      subroutine crbinPortion(r, xin, yin, d, wx, wy, wz, rbin,  n, 
     *      portion, i1, i2)
c           Suppose a (thin) layer with infinite area.
c           Suppose an origin somewhere on the layer and radial distance from the origin
c           A line segmaent with length d is given.  It's position at the surface is  xin, yin with r.
c           It's direction cosine is wx, wy, wz.
c           This program computes a portion of the line segment  contained in a given radial
c           distance bins given by rbin.  (How much portion of the line segment is in
c           rbin(1)~rbin(2), rbin(2)~rbin(3), ...
c           and put them in portion(1), portion(2),.... 
c           Nonzero part of portio(i) is informed by i=i1 to i=i2.
c               r3      r4     r5         r6           r7
c               |   r   |      |           |            | 
c             ---------------------------------------
c                    \
c                     \
c                      \ 
c                       \
c                        \
c                         \
c                          \  
c                           \   
c                            \
c                             \
c                              \
c                               \
c           In the above example,   portion(3), portion(4) and portion(5)
c            will get non zero values.
      implicit none
      real*8  r  !  input.  a value >= 0.
      real*8  xin, yin
      real*8  d  !  input.  length of the segment
      real*8  wx, wy, wz  !  input.  direction cosines. wz>=0 is assumed.
      integer n           !  input. bin size
      real*8  rbin(n)     !  input. bin values. r(1)=0 is assumed.
      real*8  portion(n)  !  output. 
      integer i1, i2      !  output. 
c
      integer i, j, i0
      integer icon
      real*8  r1, r2, el
      real*8  h, x0, y0, z0

      i1 = 0
      i2 = -10
      
      do i = 1, n
         portion(i) = 0
      enddo
c
      do i = 1, n
         if(r .le. rbin(i)) then
            j = i
c           r(j-1)     r(j) 
c             |--------|-------
c                   |
c                   r
c
            goto 10
         endif
      enddo
c        we disregard if r is very far, (even the line is directed
c        towards inner part and passes through some of the pipes
      return  !  *********
 10   continue
      x0 = xin
      y0 = yin
      z0 = 0.
      h = d*wz
c   ************* examine inner pipes
      do i = j, 2, -1
         r1 = rbin(i-1)
         r2 = rbin(i)
c           crossing point with inner pipe.
         call cxppipe(x0, y0, z0, wx, wy, wz, r1, r2,  h,  el,
     *        icon)
c     el: x-ssing point is at (x0,y0,z0)+el*(l,m,n)  el>=0
c   icon : output. 0 the point is at inner wall
c                  1 the point is at outer wall
c                  2 the point is at bottom
c                  3 the point is at top
c                 -1 no poit. 
         i0 =i-1    !  i0 >=1
         if(i1 .eq. 0) i1 = i0   ! first time i1 = i0
         i1 = min(i1, i0)        ! i1= i0 at first
         if(i2  .eq. -1) i2 = i0   !  i2 = i0 at first
         i2 = max(i2, i0)          
         portion(i0) = portion(i0) +  el/d   
         el = el*1.00000001d0
         x0 = x0 + el*wx      ! moved point
         y0 = y0 + el*wy
c         z0 = z0 + el*wz
         h = h - el*wz
         if(icon .ne. 0) goto 30  ! first outer space is current i
      enddo         
      i = j        !    first outer pipe is r(i)~ r(i+1)
 30   continue
      if(icon .ge. 2) return   !  ptcl goes bottom or top
      do j = i+1, n
c           crossing point with outer pipe.
         r1 = rbin(j-1)
         r2 = rbin(j)
         call cxppipe(x0, y0, z0, wx, wy, wz, r1, r2,  h,  el,
     *        icon)

c     el: x-ssing point is at (x0,y0,z0)+el*(l,m,n)  el>=0
c   icon : output. 0 the point is at inner wall
c                  1 the point is at outer wall
c                  2 the point is at bottom
c                  3 the point is at top
         i2 = max(i2, j-1)
         portion(j-1) = portion(j-1) +  el/d
         if(icon .ne. 1) return    !  *************
         el = el*1.000001d0
         x0 = x0 + el*wx
         y0 = y0 + el*wy
c         z0 = z0 + el*wz
         h = h - el*wz
      enddo
      end

         
