c This is exactly the same as in Epics/prog/KKlib/kklib.f
c       ****************************************************************
c       *
c       *  kxplcy: crossing point of a line with a cylinder
c       *
c       ************************ tested 89.09.06 ***********************
c
c  call kxplcy(x0, y0, z0, l, m, n, r, h,  el,
c                icon, icon2)
c  input:
c     x0,y0,z0:  a point the line passes, real*8
c     l, m, n: (real)  direction cos of the line, real*8
c     r: radius of cylinder. real*8
c     h: height of //     bottom is assumed to be on z=0
c                         axis is assumed to be z- axis
c                         top is assumed to be z=h  real*8
c  output:
c     el: x-ssing point is at (x0,y0,z0)+el*(l,m,n)  el>=0
c         only x-ssing point with el>=0 is obtained.
c         if there is two el>=0 xssing points, nearer one is
c         taken.
c   icon: index to show the side of the crossing point
c         0---> no crossing point
c         1---> crossing point is on x-y top plane
c         6---> //                          bottom
c         2---> //                 is on side
c   icon2: 0---> point is inner part of or on the cylinder
c          1---> //       outer part of the cylinder
c--------------- below; newer one
c   icon : output. 0 the point is in the cyl. el is obtained
c                  1 the point is out side of the cyl. el is
c                     obtained.
c                 -1 no x-ing point
c   icon2: output. 1  x-ing point is on x-y  top plane.
c                  2  //             on the side.
c                  6  //             on      bottom.
c                 -1  no x-ing point
c
c   ****** note ******
c          this is designed to be fast if the x-ssing point is
c          at the top or bottom of the cylinder.
c
       subroutine  kxplcy(x0, y0, z0, l, m, n,
     *         r, h,  el, icon, icon2)
       implicit none
c
       real*8 x0,y0,z0, l, m, n, el, r, h
       integer*4 icon, icon2
c
       real*8  d, wxy, x0y0, rsq, x, y, b1, ds, z
c
           rsq=r**2
           x0y0=x0**2+ y0**2 - rsq
           if(z0 .ge. 0. .and.  z0 .le. h  .and.  x0y0 .le. 0.d0) then
c                 icon2=0
               icon =0
           else
c               icon2=1
               icon =  -1   ! at least outside. may be changed later
           endif
c           icon=0
           icon2 = -1
c           if(n .gt. 0.d0 .and. icon2 .eq. 0) then
           if(n .gt. 0.d0 .and. icon .eq. 0) then
               el=(h-z0)/n
               x=x0+ el*l
               y=y0+ el*m
               if(x**2 + y**2 .le. rsq) then
c                   icon=1
                  icon2 = 1
               endif
c           elseif(n .lt. 0.d0 .and. icon2 .eq. 0) then
           elseif(n .lt. 0.d0 .and. icon .eq. 0) then
               el=-z0/n
               x=x0+ el*l
               y=y0+ el*m
               if(x**2 + y**2 .le. rsq) then
c                   icon=6
                  icon2 = 6
               endif
           endif
c           if(icon .eq. 0) then
           if(icon2 .eq. -1) then
              wxy=l**2 + m**2
              if(wxy .eq. 0.) then
c                  vertical. from outside
                 if(z0 .lt. 0. .and. n .gt. 0. .and.
     *               x0y0 .le. 0.) then
c                    icon = 6
                    icon = 1
                    icon2= 6
                    el = -z0
                 elseif(z0 .gt. h .and. n .le. 0. .and.
     *               x0y0 .le. 0.) then
c                    icon = 1
                    icon2 = 1
                    icon = 1
                    el = (h-z0)/n
                 endif
              endif
           endif
c           if(icon .eq. 0 .and. wxy .ne. 0.) then
           if(icon2 .eq. -1 .and. wxy .ne. 0.) then
              b1=l*x0+m*y0
              d= b1**2 - wxy* x0y0

              if(d .ge. 0.d0)then
                 ds=sqrt(d)
                 if(x0y0 .le. 0.d0) then
c                       point is inner part of cylinder
                     el=  (-b1 + ds)/wxy
                     z=z0+el*n
                     if(z0 .ge. 0. .and. z0 .le. h) then
c                        icon=2
                        icon = 0
                        icon2 = 2
                     elseif(z0 .gt. h .and. n .lt. 0.d0) then
                        el=(h-z0)/n
                        x=x0+el*l
                        y=y0+el*m
                        if(x**2+ y**2 .le. rsq) then
c                           icon=1
                           icon = 1
                           icon2 = 1
                        endif
                     elseif(z0 .lt. 0.d0 .and. n .gt. 0.d0) then
                        el=-z0/n
                        x=x0+el*l
                        y=y0+el*m
                        if(x**2+ y**2 .le. rsq) then
c                           icon=6
                           icon =  1
                           icon2 = 6
                        endif
                     endif
                 elseif(b1 .le. 0.) then
c                       point is outside.  x-ssing forward with cyl
                      el=  (-b1- ds)/wxy
                      z=z0+el*n
                      if(z .ge. 0. .and. z .le. h) then
c                         icon=2
                         icon = 1
                         icon2 = 2
                      elseif(n .lt. 0.d0) then
                         el=(h-z0)/n
                         x=x0+el*l
                         y=y0+el*m
                         if(x**2+ y**2 .le. rsq) then
c                            icon=1
                            icon = 1
                            icon2 = 1
                         endif
                      elseif(n .gt. 0.d0) then
                         el=-z0/n
                         x=x0+el*l
                         y=y0+el*m
                         if(x**2+ y**2 .le. rsq) then
c                            icon=6
                            icon = 1
                            icon2 = 6
                         endif
                      endif
                 endif
             endif
           endif
       end
