      subroutine ciniTracking( incident )
c          this is called after primary is fixed.
      implicit none

#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Ztrackp.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include "Zatmos.h"
#include "Zincidentv.h"
#include "Zearth.h"

      external cxyz2prim, cxyz2det
      integer klena, leng, icon
      real*8  zAngleSave, r1, r2, cosx, lengx
      real*8 clenbetween2h, cnewcos
      character*80 tracefile
      record /track/ incident
      record /coord / xyz
      integer i
      data zAngleSave/-1.d30/
      save zAngleSave
      

      Zfirst.pos.depth = 0.
      Zsave = -1.d30
#if LABELING > 0
      Labelcounter = 0
#endif
c 
      if(Job .eq. 'flesh') then
         call csetEmin(Generate2, KEminObs2, KEmin2, KEminCas2)
         call csetEmin(Generate, KEminObs, KEmin, KEminCas)
      else
         call csetEmin(Generate, KEminObs, KEmin, KEminCas)
         KEmin2 = KEmin
         KEminCas2 = KEminCas
      endif


      call cprimxyz   ! compute primary x,y,z axis in 'xyz' system
      if((Trace .gt. 0 .and. Trace .lt. 60) .or. 
     *    (Trace .gt. 100 .and. Trace .lt. 160) ) then
c            default trace output is requested. Open disk file
         write(tracefile, *) TraceDir(1:klena(TraceDir))//'/trace',
     *         EventNo
         call kseblk(tracefile, ' ', leng)
         call copenfw(TraceDev, tracefile(1:leng), icon)
         if(icon .ne. 0) then
            call cerrorMsg('tracefile couldnot be opened',0)
         endif
      elseif(Trace .gt. 60 .and. Trace .lt. 100 .or.
     *       Trace .gt. 160 .and. Trace .lt. 200) then
         call cputCerenkovS     ! cerenkov output header for each event
      endif
c
      call ciniASObs
      if(abs(ObsPlane) .eq. horizontal  .or. 
     *        ObsPlane .eq. spherical) then
         call csetObsZ(cxyz2det)
      elseif(abs(ObsPlane) .eq. perpendicular ) then
         call csetObsZ(cxyz2prim)
c          inicident.where can be fixed here. not  in cmkIncidnt
         call cxyz2prim(ObsSites(NoOfSites).pos.xyz, 
     *                  incident.pos.xyz, xyz)         
         do i = 1, NoOfSites
            if(xyz.r(3) .gt. ObsSites(i).zpl ) then
               incident.where = i
               goto 222
            endif
         enddo
         incident.where = NoOfSites + 1
         IncidentCopy.where = incident.where
 222     continue
      elseif(ObsPlane .eq.  notUsed ) then
c           Nothing to do. observation is at height =
c           BorderHeighL. (for neutrino)
      else
         call cerrorMsg('ObsPlane value is wrong', 0)
      endif
c         check some parameters
      call  cexamParam
c         if one dimensional and large angle, use table method
c         for lenth <--> thickness conversion.  make table for that
      UseTbl = OneDim .eq. 3 .or.
     *  ( OneDim .eq. 2  .and. 
     *    abs( AngleAtObsCopy.r(3) ) .lt. 0.5 )
      UseTbl = UseTbl .and.  .not. Upgoing
      if(UseTbl .and. zAngleSave .ne. AngleAtObsCopy.r(3) ) then
         Hbase = HeightList(NoOfSites) - 0.3d0  ! make little bit smaller
         Htop =100.d3   ! old value was 30d3
         r1 = Htop + Eradius
         r2 = Hbase + Eradius
         lengx = clenbetween2h(r2, r1, -AngleAtObsCopy.r(3))
         cosx = cnewcos(r2, -AngleAtObsCopy.r(3), lengx)
         call cl2tTbl(Htop, Hbase, cosx, -AngleAtObsCopy.r(3),
     *     LenStep, 
     *     LenTbl, HeightTbl, CosTbl,  ThickTbl, maxl2t, NumStep)
         zAngleSave = AngleAtObsCopy.r(3)
      endif
c          fix B at the starting point
      if( HowGeomag .le. 2 .or. HowGeomag .eq. 31 ) then
         call cgeomag(YearOfGeomag, incident.pos.xyz, Mag, icon)
         call ctransMagTo('xyz', incident.pos.xyz,  Mag, Mag)
      else
         Mag = MagfieldXYZ
      endif

      end
c     --------- compute primary system, x,y,z.  
c               The deepest detector is the reference.
      subroutine cprimxyz
      implicit none
#include "Ztrack.h"
#include "Zincidentv.h"
#include "Zobs.h"
#include "Zobsv.h"
c           all are unit vector in 'xyz' system.
c
c        X = Z x V  ( Z  is primary direction; V is vertical axis )
c          =  V x(-Z)
c          =  V x DcAtObsXyz = DetZaxis.r(1) DcAtObsXyz
c        Y = Z x X  = X x (-Z)
c          = X x DcAtObsXyz
c              
c      compute Xprimary, Yprimary, Zprimary in 'xyz' system.

      real*8  temp
c      
      Zprimary.r(1) = - DcAtObsXyz.r(1)
      Zprimary.r(2) = - DcAtObsXyz.r(2)
      Zprimary.r(3) = - DcAtObsXyz.r(3)
      call cvecProd(Zprimary, DetZaxis, Xprimary)
c         see if Zprimary // DetZaxis; if so reset Xprimary
      temp= Xprimary.r(1)**2 + Xprimary.r(2)**2 + Xprimary.r(3)**2
      if(temp .lt. 1.e-12) then
         Xprimary = DetXaxis
      else
         temp =sqrt(temp)
         Xprimary.r(1) = Xprimary.r(1)/temp
         Xprimary.r(2) = Xprimary.r(2)/temp
         Xprimary.r(3) = Xprimary.r(3)/temp
      endif
      call cvecProd(Zprimary, Xprimary, Yprimary)
      end
c     ******************************
      subroutine csetObsZ(converter)
c     *****************************
c      compute Z of observation plane 
c      
      implicit none
#include "Zcoord.h"
#include "Zpos.h"
#include "Zmagfield.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"

      external converter  ! cxyz2prim or cxyz2det
c                           depending on |ObsPlane| =2, 1
c                           or  cxyz2det for ObsPlane=3
      integer i
      record /coord/ temp
c        compute z from the base detector.
      do i = 1, NoOfSites
         call converter(ObsSites(NoOfSites).pos.xyz, 
     *     ObsSites(i).pos.xyz,
     *     temp)
         ObsSites(i).zpl = temp.r(3)
      enddo
c            this is for A.S
      do i = 1, NoOfASSites
         call converter(ASObsSites(NoOfASSites).pos.xyz, 
     *     ASObsSites(i).pos.xyz,
     *     temp)
         ASObsSites(i).zpl = temp.r(3)
      enddo
      end
c      **************************
      subroutine cqFirstID(depth)
c         inquire the first interaction depth
      implicit none

#include "Ztrack.h"
#include "Ztrackv.h"
      real*8 depth   ! output. to get the first I.D
      
      depth = Zfirst.pos.depth   ! vertical depth
      end
c      **************************
      subroutine cqFirstIPI(ptrack)
c         inquire the complete first interaction point info. 
c         as a track of the primary.
      implicit none

#include "Ztrack.h"
#include "Ztrackv.h"
      record /track/ ptrack   ! output.    if ptrack.pos.depth=0.
                              !  no interaction has been occurred
      
      ptrack = Zfirst
      end

c --------------------------------
      subroutine ciniASObs
      implicit none

#include "Zcoord.h"
#include "Zpos.h"
#include "Zmagfield.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"

      integer i

      do i = 1, NoOfASSites
         ASObsSites(i).esize = 0.
         ASObsSites(i).age = 0.
      enddo
      end
c     ***********************
      subroutine  csetEmin(gen, eminob,  emin, emCas)
c     ***********************
      implicit none
#include  "Zmanagerp.h"
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"
#include  "Zheavyc.h"
#include  "Zheavyp.h"
c
      character*(*)  gen ! input. a copy of Generate. 
      real*8  eminob   !   input. minim observational energy (kientic)
      real*8  emin     !  output. Minimum energy to be followed for non e-g
                       !  ptcls.
      real*8  emCas    !  output. Minimum energy to be followed for e-g
c
c
      real*8  ergpn    ! energy / nucleon
      logical cas      ! 
      logical obas     ! 

c
      cas = index(gen, 'em') .gt. 0 
      obas = index(gen, 'as') .gt. 0 .or.
     *   index(gen, 'lat') .gt. 0


c          energy / nucleon for heavy
      if(IncidentCopy.p.code .eq. kgnuc) then
         ergpn =
     *        IncidentCopy.p.fm.p(4)/IncidentCopy.p.subcode
      elseif(IncidentCopy.p.code .ge. kalfa .and.
     *     IncidentCopy.p.code .le.  khvymax) then
c           will  not come here
         ergpn =
     *        IncidentCopy.p.fm.p(4)/Code2massN(IncidentCopy.p.code)
      else
         ergpn = IncidentCopy.p.fm.p(4)
      endif
      if(obas ) then
               ! wait until electon  energy becomes < EasWait for AS
               ! generation. WaitRatio < 1 should be used when 1ry is 
               ! g or e.   (say, 0.01)
         EasWait =ergpn * WaitRatio
      endif


      emCas = 1.d30

      if(obas) then
         emCas = EasWait
      endif
      if(cas) then
         emCas =min(eminob, emCas)
      endif
      emin = eminob
      if(obas) then
         emin = min(emin, max(RatioToE0* ergpn, 1.d0) )
      endif 

      if(ThinSampling) then
c           thin sampling
         if(EthinRatio .lt. 0.) then
            Ethin = -EthinRatio
         else
            Ethin = EthinRatio*ergpn
         endif
      else
           Ethin = 0.
      endif
      end
      subroutine cexamParam
      implicit none
#include "Ztrackp.h"
#include "Zelemagp.h"

      end
