      subroutine cinippx
      implicit none
c         initialize leading particle x sampling.
c

#include "Zcinippxc.h"

      external cinteLdndx

      integer  i, icon
      real*8 s 
      real*8 x, x1, eps, ans
      real*8 dndx(n)  ! unnormalized dn/dx of leading particle at x= 0, 0.01,,

c                      to 1.0
          data ( dndx(i), i=  1,   n)/
     1  .00,  397.12,  733.46,  976.56, 1152.32, 1280.39, 1375.47,
     2  1448.29, 1506.53, 1555.49, 1598.69, 1638.34, 1675.71, 1711.42,
     3  1745.67, 1778.41, 1809.44, 1838.55, 1865.51, 1890.16, 1912.41,
     4  1932.22, 1949.65, 1964.79, 1977.80, 1988.86, 1998.15, 2005.88,
     5  2012.24, 2017.40, 2021.51, 2024.69, 2027.03, 2028.58, 2029.38,
     6  2029.42, 2028.69, 2027.17, 2024.80, 2021.55, 2017.37, 2012.23,
     7  2006.11, 1999.00, 1990.91, 1981.86, 1971.89, 1961.08, 1949.49,
     8  1937.21, 1924.34, 1910.98, 1897.24, 1883.22, 1869.01, 1854.70,
     9  1840.36, 1826.05, 1811.80, 1797.65, 1783.60, 1769.63, 1755.74,
     a  1741.87, 1728.00, 1714.06, 1700.02, 1685.82, 1671.41, 1656.76,
     b  1641.81, 1626.55, 1610.94, 1594.94, 1578.51, 1561.61, 1544.16,
     c  1526.07, 1507.21, 1487.43, 1466.55, 1444.39, 1420.74, 1395.47,
     d  1368.55, 1340.11, 1310.58, 1280.84, 1252.41, 1227.68, 1210.29,
     e  1205.46, 1220.57, 1265.71, 1354.46, 1504.77, 1740.05, 2090.44,
     f  2594.32, 3000.00, 3250.00                                       
     * /   


        dx = 0.01d0
        eps = 1.d-4

c          integral of  dn/dx from 0 to 1. 
        call ktrpzIntegT(dndx, 1, n, 0.d0, dx, 1.d0, s)
c
c         make normalized table
c
        do i = 1, n
           ndndx(i) = dndx(i)/s
        enddo
c         make table of intgral(0:x) of ndndx. for x = 0 to 1.0 step
c         0.01
        x = 0.
        do i=2, n 
           x = x + dx
           call ktrpzIntegT(ndndx, 1, n, 0.d0, dx, x, intendndx(i) )
        enddo
        intendndx(1) = 0.
        intendndx(n) = 1.
c           solve  inte(0:x) of ndndx = u for u = 0 to 1.0 step 0.01
        x = dx
        uconst = 0.
        x1 = 0.
        do i = 2, n-1
           uconst = uconst + dx
           call kbinChop(cinteLdndx, x1, 1.d0, x, eps, ans, icon)
           if(icon .ne. 0) then
              call cerrorMsg(
     *        'failed in making leading particle sampling table', 0)
           endif
           ppsx(i) = ans        
           x = ans
           x1 = x
        enddo
        ppsx(1) = 0.
        ppsx(n) = 1.
      end
      real*8 function cinteLdndx(x)
      implicit none
      real*8 x

#include "Zcinippxc.h"

      real*8 ans

      call ktrpzIntegT(ndndx, 1, n, 0.d0, dx, x, ans)
      cinteLdndx = ans - uconst
      end

