c	real*8 a, sigma, aven, a3
c	do while(.true.)
c	    read(*, *) a, sigma
c	    if(a .eq. 0.) stop
c	    a3 = a**(1./3.)
c	    call caveNoOfSucC(a3, sigma, aven)
c	write(*, *) ' <N>=', aven
c	enddo
c	end

	subroutine caveNoOfSucC(a3, sigma,  aven)
	implicit none
c          get average number of  succesive collisions in
c          nucleus A. 
	real*8  a3   !  input. A**(1/3) of target.
	real*8 sigma  ! input. elementary cross-section in mb
	real*8  aven  ! output. average number of collisions.
c     This gives a little bit larger values than P.R D  vol32(1985) 619. 
c        Table 1.
c	 aveNoCol(i,j) is the average number of collisions inside
c        a nucleus.  j is for A**(1/3)= 4**(1/3) to 208**(1/3) with
c        .28917 step.  i is for elementry cross-section of log(15mb) 
c        to log10(300mb)  with  0.086735333 step.

	real*8 aveNoCol(16,  16)
	real*8 da/0.289172/,  a31/1.5874/
	real*8 ds/0.086735333/, xs1/1.176091259/, xs
	integer i


c   *************************
c          for A=4; xs=15mb to 300 mb with log10 step
c    The talbe for large A and large cross-seciton is not
c    good but don't worry, they will never be used.
c
          data ( aveNoCol(i,   1), i=  1,   16)/
     1  1.0979, 1.1199, 1.1467, 1.1792, 1.2184, 1.2648, 1.3183, 1.3766,
     2  1.4331, 1.4705, 1.4823, 1.4989, 1.5138, 1.5071, 1.5272, 1.5286  
     * /   
          data ( aveNoCol(i,   2), i=  1,   16)/
     1  1.2214, 1.2700, 1.3278, 1.3951, 1.4705, 1.5493, 1.6223, 1.6762,
     2  1.7038, 1.7193, 1.7303, 1.7398, 1.7516, 1.7542, 1.7652, 1.7692  
     * /   
          data ( aveNoCol(i,   3), i=  1,   16)/
     1  1.3995, 1.4823, 1.5760, 1.6758, 1.7720, 1.8504, 1.8998, 1.9245,
     2  1.9398, 1.9521, 1.9624, 1.9718, 1.9810, 1.9875, 1.9966, 2.0013  
     * /   
          data ( aveNoCol(i,   4), i=  1,   16)/
     1  1.6243, 1.7418, 1.8636, 1.9757, 2.0609, 2.1110, 2.1356, 2.1510,
     2  2.1635, 2.1746, 2.1845, 2.1940, 2.2026, 2.2107, 2.2187, 2.2253  
     * /   
          data ( aveNoCol(i,   5), i=  1,   16)/
     1  1.8464, 1.9601, 2.0522, 2.1125, 2.1440, 2.1602, 2.1715, 2.1812,
     2  2.1901, 2.1985, 2.2064, 2.2140, 2.2211, 2.2279, 2.2343, 2.2403  
     * /   
          data ( aveNoCol(i,   6), i=  1,   16)/
     1  2.1087, 2.2251, 2.3033, 2.3439, 2.3626, 2.3742, 2.3841, 2.3933,
     2  2.4021, 2.4107, 2.4189, 2.4268, 2.4344, 2.4417, 2.4485, 2.4551  
     * /   
          data ( aveNoCol(i,   7), i=  1,   16)/
     1  2.3758, 2.4805, 2.5368, 2.5605, 2.5723, 2.5817, 2.5907, 2.5996,
     2  2.6084, 2.6170, 2.6256, 2.6338, 2.6419, 2.6494, 2.6569, 2.6635  
     * /   
          data ( aveNoCol(i,   8), i=  1,   16)/
     1  2.6378, 2.7203, 2.7548, 2.7677, 2.7760, 2.7840, 2.7923, 2.8009,
     2  2.8097, 2.8185, 2.8272, 2.8358, 2.8440, 2.8521, 2.8595, 2.8669  
     * /   
          data ( aveNoCol(i,   9), i=  1,   16)/
     1  2.7423, 2.7751, 2.7854, 2.7910, 2.7968, 2.8033, 2.8104, 2.8180,
     2  2.8258, 2.8338, 2.8417, 2.8494, 2.8569, 2.8641, 2.8710, 2.8773  
     * /   
          data ( aveNoCol(i,   10), i=  1,   16)/
     1  2.9646, 2.9817, 2.9857, 2.9891, 2.9939, 2.9999, 3.0068, 3.0144,
     2  3.0224, 3.0306, 3.0387, 3.0468, 3.0546, 3.0622, 3.0692, 3.0761  
     * /   
          data ( aveNoCol(i,   11), i=  1,   16)/
     1  3.1764, 3.1815, 3.1815, 3.1833, 3.1872, 3.1927, 3.1995, 3.2070,
     2  3.2151, 3.2233, 3.2319, 3.2399, 3.2483, 3.2556, 3.2632, 3.2695  
     * /   
          data ( aveNoCol(i,   12), i=  1,   16)/
     1  3.2017, 3.1985, 3.1970, 3.1983, 3.2018, 3.2070, 3.2132, 3.2203,
     2  3.2277, 3.2355, 3.2430, 3.2508, 3.2578, 3.2650, 3.2711, 3.2773  
     * /   
          data ( aveNoCol(i,   13), i=  1,   16)/
     1  3.3976, 3.3908, 3.3878, 3.3882, 3.3912, 3.3960, 3.4022, 3.4091,
     2  3.4168, 3.4244, 3.4325, 3.4399, 3.4476, 3.4542, 3.4609, 3.4663  
     * /   
          data ( aveNoCol(i,   14), i=  1,   16)/
     1  3.5894, 3.5800, 3.5757, 3.5752, 3.5777, 3.5823, 3.5883, 3.5954,
     2  3.6030, 3.6110, 3.6190, 3.6267, 3.6344, 3.6411, 3.6478, 3.6528  
     * /   
          data ( aveNoCol(i,   15), i=  1,   16)/
     1  3.7776, 3.7662, 3.7606, 3.7594, 3.7614, 3.7658, 3.7716, 3.7788,
     2  3.7861, 3.7946, 3.8019, 3.8105, 3.8169, 3.8249, 3.8297, 3.4772  
     * /   
          data ( aveNoCol(i,   16), i=  1,   16)/
     1  3.7868, 3.7764, 3.7716, 3.7708, 3.7731, 3.7772, 3.7832, 3.7896,
     2  3.7973, 3.8042, 3.8123, 3.8187, 3.8263, 3.8314, 3.8375, 3.6628  
     * /   

	xs = log10(sigma)
	call k4ptdi(aveNoCol, 16, 16, 16, xs1,  a31,
     *  ds,  da, xs,  a3,  aven)

        end


