      function crossint(kin, ek)
      implicit real*8 (a-h,o-z)
      real*8 cpa(111),cpba(111), cpip(111),cpim(111), ckp(111),ckm(111)

      data (cpa(i),i=1,111)/
     &   0.00,   0.00,   0.00,   0.00,   0.00,   0.27,  16.92,
     &  74.76, 141.83, 199.89, 225.79, 226.03, 230.53, 238.42,
     & 242.21, 243.64, 247.04, 250.48, 252.06, 252.35, 251.93,
     & 250.92, 251.34, 253.57, 254.72, 255.32, 255.94, 255.60,
     & 255.24, 256.41, 256.61, 256.14, 257.44, 258.39, 258.68,
     & 260.14, 261.46, 262.00, 262.48, 262.21, 280.00, 282.39,
     & 284.80, 287.24, 289.69, 292.17, 294.66, 297.18, 299.72,
     & 302.28, 304.87, 307.47, 310.10, 312.75, 315.43, 318.12,
     & 320.84, 323.58, 326.35, 329.14, 331.95, 334.79, 337.65,
     & 340.53, 343.44, 346.38, 349.34, 352.33, 355.34, 358.37,
     & 361.44, 364.53, 367.64, 370.78, 373.95, 377.15, 380.37,
     & 383.62, 386.90, 390.21, 393.54, 396.91, 400.30, 403.72,
     & 407.17, 410.65, 414.16, 417.70, 421.27, 424.87, 428.50,
     & 432.16, 435.86, 439.58, 443.34, 447.13, 450.95, 454.80,
     & 458.69, 462.61, 466.57, 470.55, 474.57, 478.63, 482.72,
     & 486.85, 491.01, 495.20, 499.44, 503.71, 508.01/

c     &  0.000145,  0.000145,  0.000145,  0.000145,  0.000145,  2.253093,
c     & 14.225546, 73.309149,145.302999,202.789961,213.611941,224.686071,
c     &228.683985,230.714164,232.847940,235.529287,238.904903,243.134972,
c     &246.344967,248.830570,250.526401,251.166879,251.973194,252.988283,
c     &253.000000,253.000000,253.000000,250.544024,252.469983,254.090741,
c     &256.515314,257.027193,257.628458,258.323297,259.114879,260.005604,
c     &260.997288,262.091304,263.288692,264.590240,265.996544,267.826684,
c     &269.690849,277.088263,279.456445,281.844867,284.253703,286.683126,
c     &289.133312,291.604440,294.096687,296.610235,299.145265,301.701961,
c     &304.280509,306.881094,309.503906,312.149134,314.816970,317.507607,
c     &320.221241,322.958066,325.718283,328.502090,331.309689,334.141284,
c     &336.997080,339.877283,342.782103,345.711749,348.666433,351.646371,
c     &354.651777,357.682869,360.739867,363.822992,366.932467,370.068519,
c     &373.231373,376.421258,379.638407,382.883052,386.155428,389.455771,
c     &392.784322,396.141320,399.527010,402.941636,406.385445,409.858688,
c     &413.361616,416.894482,420.457542,424.051054,427.675279,431.330479,
c     &435.016919,438.734866,442.484588,446.266359,450.080451,453.927140,
c     &457.806706,461.719430,465.665594,469.645485,473.659390,477.707602,
c     &481.790411,485.908116,490.061013/

      data (cpba(i),i=1,111)/
     &557.681962,532.269572,508.647078,486.721307,466.402982,447.606308,
     &430.248588,414.249893,399.532789,386.022123,373.644862,362.330012,
     &352.008584,342.613618,334.080257,326.345852,319.350094,313.035150,
     &307.345806,302.229591,297.636884,293.520984,289.838159,286.547649,
     &283.611648,280.995240,278.666320,276.595481,269.703518,268.394190,
     &267.957504,267.424865,267.111293,266.996203,267.060928,267.288669,
     &267.664401,268.174752,268.807876,269.553309,275.622107,277.977759,
     &280.353543,282.749633,285.166201,287.603423,290.061475,292.540535,
     &295.040783,297.562399,300.105567,302.670471,305.257296,307.866230,
     &310.497461,313.151181,315.827581,318.526856,321.249200,323.994812,
     &326.763889,329.556632,332.373245,335.213929,338.078893,340.968342,
     &343.882486,346.821537,349.785706,352.775210,355.790264,358.831086,
     &361.897898,364.990920,368.110377,371.256496,374.429503,377.629629,
     &380.857105,384.112166,387.395046,390.705984,394.045220,397.412995,
     &400.809553,404.235141,407.690006,411.174398,414.688570,418.232777,
     &421.807276,425.412324,429.048183,432.715117,436.413391,440.143272,
     &443.905032,447.698943,451.525278,455.384317,459.276337,463.201621,
     &467.160453,471.153119,475.179910,479.241117,483.337033,487.467956,
     &491.634184,495.836020,500.073768/

      data (cpip(i),i=1,111)/
     &  0.000167,  8.447568, 19.082244, 32.470508, 49.325334, 68.779544,
     & 82.662161, 96.857012,107.921815,133.415651,163.655540,188.879829,
     &191.056698,191.211872,191.407146,191.652856,191.961988,192.335402,
     &191.134848,189.618671,187.702248,187.443089,187.116601,186.705218,
     &186.186747,185.696300,185.696300,185.708239,187.010850,188.749643,
     &189.280014,190.230084,191.320201,192.543018,193.891770,195.360216,
     &196.942605,198.641798,201.193821,203.778630,206.396647,209.048300,
     &211.734018,214.454242,223.679018,225.893160,228.148465,230.445701,
     &232.785645,235.169091,237.596850,240.069743,242.588612,245.154309,
     &247.767707,250.429691,253.081269,254.671297,256.290885,257.940584,
     &259.620952,261.332562,263.075992,264.851835,266.660694,268.503182,
     &275.594963,277.950382,280.325933,282.721786,285.138117,287.575098,
     &290.032908,292.511724,295.011726,297.533094,300.076012,302.640663,
     &305.227233,307.835910,310.466882,313.120340,315.796477,318.495486,
     &321.217562,323.962903,326.731707,329.524176,332.340511,335.180916,
     &338.045597,340.934762,343.848619,346.787380,349.751258,352.740467,
     &355.755224,358.795747,361.862256,364.954974,368.074124,371.219933,
     &374.392627,377.592438,380.819597,384.074336,387.356894,390.667506,
     &394.006412,397.373856,400.770079/

      data (cpim(i),i=1,111)/
     &156.497255,157.058434,157.763655,158.649494,163.047285,168.888252,
     &177.379832,208.406306,239.649579,254.886351,258.696224,225.348829,
     &229.943942,238.064657,234.992889,225.388987,223.363617,213.574536,
     &209.469386,207.270729,207.270728,206.857304,206.336313,205.679594,
     &204.851511,203.806902,202.488435,200.834684,199.993818,198.932997,
     &196.802809,197.084881,197.593008,198.332889,199.309392,200.526485,
     &201.987209,203.701638,206.318666,208.969316,211.654021,214.373216,
     &223.614093,225.827028,228.081104,230.377087,232.715755,235.097903,
     &237.524337,239.995883,242.513378,245.077677,247.689650,250.350183,
     &253.034645,254.623806,256.242511,257.891310,259.570763,261.281439,
     &263.023919,264.798794,266.606667,268.448150,275.525541,277.880367,
     &280.255319,282.650570,285.066291,287.502659,289.959850,292.438041,
     &294.937413,297.458146,300.000423,302.564428,305.150347,307.758367,
     &310.388676,313.041466,315.716929,318.415258,321.136648,323.881298,
     &326.649405,329.441170,332.256795,335.096485,337.960444,340.848881,
     &343.762004,346.700025,349.663157,352.651613,355.665610,358.705367,
     &361.771104,364.863043,367.981407,371.126423,374.298319,377.497324,
     &380.723669,383.977589,387.259319,390.569098,393.907163,397.273758,
     &400.669127,404.093514,407.547168/

      data (ckp(i),i=1,111)/
     &  0.000145,  9.386154, 21.202440, 36.078263, 54.805888, 75.132969,
     & 85.090062, 96.857012,102.585136,109.601306,118.161364,122.368860,
     &127.576475,134.001720,138.013064,142.334725,145.407141,149.208396,
     &151.119579,153.510505,156.497257,157.058435,157.763656,158.649496,
     &159.272286,160.049109,161.024703,162.241871,162.979845,163.906799,
     &167.886357,169.893552,171.962212,174.091977,176.282295,178.532490,
     &180.841804,183.208839,185.562589,187.946578,190.361195,192.806834,
     &195.283893,197.792776,200.333891,202.907652,205.514480,208.154798,
     &210.829038,213.537635,216.281030,225.145684,227.387093,229.670173,
     &231.995699,234.364460,236.777259,239.234915,241.738263,244.288151,
     &246.885446,249.531027,252.225794,254.134517,255.744125,257.383659,
     &259.053674,260.754737,262.487424,264.252325,266.050038,267.881173,
     &269.746351,277.157818,279.526595,281.915617,284.325057,286.755090,
     &289.205891,291.677639,294.170512,296.684691,299.220357,301.777695,
     &304.356890,306.958128,309.581599,312.227491,314.895997,317.587309,
     &320.301624,323.039136,325.800046,328.584551,331.392856,334.225161,
     &337.081674,339.962600,342.868149,345.798530,348.753957,351.734642,
     &354.740803,357.772656,360.830421,363.914320,367.024576,370.161414,
     &373.325062,376.515749,379.733705/

      data (ckm(i),i=1,111)/
     &289.629599,286.988484,261.195955,208.026231,174.222890,179.786746,
     &190.773950,207.535943,237.040018,236.382833,234.016555,231.037587,
     &227.784016,225.463811,215.771276,211.087194,205.123906,197.578381,
     &195.882736,193.738750,191.024587,189.307333,187.135571,184.385496,
     &183.779590,183.049061,182.127537,180.969829,180.089108,178.977624,
     &176.960027,177.421740,178.150853,179.145918,180.404982,181.925616,
     &183.704950,185.741875,188.128168,190.545118,192.993120,195.472572,
     &197.983878,200.527449,203.103697,205.713043,208.355913,211.032736,
     &213.743950,216.489996,225.313806,227.558341,229.844605,232.173374,
     &234.545438,236.961602,239.422685,241.929524,244.482968,247.083884,
     &249.733155,252.431680,254.255249,255.867103,257.508923,259.181266,
     &260.884701,262.619805,264.387167,266.187387,268.021075,269.888855,
     &277.336312,279.706614,282.097175,284.508167,286.939764,289.392144,
     &291.865484,294.359962,296.875760,299.413060,301.972045,304.552900,
     &307.155814,309.780974,312.428570,315.098794,317.791840,320.507902,
     &323.247178,326.009866,328.796165,331.606277,334.440407,337.298760,
     &340.181541,343.088961,346.021230,348.978559,351.961164,354.969261,
     &358.003066,361.062801,364.148686,367.260945,370.399804,373.565489,
     &376.758231,379.978259,383.225809/

      if(kin.lt.4.or.kin.gt.14) then
         crossint = 1.d-4
         return
      end if

      if(ek.lt.0.1d0) then
         crossint = 1.d-4
         return
      end if

      elk = (log10(ek) + 1.d0)*10.d0
      ie1 = int(elk)

      dle = elk - real(ie1)
      if(ie1.lt.0) then
         ie1=0
         dle=0.
         cross = 0.0
      else if(ie1.gt.109) then
         ie1 = 109
      end if
      ie1 = ie1 + 1

      if(kin.eq.4) then
         crossint = ckp(ie1)*(1.d0 - dle) + ckp(ie1+1)*dle
      else if(kin.eq.5) then
         crossint = ckm(ie1)*(1.d0 - dle) + ckm(ie1+1)*dle
      else if(kin.eq.6 .or. kin.eq.7) then
         cr1 = ckp(ie1)*(1.d0 - dle) + ckp(ie1+1)*dle
         cr2 = ckm(ie1)*(1.d0 - dle) + ckm(ie1+1)*dle
         crossint = (cr1+ cr2)/2
      else if(kin.eq.8 .or. kin.eq.10) then
         crossint = cpa(ie1)*(1.d0 - dle) + cpa(ie1+1)*dle
      else if(kin.eq.9 .or. kin.eq.11) then
         crossint = cpba(ie1)*(1.d0 - dle) + cpba(ie1+1)*dle
      else if(kin.eq.12) then
         crossint = cpip(ie1)*(1.d0 - dle) + cpip(ie1+1)*dle
      else if(kin.eq.13) then
         crossint = cpim(ie1)*(1.d0 - dle) + cpim(ie1+1)*dle
      else if(kin.eq.14) then
         cr1 = cpip(ie1)*(1.d0 - dle) + cpip(ie1+1)*dle
         cr2 = cpim(ie1)*(1.d0 - dle) + cpim(ie1+1)*dle
         crossint = (cr1+ cr2)/2
      end if
      crossint=max(crossint,1.d-4)
      end
