c      ready made tracer
c          put trace info.
c     The output x,y,z values will be those defined as follows
c      depending on the  value of "Trace" 
c
c         0       This routine is not called.
c         
c           
c        <10       x, y, z in the primary sytem
c        <20       x, y, in the primary system. z in kg/m2
c
c        <30       x, y, z in the detector system
c        <40       x, y, in the detector system. z in kg/m2
c     
c        <50       x, y, z in 'xyz' system
c        <60       x, y in 'xyz' , z in kg/m2  
c
c    Primary system:  origin is the deepest detector.
c                     Z-axis is the primary direction
c                     X-aixs is Z x  Vertical axis
c                     X-Y plane is orthgonal to the primary
c    Detector system: origin is the deepest detector.
c                     Z-axis is the vertical one
c                     X-axis is directed to the magnetic east.
c                     X-Y palne is horizontal.
c    z in kg/m2 :     Vertical depth in kg/m2  above the 
c                     deepest detector to the particle.
c
c      60< < 100    ready made Cerenkov output.
c      100< <160      chookTrace is called.
c      160< <200      chookCeren is called with Cerenkov mode.
c        
c      
      subroutine cputTrInfo
      implicit none

#include  "Ztrack.h"
#include  "Ztrackp.h"
c  #include  "Ztrackv.h"

      
      record /coord/  f, t

      logical compress/.true./
      save compress

      if(Trace .ge. 100 .and. Trace .lt. 160) then
         call chookTrace
         return    !      ******************
      endif
      if(Trace .gt. 60 .or. Trace .gt. 160) then
         call cputCerenkov   ! Cerenkov output
         return    !      *****************
      else
c               convert coord.
         call ccoordForTr(Trace, f, t)
         call cwrtTrInfo(compress, f, t)
      endif
      end
      subroutine cwrtTrInfo(compress, f, t)
      implicit none

#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zobs.h"
#include  "Zobsv.h"
      
      record /coord/  f, t

      real*8  xxx/-1.d37/, yyy/-1.d36/, zzz/1.d34/
      integer kkk/-1000/, chg/-1000/
      save xxx, yyy, zzz, kkk, chg
      logical compress
      
      if(.not. compress) then
         write(TraceDev, *) sngl(f.r(1)), sngl(f.r(2)), sngl(f.r(3)), 
     *     TrackBefMove.p.code, sngl(TrackBefMove.p.fm.p(4)),
     *     TrackBefMove.p.charge
         write(TraceDev, *) sngl(t.r(1)), sngl(t.r(2)), sngl(t.r(3)), 
     *     MovedTrack.p.code, sngl(MovedTrack.p.fm.p(4)),
     *     MovedTrack.p.charge
         write(TraceDev, *)
         write(TraceDev, *)
      else
         if(kkk .ne. MovedTrack.p.code .or. f.r(1) .ne. xxx
     *    .or. f.r(2) .ne. yyy .or. f.r(3) .ne. zzz  .or.
     *     chg .ne. MovedTrack.p.charge ) then
            if(xxx .ne. -1.d37) then
               write(TraceDev, *) 
               write(TraceDev, *) 
            endif
            write(TraceDev, *) sngl(f.r(1)), sngl(f.r(2)), sngl(f.r(3)), 
     *      TrackBefMove.p.code, sngl(TrackBefMove.p.fm.p(4)),
     *      TrackBefMove.p.charge
c^^^^^^^
c     *      ,sngl( TrackBefMove.t/3.e8)
c^^^^^^^
         endif
         write(TraceDev, *) sngl(t.r(1)), sngl(t.r(2)), sngl(t.r(3)), 
     *     MovedTrack.p.code, sngl(MovedTrack.p.fm.p(4)),
     *     MovedTrack.p.charge
c^^^^^^^
c     *    , sngl(MovedTrack.t/3.e8)
c^^^^^^^^
         xxx = t.r(1)
         yyy = t.r(2)
         zzz = t.r(3)
         kkk = MovedTrack.p.code
         chg = MovedTrack.p.charge
      endif
      end
c     ***************************************
c             convert coord for tracing.  This is called by
c          cputTrInfo and cputCerekov

      subroutine ccoordForTr(how, f, t)

      implicit none
c     ***************************************
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zobs.h"
#include  "Zobsv.h"
      
      integer how   ! input. see Trace in cputTrInfo.
      record /coord/  f, t  ! output. transformed 'from to' coord 

      if(how .le. 20) then
c              to 1ry system
         call cxyz2prim(ObsSites(NoOfSites).pos.xyz,
     *                  TrackBefMove.pos.xyz, f)
         call cxyz2prim(ObsSites(NoOfSites).pos.xyz,
     *                 MovedTrack.pos.xyz, t)
         if(how .ge. 10) then
            f.r(3) = ObsSites(NoOfSites).pos.depth 
     *            - TrackBefMove.pos.depth 
            t.r(3) = ObsSites(NoOfSites).pos.depth 
     *            - MovedTrack.pos.depth 
         endif
      elseif(how .le. 40) then
c              to detector system
         call cxyz2det(ObsSites(NoOfSites).pos.xyz, 
     *                 TrackBefMove.pos.xyz, f)
         call cxyz2det(ObsSites(NoOfSites).pos.xyz, 
     *                 MovedTrack.pos.xyz, t)
         if(how .ge. 30) then
            f.r(3) = ObsSites(NoOfSites).pos.depth 
     *            - TrackBefMove.pos.depth 
            t.r(3) = ObsSites(NoOfSites).pos.depth 
     *            - MovedTrack.pos.depth 
         endif
      elseif(how .le. 60) then
         f = TrackBefMove.pos.xyz
         t = MovedTrack.pos.xyz
         if(how .ge. 50) then
            f.r(3) = ObsSites(NoOfSites).pos.depth 
     *            - TrackBefMove.pos.depth 
            t.r(3) = ObsSites(NoOfSites).pos.depth 
     *            - MovedTrack.pos.depth 
         endif
      else
         call cerrorMsg('100>= how > 60 for ccoordForTr ', 0)
      endif
      end
