c            make one incident particle, and maka a copy of it
c       in IncientCopy.
c
      subroutine cmkIncident(incident, fin)
      implicit none
c
c     incident:  /track/.  output.   incident particl with track information.
c               copy of it is saved as 'IncidentCopy', and can be
c               inquired by call cqIncident(...)
c
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zmanagerp.h"
#include  "Zobs.h"
#include  "Zobsp.h"

      record /track/ incident
      integer fin  ! output. if 1, no more simulation
      record /coord/ angle

      integer icon
c

      icon = 1



      do while (icon .ne. 0)
c          sample energy, mass, code (mometum is not given)
         call csampPrimary(incident.p, fin)
c            DestEventNo is < 0; and cutoffed 1ry is counted, too
c           fin==1-->  all events generated
         if(fin .eq. 1) goto 10

c          If ObsPlane != spherical, fix angle at observation level
c          in detector system.'
c          If ObsPlane = spherical, do the same tentatively.
c            (in this case Za1ry == 'is' guaranteed).

         call csPrimAng(angle)
         call cmkInc(incident, angle)
#if LABELING > 0
         incident.info = 0
         incident.label = 0
#endif
c           
         if(ObsPlane .eq. spherical) then
c              reset position and angle.

            call cresetPosAng(incident)
         endif    
         if(CutOffFile .ne. ' ') then
            call cifCutOff(icon)
         else
            icon =0
         endif
         if(icon .eq. 0) then
            if(Job .ne. 'newflesh') then
c
c                  for newflesh, next is managed by chookBgEvent
c
               EventsInTheRun = EventsInTheRun + 1
               if(Job .ne. 'flesh') then
                  EventNo = EventNo + 1
               endif
            endif
            call cupdtPrimC  ! update counter for each comp.
                             ! which is not rejected. 
         elseif( DestEventNo(2) .lt. 0 ) then
            if(Job .ne. 'newflesh') then
               EventsInTheRun = EventsInTheRun + 1
               if(Job .ne. 'flesh') then
                  EventNo = EventNo + 1
               endif
            endif
         endif
      enddo

 10   continue
      end
#if defined NEXT486
#define IMAG_P dimag
#elif defined PCLinux
#define IMAG_P dimag
#else
#define IMAG_P imag
#endif
c     *********************************
      subroutine cresetPosAng(incident)
      implicit none
c      After doing tentative business for energy, angle and
c      incident position for ObsPlnae != spherical,  this is
c      is used to reset incident position and angle for
c      spherical case.
c     
c      The incident position is uniform around a point given by the
c      (Latit, Longit, HeightOfInj)=PolarInjPos.  It will be  distributed
c      within  the half opnenig angle range given by Azimuth.
c      (if it is > 180, regarded as 180.  Hence, if Azimuth=(45,90),
c      incident position will be a ring like region on  a
c      sphere.)
c      As to the zenith angle at the incident position, 
c      it is determined isotropically from CosZenith.  Azimuth is
c      not used for this purpose.  Therefore, if zenith angle >= 90,
c      we will discard such particles. Hence, Imag(CosZenith) 
c      must be > 0.
c      
c
#include  "Zglobalc.h"
#include  "Ztrack.h"  
#include  "Ztrackp.h"
#include  "Zobs.h"  
#include  "Zobsv.h"  
#include  "Zincidentp.h"

c
      record /track/ incident  ! input/output.
      record /coord/ incipos, dir1, dir2
      logical first
      real*8 len, cs, sn, sint, u, oa1, oa2

c     @@@@@@@@@@@@@For  bug correction to ObsPlane=3
      real*8 cosx, ux
c     @@@@@@@@@@@@@@

      data first/.true./
      save first
      
c         fix position 
      oa1 = real(Azimuth)
      oa2 = IMAG_P(Azimuth) 
c        if we don't use oa1, oa2 but use real(..) directly in
c        the subroutine call, Absoft compiler give always 0 for
c        oa1  
c
      cosx = 2.      ! @@@@@@@@@
      ux = 0.        ! @@@@@@@@@
      do while (cosx .gt. -ux)  !@@@@@@@@@
         if(first) then
            call cuonSphere(1, PolarInjPos.r(3), PolarInjPos.r(1),
     *           PolarInjPos.r(2), oa1, oa2,  incident.pos.xyz)
            first =.false.
         else
c               this is quicker a bit
            call cuonSphere(2, PolarInjPos.r(3), PolarInjPos.r(1),
     *      PolarInjPos.r(2),  oa1, oa2, incident.pos.xyz)
         endif
c           fix angle around zenith at incident.pos.xyz
c            convert PolarInjPos to xyz vector
         call ctransCoord2('xyz', incident.pos.xyz, incipos)
c            convert its direction to direction cos
         call c3DV2DDCos(incipos, dir1, len)
c            sample angle around dir1 (x,y axes arbitrary)
         call rndc(u)
         dir2.r(3) =  -(  (IMAG_P(CosZenith)- real(CosZenith) )*u +
     *             real(CosZenith) )    ! going down is negative
         call rndc(u)
         call kcossn(cs, sn)
         sint = sqrt(1.d0-dir2.r(3)**2)
         dir2.r(1) = - sint*cs  ! - is needed for going down ptcl.
         dir2.r(2) = - sint*sn
c         convert it to xyz system
         call ctransVectZ(dir1, dir2, incident.vec.w)
c     @@@@@@@@@@@@@@@
         call cscalerProd(incident.vec.w, dir1, cosx)
         call rndc(ux)
      enddo   
c     @@@@@@@@@@@@@@@
c                uv 5.51
      if(Reverse .ne. 0) then
c          we must revert the angle
         dir2.r(1) = -dir2.r(1)
         dir2.r(2) = -dir2.r(2)
         dir2.r(3) = -dir2.r(3)
         call ctransVectZ(dir1, dir2, incident.vec.w)
      endif

c         reset others  
      call cresetPrim2(incident)
      end
c     *******************************
      subroutine cresetPrim(incidentp, angle)
      implicit none
c        reset primary.  This is typically used by the user,
c        at chookBgEvent to reset the primary which has been
c        set by the sytem so that the user can set own primray.
c
#include  "Ztrack.h"  
      record /ptcl/ incidentp ! input. must have E, mass, charge,subcode
      record /coord/ angle  ! input. direction cos at 'det' system
c
      record /track/ inc2
      
c         inc2.p = incidentp : for IBM, we must  write as follows.
      inc2.p.charge=incidentp.charge
      inc2.p.subcode=incidentp.subcode
      inc2.p.fm.p(4) = incidentp.fm.p(4)
      inc2.p.mass = incidentp.mass
      call cmkInc(inc2, angle)
      call ciniTracking( inc2 )
      call cinitStack
      call cpush(inc2)
      end
c     *******************************
      subroutine cresetPrim2(incident)
      implicit none
c        reset primary.  This is typically used by the user,
c        at chookBgEvent to reset the primary which has been
c        set by the sytem so that the user can set own primray.
c     The difference from cresetPrim is that the parameter is
c     track, and  this is for
c     ObsPlane==spherical case where you can put very arbitrary
c     incdint injection point.
c          See cmkInc2 for what you must set for incident.
c
#include  "Ztrack.h"  
c
      record /track/ incident  ! input. you must give everything
c                                       about primary
      
      call cmkInc2(incident)
      call ciniTracking( incident ) 
      call cinitStack
      call cpush(incident)
      end
      
c     ********************************
      subroutine cmkInc(incident, angle)
      implicit none
c
#include  "Zglobalc.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
#include  "Zincidentp.h"
#include  "Zincidentv.h"
#include  "Zearth.h"
#include  "Zcode.h"
      record /track/ incident ! input/outut.
c             must have E, m, code, subcode, charge
      record /coord/ angle    ! input. must have direction cos in the det. sys.
      record /coord/ xyz
c     
c
      real*8 to100km, clenbetween2h, zenithcos, len
      integer i, j

      AngleAtObsCopy = angle
      if(Reverse .ne. 0 ) then
c           to see  cut off or to see if go out of Earth
         do i = 1, 3
            AngleAtObsCopy.r(i) =  - AngleAtObsCopy.r(i) 
         enddo
c             charge conjugate
         incident.p.charge = -incident.p.charge
         if(incident.p.code .ne. kgnuc) then
            incident.p.subcode = -incident.p.subcode
         endif
      endif
c           convert it to 'xyz' system
      call ctransVectZx(1, DetZaxis, DetXaxis, AngleAtObsCopy, 
     *    DcAtObsXyz)
c
      incident.pos.xyz.sys = 'xyz'  !  Exyz system 
c      --- fix injection point ---
c      get length from the deepest obs. place + OffsetHeight to 
c          HeightOfInj (=100 km); Normally OffsetHeight is 0.
c         if the primary is to be directed to different height
c         than the detector, make it non zero.
      zenithcos = - AngleAtObsCopy.r(3)
      if(ObsPlane .ne. spherical) then
         to100km = clenbetween2h(
     *    ObsSites(NoOfSites).pos.radiallen + OffsetHeight, 
     *    Eradius + HeightOfInj,  zenithcos )  ! we need zenith angle here
      else
c           dummy 
         to100km = 10000.
      endif 


c         primary is going upward even if Reverse = 0.
      Upgoing = Reverse .eq. 0 .and. zenithcos .lt. 0. 
     *   .and. HeightOfInj .lt. ObsSites(NoOfSites).pos.height

      if(( Reverse .eq. 0 .and. zenithcos .lt. 0. 
     *  .and.  HeightOfInj .gt. ObsSites(NoOfSites).pos.height)
     *  .or. ( Reverse .ne. 0 .and. zenithcos .gt. 0.)) then
         if(ObsPlane .ne. spherical) then
c            distance to the conjugate point
            to100km = to100km -
     *       2*(ObsSites(NoOfSites).pos.radiallen + OffsetHeight)*
     *       zenithcos
c             we should go reversed direction
            to100km = - to100km
         endif
      endif
c           injection point
      do i = 1, 3
         incident.pos.xyz.r(i) = ObsSites(NoOfSites).pos.xyz.r(i) 
     *    + Offset.r(i)  + to100km * DcAtObsXyz.r(i)
      enddo

      call csetPos(incident.pos)
      call csetDirCos(DcAtObsXyz, incident)   ! set dc and coszenith in incident
c           momentum business
      call ce2p(incident)    !  px, py, pz   from direction cos

c          set time 0
      incident.t = 0.
      incident.wgt = 1.       ! weight is 1.


      do i = 1, NoOfSites
c               correction for Perpendicular : 2004/07/19
         if( ObsPlane .eq. Perpendicular ) then
c            fixing incident.where later.
         elseif( ObsPlane .ne. NotUsed ) then
            if( HeightOfInj .gt. ObsSites(i).pos.height ) then
               incident.where = i
               goto 222
            endif
         endif
      enddo
      if(HeightOfInj .lt. BorderHeightL) then
         call cerrorMsg('Injection height is < BorderHeightL',0)
      endif
      incident.where = NoOfSites + 1
 222  continue
      if(HeightOfInj .gt. BorderHeightH) then
         call cerrorMsg('Injection height is > BorderHeightH',0)
      endif


      incident.asflag = 0
      incident.pos.colheight = Infty  ! latest nuc. collision height
      IncidentCopy = incident

c           shift the origin of detectors to be on the primary track
c           if OffsetHight=0
      if(OffsetHeight .eq. 0. .and. ObsPlane .ne. spherical) then
         if(zenithcos .ge. 0. .or. Upgoing) then
            do i = 1, NoOfSites-1
               len = clenbetween2h(
     *              ObsSites(NoOfSites).pos.radiallen, 
     *              ObsSites(i).pos.radiallen,
     *              zenithcos ) 

               do j = 1, 3
                  ObsSites(i).pos.xyz.r(j) = 
     *            ObsSites(NoOfSites).pos.xyz.r(j)
     *             + len * DcAtObsXyz.r(j)

               enddo
            enddo
            do i = 1, NoOfASSites-1
               len = clenbetween2h(
     *         ASObsSites(NoOfASSites).pos.radiallen, 
     *         ASObsSites(i).pos.radiallen,
     *         zenithcos ) 
               do j =1 , 3
                  ASObsSites(i).pos.xyz.r(j) = 
     *                ASObsSites(NoOfSites).pos.xyz.r(j)
     *                + len * DcAtObsXyz.r(j)
               enddo
            enddo
         endif
      endif
c          compute min time from  the injection point to each
c         obs level.
      if(ObsPlane .ne. spherical) then
         call csetMinTime(incident)
         if(HeightOfInj .lt. BorderHeightL) then
            call cerrorMsg('Injection height is < BorderHeightL',0)
         endif
      endif
      end
      
c     ****************************
      subroutine cmkInc2(incident)
c          this may be used when incident is ready (
c       even when   ObsPlane==spherical)
c      incident must have:
c          incident.p:   code, subcode, mass, energy
c          incident.pos: xyz.r(1), xyz.r(2), xyz.r(3) in E-xyz
c          incident.vec: w.r(1), w.r(2), w.r(3)   in E-xyz
c          incident.where:  from which height the incident particle
c                           crosses ?
c          Otheres are set here.

      implicit none
c
#include  "Zglobalc.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
#include  "Zincidentp.h"
#include  "Zincidentv.h"
#include  "Zearth.h"

      record /track/ incident ! input
c
c
      incident.pos.xyz.sys = 'xyz'  !  Exyz system 
c         
      Upgoing = .false.

      call csetPos(incident.pos)
      call cgetZenith(incident, incident.vec.coszenith)
c      call csetDirCos(DcAtObsXyz, incident)   ! above is o.k 
c           momentum business
      call ce2p(incident)    !  px, py, pz   from direction cos

c          set time 0
      incident.t = 0.
      incident.wgt = 1.       ! weight is 1.


      incident.asflag = 0
      incident.pos.colheight = Infty  ! latest nuc. collision height
      IncidentCopy = incident
      end
c     *****************************
c        compute the minimum time the light needs to reach
c        each observation level from a given radial height from
c        along the primary direction
      subroutine csetMinTime(from)
      implicit none
c
c
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
#include  "Zincidentp.h"
#include  "Zincidentv.h"
c#include  "Zearth.h"
      
      record /track/from   ! input.  track to be origin
 
      real*8 leng
c        clenbetween2h, leng
      integer i, icon

      do i = 1, NoOfSites
c         ObsSites(i).minitime =
c     *       clenbetween2h(from.pos.radiallen, 
c     *       ObsSites(i).pos.radiallen,
c     *       from.vec.coszenith)    ! actually this is in m.
         call clenbetw2h(from.pos.radiallen, 
     *       ObsSites(i).pos.radiallen, from.vec.coszenith,
     *       leng, icon)     ! actually leng is in m.
         if(icon .eq. 0) then
            ObsSites(i).minitime = leng
         else
c              icon !=0 ==> light cannot come with this angle
            ObsSites(i).minitime = 1.d10
         endif
      enddo

      from.t = 0.    ! reset time of incident track.
      end
c     *************************** inquire incident particle
      subroutine cqIncident(incident, AngleAtObs)
c     *************************** 
      implicit none
#include  "Ztrack.h"
#include  "Zincidentv.h"
      record /track/ incident
      record /coord/ AngleAtObs
      incident = IncidentCopy
      AngleAtObs = AngleAtObsCopy
      end
c     **********************************
      subroutine cuonSphere(ini, rin, teta, phi, oa1, oa2, pos)
      implicit none
#include "Zglobalc.h"
#include "Zptcl.h"
#include "Zcoord.h"
c         This is a modified version of epuonSphere in Epics
c         generate a random point uniformly distributed on the
c         surface of a sphere.  Points are distributed around
c         given polar angles (teta, phi) within a given opening angle
c        (oa1~oa2). 
c    By uniform  is meant that the points are uniformly distributed on
c    the surface of the sphere but not on a projected plane.
c
      integer ini     ! input
                      !  1-->  teta and phi are different from
                      !        previous call or this is the first call.
                      !  != 1 -->  teta, and phi are the same as
                      !        the previous call.
      real*8  rin           ! input.  radius of the sphere
      real*8  teta           ! input.  polar angle in degree
      real*8  phi            ! input.  azimutal angle in degree
      real*8  oa1            ! input.  starting half opnening angle in degree
      real*8  oa2            ! input.  ending half opnening angle in degree
      record /coord/ pos     ! output. an  obtained random point in Exyz

      record /fmom/ xyz, xyz2
      real*8  a(4, 4), b(4, 4), ba(4, 4)
      real*8  u, r
      real*8 fcos,  fsin
      save ba

      r = rin *0.999999999d0
      if(ini .eq. 1) then
         call cgetRotMat4(2, -teta*Torad, a)
         call cgetRotMat4(3, -phi*Torad, b)
         call cmultRotMat4(b, a, ba)
      endif

      call rndc(u)
      fcos = cos( min(oa2,180.d0) * Torad)
      fcos = ( cos( min(oa1,180.d0)*Torad ) - fcos) * u +  fcos
      fsin = sqrt(1.d0- fcos**2)
      call rndc(u)
      u = u*pi*2
      xyz.p(1) = r * (fsin * cos(u))
      xyz.p(2) = r * (fsin * sin(u))
      xyz.p(3) = r * fcos

      xyz.p(4) =  1. ! dummy
      call capplyRot4(ba, xyz, xyz2)
      pos.r(1) = xyz2.p(1)
      pos.r(2) = xyz2.p(2)
      pos.r(3) = xyz2.p(3)


      pos.sys = 'xyz'
      end
c       ************************* see if geomagnetic cut or not.
        subroutine cifCutOff(icon)
        implicit none
#include "Zglobalc.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zcode.h"
#include "Ztrack.h"
#include "ZrigCut.h"

         integer icon   !   output. 0 ==> not cut. 1 ==> cut.

         record /coord/ angleatOb
         record /track/ inc

         real*8 p, rig, zen, azm, theta,  prob, u

         call cqIncident(inc, angleatOb)

         if(inc.p.charge .eq. 0) then
            icon = 0
         else
            if(Rdatafmt .le. 4) then
c              angleatOb is down going ptcl's one, change sign
               angleatOb.r(1) = - angleatOb.r(1)
               angleatOb.r(2) = - angleatOb.r(2)
               angleatOb.r(3) = - angleatOb.r(3)
c                 convert to theta fai in deg
               call kdir2deg(angleatOb.r(1), angleatOb.r(2),
     *          angleatOb.r(3), theta, azm)
c
c                 azm is given from the current x-axis  (+ is counter
c                 clock wise) The x-axis is XaxisFromSouth
c                 degrees from the south in counter clockwise.
c                 convert azm so that measured from the south
c
               azm = mod(azm+ XaxisFromSouth, 360.d0)
               if(ZenValue .eq. 'cos') then
c                    table zenith is in cos
                  zen = angleatOb.r(3)
               else
                  zen = theta
               endif
            elseif(Rdatafmt .eq. 5) then
c                 in this case, azm is longitude; zen is latitude or cos(lati)
c       
c               zen =  atan2( inc.pos.xyz.z, 
c     *                sqrt(inc.pos.xyz.x**2+inc.pos.xyz.y**2) )
               zen =  atan2( inc.pos.xyz.r(3),
     *                sqrt(inc.pos.xyz.r(1)**2+inc.pos.xyz.r(2)**2) )
               if(ZenValue .eq. 'cos') then
                  zen = cos( zen-pi/2.0d0 )
               else
                  zen = zen*Todeg
               endif
c               azm = atan2(inc.pos.xyz.y, inc.pos.xyz.x)*Todeg
               azm = atan2(inc.pos.xyz.r(2), inc.pos.xyz.r(1))*Todeg
            else
               call cerrorMsg('dataformat for cut off invalid',0)
            endif

            p = sqrt(inc.p.fm.p(4)**2 - inc.p.mass**2)
            rig = p/abs(inc.p.charge)
            call crigCut(azm, zen, rig, prob)
            call rndc(u)
            if(u .lt. prob) then
               icon = 0
            else
               icon = 1
            endif
         endif
         end
