c     *****************************************************************
c     *                                                               *
c     *  cheavyInt: treats heavy particle interactions
c     *                                                               *
c     *****************************************************************
c
c  -- process --
c             1) samples fragment ptcls using fragmentation parameters
c                and determines the no. of interacting nucleons.
c             2) gives break-up angle for fragments other than interacting
c                nucleons
c             3) for interacting nucleons, calls  chAcol to make
c                multiple production.
c
        subroutine cheavyInt(pj, ia, iz,  a, ntp)
        implicit none

#include  "Zcode.h"
#include  "Zptcl.h"
#include  "Zcoord.h"
#include  "Zheavyv.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
c///////////
c        logical deb
c        common/cdebug/ deb
c//////////
c
        external cblkHeavy
c
c
c          ia: mass no. of the target
c          iz: charge of the target

        integer ia, iz, ntp
        record /ptcl/ pj, a(*)
c
c        record /coord/ dir
c        real*8  dummylen
c
c        to store heavy fragment            nucleon
        record /ptcl/ frga(maxHeavyMassN), nuc(maxHeavyMassN)

        record /ptcl/ fragA(maxHeavyMassN), intNucA(maxHeavyMassN),
     *    nonIntNucA(maxHeavyMassN)
c

        integer noOfFragments, noOfNuc, noOfInteNuc
        save  noOfFragments, noOfNuc, noOfInteNuc

        integer noOfFrag, noOfIntN, noOfNonIntN

        integer  i, n, j
c///////////////
c        integer cumev, cev
c////////////
c         /////
c         real*8 sumerg

c         call ctestOnShell(' heavy bef frag', pj)
c         sumerg = 0.
c         ////

c////////////
c        call cqEventNo(cumev, cev)
c//////////////////
        ntp=0
c
c            ** fragmentation with some nucleon interaction **
c                 sample and set fragmentation ptcls
c      noOfFragments:  heavy fragments
c      noOfNuc:  all nucleons
c      noOfInteNuc: interacting nucleons.
c
c                                          
c        if(IntModel .eq. 'int2' .and.
c     *      ( pj.code .eq. ktriton .or. pj.code .eq. kdeut) ) then
        if( ActiveMdl .eq. 'dpmjet3' .and.
     *    (pj.fm.p(4) - pj.mass)/pj.subcode .gt. 5.1) then
              !   avoid recursive call from cdpmjet
           call cdpmjet(pj, ia, iz, a, ntp)
        elseif(ActiveMdl .eq. 'gheisha' .and.
     *        pj.code .eq. kgnuc  .and. (pj.subcode .eq. 2 .or.
     *        pj.subcode .eq. 3) ) then
c                  Gheisha should be called directly
           call chAGheisha(pj, ia, iz, a, ntp)
           noOfFragments = 0
           noOfNuc = 0
           noOfInteNuc = 0
        else

              
           call csampFragments(pj, ia, frga, noOfFragments,
     *       nuc, noOfNuc, noOfInteNuc)
           if(SkipPtclGen .eq. 0) then
c                 interaction of interating nuc.
              do  i = 1, noOfInteNuc
                 j=i + noOfNuc - noOfInteNuc
                 call chAcol(nuc(j), ia, iz, a(ntp+1), n)
                 ntp=ntp+n
              enddo
c               all business so far is done in the frame where
c               z axis is the incident
c               make rotation
              call crot3mom( pj, a, ntp )
           endif
           call crot3mom( pj, nuc, noOfNuc) ! for all nucleons. see entry below

           call crot3mom( pj, frga, noOfFragments)


c               move non-interacting nucleon and fragments
           do  i = 1, noOfNuc - noOfInteNuc 
              a(ntp+1) = nuc(i)
              ntp = ntp +1
           enddo
           do  i = 1, noOfFragments
              a(ntp + 1) = frga(i)
              ntp = ntp + 1
           enddo
        endif
        return
c     ****************** inquire the fragments at heavy interation
      entry cqHvyIntF(fragA, noOfFrag)
c     ******************* 
c        note if MovedTrack.p.code is not heavy, this gives wrong result

      noOfFrag = noOfFragments
c         move fragments
      do i = 1, noOfFrag
         fragA(i) = frga(i)
      enddo
      return
c     ******************** inquire the interacting nuc.
      entry cqHvyIntIN(intNucA, noOfIntN)
c     *******************
      noOfIntN = noOfInteNuc
c        move  interacting nucleons
      do i = 1, noOfIntN
         intNucA(i) = nuc(i+noOfNuc - noOfInteNuc)
      enddo
      return
c     ******************inquire non interacting  nuc.
      entry cqHvyIntNIN(nonIntNucA,  noOfNonIntN)
c     ******************
      noOfNonIntN = noOfNuc - noOfInteNuc
c        move non-interacting nucleons
      do i = 1, noOfNonIntN
         nonIntNucA(i) = nuc(i)
      enddo
      end
c     *****************************************************************
c     *                                                               *
c     *  csampFragments: sample and set fragmentation ptcls           *
c     *                                                               *
c     *****************************************************************
c
c      /usage/  call csampFragments(pj, ia, fra, noOfFragments, 
c    *    nuc,  noOfNuc, noOfInteNuc)
c
c       1)  samples fragment ptcl one by one by referring cfptbl
c           until sum of fragment mass no. exceeds incident mass no.
c           - 3 so that no heavy ptcl can emerg more.  then the 
c           remaining ones
c           are assigned to nucleons, if any.  If the sum exceeds
c           incident mass no. during sampling, retrial is made from the
c           first.   For each sampled fragment, energy is given pro-
c           potionally to its mass.   charge, mass and kind are also
c           given according to cosmos convention.
c
c        2) fra is to store heavy fragments
c           nuc is to store all nucleons
c        3) charge of the nucleons is reset because process 1) assigns
c           only proton
c        4) samples no. of interacting nucleons
c        5) samples pt of fragments other than interacting nucleons
c           and convert it to ptx, pty
c
c      noOfFragments:  # of heavy fragments stored in fra
c      noOfNuc:       # of nucleons  stored in nuc.
c      noOfInteNuc:  # of interacting nucleons among them
c
c
        subroutine csampFragments(pj, ia,
     *       fra,  noOfFragments, nuc, noOfNuc, noOfInteNuc)
        implicit none

#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zheavyp.h"
#include  "Zheavyc.h"


        integer noOfFragments, noOfNuc, noOfInteNuc, ia
c         ia: # of target nucleons
        record /ptcl/ pj, fra(*), nuc(*)
        integer ihg, mno, mx, mn, msumf, ihgf, jcon,
     *          hchg
        real*8  epn, u
        logical first/.true./
        integer i, zfrag
c
      if(first) then
         call cmakeFragTbl
         first = .false.
      endif

      if( (pj.fm.p(4)-pj.mass)/pj.subcode .lt. 0.1) then
         fra(1) = pj
         noOfFragments = 1
         noOfNuc = 0
         noOfInteNuc = 0
         return   !   ********
      endif

c
c         get heavy group index from the incident charge  
      ihg=Charge2heavyG(pj.charge)

c          # of nucleons
c      mno=HeavyG2massN(ihg)
      mno = pj.subcode
c       z 
c      hchg=HeavyG2charge(ihg)

       hchg=pj.charge

c       t.e  energy per nucleon
      epn=pj.fm.p(4)/mno
c         margin for mass no. conservation (for first trial)
      mx = mno
      mn = mno - 3

c
c             retry if final sum of mass exceeds incident one
c      *** until loop*** 
      do while (.true.)
c            sum of mass of fragments
         msumf = 0
c            no. of heavy fragments
         noOfFragments = 0
c            no. of all nucleons 
         noOfNuc =  0
c               repeat until sum of mass becomes >= amn
c         *** until loop*** 
         do while (.true.)
            if( mno .ge. 10  .and. noOfFragments .eq. 0) then
c                   for A >= 10, first sampled fragment must be
c                   non-nucleon to avoid too many nucleons.
                  call rndc(u)
                  u=(1.-CfragmentationTbl(ihg,2))*u +
     *                  CfragmentationTbl(ihg,2)
c                     find CfragmentationTbl >= u to sample fragrment
                  call kfrge(CfragmentationTbl(ihg,1), maxHeavyG,
     *            ihg, u,  ihgf, jcon)
c                            sampled group index
            else
               call rndc(u)
c                    find FragmentaionTbl >= u to sample fragrment
               call kfrge(CfragmentationTbl(ihg,1), maxHeavyG,
     *           ihg, u,  ihgf, jcon)
            endif
c
            if(ihgf .eq. 1)then
c               count nucleon
               noOfNuc = noOfNuc + 1
c               make ptcl;  nucleon charge is reset later
               call cmkptc(knuc, regptcl,
     *          1, nuc(noOfNuc))
               nuc(noOfNuc).fm.p(4) = epn
            else
c               count fragment
               noOfFragments=noOfFragments+1
c               make ptcl; 
               call cmkptc(HeavyG2code(ihgf), regptcl,
     *          1, fra(noOfFragments))
c                 set energy
               fra(noOfFragments).fm.p(4) = HeavyG2massN(ihgf) * epn
            endif
c               count mass no.
            msumf=msumf+HeavyG2massN(ihgf)
            if  (msumf .ge. mn)
     *                      goto 50
         enddo
   50    continue
         if(msumf .le. mx) then
c           remaining ptcls should be nucleons
            do i = 1, mno - msumf
               noOfNuc = noOfNuc + 1
               call cmkptc(knuc, regptcl, 1, nuc(noOfNuc) )
c                set energy
               nuc(noOfNuc).fm.p(4) = epn
            enddo
c             get sum of fragment charge
            zfrag = 0
            do i = 1, noOfFragments
               zfrag = zfrag + fra(i).charge
            enddo
            if(zfrag .le. pj.charge) goto 100
         endif
      enddo
  100 continue
c          reset nucleon charge
      call cresetNucChg(nuc, noOfNuc, hchg - zfrag)
c
c               sample interacting nucleon no.
      call csampInteNuc(pj, ia,  noOfNuc, noOfInteNuc)

c           sample fragment mom. all frag. 
      call csampFragMom(fra,  noOfFragments)
c           sample non-interacting nuc. mom.
      call csampFragMom(nuc, noOfNuc - noOfInteNuc)
c           set interacting nuc. mom
      do   i=noOfNuc, noOfNuc - noOfInteNuc + 1, -1
         nuc(i).fm.p(1) = 0.
         nuc(i).fm.p(2) = 0.
         nuc(i).fm.p(3) = sqrt(
     *      max( nuc(i).fm.p(4)**2 - nuc(i).mass**2, 0.d0) )
      enddo
      end
c     *****************************************************************
c     *                                                               *
c     *  cresetNucChg:  reset charge of nucleons emerging from heavy *
c     *                                                               *
c     *****************************************************************
c
       subroutine cresetNucChg(nuc, noOfNuc, z)
c
       implicit none
c----       include '../../Zptcl.h'
#include  "Zptcl.h"
       integer z, noOfNuc
       record /ptcl/ nuc(noOfNuc)
c
       integer i
c
       do i = 1, z
          nuc(i).charge = 1
       enddo
       do i = z+1, noOfNuc
          nuc(i).charge = 0
       enddo
      end
c     *****************************************************************
c     *                                                               *
c     *  csampInteNuc:  sample interacting nucleon number                   *
c     *                                                               *
c     *****************************************************************
c
c        1) gets average no. of interacting nucleons
c        2) gets average no. of nucleons from heavy
c        3) using the ratio of 1)/2) and binomial distribution,
c           samples no. of interacting nucleons.

c
c                           =   =   =   =
c
      subroutine csampInteNuc(pj, ia,  noOfNuc, noOfInteNuc)

      implicit none

#include  "Zcode.h"
#include  "Zptcl.h"
#include  "Zheavyp.h"
      
      integer noOfNuc, noOfInteNuc, ia  ! ia: # of target nuc. 
      record /ptcl/ pj  ! projectile heavy
      integer ihg
      real*8  avintn, avnn
c

c                heavy group index
      ihg=Charge2heavyG(pj.charge)
c                get average no. of interacting nucleons
      call caveInteNuc(pj, ia,  avintn)
c                average no. of nucleons in fragments
      avnn = FragmentTbl(ihg, 1)
c       sample interacting nucleon number by binormial distribution
c       with prob. avintn/avnn
      call kbinom( avintn/avnn, noOfNuc, noOfInteNuc)
      end
c     *****************************************************************
c     *                                                               *
c     *  csampFragMom:  sample  px, py, pz of fragments
c     *                                                               *
c     *****************************************************************
c
c      /usage/     call csampFragMom(a, nf)
c
c        pt is sampled by gaussian type distribution and stored in
c        'a'. ptx,pty are also stored.
c
      subroutine csampFragMom( a, nf )
      implicit none

#include  "Zptcl.h"
      integer nf
      record /ptcl/ a(nf)

      integer i, nc
      real*8 pt, p, cs, sn

       do   i=1, nf
c            sample fragment pt
         nc=0
         p=sqrt( a(i).fm.p(4)**2- a(i).mass**2 )
c         *** until loop*** 
         do while (.true.)
            call csampFragPt(a(i),  pt)
            nc=nc+1
            if         (pt .lt. p .or. nc .eq. 10)
     *                      goto 10
         enddo
   10    continue
         if(nc .ge. 10) then
             pt=min(1.d-10, p)
         endif
c               set pt and pz
         a(i).fm.p(3) = sqrt(p**2-pt**2)
         call kcossn(cs, sn)
         a(i).fm.p(1) = pt*cs
         a(i).fm.p(2) = pt*sn
       enddo
      end
c     *****************************************************************
c     *                                                               *
c     *  csampFragPt:   sample fragment pt                      
c     *                                                               *
c     *****************************************************************
c
c  -- process --
c        pt is sampled by gaussian type distribution:
c           exp(- x**2) dx**2  where x= 2pt/sqrt(pi)
c
      subroutine csampFragPt(aPtcl, pt)
      implicit none

#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zheavyp.h"
      real*8  pt      ! sampled pt in GeV/c

      record /ptcl/ aPtcl
c
c
      real*8 avpt, u
c
      if(aPtcl.code .eq. knuc) then
        avpt= PtAvNonInteNuc
      else
        avpt= PtAvFrag
      endif
c
      call rndc(u)
c          note avpt is not <pt> but <pt>/sqrt(pi/2)
      pt  =  avpt *sqrt(- log(u)* 2 )
      end
c     *****************************************************************
c     *                                                               *
c     *  cmakeFragTbl:  makes fragmentation parameter table for 
c     *                 heavy ptcl frgmentation sampling              
c     *                                                               *
c     *****************************************************************
c
c        FragmentaionTbl(i,j) is assumed to have <no. of heavy of group 
c        j>  when heavy of group i fragments.  For each group i, 
c        FragmentTbl is normalized so that the sum of them
c        becomes 1 and then made to be cumulative table such that
c        CfragmentaionTbl(i,j) <= CragmentaionTbl(i,j+).
c
c

      subroutine cmakeFragTbl
      implicit none

#include  "Zcode.h"
#include  "Zheavyp.h"
#include  "Zheavyc.h"
c
      integer i, j
c
c          do below for nucleus group 1 to maxHeavyG
c
       do   i=1, maxHeavyG
c              FragmentaionTbl(i,j) containes 
c              <no. of nucleus of group j> when
c              nucleus of group i fragments  (j<=i)
c                make cumulative table
          CfragmentationTbl(i, 1) = FragmentTbl(i, 1)
          do   j=1,i-1
             CfragmentationTbl(i,j+1)=FragmentTbl(i,j+1)
     *          +CfragmentationTbl(i,j)
          enddo
c                 normalzie
          do  j=1, i  
             CfragmentationTbl(i, j) = CfragmentationTbl(i,j)/
     *          CfragmentationTbl(i,i)
          enddo
       enddo
      end
      subroutine chg2massN(hg, massnum)
      implicit none
#include "Zcode.h"
#include "Zheavyp.h"
      integer massnum, hg
      massnum = HeavyG2massN(hg)
      end
      subroutine chg2charge(hg, charge)
      implicit none
#include "Zcode.h"
#include "Zheavyp.h"
      integer charge, hg
      charge = HeavyG2charge(hg)
      end
      subroutine ccode2hvgrp(code, hg)
      implicit none
#include "Zcode.h"
#include "Zheavyp.h"
      integer code, hg
      if(code .ge. kalfa .and. code .le. kiron) then
         hg = Code2heavyG(code)
      else
         call cerrorMsg(
     *   'ccode2hvgrp should not be used for code # He ~Fe',0)
      endif
      end
      subroutine ccode2mass(code, mass)
      implicit none
#include "Zcode.h"
#include "Zheavyp.h"
#include "Zmass.h"
      integer code, hg
      real*8 mass
      if(code .ge. kalfa .and. code .le. kiron) then
         hg = Code2heavyG(code)
         mass = HeavyG2massN(hg) * (masp+masn)/2
      else
         call cerrorMsg(
     *   'ccode2mass should not be used for code # He ~Fe',0)
      endif
      end

      
