#include "ZsaveStruc.h"
c       **************************************************************
c       *
c       * cibst1:  boost a partilce into the moving system of another
c       *         particle.
c       *
c       **************************************************************
c
c /usage/  call cibst1(init, p1, p2,  po)
c
c        Suppose two particles p1, p2.
c        p2 is given in the rest system of p1 which is given in a system
c        K.
c        This boosts particle 2 into  the K system.
c        (x,y,z) axis are assumed to be parallel to that of the K.
c        If the z axis at the rest system of p1 is the direction of
c        p1, this must not be used. (Such case is muon decay where
c        polarization exits to the z-direction). use cibst1Pol
c       
c  init: integer.  Input.  If p1 is the same as the previous call to this
c        subroutine, give a value other than 1.  If p1 is different
c        from the previous call, use 1. 
c    p1: structure /ptcl/. Input. particle 1
c    p2:  structure /ptcl/. Input. particle 2
c    po:  structure /ptcl/. Output. particle seen at K
c        po may be  the same one as p2
c
       subroutine cibst1(init, p1, p2, po)
         implicit none
c----         include '../Zptcl.h'
#include  "Zptcl.h"
         record /ptcl/ p1, p2, po
         integer init
c
         record /fmom/ g
#ifdef  USESAVE         
         save g
#endif
c
         if(init .eq. 1) then
            call cgetlf(p1, g)
         endif   
         po = p2

         call clorep(init, g, p2, po)

       end
#include "ZsaveStruc.h"
c       **************************************************************
c       *
c       * cibstPol:  boost a partilce into the moving system of another
c       *         particle.
c       *
c       **************************************************************
c
c /usage/  call cibstPol(init, p1, p2,  po)
c
c        Suppose two particles p1, p2.
c        p2 is given in the rest system of p1 which is given in a system
c        K.
c        This boosts particle 2 into  the K system.
c        z axis at the rest system of p1 is assumed to be the direction
c        of p1 in K.  This may be used for muon decay where polaization
c        exits.
c
c  init: integer.  Input.  If p1 is the same as the previous call to this
c        subroutine, give a value other than 1.  If p1 is different
c        from the previous call, use 1. 
c    p1: structure /ptcl/. Input. particle 1
c    p2:  structure /ptcl/. Input. particle 2
c    po:  structure /ptcl/. Output. particle seen at K
c        po may be  the same one as p2
c
       subroutine cibstPol(init, p1, p2, po)
         implicit none
c----         include '../Zptcl.h'
#include  "Zptcl.h"
         record /ptcl/ p1, p2, po
         integer init
c
         record /fmom/ g
#ifdef  USESAVE         
         save g
#endif
c
         if(init .eq. 1) then
            call cgetlf(p1, g)
         endif   
         po = p2
         call cloreb(init, g, p2, po)
       end


