c     include 'kgauss.f'
c     include 'rnd.f'
c           test kpoisn
c      do i=1, 100000
c         call kpoisn(3.5d0, n)
c         write(*,*)  n
c      enddo
c      end
c    ****************************************************************
c    *                                                              *
c    * kpoisn: Samples a poisson random variable                    *
c    *                                                              *
c    ********************** tested 86.12.18 *********************k.k*
c
c  /usage/  call kpoisn(am,  n)
c     am:  real*8. Input. The mean of the poisson distribution.
c      n:  integer output. integer.  A sampled variable.
c
c   If am >= 20, gaussian approximation is used.
c
c           subroutine needed.  rndc, kgauss.


      subroutine kpoisn(am, n)
      implicit none
      real*8 am
      integer n
c
      real*8 amsv/-1.98765d37/, ammx/20./
      real*8 avsv, psv, q, u, sqam, x
      save amsv, avsv, psv, sqam
c
      logical more
c
      if(am .lt. ammx) then
          if(amsv .ne. am) then
              avsv=am
              psv=exp(-am)
          endif
          n=-1
          q=1.
          more=.true.
          do while ( more )
              n=n+1
              call rndc(u)
              q=q*u
              more= q .ge. psv
          enddo
       else
          if(amsv .ne. am) then
              amsv=am
              sqam=sqrt(am)
          endif
          more=.true.
          do while ( more )
              call kgauss(am, sqam, x)
              n=x+.5
              more=n .lt. 0
          enddo    
       endif
       end
