c***********************************************************************
c $id: arinit.f,v 0.17 1992/03/11 14:14:59 lonnblad exp $
c**********************************************************************c
c                                                                      c
c                            a r i a d n e                             c
c                                                                      c
c           a monte carlo program for colour dipole radiation          c
c                                                                      c
c                        version 4 revision 02                         c
c                  latest date of change: 30 apr 1992                  c
c                                                                      c
c                              author :                                c
c                                                                      c
c                           leif lonnblad                              c
c                                                                      c
c                deutsches elektronen synchrotron - desy               c
c               notkestrasse 85, 2000 hamburg 50, germany              c
c                                                                      c
c                       tel  int+49-4089982048                         c
c                       fax  int+49-4089982777                         c
c                                                                      c
c                   e-mail lonnblad@apollo3.desy.de                    c
c                                                                      c
c                   copyright (c) 1992 leif lonnblad                   c
c                                                                      c
c                please report any errors to the author                c
c                                                                      c
c**********************************************************************c

c**********************************************************************c
c     this program must be loaded together with jetset 73              c
c     the model is described in nucl. phys. b306 (1988) 746,           c
c     z. phys. c43 (1989) 625, and nucl. phys. b339 (1990) 393.        c
c**********************************************************************c

c***********************************************************************
ccph:   double precision (b) used.   
ccph:.. this version of ariadne is to be used with fritiof 7.1
ccph:.. all fritiof-associated changes can be searched under "ccph"
ccph:   the role of lujets common block is replaced by 
ccph:      common /arjetx/ n,k(500,5),p(500,5),v(500,5)
ccph:  change by kk. 300 original --> 500 (=mxjtex)
ccph:.. since fritiof requires the strings to be treated one at a time,
ccph:   the original approach of having entire lujets to be treated
ccph:   by ariadne is not possible to use.  therefore this approach
ccph:   of replacing lujets by arjetx is adopted.  after emission is done,
ccph:   the partons can be copied back onto lujets in fritiof.
ccph:     
c***********************************************************************

      subroutine arinit(mode)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine initialize

c...initializes ariadne to run with other (lund) mc programs


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /ardat2/ pqmas(10)
      save /ardat2/

      common /ardat3/ iwrn(40)
      save /ardat3/

      include "Zarjetx.h"

      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/

      common /ludat2/ kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      save /ludat2/

      common /leptouC/ cut(14),lst(40),parl(30),x,y,w2,xq2,u
      save /leptouC/

      common /pyparsC/ mstp(200),parp(200),msti(200),pari(200)
      save /pyparsC/

      common /pysubsC/ msel,msub(200),kfin(2,-40:40),ckin(200)
      save /pysubsC/
      character mode*(*)


c...set output files if not already done
      if(msta(7).lt.0) msta(7)=mstu(11)
      if(msta(8).lt.0) msta(8)=mstu(11)

c...write out header
c      write(msta(7),1000)   ! c by k.k
      msta(2)=1

c...if ariadne mode, do nothing special
      if(mode(1:7).eq.'ariadne') then
        msta(1)=0

c...if jetset mode, switch off cascade and fragmentation in jetset
      elseif(mode(1:6).eq.'jetset') then
        msta(1)=1
        msta(5)=min(max(mstj(105),0),1)
        mstj(101)=5
        mstj(41)=0
        mstj(105)=0
        write(msta(7),1010)

c...if pythia mode, switch off cascades and fragmentation. check that 
c...ariadne can handle selected processes
      elseif(mode(1:6).eq.'pythia') then

        msta(1)=2
        write(msta(7),1020)
        msta(5)=min(max(mstp(111),0),1)
        mstp(61)=0
        mstp(71)=0
        mstp(111)=0

c...if lepto mode, switch off cascades and fragmentation.
      elseif(mode(1:5).eq.'lepto') then
        msta(1)=3
        write(msta(7),1030)
        lst(8)=9
        msta(5)=min(max(lst(7),0),1)
        lst(7)=0
      endif

c...set quark masses
      if(msta(24).gt.0) then
        do 100 i=1,8
          pqmas(i)=pmas(i,1)
 100    continue
      endif

      if(msta(24).ge.2) then
        do 110 i=1,5
          pqmas(i)=parf(100+i)
 110    continue
      endif

      if(msta(3).eq.1) call artune('delphi')

 1000 format(/,14x,
     $     'the lund monte carlo - ariadne version 4 revision 02',/,
     $     23x,'latest date of change: 30 apr 1992')
 1010 format(18x,'initialization done for running with jetset')
 1020 format(18x,'initialization done for running with pythia')
 1030 format(18x,'initialization done for running with lepto')


      return

c**** end of arinit ****************************************************
      end
c***********************************************************************

      block data ardata
      implicit double precision (a-h,o,p,r-z)

c...ariadne block data statements

c...initialization of the common blocks used in ariadne


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /ardat2/ pqmas(10)
      save /ardat2/

      common /ardat3/ iwrn(40)
      save /ardat3/

c...breif explanation of parameters and switches:
c...
c...
c...parameters:
c...
c...para(1) (d=0.200) lambda_qcd
c...para(2) (d=0.200) constant alpha_qcd for msta(12)=0
c...para(3) (d=1.000) cutoff in invariant p_t for qcd emission
c...para(4) (d=1/137) constant alpha_em
c...para(5) (d=1.000) cutoff in invariant p_t for em emission
c...para(6) (d=-1.00) maximum allowed invariant p_t (if >0)
c...para(7) (d=0.000) maximum invariant mass (if >0)
c...para(8-9) not used
c...para(10)(d=1.000) power in soft suppression (dimnsionality of
c...                  the extended source)
c...para(11)(d=0.938) soft suppression parameter for code 1
c...para(12)(d=0.938) soft suppression parameter for code 2
c...para(13)(d=0.938) soft suppression parameter for code 3
c...para(14-19) not used
c...para(20)(d=1.000) minimum p_t^2/q^2 of q-qbar pair in boson-gluon
c...                  fusion to be allowed to be treated as such. else
c...                  treated as sea-quark interaction. only used when
c...                  running with lepto version 6.0 or higher
c...para(21-30) not used
c...para(31)(d=1.000) maximum invariant p_t^2 for clustering three jets
c...                  into two in arclus
c...para(32-38) not used
c...para(39)(d=0.001) tolerance factor for momentum conservation
c...para(40)(d=1e32)  maximum allowed floating point number ("minimum"
c...                  is 1/para(40)
c...
c...switches:
c...
c...msta(1) (r)       ariadne mode (set by arinit) for treatment of
c...                  incomming events.
c...         0 =>      no special treatment
c...         1 =>      as if produced by jetset
c...         2 =>      as if produced by pythia
c...         3 =>      as if produced by lepto
c...msta(2) (i)       initialization done and headers written
c...msta(3) (d=0)     setting of parameters in  ariadne, jetset, 
c...                  pythia and lepto to suitable values.
c...         0 =>      off
c...         1 =>      on
c...msta(4) (i)       number of calls made to arexec
c...msta(5) (d=0)     perform fragmentation at the end of arexec
c...         0 =>      off
c...         1 =>      on
c...                  when running with jetset, pythia or lepto this
c...                  switch is set to the value of the corresponding
c...                  switch in these programs.
c...msta(6) (d=-1)    maximum number of emission (per string) in a
c...                  arexec call (if <0 - no limit)
c...msta(7) (d=6)     file number for output (stdout) from ariadne
c...                  set to mstu(11) by arinit
c...msta(8) (d=6)     file number for error messages (stdout) from
c...                  ariadne
c...msta(9) (d=1)     debug mode
c...         0 =>      debug off
c...         1 =>      check that energy and momentum is conserved after
c...                   each call to arexec produce. warns if change
c...                   in momentum is larger a factor para(39)
c...         2 =>      as for 1 but check every emission
c...         3 =>      as for 2 but dump string to /lujets/ after each 
c...                   emission
c...msta(10)(d=5)     maximum number of warnings (of each kind) issued
c...                  by ariadne
c...msta(11)(d=0)     phase space restrictions. the maximum p_t of an 
c...                  emission is set to the p_t of the last emission
c...                  (otherwise no restrictions) for:
c...                    gluon  q-qbar  photon  emissions
c...         0 =>        yes     yes     yes
c...         1 =>        yes     yes     no
c...         2 =>        yes     no      yes
c...         3 =>        yes     no      no
c...         4 =>        no      no      no
c...msta(12)(d=1)     running alpha_qcd
c...         0 =>      off
c...         1 =>      on
c...msta(13) (r)      error experienced by ariadne in last call to 
c...                  arexecc. reset to 0 at each call to arexec
c...msta(14)(d=1)     the maximum allowed p_t is set to the minimum
c...                  invariant p_t of all gluons in an incomming
c...                  string
c...         0 =>      off
c...         1 =>      on
c...msta(15)(d=5)     number of flavours allowed in q-qbar emission
c...msta(16)(d=2)     recoil treatment
c...         0 =>      minimize p_t1^2 + p_t3^2
c...         1 =>      as for 0 but pointlike string ends takes
c...                   all recoil
c...         2=>       as for 0 but also extended string ends which
c...                   have a>0 takes full recoil
c...msta(17)(d=2)     recoil treatment for extended dipoles
c...         0 =>      no special treatment (but cf. msta(16))
c...         1 =>      emit recoil gluon (except if pointlike quark
c...                   in other dipole end for msta(16)=1)
c...         2 =>      emit recoilgluon according to new strategy
c...msta(18)(d=1)     p_t ordering of recoil gluons
c...         0 =>      off
c...         1 =>      on
c...msta(19)(d=1)     correct or quick treatment of emissions from
c...                  heavy quarks
c...         0 =>      quick
c...         1 =>      correct
c...msta(20)(d=0)     final state photon radiation
c...         0 =>      off
c...         1 =>      on
c...         2 =>      on but turned off at the first occurence of
c...                   q-qbar emission in a string.
c...msta(21)(d=0)     photon radiation when run with pythia or lepto
c...         0 =>      off
c...         1 =>      on
c...msta(22)(d=0)     transfer of recoils in drell-yan processes
c...         0 =>      off
c...         1 =>      on
c...msta(23)(i)       line number of particle to transfer recoil to 
c...                  for msta(22) > 0
c...msta(24)(d=2)     quark masses to be used in q-qbar emissions
c...         0 =>      as specified in pmas(1-8) in /ardat2/
c...         1 =>      "bare" quark masses as specified in pmas(1-8)
c...                   in /ludat2/
c...         2 =>      "constituent" quark masses as specified in 
c...                   parf(101-108) in /ludat2/
c...msta(25-29) not used
c...msta(30)(d=1)    various options for running with lepto
c...         0 =>      stuck quark point like, remnant extended with para(11)
c...         1 =>      as 0 but remnant extended with para(11)/(1-x)
c...         2 =>      as 1 bur struck quark extended with q
c...msta(31)(d=1)    mass of extended partons
c...         0 =>      set to zero for backward compatibility
c...         1 =>      keeps value given
c...msta(32-40) not used
c...
c...end of description

      data para/0.2,0.2,1.0,0.007297353,1.0,-1.0,0.0,0.0,0.0,1.0,
     $          0.938,0.938,0.938,6*0.0,1.0,
     $          10*0.0,
     $          1.0,7*0.0,0.001,1.0e32/
      data msta/0,0,0,0,0,-1,6,6,1,5,
     $          0,1,0,1,5,2,2,1,1,0,
     $          0,0,0,2,5*0,1,
     $          1,9*0/
      data pqmas/10*0.0/
      data iwrn/40*0/


c**** end of ardata ****************************************************
      end
c***********************************************************************
c $id: araddg.f,v 0.5 1992/01/31 16:14:59 lonnblad exp $

      subroutine araddg(id)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine add gluon

c...adds a gluon entry between the partons in dipole id thus creating 
c...a new dipole


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      inxt(i)=ido(ip3(i))
      iprv(i)=idi(ip1(i))


c...allocate new gluon and new dipole at postitons ipart+1 and idips+1
c...if there is space left.
      ipart=ipart+1
      idips=idips+1
      if(ipart.ge.maxpar-1) call arerrm('araddg',6,0)
      if(idips.ge.maxdip-1) call arerrm('araddg',7,0)

c...set properties of new gluon
      do 100 i=1,5
        bp(ipart,i)=0.0
 100  continue
      ifl(ipart)=21
      iex(ipart)=0
      qq(ipart)=.false.
      idi(ipart)=id
      ido(ipart)=idips

c...set properties of new dipole
      ip1(idips)=ipart
      ip3(idips)=ip3(id)
      qdone(idips)=.false.
      qem(idips)=.false.
      istr(idips)=istr(id)

c...fix pointers for old dipole
      ip3(id)=ipart
      idi(ip3(idips))=idips
      if(iprv(id).ne.0) qdone(iprv(id))=.false.
      qdone(id)=.false.
      if(inxt(idips).ne.0) qdone(inxt(idips))=.false.

      return

c**** end of araddg ****************************************************
      end
c***********************************************************************
c $id: arangl.f,v 0.2 1991/09/26 12:41:40 lonnblad exp $

      real*8 function arangl(i1,i2)
      implicit double precision (a-h,o,p,r-z)

c...ariadne function angle


c...returns the angle between paron i1 and i2


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/


      arangl=bp(i1,1)*bp(i2,1)+bp(i1,2)*bp(i2,2)+bp(i1,3)*bp(i2,3)
      bp1=sqrt(bp(i1,1)**2+bp(i1,2)**2+bp(i1,3)**2)
      bp2=sqrt(bp(i2,1)**2+bp(i2,2)**2+bp(i2,3)**2)
      arangl=acos(arangl/(bp1*bp2))

      return

c**** end of arangl ****************************************************
      end
c***********************************************************************
c $id: arbocm.f,v 0.5 1991/11/06 13:46:04 lonnblad exp $

      subroutine arbocm(id)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine boost to center of mass

c...boost the partons in dipole id to the cms of the dipole


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /arint2/ dbex,dbey,dbez,phi,the
      save /arint2/


c...calculate boostvector and boost
      i1=ip1(id)
      i3=ip3(id)
      dpe1=bp(i1,4)
      dpe3=bp(i3,4)
      dpe=dpe1+dpe3
      dpx1=bp(i1,1)
      dpx3=bp(i3,1)
      dbex=(dpx1+dpx3)/dpe
      dpy1=bp(i1,2)
      dpy3=bp(i3,2)
      dbey=(dpy1+dpy3)/dpe
      dpz1=bp(i1,3)
      dpz3=bp(i3,3)
      dbez=(dpz1+dpz3)/dpe
      call arobo2(0.0d0,0.0d0,-dbex,-dbey,-dbez,i1,i3)

c...calculate rotation angles but no need for rotation yet
      px=bp(i1,1)
      py=bp(i1,2)
      pz=bp(i1,3)
      phi=ulangl(px,py)
      the=ulangl(pz,sqrt(px**2+py**2))

      return

c**** end of arbocm ****************************************************
      end
c***********************************************************************
c $id: arcasc.f,v 0.7 1992/04/28 13:16:33 lonnblad exp $

      subroutine arcasc
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine perform dipole cascade

c...performs a colour dipole cascade on string put in the ariadne
c...event record.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/


c...calculate total momentum of strings for debugging
      if(msta(9).gt.0) call archem(1)

c...reset counter
      io=0

c...loop over all dipole to find largest possible p_t^2
 100  isel=0
      pt2max=0.0
      do 110 i=1,idips
        pt2i=argpt2(i)
        if(pt2i.gt.pt2max) then
          pt2max=pt2i
          isel=i
        endif
 110  continue

c...check that largest p_t^2 is above cuts.
      if(isel.gt.0) then
        if((qem(isel).and.pt2max.le.para(5)**2).or.
     $     ((.not.qem(isel)).and.pt2max.le.para(3)**2)) isel=0
      endif

      if(msta(6).ge.0.and.io.ge.msta(6)) isel=0

c...exit if below cuts or limit of number of emissions is reached
      if(isel.eq.0) then
        call ardump
        if(msta(9).gt.0) call archem(0)
        return
      endif

c...perform the emission
      io=io+1
      pt2lst=pt2max
      call aremit(isel)
      qdump=.false.

c...check total momentum and dump according to debug mode
      if(msta(9).gt.2) call ardump
      if(msta(9).gt.1) call archem(0)
      goto 100

c**** end of arcasc ****************************************************
      end
c***********************************************************************
c $id: archem.f,v 0.6 1992/01/31 16:14:59 lonnblad exp $

      subroutine archem(imod)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine check momentum conservation

c...checks that momentum is conserved in ariadne


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /arint3/ dptot(5)
      save /arint3/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      include "Zarjetx.h"

      dimension dtot(5)


c...reset momentum counter. include drell-yan produced particle
c...if present and check its momentum consistency.
      if(msta(23).gt.0) then
        i=msta(23)
        do 100 j=1,4
          dtot(j)=p(i,j)
 100    continue
        if(abs(p(i,4)**2-p(i,3)**2-p(i,2)**2-p(i,1)**2-p(i,5)**2)
     $         .gt.para(39)*p(i,4)**2) call arerrm('archem',10,i)
      else
        do 110 j=1,4
          dtot(j)=0.0d0
 110    continue
      endif

c...sum all partons momentum and check their momentum concistency.
      do 120 i=1,ipart
        do 130 j=1,4
          dtot(j)=dtot(j)+bp(i,j)
 130    continue
        if(abs(bp(i,4)**2-bp(i,3)**2-bp(i,2)**2-bp(i,1)**2-bp(i,5)**2)
     $       .gt.para(39)*bp(i,4)**2.and.msta(9).ge.2)
     $       call arerrm('archem',10,i+n)
 120  continue
      dtot(5)=dsqrt(dtot(4)**2-dtot(3)**2-dtot(2)**2-dtot(1)**2)

c...if imod=1 save total momentum for later use
      if(imod.eq.1) then
        do 200 j=1,5
          dptot(j)=dtot(j)
 200    continue
        return
      endif

c...if imod=1 compare total momentum with old one
      do 300 j=1,5
        if(abs(dtot(j)-dptot(j)).gt.dptot(5)*para(39))
     $       call arerrm('archem',9,0)
 300  continue

      return

c**** end of archem ****************************************************
      end
c***********************************************************************
c $id: arclus.f,v 0.7 1992/03/13 13:36:14 lonnblad exp $

      subroutine arclus(njet)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine jet clustering

c...clusters particle in the /lujets/ common block into jets according
c...the dipole clustering algorithm.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      include "Zarjetx.h"

      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/


c...reset error flag.
      msta(13)=0

c...copy all particle to be considered as jet-initiators to the end
c...of the event record.
      if(mstu(48).eq.0) call arcopj

c...the total number of jetinitiators = current number of jets.
      njet=mstu(3)
      i1=0
      i3=0

c...loop over all possible three-jets to find the three jets with
c...smallest invariant p_t^2
100   if(njet.le.max(mstu(47),2)) then
        call arordj
        return
      endif

      j1=0
      j2=0
      j3=0
      pt2min=para(31)

      do 110 i2=n+1,n+mstu(3)
        if(k(i2,5).lt.0) goto 110
        call arupdj(i2,i1,i3)
        if(v(i2,5).lt.pt2min) then
          j1=k(i2,3)
          j2=i2
          j3=k(i2,4)
          pt2min=v(i2,5)
        endif
110   continue

c...exit if smallest p_t^2 is above cutoff
      if(j1.eq.0) then
        call arordj
        return
      endif

c...else join the three jets into two and redo the procedure.
      call arjoin(j1,j2,j3)
      k(j2,5)=-1
      i1=j1
      i3=j3
      njet=njet-1

      goto 100

c**** end of arclus ****************************************************
      end
c***********************************************************************
c $id: arcopa.f,v 0.4 1992/03/13 09:02:26 lonnblad exp $

      subroutine arcopa(ij,ip,ityp)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine copy parton

c...copies a parton from position ij in /lujets/ common block to
c...position ip in /arpart/ common block.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      include "Zarjetx.h"


      do 100 i=1,5
        bp(ip,i)=p(ij,i)
 100  continue

      ifl(ip)=k(ij,2)
      iex(ip)=mod(k(ij,4),10)
      qq(ip)=(ityp.ne.2)
      ino(ip)=0
      return

c**** end of arcopa ****************************************************
      end
c***********************************************************************
c $id: arcopj.f,v 0.6 1992/02/07 16:03:59 lonnblad exp $

      subroutine arcopj
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine copy jet

c...copies particles into jet initiators in /luclus/

      include "Zarjetx.h"

      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/

      common /ludat2/ kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      save /ludat2/


c...reset jet counter
      mstu(3)=0

c...loop over all particles in the event record
      do 100 i=1,n

c...disregard all decayed particles and unknown entries
        if(k(i,1).le.0.or.k(i,1).ge.10) goto 100

c...disregard neutrinos and neutral particles according to mstu(41)
        if(mstu(41).ge.2) then
          kc=lucomp(k(i,2))
          if(kc.eq.0.or.kc.eq.12.or.kc.eq.14.or.kc.eq.16.or.kc.eq.18) 
     $      goto 100
          if(mstu(41).ge.3.and.kchg(kc,2).eq.0.and.luchge(k(i,2)).eq.0)
     $      goto 100
        endif

        if(n+mstu(3)+1.gt.mstu(4)) then
          call luerrm(11,'(arclus:) no more memory left in lujets')
          mstu(3)=-1
          return
        endif

c...tag found jet-initiator
        mstu(3)=mstu(3)+1
        ij=n+mstu(3)
        do 200 j=1,5
          p(ij,j)=p(i,j)
 200    continue
        k(ij,1)=31
        k(ij,2)=97
        k(ij,3)=0
        k(ij,4)=0
        k(ij,5)=0
        v(ij,1)=p(i,4)**2-p(i,3)**2-p(i,2)**2-p(i,1)*2
        v(ij,5)=0

 100  continue

      return

c**** end of arcopj ****************************************************
      end
c***********************************************************************
c $id: arcrdi.f,v 0.2 1991/09/26 12:42:05 lonnblad exp $

      subroutine arcrdi(id,ipa1,ipa3,is,qed)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine create dipole

c...creates a dipole from partons ipa1 and ipa3


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/


      ido(ipa1)=id
      idi(ipa3)=id
      ip1(id)=ipa1
      ip3(id)=ipa3
      istr(id)=is
      qdone(id)=.false.
      qem(id)=qed

      return

c**** end of arcrdi ****************************************************
      end
c***********************************************************************
c $id: ardump.f,v 0.5 1992/02/07 16:01:36 lonnblad exp $

      subroutine ardump
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine dump 

c...dumps the entries in /arpart/ into /lujets/


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      include "Zarjetx.h"


ccph:..............................................................
      common /ardat1/ para(40),msta(40)
      save /ardat1/
ccph:^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

      inxt(i)=ip3(ido(i))


c...tag particles in old string with pointers to cascaded string 

      do 100 i=max(1,imf),iml
        k(i,1)=k(i,1)+10
        k(i,4)=n+1
        k(i,5)=n+ipart
 100  continue

c...loop over all strings in dipole record
      do 200 is=1,istrs

c...loop over all particles in each string
        i=ipf(is)
 210    n=n+1

ccph:..............................................................
        if(n.gt.mxjetx) then
        write(msta(8),*) '**',n,'  extend arjetx in ariadne **'
        stop
        endif 
ccph:^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
        
        do 220 j=1,5
          p(n,j)=bp(i,j)
          v(n,j)=v(imf,j)
 220    continue
        k(n,2)=ifl(i)
        k(n,3)=imf
        k(n,4)=iex(i)
        k(n,5)=ino(i)
        if(i.eq.ipl(is)) then
          k(n,1)=1
        else
          k(n,1)=2
          i=inxt(i)
          goto 210
        endif
 200  continue

c...set pointers to cascaded string
      imf=n+1-ipart
      iml=n
      qdump=.true.

      return

c**** end of ardump ****************************************************
      end
c***********************************************************************
c $id: arduph.f,v 0.4 1992/02/07 16:00:36 lonnblad exp $

      subroutine arduph
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine dump photon

c...moves photon emitted by ariadne to /lujets/


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /arint3/ dptot(5)
      save /arint3/

      include "Zarjetx.h"


      n=n+1
      do 100 i=1,5
        p(n,i)=bp(ipart+1,i)
        dptot(i)=dptot(i)-bp(ipart+1,i)
        v(n,i)=v(imf,i)
 100  continue

      dptot(5)=dsqrt(dptot(4)**2-dptot(3)**2-dptot(2)**2-dptot(1)**2)

      k(n,1)=1
      k(n,2)=22
      k(n,3)=imf
      k(n,4)=0
      k(n,5)=io

      return

c**** end of arduph ****************************************************
      end
c***********************************************************************
c $id: ardyre.f,v 0.7 1992/01/31 16:14:59 lonnblad exp $

      subroutine ardyre(id,*)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine drell-yan recoil treatment

c...transfers the recoil of an emission to a drell-yan produced
c...particle if the emission and the particle are in the same
c...phase space region.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /arint2/ dbex,dbey,dbez,phi,the
      save /arint2/

      include "Zarjetx.h"

      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/


c...locate drell-yan produced particle (idy) and boost it to cms 
c...of dipole
      idy=msta(23)
      call ludbrb(idy,idy,0.0d0,0.0d0,-dbex,-dbey,-dbez)
      call ludbrb(idy,idy,0.0d0,-phi,0.0d0,0.0d0,0.0d0)
      call ludbrb(idy,idy,-the,0.0d0,0.0d0,0.0d0,0.0d0)

c...calculate p_t and y for emitted gluon and light cone momenta for
c...idy
      ptg=sqrt(pt2in(id))
      zg=sqrt((1.0-bx1(id))/(1.0-bx3(id)))
      bpdy=p(idy,4)+p(idy,3)
      bmdy=p(idy,4)-p(idy,3)

c...if gluon is 'outside' idys phase-space, exit and perform normal 
c...emission
      if(ptg.gt.bpdy*bmdy/(bmdy*zg+bpdy/zg)) then
        call ludbrb(idy,idy,the,phi,dbex,dbey,dbez)
        return
      endif

c...calculate positions of particles in imitting dipole and emitted
c...gluon
      i1=ip1(id)
      i3=ip3(id)
      call araddg(id)
      ig=ip3(id)

c...set momenta for gluon
      bpg=ptg*zg
      bmg=ptg/zg

      w=sqrt(sdip(id))
      bptot=w+bpdy
      bmtot=w+bmdy

      bet=paru(2)*rlu(idum)

      bp(ig,1)=ptg*sin(bet)
      bp(ig,2)=ptg*cos(bet)
      bp(ig,3)=0.5*(bpg-bmg)
      bp(ig,4)=0.5*(bpg+bmg)
      bp(ig,5)=0.0

c...transfer transverse recoil to idy and set new momenta for idy
      p(idy,1)=p(idy,1)-bp(ig,1)
      p(idy,2)=p(idy,2)-bp(ig,2)
      xmt2=(p(idy,1)**2+p(idy,2)**2+p(idy,5)**2)/(bpdy*bmdy)
      bpdy=bpdy*sqrt(xmt2)
      bmdy=bmdy*sqrt(xmt2)
      p(idy,3)=0.5*(bpdy-bmdy)
      p(idy,4)=0.5*(bpdy+bmdy)

      bptot=bptot-bpdy-bpg
      bmtot=bmtot-bmdy-bmg

c...set new momenta for particles in emitting dipole and exit if
c...the recoil transfer is not kinematically allowed
      y1=bp(i1,5)**2
      y3=bp(i3,5)**2

      if(bmtot.lt.1.0e-20) call arerrm('ardyre',11,0)

      bb=0.5*(bptot*bmtot+y1-y3)/bmtot
      ba=y1*bptot/bmtot

      if(bb**2-ba.lt.0.0) call arerrm('ardyre',11,0)

      bp1=bb+sqrt(bb**2-ba)

      if(bp1.le.sqrt(y1)) call arerrm('ardyre',11,0)
      bm1=y1/bp1

      bm3=bmtot-bm1

      if(bm3.le.sqrt(y3)) call arerrm('ardyre',11,0)
      bp3=y3/bm3

      bp(i1,1)=0.0
      bp(i1,2)=0.0
      bp(i1,3)=0.5*(bp1-bm1)
      bp(i1,4)=0.5*(bp1+bm1)

      bp(i3,1)=0.0
      bp(i3,2)=0.0
      bp(i3,3)=0.5*(bp3-bm3)
      bp(i3,4)=0.5*(bp3+bm3)

c...boost back all particles to original system
      call ludbrb(idy,idy,the,phi,dbex,dbey,dbez)
      call arobo3(the,phi,dbex,dbey,dbez,i1,ig,i3)

      return 1

c**** end of ardyre ****************************************************
      end
c***********************************************************************
c $id: aremit.f,v 0.12 1992/03/12 12:02:30 lonnblad exp $

      subroutine aremit(id)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine emit

c...administers the an emission from dipole id


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      inxt(i)=ido(ip3(i))


c...if fsr photon emission go a head
      if(qem(id)) then
        call arradp(id)
        return

c...if q-qbar splitting go a head
      elseif(irad(id).ne.0) then
        call arradq(id)
        return

c...if gluon emission from point-like dipole or if no p_t-ordered
c...recoil gluon, go a head
      elseif((iex(ip1(id)).eq.0.and.iex(ip3(id)).eq.0)
     $             .or.msta(18).eq.0) then
        call arradg(id,0,snr,pt21,pt23)
        return
      endif

c...if p_t-ordered recoil gluon, first save initial configuration
c...then perform trial emission
      call arstor(id,ids,is1,is3)
      call arradg(id,0,snr,pt21,pt23)

c...if no recoil gluon was produces keep trial emission
      if(snr.le.1.0) return

c...if two recoil gluons, tag the smallest one for p_t-ordering
      if(aex1(id).lt.1.0.and.aex3(id).lt.1.0) then
        inewd=3
        if(pt23.lt.pt21) then
          igr=3
          idr=inxt(inxt(id))
        else
          igr=1
          idr=id
        endif

c...if only one recoil gluon, tag it for p_t-ordering
      elseif(aex1(id).lt.1.0.and.aex3(id).ge.1.0) then
        igr=1
        idr=id
        inewd=2
      elseif(aex1(id).ge.1.0.and.aex3(id).lt.1.0) then
        igr=3
        idr=inxt(id)
        inewd=2
      endif

      idt=maxdip-1

c...calculate the p_t^2 of a possibly earlier emission in place
c...of the recoil gluon. if this p_t^2 is lower than that of the
c...recoil gluon it could not have been emitted earlier and hence
c...the recoil gluon from the trial emission is kept.
      if(igr.eq.1) then
        sy1=bp(is1,5)/sqrt(snr)
        call argqte(idt,snr,pt2in(ids)/snr,qq(is1),.false.,
     $              iex(is1),0,sy1,0.0d0)
        if(pt2in(idt).lt.pt21.and.pt21.gt.para(3)**2
     $       .and.pt21.gt.para(10+iex(is1))**2) return
      else
        sy3=bp(is3,5)/sqrt(snr)
        call argqte(idt,snr,pt2in(ids)/snr,.false.,qq(is3),
     $              0,iex(is3),0.0d0,sy3)
        if(pt2in(idt).lt.pt23.and.pt23.gt.para(3)**2
     $       .and.pt23.gt.para(10+iex(is3))**2) return
      endif

c...a gluon can be emittes in place of the recoil gluon at an earlier 
c...time. recall the initial configuration and redo the emission without
c...recoil gluon
      call arreca(id,ids,is1,is3)

      idips=idips-inewd
      ipart=ipart-inewd
      call arradg(id,igr,snref,pt21,pt23)

c...set p_t^2 for the emission in place of the recoil gluon
      ids=id
      if(igr.eq.3) then
        ids=inxt(id)
        if(inewd.eq.3) ids=inxt(ids)
      endif

      call arstor(ids,idss,iss1,iss3)
      ip1(idss)=iss1
      ip3(idss)=iss3
      call arbocm(idss)

      qdone(ids)=.true.
      sdip(ids)=armas2(iss1,iss3)
      bx1(ids)=bx1(idt)
      bx3(ids)=bx3(idt)
      aex1(ids)=aex1(idt)
      aex3(ids)=aex3(idt)
      irad(ids)=irad(idt)
      pt2in(ids)=pt2in(idt)

      call archki(ids,iok)
      if(iok.eq.0.and.pt2in(ids).gt.para(3)**2) then
        qdone(ids)=.false.
      endif

      return

c**** end of aremit ****************************************************
      end
c***********************************************************************
c $id: arerrm.f,v 0.12 1992/03/13 14:21:02 lonnblad exp $

      subroutine arerrm(sub,ierr,iline)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine error message

c...writes out an error message and optionally terminates the program


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /ardat3/ iwrn(40)
      save /ardat3/

      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/
      character sub*(*)

c...write out common message
      if(iwrn(ierr).lt.msta(10)) write(msta(8),1000) sub,ierr,msta(4)
      msta(13)=ierr
      iwrn(ierr)=iwrn(ierr)+1
      ifatal=0
      idump=0

c...check error code and write appropriate message
      if(ierr.eq.1) then
        write(msta(8),1010)
        write(msta(8),1001) iline
        ifatal=1
        idump=1
      elseif(ierr.eq.2) then
        write(msta(8),1020)
        write(msta(8),1001) iline
        ifatal=1
        idump=1
      elseif(ierr.eq.3) then
        if(iwrn(3).gt.msta(10)) return
        iwrn(3)=iwrn(3)+1
        write(msta(8),1030)
        if(iwrn(3).eq.msta(10)) then
          write(msta(8),1001) iline
          idump=1
        endif
      elseif(ierr.eq.4) then
        write(msta(8),1040)
        write(msta(8),1001) iline
        ifatal=1
        idump=1
      elseif(ierr.eq.5) then
        write(msta(8),1050)
        write(msta(8),1001) iline
        ifatal=1
        idump=1
      elseif(ierr.eq.6) then
        write(msta(8),1060) maxpar
        ifatal=1
      elseif(ierr.eq.7) then
        write(msta(8),1070) maxdip
        ifatal=1
      elseif(ierr.eq.8) then
        write(msta(8),1080) maxstr
        ifatal=1
      elseif(ierr.eq.9) then
        if(iwrn(9).gt.msta(10)) return
        write(msta(8),1090)
        if(iwrn(9).eq.msta(10)) idump=1
      elseif(ierr.eq.10) then
        if(iwrn(10).gt.msta(10)) return
        write(msta(8),1100)
      elseif(ierr.eq.11) then
        write(msta(8),1110)
        ifatal=1
        idump=1
      elseif(ierr.eq.12) then
        write(msta(8),1120)
        ifatal=1
      elseif(ierr.eq.13) then
        if(iwrn(13).gt.msta(10)) return
        write(msta(8),1130)
      elseif(ierr.eq.14) then
        write(msta(8),1140)
        ifatal=1
      elseif(ierr.eq.20) then
        if(iwrn(20).gt.msta(10)) return
        write(msta(8),1200)
      elseif(ierr.eq.21) then
        if(iwrn(21).gt.msta(10)) return
        write(msta(8),1210)
      endif

c...dump ariadne dipole record and list the event if necessary
      if(idump.gt.0) then
        if(.not.qdump) call ardump
        write(msta(8),1002)
        call lulist(2)
      endif

c...stop execution if necessary
      if(ifatal.gt.0) then
        write(msta(8),1003)
        stop 0
      endif

 1000 format('*** error found by ariadne ***'/'in routine ',a6,
     $     '. error type =',i3,'. ariadne call number:',i7)
 1001 format('line number:',i4)
 1002 format('dump of event follows:')
 1003 format('error is fatal. execution stopped.')

 1010 format('found colour-singlet particle in string.')
 1020 format('found colour-triplet particle in string.')
 1030 format('found colour-singlet particle in string.',
     $       ' will try to cope...')
 1040 format('found colour-triplet particle in purely gluonic string.')
 1050 format('inconsistent colour flow in string.')
 1060 format('maximum number of partons (',i5,') exceeded. see manual.')
 1070 format('maximum number of dipoles (',i5,') exceeded. see manual.')
 1080 format('maximum number of strings (',i5,') exceeded. see manual.')
 1090 format('four-momentum was not conserved.')
 1100 format('particle has inconsistent four-momentum. ',
     $     'will try to cope...')
 1110 format('recoil transfer for drell-yan process was not',
     $       ' kinematically allowed.')
 1120 format('arexec called before initialization with arinit.')
 1130 format('dipole has inconsistent mass. will try to cope...')
 1140 format('unphysical boost vector.',/,
     $     'try switching to double precision - see manual')
 1200 format('selected sub-process in pythia is not suported by',
     $  ' ariadne.',/,
     $  '(only processes 11,12,13,28,53,68 are currently supported)',/,
     $  'will try to continue but results may not be meaningful.')
 1210 format('too many jets. arclus not able to order jets in energy.')

      return

c**** end of arerrm ****************************************************
      end
c***********************************************************************
c $id: arexec.f,v 0.9 1992/03/13 15:34:17 lonnblad exp $

      subroutine arexec
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine execute ariadne

c...the main driver routine in ariadne.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /ardat2/ pqmas(10)
      save /ardat2/

      common /ardat3/ iwrn(40)
      save /ardat3/

      common /arint2/ dbex,dbey,dbez,phi,the
      save /arint2/

      include "Zarjetx.h"


      common /leptouC/ cut(14),lst(40),parl(30),x,y,w2,xq2,u
      save /leptouC/

      common /pyparsC/ mstp(200),parp(200),msti(200),pari(200)
      save /pyparsC/

      common /pysubsC/ msel,msub(200),kfin(2,-40:40),ckin(200)
      save /pysubsC/

      common /pyint1C/ mint(400),vint(400)
      save /pyint1C/

c...step counter
      msta(4)=msta(4)+1

c...reset error log
      msta(13)=0

c...error if arinit has not been called
      if(msta(2).eq.0) call arerrm('arexec',12,0)

c...if ariadne mode just pass event through to arpars
      if(msta(1).eq.0) then

      call arpars(1,n)

c...if jetset mode should work by just passing event on to arpars
      elseif(msta(1).eq.1) then
        call arpars(1,n)

c...if pythia mode tag extended partons etc.
      elseif(msta(1).eq.2) then

        isub=mint(1)
        if(isub.ne.11.and.isub.ne.12.and.isub.ne.13.and.
     $     isub.ne.28.and.isub.ne.53.and.isub.ne.68)
     $       call arerrm('arexec',20,0)

        ifirst=1
        ilast=n

        do 100 i=ifirst,ilast
          if(k(i,1).gt.2) goto 100
          call argtyp(i,ityp)
          if(ityp.eq.0) goto 100
          if(k(i,3).eq.1.or.k(i,3).eq.2) then
            k(i,4)=1
          else
            k(i,4)=0
          endif
 100    continue

        call arpars(ifirst,ilast)

c...if lepto mode tag extended partons
      elseif(msta(1).eq.3) then
        if(lst(24).eq.1) then

c...boost to hadronic cm to avoid precision problems
          del=(p(5,4))+(p(6,4))
          dbxl=((p(5,1))+(p(6,1)))/del
          dbyl=((p(5,2))+(p(6,2)))/del
          dbzl=((p(5,3))+(p(6,3)))/del
          call ludbrb(5,n,0.0d0,0.0d0,-dbxl,-dbyl,-dbzl)

          if(msta(30).lt.2) then
            k(5,4)=0
          else
            k(5,4)=3
            para(13)=sqrt(xq2)
          endif
          if(msta(30).eq.0) then
            k(6,4)=1
          else
            k(6,4)=2
            para(12)=para(11)/(1.0-x)
          endif
          call arpars(5,6)
          call ludbrb(5,n,0.0d0,0.0d0,dbxl,dbyl,dbzl)
        elseif(lst(24).eq.3) then

c...boost to hadronic cm to avoid precision problems
          del=(p(5,4))+(p(6,4))+(p(7,4))+(p(8,4))
          dbxl=((p(5,1))+(p(6,1))+
     $         (p(7,1))+(p(8,1)))/del
          dbyl=((p(5,2))+(p(6,2))+
     $         (p(7,2))+(p(8,2)))/del
          dbzl=((p(5,3))+(p(6,3))+
     $         (p(7,3))+(p(8,4)))/del
          call ludbrb(5,n,0.0d0, 0.0d0,-dbxl,-dbyl,-dbzl)

          if(msta(30).lt.2) then
            k(5,4)=0
          else
            k(5,4)=3
            para(13)=sqrt(xq2)
          endif
          if(msta(30).eq.0) then
            k(6,4)=1
          else
            k(6,4)=2
            para(12)=para(11)/(1.0-x)
          endif
          call arpars(5,6)
          if(msta(30).lt.2) then
            k(7,4)=0
          else
            k(7,4)=3
            para(13)=sqrt(xq2)
          endif
          if(msta(30).eq.0) then
            k(8,4)=1
          else
            k(8,4)=2
            para(12)=para(11)/(1.0-x)
          endif
          call arpars(7,8)
          call ludbrb(5,n,0.0d0,0.0d0,dbxl,dbyl,dbzl)
        endif
      endif

c...perform fragmentation if requested
      if(msta(5).eq.1) call luexec

      return

c**** end of arexec ****************************************************
      end
c***********************************************************************
c $id: argpt2.f,v 0.4 1992/04/28 13:19:22 lonnblad exp $

      real*8 function argpt2(id)
      implicit double precision (a-h,o,p,r-z)

c...ariadne function generate pt2

c...returns the p_t^2 for a possible emission from dipole id.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/


c...set invariant mass squared in the dipole and generate a p_t^2
c...with the appropriate monte carlo subroutine
      if(qem(id).and.msta(20).ge.2.and.istrs.ge.2) then
        pt2in(id)=0.0
        qdone(id)=.true.
      endif
      if(.not.qdone(id)) then
        sdip(id)=armas2(ip1(id),ip3(id))
        if(qem(id)) then
          call argqed(id)
        else
          call argqcd(id)
        endif
        qdone(id)=.true.
      endif

      argpt2=pt2in(id)

      return

c**** end of argpt2 ****************************************************
      end
c***********************************************************************
c $id: argqcd.f,v 0.12 1992/03/11 08:56:44 lonnblad exp $

      subroutine argqcd(id)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine generate pt2 for qcd emission.

c...generates a p_t^2 for a possible qcd emission from dipole id


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /ardat2/ pqmas(10)
      save /ardat2/

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/

      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/
      external arndx1,arndx2,arndx3,arndy1,arndy2,arndy3,arndy4,
     $         arvet3,arvet4,arvet5
      real*8 arndx1,arndx2,arndx3,arndy1,arndy2,arndy3,arndy4,
     $         arvet3,arvet4,arvet5


c...copy some information from dipole record
c...s     = the invariant mass squared
c...w     = total energy in dipole
c...xt2mp = maximum allowed fractional p_t^2 (x_t^2) for restricted  
c...        phase space option
c...qq1(3)= boolean variable 'is quark' for parton 1(3)
c...ne1(3)= integer determining extention of parton 1(3) (0=pointlike)
c...sy1(3)= fractional mass of parton 1(3)
      pt2in(id)=0.0
      s=sdip(id)
      if(s.le.4.0*para(3)**2) return
      w=sqrt(s)
      xt2mp=pt2lst/s
      qq1=qq(ip1(id))
      qq3=qq(ip3(id))
      ne1=iex(ip1(id))
      ne3=iex(ip3(id))
      sy1=bp(ip1(id),5)/w
      sy3=bp(ip3(id),5)/w

      goto 100

c...special entry for checking p_t-ordering of recoil gluons
      entry argqte(id,si,xt2mpi,qq1i,qq3i,ne1i,ne3i,sy1i,sy3i)
            pt2in(id)=0.0
            s=si
            if(s.le.4.0*para(3)**2) return
            w=sqrt(s)
            xt2mp=xt2mpi
            qq1=qq1i
            qq3=qq3i
            ne1=ne1i
            ne3=ne3i
            sy1=sy1i
            sy3=sy3i

 100  sy2=0.0

c...calculate maximum x_t^2 for extended dipole
      if(ne1.gt.0.and.ne3.eq.0) xt2me=((0.25*s*(para(10+ne1)**
     $                          para(10)))**(2.0/(2.0+para(10))))/s
      if(ne1.eq.0.and.ne3.gt.0) xt2me=((0.25*s*(para(10+ne3)**
     $                          para(10)))**(2.0/(2.0+para(10))))/s
      if(ne1.gt.0.and.ne3.gt.0) xt2me=((0.25*s*((para(10+ne1)*
     $           para(10+ne3))**para(10)))**(1.0/(1.0+para(10))))/s

c...xlam = scaled lambda_qcd squared
      xlam2=para(1)**2/s

c...c = colour factors etc. in cross section
      c=6.0/(4.0*paru(1))
      if(qq1.and.qq3) c=4.0/(3.0*paru(1))

c...alpha_0 for alpha_qcd = alpha_0/ln(p_t^2/lambda_qcd^2)
      alpha0=
     * 12.0*paru(1)/(33.0-2.0*max(arnofl(w,max(5,msta(15))),3.0d0))

c...set exponents in cross section
      nxp1=3
      nxp3=3
      if(qq1) nxp1=2
      if(qq3) nxp3=2

c...flavour of this emission 0 = gluon emission
      iflg=0

c...minimum x_t^2
      xt2c=para(3)**2/s

c...calculate mass dependent parameters
      call armade

c...set maximum x_t^2
      if(msta(11).lt.4) xt2m=min(xt2m,xt2mp)
      if(ne1.gt.0.or.ne3.gt.0) xt2m=min(xt2m,xt2me)

      if(xt2m.le.xt2c) then
        pt2in(id)=0.0
        return
      endif

c...set additional parameters and call the veto algorith with
c...suitable random functions
      if(msta(12).gt.0) then
c.......running alpha_qdc
        yint=2.0*log(0.5/sqrt(xlam2)+sqrt(0.25/xlam2-1.0))
        cn=1.0/(yint*c*alpha0)
        if(ne1.gt.0.or.ne3.gt.0) then
c.........extended dipole
          call armcdi(arndx1,arndy2,arvet4)
        else
c.........pointlike dipole
          call armcdi(arndx1,arndy1,arvet4)
        endif
      else
c.......constant alpha_qcd
        yint=1.0
        cn=2.0/(c*para(2))
        if(ne1.gt.0.or.ne3.gt.0) then
c.........extended dipole
          call armcdi(arndx2,arndy2,arvet3)
        else
c.........pointlike dipole
          call armcdi(arndx2,arndy1,arvet3)
        endif
      endif

c...save the generated values of p_t^2, x1, x3, a1 and a3
      pt2in(id)=xt2*s
      bx1(id)=b1
      bx3(id)=b3
      aex1(id)=ae1
      aex3(id)=ae3
      irad(id)=0

c...exit if no q-qbar emission
      if(msta(15).le.0) return
      qg1=((.not.qq1).and.ne1.eq.0)
      qg3=((.not.qq3).and.ne3.eq.0)
      if((.not.qg1).and.(.not.qg3)) return

c...colour factors and things in cross section. if g-g dipole
c...q-qbar splitting only calculated forone gluon but double
c...cross section
      c=1.0/(8.0*paru(1))
      if(qg1.and.qg3) c=c*2.0

c...parton 3 is always assumed to be split
      if(qg1) then
        sy1=sy3
        ne1=ne3
        ne3=0
      endif
c...set 'minimum' xt2 to the xt2 of the gluon emission. xt2s below that
c...are not relevant
      xt2c=max(xt2,xt2c)

c...loop over allowed flavours
      do 200 iflg=1,msta(15)

c...set mass dependent parameters
        sy2=pqmas(iflg)/w
        sy3=sy2
        call armade

c...set phase space restrictions
        if(msta(11).lt.2) xt2m=min(xt2m,xt2mp)
        if(ne1.gt.0.or.ne3.gt.0) xt2m=min(xt2m,xt2me)

c...exit if not enough energy
        if(xt2m.le.xt2c.or.ssy.ge.1.0) goto 300

c...set additional parameters and call the veto algorith with
c...suitable random functions
        yint=2.0*sqrt(s)
c.......running alpha_qcd
        if(msta(12).gt.0) then
          cn=1.0/(yint*c*alpha0)
          if(ne1.gt.0.or.ne3.gt.0) then
c...........pointlike dipole
            call armcdi(arndx1,arndy4,arvet5)
          else
c...........extended dipole
            call armcdi(arndx1,arndy3,arvet5)
          endif
        else
c.........constant alpha_qcd
          cn=2.0/(yint*c*para(2))
          cn=1.0/(yint*c*alpha0)
          if(ne1.gt.0.or.ne3.gt.0) then
c...........pointlike dipole
            call armcdi(arndx3,arndy4,arvet5)
          else
c...........extended dipole
            call armcdi(arndx3,arndy3,arvet5)
          endif
        endif

c...if generated xt2 is larger than previous xt2 accept this and save
c...the generated values of p_t^2, x1, x3, a1 and a3
        if(xt2.gt.xt2c) then
          pt2in(id)=xt2*s
          bx1(id)=b1
          bx3(id)=b3
          aex1(id)=ae1
          aex3(id)=ae3
          irad(id)=iflg
          xt2c=xt2
        endif

 200  continue

c...exit if gluon emission was chosen 
 300  if(irad(id).eq.0) return

c...select wich gluon to split
      if((.not.qg3).or.(qg1.and.rlu(idum).gt.0.5)) then
        irad(id)=-irad(id)
        b1=bx1(id)
        bx1(id)=bx3(id)
        bx3(id)=b1
        ae1=aex1(id)
        aex1(id)=aex3(id)
        aex3(id)=ae1
      endif

      return

c**** end of argqcd ****************************************************
      end
c***********************************************************************
c $id: argqed.f,v 0.10 1992/04/30 10:58:34 lonnblad exp $

      subroutine argqed(id)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine generate pt2 for qed emission

c...generates a p-t^2 for a possible qed emission from dipole id.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/

      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/
      external arndx2,arndy1,arvet1,arvet2
      real*8 arndx2,arndy1,arvet1,arvet2


c...copy information about partons in dipole (for explanation see
c...subroutine argqcd
      pt2in(id)=0.0
      s=sdip(id)
      if(s.le.4.0*para(5)**2) return
      if(msta(20).ge.2.and.istrs.ge.2) return
      w=sqrt(s)
      xt2mp=pt2lst/s
      qq1=qq(ip1(id))
      qq3=qq(ip3(id))
      ne1=iex(ip1(id))
      ne3=iex(ip3(id))

      sy1=bp(ip1(id),5)/w
      sy2=0.0
      sy3=bp(ip3(id),5)/w

      xt2c=para(5)**2/s
      nxp1=2
      nxp3=2

c...set charges of emitting quarks and set constant in cross section
      iq1=luchge(ifl(ip1(id)))
      iq3=luchge(ifl(ip3(id)))
      fqmax=max(abs(iq1),abs(iq3))
      fq1=iq1/fqmax
      fq3=iq3/fqmax
      c=(fqmax**2)/(9.0*paru(1))
      iflg=-1

c...set mass dependent parameters
      call armade

c...restrict phase space if demanded
      if(msta(11).eq.0.or.msta(11).eq.2) xt2m=min(xt2m,xt2mp)

c...set some further parameters and call the veto algorithm with
c...suitable random functions for constant alpha_em.
      yint=1.0
      cn=2.0/(c*para(4))
      call armcdi(arndx2,arndy1,arvet1)

c...save information about emission
      pt2in(id)=xt2*s
      bx1(id)=b1
      bx3(id)=b3
      aex1(id)=ae1
      aex3(id)=ae3

      return

c**** end of argqed ****************************************************
      end
c***********************************************************************
c $id: argtyp.f,v 0.3 1991/09/26 12:42:47 lonnblad exp $

      subroutine argtyp(i,ityp)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine get type of particle

c...determines the type of particle i according to ityp=2: gluon,
c...ityp=1: quark or anti-di-quark, ityp=-1: anti-quark or di-quark,
c...ityp=0: other.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      include "Zarjetx.h"


      common /ludat2/ kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      save /ludat2/


      ityp=kchg(lucomp(k(i,2)),2)*isign(1,k(i,2))

      return

c**** end of argtyp ****************************************************
      end
c***********************************************************************
c $id: aript2.f,v 0.4 1992/01/27 16:03:19 lonnblad exp $

      real*8 function aript2(i1,i2,i3)
      implicit double precision (a-h,o,p,r-z)

c...ariadne function invariant pt2


c...returns the invariant p_t^2 of three partons


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/


      aript2=(armas2(i1,i2)-(bp(i1,5)+bp(i2,5))**2)*
     $       (armas2(i2,i3)-(bp(i2,5)+bp(i3,5))**2)/
     $        armas3(i1,i2,i3)

      return

c**** end of aript2 ****************************************************
      end
c***********************************************************************
c $id: arjoin.f,v 0.6 1992/01/27 16:03:19 lonnblad exp $

      subroutine arjoin(j1,j2,j3)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine join jets

c...join three jets into two


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      include "Zarjetx.h"


      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/


c...copy jets into ariadne dipole record
      call arcopa(j1,1,1)
      call arcopa(j2,2,1)
      call arcopa(j3,3,1)

c...boost to cms of jets
c         sum E of 1,2,3
      de=bp(1,4)+bp(2,4)+bp(3,4)
c         sum Px, of 1, 2, 3  /sum E etc
      dbex=(bp(1,1)+bp(2,1)+bp(3,1))/de
      dbey=(bp(1,2)+bp(2,2)+bp(3,2))/de
      dbez=(bp(1,3)+bp(2,3)+bp(3,3))/de

      call arobo3(0.0d0,0.0d0,-dbex,-dbey,-dbez,1,2,3)

c...rotate jet 1 to z-axis and jet 2 to xz plane
      px=bp(1,1)
      py=bp(1,2)
      pz=bp(1,3)
      phi=ulangl(px,py)
      call arobo3(0.0d0,-phi,0.0d0,0.0d0,0.0d0,1,2,3)
      the=ulangl(pz,sqrt(px**2+py**2))
      call arobo3(-the,0.0d0,0.0d0,0.0d0,0.0d0,1,2,3)
      px=bp(2,1)
      py=bp(2,2)
      phi2=ulangl(px,py)
      call arobo3(0.0d0,-phi2,0.0d0,0.0d0,0.0d0,1,2,3)

c...calculate energy fractions
      be=bp(1,4)+bp(2,4)+bp(3,4)
      b1=2.0*bp(1,4)/be
      b3=2.0*bp(3,4)/be

c...determine recoil angle
      bet=arangl(1,3)
      psi=(paru(1)-bet)*(b3**2)/(b1**2+b3**2)
      bp(1,1)=0.0
      bp(1,2)=0.0
      bp(1,3)=be*0.5
      bp(1,4)=be*0.5
      bp(1,5)=0.0
      bp(2,1)=0.0
      bp(2,2)=0.0
      bp(2,3)=-be*0.5
      bp(2,4)=be*0.5
      bp(2,5)=0.0

c...rotate and boost back
      call arobo2(psi,0.0d0,0.0d0,0.0d0,0.0d0,1,2)
      call arobo2(0.0d0,phi2,0.0d0,0.0d0,0.0d0,1,2)
      call arobo2(the,phi,dbex,dbey,dbez,1,2)

c...copy jets to /lujets/
      do 100 j=1,5
        p(j1,j)=bp(1,j)
        p(j3,j)=bp(2,j)
 100  continue
      v(j1,1)=0.0
      v(j3,1)=0.0

      return

c**** end of arjoin ****************************************************
      end
c***********************************************************************
c $id: armade.f,v 0.4 1992/01/27 16:03:19 lonnblad exp $

      subroutine armade
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine set mass dependencies

c...sets some mass dependencies needed for armcdi


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


      ssy=sy1+sy2+sy3
      y1=sy1**2
      y2=sy2**2
      y3=sy3**2

      bc1=-(y1)-1.0d0+(sy2+sy3)**2
      bc3=-(y3)-1.0d0+(sy2+sy1)**2
      xt2m=0.0
      if(sqrt(0.25+y2)-1.0-(bc1+bc3)/2.0.lt.0.0) return
      xts=(sqrt(0.25+y2)-1.0-(bc1+bc3)/2.0)**2
      xt1=-2.0*sy1-bc1
      xt3=-2.0*sy3-bc3
      if(xt1.lt.0.0) return
      if(xt3.lt.0.0) return
      xt2m=min(xts,xt1*xt3)

      bzp=0.5*(1.0+y1-y3+sqrt(1.0+(y1-y3)**2-2.0*(y1+y3)))
      bzm=0.5*(1.0+y3-y1+sqrt(1.0+(y1-y3)**2-2.0*(y1+y3)))

      return

c**** end of armade ****************************************************
      end
c***********************************************************************
c $id: armass.f,v 0.6 1992/01/27 16:03:19 lonnblad exp $

      real*8 function armas2(i1,i2)
      implicit double precision (a-h,o,p,r-z)

c...ariadne function invariant mass of 2 partons


c...returns the invariant mass^2 of partons i1 and i2

      dimension i(2)


      i(1)=i1
      i(2)=i2

      armas2=armass(2,i)

      return

c**** end of armas2 ****************************************************
      end
c***********************************************************************
c $id: armass.f,v 0.6 1992/01/27 16:03:19 lonnblad exp $

      real*8 function armas3(i1,i2,i3)
      implicit double precision (a-h,o,p,r-z)

c...ariadne function invariant mass of 3 partons


c...returns the invariant mass^2 of partons i1, i2 and i3

      dimension i(3)


      i(1)=i1
      i(2)=i2
      i(3)=i3
      
      armas3=armass(3,i)

      return

c**** end of armas3 ****************************************************
      end
c***********************************************************************
c $id: armass.f,v 0.6 1992/01/27 16:03:19 lonnblad exp $

      real*8 function armass(n,i)
      implicit double precision (a-h,o,p,r-z)

c...ariadne function invariant mass of partons


c...returns the total invariant mass^2 of n partons


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/
      dimension i(n),dps(4)


      do 100 ik=1,4
        dps(ik)=0.0d0
        do 200 ij=1,n
          dps(ik)=dps(ik)+bp(i(ij),ik)
 200    continue
 100  continue

      dmass=dps(4)**2-dps(3)**2-dps(2)**2-dps(1)**2
      armass=max(dmass,0.0d0)

      return

c**** end of armass ****************************************************
      end
c***********************************************************************
c $id: armcdi.f,v 0.9 1992/01/31 16:14:59 lonnblad exp $

      subroutine armcdi(arrndx,arrndy,arveto)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine monte carlo distribution

c...generates x_1 and x_3 for a radiating dipole


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)
      external arrndx, arrndy, arveto
      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


c...exit if below cut
 100  if(xt2m.lt.xt2c) goto 900

c...generate random xt2
      xt2=arrndx()
      if(xt2.lt.xt2c) goto 900
      xt=sqrt(xt2)

c...generate rapidity y
      y=arrndy()

c...calculate energy fractions
      b1=-xt*exp(y)-bc1
      b3=-xt*exp(-y)-bc3
      b2=2.0-b1-b3

c...set maximum xt2 for possible next random call (veto algorithm)
      xt2m=xt2

c...redo random calls according to veto-algorithm
      if(arveto().lt.rlu(idum)) goto 100

c...check that current values are kinematically allowed
      call archki(0,iok)
      if(iok.eq.0) goto 100

      return

c...if below cuts set xt2 to 0
 900  b1=-bc1
      b3=-bc3
      xt2=0.0

      return

c**** end of armcdi ****************************************************
      end
c***********************************************************************
c $id: armipt.f,v 0.3 1991/09/26 12:43:33 lonnblad exp $

      real*8 function armipt(if,il)
      implicit double precision (a-h,o,p,r-z)

c...ariadne function determine minimum pt2


c...determines the minimum p_t^2 of any gluon between positions 
c...if and il.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      inxt(ip)=ip3(ido(ip))
      iprv(ip)=ip1(idi(ip))


      armipt=para(40)
      do 100 i=if,il
        if(.not.qq(i)) armipt=min(armipt,aript2(iprv(i),i,inxt(i)))
 100  continue

      return

c**** end of armipt ****************************************************
      end
c***********************************************************************
c $id: arnofl.f,v 0.3 1991/09/26 12:43:36 lonnblad exp $

      real*8 function arnofl(w,mnofl)
      implicit double precision (a-h,o,p,r-z)

c...ariadne function number of flavours 


c...returns the number of flavourspossible at energy w


      common /ardat2/ pqmas(10)
      save /ardat2/


      arnofl=0.0
      do 100 i=1,mnofl
        if(w.lt.2.0*pqmas(i)) return
        arnofl=i
 100  continue

      return

c**** end of arnofl ****************************************************
      end
c***********************************************************************
c $id: arordj.f,v 0.6 1992/01/31 16:14:59 lonnblad exp $

      subroutine arordj
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine order jets

c...orders jets in falling energy


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      include "Zarjetx.h"


      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/


c...error if no space left in /arpart/
      if(mstu(3).gt.maxpar) call arerrm('arordj',10,0)

c...copy jets into /arpart/ and link them with pointers
      ipf=1
      njet=0
      do 100 i=1,mstu(3)
        if(k(n+i,5).lt.0) goto 100
        njet=njet+1
        ido(njet)=njet+1
        idi(njet)=njet-1
        do 110 j=1,5
          bp(njet,j)=p(n+i,j)
 110    continue
 100  continue
      idi(1)=0
      ido(njet)=0

c...copy back jets to /lujets/ in falling order in energy
      mstu(3)=njet
      do 200 i=1,mstu(3)
        emax=0.0
        im=0
        ip=ipf
 210    if(bp(ip,4).gt.emax) then
          emax=bp(ip,4)
          im=ip
        endif
        if(ido(ip).ne.0) then
          ip=ido(ip)
          goto 210
        endif

        do 220 j=1,5
          p(n+i,j)=bp(im,j)
 220    continue

        if(im.eq.ipf) then
          ipf=ido(im)
        else
          ido(idi(im))=ido(im)
          if(ido(im).ne.0) idi(ido(im))=idi(im)
        endif

 200  continue

      return

c**** end of arordj ****************************************************
      end
c***********************************************************************
c $id: arorie.f,v 0.18 1992/03/12 11:23:19 lonnblad exp $

      subroutine arorie(i1,i2,i3,bs,b1,b3,qr1,qr3,pt21,pt23)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine orient

c...orients three partons according to recoil strategy determined
c...by qr1 and qr3


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/

      inxt(i)=ip3(ido(i))
      iprv(i)=ip1(idi(i))


c...set parton energies and momentum and total energy
      bw=sqrt(bs)
      if(b1.le.0.0) call arerrm('arorie',9,0)
      de1=0.5*b1*bw
      if(b3.le.0.0) call arerrm('arorie',9,0)
      de3=0.5*b3*bw
      de2=bw-de1-de3
      if(de2.lt.bp(i2,5)) call arerrm('arorie',9,0)

ccph:  negativity may arise here occasionally.  remove the problem brutally.
c      dp1=sqrt(de1**2-bp(i1,5)**2)
c      dp2=sqrt(de2**2-bp(i2,5)**2)
c      dp3=sqrt(de3**2-bp(i3,5)**2)
      dp1=de1**2-bp(i1,5)**2
      dp2=de2**2-bp(i2,5)**2
      dp3=de3**2-bp(i3,5)**2
      if(dp1.lt.0.) then
       dp1 = 0.d0
       bp(i1,5) = de1
      endif
      if(dp2.lt.0.) then
       dp2 = 0.d0
       bp(i2,5) = de2
      endif
      if(dp3.lt.0.) then
       dp3 = 0.d0
       bp(i3,5) = de3
      endif
      dp1=dsqrt(dp1)
      dp2=dsqrt(dp2)
      dp3=dsqrt(dp3)

c...if both partons 1 and 3 can take full recoil choose one according to
c...kleiss
      if(qr1.and.qr3) then
        if(b1**2.lt.(b1**2+b3**2)*rlu(idum)) then
          qr1=.false.
        else
          qr3=.false.
        endif
      endif

c...calculate angle between partons 1 and 3
      bcalp=1.0
      if(dp1.gt.0.0.and.dp3.gt.0.0) then
        bcalp=(dp2**2-dp1**2-dp3**2)/(2.0*dp1*dp3)
      else
        call arerrm('arorie',9,0)
      endif
      if(abs(bcalp).gt.1.0) call arerrm('arorie',9,0)
      bcalp=max(-1.0d0,min(1.0d0,(bcalp)))
      balp=acos(bcalp)

c...determine angle between parton 1 and z-axis
      if(qr1.and.pt21.le.0.0.and.pt23.le.0.0) then
        bpsi=paru(1)-balp
      elseif(qr3.and.pt21.le.0.0.and.pt23.le.0.0) then
        bpsi=0.0
      else
        bpsi=(paru(1)-balp)*(b3**2)/(b1**2+b3**2)

c...new recoil strategy
        if(pt21.gt.0.0.and.pt21.ge.pt23) then
          i0=iprv(i1)
          bpsi=arecoi(bp(i0,4),de1,de2,de3,abs(bp(i0,3)),dp1,dp2,dp3,
     $         balp,pt21)
        elseif(pt23.gt.0.0.and.pt23.gt.pt21) then
          i4=inxt(i3)
          bpsi=paru(1)-balp-
     $         arecoi(bp(i4,4),de3,de2,de1,abs(bp(i4,3)),
     $         dp3,dp2,dp1,balp,pt23)
        endif
      endif

c...set random azimuth angle
      bgam=paru(2)*rlu(idum)
      bsgam=sin(bgam)
      bcgam=cos(bgam)
      bspsi=sin(bpsi)
      bcpsi=cos(bpsi)
      bspsa=sin(bpsi+balp)
      bcpsa=cos(bpsi+balp)

c...set fourmomentum of partons
      bp(i1,1)=dp1*bspsi*bsgam
      bp(i1,2)=-dp1*bspsi*bcgam
      bp(i1,3)=dp1*bcpsi
      bp(i1,4)=de1

      bp(i3,1)=dp3*bspsa*bsgam
      bp(i3,2)=-dp3*bspsa*bcgam
      bp(i3,3)=dp3*bcpsa
      bp(i3,4)=de3

      dz2=-dp1*bcpsi-dp3*bcpsa
      dt2=dsqrt(max(dp2**2-dz2**2,0.0d0))
      bp(i2,1)=-dt2*bsgam
      bp(i2,2)=dt2*bcgam
      bp(i2,3)=dz2
      bp(i2,4)=de2

      return

c**** end of arorie ****************************************************
      end
c***********************************************************************
c $id: arorie.f,v 0.18 1992/03/12 11:23:19 lonnblad exp $

      real*8 function arecoi(be0,de1,de2,de3,bp0,dp1,dp2,dp3,balp,pt12)
      implicit double precision (a-h,o,p,r-z)

c...ariadne function recoil


c...calculates the angle of a recoil gluon according to the new
c...recoil strategy: p_t1^2*exp(-y_1)=p_t2^2*exp(-y_2)


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

c...calculate the maximum and minimum angle
      phil=0.0
      phiu=paru(1)-balp

c...calculate angle of recoil gluon
      bw=de1+de2+de3
      bs=bw**2
      bm3=de3**2-dp3**2
      s0123=(bw+be0)**2-bp0**2
      s12=bs-2.0*bw*de3+bm3
      s23=bs-2.0*bw*de1
      s13=bs-2.0*bw*de2
      d01=2.0*s12*de1*be0
      d02=2.0*s12*dp1*bp0
      d03=pt12*(s0123-s13-s23+bm3-2.0*de3*be0)
      d04=2*dp3*bp0*pt12*cos(balp)
      d05=2*dp3*bp0*pt12*sin(balp)
      d11=d01-d03
      d12=d05
      d13=d04+d02
      d21=(d11**2-d13**2)/(d12**2+d13**2)
      d22=d12*d11/(d12**2+d13**2)
      d31=d22**2-d21
      dsphi=sqrt(max(d31,0.0d0))-d22
      if(dsphi.lt.0.0d0) then
        phi=phil
      elseif(dsphi.ge.1.0d0) then
        phi=phiu
      else
        phi=min(asin(dsphi),(paru(1))-balp)
      endif

      arecoi=phi

      return


c**** end of arecoi ****************************************************
      end
c***********************************************************************
c $id: arpars.f,v 0.10 1992/03/04 19:36:20 lonnblad exp $

      subroutine arpars(nstart,nend)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine parse the event record

c...parse through the /lujets/ event record to find un-cascaded
c...strings. performs dipole cascade on each found.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      include "Zarjetx.h"



      idir=0

c...loop over entries in /lujets/ to be considered
      do 100 i=nstart,nend

c...if idir=0 there is no current string so skip all entries which
c...are not the begining of a string (k(i,1)=2) otherwise copy
c...parton to dipole record
        if(idir.eq.0) then
          if(k(i,1).ne.2) goto 100
          call argtyp(i,ityp)
          if(ityp.eq.0) call arerrm('arpars',1,i)
          idir=ityp
          imf=i
          ipart=1
          idips=0
          call arcopa(i,ipart,ityp)
        else

c...if in a string, copy parton and create a dipole. error if
c...colour singlets of triplets are found
          if(k(i,1).eq.2) then
            call argtyp(i,ityp)
            if(abs(ityp).eq.1) call arerrm('arpars',2,i)
            if(abs(ityp).eq.0) call arerrm('arpars',1,i)
            ipart=ipart+1
            idips=idips+1
            call arcopa(i,ipart,ityp)
            call arcrdi(idips,ipart-1,ipart,1,.false.)

c...if the end of a string check colour flow and consistency
          elseif(k(i,1).eq.1) then
            call argtyp(i,ityp)
            if(ityp.eq.0) call arerrm('arpars',1,i)
            iml=i
            ipart=ipart+1
            idips=idips+1
            call arcopa(i,ipart,ityp)
            call arcrdi(idips,ipart-1,ipart,1,.false.)
c...........if purely gluonic string create extra dipole
            if(ityp.eq.2) then
              if(idir.ne.2) call arerrm('arpars',4,i)
              idips=idips+1
              call arcrdi(idips,ipart,1,1,.false.)
c...........if ordinary string create em-dipole
            else
              if(ityp.ne.-idir) call arerrm('arpars',5,i)
              if(msta(20).gt.0.and.idips.eq.1.and.
     $               iex(1).eq.0.and.iex(ipart).eq.0) then
                idips=idips+1
                call arcrdi(idips,ipart,1,1,.true.)
              endif
            endif

c...initialize string variables in dipole record and perform cascade
            pt2lst=para(40)
            if(msta(14).gt.1.and.ipart.gt.2) pt2lst=armipt(1,ipart)
            if(para(6).gt.0.0) pt2lst=min(pt2lst,para(6)**2)
c...don't cascade purelu gluonic string
            if(idir.ne.2) then
              ipf(1)=1
              ipl(1)=ipart
              istrs=1
              iflow(1)=idir
              call arexma(1,ipart)
              call arcasc
              idir=0
            endif
          endif
        endif
 100  continue


      return

c**** end of arpars ****************************************************
      end
c***********************************************************************
c $id: arradg.f,v 0.15 1992/03/12 12:08:18 lonnblad exp $

      subroutine arradg(id,nrem,snr,pt21,pt23)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine radiate gluon

c...performs the radiation of a gluon from dipole id


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /arint2/ dbex,dbey,dbez,phi,the
      save /arint2/

      inxt(i)=ido(ip3(i))


c...boost dipole to its cms
      call arbocm(id)

c...copy some information about dipole
      bs=armas2(ip1(id),ip3(id))
      if(abs(bs-sdip(id)).gt.(bs+sdip(id))*para(39).and.
     $     msta(9).ge.2) call arerrm('arradg',13,0)

      bw=sqrt(bs)
      b1=bx1(id)
      b3=bx3(id)
      ne1=iex(ip1(id))
      ne3=iex(ip3(id))

c...if parton not extended - no recoil gluon (trivial)
      if(ne1.eq.0) aex1(id)=2.0
      if(ne3.eq.0) aex3(id)=2.0

c...no recoil gluon if reemission
      if(nrem.eq.1) aex1(id)=2.0
      if(nrem.eq.3) aex3(id)=2.0

c...if aex1(3) >= 1 then no recoil gluon
      if(msta(17).eq.0) then
        aex1(id)=2.0
        aex3(id)=2.0
      endif

c...no recoil gluons if not enough energy left for original parton
      if(aex1(id).lt.1.0.or.aex3(id).lt.1.0) then
        by1=bp(ip1(id),5)**2/bs
        by3=bp(ip3(id),5)**2/bs
        bpt=0.5*sqrt(bs)*
     $       (1.0+by1-by3+sqrt(1.0+(by1-by3)**2-2.0*(by1+by3)))
        b1p=(1.0-aex1(id))*bpt
        if(b1p.lt.bp(ip1(id),5)) then
          aex1(id)=2.0
          b1p=0.0
          b1m=0.0
        else
          b1m=bs*by1/b1p
        endif
        bmt=0.5*sqrt(bs)*
     $       (1.0+by3-by1+sqrt(1.0+(by1-by3)**2-2.0*(by1+by3)))
        b3m=(1.0-aex3(id))*bmt
        if(b3m.lt.bp(ip3(id),5)) then
          aex3(id)=2.0
          b3p=0.0
          b3m=0.0
        else
          b3p=bs*by3/b3m
        endif
      endif

c...check if any parton can take full recoil.
      qr1=(qq(ip1(id)).and.msta(16).ge.1.and.(iex(ip1(id)).eq.0.or.
     $     (iex(ip1(id)).ge.1.and.msta(16).eq.2.and.aex1(id).ge.1.0)))
      qr3=(qq(ip3(id)).and.msta(16).ge.1.and.(iex(ip3(id)).eq.0.or.
     $     (iex(ip3(id)).ge.1.and.msta(16).eq.2.and.aex3(id).ge.1.0)))

c...special treatment for drell-yan produced particles
      if(msta(23).gt.0) call ardyre(id,*100)

c...no recoil gluons if one parton can take full recoil
      if((aex1(id).lt.1.0.or.aex3(id).lt.1.0).and.msta(17).eq.1) then
        if(qr3) aex1(id)=2.0
        if(qr1) aex3(id)=2.0
      endif

      qrg1=(aex1(id).lt.1.0)
      qrg3=(aex3(id).lt.1.0)

      ide=id

c...add recoil gluon for parton 1
      if(qrg1) then
        call araddg(id)
        ide=inxt(id)
        bp(ip1(id),1)=0.0
        bp(ip1(id),2)=0.0
        bp(ip1(id),3)=0.5*(b1p-b1m)
        bp(ip1(id),4)=0.5*(b1p+b1m)
        ino(ip3(id))=-io
      endif

c...add emitted gluon
      call araddg(ide)
      ino(ip3(ide))=io

c...add recoil gluon for parton 3
      if(qrg3) then
        idl=inxt(ide)
        call araddg(idl)
        idl=inxt(idl)
        bp(ip3(idl),1)=0.0
        bp(ip3(idl),2)=0.0
        bp(ip3(idl),3)=0.5*(b3p-b3m)
        bp(ip3(idl),4)=0.5*(b3p+b3m)
        ino(ip1(idl))=-io
      endif

      if(nrem.eq.0) then
        if(qrg1.and.qrg3) then
          snr3=bs*((bw-b1m)*(1.0-b1+by1-by3)/bw+by3)
          snr1=bs*((bw-b3p)*(1.0-b3+by3-by1)/bw+by1)
        elseif(qrg1) then
          snr=bs*(1.0-b3+by3)
        elseif(qrg3) then
          snr=bs*(1.0-b1+by1)
        else
          snr=0.0
        endif
      endif

      pt21=0.0
      pt23=0.0
      if(qrg1.or.qrg3) then
        b2m=(1.0-b3+by3-by1)*bw
        b2p=(1.0-b1+by1-by3)*bw
        if(qrg1.and.msta(17).ge.2) pt21=(b2m*b2p**3)/(bw-b1p-b2p)**2
        if(qrg3.and.msta(17).ge.2) pt23=(b2p*b2m**3)/(bw-b3m-b2m)**2
        da=(bw-b1p-b3p)/(bw-b1m-b3m)
        sa=(bw-b1p-b3p)*(bw-b1m-b3m)/bs
        db=(da-1.0d0)/(da+1.0d0)
        by1a=by1/sa
        if(qrg1) by1a=0.0
        by3a=by3/sa
        if(qrg3) by3a=0.0
        bs=bs*sa
        b1=1.0-(1.0-b1+by1-by3)/sqrt(sa*da)+by1a-by3a
        b3=1.0-(1.0-b3+by3-by1)/sqrt(sa/da)+by3a-by1a

        if(qrg1) call arobo1(0.0d0,0.0d0,0.0d0,0.0d0,-db,ip1(id))
        if(qrg3) call arobo1(0.0d0,0.0d0,0.0d0,0.0d0,-db,ip3(idl))
      endif

c...disable kleiss orientation if extended partons
      if(qr1.and.qr3.and.ne1+ne3.ne.0) then
        qr1=.false.
        qr3=.false.
      endif

c...orientate the emitted partons
      if(nrem.eq.0) then
        call arorie(ip1(ide),ip3(ide),ip3(inxt(ide)),bs,b1,b3,qr1,qr3,
     $       pt21,pt23)
      elseif(nrem.eq.1) then
        qr1=.false.
        qr3=.true.
        call arorie(ip1(ide),ip3(ide),ip3(inxt(ide)),bs,b1,b3,
     $       qr1,qr3,0.0d0,0.0d0)
      elseif(nrem.eq.3) then
        qr1=.true.
        qr3=.false.
        call arorie(ip1(ide),ip3(ide),ip3(inxt(ide)),bs,b1,b3,
     $       qr1,qr3,0.0d0,0.0d0)
      endif
        
c...boost created dipoles back to original cms
      if((.not.qrg1).and.(.not.qrg3)) then
        call arobo3(the,phi,dbex,dbey,dbez,
     $              ip1(ide),ip3(ide),ip3(inxt(ide)))
      elseif(qrg1.and.(.not.qrg3)) then
        if(msta(17).lt.2) pt21=aript2(ip1(id),ip1(ide),ip3(ide))
        call arobo4(0.0d0,0.0d0,0.0d0,0.0d0,db,
     $              ip1(id),ip1(ide),ip3(ide),ip3(inxt(ide)))
        call arobo4(the,phi,dbex,dbey,dbez,
     $              ip1(id),ip1(ide),ip3(ide),ip3(inxt(ide)))
      elseif((.not.qrg1).and.qrg3) then
        if(msta(17).lt.2) pt23=aript2(ip1(ide),ip3(ide),ip3(inxt(ide)))
        call arobo4(0.0d0,0.0d0,0.0d0,0.0d0,db,
     $              ip1(ide),ip3(ide),ip3(inxt(ide)),ip3(idl))
        call arobo4(the,phi,dbex,dbey,dbez,
     $              ip1(ide),ip3(ide),ip3(inxt(ide)),ip3(idl))
      elseif(qrg1.and.qrg3) then
        if(msta(17).lt.2) then
          pt21=aript2(ip1(id),ip1(ide),ip3(ide))
          pt23=aript2(ip3(ide),ip3(inxt(ide)),ip3(idl))
        endif
        if(pt21.ge.pt23) then
          snr=snr3
        else
          snr=snr1
        endif
        call arobo5(0.0d0,0.0d0,0.0d0,0.0d0,db,
     $              ip1(id),ip1(ide),ip3(ide),ip3(inxt(ide)),ip3(idl))
        call arobo5(the,phi,dbex,dbey,dbez,
     $              ip1(id),ip1(ide),ip3(ide),ip3(inxt(ide)),ip3(idl))
      endif

 100  continue

      return

c**** end of arradg ****************************************************
      end
c***********************************************************************
c $id: arradp.f,v 0.9 1992/02/05 14:48:41 lonnblad exp $

      subroutine arradp(id)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine radiate photon

c...performs the radiation of a photon from em-dipole id


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /arint2/ dbex,dbey,dbez,phi,the
      save /arint2/

      inxt(i)=ido(ip3(i))
      iprv(i)=idi(ip1(i))

c...boost dipole to its cms, and get its invaiant mass^2
      call arbocm(id)
      bs=armas2(ip1(id),ip3(id))
      if(abs(bs-sdip(id)).gt.(bs+sdip(id))*para(39).and.
     $     msta(9).ge.2) call arerrm('arradg',13,0)

      qr1=.true.
      qr3=.true.
c...use position ipart+1 temporarily for the photon and orientate
c...the particles/partons
      bp(ipart+1,5)=0.0
      call arorie(ip1(id),ipart+1,ip3(id),bs,bx1(id),bx3(id),
     $            qr1,qr3,0.0d0,0.0d0)

c...boost back to original cms
      call arobo3(the,phi,dbex,dbey,dbez,
     $            ip1(id),ipart+1,ip3(id))
c...copy photon information to /lujets/
      call arduph

c...flagg dipoles that were affected by the emission
      qdone(inxt(id))=.false.
      qdone(iprv(id))=.false.
      qdone(id)=.false.

      return

c**** end of arradp ****************************************************
      end
c***********************************************************************
c $id: arradq.f,v 0.8 1992/01/31 16:14:59 lonnblad exp $

      subroutine arradq(id)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine radiate q-qbar pair

c...performs the emission of a q-qbar pair from gluon in dipole id


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /arint2/ dbex,dbey,dbez,phi,the
      save /arint2/

      inxt(i)=ido(ip3(i))
      iprv(i)=idi(ip1(i))

c...boost dipole to its cms and copy its invariant mass^2
      call arbocm(id)
      bs=armas2(ip1(id),ip3(id))
      if(abs(bs-sdip(id)).gt.(bs+sdip(id))*para(39).and.
     $     msta(9).ge.2) call arerrm('arradq',13,0)

c...check which gluon to split
      if(irad(id).lt.0) then
c.......determine patons ability to recoil, save pointers and flag
c.......affected dipoles
        qr1=.true.
        qr3=(qq(ip3(id)).and.msta(16).gt.0)
        ipg=ip1(id)
        idn=id
        idp=iprv(id)
        if(inxt(id).ne.0) qdone(inxt(id))=.false.
c.......split the gluon entry, orientate the partons, and boost back
        call arsplg(ipg,abs(irad(id)))
        call arorie(ip3(idp),ip1(idn),ip3(idn),bs,bx1(id),bx3(id),
     $              qr1,qr3,0.0d0,0.0d0)
        call arobo3(the,phi,dbex,dbey,dbez,
     $              ip3(idp),ip1(idn),ip3(idn))
      else
c.......determine patons ability to recoil, save pointers and flag
c.......affected dipoles
        qr3=.true.
        qr1=(qq(ip1(id)).and.msta(16).gt.0)
        ipg=ip3(id)
        idp=id
        idn=inxt(id)
        if(iprv(id).ne.0) qdone(iprv(id))=.false.
c.......split the gluon entry, orientate the partons, and boost back
        call arsplg(ipg,abs(irad(id)))
        call arorie(ip1(idp),ip3(idp),ip1(idn),bs,bx1(id),bx3(id),
     $              qr1,qr3,0.0d0,0.0d0)
        call arobo3(the,phi,dbex,dbey,dbez,
     $              ip1(idp),ip3(idp),ip1(idn))
      endif



      return

c**** end of arradq ****************************************************
      end
c***********************************************************************
c $id: arreca.f,v 0.4 1991/11/06 14:14:58 lonnblad exp $

      subroutine arreca(id,ids,is1,is3)
      implicit double precision (a-h,o,p,r-z)

c...ariadne function recall


c...recalls a dipole entry stored by arstor


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/



      sdip(id)=sdip(ids)
      ip1(id)=ip1(ids)
      ip3(id)=ip3(ids)
      bx1(id)=bx1(ids)
      bx3(id)=bx3(ids)
      pt2in(id)=pt2in(ids)
      aex1(id)=aex1(ids)
      aex3(id)=aex3(ids)
      qdone(id)=qdone(ids)
      qem(id)=qem(ids)
      irad(id)=irad(ids)
      istr(id)=istr(ids)

      i1=ip1(id)
      i3=ip3(id)

      do 100 i=1,5
        bp(i1,i)=bp(is1,i)
        bp(i3,i)=bp(is3,i)
 100  continue
      ifl(i1)=ifl(is1)
      ifl(i3)=ifl(is3)
      iex(i1)=iex(is1)
      iex(i3)=iex(is3)
      qq(i1)=qq(is1)
      qq(i3)=qq(is3)
      idi(i1)=idi(is1)
      idi(i3)=idi(is3)
      ido(i1)=ido(is1)
      ido(i3)=ido(is3)
      ino(i1)=ino(is1)
      ino(i3)=ino(is3)

      return

c**** end of arreca ****************************************************
      end
c***********************************************************************
c $id: arupdj.f,v 0.1 1992/01/27 16:03:19 lonnblad exp $

      subroutine arupdj(i2,i1,i3)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine update jet entry

c...takes a jet entry i2 and determines its minimum invariant pt wrt.
c...all other jets. i1 and i3 indicates which jets have been changed
c...since last call


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      include "Zarjetx.h"


      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/


      if(k(i2,5).lt.0) return
      if(i1.eq.0.or.k(k(i2,3),5).lt.0.or.k(k(i2,4),5).lt.0.or.
     $     i2.eq.i1.or.i2.eq.i3.or.k(i2,3).eq.i1.or.k(i2,4).eq.i3) then
        v(i2,5)=para(40)
        do 100 j1=n+1,n+mstu(3)-1
          if(k(j1,5).lt.0) goto 100
          if(j1.eq.i2) goto 100
          do 110 j3=j1+1,n+mstu(3)
            if(k(j3,5).lt.0) goto 110
            if(j3.eq.i2) goto 110
            call arsmpt(j1,i2,j3)
 110      continue
 100    continue
      else
        do 200 j=n+1,n+mstu(3)
          if(j.eq.i2.or.k(j,5).lt.0) goto 200
          if(j.gt.i1) call arsmpt(i1,i2,j)
          if(j.lt.i3) call arsmpt(j,i2,i3)
          if(j.lt.i1) call arsmpt(j,i2,i1)
          if(j.gt.i3) call arsmpt(i3,i2,j)
 200    continue
      endif

      return

c**** end of arupdj ****************************************************
      end

      subroutine arsmpt(i1,i2,i3)
      implicit double precision (a-h,o,p,r-z)


      include "Zarjetx.h"


      p12=p(i1,4)*p(i2,4)-p(i1,3)*p(i2,3)-
     $    p(i1,2)*p(i2,2)-p(i1,1)*p(i2,1)
      p23=p(i3,4)*p(i2,4)-p(i3,3)*p(i2,3)-
     $    p(i3,2)*p(i2,2)-p(i3,1)*p(i2,1)
      p31=p(i1,4)*p(i3,4)-p(i1,3)*p(i3,3)-
     $    p(i1,2)*p(i3,2)-p(i1,1)*p(i3,1)
      pt2i=(v(i1,1)+v(i2,1)+p12)*(v(i2,1)+v(i3,1)+p23)/
     $     (v(i1,1)+v(i2,1)+v(i3,1)+p12+p23+p31)

      if(pt2i.ge.v(i2,5)) return
      v(i2,5)=pt2i
      k(i2,3)=i1
      k(i2,4)=i3  

      return
      end
c***********************************************************************
c $id: arrndx.f,v 0.4 1992/01/31 16:14:59 lonnblad exp $

      real*8 function arndx1()
      implicit double precision (a-h,o,p,r-z)

c...ariadne function rndom xt2 version 1

c...generate an x_t^2 according to a sudakov suppressed distribution.
c...suitable for running alpha_qcd


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


      arndx1=0.0
      arg=rlu(idum)
      if(log(arg)*cn.lt.log(log(xt2c/xlam2)/log(xt2m/xlam2))) return
      arndx1=xlam2*(xt2m/xlam2)**(arg**cn)

      return

c**** end of arndx1 ****************************************************
      end
c***********************************************************************

      real*8 function arndx2()
      implicit double precision (a-h,o,p,r-z)

c...ariadne function rndom xt2 version 2

c...generate an x_t^2 according to a sudakov suppressed distribution.
c...suitable for constant alpha_qcd and qed emission


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


      arndx2=0.0
      arg=rlu(idum)
      if(cn*log(arg).lt.(log(xt2m))**2-(log(xt2c))**2) return
      arndx2=exp(-sqrt((log(xt2m))**2-log(arg)*cn))

      return

c**** end of arndx2 ****************************************************
      end
c***********************************************************************

      real*8 function arndx3()
      implicit double precision (a-h,o,p,r-z)

c...ariadne function rndom xt2 version 3

c...generate an x_t^2 according to a sudakov suppressed distribution.
c...suitable for constant alpha_qcd q-qbar emission


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


      arndx3=0.0
      arg=rlu(idum)
      if(log(arg)*cn.lt.log(xt2c/xt2m)) return
      arndx3=xt2m*(arg**cn)

      return

c**** end of arndx3 ****************************************************
      end
c***********************************************************************
c $id: arrndy.f,v 0.6 1992/02/03 09:48:57 lonnblad exp $

      real*8 function arndy1()
      implicit double precision (a-h,o,p,r-z)

c...ariadne function random y version 1

c...generates a properly distributed y
c...suitable for gluon and photon emission


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


      zmax=sqrt(xts/xt2)+sqrt(max(xts/xt2-1.0d0,0.0d0))
      ymax=log(min(zmax,xt3/xt))
      ymin=-log(min(zmax,xt1/xt))

      arndy1=ymin+rlu(idum)*(ymax-ymin)

      return

c**** end of arndy1 ****************************************************
      end
c***********************************************************************

      real*8 function arndy2()
      implicit double precision (a-h,o,p,r-z)

c...ariadne function random y version 2

c...generates a properly distributed y
c...suitable for gluon emission from extended dipole


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


      zmax=sqrt(xts/xt2)+sqrt(max(xts/xt2-1.0d0,0.0d0))

      ae1=1.0
      ae3=1.0
      if(ne1.gt.0) ae1=(para(10+ne1)/(xt*w))**para(10)
      if(ne3.gt.0) ae3=(para(10+ne3)/(xt*w))**para(10)
      bp1=(1.0-ae1)*bzp
      if(bp1.le.sy1) then
        bp1=0.0
        bm1=0.0
      else
        bm1=y1/bp1
      endif
      bm3=(1.0-ae3)*bzm
      if(bm3.le.sy3) then
        bm3=0.0
        bp3=0.0
      else
        bp3=y3/bm3
      endif
      az1=1.0-bp1-bp3
      az3=1.0-bm1-bm3
      a=(0.5d0+sqrt(max(0.25d0-xt2/(az1*az3),0.0d0)))/xt

      ymax=log(min(zmax,min(xt3/xt,abs(az1)*a)))
      ymin=-log(min(zmax,min(xt1/xt,abs(az3)*a)))

      arndy2=ymin+rlu(idum)*(ymax-ymin)

      return

c**** end of arndy2 ****************************************************
      end
c***********************************************************************

      real*8 function arndy3()
      implicit double precision (a-h,o,p,r-z)

c...ariadne function random y version 3

c...generates a properly distributed y
c...suitable for q-qbar emission


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


      zmax=sqrt(xts/xt2)+sqrt(max(xts/xt2-1.0d0,0.0d0))
      zmin=min(zmax,xt1/xt)
      zmax=min(zmax,xt3/xt)

      ymax=log(zmax)
      ymin=-log(zmin)

      arndy3=-log(1.0/zmax+rlu(idum)*(zmin-1.0/zmax))

      return

c**** end of arndy3 ****************************************************
      end
c***********************************************************************

      real*8 function arndy4()
      implicit double precision (a-h,o,p,r-z)

c...ariadne function random y version 4

c...generates a properly distributed y
c...suitable for q-qbar emission from extended dipole


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/

      common /ardat1/ para(40),msta(40)
      save /ardat1/


      zmax=sqrt(xts/xt2)+sqrt(max(xts/xt2-1.0d0,0.0d0))
      zmin=min(zmax,xt1/xt)
      zmax=min(zmax,xt3/xt)

      ae1=1.0
      ae3=1.0
      if(ne1.gt.0) ae1=(para(10+ne1)/(xt*w))**para(10)
      if(ne3.gt.0) ae3=(para(10+ne3)/(xt*w))**para(10)
      bp1=(1.0-ae1)*bzp
      if(bp1.le.sy1) then
        bp1=0.0
        bm1=0.0
      else
        bm1=y1/bp1
      endif
      bm3=(1.0-ae3)*bzm
      if(bm3.le.sy3) then
        bm3=0.0
        bp3=0.0
      else
        bp3=y3/bm3
      endif
      az1=1.0-bp1-bp3
      az3=1.0-bm1-bm3
      a=(0.5d0+sqrt(max(0.25d0-xt2/(az1*az3),0.0d0)))/xt

      zmax=min(zmax,abs(az1)*a)
      zmin=min(zmin,abs(az3)*a)

      ymax=log(zmax)
      ymin=-log(zmin)

      arndy4=-log(1.0/zmax+rlu(idum)*(zmin-1.0/zmax))

      return

c**** end of arndy4 ****************************************************
      end
c***********************************************************************
c $id: arrobo.f,v 0.5 1992/03/12 12:10:13 lonnblad exp $

      subroutine arobo1(the,phi,dbex,dbey,dbez,i1)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine rotate boost 1 parton

c...rotates and boosts 1 parton in /arpart/


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)
      dimension i(1)


      i(1)=i1
      call arrobo(the,phi,dbex,dbey,dbez,1,i)

      return

c**** end of arobo1 ****************************************************
      end
c***********************************************************************
c $id: arrobo.f,v 0.5 1992/03/12 12:10:13 lonnblad exp $

      subroutine arobo2(the,phi,dbex,dbey,dbez,i1,i2)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine rotate boost 2 partons

c...rotates and boosts 2 partons in /arpart/


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)
      dimension i(2)


      i(1)=i1
      i(2)=i2
      call arrobo(the,phi,dbex,dbey,dbez,2,i)

      return

c**** end of arobo2 ****************************************************
      end
c***********************************************************************
c $id: arrobo.f,v 0.5 1992/03/12 12:10:13 lonnblad exp $

      subroutine arobo3(the,phi,dbex,dbey,dbez,i1,i2,i3)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine rotate boost 3 partons

c...rotates and boosts 3 partons in /arpart/


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)
      dimension i(3)


      i(1)=i1
      i(2)=i2
      i(3)=i3
      call arrobo(the,phi,dbex,dbey,dbez,3,i)

      return

c**** end of arobo3 ****************************************************
      end
c***********************************************************************
c $id: arrobo.f,v 0.5 1992/03/12 12:10:13 lonnblad exp $

      subroutine arobo4(the,phi,dbex,dbey,dbez,i1,i2,i3,i4)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine rotate boost 4 partons

c...rotates and boosts 4 partons in /arpart/


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)
      dimension i(4)


      i(1)=i1
      i(2)=i2
      i(3)=i3
      i(4)=i4
      call arrobo(the,phi,dbex,dbey,dbez,4,i)

      return

c**** end of arobo4 ****************************************************
      end
c***********************************************************************
c $id: arrobo.f,v 0.5 1992/03/12 12:10:13 lonnblad exp $

      subroutine arobo5(the,phi,dbex,dbey,dbez,i1,i2,i3,i4,i5)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine rotate boost 5 partons

c...rotates and boosts 5 partons in /arpart/


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)
      dimension i(5)


      i(1)=i1
      i(2)=i2
      i(3)=i3
      i(4)=i4
      i(5)=i5
      call arrobo(the,phi,dbex,dbey,dbez,5,i)

      return

c**** end of arobo5 ****************************************************
      end
c***********************************************************************
c $id: arrobo.f,v 0.5 1992/03/12 12:10:13 lonnblad exp $

      subroutine arrobo(the,phi,dbex,dbey,dbez,ni,i)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine rotate and boost

c...rotates and boost ni particles in /arpart/


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      dimension i(ni),br(3,3),bv(3),dp(4)


      if(the**2+phi**2.gt.1.0e-20) then

c...rotate (typically from z axis to direction theta,phi)

        sp=sin(phi)
        cp=cos(phi)
        st=sin(the)
        ct=cos(the)

        br(1,1)=ct*cp
        br(1,2)=-sp
        br(1,3)=st*cp
        br(2,1)=ct*sp
        br(2,2)=cp
        br(2,3)=st*sp
        br(3,1)=-st
        br(3,2)=0.0
        br(3,3)=ct

        do 100 ij=1,ni
          do 110 j=1,3
            bv(j)=bp(i(ij),j)
 110      continue
          do 120 j=1,3
            bp(i(ij),j)=br(j,1)*bv(1)+br(j,2)*bv(2)+br(j,3)*bv(3)
 120      continue
 100    continue

      endif

      dbtot2=dbex**2+dbey**2+dbez**2
      if(dbtot2.gt.1.0d-20) then
        if(dbtot2.ge.1.0d0) call arerrm('arrobo',14,0)
        dga=1.0d0/dsqrt(1.0d0-dbtot2)

        do 200 ij=1,ni
          do 210 j=1,4
            dp(j)=bp(i(ij),j)
 210      continue
          dbep=dbex*dp(1)+dbey*dp(2)+dbez*dp(3)
          dgabep=dga*(dga*dbep/(1.0d0+dga)+dp(4))

          bp(i(ij),1)=dp(1)+dgabep*dbex
          bp(i(ij),2)=dp(2)+dgabep*dbey
          bp(i(ij),3)=dp(3)+dgabep*dbez
          bp(i(ij),4)=dga*(dp(4)+dbep)

 200    continue

      endif

      return

c**** end of arrobo ****************************************************
      end
c***********************************************************************
c $id: arsplg.f,v 0.10 1992/03/04 19:36:57 lonnblad exp $

      subroutine arsplg(ig,iflav)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine split gluon

c...splits a gluon entry into a q and a q-bar entry


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat2/ pqmas(10)
      save /ardat2/

      inxt(i)=ido(ip3(i))


c...allocate space for new parton and new string if there is room
      ipart=ipart+1
      istrs=istrs+1

      if(ipart.ge.maxpar-1) call arerrm('arsplg',6,0)
      if(istrs.gt.maxstr) call arerrm('arsplg',8,0)

c...set new pointers
      idp=idi(ig)
      idn=ido(ig)
      ido(ig)=0
      idi(ipart)=0
      ido(ipart)=idn

      ip1(idn)=ipart

      is=istr(idp)

c...if closed gluonic string, no new string is created. the colour flow
c...which was previously undefined is set randomly
      if(iflow(is).eq.2) then
        istrs=istrs-1
        iflow(is)=1
        ipf(is)=ipart
        ipl(is)=ig
        if(rlu(idum).gt.0.5) iflow(is)=-1
        ifl(ig)=iflav*iflow(is)
        ifl(ipart)=-ifl(ig)

c...if new string is created set pointers for its partons
      else
        iflow(istrs)=iflow(is)
        ipf(istrs)=ipart
        ipl(istrs)=ipl(is)
        ipl(is)=ig
        ifl(ipart)=iflav*iflow(is)
        ifl(ig)=-ifl(ipart)
        idni=idn
 100    istr(idni)=istrs
        if(.not.qq(ip3(idni))) then
          idni=inxt(idni)
          goto 100
        endif
      endif

c...reset momenta for created quarks and flag affected dipoles
      do 200 i=1,4
        bp(ig,i)=0.0
        bp(ipart,i)=0.0
 200  continue
      bp(ig,5)=pqmas(iflav)
      bp(ipart,5)=pqmas(iflav)
      iex(ig)=0
      iex(ipart)=0
      qq(ig)=.true.
      qq(ipart)=.true.
      qdone(idp)=.false.
      qdone(idn)=.false.
      ino(ig)=sign(1000*abs(ino(ig))+io,ino(ig))
      ino(ipart)=ino(ig)

      return

c**** end of arsplg ****************************************************
      end
c***********************************************************************
c $id: arstor.f,v 0.3 1991/11/06 14:15:07 lonnblad exp $

      subroutine arstor(id,ids,is1,is3)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine store 

c...stores a dipole entry for later use


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /arint2/ dbex,dbey,dbez,phi,the
      save /arint2/


      ids=maxdip
      sdip(ids)=sdip(id)
      ip1(ids)=ip1(id)
      ip3(ids)=ip3(id)
      bx1(ids)=bx1(id)
      bx3(ids)=bx3(id)
      pt2in(ids)=pt2in(id)
      aex1(ids)=aex1(id)
      aex3(ids)=aex3(id)
      qdone(ids)=qdone(id)
      qem(ids)=qem(id)
      irad(ids)=irad(id)
      istr(ids)=istr(id)

      i1=ip1(id)
      i3=ip3(id)
      is1=maxpar-1
      is3=maxpar
      do 100 i=1,5
        bp(is1,i)=bp(i1,i)
        bp(is3,i)=bp(i3,i)
 100  continue
      ifl(is1)=ifl(i1)
      ifl(is3)=ifl(i3)
      iex(is1)=iex(i1)
      iex(is3)=iex(i3)
      qq(is1)=qq(i1)
      qq(is3)=qq(i3)
      idi(is1)=idi(i1)
      idi(is3)=idi(i3)
      ido(is1)=ido(i1)
      ido(is3)=ido(i3)
      ino(is1)=ino(i1)
      ino(is3)=ino(i3)

      return

c**** end of arstor ****************************************************
      end
c***********************************************************************
c $id: artest.f,v 0.12 1992/03/11 09:36:15 lonnblad exp $

      subroutine artest(iprint)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine test

c...performs various tests on ariadne


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /arstrs/ ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs
      save /arstrs/

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /ardat2/ pqmas(10)
      save /ardat2/

      common /ardat3/ iwrn(40)
      save /ardat3/

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/

      common /arint2/ dbex,dbey,dbez,phi,the
      save /arint2/

      include "Zarjetx.h"

      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/

      msta(9)=1
      msta(6)=-1
      msta(20)=1

      mstj(21)=0

      para(12)=2.0
      para(13)=10.0

      call arinit('ariadne')

      do 110 i=1,10000

        w=10.0*exp(rlu(idum)*log(1000.0))
 100    sm1=rlu(idum)*20.0
        sm2=rlu(idum)*20.0
        e1=0.5*(w**2+sm1**2-sm2**2)/w
        e2=w-e1
        if(e1.lt.sm1) goto 100
        if(e2.lt.sm2) goto 100
        ne1=int(rlu(idum)*4.0)
        ne2=int(rlu(idum)*4.0)
        n=2
        p(1,1)=0.0
        p(1,2)=0.0
        p(1,3)=-sqrt(e1**2-sm1**2)
        p(1,4)=e1
        p(1,5)=sm1
        k(1,1)=2
        k(1,2)=1
        k(1,3)=0
        k(1,4)=ne1
        k(1,5)=0
        p(2,1)=0.0
        p(2,2)=0.0
        p(2,3)=sqrt(e2**2-sm2**2)
        p(2,4)=e2
        p(2,5)=sm2
        k(2,1)=1
        k(2,2)=-1
        k(2,3)=0
        k(2,4)=ne2
        k(2,5)=0

        call arexec
        call luexec

        if(iprint.gt.0.and.mod(i,100).eq.0) call lulist(2)

 110  continue

      nerra=0
      do 200 i=1,40
        nerra=nerra+iwrn(i)
 200  continue

      nwrna=iwrn(13)+iwrn(10)
      nerra=nerra-nwrna
      if(nerra.eq.0) then
        write(msta(7),1000)
      else
        write(msta(7),1010) nerra
      endif

      if(nwrna.gt.0) write(msta(7),1020) nwrna

      nwrnj=mstu(27)
      nerrj=mstu(23)

      if(nwrnj+nerrj.ne.0) write(msta(7),1030) nwrnj,nerrj

 1000 format('no errors experienced by ariadne.')
 1010 format(i5,' errors occurred in ariadne.')
 1020 format(i5,' non-serious warnings issued by ariadne')
 1030 format(i5,' warnings and',i5,' errors occured in jetset when ',
     $     'attempting to fragment',/
     $     ,' parton state produced by ariadne.')

      return

c**** end of artest ****************************************************
      end
c***********************************************************************
c $id: arveto.f,v 0.8 1992/01/27 16:03:19 lonnblad exp $

      real*8 function arvet1()
      implicit double precision (a-h,o,p,r-z)

c...ariadne function veto factor version 1

c...determine the acceptance factor for chosen x_t^2 and y
c...suitable for photon emission with constant alpha_em


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


      arvet1=0.0
      if(b2.le.0) return
      arvet1=-((fq1*(1.0-b1)/b2-fq3*(1.0-b3)/b2)**2)*
     $         (b1**nxp1+b3**nxp3)*(ymax-ymin)*0.5/log(xt2)

      if(msta(19).eq.0) return

      arvet1=arvet1*arveth()

      return

c**** end of arvet1 ****************************************************
      end
c***********************************************************************

      real*8 function arvet2()
      implicit double precision (a-h,o,p,r-z)

c...ariadne function veto factor version 2


c...determine the acceptance factor for chosen x_t^2 and y
c...suitable for photon emission with running alpha_em


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


      arvet2=arvet1()*ulalem(xt2*s)/ulalem(0.25*s)

      return

c**** end of arvet2 ****************************************************
      end
c***********************************************************************

      real*8 function arvet3()
      implicit double precision (a-h,o,p,r-z)

c...ariadne function veto factor version 3


c...determine the acceptance factor for chosen x_t^2 and y
c...suitable for gluon emission with constant alpha_qcd


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


      arvet3=-(b1**nxp1+b3**nxp3)*(ymax-ymin)*0.5/log(xt2)

      if(msta(19).eq.0) return

      arvet3=arvet3*arveth()


      return

c**** end of arvet3 ****************************************************
      end
c***********************************************************************

      real*8 function arvet4()
      implicit double precision (a-h,o,p,r-z)

c...ariadne function veto factor version 4


c...determine the acceptance factor for chosen x_t^2 and y
c...suitable for gluon emission with running alpha_qcd


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


      arvet4=(b1**nxp1+b3**nxp3)*(ymax-ymin)*0.5/yint

      if(msta(19).eq.0) return

      arvet4=arvet4*arveth()


      return

c**** end of arvet4 ****************************************************
      end
c***********************************************************************

      real*8 function arvet5()
      implicit double precision (a-h,o,p,r-z)

c...ariadne function veto factor version 5

c...determine the acceptance factor for chosen x_t^2 and y
c...suitable for q-qbar emission


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


      arvet5=((1.0d0-b3+y3)**2+(1.0d0-b2+y2)**2)*xt*
     $         (exp(-ymin)-exp(-ymax))/yint

      return

c**** end of arvet5 ****************************************************
      end
c***********************************************************************

      real*8 function arveth()
      implicit double precision (a-h,o,p,r-z)

c...ariadne function heavy veto factor

c...extra acceptance factor for heavy dipoles


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/


      arveth=0.0
      bx1=1.0-b1+y1-y3
      bx3=1.0-b3+y3-y1
      if(b2.ge.1.0.or.bx1.le.0.or.bx3.le.0) return
      bxm=bx1/bx3
      arveth=1.0-(y1*bxm+y3/bxm)/(1.0-b2)

      return

c**** end of arveth ****************************************************
      end


c***********************************************************************
c $id: artune.f,v 0.4 1992/02/14 11:17:37 lonnblad exp $

      subroutine artune(set)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine tune

c...sets parameters and switches in ariadne and other programs which
c...ariadne runs with.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /ludat1/ mstu(200),paru(200),mstj(200),parj(200)
      save /ludat1/

      common /leptouC/ cut(14),lst(40),parl(30),x,y,w2,xq2,u
      save /leptouC/
      character set*(*)


      if(set.eq.'delphi') then
        para(1)=0.22
        para(3)=0.6
        para(5)=0.6
        mstj(11)=1
        parj(41)=0.23
        parj(42)=0.34
        parj(21)=0.405
c        write(msta(7),1000) set       ! c by k.k
      elseif(set.eq.'opal') then
        para(1)=0.20
        para(3)=1.0
        para(5)=1.0
        parj(41)=0.18
        parj(42)=0.34
        parj(21)=0.37
c        write(msta(7),1000) set  ! c by k.K
      else
        write(msta(7),1010) set
      endif

 1000 format('parameters and switches initialized using the "',a,
     $     '" tuning set')
 1010 format('tuning set "',a,'" does not exist. parameters and',
     $     ' switches retains their default value')

      return

c**** end of artune ****************************************************
      end
c***********************************************************************
c $id: arprda.f,v 0.2 1992/01/27 16:03:19 lonnblad exp $

      subroutine arprda
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine print data

c...prints out parameters and switches used in ariadne.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ardat1/ para(40),msta(40)
      save /ardat1/


      write(msta(7),*)
      write(msta(7),1000)
      do 100 i=1,20
        write(msta(7),1010) i,msta(i),msta(i+20),para(i),para(i+20)
 100  continue
      write(msta(7),*)

 1000 format(10x,'parameters and switches used by ariadne:',/,/,
     $     '         i   msta(i) msta(i+20)   para(i) para(i+20)',/)
 1010 format(2i10,i11,3x,2g11.3)

      return

c**** end of arprda ****************************************************
      end
c***********************************************************************
c $id: archki.f,v 0.6 1992/03/12 12:09:11 lonnblad exp $

      subroutine archki(id,iok)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine check kinematics

c...checks if the generated emission for dipole id (or current dipole
c...if id=0) is kinematically allowed.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /ardat1/ para(40),msta(40)
      save /ardat1/

      common /arint1/ bc1,bc3,bzm,bzp,bp1,bm1,bp3,bm3,
     $                b1,b2,b3,xt2,xt,y,qq1,qq3,ne1,ne3,
     $                s,w,c,cn,alpha0,xlam2,iflg,
     $                xt2mp,xt2me,xt2m,xt2c,xts,xt3,xt1,
     $                yint,ymax,ymin,
     $                y1,y2,y3,sy1,sy2,sy3,ssy,
     $                ae1,ae3,nxp1,nxp3,fq1,fq3
      save /arint1/

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardips/ bx1(maxdip),bx3(maxdip),pt2in(maxdip),
     $                sdip(maxdip),ip1(maxdip),ip3(maxdip),
     $                aex1(maxdip),aex3(maxdip),qdone(maxdip),
     $                qem(maxdip),irad(maxdip),istr(maxdip),idips
      save /ardips/

      common /ardat2/ pqmas(10)
      save /ardat2/

      iok=0
      if(id.ne.0) then
        iflg=irad(id)
        ne1=iex(ip1(id))
        ne3=iex(ip3(id))
        qq1=qq(ip1(id))
        qq3=qq(ip3(id))
        s=sdip(id)
        w=sqrt(s)
        sy1=bp(ip1(id),5)/w
        sy3=bp(ip3(id),5)/w
        sy2=0.0
        if(iflg.ne.0) sy2=pqmas(abs(iflg))/w
        ssy=sy1+sy2+sy3
        y1=sy1**2
        y2=sy2**2
        y3=sy3**2
        bzp=0.5*(1.0+y1-y3+sqrt(1.0+(y1-y3)**2-2.0*(y1+y3)))
        bzm=0.5*(1.0+y3-y1+sqrt(1.0+(y1-y3)**2-2.0*(y1+y3)))
        b1=bx1(id)
        b3=bx3(id)
        ae1=aex1(id)
        ae3=aex3(id)
        bp1=(1.0-ae1)*bzp
        if(bp1.le.sy1) then
          bp1=0.0
          bm1=0.0
        else
          bm1=y1/bp1
        endif
        bm3=(1.0-ae3)*bzm
        if(bm3.le.sy3) then
          bm3=0.0
          bp3=0.0
        else
          bp3=y3/bm3
        endif
      endif

      qrg=(msta(17).ne.0)
      qng=(msta(17).eq.1.and.msta(16).gt.0.and.
     $     ((qq1.and.ne1.eq.0).or.(qq3.and.ne3.eq.0)))
      qrg=(qrg.and.(.not.qng))

      if(iflg.eq.0.and.(ne1.gt.0.or.ne3.gt.0).and.
     $     (bp1.gt.0.0.or.bm3.gt.0.0).and.qrg) then
        az1=1.0-bp1-bp3
        az3=1.0-bm1-bm3
        if(az1.le.0.0) return
        if(az3.le.0.0) return
        y1a=y1/(az1*az3)
        if(bp1.gt.0.0) y1a=0.0
        y3a=y3/(az1*az3)
        if(bm3.gt.0.0) y3a=0.0
        be1=0.5*(1.0-(1.0-b1+y1-y3)/az1+y1a-y3a)
        be3=0.5*(1.0-(1.0-b3+y3-y1)/az3+y3a-y1a)
        be2=1.0-be1-be3
        bp1a=be1**2-y1a
        bp2a=be2**2-y2
        bp3a=be3**2-y3a
        if(2.0*(bp1a*bp2a+bp2a*bp3a+bp3a*bp1a).le.
     $       (bp1a**2+bp2a**2+bp3a**2)) return
        if(be1.lt.sqrt(y1a)) return
        if(be2.lt.sy2) return
        if(be3.lt.sqrt(y3a)) return
        pt21=b3
        pt23=b1
        if(bp1.gt.0.0.and.bm3.gt.0.0.and.msta(17).ge.2) then
          bp2=1.0-b1+y1-y3
          bm2=1.0-b3+y3-y1
          pt21=(bm2*bp2**3)/(1.0-bp1-bp2)**2
          pt23=(bp2*bm2**3)/(1.0-bm3-bm2)**2
        endif
        if((bp1.gt.0.0.and.bm3.gt.0.0.and.pt21.ge.pt23).or.
     $       (bm3.gt.0.0.and.bp1.le.0.0)) then
          bm3=0.0
          bp3=0.0
        else
          bp1=0.0
          bm1=0.0
        endif
        az1=1.0-bp1-bp3
        az3=1.0-bm1-bm3
        if(az1.le.0.0) return
        if(az3.le.0.0) return
        y1a=y1/(az1*az3)
        if(bp1.gt.0.0) y1a=0.0
        y3a=y3/(az1*az3)
        if(bm3.gt.0.0) y3a=0.0
        be1=0.5*(1.0-(1.0-b1+y1-y3)/az1+y1a-y3a)
        be3=0.5*(1.0-(1.0-b3+y3-y1)/az3+y3a-y1a)
        be2=1.0-be1-be3
        bp1a=be1**2-y1a
        bp2a=be2**2-y2
        bp3a=be3**2-y3a
        if(2.0*(bp1a*bp2a+bp2a*bp3a+bp3a*bp1a).le.
     $       (bp1a**2+bp2a**2+bp3a**2)) return
        if(be1.lt.sqrt(y1a)) return
        if(be2.lt.sy2) return
        if(be3.lt.sqrt(y3a)) return
      else
        be1=0.5*b1
        be3=0.5*b3
        be2=1.0-be1-be3
        bp1a=be1**2-y1
        bp2a=be2**2-y2
        bp3a=be3**2-y3
        if(2.0*(bp1a*bp2a+bp2a*bp3a+bp3a*bp1a).le.
     $       (bp1a**2+bp2a**2+bp3a**2)) return
        if(be1.lt.sy1) return
        if(be2.lt.sy2) return
        if(be3.lt.sy3) return
      endif

      iok=1

      return

c**** end of archki ****************************************************
      end
c***********************************************************************
c $id: arexma.f,v 0.1 1992/02/11 10:36:11 lonnblad exp $

      subroutine arexma(i1,i3)
      implicit double precision (a-h,o,p,r-z)

c...ariadne subroutine make extended partons massless

c...makes extended partons massless.


      parameter(maxdip=500,maxpar=500,maxstr=100)

c      implicit double precision (d)
c      implicit double precision (b)
      implicit logical (q)

      common /arpart/ bp(maxpar,5),ifl(maxpar),iex(maxpar),qq(maxpar),
     $                idi(maxpar),ido(maxpar),ino(maxpar),ipart
      save /arpart/

      common /ardat1/ para(40),msta(40)
      save /ardat1/


      if(msta(31).gt.0) return
      if(iex(i1).eq.0.and.iex(i3).eq.0) return
      dpe1=bp(i1,4)
      dpe3=bp(i3,4)
      dpe=dpe1+dpe3
      dpx1=bp(i1,1)
      dpx3=bp(i3,1)
      dbex=(dpx1+dpx3)/dpe
      dpy1=bp(i1,2)
      dpy3=bp(i3,2)
      dbey=(dpy1+dpy3)/dpe
      dpz1=bp(i1,3)
      dpz3=bp(i3,3)
      dbez=(dpz1+dpz3)/dpe
      call arobo2(0.0d0,0.0d0,-dbex,-dbey,-dbez,i1,i3)

c...calculate rotation angles but no need for rotation yet
      px=bp(i1,1)
      py=bp(i1,2)
      pz=bp(i1,3)
      phi=ulangl(px,py)
      the=ulangl(pz,sqrt(px**2+py**2))
      call arobo2(0.0d0,-phi,0.0d0,0.0d0,0.0d0,i1,i3)
      call arobo2(-the,0.0d0,0.0d0,0.0d0,0.0d0,i1,i3)
      if(iex(i1).gt.0) bp(i1,5)=0.0
      if(iex(i3).gt.0) bp(i3,5)=0.0
      be=bp(i1,4)+bp(i3,4)
      bp(i1,4)=0.5*(be**2+bp(i1,5)**2-bp(i3,5)**2)/be
      bp(i3,4)=be-bp(i1,4)
      bp(i1,3)=sqrt(bp(i1,4)**2-bp(i1,5)**2)
      bp(i3,3)=-bp(i1,3)
      bp(i1,2)=0.0
      bp(i3,2)=0.0
      bp(i1,1)=0.0
      bp(i3,1)=0.0

      call arobo2(the,phi,dbex,dbey,dbez,i1,i3)

      return

c**** end of arexma ****************************************************
      end
