c      *******************************************************
c            generate 2 leading ptcls
c      *******************************************************
      subroutine cs2lp(proj, trgt, icon)
c           proj: /ptcl/ Input. projectile in lab
c
c           trgt: /ptcl/ Input. target in lab
c           icon :   integer. Output. if 0, ok.
c                             if non 0, sampling failed after
c                             20 trials. or energy is too low
c      *** Note ***
c    After this call, leading particle infomation is set in
c    variables in ../Zevhnv.h.
c  Projectile 
       implicit none

#include  "Zptcl.h"
#include  "Zmass.h"
#include  "Zevhnv.h"

       logical first/.true./
       save first



c      ***************
       external cblkEvhnp           ! block common name
c      ****************
       record /ptcl/ proj, trgt
       integer icon
c
       record /fmom/ gc
       real*8 xpmin, xpmax, xtmin, xtmax, c2, dest1,
     *        dest2, den

       real*8 maslimit2   ! missing mass is too small or not    
       integer maxtry, count
       parameter (maxtry = 20, maslimit2 =(maspic*1.1)**2 )
       character*70 msg
       logical noferm    ! if target is at rest, no Fermi momentum.

       if(first) then
          call cinippx  ! make sampling table for pp->p+x
          call cinipipx
          first = .false.
       endif
c
       count = 0
       icon = 0
       Pjlab = proj
       Tglab = trgt
       noferm = trgt.fm.p(4) .eq. trgt.mass


c          get cms equivlent mass and 4 momentum  
       call cgeqm(Pjlab, Tglab, Cmsp, icon)
       if(icon .ne. 0) then
          write(msg, *) ' cms cannot be formed in cs2lp; proj and ',
     *                'target are '
          call cerrorMsg(msg, 1)
          call cprptc(Pjlab, 1)
          call cprptc(Tglab, 1)
          stop 9999
       endif   
c          get Lorentz factor of cms
       call cgetlf(Cmsp,  gc)
c          boost pj into cms.
       call cbst0(1, gc, Pjlab, Pjcms)     
c            boost target into cms
       call cbst0(2, gc, Tglab, Tgcms)
c          boost proj into target rest system
       if(noferm) then
           Pjtatr = Pjlab
       else    
           call cbst1(1, Tglab, Pjlab, Pjtatr)       
       endif
c            boost target into projectile rest system
       call cbst1(1, Pjlab, Tglab, Tgpatr )
c            get possible max and min x of leading particles
       call cgextx(xpmin, xpmax, xtmin, xtmax)
       if(xpmin .ge. xpmax .or. xtmin .ge. xtmax) then
          icon = 1
          return
       endif

c      ----------------------------------------------
c      *** until loop*** until virtual ptcl that balances
c                              two outgoing leadings become
c                              timelike. 
      do while (.true.)
c          *** until loop***  generation of projectile and target leading
c             ptcls.
          do while (.true.)
c               sample 1 leading ptcl and set it in 
c                  Rpjtatr(target at rest).  Note Rpjtatr is
c                  should be rotated later   
              call cslp(Pjtatr, xpmin, xpmax, Rpjtatr)
c               sample recoil target  and set it in Rtgpatr
c               the same note as above.
              call cslp(Tgpatr, xtmin, xtmax, Rtgpatr)
c                    some dirty trick to make the strange evnet less
c                    (may not be needed)
c                  make target pt colinear with projectile Pt
c                  while keeping the magnitude as it is
              c2=Rtgpatr.fm.p(1)**2 + Rtgpatr.fm.p(2)**2
              den=sqrt(( Rpjtatr.fm.p(1)**2 +  Rpjtatr.fm.p(2)**2)/c2 )
              Rtgpatr.fm.p(1) = Rpjtatr.fm.p(1)/den
              Rtgpatr.fm.p(2) = Rpjtatr.fm.p(2)/den
c     If the following two call's were omitted and equivalent ones
c     were placed inside 'cslp', 
c         Absoft compile fials to compile it; it shows
c/home01/kasahara/f/cosmos/sun/Particle/Event/Hncol/cs2lp.f -o cs2lp.o
c error on line 256 of /tmp/temp10493.f: synch error in intermediate code
c         This is not an  ordinary error.  Resolution is give by
c         putting a dummy line relating to rcord /ptcl/Rtgpart
c                rotate   recoils so that they are seen in
c                in a frame where Pjatr or Tgpatr is seen.
             call crot3vec(Pjtatr.fm, Rpjtatr.fm, Rpjtatr.fm)
             call crot3vec(Tgpatr.fm, Rtgpatr.fm, Rtgpatr.fm)
c               next is a dummy substitution to avoid stupid Absoft
c               compiler error.
c **          Rpjtatr = Rpjtatr
c                boost it to lab
             if(noferm) then
                Rpjlab = Rpjtatr
             else
                call cibst1(1, Tglab, Rpjtatr, Rpjlab)
             endif   
c                   boost to cms             
             call cbst1(1, Cmsp, Rpjlab, Rpjcms)
c                  energy libarated by projectile in cms
             dest1= Pjcms.fm.p(4) - Rpjcms.fm.p(4)
c
c                boost to lab 
             call cibst1(1, Pjlab, Rtgpatr, Rtglab)
c                   boost to cms
             call cbst1(1, Cmsp, Rtglab, Rtgcms)
c                  energy libarated by target in cms
             dest2=Tgcms.fm.p(4) - Rtgcms.fm.p(4)
             if(dest1 .gt. maspic .or. dest2 .gt. maspic)  goto 5
             count = count + 1
             if( count .gt. maxtry) then
                icon =1
                goto 5
             endif   
          enddo
    5     continue
c           form a missing mass particle
          Missingp.fm.p(1) = - (Rpjcms.fm.p(1) + Rtgcms.fm.p(1))
          Missingp.fm.p(2) = - (Rpjcms.fm.p(2) + Rtgcms.fm.p(2))
          Missingp.fm.p(3) = - (Rpjcms.fm.p(3) + Rtgcms.fm.p(3))
          Missingp.fm.p(4) = Cmsp.mass - Rpjcms.fm.p(4) - Rtgcms.fm.p(4)
          Missingp.mass = Missingp.fm.p(4)**2
     *     -(Missingp.fm.p(1)**2 + Missingp.fm.p(2)**2 +
     *       Missingp.fm.p(3)**2)
          if(Missingp.mass .lt. maslimit2 ) then
               count = count + 1
               if(count .gt. maxtry)then
                  icon = 1
                  goto 10
               endif   
          else
               Missingp.mass = sqrt (Missingp.mass)
               goto 10
          endif
      enddo
   10 continue
      end
c      ****************************************
       subroutine cgextx(xpmin, xpmax, xtmin, xtmax)
c        get extream of recoil x, defined as the ratio 
c        of incoming and outgoing leading partilce,
c        where the counter  particle is at rest.
c  xpmin:  real*8. Output. minimum x of projectile.
c  xpmax:   //             maximum //
c  xtmin:  real*8. Output. minimum x of target
c  xtmax:   //             maximum //
c
c        min is when projectile after coll. is at rest in cms.
c        max is when projectile after coll. loses mass of 1 pion
c
       implicit none
c

#include  "Zptcl.h"
#include  "Zmass.h"
#include  "Zevhnv.h"
c
       real *8  xpmin, xpmax, xtmin, xtmax
c
       record /ptcl/ rest   ! resting particle

       record /ptcl/ temp, temp2, temp3
c            
       rest.fm.p(1)=0.
       rest.fm.p(2)=0.
       rest.fm.p(3)=0.
       rest.mass=Pjlab.mass
       rest.fm.p(4) = rest.mass
c        min of projectile. 
c           boost stopped proj in cms into lab.
       call cibst1(1, Cmsp, rest, temp)
       temp.mass = rest.mass
c         boost it to target rest system
       call cbst1(1, Tglab, temp, temp2)
       xpmin= temp2.fm.p(4)/Pjtatr.fm.p(4)
c        max
c         get proj. cms energy - mass of pion
       temp=Pjcms
       temp.fm.p(4) =max(temp.fm.p(4) - maspic, Pjlab.mass)
       call cadjm(temp, temp)  ! adjust momentum along with E
c         boost it into lab
       call cibst1(1, Cmsp, temp, temp2)
       temp2.mass=Pjlab.mass
c         boost to target rest system
       call cbst1(1, Tglab, temp2, temp3)
       xpmax= temp3.fm.p(4)/Pjtatr.fm.p(4)
c                       ............
c        max and min x  of target
c            min
c          boost stopped  target in cms into lab system
       rest.mass = Tglab.mass
       rest.fm.p(4) = rest.mass
       call cibst1(1, Cmsp, rest, temp)
       temp.mass = Tglab.mass
c          boost to projectile rest system
       call cbst1(1, Pjlab, temp, temp2)
       xtmin = temp2.fm.p(4)/Tgpatr.fm.p(4)
c            max
c          get cms energy - mass of pion
       temp = Tgcms
       temp.fm.p(4) = max(temp.fm.p(4) - maspic, Tglab.mass)
c          boost it in cms  into lab
       call cibst1(1, Cmsp, temp,  temp2)
       temp2.mass = Tglab.mass
c          boost it to projectile rest system.
       call cbst1(1, Pjlab, temp2, temp3)
       xtmax =  temp3.fm.p(4)/Tgpatr.fm.p(4)
      end
c         

c     *****************************************************************
c     *                                                               *
c     * cslp:    leading ptcl sampling
c     *                                                               *
c     *****************************************************************
c
c
       subroutine cslp(p, akmin, akmax,  a)
c           p:  structure /ptcl/. Input.  Particle
c               given at the rest system of the counter ptcl.
c        akmin:  real*8. Input. min of x of the leading ptcl
c        akmax:  real*8. Input. max of x o//
c            a:  structure /ptcl/. Output.  sampled leading ptcl.
c          Note that the momentum of "a" is defined in
c          a system whose z-axis is the direction of p.fm
c          so that you have to rotate it after calling this,
c          if p has non-zero x, y component of momentum.
c
        implicit none


#include  "Zptcl.h"
        record /ptcl/ p, a
        integer nc, icon
        real*8 xp, avpt, ptn, tmsq, u, akmin, akmax
        logical notfirst  
c


        a = p
c
        nc=0
c       *** until loop*** 
        do while (.true.)
c            sample leading ptcl pt: avpt. output <pt>
c                                    ptn.  output sampled pt

           call cslppt(p, avpt,  ptn)


c            sample leading particle xp with  pt
           tmsq=ptn**2 + p.mass**2
           call cslpx(p, tmsq, akmin, akmax,  xp, notfirst, icon)


           if(icon .eq. 0 .and.  xp-akmin .lt. .2 ) then
c                  xp is small; reject some large pt 
               if(ptn .gt. avpt) then
                   call rndc(u)
                   if(u .gt. avpt/ptn) then
                       icon=1
                   endif
               endif
           endif
           nc=nc+1
           if(icon .eq. 0 .or. nc .gt. 20) goto 5
        enddo
    5   continue
        if(nc .gt. 20) then
           call cerrorMsg(' nc>20 in cslp', 0)
        endif
        a.fm.p(4)=p.fm.p(4)*xp
c           set pt tentatively in pt
        a.fm.p(3) = ptn
c           convert it to ptx, pty
        call csptxy(a,  1)
c               set pz
        a.fm.p(3) = sqrt(a.fm.p(4)**2 - a.mass**2 - ptn**2)
c         fix chacge after collision
        if(notfirst) then
c           keep the same charge if the 2nd,3rd coll. inside A.
c           a.charge = p.charge  ! not needed since a = p
        else
           call cfclp(p, xp, a)
        endif
c          this may be needed if crot3vec is not called
c          after cslp; 
c        call crot3vec(p.fm, a.fm, a.fm)
      end
      subroutine cxtuln(x, ux)
c           get normalized integral (from 0 to x) for given x
c           of leading ptcl (pp-->p)
c           u for x=0 to 1 step .01
         implicit none
         integer i
         real*8 x, ux

#include "Zcinippxc.h"

c
         i=x*nx+1.

         if(i .eq. n) then
             ux=1.
         else
c            ux=(intendndx(i+1)-intendndx(i))*nx * (x - (i-1)*dx)
c             + intedndx(i)
             ux=(intendndx(i+1)-intendndx(i))* (x*nx - i+1) +
     *           intendndx(i)
         endif
      end
      subroutine cxtulnpi(x, ux)
c           get normalized integral (from 0 to x) for given x
c           of leading pi (pp-->p)
c           u for x=0 to 1 step .01
         implicit none
         integer i
         real*8 x, ux

#include "Zcinippxc.h"

c
         i=x*nx+1.

         if(i .eq. n) then
             ux=1.
         else
             ux=(intendndx2(i+1)-intendndx2(i))* (x*nx - i+1) +
     *           intendndx2(i)
         endif
      end
c     *****************************************************************
c     *                                                               *
c     * cfclp:   fix charge of a leading particle
c     *                                                               *
c     *****************************************************************
c                            =   =   =   =
c
        subroutine cfclp(pj, xp, p)
c
        implicit none
c
c----        include  '../../Zptcl.h'
#include  "Zptcl.h"
c----        include  '../../Zcode.h'
#include  "Zcode.h"
c----        include  '../Zevhnp.h'
#include  "Zevhnp.h"
c
        record /ptcl/ pj, p
        real*8 xp
c
        real*8 rf, u
        integer k0
cc        character*70  msg
c        
        k0=pj.code
        call rndc(u)
c            branch by ptcl kind
        if(k0 .eq. kpion) then
c                      pion; more inelastic one is 
c                           more likely chargeexchanged
           rf=sqrt(1.-xp)
c            if(u .gt. Cepic0*rf) then
c          if(u .gt. 0.3* sqrt(rf) ) then
          if(u .gt. 0.35* rf ) then
c                no charge exc.
             p.charge = pj.charge
          else
             if(pj.charge .eq. 0) then
c                   0--> + or -
                call rndc(u)
                if(u .lt. .5) then
                   p.charge = 1
                else
                   p.charge = -1
                endif
             else
c                 charge-->0 or opposite charge
                call rndc(u)
                if(u .lt. rf*0.30) then
                   p.charge = -pj.charge
                else
                   p.charge = 0
                endif
             endif
          endif
      elseif(k0 .eq. kkaon) then
c                                         kaon
         rf=sqrt(1.-xp)
         if(u .gt. 0.35*rf) then
              p.charge = pj.charge
         else
              p.charge = 0
              call rndc(u) 
              p.subcode = pj.subcode
         endif
      elseif(k0 .eq. knuc) then
c                                        nucleon
         rf=sqrt(sqrt(1.-xp))
         if(u .gt. Ceneuc*rf) then
c              same charge
              p.charge = pj.charge
         else
              if(pj.charge .eq. 0) then
                  if(pj.subcode .eq. regptcl) then
                      p.charge = 1
                  else
                      p.charge = -1
                  endif
              else
                  p.charge = 0
              endif
         endif
      elseif(k0 .eq. krho) then
         p.charge = 0
      elseif(k0 .eq. komega)then
         p.charge = 0
      elseif(k0 .eq. kphi) then
         p.charge = 0
      elseif(k0 .eq. keta) then
         p.charge = 0
      else
c         write(msg,*) ' code=',k0,' undef. in cfclp'
c         call cerrorMsg(msg, 1)
c           same charge as input
      endif
      end
      subroutine cslpx(pj,  tmsq, akmin, akmax,  x, notfirst, icon)
c           sampling of x 
c            pj: structure /ptcl/. Input.
c          tmsq: input.incident transverse mass square after collision.
c         akmin: input. min x allowed
c         akmax: input. max x allowedn
c             x: output.  sampled x
c       notfirst: output.   becomes t if this is 2nd, 3rd coll. in A
c          icon:  0  x sampled
c                 1  x not sampled. kinematically impossible.
c    **** note ***  If the target is a nucleus and the collision is
c    2nd, 3rd , ...  times inside the nucleus, the x distribution is
c    changed to  x**SucPw dx to have smaller inelasticity.  
c    (SucPw=1.5 is default;
c     this corressponds to alfa=2.5 to Date et al's paper.
c    (PRD1985,vol.32. 619)  This should be 
c    managed by calling cslpx2
c
      implicit none
#include "Zcode.h"
#include  "Zptcl.h"
#include  "Zmass.h"
#include "Zcinippxc.h"
#include "Zevhnp.h"

       record /ptcl/ pj
       real*8 tmsq, x,  akmin, akmax
       real*8 umin, umax, temp1, temp2
       integer i, icon
       real*8 u
       logical lessInela/.false./, makeless, notfirst
       save lessInela


c

         if(pj.fm.p(4)**2 .le. tmsq) then
             icon=1
         elseif(.not. lessInela) then
c             cxtuln(x0, ans) ; ans= integral of dn/dx from 0, x0
            if(pj.code .ne. knuc) then
               call cxtulnpi(akmin, umin)
               call cxtulnpi(akmax, umax)
            else
               call cxtuln(akmin, umin)
               call cxtuln(akmax, umax)
            endif
c                  uniform random number should be between
c                  umin and umax

            call rndc(u)
            u=(umax-umin)*u + umin
            i=u*nx +1
            if(pj.code .eq. knuc) then
               x=(ppsx(i+1) - ppsx(i))*nx*(u- (i-1)*dx)
     *              + ppsx(i)
            else
               x=(pipsx(i+1) - pipsx(i))*nx*(u- (i-1)*dx)
     *              + pipsx(i)
            endif
         else
            call rndc(u)
            if(pj.code .ne. knuc) then
c                for mesons, make more inelastic
               temp1 = SucPw + 0.5
            else
               temp1 = SucPw + 1.
            endif
            temp2 = akmin**temp1
            x = ( (akmax**temp1 - temp2 )*u + temp2 )**(1./temp1)
         endif
         if((pj.fm.p(4)*x)**2 .le. tmsq) then
            icon=1
         else
            icon=0
         endif
         notfirst = lessInela
         return
c     ************ call this before 2nd, 3rd coll. inside nucleus
c                  with .true.  and  after that, call with .false.
      entry  cslpx2(makeless)
c     *************
         lessInela = makeless
      end
c     *****************************************************************
c     *                                                               *
c     * cslppt:  samples leading ptcl pt                              *
c     *                                                               *
c     *****************************************************************
c
c
c
        subroutine cslppt(pj, avpt,  ptn)
        implicit none
c
c       pj: strucutre /ptcl/. Input. Projectile particle at
c                                    the rest system of target.
c     avpt: real*8.  Output.  average pt at this energy.
c      ptn: real*8.  Output.  sampled pt in GeV.
c
c----       include  '../../Zptcl.h'
#include  "Zptcl.h"
c
       record /ptcl/ pj
       real*8 avpt, ptn, pw
c
      avpt=226.d-3* pj.fm.p(4)**0.1d0         ! energy is GeV

      pw=2.59d0/pj.fm.p(4)**0.1d0 
c          pt**pw * epx(-pt)dpt  type
      call ksgmrm(pw, avpt,  ptn)
      end
