c       test ksplandau
c      integer i
c      real*8  b, c, x
c
c      b =1.
c      c =0.20
c      do i= 1, 100000
c         call ksplandau(b, c, x)
c         write(*,*) sngl(x)
c      enddo
c      end

c       ksplandau.f
c  samples a random variable x following the
c  psudo-Landau energy loss distribution 
c  which is
c       exp(-1/2(y +exp(-y)) dy
c  where  y=(x-b)/c.
c
c The peak of the distribution is at x=b.
c
c  Method:  
c     let z=exp(-y).  
c   Then,  dz=-zdy.
c     exp(-1/2(y +exp(-y)) dy = exp(-y)^1/2 exp(-1/2exp(-y))dy
c    =   z^1/2 exp(-z/2) /z dz 
c    =   z^(-1/2)exp(-z/2)dz
c  So, sample z from  this distribution.  get y= -log(z).
c
c 
      subroutine ksplandau(b, c, x)
      implicit none
      real*8  b, c, x
      
      real*8  y, z
      

      call ksgmrs(-0.5d0, 2.d0, z)

      y = -log(z)
      x = c*y + b
      end

