#include "../cmain.f"
#include "chookHybAS.f"
#include "../ctemplCeren.f"
c  *************************************** hook for Beginning of a Run
c  * At this moment, all (system-level) initialization for this run
c  * has been ended.  After this routine is executed, the system goes into the
c  * event creation loop.
c  *
      subroutine chookBgRun
      implicit none
#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Zprivate.h"
      integer icon
 
      character*120 filen
      character*120  fn
      integer ios, klena
      logical ex

c         If you feel writing the parameters on stderr is
c         a bother, comment out the next or
c         use other device than ErrorOut.
c         Also you may comment out all output routines below.

c            namelist output
      call cwriteParam(ErrorOut, 1)
c            primary information
      call cprintPrim(ErrorOut)
c            observation level information
      call cprintObs(ErrorOut)
c       for nu output / sysout or other
      call cqUhooki(2, nu_dev)
      if(  nu_dev .gt. 0 .and. nu_dev .ne. 6 ) then
         call cqUHookc(1, filen)
         call cqUhooki(1, binout)
c          nu file
         call cgetfname(filen, fn)

         inquire(file=fn(1:klena(fn)),  exist=ex)
         if(binout .eq. 1) then
            open(nu_dev, file=fn,
     *           iostat=ios, access='sequential',
     *           form='unformatted')
         else
            open(nu_dev, file=fn,
     *           iostat=ios, access='sequential',
     *           form='formatted')
         endif         
         if(ios .ne. 0) then
            write(0,*) fn, ' cannot be opened'
            stop 9999
         endif

         if(ex .and. Cont ) then
cc           skip to the EOF
            do while(.true.)
               if(binout .eq. 0) then
                  read(nu_dev, *, end=100) 
               else
                  read(nu_dev, end=100)
               endif
            enddo
         endif
 100     continue
      elseif(nu_dev .eq. 6) then
         binout = 0
      endif

      end


c     *********************************** hook for Beginning of  1 event
c     *  All system-level initialization for 1 event generation has been
c     *  eneded at this moment.
c     *  After this is executed, event generation starts.
c     *
      subroutine chookBgEvent
      implicit none
#include "Ztrack.h"
#include "Zprivate.h"
#include "Zprivate2.h"
      firsttime = .true.
      stored = 0
      end
  

c     ************************************ hook for observation
c     *  One particle information is brought here by the system.
c     *  All information of the particle is in aTrack
c     *
      subroutine chookObs(aTrack, id)
c
c     Note that every real variable is in double  precision so
c     that you may output it in sigle precision to save the memory.
c     In some cases it is essential to put it in sigle (say,
c     for gnuplot).
c 
      implicit none
#include "Zcode.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zprivate2.h"

      integer id  ! input.  1 ==> aTrack is going out from
c                                 outer boundery.
c                           2 ==> reached at an observation level
c                           3 ==> reached at inner boundery.

c                                below call will be realized only if
c                                DETAILED_TRACKINg == 1
c                                the enrgy can be changed  to discard
c                                the particle
c                           4 ==> ptcl is going to interact at this
c                                 point
c                           5 ==> ptcl is going to die at this point
c                           6 ==> ptcl is being discarded because path >
c                                 limit.  
c                           7 ==> ptcl angle relative to the parent is
c                                 to large (see BackAnglLimit)
c                             (Ondimentional mode dose not invoke this)
c                           8 ===>ptcl moved a step.
      record /track/ aTrack  ! input.  concerned track.
                             ! input/output. for id>3.  The use may
                             !     give very low energy to discard this
                             !     particle.
      logical record
c
c
c
c        take memo of charged particles which have passed
c        the top surfarce (380km) once or more
c////////////
c      if(id .ne. 8) then
c         write(*,*) id,  aTrack.where, aTrack.pos.height,
c     *           aTrack.info, aTrack.p.code
c      endif
c////////////
      if( aTrack.p.charge .ne. 0 ) then
c          1 ry
         record = ( aTrack.where .le. 2 .and. aTrack.label .eq. 0 )
         if(.not. record) then
c             once crossed observation depth upwards
            record = aTrack.info .gt. 0 .and. id .le. 7 
         endif
      else
         record = .false.
      endif
           
      if(record) then
c           store typical quantities
         stored = stored + 1
         if( stored .gt. nstore ) then
            call cerrorMsg('nstore is too small',0)
         endif
         if(id .eq. 2) then
            where(stored) = aTrack.where
         else
            where(stored) = -id
         endif
         code(stored) = aTrack.p.code
         charge(stored) = aTrack.p.charge
         subcode(stored) = aTrack.p.subcode
         label(stored) = aTrack.label
         kenergy(stored) = aTrack.p.fm.p(4)-aTrack.p.mass
         x(stored) = aTrack.pos.xyz.r(1)
         y(stored) = aTrack.pos.xyz.r(2)
         z(stored) = aTrack.pos.xyz.r(3)
         wx(stored) = aTrack.vec.w.r(1)
         wy(stored) = aTrack.vec.w.r(2)
         wz(stored) = aTrack.vec.w.r(3)
         zenith(stored) = aTrack.vec.coszenith
         time(stored) = aTrack.t
         ntimes(stored) = aTrack.info
      elseif( id .eq. 8 ) then
         if(aTrack.p.charge .eq. 0) then
            if(aTrack.p.code .eq. kphoton .or.
     *        aTrack.p.code .eq. knuc ) then
               if( aTrack.pos.height .gt. 70.0d3 .and.
     *              aTrack.vec.coszenith .lt. 0.) then
c                       photons and nutrons going upwards at
c                       very high altitudes, discarde it by giving
c                       very low energy
                  aTrack.p.fm.p(4) = 1.d-5 + aTrack.p.mass
                  aTrack.p.subcode = regptcl ! make it ordinary ptcl
                                           ! anti n can anihilate and
                                           ! not discarded even 0 energy
                                           !  so make it reg. ptcl.
               endif
            endif
         endif
      endif
c         you may need in some case other information such as
c       aTrack.p.subcode   ! sub code of the particle integer*2
c       aTrack.p.mass      ! mass 
c       aTrack.wgt         ! weight of the particle (may not be 1. if
                           ! ThinSampling =T)
c       aTrack.p.fm.p(1)      ! momentum x component.  Note. Momentum is
c                            given in the  Earth xyz system.

c       aTrack.p.fm.p(2)      !          y
c       aTrack.p.fm.p(3)      !          z

      end

c    *********************************** hook for end of 1 event
c    * At this moment, 1 event generation has been ended.
c    *
      subroutine chookEnEvent

      implicit none
#include "Zglobalc.h"
#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include "Zprivate2.h"
#include "Zprivate.h"
#include "Zcode.h"

      record /track/ inci, coll
      record /coord/ angle
      integer i, j, jmax, massn
      real maxt

      call cqIncident(inci, angle)
      call cqFirstIPI(coll)

      if(inci.p.code .eq. kgnuc ) then
         massn = inci.p.subcode
      else
         massn = 1
      endif


      write(*,
     * '(i7,i4,i4,i3,g13.4,3g14.3,4f9.5,3g14.3,4f9.5,f9.1,i6)')
     * EventNo, inci.p.code, inci.p.subcode, inci.p.charge,
     * sngl(inci.p.fm.e-inci.p.mass)/massn,
     * sngl(inci.pos.xyz.x), sngl(inci.pos.xyz.y), 
     * sngl(inci.pos.xyz.z), sngl(inci.vec.w.x), 
     * sngl(inci.vec.w.y),  sngl(inci.vec.w.z),
     * sngl(inci.vec.coszenith), 
     * sngl(coll.pos.xyz.x), sngl(coll.pos.xyz.y),
     * sngl(coll.pos.xyz.z), sngl(coll.vec.w.x),
     * sngl(coll.vec.w.y), sngl(coll.vec.w.z),
     * sngl(coll.vec.coszenith), sngl(coll.pos.depth),
     * stored


c      if(ObserveAS) then
c                   electron size in B approx.
c         write(*, *) (ASObsSites(i).esize, i=1, NoOfASSites)
c                   size weighted age
c         write(*, *) (ASObsSites(i).age,   i=1, NoOfASSites) 
c      endif

      i = 1
      do while ( i .le. stored )
         maxt = time(i)
         maxtime(i) = maxt
         do j = i+1, stored
            if(label(i) .eq. label(j)) then
               maxt = max(maxt, time(j))
            else
               jmax = j -1
               goto 10
            endif
         enddo
         jmax = stored
 10      continue
         do j = i, jmax
            maxtime(j) = maxt
         enddo
         i = jmax + 1
      enddo

      do i = 1, stored
c           albedo which went back over 1st obs. level
        write(*,
     *  '(i2, i3, 2i4, i8, g13.4, 6g14.4, f9.5, 2f10.4, i11)')
     *  where(i),   !  observation level.
     *  code(i),    !  ptcl code.  integer*2.
     *  subcode(i), !  subcode     integer*2
     *  charge(i),  !  charge, 
     *  label(i),   ! label; if this is the same, same ptcl
     *  kenergy(i),  ! kinetic energy in GeV
     *  x(i), y(i), z(i), wx(i), wy(i), wz(i), ! pos. and dir.
     *  zenith(i),   time(i)/c, maxtime(i)/c,   !  zenith
     *  ntimes(i)
      enddo
c         not needed because of stored
c      write(*,*) '0 0 0 0 0 0 0 0 0 0 0 0 0 0'

      if( nu_dev .gt. 0) then
         if(.not. firsttime) then
            if(binout .eq. 1) then
               write(nu_dev) 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            else
               if(nu_dev .eq. 6) then
                  write(*,'("nu_", 11i3)')
     *             0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
               else
                  write(nu_dev,'(11i3)') 
     *             0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
               endif
            endif
         endif
      endif

      end


c     ********************************* hook for end of a run
c     *  all events have been created or time lacks
c     *
      subroutine chookEnRun

      implicit none
#include "Ztrack.h"
#include "Ztrackp.h"
      integer klena
      character*24  tracefile
      character*1  qm/"'"/
      if(Trace .gt. 0 )then
         tracefile = TraceDir(1:klena(TraceDir))//'/trace1'
        write(*, *)
     * '****** Congratulations: Cosmos is now your friend *******'
        write(*, *)
     * '       particle trace data has been created'//
     *     ' in '//tracefile
        write(*, *)
     * '       you can see it by gnuplot: For that, in gnuplot do'
        write(*, *)
     * '       set para'
        write(*, *)
     * '       splot "',tracefile(1:klena(tracefile)),'" w  l'
        write(*, *)
     * '   To see charged particles only, use following '
        write(*, *)  '      splot  "< awk ',qm,' $6 != 0 ; \ '
        write(*, *)  '           NF == 0 ',qm, ' \ '
        write(*, *)  '         ',tracefile(1:klena(tracefile)),
     *       ' " w l '
#ifdef sun4
        write(*, *) ' The last 3 lines should be on 1 line or',
     *  ' you need contination backslash'
#endif
       
        write(*, *)
     * '************      Have a nice day !!      **************'
        endif

      call cerrorMsg('to be continued', 1)
      end
c     ********************************* hook for trace
c     *  This is called only when trace > 60
c     *  User should manage the trace information here.
c     *  If you use this, you may need some output for trace
c     *  at the beginning of 1 event generatio and at the end of  1 event
c     *  generation so that you can identfy each event.
c     *
c     *
      subroutine chookTrace
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsv.h"

      real*4 h1,  h2
c
c    Every time a particle is moved in the atmosphere, this routine is called,
c    if trace > 60. 
c         For a one track segment,
c     TrackBefMove  has  track information at the beginning of the segment.
c     MoveTrack    has   track information at the end of the segment.
c   
c     You can know the  information a track contains in the 
c     chookObs routine. (Note however, no conversion of coordinate
c     has been done.  The values are in the Earth xyz system.)
c     Besides quantities explained there, you can use, for a  given 'track'
c
c     atrack.pos.xyz.x, atrack.pos.xyz.y, atrack.pos.xyz.z    (x,y.z)
c     atrack.pos.radiallen   (distance from the center of the earth)
c     atrack.pos.depth       (vertical depth)
c     atrack.pos.height      (vertical heigth from sea level)  
c

      h1 = TrackBefMove.pos.height- ObsSites(NoOfSites).pos.height
      h2 = MovedTrack.pos.height - ObsSites(NoOfSites).pos.height

      end
c     ********************* this is the hook called when
c       an electron made an interaction.
c
      subroutine chookEInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after an electron made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the electron that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c
c        IntInfArray(ProcessNo).process will have one of
c       'brems', 'mscat', 'bscat',or  'anihi'
c
      end

c     ********************* this is the hook called when
c       a gamma ray made an interaction.
c
      subroutine chookGInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a gamma ray made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the gamma that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c         IntInfArray(ProcessNo).process will have one of
c        'pair', 'comp', 'photoe' or 'photop'
c       
      end

c     ********************* this is the hook called when
c       non e-g particle made an interaction.
c
      subroutine chookNEPInt(never)
            implicit none
#include  "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zearth.h"
#include  "Zprivate.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a non-e-g particle  made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the particle that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
      record /track/aTrack
      real*8 el
      integer icon

c     
      integer i, n, nucode
c      drop neutrinos
      n = 0

      do i = 1, Nproduced
         if(Pwork(i).code .eq. kneue .or.
     *      Pwork(i).code .eq. kneumu ) then
            if(nu_dev .gt. 0) then
               aTrack = MovedTrack
               call cresetDirec(aTrack)
               call kxplsph( aTrack.pos.xyz.x, 
     *                    aTrack.pos.xyz.y,
     *                    aTrack.pos.xyz.z,
     *                    aTrack.vec.w.r(1), 
     *                    aTrack.vec.w.r(2),
     *                    aTrack.vec.w.r(3),
     *              Eradius, el, icon)
               if(icon .eq. 1 ) then
                  if(firsttime) then
                     call chookheader
                     firsttime = .false.
                  endif
c                 cross the earth
                  nucode = Pwork(i).code
                  if(Pwork(i).subcode .lt. 0) then
                     nucode = -nucode
                  endif
                  if(binout .eq. 1) then
                   write(nu_dev)
     *             nucode, MovedTrack.info, MovedTrack.label,
     *             sngl( Pwork(i).fm.p(4)),
     *             sngl( aTrack.vec.w.r(1)), sngl( aTrack.vec.w.r(2)),
     *             sngl( aTrack.vec.w.r(3)),
     *             sngl( aTrack.pos.xyz.x),  sngl( aTrack.pos.xyz.y),
     *             sngl( aTrack.pos.xyz.z), MovedTrack.t/c
                  elseif(nu_dev .eq. 6) then
                     write(*,
     *              '("nu_",i3, i11, i8, f9.3, 3f9.5, 3g13.5,f12.7)')
     *                nucode, MovedTrack.info, MovedTrack.label,
     *                Pwork(i).fm.p(4),
     *                aTrack.vec.w.r(1), aTrack.vec.w.r(2),
     *                aTrack.vec.w.r(3),
     *                aTrack.pos.xyz.x,  aTrack.pos.xyz.y,
     *                aTrack.pos.xyz.z, MovedTrack.t/c
                  else
                     write(nu_dev,
     *               '(i3, i11, i8, f9.3, 3f9.5, 3g13.5, f12.7)')
     *                nucode, MovedTrack.info, MovedTrack.label,
     *                Pwork(i).fm.p(4),
     *                aTrack.vec.w.r(1), aTrack.vec.w.r(2),
     *                aTrack.vec.w.r(3),
     *                aTrack.pos.xyz.x,  aTrack.pos.xyz.y,
     *                aTrack.pos.xyz.z, MovedTrack.t/c
                  endif
               endif
            endif
         else
            n = n + 1
            if(n .ne. i) then
               Pwork(n) = Pwork(i)
            endif
         endif
      enddo
      never = 0
      Nproduced = n
c
c        IntInfArray(ProcessNo).process  will have
c             'col' or 'decay'
      end
      subroutine chookheader
      implicit none
#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Zprivate.h"
      if(binout .eq. 1) then
         write(nu_dev) EventNo
      else
         if(nu_dev .eq. 6) then
            write(*, '("nu_",i10)') EventNo
         else
            write(nu_dev, '(i10)')  EventNo
         endif
      endif
      end


c
c              this is a copy of a part of Epics/prog/KKlib/kklib.f
c
      subroutine kxplsph(x0, y0, z0, l, m, n, r, el, icon)
      implicit none
      real*8  x0, y0, z0 ! input. the line passes this point
      real*8  l, m, n  !  input.  direc cos.  of  the line
      real*8  r        !  input.  radius of the sphere
      real*8  el       !  output. el>=0 distance to the
                       !          sphere  from  x0,y0,z0
      integer icon    !  output. icon =0.  x-point exists
                      !                  x0,.. is inside
                      !          icon = 1  x-point exists
                      !                  x0.. is outside
                      !                =-1.  no x-point

      real*8  rsqr, r0l, d
      integer icon1, icon2

      rsqr = x0**2 + y0**2 + z0**2 -r**2
      if(rsqr .le. 0.) then
c          inside
         icon2 = 0
      else
         icon2 = 1
      endif
      r0l = x0*l + y0*m + z0*n
      d = r0l**2 - rsqr
      if(d .ge. 0.) then
         d = sqrt(d)
         el = -r0l - d
         if(el .ge. 0.) then
            icon1 = 0
         else
            el = -r0l + d
            if(el .ge. 0.) then
               icon1 = 0
            else
               icon1 = 1
            endif
         endif
      else
         icon1 = 1
      endif
c
      if(icon2 .eq. 0) then
         icon = 0
      elseif(icon1 .eq. 0) then
         icon = 1
      else
         icon = -1
      endif
      end


