cc      cphotoEEPath, Energy
c      real*8 eg, egom, em/0.511e-3/,  path, prob
c      integer i
c      egom=.01
c      do  i=1,150
c          eg=egom*em
c          call cphotoEEPath(eg, prob,  path)
c          write(*, *) eg
c          egom=egom*10.**(.03333)
c      enddo
c      end
c     ****************************************************************
c     *
c     * cphotoEEPath: samples photo electric effect path in r.l
c     * cphotoEEEnergy: gives energy of photo-electron in GeV
c     *
c     ****************************************************************
c
c   /usage/  call cphotEEPath(eg, prob, path)
c            call cphotoEEEnergy(eg, e)
c
c   --input--
c    eg: photon energy in GeV
c
c   -- output --
c prob: prob/r.l 
c path: sampled path in r.l
c

c
c
c
c
       subroutine cphotoEEPath(eg, tp, path)
       implicit none
#include "Zmass.h"
c
c
       real*8  eg
       real*8  path
       real*8 tp  ! prob./r.l

       
       real*8 b0/.8406032822525545/,
     *        b1/1.76788459694177/,
     *        b2/1.82193436175065/,
     *        fa/1.08224940926528/,
     *        cnstp/8.587838661937385E-05/,
     *        ek/7.148500000000000E-04/,
     *        cnstl/.7734375/
c
       real*8  ep, epi, u

       save  b0, b1, b2, fa, cnstp, ek, cnstl
c
       ep=eg/masele
       call rndc(u)
       epi=1.d0/ep
       tp= ( (b2*epi + b1)*epi + b0 ) *
     *      fa* cnstp * epi
       if(eg .lt. ek) then
          tp=tp/cnstl
       endif
       path=-log(u) / tp
       end

c      ************
       subroutine cphotoEEEnergy(egin, eout)
c      ************
       implicit none
#include "Zmass.h"

       real*8 egin
       real*8 eout
       
c
       real*8 cnsta
       data cnsta/ -1.9859375d-04 /
       save cnsta

       eout=egin + cnsta
       if(eout .le. masele) then
          eout=masele*1.0000000001d0
       endif
       end
