c            get max movable lenghth of a ptcl.
      subroutine cmaxMovLen(leng, thick)
c       leng:  real*8. output.  max movable length in m.
c      thick:  real*8. output.  thickness corresponding to leng in kg/m2.
c                         however, note;
c                             AlmostVacT, if Reverse=0 and height >AlmostVacH
c                             0. if Reverse = 1.
c                             0. if Reverse = 2 and  height > AlmostVacH
c                                  
c
c
      implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"
#include  "Zstdatmos.h"

      real*8 leng, thick
c
      real*8  ztrunc, rmg, rmgmax
      real*8  clen2thick, erg
      integer jcut


      erg = TrackBefMove.p.fm.p(4)
c             fix energy dependent truncation path
      if(TrackBefMove.p.charge .ne. 0) then

c            magnetic
         call cmagDefR(TrackBefMove, Mag,  rmg)  ! get radius approx.
         rmg = rmg/LamorDiv        !  this is almost streight movable
c            get max length within which B is almost const
ccc         if(Reverse .ne. 0 .or.
ccc     *   (erg .gt. MagBremEmin .and. MagBrem .ne. 0 )) then
c            length within which dB  < 1 %.
         call clengSmallBC(TrackBefMove, rmgmax)  
         rmg = min(rmg, rmgmax)
cc         endif

c            mul. scatt and lpm

         if(Reverse .eq. 0) then
ccc            if(TrackBefMove.pos.height .lt. AlmostVacH) then
            call cmaxCasLen(TrackBefMove, ztrunc)
            if(TrackBefMove.p.fm.p(4) .gt. LpmBremEmin
     *         .and. LpmEffect) then
               ztrunc =
     *         max( min(TrackBefMove.pos.depth/10., ztrunc), 
     *              30.d0 )
            endif
c            call cthick2len(TrackBefMove.pos.height, 
c     *         TrackBefMove.vec.coszenith, ztrunc, leng, thick, jcut)
            call cthick2len(TrackBefMove,
     *          ztrunc, leng, thick, jcut)
c////////////
c            write(*,*) ' after thick2len, leng=',leng,
c     *         ' thick=',thick, ' jcut=',jcut, ' rmg=',rmg
c////////////////////
c                 thick may have been changed to shorter one.
            if(rmg .lt. leng) then
               thick = clen2thick(TrackBefMove.pos.height,
     *              TrackBefMove.vec.coszenith, rmg)
               leng = rmg
c//////////////
c               write(*,*) ' thick by len2th=', thick, ' len=rmg=',
c     *         leng
c////////////////
            endif
cc            else
cc               thick = AlmostVacT
cc               leng = rmg
cc            endif
         elseif(Reverse .eq. 1) then
            leng = rmg
            thick = 0.
         else
            leng = rmg
cc            if(TrackBefMove.pos.height .gt. AlmostVacH) then
cc               thick = 0.
cc            else
               thick = clen2thick(TrackBefMove.pos.height,
     *         TrackBefMove.vec.coszenith, rmg)
cc            endif
         endif
      else
c               neutral
         rmg = 1.d5
         if(Reverse .eq. 0) then
            if(TrackBefMove.p.code .eq. kneumu .or.
     *          TrackBefMove.p.code .eq. kneue) then
               leng = rmg           ! means very large
               thick = AlmostVacT   ! not used
            else
               if(TrackBefMove.p.code .eq. kphoton) then
                  if(erg .gt. MagPairEmin .and. MagPair .ne. 0) then
                     call clengSmallBC(TrackBefMove, rmgmax)  
                     rmg = min(rmg, rmgmax)
                  endif
               endif
               if(TrackBefMove.p.code .eq. kphoton .and.
     *              TrackBefMove.p.fm.p(4) .gt. LpmPairEmin .and. 
     *              LpmEffect) then
                  if(TrackBefMove.pos.height .lt. AlmostVacH) then
                     ztrunc = TrackBefMove.pos.depth/10.
                  else
                     ztrunc = AlmostVacT  
                  endif
               else
                  ztrunc = X0*5
               endif
c               call cthick2len(TrackBefMove.pos.height, 
c     *         TrackBefMove.vec.coszenith, ztrunc, leng, thick, jcut)
               call cthick2len(TrackBefMove,
     *            ztrunc, leng, thick, jcut)
c                 thick may have been changed to shorter one.
               if(rmg .lt. leng) then
                  thick = clen2thick(TrackBefMove.pos.height,
     *            TrackBefMove.vec.coszenith, rmg)
                  leng = rmg
               else
                  thick = AlmostVacT   ! not used.
                  leng = rmg           ! meas very large
               endif
            endif
         elseif(Reverse .eq. 1) then
            leng = rmg
            thick = 0.
         else
            leng = rmg
cc            if(TrackBefMove.pos.height .gt. AlmostVacH) then
cc               thick = 0.
cc            else
               thick = clen2thick(TrackBefMove.pos.height,
     *         TrackBefMove.vec.coszenith, rmg)
cc            endif
         endif
      endif
      end
c     **********************
      subroutine cmaxCasLen(aTrack, kgpm2)
      implicit none
c       get max. movable length for cascade so
c       that the scattering deflection can be
c        neglected
#include "Ztrack.h"
#include  "Ztrackp.h"
cc         #include  "Ztrackv.h"
#include  "Zelemagp.h"

      record /track/ aTrack ! input.
      real*8 kgpm2  ! output. length kg/m2

c
      real*8  ek, ttrunc


      ek = aTrack.p.fm.p(4) - aTrack.p.mass
      if(TimeStructure) then
         if(ek  .gt. 1.) then
            ttrunc=2.
         else
            ttrunc=1.66*ek + 0.333
            ttrunc=min( max(Truncc*ek, Truncn), Truncx)
         endif
      else
         ttrunc=min( max(Truncc*ek, Truncn), Truncx)
      endif
      kgpm2 = max(ttrunc, Truncn) * X0 ! max.  to avoid very small thick.
      end
c    *************************************
      subroutine cmagDefR(aTrack, mag, r)
c       get magnetic deflecton radius.  This is
c       approximate one.
      implicit none

#include  "Ztrack.h"

      record /track/aTrack  ! input. charged particle
      record /magfield/ mag  ! innput. magnetic field
      real*8  r   ! output. Radius of magnetic defletion.  m

      real*8 maxb

      if(aTrack.p.charge .eq. 0) then
         r = 1.e30
      else
         maxb = max (abs(mag.x), abs(mag.y), abs(mag.z)) 
         if(maxb .ne. 0) then
c               r is smaller than true Lamor radius which
c               would be obtained with momentum
c               since K.E < P
            r = 3.3*(aTrack.p.fm.p(4)-aTrack.p.mass)/maxb/
     *       abs(aTrack.p.charge)
            r= max(r, 1.d-2)
         else
            r = 1.e30
         endif
      endif
      end
c      ***********************
      subroutine clengSmallBC(aTrack, r)
c       get length where the change of magnetic
c       field can be regarded as small < 1 %
      implicit none

#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Zearth.h"

      record /track/aTrack ! input. r is obtaiend at this ptcl is
c                         located.
      real*8  r  ! output. within this length (m), geomag can be
c                      regarged as constant.

c     at the surface of Earth, it is about 20 km = MagChgDist
c     at larger radial distance, it becomes larger
c
      r =   aTrack.pos.radiallen/Eradius * MagChgDist

      end
