       subroutine cinteElec
       implicit none
c----       include 'Ztrack.h'
#include  "Ztrack.h"
c----       include 'Ztrackv.h'
#include  "Ztrackv.h"
         character*70 msg
c
c
         if(IntInfArray(ProcessNo).process .eq. 'brems') then
            call  cbrems
         elseif(IntInfArray(ProcessNo).process .eq. 'mscat') then
            call cknockon(-1)
         elseif(IntInfArray(ProcessNo).process .eq. 'bscat') then
            call cknockon(1)
         elseif(IntInfArray(ProcessNo).process .eq. 'anihi') then
            call canihi
         elseif(IntInfArray(ProcessNo).process .eq. 'mbrem') then
            call cmbrem
         else

              write(msg, *) ' process for electron',
     *        IntInfArray(ProcessNo).process, ' undef'
              call cerrorMsg(msg, 0)
         endif

         end
c
c         Pwork assumes that higher energy particles are normally
c         in the last part, and stacked later from the last to
c         save the stack area.  Due to this fact, putting ptlcs
c         in Pwork must be reversed (realized from v6.10)
c        *****************
         subroutine cbrems
c        *****************
         implicit none

#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"

         real*8 beg, den, cvh2den 
         record /track/ aTrack

c           get brem gamma energy
         if(LpmEffect .and. 
     *        TrackBefMove.p.fm.p(4) .gt. LpmBremEmin) then ! use BefMove.p
c            den = cthick2den(TrackBefMove.pos.depth)
            den = cvh2den(TrackBefMove.pos.height)  ! this should be better
            call cbremErgLPM(TrackBefMove.p.fm.p(4), den, beg)
         else
            call cbremsEnergy(MovedTrack.p.fm.p(4), beg)
         endif

         aTrack = MovedTrack

c         
         aTrack.p.fm.p(4) = MovedTrack.p.fm.p(4) -beg
         call ce2p(aTrack)
c
c         see           !! note above
         Pwork(Nproduced+2) = aTrack.p

         aTrack.p.fm.p(4) = beg
         call cmkptc(kphoton,  kcasg, 0,  aTrack.p)
         call ce2p(aTrack)
         Pwork(Nproduced+1) = aTrack.p

         Nproduced = Nproduced + 2
         end
c      *****************
       subroutine cknockon(cg)
c      *****************  moller and bhabha scattering
       implicit none
c----       include '../Particle/Zcode.h'
#include  "Zcode.h"
c----       include 'Ztrack.h'
#include  "Ztrack.h"
c----       include 'Ztrackv.h'
#include  "Ztrackv.h"
#include  "Zelemagp.h"
c     
       integer cg
       real*8 e1, er, tmp, cos1, cosr, sine, cs, sn, sinr
       record /coord/dc, dc1, dcr
c
       record /track/ aTrack
c
       if(cg .eq. -1) then
          call cmollerea(MovedTrack.p.fm.p(4), RecoilKineMinE,
     *                   e1, er, cos1, cosr)
       else
          call cbhabhaea(MovedTrack.p.fm.p(4), RecoilKineMinE,
     *    e1, er, cos1, cosr)
       endif

       tmp=1.d0-cos1*cos1
       if(tmp .lt. 0.d0) then
          tmp=0.d0
          cos1=1.d0
       endif
       sine=sqrt(tmp)
       call kcossn(cs,sn)
       dc.r(1) = cs*sine
       dc.r(2) = sn*sine
       dc.r(3) = cos1
c           convert angle
       call ctransVectZ(MovedTrack.vec.w, dc, dc1)
       aTrack = MovedTrack
       aTrack.p.fm.p(4) = e1
       call csetDirCos(dc1, aTrack)
       call ce2p(aTrack)

       Pwork(Nproduced + 2) = aTrack.p
c            knock on electron
       tmp=1.d0-cosr*cosr
       if(tmp .lt. 0.d0) then
          tmp=0.d0
          cosr=1.d0
       endif
       sinr=sqrt(tmp)
       dc.r(1) = -cs*sinr
       dc.r(2) = -sn*sinr
       dc.r(3) = cosr
       call ctransVectZ(MovedTrack.vec.w, dc, dcr)
       aTrack.p.fm.p(4) = er
       call csetDirCos(dcr, aTrack)
c
       if(cg .eq. 1) then
          call cmkptc(kelec,  0,  -1,  aTrack.p)
       endif

       call ce2p(aTrack)

       Pwork(Nproduced + 1) = aTrack.p

       Nproduced = Nproduced + 2
      end
c     *****************
      subroutine canihi
c     *****************
       implicit none
c----       include '../Particle/Zcode.h'
#include  "Zcode.h"
c----       include 'Ztrack.h'
#include  "Ztrack.h"
c----       include 'Ztrackv.h'
#include  "Ztrackv.h"

       real*8 e1, er, cos1, cosr, tmp, sine
       real*8 cs, sn, sinr
       record /track/aTrack
       record /coord/ dc, dc1, dcr
c
       call canihiea(MovedTrack.p.fm.p(4), e1, er, cos1, cosr)
c               
       tmp=1.d0-cos1*cos1
       if(tmp .lt. 0.d0) then
          tmp=0.d0
          cos1=-1.d0
       endif
       sine=sqrt(tmp)
       call kcossn(cs,sn)
       dc.r(1) = cs*sine
       dc.r(2) = sn*sine
       dc.r(3) = cos1
c             
       call ctransVectZ(MovedTrack.vec.w, dc, dc1)
c            higher gamma
       aTrack = MovedTrack
       call csetDirCos(dc1, aTrack)
       call cmkptc(kphoton, kcasg, 0,  aTrack.p)
       aTrack.p.fm.p(4) = e1
       Nproduced = Nproduced + 1
       Pwork(Nproduced) = aTrack.p
c       call cpush(aTrack)
c                low gamma
       tmp=1.d0-cosr*cosr
       if(tmp .lt. 0.d0) then
          tmp=0.d0
          cosr=-1.d0
       endif
       sinr=sqrt(tmp)
       dc.r(1) = -cs*sinr
       dc.r(2) = -sn*sinr
       dc.r(3) = cosr
       call ctransVectZ(MovedTrack.vec.w, dc, dcr)
       call csetDirCos(dcr, aTrack)
       aTrack.p.fm.p(4) = er
       Nproduced = Nproduced + 1
       Pwork(Nproduced) = aTrack.p
c       call cpush(aTrack)
       end

c        *****************
         subroutine cmbrem
c          magnetic brems
c        *****************
         implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"

         real*8 x, beg

         record /track/ aTrack

c           get brem gamma energy
         call cmBremE(Upsilon, x) 
         beg = x * MovedTrack.p.fm.p(4)  ! gamma energy

         aTrack = MovedTrack
         aTrack.p.fm.p(4) = MovedTrack.p.fm.p(4) -beg
         call ce2p(aTrack)
         Pwork( Nproduced + 2 ) = aTrack.p   
c           stack gamma (probably lower energy than e)
         aTrack.p.fm.p(4) = beg
         call cmkptc(kphoton,  kcasg, 0,  aTrack.p)
         call ce2p(aTrack)
         Pwork(Nproduced + 1) = aTrack.p

         Nproduced = Nproduced + 2         
         end


