c        Initialize simulation.  
c
      subroutine cbeginRun
      implicit none
#include  "Zmanagerp.h"
#include  "Zmanager.h"
#include  "Zelemagp.h"
#include  "Zevhnp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zincidentp.h" 
#include  "Zprimary.h"
#include  "Zprimaryv.h"
#include  "Zcondc.h"
#include  "Zobs.h"
#include  "Zobsp.h"


      character*16 temp
      integer jold, icon
      real*8 s1


      if(Cont) then
c           restore status at the end of previous run
         call crestoreStatus
         Cont =.true.
      elseif(Job .eq. 'flesh'  .or. Job .eq. 'newflesh') then
         temp = Job
         call cgetSkelFile 
         Job = temp    !  keet as now
      elseif(Job .eq. 'skeleton' .or. Job .eq. 'newskel' ) then
c            to be safe, parameters are written in a file first and read
c            again ; this will avoid the possible difference of internal
c            parameter values read from original param and SkeletonParam
c
         call copenNLfw(TempDev, SkeletonFile, icon)
         if(icon .ne. 0) then
            call cerrorMsg(SkeletonFile, 1)
            call cerrorMsg('File shown above cannot be opened',0)
         endif
c           at flesh time, you don't need to rewrite Job
         temp = Job
         if(Job .eq. 'newskel') then
            Job = 'newflesh'
         else
            Job = 'flesh'
         endif
         call cwriteParam(TempDev, 1)
         close(TempDev)
         call copenNLf(TempDev, SkeletonFile, icon)
         call creadParam(TempDev)
         close(TempDev)
c            restore Job
         Job = temp
      endif

c        reset parameters.
      if(BorderHeightH .eq. 0.0) then
         BorderHeightH = HeightOfInj + 1.0d0    ! from v6.10
      endif

      EventsInTheRun = 0      ! moved from ciniTracking0. 2001.09/30

      if(DestEventNo(2) .eq. 0) then
         DestEventNo(2) = DestEventNo(1)
      elseif(DestEventNo(1) .lt. 0) then
         DestEventNo(2) = -abs(DestEventNo(2))
      endif

c         to lower case letters.
      temp = Generate
      call c2lowerCase(temp, Generate)
      temp = Job
      call c2lowerCase(temp, Job)

      call rndsw(jold, 1)    ! specify random number generator 1.

      call cintModels('cosmos')  ! analysis of interaction models and init.
#if ATMOSPHERE == 1
c          read segmented atmosphere data
      call creadAtmosD
c          manipulate data
      call catmosCnst1
      call catmosCnst2
#endif
c         init for geomag
      call crdGeomag(GeomagFile, YearOfGeomag)
c        init for LPM effect energy sampling.
      s1 = (7.36d0**(1./3.d0)/183.d0)**2
      call csetLPMCnst(s1, log(s1), 1.d-4, X0)
c        initialize  observation  
      call cinitObs
c        init for   primary sampling
      call ciniSPrim(PrimaryFile)

      if(CutOffFile .ne. ' ') then
         call crigCut0(CutOffFile) ! read cutoff talbe and init.
      endif
c       init for muon interaction routines; specific for Air.
      call cRdmuTab        ! set various consts for mu int.
      call cSetMu(7.36d0, 14.7d0)
      FromEpics = .false.  ! muon interaction routines for Air are
                           ! inside Cosmos 
      call ciniSPrimAng    !  this is in csPrimaAgn.f in Tracking dir.
c        check job
      call cwhatJob
c          this is moved here; before v6.10 it was before cwhatJob
      call ciniTracking0  !  init for  tracking for all events
c           init for knockon process; Knockon is not used now.
      if(KnockOnRatio .lt. 1.d0) then
c              ********* Knockon is not used now ******
         if(Job .eq. 'newskel') then
            call cdedxEleci(KEminObs*KnockOnRatio, Knockon)
         else
c                 this must come after cwhatJob, since KEminObs2 must
c           be fixed.  For skeleton-flesh job, KnockOnRatio should be
c           small enough so that KEminObs2*KnockOnRatio < KEminObs at
c           flesh time  

            call cdedxEleci(KEminObs2*KnockOnRatio, Knockon)
         endif
      else
         call cdedxEleci(RecoilKineMinE, Knockon)
      endif
c         user hook
      call chookBgRun
      
      end

      subroutine ciniTracking0
      implicit none
#include  "Zmanager.h"
#include  "Zmanagerp.h"
#include  "Zevhnp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zprimary.h"
#include  "Zprimaryv.h"
#include  "Zobs.h"
#include  "Zobsv.h"
#include  "Zincidentp.h"
#include  "Zheavyv.h"

c
      character*24 hostn
      integer leng,  j
      integer i, now(2)
#if defined Solaris
      integer time
#elif defined PCLinuxIFC
      integer hour, mint, sec, hsec
#endif

c  
c      ********** 
c      next  is a "directive" for absoft f90.
c      which is to make the call TIME as if call time.
c      For absoft f90 ; we have to treat all variable in upper case
c      but there is no TIME tourine in the system.
c
cdir$ NAME (TIME="time")

c
c
      ObserveAS = index(Generate, 'as')  .gt. 0 .or.
     *            index(Generate, 'lat') .gt. 0 
      if(index(Generate, 'qas') .gt. 0) then
         SkipPtclGen = 1  ! quick as generation for heavies.
      else
         SkipPtclGen = 0
      endif



      RefreshIR = InitRN(1) .lt. 0 .and. 
     *        ( Job .ne. 'flesh' .and. Job .ne. 'newflesh')

      if(InitRN(1) .gt. 0 .and. InitRN(2) .gt. 0 ) then
         call rnd1r(InitRN)     ! init randeom number generator
c      *****************
      elseif(.not. RefreshIR .and. InitRN(2) .lt. 0) then
#if defined Solaris
         now(1)= time()
#elif defined PCLinuxIFC
         call gettim(hour, mint, sec, hsec)
         now(1) = hsec
         now(2) = sec
#else
         call time(now)
#endif

c         now(2) =-InitRN(2)  !  2001.09.30; dec fortran changes now(2).
c
c         add a max of 4 last char. of hostname after converting to int.

         call cgetHost(leng, hostn)   ! get hostname
         i = max(1, leng-3)

         do  j = i, leng
            now(2) = now(2) + ichar( hostn(j:j) )
            now(1) = now(1) + ichar( hostn(j:j) )
         enddo

         call rnd1r(now)
c     ******************
      endif
c          compute the offset point in 'xyz' system
c        the deepest detector origin + Offset is the point
c        to which the primary is directed.
c         offset in the detector system.
      Offset.r(1) = 0.
      Offset.r(2) = 0.
      Offset.r(3) = OffsetHeight
c        convert it to xyz system.
      call cdet2xyz(ObsSites(NoOfSites).pos.xyz, Offset, Offset)
c        make it offset 
      do i= 1, 3
         Offset.r(i) = Offset.r(i) -
     *    ObsSites(NoOfSites).pos.xyz.r(i)
      enddo

      end
c     ************
      subroutine  cwhatJob
c     ************
      implicit none
#include  "Zmanagerp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
c   
c
c
      character*190  msg
      integer klena, icon
      character*8  uid 
      character*16 temp

      if(Job .eq. ' ' .or. Job .eq. 'skeleton' .or. 
     *   Job .eq. 'newskel'  ) then
         if(Job .ne. 'newskel') then
c             save present conditions
            KEminObs2 = KEminObs
            Generate2 = Generate
            EndLevel2 = EndLevel
         elseif(Job .eq. 'newskel') then
            if( KEminObs2 .ge. KEminObs .and.
     *          EndLevel2 .le. EndLevel .and.
     *          index(Generate2,'as') .eq. 0 .and.
     *          index(Generate2,'lat') .eq. 0 ) then
               call cerrorMsg(
     *          'Doing newskel job seems nonsense', 1)
               call cerrorMsg(
     *          'Check Generate2, KEminObs2, EndLevel2',0)
            endif
         endif
         NoOfSites2 = NoOfSites    ! probably not needed
         if(Job .eq. ' ') then
            if(SeedFile .ne. ' ') then
c                  open seed file for output
               write(msg, *) 'opening SeedFile=',
     *         SeedFile(1:klena(SeedFile))
               call cerrorMsg(msg, 1)
               call copenfw(SeedFileDev, SeedFile, icon)
               if(icon .ne. 0) then
                  call cerrorMsg(SeedFile, 1)
                  call cerrorMsg('File shown above cannot be opened',0)
               endif
               if(Cont) then
                  call cskiptoEOF(SeedFileDev)
               endif
            endif               
         elseif(Job .eq. 'skeleton' .or. Job .eq. 'newskel' ) then
            call
     *      cerrorMsg('  ********** skeleton making **********', 1)
            write(msg, *)  '      Generate=', Generate
            call cerrorMsg(msg, 1)
c                 save skeleton inf. in skelotonFile file.
c             The file will be modified when the distjob command
c             processes Job = 'flesh' later. You need not modify
c             skeleton file if distjob is employed.
            if(.not. Cont) then
               temp = Job    ! save current Job
               if(Job .eq. 'newskel') then
                  Job = 'newflesh'
               else
                  Job = 'flesh'
               endif
               call copenNLfw(TempDev, SkeletonFile, icon)
               if(icon .ne. 0) then
                  call cerrorMsg(SkeletonFile, 1)
                  call cerrorMsg(
     *              'File shown above cannot be opened',0)
               endif
               call cwriteParam(TempDev, 1)
               close(TempDev)
               Job = temp
            endif
c                open SeedFile 
            if(SeedFile .eq. ' ') then
c                error. you need file
               write(msg, *)
     *         ' SeedFile must not be blank for skelton making'
               call cerrorMsg(msg, 0)
            else
               write(msg, *) 'opening SeedFile=',
     *         SeedFile(1:klena(SeedFile))
               call cerrorMsg(msg, 1)
               call copenfw(SeedFileDev, SeedFile, icon)
               if(icon .ne. 0) then
                  call cerrorMsg(SeedFile, 1)
                  call cerrorMsg('File shown above cannot be opened',0)
               endif
               if(Cont) then
                  call cskiptoEOF(SeedFileDev)
               endif
            endif
         endif
      elseif(Job   .eq. 'flesh' .or. Job .eq. 'newflesh') then
c             don't worry about KEminObs2 etc.  They have been read
c             from &Hparam
          call cerrorMsg('  ********** fleshing job   *********', 1)
          if(Job .eq. 'flesh') then
             if(EndLevel .gt. EndLevel2) then
c                to deeper detph than skeleton
                write(msg, *)
     *          ' fleshing will be done to deeper depth than'//
     *               ' skeleton making time'
                call cerrorMsg(msg, 1)
                write(msg, *) ' No of old levels=', EndLevel2,
     *               ' No of new levels=', EndLevel
                call cerrorMsg(msg, 1)
             elseif(EndLevel .lt. EndLevel2) then
                call cerrorMsg('EndLevel must be >= skelton time', 0)
             endif
             write(msg, *)  '      Old Generate=', Generate2
             call cerrorMsg(msg, 1)
             write(msg, *)  '      New Generate=', Generate
             call cerrorMsg(msg, 1)
          else
             if(EndLevel .lt. EndLevel2) then
c                to deeper detph than skeleton
                write(msg, *)
     *          ' fleshing will be done to deeper depth than'//
     *           ' skeleton making time'
                call cerrorMsg(msg, 1)
             endif
c
c              copy  old Generate, KEminObs2 to current value
c              they are future values at newskel time
             KEminObs = KEminObs2
             Generate = Generate2
             EndLevel = EndLevel2
          endif
c                open SeedFile
          if(SeedFile .eq. ' ') then
             write(*, *) ' SeedFile must not be blank for flesh job'
             call cerrorMsg(msg, 0)
          else
             write(msg, *) 'opening SeedFFile=', 
     *        SeedFile(1:klena(SeedFile))
             call cerrorMsg(msg, 1)
             call copenf(SeedFileDev, SeedFile, icon)
             if(icon .ne. 0) then
                call cerrorMsg(SeedFile, 0)
                call cerrorMsg('File shown above seems missing',0)
             endif
          endif
      else
           write(msg,*) ' Job=',Job, ' undefined'
           call cerrorMsg(msg, 0)
      endif
      if((Trace .gt. 0 .and. Trace .lt. 60) .or. Trace .gt. 100) then
c           defalut trace.  fix the dirctor
          if(TraceDir .eq. ' ') then
             call cgetLoginN(uid)
             TraceDir = '/tmp/'//uid(1:klena(uid))
          endif
       endif
      end
c        **************************************** read cont job info
      subroutine crestoreStatus
      implicit none
#include "Zmanagerp.h"
      integer icon

      call copenNLf(TempDev, ContFile,icon)
      if(icon .ne. 0) then
         call cerrorMsg(ContFile, 1)
         call cerrorMsg('File shown above seems missing',0)
      endif
      call creadParam(TempDev)
      close(TempDev)
      end
      subroutine cgetSkelFile
      implicit none
#include "Zmanagerp.h"
      integer icon
      call copenNLf(TempDev, SkeletonFile, icon)
      if(icon .ne. 0 ) then
         call cerrorMsg(SkeletonFile, 1)
         call cerrorMsg('File shown above seems missing',0)
      endif
c          read skelton parameters for flesing
      call creadParam(TempDev)
      close(TempDev)
      end


