      subroutine ctrackingAll    
c     **************************************************
c       tracking particles given in the stack area.
c       During tracking, new particles may be produced
c       and pushed in the stack area.  They are all
c       treated here, until all particles are processed.
c     **************************************************
      implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"

      integer moreptcl, jold, icon
      real*8 smallAS/1./   ! electrons < 1GeV cannot make AS at all.
cc      real*8 u, iwgt	
c     
      external cblkTracking
c
c      ***  do until no more ptcl in stack
      do while (.true.)
c           get one particle from stack
         call cpop(TrackBefMove, moreptcl)

         if(moreptcl .eq. 0) goto 100   !  exit
         call rndsw(jold, 1)            !  specify 1st generator.
         call cifDead(TrackBefMove, icon)  ! generator may be switched to 2

c            AS generation. 

         if(ObserveAS .and. icon .ne. 2) then
            if(TrackBefMove.p.code .eq. kelec) then
               if(TrackBefMove.asflag .eq. 0) then
                  if(TrackBefMove.p.fm.p(4) .le. EasWait) then
                     if(TrackBefMove.p.fm.p(4) .gt. smallAS) then ! 95/08/17
                        call cobAS(TrackBefMove)
                     endif
                     TrackBefMove.asflag =1
                  endif
               endif
            elseif(TrackBefMove.p.code .eq. kphoton) then
               if(icon .ne. 0) then
                  if(TrackBefMove.asflag .eq. 0) then
                     if(TrackBefMove.p.fm.p(4) .gt. smallAS) then
                        icon = 0 ! follow until it becomes e-pair
                     endif
                  endif
               endif
            endif
         endif
c        ----------------------------
         if(icon .eq. 0) then
            call cTracking
         else
            MoveStat = Dead
#if DETAILED_TRACKING >=1
            MovedTrack = TrackBefMove
            if(icon .eq. 1) then
               call cobservation(5)
            else
               call cobservation(6)
            endif
#endif
         endif
      enddo
 100  continue
      end
c -------------------------------------tracking a ptcl
      subroutine cTracking
      implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
#include  "Zincidentv.h"
#include  "Zcode.h"
#include  "Zmanagerp.h"
c                next is for DEBUG
c//////
c      logical deb
c      common /cdebug/ deb
c/////////
cc      cc#define DEBUG 1


      logical reset
      real*8 cosangle
      character*70 msg
      integer nextwhere, never
cc      integer icon

#if DEBUG == 1
c      deb=.true.
      call checkstat('before fixModel')
#endif

      call cfixModel( TrackBefMove.p )      ! fix interaction model.
      call cfixMedia            ! 
c           sample interaction length.  The path may
c           be truncated to a shorter one than really sampled.
c           In that case, MoveStat == Truncated.
#if DEBUG == 1
      call checkstat('before csampIntl')
#endif

      call csampIntL

#if DEBUG == 1
      call checkstat('after csampIntl')
#endif
c           Truncate the path if it is too long. Note, the truncated
c           path in the above process may be again truncated to
c           a shorter one. This happens, for example, if ptcl energy
c           is low.  Path inf is reset in IntInfArray.
      call ctruncPath
#if DEBUG == 1
      call checkstat('after ctruncPath')
#endif

c           compute path end inf. including scattering and
c           mag. deflection.  Path end inf is set in MovedTrack
      call ccompPathEnd
#if DEBUG == 1
      call checkstat('after ccompPathEnd')
#endif
c           see if MovedTrack crosses an observation site.
c         (or reaches BorderHeightL)  If so, reset MovedTrack. 
      call cifXObsSite(nextwhere)
#if DEBUG == 1
      call checkstat('after cifXObsSite')
#endif
      if(Trace .ne. 0) then
         if( mod(Trace, 10) .le. 2) then
            call cputTrInfo     ! put trace info.
         elseif(mod(Trace,10) .le. 4) then
            if( TrackBefMove.pos.height .le. HeightList(1)) then
               call cputTrInfo  ! put trace info.
            endif
         endif
      endif
#if DETAILED_TRACKING >= 3
c            the user may kill the ptcl
      call cobservation(8)
#endif


c     
      if(MoveStat .eq. Truncated) then
c           see if truncation is really ok.  for energy = 0, 
c           if anti ptcl, it should be anihilated, if decayabl,
c           it should be decayed.
         if(MovedTrack.p.fm.p(4) .eq. MovedTrack.p.mass) then
            if(MovedTrack.p.subcode .eq. antip) then
               MoveStat = ToInteract
            elseif(MovedTrack.p.code .eq. kmuon) then
               MoveStat = ToInteract
            elseif(MovedTrack.p.code .eq. kpion) then
               MoveStat = ToInteract
            elseif(MovedTrack.p.code .eq. kkaon) then
               MoveStat = ToInteract
            endif
         endif
      endif 

      if(MoveStat .eq. Truncated) then
c        &&&&&&&&&&&&&& some may lose energy by dE/dx etc. 
c                       This should be recorded
         if(Job .eq. 'newskel' .and. 
     *        (MovedTrack.p.fm.p(4) - MovedTrack.p.mass) .lt. 
     *        KEminObs)  then
            never = -1
            call chookEInt(never)
         endif
c        &&&&&&&&&&&&
c              stack current ptcl
         call cpush(MovedTrack)
      elseif(MoveStat .eq. ToInteract ) then
         if(Zfirst.pos.depth .eq. 0.) then
            if(  (MovedTrack.p.code .ge. kpion  .and. 
     *            MovedTrack.p.code .le. knuc ) .or.
     *         MovedTrack.p.code .eq. kgnuc ) then
               if(IntInfArray(ProcessNo).process .eq. 'coll') then
                  reset = .true.
               else
                  reset = .false.
               endif
            else
               reset = .true.
            endif
            if(reset) then
c             reset minimum time to reach the obs level (time from this
c             hight to the obs. level), if no mag. exists until
c                  the first collision point. or ptcl goes streight
               call cresetTimer(MovedTrack)
               Zfirst = MovedTrack
            endif
         endif
#if DETAILED_TRACKING >= 1 
         call cobservation(4)
#endif

#if DEBUG == 1
         call checkstat('before cinteraction')
#endif
         call cinteraction
c/////////////
c         if(deb) then
c            write(*,*) 'after cinte'
c         endif
c////////////
      elseif(MoveStat .eq. ToBeObserved ) then
         if(MovedTrack.p.fm.p(4)-MovedTrack.p.mass 
     *        .ge. KEminObs) then    ! .gt. for <= uv6.00
c             call only for high energy particles
c                  (at AS generation, some ptcl may have < KEminObs
c                  or some may loose energy by dE/dx etc.

            call cobservation(2)

            if(Job .eq. 'newskel' .and.
     *          EndLevel .lt. NoOfSites .and. 
     *          MovedTrack.where .eq. EndLevel ) then
c                in this case, even E> KEminObs must be recorded
c                 for skeleton making for kahanshin
c                  where should be +1 at flesh time
               MovedTrack.where = MovedTrack.where + 1
               never = -3
               call chookEInt(never)
               MovedTrack.where = MovedTrack.where - 1 ! for safty
            endif
         elseif(Job .eq. 'newskel'  .and. 
     *          EndLevel .eq. NoOfSites .and.
     *          MovedTrack.where .lt. EndLevel )  then
c            &&&&&&  this is to be recorded
c                where should be + 1 at flesh time
            MovedTrack.where = MovedTrack.where + 1
            never = -2
            call chookEInt(never)
            MovedTrack.where = MovedTrack.where - 1
c            &&&&& 
         endif
c               update observation place
         if(abs(ObsPlane) .eq. perpendicular) then
            call cscalerProd(MovedTrack.vec.w, DcAtObsXyz,
     *               cosangle)
            if(cosangle .lt. 0.) then
               MovedTrack.where = MovedTrack.where - 1
            else
               MovedTrack.where = MovedTrack.where + 1
            endif
c                  if more obs-site, stack current ptcl.
            if(.not. Upgoing) then ! incident is downgoing
               if(MovedTrack.where .gt. EndLevel) then
                                ! no need to stack; discard ptcl.
               else
                  MovedTrack.where =max( MovedTrack.where*1, 1)
                  call cpush(MovedTrack)
               endif
            else                !incident is  Upgoing
               if(MovedTrack.where .lt.1 ) then
                                ! no need to stack
               else
                  MovedTrack.where =
     *                         min(MovedTrack.where*1, EndLevel)
                  call cpush(MovedTrack)
               endif
            endif
         else
            MovedTrack.where = nextwhere
            call cpush(MovedTrack)
         endif
      elseif(MoveStat .eq. BorderL) then
         call cobservation(3)
      elseif(MoveStat .eq. BorderH) then
         call cobservation(1)
      elseif(MoveStat .eq. Dead) then   
c            actually this will not happen. branch is
c           made before this
#if DETAILED_TRACKING >= 1
         call cobservation(5)
#endif
      elseif(MoveStat .eq. AngleLimit) then
#if DETAILED_TRACKING >= 2
         call cobservation(7)
#endif
      else
         write(msg, *) ' movestat=',MoveStat,' invalid'
         call cerrorMsg(msg, 0)
      endif   
      end
      subroutine cresetTimer(aTrack)
      implicit none
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
#include  "Zincidentv.h"
#include  "Zcode.h"
#include  "Zmanagerp.h"
      record /track/ aTrack
c             reset minimum time to reach the obs level (time from this
c             hight to the obs. level), if no mag. exists until
c                  the first collision point. or ptcl goes streight
      if(mod(HowGeomag, 2) .eq. 1 .or. 
     *     IncidentCopy.p.charge .eq. 0 .and.
     *     ObsPlane .ne. 3) then
         call csetMinTime(aTrack)
      else
c         MovedTrack.t = 0.     ! bug bef uv6.09 ;;; but why commentout ??? 
      endif
      end

#if DEBUG > 0
      subroutine checkstat(str)
      implicit none
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsv.h"

      logical deb
      common /cdebug/deb

      character*(*) str
      integer i
      integer nc
      data nc/0/
      nc = nc + 1
c      if(nc .gt. 750) then
      if( deb) then


            write(*,*) str, ' code=',TrackBefMove.p.code,
     *         ' cg',TrackBefMove.p.charge,
     *         ' e=', TrackBefMove.p.fm.p(4), ' stat=',MoveStat
            write(*, *) ' where', TrackBefMove.where
            write(*,*)  ' h==', TrackBefMove.pos.height,
     *       ' d=', TrackBefMove.pos.depth
            write(*,*) ' cos=',TrackBefMove.vec.coszenith
            do i = 1, NumberOfInte
               write(*, *) ' process=',IntInfArray(i).process
               write(*, *) ' thickness=',IntInfArray(i).thickness
               write(*, *) ' length=',IntInfArray(1).length
            enddo
            write(*,*)'  ProcessNo=', ProcessNo
            write(*,*)  '--------------'
c         endif
         endif
      end
#endif
c-------------------------------------------------------
      subroutine cfixMedia
      implicit none
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Ztrackp.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"

      real*8 x/0./, y/0./, z/0./
      save x, y, z
      real*8 distant
      integer icon
      real*8 u

c       weight average  ! weight ratio: 75.53, 23.14, 1.28 %
      TargetMassN = 14.7
      TargetAtomicN = 7.36
      TargetZ2 = 55.7  ! <Z^2>
      
      call rndc(u)
c            volume ratio
      if(u .lt. .78) then
c          nitrogen
         TargetNucleonNo = 14
         TargetProtonNo = 7
      elseif(u .lt. .99) then
c             oxigen
         TargetNucleonNo = 16
         TargetProtonNo = 8
      else
c         argon
         TargetNucleonNo = 40
         TargetProtonNo = 18
      endif

      if(HowGeomag .le. 2 .or. HowGeomag .eq. 31) then
c             distant; change of B is < 1 % 
         call clengSmallBC(TrackBefMove, distant)
c   **********
         distant = distant/10.
c   **********
         if( (TrackBefMove.pos.xyz.r(1) - x)**2 + 
     *        (TrackBefMove.pos.xyz.r(2) - y)**2 + 
     *        (TrackBefMove.pos.xyz.r(3) - z)**2 
     *        .gt. distant**2) then
c              if more than MagChgDist m from previous mag set.,
c               reset mag field.
c
            call cgeomag(YearOfGeomag,  TrackBefMove.pos.xyz, 
     *                Mag, icon)

            call ctransMagTo('xyz', TrackBefMove.pos.xyz, 
     *        Mag, Mag)
            x = TrackBefMove.pos.xyz.r(1)
            y = TrackBefMove.pos.xyz.r(2)
            z = TrackBefMove.pos.xyz.r(3)

         endif
      else
         Mag = MagfieldXYZ
      endif
      end

c     --------------------------------------------------
      subroutine csampIntL
c     **************************************************
c          
c          sample interaction length 
c          and interaction type.
c       Method.  Sample interaction lengths for all possible 
c                interactions (for collisions, in kg/m2, for decay
c                in m).  They are stored in a record /intinf/ IntInfArray
c                given in Ztrackv.h;  
c            In the routine,  cfixProc, 
c                we take the minimum of values given in kg/m2, and
c                convert it in real lenght (m).  In this process,
c                path truncation may occur (if the particle is
c                going upward, and there is very thin air there,
c                then the given thickness may not be realized.
c                Or if the lenght is too large and accuracy 
c                of convesion is not enough due to the earch
c                curverture)
c                If the decay process exists, we compare the length
c                given by the above treatment, and take shorter one.
c                If decay length is shorter,  we assume the decay
c                takes place, else some collision takes place if
c                the path is not truncated. In the latter case,
c                if the path is truncated, MoveStat == Truncated
c                is set.
      implicit none

#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"

      real*8 leng/1.d50/   ! will  be truncated  by ctruncPath

c     **************************************************
      call ciniSmpIntL   ! init for interaction length sampling
c
      if(Reverse .ne. 0) then
         call csetIntInf(leng, .true., 'none')
         ProcessNo = 1
      else
         if(TrackBefMove.p.code .eq. kelec) then
            call csampEIntL
         elseif(TrackBefMove.p.code .eq. kphoton) then
            call csampGIntL
         else
            call csampNEPIntL   ! non Electron Photon  Interaction.
         endif
         call cfixProc
         if(.not. Freec .and. Zfirst.pos.depth .eq. 0.) then
            IntInfArray(ProcessNo).length = 0.
            IntInfArray(ProcessNo).thickness = 0.
         endif
      endif
      end
c     **************************** cfixProc **********
      subroutine cfixProc
      implicit none

#include  "Zglobalc.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zearth.h"


      real*8 h, leng, t, minlen, clen2thick, pcut
c     
      integer i, jcut
c     
       minlen = Infty + Infty

c              get vertical height
       h = TrackBefMove.pos.height
       do i = 1, NumberOfInte
         if(.not. IntInfArray(i).decay) then
c              convert kg/m2 into length
            if(NumberOfInte .eq. 1 .or.
     *        IntInfArray(i).thickness .ne. Infty) then
               call cthick2len(TrackBefMove,
     *         IntInfArray(i).thickness, leng, t, jcut) 
               if(leng .le. 0.) then
                  leng = 1.d-3
               endif
            else
               leng = Infty
            endif
         else
            leng = IntInfArray(i).length
            jcut = 0
         endif
         if(leng .lt. minlen) then
            if(jcut .ne. 0) then
               MoveStat = Truncated
            else
               jcut = 0
               MoveStat = ToInteract
            endif
            ProcessNo = i
            IntInfArray(i).length = leng
            minlen = leng
         endif
      enddo
c      if(leng .ge. minlen) then  !   bug in 6.00
c      if(leng .ge. Infty) then  
c         ProcessNo = 1
c         IntInfArray(1).length = 1.e5
c      endif         
      if(IntInfArray(ProcessNo).decay .or. jcut .ne. 0) then
c         In the case  of muon, if individual knockon process  
c       is neglected (by parameter setting or with high Emin)
c       the length could be quite large (say, 6000  km).
c       and results in error in the next call.
c       To avoid that, we cut the path here
c
         if( TrackBefMove.vec.coszenith .lt. 0.) then
            pcut = 300.d3
         else
            pcut = 30.d3
         endif
         if(IntInfArray(ProcessNo).length .gt. pcut) then
            MoveStat = Truncated
            IntInfArray(ProcessNo).length  = pcut
         endif
         IntInfArray(ProcessNo).thickness = clen2thick(h, 
     *      TrackBefMove.vec.coszenith, 
     *      IntInfArray(ProcessNo).length )
      endif
      end
c     ***********************
c          truncate a path of the particle, if the path
c        given in InfIntArray is too long, or the path traverses
c        an observation depth.
      subroutine ctruncPath
      implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"

      real*8 leng, thick
c
      call cmaxMovLen(leng, thick)
c//////////
c      write(*,*) ' -- maxlen=',leng, ' thick=',thick,
c     *  ' proce no=',ProcessNo, ' proc=',
c     *    IntInfArray(ProcessNo).process,
c     * ' int leng=',  IntInfArray(ProcessNo).length 
c////////////
      if(leng .lt. IntInfArray(ProcessNo).length ) then
         MoveStat = Truncated
         IntInfArray(ProcessNo).length = leng
         IntInfArray(ProcessNo).thickness  = thick
      endif
      end
