c******************************************************************************
c******************************************************************************
c******************************************************************************
c**--------------------------------------------------------------------------**
c**                                                                          **
c**                                                 june, 1992               **
c**                                     modified: nov.14, 1993               **
c**                                                                          **
c**                                                                          **
c**           lund monte carlo for hadron-hadron, hadron-nucleus             **
c**                                                                          **
c**                     and nucleus-nucleus collisions                       **
c**                                                                          **
c**                                                                          **
c**                            fritiof version 7.02                          **
c**                                                                          **
c**                                                                          **
c**    authors:                                                              **
c**    fritiof 7.0:       hong pi                                            **
c**    fritiof 4.0 - 6.0: linkai ding, evert stenlund, ulf pettersson        **
c**    fritiof 3.1: bo nilsson-almqvist, evert stenlund, conny sj\"ogren"    **
c**    fritiof 1.6 - 1.7: bo nilsson-almqvist, evert stenlund                **
c**                                                                          **
c**          department of theoretical physics, university of lund           **
c**                 solvegatan 14a, s-223 62 lund, sweden                    **
c**                                                                          **
c**                                                                          **
c**              * please report programme errors to authors *               **
c**                                                                          **
c**                internet: pihong@thep.lu.se                               **
c**                bitnet: thephp@seldc52.bitnet                             **
c**                                                                          **
c**                                                                          **
c**    notice:                                                               **
c**    fritiof 7.02 subroutine packages must be compiled together with       **
c**    ariadne 4.02r, jetset 7.3, and pythia 5.5.  be sure you have the      **
c**    proper versions of these lund programs.                               **
c**                                                                          **
c**--------------------------------------------------------------------------**
c******************************************************************************
c**   draft code: 2931114                                                     |
c**||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
c-----------------------------------------------------------------------------
c... this is a sample main program - disguised here as a subroutine,
c... which can be used to test the installation of fritiof.
c.......................................................................
c... this program generates a few sample fritiof events, and then does
c... histogram for negatively charged particle multiplicity distribution
c... in o+au collision at 200 gev/nucleon lab energy.
c... the purpose here is to illustrate the typical usage of fritiof.  
c... this routine, loaded together with fritiof_70, ariadne_4.02r,
c... pythia_55 and jetset_73, can be used to test the installation of 
c... these programs.
c---------------------------------------------------------------------

      subroutine frsample
      implicit double precision (a-h,o-z)
      save
c                                             -- a sample main program
      parameter (ksz1=20)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
       include "Zlujets.h"
      common/ludat3/mdcy(500,3),mdme(2000,2),brat(2000),kfdp(2000,5)
      dimension mp(0:300)
      save /frpara1/,/frintn0/,/ludat1/,/lujets/,/ludat3/

c...open a file to take the write out of the program:
      mstu(11) = 20
      open(mstu(11),file='test.out',status='unknown')

c:::::::multiplicity distribution for o+au collision at 200 gev ::::::::

c...forbid the decays of lambda and k_s0: 
      mdcy(lucomp(3122),1) = 0
      mdcy(lucomp(310),1) = 0

c...book spaces for the histogram (or use a histogram package):
      do 50 j=0,300
50    mp(j) = 0

c...test 10 events (of course a lot more events are needed realistically):
c////       nevent=10
      nevent=10
      ntrig = 0
      do 100 i=1, nevent

c/////      call frevent('fixt','o','au',200.d0)
      call frevent('fixt','p','p', 50.d0)
c////////////
      write(*, *) 'end of 1 event'
c/////////////


c...output the event using jetset routine lulist:
      if(i.le.3) call lulist(1)

c...edit the event record, remove partons or decayed particles:
      call luedit(1)

c...assume a trigger requiring that the energy in the forward cone
c...(theta < 0.3 degree) must be less than 60% of the total beam energy.
c...also find out the number of negatively charged particles:
      iqtrig = 0
      efwd = 0.
      n_=0
      do 70 j=1, n
      theta = plu(j,14)
c...  (plu is a jetset function.  please refer to the jetset manual.)
      if(theta.lt.0.3) efwd = efwd+plu(j,4)

c...count the negative particles.  spectator nuclei, which have codes
c...abs(k(j,2))=10000+n_proton, must be excluded:
      if(abs(k(j,2)).lt.10000) then
        if(plu(j,6).lt.0.) n_ = n_+1
      endif
70    continue

      ebeam = 200.*iop(3)
      if(efwd.lt.0.6*ebeam) iqtrig = 1

c...do histogram:
      if(iqtrig.eq.1) then
      ntrig = ntrig+1
      mp(n_) = mp(n_)+1
      endif

100   continue

c...output the histogram data:  
      write(mstu(11),500) nevent, ntrig
      do 200 j=0,300
200   write(mstu(11),*) j, dble(mp(j))/dble(ntrig)
500   format(1x,'number of events:',i4,2x,'triggered events:',i4)

c...write out the values of the parameters and some statistics:
      call frvalue(0)
             
      close (mstu(11))
      end

c*************************************************************************


c*************************************************************************
c*                                                                       *
c*   fritiof 7.02 subroutine packages                                     *
c*                                                                       *
c------------------------------------------------------------------------*
c*************************************************************************

c**************************** freditd ***********************************

      subroutine freditd()
      implicit double precision (a-h,o-z)
      save

c...this is a dummy subroutine in connection to option kfr(13)>=4.
c...user may elect to write his own special purpose codes here that
c...edits and compresses the event record lujets.  there may also be
c...times the user wish to keep a trace on certain decay products by
c...assigning them a special codes here.

      parameter (ksz1=20)
      common/frpara1/kfr(ksz1),vfr(ksz1)
       include "Zlujets.h"
      save /frpara1/,/lujets/

c.....dummy
      return
      end

c**************************** end freditd *******************************


c**************************** frevent ***********************************

      subroutine frevent(frame,beam,target,win)
      implicit double precision (a-h,o-z)
      save

c...this is the main routine that initializes and call fringeb to
c...administrate the event generation 
  
      parameter (ksz1=20,ksz2=300)
      character*(*) frame,beam,target
      character cframe*4,cbeam*4,ctarg*4,cmem*4
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ardat1/para(40),msta(40)
      include "Zlujets.h"
      dimension cmem(3)
      save cmem,winm,ifst
      save /frintn0/,/frintn3/,/frpara1/,/ludat1/,/ardat1/
      data winm,ifst /0.,0/
      
c.....check particles and frame, set initial momenta and write header

       cbeam=beam
       ctarg=target
       cframe=frame

       call frupcas(cframe)      
       call frupcas(cbeam)
       call frupcas(ctarg)

       inew = 0
       if((cframe.ne.cmem(1)).or.(cbeam.ne.cmem(2)).or.
     >    (ctarg.ne.cmem(3)).or.(abs(win-winm).gt.0.1)) inew=1

       if(inew.gt.0) then
         cmem(1) = cframe
         cmem(2) = cbeam
         cmem(3) = ctarg
         winm = win
         call frinita(cframe,cbeam,ctarg,win)
         if(kszj.ne.mstu(4)) then
         call frmgout(0,0,'lujets not compatible in fritiof and jetset'
     >                ,dble(kszj),dble(mstu(4)),0.d0,0.d0,0.d0)
         endif 
      endif

      if(ifst.eq.0) then
      do 12 lo=1, ksz1
12    nfr(lo)= 0
c.....     set some control parameters for ariadne and jetset:
      msta(7) = mstu(11)
      msta(8) = mstu(11)
      msta(9) = 0
      msta(14) = 0
c.....extended partons made massless, for compatibility with ar3.03
      msta(31) = 0

        if(kfr(12).eq.1) then
c             fragmentation parameters set to the opal optimized values:
        call artune('opal') 
        elseif(kfr(12).ge.2) then
c                               delphi optimized values
        call artune('delphi') 
        endif
      call arinit('ariadne')
      ifst= 1
      endif

c.....administrate one event.........................................

      call fringeb

      return
      end

c**************************** end fritiof *******************************

c**************************** frinita ************************************

      subroutine frinita(cframe,cbeam,ctarg,win)
      implicit double precision (a-h,o-z)
      save

c purpose: identifies the particles involved and fills common block 
c calculates initial momenta and fills common block frintn0.
c write out information about the particles and the event selection.
c the program is stopped if the beam or target particles or the frame
c are not recognized.
c this routine calls frhildn for setting the particle codes and masses.

      parameter (ksz1=20, ksz2=300)
      character cframe*4,cbeam*4,ctarg*4, partic*4,pacd*4
      character init*42, cgdate*11 
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frcodes/ipt(2),pacd(27),nnuc(27),nprot(27),kcd(27)
     >           ,ro1(27,2),exma(9,2)
      common/frgeomc/nflg,numrop,numrot,numrep
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)

      save vfr10
      save /frintn0/,/frintn3/,/frpara1/,/frcodes/,/frgeomc/,/ludat1/
      data vfr10 /0./

      data iqfst /0/
      data cgdate /'14 nov 1993'/

       iwr = 0
c         /////////////// change by kk; supress message if kfr(11) = 0
c       if(kfr(11).lt.0.or.iqfst.le.kfr(11)) iwr=1 
       if(kfr(11).lt.0.or.iqfst.lt.kfr(11)) iwr=1 
c.....................identify the particles involved....................
       do 110 l=1, 2
       ipt(l) = 0
       if(l.eq.1) partic=cbeam
       if(l.eq.2) partic=ctarg
       do 100 j=1,27
       if(partic.eq.pacd(j)) then
         ipt(l)=j
         iop(3+2*(l-1))=nnuc(ipt(l))
         iop(4+2*(l-1))=nprot(ipt(l))
         iop(6+l)=kcd(ipt(l))
         goto 110
       endif
 100   continue
 110   continue

c................................................write headers........
       if(mstu(12).eq.1) then
       write(mstu(11),1000) cgdate
       call lulist(0)
       write(mstu(11),*)
       write(mstu(11),*)
       endif

       if(ipt(1).eq.0) write(mstu(11),1100) cbeam
       if(ipt(2).eq.0) write(mstu(11),1200) ctarg
       if(ipt(1).eq.0.or.ipt(2).eq.0) stop 99901

       if(iop(3).eq.0.or.iop(5).eq.0) then
        write(mstu(11),1300)
        stop 99902
       endif
       if(iop(3).gt.ksz2) write(mstu(11),1310) iop(3)
       if(iop(5).gt.ksz2) write(mstu(11),1320) iop(5)
       if(iop(3).gt.ksz2.or.iop(5).gt.ksz2) stop 99903        

c.....set minimum mass and minimum diffractive mass

      do 112 l=1, 2
      if(nnuc(ipt(l)).le.1.and.ipt(l).le.9) then
      aop(8+l) = exma(ipt(l),1)
      aop(10+l) = exma(ipt(l),2)
      elseif(nnuc(ipt(l)).ge.2) then
      aop(8+l) = exma(8,1)
      aop(10+l) = exma(8,2)
      endif
      if(kcd(ipt(l)).ne.0) then
      pmas = ulmass(kcd(ipt(l)))
      if(aop(8+l).lt.pmas) aop(8+l)=pmas
      endif
      if(aop(8+l).le.0.0001) aop(8+l) = exma(8,1)
      if(aop(10+l).lt.aop(8+l)) aop(10+l) = aop(8+l)
112   continue

      call frhildn

       do 115 l=1,2
       do 115 lo=1,2
115    pli0(l,lo) = 0.

       if(cframe.eq.'cms') then
         init=cbeam//'-'//ctarg//' collider'//' '
         if(iwr.eq.1) write(mstu(11),1400) init
         if(iwr.eq.1) write(mstu(11),1500) win

c...in case of nucleus, here we have neglected the mass differece
c...between the nucleons.........................................
         s0=win**2
         fp = fmn(1,1)**2
         ft = fmn(2,1)**2
         pl2=s0/4-(fp+ft)/2+(fp-ft)**2/(4*s0)
         esen=frsqr(pl2 + fp, 'esenpl' )
         pli0(1,4) =esen+frsqr(pl2, 'euiron' )
         pli0(1,3) =fp/pli0(1,4)

         esen=frsqr(pl2 + ft, 'esenft')
         pli0(2,3) =esen+frsqr(pl2,'iopji1' )
         pli0(2,4) =ft/pli0(2,3)
       aop(1) = win

       elseif(cframe.eq.'fixt') then

       plab = win
       elab = sqrt(plab**2+fmn(1,1)**2)
          pli0(1,4) =elab+plab
          pli0(1,3) =fmn(1,1)**2/pli0(1,4)
          pli0(2,4) =fmn(2,1)
          pli0(2,3) =fmn(2,1)
      s0 = (pli0(1,4)+pli0(2,4))*(pli0(1,3)+pli0(2,3))
        aop(1) = sqrt(s0)
         init=cbeam//' on '//ctarg//' fixed target'//' '
         if(iwr.eq.1) then
       write(mstu(11),1400) init
         if(iop(3).gt.1) write(mstu(11),1600) win, aop(1)
         if(iop(3).eq.1) write(mstu(11),1610) win, aop(1)
       endif
       else
         write(mstu(11),2000) cframe
       stop 99904                   
       endif
      
       if(iwr.eq.1) then
       write(mstu(11),2005) iop(3),iop(4),iop(5),iop(6)
       if(iop(3)+iop(5).gt.2) write(mstu(11),2007)
       endif
         

c.....evaluate cross sections :

       if(nfr(1).gt.0.and.abs(vfr(10)-vfr10).lt.0.001) then
       vfr(10) = 0.
       vfr(11) = 0.
       endif

       call frqprob(idn(1,1),idn(2,1),iwr)
       vfr10 = vfr(10)

c..... set up a few control parameters for the geometry package:
c ...  nflg is the entry control of subroutines frpacol & fraacol

       nflg=0
       numrop=1
       if (iop(3).gt.25) numrop=3
       numrot=1
       if (iop(5).gt.25) numrot=3
       if (kfr(6).eq.1.or.(kfr(6).eq.2.and.iop(5).gt.79) ) numrot=200
       numrep=1
       if (iop(3).gt. 50.or.iop(5).gt. 50) numrep=3
       if (iop(3).gt.100.or.iop(5).gt.100) numrep=6
       if (iop(3).gt.200.or.iop(5).gt.200) numrep=10

c    /////////////
          if(iwr .eq. 1) then
c    /////////////

      if(nfr(1).eq.0) then
       if(kfr(2).eq.0) then
        write(mstu(11),2100) 
       elseif(kfr(2).eq.1) then
             write(mstu(11),2110) 
             write(mstu(11),2120) vfr(8),vfr(9)
       endif
       if(kfr(1).eq.0) then
             write(mstu(11),2130) 
       elseif(kfr(1).eq.1) then
        write(mstu(11),2140)
       endif 
       if(iop(5).gt.1) then
        if(kfr(3).eq.0) then
         write(mstu(11),2200) 
        elseif(kfr(3).eq.1.or.kfr(3).eq.3) then
         write(mstu(11),2210)
        elseif(kfr(3).eq.2.or.kfr(3).eq.3) then
         write(mstu(11),2220) vfr(1),vfr(2)
        endif
        if(kfr(4).eq.0) then
         write(mstu(11),2230) 
        elseif(kfr(4).eq.1) then
         write(mstu(11),2240)
        endif 
        if(kfr(5).eq.0) then
         write(mstu(11),2250) 
        elseif(kfr(5).eq.1) then
         write(mstu(11),2254) 
        elseif(kfr(5).eq.2) then
         write(mstu(11),2258) 
        endif 
        if(kfr(6).eq.0.or.(kfr(6).eq.2.and.iop(5).le.79)) then
         write(mstu(11),2260) 
        else
         write(mstu(11),2270) vfr(4), vfr(5)
        endif 
       endif
       if(kfr(7).eq.0) then
        write(mstu(11),2280) 
       elseif(kfr(7).eq.1) then
        write(mstu(11),2290) 
       elseif(kfr(7).eq.2) then
        write(mstu(11),3000)
       endif
       write(mstu(11),*) '  '  
      endif 

        iqfst= iqfst+1
c///////////////
       endif      !  if(iwr ..)
c //////////////   
c........................formats for initialization and error information
 1000 format(//20x,'the lund monte carlo - fritiof version 7.02'/
     *         20x,'last date of change/bug fixing: ', a11)
 1100 format(1x,'error: unrecognized beam particle ''',a,
     * '''. execution stopped.')
 1200 format(1x,'error: unrecognized target particle ''',a,
     * '''. execution stopped.')
 1300 format(1x,'error: particles not well defined. execution stopped.')
 1310 format(1x,'error: too large projectile, iop(3)= ',i5,
     * '. execution stopped.')
 1320 format(1x,'error: too large target,iop(5)= ',i5,
     * '. execution stopped.')
 1400 format(/1x,77('=')/1x,'|',75x,'|'/1x,'|',8x,'fritiof will be ',
     *'initialized for',1x,a34,1x,'|')
 1500 format(1x,'|',15x,'at',1x,f10.3,1x,'gev center-of-mass energy',
     *21x,'|'/1x,'|',75x,'|'/1x,77('='))
 1600 format(1x,'|',12x,'at',1x,f10.3,1x,'gev/c lab-momentum per nucleon
     *',19x,'|'/1x,'|',18x,'equivalent cms energy w= ',f9.4,1x,'gev',
     > 19x,'|'/1x,'|',75x,'|'/1x,77('='))
 1610 format(1x,'|',23x,'at',1x,f10.3,1x,'gev/c lab-momentum
     *',8x,'|'/1x,'|',18x,'equivalent cms energy w= ',f9.4,1x,'gev',
     > 19x,'|'/1x,'|',75x,'|'/1x,77('='))
 2000 format(1x,'error: unrecognized coordinate frame ''',a,
     *'''. execution stopped.')
 2005 format(1x,5x,'projectile (a,z)= ','(',i3,',',i3,')',
     > 4x,'target (a,z)= ','(',i3,',',i3,')',/)
 2007 format(/,/,4x,'a reminder: if the event is listed by lulist,',
     > 1x,'the lines without' /,4x,'character names represent the',
     > 1x,'spectator nuclei.')
2100   format(/,/,4x,'no gluon radiation')
2110   format(    4x,'gluon radiation included')
2120   format(4x,'mu (projectile) =',f5.2,1x,'gev;',3x,
     >           'mu (target) =',f5.2,1x,'gev')
2130   format(    4x,'fragmentation not performed')
2140   format(    4x,'fragmentation performed')
2200   format(    4x,'all interactions recorded')
2210   format(    4x,'spectator veto')
2220   format(4x,'impact parameter restricted in',
     >                                 1x,f7.3,'-',f7.3,' fm')
2230   format(    4x,'no fermi motion')
2240   format(    4x,'fermi motion included')
2250   format(    4x,'overlap function: eikonal')
2254   format(    4x,'overlap function: gaussian')
2258   format(    4x,'overlap function: gray disc')
2260   format(    4x,'no target nucleus deformation')
2270   format(    4x,'target nucleus deformation applied.',1x,
     >            'dipole and quadrupole coeff: ',f7.3,',',2x,f7.3)
2280   format(    4x,'no qcd parton scattering')
2290   format(    4x,'hardest rutherford parton scattering included')
3000   format(    4x,'multiple parton scattering included')

      return
      end

c******************************** end frinita ***************************


c******************************** frhildn *******************************

      subroutine frhildn
      implicit double precision (a-h,o-z)
      save

c...this routine sets particle codes and masses. fills common block
c...frintn3-idn,fmn; randomly order the neutrons and protons.

      parameter (ksz1=20,ksz2=300) 
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      save /frintn0/,/frpara1/,/frintn3/

      do 100 l=1,2

      if(iop(3+2*(l-1)).le.1) then
      idn(l,1)=iop(6+l)
      fmn(l,1)=ulmass(idn(l,1))
      
      else
      
      ipr=0
      inu=0
      iz0=iop(4+2*(l-1))
      ia0=iop(3+2*(l-1))
      do 30 i=1, ia0
         s=rlu(0)
         q=dble(iz0-ipr)/(ia0-ipr-inu)
         if (ipr.lt.iz0.and.(s.lt.q.or.inu.eq.ia0-iz0)) then
            idn(l,i)=2212
            ipr= ipr+1
         else  
            idn(l,i)=2112
            inu= inu+1
         endif
         fmn(l,i)=ulmass(idn(l,i))
   30 continue
         if(ipr.ne.iz0.or.inu.ne.ia0-iz0) call frmgout(0,0, 
     >   ' proton or neutron numbers incorrect!',dble(ia0),dble(iz0),
     >     dble(ipr),dble(inu),0.d0)
      endif

  100 continue

      return
      end

c******************************** end frhildn ****************************

c******************************** fringeb  *******************************

      subroutine fringeb
      implicit double precision (a-h,o-z)
      save

c........................this routine administrates one complete event

      parameter (ksz1=20,ksz2=300)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frintn1/pps(2,ksz2,5),pph(2,ksz2,5),ppsy(2,ksz2,5),ppa(2,5)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      common/frintn4/kfend(2,ksz2,2)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frgeomc/nflg,numrop,numrot,numrep
      common/frcont2/ict(10),ictt(10)
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)

      save /frintn0/,/frintn1/,/frintn3/,/frintn4/,/frpara1/,/frgeomc/,
     >     /frcont2/,/lujets/,/ludat1/

      nfr(1) = nfr(1) + 1
  2   iop(16)=0

c.....randomly order protons and neutrons:
      call frhildn

c.....create the nuclei and calculate number of collisions
      call frangan

c.....fix the end flavors for wounded strings
      do 5 l=1,2 
      do 5 ii=1, iop(9+(l-1))
   5  call frbeleo(kfend(l,ii,1),kfend(l,ii,2),idn(l,ii))

c.....generate the masses and momenta after the collisions
 10   call frringo

      mstu24=0
      nmem=0
c.. fill the strings and emit gluons: 
      n=0
      nstr = 0
      iop(15) = 0
      do 100 l=1, 2
      do 100 j=1,iop(8+l)
      call frtorst(l,j)
      nstr = nstr+1
      nqg = n-nmem
               if( (kfr(1).eq.1.and.kfr(13).ge.1).and.
     >             (nstr.gt.100.or.nqg.gt.(kszj-n)/10) ) then
      call luexec
      if(mstu(24).eq.4) mstu24=1
          if(kfr(13).le.3) then
        call luedit(kfr(13))
          elseif(kfr(13).ge.4) then 
        call freditd()
          endif
      nmem=n
      nstr=0
               endif
100   continue
       
c....to add onto lujets the colour neutral particles that may 
c....have been produced from parton-parton processes: 
      call frfilhw

      if(n.ge.kszj-2) call frmgout(0,1,
     > 'lujets array size kszj must be expanded',dble(n),dble(kszj),
     >  0.d0,0.d0,0.d0)

      if(kfr(1).eq.1.and.n.gt.nmem) then
      call  luexec
      if(mstu(24).eq.4) mstu24=1
        if(kfr(13).ge.1.and.kfr(13).le.3) then
      call luedit(kfr(13))
        elseif(kfr(13).ge.4) then 
      call freditd()
        endif
      endif

c... regenerate event in case of 'infinite-loop error' in jetset:
      if(mstu24.gt.0) goto 2

c....record the number of n-n collisions:
      iop(2) = iop(2)-ict(3)-ict(8)-ict(10)
      nfr(3) = nfr(3) + iop(2)

       nfr(4) = nfr(4) + iop(13)
       if(iop(13).ge.1) nfr(5) = nfr(5)+1
      
c-----recording of impact parameter and counting of spectator protons  

      iop(11)=iop(4)
      iop(12)=iop(6)
      do 200 l=1, 2
      do 200 j=1,iop(9+l-1)
      if(idn(l,j).eq.2212) iop(10+l)=iop(10+l)-1
  200 continue

      if(idn(1,1).ne.2212.and.idn(1,1).ne.2112) iop(11)=0 

c.....add the nuclei spectators onto the event record:
      do 300 l=1,2
      if(iop(3+2*(l-1))-iop(8+l).ge.1) then
      n = n+1
      p(n,1)=ppa(l,1)
      p(n,2)=ppa(l,2)
      p(n,3)=0.5*(ppa(l,4)-ppa(l,3))
      p(n,4)=0.5*(ppa(l,4)+ppa(l,3))
      p(n,5)=ppa(l,5)
      k(n,1) = 4
      k(n,2) = (10000+iop(10+l))*(-1)**(l-1)
      k(n,3) = 0
      k(n,4) = 0
      k(n,5) = 0
      endif
300   continue

c....check energy, momentum and charge conservation:
      if(kfr(14).eq.1) call frchkep(1)

c....dump out the event for inspection when error occurs in frmgout:
      if(iop(16).ge.1) call lulist(2)

      return
      end 

c******************************** end fringeb  ***************************


c*************************************************************************
c*************************************************************************
c                                                                        *
c      this is the routine package for nuclear geometry                  *
c      input frintn0, output frintn3_nuc                                  *
c                                                                        *
c*************************************************************************


c********************************* frangan ****************************

      subroutine frangan
      implicit double precision (a-h,o-z)
      save

      parameter (ksz1=20,ksz2=300)
      common/frgeomc/nflg,numrop,numrot,numrep
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      save /frgeomc/,/frpara1/,/frintn0/,/frintn3/

      if (iop(3).le.1.and.iop(5).le.1) then
       call frppcol

      else
      
      call frovlap      
            if(iop(3).le.1.or.iop(5).le.1) then
      call frpacol
            else
      call fraacol
            endif

      endif

      return
      end

c********************************* end frangan ****************************

c********************************* frppcol *****************************

          subroutine frppcol
      implicit double precision (a-h,o-z)
      save

c --- this routine takes care of hadron-hadron collisions

      parameter (ksz1=20,ksz2=300)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      save /frintn0/,/frintn3/

      iop(9)=1
      iop(10)=1
      iop(2)=1
      nuc(1,1)=1
      nuc(2,1)=1

      return
      end

c********************************* end frppcol *************************

c********************************* frpacol *****************************

          subroutine frpacol
      implicit double precision (a-h,o-z)
      save

c --- this routine deals with p-a collisions working in the rest frame
c      of the target center and taking z axis parallel to the projectile
c      incident direction

      parameter (ksz1=20,ksz2=300)
      common/frgeomc/nflg,numrop,numrot,numrep
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)

      dimension cort(ksz2,3)

50    if (nflg.ne.0) goto 100
c ==> first entry
      nflg=1
      nflg2=0

c --- initialization
c.....rmin is the minimum distance required between two nucleons.
  
      rmin=vfr(3)
      rmin2=rmin*rmin
      cutoff=aop(7)*3.
c --- parameters of the nucleon density distribution
      na=iop(5)
        if (kfr(6).eq.0.or.(kfr(6).eq.2.and.iop(5).le.79) ) then
         call frsearc(2,fmmt,rmmt)
        else
         call frnucdf(na,a0,a2,a4,rmax3)
        endif

100   if (nflg2.ne.0) goto 120
c ==> second entry
      nflg2=1
      nflg3=0
      nrot=0

c --- determine the coordinates of target nucleons
      na=iop(5)
        if (kfr(6).eq.0.or.(kfr(6).eq.2.and.iop(5).le.79) ) then
          call frnucor(2,na,rmin2,fmmt,rmmt,cort)
        else
          call frnucod(na,rmin2,a0,a2,a4,rmax3,cort)
        endif

120   if (nflg3.ne.0) goto 150
c ==> third entry
      nflg3=1
      nrep=0
      nrot=nrot+1

        if (kfr(6).eq.0.or.(kfr(6).eq.2.and.iop(5).le.79) ) then
c --- rotate the target nucleus 90 degrees
      do 130 i=1,iop(5)
      w=cort(i,1)
      cort(i,1)=cort(i,2)
      cort(i,2)=cort(i,3)
      cort(i,3)=w
130   continue
          else
c --- rotate target nucleus randomly along each axis with probabity 1/3
c     it is checked that this rotation gives an even solid angle dist.
      cdelta=-1.+2.*rlu(0)
      sdelta=frsqr(max(0.d0 ,1.-cdelta**2), 'sdelca' )
      ra=rlu(0)
        if (ra.gt.0.6666667) then
c --- rotate aronud z axis
      do 132 i=1,iop(5)
      x=cort(i,1)*cdelta-cort(i,2)*sdelta
      cort(i,2)=cort(i,1)*sdelta+cort(i,2)*cdelta
      cort(i,1)=x
132   continue
        else if (ra.gt.0.3333333) then
c --- rotate aronud x axis
      do 134 i=1,iop(5)
      y=cort(i,2)*cdelta-cort(i,3)*sdelta
      cort(i,3)=cort(i,2)*sdelta+cort(i,3)*cdelta
      cort(i,2)=y
134   continue
        else
c --- rotate aronud y axis
      do 136 i=1,iop(5)
      z=cort(i,3)*cdelta-cort(i,1)*sdelta
      cort(i,1)=cort(i,3)*sdelta+cort(i,1)*cdelta
      cort(i,3)=z
136   continue
        endif
          endif

c --- find out the scope in x-y plane of target nucleus
      xmaxt=cort(1,1)
      xmint=xmaxt
      ymaxt=cort(1,2)
      ymint=ymaxt
        do 140 i=2,iop(5)
      if (cort(i,1).ge.xmaxt) xmaxt=cort(i,1)
      if (cort(i,1).le.xmint) xmint=cort(i,1)
      if (cort(i,2).ge.ymaxt) ymaxt=cort(i,2)
      if (cort(i,2).le.ymint) ymint=cort(i,2)
140     continue

c --- target area in x-y plane to be shooted
      xmax=xmaxt+cutoff
      xmin=xmint-cutoff
      ymax=ymaxt+cutoff
      ymin=ymint-cutoff

      if (nrot.eq.numrot) nflg2=0

c ==> fourth entry
150   nrep=nrep+1

c --- sample impact, (xp,yp), of projectile
        if (kfr(3).eq.2.or.kfr(3).eq.3) then
      bpro=frsqr(rlu(0)*(vfr(2)*vfr(2)-vfr(1)*vfr(1))
     >                    +vfr(1)*vfr(1),'bpro09')
      bphi=6.2832*rlu(0)
      xp=bpro*cos(bphi)
      yp=bpro*sin(bphi)
        else
      xp=(xmax-xmin)*rlu(0)+xmin
      yp=(ymax-ymin)*rlu(0)+ymin
        endif
      aop(2)=frsqr(xp**2+yp**2,'bipa22')

      iop(2)=0
      iop(9)=0
      iop(10)=0

          do 200 i=1,iop(5)
c --- distance between the projectile proton and a target nucleon
      r2=(xp-cort(i,1))**2+(yp-cort(i,2))**2
c --- judge if a binary collision takes place

      pp = frvov(r2)

        if (rlu(0).lt.pp) then
      iop(2)=iop(2)+1
      iop(10)=iop(10)+1
      if (iop(2).gt.3000) call frmgout(0,0,
     & 'array nuc() needs to be
     > expanded (3000 not enough)', 0.d0,0.d0,0.d0,0.d0,0.d0)
      nuc(1,iop(2))=1
      nuc(2,iop(2))=i
        endif
200   continue

      if (iop(10).gt.0) iop(9)=1

      if (nrep.eq.numrep) nflg3=0

      if ((kfr(3).eq.1.or.kfr(3).eq.3).and.iop(9).lt.iop(3)) goto 50
      if (iop(9).eq.0) goto 50

c --- make order numbers of wounded target nucleons tightly
      do 770 i=1,iop(5)
        ii=999
        do 750 j=1,iop(2)
        if (nuc(2,j).ge.i.and.nuc(2,j).lt.ii) ii=nuc(2,j)
750     continue
        if (ii.eq.i) goto 770
        if (ii.eq.999) goto 780
        do 760 j=1,iop(2)
        if (nuc(2,j).eq.ii) then
          idn(2,i)= idn(2,ii)
          fmn(2,i)= fmn(2,ii)
          nuc(2,j)=i
        endif
760     continue
770   continue
780   continue

      return
      end

c********************************* end frpacol ************************

c********************************* fraacol ******************************

       subroutine fraacol
      implicit double precision (a-h,o-z)
      save

c --- this subroutine deals with a-a collisions working in the rest
c       frame of the target center and taking z axis parallel to the
c       projectile incident direction

      parameter (ksz1=20,ksz2=300)
      common/frgeomc/nflg,numrop,numrot,numrep
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)

      dimension corp(ksz2,3),cort(ksz2,3),markp(ksz2),markt(ksz2)

50    if (nflg.ne.0) goto 100
c ==> first entry
      nflg=1
      nflg2=0

c --- initialization
      rmin=vfr(3)
      rmin2=rmin*rmin
      cutoff=aop(7)*3.
c --- parameters of nucleon density distribution
      na=iop(3)
      call frsearc(1,fmmp,rmmp)
      na=iop(5)
        if (kfr(6).eq.0.or.(kfr(6).eq.2.and.iop(5).le.79) ) then
            call frsearc(2,fmmt,rmmt)
        else
        call frnucdf(na,a0,a2,a4,rmax3)
        endif

100   if (nflg2.ne.0) goto 200
c ==> second entry
      nflg2=1
      nflg3=0
      nrott=0

c --- determine the coordinates of target nucleons
      na=iop(5)
        if (kfr(6).eq.0.or.(kfr(6).eq.2.and.iop(5).le.79) ) then
      call frnucor(2,na,rmin2,fmmt,rmmt,cort)
        else
      call frnucod(na,rmin2,a0,a2,a4,rmax3,cort)
        endif

200   if (nflg3.ne.0) goto 300
c ==> third entry
      nflg3=1
      nflg4=0
      nrott=nrott+1

        if (kfr(6).eq.0.or.(kfr(6).eq.2.and.iop(5).le.79) ) then
c --- rotate the target nucleus
        do 210 i=1,iop(5)
      ww=cort(i,1)
      cort(i,1)=cort(i,2)
      cort(i,2)=cort(i,3)
      cort(i,3)=ww
210     continue
          else
c --- rotate target nucleus randomly along an axis with probabity 1/3
c     it is checked that this rotation gives an even solid angle dist.
      cdelta=-1.+2.*rlu(0)
      sdelta=frsqr(max(0.d0,1.-cdelta**2), 'sde9a6')
      ra=rlu(0)
        if (ra.gt.0.6666667) then
c --- rotate aronud z axis
      do 212 i=1,iop(5)
      x=cort(i,1)*cdelta-cort(i,2)*sdelta
      cort(i,2)=cort(i,1)*sdelta+cort(i,2)*cdelta
      cort(i,1)=x
212   continue
        else if (ra.gt.0.3333333) then
c --- rotate aronud x axis
      do 214 i=1,iop(5)
      y=cort(i,2)*cdelta-cort(i,3)*sdelta
      cort(i,3)=cort(i,2)*sdelta+cort(i,3)*cdelta
      cort(i,2)=y
214   continue
        else
c --- rotate aronud y axis
      do 216 i=1,iop(5)
      z=cort(i,3)*cdelta-cort(i,1)*sdelta
      cort(i,1)=cort(i,3)*sdelta+cort(i,1)*cdelta
      cort(i,3)=z
216   continue
        endif
          endif

c --- find out the scope in x-y plane of sampled target nucleons
      xmaxt=cort(1,1)
      xmint=xmaxt
      ymaxt=cort(1,2)
      ymint=ymaxt
        do 220 i=2,iop(5)
      if (cort(i,1).ge.xmaxt) xmaxt=cort(i,1)
      if (cort(i,1).le.xmint) xmint=cort(i,1)
      if (cort(i,2).ge.ymaxt) ymaxt=cort(i,2)
      if (cort(i,2).le.ymint) ymint=cort(i,2)
220     continue

      nrotp=0
c --- determine the coordinates of projectile nucleons
c       with respect to the rest frame of the projectile center
c       (z axes of two frames are assumed to be parallel each other)
      na=iop(3)
      call frnucor(1,na,rmin2,fmmp,rmmp,corp)

      if (nrott.eq.numrot) nflg2=0

300   if (nflg4.ne.0) goto 400
c ==> fourth entry
      nflg4=1
      nrep=0
      nrotp=nrotp+1

c --- rotate the projectile nucleus 90 degrees
        do 310 i=1,iop(3)
      ww=corp(i,1)
      corp(i,1)=corp(i,2)
      corp(i,2)=corp(i,3)
      corp(i,3)=ww
310     continue

c --- find out the scope of sampled projectile nucleons in thw x-y plane
c       of the projectile rest frame
      xmaxp=corp(1,1)
      xminp=xmaxp
      ymaxp=corp(1,2)
      yminp=xmaxt
        do 320 i=2,iop(3)
      if (corp(i,1).ge.xmaxp) xmaxp=corp(i,1)
      if (corp(i,1).le.xminp) xminp=corp(i,1)
      if (corp(i,2).ge.ymaxp) ymaxp=corp(i,2)
      if (corp(i,2).le.yminp) yminp=corp(i,2)
320     continue

c --- start to treat the nucleus-nucleus collision
c --- first determine the area of the projectile nucleus shooting
c      with respect to the rest frame of the target center
      xmax=xmaxt-xminp+cutoff
      xmin=xmint-xmaxp-cutoff
      ymax=ymaxt-yminp+cutoff
      ymin=ymint-ymaxp-cutoff

      if (nrotp.eq.numrop) nflg3=0

c ==> fifth entry
400   nrep=nrep+1

c --- sample impact of projectile with respect to the target rest frame
        if (kfr(3).eq.2.or.kfr(3).eq.3) then
      bpro=frsqr(rlu(0)*(vfr(2)*vfr(2)-vfr(1)*vfr(1))+
     >                      vfr(1)*vfr(1),'bpro12')
      bphi=6.2832*rlu(0)
      xpro=bpro*cos(bphi)
      ypro=bpro*sin(bphi)
        else
      xpro=(xmax-xmin)*rlu(0)+xmin
      ypro=(ymax-ymin)*rlu(0)+ymin
        endif
      aop(2)=frsqr(xpro**2+ypro**2,'bipa222')

      iop(2)=0
      iop(9)=0
      iop(10)=0

      do 410 i=1,iop(3)
      markp(i)=0
410   continue
      do 420 i=1,iop(5)
      markt(i)=0
420   continue

c --- treat the collisions between two nucleons
          do 600 nup=1,iop(3)
c --- coordinates of projectile nucleon, (xp,yp)
c       with respect to the rest frame of the target center
      xp=corp(nup,1)+xpro
      yp=corp(nup,2)+ypro
      if (xp.gt.xmaxt+cutoff) goto 600
      if (xp.lt.xmint-cutoff) goto 600
      if (yp.gt.ymaxt+cutoff) goto 600
      if (yp.lt.ymint-cutoff) goto 600

          do 500 nut=1,iop(5)
c --- distance between a projectile nucleon and a target nucleon
      r2=(xp-cort(nut,1))**2+(yp-cort(nut,2))**2
c --- judge if a binary collision takes place

      pp = frvov(r2)

      if (rlu(0).lt.pp) then
         iop(2)=iop(2)+1
        if (iop(2).gt.3000) call frmgout(0,0,'array nuct needs to be 
     >  expanded (3000 insufficient)',0.d0,0.d0,0.d0,0.d0,0.d0)
         nuc(1,iop(2))=nup
         nuc(2,iop(2))=nut
       if (markp(nup).eq.0) then
         markp(nup)=1
         iop(9)=iop(9)+1
       endif
       if (markt(nut).eq.0) then
         markt(nut)=1
         iop(10)=iop(10)+1
       endif
      endif
500   continue
600   continue

      if (nrep.eq.numrep) nflg4=0

      if ((kfr(3).eq.1.or.kfr(3).eq.3).and.iop(9).lt.iop(3)) goto 50
      if (iop(9).eq.0) goto 50

c --- order and pack the wounded nucleons in the front: 
      do 700 l=1, 2
      do 670 i=1,iop(3+2*(l-1))
        ii=999
        do 650 j=1,iop(2)
650     if (nuc(l,j).ge.i.and.nuc(l,j).lt.ii) ii=nuc(l,j)

        if (ii.eq.i) goto 670
        if (ii.eq.999) goto 700
        do 660 j=1,iop(2)
        if (nuc(l,j).eq.ii) then
          idn(l,i)= idn(l,ii)
          fmn(l,i)= fmn(l,ii)
          nuc(l,j)=i
        endif
660     continue
670   continue
700   continue


      return
      end

c********************************* end fraacol ***************************


c********************************* frnucor *******************************

      subroutine frnucor(l,na,rmin2,fmm,rmm,cor)
      implicit double precision (a-h,o-z)
      save

c --- this subroutine determines nucleon coordinates inside a nucleus
c     and recenter the sampled nucleons with respect to the rest frame of
c     the nucleus center. l=1 for proj, l=2 for target.

      parameter (ksz2=300)
      dimension cor(ksz2,3),sum(3)

      do 150 j=1,na
c --- sample a nucleon from the nucleus
c --- first, sample r
100   rr1=rmm*rlu(0)
      rr2=fmm*rlu(0)

      fr = frror(l,rr1)

        if (rr2.lt.fr) then
      r=rr1
        else
      goto 100
        endif

c --- then sample cos(sita) & fai
        do 140 num=1,10
      cthita=1.-2.*rlu(0)
      sthita=frsqr(max(0.d0,1.-cthita**2), 'sitfai')
      fai=6.2832*rlu(0)
      cor(j,1)=r*sthita*cos(fai)
      cor(j,2)=r*sthita*sin(fai)
      cor(j,3)=r*cthita
        if (j.eq.1) goto 150
c --- check if there are two nucleons too close each other
        do 130 j1=1,j-1
      dicx=cor(j,1)-cor(j1,1)
      dicy=cor(j,2)-cor(j1,2)
      dicz=cor(j,3)-cor(j1,3)
      dic2=dicx*dicx+dicy*dicy+dicz*dicz
c --- if two nucleons too close each other, sample thita & fai once more
      if (dic2.lt.rmin2) goto 140
130   continue
      goto 150
140   continue
c --- if 10 times of repeated saplings don't help, then sample r again
      goto 100
150   continue

c --- recenter the sampled nucleons within a nucleus
      sum(1)=0.
      sum(2)=0.
      sum(3)=0.
        do 170 j=1,na
      sum(1)=sum(1)+cor(j,1)
      sum(2)=sum(2)+cor(j,2)
      sum(3)=sum(3)+cor(j,3)
170     continue
        do 180 j=1,na
      cor(j,1)=cor(j,1)-sum(1)/na
      cor(j,2)=cor(j,2)-sum(2)/na
      cor(j,3)=cor(j,3)-sum(3)/na
180     continue

c --- order the nucleons on increasing z-coordinates
      do 220 j1=2,na
        zco=cor(j1,3)
        do 210 j2=1,j1-1
        if (zco.lt.cor(j2,3)) then
          xco=cor(j1,1)
          yco=cor(j1,2)
          do 200 j3=1,j1-j2
            cor(j1+1-j3,1)=cor(j1-j3,1)
            cor(j1+1-j3,2)=cor(j1-j3,2)
            cor(j1+1-j3,3)=cor(j1-j3,3)
200       continue
          cor(j2,1)=xco
          cor(j2,2)=yco
          cor(j2,3)=zco
          goto 220
          endif
210     continue
220   continue

      return
      end

c********************************* end frnucor ***************************

c********************************* frnucod *******************************

      subroutine frnucod(na,rmin2,a0,a2,a4,rmax3,cor)
      implicit double precision (a-h,o-z)
      save

c --- this subroutine determines nucleon coordinates inside a deformed
c     nucleus and recenter the sampled nucleons
c     with respect to the rest frame of the nucleus center

      parameter (ksz2=300)
      dimension cor(ksz2,3),r0(38),fm(38),rm(38),sum(3)
      data r0/5.8,5.9,6.0,6.1,6.2,6.3,6.4,6.5,6.6,6.7,6.8,6.9,7.0,7.1,
     $    7.2,7.3,7.4,7.5,7.6,7.7,7.8,7.9,8.0,8.1,8.2,8.3,8.4,8.5,8.6,
     $    8.7,8.8,8.9,9.0,9.1,9.2,9.3,9.4,9.5/
      data fm/  20.32,21.13,21.96,22.80,23.66,24.52,25.43,26.35,27.28,
     $    28.23,29.19,30.18,31.18,32.20,33.24,34.30,35.37,36.47,37.58,
     $    38.71,39.86,41.02,42.21,43.41,44.63,45.87,47.13,48.41,49.70,
     $    51.02,52.35,53.70,55.07,56.46,57.86,59.29,60.73,62.19/
      data rm/  16.49,16.59,16.70,16.81,16.91,17.02,17.13,17.23,17.34,
     $    17.45,17.56,17.66,17.77,17.87,17.98,18.09,18.19,18.30,18.41,
     $    18.51,18.62,18.73,18.83,18.94,19.04,19.15,19.26,19.36,19.47,
     $    19.57,19.68,19.79,19.89,20.00,20.10,20.21,20.32,20.42/

      do 150 j=1,na
c --- sample a nucleon from the target
c --- first sample sita from r(sita)**3. w1:cos(sita)
50    w1=-1.+2.*rlu(0)
      w2=rmax3*rlu(0)
      w12=w1*w1
      w14=w12*w12
      rsita=a0+a2*w12+a4*w14
      rsita3=rsita*rsita*rsita
      if (rsita3.lt.w2) goto 50
      cthita=w1
      sthita=frsqr(max(0.d0,1.-w12), 'sthw12')
      fai=6.2832*rlu(0)

c --- then sample r

      rt0=rsita
      fmm=frint(fm,r0,38,rt0)
      rmm=frint(rm,r0,38,rt0)

        do 140 num=1,10
100   rr1=rmm*rlu(0)
      rr2=fmm*rlu(0)
      rr1s=rr1*rr1
      fr=rr1s/(1.+frrex((rr1-rt0)/.55))
        if (rr2.lt.fr) then
      r=rr1
        else
      goto 100
        endif

      cor(j,1)=r*sthita*cos(fai)
      cor(j,2)=r*sthita*sin(fai)
      cor(j,3)=r*cthita
        if (j.eq.1) goto 150
c --- check if there are two nucleons too close each other
      do 130 j1=1,j-1
      dicx=cor(j,1)-cor(j1,1)
      dicy=cor(j,2)-cor(j1,2)
      dicz=cor(j,3)-cor(j1,3)
      dic2=dicx*dicx+dicy*dicy+dicz*dicz
c --- if two nucleons too close each other, sample r once more
      if (dic2.lt.rmin2) goto 140
130   continue
      goto 150
140   continue
c --- if 10 times repeated don't help, then sample thita and fai again
      goto 50
150   continue

c --- recenter the sampled nucleons within a nucleus
      sum(1)=0.
      sum(2)=0.
      sum(3)=0.
        do 160 j=1,na
      sum(1)=sum(1)+cor(j,1)
      sum(2)=sum(2)+cor(j,2)
      sum(3)=sum(3)+cor(j,3)
160     continue
        do 170 j=1,na
      cor(j,1)=cor(j,1)-sum(1)/na
      cor(j,2)=cor(j,2)-sum(2)/na
      cor(j,3)=cor(j,3)-sum(3)/na
170     continue

c --- order the nucleons on increasing z-coordinates
      do 220 j1=2,na
        zco=cor(j1,3)
        do 210 j2=1,j1-1
          if (zco.lt.cor(j2,3)) then
          xco=cor(j1,1)
          yco=cor(j1,2)
          do 200 j3=1,j1-j2
            cor(j1+1-j3,1)=cor(j1-j3,1)
            cor(j1+1-j3,2)=cor(j1-j3,2)
            cor(j1+1-j3,3)=cor(j1-j3,3)
200       continue
          cor(j2,1)=xco
          cor(j2,2)=yco
          cor(j2,3)=zco
          goto 220
          endif
210     continue
220   continue


      return
      end

c********************************* end frnucod ***************************

c********************************* frnucdf ******************************

      subroutine frnucdf(na,a0,a2,a4,rmax3)
      implicit double precision (a-h,o-z)
      save

c --- this subroutine determines parameters of nucleon density
c       distribution of deformed nuclei

      parameter (ksz1=20)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      save /frpara1/

      beta2s=vfr(4)*vfr(4)
      beta4s=vfr(5)*vfr(5)
      r0=1.16*na**.3333333-1.35*na**(-.3333333)
      a0=r0*(1.-.0795774*(beta2s+beta4s)-.446031*vfr(4)+.44881*vfr(5))
      a2=r0*(1.338093*vfr(4)-4.4881*vfr(5))
      a4=r0*(5.236117*vfr(5))
      rmax3=(a0+a2+a4)**3
      return
      end

c********************************* end frnucdf **************************


c********************************* frsearc *******************************

       subroutine frsearc(l,fmax,xmin)
      implicit double precision (a-h,o-z)
      save

c...this is a routine for finding maximum and 'sufficient minimum'
c...of wood-saxon or harmonic oscillator.  xm, fm are outputs.
c...input l=1 for proj, l=2 for target.

       dimension xx(4)
       xx(1)=101.
       do 10 j=1,3
        fmax=0.
        do 20 i=1,200
         x=(.01**(j-1))*(i-1)+xx(j)-100*(.01**(j-1))
       f = frror(l,x)
        if(f.gt.fmax) then
         fmax=f
         xx(j+1)=x
        endif
  20   continue
  10   continue

        x1=xx(4)
        fmin=fmax
       do 30 i=int(x1),50
        x=dble(i)
       f = frror(l,x)
           if(f.lt.fmin) then
      fmin=f
      xy=x
         endif
        if(fmin.lt.1.e-3*fmax) goto 35
  30    continue

  35    do 40 i=1,200
         x=.01*dble(i-1)+xy-1.
       f = frror(l,x)
            if(f.lt.fmin) then
       fmin=f
         xmin=x
            endif
  40    continue

        return
       end

c********************************* end frsearc ***************************

       real*8 function frror(l,r)
       implicit double precision (a-h, o-z)
       save

c......gives value of nuclear density.  l=1,2 for projectile and target
c......the dinsity frror is given by
c...... for a<,=16, harmonic oscilator potential shell model density;
c...... for a> 16, (wood-saxon) fermi distribution.       

      parameter (ksz1=20)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      character*4 pacd
      common/frcodes/ipt(2),pacd(27),nnuc(27),nprot(27),kcd(27)
     >           ,ro1(27,2),exma(9,2)
      save /frpara1/,/frcodes/

      a = nnuc(ipt(l))

      if(a.le.16) then      
      rch = ro1(ipt(l),1)
      d2 = (2.5-4./a)**(-1) * (rch**2 - 0.81**2)
c.......(proton radius 0.81 was subtracted off from the charge radius.)
      frror = (1.+((a-4.)/6.)* r**2/d2) * frrex(-r**2/d2)
       
      else       
c                               (wood-saxon) distribution

       r0 = ro1(ipt(l),1)
       c =  ro1(ipt(l),2)
        ap=a**(1./3.)
        if(r0.le.0.) r0=1.16*(1.-1.16/ap**2)
        if(c.le.0.) c =0.5
       arg = (r - r0*ap)/c
       frror=( 1.+frrex(arg) )**(-1)

       endif

       frror = r**2 * frror

       return
       end


c********************************* frovlap ******************************


      subroutine frovlap
      implicit double precision (a-h,o-z)
      save

c...this subroutine determines the parameters of overlaping functions
c...for given cross sections sigtot and sigel.  output is
c   aop(3-4): omega0,beta ---- eikonal ovlap=1 - exp(-2omega0*exp(-beta*b2))
c   aop(5-6): gaua,gaub ---- gaussian ovlap = 1-(1-gaexp(-gb*b2))**2
c   aop(7-8) rec0,alfa ---- gray disk = alfa  if b<rec0.
c   fitting such that sigtot = 2 integral d^b (1-sqrt(1-ovlap)); 
c                       siginel =  integral d^b (ovlap); 
c...units: aop(4),aop(6) are in fm^-2; aop(7) is in fermi.


      parameter (ksz1=20,pi=3.1415926)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      dimension omeg(2)
      save /frpara1/,/frintn0/

      sgtot = vfr(10)
      sgel = vfr(11)
      sgtot = sgtot/0.389
      sgel = sgel/0.389
      sginel = sgtot - sgel

      ratio = (sginel)/sgtot

c............eikonal parameters....................................

      omeg(1) = 0.
      omeg(2) = 2.
5      fomeg = ratio - 0.5*frsum(-2.*omeg(2))/frsum(-omeg(2))
      if(abs(fomeg).lt.0.001) then
      omegty = omeg(2)
      goto 100
      elseif(fomeg.lt.0.) then
      omeg(2) = omeg(2) + 0.5
      goto 5
      endif

      i = 0
10    i = i+1

      omegty = (omeg(1)+omeg(2))/2.
      fomeg = ratio - 0.5*frsum(-2.*omegty)/frsum(-omegty)
      if(abs(fomeg).lt.0.001) goto 100
      if(fomeg.lt.0.)  omeg(1) = omegty
      if(fomeg.gt.0.)  omeg(2) = omegty

      goto 10

100   beta = (-2.*pi/sgtot)* frsum(-omegty)
      aop(4) = beta/(0.197)**2

      aop(3) = omegty

c............gaussian parameters....................................

      aop(5) = 4.*sgel/sgtot
      aop(6) = 2.*pi*aop(5)/sgtot/(0.197)**2

c.............gray disk parameters................................

      aop(8) = 4.* (sginel)*sgel/sgtot**2
      rec02 = sginel/(pi*aop(8))
      aop(7) = sqrt(rec02) *0.197

      return

      end

c................................................

      real*8 function frsum(x)
      implicit double precision (a-h,o-z)
      save

c...summation frsum=sum (x^n/n*n!), used for integrating eikonal overlap func.

      frsum = 0.
      if(x.eq.0.) return
      
      i = 0
      term = 1.
10    i = i+1
      term = term * (x) * max(1,i-1)/dble(i**2)
      frsum = frsum + term
      if(abs(term).lt.min(1.d-6,1.e-6*abs(x))) goto 100

      call frloopu(*10,i,2000,'lopfrsum')

100   continue

      return
      end

c********************************* end frovlap **************************

c************************  function frvov ********************************

      real*8 function frvov(r2)
      implicit double precision (a-h,o-z)
      save

c...... gives the value of overlap function at b^2=r2.
c...... kfr(5)=iq=0, eikonal, iq=1,gaussian, iq=2, grey disk.

      parameter (ksz1=20)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      save /frpara1/,/frintn0/

      if(kfr(5).eq.0) then
      omega0 = aop(3)
      beta = aop(4)
      frvov = 1.-frrex( -2.*omega0*frrex(-beta*r2))
            else if (kfr(5).eq.1) then
      gaua = aop(5)
      gaub = aop(6)
            frvov =1.-(1.-gaua*frrex(-gaub*r2))**2
            else if (kfr(5).eq.2) then
      rec02 = aop(7)**2
      alfa = aop(8)
         if (r2.lt.rec02) then
         frvov=alfa
         else
         frvov=0.
         endif
      endif

      return
      end

c************************ end function frvov ********************************

c*************************************************************************

      real*8  function frint(ff,fx,nn,x)
      implicit double precision (a-h,o-z)
      save

cc........this function deals with the linear interpolation

      dimension ff(nn),fx(nn)

      if (x.lt.fx(1).or.x.gt.fx(nn)) then
         call frmgout(0,0, 
     >   'x out of range! be advised to set kfr(6)=0.',
     >    x,fx(1),fx(2),0.d0,0.d0)
      endif
        do 100 i=1,nn-1
      if (x.gt.fx(i).and.x.le.fx(i+1)) then
      frint=ff(i)+(ff(i+1)-ff(i))*(x-fx(i))/(fx(i+1)-fx(i))
      goto 200
      endif
100     continue

200   return
      end

c*************************************************************************

c******************* end of package for nuclear geometry *****************




c*************************************************************************
c                                                                        *
c this is the routine package for generating nucleon-nucleon collisions  *
c                                                                        *
c*************************************************************************

c********************************* frringo *******************************

      subroutine frringo
      implicit double precision (a-h,o-z)
      save

c ....................    the routine gives masses to the excited nucleons

c      implicit double precision (d)
      parameter (ksz1=20,ksz2=300)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      common/frintn1/pps(2,ksz2,5),pph(2,ksz2,5),ppsy(2,ksz2,5),ppa(2,5)
      common/frintn2/nhp(2),ihqp(2,ksz2),khp(2,ksz2,250,5),
     >   php(2,ksz2,250,5)   ! by kk 50-->250 : at 10^22 eV, not enough.
      common/frcnut/nr,kr(10,5),pr(10,5),nr0
      include "Zfrjets.h"
      common/pyparsC/mstp(200),parp(200),msti(200),pari(200)
       include "Zlujets.h"
      common/pysubsC/msel,msub(200),kfin(2,-40:40),ckin(200)

      dimension dptsq(2),dp(2,5),dn(2,5),dsm(2,5),dsym(2,5),dbeta(3),
     > pjk(2,4),ppsyu(2,5),fmn0(2),rm(2,2)
      save pxgau,pygau,rm
      save /frintn0/,/frpara1/,/frintn3/,/frintn1/,/frintn2/,/frcnut/,
     >     /frjets/,/pyparsC/,/lujets/,/pysubsC/
      data rm /0.,0.,0.,0./

      call frdoict(-1)

c..monitors ict(10) (for current event) and ictt (for all events) are set up:
c...   ict(kfel) counts the number of times error kfel occurs.
c...   ict(7) is the number of ``single diff'' collisions.
c...   ict(8) the number of collisions bypassed due to repeated errors.
c...  kfel=2,3,8,10 result in the collision being skipped.  
c...  kfel used: 1-10

c...........................................set initial momenta

10    kfel=0
      do 20 l=1,2
      do 20 i=1,iop(3+2*(l-1))
        do 21 lo=1,4
   21   pps(l,i,lo)= pli0(l,lo)
        pps(l,i,5)= frsqr(pps(l,i,4)*pps(l,i,3)-pps(l,i,1)**2
     >                    -pps(l,i,2)**2, 'reyu90')
        ihqp(l,i) = 0
        khp(l,i,1,5)=0
        php(l,i,1,5)=-1.
        php(l,i,2,5)=-1.
        do 20 lo=1,5
        pph(l,i,lo) = 0.
   20   ppsy(l,i,lo) = pps(l,i,lo)

c....spectator momenta and fermi-motion  ............

      call frhelge

c.....loop over all binary collisions

      iop(13) = 0
      iop(14) = 0
      iop(15) =0            
      nhp(1) = 0
      nhp(2) = 0
      nr = 0
      if(iop(2).gt.3000) call frmgout(0,0,
     >  '** nuc(2,3000) must be increased **',0.,0.,0.,0.,0.)

      do 1000 i=1,iop(2)

      iop(1) = i
      nu1 = nuc(1,i)
      nu2 = nuc(2,i)
      kfels=0      

c.....frvectc sets four-vectors dp(2,4) to pps .....
      call frvectc(i, 1, dp)
      call frvectc(i, 1, dsm)
      call frvectc(i, 2, dsym)

c...............................total e-p before the collision 

      do 30 lo = 1, 4
30    ppsyu(1,lo) = ppsy(1,nu1,lo)+ppsy(2,nu2,lo)

c.....boost to remnent-remnent cms ......................

      call frtocms(1, 1, dp, dbeta)

c....skip the collision when strings moving backwards in cms:
      if(dp(1,4)-dp(1,3).le.0.d0) then
c     kfel=10
      call frdoict(10)
      goto 1000
      endif

c.... angles of the momentum vectors ................................

      call frpolar(dthe,dphi, dp)

c ...  rotate so p goes to the z-axe ...................

      call frrotar(dthe,dphi,1, dp)
c....
      nr0 = nr+1

      smp= real( dp(1,3)*dp(1,4)-dp(1,1)**2-dp(1,2)**2)
      smt= real( dp(2,3)*dp(2,4)-dp(2,1)**2-dp(2,2)**2)

      w=real( dp(1,4)+dp(2,4) )
      pk2= frkvm(w,smp,smt)            
 
50    if(iop(15).eq.0) then
      do 60 ll=1,2
      do 60 lo=1,4
60    pjk(ll,lo) = 0.
      endif

c............................................generate hard partons.......

      ihav = 0
      nj = 0
      if(iop(18).ge.1.and.iop(15).eq.0) then

      fmn0(1) = ulmass(idn(1,nu1))
      fmn0(2) = ulmass(idn(2,nu2))
c...................................effective energy for hard scattering 
      p13 = fmn0(1)**2/real(dp(1,4)) 
      p24 = fmn0(2)**2/real(dp(2,3)) 
      e1 = 0.5*( real(dp(1,4))+p13 )
      p1 = 0.5*( real(dp(1,4))-p13 )
      e2 = 0.5*( real(dp(2,3))+p24 )
      p2 = 0.5*(-real(dp(2,3))+p24 )

      ckin(22)=min(1.d0,real(dp(1,3))/p13)
      ckin(24)=min(1.d0,real(dp(2,4))/p24)
      
      wef =frsqr(fmn0(1)**2+fmn0(2)**2+2.*(e1*e2-p1*p2),' wefis1')
      if(wef.lt.parp(2)) goto 495

      n=0
      
      p(1,1) = 0.
      p(1,2) = 0.
      p(2,1) = 0.
      p(2,2) = 0.
      p(1,3) = p1
      p(2,3) = p2
      p(1,4) = e1
      p(2,4) = e2

c.....pythia is reinitialized whenver the collision enviroment is changed. 
c.....if momenta unchanged, no need to reinitialize pythia, save time.....
      ini = 2
      do 216 lo=1,2
      do 216 j=3,4
216   if( abs(p(lo,j)-rm(lo,j-2)).gt.0.01*rm(lo,j-2) ) ini=1

      if(ini.eq.1) then
      do 218 lo=1,2
      do 218 j=1,2
218   rm(lo,j) = p(lo,j+2)
c.....reset parameters before every new collision:
      call frsetpy(1)
      endif

c.....pythia is reinitialized here only when the collision energy changes, but
c.....not when the particle changes (neutron instead of a proton, for exemple).

      nfr(2) = nfr(2)+1
      call frhardp(idn(1,nu1),idn(2,nu2),wef,ihav,ini)
      if(ihav.eq.0)     goto 495

      do 220 j=1, nj
      pjk(abs(kj(j,3)),1) = pjk(abs(kj(j,3)),1)+ pj(j,1)
      pjk(abs(kj(j,3)),2) = pjk(abs(kj(j,3)),2)+ pj(j,2)
      pjk(abs(kj(j,3)),3) = pjk(abs(kj(j,3)),3)+ pj(j,4) - pj(j,3)
220   pjk(abs(kj(j,3)),4) = pjk(abs(kj(j,3)),4)+ pj(j,4) + pj(j,3)

      endif
c........................................................................


c..........generate soft pt in remnent-remnent cms frame ......

495   icpk=0
      irep = 0

      aht=0.
      if(iop(15).ge.2.and.kfr(9).eq.1) aht=1.0

600   pxgau = 0.
      pygau = 0.

      if(icpk.le.100) then
      px0 = aht*pjk(1,1)
      py0 = aht*pjk(1,2)
      call frcolpt(pk2,pxgau,pygau,px0,py0)
      icpk = icpk+1
        if(iop(15).eq.0.and.nj.gt.0) then
        pttry = (pxgau+pjk(1,1))**2+ (pygau+pjk(1,2))**2
        if(pttry.gt.pk2) goto 600
        endif
      endif

500   dn(1,1) = pxgau
      dn(1,2) = pygau
      dn(2,1) = -pxgau
      dn(2,2) = -pygau

      dptsq(1) = dn(1,1)**2 + dn(1,2)**2
      dptsq(2) = dn(2,1)**2 + dn(2,2)**2

c.............................................................

      if(kfel.gt.0) then
      kfels=kfels+1
      call frdoict(kfel)
      endif

c  bypass the collision if too many errors:
      if (kfels.gt.20) then
      if(i.eq.1) goto 10      
      kfel=8
      goto 999      
      endif

c............... soft momentum transfers ...........................

610   call frpsoft(i,pjk,dp,dn,kfel)
      if(kfel.gt.0) goto 999 

c.....excited masses for soft remnents
      dwi =dn(1,4)*dn(1,3)
      dwt =dn(2,4)*dn(2,3)
      if(dwi.lt.dptsq(1).or.dwt.lt.dptsq(2)) then
      kfel=1
      goto 500
      endif

      dn(1,5)=dfrsqr(dwi-dptsq(1), 'dwi123')
      dn(2,5)=dfrsqr(dwt-dptsq(2), 'dnw935')


c.....transform dn & pj() & pr() back to original frame
      
      if(ihav.eq.1.and.irep.eq.0) then
      iql = -2
      else
      iql = -1
      endif

       call frrotar(dthe,dphi,iql, dn)
       call frtocms(1, iql, dn, dbeta)
       irep = 1

c......... update the pps(1-2,i,4) array:
      call frvectc(i, -1, dn)

      pps(1,nu1,5) =real(dn(1,5))
      pps(2,nu2,5) =real(dn(2,5))

c..................................update ppsy ..........
      call frfilhd(i,0,kfel)
      if(kfel.gt.0) goto 500            
      
c.....treatment of diffractive collision

      call frsetdm(i,kfel)
c     ...single diffractive
      if(kfel.eq.-1) call frdoict(7)   
      if(kfel.ge.5)  goto 500      

c....................store the hard partons to frintn2 ..........

      if(iop(15).eq.0) call frfilhd(i,1,kfel)

c...to test the rutherford scattering against the background:

       n=0
       if(nj.gt.0.and.iop(15).eq.0) 
     >       call frchexg(*50,i)

       if(iop(15).le.1.and.nj.gt.0) then
         iop(13) = iop(13) + 1
         iop(14) = iop(14) + (nj+1)/2
       endif  

 990   kfel=0
       iop(15)=0
       nj=0

c.........check e-p conservation .....................
      do 910 lo = 1,4
910   ppsyu(2,lo) = ppsy(1,nu1,lo)+ppsy(2,nu2,lo)

      do 920 lo = 4, 1, -1
      perr = abs(ppsyu(2,lo)-ppsyu(1,lo))
      if(perr.ge.max(0.1d0+0.5*(lo/3),0.05*ppsyu(1,lo)) ) then
      call frmgout(1,1,'frringo e-p not conserved:',
     >  ppsyu(2,1)-ppsyu(1,1),ppsyu(2,2)-ppsyu(1,2),    
     >  ppsyu(2,3)-ppsyu(1,3),ppsyu(2,4)-ppsyu(1,4),ppsyu(1,4))      
      goto 1000
      endif
920   continue

      goto 1000
999   call frvectc(i, -1, dsm)
      call frvectc(i, -2, dsym)
      call frdoict(kfel)
1000  continue

      return
      end


c-------------------------------------------------------------------

      real*8 function frkvm(w,am1,am2)
      implicit double precision (a-h,o-z)
      save

c..frkvm=3-momentum k^2 in a cms frame of two particles with mass am1 & am2:

      frkvm = ((w**2-am1-am2)**2-4.*am1*am2)/(4.*w**2)
      return
      end


c********************************* end frringo ***************************


c********************************* frpsoft *******************************

      subroutine frpsoft(i,pjk,dp,dn,kfel)
      implicit double precision (a-h,o-z)
      save

c.....to generate momenta for the soft remnents
c.....  iq=0: generated according to dq/q
c.....    =1: dq/q+k
c.....  kfel>0: no phase space for the collision 

      parameter (ksz1=20,ksz2=300)
c      implicit double precision (d)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frintn1/pps(2,ksz2,5),pph(2,ksz2,5),ppsy(2,ksz2,5),ppa(2,5)
      include "Zfrjets.h"
      dimension dp(2,5),dn(2,5),pjk(2,4)
      save /frpara1/,/frintn3/,/frintn0/,/frintn1/,/frjets/

      kfel=0
      ik9=0
      iq = 1
      if(iop(15).ge.2) iq =0
      nu1 = nuc(1,i)
      nu2 = nuc(2,i)
            
      dwp = dp(1,4)+dp(2,4)+pph(1,nu1,4)+pph(2,nu2,4)
      dwm = dp(1,3)+dp(2,3)+pph(1,nu1,3)+pph(2,nu2,3)
      da =(dn(1,1)+pph(1,nu1,1)+dble(iq*pjk(1,1)))**2+
     >    (dn(1,2)+pph(1,nu1,2)+dble(iq*pjk(1,2)))**2
      db =(dn(2,1)+pph(2,nu2,1)+dble(iq*pjk(2,1)))**2+
     >    (dn(2,2)+pph(2,nu2,2)+dble(iq*pjk(2,2)))**2
      da = da + aop(9)**2
      db = db + aop(10)**2

10    call frplimt(dwp,dwm,da,db,dplo3,dphi3,dplo4,dphi4,kfel)
      if(kfel.gt.0) return

      dplo3 = dmax1(dplo3, dp(1,3)+pph(1,nu1,3))
      dplo4 = dmax1(dplo4, dp(2,4)+pph(2,nu2,4))
      dphi3 = dmin1(dphi3, dp(1,4)+pph(1,nu1,4))
      dphi4 = dmin1(dphi4, dp(2,3)+pph(2,nu2,3))
      if(iq.eq.1) then
      dplo3 = dmax1(dplo3, (pjk(1,3)+pph(1,nu1,3)) )
      dplo4 = dmax1(dplo4, (pjk(2,4)+pph(2,nu2,4)) )
      endif
     
      p0 = 0.

      if(rlu(0).lt.0.500) then

            if(dphi3.lt.dplo3) goto 99
      p0 = -pph(1,nu1,3)
      dn(1,3) = dfrdpq(dplo3,dphi3,p0)       

      dplo4 = dmax1(dplo4,db/(dwm-dn(1,3))) 
      dphi4 = dmin1(dphi4, dwp - da/dn(1,3) ) 
            if(dphi4.lt.dplo4) goto 99
      p0 = -pph(2,nu2,4)
      dn(2,4) = dfrdpq(dplo4,dphi4,p0)

      else             

            if(dphi4.lt.dplo4) goto 99
      p0 = -pph(2,nu2,4)
      dn(2,4) = dfrdpq(dplo4,dphi4,p0)

      dplo3 = dmax1(dplo3,da/(dwp-dn(2,4))) 
      dphi3 = dmin1(dphi3, dwm - db/dn(2,4) ) 
           if(dphi3.lt.dplo3) goto 99
      p0 = -pph(1,nu1,3)
      dn(1,3) = dfrdpq(dplo3,dphi3,p0)       

      endif

      dn(1,4) = dwp - dn(2,4)
      dn(2,3) = dwm - dn(1,3)

      do 70 l=1,2
      do 70 lo=3,4
      dn(l,lo) = dn(l,lo) - (pph(l,nuc(l,i),lo))
      if(iq.eq.1) dn(l,lo) = dn(l,lo) - (pjk(l,lo))
        if(dn(l,lo).le.0.d0) then
      ik9=ik9+1
      if(ik9.lt.10) goto 10
      kfel=9
        endif
70    continue

      goto 100 
99    kfel=2
100   return
      end

c********************************* end frpsoft ***************************

c********************************* function frdpq *************************

      double precision function dfrdpq(dpmin,dpmax,p0)
      implicit double precision (a-h, o-z)
      save
c......generate pq (p- or p+ ) according to dpq/pq+p0,
c......with pmin< pq <pmax.

c      implicit double precision (d)
      parameter (ksz1=20)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      save /frpara1/

      dp0 = p0
      if(dpmin+dp0.le.0.) then
      dfrdpq = 0.
      return
      endif

        if(dpmax.le.dpmin) then
      dfrdpq = dpmin
      else
      dr = rlu(0)
      dfrdpq = (dpmin+dp0) *((dpmax+dp0)/(dpmin+dp0))**dr -dp0
      endif

      return
      end


c****************************** end function frdpq ***********************


c********************************* frplimt ******************************

c....to give the upper and lower limits for final momenta 
c....  dp(2,4)  -  initial momenta
c...   da=minimum of m_3t**2; db=minimum of m_4t**2.

      subroutine frplimt(dwp,dwm,da,db,dplo3,dphi3,dplo4,dphi4,kfel)
      implicit double precision (a-h,o-z)
      save

c      implicit double precision (d)

      kfel=0
      ds = dwp*dwm
      dtm1 = (ds + da - db)
      dtm2 = (dtm1**2-4.d0*da*ds)
            if(dtm2.lt.0) then
      kfel=3
      return
            endif
      dtm2 = dsqrt( dtm2 )
      dplo3 = (dtm1 - dtm2)/(2.d0*dwp)
      dphi3 = (dtm1 + dtm2)/(2.d0*dwp)
      dplo4 = (db-da+ dwp*dplo3)/dwm
      dphi4 = (db-da+ dwp*dphi3)/dwm

      return
      end

c********************************* end frplimt **************************

c********************************* frchexg ***************************

      subroutine frchexg(*,i)
      implicit double precision (a-h,o-z)
      save

c.....to administrate the preliminary checking and testing of rps 
c.....this routine will manages the final gluon emission if there is only
c.....one collision, else the gluon emission will be managed in fringeb. 
c...  iop(15)>=2 signals hard partons are drawned.

c      implicit double precision (d)
      parameter (ksz1=20,ksz2=300)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      include "Zfrjets.h"
       include "Zlujets.h"
      save /frintn0/,/frpara1/,/frintn3/,/frjets/,/lujets/

       if(iop(15).eq.0.and.nj.gt.0) iop(15)=1

       call frtorst(1,nuc(1,i))
       if(iop(15).ne.2) call frtorst(2,nuc(2,i))

       if(iop(15).ge.2) then   

       call frfilhd(i,-1,kfel)            
      
       return 1

       endif

       return
       end

c************************ end frchexg ***********************************


c********************************* frfilhd ******************************

      subroutine frfilhd(i,iq,kfel)
      implicit double precision (a-h,o-z)
      save

c....to incorporate the hard parton momenta into the nucleon system and
c....to eveluate the system mass ppsy(,,5).
c......iq = 0, ppsy is updated but hard partons not stored (pph not updated);
c......iq = 1, no effect to ppsy but pph, php are updated
c......iq <0: hard partons stripped off from the record.
c......output flag for iq=0: (kfel is dummy for abs(iq)=1)
c......kfel=0, no problem;
c......    =4, system mass smaller than minimum, frfilhd aborts;

      parameter (ksz1=20,ksz2=300)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      include "Zfrjets.h"
      common/frintn2/nhp(2),ihqp(2,ksz2),khp(2,ksz2,250,5),
     >   php(2,ksz2,250,5)
      common/frintn1/pps(2,ksz2,5),pph(2,ksz2,5),ppsy(2,ksz2,5),ppa(2,5)

      dimension pphn(2,4),ihqpm(2)
      save pphn
      save /frpara1/,/frintn0/,/frintn3/,/frjets/,/frintn2/,/frintn1/

      kfel=0

      if(iq.eq.0) then

      do 11 l=1,2
      do 11 j=1,4
11    pphn(l,j) = 0.

      if(nj.ge.1) then
      do 21 lo=1, nj
      l = abs(kj(lo,3))
      pphn(l,1) = pphn(l,1)+ pj(lo,1)
      pphn(l,2) = pphn(l,2)+ pj(lo,2)
      pphn(l,3) = pphn(l,3)+ pj(lo,4)-pj(lo,3)
21    pphn(l,4) = pphn(l,4)+ pj(lo,4)+pj(lo,3)
      endif

      do 30 l=1, 2
      do 30 lo=1, 4
30    ppsy(l,nuc(l,i),lo) = pps(l,nuc(l,i),lo)+ 
     >               pph(l,nuc(l,i),lo)+ pphn(l,lo)
      
      do 570 l=1,2
      smsy2 = ppsy(l,nuc(l,i),4)*ppsy(l,nuc(l,i),3)-
     >    ppsy(l,nuc(l,i),1)**2-ppsy(l,nuc(l,i),2)**2
      if(smsy2.lt.aop(8+l)**2) then
      kfel=4
      return
      endif
570   ppsy(l,nuc(l,i),5) = sqrt(smsy2 )
      
      elseif(iq.eq.1.and.nj.gt.0) then
c.....................................store the hard partons to frintn2

       ihqpm(1) = ihqp(1,nuc(1,i))
       ihqpm(2) = ihqp(2,nuc(2,i))
          
       do 512 lo = 1, nj
       iside = abs(kj(lo,3))
       inuc = nuc(iside,i)
       ihqp(iside,inuc) = ihqp(iside,inuc) +1
       nhp(iside) = nhp(iside) + 1
       do 510 l=1,4
       php(iside,inuc,ihqp(iside,inuc),l)= pj(lo,l)
510    khp(iside,inuc,ihqp(iside,inuc),l)= kj(lo,l)
       if(kfr(9).ne.0) khp(iside,inuc,ihqp(iside,inuc),4)=ihqpm(iside)
512    continue

       do 90 l = 1, 2
       do 90 l2 = 1,4
 90    pph(l,nuc(l,i),l2) = pph(l,nuc(l,i),l2)+ pphn(l,l2)

       elseif(iq.le.-1.and.nj.gt.0) then
c....................................strip off the hard partons
 
        do 520 lo = 1, nj
        iside = abs(kj(lo,3))
        inuc = nuc(iside,i)
         do 517 l=1,4
         php(iside,inuc,ihqp(iside,inuc),l)= 0.0
517      khp(iside,inuc,ihqp(iside,inuc),l)= 0.0
        nhp(iside) = nhp(iside) - 1
520     ihqp(iside,inuc) = ihqp(iside,inuc) -1

        do 95 l = 1, 2
        do 95 l2 = 1,4
 95     pph(l,nuc(l,i),l2) = pph(l,nuc(l,i),l2)- pphn(l,l2)

      nj = 0

      endif

      return
      end

c********************************* end frfilhd **************************

c********************************* frsetdm ******************************

      subroutine frsetdm(i,kfel)
      implicit double precision (a-h,o-z)
      save

c...to reset the mass if found diffractive, m<aop(10+l).
c...i is the index for the collision
c...kfel = 0: not a "diffractive" event, no reset necessary
c....... = 5: fail to properly reset, regenerate the event may be needed.
c....... = 6: double diffractive
c....... = -1: reset successfully

c      implicit double precision (d)
      parameter (ksz1=20,ksz2=300)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      common/frintn1/pps(2,ksz2,5),pph(2,ksz2,5),ppsy(2,ksz2,5),ppa(2,5)
      dimension ptsq(2),ptsqs(2),pnew(2)
      save /frintn0/,/frintn3/,/frintn1/

      if(ppsy(1,nuc(1,i),5).lt.aop(11).and.
     >                 ppsy(2,nuc(2,i),5).lt.aop(12)) then
c      "double diffractive"
      kfel=6            
      return
      elseif(ppsy(1,nuc(1,i),5).ge.aop(11).and.
     >                 ppsy(2,nuc(2,i),5).ge.aop(12)) then
      kfel=0            
      return
      elseif(ppsy(1,nuc(1,i),5).lt.aop(11)) then
      kfel=-1            
             l = 1
      elseif(ppsy(2,nuc(2,i),5).lt.aop(12)) then
      kfel=-1            
             l = 2
      endif

c-------reset the mass -------------------------------------------------
c.......keep pt fixed and choose p_large between pmin and pmax acc dp/p,
c.......which is equivalent to a uniform distributn of y.  
c.......(a bad choice here may result in an ugly peak in dn/dy_proton)

      nv = nuc(l,i)
      nvv = nuc(3-l,i)
      fm = ulmass(idn(l,nuc(l,i)))
      lg=4
      if( ppsy(l,nv,3).gt.ppsy(l,nv,4) ) lg=3

      ptsq(l) = ppsy(l,nv,1)**2+ppsy(l,nv,2)**2
      ptsqs(l) = pps(l,nv,1)**2+pps(l,nv,2)**2
      tmp20 = fm**2 + ptsq(l)
      dpmax = ppsy(l,nv,lg)
      dpmin = tmp20/ppsy(l,nv,7-lg)
c//////////////////// 0. should be 0d.0 9 Oct. 2000 by KK
c            otherwise a lot of error will appear on DEC alpha
c         pnew(lg-2) = dfrdpq(dpmin,dpmax,0.)
         pnew(lg-2) = dfrdpq(dpmin,dpmax,0.d0)
c////////////////
         pnew(5-lg) = tmp20/pnew(lg-2)
      adelp = pnew(2) - ppsy(l,nv,4)
      adelm = pnew(1) - ppsy(l,nv,3)
      ppsy(l,nv,4) = pnew(2)
      ppsy(l,nv,3) = pnew(1)
      pps(l,nv,4) = pps(l,nv,4)  + adelp
      pps(l,nv,3) = pps(l,nv,3)  + adelm
      rms34s = pps(l,nv,3)*pps(l,nv,4)
          if(rms34s.le.ptsqs(l)) goto 500
      ppsy(l,nv,5) =fm
      pps(l,nv,5) =frsqr(rms34s-ptsqs(l),'ppslnv5')

c   rebalance the energy-momentum

      ptsq(3-l) = ppsy(3-l,nvv,1)**2+ppsy(3-l,nvv,2)**2
      ptsqs(3-l) = pps(3-l,nvv,1)**2+pps(3-l,nvv,2)**2
      ppsy(3-l,nvv,4) = ppsy(3-l,nvv,4) - adelp
      ppsy(3-l,nvv,3) = ppsy(3-l,nvv,3) - adelm
      pps(3-l,nvv,4) = pps(3-l,nvv,4) - adelp
      pps(3-l,nvv,3) = pps(3-l,nvv,3) - adelm
      rmspt = aop(12-l+1)**2 + ptsq(3-l)
      rms34 = ppsy(3-l,nvv,4)*ppsy(3-l,nvv,3)
      rms34s = pps(3-l,nvv,4)*pps(3-l,nvv,3)
          if(rms34.lt.rmspt.or.rms34s.le.ptsqs(3-l)) goto 500
      ppsy(3-l,nvv,5)=frsqr(rms34-ptsq(3-l), 'dn25is')
      pps(3-l,nvv,5)=frsqr(rms34s-ptsqs(3-l), 'dn25ss')

      goto 600
500   kfel=5
600   return
      end


c********************************* end frsetdm **************************

      
c********************************* frvectc ******************************


      subroutine frvectc(i,iq,dp)
      implicit double precision (a-h,o-z)
      save

c......conversions between pps or ppsy arrays and dp(2,4):
c.........to set projectile and target four vectors to a form:
c.........dp(l,1-4)=(px,py,p_,p+) ............................
c.........iq=1, dp=pps;
c.........iq=2, dp=ppsy;
c.........for iq < 0, the reverse is done.

      parameter (ksz2=300)
      common/frintn1/pps(2,ksz2,5),pph(2,ksz2,5),ppsy(2,ksz2,5),ppa(2,5)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      double precision dp(2,5)
      save /frintn1/,/frintn3/

      if(iq.eq.1) then
      do 20 l = 1, 2
      do 20 j = 1, 4
20          dp(l,j) =dble(pps(l,nuc(l,i),j))
      elseif(iq.eq.2) then
      do 22 l = 1, 2
      do 22 j = 1, 4
22          dp(l,j) =(ppsy(l,nuc(l,i),j))
      elseif(iq.eq.-1) then
      do 60 l = 1, 2
      do 60 j = 1, 4
60          pps(l,nuc(l,i),j)=real(dp(l,j))
      elseif(iq.eq.-2) then
      do 66 l = 1, 2
      do 66 j = 1, 4
66          ppsy(l,nuc(l,i),j)=real(dp(l,j))
      endif

      return
      end

c********************************* end frvectc **************************


c********************************* frcolpt ******************************

      subroutine frcolpt(pk2m,px,py,px0,py0)
      implicit double precision (a-h,o-z)
      save

c-----------------------------------------------------------------------
c     giving the excited nucleons gaussian pt:
c      dp ~ exp(-(px-px0)**2/sig)*exp(-(py-py0)**2/sig)
c     pk2m: the upper cut off for pt^2.
c-----------------------------------------------------------------------

      parameter (ksz1=20)
c      implicit double precision (d)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      save /frpara1/

      px = 0.
      py = 0.
      pk0 = px0**2+py0**2
      p2mx = pk2m-pk0
      if(p2mx.le.1.e-5) return

      if(vfr(6).le.0.000001) then
      px = px0
      py = py0

      else

      itry = 0
10    call frgauss(p, vfr(6), p2mx)

      adelpt=frsqr(p, 'pio086')

      afi=2*3.1415926*rlu(0)
      px=px0+adelpt*cos(afi)
      py=py0+adelpt*sin(afi)
        if(px**2+py**2.gt.pk2m) then
        itry = itry+1
        call frloopu(*10,itry,100,'lpfrcolpt')
        endif

      endif

      return
      end


c********************************* end frcolpt **************************


c********************************* frhelge ******************************

      subroutine frhelge
      implicit double precision (a-h,o-z)
      save

c.... helge calculates the energy momenta for the nuclear spectator remnent
c.... and gives fermi-motion to the nucleons in the nuclei, here the input
c.... nucleons are assumed to be moving along the z-axis.
c.... by giving the rest nucleons a fermi momentum, then binding energy
c.... has to be included to ensure energy-momentum conservation. this
c.... is achieved here by puting the nucleons off shell.

      parameter (ksz1=20, ksz2=300)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn1/pps(2,ksz2,5),pph(2,ksz2,5),ppsy(2,ksz2,5),ppa(2,5)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      dimension fvect(3,ksz2)
      save /frintn0/,/frpara1/,/frintn1/,/frintn3/
      data pi /3.1415926/

      do 7 l=1,2
      nwd = iop(3+2*(l-1))-iop(8+l)
      do 9 lo=1,4
  9      ppa(l,lo) = (nwd)* pli0(l,lo)
  7      ppa(l,5)=frsqr(ppa(l,4)*ppa(l,3),'ppa')

      if(kfr(4).eq.0) return
      
c......................................................................
      do 700 l=1, 2

      if (iop(3+2*(l-1)).le.1) goto 700

   15    do 18 lo=1,5
   18    ppa(l,lo) = 0.0

       do 10 i=1,3

        sum=0.
        do 20 j=1,iop(3+2*(l-1))
          sl1=rlu(0)
          sl2=rlu(0)
          sl1=frsqr(-2.*log(max(1.d-15,sl1))*iop(3+2*(l-1))
     >                      /(iop(3+2*(l-1))-1), 'sl1kl7')
          sl2=cos(2.*pi*sl2)
          fvect(i,j)=sl1*sl2*.1
   20     sum=sum+fvect(i,j)

        do 12 j=1,iop(3+2*(l-1))
   12     fvect(i,j)=fvect(i,j)-sum/dble(iop(3+2*(l-1)))

   10 continue

      do 30 j=1,iop(3+2*(l-1))
        sum2=0.
        do 32 i=1,3
   32   sum2=sum2+fvect(i,j)**2
        if (sum2.ge..3) goto 15
   30 continue

      do 50 j=1,iop(3+2*(l-1))
        pps(l,j,1)=fvect(1,j)
        pps(l,j,2)=fvect(2,j)
        bosfac=frsqr(pps(l,j,4)/pps(l,j,3), 'bos590')
c.......in the rest frame, keeping e=m unchanged,
c.......nucleon off shell, fmn(l,j) changed from nucleon rest masses.
      ee = pps(l,j,5)
        pplus=ee+fvect(3,j)
        pminus=ee-fvect(3,j)
        em2=pplus*pminus-fvect(1,j)**2-fvect(2,j)**2

      if(em2.le.0.) goto 15

      pps(l,j,5) = sqrt(em2)
      fmn(l,j) = pps(l,j,5)
        pps(l,j,4)=pplus*bosfac
        pps(l,j,3)=pminus/bosfac
      if(j.gt.iop(8+l)) then
      do 52 lo=1,4
   52 ppa(l,lo)= ppa(l,lo)+ pps(l,j,lo)
      endif
       do 55 lo=1,4
   55  ppsy(l,j,lo) = pps(l,j,lo)
       ppsy(l,j,5) = frsqr(ppsy(l,j,4)*ppsy(l,j,3)-ppsy(l,j,1)**2
     >               -ppsy(l,j,2)**2, 'ppsyhg')
   50  continue

       ppa(l,5)=frsqr(ppa(l,4)*ppa(l,3)-ppa(l,1)**2-ppa(l,2)**2,'pa1')

 700   continue

      return
      end

c********************************* end frhelge **************************



c*************************************************************************
c      this is the routine package that sets up strings for ariadne      *
c*************************************************************************

c********************************* frtorst ******************************

      subroutine frtorst(l,j)
      implicit double precision (a-h,o-z)
      save

c------------------------------------------------------------------
c purpose: to set parton codes and momenta before entering ariadne and
c jetset, and to take care of the diffractive hadrons. fills common block
c lujets. j is the nucleon label in nuclus. l=1 for projectile and =2
c for the target.
c from here frangur are called that handles the diffractive particles,
c fratleo that sets parton momenta and calls ariadne. 
c------------------------------------------------------------------

c      implicit double precision (d)
      parameter (ksz1=20,ksz2=300)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frintn1/pps(2,ksz2,5),pph(2,ksz2,5),ppsy(2,ksz2,5),ppa(2,5)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      save /frintn0/,/frintn1/,/frpara1/

        if(iop(15).eq.0.and.ppsy(l,j,5).lt.aop(10+l)) then
          call frangur(l,j)
        else
      
        call fratleo(l,j)

        endif

      return
      end

c********************************* end frtorst **************************

c********************************* frbeleo ******************************


      subroutine frbeleo(ifla,iflb,kf)
      implicit double precision (a-h,o-z)
      save

c-----------------------------------------------------------------------
c     giving spin and quarkflavour to the ends of the excited strings.
c     for mesons, the order of the end flavors is randomly given;
c     for baryons, where a quark-diquark combination, the diquark is 
c     always assigned to iflb.
c     ifla and iflb are adapted to the standard kf codes
c-----------------------------------------------------------------------

      parameter (ksz1=20)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      save /frpara1/
      integer ifrkfc

      spin=rlu(0)
      j = abs(kf)

      if(j.lt.1000) then
c...   identify the quark and antiquark in mesons:
        j100=  j/100
	j10 = (j-j100*100)/10
	isgn = (-1)**max(j100, j10)
	if(kf.lt.0) isgn = -isgn 
	if(isgn.gt.0) j10 = -j10
	if(isgn.lt.0) j100 = -j100

        if(spin.lt..5) then
          ifla=j100
          iflb=j10
        else
          ifla=j10
          iflb=j100
        endif

      elseif(j.lt.10000) then
        j1000=  j/1000
	j100 = (j-j1000*1000)/100
	j10 = (j-j1000*1000-j100*100)/10
	if(kf.lt.0) then
        j1000=  -j1000
	j100 = -j100
	j10 = -j10
	endif
        if(spin.lt.vfr(13)) then
          ifla=j1000
          iflb=ifrkfc(j100,j10,0,1.d0)
        elseif(spin.lt.vfr(13)+vfr(14)) then
          ifla=j10
          iflb=ifrkfc(j1000,j100,0,1.d0)
        elseif(spin.lt.vfr(13)+vfr(14)+vfr(15)) then
          ifla=j100
          iflb=ifrkfc(j1000,j10,0,0.d0)
        endif
c...certain lambda-like hadrons have two lightest quarks in spin-0:
	  if(abs(j100).lt.abs(j10)) then
        if(spin.lt.vfr(13)) then
          ifla=j1000
          iflb=ifrkfc(j100,j10,0,0.d0)
        elseif(spin.lt.vfr(13)+vfr(14)) then
          ifla=j10
          iflb=ifrkfc(j1000,j100,0,1.d0)
        elseif(spin.lt.vfr(13)+vfr(14)+vfr(15)) then
          ifla=j100
          iflb=ifrkfc(j1000,j10,0,1.d0)
        endif
	  endif
	
      else

        call frmgout(0,0,'unrecognized particle kf code',
     >     dble(kf),0.d0,0.d0,0.d0,0.d0)

      endif
 

      return
      end

c********************************* end frbeleo **************************

c********************************* ifrkfc ******************************

c... the kf code for a 2- or 3-quark system of spin s composed by 
c... flavor ia, ib, ic: (the system must be qq or qqq, not qqbar, etc).
c... it corresponds to a diquark system if ic=0.........................

      integer function ifrkfc(ia,ib,ic,s)
       implicit double precision (a-h, o-z)
      ia0 = max( iabs(ia), max(iabs(ib),iabs(ic)))
      ic0 = min( iabs(ia), min(iabs(ib),iabs(ic)))
      ib0 = iabs(ia+ib+ic)-ia0-ic0
      ifrkfc = 1000*ia0 + 100*ib0 + 10*ic0 + int(2.*(s+0.2))+ 1
      if(ia.ne.iabs(ia).or.ib.ne.iabs(ib)) ifrkfc = -ifrkfc
      return
      end

c********************************* end ifrkfc **************************
      

c********************************* frangur ******************************

      subroutine frangur(l,j)
      implicit double precision (a-h,o-z)
      save

c-----------------------------------------------------------------------
c     add the diffractive particles to the event record
c-----------------------------------------------------------------------

      parameter (ksz1=20,ksz2=300)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn1/pps(2,ksz2,5),pph(2,ksz2,5),ppsy(2,ksz2,5),ppa(2,5)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
       include "Zlujets.h"
      save /frpara1/,/frintn1/,/frintn3/,/lujets/

      n=n+1
      k(n,1)=1
      k(n,2)=idn(l,j)
      k(n,3)=0
      k(n,4)=0
      k(n,5)=0
      p(n,1)=ppsy(l,j,1)
      p(n,2)=ppsy(l,j,2)
      p(n,3)=(ppsy(l,j,4)-ppsy(l,j,3))/2.
      p(n,4)=(ppsy(l,j,4)+ppsy(l,j,3))/2.
      p(n,5)=ulmass(idn(l,j))

      return
      end

c********************************* end frangur **************************

c********************************* fratleo ******************************

      subroutine fratleo(l,j)
      implicit double precision (a-h,o-z)
      save

c      implicit double precision (d)
      parameter (ksz1=20,ksz2=300,maxstr=100)
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/pyparsC/mstp(200),parp(200),msti(200),pari(200)
      common/ardat1/para(40),msta(40)
      common/arstrs/ipf(maxstr),ipl(maxstr),iflow(maxstr),
     $                pt2lst,imf,iml,io,qdump,istrs

      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frintn1/pps(2,ksz2,5),pph(2,ksz2,5),ppsy(2,ksz2,5),ppa(2,5)
      common/frintn2/nhp(2),ihqp(2,ksz2),khp(2,ksz2,250,5),
     >               php(2,ksz2,250,5)
      common/frintn3/idn(2,ksz2),fmn(2,ksz2),nuc(2,3000)
      common/frintn4/kfend(2,ksz2,2)
      include "Zfrjets.h"

      common/fratle1/na1,ka1(ksz2,5),pa1(ksz2,5)

      dimension dpv1(4),dpv2(4),ppsr(4),rfa(2,2),xpq(-25:25)
     >        ,pgl(2)

      save rfa, j1m,ifl1m,ifl2m
      save /lujets/,/ludat1/,/pyparsC/,/ardat1/,/arstrs/,/frpara1/,
     >   /frintn0/,/frintn1/,/frintn2/,/frintn3/,/frintn4/,
     >   /frjets/,/fratle1/

c-----------------------------------------------------------------------
c to set parton codes and momenta for the j-th hadron string, with ends
c flavours ifl1 and ifl2.  calls ariadne for dipole shower.
c for baryons, ifl2 always corresponds to the diquark end.
c this routine is entered twice (for each collision), once in test mode
c    and once for the final gluon radiation.
c
c codes used for partons:
c   k(j,5)=111 for a hard valence quark and its accompaning gluon kink;
c         =221 for a sea quark that has converted into a gluon.
c         =222 for the soft gluon kink accompaning a hard gluon.
c         =100 for the hard gluon.
c
c l =1 for projectile; and l=2 for target.
c    iop(15)=0 normal mode, arrange the partons and do bremsstrahlung
c    iop(15)=1 test mode, look for valence quarks and testing if rps is
c              drowned. output flag:
c           =1+l: gluon on l drowned;
c php(l,j,k,5) will be used to memorize the fractions. 
c khp(l,j,1,5)=i   labels the valence quark
c-----------------------------------------------------------------------

      if(l.eq.1) j1m= 0
                 j2m= 0
      ifl1= kfend(l,j,1)
      ifl2= kfend(l,j,2)

	if(iop(15).gt.0) then
      ifl2a = ifl2
      ifl2b = 0
      spin0 = 0.
      if(abs(ifl2).gt.1000) then
      ifl2a = (ifl2/abs(ifl2))* (abs(ifl2)/1000)
      ifl2b = (ifl2/abs(ifl2))* ((abs(ifl2)-abs(ifl2a)*1000)/100)
      spin0 = dble((abs(ifl2)-abs(ifl2a)*1000-abs(ifl2b)*100)/2)
      endif
        endif

      iqqk = 0
      iqgl = 0
      na1 = 0 

      if(ihqp(l,j).le.0) goto 150

      i0 = khp(l,j,ihqp(l,j),4)+1

      do 1000 i = i0, ihqp(l,j)

      khp(l,j,i,4) = 0

c   check if a quark is possibly a valence:
c   the processes in which quark flavors changed are treated as sea quarks:
c   note since pythia only has pions and protons, only u,d can be valence.

      if(iop(15).gt.0.and.nj.gt.0
     >   .and.khp(l,j,1,5).eq.0.and.khp(l,j,i,2).ne.21
     >   .and.(msti(1).ne.12.and.msti(1).ne.53) ) then 

      iu = khp(l,j,i,2)
      iusn = (iu/iabs(iu)) 

        if(iu.eq.ifl1.or.iusn*(iabs(iu)+2).eq.ifl1.or.
     >     iu.eq.ifl2a.or.iusn*(iabs(iu)+2).eq.ifl2a.or.
     >     iu.eq.ifl2b.or.iusn*(iabs(iu)+2).eq.ifl2b) then
c                          weighted by the structure functions     
        call pystfuC(msti(11+l-1),pari(33+l-1),pari(21)**2,xpq)
        rval = abs(xpq(iu)-xpq(-iu))/max(xpq(iu),xpq(-iu))

          if(rlu(0).le.rval) then
          khp(l,j,1,5) = i
           if(iu.eq.ifl1.or.iusn*(iabs(iu)+2).eq.ifl1) then
             khp(l,j,i,2) = ifl1        
           elseif(iu.eq.ifl2a.or.iusn*(iabs(iu)+2).eq.ifl2a) then
             khp(l,j,i,2) = ifl2a        
             if(ifl2b.eq.0) then
               ifl2 = ifl1
               ifl1 = ifl2a
             else
               spin = spin0
               if(ifl1.eq.ifl2b) spin = 1.
               ifl2 = ifrkfc(ifl1,ifl2b,0,spin)
               ifl1 = ifl2a
	     endif
           elseif(iu.eq.ifl2b.or.iusn*(iabs(iu)+2).eq.ifl2b) then
             khp(l,j,i,2) = ifl2b
             spin = spin0
             if(ifl1.eq.ifl2a) spin = 1.
             ifl2 = ifrkfc(ifl1,ifl2a,0,spin)
             ifl1 = ifl2b
           else
             khp(l,j,1,5) = 0
           endif
          endif
        endif
      endif

      if(i.eq.khp(l,j,1,5).and.iqqk.eq.0) then
      do 131 lo=1,4
      ka1(1,lo) = khp(l,j,i,lo)
131   pa1(1,lo) = php(l,j,i,lo)
      pa1(1,5) = 0.0
        ka1(1,1)= 2
        ka1(1,3)= 0
        ka1(1,4)= 0
        ka1(1,5)= 111
	iqqk=1

c..       save the end configurations:
        if(iop(15).gt.0) then
          if(l.eq.1) then
          j1m= j
          ifl1m= ifl1
          ifl2m= ifl2
          else
          j2m= j
	  endif
	endif

      else       
c         gluon entry started at na1=2
      na1 = max(na1+1,2)      
      do 138 lo=1,4
      pa1(na1,lo) = php(l,j,i,lo)
138   ka1(na1,lo) = khp(l,j,i,lo)
      pa1(na1,5) = 0.0
      ka1(na1,1)=2
      ka1(na1,5)=0
      if(ka1(na1,2).ne.21) ka1(na1,5) = 221
      ka1(na1,2)=21
      ka1(na1,3)=0
      ka1(na1,4)=0
      ka1(na1,5)=0
      iqgl= iqgl + 1

      endif

1000  continue


c...order the gluons according to pt..............
      if(na1.gt.2) call frorder(l,2,na1)

c...dipole radiation.......................

150   iop(17) = n+1

      if(iqqk.eq.1) then
      n = n+1
      do 190 lo=1,5
      k(n,lo) = ka1(1,lo)
190   p(n,lo) = pa1(1,lo)
      p(n,5) = 0.0
      p(n,4) = sqrt(p(n,1)**2+p(n,2)**2+p(n,3)**2)
      endif

c...............set up the two fractions:

      rfa(l,1) = 1.0            
      if(kfr(10).ne.0.and.iqgl.gt.0) then
        if(php(l,j,1,5).gt.0) then
        rfa(l,1) = php(l,j,1,5)
        else
          if(kfr(10).eq.1) then
          rfa(l,1) = vfr(16)
          elseif(kfr(10).eq.2) then
          rfa(l,1) = rlu(0)
          endif
        php(l,j,1,5)= rfa(l,1)
        endif
      endif
      if(rfa(l,1).gt.1.0) call frmgout(0,0,'vfr(16)>1 not allowed!',
     >   vfr(16),rfa(l,1),0.d0,0.d0,0.d0)
      
      rfa(l,2) = 1.0
      if(kfr(8).ge.1.and.iqgl.gt.0) then
        if(php(l,j,2,5).gt.0) then
        rfa(l,2) = php(l,j,2,5)
        else
      pgl(1) = pa1(iqgl+1,4)-pa1(iqgl+1,3)
      pgl(2) = pa1(iqgl+1,4)+pa1(iqgl+1,3)
      ap = sqrt( pgl(l)/ppsy(l,j,2+l))
c       rarely pgl can become zero due to inaccuracy when pz is very large.
      rkk = 0.
      rkkmx= 1.0-(pps(l,j,1)**2+pps(l,j,2)**2)/(pps(l,j,3)*pps(l,j,4))
      rkkmx = 0.99*rkkmx
593   if(ap.gt.0.) rkk=ap*((rkkmx+ap)/ap)**rlu(0)-ap
      if(rkk.le.0..or.rkk.ge.rkkmx) goto 593
      rfa(l,2) = 1.- rkk
      php(l,j,2,5)= rfa(l,2)
        endif
      endif

      do 588 lo=1,4
588   ppsr(lo) = pps(l,j,lo)

c...for the kink:
      if(rfa(l,2).gt.0.and.rfa(l,2).lt.1.0) then
      pgl(l) = (1.-rfa(l,2))* pps(l,j,2+l)
      pa1(1,1)= 0.0
      pa1(1,2)= 0.0
      pgl(3-l) = 0.0
      pa1(1,3)=0.5*(pgl(2)-pgl(1))
      pa1(1,4)=0.5*(pgl(2)+pgl(1))
      ka1(1,1)=2
      ka1(1,2)=21
      ka1(1,4)=3
      ka1(1,5)=222
      ppsr(3) = ppsr(3) - pgl(1)
      ppsr(4) = ppsr(4) - pgl(2)
      endif

590   call frppart(l,ppsr,dpv1,dpv2)

      n = n+1
      do 599 lo=1,4
599   p(n,lo) = dpv1(lo)
      p(n,5) = 0.0
      p(n,4) = sqrt(p(n,1)**2+p(n,2)**2+p(n,3)**2)
      k(n,1) = 2
      k(n,3) = 0
      k(n,4) = 1
      if(iqqk.eq.0) then
      k(n,2) = ifl1
      k(n,5) = 0
      elseif(iqqk.eq.1) then
      k(n,2) = 21
      k(n,5) = 111
      endif

      n = n+1
      do 600 lo=1,4
600   p(n,lo) = dpv2(lo)
      p(n,5) = 0.0
      p(n,4) = sqrt(p(n,1)**2+p(n,2)**2+p(n,3)**2)
      k(n,1) = 1
      k(n,2) = ifl2
      k(n,3) = 0
      k(n,4) = 2
      k(n,5) = 0

c...  check mass and remove negative mass arising from numerical 
c...  imprecisions.  
      rms0= ppsr(3)*ppsr(4)- ppsr(1)**2-ppsr(2)**2
      jn=n
      if(p(n-1,4).lt.p(n,4)) jn=n-1
      pp2=(p(n,3)+p(n-1,3))**2+(p(n,2)+p(n-1,2))**2
     >     +(p(n,1)+p(n-1,1))**2
      xrms20=(p(n,4)+p(n-1,4))**2-pp2 -rms0

      if(xrms20.lt.0.) then
      xadd0=0.0
      xadd1=0.0
700   xadd1=xadd1+0.1
      pjnv= p(jn,4)+xadd1 
      xrms2=(p(2*n-1-jn,4)+pjnv)**2-pp2-rms0
      if(xrms2*xrms20.gt.0.) goto 700

      ntry=0
710   xadd= (xadd0+xadd1)/2.0
       xrms2m=xrms2
       pjnv= p(jn,4)+xadd 
       xrms2=(p(2*n-1-jn,4)+pjnv)**2-pp2-rms0
       if(xrms2*xrms20.gt.0.) then
        xadd0=xadd
       else
        xadd1=xadd
       endif
       if(xrms2.eq.xrms2m) then
         ntry=ntry+1
       else
         ntry=0
       endif

       if(ntry.ge.5) then
         if(xrms2.le.-0.5*rms0) xadd=xadd1
         goto 720 
       endif

       goto 710

720    p(jn,4) = p(jn,4)+ xadd
      endif

      msta(11) = 0

c..test hard partons against bremsstrahlung
      if(kfr(9).ne.0.and.iop(15).eq.1.and.iqgl+iqqk.gt.0) then
        if(iqgl.gt.0.and.rfa(l,1).lt.1.0) then
        para(11) = vfr(7+l)/(rfa(l,1))
        para(12) = vfr(7+l)/(1.-rfa(l,1))
        endif
        call frtestg(l,iqqk,iqgl,iok,rfa)
        if(iok.eq.0) then
        iop(15) = iop(15) +l
          if(j1m.gt.0) khp(1,j1m,1,5)= 0
          if(j2m.gt.0) khp(2,j2m,1,5)= 0
        goto 999
        elseif(l.eq.2.and.iqqk+j1m.gt.0) then
c..            if valence quarks survived, keep the new ends:
        kfend(l,j,1) = ifl1
        kfend(l,j,2) = ifl2
          if(j1m.gt.0) then        
        kfend(1,j1m,1) = ifl1m
        kfend(1,j1m,2) = ifl2m
          endif
        endif
      endif

c.. insert hard gluons one by one, and do emission.  the pt of emission is
c.. restricted such that   pt_next gluon < pt < previous emmision. 

                         if(iop(15).eq.0) then
      para(11) = vfr(7+l)
      para(12) = para(11)
      msta(11) = 0
      if(rfa(l,1).lt.1.0) then
       para(11) = vfr(7+l)/(rfa(l,1))
       para(12) = vfr(7+l)/(1.-rfa(l,1))
      endif

      iari = 0
      para3=para(3)
      para6=para(6)
      do 900 i = 1, max(iqgl,1)
      
        inup= 0
        if(i.eq.1) inup= 0
        call frmxgpt(iop(17),inup,imx,vrptnx,1)
        if(imx.gt.0) then
          call frinset(imx,iop(17),n,nog,1)
          if(i.eq.1.and.kfr(8).gt.0) then
            call frinskk(rfa(l,2),nkk)
            if(nkk.gt.0) then 
            para(13) = para(11)/(1.-rfa(l,2))
            para(11) = para(11)/rfa(l,2)
            endif
          endif
        endif

        if(kfr(2).eq.1) then
        para(3) = max(para3,vrptnx) 
        if(iari.gt.0) para(6) = frsqr(pt2lst,'pt2lstar') 
        nmem = n
        call frariad
        iari= n-nmem
        endif

900   continue
      para(3)=para3
      para(6)=para6
			         endif

999   return
      end

c************************************************************************

      real*8 function fript(i,n1,n2,iq)
       implicit double precision (a-h, o-z)
       save
c....evaluate the invariant p_t**2 of parton i as if i is put between
c....partons n1 and n2.
c....iq=1: definition 1: s12*s13/s123
c....  =2: definition 2: s12*s13/(s123-s12-s13) (true p_t^2 in cms of n1 n2)
c....  <0: use the n1 and n2 of previously memorized (n1,n2 dummy here).

c      implicit double precision (d)
       include "Zlujets.h"

      dimension dm(2,5), di(4), ds(3)
      save dm
      save /lujets/
  
      if(iq.gt.0) then
      do 20 lo=1,5
      dm(1,lo) = ( p(n1,lo))
20    dm(2,lo) = ( p(n2,lo))
            if(i.eq.n1.or.i.eq.n2) then
      fript = 0.
      return
            endif
      endif

      do 30 l=1,3
      do 35 lo=1,4
      if(l.le.2) di(lo) = dm(l,lo)+ dble( p(i,lo))
      if(l.eq.3) di(lo) = dm(1,lo)+ di(lo)
35    continue
30    ds(l) = di(4)**2- di(3)**2-di(2)**2-di(1)**2

      ds(1) = ds(1) - (dm(1,5)+(p(i,5)))**2
      ds(2) = ds(2) - (dm(2,5)+(p(i,5)))**2
      if(iabs(iq).eq.2) ds(3) = ds(3) - ds(1) - ds(2)
      if(dabs(ds(3)).le.1.d-5) ds(3) = 1.d-5

      fript = ds(1)*ds(2)/ds(3) 

      return
      end

c************************************************************************
c********************************* end fratleo **************************

c*********************** subroutine frtestg *****************************

      subroutine frtestg(l,iqqk,iqgl,iok,rfa)
      implicit double precision (a-h,o-z)
      save

c.......test a gluon against the bremsstrahlung background
c....... iqgl = the number of gluons
c....... iok =1 - gluon sticks out ;  iok=0 - drawned.

      parameter (ksz1=20,ksz2=300)
      common/frintn1/pps(2,ksz2,5),pph(2,ksz2,5),ppsy(2,ksz2,5),ppa(2,5)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
       include "Zlujets.h"
      common/ardat1/para(40),msta(40)
      save /frintn1/,/frpara1/,/frintn0/,/lujets/,/ardat1/
      dimension rfa(2,2)

      iok = 0

      msta6 = msta(6)
      msta(6) = 1
      para11 = para(11)
      para3 = para(3)

      call frsaven(iop(17),0)

      nog = 0
      ptgl2 = 0.
      if(iqqk.gt.0) ptgl2=max(ptgl2,fript(iop(17),iop(17)+1,
     >                        iop(17)+2,1))
       if(iqgl.gt.0) then
       call frmxgpt(iop(17),n,imx,vrptnx,0)
       call frinset(imx,iop(17),n,nog,1)
        call frinskk(rfa(l,2),nkk)
        if(nkk.gt.0) then
        para(13) = para(11)/(1.-rfa(l,2))
        para(11) = para(11)/rfa(l,2)
        endif
       if(nog.gt.0) ptgl2 = max(ptgl2,fript(nog,nog-1,nog+1,1) )
       endif

      if(ptgl2.ge.para3**2) then
c        para(3) = sqrt(ptgl2)
c        nm = n
c        call frariad
c        if(n-nm.eq.0) iok= 1
c
      ptar = 0.
      nm = n
      call frariad
       if(n -nm.ge.1) then
        do 11 ii=iop(17)+1, n-1
          if(k(ii,2).eq.21.and.k(ii,5).eq.1) then
          ptar = fript(ii,ii-1,ii+1,1)
          goto 100
          endif
 11     continue
       endif
100   if(ptar.le.ptgl2) iok= 1

      endif

c.......restore the configuration:

      call frsaven(iop(17),1)
      msta(6) = msta6
      para(3) = para3
      para(11) = para11

      return
      end
      

c************************end frtestg ************************************

c*********************** subroutine frariad ***********************

      subroutine frariad
      implicit double precision (a-h,o-z)
      save

c..fritiof interface to ariadne_4.02r.  lujets entries from iop(17) to n
c..are copied to ariadne event record arjetx, and after emission is done
c..partons are copied back onto lujets.


      parameter (ksz1=20)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
       include "Zlujets.h"
c          change by kk.  300 -->  mxjetx: should be the same as
c          that in ariadne.
      parameter (mxjetx=3000)
      common/arjetx/no,ko(mxjetx,5),po(mxjetx,5),vo(mxjetx,5)
      save /frintn0/,/lujets/,/arjetx/

      no=0
      do 100 i=iop(17),n
      no=no+1
      do 100 lo=1,5
      ko(no,lo) = k(i,lo)
100   po(no,lo) = p(i,lo)

      call arexec

      n=iop(17)-1
      do 200 io=1,no
      if(ko(io,1).ge.11) goto 200
      n=n+1
      do 250 lo=1,5
      k(n,lo) = ko(io,lo)
250   p(n,lo) = po(io,lo)
200   continue

      return
      end

c*********************** end frariad *****************************

c******************************** frmxgpt ********************************

      subroutine frmxgpt(n1,n2,imx,vrptnx,idrop)
      implicit double precision (a-h,o-z)
      save

c..   to find the gluon with maximu inv-pt among those on fratle1:2-na1.
c..   idrop=1: the gluon will have ka1(i,3)=-2001 once it has been used.
c..        =0: gluons will not be marked (used when called from frtestg.
c..   the inv pt is calculated assuming the gluon is between n1 and n2.
c..   imx=0 - no more gluons are available;
c..   imx>=2 - index of the gluon with largest inv-pt.
c..   vrptnx gives value of the next largest pt.
c..   when n1 or n2 <= 0, previous memorized p(n1,)and p(n2,) will be used.

      parameter (ksz2=300)
       include "Zlujets.h"
      common/fratle1/na1,ka1(ksz2,5),pa1(ksz2,5)
      save /lujets/,/fratle1/

      vrptnx=0.
      imx=0

      if(na1.eq.2) then
      imx=2

      elseif(na1.gt.2) then

      iq=1
      if(n1.le.0.or.n2.le.0) iq=-1
      vrpt2m=-1.e4
      do 100 i=2, na1
      if(ka1(i,3).eq.-2001) goto 100
        do 120 lo=1,5
120     p(n+1,lo)=pa1(i,lo)
      vrpt2 = fript(n+1,n1,n2,iq)
      iq=-1

      if(vrpt2.gt.vrpt2m.or.imx.eq.0) then
      imx = i
      vrptnx=sqrt(max(vrpt2m,0.d0))
      vrpt2m=vrpt2
      endif
      
100   continue

      endif

      if(idrop.gt.0.and.imx.gt.0) ka1(imx,3)=-2001

      return
      end

c******************************** end frmxgpt ********************************

c******************************** frinset ********************************

      subroutine frinset(na,n1,n2,nog,iq)
      implicit double precision (a-h,o-z)
      save

c.......to place a gluon specified by na on fratle1 block onto lujets
c.......between n1,n2, where n1 is assumed to be quark n2g could be
c.......the gluon kink or the end diquark.
c.......the placing is based on rapidity 
c.......ordering, and if more than one rapidity-ordered spots are
c.......found then the one giving maximum invariant mass is used.  
c.......if no such place is found then na is placed near n1. 
c....... iq:=0 the actual insertion will not take place, n1,n2,n unchanged;
c........   =1 the insertion takes place, and the entire lujets n>nog
c........      is shifted by 1. 
c....... output nog: the actual place na was placed;
c....... the inserted gluon has a code: k(nog,5)=100.
c....... the gluon will not be placed at the string ends.  so in case of
c....... q-qbar pairs from gluon splitting in ariadne, the gluon
c....... will not be placed between the pair.  


      parameter (ksz2=300)
       include "Zlujets.h"
      common/fratle1/na1,ka1(ksz2,5),pa1(ksz2,5)
      dimension y(2)
      save /lujets/,/fratle1/

      nog = 0
      if(n2.le.n1+1) goto 250

      ygl = pa1(na,4) - pa1(na,3)
      ygu = pa1(na,4) + pa1(na,3)
      if(ygu.le.0.) then
      yg = -.9e10
      elseif(ygl.le.0.) then
      yg = +.9e10
      else
      yg = .5* log(ygu/ygl)
      endif

      vm2x = 0.
      do 200 i = n1, n2-1
      if(k(i,5).eq.222.and.k(i,2).eq.21) goto 250
      num=2
      if(i.ne.n1) then
      num=1
      y(1) = y(2)
      endif
       do 100 ii=1,num
       ir = i+2-ii
       yl = p(ir,4) - p(ir,3)
       yu = p(ir,4) + p(ir,3) 
cc       if(yu.le.0.and.yl.le.0.) call frmgout(0,1,' 0 momenta!',
cc     >         float(ir),p(ir,1),p(ir,2),p(ir,3),p(ir,4))
       if(yu.le.0.) then
       yr = -1.e10
       elseif(yl.le.0.) then
       yr = +1.e10
       else
       yr = .5* log(yu/yl)
       endif
       y(3-ii) = yr
100    continue

      if( k(i,1).eq.2 .and.
     >  (yg.ge.min(y(1),y(2)).and.yg.le.max(y(1),y(2))) ) then
      vm2=(pa1(na,4)+p(i,4)+p(i+1,4))**2-(pa1(na,3)
     >     +p(i,3)+p(i+1,3))**2-(pa1(na,2)+p(i,2)+p(i+1,2))**2- 
     >     (pa1(na,1)+p(i,1)+p(i+1,1))**2
       if(vm2.gt.vm2x) then
       vm2x = vm2
       nog = i+1
       endif
      endif
200   continue

250    nog = max(n1+1, nog)

      if (iq.ge.1) then
      do 150 i = n, nog, -1
      do 150 lo = 1,5
      k(i+1,lo) = k(i,lo)
150   p(i+1,lo) = p(i,lo)

      do 160 lo = 1,5
      k(nog,lo) = ka1(na,lo)
160   p(nog,lo) = pa1(na,lo)
      p(nog,4) = sqrt(p(nog,1)**2+p(nog,2)**2+p(nog,3)**2)
      p(nog,5) = 0.0
      k(nog,3) = 0
      k(nog,4) = 0
      k(nog,5) = 100
      n = n+1
      endif

      return
      end

c******************************** end frinset ********************************

c****************************** frppart *********************************

      subroutine frppart(l,ppsr,dpv1,dpv2)
      implicit double precision (a-h,o-z)
      save

c........if a system has a lightcone-momenta ppsr(4), it is partitioned
c........into two momenta corresponding to the quark (dpv1) and diquark(dpv2)
c........end.  note the input ppsr is light-cone: px,py,p-,p+, and the output
c........dpvs are normal 4-vector: px,py,pz,e.

      parameter (ksz1=20,pi = 3.1415926)
c      implicit double precision (d)
      dimension ppsr(4),dpv1(4),dpv2(4)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      save /frpara1/

      ppst2 = ppsr(1)**2+ppsr(2)**2
      wt2 = ppsr(3)*ppsr(4) 
      sm = wt2 - ppst2
      gp2mx = 0.25* (sqrt(wt2)-sqrt(ppst2))**2

      ntry= 0
10    ntry=ntry+1
      if(ntry.gt.200) call frmgout(0,1,'ntry runaway loop:',
     >      dble(ntry),0.d0,0.d0,0.d0,0.d0)

c.... ....to generate a gaussian pt for the diquark ..............

      call frgauss(gp2, vfr(7), gp2mx)
        gpt = frsqr(gp2, 'pt2hgf')
        phi= 2.*pi*rlu(0)
        dpv2(1) = (gpt*cos(phi))
        dpv2(2) = (gpt*sin(phi))

      dpv1(1) = -dpv2(1) + (ppsr(1))
      dpv1(2) = -dpv2(2) + (ppsr(2))

c........dpv1 corres. to the quark end, dpv2 corres. to the diquark end....

      dgpt1 = dpv1(1)**2 + dpv1(2)**2
      dgpt2 = dpv2(1)**2 + dpv2(2)**2
      dtm1 =dble(ppsr(3))+ (dgpt2-dgpt1)/(ppsr(4))
      dtm2=dtm1**2-4.d0*dgpt2*(ppsr(3))/(ppsr(4))
      if(dtm2.lt.-0.1) call frmgout(0,1,'check dtm2',wt2,ppst2,
     >    real(dgpt1),real(dgpt2),gp2mx)
      dtm2=dfrsqr(dmax1(0.d0,dtm2),'dtm2$')

      dgpv2m = (dtm1-(-1)**(l-1)*dtm2)/2.d0
      dgpv1m = (ppsr(3))-dgpv2m
      dgpv1p = dgpt1/dgpv1m
      dgpv2p = (ppsr(4))-dgpv1p
cc      dgpv1p = (dble(ppsr(4))*dgpv2m-dgpt2+dgpt1)/dble(ppsr(3))
      
      dpv1(3) = 0.5d0*(dgpv1p-dgpv1m)
      dpv1(4) = 0.5d0*(dgpv1p+dgpv1m)
      dpv2(3) = 0.5d0*(dgpv2p-dgpv2m)
      dpv2(4) = 0.5d0*(dgpv2p+dgpv2m)

      return
      end

c****************************** end frppart *****************************

c************************************ frinskk ***************************

      subroutine frinskk(xf,nkk)
      implicit double precision (a-h,o-z)
      save

c...to insert the soft gluon kink stored at na1=1 to lujets_n.
c...output: nkk=location of the kink. 
c.......   nkk=0 - gluon kink is not inserted;

      parameter (ksz1=20,ksz2=300)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn1/pps(2,ksz2,5),pph(2,ksz2,5),ppsy(2,ksz2,5),ppa(2,5)
      common/fratle1/na1,ka1(ksz2,5),pa1(ksz2,5)
       include "Zlujets.h"
      save /frpara1/,/frintn1/,/fratle1/,/lujets/

      if(xf.le.1e-5.or.xf.ge.0.99999.or.ka1(1,2).ne.21) then
      nkk = 0
      return
      endif

      nkk = n
        do 200 lo = 1, 5
        p(n+1,lo) = p(n,lo)
200     k(n+1,lo) = k(n,lo)

        do 205 lo = 1, 5
        k(nkk,lo) = ka1(1,lo)
205     p(nkk,lo) = pa1(1,lo)
        p(nkk,4) = sqrt(p(nkk,1)**2+p(nkk,2)**2+p(nkk,3)**2)
        p(nkk,5) = 0.0

        n = n+1

      return
      end

c********************************* end frinskk ***************************

c*************************** frsaven ********************************


      subroutine frsaven(n1,iq)            
      implicit double precision (a-h,o-z)
      save
c..iq=0: to save a lujets configuration (with 3 partons) n1 and n temporarily 
c..iq=\=0: restore the configuration at n1 and n1+1=n

       include "Zlujets.h"
      dimension km(3,5),pm(3,5)
      save km, pm, num
      save /lujets/

      if(iq.eq.0) then
      num = n-n1+1
      if(num.gt.3) call frmgout(0,0,'more than 3 partons in
     > frsaven',dble(n1),dble(n),0.d0,0.d0,0.d0)

      do 100 i=n1,n
      im = i-n1+1 
      do 100 lo=1,5
      pm(im,lo) = p(i,lo)
100   km(im,lo) = k(i,lo)

      else

      do 200 i=1,num
      ni = n1+i-1
      do 200 lo=1,5
      p(ni,lo) = pm(i,lo)
200   k(ni,lo) = km(i,lo)

      n = n1+num-1

      endif

      return
      end

c*************************** end frsaven ********************************

c********************************* frfilhw ******************************

      subroutine frfilhw
      implicit double precision (a-h,o-z)
      save

c     to add those vector bosons,higgs etc (if they are produced from
c     parton subprocesses) to lujets

       include "Zlujets.h"
      common/frcnut/nr,kr(10,5),pr(10,5),nr0
      save /lujets/,/frcnut/

      if(nr.le.0) return
      do 10 i = 1, nr
       n= n+1
       do 20 j=1, 5
       k(n, j) = kr(i,j)
20     p(n, j) = pr(i,j)
        k(n,1)=1
        k(n,3)=0
10    continue

      return
      end

c********************************* end frfilhw **************************

c********************************* frorder ******************************

      subroutine frorder(l,ns,ne)
      implicit double precision (a-h,o-z)
      save
c......to order particles (gluons) according to 
c........for kfr12=1, ascending rapidity for projectile
c........              descending rapidity for target
c........for kfr12>,=2, ascending pt

      parameter (ksz2=300,ksz1=20)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/fratle1/na1,ka1(ksz2,5),pa1(ksz2,5)
      common/frdumyor/ko(ksz2,5),po(ksz2,5),y(ksz2),ii(ksz2)
      save /frpara1/,/fratle1/,/frdumyor/

      kfr12 = 2
      if(ne.le.ns) return
      if(ne-ns+1.gt.ksz2) call frmgout(0,1,'frdumyor array size 
     > insufficient', dble(ns),dble(ne),0.d0,0.d0,0.d0)

      sml = 1.e-20            
      if(l.eq.1.or.kfr12.ge.2) then
c             !ascending
      iq = -1                 
      else
c              !descending
      iq = 1    
      endif

      ior=0
      do 31 io = ns, ne
      ir = io - ns + 1
      do 33 j=1, 5
      ko(ir,j) = ka1(io,j)
33    po(ir,j) = pa1(io,j)
      ppls = pa1(io,4) + pa1(io,3)
      pmis = pa1(io,4) - pa1(io,3)
      if(kfr12.eq.1) then
      y(ir) = .5* log( max(ppls,sml)/max(pmis,sml))
      elseif(kfr12.ge.2) then
      y(ir) = pa1(io,1)**2+pa1(io,2)**2
      endif
      if(ior.eq.0.and.ir.ge.2) then
       if(iq.eq.1.and.y(ir).gt.ylim) ior=1
       if(iq.eq.-1.and.y(ir).lt.ylim) ior=1
      endif
      if(ir.eq.1) then
      ylim = y(1)
      elseif(ir.gt.1.and.iq.eq.1) then
      ylim = min(ylim,y(ir))
      elseif(iq.eq.-1) then
      ylim = max(ylim,y(ir))
      endif

31    continue

      if(ior.eq.0) return

      call frord01(y, ii, ne-ns+1, iq)

      do 35 io = ns,ne
      ir = io - ns + 1
       do 35 j = 1, 5
      ka1(io,j) = ko(ii(ir),j)
35    pa1(io,j) = po(ii(ir),j)

      return
      end

c************************************ frord01 **************************

      subroutine frord01(p,ii,n,iq)
      implicit double precision (a-h,o-z)
      save

c           routine to arrange ii so that
c           p(ii(1)) >= p(ii(2)) >= ... >= p(ii(n)), if iq>,=0
c           p(ii(1)) <= p(ii(2)) <= ... <= p(ii(n)), if iq<0
c
      dimension p(*)
      integer ii(*)
      logical done

      do 101 k=1,n
101   ii(k)=k

      do 110 nlim = n-1,1,-1
            done = .true.
              if(iq.ge.0) then
            do 120 k = 1,nlim
                  if ( p(ii(k)) .lt. p(ii(k+1)) ) then
                        done=.false.
                        itemp=ii(k)
                        ii(k)=ii(k+1)
                        ii(k+1)=itemp
                        end if
 120        continue
            if (done) return
              else
            do 130 k = 1,nlim
                  if ( p(ii(k)) .gt. p(ii(k+1)) ) then
                        done=.false.
                        itemp=ii(k)
                        ii(k)=ii(k+1)
                        ii(k+1)=itemp
                        end if
 130        continue 
            if (done) return
             endif
110   continue

      return
      end


c********************************* end frord01 **************************



c*************************************************************************
c**                                                                     **
c**   this package interfaces with pythia and handles the generated     **
c**   hard partons                                                      **
c**                                                                     **
c*************************************************************************

c********************************* frqprob ******************************

      subroutine frqprob(kfi,kft,iq)
      implicit double precision (a-h,o-z)
      save

c.... to estimate cross sections.
c......kfi, kft - the kf codes of the incident and target particle (nucleon).
c......iq=0 will suppress all the write out.


      parameter (ksz1=20)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frcodes/ipt(2),pacd(27),nnuc(27),nprot(27),kcd(27)
     >           ,ro1(27,2),exma(9,2)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/pysubsC/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pyparsC/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1C/mint(400),vint(400)
      common/pyint5C/ngen(0:200,3),xsec(0:200,3)
      character pacd*4,nam1*16,nam2*16,nam1s*8,nam2s*8,words*21
      save /frpara1/,/frcodes/,/frintn0/,/lujets/,/ludat1/,/pysubsC/,
     >     /pyparsC/,/pyint1C/,/pyint5C/

      n=0
      do 100 l = 1,2
       do 120 j = 1, 2
120    p(l,j) = pli0(l,j)
      p(l,3) = (pli0(l,4)-pli0(l,3))/2.
100   p(l,4) = (pli0(l,4)+pli0(l,3))/2.

      w = aop(1)

      if(w.le.parp(2)) then
        if(kfr(7).gt.0) write(mstu(11),3000) w
        kfr(7)= 0
        parp(2)= 0.9*w
      endif
      iop(18)= kfr(7)

      call luname(kfi,nam1)
      call luname(kft,nam2)
      nam1s = nam1
      nam2s = nam2

c.....................................
      call frsetpy(1)
      call frhardp(kfi, kft, w, ihav,-1)

cc      xqcd = xsec(11,3)+xsec(12,3)+xsec(13,3)+
cc     >         xsec(28,3)+xsec(53,3)+xsec(68,3)+ 
cc     >         xsec(81,3)+xsec(82,3)+xsec(83,3)

c......vint(103) = sigl diff cross section; vint(106) = non-diff inelastic 
c......if target is a nuclei, xsections are taken as the average of n,p:

990   if(iq.gt.0) write(mstu(11),999) 
999   format(/1x,79('-')/
     >   4x,'fritiof-frqprob reporting: ',/)

      xinel = vint(106) + vint(103)
      xtot = vint(101)
      xel = vint(102)

      if(nnuc(ipt(2)).gt.1) then      
      call frhardp(kfi, 4324-iabs(kft), w, ihav,-1)
      xtot = (xtot+vint(101))/2.
      xel = (xel+vint(102))/2.
      xinel = (xinel+vint(106)+vint(103))/2.    
      nam2 = 'nucleon'//' '
      endif

      words = '(from the input)' 
      if(vfr(10).le.0.or.vfr(11).le.0.or.iq.gt.0)then
       if(vfr(10).le.0.) vfr(10) = xtot
       if(vfr(11).le.0.) vfr(11) = xel
       words = '(from block-cahn fit)'
      endif
      
       if(iq.gt.0) then
       write(mstu(11),2100) 
     >       nam1s,nam2s,words, vfr(10),vfr(11),xinel 
        write(mstu(11),3001) 
       endif
 
2100  format(6x,'cross sections for ',a8,'-- ',a8,' are',1x,a21,':',/ 
     >        8x,'total cross section=', f10.3, ' mb',/
     >        8x,'elastic cross section=', f10.3, ' mb',/
     >   6x,'non-double diffractive inelastic xsection= ',f8.3,' mb')
3000  format(/4x,'warning! w_cms=',f6.2,'-- w too small for ',  
     > 'hard scattering!',
     > /4x,'excecution continues with rps switched off!',
     > /4x,'(please refer to the pythia parameter parp(2))',/ )
3001  format(1x,79('-')/)

      return
      end

c********************************* end frqprob **************************


c********************************* frhardp *******************************

      subroutine frhardp(kfi,kft,w,ihav,iq)
      implicit double precision (a-h,o-z)
      save

c....given particle kf codes for the projectile kfi and the target kft,
c....and total cms energy w, this routine will generate parton-parton
c....processes (including qcd 2->2 processes, vector bosons or higgs
c....productions, heavy quarks ect).  the generated colored objects
c....are transfered from lujets to block frjets, and the color-neutral 
c....particles are stored in block frcnut. afterwards the n in lujets
c....is reset to zero.
c......ihav=0 - non-hard events; ihav=1, event containing hard process.
c......iq=-1 or 1: pyinitC - pythia initialization is made;
c......iq=others: no pythia initialization
c......for iq<0, only pyevent is called, fredipy will not be callled.

      parameter (ksz1=20)
      character*6 beam(2), parcde7(15)
       include "Zlujets.h"
      common/pysubsC/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pyparsC/mstp(200),parp(200),msti(200),pari(200)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frcnut/nr,kr(10,5),pr(10,5),nr0
      include "Zfrjets.h"
      include "Zfrpickj.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)

      common/frtopyxto/kf0(2)

      dimension kcd7(15),kf(2),ikf(2)   
      save beam
      save /lujets/,/pysubsC/,/pyparsC/,/frintn0/,/frpara1/,/frcnut/,
     >     /frjets/,/frpickj/,/frtopyxto/,/ludat1/

c....the following is a list of particles available in pythia 5.5.
c....note for generating hard scattering, all mesons not on the list
c....will be reduced to corresponding pions, and baryons to protons or 
c....neutrons. obviously this can only be a good approximation
c....at high energies when the gluon distribution dominents.

        data parcde7/
     >  'p+    ','p~-   ','n0    ','n~0   ','pi+   ','pi-   ',
     >  'e-    ','e+    ','nu_e  ','nu_e~ ','mu-   ','mu+   ',
     >  'nu_mu ','nu_mu~','gamma '/
        data kcd7/2212,-2212,2112,-2112,211,-211,
     >            11,  -11,  12,  -12,  13, -13,
     >            14,  -14,  22/
      
      n=0
c...            identify the beam particles: 
      kf(1) = kfi
      kf(2) = kft

      do 20 l=1, 2
                     if( kf(l).ne.kf0(l) ) then
      kf0(l) = kf(l)
      ikf(l) = 0

 5    do 12 i=1, 15
      if(kf(l).eq.kcd7(i)) then
      beam(l) = parcde7(i)
      if(ikf(l).eq.0) ikf(l) = 1
      go to 14
      endif
12    continue 
14      if(ikf(l).eq.0) then
        kfv = iabs(kf(l))
           if(kfv.gt.1000.and.kfv.lt.9999) then
	  kcg=0
        k1 = kfv/1000
          k1r = 2 - mod(k1,2) 
        k2 = (kfv-k1*1000)/100
          k2r = 2 - mod(k2,2) 
        k3 = (kfv-k1*1000-k2*100)/10
          k3r = 2 - mod(k3,2)
        klg= max(k1r,max(k2r,k3r))
        ksm= min(k1r,min(k2r,k3r))
        kme= k1r+k2r+k3r -klg-ksm
        kfvr= 1000*klg+ 100*kme+ 10*ksm+ 2
        if(kfvr.ne.2212.and.kfvr.ne.2112) kfvr= 2212
	kf(l) = kfvr *(kf(l)/kfv)
           elseif(kfv.gt.100.and.kfv.lt.999) then
        k1= kfv/100
        k2= (kfv-k1*100)/10
        k3= (kfv-k1*100-k2*10)
        k1r= 2 - mod(k1,2) 
        k2r= 2 - mod(k2,2) 
        kf(l)=(max(k1r,k2r)*100+min(k2r,k1r)*10+k3)*(-1)**max(k1r,k2r)
        if(k1r.lt.k2r) kf(l)= -kf(l)
	if(abs(kf(l)).ne.211) kf(l) = (kf(l)/iabs(kf(l)))*211
           endif
        ikf(l) = -1
        goto 5
        endif

      if(ikf(l).eq.0) then
        call frmgout(0,1,'pythia unrecognized particle', 
     >        dble(l),dble(kf(1)),dble(kf(2)),0.d0,0.d0)
      elseif(ikf(l).eq.-1) then
c      ///////////
        if(kfr(11) .gt. 0) then
c  //////////
           write(mstu(11),1010) 
          if(l.eq.1) write(mstu(11),1012) 'the projectile',
     >                     kf0(l), beam(l),kf(l)
          if(l.eq.2) write(mstu(11),1012) 'the target    ',
     >                     kf0(l), beam(l),kf(l)
c///////////////
        endif
c ///////////

      endif
      endif
20    continue

c................................      
      nj = 0
      nh = 0
      msti(2) = 0
      msti(3) = 0
      msti(31) = 0
      if(abs(iq).eq.1) call frpyini('user',beam(1),beam(2),w)
      call pyevntC

      if(msti(1).ge.91.and.msti(1).le.95) then
      ihav = 0
      else 
      ihav = 1
      endif

      if(iq.lt.0.or.ihav.eq.0) return

      call fredipy

      do 200 lo = 1, nh
      nj = nj+1
200   call frvecrc(nj,lo,1)
      
1010  format(/,6x,
     >'for the purpose of interfacing with pythia:')
1012  format(8x,a14,' (code=',i5,')',' is treated as ',a6,
     >       '(code=',i5,')',/ )

      return
      end

c********************************* end frhardp ***************************

      
c********************************* frsetpy *******************************

      subroutine frsetpy(iq)
      implicit double precision (a-h,o-z)
      save

c.......to set pt_min and certain switches for pythia................
c....... iq = -1, set on only qcd processes;
c........   = +1, set on qcd + low_pt processes
c:

      parameter (ksz1=20)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/pysubsC/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pyparsC/mstp(200),parp(200),msti(200),pari(200)
      save /frintn0/,/frpara1/,/pysubsC/,/pyparsC/

      mstp(61) = 0       
      mstp(63) = 0      
      mstp(65) = 0
      mstp(71) = 0      
      mstp(91) = 0      
      mstp(111) = 0     
      mstp(122) = 0     
      mstp(31) =5      

c....since sea quarks are treated as gluons in current model, heavy
c....quarks are not included...........
      msub(81) = 0
      msub(82) = 0
      msub(83) = 0

      if(iq.eq.-1) then
      msel = 0
      msub(11) = 1
      msub(12) = 1
      msub(13) = 1
      msub(28) = 1
      msub(53) = 1
      msub(68) = 1
      msub(92) = 0   
      msub(95) = 0
      ckin(3) = vfr(12)
      ckin(5) = vfr(12)
      ckin(6) = vfr(12)
      elseif(iq.eq.1) then
cc      msub(92) = 1   
cc      msub(95) = 1
      msel = 1
      
      endif


c.........multiple interactions....................
      parp(81) = vfr(12)

      return
      end


c********************************* end frsetpy ***************************

c********************************* frvecrc *******************************

c...to set vectors between pj(jf,), pr(jf,), and pp(l,)

      subroutine frvecrc(jf,l,iq)
      implicit double precision (a-h,o-z)
      save

      include "Zfrjets.h"
      common/frcnut/nr,kr(10,5),pr(10,5),nr0
      include "Zfrpickj.h"
      save /frjets/,/frcnut/,/frpickj/

      if(iq.eq.1) then
       do 11 j=1,5
       kj(jf,j) = kp(l,j)
11     pj(jf,j) = pp(l,j)
      elseif(iq.eq.-1) then
       do 21 j=1,5
      kp(l,j) = kj(jf,j) 
21    pp(l,j) = pj(jf,j) 
      elseif(iq.eq.2) then
       do 31 j=1,5
       kr(jf,j) = kp(l,j)
31     pr(jf,j) = pp(l,j)
      elseif(iq.eq.-2) then
       do 41 j=1,5
      kp(l,j) = kr(jf,j) 
41    pp(l,j) = pr(jf,j) 
      endif

      return
      end

c********************************* end frvecrc ***************************


c********************************* fredipy *******************************

      subroutine fredipy
      implicit double precision (a-h,o-z)
      save

c....to pick out the scattered partons out of pythia's event record.
c....note one must have set mstp(61,63,65,71,81,111) all to 0 .
c....the partons picked are stored in block frpickj.

c....kfr19 controls the assignment of the partons to the original nucleons:
c..  (currently in effect: kfr19=1)    
c..   =1 the hardest pairs are assigned according to pythia, the rest randomly.
c..   =2 both pairs of partons are assigned randomly to one of the nucleon;
c..   =0 assignment to be made by inspecting the feynman diagrams in frhqsgn.

c...  side-1: kp(j,3) = 1;  side-2: kp(j,3) = 2  - for the hardest pair;
c...  side-1: kp(j,3) = -1;  side-2: kp(j,3) = -2 - for the softer pairs.

      parameter ( ksz1=20)
      common/frpara1/kfr(ksz1),vfr(ksz1)
       include "Zlujets.h"
      common/pyparsC/mstp(200),parp(200),msti(200),pari(200)
      common/pysubsC/msel,msub(200),kfin(2,-40:40),ckin(200)
      include "Zfrpickj.h"
      save /frpara1/,/lujets/,/pyparsC/,/pysubsC/,/frpickj/

      kfr19 = 1

      ifel = 0
      do 10 l = 1, msti(3)
      if(l.eq.1) then
      line = msti(7)
      if(line.eq.0) line = msti(8)
      elseif(l.eq.2) then
      line = msti(8)
      else
      ifel = 1
      endif

      if(line.eq.0) ifel = 1
      if(ifel.eq.1) call frmgout(0,1,'error in freditpy:',
     >      dble(msti(3)),dble(msti(7)),dble(msti(8)),0.d0,0.d0)
      do 30 j=1,5
      pp(l,j) = p(line,j)
30    kp(l,j) = k(line,j)
      
      if(l.eq.1.and.kfr19.eq.2) then
      kp(1,3) = int(1.5+rlu(0))
      elseif(kfr19.eq.2) then
      kp(l,3) = kp(1,3)
      endif

10    continue


            if(kfr19.eq.1) then
      that = (pari(33)*pari(11)/2.-pp(1,4))**2-
     >   (pari(33)*pari(11)/2.-pp(1,3))**2-pp(1,2)**2-pp(1,1)**2
      t12 = abs( that - pari(15))
      u12 = abs( that - pari(16))

        if(t12.le.u12) then
      kp(1,3) = 1
      kp(2,3) = 2
      else
      kp(1,3) = 2
      kp(2,3) = 1
        endif
            endif


      nh = msti(3)

      if(mstp(81).eq.0.or.kfr(7).ne.2) return

      do 39 l = msti(8)+1, n
      if(k(l,3).eq.0) then

      nh = nh + 1
      if(nh.gt.mxpyjt)
     &  call frmgout(0,0,'extend blocks frpickj and frjets',
     >                         dble(nh),0.d0,0.d0,0.d0,0.d0)  
      iside1 = - int(1.5+ rlu(0))
      iside2 = -3 - iside1
       do 35 li = l+1, n
       xb = abs(p(l,1)+p(li,1))
       yb = abs(p(l,2)+p(li,2))
       if(xb.gt.0.0001.or.yb.gt.0.0001) goto 35
       nh = nh + 1
       do 40 j=1,5
       pp(nh-1,j) = p(l,j)
       kp(nh-1,j) = k(l,j)
       pp(nh,j) = p(li,j)
40     kp(nh,j) = k(li,j)
       kp(nh-1,3) = iside1
       if(kfr19.eq.2) then
       kp(nh,3) = iside1
       k(l,3) = iside1
       k(li,3) = iside1
       else 
       kp(nh,3) = iside2
       k(l,3) = iside1
       k(li,3) = iside2
       endif
       goto 39
35     continue
      endif

39    continue

      return
      end

c********************************* end fredipy ***************************

c********************************* frhplis *******************************

      subroutine frhplis
      implicit double precision (a-h,o-z)
      save

c.........to list the hard partons extracted from pythia event record 
c.........in case one wants to examing it                       ......

      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/pyparsC/mstp(200),parp(200),msti(200),pari(200)
      common/frcnut/nr,kr(10,5),pr(10,5),nr0
      include "Zfrjets.h"
      include "Zfrpickj.h"
      save /ludat1/,/pyparsC/,/frcnut/,/frjets/,/frpickj/

      write(mstu(11),*) '===================================='
      write(mstu(11),10) msti(5)
      write(mstu(11),15) msti(11),msti(12)
      write(mstu(11),20) msti(1), msti(2)
      write(mstu(11),30) msti(3),msti(31)
      write(mstu(11),50) msti(7),msti(8)
      write(mstu(11),60) msti(13),msti(14)
      write(mstu(11),70) msti(15),msti(16),(msti(l),l=21,24) 
      write(mstu(11),80) pari(33), pari(34)

      write(mstu(11),*) ' nh=',nh, '    -- frpickj '
      if(nh.gt.0) then
      do 301 j=1, nh
301   write(mstu(11),3401) j, (kp(j,l),l=1,5),(pp(j,l),l=1,5)
      endif
      write(mstu(11),*) ' nj=',nj, '    -- frjets '
      if(nj.gt.0) then
      do 303 j=1, nj
303   write(mstu(11),3401) j, (kj(j,l),l=1,5),(pj(j,l),l=1,5)
      endif

      write(mstu(11),*) ' nr=',nr, '    -- frcnut '
      if(nr.gt.0) then
      do 305 j=1, nr
305   write(mstu(11),3401) j, (kr(j,l),l=1,5),(pr(j,l),l=1,5)
      endif

10    format( /' parton list at ',i6,2x,'-th call to pythia',/)
15    format( ' collision between ',i5,' & ',i5,/)
20    format( ' subprocess type - msti(1,2): ',2i6 )
30    format( ' no. of partons produced: ',i6, 2x,
     >          ' no. of interactions: ', i3 )
50    format( ' parton line number - msti(7,8): ',2i6 )
60    format( ' initial shower initiaters - msti(13,14): ',2i5 )
70    format( ' the process is ',i4,' +',i4,' ->',i4,' +',i4,
     >     i4,' +',i4 )
80    format( ' x_1, x_2 = ',2g13.6, / )

3401  format(1x,i3,';',2x,5i6,2x,5f10.4, ' -- k, p ' )
      return
      end

c********************************* end frhplis ***************************



c*************************************************************************
c**                                                                     **
c**   this is the package for auxililary subroutines                    **
c**                                                                     **
c*************************************************************************

c********************************* frgauss ****************************

      subroutine frgauss(p2,v,pmax)
      implicit double precision (a-h,o-z)
      save

c.... to return a value p2 which has a maximum set by pmax, and a 
c.... 2-d gaussian distribution with width v, i.e., e^(-p2/v)dp2, 0<p2<pmax.
c.... set pmax < 0 if pmax should be infinity.

      p2 = 0
      if(v.le.1.e-8) return

      if(pmax.lt.0) then
      a = 1.
      elseif(pmax.lt.1.e-9) then
      return
      else
      a = 1. - frrex(-pmax/v)
      endif

10    p2 = -v* log(max(1.d-20,1. - a*rlu(0)))
      if(p2.lt.0.) goto 10

      return
      end

c********************************* end frgauss ************************

c********************************* frbetav ****************************

      subroutine frbetav(id,dbeta,dp)
      implicit double precision (a-h,o-z)
      save

c...for given pair of mementa dp(2,4), this is to fill the array
c...dbeta(3) which are the beta factors for the cms frame.
c.. id = 0 for normal 4-vectors
c.. id = 1 if the vectors are light-cone form: px,py,p-,p+

c      implicit double precision (d)
      dimension dbeta(3),dp(2,5),dr(2,4)

      do 10 i = 1, 2
      dr(i,1) = dp(i,1) 
      dr(i,2) = dp(i,2) 
      if(id.eq.0) then
      dr(i,3) = dp(i,3) 
      dr(i,4) = dp(i,4)
      else  
      dr(i,3) = (dp(i,4)-dp(i,3))/2.d0
      dr(i,4) = (dp(i,4)+dp(i,3))/2.d0
      endif
10    continue

c..... beta_x, beta_y, beta_z
      desum = (dr(1,4)+dr(2,4))
      if(desum.le.0.) stop 'frbeta: e 0'
      do 15 i = 1, 3
15    dbeta(i) = (dr(1,i)+dr(2,i))/desum

      return
      end

c********************************* end frbetav ************************

c********************************* frtocms ****************************

        subroutine frtocms(id,iq,dp,dbetao)
      implicit double precision (a-h,o-z)
      save

c... in double precision.
c... giving a pair of memonta dp(2,4), a call to this routine will
c... transform the momenta into their cms frame.
c... if id = 0, dp is assumed to be the ordinary 4-vector;
c...    id = 1, dp is assumed to be the light-cone form: px,py,p-,p+.
c... if iq > 0, a boost is performed to the cms fram; dbeta is output of 
c...             the beta factor used;
c...    iq = 0, a boost is done on dp with a known dbeta 
c...    iq < 0, a boost is done on dp with dbeta = -dbeta, i.e., inverse boost,
c...             here dbeta must be given as input.
c... so, for exemple,
c: ...  call frtocms(id, 1, dp, dbeta)    -- to the cms frame;
c: ...  call frtocms(id, -1, dp, dbeta)   -- back to the orginal frame.
c:
c: ...specially for |iq|=2, pj in frjets block and pr(nr0-nr)
c: ...in frcnut block are also bosted.
c: ...nr-nr0<1 is assumed.

c      implicit double precision (d)
      common/frcnut/nr,kr(10,5),pr(10,5),nr0
      include "Zfrjets.h"
      dimension dp(2,5),dbetao(3),dbeta(3),drv(4),dbp(mxfrjt)
      save /frcnut/,/frjets/
      
c..... beta_x, beta_y, beta_z
      dbet2 = 0.
      
      if(id.eq.0) then
      desum = (dp(1,4)+dp(2,4))
      dzsum = dp(1,3)+dp(2,3)
      else
      desum = (dp(1,4)+dp(1,3))/2.d0 +(dp(2,4)+dp(2,3))/2.d0
      dzsum = (dp(1,4)-dp(1,3))/2.d0 +(dp(2,4)-dp(2,3))/2.d0
      endif

      if(desum.le.0.) stop 'frcms: e less than 0'

      do 5 i = 1, 3
      if(iq.gt.0) then
       if(i.le.2) dbeta(i) = (dp(1,i)+dp(2,i))/desum
       if(i.eq.3) dbeta(i) = dzsum/desum
       dbetao(i) = dbeta(i)
      elseif(iq.lt.0) then
       dbeta(i) = - dbetao(i)
      elseif(iq.eq.0) then
       dbeta(i) = dbetao(i)
      endif
      dbet2 = dbet2 + dbeta(i)**2
5     continue

      if(dbet2.ge.1.d0) stop 'frcms: beta = 1'
      if(dbet2.lt.1.d-8) return
      dgama = 1.d0/dfrsqr(1.d0-dbet2, 'dga678')
      deff = dgama/(1.d0+dgama)


      k=0
9     k=k+1
      if(k.eq.1) then
      iup=2
      elseif(k.eq.2.or.k.eq.4) then
      iup=nj
      elseif(k.eq.3) then
         if(nr-nr0.ge.2) call frmgout(0,1,'check nr,nr0:',
     >                 dble(nr),dble(nr0),0.d0,0.d0,0.d0)
      iup=nr-nr0+1
      endif

      do 888 i = 1, iup
       if(k.eq.1) then
      drv(1) = dp(i,1)  
      drv(2) = dp(i,2)  
         if(id.eq.0) then
      drv(3) = dp(i,3)  
      drv(4) = dp(i,4)
         else     
      drv(3) = (dp(i,4)-dp(i,3))/2.d0
      drv(4) = (dp(i,4)+dp(i,3))/2.d0
         endif
      elseif(k.eq.2) then
       do 11 j=1,4
11     drv(j) = pj(i,j)
      elseif(k.eq.3) then
      ir = nr0+i-1
       do 12 j=1,4
12     drv(j) = pr(ir,j)
      endif

      dbp(i) = 0.
       do 30 j = 1, 3
30     dbp(i) = dbp(i) + dbeta(j)* drv(j)
       do 35 j = 1, 3
35     drv(j) = drv(j)+ (deff*dbp(i)-drv(4))*dgama*dbeta(j)
40    drv(4) = dgama* (drv(4)-dbp(i))

       if(k.eq.1) then
      dp(i,1) = drv(1)
      dp(i,2) = drv(2)
        if(id.eq.0) then
      dp(i,3) = drv(3)
      dp(i,4) = drv(4)
        else
      dp(i,4) = drv(4) + drv(3)
      dp(i,3) = drv(4) - drv(3)
        endif
      elseif(k.eq.2) then
      do 41 j=1,4
41    pj(i,j) = drv(j)
      elseif(k.eq.3) then
      do 42 j=1,4
42    pr(nr0+i-1,j) = drv(j)
       endif
888   continue

      if(abs(iq).eq.2.and.nj.gt.0.and.k.le.1) go to 9
      if(abs(iq).eq.2.and.nr-nr0.ge.0.and.k.le.2) go to 9
      
      return
      end

c********************************* end frtocms ************************

c********************************* frpolar ****************************

      subroutine frpolar(dthe,dphi,dp)
      implicit double precision (a-h,o-z)
      save

c....for a given pair of mementa dp(2,4), which are in light-cone form
c....and in their cms frame, this routine is to find the polar angel
c....(theta,phi) with which a follow up call to frrotar (rotation)
c....will make the pairwise momenta lie on the new z-axes.
c.......................................................................

c      implicit double precision (d)
      dimension dp(2,5)
c............................angles of the momentum vector ...............
      dthe = 0d0
      dphi = 0d0
      dbp3=.5d0*(dp(1,4)-dp(1,3))
      dxy=(dp(1,1)**2+dp(1,2)**2)
      dxyz = dxy + dbp3**2
      if(dxyz.eq.0.d0) return

      dcth=dbp3/dfrsqr(dxyz, 'dcthiowe')
      dcth=dmax1(-1.d0,dmin1(dcth,1.d0))
      dthe=dacos(dcth)
      if(dthe.eq.0.d0.or.dxy.eq.0d0) return
        dcph = dp(1,1)/dfrsqr(dxy, 'dxyeuw')
      dphi = dacos(dcph)
        if(dp(1,2).lt.0.d0) dphi = - dphi

      return
      end

c********************************* end frpolar ************************

c********************************* frrotar ****************************

       subroutine frrotar(dthe,dphi,iq,dp)
      implicit double precision (a-h,o-z)
      save

c...rotations
c:  the rotation means:
c:  if iq >0, the coordinates are first rotated dthe angle about
c:  y-axes and then an angle dphi around z-zxes. the effect is that
c:  a vector originally at (dthe,dphi) polar angle will be moved to
c:  the new z-axe.
c:  if iq <0, the coordinates are first rotated -dphi angle about
c:  z-axes and then an angle -dthe around y-zxes. 
c:  this is to counter the effect of a previous "iq>0" rotation.
c:  the moral is, if called twice like this,
c: ...  call frrotar(dthe,dphi,1,dp)
c: ...  call frrotar(dthe,dphi,-1,dp)
c:  we are back to the original frame and nothing is changed.
c:
c: ...specially for |iq|=2, pj,pji in frjets block and pr(nr0-nr)
c: ...in frcnut block are also rotated.

c      implicit double precision (d)
      common/frcnut/nr,kr(10,5),pr(10,5),nr0
      include "Zfrjets.h"

      common/dumyfrota/ dpv(4)            
      dimension dp(2,5)       
      save /frcnut/,/frjets/,/dumyfrota/

      if(dthe**2+dphi**2.lt.1d-20) return

      k=0
9     k=k+1
      if(k.eq.1) then
      iup=2
      elseif(k.eq.2.or.k.eq.4) then
      iup=nj
      elseif(k.eq.3) then
      iup=nr-nr0+1
      endif

        do 120 i=1,iup
        if(k.eq.1) then
          do 100 j=1,2
100     dpv(j) = dp(i,j)
          dpv(3)=.5d0*(dp(i,4)-dp(i,3))
          dpv(4) =.5d0*(dp(i,4)+ dp(i,3))
        elseif(k.eq.2) then
          do 101 j=1,4
101     dpv(j) = pj(i,j)
        elseif(k.eq.3) then
         if(nr-nr0.ge.2) call frmgout(0,1,'check here nr,nr0:',
     >           dble(nr),dble(nr0),0.d0,0.d0,0.d0)
          do 103 j=1,4
103     dpv(j) = pr(nr0+i-1,j)
       endif

       if(iq.gt.0) then
       call frrotaz(dphi,dpv) 
       call frrotay(dthe,dpv) 
       elseif(iq.lt.0) then
       call frrotay(-dthe,dpv)      
       call frrotaz(-dphi,dpv)
       endif

        if(k.eq.1) then
        dp(i,1) = dpv(1)      
        dp(i,2) = dpv(2)      
          dp(i,3)=dpv(4) - dpv(3)
          dp(i,4)=dpv(4) + dpv(3)
        elseif(k.eq.2) then
          do 111 j=1,4
111     pj(i,j) = dpv(j) 
        elseif(k.eq.3) then
          do 113 j=1,4
113     pr(nr0+i-1,j) = dpv(j) 
      endif

120     continue

      if(abs(iq).eq.2.and.nj.gt.0.and.k.le.1) go to 9
      if(abs(iq).eq.2.and.nr-nr0.ge.0.and.k.le.2) go to 9

      return
      end

c********************************* end frrotar ************************

c********************************* frrotay ****************************

      subroutine frrotay(dthe, dpv)
      implicit double precision (a-h,o-z)
      save

c:  rotate coordinates around y-axis by an angle dthe
c:  dpv(3) gives the space components of a vector.

c      implicit double precision (d)
      dimension dpv(4)
      if(dthe**2.lt.1d-20) return

      dpvx=dpv(1)*dcos(dthe)-dpv(3)*dsin(dthe)
      dpvy = dpv(2)
      dpvz=dpv(1)*dsin(dthe)+dpv(3)*dcos(dthe)
      
      dpv(1) = dpvx
      dpv(2) = dpvy
      dpv(3) = dpvz

      return
      end

c********************************* end frrotay ************************

c********************************* frrotaz ****************************

      subroutine frrotaz(dphi, dpv)
      implicit double precision (a-h,o-z)
      save

c:  rotate coordinates around z-axes by an angle dphi
c:  dpv(3) gives the space components of a vector.

c      implicit double precision (d)
      dimension dpv(4)
      if(dphi**2.lt.1d-20) return

      dpvx=dpv(1)*dcos(dphi)+dpv(2)*dsin(dphi)
      dpvz = dpv(3)
      dpvy=-dpv(1)*dsin(dphi)+dpv(2)*dcos(dphi)
      
      dpv(1) = dpvx
      dpv(2) = dpvy
      dpv(3) = dpvz

      return
      end

c********************************* end frrotaz ************************

c********************************* frboot1 ****************************

      subroutine frboot1(id,dpv,dbeta)
      implicit double precision (a-h,o-z)
      save

c... to boost an single momenta by a dbeta(3) factor.
c... id =0, dpv(1-4)=p_x, p_y, p_z, e;
c... id =1, dpv(1-4)=p_x, p_y, p_, p+

c      implicit double precision (d)
      dimension dbeta(3), dpv(4), drv(4)

      dbet2 = 0.d0
      do 10 j = 1, 3
10    dbet2 = dbet2 + dbeta(j)**2
      if(dbet2.lt.1.d-10) return
      if(dbet2.gt.1.d0) then
      call frmgout(0,1,' frboot1: check beta > 1',
     >    real(dbeta(1)),real(dbeta(2)),real(dbeta(3)),real(dbet2),0.)
      endif
      dbet = dsqrt(dbet2)

        if(dbet.gt.0.99999999d0) then
      do 13 j=1, 3
13    dbeta(j) = dbeta(j)* 0.99999999d0/dbet
        dbet=0.99999999d0
      dbet2 = dbet**2
        endif

      dgama = 1.d0/dfrsqr(1.d0-dbet2, 'uiop09')
        deff = dgama/(1.d0+dgama)

      drv(1) = dpv(1)   
      drv(2) = dpv(2)   
      if(id.eq.0) then
      drv(3) = dpv(3)   
      drv(4) = dpv(4)   
      else  
      drv(3) = (dpv(4) - dpv(3))/2d0      
      drv(4) = (dpv(4) + dpv(3))/2d0      
      endif

       dbp = 0.
       do 25 i = 1, 3
25     dbp = dbp + dbeta(i)* drv(i)

c..........................................boost..............
      do 30 j = 1, 3
  30    drv(j) = drv(j) +(deff*dbp -drv(4))*dgama*dbeta(j)
      drv(4) = dgama* (drv(4)-dbp)

      dpv(1) = drv(1)   
      dpv(2) = drv(2)   
      if(id.eq.0) then
      dpv(3) = drv(3)   
      dpv(4) = drv(4)   
      else  
      dpv(3) = (drv(4) - drv(3))    
      dpv(4) = (drv(4) + drv(3))    
      endif


      return
      end

c********************************* end frboot1 ************************


c********************************* frmgout *****************************

      subroutine frmgout(id,ilist,mesg,a,b,c,d,e)
      implicit double precision (a-h,o-z)
      save

c...for general message print out ....................................
c...id:  -50 - 50  id number for the error:
c.....   if id=0, the execution will be stopped upon mesg printout;
c.....   if id>0, the execution will continue but the mesg printout
c.....     is limited to nterm times;
c.....   if id<0, the execution will continue with the mesg printout
c......     but execution stops if it repeats nterm times.
c......a,b,c,d,e some variables to be printed out for inspection,
c.........          however, the will not be printed if they are all 0.
c...ilist=1: a full list including fr-status, event list, hard parton list
c........          is given.  
c........      =0: full list suppressed.
c..
c...mgo(1) - energy nonconservation in frringo;
c...mgo(2) - energy nonconservation in frppart;


      parameter (ksz1=20)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      include "Zfrjets.h"

      common/frmgov/mgo(-5:10)

      character *(*) mesg

      save /frintn0/,/ludat1/,/frjets/,/frmgov/
      data nterm/10/

   2  format(2x, a,3x,'error id=',i3,1x,'count=',i3, /)

      mgo(id) = mgo(id)+1
      if(mgo(id).le.nterm) iop(16)=1
      if(id.gt.0.and.mgo(id).gt.nterm) return

      iqab = 1
      if(abs(a)+abs(b)+abs(c)+abs(d)+abs(e).eq.0.) then
      iqab = -1
      endif
      write(mstu(11),10) nfr(1), iop(1)

      write(mstu(11),2) mesg, id, mgo(id)

      if(iqab.gt.0) write(mstu(11),*) a,b,c,d,e

      call frvalue(0)

      if(ilist.eq.1) then
      call lulist(2)
      if(nj.gt.0) call frhplis
      endif
 
      write(mstu(11),20)

      if(id.eq.0.or.(id.lt.0.and.mgo(id).ge.nterm)) then
      write(mstu(11),*) ' severe! execution stopped by frmgout'
      stop 'frmgout:'
      endif

10    format(/72('*') /72('?')/,' possibly an error! at event no. ',i7,
     > 3x,'subcollision ',i4)
20    format(72('|')/72('*'),/)

      return
      end

c********************************* end frmgout *************************

c********************************* frdoict *******************************

c.... to manage counting ......................................
c.... 1 is added to ict(i) if the argument is > 0.
c.... the record in ict is cleared if i <= -1; and
c.... (this routine is not listed in the manual)

      subroutine frdoict(i)
      implicit double precision (a-h,o-z)
      save

      common/frcont2/ict(10),ictt(10)
      save /frcont2/
      
      if(i.le.-1) then
      do 10 l=1, 10
10    ict(l) = 0
      return
      endif
      
      if(i.gt.0) then
      ict(i) = ict(i) + 1
      ictt(i) = ictt(i) + 1
      endif

      return
      end

c********************************* end frdoict ***************************
     
c******************************** auxilliary routines *******************

      real*8 function frsqr( x, message )
       implicit double precision (a-h, o-z)
       save
c....optional character 'message' helps to identify the source of error.
c....allow a little numerical error margin...

      character*(*) message
      iflag = 0
      if(x.lt.-0.001) then
      iflag = 1
      write(6,*) x, ' --sqrt-negative value '
      write(6,100) message
100   format( a )
      stop 'frsqr: `neg-root'''
      endif
      frsqr = sqrt(max(x,0.d0))
      return
      end

      double precision function dfrsqr( dx, message )
       implicit double precision (a-h, o-z)
       save
c      implicit double precision (d)
      character*(*) message
      iflag = 0
      if(dx.lt.-0.001d0) then
      iflag = 1
      write(6,*) dx, ' --sqrt-negative value '
      write(6,100) message
100   format( a )
      stop 'dfrsqr: `neg-d_root'''
      endif
      dfrsqr = dsqrt(dmax1(dx,0.d0))
      return
      end

c..........................................................

      real*8 function frrex(x)
      implicit double precision (a-h,o-z)
      save

c.......to take care the over_under_flow problem in large exponentials

      arg = min(abs(x), 80.0d0)
      if(x.lt.0.) arg = -arg

      frrex = exp(arg)

      return
      end



c********************************* frupcas ***************************

      subroutine frupcas(str)
      implicit double precision (a-h,o-z)
      save

c.... convert a string character (length<20) into upper case one
c.... str must not contain more than 3 spaces between the characters.

      character str*(*),chalp(2)*26,str0*23
      data chalp/'abcdefghijklmnopqrstuvwxyz',
     &'abcdefghijklmnopqrstuvwxyz'/

      i=0
      iph=0
      str0 = str
10    i=i+1
      if(str0(i:i).eq.' ') iph=iph+1
      if(iph.gt.3) goto 30
      if (str0(i:i) .ge. 'a'  .and.  str0(i:i) .le. 'z')  then
cc          str(i:i) = char(ichar(str(i:i)) - '20'x)
      do 20 j=1,26
20      if(str(i:i).eq.chalp(1)(j:j)) str(i:i)= chalp(2)(j:j)
      endif
      goto 10

30    return
      end

c********************************* end frupcas ***********************

c********************************* frloopu ***************************

      subroutine frloopu(*,i,imax,message)
      implicit double precision (a-h,o-z)
      save

c....handle loops to avoid infinite loop.  
c....i=loop index;  imax=maximum number of looping;
c....message = character code to mark the loop.

      parameter (ksz1=20)
      character*(*) message
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      save /ludat1/,/frintn0/

      if(i.le.imax) then
      return 1            
      else
      write(mstu(11),110) nfr(1),iop(1),message
      return
      endif

110   format(/,15('?'),2x,'event-subcollision number:',i6,'_',i4,
     >      10('?')/,4x,'loop aborted at ', a,/)

      end

c***************************** end frloopu ***************************
       
c*************************** frvalue *********************************

c...to output the values of fritiof parameters ...................
c... if iq=0, the output is written on mstu(11);
c... if iq>0, it will writes on an aux file named 'oxchk', which
c... is refreshed at an interval of every inum events.
c... if iq<0, as in iq>0 but "execution completed" will also be printed.

      subroutine frvalue(iq)
      implicit double precision (a-h,o-z)
      save
      parameter (ksz1=20)
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
      common/frcont2/ict(10),ictt(10)
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/frmgov/mgo(-5:10)

      save ico
      save /frpara1/,/frintn0/,/frcont2/,/ludat1/,/frmgov/
      data ico,inum /0,20/

      if(iq.eq.0) then
      ifile = mstu(11)
      else
      ico = ico + 1
      ifile = 111
       if(ico.eq.1) then
       open(ifile,file='oxchk',status='unknown')
       elseif(mod(ico,inum).eq.1) then 
       open(ifile,file='oxchk',status='old')
       endif
      endif
      
      write(ifile,100) 
100      format(/,79('='),/2x,'fritiof status report',/)
      
      write(ifile,106) 
      write(ifile,166)(kfr(l),l=1,15),(vfr(l),l=1,15),(iop(l),l=1,15) 

      write(ifile,103)(nfr(l),l=1,10),(ict(l),l=1,10),(ictt(l),l=1,10) 
103   format(79('-'),/,
     >   4x,7x,'1|',6x,'2|',6x,'3|',6x,'4|',6x,'5|',5x,'6|',5x,'7|',
     >     5x,'8|',5x,'9|',4x,'10|',/,79('-'),/,
     >   1x,'nfr',5i8,5i7,/,
     >   1x,'ict',5i8,5i7,/,'ictt',5i8,5i7,/,79('-'),/ )

          ratio1 = 0.
          ratio2 = 0.
          if(nfr(3).gt.0) ratio1 = dble(nfr(4))/dble(nfr(3))
          if(nfr(1).gt.0) ratio2 = dble(nfr(5))/dble(nfr(1))

      write(ifile,*)' percent of collisions having hard scattering: ',
     >     ratio1
      write(ifile,*)' percent of events having hard scattering: ',
     >     ratio2

      if(mgo(1).gt.0) write(ifile, 171) mgo(1) 
      if(mgo(2).gt.0) write(ifile, 172) mgo(2) 

cc      call datecpu(ifile)
 
      if(iq.lt.0) write(ifile, *) ' &&& execution completes &&&&'

        if(iq.ne.0.and.mod(ico,inum).eq.0) close(ifile)

106      format(20x,'kfr(l), vfr(l), iop(l)  ',30x,/,78('-') )
166      format(
     >   7x,'1|',3x,'2|',3x,'3|',3x,'4|',3x,'5|',3x,'6|',3x,'7|',
     >     3x,'8|',3x,'9|',2x,'10|',2x,'11|',2x,'12|',2x,'13|',
     >     2x,'14|',2x,'15|',/,78('-'),/,
     >   'kfr', 15i5,/,'vfr', 15f5.2,/,'iop', 15i5,/,78('-'),/ )

171   format(/,2x,'no. of errors - energy nonconserv. in frringo:',i6)
172   format(/,2x,'no. of errors - energy nonconserv. in frppart:',i6,/)

      return
      end

c***************************** end frvalue *****************************

c***********************************************************************
c..............subroutines originally from pythia.......................
c... modified slightly for fritiof to accomodate some changes in the way
c... meson-nucleon cross sections are handled.  
c.......................................................................

      subroutine frpyini(frame,beam,target,win)
      implicit double precision (a-h,o-z)
      save

c...this routine is identical to pythia's pyinitC except the routine
c...for xsections pyxtotC is replaced.

c...initializes the generation procedure; finds maxima of the
c...differential cross-sections to be used for weighting.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/ludat2/kchg(500,3),pmas(500,4),parf(2000),vckm(4,4)
      common/ludat3/mdcy(500,3),mdme(2000,2),brat(2000),kfdp(2000,5)
      common/ludat4/chaf(500)
      character chaf*8
      common/pysubsC/msel,msub(200),kfin(2,-40:40),ckin(200)
      common/pyparsC/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1C/mint(400),vint(400)
      common/pyint2C/iset(200),kfpr(200,2),coef(200,20),icol(40,4,2)
      common/pyint5C/ngen(0:200,3),xsec(0:200,3)
      save /ludat1/,/ludat2/,/ludat3/,/ludat4/
      save /pysubsC/,/pyparsC/,/pyint1C/,/pyint2C/,/pyint5C/
      dimension alamin(20),nfin(20)
      character*(*) frame,beam,target
      character chfram*8,chbeam*8,chtarg*8,chmo(12)*3,chlh(2)*6
      data alamin/0.20,0.29,0.20,0.40,0.187,0.212,0.191,0.155,
     &0.22,0.16,0.16,0.26,0.36,7*0.2/,nfin/20*4/
      data chmo/'jan','feb','mar','apr','may','jun','jul','aug','sep',
     &'oct','nov','dec'/, chlh/'lepton','hadron'/

cc    call pydataC    

c...reset mint and vint arrays. write headers.
      do 100 j=1,400
      mint(j)=0
  100 vint(j)=0.
      if(mstp(127).ge.1) write(mstu(11),5000) mstp(181),mstp(182),
     &mstp(185),chmo(mstp(184)),mstp(183)
      mstp(127)=0
      if(mstu(12).ge.1) call lulist(0)
      if(mstp(122).ge.1) write(mstu(11),5100)

c...identify beam and target particles and initialize kinematics.
      chfram=frame//' '
      chbeam=beam//' '
      chtarg=target//' '
      call pyinkiC(chfram,chbeam,chtarg,win)
      if(mint(65).eq.1) goto 160

c...select partonic subprocesses to be included in the simulation.
      if(msel.ne.0) then
        do 110 i=1,200
  110   msub(i)=0
      endif
      if(mint(43).eq.1.and.(msel.eq.1.or.msel.eq.2)) then
c...lepton+lepton -> gamma/z0 or w.
        if(mint(11)+mint(12).eq.0) msub(1)=1
        if(mint(11)+mint(12).ne.0) msub(2)=1
      elseif(mint(43).le.3.and.(msel.eq.1.or.msel.eq.2)) then
c...lepton+hadron: deep inelastic scattering.
        msub(11)=1
      elseif(msel.eq.1) then
c...high-pt qcd processes:
        msub(11)=1
        msub(12)=1
        msub(13)=1
        msub(28)=1
        msub(53)=1
        msub(68)=1
        if(mstp(82).le.1.and.ckin(3).lt.parp(81)) msub(95)=1
        if(mstp(82).ge.2.and.ckin(3).lt.parp(82)) msub(95)=1
      elseif(msel.eq.2) then
c...all qcd processes:
        msub(11)=1
        msub(12)=1
        msub(13)=1
        msub(28)=1
        msub(53)=1
        msub(68)=1
        msub(91)=1
        msub(92)=1
        msub(93)=1
        msub(95)=1
      elseif(msel.ge.4.and.msel.le.8) then
c...heavy quark production.
        msub(81)=1
        msub(82)=1
        msub(84)=1
        do 120 j=1,min(8,mdcy(21,3))
  120   mdme(mdcy(21,2)+j-1,1)=0
        mdme(mdcy(21,2)+msel-1,1)=1
        msub(85)=1
        do 130 j=1,min(8,mdcy(22,3))
  130   mdme(mdcy(22,2)+j-1,1)=0
        mdme(mdcy(22,2)+msel-1,1)=1
      elseif(msel.eq.10) then
c...prompt photon production:
        msub(14)=1
        msub(18)=1
        msub(29)=1
      elseif(msel.eq.11) then
c...z0/gamma* production:
        msub(1)=1
      elseif(msel.eq.12) then
c...w+/- production:
        msub(2)=1
      elseif(msel.eq.13) then
c...z0 + jet:
        msub(15)=1
        msub(30)=1
      elseif(msel.eq.14) then
c...w+/- + jet:
        msub(16)=1
        msub(31)=1
      elseif(msel.eq.15) then
c...z0 & w+/- pair production:
        msub(19)=1
        msub(20)=1
        msub(22)=1
        msub(23)=1
        msub(25)=1
      elseif(msel.eq.16) then
c...h0 production:
        msub(3)=1
        msub(102)=1
        msub(103)=1
        msub(123)=1
        msub(124)=1
      elseif(msel.eq.17) then
c...h0 & z0 or w+/- pair production:
        msub(24)=1
        msub(26)=1
      elseif(msel.eq.18) then
c...h0 production; interesting processes in e+e-.
        msub(24)=1
        msub(103)=1
        msub(123)=1
        msub(124)=1
      elseif(msel.eq.19) then
c...h0, h'0 and a0 production; interesting processes in e+e-.
        msub(24)=1
        msub(103)=1
        msub(123)=1
        msub(124)=1
        msub(153)=1
        msub(171)=1
        msub(173)=1
        msub(174)=1
        msub(158)=1
        msub(176)=1
        msub(178)=1
        msub(179)=1
      elseif(msel.eq.21) then
c...z'0 production:
        msub(141)=1
      elseif(msel.eq.22) then
c...w'+/- production:
        msub(142)=1
      elseif(msel.eq.23) then
c...h+/- production:
        msub(143)=1
      elseif(msel.eq.24) then
c...r production:
        msub(144)=1
      elseif(msel.eq.25) then
c...lq (leptoquark) production.
        msub(145)=1
        msub(162)=1
        msub(163)=1
        msub(164)=1
      elseif(msel.ge.35.and.msel.le.38) then
c...production of one heavy quark (w exchange):
        msub(83)=1
        do 140 j=1,min(8,mdcy(21,3))
  140   mdme(mdcy(21,2)+j-1,1)=0
        mdme(mdcy(21,2)+msel-31,1)=1
      endif

c...count number of subprocesses on.
      mint(48)=0
      do 150 isub=1,200
      if(mint(44).lt.4.and.isub.ge.91.and.isub.le.96.and.
     &msub(isub).eq.1) then
        write(mstu(11),5200) isub,chlh(mint(41)),chlh(mint(42))
        stop
      elseif(msub(isub).eq.1.and.iset(isub).eq.-1) then
        write(mstu(11),5300) isub
        stop
      elseif(msub(isub).eq.1.and.iset(isub).le.-2) then
        write(mstu(11),5400) isub
        stop
      elseif(msub(isub).eq.1) then
        mint(48)=mint(48)+1
      endif
  150 continue
      if(mint(48).eq.0) then
        write(mstu(11),5500)
        stop
      endif
      mint(49)=mint(48)-msub(91)-msub(92)-msub(93)-msub(94)

c...maximum 4 generations; set maximum number of allowed flavours.
  160 mstp(1)=min(4,mstp(1))
      mstu(114)=min(mstu(114),2*mstp(1))
      mstp(54)=min(mstp(54),2*mstp(1))

c...sum up cabibbo-kobayashi-maskawa factors for each quark/lepton.
      do 180 i=-20,20
      vint(180+i)=0.
      ia=iabs(i)
      if(ia.ge.1.and.ia.le.2*mstp(1)) then
        do 170 j=1,mstp(1)
        ib=2*j-1+mod(ia,2)
        ipm=(5-isign(1,i))/2
        idc=j+mdcy(ia,2)+2
  170   if(mdme(idc,1).eq.1.or.mdme(idc,1).eq.ipm) vint(180+i)=
     &  vint(180+i)+vckm((ia+1)/2,(ib+1)/2)
      elseif(ia.ge.11.and.ia.le.10+2*mstp(1)) then
        vint(180+i)=1.
      endif
  180 continue

c...choose lambda value to use in alpha-strong.
      mstu(111)=mstp(2)
      if(mstp(3).ge.1) then
        alam=parp(1)
        if(mstp(51).ge.1.and.mstp(51).le.13) alam=alamin(mstp(51))
        parp(1)=alam
        parp(61)=alam
        paru(112)=alam
        parj(81)=alam
        if(mstp(51).ge.1.and.mstp(51).le.13) mstu(112)=nfin(mstp(51))
      endif

c...initialize widths and partial widths for resonances.
      call pyinreC
      if(mint(65).eq.1) goto 200

c...reset variables for cross-section calculation.
      do 190 i=0,200
      do 190 j=1,3
      ngen(i,j)=0
  190 xsec(i,j)=0.

c...find parametrized total cross-sections.
      if(mint(44).eq.4) call frpyxto

c...maxima of differential cross-sections.
      if(mstp(121).le.1) call pymaxiC

c...initialize possibility of pileup events.
      if(mstp(131).ne.0) call pypileC(1)

c...initialize multiple interactions with variable impact parameter.
      if(mint(44).eq.4.and.(mint(49).ne.0.or.mstp(131).ne.0).and.
     &mstp(82).ge.2) call pymultC(1)
  200 if(mstp(122).ge.1) write(mstu(11),5600)

c...formats for initialization information.
 5000 format(///20x,'the lund monte carlo - pythia version ',i1,'.',i1/
     &20x,'**  last date of change:  ',i2,1x,a3,1x,i4,'  **'/)
 5100 format('1',18('*'),1x,'pyinitC: initialization of pythia ',
     &'routines',1x,17('*'))
 5200 format(1x,'error: process number ',i3,' not meaningful for ',a6,
     &'-',a6,' interactions.'/1x,'execution stopped!')
 5300 format(1x,'error: requested subprocess',i4,' not implemented.'/
     &1x,'execution stopped!')
 5400 format(1x,'error: requested subprocess',i4,' not existing.'/
     &1x,'execution stopped!')
 5500 format(1x,'error: no subprocess switched on.'/
     &1x,'execution stopped.')
 5600 format(/1x,22('*'),1x,'pyinitC: initialization completed',1x,
     &22('*'))

      return
      end
c*********************************************************************

      subroutine frpyxto
      implicit double precision (a-h,o-z)
      save

c...this routine is borrowed from pythia's pyxtotC.  modifications:
c... the block and cahn fit no.2 for slope parameters are changed according
c    to their paper in physics simulations at high energy  
c    (edited by v.barger,etc), which gives better fit.
c...  mstu(31)=6: block-cahn fit 8 for total xsection, and fit 1 for slope;
c...  the pion scaling factor is slightly modified to better accomodate
c...  the low energy data.  
c...  kaons added.
c
c...parametrizes total, double diffractive, single diffractive and
c...elastic cross-sections for different energies and beams.
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)
      common/pyparsC/mstp(200),parp(200),msti(200),pari(200)
      common/pyint1C/mint(400),vint(400)
      common/pyint5C/ngen(0:200,3),xsec(0:200,3)

      common/frtopyxto/kf0(2)

      save /ludat1/,/pyparsC/,/pyint1C/,/pyint5C/,/frtopyxto/
      dimension bcs(5,8),bcb(2,5),bcc(3),scale(2)

c...the following data lines are coefficients needed in the
c...block, cahn parametrization of total cross-section and nuclear
c...slope parameter; see below.
      data ((bcs(i,j),j=1,8),i=1,5)/
     1 41.74, 0.66, 0.0000, 337.,  0.0, 0.0, -39.3, 0.48,
     2 41.66, 0.60, 0.0000, 306.,  0.0, 0.0, -34.6, 0.51,
     3 41.36, 0.63, 0.0000, 299.,  7.3, 0.5, -40.4, 0.47,
     4 41.68, 0.63, 0.0083, 330.,  0.0, 0.0, -39.0, 0.48,
     5 41.13, 0.59, 0.0074, 278., 10.5, 0.5, -41.2, 0.46/
      data ((bcb(i,j),j=1,5),i=1,2)/
     1 10.79, -0.049, 0.040, 21.5, 1.23,
     2  9.92, 0.27, 0.013, 18.9, 1.93/
cc   2  9.92, -0.027, 0.013, 18.9, 1.07/
      data bcc/2.0164346,-0.5590311,0.0376279/

c...total cross-section and nuclear slope parameter for pp and p-pbar
      nfit=min(5,max(1,mstp(31)))
      sigp=bcs(nfit,1)+bcs(nfit,2)*(-0.25*paru(1)**2*
     &(1.-0.25*bcs(nfit,3)*paru(1)**2)+(1.+0.5*bcs(nfit,3)*paru(1)**2)*
     &(log(vint(2)/bcs(nfit,4)))**2+bcs(nfit,3)*
     &(log(vint(2)/bcs(nfit,4)))**4)/
     &((1.-0.25*bcs(nfit,3)*paru(1)**2)**2+2.*bcs(nfit,3)*
     &(1.+0.25*bcs(nfit,3)*paru(1)**2)*(log(vint(2)/bcs(nfit,4)))**2+
     &bcs(nfit,3)**2*(log(vint(2)/bcs(nfit,4)))**4)+bcs(nfit,5)*
     &vint(2)**(bcs(nfit,6)-1.)*sin(0.5*paru(1)*bcs(nfit,6))
      sigm=-bcs(nfit,7)*vint(2)**(bcs(nfit,8)-1.)*
     &cos(0.5*paru(1)*bcs(nfit,8))
      refp=bcs(nfit,2)*paru(1)*log(vint(2)/bcs(nfit,4))/
     &((1.-0.25*bcs(nfit,3)*paru(1)**2)**2+2.*bcs(nfit,3)*
     &(1.+0.25*bcs(nfit,3)*paru(1)**2)+(log(vint(2)/bcs(nfit,4)))**2+
     &bcs(nfit,3)**2*(log(vint(2)/bcs(nfit,4)))**4)-bcs(nfit,5)*
     &vint(2)**(bcs(nfit,6)-1.)*cos(0.5*paru(1)*bcs(nfit,6))
      refm=-bcs(nfit,7)*vint(2)**(bcs(nfit,8)-1.)*
     &sin(0.5*paru(1)*bcs(nfit,8))
      sigma=sigp-isign(1,mint(11)*mint(12))*sigm
      rho=(refp-isign(1,mint(11)*mint(12))*refm)/sigma

c...nuclear slope parameter b, curvature c:
      nfit=1
      if(mstp(31).ge.4.and.mstp(31).le.5) nfit=2
      bp=bcb(nfit,1)+bcb(nfit,2)*log(vint(2))+
     &bcb(nfit,3)*(log(vint(2)))**2
      bm=bcb(nfit,4)+bcb(nfit,5)*log(vint(2))
      b=bp-isign(1,mint(11)*mint(12))*sigm/sigp*(bm-bp)
      vint(121)=b
      c=
     & -0.5*bcc(2)/bcc(3)*(1.-sqrt(max(0.d0,1.+4.*bcc(3)/bcc(2)**2*
     &(1.e-03*vint(1)-bcc(1)))))
      vint(122)=c

c...elastic scattering cross-section (fixed by sigma-tot, rho and b).
      sigel=sigma**2*(1.+rho**2)/(16.*paru(1)*paru(5)*b)

c...single diffractive scattering cross-section from goulianos:
      sigsd=2.*0.68*(1.+36./vint(2))*log(0.6+0.1*vint(2))

c...double diffractive scattering cross-section (essentially fixed by
c...sigma-sd and sigma-el).
      sigdd=sigsd**2/(3.*sigel)

c...total non-elastic, non-diffractive cross-section.
      signd=sigma-sigdd-sigsd-sigel

c...rescale for mesons.
      scalpi = (2./3.-1.13/vint(1))            
      scalk = (2./3.-3.27/vint(1))            

      do 110 lo = 1, 2
      if(iabs(kf0(lo)).eq.321) then      
      scale(lo) = scalk
      elseif(iabs(kf0(lo)).le.999) then            
      scale(lo) = scalpi
      else                        
      scale(lo) = 1.0
      endif
110   continue

        sigma=sigma *scale(1)*scale(2)
        sigdd=sigdd *scale(1)*scale(2)
        sigsd=sigsd *scale(1)*scale(2)
        sigel=sigel *scale(1)*scale(2)
        signd=signd *scale(1)*scale(2)

c...save cross-sections in common block pypara.
      vint(101)=sigma
      vint(102)=sigel
      vint(103)=sigsd
      vint(104)=sigdd
      vint(106)=signd
      xsec(95,1)=signd

      return
      end

c*********************************************************************
c********************************************************************

	subroutine frchkep(iq)
      implicit double precision (a-h,o-z)
      save

c... check the total charge, energy, momentum conservation
c... iq=0: just check the sums and take no further steps
c...   =1: monitor the number of errors and signal (iop(16)) for printout
c...       via frmgout.  

      parameter (ksz1=20, ksz2=300)
      common/frintn0/pli0(2,4),aop(ksz1),iop(ksz1),nfr(ksz1)
       include "Zlujets.h"
      common/ludat1/mstu(200),paru(200),mstj(200),parj(200)

      data ifst /0/
      save etot, ptot, cgtot
      save /frintn0/,/lujets/,/ludat1/
 
	if(ifst.eq.0) then
c  total beam energy, momentum:
	ebm = 0.5*(pli0(1,4)+pli0(1,3))* iop(3)
	pbm = 0.5*(pli0(1,4)-pli0(1,3))* iop(3)
c  total target energy, momentum:
	etg = 0.5*(pli0(2,4)+pli0(2,3))* iop(5)
	ptg = 0.5*(pli0(2,4)-pli0(2,3))* iop(5)

	etot = ebm + etg
	ptot = pbm + ptg
	cgtot = iop(4)+ iop(6)
	ifst=1
	endif

	charg =0.0
	ee=0.0
	ppz=0.0
	ppx=0.0
	ppy=0.0
	do 100 j=1, n
	if(abs(k(j,2)).ge.10000) then
	  charg = charg+ abs(k(j,2))-10000
	  ee = ee+ p(j,4)
	  ppz = ppz+ p(j,3)	   
	  ppy = ppy+ p(j,2)	   
	  ppx = ppx+ p(j,1)
	elseif(k(j,1).ge.1.and.k(j,1).le.5) then
	  charg = charg+ plu(j,6)
	  ee = ee+ p(j,4)
	  ppz = ppz+ p(j,3)	   
	  ppy = ppy+ p(j,2)	   
	  ppx = ppx+ p(j,1)
	endif
100	continue

	ifel=0
	if(abs(ppx).gt.0.5.or.abs(ppy).gt.0.5) ifel =1
	if(abs(ppz-ptot).gt.max(0.01*ptot,0.5d0)) ifel =1
	if(abs(ee-etot).gt.max(0.01*etot,0.5d0)) ifel =1
	if(abs(charg-cgtot).gt.0.01) ifel =1
	
	if(ifel.eq.1) then
	write(mstu(11), 1000)  nfr(1) 
        if(iq.eq.1) 
     >     call frmgout(-1,0,'charge or energy non-conservation',
     >                   0.d0,0.d0,0.d0,0.d0,0.d0)
	write(mstu(11), 1010) ptot, etot, cgtot
	write(mstu(11), 1020) ppx,ppy, ppz, ee, charg
	endif

1000	format( /,'???????????????????????????????????????????'
     >      /,'  charge or energy non-conservation at event:', i6 )
1010	format('  original pz, e, charge: ', 26x, 2e13.4, f6.1)
1020	format(' total px, py, pz, e, cg: ', 4e13.4, f6.1 )
	return
	end	

c*********************************************************************

c*********************************************************************
c********************************* data frdata ***********************

      block data frdata
      implicit double precision (a-h, o-z)


      parameter (ksz1=20)
      character*4 pacd
      common/frpara1/kfr(ksz1),vfr(ksz1)
      common/frcodes/ipt(2),pacd(27),nnuc(27),nprot(27),kcd(27)
     >           ,ro1(27,2),exma(9,2)
      save /frpara1/,/frcodes/

      data kfr/1,1,0,1,0, 2,1,1,1,1, 4,2,0,0,0, 5*0/

      data vfr/0.,0.2,0.8,0.2,0.1, 0.01,0.30,.75,.75,0., 
     >         0.,1.0,0.167,.333,.5, .5,4*0./

c.....the following are particles in store.  in particulare ro1 are the
c.....parameters for nuclei density.  for a<,=16, shell model harmonic
c.....oscilator density, ro1(j,1) gives the nuclear root-mean-square-
c.....(charge) radius.  for a>16 ro1(j,2) gives the two parameters r0 and c
c.....to the wood-saxon density.  
c.....exma(j,1) and exma(j,2) correspond to the "minimum excitation mass"
c.....and "diffractive mass" respectively.
 
      data pacd/'new1','new2','pi+ ','pi- ','k+  ','k-  ','n   ','p   '
     >         ,'pbar','d   ','he  ','be  ','b   ','c   ','o   ','al  '
     >         ,'si  ','s   ','ar  ','ca  ','cu  ','ag  ','xe  ','w   '
     >         ,'au  ','pb  ','u   '/
      data nnuc/  1,     1,     1,     1,     1,     1,     1,     1,     
     >            1,     2,     4,     9,    11,    12,    16,    27,    
     >           28,    32,    40,    40,    64,   108,   131,   184,   
     >          197,   207,   238/
      data nprot/ 0,    0,      1,    -1,     1,    -1,     0,     1,     
     >           -1,    1,      2,     4,     5,     6,     8,    13,    
     >           14,   16,     18,    20,    29,    47,    54,    74, 
     >           79,    82,    92 /
      data kcd /  0,    0,    211,  -211,   321,   -321, 2112,  2212,  
     >        -2212,  18*0 /

c.....source for ro1: ro(j,1) for a<17 is from ref. bj; and ro(j,1-2) for
c.....a>17 are taken from fritiof 6.0, where ro(j,1)=r0=1.16*(1.-1.16/a**(2/3)):

      data ro1 / 0.,    0.,    0.,    0.,     0.,    0.,    0.,    0.,   
     1           0., 2.095,  1.74, 2.519,  2.37, 2.446, 2.724,   1.01,  
     1        1.014, 1.027, 1.045, 1.045, 1.076, 1.101, 1.108,  1.118,  
     1        1.120, 1.122, 1.125,     
     2           0.,    0.,    0.,    0.,     0.,    0.,    0.,    0., 
     2           0.,    0.,    0.,    0.,     0.,    0.,    0., 0.478, 
     2        0.480, 0.490, 0.490, 0.490,  0.490, 0.495,  0.52, 0.530, 
     2        0.540, 0.545,  0.55 / 

c.....ro1 follows are taken from experimental measurements from ref. bj,
c.....and some unfound in the book are hand-picked. not going to be used.
c
c      data ro1 / 0.,    0.,    0.,    0.,     0.,    0.,    0.,    0.,   
c     1           0., 2.095,  1.74, 2.519,  2.37, 2.446, 2.724,  0.947,  
c     1        1.035, 1.016,  1.00, 1.023, 1.068, 1.119, 1.114,  1.116,  
c     1        1.109, 1.121, 1.123,     
c     2           0.,    0.,    0.,    0.,     0.,    0.,    0.,    0., 
c     2           0.,    0.,    0.,    0.,     0.,    0.,    0., 0.569, 
c     2        0.537, 0.540, 0.543,  0.55,  0.579, 0.523,  0.52, 0.525, 
c     2        0.535, 0.535,  0.55 / 

      data exma/0.00,  0.00,   0.14,   0.14,  0.50,  0.50,  0.94,  0.94,
     1          0.94,
     2          0.00,  0.00,   0.40,   0.40,  0.75,  0.75,  1.20,  1.20,
     2          1.20 /

c.....reference. bj:  r.c. barrett and d.f.jackson,
c.....nuclear sizes and structure. however ca, s, ar, xe, w can not be found
c.....in the book.

      end


cc****************************** end frdata ***********************

c******************************************************************
c...........main switches and parameters...........................

c\item[kfr(1)] (d=1) fragmentation
c       \item[=0] off.
c       \item[=1] on.   
c\item[kfr(2)] (d=1) multiple gluon emission (dipole radiation) 
c       \item[=0] off.
c       \item[=1] on.
c\item[kfr(3)] (d=0) event selection for collisions with a nucleus 
c       \item[=0] generate minimum bias events (all interactions recorded).
c       \item[=1] generate only events with all projectile nucleons
c                  participated.
c       \item[=2] generate only events with impact parameter between
c                  $b_{min}$=vfr(1) and $b_{max}$=vfr(2).
c       \item[=3] apply both requirements in 1 and 2.
c\item[kfr(4)] (d=1) fermi motion in nuclei 
c       \item[=0] neglected.
c       \item[=1] included.
c\item[kfr(5)] (d=0) nucleon-nucleon overlap function 
c       \item[=0] eikonal.
c       \item[=1] gaussian.
c       \item[=2] gray disc.
c\item[kfr(6)] (d=2) target nucleus deformation
c       \item[=0] no deformation.
c       \item[=1] deformed target nucleus.
c       \item[=2] apply deformation only if the target atomic number $a\geq 80$.  
c\item[kfr(7)] (d=1) rutherford parton scattering processes
c       \item[=0] off.
c       \item[=1] on. here only the hardest rps is used in fritiof.    
c       \item[=2] on. the full multiple hard scattering scenario of pythia
c               is used.
c\item[kfr(8)](d=1) hard gluons cause a corner (soft gluon kink) on the string
c       \item[=0] no kink is formed. 
c       \item[=1] gluon kink is formed.
c\item[kfr(9)] (d=1) `drowning' of rutherford parton scattering 
c       \item[=0] off. accept all rps events.    
c       \item[=-1] on. throw away the drowned rps event completely 
c                  and replace it by a purely soft event.
c       \item[=1] as in -1, but the 
c            transverse momentum transfer of the soft collision is superimposed
c            by the $q_t$ of the drowned rps.  
c\item[kfr(10)] (d=1) 
c        srm parameters in rps events: $\mu_1=\mu_0/r$, $\mu_2=\mu_0/(1-r)$
c   \item[=0] $\mu$ remains the same as in a soft event: $\mu_1=\mu_2=\mu_0$.  
c      \item[=1] $r$\,=\,vfr(16). 
c      \item[=2] $r$ takes a uniform distribution in (0,1).
c\item[kfr(11)] (d=4)
c      write out of a message when the arguments in frevent is changed.  
c      \item[=-1] write it out every time the change occurs.    
c      \item[=$n$ ($n\geq 0$)] the write out is limited to $n$ times.    
c\item[kfr(12)] (d=2) 
c        set up of the dipole cascade and string fragmentation parameters.
c      \item[=0] no set up.  the default values are used. 
c      \item[=1] set to the values optimised by 
c       opal collaboration \cite{opal}:
c      para(1)=0.20, para(3)=1.0, parj(21)=0.37, parj(41)=0.18, parj(42)=0.34.  
c      \item[=2] set to the values optimised by delphi collaboration:
c      para(1)=0.22, para(3)=0.6, parj(21)=0.405, parj(41)=0.23, parj(42)=0.34.  
c\item[kfr(13)] (d=0) 
c       compresses the event record to save space in lujets.  this switch
c       is particularly needed for heavy ion collisions at high energy
c       where lujets must be compressed before it gets overfilled.  
c      \item[=0] do not compress lujets.  
c      \item[=1-3] luedit(kfr(13)) is called and lujets is compressed. 
c        specifically, for kfr(13)=1 fragmented jets and 
c        decayed particles are removed, for kfr(13)=2 neutrinos and
c        unknown particles are also removed, and for kfr(13)=3
c        neutral particles are further excluded.
c      \item[=4] a dummy subroutine freditd() is provided as an interface
c        in which a user may write his own special purpose codes to edit
c        and compress lujets.    
c\item[kfr(14)] (d=0) 
c       if set to 1, the outcome of each event will be checked for  
c       charge and energy-momentum conservation.
c%%
c\item[vfr(1)] (d=0.0 fm)
c       minimum impact parameter for options kfr(3)=2 or 3.
c\item[vfr(2)] (d=0.2 fm)
c       maximum impact parameter for options kfr(3)=2 or 3.
c\item[vfr(3)] (d=0.8 fm)
c  the minimum allowable distance $r_{min}$ between nucleons in a nucleus.  
c\item[vfr(4-5)] (d=0.2, 0.1)
c  dipole and quadrupole deformation coefficients for deformed target nucleus.
c\item[vfr(6)] (d=0.01 gev$^2/c^2$)
c       the $<q_t^2>$ for the gaussian distribution of soft transverse 
c       momentum transfer.
c\item[vfr(7)] (d=0.30 gev$^2/c^2$)
c       the $<q^2_{2t}>$ for the gaussian distribution of primordial transverse
c       momenta on the string ends.       
c\item[vfr(8)] (d=0.75 gev)
c       soft radiation coherence parameter $\mu_0$ for projectile hadron or
c       nucleon. 
c\item[vfr(9)] (d=0.75 gev)
c   soft radiation coherence parameter $\mu_0$ for target hadron or nucleon. 
c\item[vfr(10-11)] (d=0.0, 0.0 mb)
c       projectile-target nucleon total and elastic cross 
c       sections, respectively.
c       by default, they are taken from the parametrization 
c       of block and cahn \cite{block} (mstp(31)=5 in pythia).  
c       the meson-nucleon cross sections are obtained
c       simply by scaling down the block-cahn fit. the scale factor is
c       $(2/3-a/\sqrt s)$, where $a=1.13$ gev for pions and $a=3.27$ gev for 
c       kaons are chosen to reproduce the low energy experimental data. for
c       all the other baryons, it is treated as a pion if it is a meson
c       and it is treated as a proton if it is a baryon.
c       user may override the default by setting vfr(17-18) to positive values.
c       however, the user assigned cross sections will only affect the
c       n-n interaction probability in nucleus collisions. the
c       probability for rutherford parton scattering is not affected.  
c\item[vfr(12)] (d=1.0 gev/$c$)
c       the $q_{tmin}$ for rutherford parton scattering.  
c\item[vfr(13-15)] (d=1/6, 1/3, 1/2)
c       the probabilities for assigning various spins and flavours to the
c      diquark end of the string.  for example in a proton, vfr(13-15) are the
c       probabilities of finding a $ud$ diquark of spin 1,
c       a $uu$ diquark of spin 1, and a $ud$ diquark of spin 0, respectively. 
c\item[vfr(16)] (d=0.5)
c       the fraction $r$ in option kfr(10)=1. 
c
cc**************************************************************************
c********************************* end of fritiof package ******************

