#include "../chookHybAS.f"
#include "../ctemplCeren.f"
#include "ZcosmosBD.h"
c
c     chookASbyH:  This is a special user hook to compute
c                  AS generated by heavy primaries with
c                  generate='qas'.
c  **Important**  
c      You almost need not modify this file, although
c      you have to read this.  Those parts that you 
c      have to modify are gathered in chookASbyH2.f
c      
c
c       If the primary is a proton, we need about only 10 min even at
c       10^21 eV to produce AS by the hybrid method.  The time needed
c       at lower energies is shorter (but not propotinal to the energy).
c         However, for heavy primaries such as Fe, 
c       we need few to several hours to simulate 1 A.S even at 10^18 eV,
c       so we must coin out some new method.
c       The idea here is to use chookNEPInt where we get control 
c       when a hadron makes an interaction.  We may see interacting
c       nucleons there, and replace each of their further development by 
c       a precomputed proton shower (let's call it componet shower)
c       and discard further development of the shower by that nucleon.
c 
c       To use this routine for a heavy primary of mass A with total energy E,
c       you need to create AS by protons with energy E/A beforehand.
c       The first iteraction point of the protons should be fixed somewhere,
c       or should be known.
c       (To fix the first collision point when making c.s,
c        put Freec = f, and  say, HeightOfInj =20000). 
c       (As far as the one  dimensional  dvelopment of electrons is 
c       concerned, the first interaction point  can be almost arbitrary; 
c       The LPM effect will not be the problem).
c
c         The number of component showers should be 100~300.  For each of
c       component showers,  you must have the first interaction point, 
c       air shower sizes at different depths  (better at equisteped depths)
c       In some case you need  ages, muon size, etc, depending on your demands.
c       An arbitrary shower among them should be randomly selected as 
c       a component shower.  For this end, I recommend you to use
c       direct access file so that  you may read an arbitrary c.s from 
c       a disk file  when a c.s is requested.  Alternatively, you may
c       define a large array to store c.s data so that quick random
c       selection is possible.
c
c    Thus,  (in chookASbyH2.f)
c     a)  In chookBgRun, 
c           you may open the component shower file.
c           get some overall information
c     b)  In chookBgEvent,
c          you may clear the AS size counters.  This is auomatically
c         performed if you use standard counters.
c     c)  In chookNEPInt, 
c         c-1) you should inquire the interacting nucleons by
c              calling  cqIntePtcl,
c         c-2) get a component shower randomly
c         c-3) increment the size counters
c              You need some interpolation for this end.
c         c-4) Finally you must give "never = 2" to discard further
c              development of showers  by the interacting nucleons.
c     d)  In chookEnEvent,
c          you should output AS size.
c
c     In this template, we assume that log10( electron size) is stored in
c     a direct access file.  If size is 0, log10(size) may be -1.
c
c    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c      All actual interface routines are in chookASbyH2.f
c      In this file, there are lines to call routines in chookASbyH2.f
c      see %%%% parts below.
c
c  *************************************** hook for Beginning of a Run
c  * At this moment, all (system-level) initialization for this run
c  * has been ended.  After this routine is executed, the system goes into the
c  * event creation loop.
c  *
      subroutine chookBgRun
      implicit none
#include "Zmanagerp.h"

c
c         If you feel writing the parameters on stderr is
c         a bother, comment out the next or
c         use other device than ErrorOut.
c         Also you may comment out all output routines below.
#ifdef sun4
      external csigHandler
      integer  ieeer, ieee_handler

      ieeer = ieee_handler('set', 'invalid', csigHandler)
#endif
c
c            namelist output
      call cwriteParam(ErrorOut, 0)
c            primary information
      call cprintPrim(ErrorOut)
c            observation level information
      call cprintObs(ErrorOut)
c     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c      open component disk file, and get some over all
c     informaiton such as number of component showers
     
      call chookBgRunAS 
      
      end

#ifdef sun4
      integer function csigHandler(sig, code, context)
      implicit none
#include "Zmanagerp.h"
      integer sig, code, context(5)
      write(ErrorOut, *)  ' f.p exception content=' , context(4)
c      call abort()
      end
#endif

c     *********************************** hook for Beginning of  1 event
c     *  All system-level initialization for 1 event generation has been
c     *  eneded at this moment.
c     *  After this is executed, event generation starts.
c     *
      subroutine chookBgEvent
      implicit none
c
      integer seed(2)
c      write(*, *) ' bigin event generation'
      call cqIniRn(seed)
c      write(*,*) ' seed=', seed


      end
  

c     ************************************ hook for observation
c     *  One particel information is brought here by the system.
c     *  All information of the particle is in aTrack
c     *
      subroutine chookObs(aTrack, id)
c
c     Note that every real variable is in double  precision so
c     that you may output it in sigle precision to save the memory.
c     In some cases it is essential to put it in sigle (say,
c     for gnuplot).
c 
      implicit none
#include "Zcode.h"
#include "Ztrack.h"
      integer id  ! input.  1 ==> aTrack is going out from
c                                 outer boundery.
c                           2 ==> reached at an observation level
c                           3 ==> reached at inner boundery.
      record /track/ aTrack

c
c     For id =2, you need not output the z value, because it is always
c     0 (within the computational accuracy).
c
      if(id .eq. 2) then
c            output typical quantities.
c        write(*, *) 
c     *  aTrack.where,   !  observation level. integer*2.  1 is highest.
c     *  aTrack.p.code,    !  ptcl code.  integer*2.
c     *  aTrack.p.charge,  !  charge,  integer*2 
c     *  sngl(aTrack.t), !  relateive arrival time in nsec (NOT sec).
c                        !  if TimeStructure is F, nonsense.
c     *  sngl(aTrack.p.fm.e)  ! total energy in GeV.
c     *  sngl(aTrack.pos.xyz.x), sngl(aTrack.pos.xyz.y),  !  x, y in m
c     *  sngl(aTrack.vec.w.x),  ! direc. cos.x in the current detector system.
c     *  sngl(aTrack.vec.w.y),  ! direc. cos.y
c     *  sngl(aTrack.vec.w.z),  ! direc. cos.z
c     *  sngl(aTrack.vec.coszenith) ! cos of zenith angle
c         if(aTrack.p.code .eq. kelec) then
c            write(*, *) aTrack.where
c         endif
c      endif
c         you may need in some case other information such as
c       aTrack.p.subcode   ! sub code of the particle integer*2
c       aTrack.p.mass      ! mass 
c       aTrack.wgt         ! weight of the particle (may not be 1. if
c                           ! ThinSampling =T)
c       aTrack.p.fm.x      ! momentum x component.  Note. Momentum is
c                            given in the  Earth xyz system.

c       aTrack.p.fm.y      !          y
c       aTrack.p.fm.z      !          z

      endif
      end

c    *********************************** hook for end of 1 event
c    * At this moment, 1 event generation has been ended.
c    *
      subroutine chookEnEvent

      implicit none
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
      include "ZASbyH.h"



c      record /track/ inci
c      record /coord/ angle
      integer i
      real*8 fdepth

c

      if(ObserveAS) then
         call cqFirstID(fdepth)
c         call cqIncident(inci, angle)
c         bsin = cgetBsin(inci.p, Mag)*1.e4
c                   electron size in B approx.
c         write(*, *) (ASObsSites(i).esize, i=1, NoOfASSites)
c                   size weighted age
c         write(*, *) (ASObsSites(i).age,   i=1, NoOfASSites)
         do i = 1, NoOfASSites
             write(*, *)  sngl(ASObsSites(i).pos.depth),
     *           sngl(ASObsSites(i).esize),
     *           sngl(ASObsSites(i).age)
c     *          ,sngl(fdepth)
c     *          ,sngl(bsin)
         enddo
         write(*, *)
      endif

 
      end


c     ********************************* hook for end of a run
c     *  all events have been created or time lacks
c     *
      subroutine chookEnRun

      implicit none
      end
c     ********************************* hook for trace
c     *  This is called only when trace > 60
c     *  User should manage the trace information here.
c     *  If you use this, you may need some output for trace
c     *  at the beginning of 1 event generatio and at the end of  1 event
c     *  generation so that you can identfy each event.
c     *
c     *
      subroutine chookTrace
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsv.h"

       real*4 h1,  h2
c
c    Every time a particle is moved in the atmosphere, this routine is called,
c    if trace > 60. 
c         For a one track segment,
c     TrackBefMove  has  track information at the beginning of the segment.
c     MoveTrack    has   track information at the end of the segment.
c   
c     You can know the  information a track contains in the 
c     chookObs routine. (Note however, no conversion of coordinate
c     has been done.  The values are in the Earth xyz system.)
c     Besides quantities explained there, you can use, for a  given 'track'
c
c     atrack.pos.xyz.x, atrack.pos.xyz.y, atrack.pos.xyz.z    (x,y.z)
c     atrack.pos.radiallen   (distance from the center of the earth)
c     atrack.pos.depth       (vertical depth)
c     atrack.pos.height      (vertical heigth from sea level)  
c

      h1 = TrackBefMove.pos.height- ObsSites(NoOfSites).pos.height
      h2 = MovedTrack.pos.height - ObsSites(NoOfSites).pos.height

      end

c     ********************* this is the hook called when
c       an electron made an interaction.
c
      subroutine chookEInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after an electron made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the electron that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c
c        IntInfArray(ProcessNo).process will have one of
c       'brems', 'mscat', 'bscat', 'anihi' or 'mbrem'
c
      end

c     ********************* this is the hook called when
c       a gamma ray made an interaction.
c
      subroutine chookGInt(never)
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a gamma ray made interaction
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the gamma that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        default setting
      never = 1
c         IntInfArray(ProcessNo).process will have one of
c        'pair', 'comp', 'photoe' 'photop' 'mpair'
c       
      end

c     ********************* this is the hook called when
c       non e-g particle made an interaction.
c
      subroutine chookNEPInt(never)
            implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
c  #include  "Ztrackp.h"
      
      integer never   ! input & output
      
c         don't make never = 1, if you want to get
c         information after a non-e-g particle  made interaction.
c         if this is made non zero, this routine will never be called.
c
c   MovedTrack is the particle that made interaction
c   Pwork contains produced particles.
c   Nproduced has the number of particles in Pwork
c   IntInfArray(ProcessNo) contains the type of interaction
c
c        IntInfArray(ProcessNo).process  will have
c             'col' or 'decay'
c   %%%%%%%%%%%%%%%%%%%%%%%%%%
c         replace interacting nucleons by c.s. give never = 2
c     so that no further development by the interacting nucleons.
c
      call chookNEPIntA
      never = 2
      end
