cc           test chAcolAdhoc
          implicit none

#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zevhnv.h"
#include  "Zevhnp.h"

          integer nmax
          parameter (nmax = 700)   ! # of max ptcls supposed to be generated
          record /ptcl/ pj, a(nmax), tg, cmsptcl
c
          integer k,  ntp, j, nevent, nuccharge, icon
          real*8 x, y, eta, u
          real*8 sumx, sumy, sumz, sume, energy
          real pt
          character*90  msg
          logical lroots
c          integer l
c
          record /fmom/ rest
 
          rest.px = 0.
          rest.py = 0.
          rest.pz = 0.
          rest.e = 0.

          
          msg = 'NAir collisions; csm is that for pp col.'
          call cerrorMsg(msg, 1)
          msg =
     *    ' Enter 1) Root S flag(t/f), 2) # of events, 3) Energy(GeV)'
     *     //', 4) incident nucleon charge'
          call cerrorMsg(msg, 1)
          read(*, *) lroots, nevent, energy, nuccharge
c
          write(*, *)
     *    '# NAir collisons.  roots flag=', lroots, ' E(GeV)=', energy

          write(*, *)
     *    '# events=', nevent,' charge of nuc=',nuccharge,'incl leader'

          write(*, *) '# x, y, eta, pt, code, charge, multi'
c
cc             make incident nucleon
          call cmkptc(knuc, regptcl, nuccharge,   pj)
cc      
c             make nuclon target (not for collision)
          tg = pj
          tg.fm = rest
          tg.fm.e = tg.mass

          if(lroots) then
             energy = ( energy**2 - pj.mass**2 - tg.mass**2)
     *                /2/tg.mass
          endif
          pj.fm.x =0.
          pj.fm.y =0.
          pj.fm.e = energy
          pj.fm.z = sqrt(pj.fm.e**2-pj.mass**2)
c              form cms; this is for comparison with pp data
          call cgeqm(pj, tg, cmsptcl, icon)
c
          call rndc(u)
          do k=1, nevent
             call chAcolAdhoc(pj, 14, 7, a, ntp)
             sumx = 0.
             do j=1, ntp
                x = a(j).fm.e / pj.fm.e
                sumx = sumx + x
                sumy =0.
                sumz =0.
                sume =0.
c                      boost to cms                
                call cbst1(j, cmsptcl,  a(j), a(j))
                call cyeta(a(j), y, eta)
                pt = sqrt(a(j).fm.x**2 + a(j).fm.y**2)
                write(*, *) sngl(x), sngl(y), sngl(eta), sngl(pt), 
     *          a(j).code, a(j).charge,  ntp
             enddo
          enddo   
        end




