	subroutine ciP5F1S50C99(cs, e1, e2, desingle)
	implicit none
	real*8 cs ! output.  cos
	real*8 e1  ! output  low end of energy
        real*8 e2  ! output   high end of energy
	real*8 desingle  ! output  energy deposit by single muon
                         !       in GeV with cos angle
c    Pb=0.5cm
c    Fe=0.1cm
c    Scinti = 5.0cm
c    Cos=0.99
c    energy 0.001 GeV to 1 GeV
c    slant Single Eqv. 0.7e-2 GeV
c

	cs = 0.99
	e1 = 1.d-3
	e2 = 1.
	desingle = 1.0e-2
      end
      subroutine cemP5F1S50C99(e, de)
      implicit none
c           this is for e- incident
c             be >= 0.975
c de--output  energy deposit in scinti in gev*cos(angle)
c
      real*8 e  ! input   electron energy in GeV.
      real*8 de  ! output  energy deposit in Scinti in GeV*cos(angle)

      integer ne, i
      integer nes
      parameter (nes=13)
      parameter(ne=12)

      real*8 zr(nes)
      real*8 u, el, rr

      real*8 hx, hy, f


      real*8 a(101,ne), a1(101),
     * ap4640(101), ap2154(101),ap1(101), ap065(101), ap0464(101),
     * ap0316(101), ap0215(101), ap01(101), ap0046(101),
     *          ap0021(101), ap001(101)
      equivalence (a(1,ne-11), ap001(1))
      equivalence (a(1,ne-10), ap0021(1))
      equivalence (a(1,ne-9), ap0046(1))
      equivalence (a(1,ne-8), ap01(1))
      equivalence (a(1,ne-7), ap0215(1))
      equivalence (a(1,ne-6), ap0316(1))
      equivalence (a(1,ne-5), ap0464(1))
      equivalence (a(1,ne-4), ap065(1))
      equivalence (a(1,ne-3), ap1(1))
      equivalence (a(1,ne-2), ap2154(1))
      equivalence (a(1,ne-1), ap4640(1))
      equivalence (a(1,ne  ), a1(1))

      data hx/0.01d0/, hy/0.333333333d0/
c
      data (a1    (i),i=   1,  72)/
     1-4.0000,-2.0845,-2.0627,-2.0522,-2.0443,-2.0377,-2.0307,-2.0239,
     2-2.0172,-2.0107,-2.0040,-1.9974,-1.9906,-1.9834,-1.9760,-1.9685,
     3-1.9605,-1.9512,-1.9424,-1.9341,-1.9258,-1.9184,-1.9072,-1.8955,
     4-1.8838,-1.8733,-1.8616,-1.8485,-1.8347,-1.8201,-1.8053,-1.7910,
     5-1.7764,-1.7610,-1.7451,-1.7306,-1.7190,-1.7065,-1.6952,-1.6841,
     6-1.6731,-1.6623,-1.6523,-1.6415,-1.6293,-1.6180,-1.6063,-1.5942,
     7-1.5819,-1.5716,-1.5625,-1.5544,-1.5469,-1.5400,-1.5336,-1.5272,
     8-1.5205,-1.5133,-1.5068,-1.5010,-1.4951,-1.4893,-1.4836,-1.4776,
     9-1.4713,-1.4646,-1.4568,-1.4493,-1.4424,-1.4354,-1.4272,-1.4189/
      data (a1    (i),i=  73, 101)/
     1-1.4106,-1.4023,-1.3942,-1.3860,-1.3777,-1.3686,-1.3591,-1.3494,
     2-1.3398,-1.3303,-1.3206,-1.3113,-1.3025,-1.2941,-1.2861,-1.2750,
     3-1.2638,-1.2527,-1.2417,-1.2303,-1.2189,-1.2050,-1.1890,-1.1689,
     4-1.1497,-1.1263,-1.1017,-1.0589,-0.7450/
c
      data (ap4640(i),i=   1,  72)/
     1-4.0000,-2.6132,-2.1281,-2.0686,-2.0573,-2.0511,-2.0462,-2.0411,
     2-2.0365,-2.0319,-2.0275,-2.0230,-2.0183,-2.0130,-2.0078,-2.0027,
     3-1.9978,-1.9929,-1.9880,-1.9834,-1.9784,-1.9730,-1.9667,-1.9605,
     4-1.9543,-1.9480,-1.9414,-1.9346,-1.9271,-1.9190,-1.9110,-1.9033,
     5-1.8938,-1.8838,-1.8754,-1.8665,-1.8563,-1.8460,-1.8354,-1.8244,
     6-1.8130,-1.8013,-1.7897,-1.7779,-1.7629,-1.7528,-1.7424,-1.7320,
     7-1.7215,-1.7105,-1.6998,-1.6897,-1.6809,-1.6720,-1.6628,-1.6531,
     8-1.6433,-1.6340,-1.6247,-1.6144,-1.6017,-1.5909,-1.5815,-1.5724,
     9-1.5631,-1.5536,-1.5463,-1.5394,-1.5324,-1.5256,-1.5192,-1.5129/
      data (ap4640(i),i=  73, 101)/
     1-1.5063,-1.4994,-1.4926,-1.4864,-1.4799,-1.4724,-1.4644,-1.4562,
     2-1.4474,-1.4378,-1.4285,-1.4193,-1.4091,-1.3984,-1.3874,-1.3761,
     3-1.3653,-1.3550,-1.3455,-1.3329,-1.3199,-1.3041,-1.2882,-1.2725,
     4-1.2537,-1.2251,-1.1916,-1.1464,-0.9550/
c
      data (ap2154(i),i=   1,  72)/
     1-4.0000,-3.2815,-2.7461,-2.3292,-2.1500,-2.1000,-2.0625,-2.0552,
     2-2.0507,-2.0463,-2.0419,-2.0388,-2.0348,-2.0309,-2.0270,-2.0230,
     3-2.0191,-2.0151,-2.0110,-2.0070,-2.0030,-1.9991,-1.9954,-1.9915,
     4-1.9875,-1.9834,-1.9792,-1.9750,-1.9707,-1.9665,-1.9621,-1.9569,
     5-1.9516,-1.9462,-1.9416,-1.9372,-1.9328,-1.9279,-1.9226,-1.9170,
     6-1.9114,-1.9058,-1.8996,-1.8923,-1.8852,-1.8784,-1.8714,-1.8634,
     7-1.8553,-1.8469,-1.8386,-1.8313,-1.8234,-1.8142,-1.8039,-1.7933,
     8-1.7839,-1.7753,-1.7676,-1.7576,-1.7474,-1.7377,-1.7277,-1.7179,
     9-1.7093,-1.6997,-1.6894,-1.6808,-1.6727,-1.6644,-1.6561,-1.6476/
      data (ap2154(i),i=  73, 101)/
     1-1.6384,-1.6288,-1.6190,-1.6090,-1.5988,-1.5896,-1.5791,-1.5680,
     2-1.5586,-1.5484,-1.5377,-1.5299,-1.5204,-1.5102,-1.5011,-1.4915,
     3-1.4811,-1.4706,-1.4598,-1.4488,-1.4361,-1.4246,-1.4081,-1.3932,
     4-1.3747,-1.3476,-1.3187,-1.2772,-1.1200/
c
      data (ap1   (i),i=   1,  72)/
     1-5.0000,-3.8334,-3.4293,-3.1475,-2.9343,-2.7065,-2.5073,-2.3835,
     2-2.2866,-2.2141,-2.1509,-2.0922,-2.0675,-2.0565,-2.0499,-2.0451,
     3-2.0399,-2.0357,-2.0320,-2.0279,-2.0243,-2.0209,-2.0172,-2.0135,
     4-2.0099,-2.0062,-2.0025,-1.9988,-1.9952,-1.9917,-1.9881,-1.9846,
     5-1.9813,-1.9778,-1.9747,-1.9713,-1.9678,-1.9642,-1.9606,-1.9570,
     6-1.9535,-1.9500,-1.9468,-1.9433,-1.9397,-1.9357,-1.9315,-1.9272,
     7-1.9229,-1.9184,-1.9139,-1.9092,-1.9044,-1.8997,-1.8946,-1.8889,
     8-1.8829,-1.8775,-1.8724,-1.8670,-1.8615,-1.8561,-1.8500,-1.8430,
     9-1.8359,-1.8289,-1.8220,-1.8144,-1.8066,-1.7995,-1.7925,-1.7850/
      data (ap1   (i),i=  73, 101)/
     1-1.7770,-1.7691,-1.7610,-1.7524,-1.7435,-1.7346,-1.7250,-1.7148,
     2-1.7067,-1.6981,-1.6881,-1.6786,-1.6687,-1.6570,-1.6447,-1.6327,
     3-1.6209,-1.6087,-1.5946,-1.5830,-1.5687,-1.5548,-1.5393,-1.5227,
     4-1.5052,-1.4862,-1.4576,-1.4199,-1.2050/
c
      data (ap065 (i),i=   1,  72)/
     1-5.0000,-3.9667,-3.6739,-3.4771,-3.3060,-3.1654,-3.0597,-2.9556,
     2-2.8413,-2.7425,-2.6359,-2.5565,-2.4733,-2.4048,-2.3417,-2.2943,
     3-2.2455,-2.2031,-2.1689,-2.1304,-2.0983,-2.0679,-2.0588,-2.0488,
     4-2.0443,-2.0384,-2.0336,-2.0290,-2.0243,-2.0200,-2.0159,-2.0119,
     5-2.0079,-2.0041,-2.0004,-1.9968,-1.9932,-1.9898,-1.9863,-1.9827,
     6-1.9792,-1.9756,-1.9721,-1.9686,-1.9651,-1.9619,-1.9584,-1.9549,
     7-1.9512,-1.9474,-1.9435,-1.9395,-1.9355,-1.9314,-1.9275,-1.9235,
     8-1.9196,-1.9159,-1.9121,-1.9078,-1.9033,-1.8988,-1.8942,-1.8897,
     9-1.8853,-1.8805,-1.8751,-1.8693,-1.8639,-1.8587,-1.8537,-1.8483/
      data (ap065 (i),i=  73, 101)/
     1-1.8422,-1.8361,-1.8299,-1.8237,-1.8175,-1.8115,-1.8051,-1.7974,
     2-1.7896,-1.7821,-1.7737,-1.7637,-1.7543,-1.7457,-1.7353,-1.7254,
     3-1.7158,-1.7058,-1.6936,-1.6807,-1.6684,-1.6545,-1.6387,-1.6200,
     4-1.5989,-1.5775,-1.5483,-1.5107,-1.3550/
c
      data (ap0464(i),i=   1,  72)/
     1-5.0000,-4.1847,-3.8795,-3.7133,-3.5820,-3.4702,-3.3764,-3.2824,
     2-3.1948,-3.1045,-3.0338,-2.9676,-2.9058,-2.8288,-2.7658,-2.7014,
     3-2.6410,-2.5950,-2.5501,-2.5035,-2.4568,-2.4173,-2.3790,-2.3413,
     4-2.3049,-2.2724,-2.2387,-2.2098,-2.1859,-2.1603,-2.1403,-2.1196,
     5-2.1009,-2.0820,-2.0668,-2.0563,-2.0482,-2.0413,-2.0350,-2.0287,
     6-2.0225,-2.0166,-2.0112,-2.0066,-2.0022,-1.9976,-1.9929,-1.9883,
     7-1.9838,-1.9795,-1.9752,-1.9710,-1.9669,-1.9628,-1.9590,-1.9549,
     8-1.9507,-1.9463,-1.9420,-1.9377,-1.9335,-1.9294,-1.9252,-1.9209,
     9-1.9164,-1.9119,-1.9074,-1.9029,-1.8983,-1.8936,-1.8890,-1.8843/
      data (ap0464(i),i=  73, 101)/
     1-1.8795,-1.8744,-1.8692,-1.8638,-1.8584,-1.8527,-1.8469,-1.8408,
     2-1.8345,-1.8284,-1.8220,-1.8151,-1.8079,-1.8004,-1.7926,-1.7847,
     3-1.7771,-1.7674,-1.7565,-1.7451,-1.7353,-1.7234,-1.7088,-1.6926,
     4-1.6755,-1.6553,-1.6312,-1.5948,-1.4450/
c
      data (ap0316(i),i=   1,  72)/
     1-5.0000,-4.4368,-4.1695,-3.9958,-3.8714,-3.7779,-3.7066,-3.6373,
     2-3.5713,-3.5105,-3.4608,-3.4175,-3.3667,-3.3250,-3.2842,-3.2368,
     3-3.1870,-3.1489,-3.1093,-3.0716,-3.0289,-2.9885,-2.9587,-2.9250,
     4-2.8910,-2.8551,-2.8286,-2.8009,-2.7693,-2.7368,-2.7086,-2.6785,
     5-2.6502,-2.6224,-2.5884,-2.5641,-2.5395,-2.5142,-2.4855,-2.4599,
     6-2.4317,-2.4045,-2.3840,-2.3622,-2.3385,-2.3189,-2.3013,-2.2836,
     7-2.2674,-2.2465,-2.2269,-2.2115,-2.1935,-2.1770,-2.1603,-2.1466,
     8-2.1330,-2.1180,-2.1050,-2.0921,-2.0808,-2.0698,-2.0588,-2.0491,
     9-2.0404,-2.0333,-2.0266,-2.0206,-2.0141,-2.0073,-2.0005,-1.9941/
      data (ap0316(i),i=  73, 101)/
     1-1.9883,-1.9816,-1.9741,-1.9675,-1.9621,-1.9569,-1.9497,-1.9424,
     2-1.9351,-1.9280,-1.9210,-1.9141,-1.9072,-1.9006,-1.8935,-1.8856,
     3-1.8774,-1.8690,-1.8602,-1.8509,-1.8422,-1.8321,-1.8197,-1.8070,
     4-1.7934,-1.7728,-1.7502,-1.7205,-1.6250/
c
      data (ap0215(i),i=   1,  72)/
     1-5.0000,-4.7734,-4.4952,-4.3030,-4.1819,-4.0831,-4.0063,-3.9419,
     2-3.8922,-3.8438,-3.7933,-3.7498,-3.7069,-3.6728,-3.6377,-3.6024,
     3-3.5708,-3.5411,-3.5118,-3.4839,-3.4534,-3.4279,-3.4035,-3.3751,
     4-3.3445,-3.3142,-3.2873,-3.2610,-3.2364,-3.2153,-3.1934,-3.1698,
     5-3.1496,-3.1273,-3.1066,-3.0852,-3.0628,-3.0427,-3.0223,-3.0026,
     6-2.9857,-2.9667,-2.9476,-2.9266,-2.9077,-2.8871,-2.8691,-2.8515,
     7-2.8303,-2.8099,-2.7942,-2.7747,-2.7551,-2.7355,-2.7170,-2.6966,
     8-2.6780,-2.6568,-2.6383,-2.6166,-2.5995,-2.5831,-2.5631,-2.5431,
     9-2.5239,-2.5043,-2.4849,-2.4664,-2.4478,-2.4316,-2.4134,-2.3954/
      data (ap0215(i),i=  73, 101)/
     1-2.3779,-2.3605,-2.3446,-2.3281,-2.3117,-2.2956,-2.2822,-2.2661,
     2-2.2500,-2.2336,-2.2175,-2.2005,-2.1843,-2.1677,-2.1535,-2.1381,
     3-2.1206,-2.1050,-2.0890,-2.0746,-2.0599,-2.0462,-2.0290,-2.0132,
     4-1.9960,-1.9801,-1.9613,-1.9359,-1.7600/
c
      data (ap01  (i),i=   1,  72)/
     1-5.5229,-5.0353,-4.7978,-4.6199,-4.5025,-4.3976,-4.3261,-4.2685,
     2-4.2032,-4.1520,-4.0985,-4.0519,-4.0141,-3.9780,-3.9468,-3.9198,
     3-3.8914,-3.8650,-3.8437,-3.8199,-3.7965,-3.7702,-3.7500,-3.7283,
     4-3.7079,-3.6895,-3.6722,-3.6542,-3.6362,-3.6213,-3.6018,-3.5862,
     5-3.5689,-3.5532,-3.5389,-3.5266,-3.5141,-3.5015,-3.4873,-3.4736,
     6-3.4607,-3.4462,-3.4312,-3.4153,-3.4002,-3.3860,-3.3713,-3.3559,
     7-3.3392,-3.3225,-3.3078,-3.2951,-3.2818,-3.2688,-3.2563,-3.2432,
     8-3.2273,-3.2151,-3.2041,-3.1891,-3.1752,-3.1603,-3.1468,-3.1322,
     9-3.1179,-3.1046,-3.0910,-3.0767,-3.0636,-3.0483,-3.0319,-3.0182/
      data (ap01  (i),i=  73, 101)/
     1-3.0052,-2.9883,-2.9722,-2.9551,-2.9383,-2.9210,-2.9038,-2.8906,
     2-2.8776,-2.8579,-2.8402,-2.8219,-2.8032,-2.7826,-2.7606,-2.7410,
     3-2.7156,-2.6931,-2.6750,-2.6539,-2.6245,-2.5998,-2.5673,-2.5303,
     4-2.4950,-2.4537,-2.4035,-2.3214,-2.0600/
c
      data (ap0046(i),i=   1,  72)/
     1-5.9100,-5.2337,-4.9233,-4.7591,-4.6439,-4.5245,-4.4483,-4.3920,
     2-4.3177,-4.2571,-4.2303,-4.1853,-4.1605,-4.1273,-4.1005,-4.0729,
     3-4.0395,-4.0107,-3.9836,-3.9589,-3.9317,-3.9095,-3.8902,-3.8656,
     4-3.8453,-3.8236,-3.8046,-3.7892,-3.7742,-3.7584,-3.7428,-3.7271,
     5-3.7115,-3.6973,-3.6830,-3.6669,-3.6521,-3.6373,-3.6230,-3.6120,
     6-3.6040,-3.5904,-3.5761,-3.5625,-3.5498,-3.5365,-3.5194,-3.5085,
     7-3.4991,-3.4893,-3.4785,-3.4660,-3.4547,-3.4442,-3.4339,-3.4230,
     8-3.4101,-3.3991,-3.3844,-3.3657,-3.3622,-3.3525,-3.3411,-3.3280,
     9-3.3150,-3.3008,-3.2867,-3.2695,-3.2583,-3.2489,-3.2394,-3.2301/
      data (ap0046(i),i=  73, 101)/
     1-3.2184,-3.2067,-3.1977,-3.1844,-3.1724,-3.1628,-3.1537,-3.1432,
     2-3.1326,-3.1132,-3.0952,-3.0751,-3.0583,-3.0390,-3.0223,-2.9981,
     3-2.9821,-2.9625,-2.9445,-2.9213,-2.8964,-2.8721,-2.8450,-2.8193,
     4-2.7923,-2.7614,-2.7187,-2.6392,-2.4300/
c
      data (ap0021(i),i=   1,  72)/
     1-5.9250,-5.4665,-5.1951,-4.9641,-4.8909,-4.7604,-4.6476,-4.5669,
     2-4.5278,-4.4964,-4.4195,-4.3805,-4.3181,-4.2912,-4.2180,-4.1918,
     3-4.1568,-4.1145,-4.0813,-4.0727,-4.0385,-4.0136,-3.9903,-3.9888,
     4-3.9991,-3.9413,-3.9384,-3.9206,-3.8952,-3.8804,-3.8668,-3.8548,
     5-3.8502,-3.8420,-3.8225,-3.8186,-3.8051,-3.7899,-3.7808,-3.7569,
     6-3.7455,-3.7377,-3.7216,-3.7007,-3.6924,-3.6728,-3.6668,-3.6564,
     7-3.6363,-3.6312,-3.6248,-3.6212,-3.6097,-3.5979,-3.5872,-3.5786,
     8-3.5754,-3.5641,-3.5519,-3.5398,-3.5324,-3.5270,-3.5194,-3.5103,
     9-3.4980,-3.4867,-3.4770,-3.4720,-3.4682,-3.4610,-3.4620,-3.4336/
      data (ap0021(i),i=  73, 101)/
     1-3.4087,-3.4017,-3.3913,-3.3808,-3.3695,-3.3576,-3.3484,-3.3380,
     2-3.3275,-3.3186,-3.3065,-3.2871,-3.2731,-3.2635,-3.2541,-3.2463,
     3-3.2256,-3.2158,-3.2004,-3.1905,-3.1783,-3.1407,-3.1260,-3.0960,
     4-3.0867,-3.0521,-3.0018,-2.9871,-2.8800/
c
      data ap001/5*-6., 6*-5.,90*-4.5/
c

       data zr/1.00, .995, .950,.840, .600, .315,
     *          .143, .050, .032, .010, .01, 0., 0./
c
c
         el=log10(e)
         call rndc(u)
         call kintp3(zr, 1, nes, -3.d0, .25d0, el, rr)
         if(u .lt. rr) then
            de=0.
         else
            call rndc(u)
            call rndc(u)
            call k4ptdi(b, 101, ne, 101, 0.d0, -3.d0, hx, hy,
     *      u, el, f)
	    de = 10.d0**f
         endif
      end
      subroutine cepP5F1S50C99(e, de)
	implicit none
c            e+
	real*8 e, de
          call cemP5F1S50C99(e, de)
          if(e .lt. .021) then
c                correction;  5% increase at 10 mev
               de=de* (1. + (.021-e)* 7.)
          endif
      end
      subroutine )cgP5F1S50C99(e, de)
c           this is for g  incident
      implicit none
c           this is for g  incident
c
      real*8 e, de

      integer ne, i
      integer nes
      parameter (nes=13)
      parameter(ne = 10)
      
      real*8 u, el, rr

      real*8 hx, hy, f

      real*8 zr(nes)

c
c

      real*8 a(101,ne), a1(101),
     *          ap4640(101), ap2154(101),ap1(101), ap0464(101),
     *              ap0215(101), ap01(101), ap0046(101),
     *          ap0021(101), ap001(101)
      equivalence (a(1,ne-9 ), ap001(1))
      equivalence (a(1,ne-8), ap0021(1))
      equivalence (a(1,ne-7), ap0046(1))
      equivalence (a(1,ne-6), ap01(1))
      equivalence (a(1,ne-5), ap0215(1))
      equivalence (a(1,ne-4), ap0464(1))
      equivalence (a(1,ne-3), ap1(1))
      equivalence (a(1,ne-2), ap2154(1))
      equivalence (a(1,ne-1), ap4640(1))
      equivalence (a(1,ne  ), a1(1))

      data hx/0.01d0/, hy/0.3333333333d0/
c
      data (a1    (i),i=   1,  72)/
     1-4.2350,-2.5590,-2.2656,-2.1044,-2.0292,-1.9849,-1.9401,-1.8954,
     2-1.8469,-1.8037,-1.7704,-1.7596,-1.7508,-1.7460,-1.7429,-1.7384,
     3-1.7346,-1.7310,-1.7272,-1.7237,-1.7203,-1.7168,-1.7134,-1.7100,
     4-1.7067,-1.7034,-1.7000,-1.6967,-1.6933,-1.6901,-1.6867,-1.6832,
     5-1.6796,-1.6760,-1.6723,-1.6683,-1.6643,-1.6601,-1.6559,-1.6517,
     6-1.6475,-1.6432,-1.6386,-1.6338,-1.6289,-1.6237,-1.6185,-1.6131,
     7-1.6072,-1.6011,-1.5947,-1.5882,-1.5816,-1.5750,-1.5684,-1.5612,
     8-1.5536,-1.5462,-1.5390,-1.5314,-1.5233,-1.5148,-1.5061,-1.4976,
     9-1.4892,-1.4809,-1.4727,-1.4648,-1.4561,-1.4468,-1.4380,-1.4294/
      data (a1    (i),i=  73, 101)/
     1-1.4209,-1.4127,-1.4049,-1.3974,-1.3900,-1.3825,-1.3745,-1.3667,
     2-1.3590,-1.3507,-1.3421,-1.3338,-1.3261,-1.3168,-1.3063,-1.2949,
     3-1.2838,-1.2707,-1.2587,-1.2472,-1.2333,-1.2190,-1.2060,-1.1832,
     4-1.1606,-1.1367,-1.1061,-1.0603,-0.8600/
c
      data (ap4640(i),i=   1,  72)/
     1-4.9250,-2.6164,-2.2977,-2.1159,-2.0430,-2.0089,-1.9827,-1.9581,
     2-1.9262,-1.8932,-1.8670,-1.8404,-1.8173,-1.7940,-1.7711,-1.7600,
     3-1.7514,-1.7463,-1.7433,-1.7389,-1.7350,-1.7317,-1.7286,-1.7257,
     4-1.7228,-1.7205,-1.7178,-1.7150,-1.7122,-1.7094,-1.7067,-1.7038,
     5-1.7010,-1.6981,-1.6951,-1.6921,-1.6890,-1.6859,-1.6826,-1.6792,
     6-1.6757,-1.6722,-1.6686,-1.6650,-1.6612,-1.6577,-1.6540,-1.6505,
     7-1.6472,-1.6437,-1.6400,-1.6359,-1.6317,-1.6273,-1.6227,-1.6180,
     8-1.6132,-1.6078,-1.6020,-1.5963,-1.5907,-1.5854,-1.5796,-1.5731,
     9-1.5666,-1.5601,-1.5537,-1.5474,-1.5412,-1.5349,-1.5284,-1.5217/
      data (ap4640(i),i=  73, 101)/
     1-1.5142,-1.5066,-1.4992,-1.4922,-1.4839,-1.4753,-1.4664,-1.4579,
     2-1.4501,-1.4418,-1.4326,-1.4235,-1.4143,-1.4048,-1.3952,-1.3856,
     3-1.3761,-1.3654,-1.3534,-1.3425,-1.3293,-1.3155,-1.3019,-1.2845,
     4-1.2606,-1.2366,-1.2045,-1.1614,-0.9350/
c
      data (ap2154(i),i=   1,  72)/
     1-4.0000,-2.7905,-2.4384,-2.2249,-2.0862,-2.0540,-2.0392,-2.0234,
     2-2.0085,-1.9962,-1.9831,-1.9693,-1.9555,-1.9393,-1.9250,-1.9113,
     3-1.8955,-1.8785,-1.8611,-1.8447,-1.8278,-1.8124,-1.7999,-1.7875,
     4-1.7752,-1.7631,-1.7541,-1.7507,-1.7458,-1.7415,-1.7385,-1.7354,
     5-1.7319,-1.7284,-1.7251,-1.7219,-1.7188,-1.7158,-1.7130,-1.7103,
     6-1.7075,-1.7046,-1.7018,-1.6990,-1.6961,-1.6933,-1.6904,-1.6876,
     7-1.6847,-1.6819,-1.6790,-1.6761,-1.6731,-1.6700,-1.6668,-1.6636,
     8-1.6604,-1.6572,-1.6539,-1.6505,-1.6471,-1.6435,-1.6399,-1.6362,
     9-1.6324,-1.6283,-1.6241,-1.6198,-1.6154,-1.6110,-1.6067,-1.6021/
      data (ap2154(i),i=  73, 101)/
     1-1.5972,-1.5921,-1.5868,-1.5814,-1.5759,-1.5700,-1.5636,-1.5569,
     2-1.5493,-1.5415,-1.5339,-1.5266,-1.5183,-1.5098,-1.5013,-1.4917,
     3-1.4805,-1.4696,-1.4581,-1.4463,-1.4347,-1.4221,-1.4061,-1.3876,
     4-1.3681,-1.3482,-1.3203,-1.2752,-1.0900/
c
      data (ap1   (i),i=   1,  72)/
     1-4.0000,-3.1513,-2.7803,-2.5668,-2.4246,-2.3120,-2.2246,-2.1568,
     2-2.0917,-2.0627,-2.0498,-2.0403,-2.0348,-2.0273,-2.0200,-2.0130,
     3-2.0062,-1.9993,-1.9924,-1.9850,-1.9771,-1.9702,-1.9639,-1.9570,
     4-1.9493,-1.9419,-1.9347,-1.9272,-1.9192,-1.9111,-1.9027,-1.8943,
     5-1.8859,-1.8772,-1.8682,-1.8590,-1.8501,-1.8418,-1.8337,-1.8260,
     6-1.8175,-1.8087,-1.7994,-1.7907,-1.7824,-1.7736,-1.7643,-1.7574,
     7-1.7516,-1.7465,-1.7413,-1.7367,-1.7325,-1.7283,-1.7245,-1.7208,
     8-1.7172,-1.7139,-1.7108,-1.7075,-1.7040,-1.7006,-1.6970,-1.6935,
     9-1.6899,-1.6863,-1.6826,-1.6788,-1.6751,-1.6716,-1.6682,-1.6651/
      data (ap1   (i),i=  73, 101)/
     1-1.6617,-1.6578,-1.6537,-1.6495,-1.6452,-1.6407,-1.6360,-1.6315,
     2-1.6269,-1.6227,-1.6182,-1.6130,-1.6073,-1.6011,-1.5938,-1.5865,
     3-1.5793,-1.5723,-1.5639,-1.5549,-1.5459,-1.5341,-1.5205,-1.5067,
     4-1.4925,-1.4694,-1.4429,-1.3994,-1.2100/
c
      data (ap0464(i),i=   1,  72)/
     1-5.0000,-3.8053,-3.4961,-3.3128,-3.1678,-3.0574,-2.9636,-2.8678,
     2-2.7757,-2.6950,-2.6249,-2.5642,-2.4943,-2.4446,-2.3858,-2.3522,
     3-2.3073,-2.2690,-2.2339,-2.2042,-2.1769,-2.1478,-2.1244,-2.1015,
     4-2.0749,-2.0585,-2.0535,-2.0465,-2.0392,-2.0324,-2.0263,-2.0216,
     5-2.0171,-2.0119,-2.0065,-2.0012,-1.9959,-1.9904,-1.9851,-1.9802,
     6-1.9756,-1.9707,-1.9656,-1.9604,-1.9554,-1.9504,-1.9456,-1.9406,
     7-1.9349,-1.9290,-1.9234,-1.9178,-1.9124,-1.9070,-1.9018,-1.8966,
     8-1.8911,-1.8855,-1.8798,-1.8740,-1.8680,-1.8619,-1.8556,-1.8493,
     9-1.8429,-1.8362,-1.8281,-1.8200,-1.8128,-1.8061,-1.7991,-1.7923/
      data (ap0464(i),i=  73, 101)/
     1-1.7847,-1.7767,-1.7688,-1.7610,-1.7540,-1.7475,-1.7411,-1.7350,
     2-1.7289,-1.7229,-1.7169,-1.7108,-1.7046,-1.6982,-1.6917,-1.6852,
     3-1.6788,-1.6725,-1.6658,-1.6588,-1.6514,-1.6442,-1.6348,-1.6237,
     4-1.6110,-1.5949,-1.5746,-1.5403,-1.4150/
c
      data (ap0215(i),i=   1,  72)/
     1-5.0000,-4.5064,-4.1967,-4.0393,-3.8975,-3.8213,-3.7483,-3.6870,
     2-3.6288,-3.5575,-3.5073,-3.4515,-3.4059,-3.3536,-3.3039,-3.2499,
     3-3.2091,-3.1749,-3.1333,-3.0889,-3.0561,-3.0180,-2.9818,-2.9510,
     4-2.9187,-2.8859,-2.8589,-2.8213,-2.8025,-2.7642,-2.7343,-2.7046,
     5-2.6741,-2.6403,-2.6128,-2.5873,-2.5611,-2.5279,-2.5009,-2.4741,
     6-2.4513,-2.4254,-2.4064,-2.3816,-2.3593,-2.3398,-2.3192,-2.3008,
     7-2.2843,-2.2687,-2.2538,-2.2349,-2.2175,-2.1995,-2.1829,-2.1704,
     8-2.1559,-2.1423,-2.1298,-2.1159,-2.1054,-2.0952,-2.0849,-2.0745,
     9-2.0648,-2.0559,-2.0477,-2.0393,-2.0308,-2.0229,-2.0153,-2.0079/
      data (ap0215(i),i=  73, 101)/
     1-2.0005,-1.9934,-1.9864,-1.9786,-1.9703,-1.9618,-1.9532,-1.9463,
     2-1.9391,-1.9321,-1.9245,-1.9153,-1.9066,-1.8988,-1.8892,-1.8790,
     3-1.8701,-1.8609,-1.8506,-1.8396,-1.8266,-1.8134,-1.8003,-1.7863,
     4-1.7704,-1.7525,-1.7354,-1.7135,-1.6550/
c
      data (ap01  (i),i=   1,  72)/
     1-5.7600,-4.7731,-4.5123,-4.3345,-4.1791,-4.0900,-4.0147,-3.9388,
     2-3.8928,-3.8322,-3.7778,-3.7288,-3.6825,-3.6451,-3.6116,-3.5723,
     3-3.5370,-3.5044,-3.4691,-3.4355,-3.3995,-3.3649,-3.3319,-3.3047,
     4-3.2662,-3.2404,-3.2163,-3.1826,-3.1522,-3.1258,-3.0955,-3.0628,
     5-3.0338,-3.0107,-2.9879,-2.9629,-2.9343,-2.9074,-2.8800,-2.8492,
     6-2.8219,-2.7967,-2.7665,-2.7491,-2.7181,-2.6950,-2.6716,-2.6495,
     7-2.6275,-2.6050,-2.5790,-2.5581,-2.5421,-2.5201,-2.5004,-2.4808,
     8-2.4654,-2.4492,-2.4327,-2.4167,-2.4041,-2.3901,-2.3773,-2.3622,
     9-2.3469,-2.3340,-2.3216,-2.3075,-2.2952,-2.2846,-2.2726,-2.2604/
      data (ap01  (i),i=  73, 101)/
     1-2.2505,-2.2384,-2.2278,-2.2189,-2.2043,-2.1938,-2.1831,-2.1725,
     2-2.1622,-2.1511,-2.1408,-2.1328,-2.1229,-2.1120,-2.1010,-2.0914,
     3-2.0812,-2.0705,-2.0610,-2.0512,-2.0406,-2.0312,-2.0229,-2.0160,
     4-2.0105,-2.0058,-2.0017,-1.9982,-1.9950/
c
      data (ap0046(i),i=   1,  72)/
     1-5.9100,-4.6196,-4.3422,-4.1633,-4.0372,-3.9661,-3.8840,-3.8169,
     2-3.7631,-3.7168,-3.6563,-3.6138,-3.5649,-3.5216,-3.4841,-3.4443,
     3-3.4065,-3.3771,-3.3450,-3.3096,-3.2819,-3.2511,-3.2244,-3.2013,
     4-3.1771,-3.1515,-3.1218,-3.0946,-3.0725,-3.0484,-3.0239,-3.0018,
     5-2.9774,-2.9571,-2.9344,-2.9192,-2.9005,-2.8793,-2.8598,-2.8433,
     6-2.8287,-2.8143,-2.7985,-2.7824,-2.7672,-2.7531,-2.7383,-2.7218,
     7-2.7060,-2.6900,-2.6772,-2.6665,-2.6520,-2.6365,-2.6231,-2.6113,
     8-2.5998,-2.5886,-2.5777,-2.5658,-2.5553,-2.5455,-2.5362,-2.5264,
     9-2.5162,-2.5052,-2.4967,-2.4887,-2.4802,-2.4714,-2.4625,-2.4538/
      data (ap0046(i),i=  73, 101)/
     1-2.4454,-2.4390,-2.4338,-2.4277,-2.4215,-2.4149,-2.4076,-2.4002,
     2-2.3928,-2.3852,-2.3787,-2.3734,-2.3698,-2.3660,-2.3631,-2.3607,
     3-2.3604,-2.3617,-2.3593,-2.3569,-2.3540,-2.3509,-2.3477,-2.3443,
     4-2.3407,-2.3369,-2.3331,-2.3291,-2.3250/
c
      data (ap0021(i),i=   1,  72)/
     1-5.9700,-4.8258,-4.5108,-4.3118,-4.1800,-4.0765,-4.0017,-3.9322,
     2-3.8661,-3.8196,-3.7741,-3.7326,-3.6891,-3.6486,-3.6154,-3.5830,
     3-3.5585,-3.5313,-3.5036,-3.4752,-3.4574,-3.4346,-3.4124,-3.3876,
     4-3.3678,-3.3478,-3.3278,-3.3076,-3.2905,-3.2743,-3.2587,-3.2429,
     5-3.2274,-3.2103,-3.1947,-3.1790,-3.1657,-3.1512,-3.1348,-3.1181,
     6-3.1070,-3.0950,-3.0818,-3.0679,-3.0545,-3.0428,-3.0319,-3.0190,
     7-3.0058,-2.9930,-2.9814,-2.9711,-2.9607,-2.9490,-2.9365,-2.9245,
     8-2.9150,-2.9050,-2.8945,-2.8851,-2.8763,-2.8679,-2.8592,-2.8503,
     9-2.8419,-2.8337,-2.8261,-2.8183,-2.8097,-2.8015,-2.7939,-2.7859/
      data (ap0021(i),i=  73, 101)/
     1-2.7774,-2.7668,-2.7553,-2.7473,-2.7447,-2.7416,-2.7361,-2.7332,
     2-2.7311,-2.7300,-2.7276,-2.7252,-2.7240,-2.7232,-2.7203,-2.7187,
     3-2.7165,-2.7142,-2.7119,-2.7092,-2.7063,-2.7032,-2.6997,-2.6957,
     4-2.6940,-2.6787,-2.6652,-2.6621,-2.6550/
c
      data (ap001 (i),i=   1,  72)/
     1-5.9850,-5.0922,-4.7650,-4.6065,-4.4698,-4.3685,-4.2958,-4.2246,
     2-4.1624,-4.1094,-4.0617,-4.0194,-3.9844,-3.9486,-3.9162,-3.8900,
     3-3.8633,-3.8371,-3.8107,-3.7851,-3.7653,-3.7438,-3.7226,-3.7015,
     4-3.6818,-3.6631,-3.6455,-3.6301,-3.6156,-3.5990,-3.5829,-3.5681,
     5-3.5515,-3.5392,-3.5269,-3.5115,-3.4973,-3.4856,-3.4730,-3.4601,
     6-3.4482,-3.4373,-3.4249,-3.4122,-3.3999,-3.3886,-3.3781,-3.3662,
     7-3.3538,-3.3419,-3.3324,-3.3221,-3.3117,-3.3015,-3.2914,-3.2815,
     8-3.2717,-3.2610,-3.2503,-3.2396,-3.2298,-3.2195,-3.2088,-3.1985,
     9-3.1859,-3.1733,-3.1622,-3.1540,-3.1497,-3.1442,-3.1394,-3.1354/
      data (ap001 (i),i=  73, 101)/
     1-3.1317,-3.1283,-3.1248,-3.1218,-3.1190,-3.1164,-3.1139,-3.1120,
     2-3.1094,-3.1068,-3.1040,-3.1015,-3.0987,-3.0962,-3.0927,-3.0887,
     3-3.0845,-3.0800,-3.0755,-3.0709,-3.0662,-3.0613,-3.0564,-3.0500,
     4-3.0400,-3.0303,-3.0205,-3.0146,-3.0000/
c

      data zr/.723,.750,.795,.820, .789, .720,
     *       .640, .580, .521, .50, .475, .460, .457/
c
c
         el=log10(e)
         call rndc(u)
         call kintp3(zr, 1, nes, -3.d0, .25d0, el, rr)
         if(u .lt. rr) then
            de=0.
         else
            call rndc(u)
            call k4ptdi(b, 101, ne, 101, 0.d0, -3.d0, hx, hy,
     *      u, el, f)
            de = 10.d0**f
         endif
      end
