	subroutine ciP5F1S35C70(cs, e1, e2, desingle)
	implicit none
	real*8 cs ! output.  cos
	real*8 e1  ! output  low end of energy
        real*8 e2  ! output   high end of energy
	real*8 desingle  ! output  energy deposit by single muon
                         !       in GeV with cos angle
c    Pb=0.5cm
c    Fe=0.1cm
c    Scinti = 3.5cm
c    Cos=0.70
c    energy 0.001 GeV to 1 GeV
c    slant Single Eqv. 1.2e-2 GeV
c

	cs = 0.70
	e1 = 1.d-3
	e2 = 1.
	desingle = 1.2e-2
      end
      subroutine cemP5F1S35C70(e, de)
      implicit none
c           this is for e- incident
c
      real*8 e  ! input   electron energy in GeV.
      real*8 de  ! output  energy deposit in Scinti in GeV*cos(angle)

      integer ne, i
      integer nes
      parameter (nes=13)
      parameter(ne=10)

      real*8 zr(nes)
      real*8 u, el, rr

      real*8 hx, hy, f



      real*8 b(101,ne), b1(101),
     * bp4640(101), bp2154(101),bp1(101),             bp0464(101),
     *              bp0215(101), bp01(101), bp0046(101),
     *          bp0021(101), bp001(101)
      equivalence (b(1,ne- 9), bp001(1))
      equivalence (b(1,ne- 8), bp0021(1))
      equivalence (b(1,ne-7), bp0046(1))
      equivalence (b(1,ne-6), bp01(1))
      equivalence (b(1,ne-5), bp0215(1))
      equivalence (b(1,ne-4), bp0464(1))
      equivalence (b(1,ne-3), bp1(1))
      equivalence (b(1,ne-2), bp2154(1))
      equivalence (b(1,ne-1), bp4640(1))
      equivalence (b(1,ne  ), b1(1))
c
	data hx/0.01d0/, hy/0.3333333333d0/
c
      data (b1    (i),i=   1,  72)/
     1-4.5950,-2.3008,-2.2155,-2.1923,-2.1712,-2.1556,-2.1389,-2.1210,
     2-2.1041,-2.0836,-2.0667,-2.0472,-2.0221,-1.9980,-1.9776,-1.9569,
     3-1.9343,-1.9121,-1.8889,-1.8712,-1.8565,-1.8400,-1.8241,-1.8106,
     4-1.7973,-1.7837,-1.7702,-1.7582,-1.7465,-1.7364,-1.7261,-1.7154,
     5-1.7058,-1.6970,-1.6886,-1.6803,-1.6723,-1.6652,-1.6587,-1.6515,
     6-1.6441,-1.6366,-1.6288,-1.6217,-1.6154,-1.6086,-1.6014,-1.5944,
     7-1.5874,-1.5805,-1.5734,-1.5661,-1.5593,-1.5528,-1.5465,-1.5405,
     8-1.5340,-1.5264,-1.5192,-1.5123,-1.5056,-1.4987,-1.4918,-1.4852,
     9-1.4790,-1.4721,-1.4647,-1.4575,-1.4511,-1.4446,-1.4381,-1.4316/
      data (b1    (i),i=  73, 101)/
     1-1.4250,-1.4185,-1.4120,-1.4057,-1.3990,-1.3915,-1.3841,-1.3765,
     2-1.3690,-1.3618,-1.3541,-1.3454,-1.3370,-1.3290,-1.3205,-1.3113,
     3-1.2999,-1.2895,-1.2801,-1.2690,-1.2579,-1.2461,-1.2320,-1.2151,
     4-1.1991,-1.1760,-1.1489,-1.1114,-0.9050/
c
      data (bp4640(i),i=   1,  72)/
     1-4.0000,-3.1272,-2.5518,-2.2958,-2.2348,-2.2081,-2.1942,-2.1778,
     2-2.1657,-2.1548,-2.1405,-2.1304,-2.1199,-2.1090,-2.0982,-2.0865,
     3-2.0732,-2.0599,-2.0495,-2.0377,-2.0220,-2.0090,-1.9946,-1.9801,
     4-1.9671,-1.9532,-1.9386,-1.9261,-1.9142,-1.9012,-1.8912,-1.8821,
     5-1.8721,-1.8615,-1.8509,-1.8404,-1.8293,-1.8192,-1.8099,-1.7993,
     6-1.7900,-1.7819,-1.7727,-1.7634,-1.7542,-1.7458,-1.7383,-1.7302,
     7-1.7218,-1.7141,-1.7069,-1.6998,-1.6929,-1.6860,-1.6791,-1.6721,
     8-1.6649,-1.6580,-1.6517,-1.6453,-1.6382,-1.6310,-1.6244,-1.6182,
     9-1.6119,-1.6056,-1.5989,-1.5916,-1.5846,-1.5782,-1.5726,-1.5658/
      data (bp4640(i),i=  73, 101)/
     1-1.5583,-1.5513,-1.5451,-1.5387,-1.5323,-1.5259,-1.5193,-1.5124,
     2-1.5050,-1.4971,-1.4888,-1.4803,-1.4724,-1.4642,-1.4549,-1.4454,
     3-1.4357,-1.4256,-1.4144,-1.4028,-1.3926,-1.3819,-1.3693,-1.3525,
     4-1.3349,-1.3153,-1.2906,-1.2421,-1.0150/
c
      data (bp2154(i),i=   1,  72)/
     1-4.0000,-3.5917,-3.2362,-2.9431,-2.7302,-2.5379,-2.3933,-2.3189,
     2-2.2853,-2.2614,-2.2457,-2.2339,-2.2218,-2.2100,-2.1993,-2.1902,
     3-2.1805,-2.1695,-2.1613,-2.1541,-2.1469,-2.1395,-2.1314,-2.1231,
     4-2.1145,-2.1067,-2.0995,-2.0920,-2.0838,-2.0756,-2.0675,-2.0590,
     5-2.0504,-2.0422,-2.0338,-2.0254,-2.0165,-2.0070,-1.9993,-1.9922,
     6-1.9832,-1.9740,-1.9654,-1.9566,-1.9475,-1.9394,-1.9317,-1.9232,
     7-1.9141,-1.9044,-1.8957,-1.8883,-1.8807,-1.8730,-1.8655,-1.8583,
     8-1.8503,-1.8419,-1.8342,-1.8268,-1.8189,-1.8107,-1.8025,-1.7944,
     9-1.7868,-1.7795,-1.7720,-1.7646,-1.7581,-1.7517,-1.7448,-1.7375/
      data (bp2154(i),i=  73, 101)/
     1-1.7301,-1.7227,-1.7156,-1.7090,-1.7019,-1.6941,-1.6857,-1.6765,
     2-1.6688,-1.6616,-1.6535,-1.6452,-1.6368,-1.6284,-1.6210,-1.6120,
     3-1.6011,-1.5900,-1.5788,-1.5658,-1.5515,-1.5396,-1.5247,-1.5088,
     4-1.4898,-1.4703,-1.4394,-1.3923,-1.1950/
c
      data (bp1   (i),i=   1,  72)/
     1-5.0000,-4.1761,-3.8133,-3.6339,-3.4633,-3.3114,-3.2030,-3.0788,
     2-2.9736,-2.8795,-2.8019,-2.7162,-2.6393,-2.5712,-2.5251,-2.4794,
     3-2.4271,-2.3840,-2.3547,-2.3330,-2.3159,-2.3010,-2.2906,-2.2798,
     4-2.2694,-2.2596,-2.2513,-2.2437,-2.2362,-2.2288,-2.2217,-2.2147,
     5-2.2080,-2.2016,-2.1946,-2.1873,-2.1796,-2.1716,-2.1646,-2.1582,
     6-2.1517,-2.1453,-2.1390,-2.1329,-2.1266,-2.1199,-2.1129,-2.1062,
     7-2.1001,-2.0936,-2.0861,-2.0789,-2.0718,-2.0650,-2.0584,-2.0524,
     8-2.0451,-2.0374,-2.0306,-2.0246,-2.0180,-2.0110,-2.0037,-1.9957,
     9-1.9879,-1.9801,-1.9724,-1.9650,-1.9576,-1.9504,-1.9429,-1.9348/
      data (bp1   (i),i=  73, 101)/
     1-1.9268,-1.9191,-1.9110,-1.9025,-1.8946,-1.8875,-1.8793,-1.8704,
     2-1.8608,-1.8513,-1.8419,-1.8327,-1.8234,-1.8134,-1.8025,-1.7914,
     3-1.7803,-1.7691,-1.7568,-1.7443,-1.7316,-1.7168,-1.7019,-1.6850,
     4-1.6640,-1.6354,-1.6049,-1.5592,-1.3000/
c
      data (bp0464(i),i=   1,  72)/
     1-5.0000,-4.5229,-4.3010,-4.1549,-4.0100,-3.9106,-3.8432,-3.7719,
     2-3.6879,-3.6310,-3.5667,-3.5082,-3.4550,-3.4047,-3.3611,-3.3144,
     3-3.2746,-3.2405,-3.1964,-3.1571,-3.1195,-3.0819,-3.0460,-3.0203,
     4-2.9842,-2.9514,-2.9254,-2.8921,-2.8615,-2.8329,-2.8094,-2.7779,
     5-2.7484,-2.7239,-2.7002,-2.6717,-2.6470,-2.6214,-2.6015,-2.5772,
     6-2.5531,-2.5310,-2.5137,-2.4915,-2.4692,-2.4445,-2.4234,-2.4013,
     7-2.3843,-2.3722,-2.3600,-2.3486,-2.3397,-2.3307,-2.3217,-2.3130,
     8-2.3046,-2.2964,-2.2880,-2.2789,-2.2707,-2.2635,-2.2562,-2.2488,
     9-2.2416,-2.2346,-2.2274,-2.2203,-2.2129,-2.2051,-2.1976,-2.1907/
      data (bp0464(i),i=  73, 101)/
     1-2.1838,-2.1769,-2.1699,-2.1630,-2.1556,-2.1470,-2.1386,-2.1307,
     2-2.1225,-2.1136,-2.1047,-2.0957,-2.0857,-2.0751,-2.0641,-2.0528,
     3-2.0406,-2.0259,-2.0135,-1.9992,-1.9823,-1.9666,-1.9479,-1.9309,
     4-1.9120,-1.8872,-1.8625,-1.8065,-1.6450/
c
      data (bp0215(i),i=   1,  72)/
     1-5.3010,-5.0336,-4.8077,-4.6035,-4.4763,-4.3849,-4.2907,-4.2327,
     2-4.1866,-4.1326,-4.0941,-4.0488,-4.0155,-3.9762,-3.9381,-3.9073,
     3-3.8765,-3.8509,-3.8180,-3.7858,-3.7603,-3.7358,-3.7167,-3.6952,
     4-3.6684,-3.6467,-3.6268,-3.6016,-3.5721,-3.5509,-3.5305,-3.5143,
     5-3.4930,-3.4717,-3.4513,-3.4276,-3.4074,-3.3879,-3.3675,-3.3450,
     6-3.3241,-3.3090,-3.2897,-3.2701,-3.2510,-3.2345,-3.2127,-3.1978,
     7-3.1809,-3.1632,-3.1412,-3.1246,-3.1056,-3.0877,-3.0738,-3.0569,
     8-3.0421,-3.0258,-3.0060,-2.9873,-2.9669,-2.9473,-2.9285,-2.9076,
     9-2.8871,-2.8717,-2.8509,-2.8324,-2.8088,-2.7877,-2.7717,-2.7508/
      data (bp0215(i),i=  73, 101)/
     1-2.7308,-2.7065,-2.6880,-2.6751,-2.6555,-2.6348,-2.6143,-2.5940,
     2-2.5748,-2.5541,-2.5331,-2.5114,-2.4890,-2.4686,-2.4491,-2.4264,
     3-2.4039,-2.3839,-2.3632,-2.3435,-2.3239,-2.3055,-2.2859,-2.2675,
     4-2.2418,-2.2150,-2.1894,-2.1465,-2.0000/
c
      data (bp01  (i),i=   1,  72)/
     1-6.0000,-5.2718,-4.9860,-4.8364,-4.7101,-4.6314,-4.5264,-4.4569,
     2-4.4014,-4.3566,-4.3194,-4.2761,-4.2479,-4.2278,-4.2001,-4.1586,
     3-4.1266,-4.0932,-4.0746,-4.0529,-4.0317,-4.0013,-3.9745,-3.9476,
     4-3.9264,-3.9082,-3.8905,-3.8755,-3.8588,-3.8443,-3.8243,-3.8087,
     5-3.7948,-3.7798,-3.7620,-3.7454,-3.7263,-3.7084,-3.6913,-3.6791,
     6-3.6589,-3.6426,-3.6269,-3.6111,-3.5988,-3.5820,-3.5673,-3.5490,
     7-3.5335,-3.5187,-3.5059,-3.4878,-3.4726,-3.4578,-3.4422,-3.4310,
     8-3.4182,-3.4037,-3.3890,-3.3745,-3.3587,-3.3464,-3.3352,-3.3208,
     9-3.3096,-3.2958,-3.2836,-3.2672,-3.2507,-3.2385,-3.2193,-3.2011/
      data (bp01  (i),i=  73, 101)/
     1-3.1872,-3.1726,-3.1539,-3.1395,-3.1220,-3.1053,-3.0885,-3.0692,
     2-3.0510,-3.0342,-3.0186,-2.9957,-2.9802,-2.9591,-2.9387,-2.9243,
     3-2.8991,-2.8817,-2.8508,-2.8242,-2.7981,-2.7680,-2.7406,-2.7100,
     4-2.6732,-2.6107,-2.5547,-2.4855,-2.2400/
c
      data (bp0046(i),i=   1,  72)/
     1-5.9700,-5.4618,-5.2722,-5.1042,-4.9923,-4.8360,-4.7508,-4.6776,
     2-4.6008,-4.5415,-4.4928,-4.4148,-4.3778,-4.3539,-4.3143,-4.2844,
     3-4.2539,-4.2132,-4.1857,-4.1606,-4.1397,-4.1218,-4.0878,-4.0697,
     4-4.0420,-4.0299,-4.0141,-3.9966,-3.9686,-3.9560,-3.9418,-3.9262,
     5-3.9147,-3.8982,-3.8781,-3.8643,-3.8470,-3.8378,-3.8371,-3.8106,
     6-3.7975,-3.7884,-3.7764,-3.7629,-3.7520,-3.7398,-3.7285,-3.7164,
     7-3.7018,-3.6890,-3.6781,-3.6660,-3.6546,-3.6439,-3.6316,-3.6215,
     8-3.6110,-3.5997,-3.5840,-3.5711,-3.5571,-3.5467,-3.5368,-3.5251,
     9-3.5159,-3.5061,-3.4940,-3.4789,-3.4610,-3.4467,-3.4332,-3.4246/
      data (bp0046(i),i=  73, 101)/
     1-3.4128,-3.3994,-3.3827,-3.3636,-3.3472,-3.3360,-3.3273,-3.3197,
     2-3.3044,-3.2898,-3.2709,-3.2567,-3.2467,-3.2198,-3.2097,-3.1990,
     3-3.1824,-3.1655,-3.1460,-3.1290,-3.1067,-3.0854,-3.0589,-3.0335,
     4-2.9701,-2.9455,-2.8891,-2.7957,-2.6250/
c
      data (bp0021(i),i=   1,  72)/
     1-5.8650,-5.4795,-5.0596,-4.9509,-4.9287,-4.8480,-4.7813,-4.6900,
     2-4.6248,-4.5804,-4.5360,-4.4916,-4.4611,-4.4178,-4.3754,-4.3442,
     3-4.3295,-4.3038,-4.2947,-4.2732,-4.2510,-4.2319,-4.2141,-4.1968,
     4-4.1695,-4.1400,-4.1123,-4.1004,-4.0872,-4.0805,-4.0742,-4.0593,
     5-4.0424,-4.0316,-4.0010,-3.9803,-3.9699,-3.9618,-3.9482,-3.9267,
     6-3.9227,-3.9254,-3.8893,-3.8796,-3.8691,-3.8580,-3.8497,-3.8447,
     7-3.8368,-3.8276,-3.8200,-3.8184,-3.8031,-3.7825,-3.7811,-3.7783,
     8-3.7850,-3.7671,-3.7459,-3.7327,-3.7263,-3.7213,-3.7118,-3.6976,
     9-3.6845,-3.6731,-3.6582,-3.6436,-3.6329,-3.6277,-3.6248,-3.6577/
      data (bp0021(i),i=  73, 101)/
     1-3.6468,-3.5991,-3.5833,-3.5820,-3.5729,-3.5652,-3.5704,-3.5276,
     2-3.5319,-3.5262,-3.5142,-3.4713,-3.4622,-3.4513,-3.4420,-3.4334,
     3-3.4246,-3.4217,-3.4145,-3.3783,-3.3687,-3.3258,-3.3203,-3.2951,
     4-3.2918,-3.2232,-3.1788,-3.1195,-2.9850/
      data bp001/5*-6., 6*-5.,90*-4.5/
c

       data zr/1.00, 1.00, .965,.890, .746, .50,
     *          .260, .110, .436, .020, .01, 0.0064, 0.0032/
c
c
         el=log10(e)
         call rndc(u)
         call kintp3(zr, 1, nes, -3.d0, .25d0, el, rr)
         if(u .lt. rr) then
            de=0.
         else
            call rndc(u)
            call k4ptdi(b, 101, ne, 101, 0.d0, -3.d0, hx, hy,
     *      u, el, f)
            de=10.d0**f
         endif
      end
      subroutine cepP5F1S35C70(e, de)
	implicit none
	real*8 e, de
c            e+
          call cemP5F1S35C70(e, de)
         if(e .lt. .021) then
c                correction; 10% increase at 10 mev
              de=de* (1. + (.021-e)*10.)
         endif
      end
      subroutine cgP5F1S35C70(e, de)
      implicit none
c           this is for g  incident
c
      real*8 e, de

      integer ne, i
      integer nes
      parameter (nes=13)
      parameter(ne=10)
      
      real*8 u, el, rr

      real*8 hx, hy, f

      real*8 zr(nes)

c
c

      real*8 b(101,ne), b1(101),
     * bp4640(101), bp2154(101),bp1(101),            bp0464(101),
     *              bp0215(101), bp01(101), bp0046(101),
     *          bp0021(101), bp001(101)
c
      equivalence (b(1,ne-9 ), bp001(1))
      equivalence (b(1,ne-8 ), bp0021(1))
      equivalence (b(1,ne-7), bp0046(1))
      equivalence (b(1,ne-6), bp01(1))
      equivalence (b(1,ne-5), bp0215(1))
c     equivalence (b(1,ne-6), bp0316(1))
      equivalence (b(1,ne-4), bp0464(1))
c     equivalence (b(1,ne-4), bp065(1))
      equivalence (b(1,ne-3), bp1(1))
      equivalence (b(1,ne-2), bp2154(1))
      equivalence (b(1,ne-1), bp4640(1))
      equivalence (b(1,ne  ), b1(1))
c
	data hx/0.01d0/, hy/0.333333333333d0/

      data (b1    (i),i=   1,  72)/
     1-5.0000,-2.5502,-2.2624,-2.1739,-2.1181,-2.0606,-1.9997,-1.9585,
     2-1.9312,-1.9166,-1.9073,-1.8995,-1.8937,-1.8881,-1.8832,-1.8779,
     3-1.8726,-1.8672,-1.8619,-1.8566,-1.8514,-1.8461,-1.8408,-1.8354,
     4-1.8297,-1.8239,-1.8179,-1.8117,-1.8054,-1.7987,-1.7918,-1.7852,
     5-1.7788,-1.7721,-1.7651,-1.7576,-1.7494,-1.7415,-1.7340,-1.7257,
     6-1.7167,-1.7082,-1.6998,-1.6911,-1.6824,-1.6741,-1.6656,-1.6572,
     7-1.6485,-1.6397,-1.6319,-1.6244,-1.6166,-1.6089,-1.6012,-1.5935,
     8-1.5856,-1.5776,-1.5692,-1.5611,-1.5535,-1.5467,-1.5406,-1.5341,
     9-1.5263,-1.5185,-1.5105,-1.5030,-1.4965,-1.4896,-1.4822,-1.4746/
      data (b1    (i),i=  73, 101)/
     1-1.4668,-1.4587,-1.4504,-1.4421,-1.4342,-1.4266,-1.4198,-1.4118,
     2-1.4023,-1.3932,-1.3842,-1.3756,-1.3668,-1.3580,-1.3463,-1.3356,
     3-1.3262,-1.3149,-1.3041,-1.2920,-1.2771,-1.2649,-1.2516,-1.2344,
     4-1.2124,-1.1888,-1.1619,-1.1147,-0.9500/
c
      data (bp4640(i),i=   1,  72)/
     1-4.7750,-2.5666,-2.2527,-2.2004,-2.1629,-2.1322,-2.1028,-2.0715,
     2-2.0383,-2.0160,-1.9890,-1.9710,-1.9533,-1.9396,-1.9282,-1.9190,
     3-1.9121,-1.9062,-1.9004,-1.8954,-1.8905,-1.8859,-1.8813,-1.8767,
     4-1.8722,-1.8677,-1.8632,-1.8587,-1.8543,-1.8497,-1.8449,-1.8399,
     5-1.8351,-1.8304,-1.8260,-1.8214,-1.8165,-1.8115,-1.8066,-1.8016,
     6-1.7968,-1.7919,-1.7869,-1.7818,-1.7766,-1.7708,-1.7649,-1.7589,
     7-1.7529,-1.7468,-1.7407,-1.7345,-1.7282,-1.7215,-1.7149,-1.7083,
     8-1.7019,-1.6950,-1.6879,-1.6806,-1.6729,-1.6659,-1.6594,-1.6528,
     9-1.6465,-1.6395,-1.6310,-1.6227,-1.6158,-1.6094,-1.6042,-1.5983/
      data (bp4640(i),i=  73, 101)/
     1-1.5901,-1.5806,-1.5734,-1.5673,-1.5600,-1.5525,-1.5452,-1.5387,
     2-1.5306,-1.5215,-1.5122,-1.5031,-1.4955,-1.4874,-1.4779,-1.4681,
     3-1.4572,-1.4453,-1.4343,-1.4222,-1.4085,-1.3942,-1.3794,-1.3628,
     4-1.3436,-1.3215,-1.2872,-1.2441,-1.0400/
c
      data (bp2154(i),i=   1,  72)/
     1-5.0000,-3.0023,-2.6131,-2.4070,-2.2929,-2.2427,-2.2155,-2.1951,
     2-2.1791,-2.1626,-2.1488,-2.1350,-2.1196,-2.1053,-2.0899,-2.0759,
     3-2.0622,-2.0492,-2.0376,-2.0249,-2.0101,-1.9956,-1.9829,-1.9681,
     4-1.9593,-1.9515,-1.9428,-1.9349,-1.9284,-1.9223,-1.9165,-1.9112,
     5-1.9063,-1.9020,-1.8979,-1.8936,-1.8891,-1.8847,-1.8803,-1.8760,
     6-1.8718,-1.8678,-1.8638,-1.8602,-1.8566,-1.8530,-1.8493,-1.8453,
     7-1.8411,-1.8368,-1.8320,-1.8269,-1.8222,-1.8176,-1.8132,-1.8091,
     8-1.8047,-1.8002,-1.7960,-1.7913,-1.7858,-1.7798,-1.7743,-1.7692,
     9-1.7645,-1.7595,-1.7544,-1.7495,-1.7441,-1.7379,-1.7313,-1.7238/
      data (bp2154(i),i=  73, 101)/
     1-1.7161,-1.7090,-1.7022,-1.6957,-1.6892,-1.6826,-1.6762,-1.6694,
     2-1.6616,-1.6540,-1.6469,-1.6391,-1.6298,-1.6205,-1.6110,-1.6021,
     3-1.5934,-1.5851,-1.5727,-1.5606,-1.5507,-1.5377,-1.5240,-1.5074,
     4-1.4889,-1.4677,-1.4443,-1.3838,-1.2200/
c
      data (bp1   (i),i=   1,  72)/
     1-5.0000,-3.7109,-3.3901,-3.1123,-2.9335,-2.7699,-2.6441,-2.5500,
     2-2.4637,-2.3943,-2.3501,-2.3179,-2.2964,-2.2808,-2.2672,-2.2515,
     3-2.2386,-2.2283,-2.2179,-2.2076,-2.1984,-2.1897,-2.1815,-2.1735,
     4-2.1656,-2.1579,-2.1501,-2.1416,-2.1334,-2.1263,-2.1191,-2.1120,
     5-2.1048,-2.0977,-2.0896,-2.0794,-2.0706,-2.0642,-2.0571,-2.0498,
     6-2.0425,-2.0352,-2.0278,-2.0202,-2.0123,-2.0040,-1.9962,-1.9888,
     7-1.9815,-1.9742,-1.9673,-1.9615,-1.9559,-1.9499,-1.9438,-1.9382,
     8-1.9330,-1.9279,-1.9225,-1.9167,-1.9110,-1.9052,-1.8995,-1.8939,
     9-1.8885,-1.8833,-1.8783,-1.8735,-1.8688,-1.8639,-1.8589,-1.8538/
      data (bp1   (i),i=  73, 101)/
     1-1.8489,-1.8440,-1.8395,-1.8344,-1.8285,-1.8226,-1.8168,-1.8109,
     2-1.8050,-1.7989,-1.7930,-1.7863,-1.7792,-1.7719,-1.7642,-1.7561,
     3-1.7470,-1.7356,-1.7241,-1.7129,-1.7026,-1.6902,-1.6748,-1.6594,
     4-1.6414,-1.6193,-1.5947,-1.5545,-1.3550/
c
      data (bp0464(i),i=   1,  72)/
     1-5.0000,-4.3095,-4.0348,-3.8397,-3.7073,-3.6100,-3.5128,-3.4224,
     2-3.3383,-3.2459,-3.1652,-3.0996,-3.0456,-2.9956,-2.9416,-2.8904,
     3-2.8396,-2.7930,-2.7433,-2.7115,-2.6693,-2.6336,-2.6034,-2.5693,
     4-2.5327,-2.5033,-2.4718,-2.4440,-2.4146,-2.3915,-2.3718,-2.3543,
     5-2.3424,-2.3312,-2.3212,-2.3113,-2.3013,-2.2916,-2.2821,-2.2737,
     6-2.2661,-2.2593,-2.2520,-2.2444,-2.2371,-2.2303,-2.2234,-2.2166,
     7-2.2096,-2.2023,-2.1948,-2.1881,-2.1820,-2.1747,-2.1670,-2.1601,
     8-2.1537,-2.1468,-2.1396,-2.1326,-2.1258,-2.1188,-2.1110,-2.1032,
     9-2.0954,-2.0876,-2.0802,-2.0724,-2.0638,-2.0550,-2.0462,-2.0376/
      data (bp0464(i),i=  73, 101)/
     1-2.0290,-2.0199,-2.0106,-2.0009,-1.9925,-1.9846,-1.9761,-1.9678,
     2-1.9604,-1.9518,-1.9418,-1.9325,-1.9236,-1.9153,-1.9068,-1.8982,
     3-1.8868,-1.8758,-1.8652,-1.8543,-1.8430,-1.8312,-1.8185,-1.8054,
     4-1.7870,-1.7627,-1.7364,-1.6953,-1.5200/
c
      data (bp0215(i),i=   1,  72)/
     1-5.9850,-4.8315,-4.5608,-4.3996,-4.2674,-4.1784,-4.0900,-4.0165,
     2-3.9375,-3.8731,-3.8182,-3.7766,-3.7261,-3.6968,-3.6515,-3.6063,
     3-3.5664,-3.5358,-3.4997,-3.4644,-3.4252,-3.3870,-3.3547,-3.3123,
     4-3.2797,-3.2490,-3.2158,-3.1834,-3.1485,-3.1170,-3.0855,-3.0576,
     5-3.0270,-2.9983,-2.9667,-2.9338,-2.9027,-2.8733,-2.8470,-2.8217,
     6-2.7934,-2.7665,-2.7390,-2.7106,-2.6842,-2.6628,-2.6416,-2.6181,
     7-2.5930,-2.5707,-2.5509,-2.5293,-2.5073,-2.4867,-2.4661,-2.4460,
     8-2.4270,-2.4075,-2.3904,-2.3745,-2.3610,-2.3493,-2.3388,-2.3295,
     9-2.3190,-2.3073,-2.2996,-2.2908,-2.2816,-2.2732,-2.2646,-2.2544/
      data (bp0215(i),i=  73, 101)/
     1-2.2452,-2.2363,-2.2264,-2.2165,-2.2067,-2.1972,-2.1881,-2.1794,
     2-2.1696,-2.1590,-2.1493,-2.1371,-2.1249,-2.1138,-2.1028,-2.0901,
     3-2.0775,-2.0649,-2.0519,-2.0386,-2.0218,-2.0068,-1.9930,-1.9751,
     4-1.9541,-1.9284,-1.9009,-1.8707,-1.8150/
c
      data (bp01  (i),i=   1,  72)/
     1-5.5229,-5.0429,-4.7918,-4.5846,-4.4659,-4.3713,-4.2789,-4.2085,
     2-4.1428,-4.1042,-4.0443,-3.9973,-3.9575,-3.9192,-3.8784,-3.8396,
     3-3.7952,-3.7632,-3.7223,-3.6843,-3.6455,-3.6104,-3.5776,-3.5460,
     4-3.5096,-3.4764,-3.4499,-3.4173,-3.3823,-3.3531,-3.3225,-3.2946,
     5-3.2667,-3.2358,-3.2043,-3.1802,-3.1494,-3.1252,-3.1007,-3.0725,
     6-3.0531,-3.0303,-3.0063,-2.9801,-2.9471,-2.9249,-2.8935,-2.8746,
     7-2.8467,-2.8305,-2.8107,-2.7908,-2.7700,-2.7465,-2.7236,-2.7064,
     8-2.6824,-2.6650,-2.6484,-2.6301,-2.6108,-2.5925,-2.5781,-2.5642,
     9-2.5495,-2.5359,-2.5212,-2.5080,-2.4953,-2.4829,-2.4643,-2.4507/
      data (bp01  (i),i=  73, 101)/
     1-2.4386,-2.4244,-2.4127,-2.4019,-2.3885,-2.3770,-2.3666,-2.3562,
     2-2.3457,-2.3319,-2.3205,-2.3106,-2.3008,-2.2901,-2.2793,-2.2688,
     3-2.2589,-2.2495,-2.2410,-2.2295,-2.2156,-2.2026,-2.1922,-2.1839,
     4-2.1752,-2.1664,-2.1589,-2.1532,-2.1500/
c
      data (bp0046(i),i=   1,  72)/
     1-5.9550,-5.0157,-4.6343,-4.4404,-4.3259,-4.2129,-4.1223,-4.0591,
     2-3.9935,-3.9429,-3.8959,-3.8472,-3.8048,-3.7603,-3.7252,-3.6844,
     3-3.6476,-3.6096,-3.5639,-3.5251,-3.4948,-3.4676,-3.4359,-3.4048,
     4-3.3764,-3.3521,-3.3281,-3.3047,-3.2803,-3.2501,-3.2295,-3.2068,
     5-3.1867,-3.1657,-3.1411,-3.1215,-3.1023,-3.0805,-3.0630,-3.0446,
     6-3.0268,-3.0073,-2.9875,-2.9737,-2.9588,-2.9438,-2.9267,-2.9126,
     7-2.8960,-2.8818,-2.8647,-2.8539,-2.8407,-2.8281,-2.8146,-2.8004,
     8-2.7887,-2.7761,-2.7636,-2.7519,-2.7406,-2.7292,-2.7192,-2.7089,
     9-2.6985,-2.6899,-2.6803,-2.6701,-2.6604,-2.6512,-2.6424,-2.6338/
      data (bp0046(i),i=  73, 101)/
     1-2.6247,-2.6139,-2.6039,-2.5954,-2.5880,-2.5811,-2.5734,-2.5653,
     2-2.5590,-2.5538,-2.5483,-2.5430,-2.5379,-2.5331,-2.5290,-2.5267,
     3-2.5240,-2.5218,-2.5189,-2.5180,-2.5160,-2.5175,-2.5107,-2.5028,
     4-2.4945,-2.4867,-2.4803,-2.4761,-2.4750/
c
      data (bp0021(i),i=   1,  72)/
     1-5.9850,-4.9311,-4.6473,-4.4935,-4.3666,-4.2692,-4.1902,-4.1181,
     2-4.0590,-4.0050,-3.9607,-3.9182,-3.8801,-3.8437,-3.8014,-3.7689,
     3-3.7416,-3.7123,-3.6828,-3.6539,-3.6262,-3.5987,-3.5740,-3.5499,
     4-3.5237,-3.4991,-3.4822,-3.4633,-3.4420,-3.4244,-3.4069,-3.3874,
     5-3.3715,-3.3542,-3.3392,-3.3259,-3.3121,-3.2978,-3.2809,-3.2672,
     6-3.2541,-3.2420,-3.2300,-3.2178,-3.2055,-3.1932,-3.1821,-3.1707,
     7-3.1597,-3.1490,-3.1383,-3.1271,-3.1159,-3.1055,-3.0960,-3.0850,
     8-3.0722,-3.0598,-3.0489,-3.0385,-3.0286,-3.0201,-3.0114,-3.0026,
     9-2.9941,-2.9860,-2.9783,-2.9710,-2.9642,-2.9580,-2.9521,-2.9467/
      data (bp0021(i),i=  73, 101)/
     1-2.9411,-2.9354,-2.9297,-2.9240,-2.9190,-2.9156,-2.9121,-2.9082,
     2-2.9043,-2.9004,-2.8968,-2.8933,-2.8901,-2.8875,-2.8847,-2.8822,
     3-2.8795,-2.8768,-2.8747,-2.8728,-2.8700,-2.8669,-2.8656,-2.8647,
     4-2.8608,-2.8542,-2.8450,-2.8335,-2.8200/
c
      data (bp001 (i),i=   1,  72)/
     1-5.9850,-5.1359,-4.9030,-4.7311,-4.6185,-4.5298,-4.4526,-4.3939,
     2-4.3351,-4.2887,-4.2457,-4.2049,-4.1653,-4.1336,-4.0998,-4.0701,
     3-4.0385,-4.0117,-3.9849,-3.9589,-3.9360,-3.9175,-3.8976,-3.8784,
     4-3.8594,-3.8395,-3.8217,-3.8035,-3.7862,-3.7687,-3.7528,-3.7367,
     5-3.7222,-3.7041,-3.6876,-3.6700,-3.6549,-3.6412,-3.6264,-3.6135,
     6-3.5969,-3.5853,-3.5700,-3.5562,-3.5426,-3.5308,-3.5184,-3.5059,
     7-3.4944,-3.4827,-3.4730,-3.4638,-3.4532,-3.4435,-3.4344,-3.4254,
     8-3.4164,-3.4074,-3.3991,-3.3915,-3.3845,-3.3779,-3.3709,-3.3638,
     9-3.3566,-3.3492,-3.3424,-3.3368,-3.3314,-3.3259,-3.3205,-3.3152/
      data (bp001 (i),i=  73, 101)/
     1-3.3100,-3.3049,-3.3000,-3.2953,-3.2908,-3.2865,-3.2824,-3.2786,
     2-3.2750,-3.2716,-3.2684,-3.2653,-3.2635,-3.2609,-3.2586,-3.2549,
     3-3.2508,-3.2467,-3.2419,-3.2369,-3.2315,-3.2264,-3.2215,-3.2207,
     4-3.2153,-3.2292,-3.1739,-3.1579,-3.1500/
       data zr/.756,.77, .80, .820, .730, .670,
     *       .575, .490, .423, .390,.375, .350, .345/
c
c
         el=log10(e)
         call rndc(u)
         call kintp3(zr, 1, nes, -3.d0, .25d0, el, rr)
         if(u .lt. rr) then
            de=0.
         else
            call rndc(u)
            call k4ptdi(b, 101, ne, 101, 0.d0, -3.d0, hx, hy,
     *      u, el, f)
            de=10.d0**f
         endif
      end
