#include "ZsubstRec.h"
c            treat interaction of MovedTrack
c
      subroutine cinteraction
      implicit none

#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"
c

c
c          used to judge if user hook should be called 
c          after MovedTrack interacted.
c
      integer neverNEP/0/,  neverE/0/,  neverG/0/
      save  neverNEP, neverE, neverG
      integer never
      save never
c/////////////
c      logical deb
c      common /cccdeb/ deb
c//////////

      record /ptcl/ fragA(maxHeavyMassN),  nonIntNucA(maxHeavyMassN)
      integer noOfFrag, noOfNonIntN
c
c      record /track/aTrack
c
c   **  ptcl stacking is done in each subroutine; should be changed
c           (except for hadronic interactions)

      Nproduced = 0

c//////////////
c         if( deb ) then
c            write(*,*) ' top of  cinteraction '
c         endif
c////////////////
c

c
cc    assume MovedTrack is not changed in interaction routine
c     but may be added asflag by chookEing if it is elec.
c      (in the case of Job ='newskel' )
c     
c
      if(MovedTrack.p.code .eq. kelec) then
         call cinteElec
         if(neverE .ne. 1) then
            call chookEInt(neverE)
            never = neverE
         endif

      elseif(MovedTrack.p.code .eq. kphoton) then

          call cintePhoton
          if(neverG  .ne. 1)  then
             call chookGInt(neverG)
             never = neverG
          endif

      else
          call cinteNEP
c//////////////
c         if( deb ) then
c            write(*,*) ' aftere cinteNEP '
c         endif
c////////////////

          if(IntInfArray(ProcessNo).process .eq. 'coll') then
             MovedTrack.pos.colheight = MovedTrack.pos.height
          endif
c             interface with user hook  ***********************
          if(neverNEP .ne. 1) then
             call chookNEPInt(neverNEP)
c//////////////
c         if( deb ) then
c            write(*,*) ' after chookNEPint '
c         endif
c////////////////

             never = neverNEP
          endif
c             *******************************
      endif
      if( never .eq. 1 .or. never .eq. 0) then
         if(OneDim .eq. 0) then
c            3 dimensional
c                 stack the leading ptcl  first (to save stack area)
            call cmovePtcl3(MovedTrack, Pwork, Nproduced)
         else
            MovedTrack.vec = IncidentCopy.vec
            call cmovePtcl1(MovedTrack, Pwork, Nproduced)
         endif
      elseif(never .eq. 2) then
c              save only fragments and non interacting nucleons
cc         if(MovedTrack.p.code .ge. kdeut .and. 
cc     *      MovedTrack.p.code .le. khvymax ) then
         if(MovedTrack.p.code .eq. kgnuc ) then
c               get fragment and non interacting nuc.
            call cqHvyIntF(fragA, noOfFrag)
            call cqHvyIntNIN(nonIntNucA, noOfNonIntN)

            if(OneDim .eq. 0) then
                call cmovePtcl3(MovedTrack, fragA, noOfFrag)
                call cmovePtcl3(MovedTrack, nonIntNucA, noOfNonIntN)
             else
                MovedTrack.vec = IncidentCopy.vec
                call cmovePtcl1(MovedTrack, fragA, noOfFrag)
                call cmovePtcl1(MovedTrack, nonIntNucA, noOfNonIntN)
             endif
          endif
      elseif(never .eq. 3) then
c              don't follow all this child
      elseif(never .eq. 4) then
c             discard this event
c             clear stack
         call cinitStack
      else
         call cerrorMsg('return value from chookE,G,NEPInt wrong', 0)
      endif
      end
c     ************************************
c          move partcles in a given array to stack
c          3 dimensional case.

      subroutine  cmovePtcl3(iTrack, pw, n)
      implicit none
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
c
      integer n
      record /track/ iTrack  ! input. incident ptcl.
      record /ptcl/ pw(n)
      logical needThin

      record /track/ aTrack  
      integer i, icon
      
      needThin= ThinSampling .and. iTrack.p.fm.p(4) .lt. Ethin

      aTrack = iTrack

      do i =  n, 1, -1          ! move leading ptcl first
#ifdef SUBSTREC
         aTrack.p = pw(i)
#else
         aTrack.p.fm.p = pw(i).fm.p
         aTrack.p.mass = pw(i).mass
         aTrack.p.code = pw(i).code
         aTrack.p.subcode = pw(i).subcode
         aTrack.p.charge = pw(i).charge
#endif

c               reset direction cos and related stuffs
         call cresetDirec(aTrack)


         if(needThin) then
            call csetThinwgt(iTrack, aTrack,  icon)
         else
            icon = 0
         endif
         if(icon .eq.0) then
#if LABELING == 1
c
c              whennever an interaction occur,  update labelcounter
c             if info>0, clear the timer and infor counters.
c
            if(aTrack.info .gt. 0) then
ccc               aTrack.info = 0
               aTrack.t = 0.
            endif
            Labelcounter = Labelcounter + 1
            aTrack.label = Labelcounter
#elif LABELING == 2
c            the above simple counter may be replaced by the
c            next sophisticated one. 
c            the same one is in the 1dim mode move routine below.
c
            call ctrickycount(iTrack, aTrack, pw, i)
c
#endif
            call cpush(aTrack)
         endif
      enddo 
      end
#if LABELING == 2
c       ************************************
c             This routine updates label counters.
c          but for the survival particle form brems and knock-on
c          the label counter is not updated. 
c          For those ptcl with info > 0, timer and info counters
c          are cleared. 
      subroutine ctrickycount(iTrack, aTrack, pw, i)
      implicit none
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
c
      integer n
      record /track/ iTrack  ! input. incident ptcl.
      record /track/ aTrack  ! input/output. i-th  secondary track 
      record /ptcl/ pw(*)    ! input.  secondary pool
      integer i              ! input.  i-th secondary (index)

      logical reset

      reset = .true.

      if( iTrack.pos.height .gt. 40.d3 ) then
         if(IntInfArray(ProcessNo).process .eq. 'brems' ) then
c             for brem, electron has the same label as the incident
            if( aTrack.p.fm.p(4) .lt. iTrack.p.fm.p(4)*0.8) then
               aTrack.label = iTrack.label
               reset = .false.
            endif
         elseif(IntInfArray(ProcessNo).process .eq. 'knock' .or.
     *        IntInfArray(ProcessNo).process .eq. 'mscat' .or.
     *         IntInfArray(ProcessNo).process .eq. 'bscat' ) then
c                for the knock-on, survival particle has the same
c                label.
            if(iTrack.p.code .ne. kelec  .or.
     *           iTrack.p.charge .ne. -1) then
c                     knockon by p,mu,pi..e+ (not by e-)
               if(aTrack.p.code .ne. kelec) then
c                       survival one has the same label
                  aTrack.label = iTrack.label
                  reset = .false.
               endif
            else
c                  electron; make the higher one has the same label
               if(pw(1).fm.p(4) .gt. pw(2).fm.p(4)) then
                  if(i .eq. 1) then
                     aTrack.label = iTrack.label
                     reset = .false.
                  endif
               else
                  if(i .eq. 2) then
                     aTrack.label = iTrack.label
                     reset = .false.
                  endif
               endif
            endif                     
         endif
      endif
      if(reset) then
         Labelcounter = Labelcounter +1
         aTrack.label = Labelcounter
         aTrack.t = 0.          ! timer reset
cc         aTrack.info = 0        ! cross counter reset
      endif
      end
#endif
c     ************************************
c          move partcles in a given array to stack
c          1 dimensional case.

      subroutine  cmovePtcl1(iTrack, pw, n)
      implicit none

#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"


      integer n
      record /track/ iTrack   ! input. incident track
      record /ptcl/ pw(n)
      real*8 temp, p
      logical needThin
      integer i, icon
      
      record /track/ aTrack 

      needThin =ThinSampling .and. iTrack.p.fm.p(4) .lt. Ethin

      aTrack = iTrack

      do i =  n, 1, -1          ! move leading ptcl last
#ifdef SUBSTREC
         aTrack.p = pw(i)
#else
         aTrack.p.fm.p = pw(i).fm.p
         aTrack.p.mass = pw(i).mass
         aTrack.p.code = pw(i).code
         aTrack.p.subcode = pw(i).subcode
         aTrack.p.charge = pw(i).charge
#endif
c            see if angle of particle is larger than a lmit
         call cscalerProd(aTrack.p.fm.p, DcAtObsXyz, temp)
         call cpxyzp(aTrack.p.fm, p)
         if(p .gt. 0.) then
            temp = temp/p
         else
            temp = 1.
         endif
         if(temp .gt. BackAngLimit)  then
c              only take some limitted angle particles
c            call cresetMom(aTrack)  which is
            aTrack.p.fm.p(1) = p * aTrack.vec.w.r(1)
            aTrack.p.fm.p(2) = p * aTrack.vec.w.r(2)
            aTrack.p.fm.p(3) = p * aTrack.vec.w.r(3)

            call cgetZenith(aTrack, aTrack.vec.coszenith)

            if(needThin) then
               call csetThinwgt(iTrack, aTrack, icon)
            else
               icon = 0
            endif
            if(icon .eq. 0) then
#if LABELING == 1
c                  whennever secondary particles are generated,
c               each of them get an updated label cocunter
c               if the particle has crossed the highest level
c               (info > 0),  timer and info counter is cleared
c
               if( aTrack.info .gt. 0) then
ccc                  aTrack.info = 0
                  aTrack.t = 0.
               endif
               Labelcounter = Labelcounter + 1
               aTrack.label = Labelcounter
#elif LABELING == 2
c                   this may be used if a tricky count is needed
c               in stead of above  counting
               call ctrickycount(iTrack, aTrack, pw, i)
#endif
               call cpush(aTrack)
            endif
         endif
      enddo
      end

c     ****************************************************************
      subroutine cqIntePtcl(ptclA, num)
      implicit none
c          inquire the particle information that made interactions
c        to produce secondary particles.
c        If "MovedTrack" is a heavy,  ptclA will get interacting nucleons
c        otherwise, ptclA will have MovedTrack.p itself.
c
c           
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"

      record /ptcl/ ptclA(*)   ! output. interacted particles. max size
                               ! should be maxHeavyMassN (= 56 =Fe)
      integer num              ! output. number of ptcls in ptclA
c
c
cc      if(MovedTrack.p.code .ge. kdeut .and. 
cc     *    MovedTrack.p.code .le. khvymax ) then
      if( MovedTrack.p.code .eq. kgnuc ) then
         call cqHvyIntIN(ptclA, num)
      else
#ifdef SUBSTREC
         ptclA(1) = MovedTrack.p
#else
         ptclA(1).fm.p = MovedTrack.p.fm.p
         ptclA(1).mass = MovedTrack.p.mass
         ptclA(1).code = MovedTrack.p.code
         ptclA(1).subcode = MovedTrack.p.subcode
         ptclA(1).charge = MovedTrack.p.charge
#endif
      endif
      end
c     ***************************
      subroutine csetThinwgt(iTrack, aTrack, icon)
      implicit none
#include  "Ztrack.h"
#include  "Ztrackv.h"
      record /track/ iTrack   ! input   particle
      record /track/ aTrack  ! input/output.    particle
      integer icon           ! output.  0 if this is not tobe discarded
                             !          1 if this is to be discarded
      real*8 iwgt, u



      iwgt = aTrack.p.fm.p(4)/iTrack.p.fm.p(4) ! inverse weight

      call rndc(u)
      if(u .gt. iwgt) then
         icon =1                !  discard this ptcl
      else
         aTrack.wgt = iTrack.wgt /iwgt
         icon = 0
      endif
      end




