#include "Zcondc.h"
#if USEDPMJET == 1
CDECK  ID>, PHO_SDECAY
      SUBROUTINE PHO_SDECAY(NPOS,ISP,ILEV)
C**********************************************************************
C
C     decay of single resonance of /POEVT1/:
C       decay in helicity frame according to polarization, isotropic
C       decay and decay with limited transverse phase space possible
C
C     ATTENTION:
C     reference to particle number of CPC has to exist
C
C     input:   NPOS    position in /POEVT1/
C              ISP     0  decay according to phase space
C                      1  decay according to transversal polarization
C                      2  decay according to longitudinal polarization
C                      3  decay with limited phase space
C              ILEV    decay mode to use
C                      1 strong only
C                      2 strong and ew of tau, charm, and bottom
C                      3 strong and electro-weak decays
C                      negative: remove mother resonance after decay
C
C     output:  /POEVT1/,/POEVT2/ final particles according to decay mode
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( EPS  = 1.D-15,
     &            DEPS = 1.D-10 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)

C  particle decay data
      DOUBLE PRECISION WG_SEC_LIST
      INTEGER          IDEC_LIST,ISEC_LIST
      COMMON /POPAR3/ WG_SEC_LIST(500),IDEC_LIST(3,300),
     &  ISEC_LIST(3,500)

C  auxiliary data for three particle decay
      DOUBLE PRECISION ECM,PCM,COD,COF,SIF
      COMMON /PO3DCY/ ECM(3),PCM(3),COD(3),COF(3),SIF(3)


      DIMENSION WGHD(20),KCH(20),ID(3)

      IMODE = ABS(ILEV)
      IF(IDEB(36).GE.15) WRITE(ErrorOut,'(1X,A,3I5)')
     &  'PHO_SDECAY: NPOS,ISP,ILEV',NPOS,ISP,ILEV

C  comment entry
      IF(ISTHEP(NPOS).GT.11) RETURN

C  particle stable?
      IDCPC = IMPART(NPOS)
      IF(IDCPC.EQ.0) RETURN
      IF(IDEC_LIST(1,IDCPC).EQ.0) RETURN
      IDABS = IABS(IDCPC)

C  different decay modi (times)
      IF(IMODE.EQ.1) THEN
        IF(IDEC_LIST(1,IDABS).NE.1) RETURN
      ELSE IF(IMODE.EQ.2) THEN
        IF(IDEC_LIST(1,IDABS).GT.2) RETURN
      ELSE IF(IMODE.EQ.3) THEN
        IF(IDEC_LIST(1,IDABS).GT.3) RETURN
      ELSE
        WRITE(ErrorOut,
     * '(/1X,A,I5)') 'PHO_SDECAY: invalid mode (ILEV)',ILEV
        CALL PHO_ABORT
      ENDIF

C  decay products, check for mass limitations
      K = 0
      WGSUM = 0.D0
      AMIST = PHEP(5,NPOS)
      DO 100 I=IDEC_LIST(2,IDABS),IDEC_LIST(3,IDABS)
        AMSUM = 0.D0
        DO 200 L=1,3
          ID(L) = ISEC_LIST(L,I)
          IF(ID(L).NE.0) AMSUM = AMSUM+PHO_PMASS(ID(L),0)
 200    CONTINUE
        IF(AMSUM.LT.AMIST) THEN
          K = K+1
          WGHD(K) = WG_SEC_LIST(I)
          KCH(K) = I
        ENDIF
 100  CONTINUE
      IF(K.EQ.0)THEN
        WRITE(ErrorOut,'(/1X,A,I6,3E12.4)')
     &    'PHO_SDECAY: PARTICLE MASS TOO SMALL (NPOS,MA,DCYM)',
     &    NPOS,AMIST,AMSUM
        CALL PHO_PREVNT(0)
        RETURN
      ENDIF

C  sample new decay channel
      XI = (PHO_RNDM(AMSUM)-EPS)*WGSUM
      K = 0
      WGSUM = 0.D0
 500  CONTINUE
        K = K+1
        WGSUM = WGSUM+WGHD(K)
      IF(XI.GT.WGSUM) GOTO 500
      IK = KCH(K)
      ID(1) = ISEC_LIST(1,IK)
      ID(2) = ISEC_LIST(2,IK)
      ID(3) = ISEC_LIST(3,IK)
      IF(IDCPC.LT.0) THEN
        ID(1) = IPHO_ANTI(ID(1))
        ID(2) = IPHO_ANTI(ID(2))
        ID(3) = IPHO_ANTI(ID(3))
      ENDIF

C  rotation
      PTOT = SQRT(PHEP(1,NPOS)**2+PHEP(2,NPOS)**2+PHEP(3,NPOS)**2)
      CXS = PHEP(1,NPOS)/PTOT
      CYS = PHEP(2,NPOS)/PTOT
      CZS = PHEP(3,NPOS)/PTOT
C  boost
      GBET = PTOT/AMIST
      GAM = PHEP(4,NPOS)/AMIST

      IF(ID(3).EQ.0) THEN
C  two particle decay
        CALL PHO_SDECY2(AMIST,PHO_PMASS(ID(1),0),PHO_PMASS(ID(2),0),ISP)
      ELSE
C  three particle decay
        CALL PHO_SDECY3(AMIST,PHO_PMASS(ID(1),0),PHO_PMASS(ID(2),0),
     &    PHO_PMASS(ID(3),0),ISP)
      ENDIF

      IF(ILEV.LT.0) THEN
        IF(NHEP.NE.NPOS) THEN
          WRITE(ErrorOut,'(/1X,2A,2I5)') 'PHO_SDECAY:ERROR: ',
     &      'CANNOT REMOVE RESONANCE (NPOS,NHEP)',NPOS,NHEP
          CALL PHO_ABORT
        ENDIF
        IMO1 = JMOHEP(1,NPOS)
        IMO2 = JMOHEP(2,NPOS)
        NHEP = NHEP-1
      ELSE
        IMO1 = NPOS
        IMO2 = 0
      ENDIF
      IPH1 = IPHIST(1,NPOS)
      IPH2 = IPHIST(2,NPOS)

C  back transformation and registration
      DO 300 I=1,3
        IF(ID(I).NE.0) THEN
          CALL PHO_LTRANS(GAM,GBET,CXS,CYS,CZS,COD(I),COF(I),SIF(I),
     &      PCM(I),ECM(I),PTOT,CX,CY,CZ,EE)
          XX = PTOT*CX
          YY = PTOT*CY
          ZZ = PTOT*CZ
          CALL PHO_REGPAR(1,0,ID(I),IMO1,IMO2,XX,YY,ZZ,EE,
     &      IPH1,IPH2,0,0,IPOS,1)
        ENDIF
 300  CONTINUE

 400  CONTINUE
C  debug output
      IF(IDEB(36).GE.20) THEN
        WRITE(ErrorOut,'(2(/1X,A))') 'PHO_SDECAY: /POEVT1/',
     &                        '--------------------'
        CALL PHO_PREVNT(0)
      ENDIF

      END





CDECK  ID>, PHO_SDECY2
      SUBROUTINE PHO_SDECY2(UMO,AM1,AM2,ISP)
C**********************************************************************
C
C     isotropic/anisotropic two particle decay in CM system,
C     (transversely/longitudinally polarized boson into two
C     pseudo-scalar mesons)
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  auxiliary data for three particle decay
      DOUBLE PRECISION ECM,PCM,COD,COF,SIF
      COMMON /PO3DCY/ ECM(3),PCM(3),COD(3),COF(3),SIF(3)


      UMO2=UMO*UMO
      AM11=AM1*AM1
      AM22=AM2*AM2
      ECM(1)=(UMO2+AM11-AM22)/(2.D0*UMO)
      ECM(2)=UMO-ECM(1)
      WAU=ECM(1)*ECM(1)-AM11
      IF(WAU.LT.0.D0) THEN
        WRITE(ErrorOut,
     * '(/1X,A,E12.4)') 'PHO_SDECY2:ERROR:too small mass',WAU
        CALL PHO_ABORT
      ENDIF
      PCM(1)=SQRT(WAU)
      PCM(2)=PCM(1)

      CALL PHO_SFECFE(SIF(1),COF(1))
      IF(ISP.EQ.0) THEN
C  no polarization
        COD(1)  = 2.D0*PHO_RNDM(UMO)-1.D0
      ELSE IF(ISP.EQ.1) THEN
C  transverse polarization
 400    CONTINUE
          COD(1)  = 2.D0*PHO_RNDM(AM22)-1.D0
          SID12 = 1.D0-COD(1)*COD(1)
        IF(SID12.LT.PHO_RNDM(AM1)) GOTO 400
      ELSE IF(ISP.EQ.2) THEN
C  longitudinal polarization
 500    CONTINUE
          COD(1)  = 2.D0*PHO_RNDM(AM2)-1.D0
          COD12 = COD(1)*COD(1)
        IF(COD12.LT.PHO_RNDM(AM11)) GOTO 500
      ELSE
        WRITE(ErrorOut,'(/1X,2A,I3)') 'PHO_SDECY2:ERROR: ',
     &    'INVALID POLARIZATION',ISP
        CALL PHO_ABORT
      ENDIF

      COD(2) = -COD(1)
      COF(2) = -COF(1)
      SIF(2) = -SIF(1)

      END





CDECK  ID>, PHO_SDECY3
      SUBROUTINE PHO_SDECY3(UMO,AM1,AM2,AM3,ISP)
C**********************************************************************
C
C     isotropic/anisotropic three particle decay in CM system,
C     (transversely/longitudinally polarized boson into three
C     pseudo-scalar mesons)
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS   = 1.D-30,
     &            EPS    = 1.D-15 )

C  auxiliary data for three particle decay
      DOUBLE PRECISION ECM,PCM,COD,COF,SIF
      COMMON /PO3DCY/ ECM(3),PCM(3),COD(3),COF(3),SIF(3)


      DIMENSION F(5),XX(5)

C  calculation of maximum of S2 phase space weight
      UMOO=UMO+UMO
      GU=(AM2+AM3)**2
      GO=(UMO-AM1)**2
      UFAK=1.0000000000001D0
      IF (GU.GT.GO) UFAK=0.99999999999999D0
      OFAK=2.D0-UFAK
      GU=GU*UFAK
      GO=GO*OFAK
      DS2=(GO-GU)/99.D0
      AM11=AM1*AM1
      AM22=AM2*AM2
      AM33=AM3*AM3
      UMO2=UMO*UMO
      RHO2=0.D0
      S22=GU
      DO 124 I=1,100
        S21=S22
        S22=GU+(I-1.D0)*DS2
        RHO1=RHO2
        RHO2=PHO_XLAM(S22,UMO2,AM11)*PHO_XLAM(S22,AM22,AM33)/(S22+EPS)
        IF(RHO2.LT.RHO1) GOTO 125
  124 CONTINUE

  125 CONTINUE
      S2SUP=(S22-S21)/2.D0+S21
      SUPRHO=PHO_XLAM(S2SUP,UMO2,AM11)*PHO_XLAM(S2SUP,AM22,AM33)
     &       /(S2SUP+EPS)
      SUPRHO=SUPRHO*1.05D0
      XO=S21-DS2
      IF(GU.LT.GO.AND.XO.LT.GU) XO=GU
      IF(GU.GT.GO.AND.XO.GT.GU) XO=GU
      XX(1)=XO
      XX(3)=S22
      X1=(XO+S22)*0.5D0
      XX(2)=X1
      F(3)=RHO2
      F(1)=PHO_XLAM(XO,UMO2,AM11)*PHO_XLAM(XO,AM22,AM33)/(XO+EPS)
      F(2)=PHO_XLAM(X1,UMO2,AM11)*PHO_XLAM(X1,AM22,AM33)/(X1+EPS)
      DO 126 I=1,16
        X4=(XX(1)+XX(2))*0.5D0
        X5=(XX(2)+XX(3))*0.5D0
        F(4)=PHO_XLAM(X4,UMO2,AM11)*PHO_XLAM(X4,AM22,AM33)/(X4+EPS)
        F(5)=PHO_XLAM(X5,UMO2,AM11)*PHO_XLAM(X5,AM22,AM33)/(X5+EPS)
        XX(4)=X4
        XX(5)=X5
        DO 128 II=1,5
          IA=II
          DO 131 III=IA,5
            IF(F(II).LT.F(III)) THEN
              FH=F(II)
              F(II)=F(III)
              F(III)=FH
              FH=XX(II)
              XX(II)=XX(III)
              XX(III)=FH
            ENDIF
 131      CONTINUE
 128    CONTINUE
        SUPRHO=F(1)
        S2SUP=XX(1)
        DO 129 II=1,3
          IA=II
          DO 130 III=IA,3
            IF (XX(II).LT.XX(III)) THEN
              FH=F(II)
              F(II)=F(III)
              F(III)=FH
              FH=XX(II)
              XX(II)=XX(III)
              XX(III)=FH
            ENDIF
 130      CONTINUE
 129    CONTINUE
 126  CONTINUE

      AM23=(AM2+AM3)**2

C  selection of S1
      ITH=0
 200  CONTINUE
        ITH=ITH+1
        IF(ITH.GT.200) THEN
          WRITE(ErrorOut,
     * '(/1X,A,I10)') 'PHO_SDECY3:ERROR:too many iterations',
     &      ITH
          CALL PHO_ABORT
        ENDIF
        S2=AM23+PHO_RNDM(AM2)*((UMO-AM1)**2-AM23)
        Y=PHO_RNDM(AM23)*SUPRHO
        RHO=PHO_XLAM(S2,UMO2,AM11)*PHO_XLAM(S2,AM22,AM33)/S2
      IF(Y.GT.RHO) GOTO 200

C  selection of S2
      S1=PHO_RNDM(AM2)*RHO+AM11+AM22-(S2-UMO2+AM11)*(S2+AM22-AM33)
     &   /(2.D0*S2)-RHO/2.D0
      S3=UMO2+AM11+AM22+AM33-S1-S2
      ECM(1)=(UMO2+AM11-S2)/UMOO
      ECM(2)=(UMO2+AM22-S3)/UMOO
      ECM(3)=(UMO2+AM33-S1)/UMOO
      PCM(1)=SQRT((ECM(1)+AM1)*(ECM(1)-AM1))
      PCM(2)=SQRT((ECM(2)+AM2)*(ECM(2)-AM2))
      PCM(3)=SQRT((ECM(3)+AM3)*(ECM(3)-AM3))

C  calculation of angles: TH between p1,p2; TH1 p3,p1; TH2 p3,p2
      IF((PCM(1).LE.EPS).OR.(PCM(2).LE.EPS)) THEN
        COSTH=(PHO_RNDM(S1)-0.5D0)*2.D0
      ELSE
        COSTH=(ECM(1)*ECM(2)+0.5D0*(AM11+AM22-S1))/(PCM(1)*PCM(2))
      ENDIF
      COSTH2=(PCM(3)*PCM(3)+PCM(2)*PCM(2)-PCM(1)*PCM(1))
     &        /(2.D0*PCM(2)*PCM(3))
      SINTH2=SQRT(1.D0-COSTH2*COSTH2)
      SINTH1=COSTH2*SQRT(1.D0-COSTH*COSTH)-COSTH*SINTH2
      COSTH1=COSTH*COSTH2+SINTH2*SQRT(1.D0-COSTH*COSTH)

C  selection of the sperical coordinates of particle 3
      CALL PHO_SFECFE(SIF(3),COF(3))
      IF(ISP.EQ.0) THEN
C  no polarization
        COD(3)  = 2.D0*PHO_RNDM(S2)-1.D0
      ELSE IF(ISP.EQ.1) THEN
C  transverse polarization
 400    CONTINUE
          COD(3)  = 2.D0*PHO_RNDM(S1)-1.D0
          SID32 = 1.D0-COD(3)*COD(3)
        IF(SID32.LT.PHO_RNDM(COSTH)) GOTO 400
      ELSE IF(ISP.EQ.2) THEN
C  longitudinal polarization
 500    CONTINUE
          COD(3)  = 2.D0*PHO_RNDM(COSTH2)-1.D0
          COD32 = COD(3)*COD(3)
        IF(COD32.LT.PHO_RNDM(SINTH1)) GOTO 500
      ELSE
        WRITE(ErrorOut,'(/1X,2A,I3)') 'PHO_SDECY3:ERROR: ',
     &    'INVALID POLARIZATION',ISP
        CALL PHO_ABORT
      ENDIF

C  selection of the rotation angle of p1-p2 plane along p3
      IF(ISP.EQ.0) THEN
        CALL PHO_SFECFE(SFE,CFE)
      ELSE
        SFE = 0.D0
        CFE = 1.D0
      ENDIF
      CX11=-COSTH1
      CY11=SINTH1*CFE
      CZ11=SINTH1*SFE
      CX22=-COSTH2
      CY22=-SINTH2*CFE
      CZ22=-SINTH2*SFE

      SID3 = SQRT((1.D0+COD(3))*(1.D0-COD(3)))
      COD(1)=CX11*COD(3)+CZ11*SID3
      IF((1.D0-COD(1)*COD(1)).LT.DEPS) THEN
        WRITE(ErrorOut,
     * '(1X,A,5E12.4)') 'PHO_SDECY3: COS(TH1) > 1',
     &    COD(1),COF(3),SID3,CX11,CZ11
        CALL PHO_PREVNT(-1)
      ENDIF

      SID1=SQRT((1.D0+COD(1))*(1.D0-COD(1)))
      COF(1)=(CX11*SID3*COF(3)-CY11*SIF(3)-CZ11*COD(3)*COF(3))/SID1
      SIF(1)=(CX11*SID3*SIF(3)+CY11*COF(3)-CZ11*COD(3)*SIF(3))/SID1
      COD(2)=CX22*COD(3)+CZ22*SID3
      SID2=SQRT((1.D0+COD(2))*(1.D0-COD(2)))
      COF(2)=(CX22*SID3*COF(3)-CY22*SIF(3)-CZ22*COD(3)*COF(3))/SID2
      SIF(2)=(CX22*SID3*SIF(3)+CY22*COF(3)-CZ22*COD(3)*SIF(3))/SID2

      END



CDECK  ID>, PHO_DFMASS
      DOUBLE PRECISION FUNCTION PHO_DFMASS(XMIN,XMAX,PREF2,PVIRT2,IMODE)
C**********************************************************************
C
C     sampling of Mx diffractive mass distribution within
C              limits XMIN, XMAX
C
C     input:    XMIN,XMAX     mass limitations (GeV)
C               PREF2         original particle mass/ reference mass
C                             (squared, GeV**2)
C               PVIRT2        particle virtuality
C               IMODE         M**2 mass distribution
C                             1      1/(M**2+Q**2)
C                             2      1/(M**2+Q**2)**alpha
C                            -1      1/(M**2-Mref**2+Q**2)
C                            -2      1/(M**2-Mref**2+Q**2)**alpha
C
C     output:   diffractive mass (GeV)
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER(EPS  = 1.D-10)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


      IF((XMIN.GE.XMAX).OR.(XMIN.LE.0.3D0)) THEN
        WRITE(ErrorOut,'(/1X,2A,3E12.4)') 'PHO_DFMASS:ERROR: ',
     &    'INVALID MASS LIMITS',XMIN,XMAX,PREF2
        CALL PHO_PREVNT(-1)
        PHO_DFMASS = 0.135D0
        RETURN
      ENDIF

      IF(IMODE.GT.0) THEN
        PM2 = -PVIRT2
      ELSE
        PM2 = PREF2 - PVIRT2
      ENDIF

C  critical pomeron
      IF(ABS(IMODE).EQ.1) THEN
        XMIN2 = LOG(XMIN**2-PM2)
        XMAX2 = LOG(XMAX**2-PM2)
        XI = (XMAX2-XMIN2)*PHO_RNDM(PM2)+XMIN2
        XMA2 = EXP(XI)+PM2

C  supercritical pomeron
      ELSE IF(ABS(IMODE).EQ.2) THEN
        DDELTA = 1.D0-PARMDL(48)
        XMIN2 = (XMIN**2-PM2)**DDELTA
        XMAX2 = (XMAX**2-PM2)**DDELTA
        XI = (XMAX2-XMIN2)*PHO_RNDM(PM2)+XMIN2
        XMA2 = XI**(1.D0/DDELTA)+PM2
      ELSE
        WRITE(ErrorOut,
     * '(/,1X,A,I3)') 'PHO_DFMASS:ERROR:unsupported mode',IMODE
        CALL PHO_ABORT
      ENDIF

      PHO_DFMASS = SQRT(XMA2)
C  debug output
      IF(IDEB(43).GE.15) THEN
        WRITE(ErrorOut,
     * '(1X,A,4E12.3)') 'PHO_DFMASS:Mmin,Mmax,Mref,Mass',
     &    XMIN,XMAX,PREF2,SQRT(XMA2)
      ENDIF

      END


CDECK  ID>, PHO_DIFSLP
      SUBROUTINE PHO_DIFSLP(IDF1,IDF2,IVEC1,IVEC2,XM1,XM2,XMX,
     &                  TT,SLWGHT,IREJ)
C**********************************************************************
C
C     sampling of T  (Mandelstam variable) distribution within
C     certain limits TMIN, TMAX
C
C     input:    IDF1,2     type of diffractive vertex
C                           0   elastic/quasi-elastic scattering
C                           1   diffraction dissociation
C               IVEC1,2    vector meson IDs in case of quasi-elastic
C                          scattering, otherwise 0
C               XM1        mass of diffractive system 1 (GeV)
C               XM2        mass of diffractive system 2 (GeV)
C               XMX        max. mass of diffractive system (GeV)
C
C     output:   TT         squared momentum transfer ( < 0, GeV**2)
C               SLWGHT     weight to allow for mass-dependent slope
C               IREJ       0  successful sampling
C                          1  masses too big for given T range
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER(EPS  = 1.D-10)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  c.m. kinematics of diffraction
      INTEGER NPOSD
      DOUBLE PRECISION ECMD,PCMD,PMASSD,PVIRTD,GAMBED,
     &                 SIDD,CODD,SIFD,COFD,PDCMS
      COMMON /PODCMS/ ECMD,PCMD,PMASSD(2),PVIRTD(2),GAMBED(4),
     &                SIDD,CODD,SIFD,COFD,PDCMS(4,2),NPOSD(2)

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  parameters of 2x2 channel model
      DOUBLE PRECISION PHISUP,RMASS,VAR,AMPFAC,ELAFAC,VFAC
      COMMON /PO2CHA/ PHISUP(2),RMASS(2),VAR,AMPFAC(4),ELAFAC(4),VFAC

C  parameters of the "simple" Vector Dominance Model
      DOUBLE PRECISION VMAS,GAMM,RMIN,RMAX,VMSL,VMFA
      COMMON /POSVDM/ VMAS(4),GAMM(4),RMIN(4),RMAX(4),VMSL(4),VMFA(4)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


      IREJ = 0
      XM12 = XM1**2
      XM22 = XM2**2
      SS = ECMD**2
C
C  range of momentum transfer t
      TMIN = -PARMDL(68)
      TMAX = -PARMDL(69)
C  determine min. abs(t) necessary to produce masses
      PCM2 = PCMD**2
      PCMP2 = PHO_XLAM(SS,XM12,XM22)**2/(4.D0*SS)
      IF(PCMP2.LE.0.D0) THEN
        IREJ = 1
        TT = 0.D0
        RETURN
      ENDIF
      TMINP = PMASSD(1)**2+XM12+2.D0*PCMD*SQRT(PCMP2)
     &        -2.D0*SQRT((PMASSD(1)**2+PCM2)*(XM12+PCMP2))
C
      IF(TMINP.LT.TMAX) THEN
        IF(IDEB(44).GE.3) THEN
          WRITE(ErrorOut,
     * '(1X,2A,/5X,5E12.3)') 'PHO_DIFSLP:REJECTION: ',
     &      'TOO LARGE TMIN (XM1/2,TMIN,TMAX,TMINP)',
     &      XM1,XM2,TMIN,TMAX,TMINP
        ENDIF
        IFAIL(32) = IFAIL(32)+1
        IREJ = 1
        TT = 0.D0
        RETURN
      ENDIF
      TMINA = MIN(TMIN,TMINP)
C
C  calculation of slope (mass-dependent parametrization)
      IF(IDF1+IDF2.GT.0) THEN
C  diffraction dissociation
        XMP12 = XM1**2+PVIRTD(1)
        XMP22 = XM2**2+PVIRTD(2)
        XMX1 = SQRT(XMP12)
        XMX2 = SQRT(XMP22)
        CALL PHO_SCALES(PMASSD(1),PMASSD(2),XMX1,XMX2,SC1,SC2,SB1,SB2)
        FAC = 4.D0*(PMASSD(1)*PMASSD(2))**2
        SLOPE = DBLE(IDF1+IDF2)*B0PPP
     &    +2.D0*(B0POM(1)*SB1+B0POM(2)*SB2+ALPOMP*LOG(SS*FAC
     &    /((PMASSD(1)**2+XMP12)*(PMASSD(2)**2+XMP22))+PARMDL(47)))
        SLOPE = MAX(SLOPE,1.D0)
C
        XMA1 = XMX
        XMA2 = XMX
        IF(IDF1.EQ.0) THEN
          XMA1 = XM1
        ELSE IF(IDF1.EQ.0) THEN
          XMA2 = XM2
        ENDIF
        XMP12 = XMA1**2+PVIRTD(1)
        XMP22 = XMA2**2+PVIRTD(2)
        XMX1 = SQRT(XMP12)
        XMX2 = SQRT(XMP22)
        CALL PHO_SCALES(PMASSD(1),PMASSD(2),XMX1,XMX2,SC1,SC2,SB1,SB2)
        SLMIN = DBLE(IDF1+IDF2)*B0PPP
     &    +2.D0*(B0POM(1)*SB1+B0POM(2)*SB2+ALPOMP*LOG(SS*FAC
     &    /((PMASSD(1)**2+XMP12)*(PMASSD(2)**2+XMP22))+PARMDL(47)))
        SLMIN = MAX(SLMIN,1.D0)
      ELSE
C  elastic/quasi-elastic scattering
        IF(ISWMDL(13).EQ.0) THEN
C  external slope values
          PRINT *,'PHO_DIFSLP:ERROR: THIS OPTION IS NOT INSTALLED !!!!!'
          CALL PHO_ABORT
        ELSE IF(ISWMDL(13).EQ.1) THEN
C  model slopes
          IF(IVEC1*IVEC2.EQ.0) THEN
            SLOPE = SLOEL
          ELSE
            SLOPE = SLOVM(IVEC1,IVEC2)
          ENDIF
          SLMIN = SLOPE
        ELSE
          WRITE(ErrorOut,
     * '(/1X,A,I5)') 'SASDSDT:ERROR:invalid ISWMDL(13)',
     &      ISWMDL(13)
          CALL PHO_ABORT
        ENDIF
      ENDIF
C
C  determine max. abs(t) to avoid underflows
      TMAXP = -25.D0/SLOPE
      TMAXA = MAX(TMAX,TMAXP)
C
      IF(TMINA.LT.TMAXA) THEN
        IF(IDEB(44).GE.3) THEN
          WRITE(ErrorOut,
     * '(1X,2A,/5X,5E12.3)') 'PHO_DIFSLP:REJECTION: ',
     &      'TOO SMALL TMAX (XM1/2,TMINA,TMAXA,SLOPE)',
     &      XM1,XM2,TMINA,TMAXA,SLOPE
        ENDIF
        IFAIL(32) = IFAIL(32)+1
        IREJ = 1
        TT = 0.D0
        RETURN
      ENDIF
C
C  sampling from corrected range of T
      TMINE = EXP(SLMIN*TMINA)
      TMAXE = EXP(SLMIN*TMAXA)
      XI = (TMINE-TMAXE)*PHO_RNDM(SLMIN)+TMAXE
      TT = LOG(XI)/SLMIN
      SLWGHT = EXP((SLOPE-SLMIN)*TT)
C
C  debug output
      IF(IDEB(44).GE.15) THEN
        WRITE(ErrorOut,
     * '(1X,A,1P,E12.3/5X,A,2I2,2X,2I2,2E10.2,/5X,A,5E10.2)')
     &    'PHO_DIFSLP: SAMPLED MOMENTUM TRANSFER:',TT,
     &    'IDF1/2,IVEC1/2,XM1/2:',IDF1,IDF2,IVEC1,IVEC2,XM1,XM2,
     &    'TMI,TMX,SLMIN,SLOPE,WGHT:',TMINP,TMAXP,SLMIN,SLOPE,SLWGHT
      ENDIF
      END


CDECK  ID>, PHO_DIFKIN
      SUBROUTINE PHO_DIFKIN(XMP1,XMP2,TT,PMOM1,PMOM2,IREJ)
C**********************************************************************
C
C     calculation of diffractive kinematics
C
C     input:    XMP1         mass of outgoing particle system 1 (GeV)
C               XMP2         mass of outgoing particle system 2 (GeV)
C               TT           momentum transfer    (GeV**2, negative)
C
C     output:   PMOM1(5)     four momentum of outgoing system 1
C               PMOM2(5)     four momentum of outgoing system 2
C               IREJ         0    kinematics consistent
C                            1    kinematics inconsistent
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER(EPS  = 1.D-10,
     &          DEPS = 0.001)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  c.m. kinematics of diffraction
      INTEGER NPOSD
      DOUBLE PRECISION ECMD,PCMD,PMASSD,PVIRTD,GAMBED,
     &                 SIDD,CODD,SIFD,COFD,PDCMS
      COMMON /PODCMS/ ECMD,PCMD,PMASSD(2),PVIRTD(2),GAMBED(4),
     &                SIDD,CODD,SIFD,COFD,PDCMS(4,2),NPOSD(2)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


      DOUBLE PRECISION PMOM1,PMOM2
      DIMENSION PMOM1(5),PMOM2(5)

C  debug output
      IF(IDEB(49).GT.10) WRITE(ErrorOut,'(1X,A,/5X,5E12.4)')
     &    'PHO_DIFKIN: ECMD,PCMD,MINI-1,MINI-2,TT:',
     &    ECMD,PCMD,XMP1,XMP2,TT

C  general kinematic constraints
      IREJ = 1
      IF(ECMD.LE.1.1D0*(XMP1+XMP2)) RETURN

C  new squared cms momentum
      XMP12 = XMP1**2
      XMP22 = XMP2**2
      SS = ECMD**2
      PCM2 = PCMD**2
      PCMP2 = PHO_XLAM(SS,XMP12,XMP22)**2/(4.D0*SS)

C  new longitudinal/transverse momentum
      E1I = SQRT(PCM2+PMASSD(1)**2)
      E1F = SQRT(PCMP2+XMP12)
      E2F = SQRT(PCMP2+XMP22)
      PLONG = (TT+PCM2+PCMP2-(E1I-E1F)**2)/(2.D0*PCMD)
      PTRAN = PCMP2-PLONG**2

C  check consistency of kinematics
      IF(PTRAN.LT.0.D0) THEN
        IF(IDEB(49).GE.1) THEN
          WRITE(ErrorOut,'(1X,2A,I10)') 'PHO_DIFKIN: ',
     &      'INCONSISTENT KINEMATICS IN EVENT CALL: ',KEVENT
          WRITE(ErrorOut,'(1X,A,/5X,1p,6E11.3)')
     &      'PHO_DIFKIN: XMP1,XMP2,TT,PCMP,PLONG,PTRANS',
     &      XMP1,XMP2,TT,SQRT(PCMP2),PLONG,SIGN(SQRT(ABS(PTRAN)),PTRAN)
        ENDIF
        IREJ = 1
        RETURN
      ELSE
        PTRAN = SQRT(PTRAN)
      ENDIF
      XI = PI2*PHO_RNDM(PTRAN)

C  outgoing momenta in cm. system
      PMOM1(4) = E1F
      PMOM1(1) = PTRAN*COS(XI)
      PMOM1(2) = PTRAN*SIN(XI)
      PMOM1(3) = PLONG
      PMOM1(5) = XMP1

      PMOM2(4) = E2F
      PMOM2(1) = -PMOM1(1)
      PMOM2(2) = -PMOM1(2)
      PMOM2(3) = -PLONG
      PMOM2(5) = XMP2
      IREJ = 0

C  debug output / precision check
      IF(IDEB(49).GE.0) THEN
C  check kinematics
        XM1 = (PMOM1(4)-PMOM1(3))*(PMOM1(4)+PMOM1(3))
     &        -PMOM1(1)**2-PMOM1(2)**2
        XM1 = SIGN(SQRT(ABS(XM1)),XM1)
        XM2 = (PMOM2(4)-PMOM2(3))*(PMOM2(4)+PMOM2(3))
     &        -PMOM2(1)**2-PMOM2(2)**2
        XM2 = SIGN(SQRT(ABS(XM2)),XM2)
        IF((ABS(XM1-XMP1).GT.DEPS).OR.(ABS(XM1-XMP1).GT.DEPS)) THEN
          WRITE(ErrorOut,'(1X,2A,/5X,4E11.4)') 'PHO_DIFKIN: ',
     &      'INCONSISTENT MASSES: MINI-1,MOUT-1,MINI-2,MOUT-2',
     &      XMP1,XM1,XMP2,XM2
          CALL PHO_PREVNT(-1)
        ENDIF
C  output
        IF(IDEB(49).GT.10) THEN
          WRITE(ErrorOut,'(1X,A,5E11.3,/1X,A,5E11.3)')
     &      'PHO_DIFKIN: P1',PMOM1,'                 P2',PMOM2
        ENDIF
      ENDIF

      END


CDECK  ID>, PHO_VECRES
      SUBROUTINE PHO_VECRES(IVEC,RMASS,IDPDG,IDBAM)
C**********************************************************************
C
C     sampling of vector meson resonance in diffractive processes
C     (nothing done for hadrons)
C
C     input:   /POSVDM/     VDMFAC factors
C
C     output:  IVEC         0   incoming hadron
C                           1   rho 0
C                           2   omega
C                           3   phi
C                           4   pi+/pi- background
C              RMASS        mass of vector meson (GeV)
C              IDPDG        particle ID according to PDG
C              IDBAM        particle ID according to CPC
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER(EPS  = 1.D-10)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  parameters of the "simple" Vector Dominance Model
      DOUBLE PRECISION VMAS,GAMM,RMIN,RMAX,VMSL,VMFA
      COMMON /POSVDM/ VMAS(4),GAMM(4),RMIN(4),RMAX(4),VMSL(4),VMFA(4)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


C  particle code translation
      DIMENSION ITRANS(4)
C                  rho0,omega,phi,pi+/pi-
      DATA ITRANS /113, 223, 333, 92 /


      IDPDO = IDPDG
C
C  vector meson production
      IF(IDPDG.EQ.22) THEN
        XI = PHO_RNDM(RMASS)*(VMFA(1)+VMFA(2)+VMFA(3)+VMFA(4))
        SUM = 0.D0
        DO 55 K=1,4
          SUM = SUM + VMFA(K)
          IF(XI.LE.SUM) GOTO 65
 55     CONTINUE
 65     CONTINUE
C
        IDPDG = ITRANS(K)
        IDBAM = IPHO_PDG2ID(IDPDG)
        IVEC  = K
C  sample mass of vector meson
        CALL PHO_SAMASS(IDPDG,RMASS)

C  hadronic resonance of multi-pomeron coupling
      ELSE IF(IDPDG.EQ.990) THEN
        K = 4
        IDPDG = 91
        IDBAM = IPHO_PDG2ID(IDPDG)
        IVEC  = 4
C  sample mass of two-pion system
        CALL PHO_SAMASS(IDPDG,RMASS)

C  hadron remnants in inucleus interactions
      ELSE IF(IDPDG.EQ.81) THEN
        IF(IHFLD(1,1).EQ.0) THEN
          CALL PHO_SEAFLA(1,IFL1,IFL2,RMASS)
          CALL PHO_HACODE(IFL1,IFL2,IDBA1,IDBA2)
        ELSE
          CALL PHO_HACODE(IHFLD(1,1),IHFLD(1,2),IDBA1,IDBA2)
        ENDIF
        RMAS1 = PHO_PMASS(IDBA1,0)
        RMAS2 = PHO_PMASS(IDBA2,0)
        IF((IDBA2.NE.0).AND.
     &    (PHO_RNDM(RMAS1).LT.(RMAS1/(RMAS1+RMAS2)))) THEN
          IDBAM = IDBA2
          RMASS = RMAS2
        ELSE
          IDBAM = IDBA1
          RMASS = RMAS1
        ENDIF
        IDPDG = IPHO_ID2PDG(IDBAM)
        IVEC = 0
      ELSE IF(IDPDG.EQ.82) THEN
        IF(IHFLD(2,1).EQ.0) THEN
          CALL PHO_SEAFLA(2,IFL1,IFL2,RMASS)
          CALL PHO_HACODE(IFL1,IFL2,IDBA1,IDBA2)
        ELSE
          CALL PHO_HACODE(IHFLD(2,1),IHFLD(2,2),IDBA1,IDBA2)
        ENDIF
        RMAS1 = PHO_PMASS(IDBA1,0)
        RMAS2 = PHO_PMASS(IDBA2,0)
        IF((IDBA2.NE.0).AND.
     &    (PHO_RNDM(RMAS1).LT.(RMAS1/(RMAS1+RMAS2)))) THEN
          IDBAM = IDBA2
          RMASS = RMAS2
        ELSE
          IDBAM = IDBA1
          RMASS = RMAS1
        ENDIF
        IDPDG = IPHO_ID2PDG(IDBAM)
        IVEC = 0
      ENDIF
C  debug output
      IF(IDEB(47).GE.5) THEN
        WRITE(ErrorOut,'(1X,A,/10X,3I7,E12.4)')
     &    'PHO_VECRES: IDPDG-OLD,IDPDG,IDBAM,MASS',
     &    IDPDO,IDPDG,IDBAM,RMASS
      ENDIF

      END


CDECK  ID>, PHO_DIFRES
      SUBROUTINE PHO_DIFRES(IDMOTH,IVAL1,IVAL2,
     &                  IDPDG,IDBAM,RMASS,RGAM,RWG,LISTL)
C**********************************************************************
C
C     list of resonance states for low mass resonances
C
C     input:   IDMOTH       PDG ID of mother particle
C              IVAL1,2      quarks (photon only)
C
C     output:  IDPDG        list of PDG IDs for possible resonances
C              IDBAM        list of corresponding CPC IDs
C              RMASS        mass
C              RGAMS        decay width
C              RMASS        additional weight factor
C              LISTL        entries in current list
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      DIMENSION  IDPDG(10),IDBAM(10),RMASS(10),RGAM(10),RWG(10)

      PARAMETER (EPS    =  1.D-10,
     &           DEPS   =  1.D-15)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  particle ID translation table
      INTEGER         ID_PDG_LIST,ID_LIST,ID_PDG_MAX
      CHARACTER*12    NAME_LIST
      COMMON /POPAR1/ ID_PDG_LIST(300),ID_LIST(577),NAME_LIST(300),
     &                ID_PDG_MAX

C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)


      DIMENSION RWGHT(20),IRPDG(20),IRBAM(20)
      DATA IRPDG /113, 223, 333, 50223, 40113, 60223, 10333, 30113,
     &            12212, 42212, -12212, -42212,
     &            8*0 /
      DATA RWGHT /1.D0, 0.11D0, 0.1D0, 0.11D0, 1.D0, 0.11D0, 0.1D0,
     &            1.D0, 1.D0, 1.D0, 1.D0, 1.D0,
     &            8*1.D0 /

      DATA INIT /0/

C  initialize table
      IF(INIT.EQ.0) THEN
        DO I=1,20
          IF(IRPDG(I).NE.0) THEN
            IRBAM(I) = IPHO_PDG2ID(IRPDG(I))
          ENDIF
        ENDDO
        INIT = 1
      ENDIF

C  copy table with particles and isospin weights
      LISTL = 0
      IF(IDMOTH.EQ.22) THEN
        I1 = 4
        I2 = 8
      ELSE IF(IDMOTH.EQ.2212) THEN
        I1 = 9
        I2 = 10
      ELSE IF(IDMOTH.EQ.-2212) THEN
        I1 = 11
        I2 = 12
      ELSE
        RETURN
      ENDIF

      DO 100 I=I1,I2
        LISTL = LISTL+1
        IDBAM(LISTL) = IRBAM(I)
        IDPDG(LISTL) = IRPDG(I)
        RMASS(LISTL) = XM_LIST(IABS(IDBAM(LISTL)))
        RGAM(LISTL)  = GAM_LIST(IABS(IDBAM(LISTL)))
        RWG(LISTL)   = RWGHT(I)
 100  CONTINUE

C  debug output
      IF(IDEB(85).GE.20) THEN
        WRITE(ErrorOut,
     * '(1X,A,3I7)') 'PHO_DIFRES: mother,quarks',IDMOTH,
     &    IVAL1,IVAL2
        DO 200 I=1,LISTL
          WRITE(ErrorOut,
     * '(1X,I3,2I7,E12.4)') I,IDBAM(I),IDPDG(I),RMASS(I)
 200    CONTINUE
      ENDIF

      END





CDECK  ID>, PHO_MASSAD
      SUBROUTINE PHO_MASSAD(IFLMO,IFL1,IFL2,
     &                     PMASS,XMCON,XMOUT,IDPDG,IDCPC)
C***********************************************************************
C
C    fine-correction of low mass strings to mass of corresponding
C    resonance or two particle threshold
C
C    input:     IFLMO         PDG ID of mother particle
C               IFL1,2        requested parton flavours
C                             (not used at the moment)
C               PMASS         reference mass (mass of mother particle)
C               XMCON         conjecture of mass
C
C    output:    XMOUT         output mass (adjusted input mass)
C                             moved ot nearest mass possible
C               IDPDG         PDG resonance ID
C               IDcpc         CPC resonance ID
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS   =  1.D-8 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)

C  particle decay data
      DOUBLE PRECISION WG_SEC_LIST
      INTEGER          IDEC_LIST,ISEC_LIST
      COMMON /POPAR3/ WG_SEC_LIST(500),IDEC_LIST(3,300),
     &  ISEC_LIST(3,500)


      DIMENSION XWG(10),RMA(10),RGA(10),RWG(10),IRPDG(10),IRBAM(10)

      XMINP = XMCON
      IDPDG = 0
      IDCPC = 0
      XMOUT = XMINP

C  resonance treatment activated?
      IF(ISWMDL(23).EQ.0) RETURN

      CALL PHO_DIFRES(IFLMO,IFL1,IFL2,IRPDG,IRBAM,RMA,RGA,RWG,LISTL)
      IF(LISTL.LT.1) THEN
        IF(IDEB(7).GE.2) WRITE(ErrorOut,'(1X,A,3I7)')
     &    'PHO_MASSAD: NO RESONANCES FOR (IFMO,IF1,IF2)',
     &    IFLMO,IFL1,IFL2
        GOTO 50
      ENDIF
C  mass small?
      PMASSL = (PMASS+0.15D0)**2
      XMINP2 = XMINP**2
C  determine resonance probability
      DM2 = 1.1D0
      RPROB = (PMASSL+DM2)*(XMINP2-PMASSL)/(DM2*XMINP2)
      IF(RPROB.LT.PHO_RNDM(PMASSL)) THEN
C  sample new resonance
        XWGSUM = 0.D0
        DO 100 I=1,LISTL
          XWG(I) = RWG(I)/RMA(I)**2
          XWGSUM = XWGSUM+XWG(I)
 100    CONTINUE

        ITER = 0
 150    CONTINUE
        ITER = ITER+1
        IF(ITER.GE.5) THEN
          IDCPC = 0
          IDPDG = 0
          XMOUT = XMINP
          GOTO 50
        ENDIF

        I = 0
        XI = XWGSUM*PHO_RNDM(XMOUT)
 200    CONTINUE
          I = I+1
          XWGSUM = XWGSUM-XWG(I)
        IF((XI.LT.XWGSUM).AND.(I.LT.LISTL)) GOTO 200
        IDPDG = IRPDG(I)
        IDCPC = IRBAM(I)
        GARES = RGA(I)
        XMRES = RMA(I)
        XMRES2 = XMRES**2
C  sample new mass (from Breit-Wigner cross section)
        ALO = ATAN((PMASSL-XMRES2)/(XMRES*GARES))
        AHI = ATAN((5.D0-XMRES2)/(XMRES*GARES))
        XI = (AHI-ALO)*PHO_RNDM(XMRES)+ALO
        XMOUT = XMRES*GARES*TAN(XI)+XMRES2
        XMOUT = SQRT(XMOUT)

C  check mass for decay
        AMDCY = 2.D0*XMRES
        ID = ABS(IDCPC)
        DO 250 IK=IDEC_LIST(2,ID),IDEC_LIST(3,ID)
          AMSUM = 0.D0
          DO 275 I=1,3
            IF(ISEC_LIST(I,IK).NE.0)
     &        AMSUM = AMSUM + XM_LIST(IABS(ISEC_LIST(I,IK)))
 275      CONTINUE
          AMDCY = MIN(AMDCY,AMSUM)
 250    CONTINUE
        IF(AMDCY.GE.XMOUT) GOTO 150

C  debug output
        IF(IDEB(7).GE.10)
     &    WRITE(ErrorOut,'(1X,2A,/1X,3I6,2E10.3,2I7,2E10.3)')
     &    'PHO_MASSAD: ',
     &    'IFMO,IF1,IF2,XMCON,XMOUT,IDPDG,IDCPC,RMA,RGA',
     &    IFLMO,IFL1,IFL2,XMCON,XMOUT,IDPDG,IDCPC,RMA(I),RGA(I)
        RETURN
      ENDIF

 50   CONTINUE
C  debug output
      IF(IDEB(7).GE.15)
     &  WRITE(ErrorOut,'(1X,A,/1X,3I6,2E10.3)')
     &    'PHO_MASSAD: STRING SAMPLED: IFMO,IF1,IF2,XMCON,XMOUT',
     &    IFLMO,IFL1,IFL2,XMCON,XMOUT

      END




CDECK  ID>, PHO_PDF
      SUBROUTINE PHO_PDF(NPAR,X,SCALE2,P2VIR,PD)
C***************************************************************
C
C     call different PDF sets for different particle types
C
C     input:      NPAR     1     IGRP(1),ISET(1)
C                          2     IGRP(2),ISET(2)
C                 X        momentum fraction
C                 SCALE2   squared scale (GeV**2)
C                 P2VIR    particle virtuality (positive, GeV**2)
C
C     output      PD(-6:6) field containing the x*PDF fractions
C
C***************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      DIMENSION PD(-6:6)

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


      DIMENSION PARAM(20),VALUE(20)
      CHARACTER*20 PARAM

      REAL XR,P2R,Q2R,F2GM,XPDFGM
      DIMENSION XPDFGM(-6:6)

C  check of kinematic boundaries
      XI = X
      IF(X.GT.1.D0) THEN
        IF(IDEB(37).GE.0) THEN
          WRITE(ErrorOut,'(/,1X,A,E15.8/)')
     &      'PHO_PDF: X>1 (CORRECTED TO X=1)',X
          CALL PHO_PREVNT(-1)
        ENDIF
        XI = 0.99999999999D0
      ELSE IF(X.LE.0.D0) THEN
        IF(IDEB(37).GE.0) THEN
          WRITE(ErrorOut,'(/,1X,A,E15.8/)') 'PHO_PDF: X <= 0 ',X
          CALL PHO_PREVNT(-1)
        ENDIF
        XI = 0.0001D0
      ENDIF

      DO 100 I=-6,6
        PD(I) = 0.D0
 100  CONTINUE
      IRET = 1

      IF((NPAR.EQ.1).OR.(NPAR.EQ.2)) THEN

C  internal PDFs

        IF(IEXT(NPAR).EQ.0) THEN
          IF(ITYPE(NPAR).EQ.1) THEN
C  proton PDFs
            IF(IGRP(NPAR).EQ.5) THEN
              IF(ISET(NPAR).EQ.3) THEN
                CALL PHO_DOR92HO(XI,SCALE2,UDV,DV,GL,UDB,SB,CB,BB)
                UV = UDV-DV
                UDB = 2.D0*UDB
                DEL = 0.D0
                IRET = 0
              ELSE IF(ISET(NPAR).EQ.4) THEN
                CALL PHO_DOR92LO(XI,SCALE2,UDV,DV,GL,UDB,SB,CB,BB)
                UV = UDV-DV
                UDB = 2.D0*UDB
                DEL = 0.D0
                IRET = 0
              ELSE IF(ISET(NPAR).EQ.5) THEN
                CALL PHO_DOR94HO(XI,SCALE2,UV,DV,DEL,UDB,SB,GL)
C  heavy quarks from GRV92-HO
                AMU2  = 0.3
                ALAM2 = 0.248 * 0.248
                S  = LOG (LOG(SCALE2/ALAM2) / LOG(AMU2/ALAM2))
                SC  =  0.820
                ALC =   0.98
                BEC =   0.0
                AKC = -0.625 - 0.523 * S
                AGC =   0.0
                BC  =  1.896 + 1.616 * S
                DC  =   4.12 + 0.683 * S
                EC  =   4.36 + 1.328 * S
                ESC =  0.677 + 0.679 * S
                CB  = PHO_DOR92FS(X,S,SC,ALC,BEC,AKC,AGC,BC,DC,EC,ESC)
                SBO =  1.297
                ALB =   0.99
                BEB =   0.0
                AKB =   0.0  - 0.193 * S
                AGB =   0.0
                BBO =   0.0
                DB  =  3.447 + 0.927 * S
                EB  =   4.68 + 1.259 * S
                ESB =  1.892 + 2.199 * S
                BB  = PHO_DOR92FS(X,S,SBO,ALB,BEB,AKB,AGB,BBO,DB,EB,ESB)
                IRET = 0
              ELSE IF(ISET(NPAR).EQ.6) THEN
                CALL PHO_DOR94LO(XI,SCALE2,UV,DV,DEL,UDB,SB,GL)
C  heavy quarks from GRV92-LO
                AMU2  = 0.25
                ALAM2 = 0.232D0**2
                S  = LOG (LOG(SCALE2/ALAM2) / LOG(AMU2/ALAM2))
                SC  =  0.888
                ALC =   1.01
                BEC =   0.37
                AKC =   0.0
                AGC =   0.0
                BC  =   4.24 - 0.804 * S
                DC  =   3.46 + 1.076 * S
                EC  =   4.61 + 1.490 * S
                ESC =  2.555 + 1.961 * S
                CB  = PHO_DOR92FS(X,S,SC,ALC,BEC,AKC,AGC,BC,DC,EC,ESC)
                SBO =  1.351
                ALB =   1.00
                BEB =   0.51
                AKB =   0.0
                AGB =   0.0
                BBO =  1.848
                DB  =  2.929 + 1.396 * S
                EB  =   4.71 + 1.514 * S
                ESB =   4.02 + 1.239 * S
                BB  = PHO_DOR92FS(X,S,SBO,ALB,BEB,AKB,AGB,BBO,DB,EB,ESB)
                IRET = 0
              ELSE IF(ISET(NPAR).EQ.7) THEN
                CALL PHO_DOR94DI(XI,SCALE2, UV, DV, DEL, UDB, SB, GL)
C  heavy quarks from GRV92-HO
                AMU2  = 0.3
                ALAM2 = 0.248 * 0.248
                S  = LOG (LOG(SCALE2/ALAM2) / LOG(AMU2/ALAM2))
                SC  =  0.820
                ALC =   0.98
                BEC =   0.0
                AKC = -0.625 - 0.523 * S
                AGC =   0.0
                BC  =  1.896 + 1.616 * S
                DC  =   4.12 + 0.683 * S
                EC  =   4.36 + 1.328 * S
                ESC =  0.677 + 0.679 * S
                CB  = PHO_DOR92FS(X,S,SC,ALC,BEC,AKC,AGC,BC,DC,EC,ESC)
                SBO =  1.297
                ALB =   0.99
                BEB =   0.0
                AKB =   0.0  - 0.193 * S
                AGB =   0.0
                BBO =   0.0
                DB  =  3.447 + 0.927 * S
                EB  =   4.68 + 1.259 * S
                ESB =  1.892 + 2.199 * S
                BB  = PHO_DOR92FS(X,S,SBO,ALB,BEB,AKB,AGB,BBO,DB,EB,ESB)
                IRET = 0
              ELSE IF(ISET(NPAR).EQ.8) THEN
                CALL PHO_DOR98LO(XI,SCALE2,UV,DV,US,DS,SB,GL)
                DEL = DS-US
                UDB = DS+US
C  heavy quarks from GRV92-LO
                AMU2  = 0.25
                ALAM2 = 0.232D0**2
                S  = LOG (LOG(SCALE2/ALAM2) / LOG(AMU2/ALAM2))
                SC  =  0.888
                ALC =   1.01
                BEC =   0.37
                AKC =   0.0
                AGC =   0.0
                BC  =   4.24 - 0.804 * S
                DC  =   3.46 + 1.076 * S
                EC  =   4.61 + 1.490 * S
                ESC =  2.555 + 1.961 * S
                CB  = PHO_DOR92FS(X,S,SC,ALC,BEC,AKC,AGC,BC,DC,EC,ESC)
                SBO =  1.351
                ALB =   1.00
                BEB =   0.51
                AKB =   0.0
                AGB =   0.0
                BBO =  1.848
                DB  =  2.929 + 1.396 * S
                EB  =   4.71 + 1.514 * S
                ESB =   4.02 + 1.239 * S
                BB  = PHO_DOR92FS(X,S,SBO,ALB,BEB,AKB,AGB,BBO,DB,EB,ESB)
                IRET = 0
              ELSE IF(ISET(NPAR).EQ.9) THEN
*               CALL PHO_DOR98SC(XI,SCALE2,UV,DV,US,DS,SB,GL)
                DEL = DS-US
                UDB = DS+US
C  heavy quarks from GRV92-LO
                AMU2  = 0.25
                ALAM2 = 0.232D0**2
                S  = LOG (LOG(SCALE2/ALAM2) / LOG(AMU2/ALAM2))
                SC  =  0.888
                ALC =   1.01
                BEC =   0.37
                AKC =   0.0
                AGC =   0.0
                BC  =   4.24 - 0.804 * S
                DC  =   3.46 + 1.076 * S
                EC  =   4.61 + 1.490 * S
                ESC =  2.555 + 1.961 * S
                CB  = PHO_DOR92FS(X,S,SC,ALC,BEC,AKC,AGC,BC,DC,EC,ESC)
                SBO =  1.351
                ALB =   1.00
                BEB =   0.51
                AKB =   0.0
                AGB =   0.0
                BBO =  1.848
                DB  =  2.929 + 1.396 * S
                EB  =   4.71 + 1.514 * S
                ESB =   4.02 + 1.239 * S
                BB  = PHO_DOR92FS(X,S,SBO,ALB,BEB,AKB,AGB,BBO,DB,EB,ESB)
                IRET = 0
              ENDIF
              PD(-5) = BB
              PD(-4) = CB
              PD(-3) = SB
              PD(-2) = 0.5D0*(UDB-DEL)
              PD(-1) = 0.5D0*(UDB+DEL)
              PD(0)  = GL
              PD(1)  = DV+PD(-1)
              PD(2)  = UV+PD(-2)
              PD(3)  = PD(-3)
              PD(4)  = PD(-4)
              PD(5)  = PD(-5)
            ENDIF
          ELSE IF(ITYPE(NPAR).EQ.2) THEN
C  pion PDFs (default for pi+)
            IF(IGRP(NPAR).EQ.5) THEN
              IF(ISET(NPAR).EQ.1) THEN
                CALL PHO_DORPHO (XI,SCALE2,VA,GL,QB,CB,BB)
                IRET = 0
              ELSE IF(ISET(NPAR).EQ.2) THEN
                CALL PHO_DORPLO (XI,SCALE2,VA,GL,QB,CB,BB)
                IRET = 0
              ENDIF
              PD(-5) = BB
              PD(-4) = CB
              PD(-3) = QB
              PD(-2) = QB
              PD(-1) = QB+VA
              PD(0)  = GL
              PD(1)  = QB
              PD(2)  = VA+QB
              PD(3)  = QB
              PD(4)  = CB
              PD(5)  = BB
            ENDIF
          ELSE IF(ITYPE(NPAR).EQ.3) THEN
C  photon PDFs
            IF(IGRP(NPAR).EQ.5) THEN
              IF(ISET(NPAR).EQ.1) THEN
                CALL PHO_DORGH0 (XI,SCALE2,UB,DB,SB,CB,BB,GL)
                IRET = 0
              ELSE IF(ISET(NPAR).EQ.2) THEN
                CALL PHO_DORGHO (XI,SCALE2,UB,DB,SB,CB,BB,GL)
                IRET = 0
              ELSE IF(ISET(NPAR).EQ.3) THEN
                CALL PHO_DORGLO (XI,SCALE2,UB,DB,SB,CB,BB,GL)
                IRET = 0
              ENDIF
C  reweight with Drees-Godbole factor
              WGX = 1.D0
              IF(P2VIR.GT.0.001D0) THEN
                WGX = LOG(SCALE2/(P2VIR+PARMDL(144)))
     &               /LOG(SCALE2/PARMDL(144))
                WGX = MAX(WGX,0.D0)
              ENDIF
              PD(-5) = BB*WGX/137.D0
              PD(-4) = CB*WGX/137.D0
              PD(-3) = SB*WGX/137.D0
              PD(-2) = UB*WGX/137.D0
              PD(-1) = DB*WGX/137.D0
              PD(0)  = GL*WGX*WGX/137.D0
              PD(1)  = PD(-1)
              PD(2)  = PD(-2)
              PD(3)  = PD(-3)
              PD(4)  = PD(-4)
              PD(5)  = PD(-5)
            ELSE IF(IGRP(NPAR).EQ.8) THEN
              IF(ISET(NPAR).EQ.1) THEN
                CALL PHO_PHGAL (XI,SCALE2,PD)
                IRET = 0
              ENDIF
            ENDIF
          ELSE IF(ITYPE(NPAR).EQ.20) THEN
C  Pomeron PDFs
            MODE = IGRP(NPAR)
            IF(MODE.EQ.1) THEN
              PD(0) = 6.D0*(1.D0-XI)**5*PARMDL(26)*PARMDL(78)
              IRET = 0
            ELSE IF(MODE.EQ.2) THEN
              PD(0) = 6.D0*XI*(1.D0-XI)*PARMDL(26)*PARMDL(78)
              IRET = 0
            ELSE IF(MODE.EQ.3) THEN
              PD(0) = (0.18D0/XI+5.46D0)*(1.D0-XI)*PARMDL(26)*PARMDL(78)
              IRET = 0
            ELSE IF(MODE.EQ.4) THEN
              CALL PHO_CKMTPD(990,XI,SCALE2,PD)
              DO 105 I=-4,4
                PD(I) = PD(I)*PARMDL(78)
 105          CONTINUE
              IRET = 0
            ENDIF
          ENDIF

C  external PDFs

        ELSE IF(IEXT(NPAR).EQ.2) THEN
C  PDFLIB call: new PDF numbering
          IF(NPAR.NE.NPAOLD) THEN
            PARAM(1) = 'NPTYPE'
            PARAM(2) = 'NGROUP'
            PARAM(3) = 'NSET'
            PARAM(4) = ' '
            VALUE(1) = ITYPE(NPAR)
            VALUE(2) = ABS(IGRP(NPAR))
            VALUE(3) = ISET(NPAR)
            CALL PDFSET(PARAM,VALUE)
          ENDIF
          IF(ITYPE(NPAR).EQ.3) THEN
            IP2 = 0
            CALL STRUCTP(XI,SCALE2,P2VIR,IP2,PD(2),PD(1),PD(-2),PD(-1),
     &                   PD(-3),PD(-4),PD(-5),PD(-6),PD(0))
          ELSE
            SCALE = SQRT(SCALE2)
            CALL STRUCTM(XI,SCALE,PD(2),PD(1),PD(-2),PD(-1),
     &                   PD(-3),PD(-4),PD(-5),PD(-6),PD(0))
          ENDIF
          DO 115 I=3,6
            PD(I) = PD(-I)
 115      CONTINUE
          IF(ITYPE(NPAR).EQ.1) THEN
C  proton valence quarks
            PD(1) = PD(1)+PD(-1)
            PD(2) = PD(2)+PD(-2)
          ELSE IF(ITYPE(NPAR).EQ.2) THEN
C  pi+ valences
            DVAL = PD(1)
            PD(1) = PD(-1)
            PD(-1) = DVAL+PD(1)
            PD(2) = PD(2)+PD(-2)
          ELSE IF(ITYPE(NPAR).EQ.3) THEN
C  photon conventions
            PD(1) = PD(-1)
            PD(2) = PD(-2)
          ENDIF
          IRET = 0

        ELSE IF(IEXT(NPAR).EQ.3) THEN
C  PHOLIB call: version 2.0
          CALL PHVAL(IGRP(NPAR),ISET(NPAR),XI,SCALE2,PD,IRET)
          IF(IRET.LT.0) THEN
            WRITE(ErrorOut,
     * '(/1X,A,I2)') 'PHO_PDF:ERROR:PHVAL return code',IRET
            CALL PHO_ABORT
          ENDIF
          IRET = 0

C  photon PDFs depending on photon virtuality

        ELSE IF(IEXT(NPAR).EQ.4) THEN
          IF(IGRP(NPAR).EQ.1) THEN
C  Schuler/Sjostrand PDF (interface to single precision)
            XR = XI
            Q2R = SCALE2
            P2R = P2VIR
            IP2 = 0
            CALL PHO_SASGAM(ISET(NPAR),XR,Q2R,P2R,IP2,F2GM,XPDFGM)
            DO 120 I=-6,6
              PD(I) = DBLE(XPDFGM(I))
 120        CONTINUE
            IRET = 0
          ELSE IF(IGRP(NPAR).EQ.5) THEN
C  Gluck/Reya/Stratmann
            IF(ISET(NPAR).EQ.4) THEN
              CALL PHO_DORGLV (XI,SCALE2,P2VIR, UB, DB, SB, GL)
              CALL PHO_QPMPDF(4,XI,SCALE2,0.D0,P2VIR,CB)
              IRET = 0
              PD(-5) = 0.D0
              PD(-4) = CB
              PD(-3) = SB/137.D0
              PD(-2) = UB/137.D0
              PD(-1) = DB/137.D0
              PD(0)  = GL/137.D0
              PD(1)  = PD(-1)
              PD(1)  = PD(-1)
              PD(2)  = PD(-2)
              PD(3)  = PD(-3)
              PD(4)  = PD(-4)
              PD(5)  = PD(-5)
            ENDIF
          ENDIF
        ENDIF

C  check for errors

        IF(IRET.NE.0) THEN
          WRITE(ErrorOut,'(/1X,A,/10X,5I6)')
     &      'PHO_PDF:ERROR:UNSUPPORTED PDF(NPAR,IEXT,ITYPE,IGRP,ISET)',
     &      NPAR,IEXT(NPAR),ITYPE(NPAR),IGRP(NPAR),ISET(NPAR)
          CALL PHO_ABORT
        ENDIF
C  error in NPAR
      ELSE
        WRITE(ErrorOut,
     * '(/1X,A,I5)') 'PHO_PDF:ERROR:invalid NPAR(1,2) ',NPAR
        CALL PHO_ABORT
      ENDIF
      NPAOLD = NPAR

C  valence quark treatment

      IF(ITYPE(NPAR).EQ.2) THEN
C  meson conventions
        IF(IPARID(NPAR).EQ.111) THEN
C  pi0 valence quarks
          PD(-1) = (PD(1)+PD(-1))/2.D0
          PD(1)  = PD(-1)
          PD(-2) = (PD(2)+PD(-2))/2.D0
          PD(2)  = PD(-2)
        ELSE IF(ABS(IPARID(NPAR)).EQ.321) THEN
C  K+/-
          VALS = PD(-1)-PD(1)
          PD(-1) = PD(1)
          PD(-3) = PD(-3)+VALS
        ELSE IF(    (IPARID(NPAR).EQ.311)
     &          .OR.(IPARID(NPAR).EQ.310)
     &          .OR.(IPARID(NPAR).EQ.130)) THEN
C  neutral kaons
          VALS = PD(-1)-PD(1)
          VALU = PD(2)-PD(-2)
          PD(-1) = PD(1)
          PD(2) = PD(-2)
          PD(2)  = PD(2)+VALU/2.D0
          PD(-2) = PD(-2)+VALU/2.D0
          PD(3)  = PD(3)+VALS/2.D0
          PD(-3) = PD(-3)+VALS/2.D0
        ENDIF
      ELSE IF(ITYPE(NPAR).EQ.1) THEN
C  nucleon conventions
        IF(ABS(IPARID(NPAR)).EQ.2112) THEN
C  neutron valence quarks
          DUM = PD(1)
          PD(1) = PD(2)
          PD(2) = DUM
C  neutron valence quarks
          DUM = PD(1)
          PD(1) = PD(2)
          PD(2) = DUM
        ELSE IF(ABS(IPARID(NPAR)).EQ.3222) THEN
C  (anti-)sigma+
          VALS = PD(1)-PD(-1)
          PD(1) = PD(-1)
          PD(3) = PD(3)+VALS
        ELSE IF(ABS(IPARID(NPAR)).EQ.3112) THEN
C  (anti-)sigma-
          VALS = PD(1)-PD(-1)
          VALD = PD(2)-PD(-2)
          PD(1) = PD(-1)
          PD(2) = PD(-2)
          PD(1) = PD(1)+VALD
          PD(3) = PD(3)+VALS
        ELSE IF(    (ABS(IPARID(NPAR)).EQ.3212)
     &          .OR.(ABS(IPARID(NPAR)).EQ.3212)) THEN
C  (anti-)sigma0 and (anti-)lambda
          VALS = PD(1)-PD(-1)
          VALD = (PD(2)-PD(-2))/2.D0
          PD(1) = PD(-1)
          PD(2) = PD(-2)
          PD(1) = PD(1)+VALD
          PD(2) = PD(2)+VALD
          PD(3) = PD(3)+VALS
        ENDIF
      ENDIF

C  antiparticle
      IF(IPARID(NPAR).LT.0) THEN
        DO 190 I=1,4
          DUM=PD(I)
          PD(I)=PD(-I)
          PD(-I)=DUM
 190    CONTINUE
      ENDIF

C  optionally remove valence quarks
      IF(IPAVA(NPAR).EQ.0) THEN
        DO 200 I=1,4
          PD(I) = MIN(PD(-I),PD(I))
          PD(-I) = PD(I)
 200    CONTINUE
      ENDIF

C  debug information
      IF(IDEB(37).GE.30) WRITE(ErrorOut,
     &  '(1X,A,I4,1P,3E12.4/,2X,A,6E10.3,/2X,A,E10.3,/2X,A,6E10.3)')
     &  'PHO_PDF: NPAR,X,SCALE**2,P2VIR',
     &  NPAR,X,SCALE2,P2VIR,'PD(-6..-1)',(PD(I),I=-6,-1),
     &  'PD(0)     ',PD(0),'PD(1..6)  ',(PD(I),I=1,6)

      END


CDECK  ID>, PHO_QPMPDF
      SUBROUTINE PHO_QPMPDF(IQ,X,SCALE2,PTREF,PVIRT,FXP)
C***************************************************************
C
C     contribution to photon PDF from box graph
C     (Bethe-Heitler process)
C
C     input:      IQ       quark flavour
C                 SCALE2   scale (GeV**2, positive)
C                 PTREF    reference scale (GeV, positive)
C                 X        parton momentum fraction
C                 PVIRT    photon virtuality (GeV**2, positive)
C                 FXP      x*f(x,Q**2), x times parton density
C
C***************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


      DIMENSION QM(6)
      DATA QM / 0.2D0,0.25D0,0.5D0,1.5D0,4.5D0,174.D0 /

      FXP = 0.D0
      I = ABS(IQ)
C
*     QM2 = MAX(QM(I),PTREF)**2
*     QM2 = MAX(QM2,PVIRT)
*     BBE = (1.D0-X)*SCALE2
*     IF(BBE.LE.0.D0) THEN
*       IF(IDEB(27).GE.5) WRITE(6,'(1X,A,4E10.3)')
*    &    'PHO_QPMPDF: over mass limit (X,Q2,P2,QM)',X,SCALE2,
*    &    PVIRT,QM(I)
*     ENDIF
*     FXP = X*(4.D0-3.D0*MOD(I,2))/9.D0*3.D0/(2.D0*137.D0*PI)
*    &  *((X**2+(1.D0-X)**2)*LOG(BBE/(QM2*X))+8.D0*X*(1.D0-X)-1.D0)
C  Bethe-Heitler process approximation for 2*x*p2/q2 << 1
      QM2 = MAX(QM(I),PTREF)**2
      W2 = SCALE2/X*(1.D0-X-X*PVIRT/SCALE2)
      IF(W2.GT.4.D0*QM2) THEN
        BE = SQRT(1.D0-4.D0*QM2/W2)
        BP = SQRT(1.D0+BE*(1.D0-4.D0*X*X*PVIRT/SCALE2))
        BM = SQRT(1.D0-BE*(1.D0-4.D0*X*X*PVIRT/SCALE2))
*       FXP = X*(4.D0-3.D0*MOD(I,2))/9.D0*3.D0/(137.D0*PI)*(BE*(-1.D0
        FXP = X*Q_CH2(I)*3.D0/(137.D0*PI)*(BE*(-1.D0
     &         +6.D0*X-6.D0*X*X)+2.D0*X*X*((2.D0*QM2-PVIRT)/SCALE2
     &         -4.D0*QM2*QM2/SCALE2**2)*(1.D0/BM-1.D0/BP)
     &         +(X*X+(1.D0-X)**2+X*(1-3.D0*X)*4.D0*QM2/SCALE2
     &         -X*X*8.D0*QM2*QM2/SCALE2**2)*LOG(BP/BM))
      ELSE
        IF(IDEB(27).GE.5) WRITE(ErrorOut,'(1X,A,4E10.3)')
     &    'PHO_QPMPDF: UNDER MASS LIMIT (X,Q2,P2,QM)',X,SCALE2,
     &    PVIRT,QM(I)
      ENDIF
C  debug output
      IF(IDEB(27).GE.20) WRITE(ErrorOut,'(1X,A,I3,1P,5E10.3)')
     &  'PHO_QPMPDF: X,Q2,P2,QM',I,X,SCALE2,PVIRT,QM(I),FXP
      END


CDECK  ID>, PHO_SETPDF
      SUBROUTINE PHO_SETPDF(IDPDG,ITYP,IPAR,ISET,IEXT,IPAVAL,MODE)
C***************************************************************
C
C     assigns  PDF numbers to particles
C
C     input:      IDPDG    PDG number of particle
C                 ITYP     particle type
C                 IPAR     PDF paramertization
C                 ISET     number of set
C                 IEXT     library number for PDF calculation
C                 IPAVAL   (only output)
C                          1 PDF with valence quarks
C                          0 PDF without valence quarks
C                 MODE     -1   add entry to table
C                           1   read from table
C                           2   output of table
C
C***************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
C
C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C
      DIMENSION IPDFS(5,20)
      DATA IENTRY / 0 /
C
      IF(MODE.EQ.1) THEN
        I = 1
        IF(IDPDG.EQ.81) THEN
          IDCMP = IDEQP(1)
          IPAVAL = IHFLS(1)
        ELSE IF(IDPDG.EQ.82) THEN
          IDCMP = IDEQP(2)
          IPAVAL = IHFLS(2)
        ELSE
          IDCMP = IDPDG
          IPAVAL = 1
        ENDIF
200     CONTINUE
          IF(IDCMP.EQ.IPDFS(1,I)) THEN
            ITYP = IPDFS(2,I)
            IPAR = IPDFS(3,I)
            ISET = IPDFS(4,I)
            IEXT = IPDFS(5,I)
            IF(IDEB(80).GE.15) WRITE(ErrorOut,
     * '(1X,A,I7,5X,3I4)')
     &        'PHO_SETPDF: ID,IPAR,ISET,IEXT',IDCMP,IPAR,ISET,IEXT
            RETURN
          ENDIF
          I = I+1
          IF(I.GT.IENTRY) THEN
            WRITE(ErrorOut,'(/1X,A,I7)')
     &        'PHO_SETPDF: NO PDF ASSIGNED TO ',IDCMP
            CALL PHO_ABORT
          ENDIF
        GOTO 200
      ELSE IF(MODE.EQ.-1) THEN
        DO 50 I=1,IENTRY
          IF(IDPDG.EQ.IPDFS(1,I)) THEN
            WRITE(ErrorOut,'(/1X,A,5I6)')
     &        'PHO_SETPDF: overwrite old particle PDF',
     &        IDPDG,IPDFS(2,I),IPDFS(3,I),IPDFS(4,I),IPDFS(5,I)
            GOTO 100
          ENDIF
 50     CONTINUE
        I = IENTRY+1
        IENTRY = I
 100    CONTINUE
        IPDFS(1,I) = IDPDG
        IF(IDPDG.EQ.990) THEN
          ITYP1 = 20
        ELSE IF(IDPDG.EQ.22) THEN
          ITYP1 = 3
        ELSE IF(ABS(IDPDG).LT.1000) THEN
          ITYP1 = 2
        ELSE
          ITYP1 = 1
        ENDIF
        IPDFS(2,I) = ITYP1
        IPDFS(3,I) = IPAR
        IPDFS(4,I) = ISET
        IPDFS(5,I) = IEXT
      ELSE IF(MODE.EQ.-2) THEN
        WRITE(ErrorOut,
     * '(/1X,A)') 'PHO_SETPDF: PDFs assigned by user:'
        DO 150 I=1,IENTRY
          WRITE(ErrorOut,
     * '(5X,I4,A,I7,A,4I5)') I,'  particle:',IPDFS(1,I),
     &      '   PDF-SET  ',IPDFS(2,I),IPDFS(3,I),IPDFS(4,I),IPDFS(5,I)
 150    CONTINUE
      ELSE
        WRITE(ErrorOut,
     * '(/1X,A,I5)') 'PHO_SETPDF:ERROR: unsupported mode ',MODE
      ENDIF
      END


CDECK  ID>, PHO_GETPDF
      SUBROUTINE PHO_GETPDF(NPAR,PDFNA,ALA,Q2MI,Q2MA,XMI,XMA)
C***************************************************************
C
C     get PDF information
C
C     input:      NPAR     1  first PDF in /POPPDF/
C                          2  second PDF in /POPPDF/
C
C     output:     PDFNA    name of PDf parametrization
C                 ALA      QCD LAMBDA (4 flavours, in GeV)
C                 Q2MI     minimal Q2
C                 Q2MA     maximal Q2
C                 XMI      minimal X
C                 XMA      maximal X
C
C***************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      CHARACTER*8 PDFNA

C  PHOLIB 4.15 common
      COMMON /W50512/ QCDL4,QCDL5
      COMMON /W50513/ XMIN,XMAX,Q2MIN,Q2MAX

C  PHOPDF version 2.0 common
      PARAMETER (MAXS=6,MAXP=10)
      CHARACTER*4 CHPAR
      COMMON/PHCOM1/ XLIM(MAXP,0:MAXS,2), Q2LIM(MAXP,0:MAXS,2),
     & NSET(MAXP,2),NFL(MAXP)
      COMMON/PHCOM2/ ALM(MAXP,0:MAXS),CHPAR(MAXP),IORD(MAXP,-MAXS:MAXS)

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD


      DIMENSION PARAM(20),VALUE(20)
      CHARACTER*20 PARAM

      IF((NPAR.NE.1).AND.(NPAR.NE.2)) THEN
        WRITE(ErrorOut,'(/1X,A,I6)')
     &    'PHO_GETPDF:ERROR: INVALID PDF NUMBER (1,2)',NPAR
        CALL PHO_ABORT
      ENDIF
      ALA = 0.D0

      IF(IEXT(NPAR).EQ.0) THEN

C  internal parametrizations

        IF(ITYPE(NPAR).EQ.1) THEN
C  proton PDFs
          IF(IGRP(NPAR).EQ.5) THEN
            IF(ISET(NPAR).EQ.3) THEN
              ALA    = 0.2D0
              Q2MI   = 0.3D0
              PDFNA  = 'GRV92 HO'
            ELSE IF(ISET(NPAR).EQ.4) THEN
              ALA    = 0.2D0
              Q2MI   = 0.25D0
              PDFNA  = 'GRV92 LO'
            ELSE IF(ISET(NPAR).EQ.5) THEN
              ALA    = 0.2D0
              Q2MI   = 0.4D0
              PDFNA  = 'GRV94 HO'
            ELSE IF(ISET(NPAR).EQ.6) THEN
              ALA    = 0.2D0
              Q2MI   = 0.4D0
              PDFNA  = 'GRV94 LO'
            ELSE IF(ISET(NPAR).EQ.7) THEN
              ALA    = 0.2D0
              Q2MI   = 0.4D0
              PDFNA  = 'GRV94 DI'
            ELSE IF(ISET(NPAR).EQ.8) THEN
              ALA    = 0.175D0
              Q2MI   = 0.8D0
              PDFNA  = 'GRV98 LO'
            ELSE IF(ISET(NPAR).EQ.9) THEN
              ALA    = 0.175D0
              Q2MI   = 0.8D0
              PDFNA  = 'GRV98 SC'
            ENDIF
          ENDIF
        ELSE IF(ITYPE(NPAR).EQ.2) THEN
C  pion PDFs
          IF(IGRP(NPAR).EQ.5) THEN
            IF(ISET(NPAR).EQ.1) THEN
              ALA    = 0.2D0
              Q2MI   = 0.3D0
              PDFNA  = 'GRV-P HO'
            ELSE IF(ISET(NPAR).EQ.2) THEN
              ALA    = 0.2D0
              Q2MI   = 0.25D0
              PDFNA  = 'GRV-P LO'
            ENDIF
          ENDIF
        ELSE IF(ITYPE(NPAR).EQ.3) THEN
C  photon PDFs
          IF(IGRP(NPAR).EQ.5) THEN
            IF(ISET(NPAR).EQ.1) THEN
              ALA    = 0.2D0
              Q2MI   = 0.3D0
              PDFNA  = 'GRV-G LH'
            ELSE IF(ISET(NPAR).EQ.2) THEN
              ALA    = 0.2D0
              Q2MI   = 0.3D0
              PDFNA  = 'GRV-G HO'
            ELSE IF(ISET(NPAR).EQ.3) THEN
              ALA    = 0.2D0
              Q2MI   = 0.25D0
              PDFNA  = 'GRV-G LO'
            ENDIF
          ELSE IF(IGRP(NPAR).EQ.8) THEN
            IF(ISET(NPAR).EQ.1) THEN
              ALA    = 0.2D0
              Q2MI   = 4.D0
              PDFNA  = 'AGL-G LO'
            ENDIF
          ENDIF
        ELSE IF(ITYPE(NPAR).EQ.20) THEN
C  pomeron PDFs
          IF(IGRP(NPAR).EQ.4) THEN
            CALL PHO_CKMTPA(990,XMI,XMA,ALA,Q2MI,Q2MA,PDFNA)
          ELSE
            ALA    = 0.3D0
            Q2MI   = 2.D0
            PDFNA  = 'POM-PDF1'
          ENDIF
        ENDIF

C  external parametrizations

      ELSE IF(IEXT(NPAR).EQ.1) THEN
C  PDFLIB call: old numbering
        PARAM(1) = 'MODE'
        PARAM(2) = ' '
        VALUE(1) = IGRP(NPAR)
        CALL PDFSET(PARAM,VALUE)
        Q2MI = Q2MIN
        Q2MA = Q2MAX
        XMI  = XMIN
        XMA  = XMAX
        ALA  = QCDL4
        PDFNA = 'PDFLIB1'
      ELSE IF(IEXT(NPAR).EQ.2) THEN
C  PDFLIB call: new numbering
        PARAM(1) = 'NPTYPE'
        PARAM(2) = 'NGROUP'
        PARAM(3) = 'NSET'
        PARAM(4) = ' '
        VALUE(1) = ITYPE(NPAR)
        VALUE(2) = IGRP(NPAR)
        VALUE(3) = ISET(NPAR)
        CALL PDFSET(PARAM,VALUE)
        Q2MI = Q2MIN
        Q2MA = Q2MAX
        XMI  = XMIN
        XMA  = XMAX
        ALA  = QCDL4
        PDFNA = 'PDFLIB2'
      ELSE IF(IEXT(NPAR).EQ.3) THEN
C  PHOLIB interface
        ALA  = ALM(IGRP(NPAR),ISET(NPAR))
        Q2MI = 2.D0
        PDFNA = CHPAR(IGRP(NPAR))

C  some special internal parametrizations

      ELSE IF(IEXT(NPAR).EQ.4) THEN
C  photon PDFs depending on virtualities
        IF(IGRP(NPAR).EQ.1) THEN
C  Schuler/Sjostrand parametrization
          ALA = 0.2D0
          IF(ISET(NPAR).EQ.1) THEN
            Q2MI = 0.2D0
            PDFNA = 'SAS-1D  '
          ELSE IF(ISET(NPAR).EQ.2) THEN
            Q2MI = 0.2D0
            PDFNA = 'SAS-1M  '
          ELSE IF(ISET(NPAR).EQ.3) THEN
            Q2MI = 2.D0
            PDFNA = 'SAS-2D  '
          ELSE IF(ISET(NPAR).EQ.4) THEN
            Q2MI = 2.D0
            PDFNA = 'SAS-2M  '
          ENDIF
        ELSE IF(IGRP(NPAR).EQ.5) THEN
C  Gluck/Reya/Stratmann parametrization
          IF(ISET(NPAR).EQ.4) THEN
            ALA = 0.2D0
            Q2MI = 0.6D0
            PDFNA = 'GRS-G LO'
          ENDIF
        ENDIF
      ELSE IF(IEXT(NPAR).EQ.5) THEN
C  Schuler/Sjostrand anomalous only
        ALA   = 0.2D0
        Q2MI  = 0.2D0
        PDFNA = 'SAS ANOM'
      ENDIF
      IF(ALA.LT.0.01D0) THEN
        WRITE(ErrorOut,'(/1X,2A,/10X,5I6)')
     &    'PHO_GETPDF:ERROR: ',
     &    'UNSUPPORTED PDF (NPAR,IEXT,ITYPE,IGRP,ISET)',
     &    NPAR,IEXT(NPAR),ITYPE(NPAR),IGRP(NPAR),ISET(NPAR)
        CALL PHO_ABORT
      ENDIF

      END


CDECK  ID>, PHO_ACTPDF
      SUBROUTINE PHO_ACTPDF(IDPDG,K)
C***************************************************************
C
C     activate PDF for QCD calculations
C
C     input:      IDPDG    PDG particle number
C                 K        1  first PDF in /POPPDF/
C                          2  second PDF in /POPPDF/
C                         -2  write current settings
C
C     output:     /POPPDF/
C
C***************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD


      IF(K.GT.0) THEN

C  read PDF from table
        CALL PHO_SETPDF(IDPDG,ITYPE(K),IGRP(K),ISET(K),IEXT(K),
     &                 IPAVA(K),1)
        IPARID(K) = IDPDG
C  get PDF parameters
        CALL PHO_GETPDF(K,PDFNAM(K),PDFLAM(K),PDFQ2M(K),Q2MA,XMI,XMA)
C  initialize alpha_s calculation
        ALAM2 = PDFLAM(K)*PDFLAM(K)
        DUMMY = PHO_ALPHAS(ALAM2,-K)

        IF(IDEB(2).GE.20) THEN
          WRITE(ErrorOut,'(1X,A)')
     &      'PHO_ACTPDF: LAMBDA,Q2MIN,NAME,ITYPE,IPAR,ISET,IEXT,PAR'
          WRITE(ErrorOut,
     * '(1X,A,I2,2E12.3,2X,A8,4I4,I7)') 'SIDE',K,
     &      PDFLAM(K),PDFQ2M(K),PDFNAM(K),ITYPE(K),IGRP(K),ISET(K),
     &      IEXT(K),IPARID(K)
        ENDIF
        NPAOLD = K

      ELSE IF(K.EQ.-2) THEN

C  write table of current PDFs
        WRITE(ErrorOut,'(1X,A)')
     &    'PHO_ACTPDF: LAMBDA,Q2MIN,NAME,ITYPE,IPAR,ISET,IEXT,PAR'
        WRITE(ErrorOut,
     * '(1X,A,2E12.3,2X,A8,4I4,I7)') 'SIDE 1:',PDFLAM(1),
     &    PDFQ2M(1),PDFNAM(1),ITYPE(1),IGRP(1),ISET(1),IEXT(1),
     &    IPARID(1)
        WRITE(ErrorOut,
     * '(1X,A,2E12.3,2X,A8,4I4,I7)') 'SIDE 2:',PDFLAM(2),
     &    PDFQ2M(2),PDFNAM(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),
     &    IPARID(2)

      ELSE

        WRITE(ErrorOut,'(/1X,A,2I4)')
     &    'PHO_ACTPDF:ERROR: INVALID ARGUMENTS',IDPDG,K
        CALL PHO_ABORT

      ENDIF

      END


CDECK  ID>, PHO_PDFTST
      SUBROUTINE PHO_PDFTST(IDPDG,SCALE2,P2MASS)
C*********************************************************************
C
C     structure function test utility
C
C     input:    IDPDG    PDG ID of particle
C               SCALE2   squared scale (GeV**2)
C               P2MASS   particle virtuality (pos, GeV**2)
C
C     output:   tables of PDF, sum rule checking, table of F2
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


      DIMENSION PD(-6:6),PDSUM(-6:6),PDAVE(-6:6),FXP(4)
      CHARACTER*8 PDFNA

      CALL PHO_ACTPDF(IDPDG,1)
      CALL PHO_GETPDF(1,PDFNA,ALA,Q2MI,Q2MA,XMI,XMA)

      WRITE(ErrorOut,
     * '(/,A)') ' *** Structure Function Test Utility ***'
      WRITE(ErrorOut,
     * '(A)') ' ======================================='

      WRITE(ErrorOut,'(/,A,3I10)')
     &  ' USED STRUCTURE FUNCTION:',ITYPE(1),IGRP(1),ISET(1)
      WRITE(ErrorOut,'(A,A)')     ' corresponds to ',PDFNA
      WRITE(ErrorOut,
     * '(A,E12.3)') '  used squared scale (GeV**2):',SCALE2
      WRITE(ErrorOut,
     * '(A,E12.3)') ' particle virtuality (GeV**2):',P2MASS
      WRITE(ErrorOut,'(/1X,A)') 'x times parton densities'
      WRITE(ErrorOut,'(1X,A)') '    X         PD(-4 - 4)'
      WRITE(ErrorOut,'(1X,A)')
     &   ' ============================================================'

C  logarithmic loop over x values
C  upper bound
      XUPPER=0.9999D0
C  lower bound
      XLOWER=1.D-4
C  number of steps
      NSTEP=50

      XFIRST=LOG(XLOWER)
      XDELTA=LOG(XUPPER/XLOWER)/DBLE(NSTEP-1)
      DO 100 I=1,NSTEP
        X=EXP(XFIRST)
        XCONTR=X
        CALL PHO_PDF(1,X,SCALE2,P2MASS,PD)
        IF(X.NE.XCONTR) THEN
          WRITE(ErrorOut,
     * *) ' x changed! old: ',XCONTR,' new: ',X
        ENDIF
        WRITE(ErrorOut,'(1X,1P,10E11.4)') XCONTR,(PD(K),K=-4,4)
        XFIRST=XFIRST+XDELTA
 100  CONTINUE

      IF(IDPDG.EQ.22) THEN
        WRITE(ErrorOut,'(/1X,A)')
     &   'COMPARISON PDF TO CONTRIBUTION DUE TO BOX DIAGRAM'
        WRITE(ErrorOut,
     * '(1X,A)') '    X   PD(1),PB(1), .... ,PD(4),PB(4)'
        WRITE(ErrorOut,'(1X,A)')
     &   ' ============================================================'
        XFIRST=LOG(XLOWER)
        XDELTA=LOG(XUPPER/XLOWER)/DBLE(NSTEP-1)
        DO 110 I=1,NSTEP
          X=EXP(XFIRST)
          CALL PHO_PDF(1,X,SCALE2,P2MASS,PD)
          DO 120 K=1,4
            CALL PHO_QPMPDF(K,X,SCALE2,0.D0,P2MASS,FXP(K))
 120      CONTINUE
          WRITE(ErrorOut,
     * '(1X,1P,9E11.4)') X,(PD(K),FXP(K),K=1,4)
          XFIRST=XFIRST+XDELTA
 110    CONTINUE
      ENDIF

C  check momentum sum rule

      WRITE(ErrorOut,
     * '(/1X,A)') 'PHO_PDFTST: estimate of quark sum rules'
      DO 199 I=-6,6
        PDSUM(I) = 0.D0
        PDAVE(I) = 0.D0
 199  CONTINUE
      ITER=5000
      DO 200 I=1,ITER
        XX=DBLE(I)/DBLE(ITER)
        IF(XX.EQ.1.D0) XX = 0.999999D0
        CALL PHO_PDF(1,XX,SCALE2,P2MASS,PD)
        DO 202 K=-6,6
          PDSUM(K) = PDSUM(K)+PD(K)/XX
          PDAVE(K) = PDAVE(K)+PD(K)
 202    CONTINUE
 200  CONTINUE
      WRITE(ErrorOut,'(1X,A)')
     &  'TABLE: PARTON-ID, DX-INTEGRAL OVER Q(X,Q**2), X*Q(X,Q**2)'
      XSUM = 0.D0
      DO 204 I=-6,6
        PDSUM(I) = PDSUM(I)/DBLE(ITER)
        PDAVE(I) = PDAVE(I)/DBLE(ITER)
        XSUM = XSUM+PDAVE(I)
        WRITE(ErrorOut,'(9X,I3,3X,2E15.4)') I,PDSUM(I),PDAVE(I)
 204  CONTINUE
      WRITE(ErrorOut,'(1X,A)') 'PHO_PDFTST: valence flavours'
      DO 205 I=1,6
        WRITE(ErrorOut,'(9X,I3,E12.4)') I,PDSUM(I)-PDSUM(-I)
 205  CONTINUE
      WRITE(ErrorOut,'(1X,A,E12.4)') 'momentum sum rule',XSUM
      WRITE(ErrorOut,
     * '(A/)') ' ============================================='

C  table of F2

      WRITE(ErrorOut,'(/1X,A,E12.4,/1X,A)')
     &  'PHO_PDFTST: TABLE OF X, F2(X,Q**2) FOR Q**2',SCALE2,
     &  '-----------------------------------------------------'
      ITER=100
      DO 300 I=1,ITER
        XX=DBLE(I)/DBLE(ITER)
        IF(XX.EQ.1.D0) XX = 0.9999D0
        CALL PHO_PDF(1,XX,SCALE2,P2MASS,PD)
        F2 = 0.D0
        DO 302 K=-6,6
          IF(K.NE.0) F2 = F2 + Q_CH2(K)*PD(K)
 302    CONTINUE
        WRITE(ErrorOut,'(5X,1P,2E14.5)') XX,F2
 300  CONTINUE
      WRITE(ErrorOut,
     * '(A/)') ' ============================================='
      END



CDECK  ID>, PHO_REGPAR
      SUBROUTINE PHO_REGPAR(ISTH,IDPDG,IDBAM,JM1,JM2,P1,P2,P3,P4,
     &                  IPHIS1,IPHIS2,IC1,IC2,IPOS,IMODE)
C**********************************************************************
C
C     registration of particle in /POEVT1/ and /POEVT2/
C
C     input:    ISTH             status code of particle
C                                 -2     initial parton hard scattering
C                                 -1     parton
C                                  0     string
C                                  1     visible particle (no color)
C                                  2     decayed particle
C               IDPDG            PDG particle ID code
C               IDBAM            CPC particle ID code
C               JM1,JM2          first and second mother index
C               P1..P4           four momentum
C               IPHIS1           extended history information
C                                  IPHIS1<100: JM1 from particle 1
C                                  IPHIS1>100: JM1 from particle 2
C                                  1    valence quark
C                                  2    valence diquark
C                                  3    sea quark
C                                  4    sea diquark
C                                  (neg. for antipartons)
C               IPHIS2           extended history information
C                                  positive: JM2 from particle 1
C                                  negative: JM2 from particle 2
C                                  (see IPHIS1)
C               IC1,IC2          color labels for partons
C               IMODE            1  register given parton
C                                0  reset /POEVT1/ and /POEVT2/
C                                2  return data of entry IPOS
C
C               IPOS             position of particle in /POEVT1/
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER (DEPS = 1.D-20)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)



      IF(IMODE.EQ.1) THEN
        IF(IDEB(76).GE.26) THEN
          WRITE(ErrorOut,'(1X,A,/2X,I3,I6,3I4,4E10.3)')
     &      'PHO_REGPAR: ISTH,IDPDG,IDBAM,JM1,JM2,P1,P2,P3,P4',
     &      ISTH,IDPDG,IDBAM,JM1,JM2,P1,P2,P3,P4
          WRITE(ErrorOut,'(1X,A,/2X,6I6)')
     &      'PHO_REGPAR: IPHIS1,IPHIS2,IC1,IC2,IPOS,IMODE',
     &      IPHIS1,IPHIS2,IC1,IC2,IPOS,IMODE
        ENDIF
        IF(NHEP.EQ.NMXHEP) THEN
          WRITE(ErrorOut,'(/1X,2A,2I6/)') 'PHO_REGPAR: ',
     &      'NO SPACE LEFT IN /POEVT1/ (NHEP,NMXHEP):',NHEP,NMXHEP
          CALL PHO_ABORT
        ENDIF
        NHEP = NHEP+1
        IDBAMI = IDBAM
        IDPDGI = IDPDG
        IF(ABS(ISTH).LE.2) THEN
          IF((IDBAM.NE.0).AND.(IDPDG.EQ.0)) THEN
            IDPDGI = IPHO_ID2PDG(IDBAM)
          ELSE IF((IDBAM.EQ.0).AND.(IDPDG.NE.0)) THEN
            IDBAMI = IPHO_PDG2ID(IDPDG)
          ENDIF
        ENDIF
C  standard data
        ISTHEP(NHEP) = ISTH
        IDHEP(NHEP)  = IDPDGI
        JMOHEP(1,NHEP) = JM1
        JMOHEP(2,NHEP) = JM2
C  update of mother-daugther relations
        IF(ABS(ISTH).LE.1) THEN
          IF(JM1.GT.0) THEN
            IF(JDAHEP(1,JM1).EQ.0) THEN
              JDAHEP(1,JM1) = NHEP
              ISTHEP(JM1) = 2
            ENDIF
            JDAHEP(2,JM1) = NHEP
          ENDIF
          IF((JM2.NE.JM1).AND.(JM2.GT.0)) THEN
            IF(JDAHEP(1,JM2).EQ.0) THEN
              JDAHEP(1,JM2) = NHEP
              ISTHEP(JM2) = 2
            ENDIF
            JDAHEP(2,JM2) = NHEP
          ELSE IF(JM2.LT.0) THEN
            DO 100 II=JM1+1,-JM2
              IF(JDAHEP(1,II).EQ.0) THEN
                JDAHEP(1,II) = NHEP
                ISTHEP(II) = 2
              ENDIF
              JDAHEP(2,II) = NHEP
100         CONTINUE
          ENDIF
        ENDIF
        PHEP(1,NHEP) = P1
        PHEP(2,NHEP) = P2
        PHEP(3,NHEP) = P3
        PHEP(4,NHEP) = P4
        IF((ABS(ISTH).LE.3).OR.(ISTH.EQ.20).OR.(ISTH.EQ.21)) THEN
          TMP=(P4-P3)*(P4+P3)-P1**2-P2**2
          PHEP(5,NHEP) = SIGN(SQRT(ABS(TMP)),TMP)
        ELSE
          PHEP(5,NHEP) = 0.D0
        ENDIF
        JDAHEP(1,NHEP) = 0
        JDAHEP(2,NHEP) = 0
C  extended information
        IMPART(NHEP) = IDBAMI
C  extended history information
        IPHIST(1,NHEP) = IPHIS1
        IPHIST(2,NHEP) = IPHIS2
C  charge/baryon number or color labels
        IF(ISTH.EQ.1) THEN
          ICOLOR(1,NHEP) = IPHO_CHR3(NHEP,2)
          ICOLOR(2,NHEP) = IPHO_BAR3(NHEP,2)
        ELSE
          ICOLOR(1,NHEP) = IC1
          ICOLOR(2,NHEP) = IC2
        ENDIF

        IPOS = NHEP
        IF(IDEB(76).GE.26) THEN
          WRITE(ErrorOut,'(1X,A,2I4,2X,2I4,E12.3,I5)')
     &      'PHO_REGPAR: IPHIST1/2,IC1/2,MASS,IPOS',IPHIST(1,NHEP),
     &      IPHIST(2,NHEP),ICOLOR(1,NHEP),ICOLOR(2,NHEP),
     &      PHEP(5,NHEP),IPOS
        ENDIF



      ELSE IF(IMODE.EQ.0) THEN
        NHEP   = 0
      ELSE IF(IMODE.EQ.2) THEN
        IF((IPOS.LT.1).OR.(IPOS.GT.NHEP)) THEN
          WRITE(ErrorOut,'(1X,2A,2I8)') 'PHO_REGPAR: ',
     &      'INDEX OUT OF BOUNDS (NHEP,IPOS)',NHEP,IPOS
          RETURN
        ENDIF
        ISTH  = ISTHEP(IPOS)
        IDPDG = IDHEP(IPOS)
        IDBAM = IMPART(IPOS)
        JM1   = JMOHEP(1,IPOS)
        JM2   = JMOHEP(2,IPOS)
        P1    = PHEP(1,IPOS)
        P2    = PHEP(2,IPOS)
        P3    = PHEP(3,IPOS)
        P4    = PHEP(4,IPOS)
        IPHIS1= IPHIST(1,IPOS)
        IPHIS2= IPHIST(2,IPOS)
        IC1   = ICOLOR(1,IPOS)
        IC2   = ICOLOR(2,IPOS)
      ELSE
        WRITE(ErrorOut,
     * '(1X,A,I8)') 'PHO_REGPAR: invalid mode',IMODE
      ENDIF
      END



CDECK  ID>, IPHO_CNV1
      INTEGER FUNCTION IPHO_CNV1(IPART)
C*********************************************************************
C
C     conversion of quark numbering scheme to PARTICLE DATA GROUP
C                                             convention
C
C     input:   old internal particle code of hard scattering
C                    0   gluon
C                    1   d
C                    2   u
C                    3   s
C                    4   c
C     valence quarks changed to standard numbering
C
C     output:  standard particle codes
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
C
      II = ABS(IPART)
C  change gluon number
      IF(II.EQ.0) THEN
        IPHO_CNV1 = 21
C  change valence quark
      ELSE IF((II.GT.6).AND.(II.LT.13)) THEN
        IPHO_CNV1 = SIGN(II-6,IPART)
      ELSE
        IPHO_CNV1 = IPART
      ENDIF
      END


CDECK  ID>, PHO_HACODE
      SUBROUTINE PHO_HACODE(ID1,ID2,IDCPC1,IDCPC2)
C*********************************************************************
C
C     determination of hadron index from quarks
C
C     input:   ID1,ID2   parton code according to PDG conventions
C
C     output:  IDcpc1,2  CPC particle codes
C
C*********************************************************************

      IMPLICIT NONE

      SAVE

      INTEGER ID1,ID2,IDCPC1,IDCPC2

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)


C  local variables
      INTEGER II,JJ,KK,I1,I2

      IDCPC1 = 0
      IDCPC2 = 0

      IF(ID1*ID2.LT.0) THEN
C  meson
        IF(ID1.GT.0) THEN
          II = ID1
          JJ = -ID2
        ELSE
          II = ID2
          JJ = -ID1
        ENDIF
        IDCPC1 = ID_PSM_LIST(II,JJ)
        IDCPC2 = ID_VEM_LIST(II,JJ)

      ELSE
C  baryon
        I1 = ABS(ID1)
        I2 = ABS(ID2)
        IF(I1.GT.6) THEN
          II = I1/1000
          JJ = (I1-II*1000)/100
          KK = I2
        ELSE
          II = I1
          JJ = I2/1000
          KK = (I2-JJ*1000)/100
        ENDIF
        IDCPC1 = SIGN(ID_B8_LIST(II,JJ,KK),ID1)
        IDCPC2 = SIGN(ID_B10_LIST(II,JJ,KK),ID1)

      ENDIF

      END



CDECK  ID>, PHO_ID2STR
      SUBROUTINE PHO_ID2STR(ID1,ID2,NOBAM,IBAM1,IBAM2,IBAM3,IBAM4)
C*********************************************************************
C
C     conversion of quark numbering scheme
C
C     input:   standard particle codes:
C                       ID1
C                       ID2
C
C     output:  NOBAM    CPC string code
C              quark codes (PDG convention):
C                       IBAM1
C                       IBAM2
C                       IBAM3
C                       IBAM4
C
C              NOBAM = -1 invalid flavour combinations
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      IDA1 = ABS(ID1)
      IDA2 = ABS(ID2)

C  quark-antiquark string
      IF((IDA1.LE.6).AND.(IDA2.LE.6)) THEN
        IF((ID1*ID2).GE.0) GOTO 100
        IBAM1 = ID1
        IBAM2 = ID2
        IBAM3 = 0
        IBAM4 = 0
        NOBAM = 3
C  quark-diquark string
      ELSE IF((IDA2.GT.6).AND.(IDA1.LE.6)) THEN
        IF((ID1*ID2).LE.0) GOTO 100
        IBAM1 = ID1
        IBAM2 = ID2/1000
        IBAM3 = (ID2-IBAM2*1000)/100
        IBAM4 = 0
        NOBAM = 4
C  diquark-quark string
      ELSE IF((IDA1.GT.6).AND.(IDA2.LE.6)) THEN
        IF((ID1*ID2).LE.0) GOTO 100
        IBAM1 = ID1/1000
        IBAM2 = (ID1-IBAM1*1000)/100
        IBAM3 = ID2
        IBAM4 = 0
        NOBAM = 6
C  gluon-gluon string
      ELSE IF((IDA1.EQ.21).AND.(IDA2.EQ.21)) THEN
        IBAM1 = 21
        IBAM2 = 21
        IBAM3 = 0
        IBAM4 = 0
        NOBAM = 7
C  diquark-antidiquark string
      ELSE IF((IDA1.GT.6).AND.(IDA2.GT.6)) THEN
        IF((ID1*ID2).GE.0) GOTO 100
        IBAM1 = ID1/1000
        IBAM2 = (ID1-IBAM1*1000)/100
        IBAM3 = ID2/1000
        IBAM4 = (ID2-IBAM3*1000)/100
        NOBAM = 5
      ENDIF
      RETURN

C  invalid combination
 100  CONTINUE
        WRITE(ErrorOut,'(//1X,A,2I10)')
     &    'PHO_ID2STR: INVALID FLAVORS FOR STRING (ID1,ID2)',ID1,ID2
        CALL PHO_ABORT

      END



CDECK  ID>, PHO_MKSLTR
      SUBROUTINE PHO_MKSLTR(P1,P2,GAM,GAMB)
C********************************************************************
C
C     calculate successive Lorentz boots for arbitrary Lorentz trans.
C
C     input:   P1                initial 4 vector
C              GAM(3),GAMB(3)    Lorentz boost parameters
C
C     output:  P2                final  4 vector
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
C
      DIMENSION P1(4),P2(4),GAM(3),GAMB(3)
C
      P2(4) = P1(4)
      DO 150 I=1,3
        P2(I)=GAM(I)*P1(I)+GAMB(I)*P2(4)
        P2(4)=GAM(I)*P2(4)+GAMB(I)*P1(I)
 150  CONTINUE
      END


CDECK  ID>, PHO_GETLTR
      SUBROUTINE PHO_GETLTR(P1,P2,GAM,GAMB,DELE,IREJ)
C********************************************************************
C
C     calculate Lorentz boots for arbitrary Lorentz transformation
C
C     input:   P1    initial 4 vector
C              P2    final 4 vector
C
C     output:  GAM(3),GAMB(3)
C              DELE   energy deviation
C              IREJ   0 success
C                     1 failure
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
C
      PARAMETER ( DREL = 0.001D0 )

      DIMENSION P1(4),P2(4),GAM(3),GAMB(3),PA(4),PP(4)
C
      IREJ = 1
      DO 50 K=1,4
        PA(K) = P1(K)
        PP(K) = P1(K)
 50   CONTINUE
      PM1 = P1(4)**2-P1(1)**2-P1(2)**2-P1(3)**2
      DO 100 I=1,3
        PP(I) = P2(I)
        PP(4) = PM1+PP(1)**2+PP(2)**2+PP(3)**2
        IF(PP(4).LE.0.D0) RETURN
        PP(4) = SQRT(PP(4))
        GAMB(I) = (SQRT(PA(4)**2-PA(I)**2+PP(I)**2)*PP(I)
     &             -PA(4)*PA(I))/(PA(4)**2+PP(I)**2)
        GAM(I) = 1.D0/SQRT(1.D0-GAMB(I)**2)
        GAMB(I) = GAMB(I)*GAM(I)
        DO 150 K=1,4
          PA(K) = PP(K)
 150    CONTINUE
 100  CONTINUE
      DELE = P2(4)-PP(4)
      IREJ = 0
C  consistency check
*     IF(ABS(P2(4)-PP(4))/MAX(P2(4),PP(4)).GT.DREL) THEN
*       PM2 = P2(4)**2-P2(1)**2-P2(2)**2-P2(3)**2
*       WRITE(6,'(/1X,A,2E12.5)')
*    &    'PHO_GETLTR: INCONSISTENT ENERGIES',P2(4),PP(4)
*       WRITE(6,'(1X,A,2E12.4)') 'INPUT MASSES',PM1,PM2
*       WRITE(6,'(1X,A,4E12.4)') 'INPUT ',P1
*       WRITE(6,'(1X,A,4E12.4)') 'OUTPUT',P2
*       WRITE(6,'(1X,A,4E12.4)') 'INTERN',PP
*     ENDIF
      END


CDECK  ID>, PHO_ALTRA
      SUBROUTINE PHO_ALTRA(GA,BGX,BGY,BGZ,PCX,PCY,PCZ,EC,P,PX,PY,PZ,E)
C*********************************************************************
C
C    arbitrary Lorentz transformation
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      EP=PCX*BGX+PCY*BGY+PCZ*BGZ
      PE=EP/(GA+1.D0)+EC
      PX=PCX+BGX*PE
      PY=PCY+BGY*PE
      PZ=PCZ+BGZ*PE
      P=SQRT(PX*PX+PY*PY+PZ*PZ)
      E=GA*EC+EP

      END


CDECK  ID>, PHO_LTRANS
      SUBROUTINE PHO_LTRANS(GAM,BGAM,CX,CY,CZ,COD,COF,SIF,P,ECM,
     &                 PL,CXL,CYL,CZL,EL)
C**********************************************************************
C
C     Lorentz transformation into lab - system
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER ( TINY=1.D-08,TINY2=1.D-30 )

      SID=SQRT(1.D0-COD*COD)
      PLX=P*SID*COF
      PLY=P*SID*SIF
      PCMZ=P*COD
      PLZ=GAM*PCMZ+BGAM*ECM
      PL=SQRT(PLX*PLX+PLY*PLY+PLZ*PLZ)
      EL=GAM*ECM+BGAM*PCMZ

C  rotation into the original direction
      COZ=PLZ/PL
      SIZ=SQRT(MAX((1.D0-COZ)*(1.D0+COZ),0.D0))

*      CALL PHO_DTRANS(CX,CY,CZ,COZ,SIZ,COF,SIF,CXL,CYL,CZL)

      AX=ABS(CX)
      AY=ABS(CY)
      IF(AX.LT.AY) THEN
        AMAX=AY
        AMIN=AX
      ELSE
        AMAX=AX
        AMIN=AY
      ENDIF
      IF (ABS(CX)-TINY) 1,1,2
    1 IF (ABS(CY)-TINY) 3,3,2

    3 CONTINUE
*     WRITE(6,*)' PHO_DTRANS CX CY CZ =',CX,CY,CZ
      CXL=SIZ*COF
      CYL=SIZ*SIF
      CZL=COZ*CZ
*     WRITE(6,*)' PHO_DTRANS CXL=SIZ*COF CYL=SIZ*SIF CZL=COZ'
*     WRITE(6,*) CXL,CYL,CZL
      RETURN

    2 CONTINUE
      IF(AMAX.GT.TINY2) THEN
        AR=AMIN/AMAX
        AR=AR*AR
        A=AMAX*SQRT(1.D0+AR)
      ELSE
*       WRITE(6,*)' PHO_DTRANS AMAX LE TINY2 '
        GOTO 3
      ENDIF
      XI=SIZ*COF
      YI=SIZ*SIF
      ZI=COZ
      CXL=-CY*XI/A-CZ*CX*YI/A+CX*ZI
      CYL=CX*XI/A-CZ*CY*YI/A+CY*ZI
      CZL=A*YI+CZ*ZI

      END


CDECK  ID>, PHO_TRANS
      SUBROUTINE PHO_TRANS(XO,YO,ZO,CDE,SDE,CFE,SFE,X,Y,Z)
C**********************************************************************
C
C  rotation of coordinate frame (1) de rotation around y axis
C                               (2) fe rotation around z axis
C  (inverse rotation to PHO_TRANI)
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      X= CDE*CFE*XO-SFE*YO+SDE*CFE*ZO
      Y= CDE*SFE*XO+CFE*YO+SDE*SFE*ZO
      Z=-SDE    *XO       +CDE    *ZO

      END


CDECK  ID>, PHO_TRANI
      SUBROUTINE PHO_TRANI(XO,YO,ZO,CDE,SDE,CFE,SFE,X,Y,Z)
C**********************************************************************
C
C  rotation of coordinate frame (1) -fe rotation around z axis
C                               (2) -de rotation around y axis
C  (inverse rotation to PHO_TRANS)
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      X= CDE*CFE*XO+CDE*SFE*YO-SDE*ZO
      Y=-SFE    *XO+CFE*    YO
      Z= SDE*CFE*XO+SDE*SFE*YO+CDE*ZO

      END







CDECK  ID>, pho_cpcini
      SUBROUTINE PHO_CPCINI(NROWS,NUMBER,LIST)
C***********************************************************************
C
C     initialization of particle hash table
C
C     input:   Number     vector with Nrows entries according to PDG
C                         convention
C
C     output:  List       vector with hash table
C
C     (this code is based on the function initpns written by
C      Gerry Lynch, LBL, January 1990)
C
C***********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      INTEGER NUMBER(*),LIST(*),NROWS

      INTEGER NIN,NOUT,IP,I


      DO I = 1,577
        LIST(I) = 0
      ENDDO

C    Loop over all of the elements in the Number vector

        DO 500 IP = 1,NROWS
            NIN = NUMBER(IP)

C    Calculate a list number for this particle id number
            IF(NIN.GT.99999.OR.NIN.LE.0) THEN
                 NOUT = -1
            ELSE IF(NIN.LE.577) THEN
                 NOUT = NIN
            ELSE
                 NOUT = MOD(NIN,577)
            END IF

 200        CONTINUE

            IF(NOUT.LT.0) THEN
C    Count the bad entries
                WRITE(ErrorOut,'(1X,A,I10)')
     &            'PHO_CPCINI: INVALID PARTICLE ID',NIN
                GO TO 500
            END IF
            IF(LIST(NOUT).EQ.0) THEN
                LIST(NOUT) = IP
            ELSE
                IF(NIN.EQ.NUMBER(LIST(NOUT))) THEN
                  WRITE(ErrorOut,'(1X,A,I10)')
     &              'PHO_CPCINI: DOUBLE PARTICLE ID',NIN
                END IF
                NOUT = NOUT + 5
                IF(NOUT.GT.577) NOUT = MOD(NOUT, 577)



                GO TO 200
            END IF
 500      CONTINUE

      END




CDECK  ID>, ipho_pdg2id
      INTEGER FUNCTION IPHO_PDG2ID(IDPDG)
C**********************************************************************
C
C     calculation internal particle code using the particle index i
C     according to the PDG proposal.
C
C     input:  IDpdg          PDG particle number
C     output: ipho_pdg2id    internal particle code
C                            (0 for invalid IDpdg)
C
C     the hash algorithm is based on a program by Gerry Lynch
C
C**********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      INTEGER IDPDG

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  particle ID translation table
      INTEGER         ID_PDG_LIST,ID_LIST,ID_PDG_MAX
      CHARACTER*12    NAME_LIST
      COMMON /POPAR1/ ID_PDG_LIST(300),ID_LIST(577),NAME_LIST(300),
     &                ID_PDG_MAX


      INTEGER NIN,NOUT


      NIN = ABS(IDPDG)

      IF((NIN.GT.99999).OR.(NIN.EQ.0)) THEN
C  invalid particle number
        IF(IDEB(71).GT.5) WRITE(ErrorOut,'(1x,A,I10)')
     &    'IPHO_PDG2ID: INVALID PDG ID NUMBER ',IDPDG
        IPHO_PDG2ID = 0
        RETURN
      ELSE IF(NIN.LE.577) THEN
C  simple case
        NOUT = NIN
      ELSE
C  use hash algorithm
        NOUT = MOD(NIN,577)
      ENDIF

 100  CONTINUE

C  particle not in table
      IF(ID_LIST(NOUT).EQ.0) THEN
        IF(IDEB(71).GE.0) WRITE(ErrorOut,'(1x,A,I10)')
     &    'IPHO_PDG2ID: PARTICLE NOT IN TABLE ',IDPDG
        IPHO_PDG2ID = 0
        RETURN
      ENDIF

      IF(ID_PDG_LIST(ID_LIST(NOUT)).EQ.NIN) THEN
C  particle ID found
        IPHO_PDG2ID = SIGN(ID_LIST(NOUT),IDPDG)
        RETURN
      ELSE
C  increment and try again
        NOUT = NOUT + 5
        IF(NOUT.GT.577) NOUT = MOD(NOUT,577)
        GOTO 100
      ENDIF

      END



CDECK  ID>, IPHO_ID2PDG
      INTEGER FUNCTION IPHO_ID2PDG(IDCPC)
C**********************************************************************
C
C     conversion of internal particle code to PDG standard
C
C     input:     IDcpc        internal particle number
C     output:    ipho_id2pdg  PDG particle number
C                             (0 for invalid IDcpc)
C
C**********************************************************************

      IMPLICIT NONE

      SAVE

      INTEGER IDCPC

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  particle ID translation table
      INTEGER         ID_PDG_LIST,ID_LIST,ID_PDG_MAX
      CHARACTER*12    NAME_LIST
      COMMON /POPAR1/ ID_PDG_LIST(300),ID_LIST(577),NAME_LIST(300),
     &                ID_PDG_MAX


      INTEGER IDABS

      IDABS = ABS(IDCPC)
      IF((IDABS.LT.1).OR.(IDABS.GT.ID_PDG_MAX)) THEN
        IPHO_ID2PDG = 0
        RETURN
      ENDIF

      IPHO_ID2PDG = SIGN(ID_PDG_LIST(IDABS),IDCPC)

      END



CDECK  ID>, IPHO_LU2PDG
      INTEGER FUNCTION IPHO_LU2PDG(LUKF)
C**********************************************************************
C
C    conversion of JETSET KF code to PDG code
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (NTAB=10)
      DIMENSION LU2PD(2,NTAB)
      DATA LU2PD / 4232, 4322,
     &             4322, 4232,
     &             3212, 3122,
     &             3122, 3212,
     &            30553, 20553,
     &            30443, 20443,
     &            20443, 10443,
     &            10443, 0,
     &            511,   0,
     &            10551, 551 /
C
      DO 100 I=1,NTAB
        IF(LU2PD(1,I).EQ.LUKF) THEN
          IPHO_LU2PDG=LU2PD(2,I)
          RETURN
        ENDIF
 100  CONTINUE
      IPHO_LU2PDG=LUKF

      END


CDECK  ID>, IPHO_PDG2LU
      INTEGER FUNCTION IPHO_PDG2LU(IPDG)
C**********************************************************************
C
C    conversion of PDG code to JETSET code
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (NTAB=8)
      DIMENSION LU2PD(2,NTAB)
      DATA LU2PD / 4232, 4322,
     &             4322, 4232,
     &             3212, 3122,
     &             3122, 3212,
     &            30553, 20553,
     &            30443, 20443,
     &            20443, 10443,
     &            10551, 551 /
C
      DO 100 I=1,NTAB
        IF(LU2PD(2,I).EQ.IPDG) THEN
          IPHO_PDG2LU=LU2PD(1,I)
          RETURN
        ENDIF
 100  CONTINUE
      IPHO_PDG2LU=IPDG

      END


CDECK  ID>, pho_pname
      CHARACTER*15 FUNCTION PHO_PNAME(ID,MODE)
C***********************************************************************
C
C     returns particle name for given ID number
C
C     input:  ID      particle ID number
C             mode    0:   ID treated as compressed particle code
C                     1:   ID treated as PDG number
C
C***********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      INTEGER ID,MODE


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  particle ID translation table
      INTEGER         ID_PDG_LIST,ID_LIST,ID_PDG_MAX
      CHARACTER*12    NAME_LIST
      COMMON /POPAR1/ ID_PDG_LIST(300),ID_LIST(577),NAME_LIST(300),
     &                ID_PDG_MAX

C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)


C  external functions
      INTEGER IPHO_ID2PDG,IPHO_PDG2ID

C  local variables
      INTEGER  IDPDG,I,II,K,L,ICHAR,I_ANTI
      CHARACTER*15 NAME

      PHO_PNAME = '(?????????????)'

      IF(MODE.EQ.0) THEN
        I = ID
        IDPDG = IPHO_ID2PDG(ID)
        IF(IDPDG.EQ.0) RETURN
      ELSE IF(MODE.EQ.1) THEN
        I = IPHO_PDG2ID(ID)
        IF(I.EQ.0) RETURN
        IDPDG = ID
      ELSE IF(MODE.EQ.2) THEN
        IF(ISTHEP(ID).GT.11) THEN
          IF(ISTHEP(ID).EQ.20) THEN
            PHO_PNAME = 'HARD INI. PART.'
          ELSE IF(ISTHEP(ID).EQ.21) THEN
            PHO_PNAME = 'HARD FIN. PART.'
          ELSE IF(ISTHEP(ID).EQ.25) THEN
            PHO_PNAME = 'HARD SCATTERING'
          ELSE IF(ISTHEP(ID).EQ.30) THEN
            PHO_PNAME = 'DIFF. DISS.    '
          ELSE IF(ISTHEP(ID).EQ.35) THEN
            PHO_PNAME = 'ELASTIC SCATT. '
          ELSE IF(ISTHEP(ID).EQ.40) THEN
            PHO_PNAME = 'CENTRAL SCATT. '
          ENDIF
          RETURN
        ENDIF
        IDPDG = IDHEP(ID)
        I     = IMPART(ID)
      ELSE
        WRITE(ErrorOut,'(1x,a,2i4)')
     &    'PHO_PNAME: INVALID ARGUMENTS (ID,MODE): ',ID,MODE
        RETURN
      ENDIF

      II = ABS(I)
      IF((II.EQ.0).OR.(II.GT.ID_PDG_MAX)) RETURN

      NAME = NAME_LIST(II)
      ICHAR = ICH3_LIST(II)*SIGN(1,I)
      IF(MOD(ICHAR,3).NE.0) THEN
        ICHAR = 0
      ELSE
        ICHAR = ICHAR/3
      ENDIF

C  find position of first blank character
      K = 1
 100  CONTINUE
        K = K+1
      IF(NAME(K:K).NE.' ') GOTO 100

C  append anti-particle sign
      IF(I.LT.0) THEN
        I_ANTI = 0
        DO L=1,3
          I_ANTI = I_ANTI+IQ_LIST(L,II)
        ENDDO
        IF(IBA3_LIST(II).NE.0) THEN
          NAME(K:K) = '~'
          K = K+1
        ELSE IF(((I_ANTI.NE.0).AND.(ICHAR.EQ.0))
     &          .OR.(IDPDG.EQ.-12)
     &          .OR.(IDPDG.EQ.-14)
     &          .OR.(IDPDG.EQ.-16)) THEN
          NAME(K:K) = '~'
          K = K+1
        ENDIF
      ENDIF

C  append charge sign
      IF(ICHAR.EQ.-2) THEN
        NAME(K:K+1) = '--'
      ELSE IF(ICHAR.EQ.-1) THEN
        NAME(K:K) = '-'
      ELSE IF(ICHAR.EQ.1) THEN
        NAME(K:K) = '+'
      ELSE IF(ICHAR.EQ.2) THEN
        NAME(K:K+1) = '++'
      ENDIF

      PHO_PNAME = NAME

      END



CDECK  ID>, ipho_anti
      INTEGER FUNCTION IPHO_ANTI(ID)
C**********************************************************************
C
C     determine antiparticle for given ID
C
C     input:  ID gives CPC particle number
C
C     output: ipho_anti antiparticle code
C
C**********************************************************************

      IMPLICIT NONE

      SAVE

      INTEGER ID

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  particle ID translation table
      INTEGER         ID_PDG_LIST,ID_LIST,ID_PDG_MAX
      CHARACTER*12    NAME_LIST
      COMMON /POPAR1/ ID_PDG_LIST(300),ID_LIST(577),NAME_LIST(300),
     &                ID_PDG_MAX

C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)



C  external functions
      INTEGER IPHO_ID2PDG,IPHO_PDG2ID

C  local variables
      INTEGER IDABS,IDPDG,I_ANTI,L

      IPHO_ANTI = -ID
      IDABS = ABS(ID)


C  baryons
      IF(IBA3_LIST(IDABS).NE.0) RETURN

C  charged particles
      IF(ICH3_LIST(IDABS).NE.0) RETURN

C  K0_s and K0_l
      IDPDG = IPHO_ID2PDG(ID)
      IF(IDPDG.EQ.310) THEN
        ID = IPHO_PDG2ID(130)
        RETURN
      ELSE IF(IDPDG.EQ.130) THEN
        ID = IPHO_PDG2ID(310)
        RETURN
      ENDIF

C  neutral mesons with open strangeness, charm, or beauty
      I_ANTI = 0
      DO L=1,3
        I_ANTI = I_ANTI+IQ_LIST(L,IDABS)
      ENDDO
      IF(I_ANTI.NE.0) RETURN

C  neutrinos
      IDPDG = ABS(IDPDG)
      IF((IDPDG.EQ.12).OR.(IDPDG.EQ.14).OR.(IDPDG.EQ.16)) RETURN

      IPHO_ANTI = ID

      END



CDECK  ID>, ipho_chr3
      INTEGER FUNCTION IPHO_CHR3(ID,MODE)
C**********************************************************************
C
C     output of three times the electric charge
C
C     input:  mode
C             0   ID gives CPC particle number
C             1   ID gives PDG particle number
C             2   ID gives position of particle in /POEVT1/
C
C**********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      INTEGER ID,MODE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  particle ID translation table
      INTEGER         ID_PDG_LIST,ID_LIST,ID_PDG_MAX
      CHARACTER*12    NAME_LIST
      COMMON /POPAR1/ ID_PDG_LIST(300),ID_LIST(577),NAME_LIST(300),
     &                ID_PDG_MAX

C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)


C  external functions
      INTEGER IPHO_PDG2ID

C  local variables
      INTEGER I,IDPDG

      IPHO_CHR3 = 0

      IF(MODE.EQ.0) THEN
        I = ID
      ELSE IF(MODE.EQ.1) THEN
        I = IPHO_PDG2ID(ID)
        IF(I.EQ.0) RETURN
        IDPDG = ID
      ELSE IF(MODE.EQ.2) THEN
        IF(ISTHEP(ID).GT.11) RETURN
        I     = IMPART(ID)
        IDPDG = IDHEP(ID)
        IF((IDPDG.EQ.90).OR.(IDPDG.EQ.91).OR.(IDPDG.EQ.92)) THEN
          IPHO_CHR3 = ICOLOR(1,ID)
          RETURN
        ENDIF
      ELSE
        WRITE(ErrorOut,'(1x,a,2i4)')
     &    'IPHO_CHR3: INVALID MODE (ID,MODE): ',ID,MODE
        RETURN
      ENDIF


      IF((I.EQ.0).OR.(IABS(I).GT.ID_PDG_MAX)) THEN
        WRITE(ErrorOut,'(1x,a,3i8)')
     &    'IPHO_CHR3: INVALID ARGUMENTS (ID,MODE,I): ',ID,MODE,I
        IPHO_CHR3 = 1.D0/DBLE(I)
        CALL PHO_PREVNT(0)
        RETURN
      ENDIF


      IPHO_CHR3 = ICH3_LIST(IABS(I))*SIGN(1,I)

      END




CDECK  ID>, ipho_bar3
      INTEGER FUNCTION IPHO_BAR3(ID,MODE)
C**********************************************************************
C
C     output of three times the baryon charge
C
C     index:  MODE
C             0   ID gives CPC particle number
C             1   ID gives PDG particle number
C             2   ID gives position of particle in /POEVT1/
C
C**********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      INTEGER ID,MODE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  particle ID translation table
      INTEGER         ID_PDG_LIST,ID_LIST,ID_PDG_MAX
      CHARACTER*12    NAME_LIST
      COMMON /POPAR1/ ID_PDG_LIST(300),ID_LIST(577),NAME_LIST(300),
     &                ID_PDG_MAX

C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)


C  external functions
      INTEGER IPHO_PDG2ID

C  local variables
      INTEGER I,IDPDG

      IPHO_BAR3 = 0

      IF(MODE.EQ.0) THEN
        I = ID
      ELSE IF(MODE.EQ.1) THEN
        I = IPHO_PDG2ID(ID)
        IF(I.EQ.0) RETURN
        IDPDG = ID
      ELSE IF(MODE.EQ.2) THEN
        IF(ISTHEP(ID).GT.11) RETURN
        I     = IMPART(ID)
        IDPDG = IDHEP(ID)
        IF((IDPDG.EQ.90).OR.(IDPDG.EQ.91).OR.(IDPDG.EQ.92)) THEN
          IPHO_BAR3 = ICOLOR(2,ID)
          RETURN
        ENDIF
      ELSE
        WRITE(ErrorOut,'(1x,a,2i4)')
     &    'IPHO_BAR3: INVALID MODE (ID,MODE): ',ID,MODE
        RETURN
      ENDIF


      IF((I.EQ.0).OR.(IABS(I).GT.ID_PDG_MAX)) THEN
        WRITE(ErrorOut,'(1x,a,3i8)')
     &    'IPHO_BAR3: INVALID ARGUMENTS (ID,MODE,I): ',ID,MODE,I
        IPHO_BAR3 = 1.D0/DBLE(I)
        RETURN
      ENDIF


      IPHO_BAR3 = IBA3_LIST(IABS(I))*SIGN(1,I)

      END




CDECK  ID>, pho_pmass
      DOUBLE PRECISION FUNCTION PHO_PMASS(ID,MODE)
C***********************************************************************
C
C     particle mass
C
C     input:  mode  -1   initialization
C                    0   ID gives CPC particle number
C                    1   ID gives PDG particle number,
C                        (for quarks current masses are returned)
C                    2   ID gives position of particle in /POEVT1/
C                    3   ID gives PDG parton number,
C                        (for quarks constituent masses are returned)
C
C     output: average particle mass (in GeV)
C
C***********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      INTEGER ID,MODE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  particle ID translation table
      INTEGER         ID_PDG_LIST,ID_LIST,ID_PDG_MAX
      CHARACTER*12    NAME_LIST
      COMMON /POPAR1/ ID_PDG_LIST(300),ID_LIST(577),NAME_LIST(300),
     &                ID_PDG_MAX

C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)


C  external functions
      INTEGER IPHO_PDG2ID,IPHO_ID2PDG

      DOUBLE PRECISION PYMASS


C  local variables
      INTEGER I,IDPDG

      PHO_PMASS = 0.D0

      IF(MODE.EQ.0) THEN
        I = ID
      ELSE IF(MODE.EQ.1) THEN
        I = IPHO_PDG2ID(ID)
        IF(I.EQ.0) RETURN
      ELSE IF(MODE.EQ.2) THEN
        IF(ISTHEP(ID).GT.11) RETURN
        I     = IMPART(ID)
        IDPDG = IDHEP(ID)
        IF((IDPDG.EQ.90).OR.(IDPDG.EQ.91).OR.(IDPDG.EQ.92)) THEN
          PHO_PMASS = PHEP(5,ID)
          RETURN
        ENDIF
      ELSE IF(MODE.EQ.3) THEN
        I = ABS(ID)
        IF((I.GT.0).AND.(I.LE.6)) THEN
          PHO_PMASS = PARMDL(150+I)
          RETURN
        ELSE
          I = IPHO_PDG2ID(ID)
          IF(I.EQ.0) RETURN
        ENDIF
      ELSE IF(MODE.EQ.-1) THEN
C  take masses for quarks and di-quarks from JETSET
        DO I=1,22
          IDPDG = IPHO_ID2PDG(I)

          XM_LIST(I) = PYMASS(IDPDG)

        ENDDO
        RETURN
      ELSE
        WRITE(ErrorOut,'(1x,a,2i4)')
     &    'PHO_PMASS: INVALID ARGUMENTS (ID,MODE): ',ID,MODE
        RETURN
      ENDIF


      IF((I.EQ.0).OR.(IABS(I).GT.ID_PDG_MAX)) THEN
        WRITE(ErrorOut,'(1x,a,2i8)')
     &    'PHO_PMASS: INVALID ARGUMENTS (ID,MODE): ',ID,MODE
         PHO_PMASS = 1.D0/DBLE(I)
        RETURN
      ENDIF


      PHO_PMASS = XM_LIST(IABS(I))

      END



CDECK  ID>, PHO_MEMASS
      SUBROUTINE PHO_MEMASS(I,J,AMPS,AMPS2,AMVE,AMVE2,IPS,IVE)
C**********************************************************************
C
C     determine meson masses corresponding to the input flavours
C
C     input: I,J,K     quark flavours (PDG convention)
C
C     output: AMPS     pseudo scalar meson mass
C             AMPS2    next possible two particle configuration
C                      (two pseudo scalar  mesons)
C             AMVE     vector meson mass
C             AMVE2    next possible two particle configuration
C                      (two vector mesons)
C             IPS,IVE  meson numbers in CPC
C
C**********************************************************************

      IMPLICIT NONE

      SAVE

      INTEGER I,J,IPS,IVE
      DOUBLE PRECISION AMPS,AMPS2,AMVE,AMVE2

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  particle ID translation table
      INTEGER         ID_PDG_LIST,ID_LIST,ID_PDG_MAX
      CHARACTER*12    NAME_LIST
      COMMON /POPAR1/ ID_PDG_LIST(300),ID_LIST(577),NAME_LIST(300),
     &                ID_PDG_MAX

C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)


C  local variables
      INTEGER II,JJ


      IF(I.GT.0) THEN
        II = I
        JJ = -J
      ELSE
        II = J
        JJ = -I
      ENDIF

C  particle ID's
      IPS = ID_PSM_LIST(II,JJ)
      IVE = ID_VEM_LIST(II,JJ)
C  masses
      IF(IPS.NE.0) THEN
        AMPS = XM_LIST(IABS(IPS))
      ELSE
        AMPS = 0.D0
      ENDIF
      IF(IVE.NE.0) THEN
        AMVE = XM_LIST(IABS(IVE))
      ELSE
        AMVE = 0.D0
      ENDIF

C  next possible two-particle configurations (add phase space)
      AMPS2 = XM_PSM2_LIST(II,JJ)*1.5D0
      AMVE2 = XM_VEM2_LIST(II,JJ)*1.1D0

      END



CDECK  ID>, PHO_BAMASS
      SUBROUTINE PHO_BAMASS(I,J,K,AM8,AM82,AM10,AM102,I8,I10)
C**********************************************************************
C
C     determine baryon masses corresponding to the input flavours
C
C     input: I,J,K     quark flavours (PDG convention)
C
C     output: AM8      octett baryon mass
C             AM82     next possible two particle configuration
C                      (octett baryon and meson)
C             AM10     decuplett baryon mass
C             AM102    next possible two particle configuration
C                      (decuplett baryon and meson,
C                       baryon built up from first two quarks)
C             I8,I10   internal baryon numbers
C
C**********************************************************************

      IMPLICIT NONE

      SAVE

      INTEGER I,J,K,I8,I10
      DOUBLE PRECISION AM8,AM82,AM10,AM102

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  particle ID translation table
      INTEGER         ID_PDG_LIST,ID_LIST,ID_PDG_MAX
      CHARACTER*12    NAME_LIST
      COMMON /POPAR1/ ID_PDG_LIST(300),ID_LIST(577),NAME_LIST(300),
     &                ID_PDG_MAX

C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)


C  local variables
      INTEGER II,JJ,KK


C  find particle ID's
      II = IABS(I)
      JJ = IABS(J)
      KK = IABS(K)
      I8  = ID_B8_LIST(II,JJ,KK)
      I10 = ID_B10_LIST(II,JJ,KK)

C  masses (if combination possible)
      IF(I8.NE.0) THEN
        AM8 = XM_LIST(I8)
        I8  = SIGN(I8,I)
      ELSE
        AM8 = 0.D0
      ENDIF
      IF(I10.NE.0) THEN
        AM10 = XM_LIST(I10)
        I10  = SIGN(I10,I)
      ELSE
        AM10 = 0.D0
      ENDIF

C  next possible two-particle configurations (add phase space)
      AM82  = XM_B82_LIST(II,JJ,KK)*1.5D0
      AM102 = XM_B102_LIST(II,JJ,KK)*1.1D0

      END



CDECK  ID>, PHO_DQMASS
      SUBROUTINE PHO_DQMASS(I,J,K,L,AM82,AM102)
C**********************************************************************
C
C     determine minimal masses corresponding to the input flavours
C     (diquark a-diquark string system)
C
C     input: I,J,K,L   quark flavours (PDG convention)
C
C     output: AM82     mass of two octett baryons
C             AM102    mass of two decuplett baryons
C
C**********************************************************************

      IMPLICIT NONE

      SAVE

      INTEGER I,J,K,L
      DOUBLE PRECISION AM82,AM102

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)


C  local variables
      INTEGER II,JJ,KK,LL


      II = IABS(I)
      KK = IABS(K)
      JJ = IABS(J)
      LL = IABS(L)

      AM82  = XM_BB82_LIST(II,JJ,KK,LL)
      AM102 = XM_BB102_LIST(II,JJ,KK,LL)

      END



CDECK  ID>, PHO_CHECK
      SUBROUTINE PHO_CHECK(MD,IDEV)
C**********************************************************************
C
C     check quantum numbers of entries in /POEVT1/ and /POEVT2/
C           (energy, momentum, charge, baryon number conservation)
C
C     input:    MD      -1  check overall momentum conservation
C                           and perform detailed check only in case of
C                           deviations
C                        1  test all branchings, mother-daughter
C                           relations
C
C     output:   IDEV     0  no deviations
C                        1  deviations found
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  color string configurations including collapsed strings and hadrons
      INTEGER MSTR
      PARAMETER (MSTR=500)
      INTEGER NPOS,NCODE,IPAR1,IPAR2,IPAR3,IPAR4,NNCH,IBHAD
      COMMON /POSTRG/ NPOS(4,MSTR),NCODE(MSTR),
     &                IPAR1(MSTR),IPAR2(MSTR),IPAR3(MSTR),IPAR4(MSTR),
     &                NNCH(MSTR),IBHAD(MSTR),ISTR


C  count number of errors to avoid disk overflow
      DATA IERR / 0 /

      IDEV = 0
C  conservation check suppressed
      IF((IPAMDL(15).EQ.0).OR.(IDEB(20).LE.-10)) RETURN


      IF(IPAMDL(13).GT.0) THEN

C  DTUNUC call with x limitations
        MODE = -1
        ECM1 = SQRT(XPSUB*XTSUB)*ECM

      ELSE

C  standard call
        MODE = MD
C  first two entries are considered as scattering particles
        EE1 = PHEP(4,1) + PHEP(4,2)
        PX1 = PHEP(1,1) + PHEP(1,2)
        PY1 = PHEP(2,1) + PHEP(2,2)
        PZ1 = PHEP(3,1) + PHEP(3,2)

      ENDIF

      DDREL = PARMDL(75)
      DDABS = PARMDL(76)
      IF(MODE.EQ.-1) GOTO 500

 50   CONTINUE

      I = 1
 100  CONTINUE

C  recognize only decayed particles as mothers
        IF(ISTHEP(I).EQ.2) THEN
C  search for other mother particles
          K = JDAHEP(1,I)
          IF(K.EQ.0) THEN
            IF(IPAMDL(178).NE.0)
     &        WRITE(ErrorOut,'(1X,2A,I4)') 'PHO_CHECK: ',
     &        'ENTRY MARKED AS DECAYED BUT NO DAUTHER GIVEN:',I
            GOTO 99
          ENDIF
          K1 = JMOHEP(1,K)
          K2 = JMOHEP(2,K)
C  sum over mother particles
          ICH1 = IPHO_CHR3(K1,2)
          IBA1 = IPHO_BAR3(K1,2)
          EE1 = PHEP(4,K1)
          PX1 = PHEP(1,K1)
          PY1 = PHEP(2,K1)
          PZ1 = PHEP(3,K1)
          IF(K2.LT.0) THEN
            K2 = -K2
            IF((K1.GT.I).OR.(K2.LT.I)) THEN
              WRITE(ErrorOut,'(/,1X,2A,3I4)') 'PHO_CHECK: ',
     &          'INCONSISTENT MOTHER/DAUGHTER RELATION FOUND',I,K1,K2
              CALL PHO_PREVNT(-1)
            ENDIF
            DO 400 II=K1+1,K2
              IF(ABS(ISTHEP(II)).LE.2) THEN
                ICH1 = ICH1 + IPHO_CHR3(II,2)
                IBA1 = IBA1 + IPHO_BAR3(II,2)
                EE1 = EE1 + PHEP(4,II)
                PX1 = PX1 + PHEP(1,II)
                PY1 = PY1 + PHEP(2,II)
                PZ1 = PZ1 + PHEP(3,II)
              ENDIF
 400        CONTINUE
          ELSE IF((K2.GT.0).AND.(K2.NE.K1)) THEN
            ICH1 = ICH1 + IPHO_CHR3(K2,2)
            IBA1 = IBA1 + IPHO_BAR3(K2,2)
            EE1 = EE1 + PHEP(4,K2)
            PX1 = PX1 + PHEP(1,K2)
            PY1 = PY1 + PHEP(2,K2)
            PZ1 = PZ1 + PHEP(3,K2)
          ENDIF

C  sum over daughter particles
          ICH2 = 0.D0
          IBA2 = 0.D0
          EE2 = 0.D0
          PX2 = 0.D0
          PY2 = 0.D0
          PZ2 = 0.D0
          DO 200 II=JDAHEP(1,I),JDAHEP(2,I)
            IF(ABS(ISTHEP(II)).LE.2) THEN
              ICH2 = ICH2 + IPHO_CHR3(II,2)
              IBA2 = IBA2 + IPHO_BAR3(II,2)
              EE2 = EE2 + PHEP(4,II)
              PX2 = PX2 + PHEP(1,II)
              PY2 = PY2 + PHEP(2,II)
              PZ2 = PZ2 + PHEP(3,II)
            ENDIF
 200      CONTINUE

C  conservation check
          ESC = MAX(MAX(EE1,EE2)*DDREL,DDABS)
          IF(ABS(EE1-EE2).GT.ESC) THEN
            WRITE(ErrorOut,'(1X,A,/,5X,A,I3,2X,1P,2E10.3)')
     &        'PHO_CHECK: ENERGY CONSERVATION VIOLATED FOR',
     &        'ENTRY,INITIAL,FINAL:',I,EE1,EE2
            IDEV = 1
          ENDIF
          ESC = MAX(MAX(ABS(PX1),ABS(PX2))*DDREL,DDABS)
          IF(ABS(PX1-PX2).GT.ESC) THEN
            WRITE(ErrorOut,'(1X,A,/,5X,A,I3,2X,1P,2E12.3)')
     &        'PHO_CHECK: X-MOMENTUM CONSERVATION VIOLATED FOR',
     &        'ENTRY,INITIAL,FINAL:',I,PX1,PX2
            IDEV = 1
          ENDIF
          ESC = MAX(MAX(ABS(PY1),ABS(PY2))*DDREL,DDABS)
          IF(ABS(PY1-PY2).GT.ESC) THEN
            WRITE(ErrorOut,'(1X,A,/,5X,A,I3,2X,1P,2E12.3)')
     &        'PHO_CHECK: Y-MOMENTUM CONSERVATION VIOLATED FOR',
     &        'ENTRY,INITIAL,FINAL:',I,PY1,PY2
            IDEV = 1
          ENDIF
          ESC = MAX(MAX(ABS(PZ1),ABS(PZ2))*DDREL,DDABS)
          IF(ABS(PZ1-PZ2).GT.ESC) THEN
            WRITE(ErrorOut,'(1X,A,/,5X,A,I3,2X,1P,2E12.3)')
     &        'PHO_CHECK: Z-MOMENTUM CONSERVATION VIOLATED FOR',
     &        'ENTRY,INITIAL,FINAL:',I,PZ1,PZ2
            IDEV = 1
          ENDIF
          IF(ICH1.NE.ICH2) THEN
            WRITE(ErrorOut,'(1X,A,/,5X,A,I3,2X,2I5)')
     &        'PHO_CHECK: CHARGE CONSERVATION VIOLATED FOR',
     &        'ENTRY,INITIAL,FINAL:',I,ICH1,ICH2
            IDEV = 1
          ENDIF
          IF(IBA1.NE.IBA2) THEN
            WRITE(ErrorOut,
     * '(1X,2A,/,5X,A,I3,2X,2I5)') 'PHO_CHECK: ',
     &        'BARYON CHARGE CONSERVATION VIOLATED FOR',
     &        'ENTRY,INITIAL,FINAL:',I,IBA1,IBA2
            IDEV = 1
          ENDIF
          IF(IDEB(20).GE.35) THEN
            WRITE(ErrorOut,
     &        '(/,1X,A,A,2(2X,I4,A,I4),2(/,5X,A,4E13.4),/5X,A,4I5)')
     &      'PHO_CHECK DIAGNOSTICS:',
     &      '(1.MOTHER/L.MOTHER,1.DAUGHTER/L.DAUGHTER):',
     &      K1,'/',K2,JDAHEP(1,I),'/',JDAHEP(2,I),
     &      'MOTHER MOMENTA   ',PX1,PY1,PZ1,EE1,
     &      'DAUGHTER MOMENTA ',PX2,PY2,PZ2,EE2,
     &      'CHARGE,BARYON NO ',ICH1,ICH2,IBA1,IBA2
          ENDIF
        ENDIF
 99     CONTINUE
        I = I+1
      IF(I.LE.NHEP) GOTO 100

 55   CONTINUE

      IERR = IERR+IDEV

C  write complete event in case of deviations
      IF((IDEB(20).GE.0).AND.(IDEV.NE.0)) THEN
        CALL PHO_PREVNT(1)
        IF(ISTR.GT.0) THEN
          CALL PHO_PRSTRG

          IF(ISWMDL(6).GE.0) CALL PYLIST(1)

        ENDIF
      ENDIF

C  stop after too many errors
      IF(IERR.GT.IPAMDL(179)) THEN
        WRITE(ErrorOut,
     * '(////1X,2A,I6,////)') 'PHO_CHECK:ERROR:',
     &    'TOO MANY INCONSISTENCIES FOUND, PROGRAM TERMINATED',IERR
        CALL PHO_ABORT
      ENDIF

      RETURN

C  overall check only (less time consuming)

 500  CONTINUE

      ICH2 = 0.D0
      IBA2 = 0.D0
      EE2 = 0.D0
      PX2 = 0.D0
      PY2 = 0.D0
      PZ2 = 0.D0

      DO 300 K=3,NHEP
C  recognize only existing particles as possible daughters
        IF(ABS(ISTHEP(K)).EQ.1) THEN
          ICH2 = ICH2 + IPHO_CHR3(K,2)
          IBA2 = IBA2 + IPHO_BAR3(K,2)
          EE2 = EE2 + PHEP(4,K)
          PX2 = PX2 + PHEP(1,K)
          PY2 = PY2 + PHEP(2,K)
          PZ2 = PZ2 + PHEP(3,K)
        ENDIF
 300  CONTINUE

C  check energy-momentum conservation
      ESC = ECM*DDREL

      IF(IPAMDL(13).GT.0) THEN

C  DTUNUC call with x limitations
        ECM2 = SQRT((EE2-PZ2)*(EE2+PZ2)-PX2**2-PY2**2)
        IF(ABS(ECM1-ECM2).GT.ESC) THEN
          WRITE(ErrorOut,'(1X,A,/,5X,A,1P,2E12.4)')
     &      'PHO_CHECK: C.M. ENERGY CONSERVATION VIOLATED',
     &      'INITIAL/FINAL ENERGY:',ECM1,ECM2
          IDEV = 1
        ENDIF

      ELSE

C  standard call
        IF(ABS(EE1-EE2).GT.ESC) THEN
          WRITE(ErrorOut,'(1X,A,/,5X,A,1P,2E12.4)')
     &      'PHO_CHECK: ENERGY CONSERVATION VIOLATED',
     &      'INITIAL/FINAL ENERGY:',EE1,EE2
          IDEV = 1
        ENDIF
        IF(ABS(PX1-PX2).GT.ESC) THEN
        WRITE(ErrorOut,'(1X,A,/,5X,A,1P,2E12.4)')
     &      'PHO_CHECK: X-MOMENTUM CONSERVATION VIOLATED',
     &      'INITIAL/FINAL X-MOMENTUM:',PX1,PX2
          IDEV = 1
        ENDIF
        IF(ABS(PY1-PY2).GT.ESC) THEN
          WRITE(ErrorOut,'(1X,A,/,5X,A,1P,2E12.4)')
     &      'PHO_CHECK: Y-MOMENTUM CONSERVATION VIOLATED',
     &      'INITIAL/FINAL Y-MOMENTUM:',PY1,PY2
          IDEV = 1
        ENDIF
        IF(ABS(PZ1-PZ2).GT.ESC) THEN
          WRITE(ErrorOut,'(1X,A,/,5X,A,1P,2E12.4)')
     &      'PHO_CHECK: Z-MOMENTUM CONSERVATION VIOLATED',
     &      'INITIAL/FINAL Z-MOMENTUM:',PZ1,PZ2
          IDEV = 1
        ENDIF

C  check of quantum number conservation

        ICH1 = IPHO_CHR3(1,2) + IPHO_CHR3(2,2)
        IBA1 = IPHO_BAR3(1,2) + IPHO_BAR3(2,2)

        IF(ICH1.NE.ICH2) THEN
          WRITE(ErrorOut,'(1X,A,/,5X,A,2I5)')
     &      'PHO_CHECK: CHARGE CONSERVATION VIOLATED',
     &      'INITIAL/FINAL CHARGE SUM',ICH1,ICH2
          IDEV = 1
        ENDIF
        IF(IBA1.NE.IBA2) THEN
          WRITE(ErrorOut,'(1X,2A,/,5X,A,2I5)') 'PHO_CHECK: ',
     &      'BARYONIC CHARGE CONSERVATION VIOLATED',
     &      'INITIAL/FINAL BARYONIC CHARGE SUM',IBA1,IBA2
          IDEV = 1
        ENDIF

      ENDIF

C  perform detailed checks in case of deviations
      IF((IDEB(20).GE.0).AND.(IDEV.NE.0)) THEN
        IF(IPAMDL(13).GT.0) THEN
          GOTO 55
        ELSE
          DDREL = DDREL/2.D0
          DDABS = DDABS/2.D0
          WRITE(ErrorOut,'(/1X,2A,2E12.4)') 'PHO_CHECK: ',
     &      'INCREASING PRECISION OF TESTS TO',DDREL,DDABS
          GOTO 50
        ENDIF
      ENDIF

      END


CDECK  ID>, PHO_ABORT
      SUBROUTINE PHO_ABORT
C**********************************************************************
C
C     top MC event generation due to fatal error,
C     print all information of event generation and history
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  color string configurations including collapsed strings and hadrons
      INTEGER MSTR
      PARAMETER (MSTR=500)
      INTEGER NPOS,NCODE,IPAR1,IPAR2,IPAR3,IPAR4,NNCH,IBHAD
      COMMON /POSTRG/ NPOS(4,MSTR),NCODE(MSTR),
     &                IPAR1(MSTR),IPAR2(MSTR),IPAR3(MSTR),IPAR4(MSTR),
     &                NNCH(MSTR),IBHAD(MSTR),ISTR

C  light-cone x fractions and c.m. momenta of soft cut string ends
      INTEGER MAXSOF
      PARAMETER ( MAXSOF = 50 )
      INTEGER IJSI2,IJSI1
      DOUBLE PRECISION XS1,XS2,PSOFT1,PSOFT2
      COMMON /POSOFT/ XS1(MAXSOF),XS2(MAXSOF),
     &                PSOFT1(4,MAXSOF),PSOFT2(4,MAXSOF),
     &                IJSI1(MAXSOF),IJSI2(MAXSOF)

C  hard scattering data
      INTEGER MSCAHD
      PARAMETER ( MSCAHD = 50 )
      INTEGER LSCAHD,LSC1HD,LSIDX,
     &        NINHD,N0INHD,NIVAL,N0IVAL,NOUTHD,NBRAHD,NPROHD
      DOUBLE PRECISION PPH,PTHD,ETAHD,Q2SCA,PDFVA,XHD,VHD,X0HD
      COMMON /POHSLT/ LSCAHD,LSC1HD,LSIDX(MSCAHD),
     &                PPH(8*MSCAHD,2),PTHD(MSCAHD),ETAHD(MSCAHD,2),
     &                Q2SCA(MSCAHD,2),PDFVA(MSCAHD,2),
     &                XHD(MSCAHD,2),VHD(MSCAHD),X0HD(MSCAHD,2),
     &                NINHD(MSCAHD,2),N0INHD(MSCAHD,2),
     &                NIVAL(MSCAHD,2),N0IVAL(MSCAHD,2),
     &                NOUTHD(MSCAHD,2),NBRAHD(MSCAHD,2),NPROHD(MSCAHD)

      WRITE(ErrorOut,'(//,1X,A,/,1X,A)')
     &  'PHO_ABORT: PROGRAM EXECUTION STOPPED',
     &  '===================================='
      WRITE(ErrorOut,
     * '(/,1X,A,/,1X,A)') 'listing of available data follows:'
C
      CALL PHO_SETMDL(0,0,-2)
      CALL PHO_PREVNT(-1)
      CALL PHO_ACTPDF(0,-2)
C  print selected parton flavours
      WRITE(ErrorOut,
     * '(1X,A,I4)') 'selected soft flavours: ',KSOFT
      DO 700 I=1,KSOFT
        WRITE(ErrorOut,'(10X,2I5)') IJSI1(I),IJSI2(I)
 700  CONTINUE
      WRITE(ErrorOut,
     * '(1X,A,I4)') 'selected hard flavours: ',KHARD
      DO 750 K=1,KHARD
        I = LSIDX(K)
        WRITE(ErrorOut,'(10X,A,I5)') 'process:',NPROHD(I)
        WRITE(ErrorOut,
     * '(10X,A,2I4,7X,A,2I4)') 'initial:',NINHD(I,1),
     &    NINHD(I,2),'FINAL:',NOUTHD(I,1),NOUTHD(I,2)
 750  CONTINUE
C  print selected parton momenta
      WRITE(ErrorOut,
     * '(1X,A,I4)') 'selected soft momenta: ',KSOFT
      DO 300 I=1,KSOFT
        WRITE(ErrorOut,
     * '(10X,A,4E12.3)') 'par.1',(PSOFT1(II,I),II=1,4)
        WRITE(ErrorOut,
     * '(10X,A,4E12.3)') 'par.2',(PSOFT2(II,I),II=1,4)
 300  CONTINUE
      WRITE(ErrorOut,
     * '(1X,A,I4)') 'selected hard momenta: ',KHARD
      DO 350 K=1,KHARD
        I = LSIDX(K)
        I3 = 8*I-4
        WRITE(ErrorOut,
     * '(10X,A,4E12.3)') 'par.1',(PPH(I3+II,1),II=1,4)
        WRITE(ErrorOut,
     * '(10X,A,4E12.3)') 'par.2',(PPH(I3+II,2),II=1,4)
 350  CONTINUE

C  print /POEVT1/
      CALL PHO_PREVNT(0)

C  fragmentation process
      IF(ISTR.GT.0) THEN
C  print /POSTRG/
        CALL PHO_PRSTRG

        IF(ISWMDL(6).GE.0) CALL PYLIST(1)

      ENDIF

C  last message
c/////////////
      call cpdpmjetinp    ! print input ptcl
c////////////

      WRITE(ErrorOut,'(////5X,A,///5X,A,///)')
     &  'PHO_ABORT: EXECUTION TERMINATED DUE TO FATAL ERROR',
     &'*** SIMULATING DIVISION BY ZERO TO GET TRACEBACK INFORMATION ***'
      ISTR = 100/IPAMDL(100)

      END


CDECK  ID>, PHO_TRACE
      SUBROUTINE PHO_TRACE(ISTART,ISWI,LEVEL)
C**********************************************************************
C
C     trace program subroutines according to level,
C                          original output levels will be saved
C
C     input:   ISTART      first event to trace
C              ISWI        number of events to trace
C                                0   loop call, use old values
C                               -1   restore original output levels
C                                1   store level and wait for event
C              LEVEL       desired output level
C                                0   standard output
C                                3   internal rejections
C                                5   cross sections, slopes etc.
C                               10   parameter of subroutines and
C                                    results
C                               20   huge amount of debug output
C                               30   maximal possible output
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD


      DIMENSION IMEM(NMAXD)

C  protect ISWI
      ISW = ISWI
 10   CONTINUE
      IF(ISW.EQ.0) THEN
        IF(KEVENT.LT.ION) THEN
          RETURN
        ELSE IF(KEVENT.EQ.ION) THEN
          WRITE(ErrorOut,'(///,1X,A,///)')
     &      'PHO_TRACE: TRACE MODE SWITCHED ON'
          DO 100 I=1,NMAXD
            IMEM(I) = IDEB(I)
            IDEB(I) = MAX(ILEVEL,IMEM(I))
 100      CONTINUE
        ELSE IF(KEVENT.EQ.IOFF) THEN
          WRITE(ErrorOut,'(//,1X,A,///)')
     &      'PHO_TRACE: TRACE MODE SWITCHED OFF'
          DO 200 I=1,NMAXD
            IDEB(I) = IMEM(I)
 200      CONTINUE
        ENDIF
      ELSE IF(ISW.EQ.-1) THEN
        DO 300 I=1,NMAXD
          IDEB(I) = IMEM(I)
 300    CONTINUE
      ELSE
C  save information
        ION = ISTART
        IOFF = ISTART+ISW
        ILEVEL = LEVEL
      ENDIF
C  check coincidence
      IF(ISW.GT.0) THEN
        ISW=0
        ILEVEL = LEVEL
        GOTO 10
      ENDIF

      END


CDECK  ID>, PHO_PRSTRG
      SUBROUTINE PHO_PRSTRG
C**********************************************************************
C
C     print information of /POSTRG/
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  color string configurations including collapsed strings and hadrons
      INTEGER MSTR
      PARAMETER (MSTR=500)
      INTEGER NPOS,NCODE,IPAR1,IPAR2,IPAR3,IPAR4,NNCH,IBHAD
      COMMON /POSTRG/ NPOS(4,MSTR),NCODE(MSTR),
     &                IPAR1(MSTR),IPAR2(MSTR),IPAR3(MSTR),IPAR4(MSTR),
     &                NNCH(MSTR),IBHAD(MSTR),ISTR


      WRITE(ErrorOut,
     * '(/,1X,A,I5)') 'PHO_PRSTRG: number of strings soft+hard:',
     &  ISTR
      WRITE(ErrorOut,'(/,1X,A/,1X,A)') 'COMMON /POSTRG/:',
     &  ' NOBAM  ID1  ID2  ID3  ID4     NPO1/2/3/4        MASS'
      WRITE(ErrorOut,'(1X,A)')
     &  ' ======================================================='
      DO 800 I=1,ISTR
        WRITE(ErrorOut,'(1X,9I5,1P,E11.3)')
     &         NCODE(I),IPAR1(I),IPAR2(I),IPAR3(I),IPAR4(I),NPOS(1,I),
     &         NPOS(2,I),NPOS(3,I),NPOS(4,I),PHEP(5,NPOS(1,I))
 800  CONTINUE

      END



CDECK  ID>, PHO_PREVNT
      SUBROUTINE PHO_PREVNT(NPART)
C**********************************************************************
C
C     print all information of event generation and history
C
C     input:        NPART  -1   minimal output: process IDs
C                           0   additional output of /POEVT1/
C                           1   additional output of /POSTRG/
C                           2   additional output of /HEPEVT/
C                               (call LULIST(1))
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)


      CHARACTER*15 PHO_PNAME

      IF(NPART.GE.0) WRITE(ErrorOut,'(/)')
      WRITE(ErrorOut,'(1X,A,1PE10.3)')
     &  'PHO_PREVNT: C.M. ENERGY',ECM
      CALL PHO_SETPAR(-2,IH,NPART,0.D0)
      WRITE(ErrorOut,'(6X,A,A,/1X,I10,10I6)')
     &  'EV-CALL,ISPOM,IHPOM,ISREG,IHDIR,KSTRG,',
     &  'KHTRG,KSLOO,KHLOO,KSDPO,KHDPO',
     &  KEVENT,KSPOM,KHPOM,KSREG,KHDIR,KSTRG,KHTRG,KSLOO,KHLOO,KSDPO,
     &  KHDPO
      WRITE(ErrorOut,'(6X,A,I4,4I3)')
     &  'PROCESS-ID,IDNODF,IDIFF1,IDIFF2,IDDPOM',IPROCE,IDNODF,IDIFR1,
     &  IDIFR2,IDDPOM

      IF(IPAMDL(13).GT.0) THEN
        WRITE(ErrorOut,
     * '(1X,A)') 'PHO_PREVNT: DTUNUC special settings:'
        WRITE(ErrorOut,
     * '(5X,A,1P,4E11.3)') 'ECMN,PCMN,SECM,SPCM',
     &    ECMN,PCMN,SECM,SPCM
        WRITE(ErrorOut,
     * '(5X,A,1P,2E11.3)') 'XPSUB,XTSUB',XPSUB,XTSUB
      ENDIF

      IF(NPART.LT.0) RETURN

      IF(NPART.GE.1) CALL PHO_PRSTRG

      WRITE(ErrorOut,'(/1X,A)') 'COMMON /POEVT1/:'
      ICHAS  = 0
      IBARFS = 0
      IMULC  = 0
      IMUL   = 0
      WRITE(ErrorOut,'(/1X,A,A,/,1X,A,A)')
     &  '   NO  IST    NAME         MO-1 MO-2 DA-1 DA-2  CHA  BAR',
     &  '  IH1  IH2  CO1  CO2',
     &  '========================================================',
     &  '===================='
      DO 20 IH=1,NHEP
        CH = DBLE(IPHO_CHR3(IH,2)/3.D0)
        BA = DBLE(IPHO_BAR3(IH,2)/3.D0)
        WRITE(ErrorOut,'(1X,2I5,1X,A15,4I5,2F5.1,2I5,2I5)')
     &    IH,ISTHEP(IH),PHO_PNAME(IH,2),
     &    JMOHEP(1,IH),JMOHEP(2,IH),JDAHEP(1,IH),JDAHEP(2,IH),
     &    CH,BA,IPHIST(1,IH),IPHIST(2,IH),
     &    ICOLOR(1,IH),ICOLOR(2,IH)
        IF(ABS(ISTHEP(IH)).EQ.1) THEN
          ICHAS  = ICHAS  + IPHO_CHR3(IH,2)
          IBARFS = IBARFS + IPHO_BAR3(IH,2)
        ENDIF
        IF(ABS(ISTHEP(IH)).EQ.1) THEN
          IF(IPHO_CHR3(IH,2).NE.0) IMULC = IMULC+1
          IMUL = IMUL+1
        ENDIF
   20 CONTINUE
      WRITE(ErrorOut,
     * '(1X,2(3X,A,I3),2X,2(5X,A,I5))') 'sum charge:',ICHAS/3,
     &  'BARYON:',IBARFS/3,'CHR.MULT:',IMULC,'TOT.MULT:',IMUL

      WRITE(ErrorOut,7)
      PXS    = 0.D0
      PYS    = 0.D0
      PZS    = 0.D0
      P0S    = 0.D0
      DO 30 IN=1,NHEP
        IF(     (ABS(PHEP(3,IN)).LT.99999.D0)
     &     .AND.(PHEP(4,IN).LT.99999.D0)) THEN
          WRITE(ErrorOut,8) IN,ISTHEP(IN),PHO_PNAME(IN,2),
     &      (PHEP(J,IN),J=1,5),SQRT(PHEP(1,IN)**2+PHEP(2,IN)**2)
        ELSE
          WRITE(ErrorOut,11) IN,ISTHEP(IN),PHO_PNAME(IN,2),
     &      (PHEP(J,IN),J=1,5),SQRT(PHEP(1,IN)**2+PHEP(2,IN)**2)
        ENDIF
        IF(ABS(ISTHEP(IN)).EQ.1) THEN
          PXS = PXS + PHEP(1,IN)
          PYS = PYS + PHEP(2,IN)
          PZS = PZS + PHEP(3,IN)
          P0S = P0S + PHEP(4,IN)
        ENDIF
   30 CONTINUE
      AMFS = P0S**2-PXS**2-PYS**2-PZS**2
      AMFS = SIGN(SQRT(ABS(AMFS)),AMFS)
      IF(P0S.LT.99999.D0) THEN
        WRITE(ErrorOut,10) '      sum:    ',PXS,PYS,PZS,P0S,AMFS
      ELSE
        WRITE(ErrorOut,12) '      sum:    ',PXS,PYS,PZS,P0S,AMFS
      ENDIF
      WRITE(ErrorOut,'(//)')

    5 FORMAT(2X,8H NUMBER ,8H STATUS ,8H IDENT. ,
     &  8H 1.MOTH.,8H 2.MOTH.,8H 1.DAUG.,8H L.DAUG.,
     &  8H CHARGE ,8H BARYON ,/)
    6 FORMAT(7I8,2F8.3)
    7 FORMAT(/,2X,' NR STAT NAME        X-MOMENTA',
     &  ' Y-MOMENTA Z-MOMENTA  ENERGY    MASS     PT',/,
     &         2X,'-------------------------------',
     &  '--------------------------------------------')
    8 FORMAT(I5,I4,1X,A15,2F8.3,3F10.3,F8.3)
    9 FORMAT(I10,14X,5F10.3)
   10 FORMAT(10X,A14,1X,2F8.3,3F10.3)
   11 FORMAT(I5,I4,1X,A15,2F8.2,2F10.1,F10.3,F8.3)
   12 FORMAT(10X,A14,1X,2F8.2,2F10.1,F10.3)


      IF(NPART.GE.2) CALL PYLIST(1)


      END


CDECK  ID>, PHO_LTRHEP
      SUBROUTINE PHO_LTRHEP(I1,I2,COD,SID,COF,SIF,GAM,BGX,BGY,BGZ)
C*******************************************************************
C
C     Lorentz transformation of entries I1 to I2 in /POEVT1/
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DIFF = 0.001D0,
     &            EPS  = 1.D-5 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)



      DO 100 I=I1,MIN(I2,NHEP)
        IF((ABS(ISTHEP(I)).LE.10).OR.(ISTHEP(I).EQ.21)) THEN
          CALL PHO_TRANS(PHEP(1,I),PHEP(2,I),PHEP(3,I),COD,SID,COF,SIF,
     &      XX,YY,ZZ)
          EE=PHEP(4,I)
          CALL PHO_ALTRA(GAM,BGX,BGY,BGZ,XX,YY,ZZ,EE,PTOT,
     &      PHEP(1,I),PHEP(2,I),PHEP(3,I),PHEP(4,I))
        ELSE IF(ISTHEP(I).EQ.20) THEN
          EE=SQRT(PHEP(1,I)**2+PHEP(2,I)**2+PHEP(3,I)**2)
          CALL PHO_TRANS(PHEP(1,I),PHEP(2,I),PHEP(3,I),COD,SID,COF,SIF,
     &      XX,YY,ZZ)
          CALL PHO_ALTRA(GAM,BGX,BGY,BGZ,XX,YY,ZZ,EE,PTOT,
     &      PHEP(1,I),PHEP(2,I),PHEP(3,I),PMASS)
        ENDIF
 100  CONTINUE

C  debug precision
      IF(IDEB(70).LT.1) RETURN
      DO 200 I=I1,MIN(NHEP,I2)
        IF(ABS(ISTHEP(I)).GT.10) GOTO 190
        PMASS = PHEP(4,I)**2-PHEP(1,I)**2-PHEP(2,I)**2-PHEP(3,I)**2
        PMASS = SIGN(SQRT(ABS(PMASS)),PMASS)
        IF((ABS(PMASS-PHEP(5,I))/MAX(PHEP(5,I),1.D0)).GT.DIFF) THEN
          WRITE(ErrorOut,'(1X,A,I5,2E13.4)')
     &      'PHO_LTRHEP: INCONSISTENT MASSES:',I,PMASS,PHEP(5,I)
        ENDIF
 190    CONTINUE
 200  CONTINUE

      END


CDECK  ID>, PHO_PECMS
      SUBROUTINE PHO_PECMS(ID,PMASS1,PMASS2,ECM,PP,EE)
C*******************************************************************
C
C     calculation of cms momentum and energy of massive particle
C     (ID=  1 using PMASS1,  2 using PMASS2)
C
C     output:  PP    cms momentum
C              EE    energy in CMS of particle ID
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


      S=ECM**2
      PM1 = SIGN(PMASS1**2,PMASS1)
      PM2 = SIGN(PMASS2**2,PMASS2)
      PP = SQRT(S**2 - 2.D0*PM1*S - 2.D0*PM2*S - 2.D0*PM1*PM2
     &          + PM1**2 + PM2**2)/(2.D0*ECM)

      IF(ID.EQ.1) THEN
        EE = SQRT( PM1 + PP**2 )
      ELSE IF(ID.EQ.2) THEN
        EE = SQRT( PM2 + PP**2 )
      ELSE
        WRITE(ErrorOut,
     * '(/1X,A,I3,/)') 'PHO_PECMS:ERROR: invalid ID number:',ID
        EE = PP
      ENDIF

      END


CDECK  ID>, PHO_FRAINI
      SUBROUTINE PHO_FRAINI(IDEFAU)
C***********************************************************************
C
C     initialization of fragmentation packages
C      (currently LUND JETSET)
C
C     initialization for JETSET call in DTUNUC 1.04 (J.R. 6/93)
C                      changed to work in PHOJET   (R.E. 1/94)
C
C     input:  IDEFAU    0  no hadronization at all
C                       1  do not touch any parameter of JETSET
C                       2  default parameters kept, decay length 10mm to
C                          define stable particles
C                       3  load tuned parameters for JETSET 7.3
C             neg. value:  prevent strange/charm hadrons from decaying
C
C     ATTENTION: single precision interface to JETSET
C                may be JETSET version dependent
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER (EPS=1.D-10)


      INTEGER N,NPAD,K
      DOUBLE PRECISION P,V
      COMMON/PYJETS/N,NPAD,K(4000,5),P(4000,5),V(4000,5)



      INTEGER MSTU,MSTJ
      DOUBLE PRECISION PARU,PARJ
      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)



      INTEGER KCHG
      DOUBLE PRECISION  PMAS,PARF,VCKM
      COMMON/PYDAT2/KCHG(500,4),PMAS(500,4),PARF(2000),VCKM(4,4)



      INTEGER MDCY,MDME,KFDP
      DOUBLE PRECISION  BRAT
      COMMON/PYDAT3/MDCY(500,3),MDME(4000,2),BRAT(4000),KFDP(4000,5)




      INTEGER PYCOMP


      IDEFAB = ABS(IDEFAU)

      IF(IDEFAB.EQ.0) THEN
        WRITE(ErrorOut,
     * '(/1X,A)') 'PHO_FRAINI: hadronization switched off'
        RETURN
      ENDIF
C  defaults
      DEF2  = PARJ(2)
      IDEF12 = MSTJ(12)
      DEF19 = PARJ(19)
      DEF41 = PARJ(41)
      DEF42 = PARJ(42)
      DEF21 = PARJ(21)

C  declare stable particles
      IF(IDEFAB.GE.2) MSTJ(22) = 2

C  load optimized parameters
      IF(IDEFAB.GE.3) THEN

*       PARJ(19)=0.19
C  Lund a-parameter
C  (default=0.3)
        PARJ(41)=0.3
C  Lund b-parameter
C  (default=1.0)
        PARJ(42)=1.0
C  Lund sigma parameter in pt distribution
C  (default=0.36)
        PARJ(21)=0.36
      ENDIF
C
C  prevent particles decaying
      IF(IDEFAU.LT.0) THEN
C                 K0S

        KC=PYCOMP(310)

        MDCY(KC,1)=0
C                 PI0

        KC=PYCOMP(111)

        MDCY(KC,1)=0
C                 LAMBDA

        KC=PYCOMP(3122)

        MDCY(KC,1)=0
C                 ALAMBDA

        KC=PYCOMP(-3122)

        MDCY(KC,1)=0
C                 SIG+

        KC=PYCOMP(3222)

        MDCY(KC,1)=0
C                 ASIG+

        KC=PYCOMP(-3222)

        MDCY(KC,1)=0
C                 SIG-

        KC=PYCOMP(3112)

        MDCY(KC,1)=0
C                 ASIG-

        KC=PYCOMP(-3112)

        MDCY(KC,1)=0
C                 SIG0

        KC=PYCOMP(3212)

        MDCY(KC,1)=0
C                 ASIG0

        KC=PYCOMP(-3212)

        MDCY(KC,1)=0
C                 TET0

        KC=PYCOMP(3322)

        MDCY(KC,1)=0
C                 ATET0

        KC=PYCOMP(-3322)

        MDCY(KC,1)=0
C                 TET-

        KC=PYCOMP(3312)

        MDCY(KC,1)=0
C                 ATET-

        KC=PYCOMP(-3312)

        MDCY(KC,1)=0
C                 OMEGA-

        KC=PYCOMP(3334)

        MDCY(KC,1)=0
C                 AOMEGA-

        KC=PYCOMP(-3334)

        MDCY(KC,1)=0
C                 D+

        KC=PYCOMP(411)

        MDCY(KC,1)=0
C                 D-

        KC=PYCOMP(-411)

        MDCY(KC,1)=0
C                 D0

        KC=PYCOMP(421)

        MDCY(KC,1)=0
C                 A-D0

        KC=PYCOMP(-421)

        MDCY(KC,1)=0
C                 DS+

        KC=PYCOMP(431)

        MDCY(KC,1)=0
C                 A-DS+

        KC=PYCOMP(-431)

        MDCY(KC,1)=0
C                ETAC

        KC=PYCOMP(441)

        MDCY(KC,1)=0
C                LAMBDAC+

        KC=PYCOMP(4122)

        MDCY(KC,1)=0
C                A-LAMBDAC+

        KC=PYCOMP(-4122)

        MDCY(KC,1)=0
C                SIGMAC++

        KC=PYCOMP(4222)

        MDCY(KC,1)=0
C                SIGMAC+

        KC=PYCOMP(4212)

        MDCY(KC,1)=0
C                SIGMAC0

        KC=PYCOMP(4112)

        MDCY(KC,1)=0
C                A-SIGMAC++

        KC=PYCOMP(-4222)

        MDCY(KC,1)=0
C                A-SIGMAC+

        KC=PYCOMP(-4212)

        MDCY(KC,1)=0
C                A-SIGMAC0

        KC=PYCOMP(-4112)

        MDCY(KC,1)=0
C                KSIC+

        KC=PYCOMP(4232)

        MDCY(KC,1)=0
C                KSIC0

        KC=PYCOMP(4132)

        MDCY(KC,1)=0
C                A-KSIC+

        KC=PYCOMP(-4232)

        MDCY(KC,1)=0
C                A-KSIC0

        KC=PYCOMP(-4132)

        MDCY(KC,1)=0
      ENDIF

      WRITE(ErrorOut,2355) IDEFAU,DEF2,PARJ(2),IDEF12,MSTJ(12),
     &  DEF19,PARJ(19),DEF41,PARJ(41),DEF42,PARJ(42),DEF21,PARJ(21)
 2355 FORMAT(/' PHO_FRAINI: FRAGMENTATION INITIALIZATION ISWMDL(6)',I3/,
     &        ' --------------------------------------------------',/,
     & 5X,'PARAMETER DESCRIPTION               DEFAULT / CURRENT',/,
     & 5X,'PARJ( 2) STRANGENESS SUPPRESSION : ',2F7.3,/,
     & 5X,'MSTJ(12) POPCORN                 : ',2I7,/,
     & 5X,'PARJ(19) POPCORN                 : ',2F7.3,/,
     & 5X,'PARJ(41) LUND A                  : ',2F7.3,/,
     & 5X,'PARJ(42) LUND B                  : ',2F7.3,/,
     & 5X,'PARJ(21) SIGMA IN PT DISTRIBUTION: ',2F7.3,/)

      END


CDECK  ID>, PHO_SETPAR
      SUBROUTINE PHO_SETPAR(ISIDE,IDPDG,IDCPC,PVIR)
C**********************************************************************
C
C     assign a particle to either side 1 or 2
C     (including special treatment for remnants)
C
C     input:    Iside      1,2  side selected for the particle
C                          -2   output of current settings
C               IDpdg      PDG number
C               IDcpc      CPC number
C                          0     CPC determination in subroutine
C                          -1    special particle remnant, IDPDG
C                                is the particle number the remnant
C                                corresponds to (see /POHDFL/)
C
C**********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      INTEGER ISIDE,IDPDG,IDCPC
      DOUBLE PRECISION PVIR

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  particle ID translation table
      INTEGER         ID_PDG_LIST,ID_LIST,ID_PDG_MAX
      CHARACTER*12    NAME_LIST
      COMMON /POPAR1/ ID_PDG_LIST(300),ID_LIST(577),NAME_LIST(300),
     &                ID_PDG_MAX

C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)

C  particle decay data
      DOUBLE PRECISION WG_SEC_LIST
      INTEGER          IDEC_LIST,ISEC_LIST
      COMMON /POPAR3/ WG_SEC_LIST(500),IDEC_LIST(3,300),
     &  ISEC_LIST(3,500)


C  external functions
      INTEGER IPHO_PDG2ID,IPHO_CHR3,IPHO_BAR3
      DOUBLE PRECISION PHO_PMASS

C  local variables
      INTEGER I,IDCPCN,IDCPCR,IDPDGN,IDPDGR,IDB,IFL1,IFL2,IFL3


      IF((ISIDE.EQ.1).OR.(ISIDE.EQ.2)) THEN
        IDCPCN = IDCPC
C  remnant?
        IF(IDCPC.EQ.-1) THEN
          IF(ISIDE.EQ.1) THEN
            IDPDGR = 81
          ELSE
            IDPDGR = 82
          ENDIF
          IDCPCR = IPHO_PDG2ID(IDPDGR)
          IDEQB(ISIDE) = IPHO_PDG2ID(IDPDG)
          IDEQP(ISIDE) = IDPDG
C  copy particle properties
          IDB = ABS(IDEQB(ISIDE))
          XM_LIST(IDCPCR)  = XM_LIST(IDB)
          TAU_LIST(IDCPCR) = TAU_LIST(IDB)
          GAM_LIST(IDCPCR) = GAM_LIST(IDB)
          IF(IHFLS(ISIDE).EQ.1) THEN
            ICH3_LIST(IDCPCR) = IPHO_CHR3(IDEQB(ISIDE),0)
            IBA3_LIST(IDCPCR) = IPHO_BAR3(IDEQB(ISIDE),0)
          ELSE
            ICH3_LIST(IDCPCR) = 0
            IBA3_LIST(IDCPCR) = 0
          ENDIF
C  quark content
          IFL1 = IHFLD(ISIDE,1)
          IFL2 = IHFLD(ISIDE,2)
          IFL3 = 0
          IF(IHFLS(ISIDE).EQ.1) THEN
            IF(ABS(IHFLD(ISIDE,1)).GT.1000) THEN
              IFL1 = IHFLD(ISIDE,1)/1000
              IFL2 = MOD(IHFLD(ISIDE,1)/100,10)
              IFL3 = IHFLD(ISIDE,2)
            ELSE IF(ABS(IHFLD(ISIDE,2)).GT.1000) THEN
              IFL1 = IHFLD(ISIDE,1)
              IFL2 = IHFLD(ISIDE,2)/1000
              IFL3 = MOD(IHFLD(ISIDE,2)/100,10)
            ENDIF
          ENDIF
          IQ_LIST(1,IDCPCR) = IFL1
          IQ_LIST(2,IDCPCR) = IFL2
          IQ_LIST(3,IDCPCR) = IFL3

          IDCPCN = IDCPCR
          IDPDGN = IDPDGR

          IF(IDEB(87).GE.5) THEN
            WRITE(ErrorOut,'(1X,A,I2,/5X,A,I7,4I6)')
     &        'PHO_SETPAR: REMNANT ASSIGNMENT SIDE',ISIDE,
     &        'IDPDG,IFL1,2,3,IVAL',IDPDGN,IFL1,IFL2,IFL3,IHFLS(ISIDE)
          ENDIF
        ELSE IF(IDCPC.EQ.0) THEN
C  ordinary hadron
          IHFLS(ISIDE) = 1
          IHFLD(ISIDE,1) = 0
          IHFLD(ISIDE,2) = 0
          IDCPCN = IPHO_PDG2ID(IDPDG)
          IDPDGN = IDPDG
        ENDIF

C initialize /POGCMS/
        IFPAP(ISIDE) = IDPDGN
        IFPAB(ISIDE) = IDCPCN
        PMASS(ISIDE) = PHO_PMASS(IDCPCN,0)
        IF(IFPAP(ISIDE).EQ.22) THEN
          PVIRT(ISIDE) = ABS(PVIR)
        ELSE
          PVIRT(ISIDE) = 0.D0
        ENDIF

      ELSE IF(ISIDE.EQ.-2) THEN
C  output of current settings
        DO 100 I=1,2
          WRITE(ErrorOut,'(1X,A,I2,1X,A,I7,I4,1X,1P2E10.3)')
     &      'PHO_SETPAR: SIDE',
     &      I,'IDPDG,IDCPC,PMASS,PVIRT',IFPAP(I),IFPAB(I),PMASS(I),
     &      PVIRT(I)
          IF((IFPAP(I).EQ.81).OR.(IFPAP(I).EQ.82)) THEN
            WRITE(ErrorOut,'(5X,A,I7,I4,I2,3I5)')
     &        'REMNANT:IDPDG,IDCPC,IVAL,IFLA1,2',IDEQP(I),IDEQB(I),
     &        IHFLS(I),IHFLD(I,1),IHFLD(I,2)
          ENDIF
 100    CONTINUE
      ELSE
        WRITE(ErrorOut,'(/1X,A,I8)')
     &    'PHO_SETPAR: INVALID ARGUMENT (ISIDE)',ISIDE
      ENDIF

      END














CDECK  ID>, PHO_XLAM
      DOUBLE PRECISION FUNCTION PHO_XLAM(X,Y,Z)
C**********************************************************************
C
C     auxiliary function for two/three particle decay mode
C     (standard LAMBDA**(1/2) function)
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
C
      YZ=Y-Z
      XLAM=X*X-2.D0*X*(Y+Z)+YZ*YZ
      IF(XLAM.LT.0.D0) XLAM=-XLAM
      PHO_XLAM=SQRT(XLAM)
      END


CDECK  ID>, PHO_BESSJ0
      DOUBLE PRECISION FUNCTION PHO_BESSJ0(DX)
C**********************************************************************
C
C     CERN (KERN) LIB function C312
C
C     modified by R. Engel (03/02/93)
C
C**********************************************************************
      DOUBLE PRECISION DX
      DOUBLE PRECISION X,Y,V,H,ALFA,EIGHT
      DOUBLE PRECISION PI1,PI2,C1(0:14),C2(0:9),C3(0:10),B0,B1,B2,P,Q,R
      SAVE

      DATA EIGHT /8.0D0/
      DATA PI1 /0.79788 45608 0287D0/, PI2 /0.78539 81633 9745D0/

      DATA C1( 0) /+0.15772 79714 7489D0/
      DATA C1( 1) /-0.00872 34423 5285D0/
      DATA C1( 2) /+0.26517 86132 0334D0/
      DATA C1( 3) /-0.37009 49938 7265D0/
      DATA C1( 4) /+0.15806 71023 3210D0/
      DATA C1( 5) /-0.03489 37694 1141D0/
      DATA C1( 6) /+0.00481 91800 6947D0/
      DATA C1( 7) /-0.00046 06261 6621D0/
      DATA C1( 8) /+0.00003 24603 2882D0/
      DATA C1( 9) /-0.00000 17619 4691D0/
      DATA C1(10) /+0.00000 00760 8164D0/
      DATA C1(11) /-0.00000 00026 7925D0/
      DATA C1(12) /+0.00000 00000 7849D0/
      DATA C1(13) /-0.00000 00000 0194D0/
      DATA C1(14) /+0.00000 00000 0004D0/

      DATA C2( 0) /+0.99946 03493 4752D0/
      DATA C2( 1) /-0.00053 65220 4681D0/
      DATA C2( 2) /+0.00000 30751 8479D0/
      DATA C2( 3) /-0.00000 00517 0595D0/
      DATA C2( 4) /+0.00000 00016 3065D0/
      DATA C2( 5) /-0.00000 00000 7864D0/
      DATA C2( 6) /+0.00000 00000 0517D0/
      DATA C2( 7) /-0.00000 00000 0043D0/
      DATA C2( 8) /+0.00000 00000 0004D0/
      DATA C2( 9) /-0.00000 00000 0001D0/

      DATA C3( 0) /-0.01555 58546 05337D0/
      DATA C3( 1) /+0.00006 83851 99426D0/
      DATA C3( 2) /-0.00000 07414 49841D0/
      DATA C3( 3) /+0.00000 00179 72457D0/
      DATA C3( 4) /-0.00000 00007 27192D0/
      DATA C3( 5) /+0.00000 00000 42201D0/
      DATA C3( 6) /-0.00000 00000 03207D0/
      DATA C3( 7) /+0.00000 00000 00301D0/
      DATA C3( 8) /-0.00000 00000 00033D0/
      DATA C3( 9) /+0.00000 00000 00004D0/
      DATA C3(10) /-0.00000 00000 00001D0/

      X=DX
      V=ABS(X)
      IF(V .LT. EIGHT) THEN
       Y=V/EIGHT
       H=2.D0*Y**2-1.D0
       ALFA=-2.D0*H
       B1=0.D0
       B2=0.D0
       DO 1 I = 14,0,-1
       B0=C1(I)-ALFA*B1-B2
       B2=B1
    1  B1=B0
       B1=B0-H*B2
      ELSE
       R=1.D0/V
       Y=EIGHT*R
       H=2.D0*Y**2-1.D0
       ALFA=-2.D0*H
       B1=0.D0
       B2=0.D0
       DO 2 I = 9,0,-1
       B0=C2(I)-ALFA*B1-B2
       B2=B1
    2  B1=B0
       P=B0-H*B2
       B1=0.D0
       B2=0.D0
       DO 3 I = 10,0,-1
       B0=C3(I)-ALFA*B1-B2
       B2=B1
    3  B1=B0
       Q=Y*(B0-H*B2)
       B0=V-PI2
       B1=PI1*SQRT(R)*(P*COS(B0)-Q*SIN(B0))
      ENDIF
      PHO_BESSJ0=B1
      RETURN
      END


CDECK  ID>, PHO_BESSI0
      DOUBLE PRECISION FUNCTION PHO_BESSI0(X)
C**********************************************************************
C
C      Bessel Function I0
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      AX = ABS(X)
      IF (AX .LT. 3.75D0) THEN
        Y = (X/3.75D0)**2
        PHO_BESSI0 =
     &    1.0D0+Y*(3.5156229D0+Y*(3.0899424D0+Y*(1.2067492D0
     &    +Y*(0.2659732D0+Y*(0.360768D-1+Y*0.45813D-2)))))
      ELSE
        Y = 3.75D0/AX
        PHO_BESSI0 =
     &    (EXP(AX)/SQRT(AX))*(0.39894228D0+Y*(0.1328592D-1
     &    +Y*(0.225319D-2+Y*(-0.157565D-2+Y*(0.916281D-2
     &    +Y*(-0.2057706D-1+Y*(0.2635537D-1+Y*(-0.1647633D-1
     &    +Y*0.392377D-2))))))))
      ENDIF

      END


CDECK  ID>, PHO_BESSI1
      DOUBLE PRECISION FUNCTION PHO_BESSI1(X)
C**********************************************************************
C
C      Bessel Function I1
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      AX = ABS(X)

      IF (AX .LT. 3.75D0) THEN
        Y = (X/3.75D0)**2
        BESLI1 =
     &    AX*(0.5D0+Y*(0.87890594D0+Y*(0.51498869D0+Y*(0.15084934D0
     &    +Y*(0.2658733D-1+Y*(0.301532D-2+Y*0.32411D-3))))))
      ELSE
        Y = 3.75D0/AX
        BESLI1 =
     &    0.2282967D-1+Y*(-0.2895312D-1+Y*(0.1787654D-1
     &    -Y*0.420059D-2))
        BESLI1 =
     &    0.39894228D0+Y*(-0.3988024D-1+Y*(-0.362018D-2
     &    +Y*(0.163801D-2+Y*(-0.1031555D-1+Y*BESLI1))))
        BESLI1 = BESLI1 * EXP(AX)/SQRT(AX)
      ENDIF
      IF (X .LT. 0.D0) BESLI1 = -BESLI1

      PHO_BESSI1 = BESLI1

      END


CDECK  ID>, PHO_BESSK0
      DOUBLE PRECISION FUNCTION PHO_BESSK0(X)
C**********************************************************************
C
C      Modified Bessel Function K0
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      IF (X .LT. 2.D0) THEN
        Y = X**2/4.D0
        PHO_BESSK0 =
     &    (-LOG(X/2.D0)*PHO_BESSI0(X))+(-.57721566D0+Y*(0.42278420D0
     &    +Y*(0.23069756D0+Y*(0.3488590D-1+Y*(0.262698D-2
     &    +Y*(0.10750D-3+Y*0.740D-5))))))
      ELSE
        Y = 2.D0/X
        PHO_BESSK0 =
     &    (EXP(-X)/SQRT(X))*(1.25331414D0+Y*(-0.7832358D-1
     &    +Y*(0.2189568D-1+Y*(-0.1062446D-1+Y*(0.587872D-2
     &    +Y*(-0.251540D-2+Y*0.53208D-3))))))
      ENDIF

      END


CDECK  ID>, PHO_BESSK1
      DOUBLE PRECISION FUNCTION PHO_BESSK1(X)
C**********************************************************************
C
C      Modified Bessel Function K1
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      IF (X .LT. 2.D0) THEN
        Y = X**2/4.D0
        PHO_BESSK1 =
     &    (LOG(X/2.D0)*PHO_BESSI1(X))+(1.D0/X)*(1.D0+Y*(0.15443144D0
     &    +Y*(-0.67278579D0+Y*(-0.18156897D0+Y*(-0.1919402D-1
     &    +Y*(-0.110404D-2+Y*(-0.4686D-4)))))))
      ELSE
        Y=2.D0/X
        PHO_BESSK1 =
     &    (EXP(-X)/SQRT(X))*(1.25331414D0+Y*(0.23498619D0
     &    +Y*(-0.3655620D-1+Y*(0.1504268D-1+Y*(-0.780353D-2
     &    +Y*(0.325614D-2+Y*(-0.68245D-3)))))))
      ENDIF

      END


CDECK  ID>, PHO_GAUSET
      SUBROUTINE PHO_GAUSET(AX,BX,NX,Z,W)
C********************************************************************
C
C     N-point gauss zeros and weights for the interval (AX,BX) are
C           stored in  arrays Z and W respectively.
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      COMMON /POGDAT/A(273),X(273),KTAB(96)
      DIMENSION Z(NX),W(NX)

      ALPHA=0.5*(BX+AX)
      BETA=0.5*(BX-AX)
      N=NX

C  the N=1 case:
      IF(N.NE.1) GO TO 1
      Z(1)=ALPHA
      W(1)=BX-AX
      RETURN

C  the Gauss cases:
    1 IF((N.LE.16).AND.(N.GT.1)) GO TO 2
      IF(N.EQ.20) GO TO 2
      IF(N.EQ.24) GO TO 2
      IF(N.EQ.32) GO TO 2
      IF(N.EQ.40) GO TO 2
      IF(N.EQ.48) GO TO 2
      IF(N.EQ.64) GO TO 2
      IF(N.EQ.80) GO TO 2
      IF(N.EQ.96) GO TO 2

C  the extended Gauss cases:
      IF((N/96)*96.EQ.N) GO TO 3

C  jump to center of intervall intrgration:
      GO TO 100

C  get Gauss point array

    2 CALL PHO_GAUDAT
C  extract real points
      K=KTAB(N)
      M=N/2
      DO 21 J=1,M
C       extract values from big array
        JTAB=K-1+J
        WTEMP=BETA*A(JTAB)
        DELTA=BETA*X(JTAB)
C       store them backward
        Z(J)=ALPHA-DELTA
        W(J)=WTEMP
C       store them forward
        JP=N+1-J
        Z(JP)=ALPHA+DELTA
        W(JP)=WTEMP
   21 CONTINUE
C     store central point (odd N)
      IF((N-M-M).EQ.0) RETURN
      Z(M+1)=ALPHA
      JMID=K+M
      W(M+1)=BETA*A(JMID)
      RETURN

C  get ND96 times chained 96 Gauss point array

    3 CALL PHO_GAUDAT
C  print out message
C     -extract real points
      K=KTAB(96)
      ND96=N/96
      DO 31 J=1,48
C       extract values from big array
        JTAB=K-1+J
        WTEMP=BETA*A(JTAB)
        DELTA=BETA*X(JTAB)
        WTEMP=WTEMP/ND96
        DELTA=DELTA/ND96
        DO 32 JD96=0,ND96-1
          ZCNTR= (ALPHA-BETA)+ BETA*FLOAT(2*JD96+1)/FLOAT(ND96)
C         store them backward
          Z(J+JD96*96)=ZCNTR-DELTA
          W(J+JD96*96)=WTEMP
C         store them forward
          JP=96+1-J
          Z(JP+JD96*96)=ZCNTR+DELTA
          W(JP+JD96*96)=WTEMP
   32   CONTINUE
   31 CONTINUE
      RETURN

C  the center of intervall cases:
  100 CONTINUE
C  put in constant weight and equally spaced central points
      N=IABS(N)
      DO 111 IN=1,N
        WIN=(BX-AX)/FLOAT(N)
        Z(IN)=AX  + (FLOAT(IN)-.5)*WIN
  111 W(IN)=WIN

      END


CDECK  ID>, PHO_GAUDAT
      SUBROUTINE PHO_GAUDAT
C*********************************************************************
C
C     store big arrays needed for Gauss integral, CERNLIB D106BD
C     (arrays A,X,ITAB copied on B,Y,LTAB)
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      SAVE
      COMMON /POGDAT/ B(273),Y(273),LTAB(96)
      DIMENSION       A(273),X(273),KTAB(96)

C-----TABLE OF INITIAL SUBSCRIPTS FOR N=2(1)16(4)96
      DATA KTAB(2)/1/
      DATA KTAB(3)/2/
      DATA KTAB(4)/4/
      DATA KTAB(5)/6/
      DATA KTAB(6)/9/
      DATA KTAB(7)/12/
      DATA KTAB(8)/16/
      DATA KTAB(9)/20/
      DATA KTAB(10)/25/
      DATA KTAB(11)/30/
      DATA KTAB(12)/36/
      DATA KTAB(13)/42/
      DATA KTAB(14)/49/
      DATA KTAB(15)/56/
      DATA KTAB(16)/64/
      DATA KTAB(20)/72/
      DATA KTAB(24)/82/
      DATA KTAB(28)/82/
      DATA KTAB(32)/94/
      DATA KTAB(36)/94/
      DATA KTAB(40)/110/
      DATA KTAB(44)/110/
      DATA KTAB(48)/130/
      DATA KTAB(52)/130/
      DATA KTAB(56)/130/
      DATA KTAB(60)/130/
      DATA KTAB(64)/154/
      DATA KTAB(68)/154/
      DATA KTAB(72)/154/
      DATA KTAB(76)/154/
      DATA KTAB(80)/186/
      DATA KTAB(84)/186/
      DATA KTAB(88)/186/
      DATA KTAB(92)/186/
      DATA KTAB(96)/226/
C
C-----TABLE OF ABSCISSAE (X) AND WEIGHTS (A) FOR INTERVAL (-1,+1).
C
C-----N=2
      DATA X(1)/0.577350269189626D0  /, A(1)/1.000000000000000D0  /
C-----N=3
      DATA X(2)/0.774596669241483D0  /, A(2)/0.555555555555556D0  /
      DATA X(3)/0.000000000000000D0  /, A(3)/0.888888888888889D0  /
C-----N=4
      DATA X(4)/0.861136311594053D0  /, A(4)/0.347854845137454D0  /
      DATA X(5)/0.339981043584856D0  /, A(5)/0.652145154862546D0  /
C-----N=5
      DATA X(6)/0.906179845938664D0  /, A(6)/0.236926885056189D0  /
      DATA X(7)/0.538469310105683D0  /, A(7)/0.478628670499366D0  /
      DATA X(8)/0.000000000000000D0  /, A(8)/0.568888888888889D0  /
C-----N=6
      DATA X(9)/0.932469514203152D0  /, A(9)/0.171324492379170D0  /
      DATA X(10)/0.661209386466265D0 /, A(10)/0.360761573048139D0 /
      DATA X(11)/0.238619186083197D0 /, A(11)/0.467913934572691D0 /
C-----N=7
      DATA X(12)/0.949107912342759D0 /, A(12)/0.129484966168870D0 /
      DATA X(13)/0.741531185599394D0 /, A(13)/0.279705391489277D0 /
      DATA X(14)/0.405845151377397D0 /, A(14)/0.381830050505119D0 /
      DATA X(15)/0.000000000000000D0 /, A(15)/0.417959183673469D0 /
C-----N=8
      DATA X(16)/0.960289856497536D0 /, A(16)/0.101228536290376D0 /
      DATA X(17)/0.796666477413627D0 /, A(17)/0.222381034453374D0 /
      DATA X(18)/0.525532409916329D0 /, A(18)/0.313706645877887D0 /
      DATA X(19)/0.183434642495650D0 /, A(19)/0.362683783378362D0 /
C-----N=9
      DATA X(20)/0.968160239507626D0 /, A(20)/0.081274388361574D0 /
      DATA X(21)/0.836031107326636D0 /, A(21)/0.180648160694857D0 /
      DATA X(22)/0.613371432700590D0 /, A(22)/0.260610696402935D0 /
      DATA X(23)/0.324253423403809D0 /, A(23)/0.312347077040003D0 /
      DATA X(24)/0.000000000000000D0 /, A(24)/0.330239355001260D0 /
C-----N=10
      DATA X(25)/0.973906528517172D0 /, A(25)/0.066671344308688D0 /
      DATA X(26)/0.865063366688985D0 /, A(26)/0.149451349150581D0 /
      DATA X(27)/0.679409568299024D0 /, A(27)/0.219086362515982D0 /
      DATA X(28)/0.433395394129247D0 /, A(28)/0.269266719309996D0 /
      DATA X(29)/0.148874338981631D0 /, A(29)/0.295524224714753D0 /
C-----N=11
      DATA X(30)/0.978228658146057D0 /, A(30)/0.055668567116174D0 /
      DATA X(31)/0.887062599768095D0 /, A(31)/0.125580369464905D0 /
      DATA X(32)/0.730152005574049D0 /, A(32)/0.186290210927734D0 /
      DATA X(33)/0.519096129206812D0 /, A(33)/0.233193764591990D0 /
      DATA X(34)/0.269543155952345D0 /, A(34)/0.262804544510247D0 /
      DATA X(35)/0.000000000000000D0 /, A(35)/0.272925086777901D0 /
C-----N=12
      DATA X(36)/0.981560634246719D0 /, A(36)/0.047175336386512D0 /
      DATA X(37)/0.904117256370475D0 /, A(37)/0.106939325995318D0 /
      DATA X(38)/0.769902674194305D0 /, A(38)/0.160078328543346D0 /
      DATA X(39)/0.587317954286617D0 /, A(39)/0.203167426723066D0 /
      DATA X(40)/0.367831498998180D0 /, A(40)/0.233492536538355D0 /
      DATA X(41)/0.125233408511469D0 /, A(41)/0.249147045813403D0 /
C-----N=13
      DATA X(42)/0.984183054718588D0 /, A(42)/0.040484004765316D0 /
      DATA X(43)/0.917598399222978D0 /, A(43)/0.092121499837728D0 /
      DATA X(44)/0.801578090733310D0 /, A(44)/0.138873510219787D0 /
      DATA X(45)/0.642349339440340D0 /, A(45)/0.178145980761946D0 /
      DATA X(46)/0.448492751036447D0 /, A(46)/0.207816047536889D0 /
      DATA X(47)/0.230458315955135D0 /, A(47)/0.226283180262897D0 /
      DATA X(48)/0.000000000000000D0 /, A(48)/0.232551553230874D0 /
C-----N=14
      DATA X(49)/0.986283808696812D0 /, A(49)/0.035119460331752D0 /
      DATA X(50)/0.928434883663574D0 /, A(50)/0.080158087159760D0 /
      DATA X(51)/0.827201315069765D0 /, A(51)/0.121518570687903D0 /
      DATA X(52)/0.687292904811685D0 /, A(52)/0.157203167158194D0 /
      DATA X(53)/0.515248636358154D0 /, A(53)/0.185538397477938D0 /
      DATA X(54)/0.319112368927890D0 /, A(54)/0.205198463721296D0 /
      DATA X(55)/0.108054948707344D0 /, A(55)/0.215263853463158D0 /
C-----N=15
      DATA X(56)/0.987992518020485D0 /, A(56)/0.030753241996117D0 /
      DATA X(57)/0.937273392400706D0 /, A(57)/0.070366047488108D0 /
      DATA X(58)/0.848206583410427D0 /, A(58)/0.107159220467172D0 /
      DATA X(59)/0.724417731360170D0 /, A(59)/0.139570677926154D0 /
      DATA X(60)/0.570972172608539D0 /, A(60)/0.166269205816994D0 /
      DATA X(61)/0.394151347077563D0 /, A(61)/0.186161000015562D0 /
      DATA X(62)/0.201194093997435D0 /, A(62)/0.198431485327111D0 /
      DATA X(63)/0.000000000000000D0 /, A(63)/0.202578241925561D0 /
C-----N=16
      DATA X(64)/0.989400934991650D0 /, A(64)/0.027152459411754D0 /
      DATA X(65)/0.944575023073233D0 /, A(65)/0.062253523938648D0 /
      DATA X(66)/0.865631202387832D0 /, A(66)/0.095158511682493D0 /
      DATA X(67)/0.755404408355003D0 /, A(67)/0.124628971255534D0 /
      DATA X(68)/0.617876244402644D0 /, A(68)/0.149595988816577D0 /
      DATA X(69)/0.458016777657227D0 /, A(69)/0.169156519395003D0 /
      DATA X(70)/0.281603550779259D0 /, A(70)/0.182603415044924D0 /
      DATA X(71)/0.095012509837637D0 /, A(71)/0.189450610455069D0 /
C-----N=20
      DATA X(72)/0.993128599185094D0 /, A(72)/0.017614007139152D0 /
      DATA X(73)/0.963971927277913D0 /, A(73)/0.040601429800386D0 /
      DATA X(74)/0.912234428251325D0 /, A(74)/0.062672048334109D0 /
      DATA X(75)/0.839116971822218D0 /, A(75)/0.083276741576704D0 /
      DATA X(76)/0.746331906460150D0 /, A(76)/0.101930119817240D0 /
      DATA X(77)/0.636053680726515D0 /, A(77)/0.118194531961518D0 /
      DATA X(78)/0.510867001950827D0 /, A(78)/0.131688638449176D0 /
      DATA X(79)/0.373706088715419D0 /, A(79)/0.142096109318382D0 /
      DATA X(80)/0.227785851141645D0 /, A(80)/0.149172986472603D0 /
      DATA X(81)/0.076526521133497D0 /, A(81)/0.152753387130725D0 /
C-----N=24
      DATA X(82)/0.995187219997021D0 /, A(82)/0.012341229799987D0 /
      DATA X(83)/0.974728555971309D0 /, A(83)/0.028531388628933D0 /
      DATA X(84)/0.938274552002732D0 /, A(84)/0.044277438817419D0 /
      DATA X(85)/0.886415527004401D0 /, A(85)/0.059298584915436D0 /
      DATA X(86)/0.820001985973902D0 /, A(86)/0.073346481411080D0 /
      DATA X(87)/0.740124191578554D0 /, A(87)/0.086190161531953D0 /
      DATA X(88)/0.648093651936975D0 /, A(88)/0.097618652104113D0 /
      DATA X(89)/0.545421471388839D0 /, A(89)/0.107444270115965D0 /
      DATA X(90)/0.433793507626045D0 /, A(90)/0.115505668053725D0 /
      DATA X(91)/0.315042679696163D0 /, A(91)/0.121670472927803D0 /
      DATA X(92)/0.191118867473616D0 /, A(92)/0.125837456346828D0 /
      DATA X(93)/0.064056892862605D0 /, A(93)/0.127938195346752D0 /
C-----N=32
      DATA X(94)/0.997263861849481D0 /, A(94)/0.007018610009470D0 /
      DATA X(95)/0.985611511545268D0 /, A(95)/0.016274394730905D0 /
      DATA X(96)/0.964762255587506D0 /, A(96)/0.025392065309262D0 /
      DATA X(97)/0.934906075937739D0 /, A(97)/0.034273862913021D0 /
      DATA X(98)/0.896321155766052D0 /, A(98)/0.042835898022226D0 /
      DATA X(99)/0.849367613732569D0 /, A(99)/0.050998059262376D0 /
      DATA X(100)/0.794483795967942D0/, A(100)/0.058684093478535D0/
      DATA X(101)/0.732182118740289D0/, A(101)/0.065822222776361D0/
      DATA X(102)/0.663044266930215D0/, A(102)/0.072345794108848D0/
      DATA X(103)/0.587715757240762D0/, A(103)/0.078193895787070D0/
      DATA X(104)/0.506899908932229D0/, A(104)/0.083311924226946D0/
      DATA X(105)/0.421351276130635D0/, A(105)/0.087652093004403D0/
      DATA X(106)/0.331868602282127D0/, A(106)/0.091173878695763D0/
      DATA X(107)/0.239287362252137D0/, A(107)/0.093844399080804D0/
      DATA X(108)/0.144471961582796D0/, A(108)/0.095638720079274D0/
      DATA X(109)/0.048307665687738D0/, A(109)/0.096540088514727D0/
C-----N=40
      DATA X(110)/0.998237709710559D0/, A(110)/0.004521277098533D0/
      DATA X(111)/0.990726238699457D0/, A(111)/0.010498284531152D0/
      DATA X(112)/0.977259949983774D0/, A(112)/0.016421058381907D0/
      DATA X(113)/0.957916819213791D0/, A(113)/0.022245849194166D0/
      DATA X(114)/0.932812808278676D0/, A(114)/0.027937006980023D0/
      DATA X(115)/0.902098806968874D0/, A(115)/0.033460195282547D0/
      DATA X(116)/0.865959503212259D0/, A(116)/0.038782167974472D0/
      DATA X(117)/0.824612230833311D0/, A(117)/0.043870908185673D0/
      DATA X(118)/0.778305651426519D0/, A(118)/0.048695807635072D0/
      DATA X(119)/0.727318255189927D0/, A(119)/0.053227846983936D0/
      DATA X(120)/0.671956684614179D0/, A(120)/0.057439769099391D0/
      DATA X(121)/0.612553889667980D0/, A(121)/0.061306242492928D0/
      DATA X(122)/0.549467125095128D0/, A(122)/0.064804013456601D0/
      DATA X(123)/0.483075801686178D0/, A(123)/0.067912045815233D0/
      DATA X(124)/0.413779204371605D0/, A(124)/0.070611647391286D0/
      DATA X(125)/0.341994090825758D0/, A(125)/0.072886582395804D0/
      DATA X(126)/0.268152185007253D0/, A(126)/0.074723169057968D0/
      DATA X(127)/0.192697580701371D0/, A(127)/0.076110361900626D0/
      DATA X(128)/0.116084070675255D0/, A(128)/0.077039818164247D0/
      DATA X(129)/0.038772417506050D0/, A(129)/0.077505947978424D0/
C-----N=48
      DATA X(130)/0.998771007252426D0/, A(130)/0.003153346052305D0/
      DATA X(131)/0.993530172266350D0/, A(131)/0.007327553901276D0/
      DATA X(132)/0.984124583722826D0/, A(132)/0.011477234579234D0/
      DATA X(133)/0.970591592546247D0/, A(133)/0.015579315722943D0/
      DATA X(134)/0.952987703160430D0/, A(134)/0.019616160457355D0/
      DATA X(135)/0.931386690706554D0/, A(135)/0.023570760839324D0/
      DATA X(136)/0.905879136715569D0/, A(136)/0.027426509708356D0/
      DATA X(137)/0.876572020274247D0/, A(137)/0.031167227832798D0/
      DATA X(138)/0.843588261624393D0/, A(138)/0.034777222564770D0/
      DATA X(139)/0.807066204029442D0/, A(139)/0.038241351065830D0/
      DATA X(140)/0.767159032515740D0/, A(140)/0.041545082943464D0/
      DATA X(141)/0.724034130923814D0/, A(141)/0.044674560856694D0/
      DATA X(142)/0.677872379632663D0/, A(142)/0.047616658492490D0/
      DATA X(143)/0.628867396776513D0/, A(143)/0.050359035553854D0/
      DATA X(144)/0.577224726083972D0/, A(144)/0.052890189485193D0/
      DATA X(145)/0.523160974722233D0/, A(145)/0.055199503699984D0/
      DATA X(146)/0.466902904750958D0/, A(146)/0.057277292100403D0/
      DATA X(147)/0.408686481990716D0/, A(147)/0.059114839698395D0/
      DATA X(148)/0.348755886292160D0/, A(148)/0.060704439165893D0/
      DATA X(149)/0.287362487355455D0/, A(149)/0.062039423159892D0/
      DATA X(150)/0.224763790394689D0/, A(150)/0.063114192286254D0/
      DATA X(151)/0.161222356068891D0/, A(151)/0.063924238584648D0/
      DATA X(152)/0.097004699209462D0/, A(152)/0.064466164435950D0/
      DATA X(153)/0.032380170962869D0/, A(153)/0.064737696812683D0/
C-----N=64
      DATA X(154)/0.999305041735772D0/, A(154)/0.001783280721696D0/
      DATA X(155)/0.996340116771955D0/, A(155)/0.004147033260562D0/
      DATA X(156)/0.991013371476744D0/, A(156)/0.006504457968978D0/
      DATA X(157)/0.983336253884625D0/, A(157)/0.008846759826363D0/
      DATA X(158)/0.973326827789910D0/, A(158)/0.011168139460131D0/
      DATA X(159)/0.961008799652053D0/, A(159)/0.013463047896718D0/
      DATA X(160)/0.946411374858402D0/, A(160)/0.015726030476024D0/
      DATA X(161)/0.929569172131939D0/, A(161)/0.017951715775697D0/
      DATA X(162)/0.910522137078502D0/, A(162)/0.020134823153530D0/
      DATA X(163)/0.889315445995114D0/, A(163)/0.022270173808383D0/
      DATA X(164)/0.865999398154092D0/, A(164)/0.024352702568710D0/
      DATA X(165)/0.840629296252580D0/, A(165)/0.026377469715054D0/
      DATA X(166)/0.813265315122797D0/, A(166)/0.028339672614259D0/
      DATA X(167)/0.783972358943341D0/, A(167)/0.030234657072402D0/
      DATA X(168)/0.752819907260531D0/, A(168)/0.032057928354851D0/
      DATA X(169)/0.719881850171610D0/, A(169)/0.033805161837141D0/
      DATA X(170)/0.685236313054233D0/, A(170)/0.035472213256882D0/
      DATA X(171)/0.648965471254657D0/, A(171)/0.037055128540240D0/
      DATA X(172)/0.611155355172393D0/, A(172)/0.038550153178615D0/
      DATA X(173)/0.571895646202634D0/, A(173)/0.039953741132720D0/
      DATA X(174)/0.531279464019894D0/, A(174)/0.041262563242623D0/
      DATA X(175)/0.489403145707052D0/, A(175)/0.042473515123653D0/
      DATA X(176)/0.446366017253464D0/, A(176)/0.043583724529323D0/
      DATA X(177)/0.402270157963991D0/, A(177)/0.044590558163756D0/
      DATA X(178)/0.357220158337668D0/, A(178)/0.045491627927418D0/
      DATA X(179)/0.311322871990210D0/, A(179)/0.046284796581314D0/
      DATA X(180)/0.264687162208767D0/, A(180)/0.046968182816210D0/
      DATA X(181)/0.217423643740007D0/, A(181)/0.047540165714830D0/
      DATA X(182)/0.169644420423992D0/, A(182)/0.047999388596458D0/
      DATA X(183)/0.121462819296120D0/, A(183)/0.048344762234802D0/
      DATA X(184)/0.072993121787799D0/, A(184)/0.048575467441503D0/
      DATA X(185)/0.024350292663424D0/, A(185)/0.048690957009139D0/
C-----N=80
      DATA X(186)/0.999553822651630D0/, A(186)/0.001144950003186D0/
      DATA X(187)/0.997649864398237D0/, A(187)/0.002663533589512D0/
      DATA X(188)/0.994227540965688D0/, A(188)/0.004180313124694D0/
      DATA X(189)/0.989291302499755D0/, A(189)/0.005690922451403D0/
      DATA X(190)/0.982848572738629D0/, A(190)/0.007192904768117D0/
      DATA X(191)/0.974909140585727D0/, A(191)/0.008683945269260D0/
      DATA X(192)/0.965485089043799D0/, A(192)/0.010161766041103D0/
      DATA X(193)/0.954590766343634D0/, A(193)/0.011624114120797D0/
      DATA X(194)/0.942242761309872D0/, A(194)/0.013068761592401D0/
      DATA X(195)/0.928459877172445D0/, A(195)/0.014493508040509D0/
      DATA X(196)/0.913263102571757D0/, A(196)/0.015896183583725D0/
      DATA X(197)/0.896675579438770D0/, A(197)/0.017274652056269D0/
      DATA X(198)/0.878722567678213D0/, A(198)/0.018626814208299D0/
      DATA X(199)/0.859431406663111D0/, A(199)/0.019950610878141D0/
      DATA X(200)/0.838831473580255D0/, A(200)/0.021244026115782D0/
      DATA X(201)/0.816954138681463D0/, A(201)/0.022505090246332D0/
      DATA X(202)/0.793832717504605D0/, A(202)/0.023731882865930D0/
      DATA X(203)/0.769502420135041D0/, A(203)/0.024922535764115D0/
      DATA X(204)/0.744000297583597D0/, A(204)/0.026075235767565D0/
      DATA X(205)/0.717365185362099D0/, A(205)/0.027188227500486D0/
      DATA X(206)/0.689637644342027D0/, A(206)/0.028259816057276D0/
      DATA X(207)/0.660859898986119D0/, A(207)/0.029288369583267D0/
      DATA X(208)/0.631075773046871D0/, A(208)/0.030272321759557D0/
      DATA X(209)/0.600330622829751D0/, A(209)/0.031210174188114D0/
      DATA X(210)/0.568671268122709D0/, A(210)/0.032100498673487D0/
      DATA X(211)/0.536145920897131D0/, A(211)/0.032941939397645D0/
      DATA X(212)/0.502804111888784D0/, A(212)/0.033733214984611D0/
      DATA X(213)/0.468696615170544D0/, A(213)/0.034473120451753D0/
      DATA X(214)/0.433875370831756D0/, A(214)/0.035160529044747D0/
      DATA X(215)/0.398393405881969D0/, A(215)/0.035794393953416D0/
      DATA X(216)/0.362304753499487D0/, A(216)/0.036373749905835D0/
      DATA X(217)/0.325664370747701D0/, A(217)/0.036897714638276D0/
      DATA X(218)/0.288528054884511D0/, A(218)/0.037365490238730D0/
      DATA X(219)/0.250952358392272D0/, A(219)/0.037776364362001D0/
      DATA X(220)/0.212994502857666D0/, A(220)/0.038129711314477D0/
      DATA X(221)/0.174712291832646D0/, A(221)/0.038424993006959D0/
      DATA X(222)/0.136164022809143D0/, A(222)/0.038661759774076D0/
      DATA X(223)/0.097408398441584D0/, A(223)/0.038839651059051D0/
      DATA X(224)/0.058504437152420D0/, A(224)/0.038958395962769D0/
      DATA X(225)/0.019511383256793D0/, A(225)/0.039017813656306D0/
C-----N=96
      DATA X(226)/0.999689503883230D0/, A(226)/0.000796792065552D0/
      DATA X(227)/0.998364375863181D0/, A(227)/0.001853960788946D0/
      DATA X(228)/0.995981842987209D0/, A(228)/0.002910731817934D0/
      DATA X(229)/0.992543900323762D0/, A(229)/0.003964554338444D0/
      DATA X(230)/0.988054126329623D0/, A(230)/0.005014202742927D0/
      DATA X(231)/0.982517263563014D0/, A(231)/0.006058545504235D0/
      DATA X(232)/0.975939174585136D0/, A(232)/0.007096470791153D0/
      DATA X(233)/0.968326828463264D0/, A(233)/0.008126876925698D0/
      DATA X(234)/0.959688291448742D0/, A(234)/0.009148671230783D0/
      DATA X(235)/0.950032717784437D0/, A(235)/0.010160770535008D0/
      DATA X(236)/0.939370339752755D0/, A(236)/0.011162102099838D0/
      DATA X(237)/0.927712456722308D0/, A(237)/0.012151604671088D0/
      DATA X(238)/0.915071423120898D0/, A(238)/0.013128229566961D0/
      DATA X(239)/0.901460635315852D0/, A(239)/0.014090941772314D0/
      DATA X(240)/0.886894517402420D0/, A(240)/0.015038721026994D0/
      DATA X(241)/0.871388505909296D0/, A(241)/0.015970562902562D0/
      DATA X(242)/0.854959033434601D0/, A(242)/0.016885479864245D0/
      DATA X(243)/0.837623511228187D0/, A(243)/0.017782502316045D0/
      DATA X(244)/0.819400310737931D0/, A(244)/0.018660679627411D0/
      DATA X(245)/0.800308744139140D0/, A(245)/0.019519081140145D0/
      DATA X(246)/0.780369043867433D0/, A(246)/0.020356797154333D0/
      DATA X(247)/0.759602341176647D0/, A(247)/0.021172939892191D0/
      DATA X(248)/0.738030643744400D0/, A(248)/0.021966644438744D0/
      DATA X(249)/0.715676812348967D0/, A(249)/0.022737069658329D0/
      DATA X(250)/0.692564536642171D0/, A(250)/0.023483399085926D0/
      DATA X(251)/0.668718310043916D0/, A(251)/0.024204841792364D0/
      DATA X(252)/0.644163403784967D0/, A(252)/0.024900633222483D0/
      DATA X(253)/0.618925840125468D0/, A(253)/0.025570036005349D0/
      DATA X(254)/0.593032364777572D0/, A(254)/0.026212340735672D0/
      DATA X(255)/0.566510418561397D0/, A(255)/0.026826866725591D0/
      DATA X(256)/0.539388108324357D0/, A(256)/0.027412962726029D0/
      DATA X(257)/0.511694177154667D0/, A(257)/0.027970007616848D0/
      DATA X(258)/0.483457973920596D0/, A(258)/0.028497411065085D0/
      DATA X(259)/0.454709422167743D0/, A(259)/0.028994614150555D0/
      DATA X(260)/0.425478988407300D0/, A(260)/0.029461089958167D0/
      DATA X(261)/0.395797649828908D0/, A(261)/0.029896344136328D0/
      DATA X(262)/0.365696861472313D0/, A(262)/0.030299915420827D0/
      DATA X(263)/0.335208522892625D0/, A(263)/0.030671376123669D0/
      DATA X(264)/0.304364944354496D0/, A(264)/0.031010332586313D0/
      DATA X(265)/0.273198812591049D0/, A(265)/0.031316425596861D0/
      DATA X(266)/0.241743156163840D0/, A(266)/0.031589330770727D0/
      DATA X(267)/0.210031310460567D0/, A(267)/0.031828758894411D0/
      DATA X(268)/0.178096882367618D0/, A(268)/0.032034456231992D0/
      DATA X(269)/0.145973714654896D0/, A(269)/0.032206204794030D0/
      DATA X(270)/0.113695850110665D0/, A(270)/0.032343822568575D0/
      DATA X(271)/0.081297495464425D0/, A(271)/0.032447163714064D0/
      DATA X(272)/0.048812985136049D0/, A(272)/0.032516118713868D0/
      DATA X(273)/0.016276744849602D0/, A(273)/0.032550614492363D0/
      DATA IBD/0/
      IF(IBD.NE.0) RETURN
      IBD=1
      DO 10 I=1,273
        B(I) = A(I)
        Y(I) = X(I)
 10   CONTINUE
      DO 20 I=1,96
        LTAB(I) = KTAB(I)
 20   CONTINUE
      END


CDECK  ID>, PHO_RNDM
      DOUBLE PRECISION FUNCTION PHO_RNDM(DUMMY)
cccc &&&&&&& kk
      real*8 DUMMY, u
      call rndc(U)
      PHO_RNDM = u
      end
      DOUBLE PRECISION FUNCTION PHO_RNDMOrig(DUMMY)
      
C***********************************************************************
C
C    random number generator
C
C    initialization by call to PHO_RNDIN needed!
C
C    the algorithm is taken from
C      G.Marsaglia, A.Zaman: 'Toward a unversal random number generator'
C      Florida State Univ. preprint FSU-SCRI-87-70
C
C    implementation by K. Hahn (Dec. 88), changed to include possibility
C    of saving / reading generator registers to / from file (R.E. 10/98)
C
C    generator should not depend on the hardware (if a real has
C    at least 24 significant bits in internal representation),
C    the period is about 2**144,
C
C    internal registers:
C       U(97),C,CD,CM,I,J  - seed values as initialized in PHO_RNDIN
C
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      COMMON /PORAND/ U(97),C,CD,CM,I,J

 100  CONTINUE

      RNDMI = U(I)-U(J)
      IF ( RNDMI.LT.0.D0 ) RNDMI = RNDMI+1.D0
      U(I) = RNDMI
      I    = I-1
      IF ( I.EQ.0 ) I = 97
      J    = J-1
      IF ( J.EQ.0 ) J = 97
      C    = C-CD
      IF ( C.LT.0.D0 ) C = C+CM
      RNDMI = RNDMI-C
      IF ( RNDMI.LT.0.D0 ) RNDMI = RNDMI+1.D0

      IF((RNDMI.EQ.0.D0).OR.(RNDMI.EQ.1.D0)) GOTO 100
      PHO_RNDM = RNDMI

      END


CDECK  ID>, PHO_RNDIN
      SUBROUTINE PHO_RNDIN(NA1,NA2,NA3,NB1)
C***********************************************************************
C
C     initialization of PHO_RNDM, has to be called before using PHO_RNDM
C
C     input:
C       NA1,NA2,NA3,NB1  - values for initializing the generator
C                          NA? must be in 1..178 and not all 1;
C                          12,34,56  are the standard values
C                          NB1 must be in 1..168;
C                          78  is the standard value
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      COMMON /PORAND/ U(97),C,CD,CM,I,J
      MA1 = NA1
      MA2 = NA2
      MA3 = NA3
      MB1 = NB1
      I   = 97
      J   = 33
      DO 20 II2 = 1,97
        S = 0.D0
        T = 0.5D0
        DO 10 II1 = 1,24
          MAT  = MOD(MOD(MA1*MA2,179)*MA3,179)
          MA1  = MA2
          MA2  = MA3
          MA3  = MAT
          MB1  = MOD(53*MB1+1,169)
          IF ( MOD(MB1*MAT,64).GE.32 ) S = S+T
          T    = 0.5D0*T
 10     CONTINUE
        U(II2) = S
 20   CONTINUE
      C  =   362436.D0/16777216.D0
      CD =  7654321.D0/16777216.D0
      CM = 16777213.D0/16777216.D0

      END


CDECK  ID>, PHO_RNDSI
      SUBROUTINE PHO_RNDSI(UIN,CIN,CDIN,CMIN,IIN,JIN)
C***********************************************************************
C
C     updates internal random number generator registers using
C     registers given as arguments
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      DIMENSION UIN(97)
      COMMON /PORAND/ U(97),C,CD,CM,I,J
      DO 10 KKK = 1,97
        U(KKK) = UIN(KKK)
 10   CONTINUE
      C  = CIN
      CD = CDIN
      CM = CMIN
      I  = IIN
      J  = JIN

      END


CDECK  ID>, PHO_RNDSO
      SUBROUTINE PHO_RNDSO(UOUT,COUT,CDOUT,CMOUT,IOUT,JOUT)
C***********************************************************************
C
C     copies internal registers from randon number generator
C     to arguments
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      DIMENSION UOUT(97)
      COMMON /PORAND/ U(97),C,CD,CM,I,J
      DO 10 KKK = 1,97
        UOUT(KKK) = U(KKK)
 10   CONTINUE
      COUT  = C
      CDOUT = CD
      CMOUT = CM
      IOUT  = I
      JOUT  = J

      END


CDECK  ID>, PHO_RNDTE
      SUBROUTINE PHO_RNDTE(IO)
C***********************************************************************
C
C     test of random number generator PHO_RNDM
C
C     input:
C       IO defines output
C           0  output only if an error is detected
C           1  output independend on an error
C
C     uses PHO_RNDSI and PHO_RNDSO to bring the random number generator
C     to same status as it had before the test run
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      DIMENSION UU(97)
      DIMENSION U(6),X(6),D(6)
      DATA U / 6533892.D0 , 14220222.D0 ,  7275067.D0 ,
     &         6172232.D0 ,  8354498.D0 , 10633180.D0 /

      CALL PHO_RNDSO(UU,CC,CCD,CCM,II,JJ)

      CALL PHO_RNDIN(12,34,56,78)
      DO 10 II1 = 1,20000
        XX      = PHO_RNDM(SD)
 10   CONTINUE

      SD        = 0.D0
      DO 20 II2 = 1,6
        X(II2)  = 4096.D0*(4096.D0*PHO_RNDM(XX))
        D(II2)  = X(II2)-U(II2)
        SD      = SD+ABS(D(II2))
 20   CONTINUE

      CALL PHO_RNDSI(UU,CC,CCD,CCM,II,JJ)

      IF ((IO.EQ.1).OR.(SD.NE.0.D0)) THEN
        WRITE(ErrorOut,50) (U(I),X(I),D(I),I=1,6)
      ENDIF

 50   FORMAT(/,' PHO_RNDTE: TEST OF THE RANDOM NUMBER GENERATOR:',/,
     &  '    EXPECTED VALUE    CALCULATED VALUE     DIFFERENCE',/,
     &  6(F17.1,F20.1,F15.3,/),
     &  ' GENERATOR HAS THE SAME STATUS AS BEFORE CALLING PHO_RNDTE',/)

      END



CDECK  ID>, PHO_RNDST
      SUBROUTINE PHO_RNDST(MODE,FILENA)
C***********************************************************************
C
C     read / write random number generator status from / to file
C
C     input:    MODE        1   read registers from file
C                           2   dump registers to file
C
C               FILENA      file name
C
C***********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      INTEGER       MODE
      CHARACTER*(*) FILENA


      DOUBLE PRECISION UU,CC,CCD,CCM
      DIMENSION UU(97)

      INTEGER I,II,JJ

      CHARACTER*80 CH_DUMMY

      IF(MODE.EQ.1) THEN

        WRITE(ErrorOut,'(/,1X,2A,A,/)') 'PHO_RNDST: ',
     &    'READING RANDOM NUMBER REGISTERS FROM FILE ',FILENA

        OPEN(12,FILE=FILENA,ERR=1010,STATUS='OLD')
        READ(12,*,ERR=1010) CH_DUMMY
        DO I=1,97
          READ(12,*,ERR=1010) UU(I)
        ENDDO
        READ(12,*,ERR=1010) CC
        READ(12,*,ERR=1010) CCD
        READ(12,*,ERR=1010) CCM
        READ(12,*,ERR=1010) II,JJ
        CLOSE(12)
        CALL PHO_RNDSI(UU,CC,CCD,CCM,II,JJ)

      ELSE IF(MODE.EQ.2) THEN

        WRITE(ErrorOut,'(/,1X,2A,A,/)') 'PHO_RNDST: ',
     &    'DUMPING RANDOM NUMBER REGISTERS TO FILE ',FILENA

        OPEN(12,FILE=FILENA,ERR=1010,STATUS='UNKNOWN')
        CALL PHO_RNDSO(UU,CC,CCD,CCM,II,JJ)
        WRITE(12,'(1X,A)',ERR=1020) 'random number status registers:'
        DO I=1,97
          WRITE(12,'(1X,1P,E28.20)',ERR=1020) UU(I)
        ENDDO
        WRITE(12,'(1X,1P,E28.20)',ERR=1020) CC
        WRITE(12,'(1X,1P,E28.20)',ERR=1020) CCD
        WRITE(12,'(1X,1P,E28.20)',ERR=1020) CCM
        WRITE(12,'(1X,2I4)',ERR=1020) II,JJ
        CLOSE(12)

      ELSE

        WRITE(ErrorOut,'(/,1X,2A,I6,/)') 'PHO_RNDST: ',
     &    'CALLED WITH INVALID MODE, NOTHING DONE (MODE)',MODE

      ENDIF

      RETURN

 1010 CONTINUE
      WRITE(ErrorOut,'(1X,2A,A,/)') 'PHO_RNDST: ',
     &  'CANNOT OPEN OR READ FILE ',FILENA
      RETURN

 1020 CONTINUE
      WRITE(ErrorOut,'(1X,A,A,/)') 'PHO_RNDST: ',
     &  'cannot open or write file ',FILENA
      RETURN

      END


CDECK  ID>, PHO_DZEROX
      DOUBLE PRECISION FUNCTION PHO_DZEROX(A0,B0,EPS,MAXF,F,MODE)
C**********************************************************************
C
C     Based on
C
C        J.C.P. Bus and T.J. Dekker, Two Efficient Algorithms with
C        Guaranteed Convergence for Finding a Zero of a Function,
C        ACM Trans. Math. Software 1 (1975) 330-345.
C
C        (MODE = 1: Algorithm M;    MODE = 2: Algorithm R)
C
C        CERNLIB C200
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      CHARACTER NAME*(*)
      PARAMETER (NAME = 'PHO_DZEROX')
      LOGICAL LMT
      DIMENSION IM1(2),IM2(2),LMT(2)
      EXTERNAL F

      PARAMETER (Z1 = 1, HALF = Z1/2)

      DATA IM1 /2,3/, IM2 /-1,3/

      IF(MODE .NE. 1 .AND. MODE .NE. 2) THEN
       C=-2D+10
       WRITE(ErrorOut,100) NAME,MODE
       GO TO 99
      ENDIF
      FA=F(B0)
      FB=F(A0)
      IF(FA*FB .GT. 0) THEN
       C=-3D+10
       WRITE(ErrorOut,101) NAME
       GO TO 99
      ENDIF
      ATL=ABS(EPS)
      B=A0
      A=B0
      LMT(2)=.TRUE.
      MF=2
    1 C=A
      FC=FA
    2 IE=0
    3 IF(ABS(FC) .LT. ABS(FB)) THEN
       IF(C .NE. A) THEN
        D=A
        FD=FA
       END IF
       A=B
       B=C
       C=A
       FA=FB
       FB=FC
       FC=FA
      END IF
      TOL=ATL*(1+ABS(C))
      H=HALF*(C+B)
      HB=H-B
      IF(ABS(HB) .GT. TOL) THEN
       IF(IE .GT. IM1(MODE)) THEN
        W=HB
       ELSE
        TOL=TOL*SIGN(Z1,HB)
        P=(B-A)*FB
        LMT(1)=IE .LE. 1
        IF(LMT(MODE)) THEN
         Q=FA-FB
         LMT(2)=.FALSE.
        ELSE
         FDB=(FD-FB)/(D-B)
         FDA=(FD-FA)/(D-A)
         P=FDA*P
         Q=FDB*FA-FDA*FB
        END IF
        IF(P .LT. 0) THEN
         P=-P
         Q=-Q
        END IF
        IF(IE .EQ. IM2(MODE)) P=P+P
        IF(P .EQ. 0 .OR. P .LE. Q*TOL) THEN
         W=TOL
        ELSEIF(P .LT. HB*Q) THEN
         W=P/Q
        ELSE
         W=HB
        END IF
       END IF
       D=A
       A=B
       FD=FA
       FA=FB
       B=B+W
       MF=MF+1
       IF(MF .GT. MAXF) THEN
        WRITE(ErrorOut,102) NAME
        GO TO 99
       ENDIF
       FB=F(B)
       IF(FB .EQ. 0 .OR. SIGN(Z1,FC) .EQ. SIGN(Z1,FB)) GO TO 1
       IF(W .EQ. HB) GO TO 2
       IE=IE+1
       GO TO 3
      END IF
   99 CONTINUE
      PHO_DZEROX=C
      RETURN
  100 FORMAT(1X,A,': MODE = ',I3,' ILLEGAL')
  101 FORMAT(1X,A,': F(A) AND F(B) HAVE THE SAME SIGN')
  102 FORMAT(1X,A,': TOO MANY FUNCTION CALLS')

      END


CDECK  ID>, PHO_EXPINT
      DOUBLE PRECISION FUNCTION PHO_EXPINT(RXM)
C***********************************************************************
C
C     function to calculate  E_i(x) = -E_1(-x)
C
C     based on CERNLIB C337   (changed by R.Engel 10/1993)
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
C
      DOUBLE PRECISION P1(5),Q1(5),P2(7),Q2(7),P3(6),Q3(6),P4(8),Q4(8)
      DOUBLE PRECISION A1(8),B1(8),A2(8),B2(8),A3(6),B3(6),XL(6)
      DOUBLE PRECISION X,Y,AP,BP,DP,AQ,BQ,DQ,X0,V

      DATA  X0 /0.37250 74107 8137D0/
      DATA XL /-24.0D0,-12.0D0,-6.0D0,0.0D0,1.0D0,4.0D0/
      DATA P1
     1/+4.29312 52343 210D+0, +3.98941 53870 321D+1,
     2 +2.92525 18866 921D+2, +4.25696 82638 592D+2,
     3 -4.34981 43832 952D+2/
      DATA Q1
     1/+1.00000 00000 000D+0, +1.88992 88395 003D+1,
     2 +1.50950 38744 251D+2, +5.68052 52718 987D+2,
     3 +7.53585 64359 843D+2/
      DATA P2
     1/+4.30967 83946 939D-1, +6.90522 52278 444D+0,
     2 +2.30192 55939 133D+1, +2.43784 08879 132D+1,
     3 +9.04161 55694 633D+0, +9.99979 57705 159D-1,
     4 +4.65627 10797 510D-7/
      DATA Q2
     1/+1.03400 13040 487D-1, +3.31909 21359 330D+0,
     2 +2.04494 78501 379D+1, +4.12807 84189 142D+1,
     3 +3.24264 21069 514D+1, +1.00411 64382 905D+1,
     4 +1.00000 00000 000D+0/
      DATA P3
     1/-2.39099 64453 136D+0, -1.47982 19500 504D+2,
     2 -2.54376 33976 890D+2, -1.19557 61038 372D+2,
     3 -1.96304 08535 939D+1, -9.99999 99990 360D-1/
      DATA Q3
     1/+1.77600 70940 351D+2, +5.30685 09610 812D+2,
     2 +4.62230 27156 148D+2, +1.56818 43364 539D+2,
     3 +2.16304 08494 238D+1, +1.00000 00000 000D+0/
      DATA P4
     1/-8.66937 33995 107D+0, -5.49142 26552 109D+2,
     2 -4.21001 61535 707D+3, -2.49301 39345 865D+5,
     3 -1.19623 66934 925D+5, -2.21744 62775 885D+7,
     4 +3.89280 42131 120D+6, -3.91546 07380 910D+8/
      DATA Q4
     1/+3.41718 75000 000D+1, -1.60708 92658 722D+3,
     2 +3.57300 29805 851D+4, -4.83547 43616 216D+5,
     3 +4.28559 62461 175D+6, -2.49033 37574 054D+7,
     4 +8.91925 76757 561D+7, -1.65254 29972 521D+8/
      DATA A1
     1/-2.18086 38152 072D+0, -2.19010 23385 488D+1,
     2 +9.30816 38566 217D+0, +2.50762 81129 356D+1,
     3 -3.31842 53199 722D+1, +6.01217 99083 008D+1,
     4 -4.32531 13287 813D+1, +1.00443 10922 808D+0/
      DATA B1
     1/+0.00000 00000 000D+0, +3.93707 70185 272D+0,
     2 +3.00892 64837 292D+2, -6.25041 16167 188D+0,
     3 +1.00367 43951 673D+3, +1.43256 73812 194D+1,
     4 +2.73624 11988 933D+3, +5.27468 85196 291D-1/
      DATA A2
     1/-3.48334 65360 285D+0, -1.86545 45488 340D+1,
     2 -8.28561 99414 064D+0, -3.23467 33030 540D+1,
     3 +1.79601 68876 925D+1, +1.75656 31546 961D+0,
     4 -1.95022 32128 966D+0, +9.99994 29607 471D-1/
      DATA B2
     1/+0.00000 00000 000D+0, +6.95000 65588 743D+1,
     2 +5.72837 19383 732D+1, +2.57776 38423 844D+1,
     3 +7.60761 14800 773D+2, +2.89516 72792 514D+1,
     4 -3.43942 26689 987D+0, +1.00083 86740 264D+0/
      DATA A3
     1/-2.77809 28934 438D+1, -1.01047 90815 760D+1,
     2 -9.14830 08216 736D+0, -5.02233 17461 851D+0,
     3 -3.00000 77799 358D+0, +1.00000 00000 704D+0/
      DATA B3
     1/+0.00000 00000 000D+0, +1.22399 93926 823D+2,
     2 +2.72761 00778 779D+0, -7.18975 18395 045D+0,
     3 -2.99901 18065 262D+0, +1.99999 99428 260D+0/
C
C  conversion to E_i function
      X = -RXM
C
      IF(X .LE. XL(1)) THEN
       AP=A3(1)-X
       DO 1 I = 2,5
    1  AP=A3(I)-X+B3(I)/AP
       Y=(EXP(-X)/X)*(1.D0-(A3(6)+B3(6)/AP)/X)
      ELSEIF(X .LE. XL(2)) THEN
       AP=A2(1)-X
       DO 2 I = 2,7
    2     AP=A2(I)-X+B2(I)/AP
       Y=(EXP(-X)/X)*(A2(8)+B2(8)/AP)
      ELSEIF(X .LE. XL(3)) THEN
       AP=A1(1)-X
       DO 3 I = 2,7
    3     AP=A1(I)-X+B1(I)/AP
       Y=(EXP(-X)/X)*(A1(8)+B1(8)/AP)
      ELSEIF(X .LT. XL(4)) THEN
       V=-2.D0*(X/3.D0+1.D0)
       BP=0.D0
       DP=P4(1)
       DO 4 I = 2,8
          AP=BP
          BP=DP
    4     DP=P4(I)-AP+V*BP
       BQ=0.D0
       DQ=Q4(1)
       DO 14 I = 2,8
          AQ=BQ
          BQ=DQ
   14     DQ=Q4(I)-AQ+V*BQ
       Y=-LOG(-X/X0)+(X+X0)*(DP-AP)/(DQ-AQ)
      ELSEIF(X .EQ. XL(4)) THEN
*      CALL KERMTR('C337.1',LGFILE,MFLAG,RFLAG)
*      IF(MFLAG) THEN
*       IF(LGFILE .EQ. 0) THEN
*        WRITE(*,100) ENAME
*       ELSE
*        WRITE(LGFILE,100) ENAME
*       ENDIF
*      ENDIF
*      IF(.NOT.RFLAG) CALL ABEND
       PHO_EXPINT=0.D0
       RETURN
      ELSEIF(X .LT. XL(5)) THEN
       AP=P1(1)
       AQ=Q1(1)
       DO 5 I = 2,5
          AP=P1(I)+X*AP
    5     AQ=Q1(I)+X*AQ
       Y=-LOG(X)+AP/AQ
      ELSEIF(X .LE. XL(6)) THEN
       Y=1.D0/X
       AP=P2(1)
       AQ=Q2(1)
       DO 6 I = 2,7
          AP=P2(I)+Y*AP
    6     AQ=Q2(I)+Y*AQ
       Y=EXP(-X)*AP/AQ
      ELSE
       Y=1.D0/X
       AP=P3(1)
       AQ=Q3(1)
       DO 7 I = 2,6
          AP=P3(I)+Y*AP
    7     AQ=Q3(I)+Y*AQ
       Y=EXP(-X)*Y*(1.D0+Y*AP/AQ)
      ENDIF
C  sign conversion to E_i
      PHO_EXPINT=-Y

      END


CDECK  ID>, PHO_RNDBET
      DOUBLE PRECISION FUNCTION PHO_RNDBET(GAM,ETA)
C********************************************************************
C
C     RANDOM NUMBER GENERATION FROM BETA
C     DISTRIBUTION IN REGION  0 < X < 1.
C     F(X) = X**(GAM-1.)*(1.-X)**(ETA-1)*GAMM(ETA+GAM) / (GAMM(GAM
C                                                        *GAMM(ETA))
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      Y = PHO_RNDGAM(1.D0,GAM)
      Z = PHO_RNDGAM(1.D0,ETA)

      PHO_RNDBET = Y/(Y+Z)

      END


CDECK  ID>, PHO_RNDGAM
      DOUBLE PRECISION FUNCTION PHO_RNDGAM(ALAM,ETA)
C********************************************************************
C
C     RANDOM NUMBER SELECTION FROM GAMMA DISTRIBUTION
C     F(X) = ALAM**ETA*X**(ETA-1)*EXP(-ALAM*X) / GAM(ETA)
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
C
      NCOU=0
      N = ETA
      F = ETA - N
      IF(F.EQ.0.D0) GOTO 20
   10 R = PHO_RNDM(ETA)
      NCOU=NCOU+1
      IF (NCOU.GE.11) GOTO 20
      IF(R.LT.F/(F+2.71828D0)) GOTO 30
      YYY=LOG(PHO_RNDM(F)+1.0D-9)/F
      IF(ABS(YYY).GT.50.D0) GOTO 20
      Y = EXP(YYY)
      IF(LOG(PHO_RNDM(Y)+1.0D-9).GT.-Y) GOTO 10
      GOTO 40
   20 Y = 0.D0
      GOTO 50
   30 Y = 1.D0-LOG(PHO_RNDM(R)+1.0D-9)
      IF(PHO_RNDM(Y).GT.Y**(F-1.D0)) GOTO 10
   40 IF(N.EQ.0) GOTO 70
   50 Z = 1.D0
      DO 60 I = 1,N
   60 Z = Z*PHO_RNDM(Y)
      Y = Y-LOG(Z+1.0D-9)
   70 PHO_RNDGAM = Y/ALAM
      RETURN
      END


CDECK  ID>, PHO_SFECFE
      SUBROUTINE PHO_SFECFE(SFE,CFE)
C**********************************************************************
C
C     fast random SIN(X) COS(X) selection
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
C
    1 CONTINUE
        X=PHO_RNDM(XX)
        Y=PHO_RNDM(YY)
        XX=X*X
        YY=Y*Y
        XY=XX+YY
      IF(XY.GT.1.D0) GOTO 1
      CFE=(XX-YY)/XY
      SFE=2.D0*X*Y/XY
      IF(PHO_RNDM(XY).LT.0.5D0) THEN
        SFE=-SFE
      ENDIF
      END


CDECK  ID>, PHO_SWAPD
      SUBROUTINE PHO_SWAPD(D1,D2)
C********************************************************************
C
C     exchange of argument values (double precision)
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      D = D1
      D1 = D2
      D2 = D
      END


CDECK  ID>, PHO_SWAPI
      SUBROUTINE PHO_SWAPI(I1,I2)
C********************************************************************
C
C     exchange of argument values (integer)
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      K = I1
      I1 = I2
      I2 = K
      END



CDECK  ID>, PHO_HADCSL
      SUBROUTINE PHO_HADCSL(ID1,ID2,ECM,PLAB,IMODE,
     &                     SIGTOT,SIGEL,SIGDIF,SLOPE,RHO)
C***********************************************************************
C
C     low-energy cross section parametrizations
C
C     input:   ID1,ID2     PDG IDs of particles (meson first)
C              ECM         c.m. energy (GeV)
C              PLAB        lab. momentum (second particle at rest)
C              IMODE       1    ECM given, PLAB ignored
C                          2    PLAB given, ECM ignored
C
C     output:  SIGTOT      total cross section (mb)
C              SIGEL       elastic cross section (mb)
C              SIGDIF      diffracive cross section (sd-1,sd-2,dd), (mb)
C              SLOPE       forward elastic slope (GeV**-2)
C              RHO         real/imaginary part of elastic amplitude
C
C     comments:
C
C     - low-energy data interpolation uses PDG fits from 1992 issue
C     - high-energy extrapolation by Donnachie-Landshoff like fit made
C       by PDG 1996
C     - analytic extension of amplitude to calculate rho
C
C***********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      INTEGER ID1,ID2,IMODE
      DOUBLE PRECISION ECM,PLAB,SIGTOT,SIGEL,SIGDIF(3),SLOPE,RHO

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


      INTEGER K
      DOUBLE PRECISION SIGTO1,SIGTO2,SIGEL1,SIGEL2,
     &  SS,PL,PLL,E1,XP,YP,YM,PHR,PHP,X1,X2

      DOUBLE PRECISION TPDG92(7,2,6),TPDG96(9,6),BURQ83(3,6),XMA(6)

      DATA TPDG92  /
     &  3.D0, 2100.D0, 48.D0, 0.D0, 1.D0, 0.522D0, -4.51D0,
     &  3.D0, 2100.D0, 11.9D0, 26.9D0, -1.21D0, 0.169D0, -1.85D0,
     &  5.D0, 2100.D0, 38.4D0, 77.6D0, -0.64D0, 0.26D0, -1.2D0,
     &  5.D0, 2100.D0, 10.2D0, 52.7D0, -1.16D0, 0.125D0, -1.28D0,
     &  4.D0, 340.D0,  16.4D0, 19.3D0, -0.42D0, 0.19D0, 0.D0,
     &  4.D0, 340.D0,  0.D0, 11.4D0, -0.4D0, 0.079D0, 0.D0,
     &  2.5D0, 370.D0, 33.D0, 14.D0, -1.36D0, 0.456D0, -4.03D0,
     &  2.5D0, 370.D0, 1.76D0, 11.2D0, -0.64D0, 0.043D0, 0.D0,
     &  2.D0, 310.D0,  18.1D0, 0.D0, 1.D0, 0.26D0, -1.D0,
     &  2.D0, 310.D0,  5.D0, 8.1D0, -1.8D0, 0.16D0, -1.3D0,
     &  3.D0, 310.D0,  32.1D0, 0.D0, 1.D0, 0.66D0, -5.6D0,
     &  3.D0, 310.D0,  7.3D0, 0.D0, 1.D0, 0.29D0, -2.4D0  /

      DATA TPDG96  /
     &  50.D0, 22.D0,0.079D0,0.25D0,0.D0,
     &         77.15D0,-21.05D0,0.46D0,0.9D0,
     &  50.D0, 22.D0,0.079D0,0.25D0,0.D0,
     &         77.15D0,21.05D0,0.46D0,0.9D0,
     &  10.D0, 13.70,0.079D0,0.25D0,0.D0,
     &         31.85D0,-4.05D0,0.45D0,0.9D0,
     &  10.D0, 13.70,0.079D0,0.25D0,0.D0,
     &         31.85D0,4.05D0,0.45D0,0.9D0,
     &  10.D0, 12.20,0.079D0,0.25D0,0.D0,
     &         17.35D0,-9.05D0,0.50D0,0.9D0,
     &  10.D0, 12.20,0.079D0,0.25D0,0.D0,
     &         17.35D0,9.05D0,0.50D0,0.9D0  /

      DATA BURQ83 /
     &  11.13D0, -6.21D0, 0.30D0,
     &  11.13D0,  7.23D0, 0.30D0,
     &  9.11D0,  -0.73D0, 0.28D0,
     &  9.11D0,   0.65D0, 0.28D0,
     &  8.55D0,  -5.98D0, 0.28D0,
     &  8.55D0,   1.60D0, 0.28D0  /

      DATA XMA /
     &  2*0.93956563D0, 2*0.13956995D0, 2*0.493677D0 /

C  find index
      IF(ID2.NE.2212) THEN
        GOTO 100
      ELSE IF(ID1.EQ.2212) THEN
        K = 1
      ELSE IF(ID1.EQ.-2212) THEN
        K = 2
      ELSE IF(ID1.EQ.211) THEN
        K = 3
      ELSE IF(ID1.EQ.-211) THEN
        K = 4
      ELSE IF(ID1.EQ.321) THEN
        K = 5
      ELSE IF(ID1.EQ.-321) THEN
        K = 6
      ELSE
        GOTO 100
      ENDIF

C  calculate lab momentum
      IF(IMODE.EQ.1) THEN
        SS = ECM**2
        E1 = 0.5D0/XMA(1)*(SS-XMA(1)**2-XMA(K)**2)
        PL = SQRT(E1*E1-XMA(K)**2)
      ELSE IF(IMODE.EQ.2) THEN
        PL = PLAB
        SS = XMA(1)**2+XMA(K)**2+2.D0*XMA(1)*SQRT(PL**2+XMA(K)**2)
        ECM = SQRT(SS)
      ELSE
        WRITE(ErrorOut,
     * '(1X,A,I5)') 'PHO_HADCSL:ERROR: invalid IMODE: ',IMODE
        RETURN
      ENDIF
      PLL = LOG(PL)

C  check against lower limit
      IF(ECM.LE.XMA(1)+XMA(K)) GOTO 200

      XP  = TPDG96(2,K)*SS**TPDG96(3,K)
      YP  = TPDG96(6,K)/SS**TPDG96(8,K)
      YM  = TPDG96(7,K)/SS**TPDG96(8,K)

      PHR = TAN(PI/2.D0*(1.-TPDG96(8,K)))
      PHP = TAN(PI/2.D0*(1.+TPDG96(3,K)))
      RHO = (-YP/PHR + YM*PHR - XP/PHP)/(YP+YM+XP)
      SLOPE = BURQ83(1,K)+BURQ83(2,K)/SQRT(PL)+BURQ83(3,K)*PLL

C  select energy range and interpolation method
      IF(PL.LT.TPDG96(1,K)) THEN
        SIGTOT = TPDG92(3,1,K)+TPDG92(4,1,K)*PL**TPDG92(5,1,K)
     &          + TPDG92(6,1,K)*PLL**2+TPDG92(7,1,K)*PLL
        SIGEL  = TPDG92(3,2,K)+TPDG92(4,2,K)*PL**TPDG92(5,2,K)
     &          + TPDG92(6,2,K)*PLL**2+TPDG92(7,2,K)*PLL
      ELSE IF(PL.LT.TPDG92(2,1,K)) THEN
        SIGTO1 = TPDG92(3,1,K)+TPDG92(4,1,K)*PL**TPDG92(5,1,K)
     &          + TPDG92(6,1,K)*PLL**2+TPDG92(7,1,K)*PLL
        SIGEL1 = TPDG92(3,2,K)+TPDG92(4,2,K)*PL**TPDG92(5,2,K)
     &          + TPDG92(6,2,K)*PLL**2+TPDG92(7,2,K)*PLL
        SIGTO2 = YP+YM+XP
        SIGEL2 = SIGTO2**2/(16.D0*PI*SLOPE*GEV2MB)*(1.D0+RHO**2)
        X2 = LOG(PL/TPDG96(1,K))/LOG(TPDG92(2,1,K)/TPDG96(1,K))
        X1 = 1.D0 - X2
        SIGTOT = SIGTO2*X2 + SIGTO1*X1
        SIGEL  = SIGEL2*X2 + SIGEL1*X1
      ELSE
        SIGTOT = YP+YM+XP
        SIGEL  = SIGTOT**2/(16.D0*PI*SLOPE*GEV2MB)*(1.D0+RHO**2)
      ENDIF

C  no parametrization of diffraction implemented
      SIGDIF(1) = -1.D0
      SIGDIF(2) = -1.D0
      SIGDIF(3) = -1.D0

      RETURN

 100  CONTINUE
        WRITE(ErrorOut,'(1X,2A,2I7)') 'PHO_HADCSL:ERROR: ',
     &    'INVALID PARTICLE COMBINATION: ',ID1,ID2
        RETURN

 200  CONTINUE
        WRITE(ErrorOut,
     * '(1X,2A,1P,2E12.4)') 'PHO_HADCSL:ERROR: ',
     &    'ENERGY TOO SMALL (ECM,PLAB): ',ECM,PLAB

      END


CDECK  ID>, PHO_CSDIFF
      SUBROUTINE PHO_CSDIFF(ID1,ID2,SS,XI_MIN,XI_MAX,
     &  SIG_SD1,SIG_SD2,SIG_DD)
C***********************************************************************
C
C     cross section for diffraction dissociation according to
C     Goulianos' parametrization (Ref: PL B358 (1995) 379)
C
C     in addition rescaling for different particles is applied using
C     internal rescaling tables (not implemented yet)
C
C     input:     Id1/2       PDG ID's of incoming particles
C                SS          squared c.m. energy (GeV**2)
C                Xi_min      min. diff mass (squared) = Xi_min*SS
C                Xi_max      max. diff mass (squared) = Xi_max*SS
C
C     output:    sig_sd1     cross section for diss. of particle 1 (mb)
C                sig_sd2     cross section for diss. of particle 2 (mb)
C                sig_dd      cross section for diss. of both particles
C
C***********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      INTEGER ID1,ID2
      DOUBLE PRECISION SS,XI_MIN,XI_MAX,SIG_SD1,SIG_SD2,SIG_DD

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


      DOUBLE PRECISION XPOS1(96),XWGH1(96),XPOS2(96),XWGH2(96)
      DOUBLE PRECISION DELTA,ALPHAP,BETA0,GPOM0,XM_P,X_RAD2,XM4_P2,
     &  FAC,TT,T1,T2,TL,TU,XNORM,XI,XIL,XIU,W_XI,ALPHA_T,F2_T,
     &  XMS_1,XMS_2,CSDIFF

      INTEGER NGAU1,NGAU2,I1,I2


C  model parameters

      DATA DELTA    / 0.104D0 /
      DATA ALPHAP   / 0.25D0 /
      DATA BETA0    / 6.56D0 /
      DATA GPOM0    / 1.21D0 /
      DATA XM_P     / 0.938D0 /
      DATA X_RAD2   / 0.71D0 /

C  integration precision

      DATA NGAU1    / 96 /
      DATA NGAU2    / 96 /

      SIG_SD1 = 0.D0
      SIG_SD2 = 0.D0
      SIG_DD  = 0.D0


      IF ((ABS(ID1).EQ.2212).AND.(ABS(ID2).EQ.2212)) THEN

        XM4_P2 = 4.D0*XM_P**2
        FAC = BETA0**2/(16.D0*PI)

        T1 = -5.D0
        T2 = 0.D0
        TL = X_RAD2/3.D0/(1.D0-T1/X_RAD2)**3
        TU = X_RAD2/3.D0/(1.D0-T2/X_RAD2)**3

C  flux renormalization and cross section

        XNORM  = 0.D0

        XIL = LOG(1.5D0/SS)
        XIU = LOG(0.1D0)

        IF(XIU.LE.XIL) GOTO 1000

        CALL PHO_GAUSET(XIL,XIU,NGAU1,XPOS1,XWGH1)
        CALL PHO_GAUSET(TL,TU,NGAU2,XPOS2,XWGH2)

        DO I1=1,NGAU1

          XI = EXP(XPOS1(I1))
          W_XI = XWGH1(I1)

          DO I2=1,NGAU2

            TT = X_RAD2-X_RAD2*(X_RAD2/(3.D0*XPOS2(I2)))**(1.D0/3.D0)

            ALPHA_T =  1.D0+DELTA+ALPHAP*TT
            F2_T = ((XM4_P2-2.8D0*TT)/(XM4_P2-TT))**2

            XNORM = XNORM
     &        + F2_T*XI**(2.D0-2.D0*ALPHA_T)*XWGH2(I2)*W_XI

          ENDDO
        ENDDO

        XNORM = XNORM*FAC

 1000   CONTINUE

        XIL = LOG(XI_MIN)
        XIU = LOG(XI_MAX)

        T1 = -5.D0
        T2 = 0.D0

        TL = X_RAD2/3.D0/(1.D0-T1/X_RAD2)**3
        TU = X_RAD2/3.D0/(1.D0-T2/X_RAD2)**3

C  single diffraction diss. cross section

        CSDIFF = 0.D0

        IF(XIU.LE.XIL) GOTO 2000

        CALL PHO_GAUSET(XIL,XIU,NGAU1,XPOS1,XWGH1)
        CALL PHO_GAUSET(TL,TU,NGAU2,XPOS2,XWGH2)

        DO I1=1,NGAU1

          XI = EXP(XPOS1(I1))
          W_XI = XWGH1(I1)*BETA0*GPOM0*(XI*SS)**DELTA

          DO I2=1,NGAU2

            TT = X_RAD2-X_RAD2*(X_RAD2/(3.D0*XPOS2(I2)))**(1.D0/3.D0)

            ALPHA_T =  1.D0+DELTA+ALPHAP*TT
            F2_T = ((XM4_P2-2.8D0*TT)/(XM4_P2-TT))**2

            CSDIFF = CSDIFF
     &        + F2_T*XI**(2.D0-2.D0*ALPHA_T)*XWGH2(I2)*W_XI

          ENDDO
        ENDDO

        CSDIFF = CSDIFF*FAC*GEV2MB/MAX(1.D0,XNORM)

*       write(6,'(1x,1p,4e14.3)')
*    &    sqrt(SS),Xnorm,2.*CSdiff*MAX(1.d0,Xnorm),2.*CSdiff

        SIG_SD1 = CSDIFF
        SIG_SD2 = CSDIFF

 2000   CONTINUE

C  double diffraction dissociation cross section

        CSDIFF = 0.D0

        XIL = LOG(1.5D0/SS)
        XIU = LOG(XI_MAX/1.5D0)

        IF(XIU.LE.XIL) GOTO 3000

        FAC = (BETA0*GPOM0*SS**DELTA
     &         /(4.D0*SQRT(PI)*MAX(1.D0,XNORM)))**2
     &       /(2.D0*ALPHAP)

        CALL PHO_GAUSET(XIL,XIU,NGAU1,XPOS1,XWGH1)

        DO I1=1,NGAU1

          XI = EXP(XPOS1(I1))
          XMS_1 = XI*SS

          XIU = LOG(XI_MAX/(XI*SS))

          IF(XIL.LT.XIU) THEN

            CALL PHO_GAUSET(XIL,XIU,NGAU2,XPOS2,XWGH2)

            DO I2=1,NGAU2

              XMS_2 = EXP(XPOS2(I2))*SS
              CSDIFF = CSDIFF
     &          + 1.D0/((XMS_1*XMS_2)**DELTA*LOG(SS/(XMS_1*XMS_2)))
     &            *XWGH1(I1)*XWGH2(I2)

            ENDDO

          ENDIF

        ENDDO

        SIG_DD = CSDIFF*FAC*GEV2MB

 3000   CONTINUE


      ELSE

        WRITE(ErrorOut,'(1x,2a,2I8)') 'PHO_CSDIFF: ',
     &    'INVALID PARTICLE COMBINATION (ID1/2)',ID1,ID2

      ENDIF

      END



CDECK  ID>, PHO_ALLM97
      DOUBLE PRECISION FUNCTION PHO_ALLM97(Q2,W)
C**********************************************************************
C
C     ALLM97 parametrization for gamma*-p cross section
C     (for F2 see comments, code adapted from V. Shekelyan, H1)
C
C**********************************************************************

      IMPLICIT NONE

      SAVE

      DOUBLE PRECISION Q2,W
      DOUBLE PRECISION M02,M12,LAM2,M22
      DOUBLE PRECISION S11,S12,S13,A11,A12,A13,B11,B12,B13
      DOUBLE PRECISION S21,S22,S23,A21,A22,A23,B21,B22,B23
      DOUBLE PRECISION ALFA,XMP2,W2,Q02,S,T,T0,Z,CIN,
     &                 AP,BP,AR,BR,XP,XR,SR,SP,F2P,F2R
      DATA ALFA,XMP2 /112.2D0 , .8802D0 /

      W2=W*W
      PHO_ALLM97 = 0.D0

C  pomeron
      S11   =   0.28067D0
      S12   =   0.22291D0
      S13   =   2.1979D0
      A11   =  -0.0808D0
      A12   =  -0.44812D0
      A13   =   1.1709D0
      B11   =   0.60243D0
      B12   =   1.3754D0
      B13   =   1.8439D0
      M12   =  49.457D0

C  reggeon
      S21   =   0.80107D0
      S22   =   0.97307D0
      S23   =   3.4942D0
      A21   =   0.58400D0
      A22   =   0.37888D0
      A23   =   2.6063D0
      B21   =   0.10711D0
      B22   =   1.9386D0
      B23   =   0.49338D0
      M22   =   0.15052D0
C
      M02   =   0.31985D0
      LAM2  =   0.065270D0
      Q02   =   0.46017D0 +LAM2

C
      S=0.
      T=LOG((Q2+Q02)/LAM2)
      T0=LOG(Q02/LAM2)
      IF(Q2.GT.0.D0) S=LOG(T/T0)
      Z=1.D0

      IF(Q2.GT.0.D0) Z=(W2-XMP2)/(Q2+W2-XMP2)

      IF(S.LT.0.01D0) THEN

C   pomeron part

        XP=1.D0 /(1.D0 +(W2-XMP2)/(Q2+M12))

        AP=A11
        BP=B11**2

        SP=S11
        F2P=SP*XP**AP*Z**BP

C   reggeon part

        XR=1.D0 /(1.D0 +(W2-XMP2)/(Q2+M22))

        AR=A21
        BR=B21**2

        SR=S21
        F2R=SR*XR**AR*Z**BR

      ELSE

C   pomeron part

        XP=1.D0 /(1.D0 +(W2-XMP2)/(Q2+M12))

        AP=A11+(A11-A12)*(1.D0 /(1.D0 +S**A13)-1.D0 )

        BP=B11**2+B12**2*S**B13

        SP=S11+(S11-S12)*(1.D0 /(1.D0 +S**S13)-1.D0 )

        F2P=SP*XP**AP*Z**BP

C   reggeon part

        XR=1.D0 /(1.D0 +(W2-XMP2)/(Q2+M22))

        AR=A21+A22*S**A23
        BR=B21**2+B22**2*S**B23

        SR=S21+S22*S**S23
        F2R=SR*XR**AR*Z**BR

      ENDIF

*     F2 = (F2P+F2R)*Q2/(Q2+M02)

      CIN=ALFA/(Q2+M02)*(1.D0 +4.D0*XMP2*Q2/(Q2+W2-XMP2)**2)/Z
      PHO_ALLM97 = CIN*(F2P+F2R)

      END



CDECK  ID>, PHO_DOR98LO
      SUBROUTINE PHO_DOR98LO (XINP, Q2INP, UV, DV, US, DS, SS, GL)
C***********************************************************************
C
C   GRV98 parton densities, leading order set
C
C                  For a detailed explanation see
C                   M. Glueck, E. Reya, A. Vogt :
C        hep-ph/9806404  =  DO-TH 98/07  =  WUE-ITP-98-019
C                  (To appear in Eur. Phys. J. C)
C
C   interpolation routine based on the original GRV98PA routine,
C   adapted to define interpolation table as DATA statements
C
C                                                   (R.Engel, 09/98)
C
C
C   INPUT:   X  =  Bjorken-x        (between  1.E-9 and 1.)
C            Q2 =  scale in GeV**2  (between  0.8 and 1.E6)
C
C   OUTPUT:  UV = u - u(bar),  DV = d - d(bar),  US = u(bar),
C            DS = d(bar),  SS = s = s(bar),  GL = gluon.
C            Always x times the distribution is returned.
C
C******************************************************i****************
      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      SAVE

      PARAMETER (NPART=6, NX=68, NQ=27, NARG=2)
      DIMENSION XUVF(NX,NQ), XDVF(NX,NQ), XDEF(NX,NQ), XUDF(NX,NQ),
     1          XSF(NX,NQ), XGF(NX,NQ),
     2          XT(NARG), NA(NARG), ARRF(NX+NQ)

      DIMENSION XUVF_L(NX*NQ), XDVF_L(NX*NQ), XDEF_L(NX*NQ),
     &  XUDF_L(NX*NQ), XSF_L(NX*NQ), XGF_L(NX*NQ)

      EQUIVALENCE (XUVF(1,1),XUVF_L(1))
      EQUIVALENCE (XDVF(1,1),XDVF_L(1))
      EQUIVALENCE (XDEF(1,1),XDEF_L(1))
      EQUIVALENCE (XUDF(1,1),XUDF_L(1))
      EQUIVALENCE (XSF(1,1),XSF_L(1))
      EQUIVALENCE (XGF(1,1),XGF_L(1))

      DATA (ARRF(K),K=    1,   95) /
     &  -2.0723E+01,-2.0135E+01,-1.9560E+01,-1.8983E+01,-1.8421E+01,
     &  -1.7833E+01,-1.7258E+01,-1.6680E+01,-1.6118E+01,-1.5530E+01,
     &  -1.4955E+01,-1.4378E+01,-1.3816E+01,-1.3479E+01,-1.3122E+01,
     &  -1.2717E+01,-1.2311E+01,-1.1913E+01,-1.1513E+01,-1.1176E+01,
     &  -1.0820E+01,-1.0414E+01,-1.0009E+01,-9.6108E+00,-9.2103E+00,
     &  -8.8739E+00,-8.5172E+00,-8.1117E+00,-7.7063E+00,-7.3082E+00,
     &  -6.9078E+00,-6.5713E+00,-6.2146E+00,-5.8091E+00,-5.4037E+00,
     &  -5.0056E+00,-4.6052E+00,-4.2687E+00,-3.9120E+00,-3.5066E+00,
     &  -3.1011E+00,-2.8134E+00,-2.5257E+00,-2.3026E+00,-2.0794E+00,
     &  -1.8971E+00,-1.7430E+00,-1.6094E+00,-1.4917E+00,-1.3863E+00,
     &  -1.2910E+00,-1.2040E+00,-1.1239E+00,-1.0498E+00,-9.8083E-01,
     &  -9.1629E-01,-7.9851E-01,-6.9315E-01,-5.9784E-01,-5.1083E-01,
     &  -4.3078E-01,-3.5667E-01,-2.8768E-01,-2.2314E-01,-1.6252E-01,
     &  -1.0536E-01,-5.1293E-02, 0.0000E+00,-2.2314E-01, 0.0000E+00,
     &   2.6236E-01, 5.8779E-01, 9.9325E-01, 1.3863E+00, 1.8563E+00,
     &   2.3026E+00, 2.7726E+00, 3.2189E+00, 3.6889E+00, 4.1589E+00,
     &   4.6052E+00, 5.1930E+00, 5.7683E+00, 6.3456E+00, 6.9078E+00,
     &   7.4955E+00, 8.0709E+00, 8.6482E+00, 9.2103E+00, 9.9988E+00,
     &   1.0736E+01, 1.1513E+01, 1.2301E+01, 1.3039E+01, 1.3816E+01/
      DATA (XUVF_L(K),K=    1,  114) /
     &2.3186E+00,2.2915E+00,2.2645E+00,2.2385E+00,2.2140E+00,2.1876E+00,
     &2.1623E+00,2.1366E+00,2.1121E+00,2.0862E+00,2.0612E+00,2.0358E+00,
     &2.0110E+00,1.9963E+00,1.9806E+00,1.9624E+00,1.9446E+00,1.9263E+00,
     &1.9072E+00,1.8904E+00,1.8724E+00,1.8515E+00,1.8294E+00,1.8085E+00,
     &1.7865E+00,1.7680E+00,1.7483E+00,1.7249E+00,1.6993E+00,1.6715E+00,
     &1.6385E+00,1.6141E+00,1.5884E+00,1.5597E+00,1.5337E+00,1.5121E+00,
     &1.4985E+00,1.4980E+00,1.5116E+00,1.5555E+00,1.6432E+00,1.7434E+00,
     &1.8861E+00,2.0327E+00,2.2174E+00,2.4015E+00,2.5849E+00,2.7671E+00,
     &2.9488E+00,3.1308E+00,3.3142E+00,3.4998E+00,3.6885E+00,3.8826E+00,
     &4.0815E+00,4.2069E+00,4.5481E+00,4.8830E+00,5.2116E+00,5.5351E+00,
     &5.8553E+00,6.1665E+00,6.4745E+00,6.7767E+00,7.0735E+00,7.3628E+00,
     &7.6283E+00,0.0000E+00,2.3948E+00,2.3665E+00,2.3388E+00,2.3126E+00,
     &2.2860E+00,2.2592E+00,2.2327E+00,2.2065E+00,2.1810E+00,2.1541E+00,
     &2.1284E+00,2.1020E+00,2.0760E+00,2.0605E+00,2.0443E+00,2.0259E+00,
     &2.0068E+00,1.9873E+00,1.9676E+00,1.9500E+00,1.9312E+00,1.9081E+00,
     &1.8860E+00,1.8635E+00,1.8406E+00,1.8221E+00,1.8007E+00,1.7764E+00,
     &1.7489E+00,1.7195E+00,1.6855E+00,1.6600E+00,1.6332E+00,1.6031E+00,
     &1.5760E+00,1.5532E+00,1.5397E+00,1.5376E+00,1.5507E+00,1.5929E+00,
     &1.6784E+00,1.7759E+00,1.9129E+00,2.0531E+00,2.2292E+00,2.4032E+00/
      DATA (XUVF_L(K),K=  115,  228) /
     &2.5752E+00,2.7449E+00,2.9135E+00,3.0810E+00,3.2491E+00,3.4183E+00,
     &3.5898E+00,3.7650E+00,3.9437E+00,4.0443E+00,4.3402E+00,4.6262E+00,
     &4.9009E+00,5.1640E+00,5.4156E+00,5.6530E+00,5.8759E+00,6.0779E+00,
     &6.2540E+00,6.3836E+00,6.4062E+00,0.0000E+00,2.4808E+00,2.4513E+00,
     &2.4236E+00,2.3948E+00,2.3680E+00,2.3397E+00,2.3127E+00,2.2853E+00,
     &2.2585E+00,2.2307E+00,2.2026E+00,2.1762E+00,2.1490E+00,2.1332E+00,
     &2.1164E+00,2.0964E+00,2.0766E+00,2.0565E+00,2.0353E+00,2.0171E+00,
     &1.9969E+00,1.9738E+00,1.9501E+00,1.9258E+00,1.9026E+00,1.8821E+00,
     &1.8594E+00,1.8330E+00,1.8046E+00,1.7734E+00,1.7378E+00,1.7112E+00,
     &1.6829E+00,1.6514E+00,1.6228E+00,1.5994E+00,1.5840E+00,1.5808E+00,
     &1.5927E+00,1.6334E+00,1.7157E+00,1.8093E+00,1.9406E+00,2.0735E+00,
     &2.2394E+00,2.4019E+00,2.5615E+00,2.7178E+00,2.8718E+00,3.0246E+00,
     &3.1766E+00,3.3284E+00,3.4820E+00,3.6370E+00,3.7952E+00,3.8716E+00,
     &4.1225E+00,4.3580E+00,4.5798E+00,4.7847E+00,4.9730E+00,5.1395E+00,
     &5.2832E+00,5.3945E+00,5.4634E+00,5.4612E+00,5.2940E+00,0.0000E+00,
     &2.5823E+00,2.5527E+00,2.5226E+00,2.4928E+00,2.4650E+00,2.4358E+00,
     &2.4071E+00,2.3783E+00,2.3505E+00,2.3212E+00,2.2928E+00,2.2636E+00,
     &2.2360E+00,2.2185E+00,2.2005E+00,2.1801E+00,2.1591E+00,2.1376E+00,
     &2.1153E+00,2.0960E+00,2.0747E+00,2.0505E+00,2.0247E+00,1.9991E+00/
      DATA (XUVF_L(K),K=  229,  342) /
     &1.9746E+00,1.9523E+00,1.9287E+00,1.9000E+00,1.8693E+00,1.8361E+00,
     &1.7994E+00,1.7711E+00,1.7409E+00,1.7076E+00,1.6772E+00,1.6517E+00,
     &1.6345E+00,1.6302E+00,1.6408E+00,1.6789E+00,1.7574E+00,1.8457E+00,
     &1.9692E+00,2.0939E+00,2.2474E+00,2.3969E+00,2.5419E+00,2.6837E+00,
     &2.8216E+00,2.9573E+00,3.0915E+00,3.2246E+00,3.3583E+00,3.4917E+00,
     &3.6273E+00,3.6791E+00,3.8823E+00,4.0673E+00,4.2350E+00,4.3813E+00,
     &4.5072E+00,4.6083E+00,4.6757E+00,4.7055E+00,4.6825E+00,4.5674E+00,
     &4.2566E+00,0.0000E+00,2.7025E+00,2.6705E+00,2.6393E+00,2.6093E+00,
     &2.5790E+00,2.5484E+00,2.5184E+00,2.4880E+00,2.4590E+00,2.4277E+00,
     &2.3971E+00,2.3669E+00,2.3380E+00,2.3200E+00,2.3002E+00,2.2782E+00,
     &2.2557E+00,2.2331E+00,2.2092E+00,2.1887E+00,2.1660E+00,2.1400E+00,
     &2.1126E+00,2.0859E+00,2.0586E+00,2.0351E+00,2.0094E+00,1.9786E+00,
     &1.9453E+00,1.9096E+00,1.8707E+00,1.8406E+00,1.8084E+00,1.7728E+00,
     &1.7392E+00,1.7128E+00,1.6933E+00,1.6875E+00,1.6949E+00,1.7295E+00,
     &1.8023E+00,1.8845E+00,1.9991E+00,2.1134E+00,2.2525E+00,2.3868E+00,
     &2.5160E+00,2.6405E+00,2.7609E+00,2.8781E+00,2.9929E+00,3.1059E+00,
     &3.2180E+00,3.3292E+00,3.4407E+00,3.4675E+00,3.6225E+00,3.7573E+00,
     &3.8710E+00,3.9617E+00,4.0270E+00,4.0642E+00,4.0675E+00,4.0263E+00,
     &3.9240E+00,3.7262E+00,3.3217E+00,0.0000E+00,2.8135E+00,2.7813E+00/
      DATA (XUVF_L(K),K=  343,  456) /
     &2.7489E+00,2.7166E+00,2.6850E+00,2.6527E+00,2.6212E+00,2.5898E+00,
     &2.5592E+00,2.5267E+00,2.4943E+00,2.4636E+00,2.4320E+00,2.4129E+00,
     &2.3929E+00,2.3695E+00,2.3453E+00,2.3211E+00,2.2959E+00,2.2740E+00,
     &2.2496E+00,2.2221E+00,2.1931E+00,2.1653E+00,2.1356E+00,2.1112E+00,
     &2.0830E+00,2.0503E+00,2.0147E+00,1.9766E+00,1.9361E+00,1.9037E+00,
     &1.8696E+00,1.8318E+00,1.7966E+00,1.7677E+00,1.7459E+00,1.7378E+00,
     &1.7430E+00,1.7738E+00,1.8407E+00,1.9169E+00,2.0223E+00,2.1273E+00,
     &2.2537E+00,2.3742E+00,2.4892E+00,2.5990E+00,2.7043E+00,2.8056E+00,
     &2.9038E+00,3.0000E+00,3.0936E+00,3.1864E+00,3.2782E+00,3.2867E+00,
     &3.4021E+00,3.4971E+00,3.5691E+00,3.6188E+00,3.6422E+00,3.6335E+00,
     &3.5908E+00,3.5036E+00,3.3552E+00,3.1085E+00,2.6634E+00,0.0000E+00,
     &2.9406E+00,2.9062E+00,2.8726E+00,2.8385E+00,2.8060E+00,2.7720E+00,
     &2.7392E+00,2.7058E+00,2.6734E+00,2.6399E+00,2.6057E+00,2.5722E+00,
     &2.5390E+00,2.5194E+00,2.4975E+00,2.4728E+00,2.4471E+00,2.4216E+00,
     &2.3945E+00,2.3712E+00,2.3458E+00,2.3152E+00,2.2856E+00,2.2545E+00,
     &2.2237E+00,2.1966E+00,2.1672E+00,2.1312E+00,2.0926E+00,2.0521E+00,
     &2.0093E+00,1.9748E+00,1.9384E+00,1.8975E+00,1.8601E+00,1.8275E+00,
     &1.8036E+00,1.7924E+00,1.7948E+00,1.8206E+00,1.8808E+00,1.9499E+00,
     &2.0450E+00,2.1390E+00,2.2512E+00,2.3570E+00,2.4564E+00,2.5501E+00/
      DATA (XUVF_L(K),K=  457,  570) /
     &2.6391E+00,2.7240E+00,2.8053E+00,2.8834E+00,2.9590E+00,3.0326E+00,
     &3.1042E+00,3.0942E+00,3.1727E+00,3.2289E+00,3.2628E+00,3.2739E+00,
     &3.2574E+00,3.2103E+00,3.1297E+00,3.0047E+00,2.8211E+00,2.5467E+00,
     &2.0897E+00,0.0000E+00,3.0557E+00,3.0193E+00,2.9840E+00,2.9497E+00,
     &2.9150E+00,2.8801E+00,2.8454E+00,2.8109E+00,2.7771E+00,2.7412E+00,
     &2.7065E+00,2.6716E+00,2.6360E+00,2.6149E+00,2.5923E+00,2.5663E+00,
     &2.5395E+00,2.5120E+00,2.4834E+00,2.4589E+00,2.4330E+00,2.4011E+00,
     &2.3676E+00,2.3363E+00,2.3027E+00,2.2736E+00,2.2422E+00,2.2040E+00,
     &2.1629E+00,2.1194E+00,2.0750E+00,2.0384E+00,1.9996E+00,1.9565E+00,
     &1.9160E+00,1.8811E+00,1.8541E+00,1.8409E+00,1.8399E+00,1.8611E+00,
     &1.9143E+00,1.9764E+00,2.0622E+00,2.1459E+00,2.2457E+00,2.3385E+00,
     &2.4249E+00,2.5051E+00,2.5806E+00,2.6515E+00,2.7182E+00,2.7823E+00,
     &2.8427E+00,2.9008E+00,2.9564E+00,2.9332E+00,2.9828E+00,3.0094E+00,
     &3.0142E+00,2.9955E+00,2.9537E+00,2.8796E+00,2.7735E+00,2.6260E+00,
     &2.4242E+00,2.1388E+00,1.6900E+00,0.0000E+00,3.1718E+00,3.1348E+00,
     &3.0971E+00,3.0610E+00,3.0260E+00,2.9896E+00,2.9533E+00,2.9173E+00,
     &2.8818E+00,2.8449E+00,2.8072E+00,2.7709E+00,2.7340E+00,2.7121E+00,
     &2.6877E+00,2.6605E+00,2.6319E+00,2.6032E+00,2.5732E+00,2.5471E+00,
     &2.5180E+00,2.4851E+00,2.4511E+00,2.4170E+00,2.3817E+00,2.3505E+00/
      DATA (XUVF_L(K),K=  571,  684) /
     &2.3172E+00,2.2762E+00,2.2328E+00,2.1868E+00,2.1400E+00,2.1012E+00,
     &2.0601E+00,2.0136E+00,1.9704E+00,1.9335E+00,1.9035E+00,1.8868E+00,
     &1.8827E+00,1.8990E+00,1.9452E+00,2.0005E+00,2.0763E+00,2.1507E+00,
     &2.2377E+00,2.3179E+00,2.3917E+00,2.4592E+00,2.5218E+00,2.5799E+00,
     &2.6336E+00,2.6843E+00,2.7314E+00,2.7753E+00,2.8166E+00,2.7824E+00,
     &2.8054E+00,2.8081E+00,2.7893E+00,2.7474E+00,2.6818E+00,2.5888E+00,
     &2.4646E+00,2.3032E+00,2.0902E+00,1.8025E+00,1.3740E+00,0.0000E+00,
     &3.2793E+00,3.2385E+00,3.2014E+00,3.1643E+00,3.1270E+00,3.0888E+00,
     &3.0517E+00,3.0141E+00,2.9773E+00,2.9392E+00,2.9009E+00,2.8610E+00,
     &2.8230E+00,2.8000E+00,2.7754E+00,2.7459E+00,2.7163E+00,2.6858E+00,
     &2.6545E+00,2.6270E+00,2.5962E+00,2.5617E+00,2.5271E+00,2.4903E+00,
     &2.4527E+00,2.4207E+00,2.3851E+00,2.3421E+00,2.2960E+00,2.2476E+00,
     &2.1987E+00,2.1578E+00,2.1146E+00,2.0670E+00,2.0202E+00,1.9796E+00,
     &1.9468E+00,1.9282E+00,1.9203E+00,1.9319E+00,1.9712E+00,2.0197E+00,
     &2.0872E+00,2.1524E+00,2.2288E+00,2.2981E+00,2.3606E+00,2.4177E+00,
     &2.4692E+00,2.5159E+00,2.5591E+00,2.5981E+00,2.6339E+00,2.6669E+00,
     &2.6962E+00,2.6528E+00,2.6566E+00,2.6395E+00,2.6028E+00,2.5437E+00,
     &2.4622E+00,2.3555E+00,2.2200E+00,2.0488E+00,1.8335E+00,1.5506E+00,
     &1.1442E+00,0.0000E+00,3.3868E+00,3.3470E+00,3.3075E+00,3.2689E+00/
      DATA (XUVF_L(K),K=  685,  798) /
     &3.2300E+00,3.1909E+00,3.1517E+00,3.1129E+00,3.0747E+00,3.0335E+00,
     &2.9946E+00,2.9537E+00,2.9140E+00,2.8896E+00,2.8638E+00,2.8337E+00,
     &2.8021E+00,2.7705E+00,2.7373E+00,2.7075E+00,2.6767E+00,2.6403E+00,
     &2.6031E+00,2.5649E+00,2.5258E+00,2.4917E+00,2.4537E+00,2.4080E+00,
     &2.3597E+00,2.3091E+00,2.2580E+00,2.2150E+00,2.1692E+00,2.1186E+00,
     &2.0701E+00,2.0257E+00,1.9901E+00,1.9679E+00,1.9571E+00,1.9629E+00,
     &1.9955E+00,2.0378E+00,2.0963E+00,2.1529E+00,2.2178E+00,2.2766E+00,
     &2.3287E+00,2.3749E+00,2.4162E+00,2.4529E+00,2.4850E+00,2.5140E+00,
     &2.5392E+00,2.5617E+00,2.5798E+00,2.5298E+00,2.5151E+00,2.4811E+00,
     &2.4282E+00,2.3561E+00,2.2611E+00,2.1439E+00,2.0005E+00,1.8252E+00,
     &1.6091E+00,1.3345E+00,9.5375E-01,0.0000E+00,3.4912E+00,3.4507E+00,
     &3.4100E+00,3.3696E+00,3.3310E+00,3.2893E+00,3.2496E+00,3.2088E+00,
     &3.1686E+00,3.1278E+00,3.0865E+00,3.0438E+00,3.0020E+00,2.9766E+00,
     &2.9494E+00,2.9180E+00,2.8850E+00,2.8520E+00,2.8174E+00,2.7877E+00,
     &2.7550E+00,2.7169E+00,2.6762E+00,2.6369E+00,2.5958E+00,2.5594E+00,
     &2.5195E+00,2.4721E+00,2.4211E+00,2.3680E+00,2.3145E+00,2.2695E+00,
     &2.2214E+00,2.1684E+00,2.1154E+00,2.0706E+00,2.0303E+00,2.0058E+00,
     &1.9909E+00,1.9920E+00,2.0177E+00,2.0531E+00,2.1031E+00,2.1511E+00,
     &2.2060E+00,2.2548E+00,2.2972E+00,2.3339E+00,2.3655E+00,2.3927E+00/
      DATA (XUVF_L(K),K=  799,  912) /
     &2.4159E+00,2.4357E+00,2.4520E+00,2.4644E+00,2.4735E+00,2.4171E+00,
     &2.3878E+00,2.3397E+00,2.2743E+00,2.1907E+00,2.0861E+00,1.9611E+00,
     &1.8128E+00,1.6351E+00,1.4227E+00,1.1584E+00,8.0371E-01,0.0000E+00,
     &3.5892E+00,3.5473E+00,3.5055E+00,3.4637E+00,3.4230E+00,3.3809E+00,
     &3.3396E+00,3.2976E+00,3.2571E+00,3.2126E+00,3.1696E+00,3.1272E+00,
     &3.0840E+00,3.0569E+00,3.0286E+00,2.9959E+00,2.9619E+00,2.9273E+00,
     &2.8910E+00,2.8598E+00,2.8266E+00,2.7863E+00,2.7448E+00,2.7029E+00,
     &2.6598E+00,2.6219E+00,2.5804E+00,2.5305E+00,2.4773E+00,2.4214E+00,
     &2.3662E+00,2.3191E+00,2.2698E+00,2.2126E+00,2.1577E+00,2.1092E+00,
     &2.0674E+00,2.0393E+00,2.0210E+00,2.0173E+00,2.0367E+00,2.0654E+00,
     &2.1076E+00,2.1485E+00,2.1942E+00,2.2338E+00,2.2678E+00,2.2959E+00,
     &2.3193E+00,2.3386E+00,2.3539E+00,2.3660E+00,2.3738E+00,2.3789E+00,
     &2.3799E+00,2.3197E+00,2.2776E+00,2.2186E+00,2.1426E+00,2.0495E+00,
     &1.9397E+00,1.8097E+00,1.6583E+00,1.4814E+00,1.2736E+00,1.0200E+00,
     &6.8880E-01,0.0000E+00,3.7157E+00,3.6699E+00,3.6275E+00,3.5842E+00,
     &3.5420E+00,3.4972E+00,3.4542E+00,3.4107E+00,3.3678E+00,3.3234E+00,
     &3.2774E+00,3.2332E+00,3.1870E+00,3.1600E+00,3.1297E+00,3.0952E+00,
     &3.0595E+00,3.0231E+00,2.9850E+00,2.9534E+00,2.9160E+00,2.8740E+00,
     &2.8312E+00,2.7872E+00,2.7408E+00,2.7014E+00,2.6568E+00,2.6045E+00/
      DATA (XUVF_L(K),K=  913, 1026) /
     &2.5481E+00,2.4895E+00,2.4315E+00,2.3817E+00,2.3283E+00,2.2697E+00,
     &2.2106E+00,2.1591E+00,2.1128E+00,2.0807E+00,2.0578E+00,2.0477E+00,
     &2.0583E+00,2.0796E+00,2.1122E+00,2.1433E+00,2.1777E+00,2.2069E+00,
     &2.2299E+00,2.2483E+00,2.2618E+00,2.2718E+00,2.2778E+00,2.2803E+00,
     &2.2797E+00,2.2749E+00,2.2668E+00,2.2019E+00,2.1468E+00,2.0761E+00,
     &1.9902E+00,1.8883E+00,1.7711E+00,1.6370E+00,1.4847E+00,1.3103E+00,
     &1.1091E+00,8.7047E-01,5.6856E-01,0.0000E+00,3.8327E+00,3.7877E+00,
     &3.7424E+00,3.6981E+00,3.6540E+00,3.6083E+00,3.5637E+00,3.5184E+00,
     &3.4753E+00,3.4271E+00,3.3800E+00,3.3325E+00,3.2860E+00,3.2564E+00,
     &3.2258E+00,3.1893E+00,3.1519E+00,3.1135E+00,3.0738E+00,3.0389E+00,
     &3.0010E+00,2.9580E+00,2.9118E+00,2.8654E+00,2.8178E+00,2.7758E+00,
     &2.7289E+00,2.6738E+00,2.6146E+00,2.5530E+00,2.4924E+00,2.4399E+00,
     &2.3845E+00,2.3213E+00,2.2605E+00,2.2040E+00,2.1540E+00,2.1186E+00,
     &2.0908E+00,2.0749E+00,2.0772E+00,2.0914E+00,2.1145E+00,2.1368E+00,
     &2.1613E+00,2.1804E+00,2.1941E+00,2.2037E+00,2.2088E+00,2.2101E+00,
     &2.2083E+00,2.2031E+00,2.1942E+00,2.1826E+00,2.1665E+00,2.0987E+00,
     &2.0321E+00,1.9516E+00,1.8571E+00,1.7497E+00,1.6281E+00,1.4923E+00,
     &1.3406E+00,1.1697E+00,9.7635E-01,7.5209E-01,4.7638E-01,0.0000E+00,
     &3.9497E+00,3.9009E+00,3.8555E+00,3.8080E+00,3.7630E+00,3.7163E+00/
      DATA (XUVF_L(K),K= 1027, 1140) /
     &3.6699E+00,3.6231E+00,3.5765E+00,3.5285E+00,3.4807E+00,3.4305E+00,
     &3.3810E+00,3.3511E+00,3.3185E+00,3.2805E+00,3.2414E+00,3.2016E+00,
     &3.1598E+00,3.1244E+00,3.0837E+00,3.0383E+00,2.9908E+00,2.9424E+00,
     &2.8919E+00,2.8477E+00,2.7990E+00,2.7403E+00,2.6784E+00,2.6142E+00,
     &2.5507E+00,2.4960E+00,2.4362E+00,2.3710E+00,2.3058E+00,2.2463E+00,
     &2.1931E+00,2.1539E+00,2.1216E+00,2.0996E+00,2.0940E+00,2.1012E+00,
     &2.1154E+00,2.1294E+00,2.1444E+00,2.1543E+00,2.1597E+00,2.1610E+00,
     &2.1585E+00,2.1523E+00,2.1432E+00,2.1307E+00,2.1155E+00,2.0964E+00,
     &2.0742E+00,2.0035E+00,1.9273E+00,1.8396E+00,1.7387E+00,1.6273E+00,
     &1.5032E+00,1.3665E+00,1.2164E+00,1.0501E+00,8.6515E-01,6.5470E-01,
     &4.0284E-01,0.0000E+00,4.0572E+00,4.0093E+00,3.9616E+00,3.9140E+00,
     &3.8670E+00,3.8185E+00,3.7706E+00,3.7224E+00,3.6746E+00,3.6251E+00,
     &3.5744E+00,3.5233E+00,3.4720E+00,3.4406E+00,3.4062E+00,3.3671E+00,
     &3.3263E+00,3.2847E+00,3.2414E+00,3.2046E+00,3.1620E+00,3.1150E+00,
     &3.0653E+00,3.0145E+00,2.9619E+00,2.9153E+00,2.8641E+00,2.8032E+00,
     &2.7388E+00,2.6715E+00,2.6056E+00,2.5481E+00,2.4880E+00,2.4171E+00,
     &2.3496E+00,2.2862E+00,2.2282E+00,2.1865E+00,2.1502E+00,2.1217E+00,
     &2.1086E+00,2.1086E+00,2.1149E+00,2.1216E+00,2.1275E+00,2.1295E+00,
     &2.1273E+00,2.1212E+00,2.1119E+00,2.0992E+00,2.0837E+00,2.0653E+00/
      DATA (XUVF_L(K),K= 1141, 1254) /
     &2.0442E+00,2.0194E+00,1.9912E+00,1.9193E+00,1.8359E+00,1.7412E+00,
     &1.6366E+00,1.5214E+00,1.3956E+00,1.2594E+00,1.1115E+00,9.5033E-01,
     &7.7356E-01,5.7585E-01,3.4506E-01,0.0000E+00,4.1710E+00,4.1201E+00,
     &4.0712E+00,4.0213E+00,3.9730E+00,3.9228E+00,3.8734E+00,3.8233E+00,
     &3.7726E+00,3.7217E+00,3.6699E+00,3.6160E+00,3.5640E+00,3.5311E+00,
     &3.4960E+00,3.4549E+00,3.4121E+00,3.3689E+00,3.3237E+00,3.2848E+00,
     &3.2425E+00,3.1917E+00,3.1399E+00,3.0866E+00,3.0319E+00,2.9838E+00,
     &2.9306E+00,2.8668E+00,2.7992E+00,2.7291E+00,2.6605E+00,2.6007E+00,
     &2.5375E+00,2.4631E+00,2.3919E+00,2.3261E+00,2.2643E+00,2.2183E+00,
     &2.1772E+00,2.1426E+00,2.1222E+00,2.1155E+00,2.1135E+00,2.1130E+00,
     &2.1102E+00,2.1039E+00,2.0941E+00,2.0815E+00,2.0652E+00,2.0466E+00,
     &2.0251E+00,2.0014E+00,1.9746E+00,1.9450E+00,1.9116E+00,1.8381E+00,
     &1.7481E+00,1.6484E+00,1.5404E+00,1.4225E+00,1.2963E+00,1.1611E+00,
     &1.0161E+00,8.6047E-01,6.9193E-01,5.0691E-01,2.9581E-01,0.0000E+00,
     &4.2754E+00,4.2238E+00,4.1737E+00,4.1233E+00,4.0740E+00,4.0219E+00,
     &3.9713E+00,3.9196E+00,3.8675E+00,3.8160E+00,3.7618E+00,3.7060E+00,
     &3.6510E+00,3.6173E+00,3.5808E+00,3.5380E+00,3.4941E+00,3.4493E+00,
     &3.4027E+00,3.3623E+00,3.3163E+00,3.2647E+00,3.2114E+00,3.1563E+00,
     &3.0989E+00,3.0489E+00,2.9929E+00,2.9263E+00,2.8563E+00,2.7837E+00/
      DATA (XUVF_L(K),K= 1255, 1368) /
     &2.7122E+00,2.6501E+00,2.5825E+00,2.5073E+00,2.4327E+00,2.3623E+00,
     &2.2962E+00,2.2474E+00,2.2020E+00,2.1616E+00,2.1335E+00,2.1209E+00,
     &2.1113E+00,2.1034E+00,2.0929E+00,2.0795E+00,2.0634E+00,2.0439E+00,
     &2.0222E+00,1.9982E+00,1.9716E+00,1.9428E+00,1.9113E+00,1.8773E+00,
     &1.8394E+00,1.7649E+00,1.6692E+00,1.5658E+00,1.4547E+00,1.3360E+00,
     &1.2095E+00,1.0761E+00,9.3485E-01,7.8430E-01,6.2380E-01,4.5010E-01,
     &2.5625E-01,0.0000E+00,4.3798E+00,4.3275E+00,4.2762E+00,4.2239E+00,
     &4.1730E+00,4.1196E+00,4.0674E+00,4.0143E+00,3.9623E+00,3.9056E+00,
     &3.8502E+00,3.7935E+00,3.7370E+00,3.7018E+00,3.6642E+00,3.6200E+00,
     &3.5742E+00,3.5277E+00,3.4786E+00,3.4371E+00,3.3901E+00,3.3359E+00,
     &3.2800E+00,3.2235E+00,3.1639E+00,3.1115E+00,3.0537E+00,2.9847E+00,
     &2.9116E+00,2.8364E+00,2.7623E+00,2.6973E+00,2.6275E+00,2.5497E+00,
     &2.4705E+00,2.3972E+00,2.3281E+00,2.2747E+00,2.2253E+00,2.1793E+00,
     &2.1444E+00,2.1253E+00,2.1081E+00,2.0939E+00,2.0755E+00,2.0555E+00,
     &2.0332E+00,2.0081E+00,1.9814E+00,1.9522E+00,1.9205E+00,1.8875E+00,
     &1.8520E+00,1.8139E+00,1.7725E+00,1.6968E+00,1.5976E+00,1.4911E+00,
     &1.3772E+00,1.2577E+00,1.1320E+00,1.0005E+00,8.6242E-01,7.1750E-01,
     &5.6466E-01,4.0150E-01,2.2333E-01,0.0000E+00,4.4809E+00,4.4265E+00,
     &4.3735E+00,4.3193E+00,4.2670E+00,4.2128E+00,4.1585E+00,4.1039E+00/
      DATA (XUVF_L(K),K= 1369, 1482) /
     &4.0509E+00,3.9928E+00,3.9351E+00,3.8769E+00,3.8180E+00,3.7821E+00,
     &3.7434E+00,3.6974E+00,3.6501E+00,3.6019E+00,3.5513E+00,3.5093E+00,
     &3.4594E+00,3.4035E+00,3.3456E+00,3.2870E+00,3.2250E+00,3.1715E+00,
     &3.1110E+00,3.0396E+00,2.9639E+00,2.8863E+00,2.8096E+00,2.7429E+00,
     &2.6702E+00,2.5884E+00,2.5068E+00,2.4296E+00,2.3560E+00,2.3003E+00,
     &2.2464E+00,2.1951E+00,2.1530E+00,2.1283E+00,2.1045E+00,2.0843E+00,
     &2.0591E+00,2.0328E+00,2.0047E+00,1.9749E+00,1.9429E+00,1.9096E+00,
     &1.8740E+00,1.8369E+00,1.7978E+00,1.7560E+00,1.7116E+00,1.6360E+00,
     &1.5322E+00,1.4233E+00,1.3084E+00,1.1885E+00,1.0637E+00,9.3449E-01,
     &7.9961E-01,6.6020E-01,5.1453E-01,3.6103E-01,1.9641E-01,0.0000E+00,
     &4.6169E+00,4.5608E+00,4.5060E+00,4.4504E+00,4.3960E+00,4.3395E+00,
     &4.2837E+00,4.2262E+00,4.1710E+00,4.1106E+00,4.0517E+00,3.9908E+00,
     &3.9300E+00,3.8920E+00,3.8509E+00,3.8030E+00,3.7538E+00,3.7035E+00,
     &3.6494E+00,3.6055E+00,3.5556E+00,3.4966E+00,3.4351E+00,3.3738E+00,
     &3.3090E+00,3.2518E+00,3.1888E+00,3.1141E+00,3.0348E+00,2.9533E+00,
     &2.8730E+00,2.8020E+00,2.7264E+00,2.6400E+00,2.5551E+00,2.4732E+00,
     &2.3941E+00,2.3329E+00,2.2742E+00,2.2147E+00,2.1644E+00,2.1317E+00,
     &2.0986E+00,2.0700E+00,2.0363E+00,2.0021E+00,1.9668E+00,1.9299E+00,
     &1.8922E+00,1.8532E+00,1.8125E+00,1.7704E+00,1.7270E+00,1.6809E+00/
      DATA (XUVF_L(K),K= 1483, 1596) /
     &1.6327E+00,1.5570E+00,1.4497E+00,1.3373E+00,1.2215E+00,1.1020E+00,
     &9.7897E-01,8.5304E-01,7.2349E-01,5.9074E-01,4.5411E-01,3.1307E-01,
     &1.6547E-01,0.0000E+00,4.7403E+00,4.6834E+00,4.6262E+00,4.5696E+00,
     &4.5140E+00,4.4557E+00,4.3978E+00,4.3393E+00,4.2817E+00,4.2191E+00,
     &4.1578E+00,4.0941E+00,4.0310E+00,3.9917E+00,3.9492E+00,3.8995E+00,
     &3.8481E+00,3.7958E+00,3.7411E+00,3.6937E+00,3.6405E+00,3.5806E+00,
     &3.5171E+00,3.4520E+00,3.3840E+00,3.3254E+00,3.2596E+00,3.1812E+00,
     &3.0985E+00,3.0137E+00,2.9301E+00,2.8556E+00,2.7782E+00,2.6879E+00,
     &2.5974E+00,2.5119E+00,2.4281E+00,2.3629E+00,2.2982E+00,2.2324E+00,
     &2.1730E+00,2.1332E+00,2.0922E+00,2.0570E+00,2.0152E+00,1.9739E+00,
     &1.9323E+00,1.8902E+00,1.8474E+00,1.8039E+00,1.7589E+00,1.7129E+00,
     &1.6654E+00,1.6163E+00,1.5652E+00,1.4896E+00,1.3789E+00,1.2649E+00,
     &1.1487E+00,1.0300E+00,9.0896E-01,7.8619E-01,6.6149E-01,5.3498E-01,
     &4.0654E-01,2.7586E-01,1.4208E-01,0.0000E+00,4.8699E+00,4.8107E+00,
     &4.7518E+00,4.6928E+00,4.6350E+00,4.5750E+00,4.5152E+00,4.4524E+00,
     &4.3956E+00,4.3299E+00,4.2674E+00,4.2014E+00,4.1350E+00,4.0939E+00,
     &4.0503E+00,3.9982E+00,3.9448E+00,3.8905E+00,3.8328E+00,3.7846E+00,
     &3.7300E+00,3.6664E+00,3.5991E+00,3.5326E+00,3.4620E+00,3.3998E+00,
     &3.3311E+00,3.2494E+00,3.1632E+00,3.0752E+00,2.9881E+00,2.9120E+00/
      DATA (XUVF_L(K),K= 1597, 1710) /
     &2.8299E+00,2.7339E+00,2.6398E+00,2.5493E+00,2.4611E+00,2.3911E+00,
     &2.3215E+00,2.2482E+00,2.1812E+00,2.1342E+00,2.0854E+00,2.0427E+00,
     &1.9932E+00,1.9453E+00,1.8978E+00,1.8504E+00,1.8030E+00,1.7545E+00,
     &1.7059E+00,1.6565E+00,1.6056E+00,1.5535E+00,1.4989E+00,1.4245E+00,
     &1.3108E+00,1.1959E+00,1.0798E+00,9.6219E-01,8.4358E-01,7.2422E-01,
     &6.0451E-01,4.8425E-01,3.6380E-01,2.4286E-01,1.2189E-01,0.0000E+00,
     &4.9964E+00,4.9356E+00,4.8755E+00,4.8147E+00,4.7550E+00,4.6935E+00,
     &4.6315E+00,4.5697E+00,4.5062E+00,4.4406E+00,4.3752E+00,4.3061E+00,
     &4.2380E+00,4.1962E+00,4.1500E+00,4.0963E+00,4.0405E+00,3.9832E+00,
     &3.9245E+00,3.8728E+00,3.8172E+00,3.7504E+00,3.6811E+00,3.6108E+00,
     &3.5381E+00,3.4734E+00,3.4018E+00,3.3164E+00,3.2269E+00,3.1352E+00,
     &3.0446E+00,2.9657E+00,2.8794E+00,2.7800E+00,2.6821E+00,2.5867E+00,
     &2.4930E+00,2.4184E+00,2.3433E+00,2.2634E+00,2.1877E+00,2.1342E+00,
     &2.0772E+00,2.0279E+00,1.9713E+00,1.9172E+00,1.8642E+00,1.8120E+00,
     &1.7600E+00,1.7076E+00,1.6553E+00,1.6027E+00,1.5491E+00,1.4938E+00,
     &1.4374E+00,1.3637E+00,1.2481E+00,1.1325E+00,1.0166E+00,9.0047E-01,
     &7.8428E-01,6.6889E-01,5.5381E-01,4.3953E-01,3.2652E-01,2.1461E-01,
     &1.0498E-01,0.0000E+00,5.1134E+00,5.0511E+00,4.9886E+00,4.9273E+00,
     &4.8660E+00,4.8016E+00,4.7382E+00,4.6744E+00,4.6106E+00,4.5420E+00/
      DATA (XUVF_L(K),K= 1711, 1824) /
     &4.4742E+00,4.4028E+00,4.3320E+00,4.2892E+00,4.2413E+00,4.1858E+00,
     &4.1281E+00,4.0682E+00,4.0067E+00,3.9556E+00,3.8955E+00,3.8271E+00,
     &3.7556E+00,3.6829E+00,3.6071E+00,3.5401E+00,3.4662E+00,3.3777E+00,
     &3.2849E+00,3.1898E+00,3.0960E+00,3.0140E+00,2.9244E+00,2.8224E+00,
     &2.7183E+00,2.6191E+00,2.5219E+00,2.4431E+00,2.3628E+00,2.2767E+00,
     &2.1931E+00,2.1332E+00,2.0695E+00,2.0145E+00,1.9514E+00,1.8920E+00,
     &1.8340E+00,1.7775E+00,1.7215E+00,1.6664E+00,1.6108E+00,1.5553E+00,
     &1.4995E+00,1.4421E+00,1.3839E+00,1.3103E+00,1.1944E+00,1.0782E+00,
     &9.6271E-01,8.4822E-01,7.3481E-01,6.2240E-01,5.1184E-01,4.0291E-01,
     &2.9618E-01,1.9206E-01,9.1846E-02,0.0000E+00,5.2367E+00,5.1713E+00,
     &5.1071E+00,5.0425E+00,4.9800E+00,4.9141E+00,4.8489E+00,4.7833E+00,
     &4.7181E+00,4.6457E+00,4.5768E+00,4.5034E+00,4.4300E+00,4.3847E+00,
     &4.3353E+00,4.2782E+00,4.2182E+00,4.1570E+00,4.0921E+00,4.0385E+00,
     &3.9782E+00,3.9074E+00,3.8331E+00,3.7575E+00,3.6781E+00,3.6086E+00,
     &3.5313E+00,3.4401E+00,3.3439E+00,3.2455E+00,3.1483E+00,3.0623E+00,
     &2.9694E+00,2.8629E+00,2.7561E+00,2.6527E+00,2.5508E+00,2.4669E+00,
     &2.3816E+00,2.2887E+00,2.1979E+00,2.1317E+00,2.0613E+00,2.0002E+00,
     &1.9307E+00,1.8659E+00,1.8033E+00,1.7426E+00,1.6834E+00,1.6247E+00,
     &1.5668E+00,1.5085E+00,1.4504E+00,1.3916E+00,1.3311E+00,1.2591E+00/
      DATA (XUVF_L(K),K= 1825, 1836) /
     &1.1415E+00,1.0256E+00,9.1107E-01,7.9840E-01,6.8736E-01,5.7902E-01,
     &4.7260E-01,3.6895E-01,2.6838E-01,1.7161E-01,8.0264E-02,0.0000E+00/
      DATA (XDVF_L(K),K=    1,  114) /
     &1.4230E+00,1.4064E+00,1.3903E+00,1.3749E+00,1.3590E+00,1.3424E+00,
     &1.3271E+00,1.3114E+00,1.2962E+00,1.2803E+00,1.2647E+00,1.2492E+00,
     &1.2340E+00,1.2246E+00,1.2155E+00,1.2044E+00,1.1927E+00,1.1814E+00,
     &1.1695E+00,1.1589E+00,1.1479E+00,1.1347E+00,1.1214E+00,1.1080E+00,
     &1.0944E+00,1.0824E+00,1.0700E+00,1.0544E+00,1.0371E+00,1.0188E+00,
     &9.9884E-01,9.8287E-01,9.6563E-01,9.4645E-01,9.2847E-01,9.1313E-01,
     &9.0246E-01,8.9955E-01,9.0461E-01,9.2737E-01,9.7648E-01,1.0343E+00,
     &1.1168E+00,1.2030E+00,1.3129E+00,1.4240E+00,1.5357E+00,1.6492E+00,
     &1.7643E+00,1.8818E+00,2.0016E+00,2.1253E+00,2.2535E+00,2.3853E+00,
     &2.5225E+00,2.5620E+00,2.7906E+00,3.0230E+00,3.2574E+00,3.4983E+00,
     &3.7459E+00,4.0062E+00,4.2803E+00,4.5790E+00,4.9150E+00,5.3263E+00,
     &5.9228E+00,0.0000E+00,1.4698E+00,1.4526E+00,1.4360E+00,1.4199E+00,
     &1.4030E+00,1.3864E+00,1.3702E+00,1.3542E+00,1.3386E+00,1.3221E+00,
     &1.3059E+00,1.2896E+00,1.2740E+00,1.2644E+00,1.2544E+00,1.2425E+00,
     &1.2309E+00,1.2185E+00,1.2061E+00,1.1953E+00,1.1836E+00,1.1697E+00,
     &1.1558E+00,1.1417E+00,1.1275E+00,1.1154E+00,1.1011E+00,1.0844E+00,
     &1.0663E+00,1.0471E+00,1.0261E+00,1.0092E+00,9.9133E-01,9.7103E-01,
     &9.5184E-01,9.3560E-01,9.2380E-01,9.1922E-01,9.2378E-01,9.4563E-01,
     &9.9235E-01,1.0474E+00,1.1262E+00,1.2078E+00,1.3110E+00,1.4146E+00/
      DATA (XDVF_L(K),K=  115,  228) /
     &1.5192E+00,1.6241E+00,1.7298E+00,1.8375E+00,1.9471E+00,2.0592E+00,
     &2.1741E+00,2.2925E+00,2.4144E+00,2.4425E+00,2.6407E+00,2.8375E+00,
     &3.0361E+00,3.2345E+00,3.4343E+00,3.6388E+00,3.8488E+00,4.0682E+00,
     &4.3043E+00,4.5737E+00,4.9280E+00,0.0000E+00,1.5226E+00,1.5047E+00,
     &1.4874E+00,1.4702E+00,1.4530E+00,1.4363E+00,1.4193E+00,1.4023E+00,
     &1.3860E+00,1.3690E+00,1.3520E+00,1.3351E+00,1.3190E+00,1.3083E+00,
     &1.2983E+00,1.2858E+00,1.2733E+00,1.2606E+00,1.2476E+00,1.2362E+00,
     &1.2237E+00,1.2092E+00,1.1943E+00,1.1795E+00,1.1645E+00,1.1509E+00,
     &1.1365E+00,1.1185E+00,1.0994E+00,1.0784E+00,1.0566E+00,1.0388E+00,
     &1.0195E+00,9.9801E-01,9.7765E-01,9.6019E-01,9.4712E-01,9.4158E-01,
     &9.4524E-01,9.6454E-01,1.0088E+00,1.0604E+00,1.1346E+00,1.2112E+00,
     &1.3076E+00,1.4038E+00,1.4995E+00,1.5957E+00,1.6918E+00,1.7888E+00,
     &1.8877E+00,1.9877E+00,2.0896E+00,2.1940E+00,2.2999E+00,2.3168E+00,
     &2.4844E+00,2.6497E+00,2.8098E+00,2.9678E+00,3.1219E+00,3.2743E+00,
     &3.4260E+00,3.5742E+00,3.7237E+00,3.8717E+00,4.0300E+00,0.0000E+00,
     &1.5849E+00,1.5662E+00,1.5482E+00,1.5298E+00,1.5130E+00,1.4944E+00,
     &1.4769E+00,1.4593E+00,1.4423E+00,1.4243E+00,1.4066E+00,1.3894E+00,
     &1.3720E+00,1.3607E+00,1.3499E+00,1.3366E+00,1.3237E+00,1.3101E+00,
     &1.2963E+00,1.2840E+00,1.2709E+00,1.2553E+00,1.2396E+00,1.2232E+00/
      DATA (XDVF_L(K),K=  229,  342) /
     &1.2075E+00,1.1932E+00,1.1776E+00,1.1584E+00,1.1377E+00,1.1152E+00,
     &1.0922E+00,1.0729E+00,1.0524E+00,1.0294E+00,1.0074E+00,9.8843E-01,
     &9.7377E-01,9.6751E-01,9.6901E-01,9.8606E-01,1.0264E+00,1.0745E+00,
     &1.1435E+00,1.2136E+00,1.3018E+00,1.3894E+00,1.4758E+00,1.5619E+00,
     &1.6474E+00,1.7332E+00,1.8194E+00,1.9063E+00,1.9941E+00,2.0832E+00,
     &2.1725E+00,2.1789E+00,2.3166E+00,2.4460E+00,2.5708E+00,2.6884E+00,
     &2.7987E+00,2.9025E+00,2.9974E+00,3.0823E+00,3.1538E+00,3.2013E+00,
     &3.2043E+00,0.0000E+00,1.6586E+00,1.6391E+00,1.6202E+00,1.6014E+00,
     &1.5830E+00,1.5638E+00,1.5457E+00,1.5267E+00,1.5087E+00,1.4899E+00,
     &1.4711E+00,1.4517E+00,1.4340E+00,1.4224E+00,1.4107E+00,1.3972E+00,
     &1.3827E+00,1.3684E+00,1.3535E+00,1.3404E+00,1.3263E+00,1.3096E+00,
     &1.2927E+00,1.2758E+00,1.2575E+00,1.2422E+00,1.2250E+00,1.2046E+00,
     &1.1821E+00,1.1579E+00,1.1331E+00,1.1127E+00,1.0905E+00,1.0655E+00,
     &1.0415E+00,1.0207E+00,1.0042E+00,9.9612E-01,9.9507E-01,1.0089E+00,
     &1.0451E+00,1.0887E+00,1.1514E+00,1.2146E+00,1.2936E+00,1.3711E+00,
     &1.4469E+00,1.5220E+00,1.5960E+00,1.6694E+00,1.7428E+00,1.8159E+00,
     &1.8894E+00,1.9620E+00,2.0344E+00,2.0313E+00,2.1357E+00,2.2333E+00,
     &2.3215E+00,2.4009E+00,2.4706E+00,2.5292E+00,2.5750E+00,2.6036E+00,
     &2.6096E+00,2.5783E+00,2.4673E+00,0.0000E+00,1.7269E+00,1.7065E+00/
      DATA (XDVF_L(K),K=  343,  456) /
     &1.6866E+00,1.6676E+00,1.6480E+00,1.6279E+00,1.6089E+00,1.5891E+00,
     &1.5701E+00,1.5502E+00,1.5307E+00,1.5113E+00,1.4910E+00,1.4799E+00,
     &1.4673E+00,1.4526E+00,1.4373E+00,1.4221E+00,1.4060E+00,1.3922E+00,
     &1.3771E+00,1.3596E+00,1.3414E+00,1.3234E+00,1.3045E+00,1.2879E+00,
     &1.2689E+00,1.2468E+00,1.2227E+00,1.1966E+00,1.1706E+00,1.1487E+00,
     &1.1248E+00,1.0980E+00,1.0724E+00,1.0495E+00,1.0310E+00,1.0212E+00,
     &1.0181E+00,1.0291E+00,1.0609E+00,1.1002E+00,1.1563E+00,1.2136E+00,
     &1.2840E+00,1.3528E+00,1.4201E+00,1.4854E+00,1.5492E+00,1.6125E+00,
     &1.6751E+00,1.7368E+00,1.7981E+00,1.8579E+00,1.9157E+00,1.9057E+00,
     &1.9875E+00,2.0577E+00,2.1190E+00,2.1700E+00,2.2094E+00,2.2370E+00,
     &2.2484E+00,2.2403E+00,2.2047E+00,2.1261E+00,1.9567E+00,0.0000E+00,
     &1.8047E+00,1.7833E+00,1.7626E+00,1.7418E+00,1.7220E+00,1.7009E+00,
     &1.6810E+00,1.6603E+00,1.6403E+00,1.6193E+00,1.5986E+00,1.5775E+00,
     &1.5570E+00,1.5441E+00,1.5309E+00,1.5156E+00,1.4991E+00,1.4828E+00,
     &1.4658E+00,1.4510E+00,1.4350E+00,1.4160E+00,1.3966E+00,1.3772E+00,
     &1.3565E+00,1.3386E+00,1.3184E+00,1.2942E+00,1.2680E+00,1.2404E+00,
     &1.2125E+00,1.1887E+00,1.1631E+00,1.1342E+00,1.1064E+00,1.0813E+00,
     &1.0608E+00,1.0480E+00,1.0426E+00,1.0500E+00,1.0774E+00,1.1111E+00,
     &1.1608E+00,1.2107E+00,1.2719E+00,1.3315E+00,1.3886E+00,1.4445E+00/
      DATA (XDVF_L(K),K=  457,  570) /
     &1.4984E+00,1.5505E+00,1.6020E+00,1.6524E+00,1.7009E+00,1.7480E+00,
     &1.7926E+00,1.7763E+00,1.8327E+00,1.8794E+00,1.9154E+00,1.9405E+00,
     &1.9531E+00,1.9537E+00,1.9362E+00,1.8986E+00,1.8325E+00,1.7203E+00,
     &1.5163E+00,0.0000E+00,1.8755E+00,1.8533E+00,1.8314E+00,1.8106E+00,
     &1.7890E+00,1.7672E+00,1.7464E+00,1.7248E+00,1.7038E+00,1.6817E+00,
     &1.6601E+00,1.6385E+00,1.6160E+00,1.6033E+00,1.5889E+00,1.5721E+00,
     &1.5552E+00,1.5380E+00,1.5199E+00,1.5042E+00,1.4871E+00,1.4670E+00,
     &1.4463E+00,1.4249E+00,1.4036E+00,1.3843E+00,1.3630E+00,1.3364E+00,
     &1.3086E+00,1.2791E+00,1.2500E+00,1.2245E+00,1.1971E+00,1.1662E+00,
     &1.1361E+00,1.1090E+00,1.0858E+00,1.0721E+00,1.0641E+00,1.0676E+00,
     &1.0898E+00,1.1195E+00,1.1627E+00,1.2069E+00,1.2603E+00,1.3118E+00,
     &1.3607E+00,1.4079E+00,1.4534E+00,1.4968E+00,1.5392E+00,1.5794E+00,
     &1.6181E+00,1.6552E+00,1.6888E+00,1.6690E+00,1.7073E+00,1.7353E+00,
     &1.7530E+00,1.7595E+00,1.7531E+00,1.7338E+00,1.6988E+00,1.6428E+00,
     &1.5583E+00,1.4293E+00,1.2136E+00,0.0000E+00,1.9470E+00,1.9238E+00,
     &1.9021E+00,1.8782E+00,1.8570E+00,1.8343E+00,1.8123E+00,1.7898E+00,
     &1.7680E+00,1.7449E+00,1.7222E+00,1.6994E+00,1.6760E+00,1.6624E+00,
     &1.6469E+00,1.6299E+00,1.6118E+00,1.5933E+00,1.5742E+00,1.5574E+00,
     &1.5392E+00,1.5179E+00,1.4955E+00,1.4738E+00,1.4506E+00,1.4300E+00/
      DATA (XDVF_L(K),K=  571,  684) /
     &1.4069E+00,1.3792E+00,1.3492E+00,1.3178E+00,1.2868E+00,1.2597E+00,
     &1.2307E+00,1.1976E+00,1.1654E+00,1.1363E+00,1.1108E+00,1.0945E+00,
     &1.0840E+00,1.0845E+00,1.1017E+00,1.1268E+00,1.1637E+00,1.2016E+00,
     &1.2473E+00,1.2910E+00,1.3324E+00,1.3719E+00,1.4090E+00,1.4450E+00,
     &1.4784E+00,1.5109E+00,1.5404E+00,1.5681E+00,1.5925E+00,1.5689E+00,
     &1.5916E+00,1.6043E+00,1.6067E+00,1.5981E+00,1.5779E+00,1.5449E+00,
     &1.4949E+00,1.4262E+00,1.3303E+00,1.1932E+00,9.7657E-01,0.0000E+00,
     &2.0122E+00,1.9881E+00,1.9640E+00,1.9418E+00,1.9190E+00,1.8954E+00,
     &1.8721E+00,1.8492E+00,1.8262E+00,1.8024E+00,1.7784E+00,1.7550E+00,
     &1.7300E+00,1.7157E+00,1.6999E+00,1.6818E+00,1.6627E+00,1.6435E+00,
     &1.6233E+00,1.6058E+00,1.5866E+00,1.5643E+00,1.5417E+00,1.5178E+00,
     &1.4926E+00,1.4705E+00,1.4465E+00,1.4174E+00,1.3856E+00,1.3527E+00,
     &1.3198E+00,1.2914E+00,1.2605E+00,1.2257E+00,1.1915E+00,1.1601E+00,
     &1.1326E+00,1.1142E+00,1.1016E+00,1.0982E+00,1.1114E+00,1.1321E+00,
     &1.1637E+00,1.1958E+00,1.2352E+00,1.2722E+00,1.3071E+00,1.3397E+00,
     &1.3704E+00,1.3995E+00,1.4267E+00,1.4516E+00,1.4736E+00,1.4942E+00,
     &1.5100E+00,1.4848E+00,1.4955E+00,1.4964E+00,1.4873E+00,1.4675E+00,
     &1.4366E+00,1.3933E+00,1.3349E+00,1.2585E+00,1.1565E+00,1.0171E+00,
     &8.0601E-01,0.0000E+00,2.0789E+00,2.0539E+00,2.0294E+00,2.0053E+00/
      DATA (XDVF_L(K),K=  685,  798) /
     &1.9820E+00,1.9581E+00,1.9336E+00,1.9096E+00,1.8860E+00,1.8609E+00,
     &1.8367E+00,1.8106E+00,1.7860E+00,1.7706E+00,1.7543E+00,1.7350E+00,
     &1.7150E+00,1.6945E+00,1.6735E+00,1.6550E+00,1.6349E+00,1.6112E+00,
     &1.5864E+00,1.5617E+00,1.5356E+00,1.5128E+00,1.4868E+00,1.4555E+00,
     &1.4224E+00,1.3876E+00,1.3532E+00,1.3231E+00,1.2904E+00,1.2536E+00,
     &1.2173E+00,1.1838E+00,1.1545E+00,1.1338E+00,1.1185E+00,1.1113E+00,
     &1.1199E+00,1.1362E+00,1.1627E+00,1.1895E+00,1.2222E+00,1.2529E+00,
     &1.2813E+00,1.3080E+00,1.3324E+00,1.3546E+00,1.3756E+00,1.3938E+00,
     &1.4103E+00,1.4232E+00,1.4319E+00,1.4055E+00,1.4052E+00,1.3959E+00,
     &1.3768E+00,1.3480E+00,1.3084E+00,1.2576E+00,1.1928E+00,1.1110E+00,
     &1.0066E+00,8.6804E-01,6.6615E-01,0.0000E+00,2.1434E+00,2.1178E+00,
     &2.0930E+00,2.0676E+00,2.0440E+00,2.0184E+00,1.9935E+00,1.9686E+00,
     &1.9439E+00,1.9179E+00,1.8915E+00,1.8663E+00,1.8400E+00,1.8239E+00,
     &1.8067E+00,1.7863E+00,1.7654E+00,1.7440E+00,1.7219E+00,1.7025E+00,
     &1.6814E+00,1.6565E+00,1.6311E+00,1.6045E+00,1.5766E+00,1.5526E+00,
     &1.5250E+00,1.4925E+00,1.4574E+00,1.4213E+00,1.3849E+00,1.3532E+00,
     &1.3191E+00,1.2800E+00,1.2418E+00,1.2062E+00,1.1743E+00,1.1517E+00,
     &1.1338E+00,1.1237E+00,1.1272E+00,1.1399E+00,1.1608E+00,1.1828E+00,
     &1.2092E+00,1.2341E+00,1.2570E+00,1.2774E+00,1.2962E+00,1.3135E+00/
      DATA (XDVF_L(K),K=  799,  912) /
     &1.3280E+00,1.3406E+00,1.3511E+00,1.3588E+00,1.3613E+00,1.3335E+00,
     &1.3246E+00,1.3067E+00,1.2801E+00,1.2441E+00,1.1985E+00,1.1418E+00,
     &1.0724E+00,9.8806E-01,8.8293E-01,7.4746E-01,5.5665E-01,0.0000E+00,
     &2.2035E+00,2.1769E+00,2.1514E+00,2.1259E+00,2.1000E+00,2.0743E+00,
     &2.0488E+00,2.0226E+00,1.9973E+00,1.9702E+00,1.9428E+00,1.9166E+00,
     &1.8890E+00,1.8729E+00,1.8548E+00,1.8337E+00,1.8116E+00,1.7895E+00,
     &1.7662E+00,1.7461E+00,1.7239E+00,1.6980E+00,1.6714E+00,1.6436E+00,
     &1.6146E+00,1.5889E+00,1.5604E+00,1.5266E+00,1.4895E+00,1.4515E+00,
     &1.4138E+00,1.3806E+00,1.3448E+00,1.3040E+00,1.2638E+00,1.2261E+00,
     &1.1920E+00,1.1669E+00,1.1469E+00,1.1341E+00,1.1335E+00,1.1420E+00,
     &1.1583E+00,1.1760E+00,1.1971E+00,1.2168E+00,1.2343E+00,1.2501E+00,
     &1.2640E+00,1.2762E+00,1.2866E+00,1.2942E+00,1.2996E+00,1.3020E+00,
     &1.3003E+00,1.2725E+00,1.2557E+00,1.2312E+00,1.1982E+00,1.1569E+00,
     &1.1068E+00,1.0465E+00,9.7460E-01,8.8884E-01,7.8459E-01,6.5333E-01,
     &4.7359E-01,0.0000E+00,2.2800E+00,2.2524E+00,2.2256E+00,2.1987E+00,
     &2.1730E+00,2.1459E+00,2.1192E+00,2.0922E+00,2.0656E+00,2.0374E+00,
     &2.0100E+00,1.9802E+00,1.9520E+00,1.9346E+00,1.9156E+00,1.8937E+00,
     &1.8706E+00,1.8475E+00,1.8228E+00,1.8017E+00,1.7783E+00,1.7509E+00,
     &1.7221E+00,1.6937E+00,1.6627E+00,1.6354E+00,1.6050E+00,1.5688E+00/
      DATA (XDVF_L(K),K=  913, 1026) /
     &1.5301E+00,1.4898E+00,1.4503E+00,1.4150E+00,1.3772E+00,1.3339E+00,
     &1.2911E+00,1.2510E+00,1.2138E+00,1.1866E+00,1.1637E+00,1.1458E+00,
     &1.1403E+00,1.1441E+00,1.1548E+00,1.1669E+00,1.1817E+00,1.1950E+00,
     &1.2065E+00,1.2163E+00,1.2249E+00,1.2313E+00,1.2355E+00,1.2379E+00,
     &1.2379E+00,1.2348E+00,1.2275E+00,1.1987E+00,1.1744E+00,1.1427E+00,
     &1.1035E+00,1.0570E+00,1.0018E+00,9.3862E-01,8.6494E-01,7.7913E-01,
     &6.7747E-01,5.5266E-01,3.8741E-01,0.0000E+00,2.3524E+00,2.3243E+00,
     &2.2963E+00,2.2689E+00,2.2420E+00,2.2137E+00,2.1858E+00,2.1579E+00,
     &2.1301E+00,2.1011E+00,2.0718E+00,2.0424E+00,2.0120E+00,1.9937E+00,
     &1.9743E+00,1.9509E+00,1.9267E+00,1.9020E+00,1.8763E+00,1.8541E+00,
     &1.8295E+00,1.8006E+00,1.7713E+00,1.7402E+00,1.7077E+00,1.6794E+00,
     &1.6475E+00,1.6087E+00,1.5679E+00,1.5259E+00,1.4840E+00,1.4470E+00,
     &1.4072E+00,1.3615E+00,1.3163E+00,1.2738E+00,1.2336E+00,1.2045E+00,
     &1.1783E+00,1.1563E+00,1.1459E+00,1.1457E+00,1.1504E+00,1.1577E+00,
     &1.1662E+00,1.1742E+00,1.1807E+00,1.1857E+00,1.1886E+00,1.1902E+00,
     &1.1899E+00,1.1878E+00,1.1830E+00,1.1751E+00,1.1633E+00,1.1345E+00,
     &1.1039E+00,1.0667E+00,1.0230E+00,9.7228E-01,9.1417E-01,8.4905E-01,
     &7.7478E-01,6.9004E-01,5.9155E-01,4.7371E-01,3.2191E-01,0.0000E+00,
     &2.4233E+00,2.3947E+00,2.3653E+00,2.3365E+00,2.3090E+00,2.2800E+00/
      DATA (XDVF_L(K),K= 1027, 1140) /
     &2.2512E+00,2.2220E+00,2.1934E+00,2.1628E+00,2.1319E+00,2.1007E+00,
     &2.0700E+00,2.0512E+00,2.0301E+00,2.0057E+00,1.9809E+00,1.9549E+00,
     &1.9281E+00,1.9049E+00,1.8791E+00,1.8497E+00,1.8175E+00,1.7854E+00,
     &1.7507E+00,1.7209E+00,1.6878E+00,1.6474E+00,1.6047E+00,1.5603E+00,
     &1.5164E+00,1.4777E+00,1.4358E+00,1.3879E+00,1.3403E+00,1.2952E+00,
     &1.2523E+00,1.2206E+00,1.1913E+00,1.1661E+00,1.1505E+00,1.1462E+00,
     &1.1460E+00,1.1481E+00,1.1518E+00,1.1545E+00,1.1559E+00,1.1562E+00,
     &1.1548E+00,1.1523E+00,1.1478E+00,1.1414E+00,1.1331E+00,1.1212E+00,
     &1.1055E+00,1.0763E+00,1.0405E+00,9.9877E-01,9.5130E-01,8.9815E-01,
     &8.3813E-01,7.7188E-01,6.9792E-01,6.1492E-01,5.2020E-01,4.0920E-01,
     &2.7020E-01,0.0000E+00,2.4906E+00,2.4607E+00,2.4307E+00,2.4014E+00,
     &2.3730E+00,2.3427E+00,2.3127E+00,2.2828E+00,2.2528E+00,2.2213E+00,
     &2.1903E+00,2.1577E+00,2.1250E+00,2.1053E+00,2.0839E+00,2.0583E+00,
     &2.0318E+00,2.0051E+00,1.9771E+00,1.9527E+00,1.9259E+00,1.8935E+00,
     &1.8607E+00,1.8269E+00,1.7917E+00,1.7606E+00,1.7253E+00,1.6833E+00,
     &1.6387E+00,1.5925E+00,1.5465E+00,1.5061E+00,1.4624E+00,1.4121E+00,
     &1.3623E+00,1.3152E+00,1.2700E+00,1.2349E+00,1.2036E+00,1.1745E+00,
     &1.1544E+00,1.1457E+00,1.1410E+00,1.1389E+00,1.1378E+00,1.1357E+00,
     &1.1332E+00,1.1290E+00,1.1244E+00,1.1176E+00,1.1099E+00,1.0996E+00/
      DATA (XDVF_L(K),K= 1141, 1254) /
     &1.0875E+00,1.0729E+00,1.0538E+00,1.0249E+00,9.8511E-01,9.3994E-01,
     &8.8948E-01,8.3410E-01,7.7332E-01,7.0681E-01,6.3377E-01,5.5280E-01,
     &4.6214E-01,3.5755E-01,2.2965E-01,0.0000E+00,2.5589E+00,2.5291E+00,
     &2.4979E+00,2.4676E+00,2.4370E+00,2.4060E+00,2.3753E+00,2.3443E+00,
     &2.3135E+00,2.2809E+00,2.2486E+00,2.2146E+00,2.1810E+00,2.1602E+00,
     &2.1376E+00,2.1114E+00,2.0841E+00,2.0557E+00,2.0265E+00,2.0011E+00,
     &1.9730E+00,1.9392E+00,1.9055E+00,1.8697E+00,1.8327E+00,1.8003E+00,
     &1.7635E+00,1.7197E+00,1.6727E+00,1.6246E+00,1.5770E+00,1.5346E+00,
     &1.4890E+00,1.4363E+00,1.3841E+00,1.3341E+00,1.2867E+00,1.2492E+00,
     &1.2151E+00,1.1824E+00,1.1578E+00,1.1451E+00,1.1356E+00,1.1298E+00,
     &1.1233E+00,1.1169E+00,1.1105E+00,1.1027E+00,1.0940E+00,1.0840E+00,
     &1.0726E+00,1.0592E+00,1.0444E+00,1.0265E+00,1.0045E+00,9.7613E-01,
     &9.3249E-01,8.8451E-01,8.3193E-01,7.7510E-01,7.1373E-01,6.4749E-01,
     &5.7554E-01,4.9725E-01,4.1072E-01,3.1254E-01,1.9551E-01,0.0000E+00,
     &2.6244E+00,2.5927E+00,2.5615E+00,2.5299E+00,2.4990E+00,2.4671E+00,
     &2.4356E+00,2.4034E+00,2.3717E+00,2.3377E+00,2.3034E+00,2.2689E+00,
     &2.2340E+00,2.2126E+00,2.1892E+00,2.1616E+00,2.1331E+00,2.1040E+00,
     &2.0736E+00,2.0471E+00,2.0180E+00,1.9830E+00,1.9472E+00,1.9112E+00,
     &1.8717E+00,1.8375E+00,1.7996E+00,1.7538E+00,1.7053E+00,1.6548E+00/
      DATA (XDVF_L(K),K= 1255, 1368) /
     &1.6053E+00,1.5612E+00,1.5138E+00,1.4590E+00,1.4045E+00,1.3516E+00,
     &1.3023E+00,1.2626E+00,1.2251E+00,1.1889E+00,1.1601E+00,1.1441E+00,
     &1.1302E+00,1.1201E+00,1.1098E+00,1.0996E+00,1.0888E+00,1.0782E+00,
     &1.0659E+00,1.0531E+00,1.0388E+00,1.0228E+00,1.0047E+00,9.8480E-01,
     &9.6040E-01,9.3234E-01,8.8589E-01,8.3563E-01,7.8162E-01,7.2366E-01,
     &6.6215E-01,5.9658E-01,5.2617E-01,4.5043E-01,3.6787E-01,2.7575E-01,
     &1.6826E-01,0.0000E+00,2.6886E+00,2.6564E+00,2.6234E+00,2.5908E+00,
     &2.5600E+00,2.5268E+00,2.4943E+00,2.4612E+00,2.4283E+00,2.3924E+00,
     &2.3582E+00,2.3219E+00,2.2860E+00,2.2642E+00,2.2394E+00,2.2113E+00,
     &2.1817E+00,2.1512E+00,2.1198E+00,2.0920E+00,2.0618E+00,2.0268E+00,
     &1.9890E+00,1.9503E+00,1.9098E+00,1.8739E+00,1.8343E+00,1.7867E+00,
     &1.7365E+00,1.6843E+00,1.6329E+00,1.5870E+00,1.5377E+00,1.4807E+00,
     &1.4239E+00,1.3692E+00,1.3169E+00,1.2751E+00,1.2350E+00,1.1954E+00,
     &1.1624E+00,1.1425E+00,1.1247E+00,1.1110E+00,1.0963E+00,1.0827E+00,
     &1.0687E+00,1.0547E+00,1.0396E+00,1.0240E+00,1.0070E+00,9.8853E-01,
     &9.6834E-01,9.4569E-01,9.1962E-01,8.9220E-01,8.4321E-01,7.9105E-01,
     &7.3592E-01,6.7777E-01,6.1620E-01,5.5143E-01,4.8272E-01,4.0962E-01,
     &3.3102E-01,2.4455E-01,1.4574E-01,0.0000E+00,2.7496E+00,2.7153E+00,
     &2.6835E+00,2.6504E+00,2.6180E+00,2.5834E+00,2.5502E+00,2.5161E+00/
      DATA (XDVF_L(K),K= 1369, 1482) /
     &2.4824E+00,2.4466E+00,2.4095E+00,2.3736E+00,2.3360E+00,2.3124E+00,
     &2.2875E+00,2.2580E+00,2.2274E+00,2.1960E+00,2.1631E+00,2.1347E+00,
     &2.1032E+00,2.0670E+00,2.0277E+00,1.9882E+00,1.9458E+00,1.9086E+00,
     &1.8675E+00,1.8179E+00,1.7658E+00,1.7122E+00,1.6586E+00,1.6112E+00,
     &1.5600E+00,1.5010E+00,1.4420E+00,1.3855E+00,1.3294E+00,1.2858E+00,
     &1.2435E+00,1.2006E+00,1.1641E+00,1.1410E+00,1.1193E+00,1.1023E+00,
     &1.0837E+00,1.0664E+00,1.0496E+00,1.0329E+00,1.0157E+00,9.9745E-01,
     &9.7803E-01,9.5735E-01,9.3539E-01,9.1075E-01,8.8302E-01,8.5608E-01,
     &8.0509E-01,7.5168E-01,6.9580E-01,6.3743E-01,5.7619E-01,5.1233E-01,
     &4.4547E-01,3.7496E-01,2.9995E-01,2.1862E-01,1.2745E-01,0.0000E+00,
     &2.8331E+00,2.7978E+00,2.7648E+00,2.7299E+00,2.6960E+00,2.6609E+00,
     &2.6263E+00,2.5910E+00,2.5561E+00,2.5197E+00,2.4802E+00,2.4424E+00,
     &2.4030E+00,2.3791E+00,2.3526E+00,2.3216E+00,2.2897E+00,2.2570E+00,
     &2.2225E+00,2.1925E+00,2.1595E+00,2.1199E+00,2.0799E+00,2.0383E+00,
     &1.9938E+00,1.9551E+00,1.9121E+00,1.8601E+00,1.8054E+00,1.7494E+00,
     &1.6932E+00,1.6435E+00,1.5898E+00,1.5280E+00,1.4659E+00,1.4056E+00,
     &1.3471E+00,1.3010E+00,1.2550E+00,1.2078E+00,1.1652E+00,1.1383E+00,
     &1.1114E+00,1.0902E+00,1.0668E+00,1.0451E+00,1.0248E+00,1.0039E+00,
     &9.8353E-01,9.6205E-01,9.4076E-01,9.1705E-01,8.9229E-01,8.6577E-01/
      DATA (XDVF_L(K),K= 1483, 1596) /
     &8.3604E-01,8.0985E-01,7.5687E-01,7.0190E-01,6.4516E-01,5.8700E-01,
     &5.2660E-01,4.6452E-01,3.9995E-01,3.3310E-01,2.6289E-01,1.8826E-01,
     &1.0655E-01,0.0000E+00,2.9096E+00,2.8732E+00,2.8390E+00,2.8027E+00,
     &2.7690E+00,2.7325E+00,2.6961E+00,2.6597E+00,2.6231E+00,2.5833E+00,
     &2.5456E+00,2.5047E+00,2.4650E+00,2.4391E+00,2.4120E+00,2.3799E+00,
     &2.3462E+00,2.3123E+00,2.2763E+00,2.2451E+00,2.2108E+00,2.1692E+00,
     &2.1276E+00,2.0835E+00,2.0378E+00,1.9974E+00,1.9525E+00,1.8983E+00,
     &1.8413E+00,1.7827E+00,1.7243E+00,1.6725E+00,1.6166E+00,1.5520E+00,
     &1.4872E+00,1.4244E+00,1.3627E+00,1.3136E+00,1.2649E+00,1.2130E+00,
     &1.1663E+00,1.1352E+00,1.1040E+00,1.0787E+00,1.0514E+00,1.0264E+00,
     &1.0021E+00,9.7883E-01,9.5548E-01,9.3171E-01,9.0763E-01,8.8283E-01,
     &8.5596E-01,8.2732E-01,7.9601E-01,7.7056E-01,7.1598E-01,6.6027E-01,
     &6.0340E-01,5.4514E-01,4.8601E-01,4.2556E-01,3.6359E-01,2.9984E-01,
     &2.3396E-01,1.6486E-01,9.0844E-02,0.0000E+00,2.9880E+00,2.9510E+00,
     &2.9150E+00,2.8782E+00,2.8430E+00,2.8048E+00,2.7677E+00,2.7301E+00,
     &2.6924E+00,2.6517E+00,2.6110E+00,2.5696E+00,2.5280E+00,2.5017E+00,
     &2.4728E+00,2.4393E+00,2.4042E+00,2.3687E+00,2.3313E+00,2.2988E+00,
     &2.2631E+00,2.2204E+00,2.1768E+00,2.1312E+00,2.0828E+00,2.0405E+00,
     &1.9928E+00,1.9364E+00,1.8772E+00,1.8164E+00,1.7558E+00,1.7018E+00/
      DATA (XDVF_L(K),K= 1597, 1710) /
     &1.6434E+00,1.5762E+00,1.5084E+00,1.4432E+00,1.3783E+00,1.3261E+00,
     &1.2741E+00,1.2182E+00,1.1669E+00,1.1315E+00,1.0961E+00,1.0671E+00,
     &1.0360E+00,1.0071E+00,9.7992E-01,9.5371E-01,9.2801E-01,9.0200E-01,
     &8.7588E-01,8.4862E-01,8.2038E-01,7.9020E-01,7.5770E-01,7.3298E-01,
     &6.7721E-01,6.2090E-01,5.6394E-01,5.0631E-01,4.4841E-01,3.8970E-01,
     &3.3019E-01,2.6973E-01,2.0791E-01,1.4420E-01,7.7416E-02,0.0000E+00,
     &3.0661E+00,3.0288E+00,2.9911E+00,2.9537E+00,2.9160E+00,2.8778E+00,
     &2.8392E+00,2.8000E+00,2.7610E+00,2.7200E+00,2.6782E+00,2.6345E+00,
     &2.5900E+00,2.5625E+00,2.5329E+00,2.4982E+00,2.4617E+00,2.4247E+00,
     &2.3857E+00,2.3518E+00,2.3145E+00,2.2697E+00,2.2245E+00,2.1764E+00,
     &2.1269E+00,2.0819E+00,2.0331E+00,1.9746E+00,1.9126E+00,1.8497E+00,
     &1.7862E+00,1.7303E+00,1.6696E+00,1.5995E+00,1.5285E+00,1.4608E+00,
     &1.3929E+00,1.3377E+00,1.2826E+00,1.2228E+00,1.1669E+00,1.1279E+00,
     &1.0882E+00,1.0555E+00,1.0205E+00,9.8876E-01,9.5876E-01,9.2969E-01,
     &9.0171E-01,8.7356E-01,8.4551E-01,8.1668E-01,7.8701E-01,7.5564E-01,
     &7.2196E-01,6.9797E-01,6.4121E-01,5.8469E-01,5.2810E-01,4.7131E-01,
     &4.1460E-01,3.5783E-01,3.0063E-01,2.4338E-01,1.8544E-01,1.2660E-01,
     &6.6270E-02,0.0000E+00,3.1379E+00,3.0995E+00,3.0600E+00,3.0213E+00,
     &2.9840E+00,2.9442E+00,2.9047E+00,2.8641E+00,2.8239E+00,2.7813E+00/
      DATA (XDVF_L(K),K= 1711, 1824) /
     &2.7383E+00,2.6928E+00,2.6470E+00,2.6191E+00,2.5880E+00,2.5519E+00,
     &2.5145E+00,2.4761E+00,2.4357E+00,2.4004E+00,2.3615E+00,2.3153E+00,
     &2.2678E+00,2.2180E+00,2.1669E+00,2.1208E+00,2.0699E+00,2.0087E+00,
     &1.9447E+00,1.8795E+00,1.8139E+00,1.7558E+00,1.6930E+00,1.6205E+00,
     &1.5467E+00,1.4759E+00,1.4054E+00,1.3484E+00,1.2895E+00,1.2267E+00,
     &1.1663E+00,1.1242E+00,1.0808E+00,1.0449E+00,1.0065E+00,9.7194E-01,
     &9.3967E-01,9.0840E-01,8.7834E-01,8.4891E-01,8.1928E-01,7.8930E-01,
     &7.5803E-01,7.2562E-01,6.9124E-01,6.6796E-01,6.1058E-01,5.5392E-01,
     &4.9752E-01,4.4176E-01,3.8633E-01,3.3127E-01,2.7648E-01,2.2186E-01,
     &1.6735E-01,1.1268E-01,5.7652E-02,0.0000E+00,3.2129E+00,3.1726E+00,
     &3.1325E+00,3.0928E+00,3.0540E+00,3.0127E+00,2.9717E+00,2.9303E+00,
     &2.8887E+00,2.8449E+00,2.8001E+00,2.7537E+00,2.7060E+00,2.6766E+00,
     &2.6453E+00,2.6073E+00,2.5683E+00,2.5286E+00,2.4866E+00,2.4501E+00,
     &2.4107E+00,2.3628E+00,2.3125E+00,2.2620E+00,2.2079E+00,2.1597E+00,
     &2.1067E+00,2.0440E+00,1.9778E+00,1.9097E+00,1.8421E+00,1.7819E+00,
     &1.7169E+00,1.6416E+00,1.5664E+00,1.4922E+00,1.4189E+00,1.3583E+00,
     &1.2971E+00,1.2300E+00,1.1652E+00,1.1200E+00,1.0729E+00,1.0343E+00,
     &9.9254E-01,9.5513E-01,9.2006E-01,8.8711E-01,8.5555E-01,8.2426E-01,
     &7.9305E-01,7.6193E-01,7.2963E-01,6.9636E-01,6.6128E-01,6.3868E-01/
      DATA (XDVF_L(K),K= 1825, 1836) /
     &5.8093E-01,5.2428E-01,4.6858E-01,4.1372E-01,3.5972E-01,3.0648E-01,
     &2.5392E-01,2.0208E-01,1.5083E-01,1.0018E-01,5.0068E-02,0.0000E+00/
      DATA (XDEF_L(K),K=    1,  114) /
     &4.3007E-01,4.2474E-01,4.1967E-01,4.1458E-01,4.0970E-01,4.0443E-01,
     &3.9925E-01,3.9397E-01,3.8864E-01,3.8302E-01,3.7707E-01,3.7100E-01,
     &3.6470E-01,3.6080E-01,3.5639E-01,3.5109E-01,3.4531E-01,3.3914E-01,
     &3.3238E-01,3.2609E-01,3.1913E-01,3.1062E-01,3.0152E-01,2.9176E-01,
     &2.8100E-01,2.7114E-01,2.5952E-01,2.4467E-01,2.2784E-01,2.0937E-01,
     &1.9117E-01,1.7470E-01,1.5685E-01,1.3678E-01,1.1825E-01,1.0349E-01,
     &9.4854E-02,9.5054E-02,1.0589E-01,1.3527E-01,1.8584E-01,2.3426E-01,
     &2.9021E-01,3.3527E-01,3.7670E-01,4.0255E-01,4.1326E-01,4.0880E-01,
     &3.8831E-01,3.5045E-01,2.9287E-01,2.1298E-01,1.0773E-01,0.0000E+00,
     &0.0000E+00,2.0644E-01,1.5422E-01,1.0950E-01,7.3614E-02,4.6726E-02,
     &2.7433E-02,1.4144E-02,6.5080E-03,2.4719E-03,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,4.4398E-01,4.3864E-01,4.3346E-01,4.2809E-01,
     &4.2290E-01,4.1747E-01,4.1205E-01,4.0650E-01,4.0098E-01,3.9480E-01,
     &3.8873E-01,3.8226E-01,3.7560E-01,3.7145E-01,3.6678E-01,3.6108E-01,
     &3.5488E-01,3.4833E-01,3.4123E-01,3.3464E-01,3.2718E-01,3.1811E-01,
     &3.0838E-01,2.9811E-01,2.8670E-01,2.7630E-01,2.6412E-01,2.4861E-01,
     &2.3110E-01,2.1209E-01,1.9355E-01,1.7681E-01,1.5878E-01,1.3870E-01,
     &1.2044E-01,1.0620E-01,9.8341E-02,9.9345E-02,1.1086E-01,1.4055E-01,
     &1.9033E-01,2.3696E-01,2.8983E-01,3.3137E-01,3.6834E-01,3.8982E-01/
      DATA (XDEF_L(K),K=  115,  228) /
     &3.9672E-01,3.8896E-01,3.6609E-01,3.2678E-01,2.6933E-01,1.9181E-01,
     &9.1683E-02,0.0000E+00,0.0000E+00,1.8955E-01,1.4041E-01,9.8873E-02,
     &6.5928E-02,4.1462E-02,2.3905E-02,1.2324E-02,5.6113E-03,2.1050E-03,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,4.5980E-01,4.5420E-01,
     &4.4884E-01,4.4319E-01,4.3780E-01,4.3208E-01,4.2642E-01,4.2053E-01,
     &4.1457E-01,4.0824E-01,4.0181E-01,3.9484E-01,3.8780E-01,3.8328E-01,
     &3.7831E-01,3.7223E-01,3.6559E-01,3.5853E-01,3.5072E-01,3.4400E-01,
     &3.3590E-01,3.2633E-01,3.1598E-01,3.0508E-01,2.9301E-01,2.8197E-01,
     &2.6915E-01,2.5289E-01,2.3470E-01,2.1511E-01,1.9623E-01,1.7918E-01,
     &1.6098E-01,1.4092E-01,1.2294E-01,1.0928E-01,1.0224E-01,1.0401E-01,
     &1.1623E-01,1.4620E-01,1.9488E-01,2.3948E-01,2.8894E-01,3.2681E-01,
     &3.5905E-01,3.7613E-01,3.7908E-01,3.6817E-01,3.4299E-01,3.0266E-01,
     &2.4596E-01,1.7115E-01,7.6792E-02,0.0000E+00,0.0000E+00,1.7267E-01,
     &1.2670E-01,8.8446E-02,5.8458E-02,3.6380E-02,2.0551E-02,1.0608E-02,
     &4.7732E-03,1.7670E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &4.7845E-01,4.7258E-01,4.6687E-01,4.6107E-01,4.5540E-01,4.4938E-01,
     &4.4336E-01,4.3728E-01,4.3070E-01,4.2403E-01,4.1702E-01,4.0968E-01,
     &4.0210E-01,3.9723E-01,3.9181E-01,3.8522E-01,3.7808E-01,3.7047E-01,
     &3.6211E-01,3.5469E-01,3.4619E-01,3.3582E-01,3.2478E-01,3.1314E-01/
      DATA (XDEF_L(K),K=  229,  342) /
     &3.0021E-01,2.8848E-01,2.7488E-01,2.5781E-01,2.3886E-01,2.1865E-01,
     &1.9932E-01,1.8196E-01,1.6359E-01,1.4359E-01,1.2596E-01,1.1295E-01,
     &1.0678E-01,1.0933E-01,1.2234E-01,1.5242E-01,1.9969E-01,2.4187E-01,
     &2.8742E-01,3.2112E-01,3.4825E-01,3.6067E-01,3.5959E-01,3.4546E-01,
     &3.1813E-01,2.7719E-01,2.2151E-01,1.5037E-01,6.2862E-02,0.0000E+00,
     &0.0000E+00,1.5516E-01,1.1270E-01,7.7856E-02,5.0916E-02,3.1337E-02,
     &1.7279E-02,8.9355E-03,3.9672E-03,1.4465E-03,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,5.0059E-01,4.9450E-01,4.8826E-01,4.8213E-01,
     &4.7610E-01,4.6972E-01,4.6326E-01,4.5655E-01,4.4999E-01,4.4265E-01,
     &4.3505E-01,4.2703E-01,4.1870E-01,4.1345E-01,4.0758E-01,4.0034E-01,
     &3.9260E-01,3.8434E-01,3.7539E-01,3.6725E-01,3.5804E-01,3.4696E-01,
     &3.3492E-01,3.2231E-01,3.0852E-01,2.9601E-01,2.8154E-01,2.6348E-01,
     &2.4363E-01,2.2272E-01,2.0295E-01,1.8526E-01,1.6669E-01,1.4678E-01,
     &1.2956E-01,1.1726E-01,1.1212E-01,1.1548E-01,1.2910E-01,1.5906E-01,
     &2.0458E-01,2.4395E-01,2.8508E-01,3.1418E-01,3.3593E-01,3.4343E-01,
     &3.3827E-01,3.2104E-01,2.9189E-01,2.5067E-01,1.9688E-01,1.3016E-01,
     &5.0498E-02,0.0000E+00,0.0000E+00,1.3742E-01,9.8602E-02,6.7357E-02,
     &4.3555E-02,2.6444E-02,1.4175E-02,7.3561E-03,3.2181E-03,1.1530E-03,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,5.2114E-01,5.1454E-01/
      DATA (XDEF_L(K),K=  343,  456) /
     &5.0806E-01,5.0160E-01,4.9520E-01,4.8843E-01,4.8165E-01,4.7456E-01,
     &4.6738E-01,4.5962E-01,4.5149E-01,4.4293E-01,4.3400E-01,4.2833E-01,
     &4.2194E-01,4.1420E-01,4.0580E-01,3.9678E-01,3.8741E-01,3.7848E-01,
     &3.6878E-01,3.5682E-01,3.4416E-01,3.3062E-01,3.1602E-01,3.0269E-01,
     &2.8749E-01,2.6857E-01,2.4798E-01,2.2641E-01,2.0626E-01,1.8828E-01,
     &1.6960E-01,1.4976E-01,1.3293E-01,1.2126E-01,1.1684E-01,1.2099E-01,
     &1.3505E-01,1.6471E-01,2.0841E-01,2.4521E-01,2.8248E-01,3.0770E-01,
     &3.2484E-01,3.2845E-01,3.1999E-01,3.0047E-01,2.7030E-01,2.2924E-01,
     &1.7739E-01,1.1482E-01,4.2174E-02,0.0000E+00,0.0000E+00,1.2330E-01,
     &8.7586E-02,5.9211E-02,3.7890E-02,2.2733E-02,1.1877E-02,6.1865E-03,
     &2.6713E-03,9.4247E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &5.4423E-01,5.3740E-01,5.3068E-01,5.2385E-01,5.1700E-01,5.0982E-01,
     &5.0256E-01,4.9509E-01,4.8731E-01,4.7895E-01,4.7023E-01,4.6094E-01,
     &4.5130E-01,4.4506E-01,4.3820E-01,4.2973E-01,4.2069E-01,4.1108E-01,
     &4.0069E-01,3.9131E-01,3.8063E-01,3.6796E-01,3.5430E-01,3.3991E-01,
     &3.2433E-01,3.1014E-01,2.9407E-01,2.7418E-01,2.5281E-01,2.3056E-01,
     &2.0999E-01,1.9171E-01,1.7291E-01,1.5321E-01,1.3677E-01,1.2578E-01,
     &1.2220E-01,1.2696E-01,1.4132E-01,1.7056E-01,2.1212E-01,2.4603E-01,
     &2.7912E-01,3.0023E-01,3.1274E-01,3.1234E-01,3.0087E-01,2.7925E-01/
      DATA (XDEF_L(K),K=  457,  570) /
     &2.4820E-01,2.0782E-01,1.5841E-01,1.0056E-01,3.5470E-02,0.0000E+00,
     &0.0000E+00,1.0941E-01,7.6864E-02,5.1391E-02,3.2506E-02,1.9250E-02,
     &9.7741E-03,5.1192E-03,2.1775E-03,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,5.6542E-01,5.5814E-01,5.5101E-01,5.4385E-01,
     &5.3670E-01,5.2913E-01,5.2140E-01,5.1352E-01,5.0533E-01,4.9639E-01,
     &4.8702E-01,4.7710E-01,4.6670E-01,4.6011E-01,4.5270E-01,4.4365E-01,
     &4.3394E-01,4.2383E-01,4.1271E-01,4.0253E-01,3.9137E-01,3.7783E-01,
     &3.6325E-01,3.4810E-01,3.3163E-01,3.1674E-01,2.9988E-01,2.7922E-01,
     &2.5706E-01,2.3429E-01,2.1333E-01,1.9484E-01,1.7592E-01,1.5634E-01,
     &1.4028E-01,1.2985E-01,1.2692E-01,1.3218E-01,1.4678E-01,1.7535E-01,
     &2.1492E-01,2.4628E-01,2.7582E-01,2.9349E-01,3.0215E-01,2.9865E-01,
     &2.8479E-01,2.6176E-01,2.3025E-01,1.9073E-01,1.4372E-01,9.0030E-02,
     &3.1431E-02,0.0000E+00,0.0000E+00,9.8561E-02,6.8571E-02,4.5400E-02,
     &2.8439E-02,1.6650E-02,8.2414E-03,4.3377E-03,1.8226E-03,0.0000E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,5.8660E-01,5.7912E-01,
     &5.7170E-01,5.6412E-01,5.5660E-01,5.4858E-01,5.4040E-01,5.3194E-01,
     &5.2336E-01,5.1383E-01,5.0381E-01,4.9326E-01,4.8220E-01,4.7515E-01,
     &4.6719E-01,4.5756E-01,4.4719E-01,4.3619E-01,4.2441E-01,4.1376E-01,
     &4.0188E-01,3.8750E-01,3.7220E-01,3.5617E-01,3.3884E-01,3.2317E-01/
      DATA (XDEF_L(K),K=  571,  684) /
     &3.0561E-01,2.8413E-01,2.6132E-01,2.3801E-01,2.1667E-01,1.9794E-01,
     &1.7898E-01,1.5951E-01,1.4381E-01,1.3395E-01,1.3154E-01,1.3722E-01,
     &1.5183E-01,1.7978E-01,2.1726E-01,2.4615E-01,2.7227E-01,2.8668E-01,
     &2.9185E-01,2.8560E-01,2.6981E-01,2.4566E-01,2.1405E-01,1.7560E-01,
     &1.3093E-01,8.1317E-02,2.8821E-02,0.0000E+00,0.0000E+00,8.9016E-02,
     &6.1335E-02,4.0241E-02,2.4960E-02,1.4451E-02,6.9787E-03,3.6912E-03,
     &1.5320E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &6.0621E-01,5.9821E-01,5.9043E-01,5.8253E-01,5.7470E-01,5.6625E-01,
     &5.5768E-01,5.4870E-01,5.3948E-01,5.2962E-01,5.1919E-01,5.0796E-01,
     &4.9620E-01,4.8867E-01,4.8027E-01,4.7003E-01,4.5907E-01,4.4740E-01,
     &4.3484E-01,4.2392E-01,4.1127E-01,3.9627E-01,3.8010E-01,3.6326E-01,
     &3.4524E-01,3.2900E-01,3.1064E-01,2.8853E-01,2.6510E-01,2.4135E-01,
     &2.1970E-01,2.0080E-01,1.8175E-01,1.6242E-01,1.4701E-01,1.3753E-01,
     &1.3572E-01,1.4160E-01,1.5623E-01,1.8343E-01,2.1902E-01,2.4571E-01,
     &2.6885E-01,2.8059E-01,2.8292E-01,2.7441E-01,2.5704E-01,2.3223E-01,
     &2.0062E-01,1.6317E-01,1.2079E-01,7.4733E-02,2.7461E-02,0.0000E+00,
     &0.0000E+00,8.1334E-02,5.5577E-02,3.6150E-02,2.2243E-02,1.2749E-02,
     &6.0264E-03,3.2009E-03,1.3143E-03,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,6.2581E-01,6.1778E-01,6.0953E-01,6.0134E-01/
      DATA (XDEF_L(K),K=  685,  798) /
     &5.9310E-01,5.8428E-01,5.7523E-01,5.6587E-01,5.5625E-01,5.4565E-01,
     &5.3457E-01,5.2280E-01,5.1030E-01,5.0236E-01,4.9350E-01,4.8267E-01,
     &4.7104E-01,4.5899E-01,4.4560E-01,4.3381E-01,4.2066E-01,4.0485E-01,
     &3.8801E-01,3.7047E-01,3.5165E-01,3.3476E-01,3.1574E-01,2.9293E-01,
     &2.6889E-01,2.4469E-01,2.2279E-01,2.0369E-01,1.8458E-01,1.6537E-01,
     &1.5025E-01,1.4125E-01,1.3980E-01,1.4589E-01,1.6046E-01,1.8686E-01,
     &2.2052E-01,2.4502E-01,2.6530E-01,2.7444E-01,2.7406E-01,2.6361E-01,
     &2.4491E-01,2.1954E-01,1.8819E-01,1.5193E-01,1.1170E-01,6.9146E-02,
     &2.6829E-02,0.0000E+00,0.0000E+00,7.4387E-02,5.0398E-02,3.2529E-02,
     &1.9840E-02,1.1260E-02,5.2109E-03,2.7796E-03,1.1291E-03,0.0000E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,6.4510E-01,6.3663E-01,
     &6.2809E-01,6.1948E-01,6.1090E-01,6.0165E-01,5.9256E-01,5.8263E-01,
     &5.7237E-01,5.6121E-01,5.4960E-01,5.3710E-01,5.2390E-01,5.1555E-01,
     &5.0615E-01,4.9474E-01,4.8273E-01,4.6980E-01,4.5603E-01,4.4343E-01,
     &4.2983E-01,4.1325E-01,3.9561E-01,3.7731E-01,3.5765E-01,3.4017E-01,
     &3.2063E-01,2.9709E-01,2.7258E-01,2.4795E-01,2.2572E-01,2.0647E-01,
     &1.8735E-01,1.6824E-01,1.5339E-01,1.4470E-01,1.4366E-01,1.4990E-01,
     &1.6437E-01,1.8986E-01,2.2169E-01,2.4408E-01,2.6175E-01,2.6863E-01,
     &2.6585E-01,2.5363E-01,2.3397E-01,2.0813E-01,1.7714E-01,1.4205E-01/
      DATA (XDEF_L(K),K=  799,  912) /
     &1.0396E-01,6.4602E-02,2.6785E-02,0.0000E+00,0.0000E+00,6.8343E-02,
     &4.5962E-02,2.9434E-02,1.7812E-02,1.0015E-02,4.5458E-03,2.4331E-03,
     &9.7866E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &6.6281E-01,6.5407E-01,6.4523E-01,6.3631E-01,6.2740E-01,6.1775E-01,
     &6.0821E-01,5.9770E-01,5.8724E-01,5.7535E-01,5.6321E-01,5.5021E-01,
     &5.3640E-01,5.2763E-01,5.1775E-01,5.0583E-01,4.9310E-01,4.7946E-01,
     &4.6520E-01,4.5225E-01,4.3811E-01,4.2074E-01,4.0247E-01,3.8355E-01,
     &3.6315E-01,3.4516E-01,3.2502E-01,3.0091E-01,2.7589E-01,2.5090E-01,
     &2.2842E-01,2.0903E-01,1.8987E-01,1.7087E-01,1.5631E-01,1.4790E-01,
     &1.4709E-01,1.5345E-01,1.6771E-01,1.9243E-01,2.2253E-01,2.4307E-01,
     &2.5846E-01,2.6327E-01,2.5857E-01,2.4493E-01,2.2441E-01,1.9832E-01,
     &1.6773E-01,1.3380E-01,9.7606E-02,6.1077E-02,2.7123E-02,4.1687E-04,
     &0.0000E+00,6.3316E-02,4.2290E-02,2.6899E-02,1.6166E-02,9.0143E-03,
     &4.0214E-03,2.1587E-03,8.6042E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,6.8558E-01,6.7623E-01,6.6716E-01,6.5776E-01,
     &6.4840E-01,6.3825E-01,6.2778E-01,6.1697E-01,6.0589E-01,5.9350E-01,
     &5.8071E-01,5.6677E-01,5.5220E-01,5.4293E-01,5.3246E-01,5.1980E-01,
     &5.0630E-01,4.9221E-01,4.7690E-01,4.6348E-01,4.4839E-01,4.3024E-01,
     &4.1112E-01,3.9125E-01,3.7016E-01,3.5134E-01,3.3054E-01,3.0571E-01/
      DATA (XDEF_L(K),K=  913, 1026) /
     &2.8005E-01,2.5463E-01,2.3186E-01,2.1230E-01,1.9311E-01,1.7422E-01,
     &1.5985E-01,1.5187E-01,1.5138E-01,1.5783E-01,1.7178E-01,1.9543E-01,
     &2.2331E-01,2.4162E-01,2.5415E-01,2.5666E-01,2.4964E-01,2.3438E-01,
     &2.1293E-01,1.8681E-01,1.5680E-01,1.2430E-01,9.0488E-02,5.7352E-02,
     &2.7942E-02,7.0995E-03,2.4780E-03,5.7612E-02,3.8138E-02,2.4057E-02,
     &1.4329E-02,7.9111E-03,3.4566E-03,1.8603E-03,7.3347E-04,0.0000E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,7.0709E-01,6.9744E-01,
     &6.8784E-01,6.7803E-01,6.6830E-01,6.5763E-01,6.4678E-01,6.3540E-01,
     &6.2360E-01,6.1071E-01,5.9715E-01,5.8240E-01,5.6710E-01,5.5722E-01,
     &5.4625E-01,5.3291E-01,5.1856E-01,5.0380E-01,4.8797E-01,4.7363E-01,
     &4.5801E-01,4.3900E-01,4.1917E-01,3.9846E-01,3.7656E-01,3.5717E-01,
     &3.3564E-01,3.1017E-01,2.8397E-01,2.5816E-01,2.3508E-01,2.1538E-01,
     &1.9615E-01,1.7737E-01,1.6324E-01,1.5559E-01,1.5535E-01,1.6175E-01,
     &1.7537E-01,1.9793E-01,2.2384E-01,2.4005E-01,2.5009E-01,2.5051E-01,
     &2.4150E-01,2.2495E-01,2.0291E-01,1.7668E-01,1.4739E-01,1.1625E-01,
     &8.4583E-02,5.4470E-02,2.9013E-02,1.3147E-02,1.4553E-02,5.2777E-02,
     &3.4672E-02,2.1686E-02,1.2821E-02,7.0105E-03,3.0093E-03,1.6226E-03,
     &6.3321E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &7.2796E-01,7.1795E-01,7.0799E-01,6.9776E-01,6.8760E-01,6.7649E-01/
      DATA (XDEF_L(K),K= 1027, 1140) /
     &6.6523E-01,6.5299E-01,6.4099E-01,6.2720E-01,6.1289E-01,5.9763E-01,
     &5.8140E-01,5.7108E-01,5.5954E-01,5.4555E-01,5.3082E-01,5.1501E-01,
     &4.9841E-01,4.8352E-01,4.6718E-01,4.4758E-01,4.2678E-01,4.0543E-01,
     &3.8267E-01,3.6267E-01,3.4052E-01,3.1445E-01,2.8771E-01,2.6154E-01,
     &2.3817E-01,2.1835E-01,1.9910E-01,1.8043E-01,1.6662E-01,1.5905E-01,
     &1.5900E-01,1.6548E-01,1.7871E-01,2.0015E-01,2.2403E-01,2.3835E-01,
     &2.4610E-01,2.4469E-01,2.3394E-01,2.1634E-01,1.9372E-01,1.6761E-01,
     &1.3910E-01,1.0920E-01,7.9530E-02,5.2165E-02,3.0250E-02,1.8723E-02,
     &2.5275E-02,4.8575E-02,3.1676E-02,1.9677E-02,1.1540E-02,6.2533E-03,
     &2.6411E-03,1.4253E-03,5.5072E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,7.4788E-01,7.3751E-01,7.2708E-01,7.1644E-01,
     &7.0580E-01,6.9430E-01,6.8256E-01,6.6975E-01,6.5712E-01,6.4276E-01,
     &6.2791E-01,6.1180E-01,5.9490E-01,5.8409E-01,5.7199E-01,5.5739E-01,
     &5.4166E-01,5.2544E-01,5.0821E-01,4.9288E-01,4.7590E-01,4.5544E-01,
     &4.3393E-01,4.1178E-01,3.8837E-01,3.6775E-01,3.4513E-01,3.1844E-01,
     &2.9125E-01,2.6472E-01,2.4110E-01,2.2115E-01,2.0189E-01,1.8330E-01,
     &1.6955E-01,1.6237E-01,1.6243E-01,1.6875E-01,1.8164E-01,2.0201E-01,
     &2.2410E-01,2.3665E-01,2.4236E-01,2.3927E-01,2.2710E-01,2.0852E-01,
     &1.8563E-01,1.5962E-01,1.3170E-01,1.0314E-01,7.5292E-02,5.0347E-02/
      DATA (XDEF_L(K),K= 1141, 1254) /
     &3.1513E-02,2.3688E-02,3.4520E-02,4.4988E-02,2.9140E-02,1.7975E-02,
     &1.0472E-02,5.6268E-03,2.3442E-03,1.2646E-03,4.8432E-04,0.0000E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,7.6812E-01,7.5731E-01,
     &7.4653E-01,7.3551E-01,7.2440E-01,7.1234E-01,6.9989E-01,6.8692E-01,
     &6.7357E-01,6.5855E-01,6.4312E-01,6.2624E-01,6.0850E-01,5.9719E-01,
     &5.8457E-01,5.6934E-01,5.5297E-01,5.3626E-01,5.1802E-01,5.0223E-01,
     &4.8440E-01,4.6329E-01,4.4109E-01,4.1826E-01,3.9408E-01,3.7291E-01,
     &3.4966E-01,3.2243E-01,2.9475E-01,2.6790E-01,2.4406E-01,2.2399E-01,
     &2.0470E-01,1.8621E-01,1.7262E-01,1.6558E-01,1.6576E-01,1.7201E-01,
     &1.8441E-01,2.0372E-01,2.2403E-01,2.3482E-01,2.3856E-01,2.3398E-01,
     &2.2040E-01,2.0103E-01,1.7782E-01,1.5205E-01,1.2492E-01,9.7540E-02,
     &7.1452E-02,4.8817E-02,3.2832E-02,2.8412E-02,4.3068E-02,4.1684E-02,
     &2.6819E-02,1.6431E-02,9.5049E-03,5.0674E-03,2.0840E-03,1.1231E-03,
     &4.2643E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &7.8709E-01,7.7617E-01,7.6509E-01,7.5353E-01,7.4210E-01,7.2955E-01,
     &7.1666E-01,7.0326E-01,6.8906E-01,6.7364E-01,6.5743E-01,6.3988E-01,
     &6.2140E-01,6.0962E-01,5.9645E-01,5.8083E-01,5.6382E-01,5.4630E-01,
     &5.2750E-01,5.1079E-01,4.9267E-01,4.7078E-01,4.4780E-01,4.2425E-01,
     &3.9948E-01,3.7773E-01,3.5398E-01,3.2619E-01,2.9811E-01,2.7093E-01/
      DATA (XDEF_L(K),K= 1255, 1368) /
     &2.4686E-01,2.2668E-01,2.0735E-01,1.8888E-01,1.7555E-01,1.6865E-01,
     &1.6887E-01,1.7500E-01,1.8693E-01,2.0522E-01,2.2377E-01,2.3300E-01,
     &2.3501E-01,2.2902E-01,2.1428E-01,1.9427E-01,1.7084E-01,1.4533E-01,
     &1.1889E-01,9.2655E-02,6.8174E-02,4.7575E-02,3.4123E-02,3.2605E-02,
     &5.0454E-02,3.8820E-02,2.4822E-02,1.5113E-02,8.6857E-03,4.5962E-03,
     &1.8704E-03,1.0050E-03,3.7856E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,8.0606E-01,7.9455E-01,7.8312E-01,7.7128E-01,
     &7.5940E-01,7.4610E-01,7.3287E-01,7.1917E-01,7.0456E-01,6.8825E-01,
     &6.7140E-01,6.5313E-01,6.3390E-01,6.2170E-01,6.0798E-01,5.9180E-01,
     &5.7419E-01,5.5596E-01,5.3636E-01,5.1934E-01,5.0050E-01,4.7790E-01,
     &4.5436E-01,4.3012E-01,4.0458E-01,3.8238E-01,3.5808E-01,3.2984E-01,
     &3.0133E-01,2.7388E-01,2.4957E-01,2.2930E-01,2.0996E-01,1.9168E-01,
     &1.7832E-01,1.7159E-01,1.7177E-01,1.7770E-01,1.8921E-01,2.0651E-01,
     &2.2344E-01,2.3117E-01,2.3152E-01,2.2426E-01,2.0844E-01,1.8790E-01,
     &1.6440E-01,1.3914E-01,1.1342E-01,8.8280E-02,6.5276E-02,4.6578E-02,
     &3.5360E-02,3.6411E-02,5.6986E-02,3.6256E-02,2.3040E-02,1.3948E-02,
     &7.9676E-03,4.1856E-03,1.6876E-03,9.0394E-04,3.3789E-04,0.0000E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,8.2409E-01,8.1223E-01,
     &8.0027E-01,7.8810E-01,7.7580E-01,7.6250E-01,7.4852E-01,7.3383E-01/
      DATA (XDEF_L(K),K= 1369, 1482) /
     &7.1879E-01,7.0216E-01,6.8466E-01,6.6571E-01,6.4580E-01,6.3303E-01,
     &6.1887E-01,6.0161E-01,5.8362E-01,5.6485E-01,5.4490E-01,5.2736E-01,
     &5.0788E-01,4.8465E-01,4.6048E-01,4.3549E-01,4.0949E-01,3.8678E-01,
     &3.6198E-01,3.3325E-01,3.0435E-01,2.7667E-01,2.5212E-01,2.3179E-01,
     &2.1241E-01,1.9410E-01,1.8093E-01,1.7428E-01,1.7445E-01,1.8022E-01,
     &1.9133E-01,2.0758E-01,2.2299E-01,2.2941E-01,2.2823E-01,2.1990E-01,
     &2.0319E-01,1.8211E-01,1.5852E-01,1.3371E-01,1.0856E-01,8.4430E-02,
     &6.2776E-02,4.5758E-02,3.6514E-02,3.9756E-02,6.2597E-02,3.4019E-02,
     &2.1502E-02,1.2943E-02,7.3506E-03,3.8366E-03,1.5351E-03,8.1923E-04,
     &3.0383E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &8.4844E-01,8.3627E-01,8.2378E-01,8.1114E-01,7.9820E-01,7.8411E-01,
     &7.6977E-01,7.5436E-01,7.3871E-01,7.2101E-01,7.0269E-01,6.8280E-01,
     &6.6180E-01,6.4849E-01,6.3365E-01,6.1605E-01,5.9682E-01,5.7721E-01,
     &5.5628E-01,5.3805E-01,5.1772E-01,4.9378E-01,4.6868E-01,4.4295E-01,
     &4.1599E-01,3.9262E-01,3.6722E-01,3.3788E-01,3.0847E-01,2.8040E-01,
     &2.5562E-01,2.3513E-01,2.1572E-01,1.9746E-01,1.8447E-01,1.7787E-01,
     &1.7810E-01,1.8358E-01,1.9394E-01,2.0894E-01,2.2227E-01,2.2689E-01,
     &2.2385E-01,2.1408E-01,1.9620E-01,1.7461E-01,1.5108E-01,1.2667E-01,
     &1.0243E-01,7.9635E-02,5.9715E-02,4.4804E-02,3.7997E-02,4.3894E-02/
      DATA (XDEF_L(K),K= 1483, 1596) /
     &6.9391E-02,3.1240E-02,1.9603E-02,1.1712E-02,6.6036E-03,3.4150E-03,
     &1.3549E-03,7.1812E-04,2.6373E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,8.7089E-01,8.5819E-01,8.4535E-01,8.3207E-01,
     &8.1860E-01,8.0424E-01,7.8877E-01,7.7320E-01,7.5642E-01,7.3822E-01,
     &7.1895E-01,6.9816E-01,6.7640E-01,6.6244E-01,6.4701E-01,6.2817E-01,
     &6.0860E-01,5.8841E-01,5.6672E-01,5.4767E-01,5.2667E-01,5.0182E-01,
     &4.7599E-01,4.4955E-01,4.2190E-01,3.9787E-01,3.7196E-01,3.4199E-01,
     &3.1220E-01,2.8382E-01,2.5874E-01,2.3816E-01,2.1874E-01,2.0063E-01,
     &1.8770E-01,1.8107E-01,1.8121E-01,1.8638E-01,1.9622E-01,2.0994E-01,
     &2.2156E-01,2.2456E-01,2.1986E-01,2.0892E-01,1.9015E-01,1.6817E-01,
     &1.4465E-01,1.2070E-01,9.7309E-02,7.5665E-02,5.7234E-02,4.4095E-02,
     &3.9289E-02,4.7307E-02,7.4739E-02,2.8958E-02,1.8046E-02,1.0716E-02,
     &6.0010E-03,3.0801E-03,1.2145E-03,6.3833E-04,2.3251E-04,0.0000E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,8.9366E-01,8.8058E-01,
     &8.6727E-01,8.5353E-01,8.3950E-01,8.2436E-01,8.0890E-01,7.9205E-01,
     &7.7476E-01,7.5566E-01,7.3557E-01,7.1393E-01,6.9120E-01,6.7672E-01,
     &6.6059E-01,6.4145E-01,6.2086E-01,5.9962E-01,5.7716E-01,5.5756E-01,
     &5.3584E-01,5.1022E-01,4.8344E-01,4.5615E-01,4.2780E-01,4.0320E-01,
     &3.7671E-01,3.4621E-01,3.1594E-01,2.8727E-01,2.6196E-01,2.4126E-01/
      DATA (XDEF_L(K),K= 1597, 1710) /
     &2.2177E-01,2.0361E-01,1.9078E-01,1.8427E-01,1.8432E-01,1.8918E-01,
     &1.9834E-01,2.1079E-01,2.2065E-01,2.2210E-01,2.1587E-01,2.0383E-01,
     &1.8424E-01,1.6197E-01,1.3849E-01,1.1505E-01,9.2463E-02,7.1949E-02,
     &5.4952E-02,4.3474E-02,4.0525E-02,5.0376E-02,7.9517E-02,2.6835E-02,
     &1.6616E-02,9.8004E-03,5.4489E-03,2.7768E-03,1.0900E-03,5.6728E-04,
     &2.0489E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &9.1643E-01,9.0298E-01,8.8901E-01,8.7472E-01,8.6030E-01,8.4449E-01,
     &8.2790E-01,8.1090E-01,7.9278E-01,7.7287E-01,7.5201E-01,7.2942E-01,
     &7.0580E-01,6.9067E-01,6.7395E-01,6.5357E-01,6.3264E-01,6.1082E-01,
     &5.8728E-01,5.6718E-01,5.4478E-01,5.1825E-01,4.9075E-01,4.6263E-01,
     &4.3360E-01,4.0844E-01,3.8138E-01,3.5032E-01,3.1963E-01,2.9065E-01,
     &2.6511E-01,2.4428E-01,2.2479E-01,2.0678E-01,1.9385E-01,1.8735E-01,
     &1.8722E-01,1.9179E-01,2.0029E-01,2.1158E-01,2.1961E-01,2.1971E-01,
     &2.1194E-01,1.9894E-01,1.7862E-01,1.5609E-01,1.3279E-01,1.0972E-01,
     &8.8007E-02,6.8578E-02,5.2905E-02,4.2942E-02,4.1624E-02,5.3065E-02,
     &8.3506E-02,2.4920E-02,1.5334E-02,8.9876E-03,4.9653E-03,2.5112E-03,
     &9.8300E-04,5.0629E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,9.3762E-01,9.2325E-01,9.0916E-01,8.9432E-01,
     &8.7930E-01,8.6312E-01,8.4579E-01,8.2807E-01,8.0954E-01,7.8866E-01/
      DATA (XDEF_L(K),K= 1711, 1824) /
     &7.6704E-01,7.4360E-01,7.1911E-01,7.0343E-01,6.8612E-01,6.6512E-01,
     &6.4349E-01,6.2048E-01,5.9676E-01,5.7574E-01,5.5261E-01,5.2556E-01,
     &4.9731E-01,4.6862E-01,4.3881E-01,4.1318E-01,3.8556E-01,3.5408E-01,
     &3.2299E-01,2.9375E-01,2.6794E-01,2.4706E-01,2.2744E-01,2.0939E-01,
     &1.9662E-01,1.9016E-01,1.8990E-01,1.9412E-01,2.0192E-01,2.1208E-01,
     &2.1863E-01,2.1745E-01,2.0845E-01,1.9458E-01,1.7365E-01,1.5094E-01,
     &1.2783E-01,1.0526E-01,8.4228E-02,6.5746E-02,5.1203E-02,4.2521E-02,
     &4.2531E-02,5.5238E-02,8.6619E-02,2.3321E-02,1.4266E-02,8.3142E-03,
     &4.5684E-03,2.2945E-03,8.9721E-04,4.5700E-04,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,9.5912E-01,9.4446E-01,
     &9.2967E-01,9.1446E-01,8.9890E-01,8.8176E-01,8.6424E-01,8.4567E-01,
     &8.2630E-01,8.0492E-01,7.8242E-01,7.5817E-01,7.3271E-01,7.1653E-01,
     &6.9849E-01,6.7725E-01,6.5433E-01,6.3091E-01,6.0625E-01,5.8456E-01,
     &5.6088E-01,5.3305E-01,5.0402E-01,4.7461E-01,4.4411E-01,4.1800E-01,
     &3.8988E-01,3.5790E-01,3.2644E-01,2.9690E-01,2.7087E-01,2.4987E-01,
     &2.3039E-01,2.1219E-01,1.9955E-01,1.9298E-01,1.9248E-01,1.9636E-01,
     &2.0355E-01,2.1258E-01,2.1752E-01,2.1512E-01,2.0490E-01,1.9021E-01,
     &1.6876E-01,1.4586E-01,1.2296E-01,1.0090E-01,8.0587E-02,6.3034E-02,
     &4.9591E-02,4.2122E-02,4.3355E-02,5.7203E-02,8.9336E-02,2.1802E-02/
      DATA (XDEF_L(K),K= 1825, 1836) /
     &1.3258E-02,7.6843E-03,4.1967E-03,2.0952E-03,8.1932E-04,4.1202E-04,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00/
      DATA (XUDF_L(K),K=    1,  114) /
     &1.8987E-02,1.9947E-02,2.0980E-02,2.2068E-02,2.3225E-02,2.4540E-02,
     &2.5957E-02,2.7526E-02,2.9229E-02,3.1232E-02,3.3453E-02,3.6003E-02,
     &3.8855E-02,4.0763E-02,4.2980E-02,4.5778E-02,4.8895E-02,5.2320E-02,
     &5.6174E-02,5.9765E-02,6.3980E-02,6.9315E-02,7.5299E-02,8.1888E-02,
     &8.9292E-02,9.6162E-02,1.0414E-01,1.1410E-01,1.2505E-01,1.3674E-01,
     &1.4937E-01,1.6060E-01,1.7296E-01,1.8730E-01,2.0166E-01,2.1531E-01,
     &2.2821E-01,2.3833E-01,2.4848E-01,2.6049E-01,2.7586E-01,2.9166E-01,
     &3.1456E-01,3.3942E-01,3.7230E-01,4.0597E-01,4.3921E-01,4.7071E-01,
     &4.9846E-01,5.2057E-01,5.3433E-01,5.3610E-01,5.2141E-01,4.8433E-01,
     &4.1719E-01,6.3794E-01,6.7411E-01,7.2040E-01,7.8812E-01,8.9495E-01,
     &1.0702E+00,1.3629E+00,1.8763E+00,2.8399E+00,4.8968E+00,1.0506E+01,
     &3.7793E+01,0.0000E+00,3.1111E-02,3.2336E-02,3.3580E-02,3.4906E-02,
     &3.6247E-02,3.7773E-02,3.9337E-02,4.1056E-02,4.2876E-02,4.5001E-02,
     &4.7299E-02,4.9897E-02,5.2761E-02,5.4666E-02,5.6867E-02,5.9620E-02,
     &6.2679E-02,6.6018E-02,6.9775E-02,7.3275E-02,7.7353E-02,8.2522E-02,
     &8.8327E-02,9.4694E-02,1.0184E-01,1.0846E-01,1.1615E-01,1.2575E-01,
     &1.3628E-01,1.4752E-01,1.5964E-01,1.7036E-01,1.8215E-01,1.9580E-01,
     &2.0933E-01,2.2213E-01,2.3411E-01,2.4341E-01,2.5275E-01,2.6387E-01,
     &2.7831E-01,2.9333E-01,3.1510E-01,3.3876E-01,3.6995E-01,4.0170E-01/
      DATA (XUDF_L(K),K=  115,  228) /
     &4.3298E-01,4.6172E-01,4.8742E-01,5.0700E-01,5.1856E-01,5.1873E-01,
     &5.0352E-01,4.6746E-01,4.0418E-01,6.1801E-01,6.5339E-01,6.9923E-01,
     &7.6627E-01,8.7125E-01,1.0408E+00,1.3199E+00,1.8020E+00,2.6920E+00,
     &4.5574E+00,9.5310E+00,3.2877E+01,0.0000E+00,5.1176E-02,5.2640E-02,
     &5.4100E-02,5.5603E-02,5.7095E-02,5.8737E-02,6.0416E-02,6.2154E-02,
     &6.4016E-02,6.6046E-02,6.8273E-02,7.0765E-02,7.3444E-02,7.5182E-02,
     &7.7263E-02,7.9781E-02,8.2626E-02,8.5707E-02,8.9176E-02,9.2402E-02,
     &9.6182E-02,1.0098E-01,1.0635E-01,1.1227E-01,1.1893E-01,1.2513E-01,
     &1.3230E-01,1.4128E-01,1.5115E-01,1.6164E-01,1.7300E-01,1.8301E-01,
     &1.9397E-01,2.0660E-01,2.1907E-01,2.3072E-01,2.4154E-01,2.4985E-01,
     &2.5817E-01,2.6810E-01,2.8136E-01,2.9535E-01,3.1585E-01,3.3824E-01,
     &3.6743E-01,3.9701E-01,4.2565E-01,4.5205E-01,4.7460E-01,4.9184E-01,
     &5.0110E-01,4.9954E-01,4.8363E-01,4.4878E-01,3.8940E-01,5.9452E-01,
     &6.2820E-01,6.7181E-01,7.3612E-01,8.3598E-01,9.9560E-01,1.2543E+00,
     &1.6953E+00,2.4947E+00,4.1415E+00,8.4275E+00,2.7797E+01,0.0000E+00,
     &8.6266E-02,8.7847E-02,8.9380E-02,9.0869E-02,9.2337E-02,9.3826E-02,
     &9.5315E-02,9.6842E-02,9.8333E-02,1.0003E-01,1.0178E-01,1.0370E-01,
     &1.0575E-01,1.0710E-01,1.0872E-01,1.1075E-01,1.1295E-01,1.1538E-01,
     &1.1821E-01,1.2088E-01,1.2396E-01,1.2796E-01,1.3252E-01,1.3756E-01/
      DATA (XUDF_L(K),K=  229,  342) /
     &1.4331E-01,1.4870E-01,1.5500E-01,1.6291E-01,1.7166E-01,1.8100E-01,
     &1.9111E-01,2.0002E-01,2.0977E-01,2.2095E-01,2.3189E-01,2.4200E-01,
     &2.5123E-01,2.5821E-01,2.6512E-01,2.7351E-01,2.8514E-01,2.9789E-01,
     &3.1683E-01,3.3731E-01,3.6424E-01,3.9124E-01,4.1697E-01,4.4030E-01,
     &4.6002E-01,4.7419E-01,4.8085E-01,4.7740E-01,4.6086E-01,4.2728E-01,
     &3.7241E-01,5.6656E-01,5.9684E-01,6.3694E-01,6.9622E-01,7.8804E-01,
     &9.3343E-01,1.1653E+00,1.5545E+00,2.2504E+00,3.6537E+00,7.2124E+00,
     &2.2653E+01,0.0000E+00,1.4838E-01,1.4960E-01,1.5068E-01,1.5161E-01,
     &1.5242E-01,1.5316E-01,1.5373E-01,1.5426E-01,1.5470E-01,1.5511E-01,
     &1.5554E-01,1.5602E-01,1.5660E-01,1.5698E-01,1.5750E-01,1.5830E-01,
     &1.5923E-01,1.6034E-01,1.6181E-01,1.6324E-01,1.6509E-01,1.6746E-01,
     &1.7054E-01,1.7402E-01,1.7811E-01,1.8208E-01,1.8687E-01,1.9296E-01,
     &1.9986E-01,2.0734E-01,2.1554E-01,2.2281E-01,2.3075E-01,2.3983E-01,
     &2.4863E-01,2.5660E-01,2.6366E-01,2.6883E-01,2.7387E-01,2.8026E-01,
     &2.8982E-01,3.0088E-01,3.1780E-01,3.3626E-01,3.6021E-01,3.8399E-01,
     &4.0666E-01,4.2682E-01,4.4278E-01,4.5386E-01,4.5774E-01,4.5230E-01,
     &4.3509E-01,4.0314E-01,3.5321E-01,5.3325E-01,5.5916E-01,5.9448E-01,
     &6.4707E-01,7.2797E-01,8.5557E-01,1.0563E+00,1.3882E+00,1.9717E+00,
     &3.1223E+00,5.9601E+00,1.7750E+01,0.0000E+00,2.3139E-01,2.3138E-01/
      DATA (XUDF_L(K),K=  343,  456) /
     &2.3120E-01,2.3076E-01,2.3006E-01,2.2907E-01,2.2788E-01,2.2645E-01,
     &2.2489E-01,2.2308E-01,2.2120E-01,2.1929E-01,2.1743E-01,2.1630E-01,
     &2.1526E-01,2.1411E-01,2.1311E-01,2.1231E-01,2.1171E-01,2.1148E-01,
     &2.1150E-01,2.1182E-01,2.1271E-01,2.1412E-01,2.1601E-01,2.1822E-01,
     &2.2096E-01,2.2496E-01,2.2961E-01,2.3481E-01,2.4086E-01,2.4622E-01,
     &2.5214E-01,2.5891E-01,2.6537E-01,2.7104E-01,2.7588E-01,2.7922E-01,
     &2.8235E-01,2.8664E-01,2.9413E-01,3.0352E-01,3.1845E-01,3.3481E-01,
     &3.5617E-01,3.7737E-01,3.9689E-01,4.1403E-01,4.2736E-01,4.3558E-01,
     &4.3712E-01,4.3016E-01,4.1245E-01,3.8197E-01,3.3645E-01,5.0322E-01,
     &5.2507E-01,5.5559E-01,6.0172E-01,6.7286E-01,7.8413E-01,9.5797E-01,
     &1.2422E+00,1.7341E+00,2.6883E+00,4.9868E+00,1.4177E+01,0.0000E+00,
     &3.6389E-01,3.6098E-01,3.5780E-01,3.5400E-01,3.5016E-01,3.4553E-01,
     &3.4044E-01,3.3521E-01,3.2971E-01,3.2369E-01,3.1755E-01,3.1120E-01,
     &3.0494E-01,3.0120E-01,2.9724E-01,2.9287E-01,2.8855E-01,2.8449E-01,
     &2.8072E-01,2.7770E-01,2.7469E-01,2.7175E-01,2.6933E-01,2.6740E-01,
     &2.6613E-01,2.6556E-01,2.6563E-01,2.6631E-01,2.6763E-01,2.6975E-01,
     &2.7268E-01,2.7539E-01,2.7857E-01,2.8224E-01,2.8565E-01,2.8841E-01,
     &2.9040E-01,2.9139E-01,2.9220E-01,2.9395E-01,2.9888E-01,3.0633E-01,
     &3.1877E-01,3.3296E-01,3.5147E-01,3.6947E-01,3.8604E-01,3.9986E-01/
      DATA (XUDF_L(K),K=  457,  570) /
     &4.1008E-01,4.1548E-01,4.1467E-01,4.0620E-01,3.8830E-01,3.5965E-01,
     &3.1902E-01,4.7020E-01,4.8772E-01,5.1303E-01,5.5185E-01,6.1224E-01,
     &7.0699E-01,8.5323E-01,1.0903E+00,1.4950E+00,2.2640E+00,4.0723E+00,
     &0.0000E+00,0.0000E+00,5.2666E-01,5.1909E-01,5.1100E-01,5.0238E-01,
     &4.9333E-01,4.8312E-01,4.7293E-01,4.6180E-01,4.5066E-01,4.3890E-01,
     &4.2692E-01,4.1467E-01,4.0262E-01,3.9542E-01,3.8784E-01,3.7925E-01,
     &3.7080E-01,3.6267E-01,3.5482E-01,3.4841E-01,3.4190E-01,3.3492E-01,
     &3.2852E-01,3.2287E-01,3.1768E-01,3.1409E-01,3.1066E-01,3.0785E-01,
     &3.0564E-01,3.0446E-01,3.0380E-01,3.0388E-01,3.0402E-01,3.0458E-01,
     &3.0488E-01,3.0475E-01,3.0386E-01,3.0263E-01,3.0116E-01,3.0045E-01,
     &3.0296E-01,3.0852E-01,3.1888E-01,3.3085E-01,3.4677E-01,3.6222E-01,
     &3.7600E-01,3.8707E-01,3.9488E-01,3.9799E-01,3.9530E-01,3.8568E-01,
     &3.6791E-01,3.4080E-01,3.0424E-01,4.4195E-01,4.5570E-01,4.7648E-01,
     &5.0935E-01,5.6099E-01,6.4225E-01,7.6680E-01,9.6736E-01,1.3053E+00,
     &1.9393E+00,3.3976E+00,0.0000E+00,0.0000E+00,7.4015E-01,7.2498E-01,
     &7.0940E-01,6.9297E-01,6.7620E-01,6.5800E-01,6.3935E-01,6.2047E-01,
     &6.0114E-01,5.8076E-01,5.6065E-01,5.4030E-01,5.2035E-01,5.0839E-01,
     &4.9583E-01,4.8167E-01,4.6773E-01,4.5434E-01,4.4113E-01,4.3035E-01,
     &4.1922E-01,4.0719E-01,3.9582E-01,3.8536E-01,3.7557E-01,3.6805E-01/
      DATA (XUDF_L(K),K=  571,  684) /
     &3.6079E-01,3.5336E-01,3.4710E-01,3.4173E-01,3.3719E-01,3.3400E-01,
     &3.3124E-01,3.2819E-01,3.2494E-01,3.2158E-01,3.1765E-01,3.1400E-01,
     &3.1011E-01,3.0684E-01,3.0682E-01,3.1046E-01,3.1856E-01,3.2861E-01,
     &3.4189E-01,3.5475E-01,3.6597E-01,3.7463E-01,3.8003E-01,3.8108E-01,
     &3.7681E-01,3.6631E-01,3.4865E-01,3.2327E-01,2.9078E-01,4.1488E-01,
     &4.2529E-01,4.4193E-01,4.6945E-01,5.1322E-01,5.8236E-01,6.8846E-01,
     &8.5739E-01,1.1394E+00,1.6617E+00,2.8395E+00,0.0000E+00,0.0000E+00,
     &9.8501E-01,9.5975E-01,9.3420E-01,9.0757E-01,8.8092E-01,8.5237E-01,
     &8.2383E-01,7.9445E-01,7.6556E-01,7.3524E-01,7.0484E-01,6.7495E-01,
     &6.4547E-01,6.2798E-01,6.0969E-01,5.8904E-01,5.6882E-01,5.4932E-01,
     &5.3014E-01,5.1443E-01,4.9826E-01,4.8058E-01,4.6380E-01,4.4815E-01,
     &4.3330E-01,4.2167E-01,4.1020E-01,3.9827E-01,3.8748E-01,3.7784E-01,
     &3.6931E-01,3.6303E-01,3.5669E-01,3.4992E-01,3.4358E-01,3.3710E-01,
     &3.3025E-01,3.2429E-01,3.1817E-01,3.1242E-01,3.1001E-01,3.1195E-01,
     &3.1802E-01,3.2610E-01,3.3719E-01,3.4770E-01,3.5674E-01,3.6357E-01,
     &3.6695E-01,3.6631E-01,3.6075E-01,3.4960E-01,3.3214E-01,3.0855E-01,
     &2.7931E-01,3.9198E-01,3.9931E-01,4.1263E-01,4.3550E-01,4.7310E-01,
     &5.3259E-01,6.2375E-01,7.6876E-01,1.0087E+00,1.4464E+00,2.4185E+00,
     &0.0000E+00,0.0000E+00,1.2917E+00,1.2523E+00,1.2128E+00,1.1722E+00/
      DATA (XUDF_L(K),K=  685,  798) /
     &1.1321E+00,1.0894E+00,1.0473E+00,1.0044E+00,9.6262E-01,9.1838E-01,
     &8.7565E-01,8.3283E-01,7.9186E-01,7.6734E-01,7.4146E-01,7.1300E-01,
     &6.8484E-01,6.5787E-01,6.3134E-01,6.0963E-01,5.8730E-01,5.6294E-01,
     &5.3947E-01,5.1767E-01,4.9689E-01,4.8039E-01,4.6398E-01,4.4675E-01,
     &4.3087E-01,4.1650E-01,4.0371E-01,3.9342E-01,3.8361E-01,3.7293E-01,
     &3.6284E-01,3.5305E-01,3.4307E-01,3.3468E-01,3.2613E-01,3.1788E-01,
     &3.1306E-01,3.1309E-01,3.1715E-01,3.2346E-01,3.3232E-01,3.4066E-01,
     &3.4779E-01,3.5251E-01,3.5401E-01,3.5184E-01,3.4519E-01,3.3347E-01,
     &3.1650E-01,2.9433E-01,2.6872E-01,3.6968E-01,3.7446E-01,3.8477E-01,
     &4.0368E-01,4.3551E-01,4.8654E-01,5.6457E-01,6.8832E-01,8.9135E-01,
     &1.2583E+00,2.0601E+00,0.0000E+00,0.0000E+00,1.6499E+00,1.5928E+00,
     &1.5356E+00,1.4773E+00,1.4202E+00,1.3601E+00,1.3009E+00,1.2413E+00,
     &1.1836E+00,1.1235E+00,1.0650E+00,1.0076E+00,9.5212E-01,9.1919E-01,
     &8.8569E-01,8.4733E-01,8.1006E-01,7.7436E-01,7.3955E-01,7.1104E-01,
     &6.8173E-01,6.4966E-01,6.1893E-01,5.9026E-01,5.6287E-01,5.4114E-01,
     &5.1941E-01,4.9621E-01,4.7490E-01,4.5564E-01,4.3786E-01,4.2408E-01,
     &4.1024E-01,3.9562E-01,3.8175E-01,3.6853E-01,3.5541E-01,3.4455E-01,
     &3.3366E-01,3.2286E-01,3.1565E-01,3.1397E-01,3.1618E-01,3.2069E-01,
     &3.2744E-01,3.3383E-01,3.3911E-01,3.4194E-01,3.4194E-01,3.3844E-01/
      DATA (XUDF_L(K),K=  799,  912) /
     &3.3088E-01,3.1887E-01,3.0224E-01,2.8177E-01,2.5901E-01,3.4945E-01,
     &3.5200E-01,3.5959E-01,3.7518E-01,4.0212E-01,4.4590E-01,5.1305E-01,
     &6.1934E-01,7.9273E-01,1.1025E+00,1.7693E+00,0.0000E+00,0.0000E+00,
     &2.0413E+00,1.9626E+00,1.8840E+00,1.8053E+00,1.7284E+00,1.6480E+00,
     &1.5697E+00,1.4911E+00,1.4157E+00,1.3375E+00,1.2620E+00,1.1875E+00,
     &1.1168E+00,1.0751E+00,1.0321E+00,9.8410E-01,9.3682E-01,8.9196E-01,
     &8.4816E-01,8.1245E-01,7.7582E-01,7.3576E-01,6.9745E-01,6.6154E-01,
     &6.2742E-01,6.0036E-01,5.7319E-01,5.4409E-01,5.1721E-01,4.9291E-01,
     &4.7049E-01,4.5284E-01,4.3541E-01,4.1671E-01,3.9926E-01,3.8274E-01,
     &3.6660E-01,3.5348E-01,3.4035E-01,3.2727E-01,3.1788E-01,3.1459E-01,
     &3.1499E-01,3.1792E-01,3.2291E-01,3.2764E-01,3.3124E-01,3.3250E-01,
     &3.3120E-01,3.2663E-01,3.1834E-01,3.0608E-01,2.8998E-01,2.7085E-01,
     &2.5085E-01,3.3191E-01,3.3258E-01,3.3808E-01,3.5072E-01,3.7379E-01,
     &4.1182E-01,4.7005E-01,5.6257E-01,7.1233E-01,9.7788E-01,1.5412E+00,
     &0.0000E+00,0.0000E+00,2.6325E+00,2.5188E+00,2.4060E+00,2.2942E+00,
     &2.1863E+00,2.0740E+00,1.9650E+00,1.8571E+00,1.7537E+00,1.6473E+00,
     &1.5453E+00,1.4458E+00,1.3515E+00,1.2965E+00,1.2394E+00,1.1767E+00,
     &1.1150E+00,1.0560E+00,9.9927E-01,9.5301E-01,9.0565E-01,8.5400E-01,
     &8.0462E-01,7.5858E-01,7.1481E-01,6.7994E-01,6.4502E-01,6.0799E-01/
      DATA (XUDF_L(K),K=  913, 1026) /
     &5.7349E-01,5.4206E-01,5.1299E-01,4.9028E-01,4.6789E-01,4.4387E-01,
     &4.2168E-01,4.0096E-01,3.8070E-01,3.6457E-01,3.4857E-01,3.3249E-01,
     &3.2026E-01,3.1503E-01,3.1326E-01,3.1423E-01,3.1703E-01,3.1974E-01,
     &3.2120E-01,3.2086E-01,3.1799E-01,3.1221E-01,3.0315E-01,2.9072E-01,
     &2.7522E-01,2.5796E-01,2.4114E-01,3.1079E-01,3.0956E-01,3.1267E-01,
     &3.2223E-01,3.4089E-01,3.7246E-01,4.2134E-01,4.9853E-01,6.2305E-01,
     &8.4191E-01,1.2983E+00,0.0000E+00,0.0000E+00,3.2997E+00,3.1427E+00,
     &2.9900E+00,2.8374E+00,2.6927E+00,2.5421E+00,2.3973E+00,2.2549E+00,
     &2.1191E+00,1.9809E+00,1.8488E+00,1.7209E+00,1.6001E+00,1.5300E+00,
     &1.4576E+00,1.3771E+00,1.2999E+00,1.2268E+00,1.1551E+00,1.0975E+00,
     &1.0385E+00,9.7437E-01,9.1327E-01,8.5649E-01,8.0236E-01,7.5952E-01,
     &7.1667E-01,6.7091E-01,6.2847E-01,5.9005E-01,5.5422E-01,5.2636E-01,
     &4.9890E-01,4.6976E-01,4.4269E-01,4.1752E-01,3.9377E-01,3.7477E-01,
     &3.5594E-01,3.3710E-01,3.2226E-01,3.1511E-01,3.1131E-01,3.1067E-01,
     &3.1132E-01,3.1227E-01,3.1198E-01,3.1021E-01,3.0606E-01,2.9926E-01,
     &2.8958E-01,2.7716E-01,2.6233E-01,2.4655E-01,2.3275E-01,2.9229E-01,
     &2.8941E-01,2.9061E-01,2.9753E-01,3.1273E-01,3.3909E-01,3.8034E-01,
     &4.4548E-01,5.5028E-01,7.3256E-01,1.1074E+00,0.0000E+00,0.0000E+00,
     &4.0557E+00,3.8486E+00,3.6460E+00,3.4480E+00,3.2579E+00,3.0626E+00/
      DATA (XUDF_L(K),K= 1027, 1140) /
     &2.8756E+00,2.6929E+00,2.5196E+00,2.3441E+00,2.1778E+00,2.0170E+00,
     &1.8670E+00,1.7797E+00,1.6902E+00,1.5909E+00,1.4960E+00,1.4058E+00,
     &1.3191E+00,1.2484E+00,1.1764E+00,1.0991E+00,1.0253E+00,9.5689E-01,
     &8.9197E-01,8.4046E-01,7.8904E-01,7.3442E-01,6.8367E-01,6.3780E-01,
     &5.9520E-01,5.6218E-01,5.2934E-01,4.9500E-01,4.6300E-01,4.3370E-01,
     &4.0611E-01,3.8431E-01,3.6284E-01,3.4121E-01,3.2389E-01,3.1494E-01,
     &3.0926E-01,3.0697E-01,3.0594E-01,3.0501E-01,3.0330E-01,3.0019E-01,
     &2.9492E-01,2.8734E-01,2.7718E-01,2.6476E-01,2.5057E-01,2.3646E-01,
     &2.2503E-01,2.7558E-01,2.7132E-01,2.7089E-01,2.7569E-01,2.8794E-01,
     &3.1000E-01,3.4491E-01,4.0016E-01,4.8886E-01,6.4191E-01,9.5232E-01,
     &0.0000E+00,0.0000E+00,4.8799E+00,4.6116E+00,4.3560E+00,4.1035E+00,
     &3.8608E+00,3.6163E+00,3.3822E+00,3.1557E+00,2.9412E+00,2.7247E+00,
     &2.5209E+00,2.3248E+00,2.1421E+00,2.0368E+00,1.9287E+00,1.8094E+00,
     &1.6955E+00,1.5877E+00,1.4841E+00,1.4003E+00,1.3154E+00,1.2237E+00,
     &1.1368E+00,1.0563E+00,9.8015E-01,9.2005E-01,8.5978E-01,7.9615E-01,
     &7.3715E-01,6.8369E-01,6.3441E-01,5.9609E-01,5.5830E-01,5.1865E-01,
     &4.8192E-01,4.4872E-01,4.1747E-01,3.9300E-01,3.6895E-01,3.4483E-01,
     &3.2508E-01,3.1459E-01,3.0709E-01,3.0328E-01,3.0056E-01,2.9840E-01,
     &2.9543E-01,2.9107E-01,2.8485E-01,2.7655E-01,2.6610E-01,2.5368E-01/
      DATA (XUDF_L(K),K= 1141, 1254) /
     &2.4019E-01,2.2736E-01,2.1837E-01,2.6080E-01,2.5542E-01,2.5362E-01,
     &2.5693E-01,2.6661E-01,2.8505E-01,3.1490E-01,3.6226E-01,4.3798E-01,
     &5.6769E-01,8.2836E-01,0.0000E+00,0.0000E+00,5.8340E+00,5.4940E+00,
     &5.1700E+00,4.8532E+00,4.5515E+00,4.2463E+00,3.9559E+00,3.6752E+00,
     &3.4138E+00,3.1496E+00,2.9022E+00,2.6648E+00,2.4450E+00,2.3189E+00,
     &2.1896E+00,2.0476E+00,1.9120E+00,1.7843E+00,1.6621E+00,1.5639E+00,
     &1.4648E+00,1.3569E+00,1.2556E+00,1.1618E+00,1.0734E+00,1.0037E+00,
     &9.3416E-01,8.6065E-01,7.9257E-01,7.3145E-01,6.7463E-01,6.3082E-01,
     &5.8786E-01,5.4262E-01,5.0118E-01,4.6374E-01,4.2883E-01,4.0146E-01,
     &3.7490E-01,3.4814E-01,3.2612E-01,3.1397E-01,3.0482E-01,2.9958E-01,
     &2.9536E-01,2.9178E-01,2.8756E-01,2.8208E-01,2.7504E-01,2.6611E-01,
     &2.5539E-01,2.4319E-01,2.3031E-01,2.1877E-01,2.1195E-01,2.4673E-01,
     &2.4036E-01,2.3746E-01,2.3912E-01,2.4677E-01,2.6223E-01,2.8748E-01,
     &3.2792E-01,3.9255E-01,5.0271E-01,7.2095E-01,0.0000E+00,0.0000E+00,
     &6.8578E+00,6.4388E+00,6.0380E+00,5.6501E+00,5.2825E+00,4.9103E+00,
     &4.5613E+00,4.2230E+00,3.9070E+00,3.5911E+00,3.2966E+00,3.0156E+00,
     &2.7567E+00,2.6078E+00,2.4563E+00,2.2905E+00,2.1319E+00,1.9837E+00,
     &1.8421E+00,1.7287E+00,1.6141E+00,1.4902E+00,1.3730E+00,1.2663E+00,
     &1.1652E+00,1.0858E+00,1.0067E+00,9.2337E-01,8.4648E-01,7.7710E-01/
      DATA (XUDF_L(K),K= 1255, 1368) /
     &7.1333E-01,6.6392E-01,6.1566E-01,5.6531E-01,5.1904E-01,4.7761E-01,
     &4.3908E-01,4.0927E-01,3.8022E-01,3.5109E-01,3.2686E-01,3.1318E-01,
     &3.0244E-01,2.9602E-01,2.9031E-01,2.8538E-01,2.8024E-01,2.7382E-01,
     &2.6607E-01,2.5668E-01,2.4571E-01,2.3364E-01,2.2155E-01,2.1116E-01,
     &2.0617E-01,2.3421E-01,2.2704E-01,2.2320E-01,2.2366E-01,2.2952E-01,
     &2.4241E-01,2.6402E-01,2.9884E-01,3.5437E-01,4.4860E-01,6.3331E-01,
     &0.0000E+00,0.0000E+00,7.9784E+00,7.4673E+00,6.9820E+00,6.5121E+00,
     &6.0712E+00,5.6250E+00,5.2080E+00,4.8065E+00,4.4309E+00,4.0590E+00,
     &3.7131E+00,3.3843E+00,3.0816E+00,2.9094E+00,2.7332E+00,2.5420E+00,
     &2.3595E+00,2.1895E+00,2.0271E+00,1.8966E+00,1.7658E+00,1.6248E+00,
     &1.4933E+00,1.3718E+00,1.2579E+00,1.1683E+00,1.0795E+00,9.8589E-01,
     &8.9996E-01,8.2253E-01,7.5153E-01,6.9648E-01,6.4287E-01,5.8736E-01,
     &5.3655E-01,4.9109E-01,4.4891E-01,4.1655E-01,3.8518E-01,3.5367E-01,
     &3.2738E-01,3.1221E-01,3.0006E-01,2.9246E-01,2.8544E-01,2.7940E-01,
     &2.7319E-01,2.6601E-01,2.5763E-01,2.4782E-01,2.3676E-01,2.2486E-01,
     &2.1329E-01,2.0405E-01,2.0083E-01,2.2267E-01,2.1489E-01,2.1027E-01,
     &2.0967E-01,2.1409E-01,2.2473E-01,2.4320E-01,2.7316E-01,3.2113E-01,
     &4.0209E-01,5.5899E-01,0.0000E+00,0.0000E+00,9.1575E+00,8.5458E+00,
     &7.9700E+00,7.4123E+00,6.8876E+00,6.3653E+00,5.8736E+00,5.4042E+00/
      DATA (XUDF_L(K),K= 1369, 1482) /
     &4.9684E+00,4.5359E+00,4.1366E+00,3.7576E+00,3.4110E+00,3.2138E+00,
     &3.0122E+00,2.7943E+00,2.5871E+00,2.3944E+00,2.2102E+00,2.0646E+00,
     &1.9163E+00,1.7581E+00,1.6109E+00,1.4753E+00,1.3483E+00,1.2486E+00,
     &1.1500E+00,1.0462E+00,9.5130E-01,8.6585E-01,7.8770E-01,7.2741E-01,
     &6.6891E-01,6.0781E-01,5.5266E-01,5.0342E-01,4.5788E-01,4.2322E-01,
     &3.8960E-01,3.5594E-01,3.2768E-01,3.1125E-01,2.9779E-01,2.8890E-01,
     &2.8091E-01,2.7385E-01,2.6670E-01,2.5886E-01,2.4989E-01,2.3976E-01,
     &2.2861E-01,2.1703E-01,2.0604E-01,1.9777E-01,1.9598E-01,2.1238E-01,
     &2.0408E-01,1.9879E-01,1.9735E-01,2.0048E-01,2.0933E-01,2.2523E-01,
     &2.5120E-01,2.9296E-01,3.6305E-01,4.9711E-01,0.0000E+00,0.0000E+00,
     &1.0956E+01,1.0188E+01,9.4660E+00,8.7704E+00,8.1209E+00,7.4727E+00,
     &6.8721E+00,6.2972E+00,5.7646E+00,5.2434E+00,4.7595E+00,4.3051E+00,
     &3.8911E+00,3.6559E+00,3.4174E+00,3.1598E+00,2.9153E+00,2.6889E+00,
     &2.4732E+00,2.3031E+00,2.1311E+00,1.9475E+00,1.7771E+00,1.6202E+00,
     &1.4748E+00,1.3609E+00,1.2481E+00,1.1301E+00,1.0222E+00,9.2549E-01,
     &8.3728E-01,7.6947E-01,7.0373E-01,6.3561E-01,5.7438E-01,5.1959E-01,
     &4.6984E-01,4.3187E-01,3.9529E-01,3.5864E-01,3.2783E-01,3.0967E-01,
     &2.9444E-01,2.8428E-01,2.7469E-01,2.6638E-01,2.5813E-01,2.4942E-01,
     &2.3986E-01,2.2937E-01,2.1819E-01,2.0682E-01,1.9665E-01,1.8966E-01/
      DATA (XUDF_L(K),K= 1483, 1596) /
     &1.8971E-01,1.9926E-01,1.9036E-01,1.8442E-01,1.8192E-01,1.8362E-01,
     &1.9037E-01,2.0318E-01,2.2459E-01,2.5904E-01,3.1665E-01,4.2407E-01,
     &0.0000E+00,0.0000E+00,1.2798E+01,1.1861E+01,1.0986E+01,1.0144E+01,
     &9.3643E+00,8.5887E+00,7.8706E+00,7.1866E+00,6.5568E+00,5.9419E+00,
     &5.3754E+00,4.8419E+00,4.3593E+00,4.0864E+00,3.8109E+00,3.5127E+00,
     &3.2315E+00,2.9714E+00,2.7252E+00,2.5309E+00,2.3356E+00,2.1269E+00,
     &1.9338E+00,1.7578E+00,1.5939E+00,1.4656E+00,1.3394E+00,1.2075E+00,
     &1.0875E+00,9.8023E-01,8.8256E-01,8.0772E-01,7.3533E-01,6.6054E-01,
     &5.9364E-01,5.3423E-01,4.8009E-01,4.3930E-01,4.0003E-01,3.6079E-01,
     &3.2768E-01,3.0809E-01,2.9130E-01,2.7993E-01,2.6898E-01,2.5976E-01,
     &2.5062E-01,2.4123E-01,2.3116E-01,2.2040E-01,2.0917E-01,1.9814E-01,
     &1.8865E-01,1.8272E-01,1.8428E-01,1.8820E-01,1.7883E-01,1.7238E-01,
     &1.6914E-01,1.6979E-01,1.7482E-01,1.8534E-01,2.0325E-01,2.3214E-01,
     &2.8022E-01,3.6659E-01,0.0000E+00,0.0000E+00,1.4900E+01,1.3767E+01,
     &1.2708E+01,1.1700E+01,1.0766E+01,9.8403E+00,8.9832E+00,8.1757E+00,
     &7.4366E+00,6.7121E+00,6.0486E+00,5.4300E+00,4.8704E+00,4.5555E+00,
     &4.2371E+00,3.8955E+00,3.5734E+00,3.2760E+00,2.9952E+00,2.7738E+00,
     &2.5528E+00,2.3175E+00,2.1001E+00,1.9012E+00,1.7176E+00,1.5750E+00,
     &1.4344E+00,1.2880E+00,1.1547E+00,1.0364E+00,9.2859E-01,8.4652E-01/
      DATA (XUDF_L(K),K= 1597, 1710) /
     &7.6723E-01,6.8578E-01,6.1255E-01,5.4848E-01,4.9034E-01,4.4649E-01,
     &4.0456E-01,3.6275E-01,3.2738E-01,3.0624E-01,2.8805E-01,2.7544E-01,
     &2.6343E-01,2.5315E-01,2.4318E-01,2.3314E-01,2.2263E-01,2.1166E-01,
     &2.0051E-01,1.8983E-01,1.8102E-01,1.7610E-01,1.7901E-01,1.7764E-01,
     &1.6791E-01,1.6102E-01,1.5715E-01,1.5684E-01,1.6056E-01,1.6899E-01,
     &1.8376E-01,2.0786E-01,2.4776E-01,3.1470E-01,0.0000E+00,0.0000E+00,
     &1.7212E+01,1.5853E+01,1.4590E+01,1.3390E+01,1.2283E+01,1.1191E+01,
     &1.0185E+01,9.2395E+00,8.3762E+00,7.5315E+00,6.7670E+00,6.0503E+00,
     &5.4086E+00,5.0481E+00,4.6843E+00,4.2940E+00,3.9280E+00,3.5917E+00,
     &3.2752E+00,3.0252E+00,2.7768E+00,2.5132E+00,2.2690E+00,2.0490E+00,
     &1.8445E+00,1.6857E+00,1.5301E+00,1.3685E+00,1.2219E+00,1.0920E+00,
     &9.7438E-01,8.8478E-01,7.9825E-01,7.1007E-01,6.3111E-01,5.6196E-01,
     &5.0016E-01,4.5321E-01,4.0867E-01,3.6435E-01,3.2686E-01,3.0431E-01,
     &2.8470E-01,2.7109E-01,2.5789E-01,2.4674E-01,2.3605E-01,2.2547E-01,
     &2.1459E-01,2.0348E-01,1.9237E-01,1.8201E-01,1.7376E-01,1.6982E-01,
     &1.7398E-01,1.6789E-01,1.5795E-01,1.5065E-01,1.4630E-01,1.4521E-01,
     &1.4773E-01,1.5443E-01,1.6659E-01,1.8664E-01,2.1966E-01,2.6878E-01,
     &0.0000E+00,0.0000E+00,1.9526E+01,1.7951E+01,1.6470E+01,1.5074E+01,
     &1.3790E+01,1.2527E+01,1.1370E+01,1.0282E+01,9.2958E+00,8.3330E+00/
      DATA (XUDF_L(K),K= 1711, 1824) /
     &7.4603E+00,6.6536E+00,5.9285E+00,5.5219E+00,5.1141E+00,4.6768E+00,
     &4.2681E+00,3.8926E+00,3.5402E+00,3.2626E+00,2.9882E+00,2.6963E+00,
     &2.4284E+00,2.1851E+00,1.9619E+00,1.7885E+00,1.6187E+00,1.4429E+00,
     &1.2838E+00,1.1431E+00,1.0159E+00,9.1924E-01,8.2663E-01,7.3180E-01,
     &6.4793E-01,5.7429E-01,5.0828E-01,4.5904E-01,4.1215E-01,3.6558E-01,
     &3.2620E-01,3.0238E-01,2.8167E-01,2.6700E-01,2.5302E-01,2.4098E-01,
     &2.2975E-01,2.1873E-01,2.0756E-01,1.9633E-01,1.8532E-01,1.7533E-01,
     &1.6763E-01,1.6450E-01,1.6959E-01,1.5953E-01,1.4943E-01,1.4185E-01,
     &1.3716E-01,1.3545E-01,1.3705E-01,1.4238E-01,1.5258E-01,1.6945E-01,
     &1.9705E-01,2.3049E-01,0.0000E+00,0.0000E+00,2.2141E+01,2.0286E+01,
     &1.8570E+01,1.6948E+01,1.5466E+01,1.4010E+01,1.2679E+01,1.1431E+01,
     &1.0303E+01,9.2106E+00,8.2239E+00,7.3077E+00,6.4926E+00,6.0348E+00,
     &5.5765E+00,5.0879E+00,4.6321E+00,4.2138E+00,3.8233E+00,3.5162E+00,
     &3.2122E+00,2.8907E+00,2.5960E+00,2.3300E+00,2.0856E+00,1.8954E+00,
     &1.7110E+00,1.5199E+00,1.3476E+00,1.1955E+00,1.0584E+00,9.5478E-01,
     &8.5531E-01,7.5417E-01,6.6439E-01,5.8623E-01,5.1682E-01,4.6468E-01,
     &4.1541E-01,3.6662E-01,3.2538E-01,3.0035E-01,2.7843E-01,2.6291E-01,
     &2.4798E-01,2.3522E-01,2.2346E-01,2.1203E-01,2.0062E-01,1.8935E-01,
     &1.7843E-01,1.6874E-01,1.6163E-01,1.5920E-01,1.6520E-01,1.5147E-01/
      DATA (XUDF_L(K),K= 1825, 1836) /
     &1.4120E-01,1.3349E-01,1.2844E-01,1.2620E-01,1.2701E-01,1.3118E-01,
     &1.3954E-01,1.5369E-01,1.7631E-01,1.9416E-01,0.0000E+00,0.0000E+00/
      DATA (XSF_L(K),K=    1,  114) /
     &8.9277E-03,9.2838E-03,9.6380E-03,9.9960E-03,1.0349E-02,1.0719E-02,
     &1.1082E-02,1.1442E-02,1.1792E-02,1.2148E-02,1.2489E-02,1.2817E-02,
     &1.3124E-02,1.3295E-02,1.3474E-02,1.3661E-02,1.3835E-02,1.3985E-02,
     &1.4121E-02,1.4217E-02,1.4303E-02,1.4379E-02,1.4419E-02,1.4434E-02,
     &1.4412E-02,1.4366E-02,1.4286E-02,1.4158E-02,1.3991E-02,1.3790E-02,
     &1.3553E-02,1.3335E-02,1.3094E-02,1.2821E-02,1.2580E-02,1.2410E-02,
     &1.2357E-02,1.2459E-02,1.2790E-02,1.3571E-02,1.5018E-02,1.6665E-02,
     &1.9113E-02,2.1832E-02,2.5587E-02,2.9818E-02,3.4535E-02,3.9813E-02,
     &4.5737E-02,5.2358E-02,5.9765E-02,6.8021E-02,7.7185E-02,8.7258E-02,
     &9.8198E-02,1.1073E-01,1.4216E-01,1.8364E-01,2.3959E-01,3.1758E-01,
     &4.3050E-01,6.0203E-01,8.8214E-01,1.3845E+00,2.4294E+00,5.2463E+00,
     &1.8903E+01,0.0000E+00,1.4987E-02,1.5468E-02,1.5936E-02,1.6403E-02,
     &1.6855E-02,1.7319E-02,1.7760E-02,1.8194E-02,1.8600E-02,1.9008E-02,
     &1.9382E-02,1.9730E-02,2.0033E-02,2.0199E-02,2.0359E-02,2.0523E-02,
     &2.0654E-02,2.0760E-02,2.0831E-02,2.0870E-02,2.0886E-02,2.0858E-02,
     &2.0798E-02,2.0680E-02,2.0523E-02,2.0363E-02,2.0127E-02,1.9825E-02,
     &1.9464E-02,1.9060E-02,1.8607E-02,1.8200E-02,1.7750E-02,1.7240E-02,
     &1.6759E-02,1.6362E-02,1.6103E-02,1.6050E-02,1.6240E-02,1.6916E-02,
     &1.8336E-02,2.0030E-02,2.2586E-02,2.5447E-02,2.9418E-02,3.3874E-02/
      DATA (XSF_L(K),K=  115,  228) /
     &3.8821E-02,4.4375E-02,5.0509E-02,5.7343E-02,6.4974E-02,7.3385E-02,
     &8.2640E-02,9.2732E-02,1.0354E-01,1.1667E-01,1.4809E-01,1.8910E-01,
     &2.4387E-01,3.1940E-01,4.2764E-01,5.9054E-01,8.5228E-01,1.3150E+00,
     &2.2623E+00,4.7596E+00,1.6445E+01,0.0000E+00,2.5010E-02,2.5616E-02,
     &2.6180E-02,2.6758E-02,2.7279E-02,2.7792E-02,2.8274E-02,2.8729E-02,
     &2.9134E-02,2.9513E-02,2.9836E-02,3.0110E-02,3.0324E-02,3.0417E-02,
     &3.0492E-02,3.0537E-02,3.0551E-02,3.0517E-02,3.0432E-02,3.0326E-02,
     &3.0181E-02,2.9954E-02,2.9663E-02,2.9316E-02,2.8913E-02,2.8508E-02,
     &2.8021E-02,2.7422E-02,2.6741E-02,2.5997E-02,2.5204E-02,2.4500E-02,
     &2.3734E-02,2.2858E-02,2.2019E-02,2.1281E-02,2.0698E-02,2.0402E-02,
     &2.0365E-02,2.0844E-02,2.2137E-02,2.3807E-02,2.6404E-02,2.9338E-02,
     &3.3433E-02,3.8036E-02,4.3135E-02,4.8799E-02,5.5061E-02,6.1999E-02,
     &6.9633E-02,7.8024E-02,8.7156E-02,9.6998E-02,1.0742E-01,1.2099E-01,
     &1.5162E-01,1.9121E-01,2.4363E-01,3.1510E-01,4.1638E-01,5.6669E-01,
     &8.0557E-01,1.2216E+00,2.0572E+00,4.2084E+00,1.3911E+01,0.0000E+00,
     &4.2554E-02,4.3210E-02,4.3820E-02,4.4379E-02,4.4862E-02,4.5317E-02,
     &4.5708E-02,4.6037E-02,4.6300E-02,4.6434E-02,4.6540E-02,4.6530E-02,
     &4.6426E-02,4.6317E-02,4.6155E-02,4.5919E-02,4.5622E-02,4.5267E-02,
     &4.4833E-02,4.4425E-02,4.3932E-02,4.3298E-02,4.2582E-02,4.1785E-02/
      DATA (XSF_L(K),K=  229,  342) /
     &4.0903E-02,4.0097E-02,3.9179E-02,3.8047E-02,3.6815E-02,3.5547E-02,
     &3.4199E-02,3.3020E-02,3.1748E-02,3.0298E-02,2.8905E-02,2.7644E-02,
     &2.6563E-02,2.5882E-02,2.5485E-02,2.5614E-02,2.6651E-02,2.8199E-02,
     &3.0731E-02,3.3652E-02,3.7768E-02,4.2390E-02,4.7530E-02,5.3188E-02,
     &5.9436E-02,6.6257E-02,7.3734E-02,8.1918E-02,9.0696E-02,1.0004E-01,
     &1.0978E-01,1.2357E-01,1.5274E-01,1.8999E-01,2.3888E-01,3.0452E-01,
     &3.9656E-01,5.3136E-01,7.4246E-01,1.1043E+00,1.8158E+00,3.6023E+00,
     &0.0000E+00,0.0000E+00,7.3602E-02,7.4085E-02,7.4460E-02,7.4729E-02,
     &7.4904E-02,7.4982E-02,7.4902E-02,7.4713E-02,7.4446E-02,7.3972E-02,
     &7.3397E-02,7.2626E-02,7.1803E-02,7.1200E-02,7.0479E-02,6.9610E-02,
     &6.8654E-02,6.7624E-02,6.6495E-02,6.5467E-02,6.4313E-02,6.2898E-02,
     &6.1380E-02,5.9788E-02,5.8079E-02,5.6557E-02,5.4876E-02,5.2866E-02,
     &5.0733E-02,4.8592E-02,4.6341E-02,4.4415E-02,4.2370E-02,4.0073E-02,
     &3.7825E-02,3.5778E-02,3.3956E-02,3.2702E-02,3.1749E-02,3.1334E-02,
     &3.1922E-02,3.3216E-02,3.5534E-02,3.8322E-02,4.2321E-02,4.6830E-02,
     &5.1816E-02,5.7335E-02,6.3369E-02,6.9947E-02,7.7109E-02,8.4752E-02,
     &9.2948E-02,1.0153E-01,1.1031E-01,1.2405E-01,1.5100E-01,1.8509E-01,
     &2.2905E-01,2.8761E-01,3.6847E-01,4.8537E-01,6.6543E-01,9.6831E-01,
     &1.5524E+00,2.9766E+00,0.0000E+00,0.0000E+00,1.1509E-01,1.1500E-01/
      DATA (XSF_L(K),K=  343,  456) /
     &1.1474E-01,1.1430E-01,1.1371E-01,1.1292E-01,1.1196E-01,1.1079E-01,
     &1.0948E-01,1.0791E-01,1.0620E-01,1.0426E-01,1.0215E-01,1.0076E-01,
     &9.9224E-02,9.7466E-02,9.5472E-02,9.3507E-02,9.1346E-02,8.9460E-02,
     &8.7382E-02,8.4914E-02,8.2326E-02,7.9663E-02,7.6874E-02,7.4459E-02,
     &7.1794E-02,6.8694E-02,6.5489E-02,6.2266E-02,5.8964E-02,5.6164E-02,
     &5.3226E-02,4.9916E-02,4.6721E-02,4.3794E-02,4.1128E-02,3.9225E-02,
     &3.7654E-02,3.6613E-02,3.6666E-02,3.7626E-02,3.9655E-02,4.2227E-02,
     &4.6000E-02,5.0288E-02,5.5044E-02,6.0308E-02,6.6020E-02,7.2218E-02,
     &7.8943E-02,8.6079E-02,9.3611E-02,1.0141E-01,1.0925E-01,1.2274E-01,
     &1.4748E-01,1.7840E-01,2.1791E-01,2.6997E-01,3.4109E-01,4.4280E-01,
     &5.9706E-01,8.5325E-01,1.3371E+00,2.4909E+00,0.0000E+00,0.0000E+00,
     &1.8131E-01,1.7986E-01,1.7802E-01,1.7597E-01,1.7372E-01,1.7110E-01,
     &1.6825E-01,1.6515E-01,1.6187E-01,1.5820E-01,1.5428E-01,1.5016E-01,
     &1.4582E-01,1.4314E-01,1.4017E-01,1.3677E-01,1.3315E-01,1.2951E-01,
     &1.2571E-01,1.2248E-01,1.1891E-01,1.1472E-01,1.1045E-01,1.0615E-01,
     &1.0173E-01,9.7944E-02,9.3854E-02,8.9131E-02,8.4347E-02,7.9597E-02,
     &7.4799E-02,7.0788E-02,6.6599E-02,6.1932E-02,5.7438E-02,5.3307E-02,
     &4.9546E-02,4.6816E-02,4.4417E-02,4.2536E-02,4.1862E-02,4.2361E-02,
     &4.3960E-02,4.6198E-02,4.9612E-02,5.3553E-02,5.7974E-02,6.2830E-02/
      DATA (XSF_L(K),K=  457,  570) /
     &6.8141E-02,7.3865E-02,7.9970E-02,8.6422E-02,9.3160E-02,1.0006E-01,
     &1.0685E-01,1.1989E-01,1.4199E-01,1.6937E-01,2.0407E-01,2.4925E-01,
     &3.1029E-01,3.9635E-01,5.2529E-01,7.3579E-01,1.1263E+00,2.0347E+00,
     &0.0000E+00,0.0000E+00,2.6278E-01,2.5883E-01,2.5460E-01,2.5007E-01,
     &2.4526E-01,2.3995E-01,2.3437E-01,2.2848E-01,2.2242E-01,2.1578E-01,
     &2.0894E-01,2.0181E-01,1.9465E-01,1.9018E-01,1.8540E-01,1.7984E-01,
     &1.7415E-01,1.6846E-01,1.6261E-01,1.5768E-01,1.5234E-01,1.4615E-01,
     &1.3987E-01,1.3368E-01,1.2736E-01,1.2199E-01,1.1628E-01,1.0975E-01,
     &1.0321E-01,9.6788E-02,9.0380E-02,8.5059E-02,7.9532E-02,7.3436E-02,
     &6.7594E-02,6.2243E-02,5.7363E-02,5.3720E-02,5.0502E-02,4.7772E-02,
     &4.6346E-02,4.6358E-02,4.7497E-02,4.9377E-02,5.2401E-02,5.5965E-02,
     &6.0009E-02,6.4489E-02,6.9334E-02,7.4546E-02,8.0117E-02,8.5936E-02,
     &9.1972E-02,9.8056E-02,1.0398E-01,1.1644E-01,1.3628E-01,1.6068E-01,
     &1.9127E-01,2.3085E-01,2.8377E-01,3.5756E-01,4.6698E-01,6.4315E-01,
     &9.6485E-01,1.6969E+00,0.0000E+00,0.0000E+00,3.6944E-01,3.6187E-01,
     &3.5380E-01,3.4525E-01,3.3659E-01,3.2716E-01,3.1761E-01,3.0767E-01,
     &2.9759E-01,2.8675E-01,2.7586E-01,2.6462E-01,2.5339E-01,2.4660E-01,
     &2.3933E-01,2.3101E-01,2.2257E-01,2.1415E-01,2.0571E-01,1.9854E-01,
     &1.9083E-01,1.8216E-01,1.7338E-01,1.6480E-01,1.5613E-01,1.4885E-01/
      DATA (XSF_L(K),K=  571,  684) /
     &1.4115E-01,1.3244E-01,1.2380E-01,1.1542E-01,1.0713E-01,1.0031E-01,
     &9.3226E-02,8.5515E-02,7.8171E-02,7.1449E-02,6.5307E-02,6.0723E-02,
     &5.6523E-02,5.2878E-02,5.0622E-02,5.0109E-02,5.0720E-02,5.2187E-02,
     &5.4770E-02,5.7950E-02,6.1582E-02,6.5595E-02,6.9997E-02,7.4716E-02,
     &7.9677E-02,8.4886E-02,9.0221E-02,9.5543E-02,1.0065E-01,1.1245E-01,
     &1.3012E-01,1.5166E-01,1.7859E-01,2.1305E-01,2.5881E-01,3.2188E-01,
     &4.1454E-01,5.6186E-01,8.2718E-01,1.4188E+00,0.0000E+00,0.0000E+00,
     &4.9195E-01,4.7916E-01,4.6620E-01,4.5277E-01,4.3908E-01,4.2463E-01,
     &4.0985E-01,3.9491E-01,3.7975E-01,3.6377E-01,3.4790E-01,3.3178E-01,
     &3.1592E-01,3.0640E-01,2.9622E-01,2.8462E-01,2.7303E-01,2.6160E-01,
     &2.5012E-01,2.4047E-01,2.3023E-01,2.1867E-01,2.0717E-01,1.9597E-01,
     &1.8477E-01,1.7546E-01,1.6568E-01,1.5468E-01,1.4387E-01,1.3343E-01,
     &1.2319E-01,1.1482E-01,1.0622E-01,9.6828E-02,8.7978E-02,7.9884E-02,
     &7.2526E-02,6.6973E-02,6.1948E-02,5.7359E-02,5.4304E-02,5.3263E-02,
     &5.3381E-02,5.4456E-02,5.6601E-02,5.9380E-02,6.2613E-02,6.6252E-02,
     &7.0174E-02,7.4432E-02,7.8943E-02,8.3559E-02,8.8282E-02,9.2963E-02,
     &9.7382E-02,1.0858E-01,1.2441E-01,1.4363E-01,1.6745E-01,1.9778E-01,
     &2.3771E-01,2.9246E-01,3.7200E-01,4.9738E-01,7.2010E-01,1.2083E+00,
     &0.0000E+00,0.0000E+00,6.4521E-01,6.2534E-01,6.0540E-01,5.8499E-01/
      DATA (XSF_L(K),K=  685,  798) /
     &5.6467E-01,5.4301E-01,5.2143E-01,4.9951E-01,4.7813E-01,4.5538E-01,
     &4.3325E-01,4.1083E-01,3.8899E-01,3.7591E-01,3.6210E-01,3.4648E-01,
     &3.3091E-01,3.1578E-01,3.0062E-01,2.8797E-01,2.7469E-01,2.5979E-01,
     &2.4501E-01,2.3066E-01,2.1649E-01,2.0481E-01,1.9252E-01,1.7884E-01,
     &1.6549E-01,1.5274E-01,1.4029E-01,1.3018E-01,1.1985E-01,1.0865E-01,
     &9.8135E-02,8.8550E-02,7.9829E-02,7.3318E-02,6.7269E-02,6.1748E-02,
     &5.7838E-02,5.6250E-02,5.5826E-02,5.6474E-02,5.8181E-02,6.0533E-02,
     &6.3373E-02,6.6563E-02,7.0085E-02,7.3865E-02,7.7842E-02,8.1937E-02,
     &8.6092E-02,9.0169E-02,9.3962E-02,1.0448E-01,1.1858E-01,1.3561E-01,
     &1.5663E-01,1.8318E-01,2.1803E-01,2.6529E-01,3.3349E-01,4.3985E-01,
     &6.2661E-01,1.0291E+00,0.0000E+00,0.0000E+00,8.2462E-01,7.9558E-01,
     &7.6680E-01,7.3764E-01,7.0860E-01,6.7834E-01,6.4822E-01,6.1798E-01,
     &5.8880E-01,5.5792E-01,5.2800E-01,4.9801E-01,4.6912E-01,4.5197E-01,
     &4.3393E-01,4.1360E-01,3.9348E-01,3.7394E-01,3.5462E-01,3.3856E-01,
     &3.2180E-01,3.0303E-01,2.8460E-01,2.6681E-01,2.4932E-01,2.3502E-01,
     &2.2005E-01,2.0359E-01,1.8747E-01,1.7224E-01,1.5746E-01,1.4551E-01,
     &1.3337E-01,1.2028E-01,1.0805E-01,9.6986E-02,8.6877E-02,7.9334E-02,
     &7.2326E-02,6.5799E-02,6.1060E-02,5.8911E-02,5.7957E-02,5.8189E-02,
     &5.9441E-02,6.1387E-02,6.3834E-02,6.6632E-02,6.9732E-02,7.3070E-02/
      DATA (XSF_L(K),K=  799,  912) /
     &7.6595E-02,8.0190E-02,8.3816E-02,8.7358E-02,9.0631E-02,1.0046E-01,
     &1.1304E-01,1.2815E-01,1.4670E-01,1.7006E-01,2.0049E-01,2.4154E-01,
     &3.0039E-01,3.9121E-01,5.4894E-01,8.8378E-01,0.0000E+00,0.0000E+00,
     &1.0199E+00,9.8025E-01,9.4100E-01,9.0151E-01,8.6283E-01,8.2243E-01,
     &7.8262E-01,7.4321E-01,7.0465E-01,6.6494E-01,6.2647E-01,5.8811E-01,
     &5.5152E-01,5.2985E-01,5.0721E-01,4.8183E-01,4.5681E-01,4.3274E-01,
     &4.0883E-01,3.8916E-01,3.6878E-01,3.4589E-01,3.2366E-01,3.0238E-01,
     &2.8152E-01,2.6437E-01,2.4685E-01,2.2733E-01,2.0858E-01,1.9085E-01,
     &1.7375E-01,1.6000E-01,1.4607E-01,1.3115E-01,1.1722E-01,1.0469E-01,
     &9.3284E-02,8.4739E-02,7.6803E-02,6.9420E-02,6.3844E-02,6.1178E-02,
     &5.9720E-02,5.9561E-02,6.0398E-02,6.1984E-02,6.4051E-02,6.6494E-02,
     &6.9202E-02,7.2161E-02,7.5274E-02,7.8453E-02,8.1651E-02,8.4728E-02,
     &8.7564E-02,9.6777E-02,1.0806E-01,1.2157E-01,1.3806E-01,1.5882E-01,
     &1.8566E-01,2.2170E-01,2.7301E-01,3.5168E-01,4.8696E-01,7.7010E-01,
     &0.0000E+00,0.0000E+00,1.3158E+00,1.2585E+00,1.2024E+00,1.1462E+00,
     &1.0919E+00,1.0352E+00,9.8042E-01,9.2608E-01,8.7345E-01,8.1987E-01,
     &7.6814E-01,7.1724E-01,6.6882E-01,6.4053E-01,6.1093E-01,5.7796E-01,
     &5.4572E-01,5.1470E-01,4.8433E-01,4.5934E-01,4.3358E-01,4.0495E-01,
     &3.7717E-01,3.5082E-01,3.2513E-01,3.0408E-01,2.8258E-01,2.5918E-01/
      DATA (XSF_L(K),K=  913, 1026) /
     &2.3648E-01,2.1538E-01,1.9510E-01,1.7888E-01,1.6255E-01,1.4508E-01,
     &1.2895E-01,1.1443E-01,1.0131E-01,9.1507E-02,8.2387E-02,7.3778E-02,
     &6.7147E-02,6.3813E-02,6.1721E-02,6.1065E-02,6.1373E-02,6.2475E-02,
     &6.4105E-02,6.6079E-02,6.8362E-02,7.0856E-02,7.3440E-02,7.6143E-02,
     &7.8812E-02,8.1388E-02,8.3726E-02,9.2167E-02,1.0190E-01,1.1355E-01,
     &1.2780E-01,1.4554E-01,1.6841E-01,1.9900E-01,2.4223E-01,3.0775E-01,
     &4.1920E-01,6.4849E-01,0.0000E+00,0.0000E+00,1.6483E+00,1.5703E+00,
     &1.4940E+00,1.4180E+00,1.3449E+00,1.2694E+00,1.1966E+00,1.1250E+00,
     &1.0566E+00,9.8644E-01,9.1985E-01,8.5482E-01,7.9312E-01,7.5722E-01,
     &7.1986E-01,6.7849E-01,6.3821E-01,5.9972E-01,5.6214E-01,5.3143E-01,
     &4.9987E-01,4.6500E-01,4.3136E-01,3.9956E-01,3.6875E-01,3.4379E-01,
     &3.1832E-01,2.9044E-01,2.6397E-01,2.3923E-01,2.1580E-01,1.9706E-01,
     &1.7829E-01,1.5838E-01,1.3999E-01,1.2356E-01,1.0875E-01,9.7664E-02,
     &8.7392E-02,7.7645E-02,7.0035E-02,6.6062E-02,6.3365E-02,6.2239E-02,
     &6.2062E-02,6.2731E-02,6.3942E-02,6.5526E-02,6.7390E-02,6.9436E-02,
     &7.1635E-02,7.3891E-02,7.6122E-02,7.8246E-02,8.0196E-02,8.7884E-02,
     &9.6357E-02,1.0648E-01,1.1880E-01,1.3413E-01,1.5386E-01,1.7993E-01,
     &2.1655E-01,2.7189E-01,3.6486E-01,5.5332E-01,0.0000E+00,0.0000E+00,
     &2.0271E+00,1.9234E+00,1.8224E+00,1.7226E+00,1.6272E+00,1.5293E+00/
      DATA (XSF_L(K),K= 1027, 1140) /
     &1.4356E+00,1.3438E+00,1.2568E+00,1.1682E+00,1.0841E+00,1.0026E+00,
     &9.2625E-01,8.8207E-01,8.3568E-01,7.8523E-01,7.3607E-01,6.8926E-01,
     &6.4385E-01,6.0685E-01,5.6892E-01,5.2730E-01,4.8731E-01,4.4961E-01,
     &4.1331E-01,3.8417E-01,3.5441E-01,3.2210E-01,2.9168E-01,2.6323E-01,
     &2.3631E-01,2.1500E-01,1.9374E-01,1.7129E-01,1.5067E-01,1.3231E-01,
     &1.1579E-01,1.0349E-01,9.2080E-02,8.1205E-02,7.2626E-02,6.8039E-02,
     &6.4761E-02,6.3188E-02,6.2549E-02,6.2795E-02,6.3617E-02,6.4835E-02,
     &6.6329E-02,6.8017E-02,6.9809E-02,7.1667E-02,7.3520E-02,7.5270E-02,
     &7.6864E-02,8.3899E-02,9.1206E-02,1.0002E-01,1.1070E-01,1.2399E-01,
     &1.4094E-01,1.6341E-01,1.9474E-01,2.4163E-01,3.1971E-01,4.7587E-01,
     &0.0000E+00,0.0000E+00,2.4392E+00,2.3049E+00,2.1760E+00,2.0502E+00,
     &1.9296E+00,1.8065E+00,1.6895E+00,1.5750E+00,1.4674E+00,1.3585E+00,
     &1.2554E+00,1.1565E+00,1.0638E+00,1.0103E+00,9.5527E-01,8.9449E-01,
     &8.3572E-01,7.8018E-01,7.2635E-01,6.8280E-01,6.3819E-01,5.8948E-01,
     &5.4299E-01,4.9923E-01,4.5740E-01,4.2371E-01,3.8978E-01,3.5296E-01,
     &3.1832E-01,2.8629E-01,2.5599E-01,2.3212E-01,2.0840E-01,1.8346E-01,
     &1.6065E-01,1.4043E-01,1.2229E-01,1.0880E-01,9.6294E-02,8.4335E-02,
     &7.4905E-02,6.9717E-02,6.5897E-02,6.3914E-02,6.2851E-02,6.2731E-02,
     &6.3183E-02,6.4075E-02,6.5225E-02,6.6597E-02,6.8048E-02,6.9577E-02/
      DATA (XSF_L(K),K= 1141, 1254) /
     &7.1093E-02,7.2525E-02,7.3842E-02,8.0241E-02,8.6615E-02,9.4292E-02,
     &1.0360E-01,1.1517E-01,1.2992E-01,1.4936E-01,1.7633E-01,2.1652E-01,
     &2.8294E-01,4.1389E-01,0.0000E+00,0.0000E+00,2.9162E+00,2.7470E+00,
     &2.5840E+00,2.4244E+00,2.2743E+00,2.1215E+00,1.9764E+00,1.8358E+00,
     &1.7035E+00,1.5708E+00,1.4463E+00,1.3268E+00,1.2152E+00,1.1514E+00,
     &1.0857E+00,1.0132E+00,9.4449E-01,8.7867E-01,8.1556E-01,7.6453E-01,
     &7.1252E-01,6.5602E-01,6.0218E-01,5.5192E-01,5.0387E-01,4.6545E-01,
     &4.2679E-01,3.8521E-01,3.4602E-01,3.1005E-01,2.7623E-01,2.4962E-01,
     &2.2332E-01,1.9577E-01,1.7070E-01,1.4856E-01,1.2874E-01,1.1402E-01,
     &1.0040E-01,8.7343E-02,7.6984E-02,7.1254E-02,6.6892E-02,6.4508E-02,
     &6.3019E-02,6.2518E-02,6.2667E-02,6.3211E-02,6.4031E-02,6.5064E-02,
     &6.6243E-02,6.7458E-02,6.8679E-02,6.9830E-02,7.0885E-02,7.6672E-02,
     &8.2192E-02,8.8844E-02,9.6930E-02,1.0696E-01,1.1972E-01,1.3654E-01,
     &1.5978E-01,1.9411E-01,2.5048E-01,3.6023E-01,0.0000E+00,0.0000E+00,
     &3.4281E+00,3.2194E+00,3.0180E+00,2.8239E+00,2.6400E+00,2.4537E+00,
     &2.2781E+00,2.1087E+00,1.9503E+00,1.7915E+00,1.6433E+00,1.5021E+00,
     &1.3711E+00,1.2958E+00,1.2191E+00,1.1350E+00,1.0536E+00,9.7846E-01,
     &9.0526E-01,8.4668E-01,7.8697E-01,7.2243E-01,6.6110E-01,6.0402E-01,
     &5.4971E-01,5.0652E-01,4.6307E-01,4.1647E-01,3.7287E-01,3.3288E-01/
      DATA (XSF_L(K),K= 1255, 1368) /
     &2.9545E-01,2.6636E-01,2.3751E-01,2.0740E-01,1.8012E-01,1.5611E-01,
     &1.3467E-01,1.1881E-01,1.0414E-01,9.0105E-02,7.8839E-02,7.2563E-02,
     &6.7703E-02,6.4930E-02,6.3070E-02,6.2241E-02,6.2071E-02,6.2347E-02,
     &6.2882E-02,6.3645E-02,6.4526E-02,6.5473E-02,6.6427E-02,6.7333E-02,
     &6.8194E-02,7.3430E-02,7.8217E-02,8.3974E-02,9.1017E-02,9.9745E-02,
     &1.1088E-01,1.2552E-01,1.4563E-01,1.7528E-01,2.2351E-01,3.1636E-01,
     &0.0000E+00,0.0000E+00,3.9892E+00,3.7328E+00,3.4900E+00,3.2549E+00,
     &3.0344E+00,2.8108E+00,2.6014E+00,2.4001E+00,2.2123E+00,2.0253E+00,
     &1.8518E+00,1.6860E+00,1.5339E+00,1.4463E+00,1.3575E+00,1.2608E+00,
     &1.1678E+00,1.0809E+00,9.9767E-01,9.3087E-01,8.6314E-01,7.8996E-01,
     &7.2083E-01,6.5671E-01,5.9602E-01,5.4775E-01,4.9935E-01,4.4773E-01,
     &3.9951E-01,3.5571E-01,3.1467E-01,2.8272E-01,2.5135E-01,2.1871E-01,
     &1.8923E-01,1.6331E-01,1.4031E-01,1.2332E-01,1.0762E-01,9.2560E-02,
     &8.0473E-02,7.3714E-02,6.8385E-02,6.5246E-02,6.3019E-02,6.1878E-02,
     &6.1420E-02,6.1413E-02,6.1734E-02,6.2226E-02,6.2861E-02,6.3564E-02,
     &6.4288E-02,6.4985E-02,6.5657E-02,7.0367E-02,7.4522E-02,7.9506E-02,
     &8.5651E-02,9.3297E-02,1.0298E-01,1.1572E-01,1.3323E-01,1.5884E-01,
     &2.0039E-01,2.7925E-01,0.0000E+00,0.0000E+00,4.5788E+00,4.2729E+00,
     &3.9840E+00,3.7039E+00,3.4438E+00,3.1812E+00,2.9349E+00,2.6996E+00/
      DATA (XSF_L(K),K= 1369, 1482) /
     &2.4810E+00,2.2644E+00,2.0633E+00,1.8732E+00,1.6979E+00,1.5988E+00,
     &1.4974E+00,1.3865E+00,1.2812E+00,1.1834E+00,1.0891E+00,1.0143E+00,
     &9.3839E-01,8.5662E-01,7.7948E-01,7.0838E-01,6.4106E-01,5.8780E-01,
     &5.3454E-01,4.7781E-01,4.2528E-01,3.7737E-01,3.3289E-01,2.9818E-01,
     &2.6446E-01,2.2932E-01,1.9770E-01,1.7005E-01,1.4552E-01,1.2746E-01,
     &1.1078E-01,9.4770E-02,8.1957E-02,7.4689E-02,6.8915E-02,6.5457E-02,
     &6.2902E-02,6.1493E-02,6.0768E-02,6.0515E-02,6.0585E-02,6.0863E-02,
     &6.1298E-02,6.1789E-02,6.2311E-02,6.2835E-02,6.3340E-02,6.7601E-02,
     &7.1162E-02,7.5516E-02,8.0878E-02,8.7566E-02,9.6095E-02,1.0725E-01,
     &1.2258E-01,1.4495E-01,1.8090E-01,2.4841E-01,0.0000E+00,0.0000E+00,
     &5.4774E+00,5.0929E+00,4.7320E+00,4.3841E+00,4.0592E+00,3.7350E+00,
     &3.4329E+00,3.1454E+00,2.8799E+00,2.6172E+00,2.3747E+00,2.1466E+00,
     &1.9383E+00,1.8195E+00,1.6996E+00,1.5689E+00,1.4457E+00,1.3301E+00,
     &1.2211E+00,1.1339E+00,1.0456E+00,9.5119E-01,8.6259E-01,7.8097E-01,
     &7.0419E-01,6.4380E-01,5.8358E-01,5.1955E-01,4.6051E-01,4.0719E-01,
     &3.5768E-01,3.1962E-01,2.8220E-01,2.4360E-01,2.0909E-01,1.7895E-01,
     &1.5240E-01,1.3282E-01,1.1484E-01,9.7655E-02,8.3739E-02,7.5857E-02,
     &6.9509E-02,6.5616E-02,6.2633E-02,6.0853E-02,5.9819E-02,5.9271E-02,
     &5.9038E-02,5.9046E-02,5.9192E-02,5.9432E-02,5.9709E-02,6.0008E-02/
      DATA (XSF_L(K),K= 1483, 1596) /
     &6.0340E-02,6.4032E-02,6.6851E-02,7.0446E-02,7.4870E-02,8.0457E-02,
     &8.7554E-02,9.6862E-02,1.0964E-01,1.2821E-01,1.5779E-01,2.1189E-01,
     &0.0000E+00,0.0000E+00,6.3982E+00,5.9307E+00,5.4920E+00,5.0710E+00,
     &4.6822E+00,4.2915E+00,3.9337E+00,3.5898E+00,3.2756E+00,2.9660E+00,
     &2.6817E+00,2.4150E+00,2.1724E+00,2.0348E+00,1.8961E+00,1.7457E+00,
     &1.6034E+00,1.4714E+00,1.3471E+00,1.2473E+00,1.1476E+00,1.0408E+00,
     &9.4083E-01,8.4932E-01,7.6350E-01,6.9606E-01,6.2897E-01,5.5833E-01,
     &4.9315E-01,4.3444E-01,3.8044E-01,3.3861E-01,2.9817E-01,2.5642E-01,
     &2.1917E-01,1.8685E-01,1.5838E-01,1.3752E-01,1.1831E-01,9.9987E-02,
     &8.5224E-02,7.6762E-02,6.9910E-02,6.5655E-02,6.2297E-02,6.0213E-02,
     &5.8897E-02,5.8096E-02,5.7624E-02,5.7400E-02,5.7322E-02,5.7351E-02,
     &5.7432E-02,5.7560E-02,5.7758E-02,6.0939E-02,6.3212E-02,6.6167E-02,
     &6.9884E-02,7.4560E-02,8.0552E-02,8.8432E-02,9.9242E-02,1.1491E-01,
     &1.3966E-01,1.8320E-01,0.0000E+00,0.0000E+00,7.4490E+00,6.8826E+00,
     &6.3540E+00,5.8477E+00,5.3805E+00,4.9187E+00,4.4884E+00,4.0843E+00,
     &3.7147E+00,3.3516E+00,3.0193E+00,2.7088E+00,2.4279E+00,2.2696E+00,
     &2.1091E+00,1.9368E+00,1.7739E+00,1.6237E+00,1.4821E+00,1.3692E+00,
     &1.2557E+00,1.1358E+00,1.0238E+00,9.2133E-01,8.2567E-01,7.5070E-01,
     &6.7656E-01,5.9850E-01,5.2688E-01,4.6263E-01,4.0371E-01,3.5842E-01/
      DATA (XSF_L(K),K= 1597, 1710) /
     &3.1427E-01,2.6933E-01,2.2930E-01,1.9466E-01,1.6427E-01,1.4208E-01,
     &1.2168E-01,1.0226E-01,8.6560E-02,7.7553E-02,7.0202E-02,6.5576E-02,
     &6.1860E-02,5.9487E-02,5.7920E-02,5.6852E-02,5.6166E-02,5.5736E-02,
     &5.5458E-02,5.5289E-02,5.5193E-02,5.5163E-02,5.5243E-02,5.7935E-02,
     &5.9740E-02,6.2111E-02,6.5158E-02,6.9050E-02,7.4078E-02,8.0683E-02,
     &8.9776E-02,1.0288E-01,1.2351E-01,1.5725E-01,0.0000E+00,0.0000E+00,
     &8.6044E+00,7.9255E+00,7.2940E+00,6.6940E+00,6.1391E+00,5.5940E+00,
     &5.0907E+00,4.6180E+00,4.1841E+00,3.7622E+00,3.3775E+00,3.0195E+00,
     &2.6967E+00,2.5153E+00,2.3331E+00,2.1364E+00,1.9521E+00,1.7815E+00,
     &1.6211E+00,1.4944E+00,1.3683E+00,1.2334E+00,1.1084E+00,9.9465E-01,
     &8.8864E-01,8.0585E-01,7.2432E-01,6.3866E-01,5.6038E-01,4.9058E-01,
     &4.2648E-01,3.7768E-01,3.3036E-01,2.8189E-01,2.3907E-01,2.0214E-01,
     &1.6987E-01,1.4635E-01,1.2479E-01,1.0428E-01,8.7748E-02,7.8203E-02,
     &7.0386E-02,6.5431E-02,6.1373E-02,5.8719E-02,5.6916E-02,5.5642E-02,
     &5.4751E-02,5.4118E-02,5.3653E-02,5.3314E-02,5.3067E-02,5.2897E-02,
     &5.2861E-02,5.5140E-02,5.6493E-02,5.8378E-02,6.0860E-02,6.4090E-02,
     &6.8261E-02,7.3828E-02,8.1439E-02,9.2423E-02,1.0952E-01,1.3424E-01,
     &0.0000E+00,0.0000E+00,9.7645E+00,8.9701E+00,8.2340E+00,7.5357E+00,
     &6.8926E+00,6.2607E+00,5.6834E+00,5.1374E+00,4.6459E+00,4.1625E+00/
      DATA (XSF_L(K),K= 1711, 1824) /
     &3.7261E+00,3.3206E+00,2.9567E+00,2.7529E+00,2.5476E+00,2.3274E+00,
     &2.1217E+00,1.9320E+00,1.7541E+00,1.6131E+00,1.4740E+00,1.3257E+00,
     &1.1879E+00,1.0631E+00,9.4732E-01,8.5726E-01,7.6844E-01,6.7586E-01,
     &5.9131E-01,5.1597E-01,4.4748E-01,3.9504E-01,3.4470E-01,2.9317E-01,
     &2.4779E-01,2.0880E-01,1.7478E-01,1.5007E-01,1.2748E-01,1.0600E-01,
     &8.8713E-02,7.8704E-02,7.0472E-02,6.5220E-02,6.0885E-02,5.7993E-02,
     &5.5967E-02,5.4536E-02,5.3470E-02,5.2665E-02,5.2054E-02,5.1577E-02,
     &5.1203E-02,5.0930E-02,5.0809E-02,5.2731E-02,5.3716E-02,5.5192E-02,
     &5.7203E-02,5.9902E-02,6.3412E-02,6.8123E-02,7.4602E-02,8.3905E-02,
     &9.8185E-02,1.1515E-01,0.0000E+00,0.0000E+00,1.1069E+01,1.0141E+01,
     &9.2840E+00,8.4741E+00,7.7316E+00,7.0038E+00,6.3364E+00,5.7137E+00,
     &5.1475E+00,4.6031E+00,4.1059E+00,3.6477E+00,3.2381E+00,3.0086E+00,
     &2.7788E+00,2.5333E+00,2.3033E+00,2.0926E+00,1.8951E+00,1.7404E+00,
     &1.5854E+00,1.4229E+00,1.2715E+00,1.1352E+00,1.0089E+00,9.1089E-01,
     &8.1457E-01,7.1424E-01,6.2332E-01,5.4229E-01,4.6872E-01,4.1295E-01,
     &3.5903E-01,3.0454E-01,2.5654E-01,2.1539E-01,1.7965E-01,1.5373E-01,
     &1.3011E-01,1.0766E-01,8.9530E-02,7.9108E-02,7.0483E-02,6.4943E-02,
     &6.0331E-02,5.7203E-02,5.4990E-02,5.3395E-02,5.2144E-02,5.1206E-02,
     &5.0454E-02,4.9840E-02,4.9351E-02,4.8978E-02,4.8801E-02,5.0351E-02/
      DATA (XSF_L(K),K= 1825, 1836) /
     &5.1017E-02,5.2127E-02,5.3737E-02,5.5934E-02,5.8835E-02,6.2800E-02,
     &6.8260E-02,7.6135E-02,8.7873E-02,0.0000E+00,0.0000E+00,0.0000E+00/
      DATA (XGF_L(K),K=    1,  114) /
     &1.0646E+00,1.0934E+00,1.1214E+00,1.1484E+00,1.1741E+00,1.1999E+00,
     &1.2242E+00,1.2466E+00,1.2676E+00,1.2873E+00,1.3042E+00,1.3194E+00,
     &1.3313E+00,1.3376E+00,1.3430E+00,1.3472E+00,1.3502E+00,1.3504E+00,
     &1.3501E+00,1.3478E+00,1.3430E+00,1.3356E+00,1.3267E+00,1.3149E+00,
     &1.3003E+00,1.2857E+00,1.2680E+00,1.2451E+00,1.2189E+00,1.1899E+00,
     &1.1575E+00,1.1282E+00,1.0947E+00,1.0543E+00,1.0121E+00,9.6983E-01,
     &9.2809E-01,8.9556E-01,8.6663E-01,8.4606E-01,8.4971E-01,8.7714E-01,
     &9.3569E-01,1.0140E+00,1.1325E+00,1.2706E+00,1.4268E+00,1.6005E+00,
     &1.7918E+00,2.0014E+00,2.2301E+00,2.4791E+00,2.7490E+00,3.0404E+00,
     &3.3541E+00,3.5718E+00,4.2579E+00,5.0478E+00,5.9674E+00,7.0458E+00,
     &8.3375E+00,9.9284E+00,1.1949E+01,1.4650E+01,1.8560E+01,2.5096E+01,
     &4.0067E+01,0.0000E+00,1.6404E+00,1.6723E+00,1.7014E+00,1.7287E+00,
     &1.7533E+00,1.7768E+00,1.7973E+00,1.8152E+00,1.8297E+00,1.8417E+00,
     &1.8498E+00,1.8540E+00,1.8544E+00,1.8526E+00,1.8489E+00,1.8424E+00,
     &1.8335E+00,1.8221E+00,1.8091E+00,1.7949E+00,1.7784E+00,1.7555E+00,
     &1.7310E+00,1.7034E+00,1.6713E+00,1.6428E+00,1.6093E+00,1.5680E+00,
     &1.5230E+00,1.4754E+00,1.4241E+00,1.3785E+00,1.3278E+00,1.2681E+00,
     &1.2068E+00,1.1462E+00,1.0867E+00,1.0400E+00,9.9665E-01,9.6041E-01,
     &9.4923E-01,9.6563E-01,1.0117E+00,1.0781E+00,1.1816E+00,1.3028E+00/
      DATA (XGF_L(K),K=  115,  228) /
     &1.4397E+00,1.5912E+00,1.7573E+00,1.9376E+00,2.1326E+00,2.3425E+00,
     &2.5677E+00,2.8078E+00,3.0611E+00,3.2398E+00,3.7904E+00,4.4126E+00,
     &5.1162E+00,5.9322E+00,6.8841E+00,8.0278E+00,9.4403E+00,1.1276E+01,
     &1.3844E+01,1.7948E+01,2.6821E+01,0.0000E+00,2.5295E+00,2.5563E+00,
     &2.5800E+00,2.5995E+00,2.6174E+00,2.6286E+00,2.6363E+00,2.6395E+00,
     &2.6379E+00,2.6306E+00,2.6184E+00,2.6000E+00,2.5768E+00,2.5598E+00,
     &2.5397E+00,2.5137E+00,2.4839E+00,2.4516E+00,2.4161E+00,2.3833E+00,
     &2.3459E+00,2.3000E+00,2.2499E+00,2.1966E+00,2.1407E+00,2.0900E+00,
     &2.0320E+00,1.9647E+00,1.8929E+00,1.8190E+00,1.7411E+00,1.6734E+00,
     &1.5997E+00,1.5142E+00,1.4279E+00,1.3438E+00,1.2617E+00,1.1967E+00,
     &1.1353E+00,1.0800E+00,1.0501E+00,1.0526E+00,1.0849E+00,1.1369E+00,
     &1.2228E+00,1.3250E+00,1.4410E+00,1.5691E+00,1.7085E+00,1.8587E+00,
     &2.0200E+00,2.1915E+00,2.3728E+00,2.5633E+00,2.7603E+00,2.9047E+00,
     &3.3315E+00,3.8026E+00,4.3243E+00,4.9121E+00,5.5828E+00,6.3648E+00,
     &7.3038E+00,8.4817E+00,1.0068E+01,1.2484E+01,1.7398E+01,0.0000E+00,
     &3.9781E+00,3.9859E+00,3.9880E+00,3.9845E+00,3.9763E+00,3.9582E+00,
     &3.9337E+00,3.9028E+00,3.8636E+00,3.8159E+00,3.7613E+00,3.6984E+00,
     &3.6287E+00,3.5836E+00,3.5326E+00,3.4703E+00,3.4046E+00,3.3350E+00,
     &3.2612E+00,3.1962E+00,3.1248E+00,3.0388E+00,2.9485E+00,2.8565E+00/
      DATA (XGF_L(K),K=  229,  342) /
     &2.7591E+00,2.6752E+00,2.5823E+00,2.4756E+00,2.3627E+00,2.2510E+00,
     &2.1352E+00,2.0365E+00,1.9308E+00,1.8097E+00,1.6896E+00,1.5737E+00,
     &1.4618E+00,1.3735E+00,1.2886E+00,1.2087E+00,1.1551E+00,1.1411E+00,
     &1.1545E+00,1.1903E+00,1.2550E+00,1.3356E+00,1.4282E+00,1.5306E+00,
     &1.6419E+00,1.7606E+00,1.8869E+00,2.0194E+00,2.1574E+00,2.2992E+00,
     &2.4432E+00,2.5568E+00,2.8674E+00,3.2008E+00,3.5626E+00,3.9572E+00,
     &4.3932E+00,4.8857E+00,5.4544E+00,6.1386E+00,7.0188E+00,8.2895E+00,
     &1.0709E+01,0.0000E+00,6.3697E+00,6.3265E+00,6.2740E+00,6.2091E+00,
     &6.1391E+00,6.0517E+00,5.9560E+00,5.8525E+00,5.7367E+00,5.6106E+00,
     &5.4709E+00,5.3235E+00,5.1695E+00,5.0724E+00,4.9662E+00,4.8411E+00,
     &4.7105E+00,4.5784E+00,4.4412E+00,4.3226E+00,4.1943E+00,4.0442E+00,
     &3.8903E+00,3.7360E+00,3.5773E+00,3.4420E+00,3.2967E+00,3.1301E+00,
     &2.9593E+00,2.7916E+00,2.6229E+00,2.4802E+00,2.3301E+00,2.1613E+00,
     &1.9957E+00,1.8382E+00,1.6875E+00,1.5691E+00,1.4545E+00,1.3433E+00,
     &1.2614E+00,1.2264E+00,1.2177E+00,1.2342E+00,1.2749E+00,1.3313E+00,
     &1.3987E+00,1.4740E+00,1.5559E+00,1.6431E+00,1.7346E+00,1.8295E+00,
     &1.9260E+00,2.0232E+00,2.1174E+00,2.2034E+00,2.4118E+00,2.6289E+00,
     &2.8563E+00,3.0948E+00,3.3486E+00,3.6231E+00,3.9250E+00,4.2677E+00,
     &4.6847E+00,5.2492E+00,6.2650E+00,0.0000E+00,9.3778E+00,9.2428E+00/
      DATA (XGF_L(K),K=  343,  456) /
     &9.0960E+00,8.9365E+00,8.7665E+00,8.5746E+00,8.3714E+00,8.1544E+00,
     &7.9343E+00,7.6882E+00,7.4352E+00,7.1724E+00,6.9027E+00,6.7360E+00,
     &6.5571E+00,6.3494E+00,6.1374E+00,5.9260E+00,5.7093E+00,5.5249E+00,
     &5.3270E+00,5.0995E+00,4.8700E+00,4.6419E+00,4.4114E+00,4.2173E+00,
     &4.0129E+00,3.7786E+00,3.5451E+00,3.3173E+00,3.0900E+00,2.9004E+00,
     &2.7040E+00,2.4853E+00,2.2734E+00,2.0742E+00,1.8851E+00,1.7372E+00,
     &1.5941E+00,1.4536E+00,1.3433E+00,1.2893E+00,1.2607E+00,1.2587E+00,
     &1.2792E+00,1.3153E+00,1.3616E+00,1.4149E+00,1.4736E+00,1.5361E+00,
     &1.6012E+00,1.6677E+00,1.7344E+00,1.7990E+00,1.8589E+00,1.9261E+00,
     &2.0646E+00,2.2044E+00,2.3456E+00,2.4882E+00,2.6342E+00,2.7823E+00,
     &2.9370E+00,3.1022E+00,3.2902E+00,3.5288E+00,3.9528E+00,0.0000E+00,
     &1.3926E+01,1.3617E+01,1.3298E+01,1.2959E+01,1.2612E+01,1.2230E+01,
     &1.1845E+01,1.1442E+01,1.1036E+01,1.0599E+01,1.0158E+01,9.7041E+00,
     &9.2562E+00,8.9827E+00,8.6974E+00,8.3632E+00,8.0255E+00,7.6946E+00,
     &7.3614E+00,7.0802E+00,6.7814E+00,6.4439E+00,6.1064E+00,5.7775E+00,
     &5.4468E+00,5.1723E+00,4.8858E+00,4.5617E+00,4.2425E+00,3.9361E+00,
     &3.6353E+00,3.3874E+00,3.1301E+00,2.8506E+00,2.5816E+00,2.3318E+00,
     &2.0965E+00,1.9136E+00,1.7368E+00,1.5622E+00,1.4211E+00,1.3452E+00,
     &1.2937E+00,1.2737E+00,1.2719E+00,1.2868E+00,1.3119E+00,1.3437E+00/
      DATA (XGF_L(K),K=  457,  570) /
     &1.3799E+00,1.4189E+00,1.4596E+00,1.5003E+00,1.5401E+00,1.5761E+00,
     &1.6073E+00,1.6574E+00,1.7377E+00,1.8158E+00,1.8902E+00,1.9601E+00,
     &2.0263E+00,2.0884E+00,2.1452E+00,2.1990E+00,2.2512E+00,2.3118E+00,
     &2.4354E+00,0.0000E+00,1.9256E+01,1.8699E+01,1.8142E+01,1.7563E+01,
     &1.6980E+01,1.6355E+01,1.5725E+01,1.5081E+01,1.4443E+01,1.3769E+01,
     &1.3097E+01,1.2422E+01,1.1755E+01,1.1358E+01,1.0937E+01,1.0454E+01,
     &9.9818E+00,9.5167E+00,9.0465E+00,8.6570E+00,8.2473E+00,7.7870E+00,
     &7.3320E+00,6.8911E+00,6.4569E+00,6.0969E+00,5.7223E+00,5.3051E+00,
     &4.8992E+00,4.5131E+00,4.1351E+00,3.8285E+00,3.5148E+00,3.1749E+00,
     &2.8517E+00,2.5534E+00,2.2748E+00,2.0598E+00,1.8527E+00,1.6465E+00,
     &1.4780E+00,1.3832E+00,1.3129E+00,1.2758E+00,1.2566E+00,1.2544E+00,
     &1.2628E+00,1.2778E+00,1.2971E+00,1.3186E+00,1.3412E+00,1.3637E+00,
     &1.3845E+00,1.4021E+00,1.4142E+00,1.4518E+00,1.4945E+00,1.5327E+00,
     &1.5661E+00,1.5941E+00,1.6160E+00,1.6309E+00,1.6386E+00,1.6381E+00,
     &1.6291E+00,1.6176E+00,1.6271E+00,0.0000E+00,2.5945E+01,2.5063E+01,
     &2.4160E+01,2.3234E+01,2.2336E+01,2.1370E+01,2.0417E+01,1.9450E+01,
     &1.8508E+01,1.7517E+01,1.6548E+01,1.5580E+01,1.4645E+01,1.4085E+01,
     &1.3496E+01,1.2836E+01,1.2181E+01,1.1547E+01,1.0921E+01,1.0404E+01,
     &9.8614E+00,9.2547E+00,8.6616E+00,8.0926E+00,7.5352E+00,7.0774E+00/
      DATA (XGF_L(K),K=  571,  684) /
     &6.6043E+00,6.0842E+00,5.5816E+00,5.1040E+00,4.6450E+00,4.2749E+00,
     &3.8995E+00,3.4941E+00,3.1134E+00,2.7651E+00,2.4423E+00,2.1941E+00,
     &1.9564E+00,1.7198E+00,1.5241E+00,1.4112E+00,1.3220E+00,1.2705E+00,
     &1.2348E+00,1.2175E+00,1.2113E+00,1.2119E+00,1.2167E+00,1.2238E+00,
     &1.2321E+00,1.2398E+00,1.2460E+00,1.2491E+00,1.2470E+00,1.2752E+00,
     &1.2894E+00,1.2998E+00,1.3055E+00,1.3049E+00,1.2991E+00,1.2860E+00,
     &1.2655E+00,1.2370E+00,1.1998E+00,1.1564E+00,1.1181E+00,0.0000E+00,
     &3.3362E+01,3.2051E+01,3.0740E+01,2.9429E+01,2.8133E+01,2.6758E+01,
     &2.5422E+01,2.4082E+01,2.2784E+01,2.1435E+01,2.0130E+01,1.8839E+01,
     &1.7597E+01,1.6865E+01,1.6098E+01,1.5241E+01,1.4397E+01,1.3587E+01,
     &1.2791E+01,1.2130E+01,1.1444E+01,1.0687E+01,9.9507E+00,9.2501E+00,
     &8.5659E+00,8.0104E+00,7.4390E+00,6.8118E+00,6.2125E+00,5.6506E+00,
     &5.1096E+00,4.6780E+00,4.2434E+00,3.7769E+00,3.3424E+00,2.9475E+00,
     &2.5842E+00,2.3061E+00,2.0409E+00,1.7770E+00,1.5572E+00,1.4290E+00,
     &1.3248E+00,1.2609E+00,1.2112E+00,1.1814E+00,1.1636E+00,1.1530E+00,
     &1.1469E+00,1.1433E+00,1.1407E+00,1.1378E+00,1.1337E+00,1.1269E+00,
     &1.1152E+00,1.1360E+00,1.1320E+00,1.1243E+00,1.1127E+00,1.0960E+00,
     &1.0739E+00,1.0461E+00,1.0122E+00,9.7100E-01,9.2292E-01,8.6909E-01,
     &8.1432E-01,0.0000E+00,4.2364E+01,4.0483E+01,3.8640E+01,3.6792E+01/
      DATA (XGF_L(K),K=  685,  798) /
     &3.4991E+01,3.3112E+01,3.1295E+01,2.9487E+01,2.7748E+01,2.5953E+01,
     &2.4235E+01,2.2543E+01,2.0935E+01,1.9990E+01,1.9011E+01,1.7921E+01,
     &1.6852E+01,1.5830E+01,1.4831E+01,1.4013E+01,1.3165E+01,1.2236E+01,
     &1.1337E+01,1.0485E+01,9.6616E+00,8.9943E+00,8.3137E+00,7.5711E+00,
     &6.8670E+00,6.2090E+00,5.5842E+00,5.0866E+00,4.5873E+00,4.0564E+00,
     &3.5646E+00,3.1234E+00,2.7185E+00,2.4107E+00,2.1172E+00,1.8273E+00,
     &1.5836E+00,1.4407E+00,1.3211E+00,1.2459E+00,1.1839E+00,1.1433E+00,
     &1.1153E+00,1.0949E+00,1.0794E+00,1.0667E+00,1.0555E+00,1.0443E+00,
     &1.0317E+00,1.0172E+00,9.9883E-01,1.0131E+00,9.9503E-01,9.7446E-01,
     &9.5064E-01,9.2316E-01,8.9156E-01,8.5528E-01,8.1439E-01,7.6837E-01,
     &7.1718E-01,6.6210E-01,6.0243E-01,0.0000E+00,5.2603E+01,5.0038E+01,
     &4.7540E+01,4.5053E+01,4.2652E+01,4.0175E+01,3.7784E+01,3.5407E+01,
     &3.3154E+01,3.0851E+01,2.8651E+01,2.6507E+01,2.4488E+01,2.3310E+01,
     &2.2084E+01,2.0735E+01,1.9418E+01,1.8166E+01,1.6951E+01,1.5960E+01,
     &1.4935E+01,1.3817E+01,1.2742E+01,1.1732E+01,1.0759E+01,9.9749E+00,
     &9.1794E+00,8.3186E+00,7.5044E+00,6.7510E+00,6.0386E+00,5.4762E+00,
     &4.9137E+00,4.3200E+00,3.7728E+00,3.2842E+00,2.8391E+00,2.5026E+00,
     &2.1835E+00,1.8677E+00,1.6033E+00,1.4461E+00,1.3138E+00,1.2277E+00,
     &1.1557E+00,1.1057E+00,1.0689E+00,1.0407E+00,1.0176E+00,9.9768E-01/
      DATA (XGF_L(K),K=  799,  912) /
     &9.7951E-01,9.6199E-01,9.4331E-01,9.2359E-01,9.0058E-01,9.0921E-01,
     &8.8156E-01,8.5244E-01,8.2081E-01,7.8702E-01,7.5025E-01,7.1005E-01,
     &6.6667E-01,6.1984E-01,5.6969E-01,5.1748E-01,4.5895E-01,0.0000E+00,
     &6.3459E+01,6.0127E+01,5.6900E+01,5.3695E+01,5.0615E+01,4.7464E+01,
     &4.4440E+01,4.1483E+01,3.8684E+01,3.5826E+01,3.3122E+01,3.0500E+01,
     &2.8040E+01,2.6617E+01,2.5143E+01,2.3518E+01,2.1950E+01,2.0455E+01,
     &1.9011E+01,1.7842E+01,1.6646E+01,1.5337E+01,1.4094E+01,1.2920E+01,
     &1.1799E+01,1.0903E+01,9.9940E+00,9.0166E+00,8.0967E+00,7.2512E+00,
     &6.4551E+00,5.8279E+00,5.2081E+00,4.5519E+00,3.9568E+00,3.4237E+00,
     &2.9425E+00,2.5798E+00,2.2371E+00,1.8995E+00,1.6161E+00,1.4477E+00,
     &1.3046E+00,1.2096E+00,1.1285E+00,1.0709E+00,1.0274E+00,9.9290E-01,
     &9.6399E-01,9.3860E-01,9.1550E-01,8.9324E-01,8.7036E-01,8.4674E-01,
     &8.2129E-01,8.2506E-01,7.9094E-01,7.5633E-01,7.2031E-01,6.8307E-01,
     &6.4387E-01,6.0237E-01,5.5907E-01,5.1344E-01,4.6618E-01,4.1810E-01,
     &3.6329E-01,0.0000E+00,7.9498E+01,7.4941E+01,7.0580E+01,6.6266E+01,
     &6.2169E+01,5.8002E+01,5.4045E+01,5.0164E+01,4.6539E+01,4.2847E+01,
     &3.9386E+01,3.6065E+01,3.2968E+01,3.1180E+01,2.9347E+01,2.7330E+01,
     &2.5394E+01,2.3566E+01,2.1811E+01,2.0388E+01,1.8944E+01,1.7368E+01,
     &1.5877E+01,1.4488E+01,1.3164E+01,1.2111E+01,1.1051E+01,9.9162E+00/
      DATA (XGF_L(K),K=  913, 1026) /
     &8.8542E+00,7.8839E+00,6.9777E+00,6.2689E+00,5.5695E+00,4.8410E+00,
     &4.1789E+00,3.5909E+00,3.0635E+00,2.6689E+00,2.2973E+00,1.9324E+00,
     &1.6270E+00,1.4446E+00,1.2882E+00,1.1839E+00,1.0926E+00,1.0266E+00,
     &9.7585E-01,9.3473E-01,8.9976E-01,8.6898E-01,8.4068E-01,8.1374E-01,
     &7.8714E-01,7.6011E-01,7.3262E-01,7.3148E-01,6.9170E-01,6.5270E-01,
     &6.1357E-01,5.7426E-01,5.3417E-01,4.9316E-01,4.5166E-01,4.0914E-01,
     &3.6649E-01,3.2429E-01,2.7651E-01,0.0000E+00,9.7091E+01,9.1127E+01,
     &8.5440E+01,7.9869E+01,7.4603E+01,6.9275E+01,6.4220E+01,5.9343E+01,
     &5.4780E+01,5.0195E+01,4.5912E+01,4.1816E+01,3.8028E+01,3.5857E+01,
     &3.3637E+01,3.1205E+01,2.8880E+01,2.6695E+01,2.4601E+01,2.2923E+01,
     &2.1219E+01,1.9374E+01,1.7634E+01,1.6009E+01,1.4488E+01,1.3276E+01,
     &1.2064E+01,1.0772E+01,9.5709E+00,8.4795E+00,7.4649E+00,6.6775E+00,
     &5.9046E+00,5.1015E+00,4.3733E+00,3.7372E+00,3.1677E+00,2.7434E+00,
     &2.3459E+00,1.9566E+00,1.6317E+00,1.4368E+00,1.2699E+00,1.1572E+00,
     &1.0581E+00,9.8558E-01,9.2913E-01,8.8297E-01,8.4349E-01,8.0862E-01,
     &7.7667E-01,7.4686E-01,7.1760E-01,6.8906E-01,6.6005E-01,6.5493E-01,
     &6.1209E-01,5.7080E-01,5.3038E-01,4.9085E-01,4.5137E-01,4.1231E-01,
     &3.7316E-01,3.3442E-01,2.9613E-01,2.5928E-01,2.1912E-01,0.0000E+00,
     &1.1660E+02,1.0899E+02,1.0178E+02,9.4752E+01,8.8142E+01,8.1480E+01/
      DATA (XGF_L(K),K= 1027, 1140) /
     &7.5219E+01,6.9198E+01,6.3578E+01,5.7986E+01,5.2800E+01,4.7867E+01,
     &4.3328E+01,4.0736E+01,3.8088E+01,3.5213E+01,3.2469E+01,2.9907E+01,
     &2.7451E+01,2.5501E+01,2.3516E+01,2.1392E+01,1.9391E+01,1.7546E+01,
     &1.5800E+01,1.4426E+01,1.3057E+01,1.1607E+01,1.0266E+01,9.0517E+00,
     &7.9294E+00,7.0617E+00,6.2165E+00,5.3397E+00,4.5572E+00,3.8687E+00,
     &3.2598E+00,2.8078E+00,2.3859E+00,1.9745E+00,1.6317E+00,1.4267E+00,
     &1.2497E+00,1.1305E+00,1.0247E+00,9.4657E-01,8.8556E-01,8.3542E-01,
     &7.9253E-01,7.5465E-01,7.2037E-01,6.8840E-01,6.5775E-01,6.2793E-01,
     &5.9852E-01,5.9015E-01,5.4553E-01,5.0339E-01,4.6306E-01,4.2411E-01,
     &3.8622E-01,3.4909E-01,3.1294E-01,2.7773E-01,2.4373E-01,2.1150E-01,
     &1.7848E-01,0.0000E+00,1.3738E+02,1.2796E+02,1.1904E+02,1.1042E+02,
     &1.0233E+02,9.4222E+01,8.6662E+01,7.9409E+01,7.2655E+01,6.6001E+01,
     &5.9833E+01,5.4007E+01,4.8672E+01,4.5642E+01,4.2552E+01,3.9214E+01,
     &3.6040E+01,3.3082E+01,3.0272E+01,2.8026E+01,2.5779E+01,2.3361E+01,
     &2.1093E+01,1.9009E+01,1.7062E+01,1.5526E+01,1.4003E+01,1.2396E+01,
     &1.0916E+01,9.5845E+00,8.3611E+00,7.4188E+00,6.5021E+00,5.5589E+00,
     &4.7169E+00,3.9865E+00,3.3389E+00,2.8617E+00,2.4178E+00,1.9872E+00,
     &1.6283E+00,1.4143E+00,1.2296E+00,1.1049E+00,9.9315E-01,9.1079E-01,
     &8.4623E-01,7.9317E-01,7.4768E-01,7.0802E-01,6.7178E-01,6.3836E-01/
      DATA (XGF_L(K),K= 1141, 1254) /
     &6.0703E-01,5.7658E-01,5.4733E-01,5.3630E-01,4.9100E-01,4.4879E-01,
     &4.0920E-01,3.7138E-01,3.3521E-01,3.0054E-01,2.6721E-01,2.3523E-01,
     &2.0485E-01,1.7634E-01,1.4852E-01,0.0000E+00,1.6103E+02,1.4938E+02,
     &1.3848E+02,1.2798E+02,1.1818E+02,1.0840E+02,9.9309E+01,9.0651E+01,
     &8.2647E+01,7.4733E+01,6.7469E+01,6.0672E+01,5.4433E+01,5.0913E+01,
     &4.7343E+01,4.3482E+01,3.9833E+01,3.6452E+01,3.3242E+01,3.0689E+01,
     &2.8134E+01,2.5404E+01,2.2863E+01,2.0531E+01,1.8362E+01,1.6652E+01,
     &1.4967E+01,1.3197E+01,1.1573E+01,1.0120E+01,8.7877E+00,7.7679E+00,
     &6.7819E+00,5.7685E+00,4.8731E+00,4.0967E+00,3.4122E+00,2.9097E+00,
     &2.4451E+00,1.9953E+00,1.6222E+00,1.3995E+00,1.2076E+00,1.0771E+00,
     &9.6151E-01,8.7563E-01,8.0819E-01,7.5269E-01,7.0548E-01,6.6395E-01,
     &6.2666E-01,5.9253E-01,5.6034E-01,5.3005E-01,5.0122E-01,4.8790E-01,
     &4.4273E-01,4.0115E-01,3.6251E-01,3.2632E-01,2.9224E-01,2.5988E-01,
     &2.2931E-01,2.0039E-01,1.7324E-01,1.4805E-01,1.2201E-01,0.0000E+00,
     &1.8591E+02,1.7193E+02,1.5886E+02,1.4632E+02,1.3469E+02,1.2310E+02,
     &1.1237E+02,1.0218E+02,9.2839E+01,8.3643E+01,7.5256E+01,6.7382E+01,
     &6.0231E+01,5.6204E+01,5.2127E+01,4.7743E+01,4.3601E+01,3.9784E+01,
     &3.6172E+01,3.3310E+01,3.0455E+01,2.7410E+01,2.4579E+01,2.2009E+01,
     &1.9599E+01,1.7727E+01,1.5886E+01,1.3956E+01,1.2193E+01,1.0620E+01/
      DATA (XGF_L(K),K= 1255, 1368) /
     &9.1866E+00,8.0925E+00,7.0383E+00,5.9623E+00,5.0119E+00,4.1917E+00,
     &3.4750E+00,2.9503E+00,2.4663E+00,1.9999E+00,1.6141E+00,1.3840E+00,
     &1.1856E+00,1.0518E+00,9.3192E-01,8.4324E-01,7.7348E-01,7.1642E-01,
     &6.6779E-01,6.2531E-01,5.8732E-01,5.5231E-01,5.2039E-01,4.9037E-01,
     &4.6218E-01,4.4711E-01,4.0225E-01,3.6159E-01,3.2438E-01,2.8982E-01,
     &2.5765E-01,2.2765E-01,1.9954E-01,1.7331E-01,1.4889E-01,1.2621E-01,
     &9.6984E-02,0.0000E+00,2.1269E+02,1.9609E+02,1.8060E+02,1.6582E+02,
     &1.5214E+02,1.3863E+02,1.2613E+02,1.1431E+02,1.0351E+02,9.2957E+01,
     &8.3294E+01,7.4318E+01,6.6188E+01,6.1617E+01,5.7019E+01,5.2073E+01,
     &4.7428E+01,4.3153E+01,3.9122E+01,3.5941E+01,3.2764E+01,2.9404E+01,
     &2.6282E+01,2.3458E+01,2.0836E+01,1.8796E+01,1.6786E+01,1.4693E+01,
     &1.2792E+01,1.1101E+01,9.5678E+00,8.4010E+00,7.2773E+00,6.1402E+00,
     &5.1403E+00,4.2791E+00,3.5311E+00,2.9851E+00,2.4835E+00,2.0017E+00,
     &1.6039E+00,1.3677E+00,1.1646E+00,1.0265E+00,9.0375E-01,8.1271E-01,
     &7.4135E-01,6.8280E-01,6.3328E-01,5.9018E-01,5.5184E-01,5.1677E-01,
     &4.8494E-01,4.5537E-01,4.2797E-01,4.1146E-01,3.6736E-01,3.2788E-01,
     &2.9207E-01,2.5923E-01,2.2901E-01,2.0110E-01,1.7527E-01,1.5131E-01,
     &1.2926E-01,1.0839E-01,6.9776E-02,0.0000E+00,2.4043E+02,2.2104E+02,
     &2.0300E+02,1.8582E+02,1.7003E+02,1.5443E+02,1.4007E+02,1.2658E+02/
      DATA (XGF_L(K),K= 1369, 1482) /
     &1.1426E+02,1.0227E+02,9.1332E+01,8.1197E+01,7.2119E+01,6.6989E+01,
     &6.1846E+01,5.6342E+01,5.1188E+01,4.6448E+01,4.2002E+01,3.8498E+01,
     &3.5016E+01,3.1335E+01,2.7931E+01,2.4848E+01,2.2009E+01,1.9797E+01,
     &1.7637E+01,1.5389E+01,1.3354E+01,1.1550E+01,9.9187E+00,8.6824E+00,
     &7.4988E+00,6.3022E+00,5.2549E+00,4.3589E+00,3.5788E+00,3.0139E+00,
     &2.4962E+00,2.0005E+00,1.5931E+00,1.3514E+00,1.1435E+00,1.0028E+00,
     &8.7751E-01,7.8479E-01,7.1218E-01,6.5272E-01,6.0250E-01,5.5920E-01,
     &5.2061E-01,4.8590E-01,4.5422E-01,4.2519E-01,3.9858E-01,3.8094E-01,
     &3.3789E-01,2.9975E-01,2.6524E-01,2.3401E-01,2.0560E-01,1.7956E-01,
     &1.5565E-01,1.3374E-01,1.1354E-01,9.4096E-02,3.9275E-02,0.0000E+00,
     &2.8195E+02,2.5830E+02,2.3640E+02,2.1554E+02,1.9645E+02,1.7774E+02,
     &1.6058E+02,1.4448E+02,1.2990E+02,1.1575E+02,1.0299E+02,9.1121E+01,
     &8.0574E+01,7.4642E+01,6.8724E+01,6.2402E+01,5.6498E+01,5.1101E+01,
     &4.6042E+01,4.2081E+01,3.8152E+01,3.4014E+01,3.0201E+01,2.6780E+01,
     &2.3611E+01,2.1171E+01,1.8789E+01,1.6329E+01,1.4107E+01,1.2148E+01,
     &1.0386E+01,9.0557E+00,7.7874E+00,6.5118E+00,5.4006E+00,4.4539E+00,
     &3.6370E+00,3.0467E+00,2.5088E+00,1.9959E+00,1.5762E+00,1.3274E+00,
     &1.1142E+00,9.7065E-01,8.4265E-01,7.4825E-01,6.7451E-01,6.1445E-01,
     &5.6374E-01,5.2024E-01,4.8166E-01,4.4741E-01,4.1643E-01,3.8830E-01/
      DATA (XGF_L(K),K= 1483, 1596) /
     &3.6282E-01,3.4411E-01,3.0249E-01,2.6607E-01,2.3369E-01,2.0474E-01,
     &1.7852E-01,1.5489E-01,1.3341E-01,1.1384E-01,9.5862E-02,7.7509E-02,
     &0.0000E+00,0.0000E+00,3.2379E+02,2.9556E+02,2.6960E+02,2.4513E+02,
     &2.2265E+02,2.0073E+02,1.8071E+02,1.6202E+02,1.4515E+02,1.2887E+02,
     &1.1419E+02,1.0071E+02,8.8650E+01,8.1931E+01,7.5233E+01,6.8140E+01,
     &6.1510E+01,5.5467E+01,4.9832E+01,4.5419E+01,4.1070E+01,3.6493E+01,
     &3.2295E+01,2.8536E+01,2.5086E+01,2.2426E+01,1.9846E+01,1.7175E+01,
     &1.4781E+01,1.2681E+01,1.0797E+01,9.3831E+00,8.0380E+00,6.6897E+00,
     &5.5221E+00,4.5337E+00,3.6831E+00,3.0714E+00,2.5159E+00,1.9884E+00,
     &1.5586E+00,1.3048E+00,1.0886E+00,9.4191E-01,8.1217E-01,7.1679E-01,
     &6.4238E-01,5.8194E-01,5.3136E-01,4.8766E-01,4.4965E-01,4.1594E-01,
     &3.8570E-01,3.5847E-01,3.3403E-01,3.1456E-01,2.7454E-01,2.3977E-01,
     &2.0922E-01,1.8216E-01,1.5795E-01,1.3622E-01,1.1669E-01,9.9012E-02,
     &8.2668E-02,6.4604E-02,0.0000E+00,0.0000E+00,3.7071E+02,3.3727E+02,
     &3.0660E+02,2.7790E+02,2.5169E+02,2.2608E+02,2.0283E+02,1.8123E+02,
     &1.6179E+02,1.4311E+02,1.2635E+02,1.1097E+02,9.7357E+01,8.9759E+01,
     &8.2263E+01,7.4239E+01,6.6821E+01,6.0073E+01,5.3813E+01,4.8927E+01,
     &4.4114E+01,3.9072E+01,3.4471E+01,3.0351E+01,2.6592E+01,2.3699E+01,
     &2.0903E+01,1.8031E+01,1.5459E+01,1.3211E+01,1.1204E+01,9.7024E+00/
      DATA (XGF_L(K),K= 1597, 1710) /
     &8.2828E+00,6.8644E+00,5.6367E+00,4.6059E+00,3.7241E+00,3.0915E+00,
     &2.5189E+00,1.9786E+00,1.5396E+00,1.2816E+00,1.0611E+00,9.1306E-01,
     &7.8207E-01,6.8594E-01,6.1118E-01,5.5075E-01,5.0031E-01,4.5732E-01,
     &4.1996E-01,3.8671E-01,3.5732E-01,3.3101E-01,3.0775E-01,2.8769E-01,
     &2.4931E-01,2.1637E-01,1.8763E-01,1.6241E-01,1.4002E-01,1.2013E-01,
     &1.0238E-01,8.6311E-02,7.1348E-02,5.2982E-02,0.0000E+00,0.0000E+00,
     &4.2142E+02,3.8237E+02,3.4660E+02,3.1292E+02,2.8259E+02,2.5300E+02,
     &2.2626E+02,2.0148E+02,1.7927E+02,1.5797E+02,1.3896E+02,1.2163E+02,
     &1.0632E+02,9.7858E+01,8.9366E+01,8.0488E+01,7.2234E+01,6.4771E+01,
     &5.7843E+01,5.2468E+01,4.7182E+01,4.1663E+01,3.6633E+01,3.2165E+01,
     &2.8082E+01,2.4971E+01,2.1960E+01,1.8866E+01,1.6118E+01,1.3723E+01,
     &1.1595E+01,1.0008E+01,8.5101E+00,7.0232E+00,5.7443E+00,4.6705E+00,
     &3.7584E+00,3.1066E+00,2.5189E+00,1.9659E+00,1.5193E+00,1.2575E+00,
     &1.0346E+00,8.8517E-01,7.5338E-01,6.5695E-01,5.8219E-01,5.2200E-01,
     &4.7218E-01,4.2954E-01,3.9258E-01,3.6043E-01,3.3190E-01,3.0663E-01,
     &2.8431E-01,2.6413E-01,2.2746E-01,1.9612E-01,1.6912E-01,1.4557E-01,
     &1.2488E-01,1.0660E-01,9.0362E-02,7.5731E-02,6.1890E-02,4.2720E-02,
     &0.0000E+00,0.0000E+00,4.7166E+02,4.2676E+02,3.8580E+02,3.4749E+02,
     &3.1273E+02,2.7927E+02,2.4899E+02,2.2108E+02,1.9611E+02,1.7230E+02/
      DATA (XGF_L(K),K= 1711, 1824) /
     &1.5107E+02,1.3178E+02,1.1483E+02,1.0548E+02,9.6179E+01,8.6383E+01,
     &7.7331E+01,6.9156E+01,6.1613E+01,5.5763E+01,5.0019E+01,4.4056E+01,
     &3.8633E+01,3.3819E+01,2.9446E+01,2.6108E+01,2.2889E+01,1.9617E+01,
     &1.6706E+01,1.4179E+01,1.1938E+01,1.0276E+01,8.7112E+00,7.1630E+00,
     &5.8345E+00,4.7275E+00,3.7856E+00,3.1171E+00,2.5164E+00,1.9532E+00,
     &1.4997E+00,1.2350E+00,1.0108E+00,8.6027E-01,7.2804E-01,6.3166E-01,
     &5.5726E-01,4.9745E-01,4.4802E-01,4.0623E-01,3.7002E-01,3.3850E-01,
     &3.1081E-01,2.8644E-01,2.6509E-01,2.4476E-01,2.0951E-01,1.7979E-01,
     &1.5426E-01,1.3217E-01,1.1290E-01,9.5951E-02,8.0975E-02,6.7483E-02,
     &5.4483E-02,3.4309E-02,0.0000E+00,0.0000E+00,5.2745E+02,4.7595E+02,
     &4.2900E+02,3.8543E+02,3.4589E+02,3.0795E+02,2.7377E+02,2.4235E+02,
     &2.1434E+02,1.8771E+02,1.6408E+02,1.4266E+02,1.2392E+02,1.1358E+02,
     &1.0335E+02,9.2593E+01,8.2702E+01,7.3780E+01,6.5553E+01,5.9207E+01,
     &5.2983E+01,4.6535E+01,4.0700E+01,3.5531E+01,3.0842E+01,2.7278E+01,
     &2.3855E+01,2.0386E+01,1.7301E+01,1.4635E+01,1.2282E+01,1.0538E+01,
     &8.9065E+00,7.2932E+00,5.9178E+00,4.7769E+00,3.8086E+00,3.1240E+00,
     &2.5114E+00,1.9387E+00,1.4794E+00,1.2125E+00,9.8604E-01,8.3538E-01,
     &7.0309E-01,6.0683E-01,5.3289E-01,4.7378E-01,4.2493E-01,3.8387E-01,
     &3.4846E-01,3.1778E-01,2.9097E-01,2.6744E-01,2.4699E-01,2.2688E-01/
      DATA (XGF_L(K),K= 1825, 1836) /
     &1.9308E-01,1.6489E-01,1.4079E-01,1.2009E-01,1.0214E-01,8.6447E-02,
     &7.2603E-02,6.0131E-02,4.7893E-02,2.6613E-02,0.0000E+00,0.0000E+00/

*
      X = XINP
*...CHECK OF X AND Q2 VALUES :
      IF ( (X.LT.0.99D-9) .OR. (X.GT.1.D0) ) THEN
*        WRITE(6,91) X
  91     FORMAT (2X,'GRV98: X OUT OF RANGE',1P,E12.4)
         X = 0.99D-9
*        STOP
      ENDIF

      Q2 = Q2INP
      IF ( (Q2.LT.0.799) .OR. (Q2.GT.1.E6) ) THEN
*        WRITE(6,92) Q2
  92     FORMAT (2X,'GRV98: Q2 OUT OF RANGE',1P,E12.4)
         Q2 = 0.99E6
*        STOP
      ENDIF

*
*...INTERPOLATION :
      NA(1) = NX
      NA(2) = NQ
      XT(1) = DLOG(X)
      XT(2) = DLOG(Q2)
      X1 = 1.- X
      XV = X**0.5
      XS = X**(-0.2)
      UV = PHO_DBFINT(NARG,XT,NA,ARRF,XUVF) * X1**3 * XV
      DV = PHO_DBFINT(NARG,XT,NA,ARRF,XDVF) * X1**4 * XV
      DE = PHO_DBFINT(NARG,XT,NA,ARRF,XDEF) * X1**7 * XV
      UD = PHO_DBFINT(NARG,XT,NA,ARRF,XUDF) * X1**7 * XS
      US = 0.5 * (UD - DE)
      DS = 0.5 * (UD + DE)
      SS = PHO_DBFINT(NARG,XT,NA,ARRF,XSF)  * X1**7 * XS
      GL = PHO_DBFINT(NARG,XT,NA,ARRF,XGF)  * X1**5 * XS

      END




CDECK  ID>, PHO_DOR98SC
      SUBROUTINE PHO_DOR98SC (XINP, Q2INP, UV, DV, US, DS, SS, GL)
C***********************************************************************
C
C   GRV98 parton densities, leading order set
C
C                  For a detailed explanation see
C                   M. Glueck, E. Reya, A. Vogt :
C        hep-ph/9806404  =  DO-TH 98/07  =  WUE-ITP-98-019
C                  (To appear in Eur. Phys. J. C)
C
C   interpolation routine based on the original GRV98PA routine,
C   adapted to define interpolation table as DATA statements
C
C                                                   (R.Engel, 09/98)
C
C   CAUTION: this is a version with gluon shadowing corrections
C                                                   (R.Engel, 09/99)
C
C
C   INPUT:   X  =  Bjorken-x        (between  1.E-9 and 1.)
C            Q2 =  scale in GeV**2  (between  0.8 and 1.E6)
C
C   OUTPUT:  UV = u - u(bar),  DV = d - d(bar),  US = u(bar),
C            DS = d(bar),  SS = s = s(bar),  GL = gluon.
C            Always x times the distribution is returned.
C
C******************************************************i****************
      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      SAVE

      PARAMETER (NPART=6, NX=68, NQ=27, NARG=2)
      DIMENSION XUVF(NX,NQ), XDVF(NX,NQ), XDEF(NX,NQ), XUDF(NX,NQ),
     1          XSF(NX,NQ), XGF(NX,NQ),
     2          XT(NARG), NA(NARG), ARRF(NX+NQ)

      DIMENSION XUVF_L(NX*NQ), XDVF_L(NX*NQ), XDEF_L(NX*NQ),
     &  XUDF_L(NX*NQ), XSF_L(NX*NQ), XGF_L(NX*NQ)

      EQUIVALENCE (XUVF(1,1),XUVF_L(1))
      EQUIVALENCE (XDVF(1,1),XDVF_L(1))
      EQUIVALENCE (XDEF(1,1),XDEF_L(1))
      EQUIVALENCE (XUDF(1,1),XUDF_L(1))
      EQUIVALENCE (XSF(1,1),XSF_L(1))
      EQUIVALENCE (XGF(1,1),XGF_L(1))

*#################### data statements for shadowed LO PDF ##############
C  ... deleted ...
*#######################################################################

      X = XINP
*...CHECK OF X AND Q2 VALUES :
      IF ( (X.LT.0.99D-9) .OR. (X.GT.1.D0) ) THEN
*        WRITE(6,91) X
  91     FORMAT (2X,'GRV98_SC: X OUT OF RANGE',1P,E12.4)
         X = 0.99D-9
*        STOP
      ENDIF

      Q2 = Q2INP
      IF ( (Q2.LT.0.799) .OR. (Q2.GT.1.E6) ) THEN
*        WRITE(6,92) Q2
  92     FORMAT (2X,'GRV98_SC: Q2 OUT OF RANGE',1P,E12.4)
         Q2 = 0.99E6
*        STOP
      ENDIF

*
*...INTERPOLATION :
      NA(1) = NX
      NA(2) = NQ
      XT(1) = DLOG(X)
      XT(2) = DLOG(Q2)
      X1 = 1.- X
      XV = X**0.5
      XS = X**(-0.2)
      UV = PHO_DBFINT(NARG,XT,NA,ARRF,XUVF) * X1**3 * XV
      DV = PHO_DBFINT(NARG,XT,NA,ARRF,XDVF) * X1**4 * XV
      DE = PHO_DBFINT(NARG,XT,NA,ARRF,XDEF) * X1**7 * XV
      UD = PHO_DBFINT(NARG,XT,NA,ARRF,XUDF) * X1**7 * XS
      US = 0.5 * (UD - DE)
      DS = 0.5 * (UD + DE)
      SS = PHO_DBFINT(NARG,XT,NA,ARRF,XSF)  * X1**7 * XS
      GL = PHO_DBFINT(NARG,XT,NA,ARRF,XGF)  * X1**5 * XS

      END




CDECK  ID>, PHO_DOR94LO
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                 *
*    G R V  -  P R O T O N  - P A R A M E T R I Z A T I O N S     *
*                                                                 *
*                         1994 UPDATE                             *
*                                                                 *
*                 FOR A DETAILED EXPLANATION SEE                  *
*                   M. GLUECK, E.REYA, A.VOGT :                   *
*                   DO-TH 94/24  =  DESY 94-206                   *
*                    (TO APPEAR IN Z. PHYS. C)                    *
*                                                                 *
*   THE PARAMETRIZATIONS ARE FITTED TO THE EVOLVED PARTONS FOR    *
*        Q**2 / GEV**2  BETWEEN   0.4   AND  1.E6                 *
*             X         BETWEEN  1.E-5  AND   1.                  *
*   LARGE-X REGIONS, WHERE THE DISTRIBUTION UNDER CONSIDERATION   *
*   IS NEGLIGIBLY SMALL, WERE EXCLUDED FROM THE FIT.              *
*                                                                 *
*   HEAVY QUARK THRESHOLDS  Q(H) = M(H)  IN THE BETA FUNCTION :   *
*                   M(C)  =  1.5,  M(B)  =  4.5                   *
*   CORRESPONDING LAMBDA(F) VALUES IN GEV FOR  Q**2 > M(H)**2 :   *
*      LO :   LAMBDA(3)  =  0.232,   LAMBDA(4)  =  0.200,         *
*             LAMBDA(5)  =  0.153,                                *
*      NLO :  LAMBDA(3)  =  0.248,   LAMBDA(4)  =  0.200,         *
*             LAMBDA(5)  =  0.131.                                *
*   THE NUMBER OF ACTIVE QUARK FLAVOURS IS  NF = 3  EVERYWHERE    *
*   EXCEPT IN THE BETA FUNCTION, I.E. THE HEAVY QUARKS C,B,...    *
*   ARE NOT PRESENT AS PARTONS IN THE Q2-EVOLUTION.               *
*   IF NEEDED, HEAVY QUARK DENSITIES CAN BE TAKEN FROM THE 1991   *
*   GRV PARAMETRIZATION.                                          *
*                                                                 *
*   NLO DISTRIBUTIONS ARE GIVEN IN MS-BAR FACTORIZATION SCHEME    *
*   (SUBROUTINE GRV94HO) AS WELL AS IN THE DIS SCHEME (GRV94DI),  *
*   THE LEADING ORDER PARAMETRIZATION IS PROVIDED BY "GRV94LO".   *
*                                                                 *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*...INPUT PARAMETERS :
*
*    X   = MOMENTUM FRACTION
*    Q2  = SCALE Q**2 IN GEV**2
*
*...OUTPUT (ALWAYS X TIMES THE DISTRIBUTION) :
*
*    UV  = U(VAL) = U - U(BAR)
*    DV  = D(VAL) = D - D(BAR)
*    DEL = D(BAR) - U(BAR)
*    UDB = U(BAR) + D(BAR)
*    SB  = S = S(BAR)
*    GL  = GLUON
*
*...LO PARAMETRIZATION :
*
      SUBROUTINE PHO_DOR94LO (X, Q2, UV, DV, DEL, UDB, SB, GL)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       MU2  = 0.23
       LAM2 = 0.2322 * 0.2322
       S  = LOG (LOG(Q2/LAM2) / LOG(MU2/LAM2))
       DS = SQRT (S)
       S2 = S * S
       S3 = S2 * S
*...UV :
       NU  =  2.284 + 0.802 * S + 0.055 * S2
       AKU =  0.590 - 0.024 * S
       BKU =  0.131 + 0.063 * S
       AU  = -0.449 - 0.138 * S - 0.076 * S2
       BU  =  0.213 + 2.669 * S - 0.728 * S2
       CU  =  8.854 - 9.135 * S + 1.979 * S2
       DU  =  2.997 + 0.753 * S - 0.076 * S2
       UV  = PHO_DOR94FV (X, NU, AKU, BKU, AU, BU, CU, DU)
*...DV :
       ND  =  0.371 + 0.083 * S + 0.039 * S2
       AKD =  0.376
       BKD =  0.486 + 0.062 * S
       AD  = -0.509 + 3.310 * S - 1.248 * S2
       BD  =  12.41 - 10.52 * S + 2.267 * S2
       CD  =  6.373 - 6.208 * S + 1.418 * S2
       DD  =  3.691 + 0.799 * S - 0.071 * S2
       DV  = PHO_DOR94FV (X, ND, AKD, BKD, AD, BD, CD, DD)
*...DEL :
       NE  =  0.082 + 0.014 * S + 0.008 * S2
       AKE =  0.409 - 0.005 * S
       BKE =  0.799 + 0.071 * S
       AE  = -38.07 + 36.13 * S - 0.656 * S2
       BE  =  90.31 - 74.15 * S + 7.645 * S2
       CE  =  0.0
       DE  =  7.486 + 1.217 * S - 0.159 * S2
       DEL = PHO_DOR94FV (X, NE, AKE, BKE, AE, BE, CE, DE)
*...UDB :
       ALX =  1.451
       BEX =  0.271
       AKX =  0.410 - 0.232 * S
       BKX =  0.534 - 0.457 * S
       AGX =  0.890 - 0.140 * S
       BGX = -0.981
       CX  =  0.320 + 0.683 * S
       DX  =  4.752 + 1.164 * S + 0.286 * S2
       EX  =  4.119 + 1.713 * S
       ESX =  0.682 + 2.978 * S
       UDB = PHO_DOR94FW(X,S,ALX,BEX,AKX,BKX,AGX,BGX,CX,DX,EX,ESX)
*...SB :
       ALS =  0.914
       BES =  0.577
       AKS =  1.798 - 0.596 * S
       AS  = -5.548 + 3.669 * DS - 0.616 * S
       BS  =  18.92 - 16.73 * DS + 5.168 * S
       DST =  6.379 - 0.350 * S  + 0.142 * S2
       EST =  3.981 + 1.638 * S
       ESS =  6.402
       SB  = PHO_DOR94FS (X, S, ALS, BES, AKS, AS, BS, DST, EST, ESS)
*...GL :
       ALG =  0.524
       BEG =  1.088
       AKG =  1.742 - 0.930 * S
       BKG =        - 0.399 * S2
       AG  =  7.486 - 2.185 * S
       BG  =  16.69 - 22.74 * S  + 5.779 * S2
       CG  = -25.59 + 29.71 * S  - 7.296 * S2
       DG  =  2.792 + 2.215 * S  + 0.422 * S2 - 0.104 * S3
       EG  =  0.807 + 2.005 * S
       ESG =  3.841 + 0.316 * S
       GL = PHO_DOR94FW(X,S,ALG,BEG,AKG,BKG,AG,BG,CG,DG,EG,ESG)

       END


*
*...NLO PARAMETRIZATION (MS(BAR)) :
*
CDECK  ID>, PHO_DOR94HO
      SUBROUTINE PHO_DOR94HO (X, Q2, UV, DV, DEL, UDB, SB, GL)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       MU2  = 0.34
       LAM2 = 0.248 * 0.248
       S  = LOG (LOG(Q2/LAM2) / LOG(MU2/LAM2))
       DS = SQRT (S)
       S2 = S * S
       S3 = S2 * S
*...UV :
       NU  =  1.304 + 0.863 * S
       AKU =  0.558 - 0.020 * S
       BKU =          0.183 * S
       AU  = -0.113 + 0.283 * S - 0.321 * S2
       BU  =  6.843 - 5.089 * S + 2.647 * S2 - 0.527 * S3
       CU  =  7.771 - 10.09 * S + 2.630 * S2
       DU  =  3.315 + 1.145 * S - 0.583 * S2 + 0.154 * S3
       UV  = PHO_DOR94FV (X, NU, AKU, BKU, AU, BU, CU, DU)
*...DV :
       ND  =  0.102 - 0.017 * S + 0.005 * S2
       AKD =  0.270 - 0.019 * S
       BKD =  0.260
       AD  =  2.393 + 6.228 * S - 0.881 * S2
       BD  =  46.06 + 4.673 * S - 14.98 * S2 + 1.331 * S3
       CD  =  17.83 - 53.47 * S + 21.24 * S2
       DD  =  4.081 + 0.976 * S - 0.485 * S2 + 0.152 * S3
       DV  = PHO_DOR94FV (X, ND, AKD, BKD, AD, BD, CD, DD)
*...DEL :
       NE  =  0.070 + 0.042 * S - 0.011 * S2 + 0.004 * S3
       AKE =  0.409 - 0.007 * S
       BKE =  0.782 + 0.082 * S
       AE  = -29.65 + 26.49 * S + 5.429 * S2
       BE  =  90.20 - 74.97 * S + 4.526 * S2
       CE  =  0.0
       DE  =  8.122 + 2.120 * S - 1.088 * S2 + 0.231 * S3
       DEL = PHO_DOR94FV (X, NE, AKE, BKE, AE, BE, CE, DE)
*...UDB :
       ALX =  0.877
       BEX =  0.561
       AKX =  0.275
       BKX =  0.0
       AGX =  0.997
       BGX =  3.210 - 1.866 * S
       CX  =  7.300
       DX  =  9.010 + 0.896 * DS + 0.222 * S2
       EX  =  3.077 + 1.446 * S
       ESX =  3.173 - 2.445 * DS + 2.207 * S
       UDB = PHO_DOR94FW(X,S,ALX,BEX,AKX,BKX,AGX,BGX,CX,DX,EX,ESX)
*...SB :
       ALS =  0.756
       BES =  0.216
       AKS =  1.690 + 0.650 * DS - 0.922 * S
       AS  = -4.329 + 1.131 * S
       BS  =  9.568 - 1.744 * S
       DST =  9.377 + 1.088 * DS - 1.320 * S + 0.130 * S2
       EST =  3.031 + 1.639 * S
       ESS =  5.837 + 0.815 * S
       SB  = PHO_DOR94FS (X, S, ALS, BES, AKS, AS, BS, DST, EST, ESS)
*...GL :
       ALG =  1.014
       BEG =  1.738
       AKG =  1.724 + 0.157 * S
       BKG =  0.800 + 1.016 * S
       AG  =  7.517 - 2.547 * S
       BG  =  34.09 - 52.21 * DS + 17.47 * S
       CG  =  4.039 + 1.491 * S
       DG  =  3.404 + 0.830 * S
       EG  = -1.112 + 3.438 * S  - 0.302 * S2
       ESG =  3.256 - 0.436 * S
       GL = PHO_DOR94FW(X,S,ALG,BEG,AKG,BKG,AG,BG,CG,DG,EG,ESG)

       END



CDECK  ID>, PHO_DOR94DI
*
*...NLO PARAMETRIZATION (DIS) :
*
      SUBROUTINE PHO_DOR94DI (X, Q2, UV, DV, DEL, UDB, SB, GL)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       MU2  = 0.34
       LAM2 = 0.248 * 0.248
       S  = LOG (LOG(Q2/LAM2) / LOG(MU2/LAM2))
       DS = SQRT (S)
       S2 = S * S
       S3 = S2 * S
*...UV :
       NU  =  2.484 + 0.116 * S + 0.093 * S2
       AKU =  0.563 - 0.025 * S
       BKU =  0.054 + 0.154 * S
       AU  = -0.326 - 0.058 * S - 0.135 * S2
       BU  = -3.322 + 8.259 * S - 3.119 * S2 + 0.291 * S3
       CU  =  11.52 - 12.99 * S + 3.161 * S2
       DU  =  2.808 + 1.400 * S - 0.557 * S2 + 0.119 * S3
       UV  = PHO_DOR94FV (X, NU, AKU, BKU, AU, BU, CU, DU)
*...DV :
       ND  =  0.156 - 0.017 * S
       AKD =  0.299 - 0.022 * S
       BKD =  0.259 - 0.015 * S
       AD  =  3.445 + 1.278 * S + 0.326 * S2
       BD  = -6.934 + 37.45 * S - 18.95 * S2 + 1.463 * S3
       CD  =  55.45 - 69.92 * S + 20.78 * S2
       DD  =  3.577 + 1.441 * S - 0.683 * S2 + 0.179 * S3
       DV  = PHO_DOR94FV (X, ND, AKD, BKD, AD, BD, CD, DD)
*...DEL :
       NE  =  0.099 + 0.019 * S + 0.002 * S2
       AKE =  0.419 - 0.013 * S
       BKE =  1.064 - 0.038 * S
       AE  = -44.00 + 98.70 * S - 14.79 * S2
       BE  =  28.59 - 40.94 * S - 13.66 * S2 + 2.523 * S3
       CE  =  84.57 - 108.8 * S + 31.52 * S2
       DE  =  7.469 + 2.480 * S - 0.866 * S2
       DEL = PHO_DOR94FV (X, NE, AKE, BKE, AE, BE, CE, DE)
*...UDB :
       ALX =  1.215
       BEX =  0.466
       AKX =  0.326 + 0.150 * S
       BKX =  0.956 + 0.405 * S
       AGX =  0.272
       BGX =  3.794 - 2.359 * DS
       CX  =  2.014
       DX  =  7.941 + 0.534 * DS - 0.940 * S + 0.410 * S2
       EX  =  3.049 + 1.597 * S
       ESX =  4.396 - 4.594 * DS + 3.268 * S
       UDB = PHO_DOR94FW(X,S,ALX,BEX,AKX,BKX,AGX,BGX,CX,DX,EX,ESX)
*...SB :
       ALS =  0.175
       BES =  0.344
       AKS =  1.415 - 0.641 * DS
       AS  =  0.580 - 9.763 * DS + 6.795 * S  - 0.558 * S2
       BS  =  5.617 + 5.709 * DS - 3.972 * S
       DST =  13.78 - 9.581 * S  + 5.370 * S2 - 0.996 * S3
       EST =  4.546 + 0.372 * S2
       ESS =  5.053 - 1.070 * S  + 0.805 * S2
       SB  = PHO_DOR94FS (X, S, ALS, BES, AKS, AS, BS, DST, EST, ESS)
*...GL :
       ALG =  1.258
       BEG =  1.846
       AKG =  2.423
       BKG =  2.427 + 1.311 * S  - 0.153 * S2
       AG  =  25.09 - 7.935 * S
       BG  = -14.84 - 124.3 * DS + 72.18 * S
       CG  =  590.3 - 173.8 * S
       DG  =  5.196 + 1.857 * S
       EG  = -1.648 + 3.988 * S  - 0.432 * S2
       ESG =  3.232 - 0.542 * S
       GL = PHO_DOR94FW(X,S,ALG,BEG,AKG,BKG,AG,BG,CG,DG,EG,ESG)

       END


*
*...FUNCTIONAL FORMS OF THE PARAMETRIZATIONS :
*
CDECK  ID>, PHO_DOR94FV
      DOUBLE PRECISION FUNCTION PHO_DOR94FV (X,N,AK,BK,A,B,C,D)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       DX = SQRT (X)
       PHO_DOR94FV = N*X**AK*(1.D0+A*X**BK+X*(B+C*DX))*(1.D0-X)**D

      END


CDECK  ID>, PHO_DOR94FW
      DOUBLE PRECISION FUNCTION PHO_DOR94FW(X,S,AL,BE,AK,BK,
     &                                      A,B,C,D,E,ES)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

      LX = LOG (1./X)
      PHO_DOR94FW = (X**AK * (A + X * (B + X*C)) * LX**BK + S**AL
     1     * DEXP (-E + SQRT (ES * S**BE * LX))) * (1.- X)**D

      END


CDECK  ID>, PHO_DOR94FS
      DOUBLE PRECISION FUNCTION PHO_DOR94FS (X,S,AL,BE,AK,AG,B,D,E,ES)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

      DX = SQRT (X)
      LX = LOG (1./X)
      PHO_DOR94FS = S**AL / LX**AK * (1.+ AG*DX + B*X) * (1.- X)**D
     1      * DEXP (-E + SQRT (ES * S**BE * LX))

      END


CDECK  ID>, PHO_DOR92LO
*
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                 *
*    G R V  -  P R O T O N  - P A R A M E T R I Z A T I O N S     *
*                                                                 *
*                 FOR A DETAILED EXPLANATION SEE :                *
*              M. GLUECK, E.REYA, A.VOGT: DO-TH 91/07             *
*                                                                 *
*   THE PARAMETRIZATIONS ARE FITTED TO THE PARTON DISTRIBUTIONS   *
*   FOR Q ** 2 BETWEEN MU ** 2 (=  0.25 / 0.30  GEV ** 2  IN LO   *
*   / HO) AND  1.E8 GEV ** 2  AND FOR X BETWEEN  1.E-5  AND  1.   *
*   REGIONS, WHERE THE DISTRIBUTION UNDER CONSIDERATION IS NEG-   *
*   LIGIBLE, I.E. BELOW ABOUT 1.E-4, WERE EXCLUDED FROM THE FIT.  *
*                                                                 *
*              HEAVY QUARK THRESHOLDS  Q(H) = M(H) :              *
*         M(C)  =  1.5,  M(B)  =  4.5,  M(T)  =  100  GEV         *
*                                                                 *
*      CORRESPONDING LAMBDA(F) VALUES FOR F ACTIVE FLAVOURS :     *
*      LO :   LAMBDA(3)  =  0.232,   LAMBDA(4)  =  0.200,         *
*             LAMBDA(5)  =  0.153,   LAMBDA(6)  =  0.082  GEV     *
*      HO :   LAMBDA(3)  =  0.248,   LAMBDA(4)  =  0.200,         *
*             LAMBDA(5)  =  0.131,   LAMBDA(6)  =  0.053  GEV     *
*                                                                 *
*   HO DISTRIBUTION REFER TO THE MS-BAR SCHEME OF BARDEEN ET AL.  *
*                                                                 *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
      SUBROUTINE PHO_DOR92LO (X, Q2, UDV, DV, GL, UDB, SB, CB, BB)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       MU2  = 0.25
       LAM2 = 0.232 * 0.232
       S  = LOG (LOG(Q2/LAM2) / LOG(MU2/LAM2))
       S2 = S * S
       S3 = S2 * S
C...X * (UV + DV) :
       NUD  = 0.663 + 0.191 * S - 0.041 * S2 + 0.031 * S3
       AKUD = 0.326
       AGUD = -1.97 +  6.74 * S -  1.96 * S2
       BUD  =  24.4 -  20.7 * S +  4.08 * S2
       DUD  =  2.86 +  0.70 * S -  0.02 * S2
       UDV  = PHO_DOR92FV (X, NUD, AKUD, AGUD, BUD, DUD)
C...X * DV :
       ND  = 0.579 + 0.283 * S + 0.047 * S2
       AKD = 0.523 - 0.015 * S
       AGD =  2.22 -  0.59 * S -  0.27 * S2
       BD  =  5.95 -  6.19 * S +  1.55 * S2
       DD  =  3.57 +  0.94 * S -  0.16 * S2
       DV  = PHO_DOR92FV (X,ND,AKD,AGD,BD,DD)
C...X * G :
       ALG =  0.558
       BEG =  1.218
       AKG =   1.00 -  0.17 * S
       BKG =   0.0
       AGG =   0.0  + 4.879 * S - 1.383 * S2
       BGG =  25.92 - 28.97 * S + 5.596 * S2
       CG  = -25.69 + 23.68 * S - 1.975 * S2
       DG  =  2.537 + 1.718 * S + 0.353 * S2
       EG  =  0.595 + 2.138 * S
       ESG =  4.066
       GL = PHO_DOR92FW(X,S,ALG,BEG,AKG,BKG,AGG,BGG,CG,DG,EG,ESG)
C...X * UBAR = X * DBAR :
       ALU =  1.396
       BEU =  1.331
       AKU =  0.412 - 0.171 * S
       BKU =  0.566 - 0.496 * S
       AGU =  0.363
       BGU = -1.196
       CU  =  1.029 + 1.785 * S - 0.459 * S2
       DU  =  4.696 + 2.109 * S
       EU  =  3.838 + 1.944 * S
       ESU =  2.845
       UDB = PHO_DOR92FW(X,S,ALU,BEU,AKU,BKU,AGU,BGU,CU,DU,EU,ESU)
C...X * SBAR = X * S :
       SS  =   0.0
       ALS =  0.803
       BES =  0.563
       AKS =  2.082 - 0.577 * S
       AGS = -3.055 + 1.024 * S **  0.67
       BS  =   27.4 -  20.0 * S ** 0.154
       DS  =   6.22
       EST =   4.33 + 1.408 * S
       ESS =   8.27 - 0.437 * S
       SB = PHO_DOR92FS(X,S,SS,ALS,BES,AKS,AGS,BS,DS,EST,ESS)
C...X * CBAR = X * C :
       SC  =  0.888
       ALC =   1.01
       BEC =   0.37
       AKC =   0.0
       AGC =   0.0
       BC  =   4.24 - 0.804 * S
       DC  =   3.46 + 1.076 * S
       EC  =   4.61 + 1.490 * S
       ESC =  2.555 + 1.961 * S
       CB  = PHO_DOR92FS(X,S,SC,ALC,BEC,AKC,AGC,BC,DC,EC,ESC)
C...X * BBAR = X * B :
       SBO =  1.351
       ALB =   1.00
       BEB =   0.51
       AKB =   0.0
       AGB =   0.0
       BBO =  1.848
       DB  =  2.929 + 1.396 * S
       EB  =   4.71 + 1.514 * S
       ESB =   4.02 + 1.239 * S
       BB  = PHO_DOR92FS(X,S,SBO,ALB,BEB,AKB,AGB,BBO,DB,EB,ESB)

      END


CDECK  ID>, PHO_DOR92HO
      SUBROUTINE PHO_DOR92HO (X, Q2, UDV, DV, GL, UDB, SB, CB, BB)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       MU2  = 0.3
       LAM2 = 0.248 * 0.248
       S  = LOG (LOG(Q2/LAM2) / LOG(MU2/LAM2))
       DS = SQRT (S)
       S2 = S * S
       S3 = S2 * S
C...X * (UV + DV) :
       NUD  = 0.330 + 0.151 * S - 0.059 * S2 + 0.027 * S3
       AKUD = 0.285
       AGUD = -2.28 + 15.73 * S -  4.58 * S2
       BUD  =  56.7 -  53.6 * S + 11.21 * S2
       DUD  =  3.17 +  1.17 * S -  0.47 * S2 +  0.09 * S3
       UDV  = PHO_DOR92FV (X, NUD, AKUD, AGUD, BUD, DUD)
C...X * DV :
       ND  = 0.459 + 0.315 * DS + 0.515 * S
       AKD = 0.624              - 0.031 * S
       AGD =  8.13 -  6.77 * DS +  0.46 * S
       BD  =  6.59 - 12.83 * DS +  5.65 * S
       DD  =  3.98              +  1.04 * S  -  0.34 * S2
       DV  = PHO_DOR92FV (X, ND, AKD, AGD, BD, DD)
C...X * G :
       ALG =  1.128
       BEG =  1.575
       AKG =  0.323 + 1.653 * S
       BKG =  0.811 + 2.044 * S
       AGG =   0.0  + 1.963 * S - 0.519 * S2
       BGG =  0.078 +  6.24 * S
       CG  =  30.77 - 24.19 * S
       DG  =  3.188 + 0.720 * S
       EG  = -0.881 + 2.687 * S
       ESG =  2.466
       GL = PHO_DOR92FW(X,S,ALG,BEG,AKG,BKG,AGG,BGG,CG,DG,EG,ESG)
C...X * UBAR = X * DBAR :
       ALU =  0.594
       BEU =  0.614
       AKU =  0.636 - 0.084 * S
       BKU =   0.0
       AGU =  1.121 - 0.193 * S
       BGU =  0.751 - 0.785 * S
       CU  =   8.57 - 1.763 * S
       DU  =  10.22 + 0.668 * S
       EU  =  3.784 + 1.280 * S
       ESU =  1.808 + 0.980 * S
       UDB = PHO_DOR92FW(X,S,ALU,BEU,AKU,BKU,AGU,BGU,CU,DU,EU,ESU)
C...X * SBAR = X * S :
       SS  =   0.0
       ALS =  0.756
       BES =  0.101
       AKS =  2.942 - 1.016 * S
       AGS =  -4.60 + 1.167 * S
       BS  =   9.31 - 1.324 * S
       DS  =  11.49 - 1.198 * S + 0.053 * S2
       EST =  2.630 + 1.729 * S
       ESS =   8.12
       SB  = PHO_DOR92FS (X,S,SS,ALS,BES,AKS,AGS,BS,DS,EST,ESS)
C...X * CBAR = X * C :
       SC  =  0.820
       ALC =   0.98
       BEC =   0.0
       AKC = -0.625 - 0.523 * S
       AGC =   0.0
       BC  =  1.896 + 1.616 * S
       DC  =   4.12 + 0.683 * S
       EC  =   4.36 + 1.328 * S
       ESC =  0.677 + 0.679 * S
       CB  = PHO_DOR92FS (X,S,SC,ALC,BEC,AKC,AGC,BC,DC,EC,ESC)
C...X * BBAR = X * B :
       SBO =  1.297
       ALB =   0.99
       BEB =   0.0
       AKB =   0.0  - 0.193 * S
       AGB =   0.0
       BBO =   0.0
       DB  =  3.447 + 0.927 * S
       EB  =   4.68 + 1.259 * S
       ESB =  1.892 + 2.199 * S
       BB  = PHO_DOR92FS(X,S,SBO,ALB,BEB,AKB,AGB,BBO,DB,EB,ESB)

      END



CDECK  ID>, PHO_DOR92FV
      DOUBLE PRECISION FUNCTION PHO_DOR92FV(X,N,AK,AG,B,D)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE
       DX = SQRT (X)
       PHO_DOR92FV = N * X**AK * (1.+ AG*DX + B*X) * (1.- X)**D

      END



CDECK  ID>, PHO_DOR92FW
      DOUBLE PRECISION FUNCTION PHO_DOR92FW(X,S,
     &                                      AL,BE,AK,BK,AG,BG,C,D,E,ES)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE
       LX = LOG (1./X)
       PHO_DOR92FW = (X**AK * (AG + X * (BG + X*C)) * LX**BK + S**AL
     1      * EXP (-E + SQRT (ES * S**BE * LX))) * (1.- X)**D

      END



CDECK  ID>, PHO_DOR92FS
      DOUBLE PRECISION FUNCTION PHO_DOR92FS(X,S,ST,AL,BE,AK,AG,B,D,E,ES)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       DX = SQRT (X)
       LX = LOG (1./X)
       IF (S .LE. ST) THEN
         PHO_DOR92FS = 0.D0
       ELSE
         PHO_DOR92FS = (S-ST)**AL/LX**AK*(1.D0+AG*DX+B*X)*(1.D0-X)**D
     1          * EXP (-E + SQRT (ES * S**BE * LX))
       END IF

      END



CDECK  ID>, PHO_DORPLO
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                 *
*         G R V - P I O N - P A R A M E T R I Z A T I O N S       *
*                                                                 *
*                 FOR A DETAILED EXPLANATION SEE :                *
*              M. GLUECK, E.REYA, A.VOGT: DO-TH 91/16             *
*                                                                 *
*   THE PARAMETRIZATIONS ARE FITTED TO THE PARTON DISTRIBUTIONS   *
*   FOR Q ** 2 BETWEEN MU ** 2 (=  0.25 / 0.30  GEV ** 2  IN LO   *
*   / HO) AND  1.E8 GEV ** 2  AND FOR X BETWEEN  1.E-5  AND  1.   *
*   REGIONS, WHERE THE DISTRIBUTION UNDER CONSIDERATION IS NEG-   *
*   LIGIBLE, I.E. BELOW ABOUT 1.E-4, WERE EXCLUDED FROM THE FIT.  *
*                                                                 *
*              HEAVY QUARK THRESHOLDS  Q(H) = M(H) :              *
*         M(C)  =  1.5,  M(B)  =  4.5,  M(T)  =  100  GEV         *
*                                                                 *
*      CORRESPONDING LAMBDA(F) VALUES FOR F ACTIVE FLAVOURS :     *
*      LO :   LAMBDA(3)  =  0.232,   LAMBDA(4)  =  0.200,         *
*             LAMBDA(5)  =  0.153,   LAMBDA(6)  =  0.082  GEV     *
*      HO :   LAMBDA(3)  =  0.248,   LAMBDA(4)  =  0.200,         *
*             LAMBDA(5)  =  0.131,   LAMBDA(6)  =  0.053  GEV     *
*                                                                 *
*   HO DISTRIBUTION REFER TO THE MS-BAR SCHEME OF BARDEEN ET AL.  *
*                                                                 *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
      SUBROUTINE PHO_DORPLO (X, Q2, VAP, GLP, QBP, CBP, BBP)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       MU2  = 0.25
       LAM2 = 0.232 * 0.232
       S  = LOG (LOG(Q2/LAM2) / LOG(MU2/LAM2))
       DS = SQRT (S)
       S2 = S * S
C...X * VALENCE :
       NV  =  0.519 + 0.180 * S - 0.011 * S2
       AKV =  0.499 - 0.027 * S
       AGV =  0.381 - 0.419 * S
       DV  =  0.367 + 0.563 * S
       VAP =  PHO_DORFVP (X, NV, AKV, AGV, DV)
C...X * GLUON :
       ALG =  0.599
       BEG =  1.263
       AKG =  0.482 + 0.341 * DS
       BKG =   0.0
       AGG =  0.678 + 0.877 * S  - 0.175 * S2
       BGG =  0.338 - 1.597 * S
       CG  =   0.0  - 0.233 * S  + 0.406 * S2
       DG  =  0.390 + 1.053 * S
       EG  =  0.618 + 2.070 * S
       ESG =  3.676
       GLP = PHO_DORFGP(X,S,ALG,BEG,AKG,BKG,AGG,BGG,CG,DG,EG,ESG)
C...X * QBAR (SU(3)-SYMMETRIC SEA) :
       SL  =   0.0
       ALS =   0.55
       BES =   0.56
       AKS =  2.538 - 0.763 * S
       AGS = -0.748
       BS  =  0.313 + 0.935 * S
       DS  =  3.359
       EST =  4.433 + 1.301 * S
       ESS =   9.30 - 0.887 * S
       QBP =  PHO_DORFQP (X,S,SL,ALS,BES,AKS,AGS,BS,DS,EST,ESS)
C...X * CBAR = X * C :
       SC  =  0.888
       ALC =   1.02
       BEC =   0.39
       AKC =   0.0
       AGC =   0.0
       BC  =  1.008
       DC  =  1.208 + 0.771 * S
       EC  =   4.40 + 1.493 * S
       ESC =  2.032 + 1.901 * S
       CBP =  PHO_DORFQP (X,S,SC,ALC,BEC,AKC,AGC,BC,DC,EC,ESC)
C...X * BBAR = X * B :
       SBO =  1.351
       ALB =   1.03
       BEB =   0.39
       AKB =   0.0
       AGB =   0.0
       BBO =   0.0
       DB  =  0.697 + 0.855 * S
       EB  =   4.51 + 1.490 * S
       ESB =  3.056 + 1.694 * S
       BBP =  PHO_DORFQP(X,S,SBO,ALB,BEB,AKB,AGB,BBO,DB,EB,ESB)

       END


CDECK  ID>, PHO_DORPHO
      SUBROUTINE PHO_DORPHO (X, Q2, VAP, GLP, QBP, CBP, BBP)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       MU2  = 0.3
       LAM2 = 0.248 * 0.248
       S  = LOG (LOG(Q2/LAM2) / LOG(MU2/LAM2))
       DS = SQRT (S)
       S2 = S * S
C...X * VALENCE :
       NV  =  0.456 + 0.150 * DS + 0.112 * S - 0.019 * S2
       AKV =  0.505 - 0.033 * S
       AGV =  0.748 - 0.669 * DS - 0.133 * S
       DV  =  0.365 + 0.197 * DS + 0.394 * S
       VAP =  PHO_DORFVP (X, NV, AKV, AGV, DV)
C...X * GLUON :
       ALG =  1.096
       BEG =  1.371
       AKG =  0.437 - 0.689 * DS
       BKG = -0.631
       AGG =  1.324 - 0.441 * DS - 0.130 * S
       BGG = -0.955 + 0.259 * S
       CG  =  1.075 - 0.302 * S
       DG  =  1.158 + 1.229 * S
       EG  =   0.0  + 2.510 * S
       ESG =  2.604 + 0.165 * S
       GLP = PHO_DORFGP(X,S,ALG,BEG,AKG,BKG,AGG,BGG,CG,DG,EG,ESG)
C...X * QBAR (SU(3)-SYMMETRIC SEA) :
       SL  =   0.0
       ALS =   0.85
       BES =   0.96
       AKS = -0.350 + 0.806 * S
       AGS = -1.663
       BS  =  3.148
       DS  =  2.273 + 1.438 * S
       EST =  3.214 + 1.545 * S
       ESS =  1.341 + 1.938 * S
       QBP =  PHO_DORFQP (X,S,SL,ALS,BES,AKS,AGS,BS,DS,EST,ESS)
C...X * CBAR = X * C :
       SC  =  0.820
       ALC =   0.98
       BEC =   0.0
       AKC =   0.0  - 0.457 * S
       AGC =   0.0
       BC  =  -1.00 +  1.40 * S
       DC  =  1.318 + 0.584 * S
       EC  =   4.45 + 1.235 * S
       ESC =  1.496 + 1.010 * S
       CBP =  PHO_DORFQP (X,S,SC,ALC,BEC,AKC,AGC,BC,DC,EC,ESC)
C...X * BBAR = X * B :
       SBO =  1.297
       ALB =   0.99
       BEB =   0.0
       AKB =   0.0  - 0.172 * S
       AGB =   0.0
       BBO =   0.0
       DB  =  1.447 + 0.485 * S
       EB  =   4.79 + 1.164 * S
       ESB =  1.724 + 2.121 * S
       BBP =  PHO_DORFQP(X,S,SBO,ALB,BEB,AKB,AGB,BBO,DB,EB,ESB)

      END


CDECK  ID>, PHO_DORFVP
      DOUBLE PRECISION FUNCTION PHO_DORFVP(X,N,AK,AG,D)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       DX = SQRT (X)
       PHO_DORFVP = N * X**AK * (1.+ AG*DX) * (1.- X)**D

      END


CDECK  ID>, PHO_DORFGP
      DOUBLE PRECISION FUNCTION PHO_DORFGP(X,S,AL,BE,AK,BK,AG,
     &                                    BG,C,D,E,ES)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       DX = SQRT (X)
       LX = LOG (1./X)
       PHO_DORFGP = (X**AK * (AG + BG*DX + C*X) * LX**BK + S**AL
     1       * EXP (-E + SQRT (ES * S**BE * LX))) * (1.- X)**D

      END


CDECK  ID>, PHO_DORFQP
      DOUBLE PRECISION FUNCTION PHO_DORFQP(X,S,ST,AL,BE,AK,AG,B,D,E,ES)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       DX = SQRT (X)
       LX = LOG (1./X)
       IF (S .LE. ST) THEN
          PHO_DORFQP = 0.0
       ELSE
          PHO_DORFQP = (S-ST)**AL/LX**AK*(1.D0+AG*DX+B*X)*(1.D0-X)**D
     1           * EXP (-E + SQRT (ES * S**BE * LX))
       END IF

      END



CDECK  ID>, PHO_DORGLO
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                 *
*      G R V - P H O T O N - P A R A M E T R I Z A T I O N S      *
*                                                                 *
*                 FOR A DETAILED EXPLANATION SEE :                *
*              M. GLUECK, E.REYA, A.VOGT: DO-TH 91/31             *
*                                                                 *
*    THE OUTPUT IS ALWAYS   1./ ALPHA(EM) * X * PARTON DENSITY    *
*                                                                 *
*   THE PARAMETRIZATIONS ARE FITTED TO THE PARTON DISTRIBUTIONS   *
*   FOR Q ** 2 BETWEEN MU ** 2 (=  0.25 / 0.30  GEV ** 2  IN LO   *
*   / HO) AND  1.E6 GEV ** 2  AND FOR X BETWEEN  1.E-5  AND  1.   *
*                                                                 *
*              HEAVY QUARK THRESHOLDS  Q(H) = M(H) :              *
*         M(C)  =  1.5,  M(B)  =  4.5,  M(T)  =  100  GEV         *
*                                                                 *
*      CORRESPONDING LAMBDA(F) VALUES FOR F ACTIVE FLAVOURS :     *
*      LO :   LAMBDA(3)  =  0.232,   LAMBDA(4)  =  0.200,         *
*             LAMBDA(5)  =  0.153,   LAMBDA(6)  =  0.082  GEV     *
*      HO :   LAMBDA(3)  =  0.248,   LAMBDA(4)  =  0.200,         *
*             LAMBDA(5)  =  0.131,   LAMBDA(6)  =  0.053  GEV     *
*                                                                 *
*      HO DISTRIBUTIONS REFER TO THE DIS(GAMMA) SCHEME, SEE :     *
*              M. GLUECK, E.REYA, A.VOGT: DO-TH 91/26             *
*                                                                 *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
      SUBROUTINE PHO_DORGLO (X, Q2, UL, DL, SL, CL, BL, GL)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       MU2  = 0.25
       LAM2 = 0.232 * 0.232
       S  = LOG (LOG(Q2/LAM2) / LOG(MU2/LAM2))
       SS = SQRT (S)
       S2 = S * S
C...X * U = X * UBAR :
       AL =  1.717
       BE =  0.641
       AK =  0.500 - 0.176 * S
       BK = 15.00  - 5.687 * SS - 0.552 * S2
       AG =  0.235 + 0.046 * SS
       BG =  0.082 - 0.051 * S  + 0.168 * S2
       C  =   0.0  + 0.459 * S
       D  =  0.354 - 0.061 * S
       E  =  4.899 + 1.678 * S
       ES =  2.046 + 1.389 * S
       UL =  PHO_DORGF (X, S, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * D = X * DBAR :
       AL =  1.549
       BE =  0.782
       AK =  0.496 + 0.026 * S
       BK =  0.685 - 0.580 * SS + 0.608 * S2
       AG =  0.233 + 0.302 * S
       BG =   0.0  - 0.818 * S  + 0.198 * S2
       C  =  0.114 + 0.154 * S
       D  =  0.405 - 0.195 * S  + 0.046 * S2
       E  =  4.807 + 1.226 * S
       ES =  2.166 + 0.664 * S
       DL  =  PHO_DORGF (X, S, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * G :
       AL =  0.676
       BE =  1.089
       AK =  0.462 - 0.524 * SS
       BK =  5.451              - 0.804 * S2
       AG =  0.535 - 0.504 * SS + 0.288 * S2
       BG =  0.364 - 0.520 * S
       C  = -0.323              + 0.115 * S2
       D  =  0.233 + 0.790 * S  - 0.139 * S2
       E  =  0.893 + 1.968 * S
       ES =  3.432 + 0.392 * S
       GL =  PHO_DORGF (X, S, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * S = X * SBAR :
       SF =   0.0
       AL =  1.609
       BE =  0.962
       AK =  0.470              - 0.099 * S2
       BK =  3.246
       AG =  0.121 - 0.068 * SS
       BG = -0.090 + 0.074 * S
       C  =  0.062 + 0.034 * S
       D  =   0.0  + 0.226 * S  - 0.060 * S2
       E  =  4.288 + 1.707 * S
       ES =  2.122 + 0.656 * S
       SL =  PHO_DORGFS (X, S, SF, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * C = X * CBAR :
       SF =  0.888
       AL =  0.970
       BE =  0.545
       AK =  1.254 - 0.251 * S
       BK =  3.932              - 0.327 * S2
       AG =  0.658 + 0.202 * S
       BG = -0.699
       C  =  0.965
       D  =   0.0  + 0.141 * S  - 0.027 * S2
       E  =  4.911 + 0.969 * S
       ES =  2.796 + 0.952 * S
       CL =  PHO_DORGFS (X, S, SF, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * B = X * BBAR :
       SF =  1.351
       AL =  1.016
       BE =  0.338
       AK =  1.961 - 0.370 * S
       BK =  0.923 + 0.119 * S
       AG =  0.815 + 0.207 * S
       BG = -2.275
       C  =  1.480
       D  = -0.223 + 0.173 * S
       E  =  5.426 + 0.623 * S
       ES =  3.819 + 0.901 * S
       BL =  PHO_DORGFS (X, S, SF, AL, BE, AK, BK, AG, BG, C, D, E, ES)

       END


CDECK  ID>, PHO_DORGHO
      SUBROUTINE PHO_DORGHO (X, Q2, UH, DH, SH, CH, BH, GH)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       MU2  = 0.3
       LAM2 = 0.248 * 0.248
       S  = LOG (LOG(Q2/LAM2) / LOG(MU2/LAM2))
       SS = SQRT (S)
       S2 = S * S
C...X * U = X * UBAR :
       AL =  0.583
       BE =  0.688
       AK =  0.449 - 0.025 * S  - 0.071 * S2
       BK =  5.060 - 1.116 * SS
       AG =  0.103
       BG =  0.319 + 0.422 * S
       C  =  1.508 + 4.792 * S  - 1.963 * S2
       D  =  1.075 + 0.222 * SS - 0.193 * S2
       E  =  4.147 + 1.131 * S
       ES =  1.661 + 0.874 * S
       UH =  PHO_DORGF (X, S, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * D = X * DBAR :
       AL =  0.591
       BE =  0.698
       AK =  0.442 - 0.132 * S  - 0.058 * S2
       BK =  5.437 - 1.916 * SS
       AG =  0.099
       BG =  0.311 - 0.059 * S
       C  =  0.800 + 0.078 * S  - 0.100 * S2
       D  =  0.862 + 0.294 * SS - 0.184 * S2
       E  =  4.202 + 1.352 * S
       ES =  1.841 + 0.990 * S
       DH  =  PHO_DORGF (X, S, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * G :
       AL =  1.161
       BE =  1.591
       AK =  0.530 - 0.742 * SS + 0.025 * S2
       BK =  5.662
       AG =  0.533 - 0.281 * SS + 0.218 * S2
       BG =  0.025 - 0.518 * S  + 0.156 * S2
       C  = -0.282              + 0.209 * S2
       D  =  0.107 + 1.058 * S  - 0.218 * S2
       E  =   0.0  + 2.704 * S
       ES =  3.071 - 0.378 * S
       GH =  PHO_DORGF (X, S, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * S = X * SBAR :
       SF =   0.0
       AL =  0.635
       BE =  0.456
       AK =  1.770 - 0.735 * SS - 0.079 * S2
       BK =  3.832
       AG =  0.084 - 0.023 * S
       BG =  0.136
       C  =  2.119 - 0.942 * S  + 0.063 * S2
       D  =  1.271 + 0.076 * S  - 0.190 * S2
       E  =  4.604 + 0.737 * S
       ES =  1.641 + 0.976 * S
       SH =  PHO_DORGFS (X, S, SF, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * C = X * CBAR :
       SF =  0.820
       AL =  0.926
       BE =  0.152
       AK =  1.142 - 0.175 * S
       BK =  3.276
       AG =  0.504 + 0.317 * S
       BG = -0.433
       C  =  3.334
       D  =  0.398 + 0.326 * S  - 0.107 * S2
       E  =  5.493 + 0.408 * S
       ES =  2.426 + 1.277 * S
       CH =  PHO_DORGFS (X, S, SF, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * B = X * BBAR :
       SF =  1.297
       AL =  0.969
       BE =  0.266
       AK =  1.953 - 0.391 * S
       BK =  1.657 - 0.161 * S
       AG =  1.076 + 0.034 * S
       BG = -2.015
       C  =  1.662
       D  =  0.353 + 0.016 * S
       E  =  5.713 + 0.249 * S
       ES =  3.456 + 0.673 * S
       BH =  PHO_DORGFS (X, S, SF, AL, BE, AK, BK, AG, BG, C, D, E, ES)

      END


CDECK  ID>, PHO_DORGH0
      SUBROUTINE PHO_DORGH0 (X, Q2, U0, D0, S0, C0, B0, G0)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       MU2  = 0.3
       LAM2 = 0.248 * 0.248
       S  = LOG (LOG(Q2/LAM2) / LOG(MU2/LAM2))
       SS = SQRT (S)
       S2 = S * S
C...X * U = X * UBAR :
       AL =  1.447
       BE =  0.848
       AK =  0.527 + 0.200 * S  - 0.107 * S2
       BK =  7.106 - 0.310 * SS - 0.786 * S2
       AG =  0.197 + 0.533 * S
       BG =  0.062 - 0.398 * S  + 0.109 * S2
       C  =          0.755 * S  - 0.112 * S2
       D  =  0.318 - 0.059 * S
       E  =  4.225 + 1.708 * S
       ES =  1.752 + 0.866 * S
       U0 =  PHO_DORGF (X, S, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * D = X * DBAR :
       AL =  1.424
       BE =  0.770
       AK =  0.500 + 0.067 * SS - 0.055 * S2
       BK =  0.376 - 0.453 * SS + 0.405 * S2
       AG =  0.156 + 0.184 * S
       BG =   0.0  - 0.528 * S  + 0.146 * S2
       C  =  0.121 + 0.092 * S
       D  =  0.379 - 0.301 * S  + 0.081 * S2
       E  =  4.346 + 1.638 * S
       ES =  1.645 + 1.016 * S
       D0  =  PHO_DORGF (X, S, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * G :
       AL =  0.661
       BE =  0.793
       AK =  0.537 - 0.600 * SS
       BK =  6.389              - 0.953 * S2
       AG =  0.558 - 0.383 * SS + 0.261 * S2
       BG =   0.0  - 0.305 * S
       C  = -0.222              + 0.078 * S2
       D  =  0.153 + 0.978 * S  - 0.209 * S2
       E  =  1.429 + 1.772 * S
       ES =  3.331 + 0.806 * S
       G0 =  PHO_DORGF (X, S, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * S = X * SBAR :
       SF =   0.0
       AL =  1.578
       BE =  0.863
       AK =  0.622 + 0.332 * S  - 0.300 * S2
       BK =  2.469
       AG =  0.211 - 0.064 * SS - 0.018 * S2
       BG = -0.215 + 0.122 * S
       C  =  0.153
       D  =   0.0  + 0.253 * S  - 0.081 * S2
       E  =  3.990 + 2.014 * S
       ES =  1.720 + 0.986 * S
       S0 =  PHO_DORGFS (X, S, SF, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * C = X * CBAR :
       SF =  0.820
       AL =  0.929
       BE =  0.381
       AK =  1.228 - 0.231 * S
       BK =  3.806             - 0.337 * S2
       AG =  0.932 + 0.150 * S
       BG = -0.906
       C  =  1.133
       D  =   0.0  + 0.138 * S  - 0.028 * S2
       E  =  5.588 + 0.628 * S
       ES =  2.665 + 1.054 * S
       C0 =  PHO_DORGFS (X, S, SF, AL, BE, AK, BK, AG, BG, C, D, E, ES)
C...X * B = X * BBAR :
       SF =  1.297
       AL =  0.970
       BE =  0.207
       AK =  1.719 - 0.292 * S
       BK =  0.928 + 0.096 * S
       AG =  0.845 + 0.178 * S
       BG = -2.310
       C  =  1.558
       D  = -0.191 + 0.151 * S
       E  =  6.089 + 0.282 * S
       ES =  3.379 + 1.062 * S
       B0 =  PHO_DORGFS (X, S, SF, AL, BE, AK, BK, AG, BG, C, D, E, ES)

      END


CDECK  ID>, PHO_DORGF
      DOUBLE PRECISION FUNCTION PHO_DORGF(X,S,AL,BE,AK,BK,
     &                                   AG,BG,C,D,E,ES)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       SX = SQRT (X)
       LX = LOG (1./X)
       PHO_DORGF  = (X**AK * (AG + BG * SX + C * X**BK)  +  S**AL
     1       * EXP (-E + SQRT (ES * S**BE * LX))) * (1.- X)**D

      END


CDECK  ID>, PHO_DORGFS
      DOUBLE PRECISION FUNCTION PHO_DORGFS(X,S,SF,AL,BE,AK,BK,AG,BG,
     &                                     C,D,E,ES)
      IMPLICIT DOUBLE PRECISION (A - Z)
      SAVE

       IF (S .LE. SF) THEN
          PHO_DORGFS = 0.0
       ELSE
          SX = SQRT (X)
          LX = LOG (1./X)
          DS = S - SF
          PHO_DORGFS = (DS * X**AK * (AG + BG * SX + C * X**BK) + DS**AL
     1         * EXP (-E + SQRT (ES * S**BE * LX))) * (1.- X)**D
       END IF

      END


CDECK  ID>, PHO_DORGLV
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                 *
*           G R S - LO - VIRTUAL PHOTON PARAMETRIZATIONS          *
*                                                                 *
*                 FOR A DETAILED EXPLANATION SEE                  *
*                M. GLUECK, E.REYA, M. STRATMANN :                *
*                    PHYS. REV. D51 (1995) 3220                   *
*                                                                 *
*   THE PARAMETRIZATIONS ARE FITTED TO THE EVOLVED PARTONS FOR    *
*        Q**2 / GEV**2  BETWEEN   0.6   AND  5.E4                 *
*                       AND (!)  Q**2 > 5 P**2                    *
*        P**2 / GEV**2  BETWEEN   0.0   AND  10.                  *
*                       P**2 = 0  <=> REAL PHOTON                 *
*             X         BETWEEN  1.E-4  AND   1.                  *
*                                                                 *
*   HEAVY QUARK THRESHOLDS  Q(H) = M(H)  IN THE BETA FUNCTION :   *
*                   M(C)  =  1.5,  M(B)  =  4.5                   *
*   CORRESPONDING LAMBDA(F) VALUES IN GEV FOR  Q**2 > M(H)**2 :   *
*      LO :   LAMBDA(3)  =  0.232,   LAMBDA(4)  =  0.200,         *
*             LAMBDA(5)  =  0.153,                                *
*   THE NUMBER OF ACTIVE QUARK FLAVOURS IS  NF = 3  EVERYWHERE    *
*   EXCEPT IN THE BETA FUNCTION, I.E. THE HEAVY QUARKS C,B,...    *
*   ARE NOT PRESENT AS PARTONS IN THE Q2-EVOLUTION.               *
*                                                                 *
*   PLEASE REPORT ANY STRANGE BEHAVIOUR TO :                      *
*                  Marco.Stratmann@durham.ac.uk                   *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*...INPUT PARAMETERS :
*
*    X   = MOMENTUM FRACTION
*    Q2  = SCALE Q**2 IN GEV**2
*    P2  = VIRTUALITY OF THE PHOTON IN GEV**2
*
*...OUTPUT (ALWAYS X TIMES THE DISTRIBUTION DIVIDED BY ALPHA_EM) :
*
********************************************************
*     subroutine grspar(x,q2,p2,ugam,dgam,sgam,ggam)
      SUBROUTINE PHO_DORGLV(X,Q2,P2,UGAM,DGAM,SGAM,GGAM)
      IMPLICIT DOUBLE PRECISION (A-Z)
#include "Zmanagerp.h"
      SAVE

      INTEGER CHECK
c
c     check limits :
c
      CHECK=0
      IF(X.LT.0.0001D0) CHECK=1
      IF((Q2.LT.0.6D0).OR.(Q2.GT.50000.D0))  CHECK=1
      IF(Q2.LT.5.D0*P2) CHECK=1
c
c     calculate distributions
c
      IF(CHECK.EQ.0) THEN
         CALL PHO_GRSCALC(X,Q2,P2,UGAM,DGAM,SGAM,GGAM)
      ELSE
         WRITE(ErrorOut,
     * *) 'GRS PDF parametrization: x/q2/p2 - limits exceeded'
         WRITE(ErrorOut,
     * '(1X,A,1P,3E12.3)') 'current X, Q2, P2:',X,Q2,P2
      ENDIF

      END


CDECK  ID>, PHO_grscalc
      SUBROUTINE PHO_GRSCALC(X,Q2,P2,UGAM,DGAM,SGAM,GGAM)
      IMPLICIT DOUBLE PRECISION (A-Z)
      SAVE

      DIMENSION U1(40),DS1(40),G1(40)
      DIMENSION UD2(20),S2(20),G2(20)
      DIMENSION UP0(20),DSP0(20),GP0(20)
      SAVE U1,DS1,G1,UD2,S2,G2,UP0,DSP0,GP0
c
      DATA U1/-0.139D0,0.783D0,0.132D0,0.087D0,0.003D0,-0.0134D0,
     &   0.009D0,-0.017D0,0.092D0,-0.516D0,-0.085D0,0.439D0,
     &   0.013D0,0.108D0,-0.019D0,-0.272D0,-0.167D0,0.138D0,
     &   0.076D0,0.026D0,-0.013D0,0.27D0,0.107D0,-0.097D0,0.04D0,
     &   0.064D0,0.011D0,0.002D0,0.057D0,-0.057D0,0.162D0,
     &   -0.172D0,0.124D0,-0.016D0,-0.065D0,0.044D0,-1.009D0,
     &   0.622D0,0.227D0,-0.184D0/
      DATA DS1/0.033D0,0.007D0,-0.0516D0,0.12D0,0.001D0,-0.013D0,
     &   0.018D0,-0.028D0,0.102D0,-0.595D0,-0.114D0,0.669D0,
     &   0.022D0,0.001D0,-0.003D0,-0.0583D0,-0.041D0,0.035D0,
     &   0.009D0,0.009D0,0.004D0,0.054D0,0.025D0,-0.02D0,
     &   0.007D0,0.021D0,0.01D0,0.004D0,-0.067D0,0.06D0,-0.148D0,
     &   0.13D0,0.032D0,-0.009D0,-0.06D0,0.036D0,-0.39D0,0.033D0,
     &   0.245D0,-0.171D0/
      DATA G1/0.025D0,0.D0,-0.018D0,0.112D0,-0.025D0,0.177D0,
     &   -0.022D0,0.024D0,0.001D0,-0.0104D0,0.D0,0.D0,-1.082D0,
     &   -1.666D0,0.D0,0.086D0,0.D0,0.053D0,0.005D0,-0.058D0,
     &   0.034D0,0.073D0,1.08D0,1.63D0,-0.0256D0,-0.088D0,0.D0,
     &   0.D0,-0.004D0,0.016D0,0.007D0,-0.012D0,0.01D0,-0.673D0,
     &   0.126D0,-0.167D0,0.032D0,-0.227D0,0.086D0,-0.159D0/
      DATA UD2/0.756D0,0.187D0,0.109D0,-0.163D0,0.002D0,0.004D0,
     &   0.054D0,-0.039D0,22.53D0,-21.02D0,5.608D0,0.332D0,
     &   -0.008D0,-0.021D0,0.381D0,0.572D0,4.774D0,1.436D0,
     &   -0.614D0,3.548D0/
      DATA S2/0.902D0,0.182D0,0.271D0,-0.346D0,0.017D0,-0.01D0,
     &   -0.011D0,0.0065D0,17.1D0,-13.29D0,6.519D0,0.031D0,
     &   -0.0176D0,0.003D0,1.243D0,0.804D0,4.709D0,1.499D0,
     &   -0.48D0,3.401D0/
      DATA G2/0.364D0,1.31D0,0.86D0,-0.254D0,0.611D0,0.008D0,
     &   -0.097D0,-2.412D0,-0.843D0,2.248D0,-0.201D0,1.33D0,
     &   0.572D0,0.44D0,1.233D0,0.009D0,0.954D0,1.862D0,3.791D0,
     &   -0.079D0/
      DATA UP0/1.551D0,0.105D0,1.089D0,-0.172D0,3.822D0,-2.162D0,
     &   0.533D0,-0.467D0,-0.412D0,0.2D0,0.377D0,0.299D0,0.487D0,
     &   0.0766D0,0.119D0,0.063D0,7.605D0,0.234D0,-0.567D0,
     &   2.294D0/
      DATA DSP0/2.484D0,1.214D0,1.088D0,-0.1735D0,4.293D0,
     &   -2.802D0,0.5975D0,-0.1193D0,-0.0872D0,0.0418D0,0.128D0,
     &   0.0337D0,0.127D0,0.0135D0,0.14D0,0.0423D0,6.946D0,
     &   0.814D0,1.531D0,0.124D0/
      DATA GP0/1.682D0,1.1D0,0.5888D0,-0.4714D0,0.5362D0,0.0127D0,
     &   -2.438D0,0.03399D0,0.07825D0,0.05842D0,0.08393D0,2.348D0,
     &   -0.07182D0,1.084D0,0.3098D0,-0.07514D0,3.327D0,1.1D0,
     &   2.264D0,0.2675D0/
c
      MU2=0.25D0
      LAM2=0.232D0*0.232D0
c
      IF(P2.LE.0.25D0) THEN
         S=LOG(LOG(Q2/LAM2)/LOG(MU2/LAM2))
         LP1=0.D0
         LP2=0.D0
      ELSE
         S=LOG(LOG(Q2/LAM2)/LOG(P2/LAM2))
         LP1=LOG(P2/MU2)*LOG(P2/MU2)
         LP2=LOG(P2/MU2+LOG(P2/MU2))
      ENDIF
c
      ALP=UP0(1)+LP1*U1(1)+LP2*U1(2)
      BET=UP0(2)+LP1*U1(3)+LP2*U1(4)
      A=UP0(3)+LP1*U1(5)+LP2*U1(6)+
     &  (UP0(4)+LP1*U1(7)+LP2*U1(8))*S
      B=UP0(5)+LP1*U1(9)+LP2*U1(10)+
     &  (UP0(6)+LP1*U1(11)+LP2*U1(12))*S**0.5+
     &  (UP0(7)+LP1*U1(13)+LP2*U1(14))*S**2
      GB=UP0(8)+LP1*U1(15)+LP2*U1(16)+
     &  (UP0(9)+LP1*U1(17)+LP2*U1(18))*S+
     &  (UP0(10)+LP1*U1(19)+LP2*U1(20))*S**2
      GA=UP0(11)+LP1*U1(21)+LP2*U1(22)+
     &  (UP0(12)+LP1*U1(23)+LP2*U1(24))*S**0.5
      GC=UP0(13)+LP1*U1(25)+LP2*U1(33)+
     &  (UP0(14)+LP1*U1(26)+LP2*U1(34))*S
      GD=UP0(15)+LP1*U1(27)+LP2*U1(35)+
     &  (UP0(16)+LP1*U1(28)+LP2*U1(36))*S
      GE=UP0(17)+LP1*U1(29)+LP2*U1(37)+
     &  (UP0(18)+LP1*U1(30)+LP2*U1(38))*S
      GEP=UP0(19)+LP1*U1(31)+LP2*U1(39)+
     &  (UP0(20)+LP1*U1(32)+LP2*U1(40))*S
      UPART1=PHO_GRSF2(X,S,ALP,BET,A,B,GA,GB,GC,GD,GE,GEP)
c
      ALP=DSP0(1)+LP1*DS1(1)+LP2*DS1(2)
      BET=DSP0(2)+LP1*DS1(3)+LP2*DS1(4)
      A=DSP0(3)+LP1*DS1(5)+LP2*DS1(6)+
     &  (DSP0(4)+LP1*DS1(7)+LP2*DS1(8))*S
      B=DSP0(5)+LP1*DS1(9)+LP2*DS1(10)+
     &  (DSP0(6)+LP1*DS1(11)+LP2*DS1(12))*S**0.5+
     &  (DSP0(7)+LP1*DS1(13)+LP2*DS1(14))*S**2
      GB=DSP0(8)+LP1*DS1(15)+LP2*DS1(16)+
     &  (DSP0(9)+LP1*DS1(17)+LP2*DS1(18))*S+
     &  (DSP0(10)+LP1*DS1(19)+LP2*DS1(20))*S**2
      GA=DSP0(11)+LP1*DS1(21)+LP2*DS1(22)+
     &  (DSP0(12)+LP1*DS1(23)+LP2*DS1(24))*S
      GC=DSP0(13)+LP1*DS1(25)+LP2*DS1(33)+
     &  (DSP0(14)+LP1*DS1(26)+LP2*DS1(34))*S
      GD=DSP0(15)+LP1*DS1(27)+LP2*DS1(35)+
     &  (DSP0(16)+LP1*DS1(28)+LP2*DS1(36))*S
      GE=DSP0(17)+LP1*DS1(29)+LP2*DS1(37)+
     &  (DSP0(18)+LP1*DS1(30)+LP2*DS1(38))*S
      GEP=DSP0(19)+LP1*DS1(31)+LP2*DS1(39)+
     &  (DSP0(20)+LP1*DS1(32)+LP2*DS1(40))*S
      DSPART1=PHO_GRSF2(X,S,ALP,BET,A,B,GA,GB,GC,GD,GE,GEP)
c
      ALP=GP0(1)+LP1*G1(1)+LP2*G1(2)
      BET=GP0(2)+LP1*G1(3)+LP2*G1(4)
      A=GP0(3)+LP1*G1(5)+LP2*G1(6)+
     &  (GP0(4)+LP1*G1(7)+LP2*G1(8))*S**0.5
      B=GP0(5)+LP1*G1(9)+LP2*G1(10)+
     &  (GP0(6)+LP1*G1(11)+LP2*G1(12))*S**2
      GB=GP0(7)+LP1*G1(13)+LP2*G1(14)+
     &  (GP0(8)+LP1*G1(15)+LP2*G1(16))*S
      GA=GP0(9)+LP1*G1(17)+LP2*G1(18)+
     &  (GP0(10)+LP1*G1(19)+LP2*G1(20))*S**0.5+
     &  (GP0(11)+LP1*G1(21)+LP2*G1(22))*S**2
      GC=GP0(12)+LP1*G1(23)+LP2*G1(24)+
     &  (GP0(13)+LP1*G1(25)+LP2*G1(26))*S**2
      GD=GP0(14)+LP1*G1(27)+LP2*G1(28)+
     &  (GP0(15)+LP1*G1(29)+LP2*G1(30))*S+
     &  (GP0(16)+LP1*G1(31)+LP2*G1(32))*S**2
      GE=GP0(17)+LP1*G1(33)+LP2*G1(34)+
     &  (GP0(18)+LP1*G1(35)+LP2*G1(36))*S
      GEP=GP0(19)+LP1*G1(37)+LP2*G1(38)+
     &  (GP0(20)+LP1*G1(39)+LP2*G1(40))*S
      GPART1=PHO_GRSF2(X,S,ALP,BET,A,B,GA,GB,GC,GD,GE,GEP)
c
      S=LOG(LOG(Q2/LAM2)/LOG(MU2/LAM2))
      SUPPR=1.D0/(1.D0+P2/0.59D0)**2
c
      ALP=UD2(1)
      BET=UD2(2)
      A=UD2(3)+UD2(4)*S
      GA=UD2(5)+UD2(6)*S**0.5
      GC=UD2(7)+UD2(8)*S
      B=UD2(9)+UD2(10)*S+UD2(11)*S**2
      GB=UD2(12)+UD2(13)*S+UD2(14)*S**2
      GD=UD2(15)+UD2(16)*S
      GE=UD2(17)+UD2(18)*S
      GEP=UD2(19)+UD2(20)*S
      UDPART2=SUPPR*PHO_GRSF1(X,S,ALP,BET,A,B,GA,GB,GC,GD,GE,GEP)
c
      ALP=S2(1)
      BET=S2(2)
      A=S2(3)+S2(4)*S
      GA=S2(5)+S2(6)*S**0.5
      GC=S2(7)+S2(8)*S
      B=S2(9)+S2(10)*S+S2(11)*S**2
      GB=S2(12)+S2(13)*S+S2(14)*S**2
      GD=S2(15)+S2(16)*S
      GE=S2(17)+S2(18)*S
      GEP=S2(19)+S2(20)*S
      SPART2=SUPPR*PHO_GRSF2(X,S,ALP,BET,A,B,GA,GB,GC,GD,GE,GEP)
c
      ALP=G2(1)
      BET=G2(2)
      A=G2(3)+G2(4)*S**0.5
      B=G2(5)+G2(6)*S**2
      GB=G2(7)+G2(8)*S
      GA=G2(9)+G2(10)*S**0.5+G2(11)*S**2
      GC=G2(12)+G2(13)*S**2
      GD=G2(14)+G2(15)*S+G2(16)*S**2
      GE=G2(17)+G2(18)*S
      GEP=G2(19)+G2(20)*S
      GPART2=SUPPR*PHO_GRSF1(X,S,ALP,BET,A,B,GA,GB,GC,GD,GE,GEP)
c
      UGAM=UPART1+UDPART2
      DGAM=DSPART1+UDPART2
      SGAM=DSPART1+SPART2
      GGAM=GPART1+GPART2
c
      END


CDECK  ID>, PHO_grsf1
      DOUBLE PRECISION FUNCTION PHO_GRSF1(X,S,ALP,BET,A,B,GA,GB,GC,GD,
     &                                GE,GEP)
      IMPLICIT DOUBLE PRECISION (A-Z)
      SAVE

      PHO_GRSF1=(X**A*(GA+GB*SQRT(X)+GC*X**B)+
     &      S**ALP*EXP(-GE+SQRT(GEP*S**BET*LOG(1.D0/X))))*
     &      (1.D0-X)**GD

      END


CDECK  ID>, PHO_grsf2
      DOUBLE PRECISION FUNCTION PHO_GRSF2(X,S,ALP,BET,A,B,GA,GB,GC,GD,
     &                                GE,GEP)
      IMPLICIT DOUBLE PRECISION (A-Z)
      SAVE

      PHO_GRSF2=(S*X**A*(GA+GB*SQRT(X)+GC*X**B)+
     &      S**ALP*EXP(-GE+SQRT(GEP*S**BET*LOG(1.D0/X))))*
     &      (1.D0-X)**GD

      END


CDECK  ID>, PHO_CKMTPA
      SUBROUTINE PHO_CKMTPA(IPA,XMI,XMA,ALA,Q2MI,Q2MA,PDFNA)
C**********************************************************************
C
C     PDF based on Regge theory, evolved with .... by ....
C
C     input: IPAR     2212   proton (not installed)
C                      990   Pomeron
C
C     output: parameters of parametrization
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      CHARACTER*8 PDFNA

      REAL PROP(40),POMP(40)
      DATA PROP /
     & .230000E+00, .200000E+01, .150200E+00, .120000E+01, .263100E+00,
     & .645200E+00, .354890E+01, .111700E+01, .415000E+00, .768400E-01,
     & .100000E+00, .330000E-01, .352102E-01, .200000E+01, .200000E+01,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .100000E+00, .200000E+01, .100000E+09/
      DATA POMP /
     & .230000E+00, .500000E+01, .150200E+00, .120000E+01, .263100E+00,
     & .645200E+00, .354890E+01, .111700E+01, .415000E+00, .768400E-01,
     & .700000E-01, .700000E-01, .137161E+00, .300000E+01, .200000E+01,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .100000E+00, .500000E+01, .100000E+09/

      IF(IPA.EQ.2212) THEN
        ALA  =PROP(1)
        Q2MI = PROP(39)
        Q2MA = PROP(40)
        PDFNA = 'CKMT-PRO'
      ELSE IF(IPA.EQ.990) THEN
        ALA  = POMP(1)
        Q2MI = POMP(39)
        Q2MA = POMP(40)
        PDFNA = 'CKMT-POM'
      ELSE
        WRITE(ErrorOut,'(1X,A,I7)')
     &    'PHO_CKMTPA:ERROR: INVALID PARTICLE CODE',IPA
        STOP
      ENDIF
      XMI = 1.D-4
      XMA = 1.D0
      END


CDECK  ID>, PHO_CKMTPD
      SUBROUTINE PHO_CKMTPD(IPAR,X,SCALE2,PD)
C**********************************************************************
C
C     PDF based on Regge theory, evolved with .... by ....
C
C     input: IPAR     2212   proton (not installed)
C                      990   Pomeron
C
C     output: PD(-6:6) x*f(x)  parton distribution functions
C            (PDFLIB convention: d = PD(1), u = PD(2) )
C
C**********************************************************************
#include "Zmanagerp.h"
      SAVE

      DOUBLE PRECISION  X,SCALE2,PD(-6:6),CDN,CUP
      DIMENSION QQ(7)

      Q2=SNGL(SCALE2)
      Q1S=Q2
      XX=SNGL(X)
C  QCD lambda for evolution
      OWLAM = 0.23D0
      OWLAM2=OWLAM**2
C  Q0**2 for evolution
      Q02 = 2.D0
C
C
C  the conventions are : q(1)=x*u, q(2)=x*d, q(3)=q(4)=x*sbar=x*ubar=...
C                        q(6)=x*charm, q(7)=x*gluon
C
      SB=0.
      IF(Q2-Q02) 1,1,2
    2 SB=LOG(LOG(Q2/OWLAM2)/LOG(Q02/OWLAM2))
    1 CONTINUE
      IF(IPAR.EQ.2212) THEN
*       CALL PHO_CKMTPR(XX,SB,QQ
        WRITE(ErrorOut,
     * '(/1X,A,I6)') 'PHO_CKMTPD:ERROR: invalid particle',IPAR
        CALL PHO_ABORT
      ELSE
        CALL PHO_CKMTPO(XX,SB,QQ)
      ENDIF
C
      PD(-6) = 0.D0
      PD(-5) = 0.D0
      PD(-4) = DBLE(QQ(6))
      PD(-3) = DBLE(QQ(3))
      PD(-2) = DBLE(QQ(4))
      PD(-1) = DBLE(QQ(5))
      PD(0)  = DBLE(QQ(7))
      PD(1)  = DBLE(QQ(2))
      PD(2)  = DBLE(QQ(1))
      PD(3)  = DBLE(QQ(3))
      PD(4)  = DBLE(QQ(6))
      PD(5)  = 0.D0
      PD(6)  = 0.D0
      IF(IPAR.EQ.990) THEN
        CDN = (PD(1)-PD(-1))/2.D0
        CUP = (PD(2)-PD(-2))/2.D0
        PD(-1) = PD(-1) + CDN
        PD(-2) = PD(-2) + CUP
        PD(1) = PD(-1)
        PD(2) = PD(-2)
      ENDIF
      END


CDECK  ID>, PHO_CKMTPO
      SUBROUTINE PHO_CKMTPO(X,S,QQ)
C**********************************************************************
C
C    calculation partons in Pomeron
C
C**********************************************************************
      SAVE

      DIMENSION QQ(7)

      DIMENSION F1(25),F2(25),GF(8,20,25),DL(4000)
      EQUIVALENCE (GF(1,1,1),DL(1))
      DATA DELTA/.10/

C  RNG=  -.5
C  DEU.NORM. QUARKS,GLUONS,NEW NORM   .6223E+00   .2754E+00   .1372E+01
C  POM.NORM. QUARKS,GLUONS,ALL    .132E+00    .275E+00    .407E+00
      DATA (DL(K),K=    1,   85) /
     & .324159E-01, .324159E-01, .298895E-01, .298895E-01, .298895E-01,
     & .298895E-01, .486150E+00,-.867362E-18, .362035E-01, .362035E-01,
     & .335142E-01, .335151E-01, .335151E-01, .335142E-01, .745381E+00,
     & .399157E-02, .417146E-01, .417146E-01, .388545E-01, .388564E-01,
     & .388564E-01, .388545E-01, .107588E+01, .969559E-02, .493208E-01,
     & .493208E-01, .462819E-01, .462849E-01, .462849E-01, .462819E-01,
     & .148168E+01, .174837E-01, .593251E-01, .593251E-01, .560991E-01,
     & .561035E-01, .561035E-01, .560991E-01, .196422E+01, .276588E-01,
     & .720220E-01, .720220E-01, .686007E-01, .686065E-01, .686065E-01,
     & .686007E-01, .252331E+01, .405154E-01, .876695E-01, .876695E-01,
     & .840445E-01, .840520E-01, .840520E-01, .840445E-01, .315730E+01,
     & .563115E-01, .106489E+00, .106489E+00, .102652E+00, .102662E+00,
     & .102662E+00, .102652E+00, .386313E+01, .752690E-01, .128662E+00,
     & .128662E+00, .124605E+00, .124616E+00, .124616E+00, .124605E+00,
     & .463661E+01, .975686E-01, .154326E+00, .154326E+00, .150039E+00,
     & .150053E+00, .150053E+00, .150039E+00, .547247E+01, .123348E+00,
     & .183571E+00, .183571E+00, .179048E+00, .179063E+00, .179063E+00/
      DATA (DL(K),K=   86,  170) /
     & .179048E+00, .636464E+01, .152698E+00, .216445E+00, .216445E+00,
     & .211676E+00, .211694E+00, .211694E+00, .211676E+00, .730631E+01,
     & .185666E+00, .252948E+00, .252948E+00, .247925E+00, .247946E+00,
     & .247946E+00, .247925E+00, .829017E+01, .222252E+00, .293037E+00,
     & .293037E+00, .287752E+00, .287776E+00, .287776E+00, .287752E+00,
     & .930850E+01, .262414E+00, .336625E+00, .336625E+00, .331070E+00,
     & .331097E+00, .331097E+00, .331070E+00, .103534E+02, .306065E+00,
     & .383587E+00, .383587E+00, .377754E+00, .377785E+00, .377785E+00,
     & .377754E+00, .114166E+02, .353079E+00, .433760E+00, .433760E+00,
     & .427641E+00, .427675E+00, .427675E+00, .427641E+00, .124903E+02,
     & .403294E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .296507E-01, .296507E-01, .258624E-01, .258624E-01, .258624E-01,
     & .258624E-01, .422709E+00,-.173472E-17, .330029E-01, .330029E-01/
      DATA (DL(K),K=  171,  255) /
     & .289773E-01, .289787E-01, .289787E-01, .289773E-01, .642996E+00,
     & .344499E-02, .377610E-01, .377610E-01, .334880E-01, .334910E-01,
     & .334910E-01, .334880E-01, .914159E+00, .828363E-02, .441590E-01,
     & .441590E-01, .396285E-01, .396333E-01, .396333E-01, .396285E-01,
     & .123635E+01, .147501E-01, .523710E-01, .523710E-01, .475730E-01,
     & .475798E-01, .475798E-01, .475730E-01, .160820E+01, .230185E-01,
     & .625514E-01, .625514E-01, .574758E-01, .574848E-01, .574848E-01,
     & .574758E-01, .202705E+01, .332433E-01, .748195E-01, .748195E-01,
     & .694563E-01, .694678E-01, .694678E-01, .694563E-01, .248945E+01,
     & .455440E-01, .892611E-01, .892611E-01, .836006E-01, .836147E-01,
     & .836147E-01, .836006E-01, .299114E+01, .600067E-01, .105928E+00,
     & .105928E+00, .999607E-01, .999776E-01, .999776E-01, .999607E-01,
     & .352735E+01, .766833E-01, .124839E+00, .124839E+00, .118555E+00,
     & .118575E+00, .118575E+00, .118555E+00, .409288E+01, .955921E-01,
     & .145978E+00, .145978E+00, .139368E+00, .139391E+00, .139391E+00,
     & .139368E+00, .468226E+01, .116719E+00, .169300E+00, .169300E+00,
     & .162355E+00, .162382E+00, .162382E+00, .162355E+00, .528987E+01/
      DATA (DL(K),K=  256,  340) /
     & .140017E+00, .194730E+00, .194730E+00, .187441E+00, .187471E+00,
     & .187471E+00, .187441E+00, .591007E+01, .165413E+00, .222167E+00,
     & .222167E+00, .214525E+00, .214559E+00, .214559E+00, .214525E+00,
     & .653724E+01, .192806E+00, .251486E+00, .251486E+00, .243482E+00,
     & .243521E+00, .243521E+00, .243482E+00, .716591E+01, .222070E+00,
     & .282539E+00, .282539E+00, .274165E+00, .274208E+00, .274208E+00,
     & .274165E+00, .779082E+01, .253058E+00, .315161E+00, .315161E+00,
     & .306410E+00, .306458E+00, .306458E+00, .306410E+00, .840695E+01,
     & .285608E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .279581E-01, .279581E-01, .222797E-01, .222797E-01, .222797E-01,
     & .222797E-01, .367732E+00, .867362E-18, .309604E-01, .309604E-01,
     & .249419E-01, .249441E-01, .249441E-01, .249419E-01, .552053E+00,
     & .296633E-02, .350831E-01, .350831E-01, .287126E-01, .287173E-01/
      DATA (DL(K),K=  341,  425) /
     & .287173E-01, .287126E-01, .770476E+00, .704001E-02, .404554E-01,
     & .404554E-01, .337212E-01, .337286E-01, .337286E-01, .337212E-01,
     & .102096E+01, .123504E-01, .471588E-01, .471588E-01, .400495E-01,
     & .400599E-01, .400599E-01, .400495E-01, .130079E+01, .189795E-01,
     & .552518E-01, .552518E-01, .477564E-01, .477700E-01, .477700E-01,
     & .477564E-01, .160637E+01, .269860E-01, .647649E-01, .647649E-01,
     & .568725E-01, .568897E-01, .568897E-01, .568725E-01, .193388E+01,
     & .364007E-01, .757021E-01, .757021E-01, .674022E-01, .674232E-01,
     & .674232E-01, .674022E-01, .227916E+01, .472280E-01, .880430E-01,
     & .880430E-01, .793257E-01, .793507E-01, .793507E-01, .793257E-01,
     & .263802E+01, .594481E-01, .101745E+00, .101745E+00, .926005E-01,
     & .926297E-01, .926297E-01, .926005E-01, .300628E+01, .730184E-01,
     & .116745E+00, .116745E+00, .107164E+00, .107198E+00, .107198E+00,
     & .107164E+00, .337982E+01, .878765E-01, .132961E+00, .132961E+00,
     & .122936E+00, .122974E+00, .122974E+00, .122936E+00, .375469E+01,
     & .103942E+00, .150298E+00, .150298E+00, .139820E+00, .139863E+00,
     & .139863E+00, .139820E+00, .412714E+01, .121118E+00, .168645E+00/
      DATA (DL(K),K=  426,  510) /
     & .168645E+00, .157706E+00, .157754E+00, .157754E+00, .157706E+00,
     & .449366E+01, .139296E+00, .187883E+00, .187883E+00, .176476E+00,
     & .176529E+00, .176529E+00, .176476E+00, .485100E+01, .158356E+00,
     & .207882E+00, .207882E+00, .196000E+00, .196059E+00, .196059E+00,
     & .196000E+00, .519622E+01, .178170E+00, .228506E+00, .228506E+00,
     & .216145E+00, .216209E+00, .216209E+00, .216145E+00, .552665E+01,
     & .198603E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .275294E-01, .275294E-01, .190245E-01, .190245E-01, .190245E-01,
     & .190245E-01, .320228E+00, .000000E+00, .302671E-01, .302671E-01,
     & .212851E-01, .212884E-01, .212884E-01, .212851E-01, .470861E+00,
     & .255059E-02, .338703E-01, .338703E-01, .243988E-01, .244059E-01,
     & .244059E-01, .243988E-01, .642452E+00, .595399E-02, .383922E-01,
     & .383922E-01, .284195E-01, .284305E-01, .284305E-01, .284195E-01/
      DATA (DL(K),K=  511,  595) /
     & .831913E+00, .102638E-01, .438519E-01, .438519E-01, .333669E-01,
     & .333821E-01, .333821E-01, .333669E-01, .103618E+01, .155000E-01,
     & .502475E-01, .502475E-01, .392399E-01, .392595E-01, .392595E-01,
     & .392399E-01, .125172E+01, .216612E-01, .575580E-01, .575580E-01,
     & .460181E-01, .460425E-01, .460425E-01, .460181E-01, .147519E+01,
     & .287272E-01, .657445E-01, .657445E-01, .536635E-01, .536929E-01,
     & .536929E-01, .536635E-01, .170330E+01, .366597E-01, .747539E-01,
     & .747539E-01, .621238E-01, .621582E-01, .621582E-01, .621238E-01,
     & .193297E+01, .454066E-01, .845205E-01, .845205E-01, .713340E-01,
     & .713738E-01, .713738E-01, .713340E-01, .216133E+01, .549027E-01,
     & .949687E-01, .949687E-01, .812194E-01, .812646E-01, .812646E-01,
     & .812194E-01, .238578E+01, .650733E-01, .106015E+00, .106015E+00,
     & .916972E-01, .917480E-01, .917480E-01, .916972E-01, .260395E+01,
     & .758355E-01, .117569E+00, .117569E+00, .102678E+00, .102735E+00,
     & .102735E+00, .102678E+00, .281373E+01, .871004E-01, .129537E+00,
     & .129537E+00, .114070E+00, .114133E+00, .114133E+00, .114070E+00,
     & .301327E+01, .987750E-01, .141824E+00, .141824E+00, .125777E+00/
      DATA (DL(K),K=  596,  680) /
     & .125846E+00, .125846E+00, .125777E+00, .320098E+01, .110764E+00,
     & .154331E+00, .154331E+00, .137703E+00, .137778E+00, .137778E+00,
     & .137703E+00, .337553E+01, .122970E+00, .166962E+00, .166962E+00,
     & .149753E+00, .149833E+00, .149833E+00, .149753E+00, .353582E+01,
     & .135299E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .286766E-01, .286766E-01, .159579E-01, .159579E-01, .159579E-01,
     & .159579E-01, .279430E+00,-.867362E-18, .312327E-01, .312327E-01,
     & .178644E-01, .178691E-01, .178691E-01, .178644E-01, .399186E+00,
     & .219459E-02, .344289E-01, .344289E-01, .204015E-01, .204111E-01,
     & .204111E-01, .204015E-01, .529978E+00, .501953E-02, .382657E-01,
     & .382657E-01, .235713E-01, .235860E-01, .235860E-01, .235713E-01,
     & .668515E+00, .847682E-02, .427243E-01, .427243E-01, .273559E-01,
     & .273758E-01, .273758E-01, .273559E-01, .812075E+00, .125486E-01/
      DATA (DL(K),K=  681,  765) /
     & .477691E-01, .477691E-01, .317212E-01, .317465E-01, .317465E-01,
     & .317212E-01, .957801E+00, .172006E-01, .533547E-01, .533547E-01,
     & .366231E-01, .366539E-01, .366539E-01, .366231E-01, .110327E+01,
     & .223886E-01, .594259E-01, .594259E-01, .420076E-01, .420441E-01,
     & .420441E-01, .420076E-01, .124628E+01, .280584E-01, .659213E-01,
     & .659213E-01, .478149E-01, .478570E-01, .478570E-01, .478149E-01,
     & .138496E+01, .341502E-01, .727749E-01, .727749E-01, .539803E-01,
     & .540280E-01, .540280E-01, .539803E-01, .151767E+01, .405990E-01,
     & .799178E-01, .799178E-01, .604361E-01, .604895E-01, .604895E-01,
     & .604361E-01, .164304E+01, .473372E-01, .872796E-01, .872796E-01,
     & .671134E-01, .671724E-01, .671724E-01, .671134E-01, .175992E+01,
     & .542955E-01, .947896E-01, .947896E-01, .739429E-01, .740075E-01,
     & .740075E-01, .739429E-01, .186739E+01, .614047E-01, .102378E+00,
     & .102378E+00, .808565E-01, .809266E-01, .809266E-01, .808565E-01,
     & .196473E+01, .685965E-01, .109978E+00, .109978E+00, .877881E-01,
     & .878637E-01, .878637E-01, .877881E-01, .205141E+01, .758045E-01,
     & .117525E+00, .117525E+00, .946745E-01, .947553E-01, .947553E-01/
      DATA (DL(K),K=  766,  850) /
     & .946745E-01, .212709E+01, .829655E-01, .124958E+00, .124958E+00,
     & .101456E+00, .101542E+00, .101542E+00, .101456E+00, .219159E+01,
     & .900196E-01, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .318691E-01, .318691E-01, .129081E-01, .129081E-01, .129081E-01,
     & .129081E-01, .244842E+00,-.867362E-18, .343104E-01, .343104E-01,
     & .145076E-01, .145124E-01, .145124E-01, .145076E-01, .337040E+00,
     & .189443E-02, .371900E-01, .371900E-01, .165461E-01, .165557E-01,
     & .165557E-01, .165461E-01, .433081E+00, .422691E-02, .404763E-01,
     & .404763E-01, .189941E-01, .190085E-01, .190085E-01, .189941E-01,
     & .530109E+00, .696769E-02, .441304E-01, .441304E-01, .218150E-01,
     & .218342E-01, .218342E-01, .218150E-01, .626129E+00, .100799E-01,
     & .481031E-01, .481031E-01, .249615E-01, .249853E-01, .249853E-01,
     & .249615E-01, .719221E+00, .135159E-01, .523426E-01, .523426E-01/
      DATA (DL(K),K=  851,  935) /
     & .283837E-01, .284122E-01, .284122E-01, .283837E-01, .807951E+00,
     & .172259E-01, .567940E-01, .567940E-01, .320288E-01, .320619E-01,
     & .320619E-01, .320288E-01, .891154E+00, .211568E-01, .614022E-01,
     & .614022E-01, .358436E-01, .358811E-01, .358811E-01, .358436E-01,
     & .967928E+00, .252549E-01, .661122E-01, .661122E-01, .397750E-01,
     & .398169E-01, .398169E-01, .397750E-01, .103759E+01, .294673E-01,
     & .708708E-01, .708708E-01, .437716E-01, .438176E-01, .438176E-01,
     & .437716E-01, .109966E+01, .337422E-01, .756269E-01, .756269E-01,
     & .477840E-01, .478342E-01, .478342E-01, .477840E-01, .115380E+01,
     & .380302E-01, .803322E-01, .803322E-01, .517659E-01, .518200E-01,
     & .518200E-01, .517659E-01, .119986E+01, .422846E-01, .849423E-01,
     & .849423E-01, .556743E-01, .557322E-01, .557322E-01, .556743E-01,
     & .123782E+01, .464624E-01, .894164E-01, .894164E-01, .594701E-01,
     & .595315E-01, .595315E-01, .594701E-01, .126777E+01, .505242E-01,
     & .937178E-01, .937178E-01, .631181E-01, .631829E-01, .631829E-01,
     & .631181E-01, .128993E+01, .544348E-01, .978144E-01, .978144E-01,
     & .665876E-01, .666556E-01, .666556E-01, .665876E-01, .130457E+01/
      DATA (DL(K),K=  936, 1020) /
     & .581632E-01, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .377668E-01, .377668E-01, .968304E-02, .968304E-02, .968304E-02,
     & .968304E-02, .216392E+00,-.130104E-17, .401066E-01, .401066E-01,
     & .110266E-01, .110291E-01, .110291E-01, .110266E-01, .284113E+00,
     & .164283E-02, .426983E-01, .426983E-01, .126461E-01, .126510E-01,
     & .126510E-01, .126461E-01, .350879E+00, .355790E-02, .454940E-01,
     & .454940E-01, .144965E-01, .145039E-01, .145039E-01, .144965E-01,
     & .414611E+00, .570002E-02, .484493E-01, .484493E-01, .165364E-01,
     & .165462E-01, .165462E-01, .165364E-01, .474149E+00, .802739E-02,
     & .515153E-01, .515153E-01, .187191E-01, .187313E-01, .187313E-01,
     & .187191E-01, .528511E+00, .104932E-01, .546458E-01, .546458E-01,
     & .210009E-01, .210154E-01, .210154E-01, .210009E-01, .577107E+00,
     & .130535E-01, .577962E-01, .577962E-01, .233395E-01, .233563E-01/
      DATA (DL(K),K= 1021, 1105) /
     & .233563E-01, .233395E-01, .619574E+00, .156658E-01, .609249E-01,
     & .609249E-01, .256954E-01, .257143E-01, .257143E-01, .256954E-01,
     & .655725E+00, .182905E-01, .639938E-01, .639938E-01, .280322E-01,
     & .280532E-01, .280532E-01, .280322E-01, .685523E+00, .208909E-01,
     & .669681E-01, .669681E-01, .303170E-01, .303399E-01, .303399E-01,
     & .303170E-01, .709053E+00, .234341E-01, .698172E-01, .698172E-01,
     & .325206E-01, .325454E-01, .325454E-01, .325206E-01, .726501E+00,
     & .258907E-01, .725141E-01, .725141E-01, .346176E-01, .346442E-01,
     & .346442E-01, .346176E-01, .738139E+00, .282352E-01, .750364E-01,
     & .750364E-01, .365866E-01, .366148E-01, .366148E-01, .365866E-01,
     & .744304E+00, .304461E-01, .773653E-01, .773653E-01, .384099E-01,
     & .384396E-01, .384396E-01, .384099E-01, .745388E+00, .325056E-01,
     & .794860E-01, .794860E-01, .400736E-01, .401046E-01, .401046E-01,
     & .400736E-01, .741819E+00, .343996E-01, .813873E-01, .813873E-01,
     & .415670E-01, .415993E-01, .415993E-01, .415670E-01, .734051E+00,
     & .361177E-01, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00/
      DATA (DL(K),K= 1106, 1190) /
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .433773E-01, .433773E-01, .745094E-02, .745094E-02, .745094E-02,
     & .745094E-02, .201612E+00,-.130104E-17, .455998E-01, .455998E-01,
     & .866239E-02, .866443E-02, .866443E-02, .866239E-02, .255046E+00,
     & .149977E-02, .479569E-01, .479569E-01, .100584E-01, .100624E-01,
     & .100624E-01, .100584E-01, .305549E+00, .317779E-02, .503976E-01,
     & .503976E-01, .115911E-01, .115970E-01, .115970E-01, .115911E-01,
     & .351606E+00, .498612E-02, .528804E-01, .528804E-01, .132216E-01,
     & .132293E-01, .132293E-01, .132216E-01, .392560E+00, .688553E-02,
     & .553621E-01, .553621E-01, .149087E-01, .149181E-01, .149181E-01,
     & .149087E-01, .427948E+00, .883486E-02, .578049E-01, .578049E-01,
     & .166165E-01, .166276E-01, .166276E-01, .166165E-01, .457612E+00,
     & .107980E-01, .601739E-01, .601739E-01, .183120E-01, .183246E-01,
     & .183246E-01, .183120E-01, .481565E+00, .127419E-01, .624390E-01,
     & .624390E-01, .199661E-01, .199801E-01, .199801E-01, .199661E-01/
      DATA (DL(K),K= 1191, 1275) /
     & .499943E+00, .146375E-01, .645736E-01, .645736E-01, .215535E-01,
     & .215688E-01, .215688E-01, .215535E-01, .512983E+00, .164593E-01,
     & .665556E-01, .665556E-01, .230528E-01, .230693E-01, .230693E-01,
     & .230528E-01, .520995E+00, .181859E-01, .683669E-01, .683669E-01,
     & .244463E-01, .244639E-01, .244639E-01, .244463E-01, .524347E+00,
     & .197998E-01, .699932E-01, .699932E-01, .257201E-01, .257387E-01,
     & .257387E-01, .257201E-01, .523447E+00, .212869E-01, .714240E-01,
     & .714240E-01, .268637E-01, .268832E-01, .268832E-01, .268637E-01,
     & .518729E+00, .226367E-01, .726523E-01, .726523E-01, .278697E-01,
     & .278900E-01, .278900E-01, .278697E-01, .510641E+00, .238420E-01,
     & .736741E-01, .736741E-01, .287338E-01, .287547E-01, .287547E-01,
     & .287338E-01, .499630E+00, .248984E-01, .744886E-01, .744886E-01,
     & .294542E-01, .294757E-01, .294757E-01, .294542E-01, .486140E+00,
     & .258043E-01, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00/
      DATA (DL(K),K= 1276, 1360) /
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .499162E-01, .499162E-01, .534441E-02, .534441E-02, .534441E-02,
     & .534441E-02, .191108E+00,-.151788E-17, .519197E-01, .519197E-01,
     & .646285E-02, .646402E-02, .646402E-02, .646285E-02, .232539E+00,
     & .137669E-02, .539504E-01, .539504E-01, .769150E-02, .769377E-02,
     & .769377E-02, .769150E-02, .269907E+00, .285489E-02, .559598E-01,
     & .559598E-01, .898389E-02, .898721E-02, .898721E-02, .898389E-02,
     & .302186E+00, .438814E-02, .579130E-01, .579130E-01, .103061E-01,
     & .103104E-01, .103104E-01, .103061E-01, .329124E+00, .594258E-02,
     & .597754E-01, .597754E-01, .116245E-01, .116297E-01, .116297E-01,
     & .116245E-01, .350643E+00, .748452E-02, .615191E-01, .615191E-01,
     & .129113E-01, .129174E-01, .129174E-01, .129113E-01, .366890E+00,
     & .898645E-02, .631204E-01, .631204E-01, .141428E-01, .141497E-01,
     & .141497E-01, .141428E-01, .378134E+00, .104247E-01, .645601E-01,
     & .645601E-01, .152995E-01, .153071E-01, .153071E-01, .152995E-01,
     & .384719E+00, .117798E-01, .658236E-01, .658236E-01, .163657E-01,
     & .163739E-01, .163739E-01, .163657E-01, .387045E+00, .130362E-01/
      DATA (DL(K),K= 1361, 1445) /
     & .669000E-01, .669000E-01, .173294E-01, .173381E-01, .173381E-01,
     & .173294E-01, .385547E+00, .141821E-01, .677824E-01, .677824E-01,
     & .181820E-01, .181912E-01, .181912E-01, .181820E-01, .380677E+00,
     & .152091E-01, .684672E-01, .684672E-01, .189180E-01, .189277E-01,
     & .189277E-01, .189180E-01, .372894E+00, .161119E-01, .689539E-01,
     & .689539E-01, .195349E-01, .195449E-01, .195449E-01, .195349E-01,
     & .362650E+00, .168880E-01, .692447E-01, .692447E-01, .200324E-01,
     & .200427E-01, .200427E-01, .200324E-01, .350383E+00, .175374E-01,
     & .693442E-01, .693442E-01, .204123E-01, .204229E-01, .204229E-01,
     & .204123E-01, .336505E+00, .180622E-01, .692590E-01, .692590E-01,
     & .206783E-01, .206891E-01, .206891E-01, .206783E-01, .321403E+00,
     & .184661E-01, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .554152E-01, .554152E-01, .386683E-02, .386683E-02, .386683E-02/
      DATA (DL(K),K= 1446, 1530) /
     & .386683E-02, .185844E+00,-.151788E-17, .571372E-01, .571372E-01,
     & .493623E-02, .493704E-02, .493704E-02, .493623E-02, .219342E+00,
     & .129037E-02, .588098E-01, .588098E-01, .606768E-02, .606924E-02,
     & .606924E-02, .606768E-02, .248288E+00, .263296E-02, .603896E-01,
     & .603896E-01, .721747E-02, .721973E-02, .721973E-02, .721747E-02,
     & .271974E+00, .398431E-02, .618484E-01, .618484E-01, .835658E-02,
     & .835949E-02, .835949E-02, .835658E-02, .290397E+00, .531560E-02,
     & .631600E-01, .631600E-01, .945726E-02, .946074E-02, .946074E-02,
     & .945726E-02, .303702E+00, .659930E-02, .643051E-01, .643051E-01,
     & .104983E-01, .105023E-01, .105023E-01, .104983E-01, .312209E+00,
     & .781443E-02, .652691E-01, .652691E-01, .114624E-01, .114669E-01,
     & .114669E-01, .114624E-01, .316328E+00, .894407E-02, .660416E-01,
     & .660416E-01, .123367E-01, .123416E-01, .123416E-01, .123367E-01,
     & .316509E+00, .997546E-02, .666169E-01, .666169E-01, .131119E-01,
     & .131171E-01, .131171E-01, .131119E-01, .313229E+00, .108996E-01,
     & .669925E-01, .669925E-01, .137818E-01, .137874E-01, .137874E-01,
     & .137818E-01, .306974E+00, .117107E-01, .671695E-01, .671695E-01/
      DATA (DL(K),K= 1531, 1615) /
     & .143437E-01, .143495E-01, .143495E-01, .143437E-01, .298224E+00,
     & .124061E-01, .671517E-01, .671517E-01, .147970E-01, .148031E-01,
     & .148031E-01, .147970E-01, .287441E+00, .129858E-01, .669454E-01,
     & .669454E-01, .151437E-01, .151499E-01, .151499E-01, .151437E-01,
     & .275064E+00, .134517E-01, .665590E-01, .665590E-01, .153872E-01,
     & .153935E-01, .153935E-01, .153872E-01, .261497E+00, .138078E-01,
     & .660023E-01, .660023E-01, .155327E-01, .155391E-01, .155391E-01,
     & .155327E-01, .247105E+00, .140595E-01, .652865E-01, .652865E-01,
     & .155864E-01, .155929E-01, .155929E-01, .155864E-01, .232218E+00,
     & .142131E-01, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .601098E-01, .601098E-01, .278641E-02, .278641E-02, .278641E-02,
     & .278641E-02, .183460E+00, .130104E-17, .614949E-01, .614949E-01,
     & .382710E-02, .382771E-02, .382771E-02, .382710E-02, .211150E+00/
      DATA (DL(K),K= 1616, 1700) /
     & .122320E-02, .627722E-01, .627722E-01, .489465E-02, .489580E-02,
     & .489580E-02, .489465E-02, .234040E+00, .246333E-02, .639042E-01,
     & .639042E-01, .594825E-02, .594990E-02, .594990E-02, .594825E-02,
     & .251649E+00, .367998E-02, .648697E-01, .648697E-01, .696315E-02,
     & .696526E-02, .696526E-02, .696315E-02, .264143E+00, .484875E-02,
     & .656502E-01, .656502E-01, .791658E-02, .791907E-02, .791907E-02,
     & .791658E-02, .271822E+00, .594722E-02, .662343E-01, .662343E-01,
     & .879236E-02, .879520E-02, .879520E-02, .879236E-02, .275124E+00,
     & .695957E-02, .666152E-01, .666152E-01, .957846E-02, .958160E-02,
     & .958160E-02, .957846E-02, .274549E+00, .787413E-02, .667905E-01,
     & .667905E-01, .102668E-01, .102702E-01, .102702E-01, .102668E-01,
     & .270615E+00, .868318E-02, .667616E-01, .667616E-01, .108528E-01,
     & .108564E-01, .108564E-01, .108528E-01, .263847E+00, .938250E-02,
     & .665331E-01, .665331E-01, .113349E-01, .113387E-01, .113387E-01,
     & .113349E-01, .254756E+00, .997082E-02, .661123E-01, .661123E-01,
     & .117139E-01, .117179E-01, .117179E-01, .117139E-01, .243828E+00,
     & .104494E-01, .655090E-01, .655090E-01, .119931E-01, .119971E-01/
      DATA (DL(K),K= 1701, 1785) /
     & .119971E-01, .119931E-01, .231518E+00, .108217E-01, .647345E-01,
     & .647345E-01, .121770E-01, .121811E-01, .121811E-01, .121770E-01,
     & .218237E+00, .110927E-01, .638017E-01, .638017E-01, .122717E-01,
     & .122759E-01, .122759E-01, .122717E-01, .204353E+00, .112689E-01,
     & .627241E-01, .627241E-01, .122842E-01, .122884E-01, .122884E-01,
     & .122842E-01, .190187E+00, .113573E-01, .615161E-01, .615161E-01,
     & .122221E-01, .122262E-01, .122262E-01, .122221E-01, .176012E+00,
     & .113659E-01, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .641221E-01, .641221E-01, .198544E-02, .198544E-02, .198544E-02,
     & .198544E-02, .183018E+00, .184314E-17, .651208E-01, .651208E-01,
     & .300778E-02, .300823E-02, .300823E-02, .300778E-02, .206180E+00,
     & .116844E-02, .659664E-01, .659664E-01, .402903E-02, .402989E-02,
     & .402989E-02, .402903E-02, .224390E+00, .232648E-02, .666277E-01/
      DATA (DL(K),K= 1786, 1870) /
     & .666277E-01, .501117E-02, .501238E-02, .501238E-02, .501117E-02,
     & .237332E+00, .343657E-02, .670904E-01, .670904E-01, .593321E-02,
     & .593473E-02, .593473E-02, .593321E-02, .245310E+00, .447818E-02,
     & .673435E-01, .673435E-01, .677663E-02, .677843E-02, .677843E-02,
     & .677663E-02, .248743E+00, .543320E-02, .673832E-01, .673832E-01,
     & .752958E-02, .753161E-02, .753161E-02, .752958E-02, .248162E+00,
     & .629021E-02, .672099E-01, .672099E-01, .818432E-02, .818655E-02,
     & .818655E-02, .818432E-02, .244140E+00, .704188E-02, .668281E-01,
     & .668281E-01, .873688E-02, .873927E-02, .873927E-02, .873688E-02,
     & .237247E+00, .768463E-02, .662457E-01, .662457E-01, .918650E-02,
     & .918903E-02, .918903E-02, .918650E-02, .228043E+00, .821808E-02,
     & .654734E-01, .654734E-01, .953502E-02, .953766E-02, .953766E-02,
     & .953502E-02, .217054E+00, .864446E-02, .645238E-01, .645238E-01,
     & .978645E-02, .978915E-02, .978915E-02, .978645E-02, .204766E+00,
     & .896811E-02, .634114E-01, .634114E-01, .994639E-02, .994915E-02,
     & .994915E-02, .994639E-02, .191614E+00, .919500E-02, .621515E-01,
     & .621515E-01, .100217E-01, .100245E-01, .100245E-01, .100217E-01/
      DATA (DL(K),K= 1871, 1955) /
     & .177983E+00, .933229E-02, .607602E-01, .607602E-01, .100200E-01,
     & .100228E-01, .100228E-01, .100200E-01, .164201E+00, .938793E-02,
     & .592539E-01, .592539E-01, .994938E-02, .995217E-02, .995217E-02,
     & .994938E-02, .150544E+00, .937032E-02, .576488E-01, .576488E-01,
     & .981814E-02, .982091E-02, .982091E-02, .981814E-02, .137234E+00,
     & .928803E-02, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .675167E-01, .675167E-01, .139130E-02, .139130E-02, .139130E-02,
     & .139130E-02, .184090E+00, .113841E-17, .680840E-01, .680840E-01,
     & .240061E-02, .240097E-02, .240097E-02, .240061E-02, .203559E+00,
     & .112278E-02, .684634E-01, .684634E-01, .338513E-02, .338580E-02,
     & .338580E-02, .338513E-02, .217944E+00, .221249E-02, .686304E-01,
     & .686304E-01, .430938E-02, .431032E-02, .431032E-02, .430938E-02,
     & .227068E+00, .323420E-02, .685779E-01, .685779E-01, .515589E-02/
      DATA (DL(K),K= 1956, 2040) /
     & .515707E-02, .515707E-02, .515589E-02, .231353E+00, .417091E-02,
     & .683023E-01, .683023E-01, .591002E-02, .591140E-02, .591140E-02,
     & .591002E-02, .231327E+00, .500843E-02, .678068E-01, .678068E-01,
     & .656383E-02, .656537E-02, .656537E-02, .656383E-02, .227606E+00,
     & .573925E-02, .670989E-01, .670989E-01, .711344E-02, .711513E-02,
     & .711513E-02, .711344E-02, .220833E+00, .635992E-02, .661895E-01,
     & .661895E-01, .755852E-02, .756031E-02, .756031E-02, .755852E-02,
     & .211624E+00, .687048E-02, .650923E-01, .650923E-01, .790162E-02,
     & .790350E-02, .790350E-02, .790162E-02, .200567E+00, .727387E-02,
     & .638232E-01, .638232E-01, .814753E-02, .814946E-02, .814946E-02,
     & .814753E-02, .188197E+00, .757524E-02, .623994E-01, .623994E-01,
     & .830271E-02, .830469E-02, .830469E-02, .830271E-02, .174994E+00,
     & .778139E-02, .608390E-01, .608390E-01, .837482E-02, .837682E-02,
     & .837682E-02, .837482E-02, .161373E+00, .790029E-02, .591605E-01,
     & .591605E-01, .837226E-02, .837426E-02, .837426E-02, .837226E-02,
     & .147685E+00, .794065E-02, .573824E-01, .573824E-01, .830376E-02,
     & .830575E-02, .830575E-02, .830376E-02, .134218E+00, .791148E-02/
      DATA (DL(K),K= 2041, 2125) /
     & .555224E-01, .555224E-01, .817811E-02, .818008E-02, .818008E-02,
     & .817811E-02, .121200E+00, .782185E-02, .535980E-01, .535980E-01,
     & .800390E-02, .800584E-02, .800584E-02, .800390E-02, .108803E+00,
     & .768059E-02, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .703249E-01, .703249E-01, .953926E-03, .953926E-03, .953926E-03,
     & .953926E-03, .186497E+00, .108420E-18, .704188E-01, .704188E-01,
     & .195267E-02, .195297E-02, .195297E-02, .195267E-02, .202831E+00,
     & .108414E-02, .702995E-01, .702995E-01, .290528E-02, .290582E-02,
     & .290582E-02, .290528E-02, .213933E+00, .211514E-02, .699499E-01,
     & .699499E-01, .377873E-02, .377950E-02, .377950E-02, .377873E-02,
     & .219748E+00, .306054E-02, .693699E-01, .693699E-01, .455903E-02,
     & .455997E-02, .455997E-02, .455903E-02, .220821E+00, .390679E-02,
     & .685634E-01, .685634E-01, .523531E-02, .523640E-02, .523640E-02/
      DATA (DL(K),K= 2126, 2210) /
     & .523531E-02, .217787E+00, .464347E-02, .675406E-01, .675406E-01,
     & .580340E-02, .580462E-02, .580462E-02, .580340E-02, .211353E+00,
     & .526681E-02, .663155E-01, .663155E-01, .626315E-02, .626446E-02,
     & .626446E-02, .626315E-02, .202230E+00, .577705E-02, .649052E-01,
     & .649052E-01, .661759E-02, .661897E-02, .661897E-02, .661759E-02,
     & .191081E+00, .617758E-02, .633285E-01, .633285E-01, .687230E-02,
     & .687373E-02, .687373E-02, .687230E-02, .178518E+00, .647434E-02,
     & .616058E-01, .616058E-01, .703464E-02, .703611E-02, .703611E-02,
     & .703464E-02, .165082E+00, .667499E-02, .597580E-01, .597580E-01,
     & .711320E-02, .711468E-02, .711468E-02, .711320E-02, .151241E+00,
     & .678842E-02, .578059E-01, .578059E-01, .711723E-02, .711872E-02,
     & .711872E-02, .711723E-02, .137382E+00, .682417E-02, .557702E-01,
     & .557702E-01, .705628E-02, .705776E-02, .705776E-02, .705628E-02,
     & .123821E+00, .679205E-02, .536704E-01, .536704E-01, .693979E-02,
     & .694125E-02, .694125E-02, .693979E-02, .110798E+00, .670173E-02,
     & .515252E-01, .515252E-01, .677689E-02, .677832E-02, .677832E-02,
     & .677689E-02, .984933E-01, .656256E-02, .493519E-01, .493519E-01/
      DATA (DL(K),K= 2211, 2295) /
     & .657614E-02, .657753E-02, .657753E-02, .657614E-02, .870270E-01,
     & .638332E-02, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .725555E-01, .725555E-01, .636424E-03, .636424E-03, .636424E-03,
     & .636424E-03, .190200E+00,-.271051E-17, .721364E-01, .721364E-01,
     & .162522E-02, .162546E-02, .162546E-02, .162522E-02, .203770E+00,
     & .105090E-02, .714881E-01, .714881E-01, .254763E-02, .254807E-02,
     & .254807E-02, .254763E-02, .211914E+00, .202976E-02, .706012E-01,
     & .706012E-01, .337323E-02, .337384E-02, .337384E-02, .337323E-02,
     & .214704E+00, .290668E-02, .694832E-01, .694832E-01, .409164E-02,
     & .409240E-02, .409240E-02, .409164E-02, .212817E+00, .367169E-02,
     & .681454E-01, .681454E-01, .469593E-02, .469679E-02, .469679E-02,
     & .469593E-02, .207013E+00, .431823E-02, .666048E-01, .666048E-01,
     & .518578E-02, .518673E-02, .518673E-02, .518578E-02, .198095E+00/
      DATA (DL(K),K= 2296, 2380) /
     & .484637E-02, .648819E-01, .648819E-01, .556473E-02, .556575E-02,
     & .556575E-02, .556473E-02, .186850E+00, .525997E-02, .629989E-01,
     & .629989E-01, .583908E-02, .584014E-02, .584014E-02, .583908E-02,
     & .173986E+00, .556566E-02, .609795E-01, .609795E-01, .601725E-02,
     & .601834E-02, .601834E-02, .601725E-02, .160140E+00, .577215E-02,
     & .588474E-01, .588474E-01, .610889E-02, .611000E-02, .611000E-02,
     & .610889E-02, .145850E+00, .588934E-02, .566261E-01, .566261E-01,
     & .612435E-02, .612547E-02, .612547E-02, .612435E-02, .131564E+00,
     & .592785E-02, .543385E-01, .543385E-01, .607415E-02, .607526E-02,
     & .607526E-02, .607415E-02, .117636E+00, .589841E-02, .520060E-01,
     & .520060E-01, .596861E-02, .596970E-02, .596970E-02, .596861E-02,
     & .104336E+00, .581156E-02, .496485E-01, .496485E-01, .581753E-02,
     & .581860E-02, .581860E-02, .581753E-02, .918563E-01, .567728E-02,
     & .472842E-01, .472842E-01, .563002E-02, .563105E-02, .563105E-02,
     & .563002E-02, .803205E-01, .550487E-02, .449295E-01, .449295E-01,
     & .541435E-02, .541535E-02, .541535E-02, .541435E-02, .697975E-01,
     & .530276E-02, .000000E+00, .000000E+00, .000000E+00, .000000E+00/
      DATA (DL(K),K= 2381, 2465) /
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .742000E-01, .742000E-01, .410482E-03, .410482E-03, .410482E-03,
     & .410482E-03, .195273E+00,-.143657E-17, .732296E-01, .732296E-01,
     & .138854E-02, .138874E-02, .138874E-02, .138854E-02, .206298E+00,
     & .102151E-02, .720241E-01, .720241E-01, .228017E-02, .228054E-02,
     & .228054E-02, .228017E-02, .211639E+00, .195225E-02, .705820E-01,
     & .705820E-01, .305794E-02, .305844E-02, .305844E-02, .305794E-02,
     & .211509E+00, .276522E-02, .689187E-01, .689187E-01, .371549E-02,
     & .371609E-02, .371609E-02, .371549E-02, .206745E+00, .345441E-02,
     & .670527E-01, .670527E-01, .425016E-02, .425084E-02, .425084E-02,
     & .425016E-02, .198254E+00, .401749E-02, .650080E-01, .650080E-01,
     & .466572E-02, .466647E-02, .466647E-02, .466572E-02, .186950E+00,
     & .445856E-02, .628107E-01, .628107E-01, .496948E-02, .497027E-02,
     & .497027E-02, .496948E-02, .173701E+00, .478517E-02, .604878E-01/
      DATA (DL(K),K= 2466, 2550) /
     & .604878E-01, .517094E-02, .517175E-02, .517175E-02, .517094E-02,
     & .159263E+00, .500709E-02, .580665E-01, .580665E-01, .528116E-02,
     & .528199E-02, .528199E-02, .528116E-02, .144287E+00, .513562E-02,
     & .555730E-01, .555730E-01, .531181E-02, .531265E-02, .531265E-02,
     & .531181E-02, .129304E+00, .518264E-02, .530325E-01, .530325E-01,
     & .527468E-02, .527550E-02, .527550E-02, .527468E-02, .114731E+00,
     & .516012E-02, .504682E-01, .504682E-01, .518116E-02, .518198E-02,
     & .518198E-02, .518116E-02, .100877E+00, .507964E-02, .479014E-01,
     & .479014E-01, .504198E-02, .504278E-02, .504278E-02, .504198E-02,
     & .879578E-01, .495209E-02, .453511E-01, .453511E-01, .486695E-02,
     & .486772E-02, .486772E-02, .486695E-02, .761077E-01, .478741E-02,
     & .428340E-01, .428340E-01, .466486E-02, .466560E-02, .466560E-02,
     & .466486E-02, .653932E-01, .459453E-02, .403645E-01, .403645E-01,
     & .444342E-02, .444413E-02, .444413E-02, .444342E-02, .558281E-01,
     & .438128E-02, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00/
      DATA (DL(K),K= 2551, 2635) /
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .752337E-01, .752337E-01, .253875E-03, .253875E-03, .253875E-03,
     & .253875E-03, .201902E+00,-.159920E-17, .736752E-01, .736752E-01,
     & .121909E-02, .121925E-02, .121925E-02, .121909E-02, .210465E+00,
     & .994282E-03, .718865E-01, .718865E-01, .207747E-02, .207776E-02,
     & .207776E-02, .207747E-02, .212997E+00, .187854E-02, .698746E-01,
     & .698746E-01, .280521E-02, .280560E-02, .280560E-02, .280521E-02,
     & .209895E+00, .262933E-02, .676629E-01, .676629E-01, .340063E-02,
     & .340109E-02, .340109E-02, .340063E-02, .202191E+00, .324527E-02,
     & .652775E-01, .652775E-01, .386588E-02, .386641E-02, .386641E-02,
     & .386588E-02, .190971E+00, .372876E-02, .627483E-01, .627483E-01,
     & .420910E-02, .420967E-02, .420967E-02, .420910E-02, .177278E+00,
     & .408818E-02, .601066E-01, .601066E-01, .444148E-02, .444208E-02,
     & .444208E-02, .444148E-02, .162071E+00, .433493E-02, .573831E-01,
     & .573831E-01, .457564E-02, .457625E-02, .457625E-02, .457564E-02,
     & .146148E+00, .448183E-02, .546072E-01, .546072E-01, .462506E-02/
      DATA (DL(K),K= 2636, 2720) /
     & .462567E-02, .462567E-02, .462506E-02, .130166E+00, .454252E-02,
     & .518065E-01, .518065E-01, .460307E-02, .460368E-02, .460368E-02,
     & .460307E-02, .114632E+00, .453052E-02, .490062E-01, .490062E-01,
     & .452252E-02, .452312E-02, .452312E-02, .452252E-02, .999175E-01,
     & .445880E-02, .462287E-01, .462287E-01, .439529E-02, .439588E-02,
     & .439588E-02, .439529E-02, .862750E-01, .433936E-02, .434937E-01,
     & .434937E-01, .423211E-02, .423268E-02, .423268E-02, .423211E-02,
     & .738542E-01, .418306E-02, .408180E-01, .408180E-01, .404245E-02,
     & .404299E-02, .404299E-02, .404245E-02, .627228E-01, .399946E-02,
     & .382157E-01, .382157E-01, .383446E-02, .383498E-02, .383498E-02,
     & .383446E-02, .528847E-01, .379682E-02, .356980E-01, .356980E-01,
     & .361508E-02, .361557E-02, .361557E-02, .361508E-02, .442963E-01,
     & .358213E-02, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00/
      DATA (DL(K),K= 2721, 2805) /
     & .756149E-01, .756149E-01, .148956E-03, .148956E-03, .148956E-03,
     & .148956E-03, .210410E+00,-.149078E-18, .734321E-01, .734321E-01,
     & .109779E-02, .109791E-02, .109791E-02, .109779E-02, .216444E+00,
     & .967243E-03, .710369E-01, .710369E-01, .191860E-02, .191882E-02,
     & .191882E-02, .191860E-02, .215992E+00, .180426E-02, .684452E-01,
     & .684452E-01, .259230E-02, .259259E-02, .259259E-02, .259230E-02,
     & .209697E+00, .249224E-02, .656884E-01, .656884E-01, .312270E-02,
     & .312305E-02, .312305E-02, .312270E-02, .198844E+00, .303522E-02,
     & .627994E-01, .627994E-01, .351747E-02, .351786E-02, .351786E-02,
     & .351747E-02, .184740E+00, .344105E-02, .598138E-01, .598138E-01,
     & .378940E-02, .378981E-02, .378981E-02, .378940E-02, .168578E+00,
     & .372269E-02, .567666E-01, .567666E-01, .395362E-02, .395405E-02,
     & .395405E-02, .395362E-02, .151409E+00, .389544E-02, .536907E-01,
     & .536907E-01, .402569E-02, .402613E-02, .402613E-02, .402569E-02,
     & .134065E+00, .397499E-02, .506163E-01, .506163E-01, .402117E-02,
     & .402161E-02, .402161E-02, .402117E-02, .117191E+00, .397702E-02,
     & .475706E-01, .475706E-01, .395467E-02, .395511E-02, .395511E-02/
      DATA (DL(K),K= 2806, 2890) /
     & .395467E-02, .101250E+00, .391626E-02, .445771E-01, .445771E-01,
     & .383961E-02, .384003E-02, .384003E-02, .383961E-02, .865500E-01,
     & .380621E-02, .416559E-01, .416559E-01, .368789E-02, .368830E-02,
     & .368830E-02, .368789E-02, .732657E-01, .365888E-02, .388235E-01,
     & .388235E-01, .350985E-02, .351025E-02, .351025E-02, .350985E-02,
     & .614686E-01, .348466E-02, .360931E-01, .360931E-01, .331425E-02,
     & .331462E-02, .331462E-02, .331425E-02, .511511E-01, .329240E-02,
     & .334751E-01, .334751E-01, .310835E-02, .310870E-02, .310870E-02,
     & .310835E-02, .422485E-01, .308941E-02, .309768E-01, .309768E-01,
     & .289805E-02, .289838E-02, .289838E-02, .289805E-02, .346590E-01,
     & .288164E-02, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .752796E-01, .752796E-01, .816906E-04, .816906E-04, .816906E-04,
     & .816906E-04, .221322E+00, .298156E-18, .724376E-01, .724376E-01/
      DATA (DL(K),K= 2891, 2975) /
     & .100884E-02, .100894E-02, .100894E-02, .100884E-02, .224569E+00,
     & .938046E-03, .694166E-01, .694166E-01, .178592E-02, .178609E-02,
     & .178609E-02, .178592E-02, .220745E+00, .172460E-02, .662414E-01,
     & .662414E-01, .240001E-02, .240024E-02, .240024E-02, .240001E-02,
     & .210839E+00, .234694E-02, .629511E-01, .629511E-01, .286144E-02,
     & .286171E-02, .286171E-02, .286144E-02, .196463E+00, .281556E-02,
     & .595849E-01, .595849E-01, .318412E-02, .318441E-02, .318441E-02,
     & .318412E-02, .179204E+00, .314448E-02, .561822E-01, .561822E-01,
     & .338573E-02, .338605E-02, .338605E-02, .338573E-02, .160420E+00,
     & .335151E-02, .527801E-01, .527801E-01, .348530E-02, .348562E-02,
     & .348562E-02, .348530E-02, .141254E+00, .345578E-02, .494117E-01,
     & .494117E-01, .350098E-02, .350131E-02, .350131E-02, .350098E-02,
     & .122547E+00, .347555E-02, .461061E-01, .461061E-01, .344994E-02,
     & .345026E-02, .345026E-02, .344994E-02, .104908E+00, .342804E-02,
     & .428876E-01, .428876E-01, .334753E-02, .334784E-02, .334784E-02,
     & .334753E-02, .887264E-01, .332868E-02, .397764E-01, .397764E-01,
     & .320718E-02, .320748E-02, .320748E-02, .320718E-02, .742160E-01/
      DATA (DL(K),K= 2976, 3060) /
     & .319097E-02, .367882E-01, .367882E-01, .304033E-02, .304062E-02,
     & .304062E-02, .304033E-02, .614556E-01, .302641E-02, .339348E-01,
     & .339348E-01, .285650E-02, .285677E-02, .285677E-02, .285650E-02,
     & .504214E-01, .284454E-02, .312247E-01, .312247E-01, .266337E-02,
     & .266363E-02, .266363E-02, .266337E-02, .410205E-01, .265311E-02,
     & .286629E-01, .286629E-01, .246705E-02, .246730E-02, .246730E-02,
     & .246705E-02, .331166E-01, .245826E-02, .262521E-01, .262521E-01,
     & .227226E-02, .227248E-02, .227248E-02, .227226E-02, .265498E-01,
     & .226473E-02, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .741335E-01, .741335E-01, .409835E-04, .409835E-04, .409835E-04,
     & .409835E-04, .235495E+00,-.158395E-17, .705990E-01, .705990E-01,
     & .938808E-03, .938883E-03, .938883E-03, .938808E-03, .235413E+00,
     & .903728E-03, .669383E-01, .669383E-01, .166382E-02, .166395E-02/
      DATA (DL(K),K= 3061, 3145) /
     & .166395E-02, .166382E-02, .227523E+00, .163381E-02, .631853E-01,
     & .631853E-01, .221128E-02, .221145E-02, .221145E-02, .221128E-02,
     & .213316E+00, .218562E-02, .593855E-01, .593855E-01, .259911E-02,
     & .259931E-02, .259931E-02, .259911E-02, .194833E+00, .257720E-02,
     & .555825E-01, .555825E-01, .284819E-02, .284841E-02, .284841E-02,
     & .284819E-02, .174012E+00, .282950E-02, .518174E-01, .518174E-01,
     & .298117E-02, .298140E-02, .298140E-02, .298117E-02, .152385E+00,
     & .296523E-02, .481268E-01, .481268E-01, .302067E-02, .302090E-02,
     & .302090E-02, .302067E-02, .131168E+00, .300708E-02, .445413E-01,
     & .445413E-01, .298689E-02, .298712E-02, .298712E-02, .298689E-02,
     & .111177E+00, .297532E-02, .410859E-01, .410859E-01, .289793E-02,
     & .289815E-02, .289815E-02, .289793E-02, .929352E-01, .288809E-02,
     & .377798E-01, .377798E-01, .276920E-02, .276941E-02, .276941E-02,
     & .276920E-02, .767178E-01, .276084E-02, .346372E-01, .346372E-01,
     & .261353E-02, .261373E-02, .261373E-02, .261353E-02, .626102E-01,
     & .260643E-02, .316676E-01, .316676E-01, .244134E-02, .244154E-02,
     & .244154E-02, .244134E-02, .505665E-01, .243531E-02, .288765E-01/
      DATA (DL(K),K= 3146, 3230) /
     & .288765E-01, .226087E-02, .226105E-02, .226105E-02, .226087E-02,
     & .404527E-01, .225576E-02, .262660E-01, .262660E-01, .207845E-02,
     & .207862E-02, .207862E-02, .207845E-02, .320820E-01, .207412E-02,
     & .238351E-01, .238351E-01, .189881E-02, .189897E-02, .189897E-02,
     & .189881E-02, .252422E-01, .189514E-02, .215808E-01, .215808E-01,
     & .172536E-02, .172551E-02, .172551E-02, .172536E-02, .197186E-01,
     & .172225E-02, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .720339E-01, .720339E-01, .181946E-04, .181946E-04, .181946E-04,
     & .181946E-04, .254393E+00, .469256E-18, .677768E-01, .677768E-01,
     & .875835E-03, .875888E-03, .875888E-03, .875835E-03, .249966E+00,
     & .860480E-03, .634725E-01, .634725E-01, .153792E-02, .153801E-02,
     & .153801E-02, .153792E-02, .236824E+00, .152496E-02, .591619E-01,
     & .591619E-01, .201036E-02, .201048E-02, .201048E-02, .201036E-02/
      DATA (DL(K),K= 3231, 3315) /
     & .217211E+00, .199944E-02, .548948E-01, .548948E-01, .231978E-02,
     & .231992E-02, .231992E-02, .231978E-02, .193739E+00, .231058E-02,
     & .507162E-01, .507162E-01, .249460E-02, .249475E-02, .249475E-02,
     & .249460E-02, .168773E+00, .248686E-02, .466653E-01, .466653E-01,
     & .256217E-02, .256232E-02, .256232E-02, .256217E-02, .144012E+00,
     & .255566E-02, .427744E-01, .427744E-01, .254804E-02, .254820E-02,
     & .254820E-02, .254804E-02, .120695E+00, .254258E-02, .390676E-01,
     & .390676E-01, .247365E-02, .247380E-02, .247380E-02, .247365E-02,
     & .995452E-01, .246906E-02, .355626E-01, .355626E-01, .235710E-02,
     & .235725E-02, .235725E-02, .235710E-02, .809281E-01, .235325E-02,
     & .322703E-01, .322703E-01, .221303E-02, .221317E-02, .221317E-02,
     & .221303E-02, .649429E-01, .220980E-02, .291963E-01, .291963E-01,
     & .205294E-02, .205307E-02, .205307E-02, .205294E-02, .515039E-01,
     & .205024E-02, .263419E-01, .263419E-01, .188569E-02, .188581E-02,
     & .188581E-02, .188569E-02, .404102E-01, .188343E-02, .237044E-01,
     & .237044E-01, .171783E-02, .171795E-02, .171795E-02, .171783E-02,
     & .313959E-01, .171594E-02, .212782E-01, .212782E-01, .155409E-02/
      DATA (DL(K),K= 3316, 3400) /
     & .155419E-02, .155419E-02, .155409E-02, .241750E-01, .155251E-02,
     & .190555E-01, .190555E-01, .139767E-02, .139777E-02, .139777E-02,
     & .139767E-02, .184646E-01, .139635E-02, .170270E-01, .170270E-01,
     & .125065E-02, .125074E-02, .125074E-02, .125065E-02, .139996E-01,
     & .124955E-02, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .687547E-01, .687547E-01, .676181E-05, .676181E-05, .676181E-05,
     & .676181E-05, .280728E+00,-.145838E-17, .637529E-01, .637529E-01,
     & .808781E-03, .808818E-03, .808818E-03, .808781E-03, .270033E+00,
     & .803169E-03, .588180E-01, .588180E-01, .139388E-02, .139394E-02,
     & .139394E-02, .139388E-02, .249568E+00, .138922E-02, .539945E-01,
     & .539945E-01, .178168E-02, .178176E-02, .178176E-02, .178168E-02,
     & .222743E+00, .177782E-02, .493317E-01, .493317E-01, .200838E-02,
     & .200848E-02, .200848E-02, .200838E-02, .192919E+00, .200519E-02/
      DATA (DL(K),K= 3401, 3485) /
     & .448709E-01, .448709E-01, .211009E-02, .211019E-02, .211019E-02,
     & .211009E-02, .162975E+00, .210745E-02, .406433E-01, .406433E-01,
     & .211805E-02, .211815E-02, .211815E-02, .211805E-02, .134716E+00,
     & .211586E-02, .366716E-01, .366716E-01, .205957E-02, .205968E-02,
     & .205968E-02, .205957E-02, .109289E+00, .205776E-02, .329687E-01,
     & .329687E-01, .195606E-02, .195616E-02, .195616E-02, .195606E-02,
     & .871955E-01, .195457E-02, .295400E-01, .295400E-01, .182447E-02,
     & .182456E-02, .182456E-02, .182447E-02, .685399E-01, .182323E-02,
     & .263849E-01, .263849E-01, .167765E-02, .167774E-02, .167774E-02,
     & .167765E-02, .531615E-01, .167663E-02, .234975E-01, .234975E-01,
     & .152505E-02, .152514E-02, .152514E-02, .152505E-02, .407334E-01,
     & .152421E-02, .208683E-01, .208683E-01, .137342E-02, .137350E-02,
     & .137350E-02, .137342E-02, .308674E-01, .137273E-02, .184852E-01,
     & .184852E-01, .122732E-02, .122739E-02, .122739E-02, .122732E-02,
     & .231578E-01, .122675E-02, .163340E-01, .163340E-01, .108968E-02,
     & .108975E-02, .108975E-02, .108968E-02, .172149E-01, .108921E-02,
     & .143996E-01, .143996E-01, .962198E-03, .962260E-03, .962260E-03/
      DATA (DL(K),K= 3486, 3570) /
     & .962198E-03, .126908E-01, .961815E-03, .126661E-01, .126661E-01,
     & .845675E-03, .845732E-03, .845732E-03, .845675E-03, .928555E-02,
     & .845361E-03, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .639050E-01, .639050E-01, .189600E-05, .189600E-05, .189600E-05,
     & .189600E-05, .320203E+00, .545701E-18, .581555E-01, .581555E-01,
     & .725861E-03, .725886E-03, .725886E-03, .725861E-03, .299305E+00,
     & .724320E-03, .526376E-01, .526376E-01, .121568E-02, .121572E-02,
     & .121572E-02, .121568E-02, .267591E+00, .121442E-02, .473911E-01,
     & .473911E-01, .150820E-02, .150825E-02, .150825E-02, .150820E-02,
     & .230364E+00, .150718E-02, .424558E-01, .424558E-01, .164949E-02,
     & .164955E-02, .164955E-02, .164949E-02, .191972E+00, .164867E-02,
     & .378600E-01, .378600E-01, .168256E-02, .168262E-02, .168262E-02,
     & .168256E-02, .155818E+00, .168189E-02, .336181E-01, .336181E-01/
      DATA (DL(K),K= 3571, 3655) /
     & .164080E-02, .164086E-02, .164086E-02, .164080E-02, .123609E+00,
     & .164026E-02, .297349E-01, .297349E-01, .155136E-02, .155142E-02,
     & .155142E-02, .155136E-02, .961680E-01, .155092E-02, .262052E-01,
     & .262052E-01, .143382E-02, .143388E-02, .143388E-02, .143382E-02,
     & .735522E-01, .143346E-02, .230171E-01, .230171E-01, .130247E-02,
     & .130253E-02, .130253E-02, .130247E-02, .553916E-01, .130218E-02,
     & .201539E-01, .201539E-01, .116733E-02, .116739E-02, .116739E-02,
     & .116733E-02, .411453E-01, .116710E-02, .175955E-01, .175955E-01,
     & .103505E-02, .103510E-02, .103510E-02, .103505E-02, .301858E-01,
     & .103486E-02, .153199E-01, .153199E-01, .909828E-03, .909880E-03,
     & .909880E-03, .909828E-03, .218957E-01, .909677E-03, .133043E-01,
     & .133043E-01, .794097E-03, .794146E-03, .794146E-03, .794097E-03,
     & .157204E-01, .793976E-03, .115259E-01, .115259E-01, .689012E-03,
     & .689057E-03, .689057E-03, .689012E-03, .111816E-01, .688913E-03,
     & .996208E-02, .996208E-02, .594880E-03, .594922E-03, .594922E-03,
     & .594880E-03, .788559E-02, .594801E-03, .859151E-02, .859151E-02,
     & .511455E-03, .511493E-03, .511493E-03, .511455E-03, .551865E-02/
      DATA (DL(K),K= 3656, 3740) /
     & .511392E-03, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .567030E-01, .567030E-01, .317692E-06, .317692E-06, .317692E-06,
     & .317692E-06, .387655E+00,-.196551E-18, .502560E-01, .502560E-01,
     & .611827E-03, .611838E-03, .611838E-03, .611827E-03, .346975E+00,
     & .611576E-03, .442838E-01, .442838E-01, .981907E-03, .981929E-03,
     & .981929E-03, .981907E-03, .295290E+00, .981708E-03, .388018E-01,
     & .388018E-01, .116826E-02, .116829E-02, .116829E-02, .116826E-02,
     & .241157E+00, .116810E-02, .338227E-01, .338227E-01, .122537E-02,
     & .122541E-02, .122541E-02, .122537E-02, .190062E+00, .122525E-02,
     & .293442E-01, .293442E-01, .120047E-02, .120052E-02, .120052E-02,
     & .120047E-02, .145706E+00, .120037E-02, .253494E-01, .253494E-01,
     & .112580E-02, .112585E-02, .112585E-02, .112580E-02, .109110E+00,
     & .112572E-02, .218132E-01, .218132E-01, .102498E-02, .102503E-02/
      DATA (DL(K),K= 3741, 3825) /
     & .102503E-02, .102498E-02, .800661E-01, .102492E-02, .187030E-01,
     & .187030E-01, .913395E-03, .913450E-03, .913450E-03, .913395E-03,
     & .577342E-01, .913348E-03, .159833E-01, .159833E-01, .800935E-03,
     & .800990E-03, .800990E-03, .800935E-03, .409782E-01, .800898E-03,
     & .136172E-01, .136172E-01, .693698E-03, .693751E-03, .693751E-03,
     & .693698E-03, .286780E-01, .693669E-03, .115681E-01, .115681E-01,
     & .595013E-03, .595064E-03, .595064E-03, .595013E-03, .198197E-01,
     & .594990E-03, .980105E-02, .980105E-02, .506423E-03, .506471E-03,
     & .506471E-03, .506423E-03, .135410E-01, .506405E-03, .828286E-02,
     & .828286E-02, .428323E-03, .428368E-03, .428368E-03, .428323E-03,
     & .915498E-02, .428309E-03, .698303E-02, .698303E-02, .360397E-03,
     & .360439E-03, .360439E-03, .360397E-03, .613133E-02, .360386E-03,
     & .587373E-02, .587373E-02, .301934E-03, .301973E-03, .301973E-03,
     & .301934E-03, .407092E-02, .301925E-03, .492985E-02, .492985E-02,
     & .252029E-03, .252064E-03, .252064E-03, .252029E-03, .268179E-02,
     & .252022E-03, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00/
      DATA (DL(K),K= 3826, 3910) /
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .450567E-01, .450567E-01, .151200E-07, .151200E-07, .151200E-07,
     & .151200E-07, .542258E+00,-.767310E-18, .381624E-01, .381624E-01,
     & .438685E-03, .438751E-03, .438751E-03, .438685E-03, .447480E+00,
     & .438674E-03, .321250E-01, .321250E-01, .653465E-03, .653574E-03,
     & .653574E-03, .653465E-03, .347952E+00, .653456E-03, .268827E-01,
     & .268827E-01, .724735E-03, .724868E-03, .724868E-03, .724735E-03,
     & .258636E+00, .724728E-03, .223751E-01, .223751E-01, .709421E-03,
     & .709567E-03, .709567E-03, .709421E-03, .185088E+00, .709417E-03,
     & .185359E-01, .185359E-01, .650478E-03, .650626E-03, .650626E-03,
     & .650478E-03, .128686E+00, .650474E-03, .152906E-01, .152906E-01,
     & .572423E-03, .572567E-03, .572567E-03, .572423E-03, .873875E-01,
     & .572420E-03, .125654E-01, .125654E-01, .490165E-03, .490302E-03,
     & .490302E-03, .490165E-03, .581141E-01, .490163E-03, .102901E-01,
     & .102901E-01, .411740E-03, .411866E-03, .411866E-03, .411740E-03/
      DATA (DL(K),K= 3911, 3995) /
     & .379596E-01, .411738E-03, .839975E-02, .839975E-02, .340986E-03,
     & .341101E-03, .341101E-03, .340986E-03, .244073E-01, .340985E-03,
     & .683634E-02, .683634E-02, .279417E-03, .279520E-03, .279520E-03,
     & .279417E-03, .154717E-01, .279416E-03, .554846E-02, .554846E-02,
     & .227114E-03, .227204E-03, .227204E-03, .227114E-03, .968450E-02,
     & .227113E-03, .449143E-02, .449143E-02, .183425E-03, .183504E-03,
     & .183504E-03, .183425E-03, .599306E-02, .183425E-03, .362676E-02,
     & .362676E-02, .147387E-03, .147455E-03, .147455E-03, .147387E-03,
     & .366977E-02, .147387E-03, .292164E-02, .292164E-02, .117936E-03,
     & .117995E-03, .117995E-03, .117936E-03, .222583E-02, .117936E-03,
     & .234830E-02, .234830E-02, .940414E-04, .940914E-04, .940914E-04,
     & .940414E-04, .133844E-02, .940412E-04, .188339E-02, .188339E-02,
     & .747651E-04, .748074E-04, .748074E-04, .747651E-04, .798451E-03,
     & .747649E-04, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00/
      DATA (DL(K),K= 3996, 4000) /
     & .000000E+00, .000000E+00, .000000E+00, .000000E+00, .000000E+00/

      DO 10 I=1,7
        QQ(I) = 0.
 10   CONTINUE
      IF(X.GT.0.9985) RETURN

      IS = S/DELTA+1
      IS = MIN(IS,19)
      IS1 = IS+1
      DO 20 I=1,7
        IF(I.EQ.3.AND.X.GT.0.95) GOTO 19
        IF(I.EQ.8.AND.X.GT.0.95) GOTO 19
        DO 30 L=1,25
          F1(L)=GF(I,IS,L)
          F2(L)=GF(I,IS1,L)
 30     CONTINUE
        S1=(IS-1)*DELTA
        S2=S1+DELTA
        A1 = PHO_CKMTFV(X,F1)
        A2 = PHO_CKMTFV(X,F2)
        QQ(I)=A1*(S2-S)/DELTA+A2*(S-S1)/DELTA
 19     CONTINUE
 20   CONTINUE

      END


CDECK  ID>, PHO_CKMTFV
      REAL FUNCTION PHO_CKMTFV(X,FVL)
C**********************************************************************
C
C     LOGARITHMIC INTERPOLATOR - WATCH OUT FOR NEGATIVE
C     FUNCTIONS AND/OR X VALUES OUTSIDE THE RANGE 0 TO 1.
C     NOTE: DIMENSION OF FVL IS OVERWRITTEN BY VALUE USED
C     IN MAIN ROUTINE.
C
C**********************************************************************
      SAVE

      DIMENSION FVL(25),XGRID(25)
      DATA NX,XGRID/25,.001,.002,.004,.008,.016,.032,.064,.1,.15,
     *.2,.25,.3,.35,.4,.45,.5,.55,.6,.65,.7,.75,.8,.85,.9,.95/

      PHO_CKMTFV=0.
      DO 1 I=1,NX
      IF(X.LT.XGRID(I)) GO TO 2
    1 CONTINUE
    2 I=I-1
      IF(I.EQ.0) THEN
         I=I+1
      ELSE IF(I.GT.23) THEN
         I=23
      ENDIF
      J=I+1
      K=J+1
      AXI=LOG(XGRID(I))
      BXI=LOG(1.-XGRID(I))
      AXJ=LOG(XGRID(J))
      BXJ=LOG(1.-XGRID(J))
      AXK=LOG(XGRID(K))
      BXK=LOG(1.-XGRID(K))
      FI=LOG(ABS(FVL(I)) +1.E-15)
      FJ=LOG(ABS(FVL(J)) +1.E-16)
      FK=LOG(ABS(FVL(K)) +1.E-17)
      DET=AXI*(BXJ-BXK)+AXJ*(BXK-BXI)+AXK*(BXI-BXJ)
      ALOGA=(FI*(AXJ*BXK-AXK*BXJ)+FJ*(AXK*BXI-AXI*BXK)+FK*(AXI*BXJ-AXJ*
     $ BXI))/DET
      ALPHA=(FI*(BXJ-BXK)+FJ*(BXK-BXI)+FK*(BXI-BXJ))/DET
      BETA=(FI*(AXK-AXJ)+FJ*(AXI-AXK)+FK*(AXJ-AXI))/DET
      IF(ABS(ALPHA).GT.99..OR.ABS(BETA).GT.99..OR.ABS(ALOGA).GT.99.)
     1RETURN
C      IF(ALPHA.GT.50..OR.BETA.GT.50.) THEN
C         WRITE(6,2001) X,FVL
C 2001    FORMAT(8E12.4)
C         WRITE(6,2001) ALPHA,BETA,ALOGA,DET
C      ENDIF
      PHO_CKMTFV=EXP(ALOGA)*X**ALPHA*(1.-X)**BETA

      END


CDECK  ID>, PHO_SASGAM
C***********************************************************************
C...SaSgam version 2 - parton distributions of the photon
C...by Gerhard A. Schuler and Torbjorn Sjostrand
C...For further information see Z. Phys. C68 (1995) 607
C...and Phys. Lett. B376 (1996) 193.

C...18 January 1996: original code.
C...22 July 1996: calculation of BETA moved in SASBEH.

C!!!Note that one further call parameter - IP2 - has been added
C!!!to the SASGAM argument list compared with version 1.

C...The user should only need to call the SASGAM routine,
C...which in turn calls the auxiliary routines SASVMD, SASANO,
C...SASBEH and SASDIR. The package is self-contained.

C...One particular aspect of these parametrizations is that F2 for
C...the photon is not obtained just as the charge-squared-weighted
C...sum of quark distributions, but differ in the treatment of
C...heavy flavours (in F2 the DIS relation W2 = Q2*(1-x)/x restricts
C...the kinematics range of heavy-flavour production, but the same
C...kinematics is not relevant e.g. for jet production) and, for the
C...'MSbar' fits, in the addition of a Cgamma term related to the
C...separation of direct processes. Schematically:
C...PDF = VMD (rho, omega, phi) + anomalous (d, u, s, c, b).
C...F2  = VMD (rho, omega, phi) + anomalous (d, u, s) +
C...      Bethe-Heitler (c, b) (+ Cgamma (d, u, s)).
C...The J/psi and Upsilon states have not been included in the VMD sum,
C...but low c and b masses in the other components should compensate
C...for this in a duality sense.

C...The calling sequence is the following:
C     CALL SASGAM(ISET,X,Q2,P2,IP2,F2GM,XPDFGM)
C...with the following declaration statement:
C     DIMENSION XPDFGM(-6:6)
C...and, optionally, further information in:
C     COMMON/SASCOM/XPVMD(-6:6),XPANL(-6:6),XPANH(-6:6),XPBEH(-6:6),
C    &XPDIR(-6:6)
C     COMMON/SASVAL/VXPVMD(-6:6),VXPANL(-6:6),VXPANH(-6:6),VXPDGM(-6:6)
C...Input:  ISET = 1 : SaS set 1D ('DIS',   Q0 = 0.6 GeV)
C                = 2 : SaS set 1M ('MSbar', Q0 = 0.6 GeV)
C                = 3 : SaS set 2D ('DIS',   Q0 =  2  GeV)
C                = 4 : SaS set 2M ('MSbar', Q0 =  2  GeV)
C           X : x value.
C           Q2 : Q2 value.
C           P2 : P2 value; should be = 0. for an on-shell photon.
C           IP2 : scheme used to evaluate off-shell anomalous component.
C               = 0 : recommended default, see = 7.
C               = 1 : dipole dampening by integration; very time-consuming.
C               = 2 : P_0^2 = max( Q_0^2, P^2 )
C               = 3 : P_0^2 = Q_0^2 + P^2.
C               = 4 : P_{eff} that preserves momentum sum.
C               = 5 : P_{int} that preserves momentum and average
C                     evolution range.
C               = 6 : P_{eff}, matched to P_0 in P2 -> Q2 limit.
C               = 7 : P_{eff}, matched to P_0 in P2 -> Q2 limit.
C...Output: F2GM : F2 value of the photon (including factors of alpha_em).
C           XPFDGM :  x times parton distribution functions of the photon,
C               with elements 0 = g, 1 = d, 2 = u, 3 = s, 4 = c, 5 = b,
C               6 = t (always empty!), - for antiquarks (result is same).
C...The breakdown by component is stored in the commonblock SASCOM,
C               with elements as above.
C           XPVMD : rho, omega, phi VMD part only of output.
C           XPANL : d, u, s anomalous part only of output.
C           XPANH : c, b anomalous part only of output.
C           XPBEH : c, b Bethe-Heitler part only of output.
C           XPDIR : Cgamma (direct contribution) part only of output.
C...The above arrays do not distinguish valence and sea contributions,
C...although this information is available internally. The additional
C...commonblock SASVAL provides the valence part only of the above
C...distributions. Array names VXPVMD, VXPANL and VXPANH correspond
C...to XPVMD, XPANL and XPANH, while XPBEH and XPDIR are valence only
C...and therefore not given doubly. VXPDGM gives the sum of valence
C...parts, and so matches XPDFGM. The difference, i.e. XPVMD-VXPVMD
C...and so on, gives the sea part only.
C***********************************************************************

      SUBROUTINE PHO_SASGAM(ISET,X,Q2,P2,IP2,F2GM,XPDFGM)
C...Purpose: to construct the F2 and parton distributions of the photon
C...by summing homogeneous (VMD) and inhomogeneous (anomalous) terms.
C...For F2, c and b are included by the Bethe-Heitler formula;
C...in the 'MSbar' scheme additionally a Cgamma term is added.
      SAVE
      DIMENSION XPDFGM(-6:6)
      COMMON/SASCOM/XPVMD(-6:6),XPANL(-6:6),XPANH(-6:6),XPBEH(-6:6),
     &XPDIR(-6:6)
      COMMON/SASVAL/VXPVMD(-6:6),VXPANL(-6:6),VXPANH(-6:6),VXPDGM(-6:6)
      SAVE /SASCOM/,/SASVAL/

C...Temporary array.
      DIMENSION XPGA(-6:6), VXPGA(-6:6)
C...Charm and bottom masses (low to compensate for J/psi etc.).
      DATA PMC/1.3/, PMB/4.6/
C...alpha_em and alpha_em/(2*pi).
      DATA AEM/0.007297/, AEM2PI/0.0011614/
C...Lambda value for 4 flavours.
      DATA ALAM/0.20/
C...Mixture u/(u+d), = 0.5 for incoherent and = 0.8 for coherent sum.
      DATA FRACU/0.8/
C...VMD couplings f_V**2/(4*pi).
      DATA FRHO/2.20/, FOMEGA/23.6/, FPHI/18.4/
C...Masses for rho (=omega) and phi.
      DATA PMRHO/0.770/, PMPHI/1.020/
C...Number of points in integration for IP2=1.
      DATA NSTEP/100/

C...Reset output.
      F2GM=0.
      DO 100 KFL=-6,6
      XPDFGM(KFL)=0.
      XPVMD(KFL)=0.
      XPANL(KFL)=0.
      XPANH(KFL)=0.
      XPBEH(KFL)=0.
      XPDIR(KFL)=0.
      VXPVMD(KFL)=0.
      VXPANL(KFL)=0.
      VXPANH(KFL)=0.
      VXPDGM(KFL)=0.
  100 CONTINUE

C...Check that input sensible.
      IF(ISET.LE.0.OR.ISET.GE.5) THEN
        WRITE(*,*) ' FATAL ERROR: SaSgam called for unknown set'
        WRITE(*,*) ' ISET = ',ISET
        STOP
      ENDIF
      IF(X.LE.0..OR.X.GT.1.) THEN
        WRITE(*,*) ' FATAL ERROR: SaSgam called for unphysical x'
        WRITE(*,*) ' X = ',X
        STOP
      ENDIF

C...Set Q0 cut-off parameter as function of set used.
      IF(ISET.LE.2) THEN
        Q0=0.6
      ELSE
        Q0=2.
      ENDIF
      Q02=Q0**2

C...Scale choice for off-shell photon; common factors.
      Q2A=Q2
      FACNOR=1.
      IF(IP2.EQ.1) THEN
        P2MX=P2+Q02
        Q2A=Q2+P2*Q02/MAX(Q02,Q2)
        FACNOR=LOG(Q2/Q02)/NSTEP
      ELSEIF(IP2.EQ.2) THEN
        P2MX=MAX(P2,Q02)
      ELSEIF(IP2.EQ.3) THEN
        P2MX=P2+Q02
        Q2A=Q2+P2*Q02/MAX(Q02,Q2)
      ELSEIF(IP2.EQ.4) THEN
        P2MX=Q2*(Q02+P2)/(Q2+P2)*EXP(P2*(Q2-Q02)/
     &  ((Q2+P2)*(Q02+P2)))
      ELSEIF(IP2.EQ.5) THEN
        P2MXA=Q2*(Q02+P2)/(Q2+P2)*EXP(P2*(Q2-Q02)/
     &  ((Q2+P2)*(Q02+P2)))
        P2MX=Q0*SQRT(P2MXA)
        FACNOR=LOG(Q2/P2MXA)/LOG(Q2/P2MX)
      ELSEIF(IP2.EQ.6) THEN
        P2MX=Q2*(Q02+P2)/(Q2+P2)*EXP(P2*(Q2-Q02)/
     &  ((Q2+P2)*(Q02+P2)))
        P2MX=MAX(0.,1.-P2/Q2)*P2MX+MIN(1.,P2/Q2)*MAX(P2,Q02)
      ELSE
        P2MXA=Q2*(Q02+P2)/(Q2+P2)*EXP(P2*(Q2-Q02)/
     &  ((Q2+P2)*(Q02+P2)))
        P2MX=Q0*SQRT(P2MXA)
        P2MXB=P2MX
        P2MX=MAX(0.,1.-P2/Q2)*P2MX+MIN(1.,P2/Q2)*MAX(P2,Q02)
        P2MXB=MAX(0.,1.-P2/Q2)*P2MXB+MIN(1.,P2/Q2)*P2MXA
        FACNOR=LOG(Q2/P2MXA)/LOG(Q2/P2MXB)
      ENDIF

C...Call VMD parametrization for d quark and use to give rho, omega,
C...phi. Note dipole dampening for off-shell photon.
      CALL PHO_SASVMD(ISET,1,X,Q2A,P2MX,ALAM,XPGA,VXPGA)
      XFVAL=VXPGA(1)
      XPGA(1)=XPGA(2)
      XPGA(-1)=XPGA(-2)
      FACUD=AEM*(1./FRHO+1./FOMEGA)*(PMRHO**2/(PMRHO**2+P2))**2
      FACS=AEM*(1./FPHI)*(PMPHI**2/(PMPHI**2+P2))**2
      DO 110 KFL=-5,5
      XPVMD(KFL)=(FACUD+FACS)*XPGA(KFL)
  110 CONTINUE
      XPVMD(1)=XPVMD(1)+(1.-FRACU)*FACUD*XFVAL
      XPVMD(2)=XPVMD(2)+FRACU*FACUD*XFVAL
      XPVMD(3)=XPVMD(3)+FACS*XFVAL
      XPVMD(-1)=XPVMD(-1)+(1.-FRACU)*FACUD*XFVAL
      XPVMD(-2)=XPVMD(-2)+FRACU*FACUD*XFVAL
      XPVMD(-3)=XPVMD(-3)+FACS*XFVAL
      VXPVMD(1)=(1.-FRACU)*FACUD*XFVAL
      VXPVMD(2)=FRACU*FACUD*XFVAL
      VXPVMD(3)=FACS*XFVAL
      VXPVMD(-1)=(1.-FRACU)*FACUD*XFVAL
      VXPVMD(-2)=FRACU*FACUD*XFVAL
      VXPVMD(-3)=FACS*XFVAL

      IF(IP2.NE.1) THEN
C...Anomalous parametrizations for different strategies
C...for off-shell photons; except full integration.

C...Call anomalous parametrization for d + u + s.
        CALL PHO_SASANO(-3,X,Q2A,P2MX,ALAM,XPGA,VXPGA)
        DO 120 KFL=-5,5
        XPANL(KFL)=FACNOR*XPGA(KFL)
        VXPANL(KFL)=FACNOR*VXPGA(KFL)
  120   CONTINUE

C...Call anomalous parametrization for c and b.
        CALL PHO_SASANO(4,X,Q2A,P2MX,ALAM,XPGA,VXPGA)
        DO 130 KFL=-5,5
        XPANH(KFL)=FACNOR*XPGA(KFL)
        VXPANH(KFL)=FACNOR*VXPGA(KFL)
  130   CONTINUE
        CALL PHO_SASANO(5,X,Q2A,P2MX,ALAM,XPGA,VXPGA)
        DO 140 KFL=-5,5
        XPANH(KFL)=XPANH(KFL)+FACNOR*XPGA(KFL)
        VXPANH(KFL)=VXPANH(KFL)+FACNOR*VXPGA(KFL)
  140   CONTINUE

      ELSE
C...Special option: loop over flavours and integrate over k2.
        DO 170 KF=1,5
        DO 160 ISTEP=1,NSTEP
        Q2STEP=Q02*(Q2/Q02)**((ISTEP-0.5)/NSTEP)
        IF((KF.EQ.4.AND.Q2STEP.LT.PMC**2).OR.
     &  (KF.EQ.5.AND.Q2STEP.LT.PMB**2)) GOTO 160
        CALL PHO_SASVMD(0,KF,X,Q2,Q2STEP,ALAM,XPGA,VXPGA)
        FACQ=AEM2PI*(Q2STEP/(Q2STEP+P2))**2*FACNOR
        IF(MOD(KF,2).EQ.0) FACQ=FACQ*(8./9.)
        IF(MOD(KF,2).EQ.1) FACQ=FACQ*(2./9.)
        DO 150 KFL=-5,5
        IF(KF.LE.3) XPANL(KFL)=XPANL(KFL)+FACQ*XPGA(KFL)
        IF(KF.GE.4) XPANH(KFL)=XPANH(KFL)+FACQ*XPGA(KFL)
        IF(KF.LE.3) VXPANL(KFL)=VXPANL(KFL)+FACQ*VXPGA(KFL)
        IF(KF.GE.4) VXPANH(KFL)=VXPANH(KFL)+FACQ*VXPGA(KFL)
  150   CONTINUE
  160   CONTINUE
  170   CONTINUE
      ENDIF

C...Call Bethe-Heitler term expression for charm and bottom.
      CALL PHO_SASBEH(4,X,Q2,P2,PMC**2,XPBH)
      XPBEH(4)=XPBH
      XPBEH(-4)=XPBH
      CALL PHO_SASBEH(5,X,Q2,P2,PMB**2,XPBH)
      XPBEH(5)=XPBH
      XPBEH(-5)=XPBH

C...For MSbar subtraction call C^gamma term expression for d, u, s.
      IF(ISET.EQ.2.OR.ISET.EQ.4) THEN
        CALL PHO_SASDIR(X,Q2,P2,Q02,XPGA)
        DO 180 KFL=-5,5
        XPDIR(KFL)=XPGA(KFL)
  180   CONTINUE
      ENDIF

C...Store result in output array.
      DO 190 KFL=-5,5
      CHSQ=1./9.
      IF(IABS(KFL).EQ.2.OR.IABS(KFL).EQ.4) CHSQ=4./9.
      XPF2=XPVMD(KFL)+XPANL(KFL)+XPBEH(KFL)+XPDIR(KFL)
      IF(KFL.NE.0) F2GM=F2GM+CHSQ*XPF2
      XPDFGM(KFL)=XPVMD(KFL)+XPANL(KFL)+XPANH(KFL)
      VXPDGM(KFL)=VXPVMD(KFL)+VXPANL(KFL)+VXPANH(KFL)
  190 CONTINUE

      RETURN
      END

C*********************************************************************

CDECK  ID>, PHO_SASVMD
      SUBROUTINE PHO_SASVMD(ISET,KF,X,Q2,P2,ALAM,XPGA,VXPGA)
C...Purpose: to evaluate the VMD parton distributions of a photon,
C...evolved homogeneously from an initial scale P2 to Q2.
C...Does not include dipole suppression factor.
C...ISET is parton distribution set, see above;
C...additionally ISET=0 is used for the evolution of an anomalous photon
C...which branched at a scale P2 and then evolved homogeneously to Q2.
C...ALAM is the 4-flavour Lambda, which is automatically converted
C...to 3- and 5-flavour equivalents as needed.
      SAVE
      DIMENSION XPGA(-6:6), VXPGA(-6:6)
      DATA PMC/1.3/, PMB/4.6/, AEM/0.007297/, AEM2PI/0.0011614/

C...Reset output.
      DO 100 KFL=-6,6
      XPGA(KFL)=0.
      VXPGA(KFL)=0.
  100 CONTINUE
      KFA=IABS(KF)

C...Calculate Lambda; protect against unphysical Q2 and P2 input.
      ALAM3=ALAM*(PMC/ALAM)**(2./27.)
      ALAM5=ALAM*(ALAM/PMB)**(2./23.)
      P2EFF=MAX(P2,1.2*ALAM3**2)
      IF(KFA.EQ.4) P2EFF=MAX(P2EFF,PMC**2)
      IF(KFA.EQ.5) P2EFF=MAX(P2EFF,PMB**2)
      Q2EFF=MAX(Q2,P2EFF)

C...Find number of flavours at lower and upper scale.
      NFP=4
      IF(P2EFF.LT.PMC**2) NFP=3
      IF(P2EFF.GT.PMB**2) NFP=5
      NFQ=4
      IF(Q2EFF.LT.PMC**2) NFQ=3
      IF(Q2EFF.GT.PMB**2) NFQ=5

C...Find s as sum of 3-, 4- and 5-flavour parts.
      S=0.
      IF(NFP.EQ.3) THEN
        Q2DIV=PMC**2
        IF(NFQ.EQ.3) Q2DIV=Q2EFF
        S=S+(6./27.)*LOG(LOG(Q2DIV/ALAM3**2)/LOG(P2EFF/ALAM3**2))
      ENDIF
      IF(NFP.LE.4.AND.NFQ.GE.4) THEN
        P2DIV=P2EFF
        IF(NFP.EQ.3) P2DIV=PMC**2
        Q2DIV=Q2EFF
        IF(NFQ.EQ.5) Q2DIV=PMB**2
        S=S+(6./25.)*LOG(LOG(Q2DIV/ALAM**2)/LOG(P2DIV/ALAM**2))
      ENDIF
      IF(NFQ.EQ.5) THEN
        P2DIV=PMB**2
        IF(NFP.EQ.5) P2DIV=P2EFF
        S=S+(6./23.)*LOG(LOG(Q2EFF/ALAM5**2)/LOG(P2DIV/ALAM5**2))
      ENDIF

C...Calculate frequent combinations of x and s.
      X1=1.-X
      XL=-LOG(X)
      S2=S**2
      S3=S**3
      S4=S**4

C...Evaluate homogeneous anomalous parton distributions below or
C...above threshold.
      IF(ISET.EQ.0) THEN
      IF(Q2.LE.P2.OR.(KFA.EQ.4.AND.Q2.LT.PMC**2).OR.
     &(KFA.EQ.5.AND.Q2.LT.PMB**2)) THEN
        XVAL = X * 1.5 * (X**2+X1**2)
        XGLU = 0.
        XSEA = 0.
      ELSE
        XVAL = (1.5/(1.-0.197*S+4.33*S2)*X**2 + (1.5+2.10*S)/
     &  (1.+3.29*S)*X1**2 + 5.23*S/(1.+1.17*S+19.9*S3)*X*X1) *
     &  X**(1./(1.+1.5*S)) * (1.-X**2)**(2.667*S)
        XGLU = 4.*S/(1.+4.76*S+15.2*S2+29.3*S4) *
     &  X**(-2.03*S/(1.+2.44*S)) * (X1*XL)**(1.333*S) *
     &  ((4.*X**2+7.*X+4.)*X1/3. - 2.*X*(1.+X)*XL)
        XSEA = S2/(1.+4.54*S+8.19*S2+8.05*S3) *
     &  X**(-1.54*S/(1.+1.29*S)) * X1**(2.667*S) *
     &  ((8.-73.*X+62.*X**2)*X1/9. + (3.-8.*X**2/3.)*X*XL +
     &  (2.*X-1.)*X*XL**2)
      ENDIF

C...Evaluate set 1D parton distributions below or above threshold.
      ELSEIF(ISET.EQ.1) THEN
      IF(Q2.LE.P2.OR.(KFA.EQ.4.AND.Q2.LT.PMC**2).OR.
     &(KFA.EQ.5.AND.Q2.LT.PMB**2)) THEN
        XVAL = 1.294 * X**0.80 * X1**0.76
        XGLU = 1.273 * X**0.40 * X1**1.76
        XSEA = 0.100 * X1**3.76
      ELSE
        XVAL = 1.294/(1.+0.252*S+3.079*S2) * X**(0.80-0.13*S) *
     &  X1**(0.76+0.667*S) * XL**(2.*S)
        XGLU = 7.90*S/(1.+5.50*S) * EXP(-5.16*S) *
     &  X**(-1.90*S/(1.+3.60*S)) * X1**1.30 * XL**(0.50+3.*S) +
     &  1.273 * EXP(-10.*S) * X**0.40 * X1**(1.76+3.*S)
        XSEA = (0.1-0.397*S2+1.121*S3)/(1.+5.61*S2+5.26*S3) *
     &  X**(-7.32*S2/(1.+10.3*S2)) *
     &  X1**((3.76+15.*S+12.*S2)/(1.+4.*S))
        XSEA0 = 0.100 * X1**3.76
      ENDIF

C...Evaluate set 1M parton distributions below or above threshold.
      ELSEIF(ISET.EQ.2) THEN
      IF(Q2.LE.P2.OR.(KFA.EQ.4.AND.Q2.LT.PMC**2).OR.
     &(KFA.EQ.5.AND.Q2.LT.PMB**2)) THEN
        XVAL = 0.8477 * X**0.51 * X1**1.37
        XGLU = 3.42 * X**0.255 * X1**2.37
        XSEA = 0.
      ELSE
        XVAL = 0.8477/(1.+1.37*S+2.18*S2+3.73*S3) * X**(0.51+0.21*S)
     &  * X1**1.37 * XL**(2.667*S)
        XGLU = 24.*S/(1.+9.6*S+0.92*S2+14.34*S3) * EXP(-5.94*S) *
     &  X**((-0.013-1.80*S)/(1.+3.14*S)) * X1**(2.37+0.4*S) *
     &  XL**(0.32+3.6*S) + 3.42 * EXP(-12.*S) * X**0.255 *
     &  X1**(2.37+3.*S)
        XSEA = 0.842*S/(1.+21.3*S-33.2*S2+229.*S3) *
     &  X**((0.13-2.90*S)/(1.+5.44*S)) * X1**(3.45+0.5*S) *
     &  XL**(2.8*S)
        XSEA0 = 0.
      ENDIF

C...Evaluate set 2D parton distributions below or above threshold.
      ELSEIF(ISET.EQ.3) THEN
      IF(Q2.LE.P2.OR.(KFA.EQ.4.AND.Q2.LT.PMC**2).OR.
     &(KFA.EQ.5.AND.Q2.LT.PMB**2)) THEN
        XVAL = X**0.46 * X1**0.64 + 0.76 * X
        XGLU = 1.925 * X1**2
        XSEA = 0.242 * X1**4
      ELSE
        XVAL = (1.+0.186*S)/(1.-0.209*S+1.495*S2) * X**(0.46+0.25*S)
     &  * X1**((0.64+0.14*S+5.*S2)/(1.+S)) * XL**(1.9*S) +
     &  (0.76+0.4*S) * X * X1**(2.667*S)
        XGLU = (1.925+5.55*S+147.*S2)/(1.-3.59*S+3.32*S2) *
     &  EXP(-18.67*S) * X**((-5.81*S-5.34*S2)/(1.+29.*S-4.26*S2))
     &  * X1**((2.-5.9*S)/(1.+1.7*S)) * XL**(9.3*S/(1.+1.7*S))
        XSEA = (0.242-0.252*S+1.19*S2)/(1.-0.607*S+21.95*S2) *
     &  X**(-12.1*S2/(1.+2.62*S+16.7*S2)) * X1**4 * XL**S
        XSEA0 = 0.242 * X1**4
      ENDIF

C...Evaluate set 2M parton distributions below or above threshold.
      ELSEIF(ISET.EQ.4) THEN
      IF(Q2.LE.P2.OR.(KFA.EQ.4.AND.Q2.LT.PMC**2).OR.
     &(KFA.EQ.5.AND.Q2.LT.PMB**2)) THEN
        XVAL = 1.168 * X**0.50 * X1**2.60 + 0.965 * X
        XGLU = 1.808 * X1**2
        XSEA = 0.209 * X1**4
      ELSE
        XVAL = (1.168+1.771*S+29.35*S2) * EXP(-5.776*S) *
     &  X**((0.5+0.208*S)/(1.-0.794*S+1.516*S2)) *
     &  X1**((2.6+7.6*S)/(1.+5.*S)) * XL**(5.15*S/(1.+2.*S)) +
     &  (0.965+22.35*S)/(1.+18.4*S) * X * X1**(2.667*S)
        XGLU = (1.808+29.9*S)/(1.+26.4*S) * EXP(-5.28*S) *
     &  X**((-5.35*S-10.11*S2)/(1.+31.71*S)) *
     &  X1**((2.-7.3*S+4.*S2)/(1.+2.5*S)) *
     &  XL**(10.9*S/(1.+2.5*S))
        XSEA = (0.209+0.644*S2)/(1.+0.319*S+17.6*S2) *
     &  X**((-0.373*S-7.71*S2)/(1.+0.815*S+11.0*S2)) *
     &  X1**(4.+S) * XL**(0.45*S)
        XSEA0 = 0.209 * X1**4
      ENDIF
      ENDIF

C...Threshold factors for c and b sea.
      SLL=LOG(LOG(Q2EFF/ALAM**2)/LOG(P2EFF/ALAM**2))
      XCHM=0.
      IF(Q2.GT.PMC**2.AND.Q2.GT.1.001*P2EFF) THEN
        SCH=MAX(0.,LOG(LOG(PMC**2/ALAM**2)/LOG(P2EFF/ALAM**2)))
        IF(ISET.EQ.0) THEN
          XCHM=XSEA*(1.-(SCH/SLL)**2)
        ELSE
          XCHM=MAX(0.,XSEA-XSEA0*X1**(2.667*S))*(1.-SCH/SLL)
        ENDIF
      ENDIF
      XBOT=0.
      IF(Q2.GT.PMB**2.AND.Q2.GT.1.001*P2EFF) THEN
        SBT=MAX(0.,LOG(LOG(PMB**2/ALAM**2)/LOG(P2EFF/ALAM**2)))
        IF(ISET.EQ.0) THEN
          XBOT=XSEA*(1.-(SBT/SLL)**2)
        ELSE
          XBOT=MAX(0.,XSEA-XSEA0*X1**(2.667*S))*(1.-SBT/SLL)
        ENDIF
      ENDIF

C...Fill parton distributions.
      XPGA(0)=XGLU
      XPGA(1)=XSEA
      XPGA(2)=XSEA
      XPGA(3)=XSEA
      XPGA(4)=XCHM
      XPGA(5)=XBOT
      XPGA(KFA)=XPGA(KFA)+XVAL
      DO 110 KFL=1,5
      XPGA(-KFL)=XPGA(KFL)
  110 CONTINUE
      VXPGA(KFA)=XVAL
      VXPGA(-KFA)=XVAL

      RETURN
      END

C*********************************************************************

CDECK  ID>, PHO_SASANO
      SUBROUTINE PHO_SASANO(KF,X,Q2,P2,ALAM,XPGA,VXPGA)
C...Purpose: to evaluate the parton distributions of the anomalous
C...photon, inhomogeneously evolved from a scale P2 (where it vanishes)
C...to Q2.
C...KF=0 gives the sum over (up to) 5 flavours,
C...KF<0 limits to flavours up to abs(KF),
C...KF>0 is for flavour KF only.
C...ALAM is the 4-flavour Lambda, which is automatically converted
C...to 3- and 5-flavour equivalents as needed.
      SAVE
      DIMENSION XPGA(-6:6), VXPGA(-6:6), ALAMSQ(3:5)
      DATA PMC/1.3/, PMB/4.6/, AEM/0.007297/, AEM2PI/0.0011614/

C...Reset output.
      DO 100 KFL=-6,6
      XPGA(KFL)=0.
      VXPGA(KFL)=0.
  100 CONTINUE
      IF(Q2.LE.P2) RETURN
      KFA=IABS(KF)

C...Calculate Lambda; protect against unphysical Q2 and P2 input.
      ALAMSQ(3)=(ALAM*(PMC/ALAM)**(2./27.))**2
      ALAMSQ(4)=ALAM**2
      ALAMSQ(5)=(ALAM*(ALAM/PMB)**(2./23.))**2
      P2EFF=MAX(P2,1.2*ALAMSQ(3))
      IF(KF.EQ.4) P2EFF=MAX(P2EFF,PMC**2)
      IF(KF.EQ.5) P2EFF=MAX(P2EFF,PMB**2)
      Q2EFF=MAX(Q2,P2EFF)
      XL=-LOG(X)

C...Find number of flavours at lower and upper scale.
      NFP=4
      IF(P2EFF.LT.PMC**2) NFP=3
      IF(P2EFF.GT.PMB**2) NFP=5
      NFQ=4
      IF(Q2EFF.LT.PMC**2) NFQ=3
      IF(Q2EFF.GT.PMB**2) NFQ=5

C...Define range of flavour loop.
      IF(KF.EQ.0) THEN
        KFLMN=1
        KFLMX=5
      ELSEIF(KF.LT.0) THEN
        KFLMN=1
        KFLMX=KFA
      ELSE
        KFLMN=KFA
        KFLMX=KFA
      ENDIF

C...Loop over flavours the photon can branch into.
      DO 110 KFL=KFLMN,KFLMX

C...Light flavours: calculate t range and (approximate) s range.
      IF(KFL.LE.3.AND.(KFL.EQ.1.OR.KFL.EQ.KF)) THEN
        TDIFF=LOG(Q2EFF/P2EFF)
        S=(6./(33.-2.*NFQ))*LOG(LOG(Q2EFF/ALAMSQ(NFQ))/
     &  LOG(P2EFF/ALAMSQ(NFQ)))
        IF(NFQ.GT.NFP) THEN
          Q2DIV=PMB**2
          IF(NFQ.EQ.4) Q2DIV=PMC**2
          SNFQ=(6./(33.-2.*NFQ))*LOG(LOG(Q2DIV/ALAMSQ(NFQ))/
     &    LOG(P2EFF/ALAMSQ(NFQ)))
          SNFP=(6./(33.-2.*(NFQ-1)))*LOG(LOG(Q2DIV/ALAMSQ(NFQ-1))/
     &    LOG(P2EFF/ALAMSQ(NFQ-1)))
          S=S+(LOG(Q2DIV/P2EFF)/LOG(Q2EFF/P2EFF))*(SNFP-SNFQ)
        ENDIF
        IF(NFQ.EQ.5.AND.NFP.EQ.3) THEN
          Q2DIV=PMC**2
          SNF4=(6./(33.-2.*4))*LOG(LOG(Q2DIV/ALAMSQ(4))/
     &    LOG(P2EFF/ALAMSQ(4)))
          SNF3=(6./(33.-2.*3))*LOG(LOG(Q2DIV/ALAMSQ(3))/
     &    LOG(P2EFF/ALAMSQ(3)))
          S=S+(LOG(Q2DIV/P2EFF)/LOG(Q2EFF/P2EFF))*(SNF3-SNF4)
        ENDIF

C...u and s quark do not need a separate treatment when d has been done.
      ELSEIF(KFL.EQ.2.OR.KFL.EQ.3) THEN

C...Charm: as above, but only include range above c threshold.
      ELSEIF(KFL.EQ.4) THEN
        IF(Q2.LE.PMC**2) GOTO 110
        P2EFF=MAX(P2EFF,PMC**2)
        Q2EFF=MAX(Q2EFF,P2EFF)
        TDIFF=LOG(Q2EFF/P2EFF)
        S=(6./(33.-2.*NFQ))*LOG(LOG(Q2EFF/ALAMSQ(NFQ))/
     &  LOG(P2EFF/ALAMSQ(NFQ)))
        IF(NFQ.EQ.5.AND.NFP.EQ.4) THEN
          Q2DIV=PMB**2
          SNFQ=(6./(33.-2.*NFQ))*LOG(LOG(Q2DIV/ALAMSQ(NFQ))/
     &    LOG(P2EFF/ALAMSQ(NFQ)))
          SNFP=(6./(33.-2.*(NFQ-1)))*LOG(LOG(Q2DIV/ALAMSQ(NFQ-1))/
     &    LOG(P2EFF/ALAMSQ(NFQ-1)))
          S=S+(LOG(Q2DIV/P2EFF)/LOG(Q2EFF/P2EFF))*(SNFP-SNFQ)
        ENDIF

C...Bottom: as above, but only include range above b threshold.
      ELSEIF(KFL.EQ.5) THEN
        IF(Q2.LE.PMB**2) GOTO 110
        P2EFF=MAX(P2EFF,PMB**2)
        Q2EFF=MAX(Q2,P2EFF)
        TDIFF=LOG(Q2EFF/P2EFF)
        S=(6./(33.-2.*NFQ))*LOG(LOG(Q2EFF/ALAMSQ(NFQ))/
     &  LOG(P2EFF/ALAMSQ(NFQ)))
      ENDIF

C...Evaluate flavour-dependent prefactor (charge^2 etc.).
      CHSQ=1./9.
      IF(KFL.EQ.2.OR.KFL.EQ.4) CHSQ=4./9.
      FAC=AEM2PI*2.*CHSQ*TDIFF

C...Evaluate parton distributions (normalized to unit momentum sum).
      IF(KFL.EQ.1.OR.KFL.EQ.4.OR.KFL.EQ.5.OR.KFL.EQ.KF) THEN
        XVAL= ((1.5+2.49*S+26.9*S**2)/(1.+32.3*S**2)*X**2 +
     &  (1.5-0.49*S+7.83*S**2)/(1.+7.68*S**2)*(1.-X)**2 +
     &  1.5*S/(1.-3.2*S+7.*S**2)*X*(1.-X)) *
     &  X**(1./(1.+0.58*S)) * (1.-X**2)**(2.5*S/(1.+10.*S))
        XGLU= 2.*S/(1.+4.*S+7.*S**2) *
     &  X**(-1.67*S/(1.+2.*S)) * (1.-X**2)**(1.2*S) *
     &  ((4.*X**2+7.*X+4.)*(1.-X)/3. - 2.*X*(1.+X)*XL)
        XSEA= 0.333*S**2/(1.+4.90*S+4.69*S**2+21.4*S**3) *
     &  X**(-1.18*S/(1.+1.22*S)) * (1.-X)**(1.2*S) *
     &  ((8.-73.*X+62.*X**2)*(1.-X)/9. + (3.-8.*X**2/3.)*X*XL +
     &  (2.*X-1.)*X*XL**2)

C...Threshold factors for c and b sea.
        SLL=LOG(LOG(Q2EFF/ALAM**2)/LOG(P2EFF/ALAM**2))
        XCHM=0.
        IF(Q2.GT.PMC**2.AND.Q2.GT.1.001*P2EFF) THEN
          SCH=MAX(0.,LOG(LOG(PMC**2/ALAM**2)/LOG(P2EFF/ALAM**2)))
          XCHM=XSEA*(1.-(SCH/SLL)**3)
        ENDIF
        XBOT=0.
        IF(Q2.GT.PMB**2.AND.Q2.GT.1.001*P2EFF) THEN
          SBT=MAX(0.,LOG(LOG(PMB**2/ALAM**2)/LOG(P2EFF/ALAM**2)))
          XBOT=XSEA*(1.-(SBT/SLL)**3)
        ENDIF
      ENDIF

C...Add contribution of each valence flavour.
      XPGA(0)=XPGA(0)+FAC*XGLU
      XPGA(1)=XPGA(1)+FAC*XSEA
      XPGA(2)=XPGA(2)+FAC*XSEA
      XPGA(3)=XPGA(3)+FAC*XSEA
      XPGA(4)=XPGA(4)+FAC*XCHM
      XPGA(5)=XPGA(5)+FAC*XBOT
      XPGA(KFL)=XPGA(KFL)+FAC*XVAL
      VXPGA(KFL)=VXPGA(KFL)+FAC*XVAL
  110 CONTINUE
      DO 120 KFL=1,5
      XPGA(-KFL)=XPGA(KFL)
      VXPGA(-KFL)=VXPGA(KFL)
  120 CONTINUE

      END

C*********************************************************************

CDECK  ID>, PHO_SASBEH
      SUBROUTINE PHO_SASBEH(KF,X,Q2,P2,PM2,XPBH)
C...Purpose: to evaluate the Bethe-Heitler cross section for
C...heavy flavour production.
      SAVE
      DATA AEM2PI/0.0011614/

C...Reset output.
      XPBH=0.
      SIGBH=0.

C...Check kinematics limits.
      IF(X.GE.Q2/(4.*PM2+Q2+P2)) RETURN
      W2=Q2*(1.-X)/X-P2
      BETA2=1.-4.*PM2/W2
      IF(BETA2.LT.1E-10) RETURN
      BETA=SQRT(BETA2)
      RMQ=4.*PM2/Q2

C...Simple case: P2 = 0.
      IF(P2.LT.1E-4) THEN
        IF(BETA.LT.0.99) THEN
          XBL=LOG((1.+BETA)/(1.-BETA))
        ELSE
          XBL=LOG((1.+BETA)**2*W2/(4.*PM2))
        ENDIF
        SIGBH=BETA*(8.*X*(1.-X)-1.-RMQ*X*(1.-X))+
     &  XBL*(X**2+(1.-X)**2+RMQ*X*(1.-3.*X)-0.5*RMQ**2*X**2)

C...Complicated case: P2 > 0, based on approximation of
C...C.T. Hill and G.G. Ross, Nucl. Phys. B148 (1979) 373
      ELSE
        RPQ=1.-4.*X**2*P2/Q2
        IF(RPQ.GT.1E-10) THEN
          RPBE=SQRT(RPQ*BETA2)
          IF(RPBE.LT.0.99) THEN
            XBL=LOG((1.+RPBE)/(1.-RPBE))
            XBI=2.*RPBE/(1.-RPBE**2)
          ELSE
            RPBESN=4.*PM2/W2+(4.*X**2*P2/Q2)*BETA2
            XBL=LOG((1.+RPBE)**2/RPBESN)
            XBI=2.*RPBE/RPBESN
          ENDIF
          SIGBH=BETA*(6.*X*(1.-X)-1.)+
     &    XBL*(X**2+(1.-X)**2+RMQ*X*(1.-3.*X)-0.5*RMQ**2*X**2)+
     &    XBI*(2.*X/Q2)*(PM2*X*(2.-RMQ)-P2*X)
        ENDIF
      ENDIF

C...Multiply by charge-squared etc. to get parton distribution.
      CHSQ=1./9.
      IF(IABS(KF).EQ.2.OR.IABS(KF).EQ.4) CHSQ=4./9.
      XPBH=3.*CHSQ*AEM2PI*X*SIGBH

      END

C*********************************************************************

CDECK  ID>, PHO_SASDIR
      SUBROUTINE PHO_SASDIR(X,Q2,P2,Q02,XPGA)
C...Purpose: to evaluate the direct contribution, i.e. the C^gamma term,
C...as needed in MSbar parametrizations.
      SAVE
      DIMENSION XPGA(-6:6)
      DATA PMC/1.3/, PMB/4.6/, AEM2PI/0.0011614/

C...Reset output.
      DO 100 KFL=-6,6
      XPGA(KFL)=0.
  100 CONTINUE

C...Evaluate common x-dependent expression.
      XTMP = (X**2+(1.-X)**2) * (-LOG(X)) - 1.
      CGAM = 3.*AEM2PI*X * (XTMP*(1.+P2/(P2+Q02)) + 6.*X*(1.-X))

C...d, u, s part by simple charge factor.
      XPGA(1)=(1./9.)*CGAM
      XPGA(2)=(4./9.)*CGAM
      XPGA(3)=(1./9.)*CGAM

C...Also fill for antiquarks.
      DO 110 KF=1,5
      XPGA(-KF)=XPGA(KF)
  110 CONTINUE

      END


CDECK  ID>, PHO_PHGAL
      SUBROUTINE PHO_PHGAL(X,Q2,XPDF)
C***********************************************************************
C
C     photon parton densities with built-in momentum sum rule and
C     Regge-based low-x behaviour
C
C     H. Abramowicz, E. Gurvich, A. Levy: Phys.Lett.B420:104-108,1998
C     e-Print Archive: hep-ph/9711355
C
C     code submitted by E.Gurvich, slightly modified (R.Engel, 09/1998)
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      SAVE

      PARAMETER(IX=100,IQ=7,NARG=2,NFUN=4)
      DOUBLE PRECISION
     &       XT(IX),Q2T(IQ),ARG(NARG),ENT(IX+IQ),
     &       XPV(IX,IQ,0:NFUN),XPDF(-6:6)

      DIMENSION NA(NARG)

      DATA ZEROD/0.D0/

C...100 x values; in (D-4,.77) log spaced (78 points)
C...              in (.78,.995) lineary spaced (22 points)
      DATA Q2T/4.D0,10.D0,50.D0,1.D2,1.D3,1.D4,1.D5/
      DATA XT/
     &0.1000D-03,0.1123D-03,0.1262D-03,0.1417D-03,0.1592D-03,0.1789D-03,
     &0.2009D-03,0.2257D-03,0.2535D-03,0.2848D-03,0.3199D-03,0.3593D-03,
     &0.4037D-03,0.4534D-03,0.5093D-03,0.5722D-03,0.6427D-03,0.7220D-03,
     &0.8110D-03,0.9110D-03,0.1023D-02,0.1150D-02,0.1291D-02,0.1451D-02,
     &0.1629D-02,0.1830D-02,0.2056D-02,0.2310D-02,0.2594D-02,0.2914D-02,
     &0.3274D-02,0.3677D-02,0.4131D-02,0.4640D-02,0.5212D-02,0.5855D-02,
     &0.6577D-02,0.7388D-02,0.8299D-02,0.9323D-02,0.1047D-01,0.1176D-01,
     &0.1321D-01,0.1484D-01,0.1667D-01,0.1873D-01,0.2104D-01,0.2363D-01,
     &0.2655D-01,0.2982D-01,0.3350D-01,0.3763D-01,0.4227D-01,0.4748D-01,
     &0.5334D-01,0.5992D-01,0.6731D-01,0.7560D-01,0.8493D-01,0.9540D-01,
     &0.1072D+00,0.1204D+00,0.1352D+00,0.1519D+00,0.1706D+00,0.1917D+00,
     &0.2153D+00,0.2419D+00,0.2717D+00,0.3052D+00,0.3428D+00,0.3851D+00,
     &0.4326D+00,0.4859D+00,0.5458D+00,0.6131D+00,0.6887D+00,0.7737D+00,
     &0.7837D+00,0.7937D+00,0.8037D+00,0.8137D+00,0.8237D+00,0.8337D+00,
     &0.8437D+00,0.8537D+00,0.8637D+00,0.8737D+00,0.8837D+00,0.8937D+00,
     &0.9037D+00,0.9137D+00,0.9237D+00,0.9337D+00,0.9437D+00,0.9537D+00,
     &0.9637D+00,0.9737D+00,0.9837D+00,0.9937D+00/

C...place for DATA blocks
      DATA (XPV(I,1,0),I=1,100)/
     &0.6632D-01,0.6536D-01,0.6390D-01,0.6196D-01,0.5952D-01,0.5663D-01,
     &0.5339D-01,0.5124D-01,0.5029D-01,0.4893D-01,0.4718D-01,0.4505D-01,
     &0.4259D-01,0.4038D-01,0.3966D-01,0.3860D-01,0.3721D-01,0.3551D-01,
     &0.3354D-01,0.3206D-01,0.3134D-01,0.3031D-01,0.2902D-01,0.2747D-01,
     &0.2608D-01,0.2543D-01,0.2451D-01,0.2335D-01,0.2202D-01,0.2132D-01,
     &0.2051D-01,0.1950D-01,0.1851D-01,0.1783D-01,0.1696D-01,0.1609D-01,
     &0.1539D-01,0.1454D-01,0.1386D-01,0.1310D-01,0.1242D-01,0.1169D-01,
     &0.1104D-01,0.1036D-01,0.9694D-02,0.9046D-02,0.8400D-02,0.7792D-02,
     &0.7173D-02,0.6573D-02,0.5978D-02,0.5411D-02,0.4853D-02,0.4307D-02,
     &0.3791D-02,0.3292D-02,0.2818D-02,0.2382D-02,0.1976D-02,0.1606D-02,
     &0.1275D-02,0.9866D-03,0.7403D-03,0.5351D-03,0.3713D-03,0.2450D-03,
     &0.1524D-03,0.8849D-04,0.4730D-04,0.2278D-04,0.9707D-05,0.3518D-05,
     &0.1041D-05,0.2356D-06,0.3682D-07,0.3365D-08,0.1333D-09,0.1188D-11,
     &0.6095D-12,0.3031D-12,0.1457D-12,0.6733D-13,0.2986D-13,0.1262D-13,
     &0.5060D-14,0.1912D-14,0.6734D-15,0.2199D-15,0.6498D-16,0.1729D-16,
     &0.4059D-17,0.8091D-18,0.1324D-18,0.1691D-19,0.1518D-20,0.8785D-22,
     &0.2519D-23,0.2197D-25,0.2840D-28,0.1908D-33/
      DATA (XPV(I,1,1),I=1,100)/
     &0.5848D-03,0.5838D-03,0.5793D-03,0.5713D-03,0.5597D-03,0.5447D-03,
     &0.5270D-03,0.5167D-03,0.5143D-03,0.5087D-03,0.4998D-03,0.4879D-03,
     &0.4731D-03,0.4599D-03,0.4584D-03,0.4538D-03,0.4461D-03,0.4355D-03,
     &0.4223D-03,0.4133D-03,0.4109D-03,0.4053D-03,0.3970D-03,0.3859D-03,
     &0.3763D-03,0.3739D-03,0.3686D-03,0.3605D-03,0.3504D-03,0.3473D-03,
     &0.3426D-03,0.3355D-03,0.3286D-03,0.3253D-03,0.3196D-03,0.3138D-03,
     &0.3102D-03,0.3047D-03,0.3014D-03,0.2971D-03,0.2939D-03,0.2901D-03,
     &0.2875D-03,0.2849D-03,0.2824D-03,0.2805D-03,0.2787D-03,0.2780D-03,
     &0.2772D-03,0.2771D-03,0.2773D-03,0.2784D-03,0.2799D-03,0.2820D-03,
     &0.2850D-03,0.2886D-03,0.2930D-03,0.2985D-03,0.3050D-03,0.3126D-03,
     &0.3215D-03,0.3316D-03,0.3432D-03,0.3564D-03,0.3714D-03,0.3883D-03,
     &0.4073D-03,0.4287D-03,0.4526D-03,0.4794D-03,0.5092D-03,0.5425D-03,
     &0.5796D-03,0.6207D-03,0.6664D-03,0.7171D-03,0.7733D-03,0.8356D-03,
     &0.8429D-03,0.8502D-03,0.8574D-03,0.8647D-03,0.8719D-03,0.8791D-03,
     &0.8863D-03,0.8935D-03,0.9007D-03,0.9079D-03,0.9151D-03,0.9222D-03,
     &0.9294D-03,0.9365D-03,0.9436D-03,0.9508D-03,0.9579D-03,0.9650D-03,
     &0.9720D-03,0.9791D-03,0.9862D-03,0.9932D-03/
      DATA (XPV(I,1,2),I=1,100)/
     &0.2339D-02,0.2335D-02,0.2317D-02,0.2285D-02,0.2239D-02,0.2179D-02,
     &0.2108D-02,0.2067D-02,0.2057D-02,0.2035D-02,0.1999D-02,0.1951D-02,
     &0.1892D-02,0.1840D-02,0.1833D-02,0.1815D-02,0.1784D-02,0.1742D-02,
     &0.1689D-02,0.1653D-02,0.1643D-02,0.1621D-02,0.1588D-02,0.1544D-02,
     &0.1505D-02,0.1496D-02,0.1474D-02,0.1442D-02,0.1402D-02,0.1389D-02,
     &0.1370D-02,0.1342D-02,0.1314D-02,0.1301D-02,0.1278D-02,0.1255D-02,
     &0.1241D-02,0.1219D-02,0.1205D-02,0.1188D-02,0.1176D-02,0.1160D-02,
     &0.1150D-02,0.1139D-02,0.1130D-02,0.1122D-02,0.1115D-02,0.1112D-02,
     &0.1109D-02,0.1108D-02,0.1109D-02,0.1114D-02,0.1120D-02,0.1128D-02,
     &0.1140D-02,0.1154D-02,0.1172D-02,0.1194D-02,0.1220D-02,0.1251D-02,
     &0.1286D-02,0.1326D-02,0.1373D-02,0.1426D-02,0.1485D-02,0.1553D-02,
     &0.1629D-02,0.1715D-02,0.1811D-02,0.1917D-02,0.2037D-02,0.2170D-02,
     &0.2318D-02,0.2483D-02,0.2666D-02,0.2868D-02,0.3093D-02,0.3342D-02,
     &0.3372D-02,0.3401D-02,0.3430D-02,0.3459D-02,0.3488D-02,0.3517D-02,
     &0.3545D-02,0.3574D-02,0.3603D-02,0.3632D-02,0.3660D-02,0.3689D-02,
     &0.3717D-02,0.3746D-02,0.3775D-02,0.3803D-02,0.3831D-02,0.3860D-02,
     &0.3888D-02,0.3916D-02,0.3945D-02,0.3973D-02/
      DATA (XPV(I,1,3),I=1,100)/
     &0.1755D-03,0.1751D-03,0.1738D-03,0.1714D-03,0.1679D-03,0.1634D-03,
     &0.1581D-03,0.1550D-03,0.1543D-03,0.1526D-03,0.1499D-03,0.1464D-03,
     &0.1419D-03,0.1380D-03,0.1375D-03,0.1361D-03,0.1338D-03,0.1306D-03,
     &0.1267D-03,0.1240D-03,0.1233D-03,0.1216D-03,0.1191D-03,0.1158D-03,
     &0.1129D-03,0.1122D-03,0.1106D-03,0.1082D-03,0.1051D-03,0.1042D-03,
     &0.1028D-03,0.1006D-03,0.9857D-04,0.9759D-04,0.9587D-04,0.9414D-04,
     &0.9305D-04,0.9140D-04,0.9041D-04,0.8912D-04,0.8817D-04,0.8702D-04,
     &0.8626D-04,0.8546D-04,0.8472D-04,0.8415D-04,0.8362D-04,0.8339D-04,
     &0.8317D-04,0.8312D-04,0.8318D-04,0.8352D-04,0.8398D-04,0.8459D-04,
     &0.8550D-04,0.8658D-04,0.8789D-04,0.8956D-04,0.9151D-04,0.9379D-04,
     &0.9644D-04,0.9948D-04,0.1030D-03,0.1069D-03,0.1114D-03,0.1165D-03,
     &0.1222D-03,0.1286D-03,0.1358D-03,0.1438D-03,0.1528D-03,0.1628D-03,
     &0.1739D-03,0.1862D-03,0.1999D-03,0.2151D-03,0.2320D-03,0.2507D-03,
     &0.2529D-03,0.2551D-03,0.2572D-03,0.2594D-03,0.2616D-03,0.2637D-03,
     &0.2659D-03,0.2681D-03,0.2702D-03,0.2724D-03,0.2745D-03,0.2767D-03,
     &0.2788D-03,0.2810D-03,0.2831D-03,0.2852D-03,0.2874D-03,0.2895D-03,
     &0.2916D-03,0.2937D-03,0.2959D-03,0.2980D-03/
      DATA (XPV(I,1,4),I=1,100)/
     &0.7018D-03,0.7006D-03,0.6951D-03,0.6855D-03,0.6716D-03,0.6537D-03,
     &0.6324D-03,0.6200D-03,0.6172D-03,0.6104D-03,0.5998D-03,0.5854D-03,
     &0.5677D-03,0.5519D-03,0.5500D-03,0.5445D-03,0.5353D-03,0.5226D-03,
     &0.5068D-03,0.4960D-03,0.4930D-03,0.4864D-03,0.4764D-03,0.4631D-03,
     &0.4516D-03,0.4487D-03,0.4423D-03,0.4326D-03,0.4205D-03,0.4167D-03,
     &0.4111D-03,0.4026D-03,0.3943D-03,0.3903D-03,0.3835D-03,0.3765D-03,
     &0.3722D-03,0.3656D-03,0.3616D-03,0.3565D-03,0.3527D-03,0.3481D-03,
     &0.3450D-03,0.3418D-03,0.3389D-03,0.3366D-03,0.3345D-03,0.3336D-03,
     &0.3327D-03,0.3325D-03,0.3327D-03,0.3341D-03,0.3359D-03,0.3383D-03,
     &0.3420D-03,0.3463D-03,0.3516D-03,0.3582D-03,0.3660D-03,0.3752D-03,
     &0.3858D-03,0.3979D-03,0.4118D-03,0.4277D-03,0.4456D-03,0.4660D-03,
     &0.4887D-03,0.5145D-03,0.5432D-03,0.5752D-03,0.6111D-03,0.6510D-03,
     &0.6955D-03,0.7448D-03,0.7997D-03,0.8605D-03,0.9280D-03,0.1003D-02,
     &0.1011D-02,0.1020D-02,0.1029D-02,0.1038D-02,0.1046D-02,0.1055D-02,
     &0.1064D-02,0.1072D-02,0.1081D-02,0.1089D-02,0.1098D-02,0.1107D-02,
     &0.1115D-02,0.1124D-02,0.1132D-02,0.1141D-02,0.1149D-02,0.1158D-02,
     &0.1166D-02,0.1175D-02,0.1183D-02,0.1192D-02/
      DATA (XPV(I,2,0),I=1,100)/
     &0.1024D+00,0.1007D+00,0.9821D-01,0.9497D-01,0.9093D-01,0.8617D-01,
     &0.8086D-01,0.7731D-01,0.7566D-01,0.7338D-01,0.7048D-01,0.6700D-01,
     &0.6300D-01,0.5939D-01,0.5814D-01,0.5638D-01,0.5410D-01,0.5135D-01,
     &0.4819D-01,0.4580D-01,0.4460D-01,0.4293D-01,0.4087D-01,0.3843D-01,
     &0.3624D-01,0.3517D-01,0.3372D-01,0.3192D-01,0.2988D-01,0.2879D-01,
     &0.2755D-01,0.2602D-01,0.2454D-01,0.2352D-01,0.2224D-01,0.2097D-01,
     &0.1995D-01,0.1875D-01,0.1779D-01,0.1673D-01,0.1580D-01,0.1480D-01,
     &0.1393D-01,0.1305D-01,0.1218D-01,0.1136D-01,0.1055D-01,0.9801D-02,
     &0.9052D-02,0.8337D-02,0.7641D-02,0.6989D-02,0.6357D-02,0.5747D-02,
     &0.5179D-02,0.4637D-02,0.4127D-02,0.3663D-02,0.3232D-02,0.2840D-02,
     &0.2487D-02,0.2174D-02,0.1901D-02,0.1662D-02,0.1459D-02,0.1285D-02,
     &0.1137D-02,0.1010D-02,0.9006D-03,0.8023D-03,0.7126D-03,0.6276D-03,
     &0.5458D-03,0.4661D-03,0.3876D-03,0.3101D-03,0.2334D-03,0.1570D-03,
     &0.1486D-03,0.1404D-03,0.1322D-03,0.1242D-03,0.1162D-03,0.1084D-03,
     &0.1007D-03,0.9304D-04,0.8554D-04,0.7817D-04,0.7086D-04,0.6372D-04,
     &0.5670D-04,0.4982D-04,0.4307D-04,0.3647D-04,0.3005D-04,0.2382D-04,
     &0.1781D-04,0.1208D-04,0.6720D-05,0.1928D-05/
      DATA (XPV(I,2,1),I=1,100)/
     &0.1449D-02,0.1433D-02,0.1407D-02,0.1370D-02,0.1324D-02,0.1268D-02,
     &0.1204D-02,0.1163D-02,0.1147D-02,0.1123D-02,0.1089D-02,0.1048D-02,
     &0.1000D-02,0.9567D-03,0.9446D-03,0.9250D-03,0.8981D-03,0.8642D-03,
     &0.8244D-03,0.7951D-03,0.7821D-03,0.7623D-03,0.7362D-03,0.7043D-03,
     &0.6759D-03,0.6640D-03,0.6459D-03,0.6223D-03,0.5945D-03,0.5817D-03,
     &0.5660D-03,0.5455D-03,0.5256D-03,0.5132D-03,0.4963D-03,0.4794D-03,
     &0.4669D-03,0.4510D-03,0.4394D-03,0.4261D-03,0.4151D-03,0.4031D-03,
     &0.3934D-03,0.3838D-03,0.3747D-03,0.3666D-03,0.3591D-03,0.3533D-03,
     &0.3477D-03,0.3433D-03,0.3397D-03,0.3376D-03,0.3364D-03,0.3361D-03,
     &0.3375D-03,0.3399D-03,0.3437D-03,0.3492D-03,0.3562D-03,0.3648D-03,
     &0.3751D-03,0.3871D-03,0.4009D-03,0.4167D-03,0.4344D-03,0.4543D-03,
     &0.4760D-03,0.5003D-03,0.5268D-03,0.5558D-03,0.5876D-03,0.6226D-03,
     &0.6610D-03,0.7035D-03,0.7509D-03,0.8041D-03,0.8638D-03,0.9294D-03,
     &0.9367D-03,0.9440D-03,0.9511D-03,0.9581D-03,0.9648D-03,0.9714D-03,
     &0.9776D-03,0.9836D-03,0.9891D-03,0.9942D-03,0.9987D-03,0.1003D-02,
     &0.1006D-02,0.1008D-02,0.1008D-02,0.1007D-02,0.1004D-02,0.9977D-03,
     &0.9868D-03,0.9681D-03,0.9347D-03,0.8678D-03/
      DATA (XPV(I,2,2),I=1,100)/
     &0.3175D-02,0.3156D-02,0.3117D-02,0.3057D-02,0.2976D-02,0.2876D-02,
     &0.2760D-02,0.2689D-02,0.2666D-02,0.2625D-02,0.2566D-02,0.2489D-02,
     &0.2398D-02,0.2316D-02,0.2299D-02,0.2266D-02,0.2217D-02,0.2152D-02,
     &0.2073D-02,0.2018D-02,0.1998D-02,0.1962D-02,0.1911D-02,0.1847D-02,
     &0.1791D-02,0.1773D-02,0.1739D-02,0.1692D-02,0.1636D-02,0.1614D-02,
     &0.1586D-02,0.1545D-02,0.1506D-02,0.1485D-02,0.1452D-02,0.1420D-02,
     &0.1398D-02,0.1368D-02,0.1348D-02,0.1324D-02,0.1306D-02,0.1285D-02,
     &0.1271D-02,0.1256D-02,0.1243D-02,0.1233D-02,0.1224D-02,0.1220D-02,
     &0.1217D-02,0.1217D-02,0.1220D-02,0.1227D-02,0.1237D-02,0.1249D-02,
     &0.1267D-02,0.1288D-02,0.1313D-02,0.1345D-02,0.1381D-02,0.1422D-02,
     &0.1469D-02,0.1522D-02,0.1582D-02,0.1648D-02,0.1722D-02,0.1804D-02,
     &0.1893D-02,0.1992D-02,0.2099D-02,0.2216D-02,0.2345D-02,0.2486D-02,
     &0.2641D-02,0.2812D-02,0.3002D-02,0.3216D-02,0.3455D-02,0.3718D-02,
     &0.3748D-02,0.3777D-02,0.3806D-02,0.3833D-02,0.3861D-02,0.3887D-02,
     &0.3912D-02,0.3936D-02,0.3958D-02,0.3978D-02,0.3996D-02,0.4012D-02,
     &0.4024D-02,0.4032D-02,0.4035D-02,0.4031D-02,0.4018D-02,0.3993D-02,
     &0.3949D-02,0.3875D-02,0.3741D-02,0.3474D-02/
      DATA (XPV(I,2,3),I=1,100)/
     &0.1046D-02,0.1031D-02,0.1008D-02,0.9768D-03,0.9381D-03,0.8923D-03,
     &0.8410D-03,0.8074D-03,0.7928D-03,0.7720D-03,0.7450D-03,0.7121D-03,
     &0.6741D-03,0.6398D-03,0.6287D-03,0.6123D-03,0.5906D-03,0.5640D-03,
     &0.5332D-03,0.5101D-03,0.4988D-03,0.4827D-03,0.4624D-03,0.4380D-03,
     &0.4161D-03,0.4059D-03,0.3914D-03,0.3732D-03,0.3524D-03,0.3416D-03,
     &0.3290D-03,0.3133D-03,0.2981D-03,0.2878D-03,0.2747D-03,0.2616D-03,
     &0.2515D-03,0.2392D-03,0.2296D-03,0.2191D-03,0.2100D-03,0.2004D-03,
     &0.1923D-03,0.1842D-03,0.1764D-03,0.1694D-03,0.1627D-03,0.1571D-03,
     &0.1517D-03,0.1469D-03,0.1427D-03,0.1394D-03,0.1367D-03,0.1345D-03,
     &0.1333D-03,0.1327D-03,0.1329D-03,0.1340D-03,0.1360D-03,0.1387D-03,
     &0.1424D-03,0.1469D-03,0.1522D-03,0.1584D-03,0.1654D-03,0.1733D-03,
     &0.1819D-03,0.1915D-03,0.2019D-03,0.2132D-03,0.2257D-03,0.2396D-03,
     &0.2553D-03,0.2737D-03,0.2956D-03,0.3227D-03,0.3570D-03,0.4009D-03,
     &0.4064D-03,0.4119D-03,0.4175D-03,0.4231D-03,0.4287D-03,0.4344D-03,
     &0.4400D-03,0.4457D-03,0.4512D-03,0.4567D-03,0.4621D-03,0.4673D-03,
     &0.4723D-03,0.4769D-03,0.4811D-03,0.4848D-03,0.4875D-03,0.4891D-03,
     &0.4888D-03,0.4853D-03,0.4756D-03,0.4518D-03/
      DATA (XPV(I,2,4),I=1,100)/
     &0.1564D-02,0.1548D-02,0.1521D-02,0.1483D-02,0.1434D-02,0.1375D-02,
     &0.1308D-02,0.1265D-02,0.1249D-02,0.1223D-02,0.1188D-02,0.1145D-02,
     &0.1094D-02,0.1048D-02,0.1035D-02,0.1015D-02,0.9868D-03,0.9509D-03,
     &0.9086D-03,0.8776D-03,0.8644D-03,0.8436D-03,0.8161D-03,0.7822D-03,
     &0.7521D-03,0.7400D-03,0.7212D-03,0.6963D-03,0.6669D-03,0.6538D-03,
     &0.6377D-03,0.6163D-03,0.5956D-03,0.5832D-03,0.5658D-03,0.5486D-03,
     &0.5363D-03,0.5203D-03,0.5091D-03,0.4962D-03,0.4859D-03,0.4746D-03,
     &0.4661D-03,0.4578D-03,0.4502D-03,0.4441D-03,0.4387D-03,0.4355D-03,
     &0.4329D-03,0.4318D-03,0.4320D-03,0.4342D-03,0.4379D-03,0.4429D-03,
     &0.4503D-03,0.4594D-03,0.4704D-03,0.4839D-03,0.4996D-03,0.5177D-03,
     &0.5383D-03,0.5613D-03,0.5869D-03,0.6152D-03,0.6462D-03,0.6802D-03,
     &0.7167D-03,0.7565D-03,0.7995D-03,0.8461D-03,0.8972D-03,0.9538D-03,
     &0.1018D-02,0.1092D-02,0.1181D-02,0.1290D-02,0.1428D-02,0.1604D-02,
     &0.1626D-02,0.1649D-02,0.1671D-02,0.1694D-02,0.1716D-02,0.1739D-02,
     &0.1762D-02,0.1784D-02,0.1806D-02,0.1828D-02,0.1850D-02,0.1871D-02,
     &0.1891D-02,0.1909D-02,0.1926D-02,0.1941D-02,0.1952D-02,0.1958D-02,
     &0.1957D-02,0.1943D-02,0.1905D-02,0.1811D-02/
      DATA (XPV(I,3,0),I=1,100)/
     &0.1761D+00,0.1728D+00,0.1680D+00,0.1619D+00,0.1544D+00,0.1456D+00,
     &0.1358D+00,0.1292D+00,0.1260D+00,0.1218D+00,0.1165D+00,0.1101D+00,
     &0.1029D+00,0.9643D-01,0.9409D-01,0.9087D-01,0.8680D-01,0.8192D-01,
     &0.7638D-01,0.7217D-01,0.7000D-01,0.6708D-01,0.6352D-01,0.5934D-01,
     &0.5561D-01,0.5375D-01,0.5129D-01,0.4829D-01,0.4491D-01,0.4309D-01,
     &0.4104D-01,0.3857D-01,0.3618D-01,0.3454D-01,0.3252D-01,0.3053D-01,
     &0.2896D-01,0.2712D-01,0.2565D-01,0.2407D-01,0.2268D-01,0.2123D-01,
     &0.1997D-01,0.1870D-01,0.1748D-01,0.1634D-01,0.1523D-01,0.1422D-01,
     &0.1321D-01,0.1227D-01,0.1137D-01,0.1053D-01,0.9723D-02,0.8952D-02,
     &0.8241D-02,0.7563D-02,0.6926D-02,0.6345D-02,0.5801D-02,0.5298D-02,
     &0.4833D-02,0.4407D-02,0.4017D-02,0.3657D-02,0.3327D-02,0.3021D-02,
     &0.2735D-02,0.2469D-02,0.2217D-02,0.1976D-02,0.1746D-02,0.1522D-02,
     &0.1307D-02,0.1098D-02,0.8959D-03,0.7002D-03,0.5112D-03,0.3292D-03,
     &0.3097D-03,0.2906D-03,0.2718D-03,0.2534D-03,0.2354D-03,0.2178D-03,
     &0.2005D-03,0.1836D-03,0.1672D-03,0.1511D-03,0.1354D-03,0.1203D-03,
     &0.1055D-03,0.9128D-04,0.7756D-04,0.6440D-04,0.5185D-04,0.3998D-04,
     &0.2891D-04,0.1876D-04,0.9776D-05,0.2464D-05/
      DATA (XPV(I,3,1),I=1,100)/
     &0.3351D-02,0.3297D-02,0.3217D-02,0.3112D-02,0.2981D-02,0.2828D-02,
     &0.2656D-02,0.2543D-02,0.2493D-02,0.2422D-02,0.2332D-02,0.2223D-02,
     &0.2097D-02,0.1984D-02,0.1946D-02,0.1892D-02,0.1821D-02,0.1734D-02,
     &0.1635D-02,0.1560D-02,0.1523D-02,0.1471D-02,0.1406D-02,0.1329D-02,
     &0.1260D-02,0.1228D-02,0.1182D-02,0.1126D-02,0.1061D-02,0.1028D-02,
     &0.9902D-03,0.9426D-03,0.8967D-03,0.8664D-03,0.8274D-03,0.7890D-03,
     &0.7596D-03,0.7240D-03,0.6969D-03,0.6671D-03,0.6417D-03,0.6149D-03,
     &0.5928D-03,0.5708D-03,0.5502D-03,0.5317D-03,0.5144D-03,0.5002D-03,
     &0.4867D-03,0.4753D-03,0.4655D-03,0.4582D-03,0.4526D-03,0.4487D-03,
     &0.4475D-03,0.4480D-03,0.4506D-03,0.4559D-03,0.4632D-03,0.4729D-03,
     &0.4849D-03,0.4991D-03,0.5155D-03,0.5343D-03,0.5552D-03,0.5783D-03,
     &0.6033D-03,0.6307D-03,0.6600D-03,0.6915D-03,0.7256D-03,0.7626D-03,
     &0.8031D-03,0.8482D-03,0.8993D-03,0.9582D-03,0.1026D-02,0.1099D-02,
     &0.1107D-02,0.1115D-02,0.1122D-02,0.1129D-02,0.1136D-02,0.1142D-02,
     &0.1148D-02,0.1152D-02,0.1156D-02,0.1159D-02,0.1161D-02,0.1161D-02,
     &0.1160D-02,0.1156D-02,0.1150D-02,0.1141D-02,0.1127D-02,0.1107D-02,
     &0.1078D-02,0.1036D-02,0.9685D-03,0.8413D-03/
      DATA (XPV(I,3,2),I=1,100)/
     &0.5039D-02,0.4982D-02,0.4889D-02,0.4761D-02,0.4597D-02,0.4401D-02,
     &0.4179D-02,0.4036D-02,0.3979D-02,0.3893D-02,0.3777D-02,0.3634D-02,
     &0.3466D-02,0.3315D-02,0.3273D-02,0.3206D-02,0.3114D-02,0.2997D-02,
     &0.2860D-02,0.2760D-02,0.2717D-02,0.2650D-02,0.2562D-02,0.2454D-02,
     &0.2359D-02,0.2321D-02,0.2262D-02,0.2184D-02,0.2092D-02,0.2052D-02,
     &0.2003D-02,0.1938D-02,0.1875D-02,0.1839D-02,0.1787D-02,0.1736D-02,
     &0.1700D-02,0.1653D-02,0.1622D-02,0.1585D-02,0.1557D-02,0.1526D-02,
     &0.1504D-02,0.1483D-02,0.1464D-02,0.1450D-02,0.1438D-02,0.1433D-02,
     &0.1430D-02,0.1432D-02,0.1438D-02,0.1450D-02,0.1466D-02,0.1487D-02,
     &0.1515D-02,0.1547D-02,0.1585D-02,0.1631D-02,0.1683D-02,0.1742D-02,
     &0.1808D-02,0.1880D-02,0.1960D-02,0.2048D-02,0.2142D-02,0.2245D-02,
     &0.2354D-02,0.2471D-02,0.2596D-02,0.2729D-02,0.2872D-02,0.3025D-02,
     &0.3193D-02,0.3378D-02,0.3587D-02,0.3827D-02,0.4100D-02,0.4397D-02,
     &0.4429D-02,0.4461D-02,0.4490D-02,0.4519D-02,0.4545D-02,0.4570D-02,
     &0.4592D-02,0.4611D-02,0.4627D-02,0.4639D-02,0.4646D-02,0.4647D-02,
     &0.4642D-02,0.4628D-02,0.4604D-02,0.4566D-02,0.4510D-02,0.4431D-02,
     &0.4317D-02,0.4147D-02,0.3877D-02,0.3370D-02/
      DATA (XPV(I,3,3),I=1,100)/
     &0.2958D-02,0.2904D-02,0.2827D-02,0.2727D-02,0.2604D-02,0.2461D-02,
     &0.2301D-02,0.2195D-02,0.2146D-02,0.2079D-02,0.1995D-02,0.1894D-02,
     &0.1778D-02,0.1674D-02,0.1637D-02,0.1586D-02,0.1520D-02,0.1440D-02,
     &0.1349D-02,0.1280D-02,0.1245D-02,0.1197D-02,0.1138D-02,0.1068D-02,
     &0.1005D-02,0.9742D-03,0.9325D-03,0.8812D-03,0.8233D-03,0.7922D-03,
     &0.7568D-03,0.7138D-03,0.6722D-03,0.6438D-03,0.6084D-03,0.5735D-03,
     &0.5460D-03,0.5138D-03,0.4883D-03,0.4609D-03,0.4371D-03,0.4123D-03,
     &0.3912D-03,0.3704D-03,0.3507D-03,0.3327D-03,0.3158D-03,0.3012D-03,
     &0.2873D-03,0.2751D-03,0.2641D-03,0.2551D-03,0.2474D-03,0.2410D-03,
     &0.2365D-03,0.2334D-03,0.2318D-03,0.2321D-03,0.2339D-03,0.2372D-03,
     &0.2421D-03,0.2485D-03,0.2562D-03,0.2652D-03,0.2755D-03,0.2870D-03,
     &0.2995D-03,0.3131D-03,0.3278D-03,0.3438D-03,0.3615D-03,0.3814D-03,
     &0.4046D-03,0.4328D-03,0.4682D-03,0.5142D-03,0.5747D-03,0.6529D-03,
     &0.6625D-03,0.6722D-03,0.6819D-03,0.6916D-03,0.7012D-03,0.7107D-03,
     &0.7200D-03,0.7292D-03,0.7380D-03,0.7464D-03,0.7544D-03,0.7617D-03,
     &0.7681D-03,0.7735D-03,0.7776D-03,0.7798D-03,0.7796D-03,0.7761D-03,
     &0.7676D-03,0.7510D-03,0.7195D-03,0.6522D-03/
      DATA (XPV(I,3,4),I=1,100)/
     &0.3464D-02,0.3410D-02,0.3329D-02,0.3222D-02,0.3090D-02,0.2933D-02,
     &0.2758D-02,0.2643D-02,0.2593D-02,0.2521D-02,0.2430D-02,0.2318D-02,
     &0.2190D-02,0.2075D-02,0.2037D-02,0.1982D-02,0.1910D-02,0.1821D-02,
     &0.1720D-02,0.1643D-02,0.1607D-02,0.1554D-02,0.1489D-02,0.1410D-02,
     &0.1340D-02,0.1308D-02,0.1262D-02,0.1205D-02,0.1140D-02,0.1108D-02,
     &0.1070D-02,0.1023D-02,0.9772D-03,0.9482D-03,0.9103D-03,0.8732D-03,
     &0.8458D-03,0.8121D-03,0.7877D-03,0.7607D-03,0.7388D-03,0.7157D-03,
     &0.6981D-03,0.6812D-03,0.6662D-03,0.6540D-03,0.6438D-03,0.6377D-03,
     &0.6331D-03,0.6316D-03,0.6326D-03,0.6376D-03,0.6453D-03,0.6560D-03,
     &0.6708D-03,0.6887D-03,0.7102D-03,0.7361D-03,0.7656D-03,0.7991D-03,
     &0.8365D-03,0.8777D-03,0.9226D-03,0.9714D-03,0.1024D-02,0.1080D-02,
     &0.1138D-02,0.1201D-02,0.1267D-02,0.1338D-02,0.1415D-02,0.1501D-02,
     &0.1599D-02,0.1717D-02,0.1863D-02,0.2051D-02,0.2296D-02,0.2612D-02,
     &0.2650D-02,0.2689D-02,0.2729D-02,0.2767D-02,0.2806D-02,0.2844D-02,
     &0.2882D-02,0.2919D-02,0.2954D-02,0.2988D-02,0.3020D-02,0.3049D-02,
     &0.3075D-02,0.3097D-02,0.3114D-02,0.3123D-02,0.3122D-02,0.3108D-02,
     &0.3074D-02,0.3008D-02,0.2881D-02,0.2614D-02/
      DATA (XPV(I,4,0),I=1,100)/
     &0.2113D+00,0.2071D+00,0.2012D+00,0.1936D+00,0.1844D+00,0.1736D+00,
     &0.1616D+00,0.1536D+00,0.1497D+00,0.1445D+00,0.1380D+00,0.1303D+00,
     &0.1215D+00,0.1136D+00,0.1108D+00,0.1069D+00,0.1019D+00,0.9605D-01,
     &0.8939D-01,0.8432D-01,0.8171D-01,0.7821D-01,0.7395D-01,0.6897D-01,
     &0.6452D-01,0.6231D-01,0.5938D-01,0.5583D-01,0.5185D-01,0.4969D-01,
     &0.4728D-01,0.4438D-01,0.4158D-01,0.3967D-01,0.3731D-01,0.3500D-01,
     &0.3318D-01,0.3105D-01,0.2936D-01,0.2754D-01,0.2595D-01,0.2429D-01,
     &0.2285D-01,0.2141D-01,0.2003D-01,0.1874D-01,0.1749D-01,0.1635D-01,
     &0.1523D-01,0.1418D-01,0.1317D-01,0.1223D-01,0.1134D-01,0.1048D-01,
     &0.9692D-02,0.8938D-02,0.8227D-02,0.7578D-02,0.6967D-02,0.6398D-02,
     &0.5867D-02,0.5377D-02,0.4922D-02,0.4497D-02,0.4101D-02,0.3730D-02,
     &0.3379D-02,0.3048D-02,0.2732D-02,0.2429D-02,0.2139D-02,0.1858D-02,
     &0.1588D-02,0.1328D-02,0.1077D-02,0.8361D-03,0.6052D-03,0.3850D-03,
     &0.3616D-03,0.3387D-03,0.3162D-03,0.2943D-03,0.2728D-03,0.2518D-03,
     &0.2314D-03,0.2114D-03,0.1919D-03,0.1731D-03,0.1546D-03,0.1369D-03,
     &0.1197D-03,0.1032D-03,0.8729D-04,0.7214D-04,0.5778D-04,0.4429D-04,
     &0.3179D-04,0.2044D-04,0.1053D-04,0.2601D-05/
      DATA (XPV(I,4,1),I=1,100)/
     &0.4299D-02,0.4223D-02,0.4115D-02,0.3974D-02,0.3799D-02,0.3595D-02,
     &0.3367D-02,0.3216D-02,0.3148D-02,0.3054D-02,0.2934D-02,0.2790D-02,
     &0.2625D-02,0.2476D-02,0.2426D-02,0.2353D-02,0.2260D-02,0.2147D-02,
     &0.2018D-02,0.1920D-02,0.1871D-02,0.1804D-02,0.1720D-02,0.1620D-02,
     &0.1532D-02,0.1489D-02,0.1431D-02,0.1359D-02,0.1277D-02,0.1234D-02,
     &0.1185D-02,0.1125D-02,0.1067D-02,0.1028D-02,0.9791D-03,0.9308D-03,
     &0.8936D-03,0.8491D-03,0.8150D-03,0.7777D-03,0.7459D-03,0.7125D-03,
     &0.6849D-03,0.6575D-03,0.6318D-03,0.6088D-03,0.5872D-03,0.5693D-03,
     &0.5524D-03,0.5380D-03,0.5254D-03,0.5159D-03,0.5084D-03,0.5028D-03,
     &0.5003D-03,0.4998D-03,0.5017D-03,0.5066D-03,0.5139D-03,0.5237D-03,
     &0.5360D-03,0.5508D-03,0.5679D-03,0.5875D-03,0.6093D-03,0.6334D-03,
     &0.6593D-03,0.6876D-03,0.7177D-03,0.7500D-03,0.7848D-03,0.8225D-03,
     &0.8639D-03,0.9103D-03,0.9634D-03,0.1025D-02,0.1097D-02,0.1174D-02,
     &0.1183D-02,0.1191D-02,0.1199D-02,0.1206D-02,0.1212D-02,0.1219D-02,
     &0.1224D-02,0.1229D-02,0.1232D-02,0.1235D-02,0.1236D-02,0.1235D-02,
     &0.1232D-02,0.1227D-02,0.1219D-02,0.1207D-02,0.1190D-02,0.1167D-02,
     &0.1133D-02,0.1085D-02,0.1009D-02,0.8680D-03/
      DATA (XPV(I,4,2),I=1,100)/
     &0.5972D-02,0.5895D-02,0.5773D-02,0.5610D-02,0.5402D-02,0.5156D-02,
     &0.4878D-02,0.4698D-02,0.4623D-02,0.4513D-02,0.4369D-02,0.4191D-02,
     &0.3984D-02,0.3798D-02,0.3743D-02,0.3659D-02,0.3544D-02,0.3402D-02,
     &0.3235D-02,0.3113D-02,0.3058D-02,0.2976D-02,0.2870D-02,0.2740D-02,
     &0.2626D-02,0.2578D-02,0.2507D-02,0.2414D-02,0.2305D-02,0.2257D-02,
     &0.2198D-02,0.2121D-02,0.2046D-02,0.2003D-02,0.1942D-02,0.1882D-02,
     &0.1840D-02,0.1786D-02,0.1749D-02,0.1707D-02,0.1674D-02,0.1639D-02,
     &0.1613D-02,0.1589D-02,0.1567D-02,0.1551D-02,0.1538D-02,0.1533D-02,
     &0.1530D-02,0.1533D-02,0.1540D-02,0.1554D-02,0.1573D-02,0.1597D-02,
     &0.1628D-02,0.1665D-02,0.1709D-02,0.1760D-02,0.1818D-02,0.1884D-02,
     &0.1957D-02,0.2038D-02,0.2125D-02,0.2221D-02,0.2324D-02,0.2434D-02,
     &0.2551D-02,0.2676D-02,0.2807D-02,0.2946D-02,0.3095D-02,0.3254D-02,
     &0.3428D-02,0.3621D-02,0.3839D-02,0.4092D-02,0.4382D-02,0.4698D-02,
     &0.4731D-02,0.4764D-02,0.4795D-02,0.4824D-02,0.4851D-02,0.4876D-02,
     &0.4898D-02,0.4917D-02,0.4931D-02,0.4941D-02,0.4945D-02,0.4943D-02,
     &0.4933D-02,0.4913D-02,0.4881D-02,0.4833D-02,0.4766D-02,0.4671D-02,
     &0.4538D-02,0.4344D-02,0.4039D-02,0.3475D-02/
      DATA (XPV(I,4,3),I=1,100)/
     &0.3908D-02,0.3834D-02,0.3728D-02,0.3592D-02,0.3425D-02,0.3231D-02,
     &0.3015D-02,0.2871D-02,0.2804D-02,0.2714D-02,0.2600D-02,0.2464D-02,
     &0.2309D-02,0.2169D-02,0.2119D-02,0.2050D-02,0.1962D-02,0.1855D-02,
     &0.1735D-02,0.1643D-02,0.1596D-02,0.1532D-02,0.1453D-02,0.1361D-02,
     &0.1278D-02,0.1237D-02,0.1183D-02,0.1116D-02,0.1040D-02,0.9992D-03,
     &0.9531D-03,0.8972D-03,0.8434D-03,0.8065D-03,0.7608D-03,0.7159D-03,
     &0.6806D-03,0.6392D-03,0.6067D-03,0.5717D-03,0.5414D-03,0.5098D-03,
     &0.4831D-03,0.4567D-03,0.4317D-03,0.4090D-03,0.3877D-03,0.3693D-03,
     &0.3517D-03,0.3363D-03,0.3224D-03,0.3109D-03,0.3010D-03,0.2928D-03,
     &0.2869D-03,0.2826D-03,0.2801D-03,0.2799D-03,0.2814D-03,0.2848D-03,
     &0.2899D-03,0.2967D-03,0.3051D-03,0.3151D-03,0.3263D-03,0.3390D-03,
     &0.3528D-03,0.3678D-03,0.3841D-03,0.4018D-03,0.4214D-03,0.4437D-03,
     &0.4700D-03,0.5022D-03,0.5431D-03,0.5965D-03,0.6670D-03,0.7574D-03,
     &0.7684D-03,0.7795D-03,0.7905D-03,0.8015D-03,0.8124D-03,0.8230D-03,
     &0.8335D-03,0.8436D-03,0.8533D-03,0.8624D-03,0.8708D-03,0.8784D-03,
     &0.8849D-03,0.8901D-03,0.8934D-03,0.8945D-03,0.8925D-03,0.8863D-03,
     &0.8739D-03,0.8517D-03,0.8113D-03,0.7282D-03/
      DATA (XPV(I,4,4),I=1,100)/
     &0.4411D-02,0.4336D-02,0.4226D-02,0.4084D-02,0.3907D-02,0.3700D-02,
     &0.3469D-02,0.3316D-02,0.3248D-02,0.3153D-02,0.3032D-02,0.2886D-02,
     &0.2718D-02,0.2567D-02,0.2516D-02,0.2444D-02,0.2349D-02,0.2235D-02,
     &0.2103D-02,0.2004D-02,0.1956D-02,0.1888D-02,0.1804D-02,0.1703D-02,
     &0.1613D-02,0.1571D-02,0.1514D-02,0.1441D-02,0.1359D-02,0.1317D-02,
     &0.1269D-02,0.1210D-02,0.1153D-02,0.1116D-02,0.1069D-02,0.1022D-02,
     &0.9882D-03,0.9465D-03,0.9161D-03,0.8828D-03,0.8558D-03,0.8276D-03,
     &0.8060D-03,0.7854D-03,0.7672D-03,0.7526D-03,0.7404D-03,0.7330D-03,
     &0.7277D-03,0.7261D-03,0.7277D-03,0.7338D-03,0.7434D-03,0.7565D-03,
     &0.7745D-03,0.7963D-03,0.8222D-03,0.8532D-03,0.8886D-03,0.9283D-03,
     &0.9728D-03,0.1021D-02,0.1074D-02,0.1131D-02,0.1192D-02,0.1257D-02,
     &0.1325D-02,0.1397D-02,0.1473D-02,0.1554D-02,0.1642D-02,0.1739D-02,
     &0.1852D-02,0.1988D-02,0.2158D-02,0.2377D-02,0.2664D-02,0.3029D-02,
     &0.3074D-02,0.3119D-02,0.3163D-02,0.3207D-02,0.3251D-02,0.3294D-02,
     &0.3336D-02,0.3377D-02,0.3416D-02,0.3452D-02,0.3486D-02,0.3517D-02,
     &0.3543D-02,0.3564D-02,0.3578D-02,0.3582D-02,0.3574D-02,0.3549D-02,
     &0.3500D-02,0.3411D-02,0.3249D-02,0.2916D-02/
      DATA (XPV(I,5,0),I=1,100)/
     &0.3395D+00,0.3321D+00,0.3219D+00,0.3090D+00,0.2933D+00,0.2751D+00,
     &0.2550D+00,0.2414D+00,0.2348D+00,0.2261D+00,0.2153D+00,0.2025D+00,
     &0.1881D+00,0.1751D+00,0.1704D+00,0.1640D+00,0.1559D+00,0.1464D+00,
     &0.1357D+00,0.1276D+00,0.1233D+00,0.1178D+00,0.1110D+00,0.1032D+00,
     &0.9616D-01,0.9268D-01,0.8813D-01,0.8262D-01,0.7648D-01,0.7317D-01,
     &0.6948D-01,0.6506D-01,0.6083D-01,0.5795D-01,0.5442D-01,0.5097D-01,
     &0.4827D-01,0.4513D-01,0.4265D-01,0.4000D-01,0.3769D-01,0.3529D-01,
     &0.3322D-01,0.3117D-01,0.2920D-01,0.2737D-01,0.2561D-01,0.2402D-01,
     &0.2245D-01,0.2098D-01,0.1958D-01,0.1829D-01,0.1704D-01,0.1585D-01,
     &0.1476D-01,0.1370D-01,0.1270D-01,0.1178D-01,0.1090D-01,0.1007D-01,
     &0.9286D-02,0.8547D-02,0.7848D-02,0.7182D-02,0.6551D-02,0.5949D-02,
     &0.5372D-02,0.4823D-02,0.4298D-02,0.3794D-02,0.3314D-02,0.2852D-02,
     &0.2413D-02,0.1995D-02,0.1599D-02,0.1223D-02,0.8693D-03,0.5397D-03,
     &0.5052D-03,0.4716D-03,0.4388D-03,0.4068D-03,0.3757D-03,0.3454D-03,
     &0.3160D-03,0.2875D-03,0.2599D-03,0.2332D-03,0.2073D-03,0.1825D-03,
     &0.1587D-03,0.1359D-03,0.1142D-03,0.9370D-04,0.7445D-04,0.5655D-04,
     &0.4018D-04,0.2553D-04,0.1296D-04,0.3149D-05/
      DATA (XPV(I,5,1),I=1,100)/
     &0.7886D-02,0.7728D-02,0.7505D-02,0.7221D-02,0.6873D-02,0.6469D-02,
     &0.6022D-02,0.5723D-02,0.5585D-02,0.5398D-02,0.5164D-02,0.4885D-02,
     &0.4568D-02,0.4283D-02,0.4181D-02,0.4041D-02,0.3864D-02,0.3650D-02,
     &0.3408D-02,0.3225D-02,0.3131D-02,0.3005D-02,0.2850D-02,0.2668D-02,
     &0.2506D-02,0.2427D-02,0.2321D-02,0.2191D-02,0.2045D-02,0.1968D-02,
     &0.1880D-02,0.1774D-02,0.1672D-02,0.1604D-02,0.1519D-02,0.1435D-02,
     &0.1371D-02,0.1295D-02,0.1236D-02,0.1172D-02,0.1118D-02,0.1062D-02,
     &0.1015D-02,0.9690D-03,0.9257D-03,0.8867D-03,0.8503D-03,0.8197D-03,
     &0.7906D-03,0.7655D-03,0.7432D-03,0.7255D-03,0.7107D-03,0.6987D-03,
     &0.6911D-03,0.6864D-03,0.6850D-03,0.6876D-03,0.6934D-03,0.7025D-03,
     &0.7147D-03,0.7300D-03,0.7482D-03,0.7692D-03,0.7926D-03,0.8187D-03,
     &0.8465D-03,0.8768D-03,0.9089D-03,0.9431D-03,0.9801D-03,0.1020D-02,
     &0.1065D-02,0.1116D-02,0.1177D-02,0.1250D-02,0.1336D-02,0.1431D-02,
     &0.1441D-02,0.1451D-02,0.1460D-02,0.1468D-02,0.1476D-02,0.1483D-02,
     &0.1489D-02,0.1494D-02,0.1497D-02,0.1499D-02,0.1499D-02,0.1497D-02,
     &0.1492D-02,0.1483D-02,0.1471D-02,0.1454D-02,0.1430D-02,0.1398D-02,
     &0.1354D-02,0.1291D-02,0.1195D-02,0.1022D-02/
      DATA (XPV(I,5,2),I=1,100)/
     &0.9523D-02,0.9362D-02,0.9127D-02,0.8821D-02,0.8442D-02,0.7997D-02,
     &0.7501D-02,0.7174D-02,0.7029D-02,0.6828D-02,0.6569D-02,0.6258D-02,
     &0.5901D-02,0.5579D-02,0.5475D-02,0.5323D-02,0.5125D-02,0.4884D-02,
     &0.4606D-02,0.4399D-02,0.4301D-02,0.4162D-02,0.3986D-02,0.3776D-02,
     &0.3590D-02,0.3508D-02,0.3391D-02,0.3242D-02,0.3073D-02,0.2992D-02,
     &0.2897D-02,0.2777D-02,0.2663D-02,0.2592D-02,0.2499D-02,0.2408D-02,
     &0.2344D-02,0.2263D-02,0.2207D-02,0.2144D-02,0.2095D-02,0.2043D-02,
     &0.2005D-02,0.1970D-02,0.1939D-02,0.1917D-02,0.1898D-02,0.1891D-02,
     &0.1887D-02,0.1891D-02,0.1901D-02,0.1921D-02,0.1948D-02,0.1981D-02,
     &0.2025D-02,0.2076D-02,0.2134D-02,0.2204D-02,0.2281D-02,0.2367D-02,
     &0.2463D-02,0.2566D-02,0.2678D-02,0.2798D-02,0.2925D-02,0.3060D-02,
     &0.3199D-02,0.3347D-02,0.3500D-02,0.3659D-02,0.3827D-02,0.4007D-02,
     &0.4203D-02,0.4424D-02,0.4679D-02,0.4981D-02,0.5336D-02,0.5723D-02,
     &0.5764D-02,0.5803D-02,0.5840D-02,0.5875D-02,0.5906D-02,0.5934D-02,
     &0.5959D-02,0.5978D-02,0.5992D-02,0.6000D-02,0.6000D-02,0.5991D-02,
     &0.5971D-02,0.5938D-02,0.5890D-02,0.5821D-02,0.5726D-02,0.5597D-02,
     &0.5419D-02,0.5166D-02,0.4781D-02,0.4089D-02/
      DATA (XPV(I,5,3),I=1,100)/
     &0.7505D-02,0.7347D-02,0.7127D-02,0.6848D-02,0.6508D-02,0.6113D-02,
     &0.5677D-02,0.5385D-02,0.5248D-02,0.5065D-02,0.4837D-02,0.4566D-02,
     &0.4259D-02,0.3982D-02,0.3881D-02,0.3744D-02,0.3571D-02,0.3365D-02,
     &0.3131D-02,0.2953D-02,0.2861D-02,0.2738D-02,0.2589D-02,0.2414D-02,
     &0.2257D-02,0.2179D-02,0.2077D-02,0.1952D-02,0.1812D-02,0.1736D-02,
     &0.1651D-02,0.1549D-02,0.1451D-02,0.1384D-02,0.1302D-02,0.1222D-02,
     &0.1159D-02,0.1086D-02,0.1028D-02,0.9666D-03,0.9136D-03,0.8587D-03,
     &0.8123D-03,0.7666D-03,0.7236D-03,0.6846D-03,0.6479D-03,0.6163D-03,
     &0.5861D-03,0.5595D-03,0.5354D-03,0.5152D-03,0.4975D-03,0.4824D-03,
     &0.4710D-03,0.4620D-03,0.4558D-03,0.4530D-03,0.4527D-03,0.4552D-03,
     &0.4601D-03,0.4675D-03,0.4771D-03,0.4889D-03,0.5026D-03,0.5181D-03,
     &0.5351D-03,0.5540D-03,0.5746D-03,0.5972D-03,0.6228D-03,0.6525D-03,
     &0.6882D-03,0.7329D-03,0.7908D-03,0.8669D-03,0.9668D-03,0.1092D-02,
     &0.1106D-02,0.1121D-02,0.1136D-02,0.1150D-02,0.1164D-02,0.1178D-02,
     &0.1191D-02,0.1203D-02,0.1214D-02,0.1225D-02,0.1234D-02,0.1242D-02,
     &0.1247D-02,0.1250D-02,0.1251D-02,0.1247D-02,0.1239D-02,0.1224D-02,
     &0.1199D-02,0.1159D-02,0.1093D-02,0.9633D-03/
      DATA (XPV(I,5,4),I=1,100)/
     &0.7997D-02,0.7838D-02,0.7615D-02,0.7329D-02,0.6980D-02,0.6573D-02,
     &0.6123D-02,0.5823D-02,0.5684D-02,0.5497D-02,0.5261D-02,0.4981D-02,
     &0.4662D-02,0.4375D-02,0.4274D-02,0.4134D-02,0.3955D-02,0.3741D-02,
     &0.3497D-02,0.3313D-02,0.3221D-02,0.3095D-02,0.2940D-02,0.2758D-02,
     &0.2596D-02,0.2518D-02,0.2414D-02,0.2285D-02,0.2140D-02,0.2065D-02,
     &0.1981D-02,0.1877D-02,0.1779D-02,0.1715D-02,0.1634D-02,0.1555D-02,
     &0.1497D-02,0.1427D-02,0.1376D-02,0.1320D-02,0.1276D-02,0.1229D-02,
     &0.1194D-02,0.1161D-02,0.1131D-02,0.1108D-02,0.1089D-02,0.1077D-02,
     &0.1069D-02,0.1067D-02,0.1070D-02,0.1080D-02,0.1095D-02,0.1116D-02,
     &0.1144D-02,0.1178D-02,0.1218D-02,0.1265D-02,0.1318D-02,0.1378D-02,
     &0.1444D-02,0.1516D-02,0.1594D-02,0.1677D-02,0.1764D-02,0.1858D-02,
     &0.1954D-02,0.2056D-02,0.2162D-02,0.2275D-02,0.2398D-02,0.2536D-02,
     &0.2696D-02,0.2890D-02,0.3134D-02,0.3450D-02,0.3859D-02,0.4365D-02,
     &0.4425D-02,0.4485D-02,0.4544D-02,0.4602D-02,0.4658D-02,0.4713D-02,
     &0.4765D-02,0.4815D-02,0.4861D-02,0.4903D-02,0.4940D-02,0.4970D-02,
     &0.4993D-02,0.5007D-02,0.5008D-02,0.4994D-02,0.4961D-02,0.4900D-02,
     &0.4801D-02,0.4642D-02,0.4373D-02,0.3853D-02/
      DATA (XPV(I,6,0),I=1,100)/
     &0.4823D+00,0.4713D+00,0.4562D+00,0.4371D+00,0.4141D+00,0.3874D+00,
     &0.3580D+00,0.3381D+00,0.3284D+00,0.3157D+00,0.3000D+00,0.2816D+00,
     &0.2609D+00,0.2422D+00,0.2354D+00,0.2262D+00,0.2147D+00,0.2012D+00,
     &0.1860D+00,0.1744D+00,0.1685D+00,0.1606D+00,0.1511D+00,0.1401D+00,
     &0.1304D+00,0.1255D+00,0.1192D+00,0.1116D+00,0.1031D+00,0.9852D-01,
     &0.9345D-01,0.8740D-01,0.8162D-01,0.7769D-01,0.7289D-01,0.6822D-01,
     &0.6457D-01,0.6033D-01,0.5700D-01,0.5343D-01,0.5035D-01,0.4714D-01,
     &0.4439D-01,0.4166D-01,0.3905D-01,0.3663D-01,0.3429D-01,0.3219D-01,
     &0.3012D-01,0.2819D-01,0.2634D-01,0.2464D-01,0.2300D-01,0.2142D-01,
     &0.1997D-01,0.1857D-01,0.1723D-01,0.1600D-01,0.1482D-01,0.1370D-01,
     &0.1263D-01,0.1162D-01,0.1065D-01,0.9734D-02,0.8858D-02,0.8020D-02,
     &0.7218D-02,0.6455D-02,0.5727D-02,0.5031D-02,0.4372D-02,0.3743D-02,
     &0.3148D-02,0.2587D-02,0.2059D-02,0.1563D-02,0.1101D-02,0.6756D-03,
     &0.6315D-03,0.5886D-03,0.5468D-03,0.5062D-03,0.4667D-03,0.4284D-03,
     &0.3913D-03,0.3553D-03,0.3206D-03,0.2871D-03,0.2547D-03,0.2238D-03,
     &0.1942D-03,0.1660D-03,0.1392D-03,0.1139D-03,0.9030D-04,0.6843D-04,
     &0.4849D-04,0.3074D-04,0.1557D-04,0.3784D-05/
      DATA (XPV(I,6,1),I=1,100)/
     &0.1205D-01,0.1178D-01,0.1142D-01,0.1096D-01,0.1041D-01,0.9763D-02,
     &0.9053D-02,0.8577D-02,0.8354D-02,0.8057D-02,0.7688D-02,0.7251D-02,
     &0.6756D-02,0.6310D-02,0.6149D-02,0.5929D-02,0.5654D-02,0.5325D-02,
     &0.4953D-02,0.4670D-02,0.4526D-02,0.4332D-02,0.4097D-02,0.3822D-02,
     &0.3577D-02,0.3456D-02,0.3297D-02,0.3102D-02,0.2885D-02,0.2769D-02,
     &0.2639D-02,0.2483D-02,0.2333D-02,0.2232D-02,0.2107D-02,0.1985D-02,
     &0.1891D-02,0.1781D-02,0.1696D-02,0.1604D-02,0.1526D-02,0.1445D-02,
     &0.1377D-02,0.1310D-02,0.1248D-02,0.1192D-02,0.1139D-02,0.1094D-02,
     &0.1052D-02,0.1015D-02,0.9816D-03,0.9544D-03,0.9311D-03,0.9114D-03,
     &0.8975D-03,0.8872D-03,0.8810D-03,0.8801D-03,0.8830D-03,0.8899D-03,
     &0.9007D-03,0.9151D-03,0.9330D-03,0.9541D-03,0.9781D-03,0.1005D-02,
     &0.1034D-02,0.1065D-02,0.1099D-02,0.1135D-02,0.1174D-02,0.1217D-02,
     &0.1266D-02,0.1323D-02,0.1392D-02,0.1478D-02,0.1581D-02,0.1696D-02,
     &0.1708D-02,0.1720D-02,0.1731D-02,0.1741D-02,0.1751D-02,0.1759D-02,
     &0.1766D-02,0.1772D-02,0.1776D-02,0.1778D-02,0.1778D-02,0.1775D-02,
     &0.1769D-02,0.1759D-02,0.1744D-02,0.1723D-02,0.1695D-02,0.1657D-02,
     &0.1604D-02,0.1530D-02,0.1417D-02,0.1218D-02/
      DATA (XPV(I,6,2),I=1,100)/
     &0.1365D-01,0.1339D-01,0.1302D-01,0.1254D-01,0.1195D-01,0.1127D-01,
     &0.1051D-01,0.1001D-01,0.9777D-02,0.9465D-02,0.9073D-02,0.8604D-02,
     &0.8069D-02,0.7589D-02,0.7425D-02,0.7195D-02,0.6900D-02,0.6544D-02,
     &0.6138D-02,0.5834D-02,0.5686D-02,0.5481D-02,0.5226D-02,0.4925D-02,
     &0.4658D-02,0.4536D-02,0.4367D-02,0.4157D-02,0.3918D-02,0.3801D-02,
     &0.3667D-02,0.3499D-02,0.3340D-02,0.3241D-02,0.3112D-02,0.2987D-02,
     &0.2897D-02,0.2787D-02,0.2709D-02,0.2624D-02,0.2557D-02,0.2487D-02,
     &0.2436D-02,0.2387D-02,0.2346D-02,0.2315D-02,0.2290D-02,0.2279D-02,
     &0.2273D-02,0.2277D-02,0.2289D-02,0.2313D-02,0.2346D-02,0.2387D-02,
     &0.2441D-02,0.2503D-02,0.2575D-02,0.2660D-02,0.2755D-02,0.2859D-02,
     &0.2974D-02,0.3099D-02,0.3232D-02,0.3374D-02,0.3523D-02,0.3680D-02,
     &0.3841D-02,0.4010D-02,0.4183D-02,0.4363D-02,0.4552D-02,0.4754D-02,
     &0.4976D-02,0.5229D-02,0.5526D-02,0.5885D-02,0.6313D-02,0.6782D-02,
     &0.6832D-02,0.6879D-02,0.6924D-02,0.6966D-02,0.7004D-02,0.7038D-02,
     &0.7067D-02,0.7091D-02,0.7108D-02,0.7117D-02,0.7116D-02,0.7105D-02,
     &0.7081D-02,0.7041D-02,0.6982D-02,0.6899D-02,0.6786D-02,0.6631D-02,
     &0.6421D-02,0.6123D-02,0.5672D-02,0.4871D-02/
      DATA (XPV(I,6,3),I=1,100)/
     &0.1167D-01,0.1141D-01,0.1105D-01,0.1060D-01,0.1005D-01,0.9414D-02,
     &0.8715D-02,0.8245D-02,0.8024D-02,0.7730D-02,0.7367D-02,0.6937D-02,
     &0.6451D-02,0.6013D-02,0.5853D-02,0.5637D-02,0.5366D-02,0.5044D-02,
     &0.4680D-02,0.4403D-02,0.4259D-02,0.4069D-02,0.3839D-02,0.3571D-02,
     &0.3331D-02,0.3212D-02,0.3055D-02,0.2866D-02,0.2654D-02,0.2540D-02,
     &0.2413D-02,0.2260D-02,0.2114D-02,0.2014D-02,0.1892D-02,0.1773D-02,
     &0.1680D-02,0.1572D-02,0.1488D-02,0.1398D-02,0.1320D-02,0.1240D-02,
     &0.1173D-02,0.1106D-02,0.1044D-02,0.9874D-03,0.9342D-03,0.8881D-03,
     &0.8442D-03,0.8052D-03,0.7698D-03,0.7399D-03,0.7134D-03,0.6903D-03,
     &0.6722D-03,0.6574D-03,0.6463D-03,0.6397D-03,0.6365D-03,0.6368D-03,
     &0.6405D-03,0.6473D-03,0.6570D-03,0.6695D-03,0.6844D-03,0.7019D-03,
     &0.7213D-03,0.7431D-03,0.7673D-03,0.7943D-03,0.8253D-03,0.8617D-03,
     &0.9063D-03,0.9627D-03,0.1036D-02,0.1133D-02,0.1259D-02,0.1412D-02,
     &0.1430D-02,0.1448D-02,0.1465D-02,0.1482D-02,0.1499D-02,0.1514D-02,
     &0.1529D-02,0.1543D-02,0.1556D-02,0.1567D-02,0.1576D-02,0.1583D-02,
     &0.1587D-02,0.1588D-02,0.1586D-02,0.1578D-02,0.1563D-02,0.1539D-02,
     &0.1504D-02,0.1448D-02,0.1358D-02,0.1189D-02/
      DATA (XPV(I,6,4),I=1,100)/
     &0.1216D-01,0.1189D-01,0.1153D-01,0.1107D-01,0.1051D-01,0.9868D-02,
     &0.9154D-02,0.8677D-02,0.8454D-02,0.8157D-02,0.7787D-02,0.7349D-02,
     &0.6851D-02,0.6404D-02,0.6244D-02,0.6025D-02,0.5749D-02,0.5420D-02,
     &0.5047D-02,0.4764D-02,0.4621D-02,0.4429D-02,0.4195D-02,0.3920D-02,
     &0.3677D-02,0.3559D-02,0.3402D-02,0.3211D-02,0.2996D-02,0.2884D-02,
     &0.2759D-02,0.2608D-02,0.2463D-02,0.2369D-02,0.2251D-02,0.2138D-02,
     &0.2053D-02,0.1952D-02,0.1879D-02,0.1800D-02,0.1736D-02,0.1670D-02,
     &0.1619D-02,0.1572D-02,0.1531D-02,0.1498D-02,0.1470D-02,0.1454D-02,
     &0.1442D-02,0.1439D-02,0.1442D-02,0.1455D-02,0.1475D-02,0.1502D-02,
     &0.1539D-02,0.1584D-02,0.1637D-02,0.1699D-02,0.1769D-02,0.1847D-02,
     &0.1934D-02,0.2027D-02,0.2128D-02,0.2235D-02,0.2348D-02,0.2468D-02,
     &0.2591D-02,0.2721D-02,0.2857D-02,0.3001D-02,0.3158D-02,0.3333D-02,
     &0.3538D-02,0.3788D-02,0.4102D-02,0.4506D-02,0.5022D-02,0.5648D-02,
     &0.5720D-02,0.5792D-02,0.5862D-02,0.5931D-02,0.5997D-02,0.6060D-02,
     &0.6120D-02,0.6176D-02,0.6226D-02,0.6271D-02,0.6308D-02,0.6337D-02,
     &0.6354D-02,0.6359D-02,0.6348D-02,0.6316D-02,0.6257D-02,0.6163D-02,
     &0.6019D-02,0.5797D-02,0.5436D-02,0.4755D-02/
      DATA (XPV(I,7,0),I=1,100)/
     &0.6367D+00,0.6216D+00,0.6010D+00,0.5752D+00,0.5440D+00,0.5081D+00,
     &0.4686D+00,0.4418D+00,0.4287D+00,0.4116D+00,0.3907D+00,0.3662D+00,
     &0.3385D+00,0.3137D+00,0.3045D+00,0.2923D+00,0.2772D+00,0.2594D+00,
     &0.2393D+00,0.2241D+00,0.2163D+00,0.2060D+00,0.1936D+00,0.1792D+00,
     &0.1665D+00,0.1602D+00,0.1520D+00,0.1421D+00,0.1311D+00,0.1252D+00,
     &0.1187D+00,0.1109D+00,0.1035D+00,0.9842D-01,0.9228D-01,0.8630D-01,
     &0.8164D-01,0.7624D-01,0.7200D-01,0.6747D-01,0.6355D-01,0.5948D-01,
     &0.5601D-01,0.5255D-01,0.4926D-01,0.4620D-01,0.4326D-01,0.4061D-01,
     &0.3801D-01,0.3557D-01,0.3324D-01,0.3109D-01,0.2903D-01,0.2705D-01,
     &0.2521D-01,0.2344D-01,0.2175D-01,0.2018D-01,0.1868D-01,0.1725D-01,
     &0.1589D-01,0.1460D-01,0.1337D-01,0.1219D-01,0.1107D-01,0.9999D-02,
     &0.8975D-02,0.8003D-02,0.7079D-02,0.6199D-02,0.5369D-02,0.4581D-02,
     &0.3839D-02,0.3144D-02,0.2492D-02,0.1883D-02,0.1320D-02,0.8054D-03,
     &0.7523D-03,0.7006D-03,0.6504D-03,0.6016D-03,0.5543D-03,0.5084D-03,
     &0.4640D-03,0.4210D-03,0.3796D-03,0.3397D-03,0.3011D-03,0.2644D-03,
     &0.2292D-03,0.1957D-03,0.1640D-03,0.1342D-03,0.1063D-03,0.8046D-04,
     &0.5699D-04,0.3611D-04,0.1829D-04,0.4453D-05/
      DATA (XPV(I,7,1),I=1,100)/
     &0.1667D-01,0.1629D-01,0.1577D-01,0.1511D-01,0.1431D-01,0.1340D-01,
     &0.1239D-01,0.1171D-01,0.1139D-01,0.1097D-01,0.1045D-01,0.9835D-02,
     &0.9139D-02,0.8514D-02,0.8286D-02,0.7979D-02,0.7594D-02,0.7137D-02,
     &0.6621D-02,0.6230D-02,0.6029D-02,0.5762D-02,0.5438D-02,0.5061D-02,
     &0.4726D-02,0.4560D-02,0.4342D-02,0.4078D-02,0.3784D-02,0.3626D-02,
     &0.3451D-02,0.3240D-02,0.3038D-02,0.2902D-02,0.2735D-02,0.2572D-02,
     &0.2446D-02,0.2299D-02,0.2185D-02,0.2064D-02,0.1960D-02,0.1852D-02,
     &0.1762D-02,0.1673D-02,0.1591D-02,0.1516D-02,0.1446D-02,0.1386D-02,
     &0.1329D-02,0.1278D-02,0.1233D-02,0.1195D-02,0.1162D-02,0.1134D-02,
     &0.1113D-02,0.1096D-02,0.1084D-02,0.1078D-02,0.1077D-02,0.1081D-02,
     &0.1090D-02,0.1103D-02,0.1119D-02,0.1140D-02,0.1164D-02,0.1191D-02,
     &0.1220D-02,0.1253D-02,0.1288D-02,0.1325D-02,0.1367D-02,0.1413D-02,
     &0.1466D-02,0.1530D-02,0.1609D-02,0.1708D-02,0.1830D-02,0.1967D-02,
     &0.1981D-02,0.1995D-02,0.2008D-02,0.2021D-02,0.2032D-02,0.2042D-02,
     &0.2051D-02,0.2058D-02,0.2063D-02,0.2066D-02,0.2066D-02,0.2063D-02,
     &0.2057D-02,0.2045D-02,0.2029D-02,0.2005D-02,0.1973D-02,0.1929D-02,
     &0.1869D-02,0.1784D-02,0.1655D-02,0.1427D-02/
      DATA (XPV(I,7,2),I=1,100)/
     &0.1825D-01,0.1787D-01,0.1734D-01,0.1666D-01,0.1584D-01,0.1488D-01,
     &0.1382D-01,0.1312D-01,0.1280D-01,0.1236D-01,0.1182D-01,0.1117D-01,
     &0.1044D-01,0.9780D-02,0.9550D-02,0.9233D-02,0.8830D-02,0.8348D-02,
     &0.7799D-02,0.7387D-02,0.7184D-02,0.6906D-02,0.6565D-02,0.6163D-02,
     &0.5808D-02,0.5642D-02,0.5418D-02,0.5140D-02,0.4827D-02,0.4670D-02,
     &0.4493D-02,0.4274D-02,0.4067D-02,0.3936D-02,0.3769D-02,0.3607D-02,
     &0.3489D-02,0.3347D-02,0.3246D-02,0.3136D-02,0.3050D-02,0.2959D-02,
     &0.2893D-02,0.2830D-02,0.2777D-02,0.2736D-02,0.2703D-02,0.2687D-02,
     &0.2678D-02,0.2680D-02,0.2693D-02,0.2720D-02,0.2757D-02,0.2805D-02,
     &0.2867D-02,0.2940D-02,0.3024D-02,0.3123D-02,0.3233D-02,0.3355D-02,
     &0.3489D-02,0.3632D-02,0.3785D-02,0.3948D-02,0.4118D-02,0.4297D-02,
     &0.4479D-02,0.4668D-02,0.4863D-02,0.5063D-02,0.5274D-02,0.5499D-02,
     &0.5750D-02,0.6038D-02,0.6381D-02,0.6800D-02,0.7306D-02,0.7864D-02,
     &0.7924D-02,0.7980D-02,0.8034D-02,0.8085D-02,0.8131D-02,0.8172D-02,
     &0.8208D-02,0.8236D-02,0.8258D-02,0.8270D-02,0.8271D-02,0.8259D-02,
     &0.8233D-02,0.8188D-02,0.8122D-02,0.8027D-02,0.7897D-02,0.7721D-02,
     &0.7480D-02,0.7139D-02,0.6624D-02,0.5709D-02/
      DATA (XPV(I,7,3),I=1,100)/
     &0.1630D-01,0.1592D-01,0.1540D-01,0.1475D-01,0.1396D-01,0.1305D-01,
     &0.1205D-01,0.1138D-01,0.1107D-01,0.1065D-01,0.1013D-01,0.9526D-02,
     &0.8839D-02,0.8222D-02,0.7995D-02,0.7690D-02,0.7310D-02,0.6860D-02,
     &0.6352D-02,0.5966D-02,0.5766D-02,0.5502D-02,0.5183D-02,0.4813D-02,
     &0.4483D-02,0.4318D-02,0.4103D-02,0.3844D-02,0.3555D-02,0.3399D-02,
     &0.3225D-02,0.3018D-02,0.2820D-02,0.2685D-02,0.2521D-02,0.2360D-02,
     &0.2235D-02,0.2091D-02,0.1978D-02,0.1857D-02,0.1754D-02,0.1647D-02,
     &0.1557D-02,0.1468D-02,0.1385D-02,0.1310D-02,0.1239D-02,0.1177D-02,
     &0.1118D-02,0.1066D-02,0.1018D-02,0.9774D-03,0.9411D-03,0.9091D-03,
     &0.8835D-03,0.8619D-03,0.8450D-03,0.8338D-03,0.8268D-03,0.8242D-03,
     &0.8257D-03,0.8312D-03,0.8403D-03,0.8529D-03,0.8686D-03,0.8875D-03,
     &0.9087D-03,0.9331D-03,0.9605D-03,0.9915D-03,0.1028D-02,0.1070D-02,
     &0.1124D-02,0.1191D-02,0.1279D-02,0.1395D-02,0.1545D-02,0.1725D-02,
     &0.1746D-02,0.1766D-02,0.1786D-02,0.1805D-02,0.1823D-02,0.1841D-02,
     &0.1857D-02,0.1872D-02,0.1886D-02,0.1897D-02,0.1907D-02,0.1913D-02,
     &0.1916D-02,0.1915D-02,0.1909D-02,0.1897D-02,0.1877D-02,0.1846D-02,
     &0.1799D-02,0.1729D-02,0.1618D-02,0.1411D-02/
      DATA (XPV(I,7,4),I=1,100)/
     &0.1678D-01,0.1640D-01,0.1587D-01,0.1522D-01,0.1442D-01,0.1350D-01,
     &0.1249D-01,0.1181D-01,0.1149D-01,0.1107D-01,0.1055D-01,0.9935D-02,
     &0.9238D-02,0.8611D-02,0.8385D-02,0.8078D-02,0.7694D-02,0.7237D-02,
     &0.6721D-02,0.6331D-02,0.6132D-02,0.5867D-02,0.5545D-02,0.5170D-02,
     &0.4837D-02,0.4676D-02,0.4462D-02,0.4202D-02,0.3912D-02,0.3761D-02,
     &0.3592D-02,0.3388D-02,0.3194D-02,0.3068D-02,0.2911D-02,0.2759D-02,
     &0.2646D-02,0.2513D-02,0.2415D-02,0.2310D-02,0.2226D-02,0.2139D-02,
     &0.2072D-02,0.2010D-02,0.1955D-02,0.1911D-02,0.1875D-02,0.1852D-02,
     &0.1836D-02,0.1830D-02,0.1833D-02,0.1848D-02,0.1872D-02,0.1905D-02,
     &0.1950D-02,0.2004D-02,0.2069D-02,0.2145D-02,0.2231D-02,0.2327D-02,
     &0.2432D-02,0.2547D-02,0.2669D-02,0.2800D-02,0.2937D-02,0.3082D-02,
     &0.3232D-02,0.3389D-02,0.3553D-02,0.3727D-02,0.3917D-02,0.4130D-02,
     &0.4378D-02,0.4681D-02,0.5061D-02,0.5547D-02,0.6163D-02,0.6897D-02,
     &0.6981D-02,0.7063D-02,0.7144D-02,0.7221D-02,0.7296D-02,0.7367D-02,
     &0.7433D-02,0.7494D-02,0.7548D-02,0.7595D-02,0.7632D-02,0.7658D-02,
     &0.7671D-02,0.7667D-02,0.7644D-02,0.7595D-02,0.7513D-02,0.7388D-02,
     &0.7203D-02,0.6923D-02,0.6476D-02,0.5646D-02/

C..fetching pdfs
      DO  5 IP=-6,6
        XPDF(IP)=ZEROD
 5    CONTINUE
      DO 2 I=1,IX
        ENT(I)=LOG10(XT(I))
  2   CONTINUE
      NA(1)=IX
      NA(2)=IQ
      DO 3 I=1,IQ
        ENT(IX+I)=LOG10(Q2T(I))
   3  CONTINUE
      ARG(1)=LOG10(X)
      ARG(2)=LOG10(Q2)
C..various flavours (u-->2,d-->1)
      XPDF(0)=PHO_DBFINT(NARG,ARG,NA,ENT,XPV(1,1,0))
      XPDF(1)=PHO_DBFINT(NARG,ARG,NA,ENT,XPV(1,1,1))
      XPDF(2)=PHO_DBFINT(NARG,ARG,NA,ENT,XPV(1,1,2))
      XPDF(3)=PHO_DBFINT(NARG,ARG,NA,ENT,XPV(1,1,3))
      XPDF(4)=PHO_DBFINT(NARG,ARG,NA,ENT,XPV(1,1,4))
      DO 21 JF=1,4
        XPDF(-JF)=XPDF(JF)
 21   CONTINUE

      END



CDECK  ID>, PHO_DBFINT
      DOUBLE PRECISION FUNCTION PHO_DBFINT(NARG,ARG,NA,ENT,TABLE)
C***********************************************************************
C
C     routine based on CERN library E104
C
C     multi-dimensional interpolation routine, needed for PHOJET
C     internal cross section tables and several PDF sets (GRV98 and AGL)
C
C     changed to avoid recursive function calls (R.Engel, 09/98)
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      INTEGER NA(NARG), INDEX(32)
      DOUBLE PRECISION ARG(NARG),ENT(NARG),TABLE(*),WEIGHT(32)

      DATA ZEROD/0.D0/
      DATA ONED/1.D0/

      DBFINT    =  ZEROD
      PHO_DBFINT =  ZEROD
      IF(NARG .LT. 1  .OR.  NARG .GT. 5)  RETURN

           LMAX      =  0
           ISTEP     =  1
           KNOTS     =  1
           INDEX(1)  =  1
           WEIGHT(1) =  ONED
           DO 100    N  =  1, NARG
              X     =  ARG(N)
              NDIM  =  NA(N)
              LOCA  =  LMAX
              LMIN  =  LMAX + 1
              LMAX  =  LMAX + NDIM
              IF(NDIM .GT. 2)  GOTO 10
              IF(NDIM .EQ. 1)  GOTO 100
              H  =  X - ENT(LMIN)
              IF(H .EQ. ZEROD)  GOTO 90
              ISHIFT  =  ISTEP
              IF(X-ENT(LMIN+1) .EQ. ZEROD)  GOTO 21
              ISHIFT  =  0
              ETA     =  H / (ENT(LMIN+1) - ENT(LMIN))
              GOTO 30
   10         LOCB  =  LMAX + 1
   11         LOCC  =  (LOCA+LOCB) / 2
              IF(X-ENT(LOCC))  12, 20, 13
   12         LOCB  =  LOCC
              GOTO 14
   13         LOCA  =  LOCC
   14         IF(LOCB-LOCA .GT. 1)  GOTO 11
              LOCA    =  MIN ( MAX (LOCA,LMIN), LMAX-1 )
              ISHIFT  =  (LOCA - LMIN) * ISTEP
              ETA     =  (X - ENT(LOCA)) / (ENT(LOCA+1) - ENT(LOCA))
              GOTO 30
   20         ISHIFT  =  (LOCC - LMIN) * ISTEP
   21         DO 22  K  =  1, KNOTS
                 INDEX(K)  =  INDEX(K) + ISHIFT
   22         CONTINUE
              GOTO 90
   30         DO 31  K  =  1, KNOTS
                 INDEX(K)         =  INDEX(K) + ISHIFT
                 INDEX(K+KNOTS)   =  INDEX(K) + ISTEP
                 WEIGHT(K+KNOTS)  =  WEIGHT(K) * ETA
                 WEIGHT(K)        =  WEIGHT(K) - WEIGHT(K+KNOTS)
   31         CONTINUE
              KNOTS  =  2*KNOTS
   90         ISTEP  =  ISTEP * NDIM
  100      CONTINUE
           DO 200    K  =  1, KNOTS
              I  =  INDEX(K)
              DBFINT =  DBFINT + WEIGHT(K) * TABLE(I)
  200      CONTINUE

      PHO_DBFINT = DBFINT

      END


CDECK  ID>, PHVAL
      SUBROUTINE PHVAL(IGRP,ISET,XI,SCALE2,PD,IRET)
C**********************************************************************
C
C   dummy subroutine, remove to link PHOLIB
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION PD(-6:6)
      END
c  This is to set values for IE by IE-1; avoid neg.cross.section
      SUBROUTINE PHO_PRBDIS2(IP,ECM,IE)
C*********************************************************************
C
C     calculation of multi interactions probabilities
C
C     input:  IP        particle combination to scatter
C             ECM       CMS energy
C             IE        index for weight storing
C             /PROBAB/
C             IMAX      max. number of soft pomeron interactions
C             KMAX      max. number of hard pomeron interactions
C
C     output: /PROBAB/
C             PROB      field of probabilities
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( EPS=1.D-10 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  parameters of 2x2 channel model
      DOUBLE PRECISION PHISUP,RMASS,VAR,AMPFAC,ELAFAC,VFAC
      COMMON /PO2CHA/ PHISUP(2),RMASS(2),VAR,AMPFAC(4),ELAFAC(4),VFAC

C  Born graph cross sections and slopes
      INTEGER MAX_PRO_3
      PARAMETER ( MAX_PRO_3 = 16 )
      COMPLEX*16      SIGP,SIGR,SIGHD,SIGHR,SIGT1,SIGT2,SIGL,SIGDP,
     &                SIGD1,SIGD2,DSIGH
      COMMON /POSBRN/ SIGP,SIGR,SIGHD,SIGHR,SIGT1(2),SIGT2(2),SIGL,
     &                SIGDP(4),SIGD1(2),SIGD2(2),DSIGH(0:MAX_PRO_3)

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  Born graph cross sections after applying diffraction model
      DOUBLE PRECISION SBOPOM,SBOREG,SBOHAR,SBOHAD,SBOTR1,SBOTR2,
     &                 SBOLPO,SBODPO
      COMMON /POINT1/ SBOPOM(0:4),SBOREG(0:4),SBOHAR(0:4),SBOHAD(0:4),
     &                SBOTR1(0:4,2),SBOTR2(0:4,2),SBOLPO(0:4),
     &                SBODPO(0:4,4)

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL

C  cut probability distribution
      INTEGER IEETA1,IIMAX,KKMAX
      PARAMETER( IEETA1=20, IIMAX=20, KKMAX=20 )
      INTEGER IEEMAX,IMAX,KMAX
      REAL PROB
      DOUBLE PRECISION EPTAB
      COMMON /POPROB/ PROB(4,IEETA1,0:IIMAX,0:KKMAX),EPTAB(4,IEETA1),
     &                IEEMAX,IMAX,KMAX

C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX

C  average number of cut soft and hard ladders (obsolete)
      DOUBLE PRECISION AVERI,AVERK,AVERL,AVERM,AVERN
      COMMON /POINT2/ AVERI,AVERK,AVERL,AVERM,AVERN

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  integration precision for hard cross sections (obsolete)
      INTEGER NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO
      COMMON /POGAUP/ NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  unitarized amplitudes for different diffraction channels
      DOUBLE PRECISION ZXP,BXP,ZXR,BXR,ZXH,BXH,ZXD,BXD,
     &                 ZXT1A,BXT1A,ZXT1B,BXT1B,ZXT2A,BXT2A,ZXT2B,BXT2B,
     &                 ZXDPE,BXDPE,ZXDPA,BXDPA,ZXDPB,BXDPB,ZXDPD,BXDPD,
     &                 ZXL,BXL
      COMMON /POINT5/ ZXP(4,4),BXP(4,4),ZXR(4,4),BXR(4,4),
     &                ZXH(4,4),BXH(4,4),ZXD(4,4),BXD(4,4),
     &                ZXT1A(4,4),BXT1A(4,4),ZXT1B(4,4),BXT1B(4,4),
     &                ZXT2A(4,4),BXT2A(4,4),ZXT2B(4,4),BXT2B(4,4),
     &                ZXDPE(4,4),BXDPE(4,4),ZXDPA(4,4),BXDPA(4,4),
     &                ZXDPB(4,4),BXDPB(4,4),ZXDPD(4,4),BXDPD(4,4),
     &                ZXL(4,4),BXL(4,4)


C  local variables
      DIMENSION  AB(4,4),CHI2(4),ABSUM2(4,4),ABSTMP(4),CHITMP(4)
      PARAMETER (ICHMAX=40)
      DIMENSION CHIFAC(4,4),AMPCOF(4)
      DIMENSION PCHAIN(2,ICHMAX),XPNT(96),WGHT(96)
      DIMENSION FACLOG(0:30),PSOFT(0:30),PHARD(0:30)

C  combinatorical factors
      DATA      CHIFAC / 1.D0, 1.D0,-1.D0,-1.D0,
     &                   1.D0,-1.D0, 1.D0,-1.D0,
     &                   1.D0,-1.D0,-1.D0, 1.D0,
     &                   1.D0, 1.D0, 1.D0, 1.D0 /

      DATA FACLOG /           .000000000000000D+00,
     &  .000000000000000D+00, .693147180559945D+00,
     &  .109861228866811D+01, .138629436111989D+01,
     &  .160943791243410D+01, .179175946922805D+01,
     &  .194591014905531D+01, .207944154167984D+01,
     &  .219722457733622D+01, .230258509299405D+01,
     &  .239789527279837D+01, .248490664978800D+01,
     &  .256494935746154D+01, .263905732961526D+01,
     &  .270805020110221D+01, .277258872223978D+01,
     &  .283321334405622D+01, .289037175789616D+01,
     &  .294443897916644D+01, .299573227355399D+01,
     &  .304452243772342D+01, .309104245335832D+01,
     &  .313549421592915D+01, .317805383034795D+01,
     &  .321887582486820D+01, .325809653802148D+01,
     &  .329583686600433D+01, .333220451017520D+01,
     &  .336729582998647D+01, .340119738166216D+01 /

      DATA  ELAST / 0.D0 /
      DATA  IPLAST / 0 /

C  test for redundant calculation: skip cs calculation
      IF((ECM.NE.ELAST).OR.(IP.NE.IPLAST)) THEN
        ELAST = ECM
        IPLAST = IP
ccc        CALL PHO_XSECT(IP,0,ELAST)
        ISIMAX = IE
        SIGECM(IP,IE) = ECM
ccc        SIGTAB(IP,1,IE) = SIGTOT
        SIGTAB(IP,1,IE) = SIGTAB(IP,1,IE-1)
ccc        SIGTAB(IP,2,IE) = SIGELA
        SIGTAB(IP,2,IE) = SIGTAB(IP,2,IE-1) 
        J = 2
        DO 5 I=0,4
          DO 6 K=0,4
            J = J+1
ccc            SIGTAB(IP,J,IE) = SIGVM(I,K)
            SIGTAB(IP,J,IE) = SIGTAB(IP,J,IE-1)
 6        CONTINUE
 5      CONTINUE
cc        SIGTAB(IP,28,IE) = SIGINE
        SIGTAB(IP,28,IE) =  SIGTAB(IP,28,IE-1)
cc        SIGTAB(IP,29,IE) = SIGDIR
        SIGTAB(IP,29,IE) = SIGTAB(IP,29,IE-1)
cc        SIGTAB(IP,30,IE) = SIGLSD(1)
        SIGTAB(IP,30,IE) = SIGTAB(IP,30,IE-1)
cc        SIGTAB(IP,31,IE) = SIGLSD(2)
        SIGTAB(IP,31,IE) = SIGTAB(IP,31,IE-1)
cc        SIGTAB(IP,32,IE) = SIGHSD(1)
        SIGTAB(IP,32,IE) = SIGTAB(IP,32,IE-1)
cc        SIGTAB(IP,33,IE) = SIGHSD(2)
        SIGTAB(IP,33,IE) = SIGTAB(IP,33,IE-1)
cc        SIGTAB(IP,34,IE) = SIGLDD
        SIGTAB(IP,34,IE) = SIGTAB(IP,34,IE-1)
cc        SIGTAB(IP,35,IE) = SIGHDD
        SIGTAB(IP,35,IE) = SIGTAB(IP,35,IE-1)
cc        SIGTAB(IP,36,IE) = SIGCDF(0)
        SIGTAB(IP,36,IE) = SIGTAB(IP,36,IE-1)
cc        SIGTAB(IP,37,IE) = SIG1SO
        SIGTAB(IP,37,IE) = SIGTAB(IP,37,IE-1)
cc        SIGTAB(IP,38,IE) = SIG1HA
        SIGTAB(IP,38,IE) = SIGTAB(IP,38,IE-1)
cc        SIGTAB(IP,39,IE) = SLOEL
        SIGTAB(IP,39,IE) = SIGTAB(IP,39,IE-1)
        J = 39
        DO 7 I=1,4
          DO 8 K=1,4
            J = J+1
cc
            SIGTAB(IP,J,IE) = SIGTAB(IP,J,IE-1)
 8        CONTINUE
 7      CONTINUE
cc        SIGTAB(IP,56,IE) = SIGPOM
        SIGTAB(IP,56,IE) = SIGTAB(IP,56,IE-1)
cc        SIGTAB(IP,57,IE) = SIGREG
        SIGTAB(IP,57,IE) = SIGTAB(IP,57,IE-1) 
cc        SIGTAB(IP,58,IE) = SIGHAR
        SIGTAB(IP,58,IE) = SIGTAB(IP,58,IE-1)
cc        SIGTAB(IP,59,IE) = SIGDIR
        SIGTAB(IP,59,IE) = SIGTAB(IP,59,IE-1) 
cc        SIGTAB(IP,60,IE) = SIGTR1(1)
        SIGTAB(IP,60,IE) = SIGTAB(IP,60,IE-1)
cc        SIGTAB(IP,61,IE) = SIGTR1(2)
        SIGTAB(IP,61,IE) = SIGTAB(IP,61,IE-1)
cc        SIGTAB(IP,62,IE) = SIGTR2(1)
        SIGTAB(IP,62,IE) = SIGTAB(IP,62,IE-1)
cc        SIGTAB(IP,63,IE) = SIGTR2(2)
        SIGTAB(IP,63,IE) = SIGTAB(IP,63,IE-1)
cc        SIGTAB(IP,64,IE) = SIGLOO
        SIGTAB(IP,64,IE) = SIGTAB(IP,64,IE-1)
cc        SIGTAB(IP,65,IE) = SIGDPO(1)
        SIGTAB(IP,65,IE) = SIGTAB(IP,65,IE-1)
cc        SIGTAB(IP,66,IE) = SIGDPO(2)
        SIGTAB(IP,66,IE) = SIGTAB(IP,66,IE-1)
cc        SIGTAB(IP,67,IE) = SIGDPO(3)
        SIGTAB(IP,67,IE) = SIGTAB(IP,67,IE-1)
cc        SIGTAB(IP,68,IE) = SIGDPO(4)
        SIGTAB(IP,68,IE) =  SIGTAB(IP,68,IE-1)
C  consistency check
c        SIGNDF = SIGTOT-SIGELA-SIGVM(0,0)-SIGCDF(0)-SIGDIR
c     &          -SIGLSD(1)-SIGHSD(1)-SIGLSD(2)-SIGHSD(2)
c     &          -SIGLDD-SIGHDD
cc        above should be just bekow:
        SIGNDF = SIGTAB(IP,1,IE) -  SIGTAB(IP,2,IE)- SIGTAB(IP,3,IE) 
     *    - SIGTAB(IP,36,IE) -  SIGTAB(IP,59,IE)
     *    - SIGTAB(IP,30,IE) -  SIGTAB(IP,31,IE) 
     *    - SIGTAB(IP,32,IE) -  SIGTAB(IP,33,IE) 
     *    - SIGTAB(IP,34,IE) -  SIGTAB(IP,35,IE)

        IF(SIGNDF.LE.0.D0) THEN
          WRITE(ErrorOut,'(//1X,A,/)')
     &      'PHO_PRBDIS:ERROR: NEG.CROSS SECTION FOR UNITARIZATION!'
          WRITE(ErrorOut,'(1X,A,I3,1P,2E12.4)')
     &      'PHO_PRBDIS: IP,ECM,SIGNDF:',IP,ECM,SIGNDF
          WRITE(ErrorOut,'(4X,A,/1P,8E10.3)')
     &'(SIGTOT,SIGELA,SIGVM,SIGCDF,SIGDIR,SIGLSD(1),SIGLSD(2),SIGLDD):',
     &      SIGTOT,SIGELA,SIGVM(0,0),SIGCDF(0),SIGDIR,SIGLSD(1),
     &      SIGLSD(2),SIGLDD
          call cerrorMsg('this should not happend',0)
        ENDIF

        IF((IDEB(55).GE.2).AND.(IP.EQ.1)) THEN
          PRINT *,'------------------------------------------------'
          PRINT *,'IP,ECM:',IP,ECM
          PRINT *,'SIGTOT:',SIGTOT
          PRINT *,'SIGELA:',SIGELA
          PRINT *,'SIGVM :',SIGVM(0,0)
          PRINT *,'SIGCDF:',SIGCDF(0)
          PRINT *,'SIGDIR:',SIGDIR
          PRINT *,'SIGLSD:',SIGLSD
          PRINT *,'SIGHSD:',SIGHSD
          PRINT *,'SIGLDD:',SIGLDD
          PRINT *,'SIGHDD:',SIGHDD
          PRINT *,'SIGNDF:',SIGNDF

          PRINT *,'SIGPOM:',SIGPOM
          PRINT *,'SIGREG:',SIGREG
          PRINT *,'SIGHAR:',SIGHAR
          PRINT *,'SIGDIR:',SIGDIR
          PRINT *,'SIGTR1:',SIGTR1
          PRINT *,'SIGTR2:',SIGTR2
          PRINT *,'SIGLOO:',SIGLOO
          PRINT *,'SIGDPO:',SIGDPO
          PRINT *,'SIG1SO:',SIG1SO
          PRINT *,'SIG1HA:',SIG1HA
        ENDIF

cc       SIGTAB(IP,77,IE) = PTCUT(IP)
       SIGTAB(IP,77,IE) =  SIGTAB(IP,77,IE-1)
cc        SIGTAB(IP,78,IE) = SIGNDF
        SIGTAB(IP,78,IE) = SIGTAB(IP,78,IE-1)

        AUXFAC = PI2/SIGNDF
        IF(ISWMDL(1).EQ.3) THEN
          DO 133 I=1,4
            AMPCOF(I) = 0.D0
            DO 135 K=1,4
              AMPCOF(I) = AMPCOF(I) + 0.25D0*ELAFAC(K)*CHIFAC(K,I)
 135        CONTINUE
            AMPCOF(I) = AMPCOF(I)*AUXFAC
 133      CONTINUE
        ENDIF
C
*       BMAX=5.D0*SQRT(DBLE(BPOM))
        BMAX=10.D0
        EPTAB(IP,IE) = ECM
        CALL PHO_GAUSET(0.D0,BMAX,NGAUSO,XPNT,WGHT)
C
      ENDIF
C
      DO 160 K=0,KMAX
        DO 170 I=0,IMAX
          PROB(IP,IE,I,K) = 0.D0
 170    CONTINUE
 160  CONTINUE
      DO 120 I=1,ICHMAX
        PCHAIN(1,I) = 0.D0
        PCHAIN(2,I) = 0.D0
 120  CONTINUE
C
C  main cross section loop
C**********************************************************
      DO 5000 IB=1,NGAUSO
        B24=XPNT(IB)**2/4.D0
        FAC = XPNT(IB)*WGHT(IB)
C
        IF((ISWMDL(1).EQ.3).OR.(ISWMDL(1).EQ.4)) THEN
C
C  amplitude construction
          DO 525 I=1,4
            AB(1,I)=ZXP(1,I)*EXP(-B24/BXP(1,I))
     &              +ZXR(1,I)*EXP(-B24/BXR(1,I))
            AB(2,I)=ZXH(1,I)*EXP(-B24/BXH(1,I))
            AB(3,I)=-ZXT1A(1,I)*EXP(-B24/BXT1A(1,I))
     &              -ZXT1B(1,I)*EXP(-B24/BXT1B(1,I))
     &              -ZXT2A(1,I)*EXP(-B24/BXT2A(1,I))
     &              -ZXT2B(1,I)*EXP(-B24/BXT2B(1,I))
     &              -ZXL(1,I)*EXP(-B24/BXL(1,I))
            AB(4,I)=ZXDPE(1,I)*EXP(-B24/BXDPE(1,I))
     &              +ZXDPA(1,I)*EXP(-B24/BXDPA(1,I))
     &              +ZXDPB(1,I)*EXP(-B24/BXDPB(1,I))
     &              +ZXDPD(1,I)*EXP(-B24/BXDPD(1,I))
            AB(1,I) = AB(1,I)+AB(3,I)+AB(4,I)
            AB(2,I) = AB(2,I)
            AB(3,I) = 0.D0
            AB(4,I) = 0.D0
*
 525      CONTINUE
C
          DO 460 I=1,4
            DO 500 K=1,4
              ABSUM2(I,K) = 0.D0
              DO 550 L=1,4
                ABSUM2(I,K) = ABSUM2(I,K) + CHIFAC(L,K)*AB(I,L)
 550          CONTINUE
              ABSUM2(I,K) = 2.D0*ABSUM2(I,K)
 500        CONTINUE
 460      CONTINUE
          DO 600 I=1,4
            CHI2(I) = 0.D0
            DO 650 K=1,4
              CHI2(I) = CHI2(I) + ABSUM2(K,I)
 650        CONTINUE
 600      CONTINUE
C  sums instead of products
          DO 660 I=1,4
            DO 670 KD=1,4
              DTMP = ABS(ABSUM2(I,KD))
              IF(DTMP.LT.1.D-30) THEN
                ABSUM2(I,KD) = -50.D0
              ELSE
                ABSUM2(I,KD) = LOG(DTMP)
              ENDIF
 670        CONTINUE
 660      CONTINUE


          IF(MAX(IMAX,KMAX).GT.30) THEN
            WRITE(ErrorOut,
     * '(1X,2A,3I6)') 'PHO_PRBDIS: internal field ',
     &        'DIMENSION TOO SMALL (IMAX,KMAX,INT):',IMAX,KMAX,30
            CALL PHO_ABORT
          ENDIF

          DO 700 KD=1,4
            DO 750 I=1,4
              ABSTMP(I) = ABSUM2(I,KD)
 750        CONTINUE
C  recursive sum
            CHITMP(1) = -ABSUM2(1,KD)
            DO 800 I=0,IMAX
              CHITMP(1) = CHITMP(1)+ABSTMP(1)-FACLOG(I)
              CHITMP(2) = -ABSTMP(2)
              DO 810 K=0,KMAX
                CHITMP(2) = CHITMP(2)+ABSTMP(2)-FACLOG(K)
C  calculation of elastic part
                DTMP = -CHI2(KD)+CHITMP(1)+CHITMP(2)
                IF(DTMP.LT.-30.D0) THEN
                  DTMP = 0.D0
                ELSE
                  DTMP = EXP(DTMP)*FAC*AMPCOF(KD)
                ENDIF
cc                PROB(IP,IE,I,K) = PROB(IP,IE,I,K) + DTMP
                PROB(IP,IE,I,K) =  PROB(IP,IE-1,I,K)
 810          CONTINUE
 800        CONTINUE
 700      CONTINUE
          PROB(IP,IE,0,0) = 0.D0
C
C**********************************************************
        ELSE
          WRITE(ErrorOut,'(1X,A,I3)')
     &      'PHO_PRBDIS:ERROR: INVALID SETTING OF ISWMDL(1)',ISWMDL(1)
          STOP
        ENDIF
 5000 CONTINUE

C  debug output
      IF(IDEB(55).GE.15) THEN
        WRITE(ErrorOut,'(/,1X,A,I3,E11.4)')
     &    'PHO_PRBDIS: LIST OF PROBABILITIES (UNCORRECTED,IP,ECM)',
     &    IP,ECM
        DO 905 I=0,MIN(IMAX,5)
          DO 915 K=0,MIN(KMAX,5)
            IF(ABS(PROB(IP,IE,I,K)).GT.1.D-10)
     &        WRITE(ErrorOut,
     * '(10X,2I3,5X,E12.3)') I,K,PROB(IP,IE,I,K)
 915      CONTINUE
 905    CONTINUE
      ENDIF
C  string probability (uncorrected)
      IF(IDEB(55).GE.5) THEN
        DO 955 I=0,IMAX
          DO 965 K=0,KMAX
            INDX = 2*I+2*K
            IF((INDX.LE.ICHMAX).AND.(INDX.GT.0)) THEN
              PCHAIN(1,INDX) = PCHAIN(1,INDX) + PROB(IP,IE,I,K)
            ENDIF
 965      CONTINUE
 955    CONTINUE
        WRITE(ErrorOut,'(/1X,2A,E11.4)') 'PHO_PRBDIS: ',
     &    'LIST OF SELECTED PROBABILITIES (UNCORR,ECM)',ECM
        WRITE(ErrorOut,'(10X,A)') 'I,   0HPOM,   1HPOM,   2HPOM'
        DO 183 I=0,IIMAX
          IF(ABS(PROB(IP,IE,I,0)).GT.1.D-10)
     &      WRITE(ErrorOut,'(5X,I4,3E12.4)') I,PROB(IP,IE,I,0),
     &      PROB(IP,IE,I,1),PROB(IP,IE,I,2)
 183    CONTINUE
      ENDIF
C  substract high-mass single and double diffraction
cc      PROB(IP,IE,1,0) = PROB(IP,IE,1,0)
cc     &                 -(SIGHSD(1)+SIGHSD(2)+SIGHDD+SIGCDF(0))/SIGNDF
cc      PROB(IP,IE,1,0) = MAX(0.01,PROB(IP,IE,1,0))
  
      PROB(IP,IE,1,0) = PROB(IP,IE-1,1,0)
C
C  probability check
      CHKSUM = 0.D0
      PRONEG = 0.D0
      AVERI =  0.D0
      AVERK =  0.D0
      AVERL =  0.D0
      AVERM =  0.D0
      AVERN =  0.D0
      SIGMI =  0.D0
      SIGMK =  0.D0
      SIGML =  0.D0
      SIGMM =  0.D0
      DO 1001 I=0,IMAX
        PSOFT(I) = 0.D0
 1001 CONTINUE
      DO 1002 K=0,KMAX
        PHARD(K) = 0.D0
 1002 CONTINUE
      DO 1000 K=0,KMAX
        DO 1010 I=0,IMAX
          TMP = PROB(IP,IE,I,K)
          IF(TMP.LT.0.D0) THEN
            IF((IDEB(55).GE.0).AND.(TMP.LT.-EPS)) THEN
              WRITE(ErrorOut,'(1X,A,4I4,E14.4)')
     &          'PHO_PRBDIS: NEG.PROBABILITY:',
     &              IP,IE,I,K,PROB(IP,IE,I,K)
            ENDIF
            PRONEG = PRONEG+TMP
            TMP = 0.D0
          ENDIF
          CHKSUM = CHKSUM+TMP
          AVERI = AVERI+DBLE(I)*TMP
          AVERK = AVERK+DBLE(K)*TMP
          SIGMI = SIGMI+DBLE(I**2)*TMP
          SIGMK = SIGMK+DBLE(K**2)*TMP
          PSOFT(I) = PSOFT(I)+PROB(IP,IE,I,K)
          PHARD(K) = PHARD(K)+PROB(IP,IE,I,K)
cc          PROB(IP,IE,I,K) = CHKSUM
          PROB(IP,IE,I,K) =  PROB(IP,IE-1,I,K)
 1010   CONTINUE
 1000 CONTINUE
C
      IF(IDEB(55).GE.1) WRITE(ErrorOut,'(/,1X,A,2E15.6)')
     &  'PHO_PRBDIS: FIRST SUM OF PROBABILITIES',CHKSUM,PRONEG
C  cut probabilites output
      IF(IDEB(55).GE.5) THEN
        WRITE(ErrorOut,
     * '(/1X,A)') 'list of cut probabilities (uncorr/corr)'
        DO 185 I=1,ICHMAX
          IF(ABS(PCHAIN(1,I)).GT.1.D-10)
     &      WRITE(ErrorOut,
     * '(5X,I4,2E12.3)') I,PCHAIN(1,I),PCHAIN(1,I)/CHKSUM
 185    CONTINUE
      ENDIF
C  rescaling necessary
      IF(ABS(CHKSUM-1.D0).GT.1.D-15) THEN
        FAC = 1.D0/CHKSUM
        IF(IDEB(55).GE.1) WRITE(ErrorOut,'(/,1X,A,E15.6)')
     &    'PHO_PRBDIS: RESCALING OF PROBABILITIES WITH FACTOR',FAC
        DO 40 K=0,KMAX
          DO 50 I=0,IMAX
cc            PROB(IP,IE,I,K) = PROB(IP,IE,I,K)*FAC
            PROB(IP,IE,I,K) = PROB(IP,IE-1,I,K)
  50      CONTINUE
  40    CONTINUE
        AVERI = AVERI*FAC
        AVERK = AVERK*FAC
        AVERL = AVERL*FAC
        AVERM = AVERM*FAC
        SIGMI = SIGMI*FAC**2
        SIGMK = SIGMK*FAC**2
        SIGML = SIGML*FAC**2
        SIGMM = SIGMM*FAC**2
      ENDIF
C
C  probability to find Reggeon/Pomeron
      PROB(IP,IE,0,0) = -SIGREG/(SIGPOM+SIGREG)
      AVERJ = -PROB(IP,IE,0,0)*AVERI
      AVERII = AVERI-AVERJ
C
cc      SIGTAB(IP,74,IE) = AVERII
      SIGTAB(IP,74,IE) =  SIGTAB(IP,74,IE-1)
cc      SIGTAB(IP,75,IE) = AVERK
      SIGTAB(IP,75,IE) =  SIGTAB(IP,75,IE-1)
cc      SIGTAB(IP,76,IE) = AVERJ
      SIGTAB(IP,76,IE) = SIGTAB(IP,76,IE-1)
C
cc      SIGTAB(IP,79,IE) = PROB(IP,IE,IMAX,0)*SIGNDF
      SIGTAB(IP,79,IE) =  SIGTAB(IP,79,IE-1)
cc      SIGTAB(IP,80,IE) = SIGNDF-SIGTAB(IP,79,IE)
      SIGTAB(IP,80,IE) =  SIGTAB(IP,80,IE-1)
C
      IF(IDEB(55).GE.1) THEN

C  average interaction probabilities
        WRITE(ErrorOut,'(/1X,A,/1X,A)')
     &    'PHO_PRBDIS: EXPECTED INTERACTION STATISTICS',
     &    '-------------------------------------------'
        WRITE(ErrorOut,'(1X,A,E12.4,2I3)')
     &    'ENERGY,IP,TABLE INDEX:',EPTAB(IP,IE),IP,IE
        WRITE(ErrorOut,
     * '(1X,A,2I4)') 'current limitations (soft,hard):',
     &    IMAX,KMAX
        WRITE(ErrorOut,'(1X,A,E12.4/,4X,A,/,1X,6E11.3)')
     &    'AVERAGED NUMBER OF CUTS PER EVENT (EFF. CS):',SIGNDF,
     &    ' (POM / POM-H / REG / ENH-TRI-LOOP / ENH-DBLE / SUM):',
     &    AVERII,AVERK,AVERJ,AVERL,AVERM,
     &    AVERI+AVERK+AVERL+AVERM
        WRITE(ErrorOut,'(1X,A,/,4X,A,/,1X,4E11.3)')
     &    'STANDARD DEVIATION ( SQRT(SIGMA) ):',
     &    ' (POMERON / POMERON-H / ENH-TRI-LOOP / ENH-DBLE):',
     &    SQRT(ABS(SIGMI-AVERI**2)),SQRT(ABS(SIGMK-AVERK**2)),
     &    SQRT(ABS(SIGML-AVERL**2)),SQRT(ABS(SIGMM-AVERM**2))
        WRITE(ErrorOut,
     * '(1X,A)') 'cross section / probability  soft, hard'
        DO I=0,MIN(IMAX,KMAX)
          WRITE(ErrorOut,'(I5,2E12.4,3X,2E12.4)')
     &      I,PSOFT(I)*SIGNDF,PSOFT(I),PHARD(I)*SIGNDF,PHARD(I)
        ENDDO

C  cross check of probability distribution and inclusive cross section
        PSSUM_1 = 0.D0
        PSSUM_2 = 0.D0
        PHSUM_1 = 0.D0
        PHSUM_2 = 0.D0
        DO I=1,IMAX
          PSSUM_1 = PSSUM_1+PSOFT(I)*FAC
          PSSUM_2 = PSSUM_2+PSOFT(I)*FAC*DBLE(I)
        ENDDO
        DO K=1,KMAX
          PHSUM_1 = PHSUM_1+PHARD(K)
          PHSUM_2 = PHSUM_2+PHARD(K)*FAC*DBLE(K)
        ENDDO
        WRITE(ErrorOut,'(1x,a,2E12.4,3X,2E12.4)') 'sum:',
     &    PSSUM_2*SIGNDF,PSSUM_1,PHSUM_2*SIGNDF,PHSUM_1

      ENDIF

      END
#else
      SUBROUTINE PHO_INIT(LINP,IREJ)
      end
#endif
