#include "Zcondc.h"
#if USEDPMJET == 1
CDECK  ID>, PHO_GLU2QU
      SUBROUTINE PHO_GLU2QU(IG,IQ1,IQ2,IREJ)
C********************************************************************
C
C    split gluon with index I in POEVT1
C          (massless gluon assumed)
C
C    input:      /POEVT1/
C                IG      gluon index
C                IQ1     first quark index
C                IQ2     second quark index
C
C    output:     new quarks in /POEVT1/
C                IREJ    1 splitting impossible
C                        0 splitting successful
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS   =  1.D-15,
     &            EPS    =  1.D-5 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)


      DIMENSION P1(4),P2(4)
      DATA CUTM  /0.02D0/

      IREJ = 0

C  calculate string masses max possible
      IF(ISWMDL(9).EQ.1) THEN
        CMASS1=2.D0*(PHEP(4,IG)*PHEP(4,IQ1)-PHEP(1,IG)*PHEP(1,IQ1)
     &     -PHEP(2,IG)*PHEP(2,IQ1)-PHEP(3,IG)*PHEP(3,IQ1))
        IF(CMASS1.LT.CUTM) THEN
          IF(IDEB(73).GE.5) THEN
            WRITE(ErrorOut,'(1X,A,3I4,4E10.3)')
     &        'PHO_GLU2QU:REJECTION:IG,IQ1,IQ2,CMASS1',IG,IQ1,IQ2,CMASS1
          ENDIF
          IFAIL(33) = IFAIL(33) + 1
          IREJ = 1
          RETURN
        ENDIF
        CMASS2=2.D0*(PHEP(4,IG)*PHEP(4,IQ2)-PHEP(1,IG)*PHEP(1,IQ2)
     &     -PHEP(2,IG)*PHEP(2,IQ2)-PHEP(3,IG)*PHEP(3,IQ2))
        IF(CMASS2.LT.CUTM) THEN
          IF(IDEB(73).GE.5) THEN
            WRITE(ErrorOut,'(1X,A,3I4,4E10.3)')
     &        'PHO_GLU2QU:REJECTION:IG,IQ1,IQ2,CMASS2',IG,IQ1,IQ2,CMASS2
          ENDIF
          IFAIL(33) = IFAIL(33) + 1
          IREJ = 1
          RETURN
        ENDIF
C
C  calculate minimal z
        ZMIN1 = (CUTM-SIGN(PHEP(5,IQ1)**2,PHEP(5,IQ1)))/CMASS1+EPS
        ZMIN2 = (CUTM-SIGN(PHEP(5,IQ2)**2,PHEP(5,IQ2)))/CMASS2+EPS
        ZMIN = MIN(ZMIN1,ZMIN2)
        IF(MAX(ZMIN1,ZMIN2).GE.0.45D0) THEN
          IF(IDEB(73).GE.5) THEN
            WRITE(ErrorOut,'(1X,A,3I3,4E10.3)')
     &        'PHO_GLU2QU:REJECTION:IG,IQ1,IQ2,ZMIN1,ZMIN2,P1*PG,P2*PG',
     &        IG,IQ1,IQ2,ZMIN1,ZMIN2,CMASS1,CMASS2
          ENDIF
          IFAIL(33) = IFAIL(33) + 1
          IREJ = 1
          RETURN
        ENDIF
      ELSE
        ZMIN = MIN(0.1D0,0.5D0/PHEP(4,IG))
      ENDIF
C
      ZFRAC = PHO_GLUSPL(ZMIN)
      IF((ZFRAC.LT.ZMIN1).OR.((1.D0-ZFRAC).LT.ZMIN2)) THEN
        ZFRAC = 1.D0-ZFRAC
      ENDIF
      DO 200 I=1,4
        P1(I) = PHEP(I,IG)*ZFRAC
        P2(I) = PHEP(I,IG)*(1.D0-ZFRAC)
 200  CONTINUE
C  quark flavours
      CMASS1 = SQRT(ZFRAC*CMASS1+SIGN(PHEP(5,IQ1)**2,PHEP(5,IQ1)))
      CMASS2 = SQRT((1.D0-ZFRAC)*CMASS2
     &              +SIGN(PHEP(5,IQ2)**2,PHEP(5,IQ2)))
      CALL PHO_SEAFLA(IG,K,I,MIN(CMASS1,CMASS2))

      IF(ABS(IDHEP(IQ1)).GT.6) THEN
        K = SIGN(ABS(K),IDHEP(IQ1))
      ELSE
        K = -SIGN(ABS(K),IDHEP(IQ1))
      ENDIF
C  colors
      IF(K.GT.0) THEN
        IC1 = MAX(ICOLOR(1,IG),ICOLOR(2,IG))
        IC2 = MIN(ICOLOR(1,IG),ICOLOR(2,IG))
      ELSE
        IC1 = MIN(ICOLOR(1,IG),ICOLOR(2,IG))
        IC2 = MAX(ICOLOR(1,IG),ICOLOR(2,IG))
      ENDIF
C  register new partons
      CALL PHO_REGPAR(-1,K,0,IG,0,P1(1),P1(2),P1(3),P1(4),
     &            IPHIST(1,IG),0,IC1,0,IPOS,1)
      CALL PHO_REGPAR(-1,-K,0,IG,0,P2(1),P2(2),P2(3),P2(4),
     &            IPHIST(1,IG),0,IC2,0,IPOS,1)
C  debug output
      IF(IDEB(73).GE.20) THEN
          WRITE(ErrorOut,'(1X,A,/1X,A,3I3,5E10.3)')
     &      'PHO_GLU2QU:','   IG,IQ1,IQ2,ZMIN1,2,Z,P1*PG,P2*PG',
     &      IG,IQ1,IQ2,ZMIN1,ZMIN2,ZFRAC,CMASS1,CMASS2
        WRITE(ErrorOut,'(1X,A,4I5)') '   flavours, colors  ',
     &    K,-K,IC1,IC2
      ENDIF
      END


CDECK  ID>, PHO_GLUSPL
      DOUBLE PRECISION FUNCTION PHO_GLUSPL(ZMIN)
C*********************************************************************
C
C     calculate quark - antiquark light cone momentum fractions
C     according to Altarelli-Parisi g->q aq splitting function
C     (symmetric z interval assumed)
C
C     input: ZMIN    minimal Z value allowed,
C                    1-ZMIN maximal Z value allowed
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( ALEXP= 0.3333333333D0,
     &            DEPS = 1.D-10 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD


      IF(ZMIN.GE.0.5D0) THEN
        IF(IDEB(69).GT.2) THEN
          WRITE(ErrorOut,
     * '(1X,A,E12.4)') 'PHO_GLUSPL: ZMIN>=0.5',ZMIN
        ENDIF
        ZZ=0.D0
        GOTO 1000
      ELSE IF(ZMIN.LE.0.D0) THEN
        IF(IDEB(69).GT.2) THEN
          WRITE(ErrorOut,
     * '(1X,A,E12.4)') 'PHO_GLUSPL: ZMIN<=0',ZMIN
        ENDIF
        ZMINL = DEPS
      ELSE
        ZMINL = ZMIN
      ENDIF

      ZMAX = 1.D0-ZMINL
      XI   = PHO_RNDM(ZMAX)
      ZZ   = ((1.D0-XI)*ZMINL**3+XI*ZMAX**3)**ALEXP
      IF(PHO_RNDM(ZZ).LT.0.5D0) ZZ = 1.D0-ZZ

 1000 CONTINUE
      IF(IDEB(69).GE.10) THEN
        WRITE(ErrorOut,
     * '(1X,A,2E12.4)') 'PHO_GLUSPL: ZMIN,Z ',ZMIN,ZZ
      ENDIF
      PHO_GLUSPL = ZZ
      END


CDECK  ID>, PHO_STDPAR
      SUBROUTINE PHO_STDPAR(IJM1,IJM2,IGEN,MSPOM,MSREG,MHPOM,MHDIR,IREJ)
C***********************************************************************
C
C     select the initial parton x-fractions and flavors and
C     the final parton momenta and flavours
C     for standard Pomeron/Reggeon cuts
C
C     input:   IJM1   index of mother particle 1 in /POEVT1/
C              IJM2   index of mother particle 2 in /POEVT1/
C              IGEN   production process of mother particles
C              MSPOM  soft cut Pomerons
C              MHPOM  hard or semihard cut Pomerons
C              MSREG  soft cut Reggeons
C              MHDIR  direct hard processes
C
C              IJM1   -1    initialization of statistics
C                     -2    output of statistics
C
C     output:  partons are directly written to /POEVT1/,/POEVT2/
C
C          structure of /POSOFT/
C               XS1(I),XS2(I):     x-values of initial partons
C               IJSI1(I),IJSI2(I): flavor of initial parton
C                                  0            gluon
C                                  1,2,3,4      quarks
C                                  negative     antiquarks
C               IJSF1(I),IJSF2(I): flavor of final state partons
C               PSOFT1(I,J),PSOFT2(I,J): final part. momentum and energy
C                                J=1   PX
C                                 =2   PY
C                                 =3   PZ
C                                 =4   ENERGY
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER (RHOMAS =  0.766D0,
     &           DEPS   =  1.D-10,
     &           TINY   =  1.D-10)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF

C  particles created by initial state evolution
      INTEGER MXISR1,MXISR2
      PARAMETER ( MXISR1 = 150, MXISR2 = 50 )
      INTEGER IFLISR,IPOISR,IMXISR
      DOUBLE PRECISION PHISR
      COMMON /POPISR/ IFLISR(2,MXISR1),PHISR(2,4,MXISR1),
     &                IPOISR(2,2,MXISR2),IMXISR(2)

C  light-cone x fractions and c.m. momenta of soft cut string ends
      INTEGER MAXSOF
      PARAMETER ( MAXSOF = 50 )
      INTEGER IJSI2,IJSI1
      DOUBLE PRECISION XS1,XS2,PSOFT1,PSOFT2
      COMMON /POSOFT/ XS1(MAXSOF),XS2(MAXSOF),
     &                PSOFT1(4,MAXSOF),PSOFT2(4,MAXSOF),
     &                IJSI1(MAXSOF),IJSI2(MAXSOF)

C  table of particle indices for recursive PHOJET calls
      INTEGER MAXIPX
      PARAMETER ( MAXIPX = 100 )
      INTEGER IPOPOS,IPORES,IPOIX1,IPOIX2,IPOIX3
      COMMON /PORECU/ IPOPOS(2,MAXIPX),IPORES(MAXIPX),
     &                IPOIX1,IPOIX2,IPOIX3

C  hard scattering data
      INTEGER MSCAHD
      PARAMETER ( MSCAHD = 50 )
      INTEGER LSCAHD,LSC1HD,LSIDX,
     &        NINHD,N0INHD,NIVAL,N0IVAL,NOUTHD,NBRAHD,NPROHD
      DOUBLE PRECISION PPH,PTHD,ETAHD,Q2SCA,PDFVA,XHD,VHD,X0HD
      COMMON /POHSLT/ LSCAHD,LSC1HD,LSIDX(MSCAHD),
     &                PPH(8*MSCAHD,2),PTHD(MSCAHD),ETAHD(MSCAHD,2),
     &                Q2SCA(MSCAHD,2),PDFVA(MSCAHD,2),
     &                XHD(MSCAHD,2),VHD(MSCAHD),X0HD(MSCAHD,2),
     &                NINHD(MSCAHD,2),N0INHD(MSCAHD,2),
     &                NIVAL(MSCAHD,2),N0IVAL(MSCAHD,2),
     &                NOUTHD(MSCAHD,2),NBRAHD(MSCAHD,2),NPROHD(MSCAHD)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  internal cross check information on hard scattering limits
      DOUBLE PRECISION ETAMI,ETAMA,XXMI,XXMA
      COMMON /POHLIM/ ETAMI(2,15),ETAMA(2,15),XXMI(2,15),XXMA(2,15)

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)


      DOUBLE PRECISION PHO_ALPHAS



      DIMENSION PC(4),IFLA(2),ICI(2,2)

      IF(IJM1.EQ.-1) THEN
        DO 116 I=1,15
          ETAMI(1,I) = 1.D10
          ETAMA(1,I) = -1.D10
          ETAMI(2,I) = 1.D10
          ETAMA(2,I) = -1.D10
          XXMI(1,I) = 1.D0
          XXMA(1,I) = 0.D0
          XXMI(2,I) = 1.D0
          XXMA(2,I) = 0.D0
 116    CONTINUE
        CALL PHO_HARSCA(IJM1,1)
        CALL PHO_HARCOL(IJM1,0.D0,0,0,0,0,0,0,0,0,0,0,0,0)



        RETURN

      ELSE IF(IJM1.EQ.-2) THEN

C  output internal statistics
        IF(IDEB(23).GE.1) THEN
          WRITE(ErrorOut,'(/1X,A)')
     &      'KINEMATIC LIMITS PARTICLE C (ETAMIN,ETAMAX,XMIN,XMAX)'
          DO 117 I=1,15
            WRITE(ErrorOut,'(5X,I3,4E13.5)')
     &        I,ETAMI(1,I),ETAMA(1,I),XXMI(1,I),XXMA(1,I)
 117      CONTINUE
          WRITE(ErrorOut,'(1X,A)')
     &      'KINEMATIC LIMITS PARTICLE D (ETAMIN,ETAMAX,XMIN,XMAX)'
          DO 118 I=1,15
            WRITE(ErrorOut,'(5X,I3,4E13.5)')
     &        I,ETAMI(2,I),ETAMA(2,I),XXMI(2,I),XXMA(2,I)
 118      CONTINUE
        ENDIF
        CALL PHO_HARSCA(IJM1,1)
        CALL PHO_HARCOL(IJM1,0.D0,0,0,0,0,0,0,0,0,0,0,0,0)



        RETURN
      ENDIF

      IREJ   = 0
C  debug output
      IF(IDEB(23).GT.5) WRITE(ErrorOut,
     * 221) IJM1,IJM2,MSPOM,MHPOM,MSREG,MHDIR
  221 FORMAT (' PHO_STDPAR: JM1/2,MSPOM,MHPOM,MSREG,MHDIR ',6I5)

C  get mother data (exchange if first particle is a pomeron)
      IF((IDHEP(IJM1).EQ.990).AND.(IFPAP(1).NE.990)) THEN
        JM1 = IJM2
        JM2 = IJM1
      ELSE
        JM1 = IJM1
        JM2 = IJM2
      ENDIF

      NPOSP(1) = JM1
      NPOSP(2) = JM2
      IDPDG1 = IDHEP(JM1)
      IDBAM1 = IMPART(JM1)
      IDPDG2 = IDHEP(JM2)
      IDBAM2 = IMPART(JM2)

C  store current status of /POEVT1/
      KHPOMS = KHPOM
      KSPOMS = KSPOM
      KSREGS = KSREG
      KHDIRS = KHDIR
      NHEPS  = NHEP
      IPOIS1 = IPOIX1
      IPOIS2 = IPOIX2

C  get nominal masses (photons: VDM assumption)
      DELMAS = 0.D0
      IF(IDHEP(JM1).EQ.22) THEN
        PMASSP(1) = RHOMAS+DELMAS
        PVIRTP(1) = PHEP(5,JM1)**2
      ELSE
        PMASSP(1) = PHO_PMASS(IDBAM1,0)+DELMAS
        PVIRTP(1) = 0.D0
      ENDIF
      IF(IDHEP(JM2).EQ.22) THEN
        PMASSP(2) = RHOMAS+DELMAS
        PVIRTP(2) = PHEP(5,JM2)**2
      ELSE
        PMASSP(2) = PHO_PMASS(IDBAM2,0)+DELMAS
        PVIRTP(2) = 0.D0
      ENDIF

C  calculate c.m. energy and check kinematics
      PC(1) = PHEP(1,JM1)+PHEP(1,JM2)
      PC(2) = PHEP(2,JM1)+PHEP(2,JM2)
      PC(3) = PHEP(3,JM1)+PHEP(3,JM2)
      PC(4) = PHEP(4,JM1)+PHEP(4,JM2)
      SS = (PC(4)+PC(3))*(PC(4)-PC(3))-PC(1)**2-PC(2)**2

      IF(SS.LE.(PMASSP(1)+PMASSP(2)+DEPS)**2) THEN
        WRITE(ErrorOut,'(/,1X,2A)') 'PHO_STDPAR: ',
     &    'ENERGY SMALLER THAN TWO-PARTICLE THRESHOLD (EVENT REJECTED)'
        CALL PHO_PREVNT(1)
        IREJ = 5
        GOTO 150
      ENDIF
      ECMP = SQRT(SS)

      IF(IDEB(23).GE.5) THEN
        WRITE(ErrorOut,'(1X,2A,2I7,E12.4)') 'PHO_STDPAR: ',
     &    'PARTICLES, AVAILABLE ENERGY:',IDHEP(JM1),IDHEP(JM2),ECMP
        IF(IDEB(23).GE.25) CALL PHO_PREVNT(0)
      ENDIF

C  Lorentz transformation into c.m. system
      DO 10 I=1,4
        GAMBEP(I) = PC(I)/ECMP
 10   CONTINUE
      CALL PHO_ALTRA(GAMBEP(4),-GAMBEP(1),-GAMBEP(2),-GAMBEP(3),
     &           PHEP(1,JM1),PHEP(2,JM1),PHEP(3,JM1),
     &           PHEP(4,JM1),PTOT1,PC(1),PC(2),PC(3),PC(4))
C  rotation angle: particle 1 moves along +z
      CODP = PC(3)/PTOT1
      SIDP = SQRT(PC(1)**2+PC(2)**2)/PTOT1
      COFP = 1.D0
      SIFP = 0.D0
      IF(PTOT1*SIDP.GT.1.D-5) THEN
        COFP = PC(1)/(SIDP*PTOT1)
        SIFP = PC(2)/(SIDP*PTOT1)
        ANORF = SQRT(COFP*COFP+SIFP*SIFP)
        COFP = COFP/ANORF
        SIFP = SIFP/ANORF
      ENDIF
C  get CM momentum
      XM12 = PMASSP(1)**2
      XM22 = PMASSP(2)**2
      PCMP = PHO_XLAM(SS,XM12,XM22)/(2.D0*ECMP)

C  find particle combination
      II = 0
      IF(IDPDG2.EQ.IFPAP(2)) THEN
        IF(IDPDG1.EQ.IFPAP(1)) II = 1
      ELSE IF(IDPDG2.EQ.990) THEN
        IF(IDPDG1.EQ.IFPAP(1)) THEN
          II = 2
        ELSE IF(IDPDG1.EQ.IFPAP(2)) THEN
          II = 3
        ELSE IF(IDPDG1.EQ.990) THEN
          II = 4
        ENDIF
      ENDIF
      IF(II.EQ.0) THEN
        IF(ISWMDL(14).GT.0) THEN
          II = 1
        ELSE
          WRITE(ErrorOut,'(/1X,2A,2I8)') 'PHO_STDPAR:ERROR: ',
     &      'INVALID PARTICLE COMBINATION:',IDPDG1,IDPDG2
          CALL PHO_ABORT
        ENDIF
      ENDIF

C  select parton distribution functions from tables
      IF((MHPOM+MHDIR).GT.0) THEN
        CALL PHO_ACTPDF(IDPDG1,1)
        CALL PHO_ACTPDF(IDPDG2,2)
C  initialize alpha_s calculation
        DUMMY = PHO_ALPHAS(0.D0,-4)
      ENDIF

C  interpolate hard cross sections and rejection weights
      CALL PHO_HARINT(II,ECMP,PVIRTP(1),PVIRTP(2),
     &            -1,MAX_PRO_2,1,4,MSPOM+MHPOM+MHDIR)

      NTRY   = 10

C  position of first particle added to /POEVT2/
      NLOR1 = NHEP+1

C  ---------------- direct processes -----------------

      IF(MHDIR.EQ.1) THEN
        CALL PHO_HARDIR(II,IVAL1,IVAL2,MSPAR1,MSPAR2,MHPAR1,MHPAR2,IREJ)
        IF(IREJ.EQ.50) RETURN
        IF(IREJ.NE.0) GOTO 150
C  write comments to /POEVT1/
        CALL PHO_REGPAR(25,II,NPROHD(1),IDPDG1,IDPDG2,X0HD(1,1),
     &    X0HD(1,2),PTHD(1),VHD(1),N0INHD(1,1),N0INHD(1,2),
     &    IPHO_CNV1(NOUTHD(1,1)),IPHO_CNV1(NOUTHD(1,2)),IPOS,1)
        CALL PHO_REGPAR(20,IPHO_CNV1(N0INHD(1,1)),IPDF1,JM1,JM2,
     &    PPH(1,1),PPH(2,1),PPH(3,1),Q2SCA(1,1),100,NBRAHD(1,1),
     &    ICA1,ICA2,IPOS,1)
        CALL PHO_REGPAR(20,IPHO_CNV1(N0INHD(1,2)),IPDF2,JM2,JM1,
     &    PPH(1,2),PPH(2,2),PPH(3,2),Q2SCA(1,2),100,NBRAHD(1,2),
     &    ICA1,ICA2,IPOS,1)
        CALL PHO_REGPAR(21,NOUTHD(1,1),IPDF1,JM1,JM2,PPH(5,1),
     &    PPH(6,1),PPH(7,1),PPH(8,1),100,NBRAHD(1,1),ICA1,ICA2,
     &    IPOS1,1)
        CALL PHO_REGPAR(21,NOUTHD(1,2),IPDF2,JM2,JM1,PPH(5,2),
     &    PPH(6,2),PPH(7,2),PPH(8,2),100,NBRAHD(1,2),ICA1,ICA2,
     &    IPOS2,1)

C  soft spectator partons
        ICA1  = 0
        ICA2  = 0
        ICB1  = 0
        ICB2  = 0
        IPDF1 = 0
        IPDF2 = 0

C  single resolved: QCD compton scattering
C ------------------------------
        IF(NPROHD(1).EQ.10) THEN
C  register hadron remnant
          CALL PHO_HARREM(JM2,JM1,IGEN,-1,IVAL2,1,ICB1,ICB2,IUSED,IREJ)
          IPDF2 = 1000*IGRP(2)+ISET(2)
        ELSE IF(NPROHD(1).EQ.12) THEN
C  register hadron remnant
          CALL PHO_HARREM(JM1,JM2,IGEN,1,IVAL1,1,ICA1,ICA2,IUSED,IREJ)
          IPDF1 = 1000*IGRP(1)+ISET(1)

C  single resolved: photon gluon fusion
C ---------------------------
        ELSE IF(NPROHD(1).EQ.11) THEN
C  register hadron remnant
          CALL PHO_HARREM(JM2,JM1,IGEN,-1,IVAL2,1,ICB1,ICB2,IUSED,IREJ)
          IPDF2 = 1000*IGRP(2)+ISET(2)
        ELSE IF(NPROHD(1).EQ.13) THEN
C  register hadron remnant
          CALL PHO_HARREM(JM1,JM2,IGEN,1,IVAL1,1,ICA1,ICA2,IUSED,IREJ)
          IPDF1 = 1000*IGRP(1)+ISET(1)

C  direct process (no remnant)
C ----------------------------
        ELSE IF(NPROHD(1).EQ.14) THEN

        ENDIF

C  write final high-pt partons to POEVT1
        IF((ISWMDL(8).GE.2).AND.(NPROHD(1).NE.14)) THEN
          ICI(1,1) = ICA1
          ICI(1,2) = ICA2
          ICI(2,1) = ICB1
          ICI(2,2) = ICB2
          I = 1
          IFLA(1) = NINHD(I,1)
          IFLA(2) = NINHD(I,2)
C  initial state radiation
          DO 130 K=1,2
            DO 135 IPA=IPOISR(K,2,I),IPOISR(K,1,I)+1,-1
              KK = 1
 137          CONTINUE
              IFLB = IFLISR(K,IPA)
              IF(ABS(IFLB).LE.6) THEN
C  partons
                IF(ICI(K,1)*ICI(K,2).NE.0) THEN
                  IF(IFLB.EQ.0) THEN
                    CALL PHO_SELCOL(ICI(K,1),ICI(K,2),IC1,IC2,
     &                ICI(K,1),ICI(K,2),3)
                  ELSE IF(IFLB.GT.0) THEN
                    CALL PHO_SELCOL(ICI(K,1),ICI(K,2),IC1,IC2,
     &                ICI(K,1),ICI(K,2),4)
                  ELSE
                    CALL PHO_SELCOL(ICI(K,1),ICI(K,2),ICI(K,1),ICI(K,2),
     &                IC1,IC2,4)
                  ENDIF
                ELSE
                  IF((ICI(K,1)+ICI(K,2))*IFLB.LT.0) THEN
                    IF(IPA-KK.GT.IPOISR(K,1,I)) THEN
                      CALL PHO_SWAPI(IFLISR(K,IPA),IFLISR(K,IPA-KK))
                      KK = KK+1
                      GOTO 137
                    ENDIF
                  ENDIF
                  IF(IFLB.EQ.0) THEN
                    CALL PHO_SELCOL(ICI(K,1),ICI(K,2),ICI(K,1),ICI(K,2),
     &                IC1,IC2,2)
                  ELSE
                    CALL PHO_SELCOL(ICI(K,1),ICI(K,2),IC1,IC2,
     &                ICI(K,1),ICI(K,2),2)
                  ENDIF
                ENDIF
                IIFL = IPHO_CNV1(IFLB)

                IFLA(K) = IFLA(K)-IFLB
                IST = -1
              ELSE
C  other particle
                IIFL = IFLB
                IC1 = 0
                IC2 = 0
                IST = 1
              ENDIF
              CALL PHO_REGPAR(IST,IIFL,0,JM1,JM2,PHISR(K,1,IPA),
     &          PHISR(K,2,IPA),PHISR(K,3,IPA),PHISR(K,4,IPA),I*100+K,
     &          IGEN,IC1,IC2,IPOS,1)
 135        CONTINUE
 130      CONTINUE
          ICOLOR(1,IPOS1-2) = ICI(1,1)
          ICOLOR(2,IPOS1-2) = ICI(1,2)
          ICOLOR(1,IPOS1-1) = ICI(2,1)
          ICOLOR(2,IPOS1-1) = ICI(2,2)
          CALL PHO_HARCOL(NPROHD(I),VHD(I),IFLA(1),ICI(1,1),ICI(1,2),
     &      IFLA(2),ICI(2,1),ICI(2,2),NOUTHD(I,1),ICI(1,1),ICI(1,2),
     &      NOUTHD(I,2),ICI(2,1),ICI(2,2))
          ICOLOR(1,IPOS1) = ICI(1,1)
          ICOLOR(2,IPOS1) = ICI(1,2)
          ICOLOR(1,IPOS2) = ICI(2,1)
          ICOLOR(2,IPOS2) = ICI(2,2)
          DO 140 K=1,2
            IPA = IPOISR(K,1,I)
            CALL PHO_REGPAR(-1,IPHO_CNV1(IFLISR(K,IPA)),0,JM1,JM2,
     &        PHISR(K,1,IPA),PHISR(K,2,IPA),PHISR(K,3,IPA),
     &        PHISR(K,4,IPA),-I*100,IGEN,ICI(K,1),ICI(K,2),IPOS,1)
 140      CONTINUE
        ELSE
          ICOLOR(1,IPOS1-2) = ICA1
          ICOLOR(2,IPOS1-2) = ICA2
          ICOLOR(1,IPOS1-1) = ICB1
          ICOLOR(2,IPOS1-1) = ICB2
          CALL PHO_HARCOL(NPROHD(1),VHD(1),NINHD(1,1),ICA1,ICA2,
     &      NINHD(1,2),ICB1,ICB2,NOUTHD(1,1),ICA1,ICA2,
     &      NOUTHD(1,2),ICB1,ICB2)
          ICOLOR(1,IPOS1) = ICA1
          ICOLOR(2,IPOS1) = ICA2
          ICOLOR(1,IPOS2) = ICB1
          ICOLOR(2,IPOS2) = ICB2
          I = -1
          IF(ABS(NOUTHD(1,1)).GT.12) I = 1
          CALL PHO_REGPAR(I,IPHO_CNV1(NOUTHD(1,1)),0,JM1,JM2,PPH(5,1),
     &      PPH(6,1),PPH(7,1),PPH(8,1),-100,IGEN,ICA1,ICA2,IPOS,1)
          CALL PHO_REGPAR(I,IPHO_CNV1(NOUTHD(1,2)),0,JM1,JM2,PPH(5,2),
     &      PPH(6,2),PPH(7,2),PPH(8,2),-100,IGEN,ICB1,ICB2,IPOS,1)
        ENDIF

C  assign soft pt to spectators
        IF(ISWMDL(18).EQ.0) THEN
          IPOS2 = IPOS2-1
          CALL PHO_PARTPT(0,NLOR1,IPOS2,PTCUT(II),IREJ)
          IF(IREJ.NE.0) THEN
            IFAIL(26) = IFAIL(26) + 1
            GOTO 150
          ENDIF

        ENDIF

C  ----------------- resolved processes -------------------

C  single Reggeon exchange
C ----------------------------
      ELSE IF((MSREG.EQ.1).AND.(MHPOM+MSPOM.EQ.0)) THEN
C  flavours
        CALL PHO_REGFLA(JM1,JM2,IFL1,IFL2,IREJ)
        IF(IREJ.NE.0) THEN
          IFAIL(24) = IFAIL(24)+1
          GOTO 150
        ENDIF

C  colors
        CALL PHO_SELCOL(0,0,ICA1,ICA2,ICB1,ICB2,1)
        IF(((ABS(IFL1).GT.6).AND.(IFL1.GT.0))
     &     .OR.((ABS(IFL1).LE.6).AND.(IFL1.LT.0))) THEN
          CALL PHO_SWAPI(ICA1,ICB1)
        ENDIF
        ECMH = ECMP/2.D0

C  registration

C  DTUNUC call with special projectile / target
	IF((IPAMDL(13).GT.0).AND.(IPOIX3.EQ.0).AND.(IPROCE.EQ.1)) THEN
          CALL PHO_REGPAR(-1,IFL1,0,JM1,JM2,0.D0,0.D0,ECMH*XPSUB,
     &               ECMH*XPSUB,-1,IGEN,ICA1,0,IPOS1,1)
          CALL PHO_REGPAR(-1,IFL2,0,JM1,JM2,0.D0,0.D0,-ECMH*XTSUB,
     &               ECMH*XTSUB,-1,IGEN,ICB1,0,IPOS2,1)
C  default treatment
        ELSE
          CALL PHO_REGPAR(-1,IFL1,0,JM1,JM2,0.D0,0.D0,ECMH,ECMH,
     &      -1,IGEN,ICA1,0,IPOS1,1)
          CALL PHO_REGPAR(-1,IFL2,0,JM1,JM2,0.D0,0.D0,-ECMH,ECMH,
     &      -1,IGEN,ICB1,0,IPOS2,1)
        ENDIF

C  soft pt assignment
        IF(ISWMDL(18).EQ.0) THEN
          CALL PHO_PARTPT(0,IPOS1,IPOS2,PTCUT(II),IREJ)
          IF(IREJ.NE.0) THEN
            IFAIL(25) = IFAIL(25) + 1
            GOTO 150
          ENDIF
        ENDIF
C
C  multi Reggeon / Pomeron exchange
C----------------------------------------
      ELSE
C  parton configuration

        CALL PHO_POMSCA(II,MSPOM,MHPOM,MSREG,IVAL1,IVAL2,MSPAR1,MSPAR2,
     &              MHPAR1,MHPAR2,IREJ)

        IF(IREJ.EQ.50) RETURN
        IF(IREJ.NE.0) GOTO 150

C  register particles
        IF(IDEB(23).GE.15) WRITE(ErrorOut,'(1X,A,/15X,7I5)')
     &    'PHO_STDPAR: MSPOM,MHPOM,MSREG,MSPAR1/2,IVAL1/2',
     &    MSPOM,MHPOM,MSREG,MSPAR1,MSPAR2,IVAL1,IVAL2

C  register soft partons
        IF(IVAL1.NE.0) THEN
          IF(IVAL1.LT.0) THEN
            IND1 = 3
            IVAL1=-IVAL1
          ELSE
            IND1 = 2
          ENDIF
        ELSE IF(MSPOM.EQ.0) THEN
          IND1 = 4
        ELSE
          IND1 = 1
        ENDIF
        IF(IVAL2.NE.0) THEN
          IF(IVAL2.LT.0) THEN
            IND2 = 3
            IVAL2=-IVAL2
          ELSE
            IND2 = 2
          ENDIF
        ELSE IF(MSPOM.EQ.0) THEN
          IND2 = 4
        ELSE
          IND2 = 1
        ENDIF

        IF(IDEB(23).GE.20) WRITE(ErrorOut,'(1X,A,2I3,2X,2I3)')
     &    'PHO_STDPAR: IND1/2,IVAL1/2',IND1,IND2,IVAL1,IVAL2

C  soft Pomeron final states
C -----------------------------------
        K = MSPOM+MHPOM+MSREG
        DO 50 I=1,MSPOM

          CALL PHO_POSPOM(II,IND1,IND2,IGEN,I,K,ISWAP,IREJ)
          IF(IREJ.NE.0) THEN
            IFAIL(8) = IFAIL(8) + 1
            GOTO 150
          ENDIF
C
 50     CONTINUE

C  soft Reggeon final states
C -----------------------------------------
        DO 75 I=1,MSREG
C  flavours
          CMASS1 = MIN(PSOFT1(4,IND1),PSOFT2(4,IND2))
          IF(PHO_RNDM(CMASS1).LT.0.5D0) THEN
            CALL PHO_SEAFLA(JM1,IFLA1,IFLB1,CMASS1)
          ELSE
            CALL PHO_SEAFLA(JM2,IFLA1,IFLB1,CMASS1)
          ENDIF

C  colors
          CALL PHO_SELCOL(0,0,ICA1,ICA2,ICB1,ICB2,1)
          IF(((ABS(IFLA1).GT.6).AND.(IFLA1.GT.0))
     &      .OR.((ABS(IFLA1).LE.6).AND.(IFLA1.LT.0)))
     &      CALL PHO_SWAPI(ICA1,ICB1)
C  registration
          CALL PHO_REGPAR(-1,IFLA1,0,JM1,JM2,PSOFT1(1,IND1),
     &      PSOFT1(2,IND1),PSOFT1(3,IND1),PSOFT1(4,IND1),
     &      I,IGEN,ICA1,ICA2,IPOS1,1)
          IND1 = IND1+1
          CALL PHO_REGPAR(-1,IFLB1,0,JM2,JM1,PSOFT2(1,IND2),
     &      PSOFT2(2,IND2),PSOFT2(3,IND2),PSOFT2(4,IND2),
     &      I,IGEN,ICB1,ICB2,IPOS2,1)
          IND2 = IND2+1

          IF(IDEB(23).GE.20) WRITE(ErrorOut,'(1X,A,/15X,6I4)')
     &      'PHO_STDPAR: REG.CUT: IND1,IND2,IFLA,IFLB,IPOS1,IPOS2',
     &      IND1-1,IND2-1,IFLA1,IFLB1,IPOS1,IPOS2

C  soft pt assignment
          IF(ISWMDL(18).EQ.0) THEN
            CALL PHO_PARTPT(0,IPOS1,IPOS2,PTCUT(II),IREJ)
            IF(IREJ.NE.0) THEN
              IFAIL(25) = IFAIL(25) + 1
              GOTO 150
            ENDIF
          ENDIF

 75     CONTINUE

C  hard Pomeron final states
C ------------------------------------
        IND1 = MSPAR1
        IND2 = MSPAR2

        DO 100 L=1,MHPOM
          I = LSIDX(L)

          IFLI1 = IPHO_CNV1(N0INHD(I,1))
          IFLI2 = IPHO_CNV1(N0INHD(I,2))
          IFLO1 = IPHO_CNV1(NOUTHD(I,1))
          IFLO2 = IPHO_CNV1(NOUTHD(I,2))

C  write comments to /POEVT1/
          CALL PHO_REGPAR(25,II,NPROHD(I),IDPDG1,IDPDG2,X0HD(I,1),
     &      X0HD(I,2),PTHD(I),VHD(I),N0INHD(I,1),N0INHD(I,2),
     &      IFLO1,IFLO2,IPOS,1)
          I1 = 8*I-7
          IPDF = 1000*IGRP(1)+ISET(1)
          CALL PHO_REGPAR(20,IFLI1,IPDF,JM1,JM2,PPH(I1,1),
     &      PPH(I1+1,1),PPH(I1+2,1),Q2SCA(I,1),L*100,NBRAHD(I,1),
     &      ICA1,ICA2,IPOS,1)
          IPDF = 1000*IGRP(2)+ISET(2)
          CALL PHO_REGPAR(20,IFLI2,IPDF,JM2,JM1,PPH(I1,2),
     &      PPH(I1+1,2),PPH(I1+2,2),Q2SCA(I,2),L*100,NBRAHD(I,2),
     &      ICB1,ICB2,IPOS,1)
          I1 = 8*I-3
          IPDF = 1000*IGRP(1)+ISET(1)
          CALL PHO_REGPAR(21,IFLO1,IPDF,JM1,JM2,PPH(I1,1),
     &      PPH(I1+1,1),PPH(I1+2,1),PPH(I,1),L*100,NBRAHD(I,1),
     &      ICA1,ICA2,IPOS1,1)
          IPDF = 1000*IGRP(2)+ISET(2)
          CALL PHO_REGPAR(21,IFLO2,IPDF,JM2,JM1,PPH(I1,2),
     &      PPH(I1+1,2),PPH(I1+2,2),PPH(I,2),L*100,NBRAHD(I,2),
     &      ICB1,ICB2,IPOS2,1)

C  spectator partons belonging to hard interaction
          IF(IVAL1.EQ.I) THEN
            IVQ = 1
            IND = 1
          ELSE IF((MSPOM.EQ.0).AND.(L.EQ.1).AND.(IVAL1.EQ.0)) THEN
            IVQ = 0
            IND = 1
          ELSE
            IVQ = -1
            IND = IND1
          ENDIF
          CALL PHO_HARREM(JM1,JM2,IGEN,L,IVQ,IND,ICA1,ICA2,IUSED,IREJ)
          IF(IVQ.LT.0) IND1 = IND1-IUSED
          IF(IVAL2.EQ.I) THEN
            IVQ = 1
            IND = 1
          ELSE IF((MSPOM.EQ.0).AND.(L.EQ.1).AND.(IVAL2.EQ.0)) THEN
            IVQ = 0
            IND = 1
          ELSE
            IVQ = -1
            IND = IND2
          ENDIF
          CALL PHO_HARREM(JM2,JM1,IGEN,-L,IVQ,IND,ICB1,ICB2,IUSED,IREJ)
          IF(IVQ.LT.0) IND2 = IND2-IUSED
C
C  register hard scattered partons
          IF((ISWMDL(8).GE.2)
     &       .AND.((IPAMDL(101).NE.1).OR.(L.EQ.1))) THEN
            ICI(1,1) = ICA1
            ICI(1,2) = ICA2
            ICI(2,1) = ICB1
            ICI(2,2) = ICB2
            IFLA(1) = NINHD(I,1)
            IFLA(2) = NINHD(I,2)
C  initial state radiation
            DO 230 K=1,2
              DO 235 IPA=IPOISR(K,2,I),IPOISR(K,1,I)+1,-1
                KK = 1
 237            CONTINUE
                IFLB = IFLISR(K,IPA)
                IF(ABS(IFLB).LE.6) THEN
C  partons
                  IF(ICI(K,1)*ICI(K,2).NE.0) THEN
                    IF(IFLB.EQ.0) THEN
                      CALL PHO_SELCOL(ICI(K,1),ICI(K,2),IC1,IC2,
     &                  ICI(K,1),ICI(K,2),3)
                    ELSE IF(IFLB.GT.0) THEN
                      CALL PHO_SELCOL(ICI(K,1),ICI(K,2),IC1,IC2,
     &                  ICI(K,1),ICI(K,2),4)
                    ELSE
                      CALL PHO_SELCOL(ICI(K,1),ICI(K,2),ICI(K,1),
     &                  ICI(K,2),IC1,IC2,4)
                    ENDIF
                  ELSE
                    IF((ICI(K,1)+ICI(K,2))*IFLB.LT.0) THEN
                      IF(IPA-KK.GT.IPOISR(K,1,I)) THEN
                        CALL PHO_SWAPI(IFLISR(K,IPA),IFLISR(K,IPA-KK))
                        KK = KK+1
                        GOTO 237
                      ENDIF
                    ENDIF
                    IF(IFLB.EQ.0) THEN
                      CALL PHO_SELCOL(ICI(K,1),ICI(K,2),ICI(K,1),
     &                  ICI(K,2),IC1,IC2,2)
                    ELSE
                      CALL PHO_SELCOL(ICI(K,1),ICI(K,2),IC1,IC2,
     &                  ICI(K,1),ICI(K,2),2)
                    ENDIF
                  ENDIF
                  IIFL = IPHO_CNV1(IFLB)

                  IFLA(K)  = IFLA(K)-IFLB
                  IST = -1
                ELSE
C  other particles
                  IIFL = IFLB
                  IC1 = 0
                  IC2 = 0
                  IST = 1
                ENDIF
                CALL PHO_REGPAR(IST,IIFL,0,JM1,JM2,PHISR(K,1,IPA),
     &            PHISR(K,2,IPA),PHISR(K,3,IPA),PHISR(K,4,IPA),
     &            L*100+K,IGEN,IC1,IC2,IPOS,1)
 235          CONTINUE
 230        CONTINUE
            ICOLOR(1,IPOS1-2) = ICI(1,1)
            ICOLOR(2,IPOS1-2) = ICI(1,2)
            ICOLOR(1,IPOS1-1) = ICI(2,1)
            ICOLOR(2,IPOS1-1) = ICI(2,2)
            CALL PHO_HARCOL(NPROHD(I),VHD(I),IFLA(1),ICI(1,1),ICI(1,2),
     &        IFLA(2),ICI(2,1),ICI(2,2),NOUTHD(I,1),ICI(1,1),ICI(1,2),
     &        NOUTHD(I,2),ICI(2,1),ICI(2,2))
            ICOLOR(1,IPOS1) = ICI(1,1)
            ICOLOR(2,IPOS1) = ICI(1,2)
            ICOLOR(1,IPOS2) = ICI(2,1)
            ICOLOR(2,IPOS2) = ICI(2,2)
            DO 240 K=1,2
              IPA = IPOISR(K,1,I)
              CALL PHO_REGPAR(-1,IPHO_CNV1(IFLISR(K,IPA)),0,JM1,JM2,
     &          PHISR(K,1,IPA),PHISR(K,2,IPA),PHISR(K,3,IPA),
     &          PHISR(K,4,IPA),-L*100,IGEN,ICI(K,1),ICI(K,2),IPOS,1)
 240        CONTINUE
          ELSE
            ICOLOR(1,IPOS1-2) = ICA1
            ICOLOR(2,IPOS1-2) = ICA2
            ICOLOR(1,IPOS1-1) = ICB1
            ICOLOR(2,IPOS1-1) = ICB2
            CALL PHO_HARCOL(NPROHD(I),VHD(I),NINHD(I,1),ICA1,ICA2,
     &        NINHD(I,2),ICB1,ICB2,NOUTHD(I,1),ICA1,ICA2,
     &        NOUTHD(I,2),ICB1,ICB2)
            ICOLOR(1,IPOS1) = ICA1
            ICOLOR(2,IPOS1) = ICA2
            ICOLOR(1,IPOS2) = ICB1
            ICOLOR(2,IPOS2) = ICB2
            I1 = 8*I-3
            CALL PHO_REGPAR(-1,IPHO_CNV1(NOUTHD(I,1)),0,JM1,JM2,
     &        PPH(I1,1),PPH(I1+1,1),PPH(I1+2,1),PPH(I1+3,1),-L*100,IGEN,
     &        ICA1,ICA2,IPOS,1)
            CALL PHO_REGPAR(-1,IPHO_CNV1(NOUTHD(I,2)),0,JM1,JM2,
     &        PPH(I1,2),PPH(I1+1,2),PPH(I1+2,2),PPH(I1+3,2),-L*100,IGEN,
     &        ICB1,ICB2,IPOS,1)
          ENDIF
 100    CONTINUE
C  end of resolved parton registration
      ENDIF

      IF(MHDIR+MHPOM.GT.0) THEN

        IF(ISWMDL(29).GE.1) THEN
C  primordial kt of hard scattering
          CALL PHO_PRIMKT(1,NLOR1,NHEP,PTCUT(II),IREJ)
          IF(IREJ.NE.0) THEN
            IFAIL(27) = IFAIL(27)+1
            GOTO 150
          ENDIF
        ELSE IF(ISWMDL(24).GE.0) THEN
C  give "soft" pt only to soft (spectator) partons in hard processes
          CALL PHO_PARTPT(1,NLOR1,NHEP,PTCUT(II),IREJ)
          IF(IREJ.NE.0) THEN
            IFAIL(26) = IFAIL(26)+1
            GOTO 150
          ENDIF
        ENDIF

      ENDIF

C  give "soft" pt to partons in soft Pomerons
      IF((MHDIR.EQ.0).AND.(ISWMDL(18).EQ.1)) THEN
        CALL PHO_PARTPT(0,NLOR1,NHEP,PTCUT(II),IREJ)
        IF(IREJ.NE.0) THEN
          IFAIL(25) = IFAIL(25) + 1
          GOTO 150
        ENDIF
      ENDIF

C  boost back to lab frame
      CALL PHO_LTRHEP(NLOR1,NHEP,CODP,SIDP,COFP,SIFP,GAMBEP(4),
     &  GAMBEP(1),GAMBEP(2),GAMBEP(3))
      RETURN

C  rejection treatment
 150  CONTINUE
      IFAIL(2) = IFAIL(2)+1
C  reset counters
      KSPOM = KSPOMS
      KHPOM = KHPOMS
      KHDIR = KHDIRS
      KSREG = KSREGS
C  reset mother-daugther relations
      JDAHEP(1,JM1) = 0
      JDAHEP(2,JM1) = 0
      JDAHEP(1,JM2) = 0
      JDAHEP(2,JM2) = 0
      ISTHEP(JM1) = 1
      ISTHEP(JM2) = 1
      IPOIX1 = IPOIS1
      IPOIX2 = IPOIS2
      NHEP   = NHEPS
C  debug
      IF(IDEB(23).GT.2) WRITE(ErrorOut,'(/1X,A,4I6)')
     &  'PHO_STDPAR: REJECTION (MSPOM,MHPOM,MSREG,MHDIR)',
     &  MSPOM,MHPOM,MSREG,MHDIR
      RETURN

      END





CDECK  ID>, PHO_HARCOL
      SUBROUTINE PHO_HARCOL(MSPR,V,IP1,ICA1,ICA2,IP2,ICB1,ICB2,
     &                  IP3,ICC1,ICC2,IP4,ICD1,ICD2)
C*********************************************************************
C
C     calculate color flow for hard resolved process
C
C     input:    IP1..4  flavour of partons (PDG convention)
C               V       parton subprocess Mandelstam variable  V = t/s
C                       (lightcone momenta assumed)
C               ICA,ICB color labels
C               MSPR    process number
C                       -1   initialization of statistics
C                       -2   output of statistics
C
C     output:   ICC,ICD color label of final partons
C
C     (it is possible to use the same variables for in and output)
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  names of hard scattering processes
      INTEGER MAX_PRO_1
      PARAMETER ( MAX_PRO_1 = 16 )
      CHARACTER*18 PROC
      COMMON /POHPRO/ PROC(0:MAX_PRO_1)


      DIMENSION PC(3),ICONF(8,5),IRECN(8,2)

C  initialization
      IF(MSPR.EQ.-1) THEN
        DO 200 I=1,8
          DO 210 K=1,5
            ICONF(I,K) = 0
 210      CONTINUE
          IRECN(I,1) = 0
          IRECN(I,2) = 0
 200    CONTINUE
        RETURN
C  output of statistics
      ELSE IF(MSPR.EQ.-2) THEN
        IF(IDEB(26).LT.1) RETURN
        WRITE(ErrorOut,'(/1X,A,/1X,A)')
     &    'PHO_HARCOL: SAMPLED COLOR CONFIGURATIONS',
     &    '----------------------------------------'
        WRITE(ErrorOut,'(6X,A,15X,A)')
     &    'DIAGRAM                  COLOR CONFIGURATIONS (1-4)','SUM'
        DO 300 I=1,8
          DO 310 K=1,4
            ICONF(I,5) = ICONF(I,5) + ICONF(I,K)
 310      CONTINUE
          WRITE(ErrorOut,
     * '(2X,A,4I11,I12)') PROC(I),(ICONF(I,K),K=1,5)
 300    CONTINUE
        IF(ISWMDL(11).GE.2) THEN
          WRITE(ErrorOut,'(/6X,A)')
     &      'DIAGRAM             WITH   /   WITHOUT COLOR RE-CONNECTION'
          DO 320 I=1,8
            WRITE(ErrorOut,
     * '(2X,A,2I11)') PROC(I),IRECN(I,1),IRECN(I,2)
 320      CONTINUE
        ENDIF
        RETURN
      ENDIF
C
C  gluons: first color positive, quarks second color zero
      IF(IP1.EQ.0) THEN
        IF(ICA1.LT.0) THEN
          I = ICA2
          ICA2 = ICA1
          ICA1 = I
        ENDIF
      ELSE
        ICA2 = 0
      ENDIF
      IF(IP2.EQ.0) THEN
        IF(ICB1.LT.0) THEN
          I = ICB2
          ICB2 = ICB1
          ICB1 = I
        ENDIF
      ELSE
        ICB2 = 0
      ENDIF
      IC2 = 0
      IC4 = 0
C  debug output
      IF(IDEB(26).GE.15)
     &  WRITE(ErrorOut,'(1X,A,I4,/,5X,A,3I5,2X,3I5)')
     &  'PHO_HARCOL: PROCESS',MSPR,
     &  'INITIAL PARTONS AND COLORS',IP1,ICA1,ICA2,IP2,ICB1,ICB2
C
      IRC = 0
      IF(IPAMDL(21).EQ.1) THEN
C
C  soft color re-connection option
C
        IF(MSPR.EQ.1) THEN
C  hard g g final state, only g g --> g g
          IF((ICA1.NE.-ICA2).AND.(ICB1.NE.-ICB2)) THEN
            IF(PHO_RNDM(V).LT.PARMDL(140)) THEN
              IC1 = ICA1
              IC2 = ICA2
              IC3 = ICB1
              IC4 = ICB2
              IRECN(MSPR,1) = IRECN(MSPR,1)+1
              IRC = 1
              GOTO 100
            ENDIF
          ENDIF
        ELSE IF(MSPR.EQ.3) THEN
C  hard q g final state
          IF((ICA1.NE.-ICA2).AND.(ICB1.NE.-ICB2)) THEN
            IF(PHO_RNDM(V).LT.PARMDL(141)) THEN
              IC1 = ICA1
              IC2 = ICA2
              IC3 = ICB1
              IC4 = ICB2
              IRECN(MSPR,1) = IRECN(MSPR,1)+1
              IRC = 1
              GOTO 100
            ENDIF
          ENDIF
        ELSE IF((MSPR.EQ.5).OR.(MSPR.EQ.7).OR.(MSPR.EQ.8)) THEN
C  hard q q final state
          IF(ICA1.NE.-ICB1) THEN
            IF(PHO_RNDM(V).LT.PARMDL(142)) THEN
              IC1 = ICA1
              IC2 = ICA2
              IC3 = ICB1
              IC4 = ICB2
              IRECN(MSPR,1) = IRECN(MSPR,1)+1
              IRC = 1
              GOTO 100
            ENDIF
          ENDIF
        ENDIF
        IRECN(MSPR,2) = IRECN(MSPR,2)+1
      ENDIF
C
      IF((ISWMDL(11).EQ.1).AND.(MSPR.LT.10)) THEN
C
C  large Nc limit of all graphs
C
        IF(MSPR.EQ.1) THEN
C  g g --> g g
          IF(PHO_RNDM(V).GT.0.5D0) THEN
            IC1 = ICB1
            IC2 = ICA2
            IC3 = ICA1
            IC4 = ICB2
            ICONF(MSPR,1) = ICONF(MSPR,1)+1
          ELSE
            IC1 = ICA1
            IC2 = ICB2
            IC3 = ICB1
            IC4 = ICA2
            ICONF(MSPR,2) = ICONF(MSPR,2)+1
          ENDIF
        ELSE IF(MSPR.EQ.2) THEN
C  q qb --> g g
          CALL PHO_SELCOL(0,0,I1,K1,I2,K2,1)
          IF(ICA1.LT.0) THEN
            IC1 = I1
            IC2 = ICA1
            IC3 = ICB1
            IC4 = I2
            ICONF(MSPR,2) = ICONF(MSPR,2)+1
          ELSE
            IC1 = ICA1
            IC2 = I2
            IC3 = I1
            IC4 = ICB1
            ICONF(MSPR,1) = ICONF(MSPR,1)+1
          ENDIF
        ELSE IF(MSPR.EQ.3) THEN
C  q g --> q g
          IF(PHO_RNDM(V).LT.0.5D0) THEN
            IF(IP1+IP2.GT.0) THEN
              IC1 = ICB1
              IC2 = ICA2
              IC3 = ICA1
              IC4 = ICB2
            ELSE IF(IP1.LT.0) THEN
              IC1 = ICB2
              IC3 = ICB1
              IC4 = ICA1
            ELSE
              IC1 = ICA1
              IC2 = ICB1
              IC3 = ICA2
            ENDIF
            ICONF(MSPR,1) = ICONF(MSPR,1)+1
          ELSE
            IF(IP1.GT.0) THEN
              CALL PHO_HARCOR(-ICA1,ICB2)
              IC1 = ICA1
              IC3 = ICB1
              IC4 = -ICA1
            ELSE IF(IP2.GT.0) THEN
              CALL PHO_HARCOR(-ICB1,ICA2)
              IC1 = ICA1
              IC2 = -ICB1
              IC3 = ICB1
            ELSE IF(IP1.LT.0) THEN
              CALL PHO_HARCOR(-ICA1,ICB1)
              IC1 = ICA1
              IC3 = -ICA1
              IC4 = ICB2
            ELSE IF(IP2.LT.0) THEN
              CALL PHO_HARCOR(-ICB1,ICA1)
              IC1 = -ICB1
              IC2 = ICA2
              IC3 = ICB1
            ENDIF
            ICONF(MSPR,2) = ICONF(MSPR,2)+1
          ENDIF
        ELSE IF(MSPR.EQ.4) THEN
C  g g --> q qb
          IC1 = ICA1
          IC3 = ICB2
          CALL PHO_HARCOR(-ICB1,ICA2)
          IF(ICB2.EQ.-ICB1) IC3 = ICA2
          IF(IP3*IC1.LT.0) THEN
            I = IC1
            IC1 = IC3
            IC3 = I
          ENDIF
          ICONF(MSPR,2) = ICONF(MSPR,2)+1
        ELSE IF(MSPR.EQ.5) THEN
C  q qb --> q qb
          IF(PHO_RNDM(V).LT.0.5D0) THEN
            IF(ICA1*IP3.LT.0) THEN
              IC1 = ICB1
              IC3 = ICA1
            ELSE
              IC1 = ICA1
              IC3 = ICB1
            ENDIF
            ICONF(MSPR,1) = ICONF(MSPR,1)+1
          ELSE
            IF(ICA1*IP3.LT.0) THEN
              IC1 = -ICA1
              IC3 = ICA1
            ELSE
              IC1 = ICA1
              IC3 = -ICA1
            ENDIF
            CALL PHO_HARCOR(-ICA1,ICB1)
            ICONF(MSPR,2) = ICONF(MSPR,2)+1
          ENDIF
        ELSE IF(MSPR.EQ.6) THEN
C  q qb --> qp qbp
          IF(ICA1*IP3.LT.0) THEN
            IC1 = ICB1
            IC3 = ICA1
            ICONF(MSPR,1) = ICONF(MSPR,1)+1
          ELSE
            IC1 = ICA1
            IC3 = ICB1
            ICONF(MSPR,2) = ICONF(MSPR,2)+1
          ENDIF
        ELSE IF(MSPR.EQ.7) THEN
C  q q --> q q
          IF(PHO_RNDM(V).LT.0.5D0) THEN
            IC1 = ICA1
            IC3 = ICB1
            ICONF(MSPR,1) = ICONF(MSPR,1)+1
          ELSE
            IC1 = ICB1
            IC3 = ICA1
            ICONF(MSPR,2) = ICONF(MSPR,2)+1
          ENDIF
        ELSE IF(MSPR.EQ.8) THEN
C  q qp --> q qp
          IF(IP1*IP2.GT.0) THEN
            IF(IP3.EQ.IP1) THEN
              IC1 = ICB1
              IC3 = ICA1
            ELSE
              IC1 = ICA1
              IC3 = ICB1
            ENDIF
            ICONF(MSPR,1) = ICONF(MSPR,1)+1
          ELSE
            IF(ICA1*IP3.LT.0) THEN
              IC1 = -ICA1
              IC3 = ICA1
            ELSE
              IC1 = ICA1
              IC3 = -ICA1
            ENDIF
            CALL PHO_HARCOR(-ICA1,ICB1)
            ICONF(MSPR,2) = ICONF(MSPR,2)+1
          ENDIF
        ELSE
C  unknown process
          WRITE(ErrorOut,'(/1X,A,I3)')
     &      'PHO_HARCOL:ERROR:INVALID PROCESS NUMBER (MSPR)',MSPR
          CALL PHO_ABORT
        ENDIF
C
      ELSE
C
C  color flow according to QCD leading order matrix element
C
        U = -(1.D0+V)
        IF(MSPR.EQ.1) THEN
C  g g --> g g
          PC(1) = 1/V**2  +2.D0/V    +3.D0  +2.D0*V    +V**2
          PC(2) = 1/U**2  +2.D0/U    +3.D0  +2.D0*U    +U**2
          PC(3) = (V/U)**2+2.D0*(V/U)+3.D0  +2.D0*(U/V)+(U/V)**2
          XI = (PC(1)+PC(2)+PC(3))*PHO_RNDM(U)
          PCS = 0.D0
          DO 110 I=1,3
            PCS = PCS+PC(I)
            IF(XI.LT.PCS) GOTO 120
 110      CONTINUE
 120      CONTINUE
          IF(I.EQ.1) THEN
            CALL PHO_SELCOL(0,0,I1,K1,I2,K2,1)
            IF(PHO_RNDM(V).GT.0.5D0) THEN
              IC1 = I1
              IC2 = ICA2
              IC3 = ICB1
              IC4 = I2
              CALL PHO_HARCOR(-ICB2,ICA1)
              IF(ICB1.EQ.-ICB2) IC3 = ICA1
            ELSE
              IC1 = ICA1
              IC2 = I2
              IC3 = I1
              IC4 = ICB2
              CALL PHO_HARCOR(-ICB1,ICA2)
              IF(ICB2.EQ.-ICB1) IC4 = ICA2
            ENDIF
          ELSE IF(I.EQ.2) THEN
            CALL PHO_SELCOL(0,0,I1,K1,I2,K2,1)
            IF(PHO_RNDM(U).GT.0.5D0) THEN
              IC1 = ICB1
              IC2 = I2
              IC3 = I1
              IC4 = ICA2
              CALL PHO_HARCOR(-ICB2,ICA1)
              IF(ICB1.EQ.-ICB2) IC1 = ICA1
            ELSE
              IC1 = I1
              IC2 = ICB2
              IC3 = ICA1
              IC4 = I2
              CALL PHO_HARCOR(-ICB1,ICA2)
              IF(ICB2.EQ.-ICB1) IC2 = ICA2
            ENDIF
          ELSE
            IF(PHO_RNDM(V).GT.0.5D0) THEN
              IC1 = ICB1
              IC2 = ICA2
              IC3 = ICA1
              IC4 = ICB2
            ELSE
              IC1 = ICA1
              IC2 = ICB2
              IC3 = ICB1
              IC4 = ICA2
            ENDIF
          ENDIF
          ICONF(MSPR,I) = ICONF(MSPR,I)+1
        ELSE IF(MSPR.EQ.2) THEN
C  q qb --> g g
          PC(1) = U/V-2.D0*U**2
          PC(2) = V/U-2.D0*V**2
          CALL PHO_SELCOL(0,0,I1,K1,I2,K2,1)
          XI = (PC(1)+PC(2))*PHO_RNDM(U)
          IF(XI.LT.PC(1)) THEN
            IF(ICA1.GT.0) THEN
              IC1 = ICA1
              IC2 = I2
              IC3 = I1
              IC4 = ICB1
              ICONF(MSPR,1) = ICONF(MSPR,1)+1
            ELSE
              IC1 = I1
              IC2 = ICA1
              IC3 = ICB1
              IC4 = I2
              ICONF(MSPR,2) = ICONF(MSPR,2)+1
            ENDIF
          ELSE
            IF(ICA1.GT.0) THEN
              IC1 = I1
              IC2 = ICB1
              IC3 = ICA1
              IC4 = I2
              ICONF(MSPR,3) = ICONF(MSPR,3)+1
            ELSE
              IC1 = ICB1
              IC2 = I2
              IC3 = I1
              IC4 = ICA1
              ICONF(MSPR,4) = ICONF(MSPR,4)+1
            ENDIF
          ENDIF
        ELSE IF(MSPR.EQ.3) THEN
C  q g --> q g
          PC(1) = 2.D0*(U/V)**2-U
          PC(2) = 2.D0/V**2-1.D0/U
          XI = (PC(1)+PC(2))*PHO_RNDM(V)
          IF(XI.LT.PC(1)) THEN
            CALL PHO_SELCOL(0,0,I1,K1,I2,K2,1)
            IF(IP1.GT.0) THEN
              IC1 = I1
              IC3 = ICB1
              IC4 = I2
              CALL PHO_HARCOR(-ICA1,ICB2)
              ICONF(MSPR,1) = ICONF(MSPR,1)+1
            ELSE IF(IP1.LT.0) THEN
              IC1 = I2
              IC3 = I1
              IC4 = ICB2
              CALL PHO_HARCOR(-ICA1,ICB1)
              ICONF(MSPR,1) = ICONF(MSPR,1)+1
            ELSE IF(IP2.GT.0) THEN
              IC1 = ICA1
              IC2 = I2
              IC3 = I1
              CALL PHO_HARCOR(-ICB1,ICA2)
              ICONF(MSPR,2) = ICONF(MSPR,2)+1
            ELSE
              IC1 = I1
              IC2 = ICA2
              IC3 = I2
              CALL PHO_HARCOR(-ICB1,ICA1)
              ICONF(MSPR,2) = ICONF(MSPR,2)+1
            ENDIF
          ELSE
            IF(IP1.GT.0) THEN
              IC1 = ICB1
              IC3 = ICA1
              IC4 = ICB2
              ICONF(MSPR,3) = ICONF(MSPR,3)+1
            ELSE IF(IP1.LT.0) THEN
              IC1 = ICB2
              IC3 = ICB1
              IC4 = ICA1
              ICONF(MSPR,3) = ICONF(MSPR,3)+1
            ELSE IF(IP2.GT.0) THEN
              IC1 = ICB1
              IC2 = ICA2
              IC3 = ICA1
              ICONF(MSPR,4) = ICONF(MSPR,4)+1
            ELSE
              IC1 = ICA1
              IC2 = ICB1
              IC3 = ICA2
              ICONF(MSPR,4) = ICONF(MSPR,4)+1
            ENDIF
          ENDIF
        ELSE IF(MSPR.EQ.4) THEN
C  g g --> q qb
          PC(1) = U/V-2.D0*U**2
          PC(2) = V/U-2.D0*V**2
          XI = (PC(1)+PC(2))*PHO_RNDM(U)
          IF(XI.LT.PC(1)) THEN
            IF(IP3.GT.0) THEN
              IC1 = ICA1
              IC3 = ICB2
              CALL PHO_HARCOR(-ICB1,ICA2)
              IF(ICB2.EQ.-ICB1) IC3 = ICA2
              ICONF(MSPR,1) = ICONF(MSPR,1)+1
            ELSE
              IC1 = ICA2
              IC3 = ICB1
              CALL PHO_HARCOR(-ICB2,ICA1)
              IF(ICB1.EQ.-ICB2) IC3 = ICA1
              ICONF(MSPR,2) = ICONF(MSPR,2)+1
            ENDIF
          ELSE
            IF(IP3.GT.0) THEN
              IC1 = ICB1
              IC3 = ICA2
              CALL PHO_HARCOR(-ICB2,ICA1)
              IF(ICB1.EQ.-ICB2) IC1 = ICA1
              ICONF(MSPR,3) = ICONF(MSPR,3)+1
            ELSE
              IC1 = ICB2
              IC3 = ICA1
              CALL PHO_HARCOR(-ICB1,ICA2)
              IF(ICB2.EQ.-ICB1) IC1 = ICA2
              ICONF(MSPR,4) = ICONF(MSPR,4)+1
            ENDIF
          ENDIF
        ELSE IF(MSPR.EQ.5) THEN
C  q qb --> q qb
          PC(1) = (1.D0+U**2)/V**2
          PC(2) = (V**2+U**2)
          XI = (PC(1)+PC(2))*PHO_RNDM(V)
          IF(XI.LT.PC(1)) THEN
            CALL PHO_HARCOR(-ICB1,ICA1)
            CALL PHO_SELCOL(0,0,I1,K1,I2,K2,1)
            IF(IP3.GT.0) THEN
              IC1 = I1
              IC3 = I2
              ICONF(MSPR,1) = ICONF(MSPR,1)+1
            ELSE
              IC1 = I2
              IC3 = I1
              ICONF(MSPR,2) = ICONF(MSPR,2)+1
            ENDIF
          ELSE
            IF(IP3.GT.0) THEN
              IC1 = MAX(ICA1,ICB1)
              IC3 = MIN(ICA1,ICB1)
              ICONF(MSPR,3) = ICONF(MSPR,3)+1
            ELSE
              IC1 = MIN(ICA1,ICB1)
              IC3 = MAX(ICA1,ICB1)
              ICONF(MSPR,4) = ICONF(MSPR,4)+1
            ENDIF
          ENDIF
        ELSE IF(MSPR.EQ.6) THEN
C  q qb --> qp qpb
          IF(IP3.GT.0) THEN
            IC1 = MAX(ICA1,ICB1)
            IC3 = MIN(ICA1,ICB1)
            ICONF(MSPR,1) = ICONF(MSPR,1)+1
          ELSE
            IC1 = MIN(ICA1,ICB1)
            IC3 = MAX(ICA1,ICB1)
            ICONF(MSPR,2) = ICONF(MSPR,2)+1
          ENDIF
        ELSE IF(MSPR.EQ.7) THEN
C  q q --> q q
          PC(1) = (1.D0+U**2)/V**2
          PC(2) = (1.D0+V**2)/U**2
          XI = (PC(1)+PC(2))*PHO_RNDM(U)
          IF(XI.LT.PC(1)) THEN
            IC1 = ICB1
            IC3 = ICA1
            ICONF(MSPR,1) = ICONF(MSPR,1)+1
          ELSE
            IC1 = ICA1
            IC3 = ICB1
            ICONF(MSPR,2) = ICONF(MSPR,2)+1
          ENDIF
        ELSE IF(MSPR.EQ.8) THEN
C  q qp --> q qp
          IF(IP1*IP2.LT.0) THEN
            CALL PHO_HARCOR(-ICB1,ICA1)
            CALL PHO_SELCOL(0,0,I1,K1,I2,K2,1)
            IF(IP1.GT.0) THEN
              IC1 = I1
              IC3 = I2
              ICONF(MSPR,1) = ICONF(MSPR,1)+1
            ELSE
              IC1 = I2
              IC3 = I1
              ICONF(MSPR,2) = ICONF(MSPR,2)+1
            ENDIF
          ELSE
            IC1 = ICB1
            IC3 = ICA1
            ICONF(MSPR,3) = ICONF(MSPR,3)+1
          ENDIF

        ELSE IF(MSPR.EQ.10) THEN
C  gam q --> q g
          CALL PHO_SELCOL(ICB1,ICB2,IC1,IC2,IC3,IC4,2)
          IF(IP3.EQ.0) THEN
            CALL PHO_SWAPI(IC1,IC3)
            CALL PHO_SWAPI(IC2,IC4)
          ENDIF
        ELSE IF(MSPR.EQ.11) THEN
C  gam g --> q q
          IC1 = ICB1
          IC3 = ICB2
          IF(IP3.LT.0) CALL PHO_SWAPI(IC1,IC3)
        ELSE IF(MSPR.EQ.12) THEN
C  q gam --> q g
          CALL PHO_SELCOL(ICA1,ICA2,IC1,IC2,IC3,IC4,2)
          IF(IP3.EQ.0) THEN
            CALL PHO_SWAPI(IC1,IC3)
            CALL PHO_SWAPI(IC2,IC4)
          ENDIF
        ELSE IF(MSPR.EQ.13) THEN
C  g gam --> q q
          IC1 = ICA1
          IC3 = ICA2
          IF(IP3.LT.0) CALL PHO_SWAPI(IC1,IC3)
        ELSE IF(MSPR.EQ.14) THEN
          IF(ABS(IP3).GT.12) THEN
            IC1 = 0
            IC3 = 0
          ELSE
            CALL PHO_SELCOL(ICA1,ICA2,IC1,IC2,IC3,IC4,1)
            IF(IP3.LT.0) CALL PHO_SWAPI(IC1,IC3)
          ENDIF
        ELSE
C  unknown process
          WRITE(ErrorOut,'(/1X,A,I3)')
     &      'PHO_HARCOL:ERROR:INVALID PROCESS NUMBER',MSPR
          CALL PHO_ABORT
        ENDIF
      ENDIF
C
 100  CONTINUE
C  debug output
      IF(IDEB(26).GE.10) WRITE(ErrorOut,'(5X,A,3I5,2X,3I5)')
     &    'FINAL PARTONS AND COLORS',IP3,IC1,IC2,IP4,IC3,IC4
C  color connection?
*     IF(((IC1.NE.-IC3).AND.(IC1.NE.-IC4)).AND.
*    &  (((IC2.NE.0).AND.(IC2.NE.-IC3).AND.(IC2.NE.-IC4))
*    &  .OR.(IC2.EQ.0))) THEN
C  color exchange?
*       IF(((IP1.EQ.IP3).AND.(ICA1.EQ.IC1).AND.(ICA2.EQ.IC2))
*    &     .OR.((IP1.EQ.IP4).AND.(ICA1.EQ.IC3).AND.(ICA2.EQ.IC4))) THEN
*         IF(IRC.NE.1) THEN
*           WRITE(6,'(1X,A,I10,I3)')
*    &        'PHO_HARCOL:unexp. re-connection (event/MSPR):',KEVENT,MSPR
*           WRITE(6,'(5X,A,3I5,2X,3I5)')
*    &        'initial partons and colors',IP1,ICA1,ICA2,IP2,ICB1,ICB2
*           WRITE(6,'(5X,A,3I5,2X,3I5)')
*    &        'final partons and colors  ',IP3,IC1,IC2,IP4,IC3,IC4
*         ENDIF
*         IRC = 0
*       ENDIF
*     ENDIF
*     IF(IRC.EQ.1) THEN
*           WRITE(6,'(1X,A,I10,I3)')
*    &        'PHO_HARCOL:re-conn. failed (event/MSPR):',KEVENT,MSPR
*           WRITE(6,'(5X,A,3I5,2X,3I5)')
*    &        'initial partons and colors',IP1,ICA1,ICA2,IP2,ICB1,ICB2
*           WRITE(6,'(5X,A,3I5,2X,3I5)')
*    &        'final partons and colors  ',IP3,IC1,IC2,IP4,IC3,IC4
*     ENDIF
C
      ICC1 = IC1
      ICC2 = IC2
      ICD1 = IC3
      ICD2 = IC4

      END


CDECK  ID>, PHO_HARCOR
      SUBROUTINE PHO_HARCOR(ICOLD,ICNEW)
C***********************************************************************
C
C     substituite color in /POEVT2/
C
C     input:    ICOLD   old color
C               ICNEW   new color
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
C

C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C
      DO 100 I=NHEP,3,-1
        IF(ISTHEP(I).EQ.-1) THEN
          IF(ICOLOR(1,I).EQ.ICOLD) THEN
            ICOLOR(1,I) = ICNEW
            RETURN
          ELSE IF(IDHEP(I).EQ.21) THEN
            IF(ICOLOR(2,I).EQ.ICOLD) THEN
              ICOLOR(2,I) = ICNEW
              RETURN
            ENDIF
          ENDIF
*       ELSE IF(ISTHEP(I).EQ.20) THEN
*         IF(ICOLOR(1,I).EQ.-ICOLD) THEN
*           print *,' PHO_HARCOR(3): line, old, new:',I,ICOLD,ICNEW
*           ICOLOR(1,I) = -ICNEW
*           RETURN
*         ELSE IF(IDHEP(I).EQ.21) THEN
*           IF(ICOLOR(2,I).EQ.-ICOLD) THEN
*             print *,' PHO_HARCOR(4): line, old, new:',I,ICOLD,ICNEW
*             ICOLOR(2,I) = -ICNEW
*             RETURN
*           ENDIF
*         ENDIF
        ENDIF
 100  CONTINUE
      END


CDECK  ID>, PHO_HARREM
      SUBROUTINE PHO_HARREM(JM1,JM2,IGEN,IHPOS,IVAL,INDXS,IC1,IC2,
     &                      IUSED,IREJ)
C***********************************************************************
C
C     sample color structure for initial quark/gluon of hard scattering
C     and write hadron remnant to /POEVT1/
C
C     input:    JM1,2   index of mother particle in POEVT1
C               IGEN    mother particle production process
C               IHPOS   hard pomeron number
C               INDXH   index of hard parton
C                       positive for labels 1
C                       negative for labels 2
C               IVAL     1  hard valence parton
C                        0  hard sea parton connected by color flow with
C                           valence quarks
C                       -1  hard sea parton independent off valence
C                           quarks
C               INDXS   index of soft partons needed
C
C     output:   IC1,IC2 color label of initial parton
C               IUSED   number of soft X values used
C               IREJ    rejection flag
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( TINY   =  1.D-10 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  light-cone x fractions and c.m. momenta of soft cut string ends
      INTEGER MAXSOF
      PARAMETER ( MAXSOF = 50 )
      INTEGER IJSI2,IJSI1
      DOUBLE PRECISION XS1,XS2,PSOFT1,PSOFT2
      COMMON /POSOFT/ XS1(MAXSOF),XS2(MAXSOF),
     &                PSOFT1(4,MAXSOF),PSOFT2(4,MAXSOF),
     &                IJSI1(MAXSOF),IJSI2(MAXSOF)

C  hard scattering data
      INTEGER MSCAHD
      PARAMETER ( MSCAHD = 50 )
      INTEGER LSCAHD,LSC1HD,LSIDX,
     &        NINHD,N0INHD,NIVAL,N0IVAL,NOUTHD,NBRAHD,NPROHD
      DOUBLE PRECISION PPH,PTHD,ETAHD,Q2SCA,PDFVA,XHD,VHD,X0HD
      COMMON /POHSLT/ LSCAHD,LSC1HD,LSIDX(MSCAHD),
     &                PPH(8*MSCAHD,2),PTHD(MSCAHD),ETAHD(MSCAHD,2),
     &                Q2SCA(MSCAHD,2),PDFVA(MSCAHD,2),
     &                XHD(MSCAHD,2),VHD(MSCAHD),X0HD(MSCAHD,2),
     &                NINHD(MSCAHD,2),N0INHD(MSCAHD,2),
     &                NIVAL(MSCAHD,2),N0IVAL(MSCAHD,2),
     &                NOUTHD(MSCAHD,2),NBRAHD(MSCAHD,2),NPROHD(MSCAHD)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)


      IREJ = 0

      INDXH = SIGN(LSIDX(ABS(IHPOS)),IHPOS)

      IF(INDXH.GT.0) THEN
        IJH = IPHO_CNV1(NINHD(INDXH,1))
      ELSE
        IJH = IPHO_CNV1(NINHD(-INDXH,2))
      ENDIF
C  direct process (photon or pomeron)
      IUSED = 0
      IC1   = 0
      IC2   = 0
      IF((IJH.EQ.22).OR.(IJH.EQ.990)) RETURN

      IHP = 100*ABS(IHPOS)
      IVSW = 1
***************************************
*     IF((IDHEP(JM1).EQ.22).OR.(IDHEP(JM1).EQ.990)) IVSW = 0
***************************************

      IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,2I3,1X,5I4)')
     &  'PHO_HARREM: JM1,JM2,IHPOS,INDXH,IFLH,IVAL,INDXS:',
     &  JM1,JM2,IHPOS,INDXH,IJH,IVAL,INDXS

C  quark
C****************************************************************

        IF(IJH.NE.21) THEN

C  valence quark engaged in hard scattering
          IF(IVAL.EQ.1) THEN
            CALL PHO_PARREM(JM1,IJH,IREM,IREJ)
            IF(IREJ.NE.0) THEN
              WRITE(ErrorOut,'(/1X,2A,2I6)') 'PHO_HARREM: ',
     &          'INVALID VALENCE FLAVOUR REQUESTED JM,IFLA',JM1,IJH
              RETURN
            ENDIF
            CALL PHO_SELCOL(0,0,ICA1,ICA2,ICB1,ICB2,1)
            IF(((ABS(IREM).GT.6).AND.(IREM.GT.0))
     &         .OR.((ABS(IREM).LE.6).AND.(IREM.LT.0))) THEN
              I = ICA1
              ICA1 = ICB1
              ICB1 = I
            ENDIF
C  remnant of hadron
            IF(INDXH.GT.0) THEN
              P1 = PSOFT1(1,INDXS)
              P2 = PSOFT1(2,INDXS)
              P3 = PSOFT1(3,INDXS)
              P4 = PSOFT1(4,INDXS)
              IJSI1(INDXS) = IREM
            ELSE
              P1 = PSOFT2(1,INDXS)
              P2 = PSOFT2(2,INDXS)
              P3 = PSOFT2(3,INDXS)
              P4 = PSOFT2(4,INDXS)
              IJSI2(INDXS) = IREM
            ENDIF
C  registration
            CALL PHO_REGPAR(-1,IREM,0,JM1,JM2,P1,P2,P3,P4,
     &                      IHP,IGEN,ICA1,IVSW,IPOS,1)
            IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &        'PHO_HARREM: VAL.SPECTATOR:(IFL,IPOS,INDXS)',
     &        IREM,IPOS,SIGN(INDXS,INDXH)

            IUSED = 1

C  sea quark engaged in hard scattering, valence quarks treated
          ELSE IF(IVAL.EQ.0) THEN
            IF(INDXH.GT.0) THEN
              E1 = PSOFT1(4,INDXS)
              E2 = PSOFT1(4,INDXS+1)
            ELSE
              E1 = PSOFT2(4,INDXS)
              E2 = PSOFT2(4,INDXS+1)
            ENDIF
            CALL PHO_VALFLA(JM1,IVFL1,IVFL2,E1,E2)
            CALL PHO_SELCOL(0,0,ICA1,ICA2,ICB1,ICB2,1)
            IF(PHO_RNDM(P1).LT.0.5D0) THEN
              CALL PHO_SELCOL(ICB1,ICB2,ICB1,ICB2,ICC1,ICC2,2)
            ELSE
              CALL PHO_SELCOL(ICA1,ICA2,ICA1,ICA2,ICC1,ICC2,2)
            ENDIF
            IF(((ABS(IVFL1).GT.6).AND.(IVFL1.GT.0))
     &         .OR.((ABS(IVFL1).LE.6).AND.(IVFL1.LT.0))) THEN
              I = ICA1
              ICA1 = ICB1
              ICB1 = I
            ENDIF
            IF(INDXH.GT.0) THEN
              P1 = PSOFT1(1,INDXS)
              P2 = PSOFT1(2,INDXS)
              P3 = PSOFT1(3,INDXS)
              P4 = PSOFT1(4,INDXS)
              IJSI1(INDXS) = IVFL1
            ELSE
              P1 = PSOFT2(1,INDXS)
              P2 = PSOFT2(2,INDXS)
              P3 = PSOFT2(3,INDXS)
              P4 = PSOFT2(4,INDXS)
              IJSI2(INDXS) = IVFL1
            ENDIF
C  registration
            CALL PHO_REGPAR(-1,IVFL1,0,JM1,JM2,P1,P2,P3,P4,
     &                      IHP,IGEN,ICA1,IVSW,IPOS,1)
            IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &        'PHO_HARREM: VAL.SPECTATOR:(IFL,IPOS,INDXS)',
     &        IVFL1,IPOS,SIGN(INDXS,INDXH)

C
            IF(INDXH.GT.0) THEN
              P1 = PSOFT1(1,INDXS+1)
              P2 = PSOFT1(2,INDXS+1)
              P3 = PSOFT1(3,INDXS+1)
              P4 = PSOFT1(4,INDXS+1)
              IJSI1(INDXS+1) = IVFL2
            ELSE
              P1 = PSOFT2(1,INDXS+1)
              P2 = PSOFT2(2,INDXS+1)
              P3 = PSOFT2(3,INDXS+1)
              P4 = PSOFT2(4,INDXS+1)
              IJSI2(INDXS+1) = IVFL2
            ENDIF
C  registration
            CALL PHO_REGPAR(-1,IVFL2,0,JM1,JM2,P1,P2,P3,P4,
     &                  IHP,IGEN,ICB1,IVSW,IPOS,1)
            IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &        'PHO_HARREM: VAL.SPECTATOR:(IFL,IPOS,INDXS)',
     &        IVFL2,IPOS,SIGN(INDXS+1,INDXH)

C
            IF(IJH.LT.0) THEN
              ICB1 = ICC2
              ICA1 = ICC1
            ELSE
              ICB1 = ICC1
              ICA1 = ICC2
            ENDIF
            IF(INDXH.GT.0) THEN
              P1 = PSOFT1(1,INDXS+2)
              P2 = PSOFT1(2,INDXS+2)
              P3 = PSOFT1(3,INDXS+2)
              P4 = PSOFT1(4,INDXS+2)
              IJSI1(INDXS+2) = -IJH
            ELSE
              P1 = PSOFT2(1,INDXS+2)
              P2 = PSOFT2(2,INDXS+2)
              P3 = PSOFT2(3,INDXS+2)
              P4 = PSOFT2(4,INDXS+2)
              IJSI2(INDXS+2) = -IJH
            ENDIF
C  registration
            CALL PHO_REGPAR(-1,-IJH,0,JM1,JM2,P1,P2,P3,P4,
     &                      IHP,IGEN,ICA1,0,IPOS,1)
            IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &        'PHO_HARREM: SEA SPECTATOR:(IFL,IPOS,INDXS)',
     &        -IJH,IPOS,SIGN(INDXS+2,INDXH)
            IUSED = 3
C
C  sea quark engaged in hard scattering, valences treated separately
          ELSE IF(IVAL.EQ.-1) THEN
            CALL PHO_SELCOL(0,0,ICA1,ICA2,ICB1,ICB2,1)
            IF(IJH.GT.0) THEN
              ICC1 = ICB1
              ICB1 = ICA1
              ICA1 = ICC1
            ENDIF
            IF(INDXH.GT.0) THEN
              P1 = PSOFT1(1,INDXS)
              P2 = PSOFT1(2,INDXS)
              P3 = PSOFT1(3,INDXS)
              P4 = PSOFT1(4,INDXS)
              IJSI1(INDXS) = -IJH
            ELSE
              P1 = PSOFT2(1,INDXS)
              P2 = PSOFT2(2,INDXS)
              P3 = PSOFT2(3,INDXS)
              P4 = PSOFT2(4,INDXS)
              IJSI2(INDXS) = -IJH
            ENDIF
C  registration
            CALL PHO_REGPAR(-1,-IJH,0,JM1,JM2,P1,P2,P3,P4,
     &                      IHP,IGEN,ICA1,0,IPOS,1)
            IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &        'PHO_HARREM: SEA SPECTATOR:(IFL,IPOS,INDXS)',
     &        -IJH,IPOS,SIGN(INDXS,INDXH)

            IUSED = 1
          ELSE
            WRITE(ErrorOut,'(1X,A,2I5)')
     &        'PHO_HARREM:ERROR:UNSUPPORTED COMBINATION OF IVAL,IJH',
     &        IVAL,IJH
            CALL PHO_ABORT
          ENDIF
C
          IC1 = ICB1
          IC2 = 0
C
C  gluon
C****************************************************************
C
C  gluon from valence quarks
        ELSE
          IF(IVAL.EQ.1) THEN
C  purely gluonic pomeron remnant
            IF((IDHEP(JM1).EQ.990).AND.(IPAMDL(20).GT.0)) THEN
              IF(INDXH.GT.0) THEN
                P1 = PSOFT1(1,INDXS) + PSOFT1(1,INDXS+1)
                P2 = PSOFT1(2,INDXS) + PSOFT1(2,INDXS+1)
                P3 = PSOFT1(3,INDXS) + PSOFT1(3,INDXS+1)
                P4 = PSOFT1(4,INDXS) + PSOFT1(4,INDXS+1)
                IJSI1(INDXS) = 0
              ELSE
                P1 = PSOFT2(1,INDXS) + PSOFT2(1,INDXS+1)
                P2 = PSOFT2(2,INDXS) + PSOFT2(2,INDXS+1)
                P3 = PSOFT2(3,INDXS) + PSOFT2(3,INDXS+1)
                P4 = PSOFT2(4,INDXS) + PSOFT2(4,INDXS+1)
                IJSI2(INDXS) = 0
              ENDIF
              IFL1 = 21
              CALL PHO_SELCOL(0,0,ICA1,ICA2,ICB1,ICB2,1)
              IF(PHO_RNDM(P2).LT.0.5D0) THEN
                CALL PHO_SELCOL(ICA1,ICA2,ICA1,ICA2,ICC1,ICC2,2)
              ELSE
                CALL PHO_SELCOL(ICB1,ICB2,ICB1,ICB2,ICC1,ICC2,2)
              ENDIF
C  registration
              CALL PHO_REGPAR(-1,IFL1,0,JM1,JM2,P1,P2,P3,P4,
     &                        IHP,IGEN,ICA1,ICB1,IPOS,1)
              IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &          'PHO_HARREM: VAL.GLUON:(IFL,IPOS,INDXS)',
     &          IFL1,IPOS,SIGN(INDXS,INDXH)

              IUSED = 2
C  valence quark remnant
            ELSE
              IF(INDXH.GT.0) THEN
                E1 = PSOFT1(4,INDXS)
                E2 = PSOFT1(4,INDXS+1)
              ELSE
                E1 = PSOFT2(4,INDXS)
                E2 = PSOFT2(4,INDXS+1)
              ENDIF
              CALL PHO_VALFLA(JM1,IFL1,IFL2,E1,E2)
              CALL PHO_SELCOL(0,0,ICA1,ICA2,ICB1,ICB2,1)
              IF(((ABS(IFL1).LE.6).AND.(IFL1.LT.0))
     &           .OR.((ABS(IFL1).GT.6).AND.(IFL1.GT.0))) THEN
                I = ICA1
                ICA1 = ICB1
                ICB1 = I
              ENDIF
              IF(PHO_RNDM(P2).LT.0.5D0) THEN
                CALL PHO_SELCOL(ICA1,ICA2,ICA1,ICA2,ICC1,ICC2,2)
              ELSE
                CALL PHO_SELCOL(ICB1,ICB2,ICB1,ICB2,ICC1,ICC2,2)
              ENDIF
C  remnant of hadron
              IF(INDXH.GT.0) THEN
                P1 = PSOFT1(1,INDXS)
                P2 = PSOFT1(2,INDXS)
                P3 = PSOFT1(3,INDXS)
                P4 = PSOFT1(4,INDXS)
                IJSI1(INDXS) = IFL1
              ELSE
                P1 = PSOFT2(1,INDXS)
                P2 = PSOFT2(2,INDXS)
                P3 = PSOFT2(3,INDXS)
                P4 = PSOFT2(4,INDXS)
                IJSI2(INDXS) = IFL1
              ENDIF
C  registration
              CALL PHO_REGPAR(-1,IFL1,0,JM1,JM2,P1,P2,P3,P4,
     &                        IHP,IGEN,ICA1,IVSW,IPOS,1)
              IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &          'PHO_HARREM: VAL.SPECTATOR:(IFL,IPOS,INDXS)',
     &          IFL1,IPOS,SIGN(INDXS,INDXH)

C
              IF(INDXH.GT.0) THEN
                P1 = PSOFT1(1,INDXS+1)
                P2 = PSOFT1(2,INDXS+1)
                P3 = PSOFT1(3,INDXS+1)
                P4 = PSOFT1(4,INDXS+1)
                IJSI1(INDXS+1) = IFL2
              ELSE
                P1 = PSOFT2(1,INDXS+1)
                P2 = PSOFT2(2,INDXS+1)
                P3 = PSOFT2(3,INDXS+1)
                P4 = PSOFT2(4,INDXS+1)
                IJSI2(INDXS+1) = IFL2
              ENDIF
C  registration
              CALL PHO_REGPAR(-1,IFL2,0,JM1,JM2,P1,P2,P3,P4,
     &                        IHP,IGEN,ICB1,IVSW,IPOS,1)
              IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &          'PHO_HARREM: VAL.SPECTATOR:(IFL,IPOS,INDXS)',
     &          IFL2,IPOS,SIGN(INDXS+1,INDXH)

              IUSED = 2
            ENDIF
C
C  gluon from sea quarks connected with valence quarks
          ELSE IF(IVAL.EQ.0) THEN
            IF(INDXH.GT.0) THEN
              E1 = PSOFT1(4,INDXS)
              E2 = PSOFT1(4,INDXS+1)
            ELSE
              E1 = PSOFT2(4,INDXS)
              E2 = PSOFT2(4,INDXS+1)
            ENDIF
            CALL PHO_VALFLA(JM1,IFL1,IFL2,E1,E2)
            CALL PHO_SELCOL(0,0,ICA1,ICA2,ICB1,ICB2,1)
            IF(((ABS(IFL1).LE.6).AND.(IFL1.LT.0))
     &         .OR.((ABS(IFL1).GT.6).AND.(IFL1.GT.0))) THEN
              I = ICA1
              ICA1 = ICB1
              ICB1 = I
            ENDIF
            IF(PHO_RNDM(P3).LT.0.5D0) THEN
              CALL PHO_SELCOL(ICA1,ICA2,ICA1,ICA2,ICC1,ICC2,2)
            ELSE
              CALL PHO_SELCOL(ICB1,ICB2,ICB1,ICB2,ICC1,ICC2,2)
            ENDIF
C  remnant of hadron
            IF(INDXH.GT.0) THEN
              P1 = PSOFT1(1,INDXS)
              P2 = PSOFT1(2,INDXS)
              P3 = PSOFT1(3,INDXS)
              P4 = PSOFT1(4,INDXS)
              IJSI1(INDXS) = IFL1
            ELSE
              P1 = PSOFT2(1,INDXS)
              P2 = PSOFT2(2,INDXS)
              P3 = PSOFT2(3,INDXS)
              P4 = PSOFT2(4,INDXS)
              IJSI2(INDXS) = IFL1
            ENDIF
C  registration
            CALL PHO_REGPAR(-1,IFL1,0,JM1,JM2,P1,P2,P3,P4,
     &                      IHP,IGEN,ICA1,IVSW,IPOS,1)
            IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &        'PHO_HARREM: VAL.SPECTATOR:(IFL,IPOS,INDXS)',
     &        IFL1,IPOS,SIGN(INDXS,INDXH)

C
            IF(INDXH.GT.0) THEN
              P1 = PSOFT1(1,INDXS+1)
              P2 = PSOFT1(2,INDXS+1)
              P3 = PSOFT1(3,INDXS+1)
              P4 = PSOFT1(4,INDXS+1)
              IJSI1(INDXS+1) = IFL2
            ELSE
              P1 = PSOFT2(1,INDXS+1)
              P2 = PSOFT2(2,INDXS+1)
              P3 = PSOFT2(3,INDXS+1)
              P4 = PSOFT2(4,INDXS+1)
              IJSI2(INDXS+1) = IFL2
            ENDIF
C  registration
            CALL PHO_REGPAR(-1,IFL2,0,JM1,JM2,P1,P2,P3,P4,
     &                      IHP,IGEN,ICB1,IVSW,IPOS,1)
            IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &        'PHO_HARREM: VAL.SPECTATOR:(IFL,IPOS,INDXS)',
     &        IFL2,IPOS,SIGN(INDXS+1,INDXH)

            IF(IPAMDL(18).EQ.0)  THEN
C  sea quark pair
              CALL PHO_SEAFLA(JM1,IFL1,IFL2,PARMDL(161))
              IF(ICC1.GT.0) THEN
                IFL1 = ABS(IFL1)
                IFL2 = -IFL1
              ELSE
                IFL1 = -ABS(IFL1)
                IFL2 = -IFL1
              ENDIF
              IF(PHO_RNDM(P4).LT.0.5D0) THEN
                ICB1 = ICC2
                CALL PHO_SELCOL(ICC1,0,ICA1,ICA2,ICC1,ICC2,2)
              ELSE
                ICA1 = ICC1
                CALL PHO_SELCOL(ICC2,0,ICB1,ICB2,ICC1,ICC2,2)
              ENDIF
              IF(INDXH.GT.0) THEN
                P1 = PSOFT1(1,INDXS+2)
                P2 = PSOFT1(2,INDXS+2)
                P3 = PSOFT1(3,INDXS+2)
                P4 = PSOFT1(4,INDXS+2)
                IJSI1(INDXS+2) = IFL1
              ELSE
                P1 = PSOFT2(1,INDXS+2)
                P2 = PSOFT2(2,INDXS+2)
                P3 = PSOFT2(3,INDXS+2)
                P4 = PSOFT2(4,INDXS+2)
                IJSI2(INDXS+2) = IFL1
              ENDIF
C  registration
              CALL PHO_REGPAR(-1,IFL1,0,JM1,JM2,P1,P2,P3,P4,
     &                        IHP,IGEN,ICA1,0,IPOS,1)
              IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &          'PHO_HARREM: SEA SPECTATOR:(IFL,IPOS,INDXS)',
     &          IFL1,IPOS,SIGN(INDXS+2,INDXH)

C
              IF(INDXH.GT.0) THEN
                P1 = PSOFT1(1,INDXS+3)
                P2 = PSOFT1(2,INDXS+3)
                P3 = PSOFT1(3,INDXS+3)
                P4 = PSOFT1(4,INDXS+3)
                IJSI1(INDXS+3) = IFL2
              ELSE
                P1 = PSOFT2(1,INDXS+3)
                P2 = PSOFT2(2,INDXS+3)
                P3 = PSOFT2(3,INDXS+3)
                P4 = PSOFT2(4,INDXS+3)
                IJSI2(INDXS+3) = IFL2
              ENDIF
C  registration
              CALL PHO_REGPAR(-1,IFL2,0,JM1,JM2,P1,P2,P3,P4,
     &                        IHP,IGEN,ICB1,0,IPOS,1)
              IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &          'PHO_HARREM: SEA SPECTATOR:(IFL,IPOS,INDXS)',
     &          IFL2,IPOS,SIGN(INDXS+3,INDXH)

              IUSED = 4
            ELSE
              IUSED = 2
            ENDIF
C
C  gluon from independent sea quarks
          ELSE IF(IVAL.EQ.-1) THEN
            IF(IPAMDL(18).EQ.0) THEN
              CALL PHO_SELCOL(0,0,ICA1,ICA2,ICB1,ICB2,1)
              CALL PHO_SEAFLA(JM1,IFL1,IFL2,PARMDL(161))
              IF(((ABS(IFL1).LE.6).AND.(IFL1.LT.0))
     &           .OR.((ABS(IFL1).GT.6).AND.(IFL1.GT.0))) THEN
                I = ICA1
                ICA1 = ICB1
                ICB1 = I
              ENDIF
              IF(PHO_RNDM(P1).LT.0.5D0) THEN
                CALL PHO_SELCOL(ICA1,ICA2,ICA1,ICA2,ICC1,ICC2,2)
              ELSE
                CALL PHO_SELCOL(ICB1,ICB2,ICB1,ICB2,ICC1,ICC2,2)
              ENDIF
C  remainder of hadron
              IF(INDXH.GT.0) THEN
                P1 = PSOFT1(1,INDXS)
                P2 = PSOFT1(2,INDXS)
                P3 = PSOFT1(3,INDXS)
                P4 = PSOFT1(4,INDXS)
                IJSI1(INDXS) = IFL1
              ELSE
                P1 = PSOFT2(1,INDXS)
                P2 = PSOFT2(2,INDXS)
                P3 = PSOFT2(3,INDXS)
                P4 = PSOFT2(4,INDXS)
                IJSI2(INDXS) = IFL1
              ENDIF
C  registration
              CALL PHO_REGPAR(-1,IFL1,0,JM1,JM2,P1,P2,P3,P4,
     &                        IHP,IGEN,ICA1,ICA2,IPOS,1)
              IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &          'PHO_HARREM: SEA SPECTATOR:(IFL,IPOS,INDXS)',
     &          IFL1,IPOS,SIGN(INDXS,INDXH)

C  remnant of sea
              IF(INDXH.GT.0) THEN
                P1 = PSOFT1(1,INDXS-1)
                P2 = PSOFT1(2,INDXS-1)
                P3 = PSOFT1(3,INDXS-1)
                P4 = PSOFT1(4,INDXS-1)
                IJSI1(INDXS-1) = IFL2
              ELSE
                P1 = PSOFT2(1,INDXS-1)
                P2 = PSOFT2(2,INDXS-1)
                P3 = PSOFT2(3,INDXS-1)
                P4 = PSOFT2(4,INDXS-1)
                IJSI2(INDXS-1) = IFL2
              ENDIF
C  registration
              CALL PHO_REGPAR(-1,IFL2,0,JM1,JM2,P1,P2,P3,P4,
     &                        IHP,IGEN,ICB1,ICB2,IPOS,1)
              IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &          'PHO_HARREM: SEA SPECTATOR:(IFL,IPOS,INDXS)',
     &          IFL2,IPOS,SIGN(INDXS-1,INDXH)

              IUSED = 2
            ELSE
              CALL PHO_SELCOL(0,0,ICC1,ICA2,ICC2,ICB2,1)
              IF(IDEB(28).GE.20) WRITE(ErrorOut,'(1X,A,I5)')
     &          'PHO_HARREM: NO SPECTATOR ADDED:(INDXS)',
     &          SIGN(INDXS,INDXH)
              IUSED = 0
            ENDIF
C
          ELSE
            WRITE(ErrorOut,'(1X,A,2I5)')
     &        'PHO_HARREM:ERROR: UNSUPPORTED COMBINATION OF IVAL,IJH',
     &        IVAL,IJH
            CALL PHO_ABORT
          ENDIF
          IC1 = ICC1
          IC2 = ICC2
        ENDIF
      END


CDECK  ID>, PHO_HARDIR
      SUBROUTINE PHO_HARDIR(II,IVAL1,IVAL2,MSPAR1,MSPAR2,MHPAR1,MHPAR2,
     &                      IREJ)
C**********************************************************************
C
C     parton orientated formulation of direct scattering processes
C
C     input:
C
C     output:   II        particle combination (1..4)
C               IVAL1,2   0 no valence quarks engaged
C                         1 valence quarks engaged
C               MSPAR1,2  number of realized soft partons
C               MHPAR1,2  number of realized hard partons
C               IREJ      1 failure
C                         0 success
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  light-cone x fractions and c.m. momenta of soft cut string ends
      INTEGER MAXSOF
      PARAMETER ( MAXSOF = 50 )
      INTEGER IJSI2,IJSI1
      DOUBLE PRECISION XS1,XS2,PSOFT1,PSOFT2
      COMMON /POSOFT/ XS1(MAXSOF),XS2(MAXSOF),
     &                PSOFT1(4,MAXSOF),PSOFT2(4,MAXSOF),
     &                IJSI1(MAXSOF),IJSI2(MAXSOF)

C  hard scattering data
      INTEGER MSCAHD
      PARAMETER ( MSCAHD = 50 )
      INTEGER LSCAHD,LSC1HD,LSIDX,
     &        NINHD,N0INHD,NIVAL,N0IVAL,NOUTHD,NBRAHD,NPROHD
      DOUBLE PRECISION PPH,PTHD,ETAHD,Q2SCA,PDFVA,XHD,VHD,X0HD
      COMMON /POHSLT/ LSCAHD,LSC1HD,LSIDX(MSCAHD),
     &                PPH(8*MSCAHD,2),PTHD(MSCAHD),ETAHD(MSCAHD,2),
     &                Q2SCA(MSCAHD,2),PDFVA(MSCAHD,2),
     &                XHD(MSCAHD,2),VHD(MSCAHD),X0HD(MSCAHD,2),
     &                NINHD(MSCAHD,2),N0INHD(MSCAHD,2),
     &                NIVAL(MSCAHD,2),N0IVAL(MSCAHD,2),
     &                NOUTHD(MSCAHD,2),NBRAHD(MSCAHD,2),NPROHD(MSCAHD)

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)


      DIMENSION P1(4),P2(4),PD1(-6:6)

      PARAMETER ( TINY   =  1.D-10 )

      ITRY  = 0
      NTRY  = 10
      LSC1HD = 0
      LSIDX(1) = 1

C  check phase space
      IF(ECMP.LT.(2.D0*PTWANT+0.1D0)) THEN
        IFAIL(18) = IFAIL(18)+1
        IREJ = 50
        RETURN
      ENDIF

      AS     = (PARMDL(160+II)/ECMP)**2
      AH     = (2.D0*PTWANT/ECMP)**2

      ALNS   = LOG(AS)
      ALNH   = LOG(AH)

      XMAX   = MAX(TINY,1.D0-AS)
      Z1MAX  = LOG(XMAX)
      Z1DIF  = Z1MAX-ALNH
C
C  main loop to select hard and soft parton kinematics
C -----------------------------------------------------
 120  CONTINUE
        IREJ = 0
        ITRY   = ITRY+1
        LSC1HD = LSC1HD+1
        IF(ITRY.GT.1) THEN
          IFAIL(17) = IFAIL(17)+1
          IF(ITRY.GE.NTRY) THEN
            IREJ = 1
            GOTO 450
          ENDIF
        ENDIF
        LINE   = 0
        LSCAHD = 0
        XSS1   = 0.D0
        XSS2   = 0.D0
        MSPAR1 = 0
        MSPAR2 = 0

C  select hard V,X
        CALL PHO_HARSCA(1,II)
        XSS1   = XSS1+X1
        XSS2   = XSS2+X2
C  debug output
        IF(IDEB(25).GE.20) THEN
          WRITE(ErrorOut,'(1X,A,2E12.4,2I5)')
     &      'PHO_HARDIR: AS,XMAX,PROCESS ID,ITRY',
     &      AS,XMAX,MSPR,ITRY
          WRITE(ErrorOut,'(1X,A,4E12.4)') 'HARD X1,2  SUM X1,2',
     &      X1,X2,XSS1,XSS2
        ENDIF

      IF(MSPR.LE.11) THEN
        IF((XSS2.GT.XMAX).OR.((1.D0-XSS2).LT.AS)) GOTO 120
      ELSE IF(MSPR.LE.13) THEN
        IF((XSS1.GT.XMAX).OR.((1.D0-XSS1).LT.AS)) GOTO 120
      ENDIF

C  fill /POHSLT/
      LSCAHD     = 1
      LSIDX(1)   = 1
      XHD(1,1)   = X1
      XHD(1,2)   = X2
      X0HD(1,1)  = X1
      X0HD(1,2)  = X2
      VHD(1)     = V
      ETAHD(1,1) = ETAC
      ETAHD(1,2) = ETAD
      PTHD(1)    = PT
      Q2SCA(1,1) = QQPD
      Q2SCA(1,2) = QQPD
      NPROHD(1)  = MSPR
      NBRAHD(1,1)= IDPDG1
      NBRAHD(1,2)= IDPDG2
      DO 45 I=1,4
        PPH(I,1)   = PHI1(I)
        PPH(I,2)   = PHI2(I)
        PPH(4+I,1) = PHO1(I)
        PPH(4+I,2) = PHO2(I)
 45   CONTINUE
C  valence quarks
      IVAL1 = IV1
      IVAL2 = IV2
      PDFVA(1,1) = 0.D0
      PDFVA(1,2) = 0.D0
C  parton flavours
      IF(MSPR.LE.11) THEN
        NINHD(1,1) = IDPDG1
        NINHD(1,2) = IB
        PDFVA(1,2) = PDF2(IB)
        KHDIR = 1
      ELSE IF(MSPR.LE.13) THEN
        NINHD(1,1) = IA
        PDFVA(1,1) = PDF1(IA)
        NINHD(1,2) = IDPDG2
        KHDIR = 2
      ELSE
        NINHD(1,1) = IDPDG1
        NINHD(1,2) = IDPDG2
        KHDIR = 3
      ENDIF
      N0INHD(1,1) = NINHD(1,1)
      N0INHD(1,2) = NINHD(1,2)
      N0IVAL(1,1) = IVAL1
      N0IVAL(1,2) = IVAL2
      NOUTHD(1,1) = IC
      NOUTHD(1,2) = ID

C  reweight according to photon virtuality
      IF(MSPR.NE.14) THEN
        IF(IPAMDL(115).GE.1) THEN
          WGX = 1.D0
          IF(((MSPR.EQ.10).OR.(MSPR.EQ.11)).AND.(IDPDG2.EQ.22)) THEN
            QQPD = Q2SCA(1,2)
            IF(IPAMDL(115).EQ.1) THEN
              IF(QQPD.LT.(PVIRTP(2)+PARMDL(144))) THEN
                WGX = 0.D0
              ELSE
                WGX = LOG(QQPD/(PVIRTP(2)+PARMDL(144)))
     &               /LOG(QQPD/PARMDL(144))
              ENDIF
              IF(NINHD(1,2).EQ.0) WGX = WGX*WGX
            ELSE IF(IPAMDL(115).EQ.2) THEN
              CALL PHO_PDF(2,X2,QQPD,PVIRTP(2),PD1)
              WGX = PD1(IB)/PDFVA(1,2)
            ENDIF
          ELSE IF(((MSPR.EQ.12).OR.(MSPR.EQ.13))
     &            .AND.(IDPDG1.EQ.22)) THEN
            QQPD = Q2SCA(1,1)
            IF(IPAMDL(115).EQ.1) THEN
              IF(QQPD.LT.(PVIRTP(1)+PARMDL(144))) THEN
                WGX = 0.D0
              ELSE
                WGX = LOG(QQPD/(PVIRTP(1)+PARMDL(144)))
     &               /LOG(QQPD/PARMDL(144))
              ENDIF
              IF(NINHD(1,1).EQ.0) WGX = WGX*WGX
            ELSE IF(IPAMDL(115).EQ.2) THEN
              CALL PHO_PDF(1,X1,QQPD,PVIRTP(1),PD1)
              WGX = PD1(IA)/PDFVA(1,1)
            ENDIF
          ENDIF

          IF(IDEB(25).GE.25)
     &      WRITE(ErrorOut,
     * '(1X,2A,/5X,I10,I3,1P6E10.3)') 'PHO_HARDIR: ',
     &        'RE-WEIGHT WITH (EVE, MSPR, X1/2, Q2, PV1/2, W1/W2)',
     &        KEVENT,MSPR,X1,X2,QQPD,PVIRTP,WGX

          IF(WGX.LT.PHO_RNDM(WGX)) THEN
            IREJ = 50
            RETURN
          ENDIF

          IF(WGX.GT.1.01D0)
     &      WRITE(ErrorOut,
     * '(1X,2A,/5X,I10,I3,1P6E10.3)') 'PHO_HARDIR: ',
     &        'RE-WEIGHT >1 (EVE, MSPR, X1/2, Q2, PV1/2, W1/W2)',
     &        KEVENT,MSPR,X1,X2,QQPD,PVIRTP,WGX

        ENDIF
      ENDIF

C  generate ISR
      IF((MSPR.NE.14).AND.(ISWMDL(8).GE.2)) THEN
        IF(IPAMDL(109).EQ.1) THEN
          Q2H = PARMDL(93)*PT**2
        ELSE
          Q2H = -PARMDL(93)*VHD(1)*XHD(1,1)*XHD(1,2)*ECMP*ECMP
        ENDIF
        XHMAX1 =  1.D0 - XSS1 - AS + XHD(1,1)
        XHMAX2 =  1.D0 - XSS2 - AS + XHD(1,2)
        DO 42 J=1,4
          P1(J) = PPH(4+J,1)
          P2(J) = PPH(4+J,2)
 42     CONTINUE
        CALL PHO_HARISR(-1,P1,P2,NOUTHD(1,1),NOUTHD(1,2),N0INHD(1,1),
     &    N0INHD(1,2),N0IVAL(1,1),N0IVAL(1,2),Q2H,X0HD(1,1),X0HD(1,2),
     &    XHMAX1,XHMAX2,IFL1,IFL2,IVAL1,IVAL2,XISR1,XISR2,IREJ)
        XSS1 = XSS1+XISR1-XHD(1,1)
        XSS2 = XSS2+XISR2-XHD(1,2)
        NINHD(1,1) = IFL1
        NINHD(1,2) = IFL2
        XHD(1,1) = XISR1
        XHD(1,2) = XISR2
      ELSE
        IFL1 = NINHD(1,1)
        IFL2 = NINHD(1,2)
      ENDIF
      NIVAL(1,1) = IVAL1
      NIVAL(1,2) = IVAL2

C  add photon/hadron remnant

C  incoming gluon
      IF(IFL2.EQ.0) THEN
        XMAXX    = 1.D0 - XSS2 - AS
        XMAXH    = MIN(XMAXX,PARMDL(44))
        CALL PHO_HADSP2(IDBAM2,XSS2,XMAXH,XS2,IREJ)
        IVAL2 = 1
        MSPAR1 = 0
        MSPAR2 = 2
        MHPAR1 = 1
        MHPAR2 = 1
      ELSE IF(IFL1.EQ.0) THEN
        XMAXX    = 1.D0 - XSS1 - AS
        XMAXH    = MIN(XMAXX,PARMDL(44))
        CALL PHO_HADSP2(IDBAM1,XSS1,XMAXH,XS1,IREJ)
        IVAL1 = 1
        MSPAR1 = 2
        MSPAR2 = 0
        MHPAR1 = 1
        MHPAR2 = 1

C  incoming quark
      ELSE IF(ABS(IFL2).LE.12) THEN
        IF(IVAL2.EQ.1) THEN
          XS2(1) = 1.D0 - XSS2
          MSPAR1 = 0
          MSPAR2 = 1
          MHPAR1 = 1
          MHPAR2 = 1
        ELSE
          XMAXX    = 1.D0 - XSS2 - AS
          XMAXH    = MIN(XMAXX,PARMDL(44))
          CALL PHO_HADSP3(IDBAM2,XSS2,XMAXH,XS2,IREJ)
          MSPAR1 = 0
          MSPAR2 = 3
          MHPAR1 = 1
          MHPAR2 = 1
        ENDIF
      ELSE IF(ABS(IFL1).LE.12) THEN
        IF(IVAL1.EQ.1) THEN
          XS1(1) = 1.D0 - XSS1
          MSPAR1 = 1
          MSPAR2 = 0
          MHPAR1 = 1
          MHPAR2 = 1
        ELSE
          XMAXX    = 1.D0 - XSS1 - AS
          XMAXH    = MIN(XMAXX,PARMDL(44))
          CALL PHO_HADSP3(IDBAM1,XSS1,XMAXH,XS1,IREJ)
          MSPAR1 = 3
          MSPAR2 = 0
          MHPAR1 = 1
          MHPAR2 = 1
        ENDIF

C  double direct process
      ELSE IF(MSPR.EQ.14) THEN
        MSPAR1 = 0
        MSPAR2 = 0
        MHPAR1 = 1
        MHPAR2 = 1

C  unknown process
      ELSE
        WRITE(ErrorOut,'(/1X,A,I3/)')
     &    'PHO_HARDIR:ERROR: UNSUPPORTED HARD PROCESS (MSPR)',MSPR
        CALL PHO_ABORT
      ENDIF

      IF(IREJ.NE.0) THEN
        IF(IDEB(25).GE.3) WRITE(ErrorOut,'(1X,A,3I5)')
     &    'PHO_HARDIR: INT. REJECTION (MSPR,ITRY,NTRY)',MSPR,ITRY,NTRY
        GOTO 120
      ENDIF

C  soft particle momenta
      IF(MSPAR1.GT.0) THEN
        DO 50 I=1,MSPAR1
          PSOFT1(1,I) = 0.D0
          PSOFT1(2,I) = 0.D0
          PSOFT1(3,I) = XS1(I)*ECMP/2.D0
          PSOFT1(4,I) = XS1(I)*ECMP/2.D0
 50     CONTINUE
      ENDIF
      IF(MSPAR2.GT.0) THEN
        DO 55 I=1,MSPAR2
          PSOFT2(1,I) = 0.D0
          PSOFT2(2,I) = 0.D0
          PSOFT2(3,I) = -XS2(I)*ECMP/2.D0
          PSOFT2(4,I) = XS2(I)*ECMP/2.D0
 55     CONTINUE
      ENDIF
C  process counting
      MH_ACC_1(MSPR,II) = MH_ACC_1(MSPR,II)+1
      KSOFT = MAX(MSPAR1,MSPAR2)
      KHARD = MAX(MHPAR1,MHPAR2)
C  debug output
      IF(IDEB(25).GE.10) THEN
        WRITE(ErrorOut,'(/1X,A,2I3,3I5)')
     &    'PHO_HARDIR: ACCEPTED IVAL1,IVAL2,MSPR,ITRY,NTRY',
     &     IVAL1,IVAL2,MSPR,ITRY,NTRY
        IF(MSPAR1.GT.0) THEN
          WRITE(ErrorOut,
     * '(5X,A,I4)') 'soft x particle 1:',MSPAR1
          DO 105 I=1,MSPAR1
            WRITE(ErrorOut,'(10X,I3,E12.3)') I,XS1(I)
 105      CONTINUE
        ENDIF
        IF(MSPAR2.GT.0) THEN
          WRITE(ErrorOut,
     * '(5X,A,I4)') 'soft x particle 2:',MSPAR2
          DO 106 I=1,MSPAR2
            WRITE(ErrorOut,'(10X,I3,E12.3)') I,XS2(I)
 106      CONTINUE
        ENDIF
        WRITE(ErrorOut,
     * '(5X,A,I4)') 'ini.hard X/flavor particle 1:',MHPAR1
        WRITE(ErrorOut,
     * '(10X,I3,E12.3,I8)') 1,XHD(1,1),NINHD(1,1)
        WRITE(ErrorOut,
     * '(5X,A,I4)') 'fin.hard momenta  particle 1:',MHPAR1
        WRITE(ErrorOut,
     * '(10X,I3,4E12.3,I8)') 1,(PPH(K,1),K=5,8),NOUTHD(1,1)
        WRITE(ErrorOut,
     * '(5X,A,I4)') 'ini.hard X/flavour particle 2:',MHPAR2
        WRITE(ErrorOut,
     * '(10X,I3,E12.3,I8)') 1,XHD(1,2),NINHD(1,2)
        WRITE(ErrorOut,
     * '(5X,A,I4)') 'fin.hard momenta  particle 2:',MHPAR2
        WRITE(ErrorOut,
     * '(10X,I3,4E12.3,I8)') 1,(PPH(K,2),K=5,8),NOUTHD(1,2)
      ENDIF
      RETURN

 450  CONTINUE
      IFAIL(16) = IFAIL(16)+1
      IF(IDEB(25).GE.2) THEN
        WRITE(ErrorOut,'(1X,A,3I5)')
     &    'PHO_HARDIR: REJECTION (ITRY,NTRY,IREJ)',ITRY,NTRY,IREJ
       WRITE(ErrorOut,'(5X,A,E12.4)') 'available energy:',ECMP
       IF(IDEB(25).GE.5) THEN
         CALL PHO_PREVNT(0)
       ELSE
         CALL PHO_PREVNT(-1)
       ENDIF
      ENDIF

      END


CDECK  ID>, PHO_POMSCA
      SUBROUTINE PHO_POMSCA(II,MSPOM,MHPOM,MSREG,IVAL1,IVAL2,
     &                     MSPAR1,MSPAR2,MHPAR1,MHPAR2,IREJ)
C**********************************************************************
C
C     parton orientated formulation of soft and hard inelastic events
C
C
C     input:    II        particle combiantion (1..4)
C               MSPOM     number of soft pomerons
C               MHPOM     number of semihard pomerons
C               MSREG     number of soft reggeons
C
C     output:   IVAL1,2   0 no valence quark engaged
C                         otherwise:  position of valence quark engaged
C                         neg.number: gluon connected to valence quark
C                                     by color flow
C               MSPAR1,2  number of realized soft partons
C               MHPAR1,2  number of realized hard partons
C               IREJ      1 failure
C                         0 success
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER (TINY   =  1.D-30 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  some hadron information, will be deleted in future versions
      INTEGER NFS
      DOUBLE PRECISION QMASS,BET,PCOUDI,PNORM,VALPRG
      COMMON /POHDRN/ QMASS(6),BET,PCOUDI,PNORM,VALPRG(2),NFS

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  light-cone x fractions and c.m. momenta of soft cut string ends
      INTEGER MAXSOF
      PARAMETER ( MAXSOF = 50 )
      INTEGER IJSI2,IJSI1
      DOUBLE PRECISION XS1,XS2,PSOFT1,PSOFT2
      COMMON /POSOFT/ XS1(MAXSOF),XS2(MAXSOF),
     &                PSOFT1(4,MAXSOF),PSOFT2(4,MAXSOF),
     &                IJSI1(MAXSOF),IJSI2(MAXSOF)

C  hard scattering data
      INTEGER MSCAHD
      PARAMETER ( MSCAHD = 50 )
      INTEGER LSCAHD,LSC1HD,LSIDX,
     &        NINHD,N0INHD,NIVAL,N0IVAL,NOUTHD,NBRAHD,NPROHD
      DOUBLE PRECISION PPH,PTHD,ETAHD,Q2SCA,PDFVA,XHD,VHD,X0HD
      COMMON /POHSLT/ LSCAHD,LSC1HD,LSIDX(MSCAHD),
     &                PPH(8*MSCAHD,2),PTHD(MSCAHD),ETAHD(MSCAHD,2),
     &                Q2SCA(MSCAHD,2),PDFVA(MSCAHD,2),
     &                XHD(MSCAHD,2),VHD(MSCAHD),X0HD(MSCAHD,2),
     &                NINHD(MSCAHD,2),N0INHD(MSCAHD,2),
     &                NIVAL(MSCAHD,2),N0IVAL(MSCAHD,2),
     &                NOUTHD(MSCAHD,2),NBRAHD(MSCAHD,2),NPROHD(MSCAHD)

C  table of particle indices for recursive PHOJET calls
      INTEGER MAXIPX
      PARAMETER ( MAXIPX = 100 )
      INTEGER IPOPOS,IPORES,IPOIX1,IPOIX2,IPOIX3
      COMMON /PORECU/ IPOPOS(2,MAXIPX),IPORES(MAXIPX),
     &                IPOIX1,IPOIX2,IPOIX3

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)


      DIMENSION P1(4),P2(4),PD1(-6:6)

      IF(IDEB(24).GT.20) WRITE(ErrorOut,'(1X,A,3I5)')
     &  'PHO_POMSCA: MSPOM,MHPOM,MSREG',MSPOM,MHPOM,MSREG

      ITRY  = 0
      NTRY  = 10
      IREJ  = 0
      INMAX = 10
      MHARD = MHPOM

C  phase space limitation (single hard valence-valence quark scattering)
      IF(MHPOM.GT.0) THEN
        EMIN = 2.D0*PTWANT + 0.2D0
        IF(ECMP.LT.EMIN) THEN
          IF(IDEB(24).GE.1) WRITE(ErrorOut,
     * '(1X,A,1P,3E10.3)') 'PHO_POMSCA: ',
     &      'KIN. REJECTION (1) (ECM,PTCUT,EMIN)',ECMP,PTWANT,EMIN
          IREJ = 50
          IFAIL(6) = IFAIL(6) + 1
          RETURN
        ENDIF
      ENDIF

      SAS    = PARMDL(160+II)/ECMP
      SAH    = 2.D0*PTWANT/ECMP
      AS     = SAS**2
      AH     = SAH**2

C  save energy for leading particle effect
      XMAXP1 = 1.D0
      IF(IHFLS(1).NE.0) XMAXP1 = 1.D0-PARMDL(165)*XPSUB
      XMAXP2 = 1.D0
      IF(IHFLS(2).NE.0) XMAXP2 = 1.D0-PARMDL(165)*XTSUB

C
C  main loop to select hard and soft parton kinematics
C -----------------------------------------------------
      IFAIL(31) = IFAIL(31)+MHARD
 20   CONTINUE
        IREJ  = 0
        IHARD = 0
        LSC1HD = 0
        ITRY  = ITRY+1
        IF(ITRY.GT.1) IFAIL(5) = IFAIL(5)+1
        IF(ITRY.GE.NTRY) THEN
          IREJ = 1
          GOTO 450
        ENDIF
        LINE   = 0
        LSCAHD = 0
        IF((IPAMDL(13).GT.0).AND.(IPOIX3.EQ.0).AND.(IPROCE.EQ.1)) THEN
          XSS1   = MAX(0.D0,1.D0-XPSUB)
          XSS2   = MAX(0.D0,1.D0-XTSUB)
        ELSE
          XSS1   = 0.D0
          XSS2   = 0.D0
        ENDIF
 22     CONTINUE

C  partons needed to construct soft/hard interactions
        MSPAR1 = 2*MSPOM+MSREG+MHPOM
        MSPAR2 = MSPAR1
        MHPAR1 = MHPOM
        MHPAR2 = MHPOM

C  number of strings
        MSCHA = 2*MSPOM+MSREG
        MHCHA = 2*MHPOM

        KSOFT = MSCHA
        KHARD = MHCHA

C  check actual phase space limit
        XX = SAS*DBLE(MSCHA)+SAH*DBLE(MHCHA)/2.D0
        IF(XX.GE.1.D0) THEN
          IF(IDEB(24).GE.3) WRITE(ErrorOut,
     * '(1X,2A,/1X,4I3,1P4E12.4)')
     &      'PHO_POMSCA: INTERNAL KIN. REJECTION ',
     &      '(MSPOM,MHPOM,MSCHAIN,MHCHAIN,ECM,AS,AH,XX):',
     &      MSPOM,MHPOM,MSCHA,MHCHA,ECMP,AS,AH,XX
          IF(MSPOM+MSREG+MHPOM.GT.1) THEN
            IF(MSREG.GT.0) THEN
              MSREG = MSREG-1
            ELSE IF(MSPOM.GT.0) THEN
              MSPOM = MSPOM-1
            ELSE IF(MHPOM.GT.1) THEN
              MHPOM = MHPOM-1
            ENDIF
            GOTO 22
          ENDIF
          IF(IDEB(24).GE.1) WRITE(ErrorOut,'(1X,A,1P2E10.3)')
     &      'PHO_POMSCA: KIN. REJECTION (2) (ECM,PTCUT)',ECMP,PTWANT
          IREJ = 50
          IFAIL(6) = IFAIL(6) + 1
          RETURN
        ENDIF

        XMAXX1 = MAX(TINY,1.D0-MIN(MSPAR1,1)*AS-MIN(MHPAR1,1)*AH)
        XMAXX2 = MAX(TINY,1.D0-MIN(MSPAR2,1)*AS-MIN(MHPAR2,1)*AH)

C  very low energy phase space restriction
        IF(MHARD.GT.0) THEN
          IF((XMAXX1*XMAXX2.LE.AH)) THEN
            IF(IDEB(24).GE.1) WRITE(ErrorOut,'(1X,A,1P2E10.3)')
     &        'PHO_POMSCA: KIN. REJECTION (3) (ECM,PTCUT)',ECMP,PTWANT
            IREJ = 50
            IFAIL(6) = IFAIL(6) + 1
            RETURN
          ENDIF
        ENDIF

        AS = MAX(AS,PSOMIN/PCMP)
        ALNS  = LOG(AS)
        ALNH  = LOG(AH)
        Z1MAX = LOG(XMAXX1)
        Z2MAX = LOG(XMAXX2)
        Z1DIF = Z1MAX+Z2MAX-ALNH
        Z2DIF = Z1DIF
        PTMAX = 0.D0
C
C  select hard parton momenta
C ------------------- begin of inner loop -------------------
        IF(IPOIX3.EQ.0) IPOWGC(4+II) = 0

        IF(MHARD.GT.MSCAHD) THEN
          WRITE(ErrorOut,'(1X,2A,2I3)') 'PHO_POMSCA: ',
     &      'NO SPACE LEFT IN /POHSLT/ (MHARD,MSCAHD):',MHARD,MSCAHD
          IREJ = 1
          RETURN
        ENDIF

        DO 11 NN=1,MHARD
C
C  generate one resolved hard scattering
C
C  high-pt option
          IF((NN.EQ.1).AND.(II.EQ.1).AND.(HSWCUT(4+II).GT.PTWANT)) THEN
            CALL PHO_HARINT(-1,ECMP,PVIRTP(1),PVIRTP(2),
     &                  -1,MAX_PRO_2,1,4,MSPOM+MHPOM)
            XSCUT = HSIG(9)
            AHS    = AH
            ALNHS  = ALNH
            Z1DIFS = Z1DIF
            Z2DIFS = Z2DIF
            AH    = (2.D0*PTWANT/ECMP)**2
            ALNH  = LOG(AH)
            Z1DIF = Z1MAX+Z2MAX-ALNH
            Z2DIF = Z1DIF
            IF((Z1DIF.LE.0.01D0).OR.(Z2DIF.LE.0.01D0)) THEN
              IF(IDEB(24).GE.1) WRITE(ErrorOut,
     * '(1X,2A,/1X,1P4E12.3)')
     &          'PHO_POMSCA: KIN.REJECTION, HIGH-PT OPTION ',
     &          '(Z1/2MAX,ALNH,Z1DIF):',Z1MAX,Z2MAX,ALNH,Z1DIF
              IREJ = 5
              RETURN
            ENDIF
            CALL PHO_HARSCA(2,II)
            CALL PHO_HARINT(1,ECMP,PVIRTP(1),PVIRTP(2),
     &                  -1,MAX_PRO_2,1,4,MSPOM+MHPOM)
            AH    = AHS
            ALNH  = ALNHS
            Z1DIF = Z1DIFS
            Z2DIF = Z2DIFS
            IPOWGC(4+II) = IPOWGC(4+II)+1
            HSWGHT(4+II) = XSCUT/HSIG(9)*DBLE(MHARD)
C  minimum bias option
          ELSE
            CALL PHO_HARSCA(2,II)
          ENDIF

C  fill /POHSLT/
          LSIDX(NN)    = NN
          LSCAHD       = NN
          XHD(NN,1)    = X1
          XHD(NN,2)    = X2
          X0HD(NN,1)   = X1
          X0HD(NN,2)   = X2
          VHD(NN)      = V
          ETAHD(NN,1)  = ETAC
          ETAHD(NN,2)  = ETAD
          PTHD(NN)     = PT
          NPROHD(NN)   = MSPR
          Q2SCA(NN,1)  = QQPD
          Q2SCA(NN,2)  = QQPD
          PDFVA(NN,1)  = PDF1(IA)
          PDFVA(NN,2)  = PDF2(IB)
          NINHD(NN,1)  = IA
          NINHD(NN,2)  = IB
          N0INHD(NN,1) = IA
          N0INHD(NN,2) = IB
          NIVAL(NN,1)  = IV1
          NIVAL(NN,2)  = IV2
          N0IVAL(NN,1) = IV1
          N0IVAL(NN,2) = IV2
          NOUTHD(NN,1) = IC
          NOUTHD(NN,2) = ID
          NBRAHD(NN,1) = IDPDG1
          NBRAHD(NN,2) = IDPDG2
          I3 = 8*(NN-1)
          I4 = 8*(NN-1)+4
          DO 50 I=1,4
            PPH(I3+I,1) = PHI1(I)
            PPH(I3+I,2) = PHI2(I)
            PPH(I4+I,1) = PHO1(I)
            PPH(I4+I,2) = PHO2(I)
 50       CONTINUE

 11     CONTINUE

C  sort according to pt-hat
        DO 12 NN=1,MHARD
          PTMX = PTHD(LSIDX(NN))
          IPTM = NN
          DO 13 I=NN+1,MHARD
            IF(PTHD(LSIDX(I)).GT.PTMX) THEN
              IPTM = I
              PTMX = PTHD(LSIDX(I))
            ENDIF
 13       CONTINUE
          IF(IPTM.NE.NN) CALL PHO_SWAPI(LSIDX(NN),LSIDX(IPTM))
 12     CONTINUE
        IPTM = LSIDX(1)

C  copy partons, generate ISR
        DO 15 L=1,MHARD
          NN = LSIDX(L)
          XSSS1  = XSS1+XHD(NN,1)
          XSSS2  = XSS2+XHD(NN,2)
C  debug output
          IF(IDEB(24).GE.10) WRITE(ErrorOut,
     * '(1X,A,3I4,1P,3E11.3)')
     &      'PHO_POMSCA: NR,LSIDX,MSPR,X1,X2,PT',
     &      L,NN,NPROHD(NN),XHD(NN,1),XHD(NN,2),PTHD(NN)
C  check phase space
          IF(    (XSSS1.GT.XMAXX1)
     &       .OR.(XSSS2.GT.XMAXX2)
     &       .OR.((1.D0-XSSS1)*(1.D0-XSSS2).LT.AS) ) THEN
            IF(IHARD.EQ.0) THEN
              IF(ISWMDL(2).NE.1) GOTO 20
              MHPOM = 0
              MSPOM = 1
              MSREG = 0
            ENDIF
            GOTO 199
          ENDIF

C  reweight according to photon virtuality
          IF(IPAMDL(115).GE.1) THEN
            QQPD = Q2SCA(NN,1)
            WGX = 1.D0
            IF(IDPDG1.EQ.22) THEN
              IF(IPAMDL(115).EQ.1) THEN
                IF(QQPD.LT.PVIRTP(1)+PARMDL(144)) THEN
                  WG1 = 0.D0
                ELSE
                  WG1 = LOG(QQPD/(PVIRTP(1)+PARMDL(144)))
     &                 /LOG(QQPD/PARMDL(144))
                ENDIF
                IF(NINHD(NN,1).EQ.0) WG1 = WG1*WG1
              ELSE IF(IPAMDL(115).EQ.2) THEN
                CALL PHO_PDF(1,X0HD(NN,1),QQPD,PVIRTP(1),PD1)
                WG1 = PD1(NINHD(NN,1))/PDFVA(NN,1)
              ENDIF
              WGX = WG1
            ENDIF
            QQPD = Q2SCA(NN,2)
            IF(IDPDG2.EQ.22) THEN
              IF(IPAMDL(115).EQ.1) THEN
                IF(QQPD.LT.PVIRTP(2)+PARMDL(144)) THEN
                  WG1 = 0.D0
                ELSE
                  WG1 = LOG(QQPD/(PVIRTP(2)+PARMDL(144)))
     &                 /LOG(QQPD/PARMDL(144))
                ENDIF
                IF(NINHD(NN,2).EQ.0) WG1 = WG1*WG1
              ELSE IF(IPAMDL(115).EQ.2) THEN
                CALL PHO_PDF(2,X0HD(NN,2),QQPD,PVIRTP(2),PD1)
                WG1 = PD1(NINHD(NN,2))/PDFVA(NN,2)
              ENDIF
              WGX = WGX*WG1
            ENDIF

            IF(IDEB(24).GE.25)
     &        WRITE(ErrorOut,
     * '(1X,2A,/5X,I10,I3,1P6E10.3)') 'PHO_POMSCA: ',
     &          ' RE-WEIGHT WITH (EVE, MSPR, X1/2, Q2, PV1/2, W1/W2)',
     &          KEVENT,MSPR,X0HD(NN,1),X0HD(NN,2),QQPD,PVIRTP,WGX

            IF(WGX.LT.PHO_RNDM(WGX)) THEN
              IF(L.EQ.1) THEN
                IREJ = 50
                RETURN
              ELSE
                GOTO 199
              ENDIF
            ENDIF

            IF(WGX.GT.1.D0) WRITE(ErrorOut,
     * '(1X,2A,/5X,I10,I3,1P6E10.3)')
     &        'PHO_POMSCA: ',
     &        'WEIGHT >1 (EVE, MSPR, X1/2, Q2, PV1/2, W1/W2)',
     &        KEVENT,MSPR,X0HD(NN,1),X0HD(NN,2),QQPD,PVIRTP,WGX

          ENDIF

C  generate ISR
          IF((ISWMDL(8).GE.2)
     &       .AND.((IPAMDL(101).NE.1).OR.(L.EQ.1))) THEN
            IF(IPAMDL(109).EQ.1) THEN
              Q2H = PARMDL(93)*PTHD(NN)**2
            ELSE
              Q2H = -PARMDL(93)*VHD(NN)
     &              *XHD(NN,1)*XHD(NN,2)*ECMP*ECMP
            ENDIF
            XHMAX1 = 1.D0 - XSSS1 - MSCHA*AS + XHD(NN,1)
            XHMAX2 = 1.D0 - XSSS2 - MSCHA*AS + XHD(NN,2)
            I3     = 8*NN-4
            DO 42 J=1,4
              P1(J) = PPH(I3+J,1)
              P2(J) = PPH(I3+J,2)
 42         CONTINUE
            IF(IDEB(24).GE.10)
     &        WRITE(ErrorOut,'(1X,A,/5X,2I3,1P,3E12.4)')
     &          'PHO_POMSCA: GENERATE ISR FOR (L,NN,X1,X2,Q2H)',
     &          L,NN,XHD(NN,1),XHD(NN,2),Q2H
            J = NN
            IF(L.EQ.1) J = -NN
            CALL PHO_HARISR(J,P1,P2,NOUTHD(NN,1),NOUTHD(NN,2),
     &        N0INHD(NN,1),N0INHD(NN,2),N0IVAL(NN,1),N0IVAL(NN,2),Q2H,
     &        X0HD(NN,1),X0HD(NN,2),XHMAX1,XHMAX2,IFL1,IFL2,
     &        NIVAL(NN,1),NIVAL(NN,2),XISR1,XISR2,IREJ)
            XSSS1 = XSSS1+XISR1-XHD(NN,1)
            XSSS2 = XSSS2+XISR2-XHD(NN,2)
            NINHD(NN,1) = IFL1
            NINHD(NN,2) = IFL2
            XHD(NN,1) = XISR1
            XHD(NN,2) = XISR2
          ENDIF

C  check phase space
          IF(    (XSSS1.GT.XMAXX1)
     &       .OR.(XSSS2.GT.XMAXX2)
     &       .OR.((1.D0-XSSS1)*(1.D0-XSSS2).LT.AS) ) THEN
            IF(IHARD.EQ.0) THEN
              IF(ISWMDL(2).NE.1) GOTO 20
              MHPOM = 0
              MSPOM = 1
              MSREG = 0
            ENDIF
            GOTO 199
          ENDIF

C  leave energy for leading particle effect
          IF((IHARD.GT.0).AND.
     &       ((XSSS1.GT.XMAXP1).OR.(XSSS2.GT.XMAXP2))) THEN
            GOTO 199
          ENDIF

C  hard scattering accepted
          IHARD = IHARD+1
          XSS1 = XSSS1
          XSS2 = XSSS2
          IFAIL(31) = IFAIL(31)-1

 15     CONTINUE

C ------------------- end of inner (hard) loop -------------------
 199    CONTINUE


        MHPOM =  IHARD
        MHPAR1 = IHARD
        MHPAR2 = IHARD

C  count valences involved in hard scattering
        IVAL1  = 0
        IVAL2  = 0
        DO 17 L=1,IHARD
          NN = LSIDX(L)
          IF((NIVAL(NN,1).NE.0).AND.(IVAL1.EQ.0)) IVAL1 = NN
          IF((NIVAL(NN,2).NE.0).AND.(IVAL2.EQ.0)) IVAL2 = NN
 17     CONTINUE

        IQUA1  = 0
        IQUA2  = 0
        IVGLU1 = 0
        IVGLU2 = 0
        DO 18 L=1,IHARD
          NN = LSIDX(L)

C  photon, pomeron valences
          IF((IVAL1.EQ.0).AND.(NINHD(NN,1).NE.0)) THEN
            IF((IDPDG1.EQ.22).OR.(IDPDG1.EQ.990)) THEN
              NIVAL(NN,1) = 1
              IVAL1 = NN
            ENDIF
          ENDIF
          IF((IVAL2.EQ.0).AND.(NINHD(NN,2).NE.0)) THEN
            IF((IDPDG2.EQ.22).OR.(IDPDG2.EQ.990)) THEN
              NIVAL(NN,2) = 1
              IVAL2 = NN
            ENDIF
          ENDIF

C  total number of quarks
          IF(NINHD(NN,1).NE.0) THEN
            IQUA1 = IQUA1+1
          ELSE IF(IVGLU1.EQ.0) THEN
            IVGLU1 = NN
          ENDIF
          IF(NINHD(NN,2).NE.0) THEN
            IQUA2 = IQUA2+1
          ELSE IF(IVGLU2.EQ.0) THEN
            IVGLU2 = NN
          ENDIF
 18     CONTINUE

C  gluons emitted by valence quarks
        VALPRO = 1.D0
        IF(II.EQ.1) VALPRO = VALPRG(1)
        IVQ1 = 1
        IVG1 = 0
        IVAL1 = MAX(IVAL1,0)
        IF(IVAL1.EQ.0) THEN
          IVQ1 = 0
          IF((IVGLU1.NE.0).AND.(PHO_RNDM(XSS1).LT.VALPRO)) THEN
            IVAL1 = -IVGLU1
            IVG1 = 1
          ENDIF
        ENDIF
        VALPRO = 1.D0
        IF(II.EQ.1) VALPRO = VALPRG(2)
        IVQ2 = 1
        IVG2 = 0
        IVAL2 = MAX(IVAL2,0)
        IF(IVAL2.EQ.0) THEN
          IVQ2 = 0
          IF((IVGLU2.NE.0).AND.(PHO_RNDM(XSS2).LT.VALPRO)) THEN
            IVAL2 = -IVGLU2
            IVG2 = 1
          ENDIF
        ENDIF
        MSPOM = MAX(0,MSPOM-IQUA1-IQUA2)
C  debug output
        IF(IDEB(24).GE.5) WRITE(ErrorOut,'(1X,A,6I4)')
     &    'PHO_POMSCA: IVAL1/2,IQUA1/2,IVGLU1/2',
     &    IVAL1,IVAL2,IQUA1,IQUA2,IVGLU1,IVGLU2

C  select soft X values
 25     CONTINUE
C  number of soft/remnant quarks
        IF(MSPOM.EQ.0) THEN
          IF(IPAMDL(18).EQ.0) THEN
            MSPAR1 = 2+2*MHPOM+MSREG-IQUA1-2*IVQ1-2*IVG1
            MSPAR2 = 2+2*MHPOM+MSREG-IQUA2-2*IVQ2-2*IVG2
          ELSE
            MSPAR1 = 2+MSREG+IQUA1-2*IVQ1
            MSPAR2 = 2+MSREG+IQUA2-2*IVQ2
          ENDIF
        ELSE
          IF(IPAMDL(18).EQ.0) THEN
            MSPAR1 = 2*MSPOM+MSREG+2*MHPOM-IQUA1
            MSPAR2 = 2*MSPOM+MSREG+2*MHPOM-IQUA2
          ELSE
            MSPAR1 = 2*MSPOM+MSREG+IQUA1+2*IVG1
            MSPAR2 = 2*MSPOM+MSREG+IQUA2+2*IVG2
          ENDIF
        ENDIF
C  debug output
        IF(IDEB(24).GE.15) WRITE(ErrorOut,'(1X,A,9I3)')
     &    'PHO_POMSCA: MSP,MSR,MHP,IVQ1/2,IVG1/2,MSPAR1/2',
     &    MSPOM,MSREG,MHPOM,IVQ1,IVQ2,IVG1,IVG2,MSPAR1,MSPAR2

        XMAX1  = 1.D0 - MAX(MSPAR1-1,0)*AS - XSS1
        XMAX2  = 1.D0 - MAX(MSPAR2-1,0)*AS - XSS2
        I1 = IVQ1
        I2 = IVQ2
        IF(IVAL1.LE.0) I1 = 0
        IF(IVAL2.LE.0) I2 = 0
        IF((IVQ1+IVG1)*(IVQ2+IVG2).NE.0) THEN
          MSDIFF = 2*MSPOM
        ELSE
          MSDIFF = 2*MAX(0,MSPOM-1)
        ENDIF
        MSG1 = MSPAR1
        MSG2 = MSPAR2
        MSM1 = MSPAR1-MSDIFF
        MSM2 = MSPAR2-MSDIFF
        XMAXH1 = MIN(XMAX1,PARMDL(44))
        XMAXH2 = MIN(XMAX2,PARMDL(44))
        CALL PHO_SOFTXX(NPOSP(1),NPOSP(2),MSG1,MSG2,I1,I2,MSM1,MSM2,
     &              XSS1,XSS2,XMAXH1,XMAXH2,XS1,XS2,IREJ)

C  correct for proper simulation of high pt tail
        IF(IREJ.NE.0) THEN
          IF(IDEB(48).GE.2) WRITE(ErrorOut,'(1X,A,4I4)')
     &      'PHO_STDPAR: REJECTION (PHO_SOFTXX): MSPOM,MHPOM,I1,I2',
     &      MSPOM,MHPOM,I1,I2
          IF(MSPOM*MHPOM.GT.0) THEN
            MSPOM = MSPOM-1
            GOTO 25
          ELSE IF(MSPOM.GT.1) THEN
            MSPOM = MSPOM-1
            GOTO 25
          ELSE IF(MHPOM.GT.1) THEN
            IHARD = IHARD-1
            IF((IPAMDL(13).GT.0).AND.(IPOIX3.EQ.0)
     &         .AND.(IPROCE.EQ.1)) THEN
              XSS1   = MAX(0.D0,1.D0-XPSUB)
              XSS2   = MAX(0.D0,1.D0-XTSUB)
            ELSE
              XSS1   = 0.D0
              XSS2   = 0.D0
            ENDIF
            DO 103 K=1,IHARD
              I = LSIDX(K)
              XSS1 = XSS1+ XHD(I,1)
              XSS2 = XSS2+ XHD(I,2)
 103        CONTINUE
            GOTO 199
          ENDIF
          IREJ = 4
          GOTO 450
        ENDIF
C  accepted
        MSPOM  = MSPOM-(MSPAR1-MSG1)/2
        MSPAR1 = MSG1
        MSPAR2 = MSG2
C  ------------ kinematics sampled ---------------
C  debug output
        IF(IDEB(24).GE.10) THEN
          WRITE(ErrorOut,'(1X,A,I3)')
     &      'PHO_POMSCA: SOFT X VALUES, ITRY',ITRY
          DO 104 I=2,MAX(MSPAR1,MSPAR2)
            WRITE(ErrorOut,'(10X,I3,2E12.3)') I,XS1(I),XS2(I)
 104      CONTINUE
        ENDIF
      IF((1.D0-XSS1)*(1.D0-XSS2).LT.AS) GOTO 20

C  end of loop
      XS1(1) = 1.D0 - XSS1
      XS2(1) = 1.D0 - XSS2

C  process counting
      DO 30 N=1,LSCAHD
        MH_ACC_1(NPROHD(N),II) = MH_ACC_1(NPROHD(N),II)+1
 30   CONTINUE

C  soft particle momenta

      IF(MAX(MSPAR1,MSPAR2).GT.MAXSOF) THEN
        WRITE(ErrorOut,
     * '(1X,2A,3I4)') 'PHO_POMSCA: no space left in ',
     &    '/POSOFT/ (MSPAR1/2,MAXSOF):',MSPAR1,MSPAR2,MAXSOF
        IREJ = 1
        RETURN
      ENDIF

      DO 55 I=1,MSPAR1
        PSOFT1(1,I) = 0.D0
        PSOFT1(2,I) = 0.D0
        PSOFT1(3,I) = XS1(I)*ECMP/2.D0
        PSOFT1(4,I) = XS1(I)*ECMP/2.D0
 55   CONTINUE
      DO 60 I=1,MSPAR2
        PSOFT2(1,I) = 0.D0
        PSOFT2(2,I) = 0.D0
        PSOFT2(3,I) = -XS2(I)*ECMP/2.D0
        PSOFT2(4,I) = XS2(I)*ECMP/2.D0
 60   CONTINUE

      KSOFT = MAX(MSPAR1,MSPAR2)
      KHARD = MAX(MHPAR1,MHPAR2)
      KSPOM = MSPOM
      KSREG = MSREG
      KHPOM = MHPOM

C  debug output
      IF(IDEB(24).GE.10) THEN
        WRITE(ErrorOut,'(/1X,A,2I3,2I5)')
     &    'PHO_POMSCA: ACCEPTED IVAL1,IVAL2,ITRY,NTRY',
     &     IVAL1,IVAL2,ITRY,NTRY
        IF(MSPAR1+MSPAR2.GT.0) THEN
          WRITE(ErrorOut,
     * '(5X,A)') 'soft x particle1   particle2:'
          XTMP1 = 0.D0
          XTMP2 = 0.D0
          DO 105 I=1,MAX(MSPAR1,MSPAR2)
            IF(I.LE.MIN(MSPAR1,MSPAR2)) THEN
              WRITE(ErrorOut,'(10X,I3,2E13.4)') I,XS1(I),XS2(I)
              XTMP1 = XTMP1+XS1(I)
              XTMP2 = XTMP2+XS2(I)
            ELSE IF(I.LE.MSPAR1) THEN
              WRITE(ErrorOut,'(10X,I3,2E13.4)') I,XS1(I),0.D0
              XTMP1 = XTMP1+XS1(I)
            ELSE IF(I.LE.MSPAR2) THEN
              WRITE(ErrorOut,'(10X,I3,2E13.4)') I,0.D0,XS2(I)
              XTMP2 = XTMP2+XS2(I)
            ENDIF
 105      CONTINUE
          WRITE(ErrorOut,
     * '(5X,A,2E13.4)') 'sum X1/2 (soft):',XTMP1,XTMP2
        ENDIF
        IF(MHPAR1.GT.0) THEN
          WRITE(ErrorOut,'(5X,A)')
     &      'NR  IDX  MSPR HARD X / HARD X ISR / FLAVOR PARTICLE 1,2:'
          DO 107 K=1,MHPAR1
            I = LSIDX(K)
            WRITE(ErrorOut,'(5X,3I3,4E12.3,2I3)')
     &        K,I,NPROHD(I),X0HD(I,1),X0HD(I,2),XHD(I,1),XHD(I,2),
     &        NINHD(I,1),NINHD(I,2)
              XTMP1 = XTMP1+XHD(I,1)
              XTMP2 = XTMP2+XHD(I,2)
 107      CONTINUE
          WRITE(ErrorOut,
     * '(1X,A,2E13.4)') 'sum X1/2 (soft+hard):',XTMP1,XTMP2
          WRITE(ErrorOut,'(5X,A)') 'hard momenta  particle1:'
          DO 108 K=1,MHPAR1
            I = LSIDX(K)
            I3 = 8*I-4
            WRITE(ErrorOut,
     * '(5X,2I3,1P,4E12.3,I5)') K,I,(PPH(I3+L,1),L=1,4),
     &        NOUTHD(I,1)
 108      CONTINUE
          WRITE(ErrorOut,'(5X,A)') 'hard momenta  particle2:'
          DO 110 K=1,MHPAR2
            I = LSIDX(K)
            I3 = 8*I-4
            WRITE(ErrorOut,
     * '(5X,2I3,1P,4E12.3,I5)') K,I,(PPH(I3+L,2),L=1,4),
     &        NOUTHD(I,2)
 110      CONTINUE
        ENDIF
      ENDIF
      RETURN

C  event rejected, print debug information
 450  CONTINUE
      IFAIL(4) = IFAIL(4)+1
      IF(IDEB(24).GE.2) THEN
        WRITE(ErrorOut,'(1X,2A,/,10X,7I5)') 'PHO_POMSCA: ',
     &    'REJECTION (MSPOM,MHPOM,IHARD,MHARD,ITRY,NTRY,IREJ)',
     &    MSPOM,MHPOM,IHARD,MHARD,ITRY,NTRY,IREJ
        WRITE(ErrorOut,
     * '(5X,A,I4,1P,2E12.4)') 'IP,Ecm,PTcut:',II,ECMP,PTWANT
        IF(IDEB(24).GE.5) THEN
          CALL PHO_PREVNT(0)
        ELSE
          CALL PHO_PREVNT(-1)
        ENDIF
      ENDIF

      END



CDECK  ID>, PHO_HARX12
      SUBROUTINE PHO_HARX12
C**********************************************************************
C
C     selection of x1 and x2 according to 1/x1*1/x2
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER ( TINY= 1.D-30, TINY6=1.D-06)

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC


10    CONTINUE
        Z1 = Z1MAX-PHO_RNDM(X1)*Z1DIF
        Z2 = Z2MAX-PHO_RNDM(X2)*Z2DIF
        IF ( (Z1+Z2).LT.ALNH ) GOTO 10
      X1   = EXP(Z1)
      X2   = EXP(Z2)
      AXX  = AH/(X1*X2)
      W    = SQRT(MAX(TINY,1.D0-AXX))
      W1   = AXX/(1.D0+W)

      END


CDECK  ID>, PHO_HARDX1
      SUBROUTINE PHO_HARDX1
C**********************************************************************
C
C     selection of x1 according to 1/x1
C     ( x2 = 1 )
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER ( TINY= 1.D-30, TINY6=1.D-06)

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC


      Z1 = Z1MAX-PHO_RNDM(X1)*Z1DIF
      X2   = 1.D0
      X1   = EXP(Z1)
      AXX  = AH/X1
      W    = SQRT(MAX(TINY,1.D0-AXX))
      W1   = AXX/(1.D0+W)

      END


CDECK  ID>, PHO_HARKIN
      SUBROUTINE PHO_HARKIN(IREJ)
C***********************************************************************
C
C     selection of kinematic variables
C     (resolved and direct processes)
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( TINY= 1.D-30, TINYP=1.D-14 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  internal cross check information on hard scattering limits
      DOUBLE PRECISION ETAMI,ETAMA,XXMI,XXMA
      COMMON /POHLIM/ ETAMI(2,15),ETAMA(2,15),XXMI(2,15),XXMA(2,15)


      PARAMETER ( MAX_PRO_2 = 16 )
      DIMENSION RM(-1:MAX_PRO_2)
      DATA RM / 3.31D0, 0.0D0,
     &          7.60D0, 0.65D0, 4.00D0, 0.65D0, 0.89D0,
     &          0.45D0, 0.89D0, 0.89D0, 0.0D0,  4.776D0,
     &          0.615D0,4.776D0,0.615D0,1.0D0,  0.0D0,
     &          1.0D0 /

      IREJ = 0
      M    = MSPR

C------------- resolved processes -----------
      IF     ( M.EQ.1 ) THEN
10      CALL PHO_HARX12
        V  =-0.5D0*W1/(W1+PHO_RNDM(X1)*W)
        U  =-1.D0-V
        R  = (1.D0+W)*2.25D0*(V*V*(3.D0-U*V-V/(U*U))-U)
        IF(R*W.GT.RM(M)) WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_HARKIN:WEIGHT ERROR',M
        IF ( R*W.LT.RM(1)*PHO_RNDM(X2) ) GOTO 10
        IF ( PHO_RNDM(V).LE.0.5D0 ) V = U
      ELSEIF ( M.EQ.2 .OR. M.EQ.4 ) THEN
20      CALL PHO_HARX12
        WL = LOG(W1)
        V  =-EXP(-0.6931472D0+PHO_RNDM(X1)*WL)
        U  =-1.D0-V
        R  = (U*U+V*V)*((16.D0/27.D0)/U-(4.D0/3.D0)*V)*(WL/W)*AXX
        IF(R*W.GT.RM(M)) WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_HARKIN:WEIGHT ERROR',M
        IF ( R*W.LT.RM(M)*PHO_RNDM(X2) ) GOTO 20
        IF ( PHO_RNDM(V).LE.0.5D0 ) V = U
      ELSEIF ( M.EQ.3 ) THEN
30      CALL PHO_HARX12
        V  =-0.5D0*W1/(W1+PHO_RNDM(X1)*W)
        U  =-1.D0-V
        R  = (1.D0+W)*(1.D0+U*U)*(1.D0-(4.D0/9.D0)*V*V/U)
        IF(R*W.GT.RM(M)) WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_HARKIN:WEIGHT ERROR',M
        IF ( R*W.LT.RM(3)*PHO_RNDM(X2) ) GOTO 30
      ELSEIF ( M.EQ.5 ) THEN
50      CALL PHO_HARX12
        V  =-0.5D0*AXX/(W1+2.D0*PHO_RNDM(X1)*W)
        U  =-1.D0-V
        R  = (4.D0/9.D0)*(1.D0+U*U+V*V*(U*U+V*V))-(8.D0/27.D0)*U*U*V
        IF(R*W.GT.RM(M)) WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_HARKIN:WEIGHT ERROR',M
        IF ( R*W.LT.RM(5)*PHO_RNDM(X2) ) GOTO 50
      ELSEIF ( M.EQ.6 ) THEN
60      CALL PHO_HARX12
        V  =-0.5D0*(1.D0+W)+PHO_RNDM(X1)*W
        U  =-1.D0-V
        R  = (4.D0/9.D0)*(U*U+V*V)*AXX
        IF(R*W.GT.RM(M)) WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_HARKIN:WEIGHT ERROR',M
        IF ( R*W.LT.RM(6)*PHO_RNDM(V) ) GOTO 60
      ELSEIF ( M.EQ.7 ) THEN
70      CALL PHO_HARX12
        V  =-0.5D0*W1/(W1+PHO_RNDM(X1)*W)
        U  =-1.D0-V
        R  = (1.D0+W)*((2.D0/9.D0)*(1.D0+U*U+(1.D0+V*V)*V*V/(U*U))
     &       -(4.D0/27.D0)*V/U)
        IF(R*W.GT.RM(M)) WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_HARKIN:WEIGHT ERROR',M
        IF ( R*W.LT.RM(7)*PHO_RNDM(X2) ) GOTO 70
        IF ( PHO_RNDM(V).LE.0.5D0 ) V = U
      ELSEIF ( M.EQ.8 ) THEN
80      CALL PHO_HARX12
        V  =-0.5D0*AXX/(W1+2.D0*PHO_RNDM(X1)*W)
        U  =-1.D0-V
        R  = (4.D0/9.D0)*(1.D0+U*U)
        IF(R*W.GT.RM(M)) WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_HARKIN:WEIGHT ERROR',M
        IF ( R*W.LT.RM(8)*PHO_RNDM(X2) ) GOTO 80
      ELSEIF ( M.EQ.-1 ) THEN
90      CALL PHO_HARX12
        WL = LOG(W1)
        V  =-EXP(-0.6931472D0+PHO_RNDM(X1)*WL)
        U  =-1.D0-V
        R  = (1.D0+V*V)*(V/(U*U)-(4.D0/9.D0))*(WL/W)*AXX
        IF(R*W.GT.RM(M)) WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_HARKIN:WEIGHT ERROR',M
        IF ( R*W.LT.RM(-1)*PHO_RNDM(X2) ) GOTO 90
C------------- direct / single-resolved processes -----------
      ELSEIF ( M.EQ.10 ) THEN
100     CALL PHO_HARDX1
        WL = LOG(AXX/(1.D0+W)**2)
        U  =-(1.D0+W)/2.D0*EXP(PHO_RNDM(X1)*WL)
        R  = -(8.D0/3.D0)*(U*U+1.D0)*WL*AXX
        IF(R.GT.RM(M)) WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_HARKIN:WEIGHT ERROR',M
        IF ( R.LT.RM(10)*PHO_RNDM(U) ) GOTO 100
        V  =-1.D0-U
        X2 = X1
        X1 = 1.D0
      ELSEIF ( M.EQ.11) THEN
110     CALL PHO_HARDX1
        WL = LOG(W1)
        U  =-EXP(-0.6931472D0+PHO_RNDM(X1)*WL)
        V  =-1.D0-U
        R  = (U*U+V*V)/V*WL*AXX
        IF(R.GT.RM(M)) WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_HARKIN:WEIGHT ERROR',M
        IF ( R.LT.RM(11)*PHO_RNDM(X2) ) GOTO 110
        IF ( PHO_RNDM(V).LE.0.5D0 ) V = U
        X2 = X1
        X1 = 1.D0
      ELSEIF ( M.EQ.12 ) THEN
120     CALL PHO_HARDX1
        WL = LOG(AXX/(1.D0+W)**2)
        V  =-(1.D0+W)/2.D0*EXP(PHO_RNDM(X1)*WL)
        R  = -(8.D0/3.D0)*(V*V+1.D0)*WL*AXX
        IF(R.GT.RM(M)) WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_HARKIN:WEIGHT ERROR',M
        IF ( R.LT.RM(12)*PHO_RNDM(V) ) GOTO 120
      ELSEIF ( M.EQ.13) THEN
130     CALL PHO_HARDX1
        WL = LOG(W1)
        V  =-EXP(-0.6931472D0+PHO_RNDM(X1)*WL)
        U  =-1.D0-V
        R  = (U*U+V*V)/U*WL*AXX
        IF(R.GT.RM(M)) WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_HARKIN:WEIGHT ERROR',M
        IF ( R.LT.RM(13)*PHO_RNDM(X2) ) GOTO 130
        IF ( PHO_RNDM(V).LE.0.5D0 ) V = U
C------------- (double) direct process -----------
      ELSEIF ((M.EQ.14).OR.(M.EQ.16)) THEN
        X1 = 1.D0
        X2 = 1.D0
        AXX= AH
        W  = SQRT(MAX(TINY,1.D0-AXX))
        W1 = AXX/(1.D0+W)
        WL = LOG(W1)
 140    V  =-EXP(-0.6931472D0+PHO_RNDM(X1)*WL)
        U  =-1.D0-V
        R  = -(U*U+V*V)/U
        IF(R.GT.RM(M)) WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_HARKIN:WEIGHT ERROR',M
        IF ( R.LT.RM(14)*PHO_RNDM(X2) ) GOTO 140
        IF ( PHO_RNDM(V).LE.0.5D0 ) V = U
C---------------------------------------------
      ELSE
        WRITE(ErrorOut,'(/1X,A,I3)')
     &    'PHO_HARKIN:ERROR:UNSUPPORTED PROCESS (MSPR)',MSPR
        CALL PHO_ABORT
      ENDIF

      V    = MAX(MIN(V,-TINYP ),-1.D0+TINYP)
      U    = -1.D0-V
      U    = MAX(MIN(U,-TINYP ),-1.D0+TINYP)
      PT   = SQRT(U*V*X1*X2)*ECMP
      ETAC = 0.5D0*LOG((U*X1)/(V*X2))
      ETAD = 0.5D0*LOG((V*X1)/(U*X2))

***************************************************************
      MM = M
      IF(M.EQ.-1) MM = 3
      ETAMI(1,MM) = MIN(ETAMI(1,MM),ETAC)
      ETAMA(1,MM) = MAX(ETAMA(1,MM),ETAC)
      ETAMI(2,MM) = MIN(ETAMI(2,MM),ETAD)
      ETAMA(2,MM) = MAX(ETAMA(2,MM),ETAD)
      XXMI(1,MM) = MIN(XXMI(1,MM),X1)
      XXMA(1,MM) = MAX(XXMA(1,MM),X1)
      XXMI(2,MM) = MIN(XXMI(2,MM),X2)
      XXMA(2,MM) = MAX(XXMA(2,MM),X2)
***************************************************************

      IF(IDEB(81).GE.25) WRITE(ErrorOut,'(1X,A,/5X,6E12.3)')
     &  'PHO_HARKIN: V,PT,ETAC,ETAD,X1,X2',V,PT,ETAC,ETAD,X1,X2

      END


CDECK  ID>, PHO_HARWGH
      SUBROUTINE PHO_HARWGH(PDS,PDA,PDB,FDISTR)
C***********************************************************************
C
C     calculate product of PDFs and coupling constants
C     according to selected MSPR (process type)
C
C     input:    /POCKIN/
C
C     output:   PDS     resulting from PDFs alone
C               FDISTR  complete weight function
C               PDA,PDB fields containing the PDFs
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( TINY= 1.D-30, TINY6=1.D-06)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF

C  some hadron information, will be deleted in future versions
      INTEGER NFS
      DOUBLE PRECISION QMASS,BET,PCOUDI,PNORM,VALPRG
      COMMON /POHDRN/ QMASS(6),BET,PCOUDI,PNORM,VALPRG(2),NFS

C  scale parameters for parton model calculations
      INTEGER NQQAL,NQQALI,NQQALF,NQQPD
      DOUBLE PRECISION AQQAL,AQQALI,AQQALF,AQQPD
      COMMON /POHSCL/ AQQAL,AQQALI,AQQALF,AQQPD,
     &                NQQAL,NQQALI,NQQALF,NQQPD

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


      DOUBLE PRECISION PHO_ALPHAS,PHO_ALPHAE
      DIMENSION PDA(-6:6),PDB(-6:6)


      FDISTR = 0.D0
C  set hard scale  QQ  for alpha and partondistr.
      IF     ( NQQAL.EQ.1 ) THEN
        QQAL = AQQAL*PT*PT
      ELSEIF ( NQQAL.EQ.2 ) THEN
        QQAL = AQQAL*X1*X2*ECMP*ECMP*U*V/(1.D0+V*V+U*U)
      ELSEIF ( NQQAL.EQ.3 ) THEN
        QQAL = AQQAL*X1*X2*ECMP*ECMP
      ELSEIF ( NQQAL.EQ.4 ) THEN
        QQAL = AQQAL*X1*X2*ECMP*ECMP*(U*V)**(1.D0/3.D0)
      ENDIF
      IF     ( NQQPD.EQ.1 ) THEN
        QQPD = AQQPD*PT*PT
      ELSEIF ( NQQPD.EQ.2 ) THEN
        QQPD = AQQPD*X1*X2*ECMP*ECMP*U*V/(1.D0+V*V+U*U)
      ELSEIF ( NQQPD.EQ.3 ) THEN
        QQPD = AQQPD*X1*X2*ECMP*ECMP
      ELSEIF ( NQQPD.EQ.4 ) THEN
        QQPD = AQQPD*X1*X2*ECMP*ECMP*(U*V)**(1.D0/3.D0)
      ENDIF
C  coupling constants, PDFs
      IF(MSPR.LT.9) THEN
        ALPHA1 = PHO_ALPHAS(QQAL,3)
        ALPHA2 = ALPHA1
        CALL PHO_PDF(1,X1,QQPD,0.D0,PDA)
        CALL PHO_PDF(2,X2,QQPD,0.D0,PDB)
        IF ( MSPR.EQ.1  .OR.  MSPR.EQ.4 ) THEN
          PDS   = PDA(0)*PDB(0)
        ELSE
          S2    = 0.D0
          S3    = 0.D0
          S4    = 0.D0
          S5    = 0.D0
          DO 10 I=1,NF
            S2  = S2+PDA(I)*PDB(-I)+PDA(-I)*PDB( I)
            S3  = S3+PDA(I)*PDB( I)+PDA(-I)*PDB(-I)
            S4  = S4+PDA(I)+PDA(-I)
            S5  = S5+PDB(I)+PDB(-I)
 10       CONTINUE
          IF ((MSPR.EQ.2).OR.(MSPR.EQ.5).OR.(MSPR.EQ.6)) THEN
            PDS = S2
          ELSE IF((MSPR.EQ.3).OR.(MSPR.EQ.-1)) THEN
            PDS = PDA(0)*S5+PDB(0)*S4
          ELSE IF(MSPR.EQ.7) THEN
            PDS = S3
          ELSE IF(MSPR.EQ.8) THEN
            PDS = S4*S5-(S2+S3)
          ENDIF
        ENDIF
      ELSE IF(MSPR.LT.12) THEN
        ALPHA2 = PHO_ALPHAS(QQAL,2)
        IF(IDPDG1.EQ.22) THEN
          ALPHA1 = PHO_ALPHAE(QQAL)
        ELSE IF(IDPDG1.EQ.990) THEN
          ALPHA1 = PARMDL(74)
        ENDIF
        CALL PHO_PDF(2,X2,QQPD,0.D0,PDB)
        S4    = 0.D0
        S6    = 0.D0
        DO 15 I=1,NF
          S4  = S4+PDB(I)+PDB(-I)
C  charge counting
*         IF(MOD(I,2).EQ.0) THEN
*           S6  = S6+(PDB(I)+PDB(-I))*4.D0/9.D0
*         ELSE
*           S6  = S6+(PDB(I)+PDB(-I))*1.D0/9.D0
*         ENDIF
          S6  = S6+(PDB(I)+PDB(-I))*Q_CH2(I)
 15     CONTINUE
        IF(MSPR.EQ.10) THEN
          IF(IDPDG1.EQ.990) THEN
            PDS = S4
          ELSE
            PDS = S6
          ENDIF
        ELSE
          PDS = PDB(0)
        ENDIF
      ELSE IF(MSPR.LT.14) THEN
        ALPHA1 = PHO_ALPHAS(QQAL,1)
        IF(IDPDG2.EQ.22) THEN
          ALPHA2 = PHO_ALPHAE(QQAL)
        ELSE IF(IDPDG2.EQ.990) THEN
          ALPHA2 = PARMDL(74)
        ENDIF
        CALL PHO_PDF(1,X1,QQPD,0.D0,PDA)
        S4    = 0.D0
        S6    = 0.D0
        DO 20 I=1,NF
          S4  = S4+PDA(I)+PDA(-I)
C  charge counting
*         IF(MOD(I,2).EQ.0) THEN
*           S6  = S6+(PDA(I)+PDA(-I))*4.D0/9.D0
*         ELSE
*           S6  = S6+(PDA(I)+PDA(-I))*1.D0/9.D0
*         ENDIF
          S6  = S6+(PDA(I)+PDA(-I))*Q_CH2(I)
 20     CONTINUE
        IF(MSPR.EQ.12) THEN
          IF(IDPDG2.EQ.990) THEN
            PDS = S4
          ELSE
            PDS = S6
          ENDIF
        ELSE
          PDS = PDA(0)
        ENDIF
      ELSE IF(MSPR.EQ.14) THEN
        SSR = X1*X2*ECMP*ECMP
        IF(IDPDG1.EQ.22) THEN
          ALPHA1 = PHO_ALPHAE(SSR)
        ELSE IF(IDPDG1.EQ.990) THEN
          ALPHA1 = PARMDL(74)
        ENDIF
        IF(IDPDG2.EQ.22) THEN
          ALPHA2 = PHO_ALPHAE(SSR)
        ELSE IF(IDPDG2.EQ.990) THEN
          ALPHA2 = PARMDL(74)
        ENDIF
        PDS = 1.D0
      ELSE
        WRITE(ErrorOut,'(/1X,A,I4)')
     &    'PHO_HARWGH:ERROR: INVALID HARD PROCESS NUMBER (MSPR)',MSPR
        CALL PHO_ABORT
      ENDIF

C  complete weight
      FDISTR  = HFAC(MSPR)*ALPHA1*ALPHA2*PDS

C  debug output
      IF(IDEB(15).GE.20) WRITE(ErrorOut,
     * '(1X,A,/5X,I3,2I6,4E10.3)')
     &    'PHO_HARWGH: MSPR,ID1,ID2,AL1,AL2,PDS,FDIS',
     &    MSPR,IDPDG1,IDPDG2,ALPHA1,ALPHA2,PDS,FDISTR

      END


CDECK  ID>, PHO_HARSCA
      SUBROUTINE PHO_HARSCA(IMODE,IP)
C***********************************************************************
C
C     PHO_HARSCA determines the type of hard subprocess, the partons
C     taking part in this subprocess and the kinematic variables
C
C     input:  IMODE   1   direct processes
C                     2   resolved processes
C                     -1  initialization
C                     -2  output of statistics
C             IP      1-4 particle combination (hadron/photon)
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER( EPS  = 1.D-10,
     &           DEPS = 1.D-30 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  names of hard scattering processes
      INTEGER MAX_PRO_1
      PARAMETER ( MAX_PRO_1 = 16 )
      CHARACTER*18 PROC
      COMMON /POHPRO/ PROC(0:MAX_PRO_1)

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  hard scattering data
      INTEGER MSCAHD
      PARAMETER ( MSCAHD = 50 )
      INTEGER LSCAHD,LSC1HD,LSIDX,
     &        NINHD,N0INHD,NIVAL,N0IVAL,NOUTHD,NBRAHD,NPROHD
      DOUBLE PRECISION PPH,PTHD,ETAHD,Q2SCA,PDFVA,XHD,VHD,X0HD
      COMMON /POHSLT/ LSCAHD,LSC1HD,LSIDX(MSCAHD),
     &                PPH(8*MSCAHD,2),PTHD(MSCAHD),ETAHD(MSCAHD,2),
     &                Q2SCA(MSCAHD,2),PDFVA(MSCAHD,2),
     &                XHD(MSCAHD,2),VHD(MSCAHD),X0HD(MSCAHD,2),
     &                NINHD(MSCAHD,2),N0INHD(MSCAHD,2),
     &                NIVAL(MSCAHD,2),N0IVAL(MSCAHD,2),
     &                NOUTHD(MSCAHD,2),NBRAHD(MSCAHD,2),NPROHD(MSCAHD)

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


 111  CONTINUE

C  resolved processes
      IF(IMODE.EQ.2) THEN

        MH_PRO_ON(0,IP) = 0
        HWGX(9)  = 0.D0
        DO 15 M=-1,8
          IF(MH_PRO_ON(M,IP).EQ.1) HWGX(9) = HWGX(9)+HWGX(M)
 15     CONTINUE
        IF(HWGX(9).LT.DEPS) THEN
          WRITE(ErrorOut,
     * '(/1X,2A,I4,1P,E12.4)') 'PHO_HARSCA:ERROR: ',
     &      'NO RESOLVED PROCESS POSSIBLE FOR IP',IP,HWGX(9)
          CALL PHO_ABORT
        ENDIF
C
C ----------------------------------------------I
C  begin of iteration loop (resolved processes) I
C                                               I
        IREJSC = 0
 10     CONTINUE
        IREJSC = IREJSC+1
        IF(IREJSC.GT.1000) THEN
          WRITE(ErrorOut,'(/1X,A,I10)')
     &      'PHO_HARSCA:ERROR: TOO MANY REJECTIONS (RESOLVED)',IREJSC
            CALL PHO_ABORT
        ENDIF

C  find subprocess
        B      = PHO_RNDM(X1)*HWGX(9)
        MSPR   =-2
        SUM    = 0.D0
 20     MSPR   = MSPR+1
        IF ( MH_PRO_ON(MSPR,IP).EQ.1 ) SUM = SUM+HWGX(MSPR)
        IF ( SUM.LT.B  .AND. MSPR.LT.8 ) GOTO 20

        IF(IDEB(78).GE.20) WRITE(ErrorOut,'(1x,a,i3,i6)')
     &    'PHO_HARSCA: RESOLVED PROCESS (MSPR,IREJSC)',MSPR,IREJSC

C  find kin. variables X1,X2 and V
        CALL PHO_HARKIN(IREJ)
        IF(IREJ.NE.0) THEN
          IFAIL(29) = IFAIL(29)+1
          GOTO 10
        ENDIF
C  calculate remaining distribution
        CALL PHO_HARWGH(PDS,PDF1,PDF2,F)
C  actualize counter for cross-section calculation
        IF(F.LE.1.D-15) THEN
          F = 0.D0
          GOTO 10
        ENDIF
*       XSECT(5,MSPR) = XSECT(5,MSPR)+F
*       XSECT(6,MSPR) = XSECT(6,MSPR)+F*F
        MH_TRIED(MSPR,IP) = MH_TRIED(MSPR,IP)+1
C  check F against FMAX
        WEIGHT = F/(HWGX(MSPR)+DEPS)
        IF ( WEIGHT.LT.PHO_RNDM(X2) ) GOTO 10
C-------------------------------------------------------------------
        IF(WEIGHT.GT.1.D0) THEN
          WRITE(ErrorOut,
     * 1234) MSPR,IP,IDPDG1,IDPDG2,F,HWGX(MSPR),WEIGHT
 1234     FORMAT(/,' PHO_HARSCA: (RESOLVED) W>1 (MSPR,IP,ID1,2)',
     &      2I3,2I7,/' F,HWGX(MSPR),W',3E12.4)
          WRITE(ErrorOut,'(1X,A,5E11.3)') 'ECM,PTWANT,AS,AH,PT',
     &      ECMP,PTWANT,AS,AH,PT
          WRITE(ErrorOut,'(1X,A,5E11.3)') 'ETAC,ETAD,X1,X2,V',
     &      ETAC,ETAD,X1,X2,V
          CALL PHO_PREVNT(-1)
        ENDIF
C-------------------------------------------------------------------
C                                             I
C  end of iteration loop (resolved processes) I
C --------------------------------------------I
C
C*********************************************************************
C
C  direct processes

      ELSE IF(IMODE.EQ.1) THEN

C  single-resolved processes kinematically forbidden
        IF(Z1DIF.LT.0.D0) THEN
          HWGX(10) = 0.D0
          HWGX(11) = 0.D0
          HWGX(12) = 0.D0
          HWGX(13) = 0.D0
        ENDIF

        HWGX(15)  = 0.D0
        IF((IPAMDL(115).EQ.0).AND.(IP.EQ.1)) THEN
          DO M= 10,14
            IF(MH_PRO_ON(M,IP).EQ.1) THEN
              IF((M.EQ.10).OR.(M.EQ.11)) THEN
                FAC = FSUH(1)*FSUP(2)
              ELSE IF((M.EQ.12).OR.(M.EQ.13)) THEN
                FAC = FSUP(1)*FSUH(2)
              ELSE
                FAC = FSUH(1)*FSUH(2)
              ENDIF
              HWGX(15) = HWGX(15)+HWGX(M)*FAC
            ENDIF
          ENDDO
        ELSE
          DO M= 10,14
            IF(MH_PRO_ON(M,IP).EQ.1) HWGX(15)=HWGX(15)+HWGX(M)
          ENDDO
        ENDIF
        IF(HWGX(15).LT.DEPS) THEN
          WRITE(ErrorOut,'(/1X,2A,I4)') 'PHO_HARSCA:ERROR: ',
     &      'NO DIRECT/SINGLE-RESOLVED PROCESS POSSIBLE (IP)',IP
          CALL PHO_ABORT
        ENDIF
C
C ----------------------------------------------I
C  begin of iteration loop (direct processes)   I
C                                               I
        IREJSC = 0
 100    CONTINUE
        IREJSC = IREJSC+1
        IF(IREJSC.GT.1000) THEN
          WRITE(ErrorOut,'(/1X,A,I10)')
     &      'PHO_HARSCA:ERROR: TOO MANY REJECTIONS (DIRECT)',IREJSC
            CALL PHO_ABORT
        ENDIF

C  find subprocess
        B      = PHO_RNDM(X1)*HWGX(15)
        MSPR   = 9
        SUM    = 0.D0
        IF((IPAMDL(115).EQ.0).AND.(IP.EQ.1)) THEN
 150      CONTINUE
            MSPR   = MSPR+1
            IF(MH_PRO_ON(MSPR,IP).EQ.1) THEN
              IF((MSPR.EQ.10).OR.(MSPR.EQ.11)) THEN
                FAC = FSUH(1)*FSUP(2)
              ELSE IF((MSPR.EQ.12).OR.(MSPR.EQ.13)) THEN
                FAC = FSUP(1)*FSUH(2)
              ELSE
                FAC = FSUH(1)*FSUH(2)
              ENDIF
              SUM = SUM+HWGX(MSPR)*FAC
            ENDIF
          IF ( SUM.LT.B  .AND. MSPR.LT.14 ) GOTO 150
        ELSE
 200      CONTINUE
            MSPR   = MSPR+1
            IF(MH_PRO_ON(MSPR,IP).EQ.1) SUM = SUM+HWGX(MSPR)
          IF ( SUM.LT.B  .AND. MSPR.LT.14 ) GOTO 200
        ENDIF

        IF(IDEB(78).GE.20) WRITE(ErrorOut,'(1x,a,i3,i6)')
     &    'PHO_HARSCA: DIRECT PROCESS (MSPR,IREJSC)',MSPR,IREJSC

C  find kin. variables X1,X2 and V
        CALL PHO_HARKIN(IREJ)
        IF(IREJ.NE.0) THEN
          IFAIL(28) = IFAIL(28)+1
          GOTO 100
        ENDIF

C  calculate remaining distribution
        CALL PHO_HARWGH(PDS,PDF1,PDF2,F)

C  counter for cross-section calculation
        IF(F.LE.1.D-15) THEN
          F=0.D0
          GOTO 10
        ENDIF
*       XSECT(5,MSPR) = XSECT(5,MSPR)+F
*       XSECT(6,MSPR) = XSECT(6,MSPR)+F*F
        MH_TRIED(MSPR,IP) = MH_TRIED(MSPR,IP)+1
C  check F against FMAX
        WEIGHT = F/(HWGX(MSPR)+DEPS)
        IF(WEIGHT.LT.PHO_RNDM(X2)) GOTO 100
C-------------------------------------------------------------------
        IF(WEIGHT.GT.1.D0) THEN
          WRITE(ErrorOut,
     * 1235) MSPR,IP,IDPDG1,IDPDG2,F,HWGX(MSPR),WEIGHT
 1235     FORMAT(/,' PHO_HARSCA: (DIRECT) W>1 (MSPR,IP,ID1,2)',
     &      2I3,2I7,/,' F,HWGX(MSPR),W',3E12.4)
          WRITE(ErrorOut,'(1X,A,5E11.3)') 'ECM,PTWANT,AS,AH,PT',
     &      ECMP,PTWANT,AS,AH,PT
          WRITE(ErrorOut,'(1X,A,5E11.3)') 'ETAC,ETAD,X1,X2,V',
     &      ETAC,ETAD,X1,X2,V
          CALL PHO_PREVNT(-1)
        ENDIF
C-------------------------------------------------------------------
C                                             I
C  end of iteration loop (direct processes)   I
C --------------------------------------------I

      ELSE IF(IMODE.EQ.-1) THEN

C  initialize cross section calculations

        DO 40 M=-1,MAX_PRO_2
*         DO 30 I=5,6
*           XSECT(I,M) = 0.D0
*30       CONTINUE
C  reset counters
          DO 35 J=1,4
            MH_TRIED(M,J) = 0
            MH_ACC_1(M,J) = 0
            MH_ACC_2(M,J) = 0
 35       CONTINUE
 40     CONTINUE
        IF(IDEB(78).GE.0) THEN
          WRITE(ErrorOut,'(/1X,A,/1X,A)')
     &      'PHO_HARSCA: ACTIVATED HARD PROCESSES',
     &      '------------------------------------'
          WRITE(ErrorOut,
     * '(5X,A)') 'PROCESS,    IP= 1 ... 4 (on/off)'
          DO 42 M=1,MAX_PRO_2
            WRITE(ErrorOut,
     * '(1X,I3,5X,A,4I3)') M,PROC(M),(MH_PRO_ON(M,J),J=1,4)
 42       CONTINUE
        ENDIF
        RETURN

      ELSE IF(IMODE.EQ.-2) THEN

C  calculation of process statistics

        DO K=1,4

          MH_TRIED(0,K)  = 0
          MH_ACC_1(0,K)  = 0
          MH_ACC_2(0,K)  = 0
          MH_TRIED(9,K)  = 0
          MH_ACC_1(9,K)  = 0
          MH_ACC_2(9,K)  = 0
          MH_TRIED(15,K) = 0
          MH_ACC_1(15,K) = 0
          MH_ACC_2(15,K) = 0

          MH_TRIED(3,K) = MH_TRIED(3,K)+MH_TRIED(-1,K)
          MH_ACC_1(3,K) = MH_ACC_1(3,K)+MH_ACC_1(-1,K)
          MH_ACC_2(3,K) = MH_ACC_2(3,K)+MH_ACC_2(-1,K)

          DO M=1,8
            MH_TRIED(9,K) = MH_TRIED(9,K)+MH_TRIED(M,K)
            MH_ACC_1(9,K) = MH_ACC_1(9,K)+MH_ACC_1(M,K)
            MH_ACC_2(9,K) = MH_ACC_2(9,K)+MH_ACC_2(M,K)
          ENDDO
          DO M=10,14
            MH_TRIED(15,K) = MH_TRIED(15,K)+MH_TRIED(M,K)
            MH_ACC_1(15,K) = MH_ACC_1(15,K)+MH_ACC_1(M,K)
            MH_ACC_2(15,K) = MH_ACC_2(15,K)+MH_ACC_2(M,K)
          ENDDO
          MH_TRIED(0,K) = MH_TRIED(9,K)+MH_TRIED(15,K)
          MH_ACC_1(0,K) = MH_ACC_1(9,K)+MH_ACC_1(15,K)
          MH_ACC_2(0,K) = MH_ACC_2(9,K)+MH_ACC_2(15,K)
        ENDDO

        IF(IDEB(78).GE.1) THEN
          WRITE(ErrorOut,'(/1X,A,/1X,A)')
     &      'PHO_HARSCA: INTERNAL REJECTION STATISTICS',
     &      '-----------------------------------------'
          DO K=1,4
            IF(MH_TRIED(0,K).GT.0) THEN
              WRITE(ErrorOut,'(5X,A,I3)')
     &          'PROCESS (SAMPLED/ACCEPTED) FOR IP:',K
              DO M=0,MAX_PRO_2
                WRITE(ErrorOut,
     * '(1X,I3,1X,A,2X,3I12,F10.4)') M,PROC(M),
     &            MH_TRIED(M,K),MH_ACC_1(M,K),MH_ACC_2(K,K),
     &            DBLE(MH_ACC_1(M,K))/DBLE(MAX(1,MH_TRIED(M,K)))
              ENDDO
            ENDIF
          ENDDO
        ENDIF
        RETURN

      ELSE
        WRITE(ErrorOut,'(/1X,2A,I10)') 'PHO_HARSCA:ERROR: ',
     &    'UNSUPPORTED MODE',IMODE
        CALL PHO_ABORT
      ENDIF

C  the event is accepted now
C  actualize counter for accepted events
      MH_ACC_1(MSPR,IP) = MH_ACC_1(MSPR,IP)+1
      IF(MSPR.EQ.-1) MSPR = 3
C
C  find flavor of initial partons
C
      SUM    = 0.D0
      SCHECK = PHO_RNDM(SUM)*PDS-EPS
      IF     ( MSPR.EQ.1  .OR.  MSPR.EQ.4 ) THEN
        IA = 0
        IB = 0
      ELSEIF ( MSPR.EQ.2  .OR.  MSPR.EQ.5  .OR.  MSPR.EQ.6 ) THEN
        DO 610 IA=-NF,NF
          IF ( IA.EQ.0 ) GOTO 610
          SUM  = SUM+PDF1(IA)*PDF2(-IA)
          IF ( SUM.GE.SCHECK ) GOTO 620
 610      CONTINUE
 620    IB =-IA
      ELSEIF ( MSPR.EQ.3 ) THEN
        IB     = 0
        DO 630 IA=-NF,NF
          IF ( IA.EQ.0 ) GOTO 630
          SUM  = SUM+PDF1(0)*PDF2(IA)
          IF ( SUM.GE.SCHECK ) GOTO 640
          SUM  = SUM+PDF1(IA)*PDF2(0)
          IF ( SUM.GE.SCHECK ) GOTO 650
 630    CONTINUE
 640    IB     = IA
        IA     = 0
 650    CONTINUE
      ELSEIF ( MSPR.EQ.7 ) THEN
        DO 660 IA=-NF,NF
          IF ( IA.EQ.0 ) GOTO 660
          SUM  = SUM+PDF1(IA)*PDF2(IA)
          IF ( SUM.GE.SCHECK ) GOTO 670
 660      CONTINUE
 670    IB     = IA
      ELSEIF ( MSPR.EQ.8 ) THEN
        DO 690 IA=-NF,NF
          IF ( IA.EQ.0 ) GOTO 690
          DO 680 IB=-NF,NF
            IF ( ABS(IB).EQ.ABS(IA)  .OR.  IB.EQ.0 ) GOTO 680
            SUM = SUM+PDF1(IA)*PDF2(IB)
            IF ( SUM.GE.SCHECK ) GOTO 700
 680        CONTINUE
 690      CONTINUE
 700    CONTINUE
      ELSEIF ( MSPR.EQ.10 ) THEN
        IA     = 0
        DO 710 IB=-NF,NF
          IF ( IB.NE.0 ) THEN
            IF(IDPDG1.EQ.22) THEN
*             IF(MOD(ABS(IB),2).EQ.0) THEN
*               SUM = SUM+PDF2(IB)*4.D0/9.D0
*             ELSE
*               SUM = SUM+PDF2(IB)*1.D0/9.D0
*             ENDIF
              SUM = SUM+PDF2(IB)*Q_CH2(IB)
            ELSE
              SUM = SUM+PDF2(IB)
            ENDIF
            IF ( SUM.GE.SCHECK ) GOTO 720
          ENDIF
 710    CONTINUE
 720    CONTINUE
      ELSEIF ( MSPR.EQ.12 ) THEN
        IB     = 0
        DO 810 IA=-NF,NF
          IF ( IA.NE.0 ) THEN
            IF(IDPDG2.EQ.22) THEN
*             IF(MOD(ABS(IA),2).EQ.0) THEN
*               SUM = SUM+PDF1(IA)*4.D0/9.D0
*             ELSE
*               SUM = SUM+PDF1(IA)*1.D0/9.D0
*             ENDIF
              SUM = SUM+PDF1(IA)*Q_CH2(IA)
            ELSE
              SUM = SUM+PDF1(IA)
            ENDIF
            IF ( SUM.GE.SCHECK ) GOTO 820
          ENDIF
 810    CONTINUE
 820    CONTINUE
      ELSEIF ((MSPR.EQ.11).OR.(MSPR.EQ.13).OR.(MSPR.EQ.14)) THEN
        IA     = 0
        IB     = 0
      ENDIF
C  final check
      IF((ABS(IA).GT.NF).OR.(ABS(IB).GT.NF)) THEN
        PRINT *,'PHO_HARSCA: REJECTION, FINAL CHECK IA,IB',IA,IB
        PRINT *,'EVENT,MSPR,IA,IB,NF: ',KEVENT,MSPR,IA,IB,NF
        GOTO 111
      ENDIF
C
C  find flavour of final partons
C
      IC = IA
      ID = IB
      IF     ( MSPR.EQ.2 ) THEN
        IC = 0
        ID = 0
      ELSEIF ( MSPR.EQ.4 ) THEN
        IC = INT(FLOAT(NF+NF)*PHO_RNDM(SUM))+1
        IF ( IC.GT.NF ) IC = NF-IC
        ID =-IC
      ELSEIF ( MSPR.EQ.6 ) THEN
        IC = INT(FLOAT(NF+NF-2)*PHO_RNDM(SUM))+1
        IF ( IC.GT.NF-1 ) IC = NF-1-IC
        IF ( ABS(IC).EQ.ABS(IA) ) IC = SIGN(NF,IC)
        ID =-IC
      ELSEIF ( MSPR.EQ.11) THEN
        SUM = 0.D0
        DO 730 IC=-NF,NF
          IF ( IC.NE.0 ) THEN
            IF(IDPDG1.EQ.22) THEN
*             IF(MOD(ABS(IC),2).EQ.0) THEN
*               SUM = SUM + 4.D0
*             ELSE
*               SUM = SUM + 1.D0
*             ENDIF
              SUM = SUM + Q_CH2(IC)
            ELSE
              SUM = SUM + 1.D0
            ENDIF
          ENDIF
 730    CONTINUE
        SCHECK = PHO_RNDM(SUM)*SUM-EPS
        SUM = 0.D0
        DO 740 IC=-NF,NF
          IF ( IC.NE.0 ) THEN
            IF(IDPDG1.EQ.22) THEN
*             IF(MOD(ABS(IC),2).EQ.0) THEN
*               SUM = SUM + 4.D0
*             ELSE
*               SUM = SUM + 1.D0
*             ENDIF
              SUM = SUM + Q_CH2(IC)
            ELSE
              SUM = SUM + 1.D0
            ENDIF
            IF ( SUM.GE.SCHECK ) GOTO 750
          ENDIF
 740    CONTINUE
 750    CONTINUE
        ID = -IC
      ELSEIF ( MSPR.EQ.12) THEN
        IC = 0
        ID = IA
      ELSEIF ( MSPR.EQ.13) THEN
        SUM = 0.D0
        DO 830 IC=-NF,NF
          IF ( IC.NE.0 ) THEN
            IF(IDPDG2.EQ.22) THEN
*             IF(MOD(ABS(IC),2).EQ.0) THEN
*               SUM = SUM + 4.D0
*             ELSE
*               SUM = SUM + 1.D0
*             ENDIF
              SUM = SUM +  Q_CH2(IC)
            ELSE
              SUM = SUM + 1.D0
            ENDIF
          ENDIF
 830    CONTINUE
        SCHECK = PHO_RNDM(SUM)*SUM-EPS
        SUM = 0.D0
        DO 840 IC=-NF,NF
          IF ( IC.NE.0 ) THEN
            IF(IDPDG2.EQ.22) THEN
*             IF(MOD(ABS(IC),2).EQ.0) THEN
*               SUM = SUM + 4.D0
*             ELSE
*               SUM = SUM + 1.D0
*             ENDIF
              SUM = SUM +  Q_CH2(IC)
            ELSE
              SUM = SUM + 1.D0
            ENDIF
            IF ( SUM.GE.SCHECK ) GOTO 850
          ENDIF
 840    CONTINUE
 850    CONTINUE
        ID = -IC
      ELSEIF ( MSPR.EQ.14) THEN
        SUM = 0.D0
        DO 930 IC=1,NF
          FAC1 = 1.D0
          FAC2 = 1.D0
          IF(MOD(ABS(IC),2).EQ.0) THEN
            IF(IDPDG1.EQ.22) FAC1 = 4.D0
            IF(IDPDG2.EQ.22) FAC2 = 4.D0
          ENDIF
          SUM = SUM + FAC1*FAC2
 930    CONTINUE
        IF(IPAMDL(64).NE.0) THEN
          IF((IDPDG1.EQ.22).AND.(IDPDG2.EQ.22)) SUM = SUM + 81.D0
        ENDIF
        SCHECK = PHO_RNDM(SUM)*SUM-EPS
        SUM = 0.D0
        DO 940 IC=1,NF
          FAC1 = 1.D0
          FAC2 = 1.D0
          IF(MOD(ABS(IC),2).EQ.0) THEN
            IF(IDPDG1.EQ.22) FAC1 = 4.D0
            IF(IDPDG2.EQ.22) FAC2 = 4.D0
          ENDIF
          SUM = SUM + FAC1*FAC2
          IF ( SUM.GE.SCHECK ) GOTO 950
 940    CONTINUE
        IC = 15
 950    CONTINUE
        ID = -IC
        IF(PHO_RNDM(FAC1).GT.0.5D0) CALL PHO_SWAPI(IC,ID)
      ENDIF
      IF(IC.EQ.0) THEN
        XM3 = 0.D0
      ELSE
        XM3 = PHO_PMASS(IC,3)
      ENDIF
      IF(ID.EQ.0) THEN
        XM4 = 0.D0
      ELSE
        XM4 = PHO_PMASS(ID,3)
      ENDIF
      IF(ABS(IC).EQ.15) GOTO 955

C  valence quarks involved?
      IV1 = 0
      IF(IA.NE.0) THEN
        IF(IDPDG1.EQ.22) THEN
          CALL PHO_QPMPDF(IA,X1,QQPD,0.D0,PVIRTP(1),FXP)
          IF(PHO_RNDM(XM3)*PDF1(IA).GT.PDF1(IA)-FXP) IV1 = 1
        ELSE
          IF(PHO_RNDM(XM3)*PDF1(IA).GT.PDF1(-IA)) IV1 = 1
        ENDIF
      ENDIF
      IV2 = 0
      IF(IB.NE.0) THEN
        IF(IDPDG2.EQ.22) THEN
          CALL PHO_QPMPDF(IB,X2,QQPD,0.D0,PVIRTP(2),FXP)
          IF(PHO_RNDM(XM4)*PDF2(IB).GT.PDF2(IB)-FXP) IV2 = 1
        ELSE
          IF(PHO_RNDM(XM4)*PDF2(IB).GT.PDF2(-IB)) IV2 = 1
        ENDIF
      ENDIF
C
C  fill event record
C
 955  CONTINUE
      CALL PHO_SFECFE(SINPHI,COSPHI)
      ECM2 = ECMP/2.D0
C  incoming partons
      PHI1(1) = 0.D0
      PHI1(2) = 0.D0
      PHI1(3) = ECM2*X1
      PHI1(4) = PHI1(3)
      PHI1(5) = 0.D0
      PHI2(1) = 0.D0
      PHI2(2) = 0.D0
      PHI2(3) = -ECM2*X2
      PHI2(4) = -PHI2(3)
      PHI2(5) = 0.D0
C  outgoing partons
      PHO1(1) = PT*COSPHI
      PHO1(2) = PT*SINPHI
      PHO1(3) = -ECM2*(U*X1-V*X2)
      PHO1(4) = -ECM2*(U*X1+V*X2)
      PHO1(5) = XM3
      PHO2(1) = -PHO1(1)
      PHO2(2) = -PHO1(2)
      PHO2(3) = -ECM2*(V*X1-U*X2)
      PHO2(4) = -ECM2*(V*X1+U*X2)
      PHO2(5) = XM4

C  convert to mass shell
      CALL PHO_MSHELL(PHO1,PHO2,XM3,XM4,PHO1,PHO2,IREJ)
      IF(IREJ.NE.0) THEN
        IF(IDEB(78).GE.5) WRITE(ErrorOut,'(1X,A,1P,3E11.3)')
     &    'PHO_HARSCA: REJECTION BY PHO_MSHELL (PT,M1,M2)',
     &    PT,XM3,XM4
        GOTO 111
      ENDIF
      PTFIN = SQRT(PHO1(1)**2+PHO1(2)**2)

C  debug output
      IF(IDEB(78).GE.20) THEN
        SHAT = X1*X2*ECMP*ECMP
        WRITE(ErrorOut,
     * '(1X,A,5I4)') 'PHO_HARSCA: MSPR,IA,IB,IC,ID',
     &    MSPR,IA,IB,IC,ID
        WRITE(ErrorOut,
     * '(5X,A,1P,4E11.3)') 'X1/2,MU2,Q2 ',X1,X2,QQPD,QQAL
        WRITE(ErrorOut,
     * '(5X,A,1P,4E11.3)') 'U,V,PT,SHAT ',U,V,PT,SHAT
        WRITE(ErrorOut,'(5X,A,1P,5E11.3)') 'PHI1 ',PHI1
        WRITE(ErrorOut,'(5X,A,1P,5E11.3)') 'PHI2 ',PHI2
        WRITE(ErrorOut,'(5X,A,1P,5E11.3)') 'PHO1 ',PHO1
        WRITE(ErrorOut,'(5X,A,1P,5E11.3)') 'PHO2 ',PHO2
      ENDIF

      END


CDECK  ID>, PHO_HARFAC
      SUBROUTINE PHO_HARFAC(PTCUT,ECMI)
C*********************************************************************
C
C     initialization: find scaling factors and maxima of remaining
C                     weights
C
C     input:   PTCUT  transverse momentum cutoff
C              ECMI   cms energy
C
C     output:  Hfac(-1:Max_pro_2)  field for sampling hard processes
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER ( MXABWT = 96 )

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF

C  integration precision for hard cross sections (obsolete)
      INTEGER NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO
      COMMON /POGAUP/ NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)


      DIMENSION       ABSZ(MXABWT),WEIG(MXABWT)
      DIMENSION S(-1:MAX_PRO_2),S1(-1:MAX_PRO_2),S2(-1:MAX_PRO_2),
     &          F124(-1:MAX_PRO_2)
      DATA F124 / 1.D0,0.D0,
     &            4.D0,2.D0,2.D0,2.D0,4.D0,1.D0,4.D0,4.D0,0.D0,1.D0,
     &            2.D0,1.D0,2.D0,1.D0,0.D0,1.D0 /

      SS     = ECMI*ECMI
      AH     = (2.D0*PTCUT/ECMI)**2
      ALN    = LOG(AH)
      HLN    = LOG(0.5D0)
      NPOINT = NGAUIN
      CALL PHO_GAUSET(0.D0,1.D0,NPOINT,ABSZ,WEIG)
      DO 10 M=-1,MAX_PRO_2
        S1(M) = 0.D0
10    CONTINUE

C  resolved processes
      DO 80 I1=1,NPOINT
        Z1   = ABSZ(I1)
        X1   = EXP(ALN*Z1)
        DO 20 M=-1,9
          S2(M) = 0.D0
20      CONTINUE

        DO 60 I2=1,NPOINT
          Z2    = (1.D0-Z1)*ABSZ(I2)
          X2    = EXP(ALN*Z2)
          FAXX  = AH/(X1*X2)
          W     = SQRT(1.D0-FAXX)
          W1    = FAXX/(1.+W)
          WLOG  = LOG(W1)
          FWW   = FAXX*WLOG/W
          DO 30 M=-1,9
            S(M) = 0.D0
30        CONTINUE

          DO 40 I=1,NPOINT
            Z   = ABSZ(I)
            VA  =-0.5D0*W1/(W1+Z*W)
            UA  =-1.D0-VA
            VB  =-0.5D0*FAXX/(W1+2.D0*W*Z)
            UB  =-1.D0-VB
            VC  =-EXP(HLN+Z*WLOG)
            UC  =-1.D0-VC
            VE  =-0.5D0*(1.D0+W)+Z*W
            UE  =-1.D0-VE
            S(1)  = S(1)+(1.+W)*2.25*(VA*VA*(3.-UA*VA-VA/(UA*UA))-UA)*
     &           WEIG(I)
            S(2)  = S(2)+(VC*VC+UC*UC)*((16./27.)/UC-(4./3.)*VC)*FWW*
     &            WEIG(I)
            S(3)  = S(3)+(1.+W)*(1.+UA*UA)*(1.-(4./9.)*VA*VA/UA)*WEIG(I)
            S(5)  = S(5)+((4./9.)*(1.+UB*UB+(UB*UB+VB*VB)*VB*VB)-
     &            (8./27.)*UA*UA*VA)*WEIG(I)
            S(6)  = S(6)+(4./9.)*(UE*UE+VE*VE)*FAXX*WEIG(I)
            S(7)  = S(7)+(1.+W)*((2./9.)*(1.+UA*UA+(1.+VA*VA)*VA*VA/
     &            (UA*UA))-(4./27.)*VA/UA)*WEIG(I)
            S(8)  = S(8)+(4./9.)*(1.+UB*UB)*WEIG(I)
            S(-1) = S(-1)+(1.+VC*VC)*(VC/(UC*UC)-(4./9.))*FWW*WEIG(I)
40        CONTINUE
          S(4)    = S(2)*(9./32.)
          DO 50 M=-1,8
            S2(M) = S2(M)+S(M)*WEIG(I2)*W
50        CONTINUE
60      CONTINUE
        DO 70 M=-1,8
          S1(M) = S1(M)+S2(M)*(1.D0-Z1)*WEIG(I1)
70      CONTINUE
80    CONTINUE
      S1(4) = S1(4)*NF
      S1(6) = S1(6)*MAX(0,NF-1)
C
C  direct processes
      IF((IDPDG1.EQ.22).OR.(IDPDG1.EQ.990)
     &   .OR.(IDPDG2.EQ.22).OR.(IDPDG2.EQ.990)) THEN
        DO 180 I1=1,NPOINT
          Z2   = ABSZ(I1)
          X2   = EXP(ALN*Z2)
          FAXX  = AH/X2
          W     = SQRT(1.D0-FAXX)
          W1    = FAXX/(1.D0+W)
          WLOG  = LOG(W1)
          WL = LOG(FAXX/(1.D0+W)**2)
          FWW1  = FAXX*WL/ALN
          FWW2  = FAXX*WLOG/ALN
          DO 130 M=10,12
            S(M) = 0.D0
 130      CONTINUE
C
          DO 140 I=1,NPOINT
            Z   = ABSZ(I)
            UA  =-(1.D0+W)/2.D0*EXP(Z*WL)
            VA  =-1.D0-UA
            VB  =-EXP(HLN+Z*WLOG)
            UB  =-1.D0-VB
            S(10)  = S(10)+(8.D0/3.D0)*(1.D0+UA*UA)*WEIG(I)*FWW1
            S(11) = S(11)-(VB*VB+UB*UB)/UB*WEIG(I)*FWW2
 140      CONTINUE
          DO 170 M=10,11
            S1(M) = S1(M)+S(M)*WEIG(I1)
 170      CONTINUE
 180    CONTINUE
        S1(12) = S1(10)
        S1(13) = S1(11)
C  quark charges fractions
        IF(IDPDG1.EQ.22) THEN
          CHRNF = 0.D0
          DO 100 I=1,NF
            CHRNF = CHRNF + Q_CH2(I)
 100      CONTINUE
          S1(11) = S1(11)*CHRNF
        ELSE IF(IDPDG1.EQ.990) THEN
          S1(11) = S1(11)*NF
        ELSE
          S1(11) = 0.D0
        ENDIF
        IF(IDPDG2.EQ.22) THEN
          CHRNF = 0.D0
          DO 200 I=1,NF
            CHRNF = CHRNF + Q_CH2(I)
 200      CONTINUE
          S1(13) = S1(13)*CHRNF
        ELSE IF(IDPDG2.EQ.990) THEN
          S1(13) = S1(13)*NF
        ELSE
          S1(13) = 0.D0
        ENDIF
      ENDIF
C
C  global factors
      FFF    = PI*GEV2MB*ALN*ALN/(AH*SS)
      DO 90 M=-1,MAX_PRO_2
        HFAC(M) = MAX(FFF*F124(M)*S1(M),0.D0)
90    CONTINUE
C
C  double direct process
      IF(((IDPDG1.EQ.22).OR.(IDPDG1.EQ.990))
     &   .AND.((IDPDG2.EQ.22).OR.(IDPDG2.EQ.990))) THEN
        FAC = 0.D0
        DO 300 I=1,NF
          IF(IDPDG1.EQ.22) THEN
            F1 = Q_CH2(I)
          ELSE
            F1 = 1.D0
          ENDIF
          IF(IDPDG2.EQ.22) THEN
            F2 = Q_CH2(I)
          ELSE
            F2 = 1.D0
          ENDIF
          FAC = FAC+F1*F2*3.D0
 300    CONTINUE
        ZZ = SQRT(1.D0-4.D0*PTCUT*PTCUT/SS)
        HFAC(14) = 4.D0*PI/SS*(LOG((1.D0+ZZ)/(1.D0-ZZ))-ZZ)
     &               *GEV2MB*FAC
      ENDIF
      END


CDECK  ID>, PHO_HARWGX
      SUBROUTINE PHO_HARWGX(PTCUT,ECM)
C**********************************************************************
C
C     find maximum of remaining weight for MC sampling
C
C     input:   PTCUT  transverse momentum cutoff
C              ECM    cms energy
C
C     output:  HWgx(-1:Max_pro_2)  field for sampling hard processes
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( NKM = 10 )
      PARAMETER ( TINY = 1.D-20 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)


      DIMENSION Z(3),D(3),FF(0:NKM),PDA(-6:6),PDB(-6:6),XM1(NKM),
     &  XM2(NKM),PTM(NKM),ZMX(3,NKM),DMX(3,NKM),IMX(NKM),IPO(NKM)
      DIMENSION IFTAB(-1:MAX_PRO_2)
      DATA IFTAB  / 4,0,1,2,4,1,2,2,3,5,0,6,7,8,9,10,0,10 /

C  initial settings
      AH    = (2.D0*PTCUT/ECM)**2
      ALNH  = LOG(AH)
      FF(0) = 0.D0
      DO 22 I=1,NKM
        FF(I) = 0.D0
        XM1(I) = 0.D0
        XM2(I) = 0.D0
        PTM(I) = 0.D0
        ZMX(1,I) = 0.D0
        ZMX(2,I) = 0.D0
        ZMX(3,I) = 0.D0
        DMX(1,I) = 0.D0
        DMX(2,I) = 0.D0
        DMX(3,I) = 0.D0
        IMX(I) = 0
        IPO(I) = 0
 22   CONTINUE

      NKML = 10
      DO 40 NKON=1,NKML

        DO 50 IST=1,3
C  start configuration
        IF(IST.EQ.1) THEN
          Z(1) = MIN(0.999D0,LOG(0.5D0)/LOG(AH))
          Z(2) = 0.5
          Z(3) = 0.1
          D(1) =-0.5
          D(2) = 0.5
          D(3) = 0.5
        ELSE IF(IST.EQ.2) THEN
          Z(1) = 0.999D0
          Z(2) = 0.5
          Z(3) = 0.0
          D(1) =-0.5
          D(2) = 0.5
          D(3) = 0.5
        ELSE IF(IST.EQ.3) THEN
          Z(1) = MIN(0.999D0,LOG(0.5D0)/LOG(AH))
          Z(2) = 0.1
          Z(3) = 0.1
          D(1) =-0.5
          D(2) = 0.5
          D(3) = 0.5
        ELSE IF(IST.EQ.4) THEN
          Z(1) = MIN(0.999D0,LOG(0.5D0)/LOG(AH))
          Z(2) = 0.9
          Z(3) = 0.1
          D(1) =-0.5
          D(2) = 0.5
          D(3) = 0.5
        ENDIF
        IT   = 0
        CALL PHO_HARWGI(ECM,PTCUT,NKON,Z,F2)
C  process possible?
        IF(F2.LE.0.D0) GOTO 35

 10     CONTINUE
          IT   = IT+1
          FOLD = F2
          DO 30 I=1,3
            D(I) = D(I)/5.D0
            Z(I)   = Z(I)+D(I)
            CALL PHO_HARWGI(ECM,PTCUT,NKON,Z,F3)
            IF ( F2.GT.F3 ) Z(I) = Z(I)-D(I)
            IF ( F2.GT.F3 ) D(I) =-D(I)
 20         CONTINUE
              F1   = MIN(F2,F3)
              F2   = MAX(F2,F3)
              Z(I) = Z(I)+D(I)
              CALL PHO_HARWGI(ECM,PTCUT,NKON,Z,F3)
            IF ( F3.GT.F2 ) GOTO 20
            ZZ     = Z(I)-D(I)
            Z(I)   = ZZ+0.5*D(I)*(F3-F1)/MAX(TINY,F2+F2-F1-F3)
            IF ( ABS(ZZ-Z(I)).GT.D(I)*0.1D0 )
     &        CALL PHO_HARWGI(ECM,PTCUT,NKON,Z,F1)
            IF ( F1.LE.F2 ) Z(I) = ZZ
            F2     = MAX(F1,F2)
 30       CONTINUE
        IF((ABS(FOLD-F2)/MAX(TINY,F2).GT.0.002D0).OR.(IT.LT.3)) GOTO 10

        IF(F2.GT.FF(NKON)) THEN
          FF(NKON)  = MAX(F2,0.D0)
          XM1(NKON) = X1
          XM2(NKON) = X2
          PTM(NKON) = PT
          ZMX(1,NKON) = Z(1)
          ZMX(2,NKON) = Z(2)
          ZMX(3,NKON) = Z(3)
          DMX(1,NKON) = D(1)
          DMX(2,NKON) = D(2)
          DMX(3,NKON) = D(3)
          IMX(NKON) = IT
          IPO(NKON) = IST
        ENDIF
C
 50     CONTINUE
 35     CONTINUE
 40   CONTINUE

C  debug output
      IF(IDEB(38).GE.5) THEN
        WRITE(ErrorOut,'(/1X,A)')
     &    'PHO_HARWGX: MAXIMUM OF WEIGHT (I,IT,IS,FF,Z(1-3),D(1-3))'
        DO 60 I=1,NKM
          IF(IMX(I).NE.0) WRITE(ErrorOut,
     * '(1X,I2,I3,I2,7E10.3)') I,IMX(I),
     &      IPO(I),FF(I),ZMX(1,I),ZMX(2,I),ZMX(3,I),DMX(1,I),
     &      DMX(2,I),DMX(3,I)
 60     CONTINUE
      ENDIF

      DO 70 I=-1,MAX_PRO_2
        HWGX(I)  = MAX(FF(IFTAB(I))*HFAC(I),0.D0)
 70   CONTINUE

C  debug output
      IF(IDEB(38).GE.5) THEN
        WRITE(ErrorOut,'(/1X,A)') 'PHO_HARWGX: total weights'
        WRITE(ErrorOut,
     * '(5X,A)') 'I    X1   X2   PT   HWgx(I)  FDIS'
        DO 80 I=-1,MAX_PRO_2
          IF((IFTAB(I).NE.0).AND.(HWGX(I).GT.0.D0)) THEN
            MSPR = I
            X1 = MIN(XM1(IFTAB(I)),0.9999999999D0)
            X2 = MIN(XM2(IFTAB(I)),0.9999999999D0)
            PT = PTM(IFTAB(I))
            CALL PHO_HARWGH(PDS,PDA,PDB,FDIS)
            WRITE(ErrorOut,
     * '(1X,I3,5E12.3)') I,X1,X2,PT,HWGX(I),FDIS
          ENDIF
 80     CONTINUE
      ENDIF

      END


CDECK  ID>, PHO_HARWGI
      SUBROUTINE PHO_HARWGI(ECMX,PTCUT,NKON,Z,FDIS)
C**********************************************************************
C
C     auxiliary subroutine to find maximum of remaining weight
C
C     input:  ECMX   current CMS energy
C             PTCUT  current pt cutoff
C             NKON   process label  1..5  resolved
C                                   6..7  direct particle 1
C                                   8..9  direct particle 2
C                                   10    double direct
C             Z(3)   transformed variable
C
C     output: remaining weight
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      DIMENSION Z(3)

      PARAMETER ( NKM   = 10 )
      PARAMETER ( TINY  = 1.D-30,
     &            TINY6 = 1.D-06 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF

C  some hadron information, will be deleted in future versions
      INTEGER NFS
      DOUBLE PRECISION QMASS,BET,PCOUDI,PNORM,VALPRG
      COMMON /POHDRN/ QMASS(6),BET,PCOUDI,PNORM,VALPRG(2),NFS

C  scale parameters for parton model calculations
      INTEGER NQQAL,NQQALI,NQQALF,NQQPD
      DOUBLE PRECISION AQQAL,AQQALI,AQQALF,AQQPD
      COMMON /POHSCL/ AQQAL,AQQALI,AQQALF,AQQPD,
     &                NQQAL,NQQALI,NQQALF,NQQPD

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC


      DOUBLE PRECISION PHO_ALPHAS,PHO_ALPHAE
      DIMENSION F(NKM),PDA(-6:6),PDB(-6:6)


      FDIS = 0.D0

      IF(IDEB(64).GE.25) WRITE(ErrorOut,'(1X,A,/5X,5E12.3,I5)')
     &  'PHO_HARWGI: ECM,PT,Z,NK',ECMX,PTCUT,Z,NKON
C  check input values
      IF ( Z(1).LT.0.D0  .OR.  Z(1).GT.1.D0 ) RETURN
      IF ( Z(2).LT.0.D0  .OR.  Z(2).GT.1.D0 ) RETURN
      IF ( Z(3).LT.0.D0  .OR.  Z(3).GT.1.D0 ) RETURN
C  transformations
      Y1    = EXP(ALNH*Z(1))
      IF(NKON.LE.5) THEN
C  resolved kinematic
        Y2  =-(1.D0-Y1)+2.D0*(1.D0-Y1)*Z(2)
        X1  = 0.5D0*(Y2+SQRT(Y2*Y2+4.D0*Y1))
        X2  = X1-Y2
        X1 = MIN(X1,0.999999999999D0)
        X2 = MIN(X2,0.999999999999D0)
      ELSE IF(NKON.LE.7) THEN
C  direct kinematic 1
        X1 = 1.D0
        X2 = MIN(Y1,0.999999999999D0)
      ELSE IF(NKON.LE.9) THEN
C  direct kinematic 2
        X1 = MIN(Y1,0.999999999999D0)
        X2 = 1.D0
      ELSE
C  double direct kinematic
        X1 = 1.D0
        X2 = 1.D0
      ENDIF
      W   = SQRT(MAX(TINY,1.D0-AH/Y1))
      V   =-0.5D0+W*(Z(3)-0.5D0)
      U   =-(1.D0+V)
      PT  = MAX(SQRT(U*V*Y1*ECMX*ECMX),PTCUT)

C  set hard scale  QQ  for alpha and partondistr.
      IF     ( NQQAL.EQ.1 ) THEN
        QQAL = AQQAL*PT*PT
      ELSEIF ( NQQAL.EQ.2 ) THEN
        QQAL = AQQAL*Y1*ECMX*ECMX*U*V/(1.+V*V+U*U)
      ELSEIF ( NQQAL.EQ.3 ) THEN
        QQAL = AQQAL*Y1*ECMX*ECMX
      ELSEIF ( NQQAL.EQ.4 ) THEN
        QQAL = AQQAL*Y1*ECMX*ECMX*(U*V)**(1./3.)
      ENDIF
      IF     ( NQQPD.EQ.1 ) THEN
        QQPD = AQQPD*PT*PT
      ELSEIF ( NQQPD.EQ.2 ) THEN
        QQPD = AQQPD*Y1*ECMX*ECMX*U*V/(1.+V*V+U*U)
      ELSEIF ( NQQPD.EQ.3 ) THEN
        QQPD = AQQPD*Y1*ECMX*ECMX
      ELSEIF ( NQQPD.EQ.4 ) THEN
        QQPD = AQQPD*Y1*ECMX*ECMX*(U*V)**(1./3.)
      ENDIF
C
      IF(NKON.LE.5) THEN
        DO 10 N=1,5
          F(N) = 0.D0
 10     CONTINUE
C  resolved processes
        ALPHA1 = PHO_ALPHAS(QQAL,3)
        ALPHA2 = ALPHA1
        CALL PHO_PDF(1,X1,QQPD,0.D0,PDA)
        CALL PHO_PDF(2,X2,QQPD,0.D0,PDB)
C  calculate full distribution FDIS
        DO 20 I=1,NF
          F(2) = F(2)+PDA(I)*PDB(-I)+PDA(-I)*PDB( I)
          F(3) = F(3)+PDA(I)*PDB( I)+PDA(-I)*PDB(-I)
          F(4) = F(4)+PDA(I)+PDA(-I)
          F(5) = F(5)+PDB(I)+PDB(-I)
20      CONTINUE
        F(1)   = PDA(0)*PDB(0)
        T      = PDA(0)*F(5)+PDB(0)*F(4)
        F(5)   = F(4)*F(5)-(F(2)+F(3))
        F(4)   = T
      ELSE IF(NKON.LE.7) THEN
C  direct processes particle 1
        IF(IDPDG1.EQ.22) THEN
          ALPHA1 = PHO_ALPHAE(QQAL)
          CH1 = 4.D0/9.D0
          CH2 = 3.D0/9.D0
        ELSE IF(IDPDG1.EQ.990) THEN
          ALPHA1 = PARMDL(74)
          CH1 = 1.D0
          CH2 = 0.D0
        ELSE
          FDIS = -1.D0
          RETURN
        ENDIF
        ALPHA2 = PHO_ALPHAS(QQAL,2)
        CALL PHO_PDF(2,X2,QQPD,0.D0,PDB)
        F(6) = 0.D0
        DO 30 I=1,NF
          F(6) = F(6)+(PDB(I)+PDB(-I))*(CH1-CH2*MOD(I,2))
 30     CONTINUE
        F(7)   = PDB(0)
      ELSE IF(NKON.LE.9) THEN
C  direct processes particle 2
        ALPHA1 = PHO_ALPHAS(QQAL,1)
        IF(IDPDG2.EQ.22) THEN
          ALPHA2 = PHO_ALPHAE(QQAL)
          CH1 = 4.D0/9.D0
          CH2 = 3.D0/9.D0
        ELSE IF(IDPDG2.EQ.990) THEN
          ALPHA2 = PARMDL(74)
          CH1 = 1.D0
          CH2 = 0.D0
        ELSE
          FDIS = -1.D0
          RETURN
        ENDIF
        CALL PHO_PDF(1,X1,QQPD,0.D0,PDA)
        F(8) = 0.D0
        DO 40 I=1,NF
          F(8) = F(8)+(PDA(I)+PDA(-I))*(CH1-CH2*MOD(I,2))
 40     CONTINUE
        F(9)   = PDA(0)
      ELSE
C  double direct process
        SSR = ECMX*ECMX
        IF(IDPDG1.EQ.22) THEN
          ALPHA1 = PHO_ALPHAE(SSR)
        ELSE IF(IDPDG1.EQ.990) THEN
          ALPHA1 = PARMDL(74)
        ELSE
          FDIS = -1.D0
          RETURN
        ENDIF
        IF(IDPDG2.EQ.22) THEN
          ALPHA2 = PHO_ALPHAE(SSR)
        ELSE IF(IDPDG2.EQ.990) THEN
          ALPHA2 = PARMDL(74)
        ELSE
          FDIS = -1.D0
          RETURN
        ENDIF
        F(10) = 1.D0
      ENDIF

      FDIS   = MAX(0.D0,F(NKON)*ALPHA1*ALPHA2)

C  debug output
      IF(IDEB(64).GE.20) WRITE(ErrorOut,
     * '(1X,A,/2X,I3,2I6,7E11.3)')
     &  'PHO_HARWGI: NKON,ID1,ID2,AL1,AL2,X1,X2,PT,F(NKON),FDIS',
     &  NKON,IDPDG1,IDPDG2,ALPHA1,ALPHA2,X1,X2,PT,F(NKON),FDIS

      END


CDECK  ID>, PHO_HARINI
      SUBROUTINE PHO_HARINI(IP,IDP1,IDP2,PV1,PV2,NOUT,MODE)
C**********************************************************************
C
C     initialize calculation of hard cross section
C
C     must not be called during MC generation
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS   = 1.D-10 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  scale parameters for parton model calculations
      INTEGER NQQAL,NQQALI,NQQALF,NQQPD
      DOUBLE PRECISION AQQAL,AQQALI,AQQALF,AQQPD
      COMMON /POHSCL/ AQQAL,AQQALI,AQQALF,AQQPD,
     &                NQQAL,NQQALI,NQQALF,NQQPD

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF


      DOUBLE PRECISION PHO_ALPHAS

      CHARACTER*20 RFLAG

C  set local Pomeron c.m. system data
      IDPDG1    = IDP1
      IDPDG2    = IDP2
      PVIRTP(1) = PV1
      PVIRTP(2) = PV2
C  initialize PDFs
      CALL PHO_ACTPDF(IDPDG1,1)
      CALL PHO_ACTPDF(IDPDG2,2)
C  initialize alpha_s calculation
      DUMMY = PHO_ALPHAS(0.D0,-4)
C  initialize scales with defaults
      IF((IDPDG1.EQ.22).OR.(IDPDG1.EQ.990)) THEN
        IF((IDPDG2.EQ.22).OR.(IDPDG2.EQ.990)) THEN
          AQQAL  = PARMDL(83)
          AQQALI = PARMDL(86)
          AQQALF = PARMDL(89)
          AQQPD  = PARMDL(92)
          NQQAL  = IPAMDL(83)
          NQQALI = IPAMDL(86)
          NQQALF = IPAMDL(89)
          NQQPD  = IPAMDL(92)
        ELSE
          AQQAL  = PARMDL(82)
          AQQALI = PARMDL(85)
          AQQALF = PARMDL(88)
          AQQPD  = PARMDL(91)
          NQQAL  = IPAMDL(82)
          NQQALI = IPAMDL(85)
          NQQALF = IPAMDL(88)
          NQQPD  = IPAMDL(91)
        ENDIF
      ELSE IF((IDPDG2.EQ.22).OR.(IDPDG2.EQ.990)) THEN
        AQQAL  = PARMDL(82)
        AQQALI = PARMDL(85)
        AQQALF = PARMDL(88)
        AQQPD  = PARMDL(91)
        NQQAL  = IPAMDL(82)
        NQQALI = IPAMDL(85)
        NQQALF = IPAMDL(88)
        NQQPD  = IPAMDL(91)
      ELSE
        AQQAL  = PARMDL(81)
        AQQALI = PARMDL(84)
        AQQALF = PARMDL(87)
        AQQPD  = PARMDL(90)
        NQQAL  = IPAMDL(81)
        NQQALI = IPAMDL(84)
        NQQALF = IPAMDL(87)
        NQQPD  = IPAMDL(90)
      ENDIF
      IF(PARMDL(109+IP).LT.DEPS) PARMDL(109+IP) = AQQAL
      IF(PARMDL(113+IP).LT.DEPS) PARMDL(113+IP) = AQQALI
      IF(PARMDL(117+IP).LT.DEPS) PARMDL(117+IP) = AQQALF
      IF(PARMDL(121+IP).LT.DEPS) PARMDL(121+IP) = AQQPD
      IF(IPAMDL(64+IP).LT.0) IPAMDL(64+IP) = NQQAL
      IF(IPAMDL(68+IP).LT.0) IPAMDL(68+IP) = NQQALI
      IF(IPAMDL(72+IP).LT.0) IPAMDL(72+IP) = NQQALF
      IF(IPAMDL(76+IP).LT.0) IPAMDL(76+IP) = NQQPD
      AQQAL  = PARMDL(109+IP)
      AQQALI = PARMDL(113+IP)
      AQQALF = PARMDL(117+IP)
      AQQPD  = PARMDL(121+IP)
      NQQAL  = IPAMDL(64+IP)
      NQQALI = IPAMDL(68+IP)
      NQQALF = IPAMDL(72+IP)
      NQQPD  = IPAMDL(76+IP)
      PTCUT(1) = PARMDL(36)
      PTCUT(2) = PARMDL(37)
      PTCUT(3) = PARMDL(38)
      PTCUT(4) = PARMDL(39)
      PTANO(1) = PARMDL(130)
      PTANO(2) = PARMDL(131)
      PTANO(3) = PARMDL(132)
      PTANO(4) = PARMDL(133)
      RFLAG = '(ENERGY-INDEPENDENT)'
      IF(IPAMDL(7).GT.0) RFLAG = '(ENERGY-DEPENDENT)'

C  write out all settings
      IF((IDEB(66).GE.15).OR.(MODE.GT.0)) THEN
        WRITE(ErrorOut,1050) IP,IDPDG1,IDPDG2,PTCUT(IP),RFLAG,
     &    PDFNAM(1),IGRP(1),ISET(1),IEXT(1),
     &    PDFNAM(2),IGRP(2),ISET(2),IEXT(2),
     &    PDFLAM,NF,NQQAL,AQQAL,NQQPD,AQQPD
1050    FORMAT(/,
     &    ' PHO_HARINI: HARD SCATTERING PARAMETERS FOR IP:',I3/,
     &    5X,'PARTICLE 1 / PARTICLE 2:',2I8,/,
     &    5X,'MIN. PT   :',F7.1,2X,A,/,
     &    5X,'PDF SIDE 1:',2X,A8,' IGRP/ISET/IEXT ',3I4,/,
     &    5X,'PDF SIDE 2:',2X,A8,' IGRP/ISET/IEXT ',3I4,/,
     &    5X,'LAMBDA1,2 (4 ACTIVE FLAVOURS):',2F8.3,/,
     &    5X,'MAX. NUMBER OF ACTIVE FLAVOURS NF  :',I3,/,
     &    5X,'NQQAL/AQQAL/NQQPD/AQQPD:',I5,F8.3,I5,F8.3)
      ENDIF

      END


CDECK  ID>, PHO_HARINT
      SUBROUTINE PHO_HARINT(IPP,ECM,P2V1,P2V2,I1,I2,K1,K2,MSPOM)
C**********************************************************************
C
C     interpolate cross sections and weights for hard scattering
C
C     input:  IPP    particle combination (neg. for add. user cuts)
C             ECM    CMS energy (GeV)
C             P2V1/2 particle virtualities (pos., GeV**2)
C             I1     first subprocess to calculate
C             I2     last subprocess to calculate
C                    <-1  only scales and cutoffs calculated
C             K1     first variable to calculate
C             K2     last variable to calculate
C             MSPOM  cross sections to use for pt distribution
C                    0  reggeon
C                    >0 pomeron
C
C             for K1 < 3 the soft pt distribution is also calculated
C
C     output: interpolated values in HWgx, HSig, Hdpt
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS   = 1.D-15,
     &            DEPS2  = 2.D-15 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  parameters of 2x2 channel model
      DOUBLE PRECISION PHISUP,RMASS,VAR,AMPFAC,ELAFAC,VFAC
      COMMON /PO2CHA/ PHISUP(2),RMASS(2),VAR,AMPFAC(4),ELAFAC(4),VFAC

C  data needed for soft-pt calculation
      DOUBLE PRECISION SIGS,DSIGHP,SIGH,FS,FH,BETAS,AAS,PTCON
      COMMON /POINT3/ SIGS,DSIGHP,SIGH,FS,FH,BETAS(3),AAS,PTCON

C  scale parameters for parton model calculations
      INTEGER NQQAL,NQQALI,NQQALF,NQQPD
      DOUBLE PRECISION AQQAL,AQQALI,AQQALF,AQQPD
      COMMON /POHSCL/ AQQAL,AQQALI,AQQALF,AQQPD,
     &                NQQAL,NQQALI,NQQALF,NQQPD

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)

C  parameters for DGLAP backward evolution in ISR
      INTEGER NFSISR
      DOUBLE PRECISION Q2MISR,PMISR,ZMISR,AL2ISR
      COMMON /PODGL1/ Q2MISR(2),PMISR(2),ZMISR(2),AL2ISR(2),NFSISR

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)

C  interpolation tables for hard cross section and MC selection weights
      INTEGER MAX_TAB_E,MAX_TAB_Q2,MAX_PRO_TAB
      PARAMETER ( MAX_TAB_E = 20, MAX_TAB_Q2 = 10, MAX_PRO_TAB = 16 )
      INTEGER IH_Q2A_UP,IH_Q2B_UP,IH_ECM_UP
      DOUBLE PRECISION HFAC_TAB,HWGX_TAB,HSIG_TAB,HDPT_TAB,
     &  HQ2A_TAB,HQ2B_TAB,HECM_TAB
      COMMON /POHTAB/
     &  HFAC_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HWGX_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HSIG_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HDPT_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HQ2A_TAB(1:MAX_TAB_Q2,0:4),HQ2B_TAB(1:MAX_TAB_Q2,0:4),
     &  HECM_TAB(1:MAX_TAB_E,0:4),
     &  IH_Q2A_UP(0:4),IH_Q2B_UP(0:4),IH_ECM_UP(0:4)

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX


      DOUBLE PRECISION XP,PTS
      DIMENSION XP(2),PTS(0:2,2)

      INTEGER IV
      DIMENSION IV(2)


      IF(IDEB(58).GE.25) WRITE(ErrorOut,
     * '(1X,2A,/,5X,I2,3E12.3,5I4)')
     &    'PHO_HARINT: CALLED WITH ',
     &    'IPP,ECM,P2V1,P2V2,I1,I2,K1,K2,MSPOM',
     &    IPP,ECM,P2V1,P2V2,I1,I2,K1,K2,MSPOM

      IP = ABS(IPP)
      IF(IPP.GT.0) THEN
C  default minimum bias cutoff
        PTCUT(IP) = PHO_PTCUT(ECM,IP)
      ELSE
C  user defined additional cutoff
        PTCUT(IP) = HSWCUT(4+IP)
      ENDIF
      PTWANT = PTCUT(IP)

C  ISR cutoffs
      Q2CUT     = MIN(PTWANT**2,PARMDL(125+IP))
      Q2MISR(1) = MAX(P2V1,Q2CUT)
      Q2MISR(2) = MAX(P2V2,Q2CUT)
C  cutoff for direct photon contribution to photon PDF
      PTANO(IP) = MIN(PTCUT(IP),PARMDL(129+IP))
      PTA1      = PTANO(IP)
C  scales for hard scattering
      AQQAL  = PARMDL(109+IP)
      AQQALI = PARMDL(113+IP)
      AQQALF = PARMDL(117+IP)
      AQQPD  = PARMDL(121+IP)
      NQQAL  = IPAMDL(64+IP)
      NQQALI = IPAMDL(68+IP)
      NQQALF = IPAMDL(72+IP)
      NQQPD  = IPAMDL(76+IP)
      IF(IDEB(58).GE.15) WRITE(ErrorOut,'(1X,A,4I3,4E10.3)')
     &  'PHO_HARINT: SCALES:',
     &  NQQAL,NQQALI,NQQALF,NQQPD,AQQAL,AQQALI,AQQALF,AQQPD

      IF(I2.LT.-1) RETURN

      IL = IP
      IF(IPP.LT.0) IL = 0

C  double-log interpolation
      IF(ECM.LT.2.1D0*PTCUT(IP)) THEN
        DO 50 M=I1,I2
          HFAC(M) = 0.D0
          HWGX(M) = 0.D0
          HSIG(M) = 0.D0
          HDPT(M) = 0.D0
 50     CONTINUE
      ELSE
        I=1
 310    CONTINUE
          I = I+1
        IF((ECM.GT.HECM_TAB(I,IL)).AND.(I.LT.IH_ECM_UP(IL))) GOTO 310

        IA = 1
        IB = 1
        FAC = LOG(ECM/HECM_TAB(I-1,IL))
     &       /LOG(HECM_TAB(I,IL)/HECM_TAB(I-1,IL))
        DO M=I1,I2
C  factor due to phase space integration
          XX = LOG(HFAC_TAB(M,I-1,IA,IB,IL)+DEPS) + FAC
     &      *LOG((HFAC_TAB(M,I,IA,IB,IL)+DEPS)
     &           /(HFAC_TAB(M,I-1,IA,IB,IL)+DEPS))
          XX = EXP(XX)
          IF(XX.LT.DEPS2) XX = 0.D0
          HFAC(M) = XX
C  max. weight
          XX = LOG(HWGX_TAB(M,I-1,IA,IB,IL)+DEPS) + FAC
     &      *LOG((HWGX_TAB(M,I,IA,IB,IL)+DEPS)
     &           /(HWGX_TAB(M,I-1,IA,IB,IL)+DEPS))
          XX = EXP(XX)
          IF(XX.LT.DEPS2) XX = 0.D0
          HWGX(M) = XX*1.2D0
C  hard cross section
          XX = LOG(HSIG_TAB(M,I-1,IA,IB,IL)+DEPS) + FAC
     &      *LOG((HSIG_TAB(M,I,IA,IB,IL)+DEPS)
     &           /(HSIG_TAB(M,I-1,IA,IB,IL)+DEPS))
          XX = EXP(XX)
          IF(XX.LT.DEPS2) XX = 0.D0
          HSIG(M) = XX
C  differential hard cross section
          XX = LOG(HDPT_TAB(M,I-1,IA,IB,IL)+DEPS) + FAC
     &      *LOG((HDPT_TAB(M,I,IA,IB,IL)+DEPS)
     &           /(HDPT_TAB(M,I-1,IA,IB,IL)+DEPS))
          XX = EXP(XX)
          IF(XX.LT.DEPS2) XX = 0.D0
          HDPT(M) = XX
        ENDDO
      ENDIF

      IF((K1.LT.3).AND.(K2.GE.3)) THEN
C  cross check
        IF((I1.GT.9).OR.(I2.LT.9)) THEN
          WRITE(ErrorOut,'(1X,2A,2I4)') 'PHO_HARINT: ',
     &      'HARD CROSS SECTION NOT CALCULATED ',I1,I2
        ENDIF
        SIGH   = HSIG(9)
        DSIGHP = HDPT(9)
C  load soft cross sections from interpolation table
        IF(ECM.LE.SIGECM(IP,1)) THEN
          L1 = 1
          L2 = 1
        ELSE IF(ECM.LT.SIGECM(IP,ISIMAX)) THEN
          DO 55 I=2,ISIMAX
            IF(ECM.LE.SIGECM(IP,I)) GOTO 205
 55       CONTINUE
 205      CONTINUE
          L1 = I-1
          L2 = I
        ELSE
          WRITE(ErrorOut,'(/1X,A,I3,1P,2E11.3)')
     &      'PHO_HARINT: ENERGY TOO HIGH (IP,ECM,EMAX)',
     &      IP,ECM,SIGECM(IP,ISIMAX)
          CALL PHO_PREVNT(-1)
          L1 = ISIMAX-1
          L2 = ISIMAX
        ENDIF
        FAC2=0.D0
        IF(L1.NE.L2) FAC2=LOG(ECM/SIGECM(IP,L1))
     &                    /LOG(SIGECM(IP,L2)/SIGECM(IP,L1))
        FAC1=1.D0-FAC2
        SIGS = FAC2*(SIGTAB(IP,56,L2)+SIGTAB(IP,57,L2))+
     &         FAC1*(SIGTAB(IP,56,L1)+SIGTAB(IP,57,L1))

        FS = FPS(IP)
        FH = FPH(IP)
        CALL PHO_SOFTPT(-1,PTWANT,PTWANT,XP,IV,PTS)
      ENDIF

 300  CONTINUE

C  debug output
      IF(IDEB(58).GE.15) THEN
        WRITE(ErrorOut,'(1X,A,I10,3I2,2E10.3)')
     &    'PHO_HARINT: WEIGHTS EV,IP,K1/2,ECM,PTC',
     &    KEVENT,IP,K1,K2,ECM,PTCUT(IP)
        DO 162 M=I1,I2
          WRITE(ErrorOut,'(5X,2I3,1p,4E12.3)')
     &      M,MH_PRO_ON(M,IP),HFAC(M),HWGX(M),HSIG(M),HDPT(M)
 162    CONTINUE
      ENDIF

      END


      DOUBLE PRECISION FUNCTION PHO_PTCUT(ECM,IP)
C***********************************************************************
C
C     calculate energy-dependent transverse momentum cutoff
C
C***********************************************************************

      IMPLICIT NONE

      SAVE

      DOUBLE PRECISION ECM
      INTEGER IP

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


      PHO_PTCUT = PARMDL(35+IP)

      IF(IPAMDL(7).EQ.1) THEN
C  Bopp et al. type (DPMJET)
        PHO_PTCUT = PARMDL(35+IP)
     &             + MAX(0.D0,0.12D0*(LOG10(ECM/50.D0))**3)
      ELSE IF(IPAMDL(7).EQ.2) THEN
C  Gribov-Levin-Ryskin type
        PHO_PTCUT = PARMDL(35+IP)
     &             + 0.065D0*EXP(0.9D0*SQRT(2.D0*LOG(ECM)))
      ENDIF

      END


CDECK  ID>, PHO_HARMCI
      SUBROUTINE PHO_HARMCI(IP,EMAXF)
C**********************************************************************
C
C     initialize MC sampling and calculate hard cross section
C
C     input:  IP       particle combination (neg. number for user cut)
C             EMAXF    maximum CMS energy for
C                      interpolation table in reference to PTCUT(1..4)
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER (DEPS   = 1.D-10,
     &           PLARGE = 1.D20 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  scale parameters for parton model calculations
      INTEGER NQQAL,NQQALI,NQQALF,NQQPD
      DOUBLE PRECISION AQQAL,AQQALI,AQQALF,AQQPD
      COMMON /POHSCL/ AQQAL,AQQALI,AQQALF,AQQPD,
     &                NQQAL,NQQALI,NQQALF,NQQPD

C  names of hard scattering processes
      INTEGER MAX_PRO_1
      PARAMETER ( MAX_PRO_1 = 16 )
      CHARACTER*18 PROC
      COMMON /POHPRO/ PROC(0:MAX_PRO_1)

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)

C  interpolation tables for hard cross section and MC selection weights
      INTEGER MAX_TAB_E,MAX_TAB_Q2,MAX_PRO_TAB
      PARAMETER ( MAX_TAB_E = 20, MAX_TAB_Q2 = 10, MAX_PRO_TAB = 16 )
      INTEGER IH_Q2A_UP,IH_Q2B_UP,IH_ECM_UP
      DOUBLE PRECISION HFAC_TAB,HWGX_TAB,HSIG_TAB,HDPT_TAB,
     &  HQ2A_TAB,HQ2B_TAB,HECM_TAB
      COMMON /POHTAB/
     &  HFAC_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HWGX_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HSIG_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HDPT_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HQ2A_TAB(1:MAX_TAB_Q2,0:4),HQ2B_TAB(1:MAX_TAB_Q2,0:4),
     &  HECM_TAB(1:MAX_TAB_E,0:4),
     &  IH_Q2A_UP(0:4),IH_Q2B_UP(0:4),IH_ECM_UP(0:4)

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      COMPLEX*16 DSIG
      DIMENSION DSIG(0:MAX_PRO_2),DSPT(0:MAX_PRO_2)

C  initialization for all pt cutoffs
      I = ABS(IP)
      IL = I
      IF(IP.LT.0) THEN
        IL = 0
        PTC = HSWCUT(4+I)
      ELSE
        PTC = PHO_PTCUT(PARMDL(19),I)
      ENDIF

C  skip unassigned PTCUT
      IF(PTC.LT.0.5D0) GOTO 1000

      IH_Q2A_UP(I) = 1
      IH_Q2B_UP(I) = 1
      DO IB=1,MAX_TAB_Q2
        DO IA=1,MAX_TAB_Q2
          DO IE=1,MAX_TAB_E
            DO M=-1,MAX_PRO_2
              HFAC_TAB(M,IE,IA,IB,I) = 0.D0
              HWGX_TAB(M,IE,IA,IB,I) = 0.D0
              HSIG_TAB(M,IE,IA,IB,I) = 0.D0
              HDPT_TAB(M,IE,IA,IB,I) = 0.D0
            ENDDO
          ENDDO
        ENDDO
      ENDDO

      ELLOW = LOG(2.05*PTC)
      DELTA = (LOG(EMAXF)-ELLOW)/DBLE(IH_ECM_UP(I)-1)
C  energy too low
      IF(DELTA.LE.0.D0) GOTO 1000

C  switch between external particles and Pomeron
      IF(I.EQ.4) THEN
        IDP1 = 990
        PV1  = 0.D0
        IDP2 = 990
        PV2  = 0.D0
      ELSE IF(I.EQ.3) THEN
        IDP1 = IFPAP(2)
        PV1  = PVIRT(2)
        IDP2 = 990
        PV2  = 0.D0
      ELSE IF(I.EQ.2) THEN
        IDP1 = IFPAP(1)
        PV1  = PVIRT(1)
        IDP2 = 990
        PV2  = 0.D0
      ELSE
        IDP1 = IFPAP(1)
        PV1  = PVIRT(1)
        IDP2 = IFPAP(2)
        PV2  = PVIRT(2)
      ENDIF

C  initialize PT scales
      IF((IDPDG1.EQ.22).OR.(IDPDG1.EQ.990)) THEN
        IF((IDPDG2.EQ.22).OR.(IDPDG2.EQ.990)) THEN
          FPS(I) = PARMDL(105)
          FPH(I) = PARMDL(106)
        ELSE
          FPS(I) = PARMDL(103)
          FPH(I) = PARMDL(104)
        ENDIF
      ELSE IF((IDPDG2.EQ.22).OR.(IDPDG2.EQ.990)) THEN
        FPS(I) = PARMDL(103)
        FPH(I) = PARMDL(104)
      ELSE
        FPS(I) = PARMDL(101)
        FPH(I) = PARMDL(102)
      ENDIF

C  initialize hard scattering
      IF(IP.GT.0) THEN
        CALL PHO_HARINI(I,IDP1,IDP2,PV1,PV2,6,IDEB(8)+1)
      ELSE
        CALL PHO_HARINI(I,IDP1,IDP2,PV1,PV2,6,IDEB(8))
      ENDIF

C  energy/virtuality grid
      DO IE=1,IH_ECM_UP(IL)
        HECM_TAB(IE,IL) = EXP(ELLOW+DELTA*(IE-1))
      ENDDO
      DO IA=1,IH_Q2A_UP(IL)
        HQ2A_TAB(IA,IL) = 0.D0
      ENDDO
      DO IB=1,IH_Q2B_UP(IL)
        HQ2B_TAB(IB,IL) = 0.D0
      ENDDO

C  initialization for several energies and particle virtualities
      DO IE=1,IH_ECM_UP(IL)
        DO IA=1,IH_Q2A_UP(IL)
          DO IB=1,IH_Q2B_UP(IL)

            EE = HECM_TAB(IE,IL)
            Q2A = HQ2A_TAB(IA,IL)
            Q2B = HQ2B_TAB(IB,IL)
            CALL PHO_HARINT(IP,EE,0.D0,0.D0,0,-2,0,0,1)
            IF(IDEB(8).GE.5) WRITE(ErrorOut,'(1X,A,2E10.3,2I7)')
     &        'PHO_HARMCI: INITIALIZATION PT,ECM,ID1,ID2:',
     &        PTCUT(I),EE,IDPDG1,IDPDG2
            HFAC_TAB(0,IE,IA,IB,IL) = PTCUT(I)
            CALL PHO_HARFAC(PTCUT(I),EE)
            CALL PHO_HARWGX(PTCUT(I),EE)
            CALL PHO_HARXTO(EE,PTCUT(I),PTCUT(I),DSIG,DSPT)
            IF(IDEB(8).GE.10) THEN
              WRITE(ErrorOut,'(1X,A,/,1X,A)')
     &          'HARD CROSS SECTIONS SIGH(MB),DSIG/DPT(MB/GEV**2)',
     &          '------------------------------------------------'
              DO M=0,MAX_PRO_2
                WRITE(ErrorOut,'(10X,A,1P2E14.4)')
     &            PROC(M),DREAL(DSIG(M)),DSPT(M)
              ENDDO
            ENDIF

C  store in interpolation tables
            HFAC_TAB(-1,IE,IA,IB,IL) = HFAC(-1)
            HWGX_TAB(-1,IE,IA,IB,IL) = HWGX(-1)
            DO M=0,MAX_PRO_2
              HFAC_TAB(M,IE,IA,IB,IL) = HFAC(M)
              HWGX_TAB(M,IE,IA,IB,IL) = HWGX(M)
              HSIG_TAB(M,IE,IA,IB,IL) = DREAL(DSIG(M))*MH_PRO_ON(M,I)
              HDPT_TAB(M,IE,IA,IB,IL) = DSPT(M)*MH_PRO_ON(M,I)
            ENDDO

C  summed quantities
            HSIG_TAB(9,IE,IA,IB,IL) = 0.D0
            HDPT_TAB(9,IE,IA,IB,IL) = 0.D0
            DO M=1,8
              IF(MH_PRO_ON(M,I).GT.0) THEN
                HSIG_TAB(9,IE,IA,IB,IL) =
     &            HSIG_TAB(9,IE,IA,IB,IL) + HSIG_TAB(M,IE,IA,IB,IL)
                HDPT_TAB(9,IE,IA,IB,IL) =
     &            HDPT_TAB(9,IE,IA,IB,IL) + HDPT_TAB(M,IE,IA,IB,IL)
              ENDIF
            ENDDO
            HSIG_TAB(15,IE,IA,IB,IL) = 0.D0
            HDPT_TAB(15,IE,IA,IB,IL) = 0.D0
            DO M=10,14
              IF(MH_PRO_ON(M,I).GT.0) THEN
                HSIG_TAB(15,IE,IA,IB,IL) =
     &            HSIG_TAB(15,IE,IA,IB,IL) + HSIG_TAB(M,IE,IA,IB,IL)
                HDPT_TAB(15,IE,IA,IB,IL) =
     &            HDPT_TAB(15,IE,IA,IB,IL) + HDPT_TAB(M,IE,IA,IB,IL)
              ENDIF
            ENDDO
            HSIG_TAB(0,IE,IA,IB,IL) =
     &        HSIG_TAB(9,IE,IA,IB,IL) + HSIG_TAB(15,IE,IA,IB,IL)
            HDPT_TAB(0,IE,IA,IB,IL) =
     &        HDPT_TAB(9,IE,IA,IB,IL) + HDPT_TAB(15,IE,IA,IB,IL)

          ENDDO
        ENDDO
      ENDDO

C  debug output of weights
 1000 CONTINUE
      IF(IDEB(8).GE.5) THEN
        WRITE(ErrorOut,'(/1X,A,5X,2I7,I3,F7.2,/1X,A)')
     &    'PHO_HARMCI: WEIGHTS, MAXIMA (ID1/2,IP,PTC)',
     &    IDPDG1,IDPDG2,IP,PTCUT(I),
     &    '------------------------------------------'
        DO M=-1,MAX_PRO_2
          IF((M.EQ.0).OR.(M.EQ.9).OR.(M.EQ.15)) GOTO 512
          WRITE(ErrorOut,'(2X,A,I3,2I7)')
     &      'PHO_HARMCI: ECM HFAC, HWGX, HSIG, HDPT FOR MSTR,ID1,ID2',
     &      M,IDPDG1,IDPDG2
          DO K=1,IH_ECM_UP(IL)
            DO IA=1,IH_Q2A_UP(IL)
              DO IB=1,IH_Q2B_UP(IL)
                WRITE(ErrorOut,'(3X,1p,7E10.3)') HECM_TAB(K,IL),
     &            HQ2A_TAB(IA,IL),HQ2B_TAB(IB,IL),
     &            HFAC_TAB(M,K,IA,IB,IL),HWGX_TAB(M,K,IA,IB,IL),
     &            HSIG_TAB(M,K,IA,IB,IL),HDPT_TAB(M,K,IA,IB,IL)
              ENDDO
            ENDDO
          ENDDO
 512      CONTINUE
        ENDDO
      ENDIF

      END


CDECK  ID>, PHO_HARXR3
      SUBROUTINE PHO_HARXR3(ECMH,PT,ETAC,ETAD,DSIGMC)
C**********************************************************************
C
C     differential cross section DSIG/(DETAC*DETAD*DPT)
C
C     input:  ECMH     CMS energy
C             PT       parton PT
C             ETAC     pseudorapidity of parton C
C             ETAD     pseudorapidity of parton D
C
C     output: DSIGMC(0:15) QCD-PM cross sections dsigma/dpt/detac/detad
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( TINY= 1.D-30, ONEP1=1.1, TINY6=1.D-06, EPS=1.D-20)

      PARAMETER ( MAX_PRO_2 = 16 )
      COMPLEX*16 DSIGMC
      DIMENSION DSIGMC(0:MAX_PRO_2)
      DIMENSION DSIGM(0:MAX_PRO_2)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF

C  scale parameters for parton model calculations
      INTEGER NQQAL,NQQALI,NQQALF,NQQPD
      DOUBLE PRECISION AQQAL,AQQALI,AQQALF,AQQPD
      COMMON /POHSCL/ AQQAL,AQQALI,AQQALF,AQQPD,
     &                NQQAL,NQQALI,NQQALF,NQQPD


      DOUBLE PRECISION PHO_ALPHAS
      DIMENSION PDA(-6:6),PDB(-6:6)

      DO 10 I=1,9
        DSIGMC(I) = CMPLX(0.D0,0.D0)
        DSIGM(I)  = 0.D0
10    CONTINUE

      EC     = EXP(ETAC)
      ED     = EXP(ETAD)
C  kinematic conversions
      XA     = PT*(EC+ED)/ECMH
      XB     = XA/(EC*ED)
      IF((XA.GE.1.D0).OR.(XB.GE.1.D0)) THEN
        WRITE(ErrorOut,
     * '(/1X,A,2E12.4)') 'PHO_HARXR3:ERROR:X1 OR X2 > 1',XA,XB
        RETURN
      ENDIF
      SP     = XA*XB*ECMH*ECMH
      UP     =-ECMH*PT*EC*XB
      UP     = UP/SP
      TP     =-(1.D0+UP)
      UU     = UP*UP
      TT     = TP*TP
C  set hard scale  QQ  for alpha and partondistr.
      IF     ( NQQAL.EQ.1 ) THEN
        QQAL = AQQAL*PT*PT
      ELSEIF ( NQQAL.EQ.2 ) THEN
        QQAL = AQQAL*SP*UP*TP/(1.D0+TT+UU)
      ELSEIF ( NQQAL.EQ.3 ) THEN
        QQAL = AQQAL*SP
      ELSEIF ( NQQAL.EQ.4 ) THEN
        QQAL = AQQAL*SP*(UP*TP)**(1.D0/3.D0)
      ENDIF
      IF     ( NQQPD.EQ.1 ) THEN
        QQPD = AQQPD*PT*PT
      ELSEIF ( NQQPD.EQ.2 ) THEN
        QQPD = AQQPD*SP*UP*TP/(1.D0+TT+UU)
      ELSEIF ( NQQPD.EQ.3 ) THEN
        QQPD = AQQPD*SP
      ELSEIF ( NQQPD.EQ.4 ) THEN
        QQPD = AQQPD*SP*(UP*TP)**(1.D0/3.D0)
      ENDIF

      ALPHA  = PHO_ALPHAS(QQAL,3)
      FACTOR = PI2*GEV2MB*PT*(ALPHA/SP)**2*AKFAC
C  parton distributions (times x)
      CALL PHO_PDF(1,XA,QQPD,0.D0,PDA)
      CALL PHO_PDF(2,XB,QQPD,0.D0,PDB)
      S1    = PDA(0)*PDB(0)
      S2    = 0.D0
      S3    = 0.D0
      S4    = 0.D0
      S5    = 0.D0
      DO 20 I=1,NF
        S2  = S2+PDA(I)*PDB(-I)+PDA(-I)*PDB( I)
        S3  = S3+PDA(I)*PDB( I)+PDA(-I)*PDB(-I)
        S4  = S4+PDA(I)+PDA(-I)
        S5  = S5+PDB(I)+PDB(-I)
20    CONTINUE
C  partial cross sections (including color and symmetry factors)
C  resolved photon matrix elements (light quarks)
      DSIGM(1) = 2.25D0*(3.-((UP*TP)+UP/TT+TP/UU))
      DSIGM(6) = (4.D0/9.D0)*(UU+TT)
      DSIGM(8) = (4.D0/9.D0)*(1.D0+UU)/TT
      DSIGM(2) = (16.D0/27.D0)*(UU+TT)/(UP*TP)-3.D0*DSIGM(6)
      DSIGM(3) = ((1.D0+UU)/TT)-(4.D0/9.D0)*(1.D0+UU)/UP
      DSIGM(4) = (9.D0/32.D0)*DSIGM(2)
      DSIGM(5) = DSIGM(6)+DSIGM(8)-(8.D0/27.D0)*UU/TP
      DSIGM(7) = 0.5D0*(DSIGM(8)+(4.D0/9.D0)*(1.D0+TT)/UU-
     &           (8.D0/27.D0)/(UP*TP))
C
      DSIGM(1) = FACTOR*DSIGM(1)*S1
      DSIGM(2) = FACTOR*DSIGM(2)*S2
      DSIGM(3) = FACTOR*DSIGM(3)*(PDA(0)*S5+PDB(0)*S4)
      DSIGM(4) = FACTOR*DSIGM(4)*S1*NF
      DSIGM(5) = FACTOR*DSIGM(5)*S2
      DSIGM(6) = FACTOR*DSIGM(6)*S2*MAX(0,(NF-1))
      DSIGM(7) = FACTOR*DSIGM(7)*S3
      DSIGM(8) = FACTOR*DSIGM(8)*(S4*S5-(S2+S3))
C  complex part
      X=ABS(TP-UP)
      FAC2 = -LOG((X+2.D0)/(X+1.D-30))/PI
C
      DO 50 I=1,8
        IF(DSIGM(I).LT.EPS) DSIGM(I) = 0.D0
        DSIGMC(I) = CMPLX(DSIGM(I),DSIGM(I)*FAC2)
        DSIGMC(9) = DSIGMC(9)+DSIGMC(I)
 50   CONTINUE
      END


CDECK  ID>, PHO_HARXR2
      SUBROUTINE PHO_HARXR2(ECMH,PT,ETAC,DSIGMC)
C**********************************************************************
C
C     differential cross section DSIG/(DETAC*DPT)
C
C     input:  ECMH     CMS energy
C             PT       parton PT
C             ETAC     pseudorapidity of parton C
C
C     output: DSIGMC(0:15) QCD-PM cross sections dsigma/dpt/detac
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER ( TINY= 1.D-20 )

      PARAMETER ( MAX_PRO_2 = 16 )
      COMPLEX*16 DSIGMC
      DIMENSION DSIGMC(0:MAX_PRO_2)

C  integration precision for hard cross sections (obsolete)
      INTEGER NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO
      COMMON /POGAUP/ NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO


      COMPLEX*16 DSIG1
      DIMENSION DSIG1(0:MAX_PRO_2)
      DIMENSION ABSZ(32),WEIG(32)

      DO 10 M=1,9
        DSIGMC(M) = CMPLX(0.D0,0.D0)
        DSIG1(M)  = 0.D0
10    CONTINUE
C
      EC  = EXP(ETAC)
      ARG = ECMH/PT
      IF  ( ARG.LE.EC .OR. ARG.LE.1.D0/EC ) RETURN
      EDU = LOG(ARG-EC)
      EDL =-LOG(ARG-1.D0/EC)
      NPOINT = NGAUET
      CALL PHO_GAUSET(EDL,EDU,NPOINT,ABSZ,WEIG)
      DO 30 I=1,NPOINT
        CALL PHO_HARXR3(ECMH,PT,ETAC,ABSZ(I),DSIG1)
        DO 20 M=1,9
          PCTRL= DREAL(DSIG1(M))/TINY
          IF( PCTRL.GE.1.D0 ) THEN
            DSIGMC(M) = DSIGMC(M)+WEIG(I)*DSIG1(M)
          ENDIF
20      CONTINUE
30    CONTINUE
      END


CDECK  ID>, PHO_HARXD2
      SUBROUTINE PHO_HARXD2(ECMH,PT,ETAC,DSIGMC)
C**********************************************************************
C
C     differential cross section DSIG/(DETAC*DPT) for direct processes
C
C     input:  ECMH     CMS energy of scattering system
C             PT       parton PT
C             ETAC     pseudorapidity of parton C
C
C     output: DSIGMC(0:15) QCD-PM cross sections dsigma/dpt/detac
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( MAX_PRO_2 = 16 )
      COMPLEX*16 DSIGMC
      DIMENSION DSIGMC(0:MAX_PRO_2)
      PARAMETER ( TINY= 1.D-30, ONEP1=1.1, TINY6=1.D-06, EPS=1.D-25)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF

C  some hadron information, will be deleted in future versions
      INTEGER NFS
      DOUBLE PRECISION QMASS,BET,PCOUDI,PNORM,VALPRG
      COMMON /POHDRN/ QMASS(6),BET,PCOUDI,PNORM,VALPRG(2),NFS

C  scale parameters for parton model calculations
      INTEGER NQQAL,NQQALI,NQQALF,NQQPD
      DOUBLE PRECISION AQQAL,AQQALI,AQQALF,AQQPD
      COMMON /POHSCL/ AQQAL,AQQALI,AQQALF,AQQPD,
     &                NQQAL,NQQALI,NQQALF,NQQPD

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


      DOUBLE PRECISION PHO_ALPHAS,PHO_ALPHAE
      DIMENSION PDA(-6:6),PDB(-6:6),DSIGM(0:MAX_PRO_2)


*     ONE32=1.D0/9.D0
*     TWO32=4.D0/9.D0
      DO 10 I=10,13
        DSIGMC(I) = CMPLX(0.D0,0.D0)
        DSIGM(I) = 0.D0
 10   CONTINUE
      DSIGMC(15) = CMPLX(0.D0,0.D0)
      DSIGM(15) = 0.D0

C  direct particle 1
      IF((IDPDG1.EQ.22).OR.(IDPDG1.EQ.990)) THEN
        EC     = EXP(ETAC)
        ED     = ECMH/PT-EC
C  kinematic conversions
        XA     = 1.D0
        XB     = 1.D0/(EC*ED)
        IF ( XB.GE.1.D0 ) THEN
          WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &      'PHO_HARXD2:ERROR: XB>1 (XA,XB)',XA,XB
          RETURN
        ENDIF
        SP     = XA*XB*ECMH*ECMH
        UP     =-ECMH*PT*EC*XB
        UP     = UP/SP
        TP     =-(1.D0+UP)
        UU     = UP*UP
        TT     = TP*TP
C  set hard scale  QQ  for alpha and partondistr.
        IF     ( NQQAL.EQ.1 ) THEN
          QQAL = AQQAL*PT*PT
        ELSEIF ( NQQAL.EQ.2 ) THEN
          QQAL = AQQAL*SP*UP*TP/(1.D0+TT+UU)
        ELSEIF ( NQQAL.EQ.3 ) THEN
          QQAL = AQQAL*SP
        ELSEIF ( NQQAL.EQ.4 ) THEN
          QQAL = AQQAL*SP*(UP*TP)**(1.D0/3.D0)
        ENDIF
        IF     ( NQQPD.EQ.1 ) THEN
          QQPD = AQQPD*PT*PT
        ELSEIF ( NQQPD.EQ.2 ) THEN
          QQPD = AQQPD*SP*UP*TP/(1.D0+TT+UU)
        ELSEIF ( NQQPD.EQ.3 ) THEN
          QQPD = AQQPD*SP
        ELSEIF ( NQQPD.EQ.4 ) THEN
          QQPD = AQQPD*SP*(UP*TP)**(1.D0/3.D0)
        ENDIF

        ALPHA2 = PHO_ALPHAS(QQAL,2)
        IF(IDPDG1.EQ.22) THEN
          ALPHA1 = PHO_ALPHAE(QQAL)
        ELSE IF(IDPDG1.EQ.990) THEN
          ALPHA1 = PARMDL(74)
        ENDIF
        FACTOR = -PI2*GEV2MB*UP/PT*ALPHA1*ALPHA2/SP*AKFAC
C  parton distribution (times x)
        CALL PHO_PDF(2,XB,QQPD,0.D0,PDB)
        S1    = PDB(0)
C  charge counting
        S2    = 0.D0
        S3    = 0.D0
        IF(IDPDG1.EQ.22) THEN
          DO 20 I=1,NF
*           IF(MOD(I,2).EQ.0) THEN
*             S2 = S2 + (PDB(I)+PDB(-I))*TWO32
*             S3 = S3 + TWO32
*           ELSE
*             S2 = S2 + (PDB(I)+PDB(-I))*ONE32
*             S3 = S3 + ONE32
*           ENDIF
            S2 = S2 + (PDB(I)+PDB(-I))*Q_CH2(I)
            S3 = S3 + Q_CH2(I)
 20       CONTINUE
        ELSE IF(IDPDG1.EQ.990) THEN
          DO 25 I=1,NF
            S2 = S2 + PDB(I)+PDB(-I)
 25       CONTINUE
          S3 = NF
        ENDIF
C  partial cross sections (including color and symmetry factors)
C  direct photon matrix elements
        DSIGM(10) = -8.D0/3.D0*(UU+1.D0)/UP
        DSIGM(11) = (UU+TT)/(UP*TP)
C
        DSIGM(10) = FACTOR*DSIGM(10)*S2
        DSIGM(11) = FACTOR*DSIGM(11)*S1*S3
C  complex part
        X=ABS(TP-UP)
        FAC2 = -LOG((X+2.D0)/(X+1.D-30))/PI
C
        DO 50 I=10,11
          IF(DSIGM(I).LT.0.D0) THEN
            WRITE(ErrorOut,'(1X,A,I3,1P,2E12.4)')
     &        'PHO_HARXD2: NEG. CROSS SECTION',I,DSIGM(I),ECMH
            DSIGM(I) = 0.D0
          ENDIF
          DSIGMC(I) = CMPLX(DSIGM(I),DSIGM(I)*FAC2)
          DSIGMC(15) = DSIGMC(15)+DSIGMC(I)
 50     CONTINUE
      ENDIF
C
C  direct particle 2
      IF((IDPDG2.EQ.22).OR.(IDPDG2.EQ.990)) THEN
        EC     = EXP(ETAC)
        ED     = 1.D0/(ECMH/PT-1.D0/EC)
C  kinematic conversions
        XA     = PT*(EC+ED)/ECMH
        XB     = 1.D0
        IF ( XA.GE.1.D0 ) THEN
          WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &      'PHO_HARXD2:ERROR:XA>1 (XA,XB)',XA,XB
          RETURN
        ENDIF
        SP     = XA*XB*ECMH*ECMH
        UP     =-ECMH*PT*EC*XB
        UP     = UP/SP
        TP     =-(1.D0+UP)
        UU     = UP*UP
        TT     = TP*TP
C  set hard scale  QQ  for alpha and partondistr.
        IF     ( NQQAL.EQ.1 ) THEN
          QQAL = AQQAL*PT*PT
        ELSEIF ( NQQAL.EQ.2 ) THEN
          QQAL = AQQAL*SP*UP*TP/(1.D0+TT+UU)
        ELSEIF ( NQQAL.EQ.3 ) THEN
          QQAL = AQQAL*SP
        ELSEIF ( NQQAL.EQ.4 ) THEN
          QQAL = AQQAL*SP*(UP*TP)**(1.D0/3.D0)
        ENDIF
        IF     ( NQQPD.EQ.1 ) THEN
          QQPD = AQQPD*PT*PT
        ELSEIF ( NQQPD.EQ.2 ) THEN
          QQPD = AQQPD*SP*UP*TP/(1.D0+TT+UU)
        ELSEIF ( NQQPD.EQ.3 ) THEN
          QQPD = AQQPD*SP
        ELSEIF ( NQQPD.EQ.4 ) THEN
          QQPD = AQQPD*SP*(UP*TP)**(1.D0/3.D0)
        ENDIF

        ALPHA1 = PHO_ALPHAS(QQAL,1)
        IF(IDPDG2.EQ.22) THEN
          ALPHA2 = PHO_ALPHAE(QQAL)
        ELSE IF(IDPDG2.EQ.990) THEN
          ALPHA2 = PARMDL(74)
        ENDIF
        FACTOR = -PI2*GEV2MB*TP/PT*ALPHA1*ALPHA2/SP*AKFAC
C  parton distribution (times x)
        CALL PHO_PDF(1,XA,QQPD,0.D0,PDA)
        S1    = PDA(0)
C  charge counting
        S2    = 0.D0
        S3    = 0.D0
        IF(IDPDG2.EQ.22) THEN
          DO 70 I=1,NF
*           IF(MOD(I,2).EQ.0) THEN
*             S2 = S2 + (PDA(I)+PDA(-I))*TWO32
*             S3 = S3 + TWO32
*           ELSE
*             S2 = S2 + (PDA(I)+PDA(-I))*ONE32
*             S3 = S3 + ONE32
*           ENDIF
            S2 = S2 + (PDA(I)+PDA(-I))*Q_CH2(I)
            S3 = S3 + Q_CH2(I)
 70       CONTINUE
        ELSE IF(IDPDG2.EQ.990) THEN
          DO 75 I=1,NF
            S2 = S2 + PDA(I)+PDA(-I)
 75       CONTINUE
          S3 = NF
        ENDIF
C  partial cross sections (including color and symmetry factors)
C  direct photon matrix elements
        DSIGM(12) = -8.D0/3.D0*(TT+1.D0)/TP
        DSIGM(13) = (UU+TT)/(UP*TP)
C
        DSIGM(12) = FACTOR*DSIGM(12)*S2
        DSIGM(13) = FACTOR*DSIGM(13)*S3*S1
C  complex part
        X=ABS(TP-UP)
        FAC2 = -LOG((X+2.D0)/(X+1.D-30))/PI
C
        DO 80 I=12,13
          IF(DSIGM(I).LT.0.D0) THEN
            WRITE(ErrorOut,'(1X,A,I3,1P,2E12.4)')
     &        'PHO_HARXD2: NEG. CROSS SECTION:',I,DSIGM(I),ECMH
            DSIGM(I) = 0.D0
          ENDIF
          DSIGMC(I) = CMPLX(DSIGM(I),DSIGM(I)*FAC2)
          DSIGMC(15) = DSIGMC(15)+DSIGMC(I)
 80     CONTINUE
      ENDIF
      END


CDECK  ID>, PHO_HARXPT
      SUBROUTINE PHO_HARXPT(ECMH,PT,IPRO,DSIGMC)
C**********************************************************************
C
C     differential cross section DSIG/DPT
C
C     input:  ECMH     CMS energy of scattering system
C             PT       parton PT
C             IPRO     1  resolved processes
C                      2  direct processes
C                      3  resolved and direct processes
C
C     output: DSIGMC(0:12) QCD-PM cross sections dsigma/dpt
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER ( MAX_PRO_2 = 16 )
      COMPLEX*16 DSIGMC
      DIMENSION  DSIGMC(0:MAX_PRO_2)
      PARAMETER ( TINY= 1.D-10, ONEP1=1.1, EPS=1.D-25)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  integration precision for hard cross sections (obsolete)
      INTEGER NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO
      COMMON /POGAUP/ NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF

C  some hadron information, will be deleted in future versions
      INTEGER NFS
      DOUBLE PRECISION QMASS,BET,PCOUDI,PNORM,VALPRG
      COMMON /POHDRN/ QMASS(6),BET,PCOUDI,PNORM,VALPRG(2),NFS


      DOUBLE PRECISION PHO_ALPHAE

      COMPLEX*16 DSIG1
      DIMENSION  DSIG1(0:MAX_PRO_2)
      DIMENSION ABSZ(32),WEIG(32)


      DO 10 M=0,MAX_PRO_2
        DSIGMC(M) = CMPLX(0.D0,0.D0)
        DSIG1(M)  = CMPLX(0.D0,0.D0)
 10   CONTINUE

C  resolved and direct processes
      AMT = 2.D0*PT/ECMH
      IF ( AMT.GE.1.D0 ) RETURN
      ECU = LOG((SQRT(1.D0-AMT*AMT)+1.D0)/AMT)
      ECL = -ECU
      NPOINT = NGAUET
      CALL PHO_GAUSET(ECL,ECU,NPOINT,ABSZ,WEIG)
      DO 30 I=1,NPOINT
        DSIG1(9)  = CMPLX(0.D0,0.D0)
        DSIG1(15) = CMPLX(0.D0,0.D0)
        IF(IPRO.EQ.1) THEN
          CALL PHO_HARXR2(ECMH,PT,ABSZ(I),DSIG1)
        ELSE IF(IPRO.EQ.2) THEN
          CALL PHO_HARXD2(ECMH,PT,ABSZ(I),DSIG1)
        ELSE
          CALL PHO_HARXR2(ECMH,PT,ABSZ(I),DSIG1)
          CALL PHO_HARXD2(ECMH,PT,ABSZ(I),DSIG1)
        ENDIF
        DO 20 M=1,MAX_PRO_2
          DSIGMC(M) = DSIGMC(M)+WEIG(I)*DSIG1(M)
 20     CONTINUE
 30   CONTINUE

C  direct processes
      IF(((IDPDG1.EQ.22).OR.(IDPDG1.EQ.990))
     &   .AND.((IDPDG2.EQ.22).OR.(IDPDG2.EQ.990))) THEN
        FAC = 0.D0
        SS = ECMH*ECMH
        ALPHAE = PHO_ALPHAE(SS)
        DO 300 I=1,NF
          IF(IDPDG1.EQ.22) THEN
*           F1 = (4.D0-3.D0*MOD(I,2))/9.D0*ALPHAE
            F1 = Q_CH2(I)*ALPHAE
          ELSE
            F1 = PARMDL(74)
          ENDIF
          IF(IDPDG2.EQ.22) THEN
*           F2 = (4.D0-3.D0*MOD(I,2))/9.D0*ALPHAE
            F2 = Q_CH2(I)*ALPHAE
          ELSE
            F2 = PARMDL(74)
          ENDIF
          FAC = FAC+F1*F2*3.D0
 300    CONTINUE
C  direct cross sections
        ZZ = SQRT(1.D0-4.D0*PT*PT/SS+TINY)
        T1 = -SS/2.D0*(1.D0+ZZ)
        T2 = -SS/2.D0*(1.D0-ZZ)
        XM = -2.D0*PT/ZZ*((SS+T1)/T1+T1/(SS+T1)+(SS+T2)/T2+T2/(SS+T2))
C  hadronic part
        DSIGMC(14) = GEV2MB*2.D0*PI*FAC/(SS*SS)*XM*AKFAC

C  leptonic part (e, mu, tau)
        DSIGMC(16) = 0.D0
        IF((IDPDG1.EQ.22).AND.(IDPDG2.EQ.22)) THEN
          DSIGMC(16) = DSIGMC(14)/FAC*3.D0*ALPHAE**2
C  simulation of tau together with quarks
          IF(IPAMDL(64).NE.0) DSIGMC(14) = DSIGMC(14)+DSIGMC(16)/3.D0
        ENDIF
      ENDIF

      DSIGMC(15) = DSIGMC(15)+DSIGMC(14)
      DSIGMC(0)  = DSIGMC(9)+DSIGMC(15)

      END


CDECK  ID>, PHO_HARXTO
      SUBROUTINE PHO_HARXTO(ECMH,PTCUTR,PTCUTD,DSIGMC,DSDPTC)
C**********************************************************************
C
C     total hard cross section (perturbative QCD, Parton Model)
C
C     input:  ECMH     CMS energy of scattering system
C             PTCUTR   PT cutoff for resolved processes
C             PTCUTD   PT cutoff for direct processes (photon, Pomeron)
C
C     output: DSIGMC(0:MARPR2) cross sections for given cutoff
C             DSDPTC(0:MARPR2) differential cross sections at cutoff
C
C     note:  COMPLEX*16          DSIGMC
C            DOUBLE PRECISION    DSDPTC
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER ( MAX_PRO_2 = 16 )
      COMPLEX*16 DSIGMC
      DIMENSION DSIGMC(0:MAX_PRO_2),DSDPTC(0:MAX_PRO_2)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  integration precision for hard cross sections (obsolete)
      INTEGER NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO
      COMMON /POGAUP/ NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO

C  some hadron information, will be deleted in future versions
      INTEGER NFS
      DOUBLE PRECISION QMASS,BET,PCOUDI,PNORM,VALPRG
      COMMON /POHDRN/ QMASS(6),BET,PCOUDI,PNORM,VALPRG(2),NFS

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF


      DOUBLE PRECISION PHO_ALPHAE

      COMPLEX*16 DSIG1
      DIMENSION DSIG1(0:MAX_PRO_2)
      DIMENSION ABSZ(32),WEIG(32)

      DATA FAC / 3.0D0 /

      DO 10 M=0,MAX_PRO_2
        DSIGMC(M)= CMPLX(0.D0,0.D0)
 10   CONTINUE
      EEC=ECMH/2.001D0
C
      IF ( PTCUTR.GE.EEC ) GOTO 100
C
C  integration for resolved processes
      PTMIN  = PTCUTR
      PTMAX  = MIN(FAC*PTMIN,EEC)
      NPOINT = NGAUP1
      CALL PHO_HARXPT(ECMH,PTMIN,1,DSIG1)
      DO 60 M=1,9
        DSDPTC(M) = DREAL(DSIG1(M))
 60   CONTINUE
      DSIGH   = DREAL(DSIG1(9))
      PTMXX  = 0.95D0*PTMAX
      CALL PHO_HARXPT(ECMH,PTMXX,1,DSIG1)
      DSIGL  = DREAL(DSIG1(9))
      EX     = LOG(DSIGH/(DSIGL+1.D-30))/LOG(FAC)
      EX1    = 1.0D0-EX
      DO 50 K=1,2
        IF ( PTMIN.GE.PTMAX ) GOTO 40
        RL   = PTMIN**EX1
        RU   = PTMAX**EX1
        CALL PHO_GAUSET(RL,RU,NPOINT,ABSZ,WEIG)
        DO 30 I=1,NPOINT
          R  = ABSZ(I)
          PT = R**(1.0D0/EX1)
          CALL PHO_HARXPT(ECMH,PT,1,DSIG1)
          F  = WEIG(I)*PT/(R*EX1)
          DO 20 M=1,9
            DSIGMC(M) = DSIGMC(M)+F*DSIG1(M)
 20       CONTINUE
 30     CONTINUE
 40     PTMIN  = PTMAX
        PTMAX  = EEC
        NPOINT = NGAUP2
 50   CONTINUE
 100  CONTINUE
      DSIGMC(0) = DSIGMC(9)
      DSDPTC(0) = DSDPTC(9)
C
C  integration for direct processes
      IF((PTCUTD.GE.EEC).OR.(PTCUTD.LT.0.5D0)) RETURN
C
      IF((IDPDG1.EQ.22).OR.(IDPDG1.EQ.990)
     &   .OR.(IDPDG2.EQ.22).OR.(IDPDG2.EQ.990)) THEN
        PTMIN  = PTCUTD
        PTMAX  = MIN(FAC*PTMIN,EEC)
        NPOINT = NGAUP1
        CALL PHO_HARXPT(ECMH,PTMIN,2,DSIG1)
        IF(DREAL(DSIG1(15)).LT.1.D-15) GOTO 170
        DO 160 M=10,16
          DSDPTC(M) = DREAL(DSIG1(M))
 160    CONTINUE
        DSIGH   = DREAL(DSIG1(15)-DSIG1(14))
        PTMXX  = 0.95D0*PTMAX
        CALL PHO_HARXPT(ECMH,PTMXX,2,DSIG1)
        DSIGL  = DREAL(DSIG1(15)-DSIG1(14))
        EX     = LOG(DSIGH/(DSIGL+1.D-30))/LOG(FAC)
        EX1    = 1.0D0-EX
        DO 150 K=1,2
          IF ( PTMIN.GE.PTMAX ) GOTO 140
          RL   = PTMIN**EX1
          RU   = PTMAX**EX1
          CALL PHO_GAUSET(RL,RU,NPOINT,ABSZ,WEIG)
          DO 130 I=1,NPOINT
            R  = ABSZ(I)
            PT = R**(1.0D0/EX1)
            CALL PHO_HARXPT(ECMH,PT,2,DSIG1)
            F  = WEIG(I)*PT/(R*EX1)
            DO 120 M=10,15
              DSIGMC(M) = DSIGMC(M)+F*DSIG1(M)
 120        CONTINUE
 130      CONTINUE
 140      PTMIN  = PTMAX
          PTMAX  = EEC
          NPOINT = NGAUP2
 150    CONTINUE
      ENDIF
C
 170  CONTINUE
C
C  double direct process
      IF(((IDPDG1.EQ.22).OR.(IDPDG1.EQ.990))
     &   .AND.((IDPDG2.EQ.22).OR.(IDPDG2.EQ.990))) THEN
        FACC = 0.D0
        SS = ECMH*ECMH
        ALPHAE = PHO_ALPHAE(SS)
        DO 300 I=1,NF
          IF(IDPDG1.EQ.22) THEN
*           F1 = (4.D0-3.D0*MOD(I,2))/9.D0*ALPHAE
            F1 = Q_CH2(I)*ALPHAE
          ELSE
            F1 = PARMDL(74)
          ENDIF
          IF(IDPDG2.EQ.22) THEN
*           F2 = (4.D0-3.D0*MOD(I,2))/9.D0*ALPHAE
            F2 = Q_CH2(I)*ALPHAE
          ELSE
            F2 = PARMDL(74)
          ENDIF
          FACC = FACC + F1*F2*3.D0
 300    CONTINUE

        ZZ = SQRT(1.D0-4.D0*PTCUTD*PTCUTD/SS)
        R  = 4.D0*PI/SS*(LOG((1.D0+ZZ)/(1.D0-ZZ))-ZZ)*GEV2MB
C  hadronic cross section
        DSIGMC(14) = R*FACC*AKFAC
C  leptonic cross section
        IF((IDPDG1.EQ.22).AND.(IDPDG2.EQ.22)) THEN
          DSIGMC(16) = R*3.D0*ALPHAE**2*AKFAC
C  simulation of tau together with quarks
          IF(IPAMDL(64).NE.0) DSIGMC(14) = DSIGMC(14)+DSIGMC(16)/3.D0
          DSIGMC(16) = DSIGMC(16)*2.D0/3.D0
        ELSE
          DSIGMC(16) = CMPLX(0.D0,0.D0)
        ENDIF
C  sum of direct part
        DSIGMC(15) = CMPLX(0.D0,0.D0)
        DO 400 I=10,14
          DSIGMC(15) = DSIGMC(15) + DSIGMC(I)
 400    CONTINUE
      ENDIF
C total sum (hadronic)
      DSIGMC(0) = DSIGMC(9) + DSIGMC(15)
      DSDPTC(0) = DSDPTC(9) + DSDPTC(15)

      END


CDECK  ID>, PHO_HARISR
      SUBROUTINE PHO_HARISR(IHPOM,P1,P2,IPF1,IPF2,IPA1,IPA2,IV1,IV2,Q2H,
     &  XH1,XH2,XHMAX1,XHMAX2,IPB1,IPB2,IVO1,IVO2,XISR1,XISR2,IREJ)
C********************************************************************
C
C     initial state radiation according to DGLAP evolution equations
C     (backward evolution, no spin effects)
C
C     input:    IHPOM     index of hard Pomeron
C                         negative: delete all previous entries
C               P1,P2     4 momenta of hard scattered final partons
C                         (in CMS of hard scattering)
C               IPF1,2    flavours of final partons
C               IPA1,2    flavours of initial partons
C               IV1,2     valence quark labels (0/1)
C               Q2H       momentum transfer (squared, positive)
C               XH1,XH2   x values of initial partons
C               XHMAX1,2  max. x values allowed
C
C     output:   all emitted partons in /POPISR/, final state
C               partons are the first two entries
C               shower evolution traced in /PODGL1/
C               IPB1,2    flavours of new initial partons
C               XISR1,2   x values of new initial partons
C               IVO1,2    valence quark labels (0/1)
C
C     attention: quark numbering according to PDG convention,
C                but 0 for gluons
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER (RHOMAS =  0.766D0,
     &           DEPS   =  1.D-10,
     &           TINY   =  1.D-10)

      DIMENSION P1(4),P2(4)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  some hadron information, will be deleted in future versions
      INTEGER NFS
      DOUBLE PRECISION QMASS,BET,PCOUDI,PNORM,VALPRG
      COMMON /POHDRN/ QMASS(6),BET,PCOUDI,PNORM,VALPRG(2),NFS

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD

C  scale parameters for parton model calculations
      INTEGER NQQAL,NQQALI,NQQALF,NQQPD
      DOUBLE PRECISION AQQAL,AQQALI,AQQALF,AQQPD
      COMMON /POHSCL/ AQQAL,AQQALI,AQQALF,AQQPD,
     &                NQQAL,NQQALI,NQQALF,NQQPD

C  parameters for DGLAP backward evolution in ISR
      INTEGER NFSISR
      DOUBLE PRECISION Q2MISR,PMISR,ZMISR,AL2ISR
      COMMON /PODGL1/ Q2MISR(2),PMISR(2),ZMISR(2),AL2ISR(2),NFSISR

C  initial state parton radiation (internal part)
      INTEGER MXISR3,MXISR4
      PARAMETER ( MXISR3 = 50, MXISR4 = 100 )
      INTEGER IFL1,IFL2,IBRA,IFANO,ISH,NACC
      DOUBLE PRECISION Q2SH,PT2SH,XPSH,ZPSH,THSH,SHAT
      COMMON /POINT6/ Q2SH(2,MXISR3),PT2SH(2,MXISR3),XPSH(2,MXISR3),
     &                ZPSH(2,MXISR3),THSH(2,MXISR3),SHAT(MXISR3),
     &                IFL1(2,MXISR3),IFL2(2,MXISR3),
     &                IBRA(2,MXISR4),IFANO(2),ISH(2),NACC

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  particles created by initial state evolution
      INTEGER MXISR1,MXISR2
      PARAMETER ( MXISR1 = 150, MXISR2 = 50 )
      INTEGER IFLISR,IPOISR,IMXISR
      DOUBLE PRECISION PHISR
      COMMON /POPISR/ IFLISR(2,MXISR1),PHISR(2,4,MXISR1),
     &                IPOISR(2,2,MXISR2),IMXISR(2)



      DOUBLE PRECISION PYP,EER,THER,QMAXR
      INTEGER PYK


      DIMENSION XHMA(2),NEXT(2),PD1(-6:6),PD2(-6:6),WGGAP(-6:6),
     &          WGPDF(-6:6),XHMI(2),GB(4),PM(4),PN(4),PC(2,4),Q2(2),
     &          IVAL(2),IPAL(2),IL(2),IFSUM(2),IDMO(2)

      IREJ = 0
      NTRY = 1000
      NITER = 0
C  debug output
      IF(IDEB(79).GE.10) THEN
        WRITE(ErrorOut,
     * '(1X,A,/1X,I10,3I3,5E11.3,2(/5X,4E12.3))')
     &    'PHO_HARISR: KEV,IHPOM,IP1,IP2,Q2H,XH1,XH2,XHM1,XHM2:',
     &    KEVENT,IHPOM,IPA1,IPA2,Q2H,XH1,XH2,XHMAX1,XHMAX2,P1,P2
      ENDIF
      IF(IHPOM.EQ.0) RETURN
C
 10   CONTINUE
      NACC = 0
      IDMO(1) = IDPDG1
      IDMO(2) = IDPDG2
C
C  copy final state partons to local fields
      IHIDX = ABS(IHPOM)

      IF(IHIDX.GT.MXISR2) THEN
        WRITE(ErrorOut,
     * '(1X,2A,2I4)') 'PHO_HARISR: no space left in ',
     &    '/POPISR/ FOR HARD SCATTERING LABELS (IHIDX,MXISR2):',
     &    IHIDX,MXISR2
        IREJ = 1
      ENDIF

      DO 50 K=1,2
        IF(IHPOM.LT.0) IMXISR(K) = 0
        IPOISR(K,1,IHIDX) = IMXISR(K)+1
        IPAL(K) = IPOISR(K,1,IHIDX)
 50   CONTINUE
      DO 55 I=1,4
        PHISR(1,I,IPAL(1)) = P1(I)
        PHISR(2,I,IPAL(2)) = P2(I)
 55   CONTINUE
      IFLISR(1,IPAL(1)) = IPF1
      IFLISR(2,IPAL(2)) = IPF2
C
C  check limitations, initialize /PODGL1/
      IF((Q2H.GT.Q2MISR(1)).AND.(XH1.LT.XHMAX1)) THEN
        NEXT(1) = 1
        Q2SH(1,1) = Q2H
      ELSE
        NEXT(1) = 0
        Q2SH(1,1) = 0.D0
      ENDIF
      IF((Q2H.GT.Q2MISR(2)).AND.(XH2.LT.XHMAX2)) THEN
        NEXT(2) = 1
        Q2SH(2,1) = Q2H
      ELSE
        NEXT(2) = 0
        Q2SH(2,1) = 0.D0
      ENDIF
C
      ISH(1) = 1
      ISH(2) = 1
      XPSH(1,1) = XH1
      XPSH(2,1) = XH2
C
      IFL1(1,1) = IPA1
      IVAL(1)   = IV1
      IF((IPA1.EQ.22).OR.(IPA1.EQ.990)) NEXT(1) = 0
      IFL1(2,1) = IPA2
      IVAL(2)   = IV2
      IF((IPA2.EQ.22).OR.(IPA2.EQ.990)) NEXT(2) = 0
C
      IF(IDEB(79).GE.17) WRITE(ErrorOut,'(1X,A,/5X,2I2,3E12.3)')
     &  'PHO_HARISR:INITIAL TESTS (NEXT1,2 Q2H Q21,2)',NEXT,Q2H,Q2MISR
      IF(NEXT(1)+NEXT(2).EQ.0) GOTO 800
C
C  initialize parton shower loop
      B0QCD = (33.D0-2.D0*NFSISR)/6.D0
      AL2ISR(1) = PDFLAM(1)
      AL2ISR(2) = PDFLAM(2)
      XHMA(1) = XHMAX1
      XHMA(2) = XHMAX2
      XHMI(1) = PMISR(1)/PCMP
      XHMI(2) = PMISR(2)/PCMP
      ZPSH(1,1) = 1.D0
      ZPSH(2,1) = 1.D0
      SHAT1 = XH1*XH2*ECMP**2
      IF(IPAMDL(109).EQ.1) THEN
        PT2SH(1,1) = Q2H
      ELSE
        PT2SH(1,1) = Q2H*(1.D0-Q2H/SHAT1)
      ENDIF
      PT2SH(2,1) = PT2SH(1,1)
      IF(PT2SH(1,1).LT.Q2MISR(1)) NEXT(1) = 0
      IF(PT2SH(2,1).LT.Q2MISR(2)) NEXT(2) = 0
      THSH(1,1) = 2.D0*SQRT(Q2H/SHAT1)
      THSH(2,1) = THSH(1,1)
      IFANO(1) = 0
      IFANO(2) = 0
      ZZ = 1.D0
      IF(IREJ.NE.0) GOTO 800
C
C  main generation loop
C -------------------------------------------------
 100  CONTINUE
C  choose parton side to become solved
        IF((NEXT(1)+NEXT(2)).EQ.2) THEN
          IF(Q2SH(1,ISH(1)).GT.Q2SH(2,ISH(2))) THEN
            IP = 1
          ELSE IF(Q2SH(2,ISH(2)).GT.Q2SH(1,ISH(1))) THEN
            IP = 2
          ELSE
            IP = MAX(INT(PHO_RNDM(SHAT1)*2.D0+0.999999D0),1)
          ENDIF
        ELSE IF(NEXT(1).EQ.1) THEN
          IP = 1
        ELSE IF(NEXT(2).EQ.1) THEN
          IP = 2
        ELSE
          GOTO 800
        ENDIF
        INDX = ISH(IP)
C  INDX now parton position of parton to become solved
C  IP   now side to be treated
        XP = XPSH(IP,INDX)
        Q2P = Q2SH(IP,INDX)
        PT2 = PT2SH(IP,INDX)
        IFLB = IFL1(IP,INDX)
C  check available x
        XMIP = XHMI(IP)
C  cutoff by x limitation: no further development
        IF((XHMA(IP)-XP).LT.XMIP*2.D0) THEN
          NEXT(IP) = 0
          Q2SH(IP,INDX) = 0.D0
          IF(IDEB(79).GE.17) THEN
            WRITE(ErrorOut,'(1X,A,/5X,3E12.4,2I3)')
     &        'PHO_HARISR: EVOLUTION X-STOP (XP,XMIP,XHMA,IP,INDX)',
     &        XP,XMIP,XHMA(IP),IP,INDX
          ENDIF
          GOTO 100
        ENDIF
C  initial value of evolution variable t
        TT = LOG(AQQALI*Q2P/AL2ISR(IP))
        DO 110 I=-NFSISR,NFSISR
          WGGAP(I) = 0.D0
          WGPDF(I) = 0.D0
 110    CONTINUE
C  DGLAP weights
        ZMIN = XP/XHMA(IP)
        ZMAX = XP/(XP+XMIP)
        CF = 4./3.
C  q --> q g, g --> g g
        IF(IFLB.EQ.0) THEN
          WGGAP(0) = CF*((ZMAX**2-ZMIN**2)/2.D0-2.D0*(ZMAX-ZMIN)
     &      +2.D0*LOG(ZMAX/ZMIN))
          DO 120 I=1,NFSISR
            WGGAP(I)  = WGGAP(0)
            WGGAP(-I) = WGGAP(0)
 120      CONTINUE
          WGGAP(0) = 6.D0*((ZMIN**3-ZMAX**3)/3.D0+(ZMAX**2-ZMIN**2)/2.D0
     &      -2.D0*(ZMAX-ZMIN)+LOG(ZMAX/ZMIN*(1.D0-ZMIN)/(1.D0-ZMAX)))
C  q --> g q, g --> q qb
        ELSE IF(ABS(IFLB).LE.6) THEN
          WGGAP(IFLB) = CF*((ZMIN**2-ZMAX**2)/2.D0-ZMAX+ZMIN
     &      -2.D0*LOG((1.D0-ZMAX)/(1.D0-ZMIN)))
          IF(IVAL(IP).EQ.0) WGGAP(0) = 0.5D0*(2./3.*(ZMAX**3-ZMIN**3)
     &      -ZMAX**2+ZMIN**2+ZMAX-ZMIN)
        ELSE
          WRITE(ErrorOut,'(/1X,A,I7)')
     &      'PHO_HARISR:ERROR: UNSUPPORTED PARTICLE ID',IFLB
          CALL PHO_ABORT
        ENDIF
C  anomalous/resolved evolution
        IPDFC = 0
        IF(IPAMDL(110).GE.1) THEN
          IF((IDMO(IP).EQ.22).AND.(IFLB.NE.0)
     &       .AND.(IFLB.NE.21)) THEN
            WGDIR = 0.D0
            IF(NQQALI.EQ.1) THEN
              SCALE2 = PT2*AQQPD
            ELSE
              SCALE2 = Q2P*AQQPD
            ENDIF
            CALL PHO_PDF(IP,XP,SCALE2,0.D0,PD1)
            IPDFC = 1
            CALL PHO_QPMPDF(IFLB,XP,SCALE2,PTA1,PVIRTP(IP),WGDIR)
            XI = PHO_RNDM(XP)*PD1(IFLB)
            IF(WGDIR.GT.XI) THEN
C  debug output
              IF(IDEB(79).GE.17) WRITE(ErrorOut,
     * '(1X,2A,/5X,4E12.5,I2,I3)')
     &          'PHO_HARISR: ',
     &          'DIRECT SPLITTING (WGDIR,WGPDF,X,SCALE2,IP,IFLB)',
     &          WGDIR,PD1(IFLB),XP,SCALE2,IP,IFLB
              Q2SH(IP,INDX) = 0.D0
              NEXT(IP) = 0
              IFANO(IP) = INDX
              GOTO 100
            ENDIF
          ENDIF
        ENDIF
C
C  rejection loop for z,t sampling
C ------------------------------------
 200    CONTINUE
          NITER = NITER+1
          IF(NITER.GE.NTRY) THEN
            WRITE(ErrorOut,'(1X,A,2I6)')
     &        'PHO_HARISR: TOO MANY REJECTIONS',NITER,NTRY
            CALL PHO_PREVNT(-1)
C  clean up event
            IREJ = 1
            GOTO 10
          ENDIF
C  PDF weights
          IF(IPDFC.EQ.0) THEN
            IF(NQQALI.EQ.1) THEN
              SCALE2 = PT2*AQQPD
            ELSE
              SCALE2 = Q2P*AQQPD
            ENDIF
            CALL PHO_PDF(IP,XP,SCALE2,0.D0,PD1)
          ENDIF
          IPDFC = 0
C
          WGTOT = 0.D0
          DO 210 I=-NFSISR,NFSISR
            WGPDF(I) = PD1(I)/(PD1(IFLB)+1.D-12)*5.D0
            WGTOT = WGTOT+WGPDF(I)*WGGAP(I)
 210      CONTINUE
C
 215      CONTINUE
C  sample new t value
          TT = TT*EXP(MAX(-10.D0,LOG(PHO_RNDM(SHAT1))*B0QCD/WGTOT))
          Q2NEW = AL2ISR(IP)*EXP(TT)/AQQALI
C  debug output
          IF(IDEB(79).GE.20) WRITE(ErrorOut,'(1X,A,E12.5)')
     &      'PHO_HARISR: PRE-SELECTED Q2:',Q2NEW
C  compare to limits
          IF(Q2NEW.LT.Q2MISR(IP)) THEN
            Q2SH(IP,INDX) = 0.D0
            NEXT(IP) = 0
            IF(IDEB(79).GE.17) WRITE(ErrorOut,
     * '(1X,A,2E10.3,2I3)')
     &        'PHO_HARISR: EVOLUTION Q2-STOP (Q2,Q2MIN,IP,INDX):',
     &        Q2NEW,Q2MISR(IP),IP,INDX
            GOTO 100
          ENDIF
          Q2SH(IP,INDX) = Q2NEW
          TT = LOG(AQQALI*Q2NEW/AL2ISR(IP))
C  selection of flavours
          XI = WGTOT*PHO_RNDM(TT)
          IFLA = -NFSISR-1
 220      CONTINUE
            IFLA = IFLA+1
            XI = XI-WGPDF(IFLA)*WGGAP(IFLA)
          IF((XI.GT.0.D0).AND.(IFLA.LT.NFSISR)) GOTO 220
C  debug output
          IF(IDEB(79).GE.20) WRITE(ErrorOut,'(1X,A,2I3)')
     &      'PHO_HARISR: PRE-SELECTED IFLA (IFLA,IFLB):',IFLA,IFLB
C  selection of z
          CALL PHO_HARZSP(IFLA,IFLB,NFSISR,ZMIN,ZMAX,ZZ)
C  debug output
          IF(IDEB(79).GE.20) WRITE(ErrorOut,'(1X,A,E12.3)')
     &      'PHO_HARISR: PRE-SELECTED ZZ',ZZ
C  angular ordering
          THETA = 4.D0*ZZ**2*Q2NEW/((ECMP*XP)**2*(1.D0-ZZ))
          IF(THETA.GT.THSH(IP,INDX)) THEN
            IF(IDEB(79).GE.20) WRITE(ErrorOut,'(1X,A,2E12.3)')
     &        'PHO_HARISR: REJECT BY ANGLE (NEW/OLD)',
     &        THETA,THSH(IP,INDX)
            GOTO 215
          ENDIF
C  rejection weight given by new PDFs
          XNEW = XP/ZZ
          PT2NEW = Q2NEW*(1.D0-ZZ)
          IF(NQQALI.EQ.1) THEN
            SCALE2 = PT2NEW*AQQPD
          ELSE
            SCALE2 = Q2NEW*AQQPD
          ENDIF
          IF(SCALE2.LT.Q2MISR(IP)) THEN
            Q2SH(IP,INDX) = 0.D0
            NEXT(IP) = 0
            IF(IDEB(79).GE.17) WRITE(ErrorOut,
     * '(1X,A,2E10.3,2I3)')
     &        'PHO_HARISR: EVOL.Q2-STOP (SCALE2,Q2MIN,IP,INDX):',
     &        Q2NEW,Q2MISR(IP),IP,INDX
            GOTO 100
          ENDIF
          CALL PHO_PDF(IP,XNEW,SCALE2,0.D0,PD2)
          IF(PD2(IFLA).LT.1.D-10) GOTO 200
          CALL PHO_PDF(IP,XP,SCALE2,0.D0,PD1)
          PD1(IFLB) = MAX(PD1(IFLB),1.D-10)
          WGF = PD2(IFLA)/PD1(IFLB)/(WGPDF(IFLA)+1.D-12)
          IF(NQQALI.EQ.1) WGF = WGF*LOG(Q2NEW*AQQALI/AL2ISR(IP))
     &      /LOG(PT2NEW*AQQALI/AL2ISR(IP))
          IF((WGF.GT.1.D0).AND.(IDEB(79).GE.2)) THEN
            WRITE(ErrorOut,'(1X,A,E12.3)')
     &        'PHO_HARISR: FINAL WEIGHT:',WGF
            WRITE(ErrorOut,'(6X,A,I7,2I3,3E11.3)')
     &      'EV,IFLA,IFLB,Q2,PT2,Z:',KEVENT,IFLA,IFLB,Q2NEW,PT2NEW,ZZ
          ENDIF
        IF(WGF.LT.PHO_RNDM(XNEW)) GOTO 200

        IF(IDEB(79).GE.15) THEN
          WRITE(ErrorOut,'(1X,A,/3X,3I3,3E11.3)')
     &      'PHO_HARISR: ACCEPTED IP,IFLA,IFLB,PT2,Q2,Z:',
     &      IP,IFLA,IFLB,PT2NEW,Q2NEW,ZZ
        ENDIF


        IF(INDX.GE.MXISR3) THEN
          WRITE(ErrorOut,
     * '(1X,2A,2I4)') 'PHO_HARISR: no space left in ',
     &      '/POINT6/ FOR PARTON RADIATION (INDX,MXISR3):',INDX,MXISR3
          IREJ = 1
          RETURN
        ENDIF

C  branching accepted, registration
        Q2SH(IP,INDX) = Q2NEW
        PT2SH(IP,INDX) = PT2NEW
        ZPSH(IP,INDX) = ZZ
        IFL2(IP,INDX) = IFLA-IFLB
        Q2SH(IP,INDX+1) = Q2NEW
        PT2SH(IP,INDX+1) = PT2SH(IP,INDX)
        XPSH(IP,INDX+1) = XNEW
        THSH(IP,INDX+1) = THETA
        IFL1(IP,INDX+1) = IFLA
        ISH(IP) = ISH(IP)+1

        NACC = NACC+1

        IF(NACC.GT.MXISR4) THEN
          WRITE(ErrorOut,
     * '(1X,2A,2I4)') 'PHO_HARISR: no space left in ',
     &      '/POINT6/ FOR PARTON RADIATION (NACC,MXISR4):',NACC,MXISR4
          IREJ = 1
          RETURN
        ENDIF

        SHAT(NACC) = SHAT1
        IBRA(1,NACC) = IP
        IBRA(2,NACC) = INDX
        SHAT1 = SHAT1/ZZ

C  generation of next branching
      IF(NEXT(1)+NEXT(2).NE.0) GOTO 100

 800  CONTINUE

C  new initial flavours, x values
      IPB1 = IFL1(1,ISH(1))
      IPB2 = IFL1(2,ISH(2))
      XISR1 = XPSH(1,ISH(1))
      XISR2 = XPSH(2,ISH(2))
      IVO1  = IVAL(1)
      IVO2  = IVAL(2)
C  valence flavours
      IF(IPB1.NE.0) THEN
        IF(ISH(1).GT.1) THEN
          CALL PHO_PDF(1,XISR1,Q2MISR(1),0.D0,PD1)
          IF(IDPDG1.EQ.22) THEN
            CALL PHO_QPMPDF(IPB1,XISR1,Q2MISR(1),0.D0,PVIRTP(1),FXP)
            IF(PHO_RNDM(XISR1)*PD1(IPB1).GT.PD1(IPB1)-FXP) IVAL(1) = 1
          ELSE
            CALL PHO_PDF(1,XISR1,Q2MISR(1),0.D0,PD1)
            IF(PHO_RNDM(XISR1)*PD1(IPB1).GT.PD1(-IPB1)) IVAL(1) = 1
          ENDIF
        ENDIF
      ENDIF
      IF(IPB2.NE.0) THEN
        IF(ISH(2).GT.1) THEN
          CALL PHO_PDF(2,XISR2,Q2MISR(2),0.D0,PD1)
          IF(IDPDG2.EQ.22) THEN
            CALL PHO_QPMPDF(IPB2,XISR2,Q2MISR(2),0.D0,PVIRTP(2),FXP)
            IF(PHO_RNDM(XISR2)*PD1(IPB2).GT.PD1(IPB2)-FXP) IVAL(2) = 1
          ELSE
            IF(PHO_RNDM(XISR2)*PD1(IPB2).GT.PD1(-IPB2)) IVAL(2) = 1
          ENDIF
        ENDIF
      ENDIF

C  parton kinematics
      IF(NACC.GT.0) THEN
C  final partons in CMS
        PM(3) = (XH1-XH2)*ECMP/2.D0
        PM(4) = (XH1+XH2)*ECMP/2.D0
        SH = XH1*XH2*ECMP**2
        SSH = SQRT(SH)
        GB(3) = PM(3)/SSH
        GB(4) = PM(4)/SSH
        CALL PHO_ALTRA(GB(4),0.D0,0.D0,-GB(3),P1(1),P1(2),P1(3),
     &    P1(4),PTOT1,PHISR(1,1,IPAL(1)),PHISR(1,2,IPAL(1)),
     &    PHISR(1,3,IPAL(1)),PHISR(1,4,IPAL(1)))
        CALL PHO_ALTRA(GB(4),0.D0,0.D0,-GB(3),P2(1),P2(2),P2(3),
     &    P2(4),PTOT1,PHISR(2,1,IPAL(2)),PHISR(2,2,IPAL(2)),
     &    PHISR(2,3,IPAL(2)),PHISR(2,4,IPAL(2)))
        IL(1) = 1
        IL(2) = 1
        DO 900 I=1,NACC
          IPA = IBRA(1,I)
          IPB = 3-IPA
          IL(IPA) = IBRA(2,I)
C  new initial partons in CMS
          SH = SHAT(I)
          SSH = SQRT(SH)
          SHZ = SH/ZPSH(IPA,IL(IPA))
          SSHZ = SQRT(SHZ)
          Q2(1) = Q2SH(1,IL(1))
          Q2(2) = Q2SH(2,IL(2))
          PC(1,1) = 0.D0
          PC(1,2) = 0.D0
          PC(1,3) = SQRT((SH+Q2(1)+Q2(2))**2-4.D0*Q2(1)*Q2(2))
     &             /(2.D0*SSH)
          PC(1,4) = (SH-Q2(1)+Q2(2))/(2.D0*SSH)
          PC(2,1) = 0.D0
          PC(2,2) = 0.D0
          PC(2,3) = -PC(1,3)
          PC(2,4) = SSH-PC(1,4)
          XMS4 = PHO_PMASS(IFL2(IPA,IL(IPA)),1)**2
          EE3 = (SHZ-Q2(IPA)+Q2(IPB)-XMS4)/(2.D0*SSH)
          S1 = SH+Q2(IPA)+Q2(IPB)
          S3 = SHZ+Q2(IPB)+Q2SH(IPA,IL(IPA)+1)
          R1 = SQRT(S1**2-4.D0*Q2(IPA)*Q2(IPB))
          R3 = SQRT(S3**2-4.D0*Q2(IPB)*Q2SH(IPA,IL(IPA)+1))
          IF(Q2(IPB).LT.0.1D0) THEN
            XMS4M = (Q2(IPA)/ZPSH(IPA,IL(IPA))-Q2SH(IPA,IL(IPA)+1))
     &             *(SH/(SH+Q2(IPA))-SH/(SHZ+Q2SH(IPA,IL(IPA)+1)))
          ELSE
            XMS4M = (S1*S3-R1*R3)/(2.D0*Q2(IPB))
     &             -Q2(IPA)-Q2SH(IPA,IL(IPA)+1)
          ENDIF
          NGEN = 1
C  max. virtuality for time-like showers
          QMAX = MIN(XMS4M,PARMDL(95)*Q2(IPA))
          IF((IPAMDL(111).GE.1).AND.(QMAX.GT.PARMDL(94))) THEN
C  generate time-like parton shower
            KF = IFL2(IPA,IL(IPA))
            IF(KF.EQ.0) KF = 21
            EER = MIN(EE3-PC(IPA,4),ECMP)
            THER = 0.

            CALL PY1ENT(1,KF,EER,THER,THER)
            QMAXR = SQRT(QMAX)
            CALL PYSHOW(1,0,QMAXR)
C debug output
            IF(IDEB(79).GE.25) THEN
              WRITE(ErrorOut,
     * '(1X,2A,/,5X,1P,4E12.4)') 'PHO_HARISR: ',
     &          'PYSHOW CALLED FOR EE,QMAX,XMS4M,Q2(IPA)',
     &          EER,QMAX,XMS4M,Q2(IPA)
              CALL PYLIST(1)
            ENDIF
            NGEN = PYK(0,1)

            IF(NGEN.GT.1) THEN
              PJX = 0.D0
              PJY = 0.D0
              PJZ = 0.D0
              PJE = 0.D0
              KK = IPAL(IPA)
              DO 820 K=3,NGEN

                IF(PYK(K,1).LE.4) THEN
                  KK = KK+1

                  IF(KK.GT.MXISR1) THEN
                    WRITE(ErrorOut,
     * '(1X,2A,2I5)') 'PHO_HARISR: no space ',
     &                'LEFT IN /POPISR/ (KK,MXISR1):',KK,MXISR1
                    IREJ = 1
                    RETURN
                  ENDIF

                  PHISR(IPA,1,KK) = PYP(K,1)
                  PJX = PJX+PHISR(IPA,1,KK)
                  PHISR(IPA,2,KK) = PYP(K,2)
                  PJY = PJY+PHISR(IPA,2,KK)
                  PHISR(IPA,3,KK) = PYP(K,3)
                  PJZ = PJZ+PHISR(IPA,3,KK)
                  PHISR(IPA,4,KK) = PYP(K,4)
                  PJE = PJE+PHISR(IPA,4,KK)
                  IFLISR(IPA,KK)  = PYK(K,2)

                  IF(IFLISR(IPA,KK).EQ.21) IFLISR(IPA,KK) = 0
                  IF(IFLISR(IPA,KK).EQ.5) IFLISR(IPA,KK) = 3
                  IF(IFLISR(IPA,KK).EQ.-5) IFLISR(IPA,KK) = -3
                ENDIF
 820          CONTINUE
              NGEN = KK-IPAL(IPA)
              XMS4 = (PJE+PJZ)*(PJE-PJZ)-PJX**2-PJY**2
              PP4  = SQRT(PJE**2-XMS4)
              EE3  = (SHZ-Q2(IPA)+Q2(IPB)-XMS4)/(2.D0*SSH)
C debug output
              IF(IDEB(79).GE.20) WRITE(ErrorOut,
     * '(1X,2A,/,5X,1P,6E12.4)')
     &         'PHO_HARISR: ',
     &         'TIME-LIKE SHOWER: PJE,PJX,PJY,PJZ,PP4,XMS4',
     &         PJE,PJX,PJY,PJZ,PP4,XMS4
            ENDIF
          ENDIF
          PZ3 = (2.D0*PC(IPA,4)*EE3+Q2(IPA)+Q2SH(IPA,IL(IPA)+1)+XMS4)
     &          /(2.D0*PC(IPA,3))
          PT3 = (EE3+PZ3)*(EE3-PZ3)+Q2SH(IPA,IL(IPA)+1)
          IF(PT3.LT.0.D0) THEN
            IF(IDEB(79).GE.5) WRITE(ErrorOut,'(1X,A,E12.3)')
     &        'PHO_HARISR: REJECTION DUE TO PT3',PT3
            GOTO 10
          ENDIF
          PT3 = SQRT(PT3)
          CALL PHO_SFECFE(SFE,CFE)
          PX3 = CFE*PT3
          PY3 = SFE*PT3
C
          IF(NGEN.GT.1) THEN
C  time-like shower generated
            EE4 = EE3-PC(IPA,4)
            PZ4 = PZ3-PC(IPA,3)
            PP4 = SQRT(PT3**2+PZ4**2)
C  Lorentz boost
            GAM = (EE4*PJE-PP4*PJZ)/XMS4
            BEG = (PJE*PP4-EE4*PJZ)/XMS4
C  rotation angles
            CODD = PZ4/PP4
            SIDD = SQRT(PX3**2+PY3**2)/PP4
            COFD = 1.D0
            SIFD = 0.D0
            IF(PP4*SIDD.GT.1.D-5) THEN
              COFD = PX3/(SIDD*PP4)
              SIFD = PY3/(SIDD*PP4)
              ANORF = SQRT(COFD*COFD+SIFD*SIFD)
              COFD = COFD/ANORF
              SIFD = SIFD/ANORF
            ENDIF
C  copy partons back
            KK = IPAL(IPA)
            DO 830 K=1,NGEN
              KK = KK+1
              PX = PHISR(IPA,1,KK)
              PY = PHISR(IPA,2,KK)
              PZ = PHISR(IPA,3,KK)
              COH= PHISR(IPA,4,KK)
              EE = GAM*COH+BEG*PZ
              PZ = GAM*PZ +BEG*COH
              PHISR(IPA,4,KK) = EE
              CALL PHO_TRANS(PX,PY,PZ,CODD,SIDD,COFD,SIFD,
     &          PHISR(IPA,1,KK),PHISR(IPA,2,KK),PHISR(IPA,3,KK))
 830        CONTINUE
            IPAL(IPA) = KK
          ELSE
C  no time-like shower generated
            IPAL(IPA) = IPAL(IPA)+1
            PHISR(IPA,1,IPAL(IPA)) = PX3
            PHISR(IPA,2,IPAL(IPA)) = PY3
            PHISR(IPA,3,IPAL(IPA)) = PZ3-PC(IPA,3)
            PHISR(IPA,4,IPAL(IPA)) = EE3-PC(IPA,4)
            IFLISR(IPA,IPAL(IPA))  = IFL2(IPA,IL(IPA))
          ENDIF
          PC(IPA,1) = PX3
          PC(IPA,2) = PY3
          PC(IPA,3) = PZ3
          PC(IPA,4) = EE3
C  boost / rotate into new CMS
          DO 842 K=1,4
            GB(K) = (PC(1,K)+PC(2,K))/SSHZ
 842      CONTINUE
          CALL PHO_ALTRA(GB(4),-GB(1),-GB(2),-GB(3),PC(1,1),PC(1,2),
     &      PC(1,3),PC(1,4),PTOT1,PM(1),PM(2),PM(3),PM(4))
          COG= PM(3)/PTOT1
          SIG= SQRT(PM(1)**2+PM(2)**2)/PTOT1
          COH=1.D0
          SIH=0.D0
          IF(PTOT1*SIG.GT.1.D-5) THEN
            COH=PM(1)/(SIG*PTOT1)
            SIH=PM(2)/(SIG*PTOT1)
            ANORF=SQRT(COH*COH+SIH*SIH)
            COH=COH/ANORF
            SIH=SIH/ANORF
          ENDIF
          DO 845 K=1,2
            DO 844 L=IPOISR(K,1,IHIDX),IPAL(K)
              CALL PHO_ALTRA(GB(4),-GB(1),-GB(2),-GB(3),
     &          PHISR(K,1,L),PHISR(K,2,L),PHISR(K,3,L),PHISR(K,4,L),
     &          PTOT1,PM(1),PM(2),PM(3),PM(4))
              CALL PHO_TRANI(PM(1),PM(2),PM(3),COG,SIG,COH,SIH,PN(1),
     &          PN(2),PN(3))
              CALL PHO_TRANS(PN(1),PN(2),PN(3),1.D0,0.D0,COH,SIH,
     &          PHISR(K,1,L),PHISR(K,2,L),PHISR(K,3,L))
              PHISR(K,4,L) = PM(4)
 844        CONTINUE
 845      CONTINUE
 900    CONTINUE
C  boost back to global CMS
        PM(3) = (XISR1-XISR2)/2.D0
        PM(4) = (XISR1+XISR2)/2.D0
        SSH = SQRT(XISR1*XISR2)
        GB(3) = PM(3)/SSH
        GB(4) = PM(4)/SSH
        DO 945 K=1,2
          DO 944 L=IPOISR(K,1,IHIDX),IPAL(K)
            CALL PHO_ALTRA(GB(4),0.D0,0.D0,GB(3),PHISR(K,1,L),
     &        PHISR(K,2,L),PHISR(K,3,L),PHISR(K,4,L),PTOT1,PM(1),
     &        PM(2),PM(3),PM(4))
            PHISR(K,1,L) = PM(1)
            PHISR(K,2,L) = PM(2)
            PHISR(K,3,L) = PM(3)
            PHISR(K,4,L) = PM(4)
 944      CONTINUE
 945    CONTINUE
      ENDIF
      IPOISR(1,2,IHIDX) = IPAL(1)
      IPOISR(2,2,IHIDX) = IPAL(2)
      IMXISR(1) = IPAL(1)
      IMXISR(2) = IPAL(2)
C
C  debug output
      IF(IDEB(79).GE.10) THEN
        WRITE(ErrorOut,
     * '(1X,A,2I10/,6X,A,2E12.3,2I5)') 'NUMBER OF EMISSIONS',
     &    ISH(1)-1,ISH(2)-1,'NEW X1,X2,IFL1,ILF2',XISR1,XISR2,IPB1,IPB2
        IF(NACC.GT.0) THEN
          WRITE(ErrorOut,'(1X,A,2I5,/6X,A)')
     &    'PHO_HARISR: ISR CONFIGURATION (NITER,NACC)',NITER,NACC,
     &    ' SIDE   NO.   IFLB IFLC     Q2SH    PT2SH     XH         ZZ'
          DO 600 II=1,NACC
            K = IBRA(1,II)
            I = IBRA(2,II)
            WRITE(ErrorOut,'(5X,4I5,4E11.3)')
     &        K,I,IFL1(K,I),IFL2(K,I),Q2SH(K,I),PT2SH(K,I),XPSH(K,I),
     &        ZPSH(K,I)
 600      CONTINUE
        ENDIF
C  check of final configuration
        PX3 = 0.D0
        PY3 = 0.D0
        PZ3 = 0.D0
        EE3 = 0.D0
        IFSUM(1) = 0
        IFSUM(2) = 0
        WRITE(ErrorOut,'(1X,A)') 'PHO_HARISR: outgoing partons'
        DO 745 K=1,2
          DO 744 L=IPOISR(K,1,IHIDX),IPOISR(K,2,IHIDX)
            WRITE(ErrorOut,
     * '(6X,2I4,I6,4E11.3)') K,L,IFLISR(K,L),
     &        PHISR(K,1,L),PHISR(K,2,L),PHISR(K,3,L),PHISR(K,4,L)
            IFSUM(K) = IFSUM(K)+ IFLISR(K,L)
            PX3 = PX3 + PHISR(K,1,L)
            PY3 = PY3 + PHISR(K,2,L)
            PZ3 = PZ3 + PHISR(K,3,L)
            EE3 = EE3 + PHISR(K,4,L)
 744      CONTINUE
 745    CONTINUE
        IFSUM(1) = IFSUM(1)-IPB1
        IFSUM(2) = IFSUM(2)-IPB2
        PZ3 = PZ3 -(XISR1-XISR2)*ECMP/2.D0
        EE3 = EE3 -(XISR1+XISR2)*ECMP/2.D0
        WRITE(ErrorOut,
     * '(1X,A,2I4,4E11.3)') 'CHECK:IFL1,2 PCM(1-4)',
     &    IFSUM,PX3,PY3,PZ3,EE3
      ENDIF
      END


CDECK  ID>, PHO_HARZSP
      SUBROUTINE PHO_HARZSP(IFLA,IFLB,NFSH,ZMIN,ZMAX,ZZ)
C*********************************************************************
C
C     sampling of z values from DGLAP kernels
C
C     input:  IFLA,IFLB      parton flavours
C             NFSH           flavours involved in hard processes
C             ZMIN           minimal ZZ allowed
C             ZMAX           maximal ZZ allowed
C
C     output: ZZ             z value
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS   =  1.D-10 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)


      IF(ZMAX.LE.ZMIN) THEN
        WRITE(ErrorOut,'(1X,A,2E12.3)')
     &    'PHO_HARZSP: ZMAX<ZMIN (ZMAX,ZMIN)',ZMAX,ZMIN
        CALL PHO_PREVNT(-1)
        ZZ = 0.D0
        RETURN
      ENDIF
C
      IF(IFLB.EQ.0) THEN
        IF(IFLA.EQ.0) THEN
C  g --> g g
          C1 = ZMAX/ZMIN*(1.D0-ZMIN)/(1.D0-ZMAX)
          C2 = (1.D0-ZMIN)/ZMIN
 100      CONTINUE
            ZZ = 1.D0/(1.D0+C2/C1**PHO_RNDM(ZMIN))
          IF((1.D0-ZZ*(1.D0-ZZ))**2.LT.PHO_RNDM(ZMAX)) GOTO 100
        ELSE IF(ABS(IFLA).LE.NFSH) THEN
C  q --> q g
          C1 = ZMAX/ZMIN
 200      CONTINUE
            ZZ = ZMIN*C1**PHO_RNDM(ZMIN)
          IF(0.5D0*(1.D0+(1.D0-ZZ)**2).LT.PHO_RNDM(ZMAX)) GOTO 200
        ELSE
          GOTO 900
        ENDIF
      ELSE IF(ABS(IFLB).LE.NFSH) THEN
        IF(IFLA.EQ.0) THEN
C  g --> q qb
          C1 = ZMAX-ZMIN
 300      CONTINUE
            ZZ = ZMIN+C1*PHO_RNDM(ZMIN)
          IF((2.D0*ZZ*(ZZ-1.D0)+1.D0).LT.PHO_RNDM(ZMAX)) GOTO 300
        ELSE IF(ABS(IFLA).LE.NFSH) THEN
C  q --> g q
          C1 = (1.D0-ZMAX)/(1.D0-ZMIN)
          C2 = 1.D0-ZMIN
 400      CONTINUE
            ZZ = 1.D0-C2*C1**PHO_RNDM(ZMIN)
          IF(0.5D0*(1.D0+ZZ**2).LT.PHO_RNDM(ZMAX)) GOTO 400
        ELSE
          GOTO 900
        ENDIF
      ELSE
        GOTO 900
      ENDIF
C  debug output
      IF(IDEB(80).GE.20) WRITE(ErrorOut,'(1X,A,2I3,3E11.3)')
     &  'PHO_HARZSP: IFLA,IFLB,ZZ,ZMIN,ZMAX',
     &  IFLA,IFLB,ZZ,ZMIN,ZMAX
      RETURN

 900  CONTINUE
      WRITE(ErrorOut,
     * '(/1X,A,2I7)') 'PHO_HARZSP:ERROR: invalid flavours A,B',
     &  IFLA,IFLB
      CALL PHO_ABORT

      END


CDECK  ID>, PHO_ALPHAE
      DOUBLE PRECISION FUNCTION PHO_ALPHAE(Q2)
C**********************************************************************
C
C     calculation of ALPHA_em
C
C     input:    Q2      scale in GeV**2
C
C**********************************************************************

      IMPLICIT NONE

      SAVE

      DOUBLE PRECISION Q2

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)



      DOUBLE PRECISION PYALEM


      PHO_ALPHAE = 1.D0/137.D0

      IF(IPAMDL(120).EQ.1) THEN

        PHO_ALPHAE = PYALEM(Q2)

      ENDIF

      END


CDECK  ID>, PHO_ALPHAS
      DOUBLE PRECISION FUNCTION PHO_ALPHAS(Q2,IMODE)
C**********************************************************************
C
C     calculation of ALPHA_S
C
C     input:    IMODE = 1         lambda_QCD**2 for PDF 1 evolution
C                       2         lambda_QCD**2 for PDF 2 evolution
C                       3         lambda_QCD**2 for hard scattering
C               Q2      scale in GeV**2
C
C     initialization needed:
C               IMODE = 0         lambda values taken from PDF table
C                       -1        given Q2 is 4-flavour lambda 1
C                       -2        given Q2 is 4-flavour lambda 2
C                       -3        given Q2 is 4-flavour lambda 3
C
C
C**********************************************************************

      IMPLICIT NONE

      SAVE

      DOUBLE PRECISION Q2
      INTEGER IMODE

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD


      INTEGER I


      PHO_ALPHAS = 0.D0

      IF(IMODE.GT.0) THEN

        IF(Q2.LT.PARMDL(148)) THEN
          NFBETA = 1
        ELSE IF(Q2.LT.PARMDL(149)) THEN
          NFBETA = 2
        ELSE IF(Q2.LT.PARMDL(150)) THEN
          NFBETA = 3
        ELSE
          NFBETA = 4
        ENDIF

        PHO_ALPHAS = BQCD(NFBETA)/LOG(Q2/ALQCD2(IMODE,NFBETA))
        NFBETA = NFBETA+2

      ELSE IF(IMODE.EQ.0) THEN

        DO I=1,3
          IF(I.EQ.3) THEN
            ALQCD2(I,2) = PDFLAM(1)*PDFLAM(2)
          ELSE
            ALQCD2(I,2) = PDFLAM(I)*PDFLAM(I)
          ENDIF
          ALQCD2(I,1) = PARMDL(148)
     &                 *(ALQCD2(I,2)/PARMDL(148))**(BQCD(1)/BQCD(2))
          ALQCD2(I,3) = PARMDL(149)
     &                 *(ALQCD2(I,2)/PARMDL(149))**(BQCD(3)/BQCD(2))
          ALQCD2(I,4) = PARMDL(150)
     &                 *(ALQCD2(I,2)/PARMDL(150))**(BQCD(4)/BQCD(2))

        ENDDO

      ELSE IF(IMODE.LT.0) THEN

        IF(IMODE.EQ.-4) THEN
          I = 3
          ALQCD2(I,2) = SQRT(ALQCD2(1,2)*ALQCD2(2,2))
        ELSE
          I = -IMODE
          ALQCD2(I,2) = Q2
        ENDIF
        ALQCD2(I,1) = PARMDL(148)
     &               *(ALQCD2(I,2)/PARMDL(148))**(BQCD(1)/BQCD(2))
        ALQCD2(I,3) = PARMDL(149)
     &               *(ALQCD2(I,2)/PARMDL(149))**(BQCD(3)/BQCD(2))
        ALQCD2(I,4) = PARMDL(150)
     &               *(ALQCD2(I,2)/PARMDL(150))**(BQCD(4)/BQCD(2))

      ENDIF

      END



CDECK  ID>, PHO_DFWRAP
      SUBROUTINE PHO_DFWRAP(MODE,JM1,JM2)
C**********************************************************************
C
C     wrapper for diffraction dissociation in hadron-nucleus and
C     nucleus-nucleus collisions with DTUNUC
C
C     input:      MODE     1:   transformation into CMS
C                          2:   transformation into Lab
C                 JM1/2    indices of old mother particles
C                 JM1/2N   indices of new mother particles
C
C**********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      INTEGER MODE,JM1,JM2

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)



      DOUBLE PRECISION GAMBED(4),P1(4),P2(4),P3(4),P4(4),XM1,XM2
      DOUBLE PRECISION SS,ECMD,PTOT1,CODD,SIDD,COFD,SIFD,ANORF

      INTEGER I,NHEPS,JM1S,JM2S,JM1N,JM2N,IREJ

C  transformation into CMS

      IF(MODE.EQ.1) THEN

        JM1S = JM1
        JM2S = JM2
        NHEPS = NHEP

        XM1 = PHEP(5,JM1)
        XM2 = PHEP(5,JM2)

C  boost into CMS
        P1(1) = PHEP(1,JM1)+PHEP(1,JM2)
        P1(2) = PHEP(2,JM1)+PHEP(2,JM2)
        P1(3) = PHEP(3,JM1)+PHEP(3,JM2)
        P1(4) = PHEP(4,JM1)+PHEP(4,JM2)
        SS = (P1(4)+P1(3))*(P1(4)-P1(3))-P1(1)**2-P1(2)**2
        ECMD = SQRT(SS)
        DO 10 I=1,4
          GAMBED(I) = P1(I)/ECMD
 10     CONTINUE
        CALL PHO_ALTRA(GAMBED(4),-GAMBED(1),-GAMBED(2),-GAMBED(3),
     &             PHEP(1,JM1),PHEP(2,JM1),PHEP(3,JM1),
     &             PHEP(4,JM1),PTOT1,P1(1),P1(2),P1(3),P1(4))
C  rotation angles
        CODD = P1(3)/PTOT1
        SIDD = SQRT(P1(1)**2+P1(2)**2)/PTOT1
        COFD = 1.D0
        SIFD = 0.D0
        IF(PTOT1*SIDD.GT.1.D-5) THEN
          COFD = P1(1)/(SIDD*PTOT1)
          SIFD = P1(2)/(SIDD*PTOT1)
          ANORF= SQRT(COFD*COFD+SIFD*SIFD)
          COFD = COFD/ANORF
          SIFD = SIFD/ANORF
        ENDIF

C  initial particles in CMS

        P1(1) = 0.D0
        P1(2) = 0.D0
        P1(3) = ECMD/2.D0*XPSUB
        P1(4) = P1(3)

        P2(1) = 0.D0
        P2(2) = 0.D0
        P2(3) = -ECMD/2.D0*XTSUB
        P2(4) = -P2(3)

        CALL PHO_MSHELL(P1,P2,XM1,XM2,P3,P4,IREJ)

        CALL PHO_REGPAR(1,IDHEP(JM1),IMPART(JM1),JM1,JM2,
     &    P3(1),P3(2),P3(3),P3(4),IPHIST(1,JM1),IPHIST(2,JM1),
     &    ICOLOR(1,JM1),ICOLOR(2,JM1),JM1N,1)

        CALL PHO_REGPAR(1,IDHEP(JM2),IMPART(JM2),JM2,JM1,
     &    P4(1),P4(2),P4(3),P4(4),IPHIST(1,JM2),IPHIST(2,JM2),
     &    ICOLOR(1,JM2),ICOLOR(2,JM2),JM2N,1)


        JM1 = JM1N
        JM2 = JM2N

C  transformation into lab.

      ELSE IF(MODE.EQ.2) THEN

        CALL PHO_LTRHEP(JM1,NHEP,CODD,SIDD,COFD,SIFD,GAMBED(4),
     &    GAMBED(1),GAMBED(2),GAMBED(3))

        JM1 = JM1S
        JM2 = JM2S

C  clean up after rejection

      ELSE IF(MODE.EQ.-2) THEN

        NHEP = NHEPS

        JM1 = JM1S
        JM2 = JM2S

      ELSE

        WRITE(ErrorOut,
     * '(1X,A,I6)') 'PHO_DFWRAP: invalid MODE parameter:',MODE

      ENDIF

      END



CDECK  ID>, PHO_DIFDIS
      SUBROUTINE PHO_DIFDIS(IDIF1,IDIF2,IMOTH1,IMOTH2,SPROB,IMODE,
     &                      MSOFT,MHARD,IREJ)
C***********************************************************************
C
C     sampling of diffractive events of different kinds,
C                            (produced particles stored in /POEVT1/)
C
C     input:   IDIF1/2   diffractive process particle 1/2
C                          0   elastic/quasi-elastic scattering
C                          1   diffraction dissociation
C              IMOTH1/2  index of mother particles in /POEVT1/
C              SPROB     suppression factor (survival probability) for
C                        resolved diffraction dissociation
C              IMODE     mode of operation
C                          0  sampling of diffractive cut
C                          1  sampling of enhanced cut
C                          2  sampling of diffractive cut without
C                             scattering (needed for double-pomeron)
C                         -1  initialization
C                         -2  output of statistics
C
C     output:   MSOFT    number of generated soft strings
C               MHARD    number of generated hard strings
C               IDIF1/2  diffraction label for particle 1/2 in /PROCES/
C                          0   quasi elastic scattering
C                          1   low-mass diffractive dissociation
C                          2   soft high-mass diffractive dissociation
C                          3   hard resolved diffractive dissociation
C                          4   hard direct diffractive dissociation
C               IREJ     rejection label
C                          0  successful generation of partons
C                          1  failure
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( EPS  = 1.D-7,
     &            DEPS = 1.D-10)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  c.m. kinematics of diffraction
      INTEGER NPOSD
      DOUBLE PRECISION ECMD,PCMD,PMASSD,PVIRTD,GAMBED,
     &                 SIDD,CODD,SIFD,COFD,PDCMS
      COMMON /PODCMS/ ECMD,PCMD,PMASSD(2),PVIRTD(2),GAMBED(4),
     &                SIDD,CODD,SIFD,COFD,PDCMS(4,2),NPOSD(2)

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  parameters of 2x2 channel model
      DOUBLE PRECISION PHISUP,RMASS,VAR,AMPFAC,ELAFAC,VFAC
      COMMON /PO2CHA/ PHISUP(2),RMASS(2),VAR,AMPFAC(4),ELAFAC(4),VFAC

C  table of particle indices for recursive PHOJET calls
      INTEGER MAXIPX
      PARAMETER ( MAXIPX = 100 )
      INTEGER IPOPOS,IPORES,IPOIX1,IPOIX2,IPOIX3
      COMMON /PORECU/ IPOPOS(2,MAXIPX),IPORES(MAXIPX),
     &                IPOIX1,IPOIX2,IPOIX3


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      DOUBLE PRECISION P1,P2,XMASS,AMP,PP,PD1,PD2
      DIMENSION P1(5),P2(5),XMASS(2),AMP(2),PP(7,2),PD1(7),PD2(7)
      DIMENSION IDPDG(2),IDBAM(2),IPAR(2),IPOSP(2,2),IRPDG(2),IVEC(2),
     &          IRBAM(2),IFL1P(2),IFL2P(2),ISAM(2),JSAM(2),KSAM(2),
     &          IDIR(2),IPROC(2)

      IF(IMODE.EQ.-1) THEN
C  initialization
        RETURN
      ELSE IF(IMODE.EQ.-2) THEN
C  output of statistics
        RETURN
      ENDIF

      IREJ = 0
C  mass cuts
      PIMASS  = 0.140D0
C  debug output
      IF(IDEB(45).GE.10) THEN
        WRITE(ErrorOut,'(1X,2A,/16X,7I6)') 'PHO_DIFDIS: (1) ',
     &    'IDIF1,IDIF2,IMOTH1,IMOTH2,MSOFT,MHARD,IMODE',
     &    IDIF1,IDIF2,IMOTH1,IMOTH2,MSOFT,MHARD,IMODE
      ENDIF
      IPAR(1) = IDIF1
      IPAR(2) = IDIF2
C  save current status
      MSOFT = 0
      MHARD = 0
      KHPOMS = KHPOM
      KSPOMS = KSPOM
      KSREGS = KSREG
      KHDIRS = KHDIR
      IPOIS1 = IPOIX1
      IPOIS2 = IPOIX2
      IPOIS3 = IPOIX3
      JDA11 = JDAHEP(1,IMOTH1)
      JDA21 = JDAHEP(2,IMOTH1)
      JDA12 = JDAHEP(1,IMOTH2)
      JDA22 = JDAHEP(2,IMOTH2)
      ISTH1 = ISTHEP(IMOTH1)
      ISTH2 = ISTHEP(IMOTH2)
      NHEPS = NHEP
C  get mother data
      NPOSD(1) = IMOTH1
      NPOSD(2) = IMOTH2
      DO 20 I=1,2
        IDPDG(I) = IDHEP(NPOSD(I))
        IDBAM(I) = IMPART(NPOSD(I))
        AMP(I) = PHO_PMASS(IDBAM(I),0)
        IF(IDPDG(I).EQ.22) THEN
          PMASSD(I) = 0.765D0
          PVIRTD(I) = PHEP(5,NPOSD(I))**2
        ELSE
          PMASSD(I) = PHO_PMASS(IDBAM(I),0)
          PVIRTD(I) = 0.D0
        ENDIF
 20   CONTINUE
C  get CM system
      P1(1) = PHEP(1,IMOTH1)+PHEP(1,IMOTH2)
      P1(2) = PHEP(2,IMOTH1)+PHEP(2,IMOTH2)
      P1(3) = PHEP(3,IMOTH1)+PHEP(3,IMOTH2)
      P1(4) = PHEP(4,IMOTH1)+PHEP(4,IMOTH2)
      SS = (P1(4)+P1(3))*(P1(4)-P1(3))-P1(1)**2-P1(2)**2
      ECMD = SQRT(SS)
      IF(IDEB(45).GE.15) WRITE(ErrorOut,'(1X,A,E12.4)')
     &  'PHO_DIFDIS: AVAILABE ENERGY',ECMD
C  check total available energy
      IF((AMP(1)+AMP(2)+0.1D0).GE.ECMD) THEN
        IF(IDEB(45).GE.2) WRITE(ErrorOut,
     * '(1X,2A,/5X,A,1P,3E11.3)')
     &    'PHO_DIFDIS: ',
     &    'NOT ENOUGH ENERGY FOR INELASTIC DIFFRACTION',
     &    'ECM, PARTICLE MASSES:',ECMD,AMP
        IFAIL(7) = IFAIL(7)+1
        IREJ = 1
        RETURN
      ENDIF
C  boost into CMS
      DO 10 I=1,4
        GAMBED(I) = P1(I)/ECMD
 10   CONTINUE
      CALL PHO_ALTRA(GAMBED(4),-GAMBED(1),-GAMBED(2),-GAMBED(3),
     &           PHEP(1,IMOTH1),PHEP(2,IMOTH1),PHEP(3,IMOTH1),
     &           PHEP(4,IMOTH1),PTOT1,P1(1),P1(2),P1(3),P1(4))
C  rotation angles
      CODD = P1(3)/PTOT1
      SIDD = SQRT(P1(1)**2+P1(2)**2)/PTOT1
      COFD = 1.D0
      SIFD = 0.D0
      IF(PTOT1*SIDD.GT.1.D-5) THEN
        COFD = P1(1)/(SIDD*PTOT1)
        SIFD = P1(2)/(SIDD*PTOT1)
        ANORF= SQRT(COFD*COFD+SIFD*SIFD)
        COFD = COFD/ANORF
        SIFD = SIFD/ANORF
      ENDIF
C  initial particles in CMS
      PDCMS(1,1) = 0.D0
      PDCMS(2,1) = 0.D0
      PDCMS(3,1) = PTOT1
      PDCMS(4,1) = P1(4)
      PDCMS(1,2) = 0.D0
      PDCMS(2,2) = 0.D0
      PDCMS(3,2) = -PTOT1
      PDCMS(4,2) = ECMD-P1(4)
C  get new CM momentum
      AM12 = PMASSD(1)**2
      AM22 = PMASSD(2)**2
      PCMD = PHO_XLAM(SS,AM12,AM22)/(2.D0*ECMD)

C  coherence constraint (min/max diffractive mass allowed)
      IF(IMODE.EQ.2) THEN
        THRM1 = PARMDL(71)/SQRT(1-PARMDL(72))
        THRM1 = MAX(THRM1,PARMDL(70)*PARMDL(71))
        THRM2 = SQRT(1-PARMDL(72))*ECMD
        THRM2 = MIN(THRM2,ECMD/PARMDL(70))
      ELSE
        THRM1 = PARMDL(46)
        THRM2 = PARMDL(45)*ECMD
C  check kinematic limits
        IF(THRM2.LE.(4.D0*PARMDL(162))) IPAR(1) = MIN(IPAR(1),1)
        IF(THRM2.LE.(4.D0*PARMDL(163))) IPAR(2) = MIN(IPAR(2),1)
      ENDIF

C  check energy vs. coherence constraints
      IF(MAX(PARMDL(162),PMASSD(1)+THRM1).GE.THRM2) IPAR(1) = 0
      IF(MAX(PARMDL(163),PMASSD(2)+THRM1).GE.THRM2) IPAR(2) = 0

C  no phase space available
      IF(IPAR(1)+IPAR(2).EQ.0) THEN
        IF(IDEB(45).GE.2) WRITE(ErrorOut,
     * '(1X,2A,1P,E11.3,2(/5X,A,2E11.3))')
     &    'PHO_DIFDIS: ',
     &    'NOT ENOUGH PHASE SPACE FOR INE. DIFFRACTION (ECM)',ECMD,
     &    'SIDE 1: MIN. MASS, UPPER MASS LIMIT:',
     &    MAX(PARMDL(162),PMASSD(1)+THRM1),THRM2,
     &    'SIDE 2: MIN. MASS, UPPER MASS LIMIT:',
     &    MAX(PARMDL(163),PMASSD(2)+THRM1),THRM2
        IFAIL(7) = IFAIL(7)+1
        IREJ = 1
        RETURN
      ENDIF

      ITRY = 0
      ITRYM = 10
      IPARS1 = IPAR(1)
      IPARS2 = IPAR(2)

C  main rejection loop
C -------------------------------
 50   CONTINUE
      ITRY = ITRY+1
      IF(ITRY.GT.1) THEN
        IFAIL(13) = IFAIL(13)+1
        IF(ITRY.GE.ITRYM) THEN
          IF(IDEB(45).GE.2) WRITE(ErrorOut,'(1X,A,I10,2I3)')
     &      'PHO_DIFDIS: REJECTION (KEVE,IPAR1/2) ',KEVENT,IPAR
          IFAIL(7) = IFAIL(7)+1
          IREJ = 1
          RETURN
        ENDIF
      ENDIF
      KSPOM = KSPOMS
      KHPOM = KHPOMS
      KHDIR = KHDIRS
      KSREG = KSREGS
      IPAR(1) = IPARS1
      IPAR(2) = IPARS2
C  reset mother-daugther relations
      NHEP = NHEPS
      JDAHEP(1,IMOTH1) = JDA11
      JDAHEP(2,IMOTH1) = JDA21
      JDAHEP(1,IMOTH2) = JDA12
      JDAHEP(2,IMOTH2) = JDA22
      ISTHEP(IMOTH1) = ISTH1
      ISTHEP(IMOTH2) = ISTH2
      IPOIX1 = IPOIS1
      IPOIX2 = IPOIS2
      IPOIX3 = IPOIS3
C
      NSLP = 0
      NCOR = 0
 55   CONTINUE

C  calculation of kinematics
      DO 100 I=1,2
C  sampling of masses
        IRPDG(I) = 0
        IRBAM(I) = 0
        IFL1P(I) = IDPDG(I)
        IFL2P(I) = IDBAM(I)
        IVEC(I)  = 0
        IDIR(I) = 0
        ISAM(I) = 0
        JSAM(I) = 0
        KSAM(I) = 0
        IF(IPAR(I).EQ.0) THEN
C  vector meson dominance assumed
          XMASS(I) = AMP(I)
          CALL PHO_VECRES(IVEC(I),XMASS(I),IFL1P(I),IFL2P(I))
C  diffraction dissociation
        ELSE IF(IPAR(I).EQ.1) THEN
          XMMIN = MAX(PARMDL(161+I),PMASSD(I)+THRM1)
          PREF2 = PMASSD(I)**2
          XMASS(I) = PHO_DFMASS(XMMIN,THRM2,PREF2,PVIRTD(I),ISWMDL(22))
        ELSE
          WRITE(ErrorOut,'(/1X,A,2I3)')
     &      'PHO_DIFDIS:ERROR:INVALID IPAR1,IPAR2',IPAR(1),IPAR(2)
          CALL PHO_ABORT
        ENDIF
 100  CONTINUE

C  sampling of momentum transfer
      CALL PHO_DIFSLP(IPAR(1),IPAR(2),IVEC(1),IVEC(2),XMASS(1),XMASS(2),
     &            THRM2,TT,SLWGHT,IREJ)
      IF(IREJ.NE.0) THEN
        NSLP=NSLP+1
        IF(NSLP.LT.100) GOTO 55
        WRITE(ErrorOut,
     * '(1X,2A,/10X,2I3,2E12.3)') 'PHO_DIFDIS: ',
     &   'TOO MANY SLOPE REJECTIONS:IPAR1,IPAR2,M1,M2',IPAR,XMASS
        IREJ = 5
        RETURN
      ENDIF

C  correct for t-M^2 correlation in diffraction
      IF(PHO_RNDM(TT).GT.SLWGHT) THEN
        NCOR=NCOR+1
        IF(NCOR.LT.100) GOTO 55
        WRITE(ErrorOut,'(1X,2A,I10)') 'PHO_DIFDIS: ',
     &   'TOO MANY REJECTIONS DUE TO T-M**2 CORRELATION (EVE)',KEVENT
        IREJ = 5
        RETURN
      ENDIF

C  debug output
      IF(IDEB(45).GE.5) THEN
        WRITE(ErrorOut,'(1X,A,/5X,2I3,3E12.3)')
     &    'PHO_DIFDIS: IPAR1,IPAR2,XMASS1,XMASS2,TT',IPAR,XMASS,TT
      ENDIF
C  not double pomeron scattering
      IF(IMODE.NE.2) THEN
C  sample diffractive interaction processes
        DO 120 I=1,2
          IF(IPAR(I).NE.0) THEN
C  find particle combination
            IF(IDPDG(I).EQ.IFPAP(1)) THEN
              IP = 2
            ELSE IF(IDPDG(I).EQ.IFPAP(2)) THEN
              IP = 3
            ELSE IF(IDPDG(I).EQ.990) THEN
              IP = 4
            ELSE
              IP = I+1
            ENDIF
C  sample dissociation process
            CALL PHO_DIFPRO(IP,ISWMDL(16),IDPDG(I),990,XMASS(I),
     &        PVIRTD(I),0.D0,SPROB,IPROC(I),ISAM(I),JSAM(I),
     &        KSAM(I),IDIR(I))
            IF((IPROC(I).EQ.1).OR.(IPROC(I).EQ.8)) THEN
C  store process label
              IF(IDIR(I).GT.0) THEN
                IPAR(I) = 4
              ELSE IF(KSAM(I).GT.0) THEN
                IPAR(I) = 3
              ELSE IF(ISAM(I).GT.0) THEN
                IPAR(I) = 2
              ELSE
                IPAR(I) = 1
C  mass fine correction
                CALL PHO_MASSAD(IDPDG(I),IFL1P(I),IFL2P(I),PMASSD(I),
     &            XMASS(I),XMNEW,IRPDG(I),IRBAM(I))
                XMASS(I) = XMNEW
              ENDIF
            ELSE
C  diffractive pomeron-hadron interaction
              IPAR(I) = 10+IPROC(I)
            ENDIF
C  debug output
            IF(IDEB(45).GE.15) WRITE(ErrorOut,
     * '(1X,A,/10X,I3,E12.4,5I3)')
     &        'PHO_DIFDIS: IP,XMASS,IPROC,ISAM,JSAM,KSAM,IDIR',
     &        IP,XMASS(I),IPROC(I),ISAM(I),JSAM(I),KSAM(I),IDIR(I)
          ENDIF
 120    CONTINUE
      ENDIF
C  actualize debug information
      IF(IMODE.EQ.1) THEN
        IDIFR1 = IPAR(1)
        IDIFR2 = IPAR(2)
      ENDIF
C  calculate new momenta in CMS
      CALL PHO_DIFKIN(XMASS(1),XMASS(2),TT,P1,P2,IREJ)
      IF(IREJ.NE.0) GOTO 50
      DO 130 I=1,4
        PP(I,1) = P1(I)
        PP(I,2) = P2(I)
 130  CONTINUE

C  comment line for diffraction
      CALL PHO_REGPAR(30,IPROCE,IMODE,NPOSD(1),NPOSD(2),XMASS(1),
     &   XMASS(2),TT,ECMD,IPAR(1),IPAR(2),IDPDG(1),IDPDG(2),ICPOS,1)
C  write diffractive strings/particles
      DO 200 I=1,2
        I1 = I
        I2 = 3-I1
        DO K=1,4
          PD1(K) = PP(K,I1)
          PD2(K) = PP(K,I2)
        ENDDO
        PP(6,I1) = SIGN(PHEP(5,NPOSD(I1))**2,PHEP(5,NPOSD(I1)))
        PP(7,I1) = TT
        IGEN = IPHIST(2,NPOSD(I1))
        IF(IGEN.EQ.0) IGEN = -I1*10
        CALL PHO_DIFPAR(NPOSD(I1),NPOSD(I2),IGEN,IFL1P(I1),IFL2P(I1),
     &    IPAR(I1),PD1,PD2,IPOSP(1,I1),IPOSP(2,I1),IMODE,IREJ)
        IF(IREJ.NE.0) THEN
          IFAIL(7+I) = IFAIL(7+I)+1
          IF(IDEB(45).GE.3) WRITE(ErrorOut,'(1X,A,2I3,E11.3)')
     &      'PHO_DIFDIS: REJECTION BY PHO_DIFPAR (I,IPAR,XM)',
     &      I,IPAR(I),XMASS(I)
          GOTO 50
        ENDIF
        ICOLOR(I1,ICPOS) = IPOSP(1,I1)
 200  CONTINUE
C  double-pomeron scattering?
      IF(IMODE.EQ.2) GOTO 150

C  diffractive final states
      DO 300 I=1,2
 110    CONTINUE
        IF(IPAR(I).EQ.0) THEN
C  vector meson production
          IF(IDPDG(I).EQ.22) THEN
            IF(ISWMDL(21).GE.0) THEN
              ISP = IPAMDL(3)
              IF(ISWMDL(21).GE.1) ISP = IPAMDL(4)
              CALL PHO_SDECAY(IPOSP(1,I),ISP,2)
            ENDIF
C  hadronic state of multi-pomeron coupling
          ELSE IF(IDPDG(I).EQ.990) THEN
            CALL PHO_SDECAY(IPOSP(1,I),0,2)
          ENDIF
        ELSE
          IF((IPROC(I).EQ.1).OR.(IPROC(I).EQ.8)) THEN
            IF(ISAM(I)+JSAM(I)+KSAM(I).EQ.0) JSAM(I) = 1
            IF(IDIR(I).GT.0) THEN
              IPAR(I) = 4
            ELSE IF(KSAM(I).GT.0) THEN
              IPAR(I) = 3
            ELSE IF(ISAM(I).GT.0) THEN
              IPAR(I) = 2
            ELSE
              IPAR(I) = 1
            ENDIF
          ELSE
            IPAR(I) = 10+IPROC(I)
          ENDIF
          IPHIST(I,ICPOS) = IPAR(I)
C  update debug informantion
          KSPOM = ISAM(I)
          KSREG = JSAM(I)
          KHPOM = KSAM(I)
          KHDIR = IDIR(I)
          IDIFR1 = IPAR(1)
          IDIFR2 = IPAR(2)
          IF((IRPDG(I).NE.0).AND.(ISWMDL(23).GT.0)) THEN

C  resonance decay, pi+pi- background
            P1(1) = PHEP(1,IPOSP(1,I))+PHEP(1,IPOSP(2,I))
            P1(2) = PHEP(2,IPOSP(1,I))+PHEP(2,IPOSP(2,I))
            P1(3) = PHEP(3,IPOSP(1,I))+PHEP(3,IPOSP(2,I))
            P1(4) = PHEP(4,IPOSP(1,I))+PHEP(4,IPOSP(2,I))
            CALL PHO_REGPAR(1,IRPDG(I),IRBAM(I),IPOSP(1,I),IPOSP(2,I),
     &        P1(1),P1(2),P1(3),P1(4),0,2,0,0,IPOS,1)
C  decay
            IF(IDPDG(I).EQ.22) THEN
              IPHIST(2,IPOS) = 3
              IF(ISWMDL(21).GE.0) THEN
                ISP = IPAMDL(3)
                IF(ISWMDL(21).GE.2) ISP = IPAMDL(4)
                CALL PHO_SDECAY(IPOS,ISP,2)
              ENDIF
            ELSE
              CALL PHO_SDECAY(IPOS,IPAMDL(3),2)
            ENDIF
            IREJ = 0
          ELSE

C  particle-pomeron scattering
            IF(IPAR(I).LE.4) THEN
C  non-diffractive particle-pomeron scattering
              IGEN = IPHIST(2,NPOSD(I))
              IF(IGEN.EQ.0) THEN
                IF(I.EQ.1) THEN
                  IGEN = 5
                ELSE
                  IGEN = 6
                ENDIF
              ENDIF
              CALL PHO_STDPAR(IPOSP(1,I),IPOSP(2,I),IGEN,
     &          ISAM(I),JSAM(I),KSAM(I),IDIR(I),IREJ)
            ELSE
C  diffractive particle-pomeron scattering
              IPOIX2 = IPOIX2+1
              IPORES(IPOIX2)   = IPROC(I)
              IPOPOS(1,IPOIX2) = IPOSP(1,I)
              IPOPOS(2,IPOIX2) = IPOSP(2,I)
            ENDIF
          ENDIF
        ENDIF

C  rejection?
        IF(IREJ.NE.0) THEN
          IFAIL(20+I) = IFAIL(20+I)+1
          IF(IPAR(I).GT.1) THEN
            IF(IPAR(I).EQ.3) IFAIL(7+2*I) = IFAIL(7+2*I)+1
            IF(IPAR(I).EQ.4) IFAIL(8+2*I) = IFAIL(8+2*I)+1
            IF(IDIR(I).GT.0) THEN
              IDIR(I) = 0
            ELSE IF(KSAM(I).GT.0) THEN
              KSAM(I) = KSAM(I)-1
            ELSE IF(ISAM(I).GT.0) THEN
              ISAM(I) = ISAM(I)-1
            ENDIF
            GOTO 110
          ELSE
            IF(IDEB(45).GE.2) WRITE(ErrorOut,'(1X,A,2I3,E11.3)')
     &        'PHO_DIFDIS: REJECTION PHO_STDPAR (I,IPAR,XM)',
     &        I,IPAR(I),XMASS(I)
            GOTO 50
          ENDIF
        ENDIF
 300  CONTINUE

      IDIF1 = IPAR(1)
      IDIF2 = IPAR(2)
C  update debug information
      KSPOM = KSPOMS+ISAM(1)+ISAM(2)
      KSREG = KSREGS+JSAM(1)+JSAM(2)
      KHPOM = KHPOMS+KSAM(1)+KSAM(2)
      KHDIR = KHDIRS+IDIR(1)+IDIR(2)

 150  CONTINUE

C  debug output
      IF(IDEB(45).GE.10) THEN
        WRITE(ErrorOut,'(1X,2A,/18X,7I6)') 'PHO_DIFDIS: (2) ',
     &    'IPAR1,IPAR2,IMOTH1,IMOTH2,MSOFT,MHARD,IMODE',
     &    IPAR,NPOSD,MSOFT,MHARD,IMODE
      ENDIF
      IF(IDEB(45).GE.15) THEN
        WRITE(ErrorOut,
     * '(2(/1X,A))') 'PHO_DIFDIS: output of /POEVT1/',
     &                        '------------------------------'
        CALL PHO_PREVNT(0)
      ENDIF

      END




CDECK  ID>, PHO_DIFPRO
      SUBROUTINE PHO_DIFPRO(IP,ICUT,ID1,ID2,XMASS,P2V1,P2V2,SPROB,
     &                  IPROC,ISAM,JSAM,KSAM,IDIR)
C*********************************************************************
C
C     sampling of diffraction dissociation process
C
C     input:  IP       particle combination
C             ICUT     user imposed limitations
C             ID1/2    PDG particle code of scattering particles
C             XMASS    diffractively produced mass (GeV)
C             P2V1/2   virtuality of scattering particles (Gev**2)
C             SPROB    suppression factor for resolved single and
C                      double diffraction dissociation
C
C     output: IRPOC    process ID
C             ISAM     number of cut pomerons (soft)
C             JSAM     number of cut reggeons
C             KSAM     number of cut pomerons (hard)
C             IDIR     direct hard interaction
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX


      ISAM = 0
      JSAM = 0
      KSAM = 0
      IDIR = 0

      IF(XMASS.GT.3.D0) THEN
C  rapidity gap survival probability
        SPRO = 1.D0
        IF(ISWMDL(28).GE.1) SPRO = SPROB
C  sample interaction
        IPROC = 0
        CALL PHO_SAMPRO(IP,ID1,ID2,XMASS,P2V1,P2V2,SPRO,IPROC)
      ELSE
        IPROC = 1
      ENDIF
      IF(IPROC.EQ.1) CALL PHO_SAMPRB(XMASS,IP,ISAM,JSAM,KSAM)
C  non-diffractive hadron-pomeron interaction
      IF((IPROC.EQ.1).OR.(IPROC.EQ.8)) THEN
C  option for suppression of multiple interaction
        IF(ICUT.EQ.0) THEN
          IPROC = 1
          IF(ISAM+KSAM+IDIR.GT.0) THEN
            ISAM = 1
            JSAM = 0
          ELSE
            JSAM = 1
          ENDIF
          KSAM = 0
          IDIR = 0
        ELSE IF(ICUT.EQ.1) THEN
          IF(IDIR.GT.0) THEN
          ELSE IF(KSAM.GT.0) THEN
            KSAM = 1
            ISAM = 0
            JSAM = 0
          ELSE IF(ISAM.GT.0) THEN
            ISAM = 1
            JSAM = 0
          ELSE
            JSAM = 1
          ENDIF
        ELSE IF(ICUT.EQ.2) THEN
          KSAM = MIN(KSAM,1)
        ELSE IF(ICUT.EQ.3) THEN
          ISAM = MIN(ISAM,1)
        ENDIF
      ENDIF
      END


CDECK  ID>, PHO_DIFPAR
      SUBROUTINE PHO_DIFPAR(IMOTH1,IMOTH2,IGENM,IFL1,IFL2,IPAR,P1,P2,
     &                     IPOSH1,IPOSH2,IMODE,IREJ)
C***********************************************************************
C
C     perform string construction for diffraction dissociation
C
C     input:     IMOTH1,2     index of mother particles in POEVT1
C                IGENM        production process of mother particles
C                IFL1,IFL2    particle numbers
C                             (IDPDG,IDBAM for quasi-elas. hadron)
C                IPAR         0  quasi-elasic scattering
C                             1  single string configuration
C                             2  two string configuration
C                P1           massive 4 momentum of first
C                P1(6)        virtuality/squ.mass of particle (GeV**2)
C                P1(7)        virtuality of Pomeron (neg, GeV**2)
C                P2           massive 4 momentum of second particle
C                IMODE        1   diffraction dissociation
C                             2   double-pomeron scattering
C
C     output:    IPOSH1,2     index of the particles in /POEVT1/
C                IREJ         0  successful string construction
C                             1  no string construction possible
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      DIMENSION P1(7),P2(7)

      PARAMETER ( EPS  = 1.D-7,
     &            DEPS = 1.D-10)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  c.m. kinematics of diffraction
      INTEGER NPOSD
      DOUBLE PRECISION ECMD,PCMD,PMASSD,PVIRTD,GAMBED,
     &                 SIDD,CODD,SIFD,COFD,PDCMS
      COMMON /PODCMS/ ECMD,PCMD,PMASSD(2),PVIRTD(2),GAMBED(4),
     &                SIDD,CODD,SIFD,COFD,PDCMS(4,2),NPOSD(2)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)



      DIMENSION PCH1(2,4)
      DATA IC1 /0/
      DATA IC2 /0/

      IREJ = 0
      ILTR1 = NHEP+1
      IGEN = IGENM
      IF(IGENM.LE.-10) IGEN = 0

C  elastic part
      IF(IPAR.EQ.0) THEN
        IF((IFL1.EQ.92).OR.(IFL1.EQ.91)) THEN
          IF(IGEN.EQ.0) IGEN = 3
C  pi+/pi- isotropic background
          CALL PHO_REGPAR(1,IFL1,IFL2,IMOTH1,IMOTH2,
     &      P1(1),P1(2),P1(3),P1(4),0,IGEN,0,0,IPOSH1,1)
          CALL PHO_SDECAY(IPOSH1,0,-2)
        ELSE
          IF(IGEN.EQ.0) THEN
            IGEN = 2
            IF(IFL1.NE.IDHEP(IMOTH1)) IGEN = 3
          ENDIF
C  registration of particle or resonance
          CALL PHO_REGPAR(1,IFL1,IFL2,IMOTH1,IMOTH2,P1(1),P1(2),P1(3),
     &      P1(4),0,IGEN,0,0,IPOSH1,1)
        ENDIF

C  diffraction dissociation
      ELSE IF((IPAR.GE.1).AND.(IPAR.LE.18)) THEN
C  calculation of resulting particle momenta
        IF(IMOTH1.EQ.NPOSD(1)) THEN
          K = 2
        ELSE
          K = 1
        ENDIF
        DO 100 I=1,4
          PCH1(2,I) = PDCMS(I,K)-P2(I)
          PCH1(1,I) = P1(I)-PCH1(2,I)
 100    CONTINUE

C  registration
        IF(IMODE.LT.2) THEN
          IF(IGEN.EQ.0) IGEN = -IGENM/10+4
          CALL PHO_REGPAR(1,IFL1,IFL2,IMOTH1,IMOTH2,PCH1(1,1),
     &      PCH1(1,2),PCH1(1,3),PCH1(1,4),-1,IGEN,IC1,IC2,IPOSH1,1)
        ELSE
          IF(IGEN.EQ.0) IGEN = 4
        ENDIF
        CALL PHO_REGPAR(1,990,0,IMOTH2,IMOTH1,PCH1(2,1),PCH1(2,2),
     &    PCH1(2,3),PCH1(2,4),-1,IGEN,IC1,IC2,IPOSH2,1)

C  invalid IPAR
      ELSE
        WRITE(ErrorOut,
     * '(/1X,A,I6)') 'PHO_DIFPAR:ERROR: invalid IPAR:',IPAR
        CALL PHO_ABORT
      ENDIF

C  back transformation
      CALL PHO_LTRHEP(ILTR1,NHEP,CODD,SIDD,COFD,SIFD,GAMBED(4),
     &  GAMBED(1),GAMBED(2),GAMBED(3))

      END


CDECK  ID>, PHO_QELAST
      SUBROUTINE PHO_QELAST(IPROC,JM1,JM2,IREJ)
C**********************************************************************
C
C     sampling of quasi elastic processes
C
C     input:   IPROC  2   purely elastic scattering
C              IPROC  3   q-ela. omega/omega/phi/pi+pi- production
C              IPROC  4   double pomeron scattering
C              IPROC  -1  initialization
C              IPROC  -2  output of statistics
C              JM1/2      index of initial particle 1/2
C
C     output:  initial and final particles in /POEVT1/ involving
C              polarized resonances in /POEVT1/ and decay
C              products
C
C              IREJ    0  successful
C                      1  failure
C                     50  user rejection
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( NTAB = 20,
     &            EPS  = 1.D-10,
     &            PIMASS = 0.13D0,
     &            DEPS = 1.D-10)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  c.m. kinematics of diffraction
      INTEGER NPOSD
      DOUBLE PRECISION ECMD,PCMD,PMASSD,PVIRTD,GAMBED,
     &                 SIDD,CODD,SIFD,COFD,PDCMS
      COMMON /PODCMS/ ECMD,PCMD,PMASSD(2),PVIRTD(2),GAMBED(4),
     &                SIDD,CODD,SIFD,COFD,PDCMS(4,2),NPOSD(2)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)



      DOUBLE PRECISION P,PK1,PK2,PMI,RMASS
      DIMENSION   P(4,2),PK1(5),PK2(5),PMI(2),RMASS(2)
      DIMENSION   IFL(2),IDPRO(4)
      CHARACTER*15 PHO_PNAME
      CHARACTER*8  VMESA(0:4),VMESB(0:4)
      DIMENSION   ISAMVM(4,4)
      DATA IDPRO / 113,223,333,92 /
      DATA VMESA / 'VMESON  ','RHO     ','OMEGA   ','PHI     ',
     &             'PI+PI-  ' /
      DATA VMESB / 'VMESON  ','RHO     ','OMEGA   ','PHI     ',
     &             'PI+PI-  ' /

C  sampling of elastic/quasi-elastic processes
      IF((IPROC.EQ.2).OR.(IPROC.EQ.3)) THEN
        IREJ = 0
        NPOSD(1) = JM1
        NPOSD(2) = JM2
        DO 55 I=1,2
          PMI(I) = PHEP(5,NPOSD(I))
          IF(PMI(I).LT.0.1D0) PMI(I) = 0.765D0
 55     CONTINUE
C  get CM system
        PK1(1) = PHEP(1,JM1)+PHEP(1,JM2)
        PK1(2) = PHEP(2,JM1)+PHEP(2,JM2)
        PK1(3) = PHEP(3,JM1)+PHEP(3,JM2)
        PK1(4) = PHEP(4,JM1)+PHEP(4,JM2)
        SS = (PK1(4)+PK1(3))*(PK1(4)-PK1(3))-PK1(1)**2-PK1(2)**2
        ECMD = SQRT(SS)

        IF(ECMD.LE.PMI(1)+PMI(2)) THEN
          IF(IDEB(34).GE.3) WRITE(ErrorOut,'(1X,A,I12,3E12.4)')
     &      'PHO_QELAST: TOO SMALL MASS (EV,ECM,M1,M2)',KEVENT,
     &      ECMD,PMI
          IREJ = 5
          RETURN
        ENDIF

        DO 60 I=1,4
          GAMBED(I) = PK1(I)/ECMD
 60     CONTINUE
        CALL PHO_ALTRA(GAMBED(4),-GAMBED(1),-GAMBED(2),-GAMBED(3),
     &           PHEP(1,NPOSD(1)),PHEP(2,NPOSD(1)),PHEP(3,NPOSD(1)),
     &           PHEP(4,NPOSD(1)),PTOT1,PK1(1),PK1(2),PK1(3),PK1(4))
C  rotation angles
        CODD = PK1(3)/PTOT1
        SIDD = SQRT(PK1(1)**2+PK1(2)**2)/PTOT1
        COFD = 1.D0
        SIFD = 0.D0
        IF(PTOT1*SIDD.GT.1.D-5) THEN
          COFD = PK1(1)/(SIDD*PTOT1)
          SIFD = PK1(2)/(SIDD*PTOT1)
          ANORF = SQRT(COFD*COFD+SIFD*SIFD)
          COFD = COFD/ANORF
          SIFD = SIFD/ANORF
        ENDIF
C  get CM momentum
        AM12 = PMI(1)**2
        AM22 = PMI(2)**2
        PCMD = PHO_XLAM(SS,AM12,AM22)/(2.D0*ECMD)

C  production process of mother particles
        IGEN = IPHIST(2,NPOSD(1))
        IF(IGEN.EQ.0) IGEN = IPROC

        ICALL = ICALL + 1
C  main rejection label
 50     CONTINUE
C  determine process and final particles
        IFL(1) = IDHEP(NPOSD(1))
        IFL(2) = IDHEP(NPOSD(2))
        IF(IPROC.EQ.3) THEN
          ITRY = 0
 100      CONTINUE
          ITRY = ITRY+1
          IF(ITRY.GT.50) THEN
            IF(IDEB(34).GE.3) WRITE(ErrorOut,
     * '(1X,A,I12,I5,E12.4)')
     &        'PHO_QELAST: MASS REJECTION (EV,ITRY,ECM)',KEVENT,
     &        ITRY,ECMD
            IREJ = 5
            RETURN
          ENDIF
          XI = PHO_RNDM(PCMD)*SIGVM(0,0)-DEPS
          DO 110 I=1,4
            DO 120 J=1,4
              XI = XI-SIGVM(I,J)
              IF(XI.LE.0.D0) GOTO 130
 120        CONTINUE
 110      CONTINUE
 130      CONTINUE
          IF(IFL(1).EQ.22) IFL(1) = IDPRO(I)
          IF(IFL(2).EQ.22) IFL(2) = IDPRO(J)
          ISAMVM(I,J) = ISAMVM(I,J)+1
          ISAMQE = ISAMQE+1
C  sample new masses
          CALL PHO_SAMASS(IFL(1),RMASS(1))
          CALL PHO_SAMASS(IFL(2),RMASS(2))
          IF(RMASS(1)+RMASS(2).GE.ECMD) GOTO 100
        ELSE IF(IPROC.EQ.2) THEN
          I = 0
          J = 0
          ISAMEL = ISAMEL+1
          RMASS(1) = PHO_PMASS(NPOSD(1),2)
          RMASS(2) = PHO_PMASS(NPOSD(2),2)
        ELSE
          WRITE(ErrorOut,
     * '(/1X,A,I6)') 'PHO_QELAST:ERROR: invalid IPROC',IPROC
          CALL PHO_ABORT
        ENDIF
C  sample momentum transfer
        CALL PHO_DIFSLP(0,0,I,J,RMASS(1),RMASS(2),RMASS(1),TT,
     &    SLWGHT,IREJ)
        IF(IDEB(34).GE.5) WRITE(ErrorOut,'(1X,A,2I6,I3,3E11.3)')
     &    'PHO_QELAST: IF1,2,T,RM1,RM2',IFL,IPROC,TT,RMASS
C  calculate new momenta
        CALL PHO_DIFKIN(RMASS(1),RMASS(2),TT,PK1,PK2,IREJ)
        IF(IREJ.NE.0) GOTO 50
        DO K=1,4
          P(K,1) = PK1(K)
          P(K,2) = PK2(K)
        ENDDO
C  comment line for elastic/quasi-elastic scattering
        CALL PHO_REGPAR(35,IPROC,0,NPOSD(1),NPOSD(2),RMASS(1),RMASS(2),
     &    TT,ECMD,IFL(1),IFL(2),IDHEP(NPOSD(1)),IDHEP(NPOSD(2)),ICPOS,1)

        I1 = NHEP+1
C  fill /POEVT1/
        DO 200 I=1,2
          K = 3-I
          IF((IFL(I).EQ.92).OR.(IFL(I).EQ.91)) THEN
C  pi+/pi- isotropic background
            IGEN = 3
            CALL PHO_REGPAR(1,113,0,NPOSD(I),NPOSD(K),P(1,I),P(2,I),
     &        P(3,I),P(4,I),0,IGEN,0,0,IPOS,1)
            ICOLOR(I,ICPOS) = IPOS
            CALL PHO_SDECAY(IPOS,0,-2)
          ELSE
C  registration
            IGEN = 2
            IF(IFL(I).NE.IDHEP(NPOSD(I))) IGEN = 3
            CALL PHO_REGPAR(1,IFL(I),0,NPOSD(I),NPOSD(K),P(1,I),P(2,I),
     &        P(3,I),P(4,I),0,IGEN,0,0,IPOS,1)
            ICOLOR(I,ICPOS) = IPOS
          ENDIF
 200    CONTINUE
        I2 = NHEP
C  search for vector mesons
        DO 300 I=I1,I2
C  decay according to polarization
          IF((IDHEP(JMOHEP(1,I)).EQ.22).AND.(ISWMDL(21).GE.0)) THEN
            ISP = IPAMDL(3)
            IF(ISWMDL(21).GE.1) ISP = IPAMDL(4)
            CALL PHO_SDECAY(I,ISP,2)
          ENDIF
 300    CONTINUE
        I2 = NHEP
C  back transformation
        CALL PHO_LTRHEP(I1,I2,CODD,SIDD,COFD,SIFD,GAMBED(4),GAMBED(1),
     &              GAMBED(2),GAMBED(3))

C  initialization of tables
      ELSE IF(IPROC.EQ.-1) THEN
        DO 10 I=1,4
          DO 20 J=1,4
            ISAMVM(I,J) = 0
 20       CONTINUE
 10     CONTINUE
        ISAMEL = 0
        ISAMQE = 0
        IF(IFPAP(1).NE.22) VMESA(1) = PHO_PNAME(IFPAP(1),1)
        IF(IFPAP(2).NE.22) VMESB(1) = PHO_PNAME(IFPAP(2),1)
        CALL PHO_SAMASS(-1,RMASS(1))
        ICALL = 0

C  output of statistics
      ELSE IF(IPROC.EQ.-2) THEN
        IF(ICALL.LT.10) RETURN
        WRITE(ErrorOut,'(/,1X,A,I10/,1X,A)')
     &    'PHO_QELAST: STATISTICS OF (QUASI-)ELASTIC PROCESSES',ICALL,
     &    '---------------------------------------------------'
        WRITE(ErrorOut,'(1X,A,I10)')
     &    'SAMPLED ELASTIC PROCESSES:',ISAMEL
        WRITE(ErrorOut,'(1X,A,I10)')
     &    'SAMPLED QUASI-ELASTIC VECTORMESON PRODUCTION:',ISAMQE
        WRITE(ErrorOut,'(15X,4(4X,A))') (VMESB(I),I=1,4)
        DO 30 I=1,4
          WRITE(ErrorOut,
     * '(5X,A,4I12)') VMESA(I),(ISAMVM(I,K),K=1,4)
 30     CONTINUE
        CALL PHO_SAMASS(-2,RMASS(1))
      ELSE
        WRITE(ErrorOut,'(/1X,2A,I3)') 'PHO_QELAST:ERROR: ',
     &    'UNKNOWN PROCESS ID',IPROC
        CALL PHO_ABORT
      ENDIF

      END


CDECK  ID>, PHO_CDIFF
      SUBROUTINE PHO_CDIFF(IMOTH1,IMOTH2,MSOFT,MHARD,IMODE,IREJ)
C**********************************************************************
C
C     preparation of /POEVT1/ for double-pomeron scattering
C
C     input:   IMOTH1/2   index of mother particles in /POEVT1/
C
C              IMODE   1  sampling of pomeron-pomeron scattering
C                     -1  initialization
C                     -2  output of statistics
C
C     output:   MSOFT     number of generated soft strings
C               MHARD     number of generated hard strings
C               IREJ      0  accepted
C                         1  rejected
C                        50  user rejection
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( EPS  = 1.D-10,
     &            DEPS = 1.D-10)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  parameters of 2x2 channel model
      DOUBLE PRECISION PHISUP,RMASS,VAR,AMPFAC,ELAFAC,VFAC
      COMMON /PO2CHA/ PHISUP(2),RMASS(2),VAR,AMPFAC(4),ELAFAC(4),VFAC

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX

C  table of particle indices for recursive PHOJET calls
      INTEGER MAXIPX
      PARAMETER ( MAXIPX = 100 )
      INTEGER IPOPOS,IPORES,IPOIX1,IPOIX2,IPOIX3
      COMMON /PORECU/ IPOPOS(2,MAXIPX),IPORES(MAXIPX),
     &                IPOIX1,IPOIX2,IPOIX3


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)



      DIMENSION PD(4)


      IF(IMODE.NE.1) RETURN

      IREJ = 0
      IP = 4
C  select first diffraction
      IF(PHO_RNDM(DUM).GT.0.5D0) THEN
        IPAR1 = 1
        IPAR2 = 0
      ELSE
        IPAR1 = 0
        IPAR2 = 1
      ENDIF
      ITRY2 = 0
      ITRYM = 1000

C  save current status
      MSOFT = 0
      MHARD = 0
      KHPOMS = KHPOM
      KSPOMS = KSPOM
      KSREGS = KSREG
      KHDIRS = KHDIR
      IPOIS1 = IPOIX1
      IPOIS2 = IPOIX2
      IPOIS3 = IPOIX3
      JDA11 = JDAHEP(1,IMOTH1)
      JDA21 = JDAHEP(2,IMOTH1)
      JDA12 = JDAHEP(1,IMOTH2)
      JDA22 = JDAHEP(2,IMOTH2)
      ISTH1 = ISTHEP(IMOTH1)
      ISTH2 = ISTHEP(IMOTH2)
      NHEPS = NHEP

C  find mother particle production process
      IGEN = IPHIST(2,IMOTH1)
      IF(IGEN.EQ.0) IGEN = 4

C  main generation loop
 60   CONTINUE

      KSPOM = KSPOMS
      KHPOM = KHPOMS
      KHDIR = KHDIRS
      KSREG = KSREGS
      I1 = IPAR1
      I2 = IPAR2
C  reset mother-daugther relations
      NHEP = NHEPS
      JDAHEP(1,IMOTH1) = JDA11
      JDAHEP(2,IMOTH1) = JDA21
      JDAHEP(1,IMOTH2) = JDA12
      JDAHEP(2,IMOTH2) = JDA22
      ISTHEP(IMOTH1) = ISTH1
      ISTHEP(IMOTH2) = ISTH2
      IPOIX1 = IPOIS1
      IPOIX2 = IPOIS2
      IPOIX3 = IPOIS3
C  rejection counter
      ITRY2 = ITRY2+1
      IF(ITRY2.GT.1) THEN
        IFAIL(39) = IFAIL(39)+1
        IF(ITRY2.GE.ITRYM) GOTO 50
      ENDIF
C  generate two diffractive events
      CALL PHO_DIFDIS(I1,I2,IMOTH1,IMOTH2,1.D0,2,MSOFT,MHARD,IREJ)
      IF(IREJ.NE.0) GOTO 50
      CALL PHO_DIFDIS(I2,I1,IMOTH1,IMOTH2,1.D0,2,MSOFT,MHARD,IREJ)
      IF(IREJ.NE.0) GOTO 50
C  mass of pomeron-pomeron system
      DO 100 I2 = NHEP,1,-1
        IF(IDHEP(I2).EQ.990) GOTO 110
 100  CONTINUE
 110  CONTINUE
      DO 120 I1 = I2-1,1,-1
        IF(IDHEP(I1).EQ.990) GOTO 130
 120  CONTINUE
 130  CONTINUE
      DO 140 I=1,4
        PD(I) = PHEP(I,I1)+PHEP(I,I2)
 140  CONTINUE
      XMASS = (PD(4)-PD(3))*(PD(4)+PD(3))-PD(1)**2-PD(2)**2
      IF(IDEB(59).GE.20) WRITE(ErrorOut,'(1X,A,2I3,E12.4)')
     &  'PHO_CDIFF: IPOM1,IPOM2,MASS**2',I1,I2,XMASS
      IF(XMASS.LT.0.1D0) GOTO 60
      XMASS = SQRT(XMASS)
      IF(XMASS.LT.PARMDL(71)) GOTO 60

C  sample pomeron-pomeron interaction process
      CALL PHO_DIFPRO(4,ISWMDL(17),990,990,XMASS,0.D0,0.D0,1.D0,
     &            IPROC,ISAM,JSAM,KSAM,IDIR)

C  non-diffractive pomeron-pomeron interactions
      IF((IPROC.EQ.1).OR.(IPROC.EQ.8)) THEN
 200    CONTINUE
        IF(ISAM+JSAM+KSAM+IDIR.EQ.0) JSAM = 1
C  debug output
        IF(IDEB(59).GE.15) WRITE(ErrorOut,
     * '(1X,A,/5X,I3,E12.4,4I5)')
     &    'PHO_CDIFF: IP,XMASS,ISAM,JSAM,KSAM,IDIR,',
     &    IP,XMASS,ISAM,JSAM,KSAM,IDIR
C  store debug information
        IF(IDIR.GT.0) THEN
          IPAR = 4
        ELSE IF(KSAM.GT.0) THEN
          IPAR = 3
        ELSE IF(ISAM.GT.0) THEN
          IPAR = 2
        ELSE
          IPAR = 1
        ENDIF
        IDDPOM = IPAR
        IF(ISAM+JSAM.GT.0) KSDPO = 1
        IF(KSAM+IDIR.GT.0) KHDPO = 1
        KSPOM = ISAM
        KSREG = JSAM
        KHPOM = KSAM
        KHDIR = IDIR
        KSTRG = 0
        KSLOO = 0
C  generate pomeron-pomeron interaction
        CALL PHO_STDPAR(I1,I2,IGEN,ISAM,JSAM,KSAM,IDIR,IREJ)
        IF(IREJ.NE.0) THEN
          IFAIL(3) = IFAIL(3)+1
          IF(IPAR.GT.1) THEN
            IF(IPAR.EQ.3) IFAIL(9) = IFAIL(9)+1
            IF(IDIR.GT.0) THEN
              IFAIL(10) = IFAIL(10)+1
              IDIR = 0
            ELSE IF(KSAM.GT.0) THEN
              KSAM = KSAM-1
            ELSE IF(ISAM.GT.0) THEN
              ISAM = ISAM-1
            ENDIF
            GOTO 200
          ELSE
            IF(IDEB(59).GE.2) WRITE(ErrorOut,'(1X,A,2I3,E11.3)')
     &        'PHO_CDIFF: REJECTION BY PHO_STDPAR (I,IPAR,XM)',
     &        I,IPAR,XMASS
            GOTO 50
          ENDIF
        ENDIF

C  diffractive pomeron-pomeron interactions
      ELSE
        IPOIX2 = IPOIX2+1
        IPORES(IPOIX2)   = IPROC
        IPOPOS(1,IPOIX2) = I1
        IPOPOS(2,IPOIX2) = I2
        IPAR = 10+IPROC
        IDDPOM = IPAR
      ENDIF

C  update debug information
      KSPOM = KSPOMS+ISAM
      KSREG = KSREGS+JSAM
      KHPOM = KHPOMS+KSAM
      KHDIR = KHDIRS+IDIR
C  comment line for central diffraction
      CALL PHO_REGPAR(40,4,IPAR,IMOTH1,IMOTH2,PD(1),PD(2),PD(3),PD(4),
     &            I1,I2,IDHEP(IMOTH1),IDHEP(IMOTH2),IPOS,1)
      PHEP(5,IPOS) = XMASS
C  debug output
      IF(IDEB(59).GE.15) THEN
        WRITE(ErrorOut,
     * '(2(/1X,A))') 'PHO_CDIFF: output of /POEVT1/',
     &                        '-----------------------------'
        CALL PHO_PREVNT(0)
      ENDIF
      RETURN

C  treatment of rejection
 50   CONTINUE
      IREJ = 1
      IFAIL(40) = IFAIL(40)+1
      IF(IDEB(59).GE.3) THEN
        WRITE(ErrorOut,'(1X,A)')
     &    'PHO_CDIFF: REJECTION (ITRY,ITRYM)',ITRY2,ITRYM
        IF(IDEB(59).GE.10) THEN
          CALL PHO_PREVNT(0)
        ELSE
          CALL PHO_PREVNT(-1)
        ENDIF
      ENDIF

      END



CDECK  ID>, PHO_SAMASS
      SUBROUTINE PHO_SAMASS(IFLA,RMASS)
C**********************************************************************
C
C     resonance mass sampling of quasi elastic processes
C
C     input:   IFLA       PDG number of particle
C              IFLA   -1  initialization
C              IFLA   -2  output of statistics
C
C     output:  RMASS      particle mass (in GeV)
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER(EPS  = 1.D-10 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  parameters of the "simple" Vector Dominance Model
      DOUBLE PRECISION VMAS,GAMM,RMIN,RMAX,VMSL,VMFA
      COMMON /POSVDM/ VMAS(4),GAMM(4),RMIN(4),RMAX(4),VMSL(4),VMFA(4)




      PARAMETER(NTABM=50)
      DIMENSION XMA(4,NTABM),XMC(4,NTABM),RMA(4,NTABM)
      DIMENSION SUM(4),ICALL(4)

C*****************************************************************
C  initialization of tables
      IF(IFLA.EQ.-1) THEN
C
        NSTEP = NTABM
        DO 102 I=1,4
          ICALL(I) = 0

          DELTAM=(RMAX(I)-RMIN(I))/DBLE(NSTEP-1)
          DO 105 K=1,NSTEP
            RMA(I,K)=RMIN(I)+DELTAM*DBLE(K-1)
 105      CONTINUE
 102    CONTINUE
C  calculate table of dsig/dm
        CALL PHO_DSIGDM(RMA,XMA,NSTEP)
C  output of table
        IF(IDEB(35).GE.1) THEN
          WRITE(ErrorOut,
     * '(/5X,A)') 'table:   mass (GeV)  DSIG/DM (mub/GeV)'
          WRITE(ErrorOut,'(1X,A,/1X,A)')
     &      '  (M,  RHO,     M,  OMEGA,      M,   PHI,    M,  PI+PI-)',
     &      ' -------------------------------------------------------'
          DO 106 K=1,NSTEP
            WRITE(ErrorOut,'(1X,8E12.3)') RMA(1,K),XMA(1,K),
     &        RMA(2,K),XMA(2,K),RMA(3,K),XMA(3,K),RMA(4,K),XMA(4,K)
 106      CONTINUE
        ENDIF
C  make second table for sampling
        DO 109 I=1,4
          SUM(I) = 0.D0
          DO 108 K=2,NSTEP
            SUM(I) = SUM(I) + (XMA(I,K-1)+XMA(I,K))/2.D0
            XMC(I,K) = SUM(I)
 108      CONTINUE
 109    CONTINUE
C  normalization
        DO 118 K=1,NSTEP
          DO 119 I=1,4
            XMC(I,K) = XMC(I,K)/XMC(I,NSTEP)
 119      CONTINUE
 118    CONTINUE
        IF(IDEB(35).GE.10) THEN
          WRITE(ErrorOut,
     * '(/5X,A)') 'PHO_DSIGDM: normalized summed table:'
          WRITE(ErrorOut,'(1X,A,/1X,A)')
     &      '  (M,  RHO,     M,  OMEGA,      M,   PHI,    M,  PI+PI-)',
     &      ' -------------------------------------------------------'
          DO 120 K=1,NSTEP
            WRITE(ErrorOut,'(1X,8E12.3)') RMA(1,K),XMC(1,K),
     &        RMA(2,K),XMC(2,K),RMA(3,K),XMC(3,K),RMA(4,K),XMC(4,K)
 120      CONTINUE
        ENDIF
C
C**************************************************
C  output of statistics
      ELSE IF(IFLA.EQ.-2) THEN
        WRITE(ErrorOut,'(2(/1X,A))') 'PHO_SAMASS: statistics',
     &                        '----------------------'
        WRITE(ErrorOut,'(4(/8X,A,I10))') 'rho:   ',ICALL(1),
     &    'OMEGA: ',ICALL(2),'PHI:   ',ICALL(3),'PI+PI-:',ICALL(4)

C
C********************************************************
C  sampling of RMASS
      ELSE
C  quasi-elastic vector meson production
        IF(IFLA.EQ.113) THEN
          KP = 1
        ELSE IF(IFLA.EQ.223) THEN
          KP = 2
        ELSE IF(IFLA.EQ.333) THEN
          KP = 3
        ELSE IF(IFLA.EQ.92) THEN
          KP = 4
C  quasi-elastic production of h*
        ELSE IF(IFLA.EQ.91) THEN
          RMASS = 0.35D0
          RETURN
C  elastic hadron scattering
        ELSE
          RMASS = PHO_PMASS(IFLA,1)
          IF(IDEB(35).GE.20) WRITE(ErrorOut,'(1X,A,I7,E12.3)')
     &      'PHO_SAMASS: IFLA,MASS',IFLA,RMASS
          RETURN
        ENDIF
C
C  sample mass of vector mesonsn / two-pi background
        XI = PHO_RNDM(RMASS) + EPS
C  binary search
        IF((XMC(KP,1).LE.XI).AND.(XMC(KP,NSTEP).GE.XI)) THEN
          KMIN=1
          KMAX=NSTEP
 300      CONTINUE
          IF((KMAX-KMIN).EQ.1) GOTO 400
          KK=(KMAX+KMIN)/2
          IF(XI.LE.XMC(KP,KK)) THEN
            KMAX=KK
          ELSE
            KMIN=KK
          ENDIF
          GOTO 300
 400      CONTINUE
        ELSE
          WRITE(ErrorOut,
     * '(1X,A)') 'PHO_SAMASS:ERROR:XI out of range'
          WRITE(ErrorOut,
     * '(5X,A,I7,I6,3E12.4)') 'EVENT,IFLA,XI,XImin,XImax',
     &      KEVENT,IFLA,XI,XMC(KP,1),XMC(KP,NSTEP)
          CALL PHO_ABORT
        ENDIF
C  fine interpolation
        RMASS = RMA(KP,KMIN)+
     &          (RMA(KP,KMAX)-RMA(KP,KMIN))/
     &          (XMC(KP,KMAX)-XMC(KP,KMIN))
     &          *(XI-XMC(KP,KMIN))
        IF(IDEB(35).GE.20) THEN
          IF(IDEB(35).GE.25) WRITE(ErrorOut,'(1X,A,3E15.3)')
     &      'PHO_SAMASS: MLEFT,MRIGHT,RMASS',
     &      RMA(KP,KMIN),RMA(KP,KMAX),RMASS
          WRITE(ErrorOut,
     * '(1X,A,I7,E12.3)') 'PHO_SAMASS: IFLA,MASS',
     &      IFLA,RMASS
        ENDIF
        ICALL(KP) = ICALL(KP)+1

      ENDIF
      END




CDECK  ID>, PHO_DSIGDM
      SUBROUTINE PHO_DSIGDM(RMA,XMA,NSTEP)
C**********************************************************************
C
C     differential cross section DSIG/DM of low mass enhancement
C
C     input:   RMA(4,NTABM)   mass values
C     output:  XMA(4,NTABM)   DSIG/DM of resonances
C                  1          rho production
C                  2          omega production
C                  3          phi production
C                  4          pi-pi continuum
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER ( EPS  = 1.D-10 )

      PARAMETER(NTABM=50)
      DIMENSION XMA(4,NTABM),RMA(4,NTABM)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  parameters of the "simple" Vector Dominance Model
      DOUBLE PRECISION VMAS,GAMM,RMIN,RMAX,VMSL,VMFA
      COMMON /POSVDM/ VMAS(4),GAMM(4),RMIN(4),RMAX(4),VMSL(4),VMFA(4)


      PIMASS = 0.135
C  rho meson shape (mass dependent width)
      QRES = SQRT(VMAS(1)**2 - 4.D0*PIMASS**2)
      DO 100 I=1,NSTEP
        XMASS = RMA(1,I)
        QQ = SQRT(XMASS**2 - 4.D0*PIMASS**2)
        GAMMA = GAMM(1)*(QQ/QRES)**3
**sr 6.3.01: bugfix again implemented
C       XMA(1,I) = XMASS*GAMMA*(XMASS/VMAS(1))**PARMDL(170)
        XMA(1,I) = XMASS*GAMMA*(VMAS(1)/XMASS)**PARMDL(170)
**
     &             /((VMAS(1)**2-XMASS**2)**2+VMAS(1)**2*GAMMA**2)
 100  CONTINUE
C  omega/phi meson (constant width)
      DO 200 K=2,3
        DO 300 I=1,NSTEP
          XMASS = RMA(K,I)
          XMA(K,I) = XMASS*GAMM(K)
     &               /((VMAS(K)**2-XMASS**2)**2+VMAS(K)**2*GAMM(K)**2)
 300    CONTINUE
 200  CONTINUE
C  pi-pi continuum
      DO 400 I=1,NSTEP
        XMASS = RMA(4,I)
        XMA(4,I) = (XMASS-0.29D0)**2/XMASS
 400  CONTINUE

      END
#endif
