#include "Zcondc.h"
#if USEDPMJET == 1
CDECK  ID>, PHO_IMPAMP
      SUBROUTINE PHO_IMPAMP(EE,BMIN,BMAX,NSTEP)
C*********************************************************************
C
C     calculation of physical  impact parameter amplitude
C
C     input:   EE      cm energy (GeV)
C              BMIN    lower bound in B
C              BMAX    upper bound in B
C              NSTEP   number of values (linear)
C
C     output:  values written to output unit
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER(ONEM=-1.D0,
     &         THOUS=1.D3,
     &          DEPS=1.D-20)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  complex Born graph amplitudes used for unitarization
      COMPLEX*16      AMPEL,AMPVM,AMPSOF,AMPHAR,AMLMSD,AMHMSD,AMLMDD,
     &                AMHMDD,AMPDP
      COMMON /POINT4/ AMPEL,AMPVM(4,4),AMPSOF,AMPHAR,AMLMSD(2),
     &                AMHMSD(2),AMLMDD,AMHMDD,AMPDP(4)


      ECM=EE
      BSTEP = (BMAX-BMIN)/DBLE(NSTEP-1)
C
      WRITE(ErrorOut,'(3(/,1X,A))')
     &  'IMPACT PARAMETER AMPLITUDES:',
     &  '  B  AMP-EL  AMP-LMSD(1,2)  AMP-HMSD(1,2)  AMP-LMDD  AMP-HMDD',
     &  '-------------------------------------------------------------'
C
      BB = BMIN
      DO 100 I=1,NSTEP
C  calculate impact parameter amplitudes
        IF(I.EQ.1) THEN
          CALL PHO_EIKON(1,-1,BMIN)
        ELSE
          CALL PHO_EIKON(1,1,BB)
        ENDIF
        WRITE(ErrorOut,'(1X,8E12.4)') BB,DREAL(AMPEL),
     &    DREAL(AMLMSD(1)),DREAL(AMLMSD(2)),
     &    DREAL(AMHMSD(1)),DREAL(AMHMSD(2)),DREAL(AMLMDD),DREAL(AMHMDD)
        BB = BB+BSTEP
 100  CONTINUE

      END


CDECK  ID>, PHO_PRBDIS
      SUBROUTINE PHO_PRBDIS(IP,ECM,IE, icon)   ! &&&&&&&&& kk
C*********************************************************************
C
C     calculation of multi interactions probabilities
C
C     input:  IP        particle combination to scatter
C             ECM       CMS energy
C             IE        index for weight storing
C             /PROBAB/
C             IMAX      max. number of soft pomeron interactions
C             KMAX      max. number of hard pomeron interactions
C
C     output: /PROBAB/
C             PROB      field of probabilities
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
ccc    &&& KK
       integer icon   ! output.if non 0, neg.cross-section happened
ccc 
      PARAMETER ( EPS=1.D-10 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  parameters of 2x2 channel model
      DOUBLE PRECISION PHISUP,RMASS,VAR,AMPFAC,ELAFAC,VFAC
      COMMON /PO2CHA/ PHISUP(2),RMASS(2),VAR,AMPFAC(4),ELAFAC(4),VFAC

C  Born graph cross sections and slopes
      INTEGER MAX_PRO_3
      PARAMETER ( MAX_PRO_3 = 16 )
      COMPLEX*16      SIGP,SIGR,SIGHD,SIGHR,SIGT1,SIGT2,SIGL,SIGDP,
     &                SIGD1,SIGD2,DSIGH
      COMMON /POSBRN/ SIGP,SIGR,SIGHD,SIGHR,SIGT1(2),SIGT2(2),SIGL,
     &                SIGDP(4),SIGD1(2),SIGD2(2),DSIGH(0:MAX_PRO_3)

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  Born graph cross sections after applying diffraction model
      DOUBLE PRECISION SBOPOM,SBOREG,SBOHAR,SBOHAD,SBOTR1,SBOTR2,
     &                 SBOLPO,SBODPO
      COMMON /POINT1/ SBOPOM(0:4),SBOREG(0:4),SBOHAR(0:4),SBOHAD(0:4),
     &                SBOTR1(0:4,2),SBOTR2(0:4,2),SBOLPO(0:4),
     &                SBODPO(0:4,4)

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL

C  cut probability distribution
      INTEGER IEETA1,IIMAX,KKMAX
      PARAMETER( IEETA1=20, IIMAX=20, KKMAX=20 )
      INTEGER IEEMAX,IMAX,KMAX
      REAL PROB
      DOUBLE PRECISION EPTAB
      COMMON /POPROB/ PROB(4,IEETA1,0:IIMAX,0:KKMAX),EPTAB(4,IEETA1),
     &                IEEMAX,IMAX,KMAX

C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX

C  average number of cut soft and hard ladders (obsolete)
      DOUBLE PRECISION AVERI,AVERK,AVERL,AVERM,AVERN
      COMMON /POINT2/ AVERI,AVERK,AVERL,AVERM,AVERN

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  integration precision for hard cross sections (obsolete)
      INTEGER NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO
      COMMON /POGAUP/ NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  unitarized amplitudes for different diffraction channels
      DOUBLE PRECISION ZXP,BXP,ZXR,BXR,ZXH,BXH,ZXD,BXD,
     &                 ZXT1A,BXT1A,ZXT1B,BXT1B,ZXT2A,BXT2A,ZXT2B,BXT2B,
     &                 ZXDPE,BXDPE,ZXDPA,BXDPA,ZXDPB,BXDPB,ZXDPD,BXDPD,
     &                 ZXL,BXL
      COMMON /POINT5/ ZXP(4,4),BXP(4,4),ZXR(4,4),BXR(4,4),
     &                ZXH(4,4),BXH(4,4),ZXD(4,4),BXD(4,4),
     &                ZXT1A(4,4),BXT1A(4,4),ZXT1B(4,4),BXT1B(4,4),
     &                ZXT2A(4,4),BXT2A(4,4),ZXT2B(4,4),BXT2B(4,4),
     &                ZXDPE(4,4),BXDPE(4,4),ZXDPA(4,4),BXDPA(4,4),
     &                ZXDPB(4,4),BXDPB(4,4),ZXDPD(4,4),BXDPD(4,4),
     &                ZXL(4,4),BXL(4,4)


C  local variables
      DIMENSION  AB(4,4),CHI2(4),ABSUM2(4,4),ABSTMP(4),CHITMP(4)
      PARAMETER (ICHMAX=40)
      DIMENSION CHIFAC(4,4),AMPCOF(4)
      DIMENSION PCHAIN(2,ICHMAX),XPNT(96),WGHT(96)
      DIMENSION FACLOG(0:30),PSOFT(0:30),PHARD(0:30)

C  combinatorical factors
      DATA      CHIFAC / 1.D0, 1.D0,-1.D0,-1.D0,
     &                   1.D0,-1.D0, 1.D0,-1.D0,
     &                   1.D0,-1.D0,-1.D0, 1.D0,
     &                   1.D0, 1.D0, 1.D0, 1.D0 /

      DATA FACLOG /           .000000000000000D+00,
     &  .000000000000000D+00, .693147180559945D+00,
     &  .109861228866811D+01, .138629436111989D+01,
     &  .160943791243410D+01, .179175946922805D+01,
     &  .194591014905531D+01, .207944154167984D+01,
     &  .219722457733622D+01, .230258509299405D+01,
     &  .239789527279837D+01, .248490664978800D+01,
     &  .256494935746154D+01, .263905732961526D+01,
     &  .270805020110221D+01, .277258872223978D+01,
     &  .283321334405622D+01, .289037175789616D+01,
     &  .294443897916644D+01, .299573227355399D+01,
     &  .304452243772342D+01, .309104245335832D+01,
     &  .313549421592915D+01, .317805383034795D+01,
     &  .321887582486820D+01, .325809653802148D+01,
     &  .329583686600433D+01, .333220451017520D+01,
     &  .336729582998647D+01, .340119738166216D+01 /

      DATA  ELAST / 0.D0 /
      DATA  IPLAST / 0 /

C  test for redundant calculation: skip cs calculation
      IF((ECM.NE.ELAST).OR.(IP.NE.IPLAST)) THEN
        ELAST = ECM
        IPLAST = IP
        CALL PHO_XSECT(IP,0,ELAST)
        ISIMAX = IE
        SIGECM(IP,IE) = ECM
        SIGTAB(IP,1,IE) = SIGTOT
        SIGTAB(IP,2,IE) = SIGELA
        J = 2
        DO 5 I=0,4
          DO 6 K=0,4
            J = J+1
            SIGTAB(IP,J,IE) = SIGVM(I,K)
 6        CONTINUE
 5      CONTINUE
        SIGTAB(IP,28,IE) = SIGINE
        SIGTAB(IP,29,IE) = SIGDIR
        SIGTAB(IP,30,IE) = SIGLSD(1)
        SIGTAB(IP,31,IE) = SIGLSD(2)
        SIGTAB(IP,32,IE) = SIGHSD(1)
        SIGTAB(IP,33,IE) = SIGHSD(2)
        SIGTAB(IP,34,IE) = SIGLDD
        SIGTAB(IP,35,IE) = SIGHDD
        SIGTAB(IP,36,IE) = SIGCDF(0)
        SIGTAB(IP,37,IE) = SIG1SO
        SIGTAB(IP,38,IE) = SIG1HA
        SIGTAB(IP,39,IE) = SLOEL
        J = 39
        DO 7 I=1,4
          DO 8 K=1,4
            J = J+1
            SIGTAB(IP,J,IE) = SLOVM(I,K)
 8        CONTINUE
 7      CONTINUE
        SIGTAB(IP,56,IE) = SIGPOM
        SIGTAB(IP,57,IE) = SIGREG
        SIGTAB(IP,58,IE) = SIGHAR
        SIGTAB(IP,59,IE) = SIGDIR
        SIGTAB(IP,60,IE) = SIGTR1(1)
        SIGTAB(IP,61,IE) = SIGTR1(2)
        SIGTAB(IP,62,IE) = SIGTR2(1)
        SIGTAB(IP,63,IE) = SIGTR2(2)
        SIGTAB(IP,64,IE) = SIGLOO
        SIGTAB(IP,65,IE) = SIGDPO(1)
        SIGTAB(IP,66,IE) = SIGDPO(2)
        SIGTAB(IP,67,IE) = SIGDPO(3)
        SIGTAB(IP,68,IE) = SIGDPO(4)

C  consistency check
        SIGNDF = SIGTOT-SIGELA-SIGVM(0,0)-SIGCDF(0)-SIGDIR
     &          -SIGLSD(1)-SIGHSD(1)-SIGLSD(2)-SIGHSD(2)
     &          -SIGLDD-SIGHDD

        IF(SIGNDF.LE.0.D0) THEN
          WRITE(ErrorOut,'(//1X,A,/)')
     &      'PHO_PRBDIS:ERROR: NEG.CROSS SECTION FOR UNITARIZATION!'
          WRITE(ErrorOut,'(1X,A,I3,1P,2E12.4)')
     &      'PHO_PRBDIS: IP,ECM,SIGNDF:',IP,ECM,SIGNDF
          WRITE(ErrorOut,'(4X,A,/1P,8E10.3)')
     &'(SIGTOT,SIGELA,SIGVM,SIGCDF,SIGDIR,SIGLSD(1),SIGLSD(2),SIGLDD):',
     &      SIGTOT,SIGELA,SIGVM(0,0),SIGCDF(0),SIGDIR,SIGLSD(1),
     &      SIGLSD(2),SIGLDD
ccc         &&&&&&&&&& KK
          write(ErrorOut,*)
     *    'This is happening for pi,K > 2x10^18 eV; so we regards'
          write(ErrorOut,*)
     *    'the cross.sec is the same as previous value '
c         STOP          
          icon = 1
          return
ccc       &&&&&&&&
        ENDIF
ccc       &&&&&&&&& KK
        icon = 0
ccc       &&&&&&&&


        IF((IDEB(55).GE.2).AND.(IP.EQ.1)) THEN
          PRINT *,'------------------------------------------------'
          PRINT *,'IP,ECM:',IP,ECM
          PRINT *,'SIGTOT:',SIGTOT
          PRINT *,'SIGELA:',SIGELA
          PRINT *,'SIGVM :',SIGVM(0,0)
          PRINT *,'SIGCDF:',SIGCDF(0)
          PRINT *,'SIGDIR:',SIGDIR
          PRINT *,'SIGLSD:',SIGLSD
          PRINT *,'SIGHSD:',SIGHSD
          PRINT *,'SIGLDD:',SIGLDD
          PRINT *,'SIGHDD:',SIGHDD
          PRINT *,'SIGNDF:',SIGNDF

          PRINT *,'SIGPOM:',SIGPOM
          PRINT *,'SIGREG:',SIGREG
          PRINT *,'SIGHAR:',SIGHAR
          PRINT *,'SIGDIR:',SIGDIR
          PRINT *,'SIGTR1:',SIGTR1
          PRINT *,'SIGTR2:',SIGTR2
          PRINT *,'SIGLOO:',SIGLOO
          PRINT *,'SIGDPO:',SIGDPO
          PRINT *,'SIG1SO:',SIG1SO
          PRINT *,'SIG1HA:',SIG1HA
        ENDIF

        SIGTAB(IP,77,IE) = PTCUT(IP)
        SIGTAB(IP,78,IE) = SIGNDF

        AUXFAC = PI2/SIGNDF
        IF(ISWMDL(1).EQ.3) THEN
          DO 133 I=1,4
            AMPCOF(I) = 0.D0
            DO 135 K=1,4
              AMPCOF(I) = AMPCOF(I) + 0.25D0*ELAFAC(K)*CHIFAC(K,I)
 135        CONTINUE
            AMPCOF(I) = AMPCOF(I)*AUXFAC
 133      CONTINUE
        ENDIF
C
*       BMAX=5.D0*SQRT(DBLE(BPOM))
        BMAX=10.D0
        EPTAB(IP,IE) = ECM
        CALL PHO_GAUSET(0.D0,BMAX,NGAUSO,XPNT,WGHT)
C
      ENDIF
C
      DO 160 K=0,KMAX
        DO 170 I=0,IMAX
          PROB(IP,IE,I,K) = 0.D0
 170    CONTINUE
 160  CONTINUE
      DO 120 I=1,ICHMAX
        PCHAIN(1,I) = 0.D0
        PCHAIN(2,I) = 0.D0
 120  CONTINUE
C
C  main cross section loop
C**********************************************************
      DO 5000 IB=1,NGAUSO
        B24=XPNT(IB)**2/4.D0
        FAC = XPNT(IB)*WGHT(IB)
C
        IF((ISWMDL(1).EQ.3).OR.(ISWMDL(1).EQ.4)) THEN
C
C  amplitude construction
          DO 525 I=1,4
            AB(1,I)=ZXP(1,I)*EXP(-B24/BXP(1,I))
     &              +ZXR(1,I)*EXP(-B24/BXR(1,I))
            AB(2,I)=ZXH(1,I)*EXP(-B24/BXH(1,I))
            AB(3,I)=-ZXT1A(1,I)*EXP(-B24/BXT1A(1,I))
     &              -ZXT1B(1,I)*EXP(-B24/BXT1B(1,I))
     &              -ZXT2A(1,I)*EXP(-B24/BXT2A(1,I))
     &              -ZXT2B(1,I)*EXP(-B24/BXT2B(1,I))
     &              -ZXL(1,I)*EXP(-B24/BXL(1,I))
            AB(4,I)=ZXDPE(1,I)*EXP(-B24/BXDPE(1,I))
     &              +ZXDPA(1,I)*EXP(-B24/BXDPA(1,I))
     &              +ZXDPB(1,I)*EXP(-B24/BXDPB(1,I))
     &              +ZXDPD(1,I)*EXP(-B24/BXDPD(1,I))
            AB(1,I) = AB(1,I)+AB(3,I)+AB(4,I)
            AB(2,I) = AB(2,I)
            AB(3,I) = 0.D0
            AB(4,I) = 0.D0
*
 525      CONTINUE
C
          DO 460 I=1,4
            DO 500 K=1,4
              ABSUM2(I,K) = 0.D0
              DO 550 L=1,4
                ABSUM2(I,K) = ABSUM2(I,K) + CHIFAC(L,K)*AB(I,L)
 550          CONTINUE
              ABSUM2(I,K) = 2.D0*ABSUM2(I,K)
 500        CONTINUE
 460      CONTINUE
          DO 600 I=1,4
            CHI2(I) = 0.D0
            DO 650 K=1,4
              CHI2(I) = CHI2(I) + ABSUM2(K,I)
 650        CONTINUE
 600      CONTINUE
C  sums instead of products
          DO 660 I=1,4
            DO 670 KD=1,4
              DTMP = ABS(ABSUM2(I,KD))
              IF(DTMP.LT.1.D-30) THEN
                ABSUM2(I,KD) = -50.D0
              ELSE
                ABSUM2(I,KD) = LOG(DTMP)
              ENDIF
 670        CONTINUE
 660      CONTINUE


          IF(MAX(IMAX,KMAX).GT.30) THEN
            WRITE(ErrorOut,
     * '(1X,2A,3I6)') 'PHO_PRBDIS: internal field ',
     &        'DIMENSION TOO SMALL (IMAX,KMAX,INT):',IMAX,KMAX,30
            CALL PHO_ABORT
          ENDIF

          DO 700 KD=1,4
            DO 750 I=1,4
              ABSTMP(I) = ABSUM2(I,KD)
 750        CONTINUE
C  recursive sum
            CHITMP(1) = -ABSUM2(1,KD)
            DO 800 I=0,IMAX
              CHITMP(1) = CHITMP(1)+ABSTMP(1)-FACLOG(I)
              CHITMP(2) = -ABSTMP(2)
              DO 810 K=0,KMAX
                CHITMP(2) = CHITMP(2)+ABSTMP(2)-FACLOG(K)
C  calculation of elastic part
                DTMP = -CHI2(KD)+CHITMP(1)+CHITMP(2)
                IF(DTMP.LT.-30.D0) THEN
                  DTMP = 0.D0
                ELSE
                  DTMP = EXP(DTMP)*FAC*AMPCOF(KD)
                ENDIF
                PROB(IP,IE,I,K) = PROB(IP,IE,I,K) + DTMP
 810          CONTINUE
 800        CONTINUE
 700      CONTINUE
          PROB(IP,IE,0,0) = 0.D0
C
C**********************************************************
        ELSE
          WRITE(ErrorOut,'(1X,A,I3)')
     &      'PHO_PRBDIS:ERROR: INVALID SETTING OF ISWMDL(1)',ISWMDL(1)
          STOP
        ENDIF
 5000 CONTINUE

C  debug output
      IF(IDEB(55).GE.15) THEN
        WRITE(ErrorOut,'(/,1X,A,I3,E11.4)')
     &    'PHO_PRBDIS: LIST OF PROBABILITIES (UNCORRECTED,IP,ECM)',
     &    IP,ECM
        DO 905 I=0,MIN(IMAX,5)
          DO 915 K=0,MIN(KMAX,5)
            IF(ABS(PROB(IP,IE,I,K)).GT.1.D-10)
     &        WRITE(ErrorOut,
     * '(10X,2I3,5X,E12.3)') I,K,PROB(IP,IE,I,K)
 915      CONTINUE
 905    CONTINUE
      ENDIF
C  string probability (uncorrected)
      IF(IDEB(55).GE.5) THEN
        DO 955 I=0,IMAX
          DO 965 K=0,KMAX
            INDX = 2*I+2*K
            IF((INDX.LE.ICHMAX).AND.(INDX.GT.0)) THEN
              PCHAIN(1,INDX) = PCHAIN(1,INDX) + PROB(IP,IE,I,K)
            ENDIF
 965      CONTINUE
 955    CONTINUE
        WRITE(ErrorOut,'(/1X,2A,E11.4)') 'PHO_PRBDIS: ',
     &    'LIST OF SELECTED PROBABILITIES (UNCORR,ECM)',ECM
        WRITE(ErrorOut,'(10X,A)') 'I,   0HPOM,   1HPOM,   2HPOM'
        DO 183 I=0,IIMAX
          IF(ABS(PROB(IP,IE,I,0)).GT.1.D-10)
     &      WRITE(ErrorOut,'(5X,I4,3E12.4)') I,PROB(IP,IE,I,0),
     &      PROB(IP,IE,I,1),PROB(IP,IE,I,2)
 183    CONTINUE
      ENDIF
C  substract high-mass single and double diffraction
      PROB(IP,IE,1,0) = PROB(IP,IE,1,0)
     &                 -(SIGHSD(1)+SIGHSD(2)+SIGHDD+SIGCDF(0))/SIGNDF
      PROB(IP,IE,1,0) = MAX(0.01,PROB(IP,IE,1,0))
C
C  probability check
      CHKSUM = 0.D0
      PRONEG = 0.D0
      AVERI =  0.D0
      AVERK =  0.D0
      AVERL =  0.D0
      AVERM =  0.D0
      AVERN =  0.D0
      SIGMI =  0.D0
      SIGMK =  0.D0
      SIGML =  0.D0
      SIGMM =  0.D0
      DO 1001 I=0,IMAX
        PSOFT(I) = 0.D0
 1001 CONTINUE
      DO 1002 K=0,KMAX
        PHARD(K) = 0.D0
 1002 CONTINUE
      DO 1000 K=0,KMAX
        DO 1010 I=0,IMAX
          TMP = PROB(IP,IE,I,K)
          IF(TMP.LT.0.D0) THEN
            IF((IDEB(55).GE.0).AND.(TMP.LT.-EPS)) THEN
              WRITE(ErrorOut,'(1X,A,4I4,E14.4)')
     &          'PHO_PRBDIS: NEG.PROBABILITY:',
     &              IP,IE,I,K,PROB(IP,IE,I,K)
            ENDIF
            PRONEG = PRONEG+TMP
            TMP = 0.D0
          ENDIF
          CHKSUM = CHKSUM+TMP
          AVERI = AVERI+DBLE(I)*TMP
          AVERK = AVERK+DBLE(K)*TMP
          SIGMI = SIGMI+DBLE(I**2)*TMP
          SIGMK = SIGMK+DBLE(K**2)*TMP
          PSOFT(I) = PSOFT(I)+PROB(IP,IE,I,K)
          PHARD(K) = PHARD(K)+PROB(IP,IE,I,K)
          PROB(IP,IE,I,K) = CHKSUM
 1010   CONTINUE
 1000 CONTINUE
C
      IF(IDEB(55).GE.1) WRITE(ErrorOut,'(/,1X,A,2E15.6)')
     &  'PHO_PRBDIS: FIRST SUM OF PROBABILITIES',CHKSUM,PRONEG
C  cut probabilites output
      IF(IDEB(55).GE.5) THEN
        WRITE(ErrorOut,
     * '(/1X,A)') 'list of cut probabilities (uncorr/corr)'
        DO 185 I=1,ICHMAX
          IF(ABS(PCHAIN(1,I)).GT.1.D-10)
     &      WRITE(ErrorOut,
     * '(5X,I4,2E12.3)') I,PCHAIN(1,I),PCHAIN(1,I)/CHKSUM
 185    CONTINUE
      ENDIF
C  rescaling necessary
      IF(ABS(CHKSUM-1.D0).GT.1.D-15) THEN
        FAC = 1.D0/CHKSUM
        IF(IDEB(55).GE.1) WRITE(ErrorOut,'(/,1X,A,E15.6)')
     &    'PHO_PRBDIS: RESCALING OF PROBABILITIES WITH FACTOR',FAC
        DO 40 K=0,KMAX
          DO 50 I=0,IMAX
            PROB(IP,IE,I,K) = PROB(IP,IE,I,K)*FAC
  50      CONTINUE
  40    CONTINUE
        AVERI = AVERI*FAC
        AVERK = AVERK*FAC
        AVERL = AVERL*FAC
        AVERM = AVERM*FAC
        SIGMI = SIGMI*FAC**2
        SIGMK = SIGMK*FAC**2
        SIGML = SIGML*FAC**2
        SIGMM = SIGMM*FAC**2
      ENDIF
C
C  probability to find Reggeon/Pomeron
      PROB(IP,IE,0,0) = -SIGREG/(SIGPOM+SIGREG)
      AVERJ = -PROB(IP,IE,0,0)*AVERI
      AVERII = AVERI-AVERJ
C
      SIGTAB(IP,74,IE) = AVERII
      SIGTAB(IP,75,IE) = AVERK
      SIGTAB(IP,76,IE) = AVERJ
C
      SIGTAB(IP,79,IE) = PROB(IP,IE,IMAX,0)*SIGNDF
      SIGTAB(IP,80,IE) = SIGNDF-SIGTAB(IP,79,IE)
C
      IF(IDEB(55).GE.1) THEN

C  average interaction probabilities
        WRITE(ErrorOut,'(/1X,A,/1X,A)')
     &    'PHO_PRBDIS: EXPECTED INTERACTION STATISTICS',
     &    '-------------------------------------------'
        WRITE(ErrorOut,'(1X,A,E12.4,2I3)')
     &    'ENERGY,IP,TABLE INDEX:',EPTAB(IP,IE),IP,IE
        WRITE(ErrorOut,
     * '(1X,A,2I4)') 'current limitations (soft,hard):',
     &    IMAX,KMAX
        WRITE(ErrorOut,'(1X,A,E12.4/,4X,A,/,1X,6E11.3)')
     &    'AVERAGED NUMBER OF CUTS PER EVENT (EFF. CS):',SIGNDF,
     &    ' (POM / POM-H / REG / ENH-TRI-LOOP / ENH-DBLE / SUM):',
     &    AVERII,AVERK,AVERJ,AVERL,AVERM,
     &    AVERI+AVERK+AVERL+AVERM
        WRITE(ErrorOut,'(1X,A,/,4X,A,/,1X,4E11.3)')
     &    'STANDARD DEVIATION ( SQRT(SIGMA) ):',
     &    ' (POMERON / POMERON-H / ENH-TRI-LOOP / ENH-DBLE):',
     &    SQRT(ABS(SIGMI-AVERI**2)),SQRT(ABS(SIGMK-AVERK**2)),
     &    SQRT(ABS(SIGML-AVERL**2)),SQRT(ABS(SIGMM-AVERM**2))
        WRITE(ErrorOut,
     * '(1X,A)') 'cross section / probability  soft, hard'
        DO I=0,MIN(IMAX,KMAX)
          WRITE(ErrorOut,'(I5,2E12.4,3X,2E12.4)')
     &      I,PSOFT(I)*SIGNDF,PSOFT(I),PHARD(I)*SIGNDF,PHARD(I)
        ENDDO

C  cross check of probability distribution and inclusive cross section
        PSSUM_1 = 0.D0
        PSSUM_2 = 0.D0
        PHSUM_1 = 0.D0
        PHSUM_2 = 0.D0
        DO I=1,IMAX
          PSSUM_1 = PSSUM_1+PSOFT(I)*FAC
          PSSUM_2 = PSSUM_2+PSOFT(I)*FAC*DBLE(I)
        ENDDO
        DO K=1,KMAX
          PHSUM_1 = PHSUM_1+PHARD(K)
          PHSUM_2 = PHSUM_2+PHARD(K)*FAC*DBLE(K)
        ENDDO
        WRITE(ErrorOut,'(1x,a,2E12.4,3X,2E12.4)') 'sum:',
     &    PSSUM_2*SIGNDF,PSSUM_1,PHSUM_2*SIGNDF,PHSUM_1

      ENDIF

      END


CDECK  ID>, PHO_SAMPRO
      SUBROUTINE PHO_SAMPRO(IP,IFP1,IFP2,ECM,PVIR1,PVIR2,SPROB,IPROC)
C***********************************************************************
C
C     routine to sample kind of process
C
C     input:   IP        particle combination
C              IFP1/2    PDG number of particle 1/2
C              ECM       c.m. energy (GeV)
C              PVIR1/2   virtuality of particle 1/2 (GeV**2, positive)
C              SPROB     suppression factor for processes 1-7
C                        due to rapidity gap survival probability
C              IPROC     mode
C                          -2     output of statistics
C                          -1     initialization
C                           0     sampling of process
C
C     output:  IPROC     kind of interaction process:
C                           1  non-diffractive resolved process
C                           2  elastic scattering
C                           3  quasi-elastic rho/omega/phi production
C                           4  central diffraction
C                           5  single diffraction according to IDIFF1
C                           6  single diffraction according to IDIFF2
C                           7  double diffraction
C                           8  single-resolved / direct processes
C
C***********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      INTEGER IP,IFP1,IFP2,IPROC
      DOUBLE PRECISION ECM,PVIR1,PVIR2,SPROB

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      DOUBLE PRECISION PRO,XPROB,SIGSDI,CALLS,SIGSUM,ECMSUM
      DIMENSION PRO(8,4),XPROB(8),SIGSDI(2)
      DIMENSION CALLS(4),SIGSUM(4),ECMSUM(4)

      INTEGER I,K,KMAX
      DOUBLE PRECISION PHO_RNDM
      DOUBLE PRECISION SIGDDI,SIGHD,SIGHR,SIGNDR,XI

      IF(IDEB(11).GE.15) WRITE(ErrorOut,
     * '(/,1X,A,/5X,I3,2I6,1P4E11.3)')
     &  'PHO_SAMPRO: CALLED WITH IP,IFP1/2,ECM,PVIR1/2,SPROB',
     &  IP,IFP1,IFP2,ECM,PVIR1,PVIR2,SPROB

      IF(IPROC.GE.0) THEN

C  interpolate cross sections
        CALL PHO_CSINT(IP,IFP1,IFP2,-1,-1,ECM,PVIR1,PVIR2)

C  cross check
        IF((IP.EQ.1).AND.((SPROB.GT.1.D0).OR.(SPROB.LT.0.D0))) THEN
          WRITE(ErrorOut,'(/,1X,A,/5X,I12,I3,2I6,1P4E11.3)')
     &      'PHO_SAMPRO: INCONSISTENT GAP SURVIVAL PROBABILITY',
     &      'EVENT,IP,IFP1/2,ECM,PVIR1/2,SPROB:',
     &      KEVENT,IP,IFP1,IFP2,ECM,PVIR1,PVIR2,SPROB
        ENDIF

C  calculate cumulative probabilities
        IF(ISWMDL(1).EQ.3) THEN
          IF(ISWMDL(2).GE.1) THEN
            SIGSDI(1) = SIGLSD(1)+SIGHSD(1)
            SIGSDI(2) = SIGLSD(2)+SIGHSD(2)
            SIGDDI    = SIGLDD+SIGHDD
            SIGNDR    = SIGINE-SIGVM(0,0)-SIGCDF(0)-SIGDIR
     &                - SIGSDI(1)-SIGSDI(2)-SIGDDI
            XPROB(1)  = SIGNDR*SPROB*DBLE(IPRON(1,IP))
            XPROB(2)  = XPROB(1)+SIGELA*SPROB*DBLE(IPRON(2,IP))
            XPROB(3)  = XPROB(2)+SIGVM(0,0)*SPROB*DBLE(IPRON(3,IP))
            XPROB(4)  = XPROB(3)+SIGCDF(0)*SPROB*DBLE(IPRON(4,IP))
            XPROB(5)  = XPROB(4)+SIGSDI(1)*SPROB*DBLE(IPRON(5,IP))
            XPROB(6)  = XPROB(5)+SIGSDI(2)*SPROB*DBLE(IPRON(6,IP))
            XPROB(7)  = XPROB(6)+SIGDDI*SPROB*DBLE(IPRON(7,IP))
            XPROB(8)  = XPROB(7)+SIGDIR*DBLE(IPRON(8,IP))
          ELSE
            SIGHR = 0.D0
            IF(IPRON(1,IP).EQ.1) SIGHR = SIGHAR
            SIGHD = 0.D0
            IF(IPRON(8,IP).EQ.1) SIGHD = SIGDIR
            XPROB(1) = SIGHR/(SIGHR+SIGHD)
            XPROB(2) = XPROB(1)
            XPROB(3) = XPROB(1)
            XPROB(4) = XPROB(1)
            XPROB(5) = XPROB(1)
            XPROB(6) = XPROB(1)
            XPROB(7) = XPROB(1)
            XPROB(8) = XPROB(1)+SIGHD/(SIGHR+SIGHD)
          ENDIF

          IF(IDEB(11).GE.15) THEN
            WRITE(ErrorOut,'(1X,A,I3)')
     &        'PHO_SAMPRO: PARTIAL CROSS SECTIONS FOR IP',IP
            WRITE(ErrorOut,'(5X,I3,2X,1PE12.4)') 1,XPROB(1)
            DO 240 I=2,8
              WRITE(ErrorOut,
     * '(5X,I3,2X,1PE12.4)') I,XPROB(I)-XPROB(I-1)
 240        CONTINUE
          ENDIF

        ELSE
          WRITE(ErrorOut,
     * '(/,1X,A,I4)') 'PHO_SAMPRO:ERROR: unsupported model',
     &      ISWMDL(1)
          CALL PHO_ABORT
        ENDIF

        IF(XPROB(8).LT.1.D-20) THEN
          IF(IDEB(11).GE.2)
     &      WRITE(ErrorOut,
     * '(1X,2A,/10X,A,1P3E11.3)') 'PHO_SAMPRO:ERROR: ',
     &      'ACTIVATED PROCESSES HAVE VANISHING CROSS SECTION SUM',
     &      'IP,ECM,SIG_SUM:',IP,ECM,XPROB(8)
          IPROC = 0
          RETURN
        ENDIF

C  sample process
        XI = PHO_RNDM(XI)*XPROB(8)
        DO 100 I=1,8
          IF(XI.LE.XPROB(I)) GOTO 110
 100    CONTINUE
 110    CONTINUE
        IPROC = MIN(I,8)

        CALLS(IP)     = CALLS(IP)+1.D0
        PRO(IPROC,IP) = PRO(IPROC,IP)+1.D0
        ECMSUM(IP)    = ECMSUM(IP)+ECM
        IF(ISWMDL(2).GE.1) THEN
          SIGSUM(IP) = SIGSUM(IP)+XPROB(8)
        ELSE
          SIGSUM(IP) = SIGSUM(IP)+SIGGEN(3)
        ENDIF

C  debug output
        IF(IDEB(11).GE.5) WRITE(ErrorOut,'(1X,A,I3,I12,I4)')
     &    'PHO_SAMPRO: IP,CALL,PROC-ID',
     &    IP,INT(CALLS(IP)+0.1D0),IPROC

C  statistics initialization
      ELSE IF(IPROC.EQ.-1) THEN
        DO 260 K=1,4
          DO 250 I=1,8
            PRO(I,K) = 0.D0
 250      CONTINUE
          CALLS(K)  = 0.D0
          SIGSUM(K) = 0.D0
          ECMSUM(K) = 0.D0
 260    CONTINUE

C  write out statistics
      ELSE IF(IPROC.EQ.-2) THEN
        KMAX = 4
        IF(ISWMDL(2).EQ.0) KMAX=1
        DO 270 K=1,KMAX
          IF(CALLS(K).GT.0.5D0) THEN
            SIGSUM(K) = SIGSUM(K)/CALLS(K)**2
            ECMSUM(K) = ECMSUM(K)/CALLS(K)
            IF(IDEB(11).GE.0) THEN
              WRITE(ErrorOut,'(/,1X,2A,I4,1PE12.3,/,1X,A)')
     &          'PHO_SAMPRO: INTERNAL PROCESS STATISTICS ',
     &          '(IP,<ECM>)',K,ECMSUM(K),
     &          '---------------------------------------'
              WRITE(ErrorOut,'(8X,A)')
     &          '        PROCESS      SAMPLED    CROSS SECTION'
              IF(ISWMDL(2).GE.1) THEN
                WRITE(ErrorOut,'(9(/5X,A,0PF12.0,5X,1PE12.3))')
     &            '    ALL PROCESSES',CALLS(K),CALLS(K)*SIGSUM(K),
     &            ' NONDIF.INELASTIC',PRO(1,K),PRO(1,K)*SIGSUM(K),
     &            '          ELASTIC',PRO(2,K),PRO(2,K)*SIGSUM(K),
     &            'VMESON PRODUCTION',PRO(3,K),PRO(3,K)*SIGSUM(K),
     &            '   DOUBLE POMERON',PRO(4,K),PRO(4,K)*SIGSUM(K),
     &            ' SINGLE DIFFR.(1)',PRO(5,K),PRO(5,K)*SIGSUM(K),
     &            ' SINGLE DIFFR.(2)',PRO(6,K),PRO(6,K)*SIGSUM(K),
     &            ' DOUBLE DIFFRACT.',PRO(7,K),PRO(7,K)*SIGSUM(K),
     &            ' DIRECT PROCESSES',PRO(8,K),PRO(8,K)*SIGSUM(K)
              ELSE
                WRITE(ErrorOut,'(3(/5X,A,0PF12.0,5X,1PE12.3))')
     &            '    ALL PROCESSES',CALLS(K),CALLS(K)*SIGSUM(K),
     &            '  DOUBLE RESOLVED',PRO(1,K),PRO(1,K)*SIGSUM(K),
     &            ' SINGLE RES + DIR',PRO(8,K),PRO(8,K)*SIGSUM(K)
              ENDIF
            ENDIF
          ENDIF
 270    CONTINUE
      ENDIF

      END


CDECK  ID>, PHO_SAMPRB
      SUBROUTINE PHO_SAMPRB(ECMI,IP,ISAM,JSAM,KSAM)
C********************************************************************
C
C     routine to sample number of cut graphs of different kind
C
C     input:  IP      scattering particle combination
C             ECMI    CMS energy
C             IP      -1         initialization
C                     -2         output of statistics
C                     others     sampling of cuts
C
C     output: ISAM    number of soft Pomerons cut
C             JSAM    number of soft Reggeons cut
C             KSAM    number of hard Pomerons cut
C
C     PHO_PRBDIS has to be called before
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  cut probability distribution
      INTEGER IEETA1,IIMAX,KKMAX
      PARAMETER( IEETA1=20, IIMAX=20, KKMAX=20 )
      INTEGER IEEMAX,IMAX,KMAX
      REAL PROB
      DOUBLE PRECISION EPTAB
      COMMON /POPROB/ PROB(4,IEETA1,0:IIMAX,0:KKMAX),EPTAB(4,IEETA1),
     &                IEEMAX,IMAX,KMAX

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL

C  table of particle indices for recursive PHOJET calls
      INTEGER MAXIPX
      PARAMETER ( MAXIPX = 100 )
      INTEGER IPOPOS,IPORES,IPOIX1,IPOIX2,IPOIX3
      COMMON /PORECU/ IPOPOS(2,MAXIPX),IPORES(MAXIPX),
     &                IPOIX1,IPOIX2,IPOIX3


      DIMENSION ECMS1(4),ECMS2(4),AVERB(0:3,4),AVERC(0:3,4)



C  sample number of interactions
      IF(IP.GE.0) THEN
        ITER = 0
        ECMX = ECMI
        ECMC = ECMI
        KLIM = 1
        IF((IPAMDL(13).GT.0).AND.(IPROCE.EQ.1).AND.(IPOIX3.EQ.0)) THEN
          IF(IPAMDL(16).EQ.0) ECMC = SECM
          KLIM = 0
        ENDIF

C  sample up to kinematic limits only
        IMAX1 = MIN(IMAX,INT(0.4D0*ECMC/PARMDL(161)))
        IF(IMAX1.LT.1) THEN
          IF(IPAMDL(2).EQ.1) THEN
C  reggeon allowed
            ISAM = 0
            JSAM = 1
            KSAM = 0
            AVERB(3,IP) = AVERB(3,IP)+1.D0
          ELSE
C  only pomeron even at very low energies
            ISAM = 1
            JSAM = 0
            KSAM = 0
            AVERB(1,IP) = AVERB(1,IP)+1.D0
          ENDIF
          AVERB(0,IP) = AVERB(0,IP)+1.D0
          GOTO 150
        ENDIF
C  find interpolation factors
        IF(ECMX.LE.EPTAB(IP,1)) THEN
          I1 = 1
          I2 = 1
        ELSE IF(ECMX.LT.EPTAB(IP,IEEMAX)) THEN
          DO 50 I=2,IEEMAX
            IF(ECMX.LE.EPTAB(IP,I)) GOTO 200
 50       CONTINUE
 200      CONTINUE
          I1 = I-1
          I2 = I
        ELSE
          WRITE(ErrorOut,'(/1X,A,2E12.3)')
     &      'PHO_SAMPRB:TOO HIGH ENERGY',ECMX,EPTAB(IP,IEEMAX)
          CALL PHO_PREVNT(-1)
          I1 = IEEMAX
          I2 = IEEMAX
        ENDIF
        FAC2 = 0.D0
        IF(I1.NE.I2)
     &    FAC2=LOG(ECMX/EPTAB(IP,I1))/LOG(EPTAB(IP,I2)/EPTAB(IP,I1))
        FAC1=1.D0-FAC2
C  reggeon probability
        PREG = -(PROB(IP,I1,0,0)*FAC1+PROB(IP,I2,0,0)*FAC2)
C  calculate soft suppression factor
        IF(IP.EQ.1) FSUPP = PARMDL(35)**2
     &         /((PVIRT(1)+PARMDL(35))*(PVIRT(2)+PARMDL(35)))
C
 10     CONTINUE
        ITER = ITER+1
        XI = PHO_RNDM(FAC2)
        DO 260 KSAM=0,KMAX
          DO 270 ISAM=0,IMAX
            PRO = PROB(IP,I1,ISAM,KSAM)*FAC1
     &           +PROB(IP,I2,ISAM,KSAM)*FAC2
            IF(PRO.GT.XI) GOTO 100
 270      CONTINUE
 260    CONTINUE
        ISAM = MIN(IMAX,ISAM)
        KSAM = MIN(KMAX,KSAM)

 100    CONTINUE

        IF(ITER.GT.100) THEN

          ISAM = 0
          JSAM = 1
          KSAM = 0
          IF(IDEB(12).GE.3) WRITE(ErrorOut,
     * '(1X,A,I10,E11.3,I6)')
     &      'PHO_SAMPRB: REJECTION (EV,ECM,ITER)',KEVENT,ECMX,ITER

        ELSE

C  reggeon contribution
          JSAM = 0
          IF(IPAMDL(2).EQ.1) THEN
            DO 90 I=1,ISAM
              IF(PHO_RNDM(PRO).LT.PREG) JSAM = JSAM+1
 90         CONTINUE
            ISAM = ISAM-JSAM
          ENDIF
C  statistics of bare cuts
          IF(ITER.EQ.1) THEN
            AVERB(0,IP) = AVERB(0,IP)+1.D0
            AVERB(1,IP) = AVERB(1,IP)+DBLE(ISAM)
            AVERB(2,IP) = AVERB(2,IP)+DBLE(KSAM)
            AVERB(3,IP) = AVERB(3,IP)+DBLE(JSAM)
          ENDIF
C  limitation given by field dimensions
          IF((2*ISAM+JSAM+3*KSAM).GT.50) GOTO 10

          IF(IP.EQ.1) THEN

C  reweight according to virtualities and PDF treatment
            IF(IPAMDL(115).GE.1) THEN
              IF(KSAM.EQ.0) THEN
                IF(FSUP(1)*FSUP(2).LT.PHO_RNDM(ECMI)) GOTO 10
              ENDIF
            ENDIF

C  reduce number of cuts according to photon virtualities
            IF(IPAMDL(114).GE.1) THEN
 110          CONTINUE
              I = ISAM+JSAM
              WGX = FSUPP**I
              IF(PHO_RNDM(WGX).GT.WGX) THEN
                IF(ISAM+JSAM+KSAM.GT.1) THEN
                  IF(JSAM.GT.0) THEN
                    JSAM = JSAM-1
                    GOTO 110
                  ELSE IF(ISAM.GT.0) THEN
                    ISAM = ISAM-1
                    GOTO 110
                  ENDIF
                ENDIF
              ENDIF
            ENDIF

          ENDIF

C  phase space limitation
 120      CONTINUE
          XM = DBLE(2*ISAM+JSAM)*PARMDL(160+IP)
     &        +DBLE(2*KSAM)*PTCUT(IP)
          PACC = EXP(PARMDL(9)*(PARMDL(160+IP)-XM)/ECMC)
          IF(PHO_RNDM(XM).GT.PACC) THEN
            IF(ISAM+JSAM+KSAM.GT.1) THEN
              IF(JSAM.GT.0) THEN
                JSAM = JSAM-1
                GOTO 120
              ELSE IF(ISAM.GT.0) THEN
                ISAM = ISAM-1
                GOTO 120
              ELSE IF(KSAM.GT.KLIM) THEN
                KSAM = KSAM-1
                GOTO 120
              ENDIF
            ENDIF
          ENDIF

        ENDIF

        ISAM = ISAM+JSAM/2
        JSAM = MOD(JSAM,2)
C  collect statistics
 150    CONTINUE
        ECMS1(IP) = ECMS1(IP)+ECMX
        ECMS2(IP) = ECMS2(IP)+ECMC

        AVERC(0,IP) = AVERC(0,IP)+1.D0
        AVERC(1,IP) = AVERC(1,IP)+DBLE(ISAM)
        AVERC(2,IP) = AVERC(2,IP)+DBLE(KSAM)
        AVERC(3,IP) = AVERC(3,IP)+DBLE(JSAM)
C
        IF(IDEB(12).GE.10) WRITE(ErrorOut,'(1X,A,2E11.4,3I4)')
     &    'PHO_SAMPRB: ECM,I,J,K',ECM,ECMX,ISAM,JSAM,KSAM
C
C  initialize statistics
      ELSE IF(IP.EQ.-1) THEN
        DO 60 I=1,4
          ECMS1(I) = 0.D0
          ECMS2(I) = 0.D0
          DO 65 K=0,3
            AVERB(K,I) = 0.D0
            AVERC(K,I) = 0.D0
 65       CONTINUE

 60     CONTINUE
        RETURN
C
C  write out statistics
      ELSE IF(IP.EQ.-2) THEN
        WRITE(ErrorOut,
     * '(2(/1X,A))') 'PHO_SAMPRB: interaction statistics',
     &                        '----------------------------------'
        DO 70 I=1,4
          IF(AVERB(0,I).LT.2.D0) GOTO 75
          WRITE(ErrorOut,'(1X,A,I3,1P,2E13.3)')
     &      'STATISTICS FOR IP,<ECM_1>,<ECM_2>',I,
     &      ECMS1(I)/MAX(AVERB(0,I),1.D0),ECMS2(I)/MAX(AVERB(0,I),1.D0)
          WRITE(ErrorOut,'(5X,A)')
     &      'AVERAGE NUMBER OF S-POM,H-POM,REG CUTS (BARE)'
          WRITE(ErrorOut,'(5X,F12.0,1P3E12.4)') AVERB(0,I),
     &      (AVERB(K,I)/AVERB(0,I),K=1,3)
          WRITE(ErrorOut,'(5X,A)')
     &      'AVERAGE (WITH ENERGY/VIRTUALITY CORRECTIONS)'
          WRITE(ErrorOut,'(5X,F12.0,1P3E12.4)') AVERC(0,I),
     &      (AVERC(K,I)/AVERC(0,I),K=1,3)



 75       CONTINUE
 70     CONTINUE
        RETURN
      ENDIF
      END


CDECK  ID>, PHO_TRIREG
      SUBROUTINE PHO_TRIREG(S,GA,AA,GB,BB,DELTA,ALPHAP,GPPP,BPPP,VIR2A,
     &                     SIGTR,BTR)
C**********************************************************************
C
C     calculation of triple-Pomeron total cross section
C     according to Gribov's Regge theory
C
C     input:        S        squared cms energy
C                   GA       coupling constant to diffractive line
C                   AA       slope related to GA (GeV**-2)
C                   GB       coupling constant to elastic line
C                   BB       slope related to GB (GeV**-2)
C                   DELTA    effective pomeron delta (intercept-1)
C                   ALPHAP   slope of pomeron trajectory (GeV**-2)
C                   GPPP     triple-Pomeron coupling
C                   BPPP     slope related to B0PPP (GeV**-2)
C                   VIR2A    virtuality of particle a (GeV**2)
C                   note: units of all coupling constants are mb**1/2
C
C     output:       SIGTR    total triple-Pomeron cross section
C                   BTR      effective triple-Pomeron slope
C                            (differs from diffractive slope!)
C
C     uses E_i (Exponential-Integral function)
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER (EPS =0.0001D0)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


C  integration cut-off Sigma_U ( see Nucl.Phys.B97(1975)493 )
      SIGU = 2.5
C  integration cut-off Sigma_L (min. squared mass of diff. blob)
      SIGL = 5.+VIR2A
C  debug output
      IF(IDEB(50).GE.10) WRITE(ErrorOut,'(1X,A,/1X,1P,9E10.3)')
     &       'PHO_TRIREG: S,GA,AA,GB,BB,DELTA,ALPHAP,GPPP,BPPP ',
     &       S,GA,AA,GB,BB,DELTA,ALPHAP,GPPP,BPPP
C
      IF(S.LT.5.D0) THEN
        SIGTR = 0.D0
        BTR = BPPP+BB
        RETURN
      ENDIF
C  change units of ALPHAP to mb
      ALSCA  = ALPHAP*GEV2MB
C
C  cross section
      PART1=GA*GB**2*GPPP/(16.*PI*2.*ALSCA)*S**DELTA*
     &        EXP(-(BB+BPPP)/(2.*ALPHAP)*DELTA)
      PART2=PHO_EXPINT(((BB+BPPP)/(2.*ALPHAP)+LOG(S/SIGL))*DELTA)
      PART3=PHO_EXPINT(((BB+BPPP)/(2.*ALPHAP)+LOG(SIGU))*DELTA)
C
      SIGTR=PART1*(PART2-PART3)
C
C  slope
      PART1 = (BB+BPPP+2.*ALPHAP*LOG(S/SIGL))/
     &        (BB+BPPP+2.*ALPHAP*LOG(SIGU))
      PART2 = LOG(PART1)
      PART1 = 0.5D0*ALPHAP*LOG(1.D0+S/(SIGU*SIGL))/PART2
      BTR = (AA+BB/2.D0)/2.D0+BPPP+ALPHAP*LOG(S/4.D0)
      BTR = BTR-PART1
C
      IF(SIGTR.LT.EPS) SIGTR = 0.D0
      IF(BTR.LT.BB)  BTR = BB
C
      IF(IDEB(50).GE.7) WRITE(ErrorOut,'(1X,A,1P,3E12.3)')
     &  'PHO_TRIREG: ENERGY,SIGTR,BTR ',SQRT(S),SIGTR,BTR
      END


CDECK  ID>, PHO_LOOREG
      SUBROUTINE PHO_LOOREG(S,GA,AA,GB,BB,DELTA,ALPHAP,GPPP,BPPP,
     &                     VIR2A,VIR2B,SIGLO,BLO)
C**********************************************************************
C
C     calculation of loop-Pomeron total cross section
C     according to Gribov's Regge theory
C
C     input:        S        squared cms energy
C                   GA       coupling constant to diffractive line
C                   AA       slope related to GA (GeV**-2)
C                   GB       coupling constant to elastic line
C                   BB       slope related to GB (GeV**-2)
C                   DELTA    effective pomeron delta (intercept-1)
C                   ALPHAP   slope of pomeron trajectory (GeV**-2)
C                   GPPP     triple-Pomeron coupling
C                   BPPP     slope related to B0PPP (GeV**-2)
C                   VIR2A    virtuality of particle a (GeV**2)
C                   VIR2B    virtuality of particle b (GeV**2)
C                   note: units of all coupling constants are mb**1/2
C
C     output:       SIGLO    total loop-Pomeron cross section
C                   BLO      effective loop-Pomeron slope
C                            (differs from double diffractive slope!)
C
C     uses E_i (Exponential-Integral function)
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER (EPS =0.0001D0)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


C  integration cut-off Sigma_U ( see Nucl.Phys.B97(1975)493 )
      SIGU = 2.5
C  integration cut-off Sigma_L (min. squared mass of diff. blob)
      SIGL = 5.+VIR2A+VIR2B
C  debug output
      IF(IDEB(51).GE.10) WRITE(ErrorOut,'(1X,A,/1X,1P,9E10.3)')
     &       'PHO_LOOREG: S,GA,AA,GB,BB,DELTA,ALPHAP,GPPP,BPPP ',
     &       S,GA,AA,GB,BB,DELTA,ALPHAP,GPPP,BPPP
C
      IF(S.LT.5.D0) THEN
        SIGLO = 0.D0
        BLO = 2.D0*BPPP
        RETURN
      ENDIF

C
C  change units of ALPHAP to mb
      ALSCA  = ALPHAP*GEV2MB
C
C  cross section
      PART1=GA*GB*GPPP**2/(16.*PI*2.*ALSCA)*S**DELTA*
     &        EXP(-DELTA*BPPP/ALPHAP)
      PARTA=BPPP/ALPHAP+LOG(S/SIGL**2)
      PARTB=BPPP/ALPHAP+LOG(SIGU)
      SIGLO=PART1*(PARTA*(PHO_EXPINT(PARTA*DELTA)
     &                    -PHO_EXPINT(PARTB*DELTA))
     &             +EXP(PARTA*DELTA)/DELTA-EXP(PARTB*DELTA)/DELTA
     &            )
C
C  slope
      PART1 = LOG(ABS(PARTA/PARTB))
     &       *(PARTA-LOG(1.D0+S/(SIGL**2*SIGU)))
      PART1 = 0.25*ALPHAP*LOG(1.D0+S/(SIGU*SIGL))**2/PART1
      BLO = (AA+BB)/2.+2.*BPPP+ALPHAP*LOG(S/4.D0)
      BLO = BLO-PART1
C
      IF(SIGLO.LT.EPS) SIGLO = 0.D0
      IF(BLO.LT.2.D0*BPPP) BLO = 2.D0*BPPP
C
      IF(IDEB(51).GE.7) WRITE(ErrorOut,'(1X,A,1P,3E12.3)')
     &  'PHO_LOOREG: ENERGY,SIGLO,BLO',SQRT(S),SIGLO,BLO
      END


CDECK  ID>, PHO_TRXPOM
      SUBROUTINE PHO_TRXPOM(S,GA,AA,GB,BB,DELTA,ALPHAP,
     &                     GPPP,BPPP,SIGDP,BDP)
C**********************************************************************
C
C     calculation of total cross section of two tripe-Pomeron
C     graphs in X configuration according to Gribov's Reggeon field
C     theory
C
C     input:        S        squared cms energy
C                   GA       coupling constant to elastic line 1
C                   AA       slope related to GA (GeV**-2)
C                   GB       coupling constant to elastic line 2
C                   BB       slope related to GB (GeV**-2)
C                   DELTA    effective pomeron delta (intercept-1)
C                   ALPHAP   slope of pomeron trajectory (GeV**-2)
C                   BPPP     triple-Pomeron coupling
C                   BTR      slope related to B0PPP (GeV**-2)
C                   note: units of all coupling constants are mb**1/2
C
C     output:       SIGDP    total cross section for double-Pomeron
C                            scattering
C                   BDP      effective double-Pomeron slope
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER (EPS =0.0001D0)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)


      DIMENSION XWGH1(96),XPOS1(96)

C  lower integration cut-off Sigma_L
      SIGL = PARMDL(71)**2
C  upper integration cut-off Sigma_U
      C = 1.D0-1.D0/PARMDL(70)**2
      C = MAX(PARMDL(72),C)
      SIGU = (1.D0-C)**2*S
C  integration precision
      NGAUS1=16
C
C  debug output
      IF(IDEB(52).GE.10) WRITE(ErrorOut,'(1X,A,/1X,1P,9E10.3)')
     &       'PHO_TRXPOM: S,GA,AA,GB,BB,DELTA,ALPHAP,GPPP,BPPP',
     &       S,GA,AA,GB,BB,DELTA,ALPHAP,GPPP,BPPP
C
      IF(SIGU.LE.SIGL) THEN
        SIGDP = 0.D0
        BDP = AA+BB
        RETURN
      ENDIF
C
C  cross section
C
      XIL = LOG(SIGL)
      XIU = LOG(SIGU)
      XI = LOG(S)
      FAC = (GPPP*GA*GB)**2/(256.D0*PI2)/ALPHAP/GEV2MB**2
      ALPHA2 = 2.D0*ALPHAP
      ALOC = LOG(1.D0/(1.D0-C))
      CALL PHO_GAUSET(XIL,XIU,NGAUS1,XPOS1,XWGH1)
      XSUM = 0.D0
      DO 100 I1=1,NGAUS1
        AMXSQ  = EXP(XPOS1(I1))
        ALOSMX = LOG(S/AMXSQ)
        ALCSMX = LOG((1.D0-C)*S/AMXSQ)
        W = LOG((AA+BPPP+ALPHA2*ALCSMX)/(BB+BPPP+ALPHA2*ALOC))
        W = MAX(0.D0,W)
        WN=(AA+BB+2.D0*BPPP+ALPHA2*ALOSMX)
C  supercritical part
        WSC = AMXSQ**DELTA*(S/AMXSQ)**(2.D0*DELTA)
        XSUM = XSUM + W*XWGH1(I1)/WN*WSC
 100  CONTINUE
      SIGDP = XSUM*FAC
C
C  slope
      BDP = 0.5*(AA+BB+BPPP+ALPHAP*XI)
C
      IF(IDEB(52).GE.7) WRITE(ErrorOut,'(1X,A,1P,3E12.3)')
     &  'PHO_TRXPOM: ENERGY,SIGDP,BDP',SQRT(S),SIGDP,BDP
      END


CDECK  ID>, PHO_CHAN2A
      SUBROUTINE PHO_CHAN2A(BB)
C***********************************************************************
C
C     simple two channel model to realize low mass diffraction
C     (version A, iteration of triple- and loop-Pomeron)
C
C     input:     BB      impact parameter (mb**1/2)
C
C     output:    /POINT4/
C                AMPEL      elastic amplitude
C                AMPVM(4,4) q-elastic VM production
C                AMLMSD(2)  low mass single diffraction amplitude
C                AMHMSD(2)  high mass single diffraction amplitude
C                AMLMDD     low mass double diffraction amplitude
C                AMHMDD     high mass double diffraction amplitude
C                AMPDP(4)   central diffraction amplitude
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER (DEPS  = 1.D-5,
     &           EIGHT = 8.D0)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  complex Born graph amplitudes used for unitarization
      COMPLEX*16      AMPEL,AMPVM,AMPSOF,AMPHAR,AMLMSD,AMHMSD,AMLMDD,
     &                AMHMDD,AMPDP
      COMMON /POINT4/ AMPEL,AMPVM(4,4),AMPSOF,AMPHAR,AMLMSD(2),
     &                AMHMSD(2),AMLMDD,AMHMDD,AMPDP(4)

C  unitarized amplitudes for different diffraction channels
      DOUBLE PRECISION ZXP,BXP,ZXR,BXR,ZXH,BXH,ZXD,BXD,
     &                 ZXT1A,BXT1A,ZXT1B,BXT1B,ZXT2A,BXT2A,ZXT2B,BXT2B,
     &                 ZXDPE,BXDPE,ZXDPA,BXDPA,ZXDPB,BXDPB,ZXDPD,BXDPD,
     &                 ZXL,BXL
      COMMON /POINT5/ ZXP(4,4),BXP(4,4),ZXR(4,4),BXR(4,4),
     &                ZXH(4,4),BXH(4,4),ZXD(4,4),BXD(4,4),
     &                ZXT1A(4,4),BXT1A(4,4),ZXT1B(4,4),BXT1B(4,4),
     &                ZXT2A(4,4),BXT2A(4,4),ZXT2B(4,4),BXT2B(4,4),
     &                ZXDPE(4,4),BXDPE(4,4),ZXDPA(4,4),BXDPA(4,4),
     &                ZXDPB(4,4),BXDPB(4,4),ZXDPD(4,4),BXDPD(4,4),
     &                ZXL(4,4),BXL(4,4)

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  parameters of 2x2 channel model
      DOUBLE PRECISION PHISUP,RMASS,VAR,AMPFAC,ELAFAC,VFAC
      COMMON /PO2CHA/ PHISUP(2),RMASS(2),VAR,AMPFAC(4),ELAFAC(4),VFAC

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)


C  local variables
      DIMENSION  AB(9,4),CHI(4),CHDS(4),CHDH(4),CHDA(4),CHDB(4),
     &           CHDD(4),CHDPE(4),CHDPA(4),CHDPB(4),CHDPD(4),
     &           AMPCHA(4),EX1CHI(4),EX2CHI(4),ABSUM(4),AMPELA(4,0:9)
      DIMENSION CHIFAC(4,4),EXPFAC(4,4),IELTAB(4,4)

C  combinatorical factors
      DATA      CHIFAC / 1.D0, 1.D0,-1.D0,-1.D0,
     &                   1.D0,-1.D0, 1.D0,-1.D0,
     &                   1.D0,-1.D0,-1.D0, 1.D0,
     &                   1.D0, 1.D0, 1.D0, 1.D0 /
      DATA      EXPFAC / 1.D0, 1.D0, 1.D0, 1.D0,
     &                   1.D0,-1.D0,-1.D0, 1.D0,
     &                  -1.D0, 1.D0,-1.D0, 1.D0,
     &                  -1.D0,-1.D0, 1.D0, 1.D0 /
      DATA      IELTAB / 1, 2, 3, 4,
     &                   2, 1, 4, 3,
     &                   3, 4, 1, 2,
     &                   4, 3, 2, 1 /

      IF(IDEB(86).GE.20) WRITE(ErrorOut,'(1X,A,E12.3)')
     &  'PHO_CHAN2A: IMPACT PARAMETER B',BB

      B24 = BB**2/4.D0
      DO 25 I=1,4
        AB(1,I) = ZXP(1,I)*EXP(-B24/BXP(1,I))
     &           +ZXR(1,I)*EXP(-B24/BXR(1,I))
        AB(2,I) = ZXH(1,I)*EXP(-B24/BXH(1,I))
        AB(3,I) =-ZXT1A(1,I)*EXP(-B24/BXT1A(1,I))
        AB(4,I) =-ZXT2A(1,I)*EXP(-B24/BXT2A(1,I))
        AB(5,I) =-ZXL(1,I)*EXP(-B24/BXL(1,I))
     &           -ZXT1B(1,I)*EXP(-B24/BXT1B(1,I))
     &           -ZXT2B(1,I)*EXP(-B24/BXT2B(1,I))
        AB(6,I) = ZXDPE(1,I)*EXP(-B24/BXDPE(1,I))
        AB(7,I) = ZXDPA(1,I)*EXP(-B24/BXDPA(1,I))
        AB(8,I) = ZXDPB(1,I)*EXP(-B24/BXDPB(1,I))
        AB(9,I) = ZXDPD(1,I)*EXP(-B24/BXDPD(1,I))
 25   CONTINUE

      DO 50 I=1,4
        ABSUM(I)  = 0.D0
        DO 75 II=9,1,-1
          ABSUM(I) = ABSUM(I) + AB(II,I)
 75     CONTINUE
 50   CONTINUE
      IF(IDEB(86).GE.20) WRITE(ErrorOut,'(1X,A,4E12.3)')
     &  'PHO_CHAN2A: ABSUM',ABSUM

      DO 100 I=1,4
        CHI(I)  = 0.D0
        CHDS(I) = 0.D0
        CHDH(I) = 0.D0
        CHDA(I) = 0.D0
        CHDB(I) = 0.D0
        CHDD(I) = 0.D0
        CHDPE(I) = 0.D0
        CHDPA(I) = 0.D0
        CHDPB(I) = 0.D0
        CHDPD(I) = 0.D0
        AMPELA(I,0) = 0.D0
        AMPELA(I,9) = 0.D0
        DO 200 K=1,4
          AMPELA(I,K) = 0.D0
          AMPELA(I,K+4) = 0.D0
          AMPVM(I,K)  = 0.D0
          CHI(I)  = CHI(I)  + CHIFAC(K,I)*ABSUM(K)
          CHDS(I) = CHDS(I) + CHIFAC(K,I)*AB(1,K)
          CHDH(I) = CHDH(I) + CHIFAC(K,I)*AB(2,K)
          CHDA(I) = CHDA(I) + CHIFAC(K,I)*AB(3,K)
          CHDB(I) = CHDB(I) + CHIFAC(K,I)*AB(4,K)
          CHDD(I) = CHDD(I) + CHIFAC(K,I)*AB(5,K)
          CHDPE(I) = CHDPE(I) + CHIFAC(K,I)*AB(6,K)
          CHDPA(I) = CHDPA(I) + CHIFAC(K,I)*AB(7,K)
          CHDPB(I) = CHDPB(I) + CHIFAC(K,I)*AB(8,K)
          CHDPD(I) = CHDPD(I) + CHIFAC(K,I)*AB(9,K)
 200    CONTINUE
        IF(CHI(I).LT.-DEPS) THEN
          IF(IDEB(86).GE.0) THEN
            WRITE(ErrorOut,'(1X,A,I3,2E12.3)')
     &        'PHO_CHAN2A: NEG.EIGENVALUE (I,B,CHI)',I,BB,CHI(I)
            WRITE(ErrorOut,
     * '(5X,A,5E12.3)') 'E,CHIs:',ECM,(ABSUM(K),K=1,4)
ccc     &&&&&&&&&& KK
            write(ErrorOut, *)
     *      'prev. value or 0 is being used'
ccc       &&&&&&&&&&
          ENDIF
ccc       &&&&&&&  KK
          if(I .gt. 1) then
             CHI(I) = CHI(I-1)
          else
             CHI(I) = 0.
          endif
ccc       &&&&&&&&&
        ENDIF
        IF(ABS(CHI(I)).GT.200.D0) THEN
          EX1CHI(I) = 0.D0
          EX2CHI(I) = 0.D0
        ELSE
          TMP       = EXP(-CHI(I))
          EX1CHI(I) = TMP
          EX2CHI(I) = TMP*TMP
        ENDIF
 100  CONTINUE
      IF(IDEB(86).GE.20) THEN
        WRITE(ErrorOut,
     * '(1X,A,4E12.3)') 'PHO_CHAN2A: EX1CHI',EX1CHI
      ENDIF

      AMPELA(1,0) = 4.D0
      DO 300 K=1,4
        DO 400 J=1,4
          CFAC = 2.D0*EXPFAC(J,K)*EX2CHI(J)
          AMPELA(K,0) = AMPELA(K,0) - EXPFAC(J,K)*EX1CHI(J)
          AMPELA(K,1) = AMPELA(K,1) + CFAC*CHDS(J)
          AMPELA(K,2) = AMPELA(K,2) + CFAC*CHDH(J)
          AMPELA(K,3) = AMPELA(K,3) - CFAC*CHDA(J)
          AMPELA(K,4) = AMPELA(K,4) - CFAC*CHDB(J)
          AMPELA(K,5) = AMPELA(K,5) - CFAC*CHDD(J)
          AMPELA(K,6) = AMPELA(K,6) + CFAC*CHDPE(J)
          AMPELA(K,7) = AMPELA(K,7) + CFAC*CHDPA(J)
          AMPELA(K,8) = AMPELA(K,8) + CFAC*CHDPB(J)
          AMPELA(K,9) = AMPELA(K,9) + CFAC*CHDPD(J)
 400    CONTINUE
 300  CONTINUE

      IF(IDEB(86).GE.25) THEN
        DO 305 I=1,9
          WRITE(ErrorOut,
     * '(1X,A,I3,4E10.3)') 'PHO_CHAN2A: AMPELA(1-4,I)',I,
     &      (AMPELA(K,1),K=1,4)
 305    CONTINUE
      ENDIF

C  VDM factors --> amplitudes
C  low mass excitations
      DO 500 I=1,4
        AMPCHA(I) = 0.D0
        DO 600 K=1,4
          AMPCHA(I) = AMPCHA(I) + AMPFAC(K)*AMPELA(IELTAB(K,I),0)
 600    CONTINUE
 500  CONTINUE
      AMPVME    = AMPCHA(1)/EIGHT
      AMLMSD(1) = AMPCHA(2)/EIGHT
      AMLMSD(2) = AMPCHA(3)/EIGHT
      AMLMDD    = AMPCHA(4)/EIGHT
C  elastic part, high mass diffraction
      AMPEL = 0.5D0*ZXD(1,1)*EXP(-B24/BXD(1,1))
      AMPSOF    = 0.D0
      AMPHAR    = 0.D0
      AMHMSD(1) = 0.D0
      AMHMSD(2) = 0.D0
      AMHMDD    = 0.D0
      AMPDP(1)  = 0.D0
      AMPDP(2)  = 0.D0
      AMPDP(3)  = 0.D0
      AMPDP(4)  = 0.D0
      DO 450 I=1,4
        AMPEL     = AMPEL     + ELAFAC(I)*AMPELA(I,0)/8.D0
        AMPSOF    = AMPSOF    + ELAFAC(I)*AMPELA(I,1)
        AMPHAR    = AMPHAR    + ELAFAC(I)*AMPELA(I,2)
        AMHMSD(1) = AMHMSD(1) + ELAFAC(I)*AMPELA(I,3)
        AMHMSD(2) = AMHMSD(2) + ELAFAC(I)*AMPELA(I,4)
        AMHMDD    = AMHMDD    + ELAFAC(I)*AMPELA(I,5)
        AMPDP(1)  = AMPDP(1)  + ELAFAC(I)*AMPELA(I,6)
        AMPDP(2)  = AMPDP(2)  + ELAFAC(I)*AMPELA(I,7)
        AMPDP(3)  = AMPDP(3)  + ELAFAC(I)*AMPELA(I,8)
        AMPDP(4)  = AMPDP(4)  + ELAFAC(I)*AMPELA(I,9)
 450  CONTINUE
      AMPSOF    = AMPSOF/16.D0
      AMPHAR    = AMPHAR/16.D0
      AMHMSD(1) = AMHMSD(1)/16.D0
      AMHMSD(2) = AMHMSD(2)/16.D0
      AMHMDD    = AMHMDD/16.D0
      AMPDP(1)  = AMPDP(1)/16.D0
      AMPDP(2)  = AMPDP(2)/16.D0
      AMPDP(3)  = AMPDP(3)/16.D0
      AMPDP(4)  = AMPDP(4)/16.D0
      IF(DREAL(AMHMSD(1)).LE.0.D0) AMHMSD(1) = 0.D0
      IF(DREAL(AMHMSD(2)).LE.0.D0) AMHMSD(2) = 0.D0
      IF(DREAL(AMHMDD).LE.0.D0)    AMHMDD = 0.D0
      IF(DREAL(AMPDP(1)).LE.0.D0) AMPDP(1) = 0.D0
      IF(DREAL(AMPDP(2)).LE.0.D0) AMPDP(2) = 0.D0
      IF(DREAL(AMPDP(3)).LE.0.D0) AMPDP(3) = 0.D0
      IF(DREAL(AMPDP(4)).LE.0.D0) AMPDP(4) = 0.D0

C  vector-meson production, weight factors
      IF((IFPAP(1).EQ.22).OR.(IFPAP(2).EQ.22)) THEN
        IF(IFPAP(1).EQ.22) THEN
          IF(IFPAP(2).EQ.22) THEN
            DO 10 I=1,4
              DO 15 J=1,4
                AMPVM(I,J) = PARMDL(9+I)*PARMDL(9+J)*AMPVME
 15           CONTINUE
 10         CONTINUE
          ELSE
            AMPVM(1,1) = PARMDL(10)*AMPVME
            AMPVM(2,1) = PARMDL(11)*AMPVME
            AMPVM(3,1) = PARMDL(12)*AMPVME
            AMPVM(4,1) = PARMDL(13)*AMPVME
          ENDIF
        ELSE IF(IFPAP(2).EQ.22) THEN
          AMPVM(1,1) = PARMDL(10)*AMPVME
          AMPVM(1,2) = PARMDL(11)*AMPVME
          AMPVM(1,3) = PARMDL(12)*AMPVME
          AMPVM(1,4) = PARMDL(13)*AMPVME
        ENDIF
      ENDIF
C  debug output
      IF(IDEB(86).GE.5) THEN
        WRITE(ErrorOut,'(/,1X,A)')
     &    'PHO_CHAN2A: IMPACT PARAMETER AMPLITUDES'
        WRITE(ErrorOut,'(1X,A,1P,2E12.3)') '       AMPEL',AMPEL
        WRITE(ErrorOut,
     * '(1X,A,1P,8E10.3)') 'AMPVM(1,1-4)',(AMPVM(1,K),K=1,4)
        WRITE(ErrorOut,
     * '(1X,A,1P,8E10.3)') 'AMPVM(2,1-4)',(AMPVM(2,K),K=1,4)
        WRITE(ErrorOut,
     * '(1X,A,1P,8E10.3)') 'AMPVM(3,1-4)',(AMPVM(3,K),K=1,4)
        WRITE(ErrorOut,
     * '(1X,A,1P,8E10.3)') 'AMPVM(4,1-4)',(AMPVM(4,K),K=1,4)
        WRITE(ErrorOut,
     * '(1X,A,1P,4E12.3)') '  AMPSOF/HAR',AMPSOF,AMPHAR
        WRITE(ErrorOut,'(1X,A,1P,4E12.3)') '      AMLMSD',AMLMSD
        WRITE(ErrorOut,'(1X,A,1P,4E12.3)') '      AMHMSD',AMHMSD
        WRITE(ErrorOut,'(1X,A,1P,2E12.3)') '      AMLMDD',AMLMDD
        WRITE(ErrorOut,'(1X,A,1P,2E12.3)') '      AMHMDD',AMHMDD
        WRITE(ErrorOut,'(1X,A,1P,8E10.3)') '  AMPDP(1-4)',AMPDP
      ENDIF

      END



CDECK  ID>, PHO_EVENT
      SUBROUTINE PHO_EVENT(NEV,P1,P2,FAC,IREJ)
C********************************************************************
C
C     main subroutine to manage simulation processes
C
C     input: NEV       -1   initialization
C                       1   generation of events
C                       2   generation of events without rejection
C                           due to energy dependent cross section
C                       3   generation of events without rejection
C                           using initialization energy
C                      -2   output of event generation statistics
C            P1(4)     momentum of particle 1 (internal TARGET)
C            P2(4)     momentum of particle 2 (internal PROJECTILE)
C            FAC       used for initialization:
C                      contains cross section the events corresponds to
C                      during generation: current cross section
C
C     output: IREJ     0: event accepted
C                      1: event rejected
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( TINY   =  1.D-10 )

      DIMENSION P1(4),P2(4)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)

C  names of hard scattering processes
      INTEGER MAX_PRO_1
      PARAMETER ( MAX_PRO_1 = 16 )
      CHARACTER*18 PROC
      COMMON /POHPRO/ PROC(0:MAX_PRO_1)

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)

C  table of particle indices for recursive PHOJET calls
      INTEGER MAXIPX
      PARAMETER ( MAXIPX = 100 )
      INTEGER IPOPOS,IPORES,IPOIX1,IPOIX2,IPOIX3
      COMMON /PORECU/ IPOPOS(2,MAXIPX),IPORES(MAXIPX),
     &                IPOIX1,IPOIX2,IPOIX3


      DIMENSION IPRSAM(10),IPRACC(10),IENACC(10),IDNS(4),IDNA(4)



      IREJ = 0

C  initializations
      IF(NEV.EQ.-1) THEN
        WRITE(ErrorOut,'(/3(/1X,A))')
     &    '=======================================================',
     &    '  ------- INITIALIZATION OF EVENT GENERATION --------',
     &    '======================================================='
        CALL PHO_SETMDL(0,0,-2)
C  amplitude parameters
        CALL PHO_FITPAR(1)

        CALL PHO_REJSTA(-1)
C  initialize MC package
        CALL PHO_EVEINI(1,P1,P2,JM1,JM2)
        CALL PHO_MCINI
        CALL PHO_SAMPRO(1,IFPAP(1),IFPAP(2),ECM,PVIRT(1),PVIRT(2),
     &    0.D0,-1)
        CALL PHO_PARTON(-1,0,0,P1,P2,IREJ)

C  cross section
        FAC = SIGGEN(4)
        DO 20 I=1,10
          IPRSAM(I) = 0
          IPRACC(I) = 0
          IENACC(I) = 0
 20     CONTINUE
        ISPS = 0
        ISPA = 0
        ISRS = 0
        ISRA = 0
        IHPS = 0
        IHPA = 0
        ISTS = 0
        ISTA = 0
        ISLS = 0
        ISLA = 0
        IDIS = 0
        IDIA = 0
        IDPS = 0
        IDPA = 0
        IDNS(1) = 0
        IDNS(2) = 0
        IDNS(3) = 0
        IDNS(4) = 0
        IDNA(1) = 0
        IDNA(2) = 0
        IDNA(3) = 0
        IDNA(4) = 0
        KACCEP = 0
        KEVENT = 0
        KEVGEN = 0
        ECMSUM = 0.D0
      ELSE IF(NEV.GT.0) THEN
C
C  -------------- begin event generation ---------------
C
        IPAMDL(13) = 0
        IF(NEV.EQ.3) IPAMDL(13) = 1
        KEVENT = KEVENT+1
C  enable debugging
        CALL PHO_TRACE(0,0,0)
        IF(IDEB(68).GE.2) THEN
          IF((MOD(KEVENT,50).EQ.0).OR.(IDEB(68).GE.3))
     &      WRITE(ErrorOut,
     * '(1X,A,2I12)') 'call to PHO_EVENT no',KEVENT,KACCEP
        ENDIF
        CALL PHO_EVEINI(0,P1,P2,JM1,JM2)
C  cross section calculation
        FAC = SIGGEN(3)
        IF(NEV.EQ.1) THEN
          IF(IVWGHT(1).EQ.1) THEN
            WG = EVWGHT(1)*SIGGEN(3)/SIGGEN(4)
          ELSE
            WG = SIGGEN(3)/SIGGEN(4)
          ENDIF
          IF(PHO_RNDM(FAC).GT.WG) THEN
            IREJ = 1
            IF(IDEB(68).GE.6) THEN
              WRITE(ErrorOut,'(1X,2A,/5X,2I10,6X,1P3E10.3)')
     &          'PHO_EVENT: REJECTION DUE TO CROSS SECTION',
     &          ' (CALL/ACC/EVWGHT(1)/SIG/SIGMAX)',
     &          KEVENT,KACCEP,EVWGHT(1),SIGGEN(3),SIGGEN(4)
              CALL PHO_PREVNT(-1)
            ENDIF
            RETURN
          ENDIF
        ENDIF
        KEVGEN = KEVGEN+1
        SIGGEN(1) = SIGGEN(4)*DBLE(KEVGEN)/DBLE(KEVENT)
        HSWGHT(0) = MAX(1.D0,WG)

        ITRY1 = 0
 50     CONTINUE
          ITRY1 = ITRY1+1
          IF(ITRY1.GT.1) CALL PHO_EVEINI(2,P1,P2,JM1,JM2)

C  sample process
          IPROCE = 0
          CALL PHO_SAMPRO(1,IFPAP(1),IFPAP(2),ECM,PVIRT(1),PVIRT(2),
     &      1.D0,IPROCE)
          IF(IPROCE.EQ.0) THEN
            IF(IDEB(68).GE.4) WRITE(ErrorOut,
     * '(1X,A)') 'PHO_EVENT: ',
     &        'REJECTION BY PHO_SAMPRO (CALL,ECM)',KEVENT,ECM
            IREJ = 50
            RETURN
          ENDIF
C  sampling statistics
          IPRSAM(IPROCE) = IPRSAM(IPROCE)+1

          ITRY2 = 0
 60       CONTINUE
            ITRY2 = ITRY2+1
            IF(ITRY2.GT.1) CALL PHO_EVEINI(2,P1,P2,JM1,JM2)
C  sample number of cut graphs according to IPROCE and
C  generate parton configurations+strings
            CALL PHO_PARTON(IPROCE,JM1,JM2,P1,P2,IREJ)
C  collect statistics
            ISPS = ISPS+KSPOM
            IHPS = IHPS+KHPOM
            ISRS = ISRS+KSREG
            ISTS = ISTS+KSTRG+KHTRG
            ISLS = ISLS+KSLOO+KHLOO
            IDIS = IDIS+MIN(KHDIR,1)
            IDPS = IDPS+KHDPO+KSDPO
            IF((IDIFR1+IDIFR2+IDDPOM.EQ.0).AND.(KHDIR.GT.0))
     &        IDNS(KHDIR) = IDNS(KHDIR)+1
C  rejection?
          IF(IREJ.NE.0) THEN
            IF(IDEB(68).GE.4) THEN
              WRITE(ErrorOut,'(/1X,A,2I5)')
     &          'PHO_EVENT: REJECTION BY PHO_PARTON',ITRY2,IREJ
              CALL PHO_PREVNT(-1)
            ENDIF
            IF((IREJ.EQ.50).AND.(NEV.EQ.1)) THEN
              RETURN
            ENDIF
            IFAIL(1) = IFAIL(1)+1
            IF(ITRY1.GT.5) RETURN
            IF(IREJ.GE.5) THEN
              IF(ISWMDL(2).EQ.0) RETURN
              GOTO 50
            ENDIF
            IF(ITRY2.LT.5) GOTO 60
            GOTO 50
          ENDIF
C  fragmentation of strings

C  FSR and string fragmentation is done separately by DTUNUC routines
C         CALL PHO_STRFRA(IREJ)

C  rejection?
          IF(IREJ.NE.0) THEN
            IFAIL(23) = IFAIL(23)+1
            IF(IDEB(68).GE.4)  THEN
              WRITE(ErrorOut,'(/1X,A,2I5)')
     &          'PHO_EVENT: REJECTION BY PHO_STRFRA',ITRY2,IREJ
              CALL PHO_PREVNT(-1)
            ENDIF
            GOTO 50
          ENDIF
C  check of conservation of quantum numbers
          IF(IDEB(68).GE.-5) THEN
            CALL PHO_CHECK(-1,IREJ)
            IF(IREJ.NE.0) GOTO 50
          ENDIF
C  event now completely processed and accepted
C  acceptance statistics
          IPRACC(IPROCE) = IPRACC(IPROCE)+1
          ISPA = ISPA+KSPOM
          IHPA = IHPA+KHPOM
          ISRA = ISRA+KSREG
          ISTA = ISTA+(KSTRG+KHTRG)
          ISLA = ISLA+(KSLOO+KHLOO)
          IDIA = IDIA+MIN(KHDIR,1)
          IDPA = IDPA+KHDPO+KSDPO
          IF((IDIFR1+IDIFR2.EQ.0).AND.(KHDIR.GT.0))
     &      IDNA(KHDIR) = IDNA(KHDIR)+1
          DO 55 I=1,IPOIX2
            IENACC(IPORES(I)) = IENACC(IPORES(I))+1
 55       CONTINUE
          KACCEP = KACCEP+1

C  debug output (partial / full event listing)
          IF((IDEB(68).EQ.1).AND.(MOD(KACCEP,50).EQ.0))
     &      WRITE(ErrorOut,
     * '(1X,A,2I12)') 'call to PHO_EVENT no',KEVENT,KACCEP
          IF(IDEB(67).GE.10) THEN
            IF(IDEB(67).LE.15) THEN
              CALL PHO_PREVNT(-1)
            ELSE IF(IDEB(67).LE.20) THEN
              CALL PHO_PREVNT(0)
            ELSE IF(IDEB(67).LE.25) THEN
              CALL PHO_PREVNT(1)
            ELSE
              CALL PHO_PREVNT(2)
            ENDIF
          ENDIF
C
C  effective weight
          DO 65 I=1,10
            IF(IPOWGC(I).GT.0) THEN
              HSWGHT(0) = HSWGHT(0)*HSWGHT(I)
            ENDIF
 65       CONTINUE
          IF(IVWGHT(1).EQ.1) THEN
            WG = HSWGHT(0)
            IF(WG.GT.1.01D0) THEN
              IF(EVWGHT(1).LT.1.01D0) THEN
                WRITE(ErrorOut,'(1X,A,2I12,1PE12.3)')
     &            'PHO_EVENT: CROSS SECTION WEIGHT > 1',
     &            KEVENT,KACCEP,WG
                WRITE(ErrorOut,
     * '(5X,A,1P3E11.3)') 'SIGCUR,SIGMAX,EVWGHT(1):',
     &            SIGGEN(3),SIGGEN(4),EVWGHT(1)
              ENDIF
              EVWGHT(1) = HSWGHT(0)
              HSWGHT(0) = 1.D0
            ELSE
              EVWGHT(1) = 1.D0
            ENDIF
          ENDIF

C  effective cross section
          SIGGEN(2) = SIGGEN(4)*DBLE(KACCEP)/DBLE(KEVENT)
          ECMSUM = ECMSUM+ECM
          SIGGEN(3) = SIGGEN(3)*HSWGHT(0)
      ELSE IF(NEV.EQ.-2) THEN


C  ---------------- end of event generation ----------------------

        WRITE(ErrorOut,'(/3(/1X,A),//1X,A,3I12,/1X,A,F12.1)')
     &    '====================================================',
     &    '  --------- SUMMARY OF EVENT GENERATION ----------',
     &    '====================================================',
     &    'CALLED,GENERATED,ACCEPTED EVENTS:',KEVENT,KEVGEN,KACCEP,
     &    'AVERAGE CMS ENERGY:',ECMSUM/DBLE(MAX(1,KACCEP))

C  write out statistics
        IF(KACCEP.GT.0) THEN

          FAC1 = SIGGEN(4)/DBLE(KEVENT)
          FAC2 = FAC/DBLE(KACCEP)
          WRITE(ErrorOut,'(/1X,A,/1X,A)')
     &      'PHO_EVENT: GENERATED AND ACCEPTED EVENTS',
     &      '----------------------------------------'
          WRITE(ErrorOut,'(3X,A)')
     &   'PROCESS, SAMPLED, ACCEPTED, CROSS SECTION (INTERNAL/EXTERNAL)'
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'non.diff.',IPRSAM(1),
     &      IPRACC(1),DBLE(IPRACC(1))*FAC1,DBLE(IPRACC(1))*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'elas sca.',IPRSAM(2),
     &      IPRACC(2),DBLE(IPRACC(2))*FAC1,DBLE(IPRACC(2))*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'qela sca.',IPRSAM(3),
     &      IPRACC(3),DBLE(IPRACC(3))*FAC1,DBLE(IPRACC(3))*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'doub.pom.',IPRSAM(4),
     &      IPRACC(4),DBLE(IPRACC(4))*FAC1,DBLE(IPRACC(4))*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'diff.par1',IPRSAM(5),
     &      IPRACC(5),DBLE(IPRACC(5))*FAC1,DBLE(IPRACC(5))*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'diff.par2',IPRSAM(6),
     &      IPRACC(6),DBLE(IPRACC(6))*FAC1,DBLE(IPRACC(6))*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'doub.dif.',IPRSAM(7),
     &      IPRACC(7),DBLE(IPRACC(7))*FAC1,DBLE(IPRACC(7))*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'dir all  ',IPRSAM(8),
     &      IPRACC(8),DBLE(IPRACC(8))*FAC1,DBLE(IPRACC(8))*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'dir X res',IDNS(1),IDNA(1),
     &      DBLE(IDNA(1))*FAC1,DBLE(IDNA(1))*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'res X dir',IDNS(2),IDNA(2),
     &      DBLE(IDNA(2))*FAC1,DBLE(IDNA(2))*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'dir X dir',IDNS(3),IDNA(3),
     &      DBLE(IDNA(3))*FAC1,DBLE(IDNA(3))*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'soft pom.',ISPS,ISPA,
     &      DBLE(ISPA)*FAC1,DBLE(ISPA)*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'hard pom.',IHPS,IHPA,
     &      DBLE(IHPA)*FAC1,DBLE(IHPA)*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'soft reg.',ISRS,ISRA,
     &      DBLE(ISRA)*FAC1,DBLE(ISRA)*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'enh. trg.',ISTS,ISTA,
     &      DBLE(ISTA)*FAC1,DBLE(ISTA)*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'enh. log.',ISLS,ISLA,
     &      DBLE(ISLA)*FAC1,DBLE(ISLA)*FAC2
          WRITE(ErrorOut,
     * '(3X,A,2I12,1P2E13.3)') 'doub.pom.',IDPS,IDPA,
     &      DBLE(IDPA)*FAC1,DBLE(IDPA)*FAC2
          IF(ISWMDL(14).GT.0) THEN
            WRITE(ErrorOut,
     * '(3X,A,I3)') 'recursive pomeron splitting:',
     &        ISWMDL(14)
            WRITE(ErrorOut,
     * '(5X,A,I12)') '1->2pom-cut :',IENACC(8)
            WRITE(ErrorOut,
     * '(5X,A,I12)') '1->doub-pom :',IENACC(4)
            WRITE(ErrorOut,
     * '(5X,A,I12)') '1->diff-dis1:',IENACC(5)
            WRITE(ErrorOut,
     * '(5X,A,I12)') '1->diff-dis2:',IENACC(6)
            WRITE(ErrorOut,
     * '(5X,A,I12)') '1->doub-diff:',IENACC(7)
          ENDIF
          WRITE(ErrorOut,
     * '(2(/1X,A,1PE12.3)/)') ' sampled cross section (mb)',
     &      SIGGEN(1),'ACCEPTED CROSS SECTION (MB)',SIGGEN(2)

          CALL PHO_REJSTA(-2)
          CALL PHO_SAMPRO(1,IFPAP(1),IFPAP(2),ECM,PVIRT(1),PVIRT(2),
     &      0.D0,-2)
          CALL PHO_PARTON(-2,0,0,P1,P2,IREJ)
C  statistics of hard scattering processes
          WRITE(ErrorOut,'(2(/1X,A))')
     &      'PHO_EVENT: STATISTICS OF HARD SCATTERING PROCESSES',
     &      '--------------------------------------------------'
          DO 43 K=1,4
            IF(MH_TRIED(0,K).GT.0) THEN
              WRITE(ErrorOut,'(/5X,A,I3)')
     &      'PROCESS (ACCEPTED,X-SECTION INTERNAL/EXTERNAL) FOR IP:',K
              DO 47 M=0,MAX_PRO_2
                WRITE(ErrorOut,
     * '(1X,I3,1X,A,2X,2I12,1P2E13.3)') M,PROC(M),
     &            MH_TRIED(M,K),MH_ACC_1(M,K),DBLE(MH_ACC_1(M,K))*FAC1,
     &            DBLE(MH_ACC_2(M,K))*FAC2
 47           CONTINUE
            ENDIF
 43       CONTINUE


        ELSE
          WRITE(ErrorOut,
     * '(/1X,A,I4,/)') 'no output of statistics',KEVENT
        ENDIF
        WRITE(ErrorOut,'(/3(/1X,A)/)')
     &    '======================================================',
     &    '   ------- END OF EVENT GENERATION SUMMARY --------',
     &    '======================================================'
      ELSE
        WRITE(ErrorOut,
     * '(/1X,A,I7)') 'PHO_EVENT:ERROR: unsupported NEV',NEV
      ENDIF

      END



CDECK  ID>, PHO_PARTON
      SUBROUTINE PHO_PARTON(IPROC,JM1,JM2,P1,P2,IREJ)
C********************************************************************
C
C     calculation of complete parton configuration
C
C     input:  IPROC   process ID  1 nondiffractive
C                                 2 elastic
C                                 3 quasi-ela. rho,omega,phi prod.
C                                 4 double Pomeron
C                                 5 single diff 1
C                                 6 single diff 2
C                                 7 double diff diss.
C                                 8 single-resolved / direct photon
C             JM1,2   index of mother particles in /POEVT1/
C
C
C     output: complete parton configuration in /POEVT1/
C             IREJ                1 failure
C                                 0 success
C                                50 rejection due to user cutoffs
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      DIMENSION P1(4),P2(4)

      PARAMETER ( TINY   =  1.D-10 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  table of particle indices for recursive PHOJET calls
      INTEGER MAXIPX
      PARAMETER ( MAXIPX = 100 )
      INTEGER IPOPOS,IPORES,IPOIX1,IPOIX2,IPOIX3
      COMMON /PORECU/ IPOPOS(2,MAXIPX),IPORES(MAXIPX),
     &                IPOIX1,IPOIX2,IPOIX3

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)


      IREJ = 0
C  clear event statistics
      KSPOM = 0
      KHPOM = 0
      KSREG = 0
      KHDIR = 0
      KSTRG = 0
      KHTRG = 0
      KSLOO = 0
      KHLOO = 0
      KHARD = 0
      KSOFT = 0
      KSDPO = 0
      KHDPO = 0

C-------------------------------------------------------------------
C  nondiffractive resolved processes

      IF(IPROC.EQ.1) THEN
C  sample number of interactions
 555    CONTINUE
        IINT = 0
        IP   = 1
C  generate only hard events
        IF(ISWMDL(2).EQ.0) THEN
          MHPOM = 1
          MSPOM = 0
          MSREG = 0
          MHDIR = 0
          HSWGHT(1) = 1.D0
        ELSE
C  minimum bias events
          IPOWGC(1) = 0
 10       CONTINUE
          CALL PHO_SAMPRB(ECM,IP,IINT,JINT,KINT)
          IPOWGC(1) = IPOWGC(1)+1
          MINT = 0
          MHDIR = 0
          MSTRG = 0
          MSLOO = 0
C
C  resolved soft processes: pomeron and reggeon
          MSPOM = IINT
          MSREG = JINT
C  resolved hard process: hard pomeron
          MHPOM = KINT
C  resolved absorptive corrections
          MPTRI = 0
          MPLOO = 0
C  restrictions given by user
          IF(MSPOM.LT.ISWCUT(1)) GOTO 10
          IF(MSREG.LT.ISWCUT(2)) GOTO 10
          IF(MHPOM.LT.ISWCUT(3)) GOTO 10
          HSWGHT(1) = 1.D0/DBLE(IPOWGC(1))
C  ----------------------------
          IF(ISWMDL(15).EQ.0) THEN
            MHPOM = 0
            IF(MSREG.GT.0) THEN
              MSPOM = 0
              MSREG = 1
            ELSE
              MSPOM = 1
              MSREG = 0
            ENDIF
          ELSE IF(ISWMDL(15).EQ.1) THEN
            IF(MHPOM.GT.0) THEN
              MHPOM = 1
              MSPOM = 0
              MSREG = 0
            ELSE IF(MSPOM.GT.0) THEN
              MSPOM = 1
              MSREG = 0
            ELSE
              MSREG = 1
            ENDIF
          ELSE IF(ISWMDL(15).EQ.2) THEN
            MHPOM = MIN(1,MHPOM)
          ELSE IF(ISWMDL(15).EQ.3) THEN
            MSPOM = MIN(1,MSPOM)
          ENDIF
        ENDIF
C  ----------------------------

C  statistics
        ISPS = ISPS+MSPOM
        IHPS = IHPS+MHPOM
        ISRS = ISRS+MSREG
        ISTS = ISTS+MSTRG
        ISLS = ISLS+MSLOO

        IF(IDEB(3).GE.5) WRITE(ErrorOut,'(1X,A,I10,I7,6I4)')
     &    'PHO_PARTON: EV,SP,SR,HP,HD,ET,EL',
     &    KEVENT,MSPOM,MSREG,MHPOM,MHDIR,MPTRI,MPLOO

        ITRY2 = 0
 50     CONTINUE
        ITRY2 = ITRY2+1
        IF(ITRY2.GT.1) CALL PHO_EVEINI(2,P1,P2,JM1,JM2)
        KSPOM = MSPOM
        KSREG = MSREG
        KHPOM = MHPOM
        KHDIR = MHDIR
        KSTRG = MPTRI
        KSLOO = MPLOO

        CALL PHO_STDPAR(JM1,JM2,1,MSPOM,MSREG,MHPOM,MHDIR,IREJ)
        IF(IREJ.NE.0) THEN
          IF(IREJ.EQ.50) RETURN
          IF(IDEB(3).GE.2) THEN
            WRITE(ErrorOut,'(/1X,A,I5)')
     &        'PHO_PARTON: REJECTION BY PHO_STDPAR ',ITRY2
            CALL PHO_PREVNT(-1)
          ENDIF
          RETURN
        ENDIF
        IF(MHPOM.GT.0) THEN
          IDNODF = 3
        ELSE IF(MSPOM.GT.0) THEN
          IDNODF = 2
        ELSE
          IDNODF = 1
        ENDIF
C  check of quantum numbers of parton configurations
        IF(IDEB(3).GE.0) THEN
          CALL PHO_CHECK(1,IREJ)
          IF(IREJ.NE.0) GOTO 50
        ENDIF
C  sample strings to prepare fragmentation
        CALL PHO_STRING(1,IREJ)
        IF(IREJ.NE.0) THEN
          IF(IREJ.EQ.50) RETURN
          IFAIL(30) = IFAIL(30)+1
          IF(IDEB(3).GE.2)  THEN
            WRITE(ErrorOut,'(/1X,A,I5)')
     &        'PHO_PARTON: REJECTION BY PHO_STRING',ITRY2
            CALL PHO_PREVNT(-1)
          ENDIF
          IF(ITRY2.LT.20) GOTO 50
          IF(IDEB(3).GE.1) THEN
            WRITE(ErrorOut,'(/1X,A,I5)')
     &        'PHO_PARTON: REJECTION',ITRY2
            CALL PHO_PREVNT(-1)
          ENDIF
          RETURN
        ENDIF

C  statistics
        ISPA = ISPA+KSPOM
        IHPA = IHPA+KHPOM
        ISRA = ISRA+KSREG
        ISTA = ISTA+KSTRG
        ISLA = ISLA+KSLOO

C-------------------------------------------------------------------
C  elastic scattering / quasi-elastic rho/omega/phi production


      ELSE IF((IPROC.EQ.2).OR.(IPROC.EQ.3)) THEN
        IF(IDEB(3).GE.5) WRITE(ErrorOut,'(1X,A,I10,I4)')
     &    'PHO_PARTON: ELA./Q-ELA.SCA:(EV,IPROC)',KEVENT,IPROC

C  DTUNUC call with special projectile / target: transform into CMS
        IF((IPAMDL(13).GT.0).AND.(IPOIX3.EQ.0))
     &    CALL PHO_DFWRAP(1,JM1,JM2)

        CALL PHO_QELAST(IPROC,JM1,JM2,IREJ)

        IF(IREJ.NE.0) THEN
C  DTUNUC call with special projectile / target: clean up
          IF((IPAMDL(13).GT.0).AND.(IPOIX3.EQ.0))
     &      CALL PHO_DFWRAP(-2,JM1,JM2)
          IF(IDEB(3).GE.2) THEN
            WRITE(ErrorOut,'(/1X,A,I5)')
     &        'PHO_PARTON: REJECTION BY PHO_QELAST',IREJ
            CALL PHO_PREVNT(-1)
          ENDIF
          RETURN
        ENDIF

C  DTUNUC call with special projectile / target: transform back
        IF((IPAMDL(13).GT.0).AND.(IPOIX3.EQ.0))
     &    CALL PHO_DFWRAP(2,JM1,JM2)

C  prepare possible decays
        CALL PHO_STRING(1,IREJ)
        IF(IREJ.NE.0) THEN
          IF(IREJ.EQ.50) RETURN
          IFAIL(30) = IFAIL(30)+1
          RETURN
        ENDIF

C---------------------------------------------------------------------
C  double Pomeron scattering

      ELSE IF(IPROC.EQ.4) THEN
        MSOFT = 0
        MHARD = 0
        IF(IDEB(3).GE.5) WRITE(ErrorOut,'(1X,A,I10)')
     &      'PHO_PARTON: EV,DOUBLE-POMERON SCATTERING',KEVENT
        IDPS = IDPS+1
        ITRY2 = 0
 60     CONTINUE
        ITRY2 = ITRY2+1
        IF(ITRY2.GT.1) CALL PHO_EVEINI(2,P1,P2,JM1,JM2)
C
        CALL PHO_CDIFF(JM1,JM2,MSOFT,MHARD,1,IREJ)
        IF(IREJ.NE.0) THEN
          IF(IDEB(3).GE.2) THEN
            WRITE(ErrorOut,'(/1X,A,I5)')
     &        'PHO_PARTON: REJECTION BY PHO_CDIFF',IREJ
            CALL PHO_PREVNT(-1)
          ENDIF
          RETURN
        ENDIF
C  check of quantum numbers of parton configurations
        IF(IDEB(3).GE.0) THEN
          CALL PHO_CHECK(1,IREJ)
          IF(IREJ.NE.0) GOTO 60
        ENDIF
C  sample strings to prepare fragmentation
        CALL PHO_STRING(1,IREJ)
        IF(IREJ.NE.0) THEN
          IF(IREJ.EQ.50) RETURN
          IFAIL(30) = IFAIL(30)+1
          IF(IDEB(3).GE.2) THEN
            WRITE(ErrorOut,'(/1X,A,I5)')
     &        'PHO_PARTON: REJECTION BY PHO_STRING',ITRY2
            CALL PHO_PREVNT(-1)
          ENDIF
          IF(ITRY2.LT.10) GOTO 60
          WRITE(ErrorOut,
     * '(/1X,A,I5)') 'PHO_PARTON: rejection',ITRY2
          CALL PHO_PREVNT(-1)
          RETURN
        ENDIF
        IDPA = IDPA+1

C-----------------------------------------------------------------------
C  single / double diffraction dissociation

      ELSE IF((IPROC.GE.5).AND.(IPROC.LE.7)) THEN
        MSOFT = 0
        MHARD = 0
        IF(IDEB(3).GE.5) WRITE(ErrorOut,'(1X,A,I10,2I4)')
     &    'PHO_PARTON: EV,DIFFRACTION',KEVENT,IPAR1,IPAR2
        IF(IPROC.EQ.5) ID1S = ID1S+1
        IF(IPROC.EQ.6) ID2S = ID2S+1
        IF(IPROC.EQ.7) ID3S = ID3S+1
        ITRY2 = 0
 70     CONTINUE
        ITRY2 = ITRY2+1
        IF(ITRY2.GT.1) CALL PHO_EVEINI(2,P1,P2,JM1,JM2)
        IPAR1 = 1
        IPAR2 = 1
        IF(IPROC.EQ.5) IPAR2 = 0
        IF(IPROC.EQ.6) IPAR1 = 0
C  calculate rapidity gap survival probability
        SPROB = 1.D0
        IF(ECM.GT.10.D0) THEN
          IF((IPAR1.GE.1).AND.(IPAR2.EQ.0)) THEN
            IF(SIGTR1(1).LT.1.D-10) THEN
              SPROB = 1.D0
            ELSE
              SPROB = SIGHSD(1)/(SIGTR1(1)-2.D0*(SIGDPO(1)+SIGDPO(2)))
            ENDIF
          ELSE IF((IPAR1.EQ.0).AND.(IPAR2.GE.1)) THEN
            IF(SIGTR2(1).LT.1.D-10) THEN
              SPROB = 1.D0
            ELSE
              SPROB = SIGHSD(2)/(SIGTR2(1)-2.D0*(SIGDPO(1)+SIGDPO(3)))
            ENDIF
          ELSE IF((IPAR1.GE.1).AND.(IPAR2.GE.1)) THEN
            IF(SIGLOO.LT.1.D-10) THEN
              SPROB = 1.D0
            ELSE
              SPROB = SIGHDD/SIGLOO
            ENDIF
          ENDIF
        ENDIF
**sr
* temporary patch, r.e. 8.6.99
        SPROB = 1.D0
**

C  DTUNUC call with special projectile / target: transform into CMS
        IF((IPAMDL(13).GT.0).AND.(IPOIX3.EQ.0))
     &    CALL PHO_DFWRAP(1,JM1,JM2)

        CALL PHO_DIFDIS(IPAR1,IPAR2,JM1,JM2,SPROB,0,MSOFT,MHARD,IREJ)

        IF(IREJ.NE.0) THEN
C  DTUNUC call with special projectile / target: clean up
          IF((IPAMDL(13).GT.0).AND.(IPOIX3.EQ.0))
     &      CALL PHO_DFWRAP(-2,JM1,JM2)
          IF(IDEB(3).GE.2) THEN
            WRITE(ErrorOut,'(/1X,A,I5)')
     &        'PHO_PARTON: REJECTION BY PHO_DIFDIS',IREJ
            CALL PHO_PREVNT(-1)
          ENDIF
          RETURN
        ENDIF

C  DTUNUC call with special projectile / target: transform back
        IF((IPAMDL(13).GT.0).AND.(IPOIX3.EQ.0))
     &    CALL PHO_DFWRAP(2,JM1,JM2)

C  check of quantum numbers of parton configurations
        IF(IDEB(3).GE.0) THEN
          CALL PHO_CHECK(1,IREJ)
          IF(IREJ.NE.0) GOTO 70
        ENDIF
C  sample strings to prepare fragmentation
        CALL PHO_STRING(1,IREJ)
        IF(IREJ.NE.0) THEN
          IF(IREJ.EQ.50) RETURN
          IFAIL(30) = IFAIL(30)+1
          IF(IDEB(3).GE.2) THEN
            WRITE(ErrorOut,'(/1X,A,I5)')
     &        'PHO_PARTON: REJECTION BY PHO_STRING',ITRY2
            CALL PHO_PREVNT(-1)
          ENDIF
          IF(ITRY2.LT.10) GOTO 70
          WRITE(ErrorOut,'(/1X,A,I5)')
     &      'PHO_PARTON: REJECTION',ITRY2
          CALL PHO_PREVNT(-1)
          RETURN
        ENDIF
        IF(IPROC.EQ.5) ID1A = ID1A+1
        IF(IPROC.EQ.6) ID2A = ID2A+1
        IF(IPROC.EQ.7) ID3A = ID3A+1

C-----------------------------------------------------------------------
C  single / double direct processes

      ELSE IF(IPROC.EQ.8) THEN
        MSREG = 0
        MSPOM = 0
        MHPOM = 0
        MHDIR = 1
        IF(IDEB(3).GE.5) THEN
          WRITE(ErrorOut,
     * '(1X,A,I10)') 'PHO_PARTON: EV,direct proc',KEVENT
        ENDIF
        IDIS = IDIS+MHDIR
        ITRY2 = 0
 80     CONTINUE
        ITRY2 = ITRY2+1
        IF(ITRY2.GT.1) CALL PHO_EVEINI(2,P1,P2,JM1,JM2)
        KSPOM = MSPOM
        KSREG = MSREG
        KHPOM = MHPOM
        KHDIR = 4

        CALL PHO_STDPAR(JM1,JM2,1,MSPOM,MSREG,MHPOM,MHDIR,IREJ)
        IF(IREJ.NE.0) THEN
          IF(IREJ.EQ.50) RETURN
          IF(IDEB(3).GE.2) THEN
            WRITE(ErrorOut,'(/1X,A,I5)')
     &        'PHO_PARTON: REJECTION BY PHO_STDPAR',ITRY2
            CALL PHO_PREVNT(-1)
          ENDIF
          RETURN
        ENDIF
        IDNODF = 4
C  check of quantum numbers of parton configurations
        IF(IDEB(3).GE.0) THEN
          CALL PHO_CHECK(1,IREJ)
          IF(IREJ.NE.0) GOTO 80
        ENDIF
C  sample strings to prepare fragmentation
        CALL PHO_STRING(1,IREJ)
        IF(IREJ.NE.0) THEN
          IF(IREJ.EQ.50) RETURN
          IFAIL(30) = IFAIL(30)+1
          IF(IDEB(3).GE.2) THEN
            WRITE(ErrorOut,'(/1X,A,I5)')
     &        'PHO_PARTON: REJECTION BY PHO_STRING',ITRY2
            CALL PHO_PREVNT(-1)
          ENDIF
          IF(ITRY2.LT.10) GOTO 80
          WRITE(ErrorOut,
     * '(/1X,A,I5)') 'PHO_PARTON: rejection',ITRY2
          CALL PHO_PREVNT(-1)
          RETURN
        ENDIF
        IF(IPROC.EQ.5) ID1A = ID1A+1
        IF(IPROC.EQ.6) ID2A = ID2A+1
        IF(IPROC.EQ.7) ID3A = ID3A+1
        IDIA = IDIA+MHDIR

C-----------------------------------------------------------------------
C  initialize control statistics

      ELSE IF(IPROC.EQ.-1) THEN
        CALL PHO_SAMPRB(ECM,-1,0,0,0)
        CALL PHO_STDPAR(-1,0,0,0,0,0,0,IREJ)
        CALL PHO_SEAFLA(-1,0,0,DUM)
        IF((IFPAP(1).EQ.22).OR.(IFPAP(2).EQ.22))
     &    CALL PHO_QELAST(-1,1,2,0)
        ISPS = 0
        ISPA = 0
        ISRS = 0
        ISRA = 0
        IHPS = 0
        IHPA = 0
        ISTS = 0
        ISTA = 0
        ISLS = 0
        ISLA = 0
        ID1S = 0
        ID1A = 0
        ID2S = 0
        ID2A = 0
        ID3S = 0
        ID3A = 0
        IDPS = 0
        IDPA = 0
        IDIS = 0
        IDIA = 0
        CALL PHO_STRING(-1,IREJ)
        CALL PHO_DIFDIS(0,0,0,0,0.D0,-1,0,0,IREJ)
        RETURN

C-----------------------------------------------------------------------
C  produce statistics summary

      ELSE IF(IPROC.EQ.-2) THEN
        IF(ISWMDL(2).NE.0) CALL PHO_SAMPRB(ECM,-2,0,0,0)
        IF(IDEB(3).GE.0) THEN
          WRITE(ErrorOut,'(/1X,A,/1X,A)')
     &      'PHO_PARTON: INTERNAL STATISTICS ON PARTON CONFIGURATIONS',
     &      '--------------------------------------------------------'
          WRITE(ErrorOut,
     * '(5X,A)') 'process          sampled      accepted'
          WRITE(ErrorOut,'(5X,A,2I12)') 'soft pom.',ISPS,ISPA
          WRITE(ErrorOut,'(5X,A,2I12)') 'hard pom.',IHPS,IHPA
          WRITE(ErrorOut,'(5X,A,2I12)') 'soft reg.',ISRS,ISRA
          WRITE(ErrorOut,'(5X,A,2I12)') 'enh. tri.',ISTS,ISTA
          WRITE(ErrorOut,'(5X,A,2I12)') 'enh. loo.',ISLS,ISLA
          WRITE(ErrorOut,'(5X,A,2I12)') 'diff.pa1.',ID1S,ID1A
          WRITE(ErrorOut,'(5X,A,2I12)') 'diff.pa2.',ID2S,ID2A
          WRITE(ErrorOut,'(5X,A,2I12)') 'doub.dif.',ID3S,ID3A
          WRITE(ErrorOut,'(5X,A,2I12)') 'doub.pom.',IDPS,IDPA
          WRITE(ErrorOut,'(5X,A,2I12/)') 'dir.phot.',IDIS,IDIA
        ENDIF
        CALL PHO_STDPAR(-2,0,0,0,0,0,0,IREJ)
        IF((IFPAP(1).EQ.22).OR.(IFPAP(2).EQ.22))
     &    CALL PHO_QELAST(-2,1,2,0)
        CALL PHO_STRING(-2,IREJ)
        CALL PHO_DIFDIS(0,0,0,0,0.D0,-2,0,0,IREJ)
        CALL PHO_SEAFLA(-2,0,0,DUM)
        RETURN
      ELSE
        WRITE(ErrorOut,'(1X,A,I2)')
     &    'PARTON:ERROR: UNKNOWN PROCESS ID ',IPROC
        STOP
      ENDIF

      END


CDECK  ID>, PHO_MCINI
      SUBROUTINE PHO_MCINI
C********************************************************************
C
C     initialization of MC event generation
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
ccc     &&&&&&&&&& KK
      integer icon
ccc     &&&&&&&&
      SAVE

      PARAMETER ( PIMASS =  0.13D0,
     &            TINY   =  1.D-10 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)

C  interpolation tables for hard cross section and MC selection weights
      INTEGER MAX_TAB_E,MAX_TAB_Q2,MAX_PRO_TAB
      PARAMETER ( MAX_TAB_E = 20, MAX_TAB_Q2 = 10, MAX_PRO_TAB = 16 )
      INTEGER IH_Q2A_UP,IH_Q2B_UP,IH_ECM_UP
      DOUBLE PRECISION HFAC_TAB,HWGX_TAB,HSIG_TAB,HDPT_TAB,
     &  HQ2A_TAB,HQ2B_TAB,HECM_TAB
      COMMON /POHTAB/
     &  HFAC_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HWGX_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HSIG_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HDPT_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HQ2A_TAB(1:MAX_TAB_Q2,0:4),HQ2B_TAB(1:MAX_TAB_Q2,0:4),
     &  HECM_TAB(1:MAX_TAB_E,0:4),
     &  IH_Q2A_UP(0:4),IH_Q2B_UP(0:4),IH_ECM_UP(0:4)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)

C  cut probability distribution
      INTEGER IEETA1,IIMAX,KKMAX
      PARAMETER( IEETA1=20, IIMAX=20, KKMAX=20 )
      INTEGER IEEMAX,IMAX,KMAX
      REAL PROB
      DOUBLE PRECISION EPTAB
      COMMON /POPROB/ PROB(4,IEETA1,0:IIMAX,0:KKMAX),EPTAB(4,IEETA1),
     &                IEEMAX,IMAX,KMAX

C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX


      CHARACTER*15 PHO_PNAME
      DIMENSION ECMF(4)

      DATA  XMPOM / 0.766D0 /

C  initialize fragmentation
      CALL PHO_FRAINI(ISWMDL(6))

C  reset interpolation tables
      DO 50 I=1,4
        DO 60 J=1,10
          DO 70 K=1,70
            SIGTAB(I,K,J) = 0.D0
 70       CONTINUE
          SIGECM(I,J) = 0.D0
 60     CONTINUE
 50   CONTINUE

C  max. number of allowed colors (large N expansion)
      IC1 = 0
      IC2 = 10000
      CALL PHO_SELCOL(IC1,IC2,0,0,0,0,-1)

C  lower energy limit of initialization
      ETABLO = PARMDL(19)
      IF(ECM.LE.5.D0) ETABLO = MIN(2.5D0,ETABLO)

      WRITE(ErrorOut,'(/,1X,A,2F12.1)')
     &  'PHO_MCINI: SELECTED ENERGY RANGE (SQRT(S))',ETABLO,ECM
      WRITE(ErrorOut,'(5X,A,A,F7.3,E15.4)')
     &  'PARTICLE 1 (NAME,MASS,VIRTUALITY): ',PHO_PNAME(IFPAP(1),1),
     &  PMASS(1),PVIRT(1)
      WRITE(ErrorOut,'(5X,A,A,F7.3,E15.4)')
     &  'PARTICLE 2 (NAME,MASS,VIRTUALITY): ',PHO_PNAME(IFPAP(2),1),
     &  PMASS(2),PVIRT(2)

C  cuts on probabilities of multiple interactions
      IMAX = MIN(IPAMDL(32),IIMAX)
      KMAX = MIN(IPAMDL(33),KKMAX)
      AH = 2.D0*PTCUT(1)/ECM
      IMAX = MAX(5,MIN(IMAX,INT(ECM/2.0D0)))
      KMAX = MIN(KMAX,1+INT(0.9*1.D0/AH))

C  hard interpolation table
      ECMF(1) = ECM
      ECMF(2) = 0.9D0*ECMF(1)
      ECMF(3) = ECMF(2)
      ECMF(4) = ECMF(2)
      DO K=1,4
        IH_ECM_UP(K) = MIN(IPAMDL(30),MAX_TAB_E)
        IF(ECMF(K).LT.100.D0) IH_ECM_UP(K) = MIN(IH_ECM_UP(K),15)
        IF(ECMF(K).LT.50.D0)  IH_ECM_UP(K) = MIN(IH_ECM_UP(K),10)
        IF(ECMF(K).LT.10.D0)  IH_ECM_UP(K) = MIN(IH_ECM_UP(K),5)
      ENDDO

C  initialization of hard scattering for all channels and cutoffs
      IF(HSWCUT(5).GT.PARMDL(36))  CALL PHO_HARMCI(-1,ECMF(1))
      I0 = 4
      IF(ISWMDL(2).EQ.0) I0 = 1
      DO 110 I=I0,1,-1
        CALL PHO_HARMCI(I,ECMF(I))
 110  CONTINUE

C  dimension of interpolation table of cut probabilities
      IEEMAX = MIN(IPAMDL(31),IEETA1)
      IF(ECM.LT.100.D0) IEEMAX = MIN(IEEMAX,15)
      IF(ECM.LT.50.D0)  IEEMAX = MIN(IEEMAX,10)
      IF(ECM.LT.10.D0)  IEEMAX = MIN(IEEMAX,5)
      ISIMAX = IEEMAX

C  calculate probability distribution
      I0 = 4
      IFT1 = IFPAP(1)
      IFT2 = IFPAP(2)
      XMT1 = PMASS(1)
      XMT2 = PMASS(2)
      XVT1 = PVIRT(1)
      XVT2 = PVIRT(2)
      IF(ISWMDL(2).EQ.0) I0 = 1
      DO 150 IP=I0,1,-1
      ECMPRO = ECMF(IP)*1.001D0
      IF(IP.EQ.4) THEN
        IFPAP(1) = 990
        IFPAP(2) = 990
        PMASS(1) = XMPOM
        PMASS(2) = XMPOM
        PVIRT(1) = 0.D0
        PVIRT(2) = 0.D0
      ELSE IF(IP.EQ.3) THEN
        IFPAP(1) = IFT2
        IFPAP(2) = 990
        PMASS(1) = XMT2
        PMASS(2) = XMPOM
        PVIRT(1) = XVT2
        PVIRT(2) = 0.D0
      ELSE IF(IP.EQ.2) THEN
        IFPAP(1) = IFT1
        IFPAP(2) = 990
        PMASS(1) = XMT1
        PMASS(2) = XMPOM
        PVIRT(1) = XVT1
        PVIRT(2) = 0.D0
      ELSE
        IFPAP(1) = IFT1
        IFPAP(2) = IFT2
        PMASS(1) = XMT1
        PMASS(2) = XMT2
        PVIRT(1) = XVT1
        PVIRT(2) = XVT2
      ENDIF
      IF(IEEMAX.GT.1) THEN
        IF(IP.EQ.1) THEN
          ELMIN = LOG(ETABLO)
        ELSE
          ELMIN = LOG(2.5D0)
        ENDIF
        EDELTA = (LOG(ECMPRO)-ELMIN)/DBLE(MAX(1,IEEMAX-1))
        DO 100 I=1,IEEMAX
          ECMPRO = EXP(ELMIN+DBLE(I-1)*EDELTA)
          CALL PHO_PRBDIS(IP,ECMPRO,I, icon)  !   &&&&&&&&& kk
cc          &&&&&&&&&  KK ;use previous value if neg.cross.
          if(icon .ne. 0)  then
             call PHO_PRBDIS2(IP, ECMPRO,I)
          endif
cc         &&&&&&&&
 100    CONTINUE
      ELSE
        CALL PHO_PRBDIS(IP,ECMPRO,1, icon)  ! &&&&&&&& kk
ccc     &&&&&&&& kk
        if(icon .ne. 0) then
           call cerrorMsg(
     *     'negative crossection could not be avoided',0)
        endif
ccc     &&&&&&&&
      ENDIF

C  debug output of cross section tables
      IF(((IDEB(62).GE.0).AND.(IP.EQ.1)).OR.(IDEB(62).GE.3)) THEN
      IF((PVIRT(1)+PVIRT(2).GT.0.01D0).AND.(IDEB(62).EQ.0)) GOTO 201
      WRITE(ErrorOut,'(/1X,A,I3/1X,A,/1X,A)')
     &'TABLE OF TOTAL CROSS SECTIONS (MB) FOR PARTICLE COMBINATION',IP,
     &' ECM    SIGTOT  SIGELA  SIGINE  SIGQEL  SIGSD1  SIGSD2  SIGDD',
     &'-------------------------------------------------------------'
      DO 200 I=1,IEEMAX
        WRITE(ErrorOut,
     * '(1X,1P,8E9.2)') SIGECM(IP,I),SIGTAB(IP,1,I),
     &    SIGTAB(IP,2,I),SIGTAB(IP,28,I),SIGTAB(IP,3,I),
     &    SIGTAB(IP,30,I)+SIGTAB(IP,32,I),
     &    SIGTAB(IP,31,I)+SIGTAB(IP,33,I),
     &    SIGTAB(IP,34,I)+SIGTAB(IP,35,I)
 200  CONTINUE
 201  CONTINUE
      IF(IDEB(62).GE.2) THEN
      WRITE(ErrorOut,'(/1X,A,I3/1X,A,/1X,A)')
     &'TABLE OF PARTIAL X-SECTIONS (MB) FOR PARTICLE COMBINATION',IP,
     &' ECM    SIGSD1L SIGSD1H SIGSD2L SIGSD2H SIGDDL  SIGDDH  SIGCDF',
     &'--------------------------------------------------------------'
      DO 205 I=1,IEEMAX
        WRITE(ErrorOut,
     * '(1X,1P,8E9.2)') SIGECM(IP,I),SIGTAB(IP,30,I),
     &    SIGTAB(IP,32,I),SIGTAB(IP,31,I),SIGTAB(IP,33,I),
     &    SIGTAB(IP,34,I),SIGTAB(IP,35,I),SIGTAB(IP,36,I)
 205  CONTINUE
      ENDIF
      IF(IDEB(62).GE.2) THEN
      WRITE(ErrorOut,'(/1X,A,I3/1X,A,/1X,A)')
     &'TABLE OF BORN GRAPH X-SECTIONS (MB) FOR PARTICLE COMBINATION',IP,
     &' ECM    SIGSVDM SIGHRES SIGHDIR SIGTR1  SIGTR2  SIGLOO SIGDPO',
     &'-------------------------------------------------------------'
      DO 210 I=1,IEEMAX
        WRITE(ErrorOut,'(1X,1P,8E9.2)') SIGECM(IP,I),
     &    SIGTAB(IP,56,I)+SIGTAB(IP,57,I),SIGTAB(IP,58,I),
     &    SIGTAB(IP,59,I),SIGTAB(IP,60,I)+SIGTAB(IP,61,I),
     &    SIGTAB(IP,62,I)+SIGTAB(IP,63,I),SIGTAB(IP,64,I),
     &    SIGTAB(IP,65,I)+SIGTAB(IP,66,I)+SIGTAB(IP,67,I)
     &    +SIGTAB(IP,68,I)
 210  CONTINUE
      WRITE(ErrorOut,'(/1X,A,I3/1X,A,/1X,A)')
     &'TABLE OF UNITARIZED X-SECTIONS (MB) FOR PARTICLE COMBINATION',IP,
     &' ECM    SIGSVDM SIGHVDM  SIGTR1  SIGTR2  SIGLOO SIGDPO  SLOPE',
     &'-------------------------------------------------------------'
      DO 215 I=1,IEEMAX
        WRITE(ErrorOut,
     * '(1X,1P,8E9.2)') SIGECM(IP,I),SIGTAB(IP,79,I),
     &    SIGTAB(IP,80,I),SIGTAB(IP,32,I),SIGTAB(IP,33,I),
     &    SIGTAB(IP,35,I),SIGTAB(IP,36,I),SIGTAB(IP,39,I)
 215  CONTINUE
      ENDIF
      IF(IDEB(62).GE.1) THEN
      WRITE(ErrorOut,'(/1X,A,/1X,A,2I4,/1X,A,/1X,A)')
     &'TABLE OF EXPECTED AVERAGE NUMBER OF CUTS IN NON-DIFF EVENTS:',
     &'       FOR MAX. NUMBER OF CUTS SOFT/HARD:',IMAX,KMAX,
     &' ECM   PTCUT   SIGNDF   POM-S   POM-H   REG-S',
     &'---------------------------------------------'
      DO 220 I=1,IEEMAX
        WRITE(ErrorOut,
     * '(1X,1P,6E10.3)') SIGECM(IP,I),SIGTAB(IP,77,I),
     &    SIGTAB(IP,78,I),SIGTAB(IP,74,I),SIGTAB(IP,75,I),
     &    SIGTAB(IP,76,I)
 220  CONTINUE
      IF(IP.EQ.1) THEN
        WRITE(ErrorOut,'(/1X,A,/1X,A,/1X,A)')
     &  'TABLE OF RAPIDITY GAP SURVIVAL PROBABILITY (HIGH-MASS DIFF.):',
     &  ' ECM    SPRO-SD1     SPRO-SD2    SPRO-DD    SPRO-CD',
     &  '---------------------------------------------------'
        DO 230 I=1,IEEMAX
          IF(SIGECM(IP,I).GT.10.D0) THEN
            SPRSD1 = SIGTAB(IP,32,I)/(SIGTAB(IP,60,I)
     &               -2.D0*(SIGTAB(IP,65,I)+SIGTAB(IP,66,I)))
            SPRSD2 = SIGTAB(IP,33,I)/(SIGTAB(IP,62,I)
     &               -2.D0*(SIGTAB(IP,65,I)+SIGTAB(IP,67,I)))
            SPRDD  = SIGTAB(IP,35,I)/(SIGTAB(IP,64,I)+SIGTAB(IP,61,I)
     &               +SIGTAB(IP,63,I)-2.D0*(SIGTAB(IP,66,I)
     &               +SIGTAB(IP,67,I)+2.D0*SIGTAB(IP,68,I)))
            SPRCDF = SIGTAB(IP,36,I)/(SIGTAB(IP,65,I)+SIGTAB(IP,66,I)
     &               +SIGTAB(IP,67,I)+SIGTAB(IP,68,I))
            WRITE(ErrorOut,'(1X,1P,5E10.3)') SIGECM(IP,I),
     &        SPRSD1,SPRSD2,SPRDD,SPRCDF
          ENDIF
 230    CONTINUE
      ENDIF
      ENDIF
      ENDIF
 150  CONTINUE

C  simulate only hard scatterings
      IF(ISWMDL(2).EQ.0) THEN
        WRITE(ErrorOut,'(2(/1X,A))')
     &    'WARNING: GENERATION OF HARD SCATTERINGS ONLY!',
     &    '============================================='
        DO 151 I=2,7
          IPRON(I,1) = 0
 151    CONTINUE
        DO 152 K=2,4
          DO 153 I=1,15
            IPRON(I,K) = 0
 153      CONTINUE
 152    CONTINUE
        SIGGEN(4) = 0.D0
        DO 160 I=1,IEEMAX
          SIGMAX = 0.D0
          IF(IPRON(1,1).EQ.1) SIGMAX = SIGTAB(1,58,I)
          IF(IPRON(8,1).EQ.1) SIGMAX = SIGMAX+SIGTAB(1,59,I)
          IF(SIGMAX.GT.SIGGEN(4)) THEN
            ISIGM = I
            SIGGEN(4) = SIGMAX
          ENDIF
 160    CONTINUE
      ELSE
        WRITE(ErrorOut,'(2(/1X,A))')
     &    'ACTIVATED PROCESSES, CROSS SECTION',
     &    '----------------------------------'
        WRITE(ErrorOut,'(5X,A,I3,2X,3I3)')
     &    '  NONDIFFR. RESOLVED PROCESSES',(IPRON(1,K),K=1,4)
        WRITE(ErrorOut,'(5X,A,I3,2X,3I3)')
     &    '            ELASTIC SCATTERING',(IPRON(2,K),K=1,4)
        WRITE(ErrorOut,'(5X,A,I3,2X,3I3)')
     &    'QELAST. VECTORMESON PRODUCTION',(IPRON(3,K),K=1,4)
        WRITE(ErrorOut,'(5X,A,I3,2X,3I3)')
     &    '      DOUBLE POMERON PROCESSES',(IPRON(4,K),K=1,4)
        WRITE(ErrorOut,'(5X,A,I3,2X,3I3)')
     &    ' SINGLE DIFFRACT. PARTICLE (1)',(IPRON(5,K),K=1,4)
        WRITE(ErrorOut,'(5X,A,I3,2X,3I3)')
     &    ' SINGLE DIFFRACT. PARTICLE (2)',(IPRON(6,K),K=1,4)
        WRITE(ErrorOut,'(5X,A,I3,2X,3I3)')
     &    '    DOUBLE DIFFRACT. PROCESSES',(IPRON(7,K),K=1,4)
        WRITE(ErrorOut,'(5X,A,I3,2X,3I3)')
     &    '       DIRECT PHOTON PROCESSES',(IPRON(8,K),K=1,4)

C  calculate effective cross section
        SIGGEN(4) = 0.D0
        DO 165 I=1,IEEMAX
          CALL PHO_CSINT(1,IFPAP(1),IFPAP(2),-1,-1,SIGECM(1,I),
     &                PVIRT(1),PVIRT(2))
          SIGMAX = 0.D0
          IF(ISWMDL(2).GE.1) THEN
            IF(IPRON(1,1).EQ.1) SIGMAX = SIGTOT-SIGELA-SIGVM(0,0)
     &        -SIGCDF(0)-SIGLSD(1)-SIGHSD(1)-SIGLSD(2)-SIGHSD(2)
     &        -SIGLDD-SIGHDD-SIGDIR
            IF(IPRON(2,1).EQ.1) SIGMAX = SIGMAX+SIGELA
            IF(IPRON(3,1).EQ.1) SIGMAX = SIGMAX+SIGVM(0,0)
            IF(IPRON(4,1).EQ.1) SIGMAX = SIGMAX+SIGCDF(0)
            IF(IPRON(5,1).EQ.1) SIGMAX = SIGMAX+SIGLSD(1)+SIGHSD(1)
            IF(IPRON(6,1).EQ.1) SIGMAX = SIGMAX+SIGLSD(2)+SIGHSD(2)
            IF(IPRON(7,1).EQ.1) SIGMAX = SIGMAX+SIGLDD+SIGHDD
            IF(IPRON(8,1).EQ.1) SIGMAX = SIGMAX+SIGDIR
          ELSE
            IF(IPRON(1,1).EQ.1) SIGMAX = SIGHAR
            IF(IPRON(8,1).EQ.1) SIGMAX = SIGMAX+SIGDIR
          ENDIF
          IF(SIGMAX.GT.SIGGEN(4)) THEN
            ISIGM = I
            SIGGEN(4) = SIGMAX
          ENDIF
 165    CONTINUE
      ENDIF

C  debug output
      IF(SIGGEN(4).LT.1.D-20) THEN
        WRITE(ErrorOut,'(//1X,A)')
     &  'PHO_MCINI:ERROR: SELECTED PROCESSES HAVE VANISHING X-SECTION'
        STOP
      ENDIF
      WRITE(ErrorOut,
     * '(3X,A,1P3E11.4)') 'maximum search (Elow/Eup/Epeak)',
     &  SIGECM(1,1),SIGECM(1,IEEMAX),SIGECM(1,ISIGM)
      WRITE(ErrorOut,
     * '(11X,A,1PE12.4,/)') 'max. cross section (mb)',SIGGEN(4)

      END


CDECK  ID>, PHO_REJSTA
      SUBROUTINE PHO_REJSTA(IMODE)
C********************************************************************
C
C     MC rejection counting
C
C     input IMODE    -1   initialization
C                    -2   output of statistics
C
C********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)


      INTEGER IMODE

      INTEGER I

C  initialization
      IF(IMODE.EQ.-1) THEN
        DO 100 I=1,NMXJ
          IFAIL(I) = 0
 100    CONTINUE
C
        REJTIT(1)  = 'PARTON ALL'
        REJTIT(2)  = 'STDPAR ALL'
        REJTIT(3)  = 'STDPAR DPO'
        REJTIT(4)  = 'POMSCA ALL'
        REJTIT(5)  = 'POMSCA INT'
        REJTIT(6)  = 'POMSCA KIN'
        REJTIT(7)  = 'DIFDIS ALL'
        REJTIT(8)  = 'POSPOM ALL'
        REJTIT(9)  = 'HRES.DIF.1'
        REJTIT(10) = 'HDIR.DIF.1'
        REJTIT(11) = 'HRES.DIF.2'
        REJTIT(12) = 'HDIR.DIF.2'
        REJTIT(13) = 'DIFDIS INT'
        REJTIT(14) = 'HADRON SP2'
        REJTIT(15) = 'HADRON SP3'
        REJTIT(16) = 'HARDIR ALL'
        REJTIT(17) = 'HARDIR INT'
        REJTIT(18) = 'HARDIR KIN'
        REJTIT(19) = 'MCHECK BAR'
        REJTIT(20) = 'MCHECK MES'
        REJTIT(21) = 'DIF.DISS.1'
        REJTIT(22) = 'DIF.DISS.2'
        REJTIT(23) = 'STRFRA ALL'
        REJTIT(24) = 'MSHELL CHA'
        REJTIT(25) = 'PARTPT SOF'
        REJTIT(26) = 'PARTPT HAR'
        REJTIT(27) = 'INTRINS KT'
        REJTIT(28) = 'HACHEK DIR'
        REJTIT(29) = 'HACHEK RES'
        REJTIT(30) = 'STRING ALL'
        REJTIT(31) = 'POMSCA INT'
        REJTIT(32) = 'DIFF SLOPE'
        REJTIT(33) = 'GLU2QU ALL'
        REJTIT(34) = 'MASCOR ALL'
        REJTIT(35) = 'PARCOR ALL'
        REJTIT(36) = 'MSHELL PAR'
        REJTIT(37) = 'MSHELL ALL'
        REJTIT(38) = 'POMCOR ALL'
        REJTIT(39) = 'DB-POM KIN'
        REJTIT(40) = 'DB-POM ALL'
        REJTIT(41) = 'SOFTXX ALL'
        REJTIT(42) = 'SOFTXX PSP'

C  write output
      ELSE IF(IMODE.EQ.-2) THEN
        WRITE(ErrorOut,
     * '(/,1X,A,/,1X,A)') 'PHO_REJSTA: rejection statistics',
     &                             '--------------------------------'
        DO 300 I=1,NMXJ
          IF(IFAIL(I).GT.0)
     &      WRITE(ErrorOut,
     * '(1X,I3,1X,A,5X,I15)') I,REJTIT(I),IFAIL(I)
 300    CONTINUE
      ELSE
        WRITE(ErrorOut,
     * '(1X,A,I3)') 'PHO_REJSTA: invalid mode ',IMODE
      ENDIF

      END


CDECK  ID>, PHO_POSPOM
      SUBROUTINE PHO_POSPOM(IP,IND1,IND2,IGEN,IPOM,KCUT,ISWAP,IREJ)
C***********************************************************************
C
C     registration of one cut pomeron (soft/semihard)
C
C     input:   IP      particle combination the pomeron belongs to
C              IND1,2  position of X values in /POSOFT/
C                      1 corresponds to a valence-pomeron
C              IGEN    production process of mother particles
C              IPOM    pomeron number
C              KCUT    total number of cut pomerons and reggeons
C
C     output:  ISWAP   exchange of x values
C              IND1,2  increased by the number of partons belonging
C                      to the generated pomeron cut
C              IREJ    success/failure
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS   =  1.D-8 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX

C  light-cone x fractions and c.m. momenta of soft cut string ends
      INTEGER MAXSOF
      PARAMETER ( MAXSOF = 50 )
      INTEGER IJSI2,IJSI1
      DOUBLE PRECISION XS1,XS2,PSOFT1,PSOFT2
      COMMON /POSOFT/ XS1(MAXSOF),XS2(MAXSOF),
     &                PSOFT1(4,MAXSOF),PSOFT2(4,MAXSOF),
     &                IJSI1(MAXSOF),IJSI2(MAXSOF)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  table of particle indices for recursive PHOJET calls
      INTEGER MAXIPX
      PARAMETER ( MAXIPX = 100 )
      INTEGER IPOPOS,IPORES,IPOIX1,IPOIX2,IPOIX3
      COMMON /PORECU/ IPOPOS(2,MAXIPX),IPORES(MAXIPX),
     &                IPOIX1,IPOIX2,IPOIX3


      DIMENSION P1(4),P2(4),WGXHSD(2),WGX(6)

      IREJ = 0
      ISWAP = 0
      JM1 = NPOSP(1)
      JM2 = NPOSP(2)
      INDX1 = IND1
      INDX2 = IND2
      EA1 = XS1(IND1)*ECMP/2.D0
      EA2 = XS1(IND1+1)*ECMP/2.D0
      EB1 = XS2(IND2)*ECMP/2.D0
      EB2 = XS2(IND2+1)*ECMP/2.D0
      CMASS1 = MIN(EA1,EA2)
      CMASS2 = MIN(EB1,EB2)

C  debug output
      IF(IDEB(9).GE.20) THEN
        WRITE(ErrorOut,'(1X,2A,5I4)') 'PHO_POSPOM: ',
     &    'IP,IND1,IND2,KCUT,IPOIX1',IP,IND1,IND2,KCUT,IPOIX1
        WRITE(ErrorOut,
     * '(1X,A,2I4,1P2E12.4)') 'MOTHER1/2,MASS1/2',JM1,JM2,
     &    CMASS1,CMASS2
      ENDIF

C  flavours
      IF(IND1.EQ.1) THEN
        CALL PHO_VALFLA(JM1,IFLA1,IFLA2,EA1,EA2)
      ELSE
        CALL PHO_SEAFLA(JM1,IFLA1,IFLA2,CMASS1)
      ENDIF
      IF(IND2.EQ.1) THEN
        CALL PHO_VALFLA(JM2,IFLB1,IFLB2,EB1,EB2)
      ELSE
        CALL PHO_SEAFLA(JM2,IFLB1,IFLB2,CMASS2)
      ENDIF
      DO 75 I=1,4
        P1(I) = PSOFT1(I,IND1)+PSOFT1(I,IND1+1)
        P2(I) = PSOFT2(I,IND2)+PSOFT2(I,IND2+1)
 75   CONTINUE

C  pomeron resolved?
      IF((ISWMDL(14).GT.0).AND.(IPOIX1.GT.0)) THEN
C  find energy for cross section calculation
        IF(IPAMDL(16).EQ.2) THEN
          ESUB = ECMP
        ELSE IF(IPAMDL(16).EQ.3) THEN
          IF(IPROCE.EQ.1) THEN
            ESUB = ECM
          ELSE
            ESUB = ECMP
          ENDIF
        ELSE
          ESUB = SQRT((P1(4)+P2(4))**2-(P1(1)+P2(1))**2
     &                -(P1(2)+P2(2))**2-(P1(3)+P2(3))**2)
        ENDIF
C  load cross sections from interpolation table
        IF(ESUB.LE.SIGECM(IP,1)) THEN
          I1 = 1
          I2 = 2
        ELSE IF(ESUB.LT.SIGECM(IP,ISIMAX)) THEN
          DO 50 I=2,ISIMAX
            IF(ESUB.LE.SIGECM(IP,I)) GOTO 200
 50       CONTINUE
 200      CONTINUE
          I1 = I-1
          I2 = I
        ELSE
          WRITE(ErrorOut,'(/1X,A,2E12.3)')
     &      'PHO_POSPOM: ENERGY TOO HIGH',ESUB,SIGECM(IP,ISIMAX)
          CALL PHO_PREVNT(-1)
          I1 = ISIMAX-1
          I2 = ISIMAX
        ENDIF
        FAC2=0.D0
        IF(I1.NE.I2) FAC2=LOG(ESUB/SIGECM(IP,I1))
     &                    /LOG(SIGECM(IP,I2)/SIGECM(IP,I1))
        FAC1=1.D0-FAC2
C  calculate weights
*       WGXHSD(1) = FAC2*SIGTAB(IP,32,I2)+FAC1*SIGTAB(IP,32,I1)
*       WGXHSD(2) = FAC2*SIGTAB(IP,33,I2)+FAC1*SIGTAB(IP,33,I1)
*       WGXHDD = FAC2*SIGTAB(IP,35,I2)+FAC1*SIGTAB(IP,35,I1)
*       WGXCDF = FAC2*SIGTAB(IP,36,I2)+FAC1*SIGTAB(IP,36,I1)
*       WGXPOM = FAC2*SIGTAB(IP,37,I2)+FAC1*SIGTAB(IP,37,I1)
*       WGX(1) = WGXPOM-3.D0*(WGXHSD(1)+WGXHSD(2)+WGXHDD)+15.D0*WGXCDF

        WGXPOM = FAC2*(SIGTAB(IP,56,I2)+SIGTAB(IP,57,I2))
     &          +FAC1*(SIGTAB(IP,56,I1)+SIGTAB(IP,57,I1))
        WGXHSD(1) = FAC2*SIGTAB(IP,60,I2)+FAC1*SIGTAB(IP,60,I1)
        WGXHSD(2) = FAC2*SIGTAB(IP,62,I2)+FAC1*SIGTAB(IP,62,I1)
        WGXHDD = FAC2*(SIGTAB(IP,61,I2)+SIGTAB(IP,63,I2)
     &                 +SIGTAB(IP,64,I2))
     &          +FAC1*(SIGTAB(IP,61,I1)+SIGTAB(IP,63,I1)
     &                 +SIGTAB(IP,64,I1))
        WGXCDF = FAC2*(SIGTAB(IP,65,I2)+SIGTAB(IP,66,I2)
     &                 +SIGTAB(IP,67,I2)+SIGTAB(IP,68,I2))
     &          +FAC1*(SIGTAB(IP,65,I1)+SIGTAB(IP,66,I1)
     &                 +SIGTAB(IP,67,I1)+SIGTAB(IP,68,I1))

C  one-pomeron cut
        WGX(1) = WGXPOM-3.D0*(WGXHSD(1)+WGXHSD(2)+WGXHDD)+15.D0*WGXCDF
C  central diff. cut
        WGX(2) = WGXCDF
C  diff. diss. of particle 1
        WGX(3) = WGXHSD(1)
C  diff. diss. of particle 2
        WGX(4) = WGXHSD(2)
C  double diff. dissociation
        WGX(5) = WGXHDD
C  two-pomeron cut
        WGX(6) = 2.D0*(WGXHSD(1)+WGXHSD(2)+WGXHDD)

*       IF((WGX(1).LT.0.D0).AND.((IP.EQ.1).OR.(IDEB(9).GE.1))) THEN
*         WRITE(6,'(1X,A,/1X,A,I3,1P,2E11.3)') ' PHO_POSPOM: ',
*    &      ' unitarity bound reached for ',IP,ESUB,WGX(1)
*         WRITE(6,'(5X,A)') 'WGXHSD(1),WGXHSD(2),WGXHDD,WGXCDF,WGXPOM:'
*         WRITE(6,'(5X,1P5E11.3)') WGXHSD,WGXHDD,WGXCDF,WGXPOM
*         WRITE(6,'(5X,A,/,5X,1P,6E11.3)') 'weight factors WG(1-6)',WGX
*       ENDIF

        SUM  = WGX(1)+WGX(2)+WGX(3)+WGX(4)+WGX(5)+WGX(6)

C  selection loop
 205    CONTINUE
        XI = PHO_RNDM(SUM)*SUM
        I = 0
        SUM = 0.D0
 210    CONTINUE
          I = I+1
          SUM = SUM+WGX(I)
        IF((XI.GT.SUM).AND.(I.LT.6)) GOTO 210
C  phase space correction
        IF(I.NE.1) THEN
          ISAM = 4
          IF(I.EQ.6) ISAM = 8
          PACC = EXP(-PARMDL(8)*DBLE(ISAM*PARMDL(160+IP))/ESUB)
*         IF(PHO_RNDM(SUM).GT.PACC) I=1
          IF(PHO_RNDM(SUM).GT.PACC) GOTO 205
        ENDIF

C  do not generate diffraction for events with only one cut pomeron
        IF((KCUT.EQ.1).AND.(I.LT.6)) I = 1

C  do not generate recursive calls for remants with
C  diquark-anti-diquark flavour contents
        IF((ABS(IFLA1).GT.1000).AND.(IFLA1+IFLA2.EQ.0)) I = 1
        IF((ABS(IFLB1).GT.1000).AND.(IFLB1+IFLB2.EQ.0)) I = 1

C  debug output
        IF(IDEB(9).GE.20) WRITE(ErrorOut,
     * '(1X,A,/1X,I2,1P7E11.3)')
     &    'PHO_POSPOM: IPRO,ESUB,WGX(1-6)',I,ESUB,WGX

        IF(I.GT.1) THEN
C  second scattering needed
          CALL PHO_HACODE(IFLA1,IFLA2,IDHA1,IDUM)
          CALL PHO_HACODE(IFLB1,IFLB2,IDHA2,IDUM)
          IDPD1 = IPHO_ID2PDG(IDHA1)
          IDPD2 = IPHO_ID2PDG(IDHA2)

          IF(INDX1.EQ.1) THEN
            IF((IPHIST(2,JM1).GE.0).AND.(IDHEP(JM1).NE.990))
     &        IGEN_HAD = IGEN
          ELSE
            IGEN_HAD = -IGEN
          ENDIF
          CALL PHO_REGPAR(1,IDPD1,IDHA1,JM1,JM2,P1(1),P1(2),P1(3),P1(4),
     &      IPOM,IGEN_HAD,0,0,IPOS1,1)

          IF(INDX2.EQ.1) THEN
            IF((IPHIST(2,JM2).GE.0).AND.(IDHEP(JM2).NE.990))
     &        IGEN_HAD = IGEN
          ELSE
            IGEN_HAD = -IGEN
          ENDIF
          CALL PHO_REGPAR(1,IDPD2,IDHA2,JM2,JM1,P2(1),P2(2),P2(3),P2(4),
     &      IPOM,IGEN_HAD,0,0,IPOS1,1)

          IND1 = IND1+2
          IND2 = IND2+2
C  update index
          IPOIX2 = IPOIX2+1

          IF(IPOIX2.GT.MAXIPX) THEN
            WRITE(ErrorOut,
     * '(1X,2A,2I5)') 'PHO_POSPOM: no space left in ',
     &        '/PORECU/ (IPOIX2,MAXIPX):',IPOIX2,MAXIPX
            IREJ = 1
            RETURN
          ENDIF

          IPORES(IPOIX2) = I+2
          IPOPOS(1,IPOIX2) = IPOS1-1
          IPOPOS(2,IPOIX2) = IPOS1
          RETURN
        ENDIF
      ENDIF


 100  CONTINUE
      IF(ISWMDL(12).EQ.0) THEN
C  sample colors
        CALL PHO_SELCOL(0,0,ICA1,ICA2,ICB1,ICB2,1)
        CALL PHO_SELCOL(0,0,ICC1,ICC2,ICD1,ICD2,1)

C  purely gluonic pomeron or sea strings formed by gluons

        IF(    ((IDHEP(JM1).EQ.990).AND.(IPAMDL(20).GT.0))
     &     .OR.((IPAMDL(19).EQ.1).AND.(IND1.NE.1))) THEN
          IFLA1 = 21
          IFLA2 = 21
        ENDIF
        IF(    ((IDHEP(JM2).EQ.990).AND.(IPAMDL(20).GT.0))
     &     .OR.((IPAMDL(19).EQ.1).AND.(IND2.NE.1))) THEN
          IFLB1 = 21
          IFLB2 = 21
        ENDIF

C  color connection
        IF(IFLA1.NE.21) THEN
          IF(((ABS(IFLA1).GT.6).AND.(IFLA1.GT.0))
     &      .OR.((ABS(IFLA1).LE.6).AND.(IFLA1.LT.0)))
     &      CALL PHO_SWAPI(ICA1,ICD1)
        ENDIF
        IF(IFLB1.NE.21) THEN
          IF(((ABS(IFLB1).GT.6).AND.(IFLB1.LT.0))
     &      .OR.((ABS(IFLB1).LE.6).AND.(IFLB1.GT.0)))
     &      CALL PHO_SWAPI(ICB1,ICC1)
        ENDIF
        ISWAP = 0
        IF(ICA1*ICB1.GT.0) THEN
          IF((IND1.NE.1).AND.(IND2.NE.1)) THEN
            IF(PHO_RNDM(CMASS1).GT.0.5D0) THEN
              CALL PHO_SWAPI(IFLA1,IFLA2)
              CALL PHO_SWAPI(ICA1,ICD1)
            ELSE
              CALL PHO_SWAPI(IFLB1,IFLB2)
              CALL PHO_SWAPI(ICB1,ICC1)
            ENDIF
          ELSE IF(IND1.NE.1) THEN
            CALL PHO_SWAPI(IFLA1,IFLA2)
            CALL PHO_SWAPI(ICA1,ICD1)
          ELSE IF(IND2.NE.1) THEN
            CALL PHO_SWAPI(IFLB1,IFLB2)
            CALL PHO_SWAPI(ICB1,ICC1)
          ELSE IF((IFLA1.EQ.-IFLA2).AND.(IFLB1.EQ.-IFLB2)) THEN
            IF(PHO_RNDM(CMASS1).GT.0.5D0) THEN
              CALL PHO_SWAPI(IFLA1,IFLA2)
              CALL PHO_SWAPI(ICA1,ICD1)
            ELSE
              CALL PHO_SWAPI(IFLB1,IFLB2)
              CALL PHO_SWAPI(ICB1,ICC1)
            ENDIF
          ELSE IF(IFLA1.EQ.-IFLA2) THEN
            CALL PHO_SWAPI(IFLA1,IFLA2)
            CALL PHO_SWAPI(ICA1,ICD1)
          ELSE IF(IFLB1.EQ.-IFLB2) THEN
            CALL PHO_SWAPI(IFLB1,IFLB2)
            CALL PHO_SWAPI(ICB1,ICC1)
          ELSE
            ISWAP = 1
            IF(IDEB(9).GE.5) THEN
              WRITE(ErrorOut,'(1X,A,I12)')
     &          'PHO_POSPOM: STRING END SWAP (KEVENT)',KEVENT
                WRITE(ErrorOut,'(5X,A,4I7)')
     &          'FLAVORS:',IFLA1,IFLA2,IFLB1,IFLB2
              WRITE(ErrorOut,
     * '(5X,A,4I7)') 'colors :',ICA1,ICD1,ICB1,ICC1
            ENDIF
          ENDIF
        ENDIF

C  registration

C  purely gluonic pomeron or sea strings formed by gluons
        IF(IFLA1.EQ.21) THEN
          CALL PHO_REGPAR(-1,21,0,JM1,JM2,P1(1),P1(2),P1(3),P1(4),
     &      IPOM,IGEN,ICA1,ICD1,IPOS1,1)
          IND1 = IND1+2


C  strings formed by quarks
        ELSE
C  valence quark labels
          IF((INDX1.EQ.1).AND.(IPHIST(2,JM1).GE.0)
     &       .AND.(IDHEP(JM1).NE.990)) THEN
            ICA2 = 1
            ICD2 = 1
          ENDIF
C  registration
          CALL PHO_REGPAR(-1,IFLA1,0,JM1,JM2,PSOFT1(1,IND1),
     &      PSOFT1(2,IND1),PSOFT1(3,IND1),PSOFT1(4,IND1),IPOM,IGEN,ICA1,
     &      ICA2,IPOS1,1)
          IND1 = IND1+1
          CALL PHO_REGPAR(-1,IFLA2,0,JM1,JM2,PSOFT1(1,IND1),
     &      PSOFT1(2,IND1),PSOFT1(3,IND1),PSOFT1(4,IND1),IPOM,IGEN,ICD1,
     &      ICD2,IPOS,1)
          IND1 = IND1+1

        ENDIF

C  purely gluonic pomeron or sea strings formed by gluons
        IF(IFLB1.EQ.21) THEN
          CALL PHO_REGPAR(-1,IFLB1,0,JM2,JM1,P2(1),P2(2),P2(3),P2(4),
     &      IPOM,IGEN,ICB1,ICC1,IPOS2,1)
          IND2 = IND2+2


C  strings formed by quarks
        ELSE
C  valence quark labels
          IF((INDX2.EQ.1).AND.(IPHIST(2,JM2).GE.0)
     &       .AND.(IDHEP(JM2).NE.990)) THEN
            ICB2 = 1
            ICC2 = 1
          ENDIF
C  registration
          CALL PHO_REGPAR(-1,IFLB1,0,JM2,JM1,PSOFT2(1,IND2),
     &      PSOFT2(2,IND2),PSOFT2(3,IND2),PSOFT2(4,IND2),IPOM,IGEN,ICB1,
     &      ICB2,IPOS,1)
          IND2 = IND2+1
          CALL PHO_REGPAR(-1,IFLB2,0,JM2,JM1,PSOFT2(1,IND2),
     &      PSOFT2(2,IND2),PSOFT2(3,IND2),PSOFT2(4,IND2),IPOM,IGEN,ICC1,
     &      ICC2,IPOS2,1)
          IND2 = IND2+1

        ENDIF

C  soft pt assignment
        IF(ISWMDL(18).EQ.0) THEN
          CALL PHO_PARTPT(0,IPOS1,IPOS2,PTCUT(IP),IREJ)
          IF(IREJ.NE.0) THEN
            IFAIL(25) = IFAIL(25)+1
            RETURN
          ENDIF
        ENDIF
      ELSE
*       CALL PHO_BFKL(P1,P2,IPART,IREJ)
*       IF(IREJ.NE.0) RETURN
      ENDIF

      END


CDECK  ID>, PHO_HADSP2
      SUBROUTINE PHO_HADSP2(IFLB,XS1,XMAX,XSOFT1,IREJ)
C***********************************************************************
C
C     split hadron momentum XMAX into two partons using
C     lower cut-off: AS
C
C     input:   IFLB    compressed particle code of particle to split
C              XS1     sum of x values already selected
C              XMAX    maximal x possible
C
C     output:  XS1     new sum of x values (without first one)
C              XSOFT1  field of selected x values
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS   =  1.D-8 )

      DIMENSION XSOFT1(50)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC


C  model exponents
      DATA PVMES1 /-0.5D0/
      DATA PVMES2 /-0.5D0/
      DATA PVBAR1 / 1.5D0/
      DATA PVBAR2 /-0.5D0/
C
      IREJ = 0
      ITMAX = 100
C
C  mesonic particle
      IF(IPHO_BAR3(IFLB,0).EQ.0) THEN
        XPOT1 = PVMES1+1.D0
        XPOT2 = PVMES2+1.D0
C  baryonic particle
      ELSE
        XPOT1 = PVBAR1+1.D0
        XPOT2 = PVBAR2+1.D0
      ENDIF
      ITER = 0
      XREST= 1.D0-XS1
C  selection loop
 100  CONTINUE
        ITER = ITER+1
        IF(ITER.GE.ITMAX) THEN
          IF(IDEB(39).GE.3) THEN
            WRITE(ErrorOut,'(1X,A,I8)')
     &        'PHO_HADSP2: REJECTION (ITER)',ITER
            WRITE(ErrorOut,
     * '(5X,A,3E12.3)') 'XS1,XMAX,AS:',XS1,XMAX,AS
          ENDIF
          IFAIL(14) = IFAIL(14)+1
          IREJ = 1
          RETURN
        ENDIF
        ZZ = XREST*PHO_RNDBET(XPOT2,XPOT1)
      IF((ZZ.GT.XMAX).OR.(ZZ.LT.AS)) GOTO 100
      XSS1 = XS1 + ZZ
      IF((1.D0-XSS1).LT.AS) GOTO 100
C
      XS1 = XSS1
      XSOFT1(1) = 1.D0-XSS1
      XSOFT1(2) = ZZ
C  debug output
      IF(IDEB(39).GE.10) THEN
        WRITE(ErrorOut,
     * '(1X,A,2I8)') 'PHO_HADSP2: ITMAX,ITER',ITMAX,ITER
        WRITE(ErrorOut,
     * '(5X,A,3E10.3,5X,2E11.4)') 'XS1,XMAX,AS  X1,X2:',
     &    XS1,XMAX,AS,XSOFT1(1),XSOFT1(2)
      ENDIF
      END


CDECK  ID>, PHO_HADSP3
      SUBROUTINE PHO_HADSP3(IFLB,XS1,XMAX,XSOFT1,IREJ)
C***********************************************************************
C
C     split hadron momentum XMAX into diquark & quark pair
C     using lower cut-off: AS
C
C     input:   IFLB    compressed particle code of particle to split
C              XS1     sum of x values already selected
C              XMAX    maximal x possible
C
C     output:  XS1     new sum of x values
C              XSOFT1  field of selected x values
C
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER ( DEPS   =  1.D-8 )

      DIMENSION XSOFT1(50),XSOFT2(50)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2


      DIMENSION XPOT1(3),XPOT2(3),XMIN(2,3)

C  model exponents
      DATA PVMES1 /-0.5D0/
      DATA PVMES2 /-0.5D0/
      DATA PSMES  /-0.99D0/
      DATA PVBAR1 / 1.5D0/
      DATA PVBAR2 /-0.5D0/
      DATA PSBAR  /-0.99D0/
C
      IREJ = 0
C
C  determine exponents
C  particle 1
C
      XMMIN = 0.3D0/ECMP
      XBMIN = 1.6D0/ECMP
C  mesonic particle
      IF(IPHO_BAR3(IFLB,0).EQ.0) THEN
        XPOT1(1) = PVMES1
        XMIN(1,1)  = XMMIN
        XPOT1(2) = PVMES2
        XMIN(1,2)  = XMMIN
        XPOT1(3) = PSMES
        XMIN(1,3)  = XMMIN
C  baryonic particle
      ELSE
        XPOT1(1) = PVBAR1
        XMIN(1,1)  = XBMIN
        XPOT1(2) = PVBAR2
        XMIN(1,2)  = XMMIN
        XPOT1(3) = PSBAR
        XMIN(1,3)  = XMMIN
      ENDIF
C  particle 2
C  mesonic particle
      XPOT2(1) = PVMES1
      XMIN(2,1)  = XMMIN
      XPOT2(2) = PVMES2
      XMIN(2,2)  = XMMIN
      XPOT2(3) = PSMES
      XMIN(2,3)  = XMMIN
C
      XDUM1 = 0.01D0
      XDUM2 = 0.99D0
      CALL PHO_SELSXS(3,3,XPOT1,XPOT2,XMIN,XS1,XDUM1,XMAX,XDUM2,
     &            XSOFT1,XSOFT2,IREJ)
C  rejection?
      IF(IREJ.NE.0) THEN
        IF(IDEB(74).GE.3) WRITE(ErrorOut,'(1X,A,I6,2E12.4)')
     &    'PHO_HADSP3: REJECTION (IFLB,XS1,XMAX)',IFLB,XS1,XMAX
        IFAIL(15) = IFAIL(15)+1
        IREJ = 1
        RETURN
      ENDIF
C  debug output
      IF(IDEB(74).GE.10) THEN
        WRITE(ErrorOut,'(1X,A,I6,2E12.4)')
     &    'PHO_HADSP3: IFLB,XS1,XMAX',IFLB,XS1,XMAX
        DO 100 I=1,3
          WRITE(ErrorOut,
     * '(10X,I4,2E12.4)') I,XSOFT1(I),XSOFT2(I)
 100    CONTINUE
      ENDIF

      END


CDECK  ID>, PHO_SOFTXX
      SUBROUTINE PHO_SOFTXX(JM1,JM2,MSPAR1,MSPAR2,IVAL1,IVAL2,MSM1,MSM2,
     &                  XSUM1,XSUM2,XMAX1,XMAX2,XS1,XS2,IREJ)
C***********************************************************************
C
C    select soft x values
C
C    input:   JM1,JM2    mother particle index in POEVT1
C                        (0  flavour not known before)
C             MSPAR1,2   number of x values to select
C             IVAL1,2    number valence quarks involved in hard
C                        scattering (0,1,2)
C             MSM1,2     minimum number of soft x to get sampled
C             XSUM1,2    sum of all x values samples up this call
C             XMAX1,2    max. x value
C
C    output   XSUM1,2    new sum of x-values sampled
C             XS1,2      field containing sampled x values
C
C    x values of valence partons are first given
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC


      DIMENSION XS1(*),XS2(*)

      INTEGER MAXPOT
      PARAMETER ( MAXPOT = 50 )
      DIMENSION XPOT1(MAXPOT),XPOT2(MAXPOT),XMIN(2,MAXPOT)

      IREJ = 0

      MSMAX = MAX(MSPAR1,MSPAR2)
      MSMIN = MAX(MSM1,MSM2)

      IF(MSMAX.GT.MAXPOT) THEN
        WRITE(ErrorOut,
     * '(1X,2A,2I4)') 'PHO_SOFTXX: no space left in ',
     &    'LOCAL FIELDS XPOT1/2 (MSMAX,MAXPOT):',MSMAX,MAXPOT
        IREJ = 1
        RETURN
      ENDIF

C  determine exponents
      IBAR1 = IPHO_BAR3(JM1,2)
      IBAR2 = IPHO_BAR3(JM2,2)
      ISWAP = 0
      IF((IBAR1*IBAR2).LT.0) ISWAP = 1
C  meson-baryon scattering (asymmetric sea)
      IF((ABS(IBAR1)+ABS(IBAR2)).EQ.1) THEN
        PSBAR = PARMDL(53)
        PSMES = PARMDL(57)
      ELSE
        PSBAR = PARMDL(52)
        PSMES = PARMDL(56)
      ENDIF

C  lower limits for x sampling
      XMMINA = 2.D0*PARMDL(157)/ECMP
      XBMINA = 2.D0*PARMDL(158)/ECMP
      XSMINA = 2.D0*PARMDL(159)/ECMP
      XMIN1 = MAX(XSOMIN,AS/XMAX2)
      XMIN2 = MAX(XSOMIN,AS/XMAX1)
      XMAXP1 = MIN(1.D0-XMIN1*MSMAX,XMAX1)
      XMAXP2 = MIN(1.D0-XMIN2*MSMAX,XMAX2)
      XMIN1 = MAX(AS/XMAX2,XMIN1)
      XMIN2 = MAX(AS/XMAX1,XMIN2)

C  particle 1
      XMMIN1 = MAX(XMIN1,XMMINA)
      XBMIN1 = MAX(XMIN1,XBMINA)
      XSMIN1 = MAX(XMIN1,XSMINA)
C  mesonic particle
      IF(IBAR1.EQ.0) THEN
        IF(IHFLS(1).EQ.0) THEN
          XPOT1(1) = PARMDL(62)
          XMIN(1,1)  = XSMIN1
          XPOT1(2) = PARMDL(63)
          XMIN(1,2)  = XSMIN1
        ELSE
          XPOT1(1) = PARMDL(54)
          XMIN(1,1)  = XMMIN1
          XPOT1(2) = PARMDL(55)
          XMIN(1,2)  = XMMIN1
        ENDIF
        DO 100 I=3-IVAL1,MSMAX
          XPOT1(I) = PSMES
          XMIN(1,I)  = XSMIN1
 100    CONTINUE
C  baryonic particle
      ELSE
        IF(IHFLS(1).EQ.0) THEN
          XPOT1(1) = PARMDL(62)
          XMIN(1,1)  = XSMIN1
          XPOT1(2) = PARMDL(63)
          XMIN(1,2)  = XSMIN1
        ELSE
          XPOT1(1) = PARMDL(50)
          XMIN(1,1)  = XBMIN1
          XPOT1(2) = PARMDL(51)
          XMIN(1,2)  = XMMIN1
        ENDIF
        DO 200 I=3-IVAL1,MSMAX
          XPOT1(I) = PSBAR
          XMIN(1,I)  = XSMIN1
 200    CONTINUE
      ENDIF

C  particle 2
      XMMIN2 = MAX(XMIN2,XMMINA)
      XBMIN2 = MAX(XMIN2,XBMINA)
      XSMIN2 = MAX(XMIN2,XSMINA)
C  mesonic particle
      IF(IBAR2.EQ.0) THEN
        IF(IHFLS(2).EQ.0) THEN
          XPOT2(1) = PARMDL(62)
          XMIN(2,1)  = XSMIN2
          XPOT2(2) = PARMDL(63)
          XMIN(2,2)  = XSMIN2
        ELSE
          XPOT2(1) = PARMDL(54)
          XMIN(2,1)  = XMMIN2
          XPOT2(2) = PARMDL(55)
          XMIN(2,2)  = XMMIN2
        ENDIF
        DO 300 I=3-IVAL2,MSMAX
          XPOT2(I) = PSMES
          XMIN(2,I)  = XSMIN2
 300    CONTINUE
C  baryonic particle
      ELSE
        IF(IHFLS(2).EQ.0) THEN
          XPOT2(1) = PARMDL(62)
          XMIN(2,1)  = XSMIN2
          XPOT2(2) = PARMDL(63)
          XMIN(2,2)  = XSMIN2
        ELSE
          XPOT2(1) = PARMDL(50)
          XMIN(2,1)  = XBMIN2
          XPOT2(2) = PARMDL(51)
          XMIN(2,2)  = XMMIN2
        ENDIF
        DO 400 I=3-IVAL2,MSMAX
          XPOT2(I) = PSBAR
          XMIN(2,I)  = XSMIN2
 400    CONTINUE
      ENDIF

      XSS1 = XSUM1
      XSS2 = XSUM2
      MSOFT = MSMAX

C  check limits (important for valences)
      IF((XMIN(1,1).GE.XMAXP1).OR.(XMIN(1,2).GE.XMAXP1)) GOTO 1000
      IF((XMIN(2,1).GE.XMAXP2).OR.(XMIN(2,2).GE.XMAXP2)) GOTO 1000

      XMINS1 = XSS1
      IF(IHFLS(1).NE.0) XMINS1 = XMINS1+(PARMDL(166)/ECMP)**2
      XMINS2 = XSS2
      IF(IHFLS(2).NE.0) XMINS2 = XMINS2+(PARMDL(166)/ECMP)**2
      DO 10 I=1,MSOFT
        XMINS1 = XMINS1+XMIN(1,I)
        XMINS2 = XMINS2+XMIN(2,I)
 10   CONTINUE
      IF((XMINS1.GE.1.D0).OR.(XMINS2.GE.1.D0)) GOTO 1000

C  try to sample x values
      IF(IPAMDL(14).EQ.0) THEN
        IF(MSOFT.EQ.2) THEN
          CALL PHO_SELSX2(XPOT1,XPOT2,XMIN,XSS1,XSS2,XMAXP1,XMAXP2,
     &                XS1,XS2,IREJ)
        ELSE IF(MSOFT.LT.5) THEN
          CALL PHO_SELSXR(MSOFT,MSMIN,XPOT1,XPOT2,XMIN,XSS1,XSS2,
     &                XMAXP1,XMAXP2,XS1,XS2,IREJ)
        ELSE
          CALL PHO_SELSXS(MSOFT,MSMIN,XPOT1,XPOT2,XMIN,XSS1,XSS2,
     &                XMAXP1,XMAXP2,XS1,XS2,IREJ)
        ENDIF
      ELSE IF(IPAMDL(14).EQ.1) THEN
        IF(MSOFT.EQ.2) THEN
          CALL PHO_SELSX2(XPOT1,XPOT2,XMIN,XSS1,XSS2,XMAXP1,XMAXP2,
     &                XS1,XS2,IREJ)
        ELSE
          CALL PHO_SELSXS(MSOFT,MSMIN,XPOT1,XPOT2,XMIN,XSS1,XSS2,
     &                XMAXP1,XMAXP2,XS1,XS2,IREJ)
        ENDIF
      ELSE IF(IPAMDL(14).EQ.2) THEN
        CALL PHO_SELSXS(MSOFT,MSMIN,XPOT1,XPOT2,XMIN,XSS1,XSS2,
     &              XMAXP1,XMAXP2,XS1,XS2,IREJ)
      ELSE IF(IPAMDL(14).EQ.3) THEN
        IF(MSOFT.EQ.2) THEN
          CALL PHO_SELSX2(XPOT1,XPOT2,XMIN,XSS1,XSS2,XMAXP1,XMAXP2,
     &                XS1,XS2,IREJ)
        ELSE IF(IVAL1+IVAL2.EQ.0) THEN
          CALL PHO_SELSXI(MSOFT,MSMIN,XPOT1,XPOT2,XMIN,XSS1,XSS2,
     &                XMAXP1,XMAXP2,XS1,XS2,IREJ)
        ELSE
          CALL PHO_SELSXS(MSOFT,MSMIN,XPOT1,XPOT2,XMIN,XSS1,XSS2,
     &                XMAXP1,XMAXP2,XS1,XS2,IREJ)
        ENDIF
      ELSE
        WRITE(ErrorOut,'(/,1X,A,I3)')
     &    'PHO_SOFTXX:ERROR: UNSUPPORTED IPAMDL(14)',IPAMDL(14)
        STOP
      ENDIF
      IF(IREJ.NE.0) THEN
        IFAIL(41) = IFAIL(41)+1
        IF(IDEB(60).GE.2) THEN
          WRITE(ErrorOut,'(1X,A,I12,4I3)')
     &      'PHO_SOFTXX: REJECTION: EVE,MSP1/2,MSM1/2',
     &      KEVENT,MSPAR1,MSPAR2,MSM1,MSM2
          WRITE(ErrorOut,'(1X,A,1P4E11.3)') 'XSUM1/2,XMAX1/2',
     &      XSUM1,XSUM2,XMAX1,XMAX2
        ENDIF
        RETURN
      ENDIF
      IF(MSOFT.NE.MSMAX) THEN
        MSDIFF = MSMAX-MSOFT
        MSPAR1 = MSPAR1-MSDIFF
        MSPAR2 = MSPAR2-MSDIFF
      ENDIF

C  correct for different MSPAR numbers
      IF(MSOFT.NE.MSPAR1) THEN
        IF(MSPAR1.GT.1) THEN
          XDEL = 0.D0
          DO 500 I=MSPAR1+1,MSOFT
            XDEL = XDEL+XS1(I)
 500      CONTINUE
          XFAC = (1.D0-XSUM1)/(1.D0-XDEL-XSUM1)
          DO 550 I=2,MSPAR1
            XS1(I) = XS1(I)*XFAC
 550      CONTINUE
          XSS1 = (XSS1-XDEL-XSUM1)*XFAC+XSUM1
        ELSE
          XSS1 = XSUM1
        ENDIF
      ENDIF
      IF(MSOFT.NE.MSPAR2) THEN
        IF(MSPAR2.GT.1) THEN
          XDEL = 0.D0
          DO 600 I=MSPAR2+1,MSOFT
            XDEL = XDEL+XS2(I)
 600      CONTINUE
          XFAC = (1.D0-XSUM2)/(1.D0-XDEL-XSUM2)
          DO 650 I=2,MSPAR2
            XS2(I) = XS2(I)*XFAC
 650      CONTINUE
          XSS2 = (XSS2-XDEL-XSUM2)*XFAC+XSUM2
        ELSE
          XSS2 = XSUM2
        ENDIF
      ENDIF

C  first x entry
      XS1(1) = 1.D0 - XSS1
      XS2(1) = 1.D0 - XSS2
      XSUM1 = XSS1
      XSUM2 = XSS2

C  debug output
      IF(IDEB(60).GE.10) THEN
        WRITE(ErrorOut,'(1X,A,I8,2I4,2E12.4)')
     &    'PHO_SOFTXX: EVE,MSPAR1/2,XSUM1/2:',
     &    KEVENT,MSPAR1,MSPAR2,XSUM1,XSUM2
        WRITE(ErrorOut,
     * '(1X,A)') 'PHO_SOFTXX: I  XS1/2   XPOT1/2  XMIN1/2'
        DO 30 I=1,MSOFT
          WRITE(ErrorOut,
     * '(5X,I3,6E12.4)') I,XS1(I),XS2(I),XPOT1(I),XPOT2(I),
     &      XMIN(1,I),XMIN(2,I)
 30     CONTINUE
      ENDIF

      RETURN

C  not enough phase space
 1000 CONTINUE

      IFAIL(42) = IFAIL(42)+1
      IREJ = 1

C  warning message
      IF(IDEB(60).GE.1) THEN
        WRITE (6,'(1X,A,1P,2E11.3,/1X,A,/5X,6E11.3)')
     &    'PHO_SOFTXX: XMIN>XMAX OR SUM(XMIN)>1 (ECM,AS)',
     &    ECMP,AS,'PHO_SOFTXX: XMIN1/2,XMAXP1/2,SUM(XMIN1/2)',
     &    XMIN1,XMIN2,XMAXP1,XMAXP2,XMINS1,XMINS2
        WRITE(ErrorOut,'(1X,A,1P,3E11.3)')
     &    'PHO_SOFTXX: XMMINA,XBMINA,XSMINA:',XMMINA,XBMINA,XSMINA
        WRITE(ErrorOut,'(1X,A,1P,3E11.3)')
     &    'PHO_SOFTXX: XMMIN1,XBMIN1,XSMIN1:',XMMIN1,XBMIN1,XSMIN1
        WRITE(ErrorOut,'(1X,A,1P,3E11.3)')
     &    'PHO_SOFTXX: XMMIN2,XBMIN2,XSMIN2:',XMMIN2,XBMIN2,XSMIN2
        WRITE(ErrorOut,'(1X,A)')
     &    'PHO_SOFTXX: TABLE OF LOWER X LIMITS (I,XMIN(1,I),XMIN(2,I))'
        DO 27 I=1,MSOFT
          WRITE(ErrorOut,
     * '(5X,I3,1P,2E11.3)') I,XMIN(1,I),XMIN(2,I)
 27     CONTINUE
        WRITE(ErrorOut,'(1X,A,I10,2I4,2E11.3)')
     &    'PHO_SOFTXX: KEVENT,MSPAR1/2,XSUM1/2:',
     &    KEVENT,MSPAR1,MSPAR2,XSUM1,XSUM2
        WRITE(ErrorOut,
     * '(1X,A)') 'PHO_SOFTXX: I   XPOT1/2   XMIN1/2'
        DO 25 I=1,MSOFT
          WRITE(ErrorOut,'(5X,I3,4E12.4)') I,XPOT1(I),XPOT2(I),
     &    XMIN(1,I),XMIN(2,I)
 25     CONTINUE
      ENDIF

      END


CDECK  ID>, PHO_SELSXR
      SUBROUTINE PHO_SELSXR(MSOFT,MSMIN,XPOT1,XPOT2,XMIN,XS1,XS2,
     &                  XMAX1,XMAX2,XSOFT1,XSOFT2,IREJ)
C***********************************************************************
C
C    select x values of soft string ends (rejection method)
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      DIMENSION XPOT1(*),XPOT2(*),XMIN(2,*),XSOFT1(*),XSOFT2(*)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN


      DIMENSION XLDIF(2,50),XLMIN(2,50),REVP(2,50),POT(2,50)

      IF(IDEB(13).GE.10) THEN
        WRITE(ErrorOut,'(1X,A)') 'PHO_SELSXR:'
        WRITE(ErrorOut,
     * '(5X,A,I4,5E11.3)') 'MSOFT,XS1,XS2,XMAX1,2',
     &    MSOFT,XS1,XS2,XMAX1,XMAX2
        DO 40 I=1,MSOFT
          WRITE(ErrorOut,
     * '(5X,A,I4,2E12.3)') 'EXPONENTS',I,XPOT1(I),XPOT2(I)
 40     CONTINUE
      ENDIF
C
      IREJ = 0
C
      XMINK = MAX(PSOMIN/ECM*2.D0,XSOMIN)
      XMIN1 = MAX(AS/XMAX1,XMINK)
      XMIN2 = MAX(AS/XMAX2,XMINK)
C
      IF(MSOFT.EQ.1) THEN
        XSOFT1(2) = 0.D0
        XSOFT2(2) = 0.D0
        RETURN
      ENDIF
      XWMAX = MAX(XMAX1**XPOT1(1),XMIN1**XPOT1(1))
     &        *MAX(XMAX2**XPOT2(1),XMIN2**XPOT2(1))
C
 10   CONTINUE
C
      DO 50 I=2,MSOFT
        POT(1,I) = XPOT1(I)+1.D0
        POT(2,I) = XPOT2(I)+1.D0
        REVP(1,I) = 1.D0/POT(1,I)
        REVP(2,I) = 1.D0/POT(2,I)
        XLMIN(1,I) = XMIN(1,I)**POT(1,I)
        XLMAX = XMAX1**POT(1,I)
        XLDIF(1,I) = XLMAX-XLMIN(1,I)
        XLMIN(2,I) = XMIN(2,I)**POT(2,I)
        XLMAX = XMAX2**POT(2,I)
        XLDIF(2,I) = XLMAX-XLMIN(2,I)
 50   CONTINUE
C
      ITRY0 = 0
 5    CONTINUE
      ITRY0 = ITRY0 + 1
      IF(ITRY0.GE.IPAMDL(181)) THEN
        IF(MSOFT-MSMIN.GE.2) THEN
          MSOFT = MSMIN
          GOTO 10
        ENDIF
        GOTO 1000
      ENDIF
      XREST1 = 1.D0-XS1
      XREST2 = 1.D0-XS2
      DO 100 I=2,MSOFT
        ITRY1 = 0

 20     CONTINUE
        Z1 = XLDIF(1,I)*PHO_RNDM(XS1)+XLMIN(1,I)
        Z2 = XLDIF(2,I)*PHO_RNDM(XS2)+XLMIN(2,I)
        XSOFT1(I) = Z1**REVP(1,I)
        XSOFT2(I) = Z2**REVP(2,I)
        ITRY1 = ITRY1+1
        IF(ITRY1.GE.50) GOTO 1000
        IF( (XSOFT1(I)*XSOFT2(I)).LT.AS ) GOTO 20

        XREST1 = XREST1-XSOFT1(I)
        IF(XREST1.LT.XMIN1) GOTO 5
        IF(XREST1.LT.XMIN(1,1)) GOTO 5
        XREST2 = XREST2-XSOFT2(I)
        IF(XREST2.LT.XMIN2) GOTO 5
        IF(XREST2.LT.XMIN(2,1)) GOTO 5
        IF(XREST1*XREST2.LT.AS) GOTO 5

 100  CONTINUE
      XSOFT1(1) = XREST1
      XSOFT2(1) = XREST2
      IREJ=0
*     XX = 1.D0
*     DO 200 I=2,MSOFT
*       XX = XX*XSOFT1(I)**XPOT1(I)*XSOFT2(I)**XPOT2(I)
*200  CONTINUE
      XX = XSOFT1(1)**XPOT1(1)*XSOFT2(1)**XPOT2(1)
      IF((XX-PHO_RNDM(XX)*XWMAX).LT.0.D0) GOTO 5

      XS1 = 1.D0-XREST1
      XS2 = 1.D0-XREST2
      RETURN

 1000 CONTINUE
      IREJ = 1
      IF(IDEB(13).GE.2) THEN
        WRITE(ErrorOut,'(1X,A,2I4)')
     &    'PHO_SELSXR: REJECTION(ITRY0/1)',ITRY0,ITRY1
        WRITE(ErrorOut,
     * '(5X,A,3E12.3)') 'XMAX1,2,AS:',XMAX1,XMAX2,AS
      ENDIF

      END



CDECK  ID>, PHO_SELSX2
      SUBROUTINE PHO_SELSX2(XPOT1,XPOT2,XMIN,XSUM1,XSUM2,XMAX1,XMAX2,
     &                  XS1,XS2,IREJ)
C***********************************************************************
C
C    select x values of soft string ends using PHO_RNDBET
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      DIMENSION XPOT1(*),XPOT2(*),XMIN(2,*),XS1(*),XS2(*)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN


      IREJ = 0

      IF(IDEB(32).GE.10) THEN
        WRITE(ErrorOut,'(1X,A)') 'PHO_SELSX2:'
        WRITE(ErrorOut,'(5X,A,5E11.3)') 'AS,XSUM1,2,XMAX1,2',
     &    AS,XSUM1,XSUM2,XMAX1,XMAX2
        DO 30 I=1,2
          WRITE(ErrorOut,
     * '(5X,A,I4,2E12.3)') 'EXPONENTS',I,XPOT1(I),XPOT2(I)
 30     CONTINUE
      ENDIF

      FAC1 = 1.D0-XSUM1
      FAC2 = 1.D0-XSUM2
      FAC = FAC1*FAC2
      GAM1 = XPOT1(1)+1.D0
      GAM2 = XPOT2(1)+1.D0
      BET1 = XPOT1(2)+1.D0
      BET2 = XPOT2(2)+1.D0

      ITRY0 = 0
      DO 100 I=1,IPAMDL(182)

        ITRY1 = 0
 10     CONTINUE
          X1 = PHO_RNDBET(GAM1,BET1)
          ITRY1 = ITRY1+1
          IF(ITRY1.GE.50) GOTO 1000
        IF((X1.LE.XMIN(1,1)).OR.((1.D0-X1).LE.XMIN(1,2))) GOTO 10

        ITRY2 = 0
 11     CONTINUE
          X2 = PHO_RNDBET(GAM2,BET2)
          ITRY2 = ITRY2+1
          IF(ITRY2.GE.50) GOTO 1000
        IF((X2.LE.XMIN(2,1)).OR.((1.D0-X2).LE.XMIN(2,2))) GOTO 11

        X3 = 1.D0 - X1
        X4 = 1.D0 - X2
        IF(X1*X2*FAC.GT.AS) THEN
          IF(X3*X4*FAC.GT.AS) THEN
            XS1(1) = X1*FAC1
            XS1(2) = X3*FAC1
            XS2(1) = X2*FAC2
            XS2(2) = X4*FAC2
            IF(XS1(1).GT.XMIN(1,1)) THEN
              IF(XS2(1).GT.XMIN(2,1)) THEN
                IF(XS1(2).GT.XMIN(1,2)) THEN
                  IF(XS2(2).GT.XMIN(2,2)) THEN
                    XSUM1 = XSUM1+XS1(2)
                    XSUM2 = XSUM2+XS2(2)
                    GOTO 300
                  ENDIF
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDIF
        ITRY0 = ITRY0+1

 100  CONTINUE

 1000 CONTINUE
      IREJ = 1
      IF(IDEB(32).GE.2) THEN
        WRITE(ErrorOut,'(1X,A,3I4)')
     &    'PHO_SELSX2: REJECTION(ITRY0/1/2)',ITRY0,ITRY1,ITRY2
        WRITE(ErrorOut,
     * '(5X,A,3E12.3)') 'XMAX1,2,AS:',XMAX1,XMAX2,AS
      ENDIF
      RETURN
 300  CONTINUE

      END


CDECK  ID>, PHO_SELSXS
      SUBROUTINE PHO_SELSXS(MSOFT,MSMIN,XPOT1,XPOT2,XMIN,XS1,XS2,
     &                  XMAX1,XMAX2,XSOFT1,XSOFT2,IREJ)
C***********************************************************************
C
C    select x values of soft string ends (rescaling method)
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      DIMENSION XPOT1(*),XPOT2(*),XMIN(2,*),XSOFT1(*),XSOFT2(*)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN


      DIMENSION XLDIF(2,50),XLMIN(2,50),REVP(2,50),POT(2,50)

      IREJ = 0

 10   CONTINUE

      IF(MSOFT.EQ.1) THEN
        XSOFT1(1) = 1.D0-XS1
        XSOFT1(2) = 0.D0
        XSOFT2(1) = 1.D0-XS2
        XSOFT2(2) = 0.D0
        RETURN
      ENDIF

      DO 50 I=1,MSOFT
        POT(1,I) = XPOT1(I)+1.D0
        POT(2,I) = XPOT2(I)+1.D0
        REVP(1,I) = 1.D0/POT(1,I)
        REVP(2,I) = 1.D0/POT(2,I)
        XLMIN(1,I) = XMIN(1,I)**POT(1,I)
        XLMAX = XMAX1**POT(1,I)
        XLDIF(1,I) = XLMAX-XLMIN(1,I)
        XLMIN(2,I) = XMIN(2,I)**POT(2,I)
        XLMAX = XMAX2**POT(2,I)
        XLDIF(2,I) = XLMAX-XLMIN(2,I)
 50   CONTINUE

      ITRY0 = 0
 5    CONTINUE
      ITRY0 = ITRY0 + 1
      IF(ITRY0.GE.IPAMDL(180)) THEN
        IF(MSOFT-MSMIN.GE.2) THEN
          MSOFT= MSMIN
          GOTO 10
        ENDIF
        GOTO 1000
      ENDIF
      XSUM1 = 0.D0
      XSUM2 = 0.D0
      DO 100 I=1,MSOFT
        ITRY1 = 0
 20     CONTINUE
        Z1 = XLDIF(1,I)*PHO_RNDM(XS1)+XLMIN(1,I)
        Z2 = XLDIF(2,I)*PHO_RNDM(XS2)+XLMIN(2,I)
        XSOFT1(I) = Z1**REVP(1,I)
        XSOFT2(I) = Z2**REVP(2,I)
        ITRY1 = ITRY1+1
        IF(ITRY1.GE.50) GOTO 1000
        IF( (XSOFT1(I)*XSOFT2(I)).LT.AS ) GOTO 20
        XSUM1 = XSUM1+XSOFT1(I)
        XSUM2 = XSUM2+XSOFT2(I)
 100  CONTINUE
      FAC1 = (1.D0-XS1)/XSUM1
      FAC2 = (1.D0-XS2)/XSUM2
      DO 200 I=1,MSOFT
        XSOFT1(I) = XSOFT1(I)*FAC1
        XSOFT2(I) = XSOFT2(I)*FAC2
        IF(XSOFT1(I).LT.XMIN(1,I)) GOTO 5
        IF(XSOFT2(I).LT.XMIN(2,I)) GOTO 5
        IF(XSOFT1(I)*XSOFT2(I).LT.AS) GOTO 5
 200  CONTINUE

      XS1 = 1.D0-XSOFT1(1)
      XS2 = 1.D0-XSOFT2(1)
      RETURN

 1000 CONTINUE
      IREJ = 1
      IF(IDEB(14).GE.2) THEN
        WRITE(ErrorOut,'(1X,2A,3I4)') 'PHO_SELSXS: ',
     &    'REJECTION (MSOFT,ITRY0/1)',MSOFT,ITRY0,ITRY1
        DO 300 I=1,MSOFT
          WRITE(ErrorOut,
     * '(5X,I4,1P4E11.3)') I,XMIN(1,I),XMIN(2,I),XMAX1,XMAX2
 300    CONTINUE
      ENDIF

      END


CDECK  ID>, PHO_SELSXI
      SUBROUTINE PHO_SELSXI(MSOFT,MSMIN,XPOT1,XPOT2,XMIN,XS1,XS2,
     &                  XMAX1,XMAX2,XSOFT1,XSOFT2,IREJ)
C***********************************************************************
C
C    select x values of soft string ends (sea independent from valence)
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      DIMENSION XPOT1(*),XPOT2(*),XMIN(2,*),XSOFT1(*),XSOFT2(*)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN


      DIMENSION XLDIF(2,50),XLMIN(2,50),REVP(2,50),POT(2,50)

      IREJ = 0

 10   CONTINUE

      DO 50 I=1,MSOFT
        POT(1,I) = XPOT1(I)+1.D0
        POT(2,I) = XPOT2(I)+1.D0
        REVP(1,I) = 1.D0/POT(1,I)
        REVP(2,I) = 1.D0/POT(2,I)
        XLMIN(1,I) = XMIN(1,I)**POT(1,I)
        XLMAX = XMAX1**POT(1,I)
        XLDIF(1,I) = XLMAX-XLMIN(1,I)
        XLMIN(2,I) = XMIN(2,I)**POT(2,I)
        XLMAX = XMAX2**POT(2,I)
        XLDIF(2,I) = XLMAX-XLMIN(2,I)
 50   CONTINUE

C  selection of sea
      ITRY0 = 0
 5    CONTINUE

      ITRY0 = ITRY0 + 1
      IF(ITRY0.GE.IPAMDL(183)) THEN
        IF(MSOFT-MSMIN.GE.2) THEN
          MSOFT = MSMIN
          GOTO 10
        ENDIF
        GOTO 1000
      ENDIF
      XSUM1 = XS1
      XSUM2 = XS2
      DO 100 I=3,MSOFT
        ITRY1 = 0
 20     CONTINUE
        Z1 = XLDIF(1,I)*PHO_RNDM(XS1)+XLMIN(1,I)
        Z2 = XLDIF(2,I)*PHO_RNDM(XS2)+XLMIN(2,I)
        XSOFT1(I) = Z1**REVP(1,I)
        XSOFT2(I) = Z2**REVP(2,I)
        ITRY1 = ITRY1+1
        IF(ITRY1.GE.50) GOTO 1000
        IF( (XSOFT1(I)*XSOFT2(I)).LT.AS ) GOTO 20
        XSUM1 = XSUM1+XSOFT1(I)
        XSUM2 = XSUM2+XSOFT2(I)
 100  CONTINUE

      IF(XSUM1.GT.1.D0-XMIN(1,1)-XMIN(1,2)) GOTO 5
      IF(XSUM2.GT.1.D0-XMIN(2,1)-XMIN(2,2)) GOTO 5

C  selection of valence
      CALL PHO_SELSX2(XPOT1,XPOT2,XMIN,XSUM1,XSUM2,XMAX1,XMAX2,
     &  XSOFT1,XSOFT2,IREJ)
      IF(IREJ.NE.0) THEN
        IF(MSOFT-MSMIN.GE.2) THEN
          MSOFT = MSMIN
          GOTO 10
        ENDIF
        IF(IDEB(31).GE.2) WRITE(ErrorOut,'(1X,A,1P,4E11.4)')
     &    'PHO_SELSXI: REJECTION BY PHO_SELSX2 (XSUM1/2,XMAX1/2)',
     &    XSUM1,XSUM2,XMAX1,XMAX2
        RETURN
      ENDIF

      XS1 = 1.D0-XSOFT1(1)
      XS2 = 1.D0-XSOFT2(1)
      RETURN

 1000 CONTINUE
      IREJ = 1
      IF(IDEB(14).GE.2) THEN
        WRITE(ErrorOut,'(1X,2A,3I4)') 'PHO_SELSXI: ',
     &    'REJECTION (MSOFT,ITRY0/1)',MSOFT,ITRY0,ITRY1
        DO 300 I=1,MSOFT
          WRITE(ErrorOut,
     * '(5X,I4,1P4E11.3)') I,XMIN(1,I),XMIN(2,I),XMAX1,XMAX2
 300    CONTINUE
      ENDIF

      END


CDECK  ID>, PHO_SELCOL
      SUBROUTINE PHO_SELCOL(ICO1,ICO2,ICOA1,ICOA2,ICOB1,ICOB2,IMODE)
C********************************************************************
C
C    color combinatorics
C
C    input:         ICO1,2   colors of incoming particle
C                   IMODE    -2  output of initialization status
C                            -1  initialization
C                                   ICINP(1) selection mode
C                                            0   QCD
C                                            1   large N_c expansion
C                                   ICINP(2) max. allowed color
C                            0   clear internal color counter
C                            1   hadron into two colored objects
C                            2   quark into quark gluon
C                            3   gluon into gluon gluon
C                            4   gluon into quark antiquark
C
C    output:        ICOA1,2  colors of first outgoing particle
C                   ICOB1,2  colors of second outgoing particle
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD


      DATA METHOD /0/, II /0/

      ICI1 = ICO1
      ICI2 = ICO2
      IF(METHOD.EQ.0) THEN

        IF(IMODE.EQ.1) THEN
          II = II+1
          IF(II.GT.MAXCOL)
     &      II = MIN(PHO_RNDM(DUM)*MAXCOL+1.00001,DBLE(MAXCOL))
          ICOA1 = II
          ICOA2 = 0
          ICOB1 = -II
          ICOB2 = 0
        ELSE IF(IMODE.EQ.2) THEN
          II = II+1
          IF(II.GT.MAXCOL)
     &      II = MIN(PHO_RNDM(DUM)*MAXCOL+1.00001,DBLE(MAXCOL))
          ICOA2 = 0
          IF(ICI1.GT.0) THEN
            ICOA1 = II
            ICOB1 = ICI1
            ICOB2 = -II
          ELSE
            ICOA1 = -II
            ICOB1 = II
            ICOB2 = ICI1
          ENDIF
        ELSE IF(IMODE.EQ.3) THEN
          II = II+1
          IF(II.GT.MAXCOL)
     &      II = MIN(PHO_RNDM(DUM)*MAXCOL+1.00001,DBLE(MAXCOL))
          IF(PHO_RNDM(DUM).GT.0.5D0) THEN
            ICOA1 = ICI1
            ICOA2 = -II
            ICOB1 = II
            ICOB2 = ICI2
          ELSE
            ICOB1 = ICI1
            ICOB2 = -II
            ICOA1 = II
            ICOA2 = ICI2
          ENDIF
        ELSE IF(IMODE.EQ.4) THEN
          ICOA1 = ICI1
          ICOA2 = 0
          ICOB1 = ICI2
          ICOB2 = 0
        ELSE IF(IMODE.EQ.0) THEN
          II = 0
        ELSE IF(IMODE.EQ.-1) THEN
          METHOD = ICI1
          MAXCOL = ICI2
        ELSE IF(IMODE.EQ.-2) THEN
          WRITE(ErrorOut,
     * '(1X,A,2I5)') 'PHO_SELCOL: METHOD,MAXCOL',
     &      METHOD,MAXCOL
        ELSE
          WRITE(ErrorOut,
     * '(1X,A,I5)') 'PHO_SELCOL:ERROR:unsupported mode',IMODE
          CALL PHO_ABORT
        ENDIF

      ELSE
        WRITE(ErrorOut,'(1X,A,I5)')
     &    'PHO_SELCOL:ERROR:UNSUPPORTED METHOD SELECTED',METHOD
        CALL PHO_ABORT
      ENDIF

      II = ABS(II)
      IF(IDEB(75).GE.10) THEN
        WRITE(ErrorOut,
     * '(1X,A,I5,I12,I5)') 'PHO_SELCOL: IMODE,MAXCOL,II',
     &    IMODE,MAXCOL,II
        WRITE(ErrorOut,'(10X,A,2I5)') 'input  colors',ICI1,ICI2
        WRITE(ErrorOut,
     * '(10X,A,4I5)') 'output colors',ICOA1,ICOA2,ICOB1,ICOB2
      ENDIF

      END

CDECK  ID>, ipho_diqu
      INTEGER FUNCTION IPHO_DIQU(IQ1,IQ2)
C***********************************************************************
C
C     selection of diquark number (PDG convention)
C
C***********************************************************************

      IMPLICIT NONE

      SAVE

      INTEGER IQ1,IQ2

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


C  external functions
      DOUBLE PRECISION PHO_RNDM

C  local variables
      INTEGER I0,I1,I2
      DOUBLE PRECISION DUM


      I1 = ABS(IQ1)
      I2 = ABS(IQ2)

      IF(I1.EQ.I2) THEN
        I0 = I1*1100+3
      ELSE
        I0 = MAX(I1,I2)*1000+MIN(I1,I2)*100
        IF(PHO_RNDM(DUM).GT.PARMDL(135)) THEN
          I0 = I0+1
        ELSE
          I0 = I0+3
        ENDIF
      ENDIF

      IPHO_DIQU = SIGN(I0,IQ1)

      END



CDECK  ID>, PHO_PARREM
      SUBROUTINE PHO_PARREM(INDX,IOUT,IREM,IREJ)
C**********************************************************************
C
C     selection of particle remnant flavour(s) (quark or diquark)
C
C     input:    INDX   index of particle in /POEVT1/
C               IOUT   parton which was taken out
C
C     output:   IREM   remnant according to valence flavours
C               IREJ   0  flavour combination possible
C                      1  flavour combination impossible
C
C     all particle ID are given according to PDG conventions
C
C**********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      INTEGER INDX,IOUT,IREM,IREJ

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)


C  external functions
      INTEGER IPHO_DIQU

C  local variables
      INTEGER ID,IS,ID1,ID2,I,K,K1,K2,IQUA,IDQ
      DIMENSION IQUA(3),IDQ(2)


      ID1 = IDHEP(INDX)
      ID2 = IMPART(INDX)
      IREJ = 0

      IF(ID2.EQ.0) THEN
        WRITE(ErrorOut,
     * '(1X,A,I6)') 'PHO_PARREM: no CPC ID available for',INDX
        CALL PHO_ABORT
      ENDIF

C  particle with flavour mixing
      IF(ID1.EQ.22) THEN
C  photon
        IREM = -IOUT
        GOTO 100
      ELSE IF((ID1.EQ.111).OR.(ID1.EQ.113).OR.(ID1.EQ.223)) THEN
C  pi0, rho0, and omega
        IF(ABS(IOUT).LE.2) THEN
          IREM = -IOUT
          GOTO 100
        ELSE
          GOTO 150
        ENDIF
C  pomeron and reggeon
      ELSE IF((ID1.EQ.990).OR.(ID1.EQ.110)) THEN
        IREM = -IOUT
        GOTO 100
      ENDIF

C  ordinary hadron
      ID = ABS(ID2)
      IS = SIGN(1,ID2)
      IQUA(1) = IQ_LIST(1,ID)*IS
      IQUA(2) = IQ_LIST(2,ID)*IS
      IQUA(3) = IQ_LIST(3,ID)*IS

C  compare to flavour content
      IF(ABS(IOUT).LT.1000) THEN
C  single quark requested
        IF(IQUA(1).EQ.IOUT) THEN
          K1 = 2
          K2 = 3
        ELSE IF(IQUA(2).EQ.IOUT) THEN
          K1 = 1
          K2 = 3
        ELSE IF(IQUA(3).EQ.IOUT) THEN
          K1 = 1
          K2 = 2
        ELSE
          GOTO 150
        ENDIF
        IF(IQUA(3).EQ.0) THEN
          IREM = IQUA(K1)
        ELSE
          IREM = IPHO_DIQU(IQUA(K1),IQUA(K2))
        ENDIF
      ELSE IF(IQUA(3).NE.0) THEN
C  diquark requested from baryon
        IDQ(1) = IOUT/1000
        IDQ(2) = (IOUT-IDQ(1)*1000)/100
        DO I=1,2
          DO K=1,3
            IF(IDQ(I).EQ.IQUA(K)) THEN
              IQUA(K) = 0
              GOTO 110
            ENDIF
          ENDDO
          GOTO 150
 110      CONTINUE
        ENDDO
        IREM = IQUA(1)+IQUA(2)+IQUA(3)
      ENDIF

 100  CONTINUE
C  debug output
      IF(IDEB(72).GE.10) WRITE(ErrorOut,'(1X,A,5I6)')
     &  'PHO_PARREM: INDX,ID-PDG,ID-BAM,IOUT,IREM',
     &  INDX,ID1,ID2,IOUT,IREM
      RETURN

C  rejection
 150  CONTINUE
      IREJ = 1
      IF(IDEB(72).GE.2) WRITE(ErrorOut,'(1X,A,5I7)')
     &  'PHO_PARREM: REJECTION IDPDG,Q1-3,IOUT',IDHEP(INDX),IQUA,IOUT

      END


CDECK  ID>, PHO_VALFLA
      SUBROUTINE PHO_VALFLA(IPAR,IFL1,IFL2,E1,E2)
C***********************************************************************
C
C     selection of valence flavour decomposition of particle IPAR
C
C     input:    IPAR   particle index in /POEVT1/
C                      -1   initialization
C                      -2   output of statistics
C               XMASS  mass of particle
C                      (important for pomeron:
C                       mass dependent flavour sampling)
C
C     output:   IFL1,IFL2
C               baryon: IFL1  diquark flavour
C               (valence flavours according to PDG conventions)
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( EPS    =  0.1D0,
     &            DEPS   =  1.D-15)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)


      DATA ITMX / 5 /


      IF(IPAR.GT.0) THEN
        K = IPAR
C  select particle code
        ID1 = IDHEP(K)
        ID  = ABS(IMPART(K))
        IBAR = IPHO_BAR3(K,2)
        ITER = 0

 10     CONTINUE

        IFL1 = 0
        IFL2 = 0
        ITER = ITER+1
        IF(ITER.GT.ITMX) THEN
          WRITE(ErrorOut,
     * '(1x,2a,i10,1p,2e11.3)') 'PHO_VALFLA: ',
     &      'NO VALENCES FOUND FOR (IPAR,E1,E2)',IPAR,E1,E2
          RETURN
        ENDIF


C  not baryon
        IF(IBAR.EQ.0) THEN

C  photon
          IF(ID1.EQ.22) THEN
C  charge dependent flavour sampling
 15         CONTINUE
            K = INT(PHO_RNDM(E1)*6.D0)+1
            IF(K.LE.4) THEN
              IFL1 = 2
              IFL2 = -2
            ELSE IF(K.EQ.5) THEN
              IFL1 = 1
              IFL2 = -1
            ELSE
              IFL1 = 3
              IFL2 = -3
            ENDIF
C  optional strangeness suppression
            IF((IFL1.EQ.3).AND.(PHO_RNDM(E2).GT.PARMDL(160))) GOTO 15
            IF(PHO_RNDM(DUM).LT.0.5D0) THEN
              K = IFL1
              IFL1 = IFL2
              IFL2 = K
            ENDIF

C  pomeron, reggeon
          ELSE IF((ID1.EQ.990).OR.(ID1.EQ.110)) THEN
            IF(ISWMDL(19).EQ.0) THEN
C  SU(3) symmetric valences
              K = INT(PHO_RNDM(E1)*3.D0)+1
              IF(PHO_RNDM(DUM).LT.0.5D0) THEN
                IFL1 = K
              ELSE
                IFL1 = -K
              ENDIF
              IFL2 = -IFL1
            ELSE IF(ISWMDL(19).EQ.1) THEN
C  mass dependent flavour sampling
              EMIN = MIN(E1,E2)
              CALL PHO_SEAFLA(IPAR,IFL1,IFL2,EMIN)
            ELSE
              WRITE(ErrorOut,'(/1X,2A,I5)') 'PHO_VALFLA: ',
     &          'INVALID FLAVOUR SELECTION MODE ISWMDL(19)',ISWMDL(19)
              CALL PHO_ABORT
            ENDIF

C  meson with flavour mixing
          ELSE IF((ID1.EQ.111).OR.(ID1.EQ.113).OR.(ID1.EQ.223)) THEN
            K = INT(2.D0*PHO_RNDM(E1))+1
            IFL1 = K
            IFL2 = -K
C  meson (standard)
          ELSE
            K = INT(2.D0*PHO_RNDM(E1))+1
            IFL1 = IQ_LIST(K,ID)
            K = MOD(K,2) + 1
            IFL2 = IQ_LIST(K,ID)
            IF(IFL1.EQ.0) THEN
              EMIN = MIN(E1,E2)
              CALL PHO_SEAFLA(IPAR,IFL1,IFL2,EMIN)
            ENDIF
          ENDIF

C  baryon
        ELSE
          K = INT(2.999999D0*PHO_RNDM(E2))+1
          K1 = MOD(K,3)+1
          K2 = MOD(K1,3)+1
          IFL1 = IPHO_DIQU(IQ_LIST(K1,ID),IQ_LIST(K2,ID))
          IFL2 = IQ_LIST(K,ID)
        ENDIF

C  change sign for antiparticles
        IF(ID1.LT.0) THEN
          IFL1 = -IFL1
          IFL2 = -IFL2
        ENDIF

************************************************************************
C  check kinematic constraints
*       IF((PHO_PMASS(IFL1,3).GT.E1)
*    &     .OR.(PHO_PMASS(IFL2,3).GT.E2)) GOTO 10
************************************************************************

C  debug output
        IF(IDEB(46).GE.10) WRITE(ErrorOut,
     * '(1X,A,I5,2E12.4,2I7)')
     &    'PHO_VALFLA: IPAR,MASS1/2,FL1/2',IPAR,E1,E2,IFL1,IFL2

      ELSE IF(IPAR.EQ.-1) THEN
C  initialization

      ELSE IF(IPAR.EQ.-2) THEN
C  output of final statistics

      ELSE
        WRITE(ErrorOut,
     * '(1X,A,I10)') 'PHO_VALFLA: invalid particle (IPAR)',IPAR
        CALL PHO_ABORT
      ENDIF

      END



CDECK  ID>, PHO_REGFLA
      SUBROUTINE PHO_REGFLA(JM1,JM2,IFLR1,IFLR2,IREJ)
C**********************************************************************
C
C     selection of reggeon flavours
C
C     input:    JM1,JM2      position index of mother hadrons
C
C     output:   IFLR1,IFLR2  valence flavours according to
C                            PDG conventions and JM1,JM2
C               IREJ         0  reggeon possible
C                            1  reggeon impossible
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( EPS    =  0.1D0,
     &            DEPS   =  1.D-15)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)



      IF(JM1.GT.0) THEN
        IREJ = 0
        ITER = 0
C  available energy
        E1   = SQRT((PHEP(4,JM1)+PHEP(4,JM2))**2
     &             -(PHEP(1,JM1)+PHEP(1,JM2))**2
     &             -(PHEP(2,JM1)+PHEP(2,JM2))**2
     &             -(PHEP(3,JM1)+PHEP(3,JM2))**2)/2.D0
 50     CONTINUE
        ITER = ITER+1
        IF(ITER.GT.50) THEN
          IREJ = 1
C  debug output
          IF(IDEB(41).GE.2) WRITE(ErrorOut,
     * '(/1X,A,2I7,1P,E12.4)')
     &      'PHO_REGFLA: REJECTION, NO REGGEON FOUND FOR',
     &      IDHEP(JM1),IDHEP(JM2),E1
          RETURN
        ENDIF

        CALL PHO_VALFLA(JM1,IFLA1,IFLA2,E1,E1)
        CALL PHO_VALFLA(JM2,IFLB1,IFLB2,E1,E1)
        IF(IFLA1.EQ.-IFLB1) THEN
          IFLR1 = IFLA2
          IFLR2 = IFLB2
        ELSE IF(IFLA1.EQ.-IFLB2) THEN
          IFLR1 = IFLA2
          IFLR2 = IFLB1
        ELSE IF(IFLA2.EQ.-IFLB1) THEN
          IFLR1 = IFLA1
          IFLR2 = IFLB2
        ELSE IF(IFLA2.EQ.-IFLB2) THEN
          IFLR1 = IFLA1
          IFLR2 = IFLB1
        ELSE
C  debug output
          IF(IDEB(41).GE.25) WRITE(ErrorOut,'(/1X,A,3I4)')
     &      'PHO_REGFLA: INT.REJECTION JM1,JM2,ITRY',JM1,JM2,ITER
          GOTO 50
        ENDIF
C  debug output
        IF(IDEB(41).GE.10) WRITE(ErrorOut,
     * '(1X,A,/5X,2I4,2I6,2I5,1PE10.3)')
     &    'PHO_REGFLA: JM1/2,PDG-ID1/2,IFLR1/2,MASS',
     &    JM1,JM2,IDHEP(JM1),IDHEP(JM2),IFLR1,IFLR2,E1
      ELSE IF(JM1.EQ.-1) THEN
C  initialization
      ELSE IF(JM1.EQ.-2) THEN
C  output of statistics
      ELSE
        WRITE(ErrorOut,'(1X,A,I10)')
     &    'PHO_REGFLA: INVALID MOTHER PARTICLE (JM1)',JM1
        CALL PHO_ABORT
      ENDIF

      END



CDECK  ID>, PHO_SEAFLA
      SUBROUTINE PHO_SEAFLA(IPAR,IFL1,IFL2,CHMASS)
C**********************************************************************
C
C     selection of sea flavour content of particle IPAR
C
C     input:    IPAR    particle index in /POEVT1/
C               CHMASS  available invariant string mass
C                       positive mass --> use BAMJET method
C                       negative mass --> SU(3) symmetric sea according
C                       to values given in PARMDL(1-6)
C               IPAR    -1 initialization
C                       -2 output of statistics
C
C     output:   sea flavours according to PDG conventions
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( EPS    =  0.1D0,
     &            DEPS   =  1.D-15)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  some hadron information, will be deleted in future versions
      INTEGER NFS
      DOUBLE PRECISION QMASS,BET,PCOUDI,PNORM,VALPRG
      COMMON /POHDRN/ QMASS(6),BET,PCOUDI,PNORM,VALPRG(2),NFS


      IF(IPAR.GT.0) THEN
        IF((ISWMDL(20).EQ.1).OR.(CHMASS.LT.0.D0)) THEN
C  constant weights for sea
 15       CONTINUE
            SUM = 0.D0
            DO 40 K=1,NFSEA
              SUM = SUM + PARMDL(K)
 40         CONTINUE
            XI = PHO_RNDM(SUM)*SUM
            SUM = 0.D0
            DO 50 K=1,NFSEA
              SUM = SUM + PARMDL(K)
              IF(XI.LE.SUM) GOTO 55
 50         CONTINUE
 55         CONTINUE
          IF(K.GT.NFSEA) GOTO 15
        ELSE
C  mass dependent flavour sampling
 10       CONTINUE
            CALL PHO_FLAUX(CHMASS,K)
          IF(K.GT.NFSEA) GOTO 10
        ENDIF
        IF(PHO_RNDM(CHMASS).GT.0.5D0) K = -K
        IFL1 = K
        IFL2 = -K
        IF(IDEB(46).GE.10) THEN
          WRITE(ErrorOut,
     * '(1X,A,3I5,E12.4)') 'PHO_SEAFLA:IPAR,IFL1,IFL2,MASS',
     &      IPAR,IFL1,IFL2,CHMASS
        ENDIF
      ELSE IF(IPAR.EQ.-1) THEN
C  initialization
        NFSEA = NFS
      ELSE IF(IPAR.EQ.-2) THEN
C  output of statistics
      ELSE
        WRITE(ErrorOut,
     * '(1X,A,I10)') 'PHO_SEAFLA:ERROR:INVALID IPAR',IPAR
        CALL PHO_ABORT
      ENDIF

      END


CDECK  ID>, PHO_FLAUX
      SUBROUTINE PHO_FLAUX(EQUARK,K)
C***********************************************************************
C
C    auxiliary subroutine to select flavours
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS   =  1.D-14 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  some hadron information, will be deleted in future versions
      INTEGER NFS
      DOUBLE PRECISION QMASS,BET,PCOUDI,PNORM,VALPRG
      COMMON /POHDRN/ QMASS(6),BET,PCOUDI,PNORM,VALPRG(2),NFS


      DIMENSION WGHT(9)

C  calculate weights for given energy
      IF(EQUARK.LT.QMASS(1)) THEN
        IF(IDEB(16).GE.5)
     &    WRITE(ErrorOut,
     * '(1X,A,E12.3)') 'PHO_FLAUX: VERY SMALL MASS',
     &      EQUARK
        WGHT(1) = 0.5D0
        WGHT(2) = 0.5D0
        WGHT(3) = 0.D0
        WGHT(4) = 0.D0
        SUM = 1.D0
      ELSE
        SUM = 0.D0
        DO 305 K=1,NFS
          IF(EQUARK.GT.QMASS(K)) THEN
            WGHT(K) = PHO_BETAF(EQUARK,QMASS(K),BET)
          ELSE
            WGHT(K) = 0.D0
          ENDIF
          SUM = SUM + WGHT(K)
 305    CONTINUE
      ENDIF
C  sample flavours
      XI = SUM*(PHO_RNDM(SUM)-DEPS)
      K = 0
      SUM = 0.D0
 400  CONTINUE
        K = K+1
        SUM = SUM + WGHT(K)
      IF(XI.GT.SUM) GOTO 400
C  debug output
      IF(IDEB(16).GE.20) THEN
        WRITE(ErrorOut,
     * '(1X,A,I5)') 'PHO_FLAUX: selected flavour',K
      ENDIF
      END


CDECK  ID>, PHO_BETAF
      DOUBLE PRECISION FUNCTION PHO_BETAF(X1,X2,BET)
C********************************************************************
C
C     weights of different quark flavours
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      AX=0.D0
      BETX1=BET*X1
      IF(BETX1.LT.70.D0) AX=-1.D0/BET**2*(BETX1+1.D0)*EXP(-BETX1)
      AY=1.D0/BET**2*(BET*X2+1.D0)*EXP(-BET*X2)

      PHO_BETAF=AX+AY

      END



CDECK  ID>, PHO_MCHECK
      SUBROUTINE PHO_MCHECK(J1,IREJ)
C********************************************************************
C
C    check parton momenta for fragmentation
C
C    input:      J1      first  string number
C                        /POEVT1/
C                        /POSTRG/
C
C    output:             /POEVT1/
C                        /POSTRG/
C                IREJ    0  successful
C                        1  failure
C
C    in case of very small string mass:
C                NNCH    mass label of string
C                        0  string
C                       -1  octett baryon / pseudo scalar meson
C                        1  decuplett baryon / vector meson
C                IBHAD   hadron number according to CPC,
C                        string will be treated as resonance
C                        (sometimes far off mass shell)
C
C    constant WIDTH ( 0.01GeV ) determines range of acceptance
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( WIDTH  =  0.01D0,
     &            DEPS   =  1.D-15 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  color string configurations including collapsed strings and hadrons
      INTEGER MSTR
      PARAMETER (MSTR=500)
      INTEGER NPOS,NCODE,IPAR1,IPAR2,IPAR3,IPAR4,NNCH,IBHAD
      COMMON /POSTRG/ NPOS(4,MSTR),NCODE(MSTR),
     &                IPAR1(MSTR),IPAR2(MSTR),IPAR3(MSTR),IPAR4(MSTR),
     &                NNCH(MSTR),IBHAD(MSTR),ISTR

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)


      IREJ = 0
C  quark antiquark jet
      STRM = PHEP(5,NPOS(1,J1))
      IF(NCODE(J1).EQ.3) THEN
        CALL PHO_MEMASS(IPAR1(J1),IPAR2(J1),
     &    AMPS,AMPS2,AMVE,AMVE2,IPS,IVE)
        IF(IDEB(18).GE.5)
     &    WRITE(ErrorOut,'(1X,A,/3X,I3,5E12.3)')
     &      'PHO_MCHECK:1.STRING NO, CHMASS,AMPS,AMPS2,AMVE,AMVE2 ',
     &      J1,STRM,AMPS,AMPS2,AMVE,AMVE2
        IF(STRM.LT.AMPS) THEN
          IREJ = 1
          IFAIL(20) = IFAIL(20) + 1
          RETURN
        ELSE IF(STRM.LT.AMPS2) THEN
          IF(STRM.LT.(AMVE-WIDTH)) THEN
            NNCH(J1) = -1
            IBHAD(J1) = IPS
          ELSE
            NNCH(J1) = 1
            IBHAD(J1) = IVE
          ENDIF
        ELSE
          NNCH(J1) = 0
          IBHAD(J1) = 0
        ENDIF
C  quark diquark or v.s. jet
      ELSE IF((NCODE(J1).EQ.4).OR.(NCODE(J1).EQ.6)) THEN
        CALL PHO_BAMASS(IPAR1(J1),IPAR2(J1),IPAR3(J1),
     &              AM8,AM82,AM10,AM102,I8,I10)
        IF(IDEB(18).GE.5)
     &    WRITE(ErrorOut,'(1X,A,/5X,I3,5E12.3)')
     &            'PHO_MCHECK:1.STRING NO, CHMASS,AM8,AM82,AM10,AM102 ',
     &            J1,STRM,AM8,AM82,AM10,AM102
        IF(STRM.LT.AM8) THEN
          IREJ = 1
          IFAIL(19) = IFAIL(19) + 1
          RETURN
        ELSE IF(STRM.LT.AM82) THEN
          IF(STRM.LT.(AM10-WIDTH)) THEN
            NNCH(J1) = -1
            IBHAD(J1) = I8
          ELSE
            NNCH(J1) = 1
            IBHAD(J1) = I10
          ENDIF
        ELSE
          NNCH(J1) = 0
          IBHAD(J1) = 0
        ENDIF
C  diquark a-diquark string
      ELSE IF(NCODE(J1).EQ.5) THEN
        CALL PHO_DQMASS(IPAR1(J1),IPAR2(J1),IPAR3(J1),IPAR4(J1),
     &              AM82,AM102)
        IF(IDEB(18).GE.5)
     &    WRITE(ErrorOut,'(1X,A,/5X,I3,3E12.3)')
     &            'PHO_MCHECK:1.STRING NO, CHMASS,AM82,AM102 ',
     &            J1,STRM,AM82,AM102
        IF(STRM.LT.AM82) THEN
          IREJ = 1
          IFAIL(19) = IFAIL(19) + 1
          RETURN
        ELSE
          NNCH(J1) = 0
          IBHAD(J1) = 0
        ENDIF
      ELSE IF(NCODE(J1).LT.0) THEN
        RETURN
      ELSE
        WRITE(ErrorOut,'(/,1X,2A,2I8)')  'PHO_MCHECK: ',
     &    'INCONSISTENT FLAVOURS FOR STRING (NO,NCODE)',J1,NCODE(J1)
        CALL PHO_ABORT
      ENDIF
      END


CDECK  ID>, PHO_POMCOR
      SUBROUTINE PHO_POMCOR(IREJ)
C********************************************************************
C
C    join quarks to gluons in case of too small masses
C
C    input:              /POEVT1/
C                        /POSTRG/
C                IREJ    -1          initialization
C                        -2          output of statistics
C
C    output:             /POEVT1/
C                        /POSTRG/
C                IREJ    0  successful
C                        1  failure
C
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( EPS    =  1.D-10 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  color string configurations including collapsed strings and hadrons
      INTEGER MSTR
      PARAMETER (MSTR=500)
      INTEGER NPOS,NCODE,IPAR1,IPAR2,IPAR3,IPAR4,NNCH,IBHAD
      COMMON /POSTRG/ NPOS(4,MSTR),NCODE(MSTR),
     &                IPAR1(MSTR),IPAR2(MSTR),IPAR3(MSTR),IPAR4(MSTR),
     &                NNCH(MSTR),IBHAD(MSTR),ISTR


      DIMENSION PJ(4)

      IF(IREJ.EQ.-1) THEN
        ICTOT = 0
        ICCOR = 0
        RETURN
      ELSE IF(IREJ.EQ.-2) THEN
        WRITE(ErrorOut,'(/1X,A,2I8)')
     &    'PHO_POMCOR: TOTAL/JOINED STRINGS',ICTOT,ICCOR
        RETURN
      ENDIF
C
      IREJ = 0
C
      NITER = 100
      ITER = 0
      ICTOT = ICTOT+ISTR
      IF(ISWMDL(25).LE.0) RETURN
C  debug string entries
      IF(IDEB(83).GE.25) CALL PHO_PRSTRG
C
 50   CONTINUE
      ITER = ITER+1
      IF(ITER.GE.NITER) THEN
        IREJ = 1
        IF(IDEB(83).GE.2) THEN
          WRITE(ErrorOut,
     * '(1X,A,2I5)') 'PHO_POMCOR: rejection',ITER,NITER
          IF(IDEB(83).GE.10) CALL PHO_PREVNT(0)
        ENDIF
        RETURN
      ENDIF
C
C  check mass limits
      ISTRO = ISTR
      DO 100 I=1,ISTRO
        IF(NCODE(I).LT.0) GOTO 99
        J1 = NPOS(1,I)
        NRPOM = IPHIST(2,J1)
        IF(NRPOM.GE.100) GOTO 99
        CMASS0 = PHEP(5,J1)
C  get masses
        IF(NCODE(I).EQ.3) THEN
          CALL PHO_MEMASS(IPAR1(I),IPAR2(I),AM1,AM2,AM3,AM4,IP1,IP2)
        ELSE IF((NCODE(I).EQ.4).OR.(NCODE(I).EQ.6)) THEN
          CALL PHO_BAMASS(IPAR1(I),IPAR2(I),IPAR3(I),
     &                AM1,AM2,AM3,AM4,IP1,IP2)
        ELSE IF(NCODE(I).EQ.5) THEN
          CALL PHO_DQMASS(IPAR1(I),IPAR2(I),IPAR3(I),IPAR4(I),
     &                AM1,AM2)
          AM3 = 0.D0
          AM4 = 0.D0
          IP1 = 0
          IP2 = 0
        ELSE IF(NCODE(I).EQ.7) THEN
          GOTO 99
        ELSE IF(NCODE(I).LT.0) THEN
          GOTO 99
        ELSE
          WRITE(ErrorOut,
     * '(/,1X,A,2I5)') 'ERROR:PHO_POMCOR:STRING NO,NCODE ',
     &                            J1,NCODE(I)
          CALL PHO_ABORT
        ENDIF
        IF(IDEB(83).GE.5)
     &    WRITE(ErrorOut,'(1X,A,/3X,2I4,5E11.3,2I5)')
     &      'PHO_POMCOR: STRING,POM,CHMASS,AM1,AM2,AM3,AM4,IP1,IP2',
     &      I,NRPOM,CMASS0,AM1,AM2,AM3,AM4,IP1,IP2
C  select masses to correct
        IF(CMASS0.LT.MAX(AM2,AM4)) THEN
          DO 200 K=1,ISTRO
            IF((K.NE.I).AND.(NCODE(K).GE.0)) THEN
              J2 = NPOS(1,K)
C  join quarks to gluon
              IF(NRPOM.EQ.IPHIST(2,J2)) THEN
C  flavour check
                IFL1 = 0
                IFL2 = 0
                PROB1 = 0.D0
                PROB2 = 0.D0
                KK1 = NPOS(2,I)
                KK2 = NPOS(2,K)
                IF(IDHEP(KK1)+IDHEP(KK2).EQ.0) THEN
                  CMASS = (PHEP(4,KK1)+PHEP(4,KK2))**2
     &                   -(PHEP(1,KK1)+PHEP(1,KK2))**2
     &                   -(PHEP(2,KK1)+PHEP(2,KK2))**2
     &                   -(PHEP(2,KK1)+PHEP(2,KK2))**2
                  IFL1 = ABS(IDHEP(KK1))
                  IF(IFL1.GT.2) THEN
                    PROB1 = 0.1D0/MAX(CMASS,EPS)
                  ELSE
                    PROB1 = 0.9D0/MAX(CMASS,EPS)
                  ENDIF
                ENDIF
                KK1 = ABS(NPOS(3,I))
                KK2 = ABS(NPOS(3,K))
                IF(IDHEP(KK1)+IDHEP(KK2).EQ.0) THEN
                  CMASS = (PHEP(4,KK1)+PHEP(4,KK2))**2
     &                   -(PHEP(1,KK1)+PHEP(1,KK2))**2
     &                   -(PHEP(2,KK1)+PHEP(2,KK2))**2
     &                   -(PHEP(2,KK1)+PHEP(2,KK2))**2
                  IFL2 = ABS(IDHEP(KK1))
                  IF(IFL2.GT.2) THEN
                    PROB2 = 0.1D0/MAX(CMASS,EPS)
                  ELSE
                    PROB2 = 0.9D0/MAX(CMASS,EPS)
                  ENDIF
                ENDIF
                IF(IFL1+IFL2.EQ.0) GOTO 99
C  fusion possible
                ICCOR = ICCOR+1
                IF((PHO_RNDM(CMASS)*(PROB1+PROB2)).LT.PROB1) THEN
                  JJ = 2
                  JE = 3
                ELSE
                  JJ = 3
                  JE = 2
                ENDIF
                KK1 = ABS(NPOS(JJ,I))
                KK2 = ABS(NPOS(JJ,K))
                I1 = ABS(NPOS(JE,I))
                I2 = KK1
                IS = SIGN(1,I2-I1)
                I2 = I2 - IS
                K1 = KK2
                K2 = ABS(NPOS(JE,K))
                KS = SIGN(1,K2-K1)
                K1 = K1 + KS
                IP1 = NHEP+1
C  copy mother partons of string I
                DO 300 II=I1,I2,IS
                  CALL PHO_REGPAR(-1,IDHEP(II),0,J1,J2,PHEP(1,II),
     &              PHEP(2,II),PHEP(3,II),PHEP(4,II),I,IPHIST(2,II),
     &              ICOLOR(1,II),ICOLOR(2,II),IPOS,1)
 300            CONTINUE
C  register gluon
                DO 350 II=1,4
                  PJ(II) = PHEP(II,KK1)+PHEP(II,KK2)
 350            CONTINUE
                CALL PHO_REGPAR(-1,21,0,J1,J2,PJ(1),PJ(2),PJ(3),PJ(4),
     &            I,IPHIST(2,KK2),ICOLOR(1,KK1),ICOLOR(1,KK2),IPOS,1)
C  copy mother partons of string K
                DO 400 II=K1,K2,KS
                  CALL PHO_REGPAR(-1,IDHEP(II),0,J1,J2,PHEP(1,II),
     &              PHEP(2,II),PHEP(3,II),PHEP(4,II),I,IPHIST(2,II),
     &              ICOLOR(1,II),ICOLOR(2,II),IPOS,1)
 400            CONTINUE
C  create new string entry
                DO 450 II=1,4
                  PJ(II) = PHEP(II,J1)+PHEP(II,J2)
 450            CONTINUE
                IP2 = IPOS
                CALL PHO_REGPAR(-1,90,0,IP1,-IP2,PJ(1),PJ(2),PJ(3),
     &            PJ(4),I,IPHIST(2,J1),ICOLOR(1,J1)+ICOLOR(1,J2),
     &            ICOLOR(2,J1)+ICOLOR(2,J2),IPOS,1)
C  delete string K in /POSTRG/
                NCODE(K) = -999
C  update string I in /POSTRG/
                NPOS(1,I) = IPOS
                NPOS(2,I) = IP1
                NPOS(3,I) = -IP2
C  calculate new CPC string codes
                CALL PHO_ID2STR(IDHEP(IP1),IDHEP(IP2),NCODE(I),IPAR1(I),
     &            IPAR2(I),IPAR3(I),IPAR4(I))
                GOTO 99
              ENDIF
            ENDIF
 200      CONTINUE
        ENDIF
 99     CONTINUE
 100  CONTINUE
      IF(IDEB(83).GE.20) THEN
        WRITE(ErrorOut,
     * '(1X,A)') 'PHO_POMCOR: after string recombination'
        IF(IDEB(83).GE.22) THEN
          CALL PHO_PRSTRG
          CALL PHO_PREVNT(0)
        ENDIF
      ENDIF

      END



CDECK  ID>, PHO_MASCOR
      SUBROUTINE PHO_MASCOR(IREJ)
C********************************************************************
C
C    check and adjust parton momenta for fragmentation
C
C    input:      /POEVT1/
C                /POSTRG/
C                IREJ    -1          initialization
C                        -2          output of statistics
C
C    output:     /POEVT1/
C                /POSTRG/
C                IREJ    0  successful
C                        1  failure
C
C    in case of very small string mass:
C       - direct manipulation of /POEVT1/ and /POEVT2/
C       - string will be deleted from /POSTRG/ (label -99)
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( EPS    =  1.D-10,
     &            EMIN   =  0.3D0,
     &            DEPS   =  1.D-15)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  color string configurations including collapsed strings and hadrons
      INTEGER MSTR
      PARAMETER (MSTR=500)
      INTEGER NPOS,NCODE,IPAR1,IPAR2,IPAR3,IPAR4,NNCH,IBHAD
      COMMON /POSTRG/ NPOS(4,MSTR),NCODE(MSTR),
     &                IPAR1(MSTR),IPAR2(MSTR),IPAR3(MSTR),IPAR4(MSTR),
     &                NNCH(MSTR),IBHAD(MSTR),ISTR


      DIMENSION PC1(4),PC2(4),P1(4),PTR(4),GAM(3),GAMB(3)

      IF(IREJ.EQ.-1) THEN
        ICTOT = 0
        ICCOR = 0
        RETURN
      ELSE IF(IREJ.EQ.-2) THEN
        WRITE(ErrorOut,'(/1X,A,2I8/)')
     &    'PHO_MASCOR: TOTAL/CONVERTED STRINGS',ICTOT,ICCOR
        RETURN
      ENDIF

      IREJ = 0
      NITER = 100
      ITER = 0
      ICTOT = ICTOT+ISTR
      IF(ISWMDL(7).EQ.-1) RETURN
C  debug /POSTRG/
      IF(IDEB(42).GE.25) CALL PHO_PRSTRG

      ITOUCH = 0
 50   CONTINUE
      ITER = ITER+1
      IF(ITER.GE.NITER) THEN
        IREJ = 1
        IF(IDEB(42).GE.2) THEN
          WRITE(ErrorOut,
     * '(1X,A,2I5)') 'PHO_MASCOR: rejection',ITER,NITER
          IF(IDEB(42).GE.10) CALL PHO_PREVNT(0)
        ENDIF
        RETURN
      ENDIF

C  check mass limits
      IF(PHO_RNDM(CMASS0).LT.0.5D0) THEN
        IM1 = 1
        IM2 = ISTR
        IST = 1
      ELSE
        IM1 = ISTR
        IM2 = 1
        IST = -1
      ENDIF
      DO 100 I=IM1,IM2,IST
        J1 = NPOS(1,I)
        CMASS0 = PHEP(5,J1)
C  get masses
        IF(NCODE(I).EQ.3) THEN
          CALL PHO_MEMASS(IPAR1(I),IPAR2(I),AM1,AM2,AM3,AM4,IP1,IP2)
        ELSE IF((NCODE(I).EQ.4).OR.(NCODE(I).EQ.6)) THEN
          CALL PHO_BAMASS(IPAR1(I),IPAR2(I),IPAR3(I),
     &                AM1,AM2,AM3,AM4,IP1,IP2)
        ELSE IF(NCODE(I).EQ.5) THEN
          CALL PHO_DQMASS(IPAR1(I),IPAR2(I),IPAR3(I),IPAR4(I),
     &              AM1,AM2)
          AM3 = 0.D0
          AM4 = 0.D0
          IP1 = 0
          IP2 = 0
        ELSE IF(NCODE(I).EQ.7) THEN
          AM1 = 0.15D0
          AM2 = 0.3D0
          AM3 = 0.765D0
          AM4 = 1.5D0
*??????????????????????????????????
          IP1 = 23
          IP2 = 33
*??????????????????????????????????
        ELSE IF(NCODE(I).LT.0) THEN
          GOTO 90
        ELSE
          WRITE(ErrorOut,
     * '(/,1X,A,2I5)') 'PHO_MASCOR:ERROR: string no,NCODE ',
     &                            J1,NCODE(I)
          CALL PHO_ABORT
        ENDIF
        IF(IDEB(42).GE.20) WRITE(ErrorOut,
     * '(1X,A,/3X,I3,5E11.3,2I5)')
     &    'PHO_MASCOR: STRING NO CHMASS,AM1,AM2,AM3,AM4,IP1,IP2:',
     &    I,CMASS0,AM1,AM2,AM3,AM4,IP1,IP2
C  select masses to correct
        IBHAD(I) = 0
        NNCH(I) = 0
C  correction needed?
C  no resonances for diquark-antidiquark and gluon-gluon strings
        IF(NCODE(I).EQ.5) THEN
          IF(CMASS0.LT.1.3D0*AM1) THEN
            IF(ISWMDL(7).LE.2) THEN
              IBHAD(I) = 90
              NNCH(I)  = -1
              CHMASS   = AM1*1.3D0
            ELSE
              IREJ = 1
              RETURN
            ENDIF
          ENDIF
        ELSE
          INEED = 0
C  resonances possible
          IF(ISWMDL(7).EQ.0) THEN
            IF(CMASS0.LT.AM1*0.99D0) THEN
              IBHAD(I) = IP1
              NNCH(I)  = -1
              CHMASS   = AM1
              INEED = 1
            ELSE IF(CMASS0.LT.MIN(AM2,AM4)*1.2D0) THEN
              DELM1 = 1.D0/((CMASS0-AM1)**2+EPS)
              DELM2 = 1.D0/((CMASS0-AM3)**2+EPS)
              IF(PHO_RNDM(DELM1).LT.DELM1/(DELM1+DELM2)) THEN
                IBHAD(I) = IP1
                NNCH(I)  = -1
                CHMASS   = AM1
              ELSE
                IBHAD(I) = IP2
                NNCH(I)  = 1
                CHMASS   = AM3
              ENDIF
            ENDIF
          ELSE IF((ISWMDL(7).EQ.1).OR.(ISWMDL(7).EQ.2)) THEN
            IF(CMASS0.LT.AM1*0.99) THEN
              IBHAD(I) = IP1
              NNCH(I) = -1
              CHMASS = AM1
              INEED = 1
            ENDIF
          ELSE IF(ISWMDL(7).EQ.3) THEN
            IF(CMASS0.LT.AM1) THEN
              IREJ = 1
              RETURN
            ENDIF
          ELSE
            WRITE(ErrorOut,'(/1X,A,I5)')
     &        'PHO_MASCOR:ERROR:UNSUPPORTED ISWMDL(7)',ISWMDL(7)
            CALL PHO_ABORT
          ENDIF
        ENDIF
C
C  correction necessary?
        IF(IBHAD(I).NE.0) THEN
C  find largest invar. mass
          IPOS = 0
          CMASS1 = -1.D0
          DO 200 J2=NHEP,3,-1

            IF(ABS(ISTHEP(J2)).EQ.1) THEN
              IF((IPHIST(1,J2).LE.0).OR.(IPHIST(1,J2).GT.ISTR)) THEN
                WRITE(ErrorOut,'(1X,2A,I7,I12)') 'PHO_MASCOR: ',
     &            'INCONSISTENT IPHIST(1,J2) ENTRY (J2,KEV):',J2,KEVENT
                CALL PHO_PREVNT(0)
              ELSE IF(NCODE(IPHIST(1,J2)).GT.0) THEN
                CMASS2= (PHEP(4,J1)+PHEP(4,J2))**2
     &                 -(PHEP(1,J1)+PHEP(1,J2))**2
     &                 -(PHEP(2,J1)+PHEP(2,J2))**2
     &                 -(PHEP(3,J1)+PHEP(3,J2))**2
                IF(CMASS2.GT.CMASS1) THEN
                  IPOS=J2
                  CMASS1=CMASS2
                ENDIF
              ENDIF
            ENDIF

 200      CONTINUE
          J2 = IPOS
          IF((J1.EQ.J2).OR.(CMASS1.LE.EMIN)) THEN
            IF(INEED.EQ.1) THEN
              IREJ = 1
              RETURN
            ELSE
              IBHAD(I) = 0
              NNCH(I) = 0
              GOTO 90
            ENDIF
          ENDIF
          ISTA = ISTHEP(J1)
          ISTB = ISTHEP(J2)
          CMASS1 = SQRT(CMASS1)
          CMASS2 = PHEP(5,J2)
          IF(CMASS1.LT.(CMASS2+CHMASS)) CMASS2 = CMASS1-1.1D0*CHMASS
          IREJ = 1
          IF(CMASS2.GT.0.D0) CALL PHO_MSHELL(PHEP(1,J1),PHEP(1,J2),
     &      CHMASS,CMASS2,PC1,PC2,IREJ)
          IF(IREJ.NE.0) THEN
            IFAIL(24) = IFAIL(24)+1
            IF(IDEB(42).GE.2) THEN
              WRITE(ErrorOut,'(1X,A,2I4)')
     &          'PHO_MASCOR: REJECTION BY PHO_MSHELL (J1,J2):',J1,J2
              IF(IDEB(42).GE.10) CALL PHO_PREVNT(0)
            ENDIF
            IREJ = 1
            RETURN
          ENDIF
C  momentum transfer
          DO 210 II=1,4
            PTR(II) = PHEP(II,J2)-PC2(II)
 210      CONTINUE
          IF(IDEB(42).GE.10) WRITE(ErrorOut,
     * '(1X,A,/5X,2I3,4E12.3)')
     &      'PHO_MASCOR: J1,J2,TRANSFER',J1,J2,PTR
C  copy parents of strings
C  register partons belonging to first string
          IF(IDHEP(J1).EQ.90) THEN
            K1 = JMOHEP(1,J1)
            K2 = MAX(JMOHEP(1,J1),-JMOHEP(2,J1))
            ESUM = 0.D0
            DO 500 II=K1,K2
              ESUM = ESUM+PHEP(4,II)
 500        CONTINUE
            IF(JMOHEP(2,J1).GT.0) ESUM = ESUM+PHEP(4,JMOHEP(2,J1))
            DO 600 II=K1,K2
              FAC = PHEP(4,II)/ESUM
              DO 650 K=1,4
                P1(K) = PHEP(K,II)+FAC*PTR(K)
 650          CONTINUE
              CALL PHO_REGPAR(-1,IDHEP(II),0,J1,J2,P1(1),P1(2),P1(3),
     &          P1(4),IPHIST(1,II),IPHIST(2,II),ICOLOR(1,II),
     &          ICOLOR(2,II),IPOS,1)
 600        CONTINUE
            K1A = IPOS+K1-K2
            IF(JMOHEP(2,J1).GT.0) THEN
              II = JMOHEP(2,J1)
              FAC = PHEP(4,II)/ESUM
              DO 675 K=1,4
                P1(K) = PHEP(K,II)+FAC*PTR(K)
 675          CONTINUE
              CALL PHO_REGPAR(-1,IDHEP(II),0,J1,J2,P1(1),P1(2),P1(3),
     &          P1(4),IPHIST(1,II),IPHIST(2,II),ICOLOR(1,II),
     &          ICOLOR(2,II),IPOS,1)
            ENDIF
            K2A = -IPOS
          ELSE
            K1A = J1
            K2A = J2
          ENDIF
C  register partons belonging to second string
          IF(IDHEP(J2).EQ.90) THEN
            CALL PHO_GETLTR(PHEP(1,J2),PC2,GAM,GAMB,DELE,IREJL)
            K1 = JMOHEP(1,J2)
            K2 = MAX(JMOHEP(1,J2),-JMOHEP(2,J2))
            ESUM = 0.D0
            DO 300 II=K1,K2
              ESUM = ESUM+PHEP(4,II)
 300        CONTINUE
            IF(JMOHEP(2,J2).GT.0) ESUM = ESUM+PHEP(4,JMOHEP(2,J2))
            DO 400 II=K1,K2
              FAC = PHEP(4,II)/ESUM
              IF(IREJL.EQ.0) THEN
                CALL PHO_MKSLTR(PHEP(1,II),P1,GAM,GAMB)
                P1(4) = P1(4)+FAC*DELE
              ELSE
                DO 450 K=1,4
                  P1(K) = PHEP(K,II)-FAC*PTR(K)
 450            CONTINUE
              ENDIF
              CALL PHO_REGPAR(-1,IDHEP(II),0,J1,J2,P1(1),P1(2),P1(3),
     &          P1(4),IPHIST(1,II),IPHIST(2,II),ICOLOR(1,II),
     &          ICOLOR(2,II),IPOS,1)
 400        CONTINUE
            K1B = IPOS+K1-K2
            IF(JMOHEP(2,J2).GT.0) THEN
              II = JMOHEP(2,J2)
              FAC = PHEP(4,II)/ESUM
              IF(IREJL.EQ.0) THEN
                CALL PHO_MKSLTR(PHEP(1,II),P1,GAM,GAMB)
                P1(4) = P1(4)+FAC*DELE
              ELSE
                DO 475 K=1,4
                  P1(K) = PHEP(K,II)-FAC*PTR(K)
 475            CONTINUE
              ENDIF
              CALL PHO_REGPAR(-1,IDHEP(II),0,J1,J2,P1(1),P1(2),P1(3),
     &          P1(4),IPHIST(1,II),IPHIST(2,II),ICOLOR(1,II),
     &          ICOLOR(2,II),IPOS,1)
            ENDIF
            K2B = -IPOS
          ELSE
            K1B = J1
            K2B = J2
          ENDIF
C  register first string/collapsed to hadron
          IF((ISWMDL(7).EQ.0).OR.(ISWMDL(7).EQ.1)) THEN
            IF(NCODE(I).NE.5) THEN
              CALL PHO_REGPAR(1,0,IBHAD(I),K1A,K2A,PC1(1),PC1(2),PC1(3),
     &          PC1(4),IPHIST(1,J1),IPHIST(2,J1),0,0,IPOS,1)
C  label string as collapsed to hadron/resonance
              NCODE(I)  = -99
              IDHEP(J1) = 92
            ELSE
              CALL PHO_REGPAR(-1,90,0,K1A,K2A,PC1(1),PC1(2),PC1(3),
     &          PC1(4),IPHIST(1,J1),IPHIST(2,J1),0,0,IPOS,1)
              IDHEP(J1) = 91
            ENDIF
            NPOS(1,I) = IPOS
            NPOS(2,I) = K1A
            NPOS(3,I) = K2A
          ELSE
            CALL PHO_REGPAR(ISTA,IDHEP(J1),IMPART(J1),K1A,K2A,PC1(1),
     &        PC1(2),PC1(3),PC1(4),IPHIST(1,J1),IPHIST(2,J1),
     &        ICOLOR(1,J1),ICOLOR(2,J1),IPOS,1)
            IF(IDHEP(J1).EQ.90) THEN
              NPOS(1,IPHIST(1,J1)) = IPOS
              NPOS(2,IPHIST(1,J1)) = K1A
              NPOS(3,IPHIST(1,J1)) = K2A
C  label string as collapsed to resonance-string
              IDHEP(J1) = 91
            ELSE IF((IPHIST(1,J1).GE.1).AND.(IPHIST(1,J1).LE.ISTR)) THEN
              IF(NPOS(1,IPHIST(1,J1)).EQ.J1) NPOS(1,IPHIST(1,J1))=IPOS
            ENDIF
          ENDIF
C  register second string/hadron/parton
          CALL PHO_REGPAR(ISTB,IDHEP(J2),IMPART(J2),K1B,K2B,PC2(1),
     &      PC2(2),PC2(3),PC2(4),IPHIST(1,J2),IPHIST(2,J2),ICOLOR(1,J2),
     &      ICOLOR(2,J2),IPOS,1)
          IF(IDHEP(J2).EQ.90) THEN
            NPOS(1,IPHIST(1,J2))=IPOS
            NPOS(2,IPHIST(1,J2))=K1B
            NPOS(3,IPHIST(1,J2))=K2B
C  label string touched by momentum transfer
            IDHEP(J2) = 91
          ELSE IF((IPHIST(1,J2).GE.1).AND.(IPHIST(1,J2).LE.ISTR)) THEN
            IF(NPOS(1,IPHIST(1,J2)).EQ.J2) NPOS(1,IPHIST(1,J2))=IPOS
          ENDIF
          ICCOR = ICCOR+1
          ITOUCH = ITOUCH+1
C  consistency checks
          IF(IDEB(42).GE.5) THEN
            CALL PHO_CHECK(-1,IDEV)
            IF(IDEB(42).GE.25) CALL PHO_PREVNT(0)
          ENDIF
C  jump to next iteration
          GOTO 50
        ENDIF
 90     CONTINUE
 100  CONTINUE
C  debug output
      IF(IDEB(42).GE.15) THEN
        IF((ITOUCH.GT.0).OR.(IDEB(42).GE.25)) THEN
          WRITE(ErrorOut,
     * '(1X,A,I5)') 'PHO_MASCOR: iterations:',ITER
          CALL PHO_PREVNT(1)
        ENDIF
      ENDIF
      END


CDECK  ID>, PHO_PARCOR
      SUBROUTINE PHO_PARCOR(MODE,IREJ)
C********************************************************************
C
C    conversion of string partons (using JETSET masses)
C
C    input:      MODE    >0 position index of corresponding string
C                        -1 initialization
C                        -2 output of statistics
C
C    output:     /POSTRG/
C                IREJ    1 combination of strings impossible
C                        0 successful combination
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DELM   =  0.005D0,
     &            DEPS   =  1.D-15,
     &            EPS    =  1.D-5)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  color string configurations including collapsed strings and hadrons
      INTEGER MSTR
      PARAMETER (MSTR=500)
      INTEGER NPOS,NCODE,IPAR1,IPAR2,IPAR3,IPAR4,NNCH,IBHAD
      COMMON /POSTRG/ NPOS(4,MSTR),NCODE(MSTR),
     &                IPAR1(MSTR),IPAR2(MSTR),IPAR3(MSTR),IPAR4(MSTR),
     &                NNCH(MSTR),IBHAD(MSTR),ISTR


      DIMENSION PP1(4),PP2(4),PB1(4),PB2(4),GAM(3),GAMB(3),
     &          PL(4,100),XMP(100),XML(100)


      DOUBLE PRECISION PYMASS


      IREJ = 0
      IMODE = MODE
C
      IF(IMODE.GT.0) THEN
        ICH = 0
        I1 = JMOHEP(1,IMODE)
        I2 = ABS(JMOHEP(2,IMODE))
C  copy to local field
        L = 0
        DO 100 I=I1,I2
          L = L+1
          DO 200 K=1,4
            PL(K,L) = PHEP(K,I)
 200      CONTINUE
          XMP(L) = PHEP(5,I)

          XML(L) = PYMASS(IDHEP(I))

 100    CONTINUE
        IPAR = L
        XMC = PHEP(5,IMODE)
        IF(IDEB(82).GE.20) THEN
          WRITE(ErrorOut,'(1X,A,I7,2I4)')
     &      'PHO_PARCOR: INI.MOMENTA,MASSES(C/L),EV,ICH,L',
     &      KEVENT,IMODE,L
          DO 150 I=1,L
            WRITE(ErrorOut,
     * '(1X,4E12.4,2X,2E12.4)') (PL(K,I),K=1,4),
     &       XMP(I),XML(I)
 150      CONTINUE
        ENDIF
C
C  two parton configurations
C  -----------------------------------------
        IF(IPAR.EQ.2) THEN
          XM1 = XML(1)
          XM2 = XML(2)
          IF((XM1+XM2).GE.XMC) THEN
            IF(IDEB(82).GE.6) WRITE(ErrorOut,
     * '(1X,A,/,5X,I3,3E12.4)')
     &        'PHO_PARCOR: REJECTION I,XM1,XM2,XMC',
     &        IMODE,XM1,XM2,XMC
            GOTO 990
          ENDIF
C  conversion possible
          CALL PHO_MSHELL(PL(1,1),PL(1,2),XM1,XM2,PP1,PP2,IREJ)
          IF(IREJ.NE.0) THEN
            IFAIL(36) = IFAIL(36)+1
            IF(IDEB(82).GE.6) WRITE(ErrorOut,
     * '(1X,A,I8,I4,E12.4)')
     &      'PHO_PARCOR: REJECTION BY PHO_MSHELL EV,STRING,MASS',
     &        KEVENT,IMODE,XMC
            GOTO 990
          ENDIF
          ICH = 1
          DO 115 K=1,4
            PL(K,1) = PP1(K)
            PL(K,2) = PP2(K)
            XMP(1) = XM1
            XMP(2) = XM2
 115      CONTINUE
C
C  multi parton configurations
C  ---------------------------------
        ELSE
C
C  random selection of string side to start with
          IF(PHO_RNDM(XMC).LT.0.5D0) THEN
            K1 = 1
            K2 = IPAR
            KS = 1
          ELSE
            K1 = IPAR
            K2 = 1
            KS = -1
          ENDIF
          ITER = 0
C
 300      CONTINUE
          IF(ITER.LT.4) THEN
            KK = K1
            K1 = K2
            K2 = KK
            KS = -KS
          ELSE
            GOTO 990
          ENDIF
          ITER = ITER+1
C  select method
          IF(ITER.GT.2) GOTO 230

C  conversion according to color flow method
          IFAI = 0
          DO 210 II=K1,K2-KS,KS
            DO 215 IK=II+KS,K2,KS
              XM1 = XML(II)
              XM2 = XML(IK)
*             IF(IDEB(82).GE.10) WRITE(6,'(1X,A,2I3,4E12.4)')
*    &          'PHO_PARCOR:I,K,XM(1-4)',II,IK,XM1,XMP(II),XM2,XMP(IK)
              IF((ABS(XM1-XMP(II)).GT.DELM)
     &           .OR.(ABS(XM2-XMP(IK)).GT.DELM)) THEN
                CALL PHO_MSHELL(PL(1,II),PL(1,IK),XM1,XM2,PP1,PP2,IREJ)
                IF(IREJ.NE.0) THEN
                  IFAIL(36) = IFAIL(36)+1
                  IF(IDEB(82).GE.6) WRITE(ErrorOut,
     * '(1X,2A,I8,3I4)')
     &              'PHO_PARCOR: ',
     &              'INT.REJ. BY PHO_MSHELL EV,IC,I1,I2',
     &              KEVENT,IMODE,II,IK
                  IREJ = 0
                ELSE
                  ICH = ICH+1
                  DO 220 KK=1,4
                    PL(KK,II) = PP1(KK)
                    PL(KK,IK) = PP2(KK)
 220              CONTINUE
                  XMP(II) = XM1
                  XMP(IK) = XM2
                  GOTO 219
                ENDIF
              ELSE
                GOTO 219
              ENDIF
 215        CONTINUE
            IFAI = II
 219        CONTINUE
 210      CONTINUE
          IF(IFAI.NE.0) GOTO 300
          GOTO 950
C
 230      CONTINUE
C
C  conversion according to remainder method
          DO 350 I=K1,K2,KS
            XM1 = XML(I)
            IF(ABS(XM1-XMP(I)).GT.DELM) THEN
              ICH = ICH+1
              IFAI = I
C  conversion necessary
              DO 400 K=1,4
                PB1(K) = PL(K,I)
                PB2(K) = PHEP(K,IMODE)-PB1(K)
 400          CONTINUE
              XM2 = PB2(4)**2-PB2(1)**2-PB2(2)**2-PB2(3)**2
              IF(XM2.LT.0.D0) THEN
                IF(IDEB(82).GE.10) WRITE(ErrorOut,
     * '(1X,2A,/,5X,3I3,4E12.4)')
     &            'PHO_PARCOR: ',
     &            'INT.REJ. I,IPA,ICH,XML,XMP,XM2**2,MCHAIN',
     &            I,IPAR,IMODE,XM1,XMP(I),XM2,XMC
                GOTO 300
              ENDIF
              XM2 = SQRT(XM2)
              IF((XM1+XM2).GE.XMC) THEN
                IF(IDEB(82).GE.10) WRITE(ErrorOut,
     * '(1X,2A,/,5X,3I3,4E12.4)')
     &            'PHO_PARCOR: ',
     &            'INT.REJ. I,IPA,ICH,XML,XMP,XM2,XMC',
     &            I,IPAR,IMODE,XM1,XMP(I),XM2,XMC
                GOTO 300
              ENDIF
C  conversion possible
              CALL PHO_MSHELL(PB1,PB2,XM1,XM2,PP1,PP2,IREJ)
              IF(IREJ.NE.0) THEN
                IFAIL(36) = IFAIL(36)+1
                IF(IDEB(82).GE.6) WRITE(ErrorOut,
     * '(1X,A,I8,3I4)')
     &            'PHO_PARCOR: PHO_MSHELL REJ. ITER,STRING,PARTON',
     &            ITER,IMODE,I
                GOTO 300
              ENDIF
C  calculate Lorentz transformation
              CALL PHO_GETLTR(PB2,PP2,GAM,GAMB,DELE,IREJ)
              IF(IREJ.NE.0) THEN
                IF(IDEB(82).GE.6) WRITE(ErrorOut,
     * '(1X,A,I8,3I4)')
     &            'PHO_PARCOR: PHO_GETLTR REJ. ITER,STRING,PARTON',
     &            ITER,IMODE,I
                GOTO 300
              ENDIF
              IFAI = 0
C  transform remaining partons
              DO 450 L=K1,K2,KS
                IF(L.NE.I) THEN
                  CALL PHO_MKSLTR(PL(1,L),PP2,GAM,GAMB)
                  DO 500 K=1,4
                    PL(K,L) = PP2(K)
 500              CONTINUE
                ELSE
                  DO 550 K=1,4
                    PL(K,L) = PP1(K)
 550              CONTINUE
                ENDIF
 450          CONTINUE
              XMP(I) = XM1
            ENDIF
 350      CONTINUE
        ENDIF

C  register transformed partons
 950      CONTINUE
          IREJ = 0
          IF(ICH.NE.0) THEN
            IP1 = NHEP+1
            L = 0
            DO 700 I=I1,I2
              L= L+1
              CALL PHO_REGPAR(-1,IDHEP(I),0,IMODE,0,PL(1,L),PL(2,L),
     &          PL(3,L),PL(4,L),IPHIST(1,I),IPHIST(2,I),ICOLOR(1,I),
     &          ICOLOR(2,I),IPOS,1)
 700        CONTINUE
            IP2 = IPOS
C  register string
            CALL PHO_REGPAR(-1,90,0,IP1,-IP2,PHEP(1,IMODE),
     &        PHEP(2,IMODE),PHEP(3,IMODE),PHEP(4,IMODE),IPHIST(1,IMODE),
     &        IPHIST(2,IMODE),ICOLOR(1,IMODE),ICOLOR(2,IMODE),IPOS,1)
C  update /POSTRG/
            I = IPHIST(1,IMODE)
            NPOS(1,I) = IPOS
            NPOS(2,I) = IP1
            NPOS(3,I) = -IP2
          ENDIF
C  debug output
          IF(IDEB(82).GE.20) THEN
            WRITE(ErrorOut,'(1X,A,I7,2I4)')
     &        'PHO_PARCOR: FIN.MOMENTA,MASSES(C/L),(EV,ICH,L)',
     &        KEVENT,IMODE,L
            DO 850 I=1,L
              WRITE(ErrorOut,
     * '(1X,4E12.4,2X,2E12.4)') (PL(K,I),K=1,4),
     &         XMP(I),XML(I)
 850        CONTINUE
            WRITE(ErrorOut,'(1X,A,2I5)')
     &        'PHO_PARCOR: CONVERSION DONE (OLD/NEW ICH)',IMODE,IPOS
          ENDIF
          RETURN
C  rejection
 990      CONTINUE
          IREJ = 1
          IF(IDEB(82).GE.3) THEN
            WRITE(ErrorOut,'(/1X,A,/,5X,3I5,E12.4)')
     &        'PHO_PARCOR: REJECTION I,IPAR,ICHAIN,MCHAIN',
     &         IFAI,IPAR,IMODE,XMC
            IF(IDEB(82).GE.5) THEN
              WRITE(ErrorOut,'(1X,A,I7,2I4)')
     &          'PHO_PARCOR: MOMENTA,MASSES(C/L),(EV,ICH,L)',
     &          KEVENT,IMODE,IPAR
              DO 155 I=1,IPAR
                WRITE(ErrorOut,
     * '(1X,4E12.4,2X,2E12.4)') (PL(K,I),K=1,4),
     &           XMP(I),XML(I)
 155          CONTINUE
            ENDIF
          ENDIF
          RETURN

      ELSE IF(IMODE.EQ.-1) THEN
C  initialization
        RETURN

      ELSE IF(IMODE.EQ.-2) THEN
C  final output
        RETURN
      ENDIF
      END




CDECK  ID>, PHO_STRING
      SUBROUTINE PHO_STRING(IMODE,IREJ)
C********************************************************************
C
C    calculation of string combinatorics, Lorentz boosts and
C                   particle codes
C
C                - splitting of gluons
C                - strings will be built up from pairs of partons
C                  according to their color labels
C                  with IDHEP(..) = -1
C                - there can be other particles between to string partons
C                  (these will be unchanged by string construction)
C                - string mass fine correction
C
C    input:      IMODE    1  complete string processing
C                        -1 initialization
C                        -2 output of statistics
C
C    output:     /POSTRG/
C                IREJ    1 combination of strings impossible
C                        0 successful combination
C                       50 rejection due to user cutoffs
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS   =  1.D-15,
     &            EPS    =  1.D-5 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  color string configurations including collapsed strings and hadrons
      INTEGER MSTR
      PARAMETER (MSTR=500)
      INTEGER NPOS,NCODE,IPAR1,IPAR2,IPAR3,IPAR4,NNCH,IBHAD
      COMMON /POSTRG/ NPOS(4,MSTR),NCODE(MSTR),
     &                IPAR1(MSTR),IPAR2(MSTR),IPAR3(MSTR),IPAR4(MSTR),
     &                NNCH(MSTR),IBHAD(MSTR),ISTR

C  table of particle indices for recursive PHOJET calls
      INTEGER MAXIPX
      PARAMETER ( MAXIPX = 100 )
      INTEGER IPOPOS,IPORES,IPOIX1,IPOIX2,IPOIX3
      COMMON /PORECU/ IPOPOS(2,MAXIPX),IPORES(MAXIPX),
     &                IPOIX1,IPOIX2,IPOIX3

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)




      IREJ = 0
      IF(IMODE.EQ.-1) THEN
        CALL PHO_POMCOR(-1)
        CALL PHO_MASCOR(-1)
        CALL PHO_PARCOR(-1,IREJ)

        RETURN
      ELSE IF(IMODE.EQ.-2) THEN
        CALL PHO_POMCOR(-2)
        CALL PHO_MASCOR(-2)
        CALL PHO_PARCOR(-2,IREJ)

        RETURN
      ENDIF

C  generate enhanced graphs
      IF(IPOIX2.GT.0) THEN
 200    CONTINUE
        I1 = MAX(1,IPOIX1)
        I2 = IPOIX2
        IF(ISWMDL(14).EQ.1) IPOIX1 = 0
        KSPOMS = KSPOM-1
        KSREGS = KSREG
        KHPOMS = KHPOM
        KHDIRS = KHDIR
        IDDFS1 = IDIFR1
        IDDFS2 = IDIFR2
        IDDPOS = IDDPOM
        DO 110 I=I1,I2
          IPOIX3 = I
          KSPOM = 0
          KSREG = 0
          KHPOM = 0
          KHDIR = 0
          IF(IPORES(I).EQ.8) THEN
            KSPOM = 2
            LSPOM = 2
            LHPOM = 0
            LSREG = 0
            LHDIR = 0
            IGEN = ABS(IPHIST(2,IPOPOS(1,I)))
            CALL PHO_STDPAR(IPOPOS(1,I),IPOPOS(2,I),IGEN,
     &                      LSPOM,LSREG,LHPOM,LHDIR,IREJ)
            IF(IREJ.NE.0) THEN
              IF(IDEB(4).GE.2) THEN
                WRITE(ErrorOut,'(/1X,A,I5)')
     &            'PHO_STRING: SEC.REJECTION BY PHO_STDPAR',IREJ
                CALL PHO_PREVNT(-1)
              ENDIF
              RETURN
            ENDIF
            KSPOM = KSPOMS+LSPOM
            KSREG = KSREGS+LSREG
            KHPOM = KHPOMS+LHPOM
            KHDIR = KHDIRS+LHDIR
          ELSE IF(IPORES(I).EQ.4) THEN
            ITEMP = ISWMDL(17)
            ISWMDL(17) = 0
            CALL PHO_CDIFF(IPOPOS(1,I),IPOPOS(2,I),MSOFT,MHARD,1,IREJ)
            ISWMDL(17) = ITEMP
            IF(IREJ.NE.0) THEN
              IF(IDEB(4).GE.2) THEN
                WRITE(ErrorOut,'(/1X,A,I5)')
     &            'PHO_STRING: SEC.REJECTION BY PHO_CDIFF',IREJ
                CALL PHO_PREVNT(-1)
              ENDIF
              RETURN
            ENDIF
            KSDPO = KSDPO+1
            KSPOM = KSPOMS+KSPOM
            KSREG = KSREGS+KSREG
            KHPOM = KHPOMS+KHPOM
            KHDIR = KHDIRS+KHDIR
          ELSE
            IDIF1 = 1
            IDIF2 = 1
            IF(IPORES(I).EQ.5) THEN
              IDIF2 = 0
              KSTRG = KSTRG+1
            ELSE IF(IPORES(I).EQ.6) THEN
              IDIF1 = 0
              KSTRG = KSTRG+1
            ELSE
              KSLOO = KSLOO+1
            ENDIF
            ITEMP = ISWMDL(16)
            ISWMDL(16) = 0
            SPROB = 1.D0
            CALL PHO_DIFDIS(IDIF1,IDIF2,IPOPOS(1,I),IPOPOS(2,I),SPROB,
     &        0,MSOFT,MHARD,IREJ)
            ISWMDL(16) = ITEMP
            IF(IREJ.NE.0) THEN
              IF(IDEB(4).GE.2) THEN
                WRITE(ErrorOut,'(/1X,A,I5)')
     &            'PHO_STRING: SEC.REJECTION BY PHO_DIFDIS',IREJ
                CALL PHO_PREVNT(-1)
              ENDIF
              RETURN
            ENDIF
            KSPOM = KSPOMS+KSPOM
            KSREG = KSREGS+KSREG
            KHPOM = KHPOMS+KHPOM
            KHDIR = KHDIRS+KHDIR
          ENDIF
          IDIFR1 = IDDFS1
          IDIFR2 = IDDFS2
          IDDPOM = IDDPOS
 110    CONTINUE
        IF(IPOIX2.GT.I2) THEN
          IPOIX1 = I2+1
          GOTO 200
        ENDIF
      ENDIF

C  optional: split gluons to q-qbar pairs
      IF(ISWMDL(9).GT.0) THEN
        NHEPO = NHEP
        DO 30 I=3,NHEPO
          IF((ISTHEP(I).EQ.-1).AND.(IDHEP(I).EQ.21)) THEN
            ICG1=ICOLOR(1,I)
            ICG2=ICOLOR(2,I)
            IQ1 = 0
            IQ2 = 0
            DO 40 K=3,NHEPO
              IF(ICOLOR(1,K).EQ.-ICG1) THEN
                IQ1 = K
                IF(IQ1*IQ2.NE.0) GOTO 45
              ELSE IF(ICOLOR(1,K).EQ.-ICG2) THEN
                IQ2 = K
                IF(IQ1*IQ2.NE.0) GOTO 45
              ENDIF
 40         CONTINUE
            WRITE(ErrorOut,
     * '(/1X,2A,3I6)') 'PHO_STRING:ERROR:(1) ',
     &        'NO MATCHING COLOR FOUND (IG,ICG1,ICG2)',I,ICG1,ICG2
            CALL PHO_ABORT
 45         CONTINUE
            CALL PHO_GLU2QU(I,IQ1,IQ2,IREJ)
            IF(IREJ.NE.0) THEN
              IF(IDEB(19).GE.5) THEN
                WRITE(ErrorOut,'(/,1X,A)')
     &            'PHO_STRING: NO GLUON SPLITTING POSSIBLE'
                CALL PHO_PREVNT(0)
              ENDIF
              RETURN
            ENDIF
          ENDIF
 30     CONTINUE
      ENDIF

C  construct strings and write entries sorted by strings

      ISTR = ISTR+1
      NHEPO = NHEP
      DO 50 I=3,NHEPO

        IF(ISTR.GT.MSTR) THEN
          WRITE(ErrorOut,'(1X,2A,2I4)') 'PHO_STRING: ',
     &      'EVENT HAS TOO MANY STRINGS (ISTR,MSTR):',ISTR,MSTR
          CALL PHO_PREVNT(0)
          IREJ = 1
          RETURN
        ENDIF

        IF(ISTHEP(I).EQ.1) THEN
C  hadrons / resonances / clusters
          NPOS(1,ISTR) = I
          NPOS(2,ISTR) = 0
          NPOS(3,ISTR) = 0
          NPOS(4,ISTR) = ABS(IPHIST(2,I))
          NCODE(ISTR) = -99
          IPHIST(1,I) = ISTR
          ISTR = ISTR+1
        ELSE IF((ISTHEP(I).EQ.-1).AND.(IDHEP(I).NE.21)) THEN
C  quark /diquark terminated strings
          ICOL1 = -ICOLOR(1,I)
          P1 = PHEP(1,I)
          P2 = PHEP(2,I)
          P3 = PHEP(3,I)
          P4 = PHEP(4,I)
          ICH1 = IPHO_CHR3(I,2)
          IBA1 = IPHO_BAR3(I,2)
          CALL PHO_REGPAR(-1,IDHEP(I),IMPART(I),I,0,
     &                P1,P2,P3,P4,IPHIST(1,I),IPHIST(2,I),
     &                ICOLOR(1,I),ICOLOR(2,I),IPOS,1)
          JM1 = IPOS

          NRPOM = 0
 65       CONTINUE
          DO 55 K=3,NHEPO
            IF(ISTHEP(K).EQ.-1)THEN
              IF(IDHEP(K).EQ.21) THEN
                IF(ICOLOR(1,K).EQ.ICOL1) THEN
                  ICOL1 = -ICOLOR(2,K)
                  GOTO 60
                ELSE IF(ICOLOR(2,K).EQ.ICOL1) THEN
                  ICOL1 = -ICOLOR(1,K)
                  GOTO 60
                ENDIF
              ELSE IF(ICOLOR(1,K).EQ.ICOL1) THEN
                ICOL1 = 0
                GOTO 60
              ENDIF
            ENDIF
 55       CONTINUE
          WRITE(ErrorOut,'(/1X,A,I5)')
     &      'PHO_STRING:ERROR:(2) NO MATCHING COLOR FOUND FOR',-ICOL1
          CALL PHO_ABORT
 60       CONTINUE
          P1 = P1+PHEP(1,K)
          P2 = P2+PHEP(2,K)
          P3 = P3+PHEP(3,K)
          P4 = P4+PHEP(4,K)
          NRPOM = MAX(NRPOM,IPHIST(1,K))
          ICH1 = ICH1+IPHO_CHR3(K,2)
          IBA1 = IBA1+IPHO_BAR3(K,2)
          CALL PHO_REGPAR(-1,IDHEP(K),IMPART(K),K,0,
     &      PHEP(1,K),PHEP(2,K),PHEP(3,K),PHEP(4,K),
     &      IPHIST(1,K),IPHIST(2,K),ICOLOR(1,K),ICOLOR(2,K),IPOS,1)
C  further parton involved?
          IF(ICOL1.NE.0) GOTO 65
          JM2 = IPOS
C  register string
          IGEN = IPHIST(2,K)
          CALL PHO_REGPAR(-1,90,0,JM1,-JM2,P1,P2,P3,P4,
     &                ISTR,IGEN,ICH1,IBA1,IPOS,1)
C  store additional string information
          NPOS(1,ISTR) = IPOS
          NPOS(2,ISTR) = JM1
          NPOS(3,ISTR) = -JM2
          NPOS(4,ISTR) = ABS(IPHIST(2,K))
C  calculate CPC string codes
          CALL PHO_ID2STR(IDHEP(JM1),IDHEP(JM2),NCODE(ISTR),
     &                IPAR1(ISTR),IPAR2(ISTR),IPAR3(ISTR),IPAR4(ISTR))
          ISTR = ISTR+1
        ENDIF
 50   CONTINUE


      DO 150 I=3,NHEPO

        IF(ISTR.GT.MSTR) THEN
          WRITE(ErrorOut,'(1X,2A,2I4)') 'PHO_STRING: ',
     &      'EVENT HAS TOO MANY STRINGS (ISTR,MSTR):',ISTR,MSTR
          CALL PHO_PREVNT(0)
          IREJ = 1
          RETURN
        ENDIF

        IF(ISTHEP(I).EQ.-1) THEN
C  gluon loop-strings
          ICOL1 = -ICOLOR(1,I)
          P1 = PHEP(1,I)
          P2 = PHEP(2,I)
          P3 = PHEP(3,I)
          P4 = PHEP(4,I)
          IBA1 = 0
          ICH1 = 0
          CALL PHO_REGPAR(-1,IDHEP(I),IMPART(I),I,0,
     &                P1,P2,P3,P4,IPHIST(1,I),IPHIST(2,I),
     &                ICOLOR(1,I),ICOLOR(2,I),IPOS,1)
          JM1 = IPOS
C
          NRPOM = 0
 165      CONTINUE
          IF(ICOLOR(2,I).EQ.ICOL1) GOTO 170
          DO 155 K=I,NHEPO
            IF(ISTHEP(K).EQ.-1)THEN
              IF(ICOLOR(1,K).EQ.ICOL1) THEN
                ICOL1 = -ICOLOR(2,K)
                GOTO 160
              ELSE IF(ICOLOR(2,K).EQ.ICOL1) THEN
                ICOL1 = -ICOLOR(1,K)
                GOTO 160
              ENDIF
            ENDIF
 155      CONTINUE
          WRITE(ErrorOut,'(/1X,A,I5)')
     &      'PHO_STRING:ERROR:(3) NO MATCHING COLOR FOUND FOR',-ICOL1
          CALL PHO_ABORT
 160      CONTINUE
          P1 = P1+PHEP(1,K)
          P2 = P2+PHEP(2,K)
          P3 = P3+PHEP(3,K)
          P4 = P4+PHEP(4,K)
          NRPOM = MAX(NRPOM,IPHIST(1,K))
          CALL PHO_REGPAR(-1,IDHEP(K),IMPART(K),K,0,
     &      PHEP(1,K),PHEP(2,K),PHEP(3,K),PHEP(4,K),
     &      IPHIST(1,K),IPHIST(2,K),ICOLOR(1,K),ICOLOR(2,K),IPOS,1)
C  further parton involved?
          IF(ICOL1.NE.0) GOTO 165
 170      CONTINUE
          JM2 = IPOS
C  register string
          IGEN = IPHIST(2,K)
          CALL PHO_REGPAR(-1,90,0,JM1,-JM2,P1,P2,P3,P4,
     &                ISTR,IGEN,ICH1,IBA1,IPOS,1)
C  store additional string information
          NPOS(1,ISTR) = IPOS
          NPOS(2,ISTR) = JM1
          NPOS(3,ISTR) = -JM2
          NPOS(4,ISTR) = ABS(IPHIST(2,K))
C  calculate CPC string codes
          CALL PHO_ID2STR(IDHEP(JM1),IDHEP(JM2),NCODE(ISTR),
     &                IPAR1(ISTR),IPAR2(ISTR),IPAR3(ISTR),IPAR4(ISTR))
          ISTR = ISTR+1
        ENDIF
 150  CONTINUE


      ISTR = ISTR-1



      IF(IDEB(19).GE.17) THEN
        WRITE(ErrorOut,
     * '(1X,A)') 'PHO_STRING: after string construction'
        CALL PHO_PREVNT(0)
      ENDIF

C  pomeron corrections
      CALL PHO_POMCOR(IREJ)
      IF(IREJ.NE.0) THEN
        IFAIL(38) = IFAIL(38)+1
        IF(IDEB(19).GE.3) THEN
          WRITE(ErrorOut,'(1X,A,I6)')
     &      'PHO_STRING: REJECTION BY PHO_POMCOR (IREJ)',IREJ
          CALL PHO_PREVNT(-1)
        ENDIF
        RETURN
      ENDIF

C  string mass corrections
      CALL PHO_MASCOR(IREJ)
      IF(IREJ.NE.0) THEN
        IFAIL(34) = IFAIL(34)+1
        IF(IDEB(19).GE.3) THEN
          WRITE(ErrorOut,'(1X,A,I6)')
     &      'PHO_STRING: REJECTION BY PHO_MASCOR (IREJ)',IREJ
          CALL PHO_PREVNT(-1)
        ENDIF
        RETURN
      ENDIF

C  parton mass corrections
      DO 100 I=1,ISTR
        IF(NCODE(I).GE.0) THEN
          CALL PHO_PARCOR(NPOS(1,I),IREJ)
          IF(IREJ.NE.0) THEN
            IFAIL(35) = IFAIL(35)+1
            IF(IDEB(19).GE.3) THEN
              WRITE(ErrorOut,'(1X,A,I6)')
     &          'PHO_STRING: REJECTION BY PHO_PARCOR (IREJ)',IREJ
              CALL PHO_PREVNT(-1)
            ENDIF
            RETURN
          ENDIF
        ENDIF
 100  CONTINUE

C  statistics of hard processes
      DO 550 I=3,NHEP
        IF(ISTHEP(I).EQ.25) THEN
          K  = IMPART(I)
          II = IDHEP(I)
          MH_ACC_2(K,II) = MH_ACC_2(K,II)+1
        ENDIF
 550  CONTINUE

C  debug: write out strings
      IF(IDEB(19).GE.5) THEN
        IF(IDEB(19).GE.10)
     &    CALL PHO_CHECK(1,IDEV)
        IF(IDEB(19).GE.15) THEN
          CALL PHO_PREVNT(0)
        ELSE
          CALL PHO_PRSTRG
        ENDIF
      ENDIF

      END


CDECK  ID>, PHO_STRFRA
      SUBROUTINE PHO_STRFRA(IREJ)
C********************************************************************
C
C     do all fragmentation of strings
C
C     output:  IREJ    0   successful
C                      1   rejection
C                     50   rejection due to user cutoffs
C
C********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  color string configurations including collapsed strings and hadrons
      INTEGER MSTR
      PARAMETER (MSTR=500)
      INTEGER NPOS,NCODE,IPAR1,IPAR2,IPAR3,IPAR4,NNCH,IBHAD
      COMMON /POSTRG/ NPOS(4,MSTR),NCODE(MSTR),
     &                IPAR1(MSTR),IPAR2(MSTR),IPAR3(MSTR),IPAR4(MSTR),
     &                NNCH(MSTR),IBHAD(MSTR),ISTR


      INTEGER IREJ

      DOUBLE PRECISION PX,PY,PZ,HE,XMB,PT1,PT2,DUM

      INTEGER I,II,IJ,IFOUND,IP,IP_OLD,IPMOTH,IPOS,IBAM,IJOIN,
     &        IGEN,IS,ISH,ISTR,J,K1,K2,NHEP1,NLINES

      INTEGER INDX(500),INDX_MAX

      DOUBLE PRECISION PHO_RNDM
      INTEGER IPHO_PDG2ID
      EXTERNAL PHO_RNDM,IPHO_PDG2ID


      DOUBLE PRECISION PYP,RQLUN
      INTEGER PYK



      INTEGER MSTU,MSTJ
      DOUBLE PRECISION PARU,PARJ
      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)



      INTEGER N,NPAD,K
      DOUBLE PRECISION P,V
      COMMON/PYJETS/N,NPAD,K(4000,5),P(4000,5),V(4000,5)



      DIMENSION IJOIN(100)

      IREJ = 0
      IF(ABS(ISWMDL(6)).GT.3) THEN
        WRITE(ErrorOut,'(/1X,2A,I3)') 'PHO_STRFRA:ERROR: ',
     &    'INVALID VALUE OF ISWMDL(6)',ISWMDL(6)
        CALL PHO_ABORT
      ENDIF

C  popcorn suppression
        IF(PARMDL(134).GT.0.D0) THEN
          IF(PHO_RNDM(DUM).LT.PARMDL(134)) THEN
            MSTJ(12) = 2
          ELSE
            MSTJ(12) = 1
          ENDIF
        ENDIF

C  copy partons to fragmentation code JETSET
        IP = 0
        IP_OLD = 1

        DO 300 J=1,ISTR

C  select partons with common production process
          IGEN = NPOS(4,J)
          IF(IGEN.LT.0) GOTO 299

          INDX_MAX = 0
          DO 400 I=J,ISTR
            IF((IGEN.EQ.NPOS(4,I)).OR.(IPAMDL(17).EQ.0)) THEN

C  write final particles/resonances to JETSET
              IF(NCODE(I).EQ.-99) THEN
                II = NPOS(1,I)
                IP = IP+1
                P(IP,1) = PHEP(1,II)
                P(IP,2) = PHEP(2,II)
                P(IP,3) = PHEP(3,II)
                P(IP,4) = PHEP(4,II)
                P(IP,5) = PHEP(5,II)
                K(IP,1) = 1
                K(IP,2) = IDHEP(II)
                K(IP,3) = 0
                K(IP,4) = 0
                K(IP,5) = 0
                IPHIST(2,II) = IP

                IF(INDX_MAX.EQ.500) THEN
                  WRITE(ErrorOut,
     * '(1x,2a,i8,I12)') 'PHO_STRFRA: ',
     &              'NO SPACE LEFT IN INDEX VECTOR (INDX,KEVENT)',
     &              INDX_MAX,KEVENT
                  IREJ = 1
                  RETURN
                ENDIF

                INDX_MAX = INDX_MAX+1
                INDX(INDX_MAX) = II
C  write partons to JETSET
              ELSE IF(NCODE(I).GE.0) THEN
                K1 = JMOHEP(1,NPOS(1,I))
                K2 = MAX(JMOHEP(1,NPOS(1,I)),-JMOHEP(2,NPOS(1,I)))
                IJ = 0
                DO II=K1,K2
                  IP = IP+1
                  P(IP,1) = PHEP(1,II)
                  P(IP,2) = PHEP(2,II)
                  P(IP,3) = PHEP(3,II)
                  P(IP,4) = PHEP(4,II)
                  P(IP,5) = PHEP(5,II)
                  K(IP,1) = 1
                  K(IP,2) = IDHEP(II)
                  K(IP,3) = 0
                  K(IP,4) = 0
                  K(IP,5) = 0
                  IPHIST(2,II) = IP
                  IJ = IJ+1
                  IJOIN(IJ) = IP
                  INDX_MAX = INDX_MAX+1
                  INDX(INDX_MAX) = II

                ENDDO
                II = JMOHEP(2,NPOS(1,I))
                IF((II.GT.0).AND.(II.NE.K1)) THEN
                  IP = IP+1
                  P(IP,1) = PHEP(1,II)
                  P(IP,2) = PHEP(2,II)
                  P(IP,3) = PHEP(3,II)
                  P(IP,4) = PHEP(4,II)
                  P(IP,5) = PHEP(5,II)
                  K(IP,1) = 1
                  K(IP,2) = IDHEP(II)
                  K(IP,3) = 0
                  K(IP,4) = 0
                  K(IP,5) = 0
                  IPHIST(2,II) = IP
                  IJ = IJ+1
                  IJOIN(IJ) = IP
                  INDX_MAX = INDX_MAX+1
                  INDX(INDX_MAX) = II

                ENDIF
                N = IP
C  connect partons to strings

                CALL PYJOIN(IJ,IJOIN)

              ENDIF

              NPOS(4,I) = -NPOS(4,I)
            ENDIF
 400      CONTINUE

C  set Lund counter
          N = IP
          IF(IP.EQ.0) GOTO 299

C  hard final state evolution
          IF((ISWMDL(8).EQ.1).OR.(ISWMDL(8).EQ.3)) THEN
            ISH = 0
            DO 125 K1=1,INDX_MAX
              I = INDX(K1)
              IF(IPHIST(1,I).LE.-100) THEN
                ISH = ISH+1
                IJOIN(ISH) = I
              ENDIF
 125        CONTINUE
            IF(ISH.GE.2) THEN
              DO 130 K1=1,ISH
                IF(IJOIN(K1).EQ.0) GOTO 130
                I = IJOIN(K1)
                IF((IPAMDL(102).EQ.1)
     &             .AND.(IPHIST(1,I).NE.-100)) GOTO 130
                DO 135 K2=K1+1,ISH
                  IF(IJOIN(K2).EQ.0) GOTO 135
                  II = IJOIN(K2)
                  IF(IPHIST(1,I).EQ.IPHIST(1,II)) THEN
                    PT1 = SQRT(PHEP(1,II)**2+PHEP(2,II)**2)
                    PT2 = SQRT(PHEP(1,I)**2+PHEP(2,I)**2)
                    RQLUN = MIN(PT1,PT2)

                    IF(IDEB(22).GE.10) WRITE(ErrorOut,
     * '(1X,A,2I5,E12.4)')
     &                'PHO_STRFRA: PYSHOW CALLED',I,II,RQLUN
                    CALL PYSHOW(IPHIST(2,I),IPHIST(2,II),RQLUN)

                    IJOIN(K1) = 0
                    IJOIN(K2) = 0
                    GOTO 130
                  ENDIF
 135            CONTINUE
 130          CONTINUE
            ENDIF
          ENDIF

C  fragment parton / hadron configuration (hadronization & decay)

          IF(ISWMDL(6).NE.0) THEN
            II = MSTU(21)
            MSTU(21) = 1

            CALL PYEXEC

            MSTU(21) = II
C  Lund warning?
            IF(MSTU(28).NE.0) THEN
              IF(IDEB(22).GE.10) THEN
                WRITE(ErrorOut,'(1X,A,I12,I3)')
     &            'PHO_STRFRA:(1) LUND CODE WARNING (EV/CODE)',
     &            KEVENT,MSTU(28)
                CALL PHO_PREVNT(2)
              ENDIF
            ENDIF
C  event accepted?
            IF(MSTU(24).NE.0) THEN
              IF(IDEB(22).GE.2) THEN
                WRITE(ErrorOut,'(1X,A,I12,I3)')
     &            'PHO_STRFRA:(1) REJECTION BY LUND CODE (EV/CODE)',
     &            KEVENT,MSTU(24)
                CALL PHO_PREVNT(2)
              ENDIF
              IREJ = 1
              RETURN
            ENDIF
          ENDIF

          IP = N
C  change particle status in JETSET to avoid internal adjustments
          DO K1=IP_OLD,IP
            K(K1,1) = K(K1,1)+1000
          ENDDO
          IP_OLD = IP+1

 299      CONTINUE
 300    CONTINUE

C  restore original JETSET particle status codes
        DO I=1,N
          K(I,1) = K(I,1)-1000
        ENDDO


*       IF(IDEB(22).GE.25) THEN
*         WRITE(6,'(//1X,2A)') 'PHO_STRFRA: ',
*    &      'particle/string system before fragmentation'
*         CALL PHO_PREVNT(2)
*       ENDIF


C  copy hadrons back to POEVT1 / POEVT2

        IF(IP.GT.0) THEN
          NHEP1 = NHEP+1

          NLINES = PYK(0,1)

C  copy hadrons back with full history information
          IF(IPAMDL(178).EQ.1) THEN
            DO 155 II=1,ISTR
              IF(NCODE(II).GE.0) THEN
                K1 = IPHIST(2,NPOS(2,II))
                K2 = IPHIST(2,-NPOS(3,II))
              ELSE IF(NCODE(II).EQ.-99) THEN
                K1 = IPHIST(2,NPOS(1,II))
                K2 = K1
              ELSE
                GOTO 149
              ENDIF
              IFOUND = 0
              DO 160 J=1,NLINES

                IF(PYK(J,7).EQ.1) THEN
                  IPMOTH = PYK(J,15)

                  IF((IPMOTH.GE.K1).AND.(IPMOTH.LE.K2)) THEN

                    IBAM = IPHO_PDG2ID(PYK(J,8))

                    IF((IBAM.EQ.0).AND.(ISWMDL(6).NE.0)) THEN
                      IF(IDEB(22).GE.2) THEN
                        WRITE(ErrorOut,
     * '(/1X,2A)') 'PHO_STRFRA: ',
     &                    'LUND INTERFACE (1) REJECTION'
                        CALL PHO_PREVNT(2)
                      ENDIF
                      IREJ = 1
                      RETURN
                    ENDIF
                    IFOUND = IFOUND+1

                    PX = PYP(J,1)
                    PY = PYP(J,2)
                    PZ = PYP(J,3)
                    HE = PYP(J,4)
                    XMB = PYP(J,5)**2

C  register parton/hadron
                    IS = 1
                    IF(IBAM.EQ.0) THEN
                      IF(ISWMDL(6).EQ.0) THEN
                        IS = -1
                      ELSE
                        IF(IDEB(22).GE.2) THEN
                          WRITE(ErrorOut,
     * '(/1X,2A)') 'PHO_STRFRA: ',
     &                      'LUND INTERFACE (2) REJECTION'
                          CALL PHO_PREVNT(2)
                        ENDIF
                        IREJ = 1
                        RETURN
                      ENDIF
                    ENDIF

                    CALL PHO_REGPAR(IS,PYK(J,8),IBAM,NPOS(1,II),0,
     &                PX,PY,PZ,HE,J,0,0,0,IPOS,1)

                    ISTHEP(IPOS) = 1
                  ENDIF
                ENDIF
 160          CONTINUE
              IF(IFOUND.EQ.0) THEN
                IF(IDEB(2).GE.2) THEN
                  WRITE(ErrorOut,'(2A,I12,I3)') 'PHO_STRFRA: ',
     &            'NO PARTICLES FOUND FOR STRING (EVE,ISTR):',KEVENT,II
                ENDIF
                ISTHEP(NPOS(1,II)) = 2
              ENDIF
 149          CONTINUE
 155        CONTINUE
          ELSE
C  copy hadrons back without history information
            JDAHEP(1,1) = NHEP1
            JDAHEP(1,2) = NHEP1
            DO 170 J=1,NLINES

              IF(PYK(J,7).EQ.1) THEN
                IBAM = IPHO_PDG2ID(PYK(J,8))

                IF((IBAM.EQ.99999).AND.(ISWMDL(6).NE.0)) THEN
                  IF(IDEB(22).GE.2) THEN
                    WRITE(ErrorOut,'(/1X,A)')
     &                'PHO_STRFRA: LUND INTERFACE (3) REJECTION'
                    CALL PHO_PREVNT(2)
                  ENDIF
                  IREJ = 1
                  RETURN
                ENDIF

                PX = PYP(J,1)
                PY = PYP(J,2)
                PZ = PYP(J,3)
                HE = PYP(J,4)
                XMB = PYP(J,5)**2

C  register parton/hadron
                IS = 1
                IF(IBAM.EQ.0) THEN
                  IF(ISWMDL(6).EQ.0) THEN
                    IS = -1
                  ELSE
                    IF(IDEB(22).GE.2) THEN
                      WRITE(ErrorOut,'(/1X,A)')
     &                  'PHO_STRFRA: LUND INTERFACE (4) REJECTION'
                      CALL PHO_PREVNT(2)
                    ENDIF
                    IREJ = 1
                    RETURN
                  ENDIF
                ENDIF

                CALL PHO_REGPAR(IS,PYK(J,8),IBAM,1,2,PX,PY,PZ,
     &            HE,J,0,0,0,IPOS,1)

                ISTHEP(IPOS) = 1
              ENDIF
 170        CONTINUE
            DO 180 II=1,ISTR
              IF((NCODE(II).GE.0).OR.(NCODE(II).EQ.-99))
     &          ISTHEP(NPOS(1,II)) = 2
 180        CONTINUE
          ENDIF
        ENDIF

C  debug event status
      IF(IDEB(22).GE.15) THEN
        WRITE(ErrorOut,'(//1X,A)')
     &    'PHO_STRFRA: PARTICLE SYSTEM AFTER FRAGMENTATION'
        CALL PHO_PREVNT(2)
      ENDIF

      END


CDECK  ID>, PHO_EVEINI
      SUBROUTINE PHO_EVEINI(IMODE,P1,P2,IP1,IP2)
C********************************************************************
C
C     prepare /POEVT1/ for new event
C
C     first subroutine called for each event
C
C     input:   P1(4)  particle 1
C              P2(4)  particle 2
C              IMODE  0    general initialization
C                     1    initialization of particles and kinematics
C                     2    initialization after internal rejection
C
C     output:  IP1,IP2  index of interacting particles
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      DIMENSION P1(4),P2(4)

      PARAMETER ( EPS    =  1.D-5,
     &            DEPS   =  1.D-15 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL

C  color string configurations including collapsed strings and hadrons
      INTEGER MSTR
      PARAMETER (MSTR=500)
      INTEGER NPOS,NCODE,IPAR1,IPAR2,IPAR3,IPAR4,NNCH,IBHAD
      COMMON /POSTRG/ NPOS(4,MSTR),NCODE(MSTR),
     &                IPAR1(MSTR),IPAR2(MSTR),IPAR3(MSTR),IPAR4(MSTR),
     &                NNCH(MSTR),IBHAD(MSTR),ISTR


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  table of particle indices for recursive PHOJET calls
      INTEGER MAXIPX
      PARAMETER ( MAXIPX = 100 )
      INTEGER IPOPOS,IPORES,IPOIX1,IPOIX2,IPOIX3
      COMMON /PORECU/ IPOPOS(2,MAXIPX),IPORES(MAXIPX),
     &                IPOIX1,IPOIX2,IPOIX3

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      DIMENSION IM(2)

C  reset debug variables
      KSPOM  = 0
      KHPOM  = 0
      KSREG  = 0
      KHDIR  = 0
      KSTRG  = 0
      KHTRG  = 0
      KSLOO  = 0
      KHLOO  = 0
      KSDPO  = 0
      KSOFT  = 0
      KHARD  = 0
C
      IDNODF = 0
      IDIFR1 = 0
      IDIFR2 = 0
      IDDPOM = 0
      ISTR   = 0
      IPOIX1 = 0
      IF(ISWMDL(14).GT.0) IPOIX1 = 1
      IPOIX2 = 0
      IPOIX3 = 0
C  reset /POEVT1/ and /POEVT2/
      CALL PHO_REGPAR(0,0,0,0,0,0.D0,0.D0,0.D0,0.D0,
     &            0,0,0,0,IPOS,0)
      CALL PHO_SELCOL(0,0,0,0,0,0,0)
      DO 15 I=0,10
        IPOWGC(I) = 0
 15   CONTINUE

C  initialization of particle kinematics

C  lepton-photon/hadron-photon vertex and initial particles
        IM(1) = 0
        IM(2) = 0
        IF((IPAMDL(11).GT.0).AND.(IDPSRC(1).NE.0)) THEN
          CALL PHO_REGPAR(1,IDPSRC(1),IDBSRC(1),0,0,PINI(1,1),PINI(2,1),
     &      PINI(3,1),PINI(4,1),0,0,0,0,IM(1),1)
        ELSE
          CALL PHO_REGPAR(1,IFPAP(1),IFPAB(1),IM(1),0,P1(1),P1(2),P1(3),
     &      P1(4),0,0,0,0,IP1,1)
        ENDIF
        IF((IPAMDL(12).GT.0).AND.(IDPSRC(2).NE.0)) THEN
          CALL PHO_REGPAR(1,IDPSRC(2),IDBSRC(2),0,0,PINI(1,2),PINI(2,2),
     &      PINI(3,2),PINI(4,2),0,0,0,0,IM(2),1)
        ELSE
          CALL PHO_REGPAR(1,IFPAP(2),IFPAB(2),IM(2),0,P2(1),P2(2),P2(3),
     &      P2(4),0,0,0,0,IP2,1)
        ENDIF
        IF((IPAMDL(11).GT.0).AND.(IDPSRC(1).NE.0)) THEN
          CALL PHO_REGPAR(1,IDPSRC(1),IDBSRC(1),IM(1),0,PFIN(1,1),
     &      PFIN(2,1),PFIN(3,1),PFIN(4,1),0,10,0,0,IPOS,1)
          CALL PHO_REGPAR(1,IFPAP(1),IFPAB(1),IM(1),0,P1(1),P1(2),P1(3),
     &      P1(4),0,0,0,0,IP1,1)
        ENDIF
        IF((IPAMDL(12).GT.0).AND.(IDPSRC(2).NE.0)) THEN
          CALL PHO_REGPAR(1,IDPSRC(2),IDBSRC(2),IM(2),0,PFIN(1,2),
     &      PFIN(2,2),PFIN(3,2),PFIN(4,2),0,10,0,0,IPOS,1)
          CALL PHO_REGPAR(1,IFPAP(2),IFPAB(2),IM(2),0,P2(1),P2(2),P2(3),
     &      P2(4),0,0,0,0,IP2,1)
        ENDIF
        NEVHEP = KACCEP

      IF(IMODE.LE.1) THEN
C  CMS energy
        ECM = SQRT((P1(4)+P2(4))**2-(P1(1)+P2(1))**2-(P1(2)+P2(2))**2
     &           -(P1(3)+P2(3))**2)
*       CALL PHO_PECMS(1,PMASS(1),PMASS(2),ECM,PCM,EE)
        PMASS(1) = PHEP(5,IP1)
        PVIRT(1) = 0.D0
        IF(IFPAP(1).EQ.22) PVIRT(1) = PMASS(1)**2
        PMASS(2) = PHEP(5,IP2)
        PVIRT(2) = 0.D0
        IF(IFPAP(2).EQ.22) PVIRT(2) = PMASS(2)**2
      ENDIF

C  cross section calculations

      IF(IMODE.NE.1) THEN
        IP = 1
        CALL PHO_CSINT(IP,IFPAP(1),IFPAP(2),IGHEL(1),IGHEL(2),
     &              ECM,PVIRT(1),PVIRT(2))
      ENDIF

      IF(IMODE.LE.0) THEN
C  effective cross section
        SIGGEN(3) = 0.D0
        IF(ISWMDL(2).GE.1) THEN
          IF(IPRON(1,1).EQ.1) SIGGEN(3) = SIGTOT-SIGELA-SIGVM(0,0)
     &      -SIGCDF(0)-SIGLSD(1)-SIGHSD(1)-SIGLSD(2)-SIGHSD(2)-SIGLDD
     &      -SIGHDD-SIGDIR
          IF(IPRON(2,1).EQ.1) SIGGEN(3) = SIGGEN(3)+SIGELA
          IF(IPRON(3,1).EQ.1) SIGGEN(3) = SIGGEN(3)+SIGVM(0,0)
          IF(IPRON(4,1).EQ.1) SIGGEN(3) = SIGGEN(3)+SIGCDF(0)
          IF(IPRON(5,1).EQ.1) SIGGEN(3) = SIGGEN(3)+SIGLSD(1)+SIGHSD(1)
          IF(IPRON(6,1).EQ.1) SIGGEN(3) = SIGGEN(3)+SIGLSD(2)+SIGHSD(2)
          IF(IPRON(7,1).EQ.1) SIGGEN(3) = SIGGEN(3)+SIGLDD+SIGHDD
          IF(IPRON(8,1).EQ.1) SIGGEN(3) = SIGGEN(3)+SIGDIR
C  simulate only hard scatterings
        ELSE
          IF(IPRON(1,1).EQ.1) SIGGEN(3) = SIGHAR
          IF(IPRON(8,1).EQ.1) SIGGEN(3) = SIGGEN(3)+SIGDIR
        ENDIF

      ENDIF

C  reset of mother/daughter relations only (IMODE = 2)

C  debug output
      IF(IDEB(63).GE.15) THEN
        WRITE(ErrorOut,'(/1X,2A,I12,I3)') 'PHO_EVEINI: ',
     &    '/POEVT1/ INITIALIZED (EVENT/MODE)',KEVENT,IMODE
        IF(IMODE.LE.0) THEN
          WRITE(ErrorOut,
     * '(1X,2A,/,5X,1P,6E12.4)') 'PHO_EVEINI: ',
     &      'CURRENT SUPPRESSION FACTORS TOTAL-1/2 HARD-1/2 DIFF-1/2:',
     &      FSUP,FSUH,FSUD
          ONEM = -1.D0
          ITMP = IDEB(57)
          IDEB(57) = MAX(5,ITMP)
          CALL PHO_XSECT(1,0,ONEM)
          IDEB(57) = ITMP
        ENDIF
        CALL PHO_PREVNT(0)
      ENDIF

      END


CDECK  ID>, PHO_CSINT
      SUBROUTINE PHO_CSINT(IP,IFPA,IFPB,IHLA,IHLB,ECM,PVIR2A,PVIR2B)
C********************************************************************
C
C     calculate cross sections by interpolation
C
C     input:   IP          particle combination
C              IFPA/B      particle PDG number
C              IHLA/B      particle helicity (photons only)
C              ECM         c.m. energy (GeV)
C              PVIR2A      virtuality of particle A (GeV**2, positive)
C              PVIR2B      virtuality of particle B (GeV**2, positive)
C
C     output:  cross sections stored in /POCSEC/
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( EPS    =  1.D-5,
     &            DEPS   =  1.D-15 )

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)


      DIMENSION PVIRT(2),SIGSRH(2),FSUT(2),FSUL(2),IFPAP(2),IHEL(2)

      DIMENSION PD(-6:6),FH_T(2),FH_L(2)

C  debug
      IF(IDEB(15).GE.10) WRITE(ErrorOut,
     * '(1X,A,/10X,I3,2I6,1P3E12.4)')
     &  'PHO_CSINT: CALLED WITH IP, IFP1, IFP2, ECM, PVIR1, PVIR2',
     &  IP,IFPA,IFPB,ECM,PVIR2A,PVIR2B

C  check currently stored cross sections
      IF((IP.EQ.IPFIL).AND.(ECM.EQ.ECMFIL)
     &   .AND.(PVIR2A.EQ.P2AFIL).AND.(PVIR2B.EQ.P2BFIL)
     &   .AND.(IFPA.EQ.IFAFIL).AND.(IFPB.EQ.IFBFIL)) THEN
C  nothing to calculate
        IF(IDEB(15).GE.20)
     &    WRITE(ErrorOut,'(1X,A)') 'PHO_CSINT: nothing done'
        RETURN
      ELSE

C  copy to local fields
        IFPAP(1) = IFPA
        IFPAP(2) = IFPB
        IHEL(1)  = IHLA
        IHEL(2)  = IHLB
        PVIRT(1) = PVIR2A
        PVIRT(2) = PVIR2B

C  load cross sections from interpolation table
        IF(ECM.LE.SIGECM(IP,1)) THEN
          I1 = 1
          I2 = 2
        ELSE IF(ECM.LE.SIGECM(IP,ISIMAX)) THEN
          DO 50 I=2,ISIMAX
            IF(ECM.LE.SIGECM(IP,I)) GOTO 200
 50       CONTINUE
 200      CONTINUE
          I1 = I-1
          I2 = I
        ELSE
          WRITE(ErrorOut,'(/1X,A,2E12.3)')
     &      'PHO_CSINT: TOO HIGH ENERGY',ECM,SIGECM(IP,ISIMAX)
          CALL PHO_PREVNT(-1)
          I1 = ISIMAX-1
          I2 = ISIMAX
        ENDIF
        FAC2=0.D0
        IF(I1.NE.I2) FAC2=LOG(ECM/SIGECM(IP,I1))
     &                    /LOG(SIGECM(IP,I2)/SIGECM(IP,I1))
        FAC1=1.D0-FAC2

C  cross section dependence on photon virtualities
        DO 140 K=1,2
          FSUP(K) = 1.D0
          FSUD(K) = 1.D0
          FSUH(K) = 1.D0
          IF(IFPAP(K).EQ.22) THEN
            IF(ISWMDL(10).GE.1) THEN
              FSUP(K) = 0.D0
              FSUT(K) = 0.D0
              FSUL(K) = 0.D0
              FSUH(K) = 0.D0
C  GVDM factors for transverse/longitudinal photons
              DO 150 I=1,3
                FSUT(K) = FSUT(K)+PARMDL(26+I)
     &                   /(1.D0+PVIRT(K)/PARMDL(30+I))**2
                FSUL(K) = FSUL(K)
     &                   +PARMDL(26+I)*PVIRT(K)/(4.D0*PARMDL(30+I))
     &                   /(1.D0+PVIRT(K)/PARMDL(30+I))**2
 150          CONTINUE
              FSUT(K) = FSUT(K)+PARMDL(30)/(1.D0+PVIRT(K)/PARMDL(34))
C  transverse part
              IF((ABS(IHEL(K)).EQ.1).OR.(ISWMDL(10).EQ.1)) THEN
                FSUP(K) = FSUT(K)
                FSUH(K) = FSUT(K)/(FSUT(K)+FSUL(K))
C  diffraction of trans. photons corresponds mainly to leading twist
                FSUD(K) = 1.D0
              ENDIF
C  longitudinal (scalar) part
              IF((IHEL(K).LE.0).OR.(ISWMDL(10).EQ.1)) THEN
                FSUP(K) = FSUP(K)+FSUL(K)
                FSUH(K) = FSUH(K)+FSUL(K)/(FSUT(K)+FSUL(K))
C  diffraction of long. photons corresponds mainly to higher twist
                FSUD(K) = 0.5D0*LOG(((ECM*PARMDL(45))**2+PVIRT(K))
     &                   /((0.765D0+PARMDL(46))**2+PVIRT(K)))
     &                   /LOG(ECM*PARMDL(45)/(0.765D0+PARMDL(46)))
              ENDIF
C  debug output
              IF(IDEB(15).GE.10) THEN
                WRITE(ErrorOut,
     * '(1x,2a,2i3,/,5x,1p5e12.4)') 'PHO_CSINT: ',
     &            'SIDE,HELICITY,F_TRAN,F_LONG,F_EFF,F_HARD,F_DIFF',
     &            K,IHEL(K),FSUT(K),FSUL(K),FSUP(K),FSUH(K),FSUD(K)
              ENDIF
            ENDIF
          ENDIF
 140    CONTINUE

        FACP = FSUP(1)*FSUP(2)
        FACH = FSUH(1)*FSUH(2)
        FACD = FSUD(1)*FSUD(2)

C  matching of model cross section to F2(x,Q2,P2) in limit of Q2 >> P2

        IF((IFPAP(1).EQ.22).AND.(IFPAP(2).EQ.22)
     &     .AND.(IPAMDL(117).GT.0)) THEN
C  check kinematic limit
          Q2_MAX = MAX(PVIRT(1),PVIRT(2))
          Q2_MIN = MIN(PVIRT(1),PVIRT(2))
          IF((Q2_MAX.GT.1.D0).AND.(Q2_MIN.LT.1.D0)) THEN

C  calculate F2 from current parton density
            IF(PVIRT(1).GT.PVIRT(2)) THEN
              K = 2
            ELSE
              K = 1
            ENDIF
            Q2 = Q2_MAX
            P2 = Q2_MIN
            X = Q2/(ECM**2+Q2+P2)
            CALL PHO_ACTPDF(IFPAP(K),K)
            CALL PHO_PDF(K,X,Q2,P2,PD)
C  light quark contribution
            F2_LIGHT = 0.D0
            DO J=1,3
              F2_LIGHT = F2_LIGHT+Q_CH2(J)*(PD(J)+PD(-J))
            ENDDO
C  heavy quark contribution
            CALL PHO_QPMPDF(4,X,Q2,0.D0,P2,XPDF_C)
            F2_C = 2.D0*4.D0/9.D0*XPDF_C
            F2 = (F2_LIGHT+F2_C)

C  calculate model prediction
            SIGTOT = FAC2*SIGTAB(IP,1,I2)+FAC1*SIGTAB(IP,1,I1)
            SIGINE = FAC2*SIGTAB(IP,28,I2)+FAC1*SIGTAB(IP,28,I1)
            CALL PHO_HARINT(IP,ECM,0.D0,0.D0,0,MAX_PRO_2,3,4,1)

            IF(ISWMDL(10).GE.2) THEN

C  calculate all helicity combinations
              IF(IPAMDL(115).EQ.0) THEN
                SIGDIH    = HSIG(14)
                SIGSRH(1) = HSIG(10)+HSIG(11)
                SIGSRH(2) = HSIG(12)+HSIG(13)
                SIGTMP = SIGTOT-SIGDIH-SIGSRH(1)-SIGSRH(2)
C  photon helicity factors
                FH_T(1) = FSUT(1)/(FSUT(1)+FSUL(1))
                FH_L(1) = 1.D0-FH_T(1)
                FH_T(2) = FSUT(2)/(FSUT(2)+FSUL(2))
                FH_L(2) = 1.D0-FH_T(2)
                SIG_TT = SIGTMP*FSUT(1)*FSUT(2)
     &                  + SIGDIH*FH_T(1)*FH_T(2)
     &                  + SIGSRH(1)*FH_T(1)*FSUT(2)
     &                  + SIGSRH(2)*FSUT(1)*FH_T(2)
                SIG_TL = SIGTMP*FSUT(1)*FSUL(2)
     &                  + SIGDIH*FH_T(1)*FH_L(2)
     &                  + SIGSRH(1)*FH_T(1)*FSUL(2)
     &                  + SIGSRH(2)*FSUT(1)*FH_L(2)
                SIG_LT = SIGTMP*FSUL(1)*FSUT(2)
     &                  + SIGDIH*FH_L(1)*FH_T(2)
     &                  + SIGSRH(1)*FH_L(1)*FSUT(2)
     &                  + SIGSRH(2)*FSUL(1)*FH_T(2)
                SIG_LL = SIGTMP*FSUL(1)*FSUL(2)
     &                  + SIGDIH*FH_L(1)*FH_L(2)
     &                  + SIGSRH(1)*FH_L(1)*FSUL(2)
     &                  + SIGSRH(2)*FSUL(1)*FH_L(2)
              ELSE
C  use explicit PDF virtuality dependence (pre-tabulated)
                SIGDIH    = HSIG(14)
                SIGSRH(1) = HSIG(10)+HSIG(11)
                SIGSRH(2) = HSIG(12)+HSIG(13)
                SIGTMP = SIGTOT-SIGDIH-SIGSRH(1)-SIGSRH(2)
                PRINT *,' PHO_CSINT: INVALID OPTION FOR F2 MATCHING'
                STOP
*               CALL PHO_HARINT(IP,ECM,PVIRT(1),PVIRT(2),0,
*    &                          Max_pro_2,3,4,1)
*               SIG_TT = SIGtmp*FSUT(1)*FSUT(2)
*    &                  + HSig(10)+HSig(12)+HSig(14)+HSig(16)+HSig(18)
*               SIG_TL = SIGtmp*FSUT(1)*FSUL(2)
*    &                  + HSig(10)+HSig(12)+HSig(14)+HSig(16)+HSig(19)
*               SIG_LT = SIGtmp*FSUL(1)*FSUT(2)
*    &                  + HSig(11)+HSig(13)+HSig(15)+HSig(17)+HSig(20)
*               SIG_LL = SIGtmp*FSUL(1)*FSUL(2)
*    &                  + HSig(11)+HSig(13)+HSig(15)+HSig(17)+HSig(21)
              ENDIF
              XNU = ECM*ECM+Q2+P2
              F2_FAC = Q2*XNU/SQRT(XNU*XNU-Q2*P2)/(4.D0*PI*PI)
     &             *137.D0/GEV2MB
              IF(K.EQ.2) THEN
                F2M = F2_FAC*(SIG_TT+SIG_LT-0.5D0*SIG_TL-0.5D0*SIG_LL)
                F2S = F2_FAC*SIGTMP*(FSUT(1)*FSUT(2)+FSUL(1)*FSUT(2)
     &               -0.5D0*FSUT(1)*FSUL(2)-0.5D0*FSUL(1)*FSUL(2))
              ELSE
                F2M = F2_FAC*(SIG_TT+SIG_TL-0.5D0*SIG_LT-0.5D0*SIG_LL)
                F2S = F2_FAC*SIGTMP*(FSUT(1)*FSUT(2)+FSUT(1)*FSUL(2)
     &               -0.5D0*FSUL(1)*FSUT(2)-0.5D0*FSUL(1)*FSUL(2))
              ENDIF

            ELSE

C  assume sig_eff = sigtot
              SIGDIH    = HSIG(14)
              SIGSRH(1) = HSIG(10)+HSIG(11)
              SIGSRH(2) = HSIG(12)+HSIG(13)
              SIGTMP = SIGTOT-SIGSRH(1)-SIGSRH(2)-SIGDIH
              SIGEFF = SIGTMP*FSUP(1)*FSUP(2)
     &                +SIGSRH(1)*FSUP(2)+SIGSRH(2)*FSUP(1)+SIGDIH
              XNU = ECM*ECM+Q2+P2
              F2_FAC = Q2*XNU/SQRT(XNU*XNU-Q2*P2)/(4.D0*PI*PI)
     &             *137.D0/GEV2MB
              F2M = F2_FAC*SIGEFF
              F2S = F2_FAC*SIGTMP*FSUP(1)*FSUP(2)
            ENDIF
*           print *,' PHO_CSINT: Q2_1,Q2_2,W ',PVIRT(1),PVIRT(2),Ecm
*           print *,' PHO_CSINT: F2_mod,F2_pdf,mod/pdf ',F2m,F2,F2m/F2

C  global factor to re-scale suppression of soft contributions
            FCORR = (F2-F2M+F2S)/F2S
*           print *,' PHO_CSINT: re-scaling factor: ',Fcorr,FACP*Fcorr
            FACP = FACP*FCORR

          ENDIF
        ENDIF

        SIGTOT = (FAC2*SIGTAB(IP,1,I2)+FAC1*SIGTAB(IP,1,I1))*FACP
        SIGINE = (FAC2*SIGTAB(IP,28,I2)+FAC1*SIGTAB(IP,28,I1))*FACP
        SIGELA = (FAC2*SIGTAB(IP,2,I2)+FAC1*SIGTAB(IP,2,I1))*FACP
        J = 2
        DO 5 I=0,4
          DO 6 K=0,4
            J = J+1
            SIGVM(I,K) = (FAC2*SIGTAB(IP,J,I2)+FAC1*SIGTAB(IP,J,I1))
     &                  *FACP**2
 6        CONTINUE
 5      CONTINUE

        SIGDIR = FAC2*SIGTAB(IP,29,I2)+FAC1*SIGTAB(IP,29,I1)
        SIGHAR = FAC2*SIGTAB(IP,58,I2)+FAC1*SIGTAB(IP,58,I1)
C  suppression of multi-pomeron graphs (diffraction)
        SIGLSD(1) = (FAC2*SIGTAB(IP,30,I2)+FAC1*SIGTAB(IP,30,I1))
     &             *FACP*FSUP(2)*FSUD(1)
        SIGLSD(2) = (FAC2*SIGTAB(IP,31,I2)+FAC1*SIGTAB(IP,31,I1))
     &             *FACP*FSUP(1)*FSUD(2)
        SIGHSD(1) = (FAC2*SIGTAB(IP,32,I2)+FAC1*SIGTAB(IP,32,I1))
     &             *FACP*FSUP(2)*FSUD(1)
        SIGHSD(2) = (FAC2*SIGTAB(IP,33,I2)+FAC1*SIGTAB(IP,33,I1))
     &             *FACP*FSUP(1)*FSUD(2)
        SIGLDD    = (FAC2*SIGTAB(IP,34,I2)+FAC1*SIGTAB(IP,34,I1))
     &             *FACP**2*FACD
        SIGHDD    = (FAC2*SIGTAB(IP,35,I2)+FAC1*SIGTAB(IP,35,I1))*FACP
        SIGCDF(0) = (FAC2*SIGTAB(IP,36,I2)+FAC1*SIGTAB(IP,36,I1))
     &             *FACP**2
        SIGTR1(1) = (FAC2*SIGTAB(IP,60,I2)+FAC1*SIGTAB(IP,60,I1))
     &             *FACP*FSUP(2)*FSUD(1)
        SIGTR1(2) = (FAC2*SIGTAB(IP,61,I2)+FAC1*SIGTAB(IP,61,I1))
     &             *FACP*FSUP(2)*FSUD(1)
        SIGTR2(1) = (FAC2*SIGTAB(IP,62,I2)+FAC1*SIGTAB(IP,62,I1))
     &             *FACP*FSUP(1)*FSUD(2)
        SIGTR2(2) = (FAC2*SIGTAB(IP,63,I2)+FAC1*SIGTAB(IP,63,I1))
     &             *FACP*FSUP(1)*FSUD(2)
        SIGLOO    = (FAC2*SIGTAB(IP,64,I2)+FAC1*SIGTAB(IP,64,I1))*FACP
        SIGDPO(1) = (FAC2*SIGTAB(IP,65,I2)+FAC1*SIGTAB(IP,65,I1))
     &             *FACP**2
        SIGDPO(2) = (FAC2*SIGTAB(IP,66,I2)+FAC1*SIGTAB(IP,66,I1))
     &             *FACP**2
        SIGDPO(3) = (FAC2*SIGTAB(IP,67,I2)+FAC1*SIGTAB(IP,67,I1))
     &             *FACP**2
        SIGDPO(4) = (FAC2*SIGTAB(IP,68,I2)+FAC1*SIGTAB(IP,68,I1))
     &             *FACP**2

C  corrections due to photon virtuality dependence of PDFs
        IF(ISWMDL(2).EQ.1) THEN
          CALL PHO_HARINT(IP,ECM,0.D0,0.D0,0,MAX_PRO_2,3,4,1)
C  minimum bias event generation
          IF(IPAMDL(115).GE.1) THEN
C  all the virtuality dependence is given by PDF parametrization
            SIGHIN = FAC2*SIGTAB(IP,80,I2)+FAC1*SIGTAB(IP,80,I1)
            IF(IPAMDL(116).GE.2) THEN
C  direct interaction according to full QPM calculation
              SIGDIH = HSIG(14)
              SIGSRH(1) = HSIG(10)+HSIG(11)
              SIGSRH(2) = HSIG(12)+HSIG(13)
            ELSE
C  direct interaction suppressed according to helicity factor
              SIGDIH = HSIG(14)*FACH
              SIGSRH(1) = (HSIG(10)+HSIG(11))*FSUH(1)
              SIGSRH(2) = (HSIG(12)+HSIG(13))*FSUH(2)
            ENDIF
            PRINT *,' PHO_CSINT: OPTION NOT SUPPORTED YET'
            STOP
          ELSE
C  rescale relevant hard processes
            SIGDIH    = HSIG(14)
            SIGSRH(1) = HSIG(10)+HSIG(11)
            SIGSRH(2) = HSIG(12)+HSIG(13)
            SIGTMP = SIGINE-(SIGDIH+SIGSRH(1)+SIGSRH(2))*FACP
            SIGDIR = HSIG(14)*FACH+SIGSRH(1)*FSUH(1)*FSUP(2)
     &              +SIGSRH(2)*FSUP(1)*FSUH(2)
            SIGINE = SIGTMP+SIGDIR
            SIGTOT = SIGINE+SIGELA
          ENDIF
        ELSE
C  only hard interactions
          CALL PHO_HARINT(IP,ECM,0.D0,0.D0,0,MAX_PRO_2,3,4,1)
          SIGSRH(1) = (HSIG(10)+HSIG(11))*FSUH(1)
          SIGSRH(2) = (HSIG(12)+HSIG(13))*FSUH(2)
          SIGDIR = HSIG(14)+SIGSRH(1)+SIGSRH(2)
          SIGHAR = HSIG(9)*FACH
        ENDIF

        SIG1SO = (FAC2*SIGTAB(IP,37,I2)+FAC1*SIGTAB(IP,37,I1))*FACP
        SIG1HA = (FAC2*SIGTAB(IP,38,I2)+FAC1*SIGTAB(IP,38,I1))*FACH
        SLOEL = FAC2*SIGTAB(IP,39,I2)+FAC1*SIGTAB(IP,39,I1)
        J = 39
        DO 9 I=1,4
          DO 10 K=1,4
            J = J+1
            SLOVM(I,K) = FAC2*SIGTAB(IP,J,I2)+FAC1*SIGTAB(IP,J,I1)
 10       CONTINUE
 9      CONTINUE
        SIGPOM = (FAC2*SIGTAB(IP,56,I2)+FAC1*SIGTAB(IP,56,I1))*FACP
        SIGREG = (FAC2*SIGTAB(IP,57,I2)+FAC1*SIGTAB(IP,57,I1))*FACP

        IPFIL  = IP
        IFAFIL = IFPA
        IFBFIL = IFPB
        ECMFIL = ECM
        P2AFIL = PVIR2A
        P2BFIL = PVIR2B

        IF(IDEB(15).GE.20)
     &    WRITE(ErrorOut,
     * '(1X,A)') 'PHO_CSINT: cross sections calculated'

      ENDIF

      END



CDECK  ID>, PHO_PRIMKT
      SUBROUTINE PHO_PRIMKT(IMODE,IF,IL,PTCUT,IREJ)
C***********************************************************************
C
C    give primordial kt to partons entering hard scatterings and
C    remants connected to hard parton-parton interactions by color flow
C
C    input:  IMODE   -2   output of statistics
C                    -1   initialization
C                     1   sampling of primordial kt
C            IF           first entry in /POEVT1/ to check
C            IL           last entry in /POEVT1/ to check
C            PTCUT        current value of PTCUT to distinguish
C                         between soft and hard
C
C    output: IREJ     0   success
C                     1   failure
C
C***********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      DOUBLE PRECISION DEPS
      PARAMETER ( DEPS = 1.D-15 )

      INTEGER IMODE,IF,IL,IREJ
      DOUBLE PRECISION PTCUT

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  hard scattering data
      INTEGER MSCAHD
      PARAMETER ( MSCAHD = 50 )
      INTEGER LSCAHD,LSC1HD,LSIDX,
     &        NINHD,N0INHD,NIVAL,N0IVAL,NOUTHD,NBRAHD,NPROHD
      DOUBLE PRECISION PPH,PTHD,ETAHD,Q2SCA,PDFVA,XHD,VHD,X0HD
      COMMON /POHSLT/ LSCAHD,LSC1HD,LSIDX(MSCAHD),
     &                PPH(8*MSCAHD,2),PTHD(MSCAHD),ETAHD(MSCAHD,2),
     &                Q2SCA(MSCAHD,2),PDFVA(MSCAHD,2),
     &                XHD(MSCAHD,2),VHD(MSCAHD),X0HD(MSCAHD,2),
     &                NINHD(MSCAHD,2),N0INHD(MSCAHD,2),
     &                NIVAL(MSCAHD,2),N0IVAL(MSCAHD,2),
     &                NOUTHD(MSCAHD,2),NBRAHD(MSCAHD,2),NPROHD(MSCAHD)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)



      DOUBLE PRECISION PTS,XP,XP2,POLD,PNEW,GA,PP
      DIMENSION PTS(0:2,5),XP(5),
     &  XP2(5,2),POLD(2,2),PNEW(4,2),GA(4),PP(4)

      INTEGER IROTT,IBALT,IBAL,IV,IV2,IRMAX

      PARAMETER (IRMAX=200)
      DIMENSION IROTT(IRMAX),IBALT(5,2),IBAL(2),IV(5),IV2(5,2)

      DOUBLE PRECISION SI,EI,SF,EF,PTOT,EE,XX,YY,ZZ,ANORF,FAC,DEL,PT2,
     &                 DEL2,GAE,GAZ,SID,COD,SIF,COF,ESUM
      INTEGER IROT,I,J,K,NHD,ISTART,INEXT,ICOM


C  debug output
      IF(IDEB(10).GE.10) WRITE(ErrorOut,'(1X,A,3I4,1P,E11.3)')
     &  'PHO_PRIMKT: CALLED WITH IMODE,IF,IL,PTCUT',
     &  IMODE,IF,IL,PTCUT

C  give primordial kt to partons engaged in a hard scattering

      IF(IMODE.EQ.1) THEN

        ISTART = IF

 100    CONTINUE

        NHD = 0
        IBAL(1) = 0
        IBAL(2) = 0
        IROT = 0
        ICOM = 0
        DO 110 I=ISTART,IL
          IF(ISTHEP(I).EQ.25) THEN
C  hard scattering number
            NHD = IPHIST(1,I+1)
            ICOM = I
            K = LSIDX(NHD/100)
C  calculate momenta of incoming partons
            POLD(1,1) = XHD(K,1)*ECMP/2.D0
            POLD(2,1) = POLD(1,1)
            POLD(1,2) = -XHD(K,2)*ECMP/2.D0
            POLD(2,2) = -POLD(1,2)
            ISTART = I+3
            GOTO 150
          ENDIF
 110    CONTINUE
        RETURN

 150    CONTINUE

C  search for partons involved in hard interaction
        INEXT = 0
        IROT = 0
        DO 500 I=ISTART,IL
          IF(ABS(ISTHEP(I)).EQ.1) THEN
C  hard scatterd partons (including ISR)
            IF((IPHIST(1,I).EQ.-NHD)
     &         .OR.(IPHIST(1,I).EQ.NHD+1)
     &         .OR.(IPHIST(1,I).EQ.NHD+2)) THEN
              IROT = IROT+1

              IF(IROT.GT.IRMAX) THEN
                WRITE(ErrorOut,'(1X,/,2A,2I5)') 'PHO_PRIMKT: ',
     &            'NO MEMORY LEFT IN IROTT, EVENT REJECTED (MAX/IROT)',
     &            IRMAX,IROT
                CALL PHO_PREVNT(0)
                IREJ = 1
                RETURN
              ENDIF

              IROTT(IROT) = I
C  hard remnant
            ELSE IF(IPHIST(1,I).EQ.NHD) THEN
              IF(PHEP(3,I).GT.0.D0) THEN
                J = 1
              ELSE
                J = 2
              ENDIF
              IBAL(J) = IBAL(J)+1
              IBALT(IBAL(J),J) = I
              XP2(IBAL(J),J) = PHEP(3,I)/ECMP
              IF(ISWMDL(24).EQ.0) THEN
                IV2(IBAL(J),J) = 0
                IF(IDHEP(I).NE.21) IV2(IBAL(J),J) = ICOLOR(2,I)
              ELSE IF(ISWMDL(24).EQ.1) THEN
                IV2(IBAL(J),J) = -1
              ELSE
                IV2(IBAL(J),J) = 1
              ENDIF
            ENDIF
C  possibly further hard scattering
          ELSE IF(ISTHEP(I).EQ.25) THEN
            INEXT = 1
            ISTART = I
            GOTO 550
          ENDIF
 500    CONTINUE
 550    CONTINUE

C debug output
        IF(IDEB(10).GE.15) THEN
          WRITE(ErrorOut,'(1X,2A,I4)') 'PHO_PRIMKT: ',
     &      'HARD SCATTERING NUMBER: ',NHD/100
          WRITE(ErrorOut,'(1X,2A,I5)') 'PHO_PRIMKT: ',
     &      'NUMBER OF ENTRIES TO ROTATE: ',IROT
          DO I=1,IROT
            WRITE(ErrorOut,'(1X,2A,2I5)') 'PHO_PRIMKT: ',
     &        'ENTRIES TO ROTATE: ',I,IROTT(I)
          ENDDO
          WRITE(ErrorOut,'(1X,2A,2I5)') 'PHO_PRIMKT: ',
     &      'NUMBER OF ENTRIES TO BALANCE: ',IBAL
          DO J=1,2
            DO I=1,IBAL(J)
              WRITE(ErrorOut,'(1X,2A,I2,2I5)')
     &          'PHO_PRIMKT: ENTRIES TO BALANCE (SIDE,NO,LINE)',
     &          J,I,IBALT(I,J)
            ENDDO
          ENDDO
        ENDIF

C  incoming partons (comment lines), skip direct interacting particles
        DO 120 K=1,2
          IF((IDHEP(ICOM+K).NE.22).AND.(IDHEP(ICOM+K).NE.990)) THEN
            IF(PHEP(3,ICOM+K).GT.0.D0) THEN
              J = 1
            ELSE
              J = 2
            ENDIF
            IBAL(J) = IBAL(J)+1
            IBALT(IBAL(J),J) = -ICOM-K
            XP2(IBAL(J),J) = POLD(1,J)/ECMP
            IV2(IBAL(J),J) = -1
          ENDIF
 120    CONTINUE

C  check consistency
        IF((IBAL(1).GT.4).OR.(IBAL(2).GT.4)) THEN
          WRITE(ErrorOut,'(1X,2A,I10)') 'PHO_PRIMKT: ',
     &      'INCONSISTENT HARD SCATTERING REMNANT FOR EVENT: ',KEVENT
          WRITE(ErrorOut,'(1X,A,3I4,1P,E11.3)')
     &      'PHO_PRIMKT CALLED WITH IMODE,IF,IL,PTCUT',
     &      IMODE,IF,IL,PTCUT
          WRITE(ErrorOut,
     * '(1X,A,I4)') 'hard scattering number: ',NHD/100
          DO 390 I=1,IROT
            WRITE(ErrorOut,
     * '(1X,A,2I5)') 'entries to rotate',I,IROTT(I)
 390      CONTINUE
          DO 392 J=1,2
            DO 395 I=1,IBAL(J)
              WRITE(ErrorOut,'(1X,A,I2,2I5)')
     &          'ENTRIES TO BALANCE (SIDE,NO,LINE)',J,I,IBALT(I,J)
 395        CONTINUE
 392      CONTINUE
          IF(IBAL(1)+IBAL(2).GT.0) CALL PHO_PREVNT(0)
        ENDIF

C  calculate primordial kt

C  something to do?
        IF((IBAL(1).GT.1).OR.(IBAL(2).GT.1)) THEN

C  add transverse momentum (overwrite /POEVT1/ entries)
        DO 200 J=1,2
          IF(IBAL(J).GT.1) THEN
C  sample from truncated distribution
            K = IBAL(J)
            DO 180 I=1,K
              IV(I) = IV2(I,J)
              XP(I) = XP2(I,J)
 180        CONTINUE
 190        CONTINUE
              CALL PHO_SOFTPT(K,PTCUT,PTCUT,XP,IV,PTS)
            IF(PTS(0,K).GE.PARMDL(100)) GOTO 190
C  transform incoming partons of hard scattering
            DEL = ABS(POLD(1,J))+POLD(2,J)
            PT2 = PTS(0,K)**2
            DEL2 = DEL*DEL
            PNEW(1,J) = PTS(1,K)
            PNEW(2,J) = PTS(2,K)
            PNEW(3,J) = (-1)**J*(PT2 - DEL2)/(2.D0*DEL)
            PNEW(4,J) = (DEL2 + PT2)/(2.D0*DEL)
C  spectator partons
            ESUM = 0.D0
            DO 220 I=1,IBAL(J)-1
              K = IBALT(I,J)
              PHEP(1,K) = PHEP(1,K)+PTS(1,I)
              PHEP(2,K) = PHEP(2,K)+PTS(2,I)
              ESUM = ESUM+PHEP(4,K)
 220        CONTINUE
C  long. momentum transfer
            PP(3) = PNEW(3,J) - POLD(1,J)
            PP(4) = PNEW(4,J) - POLD(2,J)
            DO 230 I=1,IBAL(J)-1
              K = IBALT(I,J)
              FAC = PHEP(4,K)/ESUM
              PHEP(3,K) = PHEP(3,K) - FAC*PP(3)
              PHEP(4,K) = PHEP(4,K) - FAC*PP(4)
 230        CONTINUE

C  debug output
            IF(IDEB(10).GE.15) THEN
              WRITE(ErrorOut,
     * '(1X,2A,I3,1P,4E11.3)') 'PHO_PRIMKT: ',
     &          'OLD INCOMING:',J,0.D0,0.D0,(POLD(I,J),I=1,2)
              WRITE(ErrorOut,
     * '(1X,2A,I3,1P,4E11.3)') 'PHO_PRIMKT: ',
     &          'NEW INCOMING:',J,(PNEW(I,J),I=1,4)
            ENDIF

          ELSE
            PNEW(1,J) = 0.D0
            PNEW(2,J) = 0.D0
            PNEW(3,J) = POLD(1,J)
            PNEW(4,J) = POLD(2,J)
          ENDIF
 200    CONTINUE

C  transformation of hard scattering final states (including ISR)

C  old parton c.m. energy
        SI = (POLD(2,1)+POLD(2,2))**2-(POLD(1,1)+POLD(1,2))**2
        EI = SQRT(SI)
C  new parton c.m. energy
        SF = (PNEW(4,1)+PNEW(4,2))**2-(PNEW(1,1)+PNEW(1,2))**2
     &       -(PNEW(2,1)+PNEW(2,2))**2-(PNEW(3,1)+PNEW(3,2))**2
        EF = SQRT(SF)
        FAC = EF/EI
C  debug output
        IF(IDEB(10).GE.25) WRITE(ErrorOut,'(1X,A,1P,E12.4)')
     &    'PHO_PRIMKT: SCALING FACTOR (E-FINAL/E-INITIAL): ',FAC

C  calculate Lorentz transformation
        GAZ = -(POLD(1,1)+POLD(1,2))/EI
        GAE = (POLD(2,1)+POLD(2,2))/EI
        DO 240 I=1,4
          GA(I) = (PNEW(I,1)+PNEW(I,2))/EF
 240    CONTINUE
        CALL PHO_ALTRA(GA(4),-GA(1),-GA(2),-GA(3),PNEW(1,1),PNEW(2,1),
     &    PNEW(3,1),PNEW(4,1),PTOT,PP(1),PP(2),PP(3),PP(4))
        PTOT = MAX(DEPS,PTOT)
        COD= PP(3)/PTOT
        SID= SQRT(PP(1)**2+PP(2)**2)/PTOT
        COF= 1.D0
        SIF= 0.D0
        IF(PTOT*SID.GT.1.D-5) THEN
          COF=PP(1)/(SID*PTOT)
          SIF=PP(2)/(SID*PTOT)
          ANORF=SQRT(COF*COF+SIF*SIF)
          COF=COF/ANORF
          SIF=SIF/ANORF
        ENDIF

C  debug output
C  check consistency initial/final configuration before rotation
        IF(IDEB(10).GE.25) THEN
          WRITE(ErrorOut,
     * '(1X,A,1P,4E11.3)') 'PHO_PRIMKT: ini. momentum (1):',
     &      0.D0,0.D0,(POLD(I,1)+POLD(I,2),I=1,2)
          DO I=1,4
            PP(I) = 0.D0
          ENDDO
          DO I=1,IROT
            K = IROTT(I)
            DO J=1,4
              PP(J) = PP(J)+PHEP(J,K)
            ENDDO
          ENDDO
          WRITE(ErrorOut,'(1X,A,1P,4E11.3)')
     &      'PHO_PRIMKT: FIN. MOMENTUM (1):',PP
        ENDIF

C  apply rotation/boost to scattered particles
        DO 400 I=1,IROT
          K = IROTT(I)
          DO 350 J=1,4
            PP(J) = FAC*PHEP(J,K)
 350      CONTINUE
          CALL PHO_ALTRA(GAE,0.D0,0.D0,GAZ,PP(1),PP(2),PP(3),
     &      PP(4),PTOT,PHEP(1,K),PHEP(2,K),PHEP(3,K),PHEP(4,K))
          CALL PHO_TRANS(PHEP(1,K),PHEP(2,K),PHEP(3,K),
     &      COD,SID,COF,SIF,XX,YY,ZZ)
          EE = PHEP(4,K)
          CALL PHO_ALTRA(GA(4),GA(1),GA(2),GA(3),XX,YY,ZZ,EE,PTOT,
     &      PHEP(1,K),PHEP(2,K),PHEP(3,K),PHEP(4,K))
 400    CONTINUE

C  debug output
C  check consistency initial/final configuration after rotation
        IF(IDEB(10).GE.25) THEN
          DO I=1,4
            PP(I) = PNEW(I,1)+PNEW(I,2)
          ENDDO
          WRITE(ErrorOut,'(1X,A,1P,4E11.3)')
     &      'PHO_PRIMKT: INI. MOMENTUM (2):',PP
          DO I=1,4
            PP(I) = 0.D0
          ENDDO
          DO I=1,IROT
            K = IROTT(I)
            DO J=1,4
              PP(J) = PP(J)+PHEP(J,K)
            ENDDO
          ENDDO
          WRITE(ErrorOut,'(1X,A,1P,4E11.3)')
     &      'PHO_PRIMKT: FIN. MOMENTUM (2):',PP
        ENDIF

        ENDIF

        IF(INEXT.EQ.1) GOTO 100

C  initialization

      ELSE IF(IMODE.EQ.-1) THEN

C  output of statistics etc.

      ELSE IF(IMODE.EQ.-2) THEN

C  something wrong

      ELSE
        WRITE(ErrorOut,'(/1X,A,I4)')
     &    'PHO_PRIMKT:ERROR: INVALID VALUE OF IMODE:',IMODE
        CALL PHO_ABORT
      ENDIF

      END



CDECK  ID>, PHO_PARTPT
      SUBROUTINE PHO_PARTPT(IMODE,IF,IL,PTCUT,IREJ)
C********************************************************************
C
C    assign to soft partons
C
C    input:  IMODE   -2   output of statistics
C                    -1   initialization
C                     0   sampling of pt for soft partons belonging to
C                         soft Pomerons
C                     1   sampling of pt for soft partons belonging to
C                         hard Pomerons
C            IF           first entry in /POEVT1/ to check
C            IL           last entry in /POEVT1/ to check
C            PTCUT        current value of PTCUT to distinguish
C                         between soft and hard
C
C    output: IREJ     0   success
C                     1   failure
C
C    (soft pt is sampled by call to PHO_SOFTPT)
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS = 1.D-15 )

      INTEGER IMODE,IF,IL,IREJ
      DOUBLE PRECISION PTCUT

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)



      DOUBLE PRECISION PTS,PB,XP,XPB,PC
      DIMENSION PTS(0:2,50),PB(0:2,2),XP(50),XPB(2),PC(4)

      INTEGER MODIFY,IV,IVB
      DIMENSION MODIFY(50),IV(50),IVB(2)

C  debug output
      IF(IDEB(6).GE.10) WRITE(ErrorOut,'(1X,A,3I4,1P,E11.3)')
     &  'PHO_PARTPT: CALLED WITH IMODE,IF,IL,PTCUT',
     &  IMODE,IF,IL,PTCUT

      IF(IMODE.LT.0) GOTO 1000

      IREJ = 0
      IF((ISWMDL(3).EQ.10).AND.(ISWMDL(4).EQ.10)) RETURN

C  count entries to modify
      IENTRY = 0
      PTCUT2 = PTCUT**2
      EMIN = 1.D20
      IPEAK = 1
      ISTART = IF

C  soft Pomerons

      IF(IMODE.EQ.0) THEN
        DO 300 I=ISTART,IL
          IF((ISTHEP(I).EQ.-1).AND.(ABS(IPHIST(1,I)).LT.100)) THEN
            IENTRY = IENTRY+1
            MODIFY(IENTRY) = I
            XP(IENTRY) = SIGN(PHEP(4,I)/ECMP,PHEP(3,I))
            IV(IENTRY) = 0
            IF(IDHEP(I).NE.21) IV(IENTRY) = ICOLOR(2,I)
            IF(PHEP(4,I).LT.EMIN) THEN
              EMIN = PHEP(4,I)
              IPEAK = IENTRY
            ENDIF
          ENDIF
 300    CONTINUE

C  hard Pomeron associated remnants (IPHIST(1,)=100,200,...)

      ELSE IF(IMODE.EQ.1) THEN

        DO 350 I=ISTART,IL
          IF((ISTHEP(I).EQ.-1).AND.(IPHIST(1,I).GE.100)) THEN
            IF(MOD(IPHIST(1,I),100).EQ.0) THEN
              IENTRY = IENTRY+1
              MODIFY(IENTRY) = I
              XP(IENTRY) = SIGN(PHEP(4,I)/ECMP,PHEP(3,I))
              IF(ISWMDL(24).EQ.0) THEN
                IV(IENTRY) = 0
                IF(IDHEP(I).NE.21) IV(IENTRY) = ICOLOR(2,I)
              ELSE IF(ISWMDL(24).EQ.1) THEN
                IV(IENTRY) = -1
              ELSE
                IV(IENTRY) = 1
              ENDIF
              IF(PHEP(4,I).LT.EMIN) THEN
                EMIN = PHEP(4,I)
                IPEAK = IENTRY
              ENDIF
            ENDIF
          ENDIF
 350    CONTINUE

C  something wrong

      ELSE
        WRITE(ErrorOut,
     * '(/1X,A,I5)') 'PHO_PARTPT:ERROR: invalid mode',IMODE
        CALL PHO_ABORT
      ENDIF

C  debug output
      IF(IDEB(6).GE.5) THEN
        WRITE(ErrorOut,'(1X,2A,3I4)') 'PHO_PARTPT: ',
     &    'NUMBER OF PARTONS, IPEAK,MODE',IENTRY,IPEAK,IMODE
        IF(IDEB(6).GE.20) CALL PHO_PREVNT(0)
      ENDIF

C  nothing to do
      IF(IENTRY.LE.1) RETURN

C  sample pt of soft partons

      IF(ISWMDL(5).LE.1) THEN
        ITER = 0
        IPEAK = PHO_RNDM(DUM)*IENTRY+1
        CALL PHO_SWAPI(MODIFY(IPEAK),MODIFY(1))
        CALL PHO_SWAPD(XP(IPEAK),XP(1))
        CALL PHO_SWAPI(IV(IPEAK),IV(1))
 400    CONTINUE
C  energy limited sampling
          PSUMX = 0.D0
          PSUMY = 0.D0
          ITER = ITER+1
          IF(ITER.GE.1000) THEN
            IF(IDEB(6).GE.3) THEN
              WRITE(ErrorOut,'(1X,A,3I5)')
     &          'PHO_PARTPT: REJECTION FOR MODE,ENTRY,ITER',
     &          IMODE,IENTRY,ITER
              WRITE(ErrorOut,
     * '(8X,A,I5)') 'I  II  IV       XP         EP',
     &          IPEAK
              DO 405 I=1,IENTRY
                II = MODIFY(I)
                WRITE(ErrorOut,'(5X,3I5,1P,2E13.4)')
     &            I,II,IV(I),XP(I),PHEP(4,II)
 405          CONTINUE
              IF(IDEB(6).GE.5) CALL PHO_PREVNT(0)
            ENDIF
            IREJ = 1
            RETURN
          ENDIF
          DO 410 I=2,IENTRY
            II = MODIFY(I)
            PTMX = MIN(PHEP(4,II),PTCUT)
            XPB(1) = XP(I)
            IVB(1) = IV(I)
            IF(ISWMDL(5).EQ.0) THEN
              CALL PHO_SOFTPT(1,PTCUT,PTMX,XPB,IVB,PB)
            ELSE
              CALL PHO_SOFTPT(1,PTMX,PTMX,XPB,IVB,PB)
            ENDIF
            PTS(0,I) = PB(0,1)
            PTS(1,I) = PB(1,1)
            PTS(2,I) = PB(2,1)
            PSUMX = PSUMX+PB(1,1)
            PSUMY = PSUMY+PB(2,1)
 410      CONTINUE
          PTREM = SQRT(PSUMX**2+PSUMY**2)
        IF(PTREM.GT.MIN(PHEP(4,MODIFY(1)),PTCUT)) GOTO 400
        PTS(1,1) = -PSUMX
        PTS(2,1) = -PSUMY
      ELSE IF((ISWMDL(5).EQ.2)
     &        .OR.((IMODE.EQ.1).AND.(ISWMDL(5).EQ.3))) THEN
C  unlimited sampling
        IPEAK = PHO_RNDM(PSUMX)*IENTRY+1
        CALL PHO_SWAPI(MODIFY(IPEAK),MODIFY(1))
        CALL PHO_SWAPD(XP(IPEAK),XP(1))
        CALL PHO_SWAPI(IV(IPEAK),IV(1))
        CALL PHO_SOFTPT(IENTRY,PTCUT,PTCUT,XP,IV,PTS)
      ELSE IF(ISWMDL(5).EQ.3) THEN
C  each string has balanced pt
        DO 500 K=1,IENTRY
          IF(IV(K).LE.-90) GOTO 499
          I1 = MODIFY(K)
          IC1 = -ICOLOR(1,I1)
          DO 510 L=K+1,IENTRY
            IF(ICOLOR(1,MODIFY(L)).EQ.IC1) GOTO 511
 510      CONTINUE
          WRITE(ErrorOut,'(//1X,A,I5)')
     &      'PHO_PARTPT:ERROR: NO COLOR FOUND FOR (LINE,COLOR)',I1,-IC1
          CALL PHO_ABORT
 511      CONTINUE
          I2 = MODIFY(L)
          AMSQR = (PHEP(4,I1)+PHEP(4,I2))**2-(PHEP(1,I1)+PHEP(1,I2))**2
     &           -(PHEP(2,I1)+PHEP(2,I2))**2-(PHEP(3,I1)+PHEP(3,I2))**2
          AM   = SQRT(AMSQR)
          PTMX = AM/2.D0
          IVB(1) = MAX(IV(K),IV(L))
          XPB(1) = XP(K)
          CALL PHO_SOFTPT(1,PTCUT,PTMX,XPB,IVB,PB)
          PTS(1,K) = PB(1,1)
          PTS(2,K) = PB(2,1)
          PTS(1,L) = -PB(1,1)
          PTS(2,L) = -PB(2,1)
          GAM    = (PHEP(4,I1)+PHEP(4,I2))/AM
          GAMBEZ = (PHEP(3,I1)+PHEP(3,I2))/AM
          PC(1) = PB(1,1)
          PC(2) = PB(2,1)
          PLONG = SQRT(PTMX**2-PB(0,1)**2+1.D-12)
          PC(3) = SIGN(PLONG,PHEP(3,I1))
          PC(4) = PTMX
          CALL PHO_ALTRA(GAM,0.D0,0.D0,GAMBEZ,PC(1),PC(2),PC(3),PC(4),
     &               PTOT,PHEP(1,I1),PHEP(2,I1),PHEP(3,I1),PHEP(4,I1))
          PC(1) = -PC(1)
          PC(2) = -PC(2)
          PC(3) = -PC(3)
          CALL PHO_ALTRA(GAM,0.D0,0.D0,GAMBEZ,PC(1),PC(2),PC(3),PC(4),
     &               PTOT,PHEP(1,I2),PHEP(2,I2),PHEP(3,I2),PHEP(4,I2))
          IV(K) = IV(K)-100
          IV(L) = IV(L)-100
 499      CONTINUE
 500    CONTINUE
      ELSE
        WRITE(ErrorOut,'(/1X,A,I4)')
     &    'PHO_PARTPT:ERROR: INVALID VALUE OF ISWMDL(5):',ISWMDL(5)
        CALL PHO_ABORT
      ENDIF

C  change partons in /POEVT1/
      DO 900 II=1,IENTRY
        IF(IV(II).GT.-90) THEN
          I = MODIFY(II)
          PHEP(1,I) = PHEP(1,I)+PTS(1,II)
          PHEP(2,I) = PHEP(2,I)+PTS(2,II)
          AMSQR = PHEP(4,I)**2
     &             -PHEP(1,I)**2-PHEP(2,I)**2-PHEP(3,I)**2
          PHEP(5,I) = SIGN(SQRT(ABS(AMSQR)),AMSQR)
        ENDIF
 900  CONTINUE

C  debug output
      IF(IDEB(6).GE.15) THEN
        WRITE(ErrorOut,'(1X,A)') 'PHO_PARTPT: table of momenta'
        WRITE(ErrorOut,
     * '(8X,A,I5)') 'I  II  IV    XP    EP    PTS   PTX   PTY',
     &    IPEAK
        DO 505 I=1,IENTRY
          II = MODIFY(I)
          WRITE(ErrorOut,'(2X,3I5,1P,5E12.4)')
     &      I,II,IV(I),XP(I),PHEP(4,II),PTS(0,I),PTS(1,I),PTS(2,I)
 505    CONTINUE
        CALL PHO_PREVNT(0)
      ENDIF
      RETURN

C  initialization / output of statistics
 1000 CONTINUE
      CALL PHO_SOFTPT(IMODE,PTM,PTM,XP,IV,PTS)

      END



CDECK  ID>, PHO_SOFTPT
      SUBROUTINE PHO_SOFTPT(ISOFT,PTCUT,PTMAX,XV,IV,PTSOF)
C***********************************************************************
C
C    select pt of soft string ends
C
C    input:    ISOFT          number of soft partons
C                    -1       initialization
C                    >=0      sampling of p_t
C                    -2       output of statistics
C              PTCUT          cutoff for soft strings
C              PTMAX          maximal allowed PT
C              XV             field of x values
C              IV             0    sea quark
C                             1    valence quark
C
C    output:   /POINT3/       containing parameters AAS,BETAS
C              PTSOF          filed with soft pt values
C
C    note:     ISWMDL(3/4) = 0  dNs/dP_t = P_t ASS * exp(-BETA*P_t**2)
C              ISWMDL(3/4) = 1  dNs/dP_t = P_t ASS * exp(-BETA*P_t)
C              ISWMDL(3/4) = 2  photon wave function
C              ISWMDL(3/4) = 10 no soft P_t assignment
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS   =  1.D-15)

      DIMENSION PTSOF(0:2,*),XV(*)
      DIMENSION IV(*)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  data needed for soft-pt calculation
      DOUBLE PRECISION SIGS,DSIGHP,SIGH,FS,FH,BETAS,AAS,PTCON
      COMMON /POINT3/ SIGS,DSIGHP,SIGH,FS,FH,BETAS(3),AAS,PTCON


      DIMENSION BETAB(100)



C  selection of pt
      IF(ISOFT.GE.0) THEN
        CALLS = CALLS + 1.D0
C  sample according to model ISWMDL(3-6)
        IF(ISOFT.GT.1) THEN
 210      CONTINUE
          PTXS = 0.D0
          PTYS = 0.D0
          DO 300 I=2,ISOFT
            IMODE = ISWMDL(3)
C  valence partons
            IF(IV(I).EQ.1) THEN
              BETA = BETAS(1)
C  photon/pomeron valence part
              IF(IPAMDL(5).EQ.1) THEN
                IF(XV(I).GE.0.D0) THEN
                  IF((IDPDG1.EQ.22).OR.(IDPDG1.EQ.990)) THEN
                    IMODE = ISWMDL(4)
                    BETA = BETAS(3)
                  ENDIF
                ELSE
                  IF((IDPDG2.EQ.22).OR.(IDPDG2.EQ.990)) THEN
                    IMODE = ISWMDL(4)
                    BETA = BETAS(3)
                  ENDIF
                ENDIF
              ELSE IF(IPAMDL(5).EQ.2) THEN
                BETA = PARMDL(20)
              ELSE IF(IPAMDL(5).EQ.3) THEN
                BETA = BETAS(3)
              ENDIF
C  sea partons
            ELSE IF(IV(I).EQ.0) THEN
              BETA = BETAS(3)
C  hard scattering remnant
            ELSE
              IF(IPAMDL(6).EQ.0) THEN
                BETA = BETAS(1)
              ELSE IF(IPAMDL(6).EQ.1) THEN
                BETA = BETAS(3)
              ELSE
                BETA = PARMDL(20)
              ENDIF
            ENDIF
            BETA = MAX(BETA,0.01D0)
            CALL PHO_SELPT(XV(I),0.D0,PTCUT,PTS,BETA,IMODE)
            PTS = MIN(PTMAX,PTS)
            CALL PHO_SFECFE(SIG,COG)
            PTSOF(0,I) = PTS
            PTSOF(1,I) = COG*PTS
            PTSOF(2,I) = SIG*PTS
            PTXS = PTXS+PTSOF(1,I)
            PTYS = PTYS+PTSOF(2,I)
            BETAB(I) = BETA
 300      CONTINUE
C  balancing of momenta
          PTS = SQRT(PTXS**2+PTYS**2)
          IF(PTS.GE.PTMAX) GOTO 210
          PTSOF(0,1) = PTS
          PTSOF(1,1) = -PTXS
          PTSOF(2,1) = -PTYS
          BETAB(1) = 0.D0
C
*400      CONTINUE
C
C  single parton only
        ELSE
          IMODE = ISWMDL(3)
C  valence partons
          IF(IV(1).EQ.1) THEN
            BETA = BETAS(1)
C  photon/Pomeron valence part
            IF(IPAMDL(5).EQ.1) THEN
              IF(XV(1).GE.0.D0) THEN
                IF((IDPDG1.EQ.22).OR.(IDPDG1.EQ.990)) THEN
                  IMODE = ISWMDL(4)
                  BETA = BETAS(3)
                ENDIF
              ELSE
                IF((IDPDG2.EQ.22).OR.(IDPDG2.EQ.990)) THEN
                  IMODE = ISWMDL(4)
                  BETA = BETAS(3)
                ENDIF
              ENDIF
            ELSE IF(IPAMDL(5).EQ.2) THEN
              BETA = PARMDL(20)
            ELSE IF(IPAMDL(5).EQ.3) THEN
              BETA = BETAS(3)
            ENDIF
C  sea partons
          ELSE IF(IV(1).EQ.0) THEN
            BETA = BETAS(3)
C  hard scattering remnant
          ELSE
            IF(IPAMDL(6).EQ.1) THEN
              BETA = BETAS(3)
            ELSE
              BETA = PARMDL(20)
            ENDIF
          ENDIF
          BETA = MAX(BETA,0.01D0)
          CALL PHO_SELPT(XV(1),0.D0,PTCUT,PTS,BETA,IMODE)
          PTS = MIN(PTMAX,PTS)
          CALL PHO_SFECFE(SIG,COG)
          PTSOF(0,1) = PTS
          PTSOF(1,1) = COG*PTS
          PTSOF(2,1) = SIG*PTS
          BETAB(1) = BETA
        ENDIF

C  debug output
        IF(IDEB(29).GE.10) THEN
          WRITE(ErrorOut,'(1X,A,I4)') 'PHO_SOFTPT: ISOFT',ISOFT
          WRITE(ErrorOut,
     * '(6X,A)') 'TABLE OF  I, IV, XV, PT, PT-X, PT-Y, BETA'
          DO 105 I=1,ISOFT
            WRITE(ErrorOut,
     * '(10X,2I3,1P,5E12.3)') I,IV(I),XV(I),PTSOF(0,I),
     &        PTSOF(1,I),PTSOF(2,I),BETAB(I)
 105      CONTINUE
        ENDIF

C  initialization of statistics and parameters

      ELSE IF(ISOFT.EQ.-1) THEN
        PTSMIN = 0.D0
        PTSMAX = PTCUT

        IMODE = -100+ISWMDL(3)
        CALL PHO_SELPT(ECMP,PTSMIN,PTSMAX,PTS,BETAS(3),IMODE)

C  output of statistics

      ELSE IF(ISOFT.EQ.-2) THEN

      ELSE
        WRITE(ErrorOut,'(1X,2A,I2)') 'PHO_SOFTPT:ERROR: ',
     &    'UNSUPPORTED ISOFT ',ISOFT
        STOP
      ENDIF
      END



CDECK  ID>, PHO_SELPT
      SUBROUTINE PHO_SELPT(EE,PTLOW,PTHIGH,PTS,BETA,IMODE)
C***********************************************************************
C
C    select pt from different distributions
C
C    input:    EE            energy (for initialization only)
C                            otherwise x value of corresponding parton
C              PTLOW         lower pt limit
C              PTHIGH        upper pt limit
C                            (PTHIGH > 20 will cause DEXP underflows)
C
C              IMODE = 0     dNs/dP_t = P_t * ASS * exp(-BETA*P_t**2)
C              IMODE = 1     dNs/dP_t = P_t * ASS * exp(-BETA*P_t)
C              IMODE = 2     dNs/dP_t according photon wave function
C              IMODE = 10    no sampling
C
C              IMODE = -100+IMODE    initialization according to
C                                    given limitations
C
C    output:   PTS           sampled pt value
C    initialization:
C              BETA          soft pt slope in central region
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( PI2    =  6.28318530718D0,
     &            AMIN   =  1.D-2,
     &            EPS    =  1.D-7,
     &            DEPS   =  1.D-30)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  average number of cut soft and hard ladders (obsolete)
      DOUBLE PRECISION AVERI,AVERK,AVERL,AVERM,AVERN
      COMMON /POINT2/ AVERI,AVERK,AVERL,AVERM,AVERN

C  data needed for soft-pt calculation
      DOUBLE PRECISION SIGS,DSIGHP,SIGH,FS,FH,BETAS,AAS,PTCON
      COMMON /POINT3/ SIGS,DSIGHP,SIGH,FS,FH,BETAS(3),AAS,PTCON


      DOUBLE PRECISION PHO_CONN0,PHO_CONN1
      EXTERNAL PHO_CONN0,PHO_CONN1

C  initialization

      IF(IMODE.LT.0) GOTO 100

      PX = PTHIGH
      PTS = 0.D0

C  initial checks

      IF(PX.LT.AMIN) RETURN

      IF((PX-PTLOW).LT.0.01) THEN
        IF(IDEB(5).GE.3) WRITE(ErrorOut,'(1X,A,2E12.3,I3)')
     &    'PHO_SELPT: PTLOW,PTHIGH,IMODE ',PTLOW,PTHIGH,IMODE
        RETURN
      ENDIF

C  sampling of pt values according to IMODE

      IF(IMODE.EQ.0) THEN

        FAC1 = EXP(-BETA*PX**2)
        FAC2 = (1.D0-FAC1)
 25     CONTINUE
          XI1 = PHO_RNDM(PX)*FAC2 + FAC1
          PTS = SQRT(-1.D0/BETA*LOG(XI1))
        IF((PTS.GT.PTHIGH).OR.(PTS.LT.PTLOW)) GOTO 25

      ELSE IF(IMODE.EQ.1) THEN

        XIMIN = EXP(-BETA*PTHIGH)
        XIDEL = 1.D0-XIMIN
 50     CONTINUE
          PTS = -LOG((XIDEL*PHO_RNDM(XIDEL)+XIMIN)
     &              *(XIDEL*PHO_RNDM(XIMIN)+XIMIN)+DEPS)/BETA
        IF(PTS.LT.XMT) GOTO 50
        PTS = SQRT(PTS**2-XMT2)
        IF((PTS.GT.PTHIGH).OR.(PTS.LT.PTLOW)) GOTO 50

      ELSE IF(IMODE.EQ.2) THEN

        IF(EE.GE.0.D0) THEN
          P2 = PVIRTP(1)
        ELSE
          P2 = PVIRTP(2)
        ENDIF
        XV = ABS(EE)
        AA = (1.D0-XV)*XV*P2+PARMDL(25)
 75     CONTINUE
          PTS = SQRT(AA/(PHO_RNDM(PX)+EPS)-AA)
        IF((PTS.GT.PTHIGH).OR.(PTS.LT.PTLOW)) GOTO 75

C  something wrong

      ELSE IF(IMODE.NE.10) THEN
        WRITE(ErrorOut,
     * '(/1X,A,I4)') 'PHO_SELPT:ERROR: invalid IMODE',IMODE
        CALL PHO_ABORT
      ENDIF

C  debug output
      IF(IDEB(5).GE.20) THEN
        WRITE(ErrorOut,'(1X,A,I3,4E10.3)')
     &    'PHO_SELPT: MODE,BET,PTMI,PTMA,PT',
     &    IMODE,BETA,PTLOW,PTHIGH,PTS
      ENDIF
      RETURN

C  initialization
 100  CONTINUE
        PTSMIN = PTLOW
        PTSMAX = PTHIGH
        PTCON = PTHIGH
C  calculation of parameters
        INIT = IMODE+100
        AAS = 0.D0

C  initialization for model 0 (gaussian pt distribution)

        IF(INIT.EQ.0) THEN
          BETAS(1) = PARMDL(23)+0.15D0*LOG(EE)*(PARMDL(24)-PARMDL(23))
          BETUP = BETAS(1)
          BETLO = -2.D0
          XTOL = PHO_CONN0(BETLO)*PHO_CONN0(BETUP)
          IF(XTOL.LT.0.D0) THEN
            XTOL = 1.D-4
            METHOD = 1
            MAXF = 500
            BETA = 0.D0
            BETA = PHO_DZEROX(BETLO,BETUP,XTOL,MAXF,PHO_CONN0,METHOD)
*           IF(BETA.LT.-1.D+10) THEN
*             WRITE(6,'(1X,2A,1P,2E11.3)') 'PHO_SELPT: no Beta found ',
*    &          '(model 0: Ecm,PTcut)',EE,PTCON
*             WRITE(6,'(1X,A,1P,3E10.3)')
*    &          'PHO_SELPT: SIGS,SIGH,DSIGHP',SIGS,SIGH,DSIGHP
*             CALL PHO_PREVNT(-1)
*             BETA = 0.01
*           ELSE
              AAS = DSIGHP/PTCON*EXP(-BETA*PTCON**2)
*           ENDIF
          ELSE
            AAS = 0.D0
            BETA = BETAS(1)
          ENDIF

C  initialization for model 1 (exponential pt distribution)

        ELSE IF(INIT.EQ.1) THEN
          XMT = PARMDL(43)
          XMT2 = XMT*XMT
          BETAS(1) = PARMDL(21)+0.15D0*LOG(EE)*(PARMDL(22)-PARMDL(21))
          BETUP = BETAS(1)
          BETLO = -3.D0
          XTOL = PHO_CONN1(BETLO)*PHO_CONN1(BETUP)
          IF(XTOL.LT.0.D0) THEN
            XTOL = 1.D-4
            METHOD = 1
            MAXF = 500
            BETA = 0.D0
            BETA = PHO_DZEROX(BETLO,BETUP,XTOL,MAXF,PHO_CONN1,METHOD)
*           IF(BETA.LT.-1.D+10) THEN
*             WRITE(6,'(1X,2A,1P,2E11.3)') 'PHO_SELPT: no Beta found ',
*    &          '(model 1: Ecm,PTcut)',EE,PTCON
*             WRITE(6,'(1X,A,1P,3E10.3)')
*    &          'PHO_SELPT: SIGS,SIGH,DSIGHP',SIGS,SIGH,DSIGHP
*             CALL PHO_PREVNT(-1)
*             BETA = 0.01
*           ELSE
              AAS = DSIGHP/PTCON*EXP(-BETA*PTCON)
*           ENDIF
          ELSE
            AAS = 0.D0
            BETA = BETAS(1)
          ENDIF
        ELSE IF(INIT.EQ.10) THEN
          IF(IDEB(5).GT.10)
     &      WRITE(ErrorOut,
     * '(/1X,A)') 'PHO_SELPT: no soft pt sampling'
          RETURN
        ELSE
          WRITE(ErrorOut,
     * '(1X,A,I4)') 'PHO_SELPT:ERROR: invalid distribution',
     &      INIT
          CALL PHO_ABORT
        ENDIF
        BETA = MIN(BETA,BETAS(1))

C  hard cross section is too big: neg. beta parameter
        IF(BETA.LE.0.D0) THEN
          WRITE(ErrorOut,'(1X,A,1P,2E12.3)')
     &      'PHO_SELPT: PARAMETER BETA NEGATIVE (BETA,AAS)',BETA,AAS
          WRITE(ErrorOut,
     * '(1X,A,1P,4E11.3)') 'SIGS,DSIGHP,SIGH,PTCON:',
     &      SIGS,DSIGHP,SIGH,PTCON
          CALL PHO_PREVNT(-1)
        ENDIF

C  output of initialization parameters
        IF(IDEB(5).GE.10) THEN
          WRITE(ErrorOut,
     * '(1X,A,I3)') 'PHO_SELPT: initialization for model',
     &      INIT
          WRITE(ErrorOut,'(5X,A,1P,2E13.3)')
     &      'BETA,AAS        ',BETA,AAS
          WRITE(ErrorOut,'(5X,A,1P,3E13.3)')
     &      'ECM,PTMIN,PTMAX ',EE,PTSMIN,PTSMAX
          WRITE(ErrorOut,'(5X,A,1P,3E13.3)')
     &      'SIGS,DSIGHP,SIGH',SIGS,DSIGHP,SIGH
        ENDIF

      END



CDECK  ID>, PHO_CONN0
      DOUBLE PRECISION FUNCTION PHO_CONN0(BETA)
C***********************************************************************
C
C    auxiliary function to determine parameters of soft
C    pt distribution  dNs/dP_t = P_t * AAS * EXP(-BETA*P_t**2)
C
C    internal factors: FS  number of soft partons in soft Pomeron
C                      FH  number of soft partons in hard Pomeron
C
C***********************************************************************

      IMPLICIT NONE

      SAVE

C  average number of cut soft and hard ladders (obsolete)
      DOUBLE PRECISION AVERI,AVERK,AVERL,AVERM,AVERN
      COMMON /POINT2/ AVERI,AVERK,AVERL,AVERM,AVERN

C  data needed for soft-pt calculation
      DOUBLE PRECISION SIGS,DSIGHP,SIGH,FS,FH,BETAS,AAS,PTCON
      COMMON /POINT3/ SIGS,DSIGHP,SIGH,FS,FH,BETAS(3),AAS,PTCON


      DOUBLE PRECISION BETA,XX,FF

      XX = BETA*PTCON**2
      IF(ABS(XX).LT.1.D-3) THEN
        FF = FS*SIGS+FH*SIGH
     &       - DSIGHP*(PTCON/2.D0+PTCON**3*BETA/4.D0)
      ELSE
        FF = FS*SIGS+FH*SIGH
     &       - DSIGHP/(2.D0*PTCON*BETA)*(EXP(XX)-1.D0)
      ENDIF
      PHO_CONN0 = FF

*     WRITE(6,'(1X,A,3E12.3)') 'PHO_CONN0:BETA,AAS,FF',BETA,AAS,FF
*     WRITE(6,'(1X,A,3E12.3)') 'PHO_CONN0:SIGS,SIGH,DSIGH',SIGS,SIGH,DSIGHP

      END


CDECK  ID>, PHO_CONN1
      DOUBLE PRECISION FUNCTION PHO_CONN1(BETA)
C***********************************************************************
C
C    auxiliary function to determine parameters of soft
C    pt distribution  dNs/dP_t = P_t * AAS * EXP(-BETA*P_t)
C
C    internal factors: FS  number of soft partons in soft Pomeron
C                      FH  number of soft partons in hard Pomeron
C
C***********************************************************************

      IMPLICIT NONE

      SAVE

C  average number of cut soft and hard ladders (obsolete)
      DOUBLE PRECISION AVERI,AVERK,AVERL,AVERM,AVERN
      COMMON /POINT2/ AVERI,AVERK,AVERL,AVERM,AVERN

C  data needed for soft-pt calculation
      DOUBLE PRECISION SIGS,DSIGHP,SIGH,FS,FH,BETAS,AAS,PTCON
      COMMON /POINT3/ SIGS,DSIGHP,SIGH,FS,FH,BETAS(3),AAS,PTCON


      DOUBLE PRECISION BETA,XX,FF

      XX = BETA*PTCON
      IF(ABS(XX).LT.1.D-3) THEN
        FF = FS*SIGS+FH*SIGH
     &       - DSIGHP*(PTCON/2.D0+PTCON**2*BETA/6.D0)
      ELSE
        FF = FS*SIGS+FH*SIGH
     &       - DSIGHP/(PTCON*BETA**2)*(EXP(XX)-1.D0-BETA*PTCON)
      ENDIF
      PHO_CONN1 = FF

*     WRITE(6,'(1X,A,3E12.3)') 'PHO_CONN1:BETA,AAS,FF',BETA,AAS,FF
*     WRITE(6,'(1X,A,3E12.3)') 'PHO_CONN1:SIGS,SIGH,DSIGH',SIGS,SIGH,DSIGHP

      END


CDECK  ID>, PHO_MSHELL
      SUBROUTINE PHO_MSHELL(PA1,PA2,XM1,XM2,P1,P2,IREJ)
C********************************************************************
C
C    rescaling of momenta of two partons to put both
C                                       on mass shell
C
C    input:       PA1,PA2   input momentum vectors
C                 XM1,2     desired masses of particles afterwards
C                 P1,P2     changed momentum vectors
C
C********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS   =  1.D-20 )

      DIMENSION PA1(*),PA2(*),P1(*),P2(*)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  internal rejection counters
      INTEGER NMXJ
      PARAMETER (NMXJ=60)
      CHARACTER*10 REJTIT
      INTEGER IFAIL
      COMMON /POLOOP/ IFAIL(NMXJ),REJTIT(NMXJ)


      IREJ = 0
      IDEV = 0
C  debug output
      IF(IDEB(40).GE.10) THEN
        WRITE(ErrorOut,'(1X,A)') 'PHO_MSHELL: input momenta:'
        WRITE(ErrorOut,'(5X,4E12.5)') (PA1(K),K=1,4)
        WRITE(ErrorOut,'(5X,4E12.5)') (PA2(K),K=1,4)
        WRITE(ErrorOut,'(5X,A,2E12.3)') 'new masses:',XM1,XM2
      ENDIF

C  Lorentz transformation into system CMS
      PX = PA1(1)+PA2(1)
      PY = PA1(2)+PA2(2)
      PZ = PA1(3)+PA2(3)
      EE = PA1(4)+PA2(4)
      XMS = EE**2-PX**2-PY**2-PZ**2
      IF(XMS.LT.(XM1+XM2)**2) THEN
        IREJ = 1
        IFAIL(37) = IFAIL(37)+1

        IF((XM1.GT.1.D4).OR.(XM2.GT.1.D4)) IREJ = IREJ/IDEV

        IF(IDEB(40).GE.3) THEN
          WRITE(ErrorOut,'(/1X,A,I12)')
     &      'PHO_MSHELL:REJECT: TOO SMALL STRING MASS (KEVENT)',KEVENT
          WRITE(ErrorOut,
     * '(5X,A,3E12.4)') 'two-part.mass, part.masses:',
     &      SIGN(SQRT(ABS(XMS)),XMS),XM1,XM2
          WRITE(ErrorOut,
     * '(5X,A,4E11.4)') 'PX,PY,PZ,EE:',PX,PY,PZ,EE
          IDEV = 5
          IF(IDEB(40).GE.3) GOTO 55
        ENDIF
        RETURN
      ENDIF
      XMS = SQRT(XMS)
      BGX = PX/XMS
      BGY = PY/XMS
      BGZ = PZ/XMS
      GAM = EE/XMS
      CALL PHO_ALTRA(GAM,-BGX,-BGY,-BGZ,PA1(1),PA1(2),PA1(3),
     &           PA1(4),PTOT1,P1(1),P1(2),P1(3),P1(4))
C  rotation angles
      PTOT1 = MAX(DEPS,PTOT1)
      COD = P1(3)/PTOT1
      SID = SQRT(P1(1)**2+P1(2)**2)/PTOT1
      COF = 1.D0
      SIF = 0.D0
      IF(PTOT1*SID.GT.1.D-5) THEN
        COF = P1(1)/(SID*PTOT1)
        SIF = P1(2)/(SID*PTOT1)
        ANORF = SQRT(COF*COF+SIF*SIF)
        COF = COF/ANORF
        SIF = SIF/ANORF
      ENDIF

C  new CM momentum and energies (for masses XM1,XM2)
      XM12 = XM1**2
      XM22 = XM2**2
      SS   = XMS**2
      PCMP = PHO_XLAM(SS,XM12,XM22)/(2.D0*XMS)
      EE1  = SQRT(XM12+PCMP**2)
      EE2  = XMS-EE1
C  back rotation
      CALL PHO_TRANS(0.D0,0.D0,PCMP,COD,SID,COF,SIF,XX,YY,ZZ)
      CALL PHO_ALTRA(GAM,BGX,BGY,BGZ,XX,YY,ZZ,EE1,
     &           PTOT1,P1(1),P1(2),P1(3),P1(4))
      CALL PHO_ALTRA(GAM,BGX,BGY,BGZ,-XX,-YY,-ZZ,EE2,
     &           PTOT2,P2(1),P2(2),P2(3),P2(4))

C  check consistency
      DEL = XMS*0.0001
      IF(ABS(PX-P1(1)-P2(1)).GT.DEL) THEN
        IDEV = 1
      ELSE IF(ABS(PY-P1(2)-P2(2)).GT.DEL) THEN
        IDEV = 2
      ELSE IF(ABS(PZ-P1(3)-P2(3)).GT.DEL) THEN
        IDEV = 3
      ELSE IF(ABS(EE-P1(4)-P2(4)).GT.DEL) THEN
        IDEV = 4
      ENDIF
 55   CONTINUE
C  debug output
      IF(IDEV.NE.0) THEN
        WRITE(ErrorOut,'(1X,A,I3)')
     &    'PHO_MSHELL: INCONSISTENT TRANSFORMATION (IDEV)',IDEV
        WRITE(ErrorOut,'(1X,A)') 'PHO_MSHELL: input momenta:'
        WRITE(ErrorOut,'(5X,4E12.5)') (PA1(K),K=1,4)
        WRITE(ErrorOut,'(5X,4E12.5)') (PA2(K),K=1,4)
        WRITE(ErrorOut,
     * '(5X,A,3E12.3)') 'ava.mass,masses:',XMS,XM1,XM2
        WRITE(ErrorOut,'(1X,A)') 'PHO_MSHELL: output momenta:'
        WRITE(ErrorOut,'(5X,4E12.5)') (P1(K),K=1,4)
        WRITE(ErrorOut,'(5X,4E12.5)') (P2(K),K=1,4)
      ELSE IF(IDEB(40).GE.10) THEN
        WRITE(ErrorOut,'(1X,A)') 'PHO_MSHELL: output momenta:'
        WRITE(ErrorOut,'(5X,4E12.5)') (P1(K),K=1,4)
        WRITE(ErrorOut,'(5X,4E12.5)') (P2(K),K=1,4)
      ENDIF
      END
#endif
