#include "Zcondc.h"
#if USEDPMJET == 1
C***********************************************************************
C
C
C
C                       PHOJET version 1.12
C                       -------------------
C
C
C    ($Revision: 1.12.1.35 $, $Date: 2000/06/25 21:59:19 $)
C
C
C    Authors: Ralph Engel
C             (eng@lepton.bartol.udel.edu)
C
C             Johannes Ranft
C             (johannes.ranft@cern.ch)
C
C             Stefan Roesler
C             (sroesler@SLAC.Stanford.EDU)
C
C
C    For the latest version and documentation check
C       http://lepton.bartol.udel.edu/~eng/phojet.html
C
C
C    Bug reports, questions, complaints are welcome (please send a
C    mail to eng@lepton.bartol.udel).
C
C
C    Note that the code is available with several interfaces to
C    Lund fragmentation programs (JETSET7.x, 1.x and a double
C    precision JETSET version). This file is the code with
C

C                interface to PYTHIA 6.1 (or higher)


C     for usage in DTUNUC 2.x (Lund common block dimensions increased)

C
C***********************************************************************
C
C
C             List of subroutines and functions
C             ---------------------------------
C
C
C  main event simulation routines
C
C      PHO_EVENT
C      PHO_PARTON
C      PHO_POSPOM
C
C      PHO_STDPAR
C      PHO_POMSCA
C
C
C  user steering interface
C
C      PHO_SETMDL
C      PHO_PRESEL
C
C
C  experimental setup / photon flux calculation
C
C      PHO_FIXLAB
C      PHO_FIXCOL
C      PHO_GPHERA
C      PHO_GGEPEM
C      PHO_WGEPEM
C      PHO_GGBLSR
C      PHO_GGBEAM
C      PHO_GGHIOF
C      PHO_GGHIOG
C      PHO_GGFLCL
C      PHO_GGFLCR
C      PHO_GGFAUX
C      PHO_GGFNUC
C      PHO_GHHIOF
C      PHO_GHHIAS
C
C
C  initialization
C
C      PHO_INIT
C      PHO_DATINI
C      PHO_PARDAT
C      PHO_MCINI
C
C      PHO_EVEINI
C
C      PHO_HARINI
C      PHO_FRAINI
C
C      PHO_FITPAR
C
C
C  cross section calculation
C
C      PHO_CSINT
C
C      PHO_XSECT
C      PHO_BORNCS
C      PHO_HARXTO
C
C      PHO_DSIGDT
C
C      PHO_TRIREG
C      PHO_LOOREG
C      PHO_TRXPOM
C
C      PHO_EIKON
C      PHO_CHAN2A
C
C      PHO_SCALES
C
C
C  multiple interaction structure
C
C      PHO_IMPAMP
C      PHO_PRBDIS
C      PHO_SAMPRO
C      PHO_SAMPRB
C
C
C  hadron / photon remnant treatment, soft x selection
C
C      PHO_HARREM
C      PHO_PARREM
C
C      PHO_HADSP2
C      PHO_HADSP3
C      PHO_SOFTXX
C      PHO_SELSXR
C      PHO_SELSX2
C      PHO_SELSXS
C      PHO_SELSXI
C
C      PHO_VALFLA
C      PHO_REGFLA
C      PHO_SEAFLA
C      PHO_FLAUX
C      PHO_BETAF
C      IPHO_DIQU
C
C
C  primordial kt and soft parton pt
C
C      PHO_PRIMKT
C      PHO_PARTPT
C      PHO_SOFTPT
C      PHO_SELPT
C
C      PHO_CONN0
C      PHO_CONN1
C
C
C  simulation of hard scattering, initial state radiation
C
C      PHO_HARCOL
C      PHO_SELCOL
C      PHO_HARCOR
C
C      PHO_HARDIR
C      PHO_HARX12
C      PHO_HARDX1
C      PHO_HARKIN
C      PHO_HARWGH
C      PHO_HARSCA
C      PHO_HARFAC
C      PHO_HARWGX
C      PHO_HARWGI
C      PHO_HARINT
C      PHO_HARMCI
C
C      PHO_HARXR3
C      PHO_HARXR2
C      PHO_HARXD2
C      PHO_HARXPT
C      PHO_HARISR
C      PHO_HARZSP
C
C      PHO_PTCUT
C      PHO_ALPHAE
C      PHO_ALPHAS
C
C
C  diffraction dissociation
C
C      PHO_DIFDIS
C      PHO_DIFPRO
C      PHO_DIFPAR
C      PHO_QELAST
C      PHO_CDIFF
C      PHO_DFWRAP
C
C      PHO_SAMASS
C      PHO_DSIGDM
C      PHO_DFMASS
C
C      PHO_SDECAY
C      PHO_SDECY2
C      PHO_SDECY3
C
C      PHO_DIFSLP
C      PHO_DIFKIN
C      PHO_VECRES
C      PHO_DIFRES
C
C      PHO_REGPAR
C
C      PHO_PECMS
C      PHO_SETPAR
C
C
C  fragmentation, treatment of low-mass strings
C
C      PHO_STRING
C      PHO_STRFRA
C
C      PHO_ID2STR
C      PHO_MCHECK
C      PHO_POMCOR
C      PHO_MASCOR
C      PHO_PARCOR
C
C      PHO_GLU2QU
C      PHO_GLUSPL
C
C      PHO_DQMASS
C      PHO_BAMASS
C      PHO_MEMASS
C
C
C  particle code tables, particle numbering conversion
C
C      PHO_PNAME
C      PHO_PMASS
C      IPHO_CHR3
C      IPHO_BAR3
C
C      IPHO_ANTI
C
C      IPHO_PDG2ID
C      IPHO_ID2PDG
C      IPHO_LU2PDG
C      IPHO_PDG2LU
C
C      IPHO_CNV1
C      PHO_HACODE
C
C
C
C  Lorentz transformations, rotations and mass adjustment
C
C      PHO_ALTRA
C      PHO_LTRANS
C      PHO_TRANS
C      PHO_TRANI
C
C      PHO_MKSLTR
C      PHO_GETLTR
C
C      PHO_LTRHEP
C
C      PHO_MSHELL
C      PHO_MASSAD
C
C
C  program debugging and internal cross-checks
C
C      PHO_PREVNT
C      PHO_PRSTRG
C      PHO_CHECK
C
C      PHO_TRACE
C
C      PHO_REJSTA
C
C      PHO_ABORT
C
C
C  cross section fitting
C
C      PHO_FITMAI
C      PHO_FITINP
C      PHO_FITDAT
C      PHO_FITOUT
C      PHO_FITAMP
C      PHO_FITTST
C      PHO_FITMSQ
C      PHO_FITVD1
C      PHO_FITCN1
C      PHO_FITINI
C
C
C  cross section parametrizations
C
C      PHO_HADCSL
C      PHO_ALLM97
C      PHO_CSDIFF
C

C
C  random numbers
C
C      PHO_RNDM
C
C      PHO_RNDIN
C      PHO_RNDSI
C      PHO_RNDSO
C      PHO_RNDTE
C      PHO_RNDST
C
C      PHO_SFECFE
C      PHO_RNDBET
C      PHO_RNDGAM
C
C
C  auxiliary routines / numerical methods
C
C      PHO_GAUSET
C      PHO_GAUDAT
C
C      pho_samp1d
C
C      PHO_DZEROX
C      PHO_EXPINT
C      PHO_BESSJ0
C      PHO_BESSI0
C      pho_ExpBessI0
C      PHO_BESSI1
C      PHO_BESSK0
C      PHO_BESSK1
C
C      PHO_XLAM
C
C      PHO_SWAPD
C      PHO_SWAPI
C
C
C  parton density management / interface
C
C      PHO_PDF
C
C      PHO_SETPDF
C      PHO_GETPDF
C      PHO_ACTPDF
C
C      PHO_QPMPDF
C
C      PHO_PDFTST
C
C
C  parton density parametrizations form other authors
C
C      PHO_DOR98LO
C      PHO_DOR98SC
C      PHO_DOR94LO
C      PHO_DOR94HO
C      PHO_DOR94DI
C      PHO_DOR92LO
C      PHO_DOR92HO
C      PHO_DORPLO
C      PHO_DORPHO
C      PHO_DORGLO
C      PHO_DORGHO
C      PHO_DORGH0
C      PHO_DOR94FV
C      PHO_DOR94FW
C      PHO_DOR94FS
C      PHO_DOR92FV
C      PHO_DOR92FW
C      PHO_DOR92FS
C      PHO_DORFVP
C      PHO_DORFGP
C      PHO_DORFQP
C      PHO_DORGF
C      PHO_DORGFS
C      PHO_grsf1
C      PHO_grsf2
C
C      PHO_CKMTPA
C      PHO_CKMTPD
C      PHO_CKMTPO
C      PHO_CKMTFV
C
C      PHO_DBFINT
C
C      PHO_SASGAM
C      PHO_SASVMD
C      PHO_SASANO
C      PHO_SASBEH
C      PHO_SASDIR
C
C      PHO_PHGAL
C      PHVAL
C
C
C***********************************************************************

CDECK  ID>, PHO_INIT
      SUBROUTINE PHO_INIT(LINP,IREJ)
C**********************************************************************
C
C     main subroutine to configure and manage PHOJET calculations
C
C     input:  LINP       input unit to read from
C                        -1 to skip reading of input file
C
C     output: IREJ       0  success
C                        1  failure
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)


C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  integration precision for hard cross sections (obsolete)
      INTEGER NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO
      COMMON /POGAUP/ NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO

C  some hadron information, will be deleted in future versions
      INTEGER NFS
      DOUBLE PRECISION QMASS,BET,PCOUDI,PNORM,VALPRG
      COMMON /POHDRN/ QMASS(6),BET,PCOUDI,PNORM,VALPRG(2),NFS

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  photon flux kinematics and cuts
      DOUBLE PRECISION ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                 YMIN1,YMAX1,YMIN2,YMAX2,
     &                 Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                 THMIN1,THMAX1,THMIN2,THMAX2
      INTEGER          ITAG1,ITAG2
      COMMON /POFCUT/ ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                YMIN1,YMAX1,YMIN2,YMAX2,
     &                Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                THMIN1,THMAX1,THMIN2,THMAX2,
     &                ITAG1,ITAG2

C  cut probability distribution
      INTEGER IEETA1,IIMAX,KKMAX
      PARAMETER( IEETA1=20, IIMAX=20, KKMAX=20 )
      INTEGER IEEMAX,IMAX,KMAX
      REAL PROB
      DOUBLE PRECISION EPTAB
      COMMON /POPROB/ PROB(4,IEETA1,0:IIMAX,0:KKMAX),EPTAB(4,IEETA1),
     &                IEEMAX,IMAX,KMAX

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)

C  names of hard scattering processes
      INTEGER MAX_PRO_1
      PARAMETER ( MAX_PRO_1 = 16 )
      CHARACTER*18 PROC
      COMMON /POHPRO/ PROC(0:MAX_PRO_1)

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)



      INTEGER MSTU,MSTJ
      DOUBLE PRECISION PARU,PARJ
      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)



      INTEGER KCHG
      DOUBLE PRECISION  PMAS,PARF,VCKM
      COMMON/PYDAT2/KCHG(500,4),PMAS(500,4),PARF(2000),VCKM(4,4)



      INTEGER MDCY,MDME,KFDP
      DOUBLE PRECISION  BRAT
      COMMON/PYDAT3/MDCY(500,3),MDME(4000,2),BRAT(4000),KFDP(4000,5)




      INTEGER PYCOMP




      DIMENSION ITMP(0:11)
      CHARACTER*10 CNAME
      CHARACTER*70 NUMBER,FILENA

 14   FORMAT(A10,A69)
 15   FORMAT(A12)
      IREJ = 0
      WRITE(ErrorOut,*)
      WRITE(ErrorOut,
     * *) ' ==================================================='
      WRITE(ErrorOut,
     * *) '                                                    '
      WRITE(ErrorOut,
     * *) '      --      PHOJET version 1.12           --      '
      WRITE(ErrorOut,
     * *) '                                                    '
      WRITE(ErrorOut,
     * *) ' ==================================================='
      WRITE(ErrorOut,
     * *) '     Authors: Ralph Engel      (Bartol Res. Inst.)'
      WRITE(ErrorOut,
     * *) '              Johannes Ranft   (Siegen Univ.)'
      WRITE(ErrorOut,*) '              Stefan Roesler   (SLAC)'
      WRITE(ErrorOut,
     * *) ' ---------------------------------------------------'
      WRITE(ErrorOut,
     * *) '   Manual, updates, and further information:'
      WRITE(ErrorOut,
     * *) '    http://lepton.bartol.udel.edu/~eng/phojet.html'
      WRITE(ErrorOut,
     * *) ' ---------------------------------------------------'
      WRITE(ErrorOut,
     * *) '    please send suggestions / bug reports etc. to:'
      WRITE(ErrorOut,
     * *) '             eng@lepton.bartol.udel.edu'
      WRITE(ErrorOut,
     * *) ' ==================================================='
      WRITE(ErrorOut,*) '   $Date: 2000/06/25 21:59:19 $'
      WRITE(ErrorOut,*) '   $Revision: 1.12.1.35 $'

      WRITE(ErrorOut,
     * *) '   (code version with interface to PYTHIA 6.x)'


      WRITE(ErrorOut,
     * *) '   (code version for usage in DTUNUC 2.x)'

      WRITE(ErrorOut,
     * *) ' ==================================================='
      WRITE(ErrorOut,*)

C  random numbers
      CALL PHO_RNDIN(12,34,56,78)
      CALL PHO_RNDTE(0)
C  standard initializations
      CALL PHO_DATINI
      CALL PHO_PARDAT
      DUM = PHO_PMASS(0,-1)
C  initialize standard PDFs
C  proton
      CALL PHO_SETPDF(2212,IDUM,5,6,0,0,-1)
      CALL PHO_SETPDF(-2212,IDUM,5,6,0,0,-1)
C  neutron
      CALL PHO_SETPDF(2112,IDUM,5,6,0,0,-1)
      CALL PHO_SETPDF(-2112,IDUM,5,6,0,0,-1)
C  photon
      CALL PHO_SETPDF(22,IDUM,5,3,0,0,-1)
C  pomeron
      CALL PHO_SETPDF(990,IDUM,4,0,0,0,-1)
C  pion
      CALL PHO_SETPDF(211,IDUM,5,2,0,0,-1)
      CALL PHO_SETPDF(-211,IDUM,5,2,0,0,-1)
      CALL PHO_SETPDF(111,IDUM,5,2,0,0,-1)
C  kaons
      CALL PHO_SETPDF(321,IDUM,5,2,0,0,-1)
      CALL PHO_SETPDF(-321,IDUM,5,2,0,0,-1)

C  nothing to be done
      IF(LINP.LT.0) RETURN

C  main loop to read input cards
 1200 CONTINUE
        READ(LINP,14,END=1300) CNAME,NUMBER
        IF(CNAME.EQ.'ENDINPUT  ') THEN
          GOTO 1300
        ELSE IF(CNAME.EQ.'STOP      ') THEN
          WRITE(ErrorOut,*) 'STOP'
          STOP
        ELSE IF(CNAME.EQ.'COMMENT   ') THEN
          WRITE(ErrorOut,'(1X,A10,A69)') 'COMMENT   ',NUMBER
        ELSE IF(CNAME(1:1).EQ.'*') THEN
          WRITE(ErrorOut,'(1X,A10,A69)') CNAME,NUMBER
        ELSE IF(CNAME.EQ.'PTCUT     ') THEN
          READ(NUMBER,*) PARMDL(36),PARMDL(37),PARMDL(38),PARMDL(39)
          WRITE(ErrorOut,*) 'PTCUT     ',PARMDL(36),PARMDL(37),
     &      PARMDL(38),PARMDL(39)
        ELSE IF(CNAME.EQ.'PROCESS   ') THEN
          READ(NUMBER,*) (IPRON(KK,1),KK=1,8)
          WRITE(ErrorOut,*) 'PROCESS   ',(IPRON(KK,1),KK=1,8)
        ELSE IF(CNAME.EQ.'DIFF-PROC ') THEN
          READ(NUMBER,*) (ITMP(KK),KK=0,11)
          WRITE(ErrorOut,*) 'DIFF-PROC ',(ITMP(KK),KK=0,8)
          DO 112 KK=1,8
            IPRON(KK,ITMP(0)) = ITMP(KK)
 112      CONTINUE
        ELSE IF(CNAME.EQ.'SUBPROCESS') THEN
          READ(NUMBER,*) IMPRO,IP,ION
          WRITE(ErrorOut,*) 'SUBPROCESS',IMPRO,IP,ION
          MH_PRO_ON(IMPRO,IP) = ION
        ELSE IF(CNAME.EQ.'PARTICLE1 ') THEN
          READ(NUMBER,*) IDPDG,PVIR
          IHFLS(1) = 1
          XPSUB = 1.D0
          CALL PHO_SETPAR(1,IDPDG,0,PVIR)
          WRITE(ErrorOut,*) 'PARTICLE1  ',IDPDG,PVIR
        ELSE IF(CNAME.EQ.'PARTICLE2 ') THEN
          READ(NUMBER,*) IDPDG,PVIR
          IHFLS(2) = 1
          XTSUB = 1.D0
          CALL PHO_SETPAR(2,IDPDG,0,PVIR)
          WRITE(ErrorOut,*) 'PARTICLE2  ',IDPDG,PVIR
        ELSE IF(CNAME.EQ.'REMNANT1  ') THEN
          READ(NUMBER,*) IDPDG,IFL1,IFL2,IVAL,XSUB
          IHFLS(1) = IVAL
          IHFLD(1,1) = IFL1
          IHFLD(1,2) = IFL2
          XPSUB = XSUB
          PVIR = 0.D0
          CALL PHO_SETPAR(1,IDPDG,-1,PVIR)
          WRITE(ErrorOut,
     * *) 'REMNANT1   ',IDPDG,IFL1,IFL2,IVAL,XSUB
        ELSE IF(CNAME.EQ.'REMNANT2  ') THEN
          READ(NUMBER,*) IDPDG,IFL1,IFL2,IVAL,XSUB
          IHFLS(2) = IVAL
          IHFLD(2,1) = IFL1
          IHFLD(2,2) = IFL2
          XTSUB = XSUB
          PVIR = 0.D0
          CALL PHO_SETPAR(2,IDPDG,-1,PVIR)
          WRITE(ErrorOut,
     * *) 'REMNANT2   ',IDPDG,IFL1,IFL2,IVAL,XSUB
        ELSE IF(CNAME.EQ.'PDF       ') THEN
          READ(NUMBER,*) IDPDG,IPAR,ISET,IEXT
          WRITE(ErrorOut,*) 'PDF        ',IDPDG,IPAR,ISET,IEXT
          CALL PHO_SETPDF(IDPDG,IDUM,IPAR,ISET,IEXT,0,-1)
        ELSE IF(CNAME.EQ.'SETMODEL  ') THEN
          READ(NUMBER,*) I,IVAL
          WRITE(ErrorOut,*) 'SETMODEL   ',I,IVAL
          CALL PHO_SETMDL(I,IVAL,1)
        ELSE IF(CNAME.EQ.'SETPARAM  ') THEN
          READ(NUMBER,*) I,PARNEW
          WRITE(ErrorOut,*) 'SETPARAM   ',I,PARNEW
          PARMDL(I) = PARNEW
        ELSE IF(CNAME.EQ.'DEBUG     ') THEN
          READ(NUMBER,*) IDEBF,IDEBN,IDLEV
          WRITE(ErrorOut,*) 'DEBUG      ',IDEBF,IDEBN,IDLEV
          CALL PHO_TRACE(IDEBF,IDEBN,IDLEV)
        ELSE IF(CNAME.EQ.'TRACE     ') THEN
          READ(NUMBER,*) IDEBF,IDLEV
          WRITE(ErrorOut,*) 'TRACE      ',IDEBF,IDLEV
          IDEB(IDEBF) = IDLEV
        ELSE IF(CNAME.EQ.'SETICUT   ') THEN
          READ(NUMBER,*) I,ICUT
          WRITE(ErrorOut,*) 'SETICUT    ',I,ICUT
          ISWCUT(I) = ICUT
        ELSE IF(CNAME.EQ.'SETFCUT   ') THEN
          READ(NUMBER,*) I,PARNEW
          WRITE(ErrorOut,*) 'SETFCUT    ',I,PARNEW
          HSWCUT(I) = PARNEW
        ELSE IF(CNAME.EQ.'LUND-MSTU ') THEN
          READ(NUMBER,*) I,IVAL
          WRITE(ErrorOut,*) 'LUND-MSTU  ',I,IVAL
          MSTU(I) = IVAL
        ELSE IF(CNAME.EQ.'LUND-MSTJ ') THEN
          READ(NUMBER,*) I,IVAL
          WRITE(ErrorOut,*) 'LUND-MSTJ  ',I,IVAL
          MSTJ(I) = IVAL
        ELSE IF(CNAME.EQ.'LUND-PARJ ') THEN
          READ(NUMBER,*) I,EE
          WRITE(ErrorOut,*) 'LUND-PARJ  ',I,EE
          PARJ(I) = REAL(EE)
        ELSE IF(CNAME.EQ.'LUND-PARU ') THEN
          READ(NUMBER,*) I,EE
          WRITE(ErrorOut,*) 'LUND-PARU  ',I,EE
          PARU(I) = REAL(EE)
        ELSE IF(CNAME.EQ.'LUND-DECAY') THEN
          READ(NUMBER,*) ID,ION
          WRITE(ErrorOut,*) 'LUND-DECAY ',ID,ION

          KC=PYCOMP(ID)

          MDCY(KC,1) = ION
        ELSE IF(CNAME.EQ.'PSOFTMIN  ') THEN
          READ(NUMBER,*) PSOMIN
          WRITE(ErrorOut,*) 'PSOFTMIN   ',PSOMIN
        ELSE IF(CNAME.EQ.'INTPREC   ') THEN
          READ(NUMBER,*) NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO
          WRITE(ErrorOut,
     * *) 'INTPREC    ',NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO



C  PDF test utility
        ELSE IF(CNAME.EQ.'PDFTEST   ') THEN
          READ(NUMBER,*) IDPDG,SCALE2,PVIRT2
          PVIRT2 = ABS(PVIRT2)
          WRITE(ErrorOut,
     * *) 'PDFTEST   ',IDPDG,' ',SCALE2,' ',PVIRT2
          CALL PHO_PDFTST(IDPDG,SCALE2,PVIRT2)

C  mass cut on gamma-gamma or gamma-hadron system
        ELSE IF(CNAME.EQ.'ECMS-CUT  ') THEN
          READ(NUMBER,*) ECMIN,ECMAX
          WRITE(ErrorOut,*) 'ECMS-CUT  ',ECMIN,ECMAX

C  beam lepton (anti-)tagging system
        ELSE IF(CNAME.EQ.'TAG-METHOD') THEN
          READ(NUMBER,*) ITAG1,ITAG2
          WRITE(ErrorOut,*) 'TAG-METHOD',ITAG1,ITAG2
        ELSE IF(CNAME.EQ.'E-TAG1    ') THEN
          READ(NUMBER,*)
     &      EEMIN1,YMIN1,YMAX1,Q2MIN1,Q2MAX1,THMIN1,THMAX1
          WRITE(ErrorOut,*) 'E-TAG1    ',EEMIN1,YMIN1,YMAX1,
     &      Q2MIN1,Q2MAX1,THMIN1,THMAX1
        ELSE IF(CNAME.EQ.'E-TAG2    ') THEN
          READ(NUMBER,*)
     &      EEMIN2,YMIN2,YMAX2,Q2MIN2,Q2MAX2,THMIN2,THMAX2
          WRITE(ErrorOut,*) 'E-TAG2    ',EEMIN2,YMIN2,YMAX2,
     &      Q2MIN2,Q2MAX2,THMIN2,THMAX2

C  sampling of gamma-p events in ep (HERA)
        ELSE IF(    (CNAME.EQ.'WW-HERA   ')
     &          .OR.(CNAME.EQ.'GP-HERA   ')) THEN
          READ(NUMBER,*) EE1,EE2,NEV
          WRITE(ErrorOut,*) 'GP-HERA   ',EE1,EE2,NEV
          IF(YMAX2.LT.0.D0) THEN
            WRITE(ErrorOut,
     * *) ' PHO_INIT:ERROR:ELECTRON TAGGER NOT SET'
          ELSE
            CALL PHO_GPHERA(NEV,EE1,EE2)
            KEVENT = 0
          ENDIF

C  sampling of gamma-gamma events in e+e- (LEP)
        ELSE IF(    (CNAME.EQ.'GG-EPEM   ')
     &          .OR.(CNAME.EQ.'WW-EPEM   ')) THEN
          READ(NUMBER,*) EE1,EE2,NEV
          WRITE(ErrorOut,*) 'GG-EPEM   ',EE1,EE2,NEV
          IF((YMAX1.LT.0.D0).OR.(YMAX2.LT.0.D0)) THEN
            WRITE(ErrorOut,
     * *) ' PHO_INIT:ERROR:ELECTRON TAGGERS NOT SET'
          ELSE
            CALL PHO_GGEPEM(-1,EE1,EE2)
            CALL PHO_GGEPEM(NEV,EE1,EE2)
            CALL PHO_GGEPEM(-2,SIG_TOT,SIG_GG)
            KEVENT = 0
          ENDIF

C  sampling of gamma-gamma in heavy-ion collisions
        ELSE IF(CNAME.EQ.'GG-HION-F ') THEN
          READ(NUMBER,*) EE,NA,NZ,NEV
          WRITE(ErrorOut,*) 'GG-HION-F ',EE,NA,NZ,NEV
          IF((YMAX1.LT.0.D0).OR.(YMAX2.LT.0.D0)) THEN
            WRITE(ErrorOut,
     * *) ' PHO_INIT:ERROR:Y RANGE FOR PHOTONS NOT SET'
          ELSE
            CALL PHO_GGHIOF(NEV,EE,NA,NZ)
            KEVENT = 0
          ENDIF
        ELSE IF(CNAME.EQ.'GG-HION-G ') THEN
          READ(NUMBER,*) EE,NA,NZ,NEV
          WRITE(ErrorOut,*) 'GG-HION-G ',EE,NA,NZ,NEV
          IF((YMAX1.LT.0.D0).OR.(YMAX2.LT.0.D0)) THEN
            WRITE(ErrorOut,
     * *) ' PHO_INIT:ERROR:Y RANGE FOR PHOTONS NOT SET'
          ELSE
            CALL PHO_GGHIOG(NEV,EE,NA,NZ)
            KEVENT = 0
          ENDIF

C  sampling of gamma-hadron events in heavy ion collisions
        ELSE IF(CNAME.EQ.'GH-HION-F ') THEN
          READ(NUMBER,*) EE,NA,NZ,NEV
          WRITE(ErrorOut,*) 'GH-HION-F ',EE,NA,NZ,NEV
          IF((YMAX1.LT.0.D0).OR.(YMAX2.LT.0.D0)) THEN
            WRITE(ErrorOut,
     * *) ' PHO_INIT:ERROR:Y RANGE FOR PHOTONS NOT SET'
          ELSE
            CALL PHO_GHHIOF(NEV,EE,NA,NZ)
            KEVENT = 0
          ENDIF

C  sampling of hadron-gamma events in hadron - heavy ion collisions
        ELSE IF(CNAME.EQ.'HG-HIAS-F ') THEN
          READ(NUMBER,*) EP,EE,NA,NZ,NEV
          WRITE(ErrorOut,*) 'HG-HIAS-F ',EP,EE,NA,NZ,NEV
          IF(YMAX2.LT.0.D0) THEN
            WRITE(ErrorOut,
     * *) ' PHO_INIT:ERROR:Y RANGE FOR PHOTONS NOT SET'
          ELSE
            CALL PHO_GHHIAS(NEV,EP,EE,NA,NZ)
            KEVENT = 0
          ENDIF

C  sampling of photoproduction events e+e-, backscattered laser
        ELSE IF(CNAME.EQ.'BLASER    ') THEN
          READ(NUMBER,*) EE1,EE2,PL_LAM_1,PL_LAM_2,X_1,X_2,RHO,A,NEV
          WRITE(ErrorOut,*) 'BLASER    ',EE1,EE2,
     &      PL_LAM_1,PL_LAM_2,X_1,X_2,RHO,A,NEV
          CALL PHO_GGBLSR(NEV,EE1,EE2,PL_LAM_1,PL_LAM_2,X_1,X_2,RHO,A)
          KEVENT = 0

C  sampling of photoproduction events beamstrahlung
        ELSE IF(CNAME.EQ.'BEAMST    ') THEN
          READ(NUMBER,*) EE1,YPSI,SIGX,SIGY,SIGZ,AEB,NEV
          WRITE(ErrorOut,
     * *) 'BEAMST    ',EE1,YPSI,SIGX,SIGY,SIGZ,AEB,NEV
          IF(YMAX1.LT.0.D0) THEN
            WRITE(ErrorOut,
     * *) ' PHO_INIT:ERROR:ELECTRON TAGGER 1 NOT SET'
          ELSE
            CALL PHO_GGBEAM(NEV,EE1,YPSI,SIGX,SIGY,SIGZ,AEB)
            KEVENT = 0
          ENDIF

C  fixed-energy events in LAB system of particle 2
        ELSE IF(CNAME.EQ.'EVENT-LAB ') THEN
          READ(NUMBER,*) PLAB,NEV
          WRITE(ErrorOut,*) 'EVENT-LAB ',PLAB,NEV
          CALL PHO_FIXLAB(PLAB,NEV)
          KEVENT = 0

C  fixed-energy events in CM system
        ELSE IF(CNAME.EQ.'EVENT-CMS ') THEN
          READ(NUMBER,*) ECM,NEV
          WRITE(ErrorOut,*) 'EVENT-CMS ',ECM,NEV
          PMASS1 = PHO_PMASS(IFPAB(1),0)-SQRT(PVIRT(1))
          PMASS2 = PHO_PMASS(IFPAB(2),0)-SQRT(PVIRT(2))
          CALL PHO_PECMS(1,PMASS1,PMASS2,ECM,PCM,EE)
          E1 = EE
          E2 = ECM-EE
          THETA = 0.D0
          PHI   = 0.D0
          CALL PHO_FIXCOL(E1,E2,THETA,PHI,NEV)
          KEVENT = 0

C  fixed-energy events for collider setup with crossing angle
        ELSE IF(CNAME.EQ.'EVENT-COLL') THEN
          READ(NUMBER,*) E1,E2,THETA,PHI,NEV
          WRITE(ErrorOut,*) 'EVENT-COLL',E1,E2,THETA,PHI,NEV
          CALL PHO_FIXCOL(E1,E2,THETA,PHI,NEV)
          KEVENT = 0

C  read status registers from file to initialize random number generator
        ELSE IF(CNAME.EQ.'READ-RNDM ') THEN
          READ(NUMBER,'(A70)') FILENA
          WRITE(ErrorOut,*) 'READ-RNDM ',FILENA
          CALL PHO_RNDST(1,FILENA)

C  save status registers of random number generator to file
        ELSE IF(CNAME.EQ.'SAVE-RNDM ') THEN
          READ(NUMBER,'(A70)') FILENA
          WRITE(ErrorOut,*) 'SAVE-RNDM ',FILENA
          CALL PHO_RNDST(2,FILENA)

C  initialize random number generator with given seeds
        ELSE IF(CNAME.EQ.'INIT-RNDM ') THEN
          READ(NUMBER,*) ISD1,ISD2,ISD3,ISD4
          WRITE(ErrorOut,*) 'INIT-RNDM  ',ISD1,ISD2,ISD3,ISD4
          IF(    (ISD1.LT.1).OR.(ISD1.GT.178)
     &       .OR.(ISD2.LT.1).OR.(ISD2.GT.178)
     &       .OR.(ISD3.LT.1).OR.(ISD3.GT.178)
     &       .OR.(ISD4.LT.1).OR.(ISD4.GT.168)) THEN
            WRITE(ErrorOut,'(//1X,A,//)')
     &        'PHO_INIT: SEEDS OUT OF RANGE, NOTHING DONE.'
          ELSE IF((ISD1.EQ.1).OR.(ISD2.EQ.1).OR.(ISD3.EQ.1)) THEN
            WRITE(ErrorOut,'(//1X,A,//)')
     &        'PHO_INIT: FIRST THREE SEEDS EQUAL TO 1, NOTHING DONE.'
          ELSE
            CALL PHO_RNDIN(ISD1,ISD2,ISD3,ISD4)
            WRITE(ErrorOut,'(1X,A)')
     &        'RANDOM NUMBER GENERATOR INITIALIZED WITH NEW SEEDS.'
          ENDIF

C  unknown data card
        ELSE
          WRITE(ErrorOut,
     * *) 'PHO_INIT: unknown data card: ',CNAME,NUMBER
        ENDIF

      GOTO 1200
 1300 CONTINUE
      WRITE(ErrorOut,*) ' RETURN'

      END


CDECK  ID>, PHO_SETMDL
      SUBROUTINE PHO_SETMDL(INDX,IVAL,IMODE)
C**********************************************************************
C
C     set model switches
C
C     input:  INDX       model parameter number
C                        (positive: ISWMDL, negative: IPAMDL)
C             IVAL       new value
C             IMODE      -1  print value of parameter INDX
C                        1   set new value
C                        -2  print current settings
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


      IF(IMODE.EQ.-2) THEN
        WRITE(ErrorOut,
     * '(/1X,A,/1X,A,/)') 'PHO_SETMDL: current settings',
     &                             '----------------------------'
        DO 100 I=1,48,3
          IF(ISWMDL(I).EQ.-9999) GOTO 200
          IF(ISWMDL(I+1).EQ.-9999) THEN
            WRITE(ErrorOut,
     * '(5X,I3,A1,A,I6)') I,':',MDLNA(I),ISWMDL(I)
            GOTO 200
          ELSE IF(ISWMDL(I+2).EQ.-9999) THEN
            WRITE(ErrorOut,
     * '(2(5X,I3,A1,A,I6))') I,':',MDLNA(I),ISWMDL(I),
     &        I+1,':',MDLNA(I+1),ISWMDL(I+1)
            GOTO 200
          ELSE
            WRITE(ErrorOut,'(3(5X,I3,A1,A,I6))')
     &        (I+K,':',MDLNA(I+K),ISWMDL(I+K),K=0,2)
          ENDIF
 100    CONTINUE
 200    CONTINUE
      ELSE IF(IMODE.EQ.-1) THEN
        WRITE(ErrorOut,
     * '(1X,A,1X,A,I6)') 'PHO_SETMDL:',MDLNA(INDX),ISWMDL(INDX)
      ELSE IF(IMODE.EQ.1) THEN
        IF(INDX.GT.0) THEN
          IF(ISWMDL(INDX).NE.IVAL) THEN
            WRITE(ErrorOut,
     * '(1X,A,I4,1X,A,2I6)') 'PHO_SETMDL:ISWMDL(OLD/NEW):',
     &        INDX,MDLNA(INDX),ISWMDL(INDX),IVAL
            ISWMDL(INDX) = IVAL
          ENDIF
        ELSE IF(INDX.LT.0) THEN
          IF(IPAMDL(-INDX).NE.IVAL) THEN
            WRITE(ErrorOut,
     * '(1X,A,I4,1X,2I6)') 'PHO_SETMDL:IPAMDL(OLD/NEW):',
     &        -INDX,IPAMDL(-INDX),IVAL
            IPAMDL(-INDX) = IVAL
          ENDIF
        ENDIF
      ELSE
        WRITE(ErrorOut,
     * '(/1X,A,I6)') 'PHO_SETMDL:ERROR: unsupported mode',IMODE
      ENDIF
      END


CDECK  ID>, PHO_DATINI
      SUBROUTINE PHO_DATINI
C*********************************************************************
C
C     initialization of variables and switches
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)

C  scale parameters for parton model calculations
      INTEGER NQQAL,NQQALI,NQQALF,NQQPD
      DOUBLE PRECISION AQQAL,AQQALI,AQQALF,AQQPD
      COMMON /POHSCL/ AQQAL,AQQALI,AQQALF,AQQPD,
     &                NQQAL,NQQALI,NQQALF,NQQPD

C  integration precision for hard cross sections (obsolete)
      INTEGER NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO
      COMMON /POGAUP/ NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF

C  cut probability distribution
      INTEGER IEETA1,IIMAX,KKMAX
      PARAMETER( IEETA1=20, IIMAX=20, KKMAX=20 )
      INTEGER IEEMAX,IMAX,KMAX
      REAL PROB
      DOUBLE PRECISION EPTAB
      COMMON /POPROB/ PROB(4,IEETA1,0:IIMAX,0:KKMAX),EPTAB(4,IEETA1),
     &                IEEMAX,IMAX,KMAX

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)

C  photon flux kinematics and cuts
      DOUBLE PRECISION ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                 YMIN1,YMAX1,YMIN2,YMAX2,
     &                 Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                 THMIN1,THMAX1,THMIN2,THMAX2
      INTEGER          ITAG1,ITAG2
      COMMON /POFCUT/ ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                YMIN1,YMAX1,YMIN2,YMAX2,
     &                Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                THMIN1,THMAX1,THMIN2,THMAX2,
     &                ITAG1,ITAG2

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  some hadron information, will be deleted in future versions
      INTEGER NFS
      DOUBLE PRECISION QMASS,BET,PCOUDI,PNORM,VALPRG
      COMMON /POHDRN/ QMASS(6),BET,PCOUDI,PNORM,VALPRG(2),NFS

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  parameters of the "simple" Vector Dominance Model
      DOUBLE PRECISION VMAS,GAMM,RMIN,RMAX,VMSL,VMFA
      COMMON /POSVDM/ VMAS(4),GAMM(4),RMIN(4),RMAX(4),VMSL(4),VMFA(4)

C  parameters for DGLAP backward evolution in ISR
      INTEGER NFSISR
      DOUBLE PRECISION Q2MISR,PMISR,ZMISR,AL2ISR
      COMMON /PODGL1/ Q2MISR(2),PMISR(2),ZMISR(2),AL2ISR(2),NFSISR

C  particles created by initial state evolution
      INTEGER MXISR1,MXISR2
      PARAMETER ( MXISR1 = 150, MXISR2 = 50 )
      INTEGER IFLISR,IPOISR,IMXISR
      DOUBLE PRECISION PHISR
      COMMON /POPISR/ IFLISR(2,MXISR1),PHISR(2,4,MXISR1),
     &                IPOISR(2,2,MXISR2),IMXISR(2)

C  names of hard scattering processes
      INTEGER MAX_PRO_1
      PARAMETER ( MAX_PRO_1 = 16 )
      CHARACTER*18 PROC
      COMMON /POHPRO/ PROC(0:MAX_PRO_1)

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)

C  interpolation tables for hard cross section and MC selection weights
      INTEGER MAX_TAB_E,MAX_TAB_Q2,MAX_PRO_TAB
      PARAMETER ( MAX_TAB_E = 20, MAX_TAB_Q2 = 10, MAX_PRO_TAB = 16 )
      INTEGER IH_Q2A_UP,IH_Q2B_UP,IH_ECM_UP
      DOUBLE PRECISION HFAC_TAB,HWGX_TAB,HSIG_TAB,HDPT_TAB,
     &  HQ2A_TAB,HQ2B_TAB,HECM_TAB
      COMMON /POHTAB/
     &  HFAC_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HWGX_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HSIG_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HDPT_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HQ2A_TAB(1:MAX_TAB_Q2,0:4),HQ2B_TAB(1:MAX_TAB_Q2,0:4),
     &  HECM_TAB(1:MAX_TAB_E,0:4),
     &  IH_Q2A_UP(0:4),IH_Q2B_UP(0:4),IH_ECM_UP(0:4)


C  initialize /POCONS/
      PI   = ATAN(1.D0)*4.D0
      PI2  = 2.D0*PI
      PI4  = 2.D0*PI2
C  GeV**-2 --> millibarn (multiply by GEV2MB to get mb as units)
      GEV2MB = 0.389365D0
C  precalculate quark charges
      DO I=1,6
        Q_CH(I) = DBLE(2-3*MOD(I,2))/3.D0
        Q_CH(-1) = -Q_CH(I)

        Q_CH2(I) = Q_CH(I)**2
        Q_CH2(-I) = Q_CH2(I)

        Q_CH4(I) = Q_CH2(I)**2
        Q_CH4(-I) = Q_CH4(I)
      ENDDO
      Q_CH(0)  = 0.D0
      Q_CH2(0) = 0.D0
      Q_CH4(0) = 0.D0

C  initialize /GLOCMS/
      ECM    = 50.D0
      PMASS(1) = 0.D0
      PVIRT(1) = 0.D0
      PMASS(2) = 0.D0
      PVIRT(2) = 0.D0
      IFPAP(1) = 22
      IFPAP(2) = 22
C  initialize /HADVAL/
      IHFLD(1,1) = 0
      IHFLD(1,2) = 0
      IHFLD(2,1) = 0
      IHFLD(2,2) = 0
      IHFLS(1) = 1
      IHFLS(2) = 1
C  initialize /MODELS/
      ISWMDL(1)  = 3
      MDLNA(1)  = 'AMPL MOD'
      ISWMDL(2)  = 1
      MDLNA(2)  = 'MIN-BIAS'
      ISWMDL(3)  = 1
      MDLNA(3)  = 'PTS DISH'
      ISWMDL(4)  = 1
      MDLNA(4)  = 'PTS DISP'
      ISWMDL(5)  = 2
      MDLNA(5)  = 'PTS ASSI'
      ISWMDL(6)  = 3
      MDLNA(6)  = 'HADRONIZ'
      ISWMDL(7)  = 2
      MDLNA(7)  = 'MASS COR'
      ISWMDL(8)  = 3
      MDLNA(8)  = 'PAR SHOW'
      ISWMDL(9)  = 0
      MDLNA(9)  = 'GLU SPLI'
      ISWMDL(10) = 2
      MDLNA(10) = 'VIRT PHO'
      ISWMDL(11) = 0
      MDLNA(11) = 'LARGE NC'
      ISWMDL(12) = 0
      MDLNA(12) = 'LIPA POM'
      ISWMDL(13) = 1
      MDLNA(13) = 'QELAS VM'
      ISWMDL(14) = 2
      MDLNA(14) = 'ENHA GRA'
      ISWMDL(15) = 4
      MDLNA(15) = 'MULT SCA'
      ISWMDL(16) = 4
      MDLNA(16) = 'MULT DIF'
      ISWMDL(17) = 4
      MDLNA(17) = 'MULT CDF'
      ISWMDL(18) = 0
      MDLNA(18) = 'BALAN PT'
      ISWMDL(19) = 1
      MDLNA(19) = 'POMV FLA'
      ISWMDL(20) = 0
      MDLNA(20) = 'SEA  FLA'
      ISWMDL(21) = 2
      MDLNA(21) = 'SPIN DEC'
      ISWMDL(22) = 1
      MDLNA(22) = 'DIF.MASS'
      ISWMDL(23) = 1
      MDLNA(23) = 'DIFF RES'
      ISWMDL(24) = 0
      MDLNA(24) = 'PTS HPOM'
      ISWMDL(25) = 0
      MDLNA(25) = 'POM CORR'
      ISWMDL(26) = 1
      MDLNA(26) = 'OVERLAP '
      ISWMDL(27) = 0
      MDLNA(27) = 'MUL R/AN'
      ISWMDL(28) = 1
      MDLNA(28) = 'SUR PROB'
      ISWMDL(29) = 1
      MDLNA(29) = 'PRIMO KT'
      ISWMDL(30) = 0
      MDLNA(30) = 'DIFF. CS'
      ISWMDL(31) = -9999
C  mass-independent sea flavour ratios (for low-mass strings)
      PARMDL(1)  = 0.425D0
      PARMDL(2)  = 0.425D0
      PARMDL(3)  = 0.15D0
      PARMDL(4)  = 0.D0
      PARMDL(5)  = 0.D0
      PARMDL(6)  = 0.D0
C  suppression by energy momentum conservation
      PARMDL(8)  = 9.D0
      PARMDL(9)  = 7.D0
C  VDM factors
      PARMDL(10) = 0.866D0
      PARMDL(11) = 0.288D0
      PARMDL(12) = 0.288D0
      PARMDL(13) = 0.288D0
      PARMDL(14) = 0.866D0
      PARMDL(15) = 0.288D0
      PARMDL(16) = 0.288D0
      PARMDL(17) = 0.288D0
      PARMDL(18) = 0.D0
C  lower energy limit for initialization
      PARMDL(19) = 5.D0
C  soft pt for hard scattering remnants
      PARMDL(20) = 5.D0
C  low energy beta of soft pt distribution 1
      PARMDL(21) = 4.5D0
C  high energy beta of soft pt distribution 1
      PARMDL(22) = 3.0D0
C  low energy beta of soft pt distribution 0
      PARMDL(23) = 2.5D0
C  high energy beta of soft pt distribution 0
      PARMDL(24) = 0.4D0
C  effective quark mass in photon wave function
      PARMDL(25) = 0.2D0
C  normalization of unevolved Pomeron PDFs
      PARMDL(26) = 0.3D0
C  effective VDM parameters for Q**2 dependence of cross section
      PARMDL(27) = 0.65D0
      PARMDL(28) = 0.08D0
      PARMDL(29) = 0.05D0
      PARMDL(30) = 0.22D0
      PARMDL(31) = 0.589824D0
      PARMDL(32) = 0.609961D0
      PARMDL(33) = 1.038361D0
      PARMDL(34) = 1.96D0
C  Q**2 suppression of multiple interactions
      PARMDL(35) = 0.59D0
C  pt cutoff defaults
      PARMDL(36) = 2.5D0
      PARMDL(37) = 2.5D0
      PARMDL(38) = 2.5D0
      PARMDL(39) = 2.5D0
C  enhancement factor for diffractive cross sections
      PARMDL(40) = 1.D0
      PARMDL(41) = 1.D0
      PARMDL(42) = 1.D0
**sr
*  extra factor multiplying difference between Goulianos and PHOJET-
*  diff. cross sections
      PARMDL(200) = 0.6D0
**
C  mass in soft pt distribution
      PARMDL(43) = 0.D0
C  maximum of x allowed for leading particle
      PARMDL(44) = 0.9D0
C  max. mass sampled in diffraction
      PARMDL(45) = SQRT(0.4D0)
C  mass threshold in diffraction (2pi mass)
      PARMDL(46) = 0.3D0
C  regularization of slope parameter in diffraction
      PARMDL(47) = 4.D0
C  renormalized intercept for enhanced graphs
      PARMDL(48) = 1.08D0
C  coherence constraint for diff. cross sections
      PARMDL(49) = SQRT(0.05D0)
C  exponents of x distributions
C  baryon
      PARMDL(50) = 1.5D0
      PARMDL(51) = -0.5D0
      PARMDL(52) = -0.99D0
      PARMDL(53) = -0.99D0
C  meson (non-strangeness part)
      PARMDL(54) = -0.5D0
      PARMDL(55) = -0.5D0
      PARMDL(56) = -0.99D0
      PARMDL(57) = -0.99D0
C  meson (strangeness part)
      PARMDL(58) = -0.2D0
      PARMDL(59) = -0.2D0
      PARMDL(60) = -0.99D0
      PARMDL(61) = -0.99D0
C  particle remnant (no valence quarks)
      PARMDL(62) = -0.5D0
      PARMDL(63) = -0.5D0
      PARMDL(64) = -0.99D0
      PARMDL(65) = -0.99D0
C  ratio beetween triple-pomeron/reggeon couplings grrp/gppp
      PARMDL(66) = 10.D0
C  ratio beetween triple-pomeron/reggeon couplings gppr/gppp
      PARMDL(67) = 10.D0
C  min. abs(t) in diffraction
      PARMDL(68) = 0.D0
C  max. abs(t) in diffraction
      PARMDL(69) = 10.D0
C  min. mass for elastic pomerons in central diffraction
      PARMDL(70) = 2.D0
C  min. mass of diffractive blob in central diffraction
      PARMDL(71) = 2.D0
C  min. Feynman x cut in central diffraction
      PARMDL(72) = 0.D0
C  direct pomeron coupling
      PARMDL(74) = 0.D0
C  relative deviation allowed for energy-momentum conservation
C  energy-momentum relative deviation
      PARMDL(75) = 0.01D0
C  transverse momentum deviation
      PARMDL(76) = 0.01D0
C  couplings for unitarization in diffraction
C  non-unitarized pomeron coupling (sqrt(mb))
      PARMDL(77)  = 3.D0
C  rescaling factor for pomeron PDF
      PARMDL(78)  = 3.D0
C  coupling probabilities
      PARMDL(79)  = 1.D0
      PARMDL(80)  = 0.D0
C  scales to calculate alpha-s of matrix element
      PARMDL(81) = 1.D0
      PARMDL(82) = 1.D0
      PARMDL(83) = 1.D0
C  scales to calculate alpha-s of initial state radiation
      PARMDL(84) = 1.D0
      PARMDL(85) = 1.D0
      PARMDL(86) = 1.D0
C  scales to calculate alpha-s of final state radiation
      PARMDL(87) = 1.D0
      PARMDL(88) = 1.D0
      PARMDL(89) = 1.D0
C  scales to calculate PDFs
      PARMDL(90) = 1.D0
      PARMDL(91) = 1.D0
      PARMDL(92) = 1.D0
C  scale for ISR starting virtuality
      PARMDL(93) = 1.D0
C  min. virtuality to generate time-like showers in ISR
      PARMDL(94) = 2.D0
C  factor to scale the max. allowed time-like parton shower virtuality
      PARMDL(95) = 4.D0
C  max. transverse momentum for primordial kt
      PARMDL(100) = 2.D0
C  weight factors for pt-distribution
      PARMDL(101) = 2.D0
      PARMDL(102) = 2.D0
      PARMDL(103) = 4.D0
      PARMDL(104) = 2.D0
      PARMDL(105) = 6.D0
      PARMDL(106) = 4.D0
C
*     PARMDL(110-125)  reserved for hard scattering
C  currently chosen scales for hard scattering
      DO 10 I=1,16
        PARMDL(109+I) = 0.D0
 10   CONTINUE
C  virtuality cutoff in initial state evolution
      PARMDL(126) = PARMDL(36)**2
      PARMDL(127) = PARMDL(37)**2
      PARMDL(128) = PARMDL(38)**2
      PARMDL(129) = PARMDL(39)**2
C  virtuality cutoff for direct contribution to photon PDF
      PARMDL(130) = 1.D30
      PARMDL(131) = 1.D30
      PARMDL(132) = 1.D30
      PARMDL(133) = 1.D30
C  fraction of events without popcorn
      PARMDL(134) = -1.D0
C  fraction of diquarks with spin 1 (relative to sum of spin 1 and 0)
      PARMDL(135) = 0.5D0
C  soft color re-connection (fraction)
C  g g final state
      PARMDL(140) = 1.D0/64.D0
C  g q final state
      PARMDL(141) = 1.D0/24.D0
C  q q final state
      PARMDL(142) = 1.D0/9.D0
C  effective scale in Drees-Godbole like suppresion in photon PDF
      PARMDL(144) = 0.766D0**2
C  QCD scales (if PDF scales are not used, 4 active flavours)
      PARMDL(145) = 0.2D0**2
      PARMDL(146) = 0.2D0**2
      PARMDL(147) = 0.2D0**2
C  threshold scales for variable flavour calculation (GeV**2)
      PARMDL(148) = 1.5D0**2
      PARMDL(149) = 4.5D0**2
      PARMDL(150) = 175.D0**2
C  constituent quark masses
      PARMDL(151) = 0.3D0
      PARMDL(152) = 0.3D0
      PARMDL(153) = 0.5D0
      PARMDL(154) = 1.6D0
      PARMDL(155) = 5.D0
      PARMDL(156) = 174.D0
C  min. masses of valence quark
      PARMDL(157) = 0.3D0
C  min. masses of valence diquark
      PARMDL(158) = 0.8D0
C  min. mass of sea quark
      PARMDL(159) = 0.D0
C  suppression of strange quarks as photon valences
      PARMDL(160) = 0.2D0
C  min. masses for strings (used in PHO_SOFTXX)
      PARMDL(161) = 1.D0
      PARMDL(162) = 1.D0
      PARMDL(163) = 1.D0
      PARMDL(164) = 1.D0
C  min. momentum fraction for soft processes
      PARMDL(165) = 0.3D0
C  min. phase space for x-sampling
      PARMDL(166) = 0.135D0
C  Ross-Stodolsky exponent
      PARMDL(170) = 4.2D0
C  cutoff on photon-pomeron invariant mass in hadron-hadron collisions
      PARMDL(175) = 2.D0
C  complex amplitudes, eikonal functions
      IPAMDL(1)  = 0
C  allow for Reggeon cuts
      IPAMDL(2)  = 1
C  decay of hadron resonances in diffraction (0 iso, 1 trans, 2 long)
      IPAMDL(3)  = 0
C  polarization of photon resonances (0 none, 1 trans, 2 long)
      IPAMDL(4)  = 1
C  pt of valence partons
      IPAMDL(5)  = 1
C  pt of hard scattering remnant
      IPAMDL(6)  = 2
C  running cutoff for hard scattering
      IPAMDL(7)  = 1
C  intercept used for the calculation of enhanced graphs
      IPAMDL(8)  = 1
C  effective slope of hard scattering amplitde
      IPAMDL(9)  = 1
C  mass dependence of slope parameters
      IPAMDL(10) = 0
C  lepton-photon vertex 1
      IPAMDL(11) = 0
C  lepton-photon vertex 2
      IPAMDL(12) = 0
C  call by DTUNUC
      IPAMDL(13) = 0
C  method to sample x distributions
      IPAMDL(14) = 3
C  energy-momentum check
      IPAMDL(15) = 1
C  phase space correction for DTUNUC interface
      IPAMDL(16) = 1
C  fragment strings from projectile/target/central diff. separately
      IPAMDL(17) = 1
C  method to construct strings for hard interactions
      IPAMDL(18) = 1
C  method to construct strings for soft sea (pomeron cuts)
      IPAMDL(19) = 0
C  method to construct strings in pomeron interactions
      IPAMDL(20) = 0
C  soft color re-connection
      IPAMDL(21) = 0
C  resummation of triple- and loop-Pomeron
      IPAMDL(24) = 1
C  resummation of X iterated triple-Pomeron
      IPAMDL(25) = 1
C  dimension of interpolation table for weights in hard scattering
      IPAMDL(30) = MAX_TAB_E
C  dimension of interpolation table for pomeron cut distribution
      IPAMDL(31) = IEETA1
C  number of cut soft pomerons (restriction by field dimension)
      IPAMDL(32) = IIMAX
C  number of cut hard pomerons (restriction by field dimension)
      IPAMDL(33) = KKMAX
C  tau pair production in direct photon-photon collisions
      IPAMDL(64) = 0
C  currently chosen scales for hard scattering
C  ATTENTION:   IPAMDL(65-80)  reserved for hard scattering!
      DO 15 I=1,16
        IPAMDL(64+I) = -99999
 15   CONTINUE
C  scales to calculate alpha-s of matrix element
      IPAMDL(81) = 1
      IPAMDL(82) = 1
      IPAMDL(83) = 1
C  scales to calculate alpha-s of initial state radiation
      IPAMDL(84) = 1
      IPAMDL(85) = 1
      IPAMDL(86) = 1
C  scales to calculate alpha-s of final state radiation
      IPAMDL(87) = 1
      IPAMDL(88) = 1
      IPAMDL(89) = 1
C  scales to calculate PDFs
      IPAMDL(90) = 1
      IPAMDL(91) = 1
      IPAMDL(92) = 1
C  where to get the parameter sets from
      IPAMDL(99) = 1
C  program PHO_ABORT for fatal errors (simulation of division by zero)
      IPAMDL(100) = 0
C  initial state parton showers for all / hardest interaction(s)
      IPAMDL(101) = 1
C  final state parton showers for all / hardest interaction(s)
      IPAMDL(102) = 1
C  initial virtuality for ISR generation
      IPAMDL(109) = 1
C  qqbar-gamma coupling in initial state showers
      IPAMDL(110) = 1
C  generation of time-like showers during ISR
      IPAMDL(111) = 1
C  reweighting of multiple soft contributions for virtual photons
      IPAMDL(114) = 1
C  reweighting / use photon virtuality in photon PDF calculations
      IPAMDL(115) = 0
C  use full QPM model incl. interference terms (direct part in gam-gam)
      IPAMDL(116) = 0
C  matching sigma_tot to F2 as given by parton density at high Q2
      IPAMDL(117) = 1
C  use virtuality of target in F2 calculations (two-gamma only)
      IPAMDL(118) = 1
C  calculation of alpha_em
      IPAMDL(120) = 1
C  strict pt cutoff for gamma-gamma events
      IPAMDL(121) = 0
C  photon virtuality sampled in photon flux approximations
      IPAMDL(174) = 1
C  photon-pomeron: 0,1,2: both,left,right photon emission
      IPAMDL(175) = 0
C  keep full history information in PHOJET-JETSET interface
      IPAMDL(178) = 1
C  max. number of conservation law violations allowed in one run
      IPAMDL(179) = 20
C  selection of soft X values
C  max. iteration number in PHO_SELSXS
      IPAMDL(180) = 50
C  max. iteration number in PHO_SELSXR
      IPAMDL(181) = 200
C  max. iteration number in PHO_SELSX2
      IPAMDL(182) = 100
C  max. iteration number in PHO_SELSXI
      IPAMDL(183) = 50

C  initialize /PROBAB/
      IEEMAX = IEETA1
      IMAX   = IIMAX
      KMAX   = KKMAX

      DO 20 I=1,30
        PARMDL(300+I) = -100000.D0
 20   CONTINUE
C  initialize /POHDRN/
      QMASS(1) =  PARMDL(151)
      QMASS(2) =  PARMDL(152)
      QMASS(3) =  PARMDL(153)
      QMASS(4) =  PARMDL(154)
      QMASS(5) =  PARMDL(155)
      QMASS(6) =  PARMDL(156)
      BET      = 8.D0
      PCOUDI   = 0.D0
      VALPRG(1) = 1.D0
      VALPRG(2) = 1.D0
C  number of light flavours (quarks treated as massless)
      NFS      = 4
C  initialize /POCUT1/
      PTCUT(1) = PARMDL(36)
      PTCUT(2) = PARMDL(37)
      PTCUT(3) = PARMDL(38)
      PTCUT(4) = PARMDL(39)
      PSOMIN = 0.D0
      XSOMIN = 0.D0
C  initialize /POHAPA/
      NFBETA  = 4
      NF      = 4
      BQCD(1) = PI4/(11.D0-(2.D0/3.D0)*3)
      BQCD(2) = PI4/(11.D0-(2.D0/3.D0)*4)
      BQCD(3) = PI4/(11.D0-(2.D0/3.D0)*5)
      BQCD(4) = PI4/(11.D0-(2.D0/3.D0)*6)
C  initialize /POGAUP/
      NGAUP1 = 12
      NGAUP2 = 12
      NGAUET = 16
      NGAUIN = 12
      NGAUSO = 96
C  initialize //
      DO 30 I=1,100
        IDEB(I) = 0
 30   CONTINUE
C  initialize /PROCES/
      DO 35 I=1,11
        IPRON(I,1) = 1
 35   CONTINUE
      DO 36 K=2,4
        DO 37 I=2,11
          IPRON(I,K) = 0
 37     CONTINUE
        IPRON(1,K) = 1
        IPRON(8,K) = 1
 36   CONTINUE
C  initialize /POSVDM/
      TWOPIM = 0.28D0
      RMIN(1) = 0.285D0
      RMIN(2) = 0.45D0
      RMIN(3) = 1.D0
      RMIN(4) = TWOPIM
      VMAS(1) = 0.770D0
      VMAS(2) = 0.787D0
      VMAS(3) = 1.02D0
      VMAS(4) = TWOPIM
      GAMM(1) = 0.155D0
      GAMM(2) = 0.01D0
      GAMM(3) = 0.0045D0
      GAMM(4) = 1.D0
      RMAX(1) = VMAS(1)+TWOPIM
      RMAX(2) = VMAS(2)+TWOPIM
      RMAX(3) = VMAS(3)+TWOPIM
      RMAX(4) = VMAS(1)+TWOPIM
      VMSL(1) = 11.D0
      VMSL(2) = 10.D0
      VMSL(3) = 6.D0
      VMSL(4) = 4.D0
      VMFA(1) = 0.0033D0
      VMFA(2) = 0.00036D0
      VMFA(3) = 0.0002D0
      VMFA(4) = 0.0002D0
C  initialize /PODGL1/
      Q2MISR(1) = PARMDL(36)**2
      Q2MISR(2) = PARMDL(36)**2
      PMISR(1) = 1.D0
      PMISR(2) = 1.D0
      ZMISR(1) = 0.001D0
      ZMISR(2) = 0.001D0
      AL2ISR(1) = 0.046D0
      AL2ISR(2) = 0.046D0
      NFSISR  = 4
C  initialize /POPISR/
      DO 40 I=1,50
        IPOISR(1,2,I) = 0
        IPOISR(2,2,I) = 0
 40   CONTINUE
C  initialize /POHPRO/
      PROC(0) = 'SUM OVER PROCESSES'
      PROC(1) = 'G  +G  --> G  +G  '
      PROC(2) = 'Q  +QB --> G  +G  '
      PROC(3) = 'G  +Q  --> G  +Q  '
      PROC(4) = 'G  +G  --> Q  +QB '
      PROC(5) = 'Q  +QB --> Q  +QB '
      PROC(6) = 'Q  +QB --> QP +QBP'
      PROC(7) = 'Q  +Q  --> Q  +Q  '
      PROC(8) = 'Q  +QP --> Q  +QP '
      PROC(9) = 'RESOLVED PROCESSES'
      PROC(10) = 'GAM+Q  --> G  +Q  '
      PROC(11) = 'GAM+G  --> Q  +QB '
      PROC(12) = 'Q  +GAM--> G  +Q  '
      PROC(13) = 'G  +GAM--> Q  +QB '
      PROC(14) = 'GAM+GAM--> Q  +QB '
      PROC(15) = 'DIRECT PROCESSES  '
      PROC(16) = 'GAM+GAM--> L+ +L- '

C  initialize /POHRCS/
      DO M=1,MAX_PRO_2
        HWGX(M) = 0.D0
        HSIG(M) = 0.D0
        HDPT(M) = 0.D0
      ENDDO
      DO I=0,4
        DO M=-1,MAX_PRO_2
C  switch all hard subprocesses on
          MH_PRO_ON(M,I) = 1
C  reset all counters
          MH_TRIED(M,I) = 0
          MH_ACC_1(M,I) = 0
          MH_ACC_2(M,I) = 0
        ENDDO
        MH_PRO_ON(16,I) = 0
      ENDDO

C  initialize /POHTAB/
      DO I=0,4
        IH_ECM_UP(I) = 0
        IH_Q2A_UP(I) = 0
        IH_Q2B_UP(I) = 0
        HECM_TAB(1,I) = 0.D0
      ENDDO
      HECM_LAST = 0.D0
      IHA_LAST = 0.D0
      IHB_LAST = 0.D0

C  initialize /POFSRC/
      IGHEL(1) = -1
      IGHEL(2) = -1
C  initialize /LEPCUT/
      ECMIN = 5.D0
      ECMAX = 1.D+30
      EEMIN1 = 1.D0
      EEMIN2 = 1.D0
      YMAX1 = -1.D0
      YMAX2 = -1.D0
      THMIN1 = 0.D0
      THMAX1 = PI
      THMIN2 = 0.D0
      THMAX2 = PI
      ITAG1 = 1
      ITAG2 = 1
C  initialize /POWGHT/
      DO 70 I=1,20
        HSWCUT(I) = 0.D0
        ISWCUT(I) = 0
 70   CONTINUE
      EVWGHT(1) = 1.D0
      IVWGHT(1) = 0
      SIGGEN(1) = 0.D0
      SIGGEN(2) = 0.D0
      SIGGEN(3) = 0.D0
      SIGGEN(4) = 0.D0

      END



CDECK  ID>, PHO_PARDAT
      SUBROUTINE PHO_PARDAT
C***********************************************************************
C
C     particle data (based on 1996 PDG naming scheme and data tables)
C
C***********************************************************************

      IMPLICIT NONE

      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  particle ID translation table
      INTEGER         ID_PDG_LIST,ID_LIST,ID_PDG_MAX
      CHARACTER*12    NAME_LIST
      COMMON /POPAR1/ ID_PDG_LIST(300),ID_LIST(577),NAME_LIST(300),
     &                ID_PDG_MAX

C  general particle data
      DOUBLE PRECISION XM_LIST,TAU_LIST,GAM_LIST,
     &  XM_PSM2_LIST,XM_VEM2_LIST,XM_B82_LIST,XM_B102_LIST,
     &  XM_BB82_LIST,XM_BB102_LIST
      INTEGER          ICH3_LIST,IBA3_LIST,IQ_LIST,
     &                 ID_PSM_LIST,ID_VEM_LIST,ID_B8_LIST,ID_B10_LIST
      COMMON /POPAR2/ XM_LIST(300),TAU_LIST(300),GAM_LIST(300),
     &  XM_PSM2_LIST(6,6),XM_VEM2_LIST(6,6),
     &  XM_B82_LIST(6,6,6),XM_B102_LIST(6,6,6),
     &  XM_BB82_LIST(6,6,6,6),XM_BB102_LIST(6,6,6,6),
     &  ICH3_LIST(300),IBA3_LIST(300),IQ_LIST(3,300),
     &  ID_PSM_LIST(6,6),ID_VEM_LIST(6,6),
     &  ID_B8_LIST(6,6,6),ID_B10_LIST(6,6,6)

C  particle decay data
      DOUBLE PRECISION WG_SEC_LIST
      INTEGER          IDEC_LIST,ISEC_LIST
      COMMON /POPAR3/ WG_SEC_LIST(500),IDEC_LIST(3,300),
     &  ISEC_LIST(3,500)



C  external functions

      INTEGER IPHO_PDG2ID
      DOUBLE PRECISION PHO_PMASS

C  local variables for storing data tables

      INTEGER NUMBER,ICH3,IBA3,IQ_LINEAR,IDEC_LINEAR,ISEC_LINEAR,
     &  ID_PSM_LINEAR,ID_VEM_LINEAR,ID_B8_LINEAR,ID_B10_LINEAR

      DIMENSION NUMBER(300),ICH3(300),IBA3(300),IQ_LINEAR(900),
     &  IDEC_LINEAR(900),ISEC_LINEAR(900),ID_PSM_LINEAR(36),
     &  ID_VEM_LINEAR(36),ID_B8_LINEAR(216),ID_B10_LINEAR(216)

      DOUBLE PRECISION XMASS,GAMMA,WG_CHAN
      DIMENSION XMASS(300),GAMMA(300),WG_CHAN(300)

      CHARACTER*12 NAME
      DIMENSION NAME(300)

      INTEGER I,I1,I2,II,J,JJ,K,L,ICHAN,I_TAB_MAX,K8,K10,L8,L10
      DOUBLE PRECISION AM1,AM2,AM2P,AM2V,AM82,AM102,AMM

      INTEGER ITMP


      DATA I_TAB_MAX /260/

      DATA (NUMBER(K),K=    1,  171) /
     &     1,     2,     3,     4,     5,     6,  1103,  2101,  2103,
     &  2203,  3101,  3103,  3201,  3203,  3303,  4101,  4103,  4201,
     &  4203,  4301,  4303,  4403,    81,    82,    90,    91,    92,
     &   110,   990,    21,    22,    24,    23,    11,    13,    15,
     &    12,    14,    16,   211,   111,   221,   113,   213,   223,
     &   331, 10221, 10111, 10211,   333, 10223, 10113, 10213, 20113,
     & 20213,   225, 20223, 20221, 20111, 20211,   115,   215, 30223,
     & 50223, 40113, 40213, 50221,   335, 60223,   227, 10115, 10215,
     & 10333,   117,   217, 30113, 30213, 60221,   337, 20225,   229,
     & 30225, 40225,   321,   311,   310,   130,   323,   313, 10313,
     & 10323, 20313, 20323, 30313, 30323, 10311, 10321,   325,   315,
     & 40313, 40323, 10315, 10325,   317,   327, 20315, 20325,   319,
     &   329,   411,   421,   423,   413, 10423,   425,   415,   431,
     &   433, 10433,   521,   511,   513,   523,   531,   441,   443,
     & 10441, 10443,   445, 20443, 30443, 40443, 50443, 60443,   553,
     &   551, 10553,   555, 20553, 10551, 70553, 10555, 30553, 40553,
     & 50553, 60553,  2212,  2112, 12112, 12212,  1214,  2124, 22112,
     & 22212, 32112, 32212,  2116,  2216, 12116, 12216, 21214, 22124,
     & 42112, 42212, 31214, 32124,  1218,  2128,  1114,  2114,  2214/
      DATA (NUMBER(K),K=  172,  260) /
     &  2224, 31114, 32114, 32214, 32224,  1112,  1212,  2122,  2222,
     & 11114, 12114, 12214, 12224,  1116,  1216,  2126,  2226, 21112,
     & 21212, 22122, 22222, 21114, 22114, 22214, 22224, 11116, 11216,
     & 12126, 12226,  1118,  2118,  2218,  2228,  3122, 13122,  3124,
     & 23122, 33122, 13124, 43122, 53122,  3126, 13126, 23124,  3128,
     & 23126,  3222,  3212,  3112,  3224,  3214,  3114, 13112, 13212,
     & 13222, 13114, 13214, 13224, 23112, 23212, 23222,  3116,  3216,
     &  3226, 13116, 13216, 13226, 23114, 23214, 23224,  3118,  3218,
     &  3228,  3322,  3312,  3324,  3314, 13314, 13324,  3334,  4122,
     & 14122,  4222,  4212,  4112,  4322,  4312,  4332,  5122/
      DATA (NAME(K),K=    1,   76) /
     &'D           ','U           ','S           ','C           ',
     &'B           ','T           ','(DD)_1      ','(UD)_0      ',
     &'(UD)_1      ','(UU)_1      ','(SD)_0      ','(SD)_1      ',
     &'(SU)_0      ','(SU)_1      ','(SS)_1      ','(CD)_0      ',
     &'(CD)_1      ','(CU)_0      ','(CU)_1      ','(CS)_0      ',
     &'(CS)_1      ','(CC)_1      ','REMNANT 1   ','REMNANT 2   ',
     &'STRING      ','MOD. STRING ','COLL. STRING','REGGEON     ',
     &'POMERON     ','GLUON       ','GAMMA       ','W           ',
     &'Z           ','E           ','MU          ','TAU         ',
     &'NU(E)       ','NU(MU)      ','NU(TAU)     ','PI          ',
     &'PI          ','ETA         ','RHO(770)    ','RHO(770)    ',
     &'OME(782)    ','ETAP(958)   ','F(0)(980)   ','A(0)(980)   ',
     &'A(0)(980)   ','PHI(1020)   ','H(1)(1170)  ','B(1)(1235)  ',
     &'B(1)(1235)  ','A(1)(1260)  ','A(1)(1260)  ','F(2)(1270)  ',
     &'F(1)(1285)  ','ETA(1295)   ','PI(1300)    ','PI(1300)    ',
     &'A(2)(1320)  ','A(2)(1320)  ','F(1)(1420)  ','OME(1420)   ',
     &'RHO(1450)   ','RHO(1450)   ','F(0)(1500)  ','F(2)P(1525) ',
     &'OME(1600)   ','OME(3)(1670)','PI(2)(1670) ','PI(2)(1670) ',
     &'PHI(1680)   ','RHO(3)(1690)','RHO(3)(1690)','RHO(1700)   '/
      DATA (NAME(K),K=   77,  152) /
     &'RHO(1700)   ','F(J)(1710)  ','PHI(3)(1850)','F(2)(2010)  ',
     &'F(4)(2050)  ','F(2)(2300)  ','F(2)(2340)  ','K           ',
     &'K           ','K(S)        ','K(L)        ','K*(892)     ',
     &'K*(892)     ','K(1)(1270)  ','K(1)(1270)  ','K(1)(1400)  ',
     &'K(1)(1400)  ','K*(1410)    ','K*(1410)    ','K(0)*(1430) ',
     &'K(0)*(1430) ','K(2)*(1430) ','K(2)*(1430) ','K*(1680)    ',
     &'K*(1680)    ','K(2)(1770)  ','K(2)(1770)  ','K(3)*(1780) ',
     &'K(3)*(1780) ','K(2)(1820)  ','K(2)(1820)  ','K(4)*(2045) ',
     &'K(4)*(2045) ','D           ','D           ','D*(2007)    ',
     &'D*(2010)    ','D(1)(2420)  ','D(2)*(2460) ','D(2)*(2460) ',
     &'D(S)        ','D(S)*       ','D(S1)(2536) ','B           ',
     &'B           ','B*          ','B*          ','B(S)        ',
     &'ETA(C)(1S)  ','J/PSI(1S)   ','CHI(C0)(1P) ','CHI(C1)(1P) ',
     &'CHI(C2)(1P) ','PSI(2S)     ','PSI(3770)   ','PSI(4040)   ',
     &'PSI(4160)   ','PSI(4415)   ','UPS(1S)     ','CHI(B0)(1P) ',
     &'CHI(B1)(1P) ','CHI(B2)(1P) ','UPS(2S)     ','CHI(B0)(2P) ',
     &'CHI(B1)(2P) ','CHI(B2)(2P) ','UPS(3S)     ','UPS(4S)     ',
     &'UPS(10860)  ','UPS(11020)  ','P           ','N           ',
     &'N(1440)     ','N(1440)     ','N(1520)     ','N(1520)     '/
      DATA (NAME(K),K=  153,  228) /
     &'N(1535)     ','N(1535)     ','N(1650)     ','N(1650)     ',
     &'N(1675)     ','N(1675)     ','N(1680)     ','N(1680)     ',
     &'N(1700)     ','N(1700)     ','N(1710)     ','N(1710)     ',
     &'N(1720)     ','N(1720)     ','N(2190)     ','N(2190)     ',
     &'DEL(1232)   ','DEL(1232)   ','DEL(1232)   ','DEL(1232)   ',
     &'DEL(1600)   ','DEL(1600)   ','DEL(1600)   ','DEL(1600)   ',
     &'DEL(1620)   ','DEL(1620)   ','DEL(1620)   ','DEL(1620)   ',
     &'DEL(1700)   ','DEL(1700)   ','DEL(1700)   ','DEL(1700)   ',
     &'DEL(1905)   ','DEL(1905)   ','DEL(1905)   ','DEL(1905)   ',
     &'DEL(1910)   ','DEL(1910)   ','DEL(1910)   ','DEL(1910)   ',
     &'DEL(1920)   ','DEL(1920)   ','DEL(1920)   ','DEL(1920)   ',
     &'DEL(1930)   ','DEL(1930)   ','DEL(1930)   ','DEL(1930)   ',
     &'DEL(1950)   ','DEL(1950)   ','DEL(1950)   ','DEL(1950)   ',
     &'LAMBDA      ','LAM(1405)   ','LAM(1520)   ','LAM(1600)   ',
     &'LAM(1670)   ','LAM(1690)   ','LAM(1800)   ','LAM(1810)   ',
     &'LAM(1820)   ','LAM(1830)   ','LAM(1890)   ','LAM(2100)   ',
     &'LAM(2110)   ','SIGMA       ','SIGMA       ','SIGMA       ',
     &'SIG(1385)   ','SIG(1385)   ','SIG(1385)   ','SIG(1660)   ',
     &'SIG(1660)   ','SIG(1660)   ','SIG(1670)   ','SIG(1670)   '/
      DATA (NAME(K),K=  229,  260) /
     &'SIG(1670)   ','SIG(1750)   ','SIG(1750)   ','SIG(1750)   ',
     &'SIG(1775)   ','SIG(1775)   ','SIG(1775)   ','SIG(1915)   ',
     &'SIG(1915)   ','SIG(1915)   ','SIG(1940)   ','SIG(1940)   ',
     &'SIG(1940)   ','SIG(2030)   ','SIG(2030)   ','SIG(2030)   ',
     &'XI          ','XI          ','XI(1530)    ','XI(1530)    ',
     &'XI(1820)    ','XI(1820)    ','OMEGA       ','LAM(C)      ',
     &'LAM(C)(2593)','SIG(C)(2455)','SIG(C)(2455)','SIG(C)(2455)',
     &'XI(C)       ','XI(C)       ','OME(C)      ','LAM(B)      '/
      DATA (ICH3(K),K=    1,  260) /
     &-1, 2,-1, 2,-1, 2,-2, 1, 1, 4,-2,-2, 1, 1,-2, 1, 1, 4, 4, 1, 1, 4,
     & 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,-3,-3,-3, 0, 0, 0, 3, 0, 0, 0, 3,
     & 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 3,
     & 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3,
     & 0, 0, 3, 0, 3, 0, 3, 0, 3, 3, 0, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 3,
     & 0, 0, 3, 0, 0, 3, 3, 3, 3, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     & 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 3, 0, 3,
     & 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3,-3, 0, 3, 6,-3, 0, 3, 6,
     &-3, 0, 3, 6,-3, 0, 3, 6,-3, 0, 3, 6,-3, 0, 3, 6,-3, 0, 3, 6,-3, 0,
     & 3, 6,-3, 0, 3, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0,-3,
     & 3, 0,-3,-3, 0, 3,-3, 0, 3,-3, 0, 3,-3, 0, 3,-3, 0, 3,-3, 0, 3,-3,
     & 0, 3, 0,-3, 0,-3,-3, 0,-3, 3, 3, 6, 3, 0, 3, 0, 0, 0/
      DATA (IBA3(K),K=    1,  260) /
     &1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,
     &0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     &0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     &0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     &0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
     &3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
     &3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
     &3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3/
      DATA (IQ_LINEAR(K),K=    1,  418) /
     & 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 2,
     & 1, 0, 2, 1, 0, 2, 2, 0, 3, 1, 0, 3, 1, 0, 3, 2, 0, 3, 2, 0, 3, 3,
     & 0, 4, 1, 0, 4, 1, 0, 4, 2, 0, 4, 2, 0, 4, 3, 0, 4, 3, 0, 4, 4, 0,
     & 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     & 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     & 0, 0, 0, 0, 0, 0, 0, 2,-1, 0, 1,-1, 0, 2,-2, 0, 1,-1, 0, 2,-1, 0,
     & 2,-2, 0, 3,-3, 0, 2,-2, 0, 1,-1, 0, 2,-1, 0, 3,-3, 0, 2,-2, 0, 1,
     &-1, 0, 2,-1, 0, 1,-1, 0, 2, 1, 0, 2,-2, 0, 2,-2, 0, 2,-2, 0, 1,-1,
     & 0, 2,-1, 0, 1,-1, 0, 2,-1, 0, 2,-2, 0, 2,-2, 0, 1,-1, 0, 2,-1, 0,
     & 2,-2, 0, 3,-3, 0, 2,-2, 0, 2,-2, 0, 1,-1, 0, 2,-1, 0, 3,-3, 0, 1,
     &-1, 0, 2,-1, 0, 1,-1, 0, 2,-1, 0, 2,-2, 0, 3,-3, 0, 2,-2, 0, 2,-2,
     & 0, 2,-2, 0, 2,-2, 0, 2,-3, 0, 1,-3, 0, 1,-3, 0, 3,-1, 0, 2,-3, 0,
     & 1,-3, 0, 1,-3, 0, 2,-3, 0, 1,-3, 0, 2,-3, 0, 1,-3, 0, 2,-3, 0, 1,
     &-3, 0, 2,-3, 0, 2,-3, 0, 1,-3, 0, 1,-3, 0, 2,-3, 0, 1,-3, 0, 2,-3,
     & 0, 1,-3, 0, 2,-3, 0, 1,-3, 0, 2,-3, 0, 1,-3, 0, 2,-3, 0, 4,-1, 0,
     & 4,-2, 0, 4,-2, 0, 4,-1, 0, 4,-2, 0, 4,-2, 0, 4,-1, 0, 4,-3, 0, 4,
     &-3, 0, 4,-3, 0, 2,-5, 0, 1,-5, 0, 1,-5, 0, 2,-5, 0, 3,-5, 0, 4,-4,
     & 0, 4,-4, 0, 4,-4, 0, 4,-4, 0, 4,-4, 0, 4,-4, 0, 4,-4, 0, 4,-4, 0,
     & 4,-4, 0, 4,-4, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 5/
      DATA (IQ_LINEAR(K),K=  419,  780) /
     &-5, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 5,-5, 0, 2, 2,
     & 1, 2, 1, 1, 2, 1, 1, 2, 2, 1, 1, 2, 1, 2, 1, 2, 2, 1, 1, 2, 2, 1,
     & 2, 1, 1, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 1, 1, 2, 2, 1, 1, 2, 1, 2,
     & 1, 2, 2, 1, 1, 2, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1,
     & 1, 2, 1, 1, 2, 2, 1, 2, 2, 2, 1, 1, 1, 2, 1, 1, 2, 2, 1, 2, 2, 2,
     & 1, 1, 1, 1, 2, 1, 2, 1, 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 2, 2, 1, 2,
     & 2, 2, 1, 1, 1, 1, 2, 1, 2, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 1, 2, 1,
     & 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 2, 1, 1, 2, 2, 2, 1, 1, 1, 1, 2, 1,
     & 2, 1, 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 2, 2, 1, 2, 2, 2, 3, 1, 2, 3,
     & 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1,
     & 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 2, 2, 3, 2, 1, 3, 1, 1, 3,
     & 3, 2, 2, 3, 2, 1, 3, 1, 1, 3, 1, 1, 3, 2, 1, 3, 2, 2, 3, 1, 1, 3,
     & 2, 1, 3, 2, 2, 3, 1, 1, 3, 2, 1, 3, 2, 2, 3, 1, 1, 3, 2, 1, 3, 2,
     & 2, 3, 1, 1, 3, 2, 1, 3, 2, 2, 3, 1, 1, 3, 2, 1, 3, 2, 2, 3, 1, 1,
     & 3, 2, 1, 3, 2, 2, 2, 3, 3, 1, 3, 3, 2, 3, 3, 1, 3, 3, 3, 3, 1, 3,
     & 3, 2, 3, 3, 3, 2, 1, 4, 4, 1, 2, 2, 2, 4, 2, 1, 2, 1, 1, 4, 3, 2,
     & 2, 3, 1, 2, 3, 3, 4, 5, 1, 2/
      DATA (XMASS(K),K=    1,  114) /
     &3.0000E-01,3.0000E-01,3.5000E-01,1.4500E+00,4.5000E+00,1.7400E+02,
     &7.7133E-01,5.7933E-01,7.7133E-01,7.7133E-01,8.0473E-01,9.2953E-01,
     &8.0473E-01,9.2953E-01,1.0936E+00,1.9691E+00,2.0081E+00,1.9691E+00,
     &2.0081E+00,2.1543E+00,2.1797E+00,3.2753E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,8.0410E+01,9.1187E+01,5.1100E-04,1.0566E-01,1.7771E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,1.3957E-01,1.3498E-01,5.4730E-01,
     &7.7000E-01,7.7000E-01,7.8194E-01,9.5778E-01,9.8000E-01,9.8340E-01,
     &9.8340E-01,1.0194E+00,1.1700E+00,1.2295E+00,1.2295E+00,1.2300E+00,
     &1.2300E+00,1.2750E+00,1.2819E+00,1.2970E+00,1.3000E+00,1.3000E+00,
     &1.3181E+00,1.3181E+00,1.4262E+00,1.4190E+00,1.4650E+00,1.4650E+00,
     &1.5000E+00,1.5250E+00,1.6490E+00,1.6670E+00,1.6700E+00,1.6700E+00,
     &1.6800E+00,1.6910E+00,1.6910E+00,1.7000E+00,1.7000E+00,1.7120E+00,
     &1.8540E+00,2.0100E+00,2.0440E+00,2.2970E+00,2.3400E+00,4.9368E-01,
     &4.9767E-01,4.9767E-01,4.9767E-01,8.9166E-01,8.9610E-01,1.2720E+00,
     &1.2720E+00,1.4020E+00,1.4020E+00,1.4140E+00,1.4140E+00,1.4290E+00,
     &1.4290E+00,1.4256E+00,1.4324E+00,1.7170E+00,1.7170E+00,1.7730E+00,
     &1.7730E+00,1.7760E+00,1.7760E+00,1.8160E+00,1.8160E+00,2.0450E+00,
     &2.0450E+00,1.8693E+00,1.8646E+00,2.0067E+00,2.0100E+00,2.4222E+00/
      DATA (XMASS(K),K=  115,  228) /
     &2.4589E+00,2.4590E+00,1.9685E+00,2.1124E+00,2.5353E+00,5.2789E+00,
     &5.2792E+00,5.3249E+00,5.3249E+00,5.3693E+00,2.9798E+00,3.0969E+00,
     &3.4173E+00,3.5105E+00,3.5562E+00,3.6860E+00,3.7699E+00,4.0400E+00,
     &4.1590E+00,4.4150E+00,9.4604E+00,9.8598E+00,9.8919E+00,9.9132E+00,
     &1.0023E+01,1.0232E+01,1.0255E+01,1.0268E+01,1.0355E+01,1.0580E+01,
     &1.0865E+01,1.1019E+01,9.3827E-01,9.3957E-01,1.4400E+00,1.4400E+00,
     &1.5200E+00,1.5200E+00,1.5350E+00,1.5350E+00,1.6500E+00,1.6500E+00,
     &1.6750E+00,1.6750E+00,1.6800E+00,1.6800E+00,1.7000E+00,1.7000E+00,
     &1.7100E+00,1.7100E+00,1.7200E+00,1.7200E+00,2.1900E+00,2.1900E+00,
     &1.2320E+00,1.2320E+00,1.2320E+00,1.2320E+00,1.6000E+00,1.6000E+00,
     &1.6000E+00,1.6000E+00,1.6200E+00,1.6200E+00,1.6200E+00,1.6200E+00,
     &1.7000E+00,1.7000E+00,1.7000E+00,1.7000E+00,1.9050E+00,1.9050E+00,
     &1.9050E+00,1.9050E+00,1.9100E+00,1.9100E+00,1.9100E+00,1.9100E+00,
     &1.9200E+00,1.9200E+00,1.9200E+00,1.9200E+00,1.9300E+00,1.9300E+00,
     &1.9300E+00,1.9300E+00,1.9500E+00,1.9500E+00,1.9500E+00,1.9500E+00,
     &1.1157E+00,1.4070E+00,1.5195E+00,1.6000E+00,1.6700E+00,1.6900E+00,
     &1.8000E+00,1.8100E+00,1.8200E+00,1.8300E+00,1.8900E+00,2.1000E+00,
     &2.1100E+00,1.1894E+00,1.1926E+00,1.1974E+00,1.3828E+00,1.3837E+00,
     &1.3872E+00,1.6600E+00,1.6600E+00,1.6600E+00,1.6700E+00,1.6700E+00/
      DATA (XMASS(K),K=  229,  260) /
     &1.6700E+00,1.7500E+00,1.7500E+00,1.7500E+00,1.7750E+00,1.7750E+00,
     &1.7750E+00,1.9150E+00,1.9150E+00,1.9150E+00,1.9400E+00,1.9400E+00,
     &1.9400E+00,2.0300E+00,2.0300E+00,2.0300E+00,1.3149E+00,1.3213E+00,
     &1.5318E+00,1.5350E+00,1.8230E+00,1.8230E+00,1.6724E+00,2.2849E+00,
     &2.5939E+00,2.4528E+00,2.4536E+00,2.4522E+00,2.4656E+00,2.4703E+00,
     &2.7040E+00,5.6240E+00/
      DATA (GAMMA(K),K=    1,  114) /
     &8.0000E-01,8.0000E-01,8.0000E-01,8.0000E-01,8.0000E-01,8.0000E-01,
     &8.0000E-01,8.0000E-01,8.0000E-01,8.0000E-01,8.0000E-01,8.0000E-01,
     &8.0000E-01,8.0000E-01,8.0000E-01,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     &0.0000E+00,2.0600E+00,2.4900E+00,0.0000E+00,2.9959E-19,2.2700E-12,
     &0.0000E+00,0.0000E+00,0.0000E+00,2.5284E-17,7.8000E-09,1.1800E-06,
     &1.5070E-01,1.5070E-01,8.4100E-03,2.0300E-04,0.0000E+00,0.0000E+00,
     &0.0000E+00,4.4300E-03,3.6000E-01,1.4200E-01,1.4200E-01,0.0000E+00,
     &0.0000E+00,1.8550E-01,2.4000E-02,5.3000E-02,0.0000E+00,0.0000E+00,
     &1.0700E-01,1.0700E-01,5.5000E-02,1.7000E-01,3.1000E-01,3.1000E-01,
     &1.1200E-01,7.6000E-02,2.2000E-01,1.6800E-01,2.5800E-01,2.5800E-01,
     &1.5000E-01,1.6000E-01,1.6000E-01,2.4000E-01,2.4000E-01,1.3300E-01,
     &8.7000E-02,2.0000E-01,2.0800E-01,1.5000E-01,3.2000E-01,5.3140E-17,
     &0.0000E+00,7.3730E-15,1.2730E-17,5.0800E-02,5.0500E-02,9.0000E-02,
     &9.0000E-02,1.7400E-01,1.7400E-01,2.3200E-01,2.3200E-01,2.8700E-01,
     &2.8700E-01,9.8500E-02,1.0900E-01,3.2000E-01,3.2000E-01,1.8600E-01,
     &1.8600E-01,1.5900E-01,1.5900E-01,2.7600E-01,2.7600E-01,1.9800E-01,
     &1.9800E-01,6.2300E-13,1.5860E-12,5.0000E-03,2.0000E-03,1.8900E-02/
      DATA (GAMMA(K),K=  115,  228) /
     &2.3000E-02,2.5000E-02,1.4100E-12,2.0000E-03,0.0000E+00,3.9900E-13,
     &4.2200E-13,0.0000E+00,0.0000E+00,4.2700E-13,1.3200E-02,8.7000E-05,
     &1.4000E-02,8.8000E-04,2.0000E-03,2.7700E-04,2.3600E-02,5.2000E-02,
     &7.8000E-02,4.3000E-02,5.2500E-05,0.0000E+00,0.0000E+00,0.0000E+00,
     &4.4000E-05,0.0000E+00,0.0000E+00,0.0000E+00,2.6300E-05,1.0000E-02,
     &1.1000E-01,7.9000E-02,0.0000E+00,7.4240E-28,3.5000E-01,3.5000E-01,
     &1.2000E-01,1.2000E-01,1.5000E-01,1.5000E-01,1.5000E-01,1.5000E-01,
     &1.5000E-01,1.5000E-01,1.3000E-01,1.3000E-01,1.0000E-01,1.0000E-01,
     &1.0000E-01,1.0000E-01,1.5000E-01,1.5000E-01,4.5000E-01,4.5000E-01,
     &1.2000E-01,1.2000E-01,1.2000E-01,1.2000E-01,3.5000E-01,3.5000E-01,
     &3.5000E-01,3.5000E-01,1.5000E-01,1.5000E-01,1.5000E-01,1.5000E-01,
     &3.0000E-01,3.0000E-01,3.0000E-01,3.0000E-01,3.5000E-01,3.5000E-01,
     &3.5000E-01,3.5000E-01,2.5000E-01,2.5000E-01,2.5000E-01,2.5000E-01,
     &2.0000E-01,2.0000E-01,2.0000E-01,2.0000E-01,3.5000E-01,3.5000E-01,
     &3.5000E-01,3.5000E-01,3.0000E-01,3.0000E-01,3.0000E-01,3.0000E-01,
     &2.5010E-15,5.0000E-02,1.5600E-02,1.5000E-01,3.5000E-02,6.0000E-02,
     &3.0000E-01,1.5000E-01,8.0000E-02,9.5000E-02,1.0000E-01,2.0000E-01,
     &2.0000E-01,8.2400E-15,8.9000E-06,4.4500E-15,3.5800E-02,3.6000E-02,
     &3.9400E-02,1.0000E-01,1.0000E-01,1.0000E-01,6.0000E-02,6.0000E-02/
      DATA (GAMMA(K),K=  229,  260) /
     &6.0000E-02,9.0000E-02,9.0000E-02,9.0000E-02,1.2000E-01,1.2000E-01,
     &1.2000E-01,1.2000E-01,1.2000E-01,1.2000E-01,2.2000E-01,2.2000E-01,
     &2.2000E-01,1.8000E-01,1.8000E-01,1.8000E-01,2.2700E-15,4.0200E-15,
     &9.1000E-03,9.9000E-03,2.4000E-02,2.4000E-02,8.0100E-15,3.1900E-12,
     &3.6000E-03,0.0000E+00,0.0000E+00,0.0000E+00,1.8600E-12,6.7000E-12,
     &1.0200E-11,5.3100E-13/
      DATA (IDEC_LINEAR(K),K=    1,  304) /
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  3,  1,  1,  2,  2,  6,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  3,  7,  7,  3,  8,  9,  1, 10, 14,  1, 15,
     & 16,  1, 17, 17,  1, 18, 20,  1, 21, 24,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  1, 25, 29,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1, 30, 32,
     &  1, 33, 34,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1, 35, 37,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  1, 38, 39,  0,  0,  0,  0,  0,
     &  0,  1, 40, 40,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  3, 41, 46,  0,  0,  0,  3,
     & 47, 48,  3, 49, 52,  1, 53, 54,  1, 55, 56,  1, 57, 58,  1, 59,
     & 60,  0,  0,  0,  0,  0,  0,  1, 61, 68,  1, 69, 76,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0/
      DATA (IDEC_LINEAR(K),K=  305,  608) /
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  2, 77, 78,  2, 79, 82,  1, 83, 84,
     &  1, 85, 87,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2, 88, 90,  1,
     & 91, 92,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  2, 93, 95,  1, 96, 98,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  1, 99,101,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,102,102,  1,103,112,  1,
     &113,122,  0,  0,  0,  0,  0,  0,  1,123,129,  1,130,136,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  1,137,144,  1,145,152,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  1,153,153,  1,154,155,  1,156,
     &157,  1,158,158,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,159,162,  1,
     &163,169,  1,170,176,  1,177,180,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0/
      DATA (IDEC_LINEAR(K),K=  609,  780) /
     &  0,  0,  0,  0,  3,181,182,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,183,184,  3,185,
     &185,  3,186,186,  1,187,189,  1,190,192,  1,193,194,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,195,203,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  1,204,216,  0,  0,  0,  3,217,217,  3,
     &218,218,  1,219,220,  1,221,222,  0,  0,  0,  0,  0,  0,  2,223,
     &225,  2,226,239,  0,  0,  0,  2,240,240,  2,241,241,  2,242,242,
     &  2,243,246,  2,247,251,  2,252,255,  0,  0,  0/
      DATA (ISEC_LINEAR(K),K=    1,  152) /
     &     11,     12,    -12,     13,    -14,     16,     11,    -12,
     &     16,   -213,     16,      0,   -211,     16,      0,   -323,
     &     16,      0,    -13,     12,      0,     22,     22,      0,
     &     22,    -11,     11,     22,     22,      0,    111,     22,
     &     22,    111,    111,    111,    211,   -211,    111,    211,
     &   -211,     22,    211,   -211,      0,    111,    111,      0,
     &    211,    111,      0,    211,   -211,    111,    211,   -211,
     &      0,    111,     22,      0,    221,    211,   -211,    221,
     &    111,    111,    211,   -211,     22,     22,     22,      0,
     &    321,   -321,      0,    130,    310,      0,    113,    111,
     &      0,    211,   -211,    111,    221,     22,      0,    113,
     &    111,      0,   -213,    211,      0,    213,   -211,      0,
     &    211,   -211,      0,    111,    111,      0,    113,    111,
     &      0,   -213,    211,      0,    213,   -211,      0,    311,
     &   -313,      0,   -311,    313,      0,    113,    211,   -211,
     &    -13,     12,      0,    211,    111,      0,    211,    211,
     &   -211,    211,    111,    111,    -13,    111,     12,    -11,
     &    111,     12,    211,   -211,      0,    111,    111,      0,
     &    111,    111,    111,    211,   -211,    111,    211,     13/
      DATA (ISEC_LINEAR(K),K=  153,  304) /
     &     12,    211,     11,     12,    321,    111,      0,    311,
     &    211,      0,    311,    111,      0,    321,   -211,      0,
     &    311,    111,      0,    321,   -211,      0,    321,    111,
     &      0,    311,    211,      0,    311,    111,      0,    321,
     &   -211,      0,    313,    111,      0,    323,   -211,      0,
     &    311,    113,      0,    321,   -213,      0,    311,    223,
     &      0,    311,    221,      0,    321,    111,      0,    311,
     &    211,      0,    323,    111,      0,    313,    211,      0,
     &    321,    113,      0,    311,    213,      0,    321,    223,
     &      0,    321,    221,      0,   -321,    211,    211,   -311,
     &    211,      0,   -321,    211,      0,   -321,    211,    111,
     &    311,    211,   -211,    311,    111,      0,    421,    111,
     &      0,    421,     22,      0,    421,    211,      0,    411,
     &    111,      0,    411,     22,      0,    221,    211,      0,
     &    321,   -321,    321,    321,   -311,      0,    431,     22,
     &      0,    431,     22,      0,    111,    111,      0,    211,
     &   -211,      0,     22,     22,      0,    -11,     11,      0,
     &    -13,     13,      0,    211,   -211,    111,    443,    211,
     &   -211,    443,    111,    111,    443,    221,      0,   2212/
      DATA (ISEC_LINEAR(K),K=  305,  456) /
     &     11,     12,   2112,    111,      0,   2212,   -211,      0,
     &   2112,    111,    111,   2112,    211,   -211,   1114,    211,
     &      0,   2114,    111,      0,   2214,   -211,      0,   2112,
     &    113,      0,   2212,   -213,      0,   2112,    221,      0,
     &   2212,    111,      0,   2112,    211,      0,   2212,    111,
     &    111,   2212,    211,   -211,   2224,   -211,      0,   2214,
     &    111,      0,   2114,    211,      0,   2212,    113,      0,
     &   2112,    213,      0,   2212,    221,      0,   2212,   -211,
     &      0,   2112,    111,      0,   2214,   -211,      0,   2114,
     &    111,      0,   1114,    211,      0,   2212,   -213,      0,
     &   2112,    113,      0,   2212,    111,      0,   2112,    211,
     &      0,   2224,   -211,      0,   2214,    111,      0,   2114,
     &    211,      0,   2212,    113,      0,   2112,    213,      0,
     &   2212,   -211,      0,   2112,    111,      0,   2212,   -213,
     &      0,   2112,    113,      0,   3122,    311,      0,   3212,
     &    311,      0,   3112,    321,      0,   2112,    221,      0,
     &   2212,    111,      0,   2112,    211,      0,   2212,    113,
     &      0,   2112,    213,      0,   3122,    321,      0,   3222,
     &    311,      0,   3212,    321,      0,   2212,    221,      0/
      DATA (ISEC_LINEAR(K),K=  457,  608) /
     &   2112,   -211,      0,   2212,   -211,      0,   2112,    111,
     &      0,   2212,    111,      0,   2112,    211,      0,   2212,
     &    211,      0,   2112,   -211,      0,   2114,   -211,      0,
     &   1114,    111,      0,   2112,   -213,      0,   2212,   -211,
     &      0,   2112,    111,      0,   2214,   -211,      0,   2114,
     &    111,      0,   1114,    211,      0,   2212,   -213,      0,
     &   2112,    113,      0,   2212,    111,      0,   2112,    211,
     &      0,   2224,   -211,      0,   2214,    111,      0,   2114,
     &    211,      0,   2212,    113,      0,   2112,    213,      0,
     &   2212,    211,      0,   2224,    111,      0,   2214,    211,
     &      0,   2212,    213,      0,   2212,   -211,      0,   2112,
     &    111,      0,   2212,    111,      0,   2112,    211,      0,
     &   3122,     22,      0,   2112,   -211,      0,   3122,    211,
     &      0,   3212,    211,      0,   3222,    111,      0,   3122,
     &    111,      0,   3222,   -211,      0,   3112,    211,      0,
     &   3122,   -211,      0,   3212,   -211,      0,   2112,   -311,
     &      0,   2212,   -321,      0,   3222,   -211,      0,   3212,
     &    111,      0,   3112,    211,      0,   3122,    221,      0,
     &   3224,   -211,      0,   3114,    211,      0,   3214,    111/
      DATA (ISEC_LINEAR(K),K=  609,  760) /
     &      0,   2112,   -311,      0,   2212,   -321,      0,   3122,
     &    111,      0,   3122,    223,      0,   3122,    113,      0,
     &   3222,   -213,      0,   3112,    213,      0,   3212,    113,
     &      0,   3122,    221,      0,   3212,    221,      0,   3222,
     &   -211,      0,   3112,    211,      0,   3212,    111,      0,
     &   3122,    111,      0,   3122,   -211,      0,   3322,    111,
     &      0,   3312,    211,      0,   3322,   -211,      0,   3312,
     &    111,      0,   3322,   -211,      0,   3312,    111,      0,
     &   3122,   -321,      0,   3222,    221,      0,   3222,    331,
     &      0,   2212,   -311,      0,   3322,    321,      0,   3224,
     &    221,      0,   2214,    331,      0,   2224,   -321,      0,
     &   3122,    213,      0,   3212,    213,      0,   3222,    113,
     &      0,   3222,    223,      0,   2212,   -313,      0,   2214,
     &   -313,      0,   2224,   -323,      0,   4122,    211,      0,
     &   4122,    111,      0,   4122,   -211,      0,   3222,   -311,
     &      0,   3322,    211,      0,   3222,   -313,      0,   3322,
     &    213,      0,   3212,   -313,      0,   3222,   -323,      0,
     &   3322,    223,      0,   3312,    213,      0,   3214,   -313,
     &      0,   3322,   -311,      0,   3322,    313,      0,   3334/
      DATA (ISEC_LINEAR(K),K=  761,  765) /
     &    213,      0,   3334,    211,      0/
      DATA (WG_CHAN(K),K=    1,  114) /
     &1.0000E+00,2.8000E-01,2.8000E-01,3.5000E-01,7.0000E-02,2.0000E-02,
     &1.0000E+00,9.9000E-01,1.0000E-02,3.8000E-01,3.0000E-02,3.0000E-01,
     &2.4000E-01,5.0000E-02,1.0000E+00,0.0000E+00,1.0000E+00,8.8800E-01,
     &2.5000E-02,8.7000E-02,4.8000E-01,2.4000E-01,2.6000E-01,2.0000E-02,
     &4.9100E-01,3.4400E-01,1.2900E-01,2.4000E-02,1.2000E-02,4.0000E-01,
     &3.0000E-01,3.0000E-01,6.0000E-01,4.0000E-01,4.0000E-01,3.0000E-01,
     &3.0000E-01,5.0000E-01,5.0000E-01,1.0000E+00,6.4000E-01,2.1000E-01,
     &6.0000E-02,2.0000E-02,3.0000E-02,4.0000E-02,6.9000E-01,3.1000E-01,
     &2.1000E-01,1.2000E-01,2.7000E-01,4.0000E-01,3.3000E-01,6.7000E-01,
     &3.3000E-01,6.7000E-01,3.3000E-01,6.7000E-01,3.3000E-01,6.7000E-01,
     &1.9000E-01,3.8000E-01,9.0000E-02,2.0000E-01,3.0000E-02,4.0000E-02,
     &5.0000E-02,2.0000E-02,1.9000E-01,3.8000E-01,9.0000E-02,2.0000E-01,
     &3.0000E-02,4.0000E-02,5.0000E-02,2.0000E-02,7.0000E-01,3.0000E-01,
     &1.0000E-01,5.0000E-01,1.6000E-01,2.4000E-01,5.5000E-01,4.5000E-01,
     &6.8000E-01,3.0000E-01,2.0000E-02,3.0000E-01,4.0000E-01,3.0000E-01,
     &9.0000E-01,1.0000E-01,4.9000E-01,4.9000E-01,2.0000E-02,1.0000E-01,
     &1.0000E-01,8.0000E-01,6.0000E-01,3.0000E-01,1.0000E-01,1.0000E+00,
     &1.5000E-01,3.5000E-01,7.0000E-02,1.8000E-01,1.1000E-01,6.0000E-02,
     &3.0000E-02,1.0000E-02,3.0000E-02,1.0000E-02,1.5000E-01,3.5000E-01/
      DATA (WG_CHAN(K),K=  115,  228) /
     &7.0000E-02,1.8000E-01,1.1000E-01,6.0000E-02,3.0000E-02,1.0000E-02,
     &3.0000E-02,1.0000E-02,3.7000E-01,1.8000E-01,4.0000E-02,8.0000E-02,
     &1.3000E-01,1.3000E-01,7.0000E-02,1.8000E-01,3.7000E-01,1.3000E-01,
     &8.0000E-02,4.0000E-02,7.0000E-02,1.3000E-01,1.3000E-01,7.0000E-02,
     &4.7000E-01,2.3000E-01,5.0000E-02,1.0000E-02,2.0000E-02,2.0000E-02,
     &7.0000E-02,1.3000E-01,2.3000E-01,4.7000E-01,5.0000E-02,2.0000E-02,
     &1.0000E-02,2.0000E-02,1.0000E+00,3.3000E-01,6.7000E-01,6.7000E-01,
     &3.3000E-01,1.0000E+00,2.5000E-01,1.8000E-01,2.7000E-01,3.0000E-01,
     &8.0000E-02,1.7000E-01,2.4000E-01,3.0000E-02,1.8000E-01,1.0000E-01,
     &2.0000E-01,1.7000E-01,8.0000E-02,1.8000E-01,3.0000E-02,2.4000E-01,
     &2.0000E-01,1.0000E-01,2.5000E-01,2.7000E-01,1.8000E-01,3.0000E-01,
     &6.4000E-01,3.6000E-01,5.2000E-01,4.8000E-01,1.0000E+00,1.0000E+00,
     &8.8000E-01,6.0000E-02,6.0000E-02,8.8000E-01,6.0000E-02,6.0000E-02,
     &8.8000E-01,1.2000E-01,1.9000E-01,1.9000E-01,1.6000E-01,1.6000E-01,
     &1.7000E-01,3.0000E-02,3.0000E-02,3.0000E-02,4.0000E-02,1.0000E-01,
     &1.0000E-01,2.0000E-01,1.2000E-01,1.0000E-01,4.0000E-02,4.0000E-02,
     &5.0000E-02,7.5000E-02,7.5000E-02,3.0000E-02,3.0000E-02,4.0000E-02,
     &1.0000E+00,1.0000E+00,3.3000E-01,6.7000E-01,6.7000E-01,3.3000E-01,
     &2.5000E-01,2.5000E-01,5.0000E-01,2.0000E-02,3.0000E-02,7.0000E-02/
      DATA (WG_CHAN(K),K=  229,  255) /
     &2.0000E-02,2.0000E-02,4.0000E-02,1.3000E-01,7.0000E-02,6.0000E-02,
     &6.0000E-02,2.0000E-01,1.4000E-01,4.0000E-02,1.0000E-01,1.0000E+00,
     &1.0000E+00,1.0000E+00,2.5000E-01,3.0000E-02,3.0000E-01,4.2000E-01,
     &2.2000E-01,3.5000E-01,1.9000E-01,1.6000E-01,8.0000E-02,3.7000E-01,
     &2.0000E-01,3.6000E-01,7.0000E-02/
      DATA (ID_PSM_LINEAR(K),K=    1,   36) /
     &    111,    211,   -311,    411,      0,      0,   -211,    111,
     &   -321,    421,      0,      0,    311,    321,    221,    431,
     &      0,      0,   -411,   -421,   -431,    441,      0,      0,
     &      0,      0,      0,      0,      0,      0,      0,      0,
     &      0,      0,      0,      0/
      DATA (ID_VEM_LINEAR(K),K=    1,   36) /
     &    113,    213,   -313,    413,      0,      0,   -213,    113,
     &   -323,    423,      0,      0,    313,    323,    333,    433,
     &      0,      0,   -413,   -423,   -433,  20443,      0,      0,
     &      0,      0,      0,      0,      0,      0,      0,      0,
     &      0,      0,      0,      0/
      DATA (ID_B8_LINEAR(K),K=    1,  171) /
     &  1114,  2112,  3112,  4112,     0,     0,  2112,  2212,  3212,
     &  4122,     0,     0,  3112,  3212,  3312,  4312,     0,     0,
     &  4112,  4122,  4312,  4412,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &  2112,  2212,  3212,  4122,     0,     0,  2212,  2224,  3222,
     &  4222,     0,     0,  3212,  3222,  3322,  4322,     0,     0,
     &  4122,  4222,  4322,  4422,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &  3112,  3212,  3312,  4312,     0,     0,  3212,  3222,  3322,
     &  4322,     0,     0,  3312,  3322,  3334,  4332,     0,     0,
     &  4312,  4322,  4332,  4432,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &  4112,  4122,  4312,  4412,     0,     0,  4122,  4222,  4322,
     &  4422,     0,     0,  4312,  4322,  4332,  4432,     0,     0,
     &  4412,  4422,  4432,  4444,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0/
      DATA (ID_B8_LINEAR(K),K=  172,  216) /
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0/
      DATA (ID_B10_LINEAR(K),K=    1,  171) /
     &  1114,  2114,  3114,  4114,     0,     0,  2114,  2214,  3214,
     &  4214,     0,     0,  3114,  3214,  3314,  4314,     0,     0,
     &  4114,  4214,  4314,  4414,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &  2114,  2214,  3214,  4214,     0,     0,  2214,  2224,  3224,
     &  4224,     0,     0,  3214,  3224,  3324,  4324,     0,     0,
     &  4214,  4224,  4324,  4424,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &  3114,  3214,  3314,  4314,     0,     0,  3214,  3224,  3324,
     &  4324,     0,     0,  3314,  3324,  3334,  4334,     0,     0,
     &  4314,  4324,  4334,  4434,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &  4114,  4214,  4314,  4414,     0,     0,  4214,  4224,  4324,
     &  4424,     0,     0,  4314,  4324,  4334,  4434,     0,     0,
     &  4414,  4424,  4434,  4444,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0/
      DATA (ID_B10_LINEAR(K),K=  172,  216) /
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0,
     &     0,     0,     0,     0,     0,     0,     0,     0,     0/

      ID_PDG_MAX = I_TAB_MAX

C  copy from local to global variables
      DO I=1,I_TAB_MAX
        ID_PDG_LIST(I) = NUMBER(I)
        NAME_LIST(I)   = NAME(I)
        XM_LIST(I)     = XMASS(I)
        GAM_LIST(I)    = GAMMA(I)
        ICH3_LIST(I)   = ICH3(I)
        IBA3_LIST(I)   = IBA3(I)
        DO J=1,3
          IQ_LIST(J,I)   = IQ_LINEAR(3*(I-1)+J)
          IDEC_LIST(J,I) = IDEC_LINEAR(3*(I-1)+J)
        ENDDO
      ENDDO

C  initialize hash table
      CALL PHO_CPCINI(ID_PDG_MAX,ID_PDG_LIST,ID_LIST)


      ITMP = IDEB(71)
      IDEB(71) = -1


C  quark index table for mesons
      DO I=1,6
        DO J=1,6
          ID_PSM_LIST(I,J) = IPHO_PDG2ID(ID_PSM_LINEAR(6*(J-1)+I))
          ID_VEM_LIST(I,J) = IPHO_PDG2ID(ID_VEM_LINEAR(6*(J-1)+I))
        ENDDO
      ENDDO

C  quark index table for baryons
      DO I=1,6
        DO J=1,6
          DO K=1,6
            ID_B8_LIST(I,J,K)  =
     &        IPHO_PDG2ID(ID_B8_LINEAR(36*(K-1)+6*(J-1)+I))
            ID_B10_LIST(I,J,K) =
     &        IPHO_PDG2ID(ID_B10_LINEAR(36*(K-1)+6*(J-1)+I))
          ENDDO
        ENDDO
      ENDDO


      IDEB(71) = ITMP


C  copy secondary particles
C  (translate PDG-ID to CPC and sort according to CPC)
      ICHAN = 0
      DO I=1,I_TAB_MAX
        IF(IDEC_LIST(1,I).NE.0) THEN
          DO J=IDEC_LIST(2,I),IDEC_LIST(3,I)
            ICHAN = ICHAN+1
            WG_SEC_LIST(ICHAN) = WG_CHAN(J)
            DO K=1,3
              IF(ISEC_LINEAR(3*(J-1)+K).NE.0) THEN
                ISEC_LIST(K,ICHAN) = IPHO_PDG2ID(ISEC_LINEAR(3*(J-1)+K))
              ELSE
                ISEC_LIST(K,ICHAN) = 0
              ENDIF
            ENDDO
          ENDDO
        ENDIF
      ENDDO

C  add two-pion background (low-mass photon dissociation)
      I = IPHO_PDG2ID(92)
      ICHAN = ICHAN+1
      IDEC_LIST(1,I) = 1
      IDEC_LIST(2,I) = ICHAN
      IDEC_LIST(3,I) = ICHAN
      WG_SEC_LIST(ICHAN) = 1.D0
      ISEC_LIST(1,ICHAN) = IPHO_PDG2ID(211)
      ISEC_LIST(2,ICHAN) = IPHO_PDG2ID(-211)
      ISEC_LIST(3,ICHAN) = 0

C  min. mass limits for strings: q-qbar
      DO I=1,6
        DO J=1,6
          AM2P = 1000.D0
          AM2V = 1000.D0
          DO K=1,3
C  pseudo-scalar mesons
            I1 = IABS(ID_PSM_LIST(I,K))
            IF(I1.NE.0) THEN
              AM1 = XM_LIST(I1)
            ELSE
              AM1 = PHO_PMASS(I,3)+PHO_PMASS(K,3)
            ENDIF
            I2 = IABS(ID_PSM_LIST(K,J))
            IF(I2.NE.0) THEN
              AM2 = XM_LIST(I2)
            ELSE
              AM2 = PHO_PMASS(K,3)+PHO_PMASS(J,3)
            ENDIF
            AM2P = MIN(AM2P,AM1+AM2)
C  vector mesons
            I1 = IABS(ID_VEM_LIST(I,K))
            IF(I1.NE.0) THEN
              AM1 = XM_LIST(I1)
            ELSE
              AM1 = PHO_PMASS(I,3)+PHO_PMASS(K,3)
            ENDIF
            I2 = IABS(ID_VEM_LIST(K,J))
            IF(I2.NE.0) THEN
              AM2 = XM_LIST(I2)
            ELSE
              AM2 = PHO_PMASS(K,3)+PHO_PMASS(J,3)
            ENDIF
            AM2V = MIN(AM2V,AM1+AM2)
          ENDDO
          XM_PSM2_LIST(I,J) = AM2P
          XM_VEM2_LIST(I,J) = AM2V
        ENDDO
      ENDDO

C  min. mass limits for strings: qq-q
      DO I=1,6
        DO J=1,6
          DO K=1,6
            AM82  = 1000.D0
            AM102 = 1000.D0
            DO L=1,3
C  pseudo-scalar meson
              I1 = IABS(ID_PSM_LIST(K,L))
              IF(I1.NE.0) THEN
                AM1 = XM_LIST(I1)
              ELSE
                AM1 = PHO_PMASS(I,3)+PHO_PMASS(K,3)
              ENDIF
C  vector meson
              I2 = IABS(ID_VEM_LIST(K,L))
              IF(I2.NE.0) THEN
                AM2 = XM_LIST(I2)
              ELSE
                AM2 = PHO_PMASS(I,3)+PHO_PMASS(K,3)
              ENDIF
C  octet baryon
              AMM = MIN(AM1,AM2)
              K8  = ID_B8_LIST(I,J,L)
              IF(K8.NE.0) THEN
                AM1 = XM_LIST(K8)
              ELSE
                AM1 = PHO_PMASS(I,3)+PHO_PMASS(J,3)+PHO_PMASS(L,3)
              ENDIF
              AM82  = MIN(AM82, AM1 + AMM)
C  decuplet baryon
              K10 = ID_B10_LIST(I,J,L)
              IF(K10.NE.0) THEN
                AM2 = XM_LIST(K10)
              ELSE
                AM2 = PHO_PMASS(I,3)+PHO_PMASS(J,3)+PHO_PMASS(L,3)
              ENDIF
              AM102 = MIN(AM102, AM2 + AMM)
            ENDDO
            XM_B82_LIST(I,J,K)  = AM82
            XM_B102_LIST(I,J,K) = AM102
          ENDDO
        ENDDO
      ENDDO

C  min. mass limits for strings: qq-qbarqbar
      DO I=1,6
        DO J=1,6
          DO II=1,6
            DO JJ=1,6
              AM82  = 1000.D0
              AM102 = 1000.D0
              DO L=1,3
C  octet baryons
                K8  = ID_B8_LIST(I,J,L)
                IF(K8.NE.0) THEN
                  AM1 = XM_LIST(K8)
                ELSE
                  AM1 = PHO_PMASS(I,3)+PHO_PMASS(J,3)+PHO_PMASS(L,3)
                ENDIF
                L8  = ID_B8_LIST(II,JJ,L)
                IF(L8.NE.0) THEN
                  AM2 = XM_LIST(L8)
                ELSE
                  AM2 = PHO_PMASS(II,3)+PHO_PMASS(JJ,3)+PHO_PMASS(L,3)
                ENDIF
                AM82  = MIN(AM82, AM1+AM2)
C  decuplet baryons
                K10 = ID_B10_LIST(I,J,L)
                IF(K10.NE.0) THEN
                  AM1 = XM_LIST(K10)
                ELSE
                  AM1 = PHO_PMASS(I,3)+PHO_PMASS(J,3)+PHO_PMASS(L,3)
                ENDIF
                L10 = ID_B10_LIST(II,JJ,L)
                IF(L10.NE.0) THEN
                  AM2 = XM_LIST(L10)
                ELSE
                  AM2 = PHO_PMASS(II,3)+PHO_PMASS(JJ,3)+PHO_PMASS(L,3)
                ENDIF
                AM102 = MIN(AM102, AM1+AM2)
              ENDDO
              XM_BB82_LIST(I,J,II,JJ)  = AM82
              XM_BB102_LIST(I,J,II,JJ) = AM102
            ENDDO
          ENDDO
        ENDDO
      ENDDO

      END




CDECK  ID>, PHO_PRESEL
      SUBROUTINE PHO_PRESEL(MODE,IREJ)
C**********************************************************************
C
C     user specific function to pre-select events during generation
C
C     input:   MODE  5  electron and photon kinematics
C                   10  process and number of cut Pomerons
C                   15  partons without construction of strings
C                   20  partons assigned to strings
C                   25  after fragmentation, complete final state
C
C     output:  IREJ  0  event accepted
C                   50  event rejected
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
C
C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)

C  hard scattering data
      INTEGER MSCAHD
      PARAMETER ( MSCAHD = 50 )
      INTEGER LSCAHD,LSC1HD,LSIDX,
     &        NINHD,N0INHD,NIVAL,N0IVAL,NOUTHD,NBRAHD,NPROHD
      DOUBLE PRECISION PPH,PTHD,ETAHD,Q2SCA,PDFVA,XHD,VHD,X0HD
      COMMON /POHSLT/ LSCAHD,LSC1HD,LSIDX(MSCAHD),
     &                PPH(8*MSCAHD,2),PTHD(MSCAHD),ETAHD(MSCAHD,2),
     &                Q2SCA(MSCAHD,2),PDFVA(MSCAHD,2),
     &                XHD(MSCAHD,2),VHD(MSCAHD),X0HD(MSCAHD,2),
     &                NINHD(MSCAHD,2),N0INHD(MSCAHD,2),
     &                NIVAL(MSCAHD,2),N0IVAL(MSCAHD,2),
     &                NOUTHD(MSCAHD,2),NBRAHD(MSCAHD,2),NPROHD(MSCAHD)

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      IREJ = 0

*     XBJ = GQ2(2)/(GGECM**2+GQ2(2))
*     IF(XBJ.LT.0.002D0) IREJ = 1

      END


CDECK  ID>, PHO_FIXCOL
      SUBROUTINE PHO_FIXCOL(E1,E2,THETA,PHI,NEV)
C**********************************************************************
C
C     interface to call PHOJET (fixed energy run) with
C     collider kinematics
C
C     equivalen photon approximation to get photon flux
C
C     input:     NEV     number of events to generate
C                THETA   azimuthal angle (micro radians)
C                PHI     beam crossing angle
C                        (with respect to x, in degrees)
C                E1      energy of particle 1 (+z direction, GeV)
C                E2      energy of particle 2 (-z direction, GeV)
C
C     note: particle types have to be specified before
C           with PHO_SETPAR
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER(TWOPI=6.283185307D0,BOG=TWOPI/360.0D0)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  integration precision for hard cross sections (obsolete)
      INTEGER NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO
      COMMON /POGAUP/ NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      DIMENSION P1(4),P2(4)

C  remnant initialization (only needed for DTUNUC)
      ISAVP1 = IFPAP(1)
      ISAVB1 = IFPAB(1)
      IF(IFPAP(1).EQ.81) THEN
        IFPAP(1) = IDEQP(1)
        IFPAB(1) = IDEQB(1)
      ENDIF
      ISAVP2 = IFPAP(2)
      ISAVB2 = IFPAB(2)
      IF(IFPAP(2).EQ.82) THEN
        IFPAP(2) = IDEQP(2)
        IFPAB(2) = IDEQB(2)
      ENDIF
      PMASS1 = PHO_PMASS(IFPAB(1),0)-SQRT(PVIRT(1))
      PMASS2 = PHO_PMASS(IFPAB(2),0)-SQRT(PVIRT(2))
      PP1 = SQRT(E1**2-PMASS1**2)
      PP2 = SQRT(E2**2-PMASS2**2)
C  beam crossing angle
      TH = 1.D-6*THETA/2.D0
      PH = PHI*BOG
      P1(1) = PP1*SIN(TH)*COS(PH)
      P1(2) = PP1*SIN(TH)*SIN(PH)
      P1(3) = PP1*COS(TH)
      P1(4) = E1
      P2(1) = PP2*SIN(TH)*COS(PH)
      P2(2) = PP2*SIN(TH)*SIN(PH)
      P2(3) = -PP2*COS(TH)
      P2(4) = E2
      CALL PHO_EVENT(-1,P1,P2,SIGMAX,IREJ)
      IFPAP(1) = ISAVP1
      IFPAB(1) = ISAVB1
      IFPAP(2) = ISAVP2
      IFPAB(2) = ISAVB2
      ITRY = 0
      CALL PHO_PHIST(-1,SIGMAX)
      CALL PHO_LHIST(-1,SIGMAX)
C  test of DTUNUC interface (default is IPAMDL(13)=0)
      IF(IPAMDL(13).GT.0) THEN
        MODE = IPAMDL(13)
        IPAMDL(13) = 0
      ELSE
        MODE = 1
      ENDIF
C  main generation loop
      DO 50 I=1,NEV
 55     CONTINUE
        ITRY = ITRY+1
        CALL PHO_EVENT(MODE,P1,P2,SIGCUR,IREJ)
        IF(IREJ.NE.0) GOTO 55
        CALL PHO_PHIST(1,HSWGHT(0))
        CALL PHO_LHIST(1,HSWGHT(0))
 50   CONTINUE

      IF(NEV.GT.0) THEN
        SIGMAX = SIGMAX*DBLE(NEV)/DBLE(ITRY)
        WRITE(ErrorOut,'(//1X,A,/1X,A,1PE12.3,A,/1X,A)')
     &  '=========================================================',
     &  ' *****   SIMULATED CROSS SECTION: ',SIGMAX,' MB  *****',
     &  '========================================================='
        CALL PHO_EVENT(-2,P1,P2,SIGCUR,IREJ)
        CALL PHO_PHIST(-2,SIGMAX)
        CALL PHO_LHIST(-2,SIGMAX)
      ELSE
        WRITE(ErrorOut,
     * '(1X,A,I5)') 'POFCOL: no events simulated',NEV
      ENDIF

      END


CDECK  ID>, PHO_FIXLAB
      SUBROUTINE PHO_FIXLAB(PLAB,NEV)
C**********************************************************************
C
C     interface to call PHOJET (fixed energy run) with
C     LAB kinematics (second particle as target)
C
C     equivalent photon approximation to get photon flux
C
C     input:     NEV     number of events to generate
C                PLAB    LAB momentum of particle 1
C
C     note: particle types have to be specified before
C           with PHO_SETPAR
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  integration precision for hard cross sections (obsolete)
      INTEGER NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO
      COMMON /POGAUP/ NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      DIMENSION P1(4),P2(4)

C  remnant initialization (only needed for DTUNUC)
      SPCM = PLAB
      ISAVP1 = IFPAP(1)
      ISAVB1 = IFPAB(1)
      IF(IFPAP(1).EQ.81) THEN
        IFPAP(1) = IDEQP(1)
        IFPAB(1) = IDEQB(1)
      ENDIF
      ISAVP2 = IFPAP(2)
      ISAVB2 = IFPAB(2)
      IF(IFPAP(2).EQ.82) THEN
        IFPAP(2) = IDEQP(2)
        IFPAB(2) = IDEQB(2)
      ENDIF
C  get momenta in LAB system
      PMASS1 = PHO_PMASS(IFPAB(1),0)**2-PVIRT(1)
      PMASS2 = PHO_PMASS(IFPAB(2),0)**2-PVIRT(2)
      IF(PMASS2.LT.0.1D0) THEN
        WRITE(ErrorOut,'(/1X,2A,2I7)') 'PHO_FIXLAB:ERROR: ',
     &    'NO LAB SYSTEM POSSIBLE',IFPAB(1),IFPAB(2)
      ELSE
        P1(1) = 0.D0
        P1(2) = 0.D0
        P1(3) = PLAB
        P1(4) = SQRT(PMASS1+PLAB**2)
        P2(1) = 0.D0
        P2(2) = 0.D0
        P2(3) = 0.D0
        P2(4) = SQRT(PMASS2)
        CALL PHO_EVENT(-1,P1,P2,SIGMAX,IREJ)
        IFPAP(1) = ISAVP1
        IFPAB(1) = ISAVB1
        IFPAP(2) = ISAVP2
        IFPAB(2) = ISAVB2
        ITRY = 0
        CALL PHO_PHIST(-1,SIGMAX)
        CALL PHO_LHIST(-1,SIGMAX)
C  event generation loop
        DO 40 I=1,NEV
 45       CONTINUE
          ITRY = ITRY+1
          CALL PHO_EVENT(1,P1,P2,SIGCUR,IREJ)
          IF(IREJ.NE.0) GOTO 45
          CALL PHO_LHIST(1,HSWGHT(0))

          CALL PHO_PHIST(10,HSWGHT(0))

 40     CONTINUE
        IF(NEV.GT.0) THEN
          SIGMAX = SIGMAX*DBLE(NEV)/DBLE(ITRY)
          WRITE(ErrorOut,'(//1X,A,/1X,A,1PE12.3,A,/1X,A)')
     &    '=========================================================',
     &    ' *****   SIMULATED CROSS SECTION: ',SIGMAX,' MB  *****',
     &    '========================================================='
          CALL PHO_EVENT(-2,P1,P2,SIGCUR,IREJ)
          CALL PHO_PHIST(-2,SIGMAX)
          CALL PHO_LHIST(-2,SIGMAX)
        ELSE
          WRITE(ErrorOut,'(1X,A,I5)')
     &      'PHO_FIXLAB: NO EVENTS SIMULATED',NEV
        ENDIF
      ENDIF

      END


CDECK  ID>, PHO_GPHERA
      SUBROUTINE PHO_GPHERA(NEVENT,EE1,EE2)
C**********************************************************************
C
C     interface to call PHOJET (variable energy run) with
C     HERA kinematics, photon as particle 2
C
C     equivalent photon approximation to get photon flux
C
C     input:     NEVENT  number of events to generate
C                EE1     proton energy (LAB system)
C                EE2     electron energy (LAB system)
C             from /POFCUT/:
C                YMIN2    lower limit of Y
C                        (energy fraction taken by photon from electron)
C                YMAX2    upper limit of Y
C                Q2MIN2   lower limit of photon virtuality
C                Q2MAX2   upper limit of photon virtuality
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS = 1.D-10,
     &            PI   = 3.14159265359D0 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  photon flux kinematics and cuts
      DOUBLE PRECISION ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                 YMIN1,YMAX1,YMIN2,YMAX2,
     &                 Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                 THMIN1,THMAX1,THMIN2,THMAX2
      INTEGER          ITAG1,ITAG2
      COMMON /POFCUT/ ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                YMIN1,YMAX1,YMIN2,YMAX2,
     &                Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                THMIN1,THMAX1,THMIN2,THMAX2,
     &                ITAG1,ITAG2

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      DIMENSION P1(4),P2(4)


      WRITE(ErrorOut,
     * '(//1X,A,I10)') 'PHO_GPHERA: events to process',NEVENT
C  assign particle momenta according to HERA kinematics
C  proton data
      PROM = PHO_PMASS(2212,1)
      PROM2 = PROM**2
      IDPSRC(1) = 0
      IDBSRC(1) = 0
C  electron data
      ELEM = 0.512D-03
      ELEM2 = ELEM**2
      AMSRC(2) = ELEM
      IDPSRC(2) = 11
      IDBSRC(2) = IPHO_PDG2ID(11)
C
      Q2MIN = Q2MIN2
      Q2MAX = Q2MAX2
C
      XIMAX = LOG(YMAX2)
      XIMIN = LOG(YMIN2)
      XIDEL = XIMAX-XIMIN
C
      IF(Q2MIN.GT.ELEM2*YMIN2**2/(1.D0-YMIN2))
     &  WRITE(ErrorOut,'(/1X,A,1P2E11.4)')
     &  'PHO_GPHERA: LOWER Q2 CUTOFF LARGER THAN KIN. LIMIT:',
     &  Q2MIN,ELEM2*YMIN2**2/(1.D0-YMIN2)
C
      MAX_TAB = 50
      DELLY = LOG(YMAX2/YMIN2)/DBLE(MAX_TAB-1)
      FLUXT = 0.D0
      FLUXL = 0.D0
      IF(IDEB(30).GE.1) WRITE(ErrorOut,'(1X,A,I5)')
     &  'PHO_GPHERA: TABLE OF PHOTON FLUX (TRANS/LONG)',MAX_TAB
      DO 100 I=1,MAX_TAB
        Y = EXP(XIMIN+DELLY*DBLE(I-1))
        Q2LOW = MAX(Q2MIN,ELEM2*Y**2/(1.D0-Y))
        FFT = ((1.D0+(1.D0-Y)**2)/Y*LOG(Q2MAX/Q2LOW)
     &         -2.D0*ELEM2*Y*(1.D0/Q2LOW-1.D0/Q2MAX))/(2.D0*PI*137.D0)
        FFL = 2.D0*(1.D0-Y)/Y*LOG(Q2MAX/Q2LOW)/(2.D0*PI*137.D0)
        FLUXT = FLUXT + Y*FFT
        FLUXL = FLUXL + Y*FFL
        IF(IDEB(30).GE.1) WRITE(ErrorOut,
     * '(5X,1P3E14.4)') Y,FFT,FFL
 100  CONTINUE
      FLUXT = FLUXT*DELLY
      FLUXL = FLUXL*DELLY
      IF(IDEB(30).GE.1) WRITE(ErrorOut,'(1X,A,1P2E12.4)')
     &  'PHO_GPHERA: INTEGRATED FLUX (TRANS./LONG.):',FLUXT,FLUXL
C
      AY = 0.D0
      AY2 = 0.D0
      YY = YMIN2
      Q2LOW = MAX(Q2MIN,ELEM2*YY**2/(1.D0-YY))
      WGMAX = (1.D0+(1.D0-YY)**2)*LOG(Q2MAX/Q2LOW)
     &        -2.D0*ELEM2*YY*(1.D0/Q2LOW-1.D0/Q2MAX)*YY
      IF(ISWMDL(10).GE.2) WGMAX = WGMAX+2.D0*(1.D0-YY)*LOG(Q2MAX/Q2LOW)
C
C  initialization of PHOJET at upper energy limit
C  proton momentum
      P1(1) = 0.D0
      P1(2) = 0.D0
      P1(3) = SQRT(EE1**2-PROM2+DEPS)
      P1(4) = EE1
C  photon momentum
      EGAM = YMAX2*EE2
      P2(1) = 0.D0
      P2(2) = 0.D0
      P2(3) = -EGAM
      P2(4) = EGAM
C  sum of both photon polarizations
      IGHEL(2) = -1
C
      CALL PHO_SETPAR(1,2212,0,0.D0)
      CALL PHO_SETPAR(2,22,0,0.D0)
      CALL PHO_EVENT(-1,P1,P2,SIGMAX,IREJ)
      CALL PHO_PHIST(-1,SIGMAX)
      CALL PHO_LHIST(-1,SIGMAX)
C
C  generation of events, flux calculation

      ECMIN2 = ECMIN**2
      ECMAX2 = ECMAX**2
      AY = 0.D0
      AY2 = 0.D0
      Q22MIN = 1.D30
      Q22AVE = 0.D0
      Q22AV2 = 0.D0
      Q22MAX = 0.D0
      AN2MIN = 1.D30
      AN2MAX = 0.D0
      YY2MIN = 1.D30
      YY2MAX = 0.D0
      NITER = NEVENT
      ITRY = 0
      ITRW = 0
      DO 200 I=1,NITER
 150    CONTINUE
C  sample y
        ITRY = ITRY+1
 175    CONTINUE
          ITRW = ITRW+1
          YY = EXP(XIDEL*PHO_RNDM(AY)+XIMIN)
          IF(ISWMDL(10).GE.2) THEN
            YEFF = 1.D0+(1.D0-YY)**2+2.D0*(1.D0-YY)
          ELSE
            YEFF = 1.D0+(1.D0-YY)**2
          ENDIF
          Q2LOW = MAX(Q2MIN,ELEM2*YY**2/(1.D0-YY))
          Q2LOG = LOG(Q2MAX/Q2LOW)
          WGH = YEFF*Q2LOG-2.D0*ELEM2*YY**2*(1.D0/Q2LOW-1.D0/Q2MAX)
          IF(WGMAX.LT.WGH) THEN
            WRITE(ErrorOut,'(1X,A,3E12.5)')
     &        'PHO_GPHERA: INCONSISTENT WEIGHT:',YY,WGMAX,WGH
          ENDIF
        IF(PHO_RNDM(AY2)*WGMAX.GT.WGH) GOTO 175
C  sample Q2
        IF(IPAMDL(174).EQ.1) THEN
 185      CONTINUE
            Q2 = Q2LOW*EXP(Q2LOG*PHO_RNDM(YY))
            WEIGHT = (YEFF-2.D0*ELEM2*YY**2/Q2)/YEFF
          IF(WEIGHT.LT.PHO_RNDM(Q2)) GOTO 185
        ELSE
          Q2 = Q2LOW
        ENDIF
C

C  incoming electron
        PINI(1,2) = 0.D0
        PINI(2,2) = 0.D0
        PINI(3,2) = -EE2
        PINI(4,2) = EE2
        PINI(5,2) = 0.D0
C  outgoing electron
        YQ2 = SQRT((1.D0-YY)*Q2)
        Q2E = Q2/(4.D0*EE2)
        E1Y = EE2*(1.D0-YY)
        CALL PHO_SFECFE(SIF,COF)
        PFIN(1,2) = YQ2*COF
        PFIN(2,2) = YQ2*SIF
        PFIN(3,2) = -E1Y+Q2E
        PFIN(4,2) = E1Y+Q2E
        PFIN(5,2) = 0.D0
C  set /POFSRC/
        GYY(2) = YY
        GQ2(2) = Q2
C  polar angle
        PFTHE(2) = ACOS(PFIN(3,2)/PFIN(4,2))
C  electron tagger
        IF(PFIN(4,2).GT.EEMIN2) THEN
          IF((PFTHE(2).LT.THMIN2).OR.(PFTHE(2).GT.THMAX2)) GOTO 175
        ENDIF
C  azimuthal angle
        PFPHI(2) = ATAN2(SIF,COF)
C  photon momentum
        P2(1) = -PFIN(1,2)
        P2(2) = -PFIN(2,2)
        P2(3) = PINI(3,2)-PFIN(3,2)
        P2(4) = PINI(4,2)-PFIN(4,2)
C  proton momentum
        P1(1) = 0.D0
        P1(2) = 0.D0
        P1(3) = SQRT(EE1**2-PROM2)
        P1(4) = EE1
C  ECMS cut
        GGECM = (P1(4)+P2(4))**2-(P1(1)+P2(1))**2
     &         -(P1(2)+P2(2))**2-(P1(3)+P2(3))**2
        IF((GGECM.LT.ECMIN2).OR.(GGECM.GT.ECMAX2)) GOTO 175
        GGECM = SQRT(GGECM)
C
        PGAM(1,2) = P2(1)
        PGAM(2,2) = P2(2)
        PGAM(3,2) = P2(3)
        PGAM(4,2) = P2(4)
        PGAM(5,2) = -SQRT(Q2)
C  photon helicity
        IF(ISWMDL(10).GE.2) THEN
          WGH  = YEFF-2.D0*ELEM2*YY**2/Q2
          WGHL = 2.D0*(1-YY)
          IF(PHO_RNDM(YY).GE.WGHL/WGH) THEN
            IGHEL(2) = 1
          ELSE
            IGHEL(2) = 0
          ENDIF
        ELSE
          IGHEL(2) = -1
        ENDIF
C  user cuts
        CALL PHO_PRESEL(5,IREJ)
        IF(IREJ.NE.0) GOTO 175
C  event generation
        CALL PHO_EVENT(1,P1,P2,SIGCUR,IREJ)
        IF(IREJ.NE.0) GOTO 150

C  statistics
        AY = AY+YY
        AY2 = AY2+YY*YY
        YY2MIN = MIN(YY2MIN,YY)
        YY2MAX = MAX(YY2MAX,YY)
        Q22MIN = MIN(Q22MIN,Q2)
        Q22MAX = MAX(Q22MAX,Q2)
        Q22AVE = Q22AVE+Q2
        Q22AV2 = Q22AV2+Q2*Q2
        AN2MIN = MIN(AN2MIN,PFTHE(2))
        AN2MAX = MAX(AN2MAX,PFTHE(2))
C  histograms
        CALL PHO_PHIST(1,HSWGHT(0))
        CALL PHO_LHIST(1,HSWGHT(0))
 200  CONTINUE
C
      WGY = WGMAX*DBLE(ITRY)/DBLE(ITRW)/(137.D0*2.D0*PI)
      WGY = WGY*LOG(YMAX2/YMIN2)
      AY  = AY/DBLE(NITER)
      AY2 = AY2/DBLE(NITER)
      DAY = SQRT((AY2-AY**2)/DBLE(NITER))
      Q22AVE = Q22AVE/DBLE(NITER)
      Q22AV2 = Q22AV2/DBLE(NITER)
      Q22AV2 = SQRT((Q22AV2-Q22AVE**2)/DBLE(NITER))
      WEIGHT = WGY*SIGMAX*DBLE(NITER)/DBLE(ITRY)
C  output of histograms
      WRITE(ErrorOut,'(//1X,A,/1X,A,1PE12.3,A,/1X,A)')
     &'=========================================================',
     &' *****   SIMULATED CROSS SECTION: ',WEIGHT,' MB  *****',
     &'========================================================='
      WRITE(ErrorOut,'(//1X,A,3I10)')
     &  'PHO_GPHERA:SUMMARY:NITER,ITRY,ITRW',NITER,ITRY,ITRW
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'EFFECTIVE WEIGHT (FLUX,TOTAL)',
     &  WGY,WEIGHT
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Y,DY                 ',AY,DAY
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Y RANGE PHOTON       ',
     &  YY2MIN,YY2MAX
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Q2,DQ2               ',
     &  Q22AVE,Q22AV2
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Q2 RANGE PHOTON      ',
     &  Q22MIN,Q22MAX
      WRITE(ErrorOut,
     * '(1X,A,1P4E12.4)') 'SAMPLED THETA RANGE ELECTRON ',
     &  AN2MIN,AN2MAX,PI-AN2MAX,PI-AN2MIN
C
      CALL PHO_EVENT(-2,P1,P2,WEIGHT,IREJ)
      IF(NITER.GT.1) THEN
        CALL PHO_PHIST(-2,WEIGHT)
        CALL PHO_LHIST(-2,WEIGHT)
      ELSE
        WRITE(ErrorOut,
     * '(1X,A,I4)') 'PHO_GPHERA:NO OUTPUT OF HISTOGRAMS',NITER
      ENDIF



      END


CDECK  ID>, PHO_GGEPEM
      SUBROUTINE PHO_GGEPEM(NEVENT,EE1,EE2)
C**********************************************************************
C
C     interface to call PHOJET (variable energy run) for
C     gamma-gamma collisions on e+e- collider
C
C     fully differential equivalent (improved) photon approximation
C     to get photon flux
C
C     input:     EE1     LAB system energy of electron/positron 1
C                EE2     LAB system energy of electron/positron 2
C                NEVENT  >0  number of events to generate
C                        -1   initialization
C                        -2   final call (cross section calculation)
C            from /LEPCUT/:
C                YMIN1   lower limit of Y1
C                        (energy fraction taken by photon from electron)
C                YMAX1   upper limit of Y1
C                Q2MIN1  lower limit of photon virtuality
C                Q2MAX1  upper limit of photon virtuality
C                THMIN1  lower limit of scattered electron
C                THMAX1  upper limit of scattered electron
C                YMIN2   lower limit of Y2
C                        (energy fraction taken by photon from electron)
C                YMAX2   upper limit of Y2
C                Q2MIN2  lower limit of photon virtuality
C                Q2MAX2  upper limit of photon virtuality
C                THMIN2  lower limit of scattered electron
C                THMAX2  upper limit of scattered electron
C
C     output:    after final call with NEVENT=-2
C                EE1     e+ e- cross section (mb)
C                EE2     gamma-gamma cross section (mb)
C
C**********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      DOUBLE PRECISION EE1,EE2
      INTEGER NEVENT

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  photon flux kinematics and cuts
      DOUBLE PRECISION ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                 YMIN1,YMAX1,YMIN2,YMAX2,
     &                 Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                 THMIN1,THMAX1,THMIN2,THMAX2
      INTEGER          ITAG1,ITAG2
      COMMON /POFCUT/ ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                YMIN1,YMAX1,YMIN2,YMAX2,
     &                Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                THMIN1,THMAX1,THMIN2,THMAX2,
     &                ITAG1,ITAG2

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


C  external functions
      DOUBLE PRECISION PHO_RNDM

C  local variables
      DOUBLE PRECISION AN1MAX,AN1MIN,AN2MAX,AN2MIN,AY1,AY2,AYS1,AYS2,
     &  COF1,COF2,CPFTHE,DAY1,DAY2,DELLY,DITRY,DITRW,
     &  ECFRAC,ECMAX2,ECMIN2,EGAM,ELEM,ELEM2,FFL,FFT,FLUXL,FLUXT,
     &  FLXAPP,FLXQPM,GGECM2,P1,P2,PP,PT,PT2,Q21AV2,Q21AVE,Q21MAX,
     &  Q21MIN,Q22AV2,Q22AVE,Q22MAX,Q22MIN,Q2LOG1,Q2LOG2,Q2LOW1,
     &  Q2LOW2,Q2P1,Q2P2,SIF1,SIF2,SIGCUR,SIGMAX,THMAC1,
     &  THMAC2,THMIC1,THMIC2,WEIGHT,WG,WGFX,WGH,WGHAPP,WGHL,WGHQPM,
     &  WGMAX,WGY,X1DEL,X1MAX,X1MIN,X2DEL,X2MAX,X2MIN,Y1,Y2,YEFF1,YEFF2,
     &  YMI,YY1MAX,YY1MIN,YY2MAX,YY2MIN

      INTEGER I,IHEAC1,IHEAC2,IHETRY,IREJ,ITRW_LOW,ITRW_HIGH,ITRY_LOW,
     &  ITRY_HIGH,K,MAX_TAB,NITER,ITG1,ITG2

      DIMENSION P1(4),P2(4),IHETRY(4),IHEAC1(4),IHEAC2(4)
      INTEGER IPHO_PDG2ID



C  initialization of event generation

      IF(NEVENT.EQ.-1) THEN

        DO 10 I=1,4
          IHETRY(I) = 0
          IHEAC1(I) = 0
          IHEAC2(I) = 0
 10     CONTINUE

        WRITE(ErrorOut,'(//1X,A)') 'PHO_GGEPEM: initialization'

C  electron data
        ELEM = 0.512D-03
        ELEM2 = ELEM**2
        AMSRC(1) = ELEM
        AMSRC(2) = ELEM
C  lepton numbers
        IDPSRC(1) = 11
        IDPSRC(2) = -11
        IDBSRC(1) = IPHO_PDG2ID(11)
        IDBSRC(2) = IPHO_PDG2ID(-11)

C  check/update kinematic limitations

        YMI = MIN(YMAX1,1.D0-ELEM/EE1)
        IF(YMI.LT.YMAX1) THEN
          WRITE(ErrorOut,'(/1X,A,2E12.5)')
     &      'PHO_GGEPEM: YMAX1 DECREASED (OLD/NEW)',YMAX1,YMI
          YMAX1 = YMI
        ENDIF
        YMI = MIN(YMAX2,1.D0-ELEM/EE2)
        IF(YMI.LT.YMAX2) THEN
          WRITE(ErrorOut,'(/1X,A,2E12.5)')
     &      'PHO_GGEPEM: YMAX2 DECREASED (OLD/NEW)',YMAX2,YMI
          YMAX2 = YMI
        ENDIF

        YMI = ECMIN**2/(4.D0*EE1*EE2*YMAX2)
        IF(YMIN1.LT.YMI) THEN
          WRITE(ErrorOut,'(/1X,A,2E12.5)')
     &      'PHO_GGEPEM: YMIN1 INCREASED (OLD/NEW)',YMIN1,YMI
          YMIN1 = YMI
        ELSE IF(YMIN1.GT.YMI) THEN
          WRITE(ErrorOut,'(/1X,A,/1X,A,E12.5,A,E12.5)')
     &      'PHO_GGEPEM:','ECM-CUT CORRESPONDS TO YMIN1 OF',YMI,
     &      '  INSTEAD OF',YMIN1
        ENDIF
        YMI = ECMIN**2/(4.D0*EE1*EE2*YMAX1)
        IF(YMIN2.LT.YMI) THEN
          WRITE(ErrorOut,'(/1X,A,2E12.5)')
     &      'PHO_GGEPEM: YMIN2 INCREASED (OLD/NEW)',YMIN2,YMI
          YMIN2 = YMI
        ELSE IF(YMIN2.GT.YMI) THEN
          WRITE(ErrorOut,'(/1X,A,/1X,A,E12.5,A,E12.5)')
     &      'PHO_GGEPEM:','ECM-CUT CORRESPONDS TO YMIN2 OF',YMI,
     &      '  INSTEAD OF',YMIN2
        ENDIF

C  store COS of angular tagging range
        THMIC1 = COS(MAX(0.D0,THMIN1))
        THMAC1 = COS(MIN(THMAX1,PI))
        THMIC2 = COS(MAX(0.D0,THMIN2))
        THMAC2 = COS(MIN(THMAX2,PI))

        X1MAX = LOG(YMAX1)
        X1MIN = LOG(YMIN1)
        X1DEL = X1MAX-X1MIN
        X2MAX = LOG(YMAX2)
        X2MIN = LOG(YMIN2)
        X2DEL = X2MAX-X2MIN

C  debug: integrated photon flux

        IF(IDEB(30).GE.1) THEN
          MAX_TAB = 50
          FLUXT = 0.D0
          FLUXL = 0.D0
          DELLY = LOG(YMAX1/YMIN1)/DBLE(MAX_TAB-1)
          IF(IDEB(30).GE.2) WRITE(ErrorOut,
     * '(1X,2A,I5)') 'PHO_GGEPEM: ',
     &      'TABLE OF PHOTON FLUX (TRANS/LONG SIDE 1)',MAX_TAB
          DO I=1,MAX_TAB
            Y1 = EXP(X1MIN+DELLY*DBLE(I-1))
            IF((1.D0-Y1).GT.1.D-8) THEN
              Q2LOW1 = MAX(Q2MIN1,ELEM2*Y1*Y1/(1.D0-Y1))
            ELSE
              Q2LOW1 = 2.D0*Q2MAX1
            ENDIF
            IF(Q2LOW1.LT.Q2MAX1) THEN
              FFT = ((1.D0+(1.D0-Y1)**2)/Y1*LOG(Q2MAX1/Q2LOW1)
     &        -2.D0*ELEM2*Y1*(1.D0/Q2LOW1-1.D0/Q2MAX1))/(2.D0*PI*137.D0)
              FFL = 2.D0*(1.D0-Y1)*LOG(Q2MAX1/Q2LOW1)/(2.D0*PI*137.D0)
            ELSE
              FFT = 0.D0
              FFL = 0.D0
            ENDIF
            FLUXT = FLUXT + Y1*FFL
            FLUXL = FLUXL + Y1*FFT
            IF(IDEB(30).GE.2) WRITE(ErrorOut,
     * '(5X,1P3E14.4)') Y1,FFT,FFL
          ENDDO
          FLUXT = FLUXT*DELLY
          FLUXL = FLUXL*DELLY
          WRITE(ErrorOut,'(1X,2A,1P2E12.4)') 'PHO_GGEPEM: ',
     &      'INTEGRATED FLUX (TRANS/LONG SIDE 1):',FLUXT,FLUXL
        ENDIF

C  maximum weight

        Q2LOW1 = MAX(Q2MIN1,ELEM2*YMIN1**2/(1.D0-YMIN1))
        Q2LOW2 = MAX(Q2MIN2,ELEM2*YMIN2**2/(1.D0-YMIN2))
        Y1 = YMIN1
        Y2 = YMIN2
        IF(ISWMDL(10).GE.2) THEN
C  long. and transversely polarized photons
          WGMAX = ((1.D0+(1.D0-Y1)**2+2.D0*(1.D0-Y1))*LOG(Q2MAX1/Q2LOW1)
     &           -2.D0*ELEM2*Y1*(1.D0/Q2LOW1-1.D0/Q2MAX1)*Y1)
     &           *((1.D0+(1.D0-Y2)**2+2.D0*(1.D0-Y2))*LOG(Q2MAX2/Q2LOW2)
     &           -2.D0*ELEM2*Y2*(1.D0/Q2LOW2-1.D0/Q2MAX2)*Y2)
        ELSE
C  transversely polarized photons only
          WGMAX = ((1.D0+(1.D0-Y1)**2)*LOG(Q2MAX1/Q2LOW1)
     &           -2.D0*ELEM2*Y1*(1.D0/Q2LOW1-1.D0/Q2MAX1)*Y1)
     &           *((1.D0+(1.D0-Y2)**2)*LOG(Q2MAX2/Q2LOW2)
     &           -2.D0*ELEM2*Y2*(1.D0/Q2LOW2-1.D0/Q2MAX2)*Y2)
        ENDIF

C  initialize gamma-gamma event generator

C  photon 1
        EGAM = YMAX1*EE1
        P1(1) = 0.D0
        P1(2) = 0.D0
        P1(3) = SQRT(EGAM**2-Q2LOW1)
        P1(4) = EGAM
C  photon 2
        EGAM = YMAX2*EE2
        P2(1) = 0.D0
        P2(2) = 0.D0
        P2(3) = -SQRT(EGAM**2-Q2LOW2)
        P2(4) = EGAM
C  sum of helicities
        IGHEL(1) = -1
        IGHEL(2) = -1

C  set min. energy for interpolation tables
        PARMDL(19) = MIN(PARMDL(19),ECMIN)

C  initialize event gneration
        CALL PHO_SETPAR(1,22,0,0.D0)
        CALL PHO_SETPAR(2,22,0,0.D0)
        CALL PHO_EVENT(-1,P1,P2,SIGMAX,IREJ)
        CALL PHO_PHIST(-1,SIGMAX)
        CALL PHO_LHIST(-1,SIGMAX)

C  generation of events, flux calculation

        ECMIN2 = ECMIN**2
        ECMAX2 = ECMAX**2
        ECFRAC = ECMIN2/(4.D0*EE1*EE2)
        AY1  = 0.D0
        AY2  = 0.D0
        AYS1 = 0.D0
        AYS2 = 0.D0
        Q21MIN = 1.D30
        Q22MIN = 1.D30
        Q21MAX = 0.D0
        Q22MAX = 0.D0
        Q21AVE = 0.D0
        Q22AVE = 0.D0
        Q21AV2 = 0.D0
        Q22AV2 = 0.D0
        AN1MIN = 1.D30
        AN2MIN = 1.D30
        AN1MAX = 0.D0
        AN2MAX = 0.D0
        YY1MIN = 1.D30
        YY2MIN = 1.D30
        YY1MAX = 0.D0
        YY2MAX = 0.D0
        NITER = 0
        ITRY_LOW = 0
        ITRY_HIGH = 0
        ITRW_LOW = 0
        ITRW_HIGH = 0

C  generate NEVENT events (might be just 1 per call)

      ELSE IF(NEVENT.GT.0) THEN

        NITER = NITER+NEVENT

        DO 200 I=1,NEVENT

C  sample y1, y2
 150      CONTINUE
          ITRY_LOW = ITRY_LOW+1
          IF(ITRY_LOW.EQ.1000000) THEN
            ITRY_LOW = 0
            ITRY_HIGH = ITRY_HIGH+1
          ENDIF

 175      CONTINUE
            ITRW_LOW = ITRW_LOW+1
            IF(ITRW_LOW.EQ.1000000) THEN
              ITRW_LOW = 0
              ITRW_HIGH = ITRW_HIGH+1
            ENDIF

            Y1 = EXP(X1DEL*PHO_RNDM(AY1)+X1MIN)
            Y2 = EXP(X2DEL*PHO_RNDM(AY2)+X2MIN)
            IF(Y1*Y2.LT.ECFRAC) GOTO 175
            IF(ISWMDL(10).GE.2) THEN
              YEFF1 = 1.D0+(1.D0-Y1)**2+2.D0*(1.D0-Y1)
              YEFF2 = 1.D0+(1.D0-Y2)**2+2.D0*(1.D0-Y2)
            ELSE
              YEFF1 = 1.D0+(1.D0-Y1)**2
              YEFF2 = 1.D0+(1.D0-Y2)**2
            ENDIF

            Q2LOW1 = MAX(Q2MIN1,ELEM2*Y1**2/(1.D0-Y1))
            Q2LOW2 = MAX(Q2MIN2,ELEM2*Y2**2/(1.D0-Y2))
            Q2LOG1 = LOG(Q2MAX1/Q2LOW1)
            Q2LOG2 = LOG(Q2MAX2/Q2LOW2)
            WGH = (YEFF1*Q2LOG1
     &             -2.D0*ELEM2*Y1*(1.D0/Q2LOW1-1.D0/Q2MAX1)*Y1)
     &           *(YEFF2*Q2LOG2
     &             -2.D0*ELEM2*Y2*(1.D0/Q2LOW2-1.D0/Q2MAX2)*Y2)
            IF(WGMAX.LT.WGH) THEN
              WRITE(ErrorOut,'(1X,A,4E12.5)')
     &          'PHO_GGEPEM: INCONSISTENT WEIGHT:',Y1,Y2,WGMAX,WGH
            ENDIF
          IF(PHO_RNDM(AYS1)*WGMAX.GT.WGH) GOTO 175



C  limit on Ecm_gg (app. cut, precise cut applied later)
          GGECM2 = 4.D0*Y1*Y2*EE1*EE2
          IF(GGECM2.LT.ECMIN2) GOTO 175

C  sample Q2
          IF(IPAMDL(174).EQ.1) THEN
 185        CONTINUE
              Q2P1 = Q2LOW1*EXP(Q2LOG1*PHO_RNDM(Y1))
              WEIGHT = (YEFF1-2.D0*(1.D0-Y1)*Q2LOW1/Q2P1)/YEFF1
            IF(WEIGHT.LT.PHO_RNDM(Q2P1)) GOTO 185
          ELSE
            Q2P1 = Q2LOW1
          ENDIF

          IF(IPAMDL(174).EQ.1) THEN
 186        CONTINUE
              Q2P2 = Q2LOW2*EXP(Q2LOG2*PHO_RNDM(Y2))
              WEIGHT = (YEFF2-2.D0*(1.D0-Y2)*Q2LOW2/Q2P2)/YEFF2
            IF(WEIGHT.LT.PHO_RNDM(Q2P2)) GOTO 186
          ELSE
            Q2P2 = Q2LOW2
          ENDIF

          GYY(1) = Y1
          GQ2(1) = Q2P1
          GYY(2) = Y2
          GQ2(2) = Q2P2

C  incoming electron 1
          PINI(1,1) = 0.D0
          PINI(2,1) = 0.D0
          PINI(3,1) = EE1*(1.D0-0.5D0*ELEM2/EE1**2)
          PINI(4,1) = EE1
          PINI(5,1) = ELEM
C  photon 1
          PP = (2.D0*EE1**2*Y1+Q2P1)/(2.D0*PINI(3,1))
          PT2 = (EE1**2*(Q2P1*(1.D0-Y1)-ELEM2*Y1**2)
     &         -0.25D0*Q2P1**2-Q2P1*ELEM2)/PINI(3,1)**2
          IF(PT2.LT.0.D0) GOTO 175
          PT = SQRT(PT2)
          CALL PHO_SFECFE(SIF1,COF1)
          P1(1) = COF1*PT
          P1(2) = SIF1*PT
          P1(3) = PP
          P1(4) = EE1*Y1
C  outgoing electron 1
          PFIN(1,1) = -P1(1)
          PFIN(2,1) = -P1(2)
          PFIN(3,1) = PINI(3,1)-P1(3)
          PFIN(4,1) = PINI(4,1)-P1(4)
          PFIN(5,1) = ELEM
C  incoming electron 2
          PINI(1,2) = 0.D0
          PINI(2,2) = 0.D0
          PINI(3,2) = -EE2*(1.D0-0.5D0*ELEM2/EE2**2)
          PINI(4,2) = EE2
          PINI(5,2) = 0.D0
C  photon 2
          PP = (2.D0*EE2**2*Y2+Q2P2)/(2.D0*PINI(3,2))
          PT2 = (EE2**2*(Q2P2*(1.D0-Y2)-ELEM2*Y2**2)
     &         -0.25D0*Q2P2**2-Q2P2*ELEM2)/PINI(3,2)**2
          IF(PT2.LT.0.D0) GOTO 175
          PT = SQRT(PT2)
          CALL PHO_SFECFE(SIF2,COF2)
          P2(1) = COF2*PT
          P2(2) = SIF2*PT
          P2(3) = PP
          P2(4) = EE2*Y2
C  outgoing electron 2
          PFIN(1,2) = -P2(1)
          PFIN(2,2) = -P2(2)
          PFIN(3,2) = PINI(3,2)-P2(3)
          PFIN(4,2) = PINI(4,2)-P2(4)
          PFIN(5,2) = ELEM

C  precise ECMS cut

          GGECM2 = (P1(4)+P2(4))**2-(P1(1)+P2(1))**2
     &           -(P1(2)+P2(2))**2-(P1(3)+P2(3))**2
          IF((GGECM2.LT.ECMIN2).OR.(GGECM2.GT.ECMAX2)) GOTO 175
          GGECM = SQRT(GGECM2)

C  beam lepton detector acceptance

C  lepton tagger 1
          CPFTHE = PFIN(3,1)/PFIN(4,1)
          ITG1 = 0
          IF(PFIN(4,1).GE.EEMIN1) THEN
            IF((CPFTHE.LE.THMIC1).AND.(CPFTHE.GE.THMAC1)) ITG1 = 1
          ENDIF

C  lepton tagger 2
          CPFTHE = PFIN(3,2)/PFIN(4,2)
          ITG2 = 0
          IF(PFIN(4,2).GE.EEMIN2) THEN
            IF((CPFTHE.LE.THMIC2).AND.(CPFTHE.GE.THMAC2)) ITG2 = 1
          ENDIF

C  beam lepton taggers

C  anti-tag
          IF((ITAG1.EQ.-1).AND.(ITG1.NE.0)) GOTO 175
          IF((ITAG2.EQ.-1).AND.(ITG2.NE.0)) GOTO 175
C  tag
          IF((ITAG1.EQ.1).AND.(ITG1.EQ.0)) GOTO 175
          IF((ITAG2.EQ.1).AND.(ITG2.EQ.0)) GOTO 175
C  single-tag inclusive
          IF((ITAG1.EQ.0).AND.(ITAG2.EQ.0).AND.(ITG1+ITG2.EQ.0))
     &      GOTO 175
C  single-tag/anti-tag
          IF((ITAG1.EQ.2).AND.(ITAG2.EQ.2).AND.(ITG1+ITG2.NE.1))
     &      GOTO 175

          PGAM(1,1) = P1(1)
          PGAM(2,1) = P1(2)
          PGAM(3,1) = P1(3)
          PGAM(4,1) = P1(4)
          PGAM(5,1) = -SQRT(Q2P1)
          PGAM(1,2) = P2(1)
          PGAM(2,2) = P2(2)
          PGAM(3,2) = P2(3)
          PGAM(4,2) = P2(4)
          PGAM(5,2) = -SQRT(Q2P2)

C  photon helicities
          IF(ISWMDL(10).GE.2) THEN
            WGH  = YEFF1-2.D0*ELEM2*Y1**2/Q2P1
            WGHL = 2.D0*(1-Y1)
            IF(PHO_RNDM(Y1).GT.WGHL/WGH) THEN
              IGHEL(1) = 1
            ELSE
              IGHEL(1) = 0
            ENDIF
            WGH  = YEFF2-2.D0*ELEM2*Y2**2/Q2P2
            WGHL = 2.D0*(1-Y2)
            IF(PHO_RNDM(Y2).GT.WGHL/WGH) THEN
              IGHEL(2) = 1
            ELSE
              IGHEL(2) = 0
            ENDIF
            K = 2*IGHEL(1)+IGHEL(2)+1
            IHETRY(K) = IHETRY(K)+1
          ELSE
            IGHEL(1) = -1
            IGHEL(2) = -1
          ENDIF

C  user cuts
          CALL PHO_PRESEL(5,IREJ)
          IF(IREJ.NE.0) GOTO 175

          WGFX = 1.D0
C  reweight according to LO photon emission diagrams (Budnev et al.)
          IF(IPAMDL(116).GE.1) THEN
            CALL PHO_WGEPEM(FLXAPP,FLXQPM,0)
            WGFX = FLXQPM/FLXAPP
            IF(WGFX.GT.1.D0) THEN
              WRITE(ErrorOut,'(1x,a,/,5x,1p,5e11.4)')
     &          ' PHO_GGEPEM: FLUX WEIGHT > 1 (Y1/2,Q21/2,W)',
     &          Y1,Y2,Q2P1,Q2P2,GGECM
            ENDIF
          ENDIF

C  event generation
*         IVWGHT(1) = 1
*         EVWGHT(1) = MAX(WGFX,1.D0)
          CALL PHO_EVENT(1,P1,P2,SIGCUR,IREJ)
          IF(IREJ.NE.0) GOTO 150
          IF(ISWMDL(10).GE.2) THEN
            K = 2*IGHEL(1)+IGHEL(2)+1
            IHEAC1(K) = IHEAC1(K)+1
          ENDIF

C  reweight according to QPM model (e+e- collider only)
          IF((KHDIR.GT.0).AND.
     &      (IPAMDL(116).GE.2).AND.(ISWMDL(10).GE.2)) THEN
            CALL PHO_WGEPEM(WGHAPP,WGHQPM,1)
            WG = WGHQPM/WGHAPP/MAX(1.D0,WGFX)
            IF(PHO_RNDM(WG).GT.WG) GOTO 150
          ELSE IF(IPAMDL(116).GE.1) THEN
            IF(PHO_RNDM(WG).GT.WGFX) GOTO 150
          ENDIF

C  polar angle
          PFTHE(1) = ACOS(PFIN(3,1)/PFIN(4,1))
          PFTHE(2) = ACOS(PFIN(3,2)/PFIN(4,2))
C  azimuthal angle
          PFPHI(1) = ATAN2(COF1,SIF1)
          PFPHI(2) = ATAN2(COF2,SIF2)

C  statistics
          AY1  = AY1+Y1
          AYS1 = AYS1+Y1*Y1
          AY2  = AY2+Y2
          AYS2 = AYS2+Y2*Y2
          Q21MIN = MIN(Q21MIN,Q2P1)
          Q22MIN = MIN(Q22MIN,Q2P2)
          Q21MAX = MAX(Q21MAX,Q2P1)
          Q22MAX = MAX(Q22MAX,Q2P2)
          AN1MIN = MIN(AN1MIN,PFTHE(1))
          AN2MIN = MIN(AN2MIN,PFTHE(2))
          AN1MAX = MAX(AN1MAX,PFTHE(1))
          AN2MAX = MAX(AN2MAX,PFTHE(2))
          YY1MIN = MIN(YY1MIN,Y1)
          YY2MIN = MIN(YY2MIN,Y2)
          YY1MAX = MAX(YY1MAX,Y1)
          YY2MAX = MAX(YY2MAX,Y2)
          Q21AVE = Q21AVE+Q2P1
          Q22AVE = Q22AVE+Q2P2
          Q21AV2 = Q21AV2+Q2P1*Q2P1
          Q22AV2 = Q22AV2+Q2P2*Q2P2
          IF(ISWMDL(10).GE.2) THEN
            K = 2*IGHEL(1)+IGHEL(2)+1
            IHEAC2(K) = IHEAC2(K)+1
          ENDIF

C  external histograms
          CALL PHO_PHIST(1,HSWGHT(0))
          CALL PHO_LHIST(1,HSWGHT(0))
 200    CONTINUE

C  final cross section calculation and event generation summary

      ELSE IF(NEVENT.EQ.-2) THEN

*       EVWGHT(1) = 1.D0
*       IVWGHT(1) = 0
        DITRY = DBLE(ITRY_HIGH)*1.D+6+DBLE(ITRY_LOW)
        DITRW = DBLE(ITRW_HIGH)*1.D+6+DBLE(ITRW_LOW)
        WGY  = WGMAX*DITRY/DITRW/(137.D0*2.D0*PI)**2
        WGY  = WGY*LOG(YMAX1/YMIN1)*LOG(YMAX2/YMIN2)
        AY1  = AY1/DBLE(NITER)
        AYS1 = AYS1/DBLE(NITER)
        DAY1 = SQRT((AYS1-AY1**2)/DBLE(NITER))
        AY2  = AY2/DBLE(NITER)
        AYS2 = AYS2/DBLE(NITER)
        DAY2 = SQRT((AYS2-AY2**2)/DBLE(NITER))
        Q21AVE = Q21AVE/DBLE(NITER)
        Q21AV2 = Q21AV2/DBLE(NITER)
        Q21AV2 = SQRT((Q21AV2-Q21AVE**2)/DBLE(NITER))
        Q22AVE = Q22AVE/DBLE(NITER)
        Q22AV2 = Q22AV2/DBLE(NITER)
        Q22AV2 = SQRT((Q22AV2-Q22AVE**2)/DBLE(NITER))
        WEIGHT = WGY*SIGMAX*DBLE(NITER)/DITRY
        EE1 = WEIGHT
        EE2 = SIGMAX*DBLE(NITER)/DITRY

C  output of statistics, histograms
        WRITE(ErrorOut,'(//1X,A,/1X,A,1PE12.3,A,/1X,A)')
     &    '=========================================================',
     &    ' *****   SIMULATED CROSS SECTION: ',WEIGHT,' MB  *****',
     &    '========================================================='
        WRITE(ErrorOut,'(//1X,A,I10,1p,2e14.6)')
     &    'PHO_GGEPEM:SUMMARY: NITER,ITRY,ITRW',NITER,DITRY,DITRW
        WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'effective weight (FLUX,TOTAL)',
     &    WGY,WEIGHT
        WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'average Y1,DY1               ',
     &    AY1,DAY1
        WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'average Y2,DY2               ',
     &    AY2,DAY2
        WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'sampled Y range photon 1     ',
     &    YY1MIN,YY1MAX
        WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'sampled Y range photon 2     ',
     &    YY2MIN,YY2MAX
        WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'average Q2,DQ2 photon 1      ',
     &    Q21AVE,Q21AV2
        WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'sampled Q2 range photon 1    ',
     &    Q21MIN,Q21MAX
        WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'average Q2,DQ2  photon 2     ',
     &    Q22AVE,Q22AV2
        WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'sampled Q2 range photon 2    ',
     &    Q22MIN,Q22MAX
        WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'sampled THETA range electron1',
     &    AN1MIN,AN1MAX
        WRITE(ErrorOut,
     * '(1X,A,1P4E12.4)') 'sampled THETA range electron2',
     &    AN2MIN,AN2MAX,PI-AN2MAX,PI-AN2MIN

        IF(ISWMDL(10).GE.2) THEN
          WRITE(ErrorOut,'(/1X,A,3(/1X,A,4I12))')
     &    'HELICITY DECOMPOSITION:    0 0      0 1      1 0       1 1',
     &    'TRIED:        ',IHETRY,
     &    'ACCEPTED (1): ',IHEAC1,
     &    'ACCEPTED (2): ',IHEAC2
        ENDIF

        CALL PHO_EVENT(-2,P1,P2,WEIGHT,IREJ)
        IF(NITER.GT.1) THEN
          CALL PHO_PHIST(-2,WEIGHT)
          CALL PHO_LHIST(-2,WEIGHT)
        ELSE
          WRITE(ErrorOut,'(1X,A,I4)')
     &      'PHO_GGEPEM: NO OUTPUT OF HISTOGRAMS',NITER
        ENDIF



      ENDIF

      END


CDECK  ID>, PHO_WGEPEM
      SUBROUTINE PHO_WGEPEM(WGHAPP,WGHQPM,IMODE)
C**********************************************************************
C
C     calculate cross section weights for
C      fully differential equivalent (improved) photon approximation
C     and/or
C      fully differential QPM model with exact one-photon exchange graphs
C
C     (unpolarized lepton beams)
C
C     input:     IMODE     0   flux calculation only
C                          1   flux folded with QPM cross section
C                /POFSRC/  photon and electron momenta
C                /POPRCS/  process type
C                /POCKIN/  kinematics of hard scattering
C
C     output:    WGHAPP  weight of event according to approximation
C                WGHQPM  weight of event according to one-photon exchange
C
C**********************************************************************

      IMPLICIT NONE
#include "Zmanagerp.h"

      SAVE

      DOUBLE PRECISION WGHAPP,WGHQPM
      INTEGER IMODE

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  data on most recent hard scattering
      INTEGER IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC
      DOUBLE PRECISION PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                 PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,QQPD,QQAL,
     &                 PDF1,PDF2,WEIGHT,PHI1,PHI2,PHO1,PHO2
      COMMON /POCKIN/ PTWANT,AS,AH,ALNS,ALNH,Z1MAX,Z1DIF,Z2MAX,Z2DIF,
     &                PT,PTFIN,ETAC,ETAD,X1,X2,V,U,W,W1,AXX,
     &                QQPD,QQAL,PDF1(-6:6),PDF2(-6:6),WEIGHT,
     &                PHI1(5),PHI2(5),PHO1(5),PHO2(5),
     &                IA,IB,IC,ID,IV1,IV2,MSPR,IREJSC

C  hard scattering parameters used for most recent hard interaction
      INTEGER NFBETA,NF
      DOUBLE PRECISION ALQCD2,BQCD
      COMMON /POHAPA/ ALQCD2(3,4),BQCD(4),NFBETA,NF

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)



      DOUBLE PRECISION AA,ALPHA1,ALPHA2,BB,CC,CCAP,DD,FAC,HELFLX,
     &  P1,P1P2,P1Q2,P2,P2Q1,Q1KK,Q1Q2,Q2,Q2KK,QC2,RHO100,RHO1PP,
     &  RHO200,RHO2PP,RHOP08,RHOPM2,RR,SH,SIGQPM,SP,SS,SW0000,SW0P0M,
     &  SW0P0P,SW0PM0,SWP00P,SWP0M0,SWP0P0,SWPMPM,SWPP00,SWPPMM,SWPPPP,
     &  TH,TP,UH,W2,WGHEQ,WGHQQ,XCAP,XK1,XK2,XKAM,XKAP,
     &  XM2,XQ2,XTM1,XTM2,XTM3,YCAP
      DOUBLE PRECISION PHO_ALPHAS,PHO_ALPHAE

      INTEGER I,I1,I2,IDIR,IPFL1,IPFL2,IPOS,K

      DIMENSION WGHEQ(2),XM2(2),P1(4),P2(4),XK1(4),XK2(4)
      DIMENSION HELFLX(6),SIGQPM(6)

      WGHAPP = 1.D0
      WGHQPM = 0.D0

C  strict pt cutoff after putting partons on mass shell,
C  calculated in gamma-gamma CMS
      IF((IMODE.EQ.1).AND.(IPAMDL(121).GT.0)) THEN
        IF(PTFIN.LT.PTWANT) THEN
          IF(IPAMDL(121).GT.1) RETURN
          IF((IPAMDL(121).EQ.1).AND.(MSPR.EQ.14)) RETURN
        ENDIF
      ENDIF

C  cross section of sampled event (approximate treatment)

C  photon flux
      DO 50 K=1,2
        XM2(K) = AMSRC(K)**2
        IF(ABS(IGHEL(K)).EQ.1) THEN
          WGHEQ(K) = ((1.D0+(1.D0-GYY(K))**2)/GYY(K)
     &              -2.D0*XM2(K)*GYY(K)/GQ2(K))/(137.D0*2.D0*PI*GQ2(K))
        ELSE
          WGHEQ(K) = (1.D0-GYY(K))/GYY(K)/(137.D0*PI*GQ2(K))
        ENDIF
 50   CONTINUE

      W2 = GGECM*GGECM
      IDIR   = 0
      WGHQQ  = 1.D0

C  direct or single-resolved gam-gam interaction
      IF((IMODE.GE.1).AND.
     &   (IPROCE.EQ.8).AND.(MSPR.GE.10)) THEN
        IDIR   = 1
        WGHQQ = 0.D0
C  determine final state partons
        DO 100 I=3,NHEP
          IF(ISTHEP(I).EQ.25) GOTO 110
 100    CONTINUE
        WRITE(ErrorOut,'(/1X,2A,I5)') 'PHO_WGEPEM:ERROR: ',
     &    'INCONSISTENT PROCESS INFORMATION (MSPR)',MSPR
        CALL PHO_ABORT
 110    CONTINUE
        IPOS = I
C  final state flavors
        IPFL1 = ABS(IDHEP(IPOS+3))
        IPFL2 = ABS(IDHEP(IPOS+4))
        SH = X1*X2*W2
C  calculate alpha-em
        ALPHA1 = PHO_ALPHAE(QQAL)
C  calculate alpha-s
        IF(MSPR.LT.14) THEN
          ALPHA2 = PHO_ALPHAS(QQAL,3)
        ENDIF
C  LO matrix element (8 pi s dsig/dt)
*       QC2 = 4.D0/9.D0 - DBLE(MOD(IPFL2,2))*3.D0/9.D0
        QC2 = Q_CH2(IPFL2)
        IF(IPFL2.EQ.0) THEN
          WRITE(ErrorOut,
     * '(1X,2A,/,5X,A,I12,I3,4I4)') 'PHO_WGEPEM:ERROR: ',
     &      'INVALID HARD PROCESS - FLAVOR COMBINATION',
     &      'EVENT,MSPR,IA,IB,IC,ID:',KEVENT,MSPR,IA,IB,IC,ID
        ENDIF
        IF(MSPR.EQ.10) THEN
          WGHQQ  = -8.D0*PI/(3.D0*SH**2)*ALPHA1*QC2*ALPHA2*(U**2+1.D0)/U
     &            *8.D0*PI*SH
        ELSE IF(MSPR.EQ.11) THEN
          WGHQQ  = PI/SH**2*ALPHA1*QC2*ALPHA2*(V**2+U**2)/(U*V)
     &            *8.D0*PI*SH
        ELSE IF(MSPR.EQ.12) THEN
          WGHQQ  = -8.D0*PI/(3.D0*SH**2)*ALPHA1*QC2*ALPHA2*(V**2+1.D0)/V
     &            *8.D0*PI*SH
        ELSE IF(MSPR.EQ.13) THEN
          WGHQQ  = PI/SH**2*ALPHA1*QC2*ALPHA2*(V**2+U**2)/(U*V)
     &            *8.D0*PI*SH
        ELSE IF(MSPR.EQ.14) THEN
          WGHQQ  = 6.D0*PI/SH**2*(ALPHA1*QC2)**2*(V**2+U**2)/(U*V)
     &            *8.D0*PI*SH
        ENDIF
      ENDIF

C  fully differential cross section dsig/(dQ_^2 dQ_2^2 dy_1 dy_2 dphi)
      WGHAPP = WGHEQ(1)*WGHEQ(2)*WGHQQ/(2.D0*PI)

C  full leading-order QPM prediction (Budnev et al.)

C  full two-gamma flux

      P1Q2 = PINI(4,1)*PGAM(4,2)-PINI(1,1)*PGAM(1,2)
     &      -PINI(2,1)*PGAM(2,2)-PINI(3,1)*PGAM(3,2)
      P2Q1 = PINI(4,2)*PGAM(4,1)-PINI(1,2)*PGAM(1,1)
     &      -PINI(2,2)*PGAM(2,1)-PINI(3,2)*PGAM(3,1)
      Q1Q2 = PGAM(4,1)*PGAM(4,2)-PGAM(1,1)*PGAM(1,2)
     &      -PGAM(2,1)*PGAM(2,2)-PGAM(3,1)*PGAM(3,2)
      P1P2 = PINI(4,1)*PINI(4,2)-PINI(1,1)*PINI(1,2)
     &      -PINI(2,1)*PINI(2,2)-PINI(3,1)*PINI(3,2)
      DO 120 I=1,4
        P1(I) = 2.D0*PINI(I,1)-PGAM(I,1)
        P2(I) = 2.D0*PINI(I,2)-PGAM(I,2)
 120  CONTINUE
      XTM1 = 2.D0*P1Q2-Q1Q2
      XTM2 = 2.D0*P2Q1-Q1Q2
      XTM3 = P1(4)*P2(4)-P1(1)*P2(1)-P1(2)*P2(2)-P1(3)*P2(3)
      XCAP = Q1Q2**2-GQ2(1)*GQ2(2)
      YCAP = P1P2**2-XM2(1)*XM2(2)
      CCAP = -XTM3 + Q1Q2*XTM1*XTM2/XCAP

      RHO1PP = (XTM1**2/XCAP+1.D0-4.D0*XM2(1)/GQ2(1))/2.D0
      RHO2PP = (XTM2**2/XCAP+1.D0-4.D0*XM2(2)/GQ2(2))/2.D0
      RHO100 = XTM1**2/XCAP-1.D0
      RHO200 = XTM2**2/XCAP-1.D0
      RHOPM2 = CCAP**2/(GQ2(1)*GQ2(2))-2.D0*(RHO1PP-1.D0)*(RHO2PP-1.D0)
      RHOP08 = 4.D0*XTM1*XTM2*CCAP/XCAP/SQRT(GQ2(1)*GQ2(2))
      SS     = 2.D0*P1P2+XM2(1)+XM2(2)

      HELFLX(1) = 4.D0*RHO1PP*RHO2PP
      HELFLX(2) = RHOPM2
      HELFLX(3) = 2.D0*RHO1PP*RHO200
      HELFLX(4) = 2.D0*RHO100*RHO2PP
      HELFLX(5) = RHO100*RHO200
      HELFLX(6) = -RHOP08

C  only flux calculation

      IF(IDIR.EQ.0) THEN
        IF((IGHEL(1).EQ.1).AND.(IGHEL(2).EQ.1)) THEN
          WEIGHT = HELFLX(1)
        ELSE IF((IGHEL(1).EQ.1).AND.(IGHEL(2).EQ.0)) THEN
          WEIGHT = HELFLX(3)
        ELSE IF((IGHEL(1).EQ.0).AND.(IGHEL(2).EQ.1)) THEN
          WEIGHT = HELFLX(4)
        ELSE IF((IGHEL(1).EQ.0).AND.(IGHEL(2).EQ.0)) THEN
          WEIGHT = HELFLX(5)
        ELSE IF((IGHEL(1).EQ.-1).AND.(IGHEL(2).EQ.-1)) THEN
          WEIGHT = HELFLX(1)
        ELSE
          WRITE(ErrorOut,'(/1X,A,2I3)')
     &      'PHO_GGEPEM:ERROR: INVALID PHOTON HELICITIES: ',IGHEL
          WRITE(ErrorOut,'(1X,A,I12)')
     &      'PHO_GGEPEM: EVENT REJECTED (KEVENT)',KEVENT
          WEIGHT = 0.D0
        ENDIF

C  fully differential cross section dsig/(dQ_^2 dQ_2^2 dy_1 dy_2 dphi)
        WGHQPM = WEIGHT/(137.D0**2*16.D0*PI**4*GQ2(1)*GQ2(2))
     &          *SQRT(XCAP/YCAP)*PI*SS/(2.D0*YCAP)*PINI(4,1)*PINI(4,2)

      ELSE

C  flux folded with cross section
C  polarized, leading order gam gam --> q qbar cross sections

        DO 125 I=1,6
          SIGQPM(I) = 0.D0
 125    CONTINUE
C  momenta of produced parton pair
        I1 = IPOS+3
        I2 = IPOS+4
        DO 150 K=1,4
          XK1(K) = PHEP(K,I1)
          XK2(K) = PHEP(K,I2)
 150    CONTINUE
        XQ2 = PHEP(5,I2)**2

        IF(MSPR.EQ.14) THEN
C  direct photon-photon interaction
          XKAP = XQ2-(PGAM(4,1)-XK1(4))**2
     &          +(PGAM(1,1)-XK1(1))**2+(PGAM(2,1)-XK1(2))**2
     &          +(PGAM(3,1)-XK1(3))**2
          XKAM = XQ2-(PGAM(4,1)-XK2(4))**2
     &          +(PGAM(1,1)-XK2(1))**2+(PGAM(2,1)-XK2(2))**2
     &          +(PGAM(3,1)-XK2(3))**2
          CC = Q1Q2
          AA = XKAP*XKAM-GQ2(1)*GQ2(2)
          BB = CC**2-XKAP*XKAM
          DD = CC**2-GQ2(1)*GQ2(2)
          RR = -XQ2+W2*AA/(4.D0*DD)
          Q1KK = Q1Q2-GQ2(1)
          Q2KK = Q1Q2-GQ2(2)
          FAC = 192.D0*(PI*ALPHA1*QC2/(XKAP*XKAM))**2/(4.D0*SQRT(XCAP))

        ELSE
C  single-resolved photon-hadron interactions
C  Mandelstam variables
          IF(MSPR.LE.11) THEN
            TH = (PGAM(4,1)-XK1(4))**2-(PGAM(1,1)-XK1(1))**2
     &          -(PGAM(2,1)-XK1(2))**2-(PGAM(3,1)-XK1(3))**2
            UH = (PGAM(4,1)-XK2(4))**2-(PGAM(1,1)-XK2(1))**2
     &          -(PGAM(2,1)-XK2(2))**2-(PGAM(3,1)-XK2(3))**2
          ELSE
            TH = (PGAM(4,2)-XK2(4))**2-(PGAM(1,2)-XK2(1))**2
     &          -(PGAM(2,2)-XK2(2))**2-(PGAM(3,2)-XK2(3))**2
            UH = (PGAM(4,2)-XK1(4))**2-(PGAM(1,2)-XK1(1))**2
     &          -(PGAM(2,2)-XK1(2))**2-(PGAM(3,2)-XK1(3))**2
          ENDIF
          V = TH/SH
          U = UH/SH
        ENDIF

        WEIGHT = 0.D0
        IF((IGHEL(1).EQ.1).AND.(IGHEL(2).EQ.1)) THEN
          IF((MSPR.EQ.10).OR.(MSPR.EQ.12)) THEN
            IF(MSPR.EQ.10) THEN
              Q2 = -GQ2(1)
              SP = SH-XQ2
              TP = UH-XQ2
            ELSE
              Q2 = -GQ2(2)
              SP = SH-XQ2
              TP = TH-XQ2
            ENDIF
            SIGQPM(1)= -32.D0*PI**2*4.D0/3.D0*ALPHA1*QC2*ALPHA2
     &        *(SP*TP*(2.D0*Q2**4-4.D0*Q2*SP**3-2.D0*Q2**3*(3*SP+TP)
     &        +SP**2*(SP**2+TP**2)+Q2**2*(7.D0*SP**2+2.D0*SP*TP+TP**2))
     &       -2.D0*(2.D0*SP**3*TP*(SP+TP)+Q2**3*(SP**2+6.D0*SP*TP+TP**2)
     &        -2.D0*Q2**2*SP*(SP**2+4.D0*SP*TP+3.D0*TP**2)+Q2*SP*
     &        (SP**3+SP**2*TP-SP*TP**2+TP**3))*XQ2 +
     &        4.D0*(2.D0*Q2**2-SP**2)*(SP+TP)**2*XQ2**2)/
     &        (SP**2*TP**2*((Q2-SP)**2-4.D0*Q2*XQ2))
            WEIGHT = HELFLX(1)*SIGQPM(1)/(2.D0*(SH+GQ2(1)+GQ2(2)))
          ELSE IF((MSPR.EQ.11).OR.(MSPR.EQ.13)) THEN
            IF(MSPR.EQ.11) THEN
              Q2 = -GQ2(1)
            ELSE
              Q2 = -GQ2(2)
            ENDIF
            SP = SH
            TP = UH
            SIGQPM(1) = -32.D0*PI**2/2.D0*ALPHA1*QC2*ALPHA2
     &        *(-((Q2**2+SP**2)*TP*(Q2**3-SP**3-3.D0*SP**2*TP
     &        - 4.D0*SP*TP**2 - 2.D0*TP**3 - 3.D0*Q2**2*(SP + TP) + Q2*
     &            (3.D0*SP**2 + 6.D0*SP*TP + 4.D0*TP**2))) +
     &        (3.D0*Q2**5 - Q2**4*(11.D0*SP + 10.D0*TP) +
     &         4.D0*Q2**3*(4.D0*SP**2 + 5.D0*SP*TP + 4.D0*TP**2)
     &        +Q2*SP**2*(5.D0*SP**2+4.D0*SP*TP+8.D0*TP**2)-4.D0*Q2**2
     &        *(3.D0*SP**3+3.D0*SP**2*TP+4.D0*SP*TP**2+2.D0*TP**3)-
     &        SP**2*(SP**3+2.D0*SP**2*TP+8.D0*SP*TP**2+8.D0*TP**3))*XQ2+
     &        (11.D0*Q2**4-10.D0*Q2**3*(3.D0*SP+2.D0*TP)-2.D0*Q2*SP**2
     &        *(7.D0*SP+2.D0*TP)+2.D0*Q2**2*(15.D0*SP**2+10.D0*SP*TP
     &        +6.D0*TP**2)+SP**2*(3.D0*SP**2+4.D0*SP*TP+12.D0*TP**2))
     &        *XQ2**2+8.D0*(Q2**3-SP**2*TP-Q2**2*(SP+TP))*XQ2**3+
     &        2.D0*(Q2**2+SP**2)*XQ2**4)/((Q2-SP)**2*(-TP+XQ2)**2*
     &        (Q2-SP-TP+XQ2)**2)
            WEIGHT = HELFLX(1)*SIGQPM(1)/(2.D0*(SH+GQ2(1)+GQ2(2)))
          ELSE IF(MSPR.EQ.14) THEN
            SWPMPM = 4.D0*CC**2*RR*(W2-2.D0*RR)
            SWPPPP = SWPMPM +2.D0*(CC**2+BB)*(AA-4.D0*RR*CC)
            SWPPMM = 8.D0*RR*CC*(XKAP*XKAM-RR*CC)
     &              -2.D0*XKAP*XKAM*AA
            SIGQPM(1) = (SWPPPP+SWPMPM)/2.D0*FAC
            SIGQPM(2) = SWPPMM*FAC
            WEIGHT = HELFLX(1)*SIGQPM(1)
     &              +HELFLX(2)*SIGQPM(2)
          ENDIF
        ELSE IF((IGHEL(1).EQ.1).AND.(IGHEL(2).EQ.0)) THEN
          IF(MSPR.EQ.12) THEN
            Q2 = -GQ2(2)
            SP = SH-XQ2
            TP = TH-XQ2
            SIGQPM(3) = 32.D0*PI**2*8.D0/3.D0*ALPHA1*QC2*ALPHA2
     &               *Q2*(-(SP**2*TP**2*(-Q2 + SP + TP)) +
     &               SP*TP*(2.D0*Q2**2 + 3.D0*SP**2 + 2.D0*SP*TP -
     &               TP**2 - 2.D0*Q2*(3*SP + TP))*XQ2 -
     &               2.D0*(Q2*(SP**2 + 6.D0*SP*TP + TP**2) -
     &               2.D0*SP*(SP**2 + 4.D0*SP*TP + 3.D0*TP**2))*
     &               XQ2**2 + 8.D0*(SP + TP)**2*XQ2**3)/
     &               (SP**2*TP**2*((Q2 - SP)**2 - 4.D0*Q2*XQ2))
            WEIGHT = HELFLX(3)*SIGQPM(3)/(2.D0*(SH+GQ2(2)))
          ELSE IF(MSPR.EQ.13) THEN
            Q2 = -GQ2(2)
            SP = SH
            TP = TH
            SIGQPM(3) = 32.D0*PI**2*2.D0*ALPHA1*QC2*ALPHA2
     &        *(-Q2*(SP*TP*(-Q2+SP+TP)+(Q2**2-Q2*SP-2*SP*TP)*XQ2 +
     &        SP*XQ2**2))/((Q2-SP)**2*(-TP+XQ2)*(Q2-SP-TP+XQ2))
            WEIGHT = HELFLX(3)*SIGQPM(3)/(2.D0*(SH+GQ2(2)))
          ELSE IF(MSPR.EQ.14) THEN
            SWP0M0 = 4.D0*RR*GQ2(2)*(-CC**2*GQ2(1)*W2
     &              -XKAP*XKAM*Q1KK**2)/DD
            SWP0P0 = - SWP0M0+2.D0*GQ2(2)*GQ2(1)**2*W2*BB/DD
            SWPP00 = 2.D0*W2*BB*(AA-2.D0*CC*RR)
     &              *SQRT(GQ2(1)*GQ2(2))/DD
            SWP00P = 4.D0*RR*(CC**2*(GQ2(1)*Q2KK+GQ2(2)*Q1KK)
     &              +XKAP*XKAM*Q1KK*Q2KK)*SQRT(GQ2(1)*GQ2(2))/DD
            SW0PM0 = -SWP00P-2.D0*GQ2(1)*GQ2(2)*W2*BB
     &              *SQRT(GQ2(1)*GQ2(2))/DD
            SIGQPM(3) = SWP0P0*FAC
            SIGQPM(6) = (SWPP00+SW0PM0)/2.D0*FAC
            WEIGHT = HELFLX(3)*SIGQPM(3)
     &              +HELFLX(6)*SIGQPM(6)/2.D0
          ENDIF
        ELSE IF((IGHEL(1).EQ.0).AND.(IGHEL(2).EQ.1)) THEN
          IF(MSPR.EQ.10) THEN
            Q2 = -GQ2(1)
            SP = SH-XQ2
            TP = UH-XQ2
            SIGQPM(4) = 32.D0*PI**2*8.D0/3.D0*ALPHA1*QC2*ALPHA2
     &               *Q2*(-(SP**2*TP**2*(-Q2 + SP + TP)) +
     &               SP*TP*(2.D0*Q2**2 + 3.D0*SP**2 + 2.D0*SP*TP -
     &               TP**2 - 2.D0*Q2*(3*SP + TP))*XQ2 -
     &               2.D0*(Q2*(SP**2 + 6.D0*SP*TP + TP**2) -
     &               2.D0*SP*(SP**2 + 4.D0*SP*TP + 3.D0*TP**2))*
     &               XQ2**2 + 8.D0*(SP + TP)**2*XQ2**3)/
     &               (SP**2*TP**2*((Q2 - SP)**2 - 4.D0*Q2*XQ2))
            WEIGHT = HELFLX(4)*SIGQPM(4)/(2.D0*(SH+GQ2(1)))
          ELSE IF(MSPR.EQ.11) THEN
            Q2 = -GQ2(1)
            SP = SH
            TP = TH
            SIGQPM(4) = 32.D0*PI**2*2.D0*ALPHA1*QC2*ALPHA2
     &        *(-Q2*(SP*TP*(-Q2+SP+TP)+(Q2**2-Q2*SP-2*SP*TP)*XQ2 +
     &        SP*XQ2**2))/((Q2-SP)**2*(-TP+XQ2)*(Q2-SP-TP+XQ2))
            WEIGHT = HELFLX(4)*SIGQPM(4)/(2.D0*(SH+GQ2(2)))
          ELSE IF(MSPR.EQ.14) THEN
            SW0P0M = 4.D0*RR*GQ2(1)*(-CC**2*GQ2(2)*W2
     &                               -XKAP*XKAM*Q2KK**2)/DD
            SW0P0P = - SW0P0M+2.D0*GQ2(1)*GQ2(2)**2*W2*BB/DD
            SWPP00 = 2.D0*W2*BB*(AA-2.D0*CC*RR)
     &              *SQRT(GQ2(1)*GQ2(2))/DD
            SWP00P = 4.D0*RR*(CC**2*(GQ2(1)*Q2KK+GQ2(2)*Q1KK)
     &              +XKAP*XKAM*Q1KK*Q2KK)*SQRT(GQ2(1)*GQ2(2))/DD
            SW0PM0 = -SWP00P-2.D0*GQ2(1)*GQ2(2)*W2*BB
     &              *SQRT(GQ2(1)*GQ2(2))/DD
            SIGQPM(4) = SW0P0P*FAC
            SIGQPM(6) = (SWPP00+SW0PM0)/2.D0*FAC
            WEIGHT = HELFLX(4)*SIGQPM(4)
     &              +HELFLX(6)*SIGQPM(6)/2.D0
          ENDIF
        ELSE IF((IGHEL(1).EQ.0).AND.(IGHEL(2).EQ.0)) THEN
          IF(MSPR.EQ.14) THEN
            SW0000 = 2.D0*GQ2(1)*GQ2(2)*W2*W2*AA*BB/DD**2
            SIGQPM(5) = SW0000*FAC
            WEIGHT = HELFLX(5)*SIGQPM(5)
          ENDIF
        ELSE
          WRITE(ErrorOut,'(/1X,A,2I3)')
     &      'PHO_GGEPEM:ERROR: INVALID PHOTON HELICITIES: ',IGHEL
          WRITE(ErrorOut,'(1X,A,I12)')
     &      'PHO_GGEPEM: EVENT REJECTED (KEVENT)',KEVENT
          WEIGHT = 0.D0
        ENDIF

C  fully differential cross section dsig/(dQ_^2 dQ_2^2 dy_1 dy_2 dphi)

        WGHQPM = WEIGHT/(137.D0**2*16.D0*PI**4*GQ2(1)*GQ2(2))
     &          *SQRT(XCAP/YCAP)*PI*SS/(2.D0*YCAP)*PINI(4,1)*PINI(4,2)

      ENDIF

      END



CDECK  ID>, PHO_GGBLSR
      SUBROUTINE PHO_GGBLSR(NEVENT,EE1,EE2,
     &                      PL_LAM_1,PL_LAM_2,X_1,X_2,RHO,A)
C***********************************************************************
C
C     interface to call PHOJET (variable energy run) for
C     gamma-gamma collisions via laser backscattering
C
C     input:     EE1         lab. system energy of electron/positron 1
C                EE2         lab. system energy of electron/positron 2
C                NEVENT      number of events to generate
C                Pl_lam_1/2  product of electron and photon pol.
C                X_1/2       standard X parameter
C                rho         ratio of distance to conversion point and
C                            transverse beam size
C                A           ellipticity of electon beam
C
C                (see Ginzburg & Kotkin hep-ph/9905462)
C
C            from /LEPCUT/:
C                YMIN1   lower limit of Y1
C                        (energy fraction taken by photon from electron)
C                YMAX1   upper limit of Y1
C                YMIN2   lower limit of Y2
C                        (energy fraction taken by photon from electron)
C                YMAX2   upper limit of Y2
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( PI   = 3.14159265359D0 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  photon flux kinematics and cuts
      DOUBLE PRECISION ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                 YMIN1,YMAX1,YMIN2,YMAX2,
     &                 Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                 THMIN1,THMAX1,THMIN2,THMAX2
      INTEGER          ITAG1,ITAG2
      COMMON /POFCUT/ ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                YMIN1,YMAX1,YMIN2,YMAX2,
     &                Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                THMIN1,THMAX1,THMIN2,THMAX2,
     &                ITAG1,ITAG2

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      PARAMETER (N_DIM=100)
      DIMENSION X_INP_1(N_DIM),F_INP_1(N_DIM),F_INT_1(N_DIM),
     &          X_INP_2(N_DIM),F_INP_2(N_DIM),F_INT_2(N_DIM),
     &          XGRID(96),WGRID(96)

      DIMENSION P1(4),P2(4)



      PI2 = 2.D0*PI

      WRITE(ErrorOut,
     * '(//1X,A,I10)') 'PHO_GGBLSR: events to process',NEVENT

      YMAX1 = MIN(X_1/(1.D0+X_1),YMAX1)
      YMAX2 = MIN(X_2/(1.D0+X_2),YMAX2)
      IF((YMIN1.GT.YMAX1).OR.(YMIN2.GT.YMAX2)) THEN
        WRITE(ErrorOut,'(/1X,2A,2E12.4)') 'PHO_GGBLSR:ERROR: ',
     &    'INVALID YMIN1,YMIN2',YMIN1,YMIN2
        RETURN
      ENDIF
      IDPSRC(1) = 0
      IDBSRC(1) = 0
      IDPSRC(2) = 0
      IDBSRC(2) = 0

C  initialize sampling

      MAX_TAB = 50
      DELY1 = (YMAX1-YMIN1)/DBLE(MAX_TAB-1)
      DELY2 = (YMAX2-YMIN2)/DBLE(MAX_TAB-1)

      IF(IDEB(30).GE.1) WRITE(ErrorOut,'(1X,A,I5)')
     &  'PHO_GGBLSR: TABLE OF PHOTON FLUX ',MAX_TAB

      DO 100 I=1,MAX_TAB

        Y1 = YMIN1+DELY1*DBLE(I-1)
        R1 = Y1/(X_1*(1.D0-Y1))
        X_INP_1(I) = Y1
        F_INP_1(I) = 1.D0/(1.D0-Y1)-Y1+(2.D0*R1-1.D0)**2
     &            -PL_LAM_1*X_1*R1*(2.D0*R1-1.D0)*(2.D0-Y1)

        Y2 = YMIN2+DELY2*DBLE(I-1)
        R2 = Y2/(X_2*(1.D0-Y2))
        X_INP_2(I) = Y2
        F_INP_2(I) = 1.D0/(1.D0-Y2)-Y2+(2.D0*R2-1.D0)**2
     &            -PL_LAM_2*X_2*R2*(2.D0*R2-1.D0)*(2.D0-Y2)

        IF(IDEB(30).GE.1) WRITE(ErrorOut,
     * '(5X,1p,2E13.4,5x,2E13.4)')
     &    Y1,F_INP_1(I),Y2,F_INP_2(I)

 100  CONTINUE

      CALL PHO_SAMP1D(-1,X_INP_1,F_INP_1,F_INT_1,MAX_TAB,X_OUT_1)
      CALL PHO_SAMP1D(-1,X_INP_2,F_INP_2,F_INT_2,MAX_TAB,X_OUT_2)

C  initialize event generator

C  photon 1
      EGAM = YMAX1*EE1
      P1(1) = 0.D0
      P1(2) = 0.D0
      P1(3) = EGAM
      P1(4) = EGAM
C  photon 2
      EGAM = YMAX2*EE2
      P2(1) = 0.D0
      P2(2) = 0.D0
      P2(3) = -EGAM
      P2(4) = EGAM
      CALL PHO_SETPAR(1,22,0,0.D0)
      CALL PHO_SETPAR(2,22,0,0.D0)
      CALL PHO_EVENT(-1,P1,P2,SIGMAX,IREJ)
      CALL PHO_PHIST(-1,SIGMAX)
      CALL PHO_LHIST(-1,SIGMAX)

C  generation of events

      AY1  = 0.D0
      AY2  = 0.D0
      AYS1 = 0.D0
      AYS2 = 0.D0
      NITER = NEVENT
      ITRY = 0
      ITRW = 0
      DO 200 I=1,NITER
 150    CONTINUE
        ITRY = ITRY+1
 175    CONTINUE
          ITRW = ITRW+1

          CALL PHO_SAMP1D(1,X_INP_1,F_INP_1,F_INT_1,MAX_TAB,X_OUT_1)
          CALL PHO_SAMP1D(1,X_INP_2,F_INP_2,F_INT_2,MAX_TAB,X_OUT_2)



          G_1 = SQRT(MAX(0.D0,X_1/(X_OUT_1+1.D-6)-X_1-1.D0))
          G_2 = SQRT(MAX(0.D0,X_2/(X_OUT_2+1.D-6)-X_2-1.D0))
          IF(ABS(1.D0-A).LT.1.D-3) THEN
            V = RHO**2/4.D0*G_1*G_2
            WGHT = EXP(-RHO**2/8.D0*(G_1-G_2)**2)*PHO_EXPBESSI0(V)
          ELSE
            NINT = 16
            CALL PHO_GAUSET(0.D0,PI2,NINT,XGRID,WGRID)
            A2 = A**2
            FAC = RHO**2/(4.D0*(1.D0+A2))
            WGHT = 0.D0
            DO I1=1,NINT
              PHI_1 = XGRID(I1)
              DO I2=1,NINT
                PHI_2 = XGRID(I2)
                WGHT = WGHT
     &            +EXP(-FAC*(A2*(G_1*COS(PHI_1)+G_2*COS(PHI_2))**2
     &                         +(G_1*SIN(PHI_1)+G_2*SIN(PHI_2))**2))
     &            *WGRID(I1)*WGRID(I2)
              ENDDO
            ENDDO
            WGHT = WGHT/PI2**2
          ENDIF

          IF(WGHT.GT.1.D0) THEN
            WRITE(ErrorOut,'(1X,A,5E11.4)')
     &        'PHO_GGBLSR:WEIGHT ERROR:',Y1,Y2,WGHT
          ENDIF
        IF(PHO_RNDM(DUM).GT.WGHT) GOTO 175

        Y1 = X_OUT_1
        Y2 = X_OUT_2

        Q2P1 = 0.D0
        Q2P2 = 0.D0
        GYY(1) = Y1
        GQ2(1) = Q2P1
        GYY(2) = Y2
        GQ2(2) = Q2P2
C  incoming electron 1
        PINI(1,1) = 0.D0
        PINI(2,1) = 0.D0
        PINI(3,1) = EE1
        PINI(4,1) = EE1
        PINI(5,1) = 0.D0
C  outgoing electron 1
        YQ2 = SQRT((1.D0-Y1)*Q2P2)
        Q2E = Q2P1/(4.D0*EE1)
        E1Y = EE1*(1.D0-Y1)
        CALL PHO_SFECFE(SIF,COF)
        PFIN(1,1) = YQ2*COF
        PFIN(2,1) = YQ2*SIF
        PFIN(3,1) = E1Y-Q2E
        PFIN(4,1) = E1Y+Q2E
        PFIN(5,1) = 0.D0
C  photon 1
        P1(1) = -PFIN(1,1)
        P1(2) = -PFIN(2,1)
        P1(3) = PINI(3,1)-PFIN(3,1)
        P1(4) = PINI(4,1)-PFIN(4,1)
C  incoming electron 2
        PINI(1,2) = 0.D0
        PINI(2,2) = 0.D0
        PINI(3,2) = -EE2
        PINI(4,2) = EE2
        PINI(5,2) = 0.D0
C  outgoing electron 2
        YQ2 = SQRT((1.D0-Y2)*Q2P2)
        Q2E = Q2P2/(4.D0*EE2)
        E1Y = EE2*(1.D0-Y2)
        CALL PHO_SFECFE(SIF,COF)
        PFIN(1,2) = YQ2*COF
        PFIN(2,2) = YQ2*SIF
        PFIN(3,2) = -E1Y+Q2E
        PFIN(4,2) = E1Y+Q2E
        PFIN(5,2) = 0.D0
C  photon 2
        P2(1) = -PFIN(1,2)
        P2(2) = -PFIN(2,2)
        P2(3) = PINI(3,2)-PFIN(3,2)
        P2(4) = PINI(4,2)-PFIN(4,2)
C  ECMS cut
        GGECM = (P1(4)+P2(4))**2-(P1(1)+P2(1))**2
     &         -(P1(2)+P2(2))**2-(P1(3)+P2(3))**2
        IF(GGECM.LT.0.1D0) GOTO 175
        GGECM = SQRT(GGECM)
        IF((GGECM.LT.ECMIN).OR.(GGECM.GT.ECMAX)) GOTO 175

        PGAM(1,1) = P1(1)
        PGAM(2,1) = P1(2)
        PGAM(3,1) = P1(3)
        PGAM(4,1) = P1(4)
        PGAM(5,1) = 0.D0
        PGAM(1,2) = P2(1)
        PGAM(2,2) = P2(2)
        PGAM(3,2) = P2(3)
        PGAM(4,2) = P2(4)
        PGAM(5,2) = 0.D0
C  photon helicities
        IGHEL(1) = 1
        IGHEL(2) = 1
C  cut given by user
        CALL PHO_PRESEL(5,IREJ)
        IF(IREJ.NE.0) GOTO 175
C  event generation
        CALL PHO_EVENT(1,P1,P2,SIGCUR,IREJ)
        IF(IREJ.NE.0) GOTO 150

C  statistics
        AY1  = AY1+Y1
        AYS1 = AYS1+Y1*Y1
        AY2  = AY2+Y2
        AYS2 = AYS2+Y2*Y2
C  histograms
        CALL PHO_PHIST(1,HSWGHT(0))
        CALL PHO_LHIST(1,HSWGHT(0))
 200  CONTINUE

      WGY  = DBLE(ITRY)/DBLE(ITRW)
      AY1  = AY1/DBLE(NITER)
      AYS1 = AYS1/DBLE(NITER)
      DAY1 = SQRT((AYS1-AY1**2)/DBLE(NITER))
      AY2  = AY2/DBLE(NITER)
      AYS2 = AYS2/DBLE(NITER)
      DAY2 = SQRT((AYS2-AY2**2)/DBLE(NITER))
      WEIGHT = WGY*SIGMAX*DBLE(NITER)/DBLE(ITRY)
C  output of statistics, histograms
      WRITE(ErrorOut,'(//1X,A,/1X,A,1PE12.3,A,/1X,A)')
     &'=========================================================',
     &' *****   SIMULATED CROSS SECTION: ',WEIGHT,' MB  *****',
     &'========================================================='
      WRITE(ErrorOut,'(//1X,A,3I10)')
     &  'PHO_GGBLSR:SUMMARY:NITER,ITRY,ITRW',NITER,ITRY,ITRW
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'EFFECTIVE WEIGHT (FLUX,TOTAL)',
     &  WGY,WEIGHT
      WRITE(ErrorOut,
     * '(1X,A,2F10.5)') 'PHO_GGBLSR:AVERAGE Y1,DY1 ',AY1,DAY1
      WRITE(ErrorOut,
     * '(1X,A,2F10.5)') 'PHO_GGBLSR:AVERAGE Y2,DY2 ',AY2,DAY2

      CALL PHO_EVENT(-2,P1,P2,WEIGHT,IREJ)
      IF(NITER.GT.1) THEN
        CALL PHO_PHIST(-2,WEIGHT)
        CALL PHO_LHIST(-2,WEIGHT)
      ELSE
        WRITE(ErrorOut,
     * '(1X,A,I4)') 'PHO_GGBLSR:NO OUTPUT OF HISTOGRAMS',NITER
      ENDIF



      END




CDECK  ID>, pho_samp1d
      SUBROUTINE PHO_SAMP1D(IMODE,X_INP,F_INP,F_INT,N_DIM,X_OUT)
C***********************************************************************
C
C     Monte Carlo sampling from arbitrary 1d distribution
C     (linear interpolation to improve reproduction of initial function)
C
C     input: Imode          -1  initialization
C                            1  sampling (after initialization)
C            X_inp(N_dim)   array with x values
C            F_inp(N_dim)   array with function values
C            F_int(N_dim)   array with integral
C
C     output:  X_out        sampled value (Imode=1)
C
C                                                 (R.E. 10/99)
C
C***********************************************************************
      IMPLICIT NONE
#include "Zmanagerp.h"
      SAVE

      INTEGER IMODE,N_DIM
      DOUBLE PRECISION X_INP,F_INP,F_INT,X_OUT
      DIMENSION X_INP(N_DIM),F_INP(N_DIM),F_INT(N_DIM)

C  local variables
      INTEGER I
      DOUBLE PRECISION DUM,XI,A,B

C  external functions
      DOUBLE PRECISION PHO_RNDM
      EXTERNAL PHO_RNDM


      IF(IMODE.EQ.-1) THEN

C  initialization

        F_INT(1) = 0.D0
        DO I=2,N_DIM
          F_INT(I) = F_INT(I-1)
     &       +0.5D0*(F_INP(I)+F_INP(I-1))*(X_INP(I)-X_INP(I-1))
        ENDDO

      ELSE IF(IMODE.EQ.1) THEN

C  sample from previously calculated integral

        XI = PHO_RNDM(DUM)*F_INT(N_DIM)

        DO I=2,N_DIM
          IF(XI.LT.F_INT(I)) THEN
            A = (F_INP(I)-F_INP(I-1))/(X_INP(I)-X_INP(I-1))
            B = F_INP(I)-A*X_INP(I)
            XI = XI-F_INT(I-1)+0.5D0*A*X_INP(I-1)**2+B*X_INP(I-1)
            X_OUT = (SQRT(B**2+2.D0*A*XI)-B)/A
            RETURN
          ENDIF
        ENDDO
        X_OUT = X_INP(N_DIM)

      ELSE

C  invalid option Imode

        WRITE(ErrorOut,
     * '(1x,a,i6)') 'PHO_SAMP1D: invalid option Imode: ',IMODE
        X_OUT = 0.D0

      ENDIF

      END



CDECK  ID>, pho_ExpBessI0
      DOUBLE PRECISION FUNCTION PHO_EXPBESSI0(X)
C**********************************************************************
C
C     Bessel Function I0 times exponential function from neg. arg.
C     (defined for pos. arguments only)
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      AX = ABS(X)
      IF (AX .LT. 3.75D0) THEN
        Y = (X/3.75D0)**2
        PHO_EXPBESSI0 =
     &    (1.0D0+Y*(3.5156229D0+Y*(3.0899424D0+Y*(1.2067492D0
     &    +Y*(0.2659732D0+Y*(0.360768D-1+Y*0.45813D-2))))))*EXP(-AX)
      ELSE
        Y = 3.75D0/AX
        PHO_EXPBESSI0 =
     &    (1.D0/SQRT(AX))*(0.39894228D0+Y*(0.1328592D-1
     &    +Y*(0.225319D-2+Y*(-0.157565D-2+Y*(0.916281D-2
     &    +Y*(-0.2057706D-1+Y*(0.2635537D-1+Y*(-0.1647633D-1
     &    +Y*0.392377D-2))))))))
      ENDIF

      END



CDECK  ID>, PHO_GGBEAM
      SUBROUTINE PHO_GGBEAM(NEVENT,EE,YPSI,SIGX,SIGY,SIGZ,AEB)
C**********************************************************************
C
C     interface to call PHOJET (variable energy run) for
C     gamma-gamma collisions via beamstrahlung
C
C     input:     EE      LAB system energy of electron/positron
C                YPSI    beamstrahlung parameter
C                SIGX,Y  transverse bunch dimensions
C                SIGZ    longitudinal bunch dimension
C                AEB     number of electrons/positrons in a bunch
C                NEVENT  number of events to generate
C            from /LEPCUT/:
C                YMIN1   lower limit of Y
C                        (energy fraction taken by photon from electron)
C                YMAX1   upper cutoff for Y, necessary to avoid
C                        underflows
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS = 1.D-20,
     &            PI   = 3.14159265359D0 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  photon flux kinematics and cuts
      DOUBLE PRECISION ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                 YMIN1,YMAX1,YMIN2,YMAX2,
     &                 Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                 THMIN1,THMAX1,THMIN2,THMAX2
      INTEGER          ITAG1,ITAG2
      COMMON /POFCUT/ ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                YMIN1,YMAX1,YMIN2,YMAX2,
     &                Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                THMIN1,THMAX1,THMIN2,THMAX2,
     &                ITAG1,ITAG2

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      PARAMETER (MAX_TAB=100)
      DIMENSION P1(4),P2(4),TABCU(0:MAX_TAB),TABYL(0:MAX_TAB)

C
      WRITE(ErrorOut,
     * '(//1X,A,I10)') 'PHO_GGBEAM: events to process',NEVENT
C  electron data
      RE = 2.818D-12
      ELEM = 0.512D-03
      IDPSRC(1) = 0
      IDBSRC(1) = 0
      IDPSRC(2) = 0
      IDBSRC(2) = 0
C  table of flux function, log interpolation
      IF(YPSI.LE.0.D0) THEN
        YPSI  = 5.D0*RE**2*EE*AEB*137.D0/(6.D0*SIGZ*(SIGX+SIGY)*ELEM)
      ENDIF
      WRITE(ErrorOut,'(/1X,A,E12.4)')
     &  'PHO_GGBEAM: BEAMSTRAHLUNG PARAMETER:',YPSI
      WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &  'PHO_GGBEAM: SIGMA-Z,NE-BUNCH:',SIGZ,AEB
      TT    = 2.D0/3.D0
      OT    = 1.D0/3.D0
C     GAOT  = DGAMMA(OT)
      GAOT  = 2.6789385347D0
      AKAP  = TT/YPSI
      WW    = 1.D0/(6.D0*SQRT(AKAP))
      ANGAM = 5.D0*SIGZ*ELEM/(137.D0**2*2.D0*RE*EE)
     &       *YPSI/SQRT(1.D0+YPSI**TT)

      YMIN = YMIN1
      YMAX = MIN(YMAX1,0.9D0)
      TABCU(0) = 0.D0
      TABYL(0) = LOG(YMIN)
      DELLY = LOG(YMAX/YMIN)/DBLE(MAX_TAB-1)
      FLUX = 0.D0
      IF(IDEB(30).GE.1) WRITE(ErrorOut,'(1X,A,I5)')
     &  'PHO_GGBEAM: TABLE OF PHOTON FLUX',MAX_TAB
      DO 100 I=1,MAX_TAB
        Y = EXP(TABYL(0)+DELLY*DBLE(I-1))
        GG = 1.D0-0.5D0*(1-Y)**TT*(1.D0-Y+(1.D0+Y)*SQRT(1.D0+YPSI**TT))
        FF = AKAP**OT/GAOT/Y**TT/(1.D0-Y)**OT*EXP(-AKAP*Y/(1.D0-Y))
     &      *((1.D0-WW)/GG*(1.D0-(1.D0-EXP(-ANGAM*GG))/(ANGAM*GG))
     &      +WW*(1.D0-(1.D0-EXP(-ANGAM))/ANGAM))
        TABCU(I) = TABCU(I-1)+FF*Y
        TABYL(I) = LOG(Y)
        FLUX = FLUX+Y*FF
        IF(IDEB(30).GE.1) WRITE(ErrorOut,'(5X,2E15.4)') Y,FF
 100  CONTINUE
      FLUX = FLUX*DELLY
      IF(IDEB(30).GE.1) WRITE(ErrorOut,'(1X,A,E12.4)')
     &  'PHO_GGBEAM: INTEGRATED FLUX (ONE SIDE):',FLUX

      EE1 = EE
      EE2 = EE
C  photon 1
      EGAM = YMAX*EE
      P1(1) = 0.D0
      P1(2) = 0.D0
      P1(3) = EGAM
      P1(4) = EGAM
C  photon 2
      EGAM = YMAX*EE
      P2(1) = 0.D0
      P2(2) = 0.D0
      P2(3) = -EGAM
      P2(4) = EGAM
      CALL PHO_SETPAR(1,22,0,0.D0)
      CALL PHO_SETPAR(2,22,0,0.D0)
      CALL PHO_EVENT(-1,P1,P2,SIGMAX,IREJ)
      CALL PHO_PHIST(-1,SIGMAX)
      CALL PHO_LHIST(-1,SIGMAX)

C  generation of events

      AY1  = 0.D0
      AY2  = 0.D0
      AYS1 = 0.D0
      AYS2 = 0.D0
      NITER = NEVENT
      ITRY = 0
      ITRW = 0
      DO 200 I=1,NITER
 150    CONTINUE
        ITRY = ITRY+1
 175    CONTINUE
        ITRW = ITRW+1
        XI = PHO_RNDM(AY1)*TABCU(MAX_TAB)
        DO 110 K=1,MAX_TAB
          IF(TABCU(K).GE.XI) THEN
            Y1 = DELLY/(TABCU(K)-TABCU(K-1))*(XI-TABCU(K-1))+TABYL(K-1)
            Y1 = EXP(Y1)
            GOTO 120
          ENDIF
 110    CONTINUE
        Y1 = YMAX
 120    CONTINUE
        XI = PHO_RNDM(AY2)*TABCU(MAX_TAB)
        DO 130 K=1,MAX_TAB
          IF(TABCU(K).GE.XI) THEN
            Y2 = DELLY/(TABCU(K)-TABCU(K-1))*(XI-TABCU(K-1))+TABYL(K-1)
            Y2 = EXP(Y2)
            GOTO 140
          ENDIF
 130    CONTINUE
        Y2 = YMAX
 140    CONTINUE

        Q2P1 = 0.D0
        Q2P2 = 0.D0
        GYY(1) = Y1
        GQ2(1) = Q2P1
        GYY(2) = Y2
        GQ2(2) = Q2P2
C  incoming electron 1
        PINI(1,1) = 0.D0
        PINI(2,1) = 0.D0
        PINI(3,1) = EE1
        PINI(4,1) = EE1
        PINI(5,1) = 0.D0
C  outgoing electron 1
        YQ2 = SQRT((1.D0-Y1)*Q2P2)
        Q2E = Q2P1/(4.D0*EE1)
        E1Y = EE1*(1.D0-Y1)
        CALL PHO_SFECFE(SIF,COF)
        PFIN(1,1) = YQ2*COF
        PFIN(2,1) = YQ2*SIF
        PFIN(3,1) = E1Y-Q2E
        PFIN(4,1) = E1Y+Q2E
        PFIN(5,1) = 0.D0
C  photon 1
        P1(1) = -PFIN(1,1)
        P1(2) = -PFIN(2,1)
        P1(3) = PINI(3,1)-PFIN(3,1)
        P1(4) = PINI(4,1)-PFIN(4,1)
C  incoming electron 2
        PINI(1,2) = 0.D0
        PINI(2,2) = 0.D0
        PINI(3,2) = -EE2
        PINI(4,2) = EE2
        PINI(5,2) = 0.D0
C  outgoing electron 2
        YQ2 = SQRT((1.D0-Y2)*Q2P2)
        Q2E = Q2P2/(4.D0*EE2)
        E1Y = EE2*(1.D0-Y2)
        CALL PHO_SFECFE(SIF,COF)
        PFIN(1,2) = YQ2*COF
        PFIN(2,2) = YQ2*SIF
        PFIN(3,2) = -E1Y+Q2E
        PFIN(4,2) = E1Y+Q2E
        PFIN(5,2) = 0.D0
C  photon 2
        P2(1) = -PFIN(1,2)
        P2(2) = -PFIN(2,2)
        P2(3) = PINI(3,2)-PFIN(3,2)
        P2(4) = PINI(4,2)-PFIN(4,2)
C  ECMS cut
        GGECM = (P1(4)+P2(4))**2-(P1(1)+P2(1))**2
     &         -(P1(2)+P2(2))**2-(P1(3)+P2(3))**2
        IF(GGECM.LT.0.1D0) GOTO 175
        GGECM = SQRT(GGECM)
        IF((GGECM.LT.ECMIN).OR.(GGECM.GT.ECMAX)) GOTO 175
C
        PGAM(1,1) = P1(1)
        PGAM(2,1) = P1(2)
        PGAM(3,1) = P1(3)
        PGAM(4,1) = P1(4)
        PGAM(5,1) = 0.D0
        PGAM(1,2) = P2(1)
        PGAM(2,2) = P2(2)
        PGAM(3,2) = P2(3)
        PGAM(4,2) = P2(4)
        PGAM(5,2) = 0.D0
C  photon helicities
        IGHEL(1) = 1
        IGHEL(2) = 1
C  cut given by user
        CALL PHO_PRESEL(5,IREJ)
        IF(IREJ.NE.0) GOTO 175
C  event generation
        CALL PHO_EVENT(1,P1,P2,SIGCUR,IREJ)
        IF(IREJ.NE.0) GOTO 150
	GGECML = LOG(GGECM)

C  statistics
        AY1  = AY1+Y1
        AYS1 = AYS1+Y1*Y1
        AY2  = AY2+Y2
        AYS2 = AYS2+Y2*Y2
C  histograms
        CALL PHO_PHIST(1,HSWGHT(0))
        CALL PHO_LHIST(1,HSWGHT(0))
 200  CONTINUE
C
      WGY  = FLUX**2*DBLE(ITRY)/DBLE(ITRW)
      AY1  = AY1/DBLE(NITER)
      AYS1 = AYS1/DBLE(NITER)
      DAY1 = SQRT((AYS1-AY1**2)/DBLE(NITER))
      AY2  = AY2/DBLE(NITER)
      AYS2 = AYS2/DBLE(NITER)
      DAY2 = SQRT((AYS2-AY2**2)/DBLE(NITER))
      WEIGHT = WGY*SIGMAX*DBLE(NITER)/DBLE(ITRY)
C  output of statistics, histograms
      WRITE(ErrorOut,'(//1X,A,/1X,A,1PE12.3,A,/1X,A)')
     &'=========================================================',
     &' *****   SIMULATED CROSS SECTION: ',WEIGHT,' MB  *****',
     &'========================================================='
      WRITE(ErrorOut,'(//1X,A,2I10)')
     &  'PHO_GGBEAM:SUMMARY:NITER,ITRY',NITER,ITRY
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'EFFECTIVE WEIGHT (FLUX,TOTAL)',
     &  WGY,WEIGHT
      WRITE(ErrorOut,
     * '(1X,A,2F10.5)') 'PHO_GGBEAM:AVERAGE Y1,DY1 ',AY1,DAY1
      WRITE(ErrorOut,
     * '(1X,A,2F10.5)') 'PHO_GGBEAM:AVERAGE Y2,DY2 ',AY2,DAY2
C
      CALL PHO_EVENT(-2,P1,P2,WEIGHT,IREJ)
      IF(NITER.GT.1) THEN
        CALL PHO_PHIST(-2,WEIGHT)
        CALL PHO_LHIST(-2,WEIGHT)
      ELSE
        WRITE(ErrorOut,
     * '(1X,A,I4)') 'PHO_GGBEAM:NO OUTPUT OF HISTOGRAMS',NITER
      ENDIF



      END


CDECK  ID>, PHO_GGHIOF
      SUBROUTINE PHO_GGHIOF(NEVENT,EEN,NA,NZ)
C**********************************************************************
C
C     interface to call PHOJET (variable energy run) for
C     gamma-gamma collisions via heavy ions (form factor approach)
C
C     input:     EEN     LAB system energy per nucleon
C                NA      atomic number of ion/hadron
C                NZ      charge number of ion/hadron
C                NEVENT  number of events to generate
C            from /LEPCUT/:
C                YMIN1,2 lower limit of Y
C                        (energy fraction taken by photon from hadron)
C                YMAX1,2 upper cutoff for Y, necessary to avoid
C                        underflows
C                Q2MIN1,2 minimum Q**2 of photons (should be set to 0)
C                Q2MAX1,2 maximum Q**2 of photons (if necessary,
C                        corrected according size of hadron)
C
C      currently implemented approximation similar to:
C                E.Papageorgiu PhysLettB250(1990)155
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( PI   = 3.14159265359D0 )

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  photon flux kinematics and cuts
      DOUBLE PRECISION ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                 YMIN1,YMAX1,YMIN2,YMAX2,
     &                 Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                 THMIN1,THMAX1,THMIN2,THMAX2
      INTEGER          ITAG1,ITAG2
      COMMON /POFCUT/ ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                YMIN1,YMAX1,YMIN2,YMAX2,
     &                Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                THMIN1,THMAX1,THMIN2,THMAX2,
     &                ITAG1,ITAG2

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      DIMENSION P1(4),P2(4),BIMP(2,2)

C
      WRITE(ErrorOut,
     * '(2(/1X,A))') 'PHO_GGHIOF:GAMMA-GAMMA EVENT GENERATION',
     &                      '--------------------------------------'
C  hadron size and mass
      FM2GEV = 5.07D0
      HIMASS = DBLE(NA)*0.938D0
      HIMA2  = HIMASS**2
      HIRADI = 1.2D0*FM2GEV*DBLE(NA)**0.333
      ALPHA  = DBLE(NZ**2)/137.D0
C  correct Q2MAX1,2 according to hadron size
      Q2MAXH = 2.D0/HIRADI**2
      Q2MAX1 = MIN(Q2MAX1,Q2MAXH)
      Q2MAX2 = MIN(Q2MAX2,Q2MAXH)
      IF(Q2MAX1.LT.1.D-20) Q2MAX1 = Q2MAXH
      IF(Q2MAX2.LT.1.D-20) Q2MAX2 = Q2MAXH
C  total hadron / heavy ion energy
      EE = EEN*DBLE(NA)
      GAMMA = EE/HIMASS
C  setup /POFSRC/
      GAMSRC(1) = GAMMA
      GAMSRC(2) = GAMMA
      RADSRC(1) = HIRADI
      RADSRC(2) = HIRADI
      AMSRC(1)  = HIMASS
      AMSRC(1)  = HIMASS
C  kinematic limitations
      YMI = (ECMIN/(2.D0*EE))**2
      IF(YMIN1.LT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.5)')
     &    'PHO_GGHIOF: YMIN1 INCREASED TO (OLD/NEW)',YMIN1,YMI
        YMIN1 = YMI
      ELSE IF(YMIN1.GT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,/1X,A,E12.5,A,E12.5)')
     &    'PHO_GGHIOF:','ECM-CUT CORRESPONDS TO YMIN1 OF',YMI,
     &    '  INSTEAD OF',YMIN1
      ENDIF
      IF(YMIN2.LT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.5)')
     &    'PHO_GGHIOF: YMIN2 INCREASED TO (OLD/NEW)',YMIN2,YMI
        YMIN2 = YMI
      ELSE IF(YMIN2.GT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,/1X,A,E12.5,A,E12.5)')
     &    'PHO_GGHIOF:','ECM-CUT CORRESPONDS TO YMIN2 OF',YMI,
     &    '  INSTEAD OF',YMIN2
      ENDIF
C  kinematic limitation
      Q2LOW1 = MAX(Q2MIN1,HIMA2*YMIN1**2/(1.D0-YMIN1))
      Q2LOW2 = MAX(Q2MIN2,HIMA2*YMIN2**2/(1.D0-YMIN2))
C  debug output
      WRITE(ErrorOut,
     * '(/6X,A,2I4)')   'MASS NUMBER, CHARGE NUMBER  ',NA,NZ
      WRITE(ErrorOut,
     * '(6X,A,E12.5)') 'HADRON MASS (GeV)           ',HIMASS
      WRITE(ErrorOut,
     * '(6X,A,E12.5)') 'HADRON RADIUS (GeV**-1)     ',HIRADI
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'Q**2 RANGE PHOTON 1 (GEV**2)',Q2LOW1,
     &  Q2MAX1
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'Q**2 RANGE PHOTON 2 (GEV**2)',Q2LOW2,
     &  Q2MAX2
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'Y RANGE PHOTON 1            ',YMIN1,
     &  YMAX1
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'Y RANGE PHOTON 2            ',YMIN2,
     &  YMAX2
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'SQRT(S) PER NUCLEON, TOTAL  ',
     &  2.D0*EEN,2.D0*EE
      WRITE(ErrorOut,
     * '(6X,A,I10)')   'EVENTS TO PROCESS           ',NEVENT
      IF(Q2LOW1.GE.Q2MAX1) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &    'PHO_GGHIOF:ERROR:INCONSISTENT Q**2 RANGE 1',Q2LOW1,Q2MAX1
        CALL PHO_ABORT
      ENDIF
      IF(Q2LOW2.GE.Q2MAX2) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &    'PHO_GGHIOF:ERROR:INCONSISTENT Q**2 RANGE 2',Q2LOW2,Q2MAX2
        CALL PHO_ABORT
      ENDIF
C  hadron numbers set to 0
      IDPSRC(1) = 0
      IDPSRC(2) = 0
      IDBSRC(1) = 0
      IDBSRC(2) = 0
C
      MAX_TAB = 100
      YMAX = YMAX1
      YMIN = YMIN1
      XMAX = LOG(YMAX)
      XMIN = LOG(YMIN)
      XDEL = XMAX-XMIN
      DELLY = LOG(YMAX/YMIN)/DBLE(MAX_TAB-1)
      DO 100 I=1,MAX_TAB
        Y1 = EXP(XMIN+DELLY*DBLE(I-1))
        Q2LOW1 = MAX(Q2MIN1,HIMA2*Y1*Y1/(1.D0-Y1))
        IF(Q2LOW1.GE.Q2MAX1) THEN
          WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &      'PHO_GGHIOF: YMAX1 CHANGED FROM/TO',YMAX1,Y1
          YMAX1 = MIN(Y1,YMAX1)
          GOTO 101
        ENDIF
 100  CONTINUE
 101  CONTINUE
      YMAX = YMAX2
      YMIN = YMIN2
      XMAX = LOG(YMAX)
      XMIN = LOG(YMIN)
      XDEL = XMAX-XMIN
      DELLY = LOG(YMAX/YMIN)/DBLE(MAX_TAB-1)
      DO 102 I=1,MAX_TAB
        Y1 = EXP(XMIN+DELLY*DBLE(I-1))
        Q2LOW2 = MAX(Q2MIN2,HIMA2*Y1*Y1/(1.D0-Y1))
        IF(Q2LOW2.GE.Q2MAX2) THEN
          WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &      'PHO_GGHIOF: YMAX2 CHANGED FROM/TO',YMAX2,Y1
          YMAX2 = MIN(Y1,YMAX2)
          GOTO 103
        ENDIF
 102  CONTINUE
 103  CONTINUE
      YMI = (ECMIN/(2.D0*EE))**2/YMAX2
      IF(YMI.GT.YMIN1) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &    'PHO_GGHIOF: YMIN1 CHANGED FROM/TO',YMIN1,YMI
        YMIN1 = YMI
      ENDIF
      YMI = (ECMIN/(2.D0*EE))**2/YMAX1
      IF(YMI.GT.YMIN2) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &    'PHO_GGHIOF: YMIN2 CHANGED FROM/TO',YMIN2,YMI
        YMIN2 = YMI
      ENDIF
C
      X1MAX = LOG(YMAX1)
      X1MIN = LOG(YMIN1)
      X1DEL = X1MAX-X1MIN
      X2MAX = LOG(YMAX2)
      X2MIN = LOG(YMIN2)
      X2DEL = X2MAX-X2MIN
      DELLY = LOG(YMAX1/YMIN1)/DBLE(MAX_TAB-1)
      FLUX = 0.D0
      IF(IDEB(30).GE.1) WRITE(ErrorOut,'(/1X,A,I5)')
     &  'PHO_GGHIOF: TABLE OF RAW PHOTON FLUX (SIDE 1)',MAX_TAB
      DO 105 I=1,MAX_TAB
        Y1 = EXP(X1MIN+DELLY*DBLE(I-1))
        Q2LOW1 = MAX(Q2MIN1,HIMA2*Y1*Y1/(1.D0-Y1))
        FF = ((1.D0+(1.D0-Y1)**2)/Y1*LOG(Q2MAX1/Q2LOW1)
     &        -2.D0*HIMA2*Y1*(1.D0/Q2LOW1-1.D0/Q2MAX1))*ALPHA/(2.D0*PI)
        FLUX = FLUX+Y1*FF
        IF(IDEB(30).GE.1) WRITE(ErrorOut,'(5X,2E15.4)') Y1,FF
 105  CONTINUE
      FLUX = FLUX*DELLY
      IF(IDEB(30).GE.1) WRITE(ErrorOut,'(1X,A,E12.4)')
     &  'PHO_GGHIOF: INTEGRATED FLUX (ONE SIDE):',FLUX
C
      Q2LOW1 = MAX(Q2MIN1,HIMA2*YMIN1**2/(1.D0-YMIN1))
      Q2LOW2 = MAX(Q2MIN2,HIMA2*YMIN2**2/(1.D0-YMIN2))
      Y1 = YMIN1
      Y2 = YMIN2
      WGMAX = ((1.D0+(1.D0-Y1)**2)*LOG(Q2MAX1/Q2LOW1)
     &         -2.D0*HIMA2*Y1*(1.D0/Q2LOW1-1.D0/Q2MAX1)*Y1)
     &       *((1.D0+(1.D0-Y2)**2)*LOG(Q2MAX2/Q2LOW2)
     &         -2.D0*HIMA2*Y2*(1.D0/Q2LOW2-1.D0/Q2MAX2)*Y2)
C
C  photon 1
      EGAM = YMAX1*EE
      P1(1) = 0.D0
      P1(2) = 0.D0
      P1(3) = EGAM
      P1(4) = EGAM
C  photon 2
      EGAM = YMAX2*EE
      P2(1) = 0.D0
      P2(2) = 0.D0
      P2(3) = -EGAM
      P2(4) = EGAM
      CALL PHO_SETPAR(1,22,0,0.D0)
      CALL PHO_SETPAR(2,22,0,0.D0)
      CALL PHO_EVENT(-1,P1,P2,SIGMAX,IREJ)
      CALL PHO_PHIST(-1,SIGMAX)
      CALL PHO_LHIST(-1,SIGMAX)
C
C  generation of events, flux calculation

      ECFRAC = ECMIN**2/(4.D0*EE*EE)
      AY1  = 0.D0
      AY2  = 0.D0
      AYS1 = 0.D0
      AYS2 = 0.D0
      Q21MIN = 1.D30
      Q22MIN = 1.D30
      Q21MAX = 0.D0
      Q22MAX = 0.D0
      Q21AVE = 0.D0
      Q22AVE = 0.D0
      Q21AV2 = 0.D0
      Q22AV2 = 0.D0
      YY1MIN = 1.D30
      YY2MIN = 1.D30
      YY1MAX = 0.D0
      YY2MAX = 0.D0
      NITER = NEVENT
      ITRY = 0
      ITRW = 0
      DO 200 I=1,NITER
C  sample y1, y2
 150    CONTINUE
        ITRY = ITRY+1
 175    CONTINUE
          ITRW = ITRW+1
          Y1 = EXP(X1DEL*PHO_RNDM(AY1)+X1MIN)
          Y2 = EXP(X2DEL*PHO_RNDM(AY2)+X2MIN)
          IF(Y1*Y2.LT.ECFRAC) GOTO 175
C
          Q2LOW1 = MAX(Q2MIN1,HIMA2*Y1**2/(1.D0-Y1))
          IF(Q2LOW1.GE.Q2MAX1) GOTO 175
          Q2LOW2 = MAX(Q2MIN2,HIMA2*Y2**2/(1.D0-Y2))
          IF(Q2LOW2.GE.Q2MAX2) GOTO 175
          Q2LOG1 = LOG(Q2MAX1/Q2LOW1)
          Q2LOG2 = LOG(Q2MAX2/Q2LOW2)
          WGH = ((1.D0+(1.D0-Y1)**2)*Q2LOG1
     &        -2.D0*HIMA2*Y1*(1.D0/Q2LOW1-1.D0/Q2MAX1)*Y1)
     &         *((1.D0+(1.D0-Y2)**2)*Q2LOG2
     &        -2.D0*HIMA2*Y2*(1.D0/Q2LOW2-1.D0/Q2MAX2)*Y2)
          IF(WGMAX.LT.WGH) THEN
            WRITE(ErrorOut,'(1X,A,4E12.5)')
     &        'PHO_GGHIOF:WEIGHT ERROR:',Y1,Y2,WGMAX,WGH
          ENDIF
        IF(PHO_RNDM(AYS1)*WGMAX.GT.WGH) GOTO 175
C  sample Q2
        IF(IPAMDL(174).EQ.1) THEN
          YEFF = 1.D0+(1.D0-Y1)**2
 185      CONTINUE
            Q2P1 = Q2LOW1*EXP(Q2LOG1*PHO_RNDM(Y1))
            WEIGHT = (YEFF-2.D0*(1.D0-Y1)*Q2LOW1/Q2P1)/YEFF
          IF(WEIGHT.LT.PHO_RNDM(Q2P1)) GOTO 185
        ELSE
          Q2P1 = Q2LOW1
        ENDIF
        IF(IPAMDL(174).EQ.1) THEN
          YEFF = 1.D0+(1.D0-Y2)**2
 186      CONTINUE
            Q2P2 = Q2LOW2*EXP(Q2LOG2*PHO_RNDM(Y2))
            WEIGHT = (YEFF-2.D0*(1.D0-Y2)*Q2LOW2/Q2P2)/YEFF
          IF(WEIGHT.LT.PHO_RNDM(Q2P2)) GOTO 186
        ELSE
          Q2P2 = Q2LOW2
        ENDIF
C  impact parameter
        GAIMP(1) = 1.D0/SQRT(Q2P1)
        GAIMP(2) = 1.D0/SQRT(Q2P2)
C  form factor (squared)
        FF21 = 1.D0
        IF(GAIMP(1).LT.HIRADI) FF21 = 0.D0
        FF22 = 1.D0
        IF(GAIMP(2).LT.HIRADI) FF22 = 0.D0
        IF(PHO_RNDM(Q2P1).GE.FF21*FF22) GOTO 175
C  do the hadrons overlap?
        IF(ISWMDL(26).GT.0) THEN
          DO 190 K=1,2
            CALL PHO_SFECFE(SIF,COF)
            BIMP(1,K) = SIF*GAIMP(K)
            BIMP(2,K) = COF*GAIMP(K)
 190      CONTINUE
          BBABS = SQRT((BIMP(1,1)-BIMP(1,2))**2
     &                 +(BIMP(2,1)-BIMP(2,2))**2)
          IF(BBABS.LT.HIRADI+HIRADI) GOTO 175
        ENDIF
C  photon data
        GYY(1) = Y1
        GQ2(1) = Q2P1
        GYY(2) = Y2
        GQ2(2) = Q2P2
C

C  incoming hadron 1
        PINI(1,1) = 0.D0
        PINI(2,1) = 0.D0
        PINI(3,1) = EE
        PINI(4,1) = EE
        PINI(5,1) = 0.D0
C  outgoing hadron 1
        YQ2 = SQRT((1.D0-Y1)*Q2P1)
        Q2E = Q2P1/(4.D0*EE)
        E1Y = EE*(1.D0-Y1)
        CALL PHO_SFECFE(SIF,COF)
        PFIN(1,1) = YQ2*COF
        PFIN(2,1) = YQ2*SIF
        PFIN(3,1) = E1Y-Q2E
        PFIN(4,1) = E1Y+Q2E
        PFIN(5,1) = 0.D0
        PFPHI(1) = ATAN2(COF,SIF)
        PFTHE(1) = ACOS((E1Y-Q2E)/(Q2E+E1Y))
C  photon 1
        P1(1) = -PFIN(1,1)
        P1(2) = -PFIN(2,1)
        P1(3) = PINI(3,1)-PFIN(3,1)
        P1(4) = PINI(4,1)-PFIN(4,1)
C  incoming hadron 2
        PINI(1,2) = 0.D0
        PINI(2,2) = 0.D0
        PINI(3,2) = -EE
        PINI(4,2) = EE
        PINI(5,2) = 0.D0
C  outgoing hadron 2
        YQ2 = SQRT((1.D0-Y2)*Q2P2)
        Q2E = Q2P2/(4.D0*EE)
        E1Y = EE*(1.D0-Y2)
        CALL PHO_SFECFE(SIF,COF)
        PFIN(1,2) = YQ2*COF
        PFIN(2,2) = YQ2*SIF
        PFIN(3,2) = -E1Y+Q2E
        PFIN(4,2) = E1Y+Q2E
        PFIN(5,2) = 0.D0
        PFPHI(2) = ATAN2(COF,SIF)
        PFTHE(2) = ACOS((Q2E-E1Y)/(Q2E+E1Y))
C  photon 2
        P2(1) = -PFIN(1,2)
        P2(2) = -PFIN(2,2)
        P2(3) = PINI(3,2)-PFIN(3,2)
        P2(4) = PINI(4,2)-PFIN(4,2)
C  ECMS cut
        GGECM = (P1(4)+P2(4))**2-(P1(1)+P2(1))**2
     &         -(P1(2)+P2(2))**2-(P1(3)+P2(3))**2
        IF(GGECM.LT.0.1D0) GOTO 175
        GGECM = SQRT(GGECM)
        IF((GGECM.LT.ECMIN).OR.(GGECM.GT.ECMAX)) GOTO 175
C
        PGAM(1,1) = P1(1)
        PGAM(2,1) = P1(2)
        PGAM(3,1) = P1(3)
        PGAM(4,1) = P1(4)
        PGAM(5,1) = -SQRT(Q2P1)
        PGAM(1,2) = P2(1)
        PGAM(2,2) = P2(2)
        PGAM(3,2) = P2(3)
        PGAM(4,2) = P2(4)
        PGAM(5,2) = -SQRT(Q2P2)
C  photon helicities
        IGHEL(1) = 1
        IGHEL(2) = 1
C  cut given by user
        CALL PHO_PRESEL(5,IREJ)
        IF(IREJ.NE.0) GOTO 175
C  event generation
        CALL PHO_EVENT(1,P1,P2,SIGCUR,IREJ)
        IF(IREJ.NE.0) GOTO 150

C  statistics
        AY1  = AY1+Y1
        AYS1 = AYS1+Y1*Y1
        AY2  = AY2+Y2
        AYS2 = AYS2+Y2*Y2
        Q21MIN = MIN(Q21MIN,Q2P1)
        Q22MIN = MIN(Q22MIN,Q2P2)
        Q21MAX = MAX(Q21MAX,Q2P1)
        Q22MAX = MAX(Q22MAX,Q2P2)
        YY1MIN = MIN(YY1MIN,Y1)
        YY2MIN = MIN(YY2MIN,Y2)
        YY1MAX = MAX(YY1MAX,Y1)
        YY2MAX = MAX(YY2MAX,Y2)
        Q21AVE = Q21AVE+Q2P1
        Q22AVE = Q22AVE+Q2P2
        Q21AV2 = Q21AV2+Q2P1*Q2P1
        Q22AV2 = Q22AV2+Q2P2*Q2P2
C  histograms
        CALL PHO_PHIST(1,HSWGHT(0))
        CALL PHO_LHIST(1,HSWGHT(0))
 200  CONTINUE
C
      WGY  = WGMAX*DBLE(ITRY)/DBLE(ITRW)*(ALPHA/(2.D0*PI))**2
      WGY  = WGY*LOG(YMAX1/YMIN1)*LOG(YMAX2/YMIN2)
      AY1  = AY1/DBLE(NITER)
      AYS1 = AYS1/DBLE(NITER)
      DAY1 = SQRT((AYS1-AY1**2)/DBLE(NITER))
      AY2  = AY2/DBLE(NITER)
      AYS2 = AYS2/DBLE(NITER)
      DAY2 = SQRT((AYS2-AY2**2)/DBLE(NITER))
      Q21AVE = Q21AVE/DBLE(NITER)
      Q21AV2 = Q21AV2/DBLE(NITER)
      Q21AV2 = SQRT((Q21AV2-Q21AVE**2)/DBLE(NITER))
      Q22AVE = Q22AVE/DBLE(NITER)
      Q22AV2 = Q22AV2/DBLE(NITER)
      Q22AV2 = SQRT((Q22AV2-Q22AVE**2)/DBLE(NITER))
      WEIGHT = WGY*SIGMAX*DBLE(NITER)/DBLE(ITRY)
C  output of statistics, histograms
      WRITE(ErrorOut,'(//1X,A,/1X,A,1PE12.3,A,/1X,A)')
     &'=========================================================',
     &' *****   SIMULATED CROSS SECTION: ',WEIGHT,' MB  *****',
     &'========================================================='
      WRITE(ErrorOut,'(//1X,A,3I10)')
     &  'PHO_GGHIOF:SUMMARY:NITER,ITRY,ITRW',NITER,ITRY,ITRW
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'EFFECTIVE WEIGHT (FLUX,TOTAL)',
     &  WGY,WEIGHT
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Y1,DY1               ',
     &  AY1,DAY1
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Y2,DY2               ',
     &  AY2,DAY2
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Y RANGE PHOTON 1     ',
     &  YY1MIN,YY1MAX
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Y RANGE PHOTON 2     ',
     &  YY2MIN,YY2MAX
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Q2,DQ2 PHOTON 1      ',
     &  Q21AVE,Q21AV2
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Q2 RANGE PHOTON 1    ',
     &  Q21MIN,Q21MAX
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Q2,DQ2  PHOTON 2     ',
     &  Q22AVE,Q22AV2
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Q2 RANGE PHOTON 2    ',
     &  Q22MIN,Q22MAX
C
      CALL PHO_EVENT(-2,P1,P2,WEIGHT,IREJ)
      IF(NITER.GT.1) THEN
        CALL PHO_PHIST(-2,WEIGHT)
        CALL PHO_LHIST(-2,WEIGHT)
      ELSE
        WRITE(ErrorOut,
     * '(1X,A,I4)') 'PHO_GGHIOF:NO OUTPUT OF HISTOGRAMS',NITER
      ENDIF



      END


CDECK  ID>, PHO_GGHIOG
      SUBROUTINE PHO_GGHIOG(NEVENT,EEN,NA,NZ)
C**********************************************************************
C
C     interface to call PHOJET (variable energy run) for
C     gamma-gamma collisions via heavy ions (geometrical approach)
C
C
C     input:     EEN     LAB system energy per nucleon
C                NA      atomic number of ion/hadron
C                NZ      charge number of ion/hadron
C                NEVENT  number of events to generate
C            from /LEPCUT/:
C                YMIN1,2 lower limit of Y
C                        (energy fraction taken by photon from hadron)
C                YMAX1,2 upper cutoff for Y, necessary to avoid
C                        underflows
C
C      currently implemented approximation similar to:
C
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEPS = 1.D-20,
     &            PI   = 3.14159265359D0 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  photon flux kinematics and cuts
      DOUBLE PRECISION ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                 YMIN1,YMAX1,YMIN2,YMAX2,
     &                 Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                 THMIN1,THMAX1,THMIN2,THMAX2
      INTEGER          ITAG1,ITAG2
      COMMON /POFCUT/ ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                YMIN1,YMAX1,YMIN2,YMAX2,
     &                Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                THMIN1,THMAX1,THMIN2,THMAX2,
     &                ITAG1,ITAG2

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      PARAMETER (MAX_TAB=100)
      DIMENSION P1(4),P2(4),TABCU(0:MAX_TAB),TABYL(0:MAX_TAB)

C
      WRITE(ErrorOut,
     * '(2(/1X,A))') 'PHO_GGHIOG: gamma-gamma event generation',
     &                      '---------------------------------------'
C  hadron size and mass
      FM2GEV = 5.07D0
      HIMASS = DBLE(NA)*0.938D0
      HIMA2  = HIMASS**2
      HIRADI = 1.2D0*FM2GEV*DBLE(NA)**0.333
      ALPHA  = DBLE(NZ**2)/137.D0
C  total hadron / heavy ion energy
      EE     = EEN*DBLE(NA)
      GAMMA  = EE/HIMASS
C  setup /POFSRC/
      GAMSRC(1) = GAMMA
      GAMSRC(2) = GAMMA
      RADSRC(1) = HIRADI
      RADSRC(2) = HIRADI
      AMSRC(1)  = HIMASS
      AMSRC(1)  = HIMASS
C  kinematic limitations
      YMI = (ECMIN/(2.D0*EE))**2
      IF(YMIN1.LT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.5)')
     &    'PHO_GGHIOG: YMIN1 INCREASED TO (OLD/NEW)',YMIN1,YMI
        YMIN1 = YMI
      ELSE IF(YMIN1.GT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,/1X,A,E12.5,A,E12.5)')
     &    'PHO_GGHIOG:','ECM-CUT CORRESPONDS TO YMIN1 OF',YMI,
     &    '  INSTEAD OF',YMIN1
      ENDIF
      IF(YMIN2.LT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.5)')
     &    'PHO_GGHIOG: YMIN2 INCREASED TO (OLD/NEW)',YMIN2,YMI
        YMIN2 = YMI
      ELSE IF(YMIN2.GT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,/1X,A,E12.5,A,E12.5)')
     &    'PHO_GGHIOG:','ECM-CUT CORRESPONDS TO YMIN2 OF',YMI,
     &    '  INSTEAD OF',YMIN2
      ENDIF
C  debug output
      WRITE(ErrorOut,
     * '(/6X,A,2I4)')   'MASS NUMBER, CHARGE NUMBER  ',NA,NZ
      WRITE(ErrorOut,
     * '(6X,A,E12.5)') 'HADRON MASS (GeV)           ',HIMASS
      WRITE(ErrorOut,
     * '(6X,A,E12.5)') 'HADRON RADIUS (GeV**-1)     ',HIRADI
      WRITE(ErrorOut,
     * '(6X,A,E12.5)') 'LORENTZ GAMMA               ',GAMMA
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'Y RANGE PHOTON 1            ',YMIN1,
     &  YMAX1
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'Y RANGE PHOTON 2            ',YMIN2,
     &  YMAX2
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'SQRT(S) PER NUCLEON, TOTAL  ',
     &  2.D0*EEN,2.D0*EE
      WRITE(ErrorOut,
     * '(6X,A,I10)')   'EVENTS TO PROCESS           ',NEVENT
C  hadron numbers set to 0
      IDPSRC(1) = 0
      IDBSRC(1) = 0
      IDPSRC(2) = 0
      IDBSRC(2) = 0
C  table of flux function, log interpolation
      YMIN = YMIN1
      YMAX = YMAX1
      YMAX = MIN(YMAX,0.9999999D0)
      DELLY = LOG(YMAX/YMIN)/DBLE(MAX_TAB-1)
      TABYL(0) = LOG(YMIN)
      FFMAX = 0.D0
      DO 100 I=1,MAX_TAB
        Y = EXP(TABYL(0)+DELLY*DBLE(I-1))
        WG = EE*Y
        XI = WG*HIRADI/GAMMA
        FF = ALPHA*PHO_GGFLCL(XI)/Y
        FFMAX = MAX(FF,FFMAX)
        IF(FF.LT.1.D-10*FFMAX) THEN
          WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &      'PHO_GGHIOG: YMAX1 CHANGED FROM/TO',YMAX1,Y
          YMAX1 = MIN(Y,YMAX1)
          GOTO 101
        ENDIF
 100  CONTINUE
 101  CONTINUE
      YMIN = YMIN2
      YMAX = YMAX2
      YMAX = MIN(YMAX,0.9999999D0)
      DELLY = LOG(YMAX/YMIN)/DBLE(MAX_TAB-1)
      TABYL(0) = LOG(YMIN)
      FFMAX = 0.D0
      DO 102 I=1,MAX_TAB
        Y = EXP(TABYL(0)+DELLY*DBLE(I-1))
        WG = EE*Y
        XI = WG*HIRADI/GAMMA
        FF = ALPHA*PHO_GGFLCL(XI)/Y
        FFMAX = MAX(FF,FFMAX)
        IF(FF.LT.1.D-10*FFMAX) THEN
          WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &      'PHO_GGHIOG: YMAX2 CHANGED FROM/TO',YMAX2,Y
          YMAX2 = MIN(Y,YMAX2)
          GOTO 103
        ENDIF
 102  CONTINUE
 103  CONTINUE
      YMI = (ECMIN/(2.D0*EE))**2/YMAX2
      IF(YMI.GT.YMIN1) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &    'PHO_GGHIOG: YMIN1 CHANGED FROM/TO',YMIN1,YMI
        YMIN1 = YMI
      ENDIF
      YMAX1 = MIN(YMAX,YMAX1)
      YMI = (ECMIN/(2.D0*EE))**2/YMAX1
      IF(YMI.GT.YMIN2) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &    'PHO_GGHIOG: YMIN2 CHANGED FROM/TO',YMIN2,YMI
        YMIN2 = YMI
      ENDIF
C
      YMIN = YMIN1
      YMAX = YMAX1
      DELLY = LOG(YMAX/YMIN)/DBLE(MAX_TAB-1)
      TABCU(0) = 0.D0
      TABYL(0) = LOG(YMIN)
      FLUX = 0.D0
      IF(IDEB(30).GE.1) WRITE(ErrorOut,'(/1X,A,I5)')
     &  'PHO_GGHIOG: TABLE OF RAW PHOTON FLUX (SIDE 1)',MAX_TAB
      DO 105 I=1,MAX_TAB
        Y = EXP(TABYL(0)+DELLY*DBLE(I-1))
        WG = EE*Y
        XI = WG*HIRADI/GAMMA
        FF = ALPHA*PHO_GGFLCL(XI)/Y
        FFMAX = MAX(FF,FFMAX)
        TABCU(I) = TABCU(I-1)+FF*Y
        TABYL(I) = LOG(Y)
        FLUX = FLUX+Y*FF
        IF(IDEB(30).GE.1) WRITE(ErrorOut,'(5X,2E15.4)') Y,FF
 105  CONTINUE
      FLUX = FLUX*DELLY
      IF(IDEB(30).GE.1) WRITE(ErrorOut,'(1X,A,E12.4)')
     &  'PHO_GGHIOG: INTEGRATED FLUX (ONE SIDE):',FLUX
C
C  initialization
C  photon 1
      EGAM = YMAX*EE
      P1(1) = 0.D0
      P1(2) = 0.D0
      P1(3) = EGAM
      P1(4) = EGAM
C  photon 2
      EGAM = YMAX*EE
      P2(1) = 0.D0
      P2(2) = 0.D0
      P2(3) = -EGAM
      P2(4) = EGAM
      CALL PHO_SETPAR(1,22,0,0.D0)
      CALL PHO_SETPAR(2,22,0,0.D0)
      CALL PHO_EVENT(-1,P1,P2,SIGMAX,IREJ)
      CALL PHO_PHIST(-1,SIGMAX)
      CALL PHO_LHIST(-1,SIGMAX)
C
C  generation of events

      AY1  = 0.D0
      AY2  = 0.D0
      AYS1 = 0.D0
      AYS2 = 0.D0
      YY1MIN = 1.D30
      YY2MIN = 1.D30
      YY1MAX = 0.D0
      YY2MAX = 0.D0
      NITER = NEVENT
      ITRY = 0
      ITRW = 0
      DO 200 I=1,NITER
 150    CONTINUE
        ITRY = ITRY+1
 175    CONTINUE
        ITRW = ITRW+1
        XI = PHO_RNDM(AY1)*TABCU(MAX_TAB)
        DO 110 K=1,MAX_TAB
          IF(TABCU(K).GE.XI) THEN
            Y1 = DELLY/(TABCU(K)-TABCU(K-1))*(XI-TABCU(K-1))+TABYL(K-1)
            Y1 = EXP(Y1)
            GOTO 120
          ENDIF
 110    CONTINUE
        Y1 = YMAX1
 120    CONTINUE
        XI = PHO_RNDM(AY2)*TABCU(MAX_TAB)
        DO 130 K=1,MAX_TAB
          IF(TABCU(K).GE.XI) THEN
            Y2 = DELLY/(TABCU(K)-TABCU(K-1))*(XI-TABCU(K-1))+TABYL(K-1)
            Y2 = EXP(Y2)
            GOTO 140
          ENDIF
 130    CONTINUE
        Y2 = YMAX2
 140    CONTINUE
C  setup kinematics

        GYY(1) = Y1
        GQ2(1) = 0.D0
        GYY(2) = Y2
        GQ2(2) = 0.D0
C  incoming electron 1
        PINI(1,1) = 0.D0
        PINI(2,1) = 0.D0
        PINI(3,1) = EE
        PINI(4,1) = EE
        PINI(5,1) = 0.D0
C  outgoing electron 1
        E1Y = EE*(1.D0-Y1)
        PFIN(1,1) = 0.D0
        PFIN(2,1) = 0.D0
        PFIN(3,1) = E1Y
        PFIN(4,1) = E1Y
        PFIN(5,1) = 0.D0
C  photon 1
        P1(1) = -PFIN(1,1)
        P1(2) = -PFIN(2,1)
        P1(3) = PINI(3,1)-PFIN(3,1)
        P1(4) = PINI(4,1)-PFIN(4,1)
C  incoming electron 2
        PINI(1,2) = 0.D0
        PINI(2,2) = 0.D0
        PINI(3,2) = -EE
        PINI(4,2) = EE
        PINI(5,2) = 0.D0
C  outgoing electron 2
        E1Y = EE*(1.D0-Y2)
        PFIN(1,2) = 0.D0
        PFIN(2,2) = 0.D0
        PFIN(3,2) = -E1Y
        PFIN(4,2) = E1Y
        PFIN(5,2) = 0.D0
C  photon 2
        P2(1) = -PFIN(1,2)
        P2(2) = -PFIN(2,2)
        P2(3) = PINI(3,2)-PFIN(3,2)
        P2(4) = PINI(4,2)-PFIN(4,2)
C  ECMS cut
        GGECM = (P1(4)+P2(4))**2-(P1(3)+P2(3))**2
        IF(GGECM.LT.0.1D0) GOTO 175
        GGECM = SQRT(GGECM)
        IF((GGECM.LT.ECMIN).OR.(GGECM.GT.ECMAX)) GOTO 175
        PGAM(1,1) = P1(1)
        PGAM(2,1) = P1(2)
        PGAM(3,1) = P1(3)
        PGAM(4,1) = P1(4)
        PGAM(5,1) = 0.D0
        PGAM(1,2) = P2(1)
        PGAM(2,2) = P2(2)
        PGAM(3,2) = P2(3)
        PGAM(4,2) = P2(4)
        PGAM(5,2) = 0.D0
C  impact parameter constraints
        XI1   = P1(4)*HIRADI/GAMMA
        XI2   = P2(4)*HIRADI/GAMMA
        FLX   = PHO_GGFLCL(XI1)*PHO_GGFLCL(XI2)
        FCORR = PHO_GGFLCR(HIRADI)
        WGX   = (FLX-FCORR)/FLX
        IF(PHO_RNDM(Y2).GT.WGX) GOTO 175
C  photon helicities
        IGHEL(1) = 1
        IGHEL(2) = 1
C  cut given by user
        CALL PHO_PRESEL(5,IREJ)
        IF(IREJ.NE.0) GOTO 175
C  event generation
        CALL PHO_EVENT(1,P1,P2,SIGCUR,IREJ)
        IF(IREJ.NE.0) GOTO 150

C  statistics
        AY1  = AY1+Y1
        AYS1 = AYS1+Y1*Y1
        AY2  = AY2+Y2
        AYS2 = AYS2+Y2*Y2
        YY1MIN = MIN(YY1MIN,Y1)
        YY2MIN = MIN(YY2MIN,Y2)
        YY1MAX = MAX(YY1MAX,Y1)
        YY2MAX = MAX(YY2MAX,Y2)
C  histograms
        CALL PHO_PHIST(1,HSWGHT(0))
        CALL PHO_LHIST(1,HSWGHT(0))
 200  CONTINUE
C
      WGY  = FLUX**2*DBLE(ITRY)/DBLE(ITRW)
      AY1  = AY1/DBLE(NITER)
      AYS1 = AYS1/DBLE(NITER)
      DAY1 = SQRT((AYS1-AY1**2)/DBLE(NITER))
      AY2  = AY2/DBLE(NITER)
      AYS2 = AYS2/DBLE(NITER)
      DAY2 = SQRT((AYS2-AY2**2)/DBLE(NITER))
      WEIGHT = WGY*SIGMAX*DBLE(NITER)/DBLE(ITRY)
C  output of statistics, histograms
      WRITE(ErrorOut,'(//1X,A,/1X,A,1PE12.3,A,/1X,A)')
     &'=========================================================',
     &' *****   SIMULATED CROSS SECTION: ',WEIGHT,' MB  *****',
     &'========================================================='
      WRITE(ErrorOut,'(//1X,A,3I12)')
     &  'PHO_GGHIOG:SUMMARY:NITER,ITRY,ITRW',NITER,ITRY,ITRW
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'EFFECTIVE WEIGHT (FLUX,TOTAL)',
     &  WGY,WEIGHT
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Y1,DY1               ',
     &  AY1,DAY1
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Y2,DY2               ',
     &  AY2,DAY2
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Y RANGE PHOTON 1     ',
     &  YY1MIN,YY1MAX
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Y RANGE PHOTON 2     ',
     &  YY2MIN,YY2MAX

C
      CALL PHO_EVENT(-2,P1,P2,WEIGHT,IREJ)
      IF(NITER.GT.1) THEN
        CALL PHO_PHIST(-2,WEIGHT)
        CALL PHO_LHIST(-2,WEIGHT)
      ELSE
        WRITE(ErrorOut,
     * '(1X,A,I4)') 'PHO_GGHIOG:NO OUTPUT OF HISTOGRAMS',NITER
      ENDIF



      END


CDECK  ID>, PHO_GGFLCL
      DOUBLE PRECISION FUNCTION PHO_GGFLCL(XI)
C*********************************************************************
C
C     semi-classical photon flux (geometrical model)
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PHO_GGFLCL = 2.D0/3.1415927D0*(XI*PHO_BESSK0(XI)*PHO_BESSK1(XI)
     &  -XI**2/2.D0*(PHO_BESSK1(XI)**2-PHO_BESSK0(XI)**2))

      END


CDECK  ID>, PHO_GGFLCR
      DOUBLE PRECISION FUNCTION PHO_GGFLCR(XI)
C*********************************************************************
C
C     semi-classical photon flux correction due to
C     overlap in impact parameter space (geometrical model)
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (PI = 3.14159265359D0, ACCUR = 1D-2)

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)


      DIMENSION XGAUSS(126),WGAUSS(126)

      DATA XGAUSS(1)/ .57735026918962576D0/
      DATA XGAUSS(2)/-.57735026918962576D0/
      DATA WGAUSS(1)/ 1.00000000000000000D0/
      DATA WGAUSS(2)/ 1.00000000000000000D0/

      DATA XGAUSS(3)/ .33998104358485627D0/
      DATA XGAUSS(4)/ .86113631159405258D0/
      DATA XGAUSS(5)/-.33998104358485627D0/
      DATA XGAUSS(6)/-.86113631159405258D0/
      DATA WGAUSS(3)/ .65214515486254613D0/
      DATA WGAUSS(4)/ .34785484513745385D0/
      DATA WGAUSS(5)/ .65214515486254613D0/
      DATA WGAUSS(6)/ .34785484513745385D0/

      DATA XGAUSS(7)/ .18343464249564981D0/
      DATA XGAUSS(8)/ .52553240991632899D0/
      DATA XGAUSS(9)/ .79666647741362674D0/
      DATA XGAUSS(10)/ .96028985649753623D0/
      DATA XGAUSS(11)/-.18343464249564981D0/
      DATA XGAUSS(12)/-.52553240991632899D0/
      DATA XGAUSS(13)/-.79666647741362674D0/
      DATA XGAUSS(14)/-.96028985649753623D0/
      DATA WGAUSS(7)/ .36268378337836198D0/
      DATA WGAUSS(8)/ .31370664587788727D0/
      DATA WGAUSS(9)/ .22238103445337448D0/
      DATA WGAUSS(10)/ .10122853629037627D0/
      DATA WGAUSS(11)/ .36268378337836198D0/
      DATA WGAUSS(12)/ .31370664587788727D0/
      DATA WGAUSS(13)/ .22238103445337448D0/
      DATA WGAUSS(14)/ .10122853629037627D0/

      DATA XGAUSS(15)/ .0950125098376374402D0/
      DATA XGAUSS(16)/ .281603550779258913D0/
      DATA XGAUSS(17)/ .458016777657227386D0/
      DATA XGAUSS(18)/ .617876244402643748D0/
      DATA XGAUSS(19)/ .755404408355003034D0/
      DATA XGAUSS(20)/ .865631202387831744D0/
      DATA XGAUSS(21)/ .944575023073232576D0/
      DATA XGAUSS(22)/ .989400934991649933D0/
      DATA XGAUSS(23)/-.0950125098376374402D0/
      DATA XGAUSS(24)/-.281603550779258913D0/
      DATA XGAUSS(25)/-.458016777657227386D0/
      DATA XGAUSS(26)/-.617876244402643748D0/
      DATA XGAUSS(27)/-.755404408355003034D0/
      DATA XGAUSS(28)/-.865631202387831744D0/
      DATA XGAUSS(29)/-.944575023073232576D0/
      DATA XGAUSS(30)/-.989400934991649933D0/
      DATA WGAUSS(15)/ .189450610455068496D0/
      DATA WGAUSS(16)/ .182603415044923589D0/
      DATA WGAUSS(17)/ .169156519395002538D0/
      DATA WGAUSS(18)/ .149595988816576732D0/
      DATA WGAUSS(19)/ .124628971255533872D0/
      DATA WGAUSS(20)/ .0951585116824927848D0/
      DATA WGAUSS(21)/ .0622535239386478929D0/
      DATA WGAUSS(22)/ .0271524594117540949D0/
      DATA WGAUSS(23)/ .189450610455068496D0/
      DATA WGAUSS(24)/ .182603415044923589D0/
      DATA WGAUSS(25)/ .169156519395002538D0/
      DATA WGAUSS(26)/ .149595988816576732D0/
      DATA WGAUSS(27)/ .124628971255533872D0/
      DATA WGAUSS(28)/ .0951585116824927848D0/
      DATA WGAUSS(29)/ .0622535239386478929D0/
      DATA WGAUSS(30)/ .0271524594117540949D0/

      DATA XGAUSS(31)/ .0483076656877383162D0/
      DATA XGAUSS(32)/ .144471961582796493D0/
      DATA XGAUSS(33)/ .239287362252137075D0/
      DATA XGAUSS(34)/ .331868602282127650D0/
      DATA XGAUSS(35)/ .421351276130635345D0/
      DATA XGAUSS(36)/ .506899908932229390D0/
      DATA XGAUSS(37)/ .587715757240762329D0/
      DATA XGAUSS(38)/ .663044266930215201D0/
      DATA XGAUSS(39)/ .732182118740289680D0/
      DATA XGAUSS(40)/ .794483795967942407D0/
      DATA XGAUSS(41)/ .849367613732569970D0/
      DATA XGAUSS(42)/ .896321155766052124D0/
      DATA XGAUSS(43)/ .934906075937739689D0/
      DATA XGAUSS(44)/ .964762255587506430D0/
      DATA XGAUSS(45)/ .985611511545268335D0/
      DATA XGAUSS(46)/ .997263861849481564D0/
      DATA XGAUSS(47)/-.0483076656877383162D0/
      DATA XGAUSS(48)/-.144471961582796493D0/
      DATA XGAUSS(49)/-.239287362252137075D0/
      DATA XGAUSS(50)/-.331868602282127650D0/
      DATA XGAUSS(51)/-.421351276130635345D0/
      DATA XGAUSS(52)/-.506899908932229390D0/
      DATA XGAUSS(53)/-.587715757240762329D0/
      DATA XGAUSS(54)/-.663044266930215201D0/
      DATA XGAUSS(55)/-.732182118740289680D0/
      DATA XGAUSS(56)/-.794483795967942407D0/
      DATA XGAUSS(57)/-.849367613732569970D0/
      DATA XGAUSS(58)/-.896321155766052124D0/
      DATA XGAUSS(59)/-.934906075937739689D0/
      DATA XGAUSS(60)/-.964762255587506430D0/
      DATA XGAUSS(61)/-.985611511545268335D0/
      DATA XGAUSS(62)/-.997263861849481564D0/
      DATA WGAUSS(31)/ .0965400885147278006D0/
      DATA WGAUSS(32)/ .0956387200792748594D0/
      DATA WGAUSS(33)/ .0938443990808045654D0/
      DATA WGAUSS(34)/ .0911738786957638847D0/
      DATA WGAUSS(35)/ .0876520930044038111D0/
      DATA WGAUSS(36)/ .0833119242269467552D0/
      DATA WGAUSS(37)/ .0781938957870703065D0/
      DATA WGAUSS(38)/ .0723457941088485062D0/
      DATA WGAUSS(39)/ .0658222227763618468D0/
      DATA WGAUSS(40)/ .0586840934785355471D0/
      DATA WGAUSS(41)/ .0509980592623761762D0/
      DATA WGAUSS(42)/ .0428358980222266807D0/
      DATA WGAUSS(43)/ .0342738629130214331D0/
      DATA WGAUSS(44)/ .0253920653092620595D0/
      DATA WGAUSS(45)/ .0162743947309056706D0/
      DATA WGAUSS(46)/ .00701861000947009660D0/
      DATA WGAUSS(47)/ .0965400885147278006D0/
      DATA WGAUSS(48)/ .0956387200792748594D0/
      DATA WGAUSS(49)/ .0938443990808045654D0/
      DATA WGAUSS(50)/ .0911738786957638847D0/
      DATA WGAUSS(51)/ .0876520930044038111D0/
      DATA WGAUSS(52)/ .0833119242269467552D0/
      DATA WGAUSS(53)/ .0781938957870703065D0/
      DATA WGAUSS(54)/ .0723457941088485062D0/
      DATA WGAUSS(55)/ .0658222227763618468D0/
      DATA WGAUSS(56)/ .0586840934785355471D0/
      DATA WGAUSS(57)/ .0509980592623761762D0/
      DATA WGAUSS(58)/ .0428358980222266807D0/
      DATA WGAUSS(59)/ .0342738629130214331D0/
      DATA WGAUSS(60)/ .0253920653092620595D0/
      DATA WGAUSS(61)/ .0162743947309056706D0/
      DATA WGAUSS(62)/ .00701861000947009660D0/

      DATA XGAUSS(63)/ .02435029266342443250D0/
      DATA XGAUSS(64)/ .0729931217877990394D0/
      DATA XGAUSS(65)/ .121462819296120554D0/
      DATA XGAUSS(66)/ .169644420423992818D0/
      DATA XGAUSS(67)/ .217423643740007084D0/
      DATA XGAUSS(68)/ .264687162208767416D0/
      DATA XGAUSS(69)/ .311322871990210956D0/
      DATA XGAUSS(70)/ .357220158337668116D0/
      DATA XGAUSS(71)/ .402270157963991604D0/
      DATA XGAUSS(72)/ .446366017253464088D0/
      DATA XGAUSS(73)/ .489403145707052957D0/
      DATA XGAUSS(74)/ .531279464019894546D0/
      DATA XGAUSS(75)/ .571895646202634034D0/
      DATA XGAUSS(76)/ .611155355172393250D0/
      DATA XGAUSS(77)/ .648965471254657340D0/
      DATA XGAUSS(78)/ .685236313054233243D0/
      DATA XGAUSS(79)/ .719881850171610827D0/
      DATA XGAUSS(80)/ .752819907260531897D0/
      DATA XGAUSS(81)/ .783972358943341408D0/
      DATA XGAUSS(82)/ .813265315122797560D0/
      DATA XGAUSS(83)/ .840629296252580363D0/
      DATA XGAUSS(84)/ .865999398154092820D0/
      DATA XGAUSS(85)/ .889315445995114106D0/
      DATA XGAUSS(86)/ .910522137078502806D0/
      DATA XGAUSS(87)/ .929569172131939576D0/
      DATA XGAUSS(88)/ .946411374858402816D0/
      DATA XGAUSS(89)/ .961008799652053719D0/
      DATA XGAUSS(90)/ .973326827789910964D0/
      DATA XGAUSS(91)/ .983336253884625957D0/
      DATA XGAUSS(92)/ .991013371476744321D0/
      DATA XGAUSS(93)/ .996340116771955279D0/
      DATA XGAUSS(94)/ .999305041735772139D0/
      DATA XGAUSS(95)/-.02435029266342443250D0/
      DATA XGAUSS(96)/-.0729931217877990394D0/
      DATA XGAUSS(97)/-.121462819296120554D0/
      DATA XGAUSS(98)/-.169644420423992818D0/
      DATA XGAUSS(99)/-.217423643740007084D0/
      DATA XGAUSS(100)/-.264687162208767416D0/
      DATA XGAUSS(101)/-.311322871990210956D0/
      DATA XGAUSS(102)/-.357220158337668116D0/
      DATA XGAUSS(103)/-.402270157963991604D0/
      DATA XGAUSS(104)/-.446366017253464088D0/
      DATA XGAUSS(105)/-.489403145707052957D0/
      DATA XGAUSS(106)/-.531279464019894546D0/
      DATA XGAUSS(107)/-.571895646202634034D0/
      DATA XGAUSS(108)/-.611155355172393250D0/
      DATA XGAUSS(109)/-.648965471254657340D0/
      DATA XGAUSS(110)/-.685236313054233243D0/
      DATA XGAUSS(111)/-.719881850171610827D0/
      DATA XGAUSS(112)/-.752819907260531897D0/
      DATA XGAUSS(113)/-.783972358943341408D0/
      DATA XGAUSS(114)/-.813265315122797560D0/
      DATA XGAUSS(115)/-.840629296252580363D0/
      DATA XGAUSS(116)/-.865999398154092820D0/
      DATA XGAUSS(117)/-.889315445995114106D0/
      DATA XGAUSS(118)/-.910522137078502806D0/
      DATA XGAUSS(119)/-.929569172131939576D0/
      DATA XGAUSS(120)/-.946411374858402816D0/
      DATA XGAUSS(121)/-.961008799652053719D0/
      DATA XGAUSS(122)/-.973326827789910964D0/
      DATA XGAUSS(123)/-.983336253884625957D0/
      DATA XGAUSS(124)/-.991013371476744321D0/
      DATA XGAUSS(125)/-.996340116771955279D0/
      DATA XGAUSS(126)/-.999305041735772139D0/
      DATA WGAUSS(63)/ .0486909570091397204D0/
      DATA WGAUSS(64)/ .0485754674415034269D0/
      DATA WGAUSS(65)/ .0483447622348029572D0/
      DATA WGAUSS(66)/ .0479993885964583077D0/
      DATA WGAUSS(67)/ .0475401657148303087D0/
      DATA WGAUSS(68)/ .0469681828162100173D0/
      DATA WGAUSS(69)/ .0462847965813144172D0/
      DATA WGAUSS(70)/ .0454916279274181445D0/
      DATA WGAUSS(71)/ .0445905581637565631D0/
      DATA WGAUSS(72)/ .0435837245293234534D0/
      DATA WGAUSS(73)/ .0424735151236535890D0/
      DATA WGAUSS(74)/ .0412625632426235286D0/
      DATA WGAUSS(75)/ .0399537411327203414D0/
      DATA WGAUSS(76)/ .0385501531786156291D0/
      DATA WGAUSS(77)/ .0370551285402400460D0/
      DATA WGAUSS(78)/ .0354722132568823838D0/
      DATA WGAUSS(79)/ .0338051618371416094D0/
      DATA WGAUSS(80)/ .0320579283548515535D0/
      DATA WGAUSS(81)/ .0302346570724024789D0/
      DATA WGAUSS(82)/ .0283396726142594832D0/
      DATA WGAUSS(83)/ .0263774697150546587D0/
      DATA WGAUSS(84)/ .0243527025687108733D0/
      DATA WGAUSS(85)/ .0222701738083832542D0/
      DATA WGAUSS(86)/ .0201348231535302094D0/
      DATA WGAUSS(87)/ .0179517157756973431D0/
      DATA WGAUSS(88)/ .0157260304760247193D0/
      DATA WGAUSS(89)/ .0134630478967186426D0/
      DATA WGAUSS(90)/ .0111681394601311288D0/
      DATA WGAUSS(91)/ .00884675982636394772D0/
      DATA WGAUSS(92)/ .00650445796897836286D0/
      DATA WGAUSS(93)/ .00414703326056246764D0/
      DATA WGAUSS(94)/ .00178328072169643295D0/
      DATA WGAUSS(95)/ .0486909570091397204D0/
      DATA WGAUSS(96)/ .0485754674415034269D0/
      DATA WGAUSS(97)/ .0483447622348029572D0/
      DATA WGAUSS(98)/ .0479993885964583077D0/
      DATA WGAUSS(99)/ .0475401657148303087D0/
      DATA WGAUSS(100)/ .0469681828162100173D0/
      DATA WGAUSS(101)/ .0462847965813144172D0/
      DATA WGAUSS(102)/ .0454916279274181445D0/
      DATA WGAUSS(103)/ .0445905581637565631D0/
      DATA WGAUSS(104)/ .0435837245293234534D0/
      DATA WGAUSS(105)/ .0424735151236535890D0/
      DATA WGAUSS(106)/ .0412625632426235286D0/
      DATA WGAUSS(107)/ .0399537411327203414D0/
      DATA WGAUSS(108)/ .0385501531786156291D0/
      DATA WGAUSS(109)/ .0370551285402400460D0/
      DATA WGAUSS(110)/ .0354722132568823838D0/
      DATA WGAUSS(111)/ .0338051618371416094D0/
      DATA WGAUSS(112)/ .0320579283548515535D0/
      DATA WGAUSS(113)/ .0302346570724024789D0/
      DATA WGAUSS(114)/ .0283396726142594832D0/
      DATA WGAUSS(115)/ .0263774697150546587D0/
      DATA WGAUSS(116)/ .0243527025687108733D0/
      DATA WGAUSS(117)/ .0222701738083832542D0/
      DATA WGAUSS(118)/ .0201348231535302094D0/
      DATA WGAUSS(119)/ .0179517157756973431D0/
      DATA WGAUSS(120)/ .0157260304760247193D0/
      DATA WGAUSS(121)/ .0134630478967186426D0/
      DATA WGAUSS(122)/ .0111681394601311288D0/
      DATA WGAUSS(123)/ .00884675982636394772D0/
      DATA WGAUSS(124)/ .00650445796897836286D0/
      DATA WGAUSS(125)/ .00414703326056246764D0/
      DATA WGAUSS(126)/ .00178328072169643295D0/

C integrate first over b1
C
C Loop incrementing the boundary
C
      TMIN = 0.D0
      TMAX = 0.25D0
      SUM  = 0.D0

 50   CONTINUE

C
C Loop for the Gauss integration
C
      XINT=0.D0
      DO 100 N=1,6
        XINT2 = XINT
        XINT=0.D0
        DO 200 I=2**N-1,2**(N+1)-2
          T = (TMAX-TMIN)/2.D0*XGAUSS(I)+(TMAX+TMIN)/2.D0
          B1 = RADSRC(1) * EXP (T)
          XINT=XINT+WGAUSS(I) * PHO_GGFAUX(B1) * B1**2
 200    CONTINUE
        XINT = (TMAX-TMIN)/2.D0*XINT
        IF (ABS ((XINT2-XINT)/XINT) .LT. ACCUR) GOTO 300
 100  CONTINUE
        WRITE(*,*) ' (b1) GAUSS MAY BE INACCURATE'
 300  CONTINUE

      SUM = SUM + XINT
      IF (ABS (XINT2/SUM) .GT. ACCUR) THEN
        TMIN = TMAX
        TMAX = TMAX + 0.5D0
        GOTO 50
      ENDIF

      PHO_GGFLCR = 4.D0*PI * SUM

      END


CDECK  ID>, PHO_GGFAUX
      DOUBLE PRECISION FUNCTION PHO_GGFAUX(B1)
C*********************************************************************
C
C     auxiliary function for integration over b2,
C     semi-classical photon flux correction due to
C     overlap in impact parameter space (geometrical model)
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (PI = 3.14159265359D0, ACCUR = 1D-2)

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)


      DIMENSION XGAUSS(126),WGAUSS(126)

      DATA XGAUSS(1)/ .57735026918962576D0/
      DATA XGAUSS(2)/-.57735026918962576D0/
      DATA WGAUSS(1)/ 1.00000000000000000D0/
      DATA WGAUSS(2)/ 1.00000000000000000D0/

      DATA XGAUSS(3)/ .33998104358485627D0/
      DATA XGAUSS(4)/ .86113631159405258D0/
      DATA XGAUSS(5)/-.33998104358485627D0/
      DATA XGAUSS(6)/-.86113631159405258D0/
      DATA WGAUSS(3)/ .65214515486254613D0/
      DATA WGAUSS(4)/ .34785484513745385D0/
      DATA WGAUSS(5)/ .65214515486254613D0/
      DATA WGAUSS(6)/ .34785484513745385D0/

      DATA XGAUSS(7)/ .18343464249564981D0/
      DATA XGAUSS(8)/ .52553240991632899D0/
      DATA XGAUSS(9)/ .79666647741362674D0/
      DATA XGAUSS(10)/ .96028985649753623D0/
      DATA XGAUSS(11)/-.18343464249564981D0/
      DATA XGAUSS(12)/-.52553240991632899D0/
      DATA XGAUSS(13)/-.79666647741362674D0/
      DATA XGAUSS(14)/-.96028985649753623D0/
      DATA WGAUSS(7)/ .36268378337836198D0/
      DATA WGAUSS(8)/ .31370664587788727D0/
      DATA WGAUSS(9)/ .22238103445337448D0/
      DATA WGAUSS(10)/ .10122853629037627D0/
      DATA WGAUSS(11)/ .36268378337836198D0/
      DATA WGAUSS(12)/ .31370664587788727D0/
      DATA WGAUSS(13)/ .22238103445337448D0/
      DATA WGAUSS(14)/ .10122853629037627D0/

      DATA XGAUSS(15)/ .0950125098376374402D0/
      DATA XGAUSS(16)/ .281603550779258913D0/
      DATA XGAUSS(17)/ .458016777657227386D0/
      DATA XGAUSS(18)/ .617876244402643748D0/
      DATA XGAUSS(19)/ .755404408355003034D0/
      DATA XGAUSS(20)/ .865631202387831744D0/
      DATA XGAUSS(21)/ .944575023073232576D0/
      DATA XGAUSS(22)/ .989400934991649933D0/
      DATA XGAUSS(23)/-.0950125098376374402D0/
      DATA XGAUSS(24)/-.281603550779258913D0/
      DATA XGAUSS(25)/-.458016777657227386D0/
      DATA XGAUSS(26)/-.617876244402643748D0/
      DATA XGAUSS(27)/-.755404408355003034D0/
      DATA XGAUSS(28)/-.865631202387831744D0/
      DATA XGAUSS(29)/-.944575023073232576D0/
      DATA XGAUSS(30)/-.989400934991649933D0/
      DATA WGAUSS(15)/ .189450610455068496D0/
      DATA WGAUSS(16)/ .182603415044923589D0/
      DATA WGAUSS(17)/ .169156519395002538D0/
      DATA WGAUSS(18)/ .149595988816576732D0/
      DATA WGAUSS(19)/ .124628971255533872D0/
      DATA WGAUSS(20)/ .0951585116824927848D0/
      DATA WGAUSS(21)/ .0622535239386478929D0/
      DATA WGAUSS(22)/ .0271524594117540949D0/
      DATA WGAUSS(23)/ .189450610455068496D0/
      DATA WGAUSS(24)/ .182603415044923589D0/
      DATA WGAUSS(25)/ .169156519395002538D0/
      DATA WGAUSS(26)/ .149595988816576732D0/
      DATA WGAUSS(27)/ .124628971255533872D0/
      DATA WGAUSS(28)/ .0951585116824927848D0/
      DATA WGAUSS(29)/ .0622535239386478929D0/
      DATA WGAUSS(30)/ .0271524594117540949D0/

      DATA XGAUSS(31)/ .0483076656877383162D0/
      DATA XGAUSS(32)/ .144471961582796493D0/
      DATA XGAUSS(33)/ .239287362252137075D0/
      DATA XGAUSS(34)/ .331868602282127650D0/
      DATA XGAUSS(35)/ .421351276130635345D0/
      DATA XGAUSS(36)/ .506899908932229390D0/
      DATA XGAUSS(37)/ .587715757240762329D0/
      DATA XGAUSS(38)/ .663044266930215201D0/
      DATA XGAUSS(39)/ .732182118740289680D0/
      DATA XGAUSS(40)/ .794483795967942407D0/
      DATA XGAUSS(41)/ .849367613732569970D0/
      DATA XGAUSS(42)/ .896321155766052124D0/
      DATA XGAUSS(43)/ .934906075937739689D0/
      DATA XGAUSS(44)/ .964762255587506430D0/
      DATA XGAUSS(45)/ .985611511545268335D0/
      DATA XGAUSS(46)/ .997263861849481564D0/
      DATA XGAUSS(47)/-.0483076656877383162D0/
      DATA XGAUSS(48)/-.144471961582796493D0/
      DATA XGAUSS(49)/-.239287362252137075D0/
      DATA XGAUSS(50)/-.331868602282127650D0/
      DATA XGAUSS(51)/-.421351276130635345D0/
      DATA XGAUSS(52)/-.506899908932229390D0/
      DATA XGAUSS(53)/-.587715757240762329D0/
      DATA XGAUSS(54)/-.663044266930215201D0/
      DATA XGAUSS(55)/-.732182118740289680D0/
      DATA XGAUSS(56)/-.794483795967942407D0/
      DATA XGAUSS(57)/-.849367613732569970D0/
      DATA XGAUSS(58)/-.896321155766052124D0/
      DATA XGAUSS(59)/-.934906075937739689D0/
      DATA XGAUSS(60)/-.964762255587506430D0/
      DATA XGAUSS(61)/-.985611511545268335D0/
      DATA XGAUSS(62)/-.997263861849481564D0/
      DATA WGAUSS(31)/ .0965400885147278006D0/
      DATA WGAUSS(32)/ .0956387200792748594D0/
      DATA WGAUSS(33)/ .0938443990808045654D0/
      DATA WGAUSS(34)/ .0911738786957638847D0/
      DATA WGAUSS(35)/ .0876520930044038111D0/
      DATA WGAUSS(36)/ .0833119242269467552D0/
      DATA WGAUSS(37)/ .0781938957870703065D0/
      DATA WGAUSS(38)/ .0723457941088485062D0/
      DATA WGAUSS(39)/ .0658222227763618468D0/
      DATA WGAUSS(40)/ .0586840934785355471D0/
      DATA WGAUSS(41)/ .0509980592623761762D0/
      DATA WGAUSS(42)/ .0428358980222266807D0/
      DATA WGAUSS(43)/ .0342738629130214331D0/
      DATA WGAUSS(44)/ .0253920653092620595D0/
      DATA WGAUSS(45)/ .0162743947309056706D0/
      DATA WGAUSS(46)/ .00701861000947009660D0/
      DATA WGAUSS(47)/ .0965400885147278006D0/
      DATA WGAUSS(48)/ .0956387200792748594D0/
      DATA WGAUSS(49)/ .0938443990808045654D0/
      DATA WGAUSS(50)/ .0911738786957638847D0/
      DATA WGAUSS(51)/ .0876520930044038111D0/
      DATA WGAUSS(52)/ .0833119242269467552D0/
      DATA WGAUSS(53)/ .0781938957870703065D0/
      DATA WGAUSS(54)/ .0723457941088485062D0/
      DATA WGAUSS(55)/ .0658222227763618468D0/
      DATA WGAUSS(56)/ .0586840934785355471D0/
      DATA WGAUSS(57)/ .0509980592623761762D0/
      DATA WGAUSS(58)/ .0428358980222266807D0/
      DATA WGAUSS(59)/ .0342738629130214331D0/
      DATA WGAUSS(60)/ .0253920653092620595D0/
      DATA WGAUSS(61)/ .0162743947309056706D0/
      DATA WGAUSS(62)/ .00701861000947009660D0/

      DATA XGAUSS(63)/ .02435029266342443250D0/
      DATA XGAUSS(64)/ .0729931217877990394D0/
      DATA XGAUSS(65)/ .121462819296120554D0/
      DATA XGAUSS(66)/ .169644420423992818D0/
      DATA XGAUSS(67)/ .217423643740007084D0/
      DATA XGAUSS(68)/ .264687162208767416D0/
      DATA XGAUSS(69)/ .311322871990210956D0/
      DATA XGAUSS(70)/ .357220158337668116D0/
      DATA XGAUSS(71)/ .402270157963991604D0/
      DATA XGAUSS(72)/ .446366017253464088D0/
      DATA XGAUSS(73)/ .489403145707052957D0/
      DATA XGAUSS(74)/ .531279464019894546D0/
      DATA XGAUSS(75)/ .571895646202634034D0/
      DATA XGAUSS(76)/ .611155355172393250D0/
      DATA XGAUSS(77)/ .648965471254657340D0/
      DATA XGAUSS(78)/ .685236313054233243D0/
      DATA XGAUSS(79)/ .719881850171610827D0/
      DATA XGAUSS(80)/ .752819907260531897D0/
      DATA XGAUSS(81)/ .783972358943341408D0/
      DATA XGAUSS(82)/ .813265315122797560D0/
      DATA XGAUSS(83)/ .840629296252580363D0/
      DATA XGAUSS(84)/ .865999398154092820D0/
      DATA XGAUSS(85)/ .889315445995114106D0/
      DATA XGAUSS(86)/ .910522137078502806D0/
      DATA XGAUSS(87)/ .929569172131939576D0/
      DATA XGAUSS(88)/ .946411374858402816D0/
      DATA XGAUSS(89)/ .961008799652053719D0/
      DATA XGAUSS(90)/ .973326827789910964D0/
      DATA XGAUSS(91)/ .983336253884625957D0/
      DATA XGAUSS(92)/ .991013371476744321D0/
      DATA XGAUSS(93)/ .996340116771955279D0/
      DATA XGAUSS(94)/ .999305041735772139D0/
      DATA XGAUSS(95)/-.02435029266342443250D0/
      DATA XGAUSS(96)/-.0729931217877990394D0/
      DATA XGAUSS(97)/-.121462819296120554D0/
      DATA XGAUSS(98)/-.169644420423992818D0/
      DATA XGAUSS(99)/-.217423643740007084D0/
      DATA XGAUSS(100)/-.264687162208767416D0/
      DATA XGAUSS(101)/-.311322871990210956D0/
      DATA XGAUSS(102)/-.357220158337668116D0/
      DATA XGAUSS(103)/-.402270157963991604D0/
      DATA XGAUSS(104)/-.446366017253464088D0/
      DATA XGAUSS(105)/-.489403145707052957D0/
      DATA XGAUSS(106)/-.531279464019894546D0/
      DATA XGAUSS(107)/-.571895646202634034D0/
      DATA XGAUSS(108)/-.611155355172393250D0/
      DATA XGAUSS(109)/-.648965471254657340D0/
      DATA XGAUSS(110)/-.685236313054233243D0/
      DATA XGAUSS(111)/-.719881850171610827D0/
      DATA XGAUSS(112)/-.752819907260531897D0/
      DATA XGAUSS(113)/-.783972358943341408D0/
      DATA XGAUSS(114)/-.813265315122797560D0/
      DATA XGAUSS(115)/-.840629296252580363D0/
      DATA XGAUSS(116)/-.865999398154092820D0/
      DATA XGAUSS(117)/-.889315445995114106D0/
      DATA XGAUSS(118)/-.910522137078502806D0/
      DATA XGAUSS(119)/-.929569172131939576D0/
      DATA XGAUSS(120)/-.946411374858402816D0/
      DATA XGAUSS(121)/-.961008799652053719D0/
      DATA XGAUSS(122)/-.973326827789910964D0/
      DATA XGAUSS(123)/-.983336253884625957D0/
      DATA XGAUSS(124)/-.991013371476744321D0/
      DATA XGAUSS(125)/-.996340116771955279D0/
      DATA XGAUSS(126)/-.999305041735772139D0/
      DATA WGAUSS(63)/ .0486909570091397204D0/
      DATA WGAUSS(64)/ .0485754674415034269D0/
      DATA WGAUSS(65)/ .0483447622348029572D0/
      DATA WGAUSS(66)/ .0479993885964583077D0/
      DATA WGAUSS(67)/ .0475401657148303087D0/
      DATA WGAUSS(68)/ .0469681828162100173D0/
      DATA WGAUSS(69)/ .0462847965813144172D0/
      DATA WGAUSS(70)/ .0454916279274181445D0/
      DATA WGAUSS(71)/ .0445905581637565631D0/
      DATA WGAUSS(72)/ .0435837245293234534D0/
      DATA WGAUSS(73)/ .0424735151236535890D0/
      DATA WGAUSS(74)/ .0412625632426235286D0/
      DATA WGAUSS(75)/ .0399537411327203414D0/
      DATA WGAUSS(76)/ .0385501531786156291D0/
      DATA WGAUSS(77)/ .0370551285402400460D0/
      DATA WGAUSS(78)/ .0354722132568823838D0/
      DATA WGAUSS(79)/ .0338051618371416094D0/
      DATA WGAUSS(80)/ .0320579283548515535D0/
      DATA WGAUSS(81)/ .0302346570724024789D0/
      DATA WGAUSS(82)/ .0283396726142594832D0/
      DATA WGAUSS(83)/ .0263774697150546587D0/
      DATA WGAUSS(84)/ .0243527025687108733D0/
      DATA WGAUSS(85)/ .0222701738083832542D0/
      DATA WGAUSS(86)/ .0201348231535302094D0/
      DATA WGAUSS(87)/ .0179517157756973431D0/
      DATA WGAUSS(88)/ .0157260304760247193D0/
      DATA WGAUSS(89)/ .0134630478967186426D0/
      DATA WGAUSS(90)/ .0111681394601311288D0/
      DATA WGAUSS(91)/ .00884675982636394772D0/
      DATA WGAUSS(92)/ .00650445796897836286D0/
      DATA WGAUSS(93)/ .00414703326056246764D0/
      DATA WGAUSS(94)/ .00178328072169643295D0/
      DATA WGAUSS(95)/ .0486909570091397204D0/
      DATA WGAUSS(96)/ .0485754674415034269D0/
      DATA WGAUSS(97)/ .0483447622348029572D0/
      DATA WGAUSS(98)/ .0479993885964583077D0/
      DATA WGAUSS(99)/ .0475401657148303087D0/
      DATA WGAUSS(100)/ .0469681828162100173D0/
      DATA WGAUSS(101)/ .0462847965813144172D0/
      DATA WGAUSS(102)/ .0454916279274181445D0/
      DATA WGAUSS(103)/ .0445905581637565631D0/
      DATA WGAUSS(104)/ .0435837245293234534D0/
      DATA WGAUSS(105)/ .0424735151236535890D0/
      DATA WGAUSS(106)/ .0412625632426235286D0/
      DATA WGAUSS(107)/ .0399537411327203414D0/
      DATA WGAUSS(108)/ .0385501531786156291D0/
      DATA WGAUSS(109)/ .0370551285402400460D0/
      DATA WGAUSS(110)/ .0354722132568823838D0/
      DATA WGAUSS(111)/ .0338051618371416094D0/
      DATA WGAUSS(112)/ .0320579283548515535D0/
      DATA WGAUSS(113)/ .0302346570724024789D0/
      DATA WGAUSS(114)/ .0283396726142594832D0/
      DATA WGAUSS(115)/ .0263774697150546587D0/
      DATA WGAUSS(116)/ .0243527025687108733D0/
      DATA WGAUSS(117)/ .0222701738083832542D0/
      DATA WGAUSS(118)/ .0201348231535302094D0/
      DATA WGAUSS(119)/ .0179517157756973431D0/
      DATA WGAUSS(120)/ .0157260304760247193D0/
      DATA WGAUSS(121)/ .0134630478967186426D0/
      DATA WGAUSS(122)/ .0111681394601311288D0/
      DATA WGAUSS(123)/ .00884675982636394772D0/
      DATA WGAUSS(124)/ .00650445796897836286D0/
      DATA WGAUSS(125)/ .00414703326056246764D0/
      DATA WGAUSS(126)/ .00178328072169643295D0/
C
      W1 = PGAM(4,1)
      W2 = PGAM(4,2)
      BMIN = B1 - 2.D0*RADSRC(1)
      IF (RADSRC(1) .GT. BMIN) THEN
        BMIN = RADSRC(1)
      ENDIF
      BMAX = B1 + 2.D0 * RADSRC(1)

      XINT = 0.D0
      DO 100 N=1,6
        XINT2 = XINT
        XINT = 0.D0
        DO 200 I=2**N-1,2**(N+1)-2
          B2 = (BMAX-BMIN)/2.D0*XGAUSS(I)+(BMAX+BMIN)/2.D0
          XINT3 = PHO_GGFNUC(W1,B1,GAMSRC(1))
     &      * PHO_GGFNUC(W2,B2,GAMSRC(2))
     &      * ACOS ((B1**2+B2**2-4.D0*RADSRC(1)**2)/(2.D0*B1*B2))
          XINT = XINT +WGAUSS(I) * B2 * XINT3
 200    CONTINUE
        XINT = (BMAX-BMIN)/2.D0*XINT
        IF (ABS((XINT2 - XINT)/XINT) .LT. ACCUR) GOTO 300
 100  CONTINUE
      WRITE(*,*) ' (b2) GAUSS MAY BE INACCURATE'
 300  CONTINUE

      PHO_GGFAUX = XINT

      END


CDECK  ID>, PHO_GGFNUC
      DOUBLE PRECISION FUNCTION PHO_GGFNUC(W,RHO,GAMMA)
C**********************************************************************
C
C      differential photonnumber for a nucleus (geometrical model)
C      (without form factor)
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (PI = 3.14159265359D0)

      WGAMMA = W/GAMMA
      WPHIB = WGAMMA * PHO_BESSK1(WGAMMA*RHO)

      PHO_GGFNUC = 1.D0/PI**2 * WPHIB**2

      END


CDECK  ID>, PHO_GHHIOF
      SUBROUTINE PHO_GHHIOF(NEVENT,EEN,NA,NZ)
C**********************************************************************
C
C     interface to call PHOJET (variable energy run) for
C     gamma-hadron collisions in heavy ion collisions
C     (form factor approach)
C
C     input:     EEN     LAB system energy per nucleon
C                NA      atomic number of ion/hadron
C                NZ      charge number of ion/hadron
C                NEVENT  number of events to generate
C            from /LEPCUT/:
C                YMIN1,2 lower limit of Y
C                        (energy fraction taken by photon from hadron)
C                YMAX1,2 upper cutoff for Y, necessary to avoid
C                        underflows
C                Q2MIN1,2 minimum Q**2 of photons (should be set to 0)
C                Q2MAX1,2 maximum Q**2 of photons (if necessary,
C                        corrected according size of hadron)
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( PI   = 3.14159265359D0 )

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  photon flux kinematics and cuts
      DOUBLE PRECISION ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                 YMIN1,YMAX1,YMIN2,YMAX2,
     &                 Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                 THMIN1,THMAX1,THMIN2,THMAX2
      INTEGER          ITAG1,ITAG2
      COMMON /POFCUT/ ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                YMIN1,YMAX1,YMIN2,YMAX2,
     &                Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                THMIN1,THMAX1,THMIN2,THMAX2,
     &                ITAG1,ITAG2

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      DIMENSION P1(4),P2(4)
      DIMENSION NITERS(2),ITRW(2)


      WRITE(ErrorOut,
     * '(2(/1X,A))') 'PHO_GHHIOF: gamma-hadron event generation',
     &                      '----------------------------------------'
C  hadron size and mass
      FM2GEV = 5.07D0
      HIMASS = DBLE(NA)*0.938D0
      HIMA2  = HIMASS**2
      HIRADI = 1.2D0*FM2GEV*DBLE(NA)**0.333
      ALPHA  = DBLE(NZ**2)/137.D0
      AMP  = 0.938D0
      AMP2 = AMP**2
C  correct Q2MAX1,2 according to hadron size
      Q2MAXH = 2.D0/HIRADI**2
      Q2MAX1 = MIN(Q2MAX1,Q2MAXH)
      Q2MAX2 = MIN(Q2MAX2,Q2MAXH)
      IF(Q2MAX1.LT.1.D-20) Q2MAX1 = Q2MAXH
      IF(Q2MAX2.LT.1.D-20) Q2MAX2 = Q2MAXH
C  total hadron / heavy ion energy
      EE = EEN*DBLE(NA)
      GAMMA = EE/HIMASS
C  setup /POFSRC/
      GAMSRC(1) = GAMMA
      GAMSRC(2) = GAMMA
      RADSRC(1) = HIRADI
      RADSRC(2) = HIRADI
      AMSRC(1)  = HIMASS
      AMSRC(2)  = HIMASS
C  check cuts on photon-hadron mass
      IF((0.765D0+PARMDL(46)).GT.(PARMDL(45)*ECMIN)) THEN
        YMI = ECMIN
        ECMIN =  PARMDL(46)/PARMDL(45)+0.1D0
        WRITE(ErrorOut,'(/1X,A,2E12.5)')
     &    'PHO_GHHIOF: ECMIN CORRECTED TO (OLD/NEW)',YMI,ECMIN
      ENDIF
C  check kinematic limitations
      YMI = ECMIN**2/(4.D0*EE*EEN)
      IF(YMIN1.LT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.5)')
     &    'PHO_GHHIOF: YMIN1 INCREASED TO (OLD/NEW)',YMIN1,YMI
        YMIN1 = YMI
      ELSE IF(YMIN1.GT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,/1X,A,E12.5,A,E12.5)')
     &    'PHO_GHHIOF:','ECM-CUT CORRESPONDS TO YMIN1 OF',YMI,
     &    '  INSTEAD OF',YMIN1
      ENDIF
      IF(YMIN2.LT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.5)')
     &    'PHO_GHHIOF: YMIN2 INCREASED TO (OLD/NEW)',YMIN2,YMI
        YMIN2 = YMI
      ELSE IF(YMIN2.GT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,/1X,A,E12.5,A,E12.5)')
     &    'PHO_GHHIOF:','ECM-CUT CORRESPONDS TO YMIN2 OF',YMI,
     &    '  INSTEAD OF',YMIN2
      ENDIF
C  kinematic limitation
      Q2LOW1 = MAX(Q2MIN1,HIMA2*YMIN1**2/(1.D0-YMIN1))
      Q2LOW2 = MAX(Q2MIN2,HIMA2*YMIN2**2/(1.D0-YMIN2))
C  debug output
      WRITE(ErrorOut,
     * '(/6X,A,2I4)')   'MASS NUMBER, CHARGE NUMBER  ',NA,NZ
      WRITE(ErrorOut,
     * '(6X,A,E12.5)') 'HADRON MASS (GeV)           ',HIMASS
      WRITE(ErrorOut,
     * '(6X,A,E12.5)') 'HADRON RADIUS (GeV**-1)     ',HIRADI
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'Q**2 RANGE PHOTON 1 (GEV**2)',Q2LOW1,
     &  Q2MAX1
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'Q**2 RANGE PHOTON 2 (GEV**2)',Q2LOW2,
     &  Q2MAX2
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'Y RANGE PHOTON 1            ',YMIN1,
     &  YMAX1
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'Y RANGE PHOTON 2            ',YMIN2,
     &  YMAX2
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'SQRT(S) PER NUCLEON, TOTAL  ',
     &  2.D0*EEN,2.D0*EE
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'INV.MASS PHOTON-HADRON      ',ECMIN,
     &  ECMAX
      WRITE(ErrorOut,
     * '(6X,A,E12.5)') 'MIN. INV.MASS PHOTON-POMERON',
     &  PARMDL(175)
      WRITE(ErrorOut,
     * '(6X,A,I10)')   'EVENTS TO PROCESS           ',NEVENT
      IF(Q2LOW1.GE.Q2MAX1) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &    'PHO_GHHIOF:ERROR:INCONSISTENT Q**2 RANGE 1',Q2LOW1,Q2MAX1
        CALL PHO_ABORT
      ENDIF
      IF(Q2LOW2.GE.Q2MAX2) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &    'PHO_GHHIOF:ERROR:INCONSISTENT Q**2 RANGE 2',Q2LOW2,Q2MAX2
        CALL PHO_ABORT
      ENDIF
C  hadron numbers set to 0
      IDPSRC(1) = 0
      IDPSRC(2) = 0
      IDBSRC(1) = 0
      IDBSRC(2) = 0
C
      MAX_TAB = 100
      YMAX = YMAX1
      YMIN = YMIN1
      XMAX = LOG(YMAX)
      XMIN = LOG(YMIN)
      XDEL = XMAX-XMIN
      DELLY = LOG(YMAX/YMIN)/DBLE(MAX_TAB-1)
      DO 100 I=1,MAX_TAB
        Y1 = EXP(XMIN+DELLY*DBLE(I-1))
        Q2LOW1 = MAX(Q2MIN1,HIMA2*Y1*Y1/(1.D0-Y1))
        IF(Q2LOW1.GE.Q2MAX1) THEN
          WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &      'PHO_GHHIOF: YMAX1 CHANGED FROM/TO',YMAX1,Y1
          YMAX1 = MIN(Y1,YMAX1)
          GOTO 101
        ENDIF
 100  CONTINUE
 101  CONTINUE
      YMAX = YMAX2
      YMIN = YMIN2
      XMAX = LOG(YMAX)
      XMIN = LOG(YMIN)
      XDEL = XMAX-XMIN
      DELLY = LOG(YMAX/YMIN)/DBLE(MAX_TAB-1)
      DO 102 I=1,MAX_TAB
        Y1 = EXP(XMIN+DELLY*DBLE(I-1))
        Q2LOW2 = MAX(Q2MIN2,HIMA2*Y1*Y1/(1.D0-Y1))
        IF(Q2LOW2.GE.Q2MAX2) THEN
          WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &      'PHO_GHHIOF: YMAX2 CHANGED FROM/TO',YMAX2,Y1
          YMAX2 = MIN(Y1,YMAX2)
          GOTO 103
        ENDIF
 102  CONTINUE
 103  CONTINUE
C
      X1MAX = LOG(YMAX1)
      X1MIN = LOG(YMIN1)
      X1DEL = X1MAX-X1MIN
      X2MAX = LOG(YMAX2)
      X2MIN = LOG(YMIN2)
      X2DEL = X2MAX-X2MIN
      DELLY = LOG(YMAX1/YMIN1)/DBLE(MAX_TAB-1)
      FLUX = 0.D0
      IF(IDEB(30).GE.1) WRITE(ErrorOut,'(/1X,A,I5)')
     &  'PHO_GHHIOF: TABLE OF RAW PHOTON FLUX (SIDE 1)',MAX_TAB
      DO 105 I=1,MAX_TAB
        Y1 = EXP(X1MIN+DELLY*DBLE(I-1))
        Q2LOW1 = MAX(Q2MIN1,HIMA2*Y1*Y1/(1.D0-Y1))
        FF = ((1.D0+(1.D0-Y1)**2)/Y1*LOG(Q2MAX1/Q2LOW1)
     &        -2.D0*HIMA2*Y1*(1.D0/Q2LOW1-1.D0/Q2MAX1))*ALPHA/(2.D0*PI)
        FLUX = FLUX+Y1*FF
        IF(IDEB(30).GE.1) WRITE(ErrorOut,'(5X,2E15.4)') Y1,FF
 105  CONTINUE
      FLUX = FLUX*DELLY
      IF(IDEB(30).GE.1) WRITE(ErrorOut,'(1X,A,E12.4)')
     &  'PHO_GHHIOF: INTEGRATED FLUX (ONE SIDE):',FLUX
C
C  photon
      EGAM = MAX(YMAX1,YMAX2)*EE
      P1(1) = 0.D0
      P1(2) = 0.D0
      P1(3) = EGAM
      P1(4) = EGAM
C  hadron
      P2(1) = 0.D0
      P2(2) = 0.D0
      P2(3) = -SQRT(EEN**2-AMP2)
      P2(4) = EEN
      CALL PHO_SETPAR(1,22,0,0.D0)
      CALL PHO_SETPAR(2,2212,0,0.D0)
      CALL PHO_EVENT(-1,P1,P2,SIGMAX,IREJ)
C
      Q2LOW1 = MAX(Q2MIN1,HIMA2*YMIN1**2/(1.D0-YMIN1))
      Q2LOW2 = MAX(Q2MIN2,HIMA2*YMIN2**2/(1.D0-YMIN2))
      Y1 = YMIN1
      Y2 = YMIN2
      WGMAX1 = (1.D0+(1.D0-Y1)**2)*LOG(Q2MAX1/Q2LOW1)
     &         -2.D0*HIMA2*Y1*(1.D0/Q2LOW1-1.D0/Q2MAX1)*Y1
      WGMAX2 = (1.D0+(1.D0-Y2)**2)*LOG(Q2MAX2/Q2LOW2)
     &         -2.D0*HIMA2*Y2*(1.D0/Q2LOW2-1.D0/Q2MAX2)*Y2
C
      IF(IPAMDL(175).EQ.1) WGMAX2 = 0.D0
      IF(IPAMDL(175).EQ.2) WGMAX1 = 0.D0
C
      FAC12 = WGMAX1*LOG(YMAX1/YMIN1)
     &       /(WGMAX1*LOG(YMAX1/YMIN1)+WGMAX2*LOG(YMAX2/YMIN2))
C
      CALL PHO_PHIST(-1,SIGMAX)
      CALL PHO_LHIST(-1,SIGMAX)
C
C  generation of events, flux calculation

      AY1  = 0.D0
      AY2  = 0.D0
      AYS1 = 0.D0
      AYS2 = 0.D0
      Q21MIN = 1.D30
      Q22MIN = 1.D30
      Q21MAX = 0.D0
      Q22MAX = 0.D0
      Q21AVE = 0.D0
      Q22AVE = 0.D0
      Q21AV2 = 0.D0
      Q22AV2 = 0.D0
      YY1MIN = 1.D30
      YY2MIN = 1.D30
      YY1MAX = 0.D0
      YY2MAX = 0.D0
      NITER = NEVENT
      NITERS(1) = 0
      NITERS(2) = 0
      ITRY = 0
      ITRW(1) = 0
      ITRW(2) = 0
      DO 200 I=1,NITER
C  sample y1, y2
 150    CONTINUE
        ITRY = ITRY+1
 175    CONTINUE
C
C  select side of photon emission
        IF(PHO_RNDM(AY1).LT.FAC12) THEN
          ITRW(1) = ITRW(1)+1
C  select Y1
          Y1 = EXP(X1DEL*PHO_RNDM(AY1)+X1MIN)
          Q2LOW1 = MAX(Q2MIN1,HIMA2*Y1**2/(1.D0-Y1))
          IF(Q2LOW1.GE.Q2MAX1) GOTO 175
          Q2LOG1 = LOG(Q2MAX1/Q2LOW1)
          WGH = (1.D0+(1.D0-Y1)**2)*Q2LOG1
     &          -2.D0*HIMA2*Y1*(1.D0/Q2LOW1-1.D0/Q2MAX1)*Y1
          IF(WGMAX1.LT.WGH) WRITE(ErrorOut,'(1X,A,3E12.5)')
     &        'PHO_GHHIOF:WEIGHT ERROR (1):',Y1,WGMAX1,WGH
          IF(PHO_RNDM(AYS1)*WGMAX1.GT.WGH) GOTO 175
C  sample Q2
          IF(IPAMDL(174).EQ.1) THEN
            YEFF = 1.D0+(1.D0-Y1)**2
 185        CONTINUE
              Q2P1 = Q2LOW1*EXP(Q2LOG1*PHO_RNDM(Y1))
              WEIGHT = (YEFF-2.D0*(1.D0-Y1)*Q2LOW1/Q2P1)/YEFF
            IF(WEIGHT.LT.PHO_RNDM(Q2P1)) GOTO 185
          ELSE
            Q2P1 = Q2LOW1
          ENDIF
C  impact parameter
          GAIMP(1) = 1.D0/SQRT(Q2P1)
C  form factor (squared)
          FF2 = 1.D0
          IF(GAIMP(1).LT.2.D0*HIRADI) FF2 = 0.D0
          IF(PHO_RNDM(Q2P1).GE.FF2) GOTO 175
C  photon data
          GYY(1) = Y1
          GQ2(1) = Q2P1

C
C  incoming hadron 1
          PINI(1,1) = 0.D0
          PINI(2,1) = 0.D0
          PINI(3,1) = SQRT(EE**2-AMP2)
          PINI(4,1) = EE
          PINI(5,1) = AMP
C  outgoing hadron 1
          YQ2 = SQRT((1.D0-Y1)*Q2P1)
          Q2E = Q2P1/(4.D0*EE)
          E1Y = EE*(1.D0-Y1)
          CALL PHO_SFECFE(SIF,COF)
          PFIN(1,1) = YQ2*COF
          PFIN(2,1) = YQ2*SIF
          PFIN(3,1) = E1Y-Q2E
          PFIN(4,1) = E1Y+Q2E
          PFIN(5,1) = 0.D0
          PFPHI(1) = ATAN2(COF,SIF)
          PFTHE(1) = ACOS((E1Y-Q2E)/(Q2E+E1Y))
C  incoming hadron 2
          PINI(1,2) = 0.D0
          PINI(2,2) = 0.D0
          PINI(3,2) = -SQRT(EE**2-AMP2)
          PINI(4,2) = EE
          PINI(5,2) = AMP
C  scattering photon
          P1(1) = -PFIN(1,1)
          P1(2) = -PFIN(2,1)
          P1(3) = PINI(3,1)-PFIN(3,1)
          P1(4) = PINI(4,1)-PFIN(4,1)
C  scattering hadron
          P2(1) = 0.D0
          P2(2) = 0.D0
          P2(3) = -SQRT(EEN**2-AMP2)
          P2(4) = EEN
          ISIDE = 1
C
        ELSE
C
          ITRW(2) = ITRW(2)+1
C  select Y2
          Y2 = EXP(X2DEL*PHO_RNDM(AY2)+X2MIN)
          Q2LOW2 = MAX(Q2MIN2,HIMA2*Y2**2/(1.D0-Y2))
          IF(Q2LOW2.GE.Q2MAX2) GOTO 175
          Q2LOG2 = LOG(Q2MAX2/Q2LOW2)
          WGH = (1.D0+(1.D0-Y2)**2)*Q2LOG2
     &          -2.D0*HIMA2*Y2*(1.D0/Q2LOW2-1.D0/Q2MAX2)*Y2
          IF(WGMAX2.LT.WGH) WRITE(ErrorOut,'(1X,A,3E12.5)')
     &        'PHO_GHHIOF:WEIGHT ERROR (2):',Y2,WGMAX2,WGH
          IF(PHO_RNDM(AYS1)*WGMAX2.GT.WGH) GOTO 175
C  sample Q2
          IF(IPAMDL(174).EQ.1) THEN
            YEFF = 1.D0+(1.D0-Y2)**2
 186        CONTINUE
              Q2P2 = Q2LOW2*EXP(Q2LOG2*PHO_RNDM(Y2))
              WEIGHT = (YEFF-2.D0*(1.D0-Y2)*Q2LOW2/Q2P2)/YEFF
            IF(WEIGHT.LT.PHO_RNDM(Q2P2)) GOTO 186
          ELSE
            Q2P2 = Q2LOW2
          ENDIF
C  impact parameter
          GAIMP(2) = 1.D0/SQRT(Q2P2)
C  form factor (squared)
          FF2 = 1.D0
          IF(GAIMP(2).LT.2.D0*HIRADI) FF2 = 0.D0
          IF(PHO_RNDM(Q2P2).GE.FF2) GOTO 175
C  photon data
          GYY(2) = Y2
          GQ2(2) = Q2P2

C
C  incoming hadron 1
          PINI(1,1) = 0.D0
          PINI(2,1) = 0.D0
          PINI(3,1) = SQRT(EE**2-AMP2)
          PINI(4,1) = EE
          PINI(5,1) = AMP
C  incoming hadron 2
          PINI(1,2) = 0.D0
          PINI(2,2) = 0.D0
          PINI(3,2) = -SQRT(EE**2-AMP2)
          PINI(4,2) = EE
          PINI(5,2) = AMP
C  outgoing hadron 2
          YQ2 = SQRT((1.D0-Y2)*Q2P2)
          Q2E = Q2P2/(4.D0*EE)
          E1Y = EE*(1.D0-Y2)
          CALL PHO_SFECFE(SIF,COF)
          PFIN(1,2) = YQ2*COF
          PFIN(2,2) = YQ2*SIF
          PFIN(3,2) = -E1Y+Q2E
          PFIN(4,2) = E1Y+Q2E
          PFIN(5,2) = 0.D0
          PFPHI(2) = ATAN2(COF,SIF)
          PFTHE(2) = ACOS((Q2E-E1Y)/(Q2E+E1Y))
C  scattering hadron
          P2(1) = 0.D0
          P2(2) = 0.D0
          P2(3) = SQRT(EEN**2-AMP2)
          P2(4) = EEN
C  scattering photon
          P1(1) = -PFIN(1,2)
          P1(2) = -PFIN(2,2)
          P1(3) = PINI(3,2)-PFIN(3,2)
          P1(4) = PINI(4,2)-PFIN(4,2)
          ISIDE = 2
        ENDIF
C  ECMS cut
        GGECM = (P1(4)+P2(4))**2-(P1(1)+P2(1))**2
     &         -(P1(2)+P2(2))**2-(P1(3)+P2(3))**2
        IF(GGECM.LT.0.1D0) GOTO 175
        GGECM = SQRT(GGECM)
        IF((GGECM.LT.ECMIN).OR.(GGECM.GT.ECMAX)) GOTO 175
C
        PGAM(1,1) = P1(1)
        PGAM(2,1) = P1(2)
        PGAM(3,1) = P1(3)
        PGAM(4,1) = P1(4)
        PGAM(5,1) = -SQRT(Q2P1)
        PGAM(1,2) = P2(1)
        PGAM(2,2) = P2(2)
        PGAM(3,2) = P2(3)
        PGAM(4,2) = P2(4)
        PGAM(5,2) = -SQRT(Q2P2)
        CALL PHO_PRESEL(5,IREJ)
C  photon helicities
        IGHEL(1) = 1
        IGHEL(2) = 1
C  user cuts
        IF(IREJ.NE.0) GOTO 175
C  event generation
        CALL PHO_EVENT(1,P1,P2,SIGCUR,IREJ)
        IF(IREJ.NE.0) GOTO 150
C  cut on diffractive mass
        DO 250 K=1,NHEP
          IF(ISTHEP(K).EQ.30) THEN
            GHDIFF = PHEP(1,K)
            IF(GHDIFF.GE.PARMDL(175)) THEN
              GOTO 251
            ELSE
              GOTO 150
            ENDIF
          ENDIF
 250    CONTINUE
        WRITE(ErrorOut,'(/,1X,A)')
     &    'PHO_GHHIOF: NO DIFFRACTIVE ENTRY FOUND'
          CALL PHO_PREVNT(-1)
        GOTO 150
 251    CONTINUE
C  remove quasi-elastically scattered hadron
        DO 260 K=1,NHEP
          IF((ISTHEP(K).EQ.1).AND.(IDHEP(K).EQ.2212)) THEN
            XF = ABS(PHEP(3,K)/EEN)
            IF(XF.LT.PARMDL(72)) GOTO 150
*           ISTHEP(K) = 2
            GOTO 261
          ENDIF
 260    CONTINUE
 261    CONTINUE
C
C  statistics

        NITERS(ISIDE) = NITERS(ISIDE)+1
        IF(ISIDE.EQ.1) THEN

          AY1  = AY1+Y1
          AYS1 = AYS1+Y1*Y1
          Q21AVE = Q21AVE+Q2P1
          Q21AV2 = Q21AV2+Q2P1*Q2P1
          Q21MIN = MIN(Q21MIN,Q2P1)
          Q21MAX = MAX(Q21MAX,Q2P1)
          YY1MIN = MIN(YY1MIN,Y1)
          YY1MAX = MAX(YY1MAX,Y1)
        ELSE

          AY2  = AY2+Y2
          AYS2 = AYS2+Y2*Y2
          Q22AVE = Q22AVE+Q2P2
          Q22AV2 = Q22AV2+Q2P2*Q2P2
          Q22MIN = MIN(Q22MIN,Q2P2)
          Q22MAX = MAX(Q22MAX,Q2P2)
          YY2MIN = MIN(YY2MIN,Y2)
          YY2MAX = MAX(YY2MAX,Y2)
        ENDIF
C  histograms
        CALL PHO_PHIST(1,HSWGHT(0))
        CALL PHO_LHIST(1,HSWGHT(0))
 200  CONTINUE
C
      WGMAX = WGMAX1*LOG(YMAX1/YMIN1)*FAC12
      WGY1 = WGMAX*DBLE(ITRY)/DBLE(MAX(ITRW(1),1))*ALPHA/(2.D0*PI)
      WGMAX = WGMAX2*LOG(YMAX2/YMIN2)*(1.D0-FAC12)
      WGY2 = WGMAX*DBLE(ITRY)/DBLE(MAX(ITRW(2),1))*ALPHA/(2.D0*PI)
      AY1  = AY1/DBLE(MAX(NITERS(1),1))
      AYS1 = AYS1/DBLE(MAX(NITERS(1),1))
      DAY1 = SQRT((AYS1-AY1**2)/DBLE(MAX(NITERS(1),1)))
      AY2  = AY2/DBLE(MAX(NITERS(2),1))
      AYS2 = AYS2/DBLE(MAX(NITERS(2),1))
      DAY2 = SQRT((AYS2-AY2**2)/DBLE(MAX(NITERS(2),1)))
      Q21AVE = Q21AVE/DBLE(MAX(NITERS(1),1))
      Q21AV2 = Q21AV2/DBLE(MAX(NITERS(1),1))
      Q21AV2 = SQRT((Q21AV2-Q21AVE**2)/DBLE(MAX(NITERS(1),1)))
      Q22AVE = Q22AVE/DBLE(MAX(NITERS(2),1))
      Q22AV2 = Q22AV2/DBLE(MAX(NITERS(2),1))
      Q22AV2 = SQRT((Q22AV2-Q22AVE**2)/DBLE(MAX(NITERS(2),1)))
      WGMAX  = WGMAX1*LOG(YMAX1/YMIN1)+WGMAX2*LOG(YMAX2/YMIN2)
      WGY    = WGMAX*DBLE(ITRY)/DBLE(ITRW(1)+ITRW(2))*ALPHA/(2.D0*PI)
      WEIGHT = WGY*SIGMAX*DBLE(NITER)/DBLE(ITRY)
C  output of statistics, histograms
      WRITE(ErrorOut,'(//1X,A,/1X,A,1PE12.3,A,/1X,A)')
     &'=========================================================',
     &' *****   SIMULATED CROSS SECTION: ',WEIGHT,' MB  *****',
     &'========================================================='
      WRITE(ErrorOut,'(//1X,A,/3X,6I12)')
     &  'PHO_GHHIOF:SUMMARY:  NITER,   NITERS1/2,   ITRY,    ITRW1,2',
     &  NITER,NITERS,ITRY,ITRW
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'EFFECTIVE WEIGHT (FLUX,TOTAL)',
     &  WGY,WEIGHT
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Y1,DY1               ',
     &  AY1,DAY1
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Y2,DY2               ',
     &  AY2,DAY2
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Y RANGE PHOTON 1     ',
     &  YY1MIN,YY1MAX
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Y RANGE PHOTON 2     ',
     &  YY2MIN,YY2MAX
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Q2,DQ2 PHOTON 1      ',
     &  Q21AVE,Q21AV2
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Q2 RANGE PHOTON 1    ',
     &  Q21MIN,Q21MAX
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Q2,DQ2  PHOTON 2     ',
     &  Q22AVE,Q22AV2
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Q2 RANGE PHOTON 2    ',
     &  Q22MIN,Q22MAX
C
      CALL PHO_EVENT(-2,P1,P2,WEIGHT,IREJ)
      IF(NITER.GT.1) THEN
        CALL PHO_PHIST(-2,WEIGHT)
        CALL PHO_LHIST(-2,WEIGHT)
      ELSE
        WRITE(ErrorOut,
     * '(1X,A,I4)') 'PHO_GHHIOF:NO OUTPUT OF HISTOGRAMS',NITER
      ENDIF



      END


CDECK  ID>, PHO_GHHIAS
      SUBROUTINE PHO_GHHIAS(NEVENT,EEP,EEN,NA,NZ)
C**********************************************************************
C
C     interface to call PHOJET (variable energy run) for
C     gamma-hadron collisions in heavy ion - hadron
C     collisions (form factor approach)
C
C     input:     EEP     LAB system energy of proton (GeV)
C                EEN     LAB system energy per nucleon (GeV)
C                NA      atomic number of ion/hadron
C                NZ      charge number of ion/hadron
C                NEVENT  number of events to generate
C            from /LEPCUT/:
C                YMIN2   lower limit of Y
C                        (energy fraction taken by photon from hadron)
C                YMAX2   upper cutoff for Y, necessary to avoid
C                        underflows
C                Q2MIN2  minimum Q**2 of photons (should be set to 0)
C                Q2MAX2  maximum Q**2 of photons (if necessary,
C                        corrected according size of hadron)
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( PI   = 3.14159265359D0 )

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  photon flux kinematics and cuts
      DOUBLE PRECISION ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                 YMIN1,YMAX1,YMIN2,YMAX2,
     &                 Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                 THMIN1,THMAX1,THMIN2,THMAX2
      INTEGER          ITAG1,ITAG2
      COMMON /POFCUT/ ECMIN,ECMAX,EEMIN1,EEMIN2,
     &                YMIN1,YMAX1,YMIN2,YMAX2,
     &                Q2MIN1,Q2MAX1,Q2MIN2,Q2MAX2,
     &                THMIN1,THMAX1,THMIN2,THMAX2,
     &                ITAG1,ITAG2

C  gamma-lepton or gamma-hadron vertex information
      INTEGER IGHEL,IDPSRC,IDBSRC
      DOUBLE PRECISION PINI,PFIN,PGAM,GYY,GQ2,GGECM,GAIMP,PFTHE,PFPHI,
     &                 RADSRC,AMSRC,GAMSRC
      COMMON /POFSRC/ PINI(5,2),PFIN(5,2),PGAM(5,2),IGHEL(2),
     &                GYY(2),GQ2(2),GGECM,GAIMP(2),PFTHE(2),PFPHI(2),
     &                IDPSRC(2),IDBSRC(2),RADSRC(2),AMSRC(2),GAMSRC(2)

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  event weights and generated cross section
      INTEGER IPOWGC,ISWCUT,IVWGHT
      DOUBLE PRECISION SIGGEN,HSWGHT,HSWCUT,EVWGHT
      COMMON /POWGHT/ SIGGEN(4),HSWGHT(0:10),HSWCUT(20),EVWGHT(0:10),
     &                IPOWGC(0:10),ISWCUT(20),IVWGHT(0:10)


      DIMENSION P1(4),P2(4)


      WRITE(ErrorOut,
     * '(2(/1X,A))') 'PHO_GHHIAS: hadron-gamma event generation',
     &                      '-----------------------------------------'
C  hadron size and mass
      FM2GEV = 5.07D0
      HIMASS = DBLE(NA)*0.938D0
      HIMA2  = HIMASS**2
      HIRADI = 1.2D0*FM2GEV*DBLE(NA)**0.333
      ALPHA  = DBLE(NZ**2)/137.D0
      AMP  = 0.938D0
      AMP2 = AMP**2
C  correct Q2MAX2 according to hadron size
      Q2MAXH = 2.D0/HIRADI**2
      Q2MAX2 = MIN(Q2MAX2,Q2MAXH)
      IF(Q2MAX2.LT.1.D-20) Q2MAX2 = Q2MAXH
C  total hadron / heavy ion energy
      EE = EEN*DBLE(NA)
      GAMMA = EE/HIMASS
C  setup /POFSRC/
      GAMSRC(2) = GAMMA
      RADSRC(2) = HIRADI
      AMSRC(2)  = HIMASS
C  check kinematic limitations
      YMI = ECMIN**2/(4.D0*EE*EEP)
      IF(YMIN2.LT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.5)')
     &    'PHO_GHHIOF: YMIN2 INCREASED TO (OLD/NEW)',YMIN2,YMI
        YMIN2 = YMI
      ELSE IF(YMIN2.GT.YMI) THEN
        WRITE(ErrorOut,'(/1X,A,/1X,A,E12.5,A,E12.5)')
     &    'PHO_GHHIOF:','ECM-CUT CORRESPONDS TO YMIN2 OF',YMI,
     &    '  INSTEAD OF',YMIN2
      ENDIF
C  kinematic limitation
      Q2LOW2 = MAX(Q2MIN2,HIMA2*YMIN2**2/(1.D0-YMIN2))
C  debug output
      WRITE(ErrorOut,
     * '(/6X,A,2I4)')   'MASS NUMBER, CHARGE NUMBER  ',NA,NZ
      WRITE(ErrorOut,
     * '(6X,A,E12.5)') 'HEAVY ION MASS (GeV)        ',HIMASS
      WRITE(ErrorOut,
     * '(6X,A,E12.5)') 'HEAVY ION  RADIUS (GeV**-1) ',HIRADI
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'Q**2 RANGE PHOTON 2 (GEV**2)',Q2LOW2,
     &  Q2MAX2
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'Y RANGE PHOTON 2            ',YMIN2,
     &  YMAX2
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'SQRT(S) PER NUCLEON, TOTAL  ',
     &  2.D0*SQRT(EEN*EEP),2.D0*SQRT(EE*EEP)
      WRITE(ErrorOut,
     * '(6X,A,2E12.5)') 'INV.MASS HADRON-PHOTON      ',ECMIN,
     &  ECMAX
      WRITE(ErrorOut,
     * '(6X,A,I10)')   'EVENTS TO PROCESS           ',NEVENT
      IF(Q2LOW2.GE.Q2MAX2) THEN
        WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &    'PHO_GHHIOF:ERROR:INCONSISTENT Q**2 RANGE 2',Q2LOW2,Q2MAX2
        CALL PHO_ABORT
      ENDIF
C  hadron numbers set to 0
      IDPSRC(1) = 0
      IDPSRC(2) = 0
      IDBSRC(1) = 0
      IDBSRC(2) = 0
C
      MAX_TAB = 100
      YMAX = YMAX2
      YMIN = YMIN2
      XMAX = LOG(YMAX)
      XMIN = LOG(YMIN)
      XDEL = XMAX-XMIN
      DELLY = LOG(YMAX/YMIN)/DBLE(MAX_TAB-1)
      DO 102 I=1,MAX_TAB
        Y1 = EXP(XMIN+DELLY*DBLE(I-1))
        Q2LOW2 = MAX(Q2MIN2,HIMA2*Y1*Y1/(1.D0-Y1))
        IF(Q2LOW2.GE.Q2MAX2) THEN
          WRITE(ErrorOut,'(/1X,A,2E12.4)')
     &      'PHO_GHHIOF: YMAX2 CHANGED FROM/TO',YMAX2,Y1
          YMAX2 = MIN(Y1,YMAX2)
          GOTO 103
        ENDIF
 102  CONTINUE
 103  CONTINUE
C
      X2MAX = LOG(YMAX2)
      X2MIN = LOG(YMIN2)
      X2DEL = X2MAX-X2MIN
      DELLY = LOG(YMAX2/YMIN2)/DBLE(MAX_TAB-1)
      FLUX = 0.D0
      IF(IDEB(30).GE.1) WRITE(ErrorOut,'(/1X,A,I5)')
     &  'PHO_GHHIAS: TABLE OF RAW PHOTON FLUX (SIDE 2)',MAX_TAB
      DO 105 I=1,MAX_TAB
        Y2 = EXP(X2MIN+DELLY*DBLE(I-1))
        Q2LOW2 = MAX(Q2MIN2,HIMA2*Y2*Y2/(1.D0-Y2))
        FF = ((1.D0+(1.D0-Y2)**2)/Y2*LOG(Q2MAX2/Q2LOW2)
     &        -2.D0*HIMA2*Y2*(1.D0/Q2LOW2-1.D0/Q2MAX2))*ALPHA/(2.D0*PI)
        FLUX = FLUX+Y2*FF
        IF(IDEB(30).GE.1) WRITE(ErrorOut,'(5X,2E15.4)') Y2,FF
 105  CONTINUE
      FLUX = FLUX*DELLY
      IF(IDEB(30).GE.1) WRITE(ErrorOut,'(1X,A,E12.4)')
     &  'PHO_GHHIAS: INTEGRATED FLUX:',FLUX
C
C  hadron
      P1(1) = 0.D0
      P1(2) = 0.D0
      P1(3) = -SQRT(EEP**2-AMP2)
      P1(4) = EEP
C  photon
      EGAM = YMAX2*EE
      P2(1) = 0.D0
      P2(2) = 0.D0
      P2(3) = EGAM
      P2(4) = EGAM
      CALL PHO_SETPAR(1,2212,0,0.D0)
      CALL PHO_SETPAR(2,22,0,0.D0)
      CALL PHO_EVENT(-1,P1,P2,SIGMAX,IREJ)
C
      Q2LOW2 = MAX(Q2MIN2,HIMA2*YMIN2**2/(1.D0-YMIN2))
      Y2 = YMIN2
      WGMAX2 = (1.D0+(1.D0-Y2)**2)*LOG(Q2MAX2/Q2LOW2)
     &         -2.D0*HIMA2*Y2*(1.D0/Q2LOW2-1.D0/Q2MAX2)*Y2
C
      CALL PHO_PHIST(-1,SIGMAX)
      CALL PHO_LHIST(-1,SIGMAX)
C
C  generation of events, flux calculation

      AY1  = 0.D0
      AY2  = 0.D0
      AYS1 = 0.D0
      AYS2 = 0.D0
      Q22MIN = 1.D30
      Q22MAX = 0.D0
      Q22AVE = 0.D0
      Q22AV2 = 0.D0
      YY2MIN = 1.D30
      YY2MAX = 0.D0
      NITER = NEVENT
      NITERS = 0
      ITRY = 0
      ITRW = 0
      DO 200 I=1,NITER
C  sample photon flux
 150    CONTINUE
        ITRY = ITRY+1
 175    CONTINUE
C
          ITRW = ITRW+1
C  select Y2
          Y2 = EXP(X2DEL*PHO_RNDM(AY2)+X2MIN)
          Q2LOW2 = MAX(Q2MIN2,HIMA2*Y2**2/(1.D0-Y2))
          IF(Q2LOW2.GE.Q2MAX2) GOTO 175
          Q2LOG2 = LOG(Q2MAX2/Q2LOW2)
          WGH = (1.D0+(1.D0-Y2)**2)*Q2LOG2
     &          -2.D0*HIMA2*Y2*(1.D0/Q2LOW2-1.D0/Q2MAX2)*Y2
          IF(WGMAX2.LT.WGH) WRITE(ErrorOut,'(1X,A,3E12.5)')
     &        'PHO_GHHIOF:WEIGHT ERROR (2):',Y2,WGMAX2,WGH
          IF(PHO_RNDM(AYS1)*WGMAX2.GT.WGH) GOTO 175
C  sample Q2
          IF(IPAMDL(174).EQ.1) THEN
            YEFF = 1.D0+(1.D0-Y2)**2
 186        CONTINUE
              Q2P2 = Q2LOW2*EXP(Q2LOG2*PHO_RNDM(Y2))
              WEIGHT = (YEFF-2.D0*(1.D0-Y2)*Q2LOW2/Q2P2)/YEFF
            IF(WEIGHT.LT.PHO_RNDM(Q2P2)) GOTO 186
          ELSE
            Q2P2 = Q2LOW2
          ENDIF
C  impact parameter
          GAIMP(2) = 1.D0/SQRT(Q2P2)
C  form factor (squared)
          FF2 = 1.D0
          IF(GAIMP(2).LT.2.D0*HIRADI) FF2 = 0.D0
          IF(PHO_RNDM(Q2P2).GE.FF2) GOTO 175
C  photon data
          GYY(2) = Y2
          GQ2(2) = Q2P2

C
C  incoming hadron 1
          PINI(1,1) = 0.D0
          PINI(2,1) = 0.D0
          PINI(3,1) = SQRT(EEP**2-AMP2)
          PINI(4,1) = EEP
          PINI(5,1) = AMP
C  incoming hadron 2
          PINI(1,2) = 0.D0
          PINI(2,2) = 0.D0
          PINI(3,2) = -SQRT(EE**2-AMP2)
          PINI(4,2) = EE
          PINI(5,2) = AMP
C  outgoing hadron 2
          YQ2 = SQRT((1.D0-Y2)*Q2P2)
          Q2E = Q2P2/(4.D0*EE)
          E1Y = EE*(1.D0-Y2)
          CALL PHO_SFECFE(SIF,COF)
          PFIN(1,2) = YQ2*COF
          PFIN(2,2) = YQ2*SIF
          PFIN(3,2) = -E1Y+Q2E
          PFIN(4,2) = E1Y+Q2E
          PFIN(5,2) = 0.D0
          PFPHI(2) = ATAN2(COF,SIF)
          PFTHE(2) = ACOS((Q2E-E1Y)/(Q2E+E1Y))
C  scattering hadron
          P1(1) = 0.D0
          P1(2) = 0.D0
          P1(3) = SQRT(EEP**2-AMP2)
          P1(4) = EEP
          Q2P1  = AMP2
C  scattering photon
          P2(1) = -PFIN(1,2)
          P2(2) = -PFIN(2,2)
          P2(3) = PINI(3,2)-PFIN(3,2)
          P2(4) = PINI(4,2)-PFIN(4,2)
          ISIDE = 2
C
C  ECMS cut
        GGECM = (P1(4)+P2(4))**2-(P1(1)+P2(1))**2
     &         -(P1(2)+P2(2))**2-(P1(3)+P2(3))**2
        IF(GGECM.LT.0.1D0) GOTO 175
        GGECM = SQRT(GGECM)
        IF((GGECM.LT.ECMIN).OR.(GGECM.GT.ECMAX)) GOTO 175
C
        PGAM(1,1) = P1(1)
        PGAM(2,1) = P1(2)
        PGAM(3,1) = P1(3)
        PGAM(4,1) = P1(4)
        PGAM(5,1) = AMP
        PGAM(1,2) = P2(1)
        PGAM(2,2) = P2(2)
        PGAM(3,2) = P2(3)
        PGAM(4,2) = P2(4)
        PGAM(5,2) = -SQRT(Q2P2)
C  photon helicities
        IGHEL(2) = 1
C  user cuts
        CALL PHO_PRESEL(5,IREJ)
        IF(IREJ.NE.0) GOTO 175
C  event generation
        CALL PHO_EVENT(1,P1,P2,SIGCUR,IREJ)
        IF(IREJ.NE.0) GOTO 150
C  cut on diffractive mass
        DO 250 K=1,NHEP
          IF(ISTHEP(K).EQ.30) THEN
            GHDIFF = PHEP(1,K)
            IF(GHDIFF.GE.PARMDL(175)) THEN
              GOTO 251
            ELSE
              GOTO 150
            ENDIF
          ENDIF
 250    CONTINUE
        WRITE(ErrorOut,'(/,1X,A)')
     &    'PHO_GHHIOF: NO DIFFRACTIVE ENTRY FOUND'
          CALL PHO_PREVNT(-1)
        GOTO 150
 251    CONTINUE
C  remove quasi-elastically scattered hadron
        DO 260 K=1,NHEP
          IF((ISTHEP(K).EQ.1).AND.(IDHEP(K).EQ.2212)) THEN
            XF = ABS(PHEP(3,K)/EEN)
            IF(XF.LT.PARMDL(72)) GOTO 150
*           ISTHEP(K) = 2
            GOTO 261
          ENDIF
 260    CONTINUE
 261    CONTINUE
C
C  statistics

        NITERS = NITERS+1

        AY2  = AY2+Y2
        AYS2 = AYS2+Y2*Y2
        Q22AVE = Q22AVE+Q2P2
        Q22AV2 = Q22AV2+Q2P2*Q2P2
        Q22MIN = MIN(Q22MIN,Q2P2)
        Q22MAX = MAX(Q22MAX,Q2P2)
        YY2MIN = MIN(YY2MIN,Y2)
        YY2MAX = MAX(YY2MAX,Y2)
C  histograms
        CALL PHO_PHIST(1,HSWGHT(0))
        CALL PHO_LHIST(1,HSWGHT(0))
 200  CONTINUE
C
      WGMAX = WGMAX2*LOG(YMAX2/YMIN2)
      WGY2 = WGMAX*DBLE(ITRY)/DBLE(MAX(ITRW,1))*ALPHA/(2.D0*PI)
      AY2  = AY2/DBLE(MAX(NITERS,1))
      AYS2 = AYS2/DBLE(MAX(NITERS,1))
      DAY2 = SQRT((AYS2-AY2**2)/DBLE(MAX(NITERS,1)))
      Q22AVE = Q22AVE/DBLE(MAX(NITERS,1))
      Q22AV2 = Q22AV2/DBLE(MAX(NITERS,1))
      Q22AV2 = SQRT((Q22AV2-Q22AVE**2)/DBLE(MAX(NITERS,1)))
      WGMAX  = WGMAX2*LOG(YMAX2/YMIN2)
      WGY    = WGMAX*DBLE(ITRY)/DBLE(ITRW)*ALPHA/(2.D0*PI)
      WEIGHT = WGY*SIGMAX*DBLE(NITER)/DBLE(ITRY)
C  output of statistics, histograms
      WRITE(ErrorOut,'(//1X,A,/1X,A,1PE12.3,A,/1X,A)')
     &'=========================================================',
     &' *****   SIMULATED CROSS SECTION: ',WEIGHT,' MB  *****',
     &'========================================================='
      WRITE(ErrorOut,'(//1X,A,/3X,4I12)')
     &  'PHO_GHHIOF:SUMMARY:  NITER,    NITERS,    ITRY,     ITRW',
     &  NITER,NITERS,ITRY,ITRW
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'EFFECTIVE WEIGHT (FLUX,TOTAL)',
     &  WGY,WEIGHT
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Y2,DY2               ',
     &  AY2,DAY2
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Y RANGE PHOTON 2     ',
     &  YY2MIN,YY2MAX
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'AVERAGE Q2,DQ2  PHOTON 2     ',
     &  Q22AVE,Q22AV2
      WRITE(ErrorOut,
     * '(1X,A,1P2E12.4)') 'SAMPLED Q2 RANGE PHOTON 2    ',
     &  Q22MIN,Q22MAX
C
      CALL PHO_EVENT(-2,P1,P2,WEIGHT,IREJ)
      IF(NITER.GT.1) THEN
        CALL PHO_PHIST(-2,WEIGHT)
        CALL PHO_LHIST(-2,WEIGHT)
      ELSE
        WRITE(ErrorOut,
     * '(1X,A,I4)') 'PHO_GHHIOF: no output of histograms',NITER
      ENDIF



      END


CDECK  ID>, PHO_FITPAR
      SUBROUTINE PHO_FITPAR(IOUTP)
C**********************************************************************
C
C     read input parameters according to PDFs
C
C**********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( DEFA=-99999.D0,
     &            DEFB=-100000.D0,
     &           THOUS=1.D3)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  currently activated parton density parametrizations
      CHARACTER*8 PDFNAM
      INTEGER IPARID,IPAVA,ITYPE,IGRP,ISET,IEXT,NPAOLD
      DOUBLE PRECISION PDFLAM,PDFQ2M
      COMMON /POPPDF/ PDFLAM(2),PDFQ2M(2),PDFNAM(2),IPARID(2),
     &                IPAVA(2),ITYPE(2),IGRP(2),ISET(2),IEXT(2),NPAOLD

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  parameters of 2x2 channel model
      DOUBLE PRECISION PHISUP,RMASS,VAR,AMPFAC,ELAFAC,VFAC
      COMMON /PO2CHA/ PHISUP(2),RMASS(2),VAR,AMPFAC(4),ELAFAC(4),VFAC


      DIMENSION   INUM(3),IFPAS(2)
      CHARACTER*8 CNAME8,PDFNA1,PDFNA2
      CHARACTER*10 CNAM10

      PARAMETER ( MAX_TAB = 22 )
      DIMENSION XDPTAB(27,MAX_TAB),IDPTAB(8,MAX_TAB)
      REAL XDPTAB
      INTEGER IDPTAB

C  parameter set for   2212 (GRV94 LO)     2212 (GRV94 LO)
      DATA (IDPTAB(K,  1),K=1,8) /
     &    2212,     5,     6,     0,  2212,     5,     6,     0 /
      DATA (XDPTAB(K,  1),K=1,27) /
     &1.1000E+00,2.5000E-01,6.3870E+00,6.3870E+00,1.1610E+00,1.1610E+00,
     &4.5000E-01,9.0000E-01,1.0263E+01,1.0263E+01,1.1710E+00,1.1710E+00,
     &1.5600E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &1.0000E+00,0.0000E+00,1.0000E+00,0.0000E+00,3.5000E+00,2.0000E+00,
     &6.0000E-01,6.0000E-01,1.1000E+00,1.1000E+00,3.000E+00 /

C  parameter set for   2212 (GRV94 LO)    -2212 (GRV94 LO)
      DATA (IDPTAB(K,  2),K=1,8) /
     &    2212,     5,     6,     0, -2212,     5,     6,     0 /
      DATA (XDPTAB(K,  2),K=1,27) /
     &1.1000E+00,2.5000E-01,6.3870E+00,6.3870E+00,1.1610E+00,1.1610E+00,
     &4.5000E-01,9.0000E-01,1.5174E+01,1.5174E+01,1.5400E+00,1.5400E+00,
     &1.5600E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &1.0000E+00,0.0000E+00,1.0000E+00,0.0000E+00,3.5000E+00,2.0000E+00,
     &6.0000E-01,6.0000E-01,1.1000E+00,1.1000E+00,3.000E+00 /

C  parameter set for     22 (GRV-G LO)     2212 (GRV94 LO)
      DATA (IDPTAB(K,  3),K=1,8) /
     &      22,     5,     3,     0,  2212,     5,     6,     0 /
      DATA (XDPTAB(K,  3),K=1,27) /
     &1.0970E+00,2.5000E-01,2.7450E+00,6.8270E+00,1.2250E+00,1.1360E+00,
     &5.0000E-01,1.0000E+00,4.7210E+00,1.1740E+01,4.6200E-01,4.2800E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &4.3100E-03,8.0000E-05,1.0000E+00,0.0000E+00,3.2000E+00,1.0000E+00,
     &7.0000E-01,6.0000E-01,1.0000E+00,1.1000E+00,3.000E+00 /

C  parameter set for     22 (GRV-G LO)       22 (GRV-G LO)
      DATA (IDPTAB(K,  4),K=1,8) /
     &      22,     5,     3,     0,    22,     5,     3,     0 /
      DATA (XDPTAB(K,  4),K=1,27) /
     &1.0970E+00,2.5000E-01,2.7450E+00,2.7450E+00,1.2250E+00,1.2250E+00,
     &5.0000E-01,1.0000E+00,4.7210E+00,4.7210E+00,4.6200E-01,4.6200E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &4.3100E-03,8.0000E-05,4.3100E-03,8.0000E-05,3.2000E+00,1.0000E+00,
     &7.0000E-01,7.0000E-01,1.0000E+00,1.0000E+00,3.000E+00 /

C  parameter set for     22 (GRS-G LO)     2212 (GRV94 LO)
      DATA (IDPTAB(K,  5),K=1,8) /
     &      22,     5,     4,     4,  2212,     5,     6,     0 /
      DATA (XDPTAB(K,  5),K=1,27) /
     &1.0970E+00,2.5000E-01,2.7450E+00,6.8270E+00,1.2250E+00,1.1360E+00,
     &5.0000E-01,1.0000E+00,4.7210E+00,1.1740E+01,4.6200E-01,4.2800E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &4.3100E-03,8.0000E-05,1.0000E+00,0.0000E+00,3.2000E+00,1.0000E+00,
     &7.0000E-01,6.0000E-01,1.0000E+00,1.1000E+00,3.000E+00 /

C  parameter set for     22 (GRS-G LO)       22 (GRS-G LO)
      DATA (IDPTAB(K,  6),K=1,8) /
     &      22,     5,     4,     4,    22,     5,     4,     4 /
      DATA (XDPTAB(K,  6),K=1,27) /
     &1.0970E+00,2.5000E-01,2.7450E+00,2.7450E+00,1.2250E+00,1.2250E+00,
     &5.0000E-01,1.0000E+00,4.7210E+00,4.7210E+00,4.6200E-01,4.6200E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &4.3100E-03,8.0000E-05,4.3100E-03,8.0000E-05,3.2000E+00,1.0000E+00,
     &7.0000E-01,7.0000E-01,1.0000E+00,1.0000E+00,3.000E+00 /

C  parameter set for     22 (SaS-1D  )       22 (SaS-1D  )
      DATA (IDPTAB(K,  7),K=1,8) /
     &      22,     1,     1,     4,    22,     1,     1,     4 /
      DATA (XDPTAB(K,  7),K=1,27) /
     &1.0970E+00,2.5000E-01,3.1170E+00,3.1170E+00,1.3450E+00,1.3450E+00,
     &3.0200E-01,1.0000E+00,6.6050E+00,6.6050E+00,1.7500E-01,1.7500E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &4.0900E-03,9.0000E-05,4.0900E-03,9.0000E-05,3.2000E+00,1.0000E+00,
     &7.0000E-01,7.0000E-01,1.0000E+00,1.0000E+00,3.000E+00 /

C  parameter set for     22 (SaS-1M  )       22 (SaS-1M  )
      DATA (IDPTAB(K,  8),K=1,8) /
     &      22,     1,     2,     4,    22,     1,     2,     4 /
      DATA (XDPTAB(K,  8),K=1,27) /
     &1.0970E+00,2.5000E-01,2.5540E+00,2.5540E+00,1.0910E+00,1.0910E+00,
     &5.0000E-01,1.0000E+00,4.2580E+00,4.2580E+00,4.9000E-01,4.9000E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &4.5700E-03,1.0000E-04,4.5700E-03,1.0000E-04,3.2000E+00,1.0000E+00,
     &7.0000E-01,7.0000E-01,1.0000E+00,1.0000E+00,3.000E+00 /

C  parameter set for     22 (SaS-2D  )       22 (SaS-2D  )
      DATA (IDPTAB(K,  9),K=1,8) /
     &      22,     1,     3,     4,    22,     1,     3,     4 /
      DATA (XDPTAB(K,  9),K=1,27) /
     &1.0970E+00,2.5000E-01,2.5330E+00,2.5330E+00,1.1340E+00,1.1340E+00,
     &5.0100E-01,1.0000E+00,4.2300E+00,4.2300E+00,4.9300E-01,4.9300E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &4.5900E-03,1.0000E-04,4.5900E-03,1.0000E-04,3.2000E+00,1.0000E+00,
     &7.0000E-01,7.0000E-01,1.0000E+00,1.0000E+00,3.000E+00 /

C  parameter set for     22 (SaS-2M  )       22 (SaS-2M  )
      DATA (IDPTAB(K, 10),K=1,8) /
     &      22,     1,     4,     4,    22,     1,     4,     4 /
      DATA (XDPTAB(K, 10),K=1,27) /
     &1.0970E+00,2.5000E-01,2.8220E+00,2.8220E+00,1.0910E+00,1.0910E+00,
     &4.9100E-01,1.0000E+00,4.6870E+00,4.6870E+00,4.5800E-01,4.5800E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &4.6600E-03,3.0000E-05,4.6600E-03,3.0000E-05,3.2000E+00,1.0000E+00,
     &7.0000E-01,7.0000E-01,1.0000E+00,1.0000E+00,3.000E+00 /

C  parameter set for     22 (LAC     )     2212 (GRV94 LO)
      DATA (IDPTAB(K, 11),K=1,8) /
     &      22,     3,     1,     3,  2212,     5,     6,     0 /
      DATA (XDPTAB(K, 11),K=1,27) /
     &1.0970E+00,2.5000E-01,3.3050E+00,6.8270E+00,9.4500E-01,1.1360E+00,
     &4.5000E-01,1.0000E+00,6.7120E+00,1.1740E+01,2.5800E-01,4.6200E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &3.3400E-03,2.4000E-04,1.0000E+00,0.0000E+00,2.0000E+00,1.0000E+00,
     &7.0000E-01,6.0000E-01,1.0000E+00,1.1000E+00,3.000E+00 /

C  parameter set for     22 (PDFLIB2 )     2212 (GRV94 LO)
      DATA (IDPTAB(K, 12),K=1,8) /
     &      22,     3,     1,     2,  2212,     5,     6,     0 /
      DATA (XDPTAB(K, 12),K=1,27) /
     &1.0970E+00,2.5000E-01,3.3050E+00,6.8270E+00,9.4500E-01,1.1360E+00,
     &4.5000E-01,1.0000E+00,6.7120E+00,1.1740E+01,2.5800E-01,4.6200E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &3.3400E-03,2.4000E-04,1.0000E+00,0.0000E+00,2.0000E+00,1.0000E+00,
     &7.0000E-01,6.0000E-01,1.0000E+00,1.1000E+00,3.000E+00 /

C  parameter set for     22 (LAC     )       22 (LAC     )
      DATA (IDPTAB(K, 13),K=1,8) /
     &      22,     3,     1,     3,    22,     3,     1,     3 /
      DATA (XDPTAB(K, 13),K=1,27) /
     &1.0970E+00,2.5000E-01,3.3050E+00,3.3050E+00,9.4500E-01,9.4500E-01,
     &4.5000E-01,1.0000E+00,6.7120E+00,6.7120E+00,2.5800E-01,2.5800E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &3.3400E-03,2.4000E-04,3.3400E-03,2.4000E-04,2.0000E+00,1.0000E+00,
     &7.0000E-01,7.0000E-01,1.0000E+00,1.0000E+00,3.000E+00 /

C  parameter set for     22 (PDFLIB2 )       22 (PDFLIB2 )
      DATA (IDPTAB(K, 14),K=1,8) /
     &      22,     3,     1,     2,    22,     3,     1,     2 /
      DATA (XDPTAB(K, 14),K=1,27) /
     &1.0970E+00,2.5000E-01,3.3050E+00,3.3050E+00,9.4500E-01,9.4500E-01,
     &4.5000E-01,1.0000E+00,6.7120E+00,6.7120E+00,2.5800E-01,2.5800E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &3.3400E-03,2.4000E-04,3.3400E-03,2.4000E-04,2.0000E+00,1.0000E+00,
     &7.0000E-01,7.0000E-01,1.0000E+00,1.0000E+00,3.000E+00 /

C  parameter set for     22 (LAC     )     2212 (GRV94 LO)
      DATA (IDPTAB(K, 15),K=1,8) /
     &      22,     3,     2,     3,  2212,     5,     6,     0 /
      DATA (XDPTAB(K, 15),K=1,27) /
     &1.0970E+00,2.5000E-01,3.1450E+00,6.8270E+00,1.0490E+00,1.1360E+00,
     &4.5000E-01,1.0000E+00,6.3680E+00,1.1740E+01,1.4700E-01,4.6200E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &3.8700E-03,1.1000E-04,1.0000E+00,0.0000E+00,2.0000E+00,1.0000E+00,
     &7.0000E-01,6.0000E-01,1.0000E+00,1.1000E+00,3.000E+00 /

C  parameter set for     22 (PDFLIB2 )     2212 (GRV94 LO)
      DATA (IDPTAB(K, 16),K=1,8) /
     &      22,     3,     2,     2,  2212,     5,     6,     0 /
      DATA (XDPTAB(K, 16),K=1,27) /
     &1.0970E+00,2.5000E-01,3.1450E+00,6.8270E+00,1.0490E+00,1.1360E+00,
     &4.5000E-01,1.0000E+00,6.3680E+00,1.1740E+01,1.4700E-01,4.6200E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &3.8700E-03,1.1000E-04,1.0000E+00,0.0000E+00,2.0000E+00,1.0000E+00,
     &7.0000E-01,6.0000E-01,1.0000E+00,1.1000E+00,3.000E+00 /

C  parameter set for     22 (LAC     )       22 (LAC     )
      DATA (IDPTAB(K, 17),K=1,8) /
     &      22,     3,     2,     3,    22,     3,     2,     3 /
      DATA (XDPTAB(K, 17),K=1,27) /
     &1.0970E+00,2.5000E-01,3.1450E+00,3.1450E+00,1.0490E+00,1.0490E+00,
     &4.5000E-01,1.0000E+00,6.3680E+00,6.3680E+00,1.4700E-01,1.4700E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &3.8700E-03,1.1000E-04,3.8700E-03,1.0000E-04,2.0000E+00,1.0000E+00,
     &7.0000E-01,7.0000E-01,1.0000E+00,1.0000E+00,3.000E+00 /

C  parameter set for     22 (PDFLIB2 )       22 (PDFLIB2 )
      DATA (IDPTAB(K, 18),K=1,8) /
     &      22,     3,     2,     2,    22,     3,     2,     2 /
      DATA (XDPTAB(K, 18),K=1,27) /
     &1.0970E+00,2.5000E-01,3.1450E+00,3.1450E+00,1.0490E+00,1.0490E+00,
     &4.5000E-01,1.0000E+00,6.3680E+00,6.3680E+00,1.4700E-01,1.4700E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &3.8700E-03,1.1000E-04,3.8700E-03,1.0000E-04,2.0000E+00,1.0000E+00,
     &7.0000E-01,7.0000E-01,1.0000E+00,1.0000E+00,3.000E+00 /

C  parameter set for     22 (LAC     )     2212 (GRV94 LO)
      DATA (IDPTAB(K, 19),K=1,8) /
     &      22,     3,     3,     3,  2212,     5,     6,     0 /
      DATA (XDPTAB(K, 19),K=1,27) /
     &1.0970E+00,2.5000E-01,3.0510E+00,6.8270E+00,1.0500E+00,1.1360E+00,
     &4.5000E-01,1.0000E+00,6.0060E+00,1.1740E+01,2.0500E-01,4.6200E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &4.0200E-03,1.0000E-04,1.0000E+00,0.0000E+00,2.0000E+00,1.0000E+00,
     &7.0000E-01,6.0000E-01,1.0000E+00,1.1000E+00,3.000E+00 /

C  parameter set for     22 (PDFLIB2 )     2212 (GRV94 LO)
      DATA (IDPTAB(K, 20),K=1,8) /
     &      22,     3,     3,     2,  2212,     5,     6,     0 /
      DATA (XDPTAB(K, 20),K=1,27) /
     &1.0970E+00,2.5000E-01,3.0510E+00,6.8270E+00,1.0500E+00,1.1360E+00,
     &4.5000E-01,1.0000E+00,6.0060E+00,1.1740E+01,2.0500E-01,4.6200E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &4.0200E-03,1.0000E-04,1.0000E+00,0.0000E+00,2.0000E+00,1.0000E+00,
     &7.0000E-01,6.0000E-01,1.0000E+00,1.1000E+00,3.000E+00 /

C  parameter set for     22 (LAC     )       22 (LAC     )
      DATA (IDPTAB(K, 21),K=1,8) /
     &      22,     3,     3,     3,    22,     3,     3,     3 /
      DATA (XDPTAB(K, 21),K=1,27) /
     &1.0970E+00,2.5000E-01,3.0510E+00,3.0510E+00,1.0500E+00,1.0500E+00,
     &4.5000E-01,1.0000E+00,6.0060E+00,6.0060E+00,2.0500E-01,2.0500E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &4.0200E-03,1.0000E-04,4.0200E-03,1.0000E-04,2.0000E+00,1.0000E+00,
     &7.0000E-01,7.0000E-01,1.0000E+00,1.0000E+00,3.000E+00 /

C  parameter set for     22 (PDFLIB2 )       22 (PDFLIB2 )
      DATA (IDPTAB(K, 22),K=1,8) /
     &      22,     3,     3,     2,    22,     3,     3,     2 /
      DATA (XDPTAB(K, 22),K=1,27) /
     &1.0970E+00,2.5000E-01,3.0510E+00,3.0510E+00,1.0500E+00,1.0500E+00,
     &4.5000E-01,1.0000E+00,6.0060E+00,6.0060E+00,2.0500E-01,2.0500E-01,
     &1.7000E-01,5.0000E-01,6.1200E-01,3.0000E-01,
     &4.0200E-03,1.0000E-04,4.0200E-03,1.0000E-04,2.0000E+00,1.0000E+00,
     &7.0000E-01,7.0000E-01,1.0000E+00,1.0000E+00,3.000E+00 /

      DATA CNAME8 /'        '/
      DATA CNAM10 /'          '/
      DATA INIT / 0 /
      DATA IFPAS / 0, 0 /

      IF((INIT.EQ.1).AND.
     &   (IFPAP(1).EQ.IFPAS(1)).AND.(IFPAP(2).EQ.IFPAS(2))) GOTO 1300

      INIT=1
      IFPAS(1) = IFPAP(1)
      IFPAS(2) = IFPAP(2)

C  parton distribution functions
      CALL PHO_ACTPDF(IFPAP(1),1)
      CALL PHO_GETPDF(1,PDFNA1,ALAM2,Q2MIN,Q2MAX,XMIN,XMAX)
      CALL PHO_ACTPDF(IFPAP(2),2)
      CALL PHO_GETPDF(2,PDFNA2,ALAM2,Q2MIN,Q2MAX,XMIN,XMAX)
C  initialize alpha_s calculation
      DUMMY = PHO_ALPHAS(0.D0,-4)

      IF(IDEB(54).GE.0) THEN
        WRITE(ErrorOut,
     * '(/1X,A,I7,2X,A,3I7)') 'PHO_FITPAR: looking for PDF',
     &    IFPAP(1),PDFNA1,IGRP(1),ISET(1),IEXT(1)
        WRITE(ErrorOut,
     * '(1X,A,I7,2X,A,3I7)') 'PHO_FITPAR: looking for PDF',
     &    IFPAP(2),PDFNA2,IGRP(2),ISET(2),IEXT(2)
      ENDIF

      IFOUND = 0

C  load parameter set from internal tables
      I1 = 1
      I2 = 2
 110  CONTINUE

      DO I=1,MAX_TAB
        IF((IFPAP(I1).EQ.IDPTAB(1,I))
     &     .AND.(IGRP(I1).EQ.IDPTAB(2,I))
     &     .AND.(ISET(I1).EQ.IDPTAB(3,I))
     &     .AND.(IEXT(I1).EQ.IDPTAB(4,I))) THEN
          IF((IFPAP(I2).EQ.IDPTAB(5,I))
     &       .AND.(IGRP(I2).EQ.IDPTAB(6,I))
     &       .AND.(ISET(I2).EQ.IDPTAB(7,I))
     &       .AND.(IEXT(I2).EQ.IDPTAB(8,I))) THEN
            WRITE(ErrorOut,'(/1X,A)')
     &        'PHO_FITPAR: PARAMETER SET FOUND IN INTERNAL TABLE'
            ALPOM    = XDPTAB(1,I)
            ALPOMP   = XDPTAB(2,I)
            GP(I1)   = XDPTAB(3,I)
            GP(I2)   = XDPTAB(4,I)
            B0POM(I1) = XDPTAB(5,I)
            B0POM(I2) = XDPTAB(6,I)
            ALREG    = XDPTAB(7,I)
            ALREGP   = XDPTAB(8,I)
            GR(I1)   = XDPTAB(9,I)
            GR(I2)   = XDPTAB(10,I)
            B0REG(I1) = XDPTAB(11,I)
            B0REG(I2) = XDPTAB(12,I)
            GPPP     = XDPTAB(13,I)
            B0PPP    = XDPTAB(14,I)
            GPPR     = XDPTAB(15,I)
            B0PPR    = XDPTAB(16,I)
            VDMFAC(2*I1-1) = XDPTAB(17,I)
            VDMFAC(2*I1)   = XDPTAB(18,I)
            VDMFAC(2*I2-1) = XDPTAB(19,I)
            VDMFAC(2*I2)   = XDPTAB(20,I)
            B0HAR    = XDPTAB(21,I)
            AKFAC    = XDPTAB(22,I)
            PHISUP(I1) = XDPTAB(23,I)
            PHISUP(I2) = XDPTAB(24,I)
            RMASS(I1) = XDPTAB(25,I)
            RMASS(I2) = XDPTAB(26,I)
            VAR      = XDPTAB(27,I)
            IFOUND = 1
            GOTO 1200
          ENDIF
        ENDIF
      ENDDO

      IF(I1.EQ.1) THEN
        I1 = 2
        I2 = 1
        GOTO 110
      ELSE
        WRITE(ErrorOut,'(/1X,A)')
     &    'PHO_FITPAR: PARAMETER SET NOT FOUND IN INTERNAL TABLE'
      ENDIF

 1200 CONTINUE

C  get parameters of soft cross sections from fitpar.dat
      IF(IPAMDL(99).GT.IFOUND) THEN

        WRITE(ErrorOut,'(/1X,A)')
     &    'PHO_FITPAR: LOADING PARAMETER SET FROM FILE FITPAR.DAT'
cc        &&&& KK
cc        OPEN(12,FILE='FITPAR.DAT',ERR=1010,STATUS='OLD')
cc
        call cdpmOpen2(12, 'FITPAR.DAT')
cc
 100    CONTINUE
          READ(12,'(A8)',ERR=1020,END=1010) CNAME8
          IF(CNAME8.EQ.'STOP') GOTO 1010
          IF(CNAME8.EQ.'NEXTDATA') THEN
            READ(12,'(I8,2X,A8,3I6)',ERR=1020,END=1010)
     &        IDPA1,CNAME8,INUM
            IF((IDPA1.EQ.IFPAP(1)).AND.(CNAME8.EQ.PDFNA1)
     &         .AND.(INUM(1).EQ.IGRP(1)).AND.(INUM(2).EQ.ISET(1))) THEN
              READ(12,'(I8,2X,A8,3I6)',ERR=1020,END=1010)
     &          IDPA2,CNAME8,INUM
              IF((IDPA2.EQ.IFPAP(2)).AND.(CNAME8.EQ.PDFNA2).AND.
     &           (INUM(1).EQ.IGRP(2)).AND.(INUM(2).EQ.ISET(2))) THEN
                WRITE(ErrorOut,
     * '(/1X,A)') 'PHO_FITPAR: parameter set found'
                READ(12,*) ALPOM,ALPOMP,GP,B0POM
                READ(12,*) ALREG,ALREGP,GR,B0REG
                READ(12,*) GPPP,B0PPP,GPPR,B0PPR
                READ(12,*) VDMFAC(1),VDMFAC(2),VDMFAC(3),VDMFAC(4)
                READ(12,*) B0HAR
                READ(12,*) AKFAC
                READ(12,*) PHISUP
                READ(12,*) RMASS,VAR
                IFOUND = 1
                GOTO 1100
              ENDIF
            ENDIF
          ENDIF
        GOTO 100

 1020 CONTINUE
        WRITE(ErrorOut,
     * '(/A)') ' PHO_FITPAR: cannot read file fitpar.dat'
        WRITE(ErrorOut,
     * '(A,A10,A8)') ' last data card: ',CNAM10,CNAME8
 1010 CONTINUE
        WRITE(ErrorOut,'(/A)')
     &    ' PHO_FITPAR: CANNOT FIND PARAMETER SET IN FILE FITPAR.DAT'

 1100   CONTINUE
        CLOSE(12)

      ENDIF

C  nothing found
      IF(IFOUND.EQ.0) THEN
        WRITE(ErrorOut,
     * '(/A)') ' PHO_FITPAR: could not find parameter set'
        WRITE(ErrorOut,'(3(10X,A,/))')
     &    '(COPY FITPAR.DAT INTO THE WORKING DIRECTORY AND/OR',
     &    ' REQUEST THE MISSING PARAMETER SET VIA E-MAIL FROM',
     &    ' ENG@LEPTON.BARTOL.UDEL.EDU)'
        STOP
      ENDIF


 1300 CONTINUE

C  overwrite parameters with user settings
      IF(PARMDL(301).GT.DEFA) THEN
        ALPOM     = PARMDL(301)
        PARMDL(301) = DEFB
      ENDIF
      IF(PARMDL(302).GT.DEFA) THEN
        ALPOMP    = PARMDL(302)
        PARMDL(302) = DEFB
      ENDIF
      IF(PARMDL(303).GT.DEFA) THEN
        GP(1)     = PARMDL(303)
        PARMDL(303) = DEFB
      ENDIF
      IF(PARMDL(304).GT.DEFA) THEN
        GP(2)     = PARMDL(304)
        PARMDL(304) = DEFB
      ENDIF
      IF(PARMDL(305).GT.DEFA) THEN
        B0POM(1)  = PARMDL(305)
        PARMDL(305) = DEFB
      ENDIF
      IF(PARMDL(306).GT.DEFA) THEN
        B0POM(2)  = PARMDL(306)
        PARMDL(306) = DEFB
      ENDIF
      IF(PARMDL(307).GT.DEFA) THEN
        ALREG     = PARMDL(307)
        PARMDL(307) = DEFB
      ENDIF
      IF(PARMDL(308).GT.DEFA) THEN
        ALREGP    = PARMDL(308)
        PARMDL(308) = DEFB
      ENDIF
      IF(PARMDL(309).GT.DEFA) THEN
        GR(1)     = PARMDL(309)
        PARMDL(309) = DEFB
      ENDIF
      IF(PARMDL(310).GT.DEFA) THEN
        GR(2)      = PARMDL(310)
        PARMDL(310) = DEFB
      ENDIF
      IF(PARMDL(311).GT.DEFA) THEN
        B0REG(1)  = PARMDL(311)
        PARMDL(311) = DEFB
      ENDIF
      IF(PARMDL(312).GT.DEFA) THEN
        B0REG(2)  = PARMDL(312)
        PARMDL(312) = DEFB
      ENDIF
      IF(PARMDL(313).GT.DEFA) THEN
        GPPP      = PARMDL(313)
        PARMDL(313) = DEFB
      ENDIF
      IF(PARMDL(314).GT.DEFA) THEN
        B0PPP     = PARMDL(314)
        PARMDL(314)= DEFB
      ENDIF
      IF(PARMDL(315).GT.DEFA) THEN
        VDMFAC(1) = PARMDL(315)
        PARMDL(315)= DEFB
      ENDIF
      IF(PARMDL(316).GT.DEFA) THEN
        VDMFAC(2) = PARMDL(316)
        PARMDL(316)= DEFB
      ENDIF
      IF(PARMDL(317).GT.DEFA) THEN
        VDMFAC(3) = PARMDL(317)
        PARMDL(317)= DEFB
      ENDIF
      IF(PARMDL(318).GT.DEFA) THEN
        VDMFAC(4) = PARMDL(318)
        PARMDL(318)= DEFB
      ENDIF
      IF(PARMDL(319).GT.DEFA) THEN
        B0HAR     = PARMDL(319)
        PARMDL(319)= DEFB
      ENDIF
      IF(PARMDL(320).GT.DEFA) THEN
        AKFAC     = PARMDL(320)
        PARMDL(320)= DEFB
      ENDIF
      IF(PARMDL(321).GT.DEFA) THEN
        PHISUP(1) = PARMDL(321)
        PARMDL(321)= DEFB
      ENDIF
      IF(PARMDL(322).GT.DEFA) THEN
        PHISUP(2) = PARMDL(322)
        PARMDL(322)= DEFB
      ENDIF
      IF(PARMDL(323).GT.DEFA) THEN
        RMASS(1)  = PARMDL(323)
        PARMDL(323)= DEFB
      ENDIF
      IF(PARMDL(324).GT.DEFA) THEN
        RMASS(2)  = PARMDL(324)
        PARMDL(324)= DEFB
      ENDIF
      IF(PARMDL(325).GT.DEFA) THEN
        VAR       = PARMDL(325)
        PARMDL(325)= DEFB
      ENDIF
      IF(PARMDL(327).GT.DEFA) THEN
        GPPR      = PARMDL(327)
        PARMDL(327)= DEFB
      ENDIF
      IF(PARMDL(328).GT.DEFA) THEN
        B0PPR     = PARMDL(328)
        PARMDL(328)= DEFB
      ENDIF

      VDMQ2F(1) = VDMFAC(1)
      VDMQ2F(2) = VDMFAC(2)
      VDMQ2F(3) = VDMFAC(3)
      VDMQ2F(4) = VDMFAC(4)

C  output of parameter set
      IF((IDEB(54).GE.5).OR.(IOUTP.GT.0)) THEN
        WRITE(ErrorOut,
     * '(/,A,/,A)') ' PHO_FITPAR: parameter set',
     &                       ' -------------------------'
        WRITE(ErrorOut,'(2(A,F7.3),2(A,2F9.3))')
     &  '  ALPOM:',ALPOM,' ALPOMP:',ALPOMP,' GP:',GP,' B0POM:',
     &  B0POM
        WRITE(ErrorOut,'(2(A,F7.3),2(A,2F9.3))')
     &  '  ALREG:',ALREG,' ALREGP:',ALREGP,' GR:',GR,' B0REG:',
     &  B0REG
        WRITE(ErrorOut,'(4(A,F7.3))')
     &  '  GPPP :',GPPP,' B0PPP:',B0PPP,' GPPR :',GPPR,' B0PPR:',B0PPR
        WRITE(ErrorOut,'(A,4F10.5)') ' VDMFAC:',VDMFAC
        WRITE(ErrorOut,'(A,4F10.5)') ' VDMQ2F:',VDMQ2F
        WRITE(ErrorOut,'(A,F8.3)')  '  B0HAR:',B0HAR
        WRITE(ErrorOut,'(A,F8.3)')  '  AKFAC:',AKFAC
        WRITE(ErrorOut,'(A,2F8.3)') ' PHISUP:',PHISUP
        WRITE(ErrorOut,'(A,3F8.3)') '  RMASS:',RMASS,VAR
      ENDIF

      CALL PHO_HARINI(1,IFPAP(1),IFPAP(2),PVIRT(1),PVIRT(2),6,IOUTP-1)

      END




CDECK  ID>, PHO_BORNCS
      SUBROUTINE PHO_BORNCS(IP,IFHARD,XM1,XM2,XM3,XM4)
C*********************************************************************
C
C     calculation of Born graph cross sections and slopes
C
C     input: IP               particle combination
C            IFHARD           -1 calculate hard Born graph cross section
C                             0  take hard Born graph cross section
C                                from interpolation table if available
C                             1  assume that correct hard cross
C                                sections are already stored in /POSBRN/
C            XM1,XM2,XM3,XM4  masses of external lines
C                   /GLOCMS/  energy and PT cut-off
C                   /POPREG/  soft and hard parameters
C                   /POSBRN/  input cross sections
C                   /POZBRN/  scaled input values
C                    IFHARD   0  calculate hard input cross sections
C                             1  assume hard input cross sections exist
C
C     output: ZPOM            scaled pomeron cross section
C             ZIGR            scaled reggeon cross section
C             ZIGHR           scaled hard resolved cross section
C             ZIGHD           scaled hard direct cross section
C             ZIGT1           scaled triple-Pomeron cross section
C             ZIGT2           scaled triple-Pomeron cross section
C             ZIGL            scaled loop-Pomeron cross section
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER(ITWO=2,
     &        ITHREE=3,
     &         IFOUR=4,
     &         IFIVE=5,
     &          FIVE=5.D0,
     &         THOUS=1.D3,
     &           EPS=0.01D0,
     &          DEPS=1.D-30)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  names of hard scattering processes
      INTEGER MAX_PRO_1
      PARAMETER ( MAX_PRO_1 = 16 )
      CHARACTER*18 PROC
      COMMON /POHPRO/ PROC(0:MAX_PRO_1)

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)

C  interpolation tables for hard cross section and MC selection weights
      INTEGER MAX_TAB_E,MAX_TAB_Q2,MAX_PRO_TAB
      PARAMETER ( MAX_TAB_E = 20, MAX_TAB_Q2 = 10, MAX_PRO_TAB = 16 )
      INTEGER IH_Q2A_UP,IH_Q2B_UP,IH_ECM_UP
      DOUBLE PRECISION HFAC_TAB,HWGX_TAB,HSIG_TAB,HDPT_TAB,
     &  HQ2A_TAB,HQ2B_TAB,HECM_TAB
      COMMON /POHTAB/
     &  HFAC_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HWGX_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HSIG_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HDPT_TAB(-1:MAX_PRO_TAB,MAX_TAB_E,MAX_TAB_Q2,MAX_TAB_Q2,0:4),
     &  HQ2A_TAB(1:MAX_TAB_Q2,0:4),HQ2B_TAB(1:MAX_TAB_Q2,0:4),
     &  HECM_TAB(1:MAX_TAB_E,0:4),
     &  IH_Q2A_UP(0:4),IH_Q2B_UP(0:4),IH_ECM_UP(0:4)

C  Born graph cross sections and slopes
      INTEGER MAX_PRO_3
      PARAMETER ( MAX_PRO_3 = 16 )
      COMPLEX*16      SIGP,SIGR,SIGHD,SIGHR,SIGT1,SIGT2,SIGL,SIGDP,
     &                SIGD1,SIGD2,DSIGH
      COMMON /POSBRN/ SIGP,SIGR,SIGHD,SIGHR,SIGT1(2),SIGT2(2),SIGL,
     &                SIGDP(4),SIGD1(2),SIGD2(2),DSIGH(0:MAX_PRO_3)

C  scaled cross sections and slopes
      COMPLEX*16      ZIGP,ZIGR,ZIGHD,ZIGHR,ZIGT1,ZIGT2,ZIGL,ZIGDP,
     &                ZIGD1,ZIGD2,
     &                BPOM,BREG,BHAR,BHAD,BTR1,BTR2,BLOO,BDP,BD1,BD2
      COMMON /POZBRN/ ZIGP,ZIGR,ZIGHD,ZIGHR,ZIGT1(2),ZIGT2(2),ZIGL,
     &                ZIGDP(4),ZIGD1(2),ZIGD2(2),
     &                BPOM,BREG,BHAR,BHAD,BTR1(2),BTR2(2),BLOO,BDP(4),
     &                BD1(2),BD2(2)

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  parameters of 2x2 channel model
      DOUBLE PRECISION PHISUP,RMASS,VAR,AMPFAC,ELAFAC,VFAC
      COMMON /PO2CHA/ PHISUP(2),RMASS(2),VAR,AMPFAC(4),ELAFAC(4),VFAC

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

C  data needed for soft-pt calculation
      DOUBLE PRECISION SIGS,DSIGHP,SIGH,FS,FH,BETAS,AAS,PTCON
      COMMON /POINT3/ SIGS,DSIGHP,SIGH,FS,FH,BETAS(3),AAS,PTCON


      COMPLEX*16      CZERO,BP4,BR4,BHR4,BHD4,BT14,BT24,BD4,SP,SR,SS,
     &                BPOM1,BPOM2,BREG1,BREG2,B0HARD
      DIMENSION       SCB1(4),SCB2(4),SCG1(4),SCG2(4)
      DIMENSION       BT14(2),BT24(2),BD4(4)
      DIMENSION       DSPT(0:MAX_PRO_2)

      DATA  XMPOM / 0.766D0 /
      DATA  CZERO /(0.D0,0.D0)/

      CDABS(SS) = ABS(SS)
      DCMPLX(X,Y) = CMPLX(X,Y)

C  debug output
      IF(IDEB(48).GE.10) WRITE(ErrorOut,'(/1X,A,I3,4E12.3,I3)')
     &  'PHO_BORNCS: IP,M1..M4,IFHARD',IP,XM1,XM2,XM3,XM4,IFHARD
C  scales
      CALL PHO_SCALES(XM1,XM2,XM3,XM4,SCALE1,SCALE2,SCALB1,SCALB2)
C
C  calculate hard input cross sections (output in mb)
      IF(IFHARD.NE.1) THEN
        IF((IFHARD.EQ.0).AND.(HECM_TAB(1,IP).GT.1.D0)) THEN
C  double-log interpolation
          CALL PHO_HARINT(IP,ECMP,0.D0,0.D0,0,MAX_PRO_2,3,4,1)
          DO 60 M=0,MAX_PRO_2
            DSIGH(M) = HSIG(M)
            DSPT(M)  = HDPT(M)
 60       CONTINUE
        ELSE
C  new calculation
          CALL PHO_HARINT(IP,ECMP,0.D0,0.D0,0,-2,0,0,1)
          CALL PHO_HARXTO(ECMP,PTCUT(IP),PTCUT(IP),DSIGH,DSPT)
        ENDIF
C
C  save values to calculate soft pt distribution
        IF(IP.EQ.1) THEN
          VDMQ2F(1) = VDMFAC(1)
          VDMQ2F(2) = VDMFAC(2)
          VDMQ2F(3) = VDMFAC(3)
          VDMQ2F(4) = VDMFAC(4)
        ELSE IF(IP.EQ.2) THEN
          VDMQ2F(1) = VDMFAC(1)
          VDMQ2F(2) = VDMFAC(2)
          VDMQ2F(3) = 1.D0
          VDMQ2F(4) = 0.D0
        ELSE IF(IP.EQ.3) THEN
          VDMQ2F(1) = VDMFAC(3)
          VDMQ2F(2) = VDMFAC(4)
          VDMQ2F(3) = 1.D0
          VDMQ2F(4) = 0.D0
        ELSE
          VDMQ2F(1) = 1.D0
          VDMQ2F(2) = 0.D0
          VDMQ2F(3) = 1.D0
          VDMQ2F(4) = 0.D0
        ENDIF
C  VDM factors
        AMPFAC(1) = SQRT(VDMQ2F(1)*VDMQ2F(3))
        AMPFAC(2) = SQRT(VDMQ2F(2)*VDMQ2F(3))
        AMPFAC(3) = SQRT(VDMQ2F(1)*VDMQ2F(4))
        AMPFAC(4) = SQRT(VDMQ2F(2)*VDMQ2F(4))
        ELAFAC(1) = VDMQ2F(1)*VDMQ2F(3)+VDMQ2F(2)*VDMQ2F(3)
     &             +VDMQ2F(1)*VDMQ2F(4)+VDMQ2F(2)*VDMQ2F(4)
        ELAFAC(2) = 2.D0*(AMPFAC(1)*AMPFAC(2)+AMPFAC(3)*AMPFAC(4))
        ELAFAC(3) = 2.D0*(AMPFAC(1)*AMPFAC(3)+AMPFAC(2)*AMPFAC(4))
        ELAFAC(4) = 4.D0*AMPFAC(1)*AMPFAC(4)
        VFAC = ELAFAC(1)+PHISUP(1)*PHISUP(2)*ELAFAC(4)
     &        +PHISUP(1)*ELAFAC(2)+PHISUP(2)*ELAFAC(3)
        DSIGHP = DSPT(9)/VFAC
        SIGH   = DSIGH(9)/VFAC
C  extract real part
        IF(IPAMDL(1).EQ.0) THEN
          DO 50 I=0,MAX_PRO_2
            DSIGH(I)=DCMPLX(DREAL(DSIGH(I)),0.D0)
 50       CONTINUE
        ENDIF
C  write out results
        IF(IDEB(48).GE.15) THEN
          WRITE(ErrorOut,'(/1X,A,1P,2E11.3)')
     &       'PHO_BORNCS: QCD-PM CROSS SECTIONS (MB)',ECMP,PTCUT(IP)
          DO 200 I=0,MAX_PRO_2
            WRITE(ErrorOut,'(10X,A,2E14.4)') PROC(I),DSIGH(I)
 200      CONTINUE
        ENDIF
      ENDIF


C  DTUNUC interface: subtract anomalous part
      IF((IP.EQ.1).AND.(IPAMDL(13).GT.0))
     &  DSIGH(9) = DSIGH(9)-DCMPLX(DT_SANO(ECMP),0.D0)


      SCALE = CDABS(DSIGH(15))
      IF(SCALE.LT.DEPS) THEN
        SIGHD=CZERO
      ELSE
        SIGHD=DSIGH(15)
      ENDIF
      SCALE = CDABS(DSIGH(9))
      IF(SCALE.LT.DEPS) THEN
        SIGHR=CZERO
      ELSE
        SIGHR=DSIGH(9)*SCALE1*SCALE2/VFAC
      ENDIF

C  calculate soft input cross sections (output in mb)
      SS=DCMPLX(ECMP**2-PMASSP(1)**2-PMASSP(2)**2+0.01D0,0.D0)
      IF(IPAMDL(1).EQ.1) THEN
C  pomeron signature
        SP=SS*DCMPLX(0.D0,-1.D0)
C  reggeon signature
        SR=SS*DCMPLX(0.D0,1.D0)
      ELSE
        SP=SS
        SR=SS
      ENDIF
C  coupling constants (mb**1/2)
C  particle dependent slopes (GeV**-2)
      IF(IP.EQ.1) THEN
        GP1 = GP(1)
        GP2 = GP(2)
        GR1 = GR(1)
        GR2 = GR(2)
        B0POM1 = B0POM(1)
        B0POM2 = B0POM(2)
        B0REG1 = B0REG(1)
        B0REG2 = B0REG(2)
        B0HARD = B0HAR
        RMASS1 = RMASS(1)
        RMASS2 = RMASS(2)
      ELSE IF(IP.EQ.2) THEN
        GP1 = GP(1)
        GP2 = PARMDL(77)
        GR1 = GR(1)
        GR2 = PARMDL(77)*GPPR/GPPP
        B0POM1 = B0POM(1)
        B0POM2 = B0PPP
        B0REG1 = B0REG(1)
        B0REG2 = B0PPR
        B0HARD = B0POM1+B0POM2
        RMASS1 = RMASS(1)
        RMASS2 = XMPOM
      ELSE IF(IP.EQ.3) THEN
        GP1 = GP(2)
        GP2 = PARMDL(77)
        GR1 = GR(2)
        GR2 = PARMDL(77)*GPPR/GPPP
        B0POM1 = B0POM(2)
        B0POM2 = B0PPP
        B0REG1 = B0REG(2)
        B0REG2 = B0PPR
        B0HARD = B0POM1+B0POM2
        RMASS1 = RMASS(2)
        RMASS2 = XMPOM
      ELSE IF(IP.EQ.4) THEN
        GP1 = PARMDL(77)
        GP2 = GP1
        GR1 = PARMDL(77)*GPPR/GPPP
        GR2 = GR1
        B0POM1 = B0PPP
        B0POM2 = B0PPP
        B0REG1 = B0PPR
        B0REG2 = B0PPR
        B0HARD = B0POM1+B0POM2
        RMASS1 = XMPOM
        RMASS2 = XMPOM
      ELSE
        WRITE(ErrorOut,
     * '(/1X,A,I7)') 'PHO_BORNCS:ERROR:invalid IP',IP
        CALL PHO_ABORT
      ENDIF
      GP1 = GP1*SCALE1
      GP2 = GP2*SCALE2
      GR1 = GR1*SCALE1
      GR2 = GR2*SCALE2
C  input slope parameters (GeV**-2)
      BPOM1 = B0POM1*SCALB1
      BPOM2 = B0POM2*SCALB2
      BREG1 = B0REG1*SCALB1
      BREG2 = B0REG2*SCALB2
C  effective slopes
      XMR2 = (2.D0*MIN(XM1,XM3)*MIN(XM2,XM4))**2
      SCALE = SS*XMR2/((XM1**2+XM3**2)*(XM2**2+XM4**2))+2.D0
      BPOM = BPOM1 + BPOM2 + ALPOMP*LOG(SCALE)
      BREG = BREG1 + BREG2 + ALREGP*LOG(SCALE)
      IF(IPAMDL(9).EQ.0) THEN
        BHAR = B0HARD
        BHAD = B0HARD
      ELSE IF(IPAMDL(9).EQ.1) THEN
        BHAR = B0HARD*(SCALB1+SCALB2)/2.D0
        BHAD = BHAR
      ELSE IF(IPAMDL(9).EQ.2) THEN
        BHAR = BPOM1+BPOM2
        BHAD = BHAR
      ELSE
        BHAR = BPOM
        BHAD = BPOM
      ENDIF
C  input cross section pomeron
      SIGP=GP1*GP2*EXP((ALPOM-1.D0)*LOG(SP))
      SIGR=GR1*GR2*EXP((ALREG-1.D0)*LOG(SR))
C  save value to calculate soft pt distribution
      SIGS = (SIGR+SIGP)/(SCALE1*SCALE2)

C  higher order graphs
      VIRT1 = PVIRTP(1)
      VIRT2 = PVIRTP(2)
C  bare/renormalized intercept for enhanced graphs
      IF(IPAMDL(8).EQ.0) THEN
        DELTAP = ALPOM-1.D0
      ELSE
        DELTAP = PARMDL(48)-1.D0
      ENDIF
      SD = ECMP**2
      BP1 = 2.D0*BPOM1
      BP2 = 2.D0*BPOM2
C  input cross section high-mass double diffraction
      CALL PHO_LOOREG(SD,GP1,BP1,GP2,BP2,
     &            DELTAP,ALPOMP,GPPP,B0PPP,VIRT1,VIRT2,SIGTR,BTR)
      SIGL = DCMPLX(SIGTR,0.D0)
      BLOO = DCMPLX(BTR,0.D0)
C
C  input cross section high mass diffraction particle 1
C  first possibility
      CALL PHO_SCALES(XM1,XM2,XM3,PMASSP(2),
     &  SCG1(1),SCG2(1),SCB1(1),SCB2(1))
      CALL PHO_SCALES(XM1,PMASSP(2),XM3,XM4,
     &  SCG1(2),SCG2(2),SCB1(2),SCB2(2))
      SCALB1 = (SCB1(1)+SCB1(2))/2.D0
      SCALB2 = (SCB2(1)+SCB2(2))/2.D0
      BP1 = 2.D0*BPOM1*SCALB1
      BP2 = 2.D0*BPOM2*SCALB2
C  input cross section high mass diffraction
      CALL PHO_TRIREG(SD,GP1,BP1,GP2,BP2,
     &               DELTAP,ALPOMP,GPPP,B0PPP,VIRT1,SIGTR,BTR)
      SIGT1(1) = SCG1(1)*SCG2(1)*SCG2(2)*DCMPLX(SIGTR,0.D0)
      BTR1(1)  = DCMPLX(BTR,0.D0)
C  second possibility:  high-low mass double diffraction
      CALL PHO_SCALES(XM1,XM2,XM3,RMASS2,
     &  SCG1(1),SCG2(1),SCB1(1),SCB2(1))
      CALL PHO_SCALES(XM1,RMASS2,XM3,XM4,
     &  SCG1(2),SCG2(2),SCB1(2),SCB2(2))
      SCALB1 = (SCB1(1)+SCB1(2))/2.D0
      SCALB2 = (SCB2(1)+SCB2(2))/2.D0
      BP1 = 2.D0*BPOM1*SCALB1
      BP2 = 2.D0*BPOM2*SCALB2
C  input cross section high mass diffraction
      CALL PHO_TRIREG(SD,GP1,BP1,GP2,BP2,
     &               DELTAP,ALPOMP,GPPP,B0PPP,VIRT1,SIGTR,BTR)
      SIGT1(2) = SCG1(1)*SCG2(1)*SCG2(2)*DCMPLX(SIGTR,0.D0)
      BTR1(2)  = DCMPLX(BTR,0.D0)
C
C  input cross section high mass diffraction particle 2
C  first possibility
      CALL PHO_SCALES(XM1,XM2,PMASSP(1),XM4,
     &  SCG1(1),SCG2(1),SCB1(1),SCB2(1))
      CALL PHO_SCALES(PMASSP(1),XM2,XM3,XM4,
     &  SCG1(2),SCG2(2),SCB1(2),SCB2(2))
      SCALB1 = (SCB1(1)+SCB1(2))/2.D0
      SCALB2 = (SCB2(1)+SCB2(2))/2.D0
      BP1 = 2.D0*BPOM1*SCALB1
      BP2 = 2.D0*BPOM2*SCALB2
C  input cross section high mass diffraction
      CALL PHO_TRIREG(SD,GP2,BP2,GP1,BP1,
     &               DELTAP,ALPOMP,GPPP,B0PPP,VIRT2,SIGTR,BTR)
      SIGT2(1) = SCG1(1)*SCG1(2)*SCG2(1)*DCMPLX(SIGTR,0.D0)
      BTR2(1)  = DCMPLX(BTR,0.D0)
C  second possibility:  high-low mass double diffraction
      CALL PHO_SCALES(XM1,XM2,RMASS1,XM4,
     &  SCG1(1),SCG2(1),SCB1(1),SCB2(1))
      CALL PHO_SCALES(RMASS1,XM2,XM3,XM4,
     &  SCG1(2),SCG2(2),SCB1(2),SCB2(2))
      SCALB1 = (SCB1(1)+SCB1(2))/2.D0
      SCALB2 = (SCB2(1)+SCB2(2))/2.D0
      BP1 = 2.D0*BPOM1*SCALB1
      BP2 = 2.D0*BPOM2*SCALB2
C  input cross section high mass diffraction
      CALL PHO_TRIREG(SD,GP2,BP2,GP1,BP1,
     &               DELTAP,ALPOMP,GPPP,B0PPP,VIRT2,SIGTR,BTR)
      SIGT2(2) = SCG1(1)*SCG1(2)*SCG2(1)*DCMPLX(SIGTR,0.D0)
      BTR2(2)  = DCMPLX(BTR,0.D0)
C
C  input cross section for loop-pomeron
C  first possibility
      CALL PHO_SCALES(XM1,XM2,PMASSP(1),XM4,
     &  SCG1(1),SCG2(1),SCB1(1),SCB2(1))
      CALL PHO_SCALES(PMASSP(1),XM2,XM3,XM4,
     &  SCG1(2),SCG2(2),SCB1(2),SCB2(2))
      CALL PHO_SCALES(XM1,XM2,XM3,PMASSP(2),
     &  SCG1(3),SCG2(3),SCB1(3),SCB2(3))
      CALL PHO_SCALES(XM1,PMASSP(2),XM3,XM4,
     &  SCG1(4),SCG2(4),SCB1(4),SCB2(4))
      SCALB1 = (SCB1(1)+SCB1(2)+SCB1(3)+SCB1(4))/4.D0
      SCALB2 = (SCB2(1)+SCB2(2)+SCB2(3)+SCB2(4))/4.D0
      BP1 = BPOM1*SCALB1
      BP2 = BPOM2*SCALB2
      CALL PHO_TRXPOM(SD,GP2,BP2,GP1,BP1,DELTAP,ALPOMP,GPPP,B0PPP,
     &  SIGTX,BTX)
      SIGDP(1) = SCG1(1)*SCG1(2)*SCG2(3)*SCG2(4)*DCMPLX(SIGTX,0.D0)
      BDP(1)   = DCMPLX(BTX,0.D0)
C  second possibility
      CALL PHO_SCALES(XM1,XM2,RMASS1,XM4,
     &  SCG1(1),SCG2(1),SCB1(1),SCB2(1))
      CALL PHO_SCALES(RMASS1,XM2,XM3,XM4,
     &  SCG1(2),SCG2(2),SCB1(2),SCB2(2))
      CALL PHO_SCALES(XM1,XM2,XM3,PMASSP(2),
     &  SCG1(3),SCG2(3),SCB1(3),SCB2(3))
      CALL PHO_SCALES(XM1,PMASSP(2),XM3,XM4,
     &  SCG1(4),SCG2(4),SCB1(4),SCB2(4))
      SCALB1 = (SCB1(1)+SCB1(2)+SCB1(3)+SCB1(4))/4.D0
      SCALB2 = (SCB2(1)+SCB2(2)+SCB2(3)+SCB2(4))/4.D0
      BP1 = BPOM1*SCALB1
      BP2 = BPOM2*SCALB2
      CALL PHO_TRXPOM(SD,GP2,BP2,GP1,BP1,DELTAP,ALPOMP,GPPP,B0PPP,
     &  SIGTX,BTX)
      SIGDP(2) = SCG1(1)*SCG1(2)*SCG2(3)*SCG2(4)*DCMPLX(SIGTX,0.D0)
      BDP(2)   = DCMPLX(BTX,0.D0)
C  third possibility
      CALL PHO_SCALES(XM1,XM2,PMASSP(1),XM4,
     &  SCG1(1),SCG2(1),SCB1(1),SCB2(1))
      CALL PHO_SCALES(PMASSP(1),XM2,XM3,XM4,
     &  SCG1(2),SCG2(2),SCB1(2),SCB2(2))
      CALL PHO_SCALES(XM1,XM2,XM3,RMASS2,
     &  SCG1(3),SCG2(3),SCB1(3),SCB2(3))
      CALL PHO_SCALES(XM1,RMASS2,XM3,XM4,
     &  SCG1(4),SCG2(4),SCB1(4),SCB2(4))
      SCALB1 = (SCB1(1)+SCB1(2)+SCB1(3)+SCB1(4))/4.D0
      SCALB2 = (SCB2(1)+SCB2(2)+SCB2(3)+SCB2(4))/4.D0
      BP1 = BPOM1*SCALB1
      BP2 = BPOM2*SCALB2
      CALL PHO_TRXPOM(SD,GP2,BP2,GP1,BP1,DELTAP,ALPOMP,GPPP,B0PPP,
     &  SIGTX,BTX)
      SIGDP(3) = SCG1(1)*SCG1(2)*SCG2(3)*SCG2(4)*DCMPLX(SIGTX,0.D0)
      BDP(3)   = DCMPLX(BTX,0.D0)
C  fourth possibility
      CALL PHO_SCALES(XM1,XM2,RMASS1,XM4,
     &  SCG1(1),SCG2(1),SCB1(1),SCB2(1))
      CALL PHO_SCALES(RMASS1,XM2,XM3,XM4,
     &  SCG1(2),SCG2(2),SCB1(2),SCB2(2))
      CALL PHO_SCALES(XM1,XM2,XM3,RMASS2,
     &  SCG1(3),SCG2(3),SCB1(3),SCB2(3))
      CALL PHO_SCALES(XM1,RMASS2,XM3,XM4,
     &  SCG1(4),SCG2(4),SCB1(4),SCB2(4))
      SCALB1 = (SCB1(1)+SCB1(2)+SCB1(3)+SCB1(4))/4.D0
      SCALB2 = (SCB2(1)+SCB2(2)+SCB2(3)+SCB2(4))/4.D0
      BP1 = BPOM1*SCALB1
      BP2 = BPOM2*SCALB2
      CALL PHO_TRXPOM(SD,GP2,BP2,GP1,BP1,DELTAP,ALPOMP,GPPP,B0PPP,
     &  SIGTX,BTX)
      SIGDP(4) = SCG1(1)*SCG1(2)*SCG2(3)*SCG2(4)*DCMPLX(SIGTX,0.D0)
      BDP(4)   = DCMPLX(BTX,0.D0)
C
C  input cross section for YY-iterated triple-pomeron
C     .....
C
C  write out input cross sections
      IF(IDEB(48).GE.5) THEN
        WRITE(ErrorOut,'(2(/1X,A))')
     &    'BORN GRAPH INPUT CROSS SECTIONS AND SLOPES',
     &    '------------------------------------------'
        WRITE(ErrorOut,
     * '(1X,A,3E12.3)') 'energy                  ',ECMP,PVIRTP
        WRITE(ErrorOut,
     * '(1X,A,4E12.3)') 'external masses 1,2,3,4 ',
     &       XM1,XM2,XM3,XM4
        WRITE(ErrorOut,
     * '(A)') ' input cross sections (millibarn):'
        WRITE(ErrorOut,'(A,2E12.3)') '           SIGR     ',SIGR
        WRITE(ErrorOut,'(A,2E12.3)') ' (soft)    SIGP     ',SIGP
        WRITE(ErrorOut,
     * '(A,2E12.3)') ' (hard)    SIGHR    ',SIGHR
        WRITE(ErrorOut,
     * '(A,2E12.3)') '           SIGHD    ',SIGHD
        WRITE(ErrorOut,
     * '(A,4E12.3)') '           SIGT1    ',SIGT1
        WRITE(ErrorOut,
     * '(A,4E12.3)') '           SIGT2    ',SIGT2
        WRITE(ErrorOut,'(A,2E12.3)') '           SIGL     ',SIGL
        WRITE(ErrorOut,
     * '(A,4E12.3)') '         SIGDP(1-2) ',SIGDP(1),SIGDP(2)
        WRITE(ErrorOut,
     * '(A,4E12.3)') '         SIGDP(3-4) ',SIGDP(3),SIGDP(4)
        WRITE(ErrorOut,'(A)') ' input slopes (GeV**-2)'
        WRITE(ErrorOut,'(A,2E12.3)') '           BREG     ',BREG
        WRITE(ErrorOut,
     * '(A,2E12.3)') '            BREG1   ',BREG1
        WRITE(ErrorOut,
     * '(A,2E12.3)') '            BREG2   ',BREG2
        WRITE(ErrorOut,'(A,2E12.3)') '           BPOM     ',BPOM
        WRITE(ErrorOut,
     * '(A,2E12.3)') '            BPOM1   ',BPOM1
        WRITE(ErrorOut,
     * '(A,2E12.3)') '            BPOM2   ',BPOM2
        WRITE(ErrorOut,'(A,2E12.3)') '           BHAR     ',BHAR
        WRITE(ErrorOut,'(A,2E12.3)') '           BHAD     ',BHAD
        WRITE(ErrorOut,
     * '(A,E12.3)')  '           B0PPP    ',B0PPP
        WRITE(ErrorOut,'(A,4E12.3)') '           BTR1     ',BTR1
        WRITE(ErrorOut,'(A,4E12.3)') '           BTR2     ',BTR2
        WRITE(ErrorOut,'(A,2E12.3)') '           BLOO     ',BLOO
        WRITE(ErrorOut,
     * '(A,4E12.3)') '           BDP(1-2) ',BDP(1),BDP(2)
        WRITE(ErrorOut,
     * '(A,4E12.3)') '           BDP(3-4) ',BDP(3),BDP(4)
      ENDIF
C
      BPOM  = BPOM*GEV2MB
      BREG  = BREG*GEV2MB
      BHAR  = BHAR*GEV2MB
      BHAD  = BHAD*GEV2MB
      BTR1(1)  = BTR1(1)*GEV2MB
      BTR1(2)  = BTR1(2)*GEV2MB
      BTR2(1)  = BTR2(1)*GEV2MB
      BTR2(2)  = BTR2(2)*GEV2MB
      BLOO  = BLOO*GEV2MB
C
      BP4 =BPOM*4.D0
      BR4 =BREG*4.D0
      BHR4=BHAR*4.D0
      BHD4=BHAD*4.D0
      BT14(1)=BTR1(1)*4.D0
      BT14(2)=BTR1(2)*4.D0
      BT24(1)=BTR2(1)*4.D0
      BT24(2)=BTR2(2)*4.D0
      BL4 =BLOO*4.D0
C
      ZIGP     = SIGP/(PI2*BP4)
      ZIGR     = SIGR/(PI2*BR4)
      ZIGHR    = SIGHR/(PI2*BHR4)
      ZIGHD    = SIGHD/(PI2*BHD4)
      ZIGT1(1) = SIGT1(1)/(PI2*BT14(1))
      ZIGT1(2) = SIGT1(2)/(PI2*BT14(2))
      ZIGT2(1) = SIGT2(1)/(PI2*BT24(1))
      ZIGT2(2) = SIGT2(2)/(PI2*BT24(2))
      ZIGL = SIGL/(PI2*BL4)
      DO 20 I=1,4
        BDP(I) = BDP(I)*GEV2MB
        BD4(I) = BDP(I)*4.D0
        ZIGDP(I) = SIGDP(I)/(PI2*BD4(I))
 20   CONTINUE
C
      IF(IDEB(48).GE.10) THEN
        WRITE(ErrorOut,'(A)') ' normalized input values:'
        WRITE(ErrorOut,'(A,2E12.3)') '           ZIGR ',ZIGR
        WRITE(ErrorOut,'(A,2E12.3)') '           BREG ',BREG
        WRITE(ErrorOut,'(A,2E12.3)') '           ZIGP ',ZIGP
        WRITE(ErrorOut,'(A,2E12.3)') '           BPOM ',BPOM
        WRITE(ErrorOut,'(A,2E12.3)') '          ZIGHR ',ZIGHR
        WRITE(ErrorOut,'(A,2E12.3)') '           BHAR ',BHAR
        WRITE(ErrorOut,'(A,2E12.3)') '          ZIGHD ',ZIGHD
        WRITE(ErrorOut,'(A,2E12.3)') '           BHAD ',BHAD
        WRITE(ErrorOut,'(A,4E12.3)') '          ZIGT1 ',ZIGT1
        WRITE(ErrorOut,'(A,4E12.3)') '          ZIGT2 ',ZIGT2
        WRITE(ErrorOut,'(A,2E12.3)') '           ZIGL ',ZIGL
        WRITE(ErrorOut,
     * '(A,4E12.3)') '     ZIGDP(1-2) ',ZIGDP(1),ZIGDP(2)
        WRITE(ErrorOut,
     * '(A,4E12.3)') '     ZIGDP(3-4) ',ZIGDP(3),ZIGDP(4)
      ENDIF
      END


CDECK  ID>, PHO_SCALES
      SUBROUTINE PHO_SCALES(XM1,XM2,XM3,XM4,SCG1,SCG2,SCB1,SCB2)
C**********************************************************************
C
C     calculation of scale factors
C              (mass dependent couplings and slopes)
C
C     input:   XM1..XM4     external masses
C
C     output:  SCG1,SCG2    scales of coupling constants
C              SCB1,SCB2    scales of coupling slope parameter
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( EPS  = 1.D-3 )

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  parameters of 2x2 channel model
      DOUBLE PRECISION PHISUP,RMASS,VAR,AMPFAC,ELAFAC,VFAC
      COMMON /PO2CHA/ PHISUP(2),RMASS(2),VAR,AMPFAC(4),ELAFAC(4),VFAC

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)


C  scale factors for couplings
      ECMMIN = 2.D0
*     ECMTP = 6.D0
      ECMTP = 1.D0
      IF(ABS(XM1-XM3).GT.EPS) THEN
        IF(ECMP.LT.ECMTP) THEN
          SCG1 = PHISUP(1)*LOG(ECMP**2/ECMMIN)/LOG(ECMTP**2/ECMMIN)
        ELSE
          SCG1 = PHISUP(1)
        ENDIF
      ELSE
        SCG1 = 1.D0
      ENDIF
      IF(ABS(XM2-XM4).GT.EPS) THEN
        IF(ECMP.LT.ECMTP) THEN
          SCG2 = PHISUP(2)*LOG(ECMP**2/ECMMIN)/LOG(ECMTP**2/ECMMIN)
        ELSE
          SCG2 = PHISUP(2)
        ENDIF
      ELSE
        SCG2 = 1.D0
      ENDIF
C
C  scale factors for slope parameters
      IF((ISWMDL(1).LT.2).OR.(IPAMDL(10).EQ.1)) THEN
        SCB1 = 1.D0
        SCB2 = 1.D0
      ELSE IF(ISWMDL(1).EQ.2) THEN
C  rational
        SCB1 = 2.D0*PMASSP(1)**2/(XM1**2+XM3**2)
        SCB2 = 2.D0*PMASSP(2)**2/(XM2**2+XM4**2)
      ELSE IF(ISWMDL(1).GE.3) THEN
C  symmetric gaussian
        SCB1 = VAR*(XM1-XM3)**2
        IF(SCB1.LT.25.D0) THEN
          SCB1 = EXP(-SCB1)
        ELSE
          SCB1 = 0.D0
        ENDIF
        SCB2 = VAR*(XM2-XM4)**2
        IF(SCB2.LT.25.D0) THEN
          SCB2 = EXP(-SCB2)
        ELSE
          SCB2 = 0.D0
        ENDIF
      ELSE
        WRITE(ErrorOut,
     * '(/,1X,A,I4)') 'PHO_SCALES:ERROR:invalid ISWMDL(1)',
     &    ISWMDL(1)
        CALL PHO_ABORT
      ENDIF
C  debug output
      IF(IDEB(65).GE.10) THEN
        WRITE(ErrorOut,'(1X,A,4E11.3)') 'PHO_SCALES: M1..M4 ',
     &       XM1,XM2,XM3,XM4
        WRITE(ErrorOut,'(5X,A,4E11.3)') 'SCB1,SCB2,SCG1,SCG2',
     &       SCB1,SCB2,SCG1,SCG2
      ENDIF
      END


CDECK  ID>, PHO_EIKON
      SUBROUTINE PHO_EIKON(IP,IFHARD,B)
C*********************************************************************
C
C     calculation of unitarized amplitudes
C
C     input: IP               particle combination
C            IFHARD           -1  ignore previously calculated Born
C                                 cross sections
C                             0   calculate hard Born cross sections or
C                                 take them from interpolation table
C                                 (if available)
C                             1   take hard cross sections from /POSBRN/
C            B                impact parameter (mb**(1/2))
C                   /POSBRN/  input cross sections
C                   /GLOCMS/  cm energy
C                   /POPREG/  soft and hard parameters
C
C     output: /POINT4/
C             AMPEL           purely elastic amplitude
C             AMPVM           quasi-elastically vectormeson prod.
C             AMLMSD(2)       amplitudes of low mass sing. diffr.
C             AMHMSD(2)       amplitudes of high mass sing. diffr.
C             AMLMDD          amplitude of low mass double diffr.
C             AMHMDD          amplitude of high mass double diffr.
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER(ITWO=2,
     &        ITHREE=3,
     &         IFOUR=4,
     &         IFIVE=5,
     &          ISIX=6,
     &          FIVE=5.D0,
     &         THOUS=1.D3,
     &        EXPMAX=70.D0,
     &          DEPS=1.D-20)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  complex Born graph amplitudes used for unitarization
      COMPLEX*16      AMPEL,AMPVM,AMPSOF,AMPHAR,AMLMSD,AMHMSD,AMLMDD,
     &                AMHMDD,AMPDP
      COMMON /POINT4/ AMPEL,AMPVM(4,4),AMPSOF,AMPHAR,AMLMSD(2),
     &                AMHMSD(2),AMLMDD,AMHMDD,AMPDP(4)

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL

C  Born graph cross sections and slopes
      INTEGER MAX_PRO_3
      PARAMETER ( MAX_PRO_3 = 16 )
      COMPLEX*16      SIGP,SIGR,SIGHD,SIGHR,SIGT1,SIGT2,SIGL,SIGDP,
     &                SIGD1,SIGD2,DSIGH
      COMMON /POSBRN/ SIGP,SIGR,SIGHD,SIGHR,SIGT1(2),SIGT2(2),SIGL,
     &                SIGDP(4),SIGD1(2),SIGD2(2),DSIGH(0:MAX_PRO_3)

C  scaled cross sections and slopes
      COMPLEX*16      ZIGP,ZIGR,ZIGHD,ZIGHR,ZIGT1,ZIGT2,ZIGL,ZIGDP,
     &                ZIGD1,ZIGD2,
     &                BPOM,BREG,BHAR,BHAD,BTR1,BTR2,BLOO,BDP,BD1,BD2
      COMMON /POZBRN/ ZIGP,ZIGR,ZIGHD,ZIGHR,ZIGT1(2),ZIGT2(2),ZIGL,
     &                ZIGDP(4),ZIGD1(2),ZIGD2(2),
     &                BPOM,BREG,BHAR,BHAD,BTR1(2),BTR2(2),BLOO,BDP(4),
     &                BD1(2),BD2(2)

C  Born graph cross sections after applying diffraction model
      DOUBLE PRECISION SBOPOM,SBOREG,SBOHAR,SBOHAD,SBOTR1,SBOTR2,
     &                 SBOLPO,SBODPO
      COMMON /POINT1/ SBOPOM(0:4),SBOREG(0:4),SBOHAR(0:4),SBOHAD(0:4),
     &                SBOTR1(0:4,2),SBOTR2(0:4,2),SBOLPO(0:4),
     &                SBODPO(0:4,4)

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  data of c.m. system of Pomeron / Reggeon exchange
      INTEGER NPOSP,IDPDG1,IDBAM1,IDPDG2,IDBAM2
      DOUBLE PRECISION ECMP,PCMP,PMASSP,PVIRTP,GAMBEP,
     &                 SIDP,CODP,SIFP,COFP
      COMMON /POPCMS/ ECMP,PCMP,PMASSP(2),PVIRTP(2),GAMBEP(4),
     &                SIDP,CODP,SIFP,COFP,NPOSP(2),
     &                IDPDG1,IDBAM1,IDPDG2,IDBAM2

C  Reggeon phenomenology parameters
      DOUBLE PRECISION ALPOM,ALPOMP,GP,B0POM,ALREG,ALREGP,GR,B0REG,
     &                 GPPP,GPPR,B0PPP,B0PPR,VDMFAC,VDMQ2F,B0HAR,AKFAC
      COMMON /POPREG/ ALPOM,ALPOMP,GP(2),B0POM(2),
     &                ALREG,ALREGP,GR(2),B0REG(2),
     &                GPPP,GPPR,B0PPP,B0PPR,
     &                VDMFAC(4),VDMQ2F(4),B0HAR,AKFAC

C  parameters of 2x2 channel model
      DOUBLE PRECISION PHISUP,RMASS,VAR,AMPFAC,ELAFAC,VFAC
      COMMON /PO2CHA/ PHISUP(2),RMASS(2),VAR,AMPFAC(4),ELAFAC(4),VFAC

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  unitarized amplitudes for different diffraction channels
      DOUBLE PRECISION ZXP,BXP,ZXR,BXR,ZXH,BXH,ZXD,BXD,
     &                 ZXT1A,BXT1A,ZXT1B,BXT1B,ZXT2A,BXT2A,ZXT2B,BXT2B,
     &                 ZXDPE,BXDPE,ZXDPA,BXDPA,ZXDPB,BXDPB,ZXDPD,BXDPD,
     &                 ZXL,BXL
      COMMON /POINT5/ ZXP(4,4),BXP(4,4),ZXR(4,4),BXR(4,4),
     &                ZXH(4,4),BXH(4,4),ZXD(4,4),BXD(4,4),
     &                ZXT1A(4,4),BXT1A(4,4),ZXT1B(4,4),BXT1B(4,4),
     &                ZXT2A(4,4),BXT2A(4,4),ZXT2B(4,4),BXT2B(4,4),
     &                ZXDPE(4,4),BXDPE(4,4),ZXDPA(4,4),BXDPA(4,4),
     &                ZXDPB(4,4),BXDPB(4,4),ZXDPD(4,4),BXDPD(4,4),
     &                ZXL(4,4),BXL(4,4)


      COMPLEX*16      CZERO,CONE,B24,AUXP,AUXR,AUXH,AUXD,AUXT1,AUXT2,
     &                AUXL,AMPR,AMPO,AMPP,AMPQ

      DIMENSION PVOLD(2)

      DATA  ELAST / 0.D0 /
      DATA  IPOLD / -1 /
      DATA  PVOLD / -1.D0, -1.D0 /
      DATA  XMPOM / 0.766D0 /
      DATA  XMVDM / 0.766D0 /

      DCMPLX(X,Y) = CMPLX(X,Y)

C  calculation of scaled cross sections and slopes

C  test for redundant calculation
      IF((ECM.NE.ELAST).OR.(IFHARD.EQ.-1).OR.(PVIRT(1).NE.PVOLD(1))
     &   .OR.(PVIRT(2).NE.PVOLD(2)).OR.(IP.NE.IPOLD)) THEN
C  effective particle masses, VDM assumption
        XMASS1 = PMASS(1)
        XMASS2 = PMASS(2)
        RMASS1 = RMASS(1)
        RMASS2 = RMASS(2)
        IF(IFPAP(1).EQ.22) THEN
          XMASS1 = XMVDM
        ELSE IF(IFPAP(1).EQ.990) THEN
          XMASS1 = XMPOM
        ENDIF
        IF(IFPAP(2).EQ.22) THEN
          XMASS2 = XMVDM
        ELSE IF(IFPAP(2).EQ.990) THEN
          XMASS2 = XMPOM
        ENDIF
C  different particle combinations
        IF(IP.EQ.3) THEN
          XMASS1 = XMASS2
          RMASS1 = RMASS2
        ELSE IF(IP.EQ.4) THEN
          XMASS1 = XMPOM
          RMASS1 = XMASS1
        ENDIF
        IF(IP.GT.1) THEN
          XMASS2 = XMPOM
          RMASS2 = XMASS2
        ENDIF
C  update pomeron CM system
        PMASSP(1) = XMASS1
        PMASSP(2) = XMASS2
        ECMP = ECM

        CZERO    = DCMPLX(0.D0,0.D0)
        CONE     = DCMPLX(1.D0,0.D0)
        ELAST    = ECM
        PVOLD(1) = PVIRT(1)
        PVOLD(2) = PVIRT(2)
        IPOLD    = IP

C  purely elastic scattering
        CALL PHO_BORNCS(IP,IFHARD,XMASS1,XMASS2,XMASS1,XMASS2)
          ZXP(1,1) = ZIGP
          BXP(1,1) = BPOM
          ZXR(1,1) = ZIGR
          BXR(1,1) = BREG
          ZXH(1,1) = ZIGHR
          BXH(1,1) = BHAR
          ZXD(1,1) = ZIGHD
          BXD(1,1) = BHAD
          ZXT1A(1,1) = ZIGT1(1)
          BXT1A(1,1) = BTR1(1)
          ZXT1B(1,1) = ZIGT1(2)
          BXT1B(1,1) = BTR1(2)
          ZXT2A(1,1) = ZIGT2(1)
          BXT2A(1,1) = BTR2(1)
          ZXT2B(1,1) = ZIGT2(2)
          BXT2B(1,1) = BTR2(2)
          ZXL(1,1) = ZIGL
          BXL(1,1) = BLOO
          ZXDPE(1,1) = ZIGDP(1)
          BXDPE(1,1) = BDP(1)
          ZXDPA(1,1) = ZIGDP(2)
          BXDPA(1,1) = BDP(2)
          ZXDPB(1,1) = ZIGDP(3)
          BXDPB(1,1) = BDP(3)
          ZXDPD(1,1) = ZIGDP(4)
          BXDPD(1,1) = BDP(4)
          SBOPOM(1) = SIGP
          SBOREG(1) = SIGR
          SBOHAR(1) = SIGHR
          SBOHAD(1) = SIGHD
          SBOTR1(1,1) = SIGT1(1)
          SBOTR1(1,2) = SIGT1(2)
          SBOTR2(1,1) = SIGT2(1)
          SBOTR2(1,2) = SIGT2(2)
          SBOLPO(1) = SIGL
          SBODPO(1,1) = SIGDP(1)
          SBODPO(1,2) = SIGDP(2)
          SBODPO(1,3) = SIGDP(3)
          SBODPO(1,4) = SIGDP(4)

C  low mass single diffractive scattering 1
        CALL PHO_BORNCS(IP,1,XMASS1,XMASS2,RMASS1,XMASS2)
          ZXP(1,2) = ZIGP
          BXP(1,2) = BPOM
          ZXR(1,2) = ZIGR
          BXR(1,2) = BREG
          ZXH(1,2) = ZIGHR
          BXH(1,2) = BHAR
          ZXD(1,2) = ZIGHD
          BXD(1,2) = BHAD
          ZXT1A(1,2) = ZIGT1(1)
          BXT1A(1,2) = BTR1(1)
          ZXT1B(1,2) = ZIGT1(2)
          BXT1B(1,2) = BTR1(2)
          ZXT2A(1,2) = ZIGT2(1)
          BXT2A(1,2) = BTR2(1)
          ZXT2B(1,2) = ZIGT2(2)
          BXT2B(1,2) = BTR2(2)
          ZXL(1,2) = ZIGL
          BXL(1,2) = BLOO
          ZXDPE(1,2) = ZIGDP(1)
          BXDPE(1,2) = BDP(1)
          ZXDPA(1,2) = ZIGDP(2)
          BXDPA(1,2) = BDP(2)
          ZXDPB(1,2) = ZIGDP(3)
          BXDPB(1,2) = BDP(3)
          ZXDPD(1,2) = ZIGDP(4)
          BXDPD(1,2) = BDP(4)
          SBOPOM(2) = SIGP
          SBOREG(2) = SIGR
          SBOHAR(2) = SIGHR
          SBOHAD(2) = 0.D0
          SBOTR1(2,1) = SIGT1(1)
          SBOTR1(2,2) = SIGT1(2)
          SBOTR2(2,1) = SIGT2(1)
          SBOTR2(2,2) = SIGT2(2)
          SBOLPO(2) = SIGL
          SBODPO(2,1) = SIGDP(1)
          SBODPO(2,2) = SIGDP(2)
          SBODPO(2,3) = SIGDP(3)
          SBODPO(2,4) = SIGDP(4)

C  low mass single diffractive scattering 2
        CALL PHO_BORNCS(IP,1,XMASS1,XMASS2,XMASS1,RMASS2)
          ZXP(1,3) = ZIGP
          BXP(1,3) = BPOM
          ZXR(1,3) = ZIGR
          BXR(1,3) = BREG
          ZXH(1,3) = ZIGHR
          BXH(1,3) = BHAR
          ZXD(1,3) = ZIGHD
          BXD(1,3) = BHAD
          ZXT1A(1,3) = ZIGT1(1)
          BXT1A(1,3) = BTR1(1)
          ZXT1B(1,3) = ZIGT1(2)
          BXT1B(1,3) = BTR1(2)
          ZXT2A(1,3) = ZIGT2(1)
          BXT2A(1,3) = BTR2(1)
          ZXT2B(1,3) = ZIGT2(2)
          BXT2B(1,3) = BTR2(2)
          ZXL(1,3) = ZIGL
          BXL(1,3) = BLOO
          ZXDPE(1,3) = ZIGDP(1)
          BXDPE(1,3) = BDP(1)
          ZXDPA(1,3) = ZIGDP(2)
          BXDPA(1,3) = BDP(2)
          ZXDPB(1,3) = ZIGDP(3)
          BXDPB(1,3) = BDP(3)
          ZXDPD(1,3) = ZIGDP(4)
          BXDPD(1,3) = BDP(4)
          SBOPOM(3) = SIGP
          SBOREG(3) = SIGR
          SBOHAR(3) = SIGHR
          SBOHAD(3) = 0.D0
          SBOTR1(3,1) = SIGT1(1)
          SBOTR1(3,2) = SIGT1(2)
          SBOTR2(3,1) = SIGT2(1)
          SBOTR2(3,2) = SIGT2(2)
          SBOLPO(3) = SIGL
          SBODPO(3,1) = SIGDP(1)
          SBODPO(3,2) = SIGDP(2)
          SBODPO(3,3) = SIGDP(3)
          SBODPO(3,4) = SIGDP(4)

C  low mass double diffractive scattering
        CALL PHO_BORNCS(IP,1,XMASS1,XMASS2,RMASS1,RMASS2)
          ZXP(1,4) = ZIGP
          BXP(1,4) = BPOM
          ZXR(1,4) = ZIGR
          BXR(1,4) = BREG
          ZXH(1,4) = ZIGHR
          BXH(1,4) = BHAR
          ZXD(1,4) = ZIGHD
          BXD(1,4) = BHAD
          ZXT1A(1,4) = ZIGT1(1)
          BXT1A(1,4) = BTR1(1)
          ZXT1B(1,4) = ZIGT1(2)
          BXT1B(1,4) = BTR1(2)
          ZXT2A(1,4) = ZIGT2(1)
          BXT2A(1,4) = BTR2(1)
          ZXT2B(1,4) = ZIGT2(2)
          BXT2B(1,4) = BTR2(2)
          ZXL(1,4) = ZIGL
          BXL(1,4) = BLOO
          ZXDPE(1,4) = ZIGDP(1)
          BXDPE(1,4) = BDP(1)
          ZXDPA(1,4) = ZIGDP(2)
          BXDPA(1,4) = BDP(2)
          ZXDPB(1,4) = ZIGDP(3)
          BXDPB(1,4) = BDP(3)
          ZXDPD(1,4) = ZIGDP(4)
          BXDPD(1,4) = BDP(4)
          SBOPOM(4) = SIGP
          SBOREG(4) = SIGR
          SBOHAR(4) = SIGHR
          SBOHAD(4) = 0.D0
          SBOTR1(4,1) = SIGT1(1)
          SBOTR1(4,2) = SIGT1(2)
          SBOTR2(4,1) = SIGT2(1)
          SBOTR2(4,2) = SIGT2(2)
          SBOLPO(4) = SIGL
          SBODPO(4,1) = SIGDP(1)
          SBODPO(4,2) = SIGDP(2)
          SBODPO(4,3) = SIGDP(3)
          SBODPO(4,4) = SIGDP(4)

C  calculate Born graph cross sections
        SBOPOM(0) = 0.D0
        SBOREG(0) = 0.D0
        SBOHAR(0) = 0.D0
        SBOHAD(0) = 0.D0
        SBOTR1(0,1) = 0.D0
        SBOTR1(0,2) = 0.D0
        SBOTR2(0,1) = 0.D0
        SBOTR2(0,2) = 0.D0
        SBOLPO(0) = 0.D0
        SBODPO(0,1) = 0.D0
        SBODPO(0,2) = 0.D0
        SBODPO(0,3) = 0.D0
        SBODPO(0,4) = 0.D0
        DO 150 I=1,4
          SBOPOM(0) = SBOPOM(0) + ELAFAC(I)*SBOPOM(I)
          SBOREG(0) = SBOREG(0) + ELAFAC(I)*SBOREG(I)
          SBOHAR(0) = SBOHAR(0) + ELAFAC(I)*SBOHAR(I)
          SBOHAD(0) = SBOHAD(0) + ELAFAC(I)*SBOHAD(I)
          SBOTR1(0,1) = SBOTR1(0,1) + ELAFAC(I)*SBOTR1(I,1)
          SBOTR1(0,2) = SBOTR1(0,2) + ELAFAC(I)*SBOTR1(I,2)
          SBOTR2(0,1) = SBOTR2(0,1) + ELAFAC(I)*SBOTR2(I,1)
          SBOTR2(0,2) = SBOTR2(0,2) + ELAFAC(I)*SBOTR2(I,2)
          SBOLPO(0) = SBOLPO(0) + ELAFAC(I)*SBOLPO(I)
          SBODPO(0,1) = SBODPO(0,1) + ELAFAC(I)*SBODPO(I,1)
          SBODPO(0,2) = SBODPO(0,2) + ELAFAC(I)*SBODPO(I,2)
          SBODPO(0,3) = SBODPO(0,3) + ELAFAC(I)*SBODPO(I,3)
          SBODPO(0,4) = SBODPO(0,4) + ELAFAC(I)*SBODPO(I,4)
 150    CONTINUE

        SIGPOM = SBOPOM(0)
        SIGREG = SBOREG(0)
        SIGTR1(1) = SBOTR1(0,1)
        SIGTR1(2) = SBOTR1(0,2)
        SIGTR2(1) = SBOTR2(0,1)
        SIGTR2(2) = SBOTR2(0,2)
        SIGLOO = SBOLPO(0)
        SIGDPO(1) = SBODPO(0,1)
        SIGDPO(2) = SBODPO(0,2)
        SIGDPO(3) = SBODPO(0,3)
        SIGDPO(4) = SBODPO(0,4)
        SIGHAR = SBOHAR(0)
        SIGDIR = SBOHAD(0)
      ENDIF

      B24=DCMPLX(B**2,0.D0)/4.D0

      AMPEL     = CZERO
      AMPR      = CZERO
      AMPO      = CZERO
      AMPP      = CZERO
      AMPQ      = CZERO
      AMLMSD(1) = CZERO
      AMLMSD(2) = CZERO
      AMHMSD(1) = CZERO
      AMHMSD(2) = CZERO
      AMLMDD    = CZERO
      AMHMDD    = CZERO

C  different models

      IF(ISWMDL(1).LT.3) THEN
C  pomeron
        AUXP  = ZXP(1,1)*EXP(-B24/BXP(1,1))
C  reggeon
        AUXR  = ZXR(1,1)*EXP(-B24/BXR(1,1))
C  hard resolved processes
        AUXH  = ZXH(1,1)*EXP(-B24/BXH(1,1))
C  hard direct processes
        AUXD  = ZXD(1,1)*EXP(-B24/BXD(1,1))
C  triple-Pomeron: baryon high mass diffraction
        AUXT1 = ZXT1A(1,1)*EXP(-B24/BXT1A(1,1))
     &        + ZXT1B(1,1)*EXP(-B24/BXT1B(1,1))
C  triple-Pomeron: photon/meson high mass diffraction
        AUXT2 = ZXT2A(1,1)*EXP(-B24/BXT2A(1,1))
     &        + ZXT2B(1,1)*EXP(-B24/BXT2B(1,1))
C  loop-Pomeron
        AUXL  = ZXL(1,1)*EXP(-B24/BXL(1,1))
      ENDIF


      IF(ISWMDL(1).EQ.0) THEN
        AMPEL = 0.5D0*((VDMQ2F(1)+VDMQ2F(2)+VDMQ2F(3)+VDMQ2F(4))
     &                 *(CONE-EXP(-AUXR-AUXP-AUXH+AUXT1+AUXT2+AUXL))
     &        +(CONE-(VDMQ2F(1)-VDMQ2F(2)-VDMQ2F(3)-VDMQ2F(4)))*AUXD
     &               )
        AMPR = 0.5D0*SQRT(VDMQ2F(1))*(CONE-EXP(-AUXR-AUXP-AUXH
     &                                      +AUXT1+AUXT2+AUXL))
        AMPO = 0.5D0*SQRT(VDMQ2F(2))*(CONE-EXP(-AUXR-AUXP-AUXH
     &                                      +AUXT1+AUXT2+AUXL))
        AMPP = 0.5D0*SQRT(VDMQ2F(3))*(CONE-EXP(-AUXR-AUXP-AUXH
     &                                      +AUXT1+AUXT2+AUXL))
        AMPQ = 0.5D0*SQRT(VDMQ2F(4))*(CONE-EXP(-AUXR-AUXP-AUXH
     &                                      +AUXT1+AUXT2+AUXL))


      ELSE IF(ISWMDL(1).EQ.1) THEN
        AMPR = 0.5D0*SQRT(VDMQ2F(1))*
     &         ( CONE-EXP(-AUXR-AUXP-AUXH*VDMQ2F(1)) )
        AMPO = 0.5D0*SQRT(VDMQ2F(2))*
     &         ( CONE-EXP(-3.D0*AUXR-AUXP-AUXH*VDMQ2F(2)) )
        AMPP = 0.5D0*SQRT(VDMQ2F(3))*
     &         ( CONE-EXP(-AUXP-AUXH*VDMQ2F(3)) )
        AMPQ = 0.5D0*SQRT(VDMQ2F(4))*
     &         ( CONE-EXP(-AUXR-AUXP-AUXH*VDMQ2F(4)) )
        AMPEL = SQRT(VDMQ2F(1))*AMPR
     &         + SQRT(VDMQ2F(2))*AMPO
     &         + SQRT(VDMQ2F(3))*AMPP
     &         + SQRT(VDMQ2F(4))*AMPQ
     &         + AUXD/2.D0

C  simple analytic two channel model (version A)
      ELSE IF(ISWMDL(1).EQ.3) THEN
        CALL PHO_CHAN2A(B)

      ELSE
        WRITE(ErrorOut,'(1X,A,I2)')
     &       'EIKON: ERROR: UNSUPPORTED MODEL ISWMDL(1) ',ISWMDL(1)
        STOP
      ENDIF

      END



CDECK  ID>, PHO_DSIGDT
      SUBROUTINE PHO_DSIGDT(EE,XTA,NFILL)
C*********************************************************************
C
C     calculation of unitarized amplitude
C                    and differential cross section
C
C     input:   EE       cm energy (GeV)
C              XTA(1,*) t values (GeV**2)
C              NFILL    entries in t table
C
C     output:  XTA(2,*)  DSIG/DT  g p --> g h/V (mub/GeV**2)
C              XTA(3,*)  DSIG/DT  g p --> rho0 h/V
C              XTA(4,*)  DSIG/DT  g p --> omega0 h/V
C              XTA(5,*)  DSIG/DT  g p --> phi h/V
C              XTA(6,*)  DSIG/DT  g p --> pi+ pi- h/V (continuum)
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER(ITWO=2,
     &        ITHREE=3,
     &         THOUS=1.D3,
     &          DEPS=1.D-20)

      DIMENSION XTA(6,NFILL)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  integration precision for hard cross sections (obsolete)
      INTEGER NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO
      COMMON /POGAUP/ NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  complex Born graph amplitudes used for unitarization
      COMPLEX*16      AMPEL,AMPVM,AMPSOF,AMPHAR,AMLMSD,AMHMSD,AMLMDD,
     &                AMHMDD,AMPDP
      COMMON /POINT4/ AMPEL,AMPVM(4,4),AMPSOF,AMPHAR,AMLMSD(2),
     &                AMHMSD(2),AMLMDD,AMHMDD,AMPDP(4)


      COMPLEX*16   XT,AMP,CZERO
      DIMENSION    AMP(5),XPNT(96),WGHT(96),XT(5,100)
      CHARACTER*12 FNA

      CDABS(AMPEL) = ABS(AMPEL)
      DCMPLX(X,Y) = CMPLX(X,Y)

      CZERO=DCMPLX(0.D0,0.D0)

      ETMP = ECM
      ECM  = EE

      IF(NFILL.GT.100) THEN
        WRITE(ErrorOut,'(1X,A,I4)')
     &    'PHO_DSIGDT:ERROR: TOO MANY ENTRIES IN TABLE',NFILL
        STOP
      ENDIF
C
      DO 100 K=1,NFILL
        DO 150 L=1,5
          XT(L,K)=CZERO
 150    CONTINUE
 100  CONTINUE
C
C  impact parameter integration
C     BMAX=12.D0*SQRT(MAX(BPOM,BREG))
      BMAX=10.D0
      CALL PHO_GAUSET(0.D0,BMAX,NGAUSO,XPNT,WGHT)
      IAMP = 5
      IF((IFPAP(1).EQ.22).AND.(IFPAP(2).NE.22)) THEN
        I1 = 1
        I2 = 0
      ELSE IF((IFPAP(1).NE.22).AND.(IFPAP(2).EQ.22)) THEN
        I1 = 0
        I2 = 1
      ELSE IF((IFPAP(1).EQ.22).AND.(IFPAP(2).EQ.22)) THEN
        I1 = 1
        I2 = 1
      ELSE
        I1 = 0
        I2 = 0
        IAMP = 1
      ENDIF
      J1 = I1*2
      K1 = I1*3
      L1 = I1*4
      J2 = I2*2
      K2 = I2*3
      L2 = I2*4
C
      DO 200 I=1,NGAUSO
        WG=WGHT(I)*XPNT(I)
C  calculate amplitudes
        IF(I.EQ.1) THEN
          CALL PHO_EIKON(1,-1,XPNT(I))
        ELSE
          CALL PHO_EIKON(1,1,XPNT(I))
        ENDIF
        AMP(1) = AMPEL
        AMP(2) = AMPVM(I1,I2)
        AMP(3) = AMPVM(J1,J2)
        AMP(4) = AMPVM(K1,K2)
        AMP(5) = AMPVM(L1,L2)
C
        DO 400 J=1,NFILL
          XX=XPNT(I)*SQRT(XTA(1,J)/GEV2MB)
          FAC = PHO_BESSJ0(XX)*WG
          DO 500 K=1,IAMP
            XT(1,J)=XT(1,J)+AMP(K)*FAC
 500      CONTINUE
 400    CONTINUE
 200  CONTINUE
C
C  change units to mb/GeV**2
      FAC = 4.D0*PI/GEV2MB
      FNA = '(MB/GEV**2) '
      IF(I1+I2.EQ.1) THEN
        FAC = FAC*THOUS
        FNA = '(MUB/GEV**2)'
      ELSE IF(I1+I2.EQ.2) THEN
        FAC = FAC*THOUS*THOUS
        FNA = '(NB/GEV**2) '
      ENDIF
      IF(IDEB(56).GE.5) THEN
        WRITE(ErrorOut,
     * '(1X,A,A12,/1X,A)') 'table:  -T (GeV**2)   DSIG/DT ',
     &    FNA,'------------------------------------------'
      ENDIF
      DO 600 J=1,NFILL
        DO 700 K=1,IAMP
          XTA(K+1,J)=CDABS(XT(K,J))**2*FAC
 700    CONTINUE
        IF(IDEB(56).GE.5) THEN
          WRITE(ErrorOut,'(5X,6E12.3)') (XTA(I,J),I=1,IAMP+1)
        ENDIF
 600  CONTINUE

      ECM = ETMP
      END


CDECK  ID>, PHO_XSECT
      SUBROUTINE PHO_XSECT(IP,IFHARD,EE)
C*********************************************************************
C
C     calculation of physical cross sections
C
C     input:   IP      particle combination
C              IFHARD  -1 reset Born graph cross section tables
C                      0  calculate hard cross sections or take them
C                         from interpolation table (if available)
C                      1  assume that hard cross sections are already
C                         calculated and stored in /POSBRN/
C              EE      cms energy (GeV)
C
C     output:  /POSBRN/  input cross sections
C              /POZBRN/  scaled input cross values
C              /POCSEC/  physical cross sections and slopes
C
C              slopes in GeV**-2, cross sections in mb
C
C*********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER(ONEM=-1.D0,
     &         THOUS=1.D3,
     &          DEPS=1.D-20)

C  some constants
      DOUBLE PRECISION PI,PI2,PI4,GEV2MB,Q_CH,Q_CH2,Q_CH4
      COMMON /POCONS/ PI,PI2,PI4,GEV2MB,
     &  Q_CH(-6:6),Q_CH2(-6:6),Q_CH4(-6:6)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  integration precision for hard cross sections (obsolete)
      INTEGER NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO
      COMMON /POGAUP/ NGAUP1,NGAUP2,NGAUET,NGAUIN,NGAUSO

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  Born graph cross sections and slopes
      INTEGER MAX_PRO_3
      PARAMETER ( MAX_PRO_3 = 16 )
      COMPLEX*16      SIGP,SIGR,SIGHD,SIGHR,SIGT1,SIGT2,SIGL,SIGDP,
     &                SIGD1,SIGD2,DSIGH
      COMMON /POSBRN/ SIGP,SIGR,SIGHD,SIGHR,SIGT1(2),SIGT2(2),SIGL,
     &                SIGDP(4),SIGD1(2),SIGD2(2),DSIGH(0:MAX_PRO_3)

C  cross sections
      INTEGER IPFIL,IFAFIL,IFBFIL
      DOUBLE PRECISION SIGTOT,SIGELA,SIGVM,SIGINE,SIGNDF,SIGDIR,
     &                 SIGLSD,SIGHSD,SIGLDD,SIGHDD,SIGCDF,
     &                 SIGPOM,SIGREG,SIGHAR,SIGTR1,SIGTR2,SIGLOO,
     &                 SIGDPO,SIG1SO,SIG1HA,SLOEL,SLOVM,SIGCOR,
     &                 FSUP,FSUD,FSUH,ECMFIL,P2AFIL,P2BFIL
      COMMON /POCSEC/ SIGTOT,SIGELA,SIGVM(0:4,0:4),SIGINE,SIGNDF,SIGDIR,
     &                SIGLSD(2),SIGHSD(2),SIGLDD,SIGHDD,SIGCDF(0:4),
     &                SIGPOM,SIGREG,SIGHAR,SIGTR1(2),SIGTR2(2),SIGLOO,
     &                SIGDPO(4),SIG1SO,SIG1HA,SLOEL,SLOVM(4,4),SIGCOR,
     &                FSUP(2),FSUD(2),FSUH(2),ECMFIL,P2AFIL,P2BFIL,
     &                IPFIL,IFAFIL,IFBFIL

C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)


      CHARACTER*15    PHO_PNAME

C  complex Born graph amplitudes used for unitarization
      COMPLEX*16      AMPEL,AMPVM,AMPSOF,AMPHAR,AMLMSD,AMHMSD,AMLMDD,
     &                AMHMDD,AMPDP
      COMMON /POINT4/ AMPEL,AMPVM(4,4),AMPSOF,AMPHAR,AMLMSD(2),
     &                AMHMSD(2),AMLMDD,AMHMDD,AMPDP(4)


      DIMENSION XPNT(96),WGHT(96),SLVM1(4,4),SLVM2(4,4)
      CHARACTER*8 VMESA(0:4),VMESB(0:4)
      DATA VMESA / 'VMESON  ','RHO     ','OMEGA   ','PHI     ',
     &             'PI+PI-  ' /
      DATA VMESB / 'VMESON  ','RHO     ','OMEGA   ','PHI     ',
     &             'PI+PI-  ' /

      CDABS(AMPEL) = ABS(AMPEL)

      ETMP = ECM
      IF(EE.LT.0.D0) GOTO 500
      ECM = EE

C  impact parameter integration
C     BMAX=12.D0*SQRT(MAX(BPOM,BREG))
      BMAX=10.D0
      CALL PHO_GAUSET(0.D0,BMAX,NGAUSO,XPNT,WGHT)
      SIGTOT    = 0.D0
      SIGINE    = 0.D0
      SIGELA    = 0.D0
      SIGNDF    = 0.D0
      SIGLSD(1) = 0.D0
      SIGLSD(2) = 0.D0
      SIGLDD    = 0.D0
      SIGHSD(1) = 0.D0
      SIGHSD(2) = 0.D0
      SIGHDD    = 0.D0
      SIGCDF(0) = 0.D0
      SIG1SO    = 0.D0
      SIG1HA    = 0.D0
      SLEL1 = 0.D0
      SLEL2 = 0.D0
      DO 50 I=1,4
        SIGCDF(I) = 0.D0
        DO 55 K=1,4
          SIGVM(I,K) = 0.D0
          SLVM1(I,K) = 0.D0
          SLVM2(I,K) = 0.D0
 55     CONTINUE
 50   CONTINUE


      DO 100 I=1,NGAUSO
        B2  = XPNT(I)**2
        WG  = WGHT(I)*XPNT(I)
        WGB = B2*WG

C  calculate impact parameter amplitude, results in /POINT4/
        IF(I.EQ.1) THEN
          CALL PHO_EIKON(IP,IFHARD,XPNT(I))
        ELSE
          CALL PHO_EIKON(IP,1,XPNT(I))
        ENDIF

        SIGTOT    = SIGTOT + DREAL(AMPEL)*WG
        SIGELA    = SIGELA + CDABS(AMPEL)**2*WG
        SLEL1     = SLEL1  + AMPEL*WGB
        SLEL2     = SLEL2  + AMPEL*WG

        DO 110 J=1,4
          DO 120 K=1,4
            SIGVM(J,K) = SIGVM(J,K) + CDABS(AMPVM(J,K))**2*WG
            SLVM1(J,K) = SLVM1(J,K) + AMPVM(J,K)*WGB
            SLVM2(J,K) = SLVM2(J,K) + AMPVM(J,K)*WG
 120      CONTINUE
          SIGCDF(J)   = SIGCDF(J)   + DREAL(AMPDP(J))*WG
 110    CONTINUE

        SIGLSD(1) = SIGLSD(1) + CDABS(AMLMSD(1))**2*WG
        SIGLSD(2) = SIGLSD(2) + CDABS(AMLMSD(2))**2*WG
        SIGLDD    = SIGLDD    + CDABS(AMLMDD)**2*WG
        SIG1SO    = SIG1SO    + DREAL(AMPSOF)*WG
        SIG1HA    = SIG1HA    + DREAL(AMPHAR)*WG
        SIGHSD(1) = SIGHSD(1) + DREAL(AMHMSD(1))*WG
        SIGHSD(2) = SIGHSD(2) + DREAL(AMHMSD(2))*WG
        SIGHDD    = SIGHDD    + DREAL(AMHMDD)*WG

 100  CONTINUE

      SIGDIR = DREAL(SIGHD)
      FAC    = 4.D0*PI2
      SIGTOT = SIGTOT*FAC
      SIGELA = SIGELA*FAC
      FACSL  = 0.5D0/GEV2MB
      SLOEL  = SLEL1/MAX(DEPS,SLEL2)*FACSL

      IF((IFPAP(1).EQ.22).OR.(IFPAP(2).EQ.22)) THEN
        DO 130 I=1,4
          DO 140 J=1,4
            SIGVM(I,J) = SIGVM(I,J)*FAC
            SLOVM(I,J) = SLVM1(I,J)/MAX(DEPS,SLVM2(I,J))*FACSL
 140      CONTINUE
 130    CONTINUE
        SIGVM(0,0) = 0.D0
        DO 150 I=1,4
          SIGVM(0,I) = 0.D0
          SIGVM(I,0) = 0.D0
          DO 160 J=1,4
            SIGVM(0,I) = SIGVM(0,I) + SIGVM(J,I)
            SIGVM(I,0) = SIGVM(I,0) + SIGVM(I,J)
 160      CONTINUE
          SIGVM(0,0) = SIGVM(0,0) + SIGVM(I,0)
 150    CONTINUE
      ENDIF

C  diffractive cross sections

      SIGLSD(1) = SIGLSD(1)*FAC*PARMDL(40)
      SIGLSD(2) = SIGLSD(2)*FAC*PARMDL(41)
      SIGLDD    = SIGLDD   *FAC*PARMDL(42)
      SIGHSD(1) = (SIGHSD(1)-2.D0*(SIGCDF(1)+SIGCDF(2)))*FAC*PARMDL(40)
      SIGHSD(2) = (SIGHSD(2)-2.D0*(SIGCDF(1)+SIGCDF(3)))*FAC*PARMDL(41)
      SIGHDD    = (SIGHDD-2.D0*(SIGCDF(2)+SIGCDF(3)+2.D0*SIGCDF(4)))
     &            *FAC*PARMDL(42)

C  double pomeron scattering

      SIGCDF(0) = 0.D0
      DO 170 I=1,4
        SIGCDF(I) = SIGCDF(I)*FAC
        SIGCDF(0) = SIGCDF(0)+SIGCDF(I)
 170  CONTINUE


      SIG1SO    = SIG1SO   *FAC
      SIG1HA    = SIG1HA   *FAC

      SIGINE    = SIGTOT - SIGELA

C  user-forced change of diffractive cross section

      IF((IP.EQ.1).AND.(ISWMDL(30).GE.1)) THEN

C  use optional explicit parametrization for single-diffraction

        SIGSD1 = SIGLSD(1)+SIGHSD(1)
        SIGSD2 = SIGLSD(2)+SIGHSD(2)
        SS = EE*EE
        XI_MIN = 1.5D0/SS
        XI_MAX = PARMDL(45)**2
        CALL PHO_CSDIFF(IFPAP(1),IFPAP(2),SS,XI_MIN,XI_MAX,
     &    SIG_SD1,SIG_SD2,SIG_DD)
        SIG_SD1 = SIG_SD1*PARMDL(40)
        SIG_SD2 = SIG_SD2*PARMDL(41)
**sr
C       DEL_SD1 = SIG_SD1-SIGSD1
        DEL_SD1 = PARMDL(200)*(SIG_SD1-SIGSD1)
**
        FAC = SIGLSD(1)/SIGSD1
        SIGLSD(1) = SIGLSD(1)+FAC*DEL_SD1
        SIGHSD(1) = SIGHSD(1)+(1.D0-FAC)*DEL_SD1
**sr
C       DEL_SD2 = SIG_SD2-SIGSD2
        DEL_SD2 = PARMDL(200)*(SIG_SD2-SIGSD2)
**
        FAC = SIGLSD(2)/SIGSD2
        SIGLSD(2) = SIGLSD(2)+FAC*DEL_SD2
        SIGHSD(2) = SIGHSD(2)+(1.D0-FAC)*DEL_SD2

        IF(ISWMDL(30).GE.2) THEN

C  use explicit parametrization also for double diffraction diss.
          SIGDD  = SIGLDD+SIGHDD
          SIG_DD = SIG_DD*PARMDL(42)
          DEL_DD = SIG_DD-SIGDD
          FAC = SIGLDD/SIGDD
          SIGLDD = SIGLDD+FAC*DEL_DD
          SIGHDD = SIGHDD+(1.D0-FAC)*DEL_DD
          SIGCOR = DEL_SD1 + DEL_SD2 + DEL_DD

        ELSE

C  rescale double diffraction cross sections
          SIGLDD    = SIGLDD   *PARMDL(42)
          SIGHDD    = SIGHDD   *PARMDL(42)
          SIGCOR = DEL_SD1 + DEL_SD2
     &      +(SIGLDD+SIGHDD)*(PARMDL(42)-1.D0)

        ENDIF

      ELSE

C  rescale unitarized cross sections for diffraction dissociation

        SIGLSD(1) = SIGLSD(1)*PARMDL(40)
        SIGHSD(1) = SIGHSD(1)*PARMDL(40)
        SIGLSD(2) = SIGLSD(2)*PARMDL(41)
        SIGHSD(2) = SIGHSD(2)*PARMDL(41)
        SIGLDD    = SIGLDD   *PARMDL(42)
        SIGHDD    = SIGHDD   *PARMDL(42)
        SIGCOR = (SIGLSD(1)+SIGHSD(1))*(PARMDL(40)-1.D0)
     &          +(SIGLSD(2)+SIGHSD(2))*(PARMDL(41)-1.D0)
     &          +(SIGLDD+SIGHDD)*(PARMDL(42)-1.D0)

      ENDIF

C  non-diffractive inelastic cross section

      SIGNDF    = SIGTOT-SIGELA-SIGVM(0,0)-SIGCDF(0)-SIGDIR
     &            -SIGLSD(1)-SIGHSD(1)-SIGLSD(2)-SIGHSD(2)
     &            -SIGLDD-SIGHDD

C  specify elastic scattering channel

 500  CONTINUE
      IF(IFPAP(1).NE.22) THEN
        VMESA(1) = PHO_PNAME(IFPAB(1),0)
      ELSE
        VMESA(1) = 'RHO           '
      ENDIF
      IF(IFPAP(2).NE.22) THEN
        VMESB(1) = PHO_PNAME(IFPAB(2),0)
      ELSE
        VMESB(1) = 'RHO           '
      ENDIF

C  write out physical cross sections

      IF(IDEB(57).GE.5) THEN
        WRITE(ErrorOut,'(/1X,A,I3,/1X,A)')
     &    'PHO_XSECT: CROSS SECTIONS (MB) FOR COMBINATION',IP,
     &    '----------------------------------------------'
        WRITE(ErrorOut,
     * '(5X,A,E12.3,2E11.3)')'energy,virtualities',ECM,PVIRT
        WRITE(ErrorOut,
     * '(5X,A,E12.3)') '             total ',SIGTOT
        WRITE(ErrorOut,
     * '(5X,A,E12.3)') '    purely elastic ',SIGELA
        WRITE(ErrorOut,
     * '(5X,A,E12.3)') '         inelastic ',SIGINE
        WRITE(ErrorOut,'(5X,A,E12.3)') ' s-diff.particle 1 ',
     &    SIGLSD(1)+SIGHSD(1)
        IF(IDEB(57).GE.7) THEN
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') '     low-mass part ',SIGLSD(1)
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') '    high-mass part ',SIGHSD(1)
        ENDIF
        WRITE(ErrorOut,'(5X,A,E12.3)') ' s-diff.particle 2 ',
     &    SIGLSD(2)+SIGHSD(2)
        IF(IDEB(57).GE.7) THEN
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') '     low-mass part ',SIGLSD(2)
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') '    high-mass part ',SIGHSD(2)
        ENDIF
        WRITE(ErrorOut,
     * '(5X,A,E12.3)') '       double diff ',SIGLDD+SIGHDD
        IF(IDEB(57).GE.7) THEN
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') '     low-mass part ',SIGLDD
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') '    high-mass part ',SIGHDD
        ENDIF
        WRITE(ErrorOut,
     * '(5X,A,E12.3)') '    double pomeron ',SIGCDF(0)
        IF(IDEB(57).GE.7) THEN
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') '    purely elastic ',SIGCDF(1)
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') ' excitation part.1 ',SIGCDF(2)
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') ' excitation part.2 ',SIGCDF(3)
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') '   excitation both ',SIGCDF(4)
        ENDIF
        WRITE(ErrorOut,
     * '(5X,A,E12.3)') '     elastic slope ',SLOEL
        DO 200 I=1,4
          DO 210 J=1,4
            IF(SIGVM(I,J).GT.DEPS) THEN
              WRITE(ErrorOut,
     * '(1X,3A)') 'q-elastic production of ',
     &          VMESA(I),VMESB(J)
              WRITE(ErrorOut,
     * '(10X,A,E12.3)') 'cross section ',SIGVM(I,J)
              IF((I.NE.0).AND.(J.NE.0))
     &          WRITE(ErrorOut,
     * '(18X,A,E12.3)') 'slope ',SLOVM(I,J)
            ENDIF
 210      CONTINUE
 200    CONTINUE
        IF(IDEB(57).GE.7) THEN
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') ' vmeson production ',SIGVM(0,0)
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') '  one-pomeron soft ',SIG1SO
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') '  one-pomeron hard ',SIG1HA
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') '  pomeron exchange ',SIGPOM
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') '  reggeon exchange ',SIGREG
          WRITE(ErrorOut,
     * '(5X,A,E12.3)') ' hard resolved QCD ',DREAL(DSIGH(9))
          WRITE(ErrorOut,
     * '(5X,A,E12.3/)')'   hard direct QCD ',DREAL(DSIGH(15))
        ENDIF
      ENDIF

      ECM = ETMP

      END
#endif
