#include "Zcondc.h"
#if USEDPMJET == 1
c
c===evtini=============================================================*
c
CDECK  ID>, DT_EVTINI
      SUBROUTINE DT_EVTINI

c***********************************************************************
c Initialization of DTEVT1.                                            *
c This version dated 15.01.94 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c event flag
      COMMON /DTEVNO/ NEVENT,ICASCA

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL


c initialization of DTEVT1/DTEVT2
      NEND = NHKK
      IF (NEVENT.EQ.1) NEND = NMXHKK
      NHKK   = 0
      NEVHKK = NEVENT
      DO 1 I=1,NEND
         ISTHKK(I)   = 0
         IDHKK(I)    = 0
         JMOHKK(1,I) = 0
         JMOHKK(2,I) = 0
         JDAHKK(1,I) = 0
         JDAHKK(2,I) = 0
         IDRES(I)    = 0
         IDXRES(I)   = 0
         NOBAM(I)    = 0
         IDCH(I)     = 0
         IHIST(1,I)  = 0
         IHIST(2,I)  = 0
         DO 2 J=1,4
            PHKK(J,I) = 0.0D0
            VHKK(J,I) = 0.0D0
            WHKK(J,I) = 0.0D0
    2    CONTINUE
         PHKK(5,I) = 0.0D0
    1 CONTINUE
      DO 3 I=1,10
         NPOINT(I) = 0
    3 CONTINUE
      CALL DT_CHASTA(-1)

C* initialization of DTLTRA
C      IF (NCOMPO.GT.0) CALL DT_LTINI(ID,EPN,PPN,ECM)

      RETURN
      END
c
c===statis=============================================================*
c
CDECK  ID>, DT_STATIS
      SUBROUTINE DT_STATIS(MODE)

c***********************************************************************
c Initialization and output of run-statistics.                         *
c              MODE  = 1     initialization                            *
c                    = 2     output                                    *
c This version dated 23.01.94 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY3=1.0D-3)

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c central particle production, impact parameter biasing
      COMMON /DTIMPA/ BIMIN,BIMAX,XSFRAC,ICENTR

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c flags for particle decays
      COMMON /DTFRPA/ MSTUX(20),PARUX(20),MSTJX(20),PARJX(20),
     &                IMSTU(20),IPARU(20),IMSTJ(20),IPARJ(20),
     &                NMSTU,NPARU,NMSTJ,NPARJ,PDB,PDBSEA(3),ISIG0,IPI0

c diquark-breaking mechanism
      COMMON /DTDIQB/ DBRKR(3,8),DBRKA(3,8),CHAM1,CHAM3,CHAB1,CHAB3


      DIMENSION PP(4),PT(4)

      GOTO (1,2) MODE

c initialization
    1 CONTINUE

c   initialize statistics counter
      ICREQU = 0
      ICSAMP = 0
      ICCPRO = 0
      ICDPR  = 0
      ICDTA  = 0
      ICRJSS = 0
      ICVV2S = 0
      DO 10 I=1,9
         ICRES(I)    = 0
         ICCHAI(1,I) = 0
         ICCHAI(2,I) = 0
   10 CONTINUE
c   initialize rejection counter
      IRPT      = 0
      IRHHA     = 0
      LOMRES    = 0
      LOBRES    = 0
      IRFRAG    = 0
      IREVT     = 0
      IRRES(1)  = 0
      IRRES(2)  = 0
      IRCHKI(1) = 0
      IRCHKI(2) = 0
      IRCRON(1) = 0
      IRCRON(2) = 0
      IRCRON(3) = 0
      IRDIFF(1) = 0
      IRDIFF(2) = 0
      IRINC     = 0
      DO 11 I=1,5
         ICDIFF(I) = 0
   11 CONTINUE
      DO 12 I=1,8
         DO 13 J=0,30
            ICEVTG(I,J) = 0
   13    CONTINUE
   12 CONTINUE

      RETURN

c output
    2 CONTINUE

c   statistics counter
      WRITE(ErrorOut,1000)
 1000 FORMAT(/,/,1X,'STATIS:',20X,'STATISTICS OF THE RUN',/,
     &       28X,'---------------------')
      WRITE(ErrorOut,
     * 1001) ICREQU,ICSAMP,DBLE(ICSAMP)/DBLE(ICREQU)
 1001 FORMAT(/,1X,'NUMBER OF EVENTS REQUESTED / SAMPLED',13X,
     &       I8,' / ',I8,/,1X,'NUMBER OF SAMP. EVTS PER REQUESTED ',
     &       'EVENT',11X,F9.1)
      IF (ICDIFF(1).NE.0) THEN
         WRITE(ErrorOut,1009) ICDIFF
 1009    FORMAT(/,1X,'DIFFRACTIVE EVENTS:    TOTAL   ',I8,/,49X,
     &          'LOW MASS   HIGH MASS',/,24X,'SINGLE DIFFRACTION',
     &          7X,I8,4X,I8,/,24X,'DOUBLE DIFFRACTION',7X,I8,4X,I8)
      ENDIF
      IF (ICENTR.GT.0) THEN
         WRITE(ErrorOut,1002) DBLE(ICCPRO)/DBLE(ICSAMP),
     &                    DBLE(ICSAMP)/DBLE(ICCPRO)
 1002    FORMAT(/,1X,'CENTRAL PRODUCTION:',/,2X,'MEAN NUMBER',
     &          ' OF SAMPLED GLAUBER-EVENTS PER EVENT',9X,F9.1,/,
     &          2X,'FRACTION OF PRODUCTION CROSS SECTION',21X,F10.6)
      ENDIF
      WRITE(ErrorOut,1003) DBLE(ICDPR)/DBLE(ICSAMP),
     &                 DBLE(ICDTA)/DBLE(ICSAMP)
 1003 FORMAT(/,54X,'PROJ.    TARG.',/,1X,'AVERAGE NUMBER OF WOUNDED',
     &       ' NUCLEONS AFTER X-SAMPLING',2(4X,F6.2))

      IF (MCGENE.EQ.1) THEN
         WRITE(ErrorOut,1004) DBLE(ICRJSS)/DBLE(ICSAMP)
 1004    FORMAT(/,1X,'MEAN NUMBER OF SEA-SEA CHAIN REJECTIONS PER',
     &          ' EVENT',3X,F9.1)
         IF (ISICHA.EQ.1) THEN
            WRITE(ErrorOut,1005) DBLE(ICVV2S)/DBLE(ICSAMP)
 1005       FORMAT(/,1X,'REGGEON CONTRIBUTION:',/,1X,'MEAN NUMBER ',
     &             'OF SINGLE CHAINS  PER EVENT',13X,F9.1)
         ENDIF
         WRITE(ErrorOut,1006)
 1006    FORMAT(/,1X,'CHAIN SYSTEM STATISTICS:  (PER EVENT)',/,
     &       23X,'MEAN NUMBER OF CHAINS      MEAN NUMBER OF CHAINS',/,
     &       23X,'SAMPLED    HADRONIZED      HAVING MASS OF A RESO.')
         WRITE(ErrorOut,
     * 1007) (DBLE(ICCHAI(1,J))/(2.0D0*DBLE(ICSAMP)),
     &                     DBLE(ICCHAI(2,J))/(2.0D0*DBLE(ICREQU)),
     &                     DBLE(ICRES(J))/(2.0D0*DBLE(ICREQU)),J=1,8),
     &                  DBLE(ICCHAI(2,9))/MAX(DBLE(ICCHAI(1,9)),TINY3)
 1007    FORMAT(1X,'SEA     - SEA     ',6X,F4.1,8X,F4.1,17X,F4.1,/,
     &          1X,'DISEA   - SEA     ',6X,F4.1,8X,F4.1,17X,F4.1,/,
     &          1X,'SEA     - DISEA   ',6X,F4.1,8X,F4.1,17X,F4.1,/,
     &          1X,'SEA     - VALENCE ',6X,F4.1,8X,F4.1,17X,F4.1,/,
     &          1X,'DISEA   - VALENCE ',6X,F4.1,8X,F4.1,17X,F4.1,/,
     &          1X,'VALENCE - SEA     ',6X,F4.1,8X,F4.1,17X,F4.1,/,
     &          1X,'VALENCE - DISEA   ',6X,F4.1,8X,F4.1,17X,F4.1,/,
     &          1X,'VALENCE - VALENCE ',6X,F4.1,8X,F4.1,17X,F4.1,/,
     &          1X,'FUSED CHAINS      ',18X,F4.1,17X,F4.1,/)
         WRITE(ErrorOut,1008)
     &     (DBLE(IRCRON(I))/MAX(DBLE(IRCRON(1)),TINY3),I=2,3),
     &     DBLE(IRPT)/DBLE(ICREQU),(DBLE(IRRES(I))/DBLE(ICREQU),I=1,2),
     &     DBLE(LOMRES)/DBLE(ICREQU),DBLE(LOBRES)/DBLE(ICREQU),
     &     (DBLE(IRCHKI(I))/DBLE(ICREQU),I=1,2),
     &     (DBLE(IRDIFF(I))/DBLE(ICREQU),I=1,2),
     &     DBLE(IRHHA)/DBLE(ICREQU),
     &     DBLE(IRFRAG)/DBLE(ICREQU),DBLE(IREVT)/DBLE(ICREQU),
     &     (DBLE(IREXCI(I))/DBLE(ICREQU),I=1,2),IREXCI(3)
 1008    FORMAT(/,1X,'REJECTION COUNTER:  (NEVT = NO. OF EVENTS)',/,/,
     &       1X,'CRONIN-EFFECT (CRONIN)',15X,'IRCRON(2)/IRCRON(1) = ',
     &       F7.2,/,38X,'IRCRON(3)/IRCRON(1) = ',F7.2,/,1X,
     &       'INTRINS. P_T (GETSPT)',21X,'IRPT     /NEVT = ',F7.2,/,
     &       1X,'CHAIN MASS CORR. FOR RESONANCES (EVTRES)',2X,
     &       'IRRES(1) /NEVT = ',F7.2,/,33X,'(CH2RES)  IRRES(2) /',
     &       'NEVT = ',F7.2,/,43X,'LOMRES   /NEVT = ',F7.2,/,
     &       43X,'LOBRES   /NEVT = ',F7.2,/,1X,'KINEM. CORR. OF',
     &       ' 2-CHAIN SYSTEMS (CHKINE)  IRCHKI(1)/NEVT = ',F7.2,/,
     &       43X,'IRCHKI(2)/NEVT = ',F7.2,/,1X,'DIFFRACTION',31X,
     &       'IRDIFF(1)/NEVT = ',F7.2,/,43X,'IRDIFF(2)/NEVT = ',
     &       F7.2,/,1X,'TOTAL NO. OF REJ.',
     &       ' IN CHAIN-SYSTEMS TREATMENT (GETCSY)',/,43X,
     &       'IRHHA    /NEVT = ',F7.2,/,1X,'FRAGMENTATION (EVTFRA)',
     &       ' (NOT YET USED!)',4X,'IRFRAG   /NEVT = ',F7.2,/,
     &       1X,'TOTAL NO. OF REJ. IN DPM-TREATMENT OF ONE EVENT',
     &       ' (EVENTA)',/,43X,'IREVT    /NEVT = ',F7.2,/,1X,
     &       'TREATMENT OF FINAL NUCLEON CONF.',10X,'IREXCI(1)/NEVT = '
     &       ,F7.2,/,43X,'IREXCI(2)/NEVT = ',F7.2,/,48X,
     &       'IREXCI(3) = ',I5,/)
      ELSEIF (MCGENE.EQ.2) THEN
         WRITE(ErrorOut,1010) ELOJET
 1010    FORMAT(/,/,1X,'PHOJET-TREATMENT OF CHAIN SYSTEMS ABOVE  ',
     &          F4.1,' GEV')
         WRITE(ErrorOut,1011)
 1011    FORMAT(/,1X,'1. CHAIN SYSTEM STATISTICS - TOTAL NUMBERS:',/,
     &          30X,'--------------',/,/,12X,'S-S',5X,'D-S',5X,'S-D',
     &          5X,'S-V',5X,'D-V',5X,'V-S',5X,'V-D',5X,'V-V')
         WRITE(ErrorOut,1012) ((ICEVTG(I,J),I=1,8),J=0,1),
     &                    (INT(ICCHAI(2,I)/2.0D0),I=1,8),
     &                    (ICEVTG(I,2),I=1,8),(ICEVTG(I,29),I=1,8),
     &                    ((ICEVTG(I,J),I=1,8),J=3,7),
     &                    ((ICEVTG(I,J),I=1,8),J=19,21),
     &                    (ICEVTG(I,8),I=1,8),
     &                    ((ICEVTG(I,J),I=1,8),J=22,24),
     &                    (ICEVTG(I,9),I=1,8),
     &                    ((ICEVTG(I,J),I=1,8),J=25,28),
     &                    ((ICEVTG(I,J),I=1,8),J=10,18)
 1012    FORMAT(/,1X,'REQ.TO.',8I8,/,/,1X,'LOW RQ.',8I8,/,1X,'LOW AC.',
     &          8I8,/,/,1X,'PHOJET ',8I8,/,'   SNGL ',8I8,/,/,
     &          ' NO-DIF.',8I8,/,
     &          ' EL-SCA.',8I8,/,' QEL-SC.',8I8,/,' DBL-PO.',8I8,/,
     &          ' DIFF-1 ',8I8,/,'  LOW   ',8I8,/,'  HIGH  ',8I8,/,
     &          '  H-DIFF',8I8,/,' DIFF-2 ',8I8,/,'  LOW   ',8I8,/,
     &          '  HIGH  ',8I8,/,'  H-DIFF',8I8,/,' DBL-DI.',8I8,/,
     &          '  LO-LO ',8I8,/,'  HI-HI ',8I8,/,'  LO-HI ',8I8,/,
     &          '  HI-LO ',8I8,/,
     &          ' DIR-GA.',8I8,/,/,' DIR-1  ',8I8,/,' DIR-2  ',8I8,/,
     &          ' DBL-DIR',8I8,/,' S-POM. ',8I8,/,' H-POM. ',8I8,/,
     &          ' S-REG. ',8I8,/,' ENH-TRG',8I8,/,' ENH-LOG',8I8)
         WRITE(ErrorOut,1013)
 1013    FORMAT(/,1X,'2. CHAIN SYSTEM STATISTICS -',
     &          ' MEAN NUMBERS PER EVT:',/,30X,'---------------------',
     &          /,/,16X,'S-S',7X,'D-S',7X,'S-D')
         WRITE(ErrorOut,1014)
     &                 ((DBLE(ICEVTG(I,J))/DBLE(ICSAMP),I=1,3),J=0,1),
     &                 (DBLE(ICCHAI(2,I))/(2.0D0*DBLE(ICSAMP)),I=1,3),
     &                 ((DBLE(ICEVTG(I,J))/DBLE(ICSAMP),I=1,3),J=2,18)
 1014    FORMAT(/,1X,'REQ.TO.    ',3E10.2,/,/,1X,'LOW RQ.    ',3E10.2,/,
     &          1X,'LOW AC.    ',3E10.2,/,/,1X,'PHOJET     ',3E10.2,/,/,
     &          ' NO-DIF.    ',3E10.2,/,' EL-SCA.    ',3E10.2,/,
     &          ' QEL-SC.    ',3E10.2,/,' DBL-PO.    ',3E10.2,/,
     &          ' DIFF-1     ',3E10.2,/,' DIFF-2     ',3E10.2,/,
     &          ' DBL-DI.    ',3E10.2,/,' DIR-GA.    ',3E10.2,/,/,
     &          ' DIR-1      ',3E10.2,/,' DIR-2      ',3E10.2,/,
     &          ' DBL-DIR    ',3E10.2,/,' S-POM.     ',3E10.2,/,
     &          ' H-POM.     ',3E10.2,/,' S-REG.     ',3E10.2,/,
     &          ' ENH-TRG    ',3E10.2,/,' ENH-LOG    ',3E10.2)
         WRITE(ErrorOut,1015)
 1015    FORMAT(/,16X,'S-V',7X,'D-V',7X,'V-S',7X,'V-D',7X,'V-V')
         WRITE(ErrorOut,1016)
     &                 ((DBLE(ICEVTG(I,J))/DBLE(ICSAMP),I=4,8),J=0,1),
     &                 (DBLE(ICCHAI(2,I))/(2.0D0*DBLE(ICSAMP)),I=4,8),
     &                 ((DBLE(ICEVTG(I,J))/DBLE(ICSAMP),I=4,8),J=2,18)
 1016    FORMAT(/,1X,'REQ.TO.    ',5E10.2,/,/,1X,'LOW RQ.    ',5E10.2,/,
     &          1X,'LOW AC.    ',5E10.2,/,/,1X,'PHOJET     ',5E10.2,/,/,
     &          ' NO-DIF.    ',5E10.2,/,' EL-SCA.    ',5E10.2,/,
     &          ' QEL-SC.    ',5E10.2,/,' DBL-PO.    ',5E10.2,/,
     &          ' DIFF-1     ',5E10.2,/,' DIFF-2     ',5E10.2,/,
     &          ' DBL-DI.    ',5E10.2,/,' DIR-GA.    ',5E10.2,/,/,
     &          ' DIR-1      ',5E10.2,/,' DIR-2      ',5E10.2,/,
     &          ' DBL-DIR    ',5E10.2,/,' S-POM.     ',5E10.2,/,
     &          ' H-POM.     ',5E10.2,/,' S-REG.     ',5E10.2,/,
     &          ' ENH-TRG    ',5E10.2,/,' ENH-LOG    ',5E10.2)

      ENDIF
      CALL DT_CHASTA(1)

      IF ((PDBSEA(1).GT.0.0D0).OR.(PDBSEA(2).GT.0.0D0)
     &                        .OR.(PDBSEA(3).GT.0.0D0)) THEN
         WRITE(ErrorOut,*)'YGS1S,YGS2S,YUS1S,YUS2S',
     &    DBRKA(1,1)+DBRKA(2,1),DBRKA(1,2)+DBRKA(2,2),
     &    DBRKA(1,3)+DBRKA(2,3),DBRKA(1,4)+DBRKA(2,4)
         WRITE(ErrorOut,*)'YGS1R,YGS2R,YUS1R,YUS2R',
     &    DBRKR(1,1)+DBRKR(2,1),DBRKR(1,2)+DBRKR(2,2),
     &    DBRKR(1,3)+DBRKR(2,3),DBRKR(1,4)+DBRKR(2,4)
         WRITE(ErrorOut,*)'YGSA1S,YGSA2S,YUSA1S,YUSA2S',
     &    DBRKA(1,5)+DBRKA(2,5),DBRKA(1,6)+DBRKA(2,6),
     &    DBRKA(1,7)+DBRKA(2,7),DBRKA(1,8)+DBRKA(2,8)
         WRITE(ErrorOut,*)'YGSA1R,YGSA2R,YUSA1R,YUSA2R',
     &    DBRKR(1,5)+DBRKR(2,5),DBRKR(1,6)+DBRKR(2,6),
     &    DBRKR(1,7)+DBRKR(2,7),DBRKR(1,8)+DBRKR(2,8)
         WRITE(ErrorOut,*)'YG31S,YG32S,YU31S,YU32S',
     &    DBRKA(3,1),DBRKA(3,2),
     &    DBRKA(3,3),DBRKA(3,4)
         WRITE(ErrorOut,*)'YG31R,YG32R,YU31R,YU32R',
     &    DBRKR(3,1),DBRKR(3,2),
     &    DBRKR(3,3),DBRKR(3,4)
         WRITE(ErrorOut,*)'YG3A1S,YG3A2S,YU3A1S,YU3A2S',
     &    DBRKA(3,5),DBRKA(3,6),
     &    DBRKA(3,7),DBRKA(3,8)
         WRITE(ErrorOut,*)'YG3A1R,YG3A2R,YU3A1R,YU3A2R',
     &    DBRKR(3,5),DBRKR(3,6),
     &    DBRKR(3,7),DBRKR(3,8)
      ENDIF

      FAC = 1.0D0
      IF (MCGENE.EQ.2) THEN

C        CALL PHO_PHIST(-2,SIGMAX)
         CALL PHO_EVENT(-2,PP,PT,FAC,IREJ1)

      ENDIF

      CALL DT_XTIME

      RETURN
      END
c
c===evtout=============================================================*
c
CDECK  ID>, DT_EVTOUT
      SUBROUTINE DT_EVTOUT(MODE)

c***********************************************************************
c            MODE  = 1  plot content of complete DTEVT1 to out. unit   *
c                    3  plot entries of extended DTEVT1 (DTEVT2)       *
c                    4  plot entries of DTEVT1 and DTEVT2              *
c This version dated 11.12.94 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER (NMXHKK=90000)
      DIMENSION IRANGE(NMXHKK)

      IF (MODE.EQ.2) RETURN

      CALL DT_EVTPLO(IRANGE,MODE)

      RETURN
      END
c
c===evtplo=============================================================*
c
CDECK  ID>, DT_EVTPLO
      SUBROUTINE DT_EVTPLO(IRANGE,MODE)

c***********************************************************************
c            MODE  = 1  plot content of complete DTEVT1 to out. unit   *
c                    2  plot entries of DTEVT1 given by IRANGE         *
c                    3  plot entries of extended DTEVT1 (DTEVT2)       *
c                    4  plot entries of DTEVT1 and DTEVT2              *
c                    5  plot rejection counter                         *
c This version dated 11.12.94 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      CHARACTER*16 CHAU

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC


      DIMENSION IRANGE(NMXHKK)

      IF ((MODE.EQ.1).OR.(MODE.EQ.4)) THEN
         WRITE(ErrorOut,1000)
 1000    FORMAT(/,1X,'EVTPLO:',14X,'    CONTENT OF COMMON /DTEVT1/',/,
     &         15X,'           --------------------------',/,/,
     &             '       ST    ID  M1   M2   D1   D2     PX     PY',
     &             '     PZ      E       M',/)
         DO 1 I=1,NHKK
            WRITE(ErrorOut,
     * 1001) I,ISTHKK(I),IDHKK(I),JMOHKK(1,I),
     &                       JMOHKK(2,I),JDAHKK(1,I),JDAHKK(2,I),
     &                       PHKK(1,I),PHKK(2,I),PHKK(3,I),PHKK(4,I),
     &                       PHKK(5,I)
C           WRITE(LOUT,1011) I,ISTHKK(I),IDHKK(I),JMOHKK(1,I),
C    &                       JMOHKK(2,I),JDAHKK(1,I),JDAHKK(2,I),
C    &                       PHKK(3,I),PHKK(4,I)
C           WRITE(LOUT,'(4E15.4)')
C    &         VHKK(1,I),VHKK(2,I),VHKK(3,I),VHKK(4,I)
 1001       FORMAT(I5,I5,I6,4I5,3F7.3,F8.3,F8.4)
 1011       FORMAT(I5,I5,I6,4I5,2E15.5)
    1    CONTINUE
         WRITE(ErrorOut,*)
C        DO 4 I=1,NHKK
C           WRITE(LOUT,1006) I,ISTHKK(I),
C    &                    VHKK(1,I),VHKK(2,I),VHKK(3,I),WHKK(1,I),
C    &                    WHKK(2,I),WHKK(3,I)
C1006       FORMAT(1X,I4,I6,6E10.3)
C   4    CONTINUE
      ENDIF

      IF (MODE.EQ.2) THEN
         WRITE(ErrorOut,1000)
         NC = 0
    2    CONTINUE
         NC = NC+1
         IF (IRANGE(NC).EQ.-100) GOTO 9999
         I = IRANGE(NC)
         WRITE(ErrorOut,1001) I,ISTHKK(I),IDHKK(I),JMOHKK(1,I),
     &                    JMOHKK(2,I),JDAHKK(1,I),JDAHKK(2,I),
     &                    PHKK(1,I),PHKK(2,I),PHKK(3,I),PHKK(4,I),
     &                    PHKK(5,I)
         GOTO 2
      ENDIF

      IF ((MODE.EQ.3).OR.(MODE.EQ.4)) THEN
         WRITE(ErrorOut,1002)
 1002    FORMAT(/,1X,'EVTPLO:',14X,
     &         ' CONTENT OF COMMON /DTEVT1/,/DTEVT2/',/,
     &         15X,'        -----------------------------------',/,/,
     &             '       ST    ID   M1   M2   D1   D2  IDR  IDXR',
     &             ' NOBAM IDCH    M',/)
         DO 3 I=1,NHKK
C           IF ((ISTHKK(I).GT.10).OR.(ISTHKK(I).EQ.1)) THEN
               KF    = IDHKK(I)
               IDCHK = KF/10000
               IF ((((IDCHK.EQ.7).OR.(IDCHK.EQ.8)).AND.
     &            (KF.NE.80000)).OR.(IDHKK(I).EQ.99999)) KF = 92

               CALL PYNAME(KF,CHAU)

               WRITE(ErrorOut,
     * 1003) I,ISTHKK(I),IDHKK(I),JMOHKK(1,I),
     &                       JMOHKK(2,I),JDAHKK(1,I),JDAHKK(2,I),
     &                       IDRES(I),IDXRES(I),NOBAM(I),IDCH(I),
     &                       PHKK(5,I),CHAU
 1003          FORMAT(I5,I5,I6,4I5,4I4,F8.4,2X,A)
C           ENDIF
    3    CONTINUE
      ENDIF

      IF (MODE.EQ.5) THEN
         WRITE(ErrorOut,1004)
 1004    FORMAT(/,1X,'EVTPLO:',14X,'    CONTENT OF COMMON /DTREJC/',/,
     &         15X,'           --------------------------',/)
         WRITE(ErrorOut,
     * 1005) IRPT,IRHHA,IRRES,LOMRES,LOBRES,IREMC,IRFRAG,
     &                    IRSEA,IRCRON
 1005    FORMAT(1X,'IRPT   = ',I5,'  IRHHA = ',I5,/,
     &          1X,'IRRES  = ',2I5,'  LOMRES = ',I5,'  LOBRES = ',I5,/,
     &          1X,'IREMC  = ',10I5,/,
     &          1X,'IRFRAG = ',I5,'  IRSEA = ',I5,' IRCRON = ',I5,/)
      ENDIF

 9999 RETURN
      END
c
c===evtput=============================================================*
c
CDECK  ID>, DT_EVTPUT
      SUBROUTINE DT_EVTPUT(IST,ID,M1,M2,PX,PY,PZ,E,IDR,IDXR,IDC)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY4=1.0D-4,TINY3=1.0D-3,
     &           TINY2=1.0D-2,SQTINF=1.0D+15,ZERO=0.0D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


C     IF (MODE.GT.100) THEN
C        WRITE(LOUT,'(1X,A,I5,A,I5)')
C    &        'EVTPUT: reset NHKK = ',NHKK,' to NHKK =',NHKK-MODE+100
C        NHKK = NHKK-MODE+100
C        RETURN
C     ENDIF
      MO1  = M1
      MO2  = M2
      NHKK = NHKK+1

      IF (NHKK.GT.NMXHKK) THEN
         WRITE(ErrorOut,1000) NHKK
 1000    FORMAT(1X,'EVTPUT: NHKK EXEEDS NMXHKK = ',I7,
     &             '! PROGRAM EXECUTION STOPPED..')
         STOP
      ENDIF
      IF (M1.LT.0) MO1 = NHKK+M1
      IF (M2.LT.0) MO2 = NHKK+M2
      ISTHKK(NHKK)   = IST
      IDHKK(NHKK)    = ID
      JMOHKK(1,NHKK) = MO1
      JMOHKK(2,NHKK) = MO2
      JDAHKK(1,NHKK) = 0
      JDAHKK(2,NHKK) = 0
      IDRES(NHKK)    = IDR
      IDXRES(NHKK)   = IDXR
      IDCH(NHKK)     = IDC
c* here we need to do something..
      IF (ID.EQ.88888) THEN
         IDMO1 = ABS(IDHKK(MO1))
         IDMO2 = ABS(IDHKK(MO2))
         IF ((IDMO1.LT.100).AND.(IDMO2.LT.100)) NOBAM(NHKK) = 3
         IF ((IDMO1.LT.100).AND.(IDMO2.GT.100)) NOBAM(NHKK) = 4
         IF ((IDMO1.GT.100).AND.(IDMO2.GT.100)) NOBAM(NHKK) = 5
         IF ((IDMO1.GT.100).AND.(IDMO2.LT.100)) NOBAM(NHKK) = 6
      ELSE
         NOBAM(NHKK) = 0
      ENDIF
      IDBAM(NHKK) = IDT_ICIHAD(ID)
      IF (MO1.GT.0) THEN
         IF (JDAHKK(1,MO1).NE.0) THEN
            JDAHKK(2,MO1) = NHKK
         ELSE
            JDAHKK(1,MO1) = NHKK
         ENDIF
      ENDIF
      IF (MO2.GT.0) THEN
         IF (JDAHKK(1,MO2).NE.0) THEN
            JDAHKK(2,MO2) = NHKK
         ELSE
            JDAHKK(1,MO2) = NHKK
         ENDIF
      ENDIF
C      IF ((IDBAM(NHKK).GT.0).AND.(IDBAM(NHKK).NE.7)) THEN
C         PTOT   = SQRT(PX**2+PY**2+PZ**2)
C         AM0    = SQRT(ABS( (E-PTOT)*(E+PTOT) ))
C         AMRQ   = AAM(IDBAM(NHKK))
C         AMDIF2 = (AM0-AMRQ)*(AM0+AMRQ)
C         IF ((ABS(AMDIF2).GT.TINY3).AND.(E.LT.SQTINF).AND.
C     &       (PTOT.GT.ZERO)) THEN
C            DELTA = -AMDIF2/(2.0D0*(E+PTOT))
CC           DELTA = (AMRQ2-AM2)/(2.0D0*(E+PTOT))
C            E     = E+DELTA
C            PTOT1 = PTOT-DELTA
C            PX    = PX*PTOT1/PTOT
C            PY    = PY*PTOT1/PTOT
C            PZ    = PZ*PTOT1/PTOT
C         ENDIF
C      ENDIF
      PHKK(1,NHKK) = PX
      PHKK(2,NHKK) = PY
      PHKK(3,NHKK) = PZ
      PHKK(4,NHKK) = E
      PTOT = SQRT( PX**2+PY**2+PZ**2 )
      IF ((IDHKK(NHKK).GE.22).AND.(IDHKK(NHKK).LE.24)) THEN
         PHKK(5,NHKK) = PHKK(4,NHKK)**2-PTOT**2
         PHKK(5,NHKK) = SIGN(SQRT(ABS(PHKK(5,NHKK))),PHKK(5,NHKK))
      ELSE
         PHKK(5,NHKK) = (PHKK(4,NHKK)-PTOT)*(PHKK(4,NHKK)+PTOT)
C        IF ((PHKK(5,NHKK).LT.0.0D0).AND.(ABS(PHKK(5,NHKK)).GT.TINY4))
C    &      WRITE(LOUT,'(1X,A,G10.3)')
C    &        'EVTPUT: negative mass**2 ',PHKK(5,NHKK)
         PHKK(5,NHKK) = SQRT(ABS(PHKK(5,NHKK)))
      ENDIF
      IDCHK = ID/10000
      IF (((IDCHK.EQ.7).OR.(IDCHK.EQ.8)).AND.(ID.NE.80000)) THEN
c special treatment for chains:
c    z coordinate of chain in Lab  = pos. of target nucleon
c    time of chain-creation in Lab = time of passage of projectile
c                                    nucleus at pos. of taget nucleus
C        VHKK(1,NHKK) = 0.5D0*(VHKK(1,MO1)+VHKK(1,MO2))
C        VHKK(2,NHKK) = 0.5D0*(VHKK(2,MO1)+VHKK(2,MO2))
         VHKK(1,NHKK) = VHKK(1,MO2)
         VHKK(2,NHKK) = VHKK(2,MO2)
         VHKK(3,NHKK) = VHKK(3,MO2)
         VHKK(4,NHKK) = VHKK(3,MO2)/BLAB-VHKK(3,MO1)/BGLAB
C        WHKK(1,NHKK) = 0.5D0*(WHKK(1,MO1)+WHKK(1,MO2))
C        WHKK(2,NHKK) = 0.5D0*(WHKK(2,MO1)+WHKK(2,MO2))
         WHKK(1,NHKK) = WHKK(1,MO1)
         WHKK(2,NHKK) = WHKK(2,MO1)
         WHKK(3,NHKK) = WHKK(3,MO1)
         WHKK(4,NHKK) = -WHKK(3,MO1)/BLAB+WHKK(3,MO2)/BGLAB
      ELSE
         IF (MO1.GT.0) THEN
            DO 1 I=1,4
               VHKK(I,NHKK) = VHKK(I,MO1)
               WHKK(I,NHKK) = WHKK(I,MO1)
    1       CONTINUE
         ELSE
            DO 2 I=1,4
               VHKK(I,NHKK) = ZERO
               WHKK(I,NHKK) = ZERO
    2       CONTINUE
         ENDIF
      ENDIF

      RETURN
      END
c
c===chasta=============================================================*
c
CDECK  ID>, DT_CHASTA
      SUBROUTINE DT_CHASTA(MODE)

c***********************************************************************
c This subroutine performs CHAin STAtistics and checks sequence of     *
c partons in dtevt1 and sorts them with projectile partons coming      *
c first if necessary.                                                  *
c                                                                      *
c This version dated  8.5.00  is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      CHARACTER*5 CCHTYP

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c pointer to chains in hkkevt common (used by qq-breaking mechanisms)
      PARAMETER (MAXCHN=10000)
      COMMON /DTIXCH/ IDXCHN(2,MAXCHN),NCHAIN


      DIMENSION ICHCFG(10,10,9,2),ICHTYP(5,5),
     &          CCHTYP(9),ICHSTA(10),ITOT(10)
      DATA ICHCFG /1800*0/
      DATA (ICHTYP(1,K),K=1,5) / 0, 1, 3, 0, 0/
      DATA (ICHTYP(2,K),K=1,5) / 2, 0, 0, 5, 0/
      DATA (ICHTYP(3,K),K=1,5) / 4, 0, 0, 7, 0/
      DATA (ICHTYP(4,K),K=1,5) / 0, 6, 8, 0, 0/
      DATA (ICHTYP(5,K),K=1,5) / 0, 0, 0, 0, 9/
      DATA ICHSTA / 21, 22, 31, 32, 41, 42, 51, 52, 61, 62/
      DATA CCHTYP / ' Q AQ','AQ Q ',' Q D ',' D Q ','AQ AD',
     &              'AD AQ',' D AD','AD D ',' G G '/
c
c initialization
c
      IF (MODE.EQ.-1) THEN
         NCHAIN = 0
c
c loop over DTEVT1 and analyse chain configurations
c
      ELSEIF (MODE.EQ.0) THEN
         DO 21 IDX=NPOINT(3),NHKK
            IDCHK = IDHKK(IDX)/10000
            IF (((IDCHK.EQ.7).OR.(IDCHK.EQ.8)).AND.
     &          (IDHKK(IDX).NE.80000).AND.
     &          (ISTHKK(IDX).NE.2).AND.(IDRES(IDX).EQ.0)) THEN
               IF (JMOHKK(1,IDX).GT.JMOHKK(2,IDX)) THEN
                  WRITE(ErrorOut,
     * *) ' CHASTA: JMOHKK(1,x) > JMOHKK(2,x) ',
     &                          ' AT ENTRY ',IDX
                  GOTO 21
               ENDIF
c
               IST1 = ABS(ISTHKK(JMOHKK(1,IDX)))
               IST2 = ABS(ISTHKK(JMOHKK(2,IDX)))
               IMO1 = IST1/10
               IMO1 = IST1-10*IMO1
               IMO2 = IST2/10
               IMO2 = IST2-10*IMO2
c   swop parton entries if necessary since we need projectile partons
c   to come first in the common
               IF (IMO1.GT.IMO2) THEN
                  NPTN = JMOHKK(2,IDX)-JMOHKK(1,IDX)+1
                  DO 22 K=1,NPTN/2
                     I0 = JMOHKK(1,IDX)-1+K
                     I1 = JMOHKK(2,IDX)+1-K
                     ITMP = ISTHKK(I0)
                     ISTHKK(I0) = ISTHKK(I1)
                     ISTHKK(I1) = ITMP
                     ITMP = IDHKK(I0)
                     IDHKK(I0) = IDHKK(I1)
                     IDHKK(I1) = ITMP
                     IF (JDAHKK(1,JMOHKK(1,I0)).EQ.I0)
     &                  JDAHKK(1,JMOHKK(1,I0)) = I1
                     IF (JDAHKK(2,JMOHKK(1,I0)).EQ.I0)
     &                  JDAHKK(2,JMOHKK(1,I0)) = I1
                     IF (JDAHKK(1,JMOHKK(2,I0)).EQ.I0)
     &                  JDAHKK(1,JMOHKK(2,I0)) = I1
                     IF (JDAHKK(2,JMOHKK(2,I0)).EQ.I0)
     &                  JDAHKK(2,JMOHKK(2,I0)) = I1
                     IF (JDAHKK(1,JMOHKK(1,I1)).EQ.I1)
     &                  JDAHKK(1,JMOHKK(1,I1)) = I0
                     IF (JDAHKK(2,JMOHKK(1,I1)).EQ.I1)
     &                  JDAHKK(2,JMOHKK(1,I1)) = I0
                     IF (JDAHKK(1,JMOHKK(2,I1)).EQ.I1)
     &                  JDAHKK(1,JMOHKK(2,I1)) = I0
                     IF (JDAHKK(2,JMOHKK(2,I1)).EQ.I1)
     &                  JDAHKK(2,JMOHKK(2,I1)) = I0
                     ITMP = JMOHKK(1,I0)
                     JMOHKK(1,I0) = JMOHKK(1,I1)
                     JMOHKK(1,I1) = ITMP
                     ITMP = JMOHKK(2,I0)
                     JMOHKK(2,I0) = JMOHKK(2,I1)
                     JMOHKK(2,I1) = ITMP
                     ITMP = JDAHKK(1,I0)
                     JDAHKK(1,I0) = JDAHKK(1,I1)
                     JDAHKK(1,I1) = ITMP
                     ITMP = JDAHKK(2,I0)
                     JDAHKK(2,I0) = JDAHKK(2,I1)
                     JDAHKK(2,I1) = ITMP
                     DO 23 J=1,4
                        RTMP1 = PHKK(J,I0)
                        RTMP2 = VHKK(J,I0)
                        RTMP3 = WHKK(J,I0)
                        PHKK(J,I0) = PHKK(J,I1)
                        VHKK(J,I0) = VHKK(J,I1)
                        WHKK(J,I0) = WHKK(J,I1)
                        PHKK(J,I1) = RTMP1
                        VHKK(J,I1) = RTMP2
                        WHKK(J,I1) = RTMP3
   23                CONTINUE
                     RTMP1 = PHKK(5,I0)
                     PHKK(5,I0) = PHKK(5,I1)
                     PHKK(5,I1) = RTMP1
                     ITMP = IDRES(I0)
                     IDRES(I0) = IDRES(I1)
                     IDRES(I1) = ITMP
                     ITMP = IDXRES(I0)
                     IDXRES(I0) = IDXRES(I1)
                     IDXRES(I1) = ITMP
                     ITMP = NOBAM(I0)
                     NOBAM(I0) = NOBAM(I1)
                     NOBAM(I1) = ITMP
                     ITMP = IDBAM(I0)
                     IDBAM(I0) = IDBAM(I1)
                     IDBAM(I1) = ITMP
                     ITMP = IDCH(I0)
                     IDCH(I0) = IDCH(I1)
                     IDCH(I1) = ITMP
                     ITMP = IHIST(1,I0)
                     IHIST(1,I0) = IHIST(1,I1)
                     IHIST(1,I1) = ITMP
                     ITMP = IHIST(2,I0)
                     IHIST(2,I0) = IHIST(2,I1)
                     IHIST(2,I1) = ITMP
   22             CONTINUE
               ENDIF
               IST1 = ABS(ISTHKK(JMOHKK(1,IDX)))
               IST2 = ABS(ISTHKK(JMOHKK(2,IDX)))
c
c   parton 1 (projectile side)
               IF (IST1.EQ.21) THEN
                  IDX1 = 1
               ELSEIF (IST1.EQ.22) THEN
                  IDX1 = 2
               ELSEIF (IST1.EQ.31) THEN
                  IDX1 = 3
               ELSEIF (IST1.EQ.32) THEN
                  IDX1 = 4
               ELSEIF (IST1.EQ.41) THEN
                  IDX1 = 5
               ELSEIF (IST1.EQ.42) THEN
                  IDX1 = 6
               ELSEIF (IST1.EQ.51) THEN
                  IDX1 = 7
               ELSEIF (IST1.EQ.52) THEN
                  IDX1 = 8
               ELSEIF (IST1.EQ.61) THEN
                  IDX1 = 9
               ELSEIF (IST1.EQ.62) THEN
                  IDX1 = 10
               ELSE
c                 WRITE(LOUT,*)
c    &               ' CHASTA: unknown parton status flag (',
c    &               IST1,') at entry ',JMOHKK(1,IDX),'(',IDX,')'
                  GOTO 21
               ENDIF
               ID = IDHKK(JMOHKK(1,IDX))
               IF (ABS(ID).LE.4) THEN
                  IF (ID.GT.0) THEN
                     ITYP1 = 1
                  ELSE
                     ITYP1 = 2
                  ENDIF
               ELSEIF (ABS(ID).GE.1000) THEN
                  IF (ID.GT.0) THEN
                     ITYP1 = 3
                  ELSE
                     ITYP1 = 4
                  ENDIF
               ELSEIF (ID.EQ.21) THEN
                  ITYP1 = 5
               ELSE
                  WRITE(ErrorOut,*)
     &               ' CHASTA: INCONSISTENT PARTON IDENTITY (',
     &               ID,') AT ENTRY ',JMOHKK(1,IDX),'(',IDX,')'
                  GOTO 21
               ENDIF
c
c   parton 2 (target side)
               IF (IST2.EQ.21) THEN
                  IDX2 = 1
               ELSEIF (IST2.EQ.22) THEN
                  IDX2 = 2
               ELSEIF (IST2.EQ.31) THEN
                  IDX2 = 3
               ELSEIF (IST2.EQ.32) THEN
                  IDX2 = 4
               ELSEIF (IST2.EQ.41) THEN
                  IDX2 = 5
               ELSEIF (IST2.EQ.42) THEN
                  IDX2 = 6
               ELSEIF (IST2.EQ.51) THEN
                  IDX2 = 7
               ELSEIF (IST2.EQ.52) THEN
                  IDX2 = 8
               ELSEIF (IST2.EQ.61) THEN
                  IDX2 = 9
               ELSEIF (IST2.EQ.62) THEN
                  IDX2 = 10
               ELSE
c                 WRITE(LOUT,*)
c    &               ' CHASTA: unknown parton status flag (',
c    &               IST2,') at entry ',JMOHKK(2,IDX),'(',IDX,')'
                  GOTO 21
               ENDIF
               ID = IDHKK(JMOHKK(2,IDX))
               IF (ABS(ID).LE.4) THEN
                  IF (ID.GT.0) THEN
                     ITYP2 = 1
                  ELSE
                     ITYP2 = 2
                  ENDIF
               ELSEIF (ABS(ID).GE.1000) THEN
                  IF (ID.GT.0) THEN
                     ITYP2 = 3
                  ELSE
                     ITYP2 = 4
                  ENDIF
               ELSEIF (ID.EQ.21) THEN
                  ITYP2 = 5
               ELSE
                  WRITE(ErrorOut,*)
     &               ' CHASTA: INCONSISTENT PARTON IDENTITY (',
     &               ID,') AT ENTRY ',JMOHKK(1,IDX),'(',IDX,')'
                  GOTO 21
               ENDIF
c
c   fill counter
               ITYPE = ICHTYP(ITYP1,ITYP2)
               IF (ITYPE.NE.0) THEN
                  ICHCFG(IDX1,IDX2,ITYPE,1) =ICHCFG(IDX1,IDX2,ITYPE,1)+1
                  NGLUON = JMOHKK(2,IDX)-JMOHKK(1,IDX)-1
                  ICHCFG(IDX1,IDX2,ITYPE,2) =
     &               ICHCFG(IDX1,IDX2,ITYPE,2)+NGLUON

                  NCHAIN = NCHAIN+1
                  IF (NCHAIN.GT.MAXCHN) THEN
                     WRITE(ErrorOut,
     * *) ' CHASTA: NCHAIN > MAXCHN ! ',
     &                  NCHAIN,MAXCHN
                     STOP
                  ENDIF
                  IDXCHN(1,NCHAIN) = IDX
                  IDXCHN(2,NCHAIN) = ITYPE
               ELSE
                  WRITE(ErrorOut,*)
     &               ' CHASTA: INCONSISTENT CHAIN AT ENTRY ',IDX
                  GOTO 21
               ENDIF
            ENDIF
   21    CONTINUE
c
c write statistics to output unit
c
      ELSEIF (MODE.EQ.1) THEN
         WRITE(ErrorOut,
     * '(/,A)') ' CHASTA: generated chain configurations'
         DO 31 I=1,10
            WRITE(ErrorOut,'(/,2A)')
     &         ' -----------------------------------------',
     &         '------------------------------------'
            WRITE(ErrorOut,'(2A)')
     &         ' P\\T         21     22     31     32     41',
     &         '     42     51     52     61     62'
            WRITE(ErrorOut,'(2A)')
     &         ' -----------------------------------------',
     &         '------------------------------------'
            DO 32 J=1,10
               ITOT(J) = 0
               DO 33 K=1,9
                  ITOT(J) = ITOT(J)+ICHCFG(I,J,K,1)
   33          CONTINUE
   32       CONTINUE
            WRITE(ErrorOut,
     * '(1X,I2,5X,10I7,/)') ICHSTA(I),(ITOT(J),J=1,10)
            DO 34 K=1,9
               ISUM = 0
               DO 35 J=1,10
                  ISUM = ISUM+ICHCFG(I,J,K,1)
   35          CONTINUE
               IF (ISUM.GT.0)
     &            WRITE(ErrorOut,'(1X,A5,2X,10I7)')
     &               CCHTYP(K),(ICHCFG(I,J,K,1),J=1,10)
   34       CONTINUE
C           WRITE(LOUT,'(2A)')
C    &         ' -----------------------------------------',
C    &         '-------------------------------'
   31    CONTINUE
c
      ELSE
         WRITE(ErrorOut,
     * *) ' CHASTA: MODE ',MODE,' not supported !'
         STOP
      ENDIF

      RETURN
      END
c
c===pohist=============================================================*
c

CDECK  ID>, PHO_PHIST
      SUBROUTINE PHO_PHIST(IMODE,WEIGHT)


      IMPLICIT DOUBLE PRECISION (A-H,O-X,Z)
      SAVE

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI


      ILAB = 0
      IF (IMODE.EQ.10) THEN
         IMODE = 1
         ILAB  = 1
      ENDIF
      IF (ABS(IMODE).LT.1000) THEN
c PHOJET-statistics
C        CALL POHISX(IMODE,WEIGHT)
         IF (IMODE.EQ.-1) THEN
            MODE = 1
            XSTOT(1,1,1) = WEIGHT
         ENDIF
         IF (IMODE.EQ. 1) MODE = 2
         IF (IMODE.EQ.-2) MODE = 3
         IF (MODE.EQ.2) CALL DT_SWPPHO(ILAB)
C        IF (MODE.EQ.3) WRITE(6,*)
C    &      ' Sigma = ',XSPRO(1,1,1),' mb   used for normalization'
         CALL DT_HISTOG(MODE)
         CALL DT_USRHIS(MODE)
      ELSE
c DTUNUC-statistics
         MODE = IMODE/1000
C        IF (MODE.EQ.3) WRITE(6,*)
C    &      ' Sigma = ',XSPRO(1,1,1),' mb   used for normalization'
         CALL DT_HISTOG(MODE)
         CALL DT_USRHIS(MODE)
      ENDIF

      RETURN
      END
c
c===swppho=============================================================*
c
CDECK  ID>, DT_SWPPHO
      SUBROUTINE DT_SWPPHO(ILAB)

      IMPLICIT DOUBLE PRECISION (A-H,O-X,Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,TINY14=1.0D-14)

      LOGICAL LSTART

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC


c*PHOJET105a
C     PARAMETER (NMXHEP=2000)
C     COMMON/HEPEVS/NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
C    &JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),VHEP(4,NMXHEP)
C     COMMON /GLOCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)
C     COMMON /PLASAV/ PLAB
c*PHOJET110


C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

c*
      DATA ICOUNT/0/

      DATA LSTART /.TRUE./

C     IF ((IFRAME.EQ.1).AND.(ILAB.EQ.0).AND.LSTART) THEN
      IF ((IFRAME.EQ.1).AND.LSTART) THEN
         UMO  = ECM
         ELA  = ZERO
         PLA  = ZERO
         IDP  = IDT_ICIHAD(IFPAP(1))
         IDT  = IDT_ICIHAD(IFPAP(2))
         VIRT = PVIRT(1)
         CALL DT_LTINI(IDP,IDT,ELA,PLA,UMO,0)
         PLAB = PLA
         LSTART = .FALSE.
      ENDIF

      NHKK   = 0
      ICOUNT = ICOUNT+1
C     NEVHKK = NEVHEP
      NEVHKK = ICOUNT
      IF (MOD(ICOUNT,500).EQ.0) WRITE(ErrorOut,
     * *)' SWPPHO: event # ',ICOUNT
      DO 1 I=3,NHEP
         IF (ISTHEP(I).EQ.1) THEN
            NHKK = NHKK+1
            ISTHKK(NHKK) = 1
            IDHKK(NHKK)  = IDHEP(I)
            JMOHKK(1,NHKK) = 0
            JMOHKK(2,NHKK) = 0
            JDAHKK(1,NHKK) = 0
            JDAHKK(2,NHKK) = 0
            DO 2 K=1,4
               PHKK(K,NHKK) = PHEP(K,I)
               VHKK(K,NHKK) = ZERO
               WHKK(K,NHKK) = ZERO
    2       CONTINUE
            IF ((IFRAME.EQ.1).AND.(ILAB.EQ.0))
     &         CALL DT_LTNUC(PHEP(3,I),PHEP(4,I),
     &                    PHKK(3,NHKK),PHKK(4,NHKK),-3)
            PHKK(5,NHKK) = PHEP(5,I)
            IDRES(NHKK)  = 0
            IDXRES(NHKK) = 0
            NOBAM(NHKK)  = 0
            IDBAM(NHKK)  = IDT_ICIHAD(IDHEP(I))
            IDCH(NHKK)   = 0
         ENDIF
    1 CONTINUE

      RETURN
      END
c
c===histog=============================================================*
c
CDECK  ID>, DT_HISTOG
      SUBROUTINE DT_HISTOG(MODE)

c***********************************************************************
c This version dated 25.03.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      LOGICAL LFSP,LRNL

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c event flag used for histograms
      COMMON /DTNORM/ ICEVT,IEVHKK

c flags for activated histograms
      COMMON /DTHIS3/ IHISPP(50),IHISXS(50),IXSTBL


      IEVHKK = NEVHKK
      GOTO (1,2,3) MODE

c------------------------------------------------------------------
c initialization
    1 CONTINUE
      ICEVT = 0
      IF (IHISPP(1).EQ.1) CALL DT_HISTAT(IDUM,1)
      IF (IHISPP(2).EQ.1) CALL DT_HIMULT(1)

      RETURN
c------------------------------------------------------------------
c filling of histogram with event-record
    2 CONTINUE
      ICEVT = ICEVT+1

      DO 20 I=1,NHKK
         CALL DT_SWPFSP(I,LFSP,LRNL)
         IF (LFSP) THEN
            IF (IHISPP(1).EQ.1) CALL DT_HISTAT(I,2)
            IF (IHISPP(2).EQ.1) CALL DT_HIMULT(2)
         ENDIF
         IF (IHISPP(1).EQ.1) CALL DT_HISTAT(I,5)
   20 CONTINUE
      IF (IHISPP(1).EQ.1) CALL DT_HISTAT(IDUM,4)

      RETURN
c------------------------------------------------------------------
c output
    3 CONTINUE
      IF (IHISPP(1).EQ.1) CALL DT_HISTAT(IDUM,3)
      IF (IHISPP(2).EQ.1) CALL DT_HIMULT(3)

      RETURN
      END
c
c===swpfsp=============================================================*
c
CDECK  ID>, DT_SWPFSP
      SUBROUTINE DT_SWPFSP(IDX,LFSP,LRNL)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,TINY14=1.0D-14)
      PARAMETER (TWOPI=6.283185307179586476925286766559D+00,
     &           PI   =TWOPI/TWO,
     &           BOG  =TWOPI/360.0D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c (original name: PAREVT)
      LOGICAL LDIFFR, LINCTV, LEVPRT, LHEAVY, LDEEXG, LGDHPR, LPREEX,
     &        LHLFIX, LPRFIX, LPARWV, LPOWER, LSNGCH, LLVMOD, LSCHDF
      PARAMETER ( NALLWP = 39   )
      COMMON /FKPARE/ DPOWER, FSPRD0, FSHPFN, RN1GSC, RN2GSC,
     &                LDIFFR (NALLWP),LPOWER, LINCTV, LEVPRT, LHEAVY,
     &                LDEEXG, LGDHPR, LPREEX, LHLFIX, LPRFIX, LPARWV,
     &                ILVMOD, JLVMOD, LLVMOD, LSNGCH, LSCHDF

c temporary storage for one final state particle
      LOGICAL LFRAG,LGREY,LBLACK
      COMMON /DTFSPA/ AMASS,PE,EECMS,PX,PY,PZ,PZCMS,PT,PTOT,ET,EKIN,
     &                SINTHE,COSTHE,THETA,THECMS,
     &                BETA,YY,YYCMS,ETA,ETACMS,XLAB,XF,
     &                IST,IDPDG,IDBJT,IBARY,ICHAR,MULDEF,
     &                LFRAG,LGREY,LBLACK


      LOGICAL LFSP,LRNL

      LFSP = .FALSE.
      LRNL = .FALSE.
      ISTRNL = 1000
      MULDEF = 1
      IF (LEVPRT) ISTRNL = 1001

      IF (ABS(ISTHKK(IDX)).EQ.1) THEN
         IST    = ISTHKK(IDX)
         IDPDG  = IDHKK(IDX)
         LFRAG  = .FALSE.
         IF (IDHKK(IDX).LT.80000) THEN
            IDBJT  = IDBAM(IDX)
            IBARY  = IIBAR(IDBJT)
            ICHAR  = IICH(IDBJT)
            AMASS  = AAM(IDBJT)
         ELSEIF (IDHKK(IDX).EQ.80000) THEN
            IDBJT  = 0
            IBARY  = IDRES(IDX)
            ICHAR  = IDXRES(IDX)
            AMASS  = PHKK(5,IDX)
            INUT   = IBARY-ICHAR
            IF ((ICHAR.EQ.1).AND.(INUT.EQ.1)) IDBJT = 116
            IF ((ICHAR.EQ.1).AND.(INUT.EQ.2)) IDBJT = 117
            IF ((ICHAR.EQ.2).AND.(INUT.EQ.1)) IDBJT = 118
            IF ((ICHAR.EQ.2).AND.(INUT.EQ.2)) IDBJT = 119
            IF (IDBJT.EQ.0) LFRAG = .TRUE.
         ELSE
            GOTO 9999
         ENDIF
         PE     = PHKK(4,IDX)
         PX     = PHKK(1,IDX)
         PY     = PHKK(2,IDX)
         PZ     = PHKK(3,IDX)
         PT2    = PX**2+PY**2
         PT     = SQRT(PT2)
         PTOT   = SQRT(PT2+PZ**2)
         SINTHE = PT/MAX(PTOT,TINY14)
         COSTHE = PZ/MAX(PTOT,TINY14)
         IF (COSTHE.GT.ONE) THEN
            THETA = ZERO
         ELSEIF (COSTHE.LT.-ONE) THEN
            THETA = TWOPI/2.0D0
         ELSE
            THETA = ACOS(COSTHE)
         ENDIF
         EKIN   = PE-AMASS
c*sr 15.4.96 new E_t-definition
         IF (IBARY.GT.0) THEN
            ET = EKIN*SINTHE
         ELSEIF (IBARY.LT.0) THEN
            ET = (EKIN+TWO*AMASS)*SINTHE
         ELSE
            ET = PE*SINTHE
         ENDIF
c*
         XLAB   = PZ/MAX(PPROJ,TINY14)
C        XLAB   = PE/MAX(EPROJ,TINY14)
         BETA   = SQRT(ABS( (ONE-AMASS/MAX(PE,TINY14))
     &                     *(ONE+AMASS/MAX(PE,TINY14)) ))
         PPLUS  = PE+PZ
         PMINUS = PE-PZ
         IF (PMINUS.GT.TINY14) THEN
            YY = 0.5D0*LOG(ABS(PPLUS/PMINUS))
         ELSE
            YY = 100.0D0
         ENDIF
         IF ((THETA.GT.TINY14).AND.((PI-THETA).GT.TINY14)) THEN
            ETA = -LOG(TAN(THETA/TWO))
         ELSE
            ETA = 100.0D0
         ENDIF
         IF (IFRAME.EQ.1) THEN
            CALL DT_LTNUC(PZ,PE,PZCMS,EECMS,3)
            PPLUS  = EECMS+PZCMS
            PMINUS = EECMS-PZCMS
            IF ((PPLUS*PMINUS).GT.TINY14) THEN
               YYCMS = 0.5D0*LOG(ABS(PPLUS/PMINUS))
            ELSE
               YYCMS = 100.0D0
            ENDIF
            PTOTCM = SQRT(PT2+PZCMS**2)
            COSTH = PZCMS/MAX(PTOTCM,TINY14)
            IF (COSTH.GT.ONE) THEN
               THECMS = ZERO
            ELSEIF (COSTH.LT.-ONE) THEN
               THECMS = TWOPI/2.0D0
            ELSE
               THECMS = ACOS(COSTH)
            ENDIF
            IF ((THECMS.GT.TINY14).AND.((PI-THECMS).GT.TINY14)) THEN
               ETACMS = -LOG(TAN(THECMS/TWO))
            ELSE
               ETACMS = 100.0D0
            ENDIF
            XF = PZCMS/MAX(PPCM,TINY14)
            THECMS = THECMS/BOG
         ELSE
            PZCMS  = PZ
            EECMS  = PE
            YYCMS  = YY
            ETACMS = ETA
            XF     = XLAB
            THECMS = THETA/BOG
         ENDIF
         THETA  = THETA/BOG

c set flag for "grey/black"
         LGREY  = .FALSE.
         LBLACK = .FALSE.
         EK     = EKIN
         IF (IDHKK(IDX).EQ.80000) EK = EKIN/DBLE(IBARY)
         IF (MULDEF.EQ.1) THEN
c  EMU01-Def.
            IF ( ( (IDBJT.EQ. 1).AND.(EK.GT. 26.0D-3).AND.
     &                              (EK.LE.375.0D-3)      ).OR.
     &           ( (IDBJT.EQ.13).AND.(EK.GT. 12.0D-3).AND.
     &                              (EK.LE. 56.0D-3)      ).OR.
     &           ( (IDBJT.EQ.14).AND.(EK.GT. 12.0D-3).AND.
     &                              (EK.LE. 56.0D-3)      ).OR.
     &           ( (IDBJT.EQ.15).AND.(EK.GT. 20.0D-3).AND.
     &                              (EK.LE.198.0D-3)      ).OR.
     &           ( (IDBJT.EQ.16).AND.(EK.GT. 20.0D-3).AND.
     &                              (EK.LE.198.0D-3)      ).OR.
     &           ( (IDBJT.NE. 1).AND.(IDBJT.NE.13).AND.
     &             (IDBJT.NE.14).AND.(IDBJT.NE.15).AND.
     &             (IDBJT.NE.16).AND.
     &             (BETA.GT.0.23D0).AND.(BETA.LE.0.70D0)    ) )
     &         LGREY = .TRUE.
            IF ( ( (IDBJT.EQ. 1).AND.(EK.LE. 26.0D-3) ).OR.
     &           ( (IDBJT.EQ.13).AND.(EK.LE. 12.0D-3) ).OR.
     &           ( (IDBJT.EQ.14).AND.(EK.LE. 12.0D-3) ).OR.
     &           ( (IDBJT.EQ.15).AND.(EK.LE. 20.0D-3) ).OR.
     &           ( (IDBJT.EQ.16).AND.(EK.LE. 20.0D-3) ).OR.
     &           ( (IDBJT.NE. 1).AND.(IDBJT.NE.13).AND.
     &             (IDBJT.NE.14).AND.(IDBJT.NE.15).AND.
     &             (IDBJT.NE.16).AND.(BETA.LE.0.23D0)  ) )
     &         LBLACK = .TRUE.
         ELSE
c  common Def.
            IF ((BETA.GT.0.23D0).AND.(BETA.LE.0.70D0)) LGREY=.TRUE.
            IF (BETA.LE.0.23D0) LBLACK=.TRUE.
         ENDIF
         LFSP = .TRUE.
      ELSEIF (ABS(ISTHKK(IDX)).EQ.ISTRNL) THEN
         IST    = ISTHKK(IDX)
         IDPDG  = IDHKK(IDX)
         LFRAG  = .TRUE.
         IDBJT  = 0
         IBARY  = IDRES(IDX)
         ICHAR  = IDXRES(IDX)
         AMASS  = PHKK(5,IDX)
         PE     = PHKK(4,IDX)
         PX     = PHKK(1,IDX)
         PY     = PHKK(2,IDX)
         PZ     = PHKK(3,IDX)
         PT2    = PX**2+PY**2
         PT     = SQRT(PT2)
         PTOT   = SQRT(PT2+PZ**2)
         SINTHE = PT/MAX(PTOT,TINY14)
         COSTHE = PZ/MAX(PTOT,TINY14)
         IF (COSTHE.GT.ONE) THEN
            THETA = ZERO
         ELSEIF (COSTHE.LT.-ONE) THEN
            THETA = TWOPI/2.0D0
         ELSE
            THETA  = ACOS(COSTHE)
         ENDIF
         EKIN   = PE-AMASS
c*sr 15.4.96 new E_t-definition
C        ET     = PE*SINTHE
         ET     = EKIN*SINTHE
c*
         IF ((THETA.GT.TINY14).AND.((PI-THETA).GT.TINY14)) THEN
            ETA = -LOG(TAN(THETA/TWO))
         ELSE
            ETA = 100.0D0
         ENDIF
         THETA  = THETA/BOG
         LRNL   = .TRUE.
      ENDIF

 9999 CONTINUE
      RETURN
      END
c
c===himult=============================================================*
c
CDECK  ID>, DT_HIMULT
      SUBROUTINE DT_HIMULT(MODE)

c***********************************************************************
c Tables of average energies/multiplicities.                           *
c This version dated 30.08.2000 is written by S. Roesler               *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,TINY14=1.0D-14)

      PARAMETER (SWMEXP=1.7D0)

      CHARACTER*8 ANAMEH(4)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c temporary storage for one final state particle
      LOGICAL LFRAG,LGREY,LBLACK
      COMMON /DTFSPA/ AMASS,PE,EECMS,PX,PY,PZ,PZCMS,PT,PTOT,ET,EKIN,
     &                SINTHE,COSTHE,THETA,THECMS,
     &                BETA,YY,YYCMS,ETA,ETACMS,XLAB,XF,
     &                IST,IDPDG,IDBJT,IBARY,ICHAR,MULDEF,
     &                LFRAG,LGREY,LBLACK

c event flag used for histograms
      COMMON /DTNORM/ ICEVT,IEVHKK

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ


      PARAMETER (NOPART=210)
      DIMENSION AVMULT(4,NOPART),AVE(4,NOPART),AVSWM(4,NOPART)
      DATA ANAMEH /'DEUTERON','3-H     ','3-HE    ','4-HE    '/

      GOTO (1,2,3) MODE

c------------------------------------------------------------------
c initialization
    1 CONTINUE
      DO 10 I=1,NOPART
         DO 11 J=1,4
            AVMULT(J,I) = ZERO
            AVE(J,I)    = ZERO
            AVSWM(J,I)  = ZERO
   11    CONTINUE
   10 CONTINUE

      RETURN

c------------------------------------------------------------------
c filling of histogram with event-record
    2 CONTINUE
      IF (PE.LT.0.0D0) THEN
         WRITE(ErrorOut,*) ' HIMULT:  PE < 0 ! ',PE
         RETURN
      ENDIF
      IF (.NOT.LFRAG) THEN
         IVEL = 2
         IF (LGREY)  IVEL = 3
         IF (LBLACK) IVEL = 4
         AVE(1,IDBJT)       = AVE(1,IDBJT)   +PE
         AVE(IVEL,IDBJT)    = AVE(IVEL,IDBJT)+PE
         AVSWM(1,IDBJT)     = AVSWM(1,IDBJT)   +PE**SWMEXP
         AVSWM(IVEL,IDBJT)  = AVSWM(IVEL,IDBJT)+PE**SWMEXP
         AVMULT(1,IDBJT)    = AVMULT(1,IDBJT)   +ONE
         AVMULT(IVEL,IDBJT) = AVMULT(IVEL,IDBJT)+ONE
         IF (IDBJT.LT.116) THEN
c   total energy, multiplicity
            AVE(1,30)       = AVE(1,30)   +PE
            AVE(IVEL,30)    = AVE(IVEL,30)+PE
            AVSWM(1,30)     = AVSWM(1,30)+PE**SWMEXP
            AVSWM(IVEL,30)  = AVSWM(IVEL,30)+PE**SWMEXP
            AVMULT(1,30)    = AVMULT(1,30)   +ONE
            AVMULT(IVEL,30) = AVMULT(IVEL,30)+ONE
c   charged energy, multiplicity
            IF (ICHAR.LT.0) THEN
               AVE(1,26)       = AVE(1,26)   +PE
               AVE(IVEL,26)    = AVE(IVEL,26)+PE
               AVSWM(1,26)     = AVSWM(1,26)   +PE**SWMEXP
               AVSWM(IVEL,26)  = AVSWM(IVEL,26)+PE**SWMEXP
               AVMULT(1,26)    = AVMULT(1,26)   +ONE
               AVMULT(IVEL,26) = AVMULT(IVEL,26)+ONE
            ENDIF
            IF (ICHAR.NE.0) THEN
               AVE(1,27)       = AVE(1,27)   +PE
               AVE(IVEL,27)    = AVE(IVEL,27)+PE
               AVSWM(1,27)     = AVSWM(1,27)   +PE**SWMEXP
               AVSWM(IVEL,27)  = AVSWM(IVEL,27)+PE**SWMEXP
               AVMULT(1,27)    = AVMULT(1,27)   +ONE
               AVMULT(IVEL,27) = AVMULT(IVEL,27)+ONE
            ENDIF
         ENDIF
      ENDIF

      RETURN

c------------------------------------------------------------------
c output
    3 CONTINUE
      WRITE(ErrorOut,3000)
 3000 FORMAT(/,1X,'HIMULT:',21X,'PARTICLE - STATISTICS',/,
     &       29X,'---------------------',/)
      IF (MULDEF.EQ.1) THEN
         WRITE(ErrorOut,'(1X,A,/)') 'fast/grey/black: EMU-def.'
      ELSE
         BETGRE = 0.7D0
         BETBLC = 0.23D0
         WRITE(ErrorOut,3002) BETGRE,BETGRE,BETBLC,BETBLC
 3002    FORMAT(1X,'FAST:  BETA > ',F4.2,'    GREY:  ',F4.2,' > BETA > '
     &          ,F4.2,'    BLACK:  BETA < ',F4.2,/)
      ENDIF
      WRITE(ErrorOut,3003) SWMEXP
 3003 FORMAT(1X,'PARTICLE    |',12X,'AVERAGE MULTIPLICITY',/,
     &      13X,'|     TOTAL         FAST',
     &      '       GREY     BLACK      K      F(',F3.1,')',/,1X,
     &      '------------+--------------',
     &      '-------------------------------------------------')
      DO 30 I=1,NOPART
         DO 31 J=1,4
            AVMULT(J,I) = AVMULT(J,I)/DBLE(MAX(ICEVT,1))
            AVE(J,I)    = AVE(J,I)/DBLE(MAX(ICEVT,1))/EPROJ
            AVSWM(J,I)  = AVSWM(J,I)/DBLE(MAX(ICEVT,1))/EPROJ**SWMEXP
   31    CONTINUE
         IF (I.LE.115) THEN
            WRITE(ErrorOut,3004) ANAME(I),I,
     &                       AVMULT(1,I),AVMULT(2,I),
     &                       AVMULT(3,I),AVMULT(4,I),
     &                       AVE(1,I),AVSWM(1,I)
         ELSEIF (I.LE.119) THEN
            WRITE(ErrorOut,3004) ANAMEH(I-115),I,
     &                       AVMULT(1,I),AVMULT(2,I),
     &                       AVMULT(3,I),AVMULT(4,I),
     &                       AVE(1,I),AVSWM(1,I)
         ENDIF
 3004    FORMAT(1X,A8,I4,'| ',2F13.6,2F9.5,2F9.5)
   30 CONTINUE
c*temporary
C     WRITE(LOUT,'(A,F7.3)') ' number of charged heavy particles: ',
C    &               AVMULT(3,27)+AVMULT(4,27)
c*

      RETURN
      END
c
c===histat=============================================================*
c
CDECK  ID>, DT_HISTAT
      SUBROUTINE DT_HISTAT(IDX,MODE)

c***********************************************************************
c This version dated 26.02.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,TINY14=1.0D-14)
      PARAMETER (NDIM=199)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c statistics: residual nuclei
      COMMON /DTSTA2/ EXCDPM(4),EXCEVA(2),
     &                NINCGE,NINCCO(2,3),NINCHR(2,2),NINCWO(2),
     &                NINCST(2,4),NINCEV(2),
     &                NRESTO(2),NRESPR(2),NRESNU(2),NRESBA(2),
     &                NRESPB(2),NRESCH(2),NRESEV(4),
     &                NEVA(2,6),NEVAGA(2),NEVAHT(2),NEVAHY(2,2,240),
     &                NEVAFI(2,2)

c parameter for intranuclear cascade
      LOGICAL LPAULI
      COMMON /DTFOTI/ TAUFOR,KTAUGE,ITAUVE,INCMOD,LPAULI

c (original name: PAREVT)
      LOGICAL LDIFFR, LINCTV, LEVPRT, LHEAVY, LDEEXG, LGDHPR, LPREEX,
     &        LHLFIX, LPRFIX, LPARWV, LPOWER, LSNGCH, LLVMOD, LSCHDF
      PARAMETER ( NALLWP = 39   )
      COMMON /FKPARE/ DPOWER, FSPRD0, FSHPFN, RN1GSC, RN2GSC,
     &                LDIFFR (NALLWP),LPOWER, LINCTV, LEVPRT, LHEAVY,
     &                LDEEXG, LGDHPR, LPREEX, LHLFIX, LPRFIX, LPARWV,
     &                ILVMOD, JLVMOD, LLVMOD, LSNGCH, LSCHDF

c (original name: FRBKCM)
      PARAMETER ( MXFFBK =     6 )
      PARAMETER ( MXZFBK =     9 )
      PARAMETER ( MXNFBK =    10 )
      PARAMETER ( MXAFBK =    16 )
      PARAMETER ( NXZFBK = MXZFBK + MXFFBK / 3 )
      PARAMETER ( NXNFBK = MXNFBK + MXFFBK / 3 )
      PARAMETER ( NXAFBK = MXAFBK + 1 )
      PARAMETER ( MXPSST =   300 )
      PARAMETER ( MXPSFB = 41000 )
      LOGICAL LFRMBK, LNCMSS
      COMMON /FKFRBK/  AMUFBK, EEXFBK (MXPSST), AMFRBK (MXPSST),
     &          EXFRBK (MXPSFB), SDMFBK (MXPSFB), COUFBK (MXPSFB),
     &          EXMXFB, R0FRBK, R0CFBK, C1CFBK, C2CFBK,
     &          IFRBKN (MXPSST), IFRBKZ (MXPSST),
     &          IFBKSP (MXPSST), IFBKPR (MXPSST), IFBKST (MXPSST),
     &          IPSIND (0:MXNFBK,0:MXZFBK,2), JPSIND (0:MXAFBK),
     &          IFBIND (0:NXNFBK,0:NXZFBK,2), JFBIND (0:NXAFBK),
     &          IFBCHA (5,MXPSFB), IPOSST, IPOSFB, IFBSTF,
     &          IFBFRB, NBUFBK, LFRMBK, LNCMSS

c (original name: INPFLG)
      COMMON /FKINPF/ IANG,IFISS,IB0,IGEOM,ISTRAG,KEYDK

c temporary storage for one final state particle
      LOGICAL LFRAG,LGREY,LBLACK
      COMMON /DTFSPA/ AMASS,PE,EECMS,PX,PY,PZ,PZCMS,PT,PTOT,ET,EKIN,
     &                SINTHE,COSTHE,THETA,THECMS,
     &                BETA,YY,YYCMS,ETA,ETACMS,XLAB,XF,
     &                IST,IDPDG,IDBJT,IBARY,ICHAR,MULDEF,
     &                LFRAG,LGREY,LBLACK

c event flag used for histograms
      COMMON /DTNORM/ ICEVT,IEVHKK

c statistics: double-Pomeron exchange
      COMMON /DTFLG2/ INTFLG,IPOPO


      DIMENSION EMUSAM(NCOMPX)

      CHARACTER*13 CMSG(3)
      DATA CMSG /'NOT REQUESTED','NOT REQUESTED','NOT REQUESTED'/

      GOTO (1,2,3,4,5) MODE

c------------------------------------------------------------------
c initialization
    1 CONTINUE
c  emulsion treatment
      IF (NCOMPO.GT.0) THEN
         DO 10 I=1,NCOMPX
            EMUSAM(I) = ZERO
   10    CONTINUE
      ENDIF
c common /DTSTA2/, statistics on i.n.c., residual nuclei, evap.
      NINCGE = 0
      DO 11 I=1,2
         EXCDPM(I)   = ZERO
         EXCDPM(I+2) = ZERO
         EXCEVA(I)   = ZERO
         NINCWO(I)   = 0
         NINCEV(I)   = 0
         NRESTO(I)   = 0
         NRESPR(I)   = 0
         NRESNU(I)   = 0
         NRESBA(I)   = 0
         NRESPB(I)   = 0
         NRESCH(I)   = 0
         NRESEV(I)   = 0
         NRESEV(I+2) = 0
         NEVAGA(I)   = 0
         NEVAHT(I)   = 0
         NEVAFI(1,I) = 0
         NEVAFI(2,I) = 0
         DO 12 J=1,6
            IF (J.LE.2) NINCHR(I,J) = 0
            IF (J.LE.3) NINCCO(I,J) = 0
            IF (J.LE.4) NINCST(I,J) = 0
            NEVA(I,J) = 0
   12    CONTINUE
         DO 13 J=1,210
            NEVAHY(1,I,J) = 0
            NEVAHY(2,I,J) = 0
   13    CONTINUE
   11 CONTINUE
      MAXGEN = 0
c*dble Po statistics.
      KPOPO = 0

      RETURN
c------------------------------------------------------------------
c filling of histogram with event-record
    2 CONTINUE
      IF (IST.EQ.-1) THEN
         IF (.NOT.LFRAG) THEN
            IF (IDPDG.EQ.2212) THEN
               NEVA(NOBAM(IDX),1) = NEVA(NOBAM(IDX),1)+1
            ELSEIF (IDPDG.EQ.2112) THEN
               NEVA(NOBAM(IDX),2) = NEVA(NOBAM(IDX),2)+1
            ELSEIF (IDPDG.EQ.22) THEN
               NEVAGA(NOBAM(IDX)) = NEVAGA(NOBAM(IDX))+1
            ELSEIF (IDPDG.EQ.80000) THEN
               IF (IDBJT.EQ.116) THEN
                  NEVA(NOBAM(IDX),3) = NEVA(NOBAM(IDX),3)+1
               ELSEIF (IDBJT.EQ.117) THEN
                  NEVA(NOBAM(IDX),4) = NEVA(NOBAM(IDX),4)+1
               ELSEIF (IDBJT.EQ.118) THEN
                  NEVA(NOBAM(IDX),5) = NEVA(NOBAM(IDX),5)+1
               ELSEIF (IDBJT.EQ.119) THEN
                  NEVA(NOBAM(IDX),6) = NEVA(NOBAM(IDX),6)+1
               ENDIF
            ENDIF
         ELSE
c   heavy fragments (here: fission products only)
            NEVAHY(NOBAM(IDX),1,IBARY) = NEVAHY(NOBAM(IDX),1,IBARY)+1
            NEVAHY(NOBAM(IDX),2,ICHAR) = NEVAHY(NOBAM(IDX),2,ICHAR)+1
            NEVAHT(NOBAM(IDX)) = NEVAHT(NOBAM(IDX))+1
         ENDIF
      ELSEIF ((IST.EQ.1).AND.(.NOT.LFRAG)) THEN
         IF (IDCH(IDX).GT.MAXGEN) MAXGEN = IDCH(IDX)
      ENDIF

      RETURN
c------------------------------------------------------------------
c output
    3 CONTINUE

c*dble Po statistics.
C     WRITE(LOUT,'(1X,A,2I7,2E12.4)')
C    &   '# evts. / # dble-Po. evts / s_in / s_popo :',
C    & ICEVT,KPOPO,XSPRO(1,1,1),XSPRO(1,1,1)*DBLE(KPOPO)/DBLE(ICEVT)

c  emulsion treatment
      IF (NCOMPO.GT.0) THEN
         WRITE(ErrorOut,3000)
 3000    FORMAT(/,1X,'HISTAT:',14X,'STATISTICS - TARGET EMULSION',/,
     &          22X,'----------------------------',/,/,19X,
     &          'MASS    CHARGE          FRACTION',/,39X,
     &          'INPUT     TREATED',/)
         DO 30 I=1,NCOMPO
            WRITE(ErrorOut,
     * 3013) I,IEMUMA(I),IEMUCH(I),EMUFRA(I),
     &                       EMUSAM(I)/DBLE(ICEVT)
 3013       FORMAT(12X,I2,1X,2I8,6X,F7.3,5X,F7.3)
   30    CONTINUE
      ENDIF

c  i.n.c. statistics: output
      WRITE(ErrorOut,3001) ICEVT,NRESEV(2),IRINC
 3001 FORMAT(/,1X,'HISTAT:',14X,'STATISTICS - INTRANUCLEAR CASCADE',/,
     &       22X,'---------------------------------',/,/,1X,
     &       'NO. OF EVENTS FOR NORMALIZATION: (ACCEPTED FINAL EVENTS,',
     &       ' EVT)',4X,I6,/,34X,'(EVENTS BEFORE EVAP.-STEP, EVT1)',I6,
     &       /,1X,'NO. OF REJECTED EVENTS DUE TO INTRANUCLEAR',
     &       ' CASCADE',15X,I6,/)
      ICEV  = MAX(ICEVT,1)
      ICEV1 = ICEV
      IF (LEVPRT) ICEV1 = MAX(NRESEV(2),1)
      WRITE(ErrorOut,3002)
     &     (DBLE(NINCWO(I))/DBLE(ICEV),I=1,2),
     &     ((DBLE(NINCST(I,J))/DBLE(ICEV),I=1,2),J=1,4),
     &     KTAUGE,DBLE(NINCGE)/DBLE(ICEV),
     &    (DBLE(NINCCO(I,1)+NINCCO(I,2)+NINCCO(I,3))/DBLE(ICEV1),I=1,2),
     &     (DBLE(NINCCO(I,2))/DBLE(ICEV1),I=1,2),
     &     (DBLE(NINCCO(I,3))/DBLE(ICEV1),I=1,2),
     &     (DBLE(NINCCO(I,1))/DBLE(ICEV1),I=1,2)
 3002 FORMAT(1X,'NO. OF WOUNDED NUCL. IN PROJ./ TARGET (MEAN PER EVT)',
     &       5X,F6.2,' /',F6.2,/,1X,'NO. OF PARTICLES UNABLE TO ESCAPE',
     &       ' PROJ./ TARGET (MEAN PER EVT)',/,8X,'BARYONS:  POS. ',
     &       F7.3,' /',F7.3,'   NEG. ',F7.3,' /',F7.3,/,8X,
     &       'MESONS:   POS. ',F7.3,' /',F7.3,'   NEG. ',F7.3,' /',F7.3,
     &       /,1X,'MAXIMUM NO. OF GENERATIONS TREATED (MAXIMUM ALLOWED:'
     &       ,I4,')',/,43X,'(MEAN PER EVT)',5X,F6.2,/,1X,'NO. OF SEC.',
     &       ' INTERACTIONS IN PROJ./ TARGET (MEAN PER EVT1)',
     &       F7.3,' /',F7.3,/,8X,'OUT OF WHICH BY INELASTIC',
     &       ' INTERACTIONS',12X,F7.3,' /',F7.3,/,21X,'BY ELASTIC ',
     &       'INTERACTIONS',14X,F7.3,' /',F7.3,/,21X,'BY ABSORPTION ',
     &       '(AP, K-, PI- ONLY)     ',F7.3,' /',F7.3,/)
      WRITE(ErrorOut,3003) NRESEV(2),NRESEV(4),IREXCI,
     &                 IREXCI(1)+IREXCI(2)+IREXCI(3)
 3003 FORMAT(/,1X,'HISTAT:',14X,'STATISTICS - RESIDUAL NUCLEI, ',
     &       'EVAPORATION',/,22X,'-----------------------------',
     &       '------------',/,/,1X,'NO. OF EVENTS FOR NORMAL.: ',
     &       '(EVENTS HANDLED BY FICONF, EVT)',7X,I6,/,28X,'(EVENTS',
     &       ' PASSING THE EVAP.-STEP, EVT1) ',I6,/,1X,'NO. OF',
     &       ' REJECTED EVENTS     (',I4,',',I4,',',I4,')',22X,I6,/)

      WRITE(ErrorOut,3004)
 3004 FORMAT(/,22X,'1) BEFORE EVAPORATION-STEP:',/)
      ICEV  = MAX(NRESEV(2),1)
      WRITE(ErrorOut,3005)
     &     (DBLE(NRESTO(I))/DBLE(ICEV),I=1,2),
     &     (DBLE(NRESPR(I))/DBLE(ICEV),I=1,2),
     &     (DBLE(NRESNU(I))/DBLE(ICEV),I=1,2),
     &     (DBLE(NRESBA(I))/DBLE(ICEV),I=1,2),
     &     (DBLE(NRESPB(I))/DBLE(ICEV),I=1,2),
     &     (DBLE(NRESCH(I))/DBLE(ICEV),I=1,2),
     &     (EXCDPM(I)/DBLE(ICEV),I=1,2),
     &     (EXCDPM(I+2)/DBLE(ICEV),I=1,2)
 3005    FORMAT(1X,'RESIDUAL NUCLEI:  (MEAN VALUES PER EVT)',12X,
     &       'PROJ. / TARGET',/,/,8X,'TOTAL NUMBER OF PARTICLES',15X,
     &       2F9.3,/,8X,'OUT OF WHICH: PROTONS',19X,2F9.3,/,22X,
     &       'NEUTRONS',18X,2F9.3,/,22X,'BARYONS',19X,2F9.3,/,22X,
     &       'POS. BARYONS',14X,2F9.3,/,8X,'TOTAL CHARGE',28X,2F9.3,/,
     &       /,8X,'EXCITATION ENERGY (BEF. EVAP.-STEP)   ',2E11.3,/,
     &       8X,'EXCITATION ENERGY PER NUCLEON         ',2E11.3,/,/)

c evaporation / fission / fragmentation statistics: output
      ICEV  = MAX(NRESEV(2),1)
      ICEV1 = MAX(NRESEV(4),1)
      NTEVA1 =
     &   NEVA(1,1)+NEVA(1,2)+NEVA(1,3)+NEVA(1,4)+NEVA(1,5)+NEVA(1,6)
      NTEVA2 =
     &   NEVA(2,1)+NEVA(2,2)+NEVA(2,3)+NEVA(2,4)+NEVA(2,5)+NEVA(2,6)
      IF (LEVPRT) THEN
         IF (IFISS.EQ.1) CMSG(1) = 'REQUESTED    '
         IF (LFRMBK)     CMSG(2) = 'REQUESTED    '
         IF (LDEEXG)     CMSG(3) = 'REQUESTED    '
         WRITE(ErrorOut,3006)
     &        CMSG,
     &        DBLE(NTEVA1)/DBLE(ICEV1),DBLE(NTEVA2)/DBLE(ICEV1),
     &        (DBLE(NEVA(I,1))/DBLE(ICEV1),I=1,2),
     &        (DBLE(NEVA(I,2))/DBLE(ICEV1),I=1,2),
     &        (DBLE(NEVA(I,3))/DBLE(ICEV1),I=1,2),
     &        (DBLE(NEVA(I,4))/DBLE(ICEV1),I=1,2),
     &        (DBLE(NEVA(I,5))/DBLE(ICEV1),I=1,2),
     &        (DBLE(NEVA(I,6))/DBLE(ICEV1),I=1,2),
     &        (DBLE(NEVAGA(I))/DBLE(ICEV1),I=1,2),
     &        (DBLE(NEVAHT(I))/DBLE(ICEV1),I=1,2)
 3006    FORMAT(22X,'2) AFTER  EVAPORATION-STEP:',/,/,1X,'FISSION:',
     &       13X,A13,/,1X,'FERMI-BREAK-UP:',6X,A13,/,1X,'GAMMA-',
     &       'DEEXCITATION:',2X,A13,/,/,
     &       1X,'EVAPORATION/DEEXCITATION:  (MEAN VALUES PER EVT1)  ',
     &       'PROJ. / TARGET',/,/,8X,'TOTAL NUMBER OF EVAP. PARTICLES',
     &       9X,2F9.3,/,8X,'OUT OF WHICH: PROTONS',19X,2F9.3,/,22X,
     &       'NEUTRONS',18X,2F9.3,/,22X,'DEUTERONS',17X,2F9.3,/,22X,
     &       '3-H',23X,2F9.3,/,22X,'3-HE',22X,2F9.3,/,22X,'4-HE',22X,
     &       2F9.3,/,8X,'NUCL. DEEXCIT. GAMMAS',19X,2F9.3,/,8X,
     &       'HEAVY FRAGMENTS',25X,2F9.3,/)
         IF (IFISS.EQ.1) THEN
            WRITE(ErrorOut,3007) NEVAFI(1,1),NEVAFI(1,2),
     &                       NEVAFI(2,1),NEVAFI(2,2),
     &             DBLE(NEVAFI(2,1))/DBLE(MAX(NEVAFI(1,1),1))*100.0D0,
     &             DBLE(NEVAFI(2,2))/DBLE(MAX(NEVAFI(1,2),1))*100.0D0
 3007       FORMAT(1X,'FISSION:   TOTAL NUMBER OF EVENTS',14X,2I9,/
     &             12X,'OUT OF WHICH FISSION OCCURED',8X,2I9,/,
     &             50X,'(',F5.2,'%) (',F5.2,'%)',/)
         ENDIF
C        IF ((LFRMBK).OR.(IFISS.EQ.1)) THEN
C           WRITE(LOUT,3008)
C3008       FORMAT(1X,'heavy fragments - statistics:',7X,'charge',
C    &             '       proj.   / target',/)
C           DO 31 I=1,210
C              IF ((NEVAHY(1,2,I).NE.0).OR.(NEVAHY(2,2,I).NE.0)) THEN
C                 WRITE(LOUT,3009) I,
C    &            (DBLE(NEVAHY(K,2,I))*XSPRO(1,1,1)/DBLE(ICEV1),K=1,2)
C3009             FORMAT(38X,I3,3X,2E12.3)
C              ENDIF
C  31       CONTINUE
C           WRITE(LOUT,3010)
C3010       FORMAT(1X,'heavy fragments - statistics:',7X,'mass  ',
C    &             '       proj.   / target',/)
C           DO 32 I=1,210
C              IF ((NEVAHY(1,1,I).NE.0).OR.(NEVAHY(2,1,I).NE.0)) THEN
C                 WRITE(LOUT,3011) I,
C    &            (DBLE(NEVAHY(K,1,I))*XSPRO(1,1,1)/DBLE(ICEV1),K=1,2)
C3011             FORMAT(38X,I3,3X,2E12.3)
C              ENDIF
C  32       CONTINUE
C           WRITE(LOUT,*)
C        ENDIF
      ELSE
         WRITE(ErrorOut,3012)
 3012    FORMAT(22X,'2) AFTER  EVAPORATION-STEP:',/,/,1X,
     &       'EVAPORATION:         NOT REQUESTED',/)
      ENDIF

      RETURN
c------------------------------------------------------------------
c filling of histogram with event-record
    4 CONTINUE
c  emulsion treatment
      IF (NCOMPO.GT.0) THEN
         DO 40 I=1,NCOMPO
            IF (IT.EQ.IEMUMA(I)) THEN
               EMUSAM(I) = EMUSAM(I)+ONE
            ENDIF
   40    CONTINUE
      ENDIF
      NINCGE = NINCGE+MAXGEN
      MAXGEN = 0
c*dble Po statistics.
      IF (IPOPO.EQ.1) KPOPO = KPOPO+1

      RETURN
c------------------------------------------------------------------
c filling of histogram with event-record
    5 CONTINUE
      IF ((ISTHKK(IDX).EQ.15).OR.(ISTHKK(IDX).EQ.16)) THEN
         IB = IIBAR(IDBAM(IDX))
         IC = IICH(IDBAM(IDX))
         J  = ISTHKK(IDX)-14
         IF ( ((ABS(IB).EQ.1).AND.(IC.EQ.1)).OR.(IC.EQ.0) ) THEN
            NINCST(J,1) = NINCST(J,1)+1
         ELSEIF ((ABS(IB).EQ.1).AND.(IC.EQ.-1)) THEN
            NINCST(J,2) = NINCST(J,2)+1
         ELSEIF ((ABS(IB).EQ.0).AND.(IC.EQ. 1)) THEN
            NINCST(J,3) = NINCST(J,3)+1
         ELSEIF ((ABS(IB).EQ.0).AND.(IC.EQ.-1)) THEN
            NINCST(J,4) = NINCST(J,4)+1
         ENDIF
      ELSEIF (ISTHKK(IDX).EQ.17) THEN
         NINCWO(1) = NINCWO(1)+1
      ELSEIF (ISTHKK(IDX).EQ.18) THEN
         NINCWO(2) = NINCWO(2)+1
      ELSEIF (ISTHKK(IDX).EQ.1001) THEN
         IB = IDRES(IDX)
         IC = IDXRES(IDX)
         IF (IC.GT.0) THEN
            NEVAHY(NOBAM(IDX),1,IB) = NEVAHY(NOBAM(IDX),1,IB)+1
            NEVAHY(NOBAM(IDX),2,IC) = NEVAHY(NOBAM(IDX),2,IC)+1
         ENDIF
         NEVAHT(NOBAM(IDX)) = NEVAHT(NOBAM(IDX))+1
      ENDIF

      RETURN
      END
c
c===newhgr=============================================================*
c
CDECK  ID>, DT_NEWHGR
      SUBROUTINE DT_NEWHGR(XLIM1,XLIM2,XLIM3,XLIMB,IBIN,IREFN)

c***********************************************************************
c                                                                      *
c     Histogram initialization.                                        *
c                                                                      *
c     input:  XLIM1/XLIM2  lower/upper edge of histogram-window        *
c             XLIM3        bin size                                    *
c             IBIN    > 0  number of bins in equidistant lin. binning  *
c                     = -1 reset histograms                            *
c                     < -1 |IBIN| number of bins in equidistant log.   *
c                          binning or log. binning in user def. struc. *
c             XLIMB(*)     user defined bin structure                  *
c                                                                      *
c     The bin structure is sensitive to                                *
c             XLIM1, XLIM3, IBIN     if     XLIM3 > 0   (lin.)         *
c             XLIM1, XLIM2, IBIN     if     XLIM3 = 0   (lin. & log.)  *
c             XLIMB, IBIN            if     XLIM3 < 0                  *
c                                                                      *
c                                                                      *
c     output: IREFN        histogram index                             *
c                          (= -1 for inconsistent histogr. request)    *
c                                                                      *
c This subroutine is based on a original version by R. Engel.          *
c This version dated 22.4.95 is written  by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6)

      LOGICAL LSTART

      PARAMETER (ZERO   =  0.0D0,
     &           TINY   =  1.0D-10)

      DIMENSION XLIMB(*)

c histograms

      PARAMETER (NHIS=150, NDIM=250)

      COMMON /DTHIS1/ HIST(7,NHIS,NDIM),DENTRY(2,NHIS),OVERF(NHIS),
     &                UNDERF(NHIS),IBINS(NHIS),ISWI(NHIS),IHISL

c auxiliary common for histograms
      COMMON /DTHIS2/ TMPHIS(3,NHIS,NDIM),TMPUFL(NHIS),TMPOFL(NHIS)


      DATA LSTART /.TRUE./

c reset histogram counter
      IF (LSTART.OR.(IBIN.EQ.-1)) THEN
         IHISL  = 0
         IF (IBIN.EQ.-1) RETURN
         LSTART = .FALSE.
      ENDIF

      IHIS  = IHISL+1
c check for maximum number of allowed histograms
      IF (IHIS.GT.NHIS) THEN
         WRITE(ErrorOut,1003) IHIS,NHIS,IHIS
 1003    FORMAT(1X,'NEWHGR:   WARNING!  NUMBER OF HISTOGRAMS (',
     &          I4,') EXCEEDS ARRAY SIZE (',I4,')',/,21X,
     &          'HISTOGRAM',I3,' SKIPPED!')
         GOTO 9999
      ENDIF

      IREFN = IHIS
      IBINS(IHIS) = ABS(IBIN)
c check requested number of bins
      IF (IBINS(IHIS).GE.NDIM) THEN
         WRITE(ErrorOut,1000) IBIN,NDIM,NDIM
 1000    FORMAT(1X,'NEWHGR:   WARNING!  NUMBER OF BINS (',
     &          I3,') EXCEEDS ARRAY SIZE (',I3,')',/,21X,
     &          'AND WILL BE RESET TO ',I3)
         IBINS(IHIS) = NDIM
      ENDIF
      IF (IBINS(IHIS).EQ.0) THEN
         WRITE(ErrorOut,1001) IBIN,IHIS
 1001    FORMAT(1X,'NEWHGR:   WARNING!  INCONSISTENT NUMBER OF',
     &          ' BINS (',I3,')',/,21X,'HISTOGRAM',I3,' SKIPPED!')
         GOTO 9999
      ENDIF

c initialize arrays
      DO 1 I=1,NDIM
         DO 2 K=1,3
            HIST(K,IHIS,I)   = ZERO
            HIST(K+3,IHIS,I) = ZERO
            TMPHIS(K,IHIS,I) = ZERO
    2    CONTINUE
         HIST(7,IHIS,I)   = ZERO
    1 CONTINUE
      DENTRY(1,IHIS)= ZERO
      DENTRY(2,IHIS)= ZERO
      OVERF(IHIS)   = ZERO
      UNDERF(IHIS)  = ZERO
      TMPUFL(IHIS)  = ZERO
      TMPOFL(IHIS)  = ZERO

c bin str. sensitive to lower edge, bin size, and numb. of bins
      IF (XLIM3.GT.ZERO) THEN
         DO 3 K=1,IBINS(IHIS)+1
            HIST(1,IHIS,K) = XLIM1+DBLE(K-1)*XLIM3
    3    CONTINUE
         ISWI(IHIS) = 1
c bin str. sensitive to lower/upper edge and numb. of bins
      ELSEIF (XLIM3.EQ.ZERO) THEN
c   linear binning
         IF (IBIN.GT.0) THEN
            XLOW = XLIM1
            XHI  = XLIM2
            IF (XLIM2.LE.XLIM1) THEN
               WRITE(ErrorOut,1002) XLIM1,XLIM2
 1002          FORMAT(1X,'NEWHGR:   WARNING!  INCONSISTENT X-RANGE',
     &                /,21X,'(XLIM1,XLIM2 = ',2E11.4,')')
               GOTO 9999
            ENDIF
            ISWI(IHIS) = 1
         ELSEIF (IBIN.LT.-1) THEN
c   logarithmic binning
            IF ((XLIM1.LE.ZERO).OR.(XLIM2.LE.ZERO)) THEN
               WRITE(ErrorOut,1004) XLIM1,XLIM2
 1004          FORMAT(1X,'NEWHGR:   WARNING!  INCONSISTENT LOG. ',
     &                'BINNING',/,21X,'(XLIM1,XLIM2 = ',2E11.4,')')
               GOTO 9999
            ENDIF
            IF (XLIM2.LE.XLIM1) THEN
               WRITE(ErrorOut,1005) XLIM1,XLIM2
 1005          FORMAT(1X,'NEWHGR:   WARNING!  INCONSISTENT X-RANGE',
     &                /,21X,'(XLIM1,XLIM2 = ',2E11.4,')')
               GOTO 9999
            ENDIF
            XLOW = LOG10(XLIM1)
            XHI  = LOG10(XLIM2)
            ISWI(IHIS) = 3
         ENDIF
         DX = ABS(XHI-XLOW)/DBLE(MAX(IBINS(IHIS),1))
         DO 4 K=1,IBINS(IHIS)+1
            HIST(1,IHIS,K) = XLOW+DBLE(K-1)*DX
    4    CONTINUE
      ELSE
c user defined bin structure
         DO 5 K=1,IBINS(IHIS)+1
            IF (IBIN.GT.0) THEN
               HIST(1,IHIS,K) = XLIMB(K)
               ISWI(IHIS) = 2
            ELSEIF (IBIN.LT.-1) THEN
               HIST(1,IHIS,K) = LOG10(XLIMB(K))
               ISWI(IHIS) = 4
            ENDIF
    5    CONTINUE
      ENDIF

c histogram accepted
      IHISL = IHIS

      RETURN

 9999 CONTINUE
      IREFN = -1
      RETURN
      END
c
c===filhgr=============================================================*
c
CDECK  ID>, DT_FILHGR
      SUBROUTINE DT_FILHGR(XI,YI,IHIS,NEVT)

c***********************************************************************
c                                                                      *
c     Scoring for histogram IHIS.                                      *
c                                                                      *
c This subroutine is based on a original version by R. Engel.          *
c This version dated 23.4.95 is written  by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6)

      PARAMETER (ZERO = 0.0D0,
     &           ONE  = 1.0D0,
     &           TINY = 1.0D-10)

c histograms

      PARAMETER (NHIS=150, NDIM=250)

      COMMON /DTHIS1/ HIST(7,NHIS,NDIM),DENTRY(2,NHIS),OVERF(NHIS),
     &                UNDERF(NHIS),IBINS(NHIS),ISWI(NHIS),IHISL

c auxiliary common for histograms
      COMMON /DTHIS2/ TMPHIS(3,NHIS,NDIM),TMPUFL(NHIS),TMPOFL(NHIS)


      DATA NCEVT /1/

      X = XI
      Y = YI

c dump content of temorary arrays into histograms
      IF ((NEVT.NE.NCEVT).OR.(NEVT.LT.0)) THEN
         CALL DT_EVTHIS(IDUM)
         NCEVT = NEVT
      ENDIF

c check histogram index
      IF (IHIS.EQ.-1) RETURN
      IF ((IHIS.LT.1).OR.(IHIS.GT.IHISL)) THEN
C        WRITE(LOUT,1000) IHIS,IHISL
 1000    FORMAT(1X,'FILHGR:   WARNING!  HISTOGRAM INDEX',I4,
     &          ' OUT OF RANGE (1..',I3,')')
         RETURN
      ENDIF

      IF ((ISWI(IHIS).EQ.1).OR.(ISWI(IHIS).EQ.3)) THEN
c bin structure not explicitly given
         IF ((ISWI(IHIS).EQ.3).AND.(X.GT.ZERO)) X = LOG10(X)
         DX = ABS(HIST(1,IHIS,2)-HIST(1,IHIS,1))
         IF (X.LT.HIST(1,IHIS,1)) THEN
            I1 = 0
         ELSE
            I1 = INT( (X-HIST(1,IHIS,1))/MAX(DX,TINY) )+1
         ENDIF

      ELSEIF ((ISWI(IHIS).EQ.2).OR.(ISWI(IHIS).EQ.4)) THEN
c user defined bin structure
         IF ((ISWI(IHIS).EQ.4).AND.(X.GT.ZERO)) X = LOG10(X)
         IF (X.LT.HIST(1,IHIS,1)) THEN
            I1 = 0
         ELSE IF (X.GT.HIST(1,IHIS,IBINS(IHIS)+1)) THEN
            I1 = IBINS(IHIS)+1
         ELSE
c   binary sort algorithm
            KMIN = 0
            KMAX = IBINS(IHIS)+1
    1       CONTINUE
            IF ((KMAX-KMIN).EQ.1) GOTO 2
            KK = (KMAX+KMIN)/2
            IF (X.LE.HIST(1,IHIS,KK)) THEN
               KMAX=KK
            ELSE
               KMIN=KK
            ENDIF
            GOTO 1
    2       CONTINUE
            I1 = KMIN
         ENDIF

      ELSE
         WRITE(ErrorOut,1001)
 1001    FORMAT(1X,'FILHGR:   WARNING!  HISTOGRAM NOT INITIALIZED')
         RETURN
      ENDIF

c scoring
      IF (I1.LE.0) THEN
         TMPUFL(IHIS) = TMPUFL(IHIS)+ONE
      ELSEIF (I1.LE.IBINS(IHIS)) THEN
         TMPHIS(1,IHIS,I1) = TMPHIS(1,IHIS,I1)+ONE
         IF ((ISWI(IHIS).EQ.3).OR.(ISWI(IHIS).EQ.4)) THEN
            TMPHIS(2,IHIS,I1) = TMPHIS(2,IHIS,I1)+10**X
         ELSE
            TMPHIS(2,IHIS,I1) = TMPHIS(2,IHIS,I1)+X
         ENDIF
         TMPHIS(3,IHIS,I1) = TMPHIS(3,IHIS,I1)+Y
      ELSE
         TMPOFL(IHIS) = TMPOFL(IHIS)+ONE
      ENDIF

      RETURN
      END
c
c===evthis=============================================================*
c
CDECK  ID>, DT_EVTHIS
      SUBROUTINE DT_EVTHIS(NEVT)

c***********************************************************************
c Dump content of temorary histograms into /DTHIS1/. This subroutine   *
c is called after each event and for the last event before any call    *
c to OUTHGR.                                                           *
c         NEVT   number of events dumped, this is only needed to       *
c                get the normalization after the last event            *
c This version dated 23.4.95 is written  by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6)

      LOGICAL LNOETY

      PARAMETER (ZERO = 0.0D0,
     &           ONE  = 1.0D0,
     &           TINY = 1.0D-10)

c histograms

      PARAMETER (NHIS=150, NDIM=250)

      COMMON /DTHIS1/ HIST(7,NHIS,NDIM),DENTRY(2,NHIS),OVERF(NHIS),
     &                UNDERF(NHIS),IBINS(NHIS),ISWI(NHIS),IHISL

c auxiliary common for histograms
      COMMON /DTHIS2/ TMPHIS(3,NHIS,NDIM),TMPUFL(NHIS),TMPOFL(NHIS)


      DATA NCEVT /0/

      NCEVT = NCEVT+1
      NEVT  = NCEVT

      DO 1 I=1,IHISL
         LNOETY = .TRUE.
         DO 2 J=1,IBINS(I)
            IF (TMPHIS(1,I,J).GT.ZERO) THEN
               LNOETY = .FALSE.
               HIST(2,I,J)   = HIST(2,I,J)+ONE
               HIST(7,I,J)   = HIST(7,I,J)+TMPHIS(1,I,J)
               DENTRY(2,I)   = DENTRY(2,I)+TMPHIS(1,I,J)
               AVX           = TMPHIS(2,I,J)/TMPHIS(1,I,J)
               HIST(3,I,J)   = HIST(3,I,J)+TMPHIS(3,I,J)*AVX
               HIST(4,I,J)   = HIST(4,I,J)+TMPHIS(3,I,J)*AVX**2
               HIST(5,I,J)   = HIST(5,I,J)+TMPHIS(3,I,J)
               HIST(6,I,J)   = HIST(6,I,J)+TMPHIS(3,I,J)**2
               TMPHIS(1,I,J) = ZERO
               TMPHIS(2,I,J) = ZERO
               TMPHIS(3,I,J) = ZERO
            ENDIF
    2    CONTINUE
         IF (LNOETY) THEN
            IF (TMPUFL(I).GT.ZERO) THEN
               UNDERF(I) = UNDERF(I)+ONE
               TMPUFL(I) = ZERO
            ELSEIF (TMPOFL(I).GT.ZERO) THEN
               OVERF(I)  = OVERF(I)+ONE
               TMPOFL(I) = ZERO
            ENDIF
         ELSE
            DENTRY(1,I) = DENTRY(1,I)+ONE
         ENDIF
    1 CONTINUE

      RETURN
      END
c
c===outhgr=============================================================*
c
CDECK  ID>, DT_OUTHGR
      SUBROUTINE DT_OUTHGR(I1,I2,I3,I4,I5,I6,CHEAD,IHEAD,NEVTS,FAC,
     &                  ILOGY,INORM,NMODE)

c***********************************************************************
c                                                                      *
c     Plot histogram(s) to standard output unit                        *
c                                                                      *
c         I1..6         indices of histograms to be plotted            *
c         CHEAD,IHEAD   header string,integer                          *
c         NEVTS         number of events                               *
c         FAC           scaling factor                                 *
c         ILOGY   = 1   logarithmic y-axis                             *
c         INORM         normalization                                  *
c                 = 0   no further normalization (FAC is obsolete)     *
c                 = 1   per event and bin width                        *
c                 = 2   per entry and bin width                        *
c                 = 3   per bin entry                                  *
c                 = 4   per event and "bin width" x1^2...x2^2          *
c                 = 5   per event and "log. bin width" ln x1..ln x2    *
c                 = 6   per event                                      *
c         MODE    = 0   no output but normalization applied            *
c                 = 1   all valid histograms separately (small frame)  *
c                       all valid histograms separately (small frame)  *
c                 = -1  and tables as histograms                       *
c                 = 2   all valid histograms (one plot, wide frame)    *
c                       all valid histograms (one plot, wide frame)    *
c                 = -2  and tables as histograms                       *
c                                                                      *
c                                                                      *
c     Note: All histograms to be plotted with one call to this         *
c           subroutine and |MODE|=2 must have the same bin structure!  *
c           There is no test included ensuring this fact.              *
c                                                                      *
c This version dated 23.4.95 is written  by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6)

      CHARACTER*72 CHEAD

      PARAMETER (ZERO   =  0.0D0,
     &           IZERO  =  0,
     &           ONE    =  1.0D0,
     &           TWO    =  2.0D0,
     &           OHALF  =  0.5D0,
     &           EPS    =  1.0D-5,
     &           TINY   =  1.0D-8,
     &           SMALL  =  -1.0D8,
     &           RLARGE =  1.0D8 )

c histograms

      PARAMETER (NHIS=150, NDIM=250)

      COMMON /DTHIS1/ HIST(7,NHIS,NDIM),DENTRY(2,NHIS),OVERF(NHIS),
     &                UNDERF(NHIS),IBINS(NHIS),ISWI(NHIS),IHISL


      PARAMETER (NDIM2 = 2*NDIM)
      DIMENSION XX(NDIM2),YY(NDIM2)

      PARAMETER (NHISTO = 6)
      DIMENSION YY1(NDIM,NHISTO),XX1(NDIM,NHISTO),IDX1(NHISTO),
     &          IDX(NHISTO)

      CHARACTER*43 CNORM(0:8)
      DATA CNORM /'NO FURTHER NORMALIZATION                   ',
     &            'PER EVENT AND BIN WIDTH                    ',
     &            'PER ENTRY1 AND BIN WIDTH                   ',
     &            'PER BIN ENTRY                              ',
     &            'PER EVENT AND "BIN WIDTH" X1^2...X2^2      ',
     &            'PER EVENT AND "LOG. BIN WIDTH" LN X1..LN X2',
     &            'PER EVENT                                  ',
     &            'PER BIN ENTRY1                             ',
     &            'PER ENTRY2 AND BIN WIDTH                   '/

      IDX1(1) = I1
      IDX1(2) = I2
      IDX1(3) = I3
      IDX1(4) = I4
      IDX1(5) = I5
      IDX1(6) = I6

      MODE = NMODE

c initialization if "wide frame" is requested
      IF (ABS(MODE).EQ.2) THEN
         DO 1 I=1,NHISTO
            DO 2 J=1,NDIM
               XX1(J,I) = ZERO
               YY1(J,I) = ZERO
    2       CONTINUE
    1    CONTINUE
      ENDIF

c plot header
      WRITE(ErrorOut,
     * '(/1X,A,I3,/,1X,70A1)') CHEAD,IHEAD,('=',II=1,70)

c check histogram indices
      NHI = 0
      DO 3 I=1,NHISTO
         IF ((IDX1(I).GE.1).AND.(IDX1(I).LE.IHISL)) THEN
            IF (ISWI(IDX1(I)).NE.0) THEN
               IF (DENTRY(1,IDX1(I)).LT.ONE) THEN
                  WRITE(ErrorOut,1000)
     &                 IDX1(I),UNDERF(IDX1(I)),OVERF(IDX1(I))
 1000             FORMAT(/,1X,'OUTHGR:   WARNING!  NO ENTRIES IN',
     &                   ' HISTOGRAM ',I3,/,21X,'UNDERFLOWS:',F10.0,
     &                   '   OVERFLOWS:  ',F10.0)
               ELSE
                  NHI = NHI+1
                  IDX(NHI) = IDX1(I)
               ENDIF
            ENDIF
         ENDIF
    3 CONTINUE
      IF (NHI.EQ.0) THEN
         WRITE(ErrorOut,1001)
 1001    FORMAT(/,1X,'OUTHGR:   WARNING!  HISTOGRAM INDICES NOT VALID')
         RETURN
      ENDIF

c check normalization request
      IF ( ((FAC.EQ.ZERO).AND.(INORM.NE.0)).OR.
     &     ((NEVTS.LT.1).AND.((INORM.EQ.1).OR.(INORM.EQ.4).OR.
     &                        (INORM.EQ.5).OR.(INORM.EQ.6))).OR.
     &     (INORM.LT.0).OR.(INORM.GT.8) ) THEN
         WRITE(ErrorOut,1002) NEVTS,INORM,FAC
 1002    FORMAT(/,1X,'OUTHGR:   WARNING!  NORMALIZATION REQUEST NOT ',
     &          'VALID',/,21X,'NEVTS = ',I7,4X,'INORM = ',I2,4X,
     &          'FAC = ',E11.4)
         RETURN
      ENDIF

      WRITE(ErrorOut,'(/,1X,A,I8)') 'number of events:',NEVTS

c apply normalization
      DO 4 N=1,NHI

         I = IDX(N)

         IF (ISWI(I).EQ.1) THEN
            WRITE(ErrorOut,
     * 1003) I,HIST(1,I,1),HIST(1,I,IBINS(I)+1),IBINS(I)
 1003       FORMAT(/,1X,'HISTO.',I4,', LINEAR BINNING FROM',2X,E10.4,
     &             ' TO',2X,E10.4,',',2X,I3,' BINS')
         ELSEIF (ISWI(I).EQ.2) THEN
            WRITE(ErrorOut,
     * 1003) I,HIST(1,I,1),HIST(1,I,IBINS(I)+1),IBINS(I)
            WRITE(ErrorOut,1007)
 1007       FORMAT(1X,'USER DEFINED BIN STRUCTURE')
         ELSEIF (ISWI(I).EQ.3) THEN
            WRITE(ErrorOut,1004)
     &         I,10**HIST(1,I,1),10**HIST(1,I,IBINS(I)+1),IBINS(I)
 1004       FORMAT(/,1X,'HISTO.',I4,', LOGAR. BINNING FROM',2X,E10.4,
     &             ' TO',2X,E10.4,',',2X,I3,' BINS')
         ELSEIF (ISWI(I).EQ.4) THEN
            WRITE(ErrorOut,1004)
     &         I,10**HIST(1,I,1),10**HIST(1,I,IBINS(I)+1),IBINS(I)
            WRITE(ErrorOut,1007)
         ELSE
            WRITE(ErrorOut,1008) ISWI(I)
 1008       FORMAT(/,1X,'WARNING!  INCONSISTENT BIN STRUCTURE FLAG ',I4)
         ENDIF
         WRITE(ErrorOut,
     * 1005) DENTRY(1,I),DENTRY(2,I),UNDERF(I),OVERF(I)
 1005    FORMAT(13X,'ENTRIES:',2F9.0,' UNDERFL.:',F8.0,
     &          ' OVERFL.:',F8.0)
         WRITE(ErrorOut,1009) CNORM(INORM)
 1009    FORMAT(1X,'NORMALIZATION: ',A,/)

         DO 5 K=1,IBINS(I)
            CALL DT_GETBIN(I,K,NEVTS,INORM,XLOW,XHI,XMEAN,YMEAN,YERR)
            YMEAN = FAC*YMEAN
            YERR  = FAC*YERR
            WRITE(ErrorOut,
     * 1006) XLOW,XMEAN,YMEAN,YERR,HIST(2,I,K)
            WRITE(ErrorOut,
     * 1006) XHI ,XMEAN,YMEAN,YERR,HIST(2,I,K)
 1006       FORMAT(1X,5E11.3)
c    small frame
            II = 2*K
            XX(II-1) = HIST(1,I,K)
            XX(II)   = HIST(1,I,K+1)
            YY(II-1) = YMEAN
            YY(II)   = YMEAN
c    wide frame
            XX1(K,N) = XMEAN
            IF ((ISWI(I).EQ.3).OR.(ISWI(I).EQ.4))
     &         XX1(K,N) = LOG10(XMEAN)
            YY1(K,N) = YMEAN
    5    CONTINUE

c plot small frame
         IF (ABS(MODE).EQ.1) THEN
            IBIN2 = 2*IBINS(I)
            WRITE(ErrorOut,'(/,1X,A)') 'Preview:'
            IF(ILOGY.EQ.1) THEN
              CALL DT_XGLOGY(IBIN2,1,XX,YY,YY)
            ELSE
              CALL DT_XGRAPH(IBIN2,1,XX,YY,YY)
            ENDIF
         ENDIF

    4 CONTINUE

c plot wide frame
      IF (ABS(MODE).EQ.2) THEN
         WRITE(ErrorOut,'(/,1X,A)') 'Preview:'
         NSIZE = NDIM*NHISTO
         DXLOW = HIST(1,IDX(1),1)
         DDX   = ABS(HIST(1,IDX(1),2)-HIST(1,IDX(1),1))
         YLOW  = RLARGE
         YHI   = SMALL
         DO 6 I=1,NHISTO
            DO 7 J=1,NDIM
               IF (YY1(J,I).LT.YLOW) THEN
                  IF (ILOGY.EQ.1) THEN
                     IF (YY1(J,I).GT.ZERO) YLOW = YY1(J,I)
                  ELSE
                     YLOW = YY1(J,I)
                  ENDIF
               ENDIF
               IF (YY1(J,I).GT.YHI) YHI = YY1(J,I)
    7       CONTINUE
    6    CONTINUE
         DY = (YHI-YLOW)/DBLE(NDIM)
         IF (DY.LE.ZERO) THEN
            WRITE(ErrorOut,'(1X,A,6I4,A,2E12.4)')
     &         'OUTHGR:   WARNING! ZERO BIN WIDTH FOR HISTOGRAMS ',
     &         IDX,': ',YLOW,YHI
            RETURN
         ENDIF
         IF (ILOGY.EQ.1) THEN
            YLOW = LOG10(YLOW)
            DY   = (LOG10(YHI)-YLOW)/100.0D0
            DO 8 I=1,NHISTO
               DO 9 J=1,NDIM
                  IF (YY1(J,I).LE.ZERO) THEN
                     YY1(J,I) = YLOW
                  ELSE
                     YY1(J,I) = LOG10(YY1(J,I))
                  ENDIF
    9          CONTINUE
    8       CONTINUE
         ENDIF
         CALL DT_SRPLOT(XX1,YY1,NSIZE,NHISTO,NDIM,DXLOW,DDX,YLOW,DY)
      ENDIF

      RETURN
      END
c
c===getbin=============================================================*
c
CDECK  ID>, DT_GETBIN
      SUBROUTINE DT_GETBIN(IHIS,IBIN,KEVT,NORM,XLOW,XHI,
     &                  XMEAN,YMEAN,YERR)

c***********************************************************************
c This version dated 23.4.95 is written  by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6)

      PARAMETER (ZERO   = 0.0D0,
     &           ONE    = 1.0D0,
     &           TINY35 = 1.0D-35)

c histograms

      PARAMETER (NHIS=150, NDIM=250)

      COMMON /DTHIS1/ HIST(7,NHIS,NDIM),DENTRY(2,NHIS),OVERF(NHIS),
     &                UNDERF(NHIS),IBINS(NHIS),ISWI(NHIS),IHISL


      XLOW = HIST(1,IHIS,IBIN)
      XHI  = HIST(1,IHIS,IBIN+1)
      IF ((ISWI(IHIS).EQ.3).OR.(ISWI(IHIS).EQ.4)) THEN
         XLOW = 10**XLOW
         XHI  = 10**XHI
      ENDIF
      IF (NORM.EQ.2) THEN
         DX   = XHI-XLOW
         NEVT = INT(DENTRY(1,IHIS))
      ELSEIF (NORM.EQ.3) THEN
         DX   = ONE
         NEVT = INT(HIST(2,IHIS,IBIN))
      ELSEIF (NORM.EQ.4) THEN
         DX   = XHI**2-XLOW**2
         NEVT = KEVT
      ELSEIF (NORM.EQ.5) THEN
         DX   = LOG(ABS(XHI))-LOG(ABS(XLOW))
         NEVT = KEVT
      ELSEIF (NORM.EQ.6) THEN
         DX   = ONE
         NEVT = KEVT
      ELSEIF (NORM.EQ.7) THEN
         DX   = ONE
         NEVT = INT(HIST(7,IHIS,IBIN))
      ELSEIF (NORM.EQ.8) THEN
         DX   = XHI-XLOW
         NEVT = INT(DENTRY(2,IHIS))
      ELSE
         DX   = ABS(XHI-XLOW)
         NEVT = KEVT
      ENDIF
      IF (ABS(DX).LT.TINY35) DX = ONE
      NEVT   = MAX(NEVT,1)
      YMEAN  = HIST(5,IHIS,IBIN)/DX/DBLE(NEVT)
      YMEAN2 = HIST(6,IHIS,IBIN)/DX**2/DBLE(NEVT)
      YERR   = SQRT(ABS(YMEAN2-YMEAN**2))/SQRT(DBLE(NEVT))
      YSUM   = HIST(5,IHIS,IBIN)
      IF (ABS(YSUM).LT.TINY35) YSUM = ONE
C     XMEAN  = HIST(3,IHIS,IBIN)/YSUM/MAX(HIST(2,IHIS,IBIN),ONE)
      XMEAN  = HIST(3,IHIS,IBIN)/YSUM
      IF (XMEAN.EQ.ZERO) XMEAN = XLOW

      RETURN
      END
c
c===joihis=============================================================*
c
CDECK  ID>, DT_JOIHIS
      SUBROUTINE DT_JOIHIS(IH1,IH2,COPER,FAC1,FAC2,KEVT,NORM,ILOGY,MODE)

c***********************************************************************
c                                                                      *
c     Operation on histograms.                                         *
c                                                                      *
c     input:  IH1,IH2      histogram indices to be joined              *
c             COPER        character defining the requested operation, *
c                          i.e. '+', '-', '*', '/'                     *
c             FAC1,FAC2    factors for joining, i.e.                   *
c                          FAC1*histo1 COPER FAC2*histo2               *
c                                                                      *
c This version dated 23.4.95 is written  by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6)

      CHARACTER COPER*1

      PARAMETER (ZERO   =  0.0D0,
     &           ONE    =  1.0D0,
     &           OHALF  =  0.5D0,
     &           TINY8  =  1.0D-8,
     &           SMALL  =  -1.0D8,
     &           RLARGE =  1.0D8 )

c histograms

      PARAMETER (NHIS=150, NDIM=250)

      COMMON /DTHIS1/ HIST(7,NHIS,NDIM),DENTRY(2,NHIS),OVERF(NHIS),
     &                UNDERF(NHIS),IBINS(NHIS),ISWI(NHIS),IHISL


      PARAMETER (NDIM2 = 2*NDIM)
      DIMENSION XX(NDIM2),YY(NDIM2),YY1(NDIM),XX1(NDIM)

      CHARACTER*43 CNORM(0:6)
      DATA CNORM /'NO FURTHER NORMALIZATION                   ',
     &            'PER EVENT AND BIN WIDTH                    ',
     &            'PER ENTRY AND BIN WIDTH                    ',
     &            'PER BIN ENTRY                              ',
     &            'PER EVENT AND "BIN WIDTH" X1^2...X2^2      ',
     &            'PER EVENT AND "LOG. BIN WIDTH" LN X1..LN X2',
     &            'PER EVENT                                  '/

c check histogram indices
      IF ((IH1.LT.    1).OR.(IH2.LT.    1).OR.
     &    (IH1.GT.IHISL).OR.(IH2.GT.IHISL)) THEN
         WRITE(ErrorOut,1000) IH1,IH2,IHISL
 1000    FORMAT(1X,'JOIHIS:   WARNING!  INCONSISTENT HISTOGRAM ',
     &          'INDICES (',I3,',',I3,'),',/,21X,'VALID RANGE:  1,',I3)
         GOTO 9999
      ENDIF

c check bin structure of histograms to be joined
      IF (IBINS(IH1).NE.IBINS(IH2)) THEN
         WRITE(ErrorOut,1001) IH1,IH2,IBINS(IH1),IBINS(IH2)
 1001    FORMAT(1X,'JOIHIS:   WARNING!  JOINING HISTOGRAMS ',I3,
     &          ' AND ',I3,' FAILED',/,21X,
     &          'DUE TO DIFFERENT NUMBERS OF BINS (',I3,',',I3,')')
         GOTO 9999
      ENDIF
      DO 1 K=1,IBINS(IH1)+1
         IF (ABS(HIST(1,IH1,K)-HIST(1,IH2,K)).GT.TINY8) THEN
            WRITE(ErrorOut,
     * 1002) IH1,IH2,K,HIST(1,IH1,K),HIST(1,IH2,K)
 1002       FORMAT(1X,'JOIHIS:   WARNING!  JOINING HISTOGRAMS ',I3,
     &             ' AND ',I3,' FAILED AT BIN EDGE ',I3,/,21X,
     &             'X1,X2 = ',2E11.4)
            GOTO 9999
         ENDIF
    1 CONTINUE

      WRITE(ErrorOut,1003) IH1,IH2,COPER,FAC1,FAC2
 1003 FORMAT(1X,'JOIHIS:   JOINING HISTOGRAMS ',I3,',',I3,' WITH ',
     &       'OPERATION ',A,/,11X,'AND FACTORS ',2E11.4)
      WRITE(ErrorOut,1004) CNORM(NORM)
 1004 FORMAT(1X,'NORMALIZATION: ',A,/)

      DO 2 K=1,IBINS(IH1)
         CALL DT_GETBIN(IH1,K,KEVT,NORM,XLOW1,XHI1,XMEAN1,YMEAN1,YERR1)
         CALL DT_GETBIN(IH2,K,KEVT,NORM,XLOW2,XHI2,XMEAN2,YMEAN2,YERR2)
         XLOW  = XLOW1
         XHI   = XHI1
         XMEAN = OHALF*(XMEAN1+XMEAN2)
         IF (COPER.EQ.'+') THEN
            YMEAN = FAC1*YMEAN1+FAC2*YMEAN2
         ELSEIF (COPER.EQ.'*') THEN
            YMEAN = FAC1*YMEAN1*FAC2*YMEAN2
         ELSEIF (COPER.EQ.'/') THEN
            IF (YMEAN2.EQ.ZERO) THEN
               YMEAN = ZERO
            ELSE
               IF (FAC2.EQ.ZERO) FAC2 = ONE
               YMEAN = FAC1*YMEAN1/(FAC2*YMEAN2)
            ENDIF
         ELSE
            GOTO 9998
         ENDIF
         WRITE(ErrorOut,
     * 1006) XLOW,XMEAN,YMEAN,HIST(2,IH1,K),HIST(2,IH2,K)
         WRITE(ErrorOut,
     * 1006) XHI ,XMEAN,YMEAN,HIST(2,IH1,K),HIST(2,IH2,K)
 1006    FORMAT(1X,5E11.3)
c    small frame
         II = 2*K
         XX(II-1) = HIST(1,IH1,K)
         XX(II)   = HIST(1,IH1,K+1)
         YY(II-1) = YMEAN
         YY(II)   = YMEAN
c    wide frame
         XX1(K) = XMEAN
         IF ((ISWI(IH1).EQ.3).OR.(ISWI(IH1).EQ.4)) XX1(K) = LOG10(XMEAN)
         YY1(K) = YMEAN
    2 CONTINUE

c plot small frame
      IF (ABS(MODE).EQ.1) THEN
         IBIN2 = 2*IBINS(IH1)
         WRITE(ErrorOut,'(/,1X,A)') 'Preview:'
         IF(ILOGY.EQ.1) THEN
           CALL DT_XGLOGY(IBIN2,1,XX,YY,YY)
         ELSE
           CALL DT_XGRAPH(IBIN2,1,XX,YY,YY)
         ENDIF
      ENDIF

c plot wide frame
      IF (ABS(MODE).EQ.2) THEN
         WRITE(ErrorOut,'(/,1X,A)') 'Preview:'
         NSIZE = NDIM
         DXLOW = HIST(1,IH1,1)
         DDX   = ABS(HIST(1,IH1,2)-HIST(1,IH1,1))
         YLOW  = RLARGE
         YHI   = SMALL
         DO 3 I=1,NDIM
            IF (YY1(I).LT.YLOW) THEN
               IF (ILOGY.EQ.1) THEN
                  IF (YY1(I).GT.ZERO) YLOW = YY1(I)
               ELSE
                  YLOW = YY1(I)
               ENDIF
            ENDIF
            IF (YY1(I).GT.YHI) YHI = YY1(I)
    3    CONTINUE
         DY = (YHI-YLOW)/DBLE(NDIM)
         IF (DY.LE.ZERO) THEN
            WRITE(ErrorOut,'(1X,A,2I4,A,2E12.4)')
     &         'JOIHIS:   WARNING! ZERO BIN WIDTH FOR HISTOGRAMS ',
     &         IH1,IH2,': ',YLOW,YHI
            RETURN
         ENDIF
         IF (ILOGY.EQ.1) THEN
            YLOW = LOG10(YLOW)
            DY   = (LOG10(YHI)-YLOW)/100.0D0
            DO 4 I=1,NDIM
               IF (YY1(I).LE.ZERO) THEN
                  YY1(I) = YLOW
               ELSE
                  YY1(I) = LOG10(YY1(I))
               ENDIF
    4       CONTINUE
         ENDIF
         CALL DT_SRPLOT(XX1,YY1,NSIZE,1,NDIM,DXLOW,DDX,YLOW,DY)
      ENDIF

      RETURN

 9998 CONTINUE
      WRITE(ErrorOut,1005) COPER
 1005 FORMAT(1X,'JOIHIS:   UNKNOWN OPERATION ',A)

 9999 CONTINUE
      RETURN
      END
c
c===qgraph=============================================================*
c
CDECK  ID>, DT_XGRAPH
      SUBROUTINE DT_XGRAPH(N,IARG,X,Y1,Y2)
C***********************************************************************
C
C     calculate quasi graphic picture with 25 lines and 79 columns
C     ranges will be chosen automatically
C
C     input     N          dimension of input fields
C               IARG       number of curves (fields) to plot
C               X          field of X
C               Y1         field of Y1
C               Y2         field of Y2
C
C This subroutine is written by R. Engel.
C***********************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
C
      DIMENSION X(N),Y1(N),Y2(N)
      PARAMETER (EPS=1.D-30)
      PARAMETER (IYRAST=5,IXRAST=10,IBREIT=79,IZEIL=20)
      CHARACTER SYMB(5)
      CHARACTER COL(0:149,0:49)
C
      DATA SYMB /'0','E','Z','#','X'/
C
      ISPALT=IBREIT-10
C
C***  automatic range fitting
C
      XMAX=X(1)
      XMIN=X(1)
      DO 600 I=1,N
         XMAX=MAX(X(I),XMAX)
         XMIN=MIN(X(I),XMIN)
 600  CONTINUE
      XZOOM=(XMAX-XMIN)/DBLE(ISPALT)
C
      ITEST=0
      DO 1100 K=0,IZEIL-1
         ITEST=ITEST+1
         IF (ITEST.EQ.IYRAST) THEN
            DO 1010 L=1,ISPALT-1
               COL(L,K)='-'
1010        CONTINUE
            COL(ISPALT,K)='+'
            ITEST=0
            DO 1020 L=0,ISPALT-1,IXRAST
               COL(L,K)='+'
1020        CONTINUE
         ELSE
            DO 1030 L=1,ISPALT-1
               COL(L,K)=' '
1030        CONTINUE
            DO 1040 L=0,ISPALT-1,IXRAST
               COL(L,K)='|'
1040        CONTINUE
            COL(ISPALT,K)='|'
         ENDIF
1100  CONTINUE
C
C***  plot curve Y1
C
      YMAX=Y1(1)
      YMIN=Y1(1)
      DO 500 I=1,N
         YMAX=MAX(Y1(I),YMAX)
         YMIN=MIN(Y1(I),YMIN)
500   CONTINUE
      IF(IARG.GT.1) THEN
        DO 550 I=1,N
           YMAX=MAX(Y2(I),YMAX)
           YMIN=MIN(Y2(I),YMIN)
550     CONTINUE
      ENDIF
      YMAX=(YMAX-YMIN)/40.0D0+YMAX
      YMIN=YMIN-(YMAX-YMIN)/40.0D0
      YZOOM=(YMAX-YMIN)/DBLE(IZEIL)
      IF(YZOOM.LT.EPS) THEN
        WRITE(ErrorOut,'(1X,A)')
     &    'XGRAPH:WARNING: MIN = MAX, OUTPUT SUPPRESSED'
        RETURN
      ENDIF
C
C***  plot curve Y1
C
      ILAST=-1
      LLAST=-1
      DO 1200 K=1,N
         L=NINT((X(K)-XMIN)/XZOOM)
         I=NINT((YMAX-Y1(K))/YZOOM)
         IF(ILAST.GE.0) THEN
           LD = L-LLAST
           ID = I-ILAST
           DO 55 II=0,LD,SIGN(1,LD)
             DO 66 KK=0,ID,SIGN(1,ID)
               COL(II+LLAST,KK+ILAST)=SYMB(1)
 66          CONTINUE
 55        CONTINUE
         ELSE
           COL(L,I)=SYMB(1)
         ENDIF
         ILAST = I
         LLAST = L
1200  CONTINUE
C
      IF(IARG.GT.1) THEN
C
C***  plot curve Y2
C
        DO 1250 K=1,N
           L=NINT((X(K)-XMIN)/XZOOM)
           I=NINT((YMAX-Y2(K))/YZOOM)
           COL(L,I)=SYMB(2)
1250    CONTINUE
      ENDIF
C
C***  write it
C
      WRITE(ErrorOut,'(1X,79A)') ('-',I=1,IBREIT)
C
C***  write range of X
C
      XZOOM = (XMAX-XMIN)/DBLE(7)
      WRITE(ErrorOut,120) (XZOOM*DBLE(I-1)+XMIN,I=1,7)
C
      DO 1300 K=0,IZEIL-1
         YPOS=YMAX-((DBLE(K)+0.5D0)*YZOOM)
         WRITE(ErrorOut,110) YPOS,(COL(I,K),I=0,ISPALT)
 110     FORMAT(1X,1PE9.2,70A1)
1300  CONTINUE
C
C***  write range of X
C
      XZOOM = (XMAX-XMIN)/DBLE(7)
      WRITE(ErrorOut,120) (XZOOM*DBLE(I-1)+XMIN,I=1,7)
      WRITE(ErrorOut,'(1X,79A)') ('-',I=1,IBREIT)
 120  FORMAT(6X,7(1PE10.3))
      END
c
c===qglogy=============================================================*
c
CDECK  ID>, DT_XGLOGY
      SUBROUTINE DT_XGLOGY(N,IARG,X,Y1,Y2)
C***********************************************************************
C
C     calculate quasi graphic picture with 25 lines and 79 columns
C     logarithmic y axis
C     ranges will be chosen automatically
C
C     input     N          dimension of input fields
C               IARG       number of curves (fields) to plot
C               X          field of X
C               Y1         field of Y1
C               Y2         field of Y2
C
C This subroutine is written by R. Engel.
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      DIMENSION X(N),Y1(N),Y2(N)
      PARAMETER (EPS=1.D-30)
      PARAMETER (IYRAST=5,IXRAST=10,IBREIT=79,IZEIL=20)
      CHARACTER SYMB(5)
      CHARACTER COL(0:149,0:49)
      PARAMETER (DEPS = 1.D-10)
C
      DATA SYMB /'0','E','Z','#','X'/
C
      ISPALT=IBREIT-10
C
C***  automatic range fitting
C
      XMAX=X(1)
      XMIN=X(1)
      DO 600 I=1,N
         XMAX=MAX(X(I),XMAX)
         XMIN=MIN(X(I),XMIN)
 600  CONTINUE
      XZOOM=(XMAX-XMIN)/DBLE(ISPALT)
C
      ITEST=0
      DO 1100 K=0,IZEIL-1
         ITEST=ITEST+1
         IF (ITEST.EQ.IYRAST) THEN
            DO 1010 L=1,ISPALT-1
               COL(L,K)='-'
1010        CONTINUE
            COL(ISPALT,K)='+'
            ITEST=0
            DO 1020 L=0,ISPALT-1,IXRAST
               COL(L,K)='+'
1020        CONTINUE
         ELSE
            DO 1030 L=1,ISPALT-1
               COL(L,K)=' '
1030        CONTINUE
            DO 1040 L=0,ISPALT-1,IXRAST
               COL(L,K)='|'
1040        CONTINUE
            COL(ISPALT,K)='|'
         ENDIF
1100  CONTINUE
C
C***  plot curve Y1
C
      YMAX=Y1(1)
      YMIN=MAX(Y1(1),EPS)
      DO 500 I=1,N
         YMAX =MAX(Y1(I),YMAX)
         IF(Y1(I).GT.EPS) THEN
           IF(YMIN.EQ.EPS) THEN
             YMIN = Y1(I)/10.D0
           ELSE
             YMIN = MIN(Y1(I),YMIN)
           ENDIF
         ENDIF
500   CONTINUE
      IF(IARG.GT.1) THEN
        DO 550 I=1,N
           YMAX=MAX(Y2(I),YMAX)
           IF(Y2(I).GT.EPS) THEN
             IF(YMIN.EQ.EPS) THEN
               YMIN = Y2(I)
             ELSE
               YMIN = MIN(Y2(I),YMIN)
             ENDIF
           ENDIF
550     CONTINUE
      ENDIF
C
      DO 560 I=1,N
        Y1(I) = MAX(Y1(I),YMIN)
 560  CONTINUE
      IF(IARG.GT.1) THEN
        DO 570 I=1,N
          Y2(I) = MAX(Y2(I),YMIN)
 570    CONTINUE
      ENDIF
C
      IF(YMAX.LE.YMIN) THEN
        WRITE(ErrorOut,
     * '(/1X,A,2E12.3,/)') 'XGLOGY:ERROR:YMIN,YMAX ',YMIN,YMAX
        WRITE(ErrorOut,'(1X,A)') 'MIN = MAX, OUTPUT SUPPRESSED'
        RETURN
      ENDIF
C
      YMA=(LOG10(YMAX)-LOG10(YMIN))/20.0D0+LOG10(YMAX)
      YMI=LOG10(YMIN)-(LOG10(YMAX)-LOG10(YMIN))/20.0D0
      YZOOM=(YMA-YMI)/DBLE(IZEIL)
      IF(YZOOM.LT.EPS) THEN
        WRITE(ErrorOut,'(1X,A)')
     &    'XGLOGY:WARNING: MIN = MAX, OUTPUT SUPPRESSED'
        RETURN
      ENDIF
C
C***  plot curve Y1
C
      ILAST=-1
      LLAST=-1
      DO 1200 K=1,N
         L=NINT((X(K)-XMIN)/XZOOM)
         I=NINT((YMA-LOG10(Y1(K)))/YZOOM)
         IF(ILAST.GE.0) THEN
           LD = L-LLAST
           ID = I-ILAST
           DO 55 II=0,LD,SIGN(1,LD)
             DO 66 KK=0,ID,SIGN(1,ID)
               COL(II+LLAST,KK+ILAST)=SYMB(1)
 66          CONTINUE
 55        CONTINUE
         ELSE
           COL(L,I)=SYMB(1)
         ENDIF
         ILAST = I
         LLAST = L
1200  CONTINUE
C
      IF(IARG.GT.1) THEN
C
C***  plot curve Y2
C
        DO 1250 K=1,N
           L=NINT((X(K)-XMIN)/XZOOM)
           I=NINT((YMA-LOG10(Y2(K)))/YZOOM)
           COL(L,I)=SYMB(2)
1250    CONTINUE
      ENDIF
C
C***  write it
C
      WRITE(ErrorOut,'(2X,A)') '(LOGARITHMIC Y AXIS)'
      WRITE(ErrorOut,'(1X,79A)') ('-',I=1,IBREIT)
C
C***  write range of X
C
      XZOOM1 = (XMAX-XMIN)/DBLE(7)
      WRITE(ErrorOut,120) (XZOOM1*DBLE(I-1)+XMIN,I=1,7)
C
      DO 1300 K=0,IZEIL-1
         YPOS=10.D0**(YMA-((DBLE(K)+0.5D0)*YZOOM))
         WRITE(ErrorOut,110) YPOS,(COL(I,K),I=0,ISPALT)
 110     FORMAT(1X,1PE9.2,70A1)
1300  CONTINUE
C
C***  write range of X
C
      WRITE(ErrorOut,120) (XZOOM1*DBLE(I-1)+XMIN,I=1,7)
      WRITE(ErrorOut,'(1X,79A)') ('-',I=1,IBREIT)
 120  FORMAT(6X,7(1PE10.3))
C
      END
c
c===plot===============================================================*
c
CDECK  ID>, DT_SRPLOT
      SUBROUTINE DT_SRPLOT(X,Y,N,M,MM,XO,DX,YO,DY)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
c
c     initial version
c     J. Ranft, (FORTRAN-Programmierung,J.R.,Teubner, Leipzig, 72)
c     This is a subroutine of fluka to plot Y across the page
c     as a function of X down the page. Up to 37 curves can be
c     plotted in the same picture with different plotting characters.
c     Output of first 10 overprinted characters addad by FB 88
c  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
c     Input Variables:
c        X   = array containing the values of X
c        Y   = array containing the values of Y
c        N   = number of values in X and in Y
c              can exceed the fixed number of lines
c        M   = number of different curves X,Y are containing
c        MM  = number of points in each curve i.e. N=M*MM
c        XO  = smallest value of X to be plotted
c        DX  = increment of X between subsequent lines
c        YO  = smallest value of Y to be plotted
c        DY  = increment of Y between subsequent character spaces
c
c        other variables used inside:
c        XX  = numbers along the X-coordinate axis
c        YY  = numbers along the Y-coordinate axis
c        LL  = ten lines temporary storage for the plot
c        L   = character set used to plot different curves
c        LOV = memorizes overprinted symbols
c              the first 10 overprinted symbols are printed on
c              the end of the line to avoid ambiguities
c              (added by FB as considered quite helpful)
c
c********************************************************************
c
      DIMENSION XX(61),YY(61),LL(101,10)
      DIMENSION X(N),Y(N),L(40),LOV(40,10)
      DATA  L/
     11H*,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9,1HZ,
     21H+,1HA,1HO,1HB,1HC,1HD,1HE,1HF,1HG,1HH,
     31HI,1HJ,1HK,1HL,1HM,1HN,1HO,1HP,1HQ,1HR,
     41HS,1HT,1HU,1HV,1HW,1HX,1HY,1H1,1H-,1H  /
c
c
      MN=51
      DO 10 I=1,MN
        AI=I-1
   10 XX(I)=XO+AI*DX
      DO 20 I=1,11
        AI=I-1
   20 YY(I)=YO+10.0D0*AI*DY
      WRITE(ErrorOut, 500) (YY(I),I=1,11)
      MMN=MN-1
c
c
      DO 90 JJ=1,MMN,10
        JJJ=JJ-1
        DO 30 I=1,101
          DO 30 J=1,10
   30   LL(I,J)=L(40)
        DO 40 I=1,101
   40   LL(I,1)=L(39)
        DO 50 I=1,101,10
          DO 50 J=1,10
   50   LL(I,J)=L(38)
        DO 60 I=1,40
          DO 60 J=1,10
   60   LOV(I,J)=L(40)
c
c
        DO 70 I=1,M
          DO 70 J=1,MM
            II=J+(I-1)*MM
            AIX=(X(II)-(XO-DX/2.0D0))/DX+1.0D0
            AIY=(Y(II)-(YO-DY/2.0D0))/DY+1.0D0
            AIX=AIX-DBLE(JJJ)
c           changed Sept.88 by FB to avoid INTEGER OVERFLOW
            IF( AIX .GT. 1.D0.AND. AIX .LT. 11.D0.AND. AIY .GT. 1.D0.AND
     +      . AIY .LT. 102.D0) THEN
              IX=INT(AIX)
              IY=INT(AIY)
              IF( IX.GT. 0.AND. IX.LE. 10.AND. IY.GT. 0.AND. IY.LE. 101)
     +        THEN
                IF(LL(IY,IX).NE.L(38).AND.LL(IY,IX).NE.L(39)) LOV(I,IX)
     +          =LL(IY,IX)
                LL(IY,IX)=L(I)
              ENDIF
            ENDIF
   70   CONTINUE
c
c
        DO 80 I=1,10
          II=I+JJJ
          III=II+1
          WRITE(ErrorOut,
     * 510) XX(II),XX(III) , (LL(J,I),J=1,101) , (LOV(J,I),J
     +    =1,10)
   80   CONTINUE
   90 CONTINUE
c
c
      WRITE(ErrorOut, 520)
      WRITE(ErrorOut, 500) (YY(I),I=1,11)
      RETURN
c
  500 FORMAT(11X,11(1PE10.2),11HOVERPRINTED)
  510 FORMAT(1X,2(1PE10.2),101A1,1H ,10A1)
  520 FORMAT(20X,10('1---------'),'1')
      END
c
c===hadron=============================================================*
c
CDECK  ID>, DT_HADPRP
      BLOCK DATA DT_HADPRP

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c auxiliary common for reggeon exchange (DTUNUC 1.x)
      COMMON /DTQUAR/ IQECHR(-6:6),IQBCHR(-6:6),IQICHR(-6:6),
     &                IQSCHR(-6:6),IQCCHR(-6:6),IQUCHR(-6:6),
     &                IQTCHR(-6:6),MQUARK(3,39)

c hadron index conversion (BAMJET <--> PDG)
      COMMON /DTHAIC/ IPDG2(2,7),IBAM2(2,7),IPDG3(2,22),IBAM3(2,22),
     &                IPDG4(2,29),IBAM4(2,29),IPDG5(2,19),IBAM5(2,19),
     &                IAMCIN(210)

c names of hadrons used in input-cards
      CHARACTER*8 BTYPE
      COMMON /DTPAIN/ BTYPE(30)


c / DTQUAR /
c----------------------------------------------------------------------*
c                                                                      *
c     Quark content of particles:                                      *
c          index   quark   el. charge  bar. charge  isospin  isospin3  *
c              1 = u          2/3          1/3        1/2       1/2    *
c             -1 = ubar      -2/3         -1/3        1/2      -1/2    *
c              2 = d         -1/3          1/3        1/2      -1/2    *
c             -2 = dbar       1/3         -1/3        1/2       1/2    *
c              3 = s         -1/3          1/3         0         0     *
c             -3 = sbar       1/3         -1/3         0         0     *
c              4 = c          2/3          1/3         0         0     *
c             -4 = cbar      -2/3         -1/3         0         0     *
c              5 = b         -1/3          1/3         0         0     *
c             -5 = bbar       1/3         -1/3         0         0     *
c              6 = t          2/3          1/3         0         0     *
c             -6 = tbar      -2/3         -1/3         0         0     *
c                                                                      *
c         Mquark = particle quark composition (Paprop numbering)       *
c         Iqechr = electric charge ( in 1/3 unit )                     *
c         Iqbchr = baryonic charge ( in 1/3 unit )                     *
c         Iqichr = isospin ( in 1/2 unit ), z component                *
c         Iqschr = strangeness                                         *
c         Iqcchr = charm                                               *
c         Iquchr = beauty                                              *
c         Iqtchr = ......                                              *
c                                                                      *
c----------------------------------------------------------------------*
      DATA IQECHR / -2, 1, -2, 1, 1, -2, 0, 2, -1, -1, 2, -1, 2 /
      DATA IQBCHR / 6*-1, 0, 6*1 /
      DATA IQICHR / 4*0, 1, -1, 0, 1, -1, 4*0 /
      DATA IQSCHR / 3*0, 1, 5*0, -1, 3*0 /
      DATA IQCCHR / 2*0, -1, 7*0, 1, 2*0 /
      DATA IQUCHR / 0, 1, 9*0, -1, 0 /
      DATA IQTCHR / -1, 11*0, 1 /
      DATA MQUARK /
     &   2, 1, 1,   -2,-1,-1,    0, 0, 0,    0, 0, 0,    0, 0, 0,
     &   0, 0, 0,    0, 0, 0,    2, 2, 1,   -2,-2,-1,    0, 0, 0,
     &   0, 0, 0,    0, 0, 0,    1,-2, 0,    2,-1, 0,    1,-3, 0,
     &   3,-1, 0,    1, 2, 3,   -1,-2,-3,    0, 0, 0,    2, 2, 3,
     &   1, 1, 3,    1, 2, 3,    1,-1, 0,    2,-3, 0,    3,-2, 0,
     &   2,-2, 0,    3,-3, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,
     &  -1,-1,-3,   -1,-2,-3,   -2,-2,-3,    1, 3, 3,   -1,-3,-3,
     &   2, 3, 3,   -2,-3,-3,    3, 3, 3,   -3,-3,-3 /

c / DTHAIC /
c (renamed) (HAdron InDex COnversion)
c translation table version filled up by r.e. 25.01.94                 *
      DATA IAMCIN /
     &2212,-2212,11,-11,12,              -12,22,2112,-2112,-13,
     &13,130,211,-211,321,               -321,3122,-3122,310,3112,
     &3222,3212,111,311,-311,            0,0,0,0,0,
     &221,213,113,-213,223,              323,313,-323,-313,10323,
     &10313,-10323,-10313,30323,30313,   -30323,-30313,3224,3214,3114,
     &3216,3218,2224,2214,2114,          1114,12224,12214,12114,11114,
     &99999,99999,22212,22112,32124,     31214,-2224,-2214,-2114,-1114,
     &-12224,-12214,-12114,-11114,-2124, -1214,4*99999,
     &5*99999,                           5*99999,
     &4*99999,331,                       333,3322,3312,-3222,-3212,
     &-3112,-3322,-3312,3224,3214,       3114,3324,3314,3334,-3224,
     &-3214,-3114,-3324,-3314,-3334,     421,411,-411,-421,431,
     &-431,441,423,413,-413,             -423,433,-433,20443,443,
     &-15,15,16,-16,14,                  -14,4122,4232,4132,4222,
     &4212,4112,3*99999,                 3*99999,-4122,-4232,
     &-4132,-4222,-4212,-4112,99999,     5*99999,
     &5*99999,                           5*99999,
     &10*99999,
     &5*99999 , 20211,20111,-20211,99999,20321,
     &-20321,20311,-20311,7*99999 ,
     &7*99999,12212,12112,99999/

c / DTHAIC /
c (HAdron InDex COnversion)
      DATA (IPDG2(1,K),K=1,7)
     &   /   -11,   -12,   -13,   -15,   -16,   -14,     0/
      DATA (IBAM2(1,K),K=1,7)
     &   /     4,     6,    10,   131,   134,   136,     0/
      DATA (IPDG2(2,K),K=1,7)
     &   /    11,    12,    22,    13,    15,    16,    14/
      DATA (IBAM2(2,K),K=1,7)
     &   /     3,     5,     7,    11,   132,   133,   135/
      DATA (IPDG3(1,K),K=1,22)
     &   /  -211,  -321,  -311,  -213,  -323,  -313,  -411,  -421,
     &      -431,  -413,  -423,  -433,     0,     0,     0,     0,
     &         0,     0,     0,     0,     0,     0/
      DATA (IBAM3(1,K),K=1,22)
     &   /    14,    16,    25,    34,    38,    39,   118,   119,
     &       121,   125,   126,   128,     0,     0,     0,     0,
     &         0,     0,     0,     0,     0,     0/
      DATA (IPDG3(2,K),K=1,22)
     &   /   130,   211,   321,   310,   111,   311,   221,   213,
     &       113,   223,   323,   313,   331,   333,   421,   411,
     &       431,   441,   423,   413,   433,   443/
      DATA (IBAM3(2,K),K=1,22)
     &   /    12,    13,    15,    19,    23,    24,    31,    32,
     &        33,    35,    36,    37,    95,    96,   116,   117,
     &       120,   122,   123,   124,   127,   130/
      DATA (IPDG4(1,K),K=1,29)
     &   / -2212, -2112, -3122, -2224, -2214, -2114, -1114, -2124,
     &     -1214, -3222, -3212, -3112, -3322, -3312, -3224, -3214,
     &     -3114, -3324, -3314, -3334, -4122, -4232, -4132, -4222,
     &     -4212, -4112,     0,     0,     0/
      DATA (IBAM4(1,K),K=1,29)
     &   /     2,     9,    18,    67,    68,    69,    70,    75,
     &        76,    99,   100,   101,   102,   103,   110,   111,
     &       112,   113,   114,   115,   149,   150,   151,   152,
     &       153,   154,     0,     0,     0/
      DATA (IPDG4(2,K),K=1,29)
     &   /  2212,  2112,  3122,  3112,  3222,  3212,  3224,  3214,
     &      3114,  3216,  3218,  2224,  2214,  2114,  1114,  3322,
     &      3312,  3224,  3214,  3114,  3324,  3314,  3334,  4122,
     &      4232,  4132,  4222,  4212,  4112/
      DATA (IBAM4(2,K),K=1,29)
     &   /     1,     8,    17,    20,    21,    22,    48,    49,
     &        50,    51,    52,    53,    54,    55,    56,    97,
     &        98,   104,   105,   106,   107,   108,   109,   137,
     &       138,   139,   140,   141,   142/
      DATA (IPDG5(1,K),K=1,19)
     &   /-10323,-10313,-30323,-30313,-12224,-12214,-12114,-11114,
     &    -20211,-20321,-20311,     0,     0,     0,     0,     0,
     &         0,     0,     0/
      DATA (IBAM5(1,K),K=1,19)
     &   /    42,    43,    46,    47,    71,    72,    73,    74,
     &       188,   191,   193,     0,     0,     0,     0,     0,
     &         0,     0,     0/
      DATA (IPDG5(2,K),K=1,19)
     &   / 10323, 10313, 30323, 30313, 12224, 12214, 12114, 11114,
     &     22212, 22112, 32124, 31214, 20443, 20211, 20111, 20321,
     &     20311, 12212, 12112/
      DATA (IBAM5(2,K),K=1,19)
     &   /    40,    41,    44,    45,    57,    58,    59,    60,
     &        63,    64,    65,    66,   129,   186,   187,   190,
     &       192,   208,   209/

c / DTPAIN /
c internal particle names
      DATA BTYPE / 'PROTON  ' , 'APROTON ' , 'ELECTRON' , 'POSITRON' ,
     &'NEUTRIE ' , 'ANEUTRIE' , 'PHOTON  ' , 'NEUTRON ' , 'ANEUTRON' ,
     &'MUON+   ' , 'MUON-   ' , 'KAONLONG' , 'PION+   ' , 'PION-   ' ,
     &'KAON+   ' , 'KAON-   ' , 'LAMBDA  ' , 'ALAMBDA ' , 'KAONSHRT' ,
     &'SIGMA-  ' , 'SIGMA+  ' , 'SIGMAZER' , 'PIZERO  ' , 'KAONZERO' ,
     &'AKAONZER' , 'NEUTRIM ' , 'ANEUTRIM' , 'NEUTRIT ' , 'ANEUTRIT' ,
     &'BLANK   ' /

      END
c
c===blkd46=============================================================*
c
CDECK  ID>, DT_BLKD46
      BLOCK DATA DT_BLKD46

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


c / DTPART /
c Particle  masses Engel version JETSET compatible
      DATA (AAM(K),K=1,85) /
     &   .9383D+00, .9383D+00,  AMELCT  ,  AMELCT  , .0000D+00,
     &   .0000D+00, .0000D+00, .9396D+00, .9396D+00, AMMUON   ,
     &   AMMUON   , .4977D+00, .1396D+00, .1396D+00, .4936D+00,
     &   .4936D+00, .1116D+01, .1116D+01, .4977D+00, .1197D+01,
     &   .1189D+01, .1193D+01, .1350D+00, .4977D+00, .4977D+00,
     &   .0000D+00, .0000D+00, .0000D+00, .0000D+00, .0000D+00,
     &   .5488D+00, .7669D+00, .7700D+00, .7669D+00, .7820D+00,
     &   .8921D+00, .8962D+00, .8921D+00, .8962D+00, .1300D+01,
     &   .1300D+01, .1300D+01, .1300D+01, .1421D+01, .1421D+01,
     &   .1421D+01, .1421D+01, .1383D+01, .1384D+01, .1387D+01,
     &   .1820D+01, .2030D+01, .1231D+01, .1232D+01, .1233D+01,
     &   .1234D+01, .1675D+01, .1675D+01, .1675D+01, .1675D+01,
     &   .1500D+01, .1500D+01, .1515D+01, .1515D+01, .1775D+01,
     &   .1775D+01, .1231D+01, .1232D+01, .1233D+01, .1234D+01,
     &   .1675D+01, .1675D+01, .1675D+01, .1675D+01, .1515D+01,
     &   .1515D+01, .2500D+01, .4890D+00, .4890D+00, .4890D+00,
     &   .1300D+01, .1300D+01, .1300D+01, .1300D+01, .2200D+01  /
      DATA (AAM(K),K=86,183) /
     &   .2200D+01, .2200D+01, .2200D+01, .1700D+01, .1700D+01,
     &   .1700D+01, .1700D+01, .1820D+01, .2030D+01, .9575D+00,
     &   .1019D+01, .1315D+01, .1321D+01, .1189D+01, .1193D+01,
     &   .1197D+01, .1315D+01, .1321D+01, .1383D+01, .1384D+01,
     &   .1387D+01, .1532D+01, .1535D+01, .1672D+01, .1383D+01,
     &   .1384D+01, .1387D+01, .1532D+01, .1535D+01, .1672D+01,
     &   .1865D+01, .1869D+01, .1869D+01, .1865D+01, .1969D+01,
     &   .1969D+01, .2980D+01, .2007D+01, .2010D+01, .2010D+01,
     &   .2007D+01, .2113D+01, .2113D+01, .3686D+01, .3097D+01,
     &   .1784D+01, .1784D+01, .0000D+00, .0000D+00, .0000D+00,
     &   .0000D+00, .2285D+01, .2460D+01, .2460D+01, .2452D+01,
     &   .2453D+01, .2454D+01, .2560D+01, .2560D+01, .2730D+01,
     &   .3610D+01, .3610D+01, .3790D+01, .2285D+01, .2460D+01,
     &   .2460D+01, .2452D+01, .2453D+01, .2454D+01, .2560D+01,
     &   .2560D+01, .2730D+01, .3610D+01, .3610D+01, .3790D+01,
     &   .2490D+01, .2490D+01, .2490D+01, .2610D+01, .2610D+01,
     &   .2770D+01, .3670D+01, .3670D+01, .3850D+01, .4890D+01,
     &   .2490D+01, .2490D+01, .2490D+01, .2610D+01, .2610D+01,
     &   .2770D+01, .3670D+01, .3670D+01, .3850D+01, .4890D+01,
     &   .1250D+01, .1250D+01, .1250D+01  /
      DATA (AAM ( I ), I = 184,210 ) /
     & 1.44000000000000D+00, 1.44000000000000D+00, 1.30000000000000D+00,
     & 1.30000000000000D+00, 1.30000000000000D+00, 1.40000000000000D+00,
     & 1.46000000000000D+00, 1.46000000000000D+00, 1.46000000000000D+00,
     & 1.46000000000000D+00, 1.60000000000000D+00, 1.60000000000000D+00,
     & 1.66000000000000D+00, 1.66000000000000D+00, 1.66000000000000D+00,
     & 1.66000000000000D+00, 1.66000000000000D+00, 1.66000000000000D+00,
     & 1.95000000000000D+00, 1.95000000000000D+00, 1.95000000000000D+00,
     & 1.95000000000000D+00, 2.25000000000000D+00, 2.25000000000000D+00,
     & 1.44000000000000D+00, 1.44000000000000D+00, 0.00000000000000D+00/
c Particle  mean lives
      DATA (TAU(K),K=1,183) /
     &   .1000D+19, .1000D+19, .1000D+19, .1000D+19, .1000D+19,
     &   .1000D+19, .1000D+19, .9180D+03, .9180D+03, .2200D-05,
     &   .2200D-05, .5200D-07, .2600D-07, .2600D-07, .1200D-07,
     &   .1200D-07, .2600D-09, .2600D-09, .9000D-10, .1500D-09,
     &   .8000D-10, .5000D-14, .8000D-16, .0000D+00, .0000D+00,
     &   70*.0000D+00,
     &   .0000D+00, .3000D-09, .1700D-09, .8000D-10, .1000D-13,
     &   .1500D-09, .3000D-09, .1700D-09, .0000D+00, .0000D+00,
     &   .0000D+00, .0000D+00, .0000D+00, .1000D-09, .0000D+00,
     &   .0000D+00, .0000D+00, .0000D+00, .0000D+00, .1000D-09,
     &   .0000D+00, .0000D+00, .0000D+00, .0000D+00, .0000D+00,
     &   .0000D+00, .0000D+00, .0000D+00, .0000D+00, .0000D+00,
     &   .0000D+00, .0000D+00, .0000D+00, .0000D+00, .0000D+00,
     &   .9000D-11, .9000D-11, .9000D-11, .9000D-11, .1000D+19,
     &   .1000D+19, .0000D+00, .0000D+00, .0000D+00, .0000D+00,
     &   40*.0000D+00,
     &   .0000D+00, .0000D+00, .0000D+00  /
      DATA ( TAU ( I ), I = 184,210 ) /
     & 0.00000000000000D+00, 0.00000000000000D+00, 0.00000000000000D+00,
     & 0.00000000000000D+00, 0.00000000000000D+00, 0.00000000000000D+00,
     & 0.00000000000000D+00, 0.00000000000000D+00, 0.00000000000000D+00,
     & 0.00000000000000D+00, 0.00000000000000D+00, 0.00000000000000D+00,
     & 0.00000000000000D+00, 0.00000000000000D+00, 0.00000000000000D+00,
     & 0.00000000000000D+00, 0.00000000000000D+00, 0.00000000000000D+00,
     & 0.00000000000000D+00, 0.00000000000000D+00, 0.00000000000000D+00,
     & 0.00000000000000D+00, 0.00000000000000D+00, 0.00000000000000D+00,
     & 0.00000000000000D+00, 0.00000000000000D+00, 0.00000000000000D+00/
c Resonance width Gamma in GeV
      DATA (GA(K),K=  1,85) /
     &    30*.0000D+00,
     &   .8500D-06, .1520D+00, .1520D+00, .1520D+00, .1000D-01,
     &   .7900D-01, .7900D-01, .7900D-01, .7900D-01, .4500D+00,
     &   .4500D+00, .4500D+00, .4500D+00, .1080D+00, .1080D+00,
     &   .1080D+00, .1080D+00, .5000D-01, .5000D-01, .5000D-01,
     &   .8500D-01, .1800D+00, .1150D+00, .1150D+00, .1150D+00,
     &   .1150D+00, .2000D+00, .2000D+00, .2000D+00, .2000D+00,
     &   .2000D+00, .2000D+00, .1000D+00, .1000D+00, .2000D+00,
     &   .2000D+00, .1150D+00, .1150D+00, .1150D+00, .1150D+00,
     &   .2000D+00, .2000D+00, .2000D+00, .2000D+00, .1000D+00,
     &   .1000D+00, .2000D+00, .1000D+00, .1000D+00, .1000D+00,
     &   .1000D+00, .1000D+00, .1000D+00, .1000D+00, .2000D+00  /
      DATA (GA(K),K= 86,183) /
     &   .2000D+00, .2000D+00, .2000D+00, .1500D+00, .1500D+00,
     &   .1500D+00, .1500D+00, .8500D-01, .1800D+00, .2000D-02,
     &   .4000D-02, .0000D+00, .0000D+00, .0000D+00, .0000D+00,
     &   .0000D+00, .0000D+00, .0000D+00, .3400D-01, .3400D-01,
     &   .3600D-01, .9000D-02, .9000D-02, .0000D+00, .3400D-01,
     &   .3400D-01, .3600D-01, .9000D-02, .9000D-02, .0000D+00,
     &   .0000D+00, .0000D+00, .0000D+00, .0000D+00, .0000D+00,
     &   .0000D+00, .0000D+00, .5000D-02, .2000D-02, .2000D-02,
     &   .5000D-02, .2000D-02, .2000D-02, .2000D-03, .7000D-03,
     &   50*.0000D+00,
     &   .3000D+00, .3000D+00, .3000D+00  /
      DATA ( GA ( I ), I = 184,210 ) /
     & 2.00000000000000D-01, 2.00000000000000D-01, 3.00000000000000D-01,
     & 3.00000000000000D-01, 3.00000000000000D-01, 2.70000000000000D-01,
     & 2.50000000000000D-01, 2.50000000000000D-01, 2.50000000000000D-01,
     & 2.50000000000000D-01, 1.50000000000000D-01, 1.50000000000000D-01,
     & 1.00000000000000D-01, 1.00000000000000D-01, 1.00000000000000D-01,
     & 1.00000000000000D-01, 1.00000000000000D-01, 1.00000000000000D-01,
     & 6.00000000000000D-02, 6.00000000000000D-02, 6.00000000000000D-02,
     & 6.00000000000000D-02, 5.50000000000000D-02, 5.50000000000000D-02,
     & 2.00000000000000D-01, 2.00000000000000D-01, 0.00000000000000D+00/
c Particle  names
c S+1385+Sigma+(1385)    L02030+Lambda0(2030)
c Rho77=Rho(770) Om783=Omega(783) K*14=K*(1420) and so on
c designation N*@@ means N*@1(@2)
      DATA (ANAME(K),K=1,85) /
     &  'P       ','AP      ','E-      ','E+      ','NUE     ',
     &  'ANUE    ','GAM     ','NEU     ','ANEU    ','MUE+    ',
     &  'MUE-    ','K0L     ','PI+     ','PI-     ','K+      ',
     &  'K-      ','LAM     ','ALAM    ','K0S     ','SIGM-   ',
     &  'SIGM+   ','SIGM0   ','PI0     ','K0      ','AK0     ',
     &  'BLANK   ','BLANK   ','BLANK   ','BLANK   ','BLANK   ',
     &  'ETA550  ','RHO+77  ','RHO077  ','RHO-77  ','OM0783  ',
     &  'K*+892  ','K*0892  ','K*-892  ','AK*089  ','KA+125  ',
     &  'KA0125  ','KA-125  ','AKA012  ','K*+142  ','K*0142  ',
     &  'K*-142  ','AK*014  ','S+1385  ','S01385  ','S-1385  ',
     &  'L01820  ','L02030  ','N*++12  ','N*+ 12  ','N*012   ',
     &  'N*-12   ','N*++16  ','N*+16   ','N*016   ','N*-16   ',
     &  'N*+14   ','N*014   ','N*+15   ','N*015   ','N*+18   ',
     &  'N*018   ','AN--12  ','AN*-12  ','AN*012  ','AN*+12  ',
     &  'AN--16  ','AN*-16  ','AN*016  ','AN*+16  ','AN*-15  ',
     &  'AN*015  ','DE*=24  ','RPI+49  ','RPI049  ','RPI-49  ',
     &  'PIN++   ','PIN+0   ','PIN+-   ','PIN-0   ','PPPI    ' /
      DATA (ANAME(K),K=86,183) /
     &  'PNPI    ','APPPI   ','APNPI   ','K+PPI   ','K-PPI   ',
     &  'K+NPI   ','K-NPI   ','S+1820  ','S-2030  ','ETA*    ',
     &  'PHI     ','TETA0   ','TETA-   ','ASIG-   ','ASIG0   ',
     &  'ASIG+   ','ATETA0  ','ATETA+  ','SIG*+   ','SIG*0   ',
     &  'SIG*-   ','TETA*0  ','TETA*   ','OMEGA-  ','ASIG*-  ',
     &  'ASIG*0  ','ASIG*+  ','ATET*0  ','ATET*+  ','OMEGA+  ',
     &  'D0      ','D+      ','D-      ','AD0     ','F+      ',
     &  'F-      ','ETAC    ','D*0     ','D*+     ','D*-     ',
     &  'AD*0    ','F*+     ','F*-     ','PSI     ','JPSI    ',
     &  'TAU+    ','TAU-    ','NUET    ','ANUET   ','NUEM    ',
     &  'ANUEM   ','C0+     ','A+      ','A0      ','C1++    ',
     &  'C1+     ','C10     ','S+      ','S0      ','T0      ',
     &  'XU++    ','XD+     ','XS+     ','AC0-    ','AA-     ',
     &  'AA0     ','AC1--   ','AC1-    ','AC10    ','AS-     ',
     &  'AS0     ','AT0     ','AXU--   ','AXD-    ','AXS     ',
     &  'C1*++   ','C1*+    ','C1*0    ','S*+     ','S*0     ',
     &  'T*0     ','XU*++   ','XD*+    ','XS*+    ','TETA++  ',
     &  'AC1*--  ','AC1*-   ','AC1*0   ','AS*-    ','AS*0    ',
     &  'AT*0    ','AXU*--  ','AXD*-   ','AXS*-   ','ATET--  ',
     &  'RO      ','R+      ','R-      '  /
      DATA (    ANAME ( I ), I = 184,210 ) /
     &'AN*-14  ','AN*014  ','PI+130  ','PI0130  ','PI-130  ','F01400  ',
     &'K*+146  ','K*-146  ','K*0146  ','AK0146  ','L01600  ','AL0160  ',
     &'S+1660  ','S01660  ','S-1660  ','AS-166  ','AS0166  ','AS+166  ',
     &'X01950  ','X-1950  ','AX0195  ','AX+195  ','OM-225  ','AOM+22  ',
     &'N*+14   ','N*014   ','BLANK   '/
c Charge of particles and resonances
      DATA (IICH ( I ), I =   1,210 ) /
     &  1, -1, -1,  1,  0,  0,  0,  0,  0,  1, -1,  0,  1, -1,  1,
     & -1,  0,  0,  0, -1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  1,  0, -1,  0,  1,  0, -1,  0,  1,  0, -1,  0,  1,  0,
     & -1,  0,  1,  0, -1,  0,  0,  2,  1,  0, -1,  2,  1,  0, -1,
     &  1,  0,  1,  0,  1,  0, -2, -1,  0,  1, -2, -1,  0,  1, -1,
     &  0,  1,  1,  0, -1,  2,  1,  0, -1,  2,  1,  0, -1,  2,  0,
     &  1, -1,  1, -1,  0,  0,  0, -1, -1,  0,  1,  0,  1,  1,  0,
     & -1,  0, -1, -1, -1,  0,  1,  0,  1,  1,  0,  1, -1,  0,  1,
     & -1,  0,  0,  1, -1,  0,  1, -1,  0,  0,  1, -1,  0,  0,  0,
     &  0,  1,  1,  0,  2,  1,  0,  1,  0,  0,  2,  1,  1, -1, -1,
     &  0, -2, -1,  0, -1,  0,  0, -2, -1, -1,  2,  1,  0,  1,  0,
     &  0,  2,  1,  1,  2, -2, -1,  0, -1,  0,  0, -2, -1, -1, -2,
     &  0,  1, -1, -1,  0,  1,  0, -1,  0,  1, -1,  0,  0,  0,  0,
     &  1,  0, -1, -1,  0,  1,  0, -1,  0,  1, -1,  1,  1,  0,  0/
c Particle  baryonic charges
      DATA (IIBAR ( I ), I =   1,210 ) /
     &  1, -1,  0,  0,  0,  0,  0,  1, -1,  0,  0,  0,  0,  0,  0,
     &  0,  1, -1,  0,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     &  1,  1,  1,  1,  1,  1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     & -1,  2,  0,  0,  0,  1,  1,  1,  1,  2,  2,  0,  0,  1,  1,
     &  1,  1,  1,  1,  0,  0,  1,  1, -1, -1, -1, -1, -1,  1,  1,
     &  1,  1,  1,  1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,
     &  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     &  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, -1, -1,
     & -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  1,  1,  1,  1,  1,
     &  1,  1,  1,  1,  1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     &  0,  0,  0, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  1, -1,
     &  1,  1,  1, -1, -1, -1,  1,  1, -1, -1,  1, -1,  1,  1,  0/
c First number of decay channels used for resonances
c and decaying particles
      DATA K1/   1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 16, 17,
     &  18, 24, 30, 34, 38, 40, 41, 43, 44, 136, 138, 330, 327, 328,
     &   2*330, 46, 51, 52, 54, 55, 58,
c                                                             50
     &  60, 62, 64, 66, 68, 70, 72, 74, 82, 90, 98, 106, 109, 112, 114,
     & 123, 140, 141, 143, 145, 146, 150, 157, 164, 168, 174, 180, 187,
     & 194, 202, 210, 211, 213, 215, 216, 220, 227, 234, 238, 245, 252,
c                                         85
     & 254, 255, 256, 257, 259, 262, 265, 267, 269, 272, 276, 279, 282,
     & 286, 290, 293, 299, 331, 335, 339, 340, 341, 343, 344, 345, 346,
     & 347, 350, 353, 356, 358, 360, 363, 366, 369, 372, 374, 376, 379,
     & 383, 385, 387, 391, 394, 397, 400, 402, 405, 408, 410, 412, 414,
     & 417, 420, 425, 430, 431, 432, 433, 434, 448, 452, 457, 458, 459,
     & 460, 461, 462, 466, 468, 470, 472, 486, 490, 495, 496, 497, 498,
     & 499, 500, 504, 506, 508, 510, 511, 512, 513, 514, 515, 516, 517,
     & 518, 519, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 534,
     & 537, 539, 541, 547, 553, 558, 563, 568, 572, 573, 574, 575, 576,
     & 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588, 589,
     & 590, 596, 602 /
c Last number of decay channels used for resonances
c and decaying particles
      DATA K2/   1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 15, 16, 17,
     & 23, 29, 31, 35, 39, 40, 42, 43, 45, 137, 139, 330, 327, 328,
     & 2* 330, 50, 51, 53, 54, 57,
c                                                                 50
     & 59, 61, 63, 65, 67, 69, 71, 73, 81, 89, 97, 105, 108, 111, 113,
     & 122, 135, 140, 142, 144, 145, 149, 156, 163, 167, 173, 179, 186,
     & 193, 201, 209, 210, 212, 214, 215, 219, 226, 233, 237, 244, 251,
c                                              85
     & 253, 254, 255, 256, 258, 261, 264, 266, 268, 271, 275, 278, 281,
     & 285, 289, 292, 298, 307, 334, 338, 339, 340, 342, 343, 344, 345,
     & 346, 349, 352, 355, 357, 359, 362, 365, 368, 371, 373, 375, 378,
     & 382, 384, 386, 390, 393, 396, 399, 401, 404, 407, 409, 411, 413,
     & 416, 419, 424, 429, 430, 431, 432, 433, 447, 451, 456, 457, 458,
     & 459, 460, 461, 465, 467, 469, 471, 485, 489, 494, 495, 496, 497,
     & 498, 499, 503, 505, 507, 509, 510, 511, 512, 513, 514, 515, 516,
     & 517, 518, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 533,
     & 536, 538, 540, 546, 552, 557, 562, 567, 571, 572, 573, 574, 575,
     & 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588,
     & 589, 595, 601, 602 /

       END
c
c===blkd47=============================================================*
c
CDECK  ID>, DT_BLKD47
      BLOCK DATA DT_BLKD47

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c HADRIN: decay channel information
      PARAMETER (IDMAX9=602)
      CHARACTER*8 ZKNAME
      COMMON /HNDECH/ ZKNAME(IDMAX9),WT(IDMAX9),NZK(IDMAX9,3)


c Name of decay channel
c Designation N*@ means N*@1(1236)
c @1=# means ++,  @1 = = means --
c Designation  P+/0/- means Pi+/Pi0/Pi- , respectively
      DATA (ZKNAME(K),K=  1, 85) /
     &  'P       ','AP      ','E-      ','E+      ','NUE     ',
     &  'ANUE    ','GAM     ','PE-NUE  ','APEANU  ','EANUNU  ',
     &  'E-NUAN  ','3PI0    ','PI+-0   ','PIMUNU  ','PIE-NU  ',
     &  'MU+NUE  ','MU-NUE  ','MU+NUE  ','PI+PI0  ','PI++-   ',
     &  'PI+00   ','M+P0NU  ','E+P0NU  ','MU-NU   ','PI-0    ',
     &  'PI+--   ','PI-00   ','M-P0NU  ','E-P0NU  ','PPI-    ',
     &  'NPI0    ','PD-NUE  ','PM-NUE  ','APPI+   ','ANPI0   ',
     &  'APE+NU  ','APM+NU  ','PI+PI-  ','PI0PI0  ','NPI-    ',
     &  'PPI0    ','NPI+    ','LAGA    ','GAGA    ','GAE+E-  ',
     &  'GAGA    ','GAGAP0  ','PI000   ','PI+-0   ','PI+-GA  ',
     &  'PI+0    ','PI+-    ','PI00    ','PI-0    ','PI+-0   ',
     &  'PI+-    ','PI0GA   ','K+PI0   ','K0PI+   ','KOPI0   ',
     &  'K+PI-   ','K-PI0   ','AK0PI-  ','AK0PI0  ','K-PI+   ',
     &  'K+PI0   ','K0PI+   ','K0PI0   ','K+PI-   ','K-PI0   ',
     &  'K0PI-   ','AK0PI0  ','K-PI+   ','K+PI0   ','K0PI+   ',
     &  'K+89P0  ','K08PI+  ','K+RO77  ','K0RO+7  ','K+OM07  ',
     &  'K+E055  ','K0PI0   ','K+PI+   ','K089P0  ','K+8PI-  '  /
      DATA (ZKNAME(K),K= 86,170) /
     &  'K0R077  ','K+R-77  ','K+R-77  ','K0OM07  ','K0E055  ',
     &  'K-PI0   ','K0PI-   ','K-89P0  ','AK08P-  ','K-R077  ',
     &  'AK0R-7  ','K-OM07  ','K-E055  ','AK0PI0  ','K-PI+   ',
     &  'AK08P0  ','K-8PI+  ','AK0R07  ','AK0OM7  ','AK0E05  ',
     &  'LA0PI+  ','SI0PI+  ','SI+PI0  ','LA0PI0  ','SI+PI-  ',
     &  'SI-PI+  ','LA0PI-  ','SI0PI-  ','NEUAK0  ','PK-     ',
     &  'SI+PI-  ','SI0PI0  ','SI-PI+  ','LA0ET0  ','S+1PI-  ',
     &  'S-1PI+  ','SO1PI0  ','NEUAK0  ','PK-     ','LA0PI0  ',
     &  'LA0OM0  ','LA0RO0  ','SI+RO-  ','SI-RO+  ','SI0RO0  ',
     &  'LA0ET0  ','SI0ET0  ','SI+PI-  ','SI-PI+  ','SI0PI0  ',
     &  'K0S     ','K0L     ','K0S     ','K0L     ','P PI+   ',
     &  'P PI0   ','N PI+   ','P PI-   ','N PI0   ','N PI-   ',
     &  'P PI+   ','N*#PI0  ','N*+PI+  ','PRHO+   ','P PI0   ',
     &  'N PI+   ','N*#PI-  ','N*+PI0  ','N*0PI+  ','PRHO0   ',
     &  'NRHO+   ','P PI-   ','N PI0   ','N*+PI-  ','N*0PI0  ',
     &  'N*-PI+  ','PRHO-   ','NRHO0   ','N PI-   ','N*0PI-  ',
     &  'N*-PI0  ','NRHO-   ','PETA0   ','N*#PI-  ','N*+PI0  '  /
      DATA (ZKNAME(K),K=171,255) /
     &  'N*0PI+  ','PRHO0   ','NRHO+   ','NETA0   ','N*+PI-  ',
     &  'N*0PI0  ','N*-PI+  ','PRHO-   ','NRHO0   ','P PI0   ',
     &  'N PI+   ','N*#PI-  ','N*+PI0  ','N*0PI+  ','PRHO0   ',
     &  'NRHO+   ','P PI-   ','N PI0   ','N*+PI-  ','N*0PI0  ',
     &  'N*-PI+  ','PRHO-   ','NRHO0   ','P PI0   ','N PI+   ',
     &  'PRHO0   ','NRHO+   ','LAMK+   ','S+ K0   ','S0 K+   ',
     &  'PETA0   ','P PI-   ','N PI0   ','PRHO-   ','NRHO0   ',
     &  'LAMK0   ','S0 K0   ','S- K+   ','NETA/   ','APPI-   ',
     &  'APPI0   ','ANPI-   ','APPI+   ','ANPI0   ','ANPI+   ',
     &  'APPI-   ','AN*=P0  ','AN*-P-  ','APRHO-  ','APPI0   ',
     &  'ANPI-   ','AN*=P+  ','AN*-P0  ','AN*0P-  ','APRHO0  ',
     &  'ANRHO-  ','APPI+   ','ANPI0   ','AN*-P+  ','AN*0P0  ',
     &  'AN*+P-  ','APRHO+  ','ANRHO0  ','ANPI+   ','AN*0P+  ',
     &  'AN*+P0  ','ANRHO+  ','APPI0   ','ANPI-   ','AN*=P+  ',
     &  'AN*-P0  ','AN*0P-  ','APRHO0  ','ANRHO-  ','APPI+,  ',
     &  'ANPI0   ','AN*-P+  ','AN*0P0  ','AN*+P-  ','APRHO+  ',
     &  'ANRHO0  ','PN*014  ','NN*=14  ','PI+0    ','PI+-    '  /
      DATA (ZKNAME(K),K=256,340) /
     &  'PI-0    ','P+0     ','N++     ','P+-     ','P00     ',
     &  'N+0     ','N+-     ','N00     ','P-0     ','N-0     ',
     &  'P--     ','PPPI0   ','PNPI+   ','PNPI0   ','PPPI-   ',
     &  'NNPI+   ','APPPI0  ','APNPI+  ','ANNPI0  ','ANPPI-  ',
     &  'APNPI0  ','APPPI-  ','ANNPI-  ','K+PPI0  ','K+NPI+  ',
     &  'K0PPI0  ','K-PPI0  ','K-NPI+  ','AKPPI-  ','AKNPI0  ',
     &  'K+NPI0  ','K+PPI-  ','K0PPI0  ','K0NPI+  ','K-NPI0  ',
     &  'K-PPI-  ','AKNPI-  ','PAK0    ','SI+PI0  ','SI0PI+  ',
     &  'SI+ETA  ','S+1PI0  ','S01PI+  ','NEUK-   ','LA0PI-  ',
     &  'SI-OM0  ','LA0RO-  ','SI0RO-  ','SI-RO0  ','SI-ET0  ',
     &  'SI0PI-  ','SI-0    ','BLANC   ','BLANC   ','BLANC   ',
     &  'BLANC   ','BLANC   ','BLANC   ','BLANC   ','BLANC   ',
     &  'BLANC   ','BLANC   ','BLANC   ','BLANC   ','BLANC   ',
     &  'BLANC   ','BLANC   ','BLANC   ','BLANC   ','BLANC   ',
     &  'BLANC   ','BLANC   ','BLANC   ','BLANC   ','BLANC   ',
     &  'EPI+-   ','EPI00   ','GAPI+-  ','GAGA*   ','K+-     ',
     &  'KLKS    ','PI+-0   ','EGA     ','LPI0    ','LPI     '  /
      DATA (ZKNAME(K),K=341,425) /
     &  'APPI0   ','ANPI-   ','ALAGA   ','ANPI    ','ALPI0   ',
     &  'ALPI+   ','LAPI+   ','SI+PI0  ','SI0PI+  ','LAPI0   ',
     &  'SI+PI-  ','SI-PI+  ','LAPI-   ','SI-PI0  ','SI0PI-  ',
     &  'TE0PI0  ','TE-PI+  ','TE0PI-  ','TE-PI0  ','TE0PI   ',
     &  'TE-PI   ','LAK-    ','ALPI-   ','AS-PI0  ','AS0PI-  ',
     &  'ALPI0   ','AS+PI-  ','AS-PI+  ','ALPI+   ','AS+PI0  ',
     &  'AS0PI+  ','AT0PI0  ','AT+PI-  ','AT0PI+  ','AT+PI0  ',
     &  'AT0PI   ','AT+PI   ','ALK+    ','K-PI+   ','K-PI+0  ',
     &  'K0PI+-  ','K0PI0   ','K-PI++  ','AK0PI+  ','K+PI--  ',
     &  'K0PI-   ','K+PI-   ','K+PI-0  ','AKPI-+  ','AK0PI0  ',
     &  'ETAPIF  ','K++-    ','K+AK0   ','ETAPI-  ','K--+    ',
     &  'K-K0    ','PI00    ','PI+-    ','GAGA    ','D0PI0   ',
     &  'D0GA    ','D0PI+   ','D+PI0   ','DFGA    ','AD0PI-  ',
     &  'D-PI0   ','D-GA    ','AD0PI0  ','AD0GA   ','F+GA    ',
     &  'F+GA    ','F-GA    ','F-GA    ','PSPI+-  ','PSPI00  ',
     &  'PSETA   ','E+E-    ','MUE+-   ','PI+-0   ','M+NN    ',
     &  'E+NN    ','RHO+NT  ','PI+ANT  ','K*+ANT  ','M-NN    '  /
      DATA (ZKNAME(K),K=426,510) /
     &  'E-NN    ','RHO-NT  ','PI-NT   ','K*-NT   ','NUET    ',
     &  'ANUET   ','NUEM    ','ANUEM   ','SI+ETA  ','SI+ET*  ',
     &  'PAK0    ','TET0K+  ','SI*+ET  ','N*+AK0  ','N*++K-  ',
     &  'LAMRO+  ','SI0RO+  ','SI+RO0  ','SI+OME  ','PAK*0   ',
     &  'N*+AK*  ','N*++K*  ','SI+AK0  ','TET0PI  ','SI+AK*  ',
     &  'TET0RO  ','SI0AK*  ','SI+K*-  ','TET0OM  ','TET-RO  ',
     &  'SI*0AK  ','C0+PI+  ','C0+PI0  ','C0+PI-  ','A+GAM   ',
     &  'A0GAM   ','TET0AK  ','TET0K*  ','OM-RO+  ','OM-PI+  ',
     &  'C1++AK  ','A+PI+   ','C0+AK0  ','A0PI+   ','A+AK0   ',
     &  'T0PI+   ','ASI-ET  ','ASI-E*  ','APK0    ','ATET0K  ',
     &  'ASI*-E  ','AN*-K0  ','AN*--K  ','ALAMRO  ','ASI0RO  ',
     &  'ASI-RO  ','ASI-OM  ','APK*0   ','AN*-K*  ','AN*--K  ',
     &  'ASI-K0  ','ATETPI  ','ASI-K*  ','ATETRO  ','ASI0K*  ',
     &  'ASI-K*  ','ATE0OM  ','ATE+RO  ','ASI*0K  ','AC-PI-  ',
     &  'AC-PI0  ','AC-PI+  ','AA-GAM  ','AA0GAM  ','ATET0K  ',
     &  'ATE0K*  ','AOM+RO  ','AOM+PI  ','AC1--K  ','AA-PI-  ',
     &  'AC0-K0  ','AA0PI-  ','AA-K0   ','AT0PI-  ','C1++GA  '  /
      DATA (ZKNAME(K),K=511,540) /
     &  'C1++GA  ','C10GAM  ','S+GAM   ','S0GAM   ','T0GAM   ',
     &  'XU++GA  ','XD+GAM  ','XS+GAM  ','A+AKPI  ','T02PI+  ',
     &  'C1++2K  ','AC1--G  ','AC1-GA  ','AC10GA  ','AS-GAM  ',
     &  'AS0GAM  ','AT0GAM  ','AXU--G  ','AXD-GA  ','AXS-GA  ',
     &  'AA-KPI  ','AT02PI  ','AC1--K  ','RH-PI+  ','RH+PI-  ',
     &  'RH3PI0  ','RH0PI+  ','RH+PI0  ','RH0PI-  ','RH-PI0  '  /
      DATA (ZKNAME(I),I=541,602)/
     & 'APETA ','AN=P+ ','AN-PO ','ANOPO ','APRHO0','ANRHO-','ANETA ',
     & 'AN-P+ ','AN0PO ','AN+P- ','APRHO+','ANRHO0','RH0PI+','RH+PI0',
     & '3PI+00','3PI-++','F0PI+ ','RH+PI-','RH0PI0','3PI000','3PI0+-',
     & 'F0PI0 ','RH0PI-','RH-PI0','3PI-00','3PI--+','F0PI- ','PI0PI0',
     & 'PI+PI-','K+K-  ','K0AK0 ','L01600','AL0160','K*+146','K*-146',
     & 'K*0146','AK0146','S+1660','S01660','S-1660','AS-166','AS0166',
     & 'AS+166','X01690','X-1690','AX0169','AX+169','OM-225','AOM+22',
     & 'N*PPI0','N*NPI+','N*P2P0','N*PP+-','N*D+P0','N*D0P+','N*NPI0',
     & 'N*PPI-','N*N2P0','N*NP+-','N*D+P-','N*D0P0','BLANK '/
c Weight of decay channel
      DATA (WT(K),K=  1, 85) /
     &   .1000D+01, .1000D+01, .1000D+01, .1000D+01, .1000D+01,
     &   .1000D+01, .1000D+01, .1000D+01, .1000D+01, .1000D+01,
     &   .1000D+01, .2100D+00, .1200D+00, .2700D+00, .4000D+00,
     &   .1000D+01, .1000D+01, .6400D+00, .2100D+00, .6000D-01,
     &   .2000D-01, .3000D-01, .4000D-01, .6400D+00, .2100D+00,
     &   .6000D-01, .2000D-01, .3000D-01, .4000D-01, .6400D+00,
     &   .3600D+00, .0000D+00, .0000D+00, .6400D+00, .3600D+00,
     &   .0000D+00, .0000D+00, .6900D+00, .3100D+00, .1000D+01,
     &   .5200D+00, .4800D+00, .1000D+01, .9900D+00, .1000D-01,
     &   .3800D+00, .3000D-01, .3000D+00, .2400D+00, .5000D-01,
     &   .1000D+01, .1000D+01, .0000D+00, .1000D+01, .9000D+00,
     &   .1000D-01, .9000D-01, .3300D+00, .6700D+00, .3300D+00,
     &   .6700D+00, .3300D+00, .6700D+00, .3300D+00, .6700D+00,
     &   .3300D+00, .6700D+00, .3300D+00, .6700D+00, .3300D+00,
     &   .6700D+00, .3300D+00, .6700D+00, .1900D+00, .3800D+00,
     &   .9000D-01, .2000D+00, .3000D-01, .4000D-01, .5000D-01,
     &   .2000D-01, .1900D+00, .3800D+00, .9000D-01, .2000D+00  /
      DATA (WT(K),K= 86,170) /
     &   .3000D-01, .4000D-01, .5000D-01, .2000D-01, .1900D+00,
     &   .3800D+00, .9000D-01, .2000D+00, .3000D-01, .4000D-01,
     &   .5000D-01, .2000D-01, .1900D+00, .3800D+00, .9000D-01,
     &   .2000D+00, .3000D-01, .4000D-01, .5000D-01, .2000D-01,
     &   .8800D+00, .6000D-01, .6000D-01, .8800D+00, .6000D-01,
     &   .6000D-01, .8800D+00, .1200D+00, .1900D+00, .1900D+00,
     &   .1600D+00, .1600D+00, .1700D+00, .3000D-01, .3000D-01,
     &   .3000D-01, .4000D-01, .1000D+00, .1000D+00, .2000D+00,
     &   .1200D+00, .1000D+00, .4000D-01, .4000D-01, .5000D-01,
     &   .7500D-01, .7500D-01, .3000D-01, .3000D-01, .4000D-01,
     &   .5000D+00, .5000D+00, .5000D+00, .5000D+00, .1000D+01,
     &   .6700D+00, .3300D+00, .3300D+00, .6700D+00, .1000D+01,
     &   .2500D+00, .2700D+00, .1800D+00, .3000D+00, .1700D+00,
     &   .8000D-01, .1800D+00, .3000D-01, .2400D+00, .2000D+00,
     &   .1000D+00, .8000D-01, .1700D+00, .2400D+00, .3000D-01,
     &   .1800D+00, .1000D+00, .2000D+00, .2500D+00, .1800D+00,
     &   .2700D+00, .3000D+00, .4000D+00, .2000D+00, .1250D+00  /
      DATA (WT(K),K=171,255) /
     &   .7500D-01, .7500D-01, .1250D+00, .4000D+00, .7500D-01,
     &   .1250D+00, .2000D+00, .1250D+00, .7500D-01, .1800D+00,
     &   .3700D+00, .1300D+00, .8000D-01, .4000D-01, .7000D-01,
     &   .1300D+00, .3700D+00, .1800D+00, .4000D-01, .8000D-01,
     &   .1300D+00, .1300D+00, .7000D-01, .7000D-01, .1300D+00,
     &   .2300D+00, .4700D+00, .5000D-01, .2000D-01, .1000D-01,
     &   .2000D-01, .1300D+00, .7000D-01, .4700D+00, .2300D+00,
     &   .5000D-01, .1000D-01, .2000D-01, .2000D-01, .1000D+01,
     &   .6700D+00, .3300D+00, .3300D+00, .6700D+00, .1000D+01,
     &   .2500D+00, .2700D+00, .1800D+00, .3000D+00, .1700D+00,
     &   .8000D-01, .1800D+00, .3000D-01, .2400D+00, .2000D+00,
     &   .1000D+00, .8000D-01, .1700D+00, .2400D+00, .3000D-01,
     &   .1800D+00, .1000D+00, .2000D+00, .2500D+00, .1800D+00,
     &   .2700D+00, .3000D+00, .1800D+00, .3700D+00, .1300D+00,
     &   .8000D-01, .4000D-01, .7000D-01, .1300D+00, .3700D+00,
     &   .1800D+00, .4000D-01, .8000D-01, .1300D+00, .1300D+00,
     &   .7000D-01, .5000D+00, .5000D+00, .1000D+01, .1000D+01  /
      DATA (WT(K),K=256,340) /
     &   .1000D+01, .8000D+00, .2000D+00, .6000D+00, .3000D+00,
     &   .1000D+00, .6000D+00, .3000D+00, .1000D+00, .8000D+00,
     &   .2000D+00, .3300D+00, .6700D+00, .6600D+00, .1700D+00,
     &   .1700D+00, .3200D+00, .1700D+00, .3200D+00, .1900D+00,
     &   .3300D+00, .3300D+00, .3400D+00, .3000D+00, .5000D-01,
     &   .6500D+00, .3800D+00, .1200D+00, .3800D+00, .1200D+00,
     &   .3800D+00, .1200D+00, .3800D+00, .1200D+00, .3000D+00,
     &   .5000D-01, .6500D+00, .3800D+00, .2500D+00, .2500D+00,
     &   .2000D-01, .5000D-01, .5000D-01, .2000D+00, .2000D+00,
     &   .1200D+00, .1000D+00, .7000D-01, .7000D-01, .1400D+00,
     &   .5000D-01, .5000D-01, .1000D+01, .1000D+01, .1000D+01,
     &   .1000D+01, .1000D+01, .1000D+01, .1000D+01, .1000D+01,
     &   .1000D+01, .1000D+01, .1000D+01, .1000D+01, .1000D+01,
     &   .1000D+01, .1000D+01, .1000D+01, .1000D+01, .1000D+01,
     &   .1000D+01, .1000D+01, .1000D+01, .1000D+01, .1000D+01,
     &   .4800D+00, .2400D+00, .2600D+00, .2000D-01, .4700D+00,
     &   .3500D+00, .1500D+00, .3000D-01, .1000D+01, .1000D+01  /
      DATA (WT(K),K=341,425) /
     &   .5200D+00, .4800D+00, .1000D+01, .1000D+01, .1000D+01,
     &   .1000D+01, .9000D+00, .5000D-01, .5000D-01, .9000D+00,
     &   .5000D-01, .5000D-01, .9000D+00, .5000D-01, .5000D-01,
     &   .3300D+00, .6700D+00, .6700D+00, .3300D+00, .2500D+00,
     &   .2500D+00, .5000D+00, .9000D+00, .5000D-01, .5000D-01,
     &   .9000D+00, .5000D-01, .5000D-01, .9000D+00, .5000D-01,
     &   .5000D-01, .3300D+00, .6700D+00, .6700D+00, .3300D+00,
     &   .2500D+00, .2500D+00, .5000D+00, .1000D+00, .5000D+00,
     &   .1600D+00, .2400D+00, .7000D+00, .3000D+00, .7000D+00,
     &   .3000D+00, .1000D+00, .5000D+00, .1600D+00, .2400D+00,
     &   .3000D+00, .4000D+00, .3000D+00, .3000D+00, .4000D+00,
     &   .3000D+00, .4900D+00, .4900D+00, .2000D-01, .5500D+00,
     &   .4500D+00, .6800D+00, .3000D+00, .2000D-01, .6800D+00,
     &   .3000D+00, .2000D-01, .5500D+00, .4500D+00, .9000D+00,
     &   .1000D+00, .9000D+00, .1000D+00, .6000D+00, .3000D+00,
     &   .1000D+00, .1000D+00, .1000D+00, .8000D+00, .2800D+00,
     &   .2800D+00, .3500D+00, .7000D-01, .2000D-01, .2800D+00  /
      DATA (WT(K),K=426,510) /
     &   .2800D+00, .3500D+00, .7000D-01, .2000D-01, .1000D+01,
     &   .1000D+01, .1000D+01, .1000D+01, .2000D-01, .3000D-01,
     &   .7000D-01, .2000D-01, .2000D-01, .4000D-01, .1300D+00,
     &   .7000D-01, .6000D-01, .6000D-01, .2000D+00, .1400D+00,
     &   .4000D-01, .1000D+00, .2500D+00, .3000D-01, .3000D+00,
     &   .4200D+00, .2200D+00, .3500D+00, .1900D+00, .1600D+00,
     &   .8000D-01, .1000D+01, .1000D+01, .1000D+01, .1000D+01,
     &   .1000D+01, .3700D+00, .2000D+00, .3600D+00, .7000D-01,
     &   .5000D+00, .5000D+00, .5000D+00, .5000D+00, .5000D+00,
     &   .5000D+00, .2000D-01, .3000D-01, .7000D-01, .2000D-01,
     &   .2000D-01, .4000D-01, .1300D+00, .7000D-01, .6000D-01,
     &   .6000D-01, .2000D+00, .1400D+00, .4000D-01, .1000D+00,
     &   .2500D+00, .3000D-01, .3000D+00, .4200D+00, .2200D+00,
     &   .3500D+00, .1900D+00, .1600D+00, .8000D-01, .1000D+01,
     &   .1000D+01, .1000D+01, .1000D+01, .1000D+01, .3700D+00,
     &   .2000D+00, .3600D+00, .7000D-01, .5000D+00, .5000D+00,
     &   .5000D+00, .5000D+00, .5000D+00, .5000D+00, .1000D+01  /
      DATA (WT(K),K=511,540) /
     &   .1000D+01, .1000D+01, .1000D+01, .1000D+01, .1000D+01,
     &   .1000D+01, .1000D+01, .1000D+01, .3000D+00, .3000D+00,
     &   .4000D+00, .1000D+01, .1000D+01, .1000D+01, .1000D+01,
     &   .1000D+01, .1000D+01, .1000D+01, .1000D+01, .1000D+01,
     &   .3000D+00, .3000D+00, .4000D+00, .3300D+00, .3300D+00,
     &   .3400D+00, .5000D+00, .5000D+00, .5000D+00, .5000D+00  /
C
      DATA (WT(I),I=541,602) / .0D+00, .3334D+00, .2083D+00, 2*.125D+00,
     & .2083D+00, .0D+00, .125D+00, .2083D+00, .3334D+00, .2083D+00,
     & .125D+00,  0.2D+00, 0.2D+00, 0.3D+00, 0.3D+00, 0.0D+00, 0.2D+00,
     & 0.2D+00, 0.3D+00, 0.3D+00, 0.0D+00, 0.2D+00, 0.2D+00, 0.3D+00,
     & 0.3D+00, 0.0D+00, 0.31D+00, 0.62D+00, 0.035D+00, 0.035D+00,
     & 18*1.D+00, 0.5D+00, 0.16D+00, 2*0.12D+00, 2*0.05D+00, 0.5D+00,
     & 0.16D+00, 2*0.12D+00, 2*0.05D+00, 1.D+00 /
c Particle numbers in decay channel
      DATA (NZK(K,1),K=  1,170) /
     &     1,   2,   3,   4,   5,   6,   7,   1,   2,   4,
     &     3,  23,  13,  13,  13,  10,  11,  10,  13,  13,
     &    13,  10,   4,  11,  14,  14,  14,  11,   3,   1,
     &     8,   1,   1,   2,   9,   2,   2,  13,  23,   8,
     &     1,   8,  17,   7,   7,   7,  23,  23,  13,  13,
     &    13,  13,  23,  14,  13,  13,  23,  15,  24,  24,
     &    15,  16,  25,  25,  16,  15,  24,  24,  15,  16,
     &    24,  25,  16,  15,  24,  36,  37,  15,  24,  15,
     &    15,  24,  15,  37,  36,  24,  15,  24,  24,  16,
     &    24,  38,  39,  16,  25,  16,  16,  25,  16,  39,
     &    38,  25,  16,  25,  25,  17,  22,  21,  17,  21,
     &    20,  17,  22,   8,   1,  21,  22,  20,  17,  48,
     &    50,  49,   8,   1,  17,  17,  17,  21,  20,  22,
     &    17,  22,  21,  20,  22,  19,  12,  19,  12,   1,
     &     1,   8,   1,   8,   8,   1,  53,  54,   1,   1,
     &     8,  53,  54,  55,   1,   8,   1,   8,  54,  55,
     &    56,   1,   8,   8,  55,  56,   8,   1,  53,  54  /
      DATA (NZK(K,1),K=171,340) /
     &    55,   1,   8,   8,  54,  55,  56,   1,   8,   1,
     &     8,  53,  54,  55,   1,   8,   1,   8,  54,  55,
     &    56,   1,   8,   1,   8,   1,   8,  17,  21,  22,
     &     1,   1,   8,   1,   8,  17,  22,  20,   8,   2,
     &     2,   9,   2,   9,   9,   2,  67,  68,   2,   2,
     &     9,  67,  68,  69,   2,   9,   2,   9,  68,  69,
     &    70,   2,   9,   9,  69,  70,   9,   2,   9,  67,
     &    68,  69,   2,   9,   2,   9,  68,  69,  70,   2,
     &     9,   1,   8,  13,  13,  14,   1,   8,   1,   1,
     &     8,   8,   8,   1,   8,   1,   1,   1,   1,   1,
     &     8,   2,   2,   9,   9,   2,   2,   9,  15,  15,
     &    24,  16,  16,  25,  25,  15,  15,  24,  24,  16,
     &    16,  25,   1,  21,  22,  21,  48,  49,   8,  17,
     &    20,  17,  22,  20,  20,  22,  20,   0,   0,   0,
     &     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     &     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     &    31,  31,  13,   7,  15,  12,  13,  31,  17,  17  /
      DATA (NZK(K,1),K=341,510) /
     &     2,   9,  18,   9,  18,  18,  17,  21,  22,  17,
     &    21,  20,  17,  20,  22,  97,  98,  97,  98,  97,
     &    98,  17,  18,  99, 100,  18, 101,  99,  18, 101,
     &   100, 102, 103, 102, 103, 102, 103,  18,  16,  16,
     &    24,  24,  16,  25,  15,  24,  15,  15,  25,  25,
     &    31,  15,  15,  31,  16,  16,  23,  13,   7, 116,
     &   116, 116, 117, 117, 119, 118, 118, 119, 119, 120,
     &   120, 121, 121, 130, 130, 130,   4,  10,  13,  10,
     &     4,  32,  13,  36,  11,   3,  34,  14,  38, 133,
     &   134, 135, 136,  21,  21,   1,  97, 104,  54,  53,
     &    17,  22,  21,  21,   1,  54,  53,  21,  97,  21,
     &    97,  22,  21,  97,  98, 105, 137, 137, 137, 138,
     &   139,  97,  97, 109, 109, 140, 138, 137, 139, 138,
     &   145,  99,  99,   2, 102, 110,  68,  67,  18, 100,
     &    99,  99,   2,  68,  67,  99, 102,  99, 102, 100,
     &    99, 102, 103, 111, 149, 149, 149, 150, 151, 113,
     &   113, 115, 115, 152, 150, 149, 151, 150, 157, 140  /
      DATA (NZK(K,1),K=511,540) /
     &   141, 142, 143, 144, 145, 146, 147, 148, 138, 145,
     &   140, 152, 153, 154, 155, 156, 157, 158, 159, 160,
     &   150, 157, 152,  34,  32,  33,  33,  32,  33,  34  /
      DATA (NZK(I,1),I=541,602) /  2, 67, 68, 69,  2,  9,  9, 68, 69,
     & 70,  2,  9, 33, 32, 13, 14, 189, 32, 34, 23, 23, 189, 33, 34, 14,
     & 14, 189, 23, 13, 15, 24,  36,  38,  37,  39, 194, 195, 196, 197,
     & 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 1, 8, 1, 1, 54,
     & 55, 8, 1, 8, 8, 54, 55, 210/
      DATA (NZK(K,2),K=  1,170) /
     &     0,   0,   0,   0,   0,   0,   0,   3,   4,   6,
     &     5,  23,  14,  11,   3,   5,   5,   5,  23,  13,
     &    23,  23,  23,   5,  23,  13,  23,  23,  23,  14,
     &    23,   3,  11,  13,  23,   4,  10,  14,  23,  14,
     &    23,  13,   7,   7,   4,   7,   7,  23,  14,  14,
     &    23,  14,  23,  23,  14,  14,   7,  23,  13,  23,
     &    14,  23,  14,  23,  13,  23,  13,  23,  14,  23,
     &    14,  23,  13,  23,  13,  23,  13,  33,  32,  35,
     &    31,  23,  14,  23,  14,  33,  34,  35,  31,  23,
     &    14,  23,  14,  33,  34,  35,  31,  23,  13,  23,
     &    13,  33,  32,  35,  31,  13,  13,  23,  23,  14,
     &    13,  14,  14,  25,  16,  14,  23,  13,  31,  14,
     &    13,  23,  25,  16,  23,  35,  33,  34,  32,  33,
     &    31,  31,  14,  13,  23,   0,   0,   0,   0,  13,
     &    23,  13,  14,  23,  14,  13,  23,  13,  78,  23,
     &    13,  14,  23,  13,  79,  78,  14,  23,  14,  23,
     &    13,  80,  79,  14,  14,  23,  80,  31,  14,  23  /
      DATA (NZK(K,2),K=171,340) /
     &    13,  79,  78,  31,  14,  23,  13,  80,  79,  23,
     &    13,  14,  23,  13,  79,  78,  14,  23,  14,  23,
     &    13,  80,  79,  23,  13,  33,  32,  15,  24,  15,
     &    31,  14,  23,  34,  33,  24,  24,  15,  31,  14,
     &    23,  14,  13,  23,  13,  14,  23,  14,  80,  23,
     &    14,  13,  23,  14,  79,  80,  13,  23,  13,  23,
     &    14,  78,  79,  13,  13,  23,  78,  23,  14,  13,
     &    23,  14,  79,  80,  13,  23,  13,  23,  14,  78,
     &    79,  62,  61,  23,  14,  23,  13,  13,  13,  23,
     &    13,  13,  23,  14,  14,  14,   1,   8,   8,   1,
     &     8,   1,   8,   8,   1,   8,   1,   8,   1,   8,
     &     1,   1,   8,   1,   8,   8,   1,   1,   8,   8,
     &     1,   8,  25,  23,  13,  31,  23,  13,  16,  14,
     &    35,  34,  34,  33,  31,  14,  23,   0,   0,   0,
     &     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     &     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     &    13,  23,  14,   7,  16,  19,  14,   7,  23,  14  /
      DATA (NZK(K,2),K=341,510) /
     &    23,  14,   7,  13,  23,  13,  13,  23,  13,  23,
     &    14,  13,  14,  23,  14,  23,  13,  14,  23,  14,
     &    23,  16,  14,  23,  14,  23,  14,  13,  13,  23,
     &    13,  23,  14,  13,  23,  13,  23,  15,  13,  13,
     &    13,  23,  13,  13,  14,  14,  14,  14,  14,  23,
     &    13,  16,  25,  14,  15,  24,  23,  14,   7,  23,
     &     7,  13,  23,   7,  14,  23,   7,  23,   7,   7,
     &     7,   7,   7,  13,  23,  31,   3,  11,  14, 135,
     &     5, 134, 134, 134, 136,   6, 133, 133, 133,   0,
     &     0,   0,   0,  31,  95,  25,  15,  31,  95,  16,
     &    32,  32,  33,  35,  39,  39,  38,  25,  13,  39,
     &    32,  39,  38,  35,  32,  39,  13,  23,  14,   7,
     &     7,  25,  37,  32,  13,  25,  13,  25,  13,  25,
     &    13,  31,  95,  24,  16,  31,  24,  15,  34,  34,
     &    33,  35,  37,  37,  36,  24,  14,  37,  34,  37,
     &    36,  35,  34,  37,  14,  23,  13,   7,   7,  24,
     &    39,  34,  14,  24,  14,  24,  14,  24,  14,   7  /
      DATA (NZK(K,2),K=511,540) /
     &     7,   7,   7,   7,   7,   7,   7,   7,  25,  13,
     &    25,   7,   7,   7,   7,   7,   7,   7,   7,   7,
     &    24,  14,  24,  13,  14,  23,  13,  23,  14,  23  /
      DATA (NZK(I,2),I=541,602) / 31, 13, 23, 14, 79, 80, 31, 13, 23,
     & 14, 78, 79, 13, 23, 23, 13, 13, 14, 13, 23, 13, 23, 14, 23, 23,
     & 14, 14, 23, 14, 16, 25,
     & 4*23, 14*0, 23, 13, 23, 13, 23, 13, 23, 14,
     & 23, 13, 14, 23,  0 /
      DATA (NZK(K,3),K=  1,170) /
     &     0,   0,   0,   0,   0,   0,   0,   5,   6,   5,
     &     6,  23,  23,   5,   5,   0,   0,   0,   0,  14,
     &    23,   5,   5,   0,   0,  14,  23,   5,   5,   0,
     &     0,   5,   5,   0,   0,   5,   5,   0,   0,   0,
     &     0,   0,   0,   0,   3,   0,   7,  23,  23,   7,
     &     0,   0,   0,   0,  23,   0,   0,   0,   0,   0,
     &     110*0   /
      DATA (NZK(K,3),K=171,340) /
     &     80*0,
     &     0,   0,   0,   0,   0,   0,  23,  13,  14,  23,
     &    23,  14,  23,  23,  23,  14,  23,  13,  23,  14,
     &    13,  23,  13,  23,  14,  23,  14,  14,  23,  13,
     &    13,  23,  13,  14,  23,  23,  14,  23,  13,  23,
     &    14,  14,   0,   0,   0,   0,   0,   0,   0,   0,
     &     30*0,
     &    14,  23,   7,   0,   0,   0,  23,   0,   0,   0  /
      DATA (NZK(K,3),K=341,510) /
     &     30*0,
     &     0,   0,   0,   0,   0,   0,   0,   0,   0,  23,
     &    14,   0,  13,   0,  14,   0,   0,  23,  13,   0,
     &     0,  15,   0,   0,  16,   0,   0,   0,   0,   0,
     &     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     &     0,   0,   0,  14,  23,   0,   0,   0,  23, 134,
     &   134,   0,   0,   0, 133, 133,   0,   0,   0,   0,
     &     80*0  /
      DATA (NZK(K,3),K=511,540) /
     &     0,   0,   0,   0,   0,   0,   0,   0,  13,  13,
     &    25,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     &    14,  14,  24,   0,   0,   0,   0,   0,   0,   0  /
      DATA (NZK(I,3),I=541,602) / 12*0, 2*0, 23, 13, 0, 2*0, 23, 14, 0,
     & 2*0, 23, 13, 0, 4*0, 18*0, 2*0, 23, 14, 2*0, 2*0, 23, 14, 2*0, 0/

      END
c*sr 20.4.98 nucdum ===================================================*
c
c===bamfra=============================================================*
c
C     SUBROUTINE XAMFRA(NNCH,I1,I2,IFB11,IFB22,IFB33,IFB44,
CDECK  ID>, DT_BAMFRA
      SUBROUTINE DT_BAMFRA(NNCH,I1,I2,IFB11,IFB22,IFB33,IFB44,
     &                                     AMCH,NOBAM,IHAD)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      WRITE(ErrorOut,1000)
 1000 FORMAT(1X,'BAMFRA:   BAMJET-FRAGMENTATION NOT SUPPORTED')
      STOP

      END
c
c====evevap============================================================*
c
CDECK  ID>, DT_XVEVAP
      SUBROUTINE DT_XVEVAP(WE)
C     SUBROUTINE DT_EVEVAP(WE)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME


      LEVAPO = .FALSE.

      RETURN
      END
c
c====frbkin============================================================*
c
CDECK  ID>, DT_XRBKIN
      SUBROUTINE DT_XRBKIN(LDUM1,LDUM2)
C     SUBROUTINE DT_FRBKIN(LDUM1,LDUM2)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      LOGICAL LDUM1,LDUM2

      RETURN
      END
c
c====phoini============================================================*
c
CDECK  ID>, DT_XHOINI
      SUBROUTINE DT_XHOINI
C     SUBROUTINE DT_PHOINI

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      RETURN
      END
c
c====eventb============================================================*
c
CDECK  ID>, DT_XVENTB
      SUBROUTINE DT_XVENTB(NCSY,IREJ)
C     SUBROUTINE DT_EVENTB(NCSY,IREJ)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      WRITE(ErrorOut,1000)
 1000 FORMAT(1X,'EVENTB:   PHOJET-PACKAGE REQUESTED BUT NOT LINKED!')
      STOP

      END
c
c===event==============================================================*
c
CDECK  ID>, DT_XVENT
      SUBROUTINE DT_XVENT(IDUM,PP,PT,DUM,IREJ)
C     SUBROUTINE EVENT(IDUM,PP,PT,DUM,IREJ)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      DIMENSION PP(4),PT(4)

      RETURN
      END
c
c===pohisx=============================================================*
c
CDECK  ID>, DT_XOHISX
      SUBROUTINE DT_XOHISX(I,X)
C     SUBROUTINE POHISX(I,X)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      RETURN
      END
c
c===poluhi=============================================================*
c
c*PHOJET105a
C     SUBROUTINE XOLUHI(I,X)
c*PHOJET112

CDECK  ID>, PHO_LHIST
      SUBROUTINE PHO_LHIST(I,X)

c*

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      RETURN
      END
c
CDECK  ID>, PDFSET
C**********************************************************************
C
C   dummy subroutines, remove to link PDFLIB
C
C**********************************************************************
      SUBROUTINE PDFSET(PARAM,VALUE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION PARAM(20),VALUE(20)
      CHARACTER*20 PARAM
      END
CDECK  ID>, STRUCTM
      SUBROUTINE STRUCTM(XI,SCALE2,UV,DV,US,DS,SS,CS,BS,TS,GL)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      END
CDECK  ID>, STRUCTP
      SUBROUTINE STRUCTP(XI,SCALE2,P2,IP2,UV,DV,US,DS,SS,CS,BS,TS,GL)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      END
c
c===diqbrk=============================================================*
c
CDECK  ID>, DT_DIQBRK
      SUBROUTINE DT_XIQBRK
C     SUBROUTINE DT_DIQBRK

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      STOP 'DIQUARK-BREAKING NOT IMPLEMETED !'

      RETURN
      END
c
c===elhain=============================================================*
c
CDECK  ID>, DT_ELHAIN
      SUBROUTINE DT_ELHAIN(IP,PLA,ELAB,CX,CY,CZ,IT,IREJ)

c***********************************************************************
c Elastic hadron-hadron scattering.                                    *
c This is a revised version of the original.                           *
c This version dated 03.04.98 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TWO=2.0D0,ONE=1.0D0,OHALF=0.5D0,ZERO=0.0D0,
     &           TINY10=1.0D-10)

      PARAMETER (ENNTHR = 3.5D0)
      PARAMETER (PLOWH=0.01D0,PHIH=9.0D0,
     &           BLOWB=0.05D0,BHIB=0.2D0,
     &           BLOWM=0.1D0, BHIM=2.0D0)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c final state from HADRIN interaction
      PARAMETER (MAXFIN=10)
      COMMON /HNFSPA/ ITRH(MAXFIN),CXRH(MAXFIN),CYRH(MAXFIN),
     &                CZRH(MAXFIN),ELRH(MAXFIN),PLRH(MAXFIN),IRH


C     DATA TSLOPE /10.0D0/

      IREJ = 0

    1 CONTINUE

      PLAB = SQRT( (ELAB-AAM(IP))*(ELAB+AAM(IP)) )
      EKIN = ELAB-AAM(IP)
c   kinematical quantities in cms of the hadrons
      AMP2 = AAM(IP)**2
      AMT2 = AAM(IT)**2
      S    = AMP2+AMT2+TWO*ELAB*AAM(IT)
      ECM  = SQRT(S)
      ECMP = OHALF*ECM+(AMP2-AMT2)/(TWO*ECM)
      PCM  = SQRT( (ECMP-AAM(IP))*(ECMP+AAM(IP)) )

c nucleon-nucleon scattering at E_kin<3.5: use DT_TSAMCS(HETC-KFA)
      IF ( ((IP.EQ.1).OR.(IP.EQ.8)).AND.
     &     ((IT.EQ.1).OR.(IT.EQ.8)).AND.(EKIN.LT.ENNTHR) ) THEN
c   TSAMCS treats pp and np only, therefore change pn into np and
c   nn into pp
         IF (IT.EQ.1) THEN
            KPROJ = IP
         ELSE
            KPROJ = 8
            IF (IP.EQ.8) KPROJ = 1
         ENDIF
         CALL DT_TSAMCS(KPROJ,EKIN,CTCMS)
         T = TWO*PCM**2*(CTCMS-ONE)

c very crude treatment otherwise: sample t from exponential dist.
      ELSE
c   momentum transfer t
         TMAX = TWO*TWO*PCM**2
         RR = (PLAB-PLOWH)/(PHIH-PLOWH)
         IF (IIBAR(IP).NE.0) THEN
            TSLOPE = BLOWB+RR*(BHIB-BLOWB)
         ELSE
            TSLOPE = BLOWM+RR*(BHIM-BLOWM)
         ENDIF
         FMAX = EXP(-TSLOPE*TMAX)-ONE
         R = DT_RNDM(RR)
         T = LOG(ONE+R*FMAX+TINY10)/TSLOPE
         IF (T.GT.ZERO) T = LOG(ONE+R*FMAX)/TSLOPE
      ENDIF

c   target hadron in Lab after scattering
      ELRH(2) = (TWO*AMT2-T)/(TWO*AAM(IT))
      PLRH(2) = SQRT( ABS(ELRH(2)-AAM(IT))*(ELRH(2)+AAM(IT)) )
      IF (PLRH(2).LE.TINY10) THEN
C        WRITE(*,*)'ELHAIN: T,PLRH(2) ',T,PLRH(2)
         GOTO 1
      ENDIF
c   projectile hadron in Lab after scattering
      ELRH(1) = ELAB+AAM(IT)-ELRH(2)
      PLRH(1) = SQRT( ABS(ELRH(1)-AAM(IP))*(ELRH(1)+AAM(IP)) )
c   scattering angle of projectile in Lab
      CTLABP = (T-TWO*AMP2+TWO*ELAB*ELRH(1))/(TWO*PLAB*PLRH(1))
      STLABP = SQRT( (ONE-CTLABP)*(ONE+CTLABP) )
      CALL DT_DSFECF(SPLABP,CPLABP)
c   direction cosines of projectile in Lab
      CALL DT_STTRAN(CX,CY,CZ,CTLABP,STLABP,SPLABP,CPLABP,
     &                          CXRH(1),CYRH(1),CZRH(1))
c   scattering angle of target in Lab
      PLLABT = PLAB-CTLABP*PLRH(1)
      CTLABT = PLLABT/PLRH(2)
      STLABT = SQRT( (ONE-CTLABT)*(ONE+CTLABT) )
c   direction cosines of target in Lab
      CALL DT_STTRAN(CX,CY,CZ,CTLABT,STLABT,-SPLABP,-CPLABP,
     &                            CXRH(2),CYRH(2),CZRH(2))
c   fill /HNFSPA/
      IRH = 2
      ITRH(1) = IP
      ITRH(2) = IT

      RETURN
      END
c
c===tsamcs=============================================================*
c
CDECK  ID>, DT_TSAMCS
      SUBROUTINE DT_TSAMCS(KPROJ,EKIN,CST)

c***********************************************************************
c Sampling of cos(theta) for nucleon-proton scattering according to    *
c hetkfa2/bertini parametrization.                                     *
c This is a revised version of the original (HJM 24/10/88)             *
c This version dated 28.10.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TWO=2.0D0,ONE=1.0D0,OHALF=0.5D0,ZERO=0.0D0,
     &           TINY10=1.0D-10)

      DIMENSION DCLIN(195),DCHN(143),DCHNA(36),DCHNB(60)
      DIMENSION PDCI(60),PDCH(55)

      DATA (DCLIN(I),I=1,80) /
     &     5.000D-01,  1.000D+00,  0.000D+00,  1.000D+00,  0.000D+00,
     &     4.993D-01,  9.881D-01,  5.963D-02,  9.851D-01,  5.945D-02,
     &     4.936D-01,  8.955D-01,  5.224D-01,  8.727D-01,  5.091D-01,
     &     4.889D-01,  8.228D-01,  8.859D-01,  7.871D-01,  8.518D-01,
     &     4.874D-01,  7.580D-01,  1.210D+00,  7.207D-01,  1.117D+00,
     &     4.912D-01,  6.969D-01,  1.516D+00,  6.728D-01,  1.309D+00,
     &     5.075D-01,  6.471D-01,  1.765D+00,  6.667D-01,  1.333D+00,
     &     5.383D-01,  6.054D-01,  1.973D+00,  7.059D-01,  1.176D+00,
     &     5.397D-01,  5.990D-01,  2.005D+00,  7.023D-01,  1.191D+00,
     &     5.336D-01,  6.083D-01,  1.958D+00,  6.959D-01,  1.216D+00,
     &     5.317D-01,  6.075D-01,  1.962D+00,  6.897D-01,  1.241D+00,
     &     5.300D-01,  6.016D-01,  1.992D+00,  6.786D-01,  1.286D+00,
     &     5.281D-01,  6.063D-01,  1.969D+00,  6.786D-01,  1.286D+00,
     &     5.280D-01,  5.960D-01,  2.020D+00,  6.667D-01,  1.333D+00,
     &     5.273D-01,  5.920D-01,  2.040D+00,  6.604D-01,  1.358D+00,
     &     5.273D-01,  5.862D-01,  2.069D+00,  6.538D-01,  1.385D+00/
      DATA (DCLIN(I),I=81,160) /
     &     5.223D-01,  5.980D-01,  2.814D+00,  6.538D-01,  1.385D+00,
     &     5.202D-01,  5.969D-01,  2.822D+00,  6.471D-01,  1.412D+00,
     &     5.183D-01,  5.881D-01,  2.883D+00,  6.327D-01,  1.469D+00,
     &     5.159D-01,  5.866D-01,  2.894D+00,  6.250D-01,  1.500D+00,
     &     5.133D-01,  5.850D-01,  2.905D+00,  6.170D-01,  1.532D+00,
     &     5.106D-01,  5.833D-01,  2.917D+00,  6.087D-01,  1.565D+00,
     &     5.084D-01,  5.801D-01,  2.939D+00,  6.000D-01,  1.600D+00,
     &     5.063D-01,  5.763D-01,  2.966D+00,  5.909D-01,  1.636D+00,
     &     5.036D-01,  5.730D-01,  2.989D+00,  5.814D-01,  1.674D+00,
     &     5.014D-01,  5.683D-01,  3.022D+00,  5.714D-01,  1.714D+00,
     &     4.986D-01,  5.641D-01,  3.051D+00,  5.610D-01,  1.756D+00,
     &     4.964D-01,  5.580D-01,  3.094D+00,  5.500D-01,  1.800D+00,
     &     4.936D-01,  5.573D-01,  3.099D+00,  5.431D-01,  1.827D+00,
     &     4.909D-01,  5.509D-01,  3.144D+00,  5.313D-01,  1.875D+00,
     &     4.885D-01,  5.512D-01,  3.142D+00,  5.263D-01,  1.895D+00,
     &     4.857D-01,  5.437D-01,  3.194D+00,  5.135D-01,  1.946D+00/
      DATA (DCLIN(I),I=161,195) /
     &     4.830D-01,  5.353D-01,  3.253D+00,  5.000D-01,  2.000D+00,
     &     4.801D-01,  5.323D-01,  3.274D+00,  4.915D-01,  2.034D+00,
     &     4.770D-01,  5.228D-01,  3.341D+00,  4.767D-01,  2.093D+00,
     &     4.738D-01,  5.156D-01,  3.391D+00,  4.643D-01,  2.143D+00,
     &     4.701D-01,  5.010D-01,  3.493D+00,  4.444D-01,  2.222D+00,
     &     4.672D-01,  4.990D-01,  3.507D+00,  4.375D-01,  2.250D+00,
     &     4.634D-01,  4.856D-01,  3.601D+00,  4.194D-01,  2.323D+00/

      DATA PDCI /
     &     4.400D+02,  1.896D-01,  1.931D-01,  1.982D-01,  1.015D-01,
     &     1.029D-01,  4.180D-02,  4.228D-02,  4.282D-02,  4.350D-02,
     &     2.204D-02,  2.236D-02,  5.900D+02,  1.433D-01,  1.555D-01,
     &     1.774D-01,  1.000D-01,  1.128D-01,  5.132D-02,  5.600D-02,
     &     6.158D-02,  6.796D-02,  3.660D-02,  3.820D-02,  6.500D+02,
     &     1.192D-01,  1.334D-01,  1.620D-01,  9.527D-02,  1.141D-01,
     &     5.283D-02,  5.952D-02,  6.765D-02,  7.878D-02,  4.796D-02,
     &     6.957D-02,  8.000D+02,  4.872D-02,  6.694D-02,  1.152D-01,
     &     9.348D-02,  1.368D-01,  6.912D-02,  7.953D-02,  9.577D-02,
     &     1.222D-01,  7.755D-02,  9.525D-02,  1.000D+03,  3.997D-02,
     &     5.456D-02,  9.804D-02,  8.084D-02,  1.208D-01,  6.520D-02,
     &     8.233D-02,  1.084D-01,  1.474D-01,  9.328D-02,  1.093D-01/

      DATA PDCH /
     &     1.000D+03,  9.453D-02,  9.804D-02,  8.084D-02,  1.208D-01,
     &     6.520D-02,  8.233D-02,  1.084D-01,  1.474D-01,  9.328D-02,
     &     1.093D-01,  1.400D+03,  1.072D-01,  7.450D-02,  6.645D-02,
     &     1.136D-01,  6.750D-02,  8.580D-02,  1.110D-01,  1.530D-01,
     &     1.010D-01,  1.350D-01,  2.170D+03,  4.004D-02,  3.013D-02,
     &     2.664D-02,  5.511D-02,  4.240D-02,  7.660D-02,  1.364D-01,
     &     2.300D-01,  1.670D-01,  2.010D-01,  2.900D+03,  1.870D-02,
     &     1.804D-02,  1.320D-02,  2.970D-02,  2.860D-02,  5.160D-02,
     &     1.020D-01,  2.400D-01,  2.250D-01,  3.370D-01,  4.400D+03,
     &     1.196D-03,  8.784D-03,  1.517D-02,  2.874D-02,  2.488D-02,
     &     4.464D-02,  8.330D-02,  2.008D-01,  2.360D-01,  3.567D-01/

      DATA (DCHN(I),I=1,90) /
     &     4.770D-01,  4.750D-01,  4.715D-01,  4.685D-01,  4.650D-01,
     &     4.610D-01,  4.570D-01,  4.550D-01,  4.500D-01,  4.450D-01,
     &     4.405D-01,  4.350D-01,  4.300D-01,  4.250D-01,  4.200D-01,
     &     4.130D-01,  4.060D-01,  4.000D-01,  3.915D-01,  3.840D-01,
     &     3.760D-01,  3.675D-01,  3.580D-01,  3.500D-01,  3.400D-01,
     &     3.300D-01,  3.200D-01,  3.100D-01,  3.000D-01,  2.900D-01,
     &     2.800D-01,  2.700D-01,  2.600D-01,  2.500D-01,  2.400D-01,
     &     2.315D-01,  2.240D-01,  2.150D-01,  2.060D-01,  2.000D-01,
     &     1.915D-01,  1.850D-01,  1.780D-01,  1.720D-01,  1.660D-01,
     &     1.600D-01,  1.550D-01,  1.500D-01,  1.450D-01,  1.400D-01,
     &     1.360D-01,  1.320D-01,  1.280D-01,  1.250D-01,  1.210D-01,
     &     1.180D-01,  1.150D-01,  1.120D-01,  1.100D-01,  1.070D-01,
     &     1.050D-01,  1.030D-01,  1.010D-01,  9.900D-02,  9.700D-02,
     &     9.550D-02,  9.480D-02,  9.400D-02,  9.200D-02,  9.150D-02,
     &     9.100D-02,  9.000D-02,  8.990D-02,  8.900D-02,  8.850D-02,
     &     8.750D-02,  8.700D-02,  8.650D-02,  8.550D-02,  8.500D-02,
     &     8.499D-02,  8.450D-02,  8.350D-02,  8.300D-02,  8.250D-02,
     &     8.150D-02,  8.100D-02,  8.030D-02,  8.000D-02,  7.990D-02/
      DATA (DCHN(I),I=91,143) /
     &     7.980D-02,  7.950D-02,  7.900D-02,  7.860D-02,  7.800D-02,
     &     7.750D-02,  7.650D-02,  7.620D-02,  7.600D-02,  7.550D-02,
     &     7.530D-02,  7.500D-02,  7.499D-02,  7.498D-02,  7.480D-02,
     &     7.450D-02,  7.400D-02,  7.350D-02,  7.300D-02,  7.250D-02,
     &     7.230D-02,  7.200D-02,  7.100D-02,  7.050D-02,  7.020D-02,
     &     7.000D-02,  6.999D-02,  6.995D-02,  6.993D-02,  6.991D-02,
     &     6.990D-02,  6.870D-02,  6.850D-02,  6.800D-02,  6.780D-02,
     &     6.750D-02,  6.700D-02,  6.650D-02,  6.630D-02,  6.600D-02,
     &     6.550D-02,  6.525D-02,  6.510D-02,  6.500D-02,  6.499D-02,
     &     6.498D-02,  6.496D-02,  6.494D-02,  6.493D-02,  6.490D-02,
     &     6.488D-02,  6.485D-02,  6.480D-02/

      DATA DCHNA /
     &     6.300D+02,  7.810D-02,  1.421D-01,  1.979D-01,  2.479D-01,
     &     3.360D-01,  5.400D-01,  7.236D-01,  1.000D+00,  1.540D+03,
     &     2.225D-01,  3.950D-01,  5.279D-01,  6.298D-01,  7.718D-01,
     &     9.405D-01,  9.835D-01,  1.000D+00,  2.560D+03,  2.625D-01,
     &     4.550D-01,  5.963D-01,  7.020D-01,  8.380D-01,  9.603D-01,
     &     9.903D-01,  1.000D+00,  3.520D+03,  4.250D-01,  6.875D-01,
     &     8.363D-01,  9.163D-01,  9.828D-01,  1.000D+00,  1.000D+00,
     &     1.000D+00/

      DATA DCHNB /
     &     6.300D+02,  3.800D-02,  7.164D-02,  1.275D-01,  2.171D-01,
     &     3.227D-01,  4.091D-01,  5.051D-01,  6.061D-01,  7.074D-01,
     &     8.434D-01,  1.000D+00,  2.040D+03,  1.200D-01,  2.115D-01,
     &     3.395D-01,  5.295D-01,  7.251D-01,  8.511D-01,  9.487D-01,
     &     9.987D-01,  1.000D+00,  1.000D+00,  1.000D+00,  2.200D+03,
     &     1.344D-01,  2.324D-01,  3.754D-01,  5.674D-01,  7.624D-01,
     &     8.896D-01,  9.808D-01,  1.000D+00,  1.000D+00,  1.000D+00,
     &     1.000D+00,  2.850D+03,  2.330D-01,  4.130D-01,  6.610D-01,
     &     9.010D-01,  9.970D-01,  1.000D+00,  1.000D+00,  1.000D+00,
     &     1.000D+00,  1.000D+00,  1.000D+00,  3.500D+03,  3.300D-01,
     &     5.450D-01,  7.950D-01,  1.000D+00,  1.000D+00,  1.000D+00,
     &     1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00,  1.000D+00/

      CST = ONE
      IF (EKIN.GT.3.5D0) RETURN
C
      IF(KPROJ.EQ.8) GOTO 101
      IF(KPROJ.EQ.1) GOTO 102
C*                                             INVALID REACTION
      WRITE(ErrorOut,'(A,I5/A)')
     &        ' INVALID PARTICLE TYPE IN DNUPRE - KPROJ=',KPROJ,
     &        ' COS(THETA) = 1D0 RETURNED'
      RETURN
C-------------------------------- NP ELASTIC SCATTERING----------
101   CONTINUE
      IF (EKIN.GT.0.740D0)GOTO 1000
      IF (EKIN.LT.0.300D0)THEN
C                                 EKIN .LT. 300 MEV
         IDAT=1
      ELSE
C                                 300 MEV < EKIN < 740 MEV
         IDAT=6
      END IF
C
      ENER=EKIN
      IE=INT(ABS(ENER/0.020D0))
      UNIV=(ENER-DBLE(IE)*0.020D0)/0.020D0
C                                            FORWARD/BACKWARD DECISION
      K=IDAT+5*IE
      BWFW=(DCLIN(K+5)-DCLIN(K))*UNIV + DCLIN(K)
      IF (DT_RNDM(CST).LT.BWFW)THEN
         VALUE2=-1D0
         K=K+1
      ELSE
         VALUE2=1D0
         K=K+3
      END IF
C
      COEF=(DCLIN(K+5)-DCLIN(K))*UNIV + DCLIN(K)
      RND=DT_RNDM(COEF)
C
      IF(RND.LT.COEF)THEN
         CST=DT_RNDM(RND)
         CST=CST*VALUE2
      ELSE
         R1=DT_RNDM(CST)
         R2=DT_RNDM(R1)
         R3=DT_RNDM(R2)
         R4=DT_RNDM(R3)
C
         IF(VALUE2.GT.0.0)THEN
            CST=MAX(R1,R2,R3,R4)
            GOTO 1500
         ELSE
            R5=DT_RNDM(R4)
C
            IF (IDAT.EQ.1)THEN
               CST=-MAX(R1,R2,R3,R4,R5)
            ELSE
               R6=DT_RNDM(R5)
               R7=DT_RNDM(R6)
               CST=-MAX(R1,R2,R3,R4,R5,R6,R7)
            END IF
C
         END IF
C
      END IF
C
      GOTO 1500
C
C********                                EKIN  .GT.  0.74 GEV
C
1000  ENER=EKIN - 0.66D0
C     IE=ABS(ENER/0.02)
      IE=INT(ENER/0.02D0)
      EMEV=EKIN*1D3
C
      UNIV=(ENER-DBLE(IE)*0.020D0)/0.020D0
      K=IE
      BWFW=(DCHN(K+1)-DCHN(K))*UNIV + DCHN(K)
      RND=DT_RNDM(BWFW)
C                                        FORWARD NEUTRON
      IF (RND.GE.BWFW)THEN
         DO 1200 K=10,36,9
           IF (DCHNA(K).GT.EMEV) THEN
              UNIVE=(EMEV-DCHNA(K-9))/(DCHNA(K)-DCHNA(K-9))
              UNIV=DT_RNDM(UNIVE)
              DO 1100 I=1,8
                 II=K+I
                 P=(DCHNA(II)-DCHNA(II-9))*UNIVE + DCHNA(II-9)
C
                 IF (P.GT.UNIV)THEN
                    UNIV=DT_RNDM(UNIVE)
                    FLTI=DBLE(I)-UNIV
                    GOTO(290,290,290,290,330,340,350,360) I
                 END IF
 1100         CONTINUE
           END IF
 1200    CONTINUE
C
      ELSE
C                                        BACKWARD NEUTRON
         DO 1400 K=13,60,12
            IF (DCHNB(K).GT.EMEV) THEN
               UNIVE=(EMEV-DCHNB(K-12))/(DCHNB(K)-DCHNB(K-12))
               UNIV=DT_RNDM(UNIVE)
               DO 1300 I=1,11
                 II=K+I
                 P=(DCHNB(II)-DCHNB(II-12))*UNIVE + DCHNB(II-12)
C
                 IF (P.GT.UNIV)THEN
                   UNIV=DT_RNDM(P)
                   FLTI=DBLE(I)-UNIV
                   GOTO(120,120,140,150,160,160,180,190,200,210,220) I
                 END IF
 1300          CONTINUE
            END IF
 1400    CONTINUE
      END IF
C
120   CST=1.0D-2*FLTI-1.0D0
      GOTO 1500
140   CST=2.0D-2*UNIV-0.98D0
      GOTO 1500
150   CST=4.0D-2*UNIV-0.96D0
      GOTO 1500
160   CST=6.0D-2*FLTI-1.16D0
      GOTO 1500
180   CST=8.0D-2*UNIV-0.80D0
      GOTO 1500
190   CST=1.0D-1*UNIV-0.72D0
      GOTO 1500
200   CST=1.2D-1*UNIV-0.62D0
      GOTO 1500
210   CST=2.0D-1*UNIV-0.50D0
      GOTO 1500
220   CST=3.0D-1*(UNIV-1.0D0)
      GOTO 1500
C
290   CST=1.0D0-2.5D-2*FLTI
      GOTO 1500
330   CST=0.85D0+0.5D-1*UNIV
      GOTO 1500
340   CST=0.70D0+1.5D-1*UNIV
      GOTO 1500
350   CST=0.50D0+2.0D-1*UNIV
      GOTO 1500
360   CST=0.50D0*UNIV
C
1500  RETURN
C
C-----------------------------------  PP ELASTIC SCATTERING -------
C
 102  CONTINUE
      EMEV=EKIN*1D3
C
      IF (EKIN.LE.0.500D0) THEN
         RND=DT_RNDM(EMEV)
         CST=2.0D0*RND-1.0D0
         RETURN
C
      ELSEIF (EKIN.LT.1.0D0) THEN
         DO 2200 K=13,60,12
            IF (PDCI(K).GT.EMEV) THEN
               UNIVE=(EMEV-PDCI(K-12))/(PDCI(K)-PDCI(K-12))
               UNIV=DT_RNDM(UNIVE)
               SUM=0
               DO 2100 I=1,11
                 II=K+I
                 SUM=SUM + (PDCI(II)-PDCI(II-12))*UNIVE + PDCI(II-12)
C
                 IF (UNIV.LT.SUM)THEN
                   UNIV=DT_RNDM(SUM)
                   FLTI=DBLE(I)-UNIV
                   GOTO(55,55,55,60,60,65,65,65,65,70,70) I
                 END IF
 2100          CONTINUE
            END IF
 2200    CONTINUE
      ELSE
         DO 2400 K=12,55,11
            IF (PDCH(K).GT.EMEV) THEN
              UNIVE=(EMEV-PDCH(K-11))/(PDCH(K)-PDCH(K-11))
              UNIV=DT_RNDM(UNIVE)
              SUM=0.0D0
              DO 2300 I=1,10
                II=K+I
                SUM=SUM + (PDCH(II)-PDCH(II-11))*UNIVE + PDCH(II-11)
C
                IF (UNIV.LT.SUM)THEN
                  UNIV=DT_RNDM(SUM)
                  FLTI=UNIV+DBLE(I)
                  GOTO(50,55,60,60,65,65,65,65,70,70) I
                END IF
 2300         CONTINUE
            END IF
 2400    CONTINUE
      END IF
C
50    CST=0.4D0*UNIV
      GOTO 2500
55    CST=0.2D0*FLTI
      GOTO 2500
60    CST=0.3D0+0.1D0*FLTI
      GOTO 2500
65    CST=0.6D0+0.04D0*FLTI
      GOTO 2500
70    CST=0.78D0+0.02D0*FLTI
C
2500  CONTINUE
      IF (DT_RNDM(CST).GT.0.5D0) CST=-CST
C
      RETURN
      END
c
c===dhadri=============================================================*
c
CDECK  ID>, DT_DHADRI
      SUBROUTINE DT_DHADRI(N,PLAB,ELAB,CX,CY,CZ,ITTA)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
C
C-----------------------------
C*** INPUT VARIABLES LIST:
C*** SAMPLING OF HADRON NUCLEON INTERACTION FOR (ABOUT) 0.1 LE PLAB LE 6
C*** GEV/C LABORATORY MOMENTUM REGION
C*** N    - PROJECTILE HADRON INDEX
C*** PLAB - LABORATORY MOMENTUM OF N (GEV/C)
C*** ELAB - LABORATORY ENERGY OF N (GEV)
C*** CX,CY,CZ - DIRECTION COSINES OF N IN THE LABORATORY SYSTEM
C*** ITTA - TARGET NUCLEON INDEX
C*** OUTPUT VARIABLES LIST OF PARTICLE CHARACTERISTICS IN /FINLSP/
C  IR COUNTS THE NUMBER OF PRODUCED PARTICLES
C*** ITR - PARTICLE INDEX, CXR,CYR,CZR - DIRECTION COSINES (LAB. SYST.)
C*** ELR,PLR LAB. ENERGY AND LAB. MOMENTUM OF THE SAMPLED PARTICLE
C*** RESPECT., UNITS (GEV/C AND GEV)
C----------------------------

      COMMON /HNGAMR/ REDU,AMO,AMM(15)

      COMMON /HNREDV/ THRESH(268),IRII(17),IKII(17),IEII(17)

      COMMON /HNREAC/ UMO(296),PLABF(296),SIIN(296),WK(5184),
     &                NRK(2,268),NURE(30,2)

c particle properties (BAMJET index convention),
c (dublicate of DTPART for HADRIN)
      COMMON /HNABLT/ AMH(110),GAH(110),TAUH(110),ICHH(110),IBARH(110),
     &                K1H(110),K2H(110)

      COMMON /HNSPLI/ WTI(460),NZKI(460,3)

      COMMON /HNMETL/ CXS(149),CYS(149),CZS(149),ELS(149),PLS(149),
     &                ITS(149),IS

      COMMON /HNDRUN/ RUNTES,EFTES

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c final state from HADRIN interaction
      PARAMETER (MAXFIN=10)
      COMMON /HNFSPA/ ITRH(MAXFIN),CXRH(MAXFIN),CYRH(MAXFIN),
     &                CZRH(MAXFIN),ELRH(MAXFIN),PLRH(MAXFIN),IRH


      DIMENSION ITPRF(110)
      DATA NNN/0/
      DATA UMODA/0./
      DATA ITPRF/-1,-1,5*1,-1,-1,1,1,1,-1,-1,-1,-1,6*1,-1,-1,-1,85*1/
      LOWP=0
      IF (N.LE.0.OR.N.GE.111)N=1
      IF (ITPRF( N ).GT.0 .OR. ITTA.GT.8) THEN
        GOTO 280
c       WRITE (6,1000)
c    +  ' FALSE USE OF THE PARTICLE TYPE INDEX: N, ITTA', N, ITTA
c       STOP
c1000   FORMAT (3(5H ****/),A,2I4,3(5H ****/))
c    +  45H FALSE USE OF THE PARTICLE TYPE INDEX, N,LUE ,I4,3(5H ****/))
      ENDIF
      IATMPT=0
      IF (ABS(PLAB-5.0D0).LT.4.99999D0)                        GO TO 20
C     IF(IPRI.GE.1) WRITE (6,1010) PLAB
C     STOP
 1010 FORMAT ( '  PROJECTILE HADRON MOMENTUM OUTSIDE OF THE
     + ALLOWED REGION, PLAB=',1E15.5)

   20 CONTINUE
      UMODAT=N*1.11111D0+ITTA*2.19291D0
      IF(UMODAT.NE.UMODA) CALL DT_DCALUM(N,ITTA)
      UMODA=UMODAT
   30 IATMPT=0
      LOWP=LOWP+1
   40 CONTINUE
      IMACH=0
      REDU=2.0D0
      IF (LOWP.GT.20) THEN
C        WRITE(LOUT,*) ' jump 1'
         GO TO 280
      ENDIF
      NNN=N
      IF (NNN.EQ.N)                                             GO TO 50
      RUNTES=0.0D0
      EFTES=0.0D0
   50 CONTINUE
      IS=1
      IRH=0
      IST=1
      NSTAB=23
      IRE=NURE(N,1)
      IF(ITTA.GT.1) IRE=NURE(N,2)
C
C-----------------------------
C*** IE,AMT,ECM,SI DETERMINATION
C----------------------------
      CALL DT_DSIGIN(IRE,PLAB,N,IE,AMT ,AMN,ECM,SI,ITTA)
      IANTH=-1
c*sr
C     IF (AMH(1).NE.0.93828D0) IANTH=1
      IF (AMH(1).NE.0.9383D0) IANTH=1
c*
      IF (IANTH.GE.0) SI=1.0D0
      ECMMH=ECM
C
C-----------------------------
C    ENERGY INDEX
C  IRE CHARACTERIZES THE REACTION
C  IE IS THE ENERGY INDEX
C----------------------------
      IF (SI.LT.1.D-6) THEN
C        WRITE(LOUT,*) ' jump 2'
         GO TO 280
      ENDIF
      IF (N.LE.NSTAB)                                           GO TO 60
      RUNTES=RUNTES+1.0D0
      IF (RUNTES.LT.20.D0) WRITE(ErrorOut,1020)N
 1020 FORMAT(3H N=,I10,30H THE PROEKTILE IS A RESONANCE )
      IF(IBARH(N).EQ.1) N=8
      IF(IBARH(N).EQ.-1)  N=9
   60 CONTINUE
      IMACH=IMACH+1
c*sr 19.2.97: loop for direct channel suppression
C     IF (IMACH.GT.10) THEN
      IF (IMACH.GT.1000) THEN
c*
C        WRITE(LOUT,*) ' jump 3'
         GO TO 280
      ENDIF
      ECM =ECMMH
      AMN2=AMN**2
      AMT2=AMT**2
      ECMN=(ECM**2+AMN2-AMT2)/(2.0D0*ECM    )
      IF(ECMN.LE.AMN) ECMN=AMN
      PCMN=SQRT(ECMN**2-AMN2)
      GAM=(ELAB+AMT)/ECM
      BGAM=PLAB/ECM
      IF (IANTH.GE.0) ECM=2.1D0
C
C-----------------------------
C*** RANDOM CHOICE OF REACTION CHANNEL
C----------------------------
      IST=0
      VV=DT_RNDM(AMN2)
      VV=VV-1.D-17
C
C-----------------------------
C***  PLACE REDUCED VERSION
C----------------------------
      IIEI=IEII(IRE)
      IDWK=IEII(IRE+1)-IIEI
      IIWK=IRII(IRE)
      IIKI=IKII(IRE)
C
C-----------------------------
C***  SHRINKAGE TO THE CONSIDERED ENERGY REGION FOR THE USE OF WEIGHTS
C----------------------------
      HECM=ECM
      HUMO=2.0D0*UMO(IIEI+IDWK)-UMO(IIEI+IDWK-1)
      IF (HUMO.LT.ECM) ECM=HUMO
C
C-----------------------------
C*** INTERPOLATION PREPARATION
C----------------------------
      ECMO=UMO(IE)
      ECM1=UMO(IE-1)
      DECM=ECMO-ECM1
      DEC=ECMO-ECM
C
C-----------------------------
C*** RANDOM LOOP
C----------------------------
      IK=0
      WKK=0.0D0
      WICOR=0.0D0
   70 IK=IK+1
      IWK=IIWK+(IK-1)*IDWK+IE-IIEI
      WOK=WK(IWK)
      WDK=WOK-WK(IWK-1)
C
C-----------------------------
C*** TESTVARIABLE WICO/WICOR: IF CHANNEL IK HAS THE SAME WEIGHTS LIKE IK
C    GO TO NEXT CHANNEL, BECAUSE WKK((IK))-WKK((IK-1))=0, IK CAN NOT
C    CONTRIBUTE
C----------------------------
      IF (PLAB.LT.PLABF(IIEI+2)) WDK=0.0D0
      WICO=WOK*1.23459876D0+WDK*1.735218469D0
      IF (WICO.EQ.WICOR)                                        GO TO 70
      IF (UMO(IIEI+IDWK).LT.HECM) WDK=0.0D0
      WICOR=WICO
C
C-----------------------------
C*** INTERPOLATION IN CHANNEL WEIGHTS
C----------------------------
      EKLIM=-THRESH(IIKI+IK)
      IELIM=IDT_IEFUND(EKLIM,IRE)
      DELIM=UMO(IELIM)+EKLIM
     *+1.D-16
      DETE=(ECM-(ECMO-EKLIM)*0.5D0)*2.0D0
      IF (DELIM*DELIM-DETE*DETE) 90,90,80
   80 DECC=DELIM
                                                               GO TO 100
   90 DECC=DECM
  100 CONTINUE
      WKK=WOK-WDK*DEC/(DECC+1.D-9)
C
C-----------------------------
C*** RANDOM CHOICE
C----------------------------
C
      IF (VV.GT.WKK)                                            GO TO 70
C
C***IK IS THE REACTION CHANNEL
C----------------------------
      INRK=IKII(IRE)+IK
      ECM=HECM
      I1001 =0
C
  110 CONTINUE
      IT1=NRK(1,INRK)
      AM1=DT_DAMG(IT1)
      IT2=NRK(2,INRK)
      AM2=DT_DAMG(IT2)
      AMS=AM1+AM2
      I1001=I1001+1
      IF (I1001.GT.50)                                          GO TO 60
C
      IF (IT2*AMS.GT.IT2*ECM)                                  GO TO 110
      IT11=IT1
      IT22=IT2
      IF (IANTH.GE.0) ECM=ELAB+AMT+0.00001D0
      AM11=AM1
      AM22=AM2
      IF (IT2.GT.0)                                            GO TO 120
c*sr 19.2.97: supress direct channel for pp-collisions
      IF ((N.EQ.1).AND.(ITTA.EQ.1).AND.(IT2.LE.0)) THEN
         RR = DT_RNDM(AM11)
         IF (RR.LE.0.75D0) GOTO 60
      ENDIF
c*
C
C-----------------------------
C  INCLUSION OF DIRECT RESONANCES
C  RANDOM CHOICE OF DECAY CHANNELS OF THE DIRECT RESONANCE  IT1
C------------------------
      KZ1=K1H(IT1)
      IST=IST+1
      IECO=0
      ECO=ECM
      GAM=(ELAB+AMT)/ECO
      BGAM=PLAB/ECO
      CXS(1)=CX
      CYS(1)=CY
      CZS(1)=CZ
                                                               GO TO 170
  120 CONTINUE
      WW=DT_RNDM(ECO)
      IF(WW.LT. 0.5D0)                                         GO TO 130
      IT1=IT22
      IT2=IT11
      AM1=AM22
      AM2=AM11
  130 CONTINUE
C
C-----------------------------
C   THE FIRST PARTICLE IS DEFINED TO BE THE FORWARD GOING ONE AT SMALL T
      IBN=IBARH(N)
      IB1=IBARH(IT1)
      IT11=IT1
      IT22=IT2
      AM11=AM1
      AM22=AM2
      IF(IB1.EQ.IBN)                                           GO TO 140
      IT1=IT22
      IT2=IT11
      AM1=AM22
      AM2=AM11
  140 CONTINUE
C-----------------------------
C***IT1,IT2 ARE THE CREATED PARTICLES
C***MOMENTA AND DIRECTION COSINA IN THE CM - SYSTEM
C------------------------
      CALL DT_DTWOPA(ECM1,ECM2,PCM1,PCM2,COD1,COD2,COF1,COF2,SIF1,SIF2,
     *IT1,IT2,ECM,ECMN,PCMN,N,AM1,AM2)
      IST=IST+1
      ITS(IST)=IT1
      AMM(IST)=AM1
C
C-----------------------------
C***TRANSFORMATION INTO LAB SYSTEM AND ROTATION
C----------------------------
      CALL DT_DTRAFO(GAM,BGAM,CX,CY,CZ,COD1,COF1,SIF1,
     &PCM1,ECM1,PLS(IST),CXS(IST),CYS(IST),CZS(IST),ELS(IST))
      IST=IST+1
      ITS(IST)=IT2
      AMM(IST)=AM2
      CALL DT_DTRAFO(GAM,BGAM,CX,CY,CZ,COD2,COF2,SIF2,
     *PCM2,ECM2,PLS(IST),CXS(IST),CYS(IST),CZS(IST),ELS(IST))
  150 CONTINUE
C
C-----------------------------
C***TEST   STABLE OR UNSTABLE
C----------------------------
      IF(ITS(IST).GT.NSTAB)                                    GO TO 160
      IRH=IRH+1
C
C-----------------------------
C***IRH IS THE NUMBER OF THE FINAL STABLE PARTICLE
C----------------------------
C*    IF (REDU.LT.0.D0) GO TO 1009
      ITRH(IRH)=ITS(IST)
      PLRH(IRH)=PLS(IST)
      CXRH(IRH)=CXS(IST)
      CYRH(IRH)=CYS(IST)
      CZRH(IRH)=CZS(IST)
      ELRH(IRH)=ELS(IST)
      IST=IST-1
      IF(IST.GE.1)                                             GO TO 150
                                                               GO TO 260
  160 CONTINUE
C
C  RANDOM CHOICE OF DECAY CHANNELS
C----------------------------
C
      IT=ITS(IST)
      ECO=AMM(IST)
      GAM=ELS(IST)/ECO
      BGAM=PLS(IST)/ECO
      IECO=0
      KZ1=K1H(IT)
  170 CONTINUE
      IECO=IECO+1
      VV=DT_RNDM(GAM)
      VV=VV-1.D-17
      IIK=KZ1-1
  180 IIK=IIK+1
      IF (VV.GT.WTI(IIK))                                      GO TO 180
C
C  IIK IS THE DECAY CHANNEL
C----------------------------
      IT1=NZKI(IIK,1)
      I310=0
  190 CONTINUE
      I310=I310+1
      AM1=DT_DAMG(IT1)
      IT2=NZKI(IIK,2)
      AM2=DT_DAMG(IT2)
      IF (IT2-1.LT.0)                                          GO TO 240
      IT3=NZKI(IIK,3)
      AM3=DT_DAMG(IT3)
      AMS=AM1+AM2+AM3
C
C  IF  IIK-KIN.LIM.GT.ACTUAL TOTAL CM-ENERGY, DO AGAIN RANDOM IIK-CHOICE
C----------------------------
      IF (IECO.LE.10)                                          GO TO 200
      IATMPT=IATMPT+1
      IF(IATMPT.GT.3) THEN
C        WRITE(LOUT,*) ' jump 4'
         GO TO 280
      ENDIF
                                                                GO TO 40
  200 CONTINUE
      IF (I310.GT.50)                                          GO TO 170
      IF (AMS.GT.ECO)                                          GO TO 190
C
C  FOR THE DECAY CHANNEL
C  IT1,IT2, IT3 ARE THE PRODUCED PARTICLES FROM  IT
C----------------------------
      IF (REDU.LT.0.D0)                                        GO TO 30
      ITWTHC=0
      REDU=2.0D0
      IF(IT3.EQ.0)                                             GO TO 220
  210 CONTINUE
      ITWTH=1
      CALL DT_DTHREP(ECO,ECM1,ECM2,ECM3,PCM1,PCM2,PCM3,COD1,COF1,SIF1,
     *COD2,COF2,SIF2,COD3,COF3,SIF3,AM1,AM2,AM3)
                                                               GO TO 230
  220 CALL DT_DTWOPD(ECO,ECM1,ECM2,PCM1,PCM2,COD1,COF1,SIF1,
     &COD2,COF2,SIF2,AM1,AM2)
      ITWTH=-1
      IT3=0
  230 CONTINUE
      ITWTHC=ITWTHC+1
      IF (REDU.GT.0.D0)                                        GO TO 240
      REDU=2.0D0
      IF (ITWTHC.GT.100)                                        GO TO 30
      IF (ITWTH) 220,220,210
  240 CONTINUE
      ITS(IST  )=IT1
      IF (IT2-1.LT.0)                                          GO TO 250
      ITS(IST+1)  =IT2
      ITS(IST+2)=IT3
      RX=CXS(IST)
      RY=CYS(IST)
      RZ=CZS(IST)
      AMM(IST)=AM1
      CALL DT_DTRAFO(GAM,BGAM,RX,RY,RZ,COD1,COF1,SIF1,PCM1,ECM1,
     *PLS(IST),CXS(IST),CYS(IST),CZS(IST),ELS(IST))
      IST=IST+1
      AMM(IST)=AM2
      CALL DT_DTRAFO(GAM,BGAM,RX,RY,RZ,COD2,COF2,SIF2,PCM2,ECM2,
     *PLS(IST),CXS(IST),CYS(IST),CZS(IST),ELS(IST))
      IF (IT3.LE.0)                                            GO TO 250
      IST=IST+1
      AMM(IST)=AM3
      CALL DT_DTRAFO(GAM,BGAM,RX,RY,RZ,COD3,COF3,SIF3,PCM3,ECM3,
     *PLS(IST),CXS(IST),CYS(IST),CZS(IST),ELS(IST))
  250 CONTINUE
                                                               GO TO 150
  260 CONTINUE
  270 CONTINUE
      RETURN
  280 CONTINUE
C
C----------------------------
C
C   ZERO CROSS SECTION CASE
C----------------------------
C
      IRH=1
      ITRH(1)=N
      CXRH(1)=CX
      CYRH(1)=CY
      CZRH(1)=CZ
      ELRH(1)=ELAB
      PLRH(1)=PLAB
      RETURN
      END
c
c===runtt==============================================================*
c
CDECK  ID>, DT_RUNTT
      BLOCK DATA DT_RUNTT

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      COMMON /HNDRUN/ RUNTES,EFTES


      DATA RUNTES,EFTES /100.D0,100.D0/

      END
c
c===noname=============================================================*
c
CDECK  ID>, DT_NONAME
      BLOCK DATA DT_NONAME

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c slope parameters for HADRIN interactions
      COMMON /HNSLOP/ SM(25),BBM(25),BBB(25)

      COMMON /HNREDV/ THRESH(268),IRII(17),IKII(17),IEII(17)


C     DATAS     DATAS    DATAS      DATAS     DATAS
C******          *********
      DATA IKII/ 0, 15, 41, 67, 82, 93, 110, 133, 148, 159, 172, 183,
     &           207, 224, 241, 252, 268 /
      DATA IEII/ 0, 21, 46, 71, 92, 109, 126, 143, 160, 173, 186, 199,
     &           220, 241, 262, 279, 296 /
      DATA IRII/ 0, 315, 965, 1615, 1930, 2117, 2406, 2797, 3052, 3195,
     &           3364, 3507, 4011, 4368, 4725, 4912, 5184/

C
C     MASSES FOR THE SLOPE B(M) IN GEV
C     SLOPE B(M) FOR AN MESONIC SYSTEM
C     SLOPE B(M) FOR A BARYONIC SYSTEM

c
      DATA SM,BBM,BBB/  0.8D0, 0.85D0,  0.9D0, 0.95D0, 1.D0,
     &     1.05D0,  1.1D0, 1.15D0,  1.2D0, 1.25D0,
     &      1.3D0,  1.35D0, 1.4D0,  1.45D0,  1.5D0,
     &     1.55D0,  1.6D0,  1.65D0, 1.7D0,   1.75D0,
     &      1.8D0,  1.85D0, 1.9D0,  1.95D0,  2.D0,
     &     15.6D0, 14.95D0, 14.3D0, 13.65D0, 13.D0,
     &    12.35D0, 11.7D0, 10.85D0, 10.D0,  9.15D0,
     &      8.3D0,  7.8D0,  7.3D0,  7.25D0,  7.2D0,
     &     6.95D0,  6.7D0,  6.6D0,  6.5D0,   6.3D0,
     &      6.1D0,  5.85D0, 5.6D0,  5.35D0,  5.1D0,
     &      15.D0,   15.D0, 15.D0,  15.D0,   15.D0, 15.D0, 15.D0,
     &     14.2D0,  13.4D0, 12.6D0,
     &     11.8D0, 11.2D0, 10.6D0,  9.8D0,    9.D0,
     &     8.25D0,  7.5D0, 6.25D0,  5.D0,    4.5D0, 5*4.D0 /
c
      END
c
c===damg===============================================================*
c
CDECK  ID>, DT_DAMG
      DOUBLE PRECISION FUNCTION DT_DAMG(IT)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c particle properties (BAMJET index convention),
c (dublicate of DTPART for HADRIN)
      COMMON /HNABLT/ AMH(110),GAH(110),TAUH(110),ICHH(110),IBARH(110),
     &                K1H(110),K2H(110)


      DIMENSION GASUNI(14)
      DATA GASUNI/
     *-1.D0,-.98D0,-.95D0,-.87D0,-.72D0,-.48D0,
     *-.17D0,.17D0,.48D0,.72D0,.87D0,.95D0,.98D0,1.D0/
      DATA GAUNO/2.352D0/
      DATA GAUNON/2.4D0/
      DATA IO/14/
      DATA NSTAB/23/

      I=1
      IF (IT.LE.0)                                              GO TO 30
      IF (IT.LE.NSTAB)                                          GO TO 20
      DGAUNI=GAUNO*GAUNON/DBLE(IO-1)
      VV=DT_RNDM(DGAUNI)
      VV=VV*2.0D0-1.0D0+1.D-16
   10 CONTINUE
      VO=GASUNI(I)
      I=I+1
      V1=GASUNI(I)
      IF (VV.GT.V1)                                             GO TO 10
      UNIGA=DGAUNI*(DBLE(I)-2.0D0+(VV-VO+1.D-16)/
     &      (V1-VO)-(DBLE(IO)-1.0D0)*0.5D0)
      DAM=GAH(IT)*UNIGA/GAUNO
      AAM=AMH(IT)+DAM
      DT_DAMG=AAM
      RETURN
   20 CONTINUE
      DT_DAMG=AMH(IT)
      RETURN
   30 CONTINUE
      DT_DAMG=0.0D0
      RETURN
      END
c
c===dcalum=============================================================*
c
CDECK  ID>, DT_DCALUM
      SUBROUTINE DT_DCALUM(N,ITTA)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

C*** C.M.S.-ENERGY AND REACTION CHANNEL THRESHOLD CALCULATION

c particle properties (BAMJET index convention),
c (dublicate of DTPART for HADRIN)
      COMMON /HNABLT/ AMH(110),GAH(110),TAUH(110),ICHH(110),IBARH(110),
     &                K1H(110),K2H(110)

      COMMON /HNREDV/ THRESH(268),IRII(17),IKII(17),IEII(17)

      COMMON /HNSPLI/ WTI(460),NZKI(460,3)

      COMMON /HNREAC/ UMO(296),PLABF(296),SIIN(296),WK(5184),
     &                NRK(2,268),NURE(30,2)


      IRE=NURE(N,ITTA/8+1)
      IEO=IEII(IRE)+1
      IEE=IEII(IRE +1)
      AM1=AMH(N   )
      AM12=AM1**2
      AM2=AMH(ITTA)
      AM22=AM2**2
      DO 10 IE=IEO,IEE
        PLAB2=PLABF(IE)**2
        ELAB=SQRT(AM12+AM22+2.0D0*SQRT(PLAB2+AM12)*AM2)
        UMO(IE)=ELAB
   10 CONTINUE
      IKO=IKII(IRE)+1
      IKE=IKII(IRE +1)
      UMOO=UMO(IEO)
      DO 30 IK=IKO,IKE
        IF(NRK(2,IK).GT.0)                                      GO TO 30
        IKI=NRK(1,IK)
        AMSS=5.0D0
        K11=K1H(IKI)
        K22=K2H(IKI)
        DO 20 IK1=K11,K22
          IN=NZKI(IK1,1)
          AMS=AMH(IN)
          IN=NZKI(IK1,2)
          IF(IN.GT.0)AMS=AMS+AMH(IN)
          IN=NZKI(IK1,3)
          IF(IN.GT.0) AMS=AMS+AMH(IN)
          IF (AMS.LT.AMSS) AMSS=AMS
   20   CONTINUE
        IF(UMOO.LT.AMSS) UMOO=AMSS
        THRESH(IK)=UMOO
   30 CONTINUE
      RETURN
      END
c
c===dchanh=============================================================*
c
CDECK  ID>, DT_DCHANH
      SUBROUTINE DT_DCHANH

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

c particle properties (BAMJET index convention),
c (dublicate of DTPART for HADRIN)
      COMMON /HNABLT/ AMH(110),GAH(110),TAUH(110),ICHH(110),IBARH(110),
     &                K1H(110),K2H(110)

      COMMON /HNSPLI/ WTI(460),NZKI(460,3)

      COMMON /HNREDV/ THRESH(268),IRII(17),IKII(17),IEII(17)

      COMMON /HNREAC/ UMO(296),PLABF(296),SIIN(296),WK(5184),
     &                NRK(2,268),NURE(30,2)


      DIMENSION HWT(460),HWK(40),SI(5184)
      EQUIVALENCE (WK(1),SI(1))
C--------------------
C*** USE ONLY FOR DATAPREPARATION OF PURE HADRIN
C*** CALCULATION OF REACTION- AND DECAY-CHANNEL-WEIGHTS,
C*** THRESHOLD ENERGIES+MOMENTA OF REACTION CHNLS.
C*** CHANGE OF WT- AND WK-INPUTDATA INTO WEIGHTS FOR THE M.-C.-PROCEDURE
C*** (ADDED ONE TO EACH OTHER FOR CORRESPONDING CHANNELS)
C--------------------------
      IREG=16
      DO 90 IRE=1,IREG
        IWKO=IRII(IRE)
        IEE=IEII(IRE+1)-IEII(IRE)
        IKE=IKII(IRE+1)-IKII(IRE)
        IEO=IEII(IRE)+1
        IIKA=IKII(IRE)
c   modifications to suppress elestic scattering  24/07/91
        DO 80 IE=1,IEE
          SIS=1.D-14
          SINORC=0.0D0
          DO 10 IK=1,IKE
            IWK=IWKO+IEE*(IK-1)+IE
            IF(NRK(2,IIKA+IK).EQ.0) SINORC=1.0D0
            SIS=SIS+SI(IWK)*SINORC
   10     CONTINUE
          SIIN(IEO+IE-1)=SIS
          SIO=0.D0
          IF (SIS.GE.1.D-12)                                    GO TO 20
          SIS=1.D0
          SIO=1.D0
   20     CONTINUE
          SINORC=0.0D0
          DO 30 IK=1,IKE
            IWK=IWKO+IEE*(IK-1)+IE
            IF(NRK(2,IIKA+IK).EQ.0) SINORC=1.0D0
            SIO=SIO+SI(IWK)*SINORC/SIS
            HWK(IK)=SIO
   30     CONTINUE
          DO 40 IK=1,IKE
            IWK=IWKO+IEE*(IK-1)+IE
   40     WK(IWK)=HWK(IK)
          IIKI=IKII(IRE)
          DO 70 IK=1,IKE
            AM111=0.D0
            INRK1=NRK(1,IIKI+IK)
            IF (INRK1.GT.0) AM111=AMH(INRK1)
            AM222=0.D0
            INRK2=NRK(2,IIKI+IK)
            IF (INRK2.GT.0) AM222=AMH(INRK2)
            THRESH(IIKI+IK)=AM111 +AM222
            IF (INRK2-1.GE.0)                                   GO TO 60
            INRKK=K1H(INRK1)
            AMSS=5.D0
            INRKO=K2H(INRK1)
            DO 50 INRK1=INRKK,INRKO
              INZK1=NZKI(INRK1,1)
              INZK2=NZKI(INRK1,2)
              INZK3=NZKI(INRK1,3)
              IF (INZK1.LE.0.OR.INZK1.GT.110)                   GO TO 50
              IF (INZK2.LE.0.OR.INZK2.GT.110)                   GO TO 50
              IF (INZK3.LE.0.OR.INZK3.GT.110)                   GO TO 50
C     WRITE (6,310)INRK1,INZK1,INZK2,INZK3
 1000 FORMAT (4I10)
              AMS=AMH(INZK1)+AMH(INZK2)
              IF (INZK3-1.GE.0) AMS=AMS+AMH(INZK3)
              IF (AMSS.GT.AMS) AMSS=AMS
   50       CONTINUE
            AMS=AMSS
            IF (AMS.LT.UMO(IEO)) AMS=UMO(IEO)
            THRESH(IIKI+IK)=AMS
   60       CONTINUE
   70     CONTINUE
   80   CONTINUE
   90 CONTINUE
      DO 100 J=1,460
  100 HWT(J)=0.D0
      DO 120 I=1,110
        IK1=K1H(I)
        IK2=K2H(I)
        HV=0.D0
        IF (IK2.GT.460)IK2=460
        IF (IK1.LE.0)IK1=1
        DO 110 J=IK1,IK2
          HV=HV+WTI(J)
          HWT(J)=HV
          JI=J
  110   CONTINUE
        IF (ABS(HV-1.0D0).GT.1.D-4) WRITE(ErrorOut,1010)I,JI,HV
 1010 FORMAT (35H ERROR IN HWT, FALSE USE OF CHANWH ,2I6,F10.2)
  120 CONTINUE
      DO 130 J=1,460
  130 WTI(J)=HWT(J)
      RETURN
      END
c
c===dhadde=============================================================*
c
CDECK  ID>, DT_DHADDE
      SUBROUTINE DT_DHADDE

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c HADRIN: decay channel information
      PARAMETER (IDMAX9=602)
      CHARACTER*8 ZKNAME
      COMMON /HNDECH/ ZKNAME(IDMAX9),WT(IDMAX9),NZK(IDMAX9,3)

c particle properties (BAMJET index convention),
c (dublicate of DTPART for HADRIN)
      COMMON /HNABLT/ AMH(110),GAH(110),TAUH(110),ICHH(110),IBARH(110),
     &                K1H(110),K2H(110)

      COMMON /HNSPLI/ WTI(460),NZKI(460,3)

c decay channel information for HADRIN
      COMMON /HNADDH/ AMZ(16),GAZ(16),TAUZ(16),ICHZ(16),IBARZ(16),
     &                K1Z(16),K2Z(16),WTZ(153),II22,
     &                NZK1(153),NZK2(153),NZK3(153)


      DATA IRETUR/0/

      IRETUR=IRETUR+1
      AMH(31)=0.48D0
      IF (IRETUR.GT.1) RETURN
      DO 10 I=1,94
        AMH(I)   = AAM(I)
        GAH(I)   = GA(I)
        TAUH(I)  = TAU(I)
        ICHH(I)  = IICH(I)
        IBARH(I) = IIBAR(I)
        K1H(I)   = K1(I)
        K2H(I)   = K2(I)
   10 CONTINUE
c*sr
C     AMH(1)=0.93828D0
      AMH(1)=0.9383D0
c*
      AMH(2)=AMH(1)
      DO 20 I=26,30
        K1H(I)=452
        K2H(I)=452
   20 CONTINUE
      DO 30 I=1,307
        WTI(I)    = WT(I)
        NZKI(I,1) = NZK(I,1)
        NZKI(I,2) = NZK(I,2)
        NZKI(I,3) = NZK(I,3)
   30 CONTINUE
      DO 40 I=1,16
        L=I+94
        AMH(L)=AMZ(I)
        GAH( L)=GAZ(I)
        TAUH( L)=TAUZ(I)
        ICHH( L)=ICHZ(I)
        IBARH( L)=IBARZ(I)
        K1H( L)=K1Z(I)
        K2H( L)=K2Z(I)
   40 CONTINUE
      DO 50 I=1,153
        L=I+307
        WTI(L)    = WTZ(I)
        NZKI(L,3) = NZK3(I)
        NZKI(L,2) = NZK2(I)
        NZKI(L,1) = NZK1(I)
   50 CONTINUE
      RETURN
      END
c
c===iefund=============================================================*
c
CDECK  ID>, IDT_IEFUND
      INTEGER FUNCTION IDT_IEFUND(PL,IRE)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

C*****IEFUN CALCULATES A MOMENTUM INDEX

      COMMON /HNDRUN/ RUNTES,EFTES

      COMMON /HNREDV/ THRESH(268),IRII(17),IKII(17),IEII(17)

      COMMON /HNREAC/ UMO(296),PLABF(296),SIIN(296),WK(5184),
     &                NRK(2,268),NURE(30,2)


      IPLA=IEII(IRE)+1
     *+1
      IPLE=IEII(IRE+1)
      IF (PL.LT.0.)                                             GO TO 30
      DO 10 I=IPLA,IPLE
        J=I-IPLA+1
        IF (PL.LE.PLABF(I))                                     GO TO 60
   10 CONTINUE
      I=IPLE
      IF ( EFTES.GT.40.D0)                                      GO TO 20
      EFTES=EFTES+1.0D0
      WRITE(ErrorOut,1000)PL,J
   20 CONTINUE
                                                                GO TO 70
   30 CONTINUE
      DO 40 I=IPLA,IPLE
        J=I-IPLA+1
        IF (-PL.LE.UMO(I))                                      GO TO 60
   40 CONTINUE
      I=IPLE
      IF ( EFTES.GT.40.D0)                                      GO TO 50
      EFTES=EFTES+1.0D0
      WRITE(ErrorOut,1000)PL,I
   50 CONTINUE
   60 CONTINUE
   70 CONTINUE
      IDT_IEFUND=I
      RETURN
 1000 FORMAT(14H PLAB OR -ECM=,E12.4,27H IS OUT OF CONSIDERED RANGE ,
     +7H IEFUN=,I5)
      END
c
c===dsigin=============================================================*
c
CDECK  ID>, DT_DSIGIN
      SUBROUTINE DT_DSIGIN(IRE ,PLAB,N,IE ,AMT ,AMN,ECM ,SI ,ITAR)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c particle properties (BAMJET index convention),
c (dublicate of DTPART for HADRIN)
      COMMON /HNABLT/ AMH(110),GAH(110),TAUH(110),ICHH(110),IBARH(110),
     &                K1H(110),K2H(110)

      COMMON /HNREDV/ THRESH(268),IRII(17),IKII(17),IEII(17)

      COMMON /HNREAC/ UMO(296),PLABF(296),SIIN(296),WK(5184),
     &                NRK(2,268),NURE(30,2)


      IE=IDT_IEFUND(PLAB,IRE)
      IF (IE.LE.IEII(IRE)) IE=IE+1
      AMT=AMH(ITAR)
      AMN=AMH(N)
      AMN2=AMN*AMN
      AMT2=AMT*AMT
      ECM=SQRT(AMN2+AMT2+2.0D0*AMT*SQRT(AMN2+PLAB**2))
C*** INTERPOLATION PREPARATION
      ECMO=UMO(IE)
      ECM1=UMO(IE-1)
      DECM=ECMO-ECM1
      DEC=ECMO-ECM
      IIKI=IKII(IRE)+1
      EKLIM=-THRESH(IIKI)
      WOK=SIIN(IE)
      WDK=WOK-SIIN(IE-1)
      IF (ECM.GT.ECMO) WDK=0.0D0
C*** INTERPOLATION IN CHANNEL WEIGHTS
      IELIM=IDT_IEFUND(EKLIM,IRE)
      DELIM=UMO(IELIM)+EKLIM
     *+1.D-16
      DETE=(ECM-(ECMO-EKLIM)*0.5D0)*2.0D0
      IF (DELIM*DELIM-DETE*DETE) 20,20,10
   10 DECC=DELIM
                                                                GO TO 30
   20 DECC=DECM
   30 CONTINUE
      WKK=WOK-WDK*DEC/(DECC+1.D-9)
      IF (WKK.LT.0.0D0) WKK=0.0D0
      SI=WKK+1.D-12
      IF (-EKLIM.GT.ECM) SI=1.D-14
      RETURN
      END
c
c===dtchoi=============================================================*
c
CDECK  ID>, DT_DTCHOI
      SUBROUTINE DT_DTCHOI(T,P,PP,E,EE,I,II,N,AM1,AM2)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

C     ****************************
C     TCHOIC CALCULATES A RANDOM VALUE
C     FOR THE FOUR-MOMENTUM-TRANSFER T
C     ****************************

c particle properties (BAMJET index convention),
c (dublicate of DTPART for HADRIN)
      COMMON /HNABLT/ AMH(110),GAH(110),TAUH(110),ICHH(110),IBARH(110),
     &                K1H(110),K2H(110)

c slope parameters for HADRIN interactions
      COMMON /HNSLOP/ SM(25),BBM(25),BBB(25)


      AMA=AM1
      AMB=AM2
      IF (I.GT.30.AND.II.GT.30)                                 GO TO 20
      III=II
      AM3=AM2
      IF (I.LE.30)                                              GO TO 10
      III=I
      AM3=AM1
   10 CONTINUE
                                                                GO TO 30
   20 CONTINUE
      III=II
      AM3=AM2
      IF (AMA.LE.AMB)                                           GO TO 30
      III=I
      AM3=AM1
   30 CONTINUE
      IB=IBARH(III)
      AMA=AM3
      K=INT((AMA-0.75D0)/0.05D0)
      IF (K-2.LT.0) K=1
      IF (K-26.GE.0) K=25
      IF (IB)50,40,50
   40 BM=BBM(K)
                                                                GO TO 60
   50 BM=BBB(K)
   60 CONTINUE
C     NORMALIZATION
      TMIN=-2.0D0*(E*EE-P*PP)+AMH(N)**2+AM1  **2
      TMAX=-2.0D0*(E*EE+P*PP)+AMH(N)**2+AM1  **2
      VB=DT_RNDM(TMIN)
c*sr test
C     IF (VB.LT.0.2D0) BM=BM*0.1
C    **0.5
      BM = BM*5.05D0
c*
      TMI=BM*TMIN
      TMA=BM*TMAX
      ETMA=0.D0
      IF (ABS(TMA).GT.120.D0)                                   GO TO 70
      ETMA=EXP(TMA)
   70 CONTINUE
      AN=(1.0D0/BM)*(EXP(TMI)-ETMA)
C*** RANDOM CHOICE OF THE T - VALUE
      R=DT_RNDM(TMI)
      T=(1.0D0/BM)*LOG(ETMA+R*AN*BM)
      RETURN
      END
c
c===dtwopa=============================================================*
c
CDECK  ID>, DT_DTWOPA
      SUBROUTINE DT_DTWOPA(E1,E2,P1,P2,COD1,COD2,COF1,COF2,SIF1,SIF2,
     &IT1,IT2,UMOO,ECM,P,N,AM1,AM2)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

C     ******************************************************
C     QUASI TWO PARTICLE PRODUCTION
C     TWOPAR CALCULATES THE ENERGYS AND THE MOMENTA
C     FOR THE CREATED PARTICLES OR RESONANCES IT1 AND IT2
C     IN THE CM - SYSTEM
C     COD1,COD2,COF1,COF2,SIF1,SIF2 ARE THE ANGLES FOR
C     SPHERICAL COORDINATES
C     ******************************************************

c particle properties (BAMJET index convention),
c (dublicate of DTPART for HADRIN)
      COMMON /HNABLT/ AMH(110),GAH(110),TAUH(110),ICHH(110),IBARH(110),
     &                K1H(110),K2H(110)


      AMA=AM1
      AMB=AM2
      AMA2=AMA*AMA
      E1=((UMOO-AMB)*(UMOO+AMB) + AMA2)/(2.0D0*UMOO)
      E2=UMOO - E1
      IF (E1.LT.AMA*1.00001D0) E1=AMA*1.00001D0
      AMTE=(E1-AMA)*(E1+AMA)
      AMTE=AMTE+1.D-18
      P1=SQRT(AMTE)
      P2=P1
C     / P2 / = / P1 /  BUT OPPOSITE DIRECTIONS
C     DETERMINATION  OF  THE ANGLES
C     COS(THETA1)=COD1      COS(THETA2)=COD2
C     SIN(PHI1)=SIF1        SIN(PHI2)=SIF2
C     COS(PHI1)=COF1        COS(PHI2)=COF2
C     PHI IS UNIFORMLY DISTRIBUTED IN ( 0,2*PI )
      CALL DT_DSFECF(COF1,SIF1)
      COF2=-COF1
      SIF2=-SIF1
C     CALCULATION OF THETA1
      CALL DT_DTCHOI(TR,P,P1,ECM,E1,IT1,IT2,N,AM1,AM2)
      COD1=(TR-AMA2-AMH(N)*AMH(N)+2.0D0*ECM*E1)/(2.0D0*P*P1+1.D-18)
      IF (COD1.GT.0.9999999D0) COD1=0.9999999D0
      COD2=-COD1
      RETURN
      END
c
c===zk=================================================================*
c
CDECK  ID>, DT_ZK
      BLOCK DATA DT_ZK

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c decay channel information for HADRIN
      COMMON /HNADDH/ AMZ(16),GAZ(16),TAUZ(16),ICHZ(16),IBARZ(16),
     &                K1Z(16),K2Z(16),WTZ(153),II22,
     &                NZK1(153),NZK2(153),NZK3(153)

c decay channel information for HADRIN
      CHARACTER*8 ANAMZ,ZKNAM4,ZKNAM5,ZKNAM6
      COMMON /HNADDN/ ANAMZ(16),ZKNAM4(9),ZKNAM5(90),ZKNAM6(54)


c     Particle masses in GeV                                           *
      DATA AMZ/ 3*2.2D0, 0.9576D0, 3*1.887D0, 2.4D0, 2.03D0, 2*1.44D0,
     &          2*1.7D0, 3*0.D0/
c     Resonance width Gamma in GeV                                     *
      DATA GAZ/ 3*.2D0, .1D0, 4*.2D0, .18D0, 2*.2D0, 2*.15D0, 3*0.D0 /
c     Mean life time in seconds                                        *
      DATA TAUZ / 16*0.D0 /
c     Charge of particles and resonances                               *
      DATA ICHZ/ 0, 1, 3*0, 1, -1, 0, 1, -1, 0, 0, 1 , 3*0 /
c     Baryonic charge                                                  *
      DATA IBARZ/ 2, 7*0, 1, -1, -1, 1, 1, 3*0 /
c     First number of decay channels used for resonances               *
c     and decaying particles                                           *
      DATA K1Z/ 308,310,313,317,322,365,393,421,425,434,440,446,449,
     &          3*460/
c     Last number of decay channels used for resonances                *
c     and decaying particles                                           *
      DATA K2Z/ 309,312,316,321,364,392,420,424,433,439,445,448,451,
     &          3*460/
c     Weight of decay channel                                          *
      DATA WTZ/ .17D0, .83D0, 2*.33D0, .34D0, .17D0, 2*.33D0, .17D0,
     & .01D0, .13D0, .36D0, .27D0, .23D0, .0014D0, .0029D0, .0014D0,
     & .0029D0, 4*.0007D0, .0517D0, .0718D0, .0144D0, .0431D0, .0359D0,
     & .0718D0, .0014D0, .0273D0, .0014D0, .0431D0, 2*.0129D0, .0259D0,
     & .0517D0, .0359D0, .0014D0, 2*.0144D0, .0129D0, .0014D0, .0259D0,
     & .0359D0, .0072D0, .0474D0, .0948D0, .0259D0, .0072D0, .0144D0,
     & .0287D0, .0431D0, .0144D0, .0287D0, .0474D0, .0144D0, .0075D0,
     & .0057D0, .0019D0, .0038D0, .0095D0, 2*.0014D0, .0191D0, .0572D0,
     & .1430D0, 2*.0029D0, 5*.0477D0, .0019D0, .0191D0, .0686D0,.0172D0,
     & .0095D0, .1888D0, .0172D0, .0191D0, .0381D0, 2*.0571D0, .0190D0,
     & .0057D0, .0019D0, .0038D0, .0095D0, .0014D0, .0014D0, .0191D0,
     & .0572D0, .1430D0, 2*.0029D0, 5*.0477D0, .0019D0, .0191D0,.0686D0,
     & .0172D0, .0095D0, .1888D0, .0172D0, .0191D0, .0381D0, 2*.0571D0,
     & .0190D0, 4*.25D0, 2*.2D0, .12D0, .1D0, .07D0, .07D0, .14D0,
     & 2*.05D0, .0D0, .3334D0, .2083D0, 2*.125D0, .2083D0, .0D0, .125D0,
     & .2083D0, .3334D0, .2083D0, .125D0, .3D0, .05D0, .65D0, .3D0,
     & .05D0, .65D0, 9*1.D0 /
c     Particle numbers in decay channel                                *
      DATA NZK1/ 8, 1, 2, 9, 1, 2, 9, 2, 9, 7, 13, 31, 15, 24, 23, 13,
     & 23, 13, 2*23, 14, 13, 23, 31, 98, 2*33, 32, 23, 14, 13, 35, 2*23,
     & 14, 13, 33, 23, 98, 31, 23, 14, 13, 35, 2*33, 32, 23, 35, 33, 32,
     & 98, 5*35, 4*13, 23, 13, 98, 32, 33, 23, 13, 23, 13, 14, 13, 32,
     & 13, 98, 23, 13, 2*32, 13, 33, 32, 98, 2*35, 4*14, 23, 14, 98,
     & 2*34, 23, 14, 23, 2*14, 13, 34, 14, 98, 23, 14, 2*34, 14, 33, 32,
     & 98, 2*35, 104, 61, 105, 62, 1, 17, 21, 17, 22, 2*21, 22, 21, 2,
     & 67, 68, 69, 2, 2*9, 68, 69, 70, 2, 9, 2*24, 15, 2*25, 16, 9*0/
      DATA NZK2/ 2*8, 1, 8, 9, 2*8, 2*1, 7, 14, 13, 16, 25, 23, 14, 23,
     & 14, 31, 33, 32, 34, 35, 31, 23, 31, 33, 34, 31, 32, 34, 31, 33,
     & 32, 2*33, 35, 31, 33, 31, 33, 32, 34, 35, 31, 33, 34, 35, 31,
     & 4*33, 32, 3*35,  2*23, 13, 31, 32, 33, 13, 31, 32, 2*31, 32, 33,
     & 32, 32, 35, 31, 2*32, 33, 31, 33, 35, 33, 3*32, 35, 2*23, 14,
     & 31, 34, 33, 14, 31, 33, 2*31, 34, 32, 33, 34, 35, 31, 2*34, 33,
     & 31, 33, 35, 33, 2*34, 33, 35, 1, 2, 8, 9, 25, 13, 35, 2*32, 33,
     & 31, 13, 23, 31, 13, 23, 14, 79, 80, 31, 13, 23, 14, 78, 79, 8,
     & 1, 8, 1, 8, 1, 9*0 /
      DATA NZK3/ 23, 14, 2*13, 23, 13, 2*23, 14, 0, 7, 14, 4*0, 2*23,
     & 10*0, 33, 2*31, 0, 33, 34, 32, 34, 0, 35, 0, 31, 3*35, 0, 3*31,
     & 35, 31, 33, 34, 31, 33, 34, 31, 33, 35, 0, 23, 14, 6*0, 32, 3*33,
     & 32, 34, 0, 35, 0, 2*35, 2*31, 35, 32, 34, 31, 33, 32, 0, 23, 13,
     & 6*0, 34, 2*33, 34, 33, 34, 0, 35, 0,2*35, 2*31, 35, 2*34, 31,
     & 2*34, 25*0, 23, 2*14, 23, 2*13, 9*0 /
c     Particle  names                                                  *
      DATA ANAMZ / 'NNPI', 'ANPPI', 'ANNPI', ' ETS  ',' PAP  ',' PAN  ',
     & 'APN', 'DEO   ', 'S+2030', 'AN*-14', 'AN*014','KONPI ','AKOPPI',
     & 3*'BLANK' /
c     Name of decay channel                                            *
      DATA ZKNAM4/'NNPI0','PNPI-','APPPI+','ANNPI+','ANPPI0','APNPI+',
     & 'ANNPI0','APPPI0','ANPPI-'/
      DATA ZKNAM5/' GAGA ','P+P-GA','ETP+P-','K+K-  ','K0AK0 ',
     & ' POPO ',' P+P- ','POPOPO','P+P0P-','P0ET  ','&0R0  ','P-R+  ',
     & 'P+R-  ','POOM  ',' ETET ','ETSP0 ','R0ET  ',' R0R0 ','R+R-  ',
     & 'P0ETR0','P-ETR+','P+ETR-',' OMET ','P0R0R0','P0R+R-','P-R+R0',
     & 'P+R-R0','R0OM  ','P0ETOM','ETSR0 ','ETETET','P0R0OM','P-R+OM',
     & 'P+R-OM','OMOM  ','R0ETET','R0R0ET','R+R-ET','P0OMOM','OMETET',
     & 'R0R0R0','R+R0R-','ETSRET','OMR0R0','OMR+R-','OMOMET','OMOMR0',
     & 'OMOMOM',
     & ' P+PO ','P+POPO','P+P+P-','P+ET  ','P0R+  ','P+R0  ','ETSP+ ',
     & 'R+ET  ',' R0R+ ','POETR+','P+ETR0','POR+R-','P+R0R0','P-R+R+',
     & 'P+R-R+','R+OM  ','P+ETOM','ETSR+ ','POR+OM','P+R0OM','R+ETET',
     & 'R+R0ET','P+OMOM','R0R0R+','R+R+R-','ETSR+E','OMR+R0','OMOMR+',
     & 'P-PO  ','P-POPO','P-P-P+','P-ET  ','POR-  ','P-R0  ','ETSP- ',
     & 'R-ET  ','R-R0  ','POETR-','P-ETR0','POR-R0','P-R+R-','P-R0R0'/
      DATA ZKNAM6/'P+R-R-','R-OM  ','P-ETOM','ETSR- ','POR-OM','P-R0OM',
     & 'R-ETET','R-R0ET','P-OMOM','R0R0R-','R+R-R-','ETSR-E','OMR0R-',
     & 'OMOMR-', 'PAN-14','APN+14','NAN014','ANN014','PAKO  ','LPI+  ',
     & 'SI+OM','LAMRO+','SI0RO+','SI+RO0','SI+ETA','SI0PI+','SI+PI0',
     & 'APETA ','AN=P+ ','AN-PO ','ANOPO ','APRHOO','ANRHO-','ANETA ',
     & 'AN-P+ ','AN0PO ','AN+P- ','APRHO+','ANRHO0',
     & 'KONPIO','KOPPI-','K+NPI-','AKOPPO','AKONP+','K-PPI+',
     & 9*'BLANK'/
c=                                               end*block.zk      *
      END
c
c===blkd43=============================================================*
c
CDECK  ID>, DT_BLKD43
      BLOCK DATA DT_BLKD43

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c$ CREATE REAC.ADD
cCOPY REAC
c
c=== reac =============================================================*
c
c----------------------------------------------------------------------*
c                                                                      *
c     Created on 10 december 1991  by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 10-dec-91     by    Alfredo Ferrari               *
c                                                                      *
c     This is the original common reac of Hadrin                       *
c                                                                      *
c----------------------------------------------------------------------*
c
      COMMON /HNREAC/ UMO(296),PLABF(296),SIIN(296),WK(5184),
     &                NRK(2,268),NURE(30,2)


      DIMENSION
     & UMOPI(92), UMOKC(68), UMOP(39), UMON(63), UMOK0(34),
     & PLAPI(92), PLAKC(68), PLAP(39), PLAN(63), PLAK0(34),
     & SPIKP1(315), SPIKPU(278), SPIKPV(372),
     & SPIKPW(278), SPIKPX(372), SPIKP4(315),
     & SPIKP5(187), SPIKP6(289),
     & SKMPEL(102), SPIKP7(289), SKMNEL(68), SPIKP8(187),
     & SPIKP9(143), SPIKP0(169), SPKPV(143),
     & SAPPEL(105), SPIKPE(399), SAPNEL(84), SPIKPZ(273),
     & SANPEL(84) , SPIKPF(273),
     & SPKP15(187), SPKP16(272),
     & NRKPI(164), NRKKC(132), NRKP(70), NRKN(116), NRKK0(54),
     & NURELN(60)
c
       DIMENSION NRKLIN(532)
       EQUIVALENCE (NRK(1,1), NRKLIN(1))
       EQUIVALENCE (   UMO(  1),  UMOPI(1)), (   UMO( 93),  UMOKC(1))
       EQUIVALENCE (   UMO(161),   UMOP(1)), (   UMO(200),   UMON(1))
       EQUIVALENCE (   UMO(263),  UMOK0(1))
       EQUIVALENCE ( PLABF(  1),  PLAPI(1)), ( PLABF( 93),  PLAKC(1))
       EQUIVALENCE ( PLABF(161),   PLAP(1)), ( PLABF(200),   PLAN(1))
       EQUIVALENCE ( PLABF(263),  PLAK0(1))
       EQUIVALENCE (   WK(   1), SPIKP1(1)), (   WK( 316), SPIKPU(1))
       EQUIVALENCE (   WK( 594), SPIKPV(1)), (   WK( 966), SPIKPW(1))
       EQUIVALENCE (   WK(1244), SPIKPX(1)), (   WK(1616), SPIKP4(1))
       EQUIVALENCE (   WK(1931), SPIKP5(1)), (   WK(2118), SPIKP6(1))
       EQUIVALENCE (   WK(2407), SKMPEL(1)), (   WK(2509), SPIKP7(1))
       EQUIVALENCE (   WK(2798), SKMNEL(1)), (   WK(2866), SPIKP8(1))
       EQUIVALENCE (   WK(3053), SPIKP9(1)), (   WK(3196), SPIKP0(1))
       EQUIVALENCE (   WK(3365),  SPKPV(1)), (   WK(3508), SAPPEL(1))
       EQUIVALENCE (   WK(3613), SPIKPE(1)), (   WK(4012), SAPNEL(1))
       EQUIVALENCE (   WK(4096), SPIKPZ(1)), (   WK(4369), SANPEL(1))
       EQUIVALENCE (   WK(4453), SPIKPF(1)), (   WK(4726), SPKP15(1))
       EQUIVALENCE (   WK(4913), SPKP16(1))
       EQUIVALENCE (NRK(1,1), NRKLIN(1))
       EQUIVALENCE (NRKLIN(   1), NRKPI(1)), (NRKLIN( 165), NRKKC(1))
       EQUIVALENCE (NRKLIN( 297),  NRKP(1)), (NRKLIN( 367),  NRKN(1))
       EQUIVALENCE (NRKLIN( 483), NRKK0(1))
       EQUIVALENCE (NURE(1,1), NURELN(1))
c
c*** pi- p data                                                        *
c*** pi+ n data                                                        *
      DATA PLAPI / 0.D0, .3D0, .5D0, .6D0, .7D0, .8D0, .9D0, .95D0,1.D0,
     & 1.15D0, 1.3D0, 1.5D0, 1.6D0, 1.8D0, 2.D0, 2.3D0, 2.5D0, 2.8D0,
     & 3.D0, 3.5D0, 4.D0, 0.D0, .285D0, .4D0, .45D0, .5D0, .6D0, .7D0,
     & .75D0, .8D0, .85D0, .9D0, 1.D0, 1.15D0, 1.3D0, 1.5D0, 1.6D0,
     & 1.8D0, 2.D0, 2.3D0, 2.5D0, 2.8D0, 3.D0, 3.5D0, 4.D0, 4.5D0, 0.D0,
     & .285D0, .4D0, .45D0, .5D0, .6D0, .7D0, .75D0, .8D0, .85D0, .9D0,
     & 1.D0, 1.15D0, 1.3D0, 1.5D0, 1.6D0, 1.8D0, 2.D0, 2.3D0, 2.5D0,
     & 2.8D0, 3.D0, 3.5D0, 4.D0, 4.5D0, 0.D0, .3D0, .5D0, .6D0, .7D0,
     & .8D0, .9D0, .95D0, 1.D0, 1.15D0, 1.3D0, 1.5D0, 1.6D0, 1.8D0,
     & 2.D0, 2.3D0, 2.5D0, 2.8D0, 3.D0, 3.5D0, 4.D0 /
      DATA PLAKC /
     &   0.D0,  .58D0,   .8D0, 1.01D0, 1.23D0, 1.45D0, 1.68D0, 1.94D0,
     & 2.18D0, 2.42D0, 2.68D0, 2.96D0, 3.24D0,
     & 3.51D0, 3.84D0, 4.16D0, 4.49D0,
     &   0.D0,  .58D0,   .8D0, 1.01D0, 1.23D0, 1.45D0, 1.68D0, 1.94D0,
     & 2.18D0, 2.42D0, 2.68D0, 2.96D0, 3.24D0,
     & 3.51D0, 3.84D0, 4.16D0, 4.49D0,
     &   0.D0,  .58D0,   .8D0, 1.01D0, 1.23D0, 1.45D0, 1.68D0, 1.94D0,
     & 2.18D0, 2.42D0, 2.68D0, 2.96D0, 3.24D0,
     & 3.51D0, 3.84D0, 4.16D0, 4.49D0,
     &   0.D0,  .58D0,   .8D0, 1.01D0, 1.23D0, 1.45D0, 1.68D0, 1.94D0,
     & 2.18D0, 2.42D0, 2.68D0, 2.96D0, 3.24D0,
     & 3.51D0, 3.84D0, 4.16D0, 4.49D0/
      DATA PLAK0 /
     &   0.D0,  .58D0,   .8D0, 1.01D0, 1.23D0, 1.45D0, 1.68D0, 1.94D0,
     & 2.18D0, 2.42D0, 2.68D0, 2.96D0, 3.24D0,
     & 3.51D0, 3.84D0, 4.16D0, 4.49D0,
     &   0.D0,  .58D0,   .8D0, 1.01D0, 1.23D0, 1.45D0, 1.68D0, 1.94D0,
     & 2.18D0, 2.42D0, 2.68D0, 2.96D0, 3.24D0,
     & 3.51D0, 3.84D0, 4.16D0, 4.49D0/
c                 pp   pn   np   nn                                    *
      DATA PLAP /
     &   0.D0, 1.06D0, 1.34D0, 1.63D0, 1.92D0, 2.2D0, 2.5D0,2.8D0,3.1D0,
     & 3.43D0, 3.75D0, 4.07D0, 4.43D0,
     &   0.D0, 1.06D0, 1.34D0, 1.63D0, 1.92D0, 2.2D0, 2.5D0,2.8D0,3.1D0,
     & 3.43D0, 3.75D0, 4.07D0, 4.43D0,
     &   0.D0, 1.06D0, 1.34D0, 1.63D0, 1.92D0, 2.2D0, 2.5D0,2.8D0,3.1D0,
     & 3.43D0, 3.75D0, 4.07D0, 4.43D0 /
c    app   apn   anp   ann                                             *
      DATA PLAN /
     &  0.D0,   1.D-3,   .1D0,   .2D0,   .3D0,  .4D0,  .5D0, .6D0,
     & .74D0,  1.06D0, 1.34D0, 1.63D0, 1.92D0, 2.2D0, 2.5D0,2.8D0,3.1D0,
     & 3.43D0, 3.75D0, 4.07D0, 4.43D0,
     &  0.D0,   1.D-3,   .1D0,   .2D0,   .3D0,  .4D0,  .5D0, .6D0,
     & .74D0,  1.06D0, 1.34D0, 1.63D0, 1.92D0, 2.2D0, 2.5D0,2.8D0,3.1D0,
     & 3.43D0, 3.75D0, 4.07D0, 4.43D0,
     &  0.D0,   1.D-3,   .1D0,   .2D0,   .3D0,  .4D0,  .5D0, .6D0,
     & .74D0,  1.06D0, 1.34D0, 1.63D0, 1.92D0, 2.2D0, 2.5D0,2.8D0,3.1D0,
     & 3.43D0, 3.75D0, 4.07D0, 4.43D0  /
      DATA SIIN / 296*0.D0 /
      DATA UMOPI/ 1.08D0,1.233D0,1.302D0,1.369D0,1.496D0,
     & 1.557D0,1.615D0,1.6435D0,
     & 1.672D0,1.753D0,1.831D0,1.930D0,1.978D0,2.071D0,2.159D0,
     & 2.286D0,2.366D0,2.482D0,2.56D0,
     & 2.735D0,2.90D0,
     &             1.08D0,1.222D0,1.302D0,1.3365D0,1.369D0,1.434D0,
     & 1.496D0,1.527D0,1.557D0,
     & 1.586D0,1.615D0,1.672D0,1.753D0,1.831D0,1.930D0,1.978D0,
     & 2.071D0,2.159D0,2.286D0,2.366D0,
     & 2.482D0,2.560D0,2.735D0,2.90D0,3.06D0,
     &             1.08D0,1.222D0,1.302D0,1.3365D0,1.369D0,1.434D0,
     & 1.496D0,1.527D0,1.557D0,
     & 1.586D0,1.615D0,1.672D0,1.753D0,1.831D0,1.930D0,1.978D0,
     & 2.071D0,2.159D0,2.286D0,2.366D0,
     & 2.482D0,2.560D0,2.735D0,2.90D0,3.06D0,
     &                   1.08D0,1.233D0,1.302D0,1.369D0,1.496D0,
     & 1.557D0,1.615D0,1.6435D0,
     & 1.672D0,1.753D0,1.831D0,1.930D0,1.978D0,2.071D0,2.159D0,
     & 2.286D0,2.366D0,2.482D0,2.56D0,
     &  2.735D0, 2.90D0/
      DATA UMOKC/ 1.44D0,
     &  1.598D0,1.7D0,1.8D0,1.9D0,2.0D0,2.1D0,2.2D0,2.3D0,2.4D0,2.5D0,
     & 2.6D0,2.7D0,2.8D0,2.9D0,3.0D0,
     & 3.1D0,1.44D0,
     &  1.598D0,1.7D0,1.8D0,1.9D0,2.0D0,2.1D0,2.2D0,2.3D0,2.4D0,2.5D0,
     & 2.6D0,2.7D0,2.8D0,2.9D0,3.0D0,
     & 3.1D0,1.44D0,
     &  1.598D0,1.7D0,1.8D0,1.9D0,2.0D0,2.1D0,2.2D0,2.3D0,2.4D0,2.5D0,
     & 2.6D0,2.7D0,2.8D0,2.9D0,3.0D0,
     & 3.1D0,1.44D0,
     &  1.598D0,1.7D0,1.8D0,1.9D0,2.0D0,2.1D0,2.2D0,2.3D0,2.4D0,2.5D0,
     & 2.6D0,2.7D0,2.8D0,2.9D0,3.0D0,
     &  3.1D0/
      DATA UMOK0/ 1.44D0,
     &  1.598D0,1.7D0,1.8D0,1.9D0,2.0D0,2.1D0,2.2D0,2.3D0,2.4D0,2.5D0,
     & 2.6D0,2.7D0,2.8D0,2.9D0,3.0D0,
     & 3.1D0,1.44D0,
     &  1.598D0,1.7D0,1.8D0,1.9D0,2.0D0,2.1D0,2.2D0,2.3D0,2.4D0,2.5D0,
     & 2.6D0,2.7D0,2.8D0,2.9D0,3.0D0,
     &  3.1D0/
c                 pp   pn   np   nn                                    *
      DATA UMOP/
     & 1.88D0,2.102D0,2.2D0,2.3D0,2.4D0,2.5D0,2.6D0,2.7D0,2.8D0,2.9D0,
     & 3.D0,3.1D0,3.2D0,
     & 1.88D0,2.102D0,2.2D0,2.3D0,2.4D0,2.5D0,2.6D0,2.7D0,2.8D0,2.9D0,
     & 3.D0,3.1D0,3.2D0,
     & 1.88D0,2.102D0,2.2D0,2.3D0,2.4D0,2.5D0,2.6D0,2.7D0,2.8D0,2.9D0,
     & 3.D0,3.1D0,3.2D0/
c    app   apn   anp   ann                                             *
      DATA UMON /
     & 1.877D0,1.87701D0,1.879D0,1.887D0,1.9D0,1.917D0,1.938D0,1.962D0,
     & 2.D0,2.102D0,2.2D0,2.3D0,2.4D0,2.5D0,2.6D0,2.7D0,2.8D0,2.9D0,
     & 3.D0,3.1D0,3.2D0,
     & 1.877D0,1.87701D0,1.879D0,1.887D0,1.9D0,1.917D0,1.938D0,1.962D0,
     & 2.D0,2.102D0,2.2D0,2.3D0,2.4D0,2.5D0,2.6D0,2.7D0,2.8D0,2.9D0,
     & 3.D0,3.1D0,3.2D0,
     & 1.877D0,1.87701D0,1.879D0,1.887D0,1.9D0,1.917D0,1.938D0,1.962D0,
     & 2.D0,2.102D0,2.2D0,2.3D0,2.4D0,2.5D0,2.6D0,2.7D0,2.8D0,2.9D0,
     &  3.D0,3.1D0,3.2D0/
c*** reaction channel state particles                                  *
      DATA NRKPI / 13, 1, 15, 21, 81, 0, 13, 54, 23, 53, 13, 63, 13, 58,
     & 23, 57, 13, 65, 1, 32, 53, 31, 54, 32, 53, 33, 53, 35, 63, 32,
     & 13, 8, 23, 1, 17, 15, 21, 24, 22, 15, 82, 0, 61, 0, 13, 55, 23,
     & 54, 14, 53, 13, 64, 23, 63, 13, 59, 23, 58, 14, 57, 13, 66, 23,
     & 65, 1, 31, 8, 32, 1, 33, 1, 35, 54, 31, 55, 32, 54, 33, 53, 34,
     & 54, 35, 14, 1, 23, 8, 17, 24, 20, 15, 22, 24, 83, 0, 62, 0, 14,
     & 54, 23, 55, 13, 56, 14, 63, 23, 64, 14, 58, 23, 59, 13, 60, 14,
     & 65, 23, 66, 8, 31, 1, 34, 8, 33, 8, 35, 55, 31, 54, 34, 55, 33,
     & 56, 32, 55, 35, 14, 8, 24, 20, 84, 0, 14, 55, 23, 56, 14, 64, 14,
     & 59, 23, 60, 14, 66, 8, 34, 56, 31, 55, 34, 56, 33, 56, 35, 64,34/
      DATA NRKKC/ 15, 1, 89, 0, 24, 53, 15, 54, 1, 36, 1, 40, 1, 44, 36,
     & 63, 15, 63, 45, 53, 44, 54, 15, 8, 24, 1, 91, 0, 24, 54, 15, 55,
     & 8, 36, 1, 37, 8, 40, 1, 41, 8, 44, 1, 45, 36, 64, 37, 63, 15, 64,
     & 24, 63, 45, 54, 44, 55, 16, 1, 25, 8, 17, 23, 21, 14, 20,
     & 13, 22, 23, 90, 0, 38, 1, 39, 8, 16, 54, 25, 55, 1, 42, 8, 43,
     & 16, 63, 25, 64, 39, 64, 38, 63, 46, 54, 47, 55, 8, 47, 1, 46, 52,
     & 0, 51, 0, 16, 8, 17, 14, 20, 23, 22, 14, 92, 0, 8, 38, 16, 55,
     & 25, 56, 8, 42, 16, 64, 38, 64, 46, 55, 47, 56, 8, 46, 94, 0 /
c                                                                      *
c   k0 p   k0 n   ak0 p   ak/ n                                        *
c                                                                      *
      DATA NRKK0 / 24, 8, 106, 0, 15, 56, 24, 55, 37, 8, 41, 8, 45, 8,
     & 37, 64, 24, 64, 44, 56, 45, 55, 25, 1, 17, 13,   22, 13, 21, 23,
     & 107, 0, 39, 1, 25, 54, 16, 53, 43, 1, 25, 63, 39, 63, 47, 54, 46,
     & 53, 47, 1, 103, 0, 93, 0/
c   pp  pn   np   nn                                                   *
      DATA NRKP / 1, 1, 85, 0, 8, 53, 1, 54, 1, 63, 8, 57, 1, 58, 2*54,
     & 53, 55, 63, 54, 64, 53, 1, 8, 86, 0, 8, 54, 1, 55, 8, 63, 1, 64,
     & 8, 58, 1, 59, 64, 54, 63, 55, 54, 55, 53, 56, 77, 0, 2*8, 95, 0,
     & 8, 55, 1, 56, 8, 64, 8, 59, 1, 60, 2*55, 54, 56, 64, 55, 63, 56 /
c     app   apn   anp   ann                                            *
      DATA NRKN/ 1, 2, 17, 18, 15, 16, 8, 9, 13, 14, 99, 0, 87, 0, 1,
     & 68, 8, 69, 2, 54, 9, 55, 102, 0, 2, 63, 9, 64, 1, 75, 8, 76, 53,
     & 67, 54, 68, 55, 69, 56, 70, 63, 68, 64, 69, 75, 54, 76, 55, 2, 8,
     & 18, 20, 16, 24, 14, 23, 101, 0, 88, 0, 2, 55, 9, 56, 1, 67, 8,
     & 68, 2, 64, 8, 75, 2, 59, 8, 72, 68, 55, 67, 54, 69, 56, 1, 9, 18,
     & 21, 15, 25, 13, 23, 100, 0, 96, 0, 2, 53, 9, 54, 1, 69, 8, 70, 1,
     & 76, 9, 63, 1, 73, 9, 58, 55, 70, 53, 68, 54, 69 /
c*** channel cross section                                             *
      DATA SPIKP1/ 0.D0, 300.D0, 40.D0, 20.D0, 13.D0,8.5D0,8.D0, 9.5D0,
     & 12.D0,14.D0,15.5D0,20.D0,17.D0,13.D0,10.D0,9.D0,8.5D0,8.D0,7.8D0,
     & 7.3D0, 6.7D0, 9*0.D0,.23D0,.35D0,.7D0,.52D0,.4D0,.3D0,.2D0,.15D0,
     & .13D0, .11D0, .09D0, .07D0, 0.D0, .033D0,.8D0,1.35D0,1.35D0,.5D0,
     & 15*0.D0, 3*0.D0,.00D0,0.80D0,2.2D0,3.6D0,4.6D0,4.7D0,3.5D0,2.4D0,
     &1.8D0,1.4D0,.75D0,.47D0,.25D0,.13D0,.08D0,6*0.D0,0.D0,1.2D0,3.3D0,
     & 5.4D0,6.9D0,7.3D0,5.3D0,3.6D0,2.7D0,2.2D0,1.1D0,.73D0,.4D0,.22D0,
     & .12D0,9*0.D0,.0D0,0.D0,2.0D0,4.4D0,6.8D0,9.9D0,7.9D0,6.0D0,3.8D0,
     &2.5D0,2.D0,1.4D0,1.D0,.6D0,.35D0,10*0.D0,.25D0,.55D0,.75D0,1.25D0,
     & 1.9D0,2.D0,1.8D0,1.5D0,1.25D0,1.D0,.8D0,6*0.D0,4*0.D0,.4D0,.85D0,
     & 1.1D0, 1.85D0, 2.8D0, 3.D0,2.7D0,2.2D0,1.85D0,1.5D0,1.2D0,6*0.D0,
     & 6*0.D0, .5D0, 1.2D0, 1.7D0, 3.4D0, 5.2D0, 6.4D0, 6.1D0, 5.6D0,
     & 5.2D0, 6*0.D0, 2*0.D0, .0D0, 1.D0, 3.3D0, 5.2D0, 4.45D0, 3.6D0,
     & 2.75D0, 1.9D0, 1.65D0, 1.3D0, .95D0, .6D0, .45D0, 6*0.D0, 3*0.D0,
     & .0D0, .45D0, 1.4D0, 1.5D0, 1.1D0, .85D0, .5D0, .3D0, .2D0, .15D0,
     & 8*0.D0, 5*0.D0, .0D0, .0D0, .6D0, .8D0, .95D0, .8D0, .7D0, .6D0,
     & .5D0, .4D0, 6*0.D0, 5*0.D0, .0D0, .00D0, .85D0, 1.2D0, 1.4D0,
     & 1.2D0, 1.05D0, .9D0, .7D0, .55D0, 6*0.D0, 5*0.D0, .0D0, .00D0,
     & 1.D0, 1.5D0, 3.5D0, 4.15D0, 3.7D0, 2.7D0, 2.3D0, 1.75D0, 6*0.D0,
     & 10*0.D0, .5D0, 2.0D0, 3.3D0, 5.4D0, 7.D0 /
c*** pi+ n data                                                        *
      DATA SPIKPU/   0.D0, 25.D0, 13.D0,  11.D0, 10.5D0, 14.D0,  20.D0,
     & 20.D0, 16.D0, 14.D0, 19.D0, 28.D0, 17.5D0, 13.5D0, 12.D0, 10.5D0,
     & 10.D0, 10.D0, 9.5D0,  9.D0, 8.D0, 7.5D0, 7.D0, 6.5D0, 6.D0, 0.D0,
     & 48.D0, 19.D0, 15.D0, 11.5D0, 10.D0, 8.D0, 6.5D0,   5.5D0,  4.8D0,
     & 4.2D0, 7.5D0, 3.4D0,  2.5D0, 2.5D0, 2.1D0, 1.4D0,   1.D0,   .8D0,
     &  .6D0, .46D0,  .3D0, .2D0, .15D0, .13D0, 11*0.D0,  .95D0,  .65D0,
     & .48D0, .35D0,  .2D0, .18D0, .17D0, .16D0,  .15D0,   .1D0,  .09D0,
     & .065D0, .05D0, .04D0, 12*0.D0, .2D0, .25D0, .25D0,  .2D0,   .1D0,
     & .08D0, .06D0, .045D0,   .03D0, .02D0, .01D0,      .005D0, .003D0,
     & 12*0.D0, .3D0, .24D0,   .18D0, .15D0, .13D0,  .12D0, .11D0, .1D0,
     & .09D0,  .08D0, .05D0,   .04D0, .03D0,  0.D0, 0.16D0, .7D0, 1.3D0,
     & 3.1D0,  4.5D0,  2.D0, 18*0.D0, 3*.0D0,  0.D0, 0.D0, 4.0D0, 11.D0,
     & 11.4D0, 10.3D0, 7.5D0, 6.8D0, 4.75D0, 2.5D0,  1.5D0, .9D0, .55D0,
     &  .35D0, 13*0.D0, .1D0, .34D0, .5D0, .8D0, 1.1D0,   2.25D0, 3.3D0,
     & 2.3D0, 1.6D0, .95D0, .45D0, .28D0, .15D0, 10*0.D0, 2*0.D0, .17D0,
     & .64D0,  1.D0, 1.5D0, 2.1D0, 4.25D0, 6.2D0,  4.4D0,   3.D0, 1.8D0,
     &  .9D0, .53D0, .28D0,      10*0.D0, 2*0.D0,  .25D0,  .82D0,
     & 1.3D0, 1.9D0, 2.8D0, 5.5D0 , 8.D0,  5.7D0, 3.9D0, 2.35D0, 1.15D0,
     & .69D0, .37D0, 10*0.D0,     7*0.D0,   .0D0, .34D0,  1.5D0, 3.47D0,
     & 5.87D0, 6.23D0, 4.27D0, 2.6D0, 1.D0, .6D0,  .3D0,  .15D0, 6*0.D0/
c
      DATA SPIKPV/ 7*0.D0, .00D0, .16D0, .75D0, 1.73D0, 2.93D0, 3.12D0,
     & 2.13D0, 1.3D0, .5D0, .3D0, .15D0, .08D0, 6*0.D0, 10*0.D0, .2D0,
     & .6D0, .92D0, 2.4D0, 4.9D0, 6.25D0, 5.25D0, 3.5D0, 2.15D0, 1.4D0,
     & 1.D0, .7D0, 13*0.D0, .13D0, .4D0, .62D0, 1.6D0, 3.27D0, 4.17D0,
     & 3.5D0, 2.33D0, 1.43D0, .93D0, .66D0, .47D0, 13*0.D0, .07D0, .2D0,
     & .31D0, .8D0, 1.63D0, 2.08D0, 1.75D0, 1.17D0, .72D0, .47D0, .34D0,
     & .23D0, 17*0.D0, .33D0, 1.D0, 1.8D0, 2.67D0, 5.33D0, 6.D0, 5.53D0,
     & 5.D0, 17*0.D0, .17D0, .5D0, .9D0, 1.83D0, 2.67D0, 3.0D0, 2.77D0,
     & 2.5D0, 3*0.D0, 3*0.D0, 1.D0, 3.3D0, 2.8D0, 2.5D0, 2.3D0, 1.8D0,
     & 1.5D0, 1.1D0, .8D0, .7D0, .55D0, .3D0, 10*0.D0, 9*0.D0, .1D0,
     & .4D0, 1.D0, 1.4D0, 2.2D0, 2.5D0, 2.2D0, 1.65D0, 1.35D0, 1.1D0,
     & .8D0, .6D0, .4D0, 12*0.D0, .15D0, .6D0, 1.5D0, 2.1D0, 3.3D0,
     & 3.8D0, 3.3D0, 2.45D0, 2.05D0, 1.65D0, 1.2D0, .9D0, .6D0, 3*0.D0,
     & 9*0.D0, .10D0, .2D0, .5D0, .7D0, 1.3D0, 1.55D0, 1.9D0, 1.8D0,
     & 1.55D0, 1.35D0, 1.15D0, .95D0, .7D0, 13*0.D0, .2D0, .5D0, .7D0,
     & 1.3D0, 1.55D0, 1.9D0, 1.8D0, 1.55D0, 1.35D0, 1.15D0, .95D0, .7D0,
     & 17*0.D0, .2D0, .5D0, .85D0, 2.D0, 2.15D0, 2.05D0, 1.75D0, 1.D0,
     & 17*0.D0, .13D0, .33D0, .57D0, 1.33D0, 1.43D0, 1.36D0, 1.17D0,
     & .67D0, 17*0.D0, .07D0, .17D0, .28D0, .67D0, .72D0, .69D0, .58D0,
     & .33D0,17*0.D0,.4D0, .7D0, 1.D0, 1.6D0, 1.8D0, 2.3D0,1.9D0,1.7D0 /
c*** pi- p data                                                        *
      DATA SPIKPW/ 0.D0, 25.D0, 13.D0, 11.D0, 10.5D0, 14.D0, 2*20.D0,
     & 16.D0, 14.D0, 19.D0, 28.D0, 17.5D0, 13.5D0, 12.D0, 10.5D0,
     & 2*10.D0, 9.5D0, 9.D0, 8.D0, 7.5D0, 7.D0, 6.5D0, 6.D0, 0.D0,
     & 48.D0, 19.D0, 15.D0, 11.5D0, 10.D0, 8.D0, 6.5D0, 5.5D0, 4.8D0,
     & 4.2D0, 7.5D0, 3.4D0, 2*2.5D0, 2.1D0, 1.4D0, 1.D0, .8D0, .6D0,
     & .46D0, .3D0, .2D0, .15D0, .13D0, 11*0.D0, .95D0, .65D0, .48D0,
     & .35D0, .2D0, .18D0, .17D0, .16D0, .15D0, .1D0, .09D0, .065D0,
     & .05D0, .04D0, 12*0.D0, .2D0, 2*.25D0, .2D0, .1D0, .08D0, .06D0,
     & .045D0, .03D0, .02D0, .01D0, .005D0, .003D0, 12*0.D0, .3D0,
     & .24D0, .18D0, .15D0, .13D0, .12D0, .11D0, .1D0, .09D0, .08D0,
     & .05D0, .04D0, .03D0, 0.D0, 0.16D0, .7D0, 1.3D0, 3.1D0, 4.5D0,
     & 2.D0, 23*0.D0, 4.0D0, 11.D0, 11.4D0, 10.3D0, 7.5D0, 6.8D0,
     & 4.75D0, 2.5D0, 1.5D0, .9D0, .55D0, .35D0, 13*0.D0, .1D0, .34D0,
     & .5D0, .8D0, 1.1D0, 2.25D0, 3.3D0, 2.3D0, 1.6D0, .95D0, .45D0,
     & .28D0, .15D0, 12*0.D0, .17D0, .64D0, 1.D0, 1.5D0, 2.1D0, 4.25D0,
     & 6.2D0, 4.4D0, 3.D0, 1.8D0, .9D0, .53D0, .28D0, 12*0.D0, .25D0,
     & .82D0, 1.3D0, 1.9D0, 2.8D0, 5.5D0, 8.D0, 5.7D0, 3.9D0, 2.35D0,
     & 1.15D0, .69D0, .37D0, 18*0.D0, .34D0, 1.5D0, 3.47D0, 5.87D0,
     & 6.23D0, 4.27D0, 2.6D0, 1.D0, .6D0, .3D0, .15D0, 6*0.D0/
c
      DATA SPIKPX/ 8*0.D0, .16D0, .75D0, 1.73D0, 2.93D0, 3.12D0,
     & 2.13D0, 1.3D0, .5D0, .3D0, .15D0, .08D0, 16*0.D0, .2D0, .6D0,
     & .92D0, 2.4D0, 4.9D0, 6.25D0, 5.25D0, 3.5D0, 2.15D0, 1.4D0, 1.D0,
     & .7D0, 13*0.D0, .13D0, .4D0, .62D0, 1.6D0, 3.27D0, 4.17D0, 3.5D0,
     & 2.33D0, 1.43D0, .93D0, .66D0, .47D0, 13*0.D0, .07D0, .2D0, .31D0,
     & .8D0, 1.63D0, 2.08D0, 1.75D0, 1.17D0, .72D0, .47D0, .34D0, .23D0,
     & 17*0.D0, .33D0, 1.D0, 1.8D0, 2.67D0, 5.33D0, 6.D0, 5.53D0, 5.D0,
     & 17*0.D0, .17D0, .5D0, .9D0, 1.83D0, 2.67D0, 3.0D0, 2.77D0, 2.5D0,
     & 6*0.D0, 1.D0, 3.3D0, 2.8D0, 2.5D0, 2.3D0, 1.8D0, 1.5D0, 1.1D0,
     & .8D0, .7D0, .55D0, .3D0, 19*0.D0, .1D0, .4D0, 1.D0, 1.4D0, 2.2D0,
     & 2.5D0, 2.2D0, 1.65D0, 1.35D0, 1.1D0, .8D0, .6D0, .4D0, 12*0.D0,
     & .15D0, .6D0, 1.5D0, 2.1D0, 3.3D0, 3.8D0, 3.3D0, 2.45D0, 2.05D0,
     & 1.65D0, 1.2D0, .9D0, .6D0, 12*0.D0, .10D0, .2D0, .5D0, .7D0,
     & 1.3D0, 1.55D0, 1.9D0, 1.8D0, 1.55D0, 1.35D0, 1.15D0, .95D0, .7D0,
     & 13*0.D0, .2D0, .5D0, .7D0, 1.3D0, 1.55D0, 1.9D0, 1.8D0, 1.55D0,
     & 1.35D0, 1.15D0, .95D0, .7D0, 17*0.D0, .2D0, .5D0, .85D0, 2.D0,
     & 2.15D0, 2.05D0, 1.75D0, 1.D0, 17*0.D0, .13D0, .33D0, .57D0,
     & 1.33D0, 1.43D0, 1.36D0, 1.17D0, .67D0, 17*0.D0, .07D0, .17D0,
     & .28D0, .67D0, .72D0, .69D0, .58D0, .33D0, 17*0.D0, .4D0, .7D0,
     & 1.D0, 1.6D0, 1.8D0, 2.3D0, 1.9D0, 1.7D0 /
c*** pi- n data                                                        *
      DATA SPIKP4 / 0.D0, 300.D0, 40.D0, 20.D0, 13.D0, 8.5D0, 8.D0,
     & 9.5D0, 12.D0, 14.D0, 15.5D0, 20.D0, 17.D0, 13.D0, 10.D0, 9.D0,
     & 8.5D0, 8.D0, 7.8D0, 7.3D0, 6.7D0, 9*0.D0, .23D0, .35D0, .7D0,
     & .52D0, .4D0, .3D0, .2D0, .15D0, .13D0, .11D0, .09D0, .07D0, 0.D0,
     & .033D0, .8D0, 2*1.35D0, .5D0, 19*0.D0, 0.8D0, 2.2D0, 3.6D0,
     & 4.6D0, 4.7D0, 3.5D0, 2.4D0, 1.8D0, 1.4D0, .75D0, .47D0, .25D0,
     & .13D0, .08D0, 7*0.D0, 1.2D0, 3.3D0, 5.4D0, 6.9D0, 7.3D0, 5.3D0,
     & 3.6D0, 2.7D0, 2.2D0, 1.1D0, .73D0, .4D0, .22D0, .12D0, 11*0.D0,
     & 2.0D0, 4.4D0, 6.8D0, 9.9D0, 7.9D0, 6.0D0, 3.8D0, 2.5D0, 2.D0,
     & 1.4D0, 1.D0, .6D0, .35D0, 10*0.D0, .25D0, .55D0, .75D0, 1.25D0,
     & 1.9D0, 2.D0, 1.8D0, 1.5D0, 1.25D0, 1.D0, .8D0, 10*0.D0, .4D0,
     & .85D0, 1.1D0, 1.85D0, 2.8D0, 3.D0, 2.7D0, 2.2D0, 1.85D0, 1.5D0,
     & 1.2D0, 12*0.D0, .5D0, 1.2D0, 1.7D0, 3.4D0, 5.2D0, 6.4D0, 6.1D0,
     & 5.6D0, 5.2D0, 9*0.D0, 1.D0, 3.3D0, 5.2D0, 4.45D0, 3.6D0, 2.75D0,
     & 1.9D0, 1.65D0, 1.3D0, .95D0, .6D0, .45D0, 10*0.D0, .45D0, 1.4D0,
     & 1.5D0, 1.1D0, .85D0, .5D0, .3D0, .2D0, .15D0, 15*0.D0, .6D0,
     & .8D0, .95D0, .8D0, .7D0, .6D0, .5D0, .4D0, 13*0.D0, .85D0, 1.2D0,
     & 1.4D0, 1.2D0, 1.05D0, .9D0, .7D0, .55D0, 13*0.D0, 1.D0, 1.5D0,
     & 3.5D0, 4.15D0, 3.7D0, 2.7D0, 2.3D0, 1.75D0, 16*0.D0, .5D0, 2.0D0,
     & 3.3D0, 5.4D0, 7.D0 /
c*** k+  p data                                                        *
      DATA SPIKP5/ 0.D0, 20.D0, 14.D0, 12.D0, 11.5D0, 10.D0, 8.D0,
     & 7.D0, 6.D0, 5.5D0, 5.3D0, 5.D0, 4.5D0, 4.4D0, 3.8D0, 3.D0, 2.8D0,
     & 0.D0, .5D0, 1.15D0, 2.D0, 1.3D0, .8D0, .45D0, 13*0.D0, 0.9D0,
     & 2.5D0, 3.D0, 2.5D0, 2.3D0, 2.D0, 1.7D0, 1.5D0, 1.2D0, .9D0, .6D0,
     & .45D0, .21D0, .2D0, 3*0.D0, .9D0, 2.5D0, 3.D0, 2.5D0, 2.3D0,
     & 2.D0, 1.7D0, 1.5D0, 1.2D0, .9D0, .6D0, .45D0, .21D0, .2D0,
     & 4*0.D0, 1.D0, 2.1D0, 2.6D0, 2.3D0, 2.1D0, 1.8D0, 1.7D0, 1.4D0,
     & 1.2D0, 1.05D0, .9D0, .66D0, .5D0, 7*0.D0, .3D0, 2*1.D0, .9D0,
     & .7D0, .4D0, .3D0, .2D0, 11*0.D0, .1D0, 1.D0, 2.2D0, 3.5D0, 4.2D0,
     & 4.55D0, 4.85D0, 4.9D0, 10*0.D0, .2D0, .7D0, 1.6D0, 2.5D0, 2.2D0,
     & 1.71D0, 1.6D0, 6*0.D0, 1.4D0, 3.8D0, 5.D0, 4.7D0, 4.4D0, 4.D0,
     & 3.5D0, 2.85D0, 2.35D0, 2.01D0, 1.8D0, 12*0.D0, .1D0, .8D0,2.05D0,
     & 3.31D0, 3.5D0, 12*0.D0, .034D0, .2D0, .75D0, 1.04D0, 1.24D0 /
c*** k+  n data                                                        *
      DATA SPIKP6/ 0.D0, 6.D0, 11.D0, 13.D0, 6.D0, 5.D0, 3.D0, 2.2D0,
     & 1.5D0, 1.2D0, 1.D0, .7D0, .6D0, .5D0, .45D0, .35D0, .3D0, 0.D0,
     & 6.D0, 11.D0, 13.D0, 6.D0, 5.D0, 3.D0, 2.2D0, 1.5D0, 1.2D0, 1.D0,
     & .7D0, .6D0, .5D0, .45D0, .35D0, .3D0, 0.D0, .5D0, 1.3D0, 2.8D0,
     & 2.3D0, 1.6D0, .9D0, 13*0.D0, 0.9D0, 2.5D0, 3.D0, 2.5D0, 2.3D0,
     & 2.D0, 1.7D0, 1.5D0,1.2D0,.9D0,.6D0,.45D0,.21D0,.2D0,3*0.D0,0.9D0,
     & 2.5D0, 3.D0, 2.5D0, 2.3D0,2.D0,1.7D0,1.5D0,1.2D0,.9D0,.6D0,.45D0,
     & .21D0, .2D0,4*0.D0,1.D0,2.1D0,2.6D0,2.3D0,2.D0,1.8D0,1.7D0,1.4D0,
     & 1.2D0,1.15D0,.9D0,.66D0,.5D0,4*0.D0,1.D0,2.1D0,2.6D0,2.3D0,2.1D0,
     & 1.8D0,1.7D0,1.4D0,1.2D0, 1.15D0, .9D0, .66D0, .5D0, 7*0.D0, .3D0,
     & 2*1.D0, .9D0, .7D0, .4D0, .35D0, .2D0, 9*0.D0, .3D0, 2*1.D0,.9D0,
     & .7D0, .4D0, .35D0, .2D0, 11*0.D0, .1D0, 1.D0, 2.4D0,3.5D0,4.25D0,
     & 4.55D0, 4.85D0, 4.9D0, 9*0.D0, .1D0, 1.D0, 2.4D0, 3.5D0, 4.25D0,
     & 4.55D0, 4.85D0, 4.9D0, 10*0.D0, .2D0, .7D0, 1.6D0, 2.5D0, 2.2D0,
     & 1.71D0, 1.6D0, 10*0.D0, .2D0, .7D0, 1.6D0, 2.5D0, 2.2D0, 1.71D0,
     & 1.6D0, 6*0.D0, 1.4D0, 3.8D0, 5.D0, 4.7D0,4.4D0,4.D0,3.5D0,2.85D0,
     & 2.35D0, 2.01D0, 1.8D0, 6*0.D0, 1.4D0,3.8D0,5.D0,4.7D0,4.4D0,4.D0,
     & 3.5D0,2.85D0,2.35D0,2.01D0,1.8D0,12*0.D0,.1D0,.8D0,2.05D0,3.31D0,
     & 3.5D0, 12*0.D0, .034D0,.2D0,.75D0,1.04D0,1.24D0 /
c*** k-  p data                                                        *
      DATA SKMPEL/ 0.D0, 35.D0, 22.D0, 25.D0, 17.D0, 9.D0, 9.5D0, 8.D0,
     &     7.D0, 6.5D0, 6.1D0, 5.D0, 4.8D0, 4.6D0, 4.45D0, 4.3D0, 4.2D0,
     &    0.D0, 8.D0, 3.5D0, 8.D0, 3.D0, 1.9D0, 1.7D0, 1.D0, .9D0, .8D0,
     &    .75D0, .5D0, .42D0, .38D0, .34D0, .25D0, .2D0,
     &    0.D0, 3.D0, 3.2D0, 3.5D0, 1.5D0, 1.4D0, 1.1D0, .6D0, .5D0,
     &    .35D0, .28D0, .25D0, .18D0, .12D0, .1D0, .08D0, .04D0,
     &    0.D0, 8.5D0, 2.4D0, 1.7D0, 1.3D0, 1.3D0, 1.1D0, .5D0,
     &    .4D0, .4D0, .35D0, .3D0, .28D0, .2D0, .16D0, .13D0, .11D0,
     &    0.D0, 7.D0, 4.8D0, 1.4D0, 1.9D0, .9D0, .4D0, .2D0, .13D0,
     &    .1D0, .08D0, .06D0, .04D0, .02D0, .015D0, .01D0, .01D0,
     &    0.D0, 5.5D0, 1.D0, .8D0, .75D0, .32D0, .2D0, .1D0, .09D0,
     &    .08D0, .065D0, .05D0, .04D0, .022D0, .017D0, 2*.01D0/
      DATA SPIKP7 / 0.D0, .56D0, 1.46D0, 3.16D0, 2.01D0, 1.28D0, .74D0,
     & 14*0.D0, 1.13D0, 2.61D0, 2.91D0, 2.58D0, 2.35D0, 2.02D0,
     & 1.91D0, 1.57D0, 1.35D0, 1.29D0, 1.01D0, .74D0, .65D0, 4*0.D0,
     & 1.13D0, 2.61D0, 2.91D0, 2.58D0, 2.35D0, 2.02D0, 1.91D0, 1.57D0,
     & 1.35D0, 1.29D0, 1.01D0, .74D0, .65D0,  3*0.D0, 1.0D0, 3.03D0,
     & 3.36D0, 2.8D0, 2.58D0, 2.24D0, 1.91D0, 1.68D0, 1.35D0, 1.01D0,
     & .67D0, .5D0, .24D0, .23D0, 3*0.D0, 1.0D0, 3.03D0, 3.36D0, 2.8D0,
     & 2.58D0, 2.24D0, 1.91D0, 1.68D0, 1.35D0, 1.01D0, .67D0, .5D0,
     & .24D0, .23D0, 7*0.D0, .34D0, 1.12D0, 1.12D0, 1.01D0, .78D0,
     & .45D0, .39D0, .22D0, .07D0, 0.D0, 7*0.D0, .34D0, 1.12D0, 1.12D0,
     & 1.01D0, .78D0, .45D0, .39D0, .22D0, .07D0, 0.D0, 6*0.D0, 1.71D0,
     & 4.26D0, 5.6D0, 5.57D0, 4.93D0, 4.48D0, 3.92D0, 3.19D0, 2.63D0,
     & 2.25D0, 2.D0, 6*0.D0, 1.71D0, 4.26D0, 5.6D0, 5.57D0, 4.93D0,
     & 4.48D0, 3.92D0, 3.19D0, 2.63D0, 2.25D0, 2.D0, 10*0.D0, .22D0,
     & .8D0, .75D0, 1.D0, 1.3D0, 1.5D0, 1.3D0, 10*0.D0, .22D0, .8D0,
     & .75D0, 1.D0, 1.3D0, 1.5D0, 1.3D0, 13*0.D0, .1D0, .3D0, .7D0,1.D0,
     & 13*0.D0, .1D0, .3D0, .7D0, 1.D0, 9*0.D0, .11D0, 1.72D0, 2.69D0,
     & 3.92D0, 4.76D0, 5.10D0, 5.44D0, 5.3D0, 9*0.D0, .11D0, 1.72D0,
     & 2.69D0, 3.92D0, 4.76D0, 5.1D0, 5.44D0, 5.3D0, 5*0.D0,9.2D0,4.7D0,
     & 1.9D0, 10*0.D0, 2.5D0, 15.D0, 21.5D0, 15.3D0, 3.D0, 1.5D0,
     & 10*0.D0/
c**** k- n data                                                        *
      DATA SKMNEL/0.D0, 4.D0, 9.5D0, 20.D0, 13.D0, 9.5D0, 6.D0, 4.4D0,
     &        3.D0, 2.4D0, 2.D0, 1.4D0, 1.2D0, 1.D0, .9D0, .7D0, .6D0,
     &        0.D0, 4.5D0, 6.D0, 5.D0, 2.5D0, 2.D0, 1.7D0, 2.1D0,
     &        1.9D0, .9D0, .5D0, .3D0, .24D0, .2D0, .18D0, .1D0, .09D0,
     &        0.D0, 1.8D0, 2.D0, 1.1D0, .9D0, .5D0, .5D0, .4D0, .4D0,
     &        .2D0, .1D0, .06D0, .05D0, .04D0, .03D0, .02D0, .02D0,
     &        0.D0, 1.5D0, 2.D0, .9D0, 1.1D0, .4D0, .6D0, .7D0, .65D0,
     &       .3D0, .17D0, .1D0, .08D0, .07D0, .06D0, .04D0, .03D0/
      DATA SPIKP8/0.D0, .56D0, 1.29D0, 2.26D0, 1.01D0, .64D0, .37D0,
     &  14*0.D0, 1.13D0, 2.61D0, 2.91D0, 2.58D0, 2.35D0, 2.02D0,
     &  1.91D0, 1.57D0, 1.35D0, 1.29D0, 1.01D0, .74D0, .65D0,
     &  3*0.D0, 1.D0, 3.03D0, 3.36D0, 2.8D0, 2.58D0, 2.24D0,
     &  1.91D0, 1.68D0, 1.35D0, 1.01D0, .67D0, .5D0, .24D0, .23D0,
     &  3*0.D0, 1.D0, 3.03D0, 3.36D0, 2.8D0, 2.58D0, 2.24D0,
     &  1.91D0, 1.68D0, 1.35D0, 1.01D0, .67D0, .5D0, .24D0, .23D0,
     &  7*0.D0, .34D0, 1.12D0, 1.12D0, 1.01D0, .78D0, .45D0,
     &  .39D0, .22D0, .07D0, 0.D0,
     &  6*0.D0, 1.71D0, 4.26D0, 5.6D0, 5.57D0, 4.93D0,
     &  4.48D0, 3.92D0, 3.19D0, 2.63D0, 2.25D0, 2.D0,
     &  10*0.D0, .22D0, .8D0, .75D0, 1.D0, 1.3D0, 1.5D0, 1.3D0,
     &  13*0.D0, .1D0, .3D0, .7D0, 1.D0,
     &  13*0.D0, .1D0, .3D0, .7D0, 1.D0,
     &  9*0.D0, .11D0, 1.72D0, 2.69D0, 3.92D0, 4.76D0,
     &  5.10D0, 5.44D0, 5.3D0,
     &  4*0.D0, 0.00D0, 9.2D0, 4.7D0, 1.9D0, 9*0.D0/
c****  p p data                                                        *
      DATA SPIKP9/ 0.D0, 24.D0, 25.D0, 27.D0, 23.D0, 21.D0, 20.D0,
     &              19.D0, 17.D0, 15.5D0, 14.D0, 13.5D0, 13.D0,
     &              0.D0, 3.6D0, 1.7D0, 10*0.D0,
     &              .0D0, 0.D0, 8.7D0, 17.7D0, 18.8D0, 15.9D0,
     &              11.7D0, 8.D0, 6.D0, 5.3D0, 4.5D0, 3.9D0, 3.5D0,
     &              .0D0, .0D0, 2.8D0, 5.8D0, 6.2D0, 5.1D0, 3.8D0,
     &              2.7D0, 2.1D0, 1.8D0, 1.5D0, 1.3D0, 1.1D0,
     &              5*0.D0, 4.6D0, 10.2D0, 15.1D0,
     &              16.9D0, 16.5D0, 11.D0, 5.5D0, 3.5D0,
     &              10*0.D0, 4.3D0, 7.6D0, 9.D0,
     &              10*0.D0, 1.7D0, 2.6D0, 3.D0,
     &              6*0.D0, .3D0, .6D0, 1.D0, 1.6D0, 1.3D0, .8D0, .6D0,
     &              6*0.D0, .7D0, 1.2D0, 1.8D0, 2.5D0, 1.8D0, 1.3D0,
     &              1.2D0, 10*0.D0, .6D0, 1.4D0, 1.7D0,
     &              10*0.D0, 1.9D0, 4.1D0, 5.2D0/
c****  p n data                                                        *
      DATA SPIKP0/ 0.D0, 24.D0, 25.D0, 27.D0, 23.D0, 21.D0, 20.D0,
     &              19.D0, 17.D0, 15.5D0, 14.D0, 13.5D0, 13.D0,
     &              0.D0, 1.8D0, .2D0,  12*0.D0,
     &              3.2D0, 6.05D0, 9.9D0, 5.1D0,
     &              3.8D0, 2.7D0, 1.9D0, 1.5D0, 1.4D0, 1.3D0, 1.1D0,
     &              2*.0D0, 3.2D0, 6.05D0, 9.9D0, 5.1D0,
     &              3.8D0, 2.7D0, 1.9D0, 1.5D0, 1.4D0, 1.3D0, 1.1D0,
     &              5*0.D0, 4.6D0, 10.2D0, 15.1D0,
     &              16.4D0, 15.2D0, 11.D0, 5.4D0, 3.5D0,
     &              5*0.D0, 4.6D0, 10.2D0, 15.1D0,
     &              16.4D0, 15.2D0, 11.D0, 5.4D0, 3.5D0,
     &              10*0.D0, .7D0, 5.1D0, 8.D0,
     &              10*0.D0, .7D0, 5.1D0, 8.D0,
     &              10*.0D0, .3D0, 2.8D0, 4.7D0,
     &              10*.0D0, .3D0, 2.8D0, 4.7D0,
     &              7*0.D0, 1.2D0, 2.5D0, 3.5D0, 6.D0, 5.3D0, 2.9D0,
     &              7*0.D0, 1.7D0, 3.6D0, 5.4D0, 9.D0, 7.6D0, 4.2D0,
     &              5*0.D0, 7.7D0, 6.1D0, 2.9D0, 5*0.D0/
c   nn - data                                                          *
c                                                                      *
      DATA SPKPV/  0.D0, 24.D0, 25.D0, 27.D0, 23.D0, 21.D0, 20.D0,
     &              19.D0, 17.D0, 15.5D0, 14.D0, 13.5D0, 13.D0,
     &              0.D0, 3.6D0, 1.7D0, 12*0.D0,
     &              8.7D0, 17.7D0, 18.8D0, 15.9D0,
     &              11.7D0, 8.D0, 6.D0, 5.3D0, 4.5D0, 3.9D0, 3.5D0,
     &              .0D0, .0D0, 2.8D0, 5.8D0, 6.2D0, 5.1D0, 3.8D0,
     &              2.7D0, 2.1D0, 1.8D0, 1.5D0, 1.3D0, 1.1D0,
     &              5*0.D0, 4.6D0, 10.2D0, 15.1D0, 16.9D0, 16.5D0,
     &              11.D0, 5.5D0, 3.5D0,
     &              10*0.D0, 4.3D0, 7.6D0, 9.D0,
     &              10*0.D0, 1.7D0, 2.6D0, 3.D0,
     &              6*0.D0, .3D0, .6D0, 1.D0, 1.6D0, 1.3D0, .8D0, .6D0,
     &              6*0.D0, .7D0, 1.2D0, 1.8D0, 2.5D0, 1.8D0, 1.3D0,
     &              1.2D0, 10*0.D0, .6D0, 1.4D0, 1.7D0,
     &              10*0.D0, 1.9D0, 4.1D0, 5.2D0/
c***************   ap - p - data                                       *
      DATA SAPPEL/ 0.D0,  176.D0, 160.D0, 105.D0, 75.D0, 68.D0, 65.D0,
     &  50.D0,  50.D0, 43.D0, 42.D0, 40.5D0, 35.D0, 30.D0, 28.D0,
     &  25.D0,  22.D0, 21.D0, 20.D0, 18.D0, 17.D0,  11*0.D0,
     &  .05D0,  .15D0, .18D0, .2D0, .2D0, .3D0, .4D0, .6D0, .7D0, .85D0,
     &  0.D0,  1.D0, .9D0, .46D0, .3D0, .23D0, .18D0, .16D0, .14D0,
     &  .1D0,  .08D0, .05D0, .02D0, .015D0, 4*.011D0, 3*.005D0,
     &  0.D0,  55.D0, 50.D0, 25.D0, 15.D0, 15.D0, 14.D0, 12.D0,
     &  10.D0,  7.D0, 6.D0, 4.D0, 3.3D0, 2.8D0, 2.4D0, 2.D0, 1.8D0,
     &  1.55D0,  1.3D0, .95D0, .75D0,
     &  0.D0,  3.3D0, 3.D0, 1.5D0, 1.D0, .7D0, .4D0, .35D0, .4D0,
     &  .25D0,  .18D0, .08D0, .04D0, .03D0, .023D0, .016D0, .014D0,
     & .01D0,  .008D0, .006D0, .005D0/
      DATA SPIKPE/0.D0, 215.D0, 193.D0, 170.D0, 148.D0, 113.D0, 97.D0,
     & 84.D0, 78.D0, 68.D0, 64.D0, 61.D0, 46.D0, 36.D0, 31.3D0, 28.5D0,
     & 25.7D0, 22.6D0, 21.4D0, 20.7D0, 19.9D0,
     & 9*0.D0, 2.D0, 2.5D0, .2D0, 19*0.D0, .3D0, 1.4D0, 2.2D0, 1.2D0,
     & 1.1D0, 1.D0, .8D0, .6D0, .5D0, .4D0, .3D0, 10*0.D0, .3D0, 1.4D0,
     & 2.2D0, 1.2D0, 1.1D0, 1.D0, .8D0, .6D0, .5D0, .4D0, .3D0, 10*0.D0,
     & .3D0, 1.4D0, 2.2D0, 1.2D0, 1.1D0, 1.D0, .8D0, .6D0, .5D0, .4D0,
     & .3D0, 10*0.D0, .3D0, 1.4D0, 2.2D0, 1.2D0, 1.1D0, 1.D0, .8D0,
     & .6D0, .5D0, .4D0, .3D0, 9*0.D0, .6D0, 2.5D0, 5.D0, 5.2D0, 5.1D0,
     & 5.4D0, 5.8D0, 2.8D0, 2.1D0, 1.8D0, 1.6D0, 1.2D0, 13*0.D0, 1.3D0,
     & 1.5D0, 2.D0, 2.5D0, 2.5D0, 2.3D0, 1.8D0, 1.4D0, 13*0.D0, 1.3D0,
     & 1.5D0, 2.D0, 2.5D0, 2.5D0, 2.3D0, 1.8D0, 1.4D0, 13*0.D0, 1.3D0,
     & 1.5D0, 2.D0, 2.5D0, 2.5D0, 2.3D0, 1.8D0, 1.4D0, 13*0.D0, 1.3D0,
     & 1.5D0, 2.D0, 2.5D0, 2.5D0, 2.3D0, 1.8D0, 1.4D0, 14*0.D0, .2D0,
     & .5D0, 1.1D0, 1.6D0, 1.4D0, 1.1D0, .9D0, 14*0.D0, .2D0, .5D0,
     & 1.1D0, 1.6D0, 1.4D0, 1.1D0, .9D0, 14*0.D0, .2D0, .5D0, 1.1D0,
     & 1.6D0, 1.4D0, 1.1D0, .9D0, 14*0.D0, .2D0, .5D0, 1.1D0, 1.6D0,
     & 1.4D0, 1.1D0, .9D0, 17*0.D0, .3D0, 1.6D0, 2.6D0, 3.6D0, 17*0.D0,
     & .3D0, 1.6D0, 2.6D0, 3.6D0, 17*0.D0, .3D0, 1.6D0, 2.6D0,
     & 3.6D0, 17*0.D0, .3D0, 1.6D0, 2.6D0, 3.6D0 /
c***************   ap - n - data                                       *
      DATA SAPNEL/
     & 0.D0,  176.D0, 160.D0, 105.D0, 75.D0,  68.D0, 65.D0,
     & 50.D0, 50.D0,  43.D0,  42.D0,  40.5D0, 35.D0, 30.D0,  28.D0,
     & 25.D0, 22.D0,  21.D0,  20.D0,  18.D0,  17.D0, 11*0.D0,
     & .05D0, .15D0, .18D0,  .2D0,    .2D0,  .3D0,  .4D0,   .6D0,  .7D0,
     & .85D0,  0.D0,  1.D0,  .9D0,    .46D0, .3D0,  .23D0, .18D0, .16D0,
     & .14D0,  .1D0, .08D0, .05D0,    .02D0, .015D0, 4*.011D0, 3*.005D0,
     & 0.D0,  3.3D0,  3.D0, 1.5D0,     1.D0, .7D0,  .4D0,  .35D0, .4D0,
     & .25D0, .18D0, .08D0, .04D0,    .03D0, .023D0, .016D0, .014D0,
     & .01D0, .008D0, .006D0, .005D0 /
       DATA SPIKPZ/ 0.D0, 215.D0, 193.D0, 170.D0, 148.D0, 113.D0, 97.D0,
     &  84.D0, 78.D0, 68.D0, 64.D0, 61.D0, 46.D0, 36.D0, 31.3D0, 28.5D0,
     & 25.7D0, 22.6D0, 21.4D0, 20.7D0, 19.9D0, 9*0.D0, 2.4D0, .2D0,
     & 20*0.D0, 1.8D0, 2.8D0, 3.6D0, 2.3D0, 1.8D0, 1.5D0, 1.3D0, 1.D0,
     & .7D0, .5D0, .3D0, 10*0.D0, 1.8D0, 2.8D0, 3.6D0, 2.3D0, 1.8D0,
     & 1.5D0, 1.3D0, 1.D0, .7D0, .5D0, .3D0, 10*0.D0, 1.8D0, 2.8D0,
     & 3.6D0, 2.3D0, 1.8D0, 1.5D0, 1.3D0, 1.D0, .7D0, .5D0, .3D0,
     & 10*0.D0, 1.8D0, 2.8D0, 3.6D0, 2.3D0, 1.8D0, 1.5D0, 1.3D0, 1.D0,
     & .7D0, .5D0, .3D0, 13*0.D0, 5.2D0, 8.7D0, 11.4D0, 14.D0, 11.9D0,
     & 7.6D0, 6.D0, 5.D0, 13*0.D0, 5.2D0, 8.7D0, 11.4D0, 14.D0, 11.9D0,
     & 7.6D0, 6.D0, 5.D0, 18*0.D0, 1.D0, 4.9D0, 8.5D0, 18*0.D0, 1.D0,
     & 4.9D0, 8.5D0,  15*0.D0, 1.9D0, 2.3D0, 4.D0, 6.5D0, 5.2D0, 3.4D0,
     & 15*0.D0, 1.9D0, 2.3D0, 4.D0, 6.5D0, 5.2D0, 3.4D0, 15*0.D0, 1.9D0,
     & 2.3D0, 4.D0, 6.5D0, 5.2D0, 3.4D0 /
c                                                                      *
c                                                                      *
c***************   an - p - data                                       *
c                                                                      *
      DATA SANPEL/
     & 0.D0,  176.D0, 160.D0, 105.D0, 75.D0, 68.D0, 65.D0, 50.D0,
     & 50.D0, 43.D0,  42.D0,  40.5D0, 35.D0, 30.D0, 28.D0,
     & 25.D0, 22.D0,  21.D0,  20.D0,  18.D0, 17.D0, 11*0.D0, .05D0,
     & .15D0, .18D0,   .2D0,   .2D0,   .3D0,  .4D0, .6D0,   .7D0, .85D0,
     & 0.D0,   1.D0,   .9D0,  .46D0,  .3D0,  .23D0, .18D0, .16D0, .14D0,
     & .1D0,  .08D0,  .05D0,  .02D0, .015D0, 4*.011D0, 3*.005D0,
     & 0.D0,  3.3D0,  3.D0, 1.5D0, 1.D0, .7D0, .4D0, .35D0, .4D0, .25D0,
     & .18D0, .08D0, .04D0, .03D0, .023D0, .016D0, .014D0,
     & .01D0, .008D0, .006D0, .005D0 /
      DATA SPIKPF/ 0.D0, 215.D0, 193.D0, 170.D0, 148.D0, 113.D0, 97.D0,
     & 84.D0, 78.D0, 68.D0, 64.D0, 61.D0, 46.D0, 36.D0, 31.3D0, 28.5D0,
     & 25.7D0, 22.6D0, 21.4D0, 20.7D0, 19.9D0, 9*0.D0, 2.4D0, .2D0,
     & 20*0.D0, 1.8D0, 2.8D0, 3.6D0, 2.3D0, 1.8D0, 1.5D0, 1.3D0, 1.D0,
     & .7D0, .5D0, .3D0, 10*0.D0, 1.8D0, 2.8D0, 3.6D0, 2.3D0, 1.8D0,
     & 1.5D0, 1.3D0, 1.D0, .7D0, .5D0, .3D0, 10*0.D0, 1.8D0, 2.8D0,
     & 3.6D0, 2.3D0, 1.8D0, 1.5D0, 1.3D0, 1.D0, .7D0, .5D0, .3D0,
     & 10*0.D0, 1.8D0, 2.8D0, 3.6D0, 2.3D0, 1.8D0, 1.5D0, 1.3D0, 1.D0,
     & .7D0, .5D0, .3D0, 13*0.D0, 5.2D0, 8.7D0, 11.4D0, 14.D0, 11.9D0,
     & 7.6D0, 6.D0, 5.D0, 13*0.D0, 5.2D0, 8.7D0, 11.4D0, 14.D0, 11.9D0,
     & 7.6D0, 6.D0, 5.D0, 18*0.D0, 1.D0, 4.9D0, 8.5D0, 18*0.D0, 1.D0,
     & 4.9D0, 8.5D0, 15*0.D0, 1.9D0, 2.3D0, 4.D0, 6.5D0, 5.2D0, 3.4D0,
     & 15*0.D0, 1.9D0, 2.3D0, 4.D0, 6.5D0, 5.2D0, 3.4D0, 15*0.D0, 1.9D0,
     & 2.3D0, 4.D0, 6.5D0, 5.2D0, 3.4D0 /
c***  ko - n - data                                                    *
      DATA SPKP15/0.D0, 20.D0, 14.D0, 12.D0, 11.5D0, 10.D0, 8.D0, 7.D0,
     &      6.D0, 5.5D0, 5.3D0, 5.D0, 4.5D0, 4.4D0, 3.8D0, 3.D0, 2.8D0,
     &      0.D0, .5D0, 1.15D0, 2.D0, 1.3D0, .8D0, .45D0, 10*0.D0,
     &    3*0.D0, 0.9D0, 2.5D0, 3.D0, 2.5D0, 2.3D0, 2.D0, 1.7D0,
     &     1.5D0, 1.2D0, .9D0, .6D0, .45D0, .21D0, .2D0,
     &    3*0.D0, 0.9D0, 2.5D0, 3.D0, 2.5D0, 2.3D0, 2.D0, 1.7D0,
     &     1.5D0, 1.2D0, .9D0, .6D0, .45D0, .21D0, .2D0,
     &    4*0.D0, 1.D0, 2.1D0, 2.6D0, 2.3D0, 2.1D0, 1.8D0, 1.7D0,
     &     1.4D0, 1.2D0, 1.05D0, .9D0, .66D0,  .5D0,
     &    7*0.D0, .3D0, 1.D0, 1.D0, .9D0, .7D0, .4D0, .30D0, .2D0,
     &   11*0.D0, .1D0, 1.D0, 2.2D0, 3.5D0, 4.20D0, 4.55D0,
     &    4.85D0, 4.9D0,
     &   10*0.D0, .2D0, .7D0, 1.6D0, 2.5D0, 2.2D0, 1.71D0, 1.6D0,
     &    6*0.D0, 1.4D0, 3.8D0, 5.D0, 4.7D0, 4.4D0, 4.D0, 3.5D0,
     &    2.85D0, 2.35D0, 2.01D0, 1.8D0,
     &   12*0.D0, .1D0, .8D0, 2.05D0, 3.31D0, 3.5D0,
     &   12*0.D0, .034D0, .20D0, .75D0, 1.04D0, 1.24D0  /
c*** ako - p - data                                                    *
      DATA SPKP16/ 0.D0, 4.D0, 9.5D0, 20.D0, 13.D0, 9.5D0, 6.D0, 4.4D0,
     & 3.D0, 2.4D0, 2.D0, 1.4D0, 1.2D0, 1.D0, .9D0, .7D0, .6D0, 0.D0,
     & 4.5D0, 6.D0, 5.D0, 2.5D0, 2.D0, 1.7D0, 2.1D0, 1.9D0, .9D0, .5D0,
     & .3D0, .24D0, .2D0, .18D0, .1D0, .09D0, 0.D0, 1.8D0, 2.D0, 1.1D0,
     & .9D0, .5D0, .5D0, .4D0, .4D0, .2D0, .1D0, .06D0, .05D0, .04D0,
     & .03D0, .02D0, .02D0, 0.D0, 1.5D0, 2.D0, .9D0, 1.1D0, .4D0, .6D0,
     & .7D0, .65D0, .3D0, .17D0, .1D0, .08D0, .07D0, .06D0, .04D0,
     & .03D0, 0.D0, .56D0, 1.29D0, 2.26D0, 1.01D0, .64D0, .37D0,
     & 14*0.D0, 1.13D0, 2.61D0, 2.91D0, 2.58D0, 2.35D0, 2.02D0, 1.91D0,
     & 1.57D0, 1.35D0, 1.29D0, 1.01D0, .74D0, .65D0, 3*0.D0, 1.0D0,
     & 3.03D0, 3.36D0, 2.8D0, 2.58D0, 2.24D0, 1.91D0, 1.68D0, 1.35D0,
     & 1.01D0, .67D0, .5D0, .24D0, .23D0, 3*0.D0, 1.0D0, 3.03D0, 3.36D0,
     & 2.8D0, 2.58D0, 2.24D0, 1.91D0, 1.68D0, 1.35D0, 1.01D0, .67D0,
     & .5D0, .24D0, .23D0, 7*0.D0, .34D0, 1.12D0, 1.12D0, 1.01D0, .78D0,
     & .45D0, .39D0, .22D0, .07D0, 7*0.D0, 1.71D0, 4.26D0, 5.6D0,5.57D0,
     & 4.93D0, 4.48D0, 3.92D0, 3.19D0, 2.63D0, 2.25D0, 2.D0, 10*0.D0,
     & .22D0, .8D0, .75D0, 1.D0, 1.3D0, 1.5D0, 1.3D0, 13*0.D0, .1D0,
     & .3D0, .7D0, 1.D0, 13*0.D0, .1D0, .3D0, .7D0, 1.D0, 9*0.D0, .11D0,
     & 1.72D0, 2.69D0, 3.92D0, 4.76D0, 5.10D0, 5.44D0, 5.3D0, 5*0.D0,
     & 9.2D0, 4.7D0, 1.9D0, 9*0.D0, .0D0,2.5D0,15.D0,
     & 21.5D0, 15.3D0, 3.D0, 1.5D0, 10*0.D0 /
      DATA NURELN/9, 12, 5*0, 10, 14, 3*0, 1, 3, 5, 7, 6*0, 2, 6, 16,
     & 5*0, 10, 13, 5*0, 11, 12, 3*0, 2, 4, 6, 8, 6*0, 3, 15, 7, 5*0 /
c=                                               end*block.blkdt3      *
      END
c
c===qel_pol============================================================*
c
CDECK  ID>, DT_QEL_POL
      SUBROUTINE DT_QEL_POL(ENU,LTYP,P21,P22,P23,P24,P25)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      CALL DT_MASS_INI
      CALL DT_GEN_QEL(ENU,LTYP,P21,P22,P23,P24,P25)

      RETURN
      END

C==================================================================
C   Generation of  a Quasi-Elastic neutrino scattering
C==================================================================
c
c===gen_qel============================================================*
c
CDECK  ID>, DT_GEN_QEL
      SUBROUTINE DT_GEN_QEL(ENU,LTYP,P21,P22,P23,P24,P25)

C...Generate a quasi-elastic   neutrino/antineutrino
C.  Interaction on a nuclear target
C.  INPUT  : LTYP = neutrino type (1,...,6)
C.           ENU (GeV) = neutrino energy
C----------------------------------------------------

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE


      PARAMETER (MAXLND=4000)
      COMMON/PYJETS/N,NPAD,K(MAXLND,5),P(MAXLND,5),V(MAXLND,5)


c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c steering flags for qel neutrino scattering modules
      COMMON /QNEUTO/ DSIGSU,DSIGMC,NDSIG,NEUTYP,NEUDEC

c*sr - removed (not needed)
C     COMMON /CBAD/  LBAD, NBAD
C     COMMON /CNUC/ XMN,XMN2,PFERMI,EFERMI,EBIND,EB2,C0
c*

      DIMENSION PI(3),PO(3)
CJR+
      DATA ININU/0/
CJR-
C     REAL*8 DBETA(3)
C     REAL*8 MN(2), ML0(6), ML, ML2, MI, MI2, MF, MF2
      DIMENSION DBETA(3),DBETB(3),AMN(2),AML0(6)
      DATA AMN  /0.93827231D0, 0.93956563D0/
      DATA AML0 /2*0.51100D-03,2*0.105659D0, 2*1.777D0/
      DATA INIPRI/0/

C     DATA PFERMI/0.22D0/
CGB+...Binding Energy
      DATA EBIND/0.008D0/
CGB-...

      ININU=ININU+1
      IF(ININU.EQ.1)NDSIG=0
      LBAD = 0
      ENU0=ENU
c      write(*,*) enu0
C...Lepton mass
      AML = AML0(LTYP)       !  MASSA LEPTONI
      AML2 = AML**2          !  MASSA LEPTONI **2
C...Particle labels (LUND)
      N = 5
      K(1,1) = 21
      K(2,1) = 21
      K(3,1) = 21
      K(3,3) = 1
      K(4,1) = 1
      K(4,3) = 1
      K(5,1) = 1
      K(5,3) = 2
      K0 = (LTYP-1)/2          !  2
      K1 = LTYP/2              !  2
      KA = 12 + 2*K0           !  16
      IS = -1 + 2*LTYP - 4*K1  !  -1 +10 -8 = 1
      K(1,2) = IS*KA
      K(4,2) = IS*(KA-1)
      K(3,2) = IS*24
      LNU = 2 - LTYP + 2*K1    !  2 - 5 + 2 = - 1
      IF (LNU .EQ. 2)  THEN
        K(2,2) = 2212
        K(5,2) = 2112
        AMI = AMN(1)
        AMF = AMN(2)
CJR+
	PFERMI=PFERMN(2)
CJR-
      ELSE
        K(2,2) = 2112
        K(5,2) = 2212
        AMI = AMN(2)
        AMF = AMN(1)
CJR+
	PFERMI=PFERMP(2)
CJR-
      ENDIF
      AMI2 = AMI**2
      AMF2 = AMF**2

      DO IGB=1,5
        P(3,IGB) = 0.
        P(4,IGB) = 0.
        P(5,IGB) = 0.
      END DO

      NTRY = 0
CGB+...
      EFMAX  = SQRT(PFERMI**2 + AMI2) -AMI             ! MAX. FERMI ENERGY
      ENWELL = EFMAX + EBIND ! DEPTH OF NUCLEAR POTENTIAL WELL
CGB-...

  100 CONTINUE

C...4-momentum initial lepton
      P(1,5) = 0.     ! MASSA
      P(1,4) = ENU0    ! ENERGIA
      P(1,1) = 0.     ! PX
      P(1,2) = 0.     ! PY
      P(1,3) = ENU0    ! PZ

C     PF = PFERMI*PYR(0)**(1./3.)
c       write(23,*) PYR(0)
c      write(*,*) 'Pfermi=',PF
c      PF = 0.
      NTRY=NTRY+1
C     IF(ntry.GT.2) WRITE(*,*) ntry,enu0,k2
      IF (NTRY .GT. 500)  THEN
        LBAD = 1
        WRITE (   6,1001)  NBAD, ENU
        RETURN
      ENDIF
C     CT = -1. + 2.*PYR(0)
c      CT = -1.
C     ST =  SQRT(1.-CT*CT)
C     F = 2.*3.1415926*PYR(0)
c      F = 0.

C     P(2,4) = SQRT(PF*PF + MI2) - EBIND  ! energia
C     P(2,1) = PF*ST*COS(F)               ! px
C     P(2,2) = PF*ST*SIN(F)               ! py
C     P(2,3) = PF*CT                      ! pz
C     P(2,5) = SQRT(P(2,4)**2-PF*PF)      ! massa
       P(2,1) = P21
       P(2,2) = P22
       P(2,3) = P23
       P(2,4) = P24
       P(2,5) = P25
      BETA1=-P(2,1)/P(2,4)
      BETA2=-P(2,2)/P(2,4)
      BETA3=-P(2,3)/P(2,4)
      N=2
C      WRITE(6,*)' before transforming into target rest frame'

      CALL PYROBO(0,0,0.0D0,0.0D0,BETA1,BETA2,BETA3)

C      print*,' nucl. rest fram ( fermi incl.) prima della rotazione'
      N=5

      PHI11=ATAN(P(1,2)/P(1,3))
      PI(1)=P(1,1)
      PI(2)=P(1,2)
      PI(3)=P(1,3)

      CALL DT_TESTROT(PI,PO,PHI11,1)
      DO LL=1,3
        IF(ABS(PO(LL)).LT.1.D-07) PO(LL)=0.
      END DO
c        WRITE(*,*) po
      P(1,1)=PO(1)
      P(1,2)=PO(2)
      P(1,3)=PO(3)
      PHI12=ATAN(P(1,1)/P(1,3))

      PI(1)=P(1,1)
      PI(2)=P(1,2)
      PI(3)=P(1,3)
      CALL DT_TESTROT(PI,PO,PHI12,2)
      DO LL=1,3
        IF(ABS(PO(LL)).LT.1.D-07) PO(LL)=0.
      END DO
c        WRITE(*,*) po
      P(1,1)=PO(1)
      P(1,2)=PO(2)
      P(1,3)=PO(3)

      ENU=P(1,4)

C...Kinematical limits in Q**2
c      S = P(2,5)**2 + 2.*ENU*(P(2,4)-P(2,3)) !            ????
      S = P(2,5)**2 + 2.*ENU*P(2,5)
      SQS = SQRT(S)                          ! E CENTRO MASSA
      IF (SQS .LT. (AML + AMF + 3.E-03)) GOTO 100
      ELF = (S-AMF2+AML2)/(2.*SQS)           ! ENERGIA LEPTONE FINALE P
      PSTAR = (S-P(2,5)**2)/(2.*SQS)       ! P* NEUTRINO NEL C.M.
      PLF = SQRT(ELF**2-AML2)               ! 3-MOMENTO LEPTONE FINALE
      Q2MIN = -AML2 + 2.*PSTAR*(ELF-PLF)    ! + O -
      Q2MAX = -AML2 + 2.*PSTAR*(ELF+PLF)    ! ACCORDING CON COS(THETA)
      IF (Q2MIN .LT. 0.)   Q2MIN = 0.      ! ??? NON FISICO

C...Generate Q**2
      DSIGMAX = DT_DSQEL_Q2 (LTYP,ENU, Q2MIN)
  200 Q2 = Q2MIN + (Q2MAX-Q2MIN)*PYR(0)
      DSIG = DT_DSQEL_Q2 (LTYP,ENU, Q2)
      IF (DSIG .LT.  DSIGMAX*PYR(0)) GOTO 200
      CALL DT_QGAUS(Q2MIN,Q2MAX,DSIGEV,ENU,LTYP)
      NDSIG=NDSIG+1
C     WRITE(6,*)' Q2,Q2min,Q2MAX,DSIGEV',
C    &Q2,Q2min,Q2MAX,DSIGEV


C...c.m. frame. Neutrino along z axis
      DETOT = (P(1,4)) + (P(2,4)) ! E TOTALE
      DBETA(1) = ((P(1,1)) + (P(2,1)))/DETOT ! PX1+PX2/ETOT = BETA_X
      DBETA(2) = ((P(1,2)) + (P(2,2)))/DETOT !
      DBETA(3) = ((P(1,3)) + (P(2,3)))/DETOT !
c      WRITE(*,*)
c      WRITE(*,*)
C      WRITE(*,*) 'Input values laboratory frame'
      N=2

      CALL PYROBO(0,0,0.0D0,0.0D0,-DBETA(1),-DBETA(2),-DBETA(3))

      N=5
c      STHETA = ULANGL(P(1,3),P(1,1))
c      write(*,*) 'stheta' ,stheta
c      stheta=0.
c      CALL PYROBO (0,0,-STHETA,0.,0.D0,0.D0,0.D0)
c      WRITE(*,*)
c      WRITE(*,*)
C      WRITE(*,*) 'Output values cm frame'
C...Kinematic in c.m. frame
      CTSTAR = ELF/PLF - (Q2 + AML2)/(2.*PSTAR*PLF) ! COS(THETA) CM
      STSTAR = SQRT(1.-CTSTAR**2)
      PHI = 6.28319*PYR(0) ! RANDOM PHI TRA 0 E 2*PI
      P(4,5) = AML                  ! MASSA LEPTONE
      P(4,4) = ELF                 ! E LEPTONE
      P(4,3) = PLF*CTSTAR          ! PX
      P(4,1) = PLF*STSTAR*COS(PHI) ! PY
      P(4,2) = PLF*STSTAR*SIN(PHI) ! PZ


      P(5,5) = AMF                  ! BARIONE
      P(5,4) = (S+AMF2-AML2)/(2.*SQS)! E BARIONE
      P(5,3) = -P(4,3)             ! PX
      P(5,1) = -P(4,1)             ! PY
      P(5,2) = -P(4,2)             ! PZ


      P(3,5) = -Q2
      P(3,1) = P(1,1)-P(4,1)
      P(3,2) = P(1,2)-P(4,2)
      P(3,3) = P(1,3)-P(4,3)
      P(3,4) = P(1,4)-P(4,4)

C...Transform back to laboratory  frame
C      WRITE(*,*) 'before going back to nucl rest frame'
c      CALL PYROBO (0,0,STHETA,0.,0.D0,0.D0,0.D0)
      N=5

      CALL PYROBO(0,0,0.0D0,0.0D0,DBETA(1),DBETA(2),DBETA(3))

C      WRITE(*,*) 'Now back in nucl rest frame'
      IF(LTYP.GE.3) CALL DT_PREPOLA(Q2,LTYP,ENU)

c********************************************

      DO KW=1,5
        PI(1)=P(KW,1)
        PI(2)=P(KW,2)
        PI(3)=P(KW,3)
        CALL DT_TESTROT(PI,PO,PHI12,3)
        DO LL=1,3
          IF(ABS(PO(LL)).LT.1.D-07) PO(LL)=0.
        END DO
        P(KW,1)=PO(1)
        P(KW,2)=PO(2)
        P(KW,3)=PO(3)
      END DO
c********************************************

      DO KW=1,5
        PI(1)=P(KW,1)
        PI(2)=P(KW,2)
        PI(3)=P(KW,3)
        CALL DT_TESTROT(PI,PO,PHI11,4)
        DO LL=1,3
          IF(ABS(PO(LL)).LT.1.D-07) PO(LL)=0.
        END DO
        P(KW,1)=PO(1)
        P(KW,2)=PO(2)
        P(KW,3)=PO(3)
      END DO

c********************************************

C      WRITE(*,*) 'Now back in lab frame'

      CALL PYROBO(1,5,0.0D0,0.0D0,-BETA1,-BETA2,-BETA3)

CGB+...
C...test (on final momentum of nucleon) if Fermi-blocking
C...is operating
      ENUCL = SQRT(P(5,1)**2 + P(5,2)**2 + P(5,3)**2 + P(5,5)**2)
     &  - P(5,5)
      IF (ENUCL.LT. EFMAX) THEN
	IF(INIPRI.LT.10)THEN
	  INIPRI=INIPRI+1
C         WRITE(6,*)' qel: Pauli ENUCL.LT.EFMAX ', ENUCL,EFMAX
C...the interaction is not possible due to Pauli-Blocking and
C...it must be resampled
	ENDIF
        GOTO 100
      ELSE IF (ENUCL.LT.ENWELL.AND.ENUCL.GE.EFMAX) THEN
        IF(INIPRI.LT.10)THEN
          INIPRI=INIPRI+1
C     WRITE(6,*)' qel: inside ENUCL.LT.ENWELL ', ENUCL,ENWELL
        ENDIF
C                      Reject (J:R) here all these events
C                      are otherwise rejected in dpmjet
        GOTO 100
C...the interaction is possible, but the nucleon remains inside
C...the nucleus. The nucleus is therefore left excited.
C...We treat this case as a nucleon with 0 kinetic energy.
C       P(5,5) = AMF
C       P(5,4) = AMF
C       P(5,1) = 0.
C       P(5,2) = 0.
C       P(5,3) = 0.
      ELSE IF (ENUCL.GE.ENWELL) THEN
C     WRITE(6,*)' qel ENUCL.GE.ENWELL ',ENUCL,ENWELL
C...the interaction is possible, the nucleon can exit the nucleus
C...but the nuclear well depth must be subtracted. The nucleus could be
C...left in an excited state.
        PSTART = SQRT(P(5,1)**2 + P(5,2)**2 + P(5,3)**2)
C       P(5,4) = ENUCL-ENWELL + AMF
        PNUCL = SQRT(P(5,4)**2-AMF**2)
C...The 3-momentum is scaled assuming that the direction remains
C...unaffected
        P(5,1) = P(5,1) * PNUCL/PSTART
        P(5,2) = P(5,2) * PNUCL/PSTART
        P(5,3) = P(5,3) * PNUCL/PSTART
C     WRITE(6,*)' qel new P(5,4) ',P(5,4)
      ENDIF
CGB-...
      DSIGSU=DSIGSU+DSIGEV

	 GA=P(4,4)/P(4,5)
	 BGX=P(4,1)/P(4,5)
	 BGY=P(4,2)/P(4,5)
	 BGZ=P(4,3)/P(4,5)
c
         DBETB(1)=BGX/GA
         DBETB(2)=BGY/GA
         DBETB(3)=BGZ/GA
	 IF(NEUDEC.EQ.1.OR.NEUDEC.EQ.2) THEN

            CALL PYROBO(6,8,0.0D0,0.0D0,DBETB(1),DBETB(2),DBETB(3))

	 ENDIF
c
C      PRINT*,' FINE   EVENTO '
      ENU=ENU0
      RETURN

 1001 FORMAT(2X, 'DT_GEN_QEL   : EVENT REJECTED ', I5,  G10.3)
      END


C====================================================================
C.  Masses
C====================================================================

c
c===mass_ini===========================================================*
c
CDECK  ID>, DT_MASS_INI
      SUBROUTINE DT_MASS_INI
C...Initialize  the kinematics for the quasi-elastic cross section

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c particle masses used in qel neutrino scattering modules
      COMMON /QNMASS/ EML(6),EMLSQ(6),EMN1(6),EMN2(6),ETQE(6),
     &                EMN1SQ(6),EMN2SQ(6),EMPROT,EMNEUT,EMN,
     &                EMPROTSQ,EMNEUTSQ,EMNSQ


      EML(1) = 0.51100D-03   ! E-
      EML(2) = EML(1)        ! E+
      EML(3) = 0.105659D0      ! MU-
      EML(4) = EML(3)        ! MU+
      EML(5) = 1.7777D0        ! TAU-
      EML(6) = EML(5)        ! TAU+
      EMPROT = 0.93827231D0    ! P
      EMNEUT = 0.93956563D0    ! N
      EMPROTSQ = EMPROT**2
      EMNEUTSQ = EMNEUT**2
      EMN = (EMPROT + EMNEUT)/2.
      EMNSQ = EMN**2
      DO J=1,3
        J0 = 2*(J-1)
        EMN1(J0+1) = EMNEUT
        EMN1(J0+2) = EMPROT
        EMN2(J0+1) = EMPROT
        EMN2(J0+2) = EMNEUT
      ENDDO
      DO J=1,6
        EMLSQ(J) = EML(J)**2
        ETQE(J)  = ((EMN2(J)+ EML(J))**2-EMN1(J)**2)/(2.*EMN1(J))
      ENDDO
      RETURN
      END
c
c===dsqel_q2===========================================================*
c
CDECK  ID>, DT_DSQEL_Q2
      DOUBLE PRECISION FUNCTION DT_DSQEL_Q2 (JTYP,ENU, Q2)

C...differential cross section for  Quasi-Elastic scattering
C.       nu + N -> l + N'
C.  From Llewellin Smith  Phys.Rep.  3C, 261, (1971).
C.
C.  INPUT :  JTYP = 1,...,6    nu_e, ...., nubar_tau
C.           ENU (GeV) =  Neutrino energy
C.           Q2  (GeV**2) =  (Transfer momentum)**2
C.
C.  OUTPUT : DSQEL_Q2  = differential  cross section :
C.                       dsigma/dq**2  (10**-38 cm+2/GeV**2)
C------------------------------------------------------------------

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c particle masses used in qel neutrino scattering modules
      COMMON /QNMASS/ EML(6),EMLSQ(6),EMN1(6),EMN2(6),ETQE(6),
     &                EMN1SQ(6),EMN2SQ(6),EMPROT,EMNEUT,EMN,
     &                EMPROTSQ,EMNEUTSQ,EMNSQ

c*sr - removed (not needed)
C     COMMON /CAXIAL/ FA0, AXIAL2
c*

      DIMENSION SS(6)
      DATA C0 /0.17590D0 /  ! G_F**2 COS(THETA_C)**2 M**2 /(8 PI) 10**-38 CM+2
      DATA SS /1.D0, -1.D0, 1.D0, -1.D0, 1.D0, -1.D0/
      DATA AXIAL2 /1.03D0/  ! TO BE CHECKED

      FA0=-1.253D0
      CSI = 3.71D0                   !  ???
      GVE = 1.D0/ (1.D0 + Q2/0.84D0**2)**2   ! G_E(Q**2)
      GVM = (1.D0+CSI)*GVE           ! G_M (Q**2)
      X = Q2/(EMN*EMN)     ! EMN=MASSA BARIONE
      XA = X/4.D0
      FV1 = 1.D0/(1.D0+XA)*(GVE+XA*GVM)
      FV2 = 1.D0/(1.D0+XA)*(GVM-GVE)
      FA = FA0/(1.D0 + Q2/AXIAL2)**2
      FFA = FA*FA
      FFV1 = FV1*FV1
      FFV2 = FV2*FV2
      RM = EMLSQ(JTYP)/(EMN*EMN)            ! EMLSQ(JTYP)
      A1 = (4.D0+X)*FFA - (4.D0-X)*FFV1 + X*FFV2*(1.D0-XA)+4*X*FV1*FV2
      A2 = -RM * ((FV1 + FV2)**2 +  FFA)
      AA = (XA+0.25D0*RM)*(A1 + A2)
      BB = -X*FA*(FV1 + FV2)
      CC = 0.25D0*(FFA + FFV1 + XA*FFV2)
      SU = (4.D0*ENU*EMN - Q2 - EMLSQ(JTYP))/(EMN*EMN)
      DT_DSQEL_Q2 = C0*(AA + SS(JTYP)*BB*SU + CC*SU*SU) / (ENU*ENU)  !
      IF(DT_DSQEL_Q2 .LT. 0.D0) DT_DSQEL_Q2 = 0.D0

      RETURN
      END
c
c===prepola============================================================*
c
CDECK  ID>, DT_PREPOLA
      SUBROUTINE DT_PREPOLA(Q2,JTYP,ENU)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
c
c By G. Battistoni and E. Scapparone (sept. 1997)
c According to:
c     Albright & Jarlskog, Nucl Phys B84 (1975) 467
c
c

      PARAMETER (MAXLND=4000)
      COMMON/PYJETS/N,NPAD,K(MAXLND,5),P(MAXLND,5),V(MAXLND,5)


      COMMON /QNPOL/ POLARX(4),PMODUL

c particle masses used in qel neutrino scattering modules
      COMMON /QNMASS/ EML(6),EMLSQ(6),EMN1(6),EMN2(6),ETQE(6),
     &                EMN1SQ(6),EMN2SQ(6),EMPROT,EMNEUT,EMN,
     &                EMPROTSQ,EMNEUTSQ,EMNSQ

c steering flags for qel neutrino scattering modules
      COMMON /QNEUTO/ DSIGSU,DSIGMC,NDSIG,NEUTYP,NEUDEC

c*sr - removed (not needed)
C     COMMON /CAXIAL/ FA0, AXIAL2
C     COMMON /TAUTAU/Q(4,5),ETL,PXL,PYL,PZL,
C    &        ETB,PXB,PYB,PZB,ETN,PXN,PYN,PZN
c*
      REAL*8 POL(4,4),BB2(3)
      DIMENSION SS(6)
C     DATA C0 /0.17590D0 /  ! G_F**2 cos(theta_c)**2 M**2 /(8 pi) 10**-38 cm+2
      DATA SS /1.D0, -1.D0, 1.D0, -1.D0, 1.D0, -1.D0/
c*sr uncommented since common block CAXIAL is now commented
      DATA AXIAL2 /1.03D0/  ! TO BE CHECKED
c*

      RML=P(4,5)
      RMM=0.93960D+00
      FM2 = RMM**2
      MPI = 0.135D+00
      OLDQ2=Q2
      FA0=-1.253D+00
      CSI = 3.71D+00                      !
      GVE = 1.D0/ (1.D0 + Q2/(0.84D+00)**2)**2   ! G_E(Q**2)
      GVM = (1.D0+CSI)*GVE           ! G_M (Q**2)
      X = Q2/(EMN*EMN)     ! EMN=MASSA BARIONE
      XA = X/4.D0
      FV1 = 1.D0/(1.D0+XA)*(GVE+XA*GVM)
      FV2 = 1.D0/(1.D0+XA)*(GVM-GVE)
      FA = FA0/(1.D0 + Q2/AXIAL2**2)**2
      FFA = FA*FA
      FFV1 = FV1*FV1
      FFV2 = FV2*FV2
      FP=2.D0*FA*RMM/(MPI**2 + Q2)
      RM = EMLSQ(JTYP)/(EMN*EMN)            ! EMLSQ(JTYP)
      A1 = (4.D0+X)*FFA-(4.D0-X)*FFV1+X*FFV2*(1.D0-XA)+4.D0*X*FV1*FV2
      A2 = -RM * ((FV1 + FV2)**2 +  FFA)
      AA = (XA+0.25D+00*RM)*(A1 + A2)
      BB = -X*FA*(FV1 + FV2)
      CC = 0.25D+00*(FFA + FFV1 + XA*FFV2)
      SU = (4.D+00*ENU*EMN - Q2 - EMLSQ(JTYP))/(EMN*EMN)

      OMEGA1=FFA+XA*(FFA+(FV1+FV2)**2   )  ! ARTICOLO DI LL...-SMITH
      OMEGA2=4.D+00*CC
      OMEGA3=2.D+00*FA*(FV1+FV2)
      OMEGA4P=(-(FV1+FV2)**2-(FA+2*FP)**2+(4.0D+00+
     1     (Q2/FM2))*FP**2)
      OMEGA5=OMEGA2
      OMEGA4=(OMEGA4P-OMEGA2+2*OMEGA5)/4.D+00
      WW1=2.D+00*OMEGA1*EMN**2
      WW2=2.D+00*OMEGA2*EMN**2
      WW3=2.D+00*OMEGA3*EMN**2
      WW4=2.D+00*OMEGA4*EMN**2
      WW5=2.D+00*OMEGA5*EMN**2

      DO I=1,3
        BB2(I)=-P(4,I)/P(4,4)
      END DO
c      WRITE(*,*)
c      WRITE(*,*)
c      WRITE(*,*) 'Prepola: ready to transform to lepton rest frame'
      N=5

      CALL PYROBO(0,0,0.0D0,0.0D0,BB2(1),BB2(2),BB2(3))

c NOW PARTICLES ARE IN THE SCATTERED LEPTON  REST FRAME
c      WRITE(*,*)
c      WRITE(*,*)
c      WRITE(*,*) 'Prepola: now in lepton rest frame'
      EE=ENU
      QM2=Q2+RML**2
      U=Q2/(2.*RMM)
      FRAC=QM2*WW1 + (2.D+00*EE*(EE-U) - 0.5D+00*QM2)*WW2 - SS(JTYP)*
     +     (0.5D+00/(RMM**2))*(2.D+00*RMM*EE*Q2 - U*QM2)*WW3 +
     +     ((RML**2)/(2.D+00*FM2))*(QM2*WW4-2.D+00*RMM*EE*WW5) !<=FM2 INV DI RMM!!

      FACTK=2.D+00*WW1 -WW2 -SS(JTYP)*(EE/RMM)*WW3 +((EE-U)/RMM)*WW5
     +     - ((RML**2)/FM2)*WW4                        !<=FM2 INV DI RMM!!

      FACTP=2.D+00*EE/RMM*WW2 - (QM2/(2.D+00*RMM**2))*(SS(JTYP)*WW3+WW5)

      DO I=1,3
        POL(4,I)=RML*SS(JTYP)*(FACTK*P(1,I)+FACTP*P(2,I))/FRAC
        POLARX(I)=POL(4,I)
      END DO


      PMODUL=0.D0
      DO I=1,3
        PMODUL=PMODUL+POL(4,I)**2
      END DO

      IF(JTYP.GT.4.AND.NEUDEC.GT.0) THEN
         IF(NEUDEC.EQ.1) THEN
            CALL DT_LEPDCYP(EML(JTYP),EML(JTYP-2),POLARX(3),
     +        ETL,PXL,PYL,PZL,
     +        ETB,PXB,PYB,PZB,ETN,PXN,PYN,PZN)
c
c     Tau has decayed in muon
c
         ENDIF
         IF(NEUDEC.EQ.2) THEN
            CALL DT_LEPDCYP(EML(JTYP),EML(JTYP-4),POLARX(3),
     +        ETL,PXL,PYL,PZL,
     +        ETB,PXB,PYB,PZB,ETN,PXN,PYN,PZN)
c
c     Tau has decayed in electron
c
         ENDIF
         K(4,1)=15
         K(4,4) = 6
         K(4,5) = 8
         N=N+3
c
c     fill common for muon(electron)
c
         P(6,1)=PXL
         P(6,2)=PYL
         P(6,3)=PZL
         P(6,4)=ETL
         K(6,1)=1
         IF(JTYP.EQ.5) THEN
            IF(NEUDEC.EQ.1) THEN
               P(6,5)=EML(JTYP-2)
               K(6,2)=13
            ELSEIF(NEUDEC.EQ.2) THEN
               P(6,5)=EML(JTYP-4)
               K(6,2)=11
            ENDIF
         ELSEIF(JTYP.EQ.6) THEN
            IF(NEUDEC.EQ.1) THEN
               K(6,2)=-13
            ELSEIF(NEUDEC.EQ.2) THEN
               K(6,2)=-11
            ENDIF
         END IF
         K(6,3)=4
         K(6,4)=0
         K(6,5)=0
c
c     fill common for tau_(anti)neutrino
c
         P(7,1)=PXB
         P(7,2)=PYB
         P(7,3)=PZB
         P(7,4)=ETB
         P(7,5)=0.
         K(7,1)=1
         IF(JTYP.EQ.5) THEN
            K(7,2)=16
         ELSEIF(JTYP.EQ.6) THEN
            K(7,2)=-16
         END IF
         K(7,3)=4
         K(7,4)=0
         K(7,5)=0
c
c     Fill common for muon(electron)_(anti)neutrino
c
         P(8,1)=PXN
         P(8,2)=PYN
         P(8,3)=PZN
         P(8,4)=ETN
         P(8,5)=0.
         K(8,1)=1
         IF(JTYP.EQ.5) THEN
            IF(NEUDEC.EQ.1) THEN
               K(8,2)=-14
            ELSEIF(NEUDEC.EQ.2) THEN
               K(8,2)=-12
            ENDIF
         ELSEIF(JTYP.EQ.6) THEN
            IF(NEUDEC.EQ.1) THEN
               K(8,2)=14
            ELSEIF(NEUDEC.EQ.2) THEN
               K(8,2)=12
            ENDIF
         END IF
         K(8,3)=4
         K(8,4)=0
         K(8,5)=0
      ENDIF
c      WRITE(*,*)
c      WRITE(*,*)

c      IF(PMODUL.GE.1.D+00) THEN
c        WRITE(*,*) 'Pol',(POLARX(I),I=1,3)
c        write(*,*) pmodul
c        DO I=1,3
c          POL(4,I)=POL(4,I)/PMODUL
c          POLARX(I)=POL(4,I)
c        END DO
c        PMODUL=0.
c        DO I=1,3
c          PMODUL=PMODUL+POL(4,I)**2
c        END DO
c        WRITE(*,*) 'Pol',(POLARX(I),I=1,3)
c
c      ENDIF

c      WRITE(*,*) 'PMODUL = ',PMODUL

c      WRITE(*,*)
c      WRITE(*,*)
c      WRITE(*,*) 'prepola: Now back to nucl rest frame'

      CALL PYROBO(1,5,0.0D0,0.0D0,-BB2(1),-BB2(2),-BB2(3))

      XDC = V(4,1)+V(4,5)*P(4,1)/P(4,5)
      YDC = V(4,2)+V(4,5)*P(4,2)/P(4,5)
      ZDC = V(4,3)+V(4,5)*P(4,3)/P(4,5)
      DO NDC =6,8
         V(NDC,1) = XDC
         V(NDC,2) = YDC
         V(NDC,3) = ZDC
      END DO

      RETURN
      END
c
c===testrot============================================================*
c
CDECK  ID>, DT_TESTROT
      SUBROUTINE DT_TESTROT(PI,PO,PHI,MODE)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      DIMENSION ROT(3,3),PI(3),PO(3)

      IF (MODE.EQ.1) THEN
         ROT(1,1) = 1.D0
         ROT(1,2) = 0.D0
         ROT(1,3) = 0.D0
         ROT(2,1) = 0.D0
         ROT(2,2) = COS(PHI)
         ROT(2,3) = -SIN(PHI)
         ROT(3,1) = 0.D0
         ROT(3,2) = SIN(PHI)
         ROT(3,3) = COS(PHI)
      ELSEIF (MODE.EQ.2) THEN
         ROT(1,1) = 0.D0
         ROT(1,2) = 1.D0
         ROT(1,3) = 0.D0
         ROT(2,1) = COS(PHI)
         ROT(2,2) = 0.D0
         ROT(2,3) = -SIN(PHI)
         ROT(3,1) = SIN(PHI)
         ROT(3,2) = 0.D0
         ROT(3,3) = COS(PHI)
      ELSEIF (MODE.EQ.3) THEN
         ROT(1,1) = 0.D0
         ROT(2,1) = 1.D0
         ROT(3,1) = 0.D0
         ROT(1,2) = COS(PHI)
         ROT(2,2) = 0.D0
         ROT(3,2) = -SIN(PHI)
         ROT(1,3) = SIN(PHI)
         ROT(2,3) = 0.D0
         ROT(3,3) = COS(PHI)
      ELSEIF (MODE.EQ.4) THEN
         ROT(1,1) = 1.D0
         ROT(2,1) = 0.D0
         ROT(3,1) = 0.D0
         ROT(1,2) = 0.D0
         ROT(2,2) = COS(PHI)
         ROT(3,2) = -SIN(PHI)
         ROT(1,3) = 0.D0
         ROT(2,3) = SIN(PHI)
         ROT(3,3) = COS(PHI)
      ELSE
         STOP ' TESTROT: MODE NOT SUPPORTED!'
      ENDIF
      DO 1 J=1,3
        PO(J) = ROT(J,1)*PI(1)+ROT(J,2)*PI(2)+ROT(J,3)*PI(3)
    1 CONTINUE

      RETURN
      END
c
c===lepdcyp============================================================*
c
CDECK  ID>, DT_LEPDCYP
      SUBROUTINE DT_LEPDCYP(AMA,AML,POL,ETL,PXL,PYL,PZL,
     &                      ETB,PXB,PYB,PZB,ETN,PXN,PYN,PZN)
C
C-----------------------------------------------------------------
C
C   Author   :- G. Battistoni         10-NOV-1995
C
C=================================================================
C
C   Purpose   : performs decay of polarized lepton in
C               its rest frame: a => b + l + anti-nu
C               (Example: mu- => nu-mu + e- + anti-nu-e)
C               Polarization is assumed along Z-axis
C               WARNING:
C               1) b AND anti-nu ARE ASSUMED TO BE NEUTRINOS
C                  OF NEGLIGIBLE MASS
C               2) RADIATIVE CORRECTIONS ARE NOT CONSIDERED
C                  IN THIS VERSION
C
C   Method    : modifies phase space distribution obtained
C               by routine EXPLOD using a rejection against the
C               matrix element for unpolarized lepton decay
C
C   Inputs    : Mass of a :  AMA
C               Mass of l :  AML
C               Polar. of a: POL
C               (Example: fully polar. mu- decay: AMA=AMMUON, AML=AMELCT,
C                                                 POL = -1)
C
C   Outputs   : kinematic variables in the rest frame of decaying lepton
C               ETL,PXL,PYL,PZL 4-moment of l
C               ETB,PXB,PYB,PZB 4-moment of b
C               ETN,PXN,PYN,PZN 4-moment of anti-nu
C
C============================================================
C +
C Declarations.
C -
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( PIPIPI = 3.1415926535897932270 D+00 )
      PARAMETER ( ENEPER = 2.7182818284590452354 D+00 )
      PARAMETER ( SQRENT = 1.6487212707001281468 D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
C +
C    variables for EXPLOD
C -
      PARAMETER ( KPMX = 10 )
      DIMENSION AMEXPL (KPMX), PXEXPL (KPMX), PYEXPL (KPMX),
     &          PZEXPL (KPMX), ETEXPL (KPMX)
C +
C      test variables
C -
c*sr - removed (not needed)
C     COMMON /GBATNU/ ELERAT,NTRY
c*
C +
C     Initializes test variables
C -
      NTRY = 0
      ELERAT = 0.D+00
C +
C     Maximum value for matrix element
C -
      ELEMAX = ( AMA**2 + AML**2 )**2 / AMA**2 * ( AMA**2 - AML**2 +
     &  SQRT( AMA**4 + AML**4 - 3.D+00 * AMA**2 * AML**2 ) )
C + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
C     Inputs for EXPLOD
C part. no. 1 is l       (e- in mu- decay)
C part. no. 2 is b       (nu-mu in mu- decay)
C part. no. 3 is anti-nu (anti-nu-e in mu- decay)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      NPEXPL = 3
      ETOTEX = AMA
      AMEXPL(1) = AML
      AMEXPL(2) = 0.D+00
      AMEXPL(3) = 0.D+00
C +
C     phase space distribution
C -
  100 CONTINUE
      NTRY = NTRY + 1
      CALL DT_EXPLOD ( NPEXPL, AMEXPL, ETOTEX, ETEXPL, PXEXPL,
     &                 PYEXPL, PZEXPL )
C +
C  Calculates matrix element:
C  64*GF**2{[P(a)-ama*S(a)]*P(anti-nu)}{P(l)*P(b)}
C  Here CTH is the cosine of the angle between anti-nu and Z axis
C -
      CTH = PZEXPL(3) / SQRT ( PXEXPL(3)**2 + PYEXPL(3)**2 +
     &  PZEXPL(3)**2 )
      PROD1 = ETEXPL(3) * AMA * (1.D+00 - POL * CTH)
      PROD2 = ETEXPL(1) * ETEXPL(2) - PXEXPL(1)*PXEXPL(2) -
     &     PYEXPL(1)*PYEXPL(2) - PZEXPL(1)*PZEXPL(2)
      ELEMAT = 16.D+00 * PROD1 * PROD2
      IF(ELEMAT.GT.ELEMAX) THEN
        WRITE(ErrorOut,*) 'Problems in LEPDCY',ELEMAX,ELEMAT
        STOP
      ENDIF
C +
C     Here performs the rejection
C -
      TEST = DT_RNDM(ETOTEX) * ELEMAX
      IF ( TEST .GT. ELEMAT ) GO TO 100
C +
C     final assignment of variables
C -
      ELERAT = ELEMAT/ELEMAX
      ETL = ETEXPL(1)
      PXL = PXEXPL(1)
      PYL = PYEXPL(1)
      PZL = PZEXPL(1)
      ETB = ETEXPL(2)
      PXB = PXEXPL(2)
      PYB = PYEXPL(2)
      PZB = PZEXPL(2)
      ETN = ETEXPL(3)
      PXN = PXEXPL(3)
      PYN = PYEXPL(3)
      PZN = PZEXPL(3)
  999 RETURN
      END

C==================================================================
C.  Generation of  Delta resonance events
C==================================================================
c
c===gen_delta==========================================================*
c
CDECK  ID>, DT_GEN_DELTA
      SUBROUTINE DT_GEN_DELTA(ENU,LLEP,LTARG,JINT,P21,P22,P23,P24,P25)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

C...Generate a Delta-production neutrino/antineutrino
C.  CC-interaction on a nucleon
C
C.  INPUT  ENU (GeV) = Neutrino Energy
C.         LLEP = neutrino type
C.         LTARG = nucleon target type 1=p, 2=n.
C.         JINT = 1:CC, 2::NC
C.
C.  OUTPUT PPL(4)  4-monentum of final lepton
C----------------------------------------------------

      PARAMETER (MAXLND=4000)
      COMMON/PYJETS/N,NPAD,K(MAXLND,5),P(MAXLND,5),V(MAXLND,5)


c*sr - removed (not needed)
C     COMMON /CBAD/  LBAD, NBAD
c*

      DIMENSION PI(3),PO(3)
C     REAL*4 AMD0, AMD, AMN(2), AML0(6), AML, AML2, AMDMIN
      DIMENSION AML0(6),AMN(2)
      DATA AMD0 /1.231/, GAMD /0.12/, DELD/0.169/, AMDMIN/1.084/
      DATA AMN  /0.93827231, 0.93956563/
      DATA AML0 /2*0.51100E-03,2*0.105659, 2*1.777/

c     WRITE(6,*)' GEN_DEL',ENU,LLEP,LTARG,JINT,P21,P22,P23,P24,P25
      LBAD = 0
C...Final lepton mass
      IF (JINT.EQ.1) THEN
	AML = AML0(LLEP)
      ELSE
	AML = 0.
      ENDIF
      AML2 = AML**2

C...Particle labels (LUND)
      N = 5
      K(1,1) = 21
      K(2,1) = 21
      K(3,1) = 21
      K(4,1) = 1
      K(3,3) = 1
      K(4,3) = 1
      IF (LTARG .EQ. 1)  THEN
	 K(2,2) = 2212
      ELSE
	 K(2,2) = 2112
      ENDIF
      K0 = (LLEP-1)/2
      K1 = LLEP/2
      KA = 12 + 2*K0
      IS = -1 + 2*LLEP - 4*K1
      LNU = 2 - LLEP + 2*K1
      K(1,2) = IS*KA
      K(5,1) = 1
      K(5,3) = 2
      IF (JINT .EQ. 1)  THEN                    ! CC INTERACTIONS
	 K(3,2) = IS*24
	 K(4,2) = IS*(KA-1)
	IF(LNU.EQ.1) THEN
	  IF (LTARG .EQ. 1)  THEN
	      K(5,2) = 2224
	  ELSE
	      K(5,2) = 2214
	  ENDIF
	ELSE
	  IF (LTARG .EQ. 1)  THEN
	      K(5,2) = 2114
	  ELSE
	      K(5,2) = 1114
	  ENDIF
	ENDIF
      ELSE
	 K(3,2) = 23                           ! NC (Z0) INTERACTIONS
	 K(4,2) = K(1,2)
c*sr 7.5.00: swop Delta's (bug), Delta+ for proton (LTARG=1),
c                                Delta0 for neutron (LTARG=2)
C        IF (LTARG .EQ. 1)  THEN
C           K(5,2) = 2114
C        ELSE
C           K(5,2) = 2214
C        ENDIF
         IF (LTARG .EQ. 1)  THEN
            K(5,2) = 2214
         ELSE
            K(5,2) = 2114
         ENDIF
c*
      ENDIF

C...4-momentum initial lepton
      P(1,5) = 0.
      P(1,4) = ENU
      P(1,1) = 0.
      P(1,2) = 0.
      P(1,3) = ENU
C...4-momentum initial nucleon
      P(2,5) = AMN(LTARG)
C     P(2,4) = P(2,5)
C     P(2,1) = 0.
C     P(2,2) = 0.
C     P(2,3) = 0.
       P(2,1) = P21
       P(2,2) = P22
       P(2,3) = P23
       P(2,4) = P24
       P(2,5) = P25
      N=2
      BETA1=-P(2,1)/P(2,4)
      BETA2=-P(2,2)/P(2,4)
      BETA3=-P(2,3)/P(2,4)
      N=2

      CALL PYROBO(0,0,0.0D0,0.0D0,BETA1,BETA2,BETA3)

C     print*,' nucl. rest fram ( fermi incl.) prima della rotazione'

      PHI11=ATAN(P(1,2)/P(1,3))
      PI(1)=P(1,1)
      PI(2)=P(1,2)
      PI(3)=P(1,3)

      CALL DT_TESTROT(PI,PO,PHI11,1)
      DO LL=1,3
       IF(ABS(PO(LL)).LT.1.D-07) PO(LL)=0.
      END DO
      P(1,1)=PO(1)
      P(1,2)=PO(2)
      P(1,3)=PO(3)
      PHI12=ATAN(P(1,1)/P(1,3))

      PI(1)=P(1,1)
      PI(2)=P(1,2)
      PI(3)=P(1,3)
      CALL DT_TESTROT(PI,PO,PHI12,2)
      DO LL=1,3
        IF(ABS(PO(LL)).LT.1.D-07) PO(LL)=0.
      END DO
      P(1,1)=PO(1)
      P(1,2)=PO(2)
      P(1,3)=PO(3)

      ENUU=P(1,4)

C...Generate the Mass of the Delta
      NTRY = 0
100   R = PYR(0)
      AMD=AMD0+0.5*GAMD*TAN((2.*R-1.)*ATAN(2.*DELD/GAMD))
      NTRY = NTRY + 1
      IF (NTRY .GT. 1000)  THEN
	 LBAD = 1
	 WRITE (   6,1001)  NBAD, ENUU,AMD,AMDMIN,AMD0,GAMD,ET
	 RETURN
      ENDIF
      IF (AMD .LT. AMDMIN)  GOTO 100
      ET = ((AMD+AML)**2 - AMN(LTARG)**2)/(2.*AMN(LTARG))
      IF (ENUU .LT. ET) GOTO 100

C...Kinematical  limits in Q**2
      S = AMN(LTARG)**2 + 2.*AMN(LTARG)*ENUU
      SQS = SQRT(S)
      PSTAR = (S - AMN(LTARG)**2)/(2.*SQS)
      ELF = (S - AMD**2 + AML2)/(2.*SQS)
      PLF = SQRT(ELF**2 - AML2)
      Q2MIN = -AML2 + 2.*PSTAR*(ELF-PLF)
      Q2MAX = -AML2 + 2.*PSTAR*(ELF+PLF)
      IF (Q2MIN .LT. 0.)   Q2MIN = 0.

      DSIGMAX = DT_DSIGMA_DELTA(LNU,-Q2MIN, S, AML, AMD)
200   Q2 = Q2MIN + (Q2MAX-Q2MIN)*PYR(0)
      DSIG = DT_DSIGMA_DELTA(LNU,-Q2, S, AML, AMD)
      IF (DSIG .LT.  DSIGMAX*PYR(0)) GOTO 200


C...Generate the kinematics of the final particles
      EISTAR = (S + AMN(LTARG)**2)/(2.*SQS)
      GAM = EISTAR/AMN(LTARG)
      BET = PSTAR/EISTAR
      CTSTAR = ELF/PLF - (Q2 + AML2)/(2.*PSTAR*PLF)
      EL  = GAM*(ELF + BET*PLF*CTSTAR)
      PLZ = GAM*(PLF*CTSTAR + BET*ELF)
      PL  = SQRT(EL**2 - AML2)
      PLT = SQRT(MAX(1.D-06,(PL*PL - PLZ*PLZ)))
      PHI = 6.28319*PYR(0)
      P(4,1) = PLT*COS(PHI)
      P(4,2) = PLT*SIN(PHI)
      P(4,3) = PLZ
      P(4,4) = EL
      P(4,5) = AML

C...4-momentum of Delta
      P(5,1) = -P(4,1)
      P(5,2) = -P(4,2)
      P(5,3) = ENUU-P(4,3)
      P(5,4) = ENUU+AMN(LTARG)-P(4,4)
      P(5,5) = AMD

C...4-momentum  of intermediate boson
      P(3,5) = -Q2
      P(3,4) = P(1,4)-P(4,4)
      P(3,1) = P(1,1)-P(4,1)
      P(3,2) = P(1,2)-P(4,2)
      P(3,3) = P(1,3)-P(4,3)
      N=5

      DO KW=1,5
        PI(1)=P(KW,1)
        PI(2)=P(KW,2)
        PI(3)=P(KW,3)
        CALL DT_TESTROT(PI,PO,PHI12,3)
        DO LL=1,3
          IF(ABS(PO(LL)).LT.1.D-07) PO(LL)=0.
        END DO
        P(KW,1)=PO(1)
        P(KW,2)=PO(2)
        P(KW,3)=PO(3)
      END DO

c********************************************

        DO KW=1,5
          PI(1)=P(KW,1)
          PI(2)=P(KW,2)
          PI(3)=P(KW,3)
          CALL DT_TESTROT(PI,PO,PHI11,4)
          DO LL=1,3
            IF(ABS(PO(LL)).LT.1.D-07) PO(LL)=0.
          END DO
          P(KW,1)=PO(1)
          P(KW,2)=PO(2)
          P(KW,3)=PO(3)
       END DO
c********************************************
C         transform back into Lab.

      CALL PYROBO(0,0,0.0D0,0.0D0,-BETA1,-BETA2,-BETA3)

C     WRITE(6,*)' Lab fram ( fermi incl.) '
      N=5
      CALL PYEXEC


      RETURN
1001  FORMAT(2X, 'DT_GEN_DELTA : EVENT REJECTED ', I5,  6G10.3)
      END
c
c===dsigma_delta=======================================================*
c
CDECK  ID>, DT_DSIGMA_DELTA
      DOUBLE PRECISION FUNCTION DT_DSIGMA_DELTA (LNU, QQ, S, AML, MD)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

C...Reaction nu + N -> lepton + Delta
C.  returns the  cross section
C.  dsigma/dt
C.  INPUT  LNU = 1, 2  (neutrino-antineutrino)
C.         QQ = t (always negative)  GeV**2
C.         S  = (c.m energy)**2      GeV**2
C.  OUTPUT =  10**-38 cm+2/GeV**2
C-----------------------------------------------------
      REAL*8 MN, MN2, MN4, MD,MD2, MD4
      DATA MN /0.938/
      DATA PI /3.1415926/

      GF = (1.1664 * 1.97)
      GF2 = GF*GF
      MN2 = MN*MN
      MN4 = MN2*MN2
      MD2 = MD*MD
      MD4 = MD2*MD2
      AML2 = AML*AML
      AML4 = AML2*AML2
      VQ  = (MN2 - MD2 - QQ)/2.
      VPI = (MN2 + MD2 - QQ)/2.
      VK  = (S + QQ - MN2 - AML2)/2.
      PIK = (S - MN2)/2.
      QK = (AML2 - QQ)/2.
      PIQ = (QQ + MN2 - MD2)/2.
      Q = SQRT(-QQ)
      C3V = 2.07*SQRT(EXP(-6.3*Q)*(1.+9*Q))
      C3 = SQRT(3.)*C3V/MN
      C4 = -C3/MD             ! ATTENZIONE AL SEGNO
      C5A = 1.18/(1.-QQ/0.4225)**2
      C32 = C3**2
      C42 = C4**2
      C5A2 = C5A**2

      IF (LNU .EQ. 1)  THEN
      ANS3=-MD2*VPI*QK*QQ*C32+MD2*VPI*QK*C5A2+2.*MD2*VQ*
     . PIK*QK*C32+2.*MD2*VQ*QK*PIQ*C32+MD4*VPI*QK*QQ*C42-
     . 2.*VK**2*VPI*QQ*C32+2.*VK**2*VPI*C5A2+4.*VK*VPI*VQ*
     . QK*C32+2.*VK*VPI*VQ*C5A2+2.*VPI*VQ**2*QK*C32
      ANS2=2.*MN*MD*MD2*VK**2*QQ*C42-4.*MN*MD*MD2*VK*VQ*QK
     . *C42-2.*MN*MD*MD2*VQ**2*QK*C42-2.*MN*MD*MD2*QK**2*
     . C32-3.*MN*MD*MD2*QK*QQ*C32+MN*MD*MD2*QK*C5A2-MN*MD*
     . MD4*QK*QQ*C42+2.*MN*MD*VK**2*C5A2+2.*MN*MD*VK*VQ*
     . C5A2+4.*MN*C3*C4*MD2*VK**2*QQ-8.*MN*C3*C4*MD2*VK*VQ
     . *QK-4.*MN*C3*C4*MD2*VQ**2*QK-2.*MN*C3*C4*MD4*QK*QQ-
     . 4.*MN*C3*C5A*MD2*VK*QQ+4.*MN*C3*C5A*MD2*VQ*QK-2.*MD*
     . C3*C4*MD2*VK*PIK*QQ+2.*MD*C3*C4*MD2*VK*QK*PIQ+2.*MD
     . *C3*C4*MD2*VPI*QK*QQ+2.*MD*C3*C4*MD2*VQ*PIK*QK+2.*
     . MD*C3*C4*MD2*VQ*QK*PIQ-2.*MD*C3*C4*VK**2*VPI*QQ+4.*
     . MD*C3*C4*VK*VPI*VQ*QK+2.*MD*C3*C4*VPI*VQ**2*QK-MD*
     . C3*C5A*MD2*PIK*QQ+MD*C3*C5A*MD2*QK*PIQ-3.*MD*C3*C5A
     . *VK*VPI*QQ+MD*C3*C5A*VK*VQ*PIQ+3.*MD*C3*C5A*VPI*VQ*
     . QK-MD*C3*C5A*VQ**2*PIK+C4*C5A*MD2*VK*VPI*QQ+C4*C5A*
     . MD2*VK*VQ*PIQ-C4*C5A*MD2*VPI*VQ*QK-C4*C5A*MD2*VQ**2
     . *PIK-C4*C5A*MD4*PIK*QQ+C4*C5A*MD4*QK*PIQ-2.*MD2*VK
     . **2*VPI*QQ*C42+4.*MD2*VK*VPI*VQ*QK*C42-2.*MD2*VK*
     . PIK*QQ*C32+2.*MD2*VK*QK*PIQ*C32+2.*MD2*VPI*VQ**2*QK
     . *C42-2.*MD2*VPI*QK**2*C32+ANS3
      ELSE
      ANS3=-MD2*VPI*QK*QQ*C32+MD2*VPI*QK*C5A2+2.*MD2*VQ*
     . PIK*QK*C32+2.*MD2*VQ*QK*PIQ*C32+MD4*VPI*QK*QQ*C42-
     . 2.*VK**2*VPI*QQ*C32+2.*VK**2*VPI*C5A2+4.*VK*VPI*VQ*
     . QK*C32+2.*VK*VPI*VQ*C5A2+2.*VPI*VQ**2*QK*C32
      ANS2=2.*MN*MD*MD2*VK**2*QQ*C42-4.*MN*MD*MD2*VK*VQ*QK
     . *C42-2.*MN*MD*MD2*VQ**2*QK*C42-2.*MN*MD*MD2*QK**2*
     . C32-3.*MN*MD*MD2*QK*QQ*C32+MN*MD*MD2*QK*C5A2-MN*MD*
     . MD4*QK*QQ*C42+2.*MN*MD*VK**2*C5A2+2.*MN*MD*VK*VQ*
     . C5A2+4.*MN*C3*C4*MD2*VK**2*QQ-8.*MN*C3*C4*MD2*VK*VQ
     . *QK-4.*MN*C3*C4*MD2*VQ**2*QK-2.*MN*C3*C4*MD4*QK*QQ+
     . 4.*MN*C3*C5A*MD2*VK*QQ-4.*MN*C3*C5A*MD2*VQ*QK-2.*MD*
     . C3*C4*MD2*VK*PIK*QQ+2.*MD*C3*C4*MD2*VK*QK*PIQ+2.*MD
     . *C3*C4*MD2*VPI*QK*QQ+2.*MD*C3*C4*MD2*VQ*PIK*QK+2.*
     . MD*C3*C4*MD2*VQ*QK*PIQ-2.*MD*C3*C4*VK**2*VPI*QQ+4.*
     . MD*C3*C4*VK*VPI*VQ*QK+2.*MD*C3*C4*VPI*VQ**2*QK+MD*
     . C3*C5A*MD2*PIK*QQ-MD*C3*C5A*MD2*QK*PIQ+3.*MD*C3*C5A
     . *VK*VPI*QQ-MD*C3*C5A*VK*VQ*PIQ-3.*MD*C3*C5A*VPI*VQ*
     . QK+MD*C3*C5A*VQ**2*PIK-C4*C5A*MD2*VK*VPI*QQ-C4*C5A*
     . MD2*VK*VQ*PIQ+C4*C5A*MD2*VPI*VQ*QK+C4*C5A*MD2*VQ**2
     . *PIK+C4*C5A*MD4*PIK*QQ-C4*C5A*MD4*QK*PIQ-2.*MD2*VK
     . **2*VPI*QQ*C42+4.*MD2*VK*VPI*VQ*QK*C42-2.*MD2*VK*
     . PIK*QQ*C32+2.*MD2*VK*QK*PIQ*C32+2.*MD2*VPI*VQ**2*QK
     . *C42-2.*MD2*VPI*QK**2*C32+ANS3
      ENDIF
      ANS1=32.*ANS2
      ANS=ANS1/(3.*MD2)
      P1CM = (S-MN2)/(2.*SQRT(S))
      DT_DSIGMA_DELTA  = GF2/2. * ANS/(64.*PI*S*P1CM**2)

      RETURN
      END
c
c===qgaus==============================================================*
c
CDECK  ID>, DT_QGAUS
      SUBROUTINE DT_QGAUS(A,B,SS,ENU,LTYP)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      DIMENSION X(5),W(5)
      DATA X/.1488743389D0,.4333953941D0,
     & .6794095682D0,.8650633666D0,.9739065285D0
     */
      DATA W/.2955242247D0,.2692667193D0,
     & .2190863625D0,.1494513491D0,.0666713443D0
     */
      XM=0.5D0*(B+A)
      XR=0.5D0*(B-A)
      SS=0
      DO 11 J=1,5
        DX=XR*X(J)
        SS=SS+W(J)*(DT_DSQEL_Q2(LTYP,ENU,XM+DX)+
     *	DT_DSQEL_Q2(LTYP,ENU,XM-DX))
11    CONTINUE
      SS=XR*SS

      RETURN
      END
c
c===diqbrk=============================================================*
c
CDECK  ID>, DT_DIQBRK
      SUBROUTINE DT_DIQBRK

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c event flag
      COMMON /DTEVNO/ NEVENT,ICASCA


C     IF(DT_RNDM(VV).LE.0.5D0)THEN
C       CALL GSQBS1(NHKK)
C       CALL GSQBS2(NHKK)
C       CALL USQBS1(NHKK)
C       CALL USQBS2(NHKK)
C       CALL GSABS1(NHKK)
C       CALL GSABS2(NHKK)
C       CALL USABS1(NHKK)
C       CALL USABS2(NHKK)
C     ELSE
C       CALL GSQBS2(NHKK)
C       CALL GSQBS1(NHKK)
C       CALL USQBS2(NHKK)
C       CALL USQBS1(NHKK)
C       CALL GSABS2(NHKK)
C       CALL GSABS1(NHKK)
C       CALL USABS2(NHKK)
C       CALL USABS1(NHKK)
C     ENDIF

      IF(DT_RNDM(VV).LE.0.5D0) THEN
        CALL DT_DBREAK(1)
        CALL DT_DBREAK(2)
        CALL DT_DBREAK(3)
        CALL DT_DBREAK(4)
        CALL DT_DBREAK(5)
        CALL DT_DBREAK(6)
        CALL DT_DBREAK(7)
        CALL DT_DBREAK(8)
      ELSE
        CALL DT_DBREAK(2)
        CALL DT_DBREAK(1)
        CALL DT_DBREAK(4)
        CALL DT_DBREAK(3)
        CALL DT_DBREAK(6)
        CALL DT_DBREAK(5)
        CALL DT_DBREAK(8)
        CALL DT_DBREAK(7)
      ENDIF

      RETURN
      END
C
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      SUBROUTINE MUSQBS2(NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,
     *              IP1,IP21,IP22,IPP1,IPP2,IPIP,ISQ,IGCOUN)
C
C                  USQBS-2 diagram (split target diquark)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c diquark-breaking mechanism
      COMMON /DTDIQB/ DBRKR(3,8),DBRKA(3,8),CHAM1,CHAM3,CHAB1,CHAB3


C
      PARAMETER (NTMHKK= 300)
      COMMON /HKKTMP/NHKKT,NEVHKT,ISTHKT(NTMHKK),IDHKT(NTMHKK),JMOHKT
     +(2,NTMHKK),JDAHKT(2,NTMHKK), PHKT(5,NTMHKK),VHKT(4,NTMHKK),WHKT
     +(4,NTMHKK)
cKEEP,XSEADI.
      COMMON /XSEADI/ XSEACU,UNON,UNOM,UNOSEA,CVQ,CDQ,CSEA,SSMIMA,
     +SSMIMQ,VVMTHR
cKEEP,DPRIN.
      COMMON /DPRIN/ IPRI,IPEV,IPPA,IPCO,INIT,IPHKK,ITOPD,IPAUPR
      COMMON /EVFLAG/ NUMEV
C
C                  USQBS-2 diagram (split target diquark)
C
C
C     Input chain 1(NC1) valence-quark(NC1P)-valence-diquark(NC1T)
C     Input chain 2(NC2) sea-antiquark(NC2P)-sea-quark(NC2T)
C
C     Create antiquark(aqsP)-quark(qsT) pair, energy from NC1P and NC1T
C     Split remaining valence diquark(NC1T) into quarks vq1T and vq2T
C
C     Create chains 3 sea antiquark(NC2P 1)-valence-quark(vq1T 2)
C                   6 sea-antiquark(aqsP 4)-valence-quark(vq2T 5)
C                   9 valence-quark(NC1P 7)-diquark(NC2T+qsT 8)
C
C
C       Put new chains into COMMON /HKKTMP/
C
      IIGLU1=NC1T-NC1P-1
      IIGLU2=NC2T-NC2P-1
      IGCOUN=0
C     WRITE(6,*)'MUSQBS2: IIGLU1,IIGLU2 ',IIGLU1,IIGLU2
      CVQ=1.D0
      IREJ=0
      IF(IPIP.EQ.2)THEN
C     IF(NUMEV.EQ.-324)THEN
C     WRITE(6,*)' MUSQBS2(NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,',
C    *             'IP1,IP21,IP22,IPP1,IPP2,IPIP,IGCOUN)',
C    *NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,
C    *              IP1,IP21,IP22,IPP1,IPP2,IPIP,IGCOUN
      ENDIF
C
C
C
C     determine x-values of NC1T diquark
      XDIQT=PHKK(4,NC1T)*2.D0/UMO
      XVQP=PHKK(4,NC1P)*2.D0/UMO
C
C     determine x-values of sea quark pair
C
      IPCO=1
      ICOU=0
 2234 CONTINUE
      ICOU=ICOU+1
      IF(ICOU.GE.500)THEN
        IREJ=1
        IF(ISQ.EQ.3)IREJ=3
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)' MUSQBS2 Rejection 2234 ICOU. GT.500'
        IPCO=0
        RETURN
      ENDIF
      IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'MUSQBS2 call  XSEAPA: UMO,XDIQT,XVQP ',
     * UMO, XDIQT,XVQP
      XSQ=0.D0
      XSAQ=0.D0
c*NEW
C     CALL XSEAPA(UMO,XDIQT/2.D0,ISQ,ISAQ,XSQ,XSAQ,IREJ)
      IF (IPIP.EQ.1) THEN
         XQMAX  = XDIQT/2.0D0
         XAQMAX = 2.D0*XVQP/3.0D0
      ELSE
         XQMAX  = 2.D0*XVQP/3.0D0
         XAQMAX = XDIQT/2.0D0
      ENDIF
      CALL DT_CQPAIR(XQMAX,XAQMAX,XSQ,XSAQ,ISQ,IREJ)
      ISAQ = 6+ISQ
C     write(*,*) 'MUSQBS2: ',ISQ,XSQ,XDIQT,XSAQ,XVQP
c*
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'MUSQBS2 after XSEAPA',ISQ,ISAQ,XSQ,XSAQ
      IF(IREJ.GE.1)THEN
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'MUSQBS2 reject XSEAPA',ISQ,ISAQ,XSQ,XSAQ
        IPCO=0
        RETURN
      ENDIF
      IF(IPIP.EQ.1)THEN
        IF(XSAQ.GE.2.D0*XVQP/3.D0)GO TO 2234
      ELSEIF(IPIP.EQ.2)THEN
        IF(XSQ.GE.2.D0*XVQP/3.D0)GO TO 2234
      ENDIF
      IF(IPCO.GE.3)THEN
        WRITE(ErrorOut,
     * '(A,4E12.4)')' MUSQBS2 XDIQT,XVQP,XSQ,XSAQ ',
     *	XDIQT,XVQP,XSQ,XSAQ
      ENDIF
C
C     subtract xsq,xsaq from NC1T diquark and NC1P quark
C
C     XSQ=0.D0
      IF(IPIP.EQ.1)THEN
        XDIQT=XDIQT-XSQ
        XVQP =XVQP -XSAQ
      ELSEIF(IPIP.EQ.2)THEN
        XDIQT=XDIQT-XSAQ
        XVQP =XVQP -XSQ
      ENDIF
      IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'XDIQT,XVQP after subtraction',XDIQT,XVQP
C
C     Split remaining valence diquark(NC1T) into quarks vq1T and vq2T
C
      XVTHRO=CVQ/UMO
      IVTHR=0
 3466 CONTINUE
      IF(IVTHR.EQ.10)THEN
        IREJ=1
        IF(ISQ.EQ.3)IREJ=3
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)' MUSQBS2 3466 reject IVTHR 10'
      IPCO=0
        RETURN
      ENDIF
      IVTHR=IVTHR+1
      XVTHR=XVTHRO/(201-IVTHR)
      UNOPRV=UNON
 380  CONTINUE
      IF(XVTHR.GT.0.66D0*XDIQT)THEN
        IREJ=1
        IF(ISQ.EQ.3)IREJ=3
	IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)' MUSQBS2 Rejection 380 XVTHR  large ',
     *  XVTHR
      IPCO=0
        RETURN
      ENDIF
      IF(DT_RNDM(V).LT.0.5D0)THEN
        XVTQI=DT_SAMPEX(XVTHR,0.66D0*XDIQT)
        XVTQII=XDIQT-XVTQI
      ELSE
        XVTQII=DT_SAMPEX(XVTHR,0.66D0*XDIQT)
        XVTQI=XDIQT-XVTQII
      ENDIF
      IF(IPCO.GE.3)THEN
        WRITE(ErrorOut,
     * '(A,2E12.4)')'  MUSQBS2:XVTQI,XVTQII ',XVTQI,XVTQII
      ENDIF
C
C     Prepare 4 momenta of new chains and chain ends
C
C     COMMON /HKKTMP/NHKKT,NEVHKT,ISTHKT(NTMHKK),IDHKT(NTMHKK),JMOHKT
C    +(2,NTMHKK),JDAHKT(2,NTMHKK), PHKT(5,NTMHKK),VHKT(4,NTMHKK),WHKT
C    +(4,NTMHKK)
C
C     Create chains 3 sea antiquark(NC2P 1)-valence-quark(vq1T 2)
C                   6 sea-antiquark(aqsP 4)-valence-quark(vq2T 5)
C                   9 valence-quark(NC1P 7)-diquark(NC2T+qsT 8)
C
C     SUBROUTINE MUSQBS2(NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,
C    *              IP1,IP21,IP22,IPP1,IPP2)
C
      IF(IPIP.EQ.1)THEN
        XSQ1=XSQ
        XSAQ1=XSAQ
        ISQ1=ISQ
        ISAQ1=ISAQ
      ELSEIF(IPIP.EQ.2)THEN
        XSQ1=XSAQ
        XSAQ1=XSQ
        ISQ1=ISAQ
        ISAQ1=ISQ
      ENDIF
      IDHKT(1)   =IPP1
      ISTHKT(1)  =951
      JMOHKT(1,1)=NC2P
      JMOHKT(2,1)=0
      JDAHKT(1,1)=3+IIGLU1
      JDAHKT(2,1)=0
C     Create chains 3 sea antiquark(NC2P 1)-valence-quark(vq1T 2)
      PHKT(1,1)  =PHKK(1,NC2P)
      PHKT(2,1)  =PHKK(2,NC2P)
      PHKT(3,1)  =PHKK(3,NC2P)
      PHKT(4,1)  =PHKK(4,NC2P)
C     PHKT(5,1)  =PHKK(5,NC2P)
      XMIST  =(PHKT(4,1)**2-
     * PHKT(3,1)**2-PHKT(2,1)**2-
     *PHKT(1,1)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,1)  =SQRT(PHKT(4,1)**2- PHKT(3,1)**2-PHKT(2,1)**2-
     *PHKT(1,1)**2)
      ELSE
C     WRITE(6,*)'MUSQBS2 parton 1 mass square LT.0 ',XMIST
      PHKT(5,1)=0.D0
      ENDIF
      VHKT(1,1)  =VHKK(1,NC2P)
      VHKT(2,1)  =VHKK(2,NC2P)
      VHKT(3,1)  =VHKK(3,NC2P)
      VHKT(4,1)  =VHKK(4,NC2P)
      WHKT(1,1)  =WHKK(1,NC2P)
      WHKT(2,1)  =WHKK(2,NC2P)
      WHKT(3,1)  =WHKK(3,NC2P)
      WHKT(4,1)  =WHKK(4,NC2P)
C     Add here IIGLU1 gluons to this chaina
      PG1=0.D0
      PG2=0.D0
      PG3=0.D0
      PG4=0.D0
      IF(IIGLU1.GE.1)THEN
      JJG=NC1P
      DO 61 IIG=2,2+IIGLU1-1
        KKG=JJG+IIG-1
        IDHKT(IIG)   =IDHKK(KKG)
        ISTHKT(IIG)  =921
        JMOHKT(1,IIG)=KKG
        JMOHKT(2,IIG)=0
        JDAHKT(1,IIG)=3+IIGLU1
        JDAHKT(2,IIG)=0
        PHKT(1,IIG)=PHKK(1,KKG)
        PG1=PG1+ PHKT(1,IIG)
        PHKT(2,IIG)=PHKK(2,KKG)
        PG2=PG2+ PHKT(2,IIG)
        PHKT(3,IIG)=PHKK(3,KKG)
        PG3=PG3+ PHKT(3,IIG)
        PHKT(4,IIG)=PHKK(4,KKG)
        PG4=PG4+ PHKT(4,IIG)
	PHKT(5,IIG)=PHKK(5,KKG)
        VHKT(1,IIG)  =VHKK(1,KKG)
        VHKT(2,IIG)  =VHKK(2,KKG)
        VHKT(3,IIG)  =VHKK(3,KKG)
        VHKT(4,IIG)  =VHKK(4,KKG)
        WHKT(1,IIG) =WHKK(1,KKG)
        WHKT(2,IIG) =WHKK(2,KKG)
        WHKT(3,IIG) =WHKK(3,KKG)
	WHKT(4,IIG) =WHKK(4,KKG)
   61 CONTINUE
      ENDIF
      IDHKT(2+IIGLU1)   =IP21
      ISTHKT(2+IIGLU1)  =952
      JMOHKT(1,2+IIGLU1)=NC1T
      JMOHKT(2,2+IIGLU1)=0
      JDAHKT(1,2+IIGLU1)=3+IIGLU1
      JDAHKT(2,2+IIGLU1)=0
      PHKT(1,2+IIGLU1)  =PHKK(1,NC1T)*XVTQI/(XDIQT+XSQ1)
      PHKT(2,2+IIGLU1)  =PHKK(2,NC1T)*XVTQI/(XDIQT+XSQ1)
      PHKT(3,2+IIGLU1)  =PHKK(3,NC1T)*XVTQI/(XDIQT+XSQ1)
      PHKT(4,2+IIGLU1)  =PHKK(4,NC1T)*XVTQI/(XDIQT+XSQ1)
C     PHKT(5,2)  =PHKK(5,NC1T)
      XMIST  =(PHKT(4,2+IIGLU1)**2-
     * PHKT(3,2+IIGLU1)**2-PHKT(2,2+IIGLU1)**2-
     *PHKT(1,2+IIGLU1)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,2+IIGLU1)  =SQRT(PHKT(4,2+IIGLU1)**2-
     * PHKT(3,2+IIGLU1)**2-PHKT(2,2+IIGLU1)**2-
     *PHKT(1,2+IIGLU1)**2)
      ELSE
C      WRITE(6,*)' parton 4 mass square LT.0 ',XMIST
        PHKT(5,5+IIGLU1)=0.D0
      ENDIF
      VHKT(1,2+IIGLU1)  =VHKK(1,NC1T)
      VHKT(2,2+IIGLU1)  =VHKK(2,NC1T)
      VHKT(3,2+IIGLU1)  =VHKK(3,NC1T)
      VHKT(4,2+IIGLU1)  =VHKK(4,NC1T)
      WHKT(1,2+IIGLU1)  =WHKK(1,NC1T)
      WHKT(2,2+IIGLU1)  =WHKK(2,NC1T)
      WHKT(3,2+IIGLU1)  =WHKK(3,NC1T)
      WHKT(4,2+IIGLU1)  =WHKK(4,NC1T)
      IDHKT(3+IIGLU1)   =88888
      ISTHKT(3+IIGLU1)  =95
      JMOHKT(1,3+IIGLU1)=1
      JMOHKT(2,3+IIGLU1)=2+IIGLU1
      JDAHKT(1,3+IIGLU1)=0
      JDAHKT(2,3+IIGLU1)=0
      PHKT(1,3+IIGLU1)  =PHKT(1,1)+PHKT(1,2+IIGLU1)+PG1
      PHKT(2,3+IIGLU1)  =PHKT(2,1)+PHKT(2,2+IIGLU1)+PG2
      PHKT(3,3+IIGLU1)  =PHKT(3,1)+PHKT(3,2+IIGLU1)+PG3
      PHKT(4,3+IIGLU1)  =PHKT(4,1)+PHKT(4,2+IIGLU1)+PG4
      XMIST
     * =(PHKT(4,3+IIGLU1)**2-PHKT(1,3+IIGLU1)**2-PHKT(2,3+IIGLU1)**2
     *            -PHKT(3,3+IIGLU1)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,3+IIGLU1)
     * =SQRT(PHKT(4,3+IIGLU1)**2-PHKT(1,3+IIGLU1)**2-PHKT(2,3+IIGLU1)**2
     *            -PHKT(3,3+IIGLU1)**2)
      ELSE
C      WRITE(6,*)' parton 4 mass square LT.0 ',XMIST
        PHKT(5,5+IIGLU1)=0.D0
      ENDIF
      IF(IPIP.GE.2)THEN
C     IF(NUMEV.EQ.-324)THEN
C     WRITE(6,*)1,ISTHKT(1),IDHKT(1),JMOHKT(1,1),JMOHKT(2,1),
C    * JDAHKT(1,1),
C    *JDAHKT(2,1),(PHKT(III,1),III=1,5)
      DO 71 IIG=2,2+IIGLU1-1
C     WRITE(6,*)IIG,ISTHKT(IIG),IDHKT(IIG),JMOHKT(1,IIG),JMOHKT(2,IIG),
C    * JDAHKT(1,IIG),
C    *JDAHKT(2,IIG),(PHKT(III,IIG),III=1,5)
   71 CONTINUE
C     WRITE(6,*)2+IIGLU1,ISTHKT(2+IIGLU1),IDHKT(2+IIGLU1),
C    * JMOHKT(1,2+IIGLU1),JMOHKT(2,2+IIGLU1),JDAHKT(1,2+IIGLU1),
C    *JDAHKT(2,2+IIGLU1),(PHKT(III,2+IIGLU1),III=1,5)
C     WRITE(6,*)3+IIGLU1,ISTHKT(3+IIGLU1),IDHKT(3+IIGLU1),
C    * JMOHKT(1,3+IIGLU1),JMOHKT(2,3+IIGLU1),JDAHKT(1,3+IIGLU1),
C    *JDAHKT(2,3+IIGLU1),(PHKT(III,3+IIGLU1),III=1,5)
      ENDIF
      CHAMAL=CHAM1
      IF(IPIP.EQ.1)THEN
        IF(IPP1.LE.-3.OR.IP21.GE.3)CHAMAL=CHAM3
      ELSEIF(IPIP.EQ.2)THEN
        IF(IPP1.GE.3.OR.IP21.LE.-3)CHAMAL=CHAM3
      ENDIF
      IF(PHKT(5,3+IIGLU1).LT.CHAMAL)THEN
C       IREJ=1
	IPCO=0
C	RETURN
C       WRITE(6,*)' MUSQBS1 jump back from chain 3'
	GO TO 3466
      ENDIF
      VHKT(1,3+IIGLU1)  =VHKK(1,NC1)
      VHKT(2,3+IIGLU1)  =VHKK(2,NC1)
      VHKT(3,3+IIGLU1)  =VHKK(3,NC1)
      VHKT(4,3+IIGLU1)  =VHKK(4,NC1)
      WHKT(1,3+IIGLU1)  =WHKK(1,NC1)
      WHKT(2,3+IIGLU1)  =WHKK(2,NC1)
      WHKT(3,3+IIGLU1)  =WHKK(3,NC1)
      WHKT(4,3+IIGLU1)  =WHKK(4,NC1)
      IF(IPIP.EQ.1)THEN
        IDHKT(4+IIGLU1)   =-(ISAQ1-6)
      ELSEIF(IPIP.EQ.2)THEN
        IDHKT(4+IIGLU1)   =ISAQ1
      ENDIF
      ISTHKT(4+IIGLU1)  =951
      JMOHKT(1,4+IIGLU1)=NC1P
      JMOHKT(2,4+IIGLU1)=0
      JDAHKT(1,4+IIGLU1)=6+IIGLU1
      JDAHKT(2,4+IIGLU1)=0
C     create chain    6 sea-antiquark(aqsP 4)-valence-quark(vq2T 5)
      PHKT(1,4+IIGLU1)  =PHKK(1,NC1P)*XSAQ1/(XVQP+XSAQ1)
      PHKT(2,4+IIGLU1)  =PHKK(2,NC1P)*XSAQ1/(XVQP+XSAQ1)
      PHKT(3,4+IIGLU1)  =PHKK(3,NC1P)*XSAQ1/(XVQP+XSAQ1)
      PHKT(4,4+IIGLU1)  =PHKK(4,NC1P)*XSAQ1/(XVQP+XSAQ1)
C     PHKT(5,4+IIGLU1)  =PHKK(5,NC1P)
      XMIST  =(PHKT(4,4+IIGLU1)**2-
     * PHKT(3,4+IIGLU1)**2-PHKT(2,4+IIGLU1)**2-
     *PHKT(1,4+IIGLU1)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,4+IIGLU1)  =SQRT(PHKT(4,4+IIGLU1)**2-
     * PHKT(3,4+IIGLU1)**2-PHKT(2,4+IIGLU1)**2-
     *PHKT(1,4+IIGLU1)**2)
      ELSE
C     WRITE(6,*)'MUSQBS2 parton 4 mass square LT.0 ',XMIST
      PHKT(5,4+IIGLU1)=0.D0
      ENDIF
      VHKT(1,4+IIGLU1)  =VHKK(1,NC1P)
      VHKT(2,4+IIGLU1)  =VHKK(2,NC1P)
      VHKT(3,4+IIGLU1)  =VHKK(3,NC1P)
      VHKT(4,4+IIGLU1)  =VHKK(4,NC1P)
      WHKT(1,4+IIGLU1)  =WHKK(1,NC1P)
      WHKT(2,4+IIGLU1)  =WHKK(2,NC1P)
      WHKT(3,4+IIGLU1)  =WHKK(3,NC1P)
      WHKT(4,4+IIGLU1)  =WHKK(4,NC1P)
      IDHKT(5+IIGLU1)   =IP22
      ISTHKT(5+IIGLU1)  =952
      JMOHKT(1,5+IIGLU1)=NC1T
      JMOHKT(2,5+IIGLU1)=0
      JDAHKT(1,5+IIGLU1)=6+IIGLU1
      JDAHKT(2,5+IIGLU1)=0
      PHKT(1,5+IIGLU1)  =PHKK(1,NC1T)*XVTQII/(XDIQT+XSQ1)
      PHKT(2,5+IIGLU1)  =PHKK(2,NC1T)*XVTQII/(XDIQT+XSQ1)
      PHKT(3,5+IIGLU1)  =PHKK(3,NC1T)*XVTQII/(XDIQT+XSQ1)
      PHKT(4,5+IIGLU1)  =PHKK(4,NC1T)*XVTQII/(XDIQT+XSQ1)
C     PHKT(5,5+IIGLU1)  =PHKK(5,NC1T)
      XMIST  =(PHKT(4,5+IIGLU1)**2-
     * PHKT(3,5+IIGLU1)**2-PHKT(2,5+IIGLU1)**2-
     *PHKT(1,5+IIGLU1)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,5+IIGLU1)  =SQRT(PHKT(4,5+IIGLU1)**2-
     * PHKT(3,5+IIGLU1)**2-PHKT(2,5+IIGLU1)**2-
     *PHKT(1,5+IIGLU1)**2)
      ELSE
C      WRITE(6,*)' parton 4 mass square LT.0 ',XMIST
        PHKT(5,5+IIGLU1)=0.D0
      ENDIF
      VHKT(1,5+IIGLU1)  =VHKK(1,NC1T)
      VHKT(2,5+IIGLU1)  =VHKK(2,NC1T)
      VHKT(3,5+IIGLU1)  =VHKK(3,NC1T)
      VHKT(4,5+IIGLU1)  =VHKK(4,NC1T)
      WHKT(1,5+IIGLU1)  =WHKK(1,NC1T)
      WHKT(2,5+IIGLU1)  =WHKK(2,NC1T)
      WHKT(3,5+IIGLU1)  =WHKK(3,NC1T)
      WHKT(4,5+IIGLU1)  =WHKK(4,NC1T)
      IDHKT(6+IIGLU1)   =88888
      ISTHKT(6+IIGLU1)  =95
      JMOHKT(1,6+IIGLU1)=4+IIGLU1
      JMOHKT(2,6+IIGLU1)=5+IIGLU1
      JDAHKT(1,6+IIGLU1)=0
      JDAHKT(2,6+IIGLU1)=0
      PHKT(1,6+IIGLU1)  =PHKT(1,4+IIGLU1)+PHKT(1,5+IIGLU1)
      PHKT(2,6+IIGLU1)  =PHKT(2,4+IIGLU1)+PHKT(2,5+IIGLU1)
      PHKT(3,6+IIGLU1)  =PHKT(3,4+IIGLU1)+PHKT(3,5+IIGLU1)
      PHKT(4,6+IIGLU1)  =PHKT(4,4+IIGLU1)+PHKT(4,5+IIGLU1)
      XMIST
     * =(PHKT(4,6+IIGLU1)**2-PHKT(1,6+IIGLU1)**2-PHKT(2,6+IIGLU1)**2
     *            -PHKT(3,6+IIGLU1)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,6+IIGLU1)
     * =SQRT(PHKT(4,6+IIGLU1)**2-PHKT(1,6+IIGLU1)**2-PHKT(2,6+IIGLU1)**2
     *            -PHKT(3,6+IIGLU1)**2)
      ELSE
C      WRITE(6,*)' parton 4 mass square LT.0 ',XMIST
        PHKT(5,5+IIGLU1)=0.D0
      ENDIF
C     IF(IPIP.GE.2)THEN
C     IF(NUMEV.EQ.-324)THEN
C     WRITE(6,*)4+IIGLU1,ISTHKT(4+IIGLU1),IDHKT(4+IIGLU1),
C    * JMOHKT(1,4+IIGLU1),JMOHKT(2,4+IIGLU1),JDAHKT(1,4+IIGLU1),
C    *JDAHKT(2,4+IIGLU1),(PHKT(III,4+IIGLU1),III=1,5)
C     WRITE(6,*)5+IIGLU1,ISTHKT(5+IIGLU1),IDHKT(5+IIGLU1),
C    * JMOHKT(1,5+IIGLU1),JMOHKT(2,5+IIGLU1),JDAHKT(1,5+IIGLU1),
C    *JDAHKT(2,5+IIGLU1),(PHKT(III,5+IIGLU1),III=1,5)
C     WRITE(6,*)6+IIGLU1,ISTHKT(6+IIGLU1),IDHKT(6+IIGLU1),
C    * JMOHKT(1,6+IIGLU1),JMOHKT(2,6+IIGLU1),JDAHKT(1,6+IIGLU1),
C    *JDAHKT(2,6+IIGLU1),(PHKT(III,6+IIGLU1),III=1,5)
C     ENDIF
      CHAMAL=CHAM1
      IF(IPIP.EQ.1)THEN
        IF(IP22.GE.3.OR.ISAQ1.GE.9)CHAMAL=CHAM3
      ELSEIF(IPIP.EQ.2)THEN
        IF(IP22.LE.-3.OR.ISAQ1.GE.3)CHAMAL=CHAM3
      ENDIF
      IF(PHKT(5,6+IIGLU1).LT.CHAMAL)THEN
C       IREJ=1
	IPCO=0
C	RETURN
C       WRITE(6,*)' MUSQBS1 jump back from chain 6',
C    *  CHAMAL,PHKT(5,6+IIGLU1)
	GO TO 3466
      ENDIF
      VHKT(1,6+IIGLU1)  =VHKK(1,NC1)
      VHKT(2,6+IIGLU1)  =VHKK(2,NC1)
      VHKT(3,6+IIGLU1)  =VHKK(3,NC1)
      VHKT(4,6+IIGLU1)  =VHKK(4,NC1)
      WHKT(1,6+IIGLU1)  =WHKK(1,NC1)
      WHKT(2,6+IIGLU1)  =WHKK(2,NC1)
      WHKT(3,6+IIGLU1)  =WHKK(3,NC1)
      WHKT(4,6+IIGLU1)  =WHKK(4,NC1)
C     IDHKT(7)   =1000*IPP1+100*ISQ+1
      IDHKT(7+IIGLU1)   =IP1
      ISTHKT(7+IIGLU1)  =951
      JMOHKT(1,7+IIGLU1)=NC1P
      JMOHKT(2,7+IIGLU1)=0
c*NEW
C     JDAHKT(1,7+IIGLU1)=9+IIGLU1
      JDAHKT(1,7+IIGLU1)=9+IIGLU1+IIGLU2
c*
      JDAHKT(2,7+IIGLU1)=0
      PHKT(1,7+IIGLU1)  =PHKK(1,NC1P)*XVQP/(XVQP+XSAQ1)
      PHKT(2,7+IIGLU1)  =PHKK(2,NC1P)*XVQP/(XVQP+XSAQ1)
      PHKT(3,7+IIGLU1)  =PHKK(3,NC1P)*XVQP/(XVQP+XSAQ1)
      PHKT(4,7+IIGLU1)  =PHKK(4,NC1P)*XVQP/(XVQP+XSAQ1)
C     PHKT(5,7+IIGLU1)  =PHKK(5,NC1P)
      XMIST  =(PHKT(4,7+IIGLU1)**2-
     * PHKT(3,7+IIGLU1)**2-PHKT(2,7+IIGLU1)**2-
     *PHKT(1,7+IIGLU1)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,7+IIGLU1)  =SQRT(PHKT(4,7+IIGLU1)**2-
     * PHKT(3,7+IIGLU1)**2-PHKT(2,7+IIGLU1)**2-
     *PHKT(1,7+IIGLU1)**2)
      ELSE
C     WRITE(6,*)'MUSQBS2 parton 7 mass square LT.0 ',XMIST
      PHKT(5,7+IIGLU1)=0.D0
      ENDIF
      VHKT(1,7+IIGLU1)  =VHKK(1,NC1P)
      VHKT(2,7+IIGLU1)  =VHKK(2,NC1P)
      VHKT(3,7+IIGLU1)  =VHKK(3,NC1P)
      VHKT(4,7+IIGLU1)  =VHKK(4,NC1P)
      WHKT(1,7+IIGLU1)  =WHKK(1,NC1P)
      WHKT(2,7+IIGLU1)  =WHKK(2,NC1P)
      WHKT(3,7+IIGLU1)  =WHKK(3,NC1P)
      WHKT(4,7+IIGLU1)  =WHKK(4,NC2P)
C     Insert here the IIGLU2 gluons
      PG1=0.D0
      PG2=0.D0
      PG3=0.D0
      PG4=0.D0
      IF(IIGLU2.GE.1)THEN
      JJG=NC2P
      DO 81 IIG=7+IIGLU1+1,7+IIGLU1+IIGLU2
        KKG=JJG+IIG-7-IIGLU1
        IDHKT(IIG)   =IDHKK(KKG)
        ISTHKT(IIG)  =921
        JMOHKT(1,IIG)=KKG
        JMOHKT(2,IIG)=0
        JDAHKT(1,IIG)=9+IIGLU1+IIGLU2
        JDAHKT(2,IIG)=0
        PHKT(1,IIG)=PHKK(1,KKG)
        PG1=PG1+ PHKT(1,IIG)
        PHKT(2,IIG)=PHKK(2,KKG)
        PG2=PG2+ PHKT(2,IIG)
        PHKT(3,IIG)=PHKK(3,KKG)
        PG3=PG3+ PHKT(3,IIG)
        PHKT(4,IIG)=PHKK(4,KKG)
        PG4=PG4+ PHKT(4,IIG)
        PHKT(5,IIG)=PHKK(5,KKG)
        VHKT(1,IIG)  =VHKK(1,KKG)
        VHKT(2,IIG)  =VHKK(2,KKG)
        VHKT(3,IIG)  =VHKK(3,KKG)
        VHKT(4,IIG)  =VHKK(4,KKG)
        WHKT(1,IIG)  =WHKK(1,KKG)
        WHKT(2,IIG) =WHKK(2,KKG)
        WHKT(3,IIG) =WHKK(3,KKG)
	WHKT(4,IIG) =WHKK(4,KKG)
   81 CONTINUE
      ENDIF
      IF(IPIP.EQ.1)THEN
        IDHKT(8+IIGLU1+IIGLU2)   =1000*IPP2+100*ISQ1+3
	IF(IDHKT(8+IIGLU1+IIGLU2).EQ.1203)IDHKT(8+IIGLU1+IIGLU2)=2103
	IF(IDHKT(8+IIGLU1+IIGLU2).EQ.1303)IDHKT(8+IIGLU1+IIGLU2)=3103
	IF(IDHKT(8+IIGLU1+IIGLU2).EQ.2303)IDHKT(8+IIGLU1+IIGLU2)=3203
      ELSEIF(IPIP.EQ.2)THEN
        IDHKT(8+IIGLU1+IIGLU2)   =1000*IPP2+100*(-ISQ1+6)-3
	IF(IDHKT(8+IIGLU1+IIGLU2).EQ.-1203)IDHKT(8+IIGLU1+IIGLU2)=-2103
	IF(IDHKT(8+IIGLU1+IIGLU2).EQ.-1303)IDHKT(8+IIGLU1+IIGLU2)=-3103
	IF(IDHKT(8+IIGLU1+IIGLU2).EQ.-2303)IDHKT(8+IIGLU1+IIGLU2)=-3203
      ENDIF
      ISTHKT(8+IIGLU1+IIGLU2)  =952
      JMOHKT(1,8+IIGLU1+IIGLU2)=NC2T
      JMOHKT(2,8+IIGLU1+IIGLU2)=0
      JDAHKT(1,8+IIGLU1+IIGLU2)=9+IIGLU1+IIGLU2
      JDAHKT(2,8+IIGLU1+IIGLU2)=0
      PHKT(1,8+IIGLU1+IIGLU2)  =PHKK(1,NC2T)+
     * PHKK(1,NC1T)*XSQ1/(XDIQT+XSQ1)
      PHKT(2,8+IIGLU1+IIGLU2)  =PHKK(2,NC2T)+
     * PHKK(2,NC1T)*XSQ1/(XDIQT+XSQ1)
      PHKT(3,8+IIGLU1+IIGLU2)  =PHKK(3,NC2T)+
     * PHKK(3,NC1T)*XSQ1/(XDIQT+XSQ1)
      PHKT(4,8+IIGLU1+IIGLU2)  =PHKK(4,NC2T)+
     * PHKK(4,NC1T)*XSQ1/(XDIQT+XSQ1)
C     WRITE(6,*)'PHKK(4,NC1T),PHKK(4,NC2T), PHKT(4,7)',
C    * PHKK(4,NC1T),PHKK(4,NC2T), PHKT(4,7)
      IF(PHKT(4,8+IIGLU1+IIGLU2).GE. PHKK(4,NC1T))THEN
C       IREJ=1
C	WRITE(6,*)'reject PHKT(4,8+IIGLU1+IIGLU2).GE. PHKK(4,NC1T)'
C    *  ,PHKT(4,8+IIGLU1+IIGLU2), PHKK(4,NC2T),NC2T
	IPCO=0
C	RETURN
	GO TO 3466
      ENDIF
C     PHKT(5,8)  =PHKK(5,NC2T)
      XMIST  =(PHKT(4,8+IIGLU1+IIGLU2)**2-
     * PHKT(3,8+IIGLU1+IIGLU2)**2-PHKT(2,8+IIGLU1+IIGLU2)**2-
     *PHKT(1,8+IIGLU1+IIGLU2)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,8+IIGLU1+IIGLU2)  =SQRT(PHKT(4,8+IIGLU1+IIGLU2)**2-
     * PHKT(3,8+IIGLU1+IIGLU2)**2-PHKT(2,8+IIGLU1+IIGLU2)**2-
     *PHKT(1,8+IIGLU1+IIGLU2)**2)
      ELSE
C      WRITE(6,*)' parton 4 mass square LT.0 ',XMIST
        PHKT(5,5+IIGLU1)=0.D0
      ENDIF
      VHKT(1,8+IIGLU1+IIGLU2)  =VHKK(1,NC2T)
      VHKT(2,8+IIGLU1+IIGLU2)  =VHKK(2,NC2T)
      VHKT(3,8+IIGLU1+IIGLU2)  =VHKK(3,NC2T)
      VHKT(4,8+IIGLU1+IIGLU2)  =VHKK(4,NC2T)
      WHKT(1,8+IIGLU1+IIGLU2)  =WHKK(1,NC2T)
      WHKT(2,8+IIGLU1+IIGLU2)  =WHKK(2,NC2T)
      WHKT(3,8+IIGLU1+IIGLU2)  =WHKK(3,NC2T)
      WHKT(4,8+IIGLU1+IIGLU2)  =WHKK(4,NC2T)
      IDHKT(9+IIGLU1+IIGLU2)   =88888
      ISTHKT(9+IIGLU1+IIGLU2)  =95
      JMOHKT(1,9+IIGLU1+IIGLU2)=7+IIGLU1
      JMOHKT(2,9+IIGLU1+IIGLU2)=8+IIGLU1+IIGLU2
      JDAHKT(1,9+IIGLU1+IIGLU2)=0
      JDAHKT(2,9+IIGLU1+IIGLU2)=0
c*NEW
C     PHKT(1,9+IIGLU1+IIGLU2)
C    * =PHKT(1,7+IIGLU1+IIGLU2)+PHKT(1,8+IIGLU1+IIGLU2)+PG1
C     PHKT(2,9+IIGLU1+IIGLU2)
C    * =PHKT(2,7+IIGLU1+IIGLU2)+PHKT(2,8+IIGLU1+IIGLU2)+PG2
C     PHKT(3,9+IIGLU1+IIGLU2)
C    * =PHKT(3,7+IIGLU1+IIGLU2)+PHKT(3,8+IIGLU1+IIGLU2)+PG3
C     PHKT(4,9+IIGLU1+IIGLU2)
C    * =PHKT(4,7+IIGLU1+IIGLU2)+PHKT(4,8+IIGLU1+IIGLU2)+PG4
      PHKT(1,9+IIGLU1+IIGLU2)
     * =PHKT(1,7+IIGLU1)+PHKT(1,8+IIGLU1+IIGLU2)+PG1
      PHKT(2,9+IIGLU1+IIGLU2)
     * =PHKT(2,7+IIGLU1)+PHKT(2,8+IIGLU1+IIGLU2)+PG2
      PHKT(3,9+IIGLU1+IIGLU2)
     * =PHKT(3,7+IIGLU1)+PHKT(3,8+IIGLU1+IIGLU2)+PG3
      PHKT(4,9+IIGLU1+IIGLU2)
     * =PHKT(4,7+IIGLU1)+PHKT(4,8+IIGLU1+IIGLU2)+PG4
c*
      XMIST
     * =(PHKT(4,9+IIGLU1+IIGLU2)**2-PHKT(1,9+IIGLU1+IIGLU2)**2
     * -PHKT(2,9+IIGLU1+IIGLU2)**2
     *            -PHKT(3,9+IIGLU1+IIGLU2)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,9+IIGLU1+IIGLU2)
     * =SQRT(PHKT(4,9+IIGLU1+IIGLU2)**2-PHKT(1,9+IIGLU1+IIGLU2)**2
     * -PHKT(2,9+IIGLU1+IIGLU2)**2
     *            -PHKT(3,9+IIGLU1+IIGLU2)**2)
      ELSE
C      WRITE(6,*)' parton 4 mass square LT.0 ',XMIST
        PHKT(5,5+IIGLU1)=0.D0
      ENDIF
      IF(IPIP.GE.2)THEN
C     IF(NUMEV.EQ.-324)THEN
C     WRITE(6,*)7+IIGLU1,ISTHKT(7+IIGLU1),IDHKT(7+IIGLU1),
C    * JMOHKT(1,7+IIGLU1),JMOHKT(2,7+IIGLU1),JDAHKT(1,7+IIGLU1),
C    *JDAHKT(2,7+IIGLU1),(PHKT(III,7+IIGLU1),III=1,5)
C     DO 91 IIG=7+IIGLU1+1,7+IIGLU1+IIGLU2
C     WRITE(6,*)IIG,ISTHKT(IIG),IDHKT(IIG),JMOHKT(1,IIG),JMOHKT(2,IIG),
C    * JDAHKT(1,IIG),
C    *JDAHKT(2,IIG),(PHKT(III,IIG),III=1,5)
C  91 CONTINUE
C     WRITE(6,*)8+IIGLU1+IIGLU2,ISTHKT(8+IIGLU1+IIGLU2),
C    * IDHKT(8+IIGLU1+IIGLU2),JMOHKT(1,8+IIGLU1+IIGLU2),
C    *JMOHKT(2,8+IIGLU1+IIGLU2),JDAHKT(1,8+IIGLU1+IIGLU2),
C    *JDAHKT(2,8+IIGLU1+IIGLU2),(PHKT(III,8+IIGLU1+IIGLU2),III=1,5)
C     WRITE(6,*)9+IIGLU1+IIGLU2,ISTHKT(9+IIGLU1+IIGLU2),
C    * IDHKT(9+IIGLU1+IIGLU2),JMOHKT(1,9+IIGLU1+IIGLU2),
C    *JMOHKT(2,9+IIGLU1+IIGLU2),JDAHKT(1,9+IIGLU1+IIGLU2),
C    *JDAHKT(2,9+IIGLU1+IIGLU2),(PHKT(III,9+IIGLU1+IIGLU2),III=1,5)
      ENDIF
      CHAMAL=CHAB1
      IF(IPIP.EQ.1)THEN
        IF(IP1.GE.3.OR.IPP2.GE.3.OR.ISQ1.GE.3)CHAMAL=CHAB3
      ELSEIF(IPIP.EQ.2)THEN
        IF(IP1.LE.-3.OR.IPP2.LE.-3.OR.ISQ1.GE.9)CHAMAL=CHAB3
      ENDIF
      IF(PHKT(5,9+IIGLU1+IIGLU2).LT.CHAMAL)THEN
C       IREJ=1
	IPCO=0
C	RETURN
C       WRITE(6,*)' MUSQBS1 jump back from chain 9',
C    *  'CHAMAL,PHKT(5,9+IIGLU1+IIGLU2)',CHAMAL,PHKT(5,9+IIGLU1+IIGLU2)
	GO TO 3466
      ENDIF
      VHKT(1,9+IIGLU1+IIGLU2)  =VHKK(1,NC1)
      VHKT(2,9+IIGLU1+IIGLU2)  =VHKK(2,NC1)
      VHKT(3,9+IIGLU1+IIGLU2)  =VHKK(3,NC1)
      VHKT(4,9+IIGLU1+IIGLU2)  =VHKK(4,NC1)
      WHKT(1,9+IIGLU1+IIGLU2)  =WHKK(1,NC1)
      WHKT(2,9+IIGLU1+IIGLU2)  =WHKK(2,NC1)
      WHKT(3,9+IIGLU1+IIGLU2)  =WHKK(3,NC1)
      WHKT(4,9+IIGLU1+IIGLU2)  =WHKK(4,NC1)
C
      IPCO=0
      IGCOUN=9+IIGLU1+IIGLU2
       RETURN
       END
C
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      SUBROUTINE MGSQBS2(NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,
     *              IP1,IP21,IP22,IPP11,IPP12,IPP2,IPIP,ISQ,IGCOUN)
C
C                  GSQBS-2 diagram (split target diquark)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c diquark-breaking mechanism
      COMMON /DTDIQB/ DBRKR(3,8),DBRKA(3,8),CHAM1,CHAM3,CHAB1,CHAB3


C
      PARAMETER (NTMHKK= 300)
      COMMON /HKKTMP/NHKKT,NEVHKT,ISTHKT(NTMHKK),IDHKT(NTMHKK),JMOHKT
     +(2,NTMHKK),JDAHKT(2,NTMHKK), PHKT(5,NTMHKK),VHKT(4,NTMHKK),WHKT
     +(4,NTMHKK)

cKEEP,XSEADI.
      COMMON /XSEADI/ XSEACU,UNON,UNOM,UNOSEA,CVQ,CDQ,CSEA,SSMIMA,
     +SSMIMQ,VVMTHR
cKEEP,DPRIN.
      COMMON /DPRIN/ IPRI,IPEV,IPPA,IPCO,INIT,IPHKK,ITOPD,IPAUPR
C
C                  GSQBS-2 diagram (split target diquark)
C
C
C     Input chain 1(NC1) valence-quark(NC1P)-valence-diquark(NC1T)
C     Input chain 2(NC2) valence-diquark(NC2P)-sea-quark(NC2T)
C
C     Create antiquark(aqsP)-quark(qsT) pair, energy from NC1P and NC1T
C     Split remaining valence diquark(NC1T) into quarks vq1T and vq2T
C
C     Create chains 3 valence-diquark(NC2P 1)-valence-quark(vq1T 2)
C                   6 sea-antiquark(aqsP 4)-valence-quark(vq2T 5)
C                   9 valence-quark(NC1P 7)-diquark(NC2T+qsT 8)
C
C
C
C       Put new chains into COMMON /HKKTMP/
C
      IIGLU1=NC1T-NC1P-1
      IIGLU2=NC2T-NC2P-1
      IGCOUN=0
C     WRITE(6,*)' IIGLU1,IIGLU2 ',IIGLU1,IIGLU2
      CVQ=1.D0
      IREJ=0
C     IF(IPIP.EQ.2)THEN
C     WRITE(6,*)' MGSQBS2(NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,',
C    *             'IP1,IP21,IP22,IPP11,IPP12,IPP2,IPIP,IGCOUN)',
C    *NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,
C    *              IP1,IP21,IP22,IPP11,IPP12,IPP2,IPIP,IGCOUN
C     ENDIF
C
C
C
C     determine x-values of NC1T diquark
      XDIQT=PHKK(4,NC1T)*2.D0/UMO
      XVQP=PHKK(4,NC1P)*2.D0/UMO
C
C     determine x-values of sea quark pair
C
      IPCO=1
      ICOU=0
 2234 CONTINUE
      ICOU=ICOU+1
      IF(ICOU.GE.500)THEN
        IREJ=1
        IF(ISQ.EQ.3)IREJ=3
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)' MGSQBS2 Rejection 2234 ICOU. GT.500'
        IPCO=0
        RETURN
      ENDIF
      IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'MGSQBS2 call  XSEAPA: UMO,XDIQT,XVQP ',
     * UMO, XDIQT,XVQP
      XSQ=0.D0
      XSAQ=0.D0
c*NEW
C     CALL XSEAPA(UMO,XDIQT/2.D0,ISQ,ISAQ,XSQ,XSAQ,IREJ)
      IF (IPIP.EQ.1) THEN
         XQMAX  = XDIQT/2.0D0
         XAQMAX = 2.D0*XVQP/3.0D0
      ELSE
         XQMAX  = 2.D0*XVQP/3.0D0
         XAQMAX = XDIQT/2.0D0
      ENDIF
      CALL DT_CQPAIR(XQMAX,XAQMAX,XSQ,XSAQ,ISQ,IREJ)
      ISAQ = 6+ISQ
C     write(*,*) 'MGSQBS2: ',ISQ,XSQ,XDIQT,XSAQ,XVQP
c*
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'MGSQBS2 after XSEAPA',ISQ,ISAQ,XSQ,XSAQ
      IF(IREJ.GE.1)THEN
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'MGSQBS2 reject XSEAPA',ISQ,ISAQ,XSQ,XSAQ
        IPCO=0
        RETURN
      ENDIF
      IF(IPIP.EQ.1)THEN
        IF(XSAQ.GE.2.D0*XVQP/3.D0)GO TO 2234
      ELSEIF(IPIP.EQ.2)THEN
        IF(XSQ.GE.2.D0*XVQP/3.D0)GO TO 2234
      ENDIF
      IF(IPCO.GE.3)THEN
        WRITE(ErrorOut,
     * '(A,4E12.4)')' MGSQBS2 XDIQT,XVQP,XSQ,XSAQ ',
     *	XDIQT,XVQP,XSQ,XSAQ
      ENDIF
C
C     subtract xsq,xsaq from NC1T diquark and NC1P quark
C
C     XSQ=0.D0
      IF(IPIP.EQ.1)THEN
        XDIQT=XDIQT-XSQ
        XVQP =XVQP -XSAQ
      ELSEIF(IPIP.EQ.2)THEN
        XDIQT=XDIQT-XSAQ
        XVQP =XVQP -XSQ
      ENDIF
      IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'XDIQT,XVQP after subtraction',XDIQT,XVQP
C
C     Split remaining valence diquark(NC1T) into quarks vq1T and vq2T
C
      XVTHRO=CVQ/UMO
      IVTHR=0
 3466 CONTINUE
      IF(IVTHR.EQ.10)THEN
        IREJ=1
        IF(ISQ.EQ.3)IREJ=3
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)' MGSQBS2 3466 reject IVTHR 10'
        IPCO=0
        RETURN
      ENDIF
      IVTHR=IVTHR+1
      XVTHR=XVTHRO/(201-IVTHR)
      UNOPRV=UNON
 380  CONTINUE
      IF(XVTHR.GT.0.66D0*XDIQT)THEN
        IREJ=1
        IF(ISQ.EQ.3)IREJ=3
	IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)' MGSQBS2 Rejection 380 XVTHR  large ',
     *  XVTHR
        IPCO=0
        RETURN
      ENDIF
      IF(DT_RNDM(V).LT.0.5D0)THEN
        XVTQI=DT_SAMPEX(XVTHR,0.66D0*XDIQT)
        XVTQII=XDIQT-XVTQI
      ELSE
        XVTQII=DT_SAMPEX(XVTHR,0.66D0*XDIQT)
        XVTQI=XDIQT-XVTQII
      ENDIF
      IF(IPCO.GE.3)THEN
        WRITE(ErrorOut,
     * '(A,2E12.4)')'  MGSQBS2:XVTQI,XVTQII ',XVTQI,XVTQII
      ENDIF
C
C     Prepare 4 momenta of new chains and chain ends
C
C     COMMON /HKKTMP/NHKKT,NEVHKT,ISTHKT(NTMHKK),IDHKT(NTMHKK),JMOHKT
C    +(2,NTMHKK),JDAHKT(2,NTMHKK), PHKT(5,NTMHKK),VHKT(4,NTMHKK),WHKT
C    +(4,NTMHKK)
C
C     Create chains 3 valence-diquark(NC2P 1)-valence-quark(vq1T 2)
C                   6 sea-antiquark(aqsP 4)-valence-quark(vq2T 5)
C                   9 valence-quark(NC1P 7)-diquark(NC2T+qsT 8)
C
C     SUBROUTINE MGSQBS2(NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,
C    *              IP1,IP21,IP22,IPP11,IPP12,IPP2,IGCOUN)
C
      IF(IPIP.EQ.1)THEN
        XSQ1=XSQ
        XSAQ1=XSAQ
        ISQ1=ISQ
        ISAQ1=ISAQ
      ELSEIF(IPIP.EQ.2)THEN
        XSQ1=XSAQ
        XSAQ1=XSQ
        ISQ1=ISAQ
        ISAQ1=ISQ
      ENDIF
      KK11=IP21
C     IDHKT(1)   =1000*IPP11+100*IPP12+1
      KK21=IPP11
      KK22=IPP12
      XGIVE=0.D0
      IF(IPIP.EQ.1)THEN
        IDHKT(4+IIGLU1)   =-(ISAQ1-6)
      ELSEIF(IPIP.EQ.2)THEN
        IDHKT(4+IIGLU1)   =ISAQ1
      ENDIF
      ISTHKT(4+IIGLU1)  =961
      JMOHKT(1,4+IIGLU1)=NC1P
      JMOHKT(2,4+IIGLU1)=0
      JDAHKT(1,4+IIGLU1)=6+IIGLU1
      JDAHKT(2,4+IIGLU1)=0
C     create chain    6 sea-antiquark(aqsP 4)-valence-quark(vq2T 5)
      PHKT(1,4+IIGLU1)  =PHKK(1,NC1P)*XSAQ1/(XVQP+XSAQ1)
      PHKT(2,4+IIGLU1)  =PHKK(2,NC1P)*XSAQ1/(XVQP+XSAQ1)
      PHKT(3,4+IIGLU1)  =PHKK(3,NC1P)*XSAQ1/(XVQP+XSAQ1)
      PHKT(4,4+IIGLU1)  =PHKK(4,NC1P)*XSAQ1/(XVQP+XSAQ1)
C     PHKT(5,4+IIGLU1)  =PHKK(5,NC1P)
      XXMIST=(PHKT(4,4+IIGLU1)**2-
     * PHKT(3,4+IIGLU1)**2-PHKT(2,4+IIGLU1)**2-
     *PHKT(1,4+IIGLU1)**2)
      IF(XXMIST.GT.0.D0)THEN
        PHKT(5,4+IIGLU1)  =SQRT(XXMIST)
      ELSE
        WRITE(ErrorOut,*)'MGSQBS2 XXMIST',XXMIST
        XXMIST=ABS(XXMIST)
        PHKT(5,4+IIGLU1)  =SQRT(XXMIST)
      ENDIF
      VHKT(1,4+IIGLU1)  =VHKK(1,NC1P)
      VHKT(2,4+IIGLU1)  =VHKK(2,NC1P)
      VHKT(3,4+IIGLU1)  =VHKK(3,NC1P)
      VHKT(4,4+IIGLU1)  =VHKK(4,NC1P)
      WHKT(1,4+IIGLU1)  =WHKK(1,NC1P)
      WHKT(2,4+IIGLU1)  =WHKK(2,NC1P)
      WHKT(3,4+IIGLU1)  =WHKK(3,NC1P)
      WHKT(4,4+IIGLU1)  =WHKK(4,NC1P)
      IDHKT(5+IIGLU1)   =IP22
      ISTHKT(5+IIGLU1)  =962
      JMOHKT(1,5+IIGLU1)=NC1T
      JMOHKT(2,5+IIGLU1)=0
      JDAHKT(1,5+IIGLU1)=6+IIGLU1
      JDAHKT(2,5+IIGLU1)=0
      PHKT(1,5+IIGLU1)  =PHKK(1,NC1T)*XVTQII/(XDIQT+XSQ1)
      PHKT(2,5+IIGLU1)  =PHKK(2,NC1T)*XVTQII/(XDIQT+XSQ1)
      PHKT(3,5+IIGLU1)  =PHKK(3,NC1T)*XVTQII/(XDIQT+XSQ1)
      PHKT(4,5+IIGLU1)  =PHKK(4,NC1T)*XVTQII/(XDIQT+XSQ1)
C     PHKT(5,5+IIGLU1)  =PHKK(5,NC1T)
      XXMIST=(PHKT(4,5+IIGLU1)**2-
     * PHKT(3,5+IIGLU1)**2-PHKT(2,5+IIGLU1)**2-
     *PHKT(1,5+IIGLU1)**2)
      IF(XXMIST.GT.0.D0)THEN
        PHKT(5,5+IIGLU1)  =SQRT(XXMIST)
      ELSE
        WRITE(ErrorOut,*)' MGSQBS2 XXMIST', XXMIST
        XXMIST=ABS(XXMIST)
        PHKT(5,5+IIGLU1)  =SQRT(XXMIST)
      ENDIF
      VHKT(1,5+IIGLU1)  =VHKK(1,NC1T)
      VHKT(2,5+IIGLU1)  =VHKK(2,NC1T)
      VHKT(3,5+IIGLU1)  =VHKK(3,NC1T)
      VHKT(4,5+IIGLU1)  =VHKK(4,NC1T)
      WHKT(1,5+IIGLU1)  =WHKK(1,NC1T)
      WHKT(2,5+IIGLU1)  =WHKK(2,NC1T)
      WHKT(3,5+IIGLU1)  =WHKK(3,NC1T)
      WHKT(4,5+IIGLU1)  =WHKK(4,NC1T)
      IDHKT(6+IIGLU1)   =88888
      ISTHKT(6+IIGLU1)  =96
      JMOHKT(1,6+IIGLU1)=4+IIGLU1
      JMOHKT(2,6+IIGLU1)=5+IIGLU1
      JDAHKT(1,6+IIGLU1)=0
      JDAHKT(2,6+IIGLU1)=0
      PHKT(1,6+IIGLU1)  =PHKT(1,4+IIGLU1)+PHKT(1,5+IIGLU1)
      PHKT(2,6+IIGLU1)  =PHKT(2,4+IIGLU1)+PHKT(2,5+IIGLU1)
      PHKT(3,6+IIGLU1)  =PHKT(3,4+IIGLU1)+PHKT(3,5+IIGLU1)
      PHKT(4,6+IIGLU1)  =PHKT(4,4+IIGLU1)+PHKT(4,5+IIGLU1)
      PHKT(5,6+IIGLU1)
     * =SQRT(PHKT(4,6+IIGLU1)**2-PHKT(1,6+IIGLU1)**2-PHKT(2,6+IIGLU1)**2
     *            -PHKT(3,6+IIGLU1)**2)
      CHAMAL=CHAM1
      IF(IPIP.EQ.1)THEN
        IF(IP22.GE.3.OR.ISAQ1.GE.9)CHAMAL=CHAM3
      ELSEIF(IPIP.EQ.2)THEN
        IF(IP22.LE.-3.OR.ISAQ1.GE.3)CHAMAL=CHAM3
      ENDIF
C---------------------------------------------------
      IF(PHKT(5,6+IIGLU1).LT.CHAMAL)THEN
        IF(IDHKT(5+IIGLU1).EQ.-IDHKT(4+IIGLU1))THEN
C                    we drop chain 6 and give the energy to chain 3
          IDHKT(6+IIGLU1)=22888
	  XGIVE=1.D0
C	  WRITE(6,*)' drop chain 6 xgive=1'
	  GO TO 7788
        ELSEIF(IDHKT(4+IIGLU1).EQ.-IP21)THEN
C                    we drop chain 6 and give the energy to chain 3
C                    and change KK11 to IDHKT(5)
          IDHKT(6+IIGLU1)=22888
	  XGIVE=1.D0
C	  WRITE(6,*)' drop chain 6 xgive=1 KK11=IDHKT(5)'
	  KK11=IDHKT(5+IIGLU1)
	  GO TO 7788
	ELSEIF(IDHKT(4+IIGLU1).EQ.-IPP11)THEN
C                    we drop chain 6 and give the energy to chain 3
C                    and change KK21 to IDHKT(5+IIGLU1)
C     IDHKT(1)   =1000*IPP11+100*IPP12+1
          IDHKT(6+IIGLU1)=22888
	  XGIVE=1.D0
C	  WRITE(6,*)' drop chain 6 xgive=1 KK21=IDHKT(5+IIGLU1)'
	  KK21=IDHKT(5+IIGLU1)
	  GO TO 7788
	ELSEIF(IDHKT(4+IIGLU1).EQ.-IPP12)THEN
C                    we drop chain 6 and give the energy to chain 3
C                    and change KK22 to IDHKT(5)
C     IDHKT(1)   =1000*IPP11+100*IPP12+1
          IDHKT(6+IIGLU1)=22888
	  XGIVE=1.D0
C	  WRITE(6,*)' drop chain 6 xgive=1 KK22=IDHKT(5+IIGLU1)'
	  KK22=IDHKT(5+IIGLU1)
	  GO TO 7788
	ENDIF
C       IREJ=1
	IPCO=0
C	RETURN
        GO TO 3466
      ENDIF
 7788 CONTINUE
C---------------------------------------------------
      IF(IPIP.GE.3)THEN
      WRITE(ErrorOut,
     * *)4+IIGLU1,ISTHKT(4+IIGLU1),IDHKT(4+IIGLU1),
     * JMOHKT(1,4+IIGLU1),JMOHKT(2,4+IIGLU1),JDAHKT(1,4+IIGLU1),
     *JDAHKT(2,4+IIGLU1),(PHKT(III,4+IIGLU1),III=1,5)
      WRITE(ErrorOut,
     * *)5+IIGLU1,ISTHKT(5+IIGLU1),IDHKT(5+IIGLU1),
     * JMOHKT(1,5+IIGLU1),JMOHKT(2,5+IIGLU1),JDAHKT(1,5+IIGLU1),
     *JDAHKT(2,5+IIGLU1),(PHKT(III,5+IIGLU1),III=1,5)
      WRITE(ErrorOut,
     * *)6+IIGLU1,ISTHKT(6+IIGLU1),IDHKT(6+IIGLU1),
     * JMOHKT(1,6+IIGLU1),JMOHKT(2,6+IIGLU1),JDAHKT(1,6+IIGLU1),
     *JDAHKT(2,6+IIGLU1),(PHKT(III,6+IIGLU1),III=1,5)
      ENDIF
      VHKT(1,6+IIGLU1)  =VHKK(1,NC1)
      VHKT(2,6+IIGLU1)  =VHKK(2,NC1)
      VHKT(3,6+IIGLU1)  =VHKK(3,NC1)
      VHKT(4,6+IIGLU1)  =VHKK(4,NC1)
      WHKT(1,6+IIGLU1)  =WHKK(1,NC1)
      WHKT(2,6+IIGLU1)  =WHKK(2,NC1)
      WHKT(3,6+IIGLU1)  =WHKK(3,NC1)
      WHKT(4,6+IIGLU1)  =WHKK(4,NC1)
C     IDHKT(1)   =1000*IPP11+100*IPP12+1
      IF(IPIP.EQ.1)THEN
        IDHKT(1)   =1000*KK21+100*KK22+3
	IF(IDHKT(1).EQ.1203)IDHKT(1)=2103
	IF(IDHKT(1).EQ.1303)IDHKT(1)=3103
	IF(IDHKT(1).EQ.2303)IDHKT(1)=3203
      ELSEIF(IPIP.EQ.2)THEN
        IDHKT(1)   =1000*KK21+100*KK22-3
	IF(IDHKT(1).EQ.-1203)IDHKT(1)=-2103
	IF(IDHKT(1).EQ.-1303)IDHKT(1)=-3103
	IF(IDHKT(1).EQ.-2303)IDHKT(1)=-3203
      ENDIF
      ISTHKT(1)  =961
      JMOHKT(1,1)=NC2P
      JMOHKT(2,1)=0
      JDAHKT(1,1)=3+IIGLU1
      JDAHKT(2,1)=0
C     Create chains 3 valence-diquark(NC2P 1)-valence-quark(vq1T 2)
      PHKT(1,1)  =PHKK(1,NC2P)
     *+XGIVE*PHKT(1,4+IIGLU1)
      PHKT(2,1)  =PHKK(2,NC2P)
     *+XGIVE*PHKT(2,4+IIGLU1)
      PHKT(3,1)  =PHKK(3,NC2P)
     *+XGIVE*PHKT(3,4+IIGLU1)
      PHKT(4,1)  =PHKK(4,NC2P)
     *+XGIVE*PHKT(4,4+IIGLU1)
C     PHKT(5,1)  =PHKK(5,NC2P)
      XXMIST=PHKT(4,1)**2- PHKT(3,1)**2-PHKT(2,1)**2-
     *PHKT(1,1)**2
      IF(XXMIST.GT.0.D0)THEN
        PHKT(5,1)  =SQRT(XXMIST)
      ELSE
        WRITE(ErrorOut,*)'MGSQBS2',XXMIST
        XXMIST=ABS(XXMIST)
        PHKT(5,1)  =SQRT(XXMIST)
      ENDIF
      VHKT(1,1)  =VHKK(1,NC2P)
      VHKT(2,1)  =VHKK(2,NC2P)
      VHKT(3,1)  =VHKK(3,NC2P)
      VHKT(4,1)  =VHKK(4,NC2P)
      WHKT(1,1)  =WHKK(1,NC2P)
      WHKT(2,1)  =WHKK(2,NC2P)
      WHKT(3,1)  =WHKK(3,NC2P)
      WHKT(4,1)  =WHKK(4,NC2P)
C     Add here IIGLU1 gluons to this chaina
      PG1=0.D0
      PG2=0.D0
      PG3=0.D0
      PG4=0.D0
      IF(IIGLU1.GE.1)THEN
      JJG=NC1P
      DO 61 IIG=2,2+IIGLU1-1
        KKG=JJG+IIG-1
        IDHKT(IIG)   =IDHKK(KKG)
        ISTHKT(IIG)  =921
        JMOHKT(1,IIG)=KKG
        JMOHKT(2,IIG)=0
        JDAHKT(1,IIG)=3+IIGLU1
        JDAHKT(2,IIG)=0
        PHKT(1,IIG)=PHKK(1,KKG)
        PG1=PG1+ PHKT(1,IIG)
        PHKT(2,IIG)=PHKK(2,KKG)
        PG2=PG2+ PHKT(2,IIG)
        PHKT(3,IIG)=PHKK(3,KKG)
        PG3=PG3+ PHKT(3,IIG)
        PHKT(4,IIG)=PHKK(4,KKG)
        PG4=PG4+ PHKT(4,IIG)
	PHKT(5,IIG)=PHKK(5,KKG)
        VHKT(1,IIG)  =VHKK(1,KKG)
        VHKT(2,IIG)  =VHKK(2,KKG)
        VHKT(3,IIG)  =VHKK(3,KKG)
        VHKT(4,IIG)  =VHKK(4,KKG)
        WHKT(1,IIG)  =WHKK(1,KKG)
        WHKT(2,IIG)  =WHKK(2,KKG)
        WHKT(3,IIG)  =WHKK(3,KKG)
        WHKT(4,IIG)  =WHKK(4,KKG)
   61 CONTINUE
      ENDIF
C     IDHKT(2)   =IP21
      IDHKT(2+IIGLU1)   =KK11
      ISTHKT(2+IIGLU1)  =962
      JMOHKT(1,2+IIGLU1)=NC1T
      JMOHKT(2,2+IIGLU1)=0
      JDAHKT(1,2+IIGLU1)=3+IIGLU1
      JDAHKT(2,2+IIGLU1)=0
      PHKT(1,2+IIGLU1)  =PHKK(1,NC1T)*XVTQI/(XDIQT+XSQ1)
C    * +0.5D0*PHKK(1,NC2T)
     *+XGIVE*PHKT(1,5+IIGLU1)
      PHKT(2,2+IIGLU1)  =PHKK(2,NC1T)*XVTQI/(XDIQT+XSQ1)
C    *+0.5D0*PHKK(2,NC2T)
     *+XGIVE*PHKT(2,5+IIGLU1)
      PHKT(3,2+IIGLU1)  =PHKK(3,NC1T)*XVTQI/(XDIQT+XSQ1)
C    *+0.5D0*PHKK(3,NC2T)
     *+XGIVE*PHKT(3,5+IIGLU1)
      PHKT(4,2+IIGLU1)  =PHKK(4,NC1T)*XVTQI/(XDIQT+XSQ1)
C    *+0.5D0*PHKK(4,NC2T)
     *+XGIVE*PHKT(4,5+IIGLU1)
C     PHKT(5,2)  =PHKK(5,NC1T)
      XXMIST=(PHKT(4,2+IIGLU1)**2-
     * PHKT(3,2+IIGLU1)**2-PHKT(2,2+IIGLU1)**2-
     *PHKT(1,2+IIGLU1)**2)
      IF(XXMIST.GT.0.D0)THEN
        PHKT(5,2+IIGLU1)  =SQRT(XXMIST)
      ELSE
        WRITE(ErrorOut,*)'MGSQBS2 XXMIST',XXMIST
        XXMIST=ABS(XXMIST)
        PHKT(5,2+IIGLU1)  =SQRT(XXMIST)
      ENDIF
      VHKT(1,2+IIGLU1)  =VHKK(1,NC1T)
      VHKT(2,2+IIGLU1)  =VHKK(2,NC1T)
      VHKT(3,2+IIGLU1)  =VHKK(3,NC1T)
      VHKT(4,2+IIGLU1)  =VHKK(4,NC1T)
      WHKT(1,2+IIGLU1)  =WHKK(1,NC1T)
      WHKT(2,2+IIGLU1)  =WHKK(2,NC1T)
      WHKT(3,2+IIGLU1)  =WHKK(3,NC1T)
      WHKT(4,2+IIGLU1)  =WHKK(4,NC1T)
      IDHKT(3+IIGLU1)   =88888
      ISTHKT(3+IIGLU1)  =96
      JMOHKT(1,3+IIGLU1)=1
      JMOHKT(2,3+IIGLU1)=2+IIGLU1
      JDAHKT(1,3+IIGLU1)=0
      JDAHKT(2,3+IIGLU1)=0
      PHKT(1,3+IIGLU1)  =PHKT(1,1)+PHKT(1,2+IIGLU1)+PG1
      PHKT(2,3+IIGLU1)  =PHKT(2,1)+PHKT(2,2+IIGLU1)+PG2
      PHKT(3,3+IIGLU1)  =PHKT(3,1)+PHKT(3,2+IIGLU1)+PG3
      PHKT(4,3+IIGLU1)  =PHKT(4,1)+PHKT(4,2+IIGLU1)+PG4
      PHKT(5,3+IIGLU1)
     * =SQRT(PHKT(4,3+IIGLU1)**2-PHKT(1,3+IIGLU1)**2-PHKT(2,3+IIGLU1)**2
     *            -PHKT(3,3+IIGLU1)**2)
      IF(IPIP.EQ.3)THEN
      WRITE(ErrorOut,
     * *)1,ISTHKT(1),IDHKT(1),JMOHKT(1,1),JMOHKT(2,1),
     * JDAHKT(1,1),
     *JDAHKT(2,1),(PHKT(III,1),III=1,5)
      DO 71 IIG=2,2+IIGLU1-1
      WRITE(ErrorOut,
     * *)IIG,ISTHKT(IIG),IDHKT(IIG),JMOHKT(1,IIG),JMOHKT(2,IIG),
     * JDAHKT(1,IIG),
     *JDAHKT(2,IIG),(PHKT(III,IIG),III=1,5)
   71 CONTINUE
      WRITE(ErrorOut,
     * *)2+IIGLU1,ISTHKT(2+IIGLU1),IDHKT(2+IIGLU1),
     * JMOHKT(1,2+IIGLU1),JMOHKT(2,2+IIGLU1),JDAHKT(1,2+IIGLU1),
     *JDAHKT(2,2+IIGLU1),(PHKT(III,2+IIGLU1),III=1,5)
      WRITE(ErrorOut,
     * *)3+IIGLU1,ISTHKT(3+IIGLU1),IDHKT(3+IIGLU1),
     * JMOHKT(1,3+IIGLU1),JMOHKT(2,3+IIGLU1),JDAHKT(1,3+IIGLU1),
     *JDAHKT(2,3+IIGLU1),(PHKT(III,3+IIGLU1),III=1,5)
      ENDIF
      CHAMAL=CHAB1
      IF(IPIP.EQ.1)THEN
        IF(IPP11.GE.3.OR.IPP12.GE.3.OR.IP21.GE.3)CHAMAL=CHAB3
      ELSEIF(IPIP.EQ.2)THEN
        IF(IPP11.LE.-3.OR.IPP12.LE.-3.OR.IP21.LE.-3)CHAMAL=CHAB3
      ENDIF
      IF(PHKT(5,3+IIGLU1).LT.CHAMAL)THEN
C       IREJ=1
	IPCO=0
C	RETURN
	GO TO 3466
      ENDIF
      VHKT(1,3+IIGLU1)  =VHKK(1,NC1)
      VHKT(2,3+IIGLU1)  =VHKK(2,NC1)
      VHKT(3,3+IIGLU1)  =VHKK(3,NC1)
      VHKT(4,3+IIGLU1)  =VHKK(4,NC1)
      WHKT(1,3+IIGLU1)  =WHKK(1,NC1)
      WHKT(2,3+IIGLU1)  =WHKK(2,NC1)
      WHKT(3,3+IIGLU1)  =WHKK(3,NC1)
      WHKT(4,3+IIGLU1)  =WHKK(4,NC1)
C     IDHKT(7+IIGLU1)   =1000*IPP1+100*ISQ+1
      IDHKT(7+IIGLU1)   =IP1
      ISTHKT(7+IIGLU1)  =961
      JMOHKT(1,7+IIGLU1)=NC1P
      JMOHKT(2,7+IIGLU1)=0
      JDAHKT(1,7+IIGLU1)=9+IIGLU1+IIGLU2
      JDAHKT(2,7+IIGLU1)=0
      PHKT(1,7+IIGLU1)  =PHKK(1,NC1P)*XVQP/(XVQP+XSAQ1)
      PHKT(2,7+IIGLU1)  =PHKK(2,NC1P)*XVQP/(XVQP+XSAQ1)
      PHKT(3,7+IIGLU1)  =PHKK(3,NC1P)*XVQP/(XVQP+XSAQ1)
      PHKT(4,7+IIGLU1)  =PHKK(4,NC1P)*XVQP/(XVQP+XSAQ1)
C     PHKT(5,7+IIGLU1)  =PHKK(5,NC1P)
      XXMIST=(PHKT(4,7+IIGLU1)**2-
     * PHKT(3,7+IIGLU1)**2-PHKT(2,7+IIGLU1)**2-
     *PHKT(1,7+IIGLU1)**2)
      IF(XXMIST.GT.0.D0)THEN
        PHKT(5,7+IIGLU1)  =SQRT(XXMIST)
      ELSE
        WRITE(ErrorOut,*)' MGSQBS2, XXMIST',XXMIST
        XXMIST=ABS(XXMIST)
        PHKT(5,7+IIGLU1)  =SQRT(XXMIST)
      ENDIF
      VHKT(1,7+IIGLU1)  =VHKK(1,NC1P)
      VHKT(2,7+IIGLU1)  =VHKK(2,NC1P)
      VHKT(3,7+IIGLU1)  =VHKK(3,NC1P)
      VHKT(4,7+IIGLU1)  =VHKK(4,NC1P)
      WHKT(1,7+IIGLU1)  =WHKK(1,NC1P)
      WHKT(2,7+IIGLU1)  =WHKK(2,NC1P)
      WHKT(3,7+IIGLU1)  =WHKK(3,NC1P)
      WHKT(4,7+IIGLU1)  =WHKK(4,NC2P)
C     IDHKT(7)   =1000*IPP1+100*ISQ+1
C     Insert here the IIGLU2 gluons
      PG1=0.D0
      PG2=0.D0
      PG3=0.D0
      PG4=0.D0
      IF(IIGLU2.GE.1)THEN
      JJG=NC2P
      DO 81 IIG=7+IIGLU1+1,7+IIGLU1+IIGLU2
        KKG=JJG+IIG-7-IIGLU1
        IDHKT(IIG)   =IDHKK(KKG)
        ISTHKT(IIG)  =921
        JMOHKT(1,IIG)=KKG
        JMOHKT(2,IIG)=0
        JDAHKT(1,IIG)=9+IIGLU1+IIGLU2
        JDAHKT(2,IIG)=0
        PHKT(1,IIG)=PHKK(1,KKG)
        PG1=PG1+ PHKT(1,IIG)
        PHKT(2,IIG)=PHKK(2,KKG)
        PG2=PG2+ PHKT(2,IIG)
        PHKT(3,IIG)=PHKK(3,KKG)
        PG3=PG3+ PHKT(3,IIG)
        PHKT(4,IIG)=PHKK(4,KKG)
        PG4=PG4+ PHKT(4,IIG)
	PHKT(5,IIG)=PHKK(5,KKG)
        VHKT(1,IIG)  =VHKK(1,KKG)
        VHKT(2,IIG)  =VHKK(2,KKG)
        VHKT(3,IIG)  =VHKK(3,KKG)
        VHKT(4,IIG)  =VHKK(4,KKG)
        WHKT(1,IIG)  =WHKK(1,KKG)
        WHKT(2,IIG)  =WHKK(2,KKG)
        WHKT(3,IIG)  =WHKK(3,KKG)
        WHKT(4,IIG)  =WHKK(4,KKG)
   81 CONTINUE
      ENDIF
      IF(IPIP.EQ.1)THEN
        IDHKT(8+IIGLU1+IIGLU2)   =1000*IPP2+100*ISQ1+3
	IF(IDHKT(8+IIGLU1+IIGLU2).EQ.1203)IDHKT(8+IIGLU1+IIGLU2)=2103
	IF(IDHKT(8+IIGLU1+IIGLU2).EQ.1303)IDHKT(8+IIGLU1+IIGLU2)=3103
	IF(IDHKT(8+IIGLU1+IIGLU2).EQ.2303)IDHKT(8+IIGLU1+IIGLU2)=3203
      ELSEIF(IPIP.EQ.2)THEN
c*NEW
C       IDHKT(8)   =1000*IPP2+100*(-ISQ1+6)-3
        IDHKT(8+IIGLU1+IIGLU2)   =1000*IPP2+100*(-ISQ1+6)-3
c*
	IF(IDHKT(8+IIGLU1+IIGLU2).EQ.-1203)IDHKT(8+IIGLU1+IIGLU2)=-2103
	IF(IDHKT(8+IIGLU1+IIGLU2).EQ.-1303)IDHKT(8+IIGLU1+IIGLU2)=-3103
	IF(IDHKT(8+IIGLU1+IIGLU2).EQ.-2303)IDHKT(8+IIGLU1+IIGLU2)=-3203
      ENDIF
      ISTHKT(8+IIGLU1+IIGLU2)  =962
      JMOHKT(1,8+IIGLU1+IIGLU2)=NC2T
      JMOHKT(2,8+IIGLU1+IIGLU2)=0
      JDAHKT(1,8+IIGLU1+IIGLU2)=9+IIGLU1+IIGLU2
      JDAHKT(2,8+IIGLU1+IIGLU2)=0
C     PHKT(1,8)  =0.5D0*PHKK(1,NC2T)+PHKK(1,NC1T)*XSQ/(XDIQT+XSQ)
C     PHKT(2,8)  =0.5D0*PHKK(2,NC2T)+PHKK(2,NC1T)*XSQ/(XDIQT+XSQ)
C     PHKT(3,8)  =0.5D0*PHKK(3,NC2T)+PHKK(3,NC1T)*XSQ/(XDIQT+XSQ)
C     PHKT(4,8)  =0.5D0*PHKK(4,NC2T)+PHKK(4,NC1T)*XSQ/(XDIQT+XSQ)
      PHKT(1,8+IIGLU1+IIGLU2)  =
     * PHKK(1,NC2T)+PHKK(1,NC1T)*XSQ1/(XDIQT+XSQ1)
      PHKT(2,8+IIGLU1+IIGLU2)  =
     * PHKK(2,NC2T)+PHKK(2,NC1T)*XSQ1/(XDIQT+XSQ1)
      PHKT(3,8+IIGLU1+IIGLU2)  =
     * PHKK(3,NC2T)+PHKK(3,NC1T)*XSQ1/(XDIQT+XSQ1)
      PHKT(4,8+IIGLU1+IIGLU2)  =
     * PHKK(4,NC2T)+PHKK(4,NC1T)*XSQ1/(XDIQT+XSQ1)
C     WRITE(6,*)'PHKK(4,NC1T),PHKK(4,NC2T), PHKT(4,7)',
C    * PHKK(4,NC1T),PHKK(4,NC2T), PHKT(4,7)
      IF(PHKT(4,8+IIGLU1+IIGLU2).GE. PHKK(4,NC1T))THEN
C       IREJ=1
C	WRITE(6,*)'reject PHKT(4,8+IIGLU1+IIGLU2).GE. PHKK(4,NC1T)'
	IPCO=0
C	RETURN
	GO TO 3466
      ENDIF
C     PHKT(5,8)  =PHKK(5,NC2T)
      PHKT(5,8+IIGLU1+IIGLU2)  =SQRT(PHKT(4,8+IIGLU1+IIGLU2)**2-
     * PHKT(3,8+IIGLU1+IIGLU2)**2-PHKT(2,8+IIGLU1+IIGLU2)**2-
     *PHKT(1,8+IIGLU1+IIGLU2)**2)
      VHKT(1,8+IIGLU1+IIGLU2)  =VHKK(1,NC2T)
      VHKT(2,8+IIGLU1+IIGLU2)  =VHKK(2,NC2T)
      VHKT(3,8+IIGLU1+IIGLU2)  =VHKK(3,NC2T)
      VHKT(4,8+IIGLU1+IIGLU2)  =VHKK(4,NC2T)
      WHKT(1,8+IIGLU1+IIGLU2)  =WHKK(1,NC2T)
      WHKT(2,8+IIGLU1+IIGLU2)  =WHKK(2,NC2T)
      WHKT(3,8+IIGLU1+IIGLU2)  =WHKK(3,NC2T)
      WHKT(4,8+IIGLU1+IIGLU2)  =WHKK(4,NC2T)
      IDHKT(9+IIGLU1+IIGLU2)   =88888
      ISTHKT(9+IIGLU1+IIGLU2)  =96
      JMOHKT(1,9+IIGLU1+IIGLU2)=7+IIGLU1
      JMOHKT(2,9+IIGLU1+IIGLU2)=8+IIGLU1+IIGLU2
      JDAHKT(1,9+IIGLU1+IIGLU2)=0
      JDAHKT(2,9+IIGLU1+IIGLU2)=0
      PHKT(1,9+IIGLU1+IIGLU2)
     * =PHKT(1,7+IIGLU1)+PHKT(1,8+IIGLU1+IIGLU2)+PG1
      PHKT(2,9+IIGLU1+IIGLU2)
     * =PHKT(2,7+IIGLU1)+PHKT(2,8+IIGLU1+IIGLU2)+PG2
      PHKT(3,9+IIGLU1+IIGLU2)
     * =PHKT(3,7+IIGLU1)+PHKT(3,8+IIGLU1+IIGLU2)+PG3
      PHKT(4,9+IIGLU1+IIGLU2)
     * =PHKT(4,7+IIGLU1)+PHKT(4,8+IIGLU1+IIGLU2)+PG4
      PHKT(5,9+IIGLU1+IIGLU2)
     * =SQRT(PHKT(4,9+IIGLU1+IIGLU2)**2-PHKT(1,9+IIGLU1+IIGLU2)**2-
     * PHKT(2,9+IIGLU1+IIGLU2)**2
     *            -PHKT(3,9+IIGLU1+IIGLU2)**2)
      IF(IPIP.GE.3)THEN
      WRITE(ErrorOut,
     * *)7+IIGLU1,ISTHKT(7+IIGLU1),IDHKT(7+IIGLU1),
     * JMOHKT(1,7+IIGLU1),JMOHKT(2,7+IIGLU1),JDAHKT(1,7+IIGLU1),
     *JDAHKT(2,7+IIGLU1),(PHKT(III,7+IIGLU1),III=1,5)
      DO 91 IIG=7+IIGLU1+1,7+IIGLU1+IIGLU2
      WRITE(ErrorOut,
     * *)IIG,ISTHKT(IIG),IDHKT(IIG),JMOHKT(1,IIG),JMOHKT(2,IIG),
     * JDAHKT(1,IIG),
     *JDAHKT(2,IIG),(PHKT(III,IIG),III=1,5)
   91 CONTINUE
      WRITE(ErrorOut,*)8+IIGLU1+IIGLU2,ISTHKT(8+IIGLU1+IIGLU2),
     * IDHKT(8+IIGLU1+IIGLU2),JMOHKT(1,8+IIGLU1+IIGLU2),
     *JMOHKT(2,8+IIGLU1+IIGLU2),JDAHKT(1,8+IIGLU1+IIGLU2),
     *JDAHKT(2,8+IIGLU1+IIGLU2),(PHKT(III,8+IIGLU1+IIGLU2),III=1,5)
      WRITE(ErrorOut,*)9+IIGLU1+IIGLU2,ISTHKT(9+IIGLU1+IIGLU2),
     * IDHKT(9+IIGLU1+IIGLU2),JMOHKT(1,9+IIGLU1+IIGLU2),
     *JMOHKT(2,9+IIGLU1+IIGLU2),JDAHKT(1,9+IIGLU1+IIGLU2),
     *JDAHKT(2,9+IIGLU1+IIGLU2),(PHKT(III,9+IIGLU1+IIGLU2),III=1,5)
      ENDIF
      CHAMAL=CHAB1
      IF(IPIP.EQ.1)THEN
        IF(IP1.GE.3.OR.IPP2.GE.3.OR.ISQ1.GE.3)CHAMAL=CHAB3
      ELSEIF(IPIP.EQ.2)THEN
        IF(IP1.LE.-3.OR.IPP2.LE.-3.OR.ISQ1.GE.9)CHAMAL=CHAB3
      ENDIF
      IF(PHKT(5,9+IIGLU1+IIGLU2).LT.CHAMAL)THEN
C       IREJ=1
	IPCO=0
C	RETURN
	GO TO 3466
      ENDIF
      VHKT(1,9+IIGLU1+IIGLU2)  =VHKK(1,NC1)
      VHKT(2,9+IIGLU1+IIGLU2)  =VHKK(2,NC1)
      VHKT(3,9+IIGLU1+IIGLU2)  =VHKK(3,NC1)
      VHKT(4,9+IIGLU1+IIGLU2)  =VHKK(4,NC1)
      WHKT(1,9+IIGLU1+IIGLU2)  =WHKK(1,NC1)
      WHKT(2,9+IIGLU1+IIGLU2)  =WHKK(2,NC1)
      WHKT(3,9+IIGLU1+IIGLU2)  =WHKK(3,NC1)
      WHKT(4,9+IIGLU1+IIGLU2)  =WHKK(4,NC1)
C
      IPCO=0
      IGCOUN=9+IIGLU1+IIGLU2
       RETURN
       END
C
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      SUBROUTINE MUSQBS1(NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,
     *              IP11,IP12,IP2,IPP1,IPP2,IPIP,ISQ,IGCOUN)
C
C                  USQBS-1 diagram (split projectile diquark)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c diquark-breaking mechanism
      COMMON /DTDIQB/ DBRKR(3,8),DBRKA(3,8),CHAM1,CHAM3,CHAB1,CHAB3


C
      PARAMETER (NTMHKK= 300)
      COMMON /HKKTMP/NHKKT,NEVHKT,ISTHKT(NTMHKK),IDHKT(NTMHKK),JMOHKT
     +(2,NTMHKK),JDAHKT(2,NTMHKK), PHKT(5,NTMHKK),VHKT(4,NTMHKK),WHKT
     +(4,NTMHKK)
cKEEP,XSEADI.
      COMMON /XSEADI/ XSEACU,UNON,UNOM,UNOSEA,CVQ,CDQ,CSEA,SSMIMA,
     +SSMIMQ,VVMTHR
cKEEP,DPRIN.
      COMMON /DPRIN/ IPRI,IPEV,IPPA,IPCO,INIT,IPHKK,ITOPD,IPAUPR
      COMMON /EVFLAG/ NUMEV
C
C                  USQBS-1 diagram (split projectile diquark)
C
C     Input chain 1(NC1) valence-diquark(NC1P)-valence-quark(NC1T)
C     Input chain 2(NC2) sea-quark(NC2P)-sea-antiquark(NC2T)
C
C     Create quark(qsP)-antiquark(aqsT) pair, energy from NC1P and NC1T
C     Split remaining valence diquark(NC1P) into quarks vq1P and vq2P
C
C     Create chains 3 valence quark(vq1P 1)-sea-antiquark(NC2T 2)
C                   6 valence quark(vq2P 4)-sea-quark(aqsT 5)
C                   9 diquark(qsP+NC2P 7)-valence quark(NC1T 8)
C
C       Put new chains into COMMON /HKKTMP/
C
      IIGLU1=NC1T-NC1P-1
      IIGLU2=NC2T-NC2P-1
      IGCOUN=0
C     WRITE(6,*)'MUSQBS1: IIGLU1,IIGLU2,IPIP ',IIGLU1,IIGLU2,IPIP
      CVQ=1.D0
      IREJ=0
      IF(IPIP.EQ.3)THEN
C     IF(NUMEV.EQ.-324)THEN
      WRITE(ErrorOut,
     * *)' MUSQBS1(NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,',
     *             ' IP11,IP12,IP2,IPP1,IPP2,IPIP,IGCOUN)',
     *NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,
     *              IP11,IP12,IP2,IPP1,IPP2,IPIP,IGCOUN
      ENDIF
C
C
C
C     determine x-values of NC1P diquark
      XDIQP=PHKK(4,NC1P)*2.D0/UMO
      XVQT=PHKK(4,NC1T)*2.D0/UMO
C
C     determine x-values of sea quark pair
C
      IPCO=1
      ICOU=0
 2234 CONTINUE
      ICOU=ICOU+1
      IF(ICOU.GE.500)THEN
        IREJ=1
        IF(ISQ.EQ.3)IREJ=3
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)' MUSQBS1 Rejection 2234 ICOU. GT.100'
        IPCO=0
        RETURN
      ENDIF
      IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'MUSQBS1 call  XSEAPA: UMO,XDIQP,XVQT ',
     * UMO, XDIQP,XVQT
      XSQ=0.D0
      XSAQ=0.D0
c*NEW
C     CALL XSEAPA(UMO,XDIQP/2.D0,ISQ,ISAQ,XSQ,XSAQ,IREJ)
      IF (IPIP.EQ.1) THEN
         XQMAX  = XDIQP/2.0D0
         XAQMAX = 2.D0*XVQT/3.0D0
      ELSE
         XQMAX  = 2.D0*XVQT/3.0D0
         XAQMAX = XDIQP/2.0D0
      ENDIF
      CALL DT_CQPAIR(XQMAX,XAQMAX,XSQ,XSAQ,ISQ,IREJ)
      ISAQ = 6+ISQ
C     write(*,*) 'MUSQBS1: ',ISQ,XSQ,XDIQP,XSAQ,XVQT
c*
      IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'MUSQBS1 after XSEAPA',ISQ,ISAQ,XSQ,XSAQ
      IF(IREJ.GE.1)THEN
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'MUSQBS1 reject XSEAPA',ISQ,ISAQ,XSQ,XSAQ
        IPCO=0
        RETURN
      ENDIF
      IF(IPIP.EQ.1)THEN
        IF(XSAQ.GE.2.D0*XVQT/3.D0)GO TO 2234
      ELSEIF(IPIP.EQ.2)THEN
        IF(XSQ.GE.2.D0*XVQT/3.D0)GO TO 2234
      ENDIF
      IF(IPCO.GE.3)THEN
        WRITE(ErrorOut,
     * '(A,4E12.4)')' MUSQBS1 XDIQP,XVQT,XSQ,XSAQ ',
     *	XDIQP,XVQT,XSQ,XSAQ
      ENDIF
C
C     subtract xsq,xsaq from NC1P diquark and NC1T quark
C
C     XSQ=0.D0
      IF(IPIP.EQ.1)THEN
        XDIQP=XDIQP-XSQ
        XVQT =XVQT -XSAQ
      ELSEIF(IPIP.EQ.2)THEN
        XDIQP=XDIQP-XSAQ
        XVQT =XVQT -XSQ
      ENDIF
      IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'XDIQP,XVQT after subtraction',XDIQP,XVQT
C
C     Split remaining valence diquark(NC1P) into quarks vq1P and vq2P
C
      XVTHRO=CVQ/UMO
      IVTHR=0
 3466 CONTINUE
      IF(IVTHR.EQ.10)THEN
        IREJ=1
        IF(ISQ.EQ.3)IREJ=3
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)' MUSQBS1 3466 reject IVTHR 10'
        IPCO=0
        RETURN
      ENDIF
      IVTHR=IVTHR+1
      XVTHR=XVTHRO/(201-IVTHR)
      UNOPRV=UNON
 380  CONTINUE
      IF(XVTHR.GT.0.66D0*XDIQP)THEN
        IREJ=1
        IF(ISQ.EQ.3)IREJ=3
	IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)' MUSQBS1 Rejection 380 XVTHR  large ',
     *  XVTHR
        IPCO=0
        RETURN
      ENDIF
      IF(DT_RNDM(V).LT.0.5D0)THEN
        XVPQI=DT_SAMPEX(XVTHR,0.66D0*XDIQP)
        XVPQII=XDIQP-XVPQI
      ELSE
        XVPQII=DT_SAMPEX(XVTHR,0.66D0*XDIQP)
        XVPQI=XDIQP-XVPQII
      ENDIF
      IF(IPCO.GE.3)THEN
        WRITE(ErrorOut,
     * '(A,2E12.4)')'  MUSQBS1:XVPQI,XVPQII ',XVPQI,XVPQII
      ENDIF
C
C     Prepare 4 momenta of new chains and chain ends
C
C     COMMON /HKKTMP/NHKKT,NEVHKT,ISTHKT(NTMHKK),IDHKT(NTMHKK),JMOHKT
C    +(2,NTMHKK),JDAHKT(2,NTMHKK), PHKT(5,NTMHKK),VHKT(4,NTMHKK),WHKT
C    +(4,NTMHKK)
C     Create chains 3 valence quark(vq1P 1)-sea-antiquark(NC2T 2)
C                   6 valence quark(vq2P 4)-sea-quark(aqsT 5)
C                   9 diquark(qsP+NC2P 7)-valence quark(NC1T 8)
      IF(IPIP.EQ.1)THEN
        XSQ1=XSQ
        XSAQ1=XSAQ
        ISQ1=ISQ
        ISAQ1=ISAQ
      ELSEIF(IPIP.EQ.2)THEN
        XSQ1=XSAQ
        XSAQ1=XSQ
        ISQ1=ISAQ
        ISAQ1=ISQ
      ENDIF
      IDHKT(1)   =IP11
      ISTHKT(1)  =931
      JMOHKT(1,1)=NC1P
      JMOHKT(2,1)=0
      JDAHKT(1,1)=3+IIGLU1
      JDAHKT(2,1)=0
C     Create chains 3 valence quark(vq1P 1)-sea-antiquark(NC2T 2)
      PHKT(1,1)  =PHKK(1,NC1P)*XVPQI/(XDIQP+XSQ1)
      PHKT(2,1)  =PHKK(2,NC1P)*XVPQI/(XDIQP+XSQ1)
      PHKT(3,1)  =PHKK(3,NC1P)*XVPQI/(XDIQP+XSQ1)
      PHKT(4,1)  =PHKK(4,NC1P)*XVPQI/(XDIQP+XSQ1)
C     PHKT(5,1)  =PHKK(5,NC1P)
      XMIST  =(PHKT(4,1)**2- PHKT(3,1)**2-PHKT(2,1)**2-
     *PHKT(1,1)**2)
      IF(XMIST.GE.0.D0)THEN
      PHKT(5,1)  =SQRT(PHKT(4,1)**2- PHKT(3,1)**2-PHKT(2,1)**2-
     *PHKT(1,1)**2)
      ELSE
C      WRITE(6,*)'MUSQBS1 parton 1 mass square LT.0 ',XMIST
       PHKT(5,1)=0.D0
      ENDIF
      VHKT(1,1)  =VHKK(1,NC1P)
      VHKT(2,1)  =VHKK(2,NC1P)
      VHKT(3,1)  =VHKK(3,NC1P)
      VHKT(4,1)  =VHKK(4,NC1P)
      WHKT(1,1)  =WHKK(1,NC1P)
      WHKT(2,1)  =WHKK(2,NC1P)
      WHKT(3,1)  =WHKK(3,NC1P)
      WHKT(4,1)  =WHKK(4,NC1P)
C     Add here IIGLU1 gluons to this chaina
      PG1=0.D0
      PG2=0.D0
      PG3=0.D0
      PG4=0.D0
      IF(IIGLU1.GE.1)THEN
      JJG=NC1P
      DO 61 IIG=2,2+IIGLU1-1
        KKG=JJG+IIG-1
        IDHKT(IIG)   =IDHKK(KKG)
        ISTHKT(IIG)  =921
        JMOHKT(1,IIG)=KKG
        JMOHKT(2,IIG)=0
        JDAHKT(1,IIG)=3+IIGLU1
        JDAHKT(2,IIG)=0
        PHKT(1,IIG)=PHKK(1,KKG)
        PG1=PG1+ PHKT(1,IIG)
        PHKT(2,IIG)=PHKK(2,KKG)
        PG2=PG2+ PHKT(2,IIG)
        PHKT(3,IIG)=PHKK(3,KKG)
        PG3=PG3+ PHKT(3,IIG)
	PHKT(4,IIG)=PHKK(4,KKG)
	PG4=PG4+ PHKT(4,IIG)
        PHKT(5,IIG)=PHKK(5,KKG)
        VHKT(1,IIG)  =VHKK(1,KKG)
        VHKT(2,IIG)  =VHKK(2,KKG)
        VHKT(3,IIG)  =VHKK(3,KKG)
        VHKT(4,IIG)  =VHKK(4,KKG)
        WHKT(1,IIG) =WHKK(1,KKG)
	WHKT(2,IIG) =WHKK(2,KKG)
	WHKT(3,IIG) =WHKK(3,KKG)
	WHKT(4,IIG) =WHKK(4,KKG)
   61 CONTINUE
      ENDIF
      IDHKT(2+IIGLU1)   =IPP2
      ISTHKT(2+IIGLU1)  =932
      JMOHKT(1,2+IIGLU1)=NC2T
      JMOHKT(2,2+IIGLU1)=0
      JDAHKT(1,2+IIGLU1)=3+IIGLU1
      JDAHKT(2,2+IIGLU1)=0
      PHKT(1,2+IIGLU1)  =PHKK(1,NC2T)
      PHKT(2,2+IIGLU1)  =PHKK(2,NC2T)
      PHKT(3,2+IIGLU1)  =PHKK(3,NC2T)
      PHKT(4,2+IIGLU1)  =PHKK(4,NC2T)
C     PHKT(5,2+IIGLU1)  =PHKK(5,NC2T)
      XMIST=(PHKT(4,2+IIGLU1)**2-
     * PHKT(3,2+IIGLU1)**2-PHKT(2,2+IIGLU1)**2-
     *PHKT(1,2+IIGLU1)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,2+IIGLU1)  =SQRT(PHKT(4,2+IIGLU1)**2-
     * PHKT(3,2+IIGLU1)**2-PHKT(2,2+IIGLU1)**2-
     *PHKT(1,2+IIGLU1)**2)
      ELSE
C      WRITE(6,*)' parton 4 mass square LT.0 ',XMIST
        PHKT(5,2+IIGLU1)=0.D0
      ENDIF
      VHKT(1,2+IIGLU1)  =VHKK(1,NC2T)
      VHKT(2,2+IIGLU1)  =VHKK(2,NC2T)
      VHKT(3,2+IIGLU1)  =VHKK(3,NC2T)
      VHKT(4,2+IIGLU1)  =VHKK(4,NC2T)
      WHKT(1,2+IIGLU1)  =WHKK(1,NC2T)
      WHKT(2,2+IIGLU1)  =WHKK(2,NC2T)
      WHKT(3,2+IIGLU1)  =WHKK(3,NC2T)
      WHKT(4,2+IIGLU1)  =WHKK(4,NC2T)
      IDHKT(3+IIGLU1)   =88888
      ISTHKT(3+IIGLU1)  =94
      JMOHKT(1,3+IIGLU1)=1
      JMOHKT(2,3+IIGLU1)=2+IIGLU1
      JDAHKT(1,3+IIGLU1)=0
      JDAHKT(2,3+IIGLU1)=0
      PHKT(1,3+IIGLU1)  =PHKT(1,1)+PHKT(1,2+IIGLU1)+PG1
      PHKT(2,3+IIGLU1)  =PHKT(2,1)+PHKT(2,2+IIGLU1)+PG2
      PHKT(3,3+IIGLU1)  =PHKT(3,1)+PHKT(3,2+IIGLU1)+PG3
      PHKT(4,3+IIGLU1)  =PHKT(4,1)+PHKT(4,2+IIGLU1)+PG4
      XMIST
     * =(PHKT(4,3+IIGLU1)**2-PHKT(1,3+IIGLU1)**2-PHKT(2,3+IIGLU1)**2
     *            -PHKT(3,3+IIGLU1)**2)
      IF(XMIST.GE.0.D0)THEN
      PHKT(5,3+IIGLU1)
     * =SQRT(PHKT(4,3+IIGLU1)**2-PHKT(1,3+IIGLU1)**2-PHKT(2,3+IIGLU1)**2
     *            -PHKT(3,3+IIGLU1)**2)
      ELSE
C      WRITE(6,*)'MUSQBS1 parton 1 mass square LT.0 ',XMIST
       PHKT(5,1)=0.D0
      ENDIF
      IF(IPIP.GE.3)THEN
C     IF(NUMEV.EQ.-324)THEN
      WRITE(ErrorOut,*)1,ISTHKT(1),IDHKT(1),JMOHKT(1,1),
     * JMOHKT(2,1),JDAHKT(1,1),
     *JDAHKT(2,1),(PHKT(III,1),III=1,5)
      DO 71 IIG=2,2+IIGLU1-1
      WRITE(ErrorOut,
     * *)IIG,ISTHKT(IIG),IDHKT(IIG),JMOHKT(1,IIG),JMOHKT(2,IIG),
     * JDAHKT(1,IIG),
     *JDAHKT(2,IIG),(PHKT(III,IIG),III=1,5)
   71 CONTINUE
      WRITE(ErrorOut,
     * *)2+IIGLU1,ISTHKT(2+IIGLU1),IDHKT(2+IIGLU1),
     * JMOHKT(1,2+IIGLU1),JMOHKT(2,2+IIGLU1),JDAHKT(1,2+IIGLU1),
     *JDAHKT(2,2+IIGLU1),(PHKT(III,2+IIGLU1),III=1,5)
      WRITE(ErrorOut,
     * *)3+IIGLU1,ISTHKT(3+IIGLU1),IDHKT(3+IIGLU1),
     * JMOHKT(1,3+IIGLU1),JMOHKT(2,3+IIGLU1),JDAHKT(1,3+IIGLU1),
     *JDAHKT(2,3+IIGLU1),(PHKT(III,3+IIGLU1),III=1,5)
      ENDIF
      CHAMAL=CHAM1
      IF(IPIP.EQ.1)THEN
        IF(IP11.GE.3.OR.IPP2.GE.3)CHAMAL=CHAM3
      ELSEIF(IPIP.EQ.2)THEN
        IF(IP11.LE.-3.OR.IPP2.LE.-3)CHAMAL=CHAM3
      ENDIF
      IF(PHKT(5,3+IIGLU1).LT.CHAMAL)THEN
C       IREJ=1
	IPCO=0
C	RETURN
C       WRITE(6,*)' MUSQBS1 jump back from chain 3'
	GO TO 3466
      ENDIF
      VHKT(1,3+IIGLU1)  =VHKK(1,NC1)
      VHKT(2,3+IIGLU1)  =VHKK(2,NC1)
      VHKT(3,3+IIGLU1)  =VHKK(3,NC1)
      VHKT(4,3+IIGLU1)  =VHKK(4,NC1)
      WHKT(1,3+IIGLU1)  =WHKK(1,NC1)
      WHKT(2,3+IIGLU1)  =WHKK(2,NC1)
      WHKT(3,3+IIGLU1)  =WHKK(3,NC1)
      WHKT(4,3+IIGLU1)  =WHKK(4,NC1)
      IDHKT(4+IIGLU1)   =IP12
      ISTHKT(4+IIGLU1)  =931
      JMOHKT(1,4+IIGLU1)=NC1P
      JMOHKT(2,4+IIGLU1)=0
      JDAHKT(1,4+IIGLU1)=6+IIGLU1
      JDAHKT(2,4+IIGLU1)=0
C   create  chain   6 valence quark(vq2P 4)-sea-quark(aqsT 5)
      PHKT(1,4+IIGLU1)  =PHKK(1,NC1P)*XVPQII/(XDIQP+XSQ1)
      PHKT(2,4+IIGLU1)  =PHKK(2,NC1P)*XVPQII/(XDIQP+XSQ1)
      PHKT(3,4+IIGLU1)  =PHKK(3,NC1P)*XVPQII/(XDIQP+XSQ1)
      PHKT(4,4+IIGLU1)  =PHKK(4,NC1P)*XVPQII/(XDIQP+XSQ1)
C     PHKT(5,4+IIGLU1)  =PHKK(5,NC1P)
      XMIST  =(PHKT(4,4+IIGLU1)**2-
     * PHKT(3,4+IIGLU1)**2-PHKT(2,4+IIGLU1)**2-
     *PHKT(1,4+IIGLU1)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,4+IIGLU1)  =SQRT(PHKT(4,4+IIGLU1)**2-
     * PHKT(3,4+IIGLU1)**2-PHKT(2,4+IIGLU1)**2-
     *PHKT(1,4+IIGLU1)**2)
      ELSE
C      WRITE(6,*)' parton 4 mass square LT.0 ',XMIST
        PHKT(5,4+IIGLU1)=0.D0
      ENDIF
      VHKT(1,4+IIGLU1)  =VHKK(1,NC1P)
      VHKT(2,4+IIGLU1)  =VHKK(2,NC1P)
      VHKT(3,4+IIGLU1)  =VHKK(3,NC1P)
      VHKT(4,4+IIGLU1)  =VHKK(4,NC1P)
      WHKT(1,4+IIGLU1)  =WHKK(1,NC1P)
      WHKT(2,4+IIGLU1)  =WHKK(2,NC1P)
      WHKT(3,4+IIGLU1)  =WHKK(3,NC1P)
      WHKT(4,4+IIGLU1)  =WHKK(4,NC1P)
      IF(IPIP.EQ.1)THEN
        IDHKT(5+IIGLU1)   =-(ISAQ1-6)
      ELSEIF(IPIP.EQ.2)THEN
        IDHKT(5+IIGLU1)   =ISAQ1
      ENDIF
      ISTHKT(5+IIGLU1)  =932
      JMOHKT(1,5+IIGLU1)=NC1T
      JMOHKT(2,5+IIGLU1)=0
      JDAHKT(1,5+IIGLU1)=6+IIGLU1
      JDAHKT(2,5+IIGLU1)=0
      PHKT(1,5+IIGLU1)  =PHKK(1,NC1T)*XSAQ1/(XVQT+XSAQ1)
      PHKT(2,5+IIGLU1)  =PHKK(2,NC1T)*XSAQ1/(XVQT+XSAQ1)
      PHKT(3,5+IIGLU1)  =PHKK(3,NC1T)*XSAQ1/(XVQT+XSAQ1)
      PHKT(4,5+IIGLU1)  =PHKK(4,NC1T)*XSAQ1/(XVQT+XSAQ1)
C     IF( PHKT(4,5).EQ.0.D0)THEN
C       IREJ=1
CIPCO=0
CRETURN
C     ENDIF
C     PHKT(5,5)  =PHKK(5,NC1T)
      XMIST=(PHKT(4,5+IIGLU1)**2-
     * PHKT(3,5+IIGLU1)**2-PHKT(2,5+IIGLU1)**2-
     *PHKT(1,5+IIGLU1)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,5+IIGLU1)  =SQRT(PHKT(4,5+IIGLU1)**2-
     * PHKT(3,5+IIGLU1)**2-PHKT(2,5+IIGLU1)**2-
     *PHKT(1,5+IIGLU1)**2)
      ELSE
C      WRITE(6,*)' parton 4 mass square LT.0 ',XMIST
        PHKT(5,5+IIGLU1)=0.D0
      ENDIF
      VHKT(1,5+IIGLU1)  =VHKK(1,NC1T)
      VHKT(2,5+IIGLU1)  =VHKK(2,NC1T)
      VHKT(3,5+IIGLU1)  =VHKK(3,NC1T)
      VHKT(4,5+IIGLU1)  =VHKK(4,NC1T)
      WHKT(1,5+IIGLU1)  =WHKK(1,NC1T)
      WHKT(2,5+IIGLU1)  =WHKK(2,NC1T)
      WHKT(3,5+IIGLU1)  =WHKK(3,NC1T)
      WHKT(4,5+IIGLU1)  =WHKK(4,NC1T)
      IDHKT(6+IIGLU1)   =88888
      ISTHKT(6+IIGLU1)  =94
      JMOHKT(1,6+IIGLU1)=4+IIGLU1
      JMOHKT(2,6+IIGLU1)=5+IIGLU1
      JDAHKT(1,6+IIGLU1)=0
      JDAHKT(2,6+IIGLU1)=0
      PHKT(1,6+IIGLU1)  =PHKT(1,4+IIGLU1)+PHKT(1,5+IIGLU1)
      PHKT(2,6+IIGLU1)  =PHKT(2,4+IIGLU1)+PHKT(2,5+IIGLU1)
      PHKT(3,6+IIGLU1)  =PHKT(3,4+IIGLU1)+PHKT(3,5+IIGLU1)
      PHKT(4,6+IIGLU1)  =PHKT(4,4+IIGLU1)+PHKT(4,5+IIGLU1)
      XMIST
     * =(PHKT(4,6+IIGLU1)**2-PHKT(1,6+IIGLU1)**2-PHKT(2,6+IIGLU1)**2
     *            -PHKT(3,6+IIGLU1)**2)
      IF(XMIST.GE.0.D0)THEN
      PHKT(5,6+IIGLU1)
     * =SQRT(PHKT(4,6+IIGLU1)**2-PHKT(1,6+IIGLU1)**2-PHKT(2,6+IIGLU1)**2
     *            -PHKT(3,6+IIGLU1)**2)
      ELSE
C      WRITE(6,*)'MUSQBS1 parton 1 mass square LT.0 ',XMIST
       PHKT(5,1)=0.D0
      ENDIF
C     IF(IPIP.EQ.3)THEN
      CHAMAL=CHAM1
      IF(IPIP.EQ.1)THEN
        IF(IP12.GE.3.OR.ISAQ1.GE.9)CHAMAL=CHAM3
      ELSEIF(IPIP.EQ.2)THEN
        IF(IP12.LE.-3.OR.ISAQ1.GE.3)CHAMAL=CHAM3
      ENDIF
      IF(PHKT(5,6+IIGLU1).LT.CHAMAL)THEN
C       IREJ=1
	IPCO=0
C	RETURN
C       WRITE(6,*)' MGSQBS1 jump back from chain 6',
C    *	CHAMAL,PHKT(5,6+IIGLU1)
	GO TO 3466
      ENDIF
      IF(IPIP.GE.3)THEN
C     IF(NUMEV.EQ.-324)THEN
      WRITE(ErrorOut,
     * *)4+IIGLU1,ISTHKT(4+IIGLU1),IDHKT(4+IIGLU1),
     * JMOHKT(1,4+IIGLU1),JMOHKT(2,4+IIGLU1),JDAHKT(1,4+IIGLU1),
     *JDAHKT(2,4+IIGLU1),(PHKT(III,4+IIGLU1),III=1,5)
      WRITE(ErrorOut,
     * *)5+IIGLU1,ISTHKT(5+IIGLU1),IDHKT(5+IIGLU1),
     * JMOHKT(1,5+IIGLU1),JMOHKT(2,5+IIGLU1),JDAHKT(1,5+IIGLU1),
     *JDAHKT(2,5+IIGLU1),(PHKT(III,5+IIGLU1),III=1,5)
      WRITE(ErrorOut,
     * *)6+IIGLU1,ISTHKT(6+IIGLU1),IDHKT(6+IIGLU1),
     * JMOHKT(1,6+IIGLU1),JMOHKT(2,6+IIGLU1),JDAHKT(1,6+IIGLU1),
     *JDAHKT(2,6+IIGLU1),(PHKT(III,6+IIGLU1),III=1,5)
      ENDIF
      VHKT(1,6+IIGLU1)  =VHKK(1,NC1)
      VHKT(2,6+IIGLU1)  =VHKK(2,NC1)
      VHKT(3,6+IIGLU1)  =VHKK(3,NC1)
      VHKT(4,6+IIGLU1)  =VHKK(4,NC1)
      WHKT(1,6+IIGLU1)  =WHKK(1,NC1)
      WHKT(2,6+IIGLU1)  =WHKK(2,NC1)
      WHKT(3,6+IIGLU1)  =WHKK(3,NC1)
      WHKT(4,6+IIGLU1)  =WHKK(4,NC1)
      IF(IPIP.EQ.1)THEN
        IDHKT(7+IIGLU1)   =1000*IPP1+100*ISQ+3
	IF(IDHKT(7+IIGLU1).EQ.1203)IDHKT(7+IIGLU1)=2103
	IF(IDHKT(7+IIGLU1).EQ.1303)IDHKT(7+IIGLU1)=3103
	IF(IDHKT(7+IIGLU1).EQ.2303)IDHKT(7+IIGLU1)=3203
      ELSEIF(IPIP.EQ.2)THEN
        IDHKT(7+IIGLU1)   =1000*IPP1+100*(-ISQ1+6)-3
	IF(IDHKT(7+IIGLU1).EQ.-1203)IDHKT(7+IIGLU1)=-2103
	IF(IDHKT(7+IIGLU1).EQ.-1303)IDHKT(7+IIGLU1)=-3103
	IF(IDHKT(7+IIGLU1).EQ.-2303)IDHKT(7+IIGLU1)=-3203
C       WRITE(6,*)'IDHKT(7+IIGLU1),IPP1,ISQ1',IDHKT(7+IIGLU1),IPP1,ISQ1
      ENDIF
      ISTHKT(7+IIGLU1)  =931
      JMOHKT(1,7+IIGLU1)=NC2P
      JMOHKT(2,7+IIGLU1)=0
      JDAHKT(1,7+IIGLU1)=9+IIGLU1+IIGLU2
      JDAHKT(2,7+IIGLU1)=0
C    create chain     9 diquark(qsP+NC2P 7)-valence quark(NC1T 8)
      PHKT(1,7+IIGLU1)  =PHKK(1,NC2P)+PHKK(1,NC1P)*XSQ1/(XDIQP+XSQ1)
      PHKT(2,7+IIGLU1)  =PHKK(2,NC2P)+PHKK(2,NC1P)*XSQ1/(XDIQP+XSQ1)
      PHKT(3,7+IIGLU1)  =PHKK(3,NC2P)+PHKK(3,NC1P)*XSQ1/(XDIQP+XSQ1)
      PHKT(4,7+IIGLU1)  =PHKK(4,NC2P)+PHKK(4,NC1P)*XSQ1/(XDIQP+XSQ1)
C     WRITE(6,*)'PHKK(4,NC1P),PHKK(4,NC2P), PHKT(4,7)',
C    * PHKK(4,NC1P),PHKK(4,NC2P), PHKT(4,7)
      IF(PHKT(4,7+IIGLU1).GE. PHKK(4,NC1P))THEN
C       IREJ=1
C	WRITE(6,*)'reject PHKT(4,7+IIGLU1).GE. PHKK(4,NC1P)'
	IPCO=0
C	RETURN
	GO TO 3466
      ENDIF
C     PHKT(5,7)  =PHKK(5,NC2P)
      PHKT(5,7+IIGLU1)  =SQRT(PHKT(4,7+IIGLU1)**2-
     * PHKT(3,7+IIGLU1)**2-PHKT(2,7+IIGLU1)**2-
     *PHKT(1,7+IIGLU1)**2)
      VHKT(1,7+IIGLU1)  =VHKK(1,NC2P)
      VHKT(2,7+IIGLU1)  =VHKK(2,NC2P)
      VHKT(3,7+IIGLU1)  =VHKK(3,NC2P)
      VHKT(4,7+IIGLU1)  =VHKK(4,NC2P)
      WHKT(1,7+IIGLU1)  =WHKK(1,NC2P)
      WHKT(2,7+IIGLU1)  =WHKK(2,NC2P)
      WHKT(3,7+IIGLU1)  =WHKK(3,NC2P)
      WHKT(4,7+IIGLU1)  =WHKK(4,NC2P)
C     Insert here the IIGLU2 gluons
      PG1=0.D0
      PG2=0.D0
      PG3=0.D0
      PG4=0.D0
      IF(IIGLU2.GE.1)THEN
      JJG=NC2P
      DO 81 IIG=7+IIGLU1+1,7+IIGLU1+IIGLU2
        KKG=JJG+IIG-7-IIGLU1
        IDHKT(IIG)   =IDHKK(KKG)
        ISTHKT(IIG)  =921
        JMOHKT(1,IIG)=KKG
        JMOHKT(2,IIG)=0
        JDAHKT(1,IIG)=9+IIGLU1+IIGLU2
        JDAHKT(2,IIG)=0
        PHKT(1,IIG)=PHKK(1,KKG)
        PG1=PG1+ PHKT(1,IIG)
        PHKT(2,IIG)=PHKK(2,KKG)
        PG2=PG2+ PHKT(2,IIG)
        PHKT(3,IIG)=PHKK(3,KKG)
        PG3=PG3+ PHKT(3,IIG)
        PHKT(4,IIG)=PHKK(4,KKG)
        PG4=PG4+ PHKT(4,IIG)
	PHKT(5,IIG)=PHKK(5,KKG)
        VHKT(1,IIG)  =VHKK(1,KKG)
        VHKT(2,IIG)  =VHKK(2,KKG)
        VHKT(3,IIG)  =VHKK(3,KKG)
        VHKT(4,IIG)  =VHKK(4,KKG)
        WHKT(1,IIG)  =WHKK(1,KKG)
        WHKT(2,IIG) =WHKK(2,KKG)
	WHKT(3,IIG) =WHKK(3,KKG)
	WHKT(4,IIG) =WHKK(4,KKG)
   81 CONTINUE
      ENDIF
      IDHKT(8+IIGLU1+IIGLU2)   =IP2
      ISTHKT(8+IIGLU1+IIGLU2)  =932
      JMOHKT(1,8+IIGLU1+IIGLU2)=NC1T
      JMOHKT(2,8+IIGLU1+IIGLU2)=0
      JDAHKT(1,8+IIGLU1+IIGLU2)=9+IIGLU1+IIGLU2
      JDAHKT(2,8+IIGLU1+IIGLU2)=0
      PHKT(1,8+IIGLU1+IIGLU2)  =PHKK(1,NC1T)*XVQT/(XSAQ1+XVQT)
      PHKT(2,8+IIGLU1+IIGLU2)  =PHKK(2,NC1T)*XVQT/(XSAQ1+XVQT)
      PHKT(3,8+IIGLU1+IIGLU2)  =PHKK(3,NC1T)*XVQT/(XSAQ1+XVQT)
      PHKT(4,8+IIGLU1+IIGLU2)  =PHKK(4,NC1T)*XVQT/(XSAQ1+XVQT)
C     PHKT(5,8+IIGLU1+IIGLU2)  =PHKK(5,NC1T)
      XMIST=(PHKT(4,8+IIGLU1+IIGLU2)**2-
     * PHKT(3,8+IIGLU1+IIGLU2)**2-PHKT(2,8+IIGLU1+IIGLU2)**2-
     *PHKT(1,8+IIGLU1+IIGLU2)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,8+IIGLU1+IIGLU2)  =SQRT(PHKT(4,8+IIGLU1+IIGLU2)**2-
     * PHKT(3,8+IIGLU1+IIGLU2)**2-PHKT(2,8+IIGLU1+IIGLU2)**2-
     *PHKT(1,8+IIGLU1+IIGLU2)**2)
      ELSE
C      WRITE(6,*)' parton 4 mass square LT.0 ',XMIST
        PHKT(5,8+IIGLU1+IIGLU2)=0.D0
      ENDIF
      VHKT(1,8+IIGLU1+IIGLU2)  =VHKK(1,NC1T)
      VHKT(2,8+IIGLU1+IIGLU2)  =VHKK(2,NC1T)
      VHKT(3,8+IIGLU1+IIGLU2)  =VHKK(3,NC1T)
      VHKT(4,8+IIGLU1+IIGLU2)  =VHKK(4,NC1T)
      WHKT(1,8+IIGLU1+IIGLU2)  =WHKK(1,NC1T)
      WHKT(2,8+IIGLU1+IIGLU2)  =WHKK(2,NC1T)
      WHKT(3,8+IIGLU1+IIGLU2)  =WHKK(3,NC1T)
      WHKT(4,8+IIGLU1+IIGLU2)  =WHKK(4,NC1T)
      IDHKT(9+IIGLU1+IIGLU2)   =88888
      ISTHKT(9+IIGLU1+IIGLU2)  =94
      JMOHKT(1,9+IIGLU1+IIGLU2)=7+IIGLU1
      JMOHKT(2,9+IIGLU1+IIGLU2)=8+IIGLU1+IIGLU2
      JDAHKT(1,9+IIGLU1+IIGLU2)=0
      JDAHKT(2,9+IIGLU1+IIGLU2)=0
      PHKT(1,9+IIGLU1+IIGLU2)
     * =PHKT(1,7+IIGLU1)+PHKT(1,8+IIGLU1+IIGLU2)+PG1
      PHKT(2,9+IIGLU1+IIGLU2)
     * =PHKT(2,7+IIGLU1)+PHKT(2,8+IIGLU1+IIGLU2)+PG2
      PHKT(3,9+IIGLU1+IIGLU2)
     * =PHKT(3,7+IIGLU1)+PHKT(3,8+IIGLU1+IIGLU2)+PG3
      PHKT(4,9+IIGLU1+IIGLU2)
     * =PHKT(4,7+IIGLU1)+PHKT(4,8+IIGLU1+IIGLU2)+PG4
      XMIST
     *=(PHKT(4,9+IIGLU1+IIGLU2)**2-PHKT(1,9+IIGLU1+IIGLU2)**2
     * -PHKT(2,9+IIGLU1+IIGLU2)**2
     *            -PHKT(3,9+IIGLU1+IIGLU2)**2)
      IF(XMIST.GE.0.D0)THEN
      PHKT(5,9+IIGLU1+IIGLU2)
     *=SQRT(PHKT(4,9+IIGLU1+IIGLU2)**2-PHKT(1,9+IIGLU1+IIGLU2)**2
     * -PHKT(2,9+IIGLU1+IIGLU2)**2
     *            -PHKT(3,9+IIGLU1+IIGLU2)**2)
      ELSE
C      WRITE(6,*)'MUSQBS1 parton 1 mass square LT.0 ',XMIST
       PHKT(5,1)=0.D0
      ENDIF
      IF(IPIP.GE.3)THEN
C     IF(NUMEV.EQ.-324)THEN
      WRITE(ErrorOut,
     * *)7+IIGLU1,ISTHKT(7+IIGLU1),IDHKT(7+IIGLU1),
     * JMOHKT(1,7+IIGLU1),JMOHKT(2,7+IIGLU1),JDAHKT(1,7+IIGLU1),
     *JDAHKT(2,7+IIGLU1),(PHKT(III,7+IIGLU1),III=1,5)
      DO 91 IIG=7+IIGLU1+1,7+IIGLU1+IIGLU2
      WRITE(ErrorOut,
     * *)IIG,ISTHKT(IIG),IDHKT(IIG),JMOHKT(1,IIG),JMOHKT(2,IIG),
     * JDAHKT(1,IIG),
     *JDAHKT(2,IIG),(PHKT(III,IIG),III=1,5)
   91 CONTINUE
      WRITE(ErrorOut,*)8+IIGLU1+IIGLU2,
     * ISTHKT(8+IIGLU1+IIGLU2),IDHKT(8+IIGLU1+IIGLU2),
     * JMOHKT(1,8+IIGLU1+IIGLU2),JMOHKT(2,8+IIGLU1+IIGLU2),
     *JDAHKT(1,8+IIGLU1+IIGLU2),
     *JDAHKT(2,8+IIGLU1+IIGLU2),(PHKT(III,8+IIGLU1+IIGLU2),III=1,5)
      WRITE(ErrorOut,*)9+IIGLU1+IIGLU2,ISTHKT(9+IIGLU1+IIGLU2),
     * IDHKT(9+IIGLU1+IIGLU2),JMOHKT(1,9+IIGLU1+IIGLU2),
     *JMOHKT(2,9+IIGLU1+IIGLU2),JDAHKT(1,9+IIGLU1+IIGLU2),
     *JDAHKT(2,9+IIGLU1+IIGLU2),(PHKT(III,9+IIGLU1+IIGLU2),III=1,5)
      ENDIF
      CHAMAL=CHAB1
      IF(IPIP.EQ.1)THEN
        IF(IP2.GE.3.OR.IPP1.GE.3.OR.ISQ1.GE.3)CHAMAL=CHAB3
      ELSEIF(IPIP.EQ.2)THEN
        IF(IP2.LE.-3.OR.IPP1.LE.-3.OR.ISQ1.GE.9)CHAMAL=CHAB3
      ENDIF
      IF(PHKT(5,9+IIGLU1+IIGLU2).LT.CHAMAL)THEN
C       IREJ=1
	IPCO=0
C	RETURN
C       WRITE(6,*)' MGSQBS1 jump back from chain 9',
C    *  'CHAMAL,PHKT(5,9+IIGLU1+IIGLU2)',CHAMAL,PHKT(5,9+IIGLU1+IIGLU2)
	GO TO 3466
      ENDIF
      VHKT(1,9+IIGLU1+IIGLU2)  =VHKK(1,NC1)
      VHKT(2,9+IIGLU1+IIGLU2)  =VHKK(2,NC1)
      VHKT(3,9+IIGLU1+IIGLU2)  =VHKK(3,NC1)
      VHKT(4,9+IIGLU1+IIGLU2)  =VHKK(4,NC1)
      WHKT(1,9+IIGLU1+IIGLU2)  =WHKK(1,NC1)
      WHKT(2,9+IIGLU1+IIGLU2)  =WHKK(2,NC1)
      WHKT(3,9+IIGLU1+IIGLU2)  =WHKK(3,NC1)
      WHKT(4,9+IIGLU1+IIGLU2)  =WHKK(4,NC1)
C
      IPCO=0
      IGCOUN=9+IIGLU1+IIGLU2
       RETURN
       END
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      SUBROUTINE MGSQBS1(NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,
     *              IP11,IP12,IP2,IPP1,IPP21,IPP22,IPIP,ISQ,IGCOUN)
C
C                  GSQBS-1 diagram (split projectile diquark)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c diquark-breaking mechanism
      COMMON /DTDIQB/ DBRKR(3,8),DBRKA(3,8),CHAM1,CHAM3,CHAB1,CHAB3


C
      PARAMETER (NTMHKK= 300)
      COMMON /HKKTMP/NHKKT,NEVHKT,ISTHKT(NTMHKK),IDHKT(NTMHKK),JMOHKT
     +(2,NTMHKK),JDAHKT(2,NTMHKK), PHKT(5,NTMHKK),VHKT(4,NTMHKK),WHKT
     +(4,NTMHKK)
cKEEP,XSEADI.
      COMMON /XSEADI/ XSEACU,UNON,UNOM,UNOSEA,CVQ,CDQ,CSEA,SSMIMA,
     +SSMIMQ,VVMTHR
cKEEP,DPRIN.
      COMMON /DPRIN/ IPRI,IPEV,IPPA,IPCO,INIT,IPHKK,ITOPD,IPAUPR
C
C                  GSQBS-1 diagram (split projectile diquark)
C
C
C     Input chain 1(NC1) valence-diquark(NC1P)-valence-quark(NC1T)
C     Input chain 2(NC2) sea-quark(NC2P)-valence-diquark(NC2T)
C
C     Create quark(qs)-antiquark(aqs) pair energy from NC1P and NC1T
C     Split remaining valence diquark(NC1P) into quarks vq1P and vq2P
C
C     Create chains 3 valence quark(vq1P 1)-valence diquark(NC2T 2)
C                   6 valence quark(vq2P 4)-sea-quark(aqsP 5)
C                   9 diquark(qsP+NC2P 7)-valence quark(NC1T 8)
C
C       Put new chains into COMMON /HKKTMP/
C
      IIGLU1=NC1T-NC1P-1
      IIGLU2=NC2T-NC2P-1
      IGCOUN=0
C     WRITE(6,*)' IIGLU1,IIGLU2 ',IIGLU1,IIGLU2
      CVQ=1.D0
      NNNC1=IDHKK(NC1)/1000
      MMMC1=IDHKK(NC1)-NNNC1*1000
      KKKC1=ISTHKK(NC1)
      NNNC2=IDHKK(NC2)/1000
      MMMC2=IDHKK(NC2)-NNNC2*1000
      KKKC2=ISTHKK(NC2)
      IREJ=0
      IF(IPIP.EQ.3)THEN
      WRITE(ErrorOut,
     * *)' MGSQBS1(NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,',
     *             ' IP11,IP12,IP2,IPP1,IPP21,IPP22,IPIP,IGCOUN)',
     *NC1,NC1P,NC1T,NC2,NC2P,NC2T,IREJ,
     *              IP11,IP12,IP2,IPP1,IPP21,IPP22,IPIP,IGCOUN
      ENDIF
C
C
C
C     determine x-values of NC1P diquark
      XDIQP=PHKK(4,NC1P)*2.D0/UMO
      XVQT=PHKK(4,NC1T)*2.D0/UMO
C
C     determine x-values of sea quark pair
C
      IPCO=1
      ICOU=0
 2234 CONTINUE
      ICOU=ICOU+1
      IF(ICOU.GE.500)THEN
        IREJ=1
        IF(ISQ.EQ.3)IREJ=3
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)' MGSQBS1 Rejection 2234 ICOU. GT.100'
      IPCO=0
        RETURN
      ENDIF
      IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'MGSQBS1 call  XSEAPA: UMO,XDIQP,XVQT ',
     * UMO, XDIQP,XVQT
      XSQ=0.D0
      XSAQ=0.D0
c*NEW
C     CALL XSEAPA(UMO,XDIQP/2.D0,ISQ,ISAQ,XSQ,XSAQ,IREJ)
      IF (IPIP.EQ.1) THEN
         XQMAX  = XDIQP/2.0D0
         XAQMAX = 2.D0*XVQT/3.0D0
      ELSE
         XQMAX  = 2.D0*XVQT/3.0D0
         XAQMAX = XDIQP/2.0D0
      ENDIF
      CALL DT_CQPAIR(XQMAX,XAQMAX,XSQ,XSAQ,ISQ,IREJ)
      ISAQ = 6+ISQ
C     write(*,*) 'MGSQBS1: ',ISQ,XSQ,XDIQP,XSAQ,XVQT
c*
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'MGSQBS1 after XSEAPA',ISQ,ISAQ,XSQ,XSAQ
      IF(IREJ.GE.1)THEN
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'MGSQBS1 reject XSEAPA',ISQ,ISAQ,XSQ,XSAQ
      IPCO=0
        RETURN
      ENDIF
      IF(IPIP.EQ.1)THEN
        IF(XSAQ.GE.2.D0*XVQT/3.D0)GO TO 2234
      ELSEIF(IPIP.EQ.2)THEN
        IF(XSQ.GE.2.D0*XVQT/3.D0)GO TO 2234
      ENDIF
      IF(IPCO.GE.3)THEN
        WRITE(ErrorOut,
     * '(A,4E12.4)')' MGSQBS1 XDIQP,XVQT,XSQ,XSAQ ',
     *	XDIQP,XVQT,XSQ,XSAQ
      ENDIF
C
C     subtract xsq,xsaq from NC1P diquark and NC1T quark
C
C     XSQ=0.D0
      IF(IPIP.EQ.1)THEN
        XDIQP=XDIQP-XSQ
c*NEW
C       IF (XDIQP.LT.0.0D0) WRITE(*,*) ' mgsqbs1: XDIQP<0!!',XDIQP
c*
        XVQT =XVQT -XSAQ
      ELSEIF(IPIP.EQ.2)THEN
        XDIQP=XDIQP-XSAQ
        XVQT =XVQT -XSQ
      ENDIF
      IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)'XDIQP,XVQT after subtraction',XDIQP,XVQT
C
C     Split remaining valence diquark(NC1P) into quarks vq1P and vq2P
C
      XVTHRO=CVQ/UMO
      IVTHR=0
 3466 CONTINUE
      IF(IVTHR.EQ.10)THEN
        IREJ=1
        IF(ISQ.EQ.3)IREJ=3
        IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)' MGSQBS1 3466 reject IVTHR 10'
      IPCO=0
        RETURN
      ENDIF
      IVTHR=IVTHR+1
      XVTHR=XVTHRO/(201-IVTHR)
      UNOPRV=UNON
 380  CONTINUE
      IF(XVTHR.GT.0.66D0*XDIQP)THEN
        IREJ=1
        IF(ISQ.EQ.3)IREJ=3
	IF(IPCO.GE.3)WRITE(ErrorOut,
     * *)' MGSQBS1 Rejection 380 XVTHR  large ',
     *  XVTHR
      IPCO=0
        RETURN
      ENDIF
      IF(DT_RNDM(V).LT.0.5D0)THEN
        XVPQI=DT_SAMPEX(XVTHR,0.66D0*XDIQP)
        XVPQII=XDIQP-XVPQI
      ELSE
        XVPQII=DT_SAMPEX(XVTHR,0.66D0*XDIQP)
        XVPQI=XDIQP-XVPQII
      ENDIF
      IF(IPCO.GE.3)THEN
        WRITE(ErrorOut,
     * '(A,4E12.4)')'  MGSQBS1:XVTHR,XDIQP,XVPQI,XVPQII ',
     *	XVTHR,XDIQP,XVPQI,XVPQII
      ENDIF
C
C     Prepare 4 momenta of new chains and chain ends
C
C     COMMON /HKKTMP/NHKKT,NEVHKT,ISTHKT(NTMHKK),IDHKT(NTMHKK),JMOHKT
C    +(2,NTMHKK),JDAHKT(2,NTMHKK), PHKT(5,NTMHKK),VHKT(4,NTMHKK),WHKT
C    +(4,NTMHKK)
C     Create chains 3 valence quark(vq1P 1)-valence diquark(NC2T 2)
C                   6 valence quark(vq2P 4)-sea-quark(aqsP 5)
C                   9 diquark(qsP+NC2P 7)-valence quark(NC1T 8)
      IF(IPIP.EQ.1)THEN
        XSQ1=XSQ
	XSAQ1=XSAQ
	ISQ1=ISQ
	ISAQ1=ISAQ
      ELSEIF(IPIP.EQ.2)THEN
        XSQ1=XSAQ
	XSAQ1=XSQ
	ISQ1=ISAQ
	ISAQ1=ISQ
      ENDIF
      KK11=IP11
C     IDHKT(2)   =1000*IPP21+100*IPP22+1
      KK21= IPP21
      KK22= IPP22
      XGIVE=0.D0
      IDHKT(4+IIGLU1)   =IP12
      ISTHKT(4+IIGLU1)  =921
      JMOHKT(1,4+IIGLU1)=NC1P
      JMOHKT(2,4+IIGLU1)=0
      JDAHKT(1,4+IIGLU1)=6+IIGLU1
      JDAHKT(2,4+IIGLU1)=0
c*NEW
      IF ((XDIQP.LT.0.0D0).OR.(XVPQII.LT.0.0D0).OR.
     &    (XSQ1.LT.0.0D0)) WRITE(*,*) ' mgsqbs1: ',XDIQP,XVPQII,XSQ1
c*
      PHKT(1,4+IIGLU1)  =PHKK(1,NC1P)*XVPQII/(XDIQP+XSQ1)
      PHKT(2,4+IIGLU1)  =PHKK(2,NC1P)*XVPQII/(XDIQP+XSQ1)
      PHKT(3,4+IIGLU1)  =PHKK(3,NC1P)*XVPQII/(XDIQP+XSQ1)
      PHKT(4,4+IIGLU1)  =PHKK(4,NC1P)*XVPQII/(XDIQP+XSQ1)
C     PHKT(5,4+IIGLU1)  =PHKK(5,NC1P)
      XXMIST=(PHKT(4,4+IIGLU1)**2-
     *              PHKT(3,4+IIGLU1)**2-PHKT(2,4+IIGLU1)**2-
     *              PHKT(1,4+IIGLU1)**2)
      IF(XXMIST.GT.0.D0)THEN
        PHKT(5,4+IIGLU1)  =SQRT(XXMIST)
      ELSE
        WRITE(ErrorOut,*)'MGSQBS1 XXMIST',XXMIST
        XXMIST=ABS(XXMIST)
        PHKT(5,4+IIGLU1)  =SQRT(XXMIST)
      ENDIF
      VHKT(1,4+IIGLU1)  =VHKK(1,NC1P)
      VHKT(2,4+IIGLU1)  =VHKK(2,NC1P)
      VHKT(3,4+IIGLU1)  =VHKK(3,NC1P)
      VHKT(4,4+IIGLU1)  =VHKK(4,NC1P)
      WHKT(1,4+IIGLU1)  =WHKK(1,NC1P)
      WHKT(2,4+IIGLU1)  =WHKK(2,NC1P)
      WHKT(3,4+IIGLU1)  =WHKK(3,NC1P)
      WHKT(4,4+IIGLU1)  =WHKK(4,NC1P)
      IF(IPIP.EQ.1)THEN
        IDHKT(5+IIGLU1)   =-(ISAQ1-6)
      ELSEIF(IPIP.EQ.2)THEN
        IDHKT(5+IIGLU1)   =ISAQ1
      ENDIF
      ISTHKT(5+IIGLU1)  =922
      JMOHKT(1,5+IIGLU1)=NC1T
      JMOHKT(2,5+IIGLU1)=0
      JDAHKT(1,5+IIGLU1)=6+IIGLU1
      JDAHKT(2,5+IIGLU1)=0
c*NEW
      IF ((XSAQ1.LT.0.0D0).OR.(XVQT  .LT.0.0D0))
     &    WRITE(*,*) ' mgsqbs2: ',XSAQ1,XVQT
c*
      PHKT(1,5+IIGLU1)  =PHKK(1,NC1T)*XSAQ1/(XVQT+XSAQ1)
      PHKT(2,5+IIGLU1)  =PHKK(2,NC1T)*XSAQ1/(XVQT+XSAQ1)
      PHKT(3,5+IIGLU1)  =PHKK(3,NC1T)*XSAQ1/(XVQT+XSAQ1)
      PHKT(4,5+IIGLU1)  =PHKK(4,NC1T)*XSAQ1/(XVQT+XSAQ1)
C     PHKT(5,5+IIGLU1)  =PHKK(5,NC1T)
      XMIST=(PHKT(4,5+IIGLU1)**2-
     * PHKT(3,5+IIGLU1)**2-PHKT(2,5+IIGLU1)**2-
     *PHKT(1,5+IIGLU1)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,5+IIGLU1)  =SQRT(PHKT(4,5+IIGLU1)**2-
     * PHKT(3,5+IIGLU1)**2-PHKT(2,5+IIGLU1)**2-
     *PHKT(1,5+IIGLU1)**2)
      ELSE
C      WRITE(6,*)' parton 4 mass square LT.0 ',XMIST
        PHKT(5,5+IIGLU1)=0.D0
      ENDIF
      VHKT(1,5+IIGLU1)  =VHKK(1,NC1T)
      VHKT(2,5+IIGLU1)  =VHKK(2,NC1T)
      VHKT(3,5+IIGLU1)  =VHKK(3,NC1T)
      VHKT(4,5+IIGLU1)  =VHKK(4,NC1T)
      WHKT(1,5+IIGLU1)  =WHKK(1,NC1T)
      WHKT(2,5+IIGLU1)  =WHKK(2,NC1T)
      WHKT(3,5+IIGLU1)  =WHKK(3,NC1T)
      WHKT(4,5+IIGLU1)  =WHKK(4,NC1T)
      IDHKT(6+IIGLU1)   =88888
C     IDHKT(6)   =1000*NNNC1+MMMC1
      ISTHKT(6+IIGLU1)  =93
C     ISTHKT(6)  =KKKC1
      JMOHKT(1,6+IIGLU1)=4+IIGLU1
      JMOHKT(2,6+IIGLU1)=5+IIGLU1
      JDAHKT(1,6+IIGLU1)=0
      JDAHKT(2,6+IIGLU1)=0
      PHKT(1,6+IIGLU1)  =PHKT(1,4+IIGLU1)+PHKT(1,5+IIGLU1)
      PHKT(2,6+IIGLU1)  =PHKT(2,4+IIGLU1)+PHKT(2,5+IIGLU1)
      PHKT(3,6+IIGLU1)  =PHKT(3,4+IIGLU1)+PHKT(3,5+IIGLU1)
      PHKT(4,6+IIGLU1)  =PHKT(4,4+IIGLU1)+PHKT(4,5+IIGLU1)
      PHKT(5,6+IIGLU1)
     * =SQRT(PHKT(4,6+IIGLU1)**2-PHKT(1,6+IIGLU1)**2-PHKT(2,6+IIGLU1)**2
     *            -PHKT(3,6+IIGLU1)**2)
      CHAMAL=CHAM1
      IF(IPIP.EQ.1)THEN
        IF(IP12.GE.3.OR.ISAQ.GE.9)CHAMAL=CHAM3
      ELSEIF(IPIP.EQ.2)THEN
        IF(IP12.LE.-3.OR.ISAQ.GE.3)CHAMAL=CHAM3
      ENDIF
      IF(PHKT(5,6+IIGLU1).LT.CHAMAL)THEN
        IF(IDHKT(5+IIGLU1).EQ.-IDHKT(4+IIGLU1))THEN
C                    we drop chain 6 and give the energy to chain 3
          IDHKT(6+IIGLU1)=33888
	  XGIVE=1.D0
C	  WRITE(6,*)' drop chain 6 xgive=1'
	  GO TO 7788
	ELSEIF(IDHKT(5+IIGLU1).EQ.-IP11)THEN
C                    we drop chain 6 and give the energy to chain 3
C                    and change KK11 to IDHKT(4)
          IDHKT(6+IIGLU1)=33888
	  XGIVE=1.D0
C	  WRITE(6,*)' drop chain 6 xgive=1 KK11=IDHKT(4+IIGLU1)'
	  KK11=IDHKT(4+IIGLU1)
	  GO TO 7788
	ELSEIF(IDHKT(5+IIGLU1).EQ.-IPP21)THEN
C                    we drop chain 6 and give the energy to chain 3
C                    and change KK21 to IDHKT(4)
C     IDHKT(2)   =1000*IPP21+100*IPP22+1
          IDHKT(6+IIGLU1)=33888
	  XGIVE=1.D0
C	  WRITE(6,*)' drop chain 6 xgive=1 KK21=IDHKT(4+IIGLU1)'
	  KK21=IDHKT(4+IIGLU1)
	  GO TO 7788
	ELSEIF(IDHKT(5+IIGLU1).EQ.-IPP22)THEN
C                    we drop chain 6 and give the energy to chain 3
C                    and change KK22 to IDHKT(4)
C     IDHKT(2)   =1000*IPP21+100*IPP22+1
          IDHKT(6+IIGLU1)=33888
	  XGIVE=1.D0
C	  WRITE(6,*)' drop chain 6 xgive=1 KK22=IDHKT(4+IIGLU1)'
	  KK22=IDHKT(4+IIGLU1)
	  GO TO 7788
	ENDIF
C       IREJ=1
	IPCO=0
C	RETURN
C       WRITE(6,*)' MGSQBS1 jump back from chain 6'
        GO TO 3466
      ENDIF
 7788 CONTINUE
      IF(IPIP.GE.3)THEN
      WRITE(ErrorOut,
     * *)4+IIGLU1,ISTHKT(4+IIGLU1),IDHKT(4+IIGLU1),
     * JMOHKT(1,4+IIGLU1),
     * JMOHKT(2,4+IIGLU1),JDAHKT(1,4+IIGLU1),
     *JDAHKT(2,4+IIGLU1),(PHKT(III,4+IIGLU1),III=1,5)
      WRITE(ErrorOut,
     * *)5+IIGLU1,ISTHKT(5+IIGLU1),IDHKT(5+IIGLU1),
     * JMOHKT(1,5+IIGLU1),
     * JMOHKT(2,5+IIGLU1),JDAHKT(1,5+IIGLU1),
     *JDAHKT(2,5+IIGLU1),(PHKT(III,5+IIGLU1),III=1,5)
      WRITE(ErrorOut,
     * *)6+IIGLU1,ISTHKT(6+IIGLU1),IDHKT(6+IIGLU1),
     * JMOHKT(1,6+IIGLU1),
     * JMOHKT(2,6+IIGLU1),JDAHKT(1,6+IIGLU1),
     *JDAHKT(2,6+IIGLU1),(PHKT(III,6+IIGLU1),III=1,5)
      ENDIF
      VHKT(1,6+IIGLU1)  =VHKK(1,NC1)
      VHKT(2,6+IIGLU1)  =VHKK(2,NC1)
      VHKT(3,6+IIGLU1)  =VHKK(3,NC1)
      VHKT(4,6+IIGLU1)  =VHKK(4,NC1)
      WHKT(1,6+IIGLU1)  =WHKK(1,NC1)
      WHKT(2,6+IIGLU1)  =WHKK(2,NC1)
      WHKT(3,6+IIGLU1)  =WHKK(3,NC1)
      WHKT(4,6+IIGLU1)  =WHKK(4,NC1)
C     IDHKT(1)   =IP11
      IDHKT(1)   =KK11
      ISTHKT(1)  =921
      JMOHKT(1,1)=NC1P
      JMOHKT(2,1)=0
      JDAHKT(1,1)=3+IIGLU1
      JDAHKT(2,1)=0
      PHKT(1,1)  =PHKK(1,NC1P)*XVPQI/(XDIQP+XSQ1)
C    * +0.5D0*PHKK(1,NC2P)
     *+XGIVE*PHKT(1,4+IIGLU1)
      PHKT(2,1)  =PHKK(2,NC1P)*XVPQI/(XDIQP+XSQ1)
C    * +0.5D0*PHKK(2,NC2P)
     *+XGIVE*PHKT(2,4+IIGLU1)
      PHKT(3,1)  =PHKK(3,NC1P)*XVPQI/(XDIQP+XSQ1)
C    * +0.5D0*PHKK(3,NC2P)
     *+XGIVE*PHKT(3,4+IIGLU1)
      PHKT(4,1)  =PHKK(4,NC1P)*XVPQI/(XDIQP+XSQ1)
C    * +0.5D0*PHKK(4,NC2P)
     *+XGIVE*PHKT(4,4+IIGLU1)
C     PHKT(5,1)  =PHKK(5,NC1P)
      XMIST  =(PHKT(4,1)**2- PHKT(3,1)**2-PHKT(2,1)**2-
     *PHKT(1,1)**2)
      IF(XMIST.GE.0.D0)THEN
      PHKT(5,1)  =SQRT(PHKT(4,1)**2- PHKT(3,1)**2-PHKT(2,1)**2-
     *PHKT(1,1)**2)
      ELSE
C      WRITE(6,*)'MGSQBS1 parton 1 mass square LT.0 ',XMIST
       PHKT(5,1)=0.D0
      ENDIF
      VHKT(1,1)  =VHKK(1,NC1P)
      VHKT(2,1)  =VHKK(2,NC1P)
      VHKT(3,1)  =VHKK(3,NC1P)
      VHKT(4,1)  =VHKK(4,NC1P)
      WHKT(1,1)  =WHKK(1,NC1P)
      WHKT(2,1)  =WHKK(2,NC1P)
      WHKT(3,1)  =WHKK(3,NC1P)
      WHKT(4,1)  =WHKK(4,NC1P)
C     Add here IIGLU1 gluons to this chaina
      PG1=0.D0
      PG2=0.D0
      PG3=0.D0
      PG4=0.D0
      IF(IIGLU1.GE.1)THEN
      JJG=NC1P
      DO 61 IIG=2,2+IIGLU1-1
        KKG=JJG+IIG-1
        IDHKT(IIG)   =IDHKK(KKG)
        ISTHKT(IIG)  =921
        JMOHKT(1,IIG)=KKG
        JMOHKT(2,IIG)=0
        JDAHKT(1,IIG)=3+IIGLU1
        JDAHKT(2,IIG)=0
	PHKT(1,IIG)=PHKK(1,KKG)
	PG1=PG1+ PHKT(1,IIG)
	PHKT(2,IIG)=PHKK(2,KKG)
	PG2=PG2+ PHKT(2,IIG)
	PHKT(3,IIG)=PHKK(3,KKG)
	PG3=PG3+ PHKT(3,IIG)
	PHKT(4,IIG)=PHKK(4,KKG)
	PG4=PG4+ PHKT(4,IIG)
	PHKT(5,IIG)=PHKK(5,KKG)
        VHKT(1,IIG)  =VHKK(1,KKG)
        VHKT(2,IIG)  =VHKK(2,KKG)
        VHKT(3,IIG)  =VHKK(3,KKG)
        VHKT(4,IIG)  =VHKK(4,KKG)
        WHKT(1,IIG)  =WHKK(1,KKG)
        WHKT(2,IIG)  =WHKK(2,KKG)
        WHKT(3,IIG)  =WHKK(3,KKG)
        WHKT(4,IIG)  =WHKK(4,KKG)
   61 CONTINUE
      ENDIF
C     IDHKT(2)   =1000*IPP21+100*IPP22+1
      IF(IPIP.EQ.1)THEN
        IDHKT(2+IIGLU1)   =1000*KK21+100*KK22+3
	IF(IDHKT(2+IIGLU1).EQ.1203)IDHKT(2+IIGLU1)=2103
	IF(IDHKT(2+IIGLU1).EQ.1303)IDHKT(2+IIGLU1)=3103
	IF(IDHKT(2+IIGLU1).EQ.2303)IDHKT(2+IIGLU1)=3203
      ELSEIF(IPIP.EQ.2)THEN
        IDHKT(2+IIGLU1)   =1000*KK21+100*KK22-3
	IF(IDHKT(2+IIGLU1).EQ.-1203)IDHKT(2+IIGLU1)=-2103
	IF(IDHKT(2+IIGLU1).EQ.-1303)IDHKT(2+IIGLU1)=-3103
	IF(IDHKT(2+IIGLU1).EQ.-2303)IDHKT(2+IIGLU1)=-3203
      ENDIF
      ISTHKT(2+IIGLU1)  =922
      JMOHKT(1,2+IIGLU1)=NC2T
      JMOHKT(2,2+IIGLU1)=0
      JDAHKT(1,2+IIGLU1)=3+IIGLU1
      JDAHKT(2,2+IIGLU1)=0
      PHKT(1,2+IIGLU1)  =PHKK(1,NC2T)
     *+XGIVE*PHKT(1,5+IIGLU1)
      PHKT(2,2+IIGLU1)  =PHKK(2,NC2T)
     *+XGIVE*PHKT(2,5+IIGLU1)
      PHKT(3,2+IIGLU1)  =PHKK(3,NC2T)
     *+XGIVE*PHKT(3,5+IIGLU1)
      PHKT(4,2+IIGLU1)  =PHKK(4,NC2T)
     *+XGIVE*PHKT(4,5+IIGLU1)
C     PHKT(5,2)  =PHKK(5,NC2T)
      XMIST=(PHKT(4,2+IIGLU1)**2-
     * PHKT(3,2+IIGLU1)**2-PHKT(2,2+IIGLU1)**2-
     *PHKT(1,2+IIGLU1)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,2+IIGLU1)  =SQRT(PHKT(4,2+IIGLU1)**2-
     * PHKT(3,2+IIGLU1)**2-PHKT(2,2+IIGLU1)**2-
     *PHKT(1,2+IIGLU1)**2)
      ELSE
C     WRITE(6,*)'MUSQBS2 parton 1 mass square LT.0 ',XMIST
      PHKT(5,2+IIGLU1)=0.D0
      ENDIF
      VHKT(1,2+IIGLU1)  =VHKK(1,NC2T)
      VHKT(2,2+IIGLU1)  =VHKK(2,NC2T)
      VHKT(3,2+IIGLU1)  =VHKK(3,NC2T)
      VHKT(4,2+IIGLU1)  =VHKK(4,NC2T)
      WHKT(1,2+IIGLU1)  =WHKK(1,NC2T)
      WHKT(2,2+IIGLU1)  =WHKK(2,NC2T)
      WHKT(3,2+IIGLU1)  =WHKK(3,NC2T)
      WHKT(4,2+IIGLU1)  =WHKK(4,NC2T)
      IDHKT(3+IIGLU1)   =88888
C     IDHKT(3)   =1000*NNNC1+MMMC1+10
      ISTHKT(3+IIGLU1)  =93
C     ISTHKT(3)  =KKKC1
      JMOHKT(1,3+IIGLU1)=1
      JMOHKT(2,3+IIGLU1)=2+IIGLU1
      JDAHKT(1,3+IIGLU1)=0
      JDAHKT(2,3+IIGLU1)=0
      PHKT(1,3+IIGLU1)  =PHKT(1,1)+PHKT(1,2+IIGLU1)+PG1
      PHKT(2,3+IIGLU1)  =PHKT(2,1)+PHKT(2,2+IIGLU1)+PG2
      PHKT(3,3+IIGLU1)  =PHKT(3,1)+PHKT(3,2+IIGLU1)+PG3
      PHKT(4,3+IIGLU1)  =PHKT(4,1)+PHKT(4,2+IIGLU1)+PG4
      PHKT(5,3+IIGLU1)
     * =SQRT(PHKT(4,3+IIGLU1)**2-PHKT(1,3+IIGLU1)**2-PHKT(2,3+IIGLU1)**2
     *            -PHKT(3,3+IIGLU1)**2)
      IF(IPIP.GE.3)THEN
      WRITE(ErrorOut,
     * *)1,ISTHKT(1),IDHKT(1),JMOHKT(1,1),JMOHKT(2,1),
     * JDAHKT(1,1),
     *JDAHKT(2,1),(PHKT(III,1),III=1,5)
      DO 71 IIG=2,2+IIGLU1-1
      WRITE(ErrorOut,
     * *)IIG,ISTHKT(IIG),IDHKT(IIG),JMOHKT(1,IIG),JMOHKT(2,IIG),
     * JDAHKT(1,IIG),
     *JDAHKT(2,IIG),(PHKT(III,IIG),III=1,5)
   71 CONTINUE
      WRITE(ErrorOut,
     * *)2+IIGLU1,ISTHKT(2+IIGLU1),IDHKT(2),JMOHKT(1,2+IIGLU1),
     * JMOHKT(2,2+IIGLU1),JDAHKT(1,2+IIGLU1),
     *JDAHKT(2,2+IIGLU1),(PHKT(III,2+IIGLU1),III=1,5)
      WRITE(ErrorOut,
     * *)3+IIGLU1,ISTHKT(3+IIGLU1),IDHKT(3+IIGLU1),
     * JMOHKT(1,3+IIGLU1),
     * JMOHKT(2,3+IIGLU1),JDAHKT(1,3+IIGLU1),
     *JDAHKT(2,3+IIGLU1),(PHKT(III,3+IIGLU1),III=1,5)
      ENDIF
      CHAMAL=CHAB1
c*NEW
C     IF(IPIP.EQ.1)THEN
C       IF(IPP21.GE.3.OR.IPP22.GE.3.OR.IP11.GE.3)CHAMAL=CHAB3
C     ELSEIF(IPIP.EQ.2)THEN
C       IF(IPP21.LE.-3.OR.IPP22.LE.-3.OR.IP11.LE.-3)CHAMAL=CHAB3
C     ENDIF
      IF(IPIP.EQ.1)THEN
        IF(KK21.GE.3.OR.KK22.GE.3.OR.KK11.GE.3)CHAMAL=CHAB3
      ELSEIF(IPIP.EQ.2)THEN
        IF(KK21.LE.-3.OR.KK22.LE.-3.OR.KK11.LE.-3)CHAMAL=CHAB3
      ENDIF
c*
      IF(PHKT(5,3+IIGLU1).LT.CHAMAL)THEN
C       IREJ=1
	IPCO=0
C	RETURN
C       WRITE(6,*)' MGSQBS1 jump back from chain 3'
        GO TO 3466
      ENDIF
      VHKT(1,3+IIGLU1)  =VHKK(1,NC1)
      VHKT(2,3+IIGLU1)  =VHKK(2,NC1)
      VHKT(3,3+IIGLU1)  =VHKK(3,NC1)
      VHKT(4,3+IIGLU1)  =VHKK(4,NC1)
      WHKT(1,3+IIGLU1)  =WHKK(1,NC1)
      WHKT(2,3+IIGLU1)  =WHKK(2,NC1)
      WHKT(3,3+IIGLU1)  =WHKK(3,NC1)
      WHKT(4,3+IIGLU1)  =WHKK(4,NC1)
      IF(IPIP.EQ.1)THEN
        IDHKT(7+IIGLU1)   =1000*IPP1+100*ISQ1+3
        IF(IDHKT(7+IIGLU1).EQ.1203)IDHKT(7+IIGLU1)=2103
        IF(IDHKT(7+IIGLU1).EQ.1303)IDHKT(7+IIGLU1)=3103
        IF(IDHKT(7+IIGLU1).EQ.2303)IDHKT(7+IIGLU1)=3203
      ELSEIF(IPIP.EQ.2)THEN
        IDHKT(7+IIGLU1)   =1000*IPP1+100*(-ISQ1+6)-3
        IF(IDHKT(7+IIGLU1).EQ.-1203)IDHKT(7+IIGLU1)=-2103
        IF(IDHKT(7+IIGLU1).EQ.-1303)IDHKT(7+IIGLU1)=-3103
        IF(IDHKT(7+IIGLU1).EQ.-2303)IDHKT(7+IIGLU1)=-3203
C	WRITE(6,*)'IDHKT(7),IPP1,ISQ1',IDHKT(7),IPP1,ISQ1
      ENDIF
      ISTHKT(7+IIGLU1)  =921
      JMOHKT(1,7+IIGLU1)=NC2P
      JMOHKT(2,7+IIGLU1)=0
      JDAHKT(1,7+IIGLU1)=9+IIGLU1+IIGLU2
      JDAHKT(2,7+IIGLU1)=0
C     PHKT(1,7)  =0.5D0*PHKK(1,NC2P)+PHKK(1,NC1P)*XSQ/(XDIQP+XSQ)
C     PHKT(2,7)  =0.5D0*PHKK(2,NC2P)+PHKK(2,NC1P)*XSQ/(XDIQP+XSQ)
C     PHKT(3,7)  =0.5D0*PHKK(3,NC2P)+PHKK(3,NC1P)*XSQ/(XDIQP+XSQ)
C     PHKT(4,7+IIGLU1)  =0.5D0*PHKK(4,NC2P)+PHKK(4,NC1P)*XSQ/(XDIQP+XSQ)
c*NEW
      IF ((XSQ1 .LT.0.0D0).OR.(XDIQP .LT.0.0D0))
     &    WRITE(*,*) ' mgsqbs3: ',XSQ1,XDIQP
c*
      PHKT(1,7+IIGLU1)  =PHKK(1,NC2P)+PHKK(1,NC1P)*XSQ1/(XDIQP+XSQ1)
      PHKT(2,7+IIGLU1)  =PHKK(2,NC2P)+PHKK(2,NC1P)*XSQ1/(XDIQP+XSQ1)
      PHKT(3,7+IIGLU1)  =PHKK(3,NC2P)+PHKK(3,NC1P)*XSQ1/(XDIQP+XSQ1)
      PHKT(4,7+IIGLU1)  =PHKK(4,NC2P)+PHKK(4,NC1P)*XSQ1/(XDIQP+XSQ1)
C     WRITE(6,*)'PHKK(4,NC1P),PHKK(4,NC2P), PHKT(4,7)',
C    * PHKK(4,NC1P),PHKK(4,NC2P), PHKT(4,7)
      IF(PHKT(4,7+IIGLU1).GE. PHKK(4,NC1P))THEN
C       IREJ=1
C	WRITE(6,*)'reject PHKT(4,7).GE. PHKK(4,NC1P)'
	IPCO=0
C	RETURN
        GO TO 3466
      ENDIF
C     PHKT(5,7)  =PHKK(5,NC2P)
      PHKT(5,7+IIGLU1)  =SQRT(PHKT(4,7+IIGLU1)**2-
     * PHKT(3,7+IIGLU1)**2-PHKT(2,7+IIGLU1)**2-
     *PHKT(1,7+IIGLU1)**2)
      VHKT(1,7+IIGLU1)  =VHKK(1,NC2P)
      VHKT(2,7+IIGLU1)  =VHKK(2,NC2P)
      VHKT(3,7+IIGLU1)  =VHKK(3,NC2P)
      VHKT(4,7+IIGLU1)  =VHKK(4,NC2P)
      WHKT(1,7+IIGLU1)  =WHKK(1,NC2P)
      WHKT(2,7+IIGLU1)  =WHKK(2,NC2P)
      WHKT(3,7+IIGLU1)  =WHKK(3,NC2P)
      WHKT(4,7+IIGLU1)  =WHKK(4,NC2P)
C     Insert here the IIGLU2 gluons
      PG1=0.D0
      PG2=0.D0
      PG3=0.D0
      PG4=0.D0
      IF(IIGLU2.GE.1)THEN
      JJG=NC2P
      DO 81 IIG=7+IIGLU1+1,7+IIGLU1+IIGLU2
        KKG=JJG+IIG-7-IIGLU1
        IDHKT(IIG)   =IDHKK(KKG)
        ISTHKT(IIG)  =921
        JMOHKT(1,IIG)=KKG
        JMOHKT(2,IIG)=0
        JDAHKT(1,IIG)=9+IIGLU1+IIGLU2
        JDAHKT(2,IIG)=0
	PHKT(1,IIG)=PHKK(1,KKG)
	PG1=PG1+ PHKT(1,IIG)
	PHKT(2,IIG)=PHKK(2,KKG)
	PG2=PG2+ PHKT(2,IIG)
	PHKT(3,IIG)=PHKK(3,KKG)
	PG3=PG3+ PHKT(3,IIG)
	PHKT(4,IIG)=PHKK(4,KKG)
	PG4=PG4+ PHKT(4,IIG)
	PHKT(5,IIG)=PHKK(5,KKG)
        VHKT(1,IIG)  =VHKK(1,KKG)
        VHKT(2,IIG)  =VHKK(2,KKG)
        VHKT(3,IIG)  =VHKK(3,KKG)
        VHKT(4,IIG)  =VHKK(4,KKG)
        WHKT(1,IIG)  =WHKK(1,KKG)
        WHKT(2,IIG)  =WHKK(2,KKG)
        WHKT(3,IIG)  =WHKK(3,KKG)
        WHKT(4,IIG)  =WHKK(4,KKG)
   81 CONTINUE
      ENDIF
      IDHKT(8+IIGLU1+IIGLU2)   =IP2
      ISTHKT(8+IIGLU1+IIGLU2)  =922
      JMOHKT(1,8+IIGLU1+IIGLU2)=NC1T
      JMOHKT(2,8+IIGLU1+IIGLU2)=0
      JDAHKT(1,8+IIGLU1+IIGLU2)=9+IIGLU1+IIGLU2
      JDAHKT(2,8+IIGLU1+IIGLU2)=0
c*NEW
      IF ((XVQT.LT.0.0D0).OR.(XSAQ1 .LT.0.0D0))
     &    WRITE(*,*) ' mgsqbs4: ',XVQT,XSAQ1
c*
      PHKT(1,8+IIGLU1+IIGLU2)  =PHKK(1,NC1T)*XVQT/(XSAQ1+XVQT)
      PHKT(2,8+IIGLU1+IIGLU2)  =PHKK(2,NC1T)*XVQT/(XSAQ1+XVQT)
      PHKT(3,8+IIGLU1+IIGLU2)  =PHKK(3,NC1T)*XVQT/(XSAQ1+XVQT)
      PHKT(4,8+IIGLU1+IIGLU2)  =PHKK(4,NC1T)*XVQT/(XSAQ1+XVQT)
C     PHKT(5,8+IIGLU1+IIGLU2)  =PHKK(5,NC1T)
      XMIST=(PHKT(4,8+IIGLU1+IIGLU2)**2-
     * PHKT(3,8+IIGLU1+IIGLU2)**2-PHKT(2,8+IIGLU1+IIGLU2)**2-
     *PHKT(1,8+IIGLU1+IIGLU2)**2)
      IF(XMIST.GT.0.D0)THEN
      PHKT(5,8+IIGLU1+IIGLU2)  =SQRT(PHKT(4,8+IIGLU1+IIGLU2)**2-
     * PHKT(3,8+IIGLU1+IIGLU2)**2-PHKT(2,8+IIGLU1+IIGLU2)**2-
     *PHKT(1,8+IIGLU1+IIGLU2)**2)
      ELSE
C     WRITE(6,*)'MUSQBS2 parton 1 mass square LT.0 ',XMIST
      PHKT(5,8+IIGLU1+IIGLU2)=0.D0
      ENDIF
      VHKT(1,8+IIGLU1+IIGLU2)  =VHKK(1,NC1T)
      VHKT(2,8+IIGLU1+IIGLU2)  =VHKK(2,NC1T)
      VHKT(3,8+IIGLU1+IIGLU2)  =VHKK(3,NC1T)
      VHKT(4,8+IIGLU1+IIGLU2)  =VHKK(4,NC1T)
      WHKT(1,8+IIGLU1+IIGLU2)  =WHKK(1,NC1T)
      WHKT(2,8+IIGLU1+IIGLU2)  =WHKK(2,NC1T)
      WHKT(3,8+IIGLU1+IIGLU2)  =WHKK(3,NC1T)
      WHKT(4,8+IIGLU1+IIGLU2)  =WHKK(4,NC1T)
      IDHKT(9+IIGLU1+IIGLU2)   =88888
C     IDHKT(9)   =1000*NNNC2+MMMC2+10
      ISTHKT(9+IIGLU1+IIGLU2)  =93
C     ISTHKT(9)  =KKKC2
      JMOHKT(1,9+IIGLU1+IIGLU2)=7+IIGLU1
      JMOHKT(2,9+IIGLU1+IIGLU2)=8+IIGLU1+IIGLU2
      JDAHKT(1,9+IIGLU1+IIGLU2)=0
      JDAHKT(2,9+IIGLU1+IIGLU2)=0
      PHKT(1,9+IIGLU1+IIGLU2)  =PHKT(1,7+IIGLU1)
     * +PHKT(1,8+IIGLU1+IIGLU2)+PG1
      PHKT(2,9+IIGLU1+IIGLU2)  =PHKT(2,7+IIGLU1)
     * +PHKT(2,8+IIGLU1+IIGLU2)+PG2
      PHKT(3,9+IIGLU1+IIGLU2)  =PHKT(3,7+IIGLU1)
     * +PHKT(3,8+IIGLU1+IIGLU2)+PG3
      PHKT(4,9+IIGLU1+IIGLU2)  =PHKT(4,7+IIGLU1)
     * +PHKT(4,8+IIGLU1+IIGLU2)+PG4
      PHKT(5,9+IIGLU1+IIGLU2)
     * =SQRT(PHKT(4,9+IIGLU1+IIGLU2)**2-PHKT(1,9+IIGLU1+IIGLU2)**2-
     * PHKT(2,9+IIGLU1+IIGLU2)**2
     *            -PHKT(3,9+IIGLU1+IIGLU2)**2)
      IF(IPIP.GE.3)THEN
      WRITE(ErrorOut,
     * *)7+IIGLU1,ISTHKT(7+IIGLU1),IDHKT(7+IIGLU1),
     * JMOHKT(1,7+IIGLU1),
     * JMOHKT(2,7+IIGLU1),JDAHKT(1,7+IIGLU1),
     *JDAHKT(2,7+IIGLU1),(PHKT(III,7+IIGLU1),III=1,5)
      DO 91 IIG=7+IIGLU1+1,7+IIGLU1+IIGLU2
      WRITE(ErrorOut,
     * *)IIG,ISTHKT(IIG),IDHKT(IIG),JMOHKT(1,IIG),JMOHKT(2,IIG),
     * JDAHKT(1,IIG),
     *JDAHKT(2,IIG),(PHKT(III,IIG),III=1,5)
   91 CONTINUE
      WRITE(ErrorOut,*)8+IIGLU1+IIGLU2,ISTHKT(8+IIGLU1+IIGLU2),
     * IDHKT(8+IIGLU1+IIGLU2),
     * JMOHKT(1,8+IIGLU1+IIGLU2),JMOHKT(2,8+IIGLU1+IIGLU2),
     * JDAHKT(1,8+IIGLU1+IIGLU2),
     *JDAHKT(2,8+IIGLU1+IIGLU2),(PHKT(III,8+IIGLU1+IIGLU2),III=1,5)
      WRITE(ErrorOut,*)9+IIGLU1+IIGLU2,ISTHKT(9+IIGLU1+IIGLU2),
     * IDHKT(9+IIGLU1+IIGLU2),
     * JMOHKT(1,9+IIGLU1+IIGLU2),JMOHKT(2,9+IIGLU1+IIGLU2),
     * JDAHKT(1,9+IIGLU1+IIGLU2),
     *JDAHKT(2,9+IIGLU1+IIGLU2),(PHKT(III,9+IIGLU1+IIGLU2),III=1,5)
      ENDIF
      CHAMAL=CHAB1
      IF(IPIP.EQ.1)THEN
        IF(IP2.GE.3.OR.IPP1.GE.3.OR.ISQ1.GE.3)CHAMAL=CHAB3
      ELSEIF(IPIP.EQ.2)THEN
        IF(IP2.LE.-3.OR.IPP1.LE.-3.OR.ISQ1.GE.9)CHAMAL=CHAB3
      ENDIF
      IF(PHKT(5,9+IIGLU1+IIGLU2).LT.CHAMAL)THEN
C       IREJ=1
	IPCO=0
C	RETURN
C       WRITE(6,*)' MGSQBS1 jump back from chain 9',
C    *	'CHAMAL,PHKT(5,9+IIGLU1+IIGLU2)',CHAMAL,PHKT(5,9+IIGLU1+IIGLU2)
        GO TO 3466
      ENDIF
      VHKT(1,9+IIGLU1+IIGLU2)  =VHKK(1,NC1)
      VHKT(2,9+IIGLU1+IIGLU2)  =VHKK(2,NC1)
      VHKT(3,9+IIGLU1+IIGLU2)  =VHKK(3,NC1)
      VHKT(4,9+IIGLU1+IIGLU2)  =VHKK(4,NC1)
      WHKT(1,9+IIGLU1+IIGLU2)  =WHKK(1,NC1)
      WHKT(2,9+IIGLU1+IIGLU2)  =WHKK(2,NC1)
      WHKT(3,9+IIGLU1+IIGLU2)  =WHKK(3,NC1)
      WHKT(4,9+IIGLU1+IIGLU2)  =WHKK(4,NC1)
C
      IGCOUN=9+IIGLU1+IIGLU2
      IPCO=0
       RETURN
       END
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      SUBROUTINE HKKHKT(I,J)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

C#include "dtu_dtevt1.inc"
C#include "dtu_dtevt2.inc"

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

      PARAMETER (NTMHKK= 300)
      COMMON /HKKTMP/NHKKT,NEVHKT,ISTHKT(NTMHKK),IDHKT(NTMHKK),JMOHKT
     +(2,NTMHKK),JDAHKT(2,NTMHKK), PHKT(5,NTMHKK),VHKT(4,NTMHKK),WHKT
     +(4,NTMHKK)
C
      ISTHKK(I)  =ISTHKT(J)
      IDHKK(I)   =IDHKT(J)
C     IF(J.EQ.3.OR.J.EQ.6.OR.J.EQ.9)THEN
      IF(IDHKK(I).EQ.88888)THEN
C       JMOHKK(1,I)=I-2
C       JMOHKK(2,I)=I-1
        JMOHKK(1,I)=I-(J-JMOHKT(1,J))
        JMOHKK(2,I)=I-(J-JMOHKT(2,J))
      ELSE
        JMOHKK(1,I)=JMOHKT(1,J)
        JMOHKK(2,I)=JMOHKT(2,J)
      ENDIF
      JDAHKK(1,I)=JDAHKT(1,J)
      JDAHKK(2,I)=JDAHKT(2,J)
C       IF(J.EQ.1.OR.J.EQ.4.OR.J.EQ.7)THEN
C       JDAHKK(1,I)=I+2
C     ELSEIF(J.EQ.2.OR.J.EQ.5.OR.J.EQ.8)THEN
C       JDAHKK(1,I)=I+1
C     ENDIF
      IF(JDAHKT(1,J).GT.0)THEN
        JDAHKK(1,I)=I+(JDAHKT(1,J)-J)
      ENDIF
      PHKK(1,I)  =PHKT(1,J)
      PHKK(2,I)  =PHKT(2,J)
      PHKK(3,I)  =PHKT(3,J)
      PHKK(4,I)  =PHKT(4,J)
      PHKK(5,I)  =PHKT(5,J)
      VHKK(1,I)  =VHKT(1,J)
      VHKK(2,I)  =VHKT(2,J)
      VHKK(3,I)  =VHKT(3,J)
      VHKK(4,I)  =VHKT(4,J)
      WHKK(1,I)  =WHKT(1,J)
      WHKK(2,I)  =WHKT(2,J)
      WHKK(3,I)  =WHKT(3,J)
      WHKK(4,I)  =WHKT(4,J)
      RETURN
      END
c
c===dbreak=============================================================*
c
CDECK  ID>, DT_DBREAK
      SUBROUTINE DT_DBREAK(MODE)

c***********************************************************************
c This is the steering subroutine for the different diquark breaking   *
c mechanisms.                                                          *
c                                                                      *
c MODE = 1  breaking of projectile diquark in qq-q chain using         *
c           a sea quark (q-qq chain) of the same projectile            *
c      = 2  breaking of target     diquark in q-qq chain using         *
c           a sea quark (qq-q chain) of the same target                *
c      = 3  breaking of projectile diquark in qq-q chain using         *
c           a sea quark (q-aq chain) of the same projectile            *
c      = 4  breaking of target     diquark in q-qq chain using         *
c           a sea quark (aq-q chain) of the same target                *
c      = 5  breaking of projectile anti-diquark in aqaq-aq chain using *
c           a sea anti-quark (aq-aqaq chain) of the same projectile    *
c      = 6  breaking of target     anti-diquark in aq-aqaq chain using *
c           a sea anti-quark (aqaq-aq chain) of the same target        *
c      = 7  breaking of projectile anti-diquark in aqaq-aq chain using *
c           a sea anti-quark (aq-q chain) of the same projectile       *
c      = 8  breaking of target     anti-diquark in aq-aqaq chain using *
c           a sea anti-quark (q-aq chain) of the same target           *
c                                                                      *
c Original version by J. Ranft.                                        *
c This version dated 17.5.00  is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c pointer to chains in hkkevt common (used by qq-breaking mechanisms)
      PARAMETER (MAXCHN=10000)
      COMMON /DTIXCH/ IDXCHN(2,MAXCHN),NCHAIN

c diquark-breaking mechanism
      COMMON /DTDIQB/ DBRKR(3,8),DBRKA(3,8),CHAM1,CHAM3,CHAB1,CHAB3

c flags for particle decays
      COMMON /DTFRPA/ MSTUX(20),PARUX(20),MSTJX(20),PARJX(20),
     &                IMSTU(20),IPARU(20),IMSTJ(20),IPARJ(20),
     &                NMSTU,NPARU,NMSTJ,NPARJ,PDB,PDBSEA(3),ISIG0,IPI0


c
c chain identifiers
c ( 1 = q-aq,   2 = aq-q,   3 = q-qq,   4 = qq-q,
c   5 = aq-adq, 6 = adq-aq, 7 = dq-adq, 8 = adq-dq )
      DIMENSION IDCHN1(8),IDCHN2(8)
      DATA IDCHN1 / 4, 3, 4, 3, 6, 5, 6, 5/
      DATA IDCHN2 / 3, 4, 1, 2, 5, 6, 2, 1/
c
c parton identifiers
c ( +-21/22 = valence, +-31/32 = Glauber-sea, +-41/42 = Pomeron (diff),
c   +-51/52 = unitarity-sea, +-61/62 = gluons )
      DIMENSION ISP1P(8,3),ISP1T(8,3),ISP2P(8,3),ISP2T(8,3)
      DATA ISP1P / 21, 21, 21, 21, 21, 21, 21, 21,
     &             31, 31, 31, 31, 31, 31, 31, 31,
     &             41, 41, 41, 41, 51, 51, 51, 51/
      DATA ISP1T / 22, 22, 22, 22, 22, 22, 22, 22,
     &             32, 32, 32, 32, 32, 32, 32, 32,
     &             42, 42, 42, 42, 52, 52, 52, 52/
      DATA ISP2P / 31, 21, 31, 31, 21, 21, 21, 21,
     &             51, 31, 41, 41, 31, 31, 31, 31,
     &              0, 41, 51, 51, 51, 51, 51, 51/
      DATA ISP2T / 22, 32, 32, 32, 22, 22, 22, 22,
     &             32, 52, 42, 42, 32, 32, 32, 32,
     &             42,  0, 52, 52, 52, 52, 52, 52/

      IF (NCHAIN.LE.0) RETURN
      DO 1 I=1,NCHAIN
         IDX1 = IDXCHN(1,I)
         IS1P = ABS(ISTHKK(JMOHKK(1,IDX1)))
         IS1T = ABS(ISTHKK(JMOHKK(2,IDX1)))
         IF ( (IDXCHN(2,I).EQ.IDCHN1(MODE))
     &       .AND.
     &        ((IS1P.EQ.ISP1P(MODE,1)).OR.(IS1P.EQ.ISP1P(MODE,2)).OR.
     &                                    (IS1P.EQ.ISP1P(MODE,3)))
     &       .AND.
     &        ((IS1T.EQ.ISP1T(MODE,1)).OR.(IS1T.EQ.ISP1T(MODE,2)).OR.
     &                                    (IS1T.EQ.ISP1T(MODE,3)))
     &      ) THEN
            DO 2 J=1,NCHAIN
               IDX2 = IDXCHN(1,J)
               IS2P = ABS(ISTHKK(JMOHKK(1,IDX2)))
               IS2T = ABS(ISTHKK(JMOHKK(2,IDX2)))
               IF ( (IDXCHN(2,J).EQ.IDCHN2(MODE))
     &             .AND.
     &              ((IS2P.EQ.ISP2P(MODE,1)).OR.(IS2P.EQ.ISP2P(MODE,2))
     &                                      .OR.(IS2P.EQ.ISP2P(MODE,3)))
     &             .AND.
     &              ((IS2T.EQ.ISP2T(MODE,1)).OR.(IS2T.EQ.ISP2T(MODE,2))
     &                                      .OR.(IS2T.EQ.ISP2T(MODE,3)))
     &            ) THEN
c   find mother nucleons of the diquark to be splitted and of the
c   sea-quark and reject this combination if it is not the same
                  IF ((MODE.EQ.1).OR.(MODE.EQ.3).OR.
     &                (MODE.EQ.5).OR.(MODE.EQ.7)) THEN
                     IANCES = 1
                  ELSE
                     IANCES = 2
                  ENDIF
                  IDXMO1 = JMOHKK(IANCES,IDX1)
    4             CONTINUE
                  IF ((JMOHKK(1,IDXMO1).NE.0).AND.
     &                (JMOHKK(2,IDXMO1).NE.0)) THEN
                     IANC = IANCES
                  ELSE
                     IANC = 1
                  ENDIF
                  IF (JMOHKK(IANC,IDXMO1).NE.0) THEN
                     IDXMO1 = JMOHKK(IANC,IDXMO1)
                     GOTO 4
                  ENDIF
                  IDXMO2 = JMOHKK(IANCES,IDX2)
    5             CONTINUE
                  IF ((JMOHKK(1,IDXMO2).NE.0).AND.
     &                (JMOHKK(2,IDXMO2).NE.0)) THEN
                     IANC = IANCES
                  ELSE
                     IANC = 1
                  ENDIF
                  IF (JMOHKK(IANC,IDXMO2).NE.0) THEN
                     IDXMO2 = JMOHKK(IANC,IDXMO2)
                     GOTO 5
                  ENDIF
                  IF (IDXMO1.NE.IDXMO2) GOTO 2
c   quark content of projectile parton
                  IP1   = IDHKK(JMOHKK(1,IDX1))
                  IP11  = IP1/1000
                  IP12  = (IP1-1000*IP11)/100
                  IP2   = IDHKK(JMOHKK(2,IDX1))
                  IP21  = IP2/1000
                  IP22  = (IP2-1000*IP21)/100
c   quark content of target parton
                  IT1  = IDHKK(JMOHKK(1,IDX2))
                  IT11 = IT1/1000
                  IT12 = (IT1-1000*IT11)/100
                  IT2  = IDHKK(JMOHKK(2,IDX2))
                  IT21 = IT2/1000
                  IT22 = (IT2-1000*IT21)/100
c   split diquark and form new chains
                  IF (MODE.EQ.1) THEN
                     IF (IT1.EQ.4) GOTO 2
                     CALL MGSQBS1(IDX1,JMOHKK(1,IDX1),JMOHKK(2,IDX1),
     &                         IDX2,JMOHKK(1,IDX2),JMOHKK(2,IDX2),IREJ,
     &                         IP11,IP12,IP2,IT1,IT21,IT22,1,IPQ,IGCOUN)
                  ELSEIF (MODE.EQ.2) THEN
                     IF (IT2.EQ.4) GOTO 2
                     CALL MGSQBS2(IDX1,JMOHKK(1,IDX1),JMOHKK(2,IDX1),
     &                         IDX2,JMOHKK(1,IDX2),JMOHKK(2,IDX2),IREJ,
     &                         IP1,IP21,IP22,IT11,IT12,IT2,1,IPQ,IGCOUN)
                  ELSEIF (MODE.EQ.3) THEN
                     IF (IT1.EQ.4) GOTO 2
                     CALL MUSQBS1(IDX1,JMOHKK(1,IDX1),JMOHKK(2,IDX1),
     &                         IDX2,JMOHKK(1,IDX2),JMOHKK(2,IDX2),IREJ,
     &                         IP11,IP12,IP2,IT1,IT2,1,IPQ,IGCOUN)
                  ELSEIF (MODE.EQ.4) THEN
                     IF (IT2.EQ.4) GOTO 2
                     CALL MUSQBS2(IDX1,JMOHKK(1,IDX1),JMOHKK(2,IDX1),
     &                         IDX2,JMOHKK(1,IDX2),JMOHKK(2,IDX2),IREJ,
     &                         IP1,IP21,IP22,IT1,IT2,1,IPQ,IGCOUN)
                  ELSEIF (MODE.EQ.5) THEN
                     CALL MGSQBS1(IDX1,JMOHKK(1,IDX1),JMOHKK(2,IDX1),
     &                         IDX2,JMOHKK(1,IDX2),JMOHKK(2,IDX2),IREJ,
     &                         IP11,IP12,IP2,IT1,IT21,IT22,2,IPQ,IGCOUN)
                  ELSEIF (MODE.EQ.6) THEN
                     CALL MGSQBS2(IDX1,JMOHKK(1,IDX1),JMOHKK(2,IDX1),
     &                         IDX2,JMOHKK(1,IDX2),JMOHKK(2,IDX2),IREJ,
     &                         IP1,IP21,IP22,IT11,IT12,IT2,2,IPQ,IGCOUN)
                  ELSEIF (MODE.EQ.7) THEN
                     CALL MUSQBS1(IDX1,JMOHKK(1,IDX1),JMOHKK(2,IDX1),
     &                         IDX2,JMOHKK(1,IDX2),JMOHKK(2,IDX2),IREJ,
     &                         IP11,IP12,IP2,IT1,IT2,2,IPQ,IGCOUN)
                  ELSEIF (MODE.EQ.8) THEN
                     CALL MUSQBS2(IDX1,JMOHKK(1,IDX1),JMOHKK(2,IDX1),
     &                         IDX2,JMOHKK(1,IDX2),JMOHKK(2,IDX2),IREJ,
     &                         IP1,IP21,IP22,IT1,IT2,2,IPQ,IGCOUN)
                  ENDIF
                  IF (IREJ.GE.1) THEN
                     IF ((IPQ.LT.0).OR.(IPQ.GE.4))
     &                  WRITE(*,*) 'ipq !!!',IPQ,MODE
                     DBRKR(IPQ,MODE) = DBRKR(IPQ,MODE)+1.0D0
c   accept or reject new chains corresponding to PDBSEA
                  ELSE
                     IF ((IPQ.EQ.1).OR.(IPQ.EQ.2)) THEN
                        ACC   = DBRKA(1,MODE)+DBRKA(2,MODE)
                        REJ   = DBRKR(1,MODE)+DBRKR(2,MODE)
                     ELSEIF (IPQ.EQ.3) THEN
                        ACC   = DBRKA(3,MODE)
                        REJ   = DBRKR(3,MODE)
                     ELSE
                        WRITE(*,*) ' inconsistent IPQ ! ',IPQ
                        STOP
                     ENDIF
                     IF (ACC/(ACC+REJ).LE.PDBSEA(IPQ)) THEN
                        DBRKA(IPQ,MODE) = DBRKA(IPQ,MODE)+1.0D0
                        IACC = 1
                     ELSE
                        DBRKR(IPQ,MODE) = DBRKR(IPQ,MODE)+1.0D0
                        IACC = 0
                     ENDIF
c   new chains have been accepted and are now copied into HKKEVT
                     IF (IACC.EQ.1) THEN
                        IF (LEMCCK) THEN
                           CALL DT_EVTEMC(PHKK(1,IDX1),PHKK(2,IDX1),
     &                                    PHKK(3,IDX1),PHKK(4,IDX1),
     &                                    1,IDUM1,IDUM2)
                           CALL DT_EVTEMC(PHKK(1,IDX2),PHKK(2,IDX2),
     &                                    PHKK(3,IDX2),PHKK(4,IDX2),
     &                                    2,IDUM1,IDUM2)
                        ENDIF
                        IDHKK(IDX1) = 99888
                        IDHKK(IDX2) = 99888
                        IDXCHN(2,I) = -1
                        IDXCHN(2,J) = -1
                        DO 3 K=1,IGCOUN
                           NHKK = NHKK+1
                           CALL HKKHKT(NHKK,K)
                           IF ((LEMCCK).AND.(IDHKK(NHKK).EQ.88888))THEN
                              PX = -PHKK(1,NHKK)
                              PY = -PHKK(2,NHKK)
                              PZ = -PHKK(3,NHKK)
                              PE = -PHKK(4,NHKK)
                              CALL DT_EVTEMC(PX,PY,PZ,PE,2,IDUM1,IDUM2)
                           ENDIF
    3                   CONTINUE
                        IF (LEMCCK) THEN
                           CHKLEV = 0.1D0
                           CALL DT_EVTEMC(DUM1,DUM2,DUM3,CHKLEV,-1,9000,
     &                                                             IREJ)
                           IF (IREJ.NE.0) CALL DT_EVTOUT(4)
                        ENDIF
                        GOTO 1
                     ENDIF
                  ENDIF
               ENDIF
    2       CONTINUE
         ENDIF
    1 CONTINUE
      RETURN
      END
c
c===cqpair=============================================================*
c
CDECK  ID>, DT_CQPAIR
      SUBROUTINE DT_CQPAIR(XQMAX,XAQMAX,XQ,XAQ,IFLV,IREJ)

c***********************************************************************
c This subroutine Creates a Quark-antiquark PAIR from the sea.         *
c                                                                      *
c   XQMAX   maxium energy fraction of quark (input)                    *
c   XAQMAX  maxium energy fraction of antiquark (input)                *
c   XQ      energy fraction of quark (output)                          *
c   XAQ     energy fraction of antiquark (output)                      *
c   IFLV    quark flavour (- antiquark flavor) (output)                *
c                                                                      *
c This version dated 14.5.00  is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ


c
      IREJ = 0
      XQ   = 0.0D0
      XAQ  = 0.0D0
c
c sample quark flavour
c
c  set seasq here (the one from DTCHAI should be used in the future)
      SEASQ = 0.5D0
      IFLV  = INT(1.0D0+DT_RNDM(XQMAX)*(2.0D0+SEASQ))
c
c sample energy fractions of sea pair
c we first sample the energy fraction of a gluon and then split the gluon
c
c  maximum energy fraction of the gluon forced via input
      XGMAXI = XQMAX+XAQMAX
c  minimum energy fraction of the gluon
      XTHR1 = 4.0D0 /UMO**2
      XTHR2 = 0.54D0/UMO**1.5D0
      XGMIN = MAX(XTHR1,XTHR2)
c  maximum energy fraction of the gluon
      XGMAX = 0.3D0
      XGMAX = MIN(XGMAXI,XGMAX)
      IF (XGMIN.GE.XGMAX) THEN
         IREJ = 1
         RETURN
      ENDIF
c
c  sample energy fraction of the gluon
      NLOOP = 0
    1 CONTINUE
      NLOOP = NLOOP+1
      IF (NLOOP.GE.50) THEN
         IREJ = 1
         RETURN
      ENDIF
      XGLUON = DT_SAMSQX(XGMIN,XGMAX)
      EGLUON = XGLUON*UMO/2.0D0
c
c  split gluon into q-aq pair (we follow PHOJET's subroutine PHO_GLU2QU)
      ZMIN = MIN(0.1D0,0.5D0/EGLUON)
      ZMAX = 1.0D0-ZMIN
      RZ   = DT_RNDM(ZMAX)
      XHLP = ((1.0D0-RZ)*ZMIN**3+RZ*ZMAX**3)**0.33333
      RQ   = DT_RNDM(ZMAX)
      IF (RQ.LT.0.5D0) THEN
         XQ  = XGLUON*XHLP
         XAQ = XGLUON-XQ
      ELSE
         XAQ = XGLUON*XHLP
         XQ  = XGLUON-XAQ
      ENDIF
      IF ((XQ.GT.XQMAX).OR.(XAQ.GT.XAQMAX)) GOTO 1

      RETURN
      END
#else
      SUBROUTINE DT_KKINC(NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,EPN,KKMAT,
     &                                                         IREJ)
      call cerrorMsg('You specified USEDPMJET 0 in Zcondc.h', 1)
      call cerrorMsg('so that you cannot use dpmjet3', 0)
      end
      subroutine 
     & DT_DTUINI(NEVTS,EPN,NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,IEMU)
      call cerrorMsg('You specified USEDPMJET 0 in Zcondc.h', 1)
      call cerrorMsg('so that you cannot use dpmjet3', 0)
      end
#endif

