#include "Zcondc.h"
#if USEDPMJET == 1
c$ CREATE FRMBRK.FOR
cCOPY FRMBRK
c
c=== frmbrk ===========================================================*
c
CDECK  ID>, DT_FRMBRK
      SUBROUTINE DT_FRMBRK(IARES,IZRES,AMRESD,EXCRES,EKRES ,PXRES ,
     &                   PYRES,PZRES,PTRES ,SMOM1 ,ISTRES,LOKFBK )

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     Created on 08 february 1995  by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 02-may-95     by    Alfredo Ferrari               *
c                                                                      *
c     Input variables:                                                 *
c                                                                      *
c                  Iares = Mass number of the compound nucleus to be   *
c                          exploded                                    *
c                  Izres = Atomic number of the compound nucleus to be *
c                          exploded                                    *
c                 Amresd = Total atomic/nuclear mass of the compound   *
c                          nucleus to be exploded without excitation   *
c                          energy                                      *
c                 Excres = Excitation energy of the compound nucleus   *
c                          to be exploded                              *
c                  Ekres = kinetic (traslational) energy of the comp-  *
c                          ound nucleus to be exploded                 *
c              Px,y,zres = momentum components of the compound nucleus *
c                          to be exploded                              *
c                  Ptres = momentum of the compound nucleus to be      *
c                          exploded                                    *
c                                                                      *
c     Output variables:                                                *
c                                                                      *
c                 Istres = index identifying the residual nucleus in   *
c                          the particle stable states list if >0:      *
c                         -1: particle unstable                        *
c                          0: not in the particle stable state list    *
c                          but no longer particle unstable             *
c                 Lokfbk = .true. if break up is successful, .false.   *
c                          if no channel is available or other         *
c                          possible conditions                         *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: EVA1)
c*sr
C     COMMON /FKEVA1/ NPART(6),EPART(100,6),COSEVP(3,100,6),HEVSUM
      COMMON /FKEVA1/ NPART(6),EPART(200,6),COSEVP(3,200,6),HEVSUM
c*

c (original name: FRBKCM)
      PARAMETER ( MXFFBK =     6 )
      PARAMETER ( MXZFBK =     9 )
      PARAMETER ( MXNFBK =    10 )
      PARAMETER ( MXAFBK =    16 )
      PARAMETER ( NXZFBK = MXZFBK + MXFFBK / 3 )
      PARAMETER ( NXNFBK = MXNFBK + MXFFBK / 3 )
      PARAMETER ( NXAFBK = MXAFBK + 1 )
      PARAMETER ( MXPSST =   300 )
      PARAMETER ( MXPSFB = 41000 )
      LOGICAL LFRMBK, LNCMSS
      COMMON /FKFRBK/  AMUFBK, EEXFBK (MXPSST), AMFRBK (MXPSST),
     &          EXFRBK (MXPSFB), SDMFBK (MXPSFB), COUFBK (MXPSFB),
     &          EXMXFB, R0FRBK, R0CFBK, C1CFBK, C2CFBK,
     &          IFRBKN (MXPSST), IFRBKZ (MXPSST),
     &          IFBKSP (MXPSST), IFBKPR (MXPSST), IFBKST (MXPSST),
     &          IPSIND (0:MXNFBK,0:MXZFBK,2), JPSIND (0:MXAFBK),
     &          IFBIND (0:NXNFBK,0:NXZFBK,2), JFBIND (0:NXAFBK),
     &          IFBCHA (5,MXPSFB), IPOSST, IPOSFB, IFBSTF,
     &          IFBFRB, NBUFBK, LFRMBK, LNCMSS

c (original name: HIGFIS)
      PARAMETER ( IZFSMX = 61 )
      LOGICAL FISINH, LFRGMN, LAGOES
      COMMON /FKHIGF/ AFIS  (10), ZFIS  (10), UFIS  (10), EKFIS  (10),
     &                AMFIS (10), PPFIS (10), COSLFF(3,0:10),
     &                ATFIS (10), ZTFIS (10), UTFIS (10), RECFIS (10),
     &                AMTFIS(10), PPTFIS(10), EBFISS, AMDIFF,
     &                APR0, ZPR0, EREC0, UU0, HEVFIS (0:10),
     &                ISTFIS(10), NPARTF (6,0:10), NFISS, FISINH,
     &                LFRGMN, LAGOES
      DIMENSION COSLF0 (3)
      EQUIVALENCE ( COSLF0 (1), COSLFF (1,0) )

c (original name: LABCOS)
      COMMON /FKLABC/ COSLBP(3),COSLBR(3)

c (original name: NUCDAT)
      PARAMETER ( AMUAMU = AMUGEV )
      PARAMETER ( AMPROT = AMPRTN )
      PARAMETER ( AMNEUT = AMNTRN )
      PARAMETER ( AMELEC = AMELCT )
      PARAMETER ( R0NUCL = 1.12        D+00 )
      PARAMETER ( RCCOUL = 1.7         D+00 )
      PARAMETER ( FERTHO = 14.33       D-09 )
      PARAMETER ( EXPEBN = 2.39        D+00 )
      PARAMETER ( BEXC12 = FERTHO * 72.40715579499394D+00 )
      PARAMETER ( AMUC12 = AMUGEV - HLFHLF * AMELCT + BEXC12 / 12.D+00 )
      PARAMETER ( AMHYDR = AMPRTN + AMELCT  )
      PARAMETER ( AMHTON = AMHYDR - AMNTRN  )
      PARAMETER ( AMNTOU = AMNTRN - AMUC12  )
      PARAMETER ( AMUCSQ = AMUC12 * AMUC12 )
      PARAMETER ( EBNDAV = HLFHLF * (AMPRTN + AMNTRN) - AMUC12 )
      PARAMETER ( GAMMIN = 1.0D-06 )
      PARAMETER ( GAMNSQ = 2.0D+00 * GAMMIN * GAMMIN )
      PARAMETER ( TVEPSI = GAMMIN / 100.D+00 )

      COMMON /FKNDAT/ AV0WEL,     APFRMX,     AEFRMX,     AEFRMA,
     &                RDSNUC,     V0WELL (2), PFRMMX (2), EFRMMX (2),
     &                EFRMAV (2), AMNUCL (2), AMNUSQ (2), EBNDNG (2),
     &                VEFFNU (2), ESLOPE (2), PKMNNU (2), EKMNNU (2),
     &                PKMXNU (2), EKMXNU (2), EKMNAV (2), EKINAV (2),
     &                EXMNAV (2), EKUPNU (2), EXMNNU (2), EXUPNU (2),
     &                ERCLAV (2), ESWELL (2), FINCUP (2), AMRCAV    ,
     &                AMRCSQ    , ATO1O3    , ZTO1O3    , ELBNDE (0:100)

c
c  The following parameters control the minimum energy per nucleon (MeV)
c  to allow for a full N body (N>2) decay (50 keV/nucleon):
      PARAMETER ( ENCMNA = 1.D-02 )
      PARAMETER ( ENCMNB = 5.D-02 )
c  The following parameter control the minimum probability for a
c  "possible" break up channel. It is a dimensional number!
      PARAMETER ( PRCHMN = 2.D-02 )
c  The following parameter control the Coulomb barrier penetrability
c  A zero value implies a sharp Barrier. The following value, 1 MeV, is
c  consistent with Botvina's fit:
      PARAMETER ( EKBRMN = ONEONE )
c  The following parameter must be >= of the maximum number of break-up
c  channels among all nuclei for which they are tabulated:
      PARAMETER ( MXBRCH = 6000 )
c  The following parameter must be =< NCYCMX+2 where NCYCMX is the
c  parameter defined in EXPLOD, and of course must be >= MXFFBK
c  Actually it must be >= mxffbk+2 because of (possibly) two 8-Be
c  fragments to be decayed or other unstable particle decays
      PARAMETER ( MXFBFR = MXFFBK + 6 )
      DIMENSION PXEXPL (MXFBFR), PYEXPL (MXFBFR), PZEXPL (MXFBFR),
     &          ETEXPL (MXFBFR), AMEXPL (MXFBFR), KPEXPL (MXFBFR),
     &          KPHELP (MXFBFR)
      DIMENSION PXCHRG (MXFFBK), PYCHRG (MXFFBK), PZCHRG (MXFFBK),
     &          ETCHRG (MXFFBK), AMCHRG (MXFFBK)
      DIMENSION PRFBCH (0:MXBRCH), KP8BEF (2), SMOM1 (6)
      LOGICAL LOKFBK, LGDCHN
c
      LFRGMN = .FALSE.
      INRES  = IARES - IZRES
c  +-------------------------------------------------------------------*
c  |  Check if it is a meaningful residual nucleus:
      IF ( INRES .LT. 0 .OR. IZRES .LT. 0 .OR. IARES .LE. 0 ) THEN
         WRITE (ErrorOut,*)
     &   ' *** FRMBRK CALLED WITH A NONSENSE RESIDUAL NUCLEUS ',
     &         IARES, IZRES,' ***'
         STOP 'STOP:FRMBRK-IARES-IZRES-INRES'
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Just a bag of protons/neutrons:
      IF ( INRES .EQ. 0 .OR. IZRES .EQ. 0 ) THEN
c  |  +----------------------------------------------------------------*
c  |  |  The number of nucleons exceeds the usual max. n. of fragments
         IF ( IARES .GT. MXFFBK ) THEN
c  |  |  +-------------------------------------------------------------*
c  |  |  |  We can still try to "explod" the bag:
            IF ( IARES .LE. MIN ( MXFBFR, MXFFBK + 2 ) ) THEN
               WRITE (ErrorOut,*)
     &         ' *** FRMBRK: WE ARE DEALING WITH A BAG OF ', IARES,
     &         ' IDENTICAL NUCLEONS, GO ON FOLKS! ***'
               WRITE (ErrorOut,*)
     &         ' *** FRMBRK: WE ARE DEALING WITH A BAG OF ', IARES,
     &         ' IDENTICAL NUCLEONS, GO ON FOLKS! ***'
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  No chance "explod" the bag:
            ELSE
               WRITE (ErrorOut,*)
     &         ' *** FRMBRK: A BAG OF ', IARES,
     &         ' IDENTICAL NUCLEONS, CANNOT BE MANAGED ***'
               WRITE (ErrorOut,*)
     &         ' *** FRMBRK: A BAG OF ', IARES,
     &         ' IDENTICAL NUCLEONS, CANNOT BE MANAGED ***'
               LOKFBK = .FALSE.
               RETURN
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         LOKFBK = .TRUE.
         ETOTCM = AMRESD + EXCRES
         GAMCMS = ( ETOTCM + EKRES ) / ETOTCM
         ETAX   = PXRES / ETOTCM
         ETAY   = PYRES / ETOTCM
         ETAZ   = PZRES / ETOTCM
         NPEXPL = IARES
c  |  +----------------------------------------------------------------*
c  |  |  Proton "bag"
         IF ( IZRES .GT. 0 ) THEN
            KP0 = 2
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Neutron "bag"
         ELSE
            KP0 = 1
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         AMTOT  = ZERZER
c  |  +----------------------------------------------------------------*
c  |  |
         DO 200 KP = 1, IARES
            KPEXPL (KP) = KP0
            AMEXPL (KP) = AMFRBK (KPEXPL(KP))
            AMTOT  = AMTOT + AMEXPL (KP)
  200    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
         ETOTEX = ETOTCM
c  |  +----------------------------------------------------------------*
c  |  |  Print an error message and stop:
         IF ( AMTOT .GT. ONEPLS * ETOTEX ) THEN
            WRITE (ErrorOut,*)
     &      ' *** FRMBRK: NEUTRON/PROTON BAG, TOTAL ENERGY < MASS!!',
     &            ETOTEX, AMTOT, IARES, IZRES, NPEXPL,
     &            (AMEXPL (I), I=1,NPEXPL)
            WRITE (ErrorOut,*)
     &      ' *** FRMBRK: NEUTRON/PROTON BAG, TOTAL ENERGY < MASS!!',
     &            ETOTEX, AMTOT, IARES, IZRES, NPEXPL,
     &            (AMEXPL (I), I=1,NPEXPL)
            STOP 'STOP:FRMBRK-AMTOT-ETOTEX-BAG'
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Practically no energy available:
         ELSE IF ( AMTOT .GE. ONEMNS * ETOTEX ) THEN
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Split just into Npexpl neutrons/protons at rest:
            DO 300 KP = 1, NPEXPL
               ETEXPL (KP) = AMEXPL (KP)
               PXEXPL (KP) = ZERZER
               PYEXPL (KP) = ZERZER
               PZEXPL (KP) = ZERZER
  300       CONTINUE
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Make the explosion:
         ELSE
            CALL DT_EXPLOD( NPEXPL, AMEXPL, ETOTEX, ETEXPL, PXEXPL,
     &                    PYEXPL, PZEXPL )
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         GO TO 8000
c  |
c  +-------------------------------------------------------------------*
c  |  No chance to explod this residual nucleus, because of too many
c  |  neutrons/protons:
      ELSE IF ( INRES .GT. NXNFBK .OR. IZRES .GT. NXZFBK ) THEN
         LOKFBK = .FALSE.
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |  Possible break-up:
      ELSE
c  |  Compute the indeces pointing to the break-up channels for this
c  |  residual nucleus
         IFB1   = IFBIND (INRES,IZRES,1)
         IFB2   = IFBIND (INRES,IZRES,2)
c  |  +----------------------------------------------------------------*
c  |  |  No break up channel available for this Z-A combination:
         IF ( IFB2 .LT. IFB1 ) THEN
            LOKFBK = .FALSE.
            RETURN
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         LOKFBK = .TRUE.
      END IF
c  |
c  +-------------------------------------------------------------------*
      ARES   = IARES
      ZRES   = IZRES
      ETOTCM = AMRESD + EXCRES
      GAMCMS = ( ETOTCM + EKRES ) / ETOTCM
      ETAX   = PXRES / ETOTCM
      ETAY   = PYRES / ETOTCM
      ETAZ   = PZRES / ETOTCM
c  Total (atomic/nuclear) mass excess:
      EEXRES = ETOTCM - ARES * AMUFBK
      PRFBCH (0) = ZERZER
      LGDCHN = .FALSE.
      NFBCH  = 0
      IZRCH  = 0
      IZRMX  = MAX ( 8, ( IFB2 - IFB1 ) / 10 )
c  +-------------------------------------------------------------------*
c  |  Loop over all possible break-up channels
      DO 2000 IFB = IFB1, IFB2
         EKQREA = EEXRES - EXFRBK (IFB)
c  |  +----------------------------------------------------------------*
c  |  |  Energetically impossible
         IF ( EKQREA .LE. ANGLGB ) THEN
c  |  |  Probability for the given channel:
            WFBCH  = ZERZER
c  |  |  If Coulomb barrier is included in the ordering procedure
c  |  |  in Frbkin:
c           IZRCH  = IZRCH + 1
c           IF ( IZRCH .GT. IZRMX ) GO TO 2200
c           NFBCH  = NFBCH + 1
c  |  |  If Coulomb barrier is excluded in the ordering procedure
c  |  |  in Frbkin:
            GO TO 2200
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Energetically possible:
         ELSE
c  |  |  +-------------------------------------------------------------*
c  |  |  |  No barrier:
            IF ( COUFBK (IFB) .LE. ANGLGB ) THEN
               EKAVAI = EKQREA
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  With barrier
            ELSE
               EKAVAI = EKQREA - COUFBK (IFB)
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Sub-barrier region (starts at ekbrmn MeV above the
c  |  |  |  |  nominal barrier):
               IF ( EKAVAI .LT. EKBRMN ) THEN
                  EKAVAI = EKAVAI - EKBRMN
                  ALPHAB = 0.869D+00 + 9.91D+00 / ( ZRES - ONEONE )
                  EKAVAI = MIN ( EKQREA, EKBRMN ) * EXP ( ALPHAB*EKAVAI)
               END IF
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
            NFBCH  = NFBCH + 1
c  |  |  Break up channel multiplicity:
            MFBCH  = IFBCHA (5,IFB)
            EFBCH  = 1.5D+00 * DBLE (MFBCH) - 2.5D+00
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Check for a possible "compound elastic":
            IF ( MFBCH .EQ. 2 .AND. IFBCHA (4,IFB) .EQ. IFBFRB ) THEN
               EKAVAI = ZERZER
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |
            ELSE
               EKAVAI = EKAVAI**EFBCH
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  +-------------------------------------------------------------*
c*sr 30.6.
C*  |  |  |  Probability for the given channel:
C            IF ( EKAVAI .GT. PRCHMN ) THEN
c  |  |  |  Probability for the given channel: 8-C is a problem, be sure
c  |  |  |  to fragment it!
            IF ( EKAVAI .GT. PRCHMN .OR. IARES .LE. 4 .OR. ( IARES .EQ.
     &           8 .AND. IZRES .EQ. 6 ) ) THEN
c*
               WFBCH  = SDMFBK (IFB) * EKAVAI
               LGDCHN = .TRUE.
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Too small probability (avoid to select situations well below
c  |  |  |  barriers with no actual probability). Please note that
c  |  |  |  PRCHMN is dependent on the unit used for energy, the present
c  |  |  |  one is consistent for MeV.
            ELSE
               WFBCH  = ZERZER
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         PRFBCH (NFBCH) = PRFBCH (NFBCH-1) + WFBCH
 2000 CONTINUE
c  |
c  +-------------------------------------------------------------------*
 2200 CONTINUE
c  +-------------------------------------------------------------------*
c  |  Apparently no channel is open:
      IF ( .NOT. LGDCHN ) THEN
c  |  +----------------------------------------------------------------*
c  |  |  Check if this residual nucleus is in the "particle stable" list
         IF ( INRES .LE. MXNFBK .AND. IZRES .LE. MXZFBK ) THEN
            IPS1 = IPSIND (INRES,IZRES,1)
            IPS2 = IPSIND (INRES,IZRES,2)
c  |  |  +-------------------------------------------------------------*
c  |  |  |  No particle stable state available for this A-Z
            IF ( IPS1 .GT. IPS2 ) THEN
               ISTRES = -1
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  For A=17 the indeces are there but of course no stable
c  |  |  |  |  state is actually recorded! Trust the code and set them
c  |  |  |  |  as particle stable (no break up channel appears to be
c  |  |  |  |  open)
               IF ( IARES .GT. MXAFBK ) THEN
                  ISTRES = 0
               END IF
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Check the particle stability of the lowest energy state
c  |  |  |  of A-Z
            ELSE
               ISTRES = IFBKST (IPS1)
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  +-------------------------------------------------------------*
c  |  |  |  No particle stable state available for this A-Z: why it was
c  |  |  |  impossible to select a break up combination? A very good
c  |  |  |  answer is because of barrier effects, in such a case
c  |  |  |  consider the nucleus on the ground state (even though it is
c  |  |  |  not exactly on it) and go to particle unstable nuclei decay:
            IF ( ISTRES .GE. 2 .AND. ISTRES .LT. 900 ) THEN
               NPEXPL = 1
               KPEXPL (1) = IPS1
               AMEXPL (1) = ETOTCM
               ETEXPL (1) = ETOTCM
               PXEXPL (1) = ZERZER
               PYEXPL (1) = ZERZER
               PZEXPL (1) = ZERZER
               N8BEFR = 0
               GO TO 5100
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  No particle stable state available for this A-Z: why it was
c  |  |  |  impossible to select a break up combination? If there
c  |  |  |  barrier effects are not the right answer
            ELSE IF ( ISTRES .NE. 0 ) THEN
               WRITE (ErrorOut,*)
     &         ' *** FRMBRK: UNABLE TO BREAK UP AN UNSTABLE NUCLEUS!',
     &           IARES, IZRES, SNGL (EXCRES),' ***'
               WRITE (ErrorOut,*)
     &         ' *** FRMBRK: UNABLE TO BREAK UP AN UNSTABLE NUCLEUS!',
     &           IARES, IZRES, SNGL (EXCRES),' ***'
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |
         ELSE
            ISTRES = -1
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |  At this point the "final" nucleus is the original one: just check
c  |  whether it is a 8-Be nucleus and return (please note that 8-Be
c  |  even though in an excited state is always split into two alphas):
         IF ( IARES .NE. 8 .OR. IZRES .NE. 4 ) RETURN
c*sr 30.6.
         N8BEFR = 1
         NCHRGD = 2
c*
         NPEXPL = 2
         KPEXPL (1) = 6
         KPEXPL (2) = 6
         AMEXPL (1) = AMFRBK (KPEXPL(1))
         AMEXPL (2) = AMFRBK (KPEXPL(2))
         ETOTEX = ETOTCM
c  |  Make the 8-Be nucleus decay:
         CALL DT_EXPLOD( NPEXPL, AMEXPL, ETOTEX, ETEXPL, PXEXPL,
     &                 PYEXPL, PZEXPL )
c*sr 30.6. (decrease accuracy to avoid error messages on DEC-ultrix)
         ETEPS  = 1.0D3*TENTEN * CSNNRM * ETOTEX
c*
         GO TO 8000
      END IF
c  |
c  +-------------------------------------------------------------------*
      RNBRKP = DT_RNDM(RNBRKP) * PRFBCH (NFBCH)
c  +-------------------------------------------------------------------*
c  |  Loop over the possible break up channels:
      DO 3000 KFB = 1, NFBCH
c  |  +----------------------------------------------------------------*
c  |  |  The KBth of the available channels has been selected:
         IF ( RNBRKP .LT. PRFBCH (KFB) ) THEN
c  |  |  Compute the break up index:
            IFB = KFB + IFB1 - 1
            GO TO 3200
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
 3000 CONTINUE
      STOP 'STOP:FRMBRK-NO-SELECTED-CHANNEL'
 3200 CONTINUE
c  |
c  +-------------------------------------------------------------------*
      NPEXPL = IFBCHA (5,IFB)
      KPCURR = IFBCHA (4,IFB)
      KPEXPL (1) = IFBCHA (3,IFB)
      INCK   = IFRBKN (KPEXPL(1))
      IZCK   = IFRBKZ (KPEXPL(1))
c  +-------------------------------------------------------------------*
c  |  Just two "stable" particles:
      IF ( KPCURR .GT. 0 ) THEN
         KPEXPL (2) = KPCURR
         INCK = INCK + IFRBKN (KPEXPL(2))
         IZCK = IZCK + IFRBKZ (KPEXPL(2))
c  |
c  +-------------------------------------------------------------------*
c  |  The second one is a "composite" particle:
      ELSE
         JB = 1
c  |  +----------------------------------------------------------------*
c  |  |  Loop until only "stable" particles are left:
 3400    CONTINUE
            KPCURR = -KPCURR
            JB     = JB + 1
            KPEXPL (JB) = IFBCHA (3,KPCURR)
            INCK   = INCK + IFRBKN (KPEXPL(JB))
            IZCK   = IZCK + IFRBKZ (KPEXPL(JB))
            KPCURR = IFBCHA (4,KPCURR)
         IF ( KPCURR .LT. 0 ) GO TO 3400
c  |  |  Still a composite particle:
c  |  +----------------------------------------------------------------*
         JB     = JB + 1
         KPEXPL (JB) = KPCURR
         INCK   = INCK + IFRBKN (KPEXPL(JB))
         IZCK   = IZCK + IFRBKZ (KPEXPL(JB))
         IF ( JB .NE. NPEXPL ) STOP 'STOP:FRMBRK-NPEXPL-JB'
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Check charge and baryon number conservation:
      IF ( INCK .NE. INRES .OR. IZCK .NE. IZRES ) THEN
         WRITE (ErrorOut,*)' *** Frmbrk:Inres,Inck,Izres,Izck',
     &                                INRES,INCK,IZRES,IZCK
         WRITE (ErrorOut,
     * *)' *** Frmbrk:Npexpl,(Kpexpl(jb),jb=1,npexpl)',
     &                                NPEXPL,(KPEXPL(JB),JB=1,NPEXPL)
         STOP 'STOP:FRMBRK-INCK-IZCK'
      END IF
c  |
c  +-------------------------------------------------------------------*
      CALL DT_IORDIN( KPEXPL, KPHELP, NPEXPL )
      NCHRGD = 0
      N8BEFR = 0
      AMTOT  = ZERZER
c  +-------------------------------------------------------------------*
c  |  Select masses and look for charged particles (and possibly
c  |  for 8-Be):
      DO 4000 KP = 1, NPEXPL
         AMEXPL (KP) = AMFRBK (KPEXPL(KP))
         KPHELP (KP) = IFRBKZ (KPEXPL(KP))
c  |  +----------------------------------------------------------------*
c  |  |  Look for charged particles and 8-Be:
         IF ( KPHELP (KP) .GT. 0 ) THEN
            NCHRGD = NCHRGD + 1
            IF ( KPHELP (KP) .EQ. 4 .AND. IFRBKN (KPEXPL(KP)) .EQ. 4 )
     &         THEN
               N8BEFR = N8BEFR + 1
               KP8BEF (N8BEFR) = KP
            END IF
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         AMTOT  = AMTOT + AMEXPL (KP)
 4000 CONTINUE
c  |
c  +-------------------------------------------------------------------*
      EKQREA = EEXRES - EXFRBK (IFB)
c  +-------------------------------------------------------------------*
c  |  There are two or more charged particles and anyway there are not
c  |  just two charged particles (in which case plain two body decay
c  |  is perfect):
      IF ( NCHRGD .GT. 1 .AND. NPEXPL .GT. 2 ) THEN
         EKAVAI = EKQREA - COUFBK (IFB)
c  |  +----------------------------------------------------------------*
c  |  |  Sub-barrier region (starts at ekbrmn MeV above the
c  |  |  nominal barrier):
         IF ( EKAVAI .LT. EKBRMN ) THEN
            EKAVAI = EKAVAI - EKBRMN
            ALPHAB = 0.869D+00 + 9.91D+00 / ( ZRES - ONEONE )
            EKAVAI = MIN ( EKQREA, EKBRMN ) * EXP ( ALPHAB * EKAVAI )
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
        EKCOUL = EKQREA - EKAVAI
        ETOTEX = ETOTCM - EKCOUL
c  |
c  +-------------------------------------------------------------------*
c  |
      ELSE
         EKAVAI = EKQREA
         IF ( COUFBK (IFB) .GT. ANGLGB .AND. NCHRGD .LE. 0 )
     &        STOP 'STOP:FRMBRK-COUFBK'
         ETOTEX = ETOTCM
         EKCOUL = ZERZER
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Print an error message and stop:
      IF ( AMTOT .GT. ETOTEX ) THEN
         WRITE (ErrorOut,*)
     &   ' *** FRMBRK: NORMAL EXPLOSION, TOTAL ENERGY < MASS!!',
     &         ETOTEX, AMTOT, EKQREA, IARES, IZRES, NPEXPL,
     &         (AMEXPL (I), I=1,NPEXPL)
         WRITE (ErrorOut,*)
     &   ' *** FRMBRK: NORMAL EXPLOSION, TOTAL ENERGY < MASS!!',
     &         ETOTEX, AMTOT, EKQREA, IARES, IZRES, NPEXPL,
     &         (AMEXPL (I), I=1,NPEXPL)
c  |  +----------------------------------------------------------------*
c  |  |  Print a further error message:
         IF ( EKCOUL .GT. ANGLGB ) THEN
            WRITE (ErrorOut,*)
     &      ' *** EKCOUL, EKAVAI, EKBRMN', EKCOUL, EKAVAI, EKBRMN
            WRITE (ErrorOut,*)
     &      ' *** EKCOUL, EKAVAI, EKBRMN', EKCOUL, EKAVAI, EKBRMN
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         STOP 'STOP:FRMBRK-AMTOT-ETOTEX'
      END IF
c  |
c  +-------------------------------------------------------------------*
      EPERNC = EKAVAI / DBLE (IARES)
c  Omit for the moment:
c     EXPHLP = NPEXPL - 2
      EXPHLP = ONEONE
c  +-------------------------------------------------------------------*
c  |  Energy per nucleon above minimum or 2 particle decay:
      IF ( EPERNC .GE. ENCMNB * EXPHLP .OR. NPEXPL .LE. 2 ) THEN
         ENUCMN = ZERZER
         EXPHLP = ONEONE
c  |
c  +-------------------------------------------------------------------*
c  |  Energy per nucleon below any reasonable minimum
      ELSE IF ( EPERNC .LE. ENCMNA * EXPHLP ) THEN
         ENUCMN = ENCMNA * EXPHLP
c  |
c  +-------------------------------------------------------------------*
c  |
      ELSE
         PRNCMN = ( EPERNC / EXPHLP - ENCMNA ) / ( ENCMNB - ENCMNA )
         IF ( DT_RNDM(PRNCMN) .LT. PRNCMN ) THEN
            ENUCMN = ENCMNA
         ELSE
            ENUCMN = ENCMNB
         END IF
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  If the energy per nucleon is very small, set the largest mass
c  |  fragment at rest, and explod the others:
      IF ( EPERNC / EXPHLP .LT. ENUCMN .AND. NPEXPL .GT. 2 ) THEN
         MPEXPL = NPEXPL
         ETOTHL = ETOTEX
         IAHLP  = IARES
         KCHRGD = NCHRGD
 4100    CONTINUE
            IF ( KPHELP (MPEXPL) .GT. 0 ) KCHRGD = KCHRGD - 1
            ETEXPL (MPEXPL) = AMEXPL (MPEXPL)
            PXEXPL (MPEXPL) = ZERZER
            PYEXPL (MPEXPL) = ZERZER
            PZEXPL (MPEXPL) = ZERZER
            IAHLP  = IAHLP  - IFRBKN (KPEXPL(MPEXPL))
     &             - IFRBKZ (KPEXPL(MPEXPL))
            ETOTHL = ETOTHL - AMEXPL (MPEXPL)
            MPEXPL = MPEXPL - 1
c  |  Omit for the moment:
c           EXPHLP = MAX ( 1, MPEXPL - 2 )
            EXPHLP = ONEONE
            EPERNC = EKAVAI / DBLE (IAHLP)
         IF ( MPEXPL .GT. 2 .AND. EPERNC / EXPHLP .LT. ENUCMN
     &        .AND. ( KCHRGD .GT. 2 .OR. NCHRGD .LE. 1 ) )
     &      GO TO 4100
c  |  Make the explosion:
         CALL DT_EXPLOD( MPEXPL, AMEXPL, ETOTHL, ETEXPL, PXEXPL, PYEXPL,
     &                 PZEXPL )
c  |
c  +-------------------------------------------------------------------*
c  |  Make the explosion:
      ELSE
         CALL DT_EXPLOD( NPEXPL, AMEXPL, ETOTEX, ETEXPL, PXEXPL, PYEXPL,
     &                 PZEXPL )
      END IF
c  |
c  +-------------------------------------------------------------------*
c*sr 19.5.95 decrease accuracy to avoid error messages on DEC-ultrix
C     ETEPS  = TENTEN * CSNNRM * ETOTEX
      ETEPS  = 1.0D3*TENTEN * CSNNRM * ETOTEX
c*
c  +-------------------------------------------------------------------*
c  |  There are two or more charged particles:
      IF ( NCHRGD .GT. 1 .AND. EKCOUL .GT. ANGLGB ) THEN
         ECHRGD = ZERZER
         PXTCHR = ZERZER
         PYTCHR = ZERZER
         PZTCHR = ZERZER
         ICHRGD = 0
c  |  +----------------------------------------------------------------*
c  |  |  Select masses and look for charged particles
         DO 4200 KP = 1, NPEXPL
            AMEXPL (KP) = AMFRBK (KPEXPL(KP))
            KPHELP (KP) = IFRBKZ (KPEXPL(KP))
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Record charged particles:
            IF ( KPHELP (KP) .GT. 0 ) THEN
               ICHRGD = ICHRGD + 1
               ECHRGD = ECHRGD + ETEXPL (KP)
               PXTCHR = PXTCHR + PXEXPL (KP)
               PYTCHR = PYTCHR + PYEXPL (KP)
               PZTCHR = PZTCHR + PZEXPL (KP)
               ETCHRG (ICHRGD) = ETEXPL (KP)
               AMCHRG (ICHRGD) = AMEXPL (KP)
               PXCHRG (ICHRGD) = PXEXPL (KP)
               PYCHRG (ICHRGD) = PYEXPL (KP)
               PZCHRG (ICHRGD) = PZEXPL (KP)
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
 4200    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
         PTCHRG = SQRT ( PXTCHR**2 + PYTCHR**2 + PZTCHR**2 )
         UMCHRG = ( ECHRGD - PTCHRG ) * ( ECHRGD + PTCHRG )
         UMCHRG = SQRT (UMCHRG)
         GAMCHR = ECHRGD / UMCHRG
         ETACHX = PXTCHR / UMCHRG
         ETACHY = PYTCHR / UMCHRG
         ETACHZ = PZTCHR / UMCHRG
         ECHCK  = UMCHRG
         PXCHCK = ZERZER
         PYCHCK = ZERZER
         PZCHCK = ZERZER
c  |  +----------------------------------------------------------------*
c  |  |  Make the transformation to the charged particle CMS:
         DO 4400 I = 1, NCHRGD
            ETAPCM     = ETACHX * PXCHRG (I) + ETACHY * PYCHRG (I)
     &                 + ETACHZ * PZCHRG (I)
            PHELP      = ETCHRG (I) - ETAPCM / ( GAMCHR + ONEONE )
            ETCHRG (I) = GAMCHR * ETCHRG (I) - ETAPCM
            PXCHRG (I) = PXCHRG (I) - ETACHX * PHELP
            PYCHRG (I) = PYCHRG (I) - ETACHY * PHELP
            PZCHRG (I) = PZCHRG (I) - ETACHZ * PHELP
            ECHCK  = ECHCK  - ETCHRG (I)
            PXCHCK = PXCHCK - PXCHRG (I)
            PYCHCK = PYCHCK - PYCHRG (I)
            PZCHCK = PZCHCK - PZCHRG (I)
 4400    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
c  |  +----------------------------------------------------------------*
c  |  |  Check energy and momentum conservation:
         IF ( ABS (ECHCK) + ABS (PXCHCK) + ABS (PYCHCK) + ABS (PZCHCK)
     &        .GT. ETEPS  ) THEN
            WRITE (ErrorOut,*)
     &      ' *** FRMBRK_CMS1:ENERGY OR MOMENTUM CONSERVATION FAILURE:'
            WRITE (ErrorOut,*)
     &            ' NCHRGD,UMCHRG,ECHCK,PXCHCK,PYCHCK,PZCHCK',
     &              NCHRGD,UMCHRG,ECHCK,PXCHCK,PYCHCK,PZCHCK
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |  Now "expand" the energy of the charged particles in their own CMS
c  |  from Umchrg to Umnchr:
         ECHRGD = ECHRGD + EKCOUL
         UMNCHR = ( ECHRGD - PTCHRG ) * ( ECHRGD + PTCHRG )
         UMNCHR = SQRT (UMNCHR)
         DETCMS = UMNCHR - UMCHRG
         CALL DT_ECMSEX( NCHRGD, UMCHRG, DETCMS, AMCHRG, ETCHRG, PXCHRG,
     &                 PYCHRG, PZCHRG )
         GAMCHR = ECHRGD / UMNCHR
         ETACHX = PXTCHR / UMNCHR
         ETACHY = PYTCHR / UMNCHR
         ETACHZ = PZTCHR / UMNCHR
         ECHCK  = ECHRGD
         PXCHCK = PXTCHR
         PYCHCK = PYTCHR
         PZCHCK = PZTCHR
c  |  +----------------------------------------------------------------*
c  |  |  Make the transformation back to the original residual nucleus
c  |  |  CMS:
         DO 4600 I = 1, NCHRGD
            ETAPCM     = ETACHX * PXCHRG (I) + ETACHY * PYCHRG (I)
     &                 + ETACHZ * PZCHRG (I)
            PHELP      = ETCHRG (I) + ETAPCM / ( GAMCHR + ONEONE )
            ETCHRG (I) = GAMCHR * ETCHRG (I) + ETAPCM
            PXCHRG (I) = PXCHRG (I) + ETACHX * PHELP
            PYCHRG (I) = PYCHRG (I) + ETACHY * PHELP
            PZCHRG (I) = PZCHRG (I) + ETACHZ * PHELP
            ECHCK  = ECHCK  - ETCHRG (I)
            PXCHCK = PXCHCK - PXCHRG (I)
            PYCHCK = PYCHCK - PYCHRG (I)
            PZCHCK = PZCHCK - PZCHRG (I)
 4600    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
c  |  +----------------------------------------------------------------*
c  |  |  Check energy and momentum conservation:
         IF ( ABS (ECHCK) + ABS (PXCHCK) + ABS (PYCHCK) + ABS (PZCHCK)
     &        .GT. ETEPS  ) THEN
            WRITE (ErrorOut,*)
     &      ' *** FRMBRK_CMS2:ENERGY OR MOMENTUM CONSERVATION FAILURE:'
            WRITE (ErrorOut,*)
     &            ' NCHRGD,ECHRGD,ECHCK,PXCHCK,PYCHCK,PZCHCK',
     &              NCHRGD,ECHRGD,ECHCK,PXCHCK,PYCHCK,PZCHCK
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         ECHCK  = ETOTCM
         PXCHCK = ZERZER
         PYCHCK = ZERZER
         PZCHCK = ZERZER
         ICHRGD = 0
c  |  +----------------------------------------------------------------*
c  |  |  Put back on stack the transformed charged particles and check
c  |  |  energy and momentum conservation:
         DO 4800 I = 1, NPEXPL
            IF ( KPHELP (I) .GT. 0 ) THEN
               ICHRGD = ICHRGD + 1
               ETEXPL (I) = ETCHRG (ICHRGD)
               PXEXPL (I) = PXCHRG (ICHRGD)
               PYEXPL (I) = PYCHRG (ICHRGD)
               PZEXPL (I) = PZCHRG (ICHRGD)
            END IF
            ECHCK  = ECHCK  - ETEXPL (I)
            PXCHCK = PXCHCK - PXEXPL (I)
            PYCHCK = PYCHCK - PYEXPL (I)
            PZCHCK = PZCHCK - PZEXPL (I)
 4800    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
         IF ( ICHRGD .NE. NCHRGD ) STOP 'STOP:FRMBRK-ICHRGD-NCHRGD'
c  |  +----------------------------------------------------------------*
c  |  |  Check energy and momentum conservation:
         IF ( ABS (ECHCK) + ABS (PXCHCK) + ABS (PYCHCK) + ABS (PZCHCK)
     &        .GT. ETEPS  ) THEN
            WRITE (ErrorOut,*)
     &      ' *** FRMBRK_CH1:ENERGY OR MOMENTUM CONSERVATION FAILURE:'
            WRITE (ErrorOut,*)
     &            ' NPEXPL,ETOTEX,ECHCK,PXCHCK,PYCHCK,PZCHCK',
     &              NPEXPL,ETOTEX,ECHCK,PXCHCK,PYCHCK,PZCHCK
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Let possible 8-Be fragments decay (even though excited):
      DO 5000 IB = 1, N8BEFR
         KP     = KP8BEF (IB)
c        PTCHRG = SQRT ( PXEXPL (KP)**2 + PYEXPL (KP)**2
c    &          + PZEXPL (KP)**2 )
c        UMCHRG = ( ETEXPL (KP) - PTCHRG ) * ( ETEXPL (KP) + PTCHRG )
c        UMCHRG = SQRT (UMCHRG)
         UMCHRG = AMEXPL (KP)
         GAMCHR = ETEXPL (KP) / UMCHRG
         ETACHX = PXEXPL (KP) / UMCHRG
         ETACHY = PYEXPL (KP) / UMCHRG
         ETACHZ = PZEXPL (KP) / UMCHRG
c  |  Transform the 8-Be nucleus into the first alpha:
         KPEXPL (KP) = 6
         AMEXPL (KP) = AMFRBK (KPEXPL(KP))
         ETCMS  = HLFHLF * UMCHRG
         PTCMS  = SQRT ( ( ETCMS - AMEXPL (KP) )
     &                 * ( ETCMS + AMEXPL (KP) ) )
         CALL DT_RACO( PXCMS, PYCMS, PZCMS )
         PXCMS  = PTCMS * PXCMS
         PYCMS  = PTCMS * PYCMS
         PZCMS  = PTCMS * PZCMS
         ETAPCM = ETACHX * PXCMS + ETACHY * PYCMS + ETACHZ * PZCMS
         PHELP  = ETCMS  + ETAPCM / ( GAMCHR + ONEONE )
         ETEXPL (KP) = GAMCHR * ETCMS + ETAPCM
         PXEXPL (KP) = PXCMS + ETACHX * PHELP
         PYEXPL (KP) = PYCMS + ETACHY * PHELP
         PZEXPL (KP) = PZCMS + ETACHZ * PHELP
c  |  New Alpha:
         NPEXPL = NPEXPL + 1
         KP     = NPEXPL
         KPEXPL (KP) = 6
         AMEXPL (KP) = AMFRBK (KPEXPL(KP))
         ETAPCM = - ETAPCM
         PHELP  = ETCMS  + ETAPCM / ( GAMCHR + ONEONE )
         ETEXPL (KP) = GAMCHR * ETCMS + ETAPCM
         PXEXPL (KP) =-PXCMS + ETACHX * PHELP
         PYEXPL (KP) =-PYCMS + ETACHY * PHELP
         PZEXPL (KP) =-PZCMS + ETACHZ * PHELP
 5000 CONTINUE
c  |
c  +-------------------------------------------------------------------*
 5100 CONTINUE
      NUNSTB = 0
      KP     = 1
c  +-------------------------------------------------------------------*
c  |  Now look for (possible) particle unstable states:
 5500 CONTINUE
c  |  +----------------------------------------------------------------*
c  |  |  Look for possible 8-Be created by particle unstable state
c  |  |  decays:
         IF ( IFRBKZ (KPEXPL(KP)) .EQ. 4 .AND. IFRBKN (KPEXPL(KP))
     &        .EQ. 4 ) THEN
            KPDECY = 6
            KPREMN = 6
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Particle stable state:
         ELSE IF ( IFBKST (KPEXPL(KP)) .EQ. 0 ) THEN
            GO TO 7000
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Particle unstable state:
         ELSE
            IF ( IFBKST (KPEXPL(KP)) .LT. -900 )
     &         STOP 'STOP:FRMBRK-UNSTABLE'
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Three body decay
            IF ( IFBKST (KPEXPL(KP)) .GT. 10 ) THEN
               KPDECY = MOD (IFBKST(KPEXPL(KP)),10)
               KPDCY2 = ( IFBKST (KPEXPL(KP)) - KPDECY ) / 10
c  |  |  |  Now determine the identity of the "heavy" remnant: it
c  |  |  |  should be chosen among the accessible levels of the given
c  |  |  |  Z,A according to the standard phase space and barrier consi-
c  |  |  |  deration, however for the moment the ground state is always
c  |  |  |  selected
               INREMN = IFRBKN (KPEXPL(KP)) - IFRBKN (KPDECY)
     &                - IFRBKN (KPDCY2)
               IZREMN = IFRBKZ (KPEXPL(KP)) - IFRBKZ (KPDECY)
     &                - IFRBKZ (KPDCY2)
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Two body:
c  |  |  |  This should be the identity of the lightest decay product:
            ELSE
               KPDECY = ABS (IFBKST(KPEXPL(KP)))
               KPDCY2 = 0
c  |  |  |  Now determine the identity of the "heavy" remnant: it
c  |  |  |  should be chosen among the accessible levels of the given
c  |  |  |  Z,A according to the standard phase space and barrier consi-
c  |  |  |  deration, however for the moment the ground state is always
c  |  |  |  selected
               INREMN = IFRBKN (KPEXPL(KP)) - IFRBKN (KPDECY)
               IZREMN = IFRBKZ (KPEXPL(KP)) - IFRBKZ (KPDECY)
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
            IPS1   = IPSIND (INREMN,IZREMN,1)
            IPS2   = IPSIND (INREMN,IZREMN,2)
c  |  |  No particle stable state available for this A-Z
            IF ( IPS1 .GT. IPS2 ) STOP 'STOP:FRMBRK-ABSURD-DECAY'
c  |  |  Take the ground state: of course this procedure is not very
c  |  |  correct, one should decide according to phase space etc.
c  |  |  considerations among the accessible excited states, but
c  |  |  spin/parity selection rules should be taken into account, so...
            KPREMN = IPS1
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         NUNSTB = NUNSTB + 1
         UMCHRG = AMEXPL (KP)
         GAMCHR = ETEXPL (KP) / UMCHRG
         ETACHX = PXEXPL (KP) / UMCHRG
         ETACHY = PYEXPL (KP) / UMCHRG
         ETACHZ = PZEXPL (KP) / UMCHRG
c  |  +----------------------------------------------------------------*
c  |  |  Two body:
         IF ( KPDCY2 .EQ. 0 ) THEN
c  |  |  Transform the unstable nucleus into the light decay fragment:
            KPEXPL (KP) = KPDECY
            AMEXPL (KP) = AMFRBK (KPEXPL(KP))
c  |  |  Heavy fragment:
            NPEXPL = NPEXPL + 1
            LP     = NPEXPL
            KPEXPL (LP) = KPREMN
            AMEXPL (LP) = AMFRBK (KPEXPL(LP))
            ETCMS  = HLFHLF * ( UMCHRG + ( AMEXPL (KP) - AMEXPL (LP) )
     &             * ( AMEXPL (KP) + AMEXPL (LP) ) / UMCHRG )
            PTCMS  = SQRT ( ( ETCMS - AMEXPL (KP) )
     &                    * ( ETCMS + AMEXPL (KP) ) )
            CALL DT_RACO( PXCMS, PYCMS, PZCMS )
            PXCMS  = PTCMS * PXCMS
            PYCMS  = PTCMS * PYCMS
            PZCMS  = PTCMS * PZCMS
            ETAPCM = ETACHX * PXCMS + ETACHY * PYCMS + ETACHZ * PZCMS
            PHELP  = ETCMS  + ETAPCM / ( GAMCHR + ONEONE )
            ETEXPL (KP) = GAMCHR * ETCMS + ETAPCM
            PXEXPL (KP) = PXCMS + ETACHX * PHELP
            PYEXPL (KP) = PYCMS + ETACHY * PHELP
            PZEXPL (KP) = PZCMS + ETACHZ * PHELP
c  |  |  Now the heavy fragment:
            ETCMS  = UMCHRG - ETCMS
            ETAPCM = - ETAPCM
            PHELP  = ETCMS  + ETAPCM / ( GAMCHR + ONEONE )
            ETEXPL (LP) = GAMCHR * ETCMS + ETAPCM
            PXEXPL (LP) =-PXCMS + ETACHX * PHELP
            PYEXPL (LP) =-PYCMS + ETACHY * PHELP
            PZEXPL (LP) =-PZCMS + ETACHZ * PHELP
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Three body:
         ELSE
c  |  |  Transform the unstable nucleus into the light decay fragment:
            KPEXPL (KP) = KPDECY
            AMEXPL (KP) = AMFRBK (KPEXPL(KP))
            NPEXPL = NPEXPL + 2
            MP     = NPEXPL - 1
            LP     = NPEXPL
c  |  |  Second light decay fragment:
            KPEXPL (MP) = KPDCY2
            AMEXPL (MP) = AMFRBK (KPEXPL(MP))
c  |  |  Heavy fragment:
            KPEXPL (LP) = KPREMN
            AMEXPL (LP) = AMFRBK (KPEXPL(LP))
            AMCHRG (1)  = AMEXPL (KP)
            AMCHRG (2)  = AMEXPL (MP)
            AMCHRG (3)  = AMEXPL (LP)
            ETOTHL      = UMCHRG
c  |  |  Make the three body decay:
            CALL DT_EXPLOD(      3, AMCHRG, ETOTHL, ETCHRG, PXCHRG,
     &                    PYCHRG, PZCHRG )
c  |  |  First light fragment:
            ETAPCM = ETACHX * PXCHRG (1) + ETACHY * PYCHRG (1)
     &             + ETACHZ * PZCHRG (1)
            PHELP  = ETCHRG (1) + ETAPCM / ( GAMCHR + ONEONE )
            ETEXPL (KP) = GAMCHR * ETCHRG (1) + ETAPCM
            PXEXPL (KP) = PXCHRG (1) + ETACHX * PHELP
            PYEXPL (KP) = PYCHRG (1) + ETACHY * PHELP
            PZEXPL (KP) = PZCHRG (1) + ETACHZ * PHELP
c  |  |  Second light fragment:
            ETAPCM = ETACHX * PXCHRG (2) + ETACHY * PYCHRG (2)
     &             + ETACHZ * PZCHRG (2)
            PHELP  = ETCHRG (2) + ETAPCM / ( GAMCHR + ONEONE )
            ETEXPL (MP) = GAMCHR * ETCHRG (2) + ETAPCM
            PXEXPL (MP) = PXCHRG (2) + ETACHX * PHELP
            PYEXPL (MP) = PYCHRG (2) + ETACHY * PHELP
            PZEXPL (MP) = PZCHRG (2) + ETACHZ * PHELP
c  |  |  Now the heavy fragment:
            ETAPCM = ETACHX * PXCHRG (3) + ETACHY * PYCHRG (3)
     &             + ETACHZ * PZCHRG (3)
            PHELP  = ETCHRG (3) + ETAPCM / ( GAMCHR + ONEONE )
            ETEXPL (LP) = GAMCHR * ETCHRG (3) + ETAPCM
            PXEXPL (LP) = PXCHRG (3) + ETACHX * PHELP
            PYEXPL (LP) = PYCHRG (3) + ETACHY * PHELP
            PZEXPL (LP) = PZCHRG (3) + ETACHZ * PHELP
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
 7000    CONTINUE
         KP = KP + 1
      IF ( KP .LE. NPEXPL ) GO TO 5500
c  |
c  +-------------------------------------------------------------------*
 8000 CONTINUE
      ECHCK  = ETOTCM + EKRES
      PXCHCK = PXRES
      PYCHCK = PYRES
      PZCHCK = PZRES
      NONEVP = 0
c  +-------------------------------------------------------------------*
c  |  Make the transformation to the lab system of all produced
c  |  particles:
      DO 8200 I = 1, NPEXPL
         ETAPCM     = ETAX * PXEXPL (I) + ETAY * PYEXPL (I)
     &              + ETAZ * PZEXPL (I)
         PHELP      = ETEXPL (I) + ETAPCM / ( GAMCMS + ONEONE )
         ETEXPL (I) = GAMCMS * ETEXPL (I) + ETAPCM
         PXEXPL (I) = PXEXPL (I) + ETAX * PHELP
         PYEXPL (I) = PYEXPL (I) + ETAY * PHELP
         PZEXPL (I) = PZEXPL (I) + ETAZ * PHELP
         IF ( KPEXPL (I) .GT. 6 ) THEN
            NONEVP = NONEVP + 1
            INOEVP = I
         END IF
         ECHCK  = ECHCK  - ETEXPL (I)
         PXCHCK = PXCHCK - PXEXPL (I)
         PYCHCK = PYCHCK - PYEXPL (I)
         PZCHCK = PZCHCK - PZEXPL (I)
 8200 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Check energy and momentum conservation:
      IF ( ABS (ECHCK) + ABS (PXCHCK) + ABS (PYCHCK) + ABS (PZCHCK)
     &     .GT. ETEPS  ) THEN
         WRITE (ErrorOut,*)
     &   ' *** FRMBRK:ENERGY OR MOMENTUM CONSERVATION FAILURE:'
         WRITE (ErrorOut,*)
     &' NPEXPL,NCHRGD,N8BEFR,NUNSTB,ETOTEX,ECHCK,PXCHCK,PYCHCK,PZCHCK',
     &  NPEXPL,NCHRGD,N8BEFR,NUNSTB,ETOTEX,ECHCK,PXCHCK,PYCHCK,PZCHCK
         WRITE (ErrorOut,*)' Iares,Izres,',IARES,IZRES
         DO 8300 KP = 1, NPEXPL
            WRITE (ErrorOut,*)' Nfrgm,Infrg,Izfrg,',KP,
     &                        IFRBKN(KPEXPL(KP)),IFRBKZ(KPEXPL(KP))
 8300    CONTINUE
      END IF
c  |
c  +-------------------------------------------------------------------*
      ECHCK  = ETOTCM + EKRES
      PXCHCK = PXRES
      PYCHCK = PYRES
      PZCHCK = PZRES
c  +-------------------------------------------------------------------*
c  |  Just one "residual" nucleus plus n,p,d,t,3-He and alphas
      IF ( NONEVP .EQ. 1 ) THEN
         INRES  = IFRBKN (KPEXPL(INOEVP))
         IZRES  = IFRBKZ (KPEXPL(INOEVP))
         IARES  = INRES + IZRES
         ARES   = IARES
         ZRES   = IZRES
         EKRES  = ETEXPL (INOEVP) - AMEXPL (INOEVP)
c  |  Atomic mass of the residual nucleus:
         AMRESD = AMUGEV * GEVMEV * ARES + DT_ENERGY( ARES, ZRES )
         IF ( LNCMSS ) AMRESD = AMRESD - ZRES  * AMELCT * GEVMEV
     &                        + ELBNDE (IZRES) * GEVMEV
         EXCRES = AMEXPL (INOEVP) - AMRESD
         EXCRES = MAX ( EXCRES, ZERZER )
         PXRES  = PXEXPL (INOEVP)
         PYRES  = PYEXPL (INOEVP)
         PZRES  = PZEXPL (INOEVP)
         IF ( IFBKST (KPEXPL(INOEVP)) .EQ. 0 ) THEN
            ISTRES = KPEXPL (INOEVP)
         ELSE
            WRITE (ErrorOut,*)
     &   ' *** FRMBRK: PARTICLE UNSTABLE RES. NUC. LEFT AFTER BREAK UP',
     &         KPEXPL (INOEVP),' ***'
               WRITE (ErrorOut,*)
     &   ' *** FRMBRK: PARTICLE UNSTABLE RES. NUC. LEFT AFTER BREAK UP',
     &         KPEXPL (INOEVP),' ***'
            ISTRES = -1
         END IF
         P2RES  = PXRES * PXRES + PYRES * PYRES + PZRES * PZRES
         PTRES  = SQRT (P2RES)
         COSLBR (1) = PXRES / PTRES
         COSLBR (2) = PYRES / PTRES
         COSLBR (3) = PZRES / PTRES
         ECHCK  = ECHCK  - AMRESD - EXCRES - EKRES
         PXCHCK = PXCHCK - PXRES
         PYCHCK = PYCHCK - PYRES
         PZCHCK = PZCHCK - PZRES
c  |  +----------------------------------------------------------------*
c  |  |  Extract the "residual" nucleus and fill the hole with the
c  |  |  last fragment:
         IF ( INOEVP .NE. NPEXPL ) THEN
            KPEXPL (INOEVP) = KPEXPL (NPEXPL)
            ETEXPL (INOEVP) = ETEXPL (NPEXPL)
            AMEXPL (INOEVP) = AMEXPL (NPEXPL)
            PXEXPL (INOEVP) = PXEXPL (NPEXPL)
            PYEXPL (INOEVP) = PYEXPL (NPEXPL)
            PZEXPL (INOEVP) = PZEXPL (NPEXPL)
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         NPEXPL = NPEXPL - 1
c  |
c  +-------------------------------------------------------------------*
c  |  Or "true" multifragmentation event or just only evaporation
c  |  particles:
      ELSE
c  |  Set up a flag to signal it is a "true" multifragmentation event:
         LFRGMN = NONEVP .GT. 1
         IARES  = 0
         IZRES  = 0
         INRES  = 0
         ISTRES = 0
         AMRESD = ZERZER
         EXCRES = ZERZER
         EKRES  = ZERZER
         PXRES  = ZERZER
         PYRES  = ZERZER
         PZRES  = ZERZER
         PTRES  = ZERZER
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Bank n,p,d,t,3-He and 4-He and possible heavier fragments:
      DO 8600 KP = 1, NPEXPL
         EKIN   = ETEXPL (KP) - AMEXPL (KP)
         PTEXPL = SQRT ( PXEXPL (KP)**2 + PYEXPL (KP)**2
     &                 + PZEXPL (KP)**2 )
c  |  +----------------------------------------------------------------*
c  |  |  "Real" fragment:
         IF ( KPEXPL (KP) .GT. 6 ) THEN
            IF ( NONEVP .LE. 1 ) STOP 'STOP:FRMBRK-NONEVP'
            NFISS            = NFISS + 1
            PPFIS  (NFISS)   = PTEXPL
            EKFIS  (NFISS)   = EKIN
            AFIS   (NFISS)   = IFRBKN (KPEXPL(KP)) + IFRBKZ (KPEXPL(KP))
            ZFIS   (NFISS)   = IFRBKZ (KPEXPL(KP))
c  |  |  Atomic mass of the Fragment (ground state):
            AMFRGM           = AMUGEV * GEVMEV * AFIS (NFISS)
     &                       + DT_ENERGY( AFIS (NFISS), ZFIS (NFISS) )
            IF ( LNCMSS ) AMFRGM = AMFRGM - ( ZFIS (NFISS) * AMELCT
     &                           + ELBNDE (IFRBKZ(KPEXPL(KP)))) * GEVMEV
            AMFIS  (NFISS)   = AMFRBK (KPEXPL(KP))
            UFIS   (NFISS)   = AMFRBK (KPEXPL(KP)) - AMFRGM
            UFIS   (NFISS )  = MAX ( UFIS (NFISS), ZERZER )
            COSLFF (1,NFISS) = PXEXPL (KP) / PTEXPL
            COSLFF (2,NFISS) = PYEXPL (KP) / PTEXPL
            COSLFF (3,NFISS) = PZEXPL (KP) / PTEXPL
            IF ( IFBKST (KPEXPL(KP)) .EQ. 0 ) THEN
               ISTFIS (NFISS) = KPEXPL (KP)
            ELSE
               WRITE (ErrorOut,*)
     &       ' *** FRMBRK: PARTICLE UNSTABLE STATE LEFT AFTER BREAK UP',
     &         KPEXPL (KP),' ***'
               WRITE (ErrorOut,*)
     &       ' *** FRMBRK: PARTICLE UNSTABLE STATE LEFT AFTER BREAK UP',
     &         KPEXPL (KP),' ***'
               ISTFIS (NFISS) = -1
            END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Standard evaporation particles:
         ELSE
            NPART  (KPEXPL(KP)) = NPART (KPEXPL(KP)) + 1
            SMOM1  (KPEXPL(KP)) = SMOM1 (KPEXPL(KP)) + EKIN
            ITEMP  = NPART (KPEXPL(KP))
            EPART  (ITEMP,KPEXPL(KP))   = EKIN
            COSEVP (1,ITEMP,KPEXPL(KP)) = PXEXPL (KP) / PTEXPL
            COSEVP (2,ITEMP,KPEXPL(KP)) = PYEXPL (KP) / PTEXPL
            COSEVP (3,ITEMP,KPEXPL(KP)) = PZEXPL (KP) / PTEXPL
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         ECHCK  = ECHCK  - AMEXPL (KP) - EKIN
         PXCHCK = PXCHCK - PXEXPL (KP)
         PYCHCK = PYCHCK - PYEXPL (KP)
         PZCHCK = PZCHCK - PZEXPL (KP)
 8600 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Check energy and momentum conservation:
      IF ( ABS (ECHCK) + ABS (PXCHCK) + ABS (PYCHCK) + ABS (PZCHCK)
     &     .GT. ETEPS  ) THEN
         WRITE (ErrorOut,*)
     &   ' *** FRMBRK_F:ENERGY OR MOMENTUM CONSERVATION FAILURE:'
         WRITE (ErrorOut,*)
     & ' NPEXPL,NCHRGD,N8BEFR,NUNSTB,ETOTEX,ECHCK,PXCHCK,PYCHCK,PZCHCK',
     &   NPEXPL,NCHRGD,N8BEFR,NUNSTB,ETOTEX,ECHCK,PXCHCK,PYCHCK,PZCHCK
      END IF
c  |
c  +-------------------------------------------------------------------*
c=== End of subroutine Frmbrk =========================================*
      RETURN
      END

c$ CREATE DT_GETA.FOR
cCOPY DT_GETA
c
c=== geta =============================================================*
c
CDECK  ID>, DT_GETA
      DOUBLE PRECISION FUNCTION DT_GETA( U, JZ, JN, MODE, IS, AOGMAX,
     &                                 AOGMIN )

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     Created on 18 january 1993   by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 20-jun-94     by    Alfredo Ferrari               *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: COOKCM)
      PARAMETER ( ASMTOG = SIXSIX / PIPIPI**2 )
      LOGICAL LDEFOZ, LDEFON
      PARAMETER ( INCOOK = 150, IZCOOK = 98 )
      COMMON /FKCOOK/ ALPIGN, BETIGN, GAMIGN, POWIGN,
     &                SZCOOK (IZCOOK), SNCOOK (INCOOK), PZCOOK (IZCOOK),
     &                PNCOOK (INCOOK), LDEFOZ (IZCOOK), LDEFON (INCOOK)

c (original name: EVA0)
      COMMON /FKEVA0/ Y0, B0, P0 (1001), P1 (1001), P2 (1001),
     *                FLA (6), FLZ (6), RHO (6), OMEGA (6), EXMASS (6),
     *                CAM2 (130), CAM3 (200), CAM4 (130), CAM5 (200),
     *                T (4,7), RMASS (297), ALPH (297), BET (297),
     *                APRIME (250), IA (6), IZ (6)

c (original name: NUCLEV)
      LOGICAL LCLVSL, LFLVSL, LRLVSL, LEQSBL
      COMMON /FKNLEV/ PAENUC (200,2), SHENUC (200,2), DEFRMI (2),
     &                DEFMAG (2), ENNCLV (160,2), RANCLV (160,2),
     &                CUMRAD (0:160,2), RUSNUC (2),
     &                ENPLVL (114), ENNLVL(164), JUSNUC (160,2),
     &                NTANUC (2), NAVNUC (2), NLSNUC (2), NCONUC (2),
     &                NSKNUC (2), NHANUC (2), NUSNUC (2), NACNUC (2),
     &                JMXNUC (2), IPRNUC (3), JPRNUC (3), MAGNUM (8),
     &                MAGNUC (2), MGSNUC (8,2), MGSSNC (25,2),
     &                NSBSHL (2), NMNSBS (2), NPRNUC, INUCLV, LCLVSL,
     &                LFLVSL, LRLVSL, LEQSBL
      DIMENSION JUSPRO (160), JUSNEU (160), MGSPRO (8), MGSNEU (8),
     &          MGSSPR (19) , MGSSNE (25)
      EQUIVALENCE ( RUSNUC (1), RUSPRO )
      EQUIVALENCE ( RUSNUC (2), RUSNEU )
      EQUIVALENCE ( JUSNUC (1,1), JUSPRO (1) )
      EQUIVALENCE ( JUSNUC (1,2), JUSNEU (1) )
      EQUIVALENCE ( MGSNUC (1,1), MGSPRO (1) )
      EQUIVALENCE ( MGSNUC (1,2), MGSNEU (1) )
      EQUIVALENCE ( MGSSNC (1,1), MGSSPR (1) )
      EQUIVALENCE ( MGSSNC (1,2), MGSSNE (1) )
      EQUIVALENCE ( NTANUC (1), NTAPRO )
      EQUIVALENCE ( NTANUC (2), NTANEU )
      EQUIVALENCE ( NAVNUC (1), NAVPRO )
      EQUIVALENCE ( NAVNUC (2), NAVNEU )
      EQUIVALENCE ( NLSNUC (1), NLSPRO )
      EQUIVALENCE ( NLSNUC (2), NLSNEU )
      EQUIVALENCE ( NCONUC (1), NCOPRO )
      EQUIVALENCE ( NCONUC (2), NCONEU )
      EQUIVALENCE ( NSKNUC (1), NSKPRO )
      EQUIVALENCE ( NSKNUC (2), NSKNEU )
      EQUIVALENCE ( NHANUC (1), NHAPRO )
      EQUIVALENCE ( NHANUC (2), NHANEU )
      EQUIVALENCE ( NUSNUC (1), NUSPRO )
      EQUIVALENCE ( NUSNUC (2), NUSNEU )
      EQUIVALENCE ( NACNUC (1), NACPRO )
      EQUIVALENCE ( NACNUC (2), NACNEU )
      EQUIVALENCE ( JMXNUC (1), JMXPRO )
      EQUIVALENCE ( JMXNUC (2), JMXNEU )
      EQUIVALENCE ( MAGNUC (1), MAGPRO )
      EQUIVALENCE ( MAGNUC (2), MAGNEU )

c (original name: PAREVT)
      LOGICAL LDIFFR, LINCTV, LEVPRT, LHEAVY, LDEEXG, LGDHPR, LPREEX,
     &        LHLFIX, LPRFIX, LPARWV, LPOWER, LSNGCH, LLVMOD, LSCHDF
      PARAMETER ( NALLWP = 39   )
      COMMON /FKPARE/ DPOWER, FSPRD0, FSHPFN, RN1GSC, RN2GSC,
     &                LDIFFR (NALLWP),LPOWER, LINCTV, LEVPRT, LHEAVY,
     &                LDEEXG, LGDHPR, LPREEX, LHLFIX, LPRFIX, LPARWV,
     &                ILVMOD, JLVMOD, LLVMOD, LSNGCH, LSCHDF

      LOGICAL LASMLL
c
      LASMLL = .TRUE.
      IF ( JZ .LE. 0 .OR. JN .LE. 0 ) THEN
         DT_GETA = ( JZ + JN) / B0
         AOGMAX = DT_GETA
         AOGMIN = DT_GETA
         RETURN
      END IF
      GO TO 5
      ENTRY DT_GETG ( U, JZ, JN, MODE, IS, AOGMAX, AOGMIN )
      LASMLL = .FALSE.
    5 CONTINUE
      JA = JN + JZ
      AA = JA
      ZZ = JZ
      GO TO (100,200,300,400), MODE
c  +-------------------------------------------------------------------*
c  |  Standard EVAP parametrization for the level density
  100 CONTINUE
c  |  Actually this a/A
         ASMALD = ( ONEONE + Y0 * ( ( AA - TWOTWO*ZZ ) / AA )**2)
     &          / B0
      GO TO 1000
c  |
c  +-------------------------------------------------------------------*
c  |  Gilbert & Cameron level density with Z and A dependent correction
  200 CONTINUE
         IF ( JA .GT. 250 ) GO TO 100
c  |  No Cameron/Gilbert data available, use the Julich formulation
         IF ( JZ .GT. IZCOOK .OR. JN .GT. INCOOK ) GO TO 300
         IF ( JZ .LT. 9 .OR. JN .LT. 9 ) GO TO 300
c  |  +----------------------------------------------------------------*
c  |  |  Check if it is a deformed nucleus
         IF ( LDEFOZ (JZ) .OR. LDEFON (JN) ) THEN
c  |  |  Gilbert & Cameron deformation dependent term:
            DEFTGC = 0.120D+00
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Undeformed
         ELSE
c  |  |  Gilbert & Cameron deformation dependent term:
            DEFTGC = 0.142D+00
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |  Gilbert & Cameron Shell term
         SHTEGC = SZCOOK (JZ) + SNCOOK (JN)
c  |  Actually this is the Gilbert & Cameron a/A
         ASMALD = 9.17D-03 * SHTEGC + DEFTGC
      GO TO 1000
c  |
c  +-------------------------------------------------------------------*
c  |  Julich A-dependent level density:
  300 CONTINUE
         IF ( JA .GT. 250 ) GO TO 100
         IF ( JA .LE. 240 ) THEN
            ASMALD = APRIME (JA)
         ELSE
            ASMALD = (APRIME(240)+(2.5D+00-1.D-01*APRIME(240))
     &             * (JA-240.D+00))
         END IF
c  |  Actually this is a/A
         ASMALD = ASMALD * ( ONEONE + Y0 * ( ( AA - TWOTWO*ZZ )
     &          / AA )**2 ) / AA
      GO TO 1000
c  |
c  +-------------------------------------------------------------------*
c  |  Brancazio & Cameron level density (with Z and A dependent correc-
c  |  tions)
  400 CONTINUE
         IF ( JA .GT. 250 ) GO TO 100
c  |  No Cameron/Gilbert data available, use the Julich formulation
         IF ( JZ .GT. IZCOOK .OR. JN .GT. INCOOK ) GO TO 300
         IF ( JZ .LT. 9 .OR. JN .LT. 9 ) GO TO 300
         DEFTBC = 0.143 D+00
c  |  Gilbert & Cameron Shell term
         SHTEGC = SZCOOK (JZ) + SNCOOK (JN)
         IDSTMG = JN + JZ
c  |  +----------------------------------------------------------------*
c  |  |  Get the minimum number of nucleons (neutrons or protons)
c  |  |  from the nearest shell
         DO 410 MG = 1, 8
            IDSTMG = MIN ( IDSTMG, ABS (JZ-MAGNUM(MG)),
     &                             ABS (JN-MAGNUM(MG)) )
  410    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
         DSTMGS = IDSTMG
c  |  Actually this is the Brancazio & Cameron a/A
         ASMALD = 9.1D-03 * ( SHTEGC - 0.23 D+00 * DSTMGS ) + DEFTBC
      GO TO 1000
c  |
c  +-------------------------------------------------------------------*
 1000 CONTINUE
c  +-------------------------------------------------------------------*
c  |  Go smoothly to the Ignyatuk high energy limit
      IF ( ABS (GAMIGN) .GT. ANGLGB ) THEN
c        UEFF = U - PZCOOK (JZ) - PNCOOK (JN)
         UEFF = U - CAM4   (JZ) - CAM5   (JN)
c  |  +----------------------------------------------------------------*
c  |  |  Second Ignyatuk formulation:
         IF ( ABS (POWIGN) .GT. ANGLGB ) THEN
            SURIGN = ONEONE
            AAAHLP = SURIGN * AA**POWIGN
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  First Ignyatuk formulation:
         ELSE
            AAAHLP = AA
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |  Ignatyuk high energy limit: actually this is a~/A
c*sr 30.6.
C        ATILDE = ALPIGN + BETIGN * AAAHLP * SURIGN
         ATILDE = ALPIGN + BETIGN * AAAHLP
c*
c  |  +----------------------------------------------------------------*
c  |  |  A independent gamma of Ignyatuk:
         IF ( GAMIGN .GT. ZERZER ) THEN
            GAMHLP = GAMIGN
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  A dependent gamma:
         ELSE
            GAMHLP = - ATILDE / GAMIGN / RMASS (JA)
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         GAMU   = MAX ( GAMHLP * UEFF, 1.D-05 )
c  |  Ignatyuk weighting factor for the zero energy limit:
c*sr avoid floating point underflows
C        GU     = ( ONEONE - EXP (-GAMU) ) / GAMU
         IF (-GAMU.LT.LOG(ANGLGB)) THEN
            GU = ONEONE/GAMU
         ELSE
            GU     = ( ONEONE - EXP (-GAMU) ) / GAMU
         ENDIF
c*
c  |  Make the weighted mean:
         TEMP   = AA * ( ASMALD * GU + ( ONEONE - GU ) * ATILDE )
c  |  +----------------------------------------------------------------*
c  |  |  Check if a_max is at T=0 or at T=oo
         IF ( ASMALD .GT. ATILDE ) THEN
            AOGMAX = AA * ASMALD
            AOGMIN = AA * ATILDE
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |
         ELSE
            AOGMIN = AA * ASMALD
            AOGMAX = AA * ATILDE
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |
c  +-------------------------------------------------------------------*
c  |  No energy dependent level density:
      ELSE
         TEMP   = AA * ASMALD
         AOGMIN = TEMP
         AOGMAX = TEMP
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  geta = a (U) (aogmax = a_max)
      IF ( LASMLL ) THEN
         DT_GETA   = TEMP
c  |
c  +-------------------------------------------------------------------*
c  |  getg = g (U) (aogmax = g_max)
      ELSE
         DT_GETG   = ASMTOG * TEMP
         AOGMAX = ASMTOG * AOGMAX
         AOGMIN = ASMTOG * AOGMIN
      END IF
c  |
c  +-------------------------------------------------------------------*
c=== End of Function geta =============================================*
      RETURN
      END

c$ CREATE IORDIN.FOR
cCOPY IORDIN
c
c=== iordin ===========================================================*
c
CDECK  ID>, DT_IORDIN
      SUBROUTINE DT_IORDIN( IVECT, ICORR, LEN )

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     Integer array ORDering in INcreasing order:                      *
c                                                                      *
c     Created on 08 february 1995  by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 13-feb-95     by    Alfredo Ferrari               *
c                                                                      *
c----------------------------------------------------------------------*
c
      DIMENSION IVECT (LEN), ICORR (LEN)
c
c  +-------------------------------------------------------------------*
c  |
      DO 100 I = 1, LEN
         ICORR (I) = I
  100 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Ordering loop:
      DO 300 I = 1, LEN - 1
         DO 200 J = I + 1, LEN
            IF ( IVECT (J) .LT. IVECT (I) ) THEN
               IHELP     = IVECT (I)
               IVECT (I) = IVECT (J)
               IVECT (J) = IHELP
               ICHELP    = ICORR (I)
               ICORR (I) = ICORR (J)
               ICORR (J) = ICHELP
            END IF
  200    CONTINUE
  300 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Check the ordering loop:
      DO 400 I = 1, LEN - 1
         IF ( IVECT (I) .GT. IVECT (I+1) ) STOP 'STOP:IORDIN-ORDER'
  400 CONTINUE
c  |
c  +-------------------------------------------------------------------*
      RETURN
c=== End of subroutine Iordin =========================================*
      END

c$ CREATE NORRAN.FOR
cCOPY NORRAN
c
c=== norran ===========================================================*
c
CDECK  ID>, DT_NORRAN
      SUBROUTINE DT_NORRAN(RGAUSS)

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     NORmal distributed RANdom number generator                       *
c                                                                      *
c     Created on  03 april  1992   by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 19-jul-92     by    Alfredo Ferrari               *
c                                                                      *
c     This routine has the same name of the CERNLIB one for backcompa- *
c     tibility: now it is based on F.James RM48 uniform random number  *
c     generator                                                        *
c                                                                      *
c                                                                      *
c----------------------------------------------------------------------*
c
c Start_VAX_seq
      REAL SEEDA, SEEDB
c End_VAX_seq
      PARAMETER ( TWOPI = 6.283185307179586454D+00 )
C     DIMENSION RNDNUM (2)
c
c*sr 17.5.95
c replaced by random-number generator used in DPMJET
C     CALL RM48 (RNDNUM,2)
C     RGAUSS = SQRT (-2.D+00*LOG(RNDNUM(1)))*SIN(TWOPI*RNDNUM(2))
      V1 = DT_RNDM(V1)
      V2 = DT_RNDM(V2)
      RGAUSS = SQRT (-2.D+00*LOG(V1))*SIN(TWOPI*V2)
c*
      RETURN
      ENTRY DT_NORRUT ( SEEDA, SEEDB )
      SEEDA = 1.D+00
      SEEDB = 1.D+00
      RETURN
      ENTRY DT_NORRIN ( SEEDA, SEEDB )
c=== End of subroutine Norran =========================================*
      RETURN
      END

c$ CREATE DT_QNRG.FOR
cCOPY DT_QNRG
c                                                                      *
c=== qnrg =============================================================*
c                                                                      *
CDECK  ID>, DT_QNRG
      DOUBLE PRECISION FUNCTION DT_QNRG( A1, Z1, A2, Z2 )

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     Revised version of the original routine from EVAP, now it is     *
c     a dummy function:                                                *
c                                                                      *
c     Created on   15 may 1990     by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 01-oct-94     by    Alfredo Ferrari               *
c                                                                      *
c     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!     *
c     !!!  It is supposed to be used with the updated atomic   !!!     *
c     !!!                    mass data file                    !!!     *
c     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!     *
c                                                                      *
c----------------------------------------------------------------------*
c
      ENRG1 = DT_ENERGY( A1, Z1 )
      ENRG2 = DT_ENERGY( A2, Z2 )
      DT_QNRG = ENRG1 - ENRG2
      RETURN
      END

c$ CREATE RORDIN.FOR
cCOPY RORDIN
c
c=== rordin ===========================================================*
c
CDECK  ID>, DT_RORDIN
      SUBROUTINE DT_RORDIN( RVECT, ICORR, LEN )

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     Real array ORDering in INcreasing order:                         *
c                                                                      *
c     Created on 08 february 1995  by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 13-feb-95     by    Alfredo Ferrari               *
c                                                                      *
c----------------------------------------------------------------------*
c
      DIMENSION RVECT (LEN), ICORR (LEN)
c
c  +-------------------------------------------------------------------*
c  |
      DO 100 I = 1, LEN
         ICORR (I) = I
  100 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Ordering loop:
      DO 300 I = 1, LEN - 1
         DO 200 J = I + 1, LEN
            IF ( RVECT (J) .LT. RVECT (I) ) THEN
               RHELP     = RVECT (I)
               RVECT (I) = RVECT (J)
               RVECT (J) = RHELP
               ICHELP    = ICORR (I)
               ICORR (I) = ICORR (J)
               ICORR (J) = ICHELP
            END IF
  200    CONTINUE
  300 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Check the ordering loop:
      DO 400 I = 1, LEN - 1
         IF ( RVECT (I) .GT. RVECT (I+1) ) STOP 'STOP:RORDIN-ORDER'
  400 CONTINUE
c  |
c  +-------------------------------------------------------------------*
      RETURN
c=== End of subroutine Rordin =========================================*
      END
c                                                                      *
c=== berttp ===========================================================*
c                                                                      *
CDECK  ID>, DT_BERTTP
      SUBROUTINE DT_BERTTP

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( EMVGEV = 1.0                D-03 )

      PARAMETER ( NSTBIS = 304  )

      PARAMETER ( LUNIN  = 5  )
      PARAMETER ( LUNOUT = 6  )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
C---------------------------------------------------------------------
C SUBNAME = DT_BERTTP --- READ BERTINI DATA
C---------------------------------------------------------------------
C     ---------------------------------- I-N-C DATA
C     COMMON R8(2127),R4(64),CRSC(600,4),R8B(336),CS(29849)
C     REAL*8 R8,R8B,CRSC,CS
C     REAL*4 R4
C     --------------------------------- EVAPORATION DATA
c (original name: COOKCM)
      PARAMETER ( ASMTOG = SIXSIX / PIPIPI**2 )
      LOGICAL LDEFOZ, LDEFON
      PARAMETER ( INCOOK = 150, IZCOOK = 98 )
      COMMON /FKCOOK/ ALPIGN, BETIGN, GAMIGN, POWIGN,
     &                SZCOOK (IZCOOK), SNCOOK (INCOOK), PZCOOK (IZCOOK),
     &                PNCOOK (INCOOK), LDEFOZ (IZCOOK), LDEFON (INCOOK)

c (original name: EVA0)
      COMMON /FKEVA0/ Y0, B0, P0 (1001), P1 (1001), P2 (1001),
     *                FLA (6), FLZ (6), RHO (6), OMEGA (6), EXMASS (6),
     *                CAM2 (130), CAM3 (200), CAM4 (130), CAM5 (200),
     *                T (4,7), RMASS (297), ALPH (297), BET (297),
     *                APRIME (250), IA (6), IZ (6)

c (original name: FRBKCM)
      PARAMETER ( MXFFBK =     6 )
      PARAMETER ( MXZFBK =     9 )
      PARAMETER ( MXNFBK =    10 )
      PARAMETER ( MXAFBK =    16 )
      PARAMETER ( NXZFBK = MXZFBK + MXFFBK / 3 )
      PARAMETER ( NXNFBK = MXNFBK + MXFFBK / 3 )
      PARAMETER ( NXAFBK = MXAFBK + 1 )
      PARAMETER ( MXPSST =   300 )
      PARAMETER ( MXPSFB = 41000 )
      LOGICAL LFRMBK, LNCMSS
      COMMON /FKFRBK/  AMUFBK, EEXFBK (MXPSST), AMFRBK (MXPSST),
     &          EXFRBK (MXPSFB), SDMFBK (MXPSFB), COUFBK (MXPSFB),
     &          EXMXFB, R0FRBK, R0CFBK, C1CFBK, C2CFBK,
     &          IFRBKN (MXPSST), IFRBKZ (MXPSST),
     &          IFBKSP (MXPSST), IFBKPR (MXPSST), IFBKST (MXPSST),
     &          IPSIND (0:MXNFBK,0:MXZFBK,2), JPSIND (0:MXAFBK),
     &          IFBIND (0:NXNFBK,0:NXZFBK,2), JFBIND (0:NXAFBK),
     &          IFBCHA (5,MXPSFB), IPOSST, IPOSFB, IFBSTF,
     &          IFBFRB, NBUFBK, LFRMBK, LNCMSS

c (original name: HETTP)
      COMMON /FKHETP/  NHSTP,NBERTP,IOSUB,INSRS

c (original name: INPFLG)
      COMMON /FKINPF/ IANG,IFISS,IB0,IGEOM,ISTRAG,KEYDK

c (original name: ISOTOP)
      PARAMETER ( NAMSMX = 270 )
      PARAMETER ( NZGVAX =  15 )
      PARAMETER ( NISMMX = 574 )
      COMMON /FKISOT/ WAPS   (NAMSMX,NZGVAX),  T12NUC (NAMSMX,NZGVAX),
     &                WAPISM (NISMMX), T12ISM (NISMMX),
     &                ABUISO (NSTBIS), ASTLIN (2,100), ZSTLIN (2,260),
     &                AMSSST (100)  , ISOMNM (NSTBIS), ISONDX (2,100),
     &                JSPNUC (NAMSMX,NZGVAX), JPTNUC (NAMSMX,NZGVAX),
     &                INWAPS (NAMSMX), JSPISM (NISMMX),
     &                JPTISM (NISMMX), IZWISM (NISMMX),
     &                INWISM (0:NAMSMX)

c (original name: NUCGID,NUCGEO,NUCGE2,NUCPWI,NUCGII)
      PARAMETER ( PI     = PIPIPI )
      PARAMETER ( PISQ   = PIPISQ )
      PARAMETER ( SKTOHL = 0.5456645846610345D+00 )
      PARAMETER ( RZNUCL = 1.12        D+00 )
      PARAMETER ( RMSPRO = 0.8         D+00 )
      PARAMETER ( R0PROT = RMSPRO / SQRT12  )
      PARAMETER ( ARHPRO = 1.D+00 / 8.D+00 / PI / R0PROT / R0PROT
     &          / R0PROT )
      PARAMETER ( RLLE04 = RZNUCL )
      PARAMETER ( RLLE16 = RZNUCL )
      PARAMETER ( RLGT16 = RZNUCL )
      PARAMETER ( RCLE04 = 0.75D+00 / PI / RLLE04 / RLLE04 / RLLE04 )
      PARAMETER ( RCLE16 = 0.75D+00 / PI / RLLE16 / RLLE16 / RLLE16 )
      PARAMETER ( RCGT16 = 0.75D+00 / PI / RLGT16 / RLGT16 / RLGT16 )
      PARAMETER ( SKLE04 = 1.4D+00 )
      PARAMETER ( SKLE16 = 1.9D+00 )
      PARAMETER ( SKGT16 = 2.4D+00 )
      PARAMETER ( HLLE04 = SKTOHL * SKLE04 )
      PARAMETER ( HLLE16 = SKTOHL * SKLE16 )
      PARAMETER ( HLGT16 = SKTOHL * SKGT16 )
      PARAMETER ( ALPHA0 = 0.1D+00 )
      PARAMETER ( OMALH0 = 1.D+00 - ALPHA0 )
      PARAMETER ( GAMSK0 = 0.9D+00 )
      PARAMETER ( OMGAS0 = 1.D+00 - GAMSK0 )
      PARAMETER ( POTME0 = 0.6666666666666667D+00 )
      PARAMETER ( POTBA0 = 1.D+00 )
      PARAMETER ( PNFRAT = 1.533D+00 )
      PARAMETER ( RADPIM = 0.035D+00 )
      PARAMETER ( RDPMHL = 14.D+00   )
      PARAMETER ( APMRST = 4.D+00 / 44.D+00 )
      PARAMETER ( APMPRO = 1.D+00 / 6.D+00 )
      PARAMETER ( APPPRO = 5.D+00 / 6.D+00 )
      PARAMETER ( AP0PFS = 0.5D+00 )
      PARAMETER ( AP0PFP = 1.D+00 / 3.D+00 )
      PARAMETER ( AP0NFP = 2.D+00 / 3.D+00 )
      PARAMETER ( XPAUCO = 1.88495407241652 D+00 )
      PARAMETER ( MXSCIN = 50     )
      LOGICAL LABRST, LELSTC, LINELS, LCHEXC, LABSRP, LABSTH, LNCDCY,
     &        LNUSCT, LPREEQ, LNPHTC, LNWRAD, LPNRHO, LFTCMP, LFTCAC
      COMMON /FKNGID/ RHOTAB (2:260), RHATAB (2:260), ALPTAB (2:260),
     &                RADTAB (2:260), SKITAB (2:260), HALTAB (2:260),
     &                SK3TAB (2:260), SK4TAB (2:260), HABTAB (2:260),
     &                CWSTAB (2:260), EKATAB (2:260), PFATAB (2:260),
     &                PFRTAB (2:260)
      COMMON /FKNGEO/ RADTOT, RADIU1, RADIU0, RAD1O2, SKINDP, HALODP,
     &                ALPHAL, OMALHL, RADSKN, SKNEFF, CPARWS, RADPRO,
     &                RADCOR, RADCO2, RADMAX, BIMPTR, RIMPTR, XIMPTR,
     &                YIMPTR, ZIMPTR, RHOIMT, EKFPRO, PFRPRO, RHOCEN,
     &                RHOCOR, RHOSKN, EKFCEN (2), PFRCEN (2), EKFBIM,
     &                PFRBIM, RHOIMP, EKFIMP, PFRIMP, RHOIM2, EKFIM2,
     &                PFRIM2, RHOIM3, EKFIM3, PFRIM3, VPRWLL, RIMPCT,
     &                BIMPCT, XIMPCT, YIMPCT, ZIMPCT, RIMPC2, XIMPC2,
     &                YIMPC2, ZIMPC2, RIMPC3, XIMPC3, YIMPC3, ZIMPC3,
     &                XBIMPC, YBIMPC, ZBIMPC, CXIMPC, CYIMPC, CZIMPC,
     &                SQRIMP, SIGMAP, SIGMAN, SIGMAA, RHORED, R0TRAJ,
     &                R1TRAJ, SBUSED, SBTOT , SBRES , RHOAVE, EKFAVE,
     &                PFRAVE, AVEBIN, ACOLL , ZCOLL , RADSIG, OPACTY,
     &                EKECON, PNUCCO, EKEWLL, PPRWLL, PXPROJ, PYPROJ,
     &                PZPROJ, EKFERM, PNFRMI, PXFERM, PYFERM, PZFERM,
     &                EKFER2, PNFRM2, PXFER2, PYFER2, PZFER2, EKFER3,
     &                PNFRM3, PXFER3, PYFER3, PZFER3, RHOMEM, EKFMEM,
     &                BIMMEM, WLLRED, VPRBIM, POTINC, POTOUT, EEXMIN
      COMMON /FKNGE2/ RDTTNC (2), RHONCP (2), RHONC2 (2), RHONC3 (2),
     &                RHONCT (2), AMOTHR, EKOTHR, AMCREA, EKNCLN,
     &                EEXDEL, EEXANY, CLMBBR, RDCLMB, BFCLMB, BFCEFF,
     &                BNPROJ, BNDNUC, DEBRLM, SK4PAR, UBIMPC, VBIMPC,
     &                WBIMPC, BNDPOT, SIGMAT, SIGABP, SIGABN, WLLRES,
     &                POTBAR, POTMES, AGEPRI, OPNOPA, ETHRND,
     &                BNENRG (3), DEFNUC (2), SIGMPR (4), SIGMNU (4),
     &                SIGPAB (3), SIGNAB (3), HHLP   (2), FORTOT (2),
     &                FPNBLC, DPNBLC, FFTFLG, IFTFLG,
     &                IPWELL, ITNCMX, KPRIN , NTARGT, KNUCIM, KNUCI2,
     &                KNUCI3, IEVPRE, ISFCOL, ISFTAR, ISFTA2, ISFTA3,
     &                NPOTHR, ICOTHR, IBOTHR, NPUMFN, ISTNCL, ITAUCM,
     &                IABCOU, IADFLG, IGSFLG, IALFLG, ICBFLG, LPREEQ,
     &                LNPHTC, LPNRHO, LNWRAD, LFTCMP, LFTCAC
      COMMON /FKNPWI/ ALMBAR, BIMMAX, SIGGEO, LLLMAX, LLLACT
      COMMON /FKNGII/ HOLEXP (2*MXSCIN), XEXPIN (3,0:MXSCIN),
     &                YEXPIN (3,0:MXSCIN), ZEXPIN (3,0:MXSCIN),
     &                AGEXIN (0:MXSCIN), RHOEXP (2), EKFEXP, EHLFIX,
     &                NHLEXP, NHLFIX, IPRTYP, NNCEXI (0:MXSCIN),
     &                NCEXPI (3,0:MXSCIN), ISEXIN (3,0:MXSCIN),
     &                ISCTYP (0:MXSCIN), NUSCIN, NEXPEM,
     &                LABRST, LELSTC, LINELS, LCHEXC, LABSRP, LABSTH,
     &                LNCDCY, LNUSCT
      DIMENSION AWSTAB (2:260), SIGMAB (3)
      EQUIVALENCE ( DEFPRO, DEFNUC (1) )
      EQUIVALENCE ( DEFNEU, DEFNUC (2) )
      EQUIVALENCE ( RHOIPP, RHONCP (1) )
      EQUIVALENCE ( RHOINP, RHONCP (2) )
      EQUIVALENCE ( RHOIP2, RHONC2 (1) )
      EQUIVALENCE ( RHOIN2, RHONC2 (2) )
      EQUIVALENCE ( RHOIP3, RHONC3 (1) )
      EQUIVALENCE ( RHOIN3, RHONC3 (2) )
      EQUIVALENCE ( RHOIPT, RHONCT (1) )
      EQUIVALENCE ( RHOINT, RHONCT (2) )
      EQUIVALENCE ( OMALHL, SK3PAR )
      EQUIVALENCE ( ALPHAL, HABPAR )
      EQUIVALENCE ( ALPTAB (2), AWSTAB (2) )
      EQUIVALENCE ( SIGMPE, SIGMPR (1) )
      EQUIVALENCE ( SIGMPC, SIGMPR (2) )
      EQUIVALENCE ( SIGMPI, SIGMPR (3) )
      EQUIVALENCE ( SIGMPA, SIGMPR (4) )
      EQUIVALENCE ( SIGMNE, SIGMNU (1) )
      EQUIVALENCE ( SIGMNC, SIGMNU (2) )
      EQUIVALENCE ( SIGMNI, SIGMNU (3) )
      EQUIVALENCE ( SIGMNA, SIGMNU (4) )
      EQUIVALENCE ( SIGMA2, SIGPAB (1) )
      EQUIVALENCE ( SIGMA3, SIGPAB (2) )
      EQUIVALENCE ( SIGMAS, SIGPAB (3) )
      EQUIVALENCE ( SIGPAB (1), SIGMAB (1) )

c (original name: NUCLEV)
      LOGICAL LCLVSL, LFLVSL, LRLVSL, LEQSBL
      COMMON /FKNLEV/ PAENUC (200,2), SHENUC (200,2), DEFRMI (2),
     &                DEFMAG (2), ENNCLV (160,2), RANCLV (160,2),
     &                CUMRAD (0:160,2), RUSNUC (2),
     &                ENPLVL (114), ENNLVL(164), JUSNUC (160,2),
     &                NTANUC (2), NAVNUC (2), NLSNUC (2), NCONUC (2),
     &                NSKNUC (2), NHANUC (2), NUSNUC (2), NACNUC (2),
     &                JMXNUC (2), IPRNUC (3), JPRNUC (3), MAGNUM (8),
     &                MAGNUC (2), MGSNUC (8,2), MGSSNC (25,2),
     &                NSBSHL (2), NMNSBS (2), NPRNUC, INUCLV, LCLVSL,
     &                LFLVSL, LRLVSL, LEQSBL
      DIMENSION JUSPRO (160), JUSNEU (160), MGSPRO (8), MGSNEU (8),
     &          MGSSPR (19) , MGSSNE (25)
      EQUIVALENCE ( RUSNUC (1), RUSPRO )
      EQUIVALENCE ( RUSNUC (2), RUSNEU )
      EQUIVALENCE ( JUSNUC (1,1), JUSPRO (1) )
      EQUIVALENCE ( JUSNUC (1,2), JUSNEU (1) )
      EQUIVALENCE ( MGSNUC (1,1), MGSPRO (1) )
      EQUIVALENCE ( MGSNUC (1,2), MGSNEU (1) )
      EQUIVALENCE ( MGSSNC (1,1), MGSSPR (1) )
      EQUIVALENCE ( MGSSNC (1,2), MGSSNE (1) )
      EQUIVALENCE ( NTANUC (1), NTAPRO )
      EQUIVALENCE ( NTANUC (2), NTANEU )
      EQUIVALENCE ( NAVNUC (1), NAVPRO )
      EQUIVALENCE ( NAVNUC (2), NAVNEU )
      EQUIVALENCE ( NLSNUC (1), NLSPRO )
      EQUIVALENCE ( NLSNUC (2), NLSNEU )
      EQUIVALENCE ( NCONUC (1), NCOPRO )
      EQUIVALENCE ( NCONUC (2), NCONEU )
      EQUIVALENCE ( NSKNUC (1), NSKPRO )
      EQUIVALENCE ( NSKNUC (2), NSKNEU )
      EQUIVALENCE ( NHANUC (1), NHAPRO )
      EQUIVALENCE ( NHANUC (2), NHANEU )
      EQUIVALENCE ( NUSNUC (1), NUSPRO )
      EQUIVALENCE ( NUSNUC (2), NUSNEU )
      EQUIVALENCE ( NACNUC (1), NACPRO )
      EQUIVALENCE ( NACNUC (2), NACNEU )
      EQUIVALENCE ( JMXNUC (1), JMXPRO )
      EQUIVALENCE ( JMXNUC (2), JMXNEU )
      EQUIVALENCE ( MAGNUC (1), MAGPRO )
      EQUIVALENCE ( MAGNUC (2), MAGNEU )

c (original name: PAREVT)
      LOGICAL LDIFFR, LINCTV, LEVPRT, LHEAVY, LDEEXG, LGDHPR, LPREEX,
     &        LHLFIX, LPRFIX, LPARWV, LPOWER, LSNGCH, LLVMOD, LSCHDF
      PARAMETER ( NALLWP = 39   )
      COMMON /FKPARE/ DPOWER, FSPRD0, FSHPFN, RN1GSC, RN2GSC,
     &                LDIFFR (NALLWP),LPOWER, LINCTV, LEVPRT, LHEAVY,
     &                LDEEXG, LGDHPR, LPREEX, LHLFIX, LPRFIX, LPARWV,
     &                ILVMOD, JLVMOD, LLVMOD, LSNGCH, LSCHDF

c (original name: XSEPAR)
      COMMON /FKXSEP/ AANXSE (100), BBNXSE (100), CCNXSE (100),
     &                DDNXSE (100), EENXSE (100), ZZNXSE (100),
     &                EMNXSE (100), XMNXSE (100),
     &                AAPXSE (100), BBPXSE (100), CCPXSE (100),
     &                DDPXSE (100), EEPXSE (100), FFPXSE (100),
     &                ZZPXSE (100), EMPXSE (100), XMPXSE (100)


C---------------------------------------------------------------------
c*sr 17.5.95
c modified for use in DPMJET
C     WRITE( LUNOUT,'(A,I2)')
C    & ' *** Reading evaporation and nuclear data from unit: ', NBERTP
C     REWIND NBERTP
      IF (LEVPRT) WRITE(ErrorOut,1000)
 1000 FORMAT(/,1X,'BERTTP:',4X,'INITIALIZATION OF EVAPORATION MODULE',
     &       /,12X,'------------------------------------',/)
      NBERNW = 23
cc     &&&&&& KK
cc      OPEN (UNIT=NBERNW,FILE='DPMJET.DAT',STATUS='UNKNOWN')
      call cdpmOpen2(NBERNW, 'DPMJET.DAT')
cc      &&&&&&
c*sr 17.5.
c!!!! changed to be able to read the ASCII !!!!
c*
C A. Ferrari: first of all read isotopic data
      READ (NBERNW,*) ISONDX
      READ (NBERNW,*) ISOMNM
      READ (NBERNW,*) ABUISO
C     READ (NBERTP) ISONDX
C     READ (NBERTP) ISOMNM
C     READ (NBERTP) ABUISO
      DO 1 I=1,4
C        READ  (NBERTP) (CRSC(J,I),J=1,600)
C A. Ferrari: commented also the dummy read to save disk space
C        READ  (NBERTP)
    1 CONTINUE
C     READ  (NBERTP) CS
C A. Ferrari: commented also the dummy read to save disk space
C     READ  (NBERTP)
C---------------------------------------------------------------------
      READ (NBERNW,*) (P0(I),P1(I),P2(I),I=1,1001)
      READ (NBERNW,*) IA,IZ
      DO 2 I=1,6
         FLA(I)=IA(I)
         FLZ(I)=IZ(I)
    2 CONTINUE
      READ (NBERNW,*) RHO,OMEGA
      READ (NBERNW,*) EXMASS
      READ (NBERNW,*) CAM2
      READ (NBERNW,*) CAM3
      READ (NBERNW,*) CAM4
      READ (NBERNW,*) CAM5
      READ (NBERNW,*) ((T(I,J),J=1,7),I=1,3)
      DO 3 I=1,7
         T(4,I) = ZERZER
    3 CONTINUE
      READ (NBERNW,*) RMASS
      READ (NBERNW,*) ALPH
      READ (NBERNW,*) BET
      READ (NBERNW,*) INWAPS
      READ (NBERNW,*) WAPS
      READ (NBERNW,*) T12NUC
      READ (NBERNW,*) JSPNUC
      READ (NBERNW,*) JPTNUC
      READ (NBERNW,*) INWISM
      READ (NBERNW,*) IZWISM
      READ (NBERNW,*) WAPISM
      READ (NBERNW,*) T12ISM
      READ (NBERNW,*) JSPISM
      READ (NBERNW,*) JPTISM
      READ (NBERNW,*) APRIME
      IF (LEVPRT)
     &WRITE( ErrorOut,
     * '(A)' ) ' *** Evaporation: using 1977 Waps data ***'
      READ (NBERNW,*) AHELP , BHELP , LRMSCH, LRD1O2, LTRASP
      IF ( ABS (AHELP-ALPHA0) .GT. CSNNRM * ALPHA0 .OR.
     &     ABS (BHELP-GAMSK0) .GT. CSNNRM * GAMSK0 ) THEN
         WRITE (ErrorOut,*)
     &         ' *** INCONSISTENT NUCLEAR GEOMETRY DATA ON FILE ***'
         STOP
      END IF
      READ (NBERNW,*) RHOTAB, RHATAB, ALPTAB, RADTAB, SKITAB, HALTAB,
     &              EKATAB, PFATAB, PFRTAB
      READ (NBERNW,*) AANXSE, BBNXSE, CCNXSE, DDNXSE, EENXSE, ZZNXSE,
     &              EMNXSE, XMNXSE
      READ (NBERNW,*) AAPXSE, BBPXSE, CCPXSE, DDPXSE, EEPXSE, FFPXSE,
     &              ZZPXSE, EMPXSE, XMPXSE
c  Data about Fermi-breakup:
      READ (NBERNW,*) IPOSST, MXPDUM, MXADUM, MXNDUM, MXZDUM, IFBSTF
      IF ( MXADUM .NE. MXAFBK .OR. MXNDUM .NE. MXNFBK .OR. MXZDUM .NE.
     &     MXZFBK .OR. MXPDUM .NE. MXPSST ) THEN
         WRITE (ErrorOut,
     * *)' *** Inconsistent Fermi BreakUp data',
     &                   ' IN THE NUCLEAR DATA FILE ***'
         STOP 'STOP:BERTTP-INCONS-FERMI-BREAKUP-DATA'
      END IF
      READ (NBERNW,*) IFRBKN
      READ (NBERNW,*) IFRBKZ
      READ (NBERNW,*) IFBKSP
      READ (NBERNW,*) IFBKST
      READ (NBERNW,*) EEXFBK

      CLOSE (UNIT=NBERNW)

C     READ (NBERTP) (P0(I),P1(I),P2(I),I=1,1001)
C     READ (NBERTP) IA,IZ
C     DO 2 I=1,6
C        FLA(I)=IA(I)
C        FLZ(I)=IZ(I)
C   2 CONTINUE
C     READ (NBERTP) RHO,OMEGA
C     READ (NBERTP) EXMASS
C     READ (NBERTP) CAM2
C     READ (NBERTP) CAM3
C     READ (NBERTP) CAM4
C     READ (NBERTP) CAM5
C     READ (NBERTP) ((T(I,J),J=1,7),I=1,3)
C     DO 3 I=1,7
C        T(4,I) = ZERZER
C   3 CONTINUE
C     READ (NBERTP) RMASS
C     READ (NBERTP) ALPH
C     READ (NBERTP) BET
C     READ (NBERTP) INWAPS
C     READ (NBERTP) WAPS
C     READ (NBERTP) T12NUC
C     READ (NBERTP) JSPNUC
C     READ (NBERTP) JPTNUC
C     READ (NBERTP) INWISM
C     READ (NBERTP) IZWISM
C     READ (NBERTP) WAPISM
C     READ (NBERTP) T12ISM
C     READ (NBERTP) JSPISM
C     READ (NBERTP) JPTISM
C     READ (NBERTP) APRIME
C     WRITE( LUNOUT,'(A)' ) ' *** Evaporation: using 1977 Waps data ***'
C     READ (NBERTP) AHELP , BHELP , LRMSCH, LRD1O2, LTRASP
C     IF ( ABS (AHELP-ALPHA0) .GT. CSNNRM * ALPHA0 .OR.
C    &     ABS (BHELP-GAMSK0) .GT. CSNNRM * GAMSK0 ) THEN
C        WRITE (LUNOUT,*)
C    &         ' *** Inconsistent Nuclear Geometry data on file ***'
C        STOP
C     END IF
C     READ (NBERTP) RHOTAB, RHATAB, ALPTAB, RADTAB, SKITAB, HALTAB,
C    &              EKATAB, PFATAB, PFRTAB
C     READ (NBERTP) AANXSE, BBNXSE, CCNXSE, DDNXSE, EENXSE, ZZNXSE,
C    &              EMNXSE, XMNXSE
C     READ (NBERTP) AAPXSE, BBPXSE, CCPXSE, DDPXSE, EEPXSE, FFPXSE,
C    &              ZZPXSE, EMPXSE, XMPXSE
c  Data about Fermi-breakup:
C     READ (NBERTP) IPOSST, MXPDUM, MXADUM, MXNDUM, MXZDUM, IFBSTF
C     IF ( MXADUM .NE. MXAFBK .OR. MXNDUM .NE. MXNFBK .OR. MXZDUM .NE.
C    &     MXZFBK .OR. MXPDUM .NE. MXPSST ) THEN
C        WRITE (LUNOUT,*)' *** Inconsistent Fermi BreakUp data',
C    &                   ' in the Nuclear Data file ***'
C        STOP 'STOP:BERTTP-INCONS-FERMI-BREAKUP-DATA'
C     END IF
C     READ (NBERTP) IFRBKN
C     READ (NBERTP) IFRBKZ
C     READ (NBERTP) IFBKSP
C     READ (NBERTP) IFBKST
C     READ (NBERTP) EEXFBK
C     CLOSE (UNIT=NBERTP)
      DO 100 JZ = 1, 130
         SHENUC ( JZ, 1 ) = EMVGEV * ( CAM2 (JZ) + CAM4 (JZ) )
  100 CONTINUE
      DO 200 JA = 1, 200
         SHENUC ( JA, 2 ) = EMVGEV * ( CAM3 (JA) + CAM5 (JA) )
  200 CONTINUE
      CALL DT_STALIN
      IF ( ILVMOD .LE. 0 ) THEN
         ILVMOD = IB0
      ELSE
         IB0 = ILVMOD
      END IF
      IF ( LLVMOD ) THEN
         DO 300 JZ = 1, IZCOOK
            CAM4 (JZ) = PZCOOK (JZ)
  300    CONTINUE
         DO 400 JN = 1, INCOOK
            CAM5 (JN) = PNCOOK (JZ)
  400    CONTINUE
      END IF
c*sr
      IF (LEVPRT) THEN
         WRITE (ErrorOut,*)
         IF ( ILVMOD .EQ. 1 ) THEN
            WRITE (ErrorOut,*)
     &   ' **** STANDARD EVAP T=0 LEVEL DENSITY USED ****'
         ELSE IF ( ILVMOD .EQ. 2 ) THEN
            WRITE (ErrorOut,*)
     &   ' **** GILBERT & CAMERON T=0 N,Z-DEP. LEVEL DENSITY USED ****'
         ELSE IF ( ILVMOD .EQ. 3 ) THEN
            WRITE (ErrorOut,*)
     &      ' **** JULICH A-DEPENDENT LEVEL DENSITY USED ****'
         ELSE IF ( ILVMOD .EQ. 4 ) THEN
            WRITE (ErrorOut,*)
     &   ' **** BRANCAZIO & CAMERON T=0 N,Z-DEP. LEVEL DENSITY USED',
     &                                                          ' ****'
         ELSE
            WRITE (ErrorOut,*)
     &   ' **** UNKNOWN T=0 LEVEL DENSITY OPTION REQUESTED ****'
            STOP 'BERTTP-ILVMOD'
         END IF
         IF ( JLVMOD .LE. 0 ) THEN
            GAMIGN = ZERZER
            WRITE (ErrorOut,*)
     &   ' **** NO EXCITATION EN. DEPENDENCE FOR LEVEL DENSITIES ****'
         ELSE IF ( JLVMOD .EQ. 1 ) THEN
            WRITE (ErrorOut,*)
     &   ' **** IGNYATUK (1975, 1ST) LEVEL DENSITY EN. DEP. USED ****'
            WRITE (ErrorOut,*)
     &   ' **** WITH IGNYATUK (1975, 1ST) SET OF PARAMETERS FOR T=OO',
     &                                                        ' ****'
            GAMIGN = 0.054D+00
            BETIGN = -6.3 D-05
            ALPIGN = 0.154D+00
            POWIGN = ZERZER
         ELSE IF ( JLVMOD .EQ. 2 ) THEN
            WRITE (ErrorOut,*)
     &   ' ****   IGNYATUK (1975, 1ST) LEVEL DENSITY EN. DEP. USED ****'
            WRITE (ErrorOut,*)
     &   ' **** WITH UNKNOWN SET OF PARAMETERS FOR T=OO ****'
            STOP 'BERTTP-JLVMOD'
         ELSE IF ( JLVMOD .EQ. 3 ) THEN
            WRITE (ErrorOut,*)
     &   ' ****   IGNYATUK (1975, 1ST) LEVEL DENSITY EN. DEP. USED ****'
            WRITE (ErrorOut,*)
     &   ' **** WITH UNKNOWN SET OF PARAMETERS FOR T=OO ****'
            STOP 'BERTTP-JLVMOD'
         ELSE IF ( JLVMOD .EQ. 4 ) THEN
            WRITE (ErrorOut,*)
     &   ' ****   IGNYATUK (1975, 2ND) LEVEL DENSITY EN. DEP. USED ****'
            WRITE (ErrorOut,*)
     &   ' **** WITH IGNYATUK (1975, 2ND) SET OF PARAMETERS FOR T=OO',
     &                                                        ' ****'
            GAMIGN = 0.054D+00
            BETIGN = 0.162D+00
            ALPIGN = 0.114D+00
            POWIGN = -ONETHI
         ELSE IF ( JLVMOD .EQ. 5 ) THEN
            WRITE (ErrorOut,*)
     &   ' ****  IGNYATUK (1975, 2ND) LEVEL DENSITY EN. DEP. USED  ****'
            WRITE (ErrorOut,*)
     &   ' **** WITH ILJINOV & MEBEL 1ST SET OF PARAMETERS FOR T=OO****'
            GAMIGN = 0.051D+00
            BETIGN = 0.098D+00
            ALPIGN = 0.114D+00
            POWIGN = -ONETHI
         ELSE IF ( JLVMOD .EQ. 6 ) THEN
            WRITE (ErrorOut,*)
     &   ' ****   IGNYATUK (1975, 2ND) LEVEL DENSITY EN. DEP. USED ****'
            WRITE (ErrorOut,*)
     &   ' **** WITH ILJINOV & MEBEL 2ND SET OF PARAMETERS FOR T=OO****'
            GAMIGN = -0.46D+00
            BETIGN = 0.107D+00
            ALPIGN = 0.111D+00
            POWIGN = -ONETHI
         ELSE IF ( JLVMOD .EQ. 7 ) THEN
            WRITE (ErrorOut,*)
     &   ' ****   IGNYATUK (1975, 2ND) LEVEL DENSITY EN. DEP. USED ****'
            WRITE (ErrorOut,*)
     &   ' **** WITH ILJINOV & MEBEL 3RD SET OF PARAMETERS FOR T=OO****'
            GAMIGN = 0.059D+00
            BETIGN = 0.257D+00
            ALPIGN = 0.072D+00
            POWIGN = -ONETHI
         ELSE IF ( JLVMOD .EQ. 8 ) THEN
            WRITE (ErrorOut,*)
     &   ' ****   IGNYATUK (1975, 2ND) LEVEL DENSITY EN. DEP. USED ****'
            WRITE (ErrorOut,*)
     &   ' **** WITH ILJINOV & MEBEL 4TH SET OF PARAMETERS FOR T=OO****'
            GAMIGN = -0.37D+00
            BETIGN = 0.229D+00
            ALPIGN = 0.077D+00
            POWIGN = -ONETHI
         ELSE
            WRITE (ErrorOut,*)
     &   ' **** UNKNOWN T=OO LEVEL DENSITY OPTION REQUESTED ****'
            STOP 'BERTTP-JLVMOD'
         END IF
         IF ( LLVMOD ) THEN
            WRITE (ErrorOut,*)
     &      ' **** COOK''S MODIFIED PAIRING ENERGY USED ****'
         ELSE
            WRITE (ErrorOut,*)
     &      ' **** ORIGINAL GILBERT/CAMERON PAIRING ENERGY USED ****'
         END IF
      ENDIF
c*

      ILVMOD = IB0
      DO 500 JZ = 1, 130
         PAENUC ( JZ, 1 ) = EMVGEV * CAM4 (JZ)
  500 CONTINUE
      DO 600 JA = 1, 200
         PAENUC ( JA, 2 ) = EMVGEV * CAM5 (JA)
  600 CONTINUE
      RETURN
      END
c***********************************************************************
c                                                                      *
c  DPMJET 3.0:   cross section routines                                *
c                                                                      *
c***********************************************************************
c
c
c     SUBROUTINE DT_SHNDIF
c         diffractive cross sections (all energies)
c     SUBROUTINE DT_PHOXS
c         total and inel. cross sections from PHOJET interpol. tables
c     SUBROUTINE DT_XSHN
c         total and el. cross sections for all energies
c     SUBROUTINE DT_SIHNAB
c         pion 2-nucleon absorption cross sections
c     SUBROUTINE DT_SIGEMU
c         cross section for target "compounds"
c     SUBROUTINE DT_SIGGA
c         photon nucleus cross sections
c     SUBROUTINE DT_SIGGAT
c         photon nucleus cross sections from tables
c     SUBROUTINE DT_SANO
c         anomalous hard photon-nucleon cross sections from tables
c     SUBROUTINE DT_SIGGP
c         photon nucleon cross sections
c     SUBROUTINE DT_SIGVEL
c         quasi-elastic vector meson prod. cross sections
c     DOUBLE PRECISION FUNCTION DT_SIGVP
c         sigma_VN(tilde)
c     DOUBLE PRECISION FUNCTION DT_RRM2
c     DOUBLE PRECISION FUNCTION DT_RM2
c     DOUBLE PRECISION FUNCTION DT_SAM2
c     SUBROUTINE DT_CKMT
c     SUBROUTINE DT_CKMTX
c     SUBROUTINE DT_PDF0
c     SUBROUTINE DT_CKMTQ0
c     SUBROUTINE DT_CKMTDE
c     SUBROUTINE DT_CKMTPR
c     FUNCTION DT_CKMTFF
c
c     SUBROUTINE DT_FLUINI
c         total nucleon cross section fluctuation treatment
c
c     SUBROUTINE DT_SIGTBL
c         pre-tabulation of low-energy elastic x-sec. using SIHNEL
c     SUBROUTINE DT_XSTABL
c         service routines
c
c
c
c===shndif===============================================================*
c
CDECK  ID>, DT_SHNDIF
      SUBROUTINE DT_SHNDIF(ECM,KPROJ,KTARG,SIGDIF,SIGDIH)

c*********************************************************************
c   Single diffractive hadron-nucleon cross sections                 *
c                                              S.Roesler 14/1/93     *
c                                                                    *
c   The cross sections are calculated from extrapolated single       *
c   diffractive antiproton-proton cross sections (DTUJET92) using    *
c   scaling relations between total and single diffractive cross     *
c   sections.                                                        *
c*********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (ZERO=0.0D0)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c
      CSD1   =   4.201483727D0
      CSD4   = -0.4763103556D-02
      CSD5   =  0.4324148297D0
c
      CHMSD1 =  0.8519297242D0
      CHMSD4 = -0.1443076599D-01
      CHMSD5 =  0.4014954567D0
c
      EPN = (ECM**2 -AAM(KPROJ)**2 -AAM(KTARG)**2)/(2.0D0*AAM(KTARG))
      PPN = SQRT((EPN-AAM(KPROJ))*(EPN+AAM(KPROJ)))
c
      SDIAPP = CSD1+CSD4*LOG(PPN)**2+CSD5*LOG(PPN)
      SHMSD  = CHMSD1+CHMSD4*LOG(PPN)**2+CHMSD5*LOG(PPN)
      FRAC   = SHMSD/SDIAPP
c
      GOTO( 10, 20,999,999,999,999,999, 10, 20,999,
     &     999, 20, 20, 20, 20, 20, 10, 20, 20, 10,
     &      10, 10, 20, 20, 20) KPROJ
c
   10 CONTINUE
c---------------------------- p - p , n - p , sigma0+- - p ,
c                             Lambda - p
      CSD1   =  6.004476070D0
      CSD4   = -0.1257784606D-03
      CSD5   =  0.2447335720D0
      SIGDIF = CSD1+CSD4*LOG(PPN)**2+CSD5*LOG(PPN)
      SIGDIH = FRAC*SIGDIF
      RETURN
c
   20 CONTINUE
c
      KPSCAL = 2
      KTSCAL = 1
C     F      = SDIAPP/DT_SHNTOT(KPSCAL,KTSCAL,ECM,ZERO)
      DUMZER = ZERO
      CALL DT_XSHN(KPSCAL,KTSCAL,DUMZER,ECM,SIGTO,SIGEL)
      F      = SDIAPP/SIGTO
      KT     = 1
C     SIGDIF = DT_SHNTOT(KPROJ,KT,ECM,ZERO)*F
      CALL DT_XSHN(KPROJ,KT,DUMZER,ECM,SIGTO,SIGEL)
      SIGDIF = SIGTO*F
      SIGDIH = FRAC*SIGDIF
      RETURN
c
  999 CONTINUE
c-------------------------- leptons..
      SIGDIF = 1.D-10
      SIGDIH = 1.D-10
      RETURN
      END
c
c===phoxs================================================================*
c
CDECK  ID>, DT_PHOXS
      SUBROUTINE DT_PHOXS(KPROJ,KTARG,ECM,PLAB,STOT,SINE,SDIF1,BEL,MODE)

c***********************************************************************
c Total/inelastic proton-nucleon cross sections taken from PHOJET-     *
c interpolation tables.                                                *
c This version dated 05.11.97 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0)
      PARAMETER (TWOPI  = 6.283185307179586454D+00,
     &           PI     = TWOPI/TWO,
     &           GEV2MB = 0.38938D0)

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


c*PHOJET105a
C     PARAMETER (IEETAB=10)
C     COMMON /XSETAB/ SIGTAB(4,70,IEETAB),SIGECM(4,IEETAB),ISIMAX
c*PHOJET110
C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX

c*

      IF ((MCGENE.NE.2).AND.(MODE.NE.1)) THEN
         WRITE(ErrorOut,*) MCGENE
 1000    FORMAT(1X,'PHOXS: WARNING! PHOJET NOT INITIALIZED (',I2,')')
         STOP
      ENDIF

      IF (ECM.LE.ZERO) THEN
         EPN = SQRT(AAM(KPROJ)**2+PLAB**2)
         ECM = SQRT(AAM(KPROJ)**2+AAM(KTARG)**2+2.0D0*EPN*AAM(KTARG))
      ENDIF

      IF (MODE.EQ.1) THEN
c DL
         DELDL = 0.0808D0
         EPSDL = -0.4525D0
         S     = ECM*ECM
         STOT  = 21.7D0*S**DELDL+56.08D0*S**EPSDL
         ALPHAP= 0.25D0
         BEL   = 8.5D0+2.D0*ALPHAP*LOG(S)
         SIGEL = STOT**2/(16.D0*PI*BEL*GEV2MB)
         SINE  = STOT-SIGEL
         SDIF1 = ZERO
      ELSE
c Phojet
         IP = 1
         IF(ECM.LE.SIGECM(IP,1)) THEN
           I1 = 1
           I2 = 1
         ELSEIF (ECM.LT.SIGECM(IP,ISIMAX)) THEN
           DO 1 I=2,ISIMAX
              IF (ECM.LE.SIGECM(IP,I)) GOTO 2
    1      CONTINUE
    2      CONTINUE
           I1 = I-1
           I2 = I
         ELSE
           WRITE(ErrorOut,'(/1X,A,2E12.3)')
     &       'PHOXS: WARNING! ENERGY ABOVE INITIALIZATION LIMIT (',
     &       ECM,SIGECM(IP,ISIMAX)
           I1 = ISIMAX
           I2 = ISIMAX
         ENDIF
         FAC2 = ZERO
         IF (I1.NE.I2) FAC2 = LOG(ECM/SIGECM(IP,I1))
     &                       /LOG(SIGECM(IP,I2)/SIGECM(IP,I1))
         FAC1  = ONE-FAC2
         STOT  = FAC2*SIGTAB(IP, 1,I2)+FAC1*SIGTAB(IP, 1,I1)
         SINE  = FAC2*SIGTAB(IP,28,I2)+FAC1*SIGTAB(IP,28,I1)
         SDIF1 = FAC2*(SIGTAB(IP,30,I2)+SIGTAB(IP,32,I2))+
     &           FAC1*(SIGTAB(IP,30,I1)+SIGTAB(IP,32,I1))
         BEL   = FAC2*SIGTAB(IP,39,I2)+FAC1*SIGTAB(IP,39,I1)
      ENDIF

      RETURN
      END
c
c===xshn===============================================================*
c
CDECK  ID>, DT_XSHN
      SUBROUTINE DT_XSHN(IP,IT,PL,ECM,STOT,SELA)

c***********************************************************************
c Total and elastic hadron-nucleon cross section.                      *
c Below 500GeV cross sections are based on the '98 data compilation    *
c of the PDG. At higher energies PHOJET results are used (patched to   *
c the low energy data at 500GeV).                                      *
c     IP      projectile index (BAMJET numbering scheme)               *
c             (should be in the range 1..25)                           *
c     IT      target index (BAMJET numbering scheme)                   *
c             (1 = proton, 8 = neutron)                                *
c     PL      laboratory momentum                                      *
c     ECM     cm. energy (ignored if PL>0)                             *
c     STOT    total cross section                                      *
c     SELA    elastic cross section                                    *
c Last change: 24.4.99 by S. Roesler                                   *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER (LIN=5,LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0)

      PARAMETER (NPOIN1 = 54, NPOIN2 = 8,
     &           PLABLO = 0.1D0, PTHRE = 5.0D0, PLABHI = 500.0D0)
      PARAMETER (NPOINT = NPOIN1+NPOIN2+1)

      LOGICAL LFIRST
c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c*PHOJET105a
C     PARAMETER (IEETAB=10)
C     COMMON /XSETAB/ SIGTAB(4,70,IEETAB),SIGECM(4,IEETAB),ISIMAX
c*PHOJET110
C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX


      DIMENSION APL(NPOINT),ASIGTO(10,NPOINT),ASIGEL(10,NPOINT)
      DIMENSION IDXDAT(25,2)
c
      DATA APL /
     &-1.000,-0.969,-0.937,-0.906,-0.874,-0.843,-0.811,-0.780,-0.748,
     &-0.717,-0.685,-0.654,-0.622,-0.591,-0.560,-0.528,-0.497,-0.465,
     &-0.434,-0.402,-0.371,-0.339,-0.308,-0.276,-0.245,-0.213,-0.182,
     &-0.151,-0.119,-0.088,-0.056,-0.025, 0.007, 0.038, 0.070, 0.101,
     & 0.133, 0.164, 0.196, 0.227, 0.258, 0.290, 0.321, 0.353, 0.384,
     & 0.416, 0.447, 0.479, 0.510, 0.542, 0.573, 0.605, 0.636, 0.668,
     & 0.699, 0.949, 1.199, 1.449, 1.699, 1.949, 2.199, 2.449, 2.699/
c
c total cross sections:
c p p
      DATA (ASIGTO(1,K),K=1,NPOINT) /
     & 2.837, 2.760, 2.686, 2.614, 2.543, 2.472, 2.401, 2.329, 2.255,
     & 2.180, 2.103, 2.030, 1.968, 1.919, 1.861, 1.775, 1.698, 1.646,
     & 1.577, 1.518, 1.462, 1.420, 1.393, 1.375, 1.363, 1.356, 1.352,
     & 1.350, 1.351, 1.359, 1.381, 1.410, 1.444, 1.487, 1.544, 1.596,
     & 1.650, 1.672, 1.676, 1.677, 1.677, 1.675, 1.675, 1.669, 1.664,
     & 1.658, 1.653, 1.645, 1.640, 1.634, 1.630, 1.625, 1.620, 1.617,
     & 1.614, 1.602, 1.594, 1.589, 1.581, 1.583, 1.588, 1.596, 1.603/
c pbar p
      DATA (ASIGTO(2,K),K=1,NPOINT) /
     & 2.778, 2.759, 2.739, 2.718, 2.697, 2.675, 2.651, 2.626, 2.598,
     & 2.569, 2.537, 2.502, 2.471, 2.443, 2.420, 2.389, 2.361, 2.329,
     & 2.313, 2.304, 2.268, 2.244, 2.222, 2.212, 2.178, 2.162, 2.151,
     & 2.132, 2.109, 2.097, 2.089, 2.078, 2.063, 2.049, 2.035, 2.024,
     & 2.014, 2.004, 1.993, 1.981, 1.970, 1.958, 1.946, 1.933, 1.921,
     & 1.909, 1.894, 1.885, 1.871, 1.854, 1.836, 1.825, 1.816, 1.802,
     & 1.790, 1.744, 1.694, 1.663, 1.642, 1.614, 1.623, 1.623, 1.630/
c n p
      DATA (ASIGTO(3,K),K=1,NPOINT) /
     & 3.192, 3.145, 3.097, 3.047, 2.995, 2.940, 2.883, 2.824, 2.763,
     & 2.700, 2.634, 2.565, 2.494, 2.420, 2.344, 2.269, 2.196, 2.115,
     & 2.048, 1.964, 1.906, 1.842, 1.779, 1.719, 1.656, 1.604, 1.569,
     & 1.547, 1.534, 1.526, 1.522, 1.520, 1.525, 1.536, 1.550, 1.566,
     & 1.578, 1.580, 1.581, 1.584, 1.590, 1.598, 1.605, 1.608, 1.609,
     & 1.608, 1.608, 1.608, 1.608, 1.608, 1.607, 1.606, 1.606, 1.605,
     & 1.606, 1.599, 1.588, 1.587, 1.586, 1.589, 1.592, 1.597, 1.600/
c pi+ p
      DATA (ASIGTO(4,K),K=1,NPOINT) /
     & 0.643, 0.786, 0.929, 1.074, 1.199, 1.272, 1.340, 1.484, 1.610,
     & 1.750, 1.881, 2.014, 2.178, 2.244, 2.301, 2.309, 2.219, 2.118,
     & 2.001, 1.875, 1.801, 1.665, 1.609, 1.484, 1.412, 1.334, 1.195,
     & 1.160, 1.166, 1.208, 1.309, 1.356, 1.394, 1.406, 1.419, 1.473,
     & 1.540, 1.596, 1.570, 1.533, 1.516, 1.484, 1.471, 1.478, 1.492,
     & 1.497, 1.491, 1.479, 1.465, 1.453, 1.449, 1.450, 1.444, 1.428,
     & 1.422, 1.406, 1.384, 1.369, 1.364, 1.369, 1.374, 1.388, 1.395/
c pi- p
      DATA (ASIGTO(5,K),K=1,NPOINT) /
     & 0.458, 0.540, 0.626, 0.718, 0.819, 0.933, 1.063, 1.208, 1.226,
     & 1.436, 1.470, 1.594, 1.708, 1.786, 1.852, 1.836, 1.763, 1.679,
     & 1.590, 1.492, 1.445, 1.426, 1.423, 1.433, 1.473, 1.506, 1.547,
     & 1.660, 1.671, 1.545, 1.591, 1.687, 1.808, 1.656, 1.582, 1.543,
     & 1.562, 1.560, 1.537, 1.540, 1.549, 1.557, 1.557, 1.551, 1.535,
     & 1.527, 1.511, 1.510, 1.507, 1.500, 1.491, 1.483, 1.478, 1.468,
     & 1.463, 1.435, 1.408, 1.394, 1.384, 1.380, 1.383, 1.393, 1.411/
c K+ p
      DATA (ASIGTO(6,K),K=1,NPOINT) /
     & 1.097, 1.097, 1.097, 1.097, 1.097, 1.097, 1.097, 1.097, 1.097,
     & 1.097, 1.097, 1.097, 1.097, 1.097, 1.097, 1.097, 1.097, 1.097,
     & 1.097, 1.097, 1.097, 1.097, 1.097, 1.097, 1.097, 1.096, 1.095,
     & 1.098, 1.105, 1.111, 1.139, 1.169, 1.209, 1.248, 1.259, 1.268,
     & 1.262, 1.257, 1.254, 1.252, 1.250, 1.249, 1.246, 1.244, 1.244,
     & 1.243, 1.240, 1.238, 1.237, 1.236, 1.235, 1.235, 1.236, 1.236,
     & 1.236, 1.233, 1.238, 1.248, 1.257, 1.272, 1.292, 1.311, 1.336/
c K- p
      DATA (ASIGTO(7,K),K=1,NPOINT) /
     & 2.003, 2.002, 2.001, 2.000, 1.999, 1.998, 1.998, 1.997, 1.997,
     & 1.996, 1.995, 1.993, 1.990, 1.992, 1.974, 1.912, 1.865, 1.847,
     & 1.896, 1.950, 1.827, 1.681, 1.637, 1.616, 1.589, 1.545, 1.543,
     & 1.532, 1.603, 1.604, 1.616, 1.658, 1.700, 1.658, 1.595, 1.508,
     & 1.493, 1.514, 1.531, 1.523, 1.501, 1.479, 1.474, 1.467, 1.463,
     & 1.450, 1.444, 1.435, 1.426, 1.424, 1.423, 1.415, 1.401, 1.396,
     & 1.384, 1.364, 1.330, 1.313, 1.310, 1.309, 1.317, 1.329, 1.338/
c K+ n
      DATA (ASIGTO(8,K),K=1,NPOINT) /
     & 0.176, 0.229, 0.282, 0.334, 0.386, 0.437, 0.487, 0.536, 0.584,
     & 0.631, 0.675, 0.719, 0.760, 0.799, 0.835, 0.870, 0.901, 0.931,
     & 0.958, 0.984, 1.008, 1.032, 1.056, 1.079, 1.102, 1.125, 1.147,
     & 1.168, 1.187, 1.205, 1.224, 1.248, 1.279, 1.315, 1.324, 1.301,
     & 1.285, 1.279, 1.274, 1.273, 1.272, 1.271, 1.267, 1.263, 1.261,
     & 1.259, 1.256, 1.252, 1.247, 1.244, 1.241, 1.240, 1.240, 1.240,
     & 1.241, 1.243, 1.245, 1.253, 1.265, 1.275, 1.293, 1.314, 1.342/
c K- n
      DATA (ASIGTO(9,K),K=1,NPOINT) /
     & 1.778, 1.778, 1.778, 1.778, 1.778, 1.778, 1.778, 1.778, 1.778,
     & 1.778, 1.778, 1.778, 1.778, 1.778, 1.779, 1.779, 1.778, 1.773,
     & 1.765, 1.746, 1.703, 1.646, 1.561, 1.488, 1.454, 1.437, 1.437,
     & 1.458, 1.505, 1.561, 1.588, 1.593, 1.581, 1.551, 1.500, 1.454,
     & 1.427, 1.408, 1.390, 1.372, 1.361, 1.356, 1.351, 1.347, 1.343,
     & 1.341, 1.340, 1.338, 1.337, 1.335, 1.334, 1.332, 1.331, 1.330,
     & 1.330, 1.313, 1.303, 1.288, 1.288, 1.297, 1.305, 1.320, 1.342/
c Lambda p
      DATA (ASIGTO(10,K),K=1,NPOINT) /
     & 2.648, 2.598, 2.548, 2.498, 2.446, 2.394, 2.340, 2.283, 2.224,
     & 2.160, 2.091, 2.015, 1.936, 1.858, 1.785, 1.720, 1.669, 1.629,
     & 1.599, 1.576, 1.558, 1.543, 1.530, 1.520, 1.512, 1.505, 1.499,
     & 1.495, 1.495, 1.497, 1.504, 1.514, 1.525, 1.536, 1.550, 1.567,
     & 1.578, 1.580, 1.581, 1.584, 1.590, 1.598, 1.605, 1.608, 1.609,
     & 1.608, 1.608, 1.608, 1.608, 1.608, 1.607, 1.606, 1.606, 1.605,
     & 1.606, 1.599, 1.588, 1.587, 1.586, 1.589, 1.592, 1.597, 1.600/
c
c elastic cross sections:
c p p
      DATA (ASIGEL(1,K),K=1,NPOINT) /
     & 2.837, 2.760, 2.686, 2.614, 2.543, 2.472, 2.401, 2.329, 2.255,
     & 2.180, 2.103, 2.030, 1.968, 1.919, 1.861, 1.775, 1.698, 1.646,
     & 1.577, 1.518, 1.462, 1.420, 1.393, 1.374, 1.360, 1.353, 1.350,
     & 1.351, 1.356, 1.362, 1.369, 1.376, 1.384, 1.385, 1.399, 1.397,
     & 1.389, 1.385, 1.379, 1.366, 1.358, 1.344, 1.320, 1.294, 1.275,
     & 1.260, 1.248, 1.235, 1.219, 1.199, 1.172, 1.144, 1.126, 1.115,
     & 1.104, 1.013, 0.962, 0.905, 0.869, 0.845, 0.846, 0.850, 0.868/
c pbar p
      DATA (ASIGEL(2,K),K=1,NPOINT) /
     & 1.987, 1.985, 1.983, 1.980, 1.978, 1.975, 1.971, 1.968, 1.963,
     & 1.958, 1.951, 1.944, 1.935, 1.925, 1.914, 1.902, 1.889, 1.875,
     & 1.859, 1.845, 1.834, 1.817, 1.792, 1.769, 1.754, 1.738, 1.720,
     & 1.702, 1.688, 1.676, 1.667, 1.659, 1.652, 1.645, 1.640, 1.636,
     & 1.620, 1.591, 1.562, 1.546, 1.540, 1.524, 1.496, 1.475, 1.457,
     & 1.429, 1.402, 1.373, 1.344, 1.330, 1.306, 1.294, 1.265, 1.228,
     & 1.204, 1.086, 0.977, 0.933, 0.914, 0.850, 0.862, 0.848, 0.845/
c n p
      DATA (ASIGEL(3,K),K=1,NPOINT) /
     & 3.192, 3.145, 3.097, 3.047, 2.995, 2.940, 2.883, 2.824, 2.763,
     & 2.700, 2.634, 2.565, 2.494, 2.420, 2.344, 2.269, 2.196, 2.115,
     & 2.048, 1.964, 1.906, 1.842, 1.779, 1.719, 1.656, 1.604, 1.569,
     & 1.544, 1.527, 1.514, 1.504, 1.495, 1.486, 1.476, 1.466, 1.454,
     & 1.440, 1.425, 1.409, 1.392, 1.375, 1.358, 1.340, 1.322, 1.304,
     & 1.285, 1.267, 1.250, 1.234, 1.219, 1.202, 1.181, 1.158, 1.136,
     & 1.116, 0.727,-2.128, -10.0, -10.0, -10.0, -10.0, -10.0, -10.0/
c pi+ p
      DATA (ASIGEL(4,K),K=1,NPOINT) /
     & 0.643, 0.786, 0.929, 1.074, 1.199, 1.272, 1.340, 1.484, 1.610,
     & 1.750, 1.881, 2.014, 2.178, 2.244, 2.301, 2.309, 2.219, 2.118,
     & 2.001, 1.875, 1.801, 1.664, 1.610, 1.479, 1.423, 1.299, 1.166,
     & 1.097, 1.020, 0.958, 0.914, 1.013, 1.088, 1.153, 1.167, 1.235,
     & 1.240, 1.237, 1.202, 1.135, 1.090, 1.026, 0.975, 0.941, 0.904,
     & 0.894, 0.884, 0.862, 0.850, 0.845, 0.827, 0.805, 0.789, 0.776,
     & 0.763, 0.686, 0.626, 0.562, 0.505, 0.518, 0.525, 0.528, 0.528/
c pi- p
      DATA (ASIGEL(5,K),K=1,NPOINT) /
     & 0.266, 0.278, 0.294, 0.320, 0.360, 0.419, 0.503, 0.608, 0.727,
     & 0.850, 0.968, 1.071, 1.167, 1.305, 1.369, 1.404, 1.446, 1.217,
     & 1.112, 1.071, 1.014, 1.002, 0.996, 1.008, 1.070, 1.126, 1.209,
     & 1.300, 1.281, 1.188, 1.156, 1.341, 1.423, 1.314, 1.171, 1.140,
     & 1.106, 1.071, 1.011, 1.037, 1.026, 1.024, 0.988, 0.953, 0.895,
     & 0.894, 0.880, 0.871, 0.864, 0.853, 0.837, 0.820, 0.809, 0.800,
     & 0.782, 0.674, 0.612, 0.530, 0.521, 0.528, 0.524, 0.542, 0.569/
c K+ p
      DATA (ASIGEL(6,K),K=1,NPOINT) /
     & 1.064, 1.065, 1.065, 1.066, 1.066, 1.066, 1.066, 1.066, 1.066,
     & 1.065, 1.064, 1.063, 1.062, 1.062, 1.062, 1.064, 1.066, 1.070,
     & 1.076, 1.082, 1.088, 1.096, 1.103, 1.104, 1.104, 1.102, 1.093,
     & 1.087, 1.084, 1.079, 1.075, 1.067, 1.058, 1.040, 1.029, 1.012,
     & 1.003, 0.985, 0.935, 0.909, 0.880, 0.846, 0.790, 0.771, 0.759,
     & 0.743, 0.718, 0.681, 0.666, 0.645, 0.622, 0.606, 0.594, 0.584,
     & 0.575, 0.513, 0.453, 0.403, 0.356, 0.365, 0.389, 0.430, 0.477/
c K- p
      DATA (ASIGEL(7,K),K=1,NPOINT) /
     & 1.941, 1.936, 1.931, 1.926, 1.919, 1.912, 1.903, 1.892, 1.878,
     & 1.863, 1.844, 1.821, 1.791, 1.755, 1.713, 1.666, 1.615, 1.561,
     & 1.533, 1.531, 1.518, 1.511, 1.452, 1.339, 1.265, 1.233, 1.188,
     & 1.184, 1.236, 1.316, 1.333, 1.336, 1.333, 1.277, 1.216, 1.077,
     & 1.018, 0.912, 0.926, 0.920, 0.910, 0.894, 0.830, 0.825, 0.800,
     & 0.788, 0.747, 0.703, 0.707, 0.689, 0.643, 0.633, 0.635, 0.618,
     & 0.584, 0.579, 0.461, 0.403, 0.405, 0.399, 0.408, 0.418, 0.413/
c K+ n
      DATA (ASIGEL(8,K),K=1,NPOINT) /
     & 0.176, 0.229, 0.282, 0.334, 0.386, 0.437, 0.487, 0.536, 0.584,
     & 0.631, 0.676, 0.719, 0.760, 0.799, 0.835, 0.870, 0.901, 0.931,
     & 0.958, 0.984, 1.008, 1.032, 1.056, 1.079, 1.103, 1.126, 1.148,
     & 1.168, 1.187, 1.205, 1.223, 1.248, 1.282, 1.269, 1.185, 1.111,
     & 1.063, 1.031, 0.998, 0.964, 0.928, 0.889, 0.849, 0.814, 0.785,
     & 0.760, 0.738, 0.720, 0.703, 0.688, 0.674, 0.660, 0.648, 0.635,
     & 0.624, 0.536, 0.473, 0.442, 0.428, 0.428, 0.436, 0.453, 0.477/
c K- n
      DATA (ASIGEL(9,K),K=1,NPOINT) /
     & 1.613, 1.613, 1.613, 1.613, 1.613, 1.613, 1.613, 1.613, 1.613,
     & 1.613, 1.613, 1.613, 1.612, 1.613, 1.614, 1.614, 1.612, 1.606,
     & 1.593, 1.564, 1.498, 1.402, 1.240, 1.071, 0.977, 0.922, 0.914,
     & 0.961, 1.077, 1.214, 1.271, 1.290, 1.281, 1.217, 1.096, 0.979,
     & 0.896, 0.822, 0.736, 0.655, 0.608, 0.591, 0.580, 0.569, 0.559,
     & 0.550, 0.540, 0.531, 0.522, 0.514, 0.507, 0.500, 0.494, 0.489,
     & 0.485, 0.477, 0.477, 0.477, 0.477, 0.477, 0.477, 0.477, 0.477/
c Lambda p
      DATA (ASIGEL(10,K),K=1,NPOINT) /
     & 2.648, 2.598, 2.548, 2.498, 2.446, 2.394, 2.340, 2.283, 2.224,
     & 2.160, 2.091, 2.015, 1.936, 1.858, 1.785, 1.720, 1.669, 1.630,
     & 1.600, 1.577, 1.558, 1.542, 1.528, 1.518, 1.510, 1.505, 1.502,
     & 1.501, 1.500, 1.499, 1.496, 1.491, 1.485, 1.477, 1.466, 1.454,
     & 1.440, 1.425, 1.408, 1.392, 1.375, 1.358, 1.340, 1.322, 1.304,
     & 1.285, 1.267, 1.250, 1.234, 1.219, 1.202, 1.181, 1.158, 1.136,
     & 1.116, 0.727,-2.128, -10.0, -10.0, -10.0, -10.0, -10.0, -10.0/

      DATA (IDXDAT(K,1),K=1,25) /
     &  1, 2, 0, 0, 0, 0, 0, 3, 2, 0, 0,67, 4, 5, 6, 7,10, 2,67, 3,
     &  1, 3,45, 8, 9/
      DATA (IDXDAT(K,2),K=1,25) /
     &  3, 2, 0, 0, 0, 0, 0, 1, 2, 0, 0,89, 5, 4, 8, 9, 1, 2,89, 1,
     &  3, 1,45, 6, 7/

      DATA LFIRST /.TRUE./

      IF (LFIRST) THEN
         APLABL = LOG10(PLABLO)
         APLABH = LOG10(PLABHI)
         APTHRE = LOG10(PTHRE)
         ADP1   = (APTHRE-APLABL)/DBLE(NPOIN1)
         ADP2   = (APLABH-APTHRE)/DBLE(NPOIN2)
         DUM0   = ZERO
         PHOPLA = PLABHI
         PHOELA = SQRT(AAM(1)**2+PHOPLA**2)
         ECMS   = SQRT(2.0D0*AAM(1)**2+2.0D0*AAM(1)*PHOELA)
         IF (MCGENE.EQ.2) THEN
            IF (ECMS.LE.SIGECM(1,ISIMAX)) THEN
               CALL DT_PHOXS(1,1,DUM0,PHOPLA,PHOSTO,PHOSIN,DUM1,DUM2,0)
            ELSE
               CALL DT_PHOXS(1,1,DUM0,PHOPLA,PHOSTO,PHOSIN,DUM1,DUM2,1)
            ENDIF
         ELSE
            CALL DT_PHOXS(1,1,DUM0,PHOPLA,PHOSTO,PHOSIN,DUM1,DUM2,1)
         ENDIF
         PHOSEL = PHOSTO-PHOSIN
         APHOST = LOG10(PHOSTO)
         APHOSE = LOG10(PHOSEL)
         LFIRST = .FALSE.
      ENDIF
      STOT = ZERO
      SELA = ZERO
      PLAB = PL
      ECMS = ECM
      IF ( (IP.LT.1).OR.((IT.NE.1).AND.(IT.NE.8)) ) THEN
         WRITE(ErrorOut,1000) IP,IT
 1000    FORMAT(1X,'DT_XSHN: CROSS SECTIONS NOT IMPLEMENTED FOR ',
     &          'PROJ/TARGET',2I4)
         STOP
      ENDIF

      IF ((PLAB.LE.ZERO).AND.(ECMS.GT.ZERO)) THEN
         ELAB = (ECMS**2-AAM(IP)**2-AAM(IT)**2)/(2.0D0*AAM(IT))
         PLAB = SQRT((ELAB-AAM(IP))*(ELAB+AAM(IP)))
      ELSEIF ((PLAB.LE.ZERO).AND.(ECMS.LE.ZERO)) THEN
         WRITE(ErrorOut,1001) PLAB,ECMS
 1001    FORMAT(1X,'DT_XSHN: INVALID MOMENTUM/CM-ENERGY ',2E15.5)
         STOP
      ENDIF

c index of spectrum
      IDXP = IP
      IF (IP.GT.25) THEN
         IF (AAM(IP).GT.ZERO) THEN
            IF (ABS(IIBAR(IP)).GT.0) THEN
               IDXP = 1
            ELSE
               IDXP = 13
            ENDIF
         ELSE
            IDXP = 7
         ENDIF
      ENDIF
      IDXT = 1
      IF (IT.EQ.8) IDXT = 2
      IDXS = IDXDAT(IDXP,IDXT)
      IF (IDXS.EQ.0) RETURN

c compute momentum bin indices
      IF (PLAB.LT.PLABLO) THEN
         IDX0 = 1
         IDX1 = 1
      ELSEIF (PLAB.GE.PLABHI) THEN
         IDX0 = NPOINT
         IDX1 = NPOINT
      ELSE
         APLAB = LOG10(PLAB)
         IF ((PLAB.GE.PLABLO).AND.(PLAB.LT.PTHRE )) THEN
            IDX0 = INT((APLAB-APLABL)/ADP1)+1
         ELSEIF ((PLAB.GE.PTHRE ).AND.(PLAB.LT.PLABHI)) THEN
            IDX0 = INT((APLAB-APTHRE)/ADP2)+NPOIN1+1
         ENDIF
         IDX1 = IDX0+1
      ENDIF

c interpolate cross section
      IF (IDXS.GT.10) THEN
         IDXS1 = IDXS/10
         IDXS2 = IDXS-10*IDXS1
         IF (IDX0.EQ.IDX1) THEN
            IF (IDX0.EQ.1) THEN
               ASTOT = 0.5D0*(ASIGTO(IDXS1,IDX0)+ASIGTO(IDXS2,IDX0))
               ASELA = 0.5D0*(ASIGEL(IDXS1,IDX0)+ASIGEL(IDXS2,IDX0))
            ELSE
               DUM0   = ZERO
               CALL DT_PHOXS(1,1,DUM0,PLAB,PHOSTO,PHOSIN,DUM1,DUM2,0)
               PHOSEL = PHOSTO-PHOSIN
               ASTOT1 = ASIGTO(IDXS1,NPOINT)-APHOST+LOG10(PHOSTO)
               ASELA1 = ASIGEL(IDXS1,NPOINT)-APHOSE+LOG10(PHOSEL)
               ASTOT2 = ASIGTO(IDXS2,NPOINT)-APHOST+LOG10(PHOSTO)
               ASELA2 = ASIGEL(IDXS2,NPOINT)-APHOSE+LOG10(PHOSEL)
               ASTOT  = 0.5D0*(ASTOT1+ASTOT2)
               ASELA  = 0.5D0*(ASELA1+ASELA2)
            ENDIF
         ELSE
            FAC = (APLAB-APL(IDX0))/(APL(IDX1)-APL(IDX0))
            ASTOT1 = ASIGTO(IDXS1,IDX0)+
     &               FAC*(ASIGTO(IDXS1,IDX1)-ASIGTO(IDXS1,IDX0))
            ASTOT2 = ASIGTO(IDXS2,IDX0)+
     &               FAC*(ASIGTO(IDXS2,IDX1)-ASIGTO(IDXS2,IDX0))
            ASTOT  = 0.5D0*(ASTOT1+ASTOT2)
            ASELA1 = ASIGEL(IDXS1,IDX0)+
     &               FAC*(ASIGEL(IDXS1,IDX1)-ASIGEL(IDXS1,IDX0))
            ASELA2 = ASIGEL(IDXS2,IDX0)+
     &               FAC*(ASIGEL(IDXS2,IDX1)-ASIGEL(IDXS2,IDX0))
            ASELA  = 0.5D0*(ASELA1+ASELA2)
         ENDIF
      ELSE
         IF (IDX0.EQ.IDX1) THEN
            IF (IDX0.EQ.1) THEN
               ASTOT = ASIGTO(IDXS,IDX0)
               ASELA = ASIGEL(IDXS,IDX0)
            ELSE
               DUM0   = ZERO
               CALL DT_PHOXS(1,1,DUM0,PLAB,PHOSTO,PHOSIN,DUM1,DUM2,0)
               PHOSEL = PHOSTO-PHOSIN
               ASTOT  = ASIGTO(IDXS,NPOINT)-APHOST+LOG10(PHOSTO)
               ASELA  = ASIGEL(IDXS,NPOINT)-APHOSE+LOG10(PHOSEL)
            ENDIF
         ELSE
            FAC = (APLAB-APL(IDX0))/(APL(IDX1)-APL(IDX0))
            ASTOT = ASIGTO(IDXS,IDX0)+
     &              FAC*(ASIGTO(IDXS,IDX1)-ASIGTO(IDXS,IDX0))
            ASELA = ASIGEL(IDXS,IDX0)+
     &              FAC*(ASIGEL(IDXS,IDX1)-ASIGEL(IDXS,IDX0))
         ENDIF
      ENDIF
      STOT = 10.0D0**ASTOT
      SELA = 10.0D0**ASELA

      RETURN
      END
c
c===sihnab===============================================================*
c
CDECK  ID>, DT_SIHNAB
      SUBROUTINE DT_SIHNAB(IDP,IDT,PLAB,SIGABS)

c*********************************************************************
c Pion 2-nucleon absorption cross sections.                          *
c (sigma_tot for pi+ d --> p p, pi- d --> n n                        *
c  taken from Ritchie PRC 28 (1983) 926 )                            *
c This version dated 18.05.96 is written by S. Roesler               *
c*********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,TINY3=1.0D-3)
      PARAMETER (AMPR = 938.0D0,
     &           AMPI = 140.0D0,
     &           AMDE = TWO*AMPR,
     &           A    = -1.2D0,
     &           B    = 3.5D0,
     &           C    = 7.4D0,
     &           D    = 5600.0D0,
     &           ER   = 2136.0D0)

      SIGABS = ZERO
      IF ( ((IDP.NE.13).AND.(IDP.NE.14).AND.(IDP.NE.23))
     &                   .OR.((IDT.NE.1).AND.(IDT.NE.8)) ) RETURN
      PTOT = PLAB*1.0D3
      EKIN = SQRT(AMPI**2+PTOT**2)-AMPI
      IF ((EKIN.LT.TINY3).OR.(EKIN.GT.400.0D0)) RETURN
      ECM  = SQRT( (AMPI+AMDE)**2+TWO*EKIN*AMDE )
      SIGABS = A+B/SQRT(EKIN)+C*1.0D4/((ECM-ER)**2+D)
c approximate 3N-abs., I=1-abs. etc.
      SIGABS = SIGABS/0.40D0
c pi0-absorption (rough approximation!!)
      IF (IDP.EQ.23) SIGABS = 0.5D0*SIGABS

      RETURN
      END
c
c===sigemu=============================================================*
c
CDECK  ID>, DT_SIGEMU
      SUBROUTINE DT_SIGEMU

c***********************************************************************
c Combined cross section for target compounds.                         *
c This version dated 6.4.98   is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY2=1.0D-2,ZERO=0.0D0,DLARGE=1.0D10,
     &           OHALF=0.5D0,ONE=1.0D0)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN


      IF (MCGENE.NE.4) THEN
         WRITE(ErrorOut,
     * '(A)') ' DT_SIGEMU:    Combined cross sections'
         WRITE(ErrorOut,'(15X,A)') '-----------------------'
      ENDIF
      DO 1 IE=1,NEBINI
         DO 2 IQ=1,NQBINI
            SIGTOT = ZERO
            SIGELA = ZERO
            SIGQEP = ZERO
            SIGQET = ZERO
            SIGQE2 = ZERO
            SIGPRO = ZERO
            SIGDEL = ZERO
            SIGDQE = ZERO
            ERRTOT = ZERO
            ERRELA = ZERO
            ERRQEP = ZERO
            ERRQET = ZERO
            ERRQE2 = ZERO
            ERRPRO = ZERO
            ERRDEL = ZERO
            ERRDQE = ZERO
            IF (NCOMPO.GT.0) THEN
               DO 3 IC=1,NCOMPO
                  SIGTOT = SIGTOT+EMUFRA(IC)*XSTOT(IE,IQ,IC)
                  SIGELA = SIGELA+EMUFRA(IC)*XSELA(IE,IQ,IC)
                  SIGQEP = SIGQEP+EMUFRA(IC)*XSQEP(IE,IQ,IC)
                  SIGQET = SIGQET+EMUFRA(IC)*XSQET(IE,IQ,IC)
                  SIGQE2 = SIGQE2+EMUFRA(IC)*XSQE2(IE,IQ,IC)
                  SIGPRO = SIGPRO+EMUFRA(IC)*XSPRO(IE,IQ,IC)
                  SIGDEL = SIGDEL+EMUFRA(IC)*XSDEL(IE,IQ,IC)
                  SIGDQE = SIGDQE+EMUFRA(IC)*XSDQE(IE,IQ,IC)
                  ERRTOT = ERRTOT+XETOT(IE,IQ,IC)**2
                  ERRELA = ERRELA+XEELA(IE,IQ,IC)**2
                  ERRQEP = ERRQEP+XEQEP(IE,IQ,IC)**2
                  ERRQET = ERRQET+XEQET(IE,IQ,IC)**2
                  ERRQE2 = ERRQE2+XEQE2(IE,IQ,IC)**2
                  ERRPRO = ERRPRO+XEPRO(IE,IQ,IC)**2
                  ERRDEL = ERRDEL+XEDEL(IE,IQ,IC)**2
                  ERRDQE = ERRDQE+XEDQE(IE,IQ,IC)**2
    3          CONTINUE
               ERRTOT = SQRT(ERRTOT)
               ERRELA = SQRT(ERRELA)
               ERRQEP = SQRT(ERRQEP)
               ERRQET = SQRT(ERRQET)
               ERRQE2 = SQRT(ERRQE2)
               ERRPRO = SQRT(ERRPRO)
               ERRDEL = SQRT(ERRDEL)
               ERRDQE = SQRT(ERRDQE)
            ELSE
               SIGTOT = XSTOT(IE,IQ,1)
               SIGELA = XSELA(IE,IQ,1)
               SIGQEP = XSQEP(IE,IQ,1)
               SIGQET = XSQET(IE,IQ,1)
               SIGQE2 = XSQE2(IE,IQ,1)
               SIGPRO = XSPRO(IE,IQ,1)
               SIGDEL = XSDEL(IE,IQ,1)
               SIGDQE = XSDQE(IE,IQ,1)
               ERRTOT = XETOT(IE,IQ,1)
               ERRELA = XEELA(IE,IQ,1)
               ERRQEP = XEQEP(IE,IQ,1)
               ERRQET = XEQET(IE,IQ,1)
               ERRQE2 = XEQE2(IE,IQ,1)
               ERRPRO = XEPRO(IE,IQ,1)
               ERRDEL = XEDEL(IE,IQ,1)
               ERRDQE = XEDQE(IE,IQ,1)
            ENDIF
            IF (MCGENE.NE.4) THEN
               WRITE(ErrorOut,1000) ECMNN(IE),Q2G(IQ)
 1000         FORMAT(/,1X,'E_CM =',F9.1,' GEV  Q^2 =',F6.1,' GEV^2 :',/)
               WRITE(ErrorOut,1001) SIGTOT,ERRTOT
 1001          FORMAT(1X,'TOTAL',32X,F10.4,' +-',F11.5,' MB')
               WRITE(ErrorOut,1002) SIGELA,ERRELA
 1002          FORMAT(1X,'ELASTIC',30X,F10.4,' +-',F11.5,' MB')
               WRITE(ErrorOut,1003) SIGQEP,ERRQEP
 1003          FORMAT(1X,'QUASI-ELASTIC (A+B-->A+X)',12X,F10.4,' +-',
     &                F11.5,' MB')
               WRITE(ErrorOut,1004) SIGQET,ERRQET
 1004          FORMAT(1X,'QUASI-ELASTIC (A+B-->X+B)',12X,F10.4,' +-',
     &                F11.5,' MB')
               WRITE(ErrorOut,1005) SIGQE2,ERRQE2
 1005          FORMAT(1X,'QUASI-ELASTIC (A+B-->X, EXCL. 2-4)',3X,F10.4,
     &                ' +-',F11.5,' MB')
               WRITE(ErrorOut,1006) SIGPRO,ERRPRO
 1006          FORMAT(1X,'PRODUCTION',27X,F10.4,' +-',F11.5,' MB')
               WRITE(ErrorOut,1007) SIGDEL,ERRDEL
 1007          FORMAT(1X,'DIFF-EL   ',27X,F10.4,' +-',F11.5,' MB')
               WRITE(ErrorOut,1008) SIGDQE,ERRDQE
 1008          FORMAT(1X,'DIFF-QEL  ',27X,F10.4,' +-',F11.5,' MB')
            ENDIF

    2    CONTINUE
    1 CONTINUE

      RETURN
      END
c
c===sigga==============================================================*
c
CDECK  ID>, DT_SIGGA
      SUBROUTINE DT_SIGGA(NTI,XI,Q2I,ECMI,XNUI,STOT,ETOT,SIN,EIN,STOT0)

c***********************************************************************
c Total/inelastic photon-nucleus cross sections.                       *
c     !!!! Overwrites SHMAKI-initialization. Do not use it during      *
c          production runs !!!!                                        *
c This version dated 27.03.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY2=1.0D-2,ZERO=0.0D0,DLARGE=1.0D10,
     &           OHALF=0.5D0,ONE=1.0D0)
      PARAMETER (AMPROT = 0.938D0)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI


      NT  = NTI
      X   = XI
      Q2  = Q2I
      ECM = ECMI
      XNU = XNUI
      IF ((ECMI.LE.ZERO).AND.(XNUI.GT.ZERO))
     &   ECM = SQRT(AMPROT**2-Q2+2.0D0*XNUI*AMPROT)
      CALL DT_XSGLAU(1,NT,7,X,Q2,ECM,1,1,-1)
      STOT  = XSTOT(1,1,1)
      ETOT  = XETOT(1,1,1)
      SIN   = XSPRO(1,1,1)
      EIN   = XEPRO(1,1,1)

      RETURN
      END
c
c===siggat=============================================================*
c
CDECK  ID>, DT_SIGGAT
      SUBROUTINE DT_SIGGAT(Q2I,ECMI,STOT,NT)

c***********************************************************************
c Total/inelastic photon-nucleus cross sections.                       *
c Uses pre-tabulated cross section.                                    *
c This version dated 29.07.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY14=1.0D-14,
     &           ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI


      NTARG = ABS(NT)
      I1   = 1
      I2   = 1
      RATE = ONE
      IF (NEBINI.GT.1) THEN
         IF (ECMI.GE.ECMNN(NEBINI)) THEN
            I1   = NEBINI
            I2   = NEBINI
            RATE = ONE
         ELSEIF (ECMI.GT.ECMNN(1)) THEN
            DO 1 I=2,NEBINI
               IF (ECMI.LT.ECMNN(I)) THEN
                  I1   = I-1
                  I2   = I
                  RATE = (ECMI-ECMNN(I1))/(ECMNN(I2)-ECMNN(I1))
                  GOTO 2
               ENDIF
    1       CONTINUE
    2       CONTINUE
         ENDIF
      ENDIF
      J1   = 1
      J2   = 1
      RATQ = ONE
      IF (NQBINI.GT.1) THEN
         IF (Q2I.GE.Q2G(NQBINI)) THEN
            J1   = NQBINI
            J2   = NQBINI
            RATQ = ONE
         ELSEIF (Q2I.GT.Q2G(1)) THEN
            DO 3 I=2,NQBINI
               IF (Q2I.LT.Q2G(I)) THEN
                  J1   = I-1
                  J2   = I
                  RATQ = LOG10(    Q2I/MAX(Q2G(J1),TINY14))/
     &                   LOG10(Q2G(J2)/MAX(Q2G(J1),TINY14))
C                 RATQ = (Q2I-Q2G(J1))/(Q2G(J2)-Q2G(J1))
                  GOTO 4
               ENDIF
    3       CONTINUE
    4       CONTINUE
         ENDIF
      ENDIF

      STOT = XSTOT(I1,J1,NTARG)+
     &   RATE*(XSTOT(I2,J1,NTARG)-XSTOT(I1,J1,NTARG))+
     &   RATQ*(XSTOT(I1,J2,NTARG)-XSTOT(I1,J1,NTARG))+
     &   RATE*RATQ*(XSTOT(I2,J2,NTARG)-XSTOT(I1,J2,NTARG)+
     &              XSTOT(I1,J1,NTARG)-XSTOT(I2,J1,NTARG))

      RETURN
      END
c
c===sigano=============================================================*
c
CDECK  ID>, DT_SANO
      DOUBLE PRECISION FUNCTION DT_SANO(ECM)

c***********************************************************************
c This version dated 31.07.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY14=1.0D-14,
     &           ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0)
      PARAMETER (NE = 8)

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG


      DIMENSION ECMANO(NE),FRAANO(NE),SIGHRD(NE)
      DATA ECMANO /
     &             0.200D+02,0.500D+02,0.100D+03,0.200D+03,0.500D+03,
     &             0.100D+04,0.200D+04,0.500D+04
     &            /
c fixed cut (3 GeV/c)
      DATA FRAANO /
     &             0.085D+00,0.114D+00,0.105D+00,0.091D+00,0.073D+00,
     &             0.062D+00,0.054D+00,0.042D+00
     &            /
      DATA SIGHRD /
     &           4.0099D-04,3.3104D-03,1.1905D-02,3.6435D-02,1.3493D-01,
     &           3.3086D-01,7.6255D-01,2.1319D+00
     &            /
c running cut (based on obsolete Phojet-caluclations, bugs..)
C     DATA FRAANO /
C    &             0.251E+00,0.313E+00,0.279E+00,0.239E+00,0.186E+00,
C    &             0.167E+00,0.150E+00,0.131E+00
C    &            /
C     DATA SIGHRD /
C    &           6.6569E-04,4.4949E-03,1.4837E-02,4.1466E-02,1.5071E-01,
C    &           2.5736E-01,4.5593E-01,8.2550E-01
C    &            /

      DT_SANO = ZERO
      IF ((ISHAD(2).NE.1).OR.(IJPROJ.NE.7)) RETURN
      J1   = 0
      J2   = 0
      RATE = ONE
      IF (ECM.GE.ECMANO(NE)) THEN
         J1 = NE
         J2 = NE
      ELSEIF (ECM.GT.ECMANO(1)) THEN
         DO 1 IE=2,NE
            IF (ECM.LT.ECMANO(IE)) THEN
               J1   = IE-1
               J2   = IE
               RATE = LOG10(ECM/ECMANO(J1))/LOG10(ECMANO(J2)/ECMANO(J1))
               GOTO 2
            ENDIF
    1    CONTINUE
    2    CONTINUE
      ENDIF
      IF ((J1.GT.0).AND.(J2.GT.0)) THEN
         AFRA1  = LOG10(MAX(FRAANO(J1)*SIGHRD(J1),TINY14))
         AFRA2  = LOG10(MAX(FRAANO(J2)*SIGHRD(J2),TINY14))
         DT_SANO = 10.0D0**(AFRA1+RATE*(AFRA2-AFRA1))
      ENDIF

      RETURN
      END
c
c===siggp==============================================================*
c
CDECK  ID>, DT_SIGGP
      SUBROUTINE DT_SIGGP(XI,Q2I,ECMI,XNUI,STOT,SINE,SDIR)

c***********************************************************************
c Total/inelastic photon-nucleon cross sections.                       *
c This version dated 30.04.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0)
      PARAMETER (TWOPI  = 6.283185307179586476925286766559D+00,
     &           PI     = TWOPI/TWO,
     &           GEV2MB = 0.38938D0,
     &           ALPHEM = ONE/137.0D0)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)


c*PHOJET105a
C     CHARACTER*8 MDLNA
C     COMMON /MODELS/ MDLNA(50),ISWMDL(50),PARMDL(200),IPAMDL(100)
C     PARAMETER (IEETAB=10)
C     COMMON /XSETAB/ SIGTAB(4,70,IEETAB),SIGECM(4,IEETAB),ISIMAX
c*PHOJET110
C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX

c*

C     PARAMETER (NPOINT=80)
      PARAMETER (NPOINT=16)
      DIMENSION ABSZX(NPOINT),WEIGHT(NPOINT)

      STOT = ZERO
      SINE = ZERO
      SDIR = ZERO

      W2 = ECMI**2
      IF ((ECMI.LE.ZERO).AND.(XNUI.GT.ZERO))
     &   W2 = AAM(1)**2-Q2I+TWO*XNUI*AAM(1)
      Q2 = Q2I
      X  = XI
c photoprod.
      IF ((X.LE.ZERO).AND.(Q2.LE.ZERO).AND.(W2.GT.ZERO)) THEN
         Q2 = 0.0001D0
         X  = Q2/(W2+Q2-AAM(1)**2)
c DIS
      ELSEIF ((X.LE.ZERO).AND.(Q2.GT.ZERO).AND.(W2.GT.ZERO)) THEN
         X  = Q2/(W2+Q2-AAM(1)**2)
      ELSEIF ((X.GT.ZERO).AND.(Q2.LE.ZERO).AND.(W2.GT.ZERO)) THEN
         Q2 = (W2-AAM(1)**2)*X/(ONE-X)
      ELSEIF ((X.GT.ZERO).AND.(Q2.GT.ZERO)) THEN
         W2 = Q2*(ONE-X)/X+AAM(1)**2
      ELSE
         WRITE(ErrorOut,*) 'SIGGP: inconsistent input ',W2,Q2,X
         STOP
      ENDIF
      ECM = SQRT(W2)

      IF (MODEGA.EQ.1) THEN
         SCALE = SQRT(Q2)
         CALL DT_CKMT(X,SCALE,UPV,DNV,USEA,DSEA,STR,CHM,BOT,TOP,GL,F2,
     &                                                       IDPDF)
C        W = SQRT(W2)

C        ALLMF2 = PHO_ALLM97(Q2,W)

C        write(*,*) 'X,Q2,W,F2,ALLMF2',X,Q2,W,F2,ALLMF2
         STOT = TWOPI**2*ALPHEM/(Q2*(ONE-X)) * F2 *GEV2MB
         SINE = ZERO
         SDIR = ZERO
      ELSEIF (MODEGA.EQ.2) THEN
         IF (INTRGE(1).EQ.1) THEN
            AMLO2 = (3.0D0*AAM(13))**2
         ELSEIF (INTRGE(1).EQ.2) THEN
            AMLO2 = AAM(33)**2
         ELSE
            AMLO2 = AAM(96)**2
         ENDIF
         IF (INTRGE(2).EQ.1) THEN
            AMHI2 = W2/TWO
         ELSEIF (INTRGE(2).EQ.2) THEN
            AMHI2 = W2/4.0D0
         ELSE
            AMHI2 = W2
         ENDIF
         AMHI20 = (ECM-AAM(1))**2
         IF (AMHI2.GE.AMHI20) AMHI2 = AMHI20
         XAMLO  = LOG( AMLO2+Q2 )
         XAMHI  = LOG( AMHI2+Q2 )
c*PHOJET105a
C        CALL GSET(XAMLO,XAMHI,NPOINT,ABSZX,WEIGHT)
c*PHOJET112

         CALL PHO_GAUSET(XAMLO,XAMHI,NPOINT,ABSZX,WEIGHT)

c*
         SUM  = ZERO
         DO 1 J=1,NPOINT
            AM2 = EXP(ABSZX(J))-Q2
            IF (AM2.LT.16.0D0) THEN
               R = TWO
            ELSEIF ((AM2.GE.16.0D0).AND.(AM2.LT.121.0D0)) THEN
               R = 10.0D0/3.0D0
            ELSE
               R = 11.0D0/3.0D0
            ENDIF
C           FAC = R * AM2/( (AM2+Q2)*(AM2+Q2+RL2) )
            FAC = R * AM2/( (AM2+Q2)*(AM2+Q2+RL2) )
     &            * (ONE+EPSPOL*Q2/AM2)
            SUM = SUM+WEIGHT(J)*FAC
    1    CONTINUE
         SINE = SUM
         SDIR = DT_SIGVP(X,Q2)
         STOT = ALPHEM/(3.0D0*PI*(ONE-X))*SUM*SDIR
         SDIR = SDIR/(0.588D0+RL2+Q2)
C        STOT = ALPHEM/(3.0D0*PI*(ONE-X))*SUM*DT_SIGVP(X,Q2)
      ELSEIF (MODEGA.EQ.3) THEN
         CALL DT_SIGGA(1,XI,Q2I,ECMI,ZERO,STOT,ETOT,SINE,EINE,DUM)
      ELSEIF (MODEGA.EQ.4) THEN
c  load cross sections from PHOJET interpolation table
         IP = 1
         IF(ECM.LE.SIGECM(IP,1)) THEN
           I1 = 1
           I2 = 1
         ELSEIF (ECM.LT.SIGECM(IP,ISIMAX)) THEN
           DO 2 I=2,ISIMAX
              IF (ECM.LE.SIGECM(IP,I)) GOTO 3
    2      CONTINUE
    3      CONTINUE
           I1 = I-1
           I2 = I
         ELSE
           WRITE(ErrorOut,'(/1X,A,2E12.3)')
     &       'SIGGP:WARNING:TOO HIGH ENERGY',ECM,SIGECM(IP,ISIMAX)
           I1 = ISIMAX
           I2 = ISIMAX
         ENDIF
         FAC2 = ZERO
         IF (I1.NE.I2) FAC2 = LOG(ECM/SIGECM(IP,I1))
     &                       /LOG(SIGECM(IP,I2)/SIGECM(IP,I1))
         FAC1 = ONE-FAC2
c  cross section dependence on photon virtuality
         FSUP1 = ZERO
         DO 4 I=1,3
            FSUP1 = FSUP1+PARMDL(26+I)*(1.D0+Q2/(4.D0*PARMDL(30+I)))
     &                                /(1.D0+Q2/PARMDL(30+I))**2
    4    CONTINUE
         FSUP1 = FSUP1+PARMDL(30)/(1.D0+Q2/PARMDL(34))
         FAC1  = FAC1*FSUP1
         FAC2  = FAC2*FSUP1
         FSUP2 = 1.0D0
         STOT  = FAC2*SIGTAB(IP, 1,I2)+FAC1*SIGTAB(IP, 1,I1)
         SINE  = FAC2*SIGTAB(IP,28,I2)+FAC1*SIGTAB(IP,28,I1)
         SDIR  = FAC2*SIGTAB(IP,29,I2)+FAC1*SIGTAB(IP,29,I1)
c*re:
         STOT  = STOT-SDIR
c*
         SDIR  = SDIR/(FSUP1*FSUP2)
c*re:
         STOT  = STOT+SDIR
c*
      ENDIF

      RETURN
      END
c
c===sigvel=============================================================*
c
CDECK  ID>, DT_SIGVEL
      SUBROUTINE DT_SIGVEL(XI,Q2I,ECMI,XNUI,IDXV,SVEL,SIG1,SIG2)

c***********************************************************************
c Cross section for elastic vector meson production                    *
c This version dated 10.05.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0)
      PARAMETER (TWOPI  = 6.283185307179586476925286766559D+00,
     &           PI     = TWOPI/TWO,
     &           GEV2MB = 0.38938D0,
     &           ALPHEM = ONE/137.0D0)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)


      W2 = ECMI**2
      IF ((ECMI.LE.ZERO).AND.(XNUI.GT.ZERO))
     &   W2 = AAM(1)**2-Q2I+TWO*XNUI*AAM(1)
      Q2 = Q2I
      X  = XI
c photoprod.
      IF ((X.LE.ZERO).AND.(Q2.LE.ZERO).AND.(W2.GT.ZERO)) THEN
         Q2 = 0.0001D0
         X  = Q2/(W2+Q2-AAM(1)**2)
c DIS
      ELSEIF ((X.LE.ZERO).AND.(Q2.GT.ZERO).AND.(W2.GT.ZERO)) THEN
         X  = Q2/(W2+Q2-AAM(1)**2)
      ELSEIF ((X.GT.ZERO).AND.(Q2.LE.ZERO).AND.(W2.GT.ZERO)) THEN
         Q2 = (W2-AAM(1)**2)*X/(ONE-X)
      ELSEIF ((X.GT.ZERO).AND.(Q2.GT.ZERO)) THEN
         W2 = Q2*(ONE-X)/X+AAM(1)**2
      ELSE
         WRITE(ErrorOut,*) 'SIGVEL: inconsistent input ',W2,Q2,X
         STOP
      ENDIF
      ECM = SQRT(W2)

      AMV  = AAM(IDXV)
      AMV2 = AMV**2

      BSLOPE = 2.0D0*(2.0D0+AAM(32)**2/(AMV2+Q2)
     &        +0.25D0*LOG(W2/(AMV2+Q2)))*GEV2MB
      ROSH   = 0.1D0
      STOVP  = DT_SIGVP(X,Q2)/(AMV2+Q2+RL2)
      SELVP  = STOVP**2*(ONE+ROSH**2)/(8.0D0*TWOPI*BSLOPE)

      IF (IDXV.EQ.33) THEN
         COUPL = 0.00365D0
      ELSE
         STOP
      ENDIF
      SIG1 = (AMV2/(AMV2+Q2))**2 * (ONE+EPSPOL*Q2/AMV2)
      SIG2 = SELVP
      SVEL  = COUPL * (AMV2/(AMV2+Q2))**2
     &              * (ONE+EPSPOL*Q2/AMV2) * SELVP

      RETURN
      END
c
c===sigvp==============================================================*
c
CDECK  ID>, DT_SIGVP
      DOUBLE PRECISION FUNCTION DT_SIGVP(XI,Q2I)

c***********************************************************************
c sigma_Vp                                                             *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0)
      PARAMETER (TWOPI = 6.283185307179586476925286766559D+00,
     &           PI    = TWOPI/TWO,
     &           GEV2MB = 0.38938D0,
     &           AMPROT = 0.938D0,
     &           ALPHEM = ONE/137.0D0)
c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)


      X  = XI
      Q2 = Q2I
      IF (XI.LE.ZERO)  X  = 0.0001D0
      IF (Q2I.LE.ZERO) Q2 = 0.0001D0

      ECM    = SQRT( Q2*(ONE-X)/X+AMPROT**2 )

      SCALE = SQRT(Q2)
      IF (MODEGA.EQ.1) THEN
         CALL DT_CKMT(X,SCALE,UPV,DNV,USEA,DSEA,STR,CHM,BOT,TOP,GL,F2,
     &                                                       IDPDF)
C        W = ECM

C        ALLMF2 = PHO_ALLM97(Q2,W)

C        write(*,*) 'X,Q2,W,F2,ALLMF2',X,Q2,W,F2,ALLMF2
C        STOT = TWOPI**2*ALPHEM/(Q2*(ONE-X)) * F2 *GEV2MB
C        DT_SIGVP = 12.0D0*PI**3.0D0*F2/(Q2*DT_RRM2(X,Q2))
         DT_SIGVP = 12.0D0*PI**3.0D0*F2/(Q2*DT_RRM2(X,Q2))*GEV2MB
      ELSEIF (MODEGA.EQ.4) THEN
         CALL DT_SIGGP(X,Q2,ECM,DUM1,STOT,DUM2,DUM3)
C        F2 = Q2*(ONE-X)/(TWOPI**2*ALPHEM*GEV2MB) * STOT
         DT_SIGVP = 3.0D0*PI/(ALPHEM*DT_RRM2(X,Q2)) * STOT
      ELSE
         STOP ' DT_SIGVP: F2 NOT DEFINED FOR THIS MODEGA !'
      ENDIF

      RETURN

      END
c
c===RRM2===============================================================*
c
CDECK  ID>, DT_RRM2
      DOUBLE PRECISION FUNCTION DT_RRM2(X,Q2)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0)
      PARAMETER (TWOPI = 6.283185307179586476925286766559D+00,
     &           PI    = TWOPI/TWO,
     &           GEV2MB = 0.38938D0)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)


      S   = Q2*(ONE-X)/X+AAM(1)**2
      ECM = SQRT(S)

      IF (INTRGE(1).EQ.1) THEN
         AMLO2 = (3.0D0*AAM(13))**2
      ELSEIF (INTRGE(1).EQ.2) THEN
         AMLO2 = AAM(33)**2
      ELSE
         AMLO2 = AAM(96)**2
      ENDIF
      IF (INTRGE(2).EQ.1) THEN
         AMHI2 = S/TWO
      ELSEIF (INTRGE(2).EQ.2) THEN
         AMHI2 = S/4.0D0
      ELSE
         AMHI2 = S
      ENDIF
      AMHI20 = (ECM-AAM(1))**2
      IF (AMHI2.GE.AMHI20) AMHI2 = AMHI20

      AM1C2 = 16.0D0
      AM2C2 = 121.0D0
      IF (AMHI2.LE.AM1C2) THEN
         DT_RRM2 = TWO*DT_RM2(AMLO2,AMHI2,Q2)
      ELSEIF ((AMHI2.GT.AM1C2).AND.(AMHI2.LE.AM2C2)) THEN
         DT_RRM2 = TWO*DT_RM2(AMLO2,AM1C2,Q2)+
     &          10.0D0/3.0D0*DT_RM2(AM1C2,AMHI2,Q2)
      ELSE
         DT_RRM2 = TWO*DT_RM2(AMLO2,AM1C2,Q2)+
     &          10.0D0/3.0D0*DT_RM2(AM1C2,AM2C2,Q2)+
     &          11.0D0/3.0D0*DT_RM2(AM2C2,AMHI2,Q2)
      ENDIF

      RETURN
      END
c
c===RM2================================================================*
c
CDECK  ID>, DT_RM2
      DOUBLE PRECISION FUNCTION DT_RM2(AMLO2,AMHI2,Q2)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0)
      PARAMETER (TWOPI = 6.283185307179586476925286766559D+00,
     &           PI    = TWOPI/TWO,
     &           GEV2MB = 0.38938D0)
c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)


      IF (RL2.LE.ZERO) THEN
         DT_RM2 = -ONE/(AMHI2+Q2)+Q2/(TWO*(AMHI2+Q2)**2) -
     &        (-ONE/(AMLO2+Q2)+Q2/(TWO*(AMLO2+Q2)**2))
     &         +EPSPOL*(-Q2/(TWO*(AMHI2+Q2)**2)+Q2/(TWO*(AMLO2+Q2)**2))
      ELSE
         TMPMLO = LOG(ONE+RL2/(AMLO2+Q2))
         TMPMHI = LOG(ONE+RL2/(AMHI2+Q2))
         DT_RM2 = Q2/(RL2*(AMHI2+Q2))-(Q2+RL2)/RL2**2*TMPMHI
     &       -(Q2/(RL2*(AMLO2+Q2))-(Q2+RL2)/RL2**2*TMPMLO)
     &       +EPSPOL*(
     &         -Q2/(RL2*(AMHI2+Q2))+Q2/RL2**2*TMPMHI
     &       -(-Q2/(RL2*(AMLO2+Q2))+Q2/RL2**2*TMPMLO))
      ENDIF

      RETURN
      END
c
c===SAM2===============================================================*
c
CDECK  ID>, DT_SAM2
      DOUBLE PRECISION FUNCTION DT_SAM2(Q2,ECM)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0,
     &           TENTRD=10.0D0/3.0D0,ELVTRD=11.0D0/3.0D0)
      PARAMETER (TWOPI = 6.283185307179586476925286766559D+00,
     &           PI    = TWOPI/TWO,
     &           GEV2MB = 0.38938D0)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)


      S = ECM**2
      IF (INTRGE(1).EQ.1) THEN
         AMLO2 = (3.0D0*AAM(13))**2
      ELSEIF (INTRGE(1).EQ.2) THEN
         AMLO2 = AAM(33)**2
      ELSE
         AMLO2 = AAM(96)**2
      ENDIF
      IF (INTRGE(2).EQ.1) THEN
         AMHI2 = S/TWO
      ELSEIF (INTRGE(2).EQ.2) THEN
         AMHI2 = S/4.0D0
      ELSE
         AMHI2 = S
      ENDIF
      AMHI20 = (ECM-AAM(1))**2
      IF (AMHI2.GE.AMHI20) AMHI2 = AMHI20

      AM1C2 = 16.0D0
      AM2C2 = 121.0D0
      YLO   = LOG(AMLO2+Q2)
      YC1   = LOG(AM1C2+Q2)
      YC2   = LOG(AM2C2+Q2)
      YHI   = LOG(AMHI2+Q2)
      IF (AMHI2.LE.AM1C2) THEN
         FACHI = TWO
      ELSEIF ((AMHI2.GT.AM1C2).AND.(AMHI2.LE.AM2C2)) THEN
         FACHI = TENTRD
      ELSE
         FACHI = ELVTRD
      ENDIF

    1 CONTINUE
      YSAM2  = YLO+(YHI-YLO)*DT_RNDM(AM1C2)
      IF (YSAM2.LE.YC1) THEN
         FAC = TWO
      ELSEIF ((YSAM2.GT.YC1).AND.(YSAM2.LE.YC2)) THEN
         FAC = TENTRD
      ELSE
         FAC = ELVTRD
      ENDIF
      WEIGMX = FACHI*(ONE-Q2*EXP(  -YHI))
      XSAM2  = FAC  *(ONE-Q2*EXP(-YSAM2))
      IF (DT_RNDM(YSAM2)*WEIGMX.GT.XSAM2) GOTO 1

      DT_SAM2   = EXP(YSAM2)-Q2

      RETURN
      END
c
c===ckmt===============================================================*
c
CDECK  ID>, DT_CKMT
      SUBROUTINE DT_CKMT(X,SCALE,UPV,DNV,USEA,DSEA,STR,CHM,BOT,TOP,GL,
     &                F2,IPAR)

c***********************************************************************
c This version dated 31.01.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TWO=2.0D0,TINY10=1.0D-10)

      PARAMETER (Q02 = 2.0D0,
     &           DQ2 = 10.05D0,
     &           Q12 = Q02+DQ2)

      DIMENSION PD(-6:6),SEA(3),VAL(2)

      CALL DT_PDF0(Q02,X,F2Q0,VAL,SEA,GLU,IPAR)
      CALL DT_PDF0(Q12,X,F2Q1,VAL,SEA,GLU,IPAR)
      ADQ2 = LOG10(Q12)-LOG10(Q02)
      F2P  = (F2Q1-F2Q0)/ADQ2
      CALL DT_CKMTX(IPAR,X,Q02,PD,F2PQ0)
      CALL DT_CKMTX(IPAR,X,Q12,PD,F2PQ1)
      F2PP = (F2PQ1-F2PQ0)/ADQ2
      FX   = (F2P-F2PP)/(F2PP+LOG(DQ2)*F2PQ0+TINY10)*Q02

      Q2     = MAX(SCALE**2.0D0,TINY10)
      SMOOTH = 1.0D0+FX*(Q2-Q02)/Q2**2
      IF (Q2.LT.Q02) THEN
         CALL DT_PDF0(Q2,X,F2,VAL,SEA,GLU,IPAR)
         UPV  = VAL(1)
         DNV  = VAL(2)
         USEA = SEA(1)
         DSEA = SEA(2)
         STR  = SEA(3)
         CHM  = 0.0D0
         BOT  = 0.0D0
         TOP  = 0.0D0
         GL   = GLU
      ELSE
         CALL DT_CKMTX(IPAR,X,Q2,PD,F2)
         F2 = F2*SMOOTH
         UPV  = PD(2)-PD(3)
         DNV  = PD(1)-PD(3)
         USEA = PD(3)
         DSEA = PD(3)
         STR  = PD(3)
         CHM  = PD(4)
         BOT  = PD(5)
         TOP  = PD(6)
         GL   = PD(0)
C        UPV  = UPV*SMOOTH
C        DNV  = DNV*SMOOTH
C        USEA = USEA*SMOOTH
C        DSEA = DSEA*SMOOTH
C        STR  = STR*SMOOTH
C        CHM  = CHM*SMOOTH
C        GL   = GL*SMOOTH
      ENDIF

      RETURN
      END
C
CDECK  ID>, DT_CKMTX
      SUBROUTINE DT_CKMTX(IPAR,X,SCALE2,PD,F2)
C**********************************************************************
C
C     PDF based on Regge theory, evolved with .... by ....
C
C     input: IPAR     2212   proton (not installed)
C                       45   Pomeron
C                      100   Deuteron
C
C     output: PD(-6:6) x*f(x)  parton distribution functions
C            (PDFLIB convention: d = PD(1), u = PD(2) )
C
C**********************************************************************
#include "Zmanagerp.h"

      SAVE
      DOUBLE PRECISION  X,SCALE2,PD(-6:6),CDN,CUP,F2
      DIMENSION QQ(7)
C
      Q2=SNGL(SCALE2)
      Q1S=Q2
      XX=SNGL(X)
C  QCD lambda for evolution
      OWLAM = 0.23D0
      OWLAM2=OWLAM**2
C  Q0**2 for evolution
      Q02 = 2.D0
C
C
C  the conventions are : q(1)=x*u, q(2)=x*d, q(3)=q(4)=x*sbar=x*ubar=...
C                        q(6)=x*charm, q(7)=x*gluon
C
      SB=0.
      IF(Q2-Q02) 1,1,2
    2 SB=LOG(LOG(Q2/OWLAM2)/LOG(Q02/OWLAM2))
    1 CONTINUE
      IF(IPAR.EQ.2212) THEN
        CALL DT_CKMTPR(1,0,XX,SB,QQ(1))
        CALL DT_CKMTPR(2,0,XX,SB,QQ(2))
        CALL DT_CKMTPR(3,0,XX,SB,QQ(3))
        CALL DT_CKMTPR(4,0,XX,SB,QQ(4))
        CALL DT_CKMTPR(5,0,XX,SB,QQ(5))
        CALL DT_CKMTPR(8,0,XX,SB,QQ(6))
        CALL DT_CKMTPR(7,0,XX,SB,QQ(7))
C     ELSEIF (IPAR.EQ.45) THEN
C       CALL CKMTPO(1,0,XX,SB,QQ(1))
C       CALL CKMTPO(2,0,XX,SB,QQ(2))
C       CALL CKMTPO(3,0,XX,SB,QQ(3))
C       CALL CKMTPO(4,0,XX,SB,QQ(4))
C       CALL CKMTPO(5,0,XX,SB,QQ(5))
C       CALL CKMTPO(8,0,XX,SB,QQ(6))
C       CALL CKMTPO(7,0,XX,SB,QQ(7))
      ELSEIF (IPAR.EQ.100) THEN
        CALL DT_CKMTDE(1,0,XX,SB,QQ(1))
        CALL DT_CKMTDE(2,0,XX,SB,QQ(2))
        CALL DT_CKMTDE(3,0,XX,SB,QQ(3))
        CALL DT_CKMTDE(4,0,XX,SB,QQ(4))
        CALL DT_CKMTDE(5,0,XX,SB,QQ(5))
        CALL DT_CKMTDE(8,0,XX,SB,QQ(6))
        CALL DT_CKMTDE(7,0,XX,SB,QQ(7))
      ELSE
        WRITE(ErrorOut,'(1X,A,I4,A)')
     &     'CKMTX:   IPAR =',IPAR,' NOT IMPLEMENTED!'
        STOP
      ENDIF
C
      PD(-6) = 0.D0
      PD(-5) = 0.D0
      PD(-4) = DBLE(QQ(6))
      PD(-3) = DBLE(QQ(3))
      PD(-2) = DBLE(QQ(4))
      PD(-1) = DBLE(QQ(5))
      PD(0)  = DBLE(QQ(7))
      PD(1)  = DBLE(QQ(2))
      PD(2)  = DBLE(QQ(1))
      PD(3)  = DBLE(QQ(3))
      PD(4)  = DBLE(QQ(6))
      PD(5)  = 0.D0
      PD(6)  = 0.D0
      IF(IPAR.EQ.45) THEN
        CDN = (PD(1)-PD(-1))/2.D0
        CUP = (PD(2)-PD(-2))/2.D0
        PD(-1) = PD(-1) + CDN
        PD(-2) = PD(-2) + CUP
        PD(1) = PD(-1)
        PD(2) = PD(-2)
      ENDIF
      F2 = 4.0D0/9.0D0*(PD(2)-PD(3)+2.0D0*PD(3))+
     &     1.0D0/9.0D0*(PD(1)-PD(3)+2.0D0*PD(3))+
     &     1.0D0/9.0D0*(2.0D0*PD(3))+4.0D0/9.0D0*(2.0D0*PD(4))
      END
C
c
c===pdf0===============================================================*
c
CDECK  ID>, DT_PDF0
      SUBROUTINE DT_PDF0(Q2,X,F2,VAL,SEA,GLU,IPAR)

c***********************************************************************
c This subroutine calculates F_2 and PDF below Q^2=Q_0^2=2 GeV^2       *
c an F_2-ansatz given in Capella et al. PLB 337(1994)358.              *
c                   IPAR  = 2212   proton                              *
c                         =  100   deuteron                            *
c This version dated 31.01.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY9=1.0D-9)

      PARAMETER (
     &              AA     = 0.1502D0,
     &              BBDEU  = 1.2D0,
     &              BUD    = 0.754D0,
     &              BDD    = 0.4495D0,
     &              BUP    = 1.2064D0,
     &              BDP    = 0.1798D0,
     &              DELTA0 = 0.07684D0,
     &              D      = 1.117D0,
     &              C      = 3.5489D0,
     &              A      = 0.2631D0,
     &              B      = 0.6452D0,
     &              ALPHAR = 0.415D0,
     &              E      = 0.1D0
     &          )

      PARAMETER (NPOINT=16)
C     DIMENSION ABSZX(NPOINT),WEIGHT(NPOINT)
      DIMENSION SEA(3),VAL(2)

      DELTA = DELTA0*(1.0D0+2.0D0*Q2/(Q2+D))
      AN    = 1.5D0*(1.0D0+Q2/(Q2+C))
c proton, deuteron
      IF ((IPAR.EQ.2212).OR.(IPAR.EQ.100)) THEN
         CALL DT_CKMTQ0(Q2,X,IPAR,VALU0,VALD0,SEA0)
         SEA(1) = 0.75D0*SEA0
         SEA(2) = SEA(1)
         SEA(3) = SEA(1)
         VAL(1) = 9.0D0/4.0D0*VALU0
         VAL(2) = 9.0D0*VALD0
         GLU0   = SEA(1)/(1.0D0-X)
         F2     = SEA0+VALU0+VALD0
         F2PDF  = 4.0D0/9.0D0*(VAL(1)+2.0D0*SEA(1))+
     &            1.0D0/9.0D0*(VAL(2)+2.0D0*SEA(2))+
     &            1.0D0/9.0D0*(2.0D0*SEA(3))
         IF (ABS(F2-F2PDF).GT.TINY9) THEN
            WRITE(ErrorOut,
     * '(1X,A,2E15.5)') 'inconsistent PDF! ',F2,F2PDF
            STOP
         ENDIF
c*PHOJET105a
C        CALL GSET(ZERO,ONE,NPOINT,ABSZX,WEIGHT)
c*PHOJET112

C        CALL PHO_GAUSET(ZERO,ONE,NPOINT,ABSZX,WEIGHT)

c*
C        SUMQ = ZERO
C        SUMG = ZERO
C        DO 1 J=1,NPOINT
C           CALL DT_CKMTQ0(Q2,ABSZX(J),IPAR,VALU0,VALD0,SEA0)
C           VALU0 = 9.0D0/4.0D0*VALU0
C           VALD0 = 9.0D0*VALD0
C           SEA0  = 0.75D0*SEA0
C           SUMQ  = SUMQ+ (VALU0+VALD0+6.0D0*SEA0) *WEIGHT(J)
C           SUMG  = SUMG+ (SEA0/(1.0D0-ABSZX(J)))  *WEIGHT(J)
C   1    CONTINUE
C        GLU = GLU0*(1.0D0-SUMQ)/SUMG
      ELSE
         WRITE(ErrorOut,'(1X,A,I4,A)')
     &      'PDF0:   IPAR =',IPAR,' NOT IMPLEMENTED!'
         STOP
      ENDIF

      RETURN
      END
c
c===ckmtq0=============================================================*
c
CDECK  ID>, DT_CKMTQ0
      SUBROUTINE DT_CKMTQ0(Q2,X,IPAR,VALU0,VALD0,SEA0)

c***********************************************************************
c This subroutine calculates F_2 and PDF below Q^2=Q_0^2=2 GeV^2       *
c an F_2-ansatz given in Capella et al. PLB 337(1994)358.              *
c                   IPAR  = 2212   proton                              *
c                         =  100   deuteron                            *
c This version dated 31.01.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY9=1.0D-9)

      PARAMETER (
     &              AA     = 0.1502D0,
     &              BBDEU  = 1.2D0,
     &              BUD    = 0.754D0,
     &              BDD    = 0.4495D0,
     &              BUP    = 1.2064D0,
     &              BDP    = 0.1798D0,
     &              DELTA0 = 0.07684D0,
     &              D      = 1.117D0,
     &              C      = 3.5489D0,
     &              A      = 0.2631D0,
     &              B      = 0.6452D0,
     &              ALPHAR = 0.415D0,
     &              E      = 0.1D0
     &          )

      DELTA = DELTA0*(1.0D0+2.0D0*Q2/(Q2+D))
      AN    = 1.5D0*(1.0D0+Q2/(Q2+C))
c proton, deuteron
      IF ((IPAR.EQ.2212).OR.(IPAR.EQ.100)) THEN
         IF (IPAR.EQ.2212) THEN
            BU = BUP
            BD = BDP
         ELSE
            BU = BUD
            BD = BDD
         ENDIF
         SEA0  = AA*X**(-DELTA)*(1.0D0-X)**(AN+4.0D0)*
     &          (Q2/(Q2+A))**(1.0D0+DELTA)
         VALU0 = BU*X**(1.0D0-ALPHAR)*(1.0D0-X)**AN*
     &           (Q2/(Q2+B))**(ALPHAR)
         VALD0 = BD*X**(1.0D0-ALPHAR)*(1.0D0-X)**(AN+1.0D0)*
     &           (Q2/(Q2+B))**(ALPHAR)
      ELSE
         WRITE(ErrorOut,'(1X,A,I4,A)')
     &      'CKMTQ0: IPAR =',IPAR,' NOT IMPLEMENTED!'
         STOP
      ENDIF
      RETURN
      END
C
C
CDECK  ID>, DT_CKMTDE
      SUBROUTINE DT_CKMTDE(I,NDRV,X,S,ANS)
C
C**********************************************************************
C    Deuteron - PDFs
C    I   = 1, 2, 3, 4, 5, 7, 8 : xu, xd, xub, xdb, xsb, xg, xc
C    ANS = PDF(I)
C    This version by S. Roesler, 30.01.96
C**********************************************************************

      SAVE
      DIMENSION F1(25),F2(25),GF(8,20,25),DL(4000)
      EQUIVALENCE (GF(1,1,1),DL(1))
      DATA DELTA/.13/
C
      DATA (DL(K),K=    1,   85) /
     &0.351858E+00,0.388489E+00,0.325356E+00,0.325356E+00,0.325356E+00,
     &0.325356E+00,0.445218E+01,0.000000E+00,0.419818E+00,0.459249E+00,
     &0.391167E+00,0.391143E+00,0.391125E+00,0.391167E+00,0.628186E+01,
     &0.703797E-01,0.498333E+00,0.540626E+00,0.467466E+00,0.467423E+00,
     &0.467393E+00,0.467466E+00,0.837368E+01,0.151191E+00,0.587839E+00,
     &0.633058E+00,0.554689E+00,0.554630E+00,0.554595E+00,0.554689E+00,
     &0.107170E+02,0.242877E+00,0.688652E+00,0.736861E+00,0.653150E+00,
     &0.653080E+00,0.653046E+00,0.653150E+00,0.132960E+02,0.345760E+00,
     &0.800961E+00,0.852226E+00,0.763038E+00,0.762961E+00,0.762933E+00,
     &0.763038E+00,0.160884E+02,0.460033E+00,0.924829E+00,0.979213E+00,
     &0.884414E+00,0.884335E+00,0.884319E+00,0.884414E+00,0.190679E+02,
     &0.585764E+00,0.106016E+01,0.111773E+01,0.101719E+01,0.101711E+01,
     &0.101711E+01,0.101719E+01,0.222033E+02,0.722864E+00,0.120670E+01,
     &0.126752E+01,0.116110E+01,0.116102E+01,0.116105E+01,0.116110E+01,
     &0.254603E+02,0.871079E+00,0.136402E+01,0.142815E+01,0.131571E+01,
     &0.131565E+01,0.131570E+01,0.131571E+01,0.288020E+02,0.102998E+01,
     &0.153151E+01,0.159900E+01,0.148043E+01,0.148038E+01,0.148046E+01/
      DATA (DL(K),K=   86,  170) /
     &0.148043E+01,0.321898E+02,0.119897E+01,0.170838E+01,0.177930E+01,
     &0.165447E+01,0.165444E+01,0.165455E+01,0.165447E+01,0.355845E+02,
     &0.137726E+01,0.189369E+01,0.196807E+01,0.183687E+01,0.183686E+01,
     &0.183701E+01,0.183687E+01,0.389473E+02,0.156390E+01,0.208631E+01,
     &0.216422E+01,0.202653E+01,0.202654E+01,0.202673E+01,0.202653E+01,
     &0.422402E+02,0.175779E+01,0.228501E+01,0.236648E+01,0.222220E+01,
     &0.222224E+01,0.222248E+01,0.222220E+01,0.454277E+02,0.195768E+01,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.326035E+00,0.380777E+00,0.286363E+00,0.286363E+00,0.286363E+00,
     &0.286363E+00,0.392252E+01,-.138778E-16,0.380092E+00,0.438587E+00/
      DATA (DL(K),K=  171,  255) /
     &0.337452E+00,0.337430E+00,0.337424E+00,0.337452E+00,0.532193E+01,
     &0.553645E-01,0.440879E+00,0.503177E+00,0.395208E+00,0.395169E+00,
     &0.395165E+00,0.395208E+00,0.686454E+01,0.117354E+00,0.508415E+00,
     &0.574566E+00,0.459649E+00,0.459600E+00,0.459604E+00,0.459649E+00,
     &0.853316E+01,0.185994E+00,0.582647E+00,0.652699E+00,0.530722E+00,
     &0.530667E+00,0.530687E+00,0.530722E+00,0.103093E+02,0.261237E+00,
     &0.663404E+00,0.737405E+00,0.608254E+00,0.608199E+00,0.608241E+00,
     &0.608254E+00,0.121710E+02,0.342917E+00,0.750429E+00,0.828423E+00,
     &0.691990E+00,0.691941E+00,0.692009E+00,0.691990E+00,0.140946E+02,
     &0.430783E+00,0.843361E+00,0.925391E+00,0.781571E+00,0.781533E+00,
     &0.781632E+00,0.781571E+00,0.160553E+02,0.524479E+00,0.941741E+00,
     &0.102784E+01,0.876538E+00,0.876515E+00,0.876650E+00,0.876538E+00,
     &0.180277E+02,0.623549E+00,0.104501E+01,0.113521E+01,0.976335E+00,
     &0.976332E+00,0.976506E+00,0.976335E+00,0.199863E+02,0.727439E+00,
     &0.115251E+01,0.124685E+01,0.108031E+01,0.108034E+01,0.108055E+01,
     &0.108031E+01,0.219066E+02,0.835506E+00,0.126352E+01,0.136201E+01,
     &0.118775E+01,0.118780E+01,0.118806E+01,0.118775E+01,0.237652E+02/
      DATA (DL(K),K=  256,  340) /
     &0.947020E+00,0.137724E+01,0.147989E+01,0.129783E+01,0.129791E+01,
     &0.129822E+01,0.129783E+01,0.255406E+02,0.106119E+01,0.149279E+01,
     &0.159961E+01,0.140972E+01,0.140984E+01,0.141019E+01,0.140972E+01,
     &0.272135E+02,0.117715E+01,0.160929E+01,0.172028E+01,0.152252E+01,
     &0.152267E+01,0.152308E+01,0.152252E+01,0.287669E+02,0.129402E+01,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.309785E+00,0.391282E+00,0.250518E+00,0.250518E+00,0.250518E+00,
     &0.250518E+00,0.343842E+01,-.138778E-16,0.352113E+00,0.438463E+00,
     &0.288877E+00,0.288863E+00,0.288878E+00,0.288877E+00,0.446765E+01,
     &0.424850E-01,0.398382E+00,0.489596E+00,0.331132E+00,0.331111E+00/
      DATA (DL(K),K=  341,  425) /
     &0.331148E+00,0.331132E+00,0.555902E+01,0.888369E-01,0.448375E+00,
     &0.544458E+00,0.377064E+00,0.377043E+00,0.377108E+00,0.377064E+00,
     &0.669490E+01,0.138845E+00,0.501854E+00,0.602811E+00,0.426440E+00,
     &0.426425E+00,0.426523E+00,0.426440E+00,0.785892E+01,0.192281E+00,
     &0.558506E+00,0.664331E+00,0.478946E+00,0.478944E+00,0.479079E+00,
     &0.478946E+00,0.903368E+01,0.248834E+00,0.617972E+00,0.728657E+00,
     &0.534229E+00,0.534244E+00,0.534421E+00,0.534229E+00,0.102022E+02,
     &0.308155E+00,0.679844E+00,0.795370E+00,0.591883E+00,0.591921E+00,
     &0.592141E+00,0.591883E+00,0.113479E+02,0.369841E+00,0.743667E+00,
     &0.864009E+00,0.651460E+00,0.651525E+00,0.651792E+00,0.651460E+00,
     &0.124553E+02,0.433447E+00,0.808951E+00,0.934073E+00,0.712474E+00,
     &0.712571E+00,0.712885E+00,0.712474E+00,0.135102E+02,0.498486E+00,
     &0.875171E+00,0.100503E+01,0.774408E+00,0.774541E+00,0.774902E+00,
     &0.774408E+00,0.144999E+02,0.564446E+00,0.941784E+00,0.107632E+01,
     &0.836726E+00,0.836897E+00,0.837307E+00,0.836726E+00,0.154136E+02,
     &0.630788E+00,0.100823E+01,0.114738E+01,0.898879E+00,0.899092E+00,
     &0.899551E+00,0.898879E+00,0.162423E+02,0.696967E+00,0.107396E+01/
      DATA (DL(K),K=  426,  510) /
     &0.121764E+01,0.960319E+00,0.960577E+00,0.961084E+00,0.960319E+00,
     &0.169791E+02,0.762433E+00,0.113843E+01,0.128655E+01,0.102051E+01,
     &0.102081E+01,0.102137E+01,0.102051E+01,0.176190E+02,0.826647E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.304680E+00,0.425088E+00,0.216504E+00,0.216504E+00,0.216504E+00,
     &0.216504E+00,0.298356E+01,0.000000E+00,0.337300E+00,0.463627E+00,
     &0.244023E+00,0.244024E+00,0.244063E+00,0.244023E+00,0.370271E+01,
     &0.316585E-01,0.371787E+00,0.503942E+00,0.273415E+00,0.273423E+00,
     &0.273505E+00,0.273415E+00,0.443039E+01,0.651685E-01,0.407853E+00,
     &0.545739E+00,0.304395E+00,0.304418E+00,0.304545E+00,0.304395E+00/
      DATA (DL(K),K=  511,  595) /
     &0.515321E+01,0.100252E+00,0.445229E+00,0.588741E+00,0.336700E+00,
     &0.336744E+00,0.336918E+00,0.336700E+00,0.586004E+01,0.136648E+00,
     &0.483606E+00,0.632629E+00,0.370026E+00,0.370095E+00,0.370318E+00,
     &0.370026E+00,0.654027E+01,0.174056E+00,0.522666E+00,0.677074E+00,
     &0.404062E+00,0.404162E+00,0.404433E+00,0.404062E+00,0.718442E+01,
     &0.212167E+00,0.562075E+00,0.721735E+00,0.438483E+00,0.438618E+00,
     &0.438938E+00,0.438483E+00,0.778423E+01,0.250658E+00,0.601494E+00,
     &0.766258E+00,0.472959E+00,0.473131E+00,0.473500E+00,0.472959E+00,
     &0.833276E+01,0.289199E+00,0.640580E+00,0.810290E+00,0.507156E+00,
     &0.507369E+00,0.507784E+00,0.507156E+00,0.882448E+01,0.327457E+00,
     &0.678993E+00,0.853479E+00,0.540747E+00,0.541003E+00,0.541463E+00,
     &0.540747E+00,0.925529E+01,0.365104E+00,0.716405E+00,0.895483E+00,
     &0.573411E+00,0.573714E+00,0.574216E+00,0.573411E+00,0.962250E+01,
     &0.401821E+00,0.752501E+00,0.935975E+00,0.604848E+00,0.605197E+00,
     &0.605740E+00,0.604848E+00,0.992478E+01,0.437304E+00,0.786987E+00,
     &0.974647E+00,0.634775E+00,0.635173E+00,0.635752E+00,0.634775E+00,
     &0.101620E+02,0.471269E+00,0.819594E+00,0.101122E+01,0.662936E+00/
      DATA (DL(K),K=  596,  680) /
     &0.663382E+00,0.663995E+00,0.662936E+00,0.103354E+02,0.503459E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.312661E+00,0.487836E+00,0.182562E+00,0.182562E+00,0.182562E+00,
     &0.182562E+00,0.253626E+01,0.000000E+00,0.336910E+00,0.518440E+00,
     &0.200702E+00,0.200721E+00,0.200779E+00,0.200702E+00,0.299460E+01,
     &0.224425E-01,0.361554E+00,0.549164E+00,0.219359E+00,0.219402E+00,
     &0.219517E+00,0.219359E+00,0.343183E+01,0.453742E-01,0.386348E+00,
     &0.579759E+00,0.238296E+00,0.238367E+00,0.238536E+00,0.238296E+00,
     &0.384076E+01,0.685610E-01,0.411080E+00,0.610003E+00,0.257305E+00,
     &0.257408E+00,0.257630E+00,0.257305E+00,0.421619E+01,0.917987E-01/
      DATA (DL(K),K=  681,  765) /
     &0.435528E+00,0.639668E+00,0.276174E+00,0.276313E+00,0.276583E+00,
     &0.276174E+00,0.455400E+01,0.114876E+00,0.459476E+00,0.668531E+00,
     &0.294698E+00,0.294875E+00,0.295191E+00,0.294698E+00,0.485107E+01,
     &0.137589E+00,0.482719E+00,0.696375E+00,0.312682E+00,0.312900E+00,
     &0.313258E+00,0.312682E+00,0.510539E+01,0.159742E+00,0.505060E+00,
     &0.722995E+00,0.329941E+00,0.330200E+00,0.330596E+00,0.329941E+00,
     &0.531589E+01,0.181149E+00,0.526315E+00,0.748199E+00,0.346303E+00,
     &0.346604E+00,0.347034E+00,0.346303E+00,0.548250E+01,0.201638E+00,
     &0.546317E+00,0.771808E+00,0.361613E+00,0.361957E+00,0.362418E+00,
     &0.361613E+00,0.560595E+01,0.221052E+00,0.564917E+00,0.793667E+00,
     &0.375735E+00,0.376122E+00,0.376609E+00,0.375735E+00,0.568772E+01,
     &0.239253E+00,0.581987E+00,0.813638E+00,0.388553E+00,0.388982E+00,
     &0.389491E+00,0.388553E+00,0.572992E+01,0.256122E+00,0.597419E+00,
     &0.831608E+00,0.399972E+00,0.400443E+00,0.400970E+00,0.399972E+00,
     &0.573516E+01,0.271562E+00,0.611129E+00,0.847487E+00,0.409919E+00,
     &0.410430E+00,0.410972E+00,0.409919E+00,0.570642E+01,0.285497E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K=  766,  850) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.335149E+00,0.582072E+00,0.146415E+00,0.146415E+00,0.146415E+00,
     &0.146415E+00,0.206772E+01,0.000000E+00,0.351552E+00,0.603437E+00,
     &0.156515E+00,0.156542E+00,0.156595E+00,0.156515E+00,0.231143E+01,
     &0.146091E-01,0.367407E+00,0.623737E+00,0.166387E+00,0.166442E+00,
     &0.166542E+00,0.166387E+00,0.252488E+01,0.289315E-01,0.382571E+00,
     &0.642832E+00,0.175891E+00,0.175976E+00,0.176118E+00,0.175891E+00,
     &0.270658E+01,0.428312E-01,0.396926E+00,0.660609E+00,0.184917E+00,
     &0.185034E+00,0.185212E+00,0.184917E+00,0.285608E+01,0.561981E-01,
     &0.410365E+00,0.676962E+00,0.193365E+00,0.193513E+00,0.193722E+00,
     &0.193365E+00,0.297375E+01,0.689319E-01,0.422792E+00,0.691796E+00/
      DATA (DL(K),K=  851,  935) /
     &0.201144E+00,0.201324E+00,0.201560E+00,0.201144E+00,0.306050E+01,
     &0.809434E-01,0.434123E+00,0.705030E+00,0.208181E+00,0.208393E+00,
     &0.208650E+00,0.208181E+00,0.311775E+01,0.921567E-01,0.444287E+00,
     &0.716596E+00,0.214413E+00,0.214656E+00,0.214931E+00,0.214413E+00,
     &0.314738E+01,0.102508E+00,0.453228E+00,0.726441E+00,0.219792E+00,
     &0.220066E+00,0.220354E+00,0.219792E+00,0.315156E+01,0.111949E+00,
     &0.460906E+00,0.734527E+00,0.224285E+00,0.224589E+00,0.224886E+00,
     &0.224285E+00,0.313271E+01,0.120441E+00,0.467291E+00,0.740835E+00,
     &0.227870E+00,0.228203E+00,0.228506E+00,0.227870E+00,0.309338E+01,
     &0.127963E+00,0.472372E+00,0.745357E+00,0.230541E+00,0.230902E+00,
     &0.231208E+00,0.230541E+00,0.303621E+01,0.134506E+00,0.476148E+00,
     &0.748105E+00,0.232304E+00,0.232690E+00,0.232996E+00,0.232304E+00,
     &0.296381E+01,0.140070E+00,0.478635E+00,0.749103E+00,0.233176E+00,
     &0.233586E+00,0.233889E+00,0.233176E+00,0.287874E+01,0.144672E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K=  936, 1020) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.370162E+00,0.695827E+00,0.105823E+00,0.105823E+00,0.105823E+00,
     &0.105823E+00,0.154556E+01,0.208167E-16,0.378214E+00,0.703794E+00,
     &0.109539E+00,0.109554E+00,0.109571E+00,0.109539E+00,0.162770E+01,
     &0.818783E-02,0.385258E+00,0.710067E+00,0.112818E+00,0.112847E+00,
     &0.112879E+00,0.112818E+00,0.168578E+01,0.158212E-01,0.391264E+00,
     &0.714648E+00,0.115620E+00,0.115666E+00,0.115709E+00,0.115620E+00,
     &0.172175E+01,0.228667E-01,0.396214E+00,0.717539E+00,0.117923E+00,
     &0.117985E+00,0.118037E+00,0.117923E+00,0.173756E+01,0.293009E-01,
     &0.400098E+00,0.718759E+00,0.119711E+00,0.119790E+00,0.119848E+00,
     &0.119711E+00,0.173541E+01,0.351123E-01,0.402915E+00,0.718332E+00,
     &0.120979E+00,0.121074E+00,0.121137E+00,0.120979E+00,0.171755E+01,
     &0.402951E-01,0.404672E+00,0.716292E+00,0.121728E+00,0.121840E+00/
      DATA (DL(K),K= 1021, 1105) /
     &0.121905E+00,0.121728E+00,0.168619E+01,0.448514E-01,0.405385E+00,
     &0.712681E+00,0.121967E+00,0.122095E+00,0.122161E+00,0.121967E+00,
     &0.164352E+01,0.487902E-01,0.405077E+00,0.707551E+00,0.121712E+00,
     &0.121855E+00,0.121920E+00,0.121712E+00,0.159162E+01,0.521265E-01,
     &0.403778E+00,0.700963E+00,0.120984E+00,0.121141E+00,0.121204E+00,
     &0.120984E+00,0.153245E+01,0.548814E-01,0.401525E+00,0.692984E+00,
     &0.119809E+00,0.119980E+00,0.120040E+00,0.119809E+00,0.146780E+01,
     &0.570807E-01,0.398361E+00,0.683691E+00,0.118218E+00,0.118402E+00,
     &0.118457E+00,0.118218E+00,0.139928E+01,0.587542E-01,0.394333E+00,
     &0.673166E+00,0.116244E+00,0.116440E+00,0.116490E+00,0.116244E+00,
     &0.132834E+01,0.599355E-01,0.389495E+00,0.661496E+00,0.113924E+00,
     &0.114131E+00,0.114175E+00,0.113924E+00,0.125620E+01,0.606602E-01,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K= 1106, 1190) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.394012E+00,0.757115E+00,0.772117E-01,0.772117E-01,0.772117E-01,
     &0.772117E-01,0.117279E+01,0.346945E-17,0.395841E+00,0.752988E+00,
     &0.780501E-01,0.780655E-01,0.780723E-01,0.780501E-01,0.118528E+01,
     &0.491697E-02,0.396627E+00,0.747223E+00,0.785386E-01,0.785692E-01,
     &0.785806E-01,0.785386E-01,0.118242E+01,0.932754E-02,0.396401E+00,
     &0.739901E+00,0.786820E-01,0.787273E-01,0.787413E-01,0.786820E-01,
     &0.116673E+01,0.132427E-01,0.395190E+00,0.731092E+00,0.784870E-01,
     &0.785464E-01,0.785613E-01,0.784870E-01,0.114033E+01,0.166738E-01,
     &0.393030E+00,0.720878E+00,0.779683E-01,0.780410E-01,0.780555E-01,
     &0.779683E-01,0.110528E+01,0.196392E-01,0.389962E+00,0.709342E+00,
     &0.771427E-01,0.772280E-01,0.772409E-01,0.771427E-01,0.106344E+01,
     &0.221591E-01,0.386027E+00,0.696571E+00,0.760304E-01,0.761276E-01,
     &0.761378E-01,0.760304E-01,0.101653E+01,0.242567E-01,0.381274E+00,
     &0.682657E+00,0.746543E-01,0.747623E-01,0.747692E-01,0.746543E-01/
      DATA (DL(K),K= 1191, 1275) /
     &0.966057E+00,0.259571E-01,0.375752E+00,0.667695E+00,0.730389E-01,
     &0.731569E-01,0.731598E-01,0.730389E-01,0.913345E+00,0.272876E-01,
     &0.369514E+00,0.651782E+00,0.712104E-01,0.713374E-01,0.713358E-01,
     &0.712104E-01,0.859530E+00,0.282763E-01,0.362616E+00,0.635021E+00,
     &0.691957E-01,0.693307E-01,0.693243E-01,0.691957E-01,0.805566E+00,
     &0.289524E-01,0.355116E+00,0.617511E+00,0.670220E-01,0.671640E-01,
     &0.671526E-01,0.670220E-01,0.752235E+00,0.293453E-01,0.347072E+00,
     &0.599357E+00,0.647162E-01,0.648642E-01,0.648478E-01,0.647162E-01,
     &0.700161E+00,0.294844E-01,0.338543E+00,0.580659E+00,0.623046E-01,
     &0.624578E-01,0.624363E-01,0.623046E-01,0.649828E+00,0.293983E-01,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K= 1276, 1360) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.408305E+00,0.775318E+00,0.509141E-01,0.509141E-01,0.509141E-01,
     &0.509141E-01,0.818839E+00,-.867362E-17,0.403619E+00,0.758058E+00,
     &0.502245E-01,0.502351E-01,0.502337E-01,0.502245E-01,0.795347E+00,
     &0.264045E-02,0.398068E+00,0.739709E+00,0.493454E-01,0.493661E-01,
     &0.493626E-01,0.493454E-01,0.764942E+00,0.491508E-02,0.391719E+00,
     &0.720394E+00,0.482952E-01,0.483253E-01,0.483192E-01,0.482952E-01,
     &0.729624E+00,0.685202E-02,0.384627E+00,0.700222E+00,0.470896E-01,
     &0.471285E-01,0.471194E-01,0.470896E-01,0.690906E+00,0.847433E-02,
     &0.376851E+00,0.679300E+00,0.457475E-01,0.457946E-01,0.457822E-01,
     &0.457475E-01,0.650078E+00,0.980774E-02,0.368452E+00,0.657739E+00,
     &0.442875E-01,0.443419E-01,0.443261E-01,0.442875E-01,0.608239E+00,
     &0.108769E-01,0.359490E+00,0.635646E+00,0.427281E-01,0.427892E-01,
     &0.427698E-01,0.427281E-01,0.566280E+00,0.117061E-01,0.350026E+00,
     &0.613128E+00,0.410878E-01,0.411549E-01,0.411320E-01,0.410878E-01,
     &0.524918E+00,0.123191E-01,0.340122E+00,0.590292E+00,0.393848E-01,
     &0.394571E-01,0.394308E-01,0.393848E-01,0.484713E+00,0.127393E-01/
      DATA (DL(K),K= 1361, 1445) /
     &0.329838E+00,0.567240E+00,0.376363E-01,0.377132E-01,0.376836E-01,
     &0.376363E-01,0.446084E+00,0.129888E-01,0.319236E+00,0.544074E+00,
     &0.358589E-01,0.359396E-01,0.359068E-01,0.358589E-01,0.409328E+00,
     &0.130888E-01,0.308374E+00,0.520890E+00,0.340678E-01,0.341517E-01,
     &0.341160E-01,0.340678E-01,0.374641E+00,0.130594E-01,0.297312E+00,
     &0.497781E+00,0.322772E-01,0.323636E-01,0.323253E-01,0.322772E-01,
     &0.342135E+00,0.129195E-01,0.286106E+00,0.474837E+00,0.304999E-01,
     &0.305882E-01,0.305474E-01,0.304999E-01,0.311854E+00,0.126863E-01,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.407248E+00,0.746438E+00,0.335640E-01,0.335640E-01,0.335640E-01/
      DATA (DL(K),K= 1446, 1530) /
     &0.335640E-01,0.573540E+00,0.173472E-16,0.397516E+00,0.719825E+00,
     &0.324649E-01,0.324735E-01,0.324698E-01,0.324649E-01,0.540770E+00,
     &0.147177E-02,0.387197E+00,0.692869E+00,0.312911E-01,0.313075E-01,
     &0.313000E-01,0.312911E-01,0.505972E+00,0.269995E-02,0.376365E+00,
     &0.665689E+00,0.300576E-01,0.300811E-01,0.300699E-01,0.300576E-01,
     &0.470389E+00,0.371147E-02,0.365085E+00,0.638387E+00,0.287770E-01,
     &0.288070E-01,0.287922E-01,0.287770E-01,0.434885E+00,0.452768E-02,
     &0.353423E+00,0.611066E+00,0.274623E-01,0.274980E-01,0.274797E-01,
     &0.274623E-01,0.400103E+00,0.516996E-02,0.341442E+00,0.583823E+00,
     &0.261256E-01,0.261663E-01,0.261448E-01,0.261256E-01,0.366541E+00,
     &0.565807E-02,0.329207E+00,0.556753E+00,0.247782E-01,0.248234E-01,
     &0.247989E-01,0.247782E-01,0.334555E+00,0.601048E-02,0.316777E+00,
     &0.529946E+00,0.234308E-01,0.234798E-01,0.234525E-01,0.234308E-01,
     &0.304384E+00,0.624451E-02,0.304214E+00,0.503489E+00,0.220932E-01,
     &0.221452E-01,0.221155E-01,0.220932E-01,0.276170E+00,0.637618E-02,
     &0.291575E+00,0.477462E+00,0.207739E-01,0.208286E-01,0.207966E-01,
     &0.207739E-01,0.249976E+00,0.642028E-02,0.278917E+00,0.451941E+00/
      DATA (DL(K),K= 1531, 1615) /
     &0.194809E-01,0.195376E-01,0.195037E-01,0.194809E-01,0.225809E+00,
     &0.639038E-02,0.266293E+00,0.426995E+00,0.182209E-01,0.182791E-01,
     &0.182436E-01,0.182209E-01,0.203629E+00,0.629880E-02,0.253754E+00,
     &0.402686E+00,0.169996E-01,0.170587E-01,0.170219E-01,0.169996E-01,
     &0.183361E+00,0.615665E-02,0.241347E+00,0.379071E+00,0.158217E-01,
     &0.158814E-01,0.158436E-01,0.158217E-01,0.164907E+00,0.597385E-02,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.395106E+00,0.689399E+00,0.218554E-01,0.218554E-01,0.218554E-01,
     &0.218554E-01,0.398362E+00,-.173472E-17,0.381441E+00,0.656777E+00,
     &0.207816E-01,0.207886E-01,0.207844E-01,0.207816E-01,0.366703E+00/
      DATA (DL(K),K= 1616, 1700) /
     &0.826643E-03,0.367505E+00,0.624578E+00,0.197001E-01,0.197133E-01,
     &0.197053E-01,0.197001E-01,0.335573E+00,0.149886E-02,0.353373E+00,
     &0.592889E+00,0.186195E-01,0.186383E-01,0.186266E-01,0.186195E-01,
     &0.305590E+00,0.203730E-02,0.339106E+00,0.561783E+00,0.175468E-01,
     &0.175705E-01,0.175555E-01,0.175468E-01,0.277136E+00,0.245817E-02,
     &0.324766E+00,0.531331E+00,0.164887E-01,0.165166E-01,0.164986E-01,
     &0.164887E-01,0.250424E+00,0.277666E-02,0.310411E+00,0.501599E+00,
     &0.154510E-01,0.154825E-01,0.154618E-01,0.154510E-01,0.225588E+00,
     &0.300658E-02,0.296100E+00,0.472648E+00,0.144390E-01,0.144735E-01,
     &0.144504E-01,0.144390E-01,0.202681E+00,0.316040E-02,0.281885E+00,
     &0.444535E+00,0.134570E-01,0.134940E-01,0.134689E-01,0.134570E-01,
     &0.181693E+00,0.324944E-02,0.267820E+00,0.417309E+00,0.125091E-01,
     &0.125481E-01,0.125212E-01,0.125091E-01,0.162572E+00,0.328396E-02,
     &0.253953E+00,0.391017E+00,0.115984E-01,0.116389E-01,0.116106E-01,
     &0.115984E-01,0.145235E+00,0.327313E-02,0.240328E+00,0.365695E+00,
     &0.107275E-01,0.107690E-01,0.107396E-01,0.107275E-01,0.129575E+00,
     &0.322510E-02,0.226989E+00,0.341375E+00,0.989805E-02,0.994030E-02/
      DATA (DL(K),K= 1701, 1785) /
     &0.990998E-02,0.989805E-02,0.115477E+00,0.314713E-02,0.213972E+00,
     &0.318081E+00,0.911149E-02,0.915408E-02,0.912316E-02,0.911149E-02,
     &0.102820E+00,0.304556E-02,0.201311E+00,0.295830E+00,0.836852E-02,
     &0.841111E-02,0.837984E-02,0.836852E-02,0.914804E-01,0.292596E-02,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.374678E+00,0.616087E+00,0.139531E-01,0.139531E-01,0.139531E-01,
     &0.139531E-01,0.272491E+00,-.693889E-17,0.358052E+00,0.580345E+00,
     &0.130624E-01,0.130680E-01,0.130641E-01,0.130624E-01,0.245861E+00,
     &0.460255E-03,0.341487E+00,0.545719E+00,0.121971E-01,0.122076E-01,
     &0.122002E-01,0.121971E-01,0.220877E+00,0.826785E-03,0.325046E+00/
      DATA (DL(K),K= 1786, 1870) /
     &0.512244E+00,0.113599E-01,0.113748E-01,0.113641E-01,0.113599E-01,
     &0.197730E+00,0.111366E-02,0.308783E+00,0.479952E+00,0.105534E-01,
     &0.105720E-01,0.105585E-01,0.105534E-01,0.176497E+00,0.133192E-02,
     &0.292747E+00,0.448868E+00,0.977938E-02,0.980112E-02,0.978518E-02,
     &0.977938E-02,0.157150E+00,0.149139E-02,0.276986E+00,0.419015E+00,
     &0.903955E-02,0.906394E-02,0.904584E-02,0.903955E-02,0.139631E+00,
     &0.160093E-02,0.261546E+00,0.390412E+00,0.833509E-02,0.836165E-02,
     &0.834171E-02,0.833509E-02,0.123850E+00,0.166838E-02,0.246467E+00,
     &0.363074E+00,0.766687E-02,0.769516E-02,0.767369E-02,0.766687E-02,
     &0.109695E+00,0.170073E-02,0.231787E+00,0.337008E+00,0.703540E-02,
     &0.706500E-02,0.704230E-02,0.703540E-02,0.970428E-01,0.170416E-02,
     &0.217542E+00,0.312218E+00,0.644083E-02,0.647137E-02,0.644772E-02,
     &0.644083E-02,0.857658E-01,0.168409E-02,0.203759E+00,0.288701E+00,
     &0.588300E-02,0.591415E-02,0.588981E-02,0.588300E-02,0.757385E-01,
     &0.164528E-02,0.190467E+00,0.266449E+00,0.536147E-02,0.539292E-02,
     &0.536812E-02,0.536147E-02,0.668383E-01,0.159185E-02,0.177686E+00,
     &0.245447E+00,0.487551E-02,0.490698E-02,0.488195E-02,0.487551E-02/
      DATA (DL(K),K= 1871, 1955) /
     &0.589492E-01,0.152735E-02,0.165434E+00,0.225677E+00,0.442416E-02,
     &0.445543E-02,0.443037E-02,0.442416E-02,0.519652E-01,0.145483E-02,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.348042E+00,0.534691E+00,0.867977E-02,0.867977E-02,0.867977E-02,
     &0.867977E-02,0.182547E+00,-.693889E-17,0.329349E+00,0.498248E+00,
     &0.800724E-02,0.801198E-02,0.800836E-02,0.800724E-02,0.161948E+00,
     &0.250949E-03,0.311047E+00,0.463485E+00,0.737155E-02,0.738040E-02,
     &0.737356E-02,0.737155E-02,0.143267E+00,0.447662E-03,0.293181E+00,
     &0.430377E+00,0.677169E-02,0.678409E-02,0.677441E-02,0.677169E-02,
     &0.126447E+00,0.598803E-03,0.275787E+00,0.398907E+00,0.620726E-02/
      DATA (DL(K),K= 1956, 2040) /
     &0.622265E-02,0.621051E-02,0.620726E-02,0.111401E+00,0.711280E-03,
     &0.258900E+00,0.369051E+00,0.567741E-02,0.569532E-02,0.568106E-02,
     &0.567741E-02,0.979944E-01,0.790986E-03,0.242550E+00,0.340785E+00,
     &0.518138E-02,0.520134E-02,0.518531E-02,0.518138E-02,0.860936E-01,
     &0.843227E-03,0.226765E+00,0.314083E+00,0.471828E-02,0.473987E-02,
     &0.472238E-02,0.471828E-02,0.755615E-01,0.872644E-03,0.211568E+00,
     &0.288916E+00,0.428714E-02,0.430998E-02,0.429133E-02,0.428714E-02,
     &0.662627E-01,0.883319E-03,0.196981E+00,0.265252E+00,0.388691E-02,
     &0.391065E-02,0.389112E-02,0.388691E-02,0.580684E-01,0.878818E-03,
     &0.183020E+00,0.243053E+00,0.351645E-02,0.354077E-02,0.352060E-02,
     &0.351645E-02,0.508578E-01,0.862228E-03,0.169696E+00,0.222280E+00,
     &0.317451E-02,0.319914E-02,0.317858E-02,0.317451E-02,0.445190E-01,
     &0.836224E-03,0.157017E+00,0.202888E+00,0.285982E-02,0.288450E-02,
     &0.286376E-02,0.285982E-02,0.389523E-01,0.803096E-03,0.144987E+00,
     &0.184832E+00,0.257101E-02,0.259553E-02,0.257480E-02,0.257101E-02,
     &0.340677E-01,0.764787E-03,0.133605E+00,0.168060E+00,0.230670E-02,
     &0.233087E-02,0.231031E-02,0.230670E-02,0.297820E-01,0.722929E-03/
      DATA (DL(K),K= 2041, 2125) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.316867E+00,0.451111E+00,0.522815E-02,0.522815E-02,0.522815E-02,
     &0.522815E-02,0.119118E+00,0.889046E-17,0.296950E+00,0.415915E+00,
     &0.475497E-02,0.475914E-02,0.475574E-02,0.475497E-02,0.104204E+00,
     &0.132513E-03,0.277735E+00,0.382805E+00,0.431809E-02,0.432582E-02,
     &0.431944E-02,0.431809E-02,0.910279E-01,0.235347E-03,0.259241E+00,
     &0.351694E+00,0.391455E-02,0.392531E-02,0.391637E-02,0.391455E-02,
     &0.794222E-01,0.313322E-03,0.241485E+00,0.322517E+00,0.354249E-02,
     &0.355575E-02,0.354464E-02,0.354249E-02,0.692354E-01,0.370408E-03,
     &0.224480E+00,0.295202E+00,0.319987E-02,0.321518E-02,0.320226E-02/
      DATA (DL(K),K= 2126, 2210) /
     &0.319987E-02,0.603106E-01,0.409866E-03,0.208235E+00,0.269681E+00,
     &0.288490E-02,0.290184E-02,0.288744E-02,0.288490E-02,0.525034E-01,
     &0.434663E-03,0.192759E+00,0.245887E+00,0.259589E-02,0.261407E-02,
     &0.259852E-02,0.259589E-02,0.456838E-01,0.447393E-03,0.178054E+00,
     &0.223752E+00,0.233123E-02,0.235033E-02,0.233390E-02,0.233123E-02,
     &0.397318E-01,0.450314E-03,0.164120E+00,0.203207E+00,0.208941E-02,
     &0.210910E-02,0.209206E-02,0.208941E-02,0.345396E-01,0.445394E-03,
     &0.150954E+00,0.184182E+00,0.186896E-02,0.188897E-02,0.187155E-02,
     &0.186896E-02,0.300131E-01,0.434333E-03,0.138548E+00,0.166608E+00,
     &0.166844E-02,0.168854E-02,0.167096E-02,0.166844E-02,0.260692E-01,
     &0.418584E-03,0.126892E+00,0.150412E+00,0.148650E-02,0.150648E-02,
     &0.148891E-02,0.148650E-02,0.226325E-01,0.399380E-03,0.115971E+00,
     &0.135523E+00,0.132180E-02,0.134148E-02,0.132409E-02,0.132180E-02,
     &0.196374E-01,0.377764E-03,0.105767E+00,0.121870E+00,0.117308E-02,
     &0.119231E-02,0.117524E-02,0.117308E-02,0.170312E-01,0.354610E-03,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K= 2211, 2295) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.282579E+00,0.369670E+00,0.302765E-02,0.302765E-02,0.302765E-02,
     &0.302765E-02,0.752529E-01,-.455365E-17,0.262229E+00,0.337209E+00,
     &0.271512E-02,0.271883E-02,0.271564E-02,0.271512E-02,0.651086E-01,
     &0.669321E-04,0.242857E+00,0.307069E+00,0.243269E-02,0.243953E-02,
     &0.243360E-02,0.243269E-02,0.563252E-01,0.118744E-03,0.224455E+00,
     &0.279111E+00,0.217687E-02,0.218631E-02,0.217808E-02,0.217687E-02,
     &0.487143E-01,0.157767E-03,0.207014E+00,0.253223E+00,0.194534E-02,
     &0.195689E-02,0.194675E-02,0.194534E-02,0.421227E-01,0.186063E-03,
     &0.190523E+00,0.229293E+00,0.173585E-02,0.174909E-02,0.173741E-02,
     &0.173585E-02,0.364156E-01,0.205286E-03,0.174969E+00,0.207218E+00,
     &0.154647E-02,0.156100E-02,0.154811E-02,0.154647E-02,0.314732E-01/
      DATA (DL(K),K= 2296, 2380) /
     &0.216964E-03,0.160335E+00,0.186895E+00,0.137545E-02,0.139092E-02,
     &0.137713E-02,0.137545E-02,0.271927E-01,0.222455E-03,0.146604E+00,
     &0.168227E+00,0.122121E-02,0.123733E-02,0.122290E-02,0.122121E-02,
     &0.234852E-01,0.222947E-03,0.133756E+00,0.151116E+00,0.108234E-02,
     &0.109881E-02,0.108400E-02,0.108234E-02,0.202747E-01,0.219474E-03,
     &0.121765E+00,0.135471E+00,0.957502E-03,0.974107E-03,0.959112E-03,
     &0.957502E-03,0.174932E-01,0.212928E-03,0.110606E+00,0.121198E+00,
     &0.845493E-03,0.862024E-03,0.847037E-03,0.845493E-03,0.150824E-01,
     &0.204075E-03,0.100250E+00,0.108210E+00,0.745196E-03,0.761482E-03,
     &0.746662E-03,0.745196E-03,0.129965E-01,0.193573E-03,0.906661E-01,
     &0.964191E-01,0.655569E-03,0.671466E-03,0.656948E-03,0.655569E-03,
     &0.111930E-01,0.181962E-03,0.818218E-01,0.857412E-01,0.575637E-03,
     &0.591030E-03,0.576925E-03,0.575637E-03,0.962922E-02,0.169687E-03,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K= 2381, 2465) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.246444E+00,0.293515E+00,0.167124E-02,0.167124E-02,0.167124E-02,
     &0.167124E-02,0.456929E-01,-.260209E-17,0.226393E+00,0.264836E+00,
     &0.147748E-02,0.148085E-02,0.147783E-02,0.147748E-02,0.392393E-01,
     &0.318190E-04,0.207552E+00,0.238550E+00,0.130596E-02,0.131212E-02,
     &0.130656E-02,0.130596E-02,0.337276E-01,0.566426E-04,0.189877E+00,
     &0.214470E+00,0.115347E-02,0.116190E-02,0.115427E-02,0.115347E-02,
     &0.290012E-01,0.753776E-04,0.173336E+00,0.192452E+00,0.101789E-02,
     &0.102811E-02,0.101881E-02,0.101789E-02,0.249381E-01,0.889466E-04,
     &0.157889E+00,0.172355E+00,0.897268E-03,0.908872E-03,0.898270E-03,
     &0.897268E-03,0.214419E-01,0.980950E-04,0.143501E+00,0.154046E+00,
     &0.789951E-03,0.802565E-03,0.790996E-03,0.789951E-03,0.184296E-01,
     &0.103536E-03,0.130132E+00,0.137402E+00,0.694510E-03,0.707811E-03,
     &0.695568E-03,0.694510E-03,0.158331E-01,0.105929E-03,0.117743E+00/
      DATA (DL(K),K= 2466, 2550) /
     &0.122303E+00,0.609684E-03,0.623394E-03,0.610733E-03,0.609684E-03,
     &0.135929E-01,0.105853E-03,0.106293E+00,0.108637E+00,0.534365E-03,
     &0.548244E-03,0.535386E-03,0.534365E-03,0.116583E-01,0.103825E-03,
     &0.957386E-01,0.962976E-01,0.467572E-03,0.481416E-03,0.468551E-03,
     &0.467572E-03,0.999103E-02,0.100301E-03,0.860376E-01,0.851820E-01,
     &0.408422E-03,0.422062E-03,0.409350E-03,0.408422E-03,0.855563E-02,
     &0.956675E-04,0.771455E-01,0.751930E-01,0.356117E-03,0.369416E-03,
     &0.356989E-03,0.356117E-03,0.731542E-02,0.902499E-04,0.690178E-01,
     &0.662386E-01,0.309950E-03,0.322797E-03,0.310761E-03,0.309950E-03,
     &0.624633E-02,0.843305E-04,0.616096E-01,0.582312E-01,0.269281E-03,
     &0.281590E-03,0.270030E-03,0.269281E-03,0.533230E-02,0.781441E-04,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K= 2551, 2635) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.209608E+00,0.224862E+00,0.869706E-03,0.869706E-03,0.869706E-03,
     &0.869706E-03,0.264204E-01,-.138236E-17,0.190523E+00,0.200603E+00,
     &0.757542E-03,0.760626E-03,0.757768E-03,0.757542E-03,0.226261E-01,
     &0.138827E-04,0.172819E+00,0.178656E+00,0.660281E-03,0.665837E-03,
     &0.660670E-03,0.660281E-03,0.194018E-01,0.249832E-04,0.156420E+00,
     &0.158805E+00,0.575414E-03,0.582918E-03,0.575917E-03,0.575414E-03,
     &0.166434E-01,0.334851E-04,0.141265E+00,0.140883E+00,0.501258E-03,
     &0.510252E-03,0.501836E-03,0.501258E-03,0.142710E-01,0.397017E-04,
     &0.127291E+00,0.124732E+00,0.436386E-03,0.446473E-03,0.437008E-03,
     &0.436386E-03,0.122297E-01,0.439154E-04,0.114437E+00,0.110205E+00,
     &0.379575E-03,0.390415E-03,0.380217E-03,0.379575E-03,0.104701E-01,
     &0.464110E-04,0.102644E+00,0.971655E-01,0.329805E-03,0.341109E-03,
     &0.330448E-03,0.329805E-03,0.895086E-02,0.474758E-04,0.918521E-01,
     &0.854876E-01,0.286206E-03,0.297729E-03,0.286836E-03,0.286206E-03,
     &0.764249E-02,0.473771E-04,0.820032E-01,0.750529E-01,0.248027E-03/
      DATA (DL(K),K= 2636, 2720) /
     &0.259564E-03,0.248633E-03,0.248027E-03,0.651744E-02,0.463561E-04,
     &0.730394E-01,0.657510E-01,0.214611E-03,0.225995E-03,0.215186E-03,
     &0.214611E-03,0.554573E-02,0.446239E-04,0.649040E-01,0.574789E-01,
     &0.185396E-03,0.196491E-03,0.185935E-03,0.185396E-03,0.470938E-02,
     &0.423722E-04,0.575411E-01,0.501405E-01,0.159891E-03,0.170590E-03,
     &0.160391E-03,0.159891E-03,0.399752E-02,0.397689E-04,0.508960E-01,
     &0.436466E-01,0.137650E-03,0.147874E-03,0.138111E-03,0.137650E-03,
     &0.338807E-02,0.369434E-04,0.449157E-01,0.379141E-01,0.118285E-03,
     &0.127973E-03,0.118705E-03,0.118285E-03,0.286125E-02,0.340035E-04,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K= 2721, 2805) /
     &0.173133E+00,0.165162E+00,0.420483E-03,0.420483E-03,0.420483E-03,
     &0.420483E-03,0.143704E-01,0.418773E-17,0.155600E+00,0.145586E+00,
     &0.360490E-03,0.363140E-03,0.360629E-03,0.360490E-03,0.123560E-01,
     &0.533279E-05,0.139551E+00,0.128113E+00,0.309555E-03,0.314310E-03,
     &0.309792E-03,0.309555E-03,0.106262E-01,0.982612E-05,0.124876E+00,
     &0.112516E+00,0.265952E-03,0.272344E-03,0.266256E-03,0.265952E-03,
     &0.913151E-02,0.133834E-04,0.111490E+00,0.986188E-01,0.228522E-03,
     &0.236138E-03,0.228869E-03,0.228522E-03,0.783135E-02,0.160429E-04,
     &0.993081E-01,0.862590E-01,0.196336E-03,0.204821E-03,0.196706E-03,
     &0.196336E-03,0.670031E-02,0.178799E-04,0.882484E-01,0.752883E-01,
     &0.168604E-03,0.177655E-03,0.168981E-03,0.168604E-03,0.572016E-02,
     &0.189837E-04,0.782334E-01,0.655714E-01,0.144684E-03,0.154047E-03,
     &0.145058E-03,0.144684E-03,0.487276E-02,0.194655E-04,0.691885E-01,
     &0.569841E-01,0.124035E-03,0.133497E-03,0.124397E-03,0.124035E-03,
     &0.413648E-02,0.194296E-04,0.610420E-01,0.494128E-01,0.106203E-03,
     &0.115592E-03,0.106548E-03,0.106203E-03,0.350042E-02,0.189800E-04,
     &0.537249E-01,0.427533E-01,0.908141E-04,0.999895E-04,0.911377E-04/
      DATA (DL(K),K= 2806, 2890) /
     &0.908141E-04,0.295961E-02,0.182192E-04,0.471713E-01,0.369100E-01,
     &0.775359E-04,0.863895E-04,0.778360E-04,0.775359E-04,0.249629E-02,
     &0.172287E-04,0.413182E-01,0.317957E-01,0.660857E-04,0.745356E-04,
     &0.663611E-04,0.660857E-04,0.209482E-02,0.160791E-04,0.361056E-01,
     &0.273306E-01,0.562298E-04,0.642173E-04,0.564804E-04,0.562298E-04,
     &0.175588E-02,0.148407E-04,0.314766E-01,0.234421E-01,0.477598E-04,
     &0.552457E-04,0.479859E-04,0.477598E-04,0.147398E-02,0.135653E-04,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.138007E+00,0.115214E+00,0.185072E-03,0.185072E-03,0.185072E-03,
     &0.185072E-03,0.722856E-02,-.380826E-17,0.122517E+00,0.100251E+00/
      DATA (DL(K),K= 2891, 2975) /
     &0.155814E-03,0.158287E-03,0.155901E-03,0.155814E-03,0.630580E-02,
     &0.155371E-05,0.108535E+00,0.870870E-01,0.131535E-03,0.135909E-03,
     &0.131680E-03,0.131535E-03,0.547867E-02,0.304952E-05,0.959260E-01,
     &0.754985E-01,0.111183E-03,0.116980E-03,0.111366E-03,0.111183E-03,
     &0.473794E-02,0.433106E-05,0.845828E-01,0.653163E-01,0.940433E-04,
     &0.100851E-03,0.942493E-04,0.940433E-04,0.407647E-02,0.533613E-05,
     &0.744017E-01,0.563870E-01,0.795843E-04,0.870596E-04,0.798007E-04,
     &0.795843E-04,0.349165E-02,0.606691E-05,0.652864E-01,0.485720E-01,
     &0.673476E-04,0.752069E-04,0.675656E-04,0.673476E-04,0.297273E-02,
     &0.652898E-05,0.571466E-01,0.417472E-01,0.569700E-04,0.649812E-04,
     &0.571831E-04,0.569700E-04,0.251732E-02,0.675028E-05,0.498975E-01,
     &0.358008E-01,0.481618E-04,0.561391E-04,0.483654E-04,0.481618E-04,
     &0.212754E-02,0.677236E-05,0.434594E-01,0.306320E-01,0.406746E-04,
     &0.484724E-04,0.408657E-04,0.406746E-04,0.179059E-02,0.662814E-05,
     &0.377578E-01,0.261500E-01,0.343050E-04,0.418123E-04,0.344818E-04,
     &0.343050E-04,0.149563E-02,0.635273E-05,0.327229E-01,0.222734E-01,
     &0.288923E-04,0.360279E-04,0.290540E-04,0.288923E-04,0.124695E-02/
      DATA (DL(K),K= 2976, 3060) /
     &0.598767E-05,0.282894E-01,0.189287E-01,0.242960E-04,0.310036E-04,
     &0.244423E-04,0.242960E-04,0.104112E-02,0.556344E-05,0.243968E-01,
     &0.160504E-01,0.203920E-04,0.266363E-04,0.205232E-04,0.203920E-04,
     &0.863677E-03,0.510070E-05,0.209890E-01,0.135797E-01,0.170822E-04,
     &0.228449E-04,0.171989E-04,0.170822E-04,0.711641E-03,0.462338E-05,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.105155E+00,0.752467E-01,0.719932E-04,0.719932E-04,0.719932E-04,
     &0.719932E-04,0.328057E-02,-.758942E-18,0.920856E-01,0.645455E-01,
     &0.592305E-04,0.615087E-04,0.592802E-04,0.592305E-04,0.295327E-02,
     &0.945234E-07,0.804695E-01,0.552770E-01,0.489125E-04,0.528632E-04/
      DATA (DL(K),K= 3061, 3145) /
     &0.489946E-04,0.489125E-04,0.261804E-02,0.365139E-06,0.701499E-01,
     &0.472409E-01,0.404786E-04,0.456186E-04,0.405807E-04,0.404786E-04,
     &0.229460E-02,0.686912E-06,0.610049E-01,0.402864E-01,0.335367E-04,
     &0.394631E-04,0.336495E-04,0.335367E-04,0.198445E-02,0.981070E-06,
     &0.529201E-01,0.342803E-01,0.278134E-04,0.342044E-04,0.279301E-04,
     &0.278134E-04,0.169772E-02,0.122521E-05,0.457907E-01,0.291037E-01,
     &0.230821E-04,0.296833E-04,0.231978E-04,0.230821E-04,0.144575E-02,
     &0.140819E-05,0.395205E-01,0.246522E-01,0.191553E-04,0.257661E-04,
     &0.192666E-04,0.191553E-04,0.122125E-02,0.152152E-05,0.340212E-01,
     &0.208330E-01,0.158874E-04,0.223546E-04,0.159921E-04,0.158874E-04,
     &0.101912E-02,0.156880E-05,0.292116E-01,0.175644E-01,0.131678E-04,
     &0.193783E-04,0.132645E-04,0.131678E-04,0.847586E-03,0.156432E-05,
     &0.250173E-01,0.147740E-01,0.109029E-04,0.167762E-04,0.109910E-04,
     &0.109029E-04,0.705515E-03,0.151845E-05,0.213702E-01,0.123979E-01,
     &0.901273E-05,0.144953E-04,0.909200E-05,0.901273E-05,0.581767E-03,
     &0.143817E-05,0.182083E-01,0.103797E-01,0.743733E-05,0.124978E-04,
     &0.750792E-05,0.743733E-05,0.475483E-03,0.133574E-05,0.154751E-01/
      DATA (DL(K),K= 3146, 3230) /
     &0.867011E-02,0.612722E-05,0.107517E-04,0.618950E-05,0.612722E-05,
     &0.390116E-03,0.122183E-05,0.131193E-01,0.722560E-02,0.503734E-05,
     &0.922584E-05,0.509185E-05,0.503734E-05,0.319980E-03,0.110130E-05,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.754424E-01,0.449848E-01,0.236444E-04,0.236444E-04,0.236444E-04,
     &0.236444E-04,0.129291E-02,0.113079E-17,0.650429E-01,0.379660E-01,
     &0.187739E-04,0.207130E-04,0.187990E-04,0.187739E-04,0.124038E-02,
     &-.327995E-06,0.559588E-01,0.319936E-01,0.149625E-04,0.182671E-04,
     &0.150033E-04,0.149625E-04,0.113497E-02,-.464337E-06,0.480234E-01,
     &0.269030E-01,0.119484E-04,0.161746E-04,0.119982E-04,0.119484E-04/
      DATA (DL(K),K= 3231, 3315) /
     &0.100877E-02,-.490618E-06,0.411091E-01,0.225716E-01,0.954833E-05,
     &0.143391E-04,0.960250E-05,0.954833E-05,0.883852E-03,-.461770E-06,
     &0.350995E-01,0.188947E-01,0.763738E-05,0.127129E-04,0.769248E-05,
     &0.763738E-05,0.760077E-03,-.403363E-06,0.298897E-01,0.157798E-01,
     &0.611070E-05,0.112548E-04,0.616439E-05,0.611070E-05,0.639505E-03,
     &-.335607E-06,0.253856E-01,0.131470E-01,0.488993E-05,0.994021E-05,
     &0.494070E-05,0.488993E-05,0.534131E-03,-.267652E-06,0.215026E-01,
     &0.109271E-01,0.391276E-05,0.875190E-05,0.395967E-05,0.391276E-05,
     &0.445478E-03,-.205292E-06,0.181648E-01,0.906007E-02,0.312720E-05,
     &0.767418E-05,0.316978E-05,0.312720E-05,0.366232E-03,-.154024E-06,
     &0.153041E-01,0.749382E-02,0.249633E-05,0.670002E-05,0.253440E-05,
     &0.249633E-05,0.297435E-03,-.112673E-06,0.128596E-01,0.618334E-02,
     &0.199074E-05,0.582360E-05,0.202435E-05,0.199074E-05,0.242305E-03,
     &-.794410E-07,0.107770E-01,0.508977E-02,0.158457E-05,0.503733E-05,
     &0.161393E-05,0.158457E-05,0.196927E-03,-.546702E-07,0.900806E-02,
     &0.417964E-02,0.125888E-05,0.433619E-05,0.128428E-05,0.125888E-05,
     &0.158171E-03,-.364714E-07,0.751006E-02,0.342418E-02,0.998674E-06/
      DATA (DL(K),K= 3316, 3400) /
     &0.371518E-05,0.102046E-05,0.998674E-06,0.126865E-03,-.228706E-07,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.496787E-01,0.236961E-01,0.607312E-05,0.607312E-05,0.607312E-05,
     &0.607312E-05,0.415108E-03,-.140523E-17,0.420445E-01,0.196196E-01,
     &0.443589E-05,0.603481E-05,0.444683E-05,0.443589E-05,0.444425E-03,
     &-.375397E-06,0.355108E-01,0.162223E-01,0.321766E-05,0.587645E-05,
     &0.323504E-05,0.321766E-05,0.432635E-03,-.593989E-06,0.299148E-01,
     &0.133836E-01,0.231504E-05,0.562250E-05,0.233581E-05,0.231504E-05,
     &0.395801E-03,-.699904E-06,0.251339E-01,0.110157E-01,0.164651E-05,
     &0.526880E-05,0.166853E-05,0.164651E-05,0.344925E-03,-.733095E-06/
      DATA (DL(K),K= 3401, 3485) /
     &0.210605E-01,0.904539E-02,0.115940E-05,0.485739E-05,0.118122E-05,
     &0.115940E-05,0.294439E-03,-.715193E-06,0.175989E-01,0.740944E-02,
     &0.808365E-06,0.441709E-05,0.829075E-06,0.808365E-06,0.249093E-03,
     &-.665420E-06,0.146656E-01,0.605433E-02,0.555563E-06,0.396078E-05,
     &0.574607E-06,0.555563E-06,0.205675E-03,-.600648E-06,0.121872E-01,
     &0.493466E-02,0.375914E-06,0.350822E-05,0.393011E-06,0.375914E-06,
     &0.166757E-03,-.529210E-06,0.100993E-01,0.401191E-02,0.250032E-06,
     &0.307359E-05,0.265094E-06,0.250032E-06,0.135196E-03,-.456996E-06,
     &0.834582E-02,0.325348E-02,0.162261E-06,0.266488E-05,0.175325E-06,
     &0.162261E-06,0.108862E-03,-.388821E-06,0.687767E-02,0.263179E-02,
     &0.102273E-06,0.228913E-05,0.113453E-06,0.102273E-06,0.865539E-04,
     &-.326325E-06,0.565221E-02,0.212357E-02,0.620694E-07,0.194975E-05,
     &0.715290E-07,0.620694E-07,0.687156E-04,-.270547E-06,0.463248E-02,
     &0.170926E-02,0.351992E-07,0.164711E-05,0.431226E-07,0.351992E-07,
     &0.543744E-04,-.222379E-06,0.378655E-02,0.137242E-02,0.178902E-07,
     &0.138124E-05,0.244675E-07,0.178902E-07,0.426626E-04,-.181158E-06,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K= 3486, 3570) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.286141E-01,0.102357E-01,0.105702E-05,0.105702E-05,0.105702E-05,
     &0.105702E-05,0.963318E-04,0.591070E-18,0.236608E-01,0.827483E-02,
     &0.548552E-06,0.163293E-05,0.551993E-06,0.548552E-06,0.133058E-03,
     &-.268677E-06,0.195282E-01,0.668247E-02,0.238780E-06,0.183459E-05,
     &0.243802E-06,0.238780E-06,0.135119E-03,-.393414E-06,0.160742E-01,
     &0.538444E-02,0.599864E-07,0.183277E-05,0.655085E-07,0.599864E-07,
     &0.124554E-03,-.428349E-06,0.131940E-01,0.432750E-02,-.392825E-07,
     &0.172071E-05,-.338391E-07,-.392825E-07,0.111121E-03,-.415550E-06,
     &0.107996E-01,0.346954E-02,-.875089E-07,0.154604E-05,-.824926E-07,
     &-.875089E-07,0.941854E-04,-.376855E-06,0.881435E-02,0.277463E-02/
      DATA (DL(K),K= 3571, 3655) /
     &-.103962E-06,0.135013E-05,-.995446E-07,-.103962E-06,0.772195E-04,
     &-.326008E-06,0.717317E-02,0.221313E-02,-.102844E-06,0.115335E-05,
     &-.990733E-07,-.102844E-06,0.626565E-04,-.272858E-06,0.582050E-02,
     &0.176061E-02,-.929503E-07,0.967229E-06,-.898064E-07,-.929503E-07,
     &0.499930E-04,-.222828E-06,0.470908E-02,0.139692E-02,-.791495E-07,
     &0.800414E-06,-.765797E-07,-.791495E-07,0.394181E-04,-.178141E-06,
     &0.379875E-02,0.110542E-02,-.647230E-07,0.655119E-06,-.626567E-07,
     &-.647230E-07,0.309999E-04,-.140000E-06,0.305549E-02,0.872447E-03,
     &-.515215E-07,0.530834E-06,-.498829E-07,-.515215E-07,0.240354E-04,
     &-.108633E-06,0.245058E-02,0.686769E-03,-.400234E-07,0.426835E-06,
     &-.387401E-07,-.400234E-07,0.184613E-04,-.832544E-07,0.195984E-02,
     &0.539209E-03,-.304312E-07,0.341169E-06,-.294373E-07,-.304312E-07,
     &0.143512E-04,-.630818E-07,0.156297E-02,0.422273E-03,-.228633E-07,
     &0.271199E-06,-.221014E-07,-.228633E-07,0.110898E-04,-.474683E-07,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K= 3656, 3740) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.129345E-01,0.308444E-02,0.903693E-07,0.903693E-07,0.903693E-07,
     &0.903693E-07,0.123538E-04,-.166230E-18,0.103598E-01,0.241354E-02,
     &0.155648E-06,-.205296E-06,0.154889E-06,0.155648E-06,0.267249E-04,
     &0.880707E-07,0.828507E-02,0.188764E-02,0.176333E-06,-.341498E-06,
     &0.175220E-06,0.176333E-06,0.306432E-04,0.125718E-06,0.660736E-02,
     &0.147304E-02,0.173444E-06,-.383695E-06,0.172215E-06,0.173444E-06,
     &0.280787E-04,0.135578E-06,0.525320E-02,0.114618E-02,0.158651E-06,
     &-.373371E-06,0.157437E-06,0.158651E-06,0.243526E-04,0.130412E-06,
     &0.416429E-02,0.889584E-03,0.137131E-06,-.333468E-06,0.136012E-06,
     &0.137131E-06,0.203463E-04,0.116115E-06,0.329102E-02,0.688580E-03,
     &0.113839E-06,-.280874E-06,0.112853E-06,0.113839E-06,0.161038E-04,
     &0.982305E-07,0.259282E-02,0.531508E-03,0.914374E-07,-.225427E-06/
      DATA (DL(K),K= 3741, 3825) /
     &0.905971E-07,0.914374E-07,0.125639E-04,0.798741E-07,0.203641E-02,
     &0.409120E-03,0.709595E-07,-.173123E-06,0.702607E-07,0.709595E-07,
     &0.979247E-05,0.624138E-07,0.159441E-02,0.314027E-03,0.532256E-07,
     &-.127272E-06,0.526566E-07,0.532256E-07,0.741899E-05,0.469253E-07,
     &0.124447E-02,0.240357E-03,0.385509E-07,-.888851E-07,0.380956E-07,
     &0.385509E-07,0.554070E-05,0.339174E-07,0.968328E-03,0.183454E-03,
     &0.267272E-07,-.580277E-07,0.263687E-07,0.267272E-07,0.420032E-05,
     &0.233280E-07,0.751159E-03,0.139632E-03,0.174605E-07,-.342016E-07,
     &0.171822E-07,0.174605E-07,0.315522E-05,0.149727E-07,0.580936E-03,
     &0.105986E-03,0.104515E-07,-.164567E-07,0.102383E-07,0.104515E-07,
     &0.230829E-05,0.863527E-08,0.447955E-03,0.802293E-04,0.531954E-08,
     &-.376312E-08,0.515829E-08,0.531954E-08,0.170771E-05,0.399662E-08,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K= 3826, 3910) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.324478E-02,0.386879E-03,0.135983E-08,0.135983E-08,0.135983E-08,
     &0.135983E-08,0.371787E-06,-.274599E-19,0.246219E-02,0.286505E-03,
     &-.106852E-06,0.327611E-06,-.106589E-06,-.106852E-06,0.231631E-05,
     &-.107814E-06,0.186777E-02,0.212413E-03,-.161566E-06,0.492001E-06,
     &-.161179E-06,-.161566E-06,0.311589E-05,-.162249E-06,0.141322E-02,
     &0.157212E-03,-.183398E-06,0.557106E-06,-.182972E-06,-.183398E-06,
     &0.267943E-05,-.183884E-06,0.106518E-02,0.115892E-03,-.185231E-06,
     &0.562185E-06,-.184809E-06,-.185231E-06,0.203027E-05,-.185573E-06,
     &0.800350E-03,0.851995E-04,-.174680E-06,0.530096E-06,-.174290E-06,
     &-.174680E-06,0.165870E-05,-.174922E-06,0.599444E-03,0.624676E-04,
     &-.157644E-06,0.478420E-06,-.157300E-06,-.157644E-06,0.130112E-05,
     &-.157815E-06,0.447433E-03,0.456556E-04,-.137838E-06,0.418429E-06,
     &-.137543E-06,-.137838E-06,0.903220E-06,-.137958E-06,0.332836E-03,
     &0.332643E-04,-.117616E-06,0.357179E-06,-.117368E-06,-.117616E-06/
      DATA (DL(K),K= 3911, 3995) /
     &0.636187E-06,-.117699E-06,0.246754E-03,0.241622E-04,-.984560E-07,
     &0.299077E-06,-.982529E-07,-.984560E-07,0.481221E-06,-.985144E-07,
     &0.182315E-03,0.174961E-04,-.811089E-07,0.246465E-06,-.809446E-07,
     &-.811089E-07,0.342859E-06,-.811495E-07,0.134250E-03,0.126299E-04,
     &-.659052E-07,0.200354E-06,-.657742E-07,-.659052E-07,0.227840E-06,
     &-.659334E-07,0.985288E-04,0.908931E-05,-.529252E-07,0.160947E-06,
     &-.528218E-07,-.529252E-07,0.161641E-06,-.529447E-07,0.720750E-04,
     &0.652153E-05,-.420621E-07,0.127943E-06,-.419814E-07,-.420621E-07,
     &0.119540E-06,-.420756E-07,0.525538E-04,0.466527E-05,-.331141E-07,
     &0.100758E-06,-.330516E-07,-.331141E-07,0.808991E-07,-.331233E-07,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K= 3996, 4000) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
C
      ANS = 0.
      IF (X.GT.0.9985) RETURN
      IF ( ((I.EQ.3).OR.(I.EQ.8)) .AND. (X.GT.0.95) ) RETURN
C
      IS  = S/DELTA+1
      IS1 = IS+1
      DO 1 L=1,25
         KL    = L+NDRV*25
         F1(L) = GF(I,IS,KL)
         F2(L) = GF(I,IS1,KL)
    1 CONTINUE
      A1 = DT_CKMTFF(X,F1)
      A2 = DT_CKMTFF(X,F2)
C      A1=ALOG(A1)
C      A2=ALOG(A2)
      S1  = (IS-1)*DELTA
      S2  = S1+DELTA
      ANS = A1*(S-S2)/(S1-S2)+A2*(S-S1)/(S2-S1)
C      ANS=EXP(ANS)
      RETURN
      END
C
C
CDECK  ID>, DT_CKMTPR
      SUBROUTINE DT_CKMTPR(I,NDRV,X,S,ANS)
C
C**********************************************************************
C    Proton   - PDFs
C    I   = 1, 2, 3, 4, 5, 7, 8 : xu, xd, xub, xdb, xsb, xg, xc
C    ANS = PDF(I)
C    This version by S. Roesler, 31.01.96
C**********************************************************************

      SAVE
      DIMENSION F1(25),F2(25),GF(8,20,25),DL(4000)
      EQUIVALENCE (GF(1,1,1),DL(1))
      DATA DELTA/.10/
C
      DATA (DL(K),K=    1,   85) /
     &0.367759E+00,0.350609E+00,0.325356E+00,0.325356E+00,0.325356E+00,
     &0.325356E+00,0.533117E+01,0.138778E-16,0.427988E+00,0.409718E+00,
     &0.382948E+00,0.382920E+00,0.382933E+00,0.382948E+00,0.686279E+01,
     &0.611113E-01,0.494752E+00,0.475328E+00,0.447011E+00,0.446959E+00,
     &0.446984E+00,0.447011E+00,0.855688E+01,0.128659E+00,0.568248E+00,
     &0.547637E+00,0.517743E+00,0.517671E+00,0.517705E+00,0.517743E+00,
     &0.104074E+02,0.202846E+00,0.648622E+00,0.626792E+00,0.595289E+00,
     &0.595201E+00,0.595244E+00,0.595289E+00,0.124065E+02,0.283819E+00,
     &0.735974E+00,0.712890E+00,0.679748E+00,0.679648E+00,0.679696E+00,
     &0.679748E+00,0.145441E+02,0.371679E+00,0.830359E+00,0.805987E+00,
     &0.771173E+00,0.771066E+00,0.771119E+00,0.771173E+00,0.168081E+02,
     &0.466485E+00,0.931778E+00,0.906084E+00,0.869566E+00,0.869456E+00,
     &0.869511E+00,0.869566E+00,0.191850E+02,0.568240E+00,0.104018E+01,
     &0.101313E+01,0.974873E+00,0.974763E+00,0.974819E+00,0.974873E+00,
     &0.216593E+02,0.676890E+00,0.115544E+01,0.112700E+01,0.108698E+01,
     &0.108687E+01,0.108693E+01,0.108698E+01,0.242146E+02,0.792321E+00,
     &0.127738E+01,0.124751E+01,0.120570E+01,0.120560E+01,0.120565E+01/
      DATA (DL(K),K=   86,  170) /
     &0.120570E+01,0.268333E+02,0.914356E+00,0.140577E+01,0.137444E+01,
     &0.133079E+01,0.133070E+01,0.133075E+01,0.133079E+01,0.294970E+02,
     &0.104275E+01,0.154028E+01,0.150745E+01,0.146194E+01,0.146187E+01,
     &0.146192E+01,0.146194E+01,0.321867E+02,0.117720E+01,0.168054E+01,
     &0.164619E+01,0.159879E+01,0.159874E+01,0.159877E+01,0.159879E+01,
     &0.348836E+02,0.131732E+01,0.182613E+01,0.179020E+01,0.174088E+01,
     &0.174086E+01,0.174088E+01,0.174088E+01,0.375685E+02,0.146269E+01,
     &0.197653E+01,0.193901E+01,0.188774E+01,0.188774E+01,0.188775E+01,
     &0.188774E+01,0.402228E+02,0.161282E+01,0.213121E+01,0.209205E+01,
     &0.203880E+01,0.203884E+01,0.203884E+01,0.203880E+01,0.428285E+02,
     &0.176714E+01,0.228955E+01,0.224873E+01,0.219348E+01,0.219355E+01,
     &0.219353E+01,0.219348E+01,0.453682E+02,0.192507E+01,0.245093E+01,
     &0.240840E+01,0.235113E+01,0.235123E+01,0.235120E+01,0.235113E+01,
     &0.478258E+02,0.208597E+01,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.349839E+00,0.324128E+00,0.286363E+00,0.286363E+00,0.286363E+00,
     &0.286363E+00,0.469694E+01,0.000000E+00,0.398361E+00,0.371065E+00/
      DATA (DL(K),K=  171,  255) /
     &0.331239E+00,0.331213E+00,0.331227E+00,0.331239E+00,0.586152E+01,
     &0.481683E-01,0.451010E+00,0.422096E+00,0.380182E+00,0.380137E+00,
     &0.380161E+00,0.380182E+00,0.711349E+01,0.100378E+00,0.507782E+00,
     &0.477215E+00,0.433187E+00,0.433128E+00,0.433160E+00,0.433187E+00,
     &0.844371E+01,0.156627E+00,0.568644E+00,0.536390E+00,0.490220E+00,
     &0.490152E+00,0.490190E+00,0.490220E+00,0.984291E+01,0.216886E+00,
     &0.633517E+00,0.599543E+00,0.551204E+00,0.551133E+00,0.551174E+00,
     &0.551204E+00,0.113005E+02,0.281079E+00,0.702295E+00,0.666565E+00,
     &0.616031E+00,0.615963E+00,0.616004E+00,0.616031E+00,0.128050E+02,
     &0.349101E+00,0.774832E+00,0.737311E+00,0.684556E+00,0.684495E+00,
     &0.684535E+00,0.684556E+00,0.143447E+02,0.420809E+00,0.850945E+00,
     &0.811598E+00,0.756596E+00,0.756547E+00,0.756583E+00,0.756596E+00,
     &0.159073E+02,0.496022E+00,0.930413E+00,0.889207E+00,0.831933E+00,
     &0.831901E+00,0.831931E+00,0.831933E+00,0.174801E+02,0.574524E+00,
     &0.101298E+01,0.969882E+00,0.910312E+00,0.910301E+00,0.910324E+00,
     &0.910312E+00,0.190508E+02,0.656061E+00,0.109836E+01,0.105333E+01,
     &0.991445E+00,0.991459E+00,0.991471E+00,0.991445E+00,0.206070E+02/
      DATA (DL(K),K=  256,  340) /
     &0.740345E+00,0.118622E+01,0.113923E+01,0.107501E+01,0.107505E+01,
     &0.107505E+01,0.107501E+01,0.221368E+02,0.827056E+00,0.127622E+01,
     &0.122724E+01,0.116065E+01,0.116073E+01,0.116072E+01,0.116065E+01,
     &0.236287E+02,0.915845E+00,0.136797E+01,0.131696E+01,0.124800E+01,
     &0.124812E+01,0.124809E+01,0.124800E+01,0.250721E+02,0.100634E+01,
     &0.146107E+01,0.140801E+01,0.133666E+01,0.133681E+01,0.133677E+01,
     &0.133666E+01,0.264571E+02,0.109813E+01,0.155511E+01,0.149996E+01,
     &0.142621E+01,0.142641E+01,0.142634E+01,0.142621E+01,0.277747E+02,
     &0.119081E+01,0.164964E+01,0.159239E+01,0.151622E+01,0.151646E+01,
     &0.151638E+01,0.151622E+01,0.290168E+02,0.128396E+01,0.174424E+01,
     &0.168485E+01,0.160626E+01,0.160655E+01,0.160645E+01,0.160626E+01,
     &0.301765E+02,0.137713E+01,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.345345E+00,0.306823E+00,0.250518E+00,0.250518E+00,0.250518E+00,
     &0.250518E+00,0.411726E+01,-.138778E-16,0.384210E+00,0.343514E+00,
     &0.284500E+00,0.284487E+00,0.284496E+00,0.284500E+00,0.496835E+01,
     &0.371582E-01,0.425419E+00,0.382518E+00,0.320782E+00,0.320762E+00/
      DATA (DL(K),K=  341,  425) /
     &0.320777E+00,0.320782E+00,0.585504E+01,0.765988E-01,0.468853E+00,
     &0.423717E+00,0.359246E+00,0.359226E+00,0.359243E+00,0.359246E+00,
     &0.676824E+01,0.118207E+00,0.514392E+00,0.466990E+00,0.399771E+00,
     &0.399758E+00,0.399775E+00,0.399771E+00,0.769967E+01,0.161865E+00,
     &0.561883E+00,0.512186E+00,0.442209E+00,0.442208E+00,0.442222E+00,
     &0.442209E+00,0.864071E+01,0.207426E+00,0.611162E+00,0.559140E+00,
     &0.486395E+00,0.486411E+00,0.486420E+00,0.486395E+00,0.958280E+01,
     &0.254727E+00,0.662044E+00,0.607667E+00,0.532145E+00,0.532185E+00,
     &0.532185E+00,0.532145E+00,0.105176E+02,0.303587E+00,0.714325E+00,
     &0.657566E+00,0.579261E+00,0.579328E+00,0.579318E+00,0.579261E+00,
     &0.114370E+02,0.353808E+00,0.767786E+00,0.708618E+00,0.627526E+00,
     &0.627625E+00,0.627603E+00,0.627526E+00,0.123333E+02,0.405174E+00,
     &0.822195E+00,0.760591E+00,0.676711E+00,0.676846E+00,0.676810E+00,
     &0.676711E+00,0.131994E+02,0.457458E+00,0.877307E+00,0.813242E+00,
     &0.726575E+00,0.726750E+00,0.726697E+00,0.726575E+00,0.140286E+02,
     &0.510420E+00,0.932865E+00,0.866317E+00,0.776867E+00,0.777085E+00,
     &0.777015E+00,0.776867E+00,0.148150E+02,0.563809E+00,0.988608E+00/
      DATA (DL(K),K=  426,  510) /
     &0.919556E+00,0.827330E+00,0.827594E+00,0.827505E+00,0.827330E+00,
     &0.155533E+02,0.617368E+00,0.104427E+01,0.972694E+00,0.877703E+00,
     &0.878016E+00,0.877907E+00,0.877703E+00,0.162391E+02,0.670837E+00,
     &0.109958E+01,0.102547E+01,0.927723E+00,0.928088E+00,0.927957E+00,
     &0.927723E+00,0.168687E+02,0.723954E+00,0.115428E+01,0.107761E+01,
     &0.977132E+00,0.977550E+00,0.977397E+00,0.977132E+00,0.174391E+02,
     &0.776458E+00,0.120809E+01,0.112886E+01,0.102567E+01,0.102615E+01,
     &0.102597E+01,0.102567E+01,0.179481E+02,0.828097E+00,0.126078E+01,
     &0.117898E+01,0.107310E+01,0.107363E+01,0.107343E+01,0.107310E+01,
     &0.183942E+02,0.878621E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.357586E+00,0.299938E+00,0.216504E+00,0.216504E+00,0.216504E+00,
     &0.216504E+00,0.357260E+01,-.277556E-16,0.388529E+00,0.327984E+00,
     &0.241161E+00,0.241168E+00,0.241168E+00,0.241161E+00,0.415893E+01,
     &0.278429E-01,0.420472E+00,0.357015E+00,0.266823E+00,0.266844E+00,
     &0.266842E+00,0.266823E+00,0.474689E+01,0.566783E-01,0.453271E+00,
     &0.386886E+00,0.293349E+00,0.293389E+00,0.293381E+00,0.293349E+00/
      DATA (DL(K),K=  511,  595) /
     &0.532982E+01,0.863668E-01,0.486793E+00,0.417464E+00,0.320608E+00,
     &0.320673E+00,0.320657E+00,0.320608E+00,0.590219E+01,0.116779E+00,
     &0.520887E+00,0.448601E+00,0.348454E+00,0.348549E+00,0.348523E+00,
     &0.348454E+00,0.645868E+01,0.147773E+00,0.555403E+00,0.480149E+00,
     &0.376740E+00,0.376870E+00,0.376831E+00,0.376740E+00,0.699440E+01,
     &0.179201E+00,0.590183E+00,0.511950E+00,0.405314E+00,0.405482E+00,
     &0.405429E+00,0.405314E+00,0.750493E+01,0.210912E+00,0.625064E+00,
     &0.543845E+00,0.434019E+00,0.434229E+00,0.434159E+00,0.434019E+00,
     &0.798636E+01,0.242750E+00,0.659882E+00,0.575673E+00,0.462696E+00,
     &0.462952E+00,0.462864E+00,0.462696E+00,0.843528E+01,0.274558E+00,
     &0.694472E+00,0.607271E+00,0.491188E+00,0.491492E+00,0.491385E+00,
     &0.491188E+00,0.884885E+01,0.306178E+00,0.728669E+00,0.638478E+00,
     &0.519337E+00,0.519690E+00,0.519563E+00,0.519337E+00,0.922480E+01,
     &0.337451E+00,0.762311E+00,0.669133E+00,0.546987E+00,0.547392E+00,
     &0.547244E+00,0.546987E+00,0.956139E+01,0.368224E+00,0.795240E+00,
     &0.699084E+00,0.573988E+00,0.574447E+00,0.574277E+00,0.573988E+00,
     &0.985744E+01,0.398346E+00,0.827302E+00,0.728181E+00,0.600196E+00/
      DATA (DL(K),K=  596,  680) /
     &0.600710E+00,0.600518E+00,0.600196E+00,0.101123E+02,0.427671E+00,
     &0.858354E+00,0.756282E+00,0.625475E+00,0.626044E+00,0.625829E+00,
     &0.625475E+00,0.103258E+02,0.456064E+00,0.888257E+00,0.783256E+00,
     &0.649696E+00,0.650321E+00,0.650083E+00,0.649696E+00,0.104982E+02,
     &0.483395E+00,0.916887E+00,0.808981E+00,0.672742E+00,0.673422E+00,
     &0.673161E+00,0.672742E+00,0.106303E+02,0.509546E+00,0.944126E+00,
     &0.833345E+00,0.694506E+00,0.695243E+00,0.694958E+00,0.694506E+00,
     &0.107231E+02,0.534410E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.390721E+00,0.304671E+00,0.182562E+00,0.182562E+00,0.182562E+00,
     &0.182562E+00,0.303699E+01,0.693889E-17,0.414806E+00,0.325059E+00,
     &0.199103E+00,0.199133E+00,0.199124E+00,0.199103E+00,0.339971E+01,
     &0.198528E-01,0.438929E+00,0.345508E+00,0.215797E+00,0.215862E+00,
     &0.215842E+00,0.215797E+00,0.374624E+01,0.398420E-01,0.462973E+00,
     &0.365903E+00,0.232531E+00,0.232635E+00,0.232601E+00,0.232531E+00,
     &0.407322E+01,0.598565E-01,0.486835E+00,0.386142E+00,0.249208E+00,
     &0.249352E+00,0.249304E+00,0.249208E+00,0.437817E+01,0.797987E-01/
      DATA (DL(K),K=  681,  765) /
     &0.510407E+00,0.406123E+00,0.265725E+00,0.265913E+00,0.265849E+00,
     &0.265725E+00,0.465901E+01,0.995694E-01,0.533588E+00,0.425746E+00,
     &0.281986E+00,0.282220E+00,0.282139E+00,0.281986E+00,0.491410E+01,
     &0.119072E+00,0.556274E+00,0.444912E+00,0.297897E+00,0.298178E+00,
     &0.298079E+00,0.297897E+00,0.514220E+01,0.138212E+00,0.578369E+00,
     &0.463528E+00,0.313366E+00,0.313696E+00,0.313578E+00,0.313366E+00,
     &0.534249E+01,0.156900E+00,0.599777E+00,0.481503E+00,0.328308E+00,
     &0.328688E+00,0.328549E+00,0.328308E+00,0.551456E+01,0.175048E+00,
     &0.620409E+00,0.498752E+00,0.342642E+00,0.343071E+00,0.342913E+00,
     &0.342642E+00,0.565833E+01,0.192575E+00,0.640181E+00,0.515196E+00,
     &0.356292E+00,0.356770E+00,0.356592E+00,0.356292E+00,0.577410E+01,
     &0.209407E+00,0.659017E+00,0.530764E+00,0.369190E+00,0.369718E+00,
     &0.369519E+00,0.369190E+00,0.586243E+01,0.225474E+00,0.676845E+00,
     &0.545389E+00,0.381275E+00,0.381852E+00,0.381633E+00,0.381275E+00,
     &0.592421E+01,0.240714E+00,0.693604E+00,0.559015E+00,0.392493E+00,
     &0.393118E+00,0.392880E+00,0.392493E+00,0.596052E+01,0.255072E+00,
     &0.709239E+00,0.571593E+00,0.402799E+00,0.403472E+00,0.403213E+00/
      DATA (DL(K),K=  766,  850) /
     &0.402799E+00,0.597267E+01,0.268502E+00,0.723703E+00,0.583081E+00,
     &0.412157E+00,0.412875E+00,0.412597E+00,0.412157E+00,0.596211E+01,
     &0.280966E+00,0.736960E+00,0.593447E+00,0.420536E+00,0.421299E+00,
     &0.421002E+00,0.420536E+00,0.593045E+01,0.292434E+00,0.748980E+00,
     &0.602669E+00,0.427918E+00,0.428723E+00,0.428408E+00,0.427918E+00,
     &0.587934E+01,0.302884E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.448390E+00,0.320678E+00,0.146415E+00,0.146415E+00,0.146415E+00,
     &0.146415E+00,0.247594E+01,0.000000E+00,0.465760E+00,0.333734E+00,
     &0.155974E+00,0.156013E+00,0.156000E+00,0.155974E+00,0.265633E+01,
     &0.130329E-01,0.482525E+00,0.346293E+00,0.165233E+00,0.165311E+00,
     &0.165285E+00,0.165233E+00,0.281612E+01,0.257304E-01,0.498626E+00,
     &0.358294E+00,0.174131E+00,0.174249E+00,0.174209E+00,0.174131E+00,
     &0.295484E+01,0.380345E-01,0.514008E+00,0.369688E+00,0.182622E+00,
     &0.182779E+00,0.182724E+00,0.182622E+00,0.307242E+01,0.498976E-01,
     &0.528624E+00,0.380432E+00,0.190660E+00,0.190856E+00,0.190786E+00,
     &0.190660E+00,0.316911E+01,0.612760E-01,0.542428E+00,0.390485E+00/
      DATA (DL(K),K=  851,  935) /
     &0.198205E+00,0.198441E+00,0.198356E+00,0.198205E+00,0.324538E+01,
     &0.721303E-01,0.555382E+00,0.399810E+00,0.205224E+00,0.205498E+00,
     &0.205398E+00,0.205224E+00,0.330192E+01,0.824256E-01,0.567448E+00,
     &0.408377E+00,0.211687E+00,0.211997E+00,0.211882E+00,0.211687E+00,
     &0.333960E+01,0.921319E-01,0.578597E+00,0.416159E+00,0.217568E+00,
     &0.217915E+00,0.217784E+00,0.217568E+00,0.335945E+01,0.101224E+00,
     &0.588802E+00,0.423136E+00,0.222847E+00,0.223229E+00,0.223084E+00,
     &0.222847E+00,0.336262E+01,0.109681E+00,0.598043E+00,0.429293E+00,
     &0.227512E+00,0.227928E+00,0.227768E+00,0.227512E+00,0.335036E+01,
     &0.117489E+00,0.606305E+00,0.434619E+00,0.231551E+00,0.232000E+00,
     &0.231826E+00,0.231551E+00,0.332398E+01,0.124636E+00,0.613579E+00,
     &0.439110E+00,0.234962E+00,0.235442E+00,0.235254E+00,0.234962E+00,
     &0.328483E+01,0.131119E+00,0.619860E+00,0.442766E+00,0.237745E+00,
     &0.238254E+00,0.238053E+00,0.237745E+00,0.323429E+01,0.136936E+00,
     &0.625150E+00,0.445594E+00,0.239905E+00,0.240441E+00,0.240228E+00,
     &0.239905E+00,0.317371E+01,0.142091E+00,0.629453E+00,0.447603E+00,
     &0.241452E+00,0.242014E+00,0.241788E+00,0.241452E+00,0.310443E+01/
      DATA (DL(K),K=  936, 1020) /
     &0.146594E+00,0.632782E+00,0.448808E+00,0.242400E+00,0.242987E+00,
     &0.242749E+00,0.242400E+00,0.302775E+01,0.150456E+00,0.635151E+00,
     &0.449228E+00,0.242767E+00,0.243376E+00,0.243127E+00,0.242767E+00,
     &0.294491E+01,0.153694E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.528765E+00,0.341825E+00,0.105823E+00,0.105823E+00,0.105823E+00,
     &0.105823E+00,0.185069E+01,-.138778E-16,0.538124E+00,0.347118E+00,
     &0.109762E+00,0.109780E+00,0.109774E+00,0.109762E+00,0.189644E+01,
     &0.738880E-02,0.546541E+00,0.351712E+00,0.113300E+00,0.113336E+00,
     &0.113324E+00,0.113300E+00,0.192700E+01,0.143076E-01,0.554014E+00,
     &0.355607E+00,0.116431E+00,0.116485E+00,0.116466E+00,0.116431E+00,
     &0.194356E+01,0.207515E-01,0.560546E+00,0.358805E+00,0.119150E+00,
     &0.119222E+00,0.119196E+00,0.119150E+00,0.194722E+01,0.267179E-01,
     &0.566139E+00,0.361311E+00,0.121459E+00,0.121549E+00,0.121515E+00,
     &0.121459E+00,0.193921E+01,0.322084E-01,0.570802E+00,0.363134E+00,
     &0.123359E+00,0.123467E+00,0.123426E+00,0.123359E+00,0.192071E+01,
     &0.372262E-01,0.574542E+00,0.364286E+00,0.124858E+00,0.124983E+00/
      DATA (DL(K),K= 1021, 1105) /
     &0.124933E+00,0.124858E+00,0.189295E+01,0.417774E-01,0.577372E+00,
     &0.364779E+00,0.125961E+00,0.126103E+00,0.126046E+00,0.125961E+00,
     &0.185710E+01,0.458703E-01,0.579307E+00,0.364629E+00,0.126681E+00,
     &0.126839E+00,0.126774E+00,0.126681E+00,0.181432E+01,0.495154E-01,
     &0.580363E+00,0.363857E+00,0.127029E+00,0.127202E+00,0.127130E+00,
     &0.127029E+00,0.176571E+01,0.527252E-01,0.580561E+00,0.362483E+00,
     &0.127020E+00,0.127208E+00,0.127128E+00,0.127020E+00,0.171231E+01,
     &0.555142E-01,0.579923E+00,0.360529E+00,0.126670E+00,0.126872E+00,
     &0.126785E+00,0.126670E+00,0.165511E+01,0.578985E-01,0.578474E+00,
     &0.358021E+00,0.125998E+00,0.126213E+00,0.126119E+00,0.125998E+00,
     &0.159501E+01,0.598958E-01,0.576241E+00,0.354987E+00,0.125022E+00,
     &0.125249E+00,0.125148E+00,0.125022E+00,0.153284E+01,0.615248E-01,
     &0.573252E+00,0.351453E+00,0.123762E+00,0.124000E+00,0.123893E+00,
     &0.123762E+00,0.146934E+01,0.628056E-01,0.569539E+00,0.347450E+00,
     &0.122240E+00,0.122488E+00,0.122375E+00,0.122240E+00,0.140517E+01,
     &0.637587E-01,0.565134E+00,0.343008E+00,0.120476E+00,0.120733E+00,
     &0.120615E+00,0.120476E+00,0.134093E+01,0.644054E-01,0.560071E+00/
      DATA (DL(K),K= 1106, 1190) /
     &0.338158E+00,0.118493E+00,0.118758E+00,0.118635E+00,0.118493E+00,
     &0.127712E+01,0.647671E-01,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.584093E+00,0.349173E+00,0.772117E-01,0.772117E-01,0.772117E-01,
     &0.772117E-01,0.140433E+01,0.346945E-17,0.586736E+00,0.349017E+00,
     &0.785355E-01,0.785519E-01,0.785448E-01,0.785355E-01,0.139434E+01,
     &0.447504E-02,0.588402E+00,0.348237E+00,0.795437E-01,0.795759E-01,
     &0.795617E-01,0.795437E-01,0.137550E+01,0.854114E-02,0.589124E+00,
     &0.346861E+00,0.802498E-01,0.802970E-01,0.802758E-01,0.802498E-01,
     &0.134918E+01,0.122148E-01,0.588930E+00,0.344912E+00,0.806656E-01,
     &0.807271E-01,0.806990E-01,0.806656E-01,0.131652E+01,0.155101E-01,
     &0.587849E+00,0.342417E+00,0.808055E-01,0.808805E-01,0.808457E-01,
     &0.808055E-01,0.127862E+01,0.184435E-01,0.585912E+00,0.339402E+00,
     &0.806843E-01,0.807718E-01,0.807306E-01,0.806843E-01,0.123648E+01,
     &0.210315E-01,0.583151E+00,0.335894E+00,0.803173E-01,0.804166E-01,
     &0.803692E-01,0.803173E-01,0.119104E+01,0.232909E-01,0.579599E+00,
     &0.331923E+00,0.797205E-01,0.798308E-01,0.797775E-01,0.797205E-01/
      DATA (DL(K),K= 1191, 1275) /
     &0.114317E+01,0.252394E-01,0.575288E+00,0.327516E+00,0.789107E-01,
     &0.790310E-01,0.789721E-01,0.789107E-01,0.109362E+01,0.268946E-01,
     &0.570253E+00,0.322704E+00,0.779045E-01,0.780341E-01,0.779698E-01,
     &0.779045E-01,0.104307E+01,0.282745E-01,0.564530E+00,0.317515E+00,
     &0.767190E-01,0.768570E-01,0.767878E-01,0.767190E-01,0.992143E+00,
     &0.293974E-01,0.558155E+00,0.311981E+00,0.753713E-01,0.755169E-01,
     &0.754432E-01,0.753713E-01,0.941341E+00,0.302812E-01,0.551166E+00,
     &0.306131E+00,0.738784E-01,0.740308E-01,0.739528E-01,0.738784E-01,
     &0.891113E+00,0.309441E-01,0.543599E+00,0.299995E+00,0.722571E-01,
     &0.724154E-01,0.723336E-01,0.722571E-01,0.841829E+00,0.314037E-01,
     &0.535494E+00,0.293603E+00,0.705237E-01,0.706871E-01,0.706019E-01,
     &0.705237E-01,0.793794E+00,0.316774E-01,0.526888E+00,0.286986E+00,
     &0.686941E-01,0.688619E-01,0.687736E-01,0.686941E-01,0.747249E+00,
     &0.317823E-01,0.517822E+00,0.280172E+00,0.667836E-01,0.669551E-01,
     &0.668640E-01,0.667836E-01,0.702381E+00,0.317346E-01,0.508333E+00,
     &0.273189E+00,0.648068E-01,0.649814E-01,0.648879E-01,0.648068E-01,
     &0.659330E+00,0.315501E-01,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K= 1276, 1360) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.622739E+00,0.340676E+00,0.509141E-01,0.509141E-01,0.509141E-01,
     &0.509141E-01,0.980502E+00,-.173472E-17,0.617764E+00,0.335457E+00,
     &0.507607E-01,0.507701E-01,0.507651E-01,0.507607E-01,0.944375E+00,
     &0.242386E-02,0.611957E+00,0.329837E+00,0.504236E-01,0.504417E-01,
     &0.504321E-01,0.504236E-01,0.905225E+00,0.455851E-02,0.605372E+00,
     &0.323853E+00,0.499207E-01,0.499471E-01,0.499328E-01,0.499207E-01,
     &0.864035E+00,0.642656E-02,0.598052E+00,0.317537E+00,0.492668E-01,
     &0.493008E-01,0.492822E-01,0.492668E-01,0.821557E+00,0.804638E-02,
     &0.590044E+00,0.310919E+00,0.484772E-01,0.485183E-01,0.484955E-01,
     &0.484772E-01,0.778444E+00,0.943663E-02,0.581391E+00,0.304033E+00,
     &0.475665E-01,0.476142E-01,0.475874E-01,0.475665E-01,0.735263E+00,
     &0.106150E-01,0.572137E+00,0.296908E+00,0.465487E-01,0.466024E-01,
     &0.465720E-01,0.465487E-01,0.692487E+00,0.115984E-01,0.562326E+00,
     &0.289573E+00,0.454376E-01,0.454968E-01,0.454629E-01,0.454376E-01,
     &0.650510E+00,0.124032E-01,0.552003E+00,0.282060E+00,0.442463E-01,
     &0.443103E-01,0.442733E-01,0.442463E-01,0.609652E+00,0.130451E-01/
      DATA (DL(K),K= 1361, 1445) /
     &0.541210E+00,0.274395E+00,0.429871E-01,0.430555E-01,0.430156E-01,
     &0.429871E-01,0.570164E+00,0.135389E-01,0.529991E+00,0.266608E+00,
     &0.416720E-01,0.417443E-01,0.417018E-01,0.416720E-01,0.532237E+00,
     &0.138989E-01,0.518389E+00,0.258725E+00,0.403123E-01,0.403879E-01,
     &0.403431E-01,0.403123E-01,0.496010E+00,0.141386E-01,0.506446E+00,
     &0.250772E+00,0.389186E-01,0.389971E-01,0.389501E-01,0.389186E-01,
     &0.461573E+00,0.142708E-01,0.494204E+00,0.242775E+00,0.375006E-01,
     &0.375815E-01,0.375327E-01,0.375006E-01,0.428979E+00,0.143074E-01,
     &0.481705E+00,0.234757E+00,0.360674E-01,0.361503E-01,0.361000E-01,
     &0.360674E-01,0.398246E+00,0.142598E-01,0.468990E+00,0.226741E+00,
     &0.346276E-01,0.347120E-01,0.346605E-01,0.346276E-01,0.369363E+00,
     &0.141385E-01,0.456098E+00,0.218750E+00,0.331887E-01,0.332743E-01,
     &0.332216E-01,0.331887E-01,0.342300E+00,0.139532E-01,0.443068E+00,
     &0.210804E+00,0.317576E-01,0.318440E-01,0.317905E-01,0.317576E-01,
     &0.317005E+00,0.137130E-01,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.631458E+00,0.318714E+00,0.335640E-01,0.335640E-01,0.335640E-01/
      DATA (DL(K),K= 1446, 1530) /
     &0.335640E-01,0.686773E+00,0.346945E-17,0.620274E+00,0.310241E+00,
     &0.329311E-01,0.329377E-01,0.329337E-01,0.329311E-01,0.646559E+00,
     &0.135960E-02,0.608504E+00,0.301610E+00,0.322083E-01,0.322210E-01,
     &0.322133E-01,0.322083E-01,0.606503E+00,0.252820E-02,0.596205E+00,
     &0.292854E+00,0.314099E-01,0.314281E-01,0.314169E-01,0.314099E-01,
     &0.567134E+00,0.352543E-02,0.583429E+00,0.284002E+00,0.305470E-01,
     &0.305704E-01,0.305558E-01,0.305470E-01,0.528824E+00,0.436693E-02,
     &0.570223E+00,0.275080E+00,0.296307E-01,0.296586E-01,0.296411E-01,
     &0.296307E-01,0.491848E+00,0.506768E-02,0.556637E+00,0.266115E+00,
     &0.286709E-01,0.287030E-01,0.286827E-01,0.286709E-01,0.456422E+00,
     &0.564157E-02,0.542717E+00,0.257131E+00,0.276770E-01,0.277128E-01,
     &0.276900E-01,0.276770E-01,0.422697E+00,0.610148E-02,0.528511E+00,
     &0.248154E+00,0.266578E-01,0.266968E-01,0.266718E-01,0.266578E-01,
     &0.390771E+00,0.645942E-02,0.514062E+00,0.239205E+00,0.256210E-01,
     &0.256629E-01,0.256359E-01,0.256210E-01,0.360700E+00,0.672653E-02,
     &0.499417E+00,0.230307E+00,0.245741E-01,0.246185E-01,0.245896E-01,
     &0.245741E-01,0.332498E+00,0.691312E-02,0.484617E+00,0.221480E+00/
      DATA (DL(K),K= 1531, 1615) /
     &0.235237E-01,0.235701E-01,0.235397E-01,0.235237E-01,0.306153E+00,
     &0.702875E-02,0.469706E+00,0.212745E+00,0.224757E-01,0.225238E-01,
     &0.224921E-01,0.224757E-01,0.281624E+00,0.708222E-02,0.454725E+00,
     &0.204118E+00,0.214355E-01,0.214850E-01,0.214522E-01,0.214355E-01,
     &0.258855E+00,0.708159E-02,0.439713E+00,0.195618E+00,0.204079E-01,
     &0.204586E-01,0.204249E-01,0.204079E-01,0.237774E+00,0.703428E-02,
     &0.424709E+00,0.187259E+00,0.193972E-01,0.194486E-01,0.194142E-01,
     &0.193972E-01,0.218298E+00,0.694702E-02,0.409750E+00,0.179057E+00,
     &0.184069E-01,0.184588E-01,0.184239E-01,0.184069E-01,0.200339E+00,
     &0.682594E-02,0.394870E+00,0.171023E+00,0.174402E-01,0.174924E-01,
     &0.174571E-01,0.174402E-01,0.183804E+00,0.667657E-02,0.380104E+00,
     &0.163171E+00,0.164997E-01,0.165519E-01,0.165164E-01,0.164997E-01,
     &0.168600E+00,0.650389E-02,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.619056E+00,0.288873E+00,0.218554E-01,0.218554E-01,0.218554E-01,
     &0.218554E-01,0.477010E+00,-.867362E-17,0.602890E+00,0.278444E+00,
     &0.211480E-01,0.211530E-01,0.211497E-01,0.211480E-01,0.440877E+00/
      DATA (DL(K),K= 1616, 1700) /
     &0.767466E-03,0.586431E+00,0.268081E+00,0.204081E-01,0.204175E-01,
     &0.204113E-01,0.204081E-01,0.406417E+00,0.141432E-02,0.569736E+00,
     &0.257807E+00,0.196446E-01,0.196581E-01,0.196491E-01,0.196446E-01,
     &0.373808E+00,0.195508E-02,0.552853E+00,0.247642E+00,0.188646E-01,
     &0.188816E-01,0.188701E-01,0.188646E-01,0.343145E+00,0.240123E-02,
     &0.535829E+00,0.237603E+00,0.180743E-01,0.180945E-01,0.180808E-01,
     &0.180743E-01,0.314460E+00,0.276332E-02,0.518710E+00,0.227710E+00,
     &0.172796E-01,0.173025E-01,0.172868E-01,0.172796E-01,0.287750E+00,
     &0.305100E-02,0.501539E+00,0.217977E+00,0.164854E-01,0.165108E-01,
     &0.164933E-01,0.164854E-01,0.262983E+00,0.327305E-02,0.484360E+00,
     &0.208420E+00,0.156964E-01,0.157239E-01,0.157049E-01,0.156964E-01,
     &0.240098E+00,0.343744E-02,0.467213E+00,0.199053E+00,0.149165E-01,
     &0.149457E-01,0.149254E-01,0.149165E-01,0.219021E+00,0.355144E-02,
     &0.450140E+00,0.189889E+00,0.141493E-01,0.141800E-01,0.141586E-01,
     &0.141493E-01,0.199660E+00,0.362164E-02,0.433177E+00,0.180939E+00,
     &0.133978E-01,0.134297E-01,0.134073E-01,0.133978E-01,0.181918E+00,
     &0.365401E-02,0.416362E+00,0.172214E+00,0.126646E-01,0.126974E-01/
      DATA (DL(K),K= 1701, 1785) /
     &0.126742E-01,0.126646E-01,0.165692E+00,0.365394E-02,0.399729E+00,
     &0.163725E+00,0.119518E-01,0.119853E-01,0.119615E-01,0.119518E-01,
     &0.150875E+00,0.362628E-02,0.383310E+00,0.155477E+00,0.112613E-01,
     &0.112952E-01,0.112711E-01,0.112613E-01,0.137364E+00,0.357539E-02,
     &0.367138E+00,0.147479E+00,0.105945E-01,0.106287E-01,0.106042E-01,
     &0.105945E-01,0.125056E+00,0.350515E-02,0.351239E+00,0.139737E+00,
     &0.995250E-02,0.998673E-02,0.996211E-02,0.995250E-02,0.113852E+00,
     &0.341903E-02,0.335641E+00,0.132253E+00,0.933610E-02,0.937024E-02,
     &0.934557E-02,0.933610E-02,0.103659E+00,0.332009E-02,0.320367E+00,
     &0.125033E+00,0.874584E-02,0.877973E-02,0.875514E-02,0.874584E-02,
     &0.943886E-01,0.321106E-02,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.591114E+00,0.254807E+00,0.139531E-01,0.139531E-01,0.139531E-01,
     &0.139531E-01,0.326288E+00,0.000000E+00,0.571121E+00,0.243424E+00,
     &0.133325E-01,0.133362E-01,0.133336E-01,0.133325E-01,0.296956E+00,
     &0.429082E-03,0.551151E+00,0.232297E+00,0.127105E-01,0.127175E-01,
     &0.127126E-01,0.127105E-01,0.269811E+00,0.785137E-03,0.531253E+00/
      DATA (DL(K),K= 1786, 1870) /
     &0.221436E+00,0.120916E-01,0.121015E-01,0.120945E-01,0.120916E-01,
     &0.244803E+00,0.107790E-02,0.511467E+00,0.210850E+00,0.114794E-01,
     &0.114918E-01,0.114829E-01,0.114794E-01,0.221863E+00,0.131504E-02,
     &0.491833E+00,0.200545E+00,0.108767E-01,0.108913E-01,0.108808E-01,
     &0.108767E-01,0.200886E+00,0.150337E-02,0.472388E+00,0.190531E+00,
     &0.102861E-01,0.103027E-01,0.102907E-01,0.102861E-01,0.181762E+00,
     &0.164910E-02,0.453170E+00,0.180812E+00,0.970979E-02,0.972799E-02,
     &0.971477E-02,0.970979E-02,0.164371E+00,0.175777E-02,0.434213E+00,
     &0.171394E+00,0.914959E-02,0.916916E-02,0.915488E-02,0.914959E-02,
     &0.148589E+00,0.183434E-02,0.415548E+00,0.162282E+00,0.860700E-02,
     &0.862770E-02,0.861252E-02,0.860700E-02,0.134293E+00,0.188328E-02,
     &0.397208E+00,0.153479E+00,0.808323E-02,0.810484E-02,0.808891E-02,
     &0.808323E-02,0.121361E+00,0.190856E-02,0.379220E+00,0.144989E+00,
     &0.757922E-02,0.760152E-02,0.758501E-02,0.757922E-02,0.109676E+00,
     &0.191374E-02,0.361611E+00,0.136811E+00,0.709565E-02,0.711846E-02,
     &0.710150E-02,0.709565E-02,0.991261E-01,0.190199E-02,0.344406E+00,
     &0.128948E+00,0.663300E-02,0.665614E-02,0.663885E-02,0.663300E-02/
      DATA (DL(K),K= 1871, 1955) /
     &0.896059E-01,0.187610E-02,0.327627E+00,0.121398E+00,0.619152E-02,
     &0.621484E-02,0.619734E-02,0.619152E-02,0.810177E-01,0.183856E-02,
     &0.311292E+00,0.114161E+00,0.577130E-02,0.579466E-02,0.577706E-02,
     &0.577130E-02,0.732709E-01,0.179155E-02,0.295421E+00,0.107235E+00,
     &0.537228E-02,0.539554E-02,0.537794E-02,0.537228E-02,0.662824E-01,
     &0.173700E-02,0.280026E+00,0.100616E+00,0.499423E-02,0.501728E-02,
     &0.499977E-02,0.499423E-02,0.599766E-01,0.167658E-02,0.265121E+00,
     &0.943000E-01,0.463683E-02,0.465958E-02,0.464223E-02,0.463683E-02,
     &0.542848E-01,0.161174E-02,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.551659E+00,0.219084E+00,0.867977E-02,0.867977E-02,0.867977E-02,
     &0.867977E-02,0.218587E+00,-.173472E-16,0.528947E+00,0.207536E+00,
     &0.819621E-02,0.819909E-02,0.819696E-02,0.819621E-02,0.196367E+00,
     &0.234843E-03,0.506575E+00,0.196391E+00,0.772540E-02,0.773082E-02,
     &0.772680E-02,0.772540E-02,0.176280E+00,0.427503E-03,0.484579E+00,
     &0.185646E+00,0.726876E-02,0.727639E-02,0.727069E-02,0.726876E-02,
     &0.158158E+00,0.583933E-03,0.462988E+00,0.175298E+00,0.682746E-02/
      DATA (DL(K),K= 1956, 2040) /
     &0.683702E-02,0.682985E-02,0.682746E-02,0.141851E+00,0.708874E-03,
     &0.441830E+00,0.165345E+00,0.640226E-02,0.641347E-02,0.640502E-02,
     &0.640226E-02,0.127203E+00,0.806409E-03,0.421129E+00,0.155783E+00,
     &0.599380E-02,0.600641E-02,0.599686E-02,0.599380E-02,0.114065E+00,
     &0.880249E-03,0.400912E+00,0.146609E+00,0.560252E-02,0.561629E-02,
     &0.560581E-02,0.560252E-02,0.102296E+00,0.933676E-03,0.381199E+00,
     &0.137819E+00,0.522870E-02,0.524342E-02,0.523217E-02,0.522870E-02,
     &0.917608E-01,0.969607E-03,0.362011E+00,0.129407E+00,0.487247E-02,
     &0.488796E-02,0.487607E-02,0.487247E-02,0.823356E-01,0.990632E-03,
     &0.343367E+00,0.121370E+00,0.453385E-02,0.454992E-02,0.453753E-02,
     &0.453385E-02,0.739054E-01,0.999042E-03,0.325282E+00,0.113700E+00,
     &0.421272E-02,0.422921E-02,0.421644E-02,0.421272E-02,0.663651E-01,
     &0.996863E-03,0.307770E+00,0.106393E+00,0.390887E-02,0.392563E-02,
     &0.391260E-02,0.390887E-02,0.596195E-01,0.985881E-03,0.290841E+00,
     &0.994399E-01,0.362199E-02,0.363889E-02,0.362570E-02,0.362199E-02,
     &0.535826E-01,0.967664E-03,0.274506E+00,0.928343E-01,0.335170E-02,
     &0.336862E-02,0.335536E-02,0.335170E-02,0.481769E-01,0.943587E-03/
      DATA (DL(K),K= 2041, 2125) /
     &0.258771E+00,0.865679E-01,0.309756E-02,0.311439E-02,0.310114E-02,
     &0.309756E-02,0.433336E-01,0.914850E-03,0.243639E+00,0.806321E-01,
     &0.285905E-02,0.287571E-02,0.286255E-02,0.285905E-02,0.389912E-01,
     &0.882497E-03,0.229113E+00,0.750177E-01,0.263565E-02,0.265205E-02,
     &0.263905E-02,0.263565E-02,0.350948E-01,0.847432E-03,0.215193E+00,
     &0.697152E-01,0.242677E-02,0.244285E-02,0.243005E-02,0.242677E-02,
     &0.315960E-01,0.810432E-03,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.503850E+00,0.183581E+00,0.522815E-02,0.522815E-02,0.522815E-02,
     &0.522815E-02,0.142635E+00,0.123599E-16,0.479478E+00,0.172477E+00,
     &0.488093E-02,0.488328E-02,0.488147E-02,0.488093E-02,0.126767E+00,
     &0.124505E-03,0.455750E+00,0.161879E+00,0.455054E-02,0.455493E-02,
     &0.455153E-02,0.455054E-02,0.112695E+00,0.225968E-03,0.432681E+00,
     &0.151771E+00,0.423664E-02,0.424278E-02,0.423800E-02,0.423664E-02,
     &0.100212E+00,0.307702E-03,0.410286E+00,0.142140E+00,0.393907E-02,
     &0.394671E-02,0.394073E-02,0.393907E-02,0.891488E-01,0.372395E-03,
     &0.388577E+00,0.132974E+00,0.365743E-02,0.366634E-02,0.365934E-02/
      DATA (DL(K),K= 2126, 2210) /
     &0.365743E-02,0.793490E-01,0.422302E-03,0.367563E+00,0.124259E+00,
     &0.339138E-02,0.340133E-02,0.339347E-02,0.339138E-02,0.706688E-01,
     &0.459484E-03,0.347256E+00,0.115984E+00,0.314049E-02,0.315129E-02,
     &0.314273E-02,0.314049E-02,0.629792E-01,0.485762E-03,0.327660E+00,
     &0.108136E+00,0.290433E-02,0.291580E-02,0.290667E-02,0.290433E-02,
     &0.561642E-01,0.502744E-03,0.308782E+00,0.100701E+00,0.268243E-02,
     &0.269440E-02,0.268483E-02,0.268243E-02,0.501207E-01,0.511853E-03,
     &0.290625E+00,0.936693E-01,0.247429E-02,0.248663E-02,0.247672E-02,
     &0.247429E-02,0.447569E-01,0.514346E-03,0.273189E+00,0.870261E-01,
     &0.227939E-02,0.229197E-02,0.228184E-02,0.227939E-02,0.399920E-01,
     &0.511328E-03,0.256475E+00,0.807592E-01,0.209722E-02,0.210991E-02,
     &0.209965E-02,0.209722E-02,0.357547E-01,0.503769E-03,0.240478E+00,
     &0.748555E-01,0.192721E-02,0.193992E-02,0.192961E-02,0.192721E-02,
     &0.319825E-01,0.492518E-03,0.225194E+00,0.693019E-01,0.176883E-02,
     &0.178147E-02,0.177117E-02,0.176883E-02,0.286209E-01,0.478318E-03,
     &0.210615E+00,0.640851E-01,0.162151E-02,0.163400E-02,0.162379E-02,
     &0.162151E-02,0.256219E-01,0.461813E-03,0.196733E+00,0.591917E-01/
      DATA (DL(K),K= 2211, 2295) /
     &0.148471E-02,0.149698E-02,0.148691E-02,0.148471E-02,0.229436E-01,
     &0.443561E-03,0.183536E+00,0.546085E-01,0.135786E-02,0.136986E-02,
     &0.135998E-02,0.135786E-02,0.205496E-01,0.424043E-03,0.171011E+00,
     &0.503219E-01,0.124042E-02,0.125211E-02,0.124246E-02,0.124042E-02,
     &0.184079E-01,0.403672E-03,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.450310E+00,0.149685E+00,0.302765E-02,0.302765E-02,0.302765E-02,
     &0.302765E-02,0.901099E-01,-.108420E-17,0.425282E+00,0.139479E+00,
     &0.279499E-02,0.279691E-02,0.279537E-02,0.279499E-02,0.794239E-01,
     &0.632140E-04,0.401169E+00,0.129837E+00,0.257801E-02,0.258157E-02,
     &0.257870E-02,0.257801E-02,0.700941E-01,0.114711E-03,0.377966E+00,
     &0.120733E+00,0.237556E-02,0.238052E-02,0.237650E-02,0.237556E-02,
     &0.619270E-01,0.156107E-03,0.355668E+00,0.112145E+00,0.218688E-02,
     &0.219301E-02,0.218802E-02,0.218688E-02,0.547717E-01,0.188777E-03,
     &0.334269E+00,0.104052E+00,0.201113E-02,0.201823E-02,0.201243E-02,
     &0.201113E-02,0.484974E-01,0.213848E-03,0.313762E+00,0.964335E-01,
     &0.184758E-02,0.185546E-02,0.184900E-02,0.184758E-02,0.429879E-01/
      DATA (DL(K),K= 2296, 2380) /
     &0.232367E-03,0.294139E+00,0.892696E-01,0.169553E-02,0.170402E-02,
     &0.169703E-02,0.169553E-02,0.381432E-01,0.245270E-03,0.275389E+00,
     &0.825414E-01,0.155431E-02,0.156326E-02,0.155586E-02,0.155431E-02,
     &0.338762E-01,0.253383E-03,0.257502E+00,0.762303E-01,0.142329E-02,
     &0.143258E-02,0.142487E-02,0.142329E-02,0.301119E-01,0.257441E-03,
     &0.240464E+00,0.703180E-01,0.130188E-02,0.131138E-02,0.130347E-02,
     &0.130188E-02,0.267853E-01,0.258098E-03,0.224262E+00,0.647867E-01,
     &0.118950E-02,0.119912E-02,0.119108E-02,0.118950E-02,0.238409E-01,
     &0.255929E-03,0.208879E+00,0.596190E-01,0.108562E-02,0.109526E-02,
     &0.108717E-02,0.108562E-02,0.212308E-01,0.251442E-03,0.194298E+00,
     &0.547975E-01,0.989698E-03,0.999283E-03,0.991221E-03,0.989698E-03,
     &0.189136E-01,0.245082E-03,0.180499E+00,0.503054E-01,0.901248E-03,
     &0.910711E-03,0.902726E-03,0.901248E-03,0.168537E-01,0.237238E-03,
     &0.167463E+00,0.461263E-01,0.819789E-03,0.829074E-03,0.821215E-03,
     &0.819789E-03,0.150206E-01,0.228250E-03,0.155167E+00,0.422438E-01,
     &0.744866E-03,0.753925E-03,0.746234E-03,0.744866E-03,0.133878E-01,
     &0.218412E-03,0.143590E+00,0.386421E-01,0.676043E-03,0.684836E-03/
      DATA (DL(K),K= 2381, 2465) /
     &0.677349E-03,0.676043E-03,0.119320E-01,0.207976E-03,0.132706E+00,
     &0.353058E-01,0.612907E-03,0.621403E-03,0.614147E-03,0.612907E-03,
     &0.106334E-01,0.197159E-03,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.393307E+00,0.118409E+00,0.167124E-02,0.167124E-02,0.167124E-02,
     &0.167124E-02,0.547140E-01,0.433681E-17,0.368555E+00,0.109414E+00,
     &0.152547E-02,0.152705E-02,0.152573E-02,0.152547E-02,0.479708E-01,
     &0.303147E-04,0.344946E+00,0.101001E+00,0.139202E-02,0.139494E-02,
     &0.139249E-02,0.139202E-02,0.421517E-01,0.552185E-04,0.322450E+00,
     &0.931345E-01,0.126960E-02,0.127363E-02,0.127024E-02,0.126960E-02,
     &0.371043E-01,0.753524E-04,0.301043E+00,0.857854E-01,0.115731E-02,
     &0.116225E-02,0.115808E-02,0.115731E-02,0.327131E-01,0.913172E-04,
     &0.280698E+00,0.789267E-01,0.105427E-02,0.105995E-02,0.105514E-02,
     &0.105427E-02,0.288844E-01,0.103605E-03,0.261390E+00,0.725323E-01,
     &0.959726E-03,0.965979E-03,0.960659E-03,0.959726E-03,0.255366E-01,
     &0.112688E-03,0.243091E+00,0.665774E-01,0.872987E-03,0.879676E-03,
     &0.873966E-03,0.872987E-03,0.226017E-01,0.119000E-03,0.225775E+00/
      DATA (DL(K),K= 2466, 2550) /
     &0.610385E-01,0.793435E-03,0.800438E-03,0.794441E-03,0.793435E-03,
     &0.200219E-01,0.122931E-03,0.209414E+00,0.558928E-01,0.720508E-03,
     &0.727716E-03,0.721524E-03,0.720508E-03,0.177490E-01,0.124835E-03,
     &0.193979E+00,0.511187E-01,0.653691E-03,0.661011E-03,0.654703E-03,
     &0.653691E-03,0.157425E-01,0.125031E-03,0.179441E+00,0.466950E-01,
     &0.592513E-03,0.599863E-03,0.593511E-03,0.592513E-03,0.139674E-01,
     &0.123805E-03,0.165770E+00,0.426018E-01,0.536539E-03,0.543850E-03,
     &0.537513E-03,0.536539E-03,0.123945E-01,0.121411E-03,0.152935E+00,
     &0.388195E-01,0.485370E-03,0.492584E-03,0.486314E-03,0.485370E-03,
     &0.109993E-01,0.118076E-03,0.140905E+00,0.353295E-01,0.438636E-03,
     &0.445702E-03,0.439543E-03,0.438636E-03,0.976027E-02,0.113999E-03,
     &0.129648E+00,0.321137E-01,0.395992E-03,0.402871E-03,0.396859E-03,
     &0.395992E-03,0.865895E-02,0.109353E-03,0.119131E+00,0.291550E-01,
     &0.357120E-03,0.363779E-03,0.357945E-03,0.357120E-03,0.767960E-02,
     &0.104292E-03,0.109323E+00,0.264366E-01,0.321725E-03,0.328139E-03,
     &0.322505E-03,0.321725E-03,0.680866E-02,0.989468E-04,0.100191E+00,
     &0.239428E-01,0.289531E-03,0.295679E-03,0.290266E-03,0.289531E-03/
      DATA (DL(K),K= 2551, 2635) /
     &0.603390E-02,0.934295E-04,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.334851E+00,0.904666E-01,0.869706E-03,0.869706E-03,0.869706E-03,
     &0.869706E-03,0.316365E-01,-.311708E-17,0.311223E+00,0.828706E-01,
     &0.784673E-03,0.785968E-03,0.784847E-03,0.784673E-03,0.277037E-01,
     &0.134749E-04,0.288910E+00,0.758361E-01,0.708234E-03,0.710597E-03,
     &0.708543E-03,0.708234E-03,0.243298E-01,0.247881E-04,0.267855E+00,
     &0.693222E-01,0.639256E-03,0.642491E-03,0.639671E-03,0.639256E-03,
     &0.214125E-01,0.340882E-04,0.248015E+00,0.632964E-01,0.576953E-03,
     &0.580887E-03,0.577448E-03,0.576953E-03,0.188764E-01,0.415701E-04,
     &0.229343E+00,0.577274E-01,0.520615E-03,0.525096E-03,0.521167E-03,
     &0.520615E-03,0.166642E-01,0.474027E-04,0.211794E+00,0.525860E-01,
     &0.469624E-03,0.474520E-03,0.470215E-03,0.469624E-03,0.147265E-01,
     &0.517615E-04,0.195325E+00,0.478447E-01,0.423445E-03,0.428640E-03,
     &0.424060E-03,0.423445E-03,0.130234E-01,0.548213E-04,0.179891E+00,
     &0.434776E-01,0.381606E-03,0.387001E-03,0.382232E-03,0.381606E-03,
     &0.115226E-01,0.567474E-04,0.165449E+00,0.394601E-01,0.343691E-03/
      DATA (DL(K),K= 2636, 2720) /
     &0.349200E-03,0.344317E-03,0.343691E-03,0.101965E-01,0.576952E-04,
     &0.151958E+00,0.357691E-01,0.309329E-03,0.314879E-03,0.309948E-03,
     &0.309329E-03,0.902217E-02,0.578101E-04,0.139374E+00,0.323826E-01,
     &0.278192E-03,0.283721E-03,0.278796E-03,0.278192E-03,0.798131E-02,
     &0.572266E-04,0.127655E+00,0.292797E-01,0.249984E-03,0.255440E-03,
     &0.250569E-03,0.249984E-03,0.705796E-02,0.560672E-04,0.116760E+00,
     &0.264406E-01,0.224440E-03,0.229782E-03,0.225002E-03,0.224440E-03,
     &0.623793E-02,0.544420E-04,0.106647E+00,0.238467E-01,0.201321E-03,
     &0.206513E-03,0.201856E-03,0.201321E-03,0.550962E-02,0.524504E-04,
     &0.972762E-01,0.214802E-01,0.180411E-03,0.185425E-03,0.180918E-03,
     &0.180411E-03,0.486321E-02,0.501804E-04,0.886073E-01,0.193242E-01,
     &0.161512E-03,0.166328E-03,0.161990E-03,0.161512E-03,0.428946E-02,
     &0.477087E-04,0.806013E-01,0.173629E-01,0.144446E-03,0.149048E-03,
     &0.144894E-03,0.144446E-03,0.378030E-02,0.451020E-04,0.732197E-01,
     &0.155814E-01,0.129049E-03,0.133425E-03,0.129467E-03,0.129049E-03,
     &0.332897E-02,0.424179E-04,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K= 2721, 2805) /
     &0.276761E+00,0.663170E-01,0.420483E-03,0.420483E-03,0.420483E-03,
     &0.420483E-03,0.172075E-01,0.418773E-17,0.255003E+00,0.601925E-01,
     &0.374768E-03,0.375776E-03,0.374876E-03,0.374768E-03,0.151410E-01,
     &0.540038E-05,0.234664E+00,0.545789E-01,0.334420E-03,0.336252E-03,
     &0.334612E-03,0.334420E-03,0.133594E-01,0.101360E-04,0.215665E+00,
     &0.494328E-01,0.298611E-03,0.301108E-03,0.298867E-03,0.298611E-03,
     &0.118079E-01,0.141555E-04,0.197941E+00,0.447203E-01,0.266766E-03,
     &0.269787E-03,0.267068E-03,0.266766E-03,0.104461E-01,0.174750E-04,
     &0.181428E+00,0.404089E-01,0.238391E-03,0.241815E-03,0.238726E-03,
     &0.238391E-03,0.924609E-02,0.201244E-04,0.166064E+00,0.364687E-01,
     &0.213061E-03,0.216782E-03,0.213417E-03,0.213061E-03,0.818507E-02,
     &0.221467E-04,0.151790E+00,0.328719E-01,0.190418E-03,0.194343E-03,
     &0.190785E-03,0.190418E-03,0.724366E-02,0.235974E-04,0.138548E+00,
     &0.295925E-01,0.170150E-03,0.174202E-03,0.170521E-03,0.170150E-03,
     &0.640614E-02,0.245354E-04,0.126282E+00,0.266063E-01,0.151991E-03,
     &0.156104E-03,0.152359E-03,0.151991E-03,0.566089E-02,0.250221E-04,
     &0.114939E+00,0.238907E-01,0.135710E-03,0.139827E-03,0.136071E-03/
      DATA (DL(K),K= 2806, 2890) /
     &0.135710E-03,0.499773E-02,0.251191E-04,0.104465E+00,0.214245E-01,
     &0.121106E-03,0.125180E-03,0.121455E-03,0.121106E-03,0.440691E-02,
     &0.248850E-04,0.948101E-01,0.191879E-01,0.108002E-03,0.111994E-03,
     &0.108337E-03,0.108002E-03,0.388094E-02,0.243760E-04,0.859247E-01,
     &0.171625E-01,0.962435E-04,0.100124E-03,0.965624E-04,0.962435E-04,
     &0.341379E-02,0.236445E-04,0.777613E-01,0.153309E-01,0.856948E-04,
     &0.894394E-04,0.859960E-04,0.856948E-04,0.299910E-02,0.227378E-04,
     &0.702736E-01,0.136770E-01,0.762337E-04,0.798235E-04,0.765166E-04,
     &0.762337E-04,0.263116E-02,0.216984E-04,0.634174E-01,0.121859E-01,
     &0.677528E-04,0.711742E-04,0.680169E-04,0.677528E-04,0.230551E-02,
     &0.205642E-04,0.571500E-01,0.108434E-01,0.601554E-04,0.633990E-04,
     &0.604008E-04,0.601554E-04,0.201791E-02,0.193681E-04,0.514305E-01,
     &0.963651E-02,0.533545E-04,0.564148E-04,0.535814E-04,0.533545E-04,
     &0.176404E-02,0.181381E-04,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.220700E+00,0.461964E-01,0.185072E-03,0.185072E-03,0.185072E-03,
     &0.185072E-03,0.865568E-02,-.294090E-17,0.201438E+00,0.415162E-01/
      DATA (DL(K),K= 2891, 2975) /
     &0.162774E-03,0.163610E-03,0.162842E-03,0.162774E-03,0.772611E-02,
     &0.184134E-05,0.183625E+00,0.372730E-01,0.143469E-03,0.144974E-03,
     &0.143588E-03,0.143469E-03,0.690038E-02,0.359959E-05,0.167162E+00,
     &0.334245E-01,0.126634E-03,0.128666E-03,0.126791E-03,0.126634E-03,
     &0.616000E-02,0.518075E-05,0.151966E+00,0.299378E-01,0.111904E-03,
     &0.114340E-03,0.112088E-03,0.111904E-03,0.549219E-02,0.654232E-05,
     &0.137959E+00,0.267821E-01,0.989836E-04,0.101716E-03,0.991845E-04,
     &0.989836E-04,0.488896E-02,0.767008E-05,0.125065E+00,0.239289E-01,
     &0.876157E-04,0.905559E-04,0.878269E-04,0.876157E-04,0.434253E-02,
     &0.855860E-05,0.113213E+00,0.213524E-01,0.775899E-04,0.806611E-04,
     &0.778055E-04,0.775899E-04,0.384886E-02,0.921640E-05,0.102335E+00,
     &0.190285E-01,0.687292E-04,0.718676E-04,0.689446E-04,0.687292E-04,
     &0.340422E-02,0.965961E-05,0.923671E-01,0.169353E-01,0.608829E-04,
     &0.640353E-04,0.610944E-04,0.608829E-04,0.300332E-02,0.990752E-05,
     &0.832476E-01,0.150523E-01,0.539242E-04,0.570473E-04,0.541291E-04,
     &0.539242E-04,0.264288E-02,0.998320E-05,0.749179E-01,0.133608E-01,
     &0.477459E-04,0.508046E-04,0.479422E-04,0.477459E-04,0.232088E-02/
      DATA (DL(K),K= 2976, 3060) /
     &0.991147E-05,0.673221E-01,0.118435E-01,0.422554E-04,0.452220E-04,
     &0.424417E-04,0.422554E-04,0.203376E-02,0.971603E-05,0.604073E-01,
     &0.104845E-01,0.373730E-04,0.402263E-04,0.375483E-04,0.373730E-04,
     &0.177791E-02,0.941959E-05,0.541231E-01,0.926900E-02,0.330304E-04,
     &0.357544E-04,0.331943E-04,0.330304E-04,0.155117E-02,0.904408E-05,
     &0.484216E-01,0.818347E-02,0.291681E-04,0.317517E-04,0.293202E-04,
     &0.291681E-04,0.135108E-02,0.860921E-05,0.432578E-01,0.721549E-02,
     &0.257333E-04,0.281694E-04,0.258738E-04,0.257333E-04,0.117463E-02,
     &0.813214E-05,0.385889E-01,0.635362E-02,0.226802E-04,0.249648E-04,
     &0.228093E-04,0.226802E-04,0.101941E-02,0.762814E-05,0.343746E-01,
     &0.558739E-02,0.199682E-04,0.221003E-04,0.200863E-04,0.199682E-04,
     &0.883469E-03,0.711035E-05,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.168205E+00,0.301419E-01,0.719932E-04,0.719932E-04,0.719932E-04,
     &0.719932E-04,0.392825E-02,-.205998E-17,0.151922E+00,0.267932E-01,
     &0.623634E-04,0.630456E-04,0.624028E-04,0.623634E-04,0.361412E-02,
     &0.457084E-06,0.137042E+00,0.237932E-01,0.541981E-04,0.554098E-04/
      DATA (DL(K),K= 3061, 3145) /
     &0.542663E-04,0.541981E-04,0.330342E-02,0.989813E-06,0.123446E+00,
     &0.211038E-01,0.472163E-04,0.488314E-04,0.473050E-04,0.472163E-04,
     &0.300140E-02,0.152631E-05,0.111042E+00,0.186954E-01,0.412159E-04,
     &0.431273E-04,0.413184E-04,0.412159E-04,0.270826E-02,0.202092E-05,
     &0.997395E-01,0.165410E-01,0.360433E-04,0.381615E-04,0.361542E-04,
     &0.360433E-04,0.242968E-02,0.245400E-05,0.894558E-01,0.146159E-01,
     &0.315670E-04,0.338178E-04,0.316822E-04,0.315670E-04,0.216928E-02,
     &0.281218E-05,0.801130E-01,0.128978E-01,0.276779E-04,0.300002E-04,
     &0.277940E-04,0.276779E-04,0.192603E-02,0.308878E-05,0.716379E-01,
     &0.113663E-01,0.242878E-04,0.266317E-04,0.244024E-04,0.242878E-04,
     &0.170100E-02,0.328451E-05,0.639623E-01,0.100031E-01,0.213246E-04,
     &0.236502E-04,0.214357E-04,0.213246E-04,0.149649E-02,0.340483E-05,
     &0.570222E-01,0.879131E-02,0.187277E-04,0.210033E-04,0.188341E-04,
     &0.187277E-04,0.131163E-02,0.345656E-05,0.507574E-01,0.771565E-02,
     &0.164465E-04,0.186476E-04,0.165471E-04,0.164465E-04,0.114469E-02,
     &0.344782E-05,0.451118E-01,0.676223E-02,0.144396E-04,0.165480E-04,
     &0.145339E-04,0.144396E-04,0.995649E-03,0.338831E-05,0.400330E-01/
      DATA (DL(K),K= 3146, 3230) /
     &0.591841E-02,0.126720E-04,0.146744E-04,0.127597E-04,0.126720E-04,
     &0.863829E-03,0.328754E-05,0.354720E-01,0.517273E-02,0.111137E-04,
     &0.130013E-04,0.111946E-04,0.111137E-04,0.747293E-03,0.315403E-05,
     &0.313830E-01,0.451477E-02,0.973915E-05,0.115067E-04,0.981339E-05,
     &0.973915E-05,0.644664E-03,0.299600E-05,0.277237E-01,0.393511E-02,
     &0.852687E-05,0.101721E-04,0.859457E-05,0.852687E-05,0.555034E-03,
     &0.282099E-05,0.244545E-01,0.342521E-02,0.745784E-05,0.898076E-05,
     &0.751926E-05,0.745784E-05,0.476998E-03,0.263530E-05,0.215390E-01,
     &0.297737E-02,0.651555E-05,0.791817E-05,0.657100E-05,0.651555E-05,
     &0.409096E-03,0.244427E-05,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.120694E+00,0.180081E-01,0.236444E-04,0.236444E-04,0.236444E-04,
     &0.236444E-04,0.154817E-02,0.416656E-17,0.107713E+00,0.158098E-01,
     &0.200945E-04,0.206098E-04,0.201146E-04,0.200945E-04,0.151249E-02,
     &0.192118E-07,0.960063E-01,0.138667E-01,0.171552E-04,0.180593E-04,
     &0.171894E-04,0.171552E-04,0.143574E-02,0.116516E-06,0.854477E-01,
     &0.121473E-01,0.146986E-04,0.158894E-04,0.147425E-04,0.146986E-04/
      DATA (DL(K),K= 3231, 3315) /
     &0.133744E-02,0.251060E-06,0.759386E-01,0.106275E-01,0.126329E-04,
     &0.140252E-04,0.126830E-04,0.126329E-04,0.122900E-02,0.395272E-06,
     &0.673865E-01,0.928577E-02,0.108901E-04,0.124142E-04,0.109436E-04,
     &0.108901E-04,0.111367E-02,0.535145E-06,0.597062E-01,0.810254E-02,
     &0.941160E-05,0.110108E-04,0.946648E-05,0.941160E-05,0.996785E-03,
     &0.659421E-06,0.528194E-01,0.706039E-02,0.815165E-05,0.978016E-05,
     &0.820627E-05,0.815165E-05,0.885152E-03,0.762600E-06,0.466540E-01,
     &0.614371E-02,0.707299E-05,0.869464E-05,0.712616E-05,0.707299E-05,
     &0.780484E-03,0.842072E-06,0.411433E-01,0.533850E-02,0.614470E-05,
     &0.773135E-05,0.619559E-05,0.614470E-05,0.682563E-03,0.896683E-06,
     &0.362261E-01,0.463223E-02,0.534297E-05,0.687330E-05,0.539102E-05,
     &0.534297E-05,0.593317E-03,0.928176E-06,0.318459E-01,0.401364E-02,
     &0.464848E-05,0.610690E-05,0.469333E-05,0.464848E-05,0.513720E-03,
     &0.939174E-06,0.279510E-01,0.347266E-02,0.404483E-05,0.542054E-05,
     &0.408628E-05,0.404483E-05,0.442713E-03,0.932117E-06,0.244935E-01,
     &0.300029E-02,0.351893E-05,0.480507E-05,0.355692E-05,0.351893E-05,
     &0.379744E-03,0.910085E-06,0.214299E-01,0.258845E-02,0.306021E-05/
      DATA (DL(K),K= 3316, 3400) /
     &0.425313E-05,0.309476E-05,0.306021E-05,0.324785E-03,0.876365E-06,
     &0.187200E-01,0.222996E-02,0.265958E-05,0.375823E-05,0.269081E-05,
     &0.265958E-05,0.277080E-03,0.833755E-06,0.163273E-01,0.191840E-02,
     &0.230942E-05,0.331477E-05,0.233747E-05,0.230942E-05,0.235661E-03,
     &0.784780E-06,0.142185E-01,0.164805E-02,0.200337E-05,0.291797E-05,
     &0.202844E-05,0.200337E-05,0.199949E-03,0.731774E-06,0.123631E-01,
     &0.141382E-02,0.173596E-05,0.256351E-05,0.175824E-05,0.173596E-05,
     &0.169376E-03,0.676674E-06,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.794823E-01,0.948208E-02,0.607312E-05,0.607312E-05,0.607312E-05,
     &0.607312E-05,0.497062E-03,-.140523E-17,0.699344E-01,0.820355E-02,
     &0.500852E-05,0.538347E-05,0.501731E-05,0.500852E-05,0.542262E-03,
     &-.714686E-07,0.614560E-01,0.709106E-02,0.415227E-05,0.479898E-05,
     &0.416702E-05,0.415227E-05,0.549985E-03,-.960102E-07,0.539240E-01,
     &0.612155E-02,0.345977E-05,0.429563E-05,0.347839E-05,0.345977E-05,
     &0.531288E-03,-.894946E-07,0.472426E-01,0.527757E-02,0.289508E-05,
     &0.385164E-05,0.291595E-05,0.289508E-05,0.495120E-03,-.668594E-07/
      DATA (DL(K),K= 3401, 3485) /
     &0.413245E-01,0.454380E-02,0.243524E-05,0.345851E-05,0.245713E-05,
     &0.243524E-05,0.452156E-03,-.338861E-07,0.360903E-01,0.390658E-02,
     &0.205923E-05,0.310726E-05,0.208123E-05,0.205923E-05,0.406686E-03,
     &0.329349E-08,0.314681E-01,0.335393E-02,0.174861E-05,0.278918E-05,
     &0.177007E-05,0.174861E-05,0.359402E-03,0.387747E-07,0.273932E-01,
     &0.287528E-02,0.149082E-05,0.250013E-05,0.151127E-05,0.149082E-05,
     &0.313779E-03,0.705560E-07,0.238068E-01,0.246132E-02,0.127582E-05,
     &0.223699E-05,0.129498E-05,0.127582E-05,0.272195E-03,0.975744E-07,
     &0.206558E-01,0.210383E-02,0.109488E-05,0.199657E-05,0.111257E-05,
     &0.109488E-05,0.234227E-03,0.118651E-06,0.178921E-01,0.179558E-02,
     &0.941584E-06,0.177694E-05,0.957733E-06,0.941584E-06,0.199907E-03,
     &0.133780E-06,0.154726E-01,0.153020E-02,0.811157E-06,0.157680E-05,
     &0.825743E-06,0.811157E-06,0.169849E-03,0.143581E-06,0.133582E-01,
     &0.130209E-02,0.699567E-06,0.139481E-05,0.712624E-06,0.699567E-06,
     &0.143794E-03,0.148591E-06,0.115137E-01,0.110634E-02,0.603631E-06,
     &0.122977E-05,0.615228E-06,0.603631E-06,0.121163E-03,0.149477E-06,
     &0.990774E-02,0.938615E-03,0.520920E-06,0.108072E-05,0.531148E-06/
      DATA (DL(K),K= 3486, 3570) /
     &0.520920E-06,0.101725E-03,0.147055E-06,0.851194E-02,0.795146E-03,
     &0.449441E-06,0.946634E-06,0.458405E-06,0.449441E-06,0.852238E-04,
     &0.142064E-06,0.730103E-02,0.672622E-03,0.387542E-06,0.826497E-06,
     &0.395353E-06,0.387542E-06,0.712290E-04,0.135149E-06,0.625244E-02,
     &0.568155E-03,0.333888E-06,0.719316E-06,0.340658E-06,0.333888E-06,
     &0.593824E-04,0.126902E-06,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.457819E-01,0.409492E-02,0.105702E-05,0.105702E-05,0.105702E-05,
     &0.105702E-05,0.115350E-03,0.265810E-18,0.395724E-01,0.347873E-02,
     &0.812397E-06,0.103880E-05,0.815187E-06,0.812397E-06,0.160406E-03,
     &-.555147E-07,0.341639E-01,0.295295E-02,0.627904E-06,0.987449E-06,
     &0.632305E-06,0.627904E-06,0.174490E-03,-.847266E-07,0.294481E-01,
     &0.250329E-02,0.490075E-06,0.920197E-06,0.495305E-06,0.490075E-06,
     &0.174490E-03,-.944763E-07,0.253423E-01,0.211912E-02,0.387225E-06,
     &0.845257E-06,0.392760E-06,0.387225E-06,0.167111E-03,-.916775E-07,
     &0.217735E-01,0.179138E-02,0.309989E-06,0.766697E-06,0.315473E-06,
     &0.309989E-06,0.152540E-03,-.819158E-07,0.186760E-01,0.151211E-02/
      DATA (DL(K),K= 3571, 3655) /
     &0.252109E-06,0.688927E-06,0.257316E-06,0.252109E-06,0.135295E-03,
     &-.682145E-07,0.159921E-01,0.127447E-02,0.208612E-06,0.614302E-06,
     &0.213410E-06,0.208612E-06,0.118648E-03,-.528734E-07,0.136704E-01,
     &0.107254E-02,0.175203E-06,0.543807E-06,0.179526E-06,0.175203E-06,
     &0.102484E-03,-.379748E-07,0.116656E-01,0.901214E-03,0.149064E-06,
     &0.478363E-06,0.152890E-06,0.149064E-06,0.871530E-04,-.245007E-07,
     &0.993760E-02,0.756074E-03,0.128274E-06,0.418496E-06,0.131610E-06,
     &0.128274E-06,0.735682E-04,-.128491E-07,0.845081E-02,0.633315E-03,
     &0.111313E-06,0.364260E-06,0.114187E-06,0.111313E-06,0.617706E-04,
     &-.327698E-08,0.717398E-02,0.529654E-03,0.971373E-07,0.315568E-06,
     &0.995871E-07,0.971373E-07,0.514764E-04,0.421954E-08,0.607950E-02,
     &0.442265E-03,0.850687E-07,0.272228E-06,0.871375E-07,0.850687E-07,
     &0.426580E-04,0.982709E-08,0.514311E-02,0.368716E-03,0.746164E-07,
     &0.233927E-06,0.763489E-07,0.746164E-07,0.352463E-04,0.137715E-07,
     &0.434349E-02,0.306920E-03,0.654439E-07,0.200291E-06,0.668838E-07,
     &0.654439E-07,0.290260E-04,0.163078E-07,0.366196E-02,0.255085E-03,
     &0.573307E-07,0.170932E-06,0.585192E-07,0.573307E-07,0.238196E-04/
      DATA (DL(K),K= 3656, 3740) /
     &0.177037E-07,0.308217E-02,0.211681E-03,0.501185E-07,0.145441E-06,
     &0.510931E-07,0.501185E-07,0.195033E-04,0.182028E-07,0.258987E-02,
     &0.175396E-03,0.436915E-07,0.123415E-06,0.444860E-07,0.436915E-07,
     &0.159423E-04,0.180204E-07,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.206951E-01,0.123383E-02,0.903693E-07,0.903693E-07,0.903693E-07,
     &0.903693E-07,0.147928E-04,0.131925E-18,0.174566E-01,0.102241E-02,
     &0.892028E-07,0.129792E-07,0.885875E-07,0.892028E-07,0.328931E-04,
     &0.168541E-07,0.147092E-01,0.846741E-03,0.841992E-07,-.346085E-07,
     &0.832249E-07,0.841992E-07,0.410825E-04,0.262547E-07,0.123736E-01,
     &0.700287E-03,0.769173E-07,-.620958E-07,0.757563E-07,0.769173E-07,
     &0.418512E-04,0.305542E-07,0.103910E-01,0.578275E-03,0.688622E-07,
     &-.753692E-07,0.676306E-07,0.688622E-07,0.392599E-04,0.318183E-07,
     &0.871109E-02,0.476815E-03,0.611778E-07,-.782788E-07,0.599557E-07,
     &0.611778E-07,0.356221E-04,0.316149E-07,0.728984E-02,0.392546E-03,
     &0.537256E-07,-.749101E-07,0.525642E-07,0.537256E-07,0.312295E-04,
     &0.301630E-07,0.608951E-02,0.322656E-03,0.466227E-07,-.678673E-07/
      DATA (DL(K),K= 3741, 3825) /
     &0.455521E-07,0.466227E-07,0.265816E-04,0.278681E-07,0.507758E-02,
     &0.264779E-03,0.400790E-07,-.588670E-07,0.391148E-07,0.400790E-07,
     &0.223044E-04,0.251720E-07,0.422604E-02,0.216927E-03,0.341205E-07,
     &-.492124E-07,0.332680E-07,0.341205E-07,0.185283E-04,0.222885E-07,
     &0.351082E-02,0.177427E-03,0.287480E-07,-.397442E-07,0.280058E-07,
     &0.287480E-07,0.152122E-04,0.193702E-07,0.291126E-02,0.144878E-03,
     &0.239699E-07,-.309608E-07,0.233320E-07,0.239699E-07,0.123840E-04,
     &0.165481E-07,0.240962E-02,0.118102E-03,0.197695E-07,-.231453E-07,
     &0.192276E-07,0.197695E-07,0.100316E-04,0.139043E-07,0.199075E-02,
     &0.961132E-04,0.161186E-07,-.164194E-07,0.156628E-07,0.161186E-07,
     &0.808648E-05,0.114903E-07,0.164168E-02,0.780880E-04,0.129826E-07,
     &-.107955E-07,0.126029E-07,0.129826E-07,0.648861E-05,0.933575E-08,
     &0.135135E-02,0.633381E-04,0.103192E-07,-.622051E-08,0.100055E-07,
     &0.103192E-07,0.519042E-05,0.744979E-08,0.111036E-02,0.512898E-04,
     &0.808255E-08,-.260101E-08,0.782557E-08,0.808255E-08,0.414192E-05,
     &0.582811E-08,0.910718E-03,0.414657E-04,0.622640E-08,0.177583E-09,
     &0.601750E-08,0.622640E-08,0.329729E-05,0.445766E-08,0.745657E-03/
      DATA (DL(K),K= 3826, 3910) /
     &0.334694E-04,0.470431E-08,0.223586E-08,0.453577E-08,0.470431E-08,
     &0.261981E-05,0.331859E-08,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,
     &0.519165E-02,0.154752E-03,0.135983E-08,0.135983E-08,0.135983E-08,
     &0.135983E-08,0.445189E-06,0.165858E-19,0.420352E-02,0.123002E-03,
     &-.202651E-07,0.730203E-07,-.200511E-07,-.202651E-07,0.358557E-05,
     &-.213089E-07,0.340143E-02,0.977718E-04,-.356451E-07,0.114908E-06,
     &-.353066E-07,-.356451E-07,0.384652E-05,-.364475E-07,0.274771E-02,
     &0.776124E-04,-.435588E-07,0.139200E-06,-.431556E-07,-.435588E-07,
     &0.404834E-05,-.441752E-07,0.221524E-02,0.614950E-04,-.471629E-07,
     &0.150069E-06,-.467352E-07,-.471629E-07,0.391615E-05,-.476355E-07,
     &0.178268E-02,0.486476E-04,-.477545E-07,0.151420E-06,-.473296E-07,
     &-.477545E-07,0.334100E-05,-.481163E-07,0.143185E-02,0.384202E-04,
     &-.462359E-07,0.146515E-06,-.458316E-07,-.462359E-07,0.275426E-05,
     &-.465126E-07,0.114781E-02,0.302894E-04,-.434031E-07,0.137587E-06,
     &-.430295E-07,-.434031E-07,0.226010E-05,-.436143E-07,0.918288E-03,
     &0.238367E-04,-.398089E-07,0.126321E-06,-.394715E-07,-.398089E-07/
      DATA (DL(K),K= 3911, 3995) /
     &0.180947E-05,-.399700E-07,0.733193E-03,0.187249E-04,-.358525E-07,
     &0.113940E-06,-.355529E-07,-.358525E-07,0.142045E-05,-.359751E-07,
     &0.584227E-03,0.146823E-04,-.318183E-07,0.101291E-06,-.315563E-07,
     &-.318183E-07,0.110919E-05,-.319115E-07,0.464586E-03,0.114914E-04,
     &-.278936E-07,0.889550E-07,-.276671E-07,-.278936E-07,0.860964E-06,
     &-.279643E-07,0.368700E-03,0.897731E-05,-.241972E-07,0.773096E-07,
     &-.240033E-07,-.241972E-07,0.662825E-06,-.242508E-07,0.292013E-03,
     &0.700034E-05,-.208001E-07,0.665779E-07,-.206356E-07,-.208001E-07,
     &0.508061E-06,-.208406E-07,0.230814E-03,0.544870E-05,-.177366E-07,
     &0.568734E-07,-.175982E-07,-.177366E-07,0.388493E-06,-.177672E-07,
     &0.182078E-03,0.423324E-05,-.150157E-07,0.482316E-07,-.149000E-07,
     &-.150157E-07,0.296111E-06,-.150387E-07,0.143349E-03,0.328297E-05,
     &-.126295E-07,0.406343E-07,-.125335E-07,-.126295E-07,0.225104E-06,
     &-.126468E-07,0.112639E-03,0.254145E-05,-.105595E-07,0.340280E-07,
     &-.104803E-07,-.105595E-07,0.170871E-06,-.105726E-07,0.883377E-04,
     &0.196395E-05,-.878062E-08,0.283380E-07,-.871555E-08,-.878062E-08,
     &0.129517E-06,-.879039E-08,0.000000E+00,0.000000E+00,0.000000E+00/
      DATA (DL(K),K= 3996, 4000) /
     &0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00,0.000000E+00/
C
      ANS = 0.
      IF (X.GT.0.9985) RETURN
      IF ( ((I.EQ.3).OR.(I.EQ.8)) .AND. (X.GT.0.95) ) RETURN
C
      IS  = S/DELTA+1
      IS1 = IS+1
      DO 1 L=1,25
         KL    = L+NDRV*25
         F1(L) = GF(I,IS,KL)
         F2(L) = GF(I,IS1,KL)
    1 CONTINUE
      A1 = DT_CKMTFF(X,F1)
      A2 = DT_CKMTFF(X,F2)
C      A1=ALOG(A1)
C      A2=ALOG(A2)
      S1  = (IS-1)*DELTA
      S2  = S1+DELTA
      ANS = A1*(S-S2)/(S1-S2)+A2*(S-S1)/(S2-S1)
C      ANS=EXP(ANS)
      RETURN
      END
C
CDECK  ID>, DT_CKMTFF
      FUNCTION DT_CKMTFF(X,FVL)
C**********************************************************************
C
C     LOGARITHMIC INTERPOLATOR - WATCH OUT FOR NEGATIVE
C     FUNCTIONS AND/OR X VALUES OUTSIDE THE RANGE 0 TO 1.
C     NOTE: DIMENSION OF FVL IS OVERWRITTEN BY VALUE USED
C     IN MAIN ROUTINE.
C
C**********************************************************************

      SAVE
      DIMENSION FVL(25),XGRID(25)
      DATA NX,XGRID/25,.001,.002,.004,.008,.016,.032,.064,.1,.15,
     *.2,.25,.3,.35,.4,.45,.5,.55,.6,.65,.7,.75,.8,.85,.9,.95/
C
      DT_CKMTFF=0.
      DO 1 I=1,NX
      IF(X.LT.XGRID(I)) GO TO 2
    1 CONTINUE
    2 I=I-1
      IF(I.EQ.0) THEN
         I=I+1
      ELSE IF(I.GT.23) THEN
         I=23
      ENDIF
      J=I+1
      K=J+1
      AXI=LOG(XGRID(I))
      BXI=LOG(1.-XGRID(I))
      AXJ=LOG(XGRID(J))
      BXJ=LOG(1.-XGRID(J))
      AXK=LOG(XGRID(K))
      BXK=LOG(1.-XGRID(K))
      FI=LOG(ABS(FVL(I)) +1.E-15)
      FJ=LOG(ABS(FVL(J)) +1.E-16)
      FK=LOG(ABS(FVL(K)) +1.E-17)
      DET=AXI*(BXJ-BXK)+AXJ*(BXK-BXI)+AXK*(BXI-BXJ)
      ALOGA=(FI*(AXJ*BXK-AXK*BXJ)+FJ*(AXK*BXI-AXI*BXK)+FK*(AXI*BXJ-AXJ*
     $ BXI))/DET
      ALPHA=(FI*(BXJ-BXK)+FJ*(BXK-BXI)+FK*(BXI-BXJ))/DET
      BETA=(FI*(AXK-AXJ)+FJ*(AXI-AXK)+FK*(AXJ-AXI))/DET
      IF(ABS(ALPHA).GT.99..OR.ABS(BETA).GT.99..OR.ABS(ALOGA).GT.99.)
     1RETURN
C      IF(ALPHA.GT.50..OR.BETA.GT.50.) THEN
C         WRITE(6,2001) X,FVL
C 2001    FORMAT(8E12.4)
C         WRITE(6,2001) ALPHA,BETA,ALOGA,DET
C      ENDIF
      DT_CKMTFF=EXP(ALOGA)*X**ALPHA*(1.-X)**BETA
      RETURN
      END
c
c===fluini=============================================================*
c
CDECK  ID>, DT_FLUINI
      SUBROUTINE DT_FLUINI

c***********************************************************************
c Initialisation of the nucleon-nucleon cross section fluctuation      *
c treatment. The original version by J. Ranft.                         *
c This version dated 21.04.95 is revised by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0)

      PARAMETER ( A     = 0.1D0,
     &            B     = 0.893D0,
     &            OM    = 1.1D0,
     &            N     = 6,
     &            DX    = 0.003D0)

c n-n cross section fluctuations
      PARAMETER (NBINS = 1000)
      COMMON /DTXSFL/ FLUIXX(NBINS),IFLUCT

      DIMENSION FLUSI(NBINS),FLUIX(NBINS)

      WRITE(ErrorOut,1000)
 1000 FORMAT(/,1X,'FLUINI:  HADRONIC CROSS SECTION FLUCTUATIONS ',
     &       'TREATED')

      FLUSU  = ZERO
      FLUSUU = ZERO

      DO 1 I=1,NBINS
         X        = DBLE(I)*DX
         FLUIX(I) = X
         FLUS     = ((X-B)/(OM*B))**N
         IF (FLUS.LE.20.0D0) THEN
            FLUSI(I) = (X/B)*EXP(-FLUS)/(X/B+A)
         ELSE
            FLUSI(I) = ZERO
         ENDIF
         FLUSU = FLUSU+FLUSI(I)
    1 CONTINUE
      DO 2 I=1,NBINS
         FLUSUU   = FLUSUU+FLUSI(I)/FLUSU
         FLUSI(I) = FLUSUU
    2 CONTINUE

C     WRITE(LOUT,1001)
C1001 FORMAT(1X,'FLUCTUATIONS')
C     CALL PLOT(FLUIX,FLUSI,1000,1,1000,0.0D0,0.06D0,0.0D0,0.01D0)

      DO 3 I=1,NBINS
         AF = DBLE(I)*0.001D0
         DO 4 J=1,NBINS
            IF (AF.LE.FLUSI(J)) THEN
               FLUIXX(I) = FLUIX(J)
               GOTO 5
            ENDIF
    4    CONTINUE
    5    CONTINUE
    3 CONTINUE
      FLUIXX(1)     = FLUIX(1)
      FLUIXX(NBINS) = FLUIX(NBINS)

      RETURN
      END
c
c===sigtab=============================================================*
c
CDECK  ID>, DT_SIGTBL
      SUBROUTINE DT_SIGTBL(JP,JT,PTOT,SIGE,MODE)

c***********************************************************************
c This version dated 18.11.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER (TINY10=1.0D-10,TINY2=1.0D-2,ZERO=0.0D0,DLARGE=1.0D10,
     &           OHALF=0.5D0,ONE=1.0D0)
      PARAMETER (PLO=0.01D0,PHI=20.0D0,NBINS=150)

      LOGICAL LINIT

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


      DIMENSION SIGEP(5,NBINS+1),SIGEN(5,NBINS+1),IDSIG(23)
      DATA IDSIG / 1, 0, 0, 0, 0, 0, 0, 2, 0, 0,
     &             0, 0, 3, 4, 0, 0, 0, 0, 0, 0,
     &             0, 0, 5/
      DATA LINIT /.FALSE./

c precalculation and tabulation of elastic cross sections
      IF (ABS(MODE).EQ.1) THEN
         IF (MODE.EQ.1)
     &      OPEN(LLOOK,FILE='OUTDATA0/SIGTAB.OUT',STATUS='UNKNOWN')
         PLABLX = LOG10(PLO)
         PLABHX = LOG10(PHI)
         DPLAB  = (PLABHX-PLABLX)/DBLE(NBINS)
         DO 1 I=1,NBINS+1
            PLAB = PLABLX+DBLE(I-1)*DPLAB
            PLAB = 10**PLAB
            DO 2 IPROJ=1,23
               IDX = IDSIG(IPROJ)
               IF (IDX.GT.0) THEN
C                 CALL DT_SIHNEL(IPROJ,1,PLAB,SIGEP(IDX,I))
C                 CALL DT_SIHNEL(IPROJ,8,PLAB,SIGEN(IDX,I))
                  DUMZER = ZERO
                  CALL DT_XSHN(IPROJ,1,PLAB,DUMZER,SIGTOT,SIGEP(IDX,I))
                  CALL DT_XSHN(IPROJ,8,PLAB,DUMZER,SIGTOT,SIGEN(IDX,I))
               ENDIF
    2       CONTINUE
            IF (MODE.EQ.1) THEN
               WRITE(LLOOK,1000) PLAB,(SIGEP(IDX,I),IDX=1,5),
     &                                (SIGEN(IDX,I),IDX=1,5)
 1000          FORMAT(F5.1,10F7.2)
            ENDIF
    1    CONTINUE
         IF (MODE.EQ.1) CLOSE(LLOOK)
         LINIT = .TRUE.
      ELSE
         SIGE = -ONE
         IF (LINIT.AND.(JP.LE.23).AND.(PTOT.GE.PLO)
     &                           .AND.(PTOT.LE.PHI) ) THEN
            IDX = IDSIG(JP)
            IF ( (IDX.GT.0).AND.((JT.EQ.1).OR.(JT.EQ.8)) ) THEN
               PLABX = LOG10(PTOT)
               IF (PLABX.LE.PLABLX) THEN
                  I1 = 1
                  I2 = 1
               ELSEIF (PLABX.GE.PLABHX) THEN
                  I1 = NBINS+1
                  I2 = NBINS+1
               ELSE
                  I1 = INT((PLABX-PLABLX)/DPLAB)+1
                  I2 = I1+1
               ENDIF
               PLAB1X = PLABLX+DBLE(I1-1)*DPLAB
               PLAB2X = PLABLX+DBLE(I2-1)*DPLAB
               PBIN   = PLAB2X-PLAB1X
               IF (PBIN.GT.TINY10) THEN
                  RATX = (PLABX-PLAB1X)/(PLAB2X-PLAB1X)
               ELSE
                  RATX = ZERO
               ENDIF
               IF (JT.EQ.1) THEN
                  SIG1 = SIGEP(IDX,I1)
                  SIG2 = SIGEP(IDX,I2)
               ELSE
                  SIG1 = SIGEN(IDX,I1)
                  SIG2 = SIGEN(IDX,I2)
               ENDIF
               SIGE = SIG1+RATX*(SIG2-SIG1)
            ENDIF
         ENDIF
      ENDIF

      RETURN
      END
c
c===xstabl=============================================================*
c
CDECK  ID>, DT_XSTABL
      SUBROUTINE DT_XSTABL(WHAT,IXSQEL,IRATIO)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY2=1.0D-2,ZERO=0.0D0,DLARGE=1.0D10,
     &           OHALF=0.5D0,ONE=1.0D0,TWO=2.0D0)
      LOGICAL LLAB,LELOG,LQLOG

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL


      DIMENSION WHAT(6)

      LLAB   = (WHAT(1).GT.ZERO).OR.(WHAT(2).GT.ZERO)
      ELO    = ABS(WHAT(1))
      EHI    = ABS(WHAT(2))
      IF (ELO.GT.EHI) ELO = EHI
      LELOG  = WHAT(3).LT.ZERO
      NEBINS = MAX(INT(ABS(WHAT(3))),1)
      DEBINS = (EHI-ELO)/DBLE(NEBINS)
      IF (LELOG) THEN
         AELO   = LOG10(ELO)
         AEHI   = LOG10(EHI)
         ADEBIN = (AEHI-AELO)/DBLE(NEBINS)
      ENDIF
      Q2LO   = WHAT(4)
      Q2HI   = WHAT(5)
      IF (Q2LO.GT.Q2HI) Q2LO = Q2HI
      LQLOG  = WHAT(6).LT.ZERO
      NQBINS = MAX(INT(ABS(WHAT(6))),1)
      DQBINS = (Q2HI-Q2LO)/DBLE(NQBINS)
      IF (LQLOG) THEN
         AQ2LO  = LOG10(Q2LO)
         AQ2HI  = LOG10(Q2HI)
         ADQBIN = (AQ2HI-AQ2LO)/DBLE(NQBINS)
      ENDIF

      IF ( ELO.EQ. EHI) NEBINS = 0
      IF (Q2LO.EQ.Q2HI) NQBINS = 0

      WRITE(ErrorOut,
     * 1000) ELO,EHI,LLAB,IXSQEL,Q2LO,Q2HI,IJPROJ,IP,IT
 1000 FORMAT(/,1X,'XSTABL:  E_LO  =',E10.3,' GEV  E_HI  =',E10.3,
     &       ' GEV     LAB = ',L1,'  QEL: ',I2,/,10X,'Q2_LO =',F10.5,
     &       ' GEV^2  Q2_HI =',F10.5,' GEV^2',/,10X,'ID_P = ',I2,
     &       '   A_P = ',I3,'   A_T = ',I3,/)

C     IF (IJPROJ.NE.7) THEN
         WRITE(ErrorOut,
     * '(1X,A,/)')'(E,STOT,SELA,SQEP,SQET,SQE2,SINE,SPROD)'
c normalize fractions of emulsion components
         IF (NCOMPO.GT.0) THEN
            SUMFRA = ZERO
            DO 10 I=1,NCOMPO
               SUMFRA = SUMFRA+EMUFRA(I)
   10       CONTINUE
            IF (SUMFRA.GT.ZERO) THEN
               DO 11 I=1,NCOMPO
                  EMUFRA(I) = EMUFRA(I)/SUMFRA
   11          CONTINUE
            ENDIF
         ENDIF
C     ELSE
C        WRITE(LOUT,'(1X,A,/)') '(Q2,E,STOT,ETOT,SIN,EIN,STOT0)'
C     ENDIF
      DO 1 I=1,NEBINS+1
         IF (LELOG) THEN
            E = 10**(AELO+DBLE(I-1)*ADEBIN)
         ELSE
            E = ELO+DBLE(I-1)*DEBINS
         ENDIF
         DO 2 J=1,NQBINS+1
            IF (LQLOG) THEN
               Q2 = 10**(AQ2LO+DBLE(J-1)*ADQBIN)
            ELSE
               Q2 = Q2LO+DBLE(J-1)*DQBINS
            ENDIF
c            IF (IJPROJ.NE.7) THEN
               IF (LLAB) THEN
                  PLAB = ZERO
                  ECM  = ZERO
                  CALL DT_LTINI(IJPROJ,1,E,PPN0,ECM,0)
               ELSE
                  ECM = E
               ENDIF
               XI  = ZERO
               Q2I = ZERO
               IF (IJPROJ.EQ.7) Q2I = Q2
               IF (NCOMPO.GT.0) THEN
                  DO 20 IC=1,NCOMPO
                     IIT = IEMUMA(IC)
                     CALL DT_XSGLAU(IP,IIT,IJPROJ,XI,Q2I,ECM,1,1,-IC)
   20             CONTINUE
               ELSE
                  CALL DT_XSGLAU(IP,IT,IJPROJ,XI,Q2I,ECM,1,1,-1)
C                 CALL AMPLIT(IP,IT,IJPROJ,XI,Q2I,ECM,1,1,1)
               ENDIF
               IF (NCOMPO.GT.0) THEN
                  XTOT = ZERO
                  ETOT = ZERO
                  XELA = ZERO
                  EELA = ZERO
                  XQEP = ZERO
                  EQEP = ZERO
                  XQET = ZERO
                  EQET = ZERO
                  XQE2 = ZERO
                  EQE2 = ZERO
                  XPRO = ZERO
                  EPRO = ZERO
                  XPRO1= ZERO
                  XDEL = ZERO
                  EDEL = ZERO
                  XDQE = ZERO
                  EDQE = ZERO
                  DO 21 IC=1,NCOMPO
                     XTOT = XTOT+EMUFRA(IC)*XSTOT(1,1,IC)
                     ETOT = ETOT+EMUFRA(IC)*XETOT(1,1,IC)**2
                     XELA = XELA+EMUFRA(IC)*XSELA(1,1,IC)
                     EELA = EELA+EMUFRA(IC)*XEELA(1,1,IC)**2
                     XQEP = XQEP+EMUFRA(IC)*XSQEP(1,1,IC)
                     EQEP = EQEP+EMUFRA(IC)*XEQEP(1,1,IC)**2
                     XQET = XQET+EMUFRA(IC)*XSQET(1,1,IC)
                     EQET = EQET+EMUFRA(IC)*XEQET(1,1,IC)**2
                     XQE2 = XQE2+EMUFRA(IC)*XSQE2(1,1,IC)
                     EQE2 = EQE2+EMUFRA(IC)*XEQE2(1,1,IC)**2
                     XPRO = XPRO+EMUFRA(IC)*XSPRO(1,1,IC)
                     EPRO = EPRO+EMUFRA(IC)*XEPRO(1,1,IC)**2
                     XDEL = XDEL+EMUFRA(IC)*XSDEL(1,1,IC)
                     EDEL = EDEL+EMUFRA(IC)*XEDEL(1,1,IC)**2
                     XDQE = XDQE+EMUFRA(IC)*XSDQE(1,1,IC)
                     EDQE = EDQE+EMUFRA(IC)*XEDQE(1,1,IC)**2
                     YPRO = XSTOT(1,1,IC)-XSELA(1,1,IC)
     &                     -XSQEP(1,1,IC)-XSQET(1,1,IC)
     &                     -XSQE2(1,1,IC)
                     XPRO1= XPRO1+EMUFRA(IC)*YPRO
   21             CONTINUE
                  ETOT = SQRT(ETOT)
                  EELA = SQRT(EELA)
                  EQEP = SQRT(EQEP)
                  EQET = SQRT(EQET)
                  EQE2 = SQRT(EQE2)
                  EPRO = SQRT(EPRO)
                  EDEL = SQRT(EDEL)
                  EDQE = SQRT(EDQE)
                  WRITE(ErrorOut,'(8E9.3)')
     &               E,XTOT,XELA,XQEP,XQET,XQE2,XPRO,XPRO1
C                 WRITE(LOUT,'(4E9.3)')
C    &               E,XDEL,XDQE,XDEL+XDQE
               ELSE
                  WRITE(ErrorOut,'(11E10.3)')
     &              E,
     &              XSTOT(1,1,1),XSELA(1,1,1),XSQEP(1,1,1),XSQET(1,1,1),
     &              XSQE2(1,1,1),XSPRO(1,1,1),
     &              XSTOT(1,1,1)-XSELA(1,1,1)-XSQEP(1,1,1)-XSQET(1,1,1)
     &             -XSQE2(1,1,1),XSDEL(1,1,1),XSDQE(1,1,1),
     &              XSDEL(1,1,1)+XSDQE(1,1,1)
C                 WRITE(LOUT,'(4E9.3)') E,XSDEL(1,1,1),XSDQE(1,1,1),
C    &                                    XSDEL(1,1,1)+XSDQE(1,1,1)
               ENDIF
c            ELSE
c               IF (LLAB) THEN
c                  IF (IT.GT.1) THEN
c                     IF (IXSQEL.EQ.0) THEN
cC                       CALL DT_SIGGA(IT,  Q2, E,ZERO,ZERO,
cC                       CALL DT_SIGGA(IT,   E,Q2,ZERO,ZERO,
c                        CALL DT_SIGGA(IT,ZERO,Q2,ZERO,E,
c     &                             STOT,ETOT,SIN,EIN,STOT0)
c                        IF (IRATIO.EQ.1) THEN
c                           CALL DT_SIGGP(  Q2, E,ZERO,ZERO,STGP,SIGP,SDGP)
cC                          CALL DT_SIGGP(   E,Q2,ZERO,ZERO,STGP,SIGP,SDGP)
cC                          CALL DT_SIGGP(ZERO,Q2,ZERO,E,STGP,SIGP,SDGP)
c*!! save cross sections
c                           STOTA = STOT
c                           ETOTA = ETOT
c                           STOTP = STGP
c*!!
c                           STOT  = STOT/(DBLE(IT)*STGP)
c                           SIN   =  SIN/(DBLE(IT)*SIGP)
c                           STOT0 = STGP
c                           ETOT  = ZERO
c                           EIN   = ZERO
c                        ENDIF
c                     ELSE
c                        WRITE(LOUT,*)
c     &                  ' XSTABL:  qel. xs. not implemented for nuclei'
c                        STOP
c                     ENDIF
c                  ELSE
c                     ETOT = ZERO
c                     EIN  = ZERO
c                     STOT0= ZERO
c                     IF (IXSQEL.EQ.0) THEN
c                        CALL DT_SIGGP(ZERO,Q2,ZERO,E,STOT,SIN,SDIR)
c                     ELSE
c                       SIN = ZERO
c                       CALL DT_SIGVEL(ZERO,Q2,ZERO,E,IXSQEL,STOT,SIN,STOT0)
c                     ENDIF
c                  ENDIF
c               ELSE
c                  IF (IT.GT.1) THEN
c                     IF (IXSQEL.EQ.0) THEN
c                        CALL DT_SIGGA(IT,ZERO,Q2,E,ZERO,
c     &                             STOT,ETOT,SIN,EIN,STOT0)
c                        IF (IRATIO.EQ.1) THEN
c                           CALL DT_SIGGP(ZERO,Q2,E,ZERO,STGP,SIGP,SDGP)
c*!! save cross sections
c                           STOTA = STOT
c                           ETOTA = ETOT
c                           STOTP = STGP
c*!!
c                           STOT  = STOT/(DBLE(IT)*STGP)
c                           SIN   =  SIN/(DBLE(IT)*SIGP)
c                           STOT0 = STGP
c                           ETOT  = ZERO
c                           EIN   = ZERO
c                        ENDIF
c                     ELSE
c                        WRITE(LOUT,*)
c     &                  ' XSTABL:  qel. xs. not implemented for nuclei'
c                        STOP
c                     ENDIF
c                  ELSE
c                     ETOT = ZERO
c                     EIN  = ZERO
c                     STOT0= ZERO
c                     IF (IXSQEL.EQ.0) THEN
c                        CALL DT_SIGGP(ZERO,Q2,E,ZERO,STOT,SIN,SDIR)
c                     ELSE
c                       SIN = ZERO
c                       CALL DT_SIGVEL(ZERO,Q2,E,ZERO,IXSQEL,STOT,SIN,STOT0)
c                     ENDIF
c                  ENDIF
c               ENDIF
cC              WRITE(LOUT,'(1X,7E10.3)')Q2,E,STOT,STOTA,ETOTA,STOTP,ZERO
cC              WRITE(LOUT,'(1X,7E10.3)')Q2,E,STOT,ETOT,SIN,EIN,SDIR
cC              WRITE(LOUT,'(1X,7E10.3)')Q2,E,STOT,ETOT,SIN,EIN,STOT0
c               WRITE(LOUT,'(1X,6E10.3)')Q2,E,STOT,ETOT,SIN,EIN
c            ENDIF
    2    CONTINUE
    1 CONTINUE

      RETURN
      END
c
c===testxs=============================================================*
c
CDECK  ID>, DT_TESTXS
      SUBROUTINE DT_TESTXS

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      DIMENSION XSTOT(26,2),XSELA(26,2)

      OPEN(10,FILE='TESTXS_PTOT.OUT',STATUS='UNKNOWN')
      OPEN(11,FILE='TESTXS_PELA.OUT',STATUS='UNKNOWN')
      OPEN(12,FILE='TESTXS_NTOT.OUT',STATUS='UNKNOWN')
      OPEN(13,FILE='TESTXS_NELA.OUT',STATUS='UNKNOWN')
      DUMECM = 0.0D0
      PLABL = 0.01D0
      PLABH = 10000.0D0
      NBINS = 120
      APLABL = LOG10(PLABL)
      APLABH = LOG10(PLABH)
      ADPLAB = (APLABH-APLABL)/DBLE(NBINS)
      DO 1 I=1,NBINS+1
         ADP = APLABL+DBLE(I-1)*ADPLAB
         P = 10.0D0**ADP
         DO 2 J=1,26
            CALL DT_XSHN(J,1,P,DUMECM,XSTOT(J,1),XSELA(J,1))
            CALL DT_XSHN(J,8,P,DUMECM,XSTOT(J,2),XSELA(J,2))
    2    CONTINUE
         WRITE(10,1000) P,(XSTOT(K,1),K=1,26)
         WRITE(11,1000) P,(XSELA(K,1),K=1,26)
         WRITE(12,1000) P,(XSTOT(K,2),K=1,26)
         WRITE(13,1000) P,(XSELA(K,2),K=1,26)
    1 CONTINUE
 1000 FORMAT(F8.3,26F9.3)

      RETURN
      END
c***********************************************************************
c                                                                      *
c  DTUNUC 2.0:   library routines                                      *
c                                   processed by S. Roesler, 6.5.95    *
c                                                                      *
c***********************************************************************
c
c     1) Handling of parton momenta
c          SUBROUTINE MASHEL
c          SUBROUTINE DFERMI
c
c     2) Handling of parton flavors and particle indices
c          INTEGER FUNCTION IPDG2B
c          INTEGER FUNCTION IB2PDG
c          INTEGER FUNCTION IQUARK
c          INTEGER FUNCTION IBJQUA
c          INTEGER FUNCTION ICIHAD
c          INTEGER FUNCTION IPDGHA
c          INTEGER FUNCTION MCHAD
c          SUBROUTINE FLAHAD
c
c     3) Energy-momentum and quantum number conservation check routines
c          SUBROUTINE EMC1
c          SUBROUTINE EMC2
c          SUBROUTINE EVTEMC
c          SUBROUTINE EVTFLC
c          SUBROUTINE EVTCHG
c
c     4) Transformations
c          SUBROUTINE LTINI
c          SUBROUTINE LTRANS
c          SUBROUTINE LTNUC
c          SUBROUTINE DALTRA
c          SUBROUTINE DTRAFO
c          SUBROUTINE STTRAN
c          SUBROUTINE MYTRAN
c          SUBROUTINE LT2LAO
c          SUBROUTINE LT2LAB
c
c     5) Sampling from distributions
c          INTEGER FUNCTION NPOISS
c          DOUBLE PRECISION FUNCTION SAMPXB
c          DOUBLE PRECISION FUNCTION SAMPEX
c          DOUBLE PRECISION FUNCTION SAMSQX
c          DOUBLE PRECISION FUNCTION BETREJ
c          DOUBLE PRECISION FUNCTION DGAMRN
c          DOUBLE PRECISION FUNCTION DBETAR
c          SUBROUTINE RANNOR
c          SUBROUTINE DPOLI
c          SUBROUTINE DSFECF
c          SUBROUTINE RACO
c
c     6) Special functions, algorithms and service routines
c          DOUBLE PRECISION FUNCTION YLAMB
c          SUBROUTINE SORT
c          SUBROUTINE SORT1
c          SUBROUTINE DT_XTIME
c
c     7) Random number generator package
c          DOUBLE PRECISION FUNCTION DT_RNDM
c          SUBROUTINE DT_RNDMST
c          SUBROUTINE DT_RNDMIN
c          SUBROUTINE DT_RNDMOU
c          SUBROUTINE DT_RNDMTE
c
c***********************************************************************
c                                                                      *
c                 1) Handling of parton momenta                        *
c                                                                      *
c***********************************************************************
c
c===mashel=============================================================*
c
CDECK  ID>, DT_MASHEL
      SUBROUTINE DT_MASHEL(PA1,PA2,XM1,XM2,P1,P2,IREJ)

c***********************************************************************
c                                                                      *
c    rescaling of momenta of two partons to put both                   *
c                                       on mass shell                  *
c                                                                      *
c    input:       PA1,PA2   input momentum vectors                     *
c                 XM1,2     desired masses of particles afterwards     *
c                 P1,P2     changed momentum vectors                   *
c                                                                      *
c The original version is written by R. Engel.                         *
c This version dated 12.12.94 is modified by S. Roesler.               *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ONE=1.0D0,ZERO=0.0D0)

      DIMENSION PA1(4),PA2(4),P1(4),P2(4)

      IREJ = 0

c Lorentz transformation into system CMS
      PX  = PA1(1)+PA2(1)
      PY  = PA1(2)+PA2(2)
      PZ  = PA1(3)+PA2(3)
      EE  = PA1(4)+PA2(4)
      XPTOT = SQRT(PX**2+PY**2+PZ**2)
      XMS   = (EE-XPTOT)*(EE+XPTOT)
      IF(XMS.LT.(XM1+XM2)**2) THEN
C        WRITE(LOUT,'(3E12.4)')XMS,XM1,XM2
         GOTO 9999
      ENDIF
      XMS = SQRT(XMS)
      BGX = PX/XMS
      BGY = PY/XMS
      BGZ = PZ/XMS
      GAM = EE/XMS
      CALL DT_DALTRA(GAM,-BGX,-BGY,-BGZ,PA1(1),PA1(2),PA1(3),
     &           PA1(4),PTOT1,P1(1),P1(2),P1(3),P1(4))
c rotation angles
      COD = P1(3)/PTOT1
C     SID = SQRT((ONE-COD)*(ONE+COD))
      PPT = SQRT(P1(1)**2+P1(2)**2)
      SID = PPT/PTOT1
      COF = ONE
      SIF = ZERO
      IF(PTOT1*SID.GT.TINY10) THEN
         COF   = P1(1)/(SID*PTOT1)
         SIF   = P1(2)/(SID*PTOT1)
         ANORF = SQRT(COF*COF+SIF*SIF)
         COF   = COF/ANORF
         SIF   = SIF/ANORF
      ENDIF
c new CM momentum and energies (for masses XM1,XM2)
      XM12 = SIGN(XM1**2,XM1)
      XM22 = SIGN(XM2**2,XM2)
      SS   = XMS**2
      PCMP = DT_YLAMB(SS,XM12,XM22)/(2.D0*XMS)
      EE1  = SQRT(XM12+PCMP**2)
      EE2  = XMS-EE1
c back rotation
      MODE = 1
      CALL DT_MYTRAN(MODE,ZERO,ZERO,PCMP,COD,SID,COF,SIF,XX,YY,ZZ)
      CALL DT_DALTRA(GAM,BGX,BGY,BGZ,XX,YY,ZZ,EE1,
     &            PTOT1,P1(1),P1(2),P1(3),P1(4))
      CALL DT_DALTRA(GAM,BGX,BGY,BGZ,-XX,-YY,-ZZ,EE2,
     &            PTOT2,P2(1),P2(2),P2(3),P2(4))
c check consistency
      DEL = XMS*0.0001D0
      IF (ABS(PX-P1(1)-P2(1)).GT.DEL) THEN
        IDEV = 1
      ELSEIF (ABS(PY-P1(2)-P2(2)).GT.DEL) THEN
        IDEV = 2
      ELSEIF (ABS(PZ-P1(3)-P2(3)).GT.DEL) THEN
        IDEV = 3
      ELSEIF (ABS(EE-P1(4)-P2(4)).GT.DEL) THEN
        IDEV = 4
      ELSE
        IDEV = 0
      ENDIF
      IF (IDEV.NE.0) THEN
         WRITE(ErrorOut,'(/1X,A,I3)')
     &      'MASHEL: INCONSISTENT TRANSFORMATION',IDEV
         WRITE(ErrorOut,
     * '(1X,A)') 'MASHEL: input momenta/masses:'
         WRITE(ErrorOut,'(1X,5E12.5)') (PA1(K),K=1,4),XM1
         WRITE(ErrorOut,'(1X,5E12.5)') (PA2(K),K=1,4),XM2
         WRITE(ErrorOut,'(1X,A)') 'MASHEL: output momenta:'
         WRITE(ErrorOut,'(5X,4E12.5)') (P1(K),K=1,4)
         WRITE(ErrorOut,'(5X,4E12.5)') (P2(K),K=1,4)
      ENDIF
      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===dfermi=============================================================*
c
CDECK  ID>, DT_DFERMI
      SUBROUTINE DT_DFERMI(GPART)

c***********************************************************************
c Find largest of three random numbers.                                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      DIMENSION G(3)

      DO 10 I=1,3
        G(I)=DT_RNDM(GPART)
   10 CONTINUE
      IF (G(3).LT.G(2)) GOTO 40
      IF (G(3).LT.G(1)) GOTO 30
      GPART = G(3)
   20 RETURN
   30 GPART = G(1)
      GOTO 20
   40 IF (G(2).LT.G(1)) GOTO 30
      GPART = G(2)
      GOTO 20

      END

c***********************************************************************
c                                                                      *
c         2) Handling of parton flavors and particle indices           *
c                                                                      *
c***********************************************************************
c
c===ipdg2b=============================================================*
c
CDECK  ID>, IDT_IPDG2B
      INTEGER FUNCTION IDT_IPDG2B(ID,NN,MODE)

c***********************************************************************
c                                                                      *
c     conversion of quark numbering scheme                             *
c                                                                      *
c     input:   PDG parton numbering                                    *
c              for diquarks:  NN number of the constituent quark       *
c                             (e.g. ID=2301,NN=1 -> ICONV2=1)          *
c                                                                      *
c     output:  BAMJET particle codes                                   *
c              1 u     7 a-u   (MODE=1)  -1 a-u   (MODE=2)             *
c              2 d     8 a-d             -2 a-d                        *
c              3 s     9 a-s             -3 a-s                        *
c              4 c    10 a-c             -4 a-c                        *
c                                                                      *
c This is a modified version of ICONV2 written by R. Engel.            *
c This version dated 13.12.94 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      IDA = ABS(ID)
c diquarks
      IF (IDA.GT.6) THEN
        KF  = 3
        IF (IDA.GE.1000) KF = 4
        IDA = IDA/(10**(KF-NN))
        IDA = MOD(IDA,10)
      ENDIF
c exchange up and dn quarks
      IF (IDA.EQ.1) THEN
        IDA = 2
      ELSEIF (IDA.EQ.2) THEN
        IDA = 1
      ENDIF
c antiquarks
      IF (ID.LT.0) THEN
         IF (MODE.EQ.1) THEN
            IDA = IDA+6
         ELSE
            IDA = -IDA
         ENDIF
      ENDIF
      IDT_IPDG2B = IDA

      RETURN
      END
c
c===ib2pdg=============================================================*
c
CDECK  ID>, IDT_IB2PDG
      INTEGER FUNCTION IDT_IB2PDG(ID1,ID2,MODE)

c***********************************************************************
c                                                                      *
c     conversion of quark numbering scheme                             *
c                                                                      *
c     input:   BAMJET particle codes                                   *
c              1 u     7 a-u   (MODE=1)  -1 a-u   (MODE=2)             *
c              2 d     8 a-d             -2 a-d                        *
c              3 s     9 a-s             -3 a-s                        *
c              4 c    10 a-c             -4 a-c                        *
c                                                                      *
c     output:  PDG parton numbering                                    *
c                                                                      *
c This version dated 13.12.94 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      DIMENSION IHKKQ(-6:6),IHKKQQ(-3:3,-3:3)
      DATA IHKKQ/-6,-5,-4,-3,-1,-2,0,2,1,3,4,5,6/
      DATA IHKKQQ/-3303,-3103,-3203,0,0,0,0, -3103,-1103,-2103,0,0,0,0,
     &-3203,-2103,-2203,0,0,0,0, 0,0,0,0,0,0,0, 0,0,0,0,2203,2103,3203,
     &0,0,0,0,2103,1103,3103, 0,0,0,0,3203,3103,3303/

      IDA = ID1
      IDB = ID2
      IF (MODE.EQ.1) THEN
         IF (ID1.GT.6) IDA = -(ID1-6)
         IF (ID2.GT.6) IDB = -(ID2-6)
      ENDIF
      IF (ID2.EQ.0) THEN
         IDT_IB2PDG = IHKKQ(IDA)
      ELSE
         IDT_IB2PDG = IHKKQQ(IDA,IDB)
      ENDIF

      RETURN
      END
c
c===ipdgqu=============================================================*
c
CDECK  ID>, IDT_IQUARK
      INTEGER FUNCTION IDT_IQUARK(K,IDBAMJ)

c***********************************************************************
c                                                                      *
c     quark contents according to PDG conventions                      *
c     (random selection in case of quark mixing)                       *
c                                                                      *
c     input:   IDBAMJ BAMJET particle code                             *
c              K      1..3   quark number                              *
c                                                                      *
c     output:  1   d  (anti --> neg.)                                  *
c              2   u                                                   *
c              3   s                                                   *
c              4   c                                                   *
c                                                                      *
c This version written by R. Engel.                                    *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      IQ = IDT_IBJQUA(K,IDBAMJ)
c quark-antiquark
      IF (IQ.GT.6) THEN
         IQ = 6-IQ
      ENDIF
c exchange of up and down
      IF (ABS(IQ).EQ.1) THEN
         IQ = SIGN(2,IQ)
      ELSEIF (ABS(IQ).EQ.2) THEN
         IQ = SIGN(1,IQ)
      ENDIF
      IDT_IQUARK = IQ

      RETURN
      END
c
c===ibamq==============================================================*
c
CDECK  ID>, IDT_IBJQUA
      INTEGER FUNCTION IDT_IBJQUA(K,IDBAMJ)

c***********************************************************************
c                                                                      *
c     quark contents according to BAMJET conventions                   *
c     (random selection in case of quark mixing)                       *
c                                                                      *
c     input:   IDBAMJ BAMJET particle code                             *
c              K      1..3   quark number                              *
c                                                                      *
c     output:  1   u      7   u bar                                    *
c              2   d      8   d bar                                    *
c              3   s      9   s bar                                    *
c              4   c     10   c bar                                    *
c                                                                      *
c This version written by R. Engel.                                    *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      DIMENSION ITAB(3,210)
      DATA ((ITAB(I,K),I=1,3),K=1,30) /
     &    1,  1,  2,   7,  7,  8,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   1,  2,  2,   7,  8,  8,
csr 10.1.94
C    &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   3,  8,  0,
c
     &    1,  8,  0,   2,  7,  0,   1,  9,  0,
csr 10.1.94
C    &    3,  7,  0,   0,  0,  0,   0,  0,  0,
     &    3,  7,  0,   3,  1,  2,   9,  7,  8,
csr 10.1.94
C    &    0,  0,  0,   2,  2,  3,   1,  1,  3,
     &    2,  9,  0,   2,  2,  3,   1,  1,  3,
c
     &    1,  2,  3, 201,202,  0,   2,  9,  0,
     &    3,  8,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0 /
      DATA ((ITAB(I,K),I=1,3),K=31,60) /
     &    3,  9,  0,   1,  8,  0, 203,204,  0,
     &    2,  7,  0,   0,  0,  0,   1,  9,  0,
     &    2,  9,  0,   3,  7,  0,   3,  8,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   1,  1,  1,   1,  1,  2,
     &    1,  2,  2,   2,  2,  2,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0 /
      DATA ((ITAB(I,K),I=1,3),K=61,90) /
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    7,  7,  7,   7,  7,  8,   7,  8,  8,
     &    8,  8,  8,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0 /
      DATA ((ITAB(I,K),I=1,3),K=91,120) /
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   3,  9,  0,
     &    1,  3,  3,   2,  3,  3,   7,  7,  9,
     &    7,  8,  9,   8,  8,  9,   7,  9,  9,
     &    8,  9,  9,   1,  1,  3,   1,  2,  3,
     &    2,  2,  3,   1,  3,  3,   2,  3,  3,
     &    3,  3,  3,   7,  7,  9,   7,  8,  9,
     &    8,  8,  9,   7,  9,  9,   8,  9,  9,
     &    9,  9,  9,   4,  7,  0,   4,  8,  0,
     &    2, 10,  0,   1, 10,  0,   4,  9,  0 /
      DATA ((ITAB(I,K),I=1,3),K=121,150) /
     &    3, 10,  0,   4, 10,  0,   4,  7,  0,
     &    4,  8,  0,   2, 10,  0,   1, 10,  0,
     &    4,  9,  0,   3, 10,  0,   4, 10,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   1,  2,  4,   1,  3,  4,
     &    2,  3,  4,   1,  1,  4,   0,  0,  0,
     &    2,  2,  4,   0,  0,  0,   0,  0,  0,
     &    3,  3,  4,   1,  4,  4,   2,  4,  4,
     &    3,  4,  4,   7,  8, 10,   7,  9, 10 /
      DATA ((ITAB(I,K),I=1,3),K=151,180) /
     &    8,  9, 10,   7,  7, 10,   0,  0,  0,
     &    8,  8, 10,   0,  0,  0,   0,  0,  0,
     &    9,  9, 10,   7, 10, 10,   8, 10, 10,
     &    9, 10, 10,   1,  1,  4,   1,  2,  4,
     &    2,  2,  4,   1,  3,  4,   2,  3,  4,
     &    3,  3,  4,   1,  4,  4,   2,  4,  4,
     &    3,  4,  4,   4,  4,  4,   7,  7, 10,
     &    7,  8, 10,   8,  8, 10,   7,  9, 10,
     &    8,  9, 10,   9,  9, 10,   7, 10, 10,
     &    8, 10, 10,   9, 10, 10,  10, 10, 10 /
      DATA ((ITAB(I,K),I=1,3),K=181,210) /
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   1,  7,  0,
     &    2,  8,  0,   1,  7,  0,   2,  8,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0,
     &    0,  0,  0,   0,  0,  0,   0,  0,  0 /
      DATA IDOLD /0/

      ONE = 1.0D0
      IF (ITAB(1,IDBAMJ).LE.200) THEN
         ID = ITAB(K,IDBAMJ)
      ELSE
         IF(IDOLD.NE.IDBAMJ) THEN
            IT = AINT((ITAB(2,IDBAMJ)-ITAB(1,IDBAMJ)+0.999999D0)*
     &           DT_RNDM(ONE)+ITAB(1,IDBAMJ))
        ELSE
           IDOLD = 0
        ENDIF
        ID = ITAB(K,IT)
      ENDIF
      IDOLD  = IDBAMJ
      IDT_IBJQUA = ID

      RETURN
      END
c
c===icihad=============================================================*
c
CDECK  ID>, IDT_ICIHAD
      INTEGER FUNCTION IDT_ICIHAD(MCIND)

c***********************************************************************
c Conversion of particle index PDG proposal --> BAMJET-index scheme    *
c This is a completely new version dated 25.10.95.                     *
c Renamed to be not in conflict with the modified PHOJET-version       *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c hadron index conversion (BAMJET <--> PDG)
      COMMON /DTHAIC/ IPDG2(2,7),IBAM2(2,7),IPDG3(2,22),IBAM3(2,22),
     &                IPDG4(2,29),IBAM4(2,29),IPDG5(2,19),IBAM5(2,19),
     &                IAMCIN(210)


      IDT_ICIHAD = 0
      KPDG   = ABS(MCIND)
      IF ((KPDG.EQ.0).OR.(KPDG.GT.70000)) RETURN
      IF (MCIND.LT.0) THEN
         JSIGN = 1
      ELSE
         JSIGN = 2
      ENDIF
      IF (KPDG.GE.10000) THEN
         DO 1 I=1,19
            IDT_ICIHAD = IBAM5(JSIGN,I)
            IF (IPDG5(JSIGN,I).EQ.MCIND) GOTO 5
            IDT_ICIHAD = 0
    1    CONTINUE
      ELSEIF (KPDG.GE.1000) THEN
         DO 2 I=1,29
            IDT_ICIHAD = IBAM4(JSIGN,I)
            IF (IPDG4(JSIGN,I).EQ.MCIND) GOTO 5
            IDT_ICIHAD = 0
    2    CONTINUE
      ELSEIF (KPDG.GE.100) THEN
         DO 3 I=1,22
            IDT_ICIHAD = IBAM3(JSIGN,I)
            IF (IPDG3(JSIGN,I).EQ.MCIND) GOTO 5
            IDT_ICIHAD = 0
    3    CONTINUE
      ELSEIF (KPDG.GE.10) THEN
         DO 4 I=1,7
            IDT_ICIHAD = IBAM2(JSIGN,I)
            IF (IPDG2(JSIGN,I).EQ.MCIND) GOTO 5
            IDT_ICIHAD = 0
    4    CONTINUE
      ENDIF
    5 CONTINUE

      RETURN
      END
c
c===ipdgha=============================================================*
c
CDECK  ID>, IDT_IPDGHA
      INTEGER FUNCTION IDT_IPDGHA(MCIND)

c***********************************************************************
c Conversion of particle index BAMJET-index scheme --> PDG proposal    *
c Adopted from the original by S. Roesler. This version dated 12.5.95  *
c Renamed to be not in conflict with the modified PHOJET-version       *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c hadron index conversion (BAMJET <--> PDG)
      COMMON /DTHAIC/ IPDG2(2,7),IBAM2(2,7),IPDG3(2,22),IBAM3(2,22),
     &                IPDG4(2,29),IBAM4(2,29),IPDG5(2,19),IBAM5(2,19),
     &                IAMCIN(210)


      IDT_IPDGHA = IAMCIN(MCIND)

      RETURN
      END
c
c===flahad=============================================================*
c
CDECK  ID>, DT_FLAHAD
      SUBROUTINE DT_FLAHAD(ID,IF1,IF2,IF3)

c***********************************************************************
c sampling of FLAvor composition for HADrons/photons                   *
c              ID         BAMJET-id of hadron                          *
c              IF1,2,3    flavor content                               *
c                         (u,d,s: 1,2,3;  au,ad,as: -1,-1,-3)          *
c Note:  -  u,d numbering as in BAMJET                                 *
c        -  ID .le. 30 !!                                              *
c This version dated 12.03.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c auxiliary common for reggeon exchange (DTUNUC 1.x)
      COMMON /DTQUAR/ IQECHR(-6:6),IQBCHR(-6:6),IQICHR(-6:6),
     &                IQSCHR(-6:6),IQCCHR(-6:6),IQUCHR(-6:6),
     &                IQTCHR(-6:6),MQUARK(3,39)


      DIMENSION JSEL(3,6)
      DATA JSEL/ 1,2,3,  2,3,1,  3,1,2,  1,3,2,   2,1,3,   3,2,1/

      ONE = 1.0D0
      IF (ID.EQ.7) THEN
c photon (charge dependent flavour sampling)
         K = INT(DT_RNDM(ONE)*6.D0+1.D0)
         IF (K.LE.4) THEN
            IF1 = 2
            IF2 = -2
         ELSE IF(K.EQ.5) THEN
            IF1 = 1
            IF2 = -1
         ELSE
            IF1 = 3
            IF2 = -3
         ENDIF
         IF(DT_RNDM(ONE).LT.0.5D0) THEN
            K   = IF1
            IF1 = IF2
            IF2 = K
         ENDIF
         IF3 = 0
      ELSE
c hadron
         IX  = INT(1.0D0+5.99999D0*DT_RNDM(ONE))
         IF1 = MQUARK(JSEL(1,IX),ID)
         IF2 = MQUARK(JSEL(2,IX),ID)
         IF3 = MQUARK(JSEL(3,IX),ID)
         IF ((IF1.EQ.0).AND.(IF3.NE.0)) THEN
            IF1 = IF3
            IF3 = 0
         ELSEIF ((IF2.EQ.0).AND.(IF3.NE.0)) THEN
            IF2 = IF3
            IF3 = 0
         ENDIF
      ENDIF

      RETURN
      END
c
c===mchad==============================================================*
c
CDECK  ID>, IDT_MCHAD
      INTEGER FUNCTION IDT_MCHAD(ITDTU)

c***********************************************************************
c Conversion of particle index BAMJET-index scheme --> HADRIN index s. *
c Adopted from the original by S. Roesler. This version dated 6.5.95   *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      DIMENSION ITRANS(210)
      DATA ITRANS / 1, 2, -1, -1, -1, -1, -1, 8, 9, -1, -1, 24, 13, 14,
     &15, 16, 8, 9, 25, 8, 1, 8, 23, 24, 25, -1, -1, -1, -1, -1, 23, 13,
     &23, 14, 23, 15, 24, 16, 25, 15, 24, 16, 25, 15, 24, 16, 25, 1, 8,
     &8, 8, 1, 1, 1, 8, 8, 1, 1, 8, 8, 1, 8, 1, 8, 1, 8, 2, 2, 9, 9, 2,
     &2, 9, 9, 2, 9, 1, 13, 23, 14, 1, 1, 8, 8, 1, 1, 23, 14, 1, 8, 1,
     &8, 1, 8, 23, 23, 8, 8, 2, 9, 9, 9, 9, 1, 8, 8, 8, 8, 8, 2, 9, 9,
     &9, 9, 9, 85*- 1,7*-1,1,8,-1/

      IDT_MCHAD = ITRANS(ITDTU)

      RETURN
      END

c***********************************************************************
c                                                                      *
c   3) Energy-momentum and quantum number conservation check routines  *
c                                                                      *
c***********************************************************************
c
c===emc1===============================================================*
c
CDECK  ID>, DT_EMC1
      SUBROUTINE DT_EMC1(PP1,PP2,PT1,PT2,MODE,IPOS,IREJ)

c***********************************************************************
c This version dated 15.12.94 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10)

      DIMENSION PP1(4),PP2(4),PT1(4),PT2(4)

      IREJ = 0

      IF ((MODE.EQ.0).OR.(ABS(MODE).GT.3))
     &   WRITE(ErrorOut,
     * '(1X,A,I6)')'EMC1: not supported MODE ',MODE

      IF ((MODE.GT.0).AND.(MODE.LT.3)) THEN
         IF (MODE.EQ.1) THEN
            CALL DT_EVTEMC(PP1(1),PP1(2),PP1(3),PP1(4),1,IDUM,IDUM)
         ELSEIF (MODE.EQ.2) THEN
            CALL DT_EVTEMC(PP1(1),PP1(2),PP1(3),PP1(4),2,IDUM,IDUM)
         ENDIF
         CALL DT_EVTEMC(PP2(1),PP2(2),PP2(3),PP2(4),2,IDUM,IDUM)
         CALL DT_EVTEMC(PT1(1),PT1(2),PT1(3),PT1(4),2,IDUM,IDUM)
         CALL DT_EVTEMC(PT2(1),PT2(2),PT2(3),PT2(4),2,IDUM,IDUM)
      ELSEIF (MODE.LT.0) THEN
         IF (MODE.EQ.-1) THEN
            CALL DT_EVTEMC(-PP1(1),-PP1(2),-PP1(3),-PP1(4),1,IDUM,IDUM)
         ELSEIF (MODE.EQ.-2) THEN
            CALL DT_EVTEMC(-PP1(1),-PP1(2),-PP1(3),-PP1(4),2,IDUM,IDUM)
         ENDIF
         CALL DT_EVTEMC(-PP2(1),-PP2(2),-PP2(3),-PP2(4),2,IDUM,IDUM)
         CALL DT_EVTEMC(-PT1(1),-PT1(2),-PT1(3),-PT1(4),2,IDUM,IDUM)
         CALL DT_EVTEMC(-PT2(1),-PT2(2),-PT2(3),-PT2(4),2,IDUM,IDUM)
      ENDIF

      IF (ABS(MODE).EQ.3) THEN
         CALL DT_EVTEMC(DUM,DUM,DUM,DUM,3,IPOS,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
      ENDIF
      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===emc2===============================================================*
c
CDECK  ID>, DT_EMC2
      SUBROUTINE DT_EMC2(IP1,IP2,IP3,IP4,IP5,MP,IN1,IN2,IN3,IN4,IN5,MN,
     &                                                MODE,IPOS,IREJ)

c***********************************************************************
c             MODE = 1   energy-momentum cons. check                   *
c                  = 2   flavor-cons. check                            *
c                  = 3   energy-momentum & flavor cons. check          *
c                  = 4   energy-momentum & charge cons. check          *
c                  = 5   energy-momentum & flavor & charge cons. check *
c This version dated 16.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ZERO=0.0D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)


      IREJ  = 0
      IREJ1 = 0
      IREJ2 = 0
      IREJ3 = 0

      IF ((MODE.EQ.1).OR.(MODE.EQ.3).OR.(MODE.EQ.4).OR.(MODE.EQ.5))
     &                CALL DT_EVTEMC(ZERO,ZERO,ZERO,ZERO,1,IDUM,IDUM)
      IF ((MODE.EQ.2).OR.(MODE.EQ.3).OR.(MODE.EQ.5))
     &                                CALL DT_EVTFLC(0,IDUM,1,IDUM,IDUM)
      IF ((MODE.EQ.4).OR.(MODE.EQ.5)) CALL DT_EVTCHG(IDUM,1,IDUM,IDUM)
      DO 1 I=1,NHKK
         IF ((ISTHKK(I).EQ.IP1).OR.(ISTHKK(I).EQ.IP2).OR.
     &       (ISTHKK(I).EQ.IP3).OR.(ISTHKK(I).EQ.IP4).OR.
     &       (ISTHKK(I).EQ.IP5))                          THEN
            IF ((MODE.EQ.1).OR.(MODE.EQ.3).OR.(MODE.EQ.4)
     &                                    .OR.(MODE.EQ.5))
     &      CALL DT_EVTEMC(PHKK(1,I),PHKK(2,I),PHKK(3,I),PHKK(4,I),
     &                                               2,IDUM,IDUM)
            IF ((MODE.EQ.2).OR.(MODE.EQ.3).OR.(MODE.EQ.5))
     &         CALL DT_EVTFLC(IDHKK(I),MP,2,IDUM,IDUM)
            IF ((MODE.EQ.4).OR.(MODE.EQ.5))
     &                            CALL DT_EVTCHG(IDHKK(I),2,IDUM,IDUM)
         ENDIF
         IF ((ISTHKK(I).EQ.IN1).OR.(ISTHKK(I).EQ.IN2).OR.
     &       (ISTHKK(I).EQ.IN3).OR.(ISTHKK(I).EQ.IN4).OR.
     &       (ISTHKK(I).EQ.IN5))                          THEN
            IF ((MODE.EQ.1).OR.(MODE.EQ.3).OR.(MODE.EQ.4)
     &                                    .OR.(MODE.EQ.5))
     &      CALL DT_EVTEMC(-PHKK(1,I),-PHKK(2,I),-PHKK(3,I),-PHKK(4,I),
     &                                                   2,IDUM,IDUM)
            IF ((MODE.EQ.2).OR.(MODE.EQ.3).OR.(MODE.EQ.5))
     &         CALL DT_EVTFLC(IDHKK(I),MN,-2,IDUM,IDUM)
            IF ((MODE.EQ.4).OR.(MODE.EQ.5))
     &                            CALL DT_EVTCHG(IDHKK(I),-2,IDUM,IDUM)
         ENDIF
    1 CONTINUE
      IF ((MODE.EQ.1).OR.(MODE.EQ.3).OR.(MODE.EQ.4).OR.(MODE.EQ.5))
     &   CALL DT_EVTEMC(DUM,DUM,DUM,DUM,5,IPOS,IREJ1)
      IF ((MODE.EQ.2).OR.(MODE.EQ.3).OR.(MODE.EQ.5))
     &   CALL DT_EVTFLC(0,IDUM,3,IPOS,IREJ2)
      IF ((MODE.EQ.4).OR.(MODE.EQ.5)) CALL DT_EVTCHG(IDUM,3,IPOS,IREJ3)
      IF ((IREJ1.NE.0).OR.(IREJ2.NE.0).OR.(IREJ3.NE.0)) GOTO 9999

      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===evtemc=============================================================*
c
CDECK  ID>, DT_EVTEMC
      SUBROUTINE DT_EVTEMC(PXIO,PYIO,PZIO,EIO,IMODE,IPOS,IREJ)

c***********************************************************************
c This version dated 13.12.94 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY1=1.0D-1,TINY2=1.0D-2,TINY4=1.0D-4,TINY10=1.0D-10,
     &           ZERO=0.0D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME


      IREJ = 0

      MODE = IMODE
      CHKLEV = TINY10
      IF (MODE.EQ.4) THEN
         CHKLEV = TINY2
         MODE   = 3
      ELSEIF (MODE.EQ.5) THEN
         CHKLEV = TINY1
         MODE   = 3
      ELSEIF (MODE.EQ.-1) THEN
         CHKLEV = EIO
         MODE   = 3
      ENDIF

      IF (ABS(MODE).EQ.3) THEN
         PXDEV = PX
         PYDEV = PY
         PZDEV = PZ
         EDEV  = E
         IF ((IFRAG(1).EQ.2).AND.(CHKLEV.LT.TINY4)) CHKLEV = TINY4
         IF ((ABS(PXDEV).GT.CHKLEV).OR.(ABS(PYDEV).GT.CHKLEV).OR.
     &       (ABS(PZDEV).GT.CHKLEV).OR.(ABS(EDEV).GT.CHKLEV)) THEN
            IF (IOULEV(2).GT.0) WRITE(ErrorOut,
     * '(1X,A,I4,A,I8,A,/,4G10.3)')
     &         'EVTEMC: ENERGY-MOMENTUM CONS. FAILURE AT POS. ',IPOS,
     &         '  EVENT  ',NEVHKK,
     &         ' ! ',PXDEV,PYDEV,PZDEV,EDEV
            PX   = 0.0D0
            PY   = 0.0D0
            PZ   = 0.0D0
            E    = 0.0D0
            GOTO 9999
         ENDIF
         PX   = 0.0D0
         PY   = 0.0D0
         PZ   = 0.0D0
         E    = 0.0D0
         RETURN
      ENDIF

      IF (MODE.EQ.1) THEN
         PX = 0.0D0
         PY = 0.0D0
         PZ = 0.0D0
         E  = 0.0D0
      ENDIF

      PX = PX+PXIO
      PY = PY+PYIO
      PZ = PZ+PZIO
      E  = E+EIO

      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===evtflc=============================================================*
c
CDECK  ID>, DT_EVTFLC
      SUBROUTINE DT_EVTFLC(ID,ID1,MODE,IPOS,IREJ)

c***********************************************************************
c Flavor conservation check.                                           *
c        ID       identity of particle                                 *
c        ID1 = 1  ID for q,aq,qq,aqaq in PDG-numbering scheme          *
c            = 2  ID for particle/resonance in BAMJET numbering scheme *
c            = 3  ID for particle/resonance in PDG    numbering scheme *
c        MODE = 1 initialization and add ID                            *
c             =-1 initialization and subtract ID                       *
c             = 2 add ID                                               *
c             =-2 subtract ID                                          *
c             = 3 check flavor cons.                                   *
c        IPOS     flag to give position of call of EVTFLC to output    *
c                 unit in case of violation                            *
c This version dated 10.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10)

      IREJ = 0

      IF (MODE.EQ.3) THEN
         IF (IFL.NE.0) THEN
            WRITE(ErrorOut,'(1X,A,I3,A,I3)')
     &         'EVTFLC: FLAVOR-CONSERVATION FAILURE AT POS. ',IPOS,
     &         ' !  IFL = ',IFL
            IFL = 0
            GOTO 9999
         ENDIF
         IFL = 0
         RETURN
      ENDIF

      IF (MODE.EQ.1) IFL = 0
      IF (ID.EQ.0)   RETURN

      IF (ID1.EQ.1) THEN
         IDD = ABS(ID)
         NQ  = 1
         IF ((IDD.GE.100).AND.(IDD.LT.1000)) NQ = 2
         IF (IDD.GE.1000) NQ = 3
         DO 1 I=1,NQ
            IFBAM = IDT_IPDG2B(ID,I,2)
            IF (ABS(IFBAM).EQ.1) THEN
               IFBAM = SIGN(2,IFBAM)
            ELSEIF (ABS(IFBAM).EQ.2) THEN
               IFBAM = SIGN(1,IFBAM)
            ENDIF
            IF (MODE.GT.0) THEN
               IFL = IFL+IFBAM
            ELSE
               IFL = IFL-IFBAM
            ENDIF
    1    CONTINUE
         RETURN
      ENDIF

      IDD = ID
      IF (ID1.EQ.3) IDD = IDT_ICIHAD(ID)
      IF ((ID1.EQ.2).OR.(ID1.EQ.3)) THEN
         DO 2 I=1,3
            IF (MODE.GT.0) THEN
               IFL = IFL+IDT_IQUARK(I,IDD)
            ELSE
               IFL = IFL-IDT_IQUARK(I,IDD)
            ENDIF
    2    CONTINUE
      ENDIF
      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===evtchg=============================================================*
c
CDECK  ID>, DT_EVTCHG
      SUBROUTINE DT_EVTCHG(ID,MODE,IPOS,IREJ)

c***********************************************************************
c Charge conservation check.                                           *
c        ID       identity of particle (PDG-numbering scheme)          *
c        MODE = 1 initialization                                       *
c             =-2 subtract ID-charge                                   *
c             = 2 add ID-charge                                        *
c             = 3 check charge cons.                                   *
c        IPOS     flag to give position of call of EVTCHG to output    *
c                 unit in case of violation                            *
c This version dated 10.01.95 is written by S. Roesler                 *
c Last change: s.r. 21.01.01                                           *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


      IREJ = 0

      IF (MODE.EQ.1) THEN
         ICH  = 0
         IBAR = 0
         RETURN
      ENDIF

      IF (MODE.EQ.3) THEN
         IF ((ICH.NE.0).OR.(IBAR.NE.0)) THEN
            WRITE(ErrorOut,'(1X,A,I3,A,2I3,A,I8)')
     &         'EVTCHG: CHARGE/BARYO.-CONS. FAILURE AT POS. ',IPOS,
     &         '! ICH/IBAR= ',ICH,IBAR,' EVENT ',NEVHKK
            ICH  = 0
            IBAR = 0
            GOTO 9999
         ENDIF
         ICH  = 0
         IBAR = 0
         RETURN
      ENDIF

      IF (ID.EQ.0)   RETURN

      IDD = IDT_ICIHAD(ID)
c modification 21.1.01: use intrinsic phojet-functions to determine charge
c and baryon number
C     IF (IDD.GT.0) THEN
C        IF (MODE.EQ.2) THEN
C           ICH  = ICH+IICH(IDD)
C           IBAR = IBAR+IIBAR(IDD)
C        ELSEIF (MODE.EQ.-2) THEN
C           ICH  = ICH-IICH(IDD)
C           IBAR = IBAR-IIBAR(IDD)
C        ENDIF
C     ELSE
C        WRITE(LOUT,'(1X,A,3I6)') 'EVTCHG: (IDD = 0 !), IDD,ID=',IDD,ID
C        CALL DT_EVTOUT(4)
C        STOP
C     ENDIF
      IF (MODE.EQ.2) THEN
         ICH  = ICH+IPHO_CHR3(ID,1)/3
         IBAR = IBAR+IPHO_BAR3(ID,1)/3
      ELSEIF (MODE.EQ.-2) THEN
         ICH  = ICH-IPHO_CHR3(ID,1)/3
         IBAR = IBAR-IPHO_BAR3(ID,1)/3
      ENDIF

      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END

c***********************************************************************
c                                                                      *
c                 4) Transformations                                   *
c                                                                      *
c***********************************************************************
c
c===ltini==============================================================*
c
CDECK  ID>, DT_LTINI
      SUBROUTINE DT_LTINI(IDPR,IDTA,EPN0,PPN0,ECM0,MODE)

c***********************************************************************
c Initializations of Lorentz-transformations, calculation of Lorentz-  *
c parameters.                                                          *
c This version dated 13.11.95 is written by  S. Roesler.               *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY3=1.0D-3,
     &           ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN


      Q2   = VIRT
      IDP  = IDPR
      IF (MCGENE.NE.3) THEN
c lepton-projectiles and PHOJET: initialize real photon instead
         IF ((IDPR.EQ. 3).OR.(IDPR.EQ. 4).OR.
     &       (IDPR.EQ.10).OR.(IDPR.EQ.11).OR.
     &       (IDPR.EQ. 5).OR.(IDPR.EQ. 6))   THEN
            IDP = 7
            Q2  = ZERO
         ENDIF
      ENDIF
      IDT  = IDTA
      EPN  = EPN0
      PPN  = PPN0
      ECM  = ECM0
      AMP  = AAM(IDP)-SQRT(ABS(Q2))
      AMT  = AAM(IDT)
      AMP2 = SIGN(AMP**2,AMP)
      AMT2 = AMT**2
      IF (ECM0.GT.ZERO) THEN
         EPN = (ECM**2-AMP2-AMT2)/(TWO*AMT)
         IF (AMP2.GT.ZERO) THEN
            PPN = SQRT((EPN+AMP)*(EPN-AMP))
         ELSE
            PPN = SQRT(EPN**2-AMP2)
         ENDIF
      ELSE
         IF ((EPN0.NE.ZERO).AND.(PPN0.EQ.ZERO)) THEN
            IF (IDP.EQ.7) EPN = ABS(EPN)
            IF (EPN.LT.ZERO) EPN = ABS(EPN)+AMP
            IF (AMP2.GT.ZERO) THEN
               PPN = SQRT((EPN+AMP)*(EPN-AMP))
            ELSE
               PPN = SQRT(EPN**2-AMP2)
            ENDIF
         ELSEIF ((PPN0.GT.ZERO).AND.(EPN0.EQ.ZERO)) THEN
            IF (AMP2.GT.ZERO) THEN
               EPN = PPN*SQRT(ONE+(AMP/PPN)**2)
            ELSE
               EPN = SQRT(PPN**2+AMP2)
            ENDIF
         ENDIF
         ECM = SQRT(AMP2+AMT2+TWO*AMT*EPN)
      ENDIF
      UMO   = ECM
      EPROJ = EPN
      PPROJ = PPN
      IF (AMP2.GT.ZERO) THEN
         ETARG = (ECM**2-AMP2-AMT2)/(TWO*AMP)
         PTARG = -SQRT((ETARG+AMT)*(ETARG-AMT))
      ELSE
         ETARG = TINY10
         PTARG = TINY10
      ENDIF
c photon-projectiles (get momentum in cm-frame for virtuality Q^2)
      IF (IDP.EQ.7) THEN
         PGAMM(1) = ZERO
         PGAMM(2) = ZERO
         AMGAM  = AMP
         AMGAM2 = AMP2
         IF (ECM0.GT.ZERO) THEN
            S = ECM0**2
         ELSE
            IF ((EPN0.NE.ZERO).AND.(PPN0.EQ.ZERO)) THEN
               S = AMGAM2+AMT2+TWO*AMT*ABS(EPN0)
            ELSEIF ((PPN0.GT.ZERO).AND.(EPN0.EQ.ZERO)) THEN
               S = AMGAM2+AMT2+TWO*AMT*SQRT(PPN0**2+AMGAM2)
            ENDIF
         ENDIF
         PGAMM(3) = SQRT( (S**2-TWO*AMGAM2*S-TWO*AMT2*S-TWO*AMGAM2*AMT2
     &                     +AMGAM2**2+AMT2**2)/(4.0D0*S) )
         PGAMM(4) = SQRT(AMGAM2+PGAMM(3)**2)
         IF (MODE.EQ.1) THEN
            PNUCL(1) = ZERO
            PNUCL(2) = ZERO
            PNUCL(3) = -PGAMM(3)
            PNUCL(4) = SQRT(S)-PGAMM(4)
         ENDIF
      ENDIF
      IF ((IDPR.EQ. 3).OR.(IDPR.EQ. 4).OR.
     &    (IDPR.EQ.10).OR.(IDPR.EQ.11))   THEN
         PLEPT0(1) = ZERO
         PLEPT0(2) = ZERO
c neglect lepton masses
C        AMLPT2   = AAM(IDPR)**2
         AMLPT2   = ZERO
c
         IF (ECM0.GT.ZERO) THEN
            S = ECM0**2
         ELSE
            IF ((EPN0.NE.ZERO).AND.(PPN0.EQ.ZERO)) THEN
               S = AMLPT2+AMT2+TWO*AMT*ABS(EPN0)
            ELSEIF ((PPN0.GT.ZERO).AND.(EPN0.EQ.ZERO)) THEN
               S = AMLPT2+AMT2+TWO*AMT*SQRT(PPN0**2+AMLPT2)
            ENDIF
         ENDIF
         PLEPT0(3) = SQRT( (S**2-TWO*AMLPT2*S-TWO*AMT2*S-TWO*AMLPT2*AMT2
     &                     +AMLPT2**2+AMT2**2)/(4.0D0*S) )
         PLEPT0(4) = SQRT(AMLPT2+PLEPT0(3)**2)
         PNUCL(1) = ZERO
         PNUCL(2) = ZERO
         PNUCL(3) = -PLEPT0(3)
         PNUCL(4) = SQRT(S)-PLEPT0(4)
      ENDIF
c Lorentz-parameter for transformation Lab. - projectile rest system
      IF ((IDP.EQ.7).OR.(AMP.LT.TINY10)) THEN
         GALAB = TINY10
         BGLAB = TINY10
         BLAB  = TINY10
      ELSE
         GALAB = EPROJ/AMP
         BGLAB = PPROJ/AMP
         BLAB  = BGLAB/GALAB
      ENDIF
c Lorentz-parameter for transf. proj. rest sys. - nucl.-nucl. cms.
      IF (IDP.EQ.7) THEN
         GACMS(1) = TINY10
         BGCMS(1) = TINY10
      ELSE
         GACMS(1) = (ETARG+AMP)/UMO
         BGCMS(1) = PTARG/UMO
      ENDIF
c Lorentz-parameter for transformation Lab. - nucl.-nucl. cms.
      GACMS(2) = (EPROJ+AMT)/UMO
      BGCMS(2) = PPROJ/UMO
      PPCM     = GACMS(2)*PPROJ-BGCMS(2)*EPROJ

      EPN0 = EPN
      PPN0 = PPN
      ECM0 = ECM

      RETURN
      END
c
c===ltrans=============================================================*
c
CDECK  ID>, DT_LTRANS
      SUBROUTINE DT_LTRANS(PXI,PYI,PZI,PEI,PXO,PYO,PZO,PEO,ID,MODE)

c***********************************************************************
c Lorentz-transformations.                                             *
c   MODE = 1(-1)    projectile rest syst.   --> Lab (back)             *
c        = 2(-2)    projectile rest syst.   --> nucl.-nucl.cms (back)  *
c        = 3(-3)    target rest syst. (=Lab)--> nucl.-nucl.cms (back)  *
c This version dated 01.11.95 is written by  S. Roesler.               *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY3=1.0D-3,ZERO=0.0D0,TWO=2.0D0)

      PARAMETER (SQTINF=1.0D+15)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


      PXO = PXI
      PYO = PYI
      CALL DT_LTNUC(PZI,PEI,PZO,PEO,MODE)

c check particle mass for consistency (numerical rounding errors)
      PO     = SQRT(PXO*PXO+PYO*PYO+PZO*PZO)
      AMO2   = (PEO-PO)*(PEO+PO)
      AMORQ2 = AAM(ID)**2
      AMDIF2 = ABS(AMO2-AMORQ2)
      IF ((AMDIF2.GT.TINY3).AND.(PEO.LT.SQTINF).AND.(PO.GT.ZERO)) THEN
         DELTA = (AMORQ2-AMO2)/(TWO*(PEO+PO))
         PEO   = PEO+DELTA
         PO1   = PO -DELTA
         PXO   = PXO*PO1/PO
         PYO   = PYO*PO1/PO
         PZO   = PZO*PO1/PO
C        WRITE(6,*) 'LTRANS corrected', AMDIF2,PZI,PEI,PZO,PEO,MODE,ID
      ENDIF

      RETURN
      END
c
c===ltnuc==============================================================*
c
CDECK  ID>, DT_LTNUC
      SUBROUTINE DT_LTNUC(PIN,EIN,POUT,EOUT,MODE)

c***********************************************************************
c Lorentz-transformations.                                             *
c   PIN        longitudnal momentum       (input)                      *
c   EIN        energy                     (input)                      *
c   POUT       transformed long. momentum (output)                     *
c   EOUT       transformed energy         (output)                     *
c   MODE = 1(-1)    projectile rest syst.   --> Lab (back)             *
c        = 2(-2)    projectile rest syst.   --> nucl.-nucl.cms (back)  *
c        = 3(-3)    target rest syst. (=Lab)--> nucl.-nucl.cms (back)  *
c This version dated 01.11.95 is written by  S. Roesler.               *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ


      BDUM1 = ZERO
      BDUM2 = ZERO
      PDUM1 = ZERO
      PDUM2 = ZERO
      IF (ABS(MODE).EQ.1) THEN
         BG = -SIGN(BGLAB,DBLE(MODE))
         CALL DT_DALTRA(GALAB,BDUM1,BDUM2,-BG,PDUM1,PDUM2,PIN,EIN,
     &                               DUM1,DUM2,DUM3,POUT,EOUT)
      ELSEIF (ABS(MODE).EQ.2) THEN
         BG = SIGN(BGCMS(1),DBLE(MODE))
         CALL DT_DALTRA(GACMS(1),BDUM1,BDUM2,BG,PDUM1,PDUM2,PIN,EIN,
     &                               DUM1,DUM2,DUM3,POUT,EOUT)
      ELSEIF (ABS(MODE).EQ.3) THEN
         BG = -SIGN(BGCMS(2),DBLE(MODE))
         CALL DT_DALTRA(GACMS(2),BDUM1,BDUM2,BG,PDUM1,PDUM2,PIN,EIN,
     &                               DUM1,DUM2,DUM3,POUT,EOUT)
      ELSE
         WRITE(ErrorOut,1000) MODE
 1000    FORMAT(1X,'LTNUC: NOT SUPPORTED MODE (MODE = ',I3,')')
         EOUT = EIN
         POUT = PIN
      ENDIF

      RETURN
      END
c
c===daltra=============================================================*
c
CDECK  ID>, DT_DALTRA
      SUBROUTINE DT_DALTRA(GA,BGX,BGY,BGZ,PCX,PCY,PCZ,EC,P,PX,PY,PZ,E)

c***********************************************************************
c Arbitrary Lorentz-transformation.                                    *
c Adopted from the original by S. Roesler. This version dated 15.01.95 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (ONE=1.0D0)

      EP = PCX*BGX+PCY*BGY+PCZ*BGZ
      PE = EP/(GA+ONE)+EC
      PX = PCX+BGX*PE
      PY = PCY+BGY*PE
      PZ = PCZ+BGZ*PE
      P  = SQRT(PX*PX+PY*PY+PZ*PZ)
      E  = GA*EC+EP

      RETURN
      END
c
c====dtrafo============================================================*
c
CDECK  ID>, DT_DTRAFO
      SUBROUTINE DT_DTRAFO(GAM,BGAM,CX,CY,CZ,COD,COF,SIF,P,ECM,
     &                                    PL,CXL,CYL,CZL,EL)

C     LORENTZ TRANSFORMATION INTO THE LAB - SYSTEM

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      IF (ABS(COD).GT.1.0D0) COD = SIGN(1.0D0,COD)
      SID  = SQRT(1.D0-COD*COD)
      PLX  = P*SID*COF
      PLY  = P*SID*SIF
      PCMZ = P*COD
      PLZ  = GAM*PCMZ+BGAM*ECM
      PL   = SQRT(PLX*PLX+PLY*PLY+PLZ*PLZ)
      EL   = GAM*ECM+BGAM*PCMZ
C     ROTATION INTO THE ORIGINAL DIRECTION
      COZ  = PLZ/PL
      SIZ  = SQRT(1.D0-COZ**2)
      CALL DT_STTRAN(CX,CY,CZ,COZ,SIZ,SIF,COF,CXL,CYL,CZL)

      RETURN
      END
c
c====sttran============================================================*
c
CDECK  ID>, DT_STTRAN
      SUBROUTINE DT_STTRAN(XO,YO,ZO,CDE,SDE,SFE,CFE,X,Y,Z)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      DATA ANGLSQ/1.D-30/
c***********************************************************************
c     VERSION BY                     J. RANFT                          *
c                                    LEIPZIG                           *
c                                                                      *
c     THIS IS A SUBROUTINE OF FLUKA TO GIVE NEW DIRECTION COSINES      *
c                                                                      *
c     INPUT VARIABLES:                                                 *
c        XO,YO,ZO = ORIGINAL DIRECTION COSINES                         *
c        CDE,SDE  = COSINE AND SINE OF THE POLAR (THETA)               *
c                   ANGLE OF "SCATTERING"                              *
c        SDE      = SINE OF THE POLAR (THETA) ANGLE OF "SCATTERING"    *
c        SFE,CFE  = SINE AND COSINE OF THE AZIMUTHAL (PHI) ANGLE       *
c                   OF "SCATTERING"                                    *
c                                                                      *
c     OUTPUT VARIABLES:                                                *
c        X,Y,Z     = NEW DIRECTION COSINES                             *
c                                                                      *
c     ROTATION OF COORDINATE SYSTEM (SEE CERN 64-47 )                  *
c***********************************************************************
c
c
c  Changed by A. Ferrari
c
c     IF (ABS(XO)-0.0001D0) 1,1,2
c   1 IF (ABS(YO)-0.0001D0) 3,3,2
c   3 CONTINUE
      A = XO**2 + YO**2
      IF ( A .LT. ANGLSQ ) THEN
         X=SDE*CFE
         Y=SDE*SFE
         Z=CDE*ZO
      ELSE
         XI=SDE*CFE
         YI=SDE*SFE
         ZI=CDE
         A=SQRT(A)
         X=-YO*XI/A-ZO*XO*YI/A+XO*ZI
         Y=XO*XI/A-ZO*YO*YI/A+YO*ZI
         Z=A*YI+ZO*ZI
      ENDIF

      RETURN
      END
c
c===mytran=============================================================*
c
CDECK  ID>, DT_MYTRAN
      SUBROUTINE DT_MYTRAN(IMODE,XO,YO,ZO,CDE,SDE,CFE,SFE,X,Y,Z)

c***********************************************************************
c This subroutine rotates the coordinate frame                         *
c    a) theta  around y                                                *
c    b) phi    around z      if IMODE = 1                              *
c                                                                      *
c     x'          cos(ph) -sin(ph) 0      cos(th)  0  sin(th)   x      *
c     y' = A B =  sin(ph) cos(ph)  0  .   0        1        0   y      *
c     z'          0       0        1     -sin(th)  0  cos(th)   z      *
c                                                                      *
c and vice versa if IMODE = 0.                                         *
c This version dated 5.4.94 is based on the original version DTRAN     *
c by J. Ranft and is written by S. Roesler.                            *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      IF (IMODE.EQ.1) THEN
         X= CDE*CFE*XO-SFE*YO+SDE*CFE*ZO
         Y= CDE*SFE*XO+CFE*YO+SDE*SFE*ZO
         Z=-SDE    *XO       +CDE    *ZO
      ELSE
         X= CDE*CFE*XO+CDE*SFE*YO-SDE*ZO
         Y= -SFE*XO+CFE*YO
         Z= SDE*CFE*XO+SDE*SFE*YO+CDE*ZO
      ENDIF
      RETURN
      END
c
c===lt2lab=============================================================*
c
CDECK  ID>, DT_LT2LAO
      SUBROUTINE DT_LT2LAO

c***********************************************************************
c Lorentz-transformation to lab-system. This subroutine scans DTEVT1   *
c for final state particles/fragments defined in nucleon-nucleon-cms   *
c and transforms them back to the lab.                                 *
c This version dated 16.11.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)


      NEND      = NHKK
      NPOINT(5) = NHKK+1
      IF ( (NPOINT(4).EQ.0).OR.(NEND.LT.NPOINT(4)) ) RETURN
      DO 1 I=NPOINT(4),NEND
C     DO 1 I=1,NEND
         IF ((ABS(ISTHKK(I)).EQ.1).OR.(ISTHKK(I).EQ.1000).OR.
     &                                (ISTHKK(I).EQ.1001)) THEN
            CALL DT_LTNUC(PHKK(3,I),PHKK(4,I),PZ,PE,-3)
            NOB = NOBAM(I)
            CALL DT_EVTPUT(ISTHKK(I),IDHKK(I),I,0,PHKK(1,I),PHKK(2,I),
     &                            PZ,PE,IDRES(I),IDXRES(I),IDCH(I))
            IF ((ISTHKK(I).EQ.1000).OR.(ISTHKK(I).EQ.1001)) THEN
               ISTHKK(I) = 3*ISTHKK(I)
               NOBAM(NHKK)  = NOB
            ELSE
               IF (ISTHKK(I).EQ.-1) NOBAM(NHKK)  = NOB
               ISTHKK(I) = SIGN(3,ISTHKK(I))
            ENDIF
            JDAHKK(1,I) = NHKK
         ENDIF
    1 CONTINUE

      RETURN
      END
c
c===lt2lab=============================================================*
c
CDECK  ID>, DT_LT2LAB
      SUBROUTINE DT_LT2LAB

c***********************************************************************
c Lorentz-transformation to lab-system. This subroutine scans DTEVT1   *
c for final state particles/fragments defined in nucleon-nucleon-cms   *
c and transforms them to the lab.                                      *
c This version dated 07.01.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)


      IF ( (NPOINT(4).EQ.0).OR.(NHKK.LT.NPOINT(4)) ) RETURN
      DO 1 I=NPOINT(4),NHKK
         IF ((ABS(ISTHKK(I)).EQ.1).OR.(ISTHKK(I).EQ.1000).OR.
     &                                (ISTHKK(I).EQ.1001)) THEN
            CALL DT_LTNUC(PHKK(3,I),PHKK(4,I),PZ,PE,-3)
            PHKK(3,I) = PZ
            PHKK(4,I) = PE
         ENDIF
    1 CONTINUE

      RETURN
      END

c***********************************************************************
c                                                                      *
c                 5) Sampling from distributions                       *
c                                                                      *
c***********************************************************************
c
c===npoiss=============================================================*
c
CDECK  ID>, IDT_NPOISS
      INTEGER FUNCTION IDT_NPOISS(AVN)

c***********************************************************************
c Sample according to Poisson distribution with Poisson parameter AVN. *
c The original version written by J. Ranft.                            *
c This version dated 11.1.95 is written by S. Roesler.                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      EXPAVN = EXP(-AVN)
      K = 1
      A = 1.0D0

   10 CONTINUE
      A = DT_RNDM(A)*A
      IF (A.GE.EXPAVN) THEN
         K = K+1
         GOTO 10
      ENDIF
      IDT_NPOISS = K-1

      RETURN
      END
c
c===sampxb=============================================================*
c
CDECK  ID>, DT_SAMPXB
      DOUBLE PRECISION FUNCTION DT_SAMPXB(X1,X2,B)

c***********************************************************************
c Sampling from f(x)=1./SQRT(X**2+B**2) between x1 and x2.             *
c Processed by S. Roesler, 6.5.95                                      *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (TWO=2.0D0)

      A1 = LOG(X1+SQRT(X1**2+B**2))
      A2 = LOG(X2+SQRT(X2**2+B**2))
      AN = A2-A1
      A  = AN*DT_RNDM(A1)+A1
      BB = EXP(A)
      DT_SAMPXB = (BB**2-B**2)/(TWO*BB)

      RETURN
      END
c
c===sampex=============================================================*
c
CDECK  ID>, DT_SAMPEX
      DOUBLE PRECISION FUNCTION DT_SAMPEX(X1,X2)

c***********************************************************************
c Sampling from f(x)=1./x between x1 and x2.                           *
c Processed by S. Roesler, 6.5.95                                      *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (ONE=1.0D0)

      R   = DT_RNDM(X1)
      AL1 = LOG(X1)
      AL2 = LOG(X2)
      DT_SAMPEX = EXP((ONE-R)*AL1+R*AL2)

      RETURN
      END
c
c===samsqx=============================================================*
c
CDECK  ID>, DT_SAMSQX
      DOUBLE PRECISION FUNCTION DT_SAMSQX(X1,X2)

c***********************************************************************
c Sampling from f(x)=1./x^0.5 between x1 and x2.                       *
c Processed by S. Roesler, 6.5.95                                      *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (ONE=1.0D0)

      R = DT_RNDM(X1)
      DT_SAMSQX = (R*SQRT(X2)+(ONE-R)*SQRT(X1))**2

      RETURN
      END
c
c===samplw=============================================================*
c
CDECK  ID>, DT_SAMPLW
      DOUBLE PRECISION FUNCTION DT_SAMPLW(XMIN,XMAX,B)

c***********************************************************************
c Sampling from f(x)=1/x^b between x_min and x_max.                    *
c S. Roesler, 18.4.98                                                  *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (ONE=1.0D0)

      R = DT_RNDM(B)
      IF (B.EQ.ONE) THEN
         DT_SAMPLW = EXP(R*LOG(XMAX)+(ONE-R)*LOG(XMIN))
      ELSE
         ONEMB  = ONE-B
         DT_SAMPLW = (R*XMAX**ONEMB+(ONE-R)*XMIN**ONEMB)**(ONE/ONEMB)
      ENDIF

      RETURN
      END
c
c===betrej=============================================================*
c
CDECK  ID>, DT_BETREJ
      DOUBLE PRECISION FUNCTION DT_BETREJ(GAM,ETA,XMIN,XMAX)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (ONE=1.0D0)

      IF (XMIN.GE.XMAX)THEN
cccc &&&&&&&&&&&&&&&&&& KK
cc         WRITE (6,500) XMIN,XMAX
      WRITE (0,500) XMIN,XMAX
cc  500    FORMAT(1X,'DT_BETREJ:  XMIN<XMAX EXECUTION STOPPED ',2F10.5)
  500    FORMAT(1X,'DT_BETREJ:  XMIN<XMAX EXECUTION forced ',2F10.5)
cc         STOP
ccc   &&&&&&&&&&&&&&&&& KK         
         XMAX = XMIN+1.d-8
ccc
      ENDIF

   10 CONTINUE
      XX     = XMIN+(XMAX-XMIN)*DT_RNDM(ETA)
      BETMAX = XMIN**(GAM-ONE)*(ONE-XMIN)**(ETA-ONE)
      YY     = BETMAX*DT_RNDM(XX)
      BETXX  = XX**(GAM-ONE)*(ONE-XX)**(ETA-ONE)
      IF (YY.GT.BETXX) GOTO 10
      DT_BETREJ = XX

      RETURN
      END
c
c===dgamrn=============================================================*
c
CDECK  ID>, DT_DGAMRN
      DOUBLE PRECISION FUNCTION DT_DGAMRN(ALAM,ETA)

c***********************************************************************
c Sampling from Gamma-distribution.                                    *
c       F(X) = ALAM**ETA*X**(ETA-1)*EXP(-ALAM*X) / GAM(ETA)            *
c Processed by S. Roesler, 6.5.95                                      *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (ZERO=0.0D0,TINY9=1.0D-9,ONE=1.0D0)

      NCOU = 0
      N    = INT(ETA)
      F    = ETA-DBLE(N)
      IF (F.EQ.ZERO) GOTO 20
   10 R = DT_RNDM(F)
      NCOU = NCOU+1
      IF (NCOU.GE.11) GOTO 20
      IF (R.LT.F/(F+2.71828D0)) GOTO 30
      YYY = LOG(DT_RNDM(R)+TINY9)/F
      IF (ABS(YYY).GT.50.0D0) GOTO 20
      Y = EXP(YYY)
      IF (LOG(DT_RNDM(Y)+TINY9).GT.-Y) GOTO 10
      GOTO 40
   20 Y = 0.0D0
      GOTO 50
   30 Y = ONE-LOG(DT_RNDM(Y)+TINY9)
      IF (DT_RNDM(R).GT.Y**(F-ONE)) GOTO 10
   40 IF (N.EQ.0) GOTO 70
   50 Z = 1.0D0
      DO 60 I = 1,N
   60 Z = Z*DT_RNDM(Z)
      Y = Y-LOG(Z+TINY9)
   70 DT_DGAMRN = Y/ALAM

      RETURN
      END
c
c===dbetar=============================================================*
c
CDECK  ID>, DT_DBETAR
      DOUBLE PRECISION FUNCTION DT_DBETAR(GAM,ETA)

c***********************************************************************
c Sampling from Beta -distribution between 0.0 and 1.0                 *
c  F(X)=X**(GAM-1.)*(1.-X)**(ETA-1)*GAMM(ETA+GAM)/(GAMM(GAM)*GAMM(ETA))*
c Processed by S. Roesler, 6.5.95                                      *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      Y = DT_DGAMRN(1.0D0,GAM)
      Z = DT_DGAMRN(1.0D0,ETA)
      DT_DBETAR = Y/(Y+Z)

      RETURN
      END
c
c===rannor=============================================================*
c
CDECK  ID>, DT_RANNOR
      SUBROUTINE DT_RANNOR(X,Y)

c***********************************************************************
c Sampling from Gaussian distribution.                                 *
c Processed by S. Roesler, 6.5.95                                      *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (TINY10=1.0D-10)

      CALL DT_DSFECF(SFE,CFE)
      V = MAX(TINY10,DT_RNDM(X))
      A = SQRT(-2.D0*LOG(V))
      X = A*SFE
      Y = A*CFE

      RETURN
      END
c
c===dpoli==============================================================*
c
CDECK  ID>, DT_DPOLI
      SUBROUTINE DT_DPOLI(CS,SI)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      U  = DT_RNDM(CS)
      CS = DT_RNDM(U)
      IF (U.LT.0.5D0) CS=-CS
      SI = SQRT(1.0D0-CS*CS+1.0D-10)

      RETURN
      END
c
c===dsfecf=============================================================*
c
CDECK  ID>, DT_DSFECF
      SUBROUTINE DT_DSFECF(SFE,CFE)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (TWO=2.0D0,ONE=1.0D0,OHALF=0.5D0,ZERO=0.0D0)

    1 CONTINUE
      X  = DT_RNDM(SFE)
      Y  = DT_RNDM(X)
      XX = X*X
      YY = Y*Y
      XY = XX+YY
      IF (XY.GT.ONE) GOTO 1
      CFE = (XX-YY)/XY
      SFE = TWO*X*Y/XY
      IF (DT_RNDM(X).LT.OHALF) SFE = -SFE
      RETURN
      END
c
c===raco===============================================================*
c
CDECK  ID>, DT_RACO
      SUBROUTINE DT_RACO(WX,WY,WZ)

c***********************************************************************
c Direction cosines of random uniform (isotropic) direction in three   *
c dimensional space                                                    *
c Processed by S. Roesler, 20.11.95                                    *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (TWO=2.0D0,ONE=1.0D0,OHALF=0.5D0,ZERO=0.0D0)

  10  CONTINUE
      X  = TWO*DT_RNDM(WX)-ONE
      Y  = DT_RNDM(X)
      X2 = X*X
      Y2 = Y*Y
      IF (X2+Y2.GT.ONE) GOTO 10

      CFE = (X2-Y2)/(X2+Y2)
      SFE = TWO*X*Y/(X2+Y2)
c z = 1/2 [ 1 + cos (theta) ]
      Z   = DT_RNDM(X)
c 1/2 sin (theta)
      WZ = SQRT(Z*(ONE-Z))
      WX = TWO*WZ*CFE
      WY = TWO*WZ*SFE
      WZ = TWO*Z-ONE

      RETURN
      END

c***********************************************************************
c                                                                      *
c           6) Special functions, algorithms and service routines      *
c                                                                      *
c***********************************************************************
c
c===ylamb==============================================================*
c
CDECK  ID>, DT_YLAMB
      DOUBLE PRECISION FUNCTION DT_YLAMB(X,Y,Z)

c***********************************************************************
c                                                                      *
c     auxiliary function for three particle decay mode                 *
c     (standard LAMBDA**(1/2) function)                                *
c                                                                      *
c Adopted from an original version written by R. Engel.                *
c This version dated 12.12.94 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      YZ   = Y-Z
      XLAM = X*X-2.D0*X*(Y+Z)+YZ*YZ
      IF (XLAM.LE.0.D0) XLAM = ABS(XLAM)
      DT_YLAMB = SQRT(XLAM)

      RETURN
      END
c
c===sort1==============================================================*
c
CDECK  ID>, DT_SORT
      SUBROUTINE DT_SORT(A,N,I0,I1,MODE)

c***********************************************************************
c This subroutine sorts entries in A in increasing/decreasing order    *
c of A(3,i).                                                           *
c              MODE  = 1     increasing in A(3,i=1..N)                 *
c                    = 2     decreasing in A(3,i=1..N)                 *
c This version dated 21.04.95 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      DIMENSION A(3,N)

      M = I1
   10 CONTINUE
      M = I1-1
      IF (M.LE.0) RETURN
      L = 0
      DO 20 I=I0,M
         J = I+1
         IF (MODE.EQ.1) THEN
            IF (A(3,I).LE.A(3,J)) GOTO 20
         ELSE
            IF (A(3,I).GE.A(3,J)) GOTO 20
         ENDIF
         B = A(3,I)
         C = A(1,I)
         D = A(2,I)
         A(3,I) = A(3,J)
         A(2,I) = A(2,J)
         A(1,I) = A(1,J)
         A(3,J) = B
         A(1,J) = C
         A(2,J) = D
         L = 1
   20 CONTINUE
      IF (L.EQ.1) GOTO 10

      RETURN
      END
c
c===sort1==============================================================*
c
CDECK  ID>, DT_SORT1
      SUBROUTINE DT_SORT1(A,IDX,N,I0,I1,MODE)

c***********************************************************************
c This subroutine sorts entries in A in increasing/decreasing order    *
c of A(i).                                                             *
c              MODE  = 1     increasing in A(i=1..N)                   *
c                    = 2     decreasing in A(i=1..N)                   *
c This version dated 21.04.95 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      DIMENSION A(N),IDX(N)

      M = I1
   10 CONTINUE
      M = I1-1
      IF (M.LE.0) RETURN
      L = 0
      DO 20 I=I0,M
         J = I+1
         IF (MODE.EQ.1) THEN
            IF (A(I).LE.A(J)) GOTO 20
         ELSE
            IF (A(I).GE.A(J)) GOTO 20
         ENDIF
         B    = A(I)
         A(I) = A(J)
         A(J) = B
         IX     = IDX(I)
         IDX(I) = IDX(J)
         IDX(J) = IX
         L = 1
   20 CONTINUE
      IF (L.EQ.1) GOTO 10

      RETURN
      END
c
c===xtime==============================================================*
c
CDECK  ID>, DT_XTIME
      SUBROUTINE DT_XTIME

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      CHARACTER DAT*9,TIM*11

      DAT = '         '
      TIM = '           '
C     CALL GETDAT(IYEAR,IMONTH,IDAY)
C     CALL GETTIM(IHOUR,IMINUT,ISECND,IHSCND)

C     CALL DATE(DAT)
C     CALL TIME(TIM)
C     WRITE(LOUT,1000) DAT,TIM
 1000 FORMAT(/,2X,'DATE: ',A9,3X,'TIME: ',A11,/)

      RETURN
      END

c***********************************************************************
c                                                                      *
c                 7) Random number generator package                   *
c                                                                      *
c    THIS IS A PACKAGE CONTAINING A RANDOM NUMBER GENERATOR AND        *
c    SERVICE ROUTINES.                                                 *
c    THE ALGORITHM IS FROM                                             *
c      'TOWARD A UNVERSAL RANDOM NUMBER GENERATOR'                     *
c      G.MARSAGLIA, A.ZAMAN ;  FSU-SCRI-87-50                          *
c    IMPLEMENTATION BY K. HAHN  DEC. 88,                               *
c    THIS GENERATOR SHOULD NOT DEPEND ON THE HARD WARE ( IF A REAL HAS *
c    AT LEAST 24 SIGNIFICANT BITS IN INTERNAL REPRESENTATION ),        *
c    THE PERIOD IS ABOUT 2**144,                                       *
c    TIME FOR ONE CALL AT IBM-XT IS ABOUT 0.7 MILLISECONDS,            *
c    THE PACKAGE CONTAINS                                              *
c      FUNCTION DT_RNDM(I)                  : GENERATOR                *
c      SUBROUTINE DT_RNDMST(NA1,NA2,NA3,NB4): INITIALIZATION           *
c      SUBROUTINE DT_RNDMIN(U,C,CD,CM,I,J)  : PUT SEED TO GENERATOR    *
c      SUBROUTINE DT_RNDMOU(U,C,CD,CM,I,J)  : TAKE SEED FROM GENERATOR *
c      SUBROUTINE DT_RNDMTE(IO)             : TEST OF GENERATOR        *
c---                                                                   *
c    FUNCTION DT_RNDM(I)                                               *
c       GIVES UNIFORMLY DISTRIBUTED RANDOM NUMBERS  IN (0..1)          *
c       I  - DUMMY VARIABLE, NOT USED                                  *
c    SUBROUTINE DT_RNDMST(NA1,NA2,NA3,NB1)                             *
c       INITIALIZES THE GENERATOR, MUST BE CALLED BEFORE USING DT_RNDM *
c       NA1,NA2,NA3,NB1  - VALUES FOR INITIALIZING THE GENERATOR       *
c                          NA? MUST BE IN 1..178 AND NOT ALL 1         *
c                          12,34,56  ARE THE STANDARD VALUES           *
c                          NB1 MUST BE IN 1..168                       *
c                          78  IS THE STANDARD VALUE                   *
c    SUBROUTINE DT_RNDMIN(U,C,CD,CM,I,J)                               *
c       PUTS SEED TO GENERATOR ( BRINGS GENERATOR IN THE SAME STATUS   *
c       AS AFTER THE LAST DT_RNDMOU CALL )                             *
c       U(97),C,CD,CM,I,J  - SEED VALUES AS TAKEN FROM DT_RNDMOU       *
c    SUBROUTINE DT_RNDMOU(U,C,CD,CM,I,J)                               *
c       TAKES SEED FROM GENERATOR                                      *
c       U(97),C,CD,CM,I,J  - SEED VALUES                               *
c    SUBROUTINE DT_RNDMTE(IO)                                          *
c       TEST OF THE GENERATOR                                          *
c       IO     - DEFINES OUTPUT                                        *
c                  = 0  OUTPUT ONLY IF AN ERROR IS DETECTED            *
c                  = 1  OUTPUT INDEPENDEND ON AN ERROR                 *
c       DT_RNDMTE USES DT_RNDMIN AND DT_RNDMOU TO BRING GENERATOR TO   *
c       SAME STATUS                                                    *
c       AS BEFORE CALL OF DT_RNDMTE                                    *
c***********************************************************************
c
c===rndm===============================================================*
c
CDECK  ID>, DT_RNDM
ccccc &&&&&&&&&&  KK
      DOUBLE PRECISION FUNCTION DT_RNDM(VDUMMY)
      real*8 VDUMMY
      real*8  u
      call rndc(u)
      DT_RNDM = u
      end
      DOUBLE PRECISION FUNCTION DT_RNDMNOrig(VDUMMY)
cccc  &&&&&&&&&
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c random number generator
      COMMON /DTRAND/ U(97),C,CD,CM,I,J


 100  CONTINUE
      DT_RNDM = U(I)-U(J)
      IF ( DT_RNDM.LT.0.0D0 ) DT_RNDM = DT_RNDM+1.0D0
      U(I) = DT_RNDM
      I    = I-1
      IF ( I.EQ.0 ) I = 97
      J    = J-1
      IF ( J.EQ.0 ) J = 97
      C    = C-CD
      IF ( C.LT.0.0D0 ) C = C+CM
      DT_RNDM = DT_RNDM-C
      IF ( DT_RNDM.LT.0.0D0 ) DT_RNDM = DT_RNDM+1.0D0

      IF ((DT_RNDM.EQ.0.D0).OR.(DT_RNDM.EQ.1.D0)) GOTO 100

      RETURN
      END
c
c===rndmst=============================================================*
c
CDECK  ID>, DT_RNDMST
      SUBROUTINE DT_RNDMST(NA1,NA2,NA3,NB1)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c random number generator
      COMMON /DTRAND/ U(97),C,CD,CM,I,J


      MA1 = NA1
      MA2 = NA2
      MA3 = NA3
      MB1 = NB1
      I   = 97
      J   = 33
      DO 20 II2 = 1,97
        S = 0
        T = 0.5D0
        DO 10 II1 = 1,24
          MAT  = MOD(MOD(MA1*MA2,179)*MA3,179)
          MA1  = MA2
          MA2  = MA3
          MA3  = MAT
          MB1  = MOD(53*MB1+1,169)
          IF ( MOD(MB1*MAT,64).GE.32 ) S = S+T
   10   T = 0.5D0*T
   20 U(II2) = S
      C  =   362436.0D0/16777216.0D0
      CD =  7654321.0D0/16777216.0D0
      CM = 16777213.0D0/16777216.0D0
      RETURN
      END
c
c===rndmin=============================================================*
c
CDECK  ID>, DT_RNDMIN
      SUBROUTINE DT_RNDMIN(UIN,CIN,CDIN,CMIN,IIN,JIN)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c random number generator
      COMMON /DTRAND/ U(97),C,CD,CM,I,J


      DIMENSION UIN(97)

      DO 10 KKK = 1,97
   10 U(KKK) = UIN(KKK)
      C  = CIN
      CD = CDIN
      CM = CMIN
      I  = IIN
      J  = JIN

      RETURN
      END
c
c===rndmou=============================================================*
c
CDECK  ID>, DT_RNDMOU
      SUBROUTINE DT_RNDMOU(UOUT,COUT,CDOUT,CMOUT,IOUT,JOUT)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

c random number generator
      COMMON /DTRAND/ U(97),C,CD,CM,I,J


      DIMENSION UOUT(97)

      DO 10 KKK = 1,97
   10 UOUT(KKK) = U(KKK)
      COUT  = C
      CDOUT = CD
      CMOUT = CM
      IOUT  = I
      JOUT  = J

      RETURN
      END
c
c===rndmte=============================================================*
c
CDECK  ID>, DT_RNDMTE
      SUBROUTINE DT_RNDMTE(IO)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      DIMENSION UU(97),U(6),X(6),D(6)
      DATA U / 6533892.D0, 14220222.D0, 7275067.D0, 6172232.D0,
     +8354498.D0, 10633180.D0/

      CALL DT_RNDMOU(UU,CC,CCD,CCM,II,JJ)
      CALL DT_RNDMST(12,34,56,78)
      DO 10 II1 = 1,20000
   10 XX = DT_RNDM(XX)
      SD        = 0.0D0
      DO 20 II2 = 1,6
        X(II2)  = 4096.D0*(4096.D0*DT_RNDM(SD))
        D(II2)  = X(II2)-U(II2)
   20 SD = SD+D(II2)
      CALL DT_RNDMIN(UU,CC,CCD,CCM,II,JJ)
c*sr 24.01.95
C     IF ( IO.EQ. 1.OR. SD.NE.0. 0) WRITE(6,500) (U(I),X(I),D(I),I=1,6)
      IF ((IO.EQ.1).OR.(SD.NE.0.0)) THEN
C        WRITE(6,1000)
 1000    FORMAT(/,/,1X,'DT_RNDMTE: TEST OF RANDOM-NUMBER GENERATOR...',
     &          ' PASSED')
      ENDIF
c*
      RETURN
  500 FORMAT('  === TEST OF THE RANDOM-GENERATOR ===',/,
     &'    EXPECTED VALUE    CALCULATED VALUE     DIFFERENCE',/, 6(F17.
     &1,F20.1,F15.3,/), '  === END OF TEST ;',
     &'  GENERATOR HAS THE SAME STATUS AS BEFORE CALLING DT_RNDMTE')
      END
c
c
c===title==============================================================*
c
CDECK  ID>, DT_TITLE
      SUBROUTINE DT_TITLE

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      CHARACTER*6 CVERSI
      CHARACTER*11 CCHANG
      DATA CVERSI,CCHANG /'3.0-3 ','15 APR 2001'/

      CALL DT_XTIME
      WRITE(ErrorOut,1000) CVERSI,CCHANG
 1000 FORMAT(1X,'+-------------------------------------------------',
     &                  '----------------------+',/,
     &     1X,'|',71X,'|',/,
     &     1X,'|',26X,'DPMJET VERSION ',A6,24X,'|',/,
     &     1X,'|',71X,'|',/,
     &     1X,'|',22X,'(LAST CHANGE: ',A11,')',23X,'|',/,
     &     1X,'|',71X,'|',/,
     &     1X,'|',12X,'AUTHORS: STEFAN ROESLER   (SLAC)',27X,'|',/,
     &     1X,'|',21X,'RALPH ENGEL      (BARTOL RES. INST.)',14X,'|',/,
     &     1X,'|',21X,'JOHANNES RANFT   (SIEGEN UNIV.)',19X,'|',/,
     &     1X,'|',71X,'|',/,
     &     1X,'|',12X,'HTTP://HOME.CERN.CH/~SROESLER/DPMJET3.HTML',
     &                                              17X,'|',/,
     &     1X,'|',71X,'|',/,
     &     1X,'+-------------------------------------------------',
     &                '----------------------+',/,
     &     1X,'| PLEASE SEND SUGGESTIONS, BUG REPORTS, ETC. TO: ',
     &                                  'STEFAN.ROESLER@CERN.CH |',/,
     &     1X,'+-------------------------------------------------',
     &                '----------------------+',/)

      RETURN
      END
#endif
