#include "Zcondc.h"
#if USEDPMJET == 1
c*
c                                                                      *
c=== enrg =============================================================*
c                                                                      *
CDECK  ID>, DT_ENRG
      DOUBLE PRECISION FUNCTION DT_ENRG(A,Z)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( LUNIN  = 5  )
      PARAMETER ( LUNOUT = 6  )
c
c----------------------------------------------------------------------*
c                                                                      *
c     Revised version of the original routine from EVAP:               *
c                                                                      *
c     Created on   15 may 1990     by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 01-oct-94     by    Alfredo Ferrari               *
c                                                                      *
c     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!     *
c     !!!  It is supposed to be used with the updated atomic   !!!     *
c     !!!                    mass data file                    !!!     *
c     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!     *
c                                                                      *
c----------------------------------------------------------------------*
c
      PARAMETER ( O16OLD = 931.145  D+00 )
      PARAMETER ( O16NEW = 931.19826D+00 )
      PARAMETER ( O16RAT = O16NEW / O16OLD )
      PARAMETER ( C12NEW = 931.49432D+00 )
      PARAMETER ( ADJUST = -8.322737768178909D-02 )
      PARAMETER ( AINFNT = 1.0D+30 )
c (original name: EVA0)
      COMMON /FKEVA0/ Y0, B0, P0 (1001), P1 (1001), P2 (1001),
     *                FLA (6), FLZ (6), RHO (6), OMEGA (6), EXMASS (6),
     *                CAM2 (130), CAM3 (200), CAM4 (130), CAM5 (200),
     *                T (4,7), RMASS (297), ALPH (297), BET (297),
     *                APRIME (250), IA (6), IZ (6)

      LOGICAL LFIRST
      SAVE LFIRST, EXHYDR, EXNEUT
      DATA LFIRST / .TRUE. /
c
      IF ( LFIRST ) THEN
         LFIRST = .FALSE.
c*sr 30.6.
C        EXHYDR = DT_ENERGY( ONEONE, ONEONE )
C        EXNEUT = DT_ENERGY( ONEONE, ZERZER )
         EXHYDR = A
         EXNEUT = Z
         DT_ENRG   = -AINFNT
         RETURN
c*
      END IF
      IZ0 = NINT (Z)
      IF ( IZ0 .LE. 0 ) THEN
         DT_ENRG = A * EXNEUT
         RETURN
      END IF
      N   = NINT (A-Z)
      IF ( N .LE. 0 ) THEN
         DT_ENRG = Z * EXHYDR
         RETURN
      END IF
      AM2ZOA= (A-Z-Z)/A
      AM2ZOA=AM2ZOA*AM2ZOA
      A13 = RMASS(NINT(A))
c     A13 = A**.3333333333333333D+00
      AM13 = 1.D+00/A13
      EV=-17.0354D+00*(1.D+00 -1.84619 D+00*AM2ZOA)*A
      ES= 25.8357D+00*(1.D+00 -1.712185D+00*AM2ZOA)*
     &    (1.D+00 -0.62025D+00*AM13*AM13)*
     &    (A13*A13 -.62025D+00)
      EC= 0.799D+00*Z*(Z-1.D+00)*AM13*(((1.5772D+00*AM13 +1.2273D+00)*
     &    AM13-1.5849D+00)*
     &    AM13*AM13 +1.D+00)
      EEX= -0.4323D+00*AM13*Z**1.3333333D+00*
     &   (((0.49597D+00*AM13 -0.14518D+00)*AM13 -0.57811D+00) * AM13
     &   + 1.D+00)
      DT_ENRG=8.367D+00*A-0.783D+00*Z +EV +ES +EC +EEX+CAM2(IZ0)+CAM3(N)
      DT_ENRG=(DT_ENRG + A * O16OLD ) * O16RAT - A * ( C12NEW - ADJUST )
      DT_ENRG  = MIN ( DT_ENRG, Z * EXHYDR + ( A - Z ) * EXNEUT )
      RETURN
c=== End of function Enrg =============================================*
      END
c                                                                      *
c=== incini ===========================================================*
c                                                                      *
CDECK  ID>, DT_INCINI
      SUBROUTINE DT_INCINI

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( EMVGEV = 1.0                D-03 )

      PARAMETER ( LUNOUT = 6  )
c
c----------------------------------------------------------------------*
c                                                                      *
c     Created on  10  june  1990   by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 02-may-95     by    Alfredo Ferrari               *
c                                                                      *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: FHEAVY,FHEAVC)
      PARAMETER ( MXHEAV = 100 )
      CHARACTER*8 ANHEAV
      COMMON /FKFHVY/ CXHEAV (MXHEAV), CYHEAV (MXHEAV),
     &                CZHEAV (MXHEAV), TKHEAV (MXHEAV),
     &                PHEAVY (MXHEAV), WHEAVY (MXHEAV),
     &                AMHEAV  ( 12 ) , AMNHEA  ( 12 ) ,
     &                KHEAVY (MXHEAV), ICHEAV  ( 12 ) ,
     &                IBHEAV  ( 12 ) , NPHEAV
      COMMON /FKFHVC/ ANHEAV  ( 12 )

c (original name: INPFLG)
      COMMON /FKINPF/ IANG,IFISS,IB0,IGEOM,ISTRAG,KEYDK

c (original name: FRBKCM)
      PARAMETER ( MXFFBK =     6 )
      PARAMETER ( MXZFBK =     9 )
      PARAMETER ( MXNFBK =    10 )
      PARAMETER ( MXAFBK =    16 )
      PARAMETER ( NXZFBK = MXZFBK + MXFFBK / 3 )
      PARAMETER ( NXNFBK = MXNFBK + MXFFBK / 3 )
      PARAMETER ( NXAFBK = MXAFBK + 1 )
      PARAMETER ( MXPSST =   300 )
      PARAMETER ( MXPSFB = 41000 )
      LOGICAL LFRMBK, LNCMSS
      COMMON /FKFRBK/  AMUFBK, EEXFBK (MXPSST), AMFRBK (MXPSST),
     &          EXFRBK (MXPSFB), SDMFBK (MXPSFB), COUFBK (MXPSFB),
     &          EXMXFB, R0FRBK, R0CFBK, C1CFBK, C2CFBK,
     &          IFRBKN (MXPSST), IFRBKZ (MXPSST),
     &          IFBKSP (MXPSST), IFBKPR (MXPSST), IFBKST (MXPSST),
     &          IPSIND (0:MXNFBK,0:MXZFBK,2), JPSIND (0:MXAFBK),
     &          IFBIND (0:NXNFBK,0:NXZFBK,2), JFBIND (0:NXAFBK),
     &          IFBCHA (5,MXPSFB), IPOSST, IPOSFB, IFBSTF,
     &          IFBFRB, NBUFBK, LFRMBK, LNCMSS

c (original name: NUCDAT)
      PARAMETER ( AMUAMU = AMUGEV )
      PARAMETER ( AMPROT = AMPRTN )
      PARAMETER ( AMNEUT = AMNTRN )
      PARAMETER ( AMELEC = AMELCT )
      PARAMETER ( R0NUCL = 1.12        D+00 )
      PARAMETER ( RCCOUL = 1.7         D+00 )
      PARAMETER ( FERTHO = 14.33       D-09 )
      PARAMETER ( EXPEBN = 2.39        D+00 )
      PARAMETER ( BEXC12 = FERTHO * 72.40715579499394D+00 )
      PARAMETER ( AMUC12 = AMUGEV - HLFHLF * AMELCT + BEXC12 / 12.D+00 )
      PARAMETER ( AMHYDR = AMPRTN + AMELCT  )
      PARAMETER ( AMHTON = AMHYDR - AMNTRN  )
      PARAMETER ( AMNTOU = AMNTRN - AMUC12  )
      PARAMETER ( AMUCSQ = AMUC12 * AMUC12 )
      PARAMETER ( EBNDAV = HLFHLF * (AMPRTN + AMNTRN) - AMUC12 )
      PARAMETER ( GAMMIN = 1.0D-06 )
      PARAMETER ( GAMNSQ = 2.0D+00 * GAMMIN * GAMMIN )
      PARAMETER ( TVEPSI = GAMMIN / 100.D+00 )

      COMMON /FKNDAT/ AV0WEL,     APFRMX,     AEFRMX,     AEFRMA,
     &                RDSNUC,     V0WELL (2), PFRMMX (2), EFRMMX (2),
     &                EFRMAV (2), AMNUCL (2), AMNUSQ (2), EBNDNG (2),
     &                VEFFNU (2), ESLOPE (2), PKMNNU (2), EKMNNU (2),
     &                PKMXNU (2), EKMXNU (2), EKMNAV (2), EKINAV (2),
     &                EXMNAV (2), EKUPNU (2), EXMNNU (2), EXUPNU (2),
     &                ERCLAV (2), ESWELL (2), FINCUP (2), AMRCAV    ,
     &                AMRCSQ    , ATO1O3    , ZTO1O3    , ELBNDE (0:100)

c (original name: PAREVT)
      LOGICAL LDIFFR, LINCTV, LEVPRT, LHEAVY, LDEEXG, LGDHPR, LPREEX,
     &        LHLFIX, LPRFIX, LPARWV, LPOWER, LSNGCH, LLVMOD, LSCHDF
      PARAMETER ( NALLWP = 39   )
      COMMON /FKPARE/ DPOWER, FSPRD0, FSHPFN, RN1GSC, RN2GSC,
     &                LDIFFR (NALLWP),LPOWER, LINCTV, LEVPRT, LHEAVY,
     &                LDEEXG, LGDHPR, LPREEX, LHLFIX, LPRFIX, LPARWV,
     &                ILVMOD, JLVMOD, LLVMOD, LSNGCH, LSCHDF

c (original name: NUCOLD)
      COMMON /FKNOLD/ HELP (2), HHLP (2), FTVTH (2), FINCX (2),
     &                EKPOLD (2), BBOLD, ZZOLD, SQROLD, ASEASQ,
     &                FSPRED, FEX0RD

c
      BBOLD  = - 1.D+10
      ZZOLD  = - 1.D+10
      SQROLD = - 1.D+10
      APFRMX = PLABRC * ( ANINEN * PIPIPI / EIGEIG )**ONETHI / R0NUCL
      AMNUCL (1) = AMPROT
      AMNUCL (2) = AMNEUT
      AMNUSQ (1) = AMPROT * AMPROT
      AMNUSQ (2) = AMNEUT * AMNEUT
      AMNHLP = HLFHLF * ( AMNUCL (1) + AMNUCL (2) )
      ASQHLP = AMNHLP**2
c     ASQHLP = HLFHLF * ( AMNUSQ (1) + AMNUSQ (2) )
      AEFRMX = SQRT ( ASQHLP + APFRMX**2 ) - AMNHLP
      AEFRMA = 0.3D+00 * APFRMX**2 / AMNHLP * ( ONEONE - APFRMX**2 /
     &         ( 5.6D+00 * ASQHLP ) )
      AV0WEL = AEFRMX + EBNDAV
      EBNDNG (1) = EBNDAV
      EBNDNG (2) = EBNDAV
      AEXC12 = EMVGEV * DT_ENERGY( 12.D+00, 6.D+00 )
      CEXC12 = EMVGEV * DT_ENRG( 12.D+00, 6.D+00 )
      AMMC12 = 12.D+00 * AMUGEV + AEXC12
      AMNC12 = AMMC12 - 6.D+00 * AMELCT + FERTHO * 6.D+00**EXPEBN
      AEXO16 = EMVGEV * DT_ENERGY( 16.D+00, 8.D+00 )
      CEXO16 = EMVGEV * DT_ENRG( 16.D+00, 8.D+00 )
      AMMO16 = 16.D+00 * AMUGEV + AEXO16
      AMNO16 = AMMO16 - 8.D+00 * AMELCT + FERTHO * 8.D+00**EXPEBN
      AEXS28 = EMVGEV * DT_ENERGY( 28.D+00, 14.D+00 )
      CEXS28 = EMVGEV * DT_ENRG( 28.D+00, 14.D+00 )
      AMMS28 = 28.D+00 * AMUGEV + AEXS28
      AMNS28 = AMMS28 - 14.D+00 * AMELCT + FERTHO * 14.D+00**EXPEBN
      AEXC40 = EMVGEV * DT_ENERGY( 40.D+00, 20.D+00 )
      CEXC40 = EMVGEV * DT_ENRG( 40.D+00, 20.D+00 )
      AMMC40 = 40.D+00 * AMUGEV + AEXC40
      AMNC40 = AMMC40 - 20.D+00 * AMELCT + FERTHO * 20.D+00**EXPEBN
      AEXF56 = EMVGEV * DT_ENERGY( 56.D+00, 26.D+00 )
      CEXF56 = EMVGEV * DT_ENRG( 56.D+00, 26.D+00 )
      AMMF56 = 56.D+00 * AMUGEV + AEXF56
      AMNF56 = AMMF56 - 26.D+00 * AMELCT + FERTHO * 26.D+00**EXPEBN
      AEX107 = EMVGEV * DT_ENERGY( 107.D+00, 47.D+00 )
      CEX107 = EMVGEV * DT_ENRG( 107.D+00, 47.D+00 )
      AMM107 = 107.D+00 * AMUGEV + AEX107
      AMN107 = AMM107 - 47.D+00 * AMELCT + FERTHO * 47.D+00**EXPEBN
      AEX132 = EMVGEV * DT_ENERGY( 132.D+00, 54.D+00 )
      CEX132 = EMVGEV * DT_ENRG( 132.D+00, 54.D+00 )
      AMM132 = 132.D+00 * AMUGEV + AEX132
      AMN132 = AMM132 - 54.D+00 * AMELCT + FERTHO * 54.D+00**EXPEBN
      AEX181 = EMVGEV * DT_ENERGY( 181.D+00, 73.D+00 )
      CEX181 = EMVGEV * DT_ENRG( 181.D+00, 73.D+00 )
      AMM181 = 181.D+00 * AMUGEV + AEX181
      AMN181 = AMM181 - 73.D+00 * AMELCT + FERTHO * 73.D+00**EXPEBN
      AEX208 = EMVGEV * DT_ENERGY( 208.D+00, 82.D+00 )
      CEX208 = EMVGEV * DT_ENRG( 208.D+00, 82.D+00 )
      AMM208 = 208.D+00 * AMUGEV + AEX208
      AMN208 = AMM208 - 82.D+00 * AMELCT + FERTHO * 82.D+00**EXPEBN
      AEX238 = EMVGEV * DT_ENERGY( 238.D+00, 92.D+00 )
      CEX238 = EMVGEV * DT_ENRG( 238.D+00, 92.D+00 )
      AMM238 = 238.D+00 * AMUGEV + AEX238
      AMN238 = AMM238 - 92.D+00 * AMELCT + FERTHO * 92.D+00**EXPEBN

      AMHEAV (1) = AMUGEV + EMVGEV * DT_ENERGY( ONEONE, ZERZER )
      AMHEAV (2) = AMUGEV + EMVGEV * DT_ENERGY( ONEONE, ONEONE )
      AMHEAV (3) = TWOTWO * AMUGEV
     &             + EMVGEV * DT_ENERGY( TWOTWO, ONEONE )
      AMHEAV (4) = THRTHR * AMUGEV
     &             + EMVGEV * DT_ENERGY( THRTHR, ONEONE )
      AMHEAV (5) = THRTHR * AMUGEV
     &             + EMVGEV * DT_ENERGY( THRTHR, TWOTWO )
      AMHEAV (6) = FOUFOU * AMUGEV
     &             + EMVGEV * DT_ENERGY( FOUFOU, TWOTWO )
      ELBNDE (0) = ZERZER
      ELBNDE (1) = 13.6D-09
      DO 2000 IZ = 2, 100
         ELBNDE ( IZ ) = FERTHO * DBLE ( IZ )**EXPEBN
2000  CONTINUE
      AMNHEA (1) = AMHEAV (1) + ELBNDE (0)
      AMNHEA (2) = AMHEAV (2) - AMELCT + ELBNDE (1)
      AMNHEA (3) = AMHEAV (3) - AMELCT + ELBNDE (1)
      AMNHEA (4) = AMHEAV (4) - AMELCT + ELBNDE (1)
      AMNHEA (5) = AMHEAV (5) - TWOTWO * AMELCT + ELBNDE (2)
      AMNHEA (6) = AMHEAV (6) - TWOTWO * AMELCT + ELBNDE (2)
      IF ( LEVPRT ) THEN
         WRITE ( ErrorOut,
     *  * )' **** Evaporation from residual nucleus',
     &                      ' ACTIVATED **** '
         IF ( LDEEXG ) WRITE ( ErrorOut,
     *  * )' **** Deexcitation gamma',
     &                      ' PRODUCTION ACTIVATED **** '
c*sr 18.5.95
c commented, since obsolete
C        IF ( LHEAVY ) WRITE ( LUNOUT, * )' **** Evaporated "heavies"',
C    &                      ' transport activated **** '
         IF ( IFISS .GT. 0 )
     &                 WRITE ( ErrorOut,
     *  * )' **** High Energy fission ',
     &                      ' REQUESTED & ACTIVATED **** '
         IF ( LFRMBK )
     &                 WRITE ( ErrorOut,
     *  * )' **** Fermi Break Up ',
     &                      ' REQUESTED & ACTIVATED **** '
         IF ( LFRMBK ) CALL DT_FRBKIN(.FALSE.,.FALSE.)
      ELSE
         LDEEXG = .FALSE.
         LHEAVY = .FALSE.
         LFRMBK = .FALSE.
         IFISS  = 0
      END IF
      RETURN
c=== End of subroutine incini =========================================*
      END
c                                                                      *
c=== stalin ===========================================================*
c                                                                      *
CDECK  ID>, DT_STALIN
      SUBROUTINE DT_STALIN

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( LUNIN  = 5  )
      PARAMETER ( LUNOUT = 6  )
c
c----------------------------------------------------------------------*
c                                                                      *
c     STAbility LINe calculation:                                      *
c                                                                      *
c     Created on 04 december 1992  by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 04-dec-92     by    Alfredo Ferrari               *
c                                                                      *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: ISOTOP)
      PARAMETER ( NAMSMX = 270 )
      PARAMETER ( NZGVAX =  15 )
      PARAMETER ( NISMMX = 574 )
      COMMON /FKISOT/ WAPS   (NAMSMX,NZGVAX),  T12NUC (NAMSMX,NZGVAX),
     &                WAPISM (NISMMX), T12ISM (NISMMX),
     &                ABUISO (NSTBIS), ASTLIN (2,100), ZSTLIN (2,260),
     &                AMSSST (100)  , ISOMNM (NSTBIS), ISONDX (2,100),
     &                JSPNUC (NAMSMX,NZGVAX), JPTNUC (NAMSMX,NZGVAX),
     &                INWAPS (NAMSMX), JSPISM (NISMMX),
     &                JPTISM (NISMMX), IZWISM (NISMMX),
     &                INWISM (0:NAMSMX)

c
      DIMENSION ZNORM (260)
c  +-------------------------------------------------------------------*
c  |
      DO 1000 IZ=1,100
         DO 500 J=1,2
            ASTLIN (J,IZ) = ZERZER
  500    CONTINUE
 1000 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |
      DO 2000 IA=1,260
         ZNORM (IA) = ZERZER
         DO 1500 J=1,2
            ZSTLIN (J,IA) = ZERZER
 1500    CONTINUE
 2000 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Loop on the Atomic Number
      DO 3000 IZ=1,100
         AMSSST (IZ) = ZERZER
         ANORM       = ONEONE
         ZTAR        = IZ
c  |  +----------------------------------------------------------------*
c  |  |    Loop on the stable isotopes
         DO 2500 IS = ISONDX (1,IZ), ISONDX (2,IZ)
            IA = ISOMNM (IS)
            ASTLIN (1,IZ) = ASTLIN (1,IZ) + ABUISO (IS) * IA
            ASTLIN (2,IZ) = ASTLIN (2,IZ) + ABUISO (IS) * IA**2
            ZNORM    (IA) = ZNORM (IA) + ABUISO (IS)
            ZSTLIN (1,IA) = ZSTLIN (1,IA) + ABUISO (IS) * IZ
            ZSTLIN (2,IA) = ZSTLIN (2,IA) + ABUISO (IS) * IZ**2
            AHELP  = IA
            IF ( AHELP .LE. 1.00001D+00 ) THEN
               ANORM = ONEONE / ( ONEONE - ABUISO (IS) )
               GO TO 2500
            END IF
            AMSSST (IZ) = ABUISO (IS) * ( AHELP * AMUGEV
     &                  + EMVGEV * DT_ENERGY(AHELP,ZTAR) ) + AMSSST (IZ)
 2500    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
         AMSSST (IZ) = ANORM * AMSSST (IZ) / AMUGEV
c  |  Normalize and print A_stab versus Z data:
         ASTLIN (2,IZ) = MAX ( SQRT (ASTLIN(2,IZ)-ASTLIN(1,IZ)**2),
     &                         0.5D+00 )
c        WRITE (LUNOUT,*)'  Z:',IZ,' A_stab:',SNGL(ASTLIN(1,IZ)),
c    &                   '  Sigma_st',SNGL(ASTLIN(2,IZ))
 3000 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Normalize and print Z_stab versus A data:
      DO 4000 IA=1,260
         ZSTLIN (1,IA) = ZSTLIN (1,IA) / MAX ( ZNORM (IA), 1.D-10 )
         ZSTLIN (2,IA) = ZSTLIN (2,IA) / MAX ( ZNORM (IA), 1.D-10 )
         ZSTLIN (2,IA) = MAX ( ZSTLIN (2,IA), ZSTLIN (1,IA)**2 )
         IF ( ZNORM (IA) .GT. ANGLGB )
c*sr 2.11. avoid underflows at Pentium
     &      ZSTLIN (2,IA) =
     &               MAX ( SQRT ( ABS(ZSTLIN(2,IA)-ZSTLIN(1,IA)**2) ),
C    &      ZSTLIN (2,IA) = MAX ( SQRT (ZSTLIN(2,IA)-ZSTLIN(1,IA)**2),
     &                            0.3D+00 )
 4000 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Normalize and print Z_stab versus A data:
      DO 5000 IA=1,260
         IF ( ZNORM (IA) .LE. ANGLGB ) THEN
            DO 4200 JA = IA-1,1,-1
               IF ( ZNORM (JA) .GT. ANGLGB ) THEN
                  IA1 = JA
                  GO TO 4300
               END IF
 4200       CONTINUE
 4300       CONTINUE
            DO 4400 JA = IA+1,260
               IF ( ZNORM (JA) .GT. ANGLGB ) THEN
                  IA2 = JA
                  GO TO 4500
               END IF
 4400       CONTINUE
            IA2 = IA1
            IA1 = IA1 - 1
 4500       CONTINUE
            ZSTLIN (1,IA) = DBLE (IA-IA1) / DBLE (IA2-IA1)
     &                    * ( ZSTLIN (1,IA2) - ZSTLIN (1,IA1) )
     &                    + ZSTLIN (1,IA1)
            ZSTLIN (2,IA) = DBLE (IA-IA1) / DBLE (IA2-IA1)
     &                    * ( ZSTLIN (2,IA2) - ZSTLIN (2,IA1) )
     &                    + ZSTLIN (2,IA1)
         END IF
         IZ = MIN ( 100, NINT (ZSTLIN(1,IA)) )
         ATOZ = IZ / ASTLIN (1,IZ)
         ZSTLIN (2,IA) = MAX ( ZSTLIN (2,IA), ATOZ * ASTLIN (2,IZ) )
c        WRITE (LUNOUT,*)'  A:',IA,' Z_stab:',SNGL(ZSTLIN(1,IA)),
c    &                   '  Sigma_st',SNGL(ZSTLIN(2,IA))
 5000 CONTINUE
c  |
c  +-------------------------------------------------------------------*
      RETURN
      END

c*sr 30.6. routine replaced completely
c$ CREATE DRES.FOR
cCOPY DRES
c                                                                      *
c=== dres =============================================================*
c                                                                      *
CDECK  ID>, DT_DRES
      SUBROUTINE DT_DRES( M2, M3, T1, U, EREC, LOPPAR, JFISS, IFKEY )

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c  New version of DRES created  by A.Ferrari & P.Sala, INFN - Milan    *
c                                                                      *
c  Last change  on  14-feb-96  by  Alfredo Ferrari, INFN - Milan       *
c                                                                      *
c  Dres95: Dres93 plus the newly developed Fermi Break Up model        *
c  Dres93: Dres91 plus the RAL fission model taken from LAHET thanks   *
c          to R.E.Prael and extensively modified to get rid of the     *
c          unphysical patches required by HETC which are no longer     *
c          needed with a proper preequilibrium stage                   *
c  Dres91: new version from A. Ferrari and P. Sala, INFN - Milan       *
c          This routine has been adapted from the original one of the  *
c          Evap-5 module (KFA - Julich). Main modifications concern    *
c          with kinematics which is now fully relativistic and with    *
c          the treatment of few nucleons nuclei, which are now frag-   *
c          mented, even though in a very rough manner. Changes have    *
c          been made also to other routines of the Evap-5 package      *
c                                                                      *
c----------------------------------------------------------------------*
c
c----------------------------------------------------------------------*
c                                                                      *
c  Input variables:                                                    *
c     M2 = Mass number of the residual nucleus                         *
c     M3 = Atomic number of the residual nucleus                       *
c     T1 = Excitation energy of the residual nucleus before evaporation*
c     U  = Excitation energy of the residual nucleus after evaporation *
c     Erec = Recoil kinetic energy of the residual nucleus             *
c            The recoil direction is given by Coslbr (i)               *
c                                                                      *
c  Significant variables:                                              *
c     JA = Present mass number of the residual nucleus                 *
c     JZ = Present atomic number of the residual nucleus               *
c     Smom1 = Energy accumulators for the six types of evaporated      *
c             particles                                                *
c                                                                      *
c    !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!     *
c    !!!! Please note that the following variables concerning !!!!     *
c    !!!! with the present residual nucleus must be set before!!!!     *
c    !!!! entering DRES91: Ammres, Ptres                      !!!!     *
c    !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!     *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: EVA0)
      COMMON /FKEVA0/ Y0, B0, P0 (1001), P1 (1001), P2 (1001),
     *                FLA (6), FLZ (6), RHO (6), OMEGA (6), EXMASS (6),
     *                CAM2 (130), CAM3 (200), CAM4 (130), CAM5 (200),
     *                T (4,7), RMASS (297), ALPH (297), BET (297),
     *                APRIME (250), IA (6), IZ (6)

c (original name: EVA1)
c*sr
C     COMMON /FKEVA1/ NPART(6),EPART(100,6),COSEVP(3,100,6),HEVSUM
      COMMON /FKEVA1/ NPART(6),EPART(200,6),COSEVP(3,200,6),HEVSUM
c*

c (original name: FRBKCM)
      PARAMETER ( MXFFBK =     6 )
      PARAMETER ( MXZFBK =     9 )
      PARAMETER ( MXNFBK =    10 )
      PARAMETER ( MXAFBK =    16 )
      PARAMETER ( NXZFBK = MXZFBK + MXFFBK / 3 )
      PARAMETER ( NXNFBK = MXNFBK + MXFFBK / 3 )
      PARAMETER ( NXAFBK = MXAFBK + 1 )
      PARAMETER ( MXPSST =   300 )
      PARAMETER ( MXPSFB = 41000 )
      LOGICAL LFRMBK, LNCMSS
      COMMON /FKFRBK/  AMUFBK, EEXFBK (MXPSST), AMFRBK (MXPSST),
     &          EXFRBK (MXPSFB), SDMFBK (MXPSFB), COUFBK (MXPSFB),
     &          EXMXFB, R0FRBK, R0CFBK, C1CFBK, C2CFBK,
     &          IFRBKN (MXPSST), IFRBKZ (MXPSST),
     &          IFBKSP (MXPSST), IFBKPR (MXPSST), IFBKST (MXPSST),
     &          IPSIND (0:MXNFBK,0:MXZFBK,2), JPSIND (0:MXAFBK),
     &          IFBIND (0:NXNFBK,0:NXZFBK,2), JFBIND (0:NXAFBK),
     &          IFBCHA (5,MXPSFB), IPOSST, IPOSFB, IFBSTF,
     &          IFBFRB, NBUFBK, LFRMBK, LNCMSS

c (original name: HIGFIS)
      PARAMETER ( IZFSMX = 61 )
      LOGICAL FISINH, LFRGMN, LAGOES
      COMMON /FKHIGF/ AFIS  (10), ZFIS  (10), UFIS  (10), EKFIS  (10),
     &                AMFIS (10), PPFIS (10), COSLFF(3,0:10),
     &                ATFIS (10), ZTFIS (10), UTFIS (10), RECFIS (10),
     &                AMTFIS(10), PPTFIS(10), EBFISS, AMDIFF,
     &                APR0, ZPR0, EREC0, UU0, HEVFIS (0:10),
     &                ISTFIS(10), NPARTF (6,0:10), NFISS, FISINH,
     &                LFRGMN, LAGOES
      DIMENSION COSLF0 (3)
      EQUIVALENCE ( COSLF0 (1), COSLFF (1,0) )

c (original name: INPFLG)
      COMMON /FKINPF/ IANG,IFISS,IB0,IGEOM,ISTRAG,KEYDK

c (original name: LABCOS)
      COMMON /FKLABC/ COSLBP(3),COSLBR(3)

c (original name: NUCDAT)
      PARAMETER ( AMUAMU = AMUGEV )
      PARAMETER ( AMPROT = AMPRTN )
      PARAMETER ( AMNEUT = AMNTRN )
      PARAMETER ( AMELEC = AMELCT )
      PARAMETER ( R0NUCL = 1.12        D+00 )
      PARAMETER ( RCCOUL = 1.7         D+00 )
      PARAMETER ( FERTHO = 14.33       D-09 )
      PARAMETER ( EXPEBN = 2.39        D+00 )
      PARAMETER ( BEXC12 = FERTHO * 72.40715579499394D+00 )
      PARAMETER ( AMUC12 = AMUGEV - HLFHLF * AMELCT + BEXC12 / 12.D+00 )
      PARAMETER ( AMHYDR = AMPRTN + AMELCT  )
      PARAMETER ( AMHTON = AMHYDR - AMNTRN  )
      PARAMETER ( AMNTOU = AMNTRN - AMUC12  )
      PARAMETER ( AMUCSQ = AMUC12 * AMUC12 )
      PARAMETER ( EBNDAV = HLFHLF * (AMPRTN + AMNTRN) - AMUC12 )
      PARAMETER ( GAMMIN = 1.0D-06 )
      PARAMETER ( GAMNSQ = 2.0D+00 * GAMMIN * GAMMIN )
      PARAMETER ( TVEPSI = GAMMIN / 100.D+00 )

      COMMON /FKNDAT/ AV0WEL,     APFRMX,     AEFRMX,     AEFRMA,
     &                RDSNUC,     V0WELL (2), PFRMMX (2), EFRMMX (2),
     &                EFRMAV (2), AMNUCL (2), AMNUSQ (2), EBNDNG (2),
     &                VEFFNU (2), ESLOPE (2), PKMNNU (2), EKMNNU (2),
     &                PKMXNU (2), EKMXNU (2), EKMNAV (2), EKINAV (2),
     &                EXMNAV (2), EKUPNU (2), EXMNNU (2), EXUPNU (2),
     &                ERCLAV (2), ESWELL (2), FINCUP (2), AMRCAV    ,
     &                AMRCSQ    , ATO1O3    , ZTO1O3    , ELBNDE (0:100)

c (original name: RESNUC)
      LOGICAL LRNFSS, LFRAGM
      COMMON /FKRESN/  AMNTAR, AMMTAR, AMNZM1, AMMZM1, AMNNM1, AMMNM1,
     &                   ANOW,   ZNOW, ANCOLL, ZNCOLL, AMMLFT, AMNLFT,
     &                   ERES,  EKRES, AMNRES, AMMRES,  PTRES,  PXRES,
     &                  PYRES,  PZRES, PTRES2,  KTARP,  KTARN, IGREYP,
     &                 IGREYN, IPREEH, IPRDEU, IPRTRI, IPR3HE, IPR4HE,
     &                  ICRES,  IBRES, ISTRES, IEVAPL, IEVAPH, IEVNEU,
     &                 IEVPRO, IEVDEU, IEVTRI, IEV3HE, IEV4HE, IDEEXG,
     &                  IBTAR, ICHTAR, IBLEFT, ICLEFT, IOTHER, LRNFSS,
     &                 LFRAGM

c
      PARAMETER ( NEVPRD = 6 )
c
      DIMENSION ZMASS (6), Z2MASS(6), C(3), Q(0:6), FLKCOU(6), CCOUL(6),
     &          THRESH(6), SMALLA(6), R(6), S  (6), SOS   (6), STRUN(6),
     &          EYE1  (6), EYE0  (6), SMOM1    (6), BNMASS(6)
      DIMENSION CORRRR(6)
      LOGICAL LOPPAR, PENBAR, LFIRST, LCFRBK
      SAVE ZMASS, Z2MASS, EMHN, EMNUM, UM, AMUMEV, AMEMEV, QBRBE8,
     &     BNMASS, IEVEVP, NBE8, NRNEEP, LFIRST
      DATA IEVEVP / 0 /
      DATA LFIRST / .TRUE. /
c
      IEVEVP = IEVEVP + 1
C-------------------------------------- 1.ST CALL INIT
      IF ( LFIRST ) THEN
         LFIRST = .FALSE.
         IFKEY  = 0
         NBE8   = 0
         NRNEEP = 0
c  |  The following are old values already superseded by the next ones
C        ZMASS(1)=939.5124
C        ZMASS(2)=938.7298
C        ZMASS(3)=1876.0177
C        ZMASS(4)=2809.2727
C        ZMASS(5) = 2809.2539
C        ZMASS(6) = 3728.1883
C        EMH=938.7298
C        EMN=939.5124
C        UM=931.145
c  | These exmass values represents the differences between the actual
c  | atomic mass of particle I (1=neutron, 2=proton, 3=deuteron,
c  | 4=3-H, 5=3-He, 6=4-He) and A*UM (Um is one unit of the old atomic
c  | mass). All the data on the Bertini tape are consistent with an ato-
c  | mic mass unit of 931.504 which is the old value for 1/12 of the
c  | mass of the 12-C atom. All the initialization in this routine are
c  | consistent with an atomic mass unit BASED ON 16-O, 931.20793 MeV!!!
c  | Now they are computed at the very beginning when reading
c  | the Bertini tape. Zmass's are the atomic masses of these particles,
c  | now they are computed for consistency (with the proper values).
c        EXMASS(1) = 8.3675489D0
c        EXMASS(2) = 7.5851116D0
c        EXMASS(3) = 13.727994D0
c        EXMASS(4) = 15.838178D0
c        EXMASS(5) = 15.819549D0
c        EXMASS(6) = 3.6092443D0
c        ZMASS(1) = 939.57548D0
c        ZMASS(2) = 938.79304D0
c        ZMASS(3) = 1876.1438D0
c        ZMASS(4) = 2809.4620D0
c        ZMASS(5) = 2809.4433D0
c        ZMASS(6) = 3728.4409D0
c        EMH = 938.79304D0
c        EMN = 939.57548D0
c        UM  = 931.20793D0
         EXMASS(1) = GEVMEV * ( AMNEUT - AMUGEV )
         EXMASS(2) = DT_ENERGY( ONEONE, ONEONE )
         EXMASS(3) = DT_ENERGY( TWOTWO, ONEONE )
         EXMASS(4) = DT_ENERGY( THRTHR, ONEONE )
         EXMASS(5) = DT_ENERGY( THRTHR, TWOTWO )
         EXMASS(6) = DT_ENERGY( FOUFOU, TWOTWO )
         ZMASS(1) = GEVMEV * AMUGEV + EXMASS (1)
         ZMASS(2) = GEVMEV * AMUGEV + EXMASS (2)
         ZMASS(3) = TWOTWO * GEVMEV * AMUGEV + EXMASS (3)
         ZMASS(4) = THRTHR * GEVMEV * AMUGEV + EXMASS (4)
         ZMASS(5) = THRTHR * GEVMEV * AMUGEV + EXMASS (5)
         ZMASS(6) = FOUFOU * GEVMEV * AMUGEV + EXMASS (6)
         BNMASS (1) = ZERZER
         BNMASS (2) = ZERZER
         BNMASS (3) = ZMASS (1) + ZMASS (2) - ZMASS (3)
         BNMASS (4) = TWOTWO * ZMASS (1) + ZMASS (2) - ZMASS (4)
         BNMASS (5) = ZMASS (1) + TWOTWO * ZMASS (2) - ZMASS (5)
         BNMASS (6) = TWOTWO * ( ZMASS (1) + ZMASS (2) ) - ZMASS (6)
         DO 1234 KK = 1,6
            Z2MASS (KK) = ZMASS (KK) * ZMASS (KK)
 1234    CONTINUE
         AMUMEV = GEVMEV * AMUGEV
         AMEMEV = GEVMEV * AMELCT
         QBRBE8 = DT_ENERGY( EIGEIG, FOUFOU ) - TWOTWO * EXMASS (6)
         EMN    = GEVMEV * AMNEUT
         EMH    = ZMASS (2)
         UM     = AMUMEV + DT_ENERGY( 16.D+00, EIGEIG ) / 16.D+00
         EMHN   = EMH - EMN
         EMNUM  = EMN - UM
      END IF
c  |  End of initialization:
c  +-------------------------------------------------------------------*
C     --------------------------------- START OF PROCESS
c  +-------------------------------------------------------------------*
c  |  Initialize Npart and Smom if nothing has been already evaporated
c  |  for this event
      IF ( JFISS .LE. 0 ) THEN
         DO 775 I=1,6
            NPART(I) = 0
            SMOM1(I) = ZERZER
  775    CONTINUE
      END IF
c  |
c  +-------------------------------------------------------------------*
      JA = M2
      JZ = M3
      A  = JA
      Z  = JZ
      U  = T1
      RNMASS = GEVMEV * AMMRES + U
c P2res and  Ptres are the squared momentum and the momentum of the
c residual nucleus (now in relativistic kinematics), Umo the
c invariant mass of the system!
      UMO     = RNMASS
      UMO2    = UMO * UMO
      ELBTOT  = RNMASS + EREC
      GAMCM   = ELBTOT / RNMASS
      ETACM   = GEVMEV * PTRES / RNMASS
      HEVSUM  = ZERZER
      LCFRBK  = LFRMBK
      ISTRES  = 0
 1000 CONTINUE
      LOPPAR = .FALSE.
c  +-------------------------------------------------------------------*
c  |                Check for starting data inconsistencies
      IF (JA-JZ .LT. 0) THEN
         WRITE(ErrorOut,6401)
         WRITE(ErrorOut,6401)
 6401    FORMAT('1 DRES: CASCADE RESIDUAL NUCLEUS HAS MASS NO. LESS',
     &       ' THAN Z!!')
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |     Standard hook for Fermi break-up (if activated):
      ELSE IF ( JA .LE. NXAFBK .AND. JA-JZ .LE. NXNFBK .AND.
     &          JZ .LE. NXZFBK .AND. LCFRBK ) THEN
         AMRESD = A * AMUMEV + DT_ENERGY(A,Z)
         EXCRES = U
         PXRES  = GEVMEV * PXRES
         PYRES  = GEVMEV * PYRES
         PZRES  = GEVMEV * PZRES
         PTRES  = GEVMEV * PTRES
         CALL DT_FRMBRK( JA, JZ, AMRESD, EXCRES, EREC  , PXRES , PYRES ,
     &                 PZRES , PTRES , SMOM1 , ISTRES, LCFRBK )
         AMMRES = EMVGEV * AMRESD
         EKRES  = EMVGEV * EREC
         PXRES  = EMVGEV * PXRES
         PYRES  = EMVGEV * PYRES
         PZRES  = EMVGEV * PZRES
         PTRES  = EMVGEV * PTRES
         IF ( PTRES .GE. ANGLGB ) THEN
            COSLBR (1) = PXRES / PTRES
            COSLBR (2) = PYRES / PTRES
            COSLBR (3) = PZRES / PTRES
         END IF
         U      = EXCRES
         IARES  = JA
         IZRES  = JZ
c  |  +----------------------------------------------------------------*
c  |  |  Fermi Break up successful:
         IF ( LCFRBK ) THEN
            IF ( IARES  .LE. 0 .AND. .NOT. LFRGMN ) NRNEEP = NRNEEP + 1
            IF ( ISTRES .GE. 0 ) THEN
               LOPPAR = .FALSE.
               IFKEY  = 1
               GO TO 72
            ELSE
               WRITE (ErrorOut,*)
     &  ' *** DRES: UNSTABLE NUCLEUS OUT OF THE FERMI BREAK UP',
     &         IARES, IZRES, ISTRES
               ISTRES = 0
               LCFRBK = .FALSE.
               GO TO 1000
            END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Fermi Break Up not possible
         ELSE
            GO TO 1000
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |
c  +-------------------------------------------------------------------*
c  |                Rough treatment for very few nucleon residual
c  |                nuclei. The basic ideas are:
c  |        a) as many as possible alpha particles are emitted
c  |        b) particles are emitted one per time leaving a residual
c  |           excitation energy proportional to number of nucleons
c  |           left in the residual nucleus (so we deal only with
c  |           two body kinematics)
c  |       T A K E   I N T O   A C C O U N T   T H A T   T H I S
c  |       T R E A T M E N T   I S   E X T R E M E L Y   R O U G H
c  |       T H E   T A S K   B E I N G   O N L Y   T O   S U P P L Y
c  |       S O M E T H I N G   T O   S H A R E   E N E R G Y   A N D
c  |       M O M E N T U M   A M O N G   A   F E W   F R A G M E N T S
      ELSE IF ( JA .LE. 6 .OR. JZ .LE. 2 ) THEN
c  | 1000 continue moved above according to FCA suggestion
c1000    CONTINUE
         JRESID = 0
         IF ( JA .GT. 4 ) GO TO 2000
c  |  +----------------------------------------------------------------*
c  |  | First check we are not concerning with a couple of neutrons or
c  |  | protons
         IF ( JA .EQ. 2 .AND. JZ .NE. 1 ) THEN
            JEMISS = 1 + JZ / 2
            JRESID = JEMISS
            RNMASS = ZMASS (JRESID)
            U = ZERZER
            DELTU = UMO - 2.D+00 * ZMASS (JEMISS)
c  |  |  +-------------------------------------------------------------*
c  |  |  |
            IF ( DELTU .LE. ZERZER ) THEN
               IF ( DELTU .LT. - 2.D+00 * ANGLGB * UMO ) THEN
                  WRITE ( ErrorOut,
     *  * )' *** Dres: insufficient Umo for',
     &                               ' A NUCLEON COUPLE', UMO,
     &                                 2.D+00 * ZMASS (JEMISS)
               END IF
               UMO = ( UMO + DELTU ) * ( 1.D+00 + ANGLGB )
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
            GO TO 2500
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |  +----------------------------------------------------------------*
c  |  | Then check we are not concerning with one of the six
c  |  | standard particles
         DO 1700 J = 6, 1, -1
c  |  |  +-------------------------------------------------------------*
c  |  |  |
            IF ( JZ .EQ. IZ (J) .AND. JA .EQ. IA (J) ) THEN
               HEVSUM = SMOM1(3) + SMOM1(5) + SMOM1(6) + SMOM1(4)
               GO TO ( 1100, 1100, 1600, 1500, 1400, 1300 ), J
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Proton or neutron, nothing can be done
 1100          CONTINUE
                  RETURN
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Alpha:
 1300          CONTINUE
                  DEUDEU = MAX ( ZERZER, U + TWOTWO * BNMASS (3)
     &                           - BNMASS (6) )
                  PROTRI = MAX ( ZERZER, U + BNMASS (4) - BNMASS (6) )
                  UEU3HE = MAX ( ZERZER, U + BNMASS (5) - BNMASS (6) )
                  QNORM  = DEUDEU + PROTRI + UEU3HE
c  |  |  |  |  If we cannot split then return
                  IF ( QNORM .LE. ZERZER ) RETURN
                  V = DT_RNDM(V)
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  | Split or into two deuterons or a triton and a proton
c  |  |  |  |  | or a 3-He and a neutron: no account is made for
c  |  |  |  |  | Coulomb effects, probability is simply assumed
c  |  |  |  |  | proportional to reaction Qs
                  IF ( V .LT. DEUDEU / QNORM ) THEN
c  |  |  |  |  | Two deuterons selected
                     JEMISS = 3
                     JRESID = 3
                     RNMASS = ZMASS (3)
                     U = ZERZER
                     GO TO 2500
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  | Split into a triton and a proton
                  ELSE IF ( V .LT. ( DEUDEU + PROTRI ) / QNORM ) THEN
                     JEMISS = 2
                     JRESID = 4
                     RNMASS = ZMASS (4)
                     U = ZERZER
                     GO TO 2500
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  | Split into a 3-He and a neutron
                  ELSE
                     JEMISS = 1
                     JRESID = 5
                     RNMASS = ZMASS (5)
                     U = ZERZER
                     GO TO 2500
                  END IF
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  3-He:
 1400          CONTINUE
                  DEUPRO = MAX ( ZERZER, U + BNMASS (3) - BNMASS (5) )
                  PRPRNE = MAX ( ZERZER, U - BNMASS (5) )
                  QNORM  = DEUPRO + PRPRNE
c  |  |  |  |  If we cannot split then return
                  IF ( QNORM .LE. ZERZER ) RETURN
                  V = DT_RNDM(V)
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  | Split or into a deuteron and a proton
c  |  |  |  |  | or into two protons and one neutron: no account is
c  |  |  |  |  | made for Coulomb effects, probability is simply assumed
c  |  |  |  |  | prportional to reaction Qs
                  IF ( V .LT. DEUPRO / QNORM ) THEN
c  |  |  |  |  | A deuteron and a proton selected
                     JEMISS = 2
                     JRESID = 3
                     RNMASS = ZMASS (3)
                     U = ZERZER
                     GO TO 2500
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  | Split into 2 protons and 1 neutron: part of the exci-
c  |  |  |  |  | tation energy is conserved to allow the further
c  |  |  |  |  | splitting of the deuteron
                  ELSE
                     JEMISS = 2
                     JRESID = 0
                     FACT = ONEONE
c  |  |  |  |  |  +----------------------------------------------------*
c  |  |  |  |  |  | Loop to compute the residual excitation energy
 1450                CONTINUE
                        FACT = FACT * 0.6666666666666667D+00
c  |  |  |  |  |  | Erncm, Eepcm are the total energies of the residual
c  |  |  |  |  |  | nucleus and of the emitted particle in the CMS frame
                        U      = FACT * PRPRNE + BNMASS (3)
                        RNMASS = ZMASS (3) + U
                        ERNCM  = HLFHLF * ( UMO2 + RNMASS**2
     &                         - Z2MASS (JEMISS) ) / UMO
                        EEPCM  = UMO - ERNCM
                     IF ( EEPCM .LE. ZMASS (JEMISS) ) GO TO 1450
c  |  |  |  |  |  |
c  |  |  |  |  |  +----------------------------------------------------*
                     GO TO 2600
                  END IF
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Triton:
 1500          CONTINUE
                  DEUNEU = MAX ( ZERZER, U + BNMASS (3) - BNMASS (4) )
                  PRNENE = MAX ( ZERZER, U - BNMASS (4) )
                  QNORM  = DEUNEU + PRNENE
c  |  |  |  |  If we cannot split then return
                  IF ( QNORM .LE. ZERZER ) RETURN
                  V = DT_RNDM(V)
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  | Split or into a deuteron and a neutron
c  |  |  |  |  | or into two protons and one neutron: no account is
c  |  |  |  |  | made for Coulomb effects, probability is simply assumed
c  |  |  |  |  | proportional to reaction Qs
                  IF ( V .LT. DEUNEU / QNORM ) THEN
c  |  |  |  |  | A deuteron and a proton selected
                     JEMISS = 1
                     JRESID = 3
                     RNMASS = ZMASS (3)
                     U = ZERZER
                     GO TO 2500
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  | Split into 1 proton and 2 neutrons: part of the exci-
c  |  |  |  |  | tation energy is conserved to allow the further
c  |  |  |  |  | splitting of the deuteron
                  ELSE
                     JEMISS = 1
                     JRESID = 0
                     FACT = ONEONE
c  |  |  |  |  |  +----------------------------------------------------*
c  |  |  |  |  |  | Loop to compute the residual excitation energy
 1550                CONTINUE
                        FACT = FACT * 0.6666666666666667D+00
c  |  |  |  |  |  | Erncm, Eepcm are the total energies of the residual
c  |  |  |  |  |  | nucleus and of the emitted particle in the CMS frame
                        U      = FACT * PRNENE + BNMASS (3)
                        RNMASS = ZMASS (3) + U
                        ERNCM  = HLFHLF * ( UMO2 + RNMASS**2
     &                         - Z2MASS (JEMISS) ) / UMO
                        EEPCM  = UMO - ERNCM
                     IF ( EEPCM .LE. ZMASS (JEMISS) ) GO TO 1550
c  |  |  |  |  |  |
c  |  |  |  |  |  +----------------------------------------------------*
                     GO TO 2600
                  END IF
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Deuteron:
 1600          CONTINUE
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  | Split into a proton and a neutron if it is possible
                  IF ( U .GT. BNMASS (3) ) THEN
                     JEMISS = 1
                     JRESID = 2
                     RNMASS = ZMASS (2)
                     U = ZERZER
                     GO TO 2500
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  | Energy too low to split the deuteron, return
                  ELSE
                     WRITE (ErrorOut,
     * *)' **Dres: energy too low to split',
     &                               ' A DEUTERON! M2,M3',M2,M3
                     RETURN
                  END IF
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
 1700    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
 2000    CONTINUE
         A = DBLE (JA)
         Z = DBLE (JZ)
         Q (0)  = ZERZER
         ENERG0 = DT_ENERGY(A,Z)
c  |  +----------------------------------------------------------------*
c  |  |   Note that Q(i) are not the reaction Qs but the remaining
c  |  |   energy after the reaction
         DO 2100 K = 1, 6
            JJA = JA - IA (K)
            JJZ = JZ - IZ (K)
            JJN = JJA - JJZ
            IF ( JJN .LT. 0 .OR. JJZ .LT. 0 ) THEN
               Q (K) = Q (K-1)
               GO TO 2100
            END IF
            Q (K) = MAX ( U + ENERG0 - DT_ENERGY( DBLE(JJA), DBLE(JJZ) )
     &            - EXMASS (K), ZERZER ) + Q (K-1)
 2100    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
c  |  +----------------------------------------------------------------*
c  |  |  If no emission channel is open then return
         IF ( Q (6) .LE. ZERZER ) THEN
            HEVSUM = SMOM1(3) + SMOM1(5) + SMOM1(6) + SMOM1(4)
            RETURN
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         V = DT_RNDM(V)
         FACT = ONEONE
c  |  +----------------------------------------------------------------*
c  |  |
         DO 2200 J = 1, 6
c  |  |  +-------------------------------------------------------------*
c  |  |  |
            IF ( V .LT. Q (J) / Q (6) ) THEN
               JEMISS = J
               JJA    = JA - IA (JEMISS)
               JJZ    = JZ - IZ (JEMISS)
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |
               DO 2150 JJ = 1, 6
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |
                  IF ( JJA .EQ. IA (JJ) .AND. JJZ .EQ. IZ (JJ) ) THEN
                     JRESID = JJ
                     RNMASS = ZMASS (JRESID)
                     ERNCM  = HLFHLF * ( UMO2 + Z2MASS (JRESID)
     &                      - Z2MASS (JEMISS) ) / UMO
                     EEPCM  = UMO - ERNCM
                     U = ZERZER
                     GO TO 2600
                  END IF
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
 2150          CONTINUE
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
               AJJA   = DBLE (JJA)
               ZJJZ   = DBLE (JJZ)
               RNMAS0 = AJJA * AMUMEV + DT_ENERGY( AJJA, ZJJZ )
               GO TO 2300
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
 2200    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
         WRITE ( ErrorOut,
     * * )' **** error in Dres, few nucleon treatment',
     &                     ' ****'
         WRITE ( ErrorOut,
     * * )' **** error in Dres, few nucleon treatment',
     &                     ' ****'
         RETURN
c  |  +----------------------------------------------------------------*
c  |  | Loop to compute the residual excitation energy
 2300    CONTINUE
            FACT = FACT * AJJA / A
            U = FACT * ( Q (JEMISS) - Q (JEMISS-1) )
c  |  | Erncm, Eepcm are the total energies of the residual
c  |  | nucleus and of the emitted particle in the CMS frame
            RNMASS = RNMAS0 + U
            ERNCM  = HLFHLF * ( UMO2 + RNMASS**2
     &             - Z2MASS (JEMISS) ) / UMO
            EEPCM  = UMO - ERNCM
         IF ( EEPCM .LE. ZMASS (JEMISS) ) THEN
            IF ( Q (JEMISS) - Q (JEMISS-1) .GE. 1.D-06 ) GO TO 2300
c  |  +--<--<--<--<--<--< Loop back
c  |  |  Actually there is no excitation energy available!
            U = ANGLGB
            RNMASS = ONEPLS * RNMAS0
            ERNCM  = ONEPLS * RNMASS
            EEPCM  = ONEPLS * ZMASS (JEMISS)
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         GO TO 2600
c  |  From here standard two bodies kinematics with Jemiss, Rnmass
c  |  (new excitation energy is U)
 2500    CONTINUE
c  |  Erncm, Eepcm are the total energies of the residual
c  |  nucleus and of the emitted particle in the CMS frame
         ERNCM = HLFHLF * ( UMO2 + RNMASS**2 - Z2MASS (JEMISS) ) / UMO
         EEPCM = UMO - ERNCM
 2600    CONTINUE
c  |  C(i) are the direction cosines of the emitted particle
c  |  (Jemiss) in the CMS frame, of course - C(i)
c  |  are the ones of the residual nucleus (Jresid if one of the
c  |  standard partcles, say the proton)
         CALL DT_RACO(C(1),C(2),C(3))
         PCMS  = SQRT ( EEPCM**2 - Z2MASS (JEMISS) )
c  |  Now we perform the Lorentz transformation back to the original
c  |  frame (lab frame)
c  |  First the emitted particle:
         ETAX  = ETACM * COSLBR (1)
         ETAY  = ETACM * COSLBR (2)
         ETAZ  = ETACM * COSLBR (3)
         PCMSX = PCMS * C (1)
         PCMSY = PCMS * C (2)
         PCMSZ = PCMS * C (3)
         ETAPCM= PCMSX * ETAX + PCMSY * ETAY + PCMSZ * ETAZ
         EPS   = GAMCM * EEPCM + ETAPCM - ZMASS (JEMISS)
         PHELP = ETAPCM / ( GAMCM + ONEONE ) + EEPCM
         PLBPX = PCMSX + ETAX * PHELP
         PLBPY = PCMSY + ETAY * PHELP
         PLBPZ = PCMSZ + ETAZ * PHELP
         PHELP = SQRT (PLBPX * PLBPX + PLBPY * PLBPY + PLBPZ * PLBPZ)
         COSLBP (1) = PLBPX / PHELP
         COSLBP (2) = PLBPY / PHELP
         COSLBP (3) = PLBPZ / PHELP
c  |  Then the residual nucleus ( for it c (i) --> - c (i) ):
         EREC  = GAMCM  * ERNCM - ETAPCM - RNMASS
         EKRES = EMVGEV * EREC
         PHELP = - ETAPCM / ( GAMCM + ONEONE ) + ERNCM
         PXRES = EMVGEV * ( - PCMSX + ETAX * PHELP )
         PYRES = EMVGEV * ( - PCMSY + ETAY * PHELP )
         PZRES = EMVGEV * ( - PCMSZ + ETAZ * PHELP )
         P2RES = PXRES * PXRES + PYRES * PYRES + PZRES * PZRES
         PTRES = SQRT (P2RES)
         COSLBR (1) = PXRES / PTRES
         COSLBR (2) = PYRES / PTRES
         COSLBR (3) = PZRES / PTRES
c  |  Score the emitted particle
         NPART (JEMISS) = NPART (JEMISS) + 1
         SMOM1 (JEMISS) = SMOM1 (JEMISS) + EPS
c        IF ( NPART(JEMISS) .LE. 0 ) CALL ERROR
         ITEMP  =NPART(JEMISS)
         EPART (ITEMP,JEMISS)   = EPS
         COSEVP(1,ITEMP,JEMISS) = COSLBP(1)
         COSEVP(2,ITEMP,JEMISS) = COSLBP(2)
         COSEVP(3,ITEMP,JEMISS) = COSLBP(3)
c  |  +----------------------------------------------------------------*
c  |  |  Check if the residual nucleus is one of the emitted particles
         IF ( JRESID .GT. 0 ) THEN
            J = JRESID
            GO TO 6102
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         JA = JA - IA (JEMISS)
         JZ = JZ - IZ (JEMISS)
c Umo is the invariant mass of the system!!
         UMO  = RNMASS
         UMO2 = UMO * UMO
         ELBTOT  = RNMASS + EREC
         GAMCM   = ELBTOT / RNMASS
         ETACM   = GEVMEV * PTRES / RNMASS
         GO TO 1000
      END IF
c  |
c  +-------------------------------------------------------------------*
c Come to 23 at the beginning and after the end of a "normal"
c evaporation cycle
   23 CONTINUE
      A      = DBLE (JA)
      Z      = DBLE (JZ)
      IF ( LCFRBK .AND. JA .LE. NXAFBK .AND. JA - JZ .LE. NXNFBK .AND.
     &     JZ .LE. NXZFBK ) GO TO 1000
      LCFRBK = LFRMBK
c No need for the following card!!! Break up 8-Be if and only if there
c is no other open channel for it!!!
c     IF (JA.EQ.8.AND.JZ.EQ.4) GO TO 1224
c-->-->-->-->--> go to 8-Be breakup:
c  +-------------------------------------------------------------------*
c  |  Loop on possible evaporation products to compute the reaction
c  |  Qs:
      DO 2 J = 1, NEVPRD
         IF( JA - FLA(J) .LE. JZ - FLZ(J) ) THEN
            Q(J)=99999.D+00
         ELSE IF ( JA .LT. 2 * IA (J) ) THEN
            Q(J)=99999.D+00
         ELSE IF ( JZ .LT. 2 * IZ (J) ) THEN
            Q(J)=99999.D+00
         ELSE
            Q (J) = DT_QNRG(A-FLA(J),Z-FLZ(J),A,Z) + EXMASS (J)
c           Q (J) = DT_ENERGY(A-FLA(J),Z-FLZ(J)) - DT_ENERGY(A,Z)
c    &            + EXMASS (J)
         END IF
    2 CONTINUE
c  |
c  +-------------------------------------------------------------------*
      FLKCOU(1)=ZERZER
      FLKCOU(2)=DT_DOST(1,Z-FLZ(2))
      FLKCOU(3)=FLKCOU(2)+.06D+00
      FLKCOU(4)=FLKCOU(2)+.12D+00
      FLKCOU(6)=DT_DOST(2,Z-FLZ(6))
      FLKCOU(5)=FLKCOU(6)-.06D+00
      CCOUL (1)=ONEONE
      CCOU2    =DT_DOST(3,Z-FLZ(2))
      CCOUL(2)=CCOU2+ONEONE
      CCOUL(3)=CCOU2*1.5D0+THRTHR
      CCOUL(4)=CCOU2+THRTHR
      CCOUL(6)=DT_DOST(4,Z-FLZ(6))*TWOTWO+TWOTWO
      CCOUL(5)=TWOTWO*CCOUL(6)-ONEONE
      SIGMA   =ZERZER
c  Initialize the flag which checks for open particle decay with
c  zero excitation and pairing --> for particle unstable residual
c  nuclei
      LOPPAR = .FALSE.
      SES    = ZERZER
c  +-------------------------------------------------------------------*
c  |  Loop on possible evaporation products:
      DO 33 J = 1, NEVPRD
c  |  Final nucleus A:
         AA  = A  - FLA(J)
c  |  Final nucleus Z:
         ZZ  = Z  - FLZ(J)
         IAA = NINT (AA)
         IZZ = NINT (ZZ)
c  |  +----------------------------------------------------------------*
c  |  |  Avoid double counting of the same break-up configuration,
c  |  |  the evaporated fragment must be the lightest one:
c  |  |  (Is it really correct? Anyway it is no longer operational
c  |  |  with the Fermi break-up activated)
c  |  |  The last condition is really important! (added by A.Ferrari)
         IF ( JA .GE. 2 * IA (J) .AND. JZ .GE. 2 * IZ (J) .AND. JA .GT.
     &        JZ .AND. IAA .GE. IZZ ) THEN
c  |  |  Coulomb barrier:
            COUTHR     = 0.88235D+00 * FLKCOU (J) * FLZ (J)
     &                 * ZZ / ( RMASS (IAA) + RHO (J) )
c  |  |  Energy threshold for the emission of the jth-particle
            THRESH (J) = Q (J) + COUTHR
c  |  |  The residual nucleus excitation energy should range from 0
c  |  |  up to U - Q (J), but because of the Coulomb barrier for
c  |  |  charged particles which sets a minimum kinetic energy, it
c  |  |  actually goes from 0 to U - THRESH (J)
c  |  |  Maximum excitation energy of the residual nucleus:
            UMXRES = U - THRESH (J)
c  |  |  Flag for (possible) particle emission:
c  This card allows the 2nd trial (=no pairing) every time the
c  current residual nucleus ground state is particle unstable fully
c  accounting for the Coulomb barrier
c           LOPPAR = LOPPAR .OR. THRESH (J) .LT. ZERZER
c  This card allows the 2nd trial (=no pairing) every time the
c  emission channel is energetically open
c           LOPPAR = LOPPAR .OR. UMXRES .GT. ZERZER
c  This card allows the 2nd trial (=no pairing) every time the
c  current residual nucleus ground state is particle unstable
c  accounting for a possible Coulomb barrier penetration of 1.5 MeV
            LOPPAR = LOPPAR .OR. Q (J) + MAX ( COUTHR - 1.5D+00,
     &               ZERZER ) .LT. ZERZER
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Energy available for emission:
            IF ( UMXRES .GE. ZERZER ) THEN
               NN     = IAA - IZZ
               ILVMOD = IB0
c  |  |  |  This is the a lower case of the level density
               SMALLA (J) = DT_GETA( UMXRES, IZZ, NN, ILVMOD, ISDUM,
     &                             ASMMAX, ASMMIN )
c  **** Old coding ****
c              IF (IB0.NE.1) THEN
c                 APRIM = AA/B0
c              ELSE
c                 APRIM = APRIME(IAA)
c              END IF
c              SMALLA(J)=(1.D0+Y0*(AA-2.D0*ZZ)**2/AA**2)*APRIM
c  **** End old coding ****
c  |  |  |  Get the discrete levels and pairing energies:
               CALL DT_EEXLVL( IAA, IZZ, EEX1ST, EEX2ND, CORR )
c  |  |  |  Convert to MeV:
               EEX1ST = GEVMEV * EEX1ST
               EEX2ND = GEVMEV * EEX2ND
               CORR   = GEVMEV * MAX ( CORR, ZERZER )
c Old version:
c              CORR   = CAM4 (IZZ) + CAM5 (NN)
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  This patch just to avoid problems with 8-Be
               IF ( NN .EQ. 4 .AND. IZZ .EQ. 4 ) THEN
                  IF ( U - THRESH (J) - 6.1D+00 .GT. ZERZER ) THEN
                     CORR = SIXSIX
                  ELSE
                     CORR = MAX ( ZERZER, U-THRESH(J)-0.1D+00 )
                  END IF
               END IF
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  Check the flag for switching off the backshift:
               IF ( IFKEY .EQ. 1 ) CORR = ZERZER
c  |  |  |  Save the backshift:
               CORRRR (J) = CORR
c  |  |  |  Standard calculation:
               ARG = U - THRESH (J) - CORR
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  No energy available for emission:
            ELSE
               ARG = -ONEONE
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  +-------------------------------------------------------------*
c  |  |  |  No chance to emit this particle:
            IF ( ARG .LE. ZERZER ) THEN
               R  (J) = ZERZER
               S  (J) = ZERZER
               SOS(J) = ZERZER
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |
            ELSE
               S   (J) = SQRT (SMALLA(J)*ARG) * TWOTWO
               SOS (J) = TENTEN * S(J)
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  A_res < 2 A(j), or Z_res < 2 Z(j), avoid double counting etc.
         ELSE
            R  (J) = ZERZER
            S  (J) = ZERZER
            SOS(J) = ZERZER
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         SES = MAX ( SES, S (J) )
   33 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c     N1=1
c     DO 4002 J=1,NEVPRD
c        IF(SOS(J)-1250.D0)4002,4444,4444
c4002 CONTINUE
c     N1=2
c     GO TO 4003
c4444 CONTINUE
c     SES = MAX (S(1),S(2),S(3),S(4),S(5),S(6))
c4003 CONTINUE
c     SES = MAX (S(1),S(2),S(3),S(4),S(5),S(6))
      N1  = 1
      DO 1131 J = 1, NEVPRD
         JS  = SOS(J) + ONEONE
         FJS = JS
         STRUN(J) = FJS - ONEONE
         IF ( S(J) .GT. ZERZER ) THEN
            MM  = JA-IA(J)
c*sr avoid floating point underflows
C           SAS = EXP (S(J)-SES)
            IF (ABS(S(J)-SES).LT.ANGLGB) THEN
               SAS = 1.0D0
            ELSEIF ((S(J)-SES).LT.EZRZRZ) THEN
               SAS = 0.0D0
            ELSE
               SAS = EXP (S(J)-SES)
            ENDIF
C           SUS = EXP (-S(J))
            IF (-S(J).LT.LOG(ANGLGB)) THEN
               SUS = 0.0D0
            ELSE
               SUS = EXP (-S(J))
            ENDIF
c*
            EYE1(J) = ( TWOTWO * S(J)**2 -SIXSIX * S(J)
     &              + SIXSIX + SUS * ( S(J)**2 - SIXSIX ) )
     &              / ( EIGEIG * SMALLA(J)**2 )
            IF ( J .EQ. 1 ) THEN
               EYE0(J) = ( S(J) - ONEONE + SUS ) / ( TWOTWO*SMALLA(J) )
c Standard calculation
               R   (J) = RMASS(MM)**2 * ALPH(MM) * ( EYE1(J) + BET(MM)
     &                 * EYE0(J) ) * SAS
            ELSE
               R   (J) = CCOUL(J) * RMASS(MM)**2 * EYE1(J) * SAS
            END IF
            R (J) = MAX ( ZERZER, R (J) )
            SIGMA = SIGMA + R (J)
         END IF
 1131 CONTINUE
c     DO 1131 J=1,NEVPRD
c        IF(S(J))1511,1131,1511
c1511    CONTINUE
c        JS=SOS(J)+1.D0
c        MM=JA-IA(J)
c        IF(N1-1)1751,1350,1751
c1751    CONTINUE
c        IF(JS-1000)1344,1351,1351
c1350    CONTINUE
c        SAS=EXP (S(J)-SES)
c        GO TO 1352
c1351    CONTINUE
c        SAS=EXP (S(J)-50.D0)
c1352    CONTINUE
c        EYE1(J)=(S(J)**2-3.D0*S(J)+3.D0)*SAS/(4.D0*SMALLA(J)**2)
c        FJS=JS
c        STRUN(J)=FJS-1.D0
c        GO TO 2323
c1344    CONTINUE
c        FJS=JS
c        STRUN(J)=FJS-1.D0
c        EYE1(J)=(P1(JS)+(P1(JS+1)-P1(JS))*(SOS(J)-STRUN(J)))/
c    &   SMALLA(J)**2
c2323    IF(J-1)6,6,7
c   7    CONTINUE
c        R(J)=CCOUL(J)*RMASS(MM)**2*EYE1(J)
c        GO TO 3
c   6    CONTINUE
c        IF(N1-1)7777,2345,7777
c7777    CONTINUE
c        IF(JS-1000)2344,2345,2345
c2345    CONTINUE
c        EYE0(J)=(S(J)-1.D0)*0.5D0*SAS/SMALLA(J)
c        GO TO 2346
c2344    CONTINUE
c        EYE0(J)=(P0(JS)+(P0(JS+1)-P0(JS))*(SOS(J)-STRUN(J)))
c    &   /SMALLA(J)
c2346    CONTINUE
c        R(J)=RMASS(MM)**2*ALPH(MM)*(EYE1(J)+BET(MM)*
c    &   EYE0(J))
c        IF(R(J))5111,3,3
c5111    CONTINUE
c        R(J)=0.D0
c   3    CONTINUE
c        SIGMA=SIGMA+R(J)
c1131 CONTINUE
      NCOUNT = 0
 6202 CONTINUE
c  +-------------------------------------------------------------------*
c  |  No open channel available:
      IF ( SIGMA .LE. ZERZER ) THEN
c  |  +----------------------------------------------------------------*
c  |  |  Check if the residual nucleus is one of the six originally
c  |  |  available particles for evaporation:
         DO 6100 J = 1, 6
c  |  |  The residual nucleus is a p/n/d/3-H/3-He/4-He one:
            IF ( JA .EQ. IA (J) .AND. JZ .EQ. IZ (J) ) GO TO 6102
 6100    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
c  |  Non p/n/d/3-H/3-He/4-He residual nucleus:
c  |  Check for 8-Be:
         IF (JA.EQ.8.AND.JZ.EQ.4) GO TO 1224
c  |-->-->-->-->--> go to 8-Be breakup
         GO TO 72
c  |-->-->-->-->--> go to return
c  |
c  +-------------------------------------------------------------------*
c  |  Sigma non zero
      ELSE
         GO TO 10
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  The residual nucleus is a p/n/d/3-H/3-He/4-He one:
 6102 CONTINUE
         IF ( U .GT. ANGLGB ) GO TO 1000
         JEMISS = J
c  | **** Store,residual nucleus is of emitted particle type ***
c  | If we are here this means that the residual nucleus is equal to
c  | one of the six emitted particle (the j-th one). So give to it
c  | all the energy, score it and return with 0 recoil and excitation
c  | energy for the residual nucleus
         EPS = EREC
         NPART(JEMISS) = NPART(JEMISS)+1
         ITEMP=NPART(JEMISS)
         NRNEEP = NRNEEP + 1
         SMOM1(JEMISS) = SMOM1(JEMISS) + EPS
         ITEMP=NPART(JEMISS)
         EPART(ITEMP,JEMISS)=EPS
         COSEVP(1,ITEMP,JEMISS) = COSLBR(1)
         COSEVP(2,ITEMP,JEMISS) = COSLBR(2)
         COSEVP(3,ITEMP,JEMISS) = COSLBR(3)
      GO TO 8002
c  |-->-->-->-->--> go to return
c  +-------------------------------------------------------------------*
c Come here for a "normal" step
   10 CONTINUE
      LOPPAR = .FALSE.
      URAN   = DT_RNDM(URAN) * SIGMA
      SUM    = ZERZER
      DO 16 J=1,NEVPRD
         K   = J
         SUM = R(J)+SUM
         IF ( SUM - URAN .GT. ZERZER ) GO TO 17
   16 CONTINUE
      K = NEVPRD
   17 CONTINUE
      JEMISS=K
      NPART(JEMISS) = NPART (JEMISS) + 1
      JS = SOS (JEMISS) + ONEONE
      IF ( JS .GE. 1000 ) THEN
         RATIO2=(S(JEMISS)**3-6.D0*S(JEMISS)**2+15.D0*
     &   S(JEMISS)-15.D0)/((2.D0*S(JEMISS)**2-6.D0*S(JEMISS)+6.D0)
     &   *SMALLA(JEMISS))
      ELSE
         RATIO2=(P2(JS)+(P2(JS+1)-P2(JS))*
     &   (SOS(JEMISS)-STRUN(JEMISS)))/SMALLA(JEMISS)
      END IF
      EPSAV = RATIO2*TWOTWO
c  +-------------------------------------------------------------------*
c  |  Neutron channel selected:
      IF (JEMISS .EQ. 1) THEN
         MM   =JA-IA(J)
         EPSAV=(EPSAV+BET(MM))/(ONEONE+BET(MM)*EYE0(JEMISS)
     &        /EYE1(JEMISS))
c  |  +----------------------------------------------------------------*
c  |  |  Compute the fission width relative to the neutron one:
c  |  |  this part is taken from subroutine EMIT of LAHET
         IF ( IFISS .GT. 0 .AND. JZ .GE. IZFSMX .AND. .NOT. FISINH) THEN
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Compute the correction factor for the fission width:
            IF ( JZ .GT. 88 ) THEN
               AGOES = ONEONE
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |
            ELSE
c*sr modified to get proper fission xsection
C              IF ( LAGOES ) THEN
C                 AGOES = MAX ( ONEONE, ( U-SEVSEV ) / ( EPSAV+SEVSEV) )
C              ELSE
C                 AGOES = ONEONE
C              END IF
               AGOES = MAX ( ONEONE,  U/EPSAV*2.0D0 )
c*
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  Finally this is the relative fission width:
c  |  |  This is : Probfs = 1 / ( 1 + G_n / G_f )
            PROBFS = DT_FPROB( Z, A, U ) / AGOES
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Check if it will be fission:
            IF ( DT_RNDM(AGOES) .LT. PROBFS ) THEN
               FISINH = .TRUE.
               KFISS  = 1
c  |  |  |  Undo the counting of the neutron evaporation
               NPART (JEMISS) = NPART (JEMISS) - 1
               GO TO 9260
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
      END IF
c  |
c  +-------------------------------------------------------------------*
c  A. Ferrari: exprnf eliminated
c   20 E1=EXPRNF(V)/2.D0
c      E2=EXPRNF(V)/2.D0
  20  CONTINUE
      E1=-HLFHLF*LOG(DT_RNDM(E1))
      E2=-HLFHLF*LOG(DT_RNDM(E2))
c Eps should be the total kinetic energy in the CMS frame
c Standard calculation:
      EPS=(E1+E2)*EPSAV+THRESH(JEMISS)-Q(JEMISS)
      AR = A - DBLE (IA(JEMISS))
      ZR = Z - DBLE (IZ(JEMISS))
c The CMS energy is updated
      IMASS = NINT (AR)
      IF ( IMASS .EQ. 8 .AND. NINT (ZR) .EQ. 4 ) THEN
         UNEW = U - EPS - Q(JEMISS)
         UMAX = U - THRESH(JEMISS)
         IF ( UNEW .GT. 6.D+00 ) THEN
            UMIN = 6.D+00
         ELSE IF ( UNEW .GT. 4.47D+00 .AND. UMAX .GT. 6.D+00 ) THEN
            UMIN = 4.47D+00
            UNEW = 6.D+00
         ELSE IF ( UNEW .GT. 1.47D+00 .AND. UMAX .GT. 2.94D+00 ) THEN
            UMIN = 1.47D+00
            UNEW = 2.94D+00
         ELSE
            UMIN = -0.1D+00
            UNEW = ANGLGB * 0.1D+00
         END IF
      ELSE IF ( IMASS .LE. 4 ) THEN
         IPRO = NINT ( ZR )
         INEU = IMASS - IPRO
         IF ( IMASS .EQ. 1 ) THEN
c  Be sure that residual neutrons or protons are not left excited
            UMIN = ZERZER
            UNEW = ZERZER
            EPS  = U - Q(JEMISS)
         ELSE IF ( IPRO .EQ. 0 .OR. INEU .EQ. 0 ) THEN
c  Ipro protons or ineu neutrons arrived here!
            UMIN = CORRRR(JEMISS)
            UNEW = U - EPS - Q(JEMISS)
         ELSE IF ( IMASS .LE. 2 ) THEN
c  Be sure that residual deuterons are not left excited!
            UMIN = ZERZER
            UNEW = ZERZER
            EPS  = U - Q(JEMISS)
         ELSE IF ( ABS ( INEU - IPRO ) .LE. 1 ) THEN
c  For the moment also residual 3-H, 3-He and 4-He are not left
c  excited !
            UMIN = ZERZER
            UNEW = ZERZER
            EPS  = U - Q(JEMISS)
         ELSE
            UMIN = CORRRR(JEMISS)
            UNEW = U - EPS - Q(JEMISS)
         END IF
      ELSE
         UMIN = CORRRR(JEMISS)
         UNEW = U - EPS - Q(JEMISS)
      END IF
c Standard calculation
c     IF (UNEW) 6200,6220,6220
c New calculation (it should be at least equal to delta to be consistent
c with )
      IF(UNEW-UMIN)6200,6220,6220
 6220 CONTINUE
c The following two cards have been slightly modified
c     BE     = ZR * EMHN + AR * EMNUM - DT_ENERGY(AR,ZR)
c     RNMASS = ZR * EMH  + ( AR - ZR ) * EMN - BE
cor   RNMASS = AR * AMUMEV + DT_ENERGY(AR,ZR)
      RNMASS = AR * AMUMEV + DT_ENERGY(AR,ZR) + UNEW
      UMIN2  = ( RNMASS + ZMASS (JEMISS) )**2
      IF ( UMIN2 .GE. UMO2 ) THEN
         GO TO 6200
      END IF
      U = UNEW
c C(i) are the direction cosines of the evaporated particle in the CMS
c frame, of course - C(i) are the ones of the residual nucleus
      CALL DT_RACO(C(1),C(2),C(3))
c Erncm, Eepcm are the total energies of the residual nucleus and
c of the evaporated particle in the CMS frame
      ERNCM = HLFHLF * ( UMO2 + RNMASS**2 - Z2MASS (JEMISS) ) / UMO
      EEPCM = UMO - ERNCM
      PCMS  = SQRT ( EEPCM**2 - Z2MASS (JEMISS) )
c Now we perform the Lorentz transformation back to the original
c frame (lab frame)
c First the evaporated particle:
      ETAX  = ETACM * COSLBR (1)
      ETAY  = ETACM * COSLBR (2)
      ETAZ  = ETACM * COSLBR (3)
      PCMSX = PCMS * C (1)
      PCMSY = PCMS * C (2)
      PCMSZ = PCMS * C (3)
      ETAPCM = PCMSX * ETAX + PCMSY * ETAY + PCMSZ * ETAZ
      EPS = GAMCM * EEPCM + ETAPCM - ZMASS (JEMISS)
      PHELP = ETAPCM / (GAMCM + ONEONE) + EEPCM
      PLBPX = PCMSX + ETAX * PHELP
      PLBPY = PCMSY + ETAY * PHELP
      PLBPZ = PCMSZ + ETAZ * PHELP
      PHELP = SQRT (PLBPX * PLBPX + PLBPY * PLBPY + PLBPZ * PLBPZ)
      COSLBP (1) = PLBPX / PHELP
      COSLBP (2) = PLBPY / PHELP
      COSLBP (3) = PLBPZ / PHELP
c Then the residual nucleus ( for it c (i) --> - c (i) ):
      EREC  = GAMCM * ERNCM - ETAPCM - RNMASS
      EKRES = EMVGEV * EREC
      PHELP = - ETAPCM / (GAMCM + ONEONE) + ERNCM
      PXRES = EMVGEV * ( - PCMSX + ETAX * PHELP )
      PYRES = EMVGEV * ( - PCMSY + ETAY * PHELP )
      PZRES = EMVGEV * ( - PCMSZ + ETAZ * PHELP )
      P2RES = PXRES * PXRES + PYRES * PYRES + PZRES * PZRES
      PTRES = SQRT (P2RES)
      COSLBR (1) = PXRES / PTRES
      COSLBR (2) = PYRES / PTRES
      COSLBR (3) = PZRES / PTRES
c Check energy and momentum conservation !!
      IF (EREC .LE. ZERZER) THEN
         PTRES = ZERZER
         EREC  = ZERZER
      END IF
c Umo is the invariant mass of the system!!
      UMO  = RNMASS
      UMO2 = UMO * UMO
      ELBTOT  = RNMASS + EREC
      GAMCM   = ELBTOT / RNMASS
      ETACM   = 1.D+03 * PTRES / RNMASS
      GO TO 76
 6200 CONTINUE
      NCOUNT = NCOUNT + 1
      IF ( NCOUNT .LE. 10 ) GO TO 20
      SIGMA = SIGMA - R(JEMISS)
c if we are here we have sampled for > 10 times a negative energy Unew
      NPART(JEMISS)=NPART(JEMISS)-1
      R(JEMISS) = ZERZER
      NCOUNT = 0
      GO TO 6202
   76 CONTINUE
      JAT=JA-IA(JEMISS)
      JZT=JZ-IZ(JEMISS)
      IF(JAT.LE.JZT)THEN
         SIGMA = ZERZER
         GO TO 6202
      END IF
      JA=JAT
      JZ=JZT
C*****STORE,END OF NORMAL CYCLE
      SMOM1(JEMISS)=SMOM1(JEMISS)+EPS
c     IF(NPART(JEMISS).LE.0)CALL ERROR
      ITEMP=NPART(JEMISS)
      EPART(ITEMP,JEMISS)=EPS
      COSEVP(1,ITEMP,JEMISS)=COSLBP(1)
      COSEVP(2,ITEMP,JEMISS)=COSLBP(2)
      COSEVP(3,ITEMP,JEMISS)=COSLBP(3)
c The following card switch to the rough splitting treatment
      IF (JA .LE. 2) GO TO 1000
      IF (JA .NE. 8 .OR. JZ .NE. 4) GO TO 23
c If we are here the residual nucleus is a 8-Be one, break it into
c two alphas with all the available energy (U plus the Q of the breakup)
c , score them and return with 0 recoil and excitation energy
 1224 CONTINUE
      LOPPAR = .FALSE.
      IF (U .LT. ZERZER ) THEN
         EPS = ZERZER
      ELSE
      END IF
      NBE8 = NBE8 + 1
c C(i) are the direction cosines of the first alpha in the CMS
c frame, of course - C(i) are the ones of the other
      CALL DT_RACO(C(1),C(2),C(3))
c Ecms is the total energy of the alphas in the CMS frame
      ECMS  = HLFHLF * UMO
      PCMS  = SQRT ( ( ECMS - ZMASS (6) ) * ( ECMS + ZMASS (6) ) )
c Now we perform the Lorentz transformation back to the original
c frame (lab frame)
c First alpha:
      ETAX  = ETACM * COSLBR (1)
      ETAY  = ETACM * COSLBR (2)
      ETAZ  = ETACM * COSLBR (3)
      PCMSX = PCMS * C (1)
      PCMSY = PCMS * C (2)
      PCMSZ = PCMS * C (3)
      ETAPCM = PCMSX * ETAX + PCMSY * ETAY + PCMSZ * ETAZ
      EPS   = GAMCM * ECMS + ETAPCM - ZMASS (6)
      PHELP = ETAPCM / (GAMCM + ONEONE) + ECMS
      PLBPX = PCMSX + ETAX * PHELP
      PLBPY = PCMSY + ETAY * PHELP
      PLBPZ = PCMSZ + ETAZ * PHELP
      PHELP = SQRT (PLBPX * PLBPX + PLBPY * PLBPY + PLBPZ * PLBPZ)
c Store the first alpha!!
      SMOM1(6) = SMOM1(6) + EPS
      NPART(6) = NPART(6) + 1
      ITEMP = NPART(6)
      EPART (ITEMP,6) = EPS
      COSEVP (1,ITEMP,6) = PLBPX / PHELP
      COSEVP (2,ITEMP,6) = PLBPY / PHELP
      COSEVP (3,ITEMP,6) = PLBPZ / PHELP
c Then the second alpha ( for it c (i) --> - c (i) ):
      EPS   = GAMCM * ECMS - ETAPCM - ZMASS (6)
      PHELP = - ETAPCM / (GAMCM + ONEONE) + ECMS
      PLBPX = - PCMSX + ETAX * PHELP
      PLBPY = - PCMSY + ETAY * PHELP
      PLBPZ = - PCMSZ + ETAZ * PHELP
      PHELP = SQRT (PLBPX * PLBPX + PLBPY * PLBPY + PLBPZ * PLBPZ)
c Store the second alpha !!
      SMOM1(6) = SMOM1(6) + EPS
      NPART(6) = NPART(6) + 1
      ITEMP = NPART(6)
      EPART (ITEMP,6) = EPS
      COSEVP (1,ITEMP,6) = PLBPX / PHELP
      COSEVP (2,ITEMP,6) = PLBPY / PHELP
      COSEVP (3,ITEMP,6) = PLBPZ / PHELP
 8002 CONTINUE
      LOPPAR = .FALSE.
      EREC   = ZERZER
      U      = ZERZER
      EKRES  = ZERZER
      PTRES  = ZERZER
   72 CONTINUE
      HEVSUM = SMOM1 (3) + SMOM1 (5) + SMOM1 (6) + SMOM1 (4)
      RETURN
c.......................................................................
c///// RAL FISSION ROUTINE /////
 9260 CONTINUE
c  +-------------------------------------------------------------------*
c  |  Record the direction cosines of the fissioning nucleus
      DO 9270 I=1,3
         COSLF0 (I) = COSLBR (I)
 9270 CONTINUE
c  |
c  +-------------------------------------------------------------------*
      CALL DT_FISFRA( JA, JZ, U, EREC, UMO, GAMCM, ETACM )
c  +-------------------------------------------------------------------*
c  |  Check for fission failures!!
      IF ( .NOT. FISINH ) THEN
         PENBAR = .FALSE.
         GO TO 23
      END IF
c  |
c  +-------------------------------------------------------------------*
c  Do not pick up the fission fragments, rather go back to Evevap
      HEVSUM = SMOM1 (3) + SMOM1 (5) + SMOM1 (6) + SMOM1 (4)
c  Be sure that no 2nd step without pairing corrections will be tried
      LOPPAR = .FALSE.
      IFKEY  = 1
      RETURN
c=== Dres95 ===========================================================*
      END

c*sr 20.4.98 evap =====================================================*
c*sr 30.6.
c DBLPRC,DIMPAR,IOUNIT,FINUC,RESNUC,NUCGEO,NUCLEV,PARNUC,HIGFIS,
c PART,NCDNVP replaced
c*
c$ CREATE BDEVAP.FOR
cCOPY BDEVAP
c
c=== bdevap ===========================================================*
c
CDECK  ID>, DT_BDEVAP
      BLOCK DATA DT_BDEVAP

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     Block Data for the EVAPoration routines:                         *
c                                                                      *
c     Created on    20 may 1990    by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Modified from the original version of J.M.Zazula                 *
c     and, for cookcm, from a LAHET block data kindly provided by      *
c     R.E.Prael-LANL                                                   *
c                                                                      *
c     Last change on  20-feb-95    by    Alfredo Ferrari               *
c                                                                      *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: COOKCM)
      PARAMETER ( ASMTOG = SIXSIX / PIPIPI**2 )
      LOGICAL LDEFOZ, LDEFON
      PARAMETER ( INCOOK = 150, IZCOOK = 98 )
      COMMON /FKCOOK/ ALPIGN, BETIGN, GAMIGN, POWIGN,
     &                SZCOOK (IZCOOK), SNCOOK (INCOOK), PZCOOK (IZCOOK),
     &                PNCOOK (INCOOK), LDEFOZ (IZCOOK), LDEFON (INCOOK)

c (original name: EVA0)
      COMMON /FKEVA0/ Y0, B0, P0 (1001), P1 (1001), P2 (1001),
     *                FLA (6), FLZ (6), RHO (6), OMEGA (6), EXMASS (6),
     *                CAM2 (130), CAM3 (200), CAM4 (130), CAM5 (200),
     *                T (4,7), RMASS (297), ALPH (297), BET (297),
     *                APRIME (250), IA (6), IZ (6)

c (original name: HETTP)
      COMMON /FKHETP/  NHSTP,NBERTP,IOSUB,INSRS

c (original name: HETC7)
      COMMON /FKHET7/ COSKS,SINKS, COSTH,SINTH, COSPHI,SINPHI

c (original name: INPFLG)
      COMMON /FKINPF/ IANG,IFISS,IB0,IGEOM,ISTRAG,KEYDK

c
      DATA B0   / 8.D+00 /, Y0 / 1.5D+00 /
      DATA IANG / 1 /, IFISS / 1 /,  IB0 / 2 /, IGEOM / 0 /
      DATA ISTRAG /0/, KEYDK /0/
      DATA NBERTP /LUNBER/
      DATA COSTH /ONEONE/, SINTH /ZERZER/, COSPHI /ONEONE/,
     &     SINPHI/ZERZER/
c  /cookcm/
       DATA ( PZCOOK(I),I =  1, IZCOOK ) /
     & 0.000D+00, 5.440D+00, 0.000D+00, 2.760D+00, 0.000D+00, 3.340D+00,
     & 0.000D+00, 2.700D+00, 0.000D+00, 2.500D+00, 0.000D+00, 2.460D+00,
     & 0.000D+00, 2.090D+00, 0.000D+00, 1.620D+00, 0.000D+00, 1.620D+00,
     & 0.000D+00, 1.830D+00, 0.000D+00, 1.730D+00, 0.000D+00, 1.350D+00,
     & 0.000D+00, 1.540D+00, 0.000D+00, 1.280D+00, 2.600D-01, 8.800D-01,
     & 1.900D-01, 1.350D+00,-5.000D-02, 1.520D+00,-9.000D-02, 1.170D+00,
     & 4.000D-02, 1.240D+00, 2.900D-01, 1.090D+00, 2.600D-01, 1.170D+00,
     & 2.300D-01, 1.150D+00,-8.000D-02, 1.350D+00, 3.400D-01, 1.050D+00,
     & 2.800D-01, 1.270D+00, 0.000D+00, 1.050D+00, 0.000D+00, 1.000D+00,
     & 9.000D-02, 1.200D+00, 2.000D-01, 1.400D+00, 9.300D-01, 1.000D+00,
     &-2.000D-01, 1.190D+00, 9.000D-02, 9.700D-01, 0.000D+00, 9.200D-01,
     & 1.100D-01, 6.800D-01, 5.000D-02, 6.800D-01,-2.200D-01, 7.900D-01,
     & 9.000D-02, 6.900D-01, 1.000D-02, 7.200D-01, 0.000D+00, 4.000D-01,
     & 1.600D-01, 7.300D-01, 0.000D+00, 4.600D-01, 1.700D-01, 8.900D-01,
     & 0.000D+00, 7.900D-01, 0.000D+00, 8.900D-01, 0.000D+00, 8.100D-01,
     &-6.000D-02, 6.900D-01,-2.000D-01, 7.100D-01,-1.200D-01, 7.200D-01,
     & 0.000D+00, 7.700D-01/
       DATA ( PNCOOK(I),I =  1, 90 ) /
     & 0.000D+00, 5.980D+00, 0.000D+00, 2.770D+00, 0.000D+00, 3.160D+00,
     & 0.000D+00, 3.010D+00, 0.000D+00, 2.500D+00, 0.000D+00, 2.670D+00,
     & 0.000D+00, 1.800D+00, 0.000D+00, 1.670D+00, 0.000D+00, 1.860D+00,
     & 0.000D+00, 2.040D+00, 0.000D+00, 1.640D+00, 0.000D+00, 1.440D+00,
     & 0.000D+00, 1.540D+00, 0.000D+00, 1.300D+00, 0.000D+00, 1.270D+00,
     & 0.000D+00, 1.290D+00, 8.000D-02, 1.410D+00,-8.000D-02, 1.500D+00,
     &-5.000D-02, 2.240D+00,-4.700D-01, 1.430D+00,-1.500D-01, 1.440D+00,
     & 6.000D-02, 1.560D+00, 2.500D-01, 1.570D+00,-1.600D-01, 1.460D+00,
     & 0.000D+00, 9.300D-01, 1.000D-02, 6.200D-01,-5.000D-01, 1.420D+00,
     & 1.300D-01, 1.520D+00,-6.500D-01, 8.000D-01,-8.000D-02, 1.290D+00,
     &-4.700D-01, 1.250D+00,-4.400D-01, 9.700D-01, 8.000D-02, 1.650D+00,
     &-1.100D-01, 1.260D+00,-4.600D-01, 1.060D+00, 2.200D-01, 1.550D+00,
     &-7.000D-02, 1.370D+00, 1.000D-01, 1.200D+00,-2.700D-01, 9.200D-01,
     &-3.500D-01, 1.190D+00, 0.000D+00, 1.050D+00,-2.500D-01, 1.610D+00,
     &-2.100D-01, 9.000D-01,-2.100D-01, 7.400D-01,-3.800D-01, 7.200D-01/
       DATA ( PNCOOK(I),I = 91, INCOOK ) /
     &-3.400D-01, 9.200D-01,-2.600D-01, 9.400D-01, 1.000D-02, 6.500D-01,
     &-3.600D-01, 8.300D-01, 1.100D-01, 6.700D-01, 5.000D-02, 1.000D+00,
     & 5.100D-01, 1.040D+00, 3.300D-01, 6.800D-01,-2.700D-01, 8.100D-01,
     & 9.000D-02, 7.500D-01, 1.700D-01, 8.600D-01, 1.400D-01, 1.100D+00,
     &-2.200D-01, 8.400D-01,-4.700D-01, 4.800D-01, 2.000D-02, 8.800D-01,
     & 2.400D-01, 5.200D-01, 2.700D-01, 4.100D-01,-5.000D-02, 3.800D-01,
     & 1.500D-01, 6.700D-01, 0.000D+00, 6.100D-01, 0.000D+00, 7.800D-01,
     & 0.000D+00, 6.700D-01, 0.000D+00, 6.700D-01, 0.000D+00, 7.900D-01,
     & 0.000D+00, 6.000D-01, 4.000D-02, 6.400D-01,-6.000D-02, 4.500D-01,
     & 5.000D-02, 2.600D-01,-2.200D-01, 3.900D-01, 0.000D+00, 3.900D-01/
       DATA ( SZCOOK(I),I =  1, 98) /
     & 0.000D+00, 0.000D+00, 0.000D+00, 0.000D+00, 0.000D+00, 0.000D+00,
     & 0.000D+00, 0.000D+00,-1.100D-01,-8.100D-01,-2.910D+00,-4.170D+00,
     &-5.720D+00,-7.800D+00,-8.970D+00,-9.700D+00,-1.010D+01,-1.070D+01,
     &-1.138D+01,-1.207D+01,-1.255D+01,-1.324D+01,-1.393D+01,-1.471D+01,
     &-1.553D+01,-1.637D+01,-1.736D+01,-1.860D+01,-1.870D+01,-1.801D+01,
     &-1.787D+01,-1.708D+01,-1.660D+01,-1.675D+01,-1.650D+01,-1.635D+01,
     &-1.622D+01,-1.641D+01,-1.689D+01,-1.643D+01,-1.668D+01,-1.673D+01,
     &-1.745D+01,-1.729D+01,-1.744D+01,-1.782D+01,-1.862D+01,-1.827D+01,
     &-1.939D+01,-1.991D+01,-1.914D+01,-1.826D+01,-1.740D+01,-1.642D+01,
     &-1.577D+01,-1.437D+01,-1.391D+01,-1.310D+01,-1.311D+01,-1.143D+01,
     &-1.089D+01,-1.075D+01,-1.062D+01,-1.041D+01,-1.021D+01,-9.850D+00,
     &-9.470D+00,-9.030D+00,-8.610D+00,-8.130D+00,-7.460D+00,-7.480D+00,
     &-7.200D+00,-7.130D+00,-7.060D+00,-6.780D+00,-6.640D+00,-6.640D+00,
     &-7.680D+00,-7.890D+00,-8.410D+00,-8.490D+00,-7.880D+00,-6.300D+00,
     &-5.470D+00,-4.780D+00,-4.370D+00,-4.170D+00,-4.130D+00,-4.320D+00,
     &-4.550D+00,-5.040D+00,-5.280D+00,-6.060D+00,-6.280D+00,-6.870D+00,
     &-7.200D+00,-7.740D+00/
       DATA ( SNCOOK(I),I =  1, 90 ) /
     & 0.000D+00, 0.000D+00, 0.000D+00, 0.000D+00, 0.000D+00, 0.000D+00,
     & 0.000D+00, 0.000D+00, 1.030D+01, 5.660D+00, 6.800D+00, 7.530D+00,
     & 7.550D+00, 7.210D+00, 7.440D+00, 8.070D+00, 8.940D+00, 9.810D+00,
     & 1.060D+01, 1.139D+01, 1.254D+01, 1.368D+01, 1.434D+01, 1.419D+01,
     & 1.383D+01, 1.350D+01, 1.300D+01, 1.213D+01, 1.260D+01, 1.326D+01,
     & 1.413D+01, 1.492D+01, 1.552D+01, 1.638D+01, 1.716D+01, 1.755D+01,
     & 1.803D+01, 1.759D+01, 1.903D+01, 1.871D+01, 1.880D+01, 1.899D+01,
     & 1.846D+01, 1.825D+01, 1.776D+01, 1.738D+01, 1.672D+01, 1.562D+01,
     & 1.438D+01, 1.288D+01, 1.323D+01, 1.381D+01, 1.490D+01, 1.486D+01,
     & 1.576D+01, 1.620D+01, 1.762D+01, 1.773D+01, 1.816D+01, 1.867D+01,
     & 1.969D+01, 1.951D+01, 2.017D+01, 1.948D+01, 1.998D+01, 1.983D+01,
     & 2.020D+01, 1.972D+01, 1.987D+01, 1.924D+01, 1.844D+01, 1.761D+01,
     & 1.710D+01, 1.616D+01, 1.590D+01, 1.533D+01, 1.476D+01, 1.354D+01,
     & 1.263D+01, 1.065D+01, 1.010D+01, 8.890D+00, 1.025D+01, 9.790D+00,
     & 1.139D+01, 1.172D+01, 1.243D+01, 1.296D+01, 1.343D+01, 1.337D+01/
       DATA ( SNCOOK(I),I = 91, INCOOK ) /
     & 1.296D+01, 1.211D+01, 1.192D+01, 1.100D+01, 1.080D+01, 1.042D+01,
     & 1.039D+01, 9.690D+00, 9.270D+00, 8.930D+00, 8.570D+00, 8.020D+00,
     & 7.590D+00, 7.330D+00, 7.230D+00, 7.050D+00, 7.420D+00, 6.750D+00,
     & 6.600D+00, 6.380D+00, 6.360D+00, 6.490D+00, 6.250D+00, 5.850D+00,
     & 5.480D+00, 4.530D+00, 4.300D+00, 3.390D+00, 2.350D+00, 1.660D+00,
     & 8.100D-01, 4.600D-01,-9.600D-01,-1.690D+00,-2.530D+00,-3.160D+00,
     &-1.870D+00,-4.100D-01, 7.100D-01, 1.660D+00, 2.620D+00, 3.220D+00,
     & 3.760D+00, 4.100D+00, 4.460D+00, 4.830D+00, 5.090D+00, 5.180D+00,
     & 5.170D+00, 5.100D+00, 5.010D+00, 4.970D+00, 5.090D+00, 5.030D+00,
     & 4.930D+00, 5.280D+00, 5.490D+00, 5.500D+00, 5.370D+00, 5.300D+00/
      DATA LDEFOZ / 53*.FALSE.,25*.TRUE.,7*.FALSE.,13*.TRUE. /
      DATA LDEFON / 85*.FALSE.,37*.TRUE.,7*.FALSE.,21*.TRUE. /
c=== End of Block Data Bdevap =========================================*
      END

c$ CREATE BDNOPT.FOR
cCOPY BDNOPT
c
c=== bdnopt ===========================================================*
c==                                                                    *
CDECK  ID>, DT_BDNOPT
      BLOCK DATA DT_BDNOPT

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c   Created on  20 september 1989    by  Alfredo Ferrari - Infn Milan  *
c                                                                      *
c         Last change on 20-apr-95   by  Alfredo Ferrari               *
c                                                                      *
c----------------------------------------------------------------------*
c
C     INCLUDE '(BLNKCM)'
c$ CREATE BLNKCM.ADD
c*sr 17.5. commented since not used here
C     PARAMETER ( NBLNMX = 1100000 )
C     DIMENSION GMSTOR ( NBLNMX ), BRMBRR ( NBLNMX ), BRMEXP ( NBLNMX ),
C    &          BRMSIG ( NBLNMX ), SIGGTT ( KALGNM*NBLNMX ),
C    &          COMSCO ( NBLNMX ), LBSTOR ( KALGNM*NBLNMX )
C     REAL SIGGTT
C     LOGICAL LBSTOR
C     COMMON   NSTOR  ( KALGNM*NBLNMX )
c*
c*sr 18.5. commented since not used for evap.
C     COMMON / ADDRCM / MBLNMX, KBLNKL, KGMBGN, KGMLST, KCMBGN, KCMLST,
C    &                  KISBGN, KISLST, KDTBGN, KDTLST, KUBBGN, KUBLST,
C    &                  KUXBGN, KUXLST, KTCBGN, KTCLST, KRNBGN, KRNLST,
C    &                  KYLBGN, KYLLST, KXSBGN, KXSLST, KIHBGN, KIHLST,
C    &                  KINBGN, KINLST, KIEBGN, KIELST, KETBGN, KETLST,
C    &                  KRRBGN, KRRLST, KGLBGN, KGLLST, KNABGN, KNALST,
C    &                  KGDBGN, KGDLST, KDWBGN, KDWLST, KGCBGN, KGCLST,
C    &                  KWLBGN, KWLLST, KWHBGN, KWHLST, KWMBGN, KWMLST,
C    &                  KWSBGN, KWSLST, KNDBGN, KNDLST, KDPBGN, KDPLST,
C    &                  KRGBGN, KRGLST, KSGBGN, KSGLST, KBRBGN, KBRLST,
C    &                  KTMBGN
c*

C     EQUIVALENCE ( NSTOR (1), GMSTOR (1) )
C     EQUIVALENCE ( NSTOR (1), BRMBRR (1) )
C     EQUIVALENCE ( NSTOR (1), BRMEXP (1) )
C     EQUIVALENCE ( NSTOR (1), BRMSIG (1) )
C     EQUIVALENCE ( NSTOR (1), COMSCO (1) )
C     EQUIVALENCE ( NSTOR (1), SIGGTT (1) )
C     EQUIVALENCE ( NSTOR (1), LBSTOR (1) )
C     INCLUDE '(BLNTMP)'
c$ CREATE BLNTMP.ADD
c*sr 18.5. commented since not used for evap.
C     COMMON / BLNTMP / KIHBTM, KINBTM, KIEBTM, KRRBTM, KGLBTM, KNABTM,
C    &                  KGCBTM, KGDWTM, KBDWTM, KWLOTM, KWHITM, KWMUTM,
C    &                  KWSHTM, KEXTTM, KSTXTM, KSTNTM, KECTTM, KPCTTM,
C    &                  KLPBTM, NXXRGN
c*
C     INCLUDE '(CMMDNR)'
c$ CREATE CMMDNR.ADD
c*sr 18.5. commented since not used for evap.
C     LOGICAL LFLDNR
C     COMMON / CMMDNR / DDNEAR, LFLDNR
c*
C     INCLUDE '(CTITLE)'
c$ CREATE CTITLE.ADD
c*sr 18.5. commented since not used for evap.
C     CHARACTER RUNTIT*80, RUNTIM*32, RUNKEY*10
C     COMMON / CTITLE / RUNTIT, RUNTIM, RUNKEY
C     COMMON / CEXPCK / ITEXPI, ITEXMX
c*
C     INCLUDE '(DETECT)'
c$ CREATE DETECT.ADD
c*sr 18.5. commented since not used for evap.
C     PARAMETER (NRGNMX = 10)
C     PARAMETER (NDTCMX = 10)
C     PARAMETER (NSCRMX = 10)
C     PARAMETER (NDTBIN = 1024)
C     CHARACTER*10 TITDET,TITSCO
C     LOGICAL LDTCTR
C     COMMON /DETCT/  EDTMIN(NDTCMX), EDTBIN(NDTCMX), EDTCUT(NDTCMX),
C    &                KDTREG(NRGNMX,NDTCMX), KDTDET(NDTCMX,NSCRMX),
C    &                NDTSCO, NDTDET, LDTCTR, IDTREG(MXXRGN),
C    &                KDTSCD(NSCRMX)
C     COMMON /DETCH/  TITDET(NDTCMX), TITSCO(NSCRMX)
c*
C     INCLUDE '(DETLOC)'
c$ CREATE DETLOC.ADD
c*sr 18.5. commented since not used for evap.
C     PARAMETER (NDTCM2 = 10)
C     COMMON /DETLOC/ ACCUMP (NDTCM2), ACCUMN (NDTCM2),
C    &                ICOINC(NDTCM2), NCLAS
c*
C     INCLUDE '(EMGTRN)'
c$ CREATE EMGTRN.ADD
c*sr 18.5. commented since not used for evap.
C     LOGICAL LMCSMG
C     COMMON / EMGTRN / UMCSMG, VMCSMG, WMCSMG, LMCSMG
c*
C     INCLUDE '(EMSHO)'
c$ CREATE EMSHO.ADD
c*sr 18.5. commented since not used for evap.
C     LOGICAL EMFLO, EMFHLO, EMFELO, LIMPRE, LEXPTE
C     COMMON /EMSHO/ EMFETH, EMFPTH, EMFHET, EMFHPT, EMFBIA, EMFLO,
C    &               EMFHLO, EMFELO, LIMPRE, LEXPTE
c*
C     INCLUDE '(EPISOR)'
c$ CREATE EPISOR.ADD
c*sr 18.5. commented since not used for evap.
C     LOGICAL LUSSRC
C     COMMON/EPISOR/TKESUM,LUSSRC
c*
c (original name: FHEAVY,FHEAVC)
      PARAMETER ( MXHEAV = 100 )
      CHARACTER*8 ANHEAV
      COMMON /FKFHVY/ CXHEAV (MXHEAV), CYHEAV (MXHEAV),
     &                CZHEAV (MXHEAV), TKHEAV (MXHEAV),
     &                PHEAVY (MXHEAV), WHEAVY (MXHEAV),
     &                AMHEAV  ( 12 ) , AMNHEA  ( 12 ) ,
     &                KHEAVY (MXHEAV), ICHEAV  ( 12 ) ,
     &                IBHEAV  ( 12 ) , NPHEAV
      COMMON /FKFHVC/ ANHEAV  ( 12 )

c (original name: FINUC)
      PARAMETER (MXP=999)
      COMMON /FKFINU/ CXR    (MXP), CYR    (MXP), CZR    (MXP),
     &                CXRPOL (MXP), CYRPOL (MXP), CZRPOL (MXP),
     &                TKI    (MXP), PLR    (MXP), WEI    (MXP),
     &                TV, TVCMS, TVRECL, TVHEAV, TVBIND, NP0, NP,
     &                KPART  (MXP)

C     INCLUDE '(GENTHR)'
c$ CREATE GENTHR.ADD
c*sr 18.5. commented since not used for evap.
C     COMMON / GENTHR / PEANCT, PEAPIT, PLDNCT, PTHRSH (NALLWP),
C    &                  PTHDFF (NALLWP), IJNUCR (NALLWP)
c*
C     INCLUDE '(LOWNEU)'
c$ CREATE LOWNEU.ADD
c*sr 18.5. commented since not used for evap.
C     PARAMETER ( MXGTHN =  15 )
C     PARAMETER ( MXGLWN = 200 )
C     PARAMETER ( MXSHPP =   5 )
C     LOGICAL LCOMPN, LIMPRN, LBIASN, LDOWNN, LRECPR, LLOWWW, LLOWET
C     CHARACTER*10 TITLOW
C     COMMON / LOWNEU / ATOLOW (MXXMDF), WSHPLN (MXGLWN,MXSHPP), EXTWWL,
C    &                  SHPIMP (MXGLWN), EXTETL (MXGLWN), WWAMFL,
C    &                  VLLNTH (MXGTHN,MXXMDF), ABLNTH (MXGTHN,MXXMDF),
C    &                  STLNTH (MXGTHN,MXXMDF), TMRTLN (MXXMDF),
C    &                  TMNMLN (MXXMDF), ICHCPT (MXXMDF),
C    &                  IGTMRT (MXXMDF), NEUMED (MXXMDF),
C    &                  ID1MED (MXXMDF), ID2MED (MXXMDF),
C    &                  ID3MED (MXXMDF), MGTMED (MXXMDF),
C    &                  LCOMPN (MXXMDF), LRECPR (MXXMDF), KPRLOW, NMGP,
C    &                  NMTG  , IGRTHN, LIMPRN, LBIASN, LDOWNN, LLOWWW,
C    &                  LLOWET, ICLMED, IKRBGN, INABGN, IDWBGN, IETBGN,
C    &                  I0XSEC, IDXSEC, ISENAV, ISVELN, ISPNAV, IWWLWB,
C    &                  IWWLWT, IPXBGN, NPXSEC
C     COMMON / CHLWNT / TITLOW (MXXMDF)
c*
C     INCLUDE '(LTCLCM)'
c$ CREATE LTCLCM.ADD
c*sr 18.5. commented since not used for evap.
C     COMMON / LTCLCM / MLATTC, NEWLAT, MLATLD, MLATM1, MLTSEN, MLTSM1
c*
C     INCLUDE '(MULBOU)'
c$ CREATE MULBOU.ADD
c*sr 18.5. commented since not used for evap.
C     LOGICAL LLDA  , LAGAIN, LSTNEW, LARTEF, LNORML, LSENSE, LMGNOR
C     COMMON / MULBOU / UOLD  , VOLD  , WOLD  , UMAG  , VMAG  , WMAG  ,
C    &                  UNORML, VNORML, WNORML, USENSE, VSENSE, WSENSE,
C    &                  TSENSE, DDSENS, DSMALL, NSSENS, LLDA  , LAGAIN,
C    &                  LSTNEW, LARTEF, LNORML, LSENSE, LMGNOR
c*
C     INCLUDE '(MULHD)'
c$ CREATE MULHD.ADD
c*sr 18.5. commented since not used for evap.
C     PARAMETER ( MXXPT1 = 1 )
C     PARAMETER ( TIMESS = 2.00D+00 )
C     PARAMETER ( TMSRLX = 1.50D+00 )
C     PARAMETER ( EPSINS = 0.15D+00 )
C     PARAMETER ( EPSRLX = 0.50D+00 )
C     PARAMETER ( SQEPSN = 0.3872983346207417 D+00 )
C     PARAMETER ( SQEPSR = 0.7071067811865475 D+00 )
C     PARAMETER ( PARNSI = 1.732050807568877 D+00 * SQEPSN )
C     PARAMETER ( PRNSR0 = 1.732050807568877 D+00 * SQEPSR )
C     PARAMETER ( R0NCMS = 1.20 D+00 )
C     LOGICAL LTOPT, LSRCRH, LNSCRH
C     COMMON / MULHD / BLCC   ( MXXMDF ), BLCCRA ( MXXMDF ),
C    &                 XCC    ( MXXMDF ), ZTILDE ( MXXMDF, 0:MXXPT1 ),
C    &                 ALPZTL ( MXXMDF, 0:MXXPT1 ), RLDU   ( MXXMDF ),
C    &                 ALPZT2 ( MXXMDF, 0:MXXPT1 ), TEFF0  ( MXXMDF ),
C    &                 XR0    ( MXXMDF ), ECUTM  ( MXXMDF, 39, 2 ),
C    &                 ESTEPF ( MXXMDF ), HTHNSZ ( MXXMDF, 39 ),
C    &                 AE1O3  ( MXXMDF ), PARNSR ( MXXMDF ),
C    &                 HEESLI ( MXXMDF ), THMSPR, THMSSC, HMSAMP,
C    &                 HMREJE, LSRCRH ( MXXMDF ), LNSCRH ( MXXMDF ),
C    &                 LTOPT  ( MXXMDF ), NFSCAT
c*
c (original name: PAREVT)
      LOGICAL LDIFFR, LINCTV, LEVPRT, LHEAVY, LDEEXG, LGDHPR, LPREEX,
     &        LHLFIX, LPRFIX, LPARWV, LPOWER, LSNGCH, LLVMOD, LSCHDF
      PARAMETER ( NALLWP = 39   )
      COMMON /FKPARE/ DPOWER, FSPRD0, FSHPFN, RN1GSC, RN2GSC,
     &                LDIFFR (NALLWP),LPOWER, LINCTV, LEVPRT, LHEAVY,
     &                LDEEXG, LGDHPR, LPREEX, LHLFIX, LPRFIX, LPARWV,
     &                ILVMOD, JLVMOD, LLVMOD, LSNGCH, LSCHDF

c (original name: RESNUC)
      LOGICAL LRNFSS, LFRAGM
      COMMON /FKRESN/  AMNTAR, AMMTAR, AMNZM1, AMMZM1, AMNNM1, AMMNM1,
     &                   ANOW,   ZNOW, ANCOLL, ZNCOLL, AMMLFT, AMNLFT,
     &                   ERES,  EKRES, AMNRES, AMMRES,  PTRES,  PXRES,
     &                  PYRES,  PZRES, PTRES2,  KTARP,  KTARN, IGREYP,
     &                 IGREYN, IPREEH, IPRDEU, IPRTRI, IPR3HE, IPR4HE,
     &                  ICRES,  IBRES, ISTRES, IEVAPL, IEVAPH, IEVNEU,
     &                 IEVPRO, IEVDEU, IEVTRI, IEV3HE, IEV4HE, IDEEXG,
     &                  IBTAR, ICHTAR, IBLEFT, ICLEFT, IOTHER, LRNFSS,
     &                 LFRAGM

C     INCLUDE '(SCOHLP)'
c$ CREATE SCOHLP.ADD
c*sr 18.5. commented since not used for evap.
C     LOGICAL LSCZER
C     COMMON / SCOHLP / ISCRNG, JSCRNG, LSCZER
c*
C     INCLUDE '(TRACKR)'
c$ CREATE TRACKR.ADD
c*sr 18.5. commented since not used for evap.
C     PARAMETER ( MXTRCK = 2500 )
C     LOGICAL LFSSSC
C     COMMON / TRACKR /  XTRACK ( 0:MXTRCK ), YTRACK ( 0:MXTRCK ),
C    &                   ZTRACK ( 0:MXTRCK ), TTRACK   ( MXTRCK ),
C    &                   DTRACK   ( MXTRCK ), ETRACK, PTRACK, WTRACK,
C    &                   ATRACK, CTRACK, AKSHRT, AKLONG, WSCRNG,
C    &                   NTRACK, MTRACK, JTRACK, KTRACK, MMTRCK,
C    &                   LT1TRK, LT2TRK, LTRACK, LLOUSE, LFSSSC
c*
C     INCLUDE '(USRBDX)'
c$ CREATE USRBDX.ADD
c*sr 18.5. commented since not used for evap.
C     PARAMETER ( MXUSBX = 600 )
C     LOGICAL LUSBDX, LFUSBX, LWUSBX, LLNUSX
C     CHARACTER*10 TITUSX
C     COMMON /USRBX/  EBXLOW(MXUSBX), EBXHGH(MXUSBX), ABXLOW(MXUSBX),
C    &                ABXHGH(MXUSBX), DEBXBN(MXUSBX), DABXBN(MXUSBX),
C    &                AUSBDX(MXUSBX),
C    &                NEBXBN(MXUSBX), NABXBN(MXUSBX), NR1USX(MXUSBX),
C    &                NR2USX(MXUSBX), ITUSBX(MXUSBX), IDUSBX(MXUSBX),
C    &                KBUSBX(MXUSBX), IPUSBX(MXUSBX), IGMUSX(MXUSBX),
C    &                LFUSBX(MXUSBX), LWUSBX(MXUSBX), LLNUSX(MXUSBX),
C    &                NUSRBX, LUSBDX
C     COMMON /USXCH/  TITUSX(MXUSBX)
c*
C     INCLUDE '(USRBIN)'
c$ CREATE USRBIN.ADD
c*sr 18.5. commented since not used for evap.
C     PARAMETER ( MXUSBN = 100 )
C     LOGICAL LUSBIN, LEVTBN, LNTZER, LUSEVT, LUSTKB, LTRKBN
C     CHARACTER*10 TITUSB
C     COMMON /USRBN/  XLOW  (MXUSBN), XHIGH (MXUSBN), YLOW  (MXUSBN),
C    &                YHIGH (MXUSBN), ZLOW  (MXUSBN), ZHIGH (MXUSBN),
C    &                DXUSBN(MXUSBN), DYUSBN(MXUSBN), DZUSBN(MXUSBN),
C    &                TCUSBN(MXUSBN), BKUSBN(MXUSBN), B2USBN(MXUSBN),
C    &                NXBIN (MXUSBN), NYBIN (MXUSBN), NZBIN (MXUSBN),
C    &                ITUSBN(MXUSBN), IDUSBN(MXUSBN), KBUSBN(MXUSBN),
C    &                IPUSBN(MXUSBN), LEVTBN(MXUSBN), LNTZER(MXUSBN),
C    &                LTRKBN(MXUSBN), NUSRBN, LUSBIN, LUSEVT, LUSTKB
C     COMMON /USRCH/  TITUSB(MXUSBN)
c*
C     INCLUDE '(USRSNC)'
c$ CREATE USRSNC.ADD
c*sr 18.5. commented since not used for evap.
C     PARAMETER ( MXRSNC = 400 )
C     PARAMETER ( NMZMIN =  -5 )
C     LOGICAL LURSNC
C     CHARACTER*10 TIURSN
C     COMMON /USRSNC/  VURSNC(MXRSNC), IZRHGH(MXRSNC), IMRHGH(MXRSNC),
C    &                 NRURSN(MXRSNC), ITURSN(MXRSNC), KBURSN(MXRSNC),
C    &                 IPURSN(MXRSNC), NURSNC, LURSNC
C     COMMON /USRSCH/  TIURSN(MXRSNC)
C     INCLUDE '(USRTRC)'
c$ CREATE USRTRC.ADD
c*sr 18.5. commented since not used for evap.
C     PARAMETER ( MXUSTC = 400 )
C     LOGICAL LUSRTC, LUSTRK, LUSCLL, LLNUTC
C     CHARACTER*10 TITUTC
C     COMMON /USRTC/  ETCLOW(MXUSTC), ETCHGH(MXUSTC), DETCBN(MXUSTC),
C    &                VUSRTC(MXUSTC),
C    &                IUSTRK(MXUSTC), IUSCLL(MXUSTC), NETCBN(MXUSTC),
C    &                NRUSTC(MXUSTC), ITUSTC(MXUSTC), IDUSTC(MXUSTC),
C    &                KBUSTC(MXUSTC), IPUSTC(MXUSTC), IGMUTC(MXUSTC),
C    &                LLNUTC(MXUSTC), NUSRTC, NUSTRK, NUSCLL, LUSRTC,
C    &                LUSTRK, LUSCLL
C     COMMON /USTCH/  TITUTC(MXUSTC)
c*
C     INCLUDE '(USRYLD)'
c$ CREATE USRYLD.ADD
c*sr 18.5. commented since not used for evap.
C     PARAMETER ( MXUSYL = 500 )
C     LOGICAL LUSRYL, LLNUYL, LSCUYL
C     CHARACTER*10 TITUYL
C     COMMON /USRYL/  EYLLOW(MXUSYL), EYLHGH(MXUSYL), DEYLBN(MXUSYL),
C    &                USNRYL(MXUSYL), SGUSYL(MXUSYL), AYLLOW(MXUSYL),
C    &                AYLHGH(MXUSYL), PUSRYL, UUSRYL, VUSRYL, WUSRYL,
C    &                ETXUYL, ETYUYL, ETZUYL, GAMUYL, SQSUYL, UCMUYL,
C    &                VCMUYL, WCMUYL, IJUSYL, JTUSYL,
C    &                NEYLBN(MXUSYL), NR1UYL(MXUSYL), NR2UYL(MXUSYL),
C    &                IXUSYL(MXUSYL), ITUSYL(MXUSYL), IDUSYL(MXUSYL),
C    &                KBUSYL(MXUSYL), IPUSYL(MXUSYL), IGMUYL(MXUSYL),
C    &                IEUSYL(MXUSYL), IAUSYL(MXUSYL), LLNUYL(MXUSYL),
C    &                NUSRYL, LUSRYL, LSCUYL
C     COMMON /USYCH/  TITUYL(MXUSYL)
c*
C     INCLUDE '(WWINDW)'
c$ CREATE WWINDW.ADD
c*sr 18.5. commented since not used for evap.
C     PARAMETER ( MXWWSP = 3 )
C     PARAMETER ( WWSPMX = 50.D+00 )
C     LOGICAL LWWNDW, LWWPRM
C     COMMON / WWINDW / ETHWW1 (NALLWP), ETHWW2 (NALLWP),
C    &                  WWEXWD (NALLWP), EXTWWN (NALLWP),
C    &                  IWLBGN, IWHBGN, IWMBGN, LWWNDW, LWWPRM
c*

c /blnkcm/
c *** If blank common dimension has to be superseded substitute in the
c *** following two lines the new dimension in real*8 units to Nblnmx
c*sr 18.5. commented since not used for evap.
C     PARAMETER (MXDUMM = KALGNM * NBLNMX)
C     DATA KTMBGN / NBLNMX /
C     DATA MBLNMX / MXDUMM /
C     DATA KBLNKL, KGMBGN, KGMLST, KCMBGN, KCMLST, KISBGN, KISLST,
C    &     KDTBGN, KDTLST, KUBBGN, KUBLST, KUXBGN, KUXLST, KTCBGN,
C    &     KTCLST, KRNBGN, KRNLST, KYLBGN, KYLLST, KXSBGN, KXSLST,
C    &     KIHBGN, KIHLST, KINBGN, KINLST, KIEBGN, KIELST, KETBGN,
C    &     KETLST, KRRBGN, KRRLST, KGLBGN, KGLLST, KNABGN, KNALST,
C    &     KGDBGN, KGDLST, KDWBGN, KDWLST, KGCBGN, KGCLST, KWLBGN,
C    &     KWLLST, KWHBGN, KWHLST, KWMBGN, KWMLST, KWSBGN, KWSLST,
C    &     KDPBGN, KDPLST, KRGBGN, KRGLST, KSGBGN, KSGLST, KBRBGN,
C    &     KBRLST / 57*0 /

c /blntmp/
c*sr 18.5. commented since not used for evap.
C     DATA KIHBTM, KINBTM, KIEBTM, KRRBTM, KGLBTM, KNABTM, KGDWTM,
C    &     KBDWTM, KGCBTM, KWLOTM, KWHITM, KWMUTM, KWSHTM, KEXTTM,
C    &     KSTXTM, KSTNTM, KECTTM, KPCTTM, KLPBTM / 19*0 /

c /cmmdnr/
c*sr 18.5. commented since not used for evap.
C     DATA DDNEAR / 0.D+00 /, LFLDNR / .FALSE. /

c /ctitle/
c*sr 18.5. commented since not used for evap.
C     DATA RUNTIT (1:40) / '****************************************' /
C     DATA RUNTIT(41:80) / '****************************************' /
C     DATA ITEXPI, ITEXMX / 100000000, 150 /
c /detect/
c*sr 18.5. commented since not used for evap.
C     PARAMETER (NNN1 = NRGNMX*NDTCMX)
C     PARAMETER (NNN2 = NSCRMX*NDTCMX)
C     DATA LDTCTR /.FALSE./, NDTSCO /0/, NDTDET /0/
C     DATA EDTMIN/NDTCMX*0.D0/, EDTBIN/NDTCMX*0.D0/, EDTCUT/NDTCMX*0.D0/
C     DATA KDTREG/NNN1*0/, KDTDET/NNN2*0/, KDTSCD/NSCRMX*0/
C     DATA TITDET/NDTCMX*'          '/, TITSCO/NSCRMX*'          '/

c /detloc/
c*sr 18.5. commented since not used for evap.
C     DATA ACCUMP /NDTCM2*0.D0/, ACCUMN /NDTCM2*0.D0/, ICOINC /NDTCM2*0/
C     DATA NCLAS /0/

c /emgtrn/
c*sr 18.5. commented since not used for evap.
C     DATA LMCSMG / .FALSE. /

c /emsho/
c*sr 18.5. commented since not used for evap.
C     DATA LIMPRE, LEXPTE / 2 * .FALSE. /

c /episor/
c*sr 18.5. commented since not used for evap.
C     DATA TKESUM / 0.D+00 /, LUSSRC / .FALSE. /

c /fheavy/
      DATA AMHEAV / 12 * 0.D+00 /
      DATA ANHEAV / 'NEUTRON ', 'PROTON  ', 'DEUTERON', '3-H     ',
     &              '3-HE    ', '4-HE    ', 'H-FRAG-1', 'H-FRAG-2',
     &              'H-FRAG-3', 'H-FRAG-4', 'H-FRAG-5', 'H-FRAG-6'/
      DATA ICHEAV / 0, 1, 1, 1, 2, 2, 6*0 /,
     &     IBHEAV / 1, 1, 2, 3, 3, 4, 6*0 /
      DATA NPHEAV / 0 /

c /finuc/
      DATA NP / 0 /, TV / 0.D+00 /, TVCMS / 0.D+00 /, TVRECL / 0.D+00/,
     &     TVHEAV / 0.D+00 /, TVBIND / 0.D+00 /

c /genthr/
c Up to 20-apr-'95
c     DATA PEANCT, PEAPIT / 2*1.D+00 /
c     DATA PTHRSH / 16*5.D+00,2*2.5D+00,5.D+00,3*2.5D+00,8*5.D+00,
c    &              9*2.5D+00 /
c     DATA PTHDFF / 39*5.D+00 /
c    &              9*2.5D+00 /
c New values:
c*sr 18.5. commented since not used for evap.
C     DATA PEANCT, PEAPIT / 1.3D+00, 1.1D+00 /
C     DATA PTHRSH / 12*5.D+00, 2*3.5D+00, 2*5.D+00, 2*2.5D+00, 5.D+00,
C    &              3*2.5D+00, 3.5D+00, 2*5.D+00, 3.5D+00, 4*5.D+00,
C    &              9*2.5D+00 /
C     DATA PTHDFF / 12*5.D+00, 2*3.5D+00, 8*5.D+00, 3.5D+00, 2*5.D+00,
C    &              3.5D+00, 13*5.D+00 /
C     DATA PLDNCT / 0.26D+00 /
C     DATA IJNUCR / 16*1, 2*0, 1, 3*0, 8*1, 9*0 /

c /lowneu/
c*sr 18.5. commented since not used for evap.
C     DATA WWAMFL / 10.D+00 /, EXTWWL / 1.D+00 /
C     DATA IWWLWB, IWWLWT / 2 * 100000000 /
C     DATA ICLMED, INABGN, IDWBGN, IETBGN / 4*0 /
C     DATA IGRTHN / 1 /
C     DATA LIMPRN / .FALSE. /, LBIASN / .FALSE. /, LDOWNN / .FALSE. /,
C    &     LLOWWW / .FALSE. /, LLOWET / .FALSE. /

c /ltclcm/
c*sr 18.5. commented since not used for evap.
C     DATA MLATTC, NEWLAT, MLATLD, MLATM1, MLTSEN, MLTSM1 / 6*0 /

c /mulbou/
c*sr 18.5. commented since not used for evap.
C     DATA LLDA, LAGAIN, LSTNEW, LARTEF, LSENSE, LNORML, LMGNOR
C    &     / 7 * .FALSE. /
C     DATA TSENSE / AINFNT /, NSSENS / -1 /
C     DATA DSMALL / ANGLGB /

c /mulhd/
c*sr 18.5. commented since not used for evap.
C     DATA LTOPT  / MXXMDF * .FALSE. /, NFSCAT / 0 /
C     DATA ESTEPF / MXXMDF * 0.1D+00 /
C     DATA LSRCRH / MXXMDF * .FALSE. /, LNSCRH / MXXMDF * .FALSE. /
C     DATA THMSPR / 0.02D+00 /, THMSSC / 1.D+00 /

c /parevt/
      DATA DPOWER /-13.D+00 /, FSPRD0 / 0.6D+00 /, FSHPFN / 0.0D+00 /,
     &     RN1GSC /-1.0D+00 /, RN2GSC /-1.0D+00 /
      DATA LDIFFR /  .TRUE., .TRUE., 6 * .TRUE., .TRUE., 8 * .TRUE.,
     &               .TRUE., 4 * .TRUE., .TRUE., 3 * .TRUE.,
     &              4 * .FALSE., 9 * .TRUE./
c*sr 17.5.95
c default value for LEVPRT changed (reset sr 25.7.97)
c default value for LHEAVY changed 25.7.97
C     DATA LPOWER / .TRUE.  /, LINCTV / .TRUE.  /, LEVPRT / .TRUE.  /,
C    &     LHEAVY / .FALSE. /, LDEEXG / .TRUE.  /, LGDHPR / .TRUE.  /,
C    &     LPREEX / .TRUE.  /, LHLFIX / .FALSE. /, LPRFIX / .FALSE. /,
C    &     LPARWV / .TRUE.  /, LSNGCH / .TRUE.  /, LSCHDF / .TRUE.  /
      DATA LPOWER / .TRUE.  /, LINCTV / .TRUE.  /, LEVPRT / .TRUE.  /,
     &     LHEAVY / .TRUE.  /, LDEEXG / .TRUE.  /, LGDHPR / .TRUE.  /,
     &     LPREEX / .TRUE.  /, LHLFIX / .FALSE. /, LPRFIX / .FALSE. /,
     &     LPARWV / .TRUE.  /, LSNGCH / .TRUE.  /, LSCHDF / .TRUE.  /
c*
c*sr 27.5.97
c default value for ILVMOD changed
C     DATA ILVMOD / 0 /, JLVMOD / 1 /, LLVMOD / .TRUE. /
      DATA ILVMOD / 1 /, JLVMOD / 1 /, LLVMOD / .TRUE. /
c*

c /resnuc/
      DATA IPREEH / 0 /, IPRTRI / 0 /, IPRDEU / 0 /, IPR3HE / 0 /,
     &     IPR4HE / 0 /
      DATA IEVAPL / 0 /, IEVAPH / 0 /, IEVNEU / 0 /, IEVPRO / 0 /,
     &     IEVTRI / 0 /, IEVDEU / 0 /, IEV3HE / 0 /, IEV4HE / 0 /,
     &     IDEEXG / 0 /
      DATA LRNFSS / .FALSE. /

c /scohlp/
c*sr 18.5. commented since not used for evap.
C     DATA ISCRNG, JSCRNG / 2*0 /, LSCZER / .FALSE. /

c /trackr/
c*sr 18.5. commented since not used for evap.
C     DATA ETRACK /0.D+00/, WTRACK /0.D+00/, ATRACK /0.D+00/,
C    &     CTRACK /0.D+00/, NTRACK /0/, MTRACK /0/, JTRACK /0/

c /usrbin/
c*sr 18.5. commented since not used for evap.
C     DATA LUSBIN, LUSEVT, LUSTKB /3*.FALSE./, NUSRBN /0/

c /usrbdx/
c*sr 18.5. commented since not used for evap.
C     DATA LUSBDX /.FALSE./, NUSRBX /0/

c /usrsnc/
c*sr 18.5. commented since not used for evap.
C     DATA LURSNC /.FALSE./, NURSNC /0/

c /usrtrc/
c*sr 18.5. commented since not used for evap.
C     DATA LUSRTC, LUSTRK, LUSCLL / 3*.FALSE. /
C     DATA NUSRTC, NUSTRK, NUSCLL / 3*0 /

c /usryld/
c*sr 18.5. commented since not used for evap.
C     DATA LUSRYL / .FALSE./, LSCUYL / .FALSE. /, NUSRYL /0/,
C    &     IJUSYL /0/, JTUSYL /0/
C     DATA PUSRYL, UUSRYL, VUSRYL, WUSRYL / 4*ZERZER /

c /wwindw/
c*sr 18.5. commented since not used for evap.
C     DATA IWLBGN, IWHBGN, IWMBGN / 3*0 /
C     DATA LWWPRM / .TRUE. /

c=                                               end*block.bdnopt      *
      END

c$ CREATE BDPREE.FOR
cCOPY BDPREE
c
c=== bdpree ===========================================================*
c
CDECK  ID>, DT_BDPREE
      BLOCK DATA DT_BDPREE

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     Created on 16 september 1991 by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 03-feb-94     by    Alfredo Ferrari               *
c                                                                      *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: CMPISG,CHPISG)
      PARAMETER ( TPPPI0 = 0.279656044337515D+00 )
      PARAMETER ( TNNPI0 = 0.279642680857450D+00 )
      PARAMETER ( TPPPIP = 0.292295207182790D+00 )
      PARAMETER ( TPPDEP = 0.287514778898469D+00 )
      PARAMETER ( TNNPIM = 0.286723140900975D+00 )
      PARAMETER ( TNNDEM = 0.281949292916434D+00 )
      PARAMETER ( TPNPI0 = 0.279456888147740D+00 )
      PARAMETER ( TPNDE0 = 0.274693916135245D+00 )
      PARAMETER ( TPNPIP = 0.292086756473890D+00 )
      PARAMETER ( TNPPI0 = 0.279842093144975D+00 )
      PARAMETER ( TNPDE0 = 0.275072555824202D+00 )
      PARAMETER ( TNPPIP = 0.292489370554958D+00 )
      PARAMETER ( PIRSMX = 1.2D+00 )
      PARAMETER ( NPIREA = 10 )
      PARAMETER ( NPIRTA = 68 )
      PARAMETER ( NPIRLN = 21 )
      PARAMETER ( NPIRLG = NPIRTA - NPIRLN )
      PARAMETER ( NPISIS = NPIRLN + 20 )
      PARAMETER ( NPISEX = NPIRLN + 21 )
      PARAMETER ( NPIIMN = 14 )
      PARAMETER ( NPIIRC =  6 )
      PARAMETER ( DELWLL = 0.035D+00 )
      CHARACTER CHPIRE*8
      LOGICAL LDLRES
      COMMON /FKCMPI/ PMNPIS, PMMPIS, PISPIS, PEXPIS, PMXPIS, DPPISG,
     &                RTPISG, AMNPIS, AMMPIS, AISPIS, AEXPIS, AMXPIS,
     &                ARPISG, BPISLO (NPIRLN:NPIRTA,NPIREA),
     &                CPISLO (NPIRLN:NPIRTA,NPIREA), PPITHR (NPIREA),
     &                SPISLO (NPIRLN:NPIRTA,NPIREA), APITHR (NPIREA),
     &                SGPIIN (NPIIMN:NPIRTA,NPIIRC), RHPICR (1:5)   ,
     &                SGPICU (0:20,NPIRTA,NPIREA)  , SGRTRS (NPIREA),
     &                SGPIDF (0:20,NPIRTA,NPIREA)  , BRREIN (NPIREA),
     &                SGPIIS (NPIRTA,NPIREA)       , BRREOU (NPIREA),
     &                BRD3OU (2,2,-1:2), BRDEOU (2,-1:2),
     &                SGABSR (2,2,4)   , PRRSDL,
     &                IPIREA (2,2,3:5) , IPIINE (2,3:5)    , NPIRVR ,
     &                KPIIRE (2,NPIREA), KPIORE (2,NPIREA) ,
     &                JSTOKP (5), KPTOJS (23), ITTRRS (3:5), LDLRES
      COMMON /FKCHPI/ CHPIRE (NPIREA)
      DIMENSION SG2BRS (2,2), SGABSW (2,2), SG3BRS (2,2,2)
      EQUIVALENCE ( SG2BRS   (1,1), SGABSR (1,1,1) )
      EQUIVALENCE ( SGABSW   (1,1), SGABSR (1,1,2) )
      EQUIVALENCE ( SG3BRS (1,1,1), SGABSR (1,1,3) )

c (original name: FRBKCM)
      PARAMETER ( MXFFBK =     6 )
      PARAMETER ( MXZFBK =     9 )
      PARAMETER ( MXNFBK =    10 )
      PARAMETER ( MXAFBK =    16 )
      PARAMETER ( NXZFBK = MXZFBK + MXFFBK / 3 )
      PARAMETER ( NXNFBK = MXNFBK + MXFFBK / 3 )
      PARAMETER ( NXAFBK = MXAFBK + 1 )
      PARAMETER ( MXPSST =   300 )
      PARAMETER ( MXPSFB = 41000 )
      LOGICAL LFRMBK, LNCMSS
      COMMON /FKFRBK/  AMUFBK, EEXFBK (MXPSST), AMFRBK (MXPSST),
     &          EXFRBK (MXPSFB), SDMFBK (MXPSFB), COUFBK (MXPSFB),
     &          EXMXFB, R0FRBK, R0CFBK, C1CFBK, C2CFBK,
     &          IFRBKN (MXPSST), IFRBKZ (MXPSST),
     &          IFBKSP (MXPSST), IFBKPR (MXPSST), IFBKST (MXPSST),
     &          IPSIND (0:MXNFBK,0:MXZFBK,2), JPSIND (0:MXAFBK),
     &          IFBIND (0:NXNFBK,0:NXZFBK,2), JFBIND (0:NXAFBK),
     &          IFBCHA (5,MXPSFB), IPOSST, IPOSFB, IFBSTF,
     &          IFBFRB, NBUFBK, LFRMBK, LNCMSS

c (original name: NUCGID,NUCGEO,NUCGE2,NUCPWI,NUCGII)
      PARAMETER ( PI     = PIPIPI )
      PARAMETER ( PISQ   = PIPISQ )
      PARAMETER ( SKTOHL = 0.5456645846610345D+00 )
      PARAMETER ( RZNUCL = 1.12        D+00 )
      PARAMETER ( RMSPRO = 0.8         D+00 )
      PARAMETER ( R0PROT = RMSPRO / SQRT12  )
      PARAMETER ( ARHPRO = 1.D+00 / 8.D+00 / PI / R0PROT / R0PROT
     &          / R0PROT )
      PARAMETER ( RLLE04 = RZNUCL )
      PARAMETER ( RLLE16 = RZNUCL )
      PARAMETER ( RLGT16 = RZNUCL )
      PARAMETER ( RCLE04 = 0.75D+00 / PI / RLLE04 / RLLE04 / RLLE04 )
      PARAMETER ( RCLE16 = 0.75D+00 / PI / RLLE16 / RLLE16 / RLLE16 )
      PARAMETER ( RCGT16 = 0.75D+00 / PI / RLGT16 / RLGT16 / RLGT16 )
      PARAMETER ( SKLE04 = 1.4D+00 )
      PARAMETER ( SKLE16 = 1.9D+00 )
      PARAMETER ( SKGT16 = 2.4D+00 )
      PARAMETER ( HLLE04 = SKTOHL * SKLE04 )
      PARAMETER ( HLLE16 = SKTOHL * SKLE16 )
      PARAMETER ( HLGT16 = SKTOHL * SKGT16 )
      PARAMETER ( ALPHA0 = 0.1D+00 )
      PARAMETER ( OMALH0 = 1.D+00 - ALPHA0 )
      PARAMETER ( GAMSK0 = 0.9D+00 )
      PARAMETER ( OMGAS0 = 1.D+00 - GAMSK0 )
      PARAMETER ( POTME0 = 0.6666666666666667D+00 )
      PARAMETER ( POTBA0 = 1.D+00 )
      PARAMETER ( PNFRAT = 1.533D+00 )
      PARAMETER ( RADPIM = 0.035D+00 )
      PARAMETER ( RDPMHL = 14.D+00   )
      PARAMETER ( APMRST = 4.D+00 / 44.D+00 )
      PARAMETER ( APMPRO = 1.D+00 / 6.D+00 )
      PARAMETER ( APPPRO = 5.D+00 / 6.D+00 )
      PARAMETER ( AP0PFS = 0.5D+00 )
      PARAMETER ( AP0PFP = 1.D+00 / 3.D+00 )
      PARAMETER ( AP0NFP = 2.D+00 / 3.D+00 )
      PARAMETER ( XPAUCO = 1.88495407241652 D+00 )
      PARAMETER ( MXSCIN = 50     )
      LOGICAL LABRST, LELSTC, LINELS, LCHEXC, LABSRP, LABSTH, LNCDCY,
     &        LNUSCT, LPREEQ, LNPHTC, LNWRAD, LPNRHO, LFTCMP, LFTCAC
      COMMON /FKNGID/ RHOTAB (2:260), RHATAB (2:260), ALPTAB (2:260),
     &                RADTAB (2:260), SKITAB (2:260), HALTAB (2:260),
     &                SK3TAB (2:260), SK4TAB (2:260), HABTAB (2:260),
     &                CWSTAB (2:260), EKATAB (2:260), PFATAB (2:260),
     &                PFRTAB (2:260)
      COMMON /FKNGEO/ RADTOT, RADIU1, RADIU0, RAD1O2, SKINDP, HALODP,
     &                ALPHAL, OMALHL, RADSKN, SKNEFF, CPARWS, RADPRO,
     &                RADCOR, RADCO2, RADMAX, BIMPTR, RIMPTR, XIMPTR,
     &                YIMPTR, ZIMPTR, RHOIMT, EKFPRO, PFRPRO, RHOCEN,
     &                RHOCOR, RHOSKN, EKFCEN (2), PFRCEN (2), EKFBIM,
     &                PFRBIM, RHOIMP, EKFIMP, PFRIMP, RHOIM2, EKFIM2,
     &                PFRIM2, RHOIM3, EKFIM3, PFRIM3, VPRWLL, RIMPCT,
     &                BIMPCT, XIMPCT, YIMPCT, ZIMPCT, RIMPC2, XIMPC2,
     &                YIMPC2, ZIMPC2, RIMPC3, XIMPC3, YIMPC3, ZIMPC3,
     &                XBIMPC, YBIMPC, ZBIMPC, CXIMPC, CYIMPC, CZIMPC,
     &                SQRIMP, SIGMAP, SIGMAN, SIGMAA, RHORED, R0TRAJ,
     &                R1TRAJ, SBUSED, SBTOT , SBRES , RHOAVE, EKFAVE,
     &                PFRAVE, AVEBIN, ACOLL , ZCOLL , RADSIG, OPACTY,
     &                EKECON, PNUCCO, EKEWLL, PPRWLL, PXPROJ, PYPROJ,
     &                PZPROJ, EKFERM, PNFRMI, PXFERM, PYFERM, PZFERM,
     &                EKFER2, PNFRM2, PXFER2, PYFER2, PZFER2, EKFER3,
     &                PNFRM3, PXFER3, PYFER3, PZFER3, RHOMEM, EKFMEM,
     &                BIMMEM, WLLRED, VPRBIM, POTINC, POTOUT, EEXMIN
      COMMON /FKNGE2/ RDTTNC (2), RHONCP (2), RHONC2 (2), RHONC3 (2),
     &                RHONCT (2), AMOTHR, EKOTHR, AMCREA, EKNCLN,
     &                EEXDEL, EEXANY, CLMBBR, RDCLMB, BFCLMB, BFCEFF,
     &                BNPROJ, BNDNUC, DEBRLM, SK4PAR, UBIMPC, VBIMPC,
     &                WBIMPC, BNDPOT, SIGMAT, SIGABP, SIGABN, WLLRES,
     &                POTBAR, POTMES, AGEPRI, OPNOPA, ETHRND,
     &                BNENRG (3), DEFNUC (2), SIGMPR (4), SIGMNU (4),
     &                SIGPAB (3), SIGNAB (3), HHLP   (2), FORTOT (2),
     &                FPNBLC, DPNBLC, FFTFLG, IFTFLG,
     &                IPWELL, ITNCMX, KPRIN , NTARGT, KNUCIM, KNUCI2,
     &                KNUCI3, IEVPRE, ISFCOL, ISFTAR, ISFTA2, ISFTA3,
     &                NPOTHR, ICOTHR, IBOTHR, NPUMFN, ISTNCL, ITAUCM,
     &                IABCOU, IADFLG, IGSFLG, IALFLG, ICBFLG, LPREEQ,
     &                LNPHTC, LPNRHO, LNWRAD, LFTCMP, LFTCAC
      COMMON /FKNPWI/ ALMBAR, BIMMAX, SIGGEO, LLLMAX, LLLACT
      COMMON /FKNGII/ HOLEXP (2*MXSCIN), XEXPIN (3,0:MXSCIN),
     &                YEXPIN (3,0:MXSCIN), ZEXPIN (3,0:MXSCIN),
     &                AGEXIN (0:MXSCIN), RHOEXP (2), EKFEXP, EHLFIX,
     &                NHLEXP, NHLFIX, IPRTYP, NNCEXI (0:MXSCIN),
     &                NCEXPI (3,0:MXSCIN), ISEXIN (3,0:MXSCIN),
     &                ISCTYP (0:MXSCIN), NUSCIN, NEXPEM,
     &                LABRST, LELSTC, LINELS, LCHEXC, LABSRP, LABSTH,
     &                LNCDCY, LNUSCT
      DIMENSION AWSTAB (2:260), SIGMAB (3)
      EQUIVALENCE ( DEFPRO, DEFNUC (1) )
      EQUIVALENCE ( DEFNEU, DEFNUC (2) )
      EQUIVALENCE ( RHOIPP, RHONCP (1) )
      EQUIVALENCE ( RHOINP, RHONCP (2) )
      EQUIVALENCE ( RHOIP2, RHONC2 (1) )
      EQUIVALENCE ( RHOIN2, RHONC2 (2) )
      EQUIVALENCE ( RHOIP3, RHONC3 (1) )
      EQUIVALENCE ( RHOIN3, RHONC3 (2) )
      EQUIVALENCE ( RHOIPT, RHONCT (1) )
      EQUIVALENCE ( RHOINT, RHONCT (2) )
      EQUIVALENCE ( OMALHL, SK3PAR )
      EQUIVALENCE ( ALPHAL, HABPAR )
      EQUIVALENCE ( ALPTAB (2), AWSTAB (2) )
      EQUIVALENCE ( SIGMPE, SIGMPR (1) )
      EQUIVALENCE ( SIGMPC, SIGMPR (2) )
      EQUIVALENCE ( SIGMPI, SIGMPR (3) )
      EQUIVALENCE ( SIGMPA, SIGMPR (4) )
      EQUIVALENCE ( SIGMNE, SIGMNU (1) )
      EQUIVALENCE ( SIGMNC, SIGMNU (2) )
      EQUIVALENCE ( SIGMNI, SIGMNU (3) )
      EQUIVALENCE ( SIGMNA, SIGMNU (4) )
      EQUIVALENCE ( SIGMA2, SIGPAB (1) )
      EQUIVALENCE ( SIGMA3, SIGPAB (2) )
      EQUIVALENCE ( SIGMAS, SIGPAB (3) )
      EQUIVALENCE ( SIGPAB (1), SIGMAB (1) )

c (original name: NUCLEV)
      LOGICAL LCLVSL, LFLVSL, LRLVSL, LEQSBL
      COMMON /FKNLEV/ PAENUC (200,2), SHENUC (200,2), DEFRMI (2),
     &                DEFMAG (2), ENNCLV (160,2), RANCLV (160,2),
     &                CUMRAD (0:160,2), RUSNUC (2),
     &                ENPLVL (114), ENNLVL(164), JUSNUC (160,2),
     &                NTANUC (2), NAVNUC (2), NLSNUC (2), NCONUC (2),
     &                NSKNUC (2), NHANUC (2), NUSNUC (2), NACNUC (2),
     &                JMXNUC (2), IPRNUC (3), JPRNUC (3), MAGNUM (8),
     &                MAGNUC (2), MGSNUC (8,2), MGSSNC (25,2),
     &                NSBSHL (2), NMNSBS (2), NPRNUC, INUCLV, LCLVSL,
     &                LFLVSL, LRLVSL, LEQSBL
      DIMENSION JUSPRO (160), JUSNEU (160), MGSPRO (8), MGSNEU (8),
     &          MGSSPR (19) , MGSSNE (25)
      EQUIVALENCE ( RUSNUC (1), RUSPRO )
      EQUIVALENCE ( RUSNUC (2), RUSNEU )
      EQUIVALENCE ( JUSNUC (1,1), JUSPRO (1) )
      EQUIVALENCE ( JUSNUC (1,2), JUSNEU (1) )
      EQUIVALENCE ( MGSNUC (1,1), MGSPRO (1) )
      EQUIVALENCE ( MGSNUC (1,2), MGSNEU (1) )
      EQUIVALENCE ( MGSSNC (1,1), MGSSPR (1) )
      EQUIVALENCE ( MGSSNC (1,2), MGSSNE (1) )
      EQUIVALENCE ( NTANUC (1), NTAPRO )
      EQUIVALENCE ( NTANUC (2), NTANEU )
      EQUIVALENCE ( NAVNUC (1), NAVPRO )
      EQUIVALENCE ( NAVNUC (2), NAVNEU )
      EQUIVALENCE ( NLSNUC (1), NLSPRO )
      EQUIVALENCE ( NLSNUC (2), NLSNEU )
      EQUIVALENCE ( NCONUC (1), NCOPRO )
      EQUIVALENCE ( NCONUC (2), NCONEU )
      EQUIVALENCE ( NSKNUC (1), NSKPRO )
      EQUIVALENCE ( NSKNUC (2), NSKNEU )
      EQUIVALENCE ( NHANUC (1), NHAPRO )
      EQUIVALENCE ( NHANUC (2), NHANEU )
      EQUIVALENCE ( NUSNUC (1), NUSPRO )
      EQUIVALENCE ( NUSNUC (2), NUSNEU )
      EQUIVALENCE ( NACNUC (1), NACPRO )
      EQUIVALENCE ( NACNUC (2), NACNEU )
      EQUIVALENCE ( JMXNUC (1), JMXPRO )
      EQUIVALENCE ( JMXNUC (2), JMXNEU )
      EQUIVALENCE ( MAGNUC (1), MAGPRO )
      EQUIVALENCE ( MAGNUC (2), MAGNEU )

c (original name: PARNUC)
      PARAMETER ( PIGRK  = PIPIPI )
      PARAMETER ( ALEVEL = 8.D-03 )
      PARAMETER ( RCNUCL = 1.12D+00 )
      PARAMETER ( R0SIG  = 1.3D+00 )
      PARAMETER ( R0SIGK = 1.5D+00 )
      PARAMETER ( RCOULB = 1.5D+00 )
      PARAMETER ( COULBH = 0.88235D-03 )
      PARAMETER ( RHONU0 = 0.75D+00 / PIGRK / RCNUCL / RCNUCL / RCNUCL )
      PARAMETER ( TAUFO0 = 10.0D+00 )
      PARAMETER ( EKEEXP = 0.03D+00 )
      PARAMETER ( EKREXP = 0.05D+00 )
      PARAMETER ( EKEMNM = 0.01D+00 )
      PARAMETER ( NCPMX = 120 )
      COMMON /FKPARN/ EKORI , PXORI , PYORI , PZORI , PTORI , TAUFOR,
     &                ENNUC  (NCPMX), PNUCL  (NCPMX), EKFNUC (NCPMX),
     &                XSTNUC (NCPMX), YSTNUC (NCPMX), ZSTNUC (NCPMX),
     &                PXNUCL (NCPMX), PYNUCL (NCPMX), PZNUCL (NCPMX),
     &                RSTNUC (NCPMX), FREEPA (NCPMX), CRRPAN (NCPMX),
     &                CRRPAP (NCPMX), BSTNUC (NCPMX), AGENUC (NCPMX),
     &                TAUFPA (NCPMX), RHNUCL(NCPMX,2), BNDGAV, DEFMIN,
     &                KPNUCL (NCPMX), KRFNUC (NCPMX), ILINUC (NCPMX),
     &                INUCTS (NCPMX), ISFNUC (NCPMX), KPORI , IBORI ,
     &                IBNUCL, NPNUC , NNUCTS

c
      DATA LABRST, LELSTC, LINELS, LCHEXC, LABSRP, LABSTH / 6*.FALSE. /
      DATA POTBAR / POTBA0 /, POTMES / POTME0 /, WLLRES / 0.D+00 /
      DATA JUSNUC / 320 * 0 /, INUCLV / 1 /, IEVPRE / 0 /
      DATA MAGNUM / 2, 8, 20, 28, 50, 82, 126, 160 /
      DATA LPREEQ / .FALSE. /
c /cmpisg/
      DATA JSTOKP / 1, 8, 13, 14, 23 /
      DATA KPTOJS / 1, 6*0, 2, 4*0, 3, 4, 8*0, 5 /
      DATA CHPIRE / 'PI+PPI+P','PI-PPI-P','PI-PPI0N','PI0PPI0P',
     &              'PI0PPI+N','PI-NPI-N','PI+NPI+N','PI+NPI0P',
     &              'PI0NPI0N','PI0NPI-P' /
      DATA KPIIRE / 13, 1, 14, 1, 14, 1, 23, 1, 23, 1, 14, 8,
     &              13, 8, 13, 8, 23, 8, 23, 8 /
      DATA KPIORE / 13, 1, 14, 1, 23, 8, 23, 1, 13, 8, 14, 8,
     &              13, 8, 23, 1, 23, 8, 14, 1 /
      DATA IPIREA / 1, 0, 7, 8, 2, 3, 6, 0, 4, 5, 9, 10 /
      DATA IPIINE / 1, 2, 3, 4, 5, 6 /
c /frbkcm/
      DATA LFRMBK / .FALSE. /
      DATA NBUFBK /   500  /
      DATA EXMXFB / 80.0 D+00 /
      DATA R0FRBK / 1.18 D+00 /
      DATA R0CFBK / 2.173D+00 /
      DATA C1CFBK / 6.103D-03 /
      DATA C2CFBK / 9.443D-03 /
c /parnuc/
      DATA TAUFOR / TAUFO0 /
c=== End of Block Data Bdpree =========================================*
      END

c*sr 17.5. BLKDT1 removed since commons  never used

c*sr 17.5. BLKDT2 removed since commons  never used

c*sr 17.5. BLKDT3 removed since /REAC/  never used

c*sr 17.5. BLKDT4 removed since commons never used

c*sr 17.5. BLKDT5 removed since /ADDHP/, /ADDHN/ never used

c*sr 17.5. BLKDT6 removed since commons either never used or
c          replaced (/PART/)

c*sr 17.5. BLKDT7 removed since /DECAYC/ never unsed

c$ CREATE DT_DOST.FOR
cCOPY DT_DOST
c                                                                      *
c=== dost==============================================================*
c                                                                      *
CDECK  ID>, DT_DOST
      DOUBLE PRECISION FUNCTION DT_DOST(I,Z)

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
C--------------------------------------------------------------------
C SUBNAME = DT_DOST
C--------------------------------------------------------------------
c (original name: EVA0)
      COMMON /FKEVA0/ Y0, B0, P0 (1001), P1 (1001), P2 (1001),
     *                FLA (6), FLZ (6), RHO (6), OMEGA (6), EXMASS (6),
     *                CAM2 (130), CAM3 (200), CAM4 (130), CAM5 (200),
     *                T (4,7), RMASS (297), ALPH (297), BET (297),
     *                APRIME (250), IA (6), IZ (6)

C--------------------------------------------------------------------
      IF(Z-70.D0)1,2,2
    2 DT_DOST=T(I,7)
    3 RETURN
    1 IF(Z-10.D0)5,5,6
    5 DT_DOST=T(I,1)
      GOTO3
    6 N=.1D0*Z+1.D0
      X=10*N
      X=(X-Z)*.1D0
      DT_DOST=X*T(I,N-1)+(1.D0-X)*T(I,N)
      GOTO3
      END

c$ CREATE ECMSEX.FOR
cCOPY ECMSEX
c
c=== ecmsex ===========================================================*
c
CDECK  ID>, DT_ECMSEX
      SUBROUTINE DT_ECMSEX( NPEXPL, ETOTEX, DETCMS, AMEXPL, ETEXPL,
     &                    PXEXPL, PYEXPL, PZEXPL )

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     ECMSEX: makes an expansion of the total energy of a system of    *
c             Npexpl particles of masses Amexpl from Etotex to Etotex  *
c             + Detcms in their CMS reference system.                  *
c             The original total energies and momenta are stored into  *
c             etexpl and px,y,zexpl. The "expansion" is supposed to    *
c             occur without direction change for the momenta and with  *
c             an unique (scalar) expansion factor for the momenta of   *
c             all particles (--> px,y,z_tot=0 is assured "a priori")   *
c             The resulting total energies and momenta are stored      *
c             again into etexpl and px,y,zexpl.                        *
c                                                                      *
c     Created on 08 february 1995  by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 13-feb-95     by    Alfredo Ferrari               *
c                                                                      *
c     Input variables:                                                 *
c                                                                      *
c                 Npexpl = number of particles                         *
c                 Etotex = original invariant mass of npexpl particle  *
c                          system                                      *
c                 Detcms = requested variation in the system invariant *
c                          mass                                        *
c              Amexpl(i) = mass of the ith particle, i=1,npexpl        *
c              Etexpl(i) = (total) energy of the ith particle in the   *
c                          CMS of the npexpl particle system           *
c          Px,y,zexpl(i) = momentum components of the ith particle in  *
c                          the CMS of the npexpl particle system       *
c                                                                      *
c     Output variables:                                                *
c                                                                      *
c              Etexpl(i) = (total) energy of the ith particle in the   *
c                          CMS of the npexpl particle system           *
c          Px,y,zexpl(i) = momentum components of the ith particle in  *
c                          the CMS of the npexpl particle system       *
c                                                                      *
c     The unit of energy and momentum is immaterial provided Etotex    *
c     Detcms, Amexpl, Etexpl, and Px,y,zexpl are given in the same     *
c     units.                                                           *
c                                                                      *
c     Limitations: Detcms must be such to represent a small variation  *
c                  on the TOTAL energy of EACH particle. Moreover for  *
c                  negative Detcms it must be assured that there is a  *
c                  physical solution.                                  *
c                                                                      *
c----------------------------------------------------------------------*
c
      DIMENSION PXEXPL (NPEXPL), PYEXPL (NPEXPL), PZEXPL (NPEXPL),
     &          ETEXPL (NPEXPL), AMEXPL (NPEXPL)
c
      ETOTNW = ETOTEX + DETCMS
c  +-------------------------------------------------------------------*
c  |  Just two particles: no need for approximate treatment
      IF ( NPEXPL .EQ. 2 ) THEN
         PHEXPL = SQRT ( PXEXPL (1)**2 + PYEXPL (1)**2 + PZEXPL (1)**2 )
         IF ( PHEXPL .GT. ANGLGB ) THEN
            CXCMS = PXEXPL (1) / PHEXPL
            CYCMS = PYEXPL (1) / PHEXPL
            CZCMS = PZEXPL (1) / PHEXPL
         ELSE
            CALL DT_RACO( CXCMS, CYCMS, CZCMS )
         END IF
         ETEXPL (1) = HLFHLF * ( ETOTNW + ( AMEXPL (1) - AMEXPL (2) )
     &              * ( AMEXPL (1) + AMEXPL (2) ) / ETOTNW )
         PTCMS  = SQRT ( ( ETEXPL (1) - AMEXPL (1) )
     &                 * ( ETEXPL (1) + AMEXPL (1) ) )
         PXEXPL (1) = PTCMS * CXCMS
         PYEXPL (1) = PTCMS * CYCMS
         PZEXPL (1) = PTCMS * CZCMS
c  |  Now the 2nd particle
         ETEXPL (2) = ETOTNW - ETEXPL (1)
         PXEXPL (2) =-PXEXPL (1)
         PYEXPL (2) =-PYEXPL (1)
         PZEXPL (2) =-PZEXPL (1)
         RETURN
      END IF
c  |
c  +-------------------------------------------------------------------*
c  Preliminary checks:
      AMTOT  = ZERZER
      ACOFF  = ZERZER
      BCOFF  = ZERZER
      EKENOW = ZERZER
c  +-------------------------------------------------------------------*
c  |  Make a check on the available energy:
      DO 100 I = 1, NPEXPL
         AMTOT = AMTOT + AMEXPL (I)
c  |  Setting up the equation coefficients
         AMSQEX = AMEXPL (I)**2
         PSQEXP = PXEXPL (I)**2 + PYEXPL (I)**2 + PZEXPL (I)**2
         XSQEXP = PSQEXP / AMSQEX
c  |  +----------------------------------------------------------------*
c  |  |  Still a relative error of 1E-12 can occur!
         IF ( XSQEXP .LT. 2.D-04 ) THEN
            EKEEXP = HLFHLF * AMEXPL (I) * XSQEXP * ( ONEONE - 0.25D+00
     &             * XSQEXP * ( ONEONE - HLFHLF * XSQEXP ) )
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Normal computation
         ELSE
            EKEEXP = ETEXPL (I) - AMEXPL (I)
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         EKENOW = EKENOW + EKEEXP
         OVSQRX = AMSQEX / ETEXPL (I)
         CONTR  = XSQEXP * OVSQRX
         BCOFF  = BCOFF + CONTR
         ACOFF  = ACOFF + CONTR**2 * OVSQRX / AMSQEX
  100 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Print an error message and stop:
      IF ( AMTOT .GE. ETOTEX .OR. AMTOT .GE. ETOTNW ) THEN
         WRITE (ErrorOut,*)' *** Ecmsex: total energy < mass!!',
     &                         ETOTEX, ETOTNW, AMTOT
         STOP 'STOP:ECMSEX-AMTOT-ETOTEX'
      END IF
c  |
c  +-------------------------------------------------------------------*
      EKGOAL = EKENOW +DETCMS
c     ECMEPS = MAX  ( ANGLGB * ETOTNW , 1.D-12 * ( ETOTNW - AMTOT ) )
      ECMEPS = SQRT ( ANGLGB * ETOTNW * 1.D-12 * ( ETOTNW - AMTOT ) )
      DENOW  = DETCMS
      ICYCL  = 0
c  +-------------------------------------------------------------------*
c  |  Main approximation loop:
 1000 CONTINUE
         ICYCL  = ICYCL + 1
         ALPHAP = FOUFOU * DENOW / ( BCOFF + SQRT ( BCOFF**2 - TWOTWO
     &          * ACOFF  * DENOW ) )
         IF ( ICYCL .GT. 3 ) WRITE (ErrorOut,*)
     &' *** ECMSEX:DENOW,DETCMS,ICYCL,ALPHAP,ETOTEX,NPEXPL,EKEXPL',
     &             DENOW,DETCMS,ICYCL,ALPHAP,ETOTEX,NPEXPL,
     &            (ETEXPL(J)-AMEXPL(J),J=1,NPEXPL)
         EXPANS = SQRT ( ONEONE + ALPHAP )
         ACOFF  = ZERZER
         BCOFF  = ZERZER
         EKENOW = ZERZER
c  |  +----------------------------------------------------------------*
c  |  |  Setting up the equation coefficients
         DO 3000 I = 1, NPEXPL
            PXEXPL (I) = PXEXPL (I) * EXPANS
            PYEXPL (I) = PYEXPL (I) * EXPANS
            PZEXPL (I) = PZEXPL (I) * EXPANS
            AMSQEX = AMEXPL (I)**2
            PSQEXP = PXEXPL (I)**2 + PYEXPL (I)**2 + PZEXPL (I)**2
            ETEXPL (I) = SQRT ( AMSQEX + PSQEXP )
            XSQEXP = PSQEXP / AMSQEX
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Still a relative error of 1E-12 can occur!
            IF ( XSQEXP .LT. 2.D-04 ) THEN
               EKEEXP = HLFHLF * AMEXPL (I) * XSQEXP * ( ONEONE
     &                - 0.25D+00 * XSQEXP * ( ONEONE - HLFHLF * XSQEXP))
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Normal computation
            ELSE
               EKEEXP = ETEXPL (I) - AMEXPL (I)
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
            EKENOW = EKENOW + EKEEXP
            OVSQRX = AMSQEX / ETEXPL (I)
            CONTR  = XSQEXP * OVSQRX
            BCOFF  = BCOFF + CONTR
            ACOFF  = ACOFF + CONTR**2 * OVSQRX / AMSQEX
 3000    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
         DENOW  = EKGOAL - EKENOW
      IF ( ABS (DENOW) .GT. ECMEPS ) GO TO 1000
c  |
c  +-------------------------------------------------------------------*
      ETEPS  = CSNNRM * ETOTNW
      ECHCK  = ETOTNW
      PXCHCK = ZERZER
      PYCHCK = ZERZER
      PZCHCK = ZERZER
c  +-------------------------------------------------------------------*
c  |  Compute energy and momentum conservation:
      DO 7000 K = 1, NPEXPL
         ECHCK  = ECHCK  - ETEXPL (K)
         PXCHCK = PXCHCK - PXEXPL (K)
         PYCHCK = PYCHCK - PYEXPL (K)
         PZCHCK = PZCHCK - PZEXPL (K)
 7000 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Check energy and momentum conservation:
      IF ( ABS (ECHCK) + ABS (PXCHCK) + ABS (PYCHCK) + ABS (PZCHCK)
     &    .GT. ETEPS  ) THEN
         WRITE (ErrorOut,*)
     &         ' *** ECMSEX:ENERGY OR MOMENTUM CONSERVATION FAILURE:'
         WRITE (ErrorOut,*)
     &         ' NPEXPL,ETOTNW,ECHCK,PXCHCK,PYCHCK,PZCHCK',
     &           NPEXPL,ETOTNW,ECHCK,PXCHCK,PYCHCK,PZCHCK
      END IF
c  |
c  +-------------------------------------------------------------------*
c=== End of subroutine ECMSEX =========================================*
      RETURN
      END

c*sr 30.6. routine replaced completely
c$ CREATE EEXLVL.FOR
cCOPY EEXLVL
c
c=== eexlvl ===========================================================*
c
CDECK  ID>, DT_EEXLVL
      SUBROUTINE DT_EEXLVL( JA, JZ, EEX1ST, EEX2ND, EEXCON )

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     Created on 06 december 1991  by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 05-feb-96     by    Alfredo Ferrari               *
c                                                                      *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: EVA0)
      COMMON /FKEVA0/ Y0, B0, P0 (1001), P1 (1001), P2 (1001),
     *                FLA (6), FLZ (6), RHO (6), OMEGA (6), EXMASS (6),
     *                CAM2 (130), CAM3 (200), CAM4 (130), CAM5 (200),
     *                T (4,7), RMASS (297), ALPH (297), BET (297),
     *                APRIME (250), IA (6), IZ (6)

c (original name: FHEAVY,FHEAVC)
      PARAMETER ( MXHEAV = 100 )
      CHARACTER*8 ANHEAV
      COMMON /FKFHVY/ CXHEAV (MXHEAV), CYHEAV (MXHEAV),
     &                CZHEAV (MXHEAV), TKHEAV (MXHEAV),
     &                PHEAVY (MXHEAV), WHEAVY (MXHEAV),
     &                AMHEAV  ( 12 ) , AMNHEA  ( 12 ) ,
     &                KHEAVY (MXHEAV), ICHEAV  ( 12 ) ,
     &                IBHEAV  ( 12 ) , NPHEAV
      COMMON /FKFHVC/ ANHEAV  ( 12 )

c (original name: NUCDAT)
      PARAMETER ( AMUAMU = AMUGEV )
      PARAMETER ( AMPROT = AMPRTN )
      PARAMETER ( AMNEUT = AMNTRN )
      PARAMETER ( AMELEC = AMELCT )
      PARAMETER ( R0NUCL = 1.12        D+00 )
      PARAMETER ( RCCOUL = 1.7         D+00 )
      PARAMETER ( FERTHO = 14.33       D-09 )
      PARAMETER ( EXPEBN = 2.39        D+00 )
      PARAMETER ( BEXC12 = FERTHO * 72.40715579499394D+00 )
      PARAMETER ( AMUC12 = AMUGEV - HLFHLF * AMELCT + BEXC12 / 12.D+00 )
      PARAMETER ( AMHYDR = AMPRTN + AMELCT  )
      PARAMETER ( AMHTON = AMHYDR - AMNTRN  )
      PARAMETER ( AMNTOU = AMNTRN - AMUC12  )
      PARAMETER ( AMUCSQ = AMUC12 * AMUC12 )
      PARAMETER ( EBNDAV = HLFHLF * (AMPRTN + AMNTRN) - AMUC12 )
      PARAMETER ( GAMMIN = 1.0D-06 )
      PARAMETER ( GAMNSQ = 2.0D+00 * GAMMIN * GAMMIN )
      PARAMETER ( TVEPSI = GAMMIN / 100.D+00 )

      COMMON /FKNDAT/ AV0WEL,     APFRMX,     AEFRMX,     AEFRMA,
     &                RDSNUC,     V0WELL (2), PFRMMX (2), EFRMMX (2),
     &                EFRMAV (2), AMNUCL (2), AMNUSQ (2), EBNDNG (2),
     &                VEFFNU (2), ESLOPE (2), PKMNNU (2), EKMNNU (2),
     &                PKMXNU (2), EKMXNU (2), EKMNAV (2), EKINAV (2),
     &                EXMNAV (2), EKUPNU (2), EXMNNU (2), EXUPNU (2),
     &                ERCLAV (2), ESWELL (2), FINCUP (2), AMRCAV    ,
     &                AMRCSQ    , ATO1O3    , ZTO1O3    , ELBNDE (0:100)

c
      LOGICAL LHOLE
      SAVE SQATAR, JAOLD
      DATA JAOLD / 0 /
      LHOLE = .FALSE.
      GO TO 10
      ENTRY DT_EEXLVH ( JA, JZ, EEX1ST, EEX2ND, EEXFOR, EEXCON, NHOLE,
     &               IPHOL )
      LHOLE  = NHOLE .LE. 1
      EEXFOR = ZERZER
   10 CONTINUE
c
c  +-------------------------------------------------------------------*
c  |  Just one proton or neutron be sure no excited level is left:
      IF ( JA .LE. 1 ) THEN
         EEX1ST = AXCSSV
         EEX2ND = AXCSSV
         EEXCON = AXCSSV
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |  Actually it is a batch of protons or neutrons
      ELSE IF ( JA .LE. 0 .OR. JZ .LE. 0 ) THEN
         EEX1ST = ZERZER
         EEX2ND = ZERZER
         EEXCON = ZERZER
         RETURN
      END IF
c  |
c  +-------------------------------------------------------------------*
      GO TO (  200,  300,  400 ), JA - 1
      GO TO (  500,  600,  700,  800,  900, 1000, 1100, 1200, 1300,
     &        1400, 1500, 1600, 1700, 1800, 1900, 2000, 2100 ), JA -  4
      GO TO ( 2200, 2300, 2400, 2500, 2600, 2700, 2800, 2900 ), JA - 21
      GO TO ( 3600, 3700, 3800, 3900, 4000 ), JA - 35
      GO TO ( 4600, 4700, 4800, 4900, 5000, 5100 ), JA - 45
      GO TO ( 7400, 7500, 7600, 7700, 7800, 7900 ), JA - 73
      GO TO ( 8600, 8700, 8800, 8900, 9000, 9100, 9200, 9300, 9400),
     &    JA - 85
      GO TO ( 10400, 10500, 10600, 10700, 10800, 10900 ), JA - 103
      GO TO ( 19400, 19500, 19600, 19700, 19800, 19900, 20000, 20100,
     &        20200, 20300, 20400, 20500, 20600, 20700, 20800, 20900 ),
     &    JA - 193
      GO TO 90000
c  +-------------------------------------------------------------------*
c  |  Deuteron (no other possibility, see above)
  200 CONTINUE
         EEX1ST = MAX ( AMHEAV (1) + AMHEAV (2) - AMHEAV (3),
     &                  AMNHEA (1) + AMNHEA (2) - AMNHEA (3) )
     &                + GAMMIN
         EEX2ND = EEX1ST
         EEXCON = EEX1ST
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
  300 CONTINUE
c  |  +----------------------------------------------------------------*
c  |  |  Triton:
         IF ( JZ .EQ. 1 ) THEN
            EEX1ST = MAX ( AMHEAV (1) + AMHEAV (3) - AMHEAV (4),
     &                     AMNHEA (1) + AMNHEA (3) - AMNHEA (4) )
     &                   + GAMMIN
            EEX2ND = EEX1ST
            EEXCON = EEX1ST
            RETURN
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  3-He (no other chance, see above):
         ELSE
            EEX1ST = MAX ( AMHEAV (2) + AMHEAV (3) - AMHEAV (5),
     &                     AMNHEA (2) + AMNHEA (3) - AMNHEA (5) )
     &                   + GAMMIN
            EEX2ND = EEX1ST
            EEXCON = EEX1ST
            RETURN
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |
c  +-------------------------------------------------------------------*
c  |
  400 CONTINUE
c  |  +----------------------------------------------------------------*
c  |  |  4-He:
         IF ( JZ .EQ. 2 ) THEN
            EEX1ST = MAX ( AMHEAV (2) + AMHEAV (4) - AMHEAV (6),
     &                     AMNHEA (2) + AMNHEA (4) - AMNHEA (6) )
     &                   + GAMMIN
            EEX2ND = EEX1ST
            EEXCON = EEX1ST
            RETURN
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  All other A=4 are particle unstable:
         ELSE
            EEX1ST = ZERZER
            EEX2ND = ZERZER
            EEXCON = ZERZER
            RETURN
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |
c  +-------------------------------------------------------------------*
c  |
  500 CONTINUE
      GO TO 90000
c  |
c  +-------------------------------------------------------------------*
c  |
  600 CONTINUE
         IF ( JZ .EQ. 3 ) THEN
            EEXCON = ZERZER
            EEX1ST = 2.185D-03
            EEX2ND = 3.562D-03
         ELSE IF ( JZ .EQ. 2 ) THEN
            EEXCON = 1.80D-03
            EEX1ST = 1.80D-03
            EEX2ND = 1.80D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
  700 CONTINUE
         IF ( JZ .EQ. 4 ) THEN
            EEXCON = 4.57  D-03
c           EEXCON = 0.4292D-03
            EEX1ST = 0.4292D-03
            EEX2ND = 4.57  D-03
c           EEX2ND = 0.4292D-03
         ELSE IF ( JZ .EQ. 3 ) THEN
            EEXCON = 4.63   D-03
c           EEXCON = 0.47761D-03
            EEX1ST = 0.47761D-03
            EEX2ND = 4.63   D-03
c           EEX2ND = 0.47761D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
  800 CONTINUE
         IF ( JZ .EQ. 5 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.78D-03
            EEX2ND = 2.32D-03
c           EEX2ND = 0.78D-03
         ELSE IF ( JZ .EQ. 4 ) THEN
            EEXCON = 6.D-03
            EEX1ST = 2.94D-03
            EEX2ND = 6.D-03
         ELSE IF ( JZ .EQ. 3 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.9808D-03
            EEX2ND = 2.261D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
  900 CONTINUE
         IF ( JZ .EQ. 4 ) THEN
            EEXCON = 1.68D-03
            EEX1ST = 1.68D-03
            EEX2ND = 2.429D-03
         ELSE IF ( JZ .EQ. 3 ) THEN
            EEXCON = 2.691D-03
            EEX1ST = 2.691D-03
            EEX2ND = 4.31 D-03
c           EEX2ND = 2.691D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 1000 CONTINUE
         IF ( JZ .EQ. 6 ) THEN
            EEXCON = 5.22D-03
            EEX1ST = 3.353D-03
            EEX2ND = 5.22D-03
         ELSE IF ( JZ .EQ. 5 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.7183D-03
            EEX2ND = 1.7402D-03
         ELSE IF ( JZ .EQ. 4 ) THEN
            EEXCON = 5.9583D-03
            EEX1ST = 3.3680D-03
            EEX2ND = 5.9583D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 1100 CONTINUE
         IF ( JZ .EQ. 6 ) THEN
            EEXCON = 4.319D-03
            EEX1ST = 2.0000D-03
            EEX2ND = 4.319D-03
         ELSE IF ( JZ .EQ. 5 ) THEN
            EEXCON = 4.4451D-03
            EEX1ST = 2.1247D-03
            EEX2ND = 4.4451D-03
         ELSE IF ( JZ .EQ. 4 ) THEN
            EEXCON = 1.79D-03
            EEX1ST = 0.3198D-03
            EEX2ND = 1.79D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 1200 CONTINUE
         IF ( JZ .EQ. 7 ) THEN
            EEXCON = 0.96D-03
            EEX1ST = 0.96D-03
            EEX2ND = 1.19D-03
         ELSE IF ( JZ .EQ. 6 ) THEN
            EEXCON = 7.6540D-03
            EEX1ST = 4.4391D-03
c  |  |  Available only for Nhole >= 2, forbidden zone otherwise
            EEX2ND = 7.6540D-03
            EEX3RD = 12.71 D-03
            IF ( LHOLE ) THEN
               EEXFOR = EEX2ND
               EEX2ND = EEX3RD
               EEXCON = 10.0D-03
            END IF
         ELSE IF ( JZ .EQ. 5 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.9531D-03
            EEX2ND = 1.6736D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 1300 CONTINUE
         IF ( JZ .EQ. 7 ) THEN
            EEXCON = 2.365D-03
            EEX1ST = 2.365D-03
            EEX2ND = 3.511D-03
         ELSE IF ( JZ .EQ. 6 ) THEN
            EEXCON = 3.0884D-03
            EEX1ST = 3.0884D-03
            EEX2ND = 3.6844D-03
         ELSE IF ( JZ .EQ. 5 ) THEN
            EEXCON = 3.483D-03
            EEX1ST = 3.483D-03
            EEX2ND = 3.535D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 1400 CONTINUE
         IF ( JZ .EQ. 8 ) THEN
            EEXCON = 5.17D-03
            EEX1ST = 5.17D-03
            EEX2ND = 5.92D-03
         ELSE IF ( JZ .EQ. 7 ) THEN
            EEXCON = 3.9478D-03
            EEX1ST = 2.3129D-03
            EEX2ND = 3.9478D-03
          ELSE IF ( JZ .EQ. 6 ) THEN
            EEXCON = 6.094D-03
            EEX1ST = 6.094D-03
            EEX2ND = 6.590D-03
         ELSE IF ( JZ .EQ. 5 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.74D-03
            EEX2ND = 1.38D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 1500 CONTINUE
         IF ( JZ .EQ. 6 ) THEN
            EEXCON = 3.105D-03
            EEX1ST = 0.740D-03
            EEX2ND = 3.105D-03
         ELSE IF ( JZ .EQ. 7 ) THEN
            EEXCON = 5.2704D-03
            EEX1ST = 5.2704D-03
            EEX2ND = 5.2989D-03
         ELSE IF ( JZ .EQ. 8 ) THEN
            EEXCON = 5.183D-03
            EEX1ST = 5.183D-03
            EEX2ND = 5.2409D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 1600 CONTINUE
         IF ( JZ .EQ. 7 ) THEN
            EEXCON = ZERZER
c  |  Metastable: T1/2 5.3 us
            EEX1ST = 0.1201D-03
            EEX2ND = 0.397D-03
         ELSE IF ( JZ .EQ. 8 ) THEN
            EEXCON = 6.049 D-03
c  |  Not available for Nhole = 1: forbidden zone
            EEX1ST = 6.049 D-03
            EEX2ND = 6.1304D-03
c  |  For Nhole = 1:
            IF ( LHOLE ) THEN
               EEXFOR = EEX1ST
               EEX1ST = 6.1304D-03
               EEX2ND = 7.117 D-03
               EEXCON = EEX1ST
            END IF
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 1700 CONTINUE
         IF ( JZ .EQ. 7 ) THEN
            EEXCON = 1.3739D-03
            EEX1ST = 1.3739D-03
            EEX2ND = 1.8496D-03
         ELSE IF ( JZ .EQ. 8 ) THEN
            EEXCON = 3.841 D-03
            EEX1ST = 0.8708D-03
            EEX2ND = 3.0552D-03
         ELSE IF ( JZ .EQ. 9 ) THEN
            EEXCON = 3.857 D-03
            EEX1ST = 0.4953D-03
            EEX2ND = 3.104 D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 1800 CONTINUE
         IF ( JZ .EQ. 8 ) THEN
            EEXCON = 3.5551D-03
            EEX1ST = 1.9822D-03
            EEX2ND = 3.5551D-03
         ELSE IF ( JZ .EQ. 9 ) THEN
            EEXCON = 0.9371D-03
            EEX1ST = 0.9371D-03
            EEX2ND = 1.0410D-03
         ELSE IF ( JZ .EQ. 10 ) THEN
            EEXCON = 3.3762D-03
            EEX1ST = 1.8873D-03
            EEX2ND = 3.3762D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 1900 CONTINUE
         IF ( JZ .EQ. 8 ) THEN
            EEXCON = 2.371 D-03
            EEX1ST = 0.0960D-03
            EEX2ND = 1.4717D-03
         ELSE IF ( JZ .EQ. 9 ) THEN
c  |  |  Very risky: the level scheme is very complex and unusual
            EEXCON = 3.907   D-03
            EEX1ST = 0.109893D-03
            EEX2ND = 0.19715 D-03
         ELSE IF ( JZ .EQ. 10 ) THEN
c  |  |  Very risky: the level scheme is very complex and unusual
c  |  |  (and parallel to 19-F)
            EEXCON = 3.84  D-03
            EEX1ST = 0.2383D-03
            EEX2ND = 0.2752D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 2000 CONTINUE
         IF ( JZ .EQ. 8 ) THEN
            EEXCON = 3.568 D-03
            EEX1ST = 1.6737D-03
            EEX2ND = 3.568 D-03
         ELSE IF ( JZ .EQ. 9 ) THEN
            EEXCON = 0.6560D-03
            EEX1ST = 0.6560D-03
            EEX2ND = 0.8229D-03
         ELSE IF ( JZ .EQ. 10 ) THEN
            EEXCON = 4.247 D-03
            EEX1ST = 1.6338D-03
            EEX2ND = 4.247 D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 2100 CONTINUE
         IF ( JZ .EQ. 9 ) THEN
c  |  |  Risky: unusual level scheme
            EEXCON = 1.730 D-03
            EEX1ST = 0.2799D-03
            EEX2ND = 1.101 D-03
         ELSE IF ( JZ .EQ. 10 ) THEN
c  |  |  Risky: unusual level scheme
            EEXCON = 2.7885D-03
            EEX1ST = 0.3505D-03
            EEX2ND = 1.7456D-03
         ELSE IF ( JZ .EQ. 11 ) THEN
c  |  |  Risky: unusual level scheme (like 21-Ne)
            EEXCON = 2.432 D-03
            EEX1ST = 0.3318D-03
            EEX2ND = 1.723 D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 2200 CONTINUE
         IF ( JZ .EQ. 9 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.66D-03
            EEX2ND = 1.36D-03
         ELSE IF ( JZ .EQ. 10 ) THEN
            EEXCON = 1.27D-03
            EEX1ST = 1.27D-03
            EEX2ND = 3.36D-03
         ELSE IF ( JZ .EQ. 11 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.583D-03
            EEX2ND = 0.657D-03
         ELSE IF ( JZ .EQ. 12 ) THEN
            EEXCON = 3.308D-03
            EEX1ST = 1.247D-03
            EEX2ND = 3.308D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 2300 CONTINUE
         IF ( JZ .EQ. 10 ) THEN
            EEXCON = 1.017D-03
            EEX1ST = 1.017D-03
            EEX2ND = 1.702D-03
         ELSE IF ( JZ .EQ. 11 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.440D-03
            EEX2ND = 2.076D-03
         ELSE IF ( JZ .EQ. 12 ) THEN
            EEXCON = 2.051D-03
            EEX1ST = 0.4507D-03
            EEX2ND = 2.051D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 2400 CONTINUE
         IF ( JZ .EQ. 10 ) THEN
            EEXCON = 3.867D-03
            EEX1ST = 1.981D-03
            EEX2ND = 3.867D-03
         ELSE IF ( JZ .EQ. 11 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.4723D-03
            EEX2ND = 0.5633D-03
         ELSE IF ( JZ .EQ. 12 ) THEN
            EEXCON = 4.1228D-03
            EEX1ST = 1.36859D-03
            EEX2ND = 4.1228D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 2500 CONTINUE
         IF ( JZ .EQ. 11 ) THEN
            EEXCON = 2.202D-03
            EEX1ST = 0.0895D-03
            EEX2ND = 1.0693D-03
         ELSE IF ( JZ .EQ. 12 ) THEN
            EEXCON = 0.5851D-03
            EEX1ST = 0.5851D-03
            EEX2ND = 0.9748D-03
         ELSE IF ( JZ .EQ. 13 ) THEN
            EEXCON = 0.4515D-03
            EEX1ST = 0.4515D-03
            EEX2ND = 0.9448D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 2600 CONTINUE
         IF ( JZ .EQ. 12 ) THEN
            EEXCON = 2.9384D-03
            EEX1ST = 1.8087D-03
            EEX2ND = 2.9384D-03
         ELSE IF ( JZ .EQ. 13 ) THEN
            EEXCON = ZERZER
c  |  |  Metastable T1/2 6.36 s:
            EEX1ST = 0.2282D-03
            EEX2ND = 0.4169D-03
         ELSE IF ( JZ .EQ. 14 ) THEN
            EEXCON = 2.7835D-03
            EEX1ST = 1.7959D-03
            EEX2ND = 2.7835D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 2700 CONTINUE
         IF ( JZ .EQ. 12 ) THEN
            EEXCON = 0.9846D-03
            EEX1ST = 0.9846D-03
            EEX2ND = 1.6983D-03
         ELSE IF ( JZ .EQ. 13 ) THEN
            EEXCON = 0.84376D-03
            EEX1ST = 0.84376D-03
            EEX2ND = 1.01446D-03
         ELSE IF ( JZ .EQ. 14 ) THEN
            EEXCON = 0.7803D-03
            EEX1ST = 0.7803D-03
            EEX2ND = 0.9568D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 2800 CONTINUE
         IF ( JZ .EQ. 12 ) THEN
            EEXCON = 3.863D-03
            EEX1ST = 1.4735D-03
            EEX2ND = 3.863D-03
         ELSE IF ( JZ .EQ. 13 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.030642D-03
            EEX2ND = 0.9722D-03
         ELSE IF ( JZ .EQ. 14 ) THEN
            EEXCON = 4.6178D-03
            EEX1ST = 1.7789D-03
c  |  |  Not available for nhole = 1: zone forbidden
            EEX2ND = 4.6178D-03
            EEX3RD = 6.2765D-03
            IF ( LHOLE ) THEN
               EEXFOR = EEX2ND
               EEX2ND = EEX3RD
               EEXCON = EEX3RD
            END IF
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 2900 CONTINUE
         IF ( JZ .EQ. 13 ) THEN
            EEXCON = 1.3977D-03
            EEX1ST = 1.3977D-03
            EEX2ND = 1.7537D-03
         ELSE IF ( JZ .EQ. 14 ) THEN
            EEXCON = 1.2733D-03
            EEX1ST = 1.2733D-03
            EEX2ND = 2.0282D-03
         ELSE IF ( JZ .EQ. 15 ) THEN
            EEXCON = 1.3836D-03
            EEX1ST = 1.3836D-03
            EEX2ND = 1.9533D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 3600 CONTINUE
         IF ( JZ .EQ. 17 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.78842D-03
            EEX2ND = 1.16475D-03
         ELSE IF ( JZ .EQ. 18 ) THEN
            EEXCON = 4.1783D-03
            EEX1ST = 1.97039D-03
            EEX2ND = 4.1783D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 3700 CONTINUE
         IF ( JZ .EQ. 17 ) THEN
            EEXCON = 1.7266D-03
            EEX1ST = 1.7266D-03
            EEX2ND = 3.087D-03
         ELSE IF ( JZ .EQ. 18 ) THEN
            EEXCON = 1.4098D-03
            EEX1ST = 1.4098D-03
            EEX2ND = 1.6113D-03
         ELSE IF ( JZ .EQ. 19 ) THEN
            EEXCON = 1.369D-03
            EEX1ST = 1.369D-03
            EEX2ND = 1.379D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 3800 CONTINUE
         IF ( JZ .EQ. 17 ) THEN
            EEXCON = 0.6713D-03
            EEX1ST = 0.6713D-03
            EEX2ND = 0.7553D-03
         ELSE IF ( JZ .EQ. 18 ) THEN
            EEXCON = 3.3774D-03
            EEX1ST = 2.16760D-03
            EEX2ND = 3.3774D-03
         ELSE IF ( JZ .EQ. 19 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.4587D-03
            EEX2ND = 0.1302D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 3900 CONTINUE
         IF ( JZ .EQ. 17 ) THEN
            EEXCON = 1.3015D-03
            EEX1ST = 0.3964D-03
            EEX2ND = 1.3015D-03
         ELSE IF ( JZ .EQ. 18 ) THEN
            EEXCON = 1.26720D-03
            EEX1ST = 1.26720D-03
            EEX2ND = 1.5174D-03
         ELSE IF ( JZ .EQ. 19 ) THEN
            EEXCON = 2.5226D-03
            EEX1ST = 2.5226D-03
            EEX2ND = 2.8138D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 4000 CONTINUE
         IF ( JZ .EQ. 18 ) THEN
            EEXCON = 2.1208D-03
            EEX1ST = 1.46081D-03
            EEX2ND = 2.1208D-03
         ELSE IF ( JZ .EQ. 19 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.0296D-03
            EEX2ND = 0.8001D-03
         ELSE IF ( JZ .EQ. 20 ) THEN
            EEXCON = 3.3521D-03
            EEX1ST = 3.3521D-03
            EEX2ND = 3.7364D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 4600 CONTINUE
         IF ( JZ .EQ. 19 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.5873D-03
            EEX2ND = 0.691D-03
         ELSE IF ( JZ .EQ. 20 ) THEN
            EEXCON = 3.613D-03
            EEX1ST = 1.347D-03
            EEX2ND = 2.4234D-03
         ELSE IF ( JZ .EQ. 21 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.052012D-03
            EEX2ND = 0.142528D-03
         ELSE IF ( JZ .EQ. 22 ) THEN
            EEXCON = 2.661D-03
            EEX1ST = 0.88925D-03
            EEX2ND = 2.00977D-03
         ELSE IF ( JZ .EQ. 23 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.8014D-03
            EEX2ND = 0.9149D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 4700 CONTINUE
         IF ( JZ .EQ. 20 ) THEN
            EEXCON = 2.5778D-03
            EEX1ST = 2.0131D-03
            EEX2ND = 2.5778D-03
         ELSE IF ( JZ .EQ. 21 ) THEN
            EEXCON = 1.12D-03
            EEX1ST = 0.8079D-03
            EEX2ND = 0.7668D-03
         ELSE IF ( JZ .EQ. 22 ) THEN
            EEXCON = 1.253D-03
            EEX1ST = 0.15938D-03
            EEX2ND = 1.253D-03
         ELSE IF ( JZ .EQ. 23 ) THEN
            EEXCON = 1.1384D-03
            EEX1ST = 0.0876D-03
            EEX2ND = 0.1459D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 4800 CONTINUE
         IF ( JZ .EQ. 20 ) THEN
            EEXCON = 4.284D-03
            EEX1ST = 3.8317D-03
            EEX2ND = 4.284D-03
         ELSE IF ( JZ .EQ. 21 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.1309D-03
            EEX2ND = 0.252D-03
         ELSE IF ( JZ .EQ. 22 ) THEN
            EEXCON = 3.2235D-03
            EEX1ST = 0.983512D-03
            EEX2ND = 2.295618D-03
         ELSE IF ( JZ .EQ. 23 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.3082D-03
            EEX2ND = 0.4206D-03
         ELSE IF ( JZ .EQ. 24 ) THEN
            EEXCON = 3.42D-03
            EEX1ST = 0.7524D-03
            EEX2ND = 1.859D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 4900 CONTINUE
         IF ( JZ .EQ. 20 ) THEN
            EEXCON = 3.351D-03
            EEX1ST = 2.022D-03
            EEX2ND = 3.351D-03
         ELSE IF ( JZ .EQ. 21 ) THEN
            EEXCON = 2.2286D-03
            EEX1ST = 2.2286D-03
            EEX2ND = 2.3718D-03
         ELSE IF ( JZ .EQ. 22 ) THEN
            EEXCON = 1.3815D-03
            EEX1ST = 1.3815D-03
            EEX2ND = 1.542D-03
         ELSE IF ( JZ .EQ. 23 ) THEN
            EEXCON = 1.0214D-03
            EEX1ST = 0.9065D-03
            EEX2ND = 0.15294D-03
         ELSE IF ( JZ .EQ. 24 ) THEN
            EEXCON = 1.563D-03
            EEX1ST = 0.272D-03
            EEX2ND = 1.085D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 5000 CONTINUE
         IF ( JZ .EQ. 20 ) THEN
            EEXCON = 3.00D-03
            EEX1ST = 1.03D-03
            EEX2ND = 3.00D-03
         ELSE IF ( JZ .EQ. 21 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.2569D-03
            EEX2ND = 0.3285D-03
         ELSE IF ( JZ .EQ. 22 ) THEN
            EEXCON = 2.6747D-03
            EEX1ST = 1.5537D-03
            EEX2ND = 2.6747D-03
         ELSE IF ( JZ .EQ. 23 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.2262D-03
            EEX2ND = 0.3201D-03
         ELSE IF ( JZ .EQ. 24 ) THEN
            EEXCON = 2.9245D-03
            EEX1ST = 0.7833D-03
            EEX2ND = 1.8813D-03
         ELSE IF ( JZ .EQ. 25 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.23D-03
            EEX2ND = 0.6510D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 5100 CONTINUE
         IF ( JZ .EQ. 22 ) THEN
            EEXCON = 1.1666D-03
            EEX1ST = 1.1666D-03
            EEX2ND = 1.4373D-03
         ELSE IF ( JZ .EQ. 23 ) THEN
            EEXCON = 2.4157D-03
            EEX1ST = 0.3193D-03
            EEX2ND = 0.9283D-03
         ELSE IF ( JZ .EQ. 24 ) THEN
            EEXCON = 1.1645D-03
            EEX1ST = 0.7491D-03
            EEX2ND = 0.7772D-03
         ELSE IF ( JZ .EQ. 25 ) THEN
            EEXCON = 1.1395D-03
            EEX1ST = 0.2374D-03
            EEX2ND = 1.1395D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 7400 CONTINUE
         IF ( JZ .EQ. 32 ) THEN
            EEXCON = 1.2041D-03
            EEX1ST = 0.5958D-03
            EEX2ND = 1.2041D-03
         ELSE IF ( JZ .EQ. 33 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.1731D-03
            EEX2ND = 0.1830D-03
         ELSE IF ( JZ .EQ. 34 ) THEN
            EEXCON = 0.8538D-03
            EEX1ST = 0.6348D-03
            EEX2ND = 0.8538D-03
         ELSE IF ( JZ .EQ. 35 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.00985D-03
            EEX2ND = 0.0726D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 7500 CONTINUE
         IF ( JZ .EQ. 32 ) THEN
            EEXCON = 0.13968D-03
c  |  Metastable T1/2 48 s:
            EEX1ST = 0.13968D-03
            EEX2ND = 0.13968D-03
         ELSE IF ( JZ .EQ. 33 ) THEN
            EEXCON = 0.19860D-03
            EEX1ST = 0.19860D-03
            EEX2ND = 0.26465D-03
         ELSE IF ( JZ .EQ. 34 ) THEN
            EEXCON = 0.1121D-03
            EEX1ST = 0.1121D-03
            EEX2ND = 0.1328D-03
         ELSE IF ( JZ .EQ. 35 ) THEN
            EEXCON = 0.1196D-03
            EEX1ST = 0.1196D-03
            EEX2ND = 0.1325D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 7600 CONTINUE
         IF ( JZ .EQ. 32 ) THEN
            EEXCON = 1.1084D-03
            EEX1ST = 0.56293D-03
            EEX2ND = 1.1084D-03
         ELSE IF ( JZ .EQ. 33 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.04604D-03
            EEX2ND = 0.08681D-03
         ELSE IF ( JZ .EQ. 34 ) THEN
            EEXCON = 1.1223D-03
            EEX1ST = 0.5591D-03
            EEX2ND = 1.1223D-03
         ELSE IF ( JZ .EQ. 35 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.0455D-03
            EEX2ND = 0.1505D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 7700 CONTINUE
         IF ( JZ .EQ. 32 ) THEN
            EEXCON = 0.495D-03
            EEX1ST = 0.1595D-03
            EEX2ND = 0.223D-03
         ELSE IF ( JZ .EQ. 33 ) THEN
            EEXCON = 0.1949D-03
            EEX1ST = 0.1949D-03
            EEX2ND = 0.21551D-03
         ELSE IF ( JZ .EQ. 34 ) THEN
            EEXCON = 0.1618D-03
c  |  Metastable: T1/2 17.4 s
            EEX1ST = 0.1618D-03
            EEX2ND = 0.1750D-03
         ELSE IF ( JZ .EQ. 35 ) THEN
            EEXCON = 0.1060D-03
c  |  Metastable: T1/2 4.3 m
            EEX1ST = 0.1060D-03
            EEX2ND = 0.1297D-03
         ELSE IF ( JZ .EQ. 36 ) THEN
            EEXCON = ZERZER
c  |  Metastable: T1/2 0.17 us
            EEX1ST = 0.0665D-03
            EEX2ND = 0.1500D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 7800 CONTINUE
         IF ( JZ .EQ. 34 ) THEN
            EEXCON = 1.3088D-03
            EEX1ST = 0.6138D-03
            EEX2ND = 1.3088D-03
         ELSE IF ( JZ .EQ. 35 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.0323D-03
            EEX2ND = 0.0551D-03
         ELSE IF ( JZ .EQ. 36 ) THEN
            EEXCON = 1.0174D-03
            EEX1ST = 0.4550D-03
            EEX2ND = 1.0174D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 7900 CONTINUE
         IF ( JZ .EQ. 34 ) THEN
            EEXCON = ZERZER
c  |  Metastable: T1/2 3.91 m
            EEX1ST = 0.09573D-03
            EEX2ND = 0.3645D-03
         ELSE IF ( JZ .EQ. 35 ) THEN
            EEXCON = 0.2072D-03
c  |  Metastable: T1/2 4.864 s
            EEX1ST = 0.2072D-03
            EEX2ND = 0.2170D-03
         ELSE IF ( JZ .EQ. 36 ) THEN
            EEXCON = 0.13001D-03
c  |  Metastable: T1/2 50 s
            EEX1ST = 0.13001D-03
            EEX2ND = 0.14723D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 8600 CONTINUE
         IF ( JZ .EQ. 36 ) THEN
            EEXCON = 2.2499D-03
            EEX1ST = 1.565D-03
            EEX2ND = 2.2499D-03
         ELSE IF ( JZ .EQ. 37 ) THEN
            EEXCON = 0.4879D-03
            EEX1ST = 0.4879D-03
            EEX2ND = 0.5560D-03
         ELSE IF ( JZ .EQ. 38 ) THEN
            EEXCON = 1.8542D-03
            EEX1ST = 1.0766D-03
            EEX2ND = 1.8542D-03
         ELSE IF ( JZ .EQ. 39 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.2080D-03
            EEX2ND = 0.2182D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 8700 CONTINUE
         IF ( JZ .EQ. 36 ) THEN
            EEXCON = 0.5319D-03
            EEX1ST = 0.5319D-03
            EEX2ND = 1.4198D-03
         ELSE IF ( JZ .EQ. 37 ) THEN
            EEXCON = 0.40258D-03
            EEX1ST = 0.40258D-03
            EEX2ND = 0.8454D-03
         ELSE IF ( JZ .EQ. 38 ) THEN
            EEXCON = 0.3883D-03
            EEX1ST = 0.3883D-03
            EEX2ND = 0.8730D-03
         ELSE IF ( JZ .EQ. 39 ) THEN
            EEXCON = 0.3811D-03
            EEX1ST = 0.3811D-03
            EEX2ND = 0.793D-03
         ELSE IF ( JZ .EQ. 40 ) THEN
            EEXCON = 0.2010D-03
            EEX1ST = 0.2010D-03
            EEX2ND = 0.3362D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 8800 CONTINUE
         IF ( JZ .EQ. 36 ) THEN
            EEXCON = 1.5775D-03
            EEX1ST = 0.7753D-03
            EEX2ND = 1.5775D-03
         ELSE IF ( JZ .EQ. 37 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.02751D-03
            EEX2ND = 0.19632D-03
         ELSE IF ( JZ .EQ. 38 ) THEN
            EEXCON = 2.7340D-03
            EEX1ST = 1.8360D-03
            EEX2ND = 2.7340D-03
         ELSE IF ( JZ .EQ. 39 ) THEN
            EEXCON = 0.2320D-03
            EEX1ST = 0.2320D-03
            EEX2ND = 0.3929D-03
         ELSE IF ( JZ .EQ. 40 ) THEN
            EEXCON = 1.8177D-03
            EEX1ST = 1.0569D-03
            EEX2ND = 1.8177D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 8900 CONTINUE
         IF ( JZ .EQ. 37 ) THEN
            EEXCON = 0.2209D-03
            EEX1ST = 0.2209D-03
            EEX2ND = 0.4975D-03
         ELSE IF ( JZ .EQ. 38 ) THEN
            EEXCON = 1.0319D-03
            EEX1ST = 1.0319D-03
            EEX2ND = 1.4733D-03
         ELSE IF ( JZ .EQ. 39 ) THEN
            EEXCON = 0.9092D-03
c  |  Metastable: T1/2 16.6 s
            EEX1ST = 0.9092D-03
            EEX2ND = 1.5070D-03
         ELSE IF ( JZ .EQ. 40 ) THEN
            EEXCON = 0.5878D-03
c  |  Metastable: T1/2 4.18 m
            EEX1ST = 0.5878D-03
            EEX2ND = 1.0955D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 9000 CONTINUE
         IF ( JZ .EQ. 37 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.1069D-03
            EEX2ND = 0.12181D-03
         ELSE IF ( JZ .EQ. 38 ) THEN
            EEXCON = 1.6559D-03
            EEX1ST = 0.83169D-03
            EEX2ND = 1.6559D-03
         ELSE IF ( JZ .EQ. 39 ) THEN
            EEXCON = 0.68204D-03
            EEX1ST = 0.2020D-03
c  |  Metastable: T1/2 3.19 h
            EEX2ND = 0.68204D-03
         ELSE IF ( JZ .EQ. 40 ) THEN
            EEXCON = 2.1863D-03
c  |  |  Available only for Nhole >= 2, forbidden zone otherwise??
            EEX1ST = 1.7607D-03
            EEX2ND = 2.1863D-03
            IF ( LHOLE ) THEN
               EEXFOR = EEX1ST
               EEX1ST = EEX2ND
            END IF
         ELSE IF ( JZ .EQ. 41 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.1224D-03
c  |  Metastable: T1/2 18.8 S
            EEX2ND = 0.1248D-03
         ELSE IF ( JZ .EQ. 42 ) THEN
            EEXCON = 1.896D-03
            EEX1ST = 0.9479D-03
            EEX2ND = 1.896D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 9100 CONTINUE
         IF ( JZ .EQ. 37 ) THEN
            EEXCON = 0.5020D-03
            EEX1ST = 0.10878D-03
            EEX2ND = 0.5020D-03
         ELSE IF ( JZ .EQ. 38 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.09364D-03
            EEX2ND = 0.4391D-03
         ELSE IF ( JZ .EQ. 39 ) THEN
            EEXCON = 0.5555D-03
c  |  Metastable: T1/2 49.7 m
            EEX1ST = 0.5555D-03
            EEX2ND = 0.6529D-03
         ELSE IF ( JZ .EQ. 40 ) THEN
            EEXCON = 1.205D-03
            EEX1ST = 1.205D-03
            EEX2ND = 1.467D-03
         ELSE IF ( JZ .EQ. 41 ) THEN
            EEXCON = 1.1867D-03
c  |  Metastable: T1/2 62 d
            EEX1ST = 0.1045D-03
            EEX2ND = 1.1867D-03
         ELSE IF ( JZ .EQ. 42 ) THEN
            EEXCON = 1.1558D-03
c  |  Metastable: T1/2 65 s , 50% DECAY BETA+
            EEX1ST = 0.6529D-03
            EEX2ND = 1.1558D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 9200 CONTINUE
         IF ( JZ .EQ. 37 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.1424D-03
            EEX2ND = 0.3168D-03
         ELSE IF ( JZ .EQ. 38 ) THEN
            EEXCON = 1.3846D-03
            EEX1ST = 0.8147D-03
            EEX2ND = 1.3846D-03
         ELSE IF ( JZ .EQ. 39 ) THEN
            EEXCON = 0.24152D-03
            EEX1ST = 0.24152D-03
            EEX2ND = 0.31D-03
         ELSE IF ( JZ .EQ. 40 ) THEN
            EEXCON = 0.9345D-03
            EEX1ST = 0.9345D-03
            EEX2ND = 1.3830D-03
         ELSE IF ( JZ .EQ. 41 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.1351D-03
            EEX2ND = 0.2253D-03
         ELSE IF ( JZ .EQ. 42 ) THEN
            EEXCON = 2.2826D-03
            EEX1ST = 1.50947D-03
            EEX2ND = 2.2826D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 9300 CONTINUE
         IF ( JZ .EQ. 37 ) THEN
            EEXCON = 0.2536D-03
            EEX1ST = 0.2536D-03
            EEX2ND = 0.2668D-03
         ELSE IF ( JZ .EQ. 38 ) THEN
            EEXCON = 0.2134D-03
            EEX1ST = 0.2134D-03
            EEX2ND = 0.4326D-03
         ELSE IF ( JZ .EQ. 39 ) THEN
            EEXCON = 0.5902D-03
            EEX1ST = 0.5902D-03
c  |  Metastable: T1/2 .82 s
            EEX2ND = 0.7586D-03
         ELSE IF ( JZ .EQ. 40 ) THEN
            EEXCON = 0.9471D-03
            EEX1ST = 0.2669D-03
            EEX2ND = 0.9471D-03
         ELSE IF ( JZ .EQ. 41 ) THEN
            EEXCON = 0.6868D-03
c  |  Metastable: T1/2 13.6 y           !!
            EEX1ST = 0.0304D-03
            EEX2ND = 0.6868D-03
         ELSE IF ( JZ .EQ. 42 ) THEN
            EEXCON = 1.36302D-03
            EEX1ST = 0.9433D-03
            EEX2ND = 1.36302D-03
         ELSE IF ( JZ .EQ. 43 ) THEN
            EEXCON = 0.3926D-03
c  |  Metastable: T1/2 43 m
            EEX1ST = 0.3926D-03
            EEX2ND = 0.6807D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
 9400 CONTINUE
         IF ( JZ .EQ. 39 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.2D-03
            EEX2ND = 0.434D-03
         ELSE IF ( JZ .EQ. 40 ) THEN
            EEXCON = 1.300D-03
            EEX1ST = 0.9183D-03
            EEX2ND = 1.300D-03
         ELSE IF ( JZ .EQ. 41 ) THEN
            EEXCON = 0.04096D-03
            EEX1ST = 0.04096D-03
            EEX2ND = 0.05872D-03
         ELSE IF ( JZ .EQ. 42 ) THEN
            EEXCON = 1.5737D-03
            EEX1ST = 0.8710D-03
            EEX2ND = 1.5737D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
10400 CONTINUE
         IF ( JZ .EQ. 44 ) THEN
            EEXCON = 0.8885D-03
            EEX1ST = 0.35790D-03
            EEX2ND = 0.8885D-03
         ELSE IF ( JZ .EQ. 45 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.051422D-03
            EEX2ND = 0.097114D-03
         ELSE IF ( JZ .EQ. 46 ) THEN
            EEXCON = 1.3236D-03
            EEX1ST = 0.55581D-03
            EEX2ND = 1.3236D-03
         ELSE IF ( JZ .EQ. 47 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.1126D-03
            EEX2ND = 0.2121D-03
         ELSE IF ( JZ .EQ. 48 ) THEN
            EEXCON = 1.4907D-03
            EEX1ST = 0.6581D-03
            EEX2ND = 1.4907D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
10500 CONTINUE
         IF ( JZ .EQ. 44 ) THEN
            EEXCON = ZERZER
c  |  Metastable: T1/2 0.34 us
            EEX1ST = 0.02055D-03
            EEX2ND = 0.1080D-03
         ELSE IF ( JZ .EQ. 45 ) THEN
            EEXCON = 0.1296D-03
c  |  Metastable: T1/2 45 s
            EEX1ST = 0.1296D-03
            EEX2ND = 0.1491D-03
         ELSE IF ( JZ .EQ. 46 ) THEN
            EEXCON = 0.28051D-03
            EEX1ST = 0.28051D-03
            EEX2ND = 0.30625D-03
         ELSE IF ( JZ .EQ. 47 ) THEN
            EEXCON = 0.34687D-03
c  |  Metastable: T1/2 7.2 m
            EEX1ST = 0.02547D-03
            EEX2ND = 0.05314D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
10600 CONTINUE
         IF ( JZ .EQ. 44 ) THEN
            EEXCON = 0.714D-03
            EEX1ST = 0.2703D-03
            EEX2ND = 0.714D-03
         ELSE IF ( JZ .EQ. 45 ) THEN
            GO TO 90000
         ELSE IF ( JZ .EQ. 46 ) THEN
            EEXCON = 1.12802D-03
            EEX1ST = 0.51186D-03
            EEX2ND = 1.12802D-03
         ELSE IF ( JZ .EQ. 47 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.0879D-03
            EEX2ND = 0.1106D-03
         ELSE IF ( JZ .EQ. 48 ) THEN
            EEXCON = 1.4937D-03
            EEX1ST = 0.6327D-03
            EEX2ND = 1.4937D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
10700 CONTINUE
         IF ( JZ .EQ. 45 ) THEN
            EEXCON = 0.4625D-03
            EEX1ST = 0.1941D-03
            EEX2ND = 0.4625D-03
         ELSE IF ( JZ .EQ. 46 ) THEN
            EEXCON = 0.1157D-03
c  |  Metastable: T1/2 0.9 us
            EEX1ST = 0.1157D-03
c  |  Metastable: T1/2 21.3 s
            EEX2ND = 0.2149D-03
         ELSE IF ( JZ .EQ. 47 ) THEN
            EEXCON = 0.09312D-03
c  |  Metastable: T1/2 44.3 s
            EEX1ST = 0.09312D-03
            EEX2ND = 0.12559D-03
         ELSE IF ( JZ .EQ. 48 ) THEN
            EEXCON = 0.20495D-03
            EEX1ST = 0.20495D-03
            EEX2ND = 0.32094D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
10800 CONTINUE
         IF ( JZ .EQ. 46 ) THEN
            EEXCON = 0.9312D-03
            EEX1ST = 0.43393D-03
            EEX2ND = 0.9312D-03
         ELSE IF ( JZ .EQ. 47 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.0455D-03
            EEX2ND = 0.07914D-03
         ELSE IF ( JZ .EQ. 48 ) THEN
            EEXCON = 1.0174D-03
            EEX1ST = 0.63298D-03
            EEX2ND = 1.0174D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
10900 CONTINUE
         IF ( JZ .EQ. 46 ) THEN
            EEXCON = 0.1140D-03
            EEX1ST = 0.1140D-03
c  |  Metastable: T1/2 4.69 m
            EEX2ND = 0.1889D-03
         ELSE IF ( JZ .EQ. 47 ) THEN
            EEXCON = 0.3114D-03
c  |  Metastable: T1/2 39.8 s
            EEX1ST = 0.088032D-03
            EEX2ND = 0.1328D-03
         ELSE IF ( JZ .EQ. 48 ) THEN
            EEXCON = 0.2035D-03
c  |  Metastable: T1/2 12 us
            EEX1ST = 0.0599D-03
            EEX2ND = 0.2035D-03
         ELSE IF ( JZ .EQ. 49 ) THEN
            EEXCON = 0.9813D-03
c  |  Metastable: T1/2 1.34 m
            EEX1ST = 0.6498D-03
            EEX2ND = 0.9813D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
19400 CONTINUE
         IF ( JZ .EQ. 78 ) THEN
            EEXCON = 1.2296 D-03
            EEX1ST = 0.32845D-03
            EEX2ND = 0.62202D-03
         ELSE IF ( JZ .EQ. 79 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.0352D-03
            EEX2ND = 0.0805D-03
         ELSE IF ( JZ .EQ. 80 ) THEN
            EEXCON = 1.7995D-03
            EEX1ST = 0.4282D-03
            EEX2ND = 1.0645D-03
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 1.5392D-03
            EEX1ST = 0.9650D-03
            EEX2ND = 1.5392D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
19500 CONTINUE
         IF ( JZ .EQ. 78 ) THEN
            EEXCON = 0.09886D-03
            EEX1ST = 0.09886D-03
            EEX2ND = 0.12973D-03
         ELSE IF ( JZ .EQ. 79 ) THEN
            EEXCON = 0.2415 D-03
            EEX1ST = 0.06146D-03
            EEX2ND = 0.2415 D-03
         ELSE IF ( JZ .EQ. 80 ) THEN
            EEXCON = 0.5956 D-03
            EEX1ST = 0.03709D-03
            EEX2ND = 0.05330D-03
         ELSE IF ( JZ .EQ. 81 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.3837D-03
            EEX2ND = 0.4828D-03
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 0.970D-03
            EEX1ST = 0.970D-03
            EEX2ND = 1.551D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
19600 CONTINUE
         IF ( JZ .EQ. 78 ) THEN
            EEXCON = 0.6887D-03
            EEX1ST = 0.3557D-03
            EEX2ND = 0.6887D-03
         ELSE IF ( JZ .EQ. 79 ) THEN
            EEXCON = 0.0846D-03
c  |  Metastable (T1/2 8.2 s)
            EEX1ST = 0.0846D-03
            EEX2ND = 0.23239D-03
         ELSE IF ( JZ .EQ. 80 ) THEN
            EEXCON = 1.7568D-03
            EEX1ST = 0.4261D-03
            EEX2ND = 1.037 D-03
         ELSE IF ( JZ .EQ. 81 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.1918D-03
            EEX2ND = 0.2403D-03
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 1.7375D-03
            EEX1ST = 1.0486D-03
            EEX2ND = 1.7375D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
19700 CONTINUE
         IF ( JZ .EQ. 78 ) THEN
c  |  Metastable (T1/2 94 m)
            EEXCON = 0.3995 D-03
            EEX1ST = 0.05295D-03
            EEX2ND = 0.1882 D-03
         ELSE IF ( JZ .EQ. 79 ) THEN
            EEXCON = 0.8555 D-03
            EEX1ST = 0.07734D-03
            EEX2ND = 0.26875D-03
         ELSE IF ( JZ .EQ. 80 ) THEN
            EEXCON = 0.5779D-03
            EEX1ST = 0.1339D-03
            EEX2ND = 0.1522D-03
         ELSE IF ( JZ .EQ. 81 ) THEN
            EEXCON = 0.7609D-03
            EEX1ST = 0.3856D-03
            EEX2ND = 0.6080D-03
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 1.324 D-03
            EEX1ST = 0.0849D-03
            EEX2ND = 0.3193D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
19800 CONTINUE
         IF ( JZ .EQ. 79 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.055151D-03
            EEX2ND = 0.090952D-03
         ELSE IF ( JZ .EQ. 80 ) THEN
            EEXCON = 1.0485D-03
            EEX1ST = 0.4118044D-03
            EEX2ND = 1.0485D-03
         ELSE IF ( JZ .EQ. 81 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.1734D-03
            EEX2ND = 0.2595D-03
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 1.6258D-03
            EEX1ST = 1.0634D-03
            EEX2ND = 1.6258D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
19900 CONTINUE
         IF ( JZ .EQ. 79 ) THEN
            EEXCON = 0.316878D-03
            EEX1ST = 0.077157D-03
            EEX2ND = 0.31687 8D-03
         ELSE IF ( JZ .EQ. 80 ) THEN
            EEXCON = 0.4034 D-03
            EEX1ST = 0.15837D-03
            EEX2ND = 0.20820D-03
         ELSE IF ( JZ .EQ. 81 ) THEN
            EEXCON = 0.3669D-03
            EEX1ST = 0.3669D-03
            EEX2ND = 0.720 D-03
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 1.402 D-03
            EEX1ST = 0.4248D-03
            EEX2ND = 1.402 D-03
         ELSE IF ( JZ .EQ. 83 ) THEN
            EEXCON = 0.9984D-03
c  |  Roughly, metastable (uncertain), alpha unstable (T1/2 24.7 m)
            EEX1ST = 0.61  D-03
            EEX2ND = 0.9984D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
20000 CONTINUE
         IF ( JZ .EQ. 79 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.0600 D-03
            EEX2ND = 0.07621D-03
         ELSE IF ( JZ .EQ. 80 ) THEN
            EEXCON = 0.94724D-03
            EEX1ST = 0.36794D-03
            EEX2ND = 0.94724D-03
         ELSE IF ( JZ .EQ. 81 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.14763D-03
            EEX2ND = 0.25718D-03
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 1.4884D-03
            EEX1ST = 1.0262D-03
            EEX2ND = 1.4884D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
20100 CONTINUE
         IF ( JZ .EQ. 80 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.00158D-03
            EEX2ND = 0.03219D-03
         ELSE IF ( JZ .EQ. 81 ) THEN
            EEXCON = 1.0984D-03
            EEX1ST = 0.33115D-03
            EEX2ND = 0.6924D-03
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 0.6282D-03
            EEX1ST = 0.6282D-03
            EEX2ND = 0.6282D-03
         ELSE IF ( JZ .EQ. 83 ) THEN
            EEXCON = 0.848D-03
            EEX1ST = 0.848D-03
            EEX2ND = 0.848D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
20200 CONTINUE
         IF ( JZ .EQ. 80 ) THEN
            EEXCON = 0.9600D-03
            EEX1ST = 0.4395D-03
            EEX2ND = 0.9600D-03
         ELSE IF ( JZ .EQ. 81 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.4905D-03
            EEX2ND = 0.9502D-03
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 1.3828D-03
            EEX1ST = 0.96067D-03
            EEX2ND = 1.3828D-03
         ELSE IF ( JZ .EQ. 84 ) THEN
            EEXCON = 1.248D-03
            EEX1ST = 0.677D-03
            EEX2ND = 1.248D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
20300 CONTINUE
         IF ( JZ .EQ. 81 ) THEN
            EEXCON = 1.0445D-03
            EEX1ST = 0.2792D-03
            EEX2ND = 0.6805D-03
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 0.8202D-03
            EEX1ST = 0.1264D-03
            EEX2ND = 0.1864D-03
         ELSE IF ( JZ .EQ. 83 ) THEN
            EEXCON = 0.8935D-03
            EEX1ST = 0.8935D-03
            EEX2ND = 0.8935D-03
         ELSE IF ( JZ .EQ. 84 ) THEN
            EEXCON = ZERZER
            EEX1ST = 0.059D-03
            EEX2ND = 0.133D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
20400 CONTINUE
         IF ( JZ .EQ. 80 ) THEN
            EEXCON = 1.1285D-03
            EEX1ST = 0.4366D-03
            EEX2ND = 1.1285D-03
         ELSE IF ( JZ .EQ. 81 ) THEN
            EEXCON = 0.300D-03
            EEX1ST = 0.141D-03
            EEX2ND = 0.300D-03
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 1.5628D-03
            EEX1ST = 0.8992D-03
            EEX2ND = 1.5628D-03
         ELSE IF ( JZ .EQ. 84 ) THEN
            EEXCON = 1.1985D-03
            EEX1ST = 0.6833D-03
            EEX2ND = 1.1985D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
20500 CONTINUE
         IF ( JZ .EQ. 81 ) THEN
            EEXCON = 0.6194D-03
            EEX1ST = 0.2037D-03
            EEX2ND = 0.6194D-03
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 0.5763D-03
            EEX1ST = 0.00233D-03
            EEX2ND = 0.2628D-03
         ELSE IF ( JZ .EQ. 83 ) THEN
            EEXCON = 0.8498D-03
            EEX1ST = 0.8498D-03
            EEX2ND = 0.8498D-03
         ELSE IF ( JZ .EQ. 84 ) THEN
            EEXCON = 0.386D-03
            EEX1ST = 0.144D-03
            EEX2ND = 0.386D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
20600 CONTINUE
         IF ( JZ .EQ. 81 ) THEN
            EEXCON = 0.2656D-03
            EEX1ST = 0.2656D-03
            EEX2ND = 0.2656D-03
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 1.167D-03
c  |  |  Probably only neutron levels:
            EEX1ST = 0.8031D-03
            EEX2ND = 1.167D-03
         ELSE IF ( JZ .EQ. 84 ) THEN
            EEXCON = 1.17776D-03
            EEX1ST = 0.70066D-03
            EEX2ND = 1.17776D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
20700 CONTINUE
         IF ( JZ .EQ. 81 ) THEN
            EEXCON = 2.69D-03
c  |  |  Only proton levels:
            EEX1ST = 0.35D-03
            EEX2ND = 1.34D-03
c  |  |  From here neutron levels:
            EEXNEU = 2.69D-03
            IF ( LHOLE ) THEN
               IF ( IPHOL .EQ. 2 ) THEN
                  EEXFOR = EEX2ND
                  EEX1ST = EEXNEU
                  EEX2ND = EEXNEU
                  EEXCON = EEXNEU
               END IF
            END IF
         ELSE IF ( JZ .EQ. 82 ) THEN
            EEXCON = 2.340D-03
c  |  |  Only neutron levels:
            EEX1ST = 0.56965D-03
            EEX2ND = 0.8978D-03
c  |  |  Proton levels from
            EEXPRO = 2.340D-03
            IF ( LHOLE ) THEN
               IF ( IPHOL .EQ. 1 ) THEN
                  EEXFOR = EEX2ND
                  EEX1ST = EEXPRO
                  EEX2ND = EEXPRO
                  EEXCON = EEXPRO
               END IF
            END IF
         ELSE IF ( JZ .EQ. 83 ) THEN
            EEXCON = 0.6695D-03
            EEX1ST = 0.6695D-03
            EEX2ND = 0.6695D-03
         ELSE IF ( JZ .EQ. 85 ) THEN
            EEXCON = 0.6735D-03
            EEX1ST = 0.3445D-03
            EEX2ND = 0.6735D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
20800 CONTINUE
         IF ( JZ .EQ. 82 ) THEN
            EEXCON = 2.6146D-03
c  |  |  Not available for nhole =< 1: zone forbidden
            EEX1ST = 2.6146D-03
            EEX2ND = 3.1977D-03
            IF ( LHOLE ) THEN
               EEXFOR = EEX1ST
c  |  |  For nhole =< 1
               EEX1ST = 3.1977D-03
               EEX2ND = 3.475 D-03
               EEXCON = EEX2ND
            END IF
         ELSE IF ( JZ .EQ. 83 ) THEN
            EEXCON = 0.5102D-03
            EEX1ST = 0.0635D-03
            EEX2ND = 0.5102D-03
         ELSE IF ( JZ .EQ. 84 ) THEN
            EEXCON = 1.3465D-03
            EEX1ST = 0.6865D-03
            EEX2ND = 1.3465D-03
         ELSE
            GO TO 90000
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
c  |
20900 CONTINUE
         IF ( JZ .EQ. 82 ) THEN
            EEXCON = 1.423D-03
c  |  |  Only neutron levels !!!
            EEX1ST = 0.779D-03
            EEX2ND = 1.423D-03
            EEX3RD = 1.567D-03
c  |  |  Proton levels from this
            EEXPRO = 2.15 D-03
            IF ( LHOLE ) THEN
               IF ( IPHOL .EQ. 1 ) THEN
                  EEXFOR = EEX3RD
                  EEX1ST = EEXPRO
                  EEX2ND = EEX1ST
                  EEXCON = EEX2ND
               END IF
            END IF
         ELSE IF ( JZ .EQ. 83 ) THEN
            EEXCON = 2.43D-03
c  |  |  Only proton levels !!!
            EEX1ST = 0.8966D-03
            EEX2ND = 1.6085D-03
            IF ( LHOLE ) THEN
               IF ( IPHOL .EQ. 2 ) THEN
                  EEXFOR = EEX2ND
                  EEX1ST = EEXCON
                  EEX2ND = EEX1ST
                  EEXCON = EEX2ND
               END IF
            END IF
         ELSE IF ( JZ .EQ. 84 ) THEN
            EEXCON = 0.8544D-03
            EEX1ST = 0.5450D-03
            EEX2ND = 0.8544D-03
         ELSE
            GO TO 90000
         END IF
c Final checks:
         IF ( LHOLE ) THEN
            IZODD  = 1 - MOD ( JZ, 2 )
            INODD  = 1 - MOD ( JA-JZ, 2 )
            IODD   = IZODD + INODD
            IF ( IODD .EQ. 1 .AND. EEXFOR .LT. ANGLGB ) THEN
               IF ( ( IZODD .GT. 0 .AND. IPHOL .EQ. 1 )
     &             .OR. ( INODD .GT. 0 .AND. IPHOL .EQ. 2 ) ) THEN
                  IF ( JA .NE. JAOLD ) THEN
                     JAOLD  = JA
                     SQATAR = SQRT ( DBLE (JA) )
                  END IF
                  EEX2ND = 12.0D-03 / SQATAR
                  EEXFOR = MAX ( EEX1ST, HLFHLF * EEX2ND )
                  EEX1ST = EEX2ND
                  EEXCON = EEX2ND
               END IF
            END IF
         END IF
      RETURN
c  |
c  +-------------------------------------------------------------------*
90000 CONTINUE
      IF ( JA .EQ. JZ ) THEN
         EEXCON = ZERZER
         EEX1ST = ZERZER
         EEX2ND = ZERZER
         RETURN
      END IF
      IF ( JZ .EQ. 0 .OR. JA .EQ. JZ ) THEN
         EEXCON = ZERZER
      ELSE
         EEXCON = EMVGEV * ( CAM4 (JZ) + CAM5 (JA-JZ) )
      END IF
c  **** Very tentative selection of Eex1st, Eex2nd, based on pairing
c       energies according to delta = 12 MeV / A^1/2 ****
      IZODD  = 1 - MOD ( JZ, 2 )
      INODD  = 1 - MOD ( JA-JZ, 2 )
      IODD   = IZODD + INODD
c  +-------------------------------------------------------------------*
c  |  Even-even nucleus
      IF ( IODD .GE. 2 ) THEN
c  |  +----------------------------------------------------------------*
c  |  |
         IF ( JA .NE. JAOLD ) THEN
            JAOLD  = JA
            SQATAR = SQRT ( DBLE (JA) )
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         EEX1ST = 12.0D-03 / SQATAR
         EEX2ND = TWOTWO * EEX1ST
c  |
c  +-------------------------------------------------------------------*
c  |  even-odd nucleus
      ELSE IF ( IODD .GT. 0 ) THEN
c  |  +----------------------------------------------------------------*
c  |  |
         IF ( JA .NE. JAOLD ) THEN
            JAOLD  = JA
            SQATAR = SQRT ( DBLE (JA) )
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |  Only "Odd" specie level:
         EEX1ST = ZERZER
         EEX2ND = 12.0D-03 / SQATAR
         IF ( LHOLE ) THEN
            IF ( IZODD .GT. 0 .AND. IPHOL .EQ. 1 ) THEN
               EEXFOR = HLFHLF * EEX2ND
               EEX1ST = EEX2ND
               EEXCON = EEX2ND
            ELSE IF ( INODD .GT. 0 .AND. IPHOL .EQ. 2 ) THEN
               EEXFOR = HLFHLF * EEX2ND
               EEX1ST = EEX2ND
               EEXCON = EEX2ND
            END IF
         END IF
c  |
c  +-------------------------------------------------------------------*
c  |  odd-odd nucleus
      ELSE
         EEX2ND = ZERZER
         EEX1ST = ZERZER
      END IF
c  |
c  +-------------------------------------------------------------------*
      RETURN
c=== End of subroutine eexlvl =========================================*
      END
c*

c*sr 30.6. routine replaced completely
c$ CREATE ERUP.FOR
cCOPY ERUP
c                                                                      *
c=== erup =============================================================*
c                                                                      *
CDECK  ID>, DT_ERUP
      SUBROUTINE DT_ERUP(JFISS)

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     Created  on   15 may 1990     by     Alfredo & Paola Sala        *
c                                              INFN - Milan            *
c     Last change  on   15-sep-95   by     Alfredo Ferrari, INFN-Milan *
c                                                                      *
c     Derived from the ERUP routine of EVAP-V, HERMES, KFA-Julich      *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: EVA1)
c*sr
C     COMMON /FKEVA1/ NPART(6),EPART(100,6),COSEVP(3,100,6),HEVSUM
      COMMON /FKEVA1/ NPART(6),EPART(200,6),COSEVP(3,200,6),HEVSUM
c*

c (original name: FRBKCM)
      PARAMETER ( MXFFBK =     6 )
      PARAMETER ( MXZFBK =     9 )
      PARAMETER ( MXNFBK =    10 )
      PARAMETER ( MXAFBK =    16 )
      PARAMETER ( NXZFBK = MXZFBK + MXFFBK / 3 )
      PARAMETER ( NXNFBK = MXNFBK + MXFFBK / 3 )
      PARAMETER ( NXAFBK = MXAFBK + 1 )
      PARAMETER ( MXPSST =   300 )
      PARAMETER ( MXPSFB = 41000 )
      LOGICAL LFRMBK, LNCMSS
      COMMON /FKFRBK/  AMUFBK, EEXFBK (MXPSST), AMFRBK (MXPSST),
     &          EXFRBK (MXPSFB), SDMFBK (MXPSFB), COUFBK (MXPSFB),
     &          EXMXFB, R0FRBK, R0CFBK, C1CFBK, C2CFBK,
     &          IFRBKN (MXPSST), IFRBKZ (MXPSST),
     &          IFBKSP (MXPSST), IFBKPR (MXPSST), IFBKST (MXPSST),
     &          IPSIND (0:MXNFBK,0:MXZFBK,2), JPSIND (0:MXAFBK),
     &          IFBIND (0:NXNFBK,0:NXZFBK,2), JFBIND (0:NXAFBK),
     &          IFBCHA (5,MXPSFB), IPOSST, IPOSFB, IFBSTF,
     &          IFBFRB, NBUFBK, LFRMBK, LNCMSS

c (original name: INPFLG)
      COMMON /FKINPF/ IANG,IFISS,IB0,IGEOM,ISTRAG,KEYDK

c (original name: HETC5)
      COMMON /FKHET5/ APR,ZPR,EX,UU,EREC

c (original name: HETC7)
      COMMON /FKHET7/ COSKS,SINKS, COSTH,SINTH, COSPHI,SINPHI

c (original name: HETTP)
      COMMON /FKHETP/  NHSTP,NBERTP,IOSUB,INSRS

c (original name: HIGFIS)
      PARAMETER ( IZFSMX = 61 )
      LOGICAL FISINH, LFRGMN, LAGOES
      COMMON /FKHIGF/ AFIS  (10), ZFIS  (10), UFIS  (10), EKFIS  (10),
     &                AMFIS (10), PPFIS (10), COSLFF(3,0:10),
     &                ATFIS (10), ZTFIS (10), UTFIS (10), RECFIS (10),
     &                AMTFIS(10), PPTFIS(10), EBFISS, AMDIFF,
     &                APR0, ZPR0, EREC0, UU0, HEVFIS (0:10),
     &                ISTFIS(10), NPARTF (6,0:10), NFISS, FISINH,
     &                LFRGMN, LAGOES
      DIMENSION COSLF0 (3)
      EQUIVALENCE ( COSLF0 (1), COSLFF (1,0) )

c (original name: RESNUC)
      LOGICAL LRNFSS, LFRAGM
      COMMON /FKRESN/  AMNTAR, AMMTAR, AMNZM1, AMMZM1, AMNNM1, AMMNM1,
     &                   ANOW,   ZNOW, ANCOLL, ZNCOLL, AMMLFT, AMNLFT,
     &                   ERES,  EKRES, AMNRES, AMMRES,  PTRES,  PXRES,
     &                  PYRES,  PZRES, PTRES2,  KTARP,  KTARN, IGREYP,
     &                 IGREYN, IPREEH, IPRDEU, IPRTRI, IPR3HE, IPR4HE,
     &                  ICRES,  IBRES, ISTRES, IEVAPL, IEVAPH, IEVNEU,
     &                 IEVPRO, IEVDEU, IEVTRI, IEV3HE, IEV4HE, IDEEXG,
     &                  IBTAR, ICHTAR, IBLEFT, ICLEFT, IOTHER, LRNFSS,
     &                 LFRAGM

c
      LOGICAL LOPPAR
      DIMENSION  FPART (6)
C     -------------------------------------- CHECK PARAMETER
      FISINH=.FALSE.
      LFRGMN=.FALSE.
      IFKEY = 0
c  +-------------------------------------------------------------------*
c  |  Check the excitation energy
      IF ( EX .LE. ZERZER ) THEN
c  |  No excitation energy:
         IF ( JFISS .LE. 0 ) THEN
            DO 201 I=1,6
               NPART(I)=0
  201       CONTINUE
            HEVSUM = ZERZER
         END IF
c        UU = ZERZER
         UU = EX
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |  Positive excitation energy:
      ELSE
c  |  Try evaporation
         M2 = NINT (APR)
         M3 = NINT (ZPR)
 8801    CONTINUE
         CALL DT_DRES(M2,M3,EX,UU,EREC,LOPPAR,JFISS,IFKEY)
         FPARTT = ZERZER
c  |  +----------------------------------------------------------------*
c  |  |  No previous evaporation for this event
         IF ( JFISS .LE. 0 ) THEN
            DO 801 I=1,6
               FPART(I) = DBLE (NPART(I))
               FPARTT   = FPARTT + FPART (I)
  801       CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Other evaporation trials already performed for this event
         ELSE
            DO 802 I=1,6
               FPART(I) = DBLE (NPART(I)-NPARTF(I,JFISS-1))
               FPARTT   = FPARTT + FPART (I)
  802       CONTINUE
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |  +----------------------------------------------------------------*
c  |  |  No particle evaporated and pairing corrections accounted for
c  |  |  and no fission, no fragmentation
         IF ( FPARTT + IFKEY .LT. ANGLGB .AND. .NOT. FISINH .AND.
     &        .NOT. LFRGMN .AND. ISTRES .LE. 0 ) THEN
c  |  |  Try again evaporation without accounting for pairing energies
c  |  |  This card swithes off the second trial: A. Ferrari 18-09-91
c           IF ( IFKEY .LE. 0 ) GO TO 8802
c  |  |  This card allows the 2nd trial only if the residual nucleus is
c  |  |  particle unstable even in the ground level
            IF ( .NOT. LOPPAR ) GO TO 8802
            IFKEY = 1
            GO TO 8801
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
 8802    CONTINUE
         IFKEY = 0
c  |  +----------------------------------------------------------------*
c  |  |  Fragments on their own stack:
         IF ( LFRGMN .OR. FISINH ) THEN
            ZPR = ZERZER
            APR = ZERZER
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |
         ELSE
            ZPR  = ZPR - FPART(2) - FPART(3) - TWOTWO * ( FPART(5)
     &           + FPART(6)) - FPART(4)
            APR  = APR - FPART(1) - FPART(2) - TWOTWO * FPART(3)
     &           - THRTHR * ( FPART(4) + FPART(5) ) - FOUFOU * FPART(6)
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
      END IF
c  |
c  +-------------------------------------------------------------------*
      RETURN
c=== End of subroutine Erup ===========================================*
      END
c*

c*sr 30.6. routine replaced completely
c$ CREATE EVDEEX.FOR
cCOPY EVDEEX
c
c=== evdeex ===========================================================*
c
CDECK  ID>, DT_EVDEEX
      SUBROUTINE DT_EVDEEX( WEE )

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c  Evdeex :  created on 5-10-1990 by A. Ferrari & P. Sala, INFN Milan  *
c                                                                      *
c    Last change  on  19-feb-96   by   Alfredo Ferrari, INFN-Milan     *
c                                                                      *
c    This routine provides a simple model for sampling nuclear deexci- *
c    tation gammas following the evaporation step                      *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: BALANC)
      LOGICAL LRESMP, LEVDIF, LPRDIF, LSCHAI
      COMMON /FKBALA/  ETTOT,  PTTOT, PXTTOT, PYTTOT, PZTTOT,
     &                 EINCP,  EINCN, TVGREY, TVGRE0,  TVEUZ,
     &                   EUZ,    PUX,    PUY,    PUZ,  ENUCR, PXNUCR,
     &                PYNUCR, PZNUCR,  EINTR, PXINTR, PYINTR, PZINTR,
     &                  EFRM,  PXFRM,  PYFRM,  PZFRM,   PSEA,
     &                NGREYP, NGREYN,    ICU,    IBU, ICNUCR, IBNUCR,
     &                ICINTR, IBINTR, LRESMP, LEVDIF, LPRDIF, LSCHAI

c (original name: EVA0)
      COMMON /FKEVA0/ Y0, B0, P0 (1001), P1 (1001), P2 (1001),
     *                FLA (6), FLZ (6), RHO (6), OMEGA (6), EXMASS (6),
     *                CAM2 (130), CAM3 (200), CAM4 (130), CAM5 (200),
     *                T (4,7), RMASS (297), ALPH (297), BET (297),
     *                APRIME (250), IA (6), IZ (6)

c (original name: FINUC)
      PARAMETER (MXP=999)
      COMMON /FKFINU/ CXR    (MXP), CYR    (MXP), CZR    (MXP),
     &                CXRPOL (MXP), CYRPOL (MXP), CZRPOL (MXP),
     &                TKI    (MXP), PLR    (MXP), WEI    (MXP),
     &                TV, TVCMS, TVRECL, TVHEAV, TVBIND, NP0, NP,
     &                KPART  (MXP)

c (original name: FRBKCM)
      PARAMETER ( MXFFBK =     6 )
      PARAMETER ( MXZFBK =     9 )
      PARAMETER ( MXNFBK =    10 )
      PARAMETER ( MXAFBK =    16 )
      PARAMETER ( NXZFBK = MXZFBK + MXFFBK / 3 )
      PARAMETER ( NXNFBK = MXNFBK + MXFFBK / 3 )
      PARAMETER ( NXAFBK = MXAFBK + 1 )
      PARAMETER ( MXPSST =   300 )
      PARAMETER ( MXPSFB = 41000 )
      LOGICAL LFRMBK, LNCMSS
      COMMON /FKFRBK/  AMUFBK, EEXFBK (MXPSST), AMFRBK (MXPSST),
     &          EXFRBK (MXPSFB), SDMFBK (MXPSFB), COUFBK (MXPSFB),
     &          EXMXFB, R0FRBK, R0CFBK, C1CFBK, C2CFBK,
     &          IFRBKN (MXPSST), IFRBKZ (MXPSST),
     &          IFBKSP (MXPSST), IFBKPR (MXPSST), IFBKST (MXPSST),
     &          IPSIND (0:MXNFBK,0:MXZFBK,2), JPSIND (0:MXAFBK),
     &          IFBIND (0:NXNFBK,0:NXZFBK,2), JFBIND (0:NXAFBK),
     &          IFBCHA (5,MXPSFB), IPOSST, IPOSFB, IFBSTF,
     &          IFBFRB, NBUFBK, LFRMBK, LNCMSS

c (original name: NUCDAT)
      PARAMETER ( AMUAMU = AMUGEV )
      PARAMETER ( AMPROT = AMPRTN )
      PARAMETER ( AMNEUT = AMNTRN )
      PARAMETER ( AMELEC = AMELCT )
      PARAMETER ( R0NUCL = 1.12        D+00 )
      PARAMETER ( RCCOUL = 1.7         D+00 )
      PARAMETER ( FERTHO = 14.33       D-09 )
      PARAMETER ( EXPEBN = 2.39        D+00 )
      PARAMETER ( BEXC12 = FERTHO * 72.40715579499394D+00 )
      PARAMETER ( AMUC12 = AMUGEV - HLFHLF * AMELCT + BEXC12 / 12.D+00 )
      PARAMETER ( AMHYDR = AMPRTN + AMELCT  )
      PARAMETER ( AMHTON = AMHYDR - AMNTRN  )
      PARAMETER ( AMNTOU = AMNTRN - AMUC12  )
      PARAMETER ( AMUCSQ = AMUC12 * AMUC12 )
      PARAMETER ( EBNDAV = HLFHLF * (AMPRTN + AMNTRN) - AMUC12 )
      PARAMETER ( GAMMIN = 1.0D-06 )
      PARAMETER ( GAMNSQ = 2.0D+00 * GAMMIN * GAMMIN )
      PARAMETER ( TVEPSI = GAMMIN / 100.D+00 )

      COMMON /FKNDAT/ AV0WEL,     APFRMX,     AEFRMX,     AEFRMA,
     &                RDSNUC,     V0WELL (2), PFRMMX (2), EFRMMX (2),
     &                EFRMAV (2), AMNUCL (2), AMNUSQ (2), EBNDNG (2),
     &                VEFFNU (2), ESLOPE (2), PKMNNU (2), EKMNNU (2),
     &                PKMXNU (2), EKMXNU (2), EKMNAV (2), EKINAV (2),
     &                EXMNAV (2), EKUPNU (2), EXMNNU (2), EXUPNU (2),
     &                ERCLAV (2), ESWELL (2), FINCUP (2), AMRCAV    ,
     &                AMRCSQ    , ATO1O3    , ZTO1O3    , ELBNDE (0:100)

c (original name: PAREVT)
      LOGICAL LDIFFR, LINCTV, LEVPRT, LHEAVY, LDEEXG, LGDHPR, LPREEX,
     &        LHLFIX, LPRFIX, LPARWV, LPOWER, LSNGCH, LLVMOD, LSCHDF
      PARAMETER ( NALLWP = 39   )
      COMMON /FKPARE/ DPOWER, FSPRD0, FSHPFN, RN1GSC, RN2GSC,
     &                LDIFFR (NALLWP),LPOWER, LINCTV, LEVPRT, LHEAVY,
     &                LDEEXG, LGDHPR, LPREEX, LHLFIX, LPRFIX, LPARWV,
     &                ILVMOD, JLVMOD, LLVMOD, LSNGCH, LSCHDF

c (original name: RESNUC)
      LOGICAL LRNFSS, LFRAGM
      COMMON /FKRESN/  AMNTAR, AMMTAR, AMNZM1, AMMZM1, AMNNM1, AMMNM1,
     &                   ANOW,   ZNOW, ANCOLL, ZNCOLL, AMMLFT, AMNLFT,
     &                   ERES,  EKRES, AMNRES, AMMRES,  PTRES,  PXRES,
     &                  PYRES,  PZRES, PTRES2,  KTARP,  KTARN, IGREYP,
     &                 IGREYN, IPREEH, IPRDEU, IPRTRI, IPR3HE, IPR4HE,
     &                  ICRES,  IBRES, ISTRES, IEVAPL, IEVAPH, IEVNEU,
     &                 IEVPRO, IEVDEU, IEVTRI, IEV3HE, IEV4HE, IDEEXG,
     &                  IBTAR, ICHTAR, IBLEFT, ICLEFT, IOTHER, LRNFSS,
     &                 LFRAGM

c
c----------------------------------------------------------------------*
c  Entering the routine we have:                                       *
c            Ammres is the atomic  mass of the residual nucleus        *
c            Amnres is the nuclear mass of the residual nucleus        *
c            Ibres (Anow) its mass number                              *
c            Icres (Znow) its atomic number                            *
c            Eres         its total energy                             *
c            Ptres        its momentum                                 *
c            Pxres        x-component of the momentum                  *
c            Pyres        y-component of the momentum                  *
c            Pzres        z-component of the momentum                  *
c            Tvrecl       kinetic energy                               *
c            Tvcms        excitation energy                            *
c----------------------------------------------------------------------*
c
      PARAMETER ( C0M1E1 = 0.306 D+00 )
      PARAMETER ( C0E2E1 = 7.1   D-01 )
c      PARAMETER ( HNDFE1 = 5.0   D-04 )
c      PARAMETER ( HNDFM1 = 5.0   D-02 )
c      PARAMETER ( HNDFE2 = 1.0   D+01 )
c      PARAMETER ( HNDFE1 = 5.0   D-05 )
c      PARAMETER ( HNDFM1 = 3.0   D-02 )
c      PARAMETER ( HNDFE2 = 1.5   D+01 )
      PARAMETER ( FRDSCR = 1.1   D+00 )
c
      LOGICAL LG3000, L1STEX
      DIMENSION COSGAM (3)
c**  Added 14-feb-1996 : A- dependence of hindrance f.
      DIMENSION HNE1(5), HNM1(5), HNE2(5), IBRNG(5)
      SAVE HNE1, HNM1, HNE2, IBRNG
      DATA IBRNG /20, 44, 90, 150, 300/
      DATA HNE1 /3.0 D-03, 2.0 D-04, 1.0 D-04, 4.0 D-05, 2.0 D-05/
      DATA HNM1 /3.0 D-01, 9.0 D-02, 6.0 D-02, 2.0 D-02, 1.0 D-02/
      DATA HNE2 /1.0 D+01, 1.0 D+01, 8.0 D+00, 1.3 D+01, 1.6 D+01/
c**  *********
      IDEEXG = 0
      LG3000 = .FALSE.
c  +-------------------------------------------------------------------*
c  |   Ckeck if we are below threshold for gamma production
      IF ( IBRES .LE. 0 .OR. TVCMS .LE. GAMMIN ) THEN
         TVCMS = ZERZER
         RETURN
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Nuclear masses:
      IF ( LNCMSS ) THEN
         AMRESI = AMNRES
c  |
c  +-------------------------------------------------------------------*
c  |  Atomic masses:
      ELSE
         AMRESI = AMMRES
      END IF
c  |
c  +-------------------------------------------------------------------*
      ECHCK  = ERES - AMRESI
      ECHCK0 = ECHCK
c   First compute the pairing energy
      IBHELP = IBRES / 2
c  +-------------------------------------------------------------------*
c  |     Even - odd nuclei
      IF ( IBHELP * 2 .LT. IBRES ) THEN
c  |  Now this part has been substituted by a call to eexlvl
c        DELTA = 12.D-03 / SQRT ( ANOW )
         CALL DT_EEXLVL( IBRES, ICRES, EEX1ST, EEX2ND, EEXDUM )
         DELTA = EEX2ND
c  |  No discrete level input in Eexlvl
         IF ( EEX1ST .LT. ANGLGB ) EEX2ND = ZERZER
         IPAR  = 1
         JPAR  = 1
c  |
c  +-------------------------------------------------------------------*
c  |
      ELSE
         ICHELP = ICRES / 2
         JPAR   = 0
c  |  +----------------------------------------------------------------*
c  |  |   Odd - odd nuclei
         IF ( ICHELP * 2 .LT. ICRES ) THEN
c  |  |  Now this part has been substituted by a call to eexlvl
c           DELTA = ZERZER
            CALL DT_EEXLVL( IBRES, ICRES, EEX1ST, EEX2ND, EEXDUM )
            DELTA = EEX1ST
            IPAR  = 1
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |   Even - even nuclei
         ELSE
c  |  |  Now this part has been substituted by a call to eexlvl
c           DELTA = 24.D-03 / SQRT ( ANOW )
            CALL DT_EEXLVL( IBRES, ICRES, EEX1ST, EEX2ND, EEXDUM )
            DELTA = EEX2ND
c  |  |  No discrete level input in Eexlvl: set anyway the first level
c  |  |  at one pairing energy
            IF ( ABS ( HLFHLF * EEX2ND - EEX1ST ) .LT. ANGLGB )
     &         EEX2ND = EEX1ST
            IPAR  = 2
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
      END IF
c  |
c  +-------------------------------------------------------------------*
c  Be sure the 2nd excited level is consistent with the 1st one:
      EEX2ND = MAX ( EEX1ST, EEX2ND )
c  Get rid of rounding problems!
      IF ( ABS (DELTA -TVCMS) .LT. GAMMIN ) DELTA  = TVCMS
      IF ( ABS (EEXDUM-TVCMS) .LT. GAMMIN ) EEXDUM = TVCMS
c   Pairing "delta" to be used when evaluating the nuclear temperature
c     DELPAI = MIN ( EEXDUM, DELTA )
c   From 5-feb-'96
      DELPAI = EEXDUM
c   Compute the momentum of inertia of the nucleus
      RNUCL  = R0NUCL * RMASS (IBRES)
c   The following is the momentum of inertia in GeV fm^2, assuming
c   0.4 times the one of a rigid sphere with constant density
      AINERM = 0.24D+00 * AMRESI * RNUCL * RNUCL
      ROTEN0 = HLFHLF * PLABRC * PLABRC / AINERM
      ENMIN  = MAX ( DELTA, TWOTWO * ROTEN0 )
      RNMASS = AMRESI + TVCMS
      UMO    = RNMASS
      GAMCM  = ERES  / RNMASS
      ETAX   = PXRES / RNMASS
      ETAY   = PYRES / RNMASS
      ETAZ   = PZRES / RNMASS
      IF ( TVCMS .LE. FRDSCR * EEX2ND ) GO TO 3000
c   Check if we have enough energy to enter the loop
      IF ( TVCMS .LE. ENMIN .OR. IBRES .LE. 4 ) GO TO 3000
c   Now we enter the loop for gamma production
      AHELP  = RMASS (IBRES) * RMASS (IBRES)
c**  ADDED 14-FEB-1996 : A- DEPENDENCE OF HINDRANCE F.
      IF (IBRES. LE. IBRNG(1)) THEN
         HNDFE1 = HNE1(1)
         HNDFM1 = HNM1(1)
         HNDFE2 = HNE2(1)
      ELSE IF (IBRES. LE. IBRNG(2)) THEN
         HNDFE1 = HNE1(2)
         HNDFM1 = HNM1(2)
         HNDFE2 = HNE2(2)
      ELSE IF (IBRES. LE. IBRNG(3)) THEN
         HNDFE1 = HNE1(3)
         HNDFM1 = HNM1(3)
         HNDFE2 = HNE2(3)
      ELSE IF (IBRES. LE. IBRNG(4)) THEN
         HNDFE1 = HNE1(4)
         HNDFM1 = HNM1(4)
         HNDFE2 = HNE2(4)
      ELSE
         HNDFE1 = HNE1(5)
         HNDFM1 = HNM1(5)
         HNDFE2 = HNE2(5)
      END IF
c***********************************
      CFM1E1 = C0M1E1 * HNDFM1 / HNDFE1 / AHELP
      CFE2E1 = C0E2E1 * HNDFE2 / HNDFE1 * AHELP
c  +-------------------------------------------------------------------*
c  |               Gamma production from a statistical approach based
c  |               on level density
 1000 CONTINUE
         IF ( TVCMS .LE. FRDSCR * DELPAI ) GO TO 3000
c  |   Compute the nuclear T from aT^2 = Eex - Epairing, with
c  |   "a" = level density parameter
         UMEV   = GEVMEV * ( TVCMS - DELPAI )
         ASMALL = DT_GETA( UMEV  , ICRES , IBRES-ICRES, ILVMOD, ISDUM,
     &                   AOGMAX, AOGMIN )
         TEMPSQ = EMVGEV * ( TVCMS - DELPAI ) / ASMALL
         TEMPER = SQRT ( TEMPSQ )
         HHH    = TVCMS / TEMPER
         HHHSQ  = HHH * HHH
c*sr avoid floating point underflows
C        AHELP  = EXP ( - HHH )
         IF (-HHH.LT.LOG(ANGLGB)) THEN
            AHELP = ANGLGB
         ELSE
            AHELP = EXP ( - HHH )
         ENDIF
c*
         BRE1M1 = 6.D+00 - AHELP * ( HHHSQ * HHH + 3.D+00 * HHHSQ
     &          + 6.D+00 * HHH + 6.D+00 )
         BRE2   = 20.D+00 * BRE1M1 - AHELP * ( HHHSQ * HHHSQ * HHH
     &          + 5.D+00 * HHHSQ * HHHSQ )
         BRE1M1 = BRE1M1 * ( ONEONE + CFM1E1 )
         BRE2   = BRE2 * TEMPSQ * CFE2E1
c  |  +----------------------------------------------------------------*
c  |  |           Check the multipolarity of the emission
         IF ( DT_RNDM(HHH) .LT. BRE1M1 / ( BRE1M1 + BRE2 ) ) THEN
c  |  |           electric or magnetic dipole
            LMULT = 1
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |           electric quadrupole
         ELSE
            LMULT = 2
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         LEXPN  = 2 * LMULT + 1
         XDISMX = MIN ( DBLE ( LEXPN ), HHH )
         DISMX  = XDISMX ** LEXPN * EXP ( - XDISMX )
c  |  +----------------------------------------------------------------*
c  |  |        Rejection loop to sample from:
c  |  |                        X^(2xL+1) exp (-X),  X = E/T
 2000    CONTINUE
            XTENT = DT_RNDM(HHH) * HHH
            FREJE = XTENT ** LEXPN * EXP ( - XTENT ) / DISMX
         IF ( DT_RNDM(HHH) .GE. FREJE ) GO TO 2000
c  |  |
c  |  +----------------------------------------------------------------*
c  |  Total emission energy in the CMS (photon+recoil)
         ENERG0 = XTENT * TEMPER
         TVCMS0 = TVCMS
         TVCMS  = TVCMS - ENERG0
c  |  +----------------------------------------------------------------*
c  |  |  Force the residual nucleus on discrete levels:
         IF ( TVCMS .LE. FRDSCR * EEX2ND ) THEN
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Go on the ground state:
            IF ( TVCMS .LT. HLFHLF * EEX1ST .OR. TVCMS0 .LT.
     &           HLFHLF * ( EEX1ST + EEX2ND ) ) THEN
               TVCMS = ZERZER
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Go on the 1st excited level:
            ELSE IF ( TVCMS .LT. HLFHLF * ( EEX1ST + EEX2ND )
     &         .OR. TVCMS0 .LT. FRDSCR * EEX2ND ) THEN
               TVCMS = EEX1ST
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Go on the 2nd excited level:
            ELSE
               TVCMS = EEX2ND
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         RNMASS = AMRESI + TVCMS
c  |  Cosgam(i) are the direction cosines of the emitted gamma in
c  |  the CMS frame, of course - C(i) are the ones of the residual
c  |  nucleus
         CALL DT_RACO( COSGAM (1), COSGAM (2), COSGAM (3) )
c  |  Erncm, Eegcm are the total energies of the residual nucleus
c  |  and of the emitted gamma in the CMS frame
         ERNCM  = HLFHLF * ( UMO * UMO + RNMASS * RNMASS ) / UMO
         EEGCM  = UMO - ERNCM
         PCMS   = EEGCM
c  |  Now we perform the Lorentz transformation back to the original
c  |  frame (lab frame)
c  |  First the emitted gamma:
         PCMSX  = PCMS * COSGAM (1)
         PCMSY  = PCMS * COSGAM (2)
         PCMSZ  = PCMS * COSGAM (3)
         ETAPCM = PCMSX * ETAX + PCMSY * ETAY + PCMSZ * ETAZ
         ENERG  = GAMCM * EEGCM + ETAPCM
         PHELP  = ETAPCM / ( GAMCM + ONEONE ) + EEGCM
         PLBGX  = PCMSX + ETAX * PHELP
         PLBGY  = PCMSY + ETAY * PHELP
         PLBGZ  = PCMSZ + ETAZ * PHELP
c  |  Then the residual nucleus (for it cosgam(i) --> - cosgam(i) ):
         ERES   = GAMCM * ERNCM - ETAPCM
         EKRES  = ERES  - RNMASS
         PHELP  = - ETAPCM / ( GAMCM + ONEONE ) + ERNCM
         PXRES  = - PCMSX + ETAX * PHELP
         PYRES  = - PCMSY + ETAY * PHELP
         PZRES  = - PCMSZ + ETAZ * PHELP
c  |  Update conservation counters
         ECHCK  = ECHCK  - ENERG
c  |  Stack the emitted gamma
         IDEEXG = IDEEXG + 1
         NP     = NP + 1
         WEI   (NP) = WEE
         KPART (NP) = 7
         TKI   (NP) = ENERG
         PLR   (NP) = ENERG
         CXR   (NP) = PLBGX / ENERG
         CYR   (NP) = PLBGY / ENERG
         CZR   (NP) = PLBGZ / ENERG
c  |  Update kinematical parameters
         GAMCM  = ERES  / RNMASS
         ETAX   = PXRES / RNMASS
         ETAY   = PYRES / RNMASS
         ETAZ   = PZRES / RNMASS
         UMO    = RNMASS
      IF ( TVCMS .GT. ENMIN ) GO TO 1000
c  |--<--<--<--<--<  loop to emit another gamma
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |
      IF ( NP .GE. MXP ) THEN
         WRITE ( ErrorOut, * )' **** Finuc overflow in Evdeex,',
     &                      ' PROGRAM STOPPED ****'
         WRITE ( ErrorOut, * )' **** Finuc overflow in Evdeex,',
     &                      ' PROGRAM STOPPED ****'
         STOP
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |               Gamma production from rotational levels
 3000 CONTINUE
      IF ( TVCMS .LE. ANGLGB ) GO TO 3500
c  |  +----------------------------------------------------------------*
c  |  |            ( 6 + 2 x jpar ) x roten0 corresponds to the tran-
c  |  |            sition from the level with I = 2 to the level
c  |  |            with I = 0 for even-even and odd-odd nuclei (jpar=0)
c  |  |            and from I = 5/2 to I = 1/2 for odd-even nuclei
c  |  |            If we are below consider the I = 0 (I=1/2) as the
c  |  |            ground state and go down ( no transition with
c  |  |            DI = 2 is possible )
c  |  |            Check also for excitations in the region of
c  |  |            known discrete levels:
         IF ( LG3000 .OR. TVCMS .LE. DBLE ( 6 + 2 * JPAR ) * ROTEN0 .OR.
     &        TVCMS .LE. ONEPLS * HLFHLF * ( EEX1ST + EEX2ND ) ) THEN
            ENERG0 = TVCMS
            TVCMS  = ZERZER
c  |  |  Cosgam(i) are the direction cosines of the emitted gamma in
c  |  |  the CMS frame, of course - C(i) are the ones of the residual
c  |  |   nucleus
            CALL DT_RACO( COSGAM (1), COSGAM (2), COSGAM (3) )
c  |  |  Erncm, Eegcm are the total energies of the residual nucleus
c  |  |  and of the emitted gamma in the CMS frame
            ERNCM  = HLFHLF * ( UMO * UMO + AMRESI * AMRESI ) / UMO
            EEGCM  = UMO - ERNCM
            PCMS   = EEGCM
c  |  |  Now we perform the Lorentz transformation back to the original
c  |  |  frame (lab frame)
c  |  |  First the emitted gamma:
            PCMSX  = PCMS * COSGAM (1)
            PCMSY  = PCMS * COSGAM (2)
            PCMSZ  = PCMS * COSGAM (3)
            ETAPCM = PCMSX * ETAX + PCMSY * ETAY + PCMSZ * ETAZ
            ENERG  = GAMCM * EEGCM + ETAPCM
            PHELP  = ETAPCM / ( GAMCM + ONEONE ) + EEGCM
            PLBGX  = PCMSX + ETAX * PHELP
            PLBGY  = PCMSY + ETAY * PHELP
            PLBGZ  = PCMSZ + ETAZ * PHELP
c  |  |  Then the residual nucleus (for it cosgam(i) --> - cosgam(i) ):
            ERES   = GAMCM * ERNCM - ETAPCM
            EKRES  = ERES - AMRESI
            PHELP  = - ETAPCM / ( GAMCM + ONEONE ) + ERNCM
            PXRES  = - PCMSX + ETAX * PHELP
            PYRES  = - PCMSY + ETAY * PHELP
            PZRES  = - PCMSZ + ETAZ * PHELP
c  |  |  Update conservation counters
            ECHCK  = ECHCK - ENERG
c  |  |  Stack the emitted gamma
            IDEEXG = IDEEXG + 1
            NP     = NP + 1
            WEI   (NP) = WEE
            KPART (NP) = 7
            TKI   (NP) = ENERG
            PLR   (NP) = ENERG
            CXR   (NP) = PLBGX / ENERG
            CYR   (NP) = PLBGY / ENERG
            CZR   (NP) = PLBGZ / ENERG
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |               Compute the rotational level just below the
c  |  |               present level:
c  |  |                   Iamin = I of that level for odd-odd and
c  |  |                           even-even nuclei (for odd-odd it is
c  |  |                           forced to be odd), I of that level
c  |  |                           - 1/2 for even-odd nuclei (for these
c  |  |                           nuclei the ground state is at least
c  |  |                           the I=1/2 one with E=Roten0*3/4, so
c  |  |                           we must add this quantity to Tvcms
c  |  |                           to compute the nearest level)
         ELSE
            AIAMOM = SQRT ( 0.25D+00 + TVCMS / ROTEN0
     &             + 0.75D+00 * DBLE (JPAR) ) - 0.5D+00
c  |  |  +-------------------------------------------------------------*
c  |  |  |            Ipar = 1, odd - odd or even - odd nuclei
            IF ( IPAR .EQ. 1 ) THEN
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |         Even - odd nuclei: Jamin is twice the I value of
c  |  |  |  |         the rotational state just below the present one
c  |  |  |  |         ( I = Iamin + 1/2 )
               IF ( JPAR .EQ. 1 ) THEN
                  JAMIN = 2 * INT ( AIAMOM ) + 1
                  IAMIN = JAMIN / 2
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |      Check if the ground state will be a I = 1/2, or
c  |  |  |  |  |      a I = 3/2 one
                  IF ( MOD ( IAMIN, 2 ) .GT. 0 ) THEN
                     EGROUN = 3.75D+00 * ROTEN0
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |      I = 1/2 for the ground state
                  ELSE
                     EGROUN = 0.75D+00 * ROTEN0
                  END IF
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |         Odd - odd nuclei: Jamin is twice the I value of
c  |  |  |  |         the rotational state just below the present one,
c  |  |  |  |         ( I = Iamin )
               ELSE
                  IAMIN = INT ( AIAMOM )
                  JAMIN = 2 * IAMIN
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |      Check if the ground state will be a I = 1 or a
c  |  |  |  |  |      I = 0 one
                  IF ( MOD ( IAMIN, 2 ) .GT. 0 ) THEN
                     EGROUN = TWOTWO * ROTEN0
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |      I = 0 for the ground state
                  ELSE
                     EGROUN = ZERZER
                  END IF
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
               END IF
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |                  even - even nuclei: the rotational band
c  |  |  |                  will end on the I = 0 level
            ELSE
               IAMIN  = INT ( AIAMOM ) / IPAR
c  |  |  |  In this way we are considering only even values for the
c  |  |  |  angular momentum quantum number for even - even nuclei
               IAMIN  = IAMIN * IPAR
               JAMIN  = 2 * IAMIN
               EGROUN = ZERZER
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
            DELTAE = TVCMS + EGROUN - 0.25D+00 * ROTEN0 * DBLE ( JAMIN *
     &             ( JAMIN + 2 ) )
            L1STEX = .FALSE.
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Now emit all gammas corresponding to DI = 2 transitions,
c  |  |  |  Jamom is the 2xI value of the starting state, the minimum
c  |  |  |  level can be I0=0,1/2,1,3/2 --> J0 = 2xI0 = 0,1,2,3 and
c  |  |  |  the previous level (DJ=4), Jl = 4,5,6,7, so a minimum
c  |  |  |  value of 4 for Jl is ok for all possible J0
            DO 4000 JAMOM = JAMIN, 4, -4
               ENERG0 = ROTEN0 * DBLE ( 2 * JAMOM - 2 ) + DELTAE
               DELTAE = ZERZER
               TVCMS0 = TVCMS
               TVCMS  = TVCMS - ENERG0
 3800          CONTINUE
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Go on the 1st excited level:
               IF ( L1STEX ) THEN
                  TVCMS  = EEX1ST
                  ENERG0 = TVCMS0 - TVCMS
                  LG3000 = .TRUE.
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Force the residual nucleus on discrete levels:
               ELSE IF ( TVCMS .LT. FRDSCR * EEX2ND ) THEN
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |  Go on the ground state:
                  IF ( TVCMS .LT. HLFHLF * EEX1ST .OR. TVCMS0 .LT.
     &                 HLFHLF * ( EEX1ST + EEX2ND ) ) THEN
                     TVCMS  = ZERZER
                     ENERG0 = TVCMS0
                     LG3000 = .TRUE.
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |  Go on the 1st excited level:
                  ELSE IF ( TVCMS .LT. HLFHLF * ( EEX1ST + EEX2ND )
     &               .OR. TVCMS0 .LT. FRDSCR * EEX2ND ) THEN
                     TVCMS  = EEX1ST
                     ENERG0 = TVCMS0 - TVCMS
                     LG3000 = .TRUE.
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |  Go on the 2nd excited level:
                  ELSE
                     TVCMS  = EEX2ND
                     ENERG0 = TVCMS0 - TVCMS
c  |  |  |  |  |  Even-even nuclei: go on with the cascade, the next one
c  |  |  |  |  |  will be the first level
c  |  |  |  |  |  Odd-odd or Even-odd 50% thru the 1st level, 50%
c  |  |  |  |  |  directly to the ground state
                     RNFLIP = DT_RNDM(HHH)
                     LG3000 = ( IPAR .NE. 2 .AND. RNFLIP .LT. HLFHLF )
     &                        .OR. EEX1ST .GE. ONEMNS * EEX2ND
                     L1STEX = .NOT. LG3000
                  END IF
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Normal sequence:
               ELSE
                  LG3000 = .FALSE.
               END IF
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
               RNMASS = AMRESI + TVCMS
c  |  |  | Cosgam(i) are the direction cosines of the emitted gamma in
c  |  |  | the CMS frame, of course - C(i) are the ones of the residual
c  |  |  | nucleus
               CALL DT_RACO( COSGAM (1), COSGAM (2), COSGAM (3) )
c  |  |  | Erncm, Eegcm are the total energies of the residual nucleus
c  |  |  | and of the emitted gamma in the CMS frame
               ERNCM  = HLFHLF * ( UMO * UMO + RNMASS * RNMASS ) / UMO
               EEGCM  = UMO - ERNCM
               PCMS   = EEGCM
c  |  |  | Now we perform the Lorentz transformation back to the
c  |  |  | original frame (lab frame)
c  |  |  | First the emitted gamma:
               PCMSX  = PCMS * COSGAM (1)
               PCMSY  = PCMS * COSGAM (2)
               PCMSZ  = PCMS * COSGAM (3)
               ETAPCM = PCMSX * ETAX + PCMSY * ETAY + PCMSZ * ETAZ
               ENERG  = GAMCM * EEGCM + ETAPCM
               PHELP  = ETAPCM / ( GAMCM + ONEONE ) + EEGCM
               PLBGX  = PCMSX + ETAX * PHELP
               PLBGY  = PCMSY + ETAY * PHELP
               PLBGZ  = PCMSZ + ETAZ * PHELP
c  |  |  | Then the residual nucleus (for it cosgam(i) --> -cosgam(i)):
               ERES   = GAMCM * ERNCM - ETAPCM
               EKRES  = ERES - RNMASS
               PHELP  = - ETAPCM / ( GAMCM + ONEONE ) + ERNCM
               PXRES  = - PCMSX + ETAX * PHELP
               PYRES  = - PCMSY + ETAY * PHELP
               PZRES  = - PCMSZ + ETAZ * PHELP
c  |  |  | Update conservation counters
               ECHCK  = ECHCK  - ENERG
c  |  |  | Stack the emitted gamma
               IDEEXG = IDEEXG + 1
               NP     = NP + 1
               WEI   (NP) = WEE
               KPART (NP) = 7
               TKI   (NP) = ENERG
               PLR   (NP) = ENERG
               CXR   (NP) = PLBGX / ENERG
               CYR   (NP) = PLBGY / ENERG
               CZR   (NP) = PLBGZ / ENERG
c  |  |  | Update kinematical parameters
               GAMCM  = ERES  / RNMASS
               ETAX   = PXRES / RNMASS
               ETAY   = PYRES / RNMASS
               ETAZ   = PZRES / RNMASS
               UMO    = RNMASS
               IF ( LG3000 ) GO TO 3000
c  |  |  |--<--<--<--<--< go back to deexcite directly on the ground
c  |  |  |                state when we are in the known discrete level
c  |  |  |                range
               IF ( L1STEX ) GO TO 3800
c  |  |  |--<--<--<--<--< go back to deexcite thru the 1st excuted level
 4000       CONTINUE
c  |  |  |
c  |  |  +-------------------------------------------------------------*
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |
c  +-------------------------------------------------------------------*
 3500 CONTINUE
c  Update conservation counters
      ECHCK  = ECHCK - EKRES
c  +-------------------------------------------------------------------*
c  |
      IF ( ABS ( ECHCK ) .GT. 1.D-7 * ECHCK0 ) THEN
         WRITE ( ErrorOut,
     *  * )' **** No energy conservation in Evdeex',
     &                      ' ****', ECHCK, IDEEXG
         WRITE ( ErrorOut,
     *  * )' **** No energy conservation in Evdeex',
     &                      ' ****', ECHCK, IDEEXG
      END IF
c  |
c  +-------------------------------------------------------------------*
      TVCMS = ZERZER
c  +-------------------------------------------------------------------*
c  |
      IF ( NP .GT. MXP ) THEN
         WRITE ( ErrorOut, * )' **** Finuc overflow in Evdeex,',
     &                      ' PROGRAM STOPPED ****'
         WRITE ( ErrorOut, * )' **** Finuc overflow in Evdeex,',
     &                      ' PROGRAM STOPPED ****'
         STOP
      END IF
c  |
c  +-------------------------------------------------------------------*
      TVRECL = EKRES
      P2RES  = PXRES * PXRES + PYRES * PYRES + PZRES * PZRES
      PTRES  = SQRT (P2RES)
c=== End of subroutine Evdeex =========================================*
      RETURN
      END
c*

c$ CREATE EVEVAP.FOR
cCOPY EVEVAP
c
c=== evevap ===========================================================*
c
CDECK  ID>, DT_EVEVAP
      SUBROUTINE DT_EVEVAP( WEE )

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c  EVent EVAPoration: this routine is used to steer both the evapora-  *
c  tion, the high energy fission, possibly a future fragmentation      *
c  and the gamma deexcitation routines                                 *
c                                                                      *
c  Created  on  15  may  1991   by   Alfredo Ferrari & Paola Sala      *
c                                             INFN - Milan             *
c                                                                      *
c  Last change  on 02-may-95    By   Alfredo Ferrari, INFN - Milan     *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: BALANC)
      LOGICAL LRESMP, LEVDIF, LPRDIF, LSCHAI
      COMMON /FKBALA/  ETTOT,  PTTOT, PXTTOT, PYTTOT, PZTTOT,
     &                 EINCP,  EINCN, TVGREY, TVGRE0,  TVEUZ,
     &                   EUZ,    PUX,    PUY,    PUZ,  ENUCR, PXNUCR,
     &                PYNUCR, PZNUCR,  EINTR, PXINTR, PYINTR, PZINTR,
     &                  EFRM,  PXFRM,  PYFRM,  PZFRM,   PSEA,
     &                NGREYP, NGREYN,    ICU,    IBU, ICNUCR, IBNUCR,
     &                ICINTR, IBINTR, LRESMP, LEVDIF, LPRDIF, LSCHAI

c (original name: EVA1)
c*sr
C     COMMON /FKEVA1/ NPART(6),EPART(100,6),COSEVP(3,100,6),HEVSUM
      COMMON /FKEVA1/ NPART(6),EPART(200,6),COSEVP(3,200,6),HEVSUM
c*

c (original name: FHEAVY,FHEAVC)
      PARAMETER ( MXHEAV = 100 )
      CHARACTER*8 ANHEAV
      COMMON /FKFHVY/ CXHEAV (MXHEAV), CYHEAV (MXHEAV),
     &                CZHEAV (MXHEAV), TKHEAV (MXHEAV),
     &                PHEAVY (MXHEAV), WHEAVY (MXHEAV),
     &                AMHEAV  ( 12 ) , AMNHEA  ( 12 ) ,
     &                KHEAVY (MXHEAV), ICHEAV  ( 12 ) ,
     &                IBHEAV  ( 12 ) , NPHEAV
      COMMON /FKFHVC/ ANHEAV  ( 12 )

c (original name: FINUC)
      PARAMETER (MXP=999)
      COMMON /FKFINU/ CXR    (MXP), CYR    (MXP), CZR    (MXP),
     &                CXRPOL (MXP), CYRPOL (MXP), CZRPOL (MXP),
     &                TKI    (MXP), PLR    (MXP), WEI    (MXP),
     &                TV, TVCMS, TVRECL, TVHEAV, TVBIND, NP0, NP,
     &                KPART  (MXP)

c (original name: FRBKCM)
      PARAMETER ( MXFFBK =     6 )
      PARAMETER ( MXZFBK =     9 )
      PARAMETER ( MXNFBK =    10 )
      PARAMETER ( MXAFBK =    16 )
      PARAMETER ( NXZFBK = MXZFBK + MXFFBK / 3 )
      PARAMETER ( NXNFBK = MXNFBK + MXFFBK / 3 )
      PARAMETER ( NXAFBK = MXAFBK + 1 )
      PARAMETER ( MXPSST =   300 )
      PARAMETER ( MXPSFB = 41000 )
      LOGICAL LFRMBK, LNCMSS
      COMMON /FKFRBK/  AMUFBK, EEXFBK (MXPSST), AMFRBK (MXPSST),
     &          EXFRBK (MXPSFB), SDMFBK (MXPSFB), COUFBK (MXPSFB),
     &          EXMXFB, R0FRBK, R0CFBK, C1CFBK, C2CFBK,
     &          IFRBKN (MXPSST), IFRBKZ (MXPSST),
     &          IFBKSP (MXPSST), IFBKPR (MXPSST), IFBKST (MXPSST),
     &          IPSIND (0:MXNFBK,0:MXZFBK,2), JPSIND (0:MXAFBK),
     &          IFBIND (0:NXNFBK,0:NXZFBK,2), JFBIND (0:NXAFBK),
     &          IFBCHA (5,MXPSFB), IPOSST, IPOSFB, IFBSTF,
     &          IFBFRB, NBUFBK, LFRMBK, LNCMSS

c (original name: HETC5)
      COMMON /FKHET5/ APR,ZPR,EX,UU,EREC

c (original name: HETC7)
      COMMON /FKHET7/ COSKS,SINKS, COSTH,SINTH, COSPHI,SINPHI

c (original name: HETTP)
      COMMON /FKHETP/  NHSTP,NBERTP,IOSUB,INSRS

c (original name: HIGFIS)
      PARAMETER ( IZFSMX = 61 )
      LOGICAL FISINH, LFRGMN, LAGOES
      COMMON /FKHIGF/ AFIS  (10), ZFIS  (10), UFIS  (10), EKFIS  (10),
     &                AMFIS (10), PPFIS (10), COSLFF(3,0:10),
     &                ATFIS (10), ZTFIS (10), UTFIS (10), RECFIS (10),
     &                AMTFIS(10), PPTFIS(10), EBFISS, AMDIFF,
     &                APR0, ZPR0, EREC0, UU0, HEVFIS (0:10),
     &                ISTFIS(10), NPARTF (6,0:10), NFISS, FISINH,
     &                LFRGMN, LAGOES
      DIMENSION COSLF0 (3)
      EQUIVALENCE ( COSLF0 (1), COSLFF (1,0) )

c (original name: LABCOS)
      COMMON /FKLABC/ COSLBP(3),COSLBR(3)

c (original name: NUCDAT)
      PARAMETER ( AMUAMU = AMUGEV )
      PARAMETER ( AMPROT = AMPRTN )
      PARAMETER ( AMNEUT = AMNTRN )
      PARAMETER ( AMELEC = AMELCT )
      PARAMETER ( R0NUCL = 1.12        D+00 )
      PARAMETER ( RCCOUL = 1.7         D+00 )
      PARAMETER ( FERTHO = 14.33       D-09 )
      PARAMETER ( EXPEBN = 2.39        D+00 )
      PARAMETER ( BEXC12 = FERTHO * 72.40715579499394D+00 )
      PARAMETER ( AMUC12 = AMUGEV - HLFHLF * AMELCT + BEXC12 / 12.D+00 )
      PARAMETER ( AMHYDR = AMPRTN + AMELCT  )
      PARAMETER ( AMHTON = AMHYDR - AMNTRN  )
      PARAMETER ( AMNTOU = AMNTRN - AMUC12  )
      PARAMETER ( AMUCSQ = AMUC12 * AMUC12 )
      PARAMETER ( EBNDAV = HLFHLF * (AMPRTN + AMNTRN) - AMUC12 )
      PARAMETER ( GAMMIN = 1.0D-06 )
      PARAMETER ( GAMNSQ = 2.0D+00 * GAMMIN * GAMMIN )
      PARAMETER ( TVEPSI = GAMMIN / 100.D+00 )

      COMMON /FKNDAT/ AV0WEL,     APFRMX,     AEFRMX,     AEFRMA,
     &                RDSNUC,     V0WELL (2), PFRMMX (2), EFRMMX (2),
     &                EFRMAV (2), AMNUCL (2), AMNUSQ (2), EBNDNG (2),
     &                VEFFNU (2), ESLOPE (2), PKMNNU (2), EKMNNU (2),
     &                PKMXNU (2), EKMXNU (2), EKMNAV (2), EKINAV (2),
     &                EXMNAV (2), EKUPNU (2), EXMNNU (2), EXUPNU (2),
     &                ERCLAV (2), ESWELL (2), FINCUP (2), AMRCAV    ,
     &                AMRCSQ    , ATO1O3    , ZTO1O3    , ELBNDE (0:100)

c (original name: PAREVT)
      LOGICAL LDIFFR, LINCTV, LEVPRT, LHEAVY, LDEEXG, LGDHPR, LPREEX,
     &        LHLFIX, LPRFIX, LPARWV, LPOWER, LSNGCH, LLVMOD, LSCHDF
      PARAMETER ( NALLWP = 39   )
      COMMON /FKPARE/ DPOWER, FSPRD0, FSHPFN, RN1GSC, RN2GSC,
     &                LDIFFR (NALLWP),LPOWER, LINCTV, LEVPRT, LHEAVY,
     &                LDEEXG, LGDHPR, LPREEX, LHLFIX, LPRFIX, LPARWV,
     &                ILVMOD, JLVMOD, LLVMOD, LSNGCH, LSCHDF

C     INCLUDE '(PART)'
c$ CREATE PART.ADD
c*sr 19.5. commented
C     COMMON / PART /  AM     (-6:IDMAXP), GA     (-6:IDMAXP),
C    &                 TAU    (-6:IDMAXP), AMDISC (-6:IDMAXP),
C    &                 ZMNABS (-6:IDMAXP), ATNMNA (-6:IDMAXP),
C    &                 ICH    (-6:IDMAXP), IBAR   (-6:IDMAXP),
C    &                 K1     (-6:IDMAXP), K2     (-6:IDMAXP),
C    &                 KPTOIP (-6:IDMAXP), IPTOKP (-6:NALLWP),
C    &                 IDCFLG (-6:NALLWP), IPTYPE (-6:NALLWP)
c*sr 2.3.99 commented
C     CHARACTER*8  ANAME
C     COMMON /FKCHPA / ANAME (-6:IDMAXP)
c*
c (original name: RESNUC)
      LOGICAL LRNFSS, LFRAGM
      COMMON /FKRESN/  AMNTAR, AMMTAR, AMNZM1, AMMZM1, AMNNM1, AMMNM1,
     &                   ANOW,   ZNOW, ANCOLL, ZNCOLL, AMMLFT, AMNLFT,
     &                   ERES,  EKRES, AMNRES, AMMRES,  PTRES,  PXRES,
     &                  PYRES,  PZRES, PTRES2,  KTARP,  KTARN, IGREYP,
     &                 IGREYN, IPREEH, IPRDEU, IPRTRI, IPR3HE, IPR4HE,
     &                  ICRES,  IBRES, ISTRES, IEVAPL, IEVAPH, IEVNEU,
     &                 IEVPRO, IEVDEU, IEVTRI, IEV3HE, IEV4HE, IDEEXG,
     &                  IBTAR, ICHTAR, IBLEFT, ICLEFT, IOTHER, LRNFSS,
     &                 LFRAGM

c
      PARAMETER ( AMUMEV = GEVMEV * AMUGEV )
c
c*sr 30.6.
C     COMMON /EVNTTP/ LNUCRI, LHADRI
C     LOGICAL LNUCRI, LHADRI
c*
c  The initial excitation energy, mass and charge of the nucleus are
c  put into Ex, Apr, Zpr (common Hetc5)
      EX  = MAX ( GEVMEV * TVCMS, ANGLGB )
      APR = ANOW
      ZPR = ZNOW
c  Reset the fission/fragmentation counter:
      NFISS  = 0
c  Reset the stability index:
      ISTRES = 0
c*sr 30.6.
c  Set the Lagoes flag, physics (and Peanut since it is sound physics)
c  would require Lagoes = .false. ...
c**sr 30.6. LPEANU not available in this routine (even not in the new
c          version), assume LPEANU=.false. according to new BDNOPT
C     LAGOES = .NOT. LPEANU
      LAGOES = .TRUE.
c**
c*
c  Ammres is the atomic mass of the residual nucleus
c  Reset accumulators for the energy conservation check (they are only
c  local)
      EOTEST = AMMRES + TVCMS + TVRECL
c  +-------------------------------------------------------------------*
c  |  Check the possibility to end up with a "compound elastic" event
c  |  and flag it for the Fermi break-up algorithm:
      IF ( IBTAR - ICHTAR .LE. MXNFBK .AND. ICHTAR .LE. MXZFBK .AND.
     &     NP .EQ. NP0 ) THEN
         IFBFRB = IPSIND (IBTAR-ICHTAR,ICHTAR,1)
         IF ( IFBFRB .GT. 0 ) THEN
            IF ( IFBKST (IFBFRB) .NE. 0 ) IFBFRB = 0
         END IF
      END IF
c  |
c  +-------------------------------------------------------------------*
      ETEVAP = ZERZER
c  +-------------------------------------------------------------------*
c  |  Set the variables recording the recoil direction of the residual
c  |  nucleus:
      IF ( PTRES .GT. ZERZER ) THEN
         COSLBR (1) = PXRES / PTRES
         COSLBR (2) = PYRES / PTRES
         COSLBR (3) = PZRES / PTRES
c  |
c  +-------------------------------------------------------------------*
c  |  It can happen for pion capture for example that ptres=0
c  |  ( it is always 0 if no "direct" particle is emitted )
      ELSE
         COSLBR (1) = ZERZER
         COSLBR (2) = ZERZER
         COSLBR (3) = ONEONE
      END IF
c  |
c  +-------------------------------------------------------------------*
c  The call to getrig is useless, since we actually need no rotation
c     CALL GETRIG ( ZERZER, ZERZER, ONEONE )
      EREC   = GEVMEV * TVRECL
      LFRGMN = .FALSE.
c*sr 19.5.95
c*   the following variables have to be reset here, otherwise the
c*   fission/fragment. loop further down is always entered (even if
c*   "normal" evap. is handled only)
      LFRAGM = .FALSE.
      LRNFSS = .FALSE.
c*
      CALL DT_ERUP(0)
c  +-------------------------------------------------------------------*
c  |  Check for fission/fragmentation: if it occurred loop back on the
c  |  fission fragments to possibly evaporate further particles:
      IF ( FISINH .OR. LFRGMN ) THEN
         LRNFSS = FISINH
         LFRAGM = LFRGMN
         JFISS  = 0
c  |  +----------------------------------------------------------------*
c  |  |  Update the partial counters of evaporated particles
         DO 40 J = 1,6
            NPARTF (J,JFISS) = NPART (J)
            HEVFIS (JFISS)   = HEVSUM
   40    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
c  |  +----------------------------------------------------------------*
c  |  |  The following "do" is not structured as a do since Nfiss can
c  |  |  be incremented during evaporation/fragmentation of the
c  |  |  previously generated fragments
   50    CONTINUE
            FISINH = .FALSE.
            LFRGMN = .FALSE.
            JFISS  = JFISS + 1
            PTRES  = EMVGEV * PPFIS (JFISS)
            EREC   = EKFIS (JFISS)
            APR    = AFIS  (JFISS)
            ZPR    = ZFIS  (JFISS)
            AMMRES = EMVGEV * AMFIS (JFISS)
c*sr 30.6.
            AMNRES = AMMRES - ZPR * AMELCT + ELBNDE ( NINT (ZPR) )
c*
            EX     = MAX ( UFIS (JFISS), ANGLGB )
            COSLBR (1) = COSLFF (1,JFISS)
            COSLBR (2) = COSLFF (2,JFISS)
            COSLBR (3) = COSLFF (3,JFISS)
            ISTRES = ISTFIS (JFISS)
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Possible particle unstable state:
            IF ( ISTRES .LT. 0 ) THEN
               PXRES = COSLBR (1) * PTRES
               PYRES = COSLBR (2) * PTRES
               PZRES = COSLBR (3) * PTRES
c  |  |  |  The call to getrig is useless, since we need no rotation
c              CALL GETRIG ( ZERZER, ZERZER, ONEONE )
               CALL DT_ERUP(JFISS)
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |
            ELSE
               UU = EX
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
            ANOW  = APR
            ZNOW  = ZPR
            ICHLP = NINT (ZNOW)
            IBHLP = NINT (ANOW)
c  |  |  +-------------------------------------------------------------*
c  |  |  |  If we enter this branch the present fragment has been
c  |  |  |  completely evaporated without further fragmentation and
c  |  |  |  it is ready for the final gamma deexcitation and for
c  |  |  |  residual nuclei scoring
            IF ( .NOT. FISINH .AND. .NOT. LFRGMN .AND. IBHLP .GT. 0 )
     &           THEN
               AMTFIS (JFISS) = ANOW * AMUMEV +  DT_ENERGY( ANOW, ZNOW )
               UTFIS  (JFISS) = UU
               RECFIS (JFISS) = EREC
               PPTFIS (JFISS) = SQRT ( EREC * ( EREC + TWOTWO
     &                        * ( AMTFIS (JFISS) + UTFIS (JFISS) ) ) )
               ATFIS  (JFISS) = ANOW
               ZTFIS  (JFISS) = ZNOW
               ISTFIS (JFISS) = ISTRES
               COSLFF (1,JFISS) = COSLBR (1)
               COSLFF (2,JFISS) = COSLBR (2)
               COSLFF (3,JFISS) = COSLBR (3)
               ETEVAP = ETEVAP + EMVGEV * ( EREC + AMTFIS (JFISS)
     &                + UTFIS (JFISS) )
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Fragment furtherly fragmented or completely evaporated into
c  |  |  |  p,n,d,t,3-He and alphas
            ELSE
               LRNFSS = LRNFSS .OR. FISINH
               LFRAGM = LFRAGM .OR. LFRGMN
               FISINH = .FALSE.
               LFRGMN = .FALSE.
               ATFIS  (JFISS) = ZERZER
               ZTFIS  (JFISS) = ZERZER
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Update the partial counters of evaporated particles
            DO 60 J = 1,6
               NPARTF (J,JFISS) = NPART (J)
               HEVFIS (JFISS)   = HEVSUM
   60       CONTINUE
c  |  |  |
c  |  |  +-------------------------------------------------------------*
         IF ( JFISS .LT. NFISS ) GO TO 50
c  |  |
c  |  +----------------------------------------------------------------*
         FISINH = .FALSE.
         LFRGMN = .FALSE.
      END IF
c  |
c  +-------------------------------------------------------------------*
      IEVNEU = NPART (1)
      IEVPRO = NPART (2)
      IEVDEU = NPART (3)
      IEVTRI = NPART (4)
      IEV3HE = NPART (5)
      IEV4HE = NPART (6)
      IEVAPL = IEVNEU + IEVPRO
      IEVAPH = IEVDEU + IEVTRI + IEV3HE + IEV4HE
c  +-------------------------------------------------------------------*
c  |              Add to the secondary stack the evaporated neutrons
      DO 100 IP = 1, NPART (1)
         NP = NP + 1
         KPART (NP) = 8
         TKI   (NP) = EMVGEV * EPART ( IP, 1 )
         WEI   (NP) = WEE
         CXR   (NP) = COSEVP ( 1, IP, 1 )
         CYR   (NP) = COSEVP ( 2, IP, 1 )
         CZR   (NP) = COSEVP ( 3, IP, 1 )
c*sr 17.5.95
C        PLR   (NP) = SQRT ( TKI (NP) * ( TKI (NP) + TWOTWO * AM (8) ) )
         PLR   (NP) = SQRT ( ABS( TKI (NP) *
     &                     ( TKI (NP) + TWOTWO * AMHEAV (1) ) ) )
         ETEVAP = ETEVAP + TKI (NP) + AMHEAV (1)
  100 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |              Add to the secondary stack the evaporated protons
      DO 200 IP = 1, NPART (2)
         NP = NP + 1
         KPART (NP) = 1
         TKI   (NP) = EMVGEV * EPART ( IP, 2 )
         WEI   (NP) = WEE
         CXR   (NP) = COSEVP ( 1, IP, 2 )
         CYR   (NP) = COSEVP ( 2, IP, 2 )
         CZR   (NP) = COSEVP ( 3, IP, 2 )
c*sr 17.5.95
C        PLR   (NP) = SQRT ( TKI (NP) * ( TKI (NP) + TWOTWO * AM (1) ) )
         PLR   (NP) = SQRT ( TKI (NP) *
     &                     ( TKI (NP) + TWOTWO * AMHEAV (2) ) )
         ETEVAP = ETEVAP + TKI (NP) + AMHEAV (2)
  200 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |         Add to the heavy stack the other evaporated (if requested)
      IF ( LHEAVY ) THEN
         NPHEAV = 0
c  |  +----------------------------------------------------------------*
c  |  |  Loop over the particle types:
         DO 400 JP = 3, 6
c  |  |  +-------------------------------------------------------------*
c  |  |  |
            DO 300 IP = 1, NPART (JP)
               NPHEAV = NPHEAV + 1
               KHEAVY (NPHEAV) = JP
               TKHEAV (NPHEAV) = EMVGEV * EPART ( IP, JP )
               WHEAVY (NPHEAV) = WEE
               CXHEAV (NPHEAV) = COSEVP ( 1, IP, JP )
               CYHEAV (NPHEAV) = COSEVP ( 2, IP, JP )
               CZHEAV (NPHEAV) = COSEVP ( 3, IP, JP )
               PHEAVY (NPHEAV) = SQRT ( ( TKHEAV (NPHEAV) + TWOTWO
     &                         * AMHEAV (JP) ) * TKHEAV (NPHEAV) )
               ETEVAP = ETEVAP + TKHEAV (NPHEAV) + AMHEAV (JP)
  300       CONTINUE
c  |  |  |
c  |  |  +-------------------------------------------------------------*
  400    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
c  |
c  +-------------------------------------------------------------------*
c  |
      ELSE
         NPHEAV = 0
         ETEVAP = ETEVAP + EMVGEV * HEVSUM + DBLE (IEVDEU) * AMHEAV (3)
     &          + DBLE (IEVTRI) * AMHEAV (4)
     &          + DBLE (IEV3HE) * AMHEAV (5)
     &          + DBLE (IEV4HE) * AMHEAV (6)
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Fission and/or fragmentation occurred:
      IF ( LRNFSS .OR. LFRAGM ) THEN
         TVHEAV = EMVGEV * HEVSUM
         IF ( ABS ( ETEVAP - EOTEST )/ EOTEST .GT. 1.D-07 ) THEN
            WRITE ( ErrorOut, * )
     &            ' EVEVAP_FIS: FAILURE IN ENERGY CONSERVATION!!',
     &                        ETEVAP, EOTEST
            WRITE ( ErrorOut, * )
     &            ' EVEVAP_FIS: FAILURE IN ENERGY CONSERVATION!!',
     &                        ETEVAP, EOTEST
         END IF
         TVCHLP = ZERZER
         IDEHLP = 0
c  |  +----------------------------------------------------------------*
c  |  |  Loop on fission/fragmentation fragments
         DO 5000 JFISS = 1, NFISS
            ANOW  = ATFIS (JFISS)
            ZNOW  = ZTFIS (JFISS)
            IBRES = NINT ( ANOW )
            ICRES = NINT ( ZNOW )
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Check the residual nucleus:
            IF ( IBRES .EQ. 0 ) THEN
               AMMRES = ZERZER
c*sr 30.6.
               AMNRES = ZERZER
c*
               TVCMS  = ZERZER
               TVRECL = ZERZER
               PTRES  = ZERZER
               PXRES  = ZERZER
               PYRES  = ZERZER
               PZRES  = ZERZER
               EKRES  = ZERZER
               ERES   = ZERZER
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  real fragment:
            ELSE
               AMMRES = EMVGEV * AMTFIS (JFISS)
               TVCMS  = EMVGEV * UTFIS  (JFISS)
               TVRECL = EMVGEV * RECFIS (JFISS)
               PTRES  = EMVGEV * PPTFIS (JFISS)
               PXRES  = PTRES  * COSLFF (1,JFISS)
               PYRES  = PTRES  * COSLFF (2,JFISS)
               PZRES  = PTRES  * COSLFF (3,JFISS)
               ERES   = AMMRES + TVCMS + TVRECL
               EKRES  = TVRECL
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Check if the deexcitation module have to be called
            IF ( LDEEXG ) THEN
               IDEEXG = 0
               CALL DT_EVDEEX( WEE )
               IDEHLP = IDEHLP + IDEEXG
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |
            ELSE
               TVCHLP = TVCHLP + TVCMS
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Check if fission fragments have to be put on stack
            IF ( LHEAVY .AND. IBRES .GT. 0 ) THEN
               NPHEAV = NPHEAV + 1
               TKHEAV (NPHEAV) = EKRES
               PHEAVY (NPHEAV) = PTRES
               CXHEAV (NPHEAV) = PXRES / PTRES
               CYHEAV (NPHEAV) = PYRES / PTRES
               CZHEAV (NPHEAV) = PZRES / PTRES
               WHEAVY (NPHEAV) = WEE
               KHEAVY (NPHEAV) = 6 + JFISS
               AMHEAV (KHEAVY(NPHEAV)) = AMMRES
               AMNHEA (KHEAVY(NPHEAV)) = AMMRES - ICRES * AMELCT
     &                                 + ELBNDE (ICRES)
               IBHEAV (KHEAVY(NPHEAV)) = IBRES
               ICHEAV (KHEAVY(NPHEAV)) = ICRES
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
            TVHEAV = TVHEAV + TVRECL
 5000    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
         IDEEXG = IDEHLP
         TVCMS  = TVCHLP
         ANOW   = ZERZER
         ZNOW   = ZERZER
         IBRES  = 0
         ICRES  = 0
         AMMRES = ZERZER
         TVRECL = ZERZER
         PTRES  = ZERZER
         PXRES  = ZERZER
         PYRES  = ZERZER
         PZRES  = ZERZER
c*sr 30.6.
         EKRES  = ZERZER
c*
         ERES   = ZERZER
c  |
c  +-------------------------------------------------------------------*
c  |  Normal evaporation:
      ELSE
         ANOW  = APR
         ZNOW  = ZPR
         IBRES = NINT ( ANOW )
         ICRES = NINT ( ZNOW )
c  |  Ammres is the atomic mass of the residual nucleus
c  |  +----------------------------------------------------------------*
c  |  |  Check the residual nucleus:
         IF ( IBRES .EQ. 0 ) THEN
            AMMRES = ZERZER
c*sr 30.6.
            AMNRES = ZERZER
c*
            TVCMS  = ZERZER
            TVRECL = ZERZER
            PTRES  = ZERZER
            PXRES  = ZERZER
            PYRES  = ZERZER
            PZRES  = ZERZER
c*sr 30.6.
            EKRES  = ZERZER
c*
            ERES   = ZERZER
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |
         ELSE
            AMMRES = ANOW   * AMUGEV + EMVGEV * DT_ENERGY( ANOW, ZNOW )
c*sr 30.6.
            AMNRES = AMMRES - ZNOW * AMELCT + ELBNDE ( ICRES )
c*
            TVCMS  = EMVGEV * UU
            TVRECL = EMVGEV * EREC
            PTRES  = SQRT ( TVRECL * ( TVRECL + TWOTWO * ( AMMRES +
     &                      TVCMS ) ) )
            PXRES  = PTRES * COSLBR (1)
            PYRES  = PTRES * COSLBR (2)
            PZRES  = PTRES * COSLBR (3)
            ERES   = AMMRES + TVCMS + TVRECL
            EKRES  = TVRECL
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         TVHEAV = EMVGEV * HEVSUM
         ETEVAP = ETEVAP + ERES
         IF ( ABS ( ETEVAP - EOTEST )/ EOTEST .GT. 1.D-07 ) THEN
            WRITE ( ErrorOut, * )
     &            ' EVEVAP: FAILURE IN ENERGY CONSERVATION!!',
     &                        ETEVAP, EOTEST
            WRITE ( ErrorOut, * )
     &            ' NFISS,IBRES,ICRES,(NPART(I),I=1,6)',
     &              NFISS,IBRES,ICRES,(NPART(I),I=1,6)
            WRITE ( ErrorOut, * )
     &            ' EVEVAP: FAILURE IN ENERGY CONSERVATION!!',
     &                        ETEVAP, EOTEST
            WRITE ( ErrorOut, * )
     &            ' NFISS,IBRES,ICRES,(NPART(I),I=1,6)',
     &              NFISS,IBRES,ICRES,(NPART(I),I=1,6)
         END IF
c  |   Check if the deexcitation module have to be called
         IF ( LDEEXG ) CALL DT_EVDEEX( WEE )
      END IF
c  |
c  +-------------------------------------------------------------------*
      RETURN
c=== End of subroutine Evevap =========================================*
      END

c*sr 30.6. routine replaced completely
c$ CREATE EXPLOD.FOR
cCOPY EXPLOD
c
c=== explod ===========================================================*
c
CDECK  ID>, DT_EXPLOD
      SUBROUTINE DT_EXPLOD( NPEXPL, AMEXPL, ETOTEX, ETEXPL, PXEXPL,
     &                    PYEXPL, PZEXPL )

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     EXPLOD: makes a phase space like explosion out of Npexpl parti-  *
c             cles of masses Amexpl and total energy Etotex. The       *
c             resulting total energies and momenta are stored into     *
c             etexpl and px,y,zexpl. The "explosion" is supposed to    *
c             occur in the CMS of the particles                        *
c                                                                      *
c     Created on 08 february 1995  by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 27-may-96     by    Alfredo Ferrari               *
c                                                                      *
c     Input variables:                                                 *
c                                                                      *
c                 Npexpl = number of particles                         *
c              Amexpl(i) = mass of the ith particle, i=1,npexpl        *
c                 Etotex = invariant mass of npexpl particle system    *
c                                                                      *
c     Output variables:                                                *
c                                                                      *
c              Etexpl(i) = (total) energy of the ith particle in the   *
c                          CMS of the npexpl particle system           *
c          Px,y,zexpl(i) = momentum components of the ith particle in  *
c                          the CMS of the npexpl particle system       *
c                                                                      *
c     The unit of energy and momentum is immaterial provided Etotex    *
c     and Amexpl are given in the same units. Of course momenta come   *
c     out in the same unit too                                         *
c                                                                      *
c     Limitations: the number of particles must not exceed Ncycmx+2    *
c                  The efficiency becomes smaller the larger the par-  *
c                  ticle number and the larger the system energy with  *
c                  respect to the total particle mass                  *
c                                                                      *
c----------------------------------------------------------------------*
c
      PARAMETER ( NCYCMX = 10 )
      PARAMETER ( MCYCMX = NCYCMX + 1 )
      DIMENSION PXEXPL (NPEXPL), PYEXPL (NPEXPL), PZEXPL (NPEXPL),
     &          ETEXPL (NPEXPL), AMEXPL (NPEXPL), AMCYCL (MCYCMX),
     &          AMCYMX (MCYCMX), XR2ZMX (NCYCMX),
     &          AMCUMU (0:NCYCMX), RNEXPL (0:NCYCMX)
      LOGICAL LLRNTR
c
c  Statement functions:
      ZXR2MX (U) = ( ( ONEONE - U ) * ( ONEONE + U ) )**2
     &           / ( TWOTWO + TWOTWO * U**2 + SQRT ( ONEONE + U**2
     &           * ( 14.D+00 + U**2 ) ) )
c     XR2FUN (Z,U) = SQRT ( Z * ( ( ( ONEONE - U ) * ( ONEONE + U ) )**2
c    &             + Z * ( Z - TWOTWO - TWOTWO *  U**2 ) ) )
      XR2FUN (Z,U) = SQRT ( MAX ( ZERZER, Z * ( ( ( ONEONE - U )
     &             * ( ONEONE + U ) )**2 + Z * ( Z - TWOTWO - TWOTWO
     &             *  U**2 ) ) ) )
c
c  Preliminary checks:
      AMTOT  = ZERZER
c  +-------------------------------------------------------------------*
c  |  Make a check on the available energy:
      DO 100 I = 1, NPEXPL
         AMTOT = AMTOT + AMEXPL (I)
  100 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Print an error message and stop:
      IF ( AMTOT .GE. ETOTEX ) THEN
         WRITE (ErrorOut,*)' *** Explod: total energy < mass!!',
     &                         ETOTEX, AMTOT, NPEXPL,
     &                        (AMEXPL (I), I=1,NPEXPL)
         WRITE (ErrorOut,*)' *** Explod: total energy < mass!!',
     &                         ETOTEX, AMTOT, NPEXPL,
     &                        (AMEXPL (I), I=1,NPEXPL)
         STOP 'STOP:EXPLOD-AMTOT-ETOTEX'
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Print an error message and stop:
      IF ( NPEXPL .GT. NCYCMX + 2 ) THEN
         WRITE (ErrorOut,*)' *** Explod: too many particles!!',
     &                         NPEXPL, NCYCMX + 2
         STOP 'STOP:EXPLOD-NPEXPL-NCYCMX'
      END IF
c  |
c  +-------------------------------------------------------------------*
c  Total available kinetic energy:
      EKAVAI = ETOTEX - AMTOT
c  Minimum (kinetic) energy requested for each two body combination:
      EKNCMN = MIN ( CSNNRM * AMTOT, 0.05D+00 * EKAVAI / DBLE (NPEXPL) )
      LLRNTR = .FALSE.
      ETAX   = ZERZER
      ETAY   = ZERZER
      ETAZ   = ZERZER
      GAMMA  = ONEONE
      NCURR  = NPEXPL
c  Energy of the current batch of particles in their own CMS
      ECMCUR = ETOTEX
      IF ( NCURR .LE. 2 ) GO TO 6000
c-->-->-->-->--> go directly to make a 2-body decay
      NCYCLE = NPEXPL - 2
c  Preliminary operations:
      AMCYMX (1) = EKAVAI + AMEXPL (1) + AMEXPL (2)
      AMCUMU (0) = AMEXPL (1)
c  +-------------------------------------------------------------------*
c  |  Set up the mass cumulative array:
      DO 1600 I = 1, NCYCLE
         J = I + 1
c  |  This is Sum m_k, k=1,j
         AMCUMU (I)   = AMCUMU (I-1) + AMEXPL (J)
         AMCYMX (I+1) = AMCYMX (I)   + AMEXPL (J+1)
         UMU    = AMEXPL (J+1) / AMCYMX (I+1)
         ZILOW  = ( AMCUMU (I) / AMCYMX (I+1) )**2
         ZIHGH  = ( ONEONE - UMU )**2
         ZIMAX  = ZXR2MX (UMU)
c  |  +----------------------------------------------------------------*
c  |  |  The allowed interval is beyond the (local) maximum
         IF ( ZILOW .GT. ZIMAX ) THEN
            XR2ZMX (I) = XR2FUN (ZILOW,UMU)
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  The allowed interval is before the function (local) maximum
         ELSE IF ( ZIHGH .LT. ZIMAX ) THEN
            XR2ZMX (I) = XR2FUN (ZIHGH,UMU)
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  The function (local) maximum is inside the allowed interval
         ELSE
            XR2ZMX (I) = XR2FUN (ZIMAX,UMU)
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
 1600 CONTINUE
c  |
c  +-------------------------------------------------------------------*
      AMCYCL (NCYCLE+1) = ETOTEX
c  Should be already there but for rounding...:
      AMCYMX (NCYCLE+1) = ETOTEX
      UMUNM1 = AMEXPL (NPEXPL) / AMCYCL (NCYCLE+1)
      ZNM1LW = ( AMCUMU (NCYCLE) / AMCYCL (NCYCLE+1) )**2
      ZNM1HG = ( ONEONE - UMUNM1 )**2
      ZNM1MX = ZXR2MX (UMUNM1)
c  +-------------------------------------------------------------------*
c  |  The allowed interval is beyond the maximum
      IF ( ZNM1LW .GT. ZNM1MX ) THEN
         XR2ZMX (NCYCLE) = XR2FUN (ZNM1LW,UMUNM1)
c  |
c  +-------------------------------------------------------------------*
c  |  The allowed interval is before the function (local) maximum
      ELSE IF ( ZNM1HG .LT. ZNM1MX ) THEN
         XR2ZMX (NCYCLE) = XR2FUN (ZNM1HG,UMUNM1)
c  |
c  +-------------------------------------------------------------------*
c  |  The function (local) maximum is inside the allowed interval
      ELSE
         XR2ZMX (NCYCLE) = XR2FUN (ZNM1MX,UMUNM1)
      END IF
c  |
c  +-------------------------------------------------------------------*
      XR2M12 = SQRT ( ONEONE + ( ( AMEXPL (1) + AMEXPL (2) )
     &       * ( AMEXPL (1) - AMEXPL (2) ) / AMCYMX (1)**2 )**2
     &       - TWOTWO * ( AMEXPL (1)**2 + AMEXPL (2)**2 )
     &       / AMCYMX (1)**2 )
c  +-------------------------------------------------------------------*
c  |  (Possible) rejection loop:
 2000 CONTINUE
c*sr 18.5. replaced by usual random-number generator
C        CALL RM48 ( RNEXPL (0), NCYCLE + 1 )
c  |  +----------------------------------------------------------------*
c  |  |  Equivalent loop:
         DO 2300 I = 0, NCYCLE
            RNEXPL (I) = DT_RNDM(ECMCUR)
 2300    CONTINUE
c*
c  |  |
c  |  +----------------------------------------------------------------*
         RNREJE = RNEXPL (0)
c  |  +----------------------------------------------------------------*
c  |  |  Ordering loop:
         DO 2500 I = 1, NCYCLE - 1
            DO 2400 J = I + 1, NCYCLE
               IF ( RNEXPL (J) .LT. RNEXPL (I) ) THEN
                  RNEXPL (0) = RNEXPL (I)
                  RNEXPL (I) = RNEXPL (J)
                  RNEXPL (J) = RNEXPL (0)
               END IF
 2400       CONTINUE
 2500    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
         EKNCYC = RNEXPL (NCYCLE) * EKAVAI
c  |  The following card is just for rounding, to reject from the very
c  |  beginning configurations very close to the mass limit for which
c  |  phase space factors will anyway come out practically 0, but
c  |  with good chances to go into rounding.
         IF ( EKNCYC .LT. EKNCMN ) GO TO 2000
c  |  This is M_n-1
         AMCYCL (NCYCLE) = EKNCYC + AMCUMU (NCYCLE)
         ZREJE  = ( AMCYCL (NCYCLE) / AMCYCL (NCYCLE+1) )**2
c  |  Compute the M_j R2(M_j+1,M_j,m_j+1) factor for the selected M_j,
c  |  for j=n-1
         XR2NOW = XR2FUN (ZREJE,UMUNM1)
         FREJE  = XR2NOW / XR2ZMX (NCYCLE)
         IF ( RNREJE .GE. FREJE ) GO TO 2000
         RNREJE = RNREJE / FREJE
c  |  +----------------------------------------------------------------*
c  |  |  Create the Ncycle invariant masses for the intermediate mass
c  |  |  states
         DO 2600 I = NCYCLE - 1, 1, -1
            J = I + 1
c  |  |  Check the ordering loop:
            IF ( RNEXPL (I) .GT. RNEXPL (I+1) ) STOP 'STOP:EXPLOD-ORDER'
            EKNCYC = RNEXPL (I) * EKAVAI
c  |  |  The following card is just for rounding, to reject from the
c  |  |  very beginning configurations very close to the mass limit for
c  |  |  which phase space factors will anyway come out practically 0,
c  |  |  but with good chances to go into rounding.
            IF ( EKNCYC .LT. EKNCMN ) GO TO 2000
c  |  |  This is M_j
            AMCYCL (I) = EKNCYC + AMCUMU (I)
            UMU    = AMEXPL (J+1) / AMCYCL (I+1)
            ZREJE  = ( AMCYCL (I) / AMCYCL (I+1) )**2
c  |  |  Compute the M_j R2(M_j+1,M_j,m_j+1) factor for M_j
            XR2NOW = XR2FUN (ZREJE,UMU)
            FREJE  = XR2NOW / XR2ZMX (I)
c  |  |  Take into account the factor M_j+1:
            FREJE  = FREJE * AMCYCL (I+1) / AMCYMX (I+1)
            IF ( RNREJE .GE. FREJE ) GO TO 2000
            RNREJE = RNREJE / FREJE
 2600    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
         XR2NOW = SQRT ( ONEONE + ( ( AMEXPL (1) + AMEXPL (2) )
     &          * ( AMEXPL (1) - AMEXPL (2) ) / AMCYCL (1)**2 )**2
     &          - TWOTWO * ( AMEXPL (1)**2 + AMEXPL (2)**2 )
     &          / AMCYCL (1)**2 )
         FREJE  = XR2NOW / XR2M12
      IF ( RNREJE .GE. FREJE ) GO TO 2000
c  |                                        end of the rejection loop:
c  +-------------------------------------------------------------------*
      ICYCLE = NCYCLE
      NCURR  = NPEXPL
c  Energy of the current batch of particles in their own CMS
      ECMCUR = ETOTEX
c  +-------------------------------------------------------------------*
c  |  Main loop: at each cycle the number of particles to be
c  |  considered is diminished by one, till it reaches two
c  |  Icycle = cycle index, 0 < Icycle =< n-2
c  |  J = Icycle + 1, 1 < J =< n-1
c  |  At each cycle particle j+1 is "ejected" in a two body decay with
c  |  the second particle being M_j, made up of the particles from 1 toj
 3000 CONTINUE
c  |  +----------------------------------------------------------------*
c  |  |  It should never occur, however with many cycles rounding
c  |  |  could create problems:
         IF ( ECMCUR .LE. AMCYCL (ICYCLE) + AMEXPL (ICYCLE+2) ) THEN
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Problems:
            IF ( ECMCUR .LE. ONEMNS * ( AMCYCL (ICYCLE)
     &         + AMEXPL (ICYCLE+2) ) ) THEN
               WRITE (ErrorOut,*)
     &      ' *** PROBABLE ROUNDING PROBLEM IN EXPLOD ***'
               WRITE (ErrorOut,*)
     &      ' ECMCUR,NCURR,AMCYCL(ICYCLE),AMEXPL(ICYCLE+2),NPEXPL',
     &        ECMCUR,NCURR,AMCYCL(ICYCLE),AMEXPL(ICYCLE+2),NPEXPL,
     &      ' EKAVAI,EKNCMN,ICYCLE,AMEXPL(K)',
     &        EKAVAI,EKNCMN,ICYCLE,(AMEXPL(K),K=1,NPEXPL)
               WRITE (ErrorOut,*)
     &            ' *** PROBABLE ROUNDING PROBLEM IN EXPLOD ***'
               WRITE (ErrorOut,*)
     &      ' ECMCUR,NCURR,AMCYCL(ICYCLE),AMEXPL(ICYCLE+2),NPEXPL',
     &        ECMCUR,NCURR,AMCYCL(ICYCLE),AMEXPL(ICYCLE+2),NPEXPL,
     &      ' EKAVAI,EKNCMN,ICYCLE,AMEXPL(K)',
     &        EKAVAI,EKNCMN,ICYCLE,(AMEXPL(K),K=1,NPEXPL)
               GO TO 2000
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
            J      = ICYCLE + 1
c  |  |  Please note that J1 is identically equal to Ncurr....
            J1     = J + 1
c  |  |  Two body decay m_j+1 - M_j:
            ECMSJ1 = AMEXPL (J1)
            ECMSJ  = AMCYCL (ICYCLE)
            PCMS   = ZERZER
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Normal situation:
         ELSE
            J      = ICYCLE + 1
c  |  |  Please note that J1 is identically equal to Ncurr....
            J1     = J + 1
c  |  |  Two body decay m_j+1 - M_j:
            ECMSJ1 = HLFHLF * ( ECMCUR + ( AMEXPL (J1) - AMCYCL (ICYCLE)
     &             ) * ( AMEXPL (J1) + AMCYCL (ICYCLE) ) / ECMCUR )
            ECMSJ  = ECMCUR - ECMSJ1
            PCMS   = SQRT ( ( ECMSJ1 - AMEXPL (J1) )
     &                    * ( ECMSJ1 + AMEXPL (J1) ) )
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         CALL DT_RACO( PXCMS, PYCMS, PZCMS )
         PXCMS  = PXCMS * PCMS
         PYCMS  = PYCMS * PCMS
         PZCMS  = PZCMS * PCMS
c  |  +----------------------------------------------------------------*
c  |  |  Transform back to the original system if required:
         IF ( LLRNTR ) THEN
            ETAPCM      = ETAX   * PXCMS  + ETAY * PYCMS + ETAZ * PZCMS
            ETEXPL (J1) = GAMMA  * ECMSJ1 + ETAPCM
            PHELP       = ECMSJ1 + ETAPCM / ( GAMMA + ONEONE )
            PXEXPL (J1) = PXCMS  + ETAX * PHELP
            PYEXPL (J1) = PYCMS  + ETAY * PHELP
            PZEXPL (J1) = PZCMS  + ETAZ * PHELP
            ETAPCM      =-ETAPCM
            ETCURR      = GAMMA  * ECMSJ  + ETAPCM
            PHELP       = ECMSJ  + ETAPCM / ( GAMMA + ONEONE )
            PXCURR      =-PXCMS  + ETAX * PHELP
            PYCURR      =-PYCMS  + ETAY * PHELP
            PZCURR      =-PZCMS  + ETAZ * PHELP
            PTCURR      = SQRT ( PXCURR**2 + PYCURR**2 + PZCURR**2 )
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  No transformation required:
         ELSE
            ETEXPL (J1) = ECMSJ1
            PXEXPL (J1) = PXCMS
            PYEXPL (J1) = PYCMS
            PZEXPL (J1) = PZCMS
            ETCURR      = ECMSJ
            PXCURR      =-PXCMS
            PYCURR      =-PYCMS
            PZCURR      =-PZCMS
            PTCURR      = PCMS
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |  In principle it is useless, it must give amcycl(icycle), but
c  |  for safety against rounding (in principle it would be better
c  |  the opposite operation, that is, leave Ecmcur=Amcycl and get rid
c  |  of rounding on momenta computing the momentum modulus from
c  |  Amcycl and Etcurr. However for non relativistic situations
c  |  a lot of rounding would come out in the calculation of the
c  |  momentum):
         ECMCUR = SQRT ( ( ETCURR - PTCURR ) * ( ETCURR + PTCURR ) )
         GAMMA  = ETCURR / ECMCUR
         ETAX   = PXCURR / ECMCUR
         ETAY   = PYCURR / ECMCUR
         ETAZ   = PZCURR / ECMCUR
         LLRNTR = .TRUE.
         ICYCLE = ICYCLE - 1
         NCURR  = NCURR  - 1
      IF ( NCURR .GT. 2 ) GO TO 3000
c  |
c  +-------------------------------------------------------------------*
c === Two body decay m_1 - m_2: === *
 6000 CONTINUE
      ECMS1  = HLFHLF * ( ECMCUR + ( AMEXPL (1) - AMEXPL (2) )
     &       * ( AMEXPL (1) + AMEXPL (2) ) / ECMCUR )
      ECMS2  = ECMCUR - ECMS1
      PCMS   = SQRT ( ( ECMS2 - AMEXPL (2) ) * ( ECMS2 + AMEXPL (2) ) )
      CALL DT_RACO( PXCMS, PYCMS, PZCMS )
      PXCMS  = PXCMS * PCMS
      PYCMS  = PYCMS * PCMS
      PZCMS  = PZCMS * PCMS
c  +-------------------------------------------------------------------*
c  |  Transform back to the original system if required:
      IF ( LLRNTR ) THEN
         ETAPCM     = ETAX * PXCMS + ETAY * PYCMS + ETAZ * PZCMS
         ETEXPL (1) = GAMMA * ECMS1  + ETAPCM
         PHELP      = ECMS1 + ETAPCM / ( GAMMA + ONEONE )
         PXEXPL (1) = PXCMS + ETAX * PHELP
         PYEXPL (1) = PYCMS + ETAY * PHELP
         PZEXPL (1) = PZCMS + ETAZ * PHELP
         ETAPCM     =-ETAPCM
         ETEXPL (2) = GAMMA * ECMS2  + ETAPCM
         PHELP      = ECMS2 + ETAPCM / ( GAMMA + ONEONE )
         PXEXPL (2) =-PXCMS + ETAX * PHELP
         PYEXPL (2) =-PYCMS + ETAY * PHELP
         PZEXPL (2) =-PZCMS + ETAZ * PHELP
c  |
c  +-------------------------------------------------------------------*
c  |  No transformation required:
      ELSE
         ETEXPL (1) = ECMS1
         PXEXPL (1) = PXCMS
         PYEXPL (1) = PYCMS
         PZEXPL (1) = PZCMS
         ETEXPL (2) = ECMS2
         PXEXPL (2) =-PXCMS
         PYEXPL (2) =-PYCMS
         PZEXPL (2) =-PZCMS
      END IF
c  |
c  +-------------------------------------------------------------------*
      ETEPS  = TENTEN * CSNNRM * ETOTEX
      ECHCK  = ETOTEX
      PXCHCK = ZERZER
      PYCHCK = ZERZER
      PZCHCK = ZERZER
c  +-------------------------------------------------------------------*
c  |  Compute energy and momentum conservation:
      DO 7000 K = 1, NPEXPL
         ECHCK  = ECHCK  - ETEXPL (K)
         PXCHCK = PXCHCK - PXEXPL (K)
         PYCHCK = PYCHCK - PYEXPL (K)
         PZCHCK = PZCHCK - PZEXPL (K)
 7000 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Check energy and momentum conservation:
      IF ( ABS (ECHCK) + ABS (PXCHCK) + ABS (PYCHCK) + ABS (PZCHCK)
     &    .GT. ETEPS  ) THEN
         WRITE (ErrorOut,*)
     &         ' *** EXPLOD:ENERGY OR MOMENTUM CONSERVATION FAILURE:'
         WRITE (ErrorOut,*)
     &         ' NPEXPL,ETOTEX,ECHCK,PXCHCK,PYCHCK,PZCHCK',
     &           NPEXPL,ETOTEX,ECHCK,PXCHCK,PYCHCK,PZCHCK
      END IF
c  |
c  +-------------------------------------------------------------------*
c=== End of subroutine Explod =========================================*
      RETURN
      END
c*

c$ CREATE FISFRA.FOR
cCOPY FISFRA
c
c=== fisfra ===========================================================*
c
CDECK  ID>, DT_FISFRA
      SUBROUTINE DT_FISFRA( JA, JZ, U, EREC, UMO, GAMCM, ETACM )

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c  FISsion FRAgments emission:                                         *
c                                                                      *
c                                                                      *
c      Subroutine to pick post fission parameters for nucleus          *
c      JZ,JA excited to U and recoiling with Erec.                     *
c                                                                      *
c  Created  on  08 april 1993  by  A.Ferrari & P.Sala, INFN - Milan    *
c                                                                      *
c  Last change  on  16-feb-95  by  Alfredo Ferrari, INFN - Milan       *
c                                                                      *
c  This routine is just the equivalent of the routines FISSED and      *
c  FISDIS of LAHET, taken thanks to R.E.Prael                          *
c                                                                      *
c  Input variables:                                                    *
c     JA = Mass number of the fissioning nucleus                       *
c     JZ = Atomic number of the fissioning nucleus                     *
c     U  = Excitation energy (MeV) of the fissioning nucleus           *
c     Erec = Recoil kinetic energy (MeV) of the residual nucleus       *
c            The recoil direction is given by Coslf0 (i)               *
c     Umo  = invariant mass of the fissioning system (mass+excitation) *
c     Gamcm= CMS Lorentz boost "gamma"                                 *
c     Etacm= CMS Lorentz boost "eta"                                   *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: HIGFIS)
      PARAMETER ( IZFSMX = 61 )
      LOGICAL FISINH, LFRGMN, LAGOES
      COMMON /FKHIGF/ AFIS  (10), ZFIS  (10), UFIS  (10), EKFIS  (10),
     &                AMFIS (10), PPFIS (10), COSLFF(3,0:10),
     &                ATFIS (10), ZTFIS (10), UTFIS (10), RECFIS (10),
     &                AMTFIS(10), PPTFIS(10), EBFISS, AMDIFF,
     &                APR0, ZPR0, EREC0, UU0, HEVFIS (0:10),
     &                ISTFIS(10), NPARTF (6,0:10), NFISS, FISINH,
     &                LFRGMN, LAGOES
      DIMENSION COSLF0 (3)
      EQUIVALENCE ( COSLF0 (1), COSLFF (1,0) )

c (original name: NUCDAT)
      PARAMETER ( AMUAMU = AMUGEV )
      PARAMETER ( AMPROT = AMPRTN )
      PARAMETER ( AMNEUT = AMNTRN )
      PARAMETER ( AMELEC = AMELCT )
      PARAMETER ( R0NUCL = 1.12        D+00 )
      PARAMETER ( RCCOUL = 1.7         D+00 )
      PARAMETER ( FERTHO = 14.33       D-09 )
      PARAMETER ( EXPEBN = 2.39        D+00 )
      PARAMETER ( BEXC12 = FERTHO * 72.40715579499394D+00 )
      PARAMETER ( AMUC12 = AMUGEV - HLFHLF * AMELCT + BEXC12 / 12.D+00 )
      PARAMETER ( AMHYDR = AMPRTN + AMELCT  )
      PARAMETER ( AMHTON = AMHYDR - AMNTRN  )
      PARAMETER ( AMNTOU = AMNTRN - AMUC12  )
      PARAMETER ( AMUCSQ = AMUC12 * AMUC12 )
      PARAMETER ( EBNDAV = HLFHLF * (AMPRTN + AMNTRN) - AMUC12 )
      PARAMETER ( GAMMIN = 1.0D-06 )
      PARAMETER ( GAMNSQ = 2.0D+00 * GAMMIN * GAMMIN )
      PARAMETER ( TVEPSI = GAMMIN / 100.D+00 )

      COMMON /FKNDAT/ AV0WEL,     APFRMX,     AEFRMX,     AEFRMA,
     &                RDSNUC,     V0WELL (2), PFRMMX (2), EFRMMX (2),
     &                EFRMAV (2), AMNUCL (2), AMNUSQ (2), EBNDNG (2),
     &                VEFFNU (2), ESLOPE (2), PKMNNU (2), EKMNNU (2),
     &                PKMXNU (2), EKMXNU (2), EKMNAV (2), EKINAV (2),
     &                EXMNAV (2), EKUPNU (2), EXMNNU (2), EXUPNU (2),
     &                ERCLAV (2), ESWELL (2), FINCUP (2), AMRCAV    ,
     &                AMRCSQ    , ATO1O3    , ZTO1O3    , ELBNDE (0:100)

c
      PARAMETER ( AMUMEV = 1.D+03 * AMUAMU )
      DIMENSION C (3), EVODBA (4)
      SAVE EVODBA, SIGMAA, AAMEAN
c  Asym gauss width, 1/level density parameter and high mass mean.
      DATA SIGMAA, AAMEAN /6.5D+00,140.D+00/
c  Mass diff from 1 amu for neutron,diff p & n masses and n mass
c     DATA AFACT, ZFACT, ENMASS /8.3674D+00,0.7826D+0,939.5124D+00/
c  +-------------------------------------------------------------------*
c  |  Check for the logical flag for HE fission:
      IF ( .NOT. FISINH ) THEN
         WRITE (ErrorOut,60) JA,JZ,U,EREC
         WRITE (ErrorOut,60) JA,JZ,U,EREC
         RETURN
      END IF
c  |
c  +-------------------------------------------------------------------*
      Z = JZ
      A = JA
      NFISS1 = NFISS + 1
      NFISS2 = NFISS + 2
      NCK2   = 0
c  Loop here from any rejection: ten trials at maximum are allowed
   10 CONTINUE
      NCK2 = NCK2 + 1
c  +-------------------------------------------------------------------*
c  |  Check for fission failure:
      IF ( NCK2 .GT. 10 ) THEN
         WRITE (ErrorOut,
     * 50) JA,JZ,U,EREC,ZFIS(NFISS1),AFIS(NFISS1),
     &                     ZFIS(NFISS2),AFIS(NFISS2)
         FISINH = .FALSE.
         RETURN
      END IF
c  |
c  +-------------------------------------------------------------------*
c  Temp = fissility
      TEMP = Z * Z / A
c  +-------------------------------------------------------------------*
c  |  Fissility =< 35
      IF ( TEMP .LE. 35.D+00 ) THEN
         IF ( JZ .LE. 88 ) GO TO 20
c  |
c  +-------------------------------------------------------------------*
c  |  Excitation energy =< 62 MeV: assymmetric vs symmetric fission
c  |  competition is allowed
      ELSE IF ( U .LE. 62.D+00 ) THEN
c  |  High Z fission mass distribution. competition for sym vs assym
c  |  simple symmetric to assymmetric data fit
         ARG = -0.36D+00 * U
         ARG = +4.87D+03 * EXP(ARG)
c  |  Asymm probability
         PROBA = ARG / ( ONEONE + ARG )
c  |  +----------------------------------------------------------------*
c  |  |  Assymmetric fission:
         IF ( DT_RNDM(ARG) .LT. PROBA ) THEN
            CALL DT_NORRAN(A1)
c  |  |  1st fragment mass: gaussian distributed around Aamean with
c  |  |                     variance Sigmaa
            A1 = AAMEAN + SIGMAA * A1
            GO TO 30
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
      END IF
c  |
c  +-------------------------------------------------------------------*
c  Find assymetric barrier for width computation
c  assymetric barrier from Seaborg and Vandenbosch
c  Phys.Rev. 88,507 (1952) Phys.Rev. 110,507 (1958)
c  find if EE EO OE or OO nucleus
c  Na=1 odd-odd,2 even-odd,3 odd-even,4 even-even
      IN = JA - JZ
      NA = 1
      JZODD = MOD ( JZ, 2 )
      IF ( JZODD .EQ. 0 ) NA = NA + 1
      INODD = MOD ( IN, 2 )
      IF ( INODD .EQ. 0 ) NA = NA + 2
      TEMP   = Z * Z / A
c  Fission barrier:
      EBFISS = EVODBA (NA) - 0.36D+00 * TEMP
c  Come here with the fission barrier already computed by fprob
c  for "low" fissility and low Z nuclei
   20 CONTINUE
      UPR = MIN ( U-EBFISS, 1.D+02 )
      SIGMAS = 0.425D+00 * ( UPR * ( ONEONE - 0.005D+00*UPR) + 9.35D+00)
c  Sigmas is symmetric fission mass width taken from systematic of
c  Neuzil & Fairhall Phys.Rev. 129,2705,(1963)
c
c  *** Low Z fission is always symmetric
c
c  *** High Z fission is sometimes.loop back here from 1 loop if
c  *** symmetric fission predicted.
c
      ASMEAN = HLFHLF * A
      CALL DT_NORRAN(A1)
c  1st fragment mass: gaussian distributed around A/2 with
c                     variance Sigmas
      A1 = ASMEAN + A1 * SIGMAS
c  Come here for high Z/fissility for U =< 62 MeV and assymmetric
c  fission selected:
   30 CONTINUE
c  1 loop for assymmetric fission returns to here.
      IHLP = NINT (A1)
      AFIS (NFISS1) = DBLE (IHLP)
c  Check for low final a
      IF ( AFIS (NFISS1) .LT. FIVFIV ) AFIS (NFISS1) = FIVFIV
      IF ( A-AFIS(NFISS1).LT. FIVFIV ) AFIS (NFISS1) = A - FIVFIV
      AFIS (NFISS2) = A - AFIS (NFISS1)
c  Pick the charge
      Z1 = 65.5D+00 * AFIS(NFISS1) / ( 131.D+00 + AFIS(NFISS1)**TWOTHI )
      Z2 = 65.5D+00 * AFIS(NFISS2) / ( 131.D+00 + AFIS(NFISS2)**TWOTHI )
c  This card actually "averages" the above choiches for Z1 and Z2
      Z1 = Z1 + HLFHLF * ( Z - Z1 - Z2 )
c  We use constant charge density with a 2 unit gaussian smearing
      CALL DT_NORRAN(ZHLP)
c  Gaussian choiche centered on Z1 with variance of 2 units
      Z1   = Z1 + TWOTWO * ZHLP
      IHLP = NINT (Z1)
      ZFIS (NFISS1) = DBLE (IHLP)
      ZFIS (NFISS2) = Z - ZFIS (NFISS1)
c  Check for reasonable Z/A combinations:
      IF ( ZFIS (NFISS1) .GE. AFIS (NFISS1) ) GO TO 10
      IF ( ZFIS (NFISS2) .GE. AFIS (NFISS2) ) GO TO 10
      IF ( ZFIS (NFISS1) .LT. ONEMNS ) GO TO 10
      IF ( ZFIS (NFISS2) .LT. ONEMNS ) GO TO 10
c  Compute actual masses of fragments
      AMFIS (NFISS1) = AFIS (NFISS1) * AMUMEV +DT_ENERGY(AFIS(NFISS1),
     &                 ZFIS (NFISS1) )
      AMFIS (NFISS2) = AFIS (NFISS2) * AMUMEV +DT_ENERGY(AFIS(NFISS2),
     &                 ZFIS (NFISS2) )
c  Total "available" energy in the CMS:
      ETAVAI = UMO - AMFIS (NFISS1) - AMFIS (NFISS2)
c  Pick recoil kinetic energy.use systematic of ...........
c  Unik et.al. Proc.3rd IAEA Symp.on phy.& chem. fission,Rochester.vo
      TOTKM  = 0.13323D+00 * Z * Z / A**ONETHI - 11.4D+00
c  Use a width of 15% value at half height.
      SIGMAK = 0.084D+00 * TOTKM
c  Check event is energetically possible
      NCK = 0
c  +-------------------------------------------------------------------*
c  |  Loop here to select the total kinetic energy
   40 CONTINUE
         CALL DT_NORRAN(TOTKE)
         TOTKE = TOTKM + TOTKE * SIGMAK
         IF ( NCK .GT. 10 ) GO TO 10
         NCK = NCK + 1
      IF ( TOTKE .GT. ETAVAI ) GO TO 40
c  |
c  +-------------------------------------------------------------------*
c  Pick excitation from equidistribution of original plus energy balance
      TEMP = ( ETAVAI - TOTKE ) / A
      UFIS (NFISS1) = AFIS (NFISS1) * TEMP
      UFIS (NFISS2) = AFIS (NFISS2) * TEMP
c  Find total masses, including excitation energies, at evap time
      AMCMS1 = AMFIS (NFISS1) + UFIS (NFISS1)
      AMCMS2 = AMFIS (NFISS2) + UFIS (NFISS2)
      AMDIFF = UMO - AMCMS1 - AMCMS2
c  Amdiff= Totke should be satisfied
      IF ( AMDIFF .LT. ZERZER ) GO TO 40
      UMO2 = UMO * UMO
c 1st fragment total energy in the CMS
      ECMS1 = HLFHLF * ( UMO2 + AMCMS1**2 - AMCMS2**2 ) / UMO
c 2nd fragment total energy in the CMS
      ECMS2 = HLFHLF * ( UMO2 - AMCMS1**2 + AMCMS2**2 ) / UMO
c  C(i) are the direction cosines of the 1st fragment
c  in the CMS frame, of course - C(i)
c  are the ones of the 2nd fragment
      CALL DT_RACO(C(1),C(2),C(3))
      PCMS  = SQRT ( ( ECMS1 - AMCMS1 ) * ( ECMS1 + AMCMS1 ) )
c  Now we perform the Lorentz transformation back to the original
c  frame (lab frame)
c  First the 1st fragment:
      ETAX = ETACM * COSLF0 (1)
      ETAY = ETACM * COSLF0 (2)
      ETAZ = ETACM * COSLF0 (3)
      PCMSX = PCMS * C (1)
      PCMSY = PCMS * C (2)
      PCMSZ = PCMS * C (3)
      ETAPCM = PCMSX * ETAX + PCMSY * ETAY + PCMSZ * ETAZ
      EKFIS (NFISS1) = GAMCM * ECMS1 + ETAPCM - AMCMS1
      PHELP = ETAPCM / ( GAMCM + ONEONE ) + ECMS1
      PLBPX = PCMSX + ETAX * PHELP
      PLBPY = PCMSY + ETAY * PHELP
      PLBPZ = PCMSZ + ETAZ * PHELP
      PHELP = SQRT (PLBPX * PLBPX + PLBPY * PLBPY + PLBPZ * PLBPZ)
      COSLFF (1,NFISS1) = PLBPX / PHELP
      COSLFF (2,NFISS1) = PLBPY / PHELP
      COSLFF (3,NFISS1) = PLBPZ / PHELP
      PPFIS (NFISS1) = PHELP
c  Then the residual nucleus ( for it c (i) --> - c (i) ):
      EKFIS (NFISS2) = GAMCM * ECMS2 - ETAPCM - AMCMS2
      PHELP = - ETAPCM / ( GAMCM + ONEONE ) + ECMS2
      PLBPX = - PCMSX + ETAX * PHELP
      PLBPY = - PCMSY + ETAY * PHELP
      PLBPZ = - PCMSZ + ETAZ * PHELP
      PHELP = SQRT (PLBPX * PLBPX + PLBPY * PLBPY + PLBPZ * PLBPZ)
      COSLFF (1,NFISS2) = PLBPX / PHELP
      COSLFF (2,NFISS2) = PLBPY / PHELP
      COSLFF (3,NFISS2) = PLBPZ / PHELP
      PPFIS (NFISS2) = PHELP
c  +-------------------------------------------------------------------*
c  |  Set up a few variables in the common Higfis:
      IF ( NFISS .EQ. 0 ) THEN
         APR0   = A
         ZPR0   = Z
         EREC0  = EREC
         UU0    = U
      END IF
c  |
c  +-------------------------------------------------------------------*
c  Set up a flag these fission fragments are not
c  "particle stable states"
      ISTFIS (NFISS1) = -1
      ISTFIS (NFISS2) = -1
c  Update the fission fragment counter:
      NFISS = NFISS2
      RETURN
c=== Fisfra ===========================================================*
   50 FORMAT (' --> FISSION FAILED: JA=',I5,'  JZ=',I5/'-       U=',1PE1
     1 0.3,'      EREC=',E10.3/'    ZFIS1=',E10.3,'     AFIS1=',E10.3/'
     2   ZFIS2=',E10.3,'     AFIS2=',E10.3)
   60 FORMAT (//'  LOGIC ERROR IN FISFRA.CALLED WITH FISINH FLAG',' UNSE
     1T.',2I10,2F10.5)
      END

c$ CREATE DT_FPROB.FOR
cCOPY DT_FPROB
c
c=== fprob ============================================================*
c
CDECK  ID>, DT_FPROB
      DOUBLE PRECISION FUNCTION DT_FPROB(Z,A,U)

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c  Fission PROBability:                                                *
c                                                                      *
c  Created  on  8 april 1993   by     Alfredo Ferrari & Paola Sala     *
c                                                INFN - Milan          *
c                                                                      *
c  Last change  on  26-jul-94  by  Alfredo Ferrari, INFN - Milan       *
c                                                                      *
c  This function is just a translation into Fluka of the same function *
c  of LAHET kindly provided by R.E. Prael                              *
c                                                                      *
c     Input variables:                                                 *
c                       Z = present nucleus atomic number              *
c                       A =    "       "     mass    '  &&  KK '       *
c                       U =    "       "    excitation energy (MeV)    *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: EVA0)
      COMMON /FKEVA0/ Y0, B0, P0 (1001), P1 (1001), P2 (1001),
     *                FLA (6), FLZ (6), RHO (6), OMEGA (6), EXMASS (6),
     *                CAM2 (130), CAM3 (200), CAM4 (130), CAM5 (200),
     *                T (4,7), RMASS (297), ALPH (297), BET (297),
     *                APRIME (250), IA (6), IZ (6)

c (original name: HIGFIS)
      PARAMETER ( IZFSMX = 61 )
      LOGICAL FISINH, LFRGMN, LAGOES
      COMMON /FKHIGF/ AFIS  (10), ZFIS  (10), UFIS  (10), EKFIS  (10),
     &                AMFIS (10), PPFIS (10), COSLFF(3,0:10),
     &                ATFIS (10), ZTFIS (10), UTFIS (10), RECFIS (10),
     &                AMTFIS(10), PPTFIS(10), EBFISS, AMDIFF,
     &                APR0, ZPR0, EREC0, UU0, HEVFIS (0:10),
     &                ISTFIS(10), NPARTF (6,0:10), NFISS, FISINH,
     &                LFRGMN, LAGOES
      DIMENSION COSLF0 (3)
      EQUIVALENCE ( COSLF0 (1), COSLFF (1,0) )

c (original name: INPFLG)
      COMMON /FKINPF/ IANG,IFISS,IB0,IGEOM,ISTRAG,KEYDK

C
C   FUNCTION TO COMPUTE THE FISSION PROBABILITY.
C     FOR Z<90 USES ..........
C    USES STATISTICAL MODEL FITS.
C
      PARAMETER (LNFIS=18)
      DIMENSION SLOPE(LNFIS), ANORT(LNFIS)
      SAVE A1, A2, A3, CONST, SLOPE, ANORT
C     SAVE C1, C2, C3
      DATA A1, A2, A3, CONST /0.2185024D0,16.70314D0,321.175D0,
     & 0.3518099D0/
C     DATA C1, C2, C3 /1.089257D0,0.01097896D0,31.08551D0/
C     FORZ> 89 AND <100 ........
C     USE THE SYSTEMATICS OF VANDENBOSCH & HUIZENGA WITH A BALL PARK
C     OBSERVATION THAT FISSION PROBABILITY DROPS FOR MOST NUCLEI
C     AT 6 MeV
      DATA SLOPE /0.23D0,0.233D0,0.12225D0,0.14727D0,0.13559D0,0.15735D0
     1 ,0.16597D0,0.17589D0,0.18018D0,0.19568D0,0.16313D0,0.17123D0,
     2 6*0.17D0/
C     DATA ANORT /221.6,226.9,229.75,234.04,238.88,241.34,243.04,245.52,
C    1 246.84,250.18,254.0,257.8/
      DATA ANORT /219.4D0,226.9D0,229.75D0,234.04D0,238.88D0,241.34D0,
     1 243.04D0,245.52D0,246.84D0,250.18D0,254.0D0,257.8D0,261.3D0,
     2 264.8D0,268.3D0,271.8D0,275.3D0,278.8D0/
c
      DT_FPROB = ZERZER
      JZ    = NINT (Z)
      JA    = NINT (A)
c  +-------------------------------------------------------------------*
c  |  High Z fission probability: a simple expression of the kind
c  |  Gamma_neutron / Gamma_fission = 10^( s(z) x ( A - Af(z) ) is
c  |  used provided U >= 6 MeV. Please note that no explicit excitation
c  |  energy dependence is used!!!!
      IF ( JZ .GT. 88 ) THEN
         JZ = JZ - 88
         IF ( JZ .GT. LNFIS .OR. U .LT. SIXSIX ) GO TO 20
c  |  Gamnf = Gamma_neutron / Gamma_fission
         GAMNF = SLOPE (JZ) * ( DBLE (JA) - ANORT (JZ) )
         GAMNF = TENTEN**GAMNF
         GO TO 10
      END IF
c  |
c  +-------------------------------------------------------------------*
      JN = JA - JZ
c This statement should compute the reaction Q for neutron emission
c less terms of the Cameron mass formula which should be understood
      SE = DT_ENERGY(A-ONEONE,Z)-DT_ENERGY(A,Z)+EXMASS(1)
     &     -CAM2(JZ)-CAM3(JN-1)
c odd-odd: twice the pairing of the residual nucleus is subtracted
c          from the reaction Q (the residual nucleus will be even-odd)
c odd-even: the residual nucleus pairing is subtracted (the residual
c           nucleus will be even-even or odd-odd)
c     IF ((2*(JZ/2).NE.JZ).OR.(2*(JN/2).NE.JN)) SE=SE-CAM4(JZ)-CAM5(JN-1
c    1 )
c     IF ((2*(JZ/2).NE.JZ).AND.(2*(JN/2).NE.JN)) SE=SE-CAM4(JZ)-CAM5(JN-
c    1 1)
      JZODD = MOD ( JZ, 2 )
      JNODD = MOD ( JN, 2 )
      SE = SE - ( JZODD + JNODD ) * ( CAM4 (JZ) + CAM5 (JN-1) )
c X = fissility
      X  = Z*Z / A
c The following card should compute a sort of fission barrier, please
c note that SE is larger the higher the energy required for neutron
c evaporation
      EBFISS = X * ( A1 * X - A2 ) + A3 + SE
c Not enough energy to overcome the barrier
      IF ( EBFISS .GT. U ) GO TO 20
c The following should be the level density constant asmall for
c the neutron emission, A-1 / 8
c     AN  = 0.125D+00 * ( A - ONEONE )
c ** The following coding to compute the "sophisticated" level density
c ** (provided it is meaningfil in this context)
      QE = DT_ENERGY(A-ONEONE,Z) - DT_ENERGY(A,Z) + EXMASS (1)
      UMXRES = U - QE
      JN     = JA - JZ - 1
      ILVMOD = IB0
c  This is the a lower case of the level density
      AN  = DT_GETA( UMXRES, JZ, JN, ILVMOD, ISDUM, ASMMAX, ASMMIN )
c ** end "sophisticated" level density **
      AN1 = HLFHLF / AN
      AN2 = 0.25D+00 * AN1 / AN
c The following cards should compute some level density constant
c for fission
c "Normal" Atchinson:
c     AF = X - C3
c     AF = AN * ( C1 + C2 * AF * AF )
c 1st trial:
c     AF = MIN ( X - 31.D+00, ZERZER )
c     BF = MAX ( X - 31.D+00, ZERZER )
c     CHELP = 0.01D+00
c     AF = AN * C1 * ( ONEONE + CHELP * AF * AF )
c    &   / ( ONEONE + CHELP * BF * BF )
c     AF = MAX ( AF, ONEONE )
c  1st trial:
c     AF = MIN ( X - 32.2D+00, ZERZER )
c     BF = MIN ( X - 30.2D+00, ZERZER )
c     CHELP  = 0.025D+00
c     DHELP  = 0.025D+00 / 1.15D+00
c     AF     = AN * 1.075D+00 * SQRT ( ( CHELP * AF * AF + ONEONE )
c    &       / ( DHELP * BF * BF + ONEONE ) )
c  2nd trial:
c     AF = MIN ( X - 32.3D+00, ZERZER )
c     BF = MIN ( X - 30.3D+00, ZERZER )
c     CHELP  = 0.022D+00
c     DHELP  = 0.022D+00 / 1.15D+00
c     AF     = AN * 1.078D+00 * SQRT ( ( CHELP * AF * AF + ONEONE )
c    &       / ( DHELP * BF * BF + ONEONE ) )
c  3rd trial:
c     AF = MIN ( X - 32.3D+00, ZERZER )
c     BF = MIN ( X - 30.4D+00, ZERZER )
c     CHELP  = 0.021D+00
c     DHELP  = 0.021D+00 / 1.12D+00
c     AF     = AN * 1.080D+00 * SQRT ( ( CHELP * AF * AF + ONEONE )
c    &       / ( DHELP * BF * BF + ONEONE ) )
c  4th trial:
      AF = MIN ( X - 32.3D+00, ZERZER )
      BF = MIN ( X - 30.7D+00, ZERZER )
      CHELP  = 0.021D+00
      DHELP  = 0.021D+00 / 1.06D+00
      AF     = AN * 1.080D+00 * SQRT ( ( CHELP * AF * AF + ONEONE )
     &       / ( DHELP * BF * BF + ONEONE ) )
c*sr 30.6.
c  Corrective factor for large excitation energies (if energy
c  dependent level densities are used maybe it is required):
c     AF = AN + ( AF - AN ) * EXP ( - ( U - EBFISS )
c    &                            / ( 500.D+00 * EBFISS ) )
c  Go smoothly down per Z=Izfsmx
      IF ( JZ .LT. IZFSMX - 5 ) AF = AF + ( AF - AN )
     &                             * ( JZ - IZFSMX) / FIVFIV
c*
      A1THRD = A**ONETHI
c Standard level density expression for neutron emission,
c S = 2 sqrt [ a ( U - Thresh ) ]
      S = TWOTWO * SQRT (AN*(U-SE))
c  +-------------------------------------------------------------------*
c  |  "Large" S:
      IF ( S .GT. TENTEN ) THEN
        DOUI0 = AN1 * (S-ONEONE)
        DOUI1 = S   * AN2 * ( ( S + S - SIXSIX ) + SIXSIX )
        GAMNF = CONST * ( ( ( 0.76D+00*DOUI1 - 5.D-02*DOUI0 ) * A1THRD
     &        + 1.93D+00*DOUI1 ) * A1THRD + 1.66D+00*DOUI0 )
c  |  Apparently standard level density expression with a_fission,
c  |  S = 2 sqrt [ a ( U - Thresh ) ]
        S2   = TWOTWO * SQRT (AF*(U-EBFISS))
        IF ( S - S2 .GT. -150.D+00 ) THEN
           EXPS = EXP (S-S2)
        ELSE
           EXPS = ZERZER
        END IF
        E2I = EXP (-S2)
c  |  Gamnf = Gamma_neutron / Gamma_fission
        GAMNF = GAMNF * EXPS * AF / ( S2 - ONEONE + ONEONE * E2I )
c  |
c  +-------------------------------------------------------------------*
c  |  "Small" S:
      ELSE
        E1 = EXP (S)
        DOUI0 = ( ( S - ONEONE ) * E1 + ONEONE ) * AN1
        DOUI1 = ( ( SIXSIX + S * ( S + S - SIXSIX ) ) * E1 + S * S
     &        - SIXSIX ) * AN2
        GAMNF = CONST * ( ( ( 0.76D+00*DOUI1 - 5.D-02*DOUI0 ) * A1THRD
     &        + 1.93D+00*DOUI1 ) * A1THRD + 1.66D+00*DOUI0 )
c  |  Apparently standard level density expression with a_fission,
c  |  S2 = 2 sqrt [ a ( U - Thresh ) ]
        S2 = TWOTWO * SQRT (AF*(U-EBFISS))
        E2 = ( ( S2 - ONEONE ) * EXP (S2) + ONEONE ) / AF
c  |  Gamnf = Gamma_neutron / Gamma_fission
        GAMNF = GAMNF / E2
      END IF
c  |
c  +-------------------------------------------------------------------*
   10 CONTINUE
      DT_FPROB = ONEONE / ( ONEONE + GAMNF )
   20 CONTINUE
      RETURN
c=== End of function Fprob ============================================*
      END

c$ CREATE FRBKIN.FOR
cCOPY FRBKIN
c
c=== frbkin ===========================================================*
c
CDECK  ID>, DT_FRBKIN
      SUBROUTINE DT_FRBKIN(LNCHLP,LPRINT)

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     Created on 08 february 1995  by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 10-mar-95     by    Alfredo Ferrari               *
c                                                                      *
c     Input variables:                                                 *
c                                                                      *
c                  Lnchlp = auxiliary flag for nuclear (.true.) or     *
c                           atomic (.false.) masses                    *
c                  Lprint = printout flag                              *
c                                                                      *
c     Output variables:                                                *
c                  none                                                *
c                                                                      *
c----------------------------------------------------------------------*
c
c (original name: FRBKCM)
      PARAMETER ( MXFFBK =     6 )
      PARAMETER ( MXZFBK =     9 )
      PARAMETER ( MXNFBK =    10 )
      PARAMETER ( MXAFBK =    16 )
      PARAMETER ( NXZFBK = MXZFBK + MXFFBK / 3 )
      PARAMETER ( NXNFBK = MXNFBK + MXFFBK / 3 )
      PARAMETER ( NXAFBK = MXAFBK + 1 )
      PARAMETER ( MXPSST =   300 )
      PARAMETER ( MXPSFB = 41000 )
      LOGICAL LFRMBK, LNCMSS
      COMMON /FKFRBK/  AMUFBK, EEXFBK (MXPSST), AMFRBK (MXPSST),
     &          EXFRBK (MXPSFB), SDMFBK (MXPSFB), COUFBK (MXPSFB),
     &          EXMXFB, R0FRBK, R0CFBK, C1CFBK, C2CFBK,
     &          IFRBKN (MXPSST), IFRBKZ (MXPSST),
     &          IFBKSP (MXPSST), IFBKPR (MXPSST), IFBKST (MXPSST),
     &          IPSIND (0:MXNFBK,0:MXZFBK,2), JPSIND (0:MXAFBK),
     &          IFBIND (0:NXNFBK,0:NXZFBK,2), JFBIND (0:NXAFBK),
     &          IFBCHA (5,MXPSFB), IPOSST, IPOSFB, IFBSTF,
     &          IFBFRB, NBUFBK, LFRMBK, LNCMSS

c (original name: NCDNVP)
      PARAMETER ( R0PRCH = 1.128 D+00 )
      PARAMETER ( R0DRPM = 1.18  D+00 )
      PARAMETER ( CKDRPM = 240.   D+00 )
      PARAMETER ( CJDRPM = 36.8   D+00 )
      PARAMETER ( CLDRPM = 100.   D+00 )
      PARAMETER ( CMDRPM = 0.     D+00 )
      PARAMETER ( CQDRPM = 17.    D+00 )
      PARAMETER ( CA1DRP = 15.96  D+00 )
      PARAMETER ( CA2DRP = 20.69  D+00 )
      PARAMETER ( CA3DRP = 0.     D+00 )
      PARAMETER ( CC1DRP = THRTHR / FIVFIV * COUGFM / R0DRPM * GEVMEV )
      PARAMETER ( CC2DRP = CC1DRP / 336.D+00 * ( ONEONE / CJDRPM
     &                   + 18.D+00 / CKDRPM ) )
      PARAMETER ( HC3DRP = CC1DRP * HLFHLF * FIVFIV / R0DRPM / R0DRPM )
      PARAMETER ( HC4DRP = 0.610887057710857 D+00 )
      PARAMETER ( CC4DRP = FIVFIV / FOUFOU * HC4DRP * CC1DRP )
      PARAMETER ( CC5DRP = CC1DRP * CC1DRP / CQDRPM / 64.D+00 )
      PARAMETER ( R3TOVL = FOUFOU * PIPIPI / THRTHR )
      PARAMETER ( R0SSHM = HLFHLF / PIPIPI / ERFA00 )
      PARAMETER ( R0PSHM = ONETHI / PIPIPI / ERFA00 )
      LOGICAL LSHMDU, LUNFRU
      COMMON /FKNCDN/ RHCPSF (2,8), RHAPSF (2,8), RH0PSF (2,8),
     &                RHCESF (2,8), RHRDSF (2,8), RHFRSF (2,8),
     &                RRMSSF (2,8), RREQSF (2,8), VPCPSF (2,2),
     &                VPAPSF (2,2), VP0PSF (2,2), VPDPSF (2,2),
     &                VPEDSF (2,2), VPRDSF (2,2), VRMSSF (2,2),
     &                VREQSF (2,2), VPBPSF (2,2), RCVPSF (2,2),
     &                PCVPSF  (2) , VBARNN  (2) , VPEXSF  (2),
     &                SSHLNC  (2) , PSHLNC  (2) , AKVPPP, AKVPPN,
     &                BKVPPP, BKVPPN,
     &                JRHDNF  (2) , JNRHVP, JBOUVP, JRHODN, JRHOFL,
     &                LSHMDU, LUNFRU

c (original name: NUCDAT)
      PARAMETER ( AMUAMU = AMUGEV )
      PARAMETER ( AMPROT = AMPRTN )
      PARAMETER ( AMNEUT = AMNTRN )
      PARAMETER ( AMELEC = AMELCT )
      PARAMETER ( R0NUCL = 1.12        D+00 )
      PARAMETER ( RCCOUL = 1.7         D+00 )
      PARAMETER ( FERTHO = 14.33       D-09 )
      PARAMETER ( EXPEBN = 2.39        D+00 )
      PARAMETER ( BEXC12 = FERTHO * 72.40715579499394D+00 )
      PARAMETER ( AMUC12 = AMUGEV - HLFHLF * AMELCT + BEXC12 / 12.D+00 )
      PARAMETER ( AMHYDR = AMPRTN + AMELCT  )
      PARAMETER ( AMHTON = AMHYDR - AMNTRN  )
      PARAMETER ( AMNTOU = AMNTRN - AMUC12  )
      PARAMETER ( AMUCSQ = AMUC12 * AMUC12 )
      PARAMETER ( EBNDAV = HLFHLF * (AMPRTN + AMNTRN) - AMUC12 )
      PARAMETER ( GAMMIN = 1.0D-06 )
      PARAMETER ( GAMNSQ = 2.0D+00 * GAMMIN * GAMMIN )
      PARAMETER ( TVEPSI = GAMMIN / 100.D+00 )

      COMMON /FKNDAT/ AV0WEL,     APFRMX,     AEFRMX,     AEFRMA,
     &                RDSNUC,     V0WELL (2), PFRMMX (2), EFRMMX (2),
     &                EFRMAV (2), AMNUCL (2), AMNUSQ (2), EBNDNG (2),
     &                VEFFNU (2), ESLOPE (2), PKMNNU (2), EKMNNU (2),
     &                PKMXNU (2), EKMXNU (2), EKMNAV (2), EKINAV (2),
     &                EXMNAV (2), EKUPNU (2), EXMNNU (2), EXUPNU (2),
     &                ERCLAV (2), ESWELL (2), FINCUP (2), AMRCAV    ,
     &                AMRCSQ    , ATO1O3    , ZTO1O3    , ELBNDE (0:100)

c
      LOGICAL LNCHLP, LPRINT
      PARAMETER ( MXGAMM = 3*MXFFBK - 1 )
c  Required if 3100,3300 are not activated
c     PARAMETER ( MXHELP = 18000 )
      PARAMETER ( MXHELP =  6000 )
      DIMENSION QBRHLP (MXHELP), FATTOR (0:MXFFBK), FGAMMA (MXGAMM),
     &          AT1O3  (NXAFBK), AT1O3C (NXAFBK)  , IF1HLP (MXHELP),
     &          IF2HLP (MXHELP), MULHLP (MXHELP),
     &          IDHELP (MXFFBK,MXHELP), ICHELP (MXHELP)
      DIMENSION SAVHLP (2,MXHELP)
      EQUIVALENCE ( IDHELP (1,1), SAVHLP (1,1) )
c
      LNCMSS = LNCHLP
c  +-------------------------------------------------------------------*
c  |  Nuclear masses have to be used
      IF ( LNCMSS ) THEN
         AMUFBK = AMUC12 * GEVMEV
c  |
c  +-------------------------------------------------------------------*
c  |  Atomic masses have to be used
      ELSE
         AMUFBK = AMUGEV * GEVMEV
      END IF
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Array initialization:
      DO 200 IZ = 0, MXZFBK
         DO 100 IN = 0, MXNFBK
            IPSIND (IN,IZ,1) =  0
            IPSIND (IN,IZ,2) = -1
  100    CONTINUE
  200 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Array initialization:
      DO 300 IA = 0, MXAFBK
         JPSIND (IA) =  0
  300 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Array initialization:
      DO 600 IZ = 0, NXZFBK
         DO 500 IN = 0, NXNFBK
            IFBIND (IN,IZ,1) =  0
            IFBIND (IN,IZ,2) = -1
  500    CONTINUE
  600 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Array initialization:
      DO 700 IA = 0, NXAFBK
         JFBIND (IA) =  0
         IF ( IA .GE. 1 ) THEN
            AT1O3  (IA) = IA
            AT1O3  (IA) = AT1O3  (IA)**ONETHI
c  |  Roughly "a la Evap"
c           AT1O3C (IA) = DBLE   (IA*(IA-1)) / ( DBLE ( IA + 6 ) )
c           AT1O3C (IA) = AT1O3C (IA)**ONETHI
            AT1O3C (IA) = AT1O3  (IA)
         END IF
  700 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  This is 0!
      FATTOR (0) = ONEONE
c  +-------------------------------------------------------------------*
c  |  Array initialization:
      DO 800 N = 1, MXFFBK
c  |  This is just n!
         FATTOR (N) = FATTOR (N-1) * DBLE (N)
  800 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c  This is Gamma(1/2)
      FGAMMA (1) = SQRT (PIPIPI)
c  This is Gamma(1)
      FGAMMA (2) = ONEONE
c  +-------------------------------------------------------------------*
c  |  Gamma[n/2] initialization.
      DO 900 N = 3, MXGAMM
         ZETA = HLFHLF * DBLE ( N - 2 )
c  |  Gamma(z+1)=zGamma(z)
         FGAMMA (N) = FGAMMA (N-2) * ZETA
  900 CONTINUE
c  |
c  +-------------------------------------------------------------------*
      JPOSST = 0
c  +-------------------------------------------------------------------*
c  |  Loop over the possible (final) states:
      DO 1000 I = 1, IPOSST
         IN    = IFRBKN (I)
         IZ    = IFRBKZ (I)
         JSPIN = IFBKSP (I)
         IPAR  = IFBKPR (I)
         ISTAB = IFBKST (I)
         ELEV  = EEXFBK (I)
         IA    = IN + IZ
         ATAR  = IA
         ZTAR  = IZ
c  |  The following card prevents the use of particle unstable states
c  |  with two or more decay modes available
         IF ( IFBSTF .LE. 2 .AND. ISTAB .LT. -900 ) GO TO 1000
c  |  The following card prevents the use of particle unstable states
c  |  flagged as non long-lived (but maybe with still one decay
c  |  channel only open)
         IF ( IFBSTF .LE. 1 .AND. ISTAB .LT. 0 ) GO TO 1000
c  |  The following card prevents the use of any particle unstable state
         IF ( IFBSTF .LE. 0 .AND. ISTAB .GT. 0 ) GO TO 1000
         JPOSST = JPOSST + 1
         IF ( I .NE. JPOSST ) STOP 'STOP:FRBKIN-JPOSST-I'
         IF ( JPSIND (IA) .GT. 0 .AND. JPSIND (IA) .NE. JPOSST - 1 )
     &        STOP 'STOP:JPOSST-IA'
         JPSIND (IA) = JPOSST
         IF ( IPSIND (IN,IZ,1) .LE. 0 ) THEN
            IPSIND (IN,IZ,1) = JPOSST
            IPSIND (IN,IZ,2) = JPOSST
         ELSE
            IF ( IPSIND (IN,IZ,2) .NE. JPOSST - 1 ) STOP 'STOP:JPOSST'
            IPSIND (IN,IZ,2) = JPOSST
         END IF
c  |  ATOMIC mass:
         AMFRBK (I) = ATAR * AMUGEV * GEVMEV + DT_ENERGY(ATAR,ZTAR)
     &              + EEXFBK (I)
c  |  +----------------------------------------------------------------*
c  |  |  NUCLEAR masses are to be used:
         IF ( LNCMSS ) THEN
            AMFRBK (I) = AMFRBK (I) - ZTAR * AMELCT * GEVMEV
     &                 + GEVMEV * ELBNDE (IZ)
c  |  |  This is the total NUCLEAR excess mass of the current level:
            EEXFBK (I) = EEXFBK (I) + DT_ENERGY(ATAR,ZTAR)
     &                 + ATAR * GEVMEV * ( AMUGEV - AMUC12 )
     &                 - ZTAR * GEVMEV * AMELCT + GEVMEV * ELBNDE (IZ)
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  ATOMIC masses are to be used:
         ELSE
c  |  |  This is the total ATOMIC excess mass of the current level:
            EEXFBK (I) = EEXFBK (I) + DT_ENERGY(ATAR,ZTAR)
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         EEXCHK = AMFRBK (I) - ATAR * AMUFBK
         IF ( LPRINT ) WRITE (ErrorOut,
     * *)' Jposst:',JPOSST,' Z:',IZ,
     &      ' A:',IA,' E_EX',SNGL(ELEV),' ISTAB',ISTAB
         IF ( ABS (EEXCHK-EEXFBK(I)) .GT. CSNNRM * AMFRBK (I) )
     &      STOP 'STOP:FRBKIN-INVALID-EXCESS-MASS'
 1000 CONTINUE
c  |
c  +-------------------------------------------------------------------*
c === Set up the A=1 case: === *
c  N = 1, Z = 0
      IN     = 1
      IZ     = 0
c  "Break up" into 1 neutron (iposfb=1):
      IPOSFB = 1
      IFBIND (IN,IZ,1)  = IPOSFB
      IFBIND (IN,IZ,2)  = IPOSFB
c  N:
      IFBCHA (1,IPOSFB) = IN
c  Z:
      IFBCHA (2,IPOSFB) = IZ
c  First fragment id:
      IFBCHA (3,IPOSFB) = 1
c  Second (possibly composite) fragment id:
      IFBCHA (4,IPOSFB) = 0
c  Multiplicity:
      IFBCHA (5,IPOSFB) = 1
c  Spin/degeneracy/mass factor (dummy in this case):
      SDMFBK (IPOSFB)   = ONEONE
c  Coulomb barrier:
      COUFBK (IPOSFB)   = ZERZER
c  Total mass excess (atomic or nuclear depending on the option):
      EXFRBK (IPOSFB) = EEXFBK (1)
c  N = 0, Z = 1
      IN     = 0
      IZ     = 1
c  "Break up" into 1 proton (iposfb=2):
      IPOSFB = IPOSFB + 1
      IFBIND (IN,IZ,1)  = IPOSFB
      IFBIND (IN,IZ,2)  = IPOSFB
c  N:
      IFBCHA (1,IPOSFB) = IN
c  Z:
      IFBCHA (2,IPOSFB) = IZ
c  First fragment id:
      IFBCHA (3,IPOSFB) = 2
c  Second (possibly composite) fragment id:
      IFBCHA (4,IPOSFB) = 0
c  Multiplicity:
      IFBCHA (5,IPOSFB) = 1
c  Spin/degeneracy/mass factor (dummy in this case):
      SDMFBK (IPOSFB)   = ONEONE
c  Coulomb barrier:
      COUFBK (IPOSFB)   = ZERZER
c  Total mass excess (atomic or nuclear depending on the option):
      EXFRBK (IPOSFB)   = EEXFBK (2)
      JFBIND (1) = IPOSFB
c === Set up the A=2 case: === *
      VOLFBK = R3TOVL * TWOTWO * R0FRBK**3
      VOLUM0 = R3TOVL * TWOTWO * R0DRPM**3
      FCVOLU = VOLFBK / ( TWOPIP * PLABRC * GEVMEV )**3
c  Botvina's expression for the r0 to be used for barrier calculations
      RCFRBK = R0CFBK * ( ONEONE + C1CFBK ) / ( ONEONE + C2CFBK )
      FCCOU0 = 0.6D+00 * COUGFM * GEVMEV / RCFRBK
     &       / ( ONEONE + VOLFBK / VOLUM0 )**ONETHI
      NGAMMA = 3
      E32NM1 = HLFHLF * DBLE (NGAMMA)
c  N = 2, Z = 0
      IN     = 2
      IZ     = 0
c  Break up into 2 neutrons (iposfb=3):
      IPOSFB = IPOSFB + 1
      IFBIND (IN,IZ,1)  = IPOSFB
      IFBIND (IN,IZ,2)  = IPOSFB
c  N:
      IFBCHA (1,IPOSFB) = IN
c  Z:
      IFBCHA (2,IPOSFB) = IZ
c  First fragment id:
      IFBCHA (3,IPOSFB) = 1
c  Second (possibly composite) fragment id:
      IFBCHA (4,IPOSFB) = 1
c  Mass factors:
      FCMASS = AMFRBK (IFBCHA(3,IPOSFB)) * AMFRBK (IFBCHA(4,IPOSFB))
      TOTMAS = AMFRBK (IFBCHA(3,IPOSFB)) + AMFRBK (IFBCHA(4,IPOSFB))
c  Multiplicity:
      IFBCHA (5,IPOSFB) = 2
c  Spin/degeneracy/mass factor:
      SDMFBK (IPOSFB)   = TWOTWO**2 / FATTOR (2) * FCVOLU
     &                  * ( FCMASS / TOTMAS )**1.5D+00
     &                  * TWOPIP**E32NM1 / FGAMMA (NGAMMA)
c  Coulomb barrier:
      COUFBK (IPOSFB)   = ZERZER
c  Total mass excess (atomic or nuclear depending on the option):
      EXFRBK (IPOSFB)   = EEXFBK (1) + EEXFBK (1)
c  N = 1, Z = 1
      IN     = 1
      IZ     = 1
c  Break up into 1 neutron and 1 proton (iposfb=4):
      IPOSFB = IPOSFB + 1
      IFBIND (IN,IZ,1)  = IPOSFB
      IFBIND (IN,IZ,2)  = IPOSFB
c  N:
      IFBCHA (1,IPOSFB) = IN
c  Z:
      IFBCHA (2,IPOSFB) = IZ
c  First fragment id:
      IFBCHA (3,IPOSFB) = 1
c  Second (possibly composite) fragment id:
      IFBCHA (4,IPOSFB) = 2
c  Mass factors:
      FCMASS = AMFRBK (IFBCHA(3,IPOSFB)) * AMFRBK (IFBCHA(4,IPOSFB))
      TOTMAS = AMFRBK (IFBCHA(3,IPOSFB)) + AMFRBK (IFBCHA(4,IPOSFB))
c  Multiplicity:
      IFBCHA (5,IPOSFB) = 2
c  Spin/degeneracy/mass factor:
      SDMFBK (IPOSFB)   = TWOTWO**2 / FATTOR (1) * FCVOLU
     &                  * ( FCMASS / TOTMAS )**1.5D+00
     &                  * TWOPIP**E32NM1 / FGAMMA (NGAMMA)
c  Coulomb barrier:
      COUFBK (IPOSFB)   = ZERZER
c  Total mass excess (atomic or nuclear depending on the option):
      EXFRBK (IPOSFB)   = EEXFBK (1) + EEXFBK (2)
c  N = 0, Z = 2
      IN     = 0
      IZ     = 2
      FCCOUL = FOUFOU / AT1O3 (2)
c  Break up into 2 protons (iposfb=5):
      IPOSFB = IPOSFB + 1
      IFBIND (IN,IZ,1)  = IPOSFB
      IFBIND (IN,IZ,2)  = IPOSFB
c  N:
      IFBCHA (1,IPOSFB) = IN
c  Z:
      IFBCHA (2,IPOSFB) = IZ
c  First fragment id:
      IFBCHA (3,IPOSFB) = 2
c  Second (possibly composite) fragment id:
      IFBCHA (4,IPOSFB) = 2
c  Mass factors:
      FCMASS = AMFRBK (IFBCHA(3,IPOSFB)) * AMFRBK (IFBCHA(4,IPOSFB))
      TOTMAS = AMFRBK (IFBCHA(3,IPOSFB)) + AMFRBK (IFBCHA(4,IPOSFB))
c  Multiplicity:
      IFBCHA (5,IPOSFB) = 2
c  Spin/degeneracy/mass factor:
      SDMFBK (IPOSFB)   = TWOTWO**2 / FATTOR (2) * FCVOLU
     &                  * ( FCMASS / TOTMAS )**1.5D+00
     &                  * TWOPIP**E32NM1 / FGAMMA (NGAMMA)
c  Coulomb barrier:
      FCCOUL = FCCOUL - TWOTWO / AT1O3 (1)
      IF ( FCCOUL .LT. ZERZER ) STOP 'STOP:FRBKIN-FCCOUL-P-P'
      COUFBK (IPOSFB)   = FCCOU0 * FCCOUL
c  Total mass excess (atomic or nuclear depending on the option):
      EXFRBK (IPOSFB)   = EEXFBK (2) + EEXFBK (2)
      JFBIND (2) = IPOSFB
c === Set up the A=3 case: === *
      VOLFBK = R3TOVL * THRTHR * R0FRBK**3
      VOLUM0 = R3TOVL * THRTHR * R0DRPM**3
      FCVOL2 = VOLFBK / ( TWOPIP * PLABRC * GEVMEV )**3
      FCVOL3 = ( VOLFBK / ( TWOPIP * PLABRC * GEVMEV )**3 )**2
      NGAMM2 = 3
      NGAMM3 = 6
      E32NM2 = HLFHLF * DBLE (NGAMM2)
      E32NM3 = HLFHLF * DBLE (NGAMM3)
c  N = 3, Z = 0
      IN     = 3
      IZ     = 0
c  Break up into 3 neutrons (iposfb=6):
      IPOSFB = IPOSFB + 1
      IFBIND (IN,IZ,1)  = IPOSFB
      IFBIND (IN,IZ,2)  = IPOSFB
c  N:
      IFBCHA (1,IPOSFB) = IN
c  Z:
      IFBCHA (2,IPOSFB) = IZ
c  First fragment id:
      IFBCHA (3,IPOSFB) = +1
c  Second (possibly composite) fragment id:
      IFBCHA (4,IPOSFB) = -3
c  Mass factors:
      FCMASS = AMFRBK (1)**3
      TOTMAS = THRTHR * AMFRBK (1)
c  Multiplicity:
      IFBCHA (5,IPOSFB) = 3
c  Spin/degeneracy/mass factor:
      SDMFBK (IPOSFB)   = TWOTWO**3 / FATTOR (3) * FCVOL3
     &                  * ( FCMASS / TOTMAS )**1.5D+00
     &                  * TWOPIP**E32NM3 / FGAMMA (NGAMM3)
c  Coulomb barrier:
      COUFBK (IPOSFB)   = ZERZER
c  Total mass excess (atomic or nuclear depending on the option):
      EXFRBK (IPOSFB)   = EEXFBK (1) + EXFRBK (3)
c  N = 2, Z = 1
      IN     = 2
      IZ     = 1
c  Break up into 1 neutron and 1 deuteron (iposfb=7):
      IPOSFB = IPOSFB + 1
      IFBIND (IN,IZ,1)  = IPOSFB
      IFBIND (IN,IZ,2)  = IPOSFB
c  N:
      IFBCHA (1,IPOSFB) = IN
c  Z:
      IFBCHA (2,IPOSFB) = IZ
c  First fragment id:
      IFBCHA (3,IPOSFB) = 1
c  Second (possibly composite) fragment id:
      IFBCHA (4,IPOSFB) = 3
c  Mass factors:
      FCMASS = AMFRBK (IFBCHA(3,IPOSFB)) * AMFRBK (IFBCHA(4,IPOSFB))
      TOTMAS = AMFRBK (IFBCHA(3,IPOSFB)) + AMFRBK (IFBCHA(4,IPOSFB))
c  Multiplicity:
      IFBCHA (5,IPOSFB) = 2
c  Spin/degeneracy/mass factor:
      SDMFBK (IPOSFB)   = TWOTWO / FATTOR (1) * FCVOL2
     &                  * ( FCMASS / TOTMAS )**1.5D+00
     &                  * TWOPIP**E32NM2 / FGAMMA (NGAMM2)
c  Coulomb barrier:
      COUFBK (IPOSFB)   = ZERZER
c  Total mass excess (atomic or nuclear depending on the option):
      EXFRBK (IPOSFB)   = EEXFBK (1) + EEXFBK (3)
c  Break up into 2 neutrons and 1 proton (iposfb=8):
      IPOSFB = IPOSFB + 1
      IFBIND (IN,IZ,2)  = IPOSFB
c  N:
      IFBCHA (1,IPOSFB) = IN
c  Z:
      IFBCHA (2,IPOSFB) = IZ
c  First fragment id:
      IFBCHA (3,IPOSFB) = +1
c  Second (possibly composite) fragment id:
      IFBCHA (4,IPOSFB) = -4
c  Mass factors:
      FCMASS = AMFRBK (1)**2 * AMFRBK (2)
      TOTMAS = TWOTWO * AMFRBK (1) + AMFRBK (2)
c  Multiplicity:
      IFBCHA (5,IPOSFB) = 3
c  Spin/degeneracy/mass factor:
      SDMFBK (IPOSFB)   = TWOTWO**3 / FATTOR (2) * FCVOL3
     &                  * ( FCMASS / TOTMAS )**1.5D+00
     &                  * TWOPIP**E32NM3 / FGAMMA (NGAMM3)
c  Coulomb barrier:
      COUFBK (IPOSFB)   = ZERZER
c  Total mass excess (atomic or nuclear depending on the option):
      EXFRBK (IPOSFB)   = EEXFBK (1) + EXFRBK (4)
c  N = 1, Z = 2
      IN     = 1
      IZ     = 2
c  Botvina's expression for the r0 to be used for barrier calculations
      RCFRBK = R0CFBK * ( ONEONE + C1CFBK ) / ( ONEONE + C2CFBK )
      FCCOU0 = 0.6D+00 * COUGFM * GEVMEV / RCFRBK
     &       / ( ONEONE + VOLFBK / VOLUM0 )**ONETHI
c  Break up into 1 proton and 1 deuteron (iposfb=9):
      FCCOUL = FOUFOU / AT1O3 (3)
      IPOSFB = IPOSFB + 1
      IFBIND (IN,IZ,1)  = IPOSFB
      IFBIND (IN,IZ,2)  = IPOSFB
c  N:
      IFBCHA (1,IPOSFB) = IN
c  Z:
      IFBCHA (2,IPOSFB) = IZ
c  First fragment id:
      IFBCHA (3,IPOSFB) = 2
c  Second (possibly composite) fragment id:
      IFBCHA (4,IPOSFB) = 3
c  Mass factors:
      FCMASS = AMFRBK (IFBCHA(3,IPOSFB)) * AMFRBK (IFBCHA(4,IPOSFB))
      TOTMAS = AMFRBK (IFBCHA(3,IPOSFB)) + AMFRBK (IFBCHA(4,IPOSFB))
c  Multiplicity:
      IFBCHA (5,IPOSFB) = 2
c  Spin/degeneracy/mass factor:
      SDMFBK (IPOSFB)   = TWOTWO / FATTOR (1) * FCVOL2
     &                  * ( FCMASS / TOTMAS )**1.5D+00
     &                  * TWOPIP**E32NM2 / FGAMMA (NGAMM2)
c  Coulomb barrier:
      FCCOUL = FCCOUL - ONEONE / AT1O3 (1) - ONEONE / AT1O3 (2)
      IF ( FCCOUL .LT. ZERZER ) STOP 'STOP:FRBKIN-FCCOUL-P-D'
      COUFBK (IPOSFB)   = FCCOU0 * FCCOUL
c  Total mass excess (atomic or nuclear depending on the option):
      EXFRBK (IPOSFB)   = EEXFBK (2) + EEXFBK (3)
c  Break up into 1 neutron and 2 protons (iposfb=10):
      FCCOUL = FOUFOU / AT1O3 (3)
      IPOSFB = IPOSFB + 1
      IFBIND (IN,IZ,2)  = IPOSFB
c  N:
      IFBCHA (1,IPOSFB) = IN
c  Z:
      IFBCHA (2,IPOSFB) = IZ
c  First fragment id:
      IFBCHA (3,IPOSFB) = +1
c  Second (possibly composite) fragment id:
      IFBCHA (4,IPOSFB) = -5
c  Mass factors:
      FCMASS = AMFRBK (1) * AMFRBK (2)**2
      TOTMAS = AMFRBK (1) + TWOTWO * AMFRBK (2)
c  Multiplicity:
      IFBCHA (5,IPOSFB) = 3
c  Spin/degeneracy/mass factor:
      SDMFBK (IPOSFB)   = TWOTWO**3 / FATTOR (2) * FCVOL3
     &                  * ( FCMASS / TOTMAS )**1.5D+00
     &                  * TWOPIP**E32NM3 / FGAMMA (NGAMM3)
c  Coulomb barrier:
      FCCOUL = FCCOUL - TWOTWO / AT1O3 (1)
      IF ( FCCOUL .LT. ZERZER ) STOP 'STOP:FRBKIN-FCCOUL-N-P-P'
      COUFBK (IPOSFB)   = FCCOU0 * FCCOUL
c  Total mass excess (atomic or nuclear depending on the option):
      EXFRBK (IPOSFB)   = EEXFBK (1) + EXFRBK (5)
c  N = 0, Z = 3
      IN     = 0
      IZ     = 3
c  Botvina's expression for the r0 to be used for barrier calculations
c  (with some approximation for Zfj Zj)
      RCFRBK = R0CFBK * ( ONEONE + C1CFBK * TWOTWO )
     &       / ( ONEONE + C2CFBK * TWOTWO )
      FCCOU0 = 0.6D+00 * COUGFM * GEVMEV / RCFRBK
     &       / ( ONEONE + VOLFBK / VOLUM0 )**ONETHI
      FCCOUL = ANINEN / AT1O3 (3)
c  Break up into 3 protons (iposfb=11):
      IPOSFB = IPOSFB + 1
      IFBIND (IN,IZ,1)  = IPOSFB
      IFBIND (IN,IZ,2)  = IPOSFB
c  N:
      IFBCHA (1,IPOSFB) = IN
c  Z:
      IFBCHA (2,IPOSFB) = IZ
c  First fragment id:
      IFBCHA (3,IPOSFB) = +2
c  Second (possibly composite) fragment id:
      IFBCHA (4,IPOSFB) = -5
c  Multiplicity:
      IFBCHA (5,IPOSFB) = 3
c  Mass factors:
      FCMASS = AMFRBK (2)**3
      TOTMAS = THRTHR * AMFRBK (2)
c  Multiplicity:
      IFBCHA (5,IPOSFB) = 3
c  Spin/degeneracy/mass factor:
      SDMFBK (IPOSFB)   = TWOTWO**3 / FATTOR (3) * FCVOL3
     &                  * ( FCMASS / TOTMAS )**1.5D+00
     &                  * TWOPIP**E32NM3 / FGAMMA (NGAMM3)
c  Coulomb barrier:
      FCCOUL = FCCOUL - THRTHR / AT1O3 (1)
      IF ( FCCOUL .LT. ZERZER ) STOP 'STOP:FRBKIN-FCCOUL-P-P-P'
      COUFBK (IPOSFB)   = FCCOU0 * FCCOUL
c  Total mass excess (atomic or nuclear depending on the option):
      EXFRBK (IPOSFB)   = EEXFBK (2) + EXFRBK (5)
      JFBIND (3) = IPOSFB
      IF ( IPOSFB .NE. 11 ) STOP 'STOP:FRBKIN-IPOSFB-A=3'
c  +-------------------------------------------------------------------*
c  |  Loop over all possible A values:
      DO 8000 IA = 4, NXAFBK
         IA2   = IA / 2
         ATAR  = IA
c  |  +----------------------------------------------------------------*
c  |  |  Loop over all possible Z values:
         DO 7000 IZ = MAX ( 0, IA - NXNFBK ), MIN ( IA, NXZFBK )
            NBREAK = 0
            IN     = IA - IZ
            ZTAR   = IZ
            VOLFBK = R3TOVL * ATAR * R0FRBK**3
            VOLUM0 = R3TOVL * ATAR * R0DRPM**3
c  |  |  Botvina's expression for the r0 to be used for barrier
c  |  |  calculations (with some approximation for Zfj Zj)
            RCFRBK = R0CFBK * ( ONEONE + C1CFBK * ( ZTAR - ONEONE ) )
     &             / ( ONEONE + C2CFBK * ( ZTAR - ONEONE ) )
            FCCOU0 = 0.6D+00 * COUGFM * GEVMEV / RCFRBK
     &             / ( ONEONE + VOLFBK / VOLUM0 )**ONETHI
            FCCOU2 = COUGFM * GEVMEV
            A1O3SU = ZERZER
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Emit one "stable" particle and look for all possible
c  |  |  |  combinations for the remnant:
c  |  |  |  JA, JZ, JN identify the "stable" emitted particle
c  |  |  |  KA, KZ, KN identify the "stable" or "composite" remnant
            DO 5000 JA = 1, IA2
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Loop over all possible Z:
               DO 4000 JZ = MAX ( 0, JA - IN ), MIN ( JA, IZ, MXZFBK )
                  JN   = JA - JZ
c  |  |  |  |  No "stable" level exists for this N-Z
                  IF ( JN .GT. MXNFBK .OR. JZ .GT. MXZFBK ) GO TO 4000
                  JPS1 = IPSIND (JN,JZ,1)
                  JPS2 = IPSIND (JN,JZ,2)
                  IF ( JPS2 .LT. JPS1 ) GO TO 4000
                  KA   = IA - JA
                  KN   = IN - JN
                  KZ   = IZ - JZ
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |  No "stable" remnant exists for this JN-JZ
                  IF ( KN .GT. MXNFBK .OR. KZ .GT. MXZFBK ) THEN
                     KPS1 = +0
                     KPS2 = -1
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |
                  ELSE
                     KPS1 = IPSIND (KN,KZ,1)
                     KPS2 = IPSIND (KN,KZ,2)
                  END IF
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
                  KFB1 = IFBIND (KN,KZ,1)
                  KFB2 = IFBIND (KN,KZ,2)
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |  Loop over all possible "stable" emitted fragments:
                  DO 3800 JP = JPS1, JPS2
c  |  |  |  |  |  +----------------------------------------------------*
c  |  |  |  |  |  |  Loop over all possible "stable" remnants:
                     DO 3200 KP = KPS1, KPS2
                        NBREAK = NBREAK + 1
                        MULHLP (NBREAK) = 2
                        IF1HLP (NBREAK) = JP
                        IF2HLP (NBREAK) = KP
                        QBRHLP (NBREAK) = EEXFBK (JP) + EEXFBK (KP)
                        QBREPS = CSNNRM * ABS (QBRHLP(NBREAK))
c  |  |  |  |  |  |  +-------------------------------------------------*
c  |  |  |  |  |  |  |  This way of eliminating equivalent break up
c  |  |  |  |  |  |  |  combinations is a bit dangerous, since it relies
c  |  |  |  |  |  |  |  on the assumption that identical Qs <==>
c  |  |  |  |  |  |  |  identical fragments:
                        DO 3100 IB = NBREAK - 1, 1, -1
                           IF ( ABS (QBRHLP(NBREAK)-QBRHLP(IB)) .LE.
     &                          QBREPS .AND. MULHLP (NBREAK) .EQ.
     &                          MULHLP (IB) ) THEN
                              NBREAK = NBREAK - 1
                              GO TO 3200
                           END IF
 3100                   CONTINUE
c  |  |  |  |  |  |  |
c  |  |  |  |  |  |  +-------------------------------------------------*
 3200                CONTINUE
c  |  |  |  |  |  |
c  |  |  |  |  |  +----------------------------------------------------*
                     IF ( KA .LE. 1 ) STOP 'STOP:FRBKIN-KA=1'
c  |  |  |  |  |  +----------------------------------------------------*
c  |  |  |  |  |  |  Loop over all possible "composite" remnants:
                     DO 3400 KP = KFB1, KFB2
                        IF ( IFBCHA (5,KP) + 1 .GT. MXFFBK ) GO TO 3400
c  |  |  |  |  |  |-->-->-->-->--> too many fragments
                        NBREAK = NBREAK + 1
                        MULHLP (NBREAK) = 1 + IFBCHA (5,KP)
                        IF1HLP (NBREAK) = JP
                        IF2HLP (NBREAK) = -KP
                        QBRHLP (NBREAK) = EEXFBK (JP) + EXFRBK (KP)
                        QBREPS = CSNNRM * ABS (QBRHLP(NBREAK))
c  |  |  |  |  |  |  +-------------------------------------------------*
c  |  |  |  |  |  |  |  This way of eliminating equivalent break up
c  |  |  |  |  |  |  |  combinations is a bit dangerous, since it relies
c  |  |  |  |  |  |  |  on the assumption that identical Qs <==>
c  |  |  |  |  |  |  |  identical fragments:
                        DO 3300 IB = NBREAK - 1, 1, -1
                           IF ( ABS (QBRHLP(NBREAK)-QBRHLP(IB)) .LE.
     &                          QBREPS .AND. MULHLP (NBREAK) .EQ.
     &                          MULHLP (IB) ) THEN
                              NBREAK = NBREAK - 1
                              GO TO 3400
                           END IF
 3300                   CONTINUE
c  |  |  |  |  |  |  |
c  |  |  |  |  |  |  +-------------------------------------------------*
 3400                CONTINUE
c  |  |  |  |  |  |
c  |  |  |  |  |  +----------------------------------------------------*
 3800             CONTINUE
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
 4000          CONTINUE
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
 5000       CONTINUE
c  |  |  |
c  |  |  +-------------------------------------------------------------*
            IF ( NBREAK .LE. 0 ) GO TO 7000
c  |  |  If we are there some possible break-up combination for IZ-IN
c  |  |  has been found: first of all deconvolute the break-up into the
c  |  |  very elementary components and get rid of duplicate
c  |  |  combinations (if any). If the loops 3100,3300 are activated it
c  |  |  is very likely that no duplicate combination survived up to
c  |  |  this point. It also takes care to delete too large excess mass
c  |  |  combinations if the break up channels are too many
            NACTUA = NBREAK
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Loop over the recorded combinations:
            DO 6000 IB = 1, NBREAK
               INCK   = 0
               IZCK   = 0
               IDHELP (1,IB) = IF1HLP (IB)
               INCK   = INCK + IFRBKN (IDHELP(1,IB))
               IZCK   = IZCK + IFRBKZ (IDHELP(1,IB))
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Just two "stable" particles:
               IF ( IF2HLP (IB) .GT. 0 ) THEN
                  IDHELP (2,IB) = IF2HLP (IB)
                  INCK = INCK + IFRBKN (IDHELP(2,IB))
                  IZCK = IZCK + IFRBKZ (IDHELP(2,IB))
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  The second one is a "composite" particle:
               ELSE
                  KP = IF2HLP (IB)
                  JB = 1
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |  Loop until only "stable" particles are left:
 5200             CONTINUE
                     KP = -KP
                     JB = JB + 1
                     IDHELP (JB,IB) = IFBCHA (3,KP)
                     INCK = INCK + IFRBKN (IDHELP(JB,IB))
                     IZCK = IZCK + IFRBKZ (IDHELP(JB,IB))
                     IF ( IDHELP (JB,IB) .LE. 0 )
     &                  STOP 'STOP:FRBKIN-IDHELP-1'
                     KP = IFBCHA (4,KP)
                  IF ( KP .LT. 0 ) GO TO 5200
c  |  |  |  |  |  Still a composite particle:
c  |  |  |  |  +-------------------------------------------------------*
                  JB   = JB + 1
                  IDHELP (JB,IB) = KP
                  INCK = INCK + IFRBKN (IDHELP(JB,IB))
                  IZCK = IZCK + IFRBKZ (IDHELP(JB,IB))
                  IF ( IDHELP (JB,IB) .LE. 0 )
     &                  STOP 'STOP:FRBKIN-IDHELP-2'
                  IF ( JB .NE. MULHLP (IB) ) STOP 'STOP:FRBKIN-MULHLP'
               END IF
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
               IF ( INCK .NE. IN .OR. IZCK .NE. IZ )
     &              STOP 'STOP:FRBKIN-INCK-IZCK'
               CALL DT_IORDIN( IDHELP (1,IB), ICHELP, MULHLP (IB) )
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Loop on previously considered break up combinations:
               DO 5400 LB = IB - 1, 1, -1
                  IF ( MULHLP (LB) .NE. MULHLP (IB) ) GO TO 5400
                  DO 5300 JB = 1, MULHLP (IB)
                     IF ( IDHELP (JB,LB) .NE. IDHELP (JB,IB)) GO TO 5400
 5300             CONTINUE
c  |  |  |  |  LBth and IBth break up's are identical:
                  IF ( ABS (QBRHLP(IB) - QBRHLP(LB)) .GT.
     &                 1.D-12 * ABS (QBRHLP(IB)) )
     &                STOP 'STOP:FRBKIN-QBRHLP-IB-LB'
c  |  |  |  |  Discard the current combination:
                  IF1HLP (IB) = 0
                  IF2HLP (IB) = 0
                  MULHLP (IB) = 0
                  QBRHLP (IB) = -AINFNT
                  NACTUA = NACTUA - 1
                  GO TO 6000
 5400          CONTINUE
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Too many combinations: discard the largest excess mass
c  |  |  |  |  ones:
               IF ( NBREAK .GT. NBUFBK .AND. QBRHLP (IB) .GT. EXMXFB )
     &            THEN
c  |  |  |  |  Discard the current combination:
                  IF1HLP (IB) = 0
                  IF2HLP (IB) = 0
                  MULHLP (IB) = 0
                  QBRHLP (IB) = -AINFNT
                  NACTUA = NACTUA - 1
                  GO TO 6000
               END IF
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  Only "real" combinations survive up to this point:
               IPOSFB = IPOSFB + 1
               IF ( IB .EQ. 1 ) IFBIND (IN,IZ,1) = IPOSFB
               IFBIND (IN,IZ,2)  = IPOSFB
               FCVOLU = ( TWOPIP * PLABRC * GEVMEV )**3 / VOLFBK
               FCSPIN = ONEONE
               FCMASS = ONEONE
               TOTMAS = ONEONE
               FCIDEN = ONEONE
               FCCOUL = ZTAR * ZTAR / AT1O3 (IA)
               FCCOU2 = COUGFM * GEVMEV
               A1O3SU = ZERZER
               NIDENT = +0
               IDCURR = -1
               NCHRGD = 0
               EEXCHK = ZERZER
               IZCHCK = IZ
               INCHCK = IN
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Compute the various factors and make some checks:
               DO 5500 JB = 1, MULHLP (IB)
                  KP = IDHELP (JB,IB)
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |  Check if it is still an identical particle (remind
c  |  |  |  |  |  that fragments are ordered by indeces, so possible
c  |  |  |  |  |  identical states are contigous:
                  IF ( KP .NE. IDCURR ) THEN
                     FCIDEN = FCIDEN * FATTOR (NIDENT)
                     NIDENT = 1
                     IDCURR = KP
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |
                  ELSE
                     NIDENT = NIDENT + 1
                  END IF
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |  Unknown spin for this level:
                  IF ( IFBKSP (KP) .LT. 0 ) THEN
                     IPSHLP = MOD ( IFRBKZ (KP) + IFRBKN (KP), 2 )
                     FCSPIN = FCSPIN * ( DBLE (IPSHLP) + ONEONE )
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
c  |  |  |  |  |
                  ELSE
                     FCSPIN = FCSPIN * ( DBLE (IFBKSP(KP)) + ONEONE )
                  END IF
c  |  |  |  |  |
c  |  |  |  |  +-------------------------------------------------------*
                  FCVOLU = FCVOLU * VOLFBK
     &                   / ( TWOPIP * PLABRC * GEVMEV )**3
                  TOTMAS = TOTMAS + AMFRBK (KP)
                  FCMASS = FCMASS * AMFRBK (KP)
                  FCCOUL = FCCOUL - IFRBKZ (KP)**2
     &                   / AT1O3 (IFRBKZ(KP)+IFRBKN(KP))
                  IF ( IFRBKZ (KP) .GT. 0 ) THEN
                     NCHRGD = NCHRGD + 1
                     ZCUR   = IFRBKZ (KP)
                     RCFCUR = R0CFBK * ( ONEONE + C1CFBK * ZCUR
     &                      * ( ZTAR - ZCUR ) )
     &                      / ( ONEONE + C2CFBK * ZCUR * ( ZTAR - ZCUR))
                     FCCOU2 = FCCOU2 * ZCUR
                     A1O3SU = A1O3SU + AT1O3C (IFRBKZ(KP)+IFRBKN(KP))
                  END IF
                  EEXCHK = EEXCHK + EEXFBK (KP)
                  IZCHCK = IZCHCK - IFRBKZ (KP)
                  INCHCK = INCHCK - IFRBKN (KP)
 5500          CONTINUE
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
               FCIDEN = FCIDEN * FATTOR (NIDENT)
               IF ( NCHRGD .LE. 1 ) FCCOUL = ZERZER
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Two body Coulomb barrier
               IF ( NCHRGD .EQ. 2 .AND. MULHLP (IB) .EQ. 2 ) THEN
c  |  |  |  |  Real two body barrier:
                  FCCOUL = FCCOU2 / RCFCUR / A1O3SU
c  |  |  |  |  Set up in this way to easy life after
                  FCCOUL = FCCOUL / FCCOU0
               END IF
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
               IF ( ABS (EEXCHK-QBRHLP (IB)) .GT. 1.D-12*ABS(QBRHLP(IB))
     &            ) STOP 'STOP:FRBKIN-EEXCHK-QBRHLP'
               IF ( IZCHCK .NE. 0 .OR. INCHCK .NE. 0 )
     &              STOP 'STOP:FRBKIN-IZCHCK-INCHCK'
               IF ( FCCOUL .LT. ANGLGB .AND. NCHRGD .GT. 1 )
     &              STOP 'STOP:FRBKIN-FCCOUL=0'
               IF ( FCCOUL .LT. ZERZER ) STOP 'STOP:FRBKIN-FCCOUL<0'
c  |  |  |  Index for the gamma function: please note it is
c  |  |  |  tabulated as Fgamma(i)=Gamma(i/2)
               NGAMMA = 3 * ( MULHLP (IB) - 1 )
               E32NM1 = HLFHLF * DBLE   (NGAMMA)
c  |  |  |  N:
               IFBCHA (1,IPOSFB) = IN
c  |  |  |  Z:
               IFBCHA (2,IPOSFB) = IZ
c  |  |  |  First fragment id:
               IFBCHA (3,IPOSFB) = IF1HLP (IB)
c  |  |  |  Second (possibly composite) fragment id:
               IFBCHA (4,IPOSFB) = IF2HLP (IB)
c  |  |  |  Multiplicity:
               IFBCHA (5,IPOSFB) = MULHLP (IB)
c  |  |  |  Spin/degeneracy/mass factor:
               SDMFBK (IPOSFB)   = FCSPIN / FCIDEN * FCVOLU
     &                           * ( FCMASS / TOTMAS )**1.5D+00
     &                           * TWOPIP**E32NM1 / FGAMMA (NGAMMA)
c  |  |  |  Coulomb barrier:
               COUFBK (IPOSFB)   = FCCOU0 * FCCOUL
c  |  |  |  Total mass excess (atomic or nuclear depending on option):
               EXFRBK (IPOSFB)   = QBRHLP (IB)
 6000       CONTINUE
c  |  |  |
c  |  |  +-------------------------------------------------------------*
            IF ( NACTUA .GT. 0 .AND. ( NACTUA .NE. IFBIND(IN,IZ,2)
     &         - IFBIND (IN,IZ,1) + 1 ) ) STOP 'STOP:FRBKIN-NACTUA'
            IF ( LPRINT ) WRITE (ErrorOut,*)
     &   '   ',NACTUA,' BREAK-UP COMBINATIONS FOUND FOR A:',IA,' Z:',IZ
            IF ( LPRINT ) WRITE (ErrorOut,*)
     &   '   ( EXCESS MASS:',SNGL (DT_ENERGY(ATAR,ZTAR)),' MEV )'
            IF ( NACTUA .LE. 0 ) GO TO 7000
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Try to order in increasing Q (with the Coulomb barrier
c  |  |  |  included/excluded):
            DO 6200 IB = 1, NACTUA
               JPOSFB        = IB + IFBIND (IN,IZ,1) - 1
c  |  |  |  Coulomb barrier included:
c              QBRHLP (IB)   = EXFRBK (JPOSFB) + COUFBK (JPOSFB)
c  |  |  |  Coulomb barrier excluded:
               QBRHLP (IB)   = EXFRBK (JPOSFB)
               SAVHLP (1,IB) = COUFBK (JPOSFB)
               SAVHLP (2,IB) = SDMFBK (JPOSFB)
c  |  |  |  Multiplicity:
               MULHLP (IB)   = IFBCHA (5,JPOSFB)
c  |  |  |  First fragment id:
               IF1HLP (IB)   = IFBCHA (3,JPOSFB)
c  |  |  |  Second (possibly composite) fragment id:
               IF2HLP (IB)   = IFBCHA (4,JPOSFB)
 6200       CONTINUE
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  Make the ordering:
            CALL DT_RORDIN( QBRHLP, ICHELP, NACTUA )
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Complete the reordering:
            DO 6400 IB = 1, NACTUA
               IF ( IB .GT. 1 ) THEN
                  IF ( QBRHLP (IB) .LT. QBRHLP (IB-1) )
     &               STOP 'STOP:FRBKIN-QBRHLP-ORDER'
               END IF
               IBOLD             = ICHELP (IB)
               JPOSFB            = IB    + IFBIND (IN,IZ,1) - 1
               JPOSLD            = IBOLD + IFBIND (IN,IZ,1) - 1
c  |  |  |  N:
               IFBCHA (1,JPOSFB) = IN
c  |  |  |  Z:
               IFBCHA (2,JPOSFB) = IZ
c  |  |  |  First fragment id:
               IFBCHA (3,JPOSFB) = IF1HLP (IBOLD)
c  |  |  |  Second (possibly composite) fragment id:
               IFBCHA (4,JPOSFB) = IF2HLP (IBOLD)
c  |  |  |  Multiplicity:
               IFBCHA (5,JPOSFB) = MULHLP (IBOLD)
               COUFBK (JPOSFB)   = SAVHLP (1,IBOLD)
               SDMFBK (JPOSFB)   = SAVHLP (2,IBOLD)
c  |  |  |  Please note Qbrhlp is already ordered (--> Ib not Ibold)
c  |  |  |  Coulomb barrier included:
c              EXFRBK (JPOSFB)   = QBRHLP (IB) - COUFBK (JPOSFB)
c  |  |  |  Coulomb barrier excluded:
               EXFRBK (JPOSFB)   = QBRHLP (IB)
 6400       CONTINUE
c  |  |  |
c  |  |  +-------------------------------------------------------------*
            IF ( LPRINT ) WRITE (ErrorOut,*)
     &   '   (LAST Q VALUES:',(SNGL(EXFRBK(IFBIND (IN,IZ,1)+JJ)),
     &        JJ=MAX(0,NACTUA-3),NACTUA-1),' MEV)'
 7000    CONTINUE
c  |  |
c  |  +----------------------------------------------------------------*
         JFBIND (IA) = IPOSFB
 8000 CONTINUE
c  |
c  +-------------------------------------------------------------------*
      IF ( LPRINT ) WRITE (ErrorOut,*)' Iposfb:',IPOSFB
c=== End of subroutine Frbkin =========================================*
      RETURN
      END
#endif
