#include "Zcondc.h"
#if USEDPMJET == 1
c
c===getbxs=============================================================*
c
CDECK  ID>, DT_GETBXS
      SUBROUTINE DT_GETBXS(XSFRAC,BLO,BHI,NIDX)

c***********************************************************************
c Biasing in impact parameter space.                                   *
c     XSFRAC = 0 :  BLO    - minimum impact parameter  (input)         *
c                   BHI    - maximum impact parameter  (input)         *
c                   XSFRAC - fraction of cross section corresponding   *
c                            to impact parameter range (BLO,BHI)       *
c                                                      (output)        *
c     XSFRAC > 0 :  XSFRAC - fraction of cross section (input)         *
c                   BHI    - maximum impact parameter giving requested *
c                            fraction of cross section in impact       *
c                            parameter range (0,BMAX)  (output)        *
c This version dated 17.03.00  is written by S. Roesler                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB


      NTARG = ABS(NIDX)
      IF (XSFRAC.LE.0.0D0) THEN
         ILO    = MIN(NSITEB-1,INT(BLO/BSTEP(NTARG)))
         IHI    = MIN(NSITEB-1,INT(BHI/BSTEP(NTARG)))
         IF (ILO.GE.IHI) THEN
            XSFRAC = 0.0D0
            RETURN
         ENDIF
         IF (ILO.EQ.NSITEB-1) THEN
            FRCLO = BSITE(0,1,NTARG,NSITEB)
         ELSE
            FRCLO = BSITE(0,1,NTARG,ILO+1)
     &              +(BLO-ILO*BSTEP(NTARG))/BSTEP(NTARG)
     &              *(BSITE(0,1,NTARG,ILO+2)-BSITE(0,1,NTARG,ILO+1))
         ENDIF
         IF (IHI.EQ.NSITEB-1) THEN
            FRCHI = BSITE(0,1,NTARG,NSITEB)
         ELSE
            FRCHI = BSITE(0,1,NTARG,IHI+1)
     &              +(BHI-IHI*BSTEP(NTARG))/BSTEP(NTARG)
     &              *(BSITE(0,1,NTARG,IHI+2)-BSITE(0,1,NTARG,IHI+1))
         ENDIF
         XSFRAC = FRCHI-FRCLO
      ELSE
         BLO = 0.0D0
         BHI = BMAX(NTARG)
         DO 1 I=1,NSITEB-1
            IF (XSFRAC.LT.BSITE(0,1,NTARG,I+1)) THEN
               FAC = (XSFRAC              -BSITE(0,1,NTARG,I))/
     &               (BSITE(0,1,NTARG,I+1)-BSITE(0,1,NTARG,I))
               BHI = DBLE(I-1)*BSTEP(NTARG)+BSTEP(NTARG)*FAC
               GOTO 2
            ENDIF
    1    CONTINUE
    2    CONTINUE
      ENDIF

      RETURN
      END
c
c===conucl=============================================================*
c
CDECK  ID>, DT_CONUCL
      SUBROUTINE DT_CONUCL(X,N,R,MODE)

c***********************************************************************
c Calculation of coordinates of nucleons within nuclei.                *
c        X(3,N)   spatial coordinates of nucleons (in fm)  (output)    *
c        N / R    number of nucleons / radius of nucleus   (input)     *
c        MODE = 0 coordinates not sorted                               *
c             = 1 coordinates sorted with increasing X(3,i)            *
c             = 2 coordinates sorted with decreasing X(3,i)            *
c This version dated 26.10.95 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,THREE=3.0D0,
     &           ONETHI=ONE/THREE,SQRTWO=1.414213562D0)

      PARAMETER (TWOPI = 6.283185307179586454D+00 )

      PARAMETER (NSRT=10)
      DIMENSION IDXSRT(NSRT,200),ICSRT(NSRT)
      DIMENSION X(3,N),XTMP(3,220)

      CALL DT_COORDI(XTMP,IDXSRT,ICSRT,N,R)

      IF ((MODE.NE.0).AND.((N.EQ.3).OR.(N.GT.4))) THEN
         K = 0
         DO 1 I=1,NSRT
            IF (MODE.EQ.2) THEN
               ISRT = NSRT+1-I
            ELSE
               ISRT = I
            ENDIF
            K1 = K
            DO 2 J=1,ICSRT(ISRT)
               K = K+1
               X(1,K) = XTMP(1,IDXSRT(ISRT,J))
               X(2,K) = XTMP(2,IDXSRT(ISRT,J))
               X(3,K) = XTMP(3,IDXSRT(ISRT,J))
    2       CONTINUE
            IF (ICSRT(ISRT).GT.1) THEN
               I0 = K1+1
               I1 = K
               CALL DT_SORT(X,N,I0,I1,MODE)
            ENDIF
    1    CONTINUE
      ELSEIF ((MODE.NE.0).AND.((N.EQ.2).OR.(N.EQ.4))) THEN
         DO 3 I=1,N
            X(1,I) = XTMP(1,I)
            X(2,I) = XTMP(2,I)
            X(3,I) = XTMP(3,I)
    3    CONTINUE
         CALL DT_SORT(X,N,1,N,MODE)
      ELSE
         DO 4 I=1,N
            X(1,I) = XTMP(1,I)
            X(2,I) = XTMP(2,I)
            X(3,I) = XTMP(3,I)
    4    CONTINUE
      ENDIF

      RETURN
      END
c
c===coordi=============================================================*
c
CDECK  ID>, DT_COORDI
      SUBROUTINE DT_COORDI(X,IDXSRT,ICSRT,N,R)

c***********************************************************************
c Calculation of coordinates of nucleons within nuclei.                *
c        X(3,N)   spatial coordinates of nucleons (in fm)  (output)    *
c        N / R    number of nucleons / radius of nucleus   (input)     *
c Based on the original version by Shmakov et al.                      *
c This version dated 26.10.95 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,THREE=3.0D0,
     &           ONETHI=ONE/THREE,SQRTWO=1.414213562D0)

      PARAMETER (TWOPI = 6.283185307179586454D+00 )

      LOGICAL LSTART

      PARAMETER (NSRT=10)
      DIMENSION IDXSRT(NSRT,200),ICSRT(NSRT)
      DIMENSION X(3,220),WD(4),RD(3)

      DATA PDIF/0.545D0/,R2MIN/0.16D0/
      DATA WD / 0.0D0, 0.178D0, 0.465D0, 1.0D0/
      DATA RD /2.09D0, 0.935D0, 0.697D0/

      X1SUM = ZERO
      X2SUM = ZERO
      X3SUM = ZERO

      IF (N.EQ.1) THEN
         X(1,1) = ZERO
         X(2,1) = ZERO
         X(3,1) = ZERO
      ELSEIF (N.EQ.2) THEN
         EPS = DT_RNDM(RD(1))
         DO 30 I=1,3
            IF ((EPS.GE.WD(I)).AND.(EPS.LE.WD(I+1))) GOTO 40
   30    CONTINUE
   40    CONTINUE
         DO 50 J=1,3
            CALL DT_RANNOR(X1,X2)
            X(J,1) = RD(I)*X1
            X(J,2) = -X(J,1)
   50    CONTINUE
      ELSEIF ((N.EQ.3).OR.(N.EQ.4)) THEN
         SIGMA = R/SQRTWO
         LSTART = .TRUE.
         CALL DT_RANNOR(X3,X4)
         DO 100 I=1,N
            CALL DT_RANNOR(X1,X2)
            X(1,I) = SIGMA*X1
            X(2,I) = SIGMA*X2
            IF (LSTART) GOTO 80
            X(3,I) = SIGMA*X4
            CALL DT_RANNOR(X3,X4)
            GOTO 90
   80       CONTINUE
            X(3,I) = SIGMA*X3
   90       CONTINUE
            LSTART = .NOT.LSTART
            X1SUM = X1SUM+X(1,I)
            X2SUM = X2SUM+X(2,I)
            X3SUM = X3SUM+X(3,I)
  100    CONTINUE
         X1SUM = X1SUM/DBLE(N)
         X2SUM = X2SUM/DBLE(N)
         X3SUM = X3SUM/DBLE(N)
         DO 101 I=1,N
            X(1,I) = X(1,I)-X1SUM
            X(2,I) = X(2,I)-X2SUM
            X(3,I) = X(3,I)-X3SUM
  101    CONTINUE
      ELSE

c maximum nuclear radius for coordinate sampling
         RMAX = R+4.605D0*PDIF

c initialize pre-sorting
         DO 121 I=1,NSRT
            ICSRT(I) = 0
  121    CONTINUE
         DR = TWO*RMAX/DBLE(NSRT)

c sample coordinates for N nucleons
         DO 140 I=1,N
  120       CONTINUE
            RAD = RMAX*(DT_RNDM(DR))**ONETHI
            F   = DT_DENSIT(N,RAD,R)
            IF (DT_RNDM(RAD).GT.F) GOTO 120
c   theta, phi uniformly distributed
            CT  = ONE-TWO*DT_RNDM(F)
            ST  = SQRT((ONE-CT)*(ONE+CT))
            CALL DT_DSFECF(SFE,CFE)
            X(1,I) = RAD*ST*CFE
            X(2,I) = RAD*ST*SFE
            X(3,I) = RAD*CT
c   ensure that distance between two nucleons is greater than R2MIN
            IF (I.LT.2) GOTO 122
            I1 = I-1
            DO 130 I2=1,I1
               DIST2 = (X(1,I)-X(1,I2))**2+(X(2,I)-X(2,I2))**2+
     &                 (X(3,I)-X(3,I2))**2
               IF (DIST2.LE.R2MIN) GOTO 120
  130       CONTINUE
  122       CONTINUE
c   save index according to z-bin
            IDXZ        = INT( (X(3,I)+RMAX)/DR )+1
            ICSRT(IDXZ) = ICSRT(IDXZ)+1
            IDXSRT(IDXZ,ICSRT(IDXZ)) = I
            X1SUM = X1SUM+X(1,I)
            X2SUM = X2SUM+X(2,I)
            X3SUM = X3SUM+X(3,I)
  140    CONTINUE
         X1SUM = X1SUM/DBLE(N)
         X2SUM = X2SUM/DBLE(N)
         X3SUM = X3SUM/DBLE(N)
         DO 141 I=1,N
            X(1,I) = X(1,I)-X1SUM
            X(2,I) = X(2,I)-X2SUM
            X(3,I) = X(3,I)-X3SUM
  141    CONTINUE

      ENDIF

      RETURN
      END
c
c===densit=============================================================*
c
CDECK  ID>, DT_DENSIT
      DOUBLE PRECISION FUNCTION DT_DENSIT(NA,R,RA)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0)
      PARAMETER (TWOPI = 6.283185307179586476925286766559D+00,
     &           PI    = TWOPI/TWO)

      DIMENSION R0(18),FNORM(18)
      DATA R0 /  ZERO,   ZERO,   ZERO,   ZERO, 2.12D0,
     &         2.56D0, 2.41D0, 2.46D0, 2.52D0, 2.45D0,
     &         2.37D0, 2.46D0, 2.44D0, 2.54D0, 2.58D0,
     &         2.72D0, 2.66D0, 2.79D0/
      DATA FNORM /.1000D+01,.1000D+01,.1000D+01,.1000D+01,.1000D+01,
     &            .1000D+01,.1000D+01,.1000D+01,.1000D+01,.1000D+01,
     &            .1012D+01,.1039D+01,.1075D+01,.1118D+01,.1164D+01,
     &            .1214D+01,.1265D+01,.1318D+01/
      DATA PDIF /0.545D0/

      DT_DENSIT = ZERO
c shell model
      IF (NA.LE.4) THEN
         STOP 'DT_DENSIT-0'
      ELSEIF ((NA.GT.4).AND.(NA.LE.18)) THEN
         R1 = R0(NA)/SQRT(2.5D0-4.0D0/DBLE(NA))
         DT_DENSIT = (ONE+(DBLE(NA)-4.0D0)/6.0D0*(R/R1)**2)
     &            *EXP(-(R/R1)**2)/FNORM(NA)
c Woods-Saxon
      ELSEIF (NA.GT.18) THEN
         DT_DENSIT = ONE/(ONE+EXP((R-RA)/PDIF))
      ENDIF

      RETURN
      END
c
c===rnclus=============================================================*
c
CDECK  ID>, DT_RNCLUS
      DOUBLE PRECISION FUNCTION DT_RNCLUS(N)

c***********************************************************************
c Nuclear radius for nucleus with mass number N.                       *
c This version dated 26.9.00  is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (ONE=1.0D0,THREE=3.0D0,ONETHI=ONE/THREE)

c nucleon radius
      PARAMETER (RNUCLE = 1.12D0)

c nuclear radii for selected nuclei
      DIMENSION RADNUC(18)
      DATA RADNUC / 8*0.0D0,2.52D0,2.45D0,2.37D0,2.45D0,2.44D0,2.55D0,
     &               2.58D0,2.71D0,2.66D0,2.71D0/

      IF (N.LE.18) THEN
         IF (RADNUC(N).GT.0.0D0) THEN
            DT_RNCLUS = RADNUC(N)
         ELSE
            DT_RNCLUS = RNUCLE*DBLE(N)**ONETHI
         ENDIF
      ELSE
         DT_RNCLUS = RNUCLE*DBLE(N)**ONETHI
      ENDIF

      RETURN
      END
c
c===dentst=============================================================*
c
C      PROGRAM DT_DENTST
CDECK  ID>, DT_DENTST
      SUBROUTINE DT_DENTST

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      OPEN(40,FILE='DENTST.OUT',STATUS='UNKNOWN')
      OPEN(41,FILE='DENMAX.OUT',STATUS='UNKNOWN')

      RMIN  = 0.0D0
      RMAX  = 8.0D0
      NBINS = 500.0D0
      DR    = (RMAX-RMIN)/DBLE(NBINS)
      DO 1 IA=5,18
         FMAX = 0.0D0
         DO 2 IR=1,NBINS+1
            R = RMIN+DBLE(IR-1)*DR
            F = DT_DENSIT(IA,R,R)
            IF (F.GT.FMAX) FMAX = F
            WRITE(40,'(1X,I3,2E15.5)') IA,R,F
    2    CONTINUE
         WRITE(41,'(1X,I3,E15.5)') IA,FMAX
    1 CONTINUE

      CLOSE(40)
      CLOSE(41)

      END
c
c===shmaki=============================================================*
c
CDECK  ID>, DT_SHMAKI
      SUBROUTINE DT_SHMAKI(NA,NCA,NB,NCB,IJP,PPN,MODE)

c***********************************************************************
c Initialisation of Glauber formalism. This subroutine has to be       *
c called once (in case of target emulsions as often as many different  *
c target nuclei are considered) before events are sampled.             *
c         NA / NCA   mass number/charge of projectile nucleus          *
c         NB / NCB   mass number/charge of target     nucleus          *
c         IJP        identity of projectile (hadrons/leptons/photons)  *
c         PPN        projectile momentum (for projectile nuclei:       *
c                    momentum per nucleon) in target rest system       *
c         MODE = 0   Glauber formalism invoked                         *
c              = 1   fitted results are loaded from data-file          *
c              = 99  NTARG is forced to be 1                           *
c                    (used in connection with GLAUBERI-card only)      *
c This version dated 22.03.96 is based on the original SHMAKI-routine  *
c and revised by S. Roesler.                                           *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0,
     &           THREE=3.0D0)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c kinematical cuts for lepton-nucleus interactions
      COMMON /DTLCUT/ ECMIN,ECMAX,XBJMIN,ELMIN,EGMIN,EGMAX,YMIN,YMAX,
     &                Q2MIN,Q2MAX,THMIN,THMAX,Q2LI,Q2HI,ECMLI,ECMHI

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c cuts for variable energy runs
      COMMON /DTVARE/ VARELO,VAREHI,VARCLO,VARCHI

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD


      DATA NTARG,ICOUT,IVEOUT /0,0,0/

C     CALL DT_HISHAD
C     STOP

      NTARG = NTARG+1
      IF (MODE.EQ.99) NTARG = 1
      NIDX = -NTARG
      IF (MODE.EQ.-1) NIDX = NTARG

      IF ((ICOUT.LT.15).AND.(MCGENE.NE.4)) ICOUT = ICOUT+1
      IF (ICOUT.EQ.1) WRITE(ErrorOut,1000)
 1000    FORMAT(//,1X,'SHMAKI:    GLAUBER FORMALISM (SHMAKOV ET. AL) -',
     &          ' INITIALIZATION',/,12X,'--------------------------',
     &          '-------------------------',/)

      IF (MODE.EQ.2) THEN
         CALL DT_XSGLAU(NA,NB,IJP,ZERO,VIRT,UMO,1,1,NIDX)
         CALL DT_SHFAST(MODE,PPN,IBACK)
         STOP ' GLAUBER PRE-INITIALIZATION DONE'
      ENDIF
      IF (MODE.EQ.1) THEN
         CALL DT_PROFBI(NA,NB,PPN,NTARG)
      ELSE
         IBACK = 1
         IF (MODE.EQ.3)  CALL DT_SHFAST(MODE,PPN,IBACK)
         IF (IBACK.EQ.1) THEN
c lepton-nucleus (variable energy runs)
            IF ((IJP.EQ. 3).OR.(IJP.EQ. 4).OR.
     &          (IJP.EQ.10).OR.(IJP.EQ.11))   THEN
               IF ((ICOUT.LT.15).AND.(MCGENE.NE.4))
     &            WRITE(ErrorOut,1002) NB,NCB
 1002          FORMAT(1X,'VARIABLE ENERGY RUN:     PROJECTILE-ID:  7',
     &                '    TARGET A/Z: ',I3,' /',I3,/,/,8X,
     &                'E_CM (GEV)    Q^2 (GEV^2)',
     &                '    SIGMA_TOT (MB)     SIGMA_IN (MB)',/,7X,
     &                '--------------------------------',
     &                '------------------------------')
               AECMLO = LOG10(MIN(UMO,ECMLI))
               AECMHI = LOG10(MIN(UMO,ECMHI))
               IESTEP = NEB-1
               DAECM  = (AECMHI-AECMLO)/DBLE(IESTEP)
               IF (AECMLO.EQ.AECMHI) IESTEP = 0
               DO 1 I=1,IESTEP+1
                  ECM = 10.0D0**(AECMLO+DBLE(I-1)*DAECM)
                  IF (Q2HI.GT.0.1D0) THEN
                     IF (Q2LI.LT.0.01D0) THEN
                        CALL DT_XSGLAU(NA,NB,7,ZERO,ZERO,ECM,I,1,NIDX)
                        IF ((ICOUT.LT.15).AND.(MCGENE.NE.4))
     &                     WRITE(ErrorOut,1003)
     &                  ECMNN(I),ZERO,XSTOT(I,1,NTARG),XSPRO(I,1,NTARG)
                        Q2LI = 0.01D0
                        IBIN = 2
                     ELSE
                        IBIN = 1
                     ENDIF
                     IQSTEP = NQB-IBIN
                     AQ2LO  = LOG10(Q2LI)
                     AQ2HI  = LOG10(Q2HI)
                     DAQ2   = (AQ2HI-AQ2LO)/MAX(DBLE(IQSTEP),ONE)
                     DO 2 J=IBIN,IQSTEP+IBIN
                        Q2 = 10.0D0**(AQ2LO+DBLE(J-IBIN)*DAQ2)
                        CALL DT_XSGLAU(NA,NB,7,ZERO,Q2,ECM,I,J,NIDX)
                        IF ((ICOUT.LT.15).AND.(MCGENE.NE.4))
     &                     WRITE(ErrorOut,1003) ECMNN(I),
     &                     Q2G(J),XSTOT(I,J,NTARG),XSPRO(I,J,NTARG)
    2                CONTINUE
                  ELSE
                     CALL DT_XSGLAU(NA,NB,7,ZERO,ZERO,ECM,I,1,NIDX)
                     IF ((ICOUT.LT.15).AND.(MCGENE.NE.4))
     &                  WRITE(ErrorOut,1003)
     &                  ECMNN(I),ZERO,XSTOT(I,1,NTARG),XSPRO(I,1,NTARG)
                  ENDIF
 1003             FORMAT(9X,F6.1,9X,F6.2,8X,F8.3,11X,F8.3)
    1          CONTINUE
               IVEOUT = 1
            ELSE
c hadron/photon/nucleus-nucleus
               IF ((ABS(VAREHI).GT.ZERO).AND.
     &             (ABS(VAREHI).GT.ABS(VARELO))) THEN
                  IF ((ICOUT.LT.15).AND.(MCGENE.NE.4)) THEN
                     WRITE(ErrorOut,1004) NA,NB,NCB
 1004                FORMAT(1X,'VARIABLE ENERGY RUN:    PROJECTILE-ID:',
     &                      I3,'    TARGET A/Z: ',I3,' /',I3,/)
                     WRITE(ErrorOut,1005)
 1005                FORMAT('  E_CM (GEV)  E_LAB (GEV)  SIG_TOT^PP (MB)'
     &                      ,'  SIGMA_TOT (MB)  SIGMA_PROD (MB)',/,
     &                      ' -------------------------------------',
     &                      '--------------------------------------')
                  ENDIF
                  AECMLO = LOG10(VARCLO)
                  AECMHI = LOG10(VARCHI)
                  IESTEP = NEB-1
                  DAECM = (AECMHI-AECMLO)/DBLE(IESTEP)
                  IF (AECMLO.EQ.AECMHI) IESTEP = 0
                  DO 3 I=1,IESTEP+1
                     ECM = 10.0D0**(AECMLO+DBLE(I-1)*DAECM)
                     AMP = 0.938D0
                     AMT = 0.938D0
                     AMP2 = AMP**2
                     AMT2 = AMT**2
                     ELAB = (ECM**2-AMP2-AMT2)/(TWO*AMT)
                     PLAB = SQRT((ELAB+AMP)*(ELAB-AMP))
                     CALL DT_XSGLAU(NA,NB,IJP,ZERO,VIRT,ECM,I,1,NIDX)
                     IF ((ICOUT.LT.15).AND.(MCGENE.NE.4))
     &                 WRITE(ErrorOut,1006)
     &                 ECM,PLAB,SIGSH,XSTOT(I,1,NTARG),XSPRO(I,1,NTARG)
 1006             FORMAT(1X,F9.1,1X,E11.3,1X,F12.2,8X,F10.3,8X,F8.3)
    3             CONTINUE
                  IVEOUT = 1
               ELSE
                  CALL DT_XSGLAU(NA,NB,IJP,ZERO,VIRT,UMO,1,1,NIDX)
               ENDIF
            ENDIF
         ENDIF
      ENDIF

      IF ((ICOUT.LT.15).AND.(IVEOUT.EQ.0).AND.(MCGENE.NE.4).AND.
     &    (IOGLB.NE.100)) THEN
         WRITE(ErrorOut,
     * 1001) NA,NCA,NB,NCB,ECMNN(1),SIGSH*10.0D0,ROSH,
     &                    BSLOPE,NSITEB,NSTATB,XSPRO(1,1,NTARG)
 1001    FORMAT(38X,'PROJECTILE',
     &          '      TARGET',/,1X,'MASS NUMBER / CHARGE',
     &          17X,I3,' /',I3,6X,I3,' /',I3,/,/,1X,
     &          'NUCLEON-NUCLEON C.M. ENERGY',9X,F10.2,' GEV',/,/,1X,
     &          'PARAMETERS OF ELASTIC SCATTERING AMPLITUDE:',/,5X,
     &          'SIGMA =',F7.2,' MB',6X,'RHO = ',F9.4,6X,'SLOPE = ',
     &          F4.1,' GEV^-2',/,/,1X,'NUMBER OF B-STEPS',4X,I3,8X,
     &          'STATISTICS AT EACH B-STEP',4X,I5,/,/,1X,
     &          'PROD. CROSS SECTION  ',5X,F10.4,' MB',/)
      ENDIF

      RETURN
      END
c
c===profbi=============================================================*
c
CDECK  ID>, DT_PROFBI
      SUBROUTINE DT_PROFBI(NA,NB,PPN,NTARG)

c***********************************************************************
c Integral over profile function (to be used for impact-parameter      *
c sampling during event generation).                                   *
c Fitted results are used.                                             *
c         NA / NB    mass numbers of proj./target nuclei               *
c         PPN        projectile momentum (for projectile nuclei:       *
c                    momentum per nucleon) in target rest system       *
c         NTARG      index of target material (i.e. kind of nucleus)   *
c This version dated 31.05.95 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      SAVE

      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,THREE=3.0D0)

      LOGICAL LSTART
      CHARACTER CNAME*80

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI


      PARAMETER (NGLMAX=8000)
      DIMENSION NGLIT(NGLMAX),NGLIP(NGLMAX),GLAPPN(NGLMAX),
     &          GLASIG(NGLMAX),GLAFIT(5,NGLMAX)

      DATA LSTART /.TRUE./

      IF (LSTART) THEN
c read fit-parameters from file
         OPEN(47,FILE='INPDATA/GLPARA.DAT',STATUS='UNKNOWN')
         I = 0
    1    CONTINUE
         READ(47,'(A80)') CNAME
         IF (CNAME.EQ.'STOP') GOTO 2
         I = I+1
         READ(CNAME,*) NGLIP(I),NGLIT(I),GLAPPN(I),GLASIG(I),
     &                 GLAFIT(1,I),GLAFIT(2,I),GLAFIT(3,I),
     &                 GLAFIT(4,I),GLAFIT(5,I)
         IF (I+1.GT.NGLMAX) THEN
            WRITE(ErrorOut,1000)
 1000       FORMAT(1X,'PROFBI:    WARNING! ARRAY SIZE EXCEEDED - ',
     &             'PROGRAM STOPPED')
            STOP
         ENDIF
         GOTO 1
    2    CONTINUE
         NGLPAR = I
         LSTART = .FALSE.
      ENDIF

      NNA = NA
      NNB = NB
      IF (NA.GT.NB) THEN
         NNA = NB
         NNB = NA
      ENDIF
      IDXGLA = 0
      DO 3 J=1,NGLPAR
         IF ((NNB.LT.NGLIT(J)).OR.(J.EQ.NGLPAR)) THEN
            IF (NNB.NE.NGLIT(J-1)) NNB = NGLIT(J-1)
            DO 4 K=1,J-1
               IPOINT = J-K
               IF (J.EQ.NGLPAR) IPOINT = J+1-K
               IF ((NNA.GT.NGLIP(IPOINT)).OR.
     &             (NNB.NE.NGLIT(IPOINT)).OR.(IPOINT.EQ.1)) THEN
                  IF (IPOINT.EQ.1) IPOINT = 0
                  NATMP = NGLIP(IPOINT+1)
                  IF (PPN.LT.GLAPPN(IPOINT+1)) THEN
                     IDXGLA = IPOINT+1
                     GOTO 6
                  ELSE
                     J1BEG = IPOINT+1
                     J1END = J
C                    IF (J.EQ.NGLPAR) THEN
C                       J1BEG = IPOINT
C                       J1END = J
C                    ENDIF
                     DO 5 J1=J1BEG,J1END
                        IF (NGLIP(J1).EQ.NATMP) THEN
                           IF (PPN.LT.GLAPPN(J1)) THEN
                              IDXGLA = J1
                              GOTO 6
                           ENDIF
                        ELSE
                           IDXGLA = J1-1
                           GOTO 6
                        ENDIF
    5                CONTINUE
                     IF ((J.EQ.NGLPAR).AND.(PPN.GT.GLAPPN(NGLPAR)))
     &                  IDXGLA = NGLPAR
                  ENDIF
               ENDIF
    4       CONTINUE
         ENDIF
    3 CONTINUE

    6 CONTINUE
      IF (IDXGLA.EQ.0) THEN
         WRITE(ErrorOut,1001) NNA,NNB,PPN
 1001    FORMAT(1X,'PROFBI:   CONFIGURATION (NA,NB,PPN = ',
     &          2I4,F6.0,') NOT FOUND ')
         STOP
      ENDIF

c no interpolation yet available
      XSPRO(1,1,NTARG) = GLASIG(IDXGLA)

      BSITE(1,1,NTARG,1) = ZERO
      DO 10 I=2,NSITEB
         XX = DBLE(I)
         POLY  = GLAFIT(1,IDXGLA)+GLAFIT(2,IDXGLA)*XX+
     &           GLAFIT(3,IDXGLA)*XX**2+GLAFIT(4,IDXGLA)*XX**3+
     &           GLAFIT(5,IDXGLA)*XX**4
         IF (ABS(POLY).GT.35.0D0) POLY = SIGN(35.0D0,POLY)
         BSITE(1,1,NTARG,I) = (1.0D0-EXP(-POLY))
         IF (BSITE(1,1,NTARG,I).LT.ZERO) BSITE(1,1,NTARG,I) = ZERO
   10 CONTINUE

      RETURN
      END
c
c===glaube=============================================================*
c
CDECK  ID>, DT_GLAUBE
      SUBROUTINE DT_GLAUBE(NA,NB,IJPROJ,B,INTT,INTA,INTB,JS,JT,NIDX)

c***********************************************************************
c Calculation of configuartion of interacting nucleons for one event.  *
c    NB / NB    mass numbers of proj./target nuclei           (input)  *
c    B          impact parameter                              (output) *
c    INTT       total number of wounded nucleons                       *
c    INTA / INTB number of wounded nucleons in proj. / target          *
c    JS / JT(i) number of collisions proj. / target nucleon i is       *
c                                                   involved  (output) *
c    NIDX       index of projectile/target material             (input)*
c This is an update of the original routine SHMAKO by J.Ranft/HJM      *
c This version dated 22.03.96 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY14=1.0D-14,
     &           ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD


      DIMENSION JS(MAXNCL),JT(MAXNCL)

      NTARG = ABS(NIDX)

c get actual energy from /DTLTRA/
      ECMNOW = UMO
      Q2     = VIRT
c
c new patch for pre-initialized variable projectile/target/energy runs
      IF (IOGLB.EQ.100) THEN
         CALL DT_GLBSET(IJPROJ,NA,NB,EPROJ,1)
c
c variable energy run, interpolate profile function
      ELSE
         I1   = 1
         I2   = 1
         RATE = ONE
         IF (NEBINI.GT.1) THEN
            IF (ECMNOW.GE.ECMNN(NEBINI)) THEN
               I1   = NEBINI
               I2   = NEBINI
               RATE = ONE
            ELSEIF (ECMNOW.GT.ECMNN(1)) THEN
               DO 1 I=2,NEBINI
                  IF (ECMNOW.LT.ECMNN(I)) THEN
                     I1   = I-1
                     I2   = I
                     RATE = (ECMNOW-ECMNN(I1))/(ECMNN(I2)-ECMNN(I1))
                     GOTO 2
                  ENDIF
    1          CONTINUE
    2          CONTINUE
            ENDIF
         ENDIF
         J1   = 1
         J2   = 1
         RATQ = ONE
         IF (NQBINI.GT.1) THEN
            IF (Q2.GE.Q2G(NQBINI)) THEN
               J1   = NQBINI
               J2   = NQBINI
               RATQ = ONE
            ELSEIF (Q2.GT.Q2G(1)) THEN
               DO 3 I=2,NQBINI
                  IF (Q2.LT.Q2G(I)) THEN
                     J1   = I-1
                     J2   = I
                     RATQ = LOG10(     Q2/MAX(Q2G(J1),TINY14))/
     &                      LOG10(Q2G(J2)/MAX(Q2G(J1),TINY14))
C                    RATQ = (Q2-Q2G(J1))/(Q2G(J2)-Q2G(J1))
                     GOTO 4
                  ENDIF
    3          CONTINUE
    4          CONTINUE
            ENDIF
         ENDIF

         DO 5 I=1,KSITEB
            BSITE(0,1,NTARG,I) = BSITE(I1,J1,NTARG,I)+
     &         RATE*(BSITE(I2,J1,NTARG,I)-BSITE(I1,J1,NTARG,I))+
     &         RATQ*(BSITE(I1,J2,NTARG,I)-BSITE(I1,J1,NTARG,I))+
     &         RATE*RATQ*(BSITE(I2,J2,NTARG,I)-BSITE(I1,J2,NTARG,I)+
     &                    BSITE(I1,J1,NTARG,I)-BSITE(I2,J1,NTARG,I))
    5    CONTINUE
      ENDIF

      CALL DT_DIAGR(NA,NB,IJPROJ,B,JS,JT,INTT,INTA,INTB,IDIREC,NIDX)
      IF (NIDX.LE.-1) THEN
         RPROJ = RASH(1)
         RTARG = RBSH(NTARG)
      ELSE
         RPROJ = RASH(NTARG)
         RTARG = RBSH(1)
      ENDIF

      RETURN
      END
c
c===diagr==============================================================*
c
CDECK  ID>, DT_DIAGR
      SUBROUTINE DT_DIAGR(NA,NB,IJPROJ,B,JS,JT,JNT,INTA,INTB,IDIREC,
     &                                                         NIDX)

c***********************************************************************
c Based on the original version by Shmakov et al.                      *
c This version dated 21.04.95 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0)
      PARAMETER (TWOPI  = 6.283185307179586454D+00,
     &           PI     = TWOPI/TWO,
     &           GEV2MB = 0.38938D0,
     &           GEV2FM = 0.1972D0,
     &           ALPHEM = ONE/137.0D0,
c proton mass
     &           AMP    = 0.938D0,
     &           AMP2   = AMP**2,
c rho0 mass
     &           AMRHO0 = 0.77D0)

      COMPLEX*16 C,CA,CI

      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c*PHOJET105a
C     COMMON /CUTOFF/ PTCUT(4),CUTMU(4),FPS(4),FPH(4),PSOMIN,XSOMIN
c*PHOJET112
C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

c*
c coordinates of nucleons
      COMMON /DTNUCO/ PKOO(3,MAXNCL),TKOO(3,MAXNCL)

c interface between Glauber formalism and DPM
      COMMON /DTGLIF/ JSSH(MAXNCL),JTSH(MAXNCL),
     &                INTER1(MAXINT),INTER2(MAXINT)

c statistics: Glauber-formalism
      COMMON /DTSTA3/ ICWP,ICWT,NCSY,ICWPG,ICWTG,ICIG,IPGLB,ITGLB,NGLB

c n-n cross section fluctuations
      PARAMETER (NBINS = 1000)
      COMMON /DTXSFL/ FLUIXX(NBINS),IFLUCT


      DIMENSION JS(MAXNCL),JT(MAXNCL),
     &          JS0(MAXNCL),JT0(MAXNCL,MAXNCL),
     &          JI1(MAXNCL,MAXNCL),JI2(MAXNCL,MAXNCL),JNT0(MAXNCL)
      DIMENSION NWA(0:210),NWB(0:210)

      LOGICAL LFIRST
      DATA LFIRST /.TRUE./

      DATA NTARGO,ICNT /0,0/

      NTARG = ABS(NIDX)

      IF (LFIRST) THEN
         LFIRST = .FALSE.
         IF (NCOMPO.EQ.0) THEN
            NCALL  = 0
            NWAMAX = NA
            NWBMAX = NB
            DO 17 I=0,210
               NWA(I) = 0
               NWB(I) = 0
   17       CONTINUE
         ENDIF
      ENDIF
      IF (NTARG.EQ.-1) THEN
         IF (NCOMPO.EQ.0) THEN
            WRITE(ErrorOut,
     * *) ' DIAGR: distribution of wounded nucleons'
            WRITE(ErrorOut,
     * '(8X,A,3I7)') 'NCALL,NWAMAX,NWBMAX = ',
     &                                NCALL,NWAMAX,NWBMAX
            DO 18 I=1,MAX(NWAMAX,NWBMAX)
               WRITE(ErrorOut,'(8X,2I7,E12.4,I7,E12.4)')
     &                          I,NWA(I),DBLE(NWA(I))/DBLE(NCALL),
     &                            NWB(I),DBLE(NWB(I))/DBLE(NCALL)
   18       CONTINUE
         ENDIF
         RETURN
      ENDIF

      DCOH   = 1.0D10
      IPNT   = 0

      SQ2  = Q2
      IF (SQ2.LE.ZERO) SQ2 = 0.0001D0
      S   = ECMNOW**2
      X   = SQ2/(S+SQ2-AMP2)
      XNU = (S+SQ2-AMP2)/(TWO*AMP)
c photon projectiles: recalculate photon-nucleon amplitude
      IF (IJPROJ.EQ.7) THEN
   15    CONTINUE
c  VDM assumption: mass of V-meson
         AMV2   = DT_SAM2(SQ2,ECMNOW)
         AMV    = SQRT(AMV2)
         IF (AMV.GT.2.0D0*PTCUT(1)) GOTO 15
c  check for pointlike interaction
         CALL DT_POILIK(NB,NTARG,ECMNOW,SQ2,IPNT,RPNT,1)
c*sr 27.10.
C        SIGSH  = DT_SIGVP(X,SQ2)/(AMV2+SQ2+RL2)/10.0D0
         SIGSH  = (ONE-RPNT)*DT_SIGVP(X,SQ2)/(AMV2+SQ2+RL2)/10.0D0
c*
         ROSH   = 0.1D0
         BSLOPE = 2.0D0*(2.0D0+AMRHO0**2/(AMV2+SQ2)
     &                   +0.25D0*LOG(S/(AMV2+SQ2)))
c  coherence length
         IF (ISHAD(3).EQ.1) DCOH = TWO*XNU/(AMV2+SQ2)*GEV2FM
      ELSEIF ((IJPROJ.LE.12).AND.(IJPROJ.NE.7)) THEN
         IF (MCGENE.EQ.2) THEN
            ZERO1 = ZERO
            CALL DT_PHOXS(IJPROJ,1,ECMNOW,ZERO1,SDUM1,SDUM2,SDUM3,
     &                                                BSLOPE,0)
         ELSE
            BSLOPE = 8.5D0*(1.0D0+0.065D0*LOG(S))
         ENDIF
         IF (ECMNOW.LE.3.0D0) THEN
            ROSH = -0.43D0
         ELSEIF ((ECMNOW.GT.3.0D0).AND.(ECMNOW.LE.50.D0)) THEN
            ROSH = -0.63D0+0.175D0*LOG(ECMNOW)
         ELSEIF (ECMNOW.GT.50.0D0) THEN
            ROSH = 0.1D0
         ENDIF
         ELAB = (S-AAM(IJPROJ)**2-AMP2)/(TWO*AMP)
         PLAB = SQRT( (ELAB-AAM(IJPROJ))*(ELAB+AAM(IJPROJ)) )
         IF (MCGENE.EQ.2) THEN
            ZERO1 = ZERO
            CALL DT_PHOXS(IJPROJ,1,ECMNOW,ZERO1,SIGSH,SDUM2,SDUM3,
     &                                                  BDUM,0)
            SIGSH = SIGSH/10.0D0
         ELSE
C           SIGSH = DT_SHNTOT(IJPROJ,1,ZERO,PLAB)/10.0D0
            DUMZER = ZERO
            CALL DT_XSHN(IJPROJ,1,PLAB,DUMZER,SIGSH,SIGEL)
            SIGSH = SIGSH/10.0D0
         ENDIF
      ELSE
         BSLOPE = 6.0D0*(1.0D0+0.065D0*LOG(S))
         ROSH   = 0.01D0
         ELAB = (S-AAM(IJPROJ)**2-AMP2)/(TWO*AMP)
         PLAB = SQRT( (ELAB-AAM(IJPROJ))*(ELAB+AAM(IJPROJ)) )
C        SIGSH = DT_SHNTOT(IJPROJ,1,ZERO,PLAB)/10.0D0
         DUMZER = ZERO
         CALL DT_XSHN(IJPROJ,1,PLAB,DUMZER,SIGSH,SIGEL)
         SIGSH = SIGSH/10.0D0
      ENDIF
      GSH = 10.0D0/(TWO*BSLOPE*GEV2MB)
      GAM = GSH
      RCA = GAM*SIGSH/TWOPI
      FCA = -ROSH*RCA
      CA  = DCMPLX(RCA,FCA)
      CI  = DCMPLX(ONE,ZERO)

   16 CONTINUE
c impact parameter
      IF (MCGENE.NE.3) CALL DT_MODB(B,NIDX)

      NTRY = 0
    3 CONTINUE
      NTRY = NTRY+1
c initializations
      JNT  = 0
      DO 1 I=1,NA
         JS(I) = 0
    1 CONTINUE
      DO 2 I=1,NB
         JT(I) = 0
    2 CONTINUE
      IF (IJPROJ.EQ.7) THEN
         DO 8 I=1,MAXNCL
            JS0(I) = 0
            JNT0(I)= 0
            DO 9 J=1,NB
               JT0(I,J) = 0
    9       CONTINUE
    8    CONTINUE
      ENDIF

c nucleon configuration
C     IF ((NTARG.NE.NTARGO).OR.(MOD(ICNT,5).EQ.0)) THEN
      IF ((NTARG.NE.NTARGO).OR.(MOD(ICNT,1).EQ.0)) THEN
C        CALL DT_CONUCL(PKOO,NA,RASH,2)
C        CALL DT_CONUCL(TKOO,NB,RBSH(NTARG),1)
         IF (NIDX.LE.-1) THEN
            CALL DT_CONUCL(PKOO,NA,RASH(1),0)
            CALL DT_CONUCL(TKOO,NB,RBSH(NTARG),0)
         ELSE
            CALL DT_CONUCL(PKOO,NA,RASH(NTARG),0)
            CALL DT_CONUCL(TKOO,NB,RBSH(1),0)
         ENDIF
         NTARGO = NTARG
      ENDIF
      ICNT = ICNT+1

c LEPTO: pick out one struck nucleon
      IF (MCGENE.EQ.3) THEN
         JNT     = 1
         JS(1)   = 1
         IDX     = INT(DT_RNDM(X)*NB)+1
         JT(IDX) = 1
         B       = ZERO
         GOTO 19
      ENDIF

      DO 4 INA=1,NA
c cross section fluctuations
         AFLUC = ONE
         IF (IFLUCT.EQ.1) THEN
            IFLUK = INT((DT_RNDM(X)+0.001D0)*1000.0D0)
            AFLUC = FLUIXX(IFLUK)
         ENDIF
         KK1  = 1
         KINT = 1
         DO 5 INB=1,NB
c photon-projectile: check for supression by coherence length
            IF (IJPROJ.EQ.7) THEN
               IF (ABS(TKOO(3,INB)-TKOO(3,KK1)).GT.DCOH) THEN
                  KK1  = INB
                  KINT = KINT+1
               ENDIF
            ENDIF
            QQ1 = B+TKOO(1,INB)-PKOO(1,INA)
            QQ2 =   TKOO(2,INB)-PKOO(2,INA)
            XY  = GAM*(QQ1*QQ1+QQ2*QQ2)
            IF (XY.LE.15.0D0) THEN
               C  = CI-CA*AFLUC*EXP(-XY)
               AR = DBLE(C)
               AI = DIMAG(C)
               P  = AR*AR+AI*AI
               IF (DT_RNDM(XY).GE.P) THEN
                  JNT = JNT+1
                  IF (IJPROJ.EQ.7) THEN
                     JNT0(KINT) = JNT0(KINT)+1
                     IF (JNT0(KINT).GT.MAXNCL) THEN
                        WRITE(ErrorOut,1001) MAXNCL
 1001                   FORMAT(1X,
     &                        'DIAGR:  NO. OF REQUESTED INTERACTIONS',
     &                        ' EXCEEDS ARRAY DIMENSIONS ',I4)
                        STOP
                     ENDIF
                     JS0(KINT)      = JS0(KINT)+1
                     JT0(KINT,INB)  = JT0(KINT,INB)+1
                     JI1(KINT,JNT0(KINT)) = INA
                     JI2(KINT,JNT0(KINT)) = INB
                  ELSE
                     IF (JNT.GT.MAXINT) THEN
                        WRITE(ErrorOut,1000) JNT, MAXINT
 1000                   FORMAT(1X,
     &                        'DIAGR:  NO. OF REQUESTED INTERACTIONS ('
     &                        ,I4,') EXCEEDS ARRAY DIMENSIONS (',I4,')')
                        STOP
                     ENDIF
                     JS(INA) = JS(INA)+1
                     JT(INB) = JT(INB)+1
                     INTER1(JNT) = INA
                     INTER2(JNT) = INB
                  ENDIF
               ENDIF
            ENDIF
    5    CONTINUE
    4 CONTINUE

      IF (JNT.EQ.0) THEN
         IF (NTRY.LT.500) THEN
            GOTO 3
         ELSE
C           WRITE(6,*) ' new impact parameter required (old= ',B,')'
            GOTO 16
         ENDIF
      ENDIF

      IDIREC = 0
      IF (IJPROJ.EQ.7) THEN
         K = INT(ONE+DT_RNDM(X)*DBLE(KINT))
   10    CONTINUE
         IF (JNT0(K).EQ.0) THEN
            K = K+1
            IF (K.GT.KINT) K = 1
            GOTO 10
         ENDIF
c supress Glauber-cascade by direct photon processes
         CALL DT_POILIK(NB,NTARG,ECMNOW,SQ2,IPNT,RPNT,2)
         IF (IPNT.GT.0) THEN
            JNT   = 1
            JS(1) = 1
            DO 11 INB=1,NB
               JT(INB) = JT0(K,INB)
               IF (JT(INB).GT.0) GOTO 12
   11       CONTINUE
   12       CONTINUE
            INTER1(1) = 1
            INTER2(1) = INB
            IDIREC    = IPNT
         ELSE
            JNT   = JNT0(K)
            JS(1) = JS0(K)
            DO 13 INB=1,NB
               JT(INB) = JT0(K,INB)
   13       CONTINUE
            DO 14 I=1,JNT
               INTER1(I) = JI1(K,I)
               INTER2(I) = JI2(K,I)
   14       CONTINUE
         ENDIF
      ENDIF

   19 CONTINUE
      INTA = 0
      INTB = 0
      DO 6 I=1,NA
        IF (JS(I).NE.0) INTA=INTA+1
    6 CONTINUE
      DO 7 I=1,NB
        IF (JT(I).NE.0) INTB=INTB+1
    7 CONTINUE
      ICWPG = INTA
      ICWTG = INTB
      ICIG  = JNT
      IPGLB = IPGLB+INTA
      ITGLB = ITGLB+INTB
      NGLB = NGLB+1

      IF (NCOMPO.EQ.0) THEN
         NCALL = NCALL+1
         NWA(INTA) = NWA(INTA)+1
         NWB(INTB) = NWB(INTB)+1
      ENDIF

      RETURN
      END
c
c===modb===============================================================*
c
CDECK  ID>, DT_MODB
      SUBROUTINE DT_MODB(B,NIDX)

c***********************************************************************
c Sampling of impact parameter of collision.                           *
c    B          impact parameter    (output)                           *
c    NIDX       index of projectile/target material             (input)*
c Based on the original version by Shmakov et al.                      *
c This version dated 21.04.95 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY15=1.0D-15,ONE=1.0D0,TWO=2.0D0)

      LOGICAL LEFT,LFIRST

c central particle production, impact parameter biasing
      COMMON /DTIMPA/ BIMIN,BIMAX,XSFRAC,ICENTR

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI


      DATA LFIRST /.TRUE./

      NTARG = ABS(NIDX)
      IF (NIDX.LE.-1) THEN
         RA = RASH(1)
         RB = RBSH(NTARG)
      ELSE
         RA = RASH(NTARG)
         RB = RBSH(1)
      ENDIF

      IF (ICENTR.EQ.2) THEN
         IF (RA.EQ.RB) THEN
            BB = DT_RNDM(B)*(0.3D0*RA)**2
            B  = SQRT(BB)
         ELSEIF(RA.LT.RB)THEN
            BB = DT_RNDM(B)*1.4D0*(RB-RA)**2
            B  = SQRT(BB)
         ELSEIF(RA.GT.RB)THEN
            BB = DT_RNDM(B)*1.4D0*(RA-RB)**2
            B  = SQRT(BB)
         ENDIF
      ELSE
    9    CONTINUE
         Y  = DT_RNDM(BB)
         I0 = 1
         I2 = NSITEB
   10    CONTINUE
         I1 = (I0+I2)/2
         LEFT = ((BSITE(0,1,NTARG,I0)-Y)
     &          *(BSITE(0,1,NTARG,I1)-Y)).LT.ZERO
         IF (LEFT) GOTO 20
         I0 = I1
         GOTO 30
   20    CONTINUE
         I2 = I1
   30    CONTINUE
         IF (I2-I0-2) 40,50,60
   40    CONTINUE
         I1 = I2+1
         IF (I1.GT.NSITEB) I1 = I0-1
         GOTO 70
   50    CONTINUE
         I1 = I0+1
         GOTO 70
   60    CONTINUE
         GOTO 10
   70    CONTINUE
         X0 = DBLE(I0-1)*BSTEP(NTARG)
         X1 = DBLE(I1-1)*BSTEP(NTARG)
         X2 = DBLE(I2-1)*BSTEP(NTARG)
         Y0 = BSITE(0,1,NTARG,I0)
         Y1 = BSITE(0,1,NTARG,I1)
         Y2 = BSITE(0,1,NTARG,I2)
   80    CONTINUE
         B = X0*(Y-Y1)*(Y-Y2)/((Y0-Y1)*(Y0-Y2)+TINY15)+
     &       X1*(Y-Y0)*(Y-Y2)/((Y1-Y0)*(Y1-Y2)+TINY15)+
     &       X2*(Y-Y0)*(Y-Y1)/((Y2-Y0)*(Y2-Y1)+TINY15)
c*sr 5.4.98: shift B by half the bin width to be in agreement with BPROD
         B = B+0.5D0*BSTEP(NTARG)
         IF (B.LT.ZERO) B = X1
         IF (B.GT.BMAX(NTARG)) B = BMAX(NTARG)
         IF (ICENTR.LT.0) THEN
            IF (LFIRST) THEN
               LFIRST = .FALSE.
               IF (ICENTR.LE.-100) THEN
                  BIMIN  = 0.0D0
               ELSE
                  XSFRAC = 0.0D0
               ENDIF
               CALL DT_GETBXS(XSFRAC,BIMIN,BIMAX,NTARG)
               WRITE(ErrorOut,
     * 1000) RASH(1),RBSH(NTARG),BMAX(NTARG),
     &                          BIMIN,BIMAX,XSFRAC*100.0D0,
     &                          XSFRAC*XSPRO(1,1,NTARG)
 10000         FORMAT(/,1X,'DT_MODB:      BIASING IN IMPACT PARAMETER',
     &                /,15X,'---------------------------'/,/,4X,
     &                'AVERAGE RADII OF PROJ / TARG :',F10.3,' FM /',
     &                F7.3,' FM',/,4X,'CORRESP. B_MAX (4*(R_P+R_T)) :',
     &                F10.3,' FM',/,/,21X,'B_LO / B_HI :',
     &                F10.3,' FM /',F7.3,' FM',/,5X,'PERCENTAGE OF',
     &                ' CROSS SECTION :',F10.3,' %',/,5X,
     &                'CORRESPONDING CROSS SECTION :',F10.3,' MB',/)
            ENDIF
            IF (ABS(BIMAX-BIMIN).LT.1.0D-3) THEN
               B = BIMIN
            ELSE
               IF ((B.LT.BIMIN).OR.(B.GT.BIMAX)) GOTO 9
            ENDIF
         ENDIF
      ENDIF

      RETURN
      END
c
c===shfast=============================================================*
c
CDECK  ID>, DT_SHFAST
      SUBROUTINE DT_SHFAST(MODE,PPN,IBACK)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,TINY1=1.0D-1,
     &           ONE=1.0D0,TWO=2.0D0)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI


      IBACK = 0

      IF (MODE.EQ.2) THEN
         OPEN(47,FILE='OUTDATA0/SHMAKOV.OUT',STATUS='UNKNOWN')
         WRITE(47,1000) IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG,PPN
 1000    FORMAT(1X,8I5,E15.5)
         WRITE(47,1001) RASH(1),RBSH(1),BMAX(1),BSTEP(1)
 1001    FORMAT(1X,4E15.5)
         WRITE(47,1002) SIGSH,ROSH,GSH
 1002    FORMAT(1X,3E15.5)
         DO 10 I=1,100
            WRITE(47,'(1X,E15.5)') BSITE(1,1,1,I)
   10    CONTINUE
         WRITE(47,1003) NSITEB,NSTATB,ECMNN(1),XSPRO(1,1,1),BSLOPE
 1003    FORMAT(1X,2I10,3E15.5)
         CLOSE(47)
      ELSE
         OPEN(47,FILE='OUTDATA0/SHMAKOV.OUT',STATUS='UNKNOWN')
         READ(47,1000) JT,JTZ,JP,JPZ,JJPROJ,JBPROJ,JJTARG,JBTARG,PP
         IF ((JT.EQ.IT).AND.(JTZ.EQ.ITZ).AND.(JP.EQ.IP).AND.
     &       (JPZ.EQ.IPZ).AND.(JJPROJ.EQ.IJPROJ).AND.(JBPROJ.EQ.IBPROJ)
     &       .AND.(JJTARG.EQ.IJTARG).AND.(JBTARG.EQ.IBTARG).AND.
     &       (ABS(PP-PPN).LT.(PPN*0.01D0))) THEN
            READ(47,1001) RASH(1),RBSH(1),BMAX(1),BSTEP(1)
            READ(47,1002) SIGSH,ROSH,GSH
            DO 11 I=1,100
               READ(47,'(1X,E15.5)') BSITE(1,1,1,I)
   11       CONTINUE
            READ(47,1003) NSITEB,NSTATB,ECMNN(1),XSPRO(1,1,1),BSLOPE
         ELSE
            IBACK = 1
         ENDIF
         CLOSE(47)
      ENDIF

      RETURN
      END
c
c===poilik=============================================================*
c
CDECK  ID>, DT_POILIK
      SUBROUTINE DT_POILIK(NB,NTARG,ECM,VIRT,IPNT,RPNT,MODE)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY14=1.0D0)
      PARAMETER (NE = 8)

c*PHOJET105a
C     CHARACTER*8 MDLNA
C     COMMON /MODELS/ MDLNA(50),ISWMDL(50),PARMDL(200),IPAMDL(100)
C     PARAMETER (IEETAB=10)
C     COMMON /XSETAB/ SIGTAB(4,70,IEETAB),SIGECM(4,IEETAB),ISIMAX
c*PHOJET110
C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX

c*
c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)

c*sr 22.7.97
      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c*

      DATA ECMOLD,Q2OLD /-1.0D0,-1.0D0/

      IF ((ECM.EQ.ECMOLD).AND.(VIRT.EQ.Q2OLD)) GOTO 3

c load cross sections from interpolation table
      IP = 1
      IF(ECM.LE.SIGECM(IP,1)) THEN
        I1 = 1
        I2 = 1
      ELSE IF(ECM.LT.SIGECM(IP,ISIMAX)) THEN
        DO 50 I=2,ISIMAX
          IF(ECM.LE.SIGECM(IP,I)) GOTO 200
  50    CONTINUE
 200    CONTINUE
        I1 = I-1
        I2 = I
      ELSE
        WRITE(ErrorOut,'(/1X,A,2E12.3)')
     &    'POILIK:WARNING:TOO HIGH ENERGY',ECM,SIGECM(IP,ISIMAX)
        I1 = ISIMAX
        I2 = ISIMAX
      ENDIF
      FAC2 = ZERO
      IF(I1.NE.I2) FAC2=LOG(ECM/SIGECM(IP,I1))
     &                     /LOG(SIGECM(IP,I2)/SIGECM(IP,I1))
      FAC1 = ONE-FAC2

      SIGANO = DT_SANO(ECM)

c cross section dependence on photon virtuality
      FSUP1 = ZERO
      DO  150 I=1,3
         FSUP1 = FSUP1+PARMDL(26+I)*(ONE+VIRT/(4.D0*PARMDL(30+I)))
     &                             /(ONE+VIRT/PARMDL(30+I))**2
 150  CONTINUE
      FSUP1 = FSUP1+PARMDL(30)/(ONE+VIRT/PARMDL(34))
      FAC1  = FAC1*FSUP1
      FAC2  = FAC2*FSUP1
      FSUP2 = ONE

      ECMOLD = ECM
      Q2OLD  = VIRT

    3 CONTINUE

C     SIGTOT = FAC2*SIGTAB(IP, 1,I2)+FAC1*SIGTAB(IP, 1,I1)
      CALL DT_SIGGP(ZERO,VIRT,ECM,ZERO,SIGTOT,DUM1,DUM2)
      IF (ISHAD(1).EQ.1) THEN
         SIGDIR = FAC2*SIGTAB(IP,29,I2)+FAC1*SIGTAB(IP,29,I1)
      ELSE
         SIGDIR = ZERO
      ENDIF
      SIGANO = FSUP1*FSUP2*SIGANO
      SIGTOT = SIGTOT-SIGDIR-SIGANO
      SIGDIR = SIGDIR/(FSUP1*FSUP2)
      SIGANO = SIGANO/(FSUP1*FSUP2)
      SIGTOT = SIGTOT+SIGDIR+SIGANO

      RR = DT_RNDM(SIGTOT)
      IF (RR.LT.SIGDIR/SIGTOT) THEN
         IPNT = 1
      ELSEIF ((RR.GE.SIGDIR/SIGTOT).AND.
     &        (RR.LT.(SIGDIR+SIGANO)/SIGTOT)) THEN
         IPNT = 2
      ELSE
         IPNT = 0
      ENDIF
      RPNT = (SIGDIR+SIGANO)/SIGTOT
C     WRITE(LOUT,'(I3,2F15.5)') ISHAD(1),FAC1,FAC2
C     WRITE(LOUT,'(I3,2F15.5)') MODE,SIGDIR,SIGANO
C     WRITE(LOUT,'(I3,4F15.5)') MODE,SIGDIR+SIGANO,SIGTOT,RPNT,ECM
C     WRITE(6,'(1X,6E12.4)') ECM,VIRT,SIGTOT,SIGDIR,SIGANO,RPNT
      IF (MODE.EQ.1) RETURN

c*sr 22.7.97
      K1   = 1
      K2   = 1
      RATE = ZERO
      IF (ECM.GE.ECMNN(NEBINI)) THEN
         K1   = NEBINI
         K2   = NEBINI
         RATE = ONE
      ELSEIF (ECM.GT.ECMNN(1)) THEN
         DO 10 I=2,NEBINI
            IF (ECM.LT.ECMNN(I)) THEN
               K1   = I-1
               K2   = I
               RATE = (ECM-ECMNN(K1))/(ECMNN(K2)-ECMNN(K1))
               GOTO 11
            ENDIF
   10    CONTINUE
   11    CONTINUE
      ENDIF
      J1   = 1
      J2   = 1
      RATQ = ZERO
      IF (NQBINI.GT.1) THEN
         IF (VIRT.GE.Q2G(NQBINI)) THEN
            J1   = NQBINI
            J2   = NQBINI
            RATQ = ONE
         ELSEIF (VIRT.GT.Q2G(1)) THEN
            DO 12 I=2,NQBINI
               IF (VIRT.LT.Q2G(I)) THEN
                  J1   = I-1
                  J2   = I
                  RATQ = LOG10(   VIRT/MAX(Q2G(J1),TINY14))/
     &                   LOG10(Q2G(J2)/MAX(Q2G(J1),TINY14))
                  GOTO 13
               ENDIF
   12       CONTINUE
   13       CONTINUE
         ENDIF
      ENDIF
      SGA = XSPRO(K1,J1,NTARG)+
     &      RATE*(XSPRO(K2,J1,NTARG)-XSPRO(K1,J1,NTARG))+
     &      RATQ*(XSPRO(K1,J2,NTARG)-XSPRO(K1,J1,NTARG))+
     &      RATE*RATQ*(XSPRO(K2,J2,NTARG)-XSPRO(K1,J2,NTARG)+
     &                 XSPRO(K1,J1,NTARG)-XSPRO(K2,J1,NTARG))
      SDI = DBLE(NB)*SIGDIR
      SAN = DBLE(NB)*SIGANO
      SPL = SDI+SAN
      RR = DT_RNDM(SPL)
      IF (RR.LT.SDI/SGA) THEN
         IPNT = 1
      ELSEIF ((RR.GE.SDI/SGA).AND.
     &        (RR.LT.SPL/SGA)) THEN
         IPNT = 2
      ELSE
         IPNT = 0
      ENDIF
      RPNT = SPL/SGA
C     WRITE(LOUT,'(I3,4F15.5)') MODE,SPL,SGA,RPNT,ECM
c*

      RETURN
      END
c
c===glbini=============================================================*
c
CDECK  ID>, DT_GLBINI
      SUBROUTINE DT_GLBINI(WHAT)

c***********************************************************************
c Pre-initialization of profile function                               *
c This version dated 28.11.00 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (LIN=5,LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY14=1.D-14)

      LOGICAL LCMS

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD

c number of data sets other than protons and nuclei
c at the moment = 2 (pions and kaons)
      PARAMETER (MAXOFF=2)
      DIMENSION IJPINI(5),IOFFST(25)
      DATA IJPINI / 13, 15,  0,  0,  0/
c Glauber data-set to be used for hadron projectiles
c (0=proton, 1=pion, 2=kaon)
      DATA (IOFFST(K),K=1,25) /
     &  0, 0,-1,-1,-1,-1,-1, 0, 0,-1,-1, 2, 1, 1, 2, 2, 0, 0, 2, 0,
     &  0, 0, 1, 2, 2/


      PARAMETER (MAXMSS = 100)
      DIMENSION IASAV(MAXMSS),IBSAV(MAXMSS)
      DIMENSION WHAT(6)

      DATA JPEACH,JPSTEP / 18, 5 /
c
c--------------------------------------------------------------------------
c general initializations
c
c  steps in projectile mass number for initialization
      IF (WHAT(4).GT.ZERO) JPEACH = INT(WHAT(4))
      IF (WHAT(5).GT.ZERO) JPSTEP = INT(WHAT(5))
c
c  energy range and binning
      ELO  = ABS(WHAT(1))
      EHI  = ABS(WHAT(2))
      IF (ELO.GT.EHI) ELO = EHI
      NEBIN = MAX(INT(WHAT(3)),1)
      IF (ELO.EQ.EHI) NEBIN = 0
      LCMS = (WHAT(1).LT.ZERO).OR.(WHAT(2).LT.ZERO)
      IF (LCMS) THEN
         ECMINI = EHI
      ELSE
         ECMINI = SQRT(AAM(IJPROJ)**2+AAM(IJTARG)**2
     &                 +2.0D0*AAM(IJTARG)*EHI)
      ENDIF
c
c  default arguments for Glauber-routine
      XI  = ZERO
      Q2I = ZERO
c
c  initialize nuclear parameters, etc.
      CALL DT_BERTTP
      CALL DT_INCINI
c
c  open Glauber-data output file
      IDX = INDEX(CGLB,' ')
      K   = 12
      IF (IDX.GT.1) K = IDX-1
      OPEN(LLOOK,FILE=CGLB(1:K)//'.GLB',STATUS='UNKNOWN')
c
c--------------------------------------------------------------------------
c Glauber-initialization for proton and nuclei projectiles
c
c  initialize phojet for proton-proton interactions
      ELAB = ZERO
      PLAB = ZERO
      CALL DT_LTINI(IJPROJ,IJTARG,ELAB,PLAB,ECMINI,1)
      CALL DT_PHOINI
c
c  record projectile masses
      NASAV = 0
      NPROJ = MIN(IP,JPEACH)
      DO 10 KPROJ=1,NPROJ
         NASAV = NASAV+1
         IF (NASAV.GT.MAXMSS) STOP ' GLBINI: NASAV > MAXMSS ! '
         IASAV(NASAV) = KPROJ
   10 CONTINUE
      IF (IP.GT.JPEACH) THEN
         NPROJ = DBLE(IP-JPEACH)/DBLE(JPSTEP)
         IF (NPROJ.EQ.0) THEN
            NASAV = NASAV+1
            IF (NASAV.GT.MAXMSS) STOP ' GLBINI: NASAV > MAXMSS ! '
            IASAV(NASAV) = IP
         ELSE
            DO 11 IPROJ=1,NPROJ
               KPROJ = JPEACH+IPROJ*JPSTEP
               NASAV = NASAV+1
               IF (NASAV.GT.MAXMSS) STOP ' GLBINI: NASAV > MAXMSS ! '
               IASAV(NASAV) = KPROJ
   11       CONTINUE
            IF (KPROJ.LT.IP) THEN
               NASAV = NASAV+1
               IF (NASAV.GT.MAXMSS) STOP ' GLBINI: NASAV > MAXMSS ! '
               IASAV(NASAV) = IP
            ENDIF
         ENDIF
      ENDIF
c
c  record target masses
      NBSAV = 0
      NTARG = 1
      IF (NCOMPO.GT.0) NTARG = NCOMPO
      DO 12 ITARG=1,NTARG
         NBSAV = NBSAV+1
         IF (NBSAV.GT.MAXMSS) STOP ' GLBINI: NBSAV > MAXMSS ! '
         IF (NCOMPO.GT.0) THEN
            IBSAV(NBSAV) = IEMUMA(ITARG)
         ELSE
            IBSAV(NBSAV) = IT
         ENDIF
   12 CONTINUE
c
c  print masses
      WRITE(LLOOK,1000) NEBIN,': ',SIGN(ELO,WHAT(1)),SIGN(EHI,WHAT(2))
 1000 FORMAT(I4,A,1P,2E13.5)
      NLINES = DBLE(NASAV)/18.0D0
      IF (NLINES.GT.0) THEN
         DO 13 I=1,NLINES
            IF (I.EQ.1) THEN
               WRITE(LLOOK,'(I4,A,18I4)')NASAV,': ',(IASAV(J),J=1,18)
            ELSE
               WRITE(LLOOK,'(6X,18I4)') (IASAV(J),J=18*I-17,18*I)
            ENDIF
   13    CONTINUE
      ENDIF
      I0 = 18*NLINES+1
      IF (I0.LE.NASAV) THEN
         IF (I0.EQ.1) THEN
            WRITE(LLOOK,'(I4,A,18I4)')NASAV,': ',(IASAV(J),J=I0,NASAV)
         ELSE
            WRITE(LLOOK,'(6X,18I4)') (IASAV(J),J=I0,NASAV)
         ENDIF
      ENDIF
      NLINES = DBLE(NBSAV)/18.0D0
      IF (NLINES.GT.0) THEN
         DO 14 I=1,NLINES
            IF (I.EQ.1) THEN
               WRITE(LLOOK,'(I4,A,18I4)')NBSAV,': ',(IBSAV(J),J=1,18)
            ELSE
               WRITE(LLOOK,'(6X,18I4)') (IBSAV(J),J=18*I-17,18*I)
            ENDIF
   14    CONTINUE
      ENDIF
      I0 = 18*NLINES+1
      IF (I0.LE.NBSAV) THEN
         IF (I0.EQ.1) THEN
            WRITE(LLOOK,'(I4,A,18I4)')NBSAV,': ',(IBSAV(J),J=I0,NBSAV)
         ELSE
            WRITE(LLOOK,'(6X,18I4)') (IBSAV(J),J=I0,NBSAV)
         ENDIF
      ENDIF
c
c  calculate Glauber-data for each energy and mass combination
c
c   loop over energy bins
      ELO = LOG10(ELO)
      EHI = LOG10(EHI)
      DEBIN = (EHI-ELO)/DBLE(NEBIN)
      DO 1 IE=1,NEBIN+1
         E = ELO+DBLE(IE-1)*DEBIN
         E = 10**E
         IF (LCMS) THEN
            E   = MAX(2.0D0*AAM(IJPROJ)+0.1D0,E)
            ECM = E
         ELSE
            PLAB = ZERO
            ECM  = ZERO
            E    = MAX(AAM(IJPROJ)+0.1D0,E)
            CALL DT_LTINI(IJPROJ,IJTARG,E,PLAB,ECM,0)
         ENDIF
c
c   loop over projectile and target masses
         DO 2 ITARG=1,NBSAV
            DO 3 IPROJ=1,NASAV
               CALL DT_XSGLAU(IASAV(IPROJ),IBSAV(ITARG),IJPROJ,
     &                                       XI,Q2I,ECM,1,1,-1)
    3       CONTINUE
    2    CONTINUE
c
    1 CONTINUE
c
c--------------------------------------------------------------------------
c Glauber-initialization for pion, kaon, ... projectiles
c
      DO 6 IJ=1,MAXOFF
c
c  initialize phojet for this interaction
         ELAB = ZERO
         PLAB = ZERO
         IJPROJ = IJPINI(IJ)
         IP     = 1
         IPZ    = 1
         CALL DT_LTINI(IJPROJ,IJTARG,ELAB,PLAB,ECMINI,1)
         CALL DT_PHOINI
c
c  calculate Glauber-data for each energy and mass combination
c
c   loop over energy bins
         DO 4 IE=1,NEBIN+1
            E = ELO+DBLE(IE-1)*DEBIN
            E = 10**E
            IF (LCMS) THEN
               E   = MAX(2.0D0*AAM(IJPROJ)+TINY14,E)
               ECM = E
            ELSE
               PLAB = ZERO
               ECM  = ZERO
               E    = MAX(AAM(IJPROJ)+TINY14,E)
               CALL DT_LTINI(IJPROJ,IJTARG,E,PLAB,ECM,0)
            ENDIF
c
c   loop over projectile and target masses
            DO 5 ITARG=1,NBSAV
               CALL DT_XSGLAU(1,IBSAV(ITARG),IJPROJ,XI,Q2I,ECM,1,1,-1)
    5       CONTINUE
c
    4    CONTINUE
c
    6 CONTINUE

c--------------------------------------------------------------------------
c close output unit(s), etc.
c
      CLOSE(LLOOK)

      RETURN
      END
c
c===glbset=============================================================*
c
CDECK  ID>, DT_GLBSET
      SUBROUTINE DT_GLBSET(IDPROJ,NA,NB,ELAB,MODE)
c***********************************************************************
c Interpolation of pre-initialized profile functions                   *
c This version dated 28.11.00 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER (LIN=5,LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0)

      LOGICAL LCMS,LREAD

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c number of data sets other than protons and nuclei
c at the moment = 2 (pions and kaons)
      PARAMETER (MAXOFF=2)
      DIMENSION IJPINI(5),IOFFST(25)
      DATA IJPINI / 13, 15,  0,  0,  0/
c Glauber data-set to be used for hadron projectiles
c (0=proton, 1=pion, 2=kaon)
      DATA (IOFFST(K),K=1,25) /
     &  0, 0,-1,-1,-1,-1,-1, 0, 0,-1,-1, 2, 1, 1, 2, 2, 0, 0, 2, 0,
     &  0, 0, 1, 2, 2/

c
c        &&&&& expasion  by KK
c                      10       22+2=24       20    = 4800
c           NSET0 = (NEBIN+1)*(NABIN+MAXOFF)*NBBIN <= MAXSET
cc      for air  NEBIN =4800/(24*3)-1 = 65  : enough large
cc      proj: A=1,2,3...14,15, 21,27,33,39,45,51,56  --> 22 A's
cc
cc 
cc      PARAMETER (MAXSET=1000,   ! original
      PARAMETER (MAXSET=4800,
     &           MAXBIN=50)
      DIMENSION XSIG(MAXSET,6),XERR(MAXSET,6),BPROFL(MAXSET,KSITEB)
      DIMENSION IABIN(MAXBIN),IBBIN(MAXBIN),XS(6),XE(6),
     &          BPRO0(KSITEB),BPRO1(KSITEB),BPRO(KSITEB),
     &          IAIDX(10)

      DATA LREAD /.FALSE./

      character*12 tempstr
c
c read data from file
c
      IF (MODE.EQ.0) THEN

         IF (LREAD) RETURN

         DO 1 I=1,MAXSET
            DO 2 J=1,6
               XSIG(I,J) = ZERO
               XERR(I,J) = ZERO
    2       CONTINUE
            DO 3 J=1,KSITEB
               BPROFL(I,J) = ZERO
    3       CONTINUE
    1    CONTINUE
         DO 4 I=1,MAXBIN
            IABIN(I) = 0
            IBBIN(I) = 0
    4    CONTINUE
         DO 5 I=1,KSITEB
            BPRO0(I) = ZERO
            BPRO1(I) = ZERO
            BPRO(I)  = ZERO
    5    CONTINUE

         IDX = INDEX(CGLB,' ')
         K   = 12
         IF (IDX.GT.1) K = IDX-1
ccc         &&&&&&&&&&&& kk
         tempstr = ' '
         tempstr =CGLB(1:K)//'.GLB'
c         OPEN(LLOOK,FILE=CGLB(1:K)//'.GLB',STATUS='UNKNOWN')
         call cdpmOpen(LLOOK, tempstr)
         WRITE(ErrorOut,1000) tempstr
ccc    &&&&&&&
 1000    FORMAT(/,' GLBSET: IMPACT PARAMETER DISTRIBUTIONS READ FROM ',
     &          'FILE ',A12,/)
c
c  read binning information
         READ(LLOOK,'(I4,2X,2E13.5)') NEBIN,ELO,EHI
         LCMS = ELO.LT.ZERO
         WRITE(ErrorOut,
     * '(1X,A)') ' equidistant logarithmic energy binning:'
         IF (LCMS) THEN
            WRITE(ErrorOut,1001) '(cms)',ABS(ELO),ABS(EHI),NEBIN
         ELSE
            WRITE(ErrorOut,1001) '(lab)',ABS(ELO),ABS(EHI),NEBIN
         ENDIF
 1001    FORMAT(2X,A5,'  E_LO = ',1P,E9.3,'  E_HI = ',1P,E9.3,4X,
     &          'NO. OF BINS:',I5,/)
         ELO  = LOG10(ABS(ELO))
         EHI  = LOG10(ABS(EHI))
         DEBIN = (EHI-ELO)/ABS(DBLE(NEBIN))
         WRITE(ErrorOut,
     * '(/,1X,A)') ' projectiles: (mass number)'
         READ(LLOOK,'(I4,2X,18I4)') NABIN,(IABIN(J),J=1,18)
         IF (NABIN.LT.18) THEN
            WRITE(ErrorOut,'(6X,18I4)') (IABIN(J),J=1,NABIN)
         ELSE
            WRITE(ErrorOut,'(6X,18I4)') (IABIN(J),J=1,18)
         ENDIF
         IF (NABIN.GT.MAXBIN) STOP ' GLBSET: NABIN > MAXBIN !'
         IF (NABIN.GT.18) THEN
            NLINES = DBLE(NABIN-18)/18.0D0
            IF (NLINES.GT.0) THEN
               DO 7 I=1,NLINES
                  I0 = 18*(I+1)-17
                  READ(LLOOK,'(6X,18I4)') (IABIN(J),J=I0,I0+17)
                  WRITE(ErrorOut,
     * '(6X,18I4)') (IABIN(J),J=I0,I0+17)
    7          CONTINUE
            ENDIF
            I0 = 18*(NLINES+1)+1
            IF (I0.LE.NABIN) THEN
               READ(LLOOK,'(6X,18I4)') (IABIN(J),J=I0,NABIN)
               WRITE(ErrorOut,'(6X,18I4)') (IABIN(J),J=I0,NABIN)
            ENDIF
         ENDIF
         WRITE(ErrorOut,'(/,1X,A)') ' targets: (mass number)'
         READ(LLOOK,'(I4,2X,18I4)') NBBIN,(IBBIN(J),J=1,18)
         IF (NBBIN.LT.18) THEN
            WRITE(ErrorOut,'(6X,18I4)') (IBBIN(J),J=1,NBBIN)
         ELSE
            WRITE(ErrorOut,'(6X,18I4)') (IBBIN(J),J=1,18)
         ENDIF
         IF (NBBIN.GT.MAXBIN) STOP ' GLBSET: NBBIN > MAXBIN !'
         IF (NBBIN.GT.18) THEN
            NLINES = DBLE(NBBIN-18)/18.0D0
            IF (NLINES.GT.0) THEN
               DO 8 I=1,NLINES
                  I0 = 18*(I+1)-17
                  READ(LLOOK,'(6X,18I4)') (IBBIN(J),J=I0,I0+17)
                  WRITE(ErrorOut,
     * '(6X,18I4)') (IBBIN(J),J=I0,I0+17)
    8          CONTINUE
            ENDIF
            I0 = 18*(NLINES+1)+1
            IF (I0.LE.NBBIN) THEN
               READ(LLOOK,'(6X,18I4)') (IBBIN(J),J=I0,NBBIN)
               WRITE(ErrorOut,'(6X,18I4)') (IBBIN(J),J=I0,NBBIN)
            ENDIF
         ENDIF
c  number of data sets to follow in the Glauber data file
c   this variable is used for checks of consistency of projectile
c   and target mass configurations given in header of Glauber data
c   file and the data-sets which follow in this file
         NSET0 = (NEBIN+1)*(NABIN+MAXOFF)*NBBIN
c
c  read profile function data
         NSET  = 0
         NAIDX = 0
         IPOLD = 0
   10    CONTINUE
         NSET = NSET+1
         IF (NSET.GT.MAXSET) STOP ' GLBSET: NSET > MAXSET ! '
         READ(LLOOK,1002,END=100) IP,IA,IB,ISTATB,ISITEB,ECM
 1002    FORMAT(5I10,E15.5)
         IF ((IP.NE.1).AND.(IP.NE.IPOLD)) THEN
            NAIDX = NAIDX+1
            IF (NAIDX.GT.10) STOP ' GLBSET: NAIDX > 10 !'
            IAIDX(NAIDX) = IP
            IPOLD = IP
         ENDIF
         READ(LLOOK,'(6E12.5)') (XSIG(NSET,I),I=1,6)
         READ(LLOOK,'(6E12.5)') (XERR(NSET,I),I=1,6)
         NLINES = INT(DBLE(ISITEB)/7.0D0)
         IF (NLINES.GT.0) THEN
            DO 11 I=1,NLINES
               READ(LLOOK,'(7E11.4)') (BPROFL(NSET,J),J=7*I-6,7*I)
   11       CONTINUE
         ENDIF
         I0 = 7*NLINES+1
         IF (I0.LE.ISITEB)
     &      READ(LLOOK,'(7E11.4)') (BPROFL(NSET,J),J=I0,ISITEB)
         GOTO 10
  100    CONTINUE
         NSET = NSET-1
         IF (NSET.NE.NSET0) STOP ' GLBSET: NSET.NE.NSET0 !'
         WRITE(ErrorOut,'(/,1X,A)')
     &   ' PROJECTILES OTHER THAN PROTONS AND NUCLEI: (PARTICLE INDEX)'
         IF (NAIDX.GT.0) THEN
            WRITE(ErrorOut,'(6X,18I4)') (IAIDX(J),J=1,NAIDX)
         ELSE
            WRITE(ErrorOut,'(6X,A)') 'none'
         ENDIF
c
         CLOSE(LLOOK)
         WRITE(ErrorOut,*)
         LREAD = .TRUE.
c
c calculate profile function for certain set of parameters
c
      ELSE

c        write(*,*) 'glbset called for ',IDPROJ,NA,NB,ELAB,MODE
c
c check for type of projectile and set index-offset to entry in
c Glauber data array correspondingly
         IF (IDPROJ.GT.25) STOP ' GLBSET: IDPROJ > 25 !'
         IF (IOFFST(IDPROJ).EQ.-1) THEN
            STOP ' GLBSET: NO DATA FOR THIS PROJECTILE !'
         ELSEIF (IOFFST(IDPROJ).GT.0) THEN
            IDXOFF = (NEBIN+1)*(NABIN+IOFFST(IDPROJ)-1)*NBBIN
         ELSE
            IDXOFF = 0
         ENDIF
c
c get energy bin and interpolation factor
         IF (LCMS) THEN
            E = SQRT(AAM(IDPROJ)**2+AAM(1)**2+2.0D0*AAM(1)*ELAB)
         ELSE
            E = ELAB
         ENDIF
         E = LOG10(E)
         IF ((E.LT.ELO).OR.(E.GT.EHI)) THEN
            WRITE(ErrorOut,*) ' GLBSET: inconsistent energy ! '
            WRITE(ErrorOut,
     * *) '         (E,E_lo,E_hi) ',E,ELO,EHI
            STOP
         ENDIF
         IE0  = (E-ELO)/DEBIN+1
         IE1  = IE0+1
         FACE = (E-(ELO+DBLE(IE0-1)*DEBIN))/DEBIN
c
c get target nucleus index
         KB = 0
         DO 20 I=1,NBBIN
            IF (NB.EQ.IBBIN(I)) THEN
               KB = I
               GOTO 21
            ENDIF
   20    CONTINUE
         WRITE(ErrorOut,
     * *) ' GLBSET: data not found for target ',NB
         STOP
   21    CONTINUE
c
c get projectile nucleus bin and interpolation factor
         KA0 = 0
         KA1 = 0
         FACNA = 0
         IF (IDXOFF.GT.0) THEN
            KA0 = 1
            KA1 = 1
            KABIN = 1
         ELSE
            IF (NA.GT.IABIN(NABIN)) STOP ' GLBSET: NA > IABIN(NABIN) !'
            DO 22 I=1,NABIN
               IF (NA.EQ.IABIN(I)) THEN
                  KA0 = I
                  KA1 = I
                  GOTO 23
               ELSEIF (NA.LT.IABIN(I)) THEN
                  KA0 = I-1
                  KA1 = I
                  GOTO 23
               ENDIF
   22       CONTINUE
            WRITE(ErrorOut,
     * *) ' GLBSET: data not found for projectile ',NA
            STOP
   23       CONTINUE
            IF (KA0.NE.KA1)
     &         FACNA = DBLE(NA-IABIN(KA0))/DBLE(IABIN(KA1)-IABIN(KA0))
            KABIN = NABIN
         ENDIF
c
c interpolate profile functions for interactions ka0-kb and ka1-kb
c for energy E separately
         IDX0 = IDXOFF+1+(IE0-1)*KABIN*NBBIN+(KB-1)*KABIN+(KA0-1)
         IDX1 = IDXOFF+1+(IE1-1)*KABIN*NBBIN+(KB-1)*KABIN+(KA0-1)
         IDY0 = IDXOFF+1+(IE0-1)*KABIN*NBBIN+(KB-1)*KABIN+(KA1-1)
         IDY1 = IDXOFF+1+(IE1-1)*KABIN*NBBIN+(KB-1)*KABIN+(KA1-1)
         DO 30 I=1,ISITEB
            BPRO0(I) = BPROFL(IDX0,I)
     &                 +FACE*(BPROFL(IDX1,I)-BPROFL(IDX0,I))
            BPRO1(I) = BPROFL(IDY0,I)
     &                 +FACE*(BPROFL(IDY1,I)-BPROFL(IDY0,I))
   30    CONTINUE
         RADB  = DT_RNCLUS(NB)
         BSTP0 = 2.0D0*(DT_RNCLUS(IABIN(KA0))+RADB)/DBLE(ISITEB-1)
         BSTP1 = 2.0D0*(DT_RNCLUS(IABIN(KA1))+RADB)/DBLE(ISITEB-1)
c
c interpolate cross sections for energy E and projectile mass
         DO 31 I=1,6
            XS0   = XSIG(IDX0,I)+FACE*(XSIG(IDX1,I)-XSIG(IDX0,I))
            XS1   = XSIG(IDY0,I)+FACE*(XSIG(IDY1,I)-XSIG(IDY0,I))
            XS(I) = XS0+FACNA*(XS1-XS0)
            XE0   = XERR(IDX0,I)+FACE*(XERR(IDX1,I)-XERR(IDX0,I))
            XE1   = XERR(IDY0,I)+FACE*(XERR(IDY1,I)-XERR(IDY0,I))
            XE(I) = XE0+FACNA*(XE1-XE0)
   31    CONTINUE
c
c interpolate between ka0 and ka1
         RADA = DT_RNCLUS(NA)
         BMX  = 2.0D0*(RADA+RADB)
         BSTP = BMX/DBLE(ISITEB-1)
         BPRO(1) = ZERO
         DO 32 I=1,ISITEB-1
            B = DBLE(I)*BSTP
c
c   calculate values of profile functions at B
            IDX0 = B/BSTP0+1
            IF (IDX0.GT.ISITEB) IDX0 = ISITEB
            IDX1 = MIN(IDX0+1,ISITEB)
            FACB = (B-DBLE(IDX0-1)*BSTP0)/BSTP0
            BPR0 = BPRO0(IDX0)+FACB*(BPRO0(IDX1)-BPRO0(IDX0))
            IDX0 = B/BSTP1+1
            IF (IDX0.GT.ISITEB) IDX0 = ISITEB
            IDX1 = MIN(IDX0+1,ISITEB)
            FACB = (B-DBLE(IDX0-1)*BSTP1)/BSTP1
            BPR1 = BPRO1(IDX0)+FACB*(BPRO1(IDX1)-BPRO1(IDX0))
c
            BPRO(I+1) = BPR0+FACNA*(BPR1-BPR0)
   32    CONTINUE
c
c fill common dtglam
         NSITEB   = ISITEB
         RASH(1)  = RADA
         RBSH(1)  = RADB
         BMAX(1)  = BMX
         BSTEP(1) = BSTP
         DO 33 I=1,KSITEB
            BSITE(0,1,1,I) = BPRO(I)
   33    CONTINUE
c
c fill common dtglxs
         XSTOT(1,1,1) = XS(1)
         XSELA(1,1,1) = XS(2)
         XSQEP(1,1,1) = XS(3)
         XSQET(1,1,1) = XS(4)
         XSQE2(1,1,1) = XS(5)
         XSPRO(1,1,1) = XS(6)
         XETOT(1,1,1) = XE(1)
         XEELA(1,1,1) = XE(2)
         XEQEP(1,1,1) = XE(3)
         XEQET(1,1,1) = XE(4)
         XEQE2(1,1,1) = XE(5)
         XEPRO(1,1,1) = XE(6)

      ENDIF

      RETURN
      END
c
c===xksamp=============================================================*
c
CDECK  ID>, DT_XKSAMP
      SUBROUTINE DT_XKSAMP(NN,ECM)

c***********************************************************************
c Sampling of parton x-values and chain system for one interaction.    *
c                                   processed by S. Roesler, 9.8.95    *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ZERO=0.0D0,OHALF=0.5D0,ONE=1.0D0)
      SAVE

      PARAMETER (
c lower cuts for (valence-sea/sea-valence) chain masses
c   antiquark-quark (u/d-sea quark)    (s-sea quark)
     &               AMIU = 0.5D0,      AMIS = 0.8D0,
c   quark-diquark   (u/d-sea quark)    (s-sea quark)
     &               AMAU = 2.6D0,      AMAS = 2.6D0,
c maximum lower valence-x threshold
     &           XVMAX  = 0.98D0,
c fraction of sea-diquarks sampled out of sea-partons
c*test
C    &           FRCDIQ = 0.9D0,
c*
c
     &           SQMA   = 0.7D0,
c
c maximum number of trials to generate x's for the required number
c of sea quark pairs for a given hadron
     &           NSEATY = 12
C    &           NSEATY = 3
     &          )

      LOGICAL ZUOVP,ZUOSP,ZUOVT,ZUOST,INTLO


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c interface between Glauber formalism and DPM
      COMMON /DTGLIF/ JSSH(MAXNCL),JTSH(MAXNCL),
     &                INTER1(MAXINT),INTER2(MAXINT)

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c threshold values for x-sampling (DTUNUC 1.x)
      COMMON /DTXCUT/ XSEACU,UNON,UNOM,UNOSEA,CVQ,CDQ,CSEA,SSMIMA,
     &                SSMIMQ,VVMTHR

c x-values of partons (DTUNUC 1.x)
      COMMON /DTDPMX/ XPVQ(MAXVQU),XPVD(MAXVQU),
     &                XTVQ(MAXVQU),XTVD(MAXVQU),
     &                XPSQ(MAXSQU),XPSAQ(MAXSQU),
     &                XTSQ(MAXSQU),XTSAQ(MAXSQU)

c flavors of partons (DTUNUC 1.x)
      COMMON /DTDPMF/ IPVQ(MAXVQU),IPPV1(MAXVQU),IPPV2(MAXVQU),
     &                ITVQ(MAXVQU),ITTV1(MAXVQU),ITTV2(MAXVQU),
     &                IPSQ(MAXSQU),IPSQ2(MAXSQU),
     &                IPSAQ(MAXSQU),IPSAQ2(MAXSQU),
     &                ITSQ(MAXSQU),ITSQ2(MAXSQU),
     &                ITSAQ(MAXSQU),ITSAQ2(MAXSQU),
     &                KKPROJ(MAXVQU),KKTARG(MAXVQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPMI/ NVV,NSV,NVS,NSS,NDV,NVD,NDS,NSD,
     &                IXPV,IXPS,IXTV,IXTS,
     &                INTVV1(MAXVQU),INTVV2(MAXVQU),
     &                INTSV1(MAXVQU),INTSV2(MAXVQU),
     &                INTVS1(MAXVQU),INTVS2(MAXVQU),
     &                INTSS1(MAXSQU),INTSS2(MAXSQU),
     &                INTDV1(MAXVQU),INTDV2(MAXVQU),
     &                INTVD1(MAXVQU),INTVD2(MAXVQU),
     &                INTDS1(MAXSQU),INTDS2(MAXSQU),
     &                INTSD1(MAXSQU),INTSD2(MAXSQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPM0/ IFROVP(MAXVQU),ITOVP(MAXVQU),IFROSP(MAXSQU),
     &                IFROVT(MAXVQU),ITOVT(MAXVQU),IFROST(MAXSQU)

c auxiliary common for chain system storage (DTUNUC 1.x)
      COMMON /DTCHSY/ ISKPCH(8,MAXINT),IPOSP(MAXNCL),IPOST(MAXNCL)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      DIMENSION ZUOVP(MAXVQU),ZUOSP(MAXSQU),ZUOVT(MAXVQU),ZUOST(MAXSQU),
     &          INTLO(MAXINT)

c (1) initializations
c-----------------------------------------------------------------------

c*test
      IF (ECM.LT.4.5D0) THEN
C        FRCDIQ = 0.6D0
         FRCDIQ = 0.4D0
      ELSEIF ((ECM.GE.4.5D0).AND.(ECM.LT.7.5)) THEN
C        FRCDIQ = 0.6D0+(ECM-4.5D0)/3.0D0*0.3D0
         FRCDIQ = 0.4D0+(ECM-4.5D0)/3.0D0*0.3D0
      ELSE
C        FRCDIQ = 0.9D0
         FRCDIQ = 0.7D0
      ENDIF
c*
      DO 30 I=1,MAXSQU
         ZUOSP(I) = .FALSE.
         ZUOST(I) = .FALSE.
         IF (I.LE.MAXVQU) THEN
            ZUOVP(I) = .FALSE.
            ZUOVT(I) = .FALSE.
         ENDIF
   30 CONTINUE

c lower thresholds for x-selection
c  sea-quarks       (default: CSEA=0.2)
      IF (ECM.LT.10.0D0) THEN
c*!!test
         XSTHR = ((12.0D0-ECM)/5.0D0+1.0D0)*CSEA/ECM
C        XSTHR = ((12.0D0-ECM)/5.0D0+1.0D0)*CSEA/ECM**2.0D0
         NSEA  = NSEATY
C        XSTHR = ONE/ECM**2
      ELSE
c*sr 30.3.98
C        XSTHR = CSEA/ECM
         XSTHR = CSEA/ECM**2
C        XSTHR = ONE/ECM**2
c*
         IF ((IP.GE.150).AND.(IT.GE.150))
     &      XSTHR = 2.5D0/(ECM*SQRT(ECM))
         NSEA  = NSEATY
      ENDIF
c                   (default: SSMIMA=0.14) used for sea-diquarks (?)
      XSSTHR = SSMIMA/ECM
      BSQMA  = SQMA/ECM
c  valence-quarks   (default: CVQ=1.0)
      XVTHR  = CVQ/ECM
c  valence-diquarks (default: CDQ=2.0)
      XDTHR  = CDQ/ECM

c maximum-x for sea-quarks
      XVCUT  = XVTHR+XDTHR
      XXSEAM = ONE-XVCUT
c*sr 18.4. test: DPMJET
C     XXSEAM=1.0 - XVTHR*(1.D0+0.3D0*DT_RNDM(V1))
C    &            - XDTHR*(1.D0+0.3D0*DT_RNDM(V2))
C    &             -0.01*(1.D0+1.5D0*DT_RNDM(V3))
c*
c maximum number of sea-pairs allowed kinematically
C     NSMAX  = INT(OHALF*XXSEAM/XSTHR)
      RNSMAX = OHALF*XXSEAM/XSTHR
      IF (RNSMAX.GT.10000.0D0) THEN
         NSMAX = 10000
      ELSE
         NSMAX = INT(OHALF*XXSEAM/XSTHR)
      ENDIF
c check kinematical limit for valence-x thresholds
      IF (XVCUT.GT.XVMAX) THEN
         WRITE(ErrorOut,1000) XVCUT,ECM
 1000    FORMAT(' XKSAMP:    KIN. LIMIT FOR VALENCE-X',
     &          '  THRESHOLDS NOT ALLOWED (',2E9.3,')')
cc     &&&&&&
         call cpdpmjetinp
c     &&&&&&&&&&&&
C        XVTHR = XVMAX-XDTHR
C        IF (XVTHR.LT.ZERO) STOP
ccc          &&&&&&&&&& KK
cccc         STOP
      ENDIF

c set eta for valence-x sampling (BETREJ)
c   (UNON per default, UNOM used for projectile mesons only)
      IF ((IJPROJ.NE.0).AND.(IBPROJ.EQ.0)) THEN
         UNOPRV = UNOM
      ELSE
         UNOPRV = UNON
      ENDIF

c (2) select parton x-values of interacting projectile nucleons
c-----------------------------------------------------------------------

      IXPV = 0
      IXPS = 0

      DO 100 IPP=1,IP
c   get interacting projectile nucleon as sampled by Glauber
         IF (JSSH(IPP).NE.0) THEN
            IXSTMP = IXPS
	    IXVTMP = IXPV
   99       CONTINUE
	    IXPS   = IXSTMP
	    IXPV   = IXVTMP
c     JIPP is the actual number of sea-pairs sampled for this nucleon
            JIPP   = MIN(JSSH(IPP)-1,NSMAX)
   41       CONTINUE
            XXSEA  = ZERO
            IF (JIPP.GT.0) THEN
               XSMAX = XXSEAM-2.0D0*DBLE(JIPP)*XSTHR
c???
               IF (XSTHR.GE.XSMAX) THEN
                  JIPP = JIPP-1
                  GOTO 41
               ENDIF

c>>>get x-values of sea-quark pairs
               NSCOUN = 0
               PLW = 0.5D0
   40          CONTINUE
c     accumulator for sea x-values
               XXSEA  = ZERO
               NSCOUN = NSCOUN+1
               IF (DBLE(NSCOUN)/DBLE(NSEA).GT.0.5D0) PLW = 1.0D0
               IF (NSCOUN.GT.NSEA) THEN
c     decrease the number of interactions after NSEA trials
                  JIPP   = JIPP-1
                  NSCOUN = 0
               ENDIF
               DO 70 ISQ=1,JIPP
c     sea-quarks
                  IF (IPSQ(IXPS+1).LE.2) THEN
c*sr 8.4.98 (1/sqrt(x))
C                    XPSQI = DT_SAMPEX(XSTHR,XSMAX)
C                    XPSQI = DT_SAMSQX(XSTHR,XSMAX)
                     XPSQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                  ELSE
                     IF (XSMAX.GT.XSTHR+BSQMA) THEN
                        XPSQI = DT_SAMPXB(XSTHR+BSQMA,XSMAX,BSQMA)
                     ELSE
c*sr 8.4.98 (1/sqrt(x))
C                       XPSQI = DT_SAMPEX(XSTHR,XSMAX)
C                       XPSQI = DT_SAMSQX(XSTHR,XSMAX)
                        XPSQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                     ENDIF
                  ENDIF
c     sea-antiquarks
                  IF (IPSAQ(IXPS+1).GE.-2) THEN
c*sr 8.4.98 (1/sqrt(x))
C                    XPSAQI = DT_SAMPEX(XSTHR,XSMAX)
C                    XPSAQI = DT_SAMSQX(XSTHR,XSMAX)
                     XPSAQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                  ELSE
                     IF (XSMAX.GT.XSTHR+BSQMA) THEN
                        XPSAQI = DT_SAMPXB(XSTHR+BSQMA,XSMAX,BSQMA)
                     ELSE
c*sr 8.4.98 (1/sqrt(x))
C                       XPSAQI = DT_SAMPEX(XSTHR,XSMAX)
C                       XPSAQI = DT_SAMSQX(XSTHR,XSMAX)
                        XPSAQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                     ENDIF
                  ENDIF
                  XXSEA = XXSEA+XPSQI+XPSAQI
c     check for maximum allowed sea x-value
                  IF (XXSEA.GE.XXSEAM) THEN
                     IXPS = IXPS-ISQ+1
                     GOTO 40
                  ENDIF
c     accept this sea-quark pair
                  IXPS         = IXPS+1
                  XPSQ(IXPS)   = XPSQI
                  XPSAQ(IXPS)  = XPSAQI
                  IFROSP(IXPS) = IPP
                  ZUOSP(IXPS)  = .TRUE.
   70          CONTINUE
            ENDIF

c>>>get x-values of valence partons
c     valence quark
            IF (XVTHR.GT.0.05D0) THEN
               XVHI  = ONE-XXSEA-XDTHR
               XPVQI = DT_BETREJ(OHALF,UNOPRV,XVTHR,XVHI)
            ELSE
   90          CONTINUE
               XPVQI = DT_DBETAR(OHALF,UNOPRV)
               IF ((XPVQI.LT.XVTHR).OR.(ONE-XPVQI-XXSEA.LT.XDTHR))
     &                                                     GOTO 90
            ENDIF
c     valence diquark
            XPVDI = ONE-XPVQI-XXSEA
c       reject according to x**1.5
            XDTMP = XPVDI**1.5D0
	    IF (DT_RNDM(XPVDI).GT.XDTMP) GOTO 99
c     accept these valence partons
            IXPV         = IXPV+1
            XPVQ(IXPV)   = XPVQI
            XPVD(IXPV)   = XPVDI
            IFROVP(IXPV) = IPP
            ITOVP(IPP)   = IXPV
            ZUOVP(IXPV)  = .TRUE.

         ENDIF
  100 CONTINUE

c (3) select parton x-values of interacting target nucleons
c-----------------------------------------------------------------------

      IXTV = 0
      IXTS = 0

      DO 170 ITT=1,IT
c   get interacting target nucleon as sampled by Glauber
         IF (JTSH(ITT).NE.0) THEN
            IXSTMP = IXTS
	    IXVTMP = IXTV
  169       CONTINUE
	    IXTS   = IXSTMP
	    IXTV   = IXVTMP
c     JITT is the actual number of sea-pairs sampled for this nucleon
            JITT   = MIN(JTSH(ITT)-1,NSMAX)
  111       CONTINUE
            XXSEA  = ZERO
            IF (JITT.GT.0) THEN
               XSMAX = XXSEAM-2.0D0*DBLE(JITT)*XSTHR
c???
               IF (XSTHR.GE.XSMAX) THEN
                  JITT = JITT-1
                  GOTO 111
               ENDIF

c>>>get x-values of sea-quark pairs
               NSCOUN = 0
               PLW = 0.5D0
  110          CONTINUE
c     accumulator for sea x-values
               XXSEA  = ZERO
               NSCOUN = NSCOUN+1
               IF (DBLE(NSCOUN)/DBLE(NSEA).GT.0.5D0) PLW = 1.0D0
               IF (NSCOUN.GT.NSEA)THEN
c     decrease the number of interactions after NSEA trials
                  JITT   = JITT-1
                  NSCOUN = 0
               ENDIF
               DO 140 ISQ=1,JITT
c     sea-quarks
                  IF (ITSQ(IXTS+1).LE.2) THEN
c*sr 8.4.98 (1/sqrt(x))
C                    XTSQI = DT_SAMPEX(XSTHR,XSMAX)
C                    XTSQI = DT_SAMSQX(XSTHR,XSMAX)
                     XTSQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                  ELSE
                     IF (XSMAX.GT.XSTHR+BSQMA) THEN
                        XTSQI = DT_SAMPXB(XSTHR+BSQMA,XSMAX,BSQMA)
                     ELSE
c*sr 8.4.98 (1/sqrt(x))
C                       XTSQI = DT_SAMPEX(XSTHR,XSMAX)
C                       XTSQI = DT_SAMSQX(XSTHR,XSMAX)
                        XTSQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                     ENDIF
                  ENDIF
c     sea-antiquarks
                  IF (ITSAQ(IXTS+1).GE.-2) THEN
c*sr 8.4.98 (1/sqrt(x))
C                    XTSAQI = DT_SAMPEX(XSTHR,XSMAX)
C                    XTSAQI = DT_SAMSQX(XSTHR,XSMAX)
                     XTSAQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                  ELSE
                     IF (XSMAX.GT.XSTHR+BSQMA) THEN
                        XTSAQI = DT_SAMPXB(XSTHR+BSQMA,XSMAX,BSQMA)
                     ELSE
c*sr 8.4.98 (1/sqrt(x))
C                       XTSAQI = DT_SAMPEX(XSTHR,XSMAX)
C                       XTSAQI = DT_SAMSQX(XSTHR,XSMAX)
                        XTSAQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                     ENDIF
                  ENDIF
                  XXSEA = XXSEA+XTSQI+XTSAQI
c     check for maximum allowed sea x-value
                  IF (XXSEA.GE.XXSEAM) THEN
                     IXTS = IXTS-ISQ+1
                     GOTO 110
                  ENDIF
c     accept this sea-quark pair
                  IXTS         = IXTS+1
                  XTSQ(IXTS)   = XTSQI
                  XTSAQ(IXTS)  = XTSAQI
                  IFROST(IXTS) = ITT
                  ZUOST(IXTS)  = .TRUE.
  140          CONTINUE
            ENDIF

c>>>get x-values of valence partons
c     valence quark
            IF (XVTHR.GT.0.05D0) THEN
               XVHI  = ONE-XXSEA-XDTHR
               XTVQI = DT_BETREJ(OHALF,UNON,XVTHR,XVHI)
            ELSE
  160          CONTINUE
               XTVQI = DT_DBETAR(OHALF,UNON)
               IF ((XTVQI.LT.XVTHR).OR.(ONE-XTVQI-XXSEA.LT.XDTHR))
     &                                                    GOTO 160
            ENDIF
c     valence diquark
            XTVDI = ONE-XTVQI-XXSEA
c       reject according to x**1.5
            XDTMP = XTVDI**1.5D0
	    IF (DT_RNDM(XPVDI).GT.XDTMP) GOTO 169
c     accept these valence partons
            IXTV         = IXTV+1
            XTVQ(IXTV)   = XTVQI
            XTVD(IXTV)   = XTVDI
            IFROVT(IXTV) = ITT
            ITOVT(ITT)   = IXTV
            ZUOVT(IXTV)  = .TRUE.

         ENDIF
  170 CONTINUE

c (4) get valence-valence chains
c-----------------------------------------------------------------------

      NVV = 0
      DO 240 I=1,NN
         INTLO(I) = .TRUE.
         IPVAL    = ITOVP(INTER1(I))
         ITVAL    = ITOVT(INTER2(I))
         IF (ZUOVP(IPVAL).AND.ZUOVT(ITVAL)) THEN
            INTLO(I)      = .FALSE.
            ZUOVP(IPVAL)  = .FALSE.
            ZUOVT(ITVAL)  = .FALSE.
            NVV           = NVV+1
            ISKPCH(8,NVV) = 0
            INTVV1(NVV)   = IPVAL
            INTVV2(NVV)   = ITVAL
         ENDIF
  240 CONTINUE

c (5) get sea-valence chains
c-----------------------------------------------------------------------

      NSV = 0
      NDV = 0
      PLW = 0.5D0
      DO 270 I=1,NN
         IF (INTLO(I)) THEN
            IPVAL = ITOVP(INTER1(I))
            ITVAL = ITOVT(INTER2(I))
            DO 250 J=1,IXPS
               IF (ZUOSP(J).AND.(IFROSP(J).EQ.INTER1(I)).AND.
     &                                ZUOVT(ITVAL)) THEN
                  ZUOSP(J)     = .FALSE.
                  ZUOVT(ITVAL) = .FALSE.
                  INTLO(I)     = .FALSE.
                  IF (LSEADI.AND.(DT_RNDM(PLW).GT.FRCDIQ)) THEN
c   sample sea-diquark pair
                     CALL DT_SAMSDQ(ECM,ITVAL,J,2,IREJ1)
                     IF (IREJ1.EQ.0) GOTO 260
                  ENDIF
                  NSV           = NSV+1
                  ISKPCH(4,NSV) = 0
                  INTSV1(NSV)   = J
                  INTSV2(NSV)   = ITVAL

c>>>correct chain kinematics according to minimum chain masses
c     the actual chain masses
                  AMSVQ1 = XPSQ(J) *XTVD(ITVAL)*ECM**2
                  AMSVQ2 = XPSAQ(J)*XTVQ(ITVAL)*ECM**2
c     get lower mass cuts
                  IF (IPSQ(J).EQ.3) THEN
c       q being s-quark
                     AMCHK1 = AMAS
                     AMCHK2 = AMIS
                  ELSE
c       q being u/d-quark
                     AMCHK1 = AMAU
                     AMCHK2 = AMIU
                  ENDIF
c       q-qq chain
c         chain mass above minimum - resampling of sea-q x-value
                  IF (AMSVQ1.GT.AMCHK1) THEN
                     XPSQTH      = AMCHK1/(XTVD(ITVAL)*ECM**2)
c*sr 8.4.98 (1/sqrt(x))
C                    XPSQXX      = DT_SAMPEX(XPSQTH,XPSQ(J))
C                    XPSQXX      = DT_SAMSQX(XPSQTH,XPSQ(J))
                     XPSQXX      = DT_SAMPLW(XPSQTH,XPSQ(J),PLW)
c*
                     XPVD(IPVAL) = XPVD(IPVAL)+XPSQ(J)-XPSQXX
                     XPSQ(J)     = XPSQXX
c         chain mass below minimum - reset sea-q x-value and correct
c                                    diquark-x of the same nucleon
                  ELSEIF (AMSVQ1.LT.AMCHK1) THEN
                     XPSQW       = AMCHK1/(XTVD(ITVAL)*ECM**2)
                     DXPSQ       = XPSQW-XPSQ(J)
                     IF (XPVD(IPVAL).GE.XDTHR+DXPSQ) THEN
                        XPVD(IPVAL) = XPVD(IPVAL)-DXPSQ
                        XPSQ(J)     = XPSQW
                     ENDIF
                  ENDIF
c       aq-q chain
c         chain mass below minimum - reset sea-aq x-value and correct
c                                    diquark-x of the same nucleon
                  IF (AMSVQ2.LT.AMCHK2) THEN
                     XPSQW = AMCHK2/(XTVQ(ITVAL)*ECM**2)
                     DXPSQ = XPSQW-XPSAQ(J)
                     IF (XPVD(IPVAL).GE.XDTHR+DXPSQ) THEN
                        XPVD(IPVAL) = XPVD(IPVAL)-DXPSQ
                        XPSAQ(J)    = XPSQW
                     ENDIF
                  ENDIF
c>>>end of chain mass correction

                  GOTO 260
               ENDIF
  250       CONTINUE
         ENDIF
  260    CONTINUE
  270 CONTINUE

c (6) get valence-sea chains
c-----------------------------------------------------------------------

      NVS = 0
      NVD = 0
      DO 300 I=1,NN
         IF (INTLO(I)) THEN
            IPVAL = ITOVP(INTER1(I))
            ITVAL = ITOVT(INTER2(I))
            DO 280 J=1,IXTS
               IF (ZUOVP(IPVAL).AND.ZUOST(J).AND.
     &                  (IFROST(J).EQ.INTER2(I))) THEN
                  ZUOST(J)     = .FALSE.
                  ZUOVP(IPVAL) = .FALSE.
                  INTLO(I)     = .FALSE.
                  IF (LSEADI.AND.(DT_RNDM(ECM).GT.FRCDIQ)) THEN
c   sample sea-diquark pair
                     CALL DT_SAMSDQ(ECM,IPVAL,J,1,IREJ1)
                     IF (IREJ1.EQ.0) GOTO 290
                  ENDIF
                  NVS           = NVS + 1
                  ISKPCH(6,NVS) = 0
                  INTVS1(NVS)   = IPVAL
                  INTVS2(NVS)   = J

c>>>correct chain kinematics according to minimum chain masses
c     the actual chain masses
                  AMVSQ1 = XPVQ(IPVAL)*XTSAQ(J)*ECM**2
                  AMVSQ2 = XPVD(IPVAL)*XTSQ(J) *ECM**2
c     get lower mass cuts
                  IF (ITSQ(J).EQ.3) THEN
c       q being s-quark
                     AMCHK1 = AMIS
                     AMCHK2 = AMAS
                  ELSE
c       q being u/d-quark
                     AMCHK1 = AMIU
                     AMCHK2 = AMAU
                  ENDIF
c       q-aq chain
c         chain mass below minimum - reset sea-aq x-value and correct
c                                    diquark-x of the same nucleon
                  IF (AMVSQ1.LT.AMCHK1) THEN
                     XTSQW = AMCHK1/(XPVQ(IPVAL)*ECM**2)
                     DXTSQ = XTSQW-XTSAQ(J)
                     IF (XTVD(ITVAL).GE.XDTHR+DXTSQ) THEN
                        XTVD(ITVAL) = XTVD(ITVAL)-DXTSQ
                        XTSAQ(J)    = XTSQW
                     ENDIF
                  ENDIF
c       qq-q chain
c         chain mass above minimum - resampling of sea-q x-value
                  IF (AMVSQ2.GT.AMCHK2) THEN
                     XTSQTH      = AMCHK2/(XPVD(IPVAL)*ECM**2)
c*sr 8.4.98 (1/sqrt(x))
C                    XTSQXX      = DT_SAMPEX(XTSQTH,XTSQ(J))
C                    XTSQXX      = DT_SAMSQX(XTSQTH,XTSQ(J))
                     XTSQXX      = DT_SAMPLW(XTSQTH,XTSQ(J),PLW)
c*
                     XTVD(ITVAL) = XTVD(ITVAL)+XTSQ(J)-XTSQXX
                     XTSQ(J)     = XTSQXX
c         chain mass below minimum - reset sea-q x-value and correct
c                                    diquark-x of the same nucleon
                  ELSEIF (AMVSQ2.LT.AMCHK2) THEN
                     XTSQW       = AMCHK2/(XPVD(IPVAL)*ECM**2)
                     DXTSQ       = XTSQW-XTSQ(J)
                     IF (XTVD(ITVAL).GE.XDTHR+DXTSQ) THEN
                        XTVD(ITVAL) = XTVD(ITVAL)-DXTSQ
                        XTSQ(J)     = XTSQW
                     ENDIF
                  ENDIF
c>>>end of chain mass correction

                  GOTO 290
               ENDIF
  280       CONTINUE
         ENDIF
  290    CONTINUE
  300 CONTINUE

c (7) get sea-sea chains
c-----------------------------------------------------------------------

      NSS = 0
      NDS = 0
      NSD = 0
      DO 420 I=1,NN
         IF (INTLO(I)) THEN
            IPVAL = ITOVP(INTER1(I))
            ITVAL = ITOVT(INTER2(I))
c   loop over target partons not yet matched
            DO 400 J=1,IXTS
               IF (ZUOST(J).AND.(IFROST(J).EQ.INTER2(I))) THEN
c   loop over projectile partons not yet matched
                  DO 390 JJ=1,IXPS
                     IF (ZUOSP(JJ).AND.(IFROSP(JJ).EQ.INTER1(I))) THEN
                        ZUOSP(JJ)     = .FALSE.
                        ZUOST(J)      = .FALSE.
                        INTLO(I)      = .FALSE.
                        NSS           = NSS+1
                        ISKPCH(1,NSS) = 0
                        INTSS1(NSS)   = JJ
                        INTSS2(NSS)   = J

c---->chain recombination option
                        VALFRA        = DBLE(NVV/(NVV+IXPS+IXTS))
                        IF (IRECOM.EQ.1.AND.(DT_RNDM(BSQMA).GT.VALFRA))
     &                                                             THEN
c       sea-sea chains may recombine with valence-valence chains
c       only if they have the same projectile or target nucleon
                           DO 4201 IVV=1,NVV
                              IF (ISKPCH(8,IVV).NE.99) THEN
                                 IXVPR = INTVV1(IVV)
                                 IXVTA = INTVV2(IVV)
                                 IF ((INTER1(I).EQ.IFROVP(IXVPR)).OR.
     &                               (INTER2(I).EQ.IFROVT(IXVTA))) THEN
c         recombination possible, drop old v-v and s-s chains
                                    ISKPCH(1,NSS) = 99
                                    ISKPCH(8,IVV) = 99

c         (a) assign new s-v chains
c         ~~~~~~~~~~~~~~~~~~~~~~~~~
                                    IF (LSEADI.AND.
     &                                  (DT_RNDM(VALFRA).GT.FRCDIQ))
     &                                                             THEN
c           sample sea-diquark pair
                                       CALL DT_SAMSDQ(ECM,IXVTA,JJ,2,
     &                                                      IREJ1)
                                       IF (IREJ1.EQ.0) GOTO 4202
                                    ENDIF
                                    NSV           = NSV+1
                                    ISKPCH(4,NSV) = 0
                                    INTSV1(NSV)   = JJ
                                    INTSV2(NSV)   = IXVTA
c>>>>>>>>>>>correct chain kinematics according to minimum chain masses
c           the actual chain masses
                                    AMSVQ1 = XPSQ(JJ) *XTVD(IXVTA)
     &                                                     *ECM**2
                                    AMSVQ2 = XPSAQ(JJ)*XTVQ(IXVTA)
     &                                                     *ECM**2
c           get lower mass cuts
                                    IF (IPSQ(JJ).EQ.3) THEN
c             q being s-quark
                                       AMCHK1 = AMAS
                                       AMCHK2 = AMIS
                                    ELSE
c             q being u/d-quark
                                       AMCHK1 = AMAU
                                       AMCHK2 = AMIU
                                    ENDIF
c           q-qq chain
c             chain mass above minimum - resampling of sea-q x-value
                                    IF (AMSVQ1.GT.AMCHK1) THEN
                                       XPSQTH      =
     &                                    AMCHK1/(XTVD(IXVTA)*ECM**2)
c*sr 8.4.98 (1/sqrt(x))
                                       XPSQXX      =
     &                                    DT_SAMPLW(XPSQTH,XPSQ(JJ),PLW)
C    &                                    DT_SAMSQX(XPSQTH,XPSQ(JJ))
C    &                                    DT_SAMPEX(XPSQTH,XPSQ(JJ))
c*
                                       XPVD(IPVAL) =
     &                                    XPVD(IPVAL)+XPSQ(JJ)-XPSQXX
                                       XPSQ(JJ)    = XPSQXX
c             chain mass below minimum - reset sea-q x-value and correct
c                                        diquark-x of the same nucleon
                                    ELSEIF (AMSVQ1.LT.AMCHK1) THEN
                                       XPSQW =
     &                                    AMCHK1/(XTVD(IXVTA)*ECM**2)
                                       DXPSQ = XPSQW-XPSQ(JJ)
                                       IF (XPVD(IPVAL).GE.XDTHR+DXPSQ)
     &                                                            THEN
                                          XPVD(IPVAL) =
     &                                       XPVD(IPVAL)-DXPSQ
                                          XPSQ(JJ)    = XPSQW
                                       ENDIF
                                    ENDIF
c           aq-q chain
c             chain mass below minimum - reset sea-aq x-value and correct
c                                        diquark-x of the same nucleon
                                    IF (AMSVQ2.LT.AMCHK2) THEN
                                       XPSQW =
     &                                    AMCHK2/(XTVQ(IXVTA)*ECM**2)
                                       DXPSQ = XPSQW-XPSAQ(JJ)
                                       IF (XPVD(IPVAL).GE.XDTHR+DXPSQ)
     &                                                            THEN
                                          XPVD(IPVAL) =
     &                                       XPVD(IPVAL)-DXPSQ
                                          XPSAQ(JJ)   = XPSQW
                                       ENDIF
                                    ENDIF
c>>>>>>>>>>>end of chain mass correction
 4202                               CONTINUE

c         (b) assign new v-s chains
c         ~~~~~~~~~~~~~~~~~~~~~~~~~
                                    IF (LSEADI.AND.(
     &                                  DT_RNDM(AMSVQ2).GT.FRCDIQ))
     &                                                             THEN
c           sample sea-diquark pair
                                       CALL DT_SAMSDQ(ECM,IXVPR,J,1,
     &                                                      IREJ1)
                                       IF (IREJ1.EQ.0) GOTO 4203
                                    ENDIF
                                    NVS           = NVS+1
                                    ISKPCH(6,NVS) = 0
                                    INTVS1(NVS)   = IXVPR
                                    INTVS2(NVS)   = J
c>>>>>>>>>>>correct chain kinematics according to minimum chain masses
c           the actual chain masses
                                    AMVSQ1 = XPVQ(IXVPR)*XTSAQ(J)*ECM**2
                                    AMVSQ2 = XPVD(IXVPR)*XTSQ(J) *ECM**2
c           get lower mass cuts
                                    IF (ITSQ(J).EQ.3) THEN
c             q being s-quark
                                       AMCHK1 = AMIS
                                       AMCHK2 = AMAS
                                    ELSE
c             q being u/d-quark
                                       AMCHK1 = AMIU
                                       AMCHK2 = AMAU
                                    ENDIF
c           q-aq chain
c             chain mass below minimum - reset sea-aq x-value and correct
c                                        diquark-x of the same nucleon
                                    IF (AMVSQ1.LT.AMCHK1) THEN
                                       XTSQW =
     &                                    AMCHK1/(XPVQ(IXVPR)*ECM**2)
                                       DXTSQ = XTSQW-XTSAQ(J)
                                       IF (XTVD(ITVAL).GE.XDTHR+DXTSQ)
     &                                                            THEN
                                          XTVD(ITVAL) =
     &                                       XTVD(ITVAL)-DXTSQ
                                          XTSAQ(J)    = XTSQW
                                       ENDIF
                                    ENDIF
                                    IF (AMVSQ2.GT.AMCHK2) THEN
                                       XTSQTH      =
     &                                    AMCHK2/(XPVD(IXVPR)*ECM**2)
c*sr 8.4.98 (1/sqrt(x))
                                       XTSQXX      =
     &                                    DT_SAMPLW(XTSQTH,XTSQ(J),PLW)
C    &                                    DT_SAMSQX(XTSQTH,XTSQ(J))
C    &                                    DT_SAMPEX(XTSQTH,XTSQ(J))
c*
                                       XTVD(ITVAL) =
     &                                    XTVD(ITVAL)+XTSQ(J)-XTSQXX
                                       XTSQ(J)     = XTSQXX
                                    ELSEIF (AMVSQ2.LT.AMCHK2) THEN
                                       XTSQW =
     &                                    AMCHK2/(XPVD(IXVPR)*ECM**2)
                                       DXTSQ = XTSQW-XTSQ(J)
                                       IF (XTVD(ITVAL).GE.XDTHR+DXTSQ)
     &                                                            THEN
                                          XTVD(ITVAL) =
     &                                       XTVD(ITVAL)-DXTSQ
                                          XTSQ(J)     = XTSQW
                                       ENDIF
                                    ENDIF
c>>>>>>>>>end of chain mass correction
 4203                               CONTINUE
c       jump out of s-s chain loop
                                    GOTO 420
                                 ENDIF
                              ENDIF
 4201                      CONTINUE
                        ENDIF
c---->end of chain recombination option

c     sample sea-diquark pair (projectile)
                        IF (LSEADI.AND.(DT_RNDM(BSQMA).GT.FRCDIQ)) THEN
                           CALL DT_SAMSDQ(ECM,J,JJ,4,IREJ1)
                           IF (IREJ1.EQ.0) THEN
                              ISKPCH(1,NSS) = 99
                              GOTO 410
                           ENDIF
                        ENDIF
c     sample sea-diquark pair (target)
                        IF (LSEADI.AND.(DT_RNDM(ECM).GT.FRCDIQ)) THEN
                           CALL DT_SAMSDQ(ECM,JJ,J,3,IREJ1)
                           IF (IREJ1.EQ.0) THEN
                              ISKPCH(1,NSS) = 99
                              GOTO 410
                           ENDIF
                        ENDIF
c>>>>>correct chain kinematics according to minimum chain masses
c     the actual chain masses
                        SSMA1Q = XPSQ(JJ) *XTSAQ(J)*ECM**2
                        SSMA2Q = XPSAQ(JJ)*XTSQ(J) *ECM**2
c     check for lower mass cuts
                        IF ((SSMA1Q.LT.SSMIMQ).OR.
     &                      (SSMA2Q.LT.SSMIMQ)) THEN
                           IPVAL = ITOVP(INTER1(I))
                           ITVAL = ITOVT(INTER2(I))
                           IF ((XPVD(IPVAL).GT.XDTHR+3.5D0*XSSTHR).AND.
     &                         (XTVD(ITVAL).GT.XDTHR+3.5D0*XSSTHR))THEN
c       maximum allowed x values for sea quarks
                              XSPMAX = ONE-XPVQ(IPVAL)-XDTHR-
     &                                           1.2D0*XSSTHR
                              XSTMAX = ONE-XTVQ(ITVAL)-XDTHR-
     &                                           1.2D0*XSSTHR
c       resampling of x values not possible - skip sea-sea chains
                              IF ((XSPMAX.LE.XSSTHR+0.05D0).OR.
     &                            (XSTMAX.LE.XSSTHR+0.05D0)) GOTO 380
c       resampling of x for projectile sea quark pair
                              ICOUS = 0
  310                         CONTINUE
                              ICOUS = ICOUS+1
                              IF (XSSTHR.GT.0.05D0) THEN
                                 XPSQI =DT_BETREJ(XSEACU,UNOSEA,XSSTHR,
     &                                                         XSPMAX)
                                 XPSAQI=DT_BETREJ(XSEACU,UNOSEA,XSSTHR,
     &                                                         XSPMAX)
                              ELSE
  320                            CONTINUE
                                 XPSQI = DT_DBETAR(XSEACU,UNOSEA)
                                 IF ((XPSQI.LT.XSSTHR).OR.
     &                               (XPSQI.GT.XSPMAX))  GOTO 320
  330                            CONTINUE
                                 XPSAQI = DT_DBETAR(XSEACU,UNOSEA)
                                 IF ((XPSAQI.LT.XSSTHR).OR.
     &                               (XPSAQI.GT.XSPMAX)) GOTO 330
                              ENDIF
c       final test of remaining x for projectile diquark
                              XPVDCO = XPVD(IPVAL)-XPSQI-XPSAQI
     &                                            +XPSQ(JJ)+XPSAQ(JJ)
                              IF (XPVDCO.LE.XDTHR) THEN
c!!!
C                                IF (ICOUS.LT.5) GOTO 310
                                 IF (ICOUS.LT.0.5D0) GOTO 310
                                 GOTO 380
                              ENDIF
c       resampling of x for target sea quark pair
                              ICOUS = 0
  350                         CONTINUE
                              ICOUS = ICOUS+1
                              IF (XSSTHR.GT.0.05D0) THEN
                                 XTSQI =DT_BETREJ(XSEACU,UNOSEA,XSSTHR,
     &                                                         XSTMAX)
                                 XTSAQI=DT_BETREJ(XSEACU,UNOSEA,XSSTHR,
     &                                                         XSTMAX)
                              ELSE
  360                            CONTINUE
                                 XTSQI = DT_DBETAR(XSEACU,UNOSEA)
                                 IF ((XTSQI.LT.XSSTHR).OR.
     &                               (XTSQI.GT.XSTMAX))  GOTO 360
  370                            CONTINUE
                                 XTSAQI = DT_DBETAR(XSEACU,UNOSEA)
                                 IF ((XTSAQI.LT.XSSTHR).OR.
     &                               (XTSAQI.GT.XSTMAX)) GOTO 370
                              ENDIF
c       final test of remaining x for target diquark
                              XTVDCO = XTVD(ITVAL)-XTSQI-XTSAQI
     &                                            +XTSQ(J)+XTSAQ(J)
                              IF (XTVDCO.LT.XDTHR) THEN
                                 IF (ICOUS.LT.5) GOTO 350
                                 GOTO 380
                              ENDIF
                              XPVD(IPVAL) = XPVDCO
                              XTVD(ITVAL) = XTVDCO
                              XPSQ(JJ)    = XPSQI
                              XPSAQ(JJ)   = XPSAQI
                              XTSQ(J)     = XTSQI
                              XTSAQ(J)    = XTSAQI
c>>>>>end of chain mass correction
                              GOTO 410
                           ENDIF
c     come here to discard s-s interaction
c     resampling of x values not allowed or unsuccessful
  380                      CONTINUE
                           INTLO(I)  = .FALSE.
                           ZUOST(J)  = .TRUE.
                           ZUOSP(JJ) = .TRUE.
                           NSS       = NSS-1
                        ENDIF
c   consider next s-s interaction
                        GOTO 410
                     ENDIF
  390             CONTINUE
               ENDIF
  400       CONTINUE
         ENDIF
  410    CONTINUE
  420 CONTINUE

c correct x-values of valence quarks for non-matching sea quarks
      DO 430 I=1,IXPS
         IF (ZUOSP(I)) THEN
            IPVAL       = ITOVP(IFROSP(I))
            XPVQ(IPVAL) = XPVQ(IPVAL)+XPSQ(I)+XPSAQ(I)
            XPSQ(I)     = ZERO
            XPSAQ(I)    = ZERO
            ZUOSP(I)    = .FALSE.
         ENDIF
  430 CONTINUE
      DO 440 I=1,IXTS
         IF (ZUOST(I)) THEN
            ITVAL       = ITOVT(IFROST(I))
            XTVQ(ITVAL) = XTVQ(ITVAL)+XTSQ(I)+XTSAQ(I)
            XTSQ(I)     = ZERO
            XTSAQ(I)    = ZERO
            ZUOST(I)    = .FALSE.
         ENDIF
  440 CONTINUE
      DO 450 I=1,IXPV
         IF (ZUOVP(I)) ISTHKK(IFROVP(I)) = 13
  450 CONTINUE
      DO 460 I=1,IXTV
         IF (ZUOVT(I)) ISTHKK(IFROVT(I)+IP) = 14
  460 CONTINUE

      RETURN
      END
c
c===samsdq=============================================================*
c
CDECK  ID>, DT_SAMSDQ
      SUBROUTINE DT_SAMSDQ(ECM,IDX1,IDX2,MODE,IREJ)

c***********************************************************************
c SAMpling of Sea-DiQuarks                                             *
c              ECM        cm-energy of the nucleon-nucleon system      *
c              IDX1,2     indices of x-values of the participating     *
c                         partons (IDX2 is always the sea-q-pair to be *
c                         changed to sea-qq-pair)                      *
c              MODE       = 1  valence-q - sea-diq                     *
c                         = 2  sea-diq   - valence-q                   *
c                         = 3  sea-q     - sea-diq                     *
c                         = 4  sea-diq   - sea-q                       *
c Based on DIQVS, DIQSV, DIQSSD, DIQDSS.                               *
c This version dated 17.10.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (ZERO=0.0D0)

c threshold values for x-sampling (DTUNUC 1.x)
      COMMON /DTXCUT/ XSEACU,UNON,UNOM,UNOSEA,CVQ,CDQ,CSEA,SSMIMA,
     &                SSMIMQ,VVMTHR

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c x-values of partons (DTUNUC 1.x)
      COMMON /DTDPMX/ XPVQ(MAXVQU),XPVD(MAXVQU),
     &                XTVQ(MAXVQU),XTVD(MAXVQU),
     &                XPSQ(MAXSQU),XPSAQ(MAXSQU),
     &                XTSQ(MAXSQU),XTSAQ(MAXSQU)

c flavors of partons (DTUNUC 1.x)
      COMMON /DTDPMF/ IPVQ(MAXVQU),IPPV1(MAXVQU),IPPV2(MAXVQU),
     &                ITVQ(MAXVQU),ITTV1(MAXVQU),ITTV2(MAXVQU),
     &                IPSQ(MAXSQU),IPSQ2(MAXSQU),
     &                IPSAQ(MAXSQU),IPSAQ2(MAXSQU),
     &                ITSQ(MAXSQU),ITSQ2(MAXSQU),
     &                ITSAQ(MAXSQU),ITSAQ2(MAXSQU),
     &                KKPROJ(MAXVQU),KKTARG(MAXVQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPMI/ NVV,NSV,NVS,NSS,NDV,NVD,NDS,NSD,
     &                IXPV,IXPS,IXTV,IXTS,
     &                INTVV1(MAXVQU),INTVV2(MAXVQU),
     &                INTSV1(MAXVQU),INTSV2(MAXVQU),
     &                INTVS1(MAXVQU),INTVS2(MAXVQU),
     &                INTSS1(MAXSQU),INTSS2(MAXSQU),
     &                INTDV1(MAXVQU),INTDV2(MAXVQU),
     &                INTVD1(MAXVQU),INTVD2(MAXVQU),
     &                INTDS1(MAXSQU),INTDS2(MAXSQU),
     &                INTSD1(MAXSQU),INTSD2(MAXSQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPM0/ IFROVP(MAXVQU),ITOVP(MAXVQU),IFROSP(MAXSQU),
     &                IFROVT(MAXVQU),ITOVT(MAXVQU),IFROST(MAXSQU)

c auxiliary common for chain system storage (DTUNUC 1.x)
      COMMON /DTCHSY/ ISKPCH(8,MAXINT),IPOSP(MAXNCL),IPOST(MAXNCL)


      IREJ = 0
c  threshold-x for valence diquarks
      XDTHR = CDQ/ECM

      GOTO (1,2,3,4) MODE

c---------------------------------------------------------------------
c proj. valence partons - targ. sea partons
c get x-values and flavors for target sea-diquark pair

    1 CONTINUE
      IDXVP = IDX1
      IDXST = IDX2

c  index of corr. val-diquark-x in target nucleon
      IDXVT = ITOVT(IFROST(IDXST))
c  available x above diquark thresholds for valence- and sea-diquarks
      XXD   = XTVD(IDXVT)+XTSQ(IDXST)+XTSAQ(IDXST)-3.0D0*XDTHR

      IF (XXD.GE.ZERO) THEN
c  x-values for the three diquarks of the target nucleon
         RR1    = DT_RNDM(XXD)
         RR2    = DT_RNDM(RR1)
         RR3    = DT_RNDM(RR2)
         SR123  = RR1+RR2+RR3
         XXTV   = XDTHR+RR1*XXD/SR123
         XXTSQ  = XDTHR+RR2*XXD/SR123
         XXTSAQ = XDTHR+RR3*XXD/SR123
      ELSE
         XXTV   = XTVD(IDXVT)
         XXTSQ  = XTSQ(IDXST)
         XXTSAQ = XTSAQ(IDXST)
      ENDIF
c  flavor of the second quarks in the sea-diquark pair
      ITSQ2(IDXST)  = INT(1.0D0+DT_RNDM(RR3)*(2.0D0+SEASQ))
      ITSAQ2(IDXST) = -ITSQ2(IDXST)
c  check masses of the new val-q - sea-qq, val-qq - sea-aqaq chains
      AM1    = XXTSQ *XPVQ(IDXVP)*ECM**2
      AM2    = XXTSAQ*XPVD(IDXVP)*ECM**2
      IF ( (ITSQ(IDXST).EQ.3).AND.(ITSQ2(IDXST).EQ.3).AND.
c    ss-asas pair
     &     ((AM2.LE.18.0D0).OR.(AM1.LE.6.6D0))            ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( ((ITSQ(IDXST).EQ.3).OR.(ITSQ2(IDXST).EQ.3)).AND.
c    at least one strange quark
     &         ((AM2.LE.14.6D0).OR.(AM1.LE.5.8D0))        ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( (AM2.LE.13.4D0).OR.(AM1.LE.5.0D0) ) THEN
         IREJ = 1
         RETURN
      ENDIF
c  accept the new sea-diquark
      XTVD(IDXVT)   = XXTV
      XTSQ(IDXST)   = XXTSQ
      XTSAQ(IDXST)  = XXTSAQ
      NVD           = NVD+1
      INTVD1(NVD)   = IDXVP
      INTVD2(NVD)   = IDXST
      ISKPCH(7,NVD) = 0
      RETURN

c---------------------------------------------------------------------
c proj. sea partons - targ. valence partons
c get x-values and flavors for projectile sea-diquark pair

    2 CONTINUE
      IDXSP = IDX2
      IDXVT = IDX1

c  index of corr. val-diquark-x in projectile nucleon
      IDXVP = ITOVP(IFROSP(IDXSP))
c  available x above diquark thresholds for valence- and sea-diquarks
      XXD   = XPVD(IDXVP)+XPSQ(IDXSP)+XPSAQ(IDXSP)-3.0D0*XDTHR

      IF (XXD.GE.ZERO) THEN
c  x-values for the three diquarks of the projectile nucleon
         RR1    = DT_RNDM(XXD)
         RR2    = DT_RNDM(RR1)
         RR3    = DT_RNDM(RR2)
         SR123  = RR1+RR2+RR3
         XXPV   = XDTHR+RR1*XXD/SR123
         XXPSQ  = XDTHR+RR2*XXD/SR123
         XXPSAQ = XDTHR+RR3*XXD/SR123
      ELSE
         XXPV   = XPVD(IDXVP)
         XXPSQ  = XPSQ(IDXSP)
         XXPSAQ = XPSAQ(IDXSP)
      ENDIF
c  flavor of the second quarks in the sea-diquark pair
      IPSQ2(IDXSP)  = INT(1.0D0+DT_RNDM(XXD)*(2.0D0+SEASQ))
      IPSAQ2(IDXSP) = -IPSQ2(IDXSP)
c  check masses of the new sea-qq - val-q, sea-aqaq - val-qq chains
      AM1    = XXPSQ *XTVQ(IDXVT)*ECM**2
      AM2    = XXPSAQ*XTVD(IDXVT)*ECM**2
      IF ( (IPSQ(IDXSP).EQ.3).AND.(IPSQ2(IDXSP).EQ.3).AND.
c    ss-asas pair
     &     ((AM2.LE.18.0D0).OR.(AM1.LE.6.6D0))            ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( ((IPSQ(IDXSP).EQ.3).OR.(IPSQ2(IDXSP).EQ.3)).AND.
c    at least one strange quark
     &         ((AM2.LE.14.6D0).OR.(AM1.LE.5.8D0))        ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( (AM2.LE.13.4D0).OR.(AM1.LE.5.0D0) ) THEN
         IREJ = 1
         RETURN
      ENDIF
c  accept the new sea-diquark
      XPVD(IDXVP)   = XXPV
      XPSQ(IDXSP)   = XXPSQ
      XPSAQ(IDXSP)  = XXPSAQ
      NDV           = NDV+1
      INTDV1(NDV)   = IDXSP
      INTDV2(NDV)   = IDXVT
      ISKPCH(5,NDV) = 0
      RETURN

c---------------------------------------------------------------------
c proj. sea partons - targ. sea partons
c get x-values and flavors for target sea-diquark pair

    3 CONTINUE
      IDXSP = IDX1
      IDXST = IDX2

c  index of corr. val-diquark-x in target nucleon
      IDXVT = ITOVT(IFROST(IDXST))
c  available x above diquark thresholds for valence- and sea-diquarks
      XXD   = XTVD(IDXVT)+XTSQ(IDXST)+XTSAQ(IDXST)-3.0D0*XDTHR

      IF (XXD.GE.ZERO) THEN
c  x-values for the three diquarks of the target nucleon
         RR1    = DT_RNDM(XXD)
         RR2    = DT_RNDM(RR1)
         RR3    = DT_RNDM(RR2)
         SR123  = RR1+RR2+RR3
         XXTV   = XDTHR+RR1*XXD/SR123
         XXTSQ  = XDTHR+RR2*XXD/SR123
         XXTSAQ = XDTHR+RR3*XXD/SR123
      ELSE
         XXTV   = XTVD(IDXVT)
         XXTSQ  = XTSQ(IDXST)
         XXTSAQ = XTSAQ(IDXST)
      ENDIF
c  flavor of the second quarks in the sea-diquark pair
      ITSQ2(IDXST)  = INT(1.0D0+DT_RNDM(XXD)*(2.0D0+SEASQ))
      ITSAQ2(IDXST) = -ITSQ2(IDXST)
c  check masses of the new sea-q - sea-qq, sea-aq - sea-aqaq chains
      AM1    = XXTSQ *XPSQ(IDXSP)*ECM**2
      AM2    = XXTSAQ*XPSAQ(IDXSP)*ECM**2
      IF ( (ITSQ(IDXST).EQ.3).AND.(ITSQ2(IDXST).EQ.3).AND.
c    ss-asas pair
     &     ((AM2.LE.6.6D0).OR.(AM1.LE.6.6D0))            ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( ((ITSQ(IDXST).EQ.3).OR.(ITSQ2(IDXST).EQ.3)).AND.
c    at least one strange quark
     &         ((AM2.LE.5.8D0).OR.(AM1.LE.5.8D0))        ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( (AM2.LE.5.0D0).OR.(AM1.LE.5.0D0) ) THEN
         IREJ = 1
         RETURN
      ENDIF
c  accept the new sea-diquark
      XTVD(IDXVT)   = XXTV
      XTSQ(IDXST)   = XXTSQ
      XTSAQ(IDXST)  = XXTSAQ
      NSD           = NSD+1
      INTSD1(NSD)   = IDXSP
      INTSD2(NSD)   = IDXST
      ISKPCH(3,NSD) = 0
      RETURN

c---------------------------------------------------------------------
c proj. sea partons - targ. sea partons
c get x-values and flavors for projectile sea-diquark pair

    4 CONTINUE
      IDXSP = IDX2
      IDXST = IDX1

c  index of corr. val-diquark-x in projectile nucleon
      IDXVP = ITOVP(IFROSP(IDXSP))
c  available x above diquark thresholds for valence- and sea-diquarks
      XXD   = XPVD(IDXVP)+XPSQ(IDXSP)+XPSAQ(IDXSP)-3.0D0*XDTHR

      IF (XXD.GE.ZERO) THEN
c  x-values for the three diquarks of the projectile nucleon
         RR1    = DT_RNDM(XXD)
         RR2    = DT_RNDM(RR1)
         RR3    = DT_RNDM(RR2)
         SR123  = RR1+RR2+RR3
         XXPV   = XDTHR+RR1*XXD/SR123
         XXPSQ  = XDTHR+RR2*XXD/SR123
         XXPSAQ = XDTHR+RR3*XXD/SR123
      ELSE
         XXPV   = XPVD(IDXVP)
         XXPSQ  = XPSQ(IDXSP)
         XXPSAQ = XPSAQ(IDXSP)
      ENDIF
c  flavor of the second quarks in the sea-diquark pair
      IPSQ2(IDXSP)  = INT(1.0D0+DT_RNDM(RR3)*(2.0D0+SEASQ))
      IPSAQ2(IDXSP) = -IPSQ2(IDXSP)
c  check masses of the new sea-qq - sea-q, sea-aqaq - sea-qq chains
      AM1    = XXPSQ *XTSQ(IDXST)*ECM**2
      AM2    = XXPSAQ*XTSAQ(IDXST)*ECM**2
      IF ( (IPSQ(IDXSP).EQ.3).AND.(IPSQ2(IDXSP).EQ.3).AND.
c    ss-asas pair
     &     ((AM2.LE.6.6D0).OR.(AM1.LE.6.6D0))            ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( ((IPSQ(IDXSP).EQ.3).OR.(IPSQ2(IDXSP).EQ.3)).AND.
c    at least one strange quark
     &         ((AM2.LE.5.8D0).OR.(AM1.LE.5.8D0))        ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( (AM2.LE.5.0D0).OR.(AM1.LE.5.0D0) ) THEN
         IREJ = 1
         RETURN
      ENDIF
c  accept the new sea-diquark
      XPVD(IDXVP)   = XXPV
      XPSQ(IDXSP)   = XXPSQ
      XPSAQ(IDXSP)  = XXPSAQ
      NDS           = NDS+1
      INTDS1(NDS)   = IDXSP
      INTDS2(NDS)   = IDXST
      ISKPCH(2,NDS) = 0
      RETURN
      END
c
c===difevt=============================================================*
c
CDECK  ID>, DT_DIFEVT
      SUBROUTINE DT_DIFEVT(IFP1,IFP2,PP,MOP,
     &                  IFT1,IFT2,PT,MOT,JDIFF,NCSY,IREJ)

c***********************************************************************
c Interface to treatment of diffractive interactions.                  *
c  (input)          IFP1/2        PDG-indizes of projectile partons    *
c                                 (baryon: IFP2 - adiquark)            *
c                   PP(4)         projectile 4-momentum                *
c                   IFT1/2        PDG-indizes of target partons        *
c                                 (baryon: IFT1 - adiquark)            *
c                   PT(4)         target 4-momentum                    *
c  (output)         JDIFF = 0     no diffraction                       *
c                         = 1/-1  LMSD/LMDD                            *
c                         = 2/-2  HMSD/HMDD                            *
c                   NCSY          counter for two-chain systems        *
c                                 dumped to DTEVT1                     *
c This version dated 14.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY10=1.0D-10,TINY5=1.0D-5,
     &           OHALF=0.5D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF


      DIMENSION PP(4),PT(4)

      LOGICAL LFIRST
      DATA LFIRST /.TRUE./

      IREJ   = 0
      JDIFF  = 0
      IFLAGD = JDIFF

c cm. energy
      XM = SQRT((PP(4)+PT(4))**2-(PP(1)+PT(1))**2-
     &          (PP(2)+PT(2))**2-(PP(3)+PT(3))**2)
c identities of projectile hadron / target nucleon
      KPROJ = IDT_ICIHAD(IDHKK(MOP))
      KTARG = IDT_ICIHAD(IDHKK(MOT))

c single diffractive xsections
      CALL DT_SHNDIF(XM,KPROJ,KTARG,SDTOT,SDHM)
c double diffractive xsections
c*!! no double diff yet
C     CALL DT_SHNDIF(XM,KPROJ,KTARG,SDTOT,SDHM,DDTOT,DDHM)
      DDTOT = 0.0D0
      DDHM  = 0.0D0
c*!!
c total inelastic xsection
C     SIGIN  = DT_SHNTOT(KPROJ,KTARG,XM,ZERO)-DT_SHNELA(KPROJ,KTARG,XM)
      DUMZER = ZERO
      CALL DT_XSHN(KPROJ,KTARG,DUMZER,XM,SIGTO,SIGEL)
      SIGIN  = MAX(SIGTO-SIGEL,ZERO)

c fraction of diffractive processes
      FRADIF = (SDTOT+DDTOT)/SIGIN

      IF (LFIRST) THEN
         WRITE(ErrorOut,1000) XM,SDTOT,SIGIN
 1000    FORMAT(1X,'DIFEVT: SINGLE DIFFRACTION REQUESTED AT E_CM = ',
     &          F5.1,' GEV',/,9X,'SIGMA_SD = ',F4.1,' MB, SIGMA_IN = ',
     &          F5.1,' MB',/)
         LFIRST = .FALSE.
      ENDIF

      IF ((DT_RNDM(DDHM).LE.FRADIF).OR.
     &    (ISINGD.GT.1).OR.(IDOUBD.GT.1)) THEN
c diffractive interaction requested by x-section or by user
         FRASD  = SDTOT/(SDTOT+DDTOT)
         FRASDH = SDHM/SDTOT
c*sr needs to be specified!!
C        FRADDH = DDHM/DDTOT
         FRADDH = 1.0D0
c*
         IF ((DT_RNDM(FRASD).LE.FRASD).OR.(ISINGD.GT.1)) THEN
c   single diffraction
            KDIFF = 1
            IF (DT_RNDM(DDTOT).LE.FRASDH) THEN
               KP = 2
               KT = 0
               IF (((ISINGD.EQ.4).OR.(DT_RNDM(DDTOT).GE.OHALF)).AND.
     &               ISINGD.NE.3) THEN
                  KP = 0
                  KT = 2
               ENDIF
            ELSE
               KP = 1
               KT = 0
               IF (((ISINGD.EQ.4).OR.(DT_RNDM(FRADDH).GE.OHALF)).AND.
     &               ISINGD.NE.3) THEN
                  KP = 0
                  KT = 1
               ENDIF
            ENDIF
         ELSE
c   double diffraction
            KDIFF = -1
            IF (DT_RNDM(FRADDH).LE.FRADDH) THEN
               KP = 2
               KT = 2
            ELSE
               KP = 1
               KT = 1
            ENDIF
         ENDIF
         CALL DT_DIFFKI(IFP1,IFP2,PP,MOP,KP,
     &               IFT1,IFT2,PT,MOT,KT,NCSY,IREJ1)
         IF (IREJ1.EQ.0) THEN
            IFLAGD = 2*KDIFF
            IF ((KP.EQ.1).OR.(KT.EQ.1)) IFLAGD = KDIFF
         ELSE
            GOTO 9999
         ENDIF
      ENDIF
      JDIFF = IFLAGD

      RETURN

 9999 CONTINUE
      IREJ  = 1
      RETURN
      END
c
c===difkin=============================================================*
c
CDECK  ID>, DT_DIFFKI
      SUBROUTINE DT_DIFFKI(IFP1,IFP2,PP,MOP,KP,
     &                  IFT1,IFT2,PT,MOT,KT,NCSY,IREJ)

c***********************************************************************
c Kinematics of diffractive nucleon-nucleon interaction.               *
c          IFP1/2   PDG-indizes of projectile partons                  *
c                   (baryon: IFP2 - adiquark)                          *
c          PP(4)    projectile 4-momentum                              *
c          IFT1/2   PDG-indizes of target partons                      *
c                   (baryon: IFT1 - adiquark)                          *
c          PT(4)    target 4-momentum                                  *
c          KP   = 0 projectile quasi-elastically scattered             *
c               = 1            excited to low-mass diff. state         *
c               = 2            excited to high-mass diff. state        *
c          KT   = 0 target     quasi-elastically scattered             *
c               = 1            excited to low-mass diff. state         *
c               = 2            excited to high-mass diff. state        *
c This version dated 12.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY10=1.0D-10,TINY5=1.0D-5)

      LOGICAL LSTART

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)


      DIMENSION PITOT(4),BGTOT(4),PP1(4),PT1(4),PPBLOB(4),PTBLOB(4),
     &          PP(4),PT(4),PPOM1(4),DEV1(4),DEV2(4)

      DATA LSTART /.TRUE./

      IF (LSTART) THEN
         WRITE(ErrorOut,2000)
 2000    FORMAT(/,1X,'DIFEVT:  DIFFRACTIVE INTERACTIONS TREATED ')
         LSTART = .FALSE.
      ENDIF

      IREJ = 0

c initialize common /DTDIKI/
      CALL DT_DIFINI
c store momenta of initial incoming particles for emc-check
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(PP(1),PP(2),PP(3),PP(4),1,IDUM,IDUM)
         CALL DT_EVTEMC(PT(1),PT(2),PT(3),PT(4),2,IDUM,IDUM)
      ENDIF

c masses of initial particles
      XMP2 = PP(4)**2-PP(1)**2-PP(2)**2-PP(3)**2
      XMT2 = PT(4)**2-PT(1)**2-PT(2)**2-PT(3)**2
      IF ((XMP2.LT.ZERO).OR.(XMT2.LT.ZERO)) GOTO 9999
      XMP  = SQRT(XMP2)
      XMT  = SQRT(XMT2)
c check quark-input (used to adjust coherence cond. for M-selection)
      IBP  = 0
      IF ((ABS(IFP1).GE.1000).OR.(ABS(IFP2).GE.1000)) IBP = 1
      IBT  = 0
      IF ((ABS(IFT1).GE.1000).OR.(ABS(IFT2).GE.1000)) IBT = 1

c parameter for Lorentz-transformation into nucleon-nucleon cms
      DO 3 K=1,4
         PITOT(K) = PP(K)+PT(K)
    3 CONTINUE
      XMTOT2 = PITOT(4)**2-PITOT(1)**2-PITOT(2)**2-PITOT(3)**2
      IF (XMTOT2.LE.ZERO) THEN
         WRITE(ErrorOut,1000) XMTOT2
 1000    FORMAT(1X,'DIFEVT:   NEGATIVE CM. ENERGY!  ',
     &          'XMTOT2 = ',E12.3)
         GOTO 9999
      ENDIF
      XMTOT = SQRT(XMTOT2)
      DO 4 K=1,4
         BGTOT(K) = PITOT(K)/XMTOT
    4 CONTINUE
c transformation of nucleons into cms
      CALL DT_DALTRA(BGTOT(4),-BGTOT(1),-BGTOT(2),-BGTOT(3),PP(1),PP(2),
     &            PP(3),PP(4),PPTOT,PP1(1),PP1(2),PP1(3),PP1(4))
      CALL DT_DALTRA(BGTOT(4),-BGTOT(1),-BGTOT(2),-BGTOT(3),PT(1),PT(2),
     &            PT(3),PT(4),PTTOT,PT1(1),PT1(2),PT1(3),PT1(4))
c rotation angles
      COD = PP1(3)/PPTOT
C     SID = SQRT((ONE-COD)*(ONE+COD))
      PPT = SQRT(PP1(1)**2+PP1(2)**2)
      SID = PPT/PPTOT
      COF = ONE
      SIF = ZERO
      IF(PPTOT*SID.GT.TINY10) THEN
         COF   = PP1(1)/(SID*PPTOT)
         SIF   = PP1(2)/(SID*PPTOT)
         ANORF = SQRT(COF*COF+SIF*SIF)
         COF   = COF/ANORF
         SIF   = SIF/ANORF
      ENDIF
c check consistency
      DO 5 K=1,4
         DEV1(K) = ABS(PP1(K)+PT1(K))
    5 CONTINUE
      DEV1(4) = ABS(DEV1(4)-XMTOT)
      IF ((DEV1(1).GT.TINY10).OR.(DEV1(2).GT.TINY10).OR.
     &    (DEV1(3).GT.TINY10).OR.(DEV1(4).GT.TINY10))     THEN
         WRITE(ErrorOut,1001) DEV1
 1001    FORMAT(1X,'DIFEVT:   INCONSITENT LORENTZ-TRANSFORMATION! ',
     &          /,8X,4E12.3)
         GOTO 9999
      ENDIF

c select x-fractions in high-mass diff. interactions
      IF ((KP.EQ.2).OR.(KT.EQ.2)) CALL DT_XVALHM(KP,KT)

c select diffractive masses
c - projectile
      IF (KP.EQ.1) THEN
         XMPF = DT_XMLMD(XMTOT)
         CALL DT_LM2RES(IFP1,IFP2,XMPF,IDPR,IDXPR,IREJ1)
         IF (IREJ1.GT.0) GOTO 9999
      ELSEIF (KP.EQ.2) THEN
         XMPF = DT_XMHMD(XMTOT,IBP,1)
      ELSE
         XMPF = XMP
      ENDIF
c - target
      IF (KT.EQ.1) THEN
         XMTF = DT_XMLMD(XMTOT)
         CALL DT_LM2RES(IFT1,IFT2,XMTF,IDTR,IDXTR,IREJ1)
         IF (IREJ1.GT.0) GOTO 9999
      ELSEIF (KT.EQ.2) THEN
         XMTF = DT_XMHMD(XMTOT,IBT,2)
      ELSE
         XMTF = XMT
      ENDIF

c kinematical treatment of "two-particle" system (masses - XMPF,XMTF)
      XMPF2 = XMPF**2
      XMTF2 = XMTF**2
      PPBLOB(3) = DT_YLAMB(XMTOT2,XMPF2,XMTF2)/(2.D0*XMTOT)
      PPBLOB(4) = SQRT(XMPF2+PPBLOB(3)**2)

c select momentum transfer (all t-values used here are <0)
c   minimum absolute value to produce diffractive masses
      TMIN = XMP2+XMPF2-2.0D0*(PP1(4)*PPBLOB(4)-PPTOT*PPBLOB(3))
      TT   = DT_TDIFF(XMTOT,TMIN,XMPF,KP,XMTF,KT,IREJ1)
      IF (IREJ1.GT.0) GOTO 9999

c longitudinal momentum of excited/elastically scattered projectile
      PPBLOB(3) = (TT-XMP2-XMPF2+2.0D0*PP1(4)*PPBLOB(4))/(2.0D0*PPTOT)
c total transverse momentum due to t-selection
      PPBLT2 = PPBLOB(4)**2-PPBLOB(3)**2-XMPF2
      IF (PPBLT2.LT.ZERO) THEN
         WRITE(ErrorOut,1002) PPBLT2,KP,PP1,XMPF,KT,PT1,XMTF,TT
 1002    FORMAT(1X,'DIFEVT:   INCONSISTENT TRANSVERSE MOMENTUM! ',
     &          E12.3,2(/,1X,I2,5E12.3),/,1X,E12.3)
         GOTO 9999
      ENDIF
      CALL DT_DSFECF(SINPHI,COSPHI)
      PPBLT     = SQRT(PPBLT2)
      PPBLOB(1) = COSPHI*PPBLT
      PPBLOB(2) = SINPHI*PPBLT

c rotate excited/elastically scattered projectile into n-n cms.
      CALL DT_MYTRAN(1,PPBLOB(1),PPBLOB(2),PPBLOB(3),COD,SID,COF,SIF,
     &                                                    XX,YY,ZZ)
      PPBLOB(1) = XX
      PPBLOB(2) = YY
      PPBLOB(3) = ZZ

c 4-momentum of excited/elastically scattered target and of exchanged
c Pomeron
      DO 6 K=1,4
         IF (K.LT.4) PTBLOB(K) = -PPBLOB(K)
         PPOM1(K) = PP1(K)-PPBLOB(K)
    6 CONTINUE
      PTBLOB(4) = XMTOT-PPBLOB(4)

c Lorentz-transformation back into system of initial diff. collision
      CALL DT_DALTRA(BGTOT(4),BGTOT(1),BGTOT(2),BGTOT(3),
     &            PPBLOB(1),PPBLOB(2),PPBLOB(3),PPBLOB(4),
     &            PPTOTF,PPF(1),PPF(2),PPF(3),PPF(4))
      CALL DT_DALTRA(BGTOT(4),BGTOT(1),BGTOT(2),BGTOT(3),
     &            PTBLOB(1),PTBLOB(2),PTBLOB(3),PTBLOB(4),
     &            PTTOTF,PTF(1),PTF(2),PTF(3),PTF(4))
      CALL DT_DALTRA(BGTOT(4),BGTOT(1),BGTOT(2),BGTOT(3),
     &            PPOM1(1),PPOM1(2),PPOM1(3),PPOM1(4),
     &            PPOMTO,PPOM(1),PPOM(2),PPOM(3),PPOM(4))

c store 4-momentum of elastically scattered particle (in single diff.
c events)
      IF (KP.EQ.0) THEN
         DO 7 K=1,4
            PSC(K) = PPF(K)
    7    CONTINUE
      ELSEIF (KT.EQ.0) THEN
         DO 8 K=1,4
            PSC(K) = PTF(K)
    8    CONTINUE
      ENDIF

c check consistency of kinematical treatment so far
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(-PPF(1),-PPF(2),-PPF(3),-PPF(4),2,IDUM,IDUM)
         CALL DT_EVTEMC(-PTF(1),-PTF(2),-PTF(3),-PTF(4),2,IDUM,IDUM)
         CALL DT_EVTEMC(DUM,DUM,DUM,DUM,3,60,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
      ENDIF
      DO 9 K=1,4
         DEV1(K) = ABS(PP(K)-PPF(K)-PPOM(K))
         DEV2(K) = ABS(PT(K)-PTF(K)+PPOM(K))
    9 CONTINUE
      IF ((DEV1(1).GT.TINY5).OR.(DEV1(2).GT.TINY5).OR.
     &    (DEV1(3).GT.TINY5).OR.(DEV1(4).GT.TINY5).OR.
     &    (DEV2(1).GT.TINY5).OR.(DEV2(2).GT.TINY5).OR.
     &    (DEV2(3).GT.TINY5).OR.(DEV2(4).GT.TINY5))     THEN
         WRITE(ErrorOut,1003) DEV1,DEV2
 1003    FORMAT(1X,'DIFEVT:   INCONSITENT KINEMATICAL TREATMENT!  ',
     &          2(/,8X,4E12.3))
         GOTO 9999
      ENDIF

c kinematical treatment for low-mass diffraction
      CALL DT_LMKINE(IFP1,IFP2,KP,IFT1,IFT2,KT,IREJ1)
      IF (IREJ1.NE.0) GOTO 9999

c dump diffractive chains into DTEVT1
      CALL DT_DIFPUT(IFP1,IFP2,PP,MOP,KP,IFT1,IFT2,PT,MOT,KT,NCSY,IREJ1)
      IF (IREJ1.NE.0) GOTO 9999

      RETURN

 9999 CONTINUE
      IRDIFF(1) = IRDIFF(1)+1
      IREJ      = 1
      RETURN
      END
c
c===xmhmd==============================================================*
c
CDECK  ID>, DT_XMHMD
      DOUBLE PRECISION FUNCTION DT_XMHMD(ECM,IB,MODE)

c***********************************************************************
c Diffractive mass in high mass single/double diffractive events.      *
c This version dated 11.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (OHALF=0.5D0,ONE=1.0D0,ZERO=0.0D0)

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)


C     DATA XCOLOW /0.05D0/
      DATA XCOLOW /0.15D0/

      DT_XMHMD = ZERO
      XH = XPH(2)
      IF (MODE.EQ.2) XH = XTH(2)

c minimum Pomeron-x for high-mass diffraction
c (adjusted to get a smooth transition between HM and LM component)
      R = DT_RNDM(XH)
      XDIMIN = (3.0D0+400.0D0*R**2)/(XH*ECM**2)
      IF (ECM.LE.300.0D0) THEN
         RR     = (1.0D0-EXP(-((ECM/140.0D0)**4)))
         XDIMIN = (3.0D0+400.0D0*(R**2)*RR)/(XH*ECM**2)
      ENDIF
c maximum Pomeron-x for high-mass diffraction
c (coherence condition, adjusted to fit to experimental data)
      IF (IB.NE.0) THEN
c   baryon-diffraction
         XDIMAX = XCOLOW*(1.0D0+EXP(-((ECM/420.0D0)**2)))
      ELSE
c   meson-diffraction
         XDIMAX = XCOLOW*(1.0D0+4.0D0*EXP(-((ECM/420.0D0)**2)))
      ENDIF
c check boundaries
      IF (XDIMIN.GE.XDIMAX) THEN
         XDIMIN = OHALF*XDIMAX
      ENDIF

      KLOOP = 0
    1 CONTINUE
      KLOOP = KLOOP+1
      IF (KLOOP.GT.20) RETURN
c sample Pomeron-x from 1/x-distribution (critical Pomeron)
      XDIFF = DT_SAMPEX(XDIMIN,XDIMAX)
c corr. diffr. mass
      DT_XMHMD = ECM*SQRT(XDIFF)
      IF (DT_XMHMD.LT.2.5D0) GOTO 1

      RETURN
      END
c
c===xmlmd==============================================================*
c
CDECK  ID>, DT_XMLMD
      DOUBLE PRECISION FUNCTION DT_XMLMD(ECM)

c***********************************************************************
c Diffractive mass in high mass single/double diffractive events.      *
c This version dated 11.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c minimum Pomeron-x for low-mass diffraction
C     AMO = 1.5D0
      AMO = 2.0D0
c maximum Pomeron-x for low-mass diffraction
c (adjusted to get a smooth transition between HM and LM component)
      R   = DT_RNDM(AMO)
      SAM = 1.0D0
      IF (ECM.LE.300.0D0) SAM = 1.0D0-EXP(-((ECM/200.0D0)**4))
      R   = DT_RNDM(AMO)*SAM
      AMAX= (1.0D0-SAM)*SQRT(0.1D0*ECM**2)+SAM*SQRT(400.0D0)
      AMU = R*SQRT(100.0D0)+(1.0D0-R)*AMAX

c selection of diffractive mass
c (adjusted to get a smooth transition between HM and LM component)
      R   = DT_RNDM(AMU)
      IF (ECM.LE.50.0D0) THEN
         DT_XMLMD = AMO*(AMU/AMO)**R
      ELSE
         A = 0.7D0
         IF (ECM.LE.300.0D0) A = 0.7D0*(1.0D0-EXP(-((ECM/100.0D0)**2)))
         DT_XMLMD = 1.0D0/((R/(AMU**A)+(1.0D0-R)/(AMO**A))**(1.0D0/A))
      ENDIF

      RETURN
      END
c
c===tdiff==============================================================*
c
CDECK  ID>, DT_TDIFF
      DOUBLE PRECISION FUNCTION DT_TDIFF(ECM,TMIN,XM1I,K1,XM2I,K2,IREJ)

c***********************************************************************
c t-selection for single/double diffractive interactions.              *
c          ECM      cm. energy                                         *
c          TMIN     minimum momentum transfer to produce diff. masses  *
c          XM1/XM2  diffractively produced masses                      *
c                   (for single diffraction XM2 is obsolete)           *
c          K1/K2= 0 not excited                                        *
c               = 1 low-mass excitation                                *
c               = 2 high-mass excitation                               *
c This version dated 11.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0)

      PARAMETER ( BTP0   = 3.7D0,
     &            ALPHAP = 0.24D0 )

      IREJ   = 0
      NCLOOP = 0
      DT_TDIFF  = ZERO

      IF (K1.GT.0) THEN
         XM1 = XM1I
         XM2 = XM2I
      ELSE
         XM1 = XM2I
      ENDIF
      XDI = (XM1/ECM)**2
      IF ((K1.EQ.0).OR.(K2.EQ.0)) THEN
c slope for single diffraction
         SLOPE = BTP0-2.0D0*ALPHAP*LOG(XDI)
      ELSE
c slope for double diffraction
         SLOPE = -2.0D0*ALPHAP*LOG(XDI*XM2**2)
      ENDIF

    1 CONTINUE
      NCLOOP = NCLOOP+1
      IF (MOD(NCLOOP,1000).EQ.0) GOTO 9999
      Y = DT_RNDM(XDI)
      T = -LOG(1.0D0-Y)/SLOPE
      IF (ABS(T).LE.ABS(TMIN)) GOTO 1
      DT_TDIFF = -ABS(T)

      RETURN

 9999 CONTINUE
      WRITE(ErrorOut,1000) ECM,TMIN,XM1I,XM2I,K1,K2
 1000 FORMAT(1X,'DT_TDIFF:   T-SELECTION REJECTED!',/,
     &       1X,'ECM  = ',E12.3,' TMIN = ',E12.2,/,1X,'XM1I = ',
     &       E12.3,' XM2I = ',E12.3,' K1 = ',I2,' K2 = ',I2)
      IREJ = 1
      RETURN
      END
c
c===xvalhm=============================================================*
c
CDECK  ID>, DT_XVALHM
      SUBROUTINE DT_XVALHM(KP,KT)

c***********************************************************************
c Sampling of parton x-values in high-mass diffractive interactions.   *
c This version dated 12.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,OHALF=0.5D0,ONE=1.0D0,TINY2=1.0D-2)

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      DATA UNON,XVQTHR /2.0D0,0.8D0/

      IF (KP.EQ.2) THEN
c x-fractions of projectile valence partons
    1    CONTINUE
         XPH(1) = DT_DBETAR(OHALF,UNON)
         IF (XPH(1).GE.XVQTHR) GOTO 1
         XPH(2) = ONE-XPH(1)
c x-fractions of Pomeron q-aq-pair
         XPOLO = TINY2
         XPOHI = ONE-TINY2
         XPPO(1) = DT_SAMPEX(XPOLO,XPOHI)
         XPPO(2) = ONE-XPPO(1)
c flavors of Pomeron q-aq-pair
         IFLAV    = INT(ONE+DT_RNDM(UNON)*(2.0D0+SEASQ))
         IFPPO(1) = IFLAV
         IFPPO(2) = -IFLAV
         IF (DT_RNDM(UNON).GT.OHALF) THEN
            IFPPO(1) = -IFLAV
            IFPPO(2) = IFLAV
         ENDIF
      ENDIF

      IF (KT.EQ.2) THEN
c x-fractions of projectile target partons
    2    CONTINUE
         XTH(1) = DT_DBETAR(OHALF,UNON)
         IF (XTH(1).GE.XVQTHR) GOTO 2
         XTH(2) = ONE-XTH(1)
c x-fractions of Pomeron q-aq-pair
         XPOLO = TINY2
         XPOHI = ONE-TINY2
         XTPO(1) = DT_SAMPEX(XPOLO,XPOHI)
         XTPO(2) = ONE-XTPO(1)
c flavors of Pomeron q-aq-pair
         IFLAV    = INT(ONE+DT_RNDM(XPOLO)*(2.0D0+SEASQ))
         IFTPO(1) = IFLAV
         IFTPO(2) = -IFLAV
         IF (DT_RNDM(XPOLO).GT.OHALF) THEN
            IFTPO(1) = -IFLAV
            IFTPO(2) = IFLAV
         ENDIF
      ENDIF

      RETURN
      END
c
c===lm2res=============================================================*
c
CDECK  ID>, DT_LM2RES
      SUBROUTINE DT_LM2RES(IF1,IF2,XM,IDR,IDXR,IREJ)

c***********************************************************************
c Check low-mass diffractive excitation for resonance mass.            *
c   (input)   IF1/2    PDG-indizes of valence partons                  *
c   (in/out)  XM       diffractive mass requested/corrected            *
c   (output)  IDR/IDXR id./BAMJET-index of resonance                   *
c This version dated 12.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,OHALF=0.5D0,ONE=1.0D0)

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)


      IREJ = 0
      IF1B = 0
      IF2B = 0
      XMI  = XM

c BAMJET indices of partons
      IF1A = IDT_IPDG2B(IF1,1,2)
      IF (ABS(IF1).GE.1000) IF1B = IDT_IPDG2B(IF1,2,2)
      IF2A = IDT_IPDG2B(IF2,1,2)
      IF (ABS(IF2).GE.1000) IF2B = IDT_IPDG2B(IF2,2,2)

c get kind of chains (1 - q-aq, 2 - q-qq/aq-aqaq)
      IDCH = 2
      IF ((IF1B.EQ.0).AND.(IF2B.EQ.0)) IDCH = 1

c check for resonance mass
      CALL DT_CH2RES(IF1A,IF1B,IF2A,IF2B,IDR,IDXR,XMI,XMN,IDCH,IREJ1)
      IF (IREJ1.NE.0) GOTO 9999

      XM = XMN
      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===lmkine=============================================================*
c
CDECK  ID>, DT_LMKINE
      SUBROUTINE DT_LMKINE(IFP1,IFP2,KP,IFT1,IFT2,KT,IREJ)

c***********************************************************************
c Kinematical treatment of low-mass excitations.                       *
c This version dated 12.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,OHALF=0.5D0,ONE=1.0D0)



c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)


      DIMENSION P1(4),P2(4)

      IREJ = 0

      IF (KP.EQ.1) THEN
         PABS = SQRT(PPF(1)**2+PPF(2)**2+PPF(3)**2)
         POE  = PPF(4)/PABS
         FAC1 = OHALF*(POE+ONE)
         FAC2 = -OHALF*(POE-ONE)
         DO 1 K=1,3
            PPLM1(K) = FAC1*PPF(K)
            PPLM2(K) = FAC2*PPF(K)
    1    CONTINUE
         PPLM1(4) = FAC1*PABS
         PPLM2(4) = -FAC2*PABS
         IF (IMSHL.EQ.1) THEN

            XM1 = PYMASS(IFP1)
            XM2 = PYMASS(IFP2)

            CALL DT_MASHEL(PPLM1,PPLM2,XM1,XM2,P1,P2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            DO 2 K=1,4
               PPLM1(K) = P1(K)
               PPLM2(K) = P2(K)
    2       CONTINUE
         ENDIF
      ENDIF

      IF (KT.EQ.1) THEN
         PABS = SQRT(PTF(1)**2+PTF(2)**2+PTF(3)**2)
         POE  = PTF(4)/PABS
         FAC1 = OHALF*(POE+ONE)
         FAC2 = -OHALF*(POE-ONE)
         DO 3 K=1,3
            PTLM2(K) = FAC1*PTF(K)
            PTLM1(K) = FAC2*PTF(K)
    3    CONTINUE
         PTLM2(4) = FAC1*PABS
         PTLM1(4) = -FAC2*PABS
         IF (IMSHL.EQ.1) THEN

            XM1 = PYMASS(IFT1)
            XM2 = PYMASS(IFT2)

            CALL DT_MASHEL(PTLM1,PTLM2,XM1,XM2,P1,P2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            DO 4 K=1,4
               PTLM1(K) = P1(K)
               PTLM2(K) = P2(K)
    4       CONTINUE
         ENDIF
      ENDIF

      RETURN

 9999 CONTINUE
      WRITE(ErrorOut,
     * '(A)') 'LMKINE:   kinematical treatment rejected'
      IREJ = 1
      RETURN
      END
c
c===difini=============================================================*
c
CDECK  ID>, DT_DIFINI
      SUBROUTINE DT_DIFINI

c***********************************************************************
c Initialization of common /DTDIKI/                                    *
c This version dated 12.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,OHALF=0.5D0,ONE=1.0D0)

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)


      DO 1 K=1,4
         PPOM(K)  = ZERO
         PSC(K)   = ZERO
         PPF(K)   = ZERO
         PTF(K)   = ZERO
         PPLM1(K) = ZERO
         PPLM2(K) = ZERO
         PTLM1(K) = ZERO
         PTLM2(K) = ZERO
    1 CONTINUE
      DO 2 K=1,2
         XPH(K)   = ZERO
         XPPO(K)  = ZERO
         XTH(K)   = ZERO
         XTPO(K)  = ZERO
         IFPPO(K) = 0
         IFTPO(K) = 0
    2 CONTINUE
      IDPR  = 0
      IDXPR = 0
      IDTR  = 0
      IDXTR = 0

      RETURN
      END
c
c===difput=============================================================*
c
CDECK  ID>, DT_DIFPUT
      SUBROUTINE DT_DIFPUT(IFP1,IFP2,PP,MOP,KP,IFT1,IFT2,PT,MOT,KT,NCSY,
     &                                                          IREJ)

c***********************************************************************
c Dump diffractive chains into DTEVT1                                  *
c This version dated 12.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,OHALF=0.5D0,ONE=1.0D0)

      LOGICAL LCHK

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC


      DIMENSION PP1(4),PP2(4),PT1(4),PT2(4),PCH(4),PP(4),PT(4),
     &          P1(4),P2(4),P3(4),P4(4)

      IREJ = 0

      IF (KP.EQ.1) THEN
         DO 1 K=1,4
            PCH(K) = PPLM1(K)+PPLM2(K)
    1    CONTINUE
         ID1 = IFP1
         ID2 = IFP2
         IF (DT_RNDM(PT).GT.OHALF) THEN
            ID1 = IFP2
            ID2 = IFP1
         ENDIF
         CALL DT_EVTPUT(21,ID1,MOP,0,PPLM1(1),PPLM1(2),PPLM1(3),
     &                                        PPLM1(4),0,0,0)
         CALL DT_EVTPUT(21,ID2,MOP,0,PPLM2(1),PPLM2(2),PPLM2(3),
     &                                        PPLM2(4),0,0,0)
         CALL DT_EVTPUT(281,88888,-2,-1,PCH(1),PCH(2),PCH(3),PCH(4),
     &                                              IDPR,IDXPR,8)
      ELSEIF (KP.EQ.2) THEN
         DO 2 K=1,4
            PP1(K) = XPH(1)*PP(K)
            PP2(K) = XPH(2)*PP(K)
            PT1(K) = -XPPO(1)*PPOM(K)
            PT2(K) = -XPPO(2)*PPOM(K)
    2    CONTINUE
         CALL  DT_CHKCSY(IFP1,IFPPO(1),LCHK)
         XM1 = ZERO
         XM2 = ZERO
         IF (LCHK) THEN
            CALL DT_MASHEL(PP1,PT1,XM1,XM2,P1,P2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            CALL DT_MASHEL(PP2,PT2,XM1,XM2,P3,P4,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            DO 3 K=1,4
               PP1(K) = P1(K)
               PT1(K) = P2(K)
               PP2(K) = P3(K)
               PT2(K) = P4(K)
    3       CONTINUE
            CALL DT_EVTPUT(-21,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                       0,0,8)
            CALL DT_EVTPUT(-41,IFPPO(1),MOT,0,PT1(1),PT1(2),PT1(3),
     &                                             PT1(4),0,0,8)
            CALL DT_EVTPUT(-21,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                       0,0,8)
            CALL DT_EVTPUT(-41,IFPPO(2),MOT,0,PT2(1),PT2(2),PT2(3),
     &                                             PT2(4),0,0,8)
         ELSE
            CALL DT_MASHEL(PP1,PT2,XM1,XM2,P1,P2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            CALL DT_MASHEL(PP2,PT1,XM1,XM2,P3,P4,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            DO 4 K=1,4
               PP1(K) = P1(K)
               PT2(K) = P2(K)
               PP2(K) = P3(K)
               PT1(K) = P4(K)
    4       CONTINUE
            CALL DT_EVTPUT(-21,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                       0,0,8)
            CALL DT_EVTPUT(-41,IFPPO(2),MOT,0,PT2(1),PT2(2),PT2(3),
     &                                                PT2(4),0,0,8)
            CALL DT_EVTPUT(-21,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                       0,0,8)
            CALL DT_EVTPUT(-41,IFPPO(1),MOT,0,PT1(1),PT1(2),PT1(3),
     &                                                PT1(4),0,0,8)
         ENDIF
         NCSY = NCSY+1
      ELSE
         CALL DT_EVTPUT(1,IDHKK(MOP),MOP,0,PSC(1),PSC(2),PSC(3),PSC(4),
     &                                                        0,0,0)
      ENDIF

      IF (KT.EQ.1) THEN
         DO 5 K=1,4
            PCH(K) = PTLM1(K)+PTLM2(K)
    5    CONTINUE
         ID1 = IFT1
         ID2 = IFT2
         IF (DT_RNDM(PT).GT.OHALF) THEN
            ID1 = IFT2
            ID2 = IFT1
         ENDIF
         CALL DT_EVTPUT(22,ID1,MOT,0,PTLM1(1),PTLM1(2),PTLM1(3),
     &                                              PTLM1(4),0,0,0)
         CALL DT_EVTPUT(22,ID2,MOT,0,PTLM2(1),PTLM2(2),PTLM2(3),
     &                                              PTLM2(4),0,0,0)
         CALL DT_EVTPUT(281,88888,-2,-1,PCH(1),PCH(2),PCH(3),PCH(4),
     &                                              IDTR,IDXTR,8)
      ELSEIF (KT.EQ.2) THEN
         DO 6 K=1,4
            PP1(K) = XTPO(1)*PPOM(K)
            PP2(K) = XTPO(2)*PPOM(K)
            PT1(K) = XTH(2)*PT(K)
            PT2(K) = XTH(1)*PT(K)
    6    CONTINUE
         CALL  DT_CHKCSY(IFTPO(1),IFT1,LCHK)
         XM1 = ZERO
         XM2 = ZERO
         IF (LCHK) THEN
            CALL DT_MASHEL(PP1,PT1,XM1,XM2,P1,P2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            CALL DT_MASHEL(PP2,PT2,XM1,XM2,P3,P4,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            DO 7 K=1,4
               PP1(K) = P1(K)
               PT1(K) = P2(K)
               PP2(K) = P3(K)
               PT2(K) = P4(K)
    7       CONTINUE
            CALL DT_EVTPUT(-41,IFTPO(1),MOP,0,PP1(1),PP1(2),PP1(3),
     &                                                PP1(4),0,0,8)
            CALL DT_EVTPUT(-21,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                       0,0,8)
            CALL DT_EVTPUT(-41,IFTPO(2),MOP,0,PP2(1),PP2(2),PP2(3),
     &                                                PP2(4),0,0,8)
            CALL DT_EVTPUT(-21,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                       0,0,8)
         ELSE
            CALL DT_MASHEL(PP1,PT2,XM1,XM2,P1,P2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            CALL DT_MASHEL(PP2,PT1,XM1,XM2,P3,P4,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            DO 8 K=1,4
               PP1(K) = P1(K)
               PT2(K) = P2(K)
               PP2(K) = P3(K)
               PT1(K) = P4(K)
    8       CONTINUE
            CALL DT_EVTPUT(-41,IFTPO(1),MOP,0,PP1(1),PP1(2),PP1(3),
     &                                                PP1(4),0,0,8)
            CALL DT_EVTPUT(-21,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                       0,0,8)
            CALL DT_EVTPUT(-41,IFTPO(2),MOP,0,PP2(1),PP2(2),PP2(3),
     &                                                PP2(4),0,0,8)
            CALL DT_EVTPUT(-21,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                       0,0,8)
         ENDIF
         NCSY = NCSY+1
      ELSE
         CALL DT_EVTPUT(1,IDHKK(MOT),MOT,0,PSC(1),PSC(2),PSC(3),PSC(4),
     &                                                        0,0,0)
      ENDIF

      RETURN

 9999 CONTINUE
      IRDIFF(2) = IRDIFF(2)+1
      IREJ      = 1
      RETURN
      END
c
c===evtfrg=============================================================*
c
CDECK  ID>, DT_EVTFRG
      SUBROUTINE DT_EVTFRG(KMODE,NFRG,NPYMEM,IREJ)

c***********************************************************************
c Hadronization of chains in DTEVT1.                                   *
c                                                                      *
c Input:                                                               *
c   KMODE = 1   hadronization of PHOJET-chains (id=77xxx)              *
c         = 2   hadronization of DTUNUC-chains (id=88xxx)              *
c   NFRG  if KMODE = 1 : upper index of PHOJET-scatterings to be       *
c                        hadronized with one PYEXEC call               *
c         if KMODE = 2 : max. number of DTUNUC-chains to be hadronized *
c                        with one PYEXEC call                          *
c Output:                                                              *
c   NPYMEM      number of entries in JETSET-common after hadronization *
c   IREJ        rejection flag                                         *
c                                                                      *
c This version dated 17.09.00 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY3=1.0D-3,TINY1=1.0D-1)
      PARAMETER (ONE=1.0D0,ZERO=0.0D0)

      LOGICAL LACCEP

      PARAMETER (MXJOIN=200)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c phojet
C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

c jetset

      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)



      PARAMETER (MAXLND=4000)
      COMMON/PYJETS/N,NPAD,K(MAXLND,5),P(MAXLND,5),V(MAXLND,5)



      INTEGER PYK

      DIMENSION IJOIN(MXJOIN),ISJOIN(MXJOIN),IHISMO(8000),IFLG(4000)

      MODE = KMODE
      ISTSTG = 7
      IF (MODE.NE.1) ISTSTG = 8
      IREJ = 0

      IP     = 0
      ISH    = 0
      INIEMC = 1
      NEND   = NHKK
      NACCEP = 0
      IFRG   = 0
      IF (NPOINT(4).LE.NPOINT(3)) NPOINT(4) = NHKK+1
      DO 10 I=NPOINT(3),NEND
c sr 14.02.00: seems to be not necessary anymore, commented
C        LACCEP = ((NOBAM(I).EQ.0).AND.(MODE.EQ.1)).OR.
C    &            ((NOBAM(I).NE.0).AND.(MODE.EQ.2))
         LACCEP = .TRUE.
c pick up chains from dtevt1
         IDCHK = IDHKK(I)/10000
         IF ((IDCHK.EQ.ISTSTG).AND.LACCEP) THEN
            IF (IDCHK.EQ.7) THEN
               IPJE = IDHKK(I)-IDCHK*10000
               IF (IPJE.NE.IFRG) THEN
                  IFRG = IPJE
                  IF (IFRG.GT.NFRG) GOTO 16
               ENDIF
            ELSE
               IPJE = 1
               IFRG = IFRG+1
               IF (IFRG.GT.NFRG) THEN
                  NFRG = -1
                  GOTO 16
               ENDIF
            ENDIF
c   statistics counter
c           IF (IDCH(I).LE.8)
c    &         ICCHAI(2,IDCH(I)) = ICCHAI(2,IDCH(I))+1
c           IF (IDRES(I).NE.0) ICRES(IDCH(I)) = ICRES(IDCH(I))+1
c special treatment for small chains already corrected to hadrons
            IF (IDRES(I).NE.0) THEN
               IF (IDRES(I).EQ.11) THEN
                  ID = IDXRES(I)
               ELSE
                  ID = IDT_IPDGHA(IDXRES(I))
               ENDIF
               IF (LEMCCK) THEN
                  CALL DT_EVTEMC(PHKK(1,I),PHKK(2,I),PHKK(3,I),
     &                              PHKK(4,I),INIEMC,IDUM,IDUM)
                  INIEMC = 2
               ENDIF
               IP = IP+1
               IF (IP.GT.MSTU(4)) STOP ' NEWFRA 1: IP.GT.MSTU(4) !'
               P(IP,1) = PHKK(1,I)
               P(IP,2) = PHKK(2,I)
               P(IP,3) = PHKK(3,I)
               P(IP,4) = PHKK(4,I)
               P(IP,5) = PHKK(5,I)
               K(IP,1) = 1
               K(IP,2) = ID
               K(IP,3) = 0
               K(IP,4) = 0
               K(IP,5) = 0
               IHIST(2,I) = 10000*IPJE+IP
               IF (IHIST(1,I).LE.-100) THEN
                  ISH = ISH+1
                  IF (ISH.GT.MXJOIN) STOP 'ISH > MXJOIN !'
                  ISJOIN(ISH) = I
               ENDIF
               N = IP
               IHISMO(IP) = I
            ELSE
               IJ  = 0
               DO 11 KK=JMOHKK(1,I),JMOHKK(2,I)
                  IF (LEMCCK) THEN
                     CALL DT_EVTEMC(PHKK(1,KK),PHKK(2,KK),PHKK(3,KK),
     &                                   PHKK(4,KK),INIEMC,IDUM,IDUM)
                     CALL DT_EVTFLC(IDHKK(KK),1,INIEMC,IDUM,IDUM)
                     INIEMC = 2
                  ENDIF
                  ID = IDHKK(KK)
                  IF (ID.EQ.0) ID = 21
c                  PTOT = SQRT(PHKK(1,KK)**2+PHKK(2,KK)**2+PHKK(3,KK)**2)
c                  AM0  = SQRT(ABS((PHKK(4,KK)-PTOT)*(PHKK(4,KK)+PTOT)))

c                  AMRQ   = PYMASS(ID)

c                  AMDIF2 = (AM0-AMRQ)*(AM0+AMRQ)
c                  IF ((ABS(AMDIF2).GT.TINY3).AND.(PTOT.GT.ZERO).AND.
c     &                (ABS(IDIFF).EQ.0)) THEN
cC                    WRITE(LOUT,*)'here: ',NEVHKK,AM0,AMRQ
c                     DELTA      = -AMDIF2/(2.0D0*(PHKK(4,KK)+PTOT))
c                     PHKK(4,KK) = PHKK(4,KK)+DELTA
c                     PTOT1      = PTOT-DELTA
c                     PHKK(1,KK) = PHKK(1,KK)*PTOT1/PTOT
c                     PHKK(2,KK) = PHKK(2,KK)*PTOT1/PTOT
c                     PHKK(3,KK) = PHKK(3,KK)*PTOT1/PTOT
c                     PHKK(5,KK) = AMRQ
c                  ENDIF
                  IP = IP+1
                  IF (IP.GT.MSTU(4)) STOP ' NEWFRA 2: IP.GT.MSTU(4) !'
                  P(IP,1) = PHKK(1,KK)
                  P(IP,2) = PHKK(2,KK)
                  P(IP,3) = PHKK(3,KK)
                  P(IP,4) = PHKK(4,KK)
                  P(IP,5) = PHKK(5,KK)
                  K(IP,1) = 1
                  K(IP,2) = ID
                  K(IP,3) = 0
                  K(IP,4) = 0
                  K(IP,5) = 0
                  IHIST(2,KK) = 10000*IPJE+IP
                  IF (IHIST(1,KK).LE.-100) THEN
                     ISH = ISH+1
                     IF (ISH.GT.MXJOIN) STOP 'ISH > MXJOIN !'
                     ISJOIN(ISH) = KK
                  ENDIF
                  IJ = IJ+1
                  IF (IJ.GT.MXJOIN) STOP 'IJ > MXJOIN !'
                  IJOIN(IJ)  = IP
                  IHISMO(IP) = I
   11          CONTINUE
               N = IP
c join the two-parton system

               CALL PYJOIN(IJ,IJOIN)

            ENDIF
            IDHKK(I) = 99999
         ENDIF
   10 CONTINUE
   16 CONTINUE
      N = IP

      IF (IP.GT.0) THEN

c final state parton shower
         DO 136 NPJE=1,IPJE
            IF ((MCGENE.EQ.2).AND.(ISH.GE.2)) THEN
               IF ((ISWMDL(8).EQ.1).OR.(ISWMDL(8).EQ.3)) THEN
                  DO 130 K1=1,ISH
                     IF (ISJOIN(K1).EQ.0) GOTO 130
                     I = ISJOIN(K1)
                     IF ((IPAMDL(102).EQ.1).AND.(IHIST(1,I).NE.-100))
     &                                                       GOTO 130
                     IH1 = IHIST(2,I)/10000
                     IF (IH1.NE.NPJE) GOTO 130
                     IH1 = IHIST(2,I)-IH1*10000
                     DO 135 K2=K1+1,ISH
                        IF (ISJOIN(K2).EQ.0) GOTO 135
                        II = ISJOIN(K2)
                        IH2 = IHIST(2,II)/10000
                        IF (IH2.NE.NPJE) GOTO 135
                        IH2 = IHIST(2,II)-IH2*10000
                        IF (IHIST(1,I).EQ.IHIST(1,II)) THEN
                           PT1 = SQRT(PHKK(1,II)**2+PHKK(2,II)**2)
                           PT2 = SQRT(PHKK(1, I)**2+PHKK(2, I)**2)

                           RQLUN = MIN(PT1,PT2)
                           CALL PYSHOW(IH1,IH2,RQLUN)

                           ISJOIN(K1) = 0
                           ISJOIN(K2) = 0
                           GOTO 130
                        ENDIF
 135                 CONTINUE
 130              CONTINUE
               ENDIF
            ENDIF
 136     CONTINUE

         CALL DT_INITJS(MODE)
c hadronization

         CALL PYEXEC

         IF (MSTU(24).NE.0) THEN
            WRITE(ErrorOut,*) ' JETSET-reject at event',
     &                    NEVHKK,MSTU(24),KMODE
C           CALL DT_EVTOUT(4)

C           CALL PYLIST(2)

            GOTO 9999
         ENDIF

c   number of entries in LUJETS

         NLINES = PYK(0,1)

         NPYMEM = NLINES

         DO 12 I=1,NLINES
            IFLG(I) = 0
   12    CONTINUE

         DO 13 II=1,NLINES

            IF ((PYK(II,7).EQ.1).AND.(IFLG(II).NE.1)) THEN

c  pick up mother resonance if possible and put it together with
c  their decay-products into the common
               IDXMOR = K(II,3)
               IF ((IDXMOR.GE.1).AND.(IDXMOR.LE.MAXLND)) THEN
                  KFMOR = K(IDXMOR,2)
                  ISMOR = K(IDXMOR,1)
               ELSE
                  KFMOR = 91
                  ISMOR = 1
               ENDIF
               IF ((KFMOR.NE.91).AND.(KFMOR.NE.92).AND.
     &             (KFMOR.NE.94).AND.(ISMOR.EQ.11)) THEN
                  ID = K(IDXMOR,2)

                  MO = IHISMO(PYK(IDXMOR,15))
                  PX = PYP(IDXMOR,1)
                  PY = PYP(IDXMOR,2)
                  PZ = PYP(IDXMOR,3)
                  PE = PYP(IDXMOR,4)

                  CALL DT_EVTPUT(2,ID,MO,0,PX,PY,PZ,PE,0,0,0)
                  IFLG(IDXMOR) = 1
                  MO = NHKK
                  DO 15 JDAUG=K(IDXMOR,4),K(IDXMOR,5)

                     IF (PYK(JDAUG,7).EQ.1) THEN
                        ID = PYK(JDAUG,8)
                        PX = PYP(JDAUG,1)
                        PY = PYP(JDAUG,2)
                        PZ = PYP(JDAUG,3)
                        PE = PYP(JDAUG,4)

                        CALL DT_EVTPUT(1,ID,MO,0,PX,PY,PZ,PE,0,0,0)
                        IF (LEMCCK) THEN

                           PX = -PYP(JDAUG,1)
                           PY = -PYP(JDAUG,2)
                           PZ = -PYP(JDAUG,3)
                           PE = -PYP(JDAUG,4)

                           CALL DT_EVTEMC(PX,PY,PZ,PE,2,IDUM,IDUM)
                        ENDIF
                        IFLG(JDAUG) = 1
                     ENDIF
   15             CONTINUE
               ELSE
c  there was no mother resonance

                  MO = IHISMO(PYK(II,15))
                  ID = PYK(II,8)
                  PX = PYP(II,1)
                  PY = PYP(II,2)
                  PZ = PYP(II,3)
                  PE = PYP(II,4)

                  CALL DT_EVTPUT(1,ID,MO,0,PX,PY,PZ,PE,0,0,0)
                  IF (LEMCCK) THEN

                     PX = -PYP(II,1)
                     PY = -PYP(II,2)
                     PZ = -PYP(II,3)
                     PE = -PYP(II,4)

                     CALL DT_EVTEMC(PX,PY,PZ,PE,2,IDUM,IDUM)
                  ENDIF
               ENDIF
            ENDIF
   13    CONTINUE
         IF (LEMCCK) THEN
            CHKLEV = TINY1
            CALL DT_EVTEMC(DUM,DUM,DUM,CHKLEV,-1,6,IREJ1)
C           IF (IREJ1.NE.0) CALL DT_EVTOUT(4)
         ENDIF

c global energy-momentum & flavor conservation check
c*sr 16.5. this check is skipped in case of phojet-treatment
         IF (MCGENE.EQ.1)
     &      CALL DT_EMC2(9,10,0,0,0,3,1,0,0,0,0,3,4,12,IREJ3)

c update statistics-counter for diffraction
c        IF (IFLAGD.NE.0) THEN
c           ICDIFF(1) = ICDIFF(1)+1
c           IF (IFLAGD.EQ. 1) ICDIFF(2) = ICDIFF(2)+1
c           IF (IFLAGD.EQ. 2) ICDIFF(3) = ICDIFF(3)+1
c           IF (IFLAGD.EQ.-1) ICDIFF(4) = ICDIFF(4)+1
c           IF (IFLAGD.EQ.-2) ICDIFF(5) = ICDIFF(5)+1
c        ENDIF

      ENDIF

      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===decay==============================================================*
c
CDECK  ID>, DT_DECAYS
      SUBROUTINE DT_DECAYS(PIN,IDXIN,POUT,IDXOUT,NSEC,IREJ)

c***********************************************************************
c Resonance-decay.                                                     *
c This subroutine replaces DDECAY/DECHKK.                              *
c             PIN(4)      4-momentum of resonance          (input)     *
c             IDXIN       BAMJET-index of resonance        (input)     *
c             POUT(20,4)  4-momenta of decay-products      (output)    *
c             IDXOUT(20)  BAMJET-indices of decay-products (output)    *
c             NSEC        number of secondaries            (output)    *
c Adopted from the original version DECHKK.                            *
c This version dated 09.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY17=1.0D-17)

c HADRIN: decay channel information
      PARAMETER (IDMAX9=602)
      CHARACTER*8 ZKNAME
      COMMON /HNDECH/ ZKNAME(IDMAX9),WT(IDMAX9),NZK(IDMAX9,3)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME


      DIMENSION PIN(4),PI(20,4),POUT(20,4),IDXOUT(20),
     &          EF(3),PF(3),PFF(3),IDXSTK(20),IDX(3),
     &          CODF(3),COFF(3),SIFF(3),DCOS(3),DCOSF(3)

c ISTAB = 1 strong and weak decays
c       = 2 strong decays only
c       = 3 strong decays, weak decays for charmed particles and tau
c           leptons only
      DATA ISTAB /2/

      IREJ = 0
      NSEC = 0
c put initial resonance to stack
      NSTK = 1
      IDXSTK(NSTK) = IDXIN
      DO 5 I=1,4
         PI(NSTK,I) = PIN(I)
    5 CONTINUE

c store initial configuration for energy-momentum cons. check
      IF (LEMCCK) CALL DT_EVTEMC(PI(NSTK,1),PI(NSTK,2),PI(NSTK,3),
     &                                   PI(NSTK,4),1,IDUM,IDUM)

  100 CONTINUE
c get particle from stack
      IDXI = IDXSTK(NSTK)
c skip stable particles
      IF (ISTAB.EQ.1) THEN
         IF ((IDXI.EQ.135).OR. (IDXI.EQ.136)) GOTO 10
         IF ((IDXI.GE.  1).AND.(IDXI.LE.  7)) GOTO 10
      ELSEIF (ISTAB.EQ.2) THEN
         IF ((IDXI.GE.  1).AND.(IDXI.LE. 30)) GOTO 10
         IF ((IDXI.GE. 97).AND.(IDXI.LE.103)) GOTO 10
         IF ((IDXI.GE.115).AND.(IDXI.LE.122)) GOTO 10
         IF ((IDXI.GE.131).AND.(IDXI.LE.136)) GOTO 10
         IF ( IDXI.EQ.109)                    GOTO 10
         IF ((IDXI.GE.137).AND.(IDXI.LE.160)) GOTO 10
      ELSEIF (ISTAB.EQ.3) THEN
         IF ((IDXI.GE.  1).AND.(IDXI.LE. 23)) GOTO 10
         IF ((IDXI.GE. 97).AND.(IDXI.LE.103)) GOTO 10
         IF ((IDXI.GE.109).AND.(IDXI.LE.115)) GOTO 10
         IF ((IDXI.GE.133).AND.(IDXI.LE.136)) GOTO 10
      ENDIF

c calculate direction cosines and Lorentz-parameter of decaying part.
      PTOT = SQRT(PI(NSTK,1)**2+PI(NSTK,2)**2+PI(NSTK,3)**2)
      PTOT = MAX(PTOT,TINY17)
      DO 1 I=1,3
         DCOS(I) = PI(NSTK,I)/PTOT
    1 CONTINUE
      GAM  = PI(NSTK,4)/AAM(IDXI)
      BGAM = PTOT/AAM(IDXI)

c get decay-channel
      KCHAN = K1(IDXI)-1
    2 CONTINUE
      KCHAN = KCHAN+1
      IF ((DT_RNDM(GAM)-TINY17).GT.WT(KCHAN)) GOTO 2

c identities of secondaries
      IDX(1) = NZK(KCHAN,1)
      IDX(2) = NZK(KCHAN,2)
      IF (IDX(2).LT.1) GOTO 9999
      IDX(3) = NZK(KCHAN,3)

c handle decay in rest system of decaying particle
      IF (IDX(3).EQ.0) THEN
c   two-particle decay
         NDEC = 2
         CALL DT_DTWOPD(AAM(IDXI),EF(1),EF(2),PF(1),PF(2),
     &               CODF(1),COFF(1),SIFF(1),CODF(2),COFF(2),SIFF(2),
     &               AAM(IDX(1)),AAM(IDX(2)))
      ELSE
c   three-particle decay
         NDEC = 3
         CALL DT_DTHREP(AAM(IDXI),EF(1),EF(2),EF(3),PF(1),PF(2),PF(3),
     &               CODF(1),COFF(1),SIFF(1),CODF(2),COFF(2),SIFF(2),
     &               CODF(3),COFF(3),SIFF(3),
     &               AAM(IDX(1)),AAM(IDX(2)),AAM(IDX(3)))
      ENDIF
      NSTK = NSTK-1

c transform decay products back
      DO 3 I=1,NDEC
         NSTK = NSTK+1
         CALL DT_DTRAFO(GAM,BGAM,DCOS(1),DCOS(2),DCOS(3),
     &               CODF(I),COFF(I),SIFF(I),PF(I),EF(I),
     &               PFF(I),DCOSF(1),DCOSF(2),DCOSF(3),PI(NSTK,4))
c add particle to stack
         IDXSTK(NSTK) = IDX(I)
         DO 4 J=1,3
            PI(NSTK,J) = DCOSF(J)*PFF(I)
    4    CONTINUE
    3 CONTINUE
      GOTO 100

   10 CONTINUE
c stable particle, put to output-arrays
      NSEC = NSEC+1
      DO 6 I=1,4
         POUT(NSEC,I) = PI(NSTK,I)
    6 CONTINUE
      IDXOUT(NSEC) = IDXSTK(NSTK)
c store secondaries for energy-momentum conservation check
      IF (LEMCCK)
     &CALL DT_EVTEMC(-POUT(NSEC,1),-POUT(NSEC,2),-POUT(NSEC,3),
     &            -POUT(NSEC,4),2,IDUM,IDUM)
      NSTK = NSTK-1
      IF (NSTK.GT.0) GOTO 100

c check energy-momentum conservation
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(DUM,DUM,DUM,DUM,3,5,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
      ENDIF

      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===decay1=============================================================*
c
CDECK  ID>, DT_DECAY1
      SUBROUTINE DT_DECAY1

c***********************************************************************
c Decay of resonances stored in DTEVT1.                                *
c This version dated 20.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)


      DIMENSION PIN(4),POUT(20,4),IDXOUT(20)

      NEND = NHKK
C     DO 1 I=NPOINT(5),NEND
      DO 1 I=NPOINT(4),NEND
         IF (ABS(ISTHKK(I)).EQ.1) THEN
            DO 2 K=1,4
               PIN(K) = PHKK(K,I)
    2       CONTINUE
            IDXIN = IDBAM(I)
            CALL DT_DECAYS(PIN,IDXIN,POUT,IDXOUT,NSEC,IREJ)
            IF (NSEC.GT.1) THEN
               DO 3 N=1,NSEC
                  IDHAD = IDT_IPDGHA(IDXOUT(N))
                  CALL DT_EVTPUT(1,IDHAD,I,0,POUT(N,1),POUT(N,2),
     &                               POUT(N,3),POUT(N,4),0,0,0)
    3          CONTINUE
            ENDIF
         ENDIF
    1 CONTINUE

      RETURN
      END
c
c===decpi0=============================================================*
c
CDECK  ID>, DT_DECPI0
      SUBROUTINE DT_DECPI0

c***********************************************************************
c Decay of pi0 handled with JETSET.                                    *
c This version dated 18.02.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY3=1.0D-3,ONE=1.0D0,ZERO=0.0D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)


      COMMON/PYDAT3/MDCY(500,3),MDME(4000,2),BRAT(4000),KFDP(4000,5)



      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)



      PARAMETER (MAXLND=4000)
      COMMON/PYJETS/N,NPAD,K(MAXLND,5),P(MAXLND,5),V(MAXLND,5)


c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME



      INTEGER PYCOMP,PYK


      DIMENSION IHISMO(NMXHKK),P1(4)

      TWOPI = 2.0D0*ATAN2(0.0D0,-1.0D0)

      CALL DT_INITJS(2)
c allow pi0 decay

      KC = PYCOMP(111)

      MDCY(KC,1) = 1

      NN  = 0
      INI = 0
      DO 1 I=1,NHKK
         IF ((ISTHKK(I).EQ.1).AND.(IDHKK(I).EQ.111)) THEN
            IF (INI.EQ.0) THEN
               INI = 1
            ELSE
               INI = 2
            ENDIF
            IF (LEMCCK) CALL DT_EVTEMC(PHKK(1,I),PHKK(2,I),PHKK(3,I),
     &                                    PHKK(4,I),INI,IDUM,IDUM)
            PT    = SQRT(PHKK(1,I)**2+PHKK(2,I)**2)
            PTOT  = SQRT(PT**2+PHKK(3,I)**2)
            COSTH = PHKK(3,I)/(PTOT+TINY10)
            IF (COSTH.GT.ONE) THEN
               THETA = ZERO
            ELSEIF (COSTH.LT.-ONE) THEN
               THETA = TWOPI/2.0D0
            ELSE
               THETA = ACOS(COSTH)
            ENDIF
            PHI     = ASIN(PHKK(2,I)/(PT  +TINY10))
            IF (PHKK(1,I).LT.0.0D0)

     &         PHI  = SIGN(TWOPI/2.0D0-ABS(PHI),PHI)

            ENER    = PHKK(4,I)
            NN      = NN+1
            KTEMP   = MSTU(10)
            MSTU(10)= 1
            P(NN,5) = PHKK(5,I)

            CALL PY1ENT(NN,111,ENER,THETA,PHI)

            MSTU(10)  = KTEMP
            IHISMO(NN)= I
         ENDIF
    1 CONTINUE
      IF (NN.GT.0) THEN

         CALL PYEXEC


         NLINES = PYK(0,1)

         DO 2 II=1,NLINES

            IF (PYK(II,7).EQ.1) THEN

               DO 3 KK=1,4

                  P1(KK) = PYP(II,KK)

    3          CONTINUE

               ID = PYK(II,8)
               MO = IHISMO(PYK(II,15))

               CALL DT_EVTPUT(1,ID,MO,0,P1(1),P1(2),P1(3),P1(4),0,0,0)
               IF (LEMCCK)
     &            CALL DT_EVTEMC(-P1(1),-P1(2),-P1(3),-P1(4),2,
     &                                            IDUM,IDUM)
csr: flag with neg. sign (for HELIOS p/A-W jobs)
               ISTHKK(MO) = -2
            ENDIF
    2    CONTINUE
         IF (LEMCCK) CALL DT_EVTEMC(DUM,DUM,DUM,DUM,4,7000,IREJ1)
      ENDIF
      MDCY(KC,1) = 0

      RETURN
      END
c
c===dtwopd=============================================================*
c
CDECK  ID>, DT_DTWOPD
      SUBROUTINE DT_DTWOPD(UMO,ECM1,ECM2,PCM1,PCM2,COD1,COF1,SIF1,COD2,
     &                                            COF2,SIF2,AM1,AM2)

c***********************************************************************
c Two-particle decay.                                                  *
c  UMO                 cm-energy of the decaying system       (input)  *
c  AM1/AM2             masses of the decay products           (input)  *
c  ECM1,ECM2/PCM1,PCM2 cm-energies/momenta of the decay prod. (output) *
c  COD,COF,SIF         direction cosines of the decay prod.   (output) *
c Revised by S. Roesler, 20.11.95                                      *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0,ZERO=0.0D0)

      IF (UMO.LT.(AM1+AM2)) THEN
         WRITE(ErrorOut,1000) UMO,AM1,AM2
 1000    FORMAT(1X,'DTWOPD:    INCONSISTENT KINEMATICS - UMO,AM1,AM2 ',
     &          3E12.3)
         STOP
      ENDIF

      ECM1 = ((UMO-AM2)*(UMO+AM2)+AM1*AM1)/(TWO*UMO)
      ECM2 = UMO-ECM1
      PCM1 = SQRT((ECM1-AM1)*(ECM1+AM1))
      PCM2 = PCM1
      CALL DT_DSFECF(SIF1,COF1)
      COD1 = TWO*DT_RNDM(PCM2)-ONE
      COD2 = -COD1
      COF2 = -COF1
      SIF2 = -SIF1

      RETURN
      END
c
c===dthrep=============================================================*
c
CDECK  ID>, DT_DTHREP
      SUBROUTINE DT_DTHREP(UMO,ECM1,ECM2,ECM3,PCM1,PCM2,PCM3,COD1,COF1,
     &                  SIF1,COD2,COF2,SIF2,COD3,COF3,SIF3,AM1,AM2,AM3)

c***********************************************************************
c Three-particle decay.                                                *
c  UMO                 cm-energy of the decaying system       (input)  *
c  AM1/2/3             masses of the decay products           (input)  *
c  ECM1/2/2,PCM1/2/3   cm-energies/momenta of the decay prod. (output) *
c  COD,COF,SIF         direction cosines of the decay prod.   (output) *
c                                                                      *
c Threpd89: slight revision by A. Ferrari                              *
c Last change on   11-oct-93   by    Alfredo Ferrari, INFN - Milan     *
c Revised by S. Roesler, 20.11.95                                      *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( PIPIPI = 3.1415926535897932270 D+00 )

      COMMON /HNGAMR/ REDU,AMO,AMM(15)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME


      DIMENSION F(5),XX(5)
      DATA EPS /AZRZRZ/

      UMOO=UMO+UMO
C***S1, S2, S3 ARE THE INVARIANT MASSES OF THE PARTICLES 1, 2, 3
C***J. VON NEUMANN - RANDOM - SELECTION OF S2
C***CALCULATION OF THE MAXIMUM OF THE S2 - DISTRIBUTION
      UUMO=UMO
      AAM1=AM1
      AAM2=AM2
      AAM3=AM3
      GU=(AM2+AM3)**2
      GO=(UMO-AM1)**2
c     UFAK=1.0000000000001D0
c     IF (GU.GT.GO) UFAK=0.9999999999999D0
      IF (GU.GT.GO) THEN
         UFAK=ONEMNS
      ELSE
         UFAK=ONEPLS
      END IF
      OFAK=2.D0-UFAK
      GU=GU*UFAK
      GO=GO*OFAK
      DS2=(GO-GU)/99.D0
      AM11=AM1*AM1
      AM22=AM2*AM2
      AM33=AM3*AM3
      UMO2=UMO*UMO
      RHO2=0.D0
      S22=GU
      DO 124 I=1,100
         S21=S22
         S22=GU+(I-1.D0)*DS2
         RHO1=RHO2
         RHO2=DT_YLAMB(S22,UMO2,AM11)*DT_YLAMB(S22,AM22,AM33)/
     *                                             (S22+EPS)
         IF(RHO2.LT.RHO1) GO TO 125
  124 CONTINUE
  125 S2SUP=(S22-S21)*.5D0+S21
      SUPRHO=DT_YLAMB(S2SUP,UMO2,AM11)*DT_YLAMB(S2SUP,AM22,AM33)/
     *                                           (S2SUP+EPS)
      SUPRHO=SUPRHO*1.05D0
      XO=S21-DS2
      IF (GU.LT.GO.AND.XO.LT.GU) XO=GU
      IF (GU.GT.GO.AND.XO.GT.GU) XO=GU
      XX(1)=XO
      XX(3)=S22
      X1=(XO+S22)*0.5D0
      XX(2)=X1
      F(3)=RHO2
      F(1)=DT_YLAMB(XO,UMO2,AM11)*DT_YLAMB(XO,AM22,AM33)/(XO+EPS)
      F(2)=DT_YLAMB(X1,UMO2,AM11)*DT_YLAMB(X1,AM22,AM33)/(X1+EPS)
      DO 126 I=1,16
         X4=(XX(1)+XX(2))*0.5D0
         X5=(XX(2)+XX(3))*0.5D0
         F(4)=DT_YLAMB(X4,UMO2,AM11)*DT_YLAMB(X4,AM22,AM33)/
     *                                               (X4+EPS)
         F(5)=DT_YLAMB(X5,UMO2,AM11)*DT_YLAMB(X5,AM22,AM33)/
     *                                               (X5+EPS)
         XX(4)=X4
         XX(5)=X5
         DO 128 II=1,5
            IA=II
            DO 128 III=IA,5
               IF (F (II).GE.F (III)) GO TO 128
               FH=F(II)
               F(II)=F(III)
               F(III)=FH
               FH=XX(II)
               XX(II)=XX(III)
               XX(III)=FH
128      CONTINUE
         SUPRHO=F(1)
         S2SUP=XX(1)
         DO 129 II=1,3
            IA=II
            DO 129 III=IA,3
               IF (XX(II).GE.XX(III)) GO TO 129
               FH=F(II)
               F(II)=F(III)
               F(III)=FH
               FH=XX(II)
               XX(II)=XX(III)
               XX(III)=FH
129      CONTINUE
126   CONTINUE
      AM23=(AM2+AM3)**2
      ITH=0
      REDU=2.D0
    1 CONTINUE
      ITH=ITH+1
      IF (ITH.GT.200) REDU=-9.D0
      IF (ITH.GT.200) GO TO 400
      C=DT_RNDM(REDU)
c     S2=AM23+C*((UMO-AM1)**2-AM23)
      S2=AM23+C*(UMO-AM1-AM2-AM3)*(UMO-AM1+AM2+AM3)
      Y=DT_RNDM(S2)
      Y=Y*SUPRHO
      RHO=DT_YLAMB(S2,UMO2,AM11)*DT_YLAMB(S2,AM22,AM33)/S2
      IF(Y.GT.RHO) GO TO 1
C***RANDOM SELECTION OF S3 AND CALCULATION OF S1
      S1=DT_RNDM(S2)
      S1=S1*RHO+AM11+AM22-(S2-UMO2+AM11)*(S2+AM22-AM33)/(2.D0*S2)-
     &RHO*.5D0
      S3=UMO2+AM11+AM22+AM33-S1-S2
      ECM1=(UMO2+AM11-S2)/UMOO
      ECM2=(UMO2+AM22-S3)/UMOO
      ECM3=(UMO2+AM33-S1)/UMOO
      PCM1=SQRT((ECM1+AM1)*(ECM1-AM1))
      PCM2=SQRT((ECM2+AM2)*(ECM2-AM2))
      PCM3=SQRT((ECM3+AM3)*(ECM3-AM3))
      CALL DT_DSFECF(SFE,CFE)
C***TH IS THE ANGLE BETWEEN PARTICLES 1 AND 2
C***TH1, TH2 ARE THE ANGLES BETWEEN PARTICLES 1, 2 AND THE DIRECTION OF
      PCM12 = PCM1 * PCM2
      IF ( PCM12 .LT. ANGLSQ ) GO TO 200
      COSTH=(ECM1*ECM2+0.5D+00*(AM11+AM22-S1))/PCM12
      GO TO 300
 200  CONTINUE
         UW=DT_RNDM(S1)
         COSTH=(UW-0.5D+00)*2.D+00
 300  CONTINUE
c     IF(ABS(COSTH).GT.0.9999999999999999D0)
c    &COSTH=SIGN(0.9999999999999999D0,COSTH)
      IF(ABS(COSTH).GT.ONEONE)
     &COSTH=SIGN(ONEONE,COSTH)
      IF (REDU.LT.1.D+00) RETURN
      COSTH2=(PCM3*PCM3+PCM2*PCM2-PCM1*PCM1)/(2.D+00*PCM2*PCM3)
c     IF(ABS(COSTH2).GT.0.9999999999999999D0)
c    &COSTH2=SIGN(0.9999999999999999D0,COSTH2)
      IF(ABS(COSTH2).GT.ONEONE)
     &COSTH2=SIGN(ONEONE,COSTH2)
      SINTH2=SQRT((ONEONE-COSTH2)*(ONEONE+COSTH2))
      SINTH =SQRT((ONEONE-COSTH)*(ONEONE+COSTH))
      SINTH1=COSTH2*SINTH-COSTH*SINTH2
      COSTH1=COSTH*COSTH2+SINTH2*SINTH
C***RANDOM SELECTION OF THE SPHERICAL COORDINATES OF THE DIRECTION OF PA
C***CFE, SFE ARE COS AND SIN OF THE ROTATION ANGLE OF THE SYSTEM 1, 2 AR
C***THE DIRECTION OF PARTICLE 3
C***CALCULATION OF THE SPHERICAL COORDINATES OF PARTICLES 1, 2
      CX11=-COSTH1
      CY11=SINTH1*CFE
      CZ11=SINTH1*SFE
      CX22=-COSTH2
      CY22=-SINTH2*CFE
      CZ22=-SINTH2*SFE
      CALL DT_DSFECF(SIF3,COF3)
      COD3=TWOTWO*DT_RNDM(CX11)-ONEONE
      SID3=SQRT((1.D+00-COD3)*(1.D+00+COD3))
    2 FORMAT(5F20.15)
      COD1=CX11*COD3+CZ11*SID3
      CHLP=(ONEONE-COD1)*(ONEONE+COD1)
      IF(CHLP.LT.1.D-14)WRITE(ErrorOut,2)COD1,COF3,SID3,
     &CX11,CZ11
      SID1=SQRT(CHLP)
      COF1=(CX11*SID3*COF3-CY11*SIF3-CZ11*COD3*COF3)/SID1
      SIF1=(CX11*SID3*SIF3+CY11*COF3-CZ11*COD3*SIF3)/SID1
      COD2=CX22*COD3+CZ22*SID3
      SID2=SQRT((ONEONE-COD2)*(ONEONE+COD2))
      COF2=(CX22*SID3*COF3-CY22*SIF3-CZ22*COD3*COF3)/SID2
      SIF2=(CX22*SID3*SIF3+CY22*COF3-CZ22*COD3*SIF3)/SID2
 400  CONTINUE
c === Energy conservation check: === *
      EOCHCK = UMO - ECM1 - ECM2 - ECM3
c     SID1 = SQRT ( ( ONEONE - COD1 ) * ( ONEONE + COD1 ) )
c     SID2 = SQRT ( ( ONEONE - COD2 ) * ( ONEONE + COD2 ) )
c     SID3 = SQRT ( ( ONEONE - COD3 ) * ( ONEONE + COD3 ) )
      PZCHCK = PCM1 * COD1 + PCM2 * COD2 + PCM3 * COD3
      PXCHCK = PCM1 * COF1 * SID1 + PCM2 * COF2 * SID2
     &       + PCM3 * COF3 * SID3
      PYCHCK = PCM1 * SIF1 * SID1 + PCM2 * SIF2 * SID2
     &       + PCM3 * SIF3 * SID3
      EOCMPR = 1.D-12 * UMO
      IF ( ABS (EOCHCK) + ABS (PXCHCK) + ABS (PYCHCK) + ABS (PZCHCK)
     &     .GT. EOCMPR ) THEN
c*sr 5.5.95 output-unit changed
         IF (IOULEV(1).GT.0) THEN
            WRITE(ErrorOut,*)
     &      ' *** THREPD: ENERGY/MOMENTUM CONSERVATION FAILURE! ***',
     &      EOCHCK,PXCHCK,PYCHCK,PZCHCK
            WRITE(ErrorOut,
     * *)' *** SID1,SID2,SID3',SID1,SID2,SID3
         ENDIF
c*
      END IF
      RETURN
      END
c
c===dbklas=============================================================*
c
CDECK  ID>, DT_DBKLAS
      SUBROUTINE DT_DBKLAS(I,J,K,I8,I10)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c quark-content to particle index conversion (DTUNUC 1.x)
      COMMON /DTQ2ID/ IMPS(6,6),IMVE(6,6),IB08(6,21),IB10(6,21),
     &                IA08(6,21),IA10(6,21)


      IF (I) 20,20,10
c baryons
   10 CONTINUE
      CALL DT_INDEXD(J,K,IND)
      I8  = IB08(I,IND)
      I10 = IB10(I,IND)
      IF (I8.LE.0) I8 = I10
      RETURN
c antibaryons
   20 CONTINUE
      II = IABS(I)
      JJ = IABS(J)
      KK = IABS(K)
      CALL DT_INDEXD(JJ,KK,IND)
      I8  = IA08(II,IND)
      I10 = IA10(II,IND)
      IF (I8.LE.0) I8 = I10

      RETURN
      END
c
c===indexd=============================================================*
c
CDECK  ID>, DT_INDEXD
      SUBROUTINE DT_INDEXD(KA,KB,IND)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      KP = KA*KB
      KS = KA+KB
      IF (KP.EQ.1) IND=1
      IF (KP.EQ.2) IND=2
      IF (KP.EQ.3) IND=3
      IF ((KP.EQ.4).AND.(KS.EQ.5)) IND=4
      IF (KP.EQ.5) IND=5
      IF ((KP.EQ.6).AND.(KS.EQ.7)) IND=6
      IF ((KP.EQ.4).AND.(KS.EQ.4)) IND=7
      IF ((KP.EQ.6).AND.(KS.EQ.5)) IND=8
      IF (KP.EQ.8)  IND=9
      IF (KP.EQ.10) IND=10
      IF ((KP.EQ.12).AND.(KS.EQ.8)) IND=11
      IF (KP.EQ.9)  IND=12
      IF ((KP.EQ.12).AND.(KS.EQ.7)) IND=13
      IF (KP.EQ.15) IND=14
      IF (KP.EQ.18) IND=15
      IF (KP.EQ.16) IND=16
      IF (KP.EQ.20) IND=17
      IF (KP.EQ.24) IND=18
      IF (KP.EQ.25) IND=19
      IF (KP.EQ.30) IND=20
      IF (KP.EQ.36) IND=21

      RETURN
      END
c
c===dchant=============================================================*
c
CDECK  ID>, DT_DCHANT
      SUBROUTINE DT_DCHANT

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ONE=1.0D0,ZERO=0.0D0)

c HADRIN: decay channel information
      PARAMETER (IDMAX9=602)
      CHARACTER*8 ZKNAME
      COMMON /HNDECH/ ZKNAME(IDMAX9),WT(IDMAX9),NZK(IDMAX9,3)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


      DIMENSION HWT(IDMAX9)

c change of weights wt from absolut values into the sum of wt of a dec.
      DO 10 J=1,IDMAX9
         HWT(J) = ZERO
   10 CONTINUE
C     DO 999 KKK=1,210
C        WRITE(LOUT,'(A8,F5.2,2E10.3,2I4,2I10)')
C    &      ANAME(KKK),AAM(KKK),GA(KKK),TAU(KKK),IICH(KKK),IIBAR(KKK),
C    &      K1(KKK),K2(KKK)
C 999 CONTINUE
C     STOP
      DO 30 I=1,210
         IK1 = K1(I)
         IK2 = K2(I)
         HV  = ZERO
         DO 20 J=IK1,IK2
            HV     = HV+WT(J)
            HWT(J) = HV
c*sr 13.1.95
            IF (HWT(J).GT.1.0001) WRITE(ErrorOut,
     * 1000) HWT(J),J,I,IK1
 1000       FORMAT(2X,15H ERROR IN HWT =,1F10.5,8H J,I,K1=,3I5)
   20    CONTINUE
   30 CONTINUE
      DO 40 J=1,IDMAX9
         WT(J) = HWT(J)
   40 CONTINUE

      RETURN
      END
c
c===ddatar=============================================================*
c
CDECK  ID>, DT_DDATAR
      SUBROUTINE DT_DDATAR

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ONE=1.0D0,ZERO=0.0D0)

c quark-content to particle index conversion (DTUNUC 1.x)
      COMMON /DTQ2ID/ IMPS(6,6),IMVE(6,6),IB08(6,21),IB10(6,21),
     &                IA08(6,21),IA10(6,21)


      DIMENSION IV(36),IP(36),IB(126),IBB(126),IA(126),IAA(126)

      DATA IV/ 33, 34, 38,123,  0,  0, 32, 33, 39,124,
     &          0,  0, 36, 37, 96,127,  0,  0,126,125,
     &        128,129,14*0/
      DATA IP/ 23, 14, 16,116,  0,  0, 13, 23, 25,117,
     &          0,  0, 15, 24, 31,120,  0,  0,119,118,
     &        121,122,14*0/
      DATA IB/  0,  1, 21,140,  0,  0,  8, 22,137,  0,
     &          0, 97,138,  0,  0,146,  0,  0,  0,  0,
     &          0,  1,  8, 22,137,  0,  0,  0, 20,142,
     &          0,  0, 98,139,  0,  0,147,  0,  0,  0,
     &          0,  0, 21, 22, 97,138,  0,  0, 20, 98,
     &        139,  0,  0,  0,145,  0,  0,148,  0,  0,
     &          0,  0,  0,140,137,138,146,  0,  0,142,
     &        139,147,  0,  0,145,148,           50*0/
      DATA IBB/53, 54,104,161,  0,  0, 55,105,162,  0,
     &          0,107,164,  0,  0,167,  0,  0,  0,  0,
     &          0, 54, 55,105,162,  0,  0, 56,106,163,
     &          0,  0,108,165,  0,  0,168,  0,  0,  0,
     &          0,  0,104,105,107,164,  0,  0,106,108,
     &        165,  0,  0,109,166,  0,  0,169,  0,  0,
     &          0,  0,  0,161,162,164,167,  0,  0,163,
     &        165,168,  0,  0,166,169,  0,  0,170,47*0/
      DATA IA/  0,  2, 99,152,  0,  0,  9,100,149,  0,
     &          0,102,150,  0,  0,158,  0,  0,  0,  0,
     &          0,  2,  9,100,149,  0,  0,  0,101,154,
     &          0,  0,103,151,  0,  0,159,  0,  0,  0,
     &          0,  0, 99,100,102,150,  0,  0,101,103,
     &        151,  0,  0,  0,157,  0,  0,160,  0,  0,
     &          0,  0,  0,152,149,150,158,  0,  0,154,
     &        151,159,  0,  0,157,160,           50*0/
      DATA IAA/67, 68,110,171,  0,  0, 69,111,172,  0,
     &          0,113,174,  0,  0,177,  0,  0,  0,  0,
     &          0, 68, 69,111,172,  0,  0, 70,112,173,
     &          0,  0,114,175,  0,  0,178,  0,  0,  0,
     &          0,  0,110,111,113,174,  0,  0,112,114,
     &        175,  0,  0,115,176,  0,  0,179,  0,  0,
     &          0,  0,  0,171,172,174,177,  0,  0,173,
     &        175,178,  0,  0,176,179,  0,  0,180,47*0/

      L=0
      DO 2 I=1,6
         DO 1 J=1,6
            L = L+1
            IMPS(I,J) = IP(L)
            IMVE(I,J) = IV(L)
    1    CONTINUE
    2 CONTINUE
      L=0
      DO 4 I=1,6
         DO 3 J=1,21
            L = L+1
            IB08(I,J) = IB(L)
            IB10(I,J) = IBB(L)
            IA08(I,J) = IA(L)
            IA10(I,J) = IAA(L)
    3    CONTINUE
    4 CONTINUE
C     A1  = 0.88D0
C     B1  = 3.0D0
C     B2  = 3.0D0
C     B3  = 8.0D0
C     LT  = 0
C     LB  = 0
C     BET = 12.0D0
C     AS  = 0.25D0
C     B8  = 0.33D0
C     AME = 0.95D0
C     DIQ = 0.375D0
C     ISU = 4

      RETURN
      END
c
c===initjs=============================================================*
c
CDECK  ID>, DT_INITJS
      SUBROUTINE DT_INITJS(MODE)

c***********************************************************************
c Initialize JETSET paramters.                                         *
c           MODE = 0 default settings                                  *
c                = 1 PHOJET settings                                   *
c                = 2 DTUNUC settings                                   *
c This version dated 16.02.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ONE=1.0D0,ZERO=0.0D0)

      LOGICAL LFIRST,LFIRDT,LFIRPH


      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)



      COMMON/PYDAT3/MDCY(500,3),MDME(4000,2),BRAT(4000),KFDP(4000,5)


c flags for particle decays
      COMMON /DTFRPA/ MSTUX(20),PARUX(20),MSTJX(20),PARJX(20),
     &                IMSTU(20),IPARU(20),IMSTJ(20),IPARJ(20),
     &                NMSTU,NPARU,NMSTJ,NPARJ,PDB,PDBSEA(3),ISIG0,IPI0

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME



      INTEGER PYCOMP


      DIMENSION IDXSTA(40)
      DATA IDXSTA
c          K0s   pi0  lam   alam  sig+  asig+ sig-  asig- tet0  atet0
     &  /  310,  111, 3122,-3122, 3222,-3222, 3112,-3112, 3322,-3322,
c          tet- atet-  om-  aom-   D+    D-    D0    aD0   Ds+   aDs+
     &    3312,-3312, 3334,-3334,  411, -411,  421, -421,  431, -431,
c          etac lamc+alamc+sigc++ sigc+ sigc0asigc++asigc+asigc0 Ksic+
     &     441, 4122,-4122, 4222, 4212, 4112,-4222,-4212,-4112, 4232,
c         Ksic0 aKsic+aKsic0 sig0 asig0
     &    4132,-4232,-4132, 3212,-3212, 5*0/

      DATA LFIRST,LFIRDT,LFIRPH /.TRUE.,.TRUE.,.TRUE./

      IF (LFIRST) THEN
c save default settings
         PDEF1  = PARJ(1)
         PDEF2  = PARJ(2)
         PDEF3  = PARJ(3)
         PDEF5  = PARJ(5)
         PDEF6  = PARJ(6)
         PDEF7  = PARJ(7)
         PDEF18 = PARJ(18)
         PDEF19 = PARJ(19)
         PDEF21 = PARJ(21)
         PDEF42 = PARJ(42)
         MDEF12 = MSTJ(12)
c LUJETS / PYJETS array-dimensions

         MSTU(4) = 4000

c increase maximum number of JETSET-error prints
         MSTU(22) = 50000
c prevent particles decaying
         DO 1 I=1,35
            IF (I.LT.34) THEN

               KC = PYCOMP(IDXSTA(I))

               IF (I.EQ.2) THEN
c  pi0 decay
C                 MDCY(KC,1) = 1
                  MDCY(KC,1) = 0
c*cr mode
C              ELSEIF ((I.EQ.4).OR.(I.EQ. 6).OR.
C   &                 (I.EQ.8).OR.(I.EQ.10)) THEN
C              ELSEIF (I.EQ.4) THEN
C                 MDCY(KC,1) = 1
c*
               ELSE
                  MDCY(KC,1) = 0
               ENDIF
            ELSEIF (((I.EQ.34).OR.(I.EQ.35)).AND.(ISIG0.EQ.0)) THEN

               KC = PYCOMP(IDXSTA(I))

               MDCY(KC,1) = 0
            ENDIF
    1    CONTINUE
c popcorn:
         IF (PDB.LE.ZERO) THEN
c   no popcorn-mechanism
            MSTJ(12) = 1
         ELSE
            MSTJ(12) = 3
            PARJ(5)  = PDB
         ENDIF
c set JETSET-parameter requested by input cards
         IF (NMSTU.GT.0) THEN
            DO 2 I=1,NMSTU
               MSTU(IMSTU(I)) = MSTUX(I)
    2       CONTINUE
         ENDIF
         IF (NMSTJ.GT.0) THEN
            DO 3 I=1,NMSTJ
               MSTJ(IMSTJ(I)) = MSTJX(I)
    3       CONTINUE
         ENDIF
         IF (NPARU.GT.0) THEN
            DO 4 I=1,NPARU
               PARU(IPARU(I)) = PARUX(I)
    4       CONTINUE
         ENDIF
         LFIRST = .FALSE.
      ENDIF
c
c PARJ(1)  suppression of qq-aqaq pair prod. compared to
c          q-aq pair prod.                      (default: 0.1)
c PARJ(2)  strangeness suppression               (default: 0.3)
c PARJ(3)  extra suppression of strange diquarks (default: 0.4)
c PARJ(6)  extra suppression of sas-pair shared by B and
c          aB in BMaB                           (default: 0.5)
c PARJ(7)  extra suppression of strange meson M in BMaB
c          configuration                        (default: 0.5)
c PARJ(18) spin 3/2 baryon suppression           (default: 1.0)
c PARJ(21) width sigma in Gaussian p_x, p_y transverse
c          momentum distrib. for prim. hadrons  (default: 0.35)
c PARJ(42) b-parameter for symmetric Lund-fragmentation
c          function                             (default: 0.9 GeV^-2)
c
c PHOJET settings
      IF (MODE.EQ.1) THEN
c   JETSET default
C        PARJ(1)  = PDEF1
C        PARJ(2)  = PDEF2
C        PARJ(3)  = PDEF3
C        PARJ(6)  = PDEF6
C        PARJ(7)  = PDEF7
C        PARJ(18) = PDEF18
C        PARJ(21) = PDEF21
C        PARJ(42) = PDEF42
c*sr 18.11.98 parameter tuning
C        PARJ(1)  = 0.092D0
C        PARJ(2)  = 0.25D0
C        PARJ(3)  = 0.45D0
C        PARJ(19) = 0.3D0
C        PARJ(21) = 0.45D0
C        PARJ(42) = 1.0D0
c*sr 28.04.99 parameter tuning (May 99 minor modifications)
         PARJ(1)  = 0.085D0
         PARJ(2)  = 0.26D0
         PARJ(3)  = 0.8D0
         PARJ(11) = 0.38D0
         PARJ(18) = 0.3D0
         PARJ(19) = 0.4D0
         PARJ(21) = 0.36D0
         PARJ(41) = 0.3D0
         PARJ(42) = 0.86D0
         IF (NPARJ.GT.0) THEN
            DO 10 I=1,NPARJ
               IF (IPARJ(I).GT.0) PARJ(IPARJ(I)) = PARJX(I)
   10       CONTINUE
         ENDIF
         IF (LFIRPH) THEN
            WRITE(ErrorOut,'(1X,A)')
     &         'DT_INITJS: JETSET-PARAMETER FOR PHOJET'
            CALL DT_JSPARA(0)
            LFIRPH = .FALSE.
         ENDIF
c DTUNUC settings
      ELSEIF (MODE.EQ.2) THEN
         IF (IFRAG(2).EQ.1) THEN
c*sr parameters before 9.3.96
C           PARJ(2)  = 0.27D0
C           PARJ(3)  = 0.6D0
C           PARJ(6)  = 0.75D0
C           PARJ(7)  = 0.75D0
C           PARJ(21) = 0.55D0
C           PARJ(42) = 1.3D0
c*sr 18.11.98 parameter tuning
C           PARJ(1)  = 0.05D0
C           PARJ(2)  = 0.27D0
C           PARJ(3)  = 0.4D0
C           PARJ(19) = 0.2D0
C           PARJ(21) = 0.45D0
C           PARJ(42) = 1.0D0
c*sr 28.04.99 parameter tuning
            PARJ(1)  = 0.11D0
            PARJ(2)  = 0.36D0
            PARJ(3)  = 0.8D0
            PARJ(19) = 0.2D0
            PARJ(21) = 0.3D0
            PARJ(41) = 0.3D0
            PARJ(42) = 0.58D0
            IF (NPARJ.GT.0) THEN
               DO 20 I=1,NPARJ
                  IF (IPARJ(I).LT.0) THEN
                     IDX = ABS(IPARJ(I))
                     PARJ(IDX) = PARJX(I)
                  ENDIF
   20          CONTINUE
            ENDIF
            IF (LFIRDT) THEN
               WRITE(ErrorOut,'(1X,A)')
     &           'DT_INITJS: JETSET-PARAMETER FOR DTUNUC'
               CALL DT_JSPARA(0)
               LFIRDT = .FALSE.
            ENDIF
         ELSEIF (IFRAG(2).EQ.2) THEN
            PARJ(1)  = 0.11D0
            PARJ(2)  = 0.27D0
            PARJ(3)  = 0.3D0
            PARJ(6)  = 0.35D0
            PARJ(7)  = 0.45D0
            PARJ(18) = 0.66D0
C           PARJ(21) = 0.55D0
C           PARJ(42) = 1.0D0
            PARJ(21) = 0.60D0
            PARJ(42) = 1.3D0
         ELSE
            PARJ(1)  = PDEF1
            PARJ(2)  = PDEF2
            PARJ(3)  = PDEF3
            PARJ(6)  = PDEF6
            PARJ(7)  = PDEF7
            PARJ(18) = PDEF18
            PARJ(21) = PDEF21
            PARJ(42) = PDEF42
         ENDIF
      ELSE
         PARJ(1)  = PDEF1
         PARJ(2)  = PDEF2
         PARJ(3)  = PDEF3
         PARJ(5)  = PDEF5
         PARJ(6)  = PDEF6
         PARJ(7)  = PDEF7
         PARJ(18) = PDEF18
         PARJ(19) = PDEF19
         PARJ(21) = PDEF21
         PARJ(42) = PDEF42
         MSTJ(12) = MDEF12
      ENDIF

      RETURN
      END
c
c===jspara=============================================================*
c
CDECK  ID>, DT_JSPARA
      SUBROUTINE DT_JSPARA(MODE)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY3=1.0D-3,TINY1=1.0D-1,
     &           ONE=1.0D0,ZERO=0.0D0)

      LOGICAL LFIRST


      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)



      DIMENSION ISTU(200),QARU(200),ISTJ(200),QARJ(200)

      DATA LFIRST /.TRUE./

c save the default JETSET-parameter on the first call
      IF (LFIRST) THEN
         DO 1 I=1,200
            ISTU(I) = MSTU(I)
            QARU(I) = PARU(I)
            ISTJ(I) = MSTJ(I)
            QARJ(I) = PARJ(I)
    1    CONTINUE
         LFIRST = .FALSE.
      ENDIF

      WRITE(ErrorOut,1000)
 1000 FORMAT(1X,'DT_JSPARA: NEW VALUE (DEFAULT VALUE)')

c compare the default JETSET-parameter with the present values
      DO 2 I=1,200
         IF ((MSTU(I).NE.ISTU(I)).AND.(I.NE.31)) THEN
            WRITE(ErrorOut,1002) 'MSTU(',I,MSTU(I),ISTU(I)
C           ISTU(I) = MSTU(I)
         ENDIF
         DIFF = ABS(PARU(I)-QARU(I))
         IF ((DIFF.GE.1.0D-5).AND.(I.NE.21)) THEN
            WRITE(ErrorOut,1001) 'PARU(',I,PARU(I),QARU(I)
C           QARU(I) = PARU(I)
         ENDIF
         IF (MSTJ(I).NE.ISTJ(I)) THEN
            WRITE(ErrorOut,1002) 'MSTJ(',I,MSTJ(I),ISTJ(I)
C           ISTJ(I) = MSTJ(I)
         ENDIF
         DIFF = ABS(PARJ(I)-QARJ(I))
         IF (DIFF.GE.1.0D-5) THEN
            WRITE(ErrorOut,1001) 'PARJ(',I,PARJ(I),QARJ(I)
C           QARJ(I) = PARJ(I)
         ENDIF
    2 CONTINUE
 1001 FORMAT(12X,A5,I3,'): ',F6.3,' (',F6.3,')')
 1002 FORMAT(12X,A5,I3,'): ',I6,' (',I6,')')

      RETURN
      END
c
c===fozoca=============================================================*
c
CDECK  ID>, DT_FOZOCA
      SUBROUTINE DT_FOZOCA(LFZC,IREJ)

c***********************************************************************
c This subroutine treats the complete FOrmation ZOne supressed intra-  *
c nuclear CAscade.                                                     *
c               LFZC = .true.  cascade has been treated                *
c                    = .false. cascade skipped                         *
c This is a completely revised version of the original FOZOKL.         *
c This version dated 18.11.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (DLARGE=1.0D10,OHALF=0.5D0,ZERO=0.0D0)
      PARAMETER (FM2MM=1.0D-12,RNUCLE = 1.12D0)

      LOGICAL LSTART,LCAS,LFZC

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c final state after intranuclear cascade step
      COMMON /DTPAUL/ EWOUND(2,300),NWOUND(2),IDXINC(2000),NOINC

c parameter for intranuclear cascade
      LOGICAL LPAULI
      COMMON /DTFOTI/ TAUFOR,KTAUGE,ITAUVE,INCMOD,LPAULI


      DIMENSION NCWOUN(2)

      DATA LSTART /.TRUE./

      LFZC = .TRUE.
      IREJ = 0

c skip cascade if hadron-hadron interaction or if supressed by user
      IF (((IP.EQ.1).AND.(IT.EQ.1)).OR.(KTAUGE.LT.1)) GOTO 9999
c skip cascade if not all possible chains systems are hadronized
      DO 1 I=1,8
         IF (.NOT.LHADRO(I)) GOTO 9999
    1 CONTINUE

      IF (LSTART) THEN
         WRITE(ErrorOut,1000) KTAUGE,TAUFOR,INCMOD
 1000    FORMAT(/,1X,'FOZOCA:  INTRANUCLEAR CASCADE TREATED FOR A ',
     &          'MAXIMUM OF',I4,' GENERATIONS',/,10X,'FORMATION TIME ',
     &          'PARAMETER:',F5.1,'  FM/C',9X,'MODUS:',I2)
         IF (ITAUVE.EQ.1) WRITE(ErrorOut,1001)
         IF (ITAUVE.EQ.2) WRITE(ErrorOut,1002)
 1001    FORMAT(10X,'P_T DEPENDENT FORMATION ZONE',/)
 1002    FORMAT(10X,'CONSTANT FORMATION ZONE',/)
         LSTART = .FALSE.
      ENDIF

c in order to avoid wasting of cpu-time the DTEVT1-indices of nucleons
c which may interact with final state particles are stored in a seperate
c array - here all proj./target nucleon-indices (just for simplicity)
      NOINC = 0
      DO 9 I=1,NPOINT(1)-1
         NOINC = NOINC+1
         IDXINC(NOINC) = I
    9 CONTINUE

c initialize Pauli-principle treatment (find wounded nucleons)
      NWOUND(1) = 0
      NWOUND(2) = 0
      NCWOUN(1) = 0
      NCWOUN(2) = 0
      DO 2 J=1,NPOINT(1)
         DO 3 I=1,2
            IF (ISTHKK(J).EQ.10+I) THEN
               NWOUND(I) = NWOUND(I)+1
               EWOUND(I,NWOUND(I)) = PHKK(4,J)
               IF (IDHKK(J).EQ.2212) NCWOUN(I) = NCWOUN(I)+1
            ENDIF
    3    CONTINUE
    2 CONTINUE

c modify nuclear potential for wounded nucleons
      IPRCL  = IP -NWOUND(1)
      IPZRCL = IPZ-NCWOUN(1)
      ITRCL  = IT -NWOUND(2)
      ITZRCL = ITZ-NCWOUN(2)
      CALL DT_NCLPOT(IPZRCL,IPRCL,ITZRCL,ITRCL,ZERO,ZERO,1)

      NSTART = NPOINT(4)
      NEND   = NHKK

    7 CONTINUE
      DO 8 I=NSTART,NEND

         IF ((ABS(ISTHKK(I)).EQ.1).AND.(IDCH(I).LT.KTAUGE)) THEN
c select nucleus the cascade starts first (proj. - 1, target - -1)
            NCAS   = 1
c   projectile/target with probab. 1/2
            IF ((INCMOD.EQ.1).OR.(IDCH(I).GT.0)) THEN
               IF (DT_RNDM(TAUFOR).GT.OHALF) NCAS = -NCAS
c   in the nucleus with highest mass
            ELSEIF (INCMOD.EQ.2) THEN
               IF (IP.GT.IT) THEN
                  NCAS = -NCAS
               ELSEIF (IP.EQ.IT) THEN
                  IF (DT_RNDM(TAUFOR).GT.OHALF) NCAS = -NCAS
               ENDIF
c the nucleus the cascade starts first is requested to be the one
c moving in the direction of the secondary
            ELSEIF (INCMOD.EQ.3) THEN
               NCAS = INT(SIGN(1.0D0,PHKK(3,I)))
            ENDIF
c check that the selected "nucleus" is not a hadron
            IF (((NCAS.EQ. 1).AND.(IP.LE.1)).OR.
     &          ((NCAS.EQ.-1).AND.(IT.LE.1)))    NCAS = -NCAS

c treat intranuclear cascade in the nucleus selected first
            LCAS = .FALSE.
            CALL DT_INUCAS(IT,IP,I,LCAS,NCAS,IREJ1)
            IF (IREJ1.NE.0) GOTO 9998
c treat intranuclear cascade in the other nucleus if this isn't a had.
            NCAS = -NCAS
            IF (((NCAS.EQ. 1).AND.(IP.GT.1)).OR.
     &          ((NCAS.EQ.-1).AND.(IT.GT.1)))    THEN
               IF (LCAS) CALL DT_INUCAS(IT,IP,I,LCAS,NCAS,IREJ1)
               IF (IREJ1.NE.0) GOTO 9998
            ENDIF

         ENDIF

    8 CONTINUE
      NSTART = NEND+1
      NEND   = NHKK
      IF (NSTART.LE.NEND) GOTO 7

      RETURN

 9998 CONTINUE
c reject this event
      IRINC = IRINC+1
      IREJ = 1

 9999 CONTINUE
c intranucl. cascade not treated because of interaction properties or
c it is supressed by user or it was rejected or...
      LFZC = .FALSE.
c reset flag characterizing direction of motion in n-n-cms
c*sr14-11-95
C     DO 9990 I=NPOINT(5),NHKK
C        IF (ISTHKK(I).EQ.-1) ISTHKK(I)=1
C9990 CONTINUE

      RETURN
      END
c
c===inucas=============================================================*
c
CDECK  ID>, DT_INUCAS
      SUBROUTINE DT_INUCAS(IT,IP,IDXCAS,LCAS,NCAS,IREJ)

c***********************************************************************
c Formation zone supressed IntraNUclear CAScade for one final state    *
c particle.                                                            *
c           IT, IP    mass numbers of target, projectile nuclei        *
c           IDXCAS    index of final state particle in DTEVT1          *
c           NCAS =  1 intranuclear cascade in projectile               *
c                = -1 intranuclear cascade in target                   *
c This version dated 18.11.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER (TINY10=1.0D-10,TINY2=1.0D-2,ZERO=0.0D0,DLARGE=1.0D10,
     &           OHALF=0.5D0,ONE=1.0D0)
      PARAMETER (FM2MM=1.0D-12,RNUCLE = 1.12D0)
      PARAMETER (TWOPI=6.283185307179586454D+00)
      PARAMETER (PLOWH=0.01D0,PHIH=9.0D0)

      LOGICAL LABSOR,LCAS

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c final state after inc step
      PARAMETER (MAXFSP=10)
      COMMON /DTCAPA/ PFSP(5,MAXFSP),IDFSP(MAXFSP),NFSP

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c parameter for intranuclear cascade
      LOGICAL LPAULI
      COMMON /DTFOTI/ TAUFOR,KTAUGE,ITAUVE,INCMOD,LPAULI

c final state after intranuclear cascade step
      COMMON /DTPAUL/ EWOUND(2,300),NWOUND(2),IDXINC(2000),NOINC

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c statistics: residual nuclei
      COMMON /DTSTA2/ EXCDPM(4),EXCEVA(2),
     &                NINCGE,NINCCO(2,3),NINCHR(2,2),NINCWO(2),
     &                NINCST(2,4),NINCEV(2),
     &                NRESTO(2),NRESPR(2),NRESNU(2),NRESBA(2),
     &                NRESPB(2),NRESCH(2),NRESEV(4),
     &                NEVA(2,6),NEVAGA(2),NEVAHT(2),NEVAHY(2,2,240),
     &                NEVAFI(2,2)


      DIMENSION PCAS(2,5),PTOCAS(2),COSCAS(2,3),VTXCAS(2,4),VTXCA1(2,4),
     &          PCAS1(5),PNUC(5),BGTA(4),
     &          BGCAS(2),GACAS(2),BECAS(2),
     &          RNUC(2),BIMPC(2),VTXDST(3),IDXSPE(2),IDSPE(2),NWTMP(2)

      DATA PDIF /0.545D0/

      IREJ = 0

c update counter
      IF (NINCEV(1).NE.NEVHKK) THEN
         NINCEV(1) = NEVHKK
         NINCEV(2) = NINCEV(2)+1
      ENDIF

c "BAMJET-index" of this hadron
      IDCAS = IDBAM(IDXCAS)
      IF (IDT_MCHAD(IDCAS).EQ.-1) RETURN

c skip gammas, electrons, etc..
      IF (AAM(IDCAS).LT.TINY2) RETURN

c Lorentz-trsf. into projectile rest system
      IF (IP.GT.1) THEN
         CALL DT_LTRANS(PHKK(1,IDXCAS),PHKK(2,IDXCAS),PHKK(3,IDXCAS),
     &               PHKK(4,IDXCAS),PCAS(1,1),PCAS(1,2),PCAS(1,3),
     &               PCAS(1,4),IDCAS,-2)
         PTOCAS(1) = SQRT(PCAS(1,1)**2+PCAS(1,2)**2+PCAS(1,3)**2)
         PCAS(1,5) = (PCAS(1,4)-PTOCAS(1))*(PCAS(1,4)+PTOCAS(1))
         IF (PCAS(1,5).GT.ZERO) THEN
            PCAS(1,5) = SQRT(PCAS(1,5))
         ELSE
            PCAS(1,5) = AAM(IDCAS)
         ENDIF
         DO 20 K=1,3
            COSCAS(1,K) = PCAS(1,K)/MAX(PTOCAS(1),TINY10)
   20    CONTINUE
c Lorentz-parameters
c   particle rest system --> projectile rest system
         BGCAS(1) = PTOCAS(1)/MAX(PCAS(1,5),TINY10)
         GACAS(1) = PCAS(1,4)/MAX(PCAS(1,5),TINY10)
         BECAS(1) = BGCAS(1)/GACAS(1)
      ELSE
         DO 21 K=1,5
            PCAS(1,K) = ZERO
            IF (K.LE.3) COSCAS(1,K) = ZERO
   21    CONTINUE
         PTOCAS(1) = ZERO
         BGCAS(1)  = ZERO
         GACAS(1)  = ZERO
         BECAS(1)  = ZERO
      ENDIF
c Lorentz-trsf. into target rest system
      IF (IT.GT.1) THEN
c LEPTO: final state particles are already in target rest frame
C        IF (MCGENE.EQ.3) THEN
C           PCAS(2,1) = PHKK(1,IDXCAS)
C           PCAS(2,2) = PHKK(2,IDXCAS)
C           PCAS(2,3) = PHKK(3,IDXCAS)
C           PCAS(2,4) = PHKK(4,IDXCAS)
C        ELSE
            CALL DT_LTRANS(PHKK(1,IDXCAS),PHKK(2,IDXCAS),PHKK(3,IDXCAS),
     &                  PHKK(4,IDXCAS),PCAS(2,1),PCAS(2,2),PCAS(2,3),
     &                  PCAS(2,4),IDCAS,-3)
C        ENDIF
         PTOCAS(2) = SQRT(PCAS(2,1)**2+PCAS(2,2)**2+PCAS(2,3)**2)
         PCAS(2,5) = (PCAS(2,4)-PTOCAS(2))*(PCAS(2,4)+PTOCAS(2))
         IF (PCAS(2,5).GT.ZERO) THEN
            PCAS(2,5) = SQRT(PCAS(2,5))
         ELSE
            PCAS(2,5) = AAM(IDCAS)
         ENDIF
         DO 22 K=1,3
            COSCAS(2,K) = PCAS(2,K)/MAX(PTOCAS(2),TINY10)
   22    CONTINUE
c Lorentz-parameters
c   particle rest system --> target rest system
         BGCAS(2) = PTOCAS(2)/MAX(PCAS(2,5),TINY10)
         GACAS(2) = PCAS(2,4)/MAX(PCAS(2,5),TINY10)
         BECAS(2) = BGCAS(2)/GACAS(2)
      ELSE
         DO 23 K=1,5
            PCAS(2,K) = ZERO
            IF (K.LE.3) COSCAS(2,K) = ZERO
   23    CONTINUE
         PTOCAS(2) = ZERO
         BGCAS(2)  = ZERO
         GACAS(2)  = ZERO
         BECAS(2)  = ZERO
      ENDIF

c radii of nuclei (mm) modified by the wall-depth of the Woods-Saxon-
c potential (see CONUCL)
      RNUC(1)  = (RPROJ+4.605D0*PDIF)*FM2MM
      RNUC(2)  = (RTARG+4.605D0*PDIF)*FM2MM
c impact parameter (the projectile moving along z)
      BIMPC(1) = ZERO
      BIMPC(2) = BIMPAC*FM2MM

c get position of initial hadron in projectile/target rest-syst.
      DO 3 K=1,4
         VTXCAS(1,K) = WHKK(K,IDXCAS)
         VTXCAS(2,K) = VHKK(K,IDXCAS)
    3 CONTINUE

      ICAS = 1
      I2   = 2
      IF (NCAS.EQ.-1) THEN
         ICAS = 2
         I2   = 1
      ENDIF

      IF (PTOCAS(ICAS).LT.TINY10) THEN
         WRITE(ErrorOut,1000) PTOCAS
 1000    FORMAT(1X,'INUCAS:   WARNING! ZERO MOMENTUM OF INITIAL',
     &          '  HADRON ',/,20X,2E12.4)
         GOTO 9999
      ENDIF

c reset spectator flags
      NSPE = 0
      IDXSPE(1) = 0
      IDXSPE(2) = 0
      IDSPE(1)  = 0
      IDSPE(2)  = 0

c formation length (in fm)
C     IF (LCAS) THEN
C        DEL0 = ZERO
C     ELSE
         DEL0 = TAUFOR*BGCAS(ICAS)
         IF (ITAUVE.EQ.1) THEN
            AMT  = PCAS(ICAS,1)**2+PCAS(ICAS,2)**2+PCAS(ICAS,5)**2
            DEL0 = DEL0*PCAS(ICAS,5)**2/AMT
         ENDIF
C     ENDIF
c   sample from exp(-del/del0)
      DEL1   = -DEL0*LOG(MAX(DT_RNDM(DEL0),TINY10))
c save formation time
      TAUSA1 = DEL1/BGCAS(ICAS)
      REL1   = TAUSA1*BGCAS(I2)

      DEL    = DEL1
      TAUSAM = DEL/BGCAS(ICAS)
      REL    = TAUSAM*BGCAS(I2)

c special treatment for negative particles unable to escape
c nuclear potential (implemented for ap, pi-, K- only)
      LABSOR = .FALSE.
      IF ((IICH(IDCAS).EQ.-1).AND.(IDCAS.LT.20)) THEN
c   threshold energy = nuclear potential + Coulomb potential
c   (nuclear potential for hadron-nucleus interactions only)
         ETHR = AAM(IDCAS)+EPOT(ICAS,IDCAS)+ETACOU(ICAS)
         IF (PCAS(ICAS,4).LT.ETHR) THEN
            DO 4 K=1,5
               PCAS1(K) = PCAS(ICAS,K)
    4       CONTINUE
c   "absorb" negative particle in nucleus
            CALL DT_ABSORP(IDCAS,PCAS1,NCAS,NSPE,IDSPE,IDXSPE,0,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            IF (NSPE.GE.1) LABSOR = .TRUE.
         ENDIF
      ENDIF

c if the initial particle has not been absorbed proceed with
c "normal" cascade
      IF (.NOT.LABSOR) THEN

c   calculate coordinates of hadron at the end of the formation zone
c   transport-time and -step in the rest system where this step is
c   treated
         DSTEP  = DEL*FM2MM
         DTIME  = DSTEP/BECAS(ICAS)
         RSTEP  = REL*FM2MM
         IF ((IP.GT.1).AND.(IT.GT.1)) THEN
            RTIME = RSTEP/BECAS(I2)
         ELSE
            RTIME = ZERO
         ENDIF
c   save step whithout considering the overlapping region
         DSTEP1 = DEL1*FM2MM
         DTIME1 = DSTEP1/BECAS(ICAS)
         RSTEP1 = REL1*FM2MM
         IF ((IP.GT.1).AND.(IT.GT.1)) THEN
            RTIME1 = RSTEP1/BECAS(I2)
         ELSE
            RTIME1 = ZERO
         ENDIF
c   transport to the end of the formation zone in this system
         DO 5 K=1,3
            VTXCA1(ICAS,K) = VTXCAS(ICAS,K)+DSTEP1*COSCAS(ICAS,K)
            VTXCA1(I2,K)   = VTXCAS(I2,K)  +RSTEP1*COSCAS(I2,K)
            VTXCAS(ICAS,K) = VTXCAS(ICAS,K)+DSTEP*COSCAS(ICAS,K)
            VTXCAS(I2,K)   = VTXCAS(I2,K)  +RSTEP*COSCAS(I2,K)
    5    CONTINUE
         VTXCA1(ICAS,4) = VTXCAS(ICAS,4)+DTIME1
         VTXCA1(I2,4)   = VTXCAS(I2,4)  +RTIME1
         VTXCAS(ICAS,4) = VTXCAS(ICAS,4)+DTIME
         VTXCAS(I2,4)   = VTXCAS(I2,4)  +RTIME

         IF ((IP.GT.1).AND.(IT.GT.1)) THEN
            XCAS   = VTXCAS(ICAS,1)
            YCAS   = VTXCAS(ICAS,2)
            XNCLTA = BIMPAC*FM2MM
            RNCLPR = (RPROJ+RNUCLE)*FM2MM
            RNCLTA = (RTARG+RNUCLE)*FM2MM
C           RNCLPR = (RPROJ+1.605D0*PDIF)*FM2MM
C           RNCLTA = (RTARG+1.605D0*PDIF)*FM2MM
C           RNCLPR = (RPROJ)*FM2MM
C           RNCLTA = (RTARG)*FM2MM
            RCASPR = SQRT( XCAS**2        +YCAS**2)
            RCASTA = SQRT((XCAS-XNCLTA)**2+YCAS**2)
            IF ((RCASPR.LT.RNCLPR).AND.(RCASTA.LT.RNCLTA)) THEN
               IF (IDCH(IDXCAS).EQ.0) NOBAM(IDXCAS) = 3
            ENDIF
         ENDIF

c   check if particle is already outside of the corresp. nucleus
         RDIST = SQRT((VTXCAS(ICAS,1)-BIMPC(ICAS))**2+
     &                VTXCAS(ICAS,2)**2+VTXCAS(ICAS,3)**2)
         IF (RDIST.GE.RNUC(ICAS)) THEN
c   here: IDCH is the generation of the final state part. starting
c   with zero for hadronization products
c   flag particles of generation 0 being outside the nuclei after
c   formation time (to be used for excitation energy calculation)
            IF ((IDCH(IDXCAS).EQ.0).AND.(NOBAM(IDXCAS).LT.3))
     &         NOBAM(IDXCAS) = NOBAM(IDXCAS)+ICAS
            GOTO 9997
         ENDIF
         DIST   = DLARGE
         DISTP  = DLARGE
         DISTN  = DLARGE
         IDXP   = 0
         IDXN   = 0

c   already here: skip particles being outside HADRIN "energy-window"
c   to avoid wasting of time
         NINCHR(ICAS,1) = NINCHR(ICAS,1)+1
         IF ((PTOCAS(ICAS).LE.PLOWH).OR.(PTOCAS(ICAS).GE.PHIH)) THEN
            NINCHR(ICAS,2) = NINCHR(ICAS,2)+1
C           WRITE(LOUT,1002) IDXCAS,IDCAS,ICAS,PTOCAS(ICAS),NEVHKK
C1002       FORMAT(1X,'INUCAS:   warning! momentum of particle with ',
C    &             'index ',I5,' (id: ',I3,') ',I3,/,11X,'p_tot = ',
C    &             E12.4,', above or below HADRIN-thresholds',I6)
            NSPE = 0
            GOTO 9997
         ENDIF

         DO 7 IDXHKK=1,NOINC
            I = IDXINC(IDXHKK)
c   scan DTEVT1 for unwounded or excited nucleons
            IF ((ISTHKK(I).EQ.12+ICAS).OR.(ISTHKK(I).EQ.14+ICAS)) THEN
               DO 8 K=1,3
                  IF (ICAS.EQ.1) THEN
                     VTXDST(K) = WHKK(K,I)-VTXCAS(1,K)
                  ELSEIF (ICAS.EQ.2) THEN
                     VTXDST(K) = VHKK(K,I)-VTXCAS(2,K)
                  ENDIF
    8          CONTINUE
               POSNUC = VTXDST(1)*COSCAS(ICAS,1)+
     &                  VTXDST(2)*COSCAS(ICAS,2)+
     &                  VTXDST(3)*COSCAS(ICAS,3)
c   check if nucleon is situated in forward direction
               IF (POSNUC.GT.ZERO) THEN
c   distance between hadron and this nucleon
                  DISTNU = SQRT(VTXDST(1)**2+VTXDST(2)**2+
     &                          VTXDST(3)**2)
c   impact parameter
                  BIMNU2 = DISTNU**2-POSNUC**2
                  IF (BIMNU2.LT.ZERO) THEN
                     WRITE(ErrorOut,1001) DISTNU,POSNUC,BIMNU2
 1001                FORMAT(1X,'INUCAS:   WARNING! INCONSISTENT IMPACT',
     &                      '  PARAMETER ',/,20X,3E12.4)
                     GOTO 7
                  ENDIF
                  BIMNU  = SQRT(BIMNU2)
c   maximum impact parameter to have interaction
                  IDNUC  = IDT_ICIHAD(IDHKK(I))
                  IDNUC1 = IDT_MCHAD(IDNUC)
                  IDCAS1 = IDT_MCHAD(IDCAS)
                  DO 19 K=1,5
                     PCAS1(K) = PCAS(ICAS,K)
                     PNUC(K)  = PHKK(K,I)
   19             CONTINUE
c Lorentz-parameter for trafo into rest-system of target
                  DO 18 K=1,4
                     BGTA(K) = PNUC(K)/MAX(PNUC(5),TINY10)
   18             CONTINUE
c transformation of projectile into rest-system of target
                  CALL DT_DALTRA(BGTA(4),-BGTA(1),-BGTA(2),-BGTA(3),
     &                        PCAS1(1),PCAS1(2),PCAS1(3),PCAS1(4),
     &                        PPTOT,PX,PY,PZ,PE)
c*
C                 CALL DT_SIHNIN(IDCAS1,IDNUC1,PPTOT,SIGIN)
C                 CALL DT_SIHNEL(IDCAS1,IDNUC1,PPTOT,SIGEL)
                  DUMZER = ZERO
                  CALL DT_XSHN(IDCAS1,IDNUC1,PPTOT,DUMZER,SIGTOT,SIGEL)
                  CALL DT_SIHNAB(IDCAS1,IDNUC1,PPTOT,SIGAB)
                  IF (((IDCAS1.EQ.13).OR.(IDCAS1.EQ.14)).AND.
     &                (PPTOT.LT.0.15D0)) SIGEL = SIGEL/2.0D0
                  SIGIN = SIGTOT-SIGEL-SIGAB
C                 SIGTOT = SIGIN+SIGEL+SIGAB
c*
                  BIMMAX = SQRT(SIGTOT/(5.0D0*TWOPI))*FM2MM
c   check if interaction is possible
                  IF (BIMNU.LE.BIMMAX) THEN
c   get nucleon with smallest distance and kind of interaction
c   (elastic/inelastic)
                     IF (DISTNU.LT.DIST) THEN
                        DIST      = DISTNU
                        BINT      = BIMNU
                        IF (IDNUC.NE.IDSPE(1)) THEN
                           IDSPE(2)  = IDSPE(1)
                           IDXSPE(2) = IDXSPE(1)
                           IDSPE(1)  = IDNUC
                        ENDIF
                        IDXSPE(1) = I
                        NSPE      = 1
c*sr
                        SELA = SIGEL
                        SABS = SIGAB
                        STOT = SIGTOT
C                       IF ((IDCAS.EQ.2).OR.(IDCAS.EQ.9)) THEN
C                          SELA = SIGEL
C                          STOT = SIGIN+SIGEL
C                       ELSE
C                          SELA = SIGEL+0.75D0*SIGIN
C                          STOT = 0.25D0*SIGIN+SELA
C                       ENDIF
c*
                     ENDIF
                  ENDIF
               ENDIF
               DISTNU = SQRT(VTXDST(1)**2+VTXDST(2)**2+
     &                       VTXDST(3)**2)
               IDNUC  = IDT_ICIHAD(IDHKK(I))
               IF (IDNUC.EQ.1) THEN
                  IF (DISTNU.LT.DISTP) THEN
                     DISTP = DISTNU
                     IDXP  = I
                     POSP  = POSNUC
                  ENDIF
               ELSEIF (IDNUC.EQ.8) THEN
                  IF (DISTNU.LT.DISTN) THEN
                     DISTN = DISTNU
                     IDXN  = I
                     POSN  = POSNUC
                  ENDIF
               ENDIF
            ENDIF
    7    CONTINUE

c there is no nucleon for a secondary interaction
         IF (NSPE.EQ.0) GOTO 9997

C        IF ((IDCAS.EQ.13).AND.((PCAS(ICAS,4)-PCAS(ICAS,5)).LT.0.1D0))
C    &      WRITE(LOUT,*) STOT,SELA,SABS,IDXSPE
         IF (IDXSPE(2).EQ.0) THEN
            IF ((IDSPE(1).EQ.1).AND.(IDXN.GT.0)) THEN
C              DO 80 K=1,3
C                 IF (ICAS.EQ.1) THEN
C                    VTXDST(K) = WHKK(K,IDXN)-WHKK(K,IDXSPE(1))
C                 ELSEIF (ICAS.EQ.2) THEN
C                    VTXDST(K) = VHKK(K,IDXN)-VHKK(K,IDXSPE(1))
C                 ENDIF
C  80          CONTINUE
C              DISTNU = SQRT(VTXDST(1)**2+VTXDST(2)**2+
C    &                       VTXDST(3)**2)
C              IF ((DISTNU.LT.15.0D0*FM2MM).OR.(POSN.GT.ZERO)) THEN
                  IDXSPE(2) = IDXN
                  IDSPE(2)  = 8
C              ELSE
C                 STOT = STOT-SABS
C                 SABS = ZERO
C              ENDIF
            ELSEIF ((IDSPE(1).EQ.8).AND.(IDXP.GT.0)) THEN
C              DO 81 K=1,3
C                 IF (ICAS.EQ.1) THEN
C                    VTXDST(K) = WHKK(K,IDXP)-WHKK(K,IDXSPE(1))
C                 ELSEIF (ICAS.EQ.2) THEN
C                    VTXDST(K) = VHKK(K,IDXP)-VHKK(K,IDXSPE(1))
C                 ENDIF
C  81          CONTINUE
C              DISTNU = SQRT(VTXDST(1)**2+VTXDST(2)**2+
C    &                       VTXDST(3)**2)
C              IF ((DISTNU.LT.15.0D0*FM2MM).OR.(POSP.GT.ZERO)) THEN
                  IDXSPE(2) = IDXP
                  IDSPE(2)  = 1
C              ELSE
C                 STOT = STOT-SABS
C                 SABS = ZERO
C              ENDIF
            ELSE
               STOT = STOT-SABS
               SABS = ZERO
            ENDIF
         ENDIF
         RR = DT_RNDM(DIST)
         IF (RR.LT.SELA/STOT) THEN
            IPROC = 2
         ELSEIF ((RR.GE.SELA/STOT).AND.(RR.LT.(SELA+SABS)/STOT)) THEN
            IPROC = 3
         ELSE
            IPROC = 1
         ENDIF

         DO 9 K=1,5
            PCAS1(K) = PCAS(ICAS,K)
            PNUC(K)  = PHKK(K,IDXSPE(1))
    9    CONTINUE
         IF (IPROC.EQ.3) THEN
c 2-nucleon absorption of pion
            NSPE = 2
            CALL DT_ABSORP(IDCAS,PCAS1,NCAS,NSPE,IDSPE,IDXSPE,1,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            IF (NSPE.GE.1) LABSOR = .TRUE.
         ELSE
c sample secondary interaction
            IDNUC = IDBAM(IDXSPE(1))
            CALL DT_HADRIN(IDCAS,PCAS1,IDNUC,PNUC,IPROC,IREJ1)
            IF (IREJ1.EQ.1) GOTO 9999
            IF (IREJ1.GT.1) GOTO 9998
         ENDIF
      ENDIF

c update arrays to include Pauli-principle
      DO 10 I=1,NSPE
         IF (NWOUND(ICAS).LE.299) THEN
            NWOUND(ICAS) = NWOUND(ICAS)+1
            EWOUND(ICAS,NWOUND(ICAS)) = PHKK(4,IDXSPE(I))
         ENDIF
   10 CONTINUE

c dump initial hadron for energy-momentum conservation check
      IF (LEMCCK)
     &   CALL DT_EVTEMC(PCAS(ICAS,1),PCAS(ICAS,2),PCAS(ICAS,3),
     &               PCAS(ICAS,4),1,IDUM,IDUM)

c dump final state particles into DTEVT1

c   check if Pauli-principle is fulfilled
      NPAULI = 0
      NWTMP(1) = NWOUND(1)
      NWTMP(2) = NWOUND(2)
      DO 111 I=1,NFSP
         NPAULI = 0
         J1 = 2
         IF (((NCAS.EQ. 1).AND.(IT.LE.1)).OR.
     &       ((NCAS.EQ.-1).AND.(IP.LE.1)))    J1 = 1
         DO 117 J=1,J1
            IF ((NPAULI.NE.0).AND.(J.EQ.2)) GOTO 117
            IF (J.EQ.1) THEN
               IDX = ICAS
               PE  = PFSP(4,I)
            ELSE
               IDX  = I2
               MODE = 1
               IF (IDX.EQ.1) MODE = -1
               CALL DT_LTNUC(PFSP(3,I),PFSP(4,I),PZ,PE,MODE)
            ENDIF
c first check if cascade step is forbidden due to Pauli-principle
c (in case of absorpion this step is forced)
            IF ((.NOT.LABSOR).AND.LPAULI.AND.((IDFSP(I).EQ.1).OR.
     &          (IDFSP(I).EQ.8))) THEN
c   get nuclear potential barrier
               POT = EPOT(IDX,IDFSP(I))+AAM(IDFSP(I))
               IF (IDFSP(I).EQ.1) THEN
                  POTLOW = POT-EBINDP(IDX)
               ELSE
                  POTLOW = POT-EBINDN(IDX)
               ENDIF
c   final state particle not able to escape nucleus
               IF (PE.LE.POTLOW) THEN
c     check if there are wounded nucleons
                  IF ((NWOUND(IDX).GE.1).AND.(PE.GE.
     &                 EWOUND(IDX,NWOUND(IDX)))) THEN
                     NPAULI      = NPAULI+1
                     NWOUND(IDX) = NWOUND(IDX)-1
                  ELSE
c     interaction prohibited by Pauli-principle
                     NWOUND(1) = NWTMP(1)
                     NWOUND(2) = NWTMP(2)
                     GOTO 9997
                  ENDIF
               ENDIF
            ENDIF
  117    CONTINUE
  111 CONTINUE

      NPAULI = 0
      NWOUND(1) = NWTMP(1)
      NWOUND(2) = NWTMP(2)

      DO 11 I=1,NFSP

         IST = ISTHKK(IDXCAS)

         NPAULI = 0
         J1 = 2
         IF (((NCAS.EQ. 1).AND.(IT.LE.1)).OR.
     &       ((NCAS.EQ.-1).AND.(IP.LE.1)))    J1 = 1
         DO 17 J=1,J1
            IF ((NPAULI.NE.0).AND.(J.EQ.2)) GOTO 17
            IDX = ICAS
            PE  = PFSP(4,I)
            IF (J.EQ.2) THEN
               IDX = I2
               CALL DT_LTNUC(PFSP(3,I),PFSP(4,I),PZ,PE,NCAS)
            ENDIF
c first check if cascade step is forbidden due to Pauli-principle
c (in case of absorpion this step is forced)
            IF ((.NOT.LABSOR).AND.LPAULI.AND.((IDFSP(I).EQ.1).OR.
     &          (IDFSP(I).EQ.8))) THEN
c   get nuclear potential barrier
               POT = EPOT(IDX,IDFSP(I))+AAM(IDFSP(I))
               IF (IDFSP(I).EQ.1) THEN
                  POTLOW = POT-EBINDP(IDX)
               ELSE
                  POTLOW = POT-EBINDN(IDX)
               ENDIF
c   final state particle not able to escape nucleus
               IF (PE.LE.POTLOW) THEN
c     check if there are wounded nucleons
                  IF ((NWOUND(IDX).GE.1).AND.(PE.GE.
     &                 EWOUND(IDX,NWOUND(IDX)))) THEN
                     NWOUND(IDX) = NWOUND(IDX)-1
                     NPAULI = NPAULI+1
                     IST    = 14+IDX
                  ELSE
c     interaction prohibited by Pauli-principle
                     NWOUND(1) = NWTMP(1)
                     NWOUND(2) = NWTMP(2)
                     GOTO 9997
                  ENDIF
c*sr
c               ELSEIF (PE.LE.POT) THEN
cC              ELSEIF ((PE.LE.POT).AND.(NWOUND(IDX).GE.1)) THEN
cC                 NWOUND(IDX) = NWOUND(IDX)-1
c**
c                  NPAULI = NPAULI+1
c                  IST    = 14+IDX
               ENDIF
            ENDIF
   17    CONTINUE

c dump final state particles for energy-momentum conservation check
         IF (LEMCCK) CALL DT_EVTEMC(-PFSP(1,I),-PFSP(2,I),-PFSP(3,I),
     &                           -PFSP(4,I),2,IDUM,IDUM)

         PX = PFSP(1,I)
         PY = PFSP(2,I)
         PZ = PFSP(3,I)
         PE = PFSP(4,I)
         IF (ABS(IST).EQ.1) THEN
c transform particles back into n-n cms
c LEPTO: leave final state particles in target rest frame
C           IF (MCGENE.EQ.3) THEN
C              PFSP(1,I) = PX
C              PFSP(2,I) = PY
C              PFSP(3,I) = PZ
C              PFSP(4,I) = PE
C           ELSE
               IMODE = ICAS+1
               CALL DT_LTRANS(PX,PY,PZ,PE,PFSP(1,I),PFSP(2,I),PFSP(3,I),
     &                     PFSP(4,I),IDFSP(I),IMODE)
C           ENDIF
         ELSEIF ((ICAS.EQ.2).AND.(IST.EQ.15)) THEN
c target cascade but fsp got stuck in proj. --> transform it into
c proj. rest system
            CALL DT_LTRANS(PX,PY,PZ,PE,PFSP(1,I),PFSP(2,I),PFSP(3,I),
     &                  PFSP(4,I),IDFSP(I),-1)
         ELSEIF ((ICAS.EQ.1).AND.(IST.EQ.16)) THEN
c proj. cascade but fsp got stuck in target --> transform it into
c target rest system
            CALL DT_LTRANS(PX,PY,PZ,PE,PFSP(1,I),PFSP(2,I),PFSP(3,I),
     &                  PFSP(4,I),IDFSP(I),1)
         ENDIF

c dump final state particles into DTEVT1
         IGEN = IDCH(IDXCAS)+1
         ID   = IDT_IPDGHA(IDFSP(I))
         IXR  = 0
         IF (LABSOR) IXR = 99
         CALL DT_EVTPUT(IST,ID,IDXCAS,IDXSPE(1),PFSP(1,I),
     &               PFSP(2,I),PFSP(3,I),PFSP(4,I),0,IXR,IGEN)

c update the counter for particles which got stuck inside the nucleus
         IF ((IST.EQ.15).OR.(IST.EQ.16)) THEN
            NOINC = NOINC+1
            IDXINC(NOINC) = NHKK
         ENDIF
         IF (LABSOR) THEN
c   in case of absorption the spatial treatment is an approximate
c   solution anyway (the positions of the nucleons which "absorb" the
c   cascade particle are not taken into consideration) therefore the
c   particles are produced at the position of the cascade particle
            DO 12 K=1,4
               WHKK(K,NHKK) = WHKK(K,IDXCAS)
               VHKK(K,NHKK) = VHKK(K,IDXCAS)
   12       CONTINUE
         ELSE
c   DDISTL - distance the cascade particle moves to the intera. point
c   (the position where impact-parameter = distance to the interacting
c   nucleon), DIST - distance to the interacting nucleon at the time of
c   formation of the cascade particle, BINT - impact-parameter of this
c   cascade-interaction
            DDISTL = SQRT(DIST**2-BINT**2)
            DTIME  = DDISTL/BECAS(ICAS)
            DTIMEL = DDISTL/BGCAS(ICAS)
            RDISTL = DTIMEL*BGCAS(I2)
            IF ((IP.GT.1).AND.(IT.GT.1)) THEN
               RTIME = RDISTL/BECAS(I2)
            ELSE
               RTIME = ZERO
            ENDIF
c   RDISTL, RTIME are this step and time in the rest system of the other
c   nucleus
            DO 13 K=1,3
               VTXCA1(ICAS,K) = VTXCAS(ICAS,K)+COSCAS(ICAS,K)*DDISTL
               VTXCA1(I2,K)   = VTXCAS(I2,K)  +COSCAS(I2,K)  *RDISTL
   13       CONTINUE
            VTXCA1(ICAS,4) = VTXCAS(ICAS,4)+DTIME
            VTXCA1(I2,4)   = VTXCAS(I2,4)  +RTIME
c   position of particle production is half the impact-parameter to
c   the interacting nucleon
            DO 14 K=1,3
               WHKK(K,NHKK) = OHALF*(VTXCA1(1,K)+WHKK(K,IDXSPE(1)))
               VHKK(K,NHKK) = OHALF*(VTXCA1(2,K)+VHKK(K,IDXSPE(1)))
   14       CONTINUE
c   time of production of secondary = time of interaction
            WHKK(4,NHKK) = VTXCA1(1,4)
            VHKK(4,NHKK) = VTXCA1(2,4)
         ENDIF

   11 CONTINUE

c modify status and position of cascade particle (the latter for
c statistics reasons only)
      ISTHKK(IDXCAS) = 2
      IF (LABSOR) ISTHKK(IDXCAS) = 19
      IF (.NOT.LABSOR) THEN
         DO 15 K=1,4
            WHKK(K,IDXCAS) = VTXCA1(1,K)
            VHKK(K,IDXCAS) = VTXCA1(2,K)
   15    CONTINUE
      ENDIF

      DO 16 I=1,NSPE
         IS = IDXSPE(I)
c dump interacting nucleons for energy-momentum conservation check
         IF (LEMCCK)
     &      CALL DT_EVTEMC(PHKK(1,IS),PHKK(2,IS),PHKK(3,IS),PHKK(4,IS),
     &                                                  2,IDUM,IDUM)
c modify entry for interacting nucleons
         IF (ISTHKK(IS).EQ.12+ICAS) ISTHKK(IS)=16+ICAS
         IF (ISTHKK(IS).EQ.14+ICAS) ISTHKK(IS)=2
         IF (I.GE.2) THEN
            JDAHKK(1,IS) = JDAHKK(1,IDXSPE(1))
            JDAHKK(2,IS) = JDAHKK(2,IDXSPE(1))
         ENDIF
   16 CONTINUE

c check energy-momentum conservation
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(DUM,DUM,DUM,DUM,4,500,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
      ENDIF

c update counter
      IF (LABSOR) THEN
         NINCCO(ICAS,1) = NINCCO(ICAS,1)+1
      ELSE
         IF (IPROC.EQ.1) NINCCO(ICAS,2) = NINCCO(ICAS,2)+1
         IF (IPROC.EQ.2) NINCCO(ICAS,3) = NINCCO(ICAS,3)+1
      ENDIF

      RETURN

 9997 CONTINUE
 9998 CONTINUE
c transport-step but no cascade step due to configuration (i.e. there
c is no nucleon for interaction etc.)
      IF (LCAS) THEN
         DO 100 K=1,4
C           WHKK(K,IDXCAS) = VTXCAS(1,K)
C           VHKK(K,IDXCAS) = VTXCAS(2,K)
            WHKK(K,IDXCAS) = VTXCA1(1,K)
            VHKK(K,IDXCAS) = VTXCA1(2,K)
  100    CONTINUE
      ENDIF

C9998 CONTINUE
c no cascade-step because of configuration
c (i.e. hadron outside nucleus etc.)
      LCAS = .TRUE.
      RETURN

 9999 CONTINUE
c rejection
      IREJ = 1
      RETURN
      END
c
c===absorp=============================================================*
c
CDECK  ID>, DT_ABSORP
      SUBROUTINE DT_ABSORP(IDCAS,PCAS,NCAS,NSPE,IDSPE,IDXSPE,MODE,IREJ)

c***********************************************************************
c Two-nucleon absorption of antiprotons, pi-, and K-.                  *
c Antiproton absorption is handled by HADRIN.                          *
c The following channels for meson-absorption are considered:          *
c          pi- + p + p ---> n + p                                      *
c          pi- + p + n ---> n + n                                      *
c          K-  + p + p ---> sigma+ + n / Lam + p / sigma0 + p          *
c          K-  + p + n ---> sigma- + n / Lam + n / sigma0 + n          *
c          K-  + p + p ---> sigma- + n                                 *
c      IDCAS, PCAS   identity, momentum of particle to be absorbed     *
c      NCAS =  1     intranuclear cascade in projectile                *
c           = -1     intranuclear cascade in target                    *
c      NSPE          number of spectator nucleons involved             *
c      IDXSPE(2)     DTEVT1-indices of spectator nucleons involved     *
c Revised version of the original STOPIK written by HJM and J. Ranft.  *
c This version dated 24.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY5=1.0D-5,ONE=1.0D0,
     &           ONETHI=0.3333D0,TWOTHI=0.6666D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c final state after inc step
      PARAMETER (MAXFSP=10)
      COMMON /DTCAPA/ PFSP(5,MAXFSP),IDFSP(MAXFSP),NFSP

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


      DIMENSION PCAS(5),IDXSPE(2),IDSPE(2),PSPE(2,5),PSPE1(5),
     &          PTOT3P(4),BG3P(4),
     &          ECMF(2),PCMF(2),CODF(2),COFF(2),SIFF(2)

      IREJ = 0
      NFSP = 0

c skip particles others than ap, pi-, K- for mode=0
      IF ((MODE.EQ.0).AND.
     &    (IDCAS.NE.2).AND.(IDCAS.NE.14).AND.(IDCAS.NE.16)) RETURN
c skip particles others than pions for mode=1
c (2-nucleon absorption in intranuclear cascade)
      IF ((MODE.EQ.1).AND.
     &    (IDCAS.NE.13).AND.(IDCAS.NE.14).AND.(IDCAS.NE.23)) RETURN

      NUCAS = NCAS
      IF (NUCAS.EQ.-1) NUCAS = 2

      IF (MODE.EQ.0) THEN
c scan spectator nucleons for nucleons being able to "absorb"
         NSPE      = 0
         IDXSPE(1) = 0
         IDXSPE(2) = 0
         DO 1 I=1,NHKK
            IF ((ISTHKK(I).EQ.12+NUCAS).OR.(ISTHKK(I).EQ.14+NUCAS)) THEN
               NSPE         = NSPE+1
               IDXSPE(NSPE) = I
               IDSPE(NSPE)  = IDBAM(I)
               IF ((NSPE.EQ.1).AND.(IDCAS.EQ.2)) GOTO 2
               IF (NSPE.EQ.2) THEN
                  IF ((IDCAS.EQ.14).AND.(IDSPE(1).EQ.8).AND.
     &                                  (IDSPE(2).EQ.8)) THEN
c    there is no pi-+n+n channel
                     NSPE = 1
                     GOTO 1
                  ELSE
                     GOTO 2
                  ENDIF
               ENDIF
            ENDIF
    1    CONTINUE

    2    CONTINUE
      ENDIF
c transform excited projectile nucleons (status=15) into proj. rest s.
      DO 3 I=1,NSPE
         DO 4 K=1,5
            PSPE(I,K) = PHKK(K,IDXSPE(I))
    4    CONTINUE
    3 CONTINUE

c antiproton absorption
      IF ((IDCAS.EQ.2).AND.(NSPE.GE.1)) THEN
         DO 5 K=1,5
            PSPE1(K) = PSPE(1,K)
    5    CONTINUE
         CALL DT_HADRIN(IDCAS,PCAS,IDSPE(1),PSPE1,1,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999

c meson absorption
      ELSEIF (((IDCAS.EQ.13).OR.(IDCAS.EQ.14).OR.(IDCAS.EQ.23)
     &                      .OR.(IDCAS.EQ.16)).AND.(NSPE.GE.2)) THEN
         IF (IDCAS.EQ.14) THEN
c   pi- absorption
            IDFSP(1) = 8
            IDFSP(2) = 8
            IF ((IDSPE(1).EQ.1).AND.(IDSPE(2).EQ.1)) IDFSP(2) = 1
         ELSEIF (IDCAS.EQ.13) THEN
c   pi+ absorption
            IDFSP(1) = 1
            IDFSP(2) = 1
            IF ((IDSPE(1).EQ.8).AND.(IDSPE(2).EQ.8)) IDFSP(2) = 8
         ELSEIF (IDCAS.EQ.23) THEN
c   pi0 absorption
            IDFSP(1) = IDSPE(1)
            IDFSP(2) = IDSPE(2)
         ELSEIF (IDCAS.EQ.16) THEN
c   K- absorption
            R = DT_RNDM(PCAS)
            IF ((IDSPE(1).EQ.1).AND.(IDSPE(2).EQ.1)) THEN
               IF (R.LT.ONETHI) THEN
                  IDFSP(1) = 21
                  IDFSP(2) = 8
               ELSEIF (R.LT.TWOTHI) THEN
                  IDFSP(1) = 17
                  IDFSP(2) = 1
               ELSE
                  IDFSP(1) = 22
                  IDFSP(2) = 1
               ENDIF
            ELSEIF ((IDSPE(1).EQ.8).AND.(IDSPE(2).EQ.8)) THEN
               IDFSP(1) = 20
               IDFSP(2) = 8
            ELSE
               IF (R.LT.ONETHI) THEN
                  IDFSP(1) = 20
                  IDFSP(2) = 1
               ELSEIF (R.LT.TWOTHI) THEN
                  IDFSP(1) = 17
                  IDFSP(2) = 8
               ELSE
                  IDFSP(1) = 22
                  IDFSP(2) = 8
               ENDIF
            ENDIF
         ENDIF
c   dump initial particles for energy-momentum cons. check
         IF (LEMCCK) THEN
            CALL DT_EVTEMC(PCAS(1),PCAS(2),PCAS(3),PCAS(4),1,IDUM,IDUM)
            CALL DT_EVTEMC(PSPE(1,1),PSPE(1,2),PSPE(1,3),PSPE(1,4),2,
     &                                                    IDUM,IDUM)
            CALL DT_EVTEMC(PSPE(2,1),PSPE(2,2),PSPE(2,3),PSPE(2,4),2,
     &                                                    IDUM,IDUM)
         ENDIF
c   get Lorentz-parameter of 3 particle initial state
         DO 6 K=1,4
            PTOT3P(K) = PCAS(K)+PSPE(1,K)+PSPE(2,K)
    6    CONTINUE
         P3P  = SQRT(PTOT3P(1)**2+PTOT3P(2)**2+PTOT3P(3)**2)
         AM3P = SQRT( (PTOT3P(4)-P3P)*(PTOT3P(4)+P3P) )
         DO 7 K=1,4
            BG3P(K) = PTOT3P(K)/MAX(AM3P,TINY10)
    7    CONTINUE
c   2-particle decay of the 3-particle compound system
         CALL DT_DTWOPD(AM3P,ECMF(1),ECMF(2),PCMF(1),PCMF(2),
     &               CODF(1),COFF(1),SIFF(1),CODF(2),COFF(2),SIFF(2),
     &               AAM(IDFSP(1)),AAM(IDFSP(2)))
         DO 8 I=1,2
            SDF = SQRT((ONE-CODF(I))*(ONE+CODF(I)))
            PX  = PCMF(I)*COFF(I)*SDF
            PY  = PCMF(I)*SIFF(I)*SDF
            PZ  = PCMF(I)*CODF(I)
            CALL DT_DALTRA(BG3P(4),BG3P(1),BG3P(2),BG3P(3),PX,PY,PZ,
     &                  ECMF(I),PTOFSP,PFSP(1,I),PFSP(2,I),PFSP(3,I),
     &                  PFSP(4,I))
            PFSP(5,I) = SQRT( (PFSP(4,I)-PTOFSP)*(PFSP(4,I)+PTOFSP) )
c   check consistency of kinematics
            IF (ABS(AAM(IDFSP(I))-PFSP(5,I)).GT.TINY5) THEN
               WRITE(ErrorOut,
     * 1001) IDFSP(I),AAM(IDFSP(I)),PFSP(5,I)
 1001          FORMAT(1X,'ABSORP:   WARNING! INCONSISTENT',
     &                ' TREE-PARTICLE KINEMATICS',/,20X,'ID: ',I3,
     &                ' AAM = ',E10.4,' MFSP = ',E10.4)
            ENDIF
c   dump final state particles for energy-momentum cons. check
            IF (LEMCCK) CALL DT_EVTEMC(-PFSP(1,I),-PFSP(2,I),
     &                              -PFSP(3,I),-PFSP(4,I),2,IDUM,IDUM)
    8    CONTINUE
         NFSP = 2
         IF (LEMCCK) THEN
            CALL DT_EVTEMC(DUM,DUM,DUM,DUM,3,100,IREJ1)
            IF (IREJ1.NE.0) THEN
               WRITE(ErrorOut,
     * *)'ABSORB: EMC ',AAM(IDFSP(1)),AAM(IDFSP(2)),
     &                      AM3P
               GOTO 9999
            ENDIF
         ENDIF
      ELSE
         IF (IOULEV(3).GT.0) WRITE(ErrorOut,1000) IDCAS,NSPE
 1000    FORMAT(1X,'ABSORP:   WARNING! ABSORPTION FOR PARTICLE ',I3,
     &          ' IMPOSSIBLE',/,20X,'TOO FEW SPECTATORS (',I2,')')
         NSPE = 0
      ENDIF

      RETURN

 9999 CONTINUE
      IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in ABSORP'
      IREJ = 1
      RETURN
      END
c
c===hadrin=============================================================*
c
CDECK  ID>, DT_HADRIN
      SUBROUTINE DT_HADRIN(IDPR,PPR,IDTA,PTA,MODE,IREJ)

c***********************************************************************
c Interface to the HADRIN-routines for inelastic and elastic           *
c scattering.                                                          *
c      IDPR,PPR(5)   identity, momentum of projectile                  *
c      IDTA,PTA(5)   identity, momentum of target                      *
c      MODE  = 1     inelastic interaction                             *
c            = 2     elastic   interaction                             *
c Revised version of the original FHAD.                                *
c This version dated 27.10.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,TINY5=1.0D-5,TINY3=1.0D-3,
     &           TINY2=1.0D-2,TINY1=1.0D-1,ONE=1.0D0)

      LOGICAL LCORR,LMSSG

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c final state after inc step
      PARAMETER (MAXFSP=10)
      COMMON /DTCAPA/ PFSP(5,MAXFSP),IDFSP(MAXFSP),NFSP

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c output-common for DHADRI/ELHAIN
c final state from HADRIN interaction
      PARAMETER (MAXFIN=10)
      COMMON /HNFSPA/ ITRH(MAXFIN),CXRH(MAXFIN),CYRH(MAXFIN),
     &                CZRH(MAXFIN),ELRH(MAXFIN),PLRH(MAXFIN),IRH


      DIMENSION PPR(5),PPR1(5),PTA(5),BGTA(4),
     &          P1IN(4),P2IN(4),P1OUT(4),P2OUT(4),IMCORR(2)

      DATA LMSSG /.TRUE./

      IREJ  = 0
      NFSP  = 0
      KCORR = 0
      IMCORR(1) = 0
      IMCORR(2) = 0
      LCORR = .FALSE.

c   dump initial particles for energy-momentum cons. check
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(PPR(1),PPR(2),PPR(3),PPR(4),1,IDUM,IDUM)
         CALL DT_EVTEMC(PTA(1),PTA(2),PTA(3),PTA(4),2,IDUM,IDUM)
      ENDIF

      AMP2 = PPR(4)**2-PPR(1)**2-PPR(2)**2-PPR(3)**2
      AMT2 = PTA(4)**2-PTA(1)**2-PTA(2)**2-PTA(3)**2
      IF ((AMP2.LT.ZERO).OR.(AMT2.LT.ZERO).OR.
     &    (ABS(AMP2-AAM(IDPR)**2).GT.TINY5).OR.
     &    (ABS(AMT2-AAM(IDTA)**2).GT.TINY5)) THEN
         IF (LMSSG.AND.(IOULEV(3).GT.0))
     &   WRITE(ErrorOut,
     * 1000) AMP2,AAM(IDPR)**2,AMT2,AAM(IDTA)**2
 1000    FORMAT(1X,'HADRIN:   WARNING! INCONSISTENT PROJECTILE/TARGET',
     &          ' MASS',/,20X,'AMP2 = ',E12.4,', AAM(IDPR)**2 = ',
     &          E12.4,/,20X,'AMT2 = ',E12.4,', AAM(IDTA)**2 = ',E12.4)
         LMSSG = .FALSE.
         LCORR = .TRUE.
      ENDIF

c convert initial state particles into particles which can be
c handled by HADRIN
      IDHPR = IDPR
      IDHTA = IDTA
      IF ((IDHPR.LE.0).OR.(IDHPR.GE.111).OR.LCORR) THEN
         IF ((IDHPR.LE.0).OR.(IDHPR.GE.111)) IDHPR = 1
         DO 1 K=1,4
            P1IN(K) = PPR(K)
            P2IN(K) = PTA(K)
    1    CONTINUE
         XM1 = AAM(IDHPR)
         XM2 = AAM(IDHTA)
         CALL DT_MASHEL(P1IN,P2IN,XM1,XM2,P1OUT,P2OUT,IREJ1)
         IF (IREJ1.GT.0) THEN
            WRITE(ErrorOut,
     * '(1X,A)') 'HADRIN:   inconsistent mass trsf.'
            GOTO 9999
         ENDIF
         DO 2 K=1,4
            PPR(K) = P1OUT(K)
            PTA(K) = P2OUT(K)
    2    CONTINUE
         PPR(5) = SQRT(PPR(4)**2-PPR(1)**2-PPR(2)**2-PPR(3)**2)
         PTA(5) = SQRT(PTA(4)**2-PTA(1)**2-PTA(2)**2-PTA(3)**2)
      ENDIF

c Lorentz-parameter for trafo into rest-system of target
      DO 3 K=1,4
         BGTA(K) = PTA(K)/PTA(5)
    3 CONTINUE
c transformation of projectile into rest-system of target
      CALL DT_DALTRA(BGTA(4),-BGTA(1),-BGTA(2),-BGTA(3),PPR(1),PPR(2),
     &            PPR(3),PPR(4),PPRTO1,PPR1(1),PPR1(2),PPR1(3),
     &            PPR1(4))

c direction cosines of projectile in target rest system
      CX = PPR1(1)/PPRTO1
      CY = PPR1(2)/PPRTO1
      CZ = PPR1(3)/PPRTO1

c sample inelastic interaction
      IF (MODE.EQ.1) THEN
         CALL DT_DHADRI(IDHPR,PPRTO1,PPR1(4),CX,CY,CZ,IDHTA)
         IF (IRH.EQ.1) GOTO 9998
c sample elastic interaction
      ELSEIF (MODE.EQ.2) THEN
         CALL DT_ELHAIN(IDHPR,PPRTO1,PPR1(4),CX,CY,CZ,IDHTA,IREJ1)
         IF (IREJ1.NE.0) THEN
            IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in HADRIN'
            GOTO 9999
         ENDIF
         IF (IRH.EQ.1) GOTO 9998
      ELSE
         WRITE(ErrorOut,1001) MODE,INTHAD
 1001    FORMAT(1X,'HADRIN:   WARNING! INCONSISTENT INTERACTION MODE',
     &          I4,' (INTHAD =',I4,')')
         GOTO 9999
      ENDIF

c transform final state particles back into Lab.
      DO 4 I=1,IRH
         NFSP = NFSP+1
         PX   = CXRH(I)*PLRH(I)
         PY   = CYRH(I)*PLRH(I)
         PZ   = CZRH(I)*PLRH(I)
         CALL DT_DALTRA(BGTA(4),BGTA(1),BGTA(2),BGTA(3),
     &               PX,PY,PZ,ELRH(I),PTOFSP,PFSP(1,NFSP),
     &               PFSP(2,NFSP),PFSP(3,NFSP),PFSP(4,NFSP))
         IDFSP(NFSP) = ITRH(I)
         AMFSP2 = PFSP(4,NFSP)**2-PFSP(1,NFSP)**2-PFSP(2,NFSP)**2-
     &                                            PFSP(3,NFSP)**2
         IF (AMFSP2.LT.-TINY3) THEN
            WRITE(ErrorOut,
     * 1002) IDFSP(NFSP),PFSP(1,NFSP),PFSP(2,NFSP),
     &                       PFSP(3,NFSP),PFSP(4,NFSP),AMFSP2
 1002       FORMAT(1X,'HADRIN:   WARNING! FINAL STATE PARTICLE (ID = ',
     &             I2,') WITH NEGATIVE MASS^2',/,1X,5E12.4)
            GOTO 9999
         ELSE
            PFSP(5,NFSP) = SQRT(ABS(AMFSP2))
            IF (ABS(PFSP(5,NFSP)-AAM(IDFSP(NFSP))).GT.TINY1) THEN
               WRITE(ErrorOut,
     * 1003) IDFSP(NFSP),AAM(IDFSP(NFSP)),
     &                          PFSP(5,NFSP)
 1003          FORMAT(1X,'HADRIN:   WARNING! FINAL STATE PARTICLE',
     &                ' (ID = ',I2,') WITH INCONSISTENT MASS',/,1X,
     &                2E12.4)
               KCORR         = KCORR+1
               IF (KCORR.GT.2) GOTO 9999
               IMCORR(KCORR) = NFSP
            ENDIF
         ENDIF
c   dump final state particles for energy-momentum cons. check
         IF (LEMCCK) CALL DT_EVTEMC(-PFSP(1,I),-PFSP(2,I),
     &                           -PFSP(3,I),-PFSP(4,I),2,IDUM,IDUM)
    4 CONTINUE

c transform momenta on mass shell in case of inconsistencies in
c HADRIN
      IF (KCORR.GT.0) THEN
         IF (KCORR.EQ.2) THEN
            I1 = IMCORR(1)
            I2 = IMCORR(2)
         ELSE
            IF (IMCORR(1).EQ.1) THEN
               I1 = 1
               I2 = 2
            ELSE
               I1 = 1
               I2 = IMCORR(1)
            ENDIF
         ENDIF
         IF (LEMCCK) CALL DT_EVTEMC(PFSP(1,I1),PFSP(2,I1),
     &                           PFSP(3,I1),PFSP(4,I1),2,IDUM,IDUM)
         IF (LEMCCK) CALL DT_EVTEMC(PFSP(1,I2),PFSP(2,I2),
     &                           PFSP(3,I2),PFSP(4,I2),2,IDUM,IDUM)
         DO 5 K=1,4
            P1IN(K) = PFSP(K,I1)
            P2IN(K) = PFSP(K,I2)
    5    CONTINUE
         XM1 = AAM(IDFSP(I1))
         XM2 = AAM(IDFSP(I2))
         CALL DT_MASHEL(P1IN,P2IN,XM1,XM2,P1OUT,P2OUT,IREJ1)
         IF (IREJ1.GT.0) THEN
            WRITE(ErrorOut,
     * '(1X,A)') 'HADRIN:   inconsistent mass trsf.'
C           GOTO 9999
         ENDIF
         DO 6 K=1,4
            PFSP(K,I1) = P1OUT(K)
            PFSP(K,I2) = P2OUT(K)
    6    CONTINUE
         PFSP(5,I1) = SQRT(PFSP(4,I1)**2-PFSP(1,I1)**2
     &                    -PFSP(2,I1)**2-PFSP(3,I1)**2)
         PFSP(5,I2) = SQRT(PFSP(4,I2)**2-PFSP(1,I2)**2
     &                    -PFSP(2,I2)**2-PFSP(3,I2)**2)
c   dump final state particles for energy-momentum cons. check
         IF (LEMCCK) CALL DT_EVTEMC(-PFSP(1,I1),-PFSP(2,I1),
     &                           -PFSP(3,I1),-PFSP(4,I1),2,IDUM,IDUM)
         IF (LEMCCK) CALL DT_EVTEMC(-PFSP(1,I2),-PFSP(2,I2),
     &                           -PFSP(3,I2),-PFSP(4,I2),2,IDUM,IDUM)
      ENDIF

c check energy-momentum conservation
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(DUM,DUM,DUM,DUM,4,102,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
      ENDIF

      RETURN

 9998 CONTINUE
      IREJ = 2
      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===hadcol=============================================================*
c
CDECK  ID>, DT_HADCOL
      SUBROUTINE DT_HADCOL(IDPROJ,PPN,IDXTAR,IREJ)

c***********************************************************************
c Interface to the HADRIN-routines for inelastic and elastic           *
c scattering. This subroutine samples hadron-nucleus interactions      *
c below DPM-threshold.                                                 *
c      IDPROJ        BAMJET-index of projectile hadron                 *
c      PPN           projectile momentum in target rest frame          *
c      IDXTAR        DTEVT1-index of target nucleon undergoing         *
c                    interaction with projectile hadron                *
c This subroutine replaces HADHAD.                                     *
c This version dated 5.5.95 is written by S. Roesler                   *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,TINY3=1.0D-3,ONE=1.0D0)

      LOGICAL LSTART

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c interface HADRIN-DPM
      COMMON /HNTHRE/ EHADTH,EHADLO,EHADHI,INTHAD,IDXTA

c parameter for intranuclear cascade
      LOGICAL LPAULI
      COMMON /DTFOTI/ TAUFOR,KTAUGE,ITAUVE,INCMOD,LPAULI

c final state after inc step
      PARAMETER (MAXFSP=10)
      COMMON /DTCAPA/ PFSP(5,MAXFSP),IDFSP(MAXFSP),NFSP

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


      DIMENSION PPROJ(5),PNUC(5)

      DATA LSTART /.TRUE./

      IREJ   = 0

      NPOINT(1) = NHKK+1

      TAUSAV = TAUFOR
      TAUFOR = TAUFOR/2.0D0
      IF (LSTART) THEN
         WRITE(ErrorOut,1000)
 1000    FORMAT(/,1X,'HADCOL:  SCATTERING HANDLED BY HADRIN')
         WRITE(ErrorOut,1001) TAUFOR
 1001    FORMAT(/,1X,'HADCOL:  FORMATION ZONE PARAMETER SET TO ',
     &          F5.1,' FM/C')
         LSTART = .FALSE.
      ENDIF

      IDNUC  = IDBAM(IDXTAR)
      IDNUC1 = IDT_MCHAD(IDNUC)
      IDPRO1 = IDT_MCHAD(IDPROJ)

      IF ((INTHAD.EQ.1).OR.(INTHAD.EQ.2)) THEN
         IPROC = INTHAD
      ELSE
c*
C        CALL DT_SIHNIN(IDPRO1,IDNUC1,PPN,SIGIN)
C        CALL DT_SIHNEL(IDPRO1,IDNUC1,PPN,SIGEL)
         DUMZER = ZERO
         CALL DT_XSHN(IDPRO1,IDNUC1,PPN,DUMZER,SIGTOT,SIGEL)
         SIGIN = SIGTOT-SIGEL
C        SIGTOT = SIGIN+SIGEL
c*
         IPROC  = 1
         IF (DT_RNDM(SIGIN).LT.SIGEL/SIGTOT) IPROC = 2
      ENDIF

      PPROJ(1) = ZERO
      PPROJ(2) = ZERO
      PPROJ(3) = PPN
      PPROJ(5) = AAM(IDPROJ)
      PPROJ(4) = SQRT(PPROJ(5)**2+PPROJ(3)**2)
      DO 1 K=1,5
         PNUC(K)  = PHKK(K,IDXTAR)
    1 CONTINUE

      ILOOP = 0
    2 CONTINUE
      ILOOP = ILOOP+1
      IF (ILOOP.GT.100) GOTO 9999

      CALL DT_HADRIN(IDPROJ,PPROJ,IDNUC,PNUC,IPROC,IREJ1)
      IF (IREJ1.EQ.1) GOTO 9999

      IF (IREJ1.GT.1) THEN
c no interaction possible
c   require Pauli blocking
         IF ((IDPROJ.EQ.1).AND.(PPROJ(4).LE.PFERMP(2)+PPROJ(5))) GOTO 2
         IF ((IDPROJ.EQ.8).AND.(PPROJ(4).LE.PFERMN(2)+PPROJ(5))) GOTO 2
         IF ((IIBAR(IDPROJ).NE.1).AND.
     &       (PPROJ(4).LE.EPOT(2,IDPROJ)+PPROJ(5)))              GOTO 2
c   store incoming particle as final state particle
         CALL DT_LTNUC(PPROJ(3),PPROJ(4),PCMS,ECMS,3)
         CALL DT_EVTPUT(1,IDPROJ,1,0,PPROJ(1),PPROJ(2),PCMS,ECMS,0,0,0)
         NPOINT(4) = NHKK
      ELSE
c require Pauli blocking for final state nucleons
         DO 4 I=1,NFSP
            IF ((IDFSP(I).EQ.1).AND.
     &          (PFSP(4,I).LE.PFERMP(2)+AAM(IDFSP(I))))       GOTO 2
            IF ((IDFSP(I).EQ.8).AND.
     &          (PFSP(4,I).LE.PFERMN(2)+AAM(IDFSP(I))))       GOTO 2
            IF ((IIBAR(IDFSP(I)).NE.1).AND.
     &          (PFSP(4,I).LE.EPOT(2,IDFSP(I))+AAM(IDFSP(I))))GOTO 2
    4    CONTINUE
c store final state particles
         DO 5 I=1,NFSP
            IST = 1
            IF ((IIBAR(IDFSP(I)).EQ.1).AND.
     &          (PFSP(4,I).LE.EPOT(2,IDFSP(I))+AAM(IDFSP(I)))) IST = 16
            IDHAD = IDT_IPDGHA(IDFSP(I))
            CALL DT_LTNUC(PFSP(3,I),PFSP(4,I),PCMS,ECMS,3)
            CALL DT_EVTPUT(IST,IDHAD,1,IDXTAR,PFSP(1,I),PFSP(2,I),
     &                                        PCMS,ECMS,0,0,0)
            IF (I.EQ.1) NPOINT(4) = NHKK
            VHKK(1,NHKK) = 0.5D0*(VHKK(1,1)+VHKK(1,IDXTAR))
            VHKK(2,NHKK) = 0.5D0*(VHKK(2,1)+VHKK(2,IDXTAR))
            VHKK(3,NHKK) = VHKK(3,IDXTAR)
            VHKK(4,NHKK) = VHKK(4,IDXTAR)
            WHKK(1,NHKK) = 0.5D0*(WHKK(1,1)+WHKK(1,IDXTAR))
            WHKK(2,NHKK) = 0.5D0*(WHKK(2,1)+WHKK(2,IDXTAR))
            WHKK(3,NHKK) = WHKK(3,1)
            WHKK(4,NHKK) = WHKK(4,1)
    5    CONTINUE
      ENDIF
      TAUFOR = TAUSAV
      RETURN

 9999 CONTINUE
      IREJ = 1
      TAUFOR = TAUSAV
      RETURN
      END
c
c===getemu=============================================================*
c
CDECK  ID>, DT_GETEMU
      SUBROUTINE DT_GETEMU(IT,ITZ,KKMAT,MODE)

c***********************************************************************
c Sampling of emulsion component to be considered as target-nucleus.   *
c This version dated 6.5.95   is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY3=1.0D-3,TINY10=1.0D-10)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD


      IF (MODE.EQ.0) THEN
         SUMFRA = ZERO
         RR = DT_RNDM(SUMFRA)
         IT  = 0
         ITZ = 0
         DO 1 ICOMP=1,NCOMPO
            SUMFRA = SUMFRA+EMUFRA(ICOMP)
            IF (SUMFRA.GT.RR) THEN
               IT    = IEMUMA(ICOMP)
               ITZ   = IEMUCH(ICOMP)
               KKMAT = ICOMP
               GOTO 2
            ENDIF
    1    CONTINUE
    2    CONTINUE
         IF (IT.LE.0) THEN
            WRITE(ErrorOut,'(1X,A,E12.3)')
     &       'WARNING!  NORM. FAILURE WITHIN EMULSION FRACTIONS',
     &       SUMFRA
            STOP
         ENDIF
      ELSEIF (MODE.EQ.1) THEN
         NDIFF = 10000
         DO 3 I=1,NCOMPO
            IDIFF = ABS(IT-IEMUMA(I))
            IF (IDIFF.LT.NDIFF) THEN
               KKMAT = I
               NDIFF = IDIFF
            ENDIF
    3    CONTINUE
      ELSE
         STOP 'DT_GETEMU'
      ENDIF

c bypass for variable projectile/target/energy runs: the correct
c Glauber data will be always loaded on kkmat=1
      IF (IOGLB.EQ.100) THEN
         KKMAT = 1
      ENDIF

      RETURN
      END
c
c===nclpot=============================================================*
c
CDECK  ID>, DT_NCLPOT
      SUBROUTINE DT_NCLPOT(IPZ,IP,ITZ,IT,AFERP,AFERT,MODE)

c***********************************************************************
c Calculation of Coulomb and nuclear potential for a given configurat. *
c               IPZ, IP       charge/mass number of proj.              *
c               ITZ, IT       charge/mass number of targ.              *
c               AFERP,AFERT   factors modifying proj./target pot.      *
c                             if =0, FERMOD is used                    *
c               MODE = 0      calculation of binding energy            *
c                    = 1      pre-calculated binding energy is used    *
c This version dated 16.11.95  is written by S. Roesler.               *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY3=1.0D-3,TINY2=1.0D-2,
     &           TINY10=1.0D-10)

      LOGICAL LSTART

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI


      DIMENSION IDXPOT(14)
c                   ap   an  lam  alam sig- sig+ sig0 tet0 tet- asig-
      DATA IDXPOT /   2,   9,  17,  18,  20,  21,  22,  97,  98,  99,
c                 asig0 asig+ atet0 atet+
     &              100, 101, 102, 103/

      DATA AN     /0.4D0/
      DATA LSTART /.TRUE./

      IF (MODE.EQ.0) THEN
         EBINDP(1) = ZERO
         EBINDN(1) = ZERO
         EBINDP(2) = ZERO
         EBINDN(2) = ZERO
      ENDIF
      AIP  = DBLE(IP)
      AIPZ = DBLE(IPZ)
      AIT  = DBLE(IT)
      AITZ = DBLE(ITZ)

      FERMIP = AFERP
      IF (AFERP.LE.ZERO) FERMIP = FERMOD
      FERMIT = AFERT
      IF (AFERT.LE.ZERO) FERMIT = FERMOD

c Fermi momenta and binding energy for projectile
      IF ((IP.GT.1).AND.LFERMI) THEN
         IF (MODE.EQ.0) THEN
C           EBINDP(1) = DT_EBIND(IP,IPZ)-DT_EBIND(IP-1,IPZ-1)
C           EBINDN(1) = DT_EBIND(IP,IPZ)-DT_EBIND(IP-1,IPZ)
            BIP  = AIP -ONE
            BIPZ = AIPZ-ONE
            EBINDP(1) = 1.0D-3*ABS(DT_ENERGY(AIP,AIPZ)
     &                            -DT_ENERGY(BIP,BIPZ))
            IF (AIP.LE.AIPZ) THEN
               EBINDN(1) = EBINDP(1)
               WRITE(ErrorOut,
     * *) ' DT_NCLPOT: AIP.LE.AIPZ (',AIP,AIPZ,')'
            ELSE
               EBINDN(1) = 1.0D-3*ABS(DT_ENERGY(AIP,AIPZ)
     &                               -DT_ENERGY(BIP,AIPZ))
            ENDIF
         ENDIF
         PFERMP(1) = FERMIP*AN*(AIPZ/AIP)**0.333333D0
         PFERMN(1) = FERMIP*AN*((AIP-AIPZ)/AIP)**0.33333D0
      ELSE
         PFERMP(1) = ZERO
         PFERMN(1) = ZERO
      ENDIF
c effective nuclear potential for projectile
C     EPOT(1,1) = PFERMP(1)**2/(2.0D0*AAM(1)) + EBINDP(1)
C     EPOT(1,8) = PFERMN(1)**2/(2.0D0*AAM(8)) + EBINDN(1)
      EPOT(1,1) = SQRT(PFERMP(1)**2+AAM(1)**2) -AAM(1) + EBINDP(1)
      EPOT(1,8) = SQRT(PFERMN(1)**2+AAM(8)**2) -AAM(8) + EBINDN(1)

c Fermi momenta and binding energy for target
      IF ((IT.GT.1).AND.LFERMI) THEN
         IF (MODE.EQ.0) THEN
C           EBINDP(2) = DT_EBIND(IT,ITZ)-DT_EBIND(IT-1,ITZ-1)
C           EBINDN(2) = DT_EBIND(IT,ITZ)-DT_EBIND(IT-1,ITZ)
            BIT  = AIT -ONE
            BITZ = AITZ-ONE
            EBINDP(2) = 1.0D-3*ABS(DT_ENERGY(AIT,AITZ)
     &                            -DT_ENERGY(BIT,BITZ))
            IF (AIT.LE.AITZ) THEN
               EBINDN(2) = EBINDP(2)
               WRITE(ErrorOut,
     * *) ' DT_NCLPOT: AIT.LE.AIPT (',AIT,AIPT,')'
            ELSE
               EBINDN(2) = 1.0D-3*ABS(DT_ENERGY(AIT,AITZ)
     &                               -DT_ENERGY(BIT,AITZ))
            ENDIF
         ENDIF
         PFERMP(2) = FERMIT*AN*(AITZ/AIT)**0.333333D0
         PFERMN(2) = FERMIT*AN*((AIT-AITZ)/AIT)**0.33333D0
      ELSE
         PFERMP(2) = ZERO
         PFERMN(2) = ZERO
      ENDIF
c effective nuclear potential for target
C     EPOT(2,1) = PFERMP(2)**2/(2.0D0*AAM(1)) + EBINDP(2)
C     EPOT(2,8) = PFERMN(2)**2/(2.0D0*AAM(8)) + EBINDN(2)
      EPOT(2,1) = SQRT(PFERMP(2)**2+AAM(1)**2) -AAM(1) + EBINDP(2)
      EPOT(2,8) = SQRT(PFERMN(2)**2+AAM(8)**2) -AAM(8) + EBINDN(2)

      DO 2 I=1,14
         EPOT(1,IDXPOT(I)) = EPOT(1,8)
         EPOT(2,IDXPOT(I)) = EPOT(2,8)
    2 CONTINUE

c Coulomb energy
      ETACOU(1) = ZERO
      ETACOU(2) = ZERO
      IF (ICOUL.EQ.1) THEN
         IF (IP.GT.1)
     &   ETACOU(1) = 0.001116D0*AIPZ/(1.0D0+AIP**0.333D0)
         IF (IT.GT.1)
     &   ETACOU(2) = 0.001116D0*AITZ/(1.0D0+AIT**0.333D0)
      ENDIF

      IF (LSTART) THEN
         WRITE(ErrorOut,1000) IP,IPZ,IT,ITZ,EBINDP,EBINDN,
     &                    EPOT(1,1)-EBINDP(1),EPOT(2,1)-EBINDP(2),
     &                    EPOT(1,8)-EBINDN(1),EPOT(2,8)-EBINDN(2),
     &                    FERMOD,ETACOU
 1000    FORMAT(/,/,1X,'NCLPOT:    QUANTITIES FOR INCLUSION OF NUCLEAR'
     &           ,' EFFECTS',/,12X,'---------------------------',
     &           '----------------',/,/,38X,'PROJECTILE',
     &           '      TARGET',/,/,1X,'MASS NUMBER / CHARGE',
     &           17X,I3,' /',I3,6X,I3,' /',I3,/,1X,'BINDING ENERGY  -',
     &           ' PROTON   (GEV) ',2E14.4,/,17X,'- NEUTRON  (GEV)'
     &          ,1X,2E14.4,/,1X,'FERMI-POTENTIAL - PROTON   (GEV)',
     &           1X,2E14.4,/,17X,'- NEUTRON  (GEV) ',2E14.4,/,/,
     &           1X,'SCALE FACTOR FOR FERMI-MOMENTUM    ',F4.2,/,
     &           /,1X,'COULOMB-ENERGY ',2(E14.4,' GEV  '),/,/)
         LSTART = .FALSE.
      ENDIF

      RETURN
      END
c
c===resncl=============================================================*
c
CDECK  ID>, DT_RESNCL
      SUBROUTINE DT_RESNCL(EPN,NLOOP,MODE)

c***********************************************************************
c Treatment of residual nuclei and nuclear effects.                    *
c         MODE = 1     initializations                                 *
c              = 2     treatment of final state                        *
c This version dated 16.11.95 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.D0,ONE=1.D0,TWO=2.D0,THREE=3.D0,TINY3=1.0D-3,
     &           TINY2=1.0D-2,TINY1=1.0D-1,TINY4=1.0D-4,TINY10=1.0D-10,
     &           ONETHI=ONE/THREE)
      PARAMETER (AMUAMU = 0.93149432D0,
     &           FM2MM  = 1.0D-12,
     &           RNUCLE = 1.12D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c treatment of residual nuclei: wounded nucleons
      COMMON /DTWOUN/ NPW,NPW0,NPCW,NTW,NTW0,NTCW,IPW(210),ITW(210)

c treatment of residual nuclei: 4-momenta
      LOGICAL LRCLPR,LRCLTA
      COMMON /DTRNU1/ PINIPR(5),PINITA(5),PRCLPR(5),PRCLTA(5),
     &                TRCLPR(5),TRCLTA(5),LRCLPR,LRCLTA


      DIMENSION PFSP(4),PSEC(4),PSEC0(4)
      DIMENSION PMOMB(5000),IDXB(5000),PMOMM(10000),IDXM(10000),
     &          IDXCOR(15000),IDXOTH(NMXHKK)

      GOTO (1,2) MODE

c------- initializations
    1 CONTINUE

c initialize arrays for residual nuclei
      DO 10 K=1,5
         IF (K.LE.4) THEN
            PFSP(K)     = ZERO
         ENDIF
         PINIPR(K) = ZERO
         PINITA(K) = ZERO
         PRCLPR(K) = ZERO
         PRCLTA(K) = ZERO
         TRCLPR(K) = ZERO
         TRCLTA(K) = ZERO
   10 CONTINUE
      SCPOT = ONE
      NLOOP = 0

c correction of projectile 4-momentum for effective target pot.
c and Coulomb-energy (in case of hadron-nucleus interaction only)
      IF ((IP.EQ.1).AND.(IT.GT.1).AND.LFERMI) THEN
         EPNI = EPN
c   Coulomb-energy:
c     positively charged hadron - check energy for Coloumb pot.
         IF (IICH(IJPROJ).EQ.1) THEN
            THRESH = ETACOU(2)+AAM(IJPROJ)
            IF (EPNI.LE.THRESH) THEN
               WRITE(ErrorOut,1000)
 1000          FORMAT(/,1X,'KKINC:  WARNING!  PROJECTILE ENERGY',
     &                ' BELOW COULOMB THRESHOLD - EVENT REJECTED',/)
               ISTHKK(1) = 1
               RETURN
            ENDIF
c     negatively charged hadron - increase energy by Coulomb energy
         ELSEIF (IICH(IJPROJ).EQ.-1) THEN
            EPNI = EPNI+ETACOU(2)
         ENDIF
         IF ((IJPROJ.EQ.1).OR.(IJPROJ.EQ.8)) THEN
c   Effective target potential
csr 6.6. binding energy only (to avoid negative exc. energies)
C           EPNI = EPNI+EPOT(2,IJPROJ)
            EBIPOT = EBINDP(2)
            IF ((IJPROJ.NE.1).AND.(ABS(EPOT(2,IJPROJ)).GT.5.0D-3))
     &         EBIPOT = EBINDN(2)
            EPNI = EPNI+ABS(EBIPOT)
c re-initialization of DTLTRA
            DUM1 = ZERO
            DUM2 = ZERO
            CALL DT_LTINI(IJPROJ,IJTARG,EPNI,DUM1,DUM2,0)
         ENDIF
      ENDIF

c projectile in n-n cms
      IF ((IP.LE.1).AND.(IT.GT.1)) THEN
         PMASS1 = AAM(IJPROJ)
C* VDM assumption
C         IF (IJPROJ.EQ.7) PMASS1 = AAM(33)
         IF (IJPROJ.EQ.7) PMASS1 = AAM(IJPROJ)-SQRT(VIRT)
         PMASS2 = AAM(1)
         PM1 = SIGN(PMASS1**2,PMASS1)
         PM2 = SIGN(PMASS2**2,PMASS2)
         PINIPR(4) = (UMO**2-PM2+PM1)/(TWO*UMO)
         PINIPR(5) = PMASS1
         IF (PMASS1.GT.ZERO) THEN
            PINIPR(3) = SQRT((PINIPR(4)-PINIPR(5))
     &                      *(PINIPR(4)+PINIPR(5)))
         ELSE
            PINIPR(3) = SQRT(PINIPR(4)**2-PM1)
         ENDIF
         AIT  = DBLE(IT)
         AITZ = DBLE(ITZ)
         PINITA(5) = AIT*AMUAMU+1.0D-3*DT_ENERGY(AIT,AITZ)
         CALL DT_LTNUC(ZERO,PINITA(5),PINITA(3),PINITA(4),3)
      ELSEIF ((IP.GT.1).AND.(IT.LE.1)) THEN
         PMASS1 = AAM(1)
         PMASS2 = AAM(IJTARG)
         PM1 = SIGN(PMASS1**2,PMASS1)
         PM2 = SIGN(PMASS2**2,PMASS2)
         PINITA(4) = (UMO**2-PM1+PM2)/(TWO*UMO)
         PINITA(5) = PMASS2
         PINITA(3) = -SQRT((PINITA(4)-PINITA(5))
     &                    *(PINITA(4)+PINITA(5)))
         AIP  = DBLE(IP)
         AIPZ = DBLE(IPZ)
         PINIPR(5) = AIP*AMUAMU+1.0D-3*DT_ENERGY(AIP,AIPZ)
         CALL DT_LTNUC(ZERO,PINIPR(5),PINIPR(3),PINIPR(4),2)
      ELSEIF ((IP.GT.1).AND.(IT.GT.1)) THEN
         AIP  = DBLE(IP)
         AIPZ = DBLE(IPZ)
         PINIPR(5) = AIP*AMUAMU+1.0D-3*DT_ENERGY(AIP,AIPZ)
         CALL DT_LTNUC(ZERO,PINIPR(5),PINIPR(3),PINIPR(4),2)
         AIT  = DBLE(IT)
         AITZ = DBLE(ITZ)
         PINITA(5) = AIT*AMUAMU+1.0D-3*DT_ENERGY(AIT,AITZ)
         CALL DT_LTNUC(ZERO,PINITA(5),PINITA(3),PINITA(4),3)
      ENDIF

      RETURN

c------- treatment of final state
    2 CONTINUE

      NLOOP = NLOOP+1
      IF (NLOOP.GT.1) SCPOT = 0.10D0
C     WRITE(LOUT,*) 'event ',NEVHKK,NLOOP,SCPOT

      JPW  = NPW
      JPCW = NPCW
      JTW  = NTW
      JTCW = NTCW
      DO 40 K=1,4
         PFSP(K)   = ZERO
   40 CONTINUE

      NOB = 0
      NOM = 0
      DO 900 I=NPOINT(4),NHKK
         IDXOTH(I) = -1
         IF (ISTHKK(I).EQ.1) THEN
            IF (IDBAM(I).EQ.7) GOTO 900
            IPOT = 0
            IOTHER = 0
c particle moving into forward direction
            IF (PHKK(3,I).GE.ZERO) THEN
c   most likely to be effected by projectile potential
               IPOT = 1
c     there is no projectile nucleus, try target
               IF ((IP.LE.1).OR.((IP-NPW).LE.1)) THEN
                  IPOT   = 2
                  IF (IP.GT.1) IOTHER = 1
c       there is no target nucleus --> skip
                  IF ((IT.LE.1).OR.((IT-NTW).LE.1)) GOTO 900
               ENDIF
c particle moving into backward direction
            ELSE
c   most likely to be effected by target potential
               IPOT = 2
c     there is no target nucleus, try projectile
               IF ((IT.LE.1).OR.((IT-NTW).LE.1)) THEN
                  IPOT   = 1
                  IF (IT.GT.1) IOTHER = 1
c       there is no projectile nucleus --> skip
                  IF ((IP.LE.1).OR.((IP-NPW).LE.1)) GOTO 900
               ENDIF
            ENDIF
            IFLG = -IPOT
c nobam=3: particle is in overlap-region or neither inside proj. nor target
c      =1: particle is not in overlap-region AND is inside target (2)
c      =2: particle is not in overlap-region AND is inside projectile (1)
c flag particles which are inside the nucleus ipot but not in its
c overlap region
            IF ((NOBAM(I).NE.IPOT).AND.(NOBAM(I).LT.3)) IFLG = IPOT
c baryons: keep all nucleons and all others where flag is set
            IF (IIBAR(IDBAM(I)).NE.0) THEN
               IF ((IDBAM(I).EQ.1).OR.(IDBAM(I).EQ.8).OR.(IFLG.GT.0))
     &                                                           THEN
                  NOB = NOB+1
                  PMOMB(NOB) = PHKK(3,I)
                  IDXB(NOB)  = SIGN(1000000*IABS(IFLG)
     &                        +100000*IOTHER+I,IFLG)
               ENDIF
c mesons: keep only those mesons where flag is set
            ELSE
               IF (IFLG.GT.0) THEN
                  NOM = NOM+1
                  PMOMM(NOM) = PHKK(3,I)
                  IDXM(NOM)  = 1000000*IFLG+100000*IOTHER+I
               ENDIF
            ENDIF
         ENDIF
  900 CONTINUE
c
c sort particles in the arrays according to increasing long. momentum
      CALL DT_SORT1(PMOMB,IDXB,NOB,1,NOB,1)
      CALL DT_SORT1(PMOMM,IDXM,NOM,1,NOM,1)
c
c shuffle indices into one and the same array according to the later
c sequence of correction
      NCOR = 0
      IF (IT.GT.1) THEN
         DO 910 I=1,NOB
            IF (PMOMB(I).GT.ZERO) GOTO 911
            NCOR = NCOR+1
            IDXCOR(NCOR) = IDXB(I)
  910    CONTINUE
  911    CONTINUE
         IF (IP.GT.1) THEN
            DO 912 J=1,NOB
               I = NOB+1-J
               IF (PMOMB(I).LT.ZERO) GOTO 913
               NCOR = NCOR+1
               IDXCOR(NCOR) = IDXB(I)
  912       CONTINUE
  913       CONTINUE
         ELSE
            DO 914 I=1,NOB
               IF (PMOMB(I).GT.ZERO) THEN
                  NCOR = NCOR+1
                  IDXCOR(NCOR) = IDXB(I)
               ENDIF
  914       CONTINUE
         ENDIF
      ELSE
         DO 915 J=1,NOB
            I = NOB+1-J
            NCOR = NCOR+1
            IDXCOR(NCOR) = IDXB(I)
  915    CONTINUE
      ENDIF
      DO 925 I=1,NOM
         IF (PMOMM(I).GT.ZERO) GOTO 926
         NCOR = NCOR+1
         IDXCOR(NCOR) = IDXM(I)
  925 CONTINUE
  926 CONTINUE
      DO 927 J=1,NOM
         I = NOM+1-J
         IF (PMOMM(I).LT.ZERO) GOTO 928
         NCOR = NCOR+1
         IDXCOR(NCOR) = IDXM(I)
  927 CONTINUE
  928 CONTINUE
c
C      IF (NEVHKK.EQ.484) THEN
C         WRITE(LOUT,9000) JPCW,JPW-JPCW,JTCW,JTW-JTCW
C 9000    FORMAT(1X,'wounded nucleons (proj.-p,n  targ.-p,n)',/,4I10)
C         WRITE(LOUT,9001) NOB,NOM,NCOR
C 9001    FORMAT(1X,'produced particles (baryons,mesons,all)',3I10)
C         WRITE(LOUT,'(/,A)') ' baryons '
C         DO 950 I=1,NOB
CC           J     = IABS(IDXB(I))
CC           INDEX = J-IABS(J/1000000)*1000000
C            IPOT   = IABS(IDXB(I))/1000000
C            IOTHER = IABS(IDXB(I))/100000-IPOT*10
C            INDEX = IABS(IDXB(I))-IPOT*1000000-IOTHER*100000
C            WRITE(LOUT,9002) I,INDEX,IDXB(I),IDBAM(INDEX),PMOMB(I)
C  950    CONTINUE
C         WRITE(LOUT,'(/,A)') ' mesons '
C         DO 951 I=1,NOM
CC           INDEX = IDXM(I)-IABS(IDXM(I)/1000000)*1000000
C            IPOT   = IABS(IDXM(I))/1000000
C            IOTHER = IABS(IDXM(I))/100000-IPOT*10
C            INDEX = IABS(IDXM(I))-IPOT*1000000-IOTHER*100000
C            WRITE(LOUT,9002) I,INDEX,IDXM(I),IDBAM(INDEX),PMOMM(I)
C  951    CONTINUE
C 9002    FORMAT(1X,4I14,E14.5)
C         WRITE(LOUT,'(/,A)') ' all '
C         DO 952 I=1,NCOR
CC           J     = IABS(IDXCOR(I))
CC           INDEX = J-IABS(J/1000000)*1000000
CC            IPOT   = IABS(IDXCOR(I))/1000000
C            IOTHER = IABS(IDXCOR(I))/100000-IPOT*10
C            INDEX = IABS(IDXCOR(I))-IPOT*1000000-IOTHER*100000
C            WRITE(LOUT,9003) I,INDEX,IDXCOR(I),IDBAM(INDEX)
C  952    CONTINUE
C 9003    FORMAT(1X,4I14)
C      ENDIF
c
      DO 20 ICOR=1,NCOR
         IPOT   = IABS(IDXCOR(ICOR))/1000000
         IOTHER = IABS(IDXCOR(ICOR))/100000-IPOT*10
         I = IABS(IDXCOR(ICOR))-IPOT*1000000-IOTHER*100000
         IDXOTH(I) = 1

         IDSEC  = IDBAM(I)

c reduction of particle momentum by corresponding nuclear potential
c (this applies only if Fermi-momenta are requested)

         IF (LFERMI) THEN

c   Lorentz-transformation into the rest system of the selected nucleus
            IMODE = -IPOT-1
            CALL DT_LTRANS(PHKK(1,I),PHKK(2,I),PHKK(3,I),PHKK(4,I),
     &                  PSEC(1),PSEC(2),PSEC(3),PSEC(4),IDSEC,IMODE)
            PSECO  = SQRT(PSEC(1)**2+PSEC(2)**2+PSEC(3)**2)
            AMSEC  = SQRT(ABS((PSEC(4)-PSECO)*(PSEC(4)+PSECO)))
            JPMOD  = 0

            CHKLEV = TINY3
            IF ((EPROJ.GE.1.0D4).AND.(IDSEC.EQ.7)) CHKLEV = TINY1
            IF (EPROJ.GE.2.0D6) CHKLEV = 1.0D0
            IF (ABS(AMSEC-AAM(IDSEC)).GT.CHKLEV) THEN
               IF (IOULEV(3).GT.0)
     &            WRITE(ErrorOut,
     * 2000) I,NEVHKK,IDSEC,AMSEC,AAM(IDSEC)
 2000          FORMAT(1X,'RESNCL: INCONSISTENT MASS OF PARTICLE',
     &                ' AT ENTRY ',I5,' (EVT.',I8,')',/,' IDSEC: ',
     &                I4,'   AMSEC: ',E12.3,'  AAM(IDSEC): ',E12.3,/)
               GOTO 23
            ENDIF

            DO 21 K=1,4
               PSEC0(K) = PSEC(K)
   21       CONTINUE

c   the correction for nuclear potential effects is applied to as many
c   p/n as many nucleons were wounded; the momenta of other final state
c   particles are corrected only if they materialize inside the corresp.
c   nucleus (here: NOBAM = 1 part. outside proj., = 2 part. outside targ
c   = 3 part. outside proj. and targ., >=10 in overlapping region)
            IF ((IDSEC.EQ.1).OR.(IDSEC.EQ.8)) THEN
               IF (IPOT.EQ.1) THEN
                  IF ((JPW.GT.0).AND.(IOTHER.EQ.0)) THEN
c      this is most likely a wounded nucleon
c*test
C                    RDIST = SQRT((VHKK(1,IPW(JPW))/FM2MM)**2
C    &                           +(VHKK(2,IPW(JPW))/FM2MM)**2
C    &                           +(VHKK(3,IPW(JPW))/FM2MM)**2)
C                    RAD   = RNUCLE*DBLE(IP)**ONETHI
C                    FDEN  = 1.4D0*DT_DENSIT(IP,RDIST,RAD)
C                    PSEC(4) = PSEC(4)-SCPOT*FDEN*EPOT(IPOT,IDSEC)
c*
                     PSEC(4) = PSEC(4)-SCPOT*EPOT(IPOT,IDSEC)
                     JPW = JPW-1
                     JPMOD = 1
                  ELSE
c      correct only if part. was materialized inside nucleus
c      and if it is ouside the overlapping region
                     IF ((NOBAM(I).NE.1).AND.(NOBAM(I).LT.3)) THEN
                        PSEC(4) = PSEC(4)-SCPOT*EPOT(IPOT,IDSEC)
                        JPMOD = 1
                     ENDIF
                  ENDIF
               ELSEIF (IPOT.EQ.2) THEN
                  IF ((JTW.GT.0).AND.(IOTHER.EQ.0)) THEN
c      this is most likely a wounded nucleon
c*test
C                    RDIST = SQRT((VHKK(1,ITW(JTW))/FM2MM)**2
C    &                           +(VHKK(2,ITW(JTW))/FM2MM)**2
C    &                           +(VHKK(3,ITW(JTW))/FM2MM)**2)
C                    RAD   = RNUCLE*DBLE(IT)**ONETHI
C                    FDEN  = 1.4D0*DT_DENSIT(IT,RDIST,RAD)
C                    PSEC(4) = PSEC(4)-SCPOT*FDEN*EPOT(IPOT,IDSEC)
c*
                     PSEC(4) = PSEC(4)-SCPOT*EPOT(IPOT,IDSEC)
                     JTW = JTW-1
                     JPMOD = 1
                  ELSE
c      correct only if part. was materialized inside nucleus
                     IF ((NOBAM(I).NE.2).AND.(NOBAM(I).LT.3)) THEN
                        PSEC(4) = PSEC(4)-SCPOT*EPOT(IPOT,IDSEC)
                        JPMOD = 1
                     ENDIF
                  ENDIF
               ENDIF
            ELSE
               IF ((NOBAM(I).NE.IPOT).AND.(NOBAM(I).LT.3)) THEN
                  PSEC(4) = PSEC(4)-SCPOT*EPOT(IPOT,IDSEC)
                  JPMOD = 1
               ENDIF
            ENDIF

            IF (NLOOP.EQ.1) THEN
c Coulomb energy correction:
c the treatment of Coulomb potential correction is similar to the
c one for nuclear potential
               IF (IDSEC.EQ.1) THEN
                  IF ((IPOT.EQ.1).AND.(JPCW.GT.0)) THEN
                     JPCW = JPCW-1
                  ELSEIF ((IPOT.EQ.2).AND.(JTCW.GT.0)) THEN
                     JTCW = JTCW-1
                  ELSE
                     IF ((NOBAM(I).EQ.IPOT).OR.(NOBAM(I).EQ.3)) GOTO 25
                  ENDIF
               ELSE
                  IF ((NOBAM(I).EQ.IPOT).OR.(NOBAM(I).EQ.3)) GOTO 25
               ENDIF
               IF (IICH(IDSEC).EQ.1) THEN
c    pos. particles: check if they are able to escape Coulomb potential
                  IF (PSEC(4).LT.AMSEC+ETACOU(IPOT)) THEN
                     ISTHKK(I) = 14+IPOT
                     IF (ISTHKK(I).EQ.15) THEN
                        DO 26 K=1,4
                           PHKK(K,I) = PSEC0(K)
                           TRCLPR(K) = TRCLPR(K)+PSEC0(K)
   26                CONTINUE
                        IF ((IDSEC.EQ.1).OR.(IDSEC.EQ.8)) NPW = NPW-1
                        IF (IDSEC.EQ.1) NPCW = NPCW-1
                     ELSEIF (ISTHKK(I).EQ.16) THEN
                        DO 27 K=1,4
                           PHKK(K,I) = PSEC0(K)
                           TRCLTA(K) = TRCLTA(K)+PSEC0(K)
   27                   CONTINUE
                        IF ((IDSEC.EQ.1).OR.(IDSEC.EQ.8)) NTW = NTW-1
                        IF (IDSEC.EQ.1) NTCW = NTCW-1
                     ENDIF
                     GOTO 20
                  ENDIF
               ELSEIF (IICH(IDSEC).EQ.-1) THEN
c    neg. particles: decrease energy by Coulomb-potential
                  PSEC(4) = PSEC(4)-ETACOU(IPOT)
                  JPMOD = 1
               ENDIF
            ENDIF

   25       CONTINUE

            IF (PSEC(4).LT.AMSEC) THEN
               IF (IOULEV(6).GT.0)
     &            WRITE(ErrorOut,2001) I,IDSEC,PSEC(4),AMSEC
 2001          FORMAT(1X,'KKINC: PARTICLE AT DTEVT1-POS. ',I5,
     &                ' IS NOT ALLOWED TO ESCAPE NUCLEUS',/,
     &                8X,'ID : ',I3,'   REDUCED ENERGY: ',E15.4,
     &                '   MASS: ',E12.3)
               ISTHKK(I) = 14+IPOT
               IF (ISTHKK(I).EQ.15) THEN
                  DO 28 K=1,4
                     PHKK(K,I) = PSEC0(K)
                     TRCLPR(K) = TRCLPR(K)+PSEC0(K)
   28             CONTINUE
                  IF ((IDSEC.EQ.1).OR.(IDSEC.EQ.8)) NPW = NPW-1
                  IF (IDSEC.EQ.1) NPCW = NPCW-1
               ELSEIF (ISTHKK(I).EQ.16) THEN
                  DO 29 K=1,4
                     PHKK(K,I) = PSEC0(K)
                     TRCLTA(K) = TRCLTA(K)+PSEC0(K)
   29             CONTINUE
                  IF ((IDSEC.EQ.1).OR.(IDSEC.EQ.8)) NTW = NTW-1
                  IF (IDSEC.EQ.1) NTCW = NTCW-1
               ENDIF
               GOTO 20
            ENDIF

            IF (JPMOD.EQ.1) THEN
               PSECN  = SQRT( (PSEC(4)-AMSEC)*(PSEC(4)+AMSEC) )
c 4-momentum after correction for nuclear potential
               DO 22 K=1,3
                  PSEC(K) = PSEC(K)*PSECN/PSECO
   22          CONTINUE

c store recoil momentum from particles escaping the nuclear potentials
               DO 30 K=1,4
                  IF (IPOT.EQ.1) THEN
                     TRCLPR(K) = TRCLPR(K)+PSEC0(K)-PSEC(K)
                  ELSEIF (IPOT.EQ.2) THEN
                     TRCLTA(K) = TRCLTA(K)+PSEC0(K)-PSEC(K)
                  ENDIF
   30          CONTINUE

c transform momentum back into n-n cms
               IMODE = IPOT+1
               CALL DT_LTRANS(PSEC(1),PSEC(2),PSEC(3),PSEC(4),
     &                     PHKK(1,I),PHKK(2,I),PHKK(3,I),PHKK(4,I),
     &                     IDSEC,IMODE)
            ENDIF

         ENDIF

   23    CONTINUE
         DO 31 K=1,4
            PFSP(K) = PFSP(K)+PHKK(K,I)
   31    CONTINUE

   20 CONTINUE

      DO 33 I=NPOINT(4),NHKK
         IF ((ISTHKK(I).EQ.1).AND.(IDXOTH(I).LT.0)) THEN
            PFSP(1) = PFSP(1)+PHKK(1,I)
            PFSP(2) = PFSP(2)+PHKK(2,I)
            PFSP(3) = PFSP(3)+PHKK(3,I)
            PFSP(4) = PFSP(4)+PHKK(4,I)
         ENDIF
   33 CONTINUE

      DO 34 K=1,5
         PRCLPR(K) = TRCLPR(K)
         PRCLTA(K) = TRCLTA(K)
   34 CONTINUE

      IF ((IP.EQ.1).AND.(IT.GT.1).AND.LFERMI) THEN
c hadron-nucleus interactions: get residual momentum from energy-
c momentum conservation
         DO 32 K=1,4
            PRCLPR(K) = ZERO
            PRCLTA(K) = PINIPR(K)+PINITA(K)-PFSP(K)
   32    CONTINUE
      ELSE
c nucleus-hadron, nucleus-nucleus: get residual momentum from
c accumulated recoil momenta of particles leaving the spectators
c   transform accumulated recoil momenta of residual nuclei into
c   n-n cms
         PZI = PRCLPR(3)
         PEI = PRCLPR(4)
         CALL DT_LTNUC(PZI,PEI,PRCLPR(3),PRCLPR(4),2)
         PZI = PRCLTA(3)
         PEI = PRCLTA(4)
         CALL DT_LTNUC(PZI,PEI,PRCLTA(3),PRCLTA(4),3)
C        IF (IP.GT.1) THEN
            PRCLPR(3) = PRCLPR(3)+PINIPR(3)
            PRCLPR(4) = PRCLPR(4)+PINIPR(4)
C        ENDIF
         IF (IT.GT.1) THEN
            PRCLTA(3) = PRCLTA(3)+PINITA(3)
            PRCLTA(4) = PRCLTA(4)+PINITA(4)
         ENDIF
      ENDIF

c check momenta of residual nuclei
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(-PINIPR(1),-PINIPR(2),-PINIPR(3),-PINIPR(4),
     &               1,IDUM,IDUM)
         CALL DT_EVTEMC(-PINITA(1),-PINITA(2),-PINITA(3),-PINITA(4),
     &               2,IDUM,IDUM)
         CALL DT_EVTEMC(PRCLPR(1),PRCLPR(2),PRCLPR(3),PRCLPR(4),
     &               2,IDUM,IDUM)
         CALL DT_EVTEMC(PRCLTA(1),PRCLTA(2),PRCLTA(3),PRCLTA(4),
     &               2,IDUM,IDUM)
         CALL DT_EVTEMC(PFSP(1),PFSP(2),PFSP(3),PFSP(4),2,IDUM,IDUM)
c*sr 19.12. changed to avoid output when used with phojet
C        CHKLEV = TINY3
         CHKLEV = TINY1
         CALL DT_EVTEMC(DUM,DUM,DUM,CHKLEV,-1,501,IREJ1)
C        IF ((NEVHKK.EQ.409).OR.(NEVHKK.EQ.460).OR.(NEVHKK.EQ.765))
C    &      CALL DT_EVTOUT(4)
         IF (IREJ1.GT.0) RETURN
      ENDIF

      RETURN
      END
c
c===scn4ba=============================================================*
c
CDECK  ID>, DT_SCN4BA
      SUBROUTINE DT_SCN4BA

c***********************************************************************
c SCan /DTEVT1/ 4 BAryons which are not able to escape nuclear pot.    *
c This version dated 12.12.95 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY3=1.0D-3,TINY2=1.0D-2,
     &           TINY10=1.0D-10)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c treatment of residual nuclei: wounded nucleons
      COMMON /DTWOUN/ NPW,NPW0,NPCW,NTW,NTW0,NTCW,IPW(210),ITW(210)

c treatment of residual nuclei: 4-momenta
      LOGICAL LRCLPR,LRCLTA
      COMMON /DTRNU1/ PINIPR(5),PINITA(5),PRCLPR(5),PRCLTA(5),
     &                TRCLPR(5),TRCLTA(5),LRCLPR,LRCLTA


      DIMENSION PLAB(2,5),PCMS(4)

      IREJ = 0

c get number of wounded nucleons
      NPW    = 0
      NPW0   = 0
      NPCW   = 0
      NPSTCK = 0
      NTW    = 0
      NTW0   = 0
      NTCW   = 0
      NTSTCK = 0

      ISGLPR = 0
      ISGLTA = 0
      LRCLPR = .FALSE.
      LRCLTA = .FALSE.

C     DO 2 I=1,NHKK
      DO 2 I=1,NPOINT(1)
c projectile nucleons wounded in primary interaction and in fzc
         IF ((ISTHKK(I).EQ.11).OR.(ISTHKK(I).EQ.17)) THEN
            NPW      = NPW+1
            IPW(NPW) = I
            NPSTCK   = NPSTCK+1
            IF (IDHKK(I).EQ.2212) NPCW = NPCW+1
            IF (ISTHKK(I).EQ.11)  NPW0 = NPW0+1
C           IF (IP.GT.1) THEN
               DO 5 K=1,4
                  TRCLPR(K) = TRCLPR(K)-PHKK(K,I)
    5          CONTINUE
C           ENDIF
c target nucleons wounded in primary interaction and in fzc
         ELSEIF ((ISTHKK(I).EQ.12).OR.(ISTHKK(I).EQ.18)) THEN
            NTW      = NTW+1
            ITW(NTW) = I
            NTSTCK   = NTSTCK+1
            IF (IDHKK(I).EQ.2212) NTCW = NTCW+1
            IF (ISTHKK(I).EQ.12)  NTW0 = NTW0+1
            IF (IT.GT.1) THEN
               DO 6 K=1,4
                  TRCLTA(K) = TRCLTA(K)-PHKK(K,I)
    6          CONTINUE
            ENDIF
         ELSEIF (ISTHKK(I).EQ.13) THEN
            ISGLPR = I
         ELSEIF (ISTHKK(I).EQ.14) THEN
            ISGLTA = I
         ENDIF
    2 CONTINUE

      DO 11 I=NPOINT(4),NHKK
c baryons which are unable to escape the nuclear potential of proj.
         IF (ISTHKK(I).EQ.15) THEN
            ISGLPR = I
            NPSTCK = NPSTCK-1
            IF (IIBAR(IDBAM(I)).NE.0) THEN
               NPW    = NPW-1
               IF (IICH(IDBAM(I)).GT.0) NPCW = NPCW-1
            ENDIF
            DO 7 K=1,4
               TRCLPR(K) = TRCLPR(K)+PHKK(K,I)
    7       CONTINUE
c baryons which are unable to escape the nuclear potential of targ.
         ELSEIF (ISTHKK(I).EQ.16) THEN
            ISGLTA = I
            NTSTCK = NTSTCK-1
            IF (IIBAR(IDBAM(I)).NE.0) THEN
               NTW    = NTW-1
               IF (IICH(IDBAM(I)).GT.0) NTCW = NTCW-1
            ENDIF
            DO 8 K=1,4
               TRCLTA(K) = TRCLTA(K)+PHKK(K,I)
    8       CONTINUE
         ENDIF
   11 CONTINUE

c residual nuclei so far
      IRESP = IP-NPSTCK
      IREST = IT-NTSTCK

c ckeck for "residual nuclei" consisting of one nucleon only
c treat it as final state particle
      IF (IRESP.EQ.1) THEN
         ID  = IDBAM(ISGLPR)
         IST = ISTHKK(ISGLPR)
         CALL DT_LTRANS(PHKK(1,ISGLPR),PHKK(2,ISGLPR),
     &               PHKK(3,ISGLPR),PHKK(4,ISGLPR),
     &               PCMS(1),PCMS(2),PCMS(3),PCMS(4),ID,2)
         IF (IST.EQ.13) THEN
            ISTHKK(ISGLPR) = 11
         ELSE
            ISTHKK(ISGLPR) = 2
         ENDIF
         CALL DT_EVTPUT(1,IDHKK(ISGLPR),ISGLPR,0,
     &               PCMS(1),PCMS(2),PCMS(3),PCMS(4),
     &               IDRES(ISGLPR),IDXRES(ISGLPR),IDCH(ISGLPR))
         NOBAM(NHKK)      = NOBAM(ISGLPR)
         JDAHKK(1,ISGLPR) = NHKK
         DO 21 K=1,4
            TRCLPR(K) = TRCLPR(K)-PHKK(K,ISGLPR)
   21    CONTINUE
      ENDIF
      IF (IREST.EQ.1) THEN
         ID  = IDBAM(ISGLTA)
         IST = ISTHKK(ISGLTA)
         CALL DT_LTRANS(PHKK(1,ISGLTA),PHKK(2,ISGLTA),
     &               PHKK(3,ISGLTA),PHKK(4,ISGLTA),
     &               PCMS(1),PCMS(2),PCMS(3),PCMS(4),ID,3)
         IF (IST.EQ.14) THEN
            ISTHKK(ISGLTA) = 12
         ELSE
            ISTHKK(ISGLTA) = 2
         ENDIF
         CALL DT_EVTPUT(1,IDHKK(ISGLTA),ISGLTA,0,
     &               PCMS(1),PCMS(2),PCMS(3),PCMS(4),
     &               IDRES(ISGLTA),IDXRES(ISGLTA),IDCH(ISGLTA))
         NOBAM(NHKK)      = NOBAM(ISGLTA)
         JDAHKK(1,ISGLTA) = NHKK
         DO 22 K=1,4
            TRCLTA(K) = TRCLTA(K)-PHKK(K,ISGLTA)
   22    CONTINUE
      ENDIF

c get nuclear potential corresp. to the residual nucleus
      IPRCL  = IP -NPW
      IPZRCL = IPZ-NPCW
      ITRCL  = IT -NTW
      ITZRCL = ITZ-NTCW
      CALL DT_NCLPOT(IPZRCL,IPRCL,ITZRCL,ITRCL,ZERO,ZERO,1)

c baryons unable to escape the nuclear potential are treated as
c excited nucleons (ISTHKK=15,16)
      DO 3 I=NPOINT(4),NHKK
         IF (ISTHKK(I).EQ.1) THEN
            ID  = IDBAM(I)
            IF ( ((ID.EQ.1).OR.(ID.EQ.8)).AND.(NOBAM(I).NE.3) ) THEN
c   final state n and p not being outside of both nuclei are considered
               NPOTP = 1
               NPOTT = 1
               IF ( (IP.GT.1)      .AND.(IRESP.GT.1).AND.
     &              (NOBAM(I).NE.1).AND.(NPW.GT.0)        ) THEN
c     Lorentz-trsf. into proj. rest sys. for those being inside proj.
                  CALL DT_LTRANS(PHKK(1,I),PHKK(2,I),PHKK(3,I),
     &                        PHKK(4,I),PLAB(1,1),PLAB(1,2),PLAB(1,3),
     &                        PLAB(1,4),ID,-2)
                  PLABT = SQRT(PLAB(1,1)**2+PLAB(1,2)**2+PLAB(1,3)**2)
                  PLAB(1,5) = SQRT(ABS( (PLAB(1,4)-PLABT)*
     &                                  (PLAB(1,4)+PLABT) ))
                  EKIN = PLAB(1,4)-PLAB(1,5)
                  IF (EKIN.LE.EPOT(1,ID)) NPOTP = 15
                  IF ((ID.EQ.1).AND.(NPCW.LE.0)) NPOTP = 1
               ENDIF
               IF ( (IT.GT.1)      .AND.(IREST.GT.1).AND.
     &              (NOBAM(I).NE.2).AND.(NTW.GT.0)        ) THEN
c     Lorentz-trsf. into targ. rest sys. for those being inside targ.
                  CALL DT_LTRANS(PHKK(1,I),PHKK(2,I),PHKK(3,I),
     &                        PHKK(4,I),PLAB(2,1),PLAB(2,2),PLAB(2,3),
     &                        PLAB(2,4),ID,-3)
                  PLABT = SQRT(PLAB(2,1)**2+PLAB(2,2)**2+PLAB(2,3)**2)
                  PLAB(2,5) = SQRT(ABS( (PLAB(2,4)-PLABT)*
     &                                  (PLAB(2,4)+PLABT) ))
                  EKIN = PLAB(2,4)-PLAB(2,5)
                  IF (EKIN.LE.EPOT(2,ID)) NPOTT = 16
                  IF ((ID.EQ.1).AND.(NTCW.LE.0)) NPOTT = 1
               ENDIF
               IF (PHKK(3,I).GE.ZERO) THEN
                  ISTHKK(I) = NPOTT
                  IF (NPOTP.NE.1) ISTHKK(I) = NPOTP
               ELSE
                  ISTHKK(I) = NPOTP
                  IF (NPOTT.NE.1) ISTHKK(I) = NPOTT
               ENDIF
               IF (ISTHKK(I).NE.1) THEN
                  J = ISTHKK(I)-14
                  DO 4 K=1,5
                     PHKK(K,I) = PLAB(J,K)
    4             CONTINUE
                  IF (ISTHKK(I).EQ.15) THEN
                     NPW = NPW-1
                     IF (ID.EQ.1) NPCW = NPCW-1
                     DO 9 K=1,4
                        TRCLPR(K) = TRCLPR(K)+PHKK(K,I)
    9                CONTINUE
                  ELSEIF (ISTHKK(I).EQ.16) THEN
                     NTW = NTW-1
                     IF (ID.EQ.1) NTCW = NTCW-1
                     DO 10 K=1,4
                        TRCLTA(K) = TRCLTA(K)+PHKK(K,I)
   10                CONTINUE
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
    3 CONTINUE

c again: get nuclear potential corresp. to the residual nucleus
      IPRCL  = IP -NPW
      IPZRCL = IPZ-NPCW
      ITRCL  = IT -NTW
      ITZRCL = ITZ-NTCW
c      AFERP = 1.2D0*FERMOD*(ONE+(DBLE(IP+10-NPW0)/DBLE(IP+10))**1.1D0)
cC     AFERP = 1.21D0*FERMOD*(ONE+(DBLE(IP+40-NPW0)/DBLE(IP+40))**1.1D0)
c     &             *(0.94D0+0.3D0*EXP(-DBLE(NPW0)/5.0D0)) /2.0D0
C     AFERP = 0.0D0
c      AFERT = 1.2D0*FERMOD*(ONE+(DBLE(IT+10-NTW0)/DBLE(IT+10))**1.1D0)
cC     AFERT = 1.21D0*FERMOD*(ONE+(DBLE(IT+40-NTW0)/DBLE(IT+40))**1.1D0)
c     &             *(0.94D0+0.3D0*EXP(-DBLE(NTW0)/5.0D0)) /2.0D0
C     AFERT = 0.0D0
C     IF (AFERP.LT.FERMOD) AFERP = FERMOD+0.1
C     IF (AFERT.LT.FERMOD) AFERT = FERMOD+0.1
C     IF (AFERP.GT.0.85D0) AFERP = 0.85D0
C     IF (AFERT.GT.0.85D0) AFERT = 0.85D0
      AFERP = FERMOD+0.1D0
      AFERT = FERMOD+0.1D0

      CALL DT_NCLPOT(IPZRCL,IPRCL,ITZRCL,ITRCL,AFERP,AFERT,1)

      RETURN
      END
c
c===ficonf=============================================================*
c
CDECK  ID>, DT_FICONF
      SUBROUTINE DT_FICONF(IJPROJ,IP,IPZ,IT,ITZ,NLOOP,IREJ)

c***********************************************************************
c Treatment of FInal CONFiguration including evaporation, fission and  *
c Fermi-break-up (for light nuclei only).                              *
c Adopted from the original routine FINALE and extended to residual    *
c projectile nuclei.                                                   *
c This version dated 12.12.95 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY3=1.0D-3,TINY10=1.0D-10)
      PARAMETER (ANGLGB=5.0D-16)
      PARAMETER (AMUAMU=0.93149432D0,AMELEC=0.51099906D-3)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c central particle production, impact parameter biasing
      COMMON /DTIMPA/ BIMIN,BIMAX,XSFRAC,ICENTR

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c treatment of residual nuclei: 4-momenta
      LOGICAL LRCLPR,LRCLTA
      COMMON /DTRNU1/ PINIPR(5),PINITA(5),PRCLPR(5),PRCLTA(5),
     &                TRCLPR(5),TRCLTA(5),LRCLPR,LRCLTA

c treatment of residual nuclei: properties of residual nuclei
      COMMON /DTRNU2/ AMRCL0(2),EEXC(2),EEXCFI(2),
     &                NTOT(2),NPRO(2),NN(2),NH(2),NHPOS(2),NQ(2),
     &                NTOTFI(2),NPROFI(2)

c statistics: residual nuclei
      COMMON /DTSTA2/ EXCDPM(4),EXCEVA(2),
     &                NINCGE,NINCCO(2,3),NINCHR(2,2),NINCWO(2),
     &                NINCST(2,4),NINCEV(2),
     &                NRESTO(2),NRESPR(2),NRESNU(2),NRESBA(2),
     &                NRESPB(2),NRESCH(2),NRESEV(4),
     &                NEVA(2,6),NEVAGA(2),NEVAHT(2),NEVAHY(2,2,240),
     &                NEVAFI(2,2)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c (original name: FINUC)
      PARAMETER (MXP=999)
      COMMON /FKFINU/ CXR    (MXP), CYR    (MXP), CZR    (MXP),
     &                CXRPOL (MXP), CYRPOL (MXP), CZRPOL (MXP),
     &                TKI    (MXP), PLR    (MXP), WEI    (MXP),
     &                TV, TVCMS, TVRECL, TVHEAV, TVBIND, NP0, NP,
     &                KPART  (MXP)

c (original name: RESNUC)
      LOGICAL LRNFSS, LFRAGM
      COMMON /FKRESN/  AMNTAR, AMMTAR, AMNZM1, AMMZM1, AMNNM1, AMMNM1,
     &                   ANOW,   ZNOW, ANCOLL, ZNCOLL, AMMLFT, AMNLFT,
     &                   ERES,  EKRES, AMNRES, AMMRES,  PTRES,  PXRES,
     &                  PYRES,  PZRES, PTRES2,  KTARP,  KTARN, IGREYP,
     &                 IGREYN, IPREEH, IPRDEU, IPRTRI, IPR3HE, IPR4HE,
     &                  ICRES,  IBRES, ISTRES, IEVAPL, IEVAPH, IEVNEU,
     &                 IEVPRO, IEVDEU, IEVTRI, IEV3HE, IEV4HE, IDEEXG,
     &                  IBTAR, ICHTAR, IBLEFT, ICLEFT, IOTHER, LRNFSS,
     &                 LFRAGM

      COMMON /FKNDAT/ AV0WEL,     APFRMX,     AEFRMX,     AEFRMA,
     &                RDSNUC,     V0WELL (2), PFRMMX (2), EFRMMX (2),
     &                EFRMAV (2), AMNUCL (2), AMNUSQ (2), EBNDNG (2),
     &                VEFFNU (2), ESLOPE (2), PKMNNU (2), EKMNNU (2),
     &                PKMXNU (2), EKMXNU (2), EKMNAV (2), EKINAV (2),
     &                EXMNAV (2), EKUPNU (2), EXMNNU (2), EXUPNU (2),
     &                ERCLAV (2), ESWELL (2), FINCUP (2), AMRCAV    ,
     &                AMRCSQ    , ATO1O3    , ZTO1O3    , ELBNDE (0:100)

c (original name: PAREVT)
      LOGICAL LDIFFR, LINCTV, LEVPRT, LHEAVY, LDEEXG, LGDHPR, LPREEX,
     &        LHLFIX, LPRFIX, LPARWV, LPOWER, LSNGCH, LLVMOD, LSCHDF
      PARAMETER ( NALLWP = 39   )
      COMMON /FKPARE/ DPOWER, FSPRD0, FSHPFN, RN1GSC, RN2GSC,
     &                LDIFFR (NALLWP),LPOWER, LINCTV, LEVPRT, LHEAVY,
     &                LDEEXG, LGDHPR, LPREEX, LHLFIX, LPRFIX, LPARWV,
     &                ILVMOD, JLVMOD, LLVMOD, LSNGCH, LSCHDF

c event flag
      COMMON /DTEVNO/ NEVENT,ICASCA


      DIMENSION INUC(2),IDXPAR(2),IDPAR(2),AIF(2),AIZF(2),AMRCL(2),
     &          PRCL(2,4),MO1(2),MO2(2),VRCL(2,4),WRCL(2,4),
     &          P1IN(4),P2IN(4),P1OUT(4),P2OUT(4)

      DIMENSION EXPNUC(2),EXC(2,210),NEXC(2,210)
      DATA EXC,NEXC /420*ZERO,420*0/
      DATA EXPNUC /4.0D-3,4.0D-3/

      IREJ   = 0
      LRCLPR = .FALSE.
      LRCLTA = .FALSE.

c skip residual nucleus treatment if not requested or in case
c of central collisions
      IF ((.NOT.LEVPRT).OR.(ICENTR.GT.0).OR.(ICENTR.EQ.-1)) RETURN

      DO 1 K=1,2
         IDPAR(K) = 0
         IDXPAR(K)= 0
         NTOT(K)  = 0
         NTOTFI(K)= 0
         NPRO(K)  = 0
         NPROFI(K)= 0
         NN(K)    = 0
         NH(K)    = 0
         NHPOS(K) = 0
         NQ(K)    = 0
         EEXC(K)  = ZERO
         MO1(K)   = 0
         MO2(K)   = 0
         DO 2 I=1,4
            VRCL(K,I) = ZERO
            WRCL(K,I) = ZERO
    2    CONTINUE
    1 CONTINUE
      NFSP = 0
      INUC(1) = IP
      INUC(2) = IT

      DO 3 I=1,NHKK

c number of final state particles
         IF (ABS(ISTHKK(I)).EQ.1) THEN
            NFSP  = NFSP+1
            IDFSP = IDBAM(I)
         ENDIF

c properties of remaining nucleon configurations
         KF = 0
         IF ((ISTHKK(I).EQ.13).OR.(ISTHKK(I).EQ.15)) KF = 1
         IF ((ISTHKK(I).EQ.14).OR.(ISTHKK(I).EQ.16)) KF = 2
         IF (KF.GT.0) THEN
            IF (MO1(KF).EQ.0) MO1(KF) = I
            MO2(KF)  = I
c   position of residual nucleus = average position of nucleons
            DO 4 K=1,4
               VRCL(KF,K) = VRCL(KF,K)+VHKK(K,I)
               WRCL(KF,K) = WRCL(KF,K)+WHKK(K,I)
    4       CONTINUE
c   total number of particles contributing to each residual nucleus
            NTOT(KF)  = NTOT(KF)+1
            IDTMP     = IDBAM(I)
            IDXTMP    = I
c   total charge of residual nuclei
            NQ(KF) = NQ(KF)+IICH(IDTMP)
c   number of protons
            IF (IDHKK(I).EQ.2212) THEN
               NPRO(KF) = NPRO(KF)+1
c   number of neutrons
            ELSEIF (IDHKK(I).EQ.2112) THEN
               NN(KF) = NN(KF)+1
            ELSE
c   number of baryons other than n, p
               IF (IIBAR(IDTMP).EQ.1) THEN
                  NH(KF) = NH(KF)+1
                  IF (IICH(IDTMP).EQ.1) NHPOS(KF) = NHPOS(KF)+1
               ELSE
c   any other mesons (status set to 1)
C                 WRITE(LOUT,1002) KF,IDTMP
C1002             FORMAT(1X,'FICONF:   residual nucleus ',I2,
C    &                   ' containing meson ',I4,', status set to 1')
                  ISTHKK(I) = 1
                  IDTMP     = IDPAR(KF)
                  IDXTMP    = IDXPAR(KF)
                  NTOT(KF)  = NTOT(KF)-1
               ENDIF
            ENDIF
            IDPAR(KF)  = IDTMP
            IDXPAR(KF) = IDXTMP
         ENDIF
    3 CONTINUE

c reject elastic events (def: one final state particle = projectile)
      IF ((IP.EQ.1).AND.(NFSP.EQ.1).AND.(IDFSP.EQ.IJPROJ)) THEN
         IREXCI(3) = IREXCI(3)+1
         GOTO 9999
C        RETURN
      ENDIF

c check if one nucleus disappeared..
C     IF ((IP.GT.1).AND.(NTOT(1).EQ.0).AND.(NTOT(2).NE.0)) THEN
C        DO 5 K=1,4
C           PRCLTA(K) = PRCLTA(K)+PRCLPR(K)
C           PRCLPR(K) = ZERO
C   5    CONTINUE
C     ELSEIF ((IT.GT.1).AND.(NTOT(2).EQ.0).AND.(NTOT(1).NE.0)) THEN
C        DO 6 K=1,4
C           PRCLPR(K) = PRCLPR(K)+PRCLTA(K)
C           PRCLTA(K) = ZERO
C   6    CONTINUE
C     ENDIF

      ICOR   = 0
      INORCL = 0
      DO 7 I=1,2
         DO 8 K=1,4
c get the average of the nucleon positions
            VRCL(I,K) = VRCL(I,K)/MAX(NTOT(I),1)
            WRCL(I,K) = WRCL(I,K)/MAX(NTOT(I),1)
            IF (I.EQ.1) PRCL(1,K) = PRCLPR(K)
            IF (I.EQ.2) PRCL(2,K) = PRCLTA(K)
    8    CONTINUE
c mass number and charge of residual nuclei
         AIF(I)  = DBLE(NTOT(I))
         AIZF(I) = DBLE(NPRO(I)+NHPOS(I))
         IF (NTOT(I).GT.1) THEN
c masses of residual nuclei in ground state
            AMRCL0(I) = AIF(I)*AMUAMU+1.0D-3*DT_ENERGY(AIF(I),AIZF(I))
c masses of residual nuclei
            PTORCL   = SQRT(PRCL(I,1)**2+PRCL(I,2)**2+PRCL(I,3)**2)
            AMRCL(I) = (PRCL(I,4)-PTORCL)*(PRCL(I,4)+PTORCL)
            IF (AMRCL(I).GT.ZERO) AMRCL(I) = SQRT(AMRCL(I))
            IF (AMRCL(I).LE.ZERO) THEN
               IF (IOULEV(3).GT.0)
     &            WRITE(ErrorOut,
     * 1000) I,PRCL(I,1),PRCL(I,2),PRCL(I,3),
     &                             PRCL(I,4),NTOT
 1000          FORMAT(1X,'WARNING! NEGATIVE EXCITATION ENERGY',/,
     &                I4,4E15.4,2I4)
               AMRCL(I) = ZERO
               EEXC(I)  = ZERO
               IF (NLOOP.LE.500) THEN
                  GOTO 9998
               ELSE
                  IREXCI(2) = IREXCI(2)+1
                  GOTO 9999
               ENDIF
            ELSEIF ((AMRCL(I).GT.ZERO).AND.(AMRCL(I).LT.AMRCL0(I)))
     &                                                         THEN
c*sr
C              WRITE(6,*) NEVHKK,I,NTOT(1),NTOT(2),AMRCL(I),AMRCL0(I)
c*
c*sr 3.3
C              AMRCL(I) = AMRCL0(I)+EXPNUC(I)*DBLE(NTOT(I))
               M = MIN(NTOT(I),210)
               IF (NEXC(I,M).GT.0) THEN
                  AMRCL(I) = AMRCL0(I)+EXC(I,M)/DBLE(NEXC(I,M))
               ELSE
   70             CONTINUE
                  M = M+1
                  IF (M.GE.INUC(I)) THEN
                     AMRCL(I) = AMRCL0(I)+EXPNUC(I)*DBLE(NTOT(I))
                  ELSE
                     IF (NEXC(I,M).GT.0) THEN
                        AMRCL(I) = AMRCL0(I)+EXC(I,M)/DBLE(NEXC(I,M))
                     ELSE
                        GOTO 70
                     ENDIF
                  ENDIF
               ENDIF
c*
               EEXC(I)  = AMRCL(I)-AMRCL0(I)
               ICOR     = ICOR+I
            ELSE
c excitation energies of residual nuclei
               EEXC(I)   = AMRCL(I)-AMRCL0(I)
               IF (ICASCA.EQ.0) THEN
c*sr 15.1.
C                 EXPNUC(I) = EEXC(I)/DBLE(NTOT(I))
                  EXPNUC(I) = EEXC(I)/MAX(1,INUC(I)-NTOT(I))
                  M = MIN(NTOT(I),210)
                  EXC(I,M)  = EXC(I,M)+EEXC(I)
                  NEXC(I,M) = NEXC(I,M)+1
               ENDIF
            ENDIF
         ELSEIF (NTOT(I).EQ.1) THEN
            WRITE(ErrorOut,1003) I
 1003       FORMAT(1X,'FICONF:   WARNING! NTOT(I)=1? (I=',I3,')')
            GOTO 9999
         ELSE
            AMRCL0(I) = ZERO
            AMRCL(I)  = ZERO
            EEXC(I)   = ZERO
            INORCL    = INORCL+I
         ENDIF
    7 CONTINUE

      PRCLPR(5) = AMRCL(1)
      PRCLTA(5) = AMRCL(2)

      IF (ICOR.GT.0) THEN
         IF (INORCL.EQ.0) THEN
c one or both residual nuclei consist of one nucleon only, transform
c this nucleon on mass shell
            DO 9 K=1,4
               P1IN(K) = PRCL(1,K)
               P2IN(K) = PRCL(2,K)
    9       CONTINUE
            XM1 = AMRCL(1)
            XM2 = AMRCL(2)
            CALL DT_MASHEL(P1IN,P2IN,XM1,XM2,P1OUT,P2OUT,IREJ1)
            IF (IREJ1.GT.0) THEN
               WRITE(ErrorOut,*) 'ficonf-mashel rejection'
               GOTO 9999
            ENDIF
            DO 10 K=1,4
               PRCL(1,K) = P1OUT(K)
               PRCL(2,K) = P2OUT(K)
               PRCLPR(K) = P1OUT(K)
               PRCLTA(K) = P2OUT(K)
   10       CONTINUE
            PRCLPR(5) = AMRCL(1)
            PRCLTA(5) = AMRCL(2)
         ELSE
            IF (IOULEV(3).GT.0)
     &      WRITE(ErrorOut,
     * 1001) NEVHKK,INT(AIF(1)),INT(AIZF(1)),
     &                       INT(AIF(2)),INT(AIZF(2)),AMRCL0(1),
     &                       AMRCL(1),AMRCL(1)-AMRCL0(1),AMRCL0(2),
     &                       AMRCL(2),AMRCL(2)-AMRCL0(2)
 1001       FORMAT(1X,'FICONF:   WARNING! NO RESIDUAL NUCLEUS FOR',
     &             ' CORRECTION',/,11X,'AT EVENT',I8,
     &             ',  NUCLEON CONFIG. 1:',2I4,' 2:',2I4,
     &             2(/,11X,3E12.3))
            IF (NLOOP.LE.500) THEN
               GOTO 9998
            ELSE
               IREXCI(1) = IREXCI(1)+1
            ENDIF
         ENDIF
      ENDIF

c update counter
C     IF (NRESEV(1).NE.NEVHKK) THEN
C        NRESEV(1) = NEVHKK
C        NRESEV(2) = NRESEV(2)+1
C     ENDIF
      NRESEV(2) = NRESEV(2)+1
      DO 15 I=1,2
         EXCDPM(I)   = EXCDPM(I)+EEXC(I)
         EXCDPM(I+2) = EXCDPM(I+2)+(EEXC(I)/MAX(NTOT(I),1))
         NRESTO(I) = NRESTO(I)+NTOT(I)
         NRESPR(I) = NRESPR(I)+NPRO(I)
         NRESNU(I) = NRESNU(I)+NN(I)
         NRESBA(I) = NRESBA(I)+NH(I)
         NRESPB(I) = NRESPB(I)+NHPOS(I)
         NRESCH(I) = NRESCH(I)+NQ(I)
   15 CONTINUE

c evaporation
      IF (LEVPRT) THEN
         DO 13 I=1,2
c initialize evaporation counter
            NP = 0
            EEXCFI(I) = ZERO
            IF ((INUC(I).GT.1).AND.(AIF(I).GT.ONE).AND.
     &          (EEXC(I).GT.ZERO)) THEN
c put residual nuclei into DTEVT1
               IDRCL = 80000
               JMASS = INT( AIF(I))
               JCHAR = INT(AIZF(I))
               CALL DT_EVTPUT(1000,IDRCL,MO1(I),MO2(I),PRCL(I,1),
     &              PRCL(I,2),PRCL(I,3),PRCL(I,4),JMASS,JCHAR,0)
c*sr 22.6.97
               NOBAM(NHKK) = I
c*
               DO 14 J=1,4
                  VHKK(J,NHKK) = VRCL(I,J)
                  WHKK(J,NHKK) = WRCL(I,J)
   14          CONTINUE
c  interface to evaporation module - fill final residual nucleus into
c  common FKRESN
               PXRES  = PRCL(I,1)
               PYRES  = PRCL(I,2)
               PZRES  = PRCL(I,3)
               IBRES  = NPRO(I)+NN(I)+NH(I)
               ICRES  = NPRO(I)+NHPOS(I)
               ANOW   = DBLE(IBRES)
               ZNOW   = DBLE(ICRES)
               PTRES  = SQRT(PXRES**2+PYRES**2+PZRES**2)
c   ground state mass of the residual nucleus (should be equal to AM0T)
               AMMRES = AMRCL0(I)
               AMNRES = AMMRES-ZNOW*AMELEC+ELBNDE(ICRES)
c  common FKFINU
               TV = ZERO
c   kinetic energy of residual nucleus
               TVRECL = PRCL(I,4)-AMRCL(I)
c   excitation energy of residual nucleus
               TVCMS  = EEXC(I)
               PTOLD  = PTRES
               PTRES  = SQRT(ABS(TVRECL*(TVRECL+2.0D0*(AMMRES+TVCMS))))
               IF (PTOLD.LT.ANGLGB) THEN
                  CALL DT_RACO(PXRES,PYRES,PZRES)
                  PTOLD = ONE
               ENDIF
               PXRES = PXRES*PTRES/PTOLD
               PYRES = PYRES*PTRES/PTOLD
               PZRES = PZRES*PTRES/PTOLD
c evaporation
               WE = ONE
               CALL DT_EVEVAP(WE)
c put evaporated particles and residual nuclei to DTEVT1
               MO = NHKK
               CALL DT_EVA2HE(MO,EXCITF,I,IREJ1)
               EEXCFI(I) = EXCITF
               EXCEVA(I) = EXCEVA(I)+EXCITF
            ENDIF
   13    CONTINUE
      ENDIF

      RETURN

C9998 IREXCI(1) = IREXCI(1)+1
 9998 IREJ   = IREJ+1
 9999 CONTINUE
      LRCLPR = .TRUE.
      LRCLTA = .TRUE.
      IREJ   = IREJ+1
      RETURN
      END
c                                                                      *
c====eva2he============================================================*
c                                                                      *
CDECK  ID>, DT_EVA2HE
      SUBROUTINE DT_EVA2HE(MO,EEXCF,IRCL,IREJ)

c***********************************************************************
c Interface between common's of evaporation module (FKFINU,FKFHVY)     *
c and DTEVT1.                                                          *
c    MO    DTEVT1-index of "mother" (residual) nucleus before evap.    *
c    EEXCF exitation energy of residual nucleus after evaporation      *
c    IRCL  = 1 projectile residual nucleus                             *
c          = 2 target     residual nucleus                             *
c This version dated 19.04.95 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY3=1.0D-3)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c Note: DTEVT2 - special use for heavy fragments !
c       (IDRES(I) = mass number, IDXRES(I) = charge)
c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c statistics: residual nuclei
      COMMON /DTSTA2/ EXCDPM(4),EXCEVA(2),
     &                NINCGE,NINCCO(2,3),NINCHR(2,2),NINCWO(2),
     &                NINCST(2,4),NINCEV(2),
     &                NRESTO(2),NRESPR(2),NRESNU(2),NRESBA(2),
     &                NRESPB(2),NRESCH(2),NRESEV(4),
     &                NEVA(2,6),NEVAGA(2),NEVAHT(2),NEVAHY(2,2,240),
     &                NEVAFI(2,2)

c treatment of residual nuclei: properties of residual nuclei
      COMMON /DTRNU2/ AMRCL0(2),EEXC(2),EEXCFI(2),
     &                NTOT(2),NPRO(2),NN(2),NH(2),NHPOS(2),NQ(2),
     &                NTOTFI(2),NPROFI(2)

c (original name: FINUC)
      PARAMETER (MXP=999)
      COMMON /FKFINU/ CXR    (MXP), CYR    (MXP), CZR    (MXP),
     &                CXRPOL (MXP), CYRPOL (MXP), CZRPOL (MXP),
     &                TKI    (MXP), PLR    (MXP), WEI    (MXP),
     &                TV, TVCMS, TVRECL, TVHEAV, TVBIND, NP0, NP,
     &                KPART  (MXP)

c (original name: FHEAVY,FHEAVC)
      PARAMETER ( MXHEAV = 100 )
      CHARACTER*8 ANHEAV
      COMMON /FKFHVY/ CXHEAV (MXHEAV), CYHEAV (MXHEAV),
     &                CZHEAV (MXHEAV), TKHEAV (MXHEAV),
     &                PHEAVY (MXHEAV), WHEAVY (MXHEAV),
     &                AMHEAV  ( 12 ) , AMNHEA  ( 12 ) ,
     &                KHEAVY (MXHEAV), ICHEAV  ( 12 ) ,
     &                IBHEAV  ( 12 ) , NPHEAV
      COMMON /FKFHVC/ ANHEAV  ( 12 )

c (original name: RESNUC)
      LOGICAL LRNFSS, LFRAGM
      COMMON /FKRESN/  AMNTAR, AMMTAR, AMNZM1, AMMZM1, AMNNM1, AMMNM1,
     &                   ANOW,   ZNOW, ANCOLL, ZNCOLL, AMMLFT, AMNLFT,
     &                   ERES,  EKRES, AMNRES, AMMRES,  PTRES,  PXRES,
     &                  PYRES,  PZRES, PTRES2,  KTARP,  KTARN, IGREYP,
     &                 IGREYN, IPREEH, IPRDEU, IPRTRI, IPR3HE, IPR4HE,
     &                  ICRES,  IBRES, ISTRES, IEVAPL, IEVAPH, IEVNEU,
     &                 IEVPRO, IEVDEU, IEVTRI, IEV3HE, IEV4HE, IDEEXG,
     &                  IBTAR, ICHTAR, IBLEFT, ICLEFT, IOTHER, LRNFSS,
     &                 LFRAGM


      DIMENSION IPTOKP(39)
      DATA IPTOKP / 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
     & 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 99,
     & 100, 101, 97, 102, 98, 103, 109, 115 /

      IREJ = 0

c skip if evaporation package is not included
      IF (.NOT.LEVAPO) RETURN

c update counter
      IF (NRESEV(3).NE.NEVHKK) THEN
         NRESEV(3) = NEVHKK
         NRESEV(4) = NRESEV(4)+1
      ENDIF

      IF (LEMCCK)
     &   CALL DT_EVTEMC(PHKK(1,MO),PHKK(2,MO),PHKK(3,MO),PHKK(4,MO),1,
     &                                                   IDUM,IDUM)
c mass number/charge of residual nucleus before evaporation
      IBTOT = IDRES(MO)
      IZTOT = IDXRES(MO)

c protons/neutrons/gammas
      DO 1 I=1,NP
         PX    = CXR(I)*PLR(I)
         PY    = CYR(I)*PLR(I)
         PZ    = CZR(I)*PLR(I)
         ID    = IPTOKP(KPART(I))
         IDPDG = IDT_IPDGHA(ID)
         AM    = ((PLR(I)+TKI(I))*(PLR(I)-TKI(I)))/
     &           (2.0D0*MAX(TKI(I),TINY10))
         IF (ABS(AM-AAM(ID)).GT.TINY3) THEN
            WRITE(ErrorOut,1000) ID,AM,AAM(ID)
 1000       FORMAT(1X,'EVA2HE:  INCONSISTENT MASS OF EVAP. ',
     &             'PARTICLE',I3,2E10.3)
         ENDIF
         PE = TKI(I)+AM
         CALL DT_EVTPUT(-1,IDPDG,MO,0,PX,PY,PZ,PE,0,0,0)
         NOBAM(NHKK) = IRCL
         IF (LEMCCK) CALL DT_EVTEMC(-PX,-PY,-PZ,-PE,2,IDUM,IDUM)
         IBTOT = IBTOT-IIBAR(ID)
         IZTOT = IZTOT-IICH(ID)
    1 CONTINUE

c heavy fragments
      DO 2 I=1,NPHEAV
         PX     = CXHEAV(I)*PHEAVY(I)
         PY     = CYHEAV(I)*PHEAVY(I)
         PZ     = CZHEAV(I)*PHEAVY(I)
         IDHEAV = 80000
         AM     = ((PHEAVY(I)+TKHEAV(I))*(PHEAVY(I)-TKHEAV(I)))/
     &            (2.0D0*MAX(TKHEAV(I),TINY10))
         PE     = TKHEAV(I)+AM
         CALL DT_EVTPUT(-1,IDHEAV,MO,0,PX,PY,PZ,PE,
     &                  IBHEAV(KHEAVY(I)),ICHEAV(KHEAVY(I)),0)
         NOBAM(NHKK) = IRCL
         IF (LEMCCK) CALL DT_EVTEMC(-PX,-PY,-PZ,-PE,2,IDUM,IDUM)
         IBTOT = IBTOT-IBHEAV(KHEAVY(I))
         IZTOT = IZTOT-ICHEAV(KHEAVY(I))
    2 CONTINUE

      IF (IBRES.GT.0) THEN
c residual nucleus after evaporation
         IDNUC = 80000
         CALL DT_EVTPUT(1001,IDNUC,MO,0,PXRES,PYRES,PZRES,ERES,
     &                                        IBRES,ICRES,0)
         NOBAM(NHKK) = IRCL
      ENDIF
      EEXCF = TVCMS
      NTOTFI(IRCL) = IBRES
      NPROFI(IRCL) = ICRES
      IF (LEMCCK) CALL DT_EVTEMC(-PXRES,-PYRES,-PZRES,-ERES,2,IDUM,IDUM)
      IBTOT = IBTOT-IBRES
      IZTOT = IZTOT-ICRES

c count events with fission
      NEVAFI(1,IRCL) = NEVAFI(1,IRCL)+1
      IF (LRNFSS) NEVAFI(2,IRCL) = NEVAFI(2,IRCL)+1

c energy-momentum conservation check
      IF (LEMCCK) CALL DT_EVTEMC(DUM,DUM,DUM,DUM,5,40,IREJ)
C     IF (IREJ.GT.0) THEN
C        CALL DT_EVTOUT(4)
C        WRITE(*,*) EEXC(2),EEXCFI(2),NP,NPHEAV
C     ENDIF
c baryon-number/charge conservation check
      IF (IBTOT+IZTOT.NE.0) THEN
         WRITE(ErrorOut,1001) NEVHKK,IBTOT,IZTOT
 1001    FORMAT(1X,'EVA2HE:   BARYON-NUMBER/CHARGE CONSERVATION ',
     &          'FAILURE AT EVENT ',I8,' :  IBTOT,IZTOT = ',2I3)
      ENDIF

      RETURN
      END
c
c===ebind==============================================================*
c
CDECK  ID>, DT_EBIND
      DOUBLE PRECISION FUNCTION DT_EBIND(IA,IZ)

c***********************************************************************
c Binding energy for nuclei.                                           *
c (Shirokov & Yudin, Yad. Fizika, Nauka, Moskva 1972)                  *
c                 IA        mass number                                *
c                 IZ        atomic number                              *
c This version dated 5.5.95   is updated by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0)

      DATA       A1,       A2,        A3,        A4,      A5
     &     / 0.01575D0, 0.0178D0, 0.000710D0, 0.0237D0, 0.034D0/

      IF ((IA.LE.1).OR.(IZ.EQ.0)) THEN
         WRITE(ErrorOut,
     * '(1X,A,2I5)') 'DT_EBIND IA,IZ set EBIND=0.  ',IA,IZ
         DT_EBIND = ZERO
         RETURN
      ENDIF
      AA = IA
      DT_EBIND = A1*AA - A2*AA**0.666667D0-A3*IZ*IZ*AA**(-0.333333D0)
     &        -A4*(IA-2*IZ)**2/AA
      IF (MOD(IA,2).EQ.1) THEN
         IA5 = 0
      ELSEIF (MOD(IZ,2).EQ.1) THEN
         IA5 = 1
      ELSE
         IA5 = -1
      ENDIF
      DT_EBIND = DT_EBIND - IA5*A5*AA**(-0.75D0)

      RETURN
      END

c*sr 30.6. routine replaced completely
c$ CREATE DT_ENERGY.FOR
cCOPY DT_ENERGY
c                                                                      *
c=== energy ===========================================================*
c                                                                      *
CDECK  ID>, DT_ENERGY
      DOUBLE PRECISION FUNCTION DT_ENERGY( A, Z )

C     INCLUDE '(DBLPRC)'
c$ CREATE DBLPRC.ADD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
c (original name: GLOBAL)
      PARAMETER ( KALGNM = 2 )
      PARAMETER ( ANGLGB = 5.0D-16 )
      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AXCSSV = 0.2D+16 )
      PARAMETER ( ANDRFL = 1.0D-38 )
      PARAMETER ( AVRFLW = 1.0D+38 )
      PARAMETER ( AINFNT = 1.0D+30 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( EINFNT = +69.07755278982137 D+00 )
      PARAMETER ( EZRZRZ = -69.07755278982137 D+00 )
      PARAMETER ( EXCSSV = +35.23192357547063 D+00 )
      PARAMETER ( ENGLGB = -35.23192357547063 D+00 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( CSNNRM = 2.0D-15 )
      PARAMETER ( DMXTRN = 1.0D+08 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( THRTHR = 3.D+00 )
      PARAMETER ( FOUFOU = 4.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( SIXSIX = 6.D+00 )
      PARAMETER ( SEVSEV = 7.D+00 )
      PARAMETER ( EIGEIG = 8.D+00 )
      PARAMETER ( ANINEN = 9.D+00 )
      PARAMETER ( TENTEN = 10.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )
      PARAMETER ( ONETHI = ONEONE / THRTHR )
      PARAMETER ( TWOTHI = TWOTWO / THRTHR )
      PARAMETER ( ONEFOU = ONEONE / FOUFOU )
      PARAMETER ( THRTWO = THRTHR / TWOTWO )
      PARAMETER ( PIPIPI = 3.141592653589793238462643383279D+00 )
      PARAMETER ( TWOPIP = 6.283185307179586476925286766559D+00 )
      PARAMETER ( PIP5O2 = 7.853981633974483096156608458199D+00 )
      PARAMETER ( PIPISQ = 9.869604401089358618834490999876D+00 )
      PARAMETER ( PIHALF = 1.570796326794896619231321691640D+00 )
      PARAMETER ( ERFA00 = 0.886226925452758013649083741671D+00 )
      PARAMETER ( SQTWPI = 2.506628274631000502415765284811D+00 )
      PARAMETER ( EULERO = 0.577215664901532860606512      D+00 )
      PARAMETER ( EULEXP = 1.781072417990197985236504      D+00 )
      PARAMETER ( EULLOG =-0.5495393129816448223376619     D+00 )
      PARAMETER ( E1M2EU = 0.8569023337737540831433017     D+00 )
      PARAMETER ( ENEPER = 2.718281828459045235360287471353D+00 )
      PARAMETER ( SQRENT = 1.648721270700128146848650787814D+00 )
      PARAMETER ( SQRTWO = 1.414213562373095048801688724210D+00 )
      PARAMETER ( SQRTHR = 1.732050807568877293527446341506D+00 )
      PARAMETER ( SQRFIV = 2.236067977499789696409173668731D+00 )
      PARAMETER ( SQRSIX = 2.449489742783178098197284074706D+00 )
      PARAMETER ( SQRSEV = 2.645751311064590590501615753639D+00 )
      PARAMETER ( SQRT12 = 3.464101615137754587054892683012D+00 )
      PARAMETER ( CLIGHT = 2.99792458         D+10 )
      PARAMETER ( AVOGAD = 6.0221367          D+23 )
      PARAMETER ( BOLTZM = 1.380658           D-23 )
      PARAMETER ( AMELGR = 9.1093897          D-28 )
      PARAMETER ( PLCKBR = 1.05457266         D-27 )
      PARAMETER ( ELCCGS = 4.8032068          D-10 )
      PARAMETER ( ELCMKS = 1.60217733         D-19 )
      PARAMETER ( AMUGRM = 1.6605402          D-24 )
      PARAMETER ( AMMUMU = 0.113428913        D+00 )
      PARAMETER ( AMPRMU = 1.007276470        D+00 )
      PARAMETER ( AMNEMU = 1.008664904        D+00 )
      PARAMETER ( ALPFSC = 7.2973530791728595 D-03 )
      PARAMETER ( FSCTO2 = 5.3251361962113614 D-05 )
      PARAMETER ( FSCTO3 = 3.8859399018437826 D-07 )
      PARAMETER ( FSCTO4 = 2.8357075508200407 D-09 )
      PARAMETER ( PLABRC = 0.197327053        D+00 )
      PARAMETER ( AMELCT = 0.51099906         D-03 )
      PARAMETER ( AMUGEV = 0.93149432         D+00 )
      PARAMETER ( AMMUON = 0.105658389        D+00 )
      PARAMETER ( AMPRTN = 0.93827231         D+00 )
      PARAMETER ( AMNTRN = 0.93956563         D+00 )
      PARAMETER ( AMDEUT = 1.87561339         D+00 )
      PARAMETER ( COUGFM = ELCCGS * ELCCGS / ELCMKS * 1.D-07 * 1.D+13
     &                   * 1.D-09 )
      PARAMETER ( RCLSEL = 2.8179409183694872 D-13 )
      PARAMETER ( BLTZMN = 8.617385           D-14 )
      PARAMETER ( A0BOHR = PLABRC / ALPFSC / AMELCT )
      PARAMETER ( GFOHB3 = 1.16639            D-05 )
      PARAMETER ( GFERMI = GFOHB3 * PLABRC * PLABRC * PLABRC )
      PARAMETER ( SIN2TW = 0.2319             D+00 )
      PARAMETER ( GEVMEV = 1.0                D+03 )
      PARAMETER ( EMVGEV = 1.0                D-03 )
      PARAMETER ( ALGVMV = 6.90775527898214   D+00 )
      PARAMETER ( RADDEG = 180.D+00 / PIPIPI )
      PARAMETER ( DEGRAD = PIPIPI / 180.D+00 )
      LOGICAL LGBIAS, LGBANA
      COMMON /FKGLOB/ LGBIAS, LGBANA

C     INCLUDE '(DIMPAR)'
c$ CREATE DIMPAR.ADD
      PARAMETER ( MXXRGN = 5000 )
      PARAMETER ( MXXMDF = 82   )
      PARAMETER ( MXXMDE = 54   )
      PARAMETER ( MFSTCK = 1000 )
      PARAMETER ( MESTCK = 100  )
      PARAMETER ( NALLWP = 39   )
      PARAMETER ( NELEMX = 80   )
      PARAMETER ( MPDPDX = 8    )
      PARAMETER ( ICOMAX = 180  )
      PARAMETER ( NSTBIS = 304  )
      PARAMETER ( IDMAXP = 220  )
      PARAMETER ( IDMXDC = 640  )
      PARAMETER ( MKBMX1 = 1    )
      PARAMETER ( MKBMX2 = 1    )
C     INCLUDE '(IOUNIT)'
c$ CREATE IOUNIT.ADD
      PARAMETER ( LUNIN  =  5 )
      PARAMETER ( LUNOUT =  6 )
c*sr 19.5. set error output-unit from 15 to 6
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( LUNBER = 14 )
      PARAMETER ( LUNECH =  8 )
      PARAMETER ( LUNFLU = 13 )
      PARAMETER ( LUNGEO = 16 )
      PARAMETER ( LUNPMF = 12 )
      PARAMETER ( LUNRAN =  2 )
      PARAMETER ( LUNXSC =  9 )
      PARAMETER ( LUNDET = 17 )
      PARAMETER ( LUNRAY = 10 )
      PARAMETER ( LUNRDB =  1 )
      PARAMETER ( LUNPGO =  7 )
      PARAMETER ( LUNPGS =  4 )
      PARAMETER ( LUNSCR =  3 )
c
c----------------------------------------------------------------------*
c                                                                      *
c     Revised version of the original routine from EVAP:               *
c                                                                      *
c     Created on   15 may 1990     by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 19-sep-95     by    Alfredo Ferrari               *
c                                                                      *
c     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!     *
c     !!!  It is supposed to be used with the updated atomic   !!!     *
c     !!!                    mass data file                    !!!     *
c     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!     *
c                                                                      *
c----------------------------------------------------------------------*
c
c  Mass number below which "unknown" isotopes out of the Z-interval
c  reported in the mass tabulations are completely unstable and made
c  up by Z proton masses + N neutron masses:
      PARAMETER ( KAFREE =  4 )
c  Mass number below which "unknown" isotopes out of the Z-interval
c  reported in the mass tabulations are supposed to be particle unstable
      PARAMETER ( KAPUNS = 12 )
c  Minimum energy required for particle unstable isotopes
      PARAMETER ( DEPUNS = 0.5D+00 )
c
c (original name: EVA0)
      COMMON /FKEVA0/ Y0, B0, P0 (1001), P1 (1001), P2 (1001),
     *                FLA (6), FLZ (6), RHO (6), OMEGA (6), EXMASS (6),
     *                CAM2 (130), CAM3 (200), CAM4 (130), CAM5 (200),
     *                T (4,7), RMASS (297), ALPH (297), BET (297),
     *                APRIME (250), IA (6), IZ (6)

c (original name: ISOTOP)
      PARAMETER ( NAMSMX = 270 )
      PARAMETER ( NZGVAX =  15 )
      PARAMETER ( NISMMX = 574 )
      COMMON /FKISOT/ WAPS   (NAMSMX,NZGVAX),  T12NUC (NAMSMX,NZGVAX),
     &                WAPISM (NISMMX), T12ISM (NISMMX),
     &                ABUISO (NSTBIS), ASTLIN (2,100), ZSTLIN (2,260),
     &                AMSSST (100)  , ISOMNM (NSTBIS), ISONDX (2,100),
     &                JSPNUC (NAMSMX,NZGVAX), JPTNUC (NAMSMX,NZGVAX),
     &                INWAPS (NAMSMX), JSPISM (NISMMX),
     &                JPTISM (NISMMX), IZWISM (NISMMX),
     &                INWISM (0:NAMSMX)

c
      SAVE KA0, KZ0, IZ0
      DATA KA0, KZ0, IZ0 / -1, -1, -1 /
c
      IFLAG = 1
      GO TO 10
c======================================================================*
c                                                                      *
c     Entry ENergy - KNOWn                                             *
c                                                                      *
c======================================================================*
      ENTRY DT_ENKNOW ( A, Z, IZZ0 )
      IZZ0  =-1
      IFLAG = 2
   10 CONTINUE
c
      KA0 = NINT ( A )
      KZ0 = NINT ( Z )
      N   = KA0 - KZ0
c  +-------------------------------------------------------------------*
c  |  Null residual nucleus:
      IF ( KA0 .EQ. 0 .AND. KZ0 .LE. 0 ) THEN
         IF ( IFLAG .EQ. 1 ) THEN
            DT_ENERGY = ZERZER
         ELSE
            DT_ENKNOW = ZERZER
            IZZ0   = -1
         END IF
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |  Only protons:
      ELSE IF ( N .LE. 0 ) THEN
         IF ( N .LT. 0 ) THEN
            WRITE ( ErrorOut, * )
     &     ' DPMJET STOPPED IN ENERGY: MASS NUMBER =< ATOMIC NUMBER !!',
     &       KA0, KZ0
            WRITE ( ErrorOut, * )
     &     ' DPMJET STOPPED IN ENERGY: MASS NUMBER =< ATOMIC NUMBER !!',
     &       KA0, KZ0
               WRITE ( 77, * )
     &  ' ^^^DPMJET STOPPED IN ENERGY: MASS NUMBER =< ATOMIC NUMBER !!',
     &       KA0, KZ0
            STOP 'DT_ENERGY:KA0-KZ0'
         END IF
         IZ0    = -1
         IF ( IFLAG .EQ. 1 ) THEN
            DT_ENERGY = Z * WAPS ( 1, 2 )
         ELSE
            DT_ENKNOW = Z * WAPS ( 1, 2 )
            IZZ0   = -1
         END IF
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |  Only neutrons:
      ELSE IF ( KZ0 .LE. 0 ) THEN
         IF ( KZ0 .LT. 0 ) THEN
            WRITE ( ErrorOut, * )
     &   ' DPMJET STOPPED IN ENERGY: NEGATIVE ATOMIC NUMBER !!',KA0,KZ0
            WRITE ( ErrorOut, * )
     &   ' DPMJET STOPPED IN ENERGY: NEGATIVE ATOMIC NUMBER !!',KA0,KZ0
            WRITE ( 77, * )
     &' ^^^DPMJET STOPPED IN ENERGY: NEGATIVE ATOMIC NUMBER !!',KA0,KZ0
            STOP 'DT_ENERGY:KZ0<0'
         END IF
         IZ0    = -1
         IF ( IFLAG .EQ. 1 ) THEN
            DT_ENERGY = A * WAPS ( 1, 1 )
         ELSE
            DT_ENKNOW = A * WAPS ( 1, 1 )
            IZZ0   = -1
         END IF
         RETURN
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  No actual nucleus
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  A larger than maximum allowed:
      IF ( KA0 .GT. NAMSMX ) THEN
         IZ0    = -1
         IF ( IFLAG .EQ. 1 ) THEN
            DT_ENERGY = DT_ENRG( A, Z )
         ELSE
            DT_ENKNOW = DT_ENRG( A, Z )
            IZZ0   = -1
         END IF
         RETURN
      END IF
c  |
c  +-------------------------------------------------------------------*
      IZZ = INWAPS ( KA0 )
c  +-------------------------------------------------------------------*
c  |  Too much neutron rich with respect to the stability line:
      IF ( KZ0 .LT. IZZ ) THEN
c  |  +----------------------------------------------------------------*
c  |  |  Up to A=Kafree all "bound" masses are known, set it unbound:
         IF ( KA0 .LE. KAFREE ) THEN
            DT_ENERGY = AINFNT
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Up to Kapuns: be sure it is particle unstable
         ELSE IF ( KA0 .LE. KAPUNS ) THEN
c  |  |  Exp. excess mass for A,IZZ
            ENEEXP = WAPS ( KA0, 1 )
c  |  |  Cameron excess mass for A, IZZ
            ENECA1 = DT_ENRG( A, DBLE (IZZ) )
c  |  |  Cameron excess mass for A, Z
            DT_ENERGY = DT_ENRG( A, Z )
c  |  |  Use just the difference according to Cameron!!!
            DT_ENERGY = ENEEXP + DT_ENERGY - ENECA1
            JZZ    = INWAPS ( KA0 - 1 )
            LZZ    = INWAPS ( KA0 - 2 )
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Residual mass for n-decay known:
            IF ( KZ0 .GE. JZZ .AND. KZ0 .LE. JZZ + NZGVAX - 1 ) THEN
               IZ0    = KZ0 - JZZ + 1
               DT_ENERGY = MAX(DT_ENERGY,WAPS (KA0-1,IZ0) + WAPS (1,1)
     &                      + DEPUNS )
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Residual mass for 2n-decay known:
            ELSE IF ( KZ0 .GE. LZZ .AND. KZ0 .LE. LZZ + NZGVAX - 1 )THEN
               IZ0    = KZ0 - LZZ + 1
               DT_ENERGY = MAX ( DT_ENERGY, WAPS (KA0-2,IZ0) + TWOTWO *
     &                      ( WAPS (1,1) + DEPUNS ) )
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Set it unbound:
            ELSE
               DT_ENERGY = AINFNT
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Proceed as usual:
         ELSE
c  |  |  Exp. excess mass for A,IZZ
            ENEEXP = WAPS ( KA0, 1 )
c  |  |  Cameron excess mass for A, IZZ
            ENECA1 = DT_ENRG( A, DBLE (IZZ) )
c  |  |  Cameron excess mass for A, Z
            DT_ENERGY = DT_ENRG( A, Z )
c  |  |  Use just the difference according to Cameron!!!
            DT_ENERGY = ENEEXP + DT_ENERGY - ENECA1
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |  Be sure not to have a positive energy state:
         DT_ENERGY = MIN(DT_ENERGY,(A-Z) * WAPS (1,1) + Z * WAPS (1,2) )
         IZ0    = -1
         IF ( IFLAG .EQ. 2 ) THEN
            DT_ENKNOW = DT_ENERGY
            IZZ0   = -1
         END IF
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |  Too much proton rich with respect to the stability line:
      ELSE IF ( KZ0 .GT. IZZ + NZGVAX - 1 ) THEN
c  |  +----------------------------------------------------------------*
c  |  |  Up to A=Kafree all "bound" masses are known, set it unbound:
         IF ( KA0 .LE. KAFREE ) THEN
            DT_ENERGY = AINFNT
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Up to Kapuns: be sure it is particle unstable
         ELSE IF ( KA0 .LE. KAPUNS ) THEN
c  |  |  Exp. excess mass for A,IZZ+NZGVAX-1
            ENEEXP = WAPS ( KA0, NZGVAX )
c  |  |  Cameron excess mass for A, IZZ+NZGVAX-1
            ENECA1 = DT_ENRG( A, DBLE (IZZ+NZGVAX-1) )
c  |  |  Cameron excess mass for A, Z
            DT_ENERGY = DT_ENRG( A, Z )
c  |  |  Use just the difference according to Cameron!!!
            DT_ENERGY = ENEEXP + DT_ENERGY - ENECA1
            JZZ    = INWAPS ( KA0 - 1 )
            LZZ    = INWAPS ( KA0 - 2 )
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Residual mass for p-decay known:
            IF ( KZ0-1 .GE. JZZ .AND. KZ0-1 .LE. JZZ + NZGVAX - 1 ) THEN
               IZ0    = KZ0 - 1 - JZZ + 1
               DT_ENERGY = MAX (DT_ENERGY, WAPS (KA0-1,IZ0) + WAPS (1,2)
     &                      + DEPUNS )
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Residual mass for 2p-decay known:
            ELSE IF ( KZ0-2 .GE. LZZ .AND. KZ0-2 .LE. LZZ + NZGVAX - 1 )
     &         THEN
               IZ0    = KZ0 - 2 - LZZ + 1
               DT_ENERGY = MAX ( DT_ENERGY, WAPS (KA0-2,IZ0) + TWOTWO *
     &                      ( WAPS (1,2) + DEPUNS ) )
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Set it unbound:
            ELSE
               DT_ENERGY = AINFNT
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  Proceed as usual:
         ELSE
c  |  |  Exp. excess mass for A,IZZ+NZGVAX-1
            ENEEXP = WAPS ( KA0, NZGVAX )
c  |  |  Cameron excess mass for A, IZZ+NZGVAX-1
            ENECA1 = DT_ENRG( A, DBLE (IZZ+NZGVAX-1) )
c  |  |  Cameron excess mass for A, Z
            DT_ENERGY = DT_ENRG( A, Z )
c  |  |  Use just the difference according to Cameron!!!
            DT_ENERGY = ENEEXP + DT_ENERGY - ENECA1
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |  Be sure not to have a positive energy state:
         DT_ENERGY = MIN(DT_ENERGY,(A-Z) * WAPS (1,1) + Z * WAPS (1,2) )
         IZ0    = -1
         IF ( IFLAG .EQ. 2 ) THEN
            DT_ENKNOW = DT_ENERGY
            IZZ0   = -1
         END IF
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |  Known isotope or anyway isotope "inside" the stability zone
      ELSE
         IZ0    = KZ0 - IZZ + 1
         DT_ENERGY = WAPS ( KA0, IZ0 )
         IF ( IFLAG .EQ. 2 ) IZZ0 = IZ0
c  |  +----------------------------------------------------------------*
c  |  |  Mass not known
         IF ( ABS (DT_ENERGY) .LT. ANGLGB .AND. (KA0 .NE. 12 .OR. KZ0
     &        .NE. 6) ) THEN
            IF ( IFLAG .EQ. 2 ) IZZ0 = -1
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Set it unbound:
            IF ( KA0 .LE. KAFREE ) THEN
               DT_ENERGY = AINFNT
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Try to get a reasonable excess mass:
            ELSE
               JZ0 = -100
c  |  |  |  +----------------------------------------------------------*
c  |  |  |  |  Check the closest one known:
               DO 500 JZZ = 1, NZGVAX
                  IF ( ABS ( WAPS (KA0,JZZ) ) .GT. ANGLGB .AND.
     &                 ABS (JZZ-IZ0) .LT. ABS (JZ0-IZ0) ) JZ0 = JZZ
                  IF ( ABS (JZ0-IZ0) .EQ. 1 ) GO TO 550
  500          CONTINUE
c  |  |  |  |
c  |  |  |  +----------------------------------------------------------*
  550          CONTINUE
c  |  |  |  Exp. excess mass for A,IZZ+JZ0-1
               ENEEXP = WAPS ( KA0, JZ0 )
c  |  |  |  Cameron excess mass for A, IZZ+JZ0-1
               ENECA1 = DT_ENRG( A, DBLE (IZZ+JZ0-1) )
c  |  |  |  Cameron excess mass for A, Z
               DT_ENERGY = DT_ENRG( A, Z )
c  |  |  |  Use just the difference according to Cameron!!!
               DT_ENERGY = ENEEXP + DT_ENERGY - ENECA1
               IZ0    = -1
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  Be sure not to have a positive energy state:
            DT_ENERGY = MIN(DT_ENERGY,(A-Z)*WAPS(1,1)+Z*WAPS (1,2) )
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
         IF ( IFLAG .EQ. 2 ) DT_ENKNOW = DT_ENERGY
         RETURN
      END IF
c  |
c  +-------------------------------------------------------------------*
c=== End of Function Energy ===========================================*
c     RETURN
      END
#endif
