#include "Zcondc.h"
#if USEDPMJET == 1
c
c    +-------------------------------------------------------------+
c    |                                                             |
c    |                                                             |
c    |                        DPMJET 3.0                           |
c    |                                                             |
c    |                                                             |
c    |         S. Roesler+), R. Engel#), J. Ranft*)                |
c    |                                                             |
c    |         +) SLAC, M.S.48, P.O.Box 4349                       |
c    |            Stanford, CA 94309, USA                          |
c    |            Email: Stefan.Roesler@cern.ch                    |
c    |                                                             |
c    |         #) University of Delaware, BRI                      |
c    |            Newark, DE 19716, USA                            |
c    |                                                             |
c    |         *) University of Siegen, Dept. of Physics           |
c    |            D-57068 Siegen, Germany                          |
c    |                                                             |
c    |                                                             |
c    |       http://home.cern.ch/sroesler/dpmjet3.html             |
c    |                                                             |
c    |                                                             |
c    |       Monte Carlo models used for event generation:         |
c    |          PHOJET 1.12, JETSET 7.4 and LEPTO 6.5.1            |
c    |                                                             |
c    +-------------------------------------------------------------+
c
c
c===init===============================================================*
c
CDECK  ID>, DT_INIT
      SUBROUTINE DT_INIT(NCASES,EPN,NPMASS,NPCHAR,NTMASS,NTCHAR,
     &                                             IDP,IGLAU)

c***********************************************************************
c Initialization of event generation                                   *
c This version dated  7.4.98  is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER (LIN=5,LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c names of hadrons used in input-cards
      CHARACTER*8 BTYPE
      COMMON /DTPAIN/ BTYPE(30)

c (original name: PAREVT)
      LOGICAL LDIFFR, LINCTV, LEVPRT, LHEAVY, LDEEXG, LGDHPR, LPREEX,
     &        LHLFIX, LPRFIX, LPARWV, LPOWER, LSNGCH, LLVMOD, LSCHDF
      PARAMETER ( NALLWP = 39   )
      COMMON /FKPARE/ DPOWER, FSPRD0, FSHPFN, RN1GSC, RN2GSC,
     &                LDIFFR (NALLWP),LPOWER, LINCTV, LEVPRT, LHEAVY,
     &                LDEEXG, LGDHPR, LPREEX, LHLFIX, LPRFIX, LPARWV,
     &                ILVMOD, JLVMOD, LLVMOD, LSNGCH, LSCHDF

c (original name: INPFLG)
      COMMON /FKINPF/ IANG,IFISS,IB0,IGEOM,ISTRAG,KEYDK

c (original name: FRBKCM)
      PARAMETER ( MXFFBK =     6 )
      PARAMETER ( MXZFBK =     9 )
      PARAMETER ( MXNFBK =    10 )
      PARAMETER ( MXAFBK =    16 )
      PARAMETER ( NXZFBK = MXZFBK + MXFFBK / 3 )
      PARAMETER ( NXNFBK = MXNFBK + MXFFBK / 3 )
      PARAMETER ( NXAFBK = MXAFBK + 1 )
      PARAMETER ( MXPSST =   300 )
      PARAMETER ( MXPSFB = 41000 )
      LOGICAL LFRMBK, LNCMSS
      COMMON /FKFRBK/  AMUFBK, EEXFBK (MXPSST), AMFRBK (MXPSST),
     &          EXFRBK (MXPSFB), SDMFBK (MXPSFB), COUFBK (MXPSFB),
     &          EXMXFB, R0FRBK, R0CFBK, C1CFBK, C2CFBK,
     &          IFRBKN (MXPSST), IFRBKZ (MXPSST),
     &          IFBKSP (MXPSST), IFBKPR (MXPSST), IFBKST (MXPSST),
     &          IPSIND (0:MXNFBK,0:MXZFBK,2), JPSIND (0:MXAFBK),
     &          IFBIND (0:NXNFBK,0:NXZFBK,2), JFBIND (0:NXAFBK),
     &          IFBCHA (5,MXPSFB), IPOSST, IPOSFB, IFBSTF,
     &          IFBFRB, NBUFBK, LFRMBK, LNCMSS

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c interface HADRIN-DPM
      COMMON /HNTHRE/ EHADTH,EHADLO,EHADHI,INTHAD,IDXTA

c central particle production, impact parameter biasing
      COMMON /DTIMPA/ BIMIN,BIMAX,XSFRAC,ICENTR

c parameter for intranuclear cascade
      LOGICAL LPAULI
      COMMON /DTFOTI/ TAUFOR,KTAUGE,ITAUVE,INCMOD,LPAULI

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT

c threshold values for x-sampling (DTUNUC 1.x)
      COMMON /DTXCUT/ XSEACU,UNON,UNOM,UNOSEA,CVQ,CDQ,CSEA,SSMIMA,
     &                SSMIMQ,VVMTHR

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c n-n cross section fluctuations
      PARAMETER (NBINS = 1000)
      COMMON /DTXSFL/ FLUIXX(NBINS),IFLUCT

c flags for particle decays
      COMMON /DTFRPA/ MSTUX(20),PARUX(20),MSTJX(20),PARJX(20),
     &                IMSTU(20),IPARU(20),IMSTJ(20),IPARJ(20),
     &                NMSTU,NPARU,NMSTJ,NPARJ,PDB,PDBSEA(3),ISIG0,IPI0

c diquark-breaking mechanism
      COMMON /DTDIQB/ DBRKR(3,8),DBRKA(3,8),CHAM1,CHAM3,CHAB1,CHAB3

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c parameters for hA-diffraction
      COMMON /DTDIHA/ DIBETA,DIALPH

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c kinematical cuts for lepton-nucleus interactions
      COMMON /DTLCUT/ ECMIN,ECMAX,XBJMIN,ELMIN,EGMIN,EGMAX,YMIN,YMAX,
     &                Q2MIN,Q2MAX,THMIN,THMAX,Q2LI,Q2HI,ECMLI,ECMHI

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD

c cuts for variable energy runs
      COMMON /DTVARE/ VARELO,VAREHI,VARCLO,VARCHI

c flags for activated histograms
      COMMON /DTHIS3/ IHISPP(50),IHISXS(50),IXSTBL


      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)



      COMMON/PYDAT3/MDCY(500,3),MDME(4000,2),BRAT(4000),KFDP(4000,5)


c LEPTO
c*LUND single / double precision
      REAL CUT,PARL,TMPX,TMPY,TMPW2,TMPQ2,TMPU
      COMMON /LEPTOU/ CUT(14),LST(40),PARL(30),
     &                TMPX,TMPY,TMPW2,TMPQ2,TMPU

c LEPTO
      REAL RPPN
      COMMON /LEPTOI/ RPPN,LEPIN,INTER

c steering flags for qel neutrino scattering modules
      COMMON /QNEUTO/ DSIGSU,DSIGMC,NDSIG,NEUTYP,NEUDEC



      INTEGER PYCOMP


C     DIMENSION XPARA(5)
      DIMENSION XDUMB(40),IPRANG(5)

      PARAMETER (MXCARD=58)
      CHARACTER*78 CLINE,CTITLE
      CHARACTER*60 CWHAT
      CHARACTER*8  BLANK,SDUM
      CHARACTER*10 CODE,CODEWD
      CHARACTER*72 HEADER
      LOGICAL LSTART,LEINP,LXSTAB
      DIMENSION WHAT(6),CODE(MXCARD)
      DATA CODE/
     &   'TITLE     ','PROJPAR   ','TARPAR    ','ENERGY    ',
     &   'MOMENTUM  ','CMENERGY  ','EMULSION  ','FERMI     ',
     &   'TAUFOR    ','PAULI     ','COULOMB   ','HADRIN    ',
     &   'EVAP      ','EMCCHECK  ','MODEL     ','PHOINPUT  ',
     &   'GLAUBERI  ','FLUCTUAT  ','CENTRAL   ','RECOMBIN  ',
     &   'COMBIJET  ','XCUTS     ','INTPT     ','CRONINPT  ',
     &   'SEADISTR  ','SEASU3    ','DIQUARKS  ','RESONANC  ',
     &   'DIFFRACT  ','SINGLECH  ','NOFRAGME  ','HADRONIZE ',
     &   'POPCORN   ','PARDECAY  ','BEAM      ','LUND-MSTU ',
     &   'LUND-MSTJ ','LUND-MDCY ','LUND-PARJ ','LUND-PARU ',
     &   'OUTLEVEL  ','FRAME     ','L-TAG     ','L-ETAG    ',
     &   'ECMS-CUT  ','VDM-PAR1  ','HISTOGRAM ','XS-TABLE  ',
     &   'GLAUB-PAR ','GLAUB-INI ','VDM-PAR2  ','XS-QELPRO ',
     &   'RNDMINIT  ','LEPTO-CUT ','LEPTO-LST ','LEPTO-PARL',
     &   'START     ','STOP      '/
      DATA BLANK /'        '/

      DATA LSTART,LXSTAB,IFIRST /.TRUE.,.FALSE.,1/
      DATA CMEOLD /0.0D0/

c---------------------------------------------------------------------
c at the first call of INIT: initialize event generation
      IF (LSTART) THEN
         CALL DT_TITLE
c   initialization and test of the random number generator
         CALL DT_RNDMST(22,54,76,92)
         CALL DT_RNDMTE(1)
c   initialization of BAMJET, DECAY and HADRIN
         CALL DT_DDATAR
         CALL DT_DHADDE
         CALL DT_DCHANT
         CALL DT_DCHANH
c   set default values for input variables
         CALL DT_DEFAUL(EPN,PPN)
         IGLAU  = 0
         IXSQEL = 0
c   flag for collision energy input
         LEINP  = .FALSE.
         LSTART = .FALSE.
      ENDIF

c---------------------------------------------------------------------
   10 CONTINUE

c read control card from input-unit LIN
      READ(TempDev,'(A78)',END=9999) CLINE
      IF (CLINE(1:1).EQ.'*') THEN
c comment-line
         WRITE(ErrorOut,'(A78)') CLINE
         GOTO 10
      ENDIF
C     READ(CLINE,1000,END=9999) CODEWD,(WHAT(I),I=1,6),SDUM
C1000 FORMAT(A10,6E10.0,A8)
      DO 1008 I=1,6
         WHAT(I) = ZERO
 1008 CONTINUE
      READ(CLINE,1006,END=9999) CODEWD,CWHAT,SDUM
 1006 FORMAT(A10,A60,A8)
      READ(CWHAT,*,END=1007) (WHAT(I),I=1,6)
 1007 CONTINUE
      WRITE(ErrorOut,1001) CODEWD,(WHAT(I),I=1,6),SDUM
 1001 FORMAT(A10,6G10.3,A8)

c check for valid control card and get card index
      ICW = 0
      DO 11 I=1,MXCARD
         IF (CODEWD.EQ.CODE(I)) ICW = I
   11 CONTINUE
      IF (ICW.EQ.0) THEN
         WRITE(ErrorOut,1002) CODEWD
 1002    FORMAT(/,1X,'---> ',A10,': INVALID CONTROL-CARD !',/)
         GOTO 10
      ENDIF

      GOTO(
c------------------------------------------------------------
c       TITLE   ,  PROJPAR ,  TARPAR  ,  ENERGY  ,  MOMENTUM,
     &  100     ,  110     ,  120     ,  130     ,  140     ,
c
c------------------------------------------------------------
c       CMENERGY,  EMULSION,  FERMI   ,  TAUFOR  ,  PAULI   ,
     &  150     ,  160     ,  170     ,  180     ,  190     ,
c
c------------------------------------------------------------
c       COULOMB ,  HADRIN  ,  EVAP    ,  EMCCHECK,  MODEL   ,
     &  200     ,  210     ,  220     ,  230     ,  240     ,
c
c------------------------------------------------------------
c       PHOINPUT,  GLAUBERI,  FLUCTUAT,  CENTRAL ,  RECOMBIN,
     &  250     ,  260     ,  270     ,  280     ,  290     ,
c
c------------------------------------------------------------
c       COMBIJET,  XCUTS   ,  INTPT   ,  CRONINPT,  SEADISTR,
     &  300     ,  310     ,  320     ,  330     ,  340     ,
c
c------------------------------------------------------------
c       SEASU3  ,  DIQUARKS,  RESONANC,  DIFFRACT,  SINGLECH,
     &  350     ,  360     ,  370     ,  380     ,  390     ,
c
c------------------------------------------------------------
c       NOFRAGME, HADRONIZE,  POPCORN ,  PARDECAY,  BEAM    ,
     &  400     ,  410     ,  420     ,  430     ,  440     ,
c
c------------------------------------------------------------
c      LUND-MSTU, LUND-MSTJ, LUND-MDCY, LUND-PARJ, LUND-PARU,
     &  450     ,  451     ,  452     ,  460     ,  470     ,
c
c------------------------------------------------------------
c       OUTLEVEL,  FRAME   , L-TAG    ,  L-ETAG  ,  ECMS-CUT,
     &  480     ,  490     ,  500     ,  510     ,  520     ,
c
c------------------------------------------------------------
c       VDM-PAR1, HISTOGRAM, XS-TABLE , GLAUB-PAR, GLAUB-INI,
     &  530     ,  540     ,  550     ,  560     ,  565     ,
c
c------------------------------------------------------------
c               ,          ,  VDM-PAR2, XS-QELPRO, RNDMINIT ,
     &                        570     ,  580     ,  590     ,
c
c------------------------------------------------------------
c      LEPTO-CUT, LEPTO-LST,LEPTO-PARL,  START   ,  STOP    )
     &  600     ,  610     ,  620     ,  630     ,  640     ) , ICW
c
c------------------------------------------------------------

      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = TITLE                       *
c                                                                   *
c       what (1..6), sdum   no meaning                              *
c                                                                   *
c       Note:  The control-card following this must consist of      *
c              a string of characters usually giving the title of   *
c              the run.                                             *
c                                                                   *
c********************************************************************

  100 CONTINUE
      READ(TempDev,'(A78)') CTITLE
      WRITE(ErrorOut,'(//,5X,A78,//)') CTITLE
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = PROJPAR                     *
c                                                                   *
c       what (1) =  mass number of projectile nucleus  default: 1   *
c       what (2) =  charge of projectile nucleus       default: 1   *
c       what (3..6)   no meaning                                    *
c       sdum        projectile particle code word                   *
c                                                                   *
c       Note: If sdum is defined what (1..2) have no meaning.       *
c                                                                   *
c********************************************************************

  110 CONTINUE
      IF (SDUM.EQ.BLANK) THEN
         IP     = INT(WHAT(1))
         IPZ    = INT(WHAT(2))
         IJPROJ = 1
         IBPROJ = 1
      ELSE
         IJPROJ = 0
         DO 111 II=1,30
            IF (SDUM.EQ.BTYPE(II)) THEN
               IP     = 1
               IPZ    = 1
               IF (II.EQ.26) THEN
                  IJPROJ = 135
               ELSEIF (II.EQ.27) THEN
                  IJPROJ = 136
               ELSEIF (II.EQ.28) THEN
                  IJPROJ = 133
               ELSEIF (II.EQ.29) THEN
                  IJPROJ = 134
               ELSE
                  IJPROJ = II
               ENDIF
               IBPROJ = IIBAR(IJPROJ)
c photon
               IF ((IJPROJ.EQ.7).AND.(WHAT(1).GT.ZERO)) VIRT = WHAT(1)
c lepton
               IF (((IJPROJ.EQ. 3).OR.(IJPROJ.EQ. 4).OR.
     &              (IJPROJ.EQ.10).OR.(IJPROJ.EQ.11)).AND.
     &                              (WHAT(1).GT.ZERO)) Q2HI = WHAT(1)
            ENDIF
  111    CONTINUE
         IF (IJPROJ.EQ.0) THEN
            WRITE(ErrorOut,1110)
 1110       FORMAT(/,1X,'INVALID PROJPAR CARD !',/)
            GOTO 9999
         ENDIF
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = TARPAR                      *
c                                                                   *
c       what (1) =  mass number of target nucleus      default: 1   *
c       what (2) =  charge of target nucleus           default: 1   *
c       what (3..6)   no meaning                                    *
c       sdum        target particle code word                       *
c                                                                   *
c       Note: If sdum is defined what (1..2) have no meaning.       *
c                                                                   *
c********************************************************************

  120 CONTINUE
      IF (SDUM.EQ.BLANK) THEN
         IT     = INT(WHAT(1))
         ITZ    = INT(WHAT(2))
         IJTARG = 1
         IBTARG = 1
      ELSE
         IJTARG = 0
         DO 121 II=1,30
            IF (SDUM.EQ.BTYPE(II)) THEN
               IT     = 1
               ITZ    = 1
               IJTARG = II
               IBTARG = IIBAR(IJTARG)
            ENDIF
  121    CONTINUE
         IF (IJTARG.EQ.0) THEN
            WRITE(ErrorOut,1120)
 1120       FORMAT(/,1X,'INVALID TARPAR CARD !',/)
            GOTO 9999
         ENDIF
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = ENERGY                      *
c                                                                   *
c       what (1) =  energy (GeV) of projectile in Lab.              *
c                   if what(1) < 0:  |what(1)| = kinetic energy     *
c                                                default: 200 GeV   *
c                   if |what(2)| > 0: min. energy for variable      *
c                                     energy runs                   *
c       what (2) =  max. energy for variable energy runs            *
c                   if what(2) < 0:  |what(2)| = kinetic energy     *
c                                                                   *
c********************************************************************

  130 CONTINUE
      EPN    = WHAT(1)
      PPN    = ZERO
      CMENER = ZERO
      IF ((ABS(WHAT(2)).GT.ZERO).AND.
     &    (ABS(WHAT(2)).GT.ABS(WHAT(1)))) THEN
         VARELO = WHAT(1)
         VAREHI = WHAT(2)
         EPN    = VAREHI
      ENDIF
      LEINP  = .TRUE.
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = MOMENTUM                    *
c                                                                   *
c       what (1) =  momentum (GeV/c) of projectile in Lab.          *
c                                                default: 200 GeV/c *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  140 CONTINUE
      EPN    = ZERO
      PPN    = WHAT(1)
      CMENER = ZERO
      LEINP  = .TRUE.
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = CMENERGY                    *
c                                                                   *
c       what (1) =  energy in nucleon-nucleon cms.                  *
c                                                default: none      *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  150 CONTINUE
      EPN    = ZERO
      PPN    = ZERO
      CMENER = WHAT(1)
      LEINP  = .TRUE.
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = EMULSION                    *
c                                                                   *
c               definition of nuclear emulsions                     *
c                                                                   *
c     what(1)      mass number of emulsion component                *
c     what(2)      charge of emulsion component                     *
c     what(3)      fraction of events in which a scattering on a    *
c                  nucleus of this properties is performed          *
c     what(4,5,6)  as what(1,2,3) but for another component         *
c                                             default: no emulsion  *
c     sdum         no meaning                                       *
c                                                                   *
c     Note: If this input-card is once used with valid parameters   *
c           TARPAR is obsolete.                                     *
c           Not the absolute values of the fractions are important  *
c           but only the ratios of fractions of different comp.     *
c           This control card can be repeatedly used to define      *
c           emulsions consisting of up to 10 elements.              *
c                                                                   *
c********************************************************************

  160 CONTINUE
      IF ((WHAT(1).GT.ZERO).AND.(WHAT(2).GT.ZERO)
     &                     .AND.(ABS(WHAT(3)).GT.ZERO)) THEN
         NCOMPO = NCOMPO+1
         IF (NCOMPO.GT.NCOMPX) THEN
            WRITE(ErrorOut,1600)
            STOP
         ENDIF
         IEMUMA(NCOMPO) = INT(WHAT(1))
         IEMUCH(NCOMPO) = INT(WHAT(2))
         EMUFRA(NCOMPO) = WHAT(3)
         IEMUL = 1
C        CALL SHMAKF(IDUM,IDUM,IEMUMA(NCOMPO),IEMUCH(NCOMPO))
      ENDIF
      IF ((WHAT(4).GT.ZERO).AND.(WHAT(5).GT.ZERO)
     &                     .AND.(ABS(WHAT(6)).GT.ZERO)) THEN
         NCOMPO = NCOMPO+1
         IF (NCOMPO.GT.NCOMPX) THEN
            WRITE(ErrorOut,1001)
            STOP
         ENDIF
         IEMUMA(NCOMPO) = INT(WHAT(4))
         IEMUCH(NCOMPO) = INT(WHAT(5))
         EMUFRA(NCOMPO) = WHAT(6)
C        CALL SHMAKF(IDUM,IDUM,IEMUMA(NCOMPO),IEMUCH(NCOMPO))
      ENDIF
 1600 FORMAT(1X,'TOO MANY EMULSION COMPONENTS - PROGRAM STOPPED')
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = FERMI                       *
c                                                                   *
c       what (1) = -1 Fermi-motion of nucleons not treated          *
c                                                 default: 1        *
c       what (2) =    scale factor for Fermi-momentum               *
c                                                 default: 0.75     *
c       what (3..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  170 CONTINUE
      IF (WHAT(1).EQ.-1.0D0) THEN
         LFERMI = .FALSE.
      ELSE
         LFERMI = .TRUE.
      ENDIF
      XMOD = WHAT(2)
      IF (XMOD.GE.ZERO) FERMOD = XMOD
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = TAUFOR                      *
c                                                                   *
c          formation time supressed intranuclear cascade            *
c                                                                   *
c    what (1)      formation time (in fm/c)                         *
c                  note: what(1)=10. corresponds roughly to an      *
c                        average formation time of 1 fm/c           *
c                                                 default: 5. fm/c  *
c    what (2)      number of generations followed                   *
c                                                 default: 25       *
c    what (3) = 1. p_t-dependent formation zone                     *
c             = 2. constant formation zone                          *
c                                                 default: 1        *
c    what (4)      modus of selection of nucleus where the          *
c                  cascade if followed first                        *
c             = 1.  proj./target-nucleus with probab. 1/2           *
c             = 2.  nucleus with highest mass                       *
c             = 3.  proj. nucleus if particle is moving in pos. z   *
c                   targ. nucleus if particle is moving in neg. z   *
c                                                 default: 1        *
c    what (5..6), sdum   no meaning                                 *
c                                                                   *
c********************************************************************

  180 CONTINUE
      TAUFOR = WHAT(1)
      KTAUGE = INT(WHAT(2))
      INCMOD = 1
      IF ((WHAT(3).GE.1.0D0).AND.(WHAT(3).LE.2.0D0))
     &                                    ITAUVE = INT(WHAT(3))
      IF ((WHAT(4).GE.1.0D0).AND.(WHAT(4).LE.3.0D0))
     &                                    INCMOD = INT(WHAT(4))
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = PAULI                       *
c                                                                   *
c       what (1) =  -1  Pauli's principle for secondary             *
c                       interactions not treated                    *
c                                                    default: 1     *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  190 CONTINUE
      IF (WHAT(1).EQ.-1.0D0) THEN
         LPAULI = .FALSE.
      ELSE
         LPAULI = .TRUE.
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = COULOMB                     *
c                                                                   *
c       what (1) = -1. Coulomb-energy treatment switched off        *
c                                                    default: 1     *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  200 CONTINUE
      ICOUL = 1
      IF (WHAT(1).EQ.-1.0D0) THEN
         ICOUL = 0
      ELSE
         ICOUL = 1
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = HADRIN                      *
c                                                                   *
c                       HADRIN module                               *
c                                                                   *
c    what (1) = 0. elastic/inelastic interactions with probab.      *
c                  as defined by cross-sections                     *
c             = 1. inelastic interactions forced                    *
c             = 2. elastic interactions forced                      *
c                                                 default: 1        *
c    what (2)      upper threshold in total energy (GeV) below      *
c                  which interactions are sampled by HADRIN         *
c                                                 default: 5. GeV   *
c    what (3..6), sdum   no meaning                                 *
c                                                                   *
c********************************************************************

  210 CONTINUE
      IWHAT = INT(WHAT(1))
      IF ((IWHAT.GE.0).AND.(IWHAT.LE.2)) INTHAD = IWHAT
      IF ((WHAT(2).GT.ZERO).AND.(WHAT(2).LT.15.0D0)) EHADTH = WHAT(2)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = EVAP                        *
c                                                                   *
c                    evaporation module                             *
c                                                                   *
c  what (1) =< -1 ==> evaporation is switched off                   *
c           >=  1 ==> evaporation is performed                      *
c                                                                   *
c         what (1) = i1 + i2*10 + i3*100 + i4*10000                 *
c                    (i1, i2, i3, i4 >= 0 )                         *
c                                                                   *
c   i1 is the flag for selecting the T=0 level density option used  *
c      =  1: standard EVAP level densities with Cook pairing        *
c            energies                                               *
c      =  2: Z,N-dependent Gilbert & Cameron level densities        *
c                                                        (default)  *
c      =  3: Julich A-dependent level densities                     *
c      =  4: Z,N-dependent Brancazio & Cameron level densities      *
c                                                                   *
c   i2 >= 1: high energy fission activated                          *
c            (default high energy fission activated)                *
c                                                                   *
c   i3 =  0: No energy dependence for level densities               *
c      =  1: Standard Ignyatuk (1975, 1st) energy dependence        *
c            for level densities (default)                          *
c      =  2: Standard Ignyatuk (1975, 1st) energy dependence        *
c            for level densities with NOT used set of parameters    *
c      =  3: Standard Ignyatuk (1975, 1st) energy dependence        *
c            for level densities with NOT used set of parameters    *
c      =  4: Second   Ignyatuk (1975, 2nd) energy dependence        *
c            for level densities                                    *
c      =  5: Second   Ignyatuk (1975, 2nd) energy dependence        *
c            for level densities with fit 1 Iljinov & Mebel set of  *
c            parameters                                             *
c      =  6: Second   Ignyatuk (1975, 2nd) energy dependence        *
c            for level densities with fit 2 Iljinov & Mebel set of  *
c            parameters                                             *
c      =  7: Second   Ignyatuk (1975, 2nd) energy dependence        *
c            for level densities with fit 3 Iljinov & Mebel set of  *
c            parameters                                             *
c      =  8: Second   Ignyatuk (1975, 2nd) energy dependence        *
c            for level densities with fit 4 Iljinov & Mebel set of  *
c            parameters                                             *
c                                                                   *
c   i4 >= 1: Original Gilbert and Cameron pairing energies used     *
c            (default Cook's modified pairing energies)             *
c                                                                   *
c  what (2) = ig + 10 * if   (ig and if must have the same sign)    *
c                                                                   *
c   ig =< -1 ==> deexcitation gammas are not produced               *
c                (if the evaporation step is not performed          *
c                 they are never produced)                          *
c   if =< -1 ==> Fermi Break Up is not invoked                      *
c                (if the evaporation step is not performed          *
c                 it is never invoked)                              *
c   The default is: deexcitation gamma produced and Fermi break up  *
c                   activated for the new  preequilibrium, not      *
c                   activated otherwise.                            *
c  what (3..6), sdum   no meaning                                   *
c                                                                   *
c********************************************************************

 220  CONTINUE
      IF (WHAT(1).LE.-1.0D0) THEN
         LEVPRT = .FALSE.
         LDEEXG = .FALSE.
         LHEAVY = .FALSE.
         GOTO 10
      ENDIF
      WHTSAV = WHAT (1)
      IF ( NINT (WHAT (1)) .GE. 10000 ) THEN
         LLVMOD   = .FALSE.
         JLVHLP   = NINT (WHAT (1)) / 10000
         WHAT (1) = WHAT (1) - 10000.D+00 * JLVHLP
      END IF
      IF ( NINT (WHAT (1)) .GE. 100 ) THEN
         JLVMOD   = NINT (WHAT (1)) / 100
         WHAT (1) = WHAT (1) - 100.D+00 * JLVMOD
      END IF
      IF ( NINT (WHAT (1)) .GE. 10  ) THEN
         IFISS    = 1
         JLVHLP   = NINT (WHAT (1)) / 10
         WHAT (1) = WHAT (1) - 10.D+00 * JLVHLP
      ELSE IF ( NINT (WHTSAV) .NE. 0 ) THEN
         IFISS    = 0
      END IF
      IF ( NINT (WHAT (1)) .GE. 0 ) THEN
         LEVPRT = .TRUE.
         ILVMOD = NINT (WHAT(1))
         IF ( ABS (NINT (WHAT (2))) .GE. 10  ) THEN
            LFRMBK   = .TRUE.
            JLVHLP   = NINT (WHAT (2)) / 10
            WHAT (2) = WHAT (2) - 10.D+00 * JLVHLP
         ELSE IF ( NINT (WHAT (2)) .NE. 0 ) THEN
            LFRMBK   = .FALSE.
         END IF
         IF ( NINT (WHAT (2)) .GE. 0 ) THEN
            LDEEXG = .TRUE.
         ELSE
            LDEEXG = .FALSE.
         END IF
c*sr heavies are always put to /FKFHVY/
C        IF ( NINT (WHAT(3)) .GE. 1 ) THEN
C           LHEAVY = .TRUE.
C        ELSE
C           LHEAVY = .FALSE.
C        END IF
         LHEAVY = .TRUE.
      ELSE
         LEVPRT = .FALSE.
         LDEEXG = .FALSE.
         LHEAVY = .FALSE.
      END IF

      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = EMCCHECK                    *
c                                                                   *
c    extended energy-momentum / quantum-number conservation check   *
c                                                                   *
c       what (1) = -1   extended check not performed                *
c                                                    default: 1.    *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  230 CONTINUE
      IF (WHAT(1).EQ.-1) THEN
         LEMCCK = .FALSE.
      ELSE
         LEMCCK = .TRUE.
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = MODEL                       *
c                                                                   *
c     Model to be used to treat nucleon-nucleon interactions        *
c                                                                   *
c       sdum = DTUNUC    two-chain model                            *
c            = PHOJET    multiple chains including minijets         *
c            = LEPTO     DIS                                        *
c            = QNEUTRIN  quasi-elastic neutrino scattering          *
c                                                  default: PHOJET  *
c                                                                   *
c       if sdum = LEPTO:                                            *
c       what (1)         (variable INTER)                           *
c                        = 1  gamma exchange                        *
c                        = 2  W+-   exchange                        *
c                        = 3  Z0    exchange                        *
c                        = 4  gamma/Z0 exchange                     *
c                                                                   *
c       if sdum = QNEUTRIN:                                         *
c       what (1)         = 0  elastic scattering on nucleon and     *
c                             tau does not decay (default)          *
c                        = 1  decay of tau into mu..                *
c                        = 2  decay of tau into e..                 *
c                        = 10 CC events on p and n                  *
c                        = 11 NC events on p and n                  *
c                                                                   *
c       what (2..6)      no meaning                                 *
c                                                                   *
c********************************************************************

  240 CONTINUE
      IF (SDUM.EQ.CMODEL(1)) THEN
         MCGENE = 1
      ELSEIF (SDUM.EQ.CMODEL(2)) THEN
         MCGENE = 2
      ELSEIF (SDUM.EQ.CMODEL(3)) THEN
         MCGENE = 3
         IF ((WHAT(1).GE.1.0D0).AND.(WHAT(1).LE.4.0D0))
     &      INTER = INT(WHAT(1))
      ELSEIF (SDUM.EQ.CMODEL(4)) THEN
         MCGENE = 4
         IWHAT  = INT(WHAT(1))
         IF ((IWHAT.EQ.1 ).OR.(IWHAT.EQ.2 ).OR.
     &       (IWHAT.EQ.10).OR.(IWHAT.EQ.11))
     &      NEUDEC = IWHAT
      ELSE
         STOP ' UNKNOWN MODEL !'
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = PHOINPUT                    *
c                                                                   *
c       Start of input-section for PHOJET-specific input-cards      *
c       Note:  This section will not be finished before giving      *
c              ENDINPUT-card                                        *
c       what (1..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  250 CONTINUE
      IF (LPHOIN) THEN

         CALL PHO_INIT(TempDev,IREJ1)

         IF (IREJ1.NE.0) THEN
            WRITE(ErrorOut,
     * '(1X,A)')'INIT:   reading PHOJET-input failed'
            STOP
         ENDIF
         LPHOIN = .FALSE.
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = GLAUBERI                    *
c                                                                   *
c        Pre-initialization of impact parameter selection           *
c                                                                   *
c        what (1..6), sdum   no meaning                             *
c                                                                   *
c********************************************************************

  260 CONTINUE
      IF (IFIRST.NE.99) THEN
         CALL DT_RNDMST(12,34,56,78)
         CALL DT_RNDMTE(1)
         OPEN(40,FILE='OUTDATA0/SHM.OUT',STATUS='UNKNOWN')
C        OPEN(11,FILE='outdata0/shm.dbg',STATUS='UNKNOWN')
         IFIRST = 99
      ENDIF

      IPPN = 8
      PLOW = 10.0D0
C     IPPN = 1
C     PLOW = 100.0D0
      PHI  = 1.0D5
      APLOW = LOG10(PLOW)
      APHI  = LOG10(PHI)
      ADP   = (APHI-APLOW)/DBLE(IPPN)

      IPLOW = 1
      IDIP  = 1
      IIP   = 5
C     IPLOW = 1
C     IDIP  = 1
C     IIP   = 1
      IPRANG(1) = 1
      IPRANG(2) = 2
      IPRANG(3) = 5
      IPRANG(4) = 10
      IPRANG(5) = 20

      ITLOW = 30
      IDIT  = 3
      IIT   = 60
C     IDIT  = 10
C     IIT   = 21

      DO 473 NCIT=1,IIT
         IT   = ITLOW+(NCIT-1)*IDIT
C        IPHI = IT
C        IDIP = 10
C        IIP  = (IPHI-IPLOW)/IDIP
C        IF (IIP.EQ.0) IIP = 1
C        IF (IT.EQ.IPLOW) IIP = 0

         DO 472 NCIP=1,IIP
            IP = IPRANG(NCIP)
CC           IF (NCIP.LE.IIP) THEN
C               IP = IPLOW+(NCIP-1)*IDIP
CC           ELSE
CC              IP = IT
CC           ENDIF
            IF (IP.GT.IT) GOTO 472

            DO 471 NCP=1,IPPN+1
               APPN = APLOW+DBLE(NCP-1)*ADP
               PPN  = 10**APPN

               OPEN(12,FILE='OUTDATA0/SHM.STA',STATUS='UNKNOWN')
               WRITE(12,'(1X,2I5,E15.3)') IP,IT,PPN
               CLOSE(12)

               XLIM1 = 0.0D0
               XLIM2 = 50.0D0
               XLIM3 = ZERO
               IBIN  = 50
               CALL DT_NEWHGR(XDUM,XDUM,XDUM,XDUMB,-1,IHDUM)
               CALL DT_NEWHGR(XLIM1,XLIM2,XLIM3,XDUMB,IBIN,IHSHMA)

               NEVFIT = 5
C              IF ((IP.GT.10).OR.(IT.GT.10)) THEN
C                 NEVFIT = 5
C              ELSE
C                 NEVFIT = 10
C              ENDIF
               SIGAV  = 0.0D0

               DO 478 I=1,NEVFIT
                  CALL DT_SHMAKI(IP,IDUM1,IT,IDUM1,IJPROJ,PPN,99)
                  SIGAV = SIGAV+XSPRO(1,1,1)
                  DO 479 J=1,50
                     XC = DBLE(J)
                     CALL DT_FILHGR(XC,BSITE(1,1,1,J),IHSHMA,I)
  479             CONTINUE
  478          CONTINUE

               CALL DT_EVTHIS(IDUM)
               HEADER = ' BSITE'
C              CALL OUTGEN(IHSHMA,0,0,0,0,0,HEADER,0,NEVFIT,ONE,0,1,-1)

C              CALL GENFIT(XPARA)
C              WRITE(40,'(2I4,E11.3,F6.0,5E11.3)')
C    &              IP,IT,PPN,SIGAV/DBLE(NEVFIT),XPARA

  471       CONTINUE

  472    CONTINUE

  473 CONTINUE

      STOP

c********************************************************************
c                                                                   *
c               control card:  codewd = FLUCTUAT                    *
c                                                                   *
c           Treatment of cross section fluctuations                 *
c                                                                   *
c       what (1) = 1  treat cross section fluctuations              *
c                                                    default: 0.    *
c       what (1..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

 270  CONTINUE
      IFLUCT = 0
      IF (WHAT(1).EQ.ONE) THEN
         IFLUCT = 1
         CALL DT_FLUINI
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = CENTRAL                     *
c                                                                   *
c       what (1) = 1.  central production forced     default: 0     *
c  if what (1) < 0 and > -100                                       *
c       what (2) = min. impact parameter             default: 0     *
c       what (3) = max. impact parameter             default: b_max *
c  if what (1) < -99                                                *
c       what (2) = fraction of cross section         default: 1     *
c  if what (1) = -1 : evaporation/fzc suppressed                    *
c  if what (1) < -1 : evaporation/fzc allowed                       *
c                                                                   *
c       what (4..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  280 CONTINUE
      ICENTR = INT(WHAT(1))
      IF (ICENTR.LT.0) THEN
         IF (ICENTR.GT.-100) THEN
            BIMIN = WHAT(2)
            BIMAX = WHAT(3)
         ELSE
            XSFRAC = WHAT(2)
         ENDIF
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = RECOMBIN                    *
c                                                                   *
c                     Chain recombination                           *
c        (recombine S-S and V-V chains to V-S chains)               *
c                                                                   *
c       what (1) = -1. recombination switched off    default: 1     *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  290 CONTINUE
      IRECOM = 1
      IF (WHAT(1).EQ.-1.0D0) IRECOM = 0
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = COMBIJET                    *
c                                                                   *
c               chain fusion (2 q-aq --> qq-aqaq)                   *
c                                                                   *
c       what (1) = 1   fusion treated                               *
c                                                    default: 0.    *
c       what (2)       minimum number of uncombined chains from     *
c                      single projectile or target nucleons         *
c                                                    default: 0.    *
c       what (3..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  300 CONTINUE
      LCO2CR = .FALSE.
      IF (INT(WHAT(1)).EQ.1) LCO2CR = .TRUE.
      IF (WHAT(2).GE.ZERO) CUTOF = WHAT(2)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = XCUTS                       *
c                                                                   *
c                 thresholds for x-sampling                         *
c                                                                   *
c    what (1)    defines lower threshold for val.-q x-value (CVQ)   *
c                                                 default: 1.       *
c    what (2)    defines lower threshold for val.-qq x-value (CDQ)  *
c                                                 default: 2.       *
c    what (3)    defines lower threshold for sea-q x-value (CSEA)   *
c                                                 default: 0.2      *
c    what (4)    sea-q x-values in S-S chains (SSMIMA)              *
c                                                 default: 0.14     *
c    what (5)    not used                                           *
c                                                 default: 2.       *
c    what (6), sdum   no meaning                                    *
c                                                                   *
c    Note: Lower thresholds (what(1..3)) are def. as x_thr=CXXX/ECM *
c                                                                   *
c********************************************************************

  310 CONTINUE
      IF (WHAT(1).GE.0.5D0) CVQ    = WHAT(1)
      IF (WHAT(2).GE.ONE)   CDQ    = WHAT(2)
      IF (WHAT(3).GE.0.1D0) CSEA   = WHAT(3)
      IF (WHAT(4).GE.ZERO) THEN
         SSMIMA = WHAT(4)
         SSMIMQ = SSMIMA**2
      ENDIF
      IF (WHAT(5).GT.2.0D0) VVMTHR = WHAT(5)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = INTPT                       *
c                                                                   *
c     what (1) = -1   intrinsic transverse momenta of partons       *
c                     not treated                default: 1         *
c     what (2..6), sdum   no meaning                                *
c                                                                   *
c********************************************************************

  320 CONTINUE
      IF (WHAT(1).EQ.-1.0D0) THEN
         LINTPT = .FALSE.
      ELSE
         LINTPT = .TRUE.
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = CRONINPT                    *
c                                                                   *
c    Cronin effect (multiple scattering of partons at chain ends)   *
c                                                                   *
c       what (1) = -1  Cronin effect not treated     default: 1     *
c       what (2) = 0   scattering parameter          default: 0.64  *
c       what (3..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  330 CONTINUE
      IF (WHAT(1).EQ.-1.0D0) THEN
         MKCRON = 0
      ELSE
         MKCRON = 1
      ENDIF
      CRONCO = WHAT(2)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = SEADISTR                    *
c                                                                   *
c     what (1)  (XSEACO)  sea(x) prop. 1/x**what (1)   default: 1.  *
c     what (2)  (UNON)                                 default: 2.  *
c     what (3)  (UNOM)                                 default: 1.5 *
c     what (4)  (UNOSEA)                               default: 5.  *
c                        qdis(x) prop. (1-x)**what (1)  etc.        *
c     what (5..6), sdum   no meaning                                *
c                                                                   *
c********************************************************************

  340 CONTINUE
      XSEACO = WHAT(1)
      XSEACU = 1.05D0-XSEACO
      UNON   = WHAT(2)
      IF (UNON.LT.0.1D0) UNON = 2.0D0
      UNOM   = WHAT(3)
      IF (UNOM.LT.0.1D0) UNOM = 1.5D0
      UNOSEA = WHAT(4)
      IF (UNOSEA.LT.0.1D0) UNOSEA = 5.0D0
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = SEASU3                      *
c                                                                   *
c          Treatment of strange-quarks at chain ends                *
c                                                                   *
c       what (1)   (SEASQ)  strange-quark supression factor         *
c                  iflav = 1.+rndm*(2.+SEASQ)                       *
c                                                    default: 1.    *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  350 CONTINUE
      SEASQ = WHAT(1)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = DIQUARKS                    *
c                                                                   *
c     what (1) = -1.  sea-diquark/antidiquark-pairs not treated     *
c                                                    default: 1.    *
c     what (2..6), sdum   no meaning                                *
c                                                                   *
c********************************************************************

 360  CONTINUE
      IF (WHAT(1).EQ.-1.0D0) THEN
         LSEADI = .FALSE.
      ELSE
         LSEADI = .TRUE.
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = RESONANC                    *
c                                                                   *
c                 treatment of low mass chains                      *
c                                                                   *
c    what (1) = -1 low chain masses are not corrected for resonance *
c                  masses (obsolete for BAMJET-fragmentation)       *
c                                       default: 1.                 *
c    what (2) = -1 massless partons     default: 1. (massive)       *
c                                       default: 1. (massive)       *
c    what (3) = -1 chain-system containing chain of too small       *
c                  mass is rejected (note: this does not fully      *
c                  apply to S-S chains) default: 0.                 *
c    what (4..6), sdum   no meaning                                 *
c                                                                   *
c********************************************************************

  370 CONTINUE
      IRESCO = 1
      IMSHL  = 1
      IRESRJ = 0
      IF (WHAT(1).EQ.-ONE) IRESCO = 0
      IF (WHAT(2).EQ.-ONE) IMSHL  = 0
      IF (WHAT(3).EQ.-ONE) IRESRJ = 1
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = DIFFRACT                    *
c                                                                   *
c                Treatment of diffractive events                    *
c                                                                   *
c     what (1) = (ISINGD) 0  no single diffraction                  *
c                         1  single diffraction included            *
c                       +-2  single diffractive events only         *
c                       +-3  projectile single diffraction only     *
c                       +-4  target single diffraction only         *
c                        -5  double pomeron exchange only           *
c                      (neg. sign applies to PHOJET events)         *
c                                                     default: 0.   *
c                                                                   *
c     what (2) = (IDOUBD) 0  no double diffraction                  *
c                         1  double diffraction included            *
c                         2  double diffractive events only         *
c                                                     default: 0.   *
c     what (3) = 1 projectile diffraction treated (2-channel form.) *
c                                                     default: 0.   *
c     what (4) = alpha-parameter in projectile diffraction          *
c                                                     default: 0.   *
c     what (5..6), sdum   no meaning                                *
c                                                                   *
c********************************************************************

  380 CONTINUE
      IF (ABS(WHAT(1)).GT.ZERO) ISINGD = INT(WHAT(1))
      IF (ABS(WHAT(2)).GT.ZERO) IDOUBD = INT(WHAT(2))
      IF ((ISINGD.GT.1).AND.(IDOUBD.GT.1)) THEN
         WRITE(ErrorOut,1380)
 1380    FORMAT(1X,'INIT:   INCONSISTENT DIFFRACT - INPUT !',/,
     &          11X,'IDOUBD IS RESET TO ZERO')
         IDOUBD = 0
      ENDIF
      IF (WHAT(3).GT.ZERO) DIBETA = WHAT(3)
      IF (WHAT(4).GT.ZERO) DIALPH = WHAT(4)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = SINGLECH                    *
c                                                                   *
c       what (1) = 1.  Regge contribution (one chain) included      *
c                                                   default: 0.     *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

 390  CONTINUE
      ISICHA = 0
      IF (WHAT(1).EQ.ONE) ISICHA = 1
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = NOFRAGME                    *
c                                                                   *
c                 biased chain hadronization                        *
c                                                                   *
c       what (1..6) = -1  no of hadronizsation of S-S chains        *
c                   = -2  no of hadronizsation of D-S chains        *
c                   = -3  no of hadronizsation of S-D chains        *
c                   = -4  no of hadronizsation of S-V chains        *
c                   = -5  no of hadronizsation of D-V chains        *
c                   = -6  no of hadronizsation of V-S chains        *
c                   = -7  no of hadronizsation of V-D chains        *
c                   = -8  no of hadronizsation of V-V chains        *
c                   = -9  no of hadronizsation of comb. chains      *
c                                  default:  complete hadronization *
c       sdum   no meaning                                           *
c                                                                   *
c********************************************************************

  400 CONTINUE
      DO 401 I=1,6
         ICHAIN = INT(WHAT(I))
         IF ((ICHAIN.LE.-1).AND.(ICHAIN.GE.-9))
     &      LHADRO(ABS(ICHAIN)) = .FALSE.
  401 CONTINUE
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = HADRONIZE                   *
c                                                                   *
c           hadronization model and parameter switch                *
c                                                                   *
c       what (1) = 1    hadronization via BAMJET                    *
c                = 2    hadronization via JETSET                    *
c                                                    default: 2     *
c       what (2) = 1..3 parameter set to be used                    *
c                       JETSET: 3 sets available                    *
c                               ( = 3 default JETSET-parameters)    *
c                       BAMJET: 1 set available                     *
c                                                    default: 1     *
c       what (3..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  410 CONTINUE
      IWHAT1 = INT(WHAT(1))
      IWHAT2 = INT(WHAT(2))
      IF ((IWHAT1.EQ.1).OR.(IWHAT1.EQ.2)) IFRAG(1) = IWHAT1
      IF ((IWHAT1.EQ.2).AND.(IWHAT2.GE.1).AND.(IWHAT2.LE.3))
     &                                    IFRAG(2) = IWHAT2
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = POPCORN                     *
c                                                                   *
c  "Popcorn-effect" in fragmentation and diquark breaking diagrams  *
c                                                                   *
c   what (1) = (PDB) frac. of diquark fragmenting directly into     *
c                    baryons (PYTHIA/JETSET fragmentation)          *
c                    (JETSET: = 0. Popcorn mechanism switched off)  *
c                                                    default: 0.5   *
c   what (2) = probability for accepting a diquark breaking         *
c              diagram involving the generation of a u/d quark-     *
c              antiquark pair                        default: 0.0   *
c   what (3) = same a what (2), here for s quark-antiquark pair     *
c                                                    default: 0.0   *
c   what (4..6), sdum   no meaning                                  *
c                                                                   *
c********************************************************************

  420 CONTINUE
      IF (WHAT(1).GE.0.0D0) PDB = WHAT(1)
      IF (WHAT(2).GE.0.0D0) THEN
         PDBSEA(1) = WHAT(2)
         PDBSEA(2) = WHAT(2)
      ENDIF
      IF (WHAT(3).GE.0.0D0) PDBSEA(3) = WHAT(3)
      DO 421 I=1,8
         DBRKA(1,I) = DBRKR(1,I)*PDBSEA(1)/(1.D0-PDBSEA(1))
         DBRKA(2,I) = DBRKR(2,I)*PDBSEA(2)/(1.D0-PDBSEA(2))
         DBRKA(3,I) = DBRKR(3,I)*PDBSEA(3)/(1.D0-PDBSEA(3))
  421 CONTINUE
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = PARDECAY                    *
c                                                                   *
c      what (1) = 1.  Sigma0/Asigma0 are decaying within JETSET     *
c               = 2.  pion^0 decay after intranucl. cascade         *
c                                                default: no decay  *
c      what (2..6), sdum   no meaning                               *
c                                                                   *
c********************************************************************

 430  CONTINUE
      IF (WHAT(1).EQ.ONE)  ISIG0 = 1
      IF (WHAT(1).EQ.2.0D0) IPI0 = 1
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = BEAM                        *
c                                                                   *
c              definition of beam parameters                        *
c                                                                   *
c      what (1/2)  > 0 : energy of beam 1/2 (GeV)                   *
c                  < 0 : abs(what(1/2)) energy per charge of        *
c                        beam 1/2 (GeV)                             *
c                  (beam 1 is directed into positive z-direction)   *
c      what (3)    beam crossing angle, defined as 2x angle between *
c                  one beam and the z-axis (micro rad)              *
c      what (4)    angle with x-axis defining the collision plane   *
c      what (5..6), sdum   no meaning                               *
c                                                                   *
c      Note: this card requires previously defined projectile and   *
c            target identities (PROJPAR, TARPAR)                    *
c                                                                   *
c********************************************************************

  440 CONTINUE
      CALL DT_BEAMPR(WHAT,PPN,1)
      EPN    = ZERO
      CMENER = ZERO
      LEINP  = .TRUE.
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LUND-MSTU                   *
c                                                                   *
c          set parameter MSTU in JETSET-common /LUDAT1/             *
c                                                                   *
c       what (1) =  index according to LUND-common block            *
c       what (2) =  new value of MSTU( int(what(1)) )               *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-Lund or corresponding to  *
c                                 the set given in HADRONIZE        *
c                                                                   *
c********************************************************************

  450 CONTINUE
      IF (WHAT(1).GT.ZERO) THEN
         NMSTU = NMSTU+1
         IMSTU(NMSTU) = INT(WHAT(1))
         MSTUX(NMSTU) = INT(WHAT(2))
      ENDIF
      IF (WHAT(3).GT.ZERO) THEN
         NMSTU = NMSTU+1
         IMSTU(NMSTU) = INT(WHAT(3))
         MSTUX(NMSTU) = INT(WHAT(4))
      ENDIF
      IF (WHAT(5).GT.ZERO) THEN
         NMSTU = NMSTU+1
         IMSTU(NMSTU) = INT(WHAT(5))
         MSTUX(NMSTU) = INT(WHAT(6))
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LUND-MSTJ                   *
c                                                                   *
c          set parameter MSTJ in JETSET-common /LUDAT1/             *
c                                                                   *
c       what (1) =  index according to LUND-common block            *
c       what (2) =  new value of MSTJ( int(what(1)) )               *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-Lund or corresponding to  *
c                                 the set given in HADRONIZE        *
c                                                                   *
c********************************************************************

  451 CONTINUE
      IF (WHAT(1).GT.ZERO) THEN
         NMSTJ = NMSTJ+1
         IMSTJ(NMSTJ) = INT(WHAT(1))
         MSTJX(NMSTJ) = INT(WHAT(2))
      ENDIF
      IF (WHAT(3).GT.ZERO) THEN
         NMSTJ = NMSTJ+1
         IMSTJ(NMSTJ) = INT(WHAT(3))
         MSTJX(NMSTJ) = INT(WHAT(4))
      ENDIF
      IF (WHAT(5).GT.ZERO) THEN
         NMSTJ = NMSTJ+1
         IMSTJ(NMSTJ) = INT(WHAT(5))
         MSTJX(NMSTJ) = INT(WHAT(6))
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LUND-MDCY                   *
c                                                                   *
c  set parameter MDCY(I,1) for particle decays in JETSET-common     *
c                                                      /LUDAT3/     *
c                                                                   *
c       what (1-6) = PDG particle index of particle which should    *
c                    not decay                                      *
c                        default: default-Lund or forced in         *
c                                 DT_INITJS                         *
c                                                                   *
c********************************************************************

  452 CONTINUE
      DO 4521 I=1,6
         IF (WHAT(I).NE.ZERO) THEN

            KC = PYCOMP(INT(WHAT(I)))

            MDCY(KC,1) = 0
         ENDIF
 4521 CONTINUE
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LUND-PARJ                   *
c                                                                   *
c          set parameter PARJ in JETSET-common /LUDAT1/             *
c                                                                   *
c       what (1) =  index according to LUND-common block            *
c       what (2) =  new value of PARJ( int(what(1)) )               *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-Lund or corresponding to  *
c                                 the set given in HADRONIZE        *
c                                                                   *
c********************************************************************

  460 CONTINUE
      IF (WHAT(1).NE.ZERO) THEN
         NPARJ = NPARJ+1
         IPARJ(NPARJ) = INT(WHAT(1))
         PARJX(NPARJ) = WHAT(2)
      ENDIF
      IF (WHAT(3).NE.ZERO) THEN
         NPARJ = NPARJ+1
         IPARJ(NPARJ) = INT(WHAT(3))
         PARJX(NPARJ) = WHAT(4)
      ENDIF
      IF (WHAT(5).NE.ZERO) THEN
         NPARJ = NPARJ+1
         IPARJ(NPARJ) = INT(WHAT(5))
         PARJX(NPARJ) = WHAT(6)
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LUND-PARU                   *
c                                                                   *
c          set parameter PARJ in JETSET-common /LUDAT1/             *
c                                                                   *
c       what (1) =  index according to LUND-common block            *
c       what (2) =  new value of PARU( int(what(1)) )               *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-Lund or corresponding to  *
c                                 the set given in HADRONIZE        *
c                                                                   *
c********************************************************************

  470 CONTINUE
      IF (WHAT(1).GT.ZERO) THEN
         NPARU = NPARU+1
         IPARU(NPARU) = INT(WHAT(1))
         PARUX(NPARU) = WHAT(2)
      ENDIF
      IF (WHAT(3).GT.ZERO) THEN
         NPARU = NPARU+1
         IPARU(NPARU) = INT(WHAT(3))
         PARUX(NPARU) = WHAT(4)
      ENDIF
      IF (WHAT(5).GT.ZERO) THEN
         NPARU = NPARU+1
         IPARU(NPARU) = INT(WHAT(5))
         PARUX(NPARU) = WHAT(6)
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = OUTLEVEL                    *
c                                                                   *
c                    output control switches                        *
c                                                                   *
c       what (1) =  internal rejection informations  default: 0     *
c       what (2) =  energy-momentum conservation check output       *
c                                                    default: 0     *
c       what (3) =  internal warning messages        default: 0     *
c       what (4..6), sdum    not yet used                           *
c                                                                   *
c********************************************************************

  480 CONTINUE
      DO 481 K=1,6
         IOULEV(K) = INT(WHAT(K))
  481 CONTINUE
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = FRAME                       *
c                                                                   *
c          frame in which final state is given in DTEVT1            *
c                                                                   *
c       what (1) = 1  target rest frame (laboratory)                *
c                = 2  nucleon-nucleon cms                           *
c                                                    default: 1     *
c                                                                   *
c********************************************************************

  490 CONTINUE
      KFRAME = INT(WHAT(1))
      IF ((KFRAME.GE.1).AND.(KFRAME.LE.2)) IFRAME = KFRAME
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = L-TAG                       *
c                                                                   *
c                        lepton tagger:                             *
c   definition of kinematical cuts for radiated photon and          *
c   outgoing lepton detection in lepton-nucleus interactions        *
c                                                                   *
c       what (1) = y_min                                            *
c       what (2) = y_max                                            *
c       what (3) = Q^2_min                                          *
c       what (4) = Q^2_max                                          *
c       what (5) = theta_min  (Lab)                                 *
c       what (6) = theta_max  (Lab)                                 *
c                                       default: no cuts            *
c       sdum    no meaning                                          *
c                                                                   *
c********************************************************************

  500 CONTINUE
      YMIN  = WHAT(1)
      YMAX  = WHAT(2)
      Q2MIN = WHAT(3)
      Q2MAX = WHAT(4)
      THMIN = WHAT(5)
      THMAX = WHAT(6)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = L-ETAG                      *
c                                                                   *
c                        lepton tagger:                             *
c       what (1) = min. outgoing lepton energy  (in Lab)            *
c       what (2) = min. photon energy           (in Lab)            *
c       what (3) = max. photon energy           (in Lab)            *
c                                       default: no cuts            *
c       what (2..6), sdum    no meaning                             *
c                                                                   *
c********************************************************************

  510 CONTINUE
      ELMIN = MAX(WHAT(1),ZERO)
      EGMIN = MAX(WHAT(2),ZERO)
      EGMAX = MAX(WHAT(3),ZERO)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = ECMS-CUT                    *
c                                                                   *
c     what (1) = min. c.m. energy to be sampled                     *
c     what (2) = max. c.m. energy to be sampled                     *
c     what (3) = min x_Bj         to be sampled                     *
c                                       default: no cuts            *
c     what (3..6), sdum    no meaning                               *
c                                                                   *
c********************************************************************

  520 CONTINUE
      ECMIN  = WHAT(1)
      ECMAX  = WHAT(2)
      IF (ECMIN.GT.ECMAX) ECMIN = ECMAX
      XBJMIN = MAX(WHAT(3),ZERO)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = VDM-PAR1                    *
c                                                                   *
c      parameters in gamma-nucleus cross section calculation        *
c                                                                   *
c       what (1) =  Lambda^2                       default: 2.      *
c       what (2)    lower limit in M^2 integration                  *
c                =  1  (3m_pi)^2                                    *
c                =  2  (m_rho0)^2                                   *
c                =  3  (m_phi)^2                   default: 1       *
c       what (3)    upper limit in M^2 integration                  *
c                =  1   s/2                                         *
c                =  2   s/4                                         *
c                =  3   s                          default: 3       *
c       what (4)    CKMT F_2 structure function                     *
c                =  2212  proton                                    *
c                =  100   deuteron                 default: 2212    *
c       what (5)    calculation of gamma-nucleon xsections          *
c                =  1  according to CKMT-parametrization of F_2     *
c                =  2  integrating SIGVP over M^2                   *
c                =  3  using SIGGA                                  *
c                =  4  PHOJET cross sections       default:  4      *
c                                                                   *
c       what (6), sdum    no meaning                                *
c                                                                   *
c********************************************************************

  530 CONTINUE
      IF (WHAT(1).GE.ZERO) RL2 = WHAT(1)
      IF ((WHAT(2).GE.1).AND.(WHAT(2).LE.3)) INTRGE(1) = INT(WHAT(2))
      IF ((WHAT(3).GE.1).AND.(WHAT(3).LE.3)) INTRGE(2) = INT(WHAT(3))
      IF ((WHAT(4).EQ.2212).OR.(WHAT(4).EQ.100)) IDPDF = INT(WHAT(4))
      IF ((WHAT(5).GE.1).AND.(WHAT(5).LE.4)) MODEGA = INT(WHAT(5))
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = HISTOGRAM                   *
c                                                                   *
c           activate different classes of histograms                *
c                                                                   *
c                                default: no histograms             *
c                                                                   *
c********************************************************************

  540 CONTINUE
      DO 541 J=1,6
         IF ((WHAT(J).GE.100).AND.(WHAT(J).LE.150)) THEN
            IHISPP(INT(WHAT(J))-100) = 1
         ELSEIF ((ABS(WHAT(J)).GE.200).AND.(ABS(WHAT(J)).LE.250)) THEN
            IHISXS(INT(ABS(WHAT(J)))-200) = 1
            IF (WHAT(J).LT.ZERO) IXSTBL = 1
         ENDIF
  541 CONTINUE
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = XS-TABLE                    *
c                                                                   *
c    output of cross section table for requested interaction        *
c              - particle production deactivated ! -                *
c                                                                   *
c       what (1)      lower energy limit for tabulation             *
c                > 0  Lab. frame                                    *
c                < 0  nucleon-nucleon cms                           *
c       what (2)      upper energy limit for tabulation             *
c                > 0  Lab. frame                                    *
c                < 0  nucleon-nucleon cms                           *
c       what (3) > 0  # of equidistant lin. bins in E               *
c                < 0  # of equidistant log. bins in E               *
c       what (4)      lower limit of particle virtuality (photons)  *
c       what (5)      upper limit of particle virtuality (photons)  *
c       what (6) > 0  # of equidistant lin. bins in Q^2             *
c                < 0  # of equidistant log. bins in Q^2             *
c                                                                   *
c********************************************************************

  550 CONTINUE
      IF (WHAT(1).EQ.99999.0D0) THEN
         IRATIO = INT(WHAT(2))
         GOTO 10
      ENDIF
      CMENER = ABS(WHAT(2))
      IF (.NOT.LXSTAB) THEN
         CALL DT_BERTTP
         CALL DT_INCINI
      ENDIF
      IF ((.NOT.LXSTAB).OR.(CMENER.NE.CMEOLD)) THEN
         CMEOLD = CMENER
         IF (WHAT(2).GT.ZERO)
     &      CMENER = SQRT(2.0D0*AAM(1)**2+2.0D0*WHAT(2)*AAM(1))
         EPN = ZERO
         PPN = ZERO
C        WRITE(LOUT,*) 'CMENER = ',CMENER
         CALL DT_LTINI(IJPROJ,IJTARG,EPN,PPN,CMENER,1)
         CALL DT_PHOINI
      ENDIF
      CALL DT_BERTTP
      CALL DT_INCINI
      CALL DT_XSTABL(WHAT,IXSQEL,IRATIO)
      IXSQEL = 0
      LXSTAB = .TRUE.
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = GLAUB-PAR                   *
c                                                                   *
c                parameters in Glauber-formalism                    *
c                                                                   *
c    what (1)  # of nucleon configurations sampled in integration   *
c              over nuclear desity                default: 1000     *
c    what (2)  # of bins for integration over impact-parameter and  *
c              for profile-function calculation   default: 49       *
c    what (3)  = 1 calculation of tot., el. and qel. cross sections *
c                                                 default: 0        *
c    what (4)  = 1   read pre-calculated impact-parameter distrib.  *
c                    from "sdum".glb                                *
c              =-1   dump pre-calculated impact-parameter distrib.  *
c                    into "sdum".glb                                *
c              = 100 read pre-calculated impact-parameter distrib.  *
c                    for variable projectile/target/energy runs     *
c                    from "sdum".glb                                *
c                                                 default: 0        *
c    what (5..6)   no meaning                                       *
c    sdum      if |what (4)| = 1 name of in/output-file (sdum.glb)  *
c                                                                   *
c********************************************************************

  560 CONTINUE
      IF (WHAT(1).GT.ZERO) JSTATB = INT(WHAT(1))
      IF (WHAT(2).GT.ZERO) JBINSB = INT(WHAT(2))
      IF (WHAT(3).EQ.ONE) LPROD = .FALSE.
      IF ((ABS(WHAT(4)).EQ.ONE).OR.(WHAT(4).EQ.100)) THEN
         IOGLB = INT(WHAT(4))
         CGLB  = SDUM
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = GLAUB-INI                   *
c                                                                   *
c             pre-initialization of profile function                *
c                                                                   *
c       what (1)      lower energy limit for initialization         *
c                > 0  Lab. frame                                    *
c                < 0  nucleon-nucleon cms                           *
c       what (2)      upper energy limit for initialization         *
c                > 0  Lab. frame                                    *
c                < 0  nucleon-nucleon cms                           *
c       what (3) > 0  # of equidistant lin. bins in E               *
c                < 0  # of equidistant log. bins in E               *
c       what (4)      maximum projectile mass number for which the  *
c                     Glauber data are initialized for each         *
c                     projectile mass number                        *
c                     (if <= mass given with the PROJPAR-card)      *
c                                              default: 18          *
c       what (5)      steps in mass number starting from what (4)   *
c                     up to mass number defined with PROJPAR-card   *
c                     for which Glauber data are initialized        *
c                                              default: 5           *
c       what (6)      no meaning                                    *
c       sdum          no meaning                                    *
c                                                                   *
c********************************************************************

  565 CONTINUE
      IOGLB = -100
      CALL DT_GLBINI(WHAT)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = VDM-PAR2                    *
c                                                                   *
c      parameters in gamma-nucleus cross section calculation        *
c                                                                   *
c      what (1) = 0 no suppression of shadowing by direct photon    *
c                   processes                                       *
c               = 1 suppression ..                   default: 1     *
c      what (2) = 0 no suppression of shadowing by anomalous        *
c                   component if photon-F_2                         *
c               = 1 suppression ..                   default: 1     *
c      what (3) = 0 no suppression of shadowing by coherence        *
c                   length of the photon                            *
c               = 1 suppression ..                   default: 1     *
c      what (4) = 1 longitudinal polarized photons are taken into   *
c                   account                                         *
c                   eps*R*Q^2/M^2 = what(4)*Q^2/M^2  default: 0     *
c      what (5..6), sdum    no meaning                              *
c                                                                   *
c********************************************************************

  570 CONTINUE
      IF ((WHAT(1).EQ.ZERO).OR.(WHAT(1).EQ.ONE)) ISHAD(1) = INT(WHAT(1))
      IF ((WHAT(2).EQ.ZERO).OR.(WHAT(2).EQ.ONE)) ISHAD(2) = INT(WHAT(2))
      IF ((WHAT(3).EQ.ZERO).OR.(WHAT(3).EQ.ONE)) ISHAD(3) = INT(WHAT(3))
      EPSPOL  = WHAT(4)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  XS-QELPRO                            *
c                                                                   *
c     what (1..6), sdum    no meaning                               *
c                                                                   *
c********************************************************************

  580 CONTINUE
      IXSQEL = ABS(WHAT(1))
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  RNDMINIT                             *
c                                                                   *
c           initialization of random number generator               *
c                                                                   *
c     what (1..4)    values for initialization (= 1..168)           *
c     what (5..6), sdum    no meaning                               *
c                                                                   *
c********************************************************************

  590 CONTINUE
      IF ((WHAT(1).LT.1.0D0).OR.(WHAT(1).GT.168.0D0)) THEN
         NA1 = 22
      ELSE
         NA1 = WHAT(1)
      ENDIF
      IF ((WHAT(2).LT.1.0D0).OR.(WHAT(2).GT.168.0D0)) THEN
         NA2 = 54
      ELSE
         NA2 = WHAT(2)
      ENDIF
      IF ((WHAT(3).LT.1.0D0).OR.(WHAT(3).GT.168.0D0)) THEN
         NA3 = 76
      ELSE
         NA3 = WHAT(3)
      ENDIF
      IF ((WHAT(4).LT.1.0D0).OR.(WHAT(4).GT.168.0D0)) THEN
         NA4 = 92
      ELSE
         NA4 = WHAT(4)
      ENDIF
      CALL DT_RNDMST(NA1,NA2,NA3,NA4)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LEPTO-CUT                   *
c                                                                   *
c          set parameter CUT in LEPTO-common /LEPTOU/               *
c                                                                   *
c       what (1) =  index in CUT-array                              *
c       what (2) =  new value of CUT( int(what(1)) )                *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-LEPTO parameters          *
c                                                                   *
c********************************************************************

  600 CONTINUE
      IF (WHAT(1).GT.ZERO) CUT(INT(WHAT(1))) = WHAT(2)
      IF (WHAT(3).GT.ZERO) CUT(INT(WHAT(3))) = WHAT(4)
      IF (WHAT(5).GT.ZERO) CUT(INT(WHAT(5))) = WHAT(6)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LEPTO-LST                   *
c                                                                   *
c          set parameter LST in LEPTO-common /LEPTOU/               *
c                                                                   *
c       what (1) =  index in LST-array                              *
c       what (2) =  new value of LST( int(what(1)) )                *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-LEPTO parameters          *
c                                                                   *
c********************************************************************

  610 CONTINUE
      IF (WHAT(1).GT.ZERO) LST(INT(WHAT(1))) = INT(WHAT(2))
      IF (WHAT(3).GT.ZERO) LST(INT(WHAT(3))) = INT(WHAT(4))
      IF (WHAT(5).GT.ZERO) LST(INT(WHAT(5))) = INT(WHAT(6))
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LEPTO-PARL                  *
c                                                                   *
c          set parameter PARL in LEPTO-common /LEPTOU/              *
c                                                                   *
c       what (1) =  index in PARL-array                             *
c       what (2) =  new value of PARL( int(what(1)) )               *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-LEPTO parameters          *
c                                                                   *
c********************************************************************

  620 CONTINUE
      IF (WHAT(1).GT.ZERO) PARL(INT(WHAT(1))) = WHAT(2)
      IF (WHAT(3).GT.ZERO) PARL(INT(WHAT(3))) = WHAT(4)
      IF (WHAT(5).GT.ZERO) PARL(INT(WHAT(5))) = WHAT(6)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = START                       *
c                                                                   *
c       what (1) =   number of events                default: 100.  *
c       what (2) = 0 Glauber initialization follows                 *
c                = 1 Glauber initialization supressed, fitted       *
c                    results are used instead                       *
c                    (this does not apply if emulsion-treatment     *
c                     is requested)                                 *
c                = 2 Glauber initialization is written to           *
c                    output-file shmakov.out                        *
c                = 3 Glauber initialization is read from input-file *
c                    shmakov.out                     default: 0     *
c       what (3..6)  no meaning                                     *
c       what (3..6)  no meaning                                     *
c                                                                   *
c********************************************************************

  630 CONTINUE

c check for cross-section table output only
      IF (LXSTAB) STOP

      NCASES = INT(WHAT(1))
      IF (NCASES.LE.0) NCASES = 100
      IGLAU = INT(WHAT(2))
      IF ((IGLAU.NE.1).AND.(IGLAU.NE.2).AND.(IGLAU.NE.3))
     &                                            IGLAU = 0

      NPMASS = IP
      NPCHAR = IPZ
      NTMASS = IT
      NTCHAR = ITZ
      IDP    = IJPROJ
      IDT    = IJTARG
      IF (IDP.LE.0) IDP = 1
c muon neutrinos: temporary (missing index)
c (new patch in projpar: therefore the following this is probably not
c  necessary anymore..)
C     IF (IDP.EQ.26) IDP = 5
C     IF (IDP.EQ.27) IDP = 6

c redefine collision energy
      IF (LEINP) THEN
         IF (ABS(VAREHI).GT.ZERO) THEN
            PDUM = ZERO
            IF (VARELO.LT.EHADLO) VARELO = EHADLO
            CALL DT_LTINI(IDP,IDT,VARELO,PDUM,VARCLO,1)
            PDUM = ZERO
            CALL DT_LTINI(IDP,IDT,VAREHI,PDUM,VARCHI,1)
         ENDIF
         CALL DT_LTINI(IDP,IDT,EPN,PPN,CMENER,1)
      ELSE
         WRITE(ErrorOut,1003)
 1003    FORMAT(1X,'INIT:   COLLISION ENERGY NOT DEFINED!',/,
     &          1X,'              -PROGRAM STOPPED-      ')
         STOP
      ENDIF

c switch off evaporation (even if requested) if central coll. requ.
      IF ((ICENTR.EQ.-1).OR.(ICENTR.GT.0).OR.(XSFRAC.LT.0.5D0)) THEN
         IF (LEVPRT) THEN
            WRITE(ErrorOut,1004)
 1004       FORMAT(1X,/,'WARNING!  EVAPORATION REQUEST REJECTED SINCE',
     &             ' CENTRAL COLLISIONS FORCED.')
            LEVPRT = .FALSE.
            LDEEXG = .FALSE.
            LHEAVY = .FALSE.
         ENDIF
      ENDIF

c initialization of evaporation-module
      CALL DT_BERTTP
      CALL DT_INCINI
c save the default JETSET-parameter
      CALL DT_JSPARA(0)

c force use of phojet for g-A
      IF ((IDP.EQ.7).AND.(MCGENE.NE.3)) MCGENE = 2
c initialization of nucleon-nucleon event generator
      IF (MCGENE.EQ.2) CALL DT_PHOINI
c initialization of LEPTO event generator
      IF (MCGENE.EQ.3) THEN

         STOP ' THIS VERSION DOES NOT CONTAIN LEPTO !'

      ENDIF

c initialization of quasi-elastic neutrino scattering
      IF (MCGENE.EQ.4) THEN
         IF (IJPROJ.EQ.5) THEN
            NEUTYP = 1
         ELSEIF (IJPROJ.EQ.6) THEN
            NEUTYP = 2
         ELSEIF (IJPROJ.EQ.135) THEN
            NEUTYP = 3
         ELSEIF (IJPROJ.EQ.136) THEN
            NEUTYP = 4
         ELSEIF (IJPROJ.EQ.133) THEN
            NEUTYP = 5
         ELSEIF (IJPROJ.EQ.134) THEN
            NEUTYP = 6
         ENDIF
      ENDIF

c normalize fractions of emulsion components
      IF (NCOMPO.GT.0) THEN
         SUMFRA = ZERO
         DO 491 I=1,NCOMPO
            SUMFRA = SUMFRA+EMUFRA(I)
  491    CONTINUE
         IF (SUMFRA.GT.ZERO) THEN
            DO 492 I=1,NCOMPO
               EMUFRA(I) = EMUFRA(I)/SUMFRA
  492       CONTINUE
         ENDIF
      ENDIF

c disallow Cronin's multiple scattering for nucleus-nucleus interactions
      IF ((IP.GT.1).AND.(MKCRON.GT.0)) THEN
         WRITE(ErrorOut,1005)
 1005    FORMAT(/,1X,'INIT:  MULTIPLE SCATTERING DISALLOWED',/)
         MKCRON = 0
      ENDIF

c initialization of Glauber-formalism (moved to xAEVT, sr 26.3.96)
C     IF (NCOMPO.LE.0) THEN
C        CALL DT_SHMAKI(IP,IPZ,IT,ITZ,IDP,PPN,IGLAU)
C     ELSE
C        DO 493 I=1,NCOMPO
C           CALL DT_SHMAKI(IP,IPZ,IEMUMA(I),IEMUCH(I),IDP,PPN,0)
C 493    CONTINUE
C     ENDIF

c pre-tabulation of elastic cross-sections
      CALL DT_SIGTBL(JDUM,JDUM,DUM,DUM,-1)

      CALL DT_XTIME

      RETURN

c********************************************************************
c                                                                   *
c               control card:  codewd = STOP                        *
c                                                                   *
c               stop of the event generation                        *
c                                                                   *
c       what (1..6)  no meaning                                     *
c                                                                   *
c********************************************************************

 9999 CONTINUE
      WRITE(ErrorOut,9000)
 9000 FORMAT(1X,'---> UNEXPECTED END OF INPUT !')

  640 CONTINUE
      STOP

      END
c
c===kkinc==============================================================*
c
CDECK  ID>, DT_KKINC
      SUBROUTINE DT_KKINC(NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,EPN,KKMAT,
     &                                                         IREJ)

c***********************************************************************
c Treatment of complete nucleus-nucleus or hadron-nucleus scattering   *
c This subroutine is an update of the previous version written         *
c by J. Ranft/ H.-J. Moehring.                                         *
c This version dated 19.11.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY5=1.0D-5,
     &           TINY2=1.0D-2,TINY3=1.0D-3)

      LOGICAL LFZC

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c flags for particle decays
      COMMON /DTFRPA/ MSTUX(20),PARUX(20),MSTJX(20),PARJX(20),
     &                IMSTU(20),IPARU(20),IMSTJ(20),IPARJ(20),
     &                NMSTU,NPARU,NMSTJ,NPARJ,PDB,PDBSEA(3),ISIG0,IPI0

c cuts for variable energy runs
      COMMON /DTVARE/ VARELO,VAREHI,VARCLO,VARCHI

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD


      DIMENSION WHAT(6)

      IREJ  = 0
      ILOOP = 0
  100 CONTINUE
      IF (ILOOP.EQ.4) THEN
         WRITE(ErrorOut,1000) NEVHKK
 1000    FORMAT(1X,'KKINC: EVENT ',I8,' REJECTED!')
         GOTO 9999
      ENDIF
      ILOOP = ILOOP+1

c variable energy-runs, recalculate parameters for LT's
      IF ((ABS(VAREHI).GT.ZERO).OR.(IOGLB.EQ.100)) THEN
         PDUM = ZERO
         CDUM = ZERO
         CALL DT_LTINI(IDP,1,EPN,PDUM,CDUM,1)
      ENDIF
      IF (EPN.GT.EPROJ) THEN
         WRITE(ErrorOut,'(A,E9.3,2A,E9.3,A)')
     &      ' REQUESTED ENERGY (',EPN,'GEV) EXCEEDS',
     &      ' INITIALIZATION ENERGY (',EPROJ,'GEV) !'
         STOP
      ENDIF

c re-initialize /DTPRTA/
      IP  = NPMASS
      IPZ = NPCHAR
      IT  = NTMASS
      ITZ = NTCHAR
      IJPROJ = IDP
      IBPROJ = IIBAR(IJPROJ)

c calculate nuclear potentials (common /DTNPOT/)
      CALL DT_NCLPOT(IPZ,IP,ITZ,IT,ZERO,ZERO,0)

c initialize treatment for residual nuclei
      CALL DT_RESNCL(EPN,NLOOP,1)

c sample hadron/nucleus-nucleus interaction
      CALL DT_KKEVNT(KKMAT,IREJ1)
      IF (IREJ1.GT.0) THEN
         IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in KKINC'
         GOTO 9999
      ENDIF

      IF ((NPMASS.GT.1).OR.(NTMASS.GT.1)) THEN

c intranuclear cascade of final state particles for KTAUGE generations
c of secondaries
         CALL DT_FOZOCA(LFZC,IREJ1)
         IF (IREJ1.GT.0) THEN
            IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 2 in KKINC'
            GOTO 9999
         ENDIF

c baryons unable to escape the nuclear potential are treated as
c excited nucleons (ISTHKK=15,16)
         CALL DT_SCN4BA

c decay of resonances produced in intranuclear cascade processes
c*sr 15-11-95 should be obsolete
C        IF (LFZC) CALL DT_DECAY1

  101    CONTINUE
c treatment of residual nuclei
         CALL DT_RESNCL(EPN,NLOOP,2)

c evaporation / fission / fragmentation
c (if intranuclear cascade was sampled only)
         IF (LFZC) THEN
            CALL DT_FICONF(IJPROJ,IP,IPZ,IT,ITZ,NLOOP,IREJ1)
            IF (IREJ1.GT.1) GOTO 101
            IF (IREJ1.EQ.1) GOTO 100
         ENDIF

      ENDIF

c transform finale state into Lab.
      IFLAG = 2
      CALL DT_BEAMPR(WHAT,DUM,IFLAG)
      IF ((IFRAME.EQ.1).AND.(IFLAG.EQ.-1)) CALL DT_LT2LAB

      IF (IPI0.EQ.1) CALL DT_DECPI0

C     IF (NEVHKK.EQ.5) CALL DT_EVTOUT(4)

      RETURN
 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===defaul=============================================================*
c
CDECK  ID>, DT_DEFAUL
      SUBROUTINE DT_DEFAUL(EPN,PPN)

c***********************************************************************
c Variables are set to default values.                                 *
c This version dated 8.5.95 is written by S. Roesler.                  *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY10=1.0D-10)
      PARAMETER (TWOPI  = 6.283185307179586454D+00)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c interface HADRIN-DPM
      COMMON /HNTHRE/ EHADTH,EHADLO,EHADHI,INTHAD,IDXTA

c central particle production, impact parameter biasing
      COMMON /DTIMPA/ BIMIN,BIMAX,XSFRAC,ICENTR

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c parameter for intranuclear cascade
      LOGICAL LPAULI
      COMMON /DTFOTI/ TAUFOR,KTAUGE,ITAUVE,INCMOD,LPAULI

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT

c threshold values for x-sampling (DTUNUC 1.x)
      COMMON /DTXCUT/ XSEACU,UNON,UNOM,UNOSEA,CVQ,CDQ,CSEA,SSMIMA,
     &                SSMIMQ,VVMTHR

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c n-n cross section fluctuations
      PARAMETER (NBINS = 1000)
      COMMON /DTXSFL/ FLUIXX(NBINS),IFLUCT

c flags for particle decays
      COMMON /DTFRPA/ MSTUX(20),PARUX(20),MSTJX(20),PARJX(20),
     &                IMSTU(20),IPARU(20),IMSTJ(20),IPARJ(20),
     &                NMSTU,NPARU,NMSTJ,NPARJ,PDB,PDBSEA(3),ISIG0,IPI0

c diquark-breaking mechanism
      COMMON /DTDIQB/ DBRKR(3,8),DBRKA(3,8),CHAM1,CHAM3,CHAB1,CHAB3

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD

c kinematical cuts for lepton-nucleus interactions
      COMMON /DTLCUT/ ECMIN,ECMAX,XBJMIN,ELMIN,EGMIN,EGMAX,YMIN,YMAX,
     &                Q2MIN,Q2MAX,THMIN,THMAX,Q2LI,Q2HI,ECMLI,ECMHI

c flags for activated histograms
      COMMON /DTHIS3/ IHISPP(50),IHISXS(50),IXSTBL

c cuts for variable energy runs
      COMMON /DTVARE/ VARELO,VAREHI,VARCLO,VARCHI

c parameters for hA-diffraction
      COMMON /DTDIHA/ DIBETA,DIALPH

c LEPTO
      REAL RPPN
      COMMON /LEPTOI/ RPPN,LEPIN,INTER

c steering flags for qel neutrino scattering modules
      COMMON /QNEUTO/ DSIGSU,DSIGMC,NDSIG,NEUTYP,NEUDEC

c event flag
      COMMON /DTEVNO/ NEVENT,ICASCA


      DATA POTMES /0.002D0/

c common /DTNPOT/
      DO 10 I=1,2
         PFERMP(I) = ZERO
         PFERMN(I) = ZERO
         EBINDP(I) = ZERO
         EBINDN(I) = ZERO
         DO 11 J=1,210
            EPOT(I,J) = ZERO
   11    CONTINUE
c nucleus independent meson potential
         EPOT(I,13) = POTMES
         EPOT(I,14) = POTMES
         EPOT(I,15) = POTMES
         EPOT(I,16) = POTMES
         EPOT(I,23) = POTMES
         EPOT(I,24) = POTMES
         EPOT(I,25) = POTMES
   10 CONTINUE
c*sr 7.4.98: changed after corrected B-sampling
C     FERMOD    = 0.55D0
      FERMOD    = 0.68D0
      ETACOU(1) = ZERO
      ETACOU(2) = ZERO
      ICOUL     = 1
      LFERMI    = .TRUE.

c common /HNTHRE/
      EHADTH = -99.0D0
      EHADLO = 4.06D0
      EHADHI = 6.0D0
      INTHAD = 1
      IDXTA  = 2

c common /DTIMPA/
      ICENTR = 0
      BIMIN  = ZERO
      BIMAX  = 1.0D10
      XSFRAC = 1.0D0

c common /DTPRTA/
      IP  = 1
      IPZ = 1
      IT  = 1
      ITZ = 1
      IJPROJ = 1
      IBPROJ = 1
      IJTARG = 1
      IBTARG = 1
c common /DTGPRO/
      VIRT = ZERO
      DO 14 I=1,4
         PGAMM(I)  = ZERO
         PLEPT0(I) = ZERO
         PLEPT1(I) = ZERO
         PNUCL(I)  = ZERO
   14 CONTINUE
      IDIREC   = 0

c common /DTCOMP/
      NCOMPO = 0
      IEMUL  = 0
      DO 12 I=1,NCOMPX
         EMUFRA(I) = ZERO
         IEMUMA(I) = 1
         IEMUCH(I) = 1
   12 CONTINUE

c common /DTFOTI/
c*sr 7.4.98: changed after corrected B-sampling
C     TAUFOR = 4.4D0
      TAUFOR = 3.1D0
      KTAUGE = 25
      ITAUVE = 1
      INCMOD = 1
      LPAULI = .TRUE.

c common /DTCHAI/
      SEASQ  = ONE
      MKCRON = 1
      CRONCO = 0.64D0
      ISICHA = 0
      CUTOF  = 100.0D0
      LCO2CR = .FALSE.
      IRECOM = 1
      LINTPT = .TRUE.

c common /DTXCUT/
c  definition of soft quark distributions
      XSEACU = 0.05D0
      UNON   = 2.0D0
      UNOM   = 1.5D0
      UNOSEA = 5.0D0
c  cutoff parameters for x-sampling
      CVQ    = 1.0D0
      CDQ    = 2.0D0
C     CSEA   = 0.3D0
      CSEA   = 0.1D0
      SSMIMA = 1.2D0
      SSMIMQ = SSMIMA**2
      VVMTHR = 2.0D0

c common /DTFLG1/
      IFRAG(1) = 2
      IFRAG(2) = 1
      IRESCO   = 1
      IMSHL    = 1
      IRESRJ   = 0
      LEMCCK   = .FALSE.
      LHADRO(0) = .FALSE.
      DO 13 I=1,9
         LHADRO(I) = .TRUE.
         IF (I.LE.6) IOULEV(I) = -1
   13 CONTINUE
      LSEADI = .TRUE.
      LEVAPO = .TRUE.
      IFRAME = 1

c common /DTXSFL/
      IFLUCT = 0

c common /DTFRPA/
      PDB = 0.15D0
      PDBSEA(1) = 0.0D0
      PDBSEA(2) = 0.0D0
      PDBSEA(3) = 0.0D0
      ISIG0 = 0
      IPI0  = 0
      NMSTU = 0
      NPARU = 0
      NMSTJ = 0
      NPARJ = 0

c common /DTDIQB/
      DO 15 I=1,8
         DBRKR(1,I) = 5.0D0
         DBRKR(2,I) = 5.0D0
         DBRKR(3,I) = 10.0D0
         DBRKA(1,I) = ZERO
         DBRKA(2,I) = ZERO
         DBRKA(3,I) = ZERO
   15 CONTINUE
      CHAM1 = 0.2D0
      CHAM3 = 0.5D0
      CHAB1 = 0.7D0
      CHAB3 = 1.0D0

c common /DTFLG3/
      ISINGD = 0
      IDOUBD = 0
      IFLAGD = 0
      IDIFF  = 0

c common /DTMODL/
      MCGENE    = 2
      CMODEL(1) = 'DTUNUC  '
      CMODEL(2) = 'PHOJET  '
      CMODEL(3) = 'LEPTO   '
      CMODEL(4) = 'QNEUTRIN'
      LPHOIN    = .TRUE.
      ELOJET    = 5.0D0

c common /DTLCUT/
      ECMIN  = 3.5D0
      ECMAX  = 1.0D10
      XBJMIN = ZERO
      ELMIN = ZERO
      EGMIN = ZERO
      EGMAX = 1.0D10
      YMIN  = TINY10
      YMAX  = 0.999D0
      Q2MIN = TINY10
      Q2MAX = 10.0D0
      THMIN = ZERO
      THMAX = TWOPI
      Q2LI  = ZERO
      Q2HI  = 1.0D10
      ECMLI = ZERO
      ECMHI = 1.0D10

c common /DTVDMP/
      RL2       = 2.0D0
      INTRGE(1) = 1
      INTRGE(2) = 3
      IDPDF     = 2212
      MODEGA    = 4
      ISHAD(1)  = 1
      ISHAD(2)  = 1
      ISHAD(3)  = 1
      EPSPOL    = ZERO

c common /DTGLGP/
      JSTATB = 1000
      JBINSB = 49
      CGLB   = '        '
      IOGLB  = 0
      LPROD  = .TRUE.

c common /DTHIS3/
      DO 16 I=1,50
         IHISPP(I) = 0
         IHISXS(I) = 0
   16 CONTINUE
      IXSTBL = 0

c common /DTVARE/
      VARELO = ZERO
      VAREHI = ZERO
      VARCLO = ZERO
      VARCHI = ZERO

c common /DTDIHA/
      DIBETA = -1.0D0
      DIALPH = ZERO

c common /LEPTOI/
      RPPN  = 0.0
      LEPIN = 0
      INTER = 0

c common /QNEUTO/
      NEUTYP = 1
      NEUDEC = 0

c common /DTEVNO/
      NEVENT = 1
      ICASCA = 0

c default Lab.-energy
      EPN = 200.0D0
      PPN = SQRT((EPN-AAM(IJPROJ))*(EPN+AAM(IJPROJ)))

      RETURN
      END
c
c===aaevt==============================================================*
c
CDECK  ID>, DT_AAEVT
      SUBROUTINE DT_AAEVT(NEVTS,EPN,NPMASS,NPCHAR,NTMASS,NTCHAR,
     &                                             IDP,IGLAU)

c***********************************************************************
c This version dated 22.03.96 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c event flag
      COMMON /DTEVNO/ NEVENT,ICASCA


      CHARACTER*8 DATE,HHMMSS
      DIMENSION IDMNYR(3)

      KKMAT  = 1
      NMSG   = MAX(NEVTS/100,1)

c initialization of run-statistics and histograms
      CALL DT_STATIS(1)

      CALL PHO_PHIST(1000,DUM)


c initialization of Glauber-formalism
      IF (NCOMPO.LE.0) THEN
         CALL DT_SHMAKI(NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,EPN,IGLAU)
      ELSE
         DO 1 I=1,NCOMPO
            CALL DT_SHMAKI(NPMASS,NPCHAR,IEMUMA(I),IEMUCH(I),IDP,EPN,0)
    1    CONTINUE
      ENDIF
      CALL DT_SIGEMU

      CALL IDATE(IDMNYR)
      WRITE(DATE,'(I2,''/'',I2,''/'',I2)')
     &   IDMNYR(1),IDMNYR(2),MOD(IDMNYR(3),100)
      CALL ITIME(IDMNYR)
      WRITE(HHMMSS,'(I2,'':'',I2,'':'',I2)')
     &   IDMNYR(1),IDMNYR(2),IDMNYR(3)
      WRITE(ErrorOut,1001) DATE,HHMMSS
 1001 FORMAT(/,' DT_AAEVT: INITIALISATION FINISHED. ( DATE: ',A8,
     &       '   TIME: ',A8,' )')

c generate NEVTS events
      DO 2 IEVT=1,NEVTS

c  print run-status message
         IF (MOD(IEVT,NMSG).EQ.0) THEN
            CALL IDATE(IDMNYR)
            WRITE(DATE,'(I2,''/'',I2,''/'',I2)')
     &         IDMNYR(1),IDMNYR(2),MOD(IDMNYR(3),100)
            CALL ITIME(IDMNYR)
            WRITE(HHMMSS,'(I2,'':'',I2,'':'',I2)')
     &         IDMNYR(1),IDMNYR(2),IDMNYR(3)
            WRITE(ErrorOut,1000) IEVT-1,NEVTS,DATE,HHMMSS
 1000       FORMAT(/,1X,I8,' OUT OF ',I8,' EVENTS SAMPLED ( DATE: ',A,
     &             '   TIME: ',A,' )',/)
C           WRITE(LOUT,1000) IEVT-1
C1000       FORMAT(1X,I8,' events sampled')
         ENDIF
         NEVENT = IEVT
c  treat nuclear emulsions
         IF (IEMUL.GT.0) CALL DT_GETEMU(NTMASS,NTCHAR,KKMAT,0)
c  composite targets only
         KKMAT = -KKMAT
c  sample this event
         CALL DT_KKINC(NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,EPN,KKMAT,IREJ)


         CALL PHO_PHIST(2000,DUM)


    2 CONTINUE

c print run-statistics and histograms to output-unit 6

      CALL PHO_PHIST(3000,DUM)

      CALL DT_STATIS(2)

      RETURN
      END
c
c===laevt==============================================================*
c
CDECK  ID>, DT_LAEVT
      SUBROUTINE DT_LAEVT(NEVTS,EPN,NPMASS,NPCHAR,NTMASS,NTCHAR,
     &                                             IDP,IGLAU)

c***********************************************************************
c Interface to run DPMJET for lepton-nucleus interactions.             *
c Kinematics is sampled using the equivalent photon approximation      *
c Based on GPHERA-routine by R. Engel.                                 *
c This version dated 23.03.96 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY4=1.0D-4,
     &           ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,THREE=3.0D0)
      PARAMETER (TWOPI  = 6.283185307179586454D+00,
     &           PI     = TWOPI/TWO,
     &           ALPHEM = ONE/137.0D0)

C     CHARACTER*72 HEADER

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c kinematical cuts for lepton-nucleus interactions
      COMMON /DTLCUT/ ECMIN,ECMAX,XBJMIN,ELMIN,EGMIN,EGMAX,YMIN,YMAX,
     &                Q2MIN,Q2MAX,THMIN,THMAX,Q2LI,Q2HI,ECMLI,ECMHI

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c kinematics at lepton-gamma vertex
      COMMON /DTLGVX/ PPL0(4),PPL1(4),PPG(4),PPA(4)

c flags for activated histograms
      COMMON /DTHIS3/ IHISPP(50),IHISXS(50),IXSTBL

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c event flag
      COMMON /DTEVNO/ NEVENT,ICASCA


      DIMENSION XDUMB(40),BGTA(4)

c LEPTO
      IF (MCGENE.EQ.3) THEN

         STOP ' THIS VERSION DOES NOT CONTAIN LEPTO !'

      ENDIF

      KKMAT  = 1
      NMSG   = MAX(NEVTS/10,1)

c mass of incident lepton
      AMLPT  = AAM(IDP)
      AMLPT2 = AMLPT**2
      IDPPDG = IDT_IPDGHA(IDP)

c consistency of kinematical limits
      Q2MIN  = MAX(Q2MIN,TINY10)
      Q2MAX  = MAX(Q2MAX,TINY10)
      YMIN   = MIN(MAX(YMIN,TINY10),0.999D0)
      YMAX   = MIN(MAX(YMAX,TINY10),0.999D0)

c total energy of the lepton-nucleon system
      PTOTLN = SQRT( (PLEPT0(1)+PNUCL(1))**2+(PLEPT0(2)+PNUCL(2))**2
     &                                      +(PLEPT0(3)+PNUCL(3))**2 )
      ETOTLN = PLEPT0(4)+PNUCL(4)
      ECMLN  = SQRT((ETOTLN-PTOTLN)*(ETOTLN+PTOTLN))
      ECMAX  = MIN(ECMAX,ECMLN)
      WRITE(ErrorOut,
     * 1003) ECMIN,ECMAX,YMIN,YMAX,Q2MIN,Q2MAX,EGMIN,
     &                 THMIN,THMAX,ELMIN
 1003 FORMAT(1X,'LAEVT:',16X,'KINEMATICAL CUTS',/,22X,
     &       '------------------',/,9X,'W (MIN)   =',
     &       F7.1,' GEV    (MAX) =',F7.1,' GEV',/,9X,'Y (MIN)   =',
     &       F7.3,8X,'(MAX) =',F7.3,/,9X,'Q^2 (MIN) =',F7.1,
     &       ' GEV^2  (MAX) =',F7.1,' GEV^2',/,' (LAB)   E_G (MIN) ='
     &       ,F7.1,' GEV',/,' (LAB) THETA (MIN) =',F7.4,8X,'(MAX) =',
     &       F7.4,'   FOR E_LPT >',F7.1,' GEV',/)

c Lorentz-parameter for transf. into Lab
      BGTA(1) = PNUCL(1)/AAM(1)
      BGTA(2) = PNUCL(2)/AAM(1)
      BGTA(3) = PNUCL(3)/AAM(1)
      BGTA(4) = PNUCL(4)/AAM(1)
c LT of incident lepton into Lab and dump it in DTEVT1
      CALL DT_DALTRA(BGTA(4),-BGTA(1),-BGTA(2),-BGTA(3),
     &            PLEPT0(1),PLEPT0(2),PLEPT0(3),PLEPT0(4),
     &            PLTOT,PPL0(1),PPL0(2),PPL0(3),PPL0(4))
      CALL DT_DALTRA(BGTA(4),-BGTA(1),-BGTA(2),-BGTA(3),
     &            PNUCL(1),PNUCL(2),PNUCL(3),PNUCL(4),
     &            PLTOT,PPA(1),PPA(2),PPA(3),PPA(4))
c maximum energy of photon nucleon system
      PTOTGN = SQRT((YMAX*PPL0(1)+PPA(1))**2+(YMAX*PPL0(2)+PPA(2))**2
     &                                      +(YMAX*PPL0(3)+PPA(3))**2)
      ETOTGN = YMAX*PPL0(4)+PPA(4)
      EGNMAX = SQRT((ETOTGN-PTOTGN)*(ETOTGN+PTOTGN))
      EGNMAX = MIN(EGNMAX,ECMAX)
c minimum energy of photon nucleon system
      PTOTGN = SQRT((YMIN*PPL0(1)+PPA(1))**2+(YMIN*PPL0(2)+PPA(2))**2
     &                                      +(YMIN*PPL0(3)+PPA(3))**2)
      ETOTGN = YMIN*PPL0(4)+PPA(4)
      EGNMIN = SQRT((ETOTGN-PTOTGN)*(ETOTGN+PTOTGN))
      EGNMIN = MAX(EGNMIN,ECMIN)

c limits for Glauber-initialization
      Q2LI  = Q2MIN
      Q2HI  = MAX(Q2LI,MIN(Q2HI,Q2MAX))
      ECMLI = MAX(EGNMIN,THREE)
      ECMHI = EGNMAX
      WRITE(ErrorOut,1004) EGNMIN,EGNMAX,ECMLI,ECMHI,Q2LI,Q2HI
 1004 FORMAT(1X,'RESULTING LIMITS:',/,9X,'W (MIN)   =',F7.1,
     &       ' GEV    (MAX) =',F7.1,' GEV',/,/,' LIMITS FOR ',
     &       'GLAUBER-INITIALIZATION:',/,9X,'W (MIN)   =',F7.1,
     &       ' GEV    (MAX) =',F7.1,' GEV',/,9X,'Q^2 (MIN) =',F7.1,
     &       ' GEV^2  (MAX) =',F7.1,' GEV^2',/)
c initialization of Glauber-formalism
      IF (NCOMPO.LE.0) THEN
         CALL DT_SHMAKI(NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,EPN,IGLAU)
      ELSE
         DO 9 I=1,NCOMPO
            CALL DT_SHMAKI(NPMASS,NPCHAR,IEMUMA(I),IEMUCH(I),IDP,EPN,0)
    9    CONTINUE
      ENDIF
      CALL DT_SIGEMU

c initialization of run-statistics and histograms
      CALL DT_STATIS(1)

      CALL PHO_PHIST(1000,DUM)


c maximum photon-nucleus cross section
      I1  = 1
      I2  = 1
      RAT = ONE
      IF (EGNMAX.GE.ECMNN(NEBINI)) THEN
         I1  = NEBINI
         I2  = NEBINI
         RAT = ONE
      ELSEIF (EGNMAX.GT.ECMNN(1)) THEN
         DO 5 I=2,NEBINI
            IF (EGNMAX.LT.ECMNN(I)) THEN
               I1  = I-1
               I2  = I
               RAT = (EGNMAX-ECMNN(I1))/(ECMNN(I2)-ECMNN(I1))
               GOTO 6
            ENDIF
    5    CONTINUE
    6    CONTINUE
      ENDIF
      SIGMAX = XSTOT(I1,1,1)+RAT*(XSTOT(I2,1,1)-XSTOT(I1,1,1))
      EGNXX  = EGNMAX
      I1  = 1
      I2  = 1
      RAT = ONE
      IF (EGNMIN.GE.ECMNN(NEBINI)) THEN
         I1  = NEBINI
         I2  = NEBINI
         RAT = ONE
      ELSEIF (EGNMIN.GT.ECMNN(1)) THEN
         DO 7 I=2,NEBINI
            IF (EGNMIN.LT.ECMNN(I)) THEN
               I1  = I-1
               I2  = I
               RAT = (EGNMIN-ECMNN(I1))/(ECMNN(I2)-ECMNN(I1))
               GOTO 8
            ENDIF
    7    CONTINUE
    8    CONTINUE
      ENDIF
      SIGXX = XSTOT(I1,1,1)+RAT*(XSTOT(I2,1,1)-XSTOT(I1,1,1))
      IF (SIGXX.GT.SIGMAX) EGNXX = EGNMIN
      SIGMAX = MAX(SIGMAX,SIGXX)
      WRITE(ErrorOut,
     * '(9X,A,F8.3,A)') 'Sigma_tot (max) =',SIGMAX,' mb'

c plot photon flux table
      AYMIN = LOG(YMIN)
      AYMAX = LOG(YMAX)
      AYRGE = AYMAX-AYMIN
      MAXTAB = 50
      ADY    = LOG(YMAX/YMIN)/DBLE(MAXTAB-1)
C     WRITE(LOUT,'(/,1X,A)') 'LAEVT:   photon flux '
      DO 1 I=1,MAXTAB
         Y     = EXP(AYMIN+ADY*DBLE(I-1))
         Q2LOW = MAX(Q2MIN,AMLPT2*Y**2/(ONE-Y))
         FF1   = ALPHEM/TWOPI * ((ONE+(ONE-Y)**2)/Y*LOG(Q2MAX/Q2LOW)
     &                           -TWO*AMLPT2*Y*(ONE/Q2LOW-ONE/Q2MAX))
         FF2   = ALPHEM/TWOPI * ((ONE+(ONE-Y)**2)/Y*LOG(Q2MAX/Q2LOW)
     &                           -TWO*(ONE-Y)/Y*(ONE-Q2LOW/Q2MAX))
C        WRITE(LOUT,'(5X,3E15.4)') Y,FF1,FF2
    1 CONTINUE

c maximum residual weight for flux sampling (dy/y)
      YY     = YMIN
      Q2LOW  = MAX(Q2MIN,AMLPT2*YY**2/(ONE-YY))
      WGHMAX = (ONE+(ONE-YY)**2)*LOG(Q2MAX/Q2LOW)
     &         -TWO*AMLPT2*YY*(ONE/Q2LOW-ONE/Q2MAX)*YY

      CALL DT_NEWHGR(YMIN,YMAX,ZERO,XDUMB,49,IHFLY0)
      CALL DT_NEWHGR(YMIN,YMAX,ZERO,XDUMB,49,IHFLY1)
      CALL DT_NEWHGR(YMIN,YMAX,ZERO,XDUMB,49,IHFLY2)
      CALL DT_NEWHGR(Q2LOW,Q2MAX,ZERO,XDUMB,20,IHFLQ0)
      CALL DT_NEWHGR(Q2LOW,Q2MAX,ZERO,XDUMB,20,IHFLQ1)
      CALL DT_NEWHGR(Q2LOW,Q2MAX,ZERO,XDUMB,20,IHFLQ2)
      CALL DT_NEWHGR(EGNMIN,EGNMAX,ZERO,XDUMB,20,IHFLE0)
      CALL DT_NEWHGR(EGNMIN,EGNMAX,ZERO,XDUMB,20,IHFLE1)
      CALL DT_NEWHGR(EGNMIN,EGNMAX,ZERO,XDUMB,20,IHFLE2)
      CALL DT_NEWHGR(ZERO,EGMAX,ZERO,XDUMB,20,IHFLU0)
      CALL DT_NEWHGR(ZERO,EGMAX,ZERO,XDUMB,20,IHFLU1)
      CALL DT_NEWHGR(ZERO,EGMAX,ZERO,XDUMB,20,IHFLU2)
      XBLOW = 0.001D0
      CALL DT_NEWHGR(XBLOW,ONE,ZERO,XDUMB,-40,IHFLX0)
      CALL DT_NEWHGR(XBLOW,ONE,ZERO,XDUMB,-40,IHFLX1)
      CALL DT_NEWHGR(XBLOW,ONE,ZERO,XDUMB,-40,IHFLX2)

      ITRY = 0
      ITRW = 0
      NC0  = 0
      NC1  = 0

c generate events
      DO 2 IEVT=1,NEVTS
         IF (MOD(IEVT,NMSG).EQ.0) THEN
C           OPEN(LLOOK,FILE='/scrtch3/hr/sroesler/statusd5.out',
C    &                                         STATUS='UNKNOWN')
            WRITE(ErrorOut,'(1X,I8,A)') IEVT-1,' events sampled'
C           CLOSE(LLOOK)
         ENDIF
         NEVENT = IEVT

  100    CONTINUE
         ITRY = ITRY+1

c  sample y
  101    CONTINUE
         ITRW  = ITRW+1
         YY    = EXP(AYRGE*DT_RNDM(RAT)+AYMIN)
         Q2LOW = MAX(Q2MIN,AMLPT2*YY**2/(ONE-YY))
         Q2LOG = LOG(Q2MAX/Q2LOW)
         WGH   = (ONE+(ONE-YY)**2)*Q2LOG
     &           -TWO*AMLPT2*YY*(ONE/Q2LOW-ONE/Q2MAX)*YY
         IF (WGHMAX.LT.WGH) WRITE(ErrorOut,1000) YY,WGHMAX,WGH
 1000    FORMAT(1X,'LAEVT:   WEIGHT ERROR!',3E12.5)
         IF (DT_RNDM(YY)*WGHMAX.GT.WGH) GOTO 101

c  sample Q2
         YEFF = ONE+(ONE-YY)**2
  102    CONTINUE
         Q2  = Q2LOW*EXP(Q2LOG*DT_RNDM(YY))
         WGH = (YEFF-TWO*(ONE-YY)*Q2LOW/Q2)/YEFF
         IF (WGH.LT.DT_RNDM(Q2)) GOTO 102

c        NC0 = NC0+1
c        CALL DT_FILHGR(YY,ONE,IHFLY0,NC0)
c        CALL DT_FILHGR(Q2,ONE,IHFLQ0,NC0)

c  kinematics at lepton-photon vertex
c   scattered electron
         YQ2 = SQRT((ONE-YY)*Q2)
         Q2E = Q2/(4.0D0*PLEPT0(4))
         E1Y = (ONE-YY)*PLEPT0(4)
         CALL DT_DSFECF(SIF,COF)
         PLEPT1(1) = YQ2*COF
         PLEPT1(2) = YQ2*SIF
         PLEPT1(3) = E1Y-Q2E
         PLEPT1(4) = E1Y+Q2E
C        THETA = ACOS( (E1Y-Q2E)/(E1Y+Q2E) )
c   radiated photon
         PGAMM(1) = -PLEPT1(1)
         PGAMM(2) = -PLEPT1(2)
         PGAMM(3) = PLEPT0(3)-PLEPT1(3)
         PGAMM(4) = PLEPT0(4)-PLEPT1(4)
c   E_cm cut
         PTOTGN = SQRT( (PGAMM(1)+PNUCL(1))**2+(PGAMM(2)+PNUCL(2))**2
     &                                        +(PGAMM(3)+PNUCL(3))**2 )
         ETOTGN = PGAMM(4)+PNUCL(4)
         ECMGN  = (ETOTGN-PTOTGN)*(ETOTGN+PTOTGN)
         IF (ECMGN.LT.0.1D0) GOTO 101
         ECMGN  = SQRT(ECMGN)
         IF ((ECMGN.LT.ECMIN).OR.(ECMGN.GT.ECMAX)) GOTO 101

c  Lorentz-transformation into nucleon-rest system
         CALL DT_DALTRA(BGTA(4),-BGTA(1),-BGTA(2),-BGTA(3),
     &               PGAMM(1),PGAMM(2),PGAMM(3),PGAMM(4),
     &               PGTOT,PPG(1),PPG(2),PPG(3),PPG(4))
         CALL DT_DALTRA(BGTA(4),-BGTA(1),-BGTA(2),-BGTA(3),
     &               PLEPT1(1),PLEPT1(2),PLEPT1(3),PLEPT1(4),
     &               PLTOT,PPL1(1),PPL1(2),PPL1(3),PPL1(4))
c  temporary checks..
         Q2TMP = ABS(PPG(4)**2-PGTOT**2)
         IF (ABS(Q2-Q2TMP).GT.0.01D0) WRITE(ErrorOut,
     * 1001) Q2,Q2TMP
 1001    FORMAT(1X,'LAEVT:    INCONSISTENT KINEMATICS (Q2,Q2TMP) ',
     &          2F10.4)
         ECMTMP = SQRT((PPG(4)+AAM(1)-PGTOT)*(PPG(4)+AAM(1)+PGTOT))
         IF (ABS(ECMGN-ECMTMP).GT.TINY10) WRITE(ErrorOut,
     * 1002) ECMGN,ECMTMP
 1002    FORMAT(1X,'LAEVT:    INCONSISTENT KINEMATICS (ECMGN,ECMTMP) ',
     &          2F10.2)
         YYTMP = PPG(4)/PPL0(4)
         IF (ABS(YY-YYTMP).GT.0.01D0) WRITE(ErrorOut,
     * 1005) YY,YYTMP
 1005    FORMAT(1X,'LAEVT:    INCONSISTENT KINEMATICS (YY,YYTMP) ',
     &          2F10.4)

c  lepton tagger (Lab)
         THETA = ACOS( PPL1(3)/PLTOT )
         IF (PPL1(4).GT.ELMIN) THEN
            IF ((THETA.LT.THMIN).OR.(THETA.GT.THMAX)) GOTO 101
         ENDIF
c  photon energy-cut (Lab)
         IF (PPG(4).LT.EGMIN) GOTO 101
         IF (PPG(4).GT.EGMAX) GOTO 101
c   x_Bj cut
         XBJ = ABS(Q2/(1.876D0*PPG(4)))
         IF (XBJ.LT.XBJMIN) GOTO 101

         NC0 = NC0+1
         CALL DT_FILHGR(    Q2,ONE,IHFLQ0,NC0)
         CALL DT_FILHGR(    YY,ONE,IHFLY0,NC0)
         CALL DT_FILHGR(   XBJ,ONE,IHFLX0,NC0)
         CALL DT_FILHGR(PPG(4),ONE,IHFLU0,NC0)
         CALL DT_FILHGR( ECMGN,ONE,IHFLE0,NC0)

c  rotation angles against z-axis
         COD = PPG(3)/PGTOT
C        SID = SQRT((ONE-COD)*(ONE+COD))
         PPT = SQRT(PPG(1)**2+PPG(2)**2)
         SID = PPT/PGTOT
         COF = ONE
         SIF = ZERO
         IF (PGTOT*SID.GT.TINY10) THEN
            COF   = PPG(1)/(SID*PGTOT)
            SIF   = PPG(2)/(SID*PGTOT)
            ANORF = SQRT(COF*COF+SIF*SIF)
            COF   = COF/ANORF
            SIF   = SIF/ANORF
         ENDIF

         IF (IXSTBL.EQ.0) THEN
c  change to photon projectile
            IJPROJ = 7
c  set virtuality
            VIRT = Q2
c  re-initialize LTs with new kinematics
c  !!PGAMM ist set in cms (ECMGN) along z
            EPN = ZERO
            PPN = ZERO
            CALL DT_LTINI(IJPROJ,IJTARG,EPN,PPN,ECMGN,0)
c  force Lab-system
            IFRAME = 1
c  get emulsion component if requested
            IF (IEMUL.GT.0) CALL DT_GETEMU(NTMASS,NTCHAR,KKMAT,0)
c  convolute with cross section
            CALL DT_SIGGAT(Q2LOW,EGNXX,STOTX,KKMAT)
            CALL DT_SIGGAT(Q2,ECMGN,STOT,KKMAT)
            IF (STOTX.LT.STOT) WRITE(ErrorOut,'(1X,A,/,6E12.3)')
     &         'LAEVT: WARNING STOTX<STOT ! ',Q2LOW,EGNMAX,STOTX,
     &                                        Q2,ECMGN,STOT
            IF (DT_RNDM(Q2)*STOTX.GT.STOT) GOTO 100
            NC1 = NC1+1
            CALL DT_FILHGR(    Q2,ONE,IHFLQ1,NC1)
            CALL DT_FILHGR(    YY,ONE,IHFLY1,NC1)
            CALL DT_FILHGR(   XBJ,ONE,IHFLX1,NC1)
            CALL DT_FILHGR(PPG(4),ONE,IHFLU1,NC1)
            CALL DT_FILHGR( ECMGN,ONE,IHFLE1,NC1)
c  composite targets only
            KKMAT = -KKMAT
c  sample this event
            CALL DT_KKINC(NPMASS,NPCHAR,NTMASS,NTCHAR,IJPROJ,EPN,KKMAT,
     &                                                            IREJ)
c  rotate momenta of final state particles back in photon-nucleon syst.
            DO 4 I=NPOINT(4),NHKK
               IF ((ABS(ISTHKK(I)).EQ.1).OR.(ISTHKK(I).EQ.1000).OR.
     &                                      (ISTHKK(I).EQ.1001)) THEN
                  PX = PHKK(1,I)
                  PY = PHKK(2,I)
                  PZ = PHKK(3,I)
                  CALL DT_MYTRAN(1,PX,PY,PZ,COD,SID,COF,SIF,
     &                        PHKK(1,I),PHKK(2,I),PHKK(3,I))
               ENDIF
    4       CONTINUE
         ENDIF

         CALL DT_FILHGR(    Q2,ONE,IHFLQ2,NC1)
         CALL DT_FILHGR(    YY,ONE,IHFLY2,NC1)
         CALL DT_FILHGR(   XBJ,ONE,IHFLX2,NC1)
         CALL DT_FILHGR(PPG(4),ONE,IHFLU2,NC1)
         CALL DT_FILHGR( ECMGN,ONE,IHFLE2,NC1)

c  dump this event to histograms

         CALL PHO_PHIST(2000,DUM)


    2 CONTINUE

      WGY    = ALPHEM/TWOPI*WGHMAX*DBLE(ITRY)/DBLE(ITRW)
      WGY    = WGY*LOG(YMAX/YMIN)
      WEIGHT = WGY*SIGMAX*DBLE(NEVTS)/DBLE(ITRY)

C     HEADER = ' LAEVT:  Q^2 distribution 0'
C     CALL DT_OUTHGR(IHFLQ0,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  Q^2 distribution 1'
C     CALL DT_OUTHGR(IHFLQ1,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  Q^2 distribution 2'
C     CALL DT_OUTHGR(IHFLQ2,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  y   distribution 0'
C     CALL DT_OUTHGR(IHFLY0,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  y   distribution 1'
C     CALL DT_OUTHGR(IHFLY1,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  y   distribution 2'
C     CALL DT_OUTHGR(IHFLY2,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  x   distribution 0'
C     CALL DT_OUTHGR(IHFLX0,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  x   distribution 1'
C     CALL DT_OUTHGR(IHFLX1,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  x   distribution 2'
C     CALL DT_OUTHGR(IHFLX2,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  E_g distribution 0'
C     CALL DT_OUTHGR(IHFLU0,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  E_g distribution 1'
C     CALL DT_OUTHGR(IHFLU1,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  E_g distribution 2'
C     CALL DT_OUTHGR(IHFLU2,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  E_c distribution 0'
C     CALL DT_OUTHGR(IHFLE0,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  E_c distribution 1'
C     CALL DT_OUTHGR(IHFLE1,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  E_c distribution 2'
C     CALL DT_OUTHGR(IHFLE2,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)

c print run-statistics and histograms to output-unit 6

      CALL PHO_PHIST(3000,DUM)

      IF (IXSTBL.EQ.0) CALL DT_STATIS(2)

      RETURN
      END
c
c===dtuini=============================================================*
c
CDECK  ID>, DT_DTUINI
      SUBROUTINE DT_DTUINI(NEVTS,EPN,NPMASS,NPCHAR,NTMASS,NTCHAR,
     &                                               IDP,IEMU)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD


      CALL DT_INIT(NEVTS,EPN,NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,IGLAU)
      CALL DT_STATIS(1)

      CALL PHO_PHIST(1000,DUM)

      IF (NCOMPO.LE.0) THEN
         CALL DT_SHMAKI(NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,EPN,IGLAU)
      ELSE
         DO 1 I=1,NCOMPO
            CALL DT_SHMAKI(NPMASS,NPCHAR,IEMUMA(I),IEMUCH(I),IDP,EPN,0)
    1    CONTINUE
      ENDIF
      IF (IOGLB.NE.100) CALL DT_SIGEMU
      IEMU = IEMUL

      RETURN
      END
c
c===dtuout=============================================================*
c
CDECK  ID>, DT_DTUOUT
      SUBROUTINE DT_DTUOUT

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE


      CALL PHO_PHIST(3000,DUM)

      CALL DT_STATIS(2)

      RETURN
      END
c
c===beam===============================================================*
c
CDECK  ID>, DT_BEAMPR
      SUBROUTINE DT_BEAMPR(WHAT,PLAB,MODE)

c***********************************************************************
c Initialization of event generation                                   *
c This version dated  7.4.98  is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (LIN=5,LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY10=1.0D-10)
      PARAMETER (TWOPI=6.283185307D0,BOG=TWOPI/360.0D0)

      LOGICAL LBEAM

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c beam momenta
      COMMON /DTBEAM/ P1(4),P2(4)


C     DIMENSION WHAT(6),P1(4),P2(4),P1CMS(4),P2CMS(4)
      DIMENSION WHAT(6),P1CMS(4),P2CMS(4)

      DATA LBEAM /.FALSE./

      GOTO (1,2) MODE

    1 CONTINUE

      E1  = WHAT(1)
      IF (E1.LT.ZERO) E1 = DBLE(IPZ)/DBLE(IP)*ABS(WHAT(1))
      E2  = WHAT(2)
      IF (E2.LT.ZERO) E2 = DBLE(ITZ)/DBLE(IT)*ABS(WHAT(2))
      PP1 = SQRT( (E1+AAM(IJPROJ))*(E1-AAM(IJPROJ)) )
      PP2 = SQRT( (E2+AAM(IJTARG))*(E2-AAM(IJTARG)) )
      TH  = 1.D-6*WHAT(3)/2.D0
      PH  = WHAT(4)*BOG
      P1(1) = PP1*SIN(TH)*COS(PH)
      P1(2) = PP1*SIN(TH)*SIN(PH)
      P1(3) = PP1*COS(TH)
      P1(4) = E1
      P2(1) = PP2*SIN(TH)*COS(PH)
      P2(2) = PP2*SIN(TH)*SIN(PH)
      P2(3) = -PP2*COS(TH)
      P2(4) = E2
      ECM  = SQRT( (P1(4)+P2(4))**2-(P1(1)+P2(1))**2-(P1(2)+P2(2))**2
     &                                              -(P1(3)+P2(3))**2 )
      ELAB = (ECM**2-AAM(IJPROJ)**2-AAM(IJTARG)**2)/(2.0D0*AAM(IJTARG))
      PLAB = SQRT( (ELAB+AAM(IJPROJ))*(ELAB-AAM(IJPROJ)) )
      BGX  = (P1(1)+P2(1))/ECM
      BGY  = (P1(2)+P2(2))/ECM
      BGZ  = (P1(3)+P2(3))/ECM
      BGE  = (P1(4)+P2(4))/ECM
      CALL DT_DALTRA(BGE,-BGX,-BGY,-BGZ,P1(1),P1(2),P1(3),P1(4),
     &            P1TOT,P1CMS(1),P1CMS(2),P1CMS(3),P1CMS(4))
      CALL DT_DALTRA(BGE,-BGX,-BGY,-BGZ,P2(1),P2(2),P2(3),P2(4),
     &            P2TOT,P2CMS(1),P2CMS(2),P2CMS(3),P2CMS(4))
      COD = P1CMS(3)/P1TOT
C     SID = SQRT((ONE-COD)*(ONE+COD))
      PPT = SQRT(P1CMS(1)**2+P1CMS(2)**2)
      SID = PPT/P1TOT
      COF = ONE
      SIF = ZERO
      IF (P1TOT*SID.GT.TINY10) THEN
         COF   = P1CMS(1)/(SID*P1TOT)
         SIF   = P1CMS(2)/(SID*P1TOT)
         ANORF = SQRT(COF*COF+SIF*SIF)
         COF   = COF/ANORF
         SIF   = SIF/ANORF
      ENDIF
c*check
C     WRITE(LOUT,'(4E15.4)') P1(1),P1(2),P1(3),P1(4)
C     WRITE(LOUT,'(4E15.4)') P2(1),P2(2),P2(3),P2(4)
C     WRITE(LOUT,'(5E15.4)') P1CMS(1),P1CMS(2),P1CMS(3),P1CMS(4),P1TOT
C     WRITE(LOUT,'(5E15.4)') P2CMS(1),P2CMS(2),P2CMS(3),P2CMS(4),P2TOT
C     PAX = ZERO
C     PAY = ZERO
C     PAZ = P1TOT
C     PAE = SQRT(AAM(IJPROJ)**2+PAZ**2)
C     PBX = ZERO
C     PBY = ZERO
C     PBZ = -P2TOT
C     PBE = SQRT(AAM(IJTARG)**2+PBZ**2)
C     WRITE(LOUT,'(4E15.4)') PAX,PAY,PAZ,PAE
C     WRITE(LOUT,'(4E15.4)') PBX,PBY,PBZ,PBE
C     CALL DT_MYTRAN(1,PAX,PAY,PAZ,COD,SID,COF,SIF,
C    &            P1CMS(1),P1CMS(2),P1CMS(3))
C     CALL DT_MYTRAN(1,PBX,PBY,PBZ,COD,SID,COF,SIF,
C    &            P2CMS(1),P2CMS(2),P2CMS(3))
C     WRITE(LOUT,'(4E15.4)') P1CMS(1),P1CMS(2),P1CMS(3),P1CMS(4)
C     WRITE(LOUT,'(4E15.4)') P2CMS(1),P2CMS(2),P2CMS(3),P2CMS(4)
C     CALL DT_DALTRA(BGE,BGX,BGY,BGZ,P1CMS(1),P1CMS(2),P1CMS(3),P1CMS(4),
C    &            P1TOT,P1(1),P1(2),P1(3),P1(4))
C     CALL DT_DALTRA(BGE,BGX,BGY,BGZ,P2CMS(1),P2CMS(2),P2CMS(3),P2CMS(4),
C    &            P2TOT,P2(1),P2(2),P2(3),P2(4))
C     WRITE(LOUT,'(4E15.4)') P1(1),P1(2),P1(3),P1(4)
C     WRITE(LOUT,'(4E15.4)') P2(1),P2(2),P2(3),P2(4)
C     STOP
c*

      LBEAM = .TRUE.

      RETURN

    2 CONTINUE

      IF (LBEAM) THEN
         IF ( (NPOINT(4).EQ.0).OR.(NHKK.LT.NPOINT(4)) ) RETURN
         DO 20 I=NPOINT(4),NHKK
            IF ((ABS(ISTHKK(I)).EQ.1).OR.(ISTHKK(I).EQ.1000).OR.
     &                                   (ISTHKK(I).EQ.1001)) THEN
               CALL DT_MYTRAN(1,PHKK(1,I),PHKK(2,I),PHKK(3,I),
     &                     COD,SID,COF,SIF,PXCMS,PYCMS,PZCMS)
               PECMS = PHKK(4,I)
               CALL DT_DALTRA(BGE,BGX,BGY,BGZ,PXCMS,PYCMS,PZCMS,PECMS,
     &                     PTOT,PHKK(1,I),PHKK(2,I),PHKK(3,I),PHKK(4,I))
            ENDIF
   20    CONTINUE
      ELSE
         MODE = -1
      ENDIF

      RETURN
      END
c
c===eventb=============================================================*
c
CDECK  ID>, DT_EVENTB
      SUBROUTINE DT_EVENTB(NCSY,IREJ)

c***********************************************************************
c Treatment of nucleon-nucleon interactions with full two-component    *
c Dual Parton Model.                                                   *
c          NCSY     number of nucleon-nucleon interactions             *
c          IREJ     rejection flag                                     *
c This version dated 14.01.2000 is written by S. Roesler               *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ZERO=0.0D0,ONE=1.0D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c! uncomment this line for internal phojet-fragmentation
C #include "dtu_dtevtp.inc"
c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c DTUNUC-PHOJET interface, Lorentz-param. of n-n subsystem
      COMMON /DTLTSU/ BGX,BGY,BGZ,GAM

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c statistics: double-Pomeron exchange
      COMMON /DTFLG2/ INTFLG,IPOPO

c flags for particle decays
      COMMON /DTFRPA/ MSTUX(20),PARUX(20),MSTJX(20),PARJX(20),
     &                IMSTU(20),IPARU(20),IMSTJ(20),IPARJ(20),
     &                NMSTU,NPARU,NMSTJ,NPARJ,PDB,PDBSEA(3),ISIG0,IPI0

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  initial state parton radiation (internal part)
      INTEGER MXISR3,MXISR4
      PARAMETER ( MXISR3 = 50, MXISR4 = 100 )
      INTEGER IFL1,IFL2,IBRA,IFANO,ISH,NACC
      DOUBLE PRECISION Q2SH,PT2SH,XPSH,ZPSH,THSH,SHAT
      COMMON /POINT6/ Q2SH(2,MXISR3),PT2SH(2,MXISR3),XPSH(2,MXISR3),
     &                ZPSH(2,MXISR3),THSH(2,MXISR3),SHAT(MXISR3),
     &                IFL1(2,MXISR3),IFL2(2,MXISR3),
     &                IBRA(2,MXISR4),IFANO(2),ISH(2),NACC

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)


      DIMENSION PP(4),PT(4),PTOT(4),PP1(4),PP2(4),PT1(4),PT2(4),
     &          PPNN(4),PTNN(4),PTOTNN(4),PPSUB(4),PTSUB(4),
     &          PPTCMS(4),PTTCMS(4),PPTMP(4),PTTMP(4),
     &          KPRON(15),ISINGL(2000)

c initial values for max. number of phojet scatterings and dtunuc chains
c to be fragmented with one pyexec call
      DATA MXPHFR,MXDTFR /10,100/

      IREJ      = 0
c pointer to first parton of the first chain in dtevt common
      NPOINT(3) = NHKK+1
c special flag for double-Pomeron statistics
      IPOPO = 1
c counter for low-mass (DTUNUC) interactions
      NDTUSC = 0
c counter for interactions treated by PHOJET
      NPHOSC = 0

c scan interactions for single nucleon-nucleon interactions
c (this has to be checked here because Cronin modifies parton momenta)
      NC = NPOINT(2)
      IF (NCSY.GT.2000) STOP ' DT_EVENTB: NCSY > 2000 ! '
      DO 8 I=1,NCSY
         ISINGL(I) = 0
         MOP = JMOHKK(1,NC)
         MOT = JMOHKK(1,NC+1)
         DIFF1 = ABS(PHKK(4,MOP)-PHKK(4,  NC)-PHKK(4,NC+2))
         DIFF2 = ABS(PHKK(4,MOT)-PHKK(4,NC+1)-PHKK(4,NC+3))
         IF ((DIFF1.LT.TINY10).AND.(DIFF2.LT.TINY10)) ISINGL(I) = 1
         NC = NC+4
    8 CONTINUE

c multiple scattering of chain ends
      IF ((IP.GT.1).AND.(MKCRON.NE.0)) CALL DT_CRONIN(1)
      IF ((IT.GT.1).AND.(MKCRON.NE.0)) CALL DT_CRONIN(2)

c switch to PHOJET-settings for JETSET parameter
      CALL DT_INITJS(1)

c loop over nucleon-nucleon interaction
      NC = NPOINT(2)
      DO 2 I=1,NCSY
c
c   pick up one nucleon-nucleon interaction from DTEVT1
c     ppnn  / ptnn   - momenta of the interacting nucleons (cms)
c     ptotnn         - total momentum of the interacting nucleons (cms)
c     pp1,2 / pt1,2  - momenta of the four partons
c     pp    / pt     - total momenta of the proj / targ partons
c     ptot           - total momentum of the four partons
         MOP = JMOHKK(1,NC)
         MOT = JMOHKK(1,NC+1)
         DO 3 K=1,4
            PPNN(K)   = PHKK(K,MOP)
            PTNN(K)   = PHKK(K,MOT)
            PTOTNN(K) = PPNN(K)+PTNN(K)
            PP1(K)    = PHKK(K,NC)
            PT1(K)    = PHKK(K,NC+1)
            PP2(K)    = PHKK(K,NC+2)
            PT2(K)    = PHKK(K,NC+3)
            PP(K)     = PP1(K)+PP2(K)
            PT(K)     = PT1(K)+PT2(K)
            PTOT(K)   = PP(K)+PT(K)
    3    CONTINUE
c
c-----------------------------------------------------------------------
c   this is a complete nucleon-nucleon interaction
c
         IF (ISINGL(I).EQ.1) THEN
c
c     initialize PHOJET-variables for remnant/valence-partons
            IHFLD(1,1) = 0
            IHFLD(1,2) = 0
            IHFLD(2,1) = 0
            IHFLD(2,2) = 0
            IHFLS(1) = 1
            IHFLS(2) = 1
c     save current settings of PHOJET process and min. bias flags
            DO 9 K=1,11
               KPRON(K) = IPRON(K,1)
    9       CONTINUE
            ISWSAV   = ISWMDL(2)
c
c     check if forced sampling of diffractive interaction requested
            IF (ISINGD.LT.-1) THEN
               DO 90 K=1,11
                  IPRON(K,1) = 0
   90          CONTINUE
               IF ((ISINGD.EQ.-2).OR.(ISINGD.EQ.-3)) IPRON(5,1) = 1
               IF ((ISINGD.EQ.-2).OR.(ISINGD.EQ.-4)) IPRON(6,1) = 1
               IF (ISINGD.EQ.-5) IPRON(4,1) = 1
            ENDIF
c
c     for photons: a direct/anomalous interaction is not sampled
c     in PHOJET but already in Glauber-formalism. Here we check if such
c     an interaction is requested
            IF (IJPROJ.EQ.7) THEN
c       first switch off direct interactions
               IPRON(8,1) = 0
c       this is a direct interactions
               IF (IDIREC.EQ.1) THEN
                  DO 12 K=1,11
                     IPRON(K,1) = 0
   12             CONTINUE
                  IPRON(8,1) = 1
c       this is an anomalous interactions
c         (iswmdl(2) = 0 only hard int. generated ( = 1 min. bias) )
               ELSEIF (IDIREC.EQ.2) THEN
                  ISWMDL(2) = 0
               ENDIF
            ELSE
               IF (IDIREC.NE.0) STOP ' DT_EVENTB: IDIREC > 0 ! '
            ENDIF
c
c     make sure that total momenta of partons, pp and pt, are on mass
c     shell (Cronin may have srewed this up..)
            CALL DT_MASHEL(PP,PT,PHKK(5,MOP),PHKK(5,MOT),PPNN,PTNN,IR1)
            IF (IR1.NE.0) THEN
               IF (IOULEV(1).GT.0) WRITE(ErrorOut,'(1X,A)')
     &              'EVENTB:  MASS SHELL CORRECTION REJECTED'
               GOTO 9999
            ENDIF
c
c     initialize the incoming particles in PHOJET
            IF ((IP.EQ.1).AND.(IJPROJ.EQ.7)) THEN

               CALL PHO_SETPAR(1,22,0,VIRT)

            ELSE

               CALL PHO_SETPAR(1,IDHKK(MOP),0,ZERO)

            ENDIF

            CALL PHO_SETPAR(2,IDHKK(MOT),0,ZERO)

c
c     initialize rejection loop counter for anomalous processes
            IRJANO = 0
  800       CONTINUE
            IRJANO = IRJANO+1
c
c     temporary fix for ifano problem
            IFANO(1) = 0
            IFANO(2) = 0
c
c     generate complete hadron/nucleon/photon-nucleon event with PHOJET

            CALL PHO_EVENT(2,PPNN,PTNN,DUM,IREJ1)

c
c     for photons: special consistency check for anomalous interactions
            IF (IJPROJ.EQ.7) THEN
               IF (IRJANO.LT.30) THEN
                  IF (IFANO(1).NE.0) THEN
c       here, an anomalous interaction was generated. Check if it
c       was also requested. Otherwise reject this event.
                     IF (IDIREC.EQ.0) GOTO 800
                  ELSE
c       here, an anomalous interaction was not generated. Check if it
c       was requested in which case we need to reject this event.
                     IF (IDIREC.EQ.2) GOTO 800
                  ENDIF
               ELSE
                  WRITE(ErrorOut,
     * *) ' DT_EVENTB: Warning! IRJANO > 30 ',
     &                          IRJANO,IDIREC,NEVHKK
               ENDIF
            ENDIF
c
c     copy back original settings of PHOJET process and min. bias flags
            DO 10 K=1,11
               IPRON(K,1) = KPRON(K)
   10       CONTINUE
            ISWMDL(2) = ISWSAV
c
c     check if PHOJET has rejected this event
            IF (IREJ1.NE.0) THEN
C              IF (IOULEV(1).GT.0) WRITE(LOUT,'(1X,A,I4)')
               WRITE(ErrorOut,'(1X,A,I4)')
     &            'EVENTB:  CHAIN SYSTEM REJECTED',IDIREC

               CALL PHO_PREVNT(0)

               GOTO 9999
            ENDIF
c
c     copy partons and strings from PHOJET common back into DTEVT for
c     external fragmentation
            MO1 = NC
            MO2 = NC+3
c!      uncomment this line for internal phojet-fragmentation
C           CALL DT_GETFSP(MO1,MO2,PPNN,PTNN,-1)
            NPHOSC = NPHOSC+1
            CALL DT_GETPJE(MO1,MO2,PPNN,PTNN,-1,NPHOSC,IREJ1)
            IF (IREJ1.NE.0) THEN
               IF (IOULEV(1).GT.0)
     &         WRITE(ErrorOut,
     * '(1X,A,I4)') 'EVENTB: chain system rejected 1'
               GOTO 9999
            ENDIF
c
c     update statistics counter
            ICEVTG(IDCH(NC),29) = ICEVTG(IDCH(NC),29)+1
c
c-----------------------------------------------------------------------
c   this interaction involves "remnants"
c
         ELSE
c
c     total mass of this system
            PPTOT  = SQRT(PTOT(1)**2+PTOT(2)**2+PTOT(3)**2)
            AMTOT2 = (PTOT(4)-PPTOT)*(PTOT(4)+PPTOT)
            IF (AMTOT2.LT.ZERO) THEN
               AMTOT = ZERO
            ELSE
               AMTOT = SQRT(AMTOT2)
            ENDIF
c
c     systems with masses larger than elojet are treated with PHOJET
            IF (AMTOT.GT.ELOJET) THEN
c
c     initialize PHOJET-variables for remnant/valence-partons
c       projectile parton flavors and valence flag
               IHFLD(1,1) = IDHKK(NC)
               IHFLD(1,2) = IDHKK(NC+2)
               IHFLS(1)   = 0
               IF ((IDCH(NC).EQ.6).OR.(IDCH(NC).EQ.7)
     &                            .OR.(IDCH(NC).EQ.8)) IHFLS(1) = 1
c       target parton flavors and valence flag
               IHFLD(2,1) = IDHKK(NC+1)
               IHFLD(2,2) = IDHKK(NC+3)
               IHFLS(2)   = 0
               IF ((IDCH(NC).EQ.4).OR.(IDCH(NC).EQ.5)
     &                            .OR.(IDCH(NC).EQ.8)) IHFLS(2) = 1
c       flag signalizing PHOJET how to treat the remnant:
c         iremn = -1 sea-quark remnant: PHOJET takes flavors from ihfld
c         iremn > -1 valence remnant: PHOJET assumes flavors according
c                    to mother particle
               IREMN1 = IHFLS(1)-1
               IREMN2 = IHFLS(2)-1
c
c     initialize the incoming particles in PHOJET
               IF ((IP.EQ.1).AND.(IJPROJ.EQ.7)) THEN

                  CALL PHO_SETPAR(1,22,IREMN1,VIRT)

               ELSE

                  CALL PHO_SETPAR(1,IDHKK(MOP),IREMN1,ZERO)

               ENDIF

               CALL PHO_SETPAR(2,IDHKK(MOT),IREMN2,ZERO)

c
c     calculate Lorentz parameter of the nucleon-nucleon cm-system
               PPTOTN = SQRT(PTOTNN(1)**2+PTOTNN(2)**2+PTOTNN(3)**2)
               AMNN   = SQRT( (PTOTNN(4)-PPTOTN)*(PTOTNN(4)+PPTOTN) )
               BGX    = PTOTNN(1)/AMNN
               BGY    = PTOTNN(2)/AMNN
               BGZ    = PTOTNN(3)/AMNN
               GAM    = PTOTNN(4)/AMNN
c     transform interacting nucleons into nucleon-nucleon cm-system
               CALL DT_DALTRA(GAM,-BGX,-BGY,-BGZ,
     &                     PPNN(1),PPNN(2),PPNN(3),PPNN(4),PPCMS,
     &                     PPTCMS(1),PPTCMS(2),PPTCMS(3),PPTCMS(4))
               CALL DT_DALTRA(GAM,-BGX,-BGY,-BGZ,
     &                     PTNN(1),PTNN(2),PTNN(3),PTNN(4),PTCMS,
     &                     PTTCMS(1),PTTCMS(2),PTTCMS(3),PTTCMS(4))
c     transform (total) momenta of the proj and targ partons into
c     nucleon-nucleon cm-system
               CALL DT_DALTRA(GAM,-BGX,-BGY,-BGZ,
     &                     PP(1),PP(2),PP(3),PP(4),
     &                     PPTSUB,PPSUB(1),PPSUB(2),PPSUB(3),PPSUB(4))
               CALL DT_DALTRA(GAM,-BGX,-BGY,-BGZ,
     &                     PT(1),PT(2),PT(3),PT(4),
     &                     PTTSUB,PTSUB(1),PTSUB(2),PTSUB(3),PTSUB(4))
c     energy fractions of the proj and targ partons
               XPSUB = MIN(PPSUB(4)/PPTCMS(4),ONE)
               XTSUB = MIN(PTSUB(4)/PTTCMS(4),ONE)
c**
c testprint
c              PTOTCM = SQRT( (PPTCMS(1)+PTTCMS(1))**2 +
c    &                        (PPTCMS(2)+PTTCMS(2))**2 +
c    &                        (PPTCMS(3)+PTTCMS(3))**2 )
c              EOLDCM = SQRT( (PPTCMS(4)+PTTCMS(4)-PTOTCM) *
c    &                        (PPTCMS(4)+PTTCMS(4)+PTOTCM) )
c              PTOTSU = SQRT( (PPSUB(1)+PTSUB(1))**2 +
c    &                        (PPSUB(2)+PTSUB(2))**2 +
c    &                        (PPSUB(3)+PTSUB(3))**2 )
c              EOLDSU = SQRT( (PPSUB(4)+PTSUB(4)-PTOTSU) *
c    &                        (PPSUB(4)+PTSUB(4)+PTOTSU) )
c**
c
c     save current settings of PHOJET process and min. bias flags
               DO 7 K=1,11
                  KPRON(K) = IPRON(K,1)
    7          CONTINUE
c     disallow direct photon int. (does not make sense here anyway)
               IPRON(8,1) = 0
c     disallow double pomeron processes (due to technical problems
c     in PHOJET, needs to be solved sometime)
               IPRON(4,1) = 0
c     disallow diffraction for sea-diquarks
               IF ((IABS(IHFLD(1,1)).GT.1100).AND.
     &             (IABS(IHFLD(1,2)).GT.1100)) THEN
                  IPRON(3,1) = 0
                  IPRON(6,1) = 0
               ENDIF
               IF ((IABS(IHFLD(2,1)).GT.1100).AND.
     &             (IABS(IHFLD(2,2)).GT.1100)) THEN
                  IPRON(3,1) = 0
                  IPRON(5,1) = 0
               ENDIF
c
c     we need massless partons: transform them on mass shell
               XMP = ZERO
               XMT = ZERO
               DO 6 K=1,4
                  PPTMP(K) = PPSUB(K)
                  PTTMP(K) = PTSUB(K)
    6          CONTINUE
               CALL DT_MASHEL(PPTMP,PTTMP,XMP,XMT,PPSUB,PTSUB,IREJ1)
               PPSUTO  = SQRT(PPSUB(1)**2+PPSUB(2)**2+PPSUB(3)**2)
               PTSUTO  = SQRT(PTSUB(1)**2+PTSUB(2)**2+PTSUB(3)**2)
               PSUTOT = SQRT((PPSUB(1)+PTSUB(1))**2+
     &                  (PPSUB(2)+PTSUB(2))**2+(PPSUB(3)+PTSUB(3))**2)
c     total energy of the subsysten after mass transformation
c      (should be the same as before..)
               SECM = SQRT( (PPSUB(4)+PTSUB(4)-PSUTOT)*
     &                      (PPSUB(4)+PTSUB(4)+PSUTOT) )
c
c     after mass shell transformation the x_sub - relation has to be
c     corrected. We therefore create "pseudo-momenta" of mother-nucleons.
c
c     The old version was to scale based on the original x_sub and the
c     4-momenta of the subsystem. At very high energy this could lead to
c     "pseudo-cm energies" of the parent system considerably exceeding
c     the true cm energy. Now we keep the true cm energy and calculate
c     new x_sub instead.
C old version  PPTCMS(4) = PPSUB(4)/XPSUB
               PPTCMS(4) = MAX(PPTCMS(4),PPSUB(4))
               XPSUB = PPSUB(4)/PPTCMS(4)
               IF (IJPROJ.EQ.7) THEN
                  AMP2  = PHKK(5,MOT)**2
                  PTOT1 = SQRT(PPTCMS(4)**2-AMP2)
               ELSE
c???????
                  PTOT1 = SQRT((PPTCMS(4)-PHKK(5,MOP))
     &                        *(PPTCMS(4)+PHKK(5,MOP)))
C                 PTOT1 = SQRT((PPTCMS(4)-PHKK(5,MOT))
C    &                        *(PPTCMS(4)+PHKK(5,MOT)))
               ENDIF
C old version  PTTCMS(4) = PTSUB(4)/XTSUB
               PTTCMS(4) = MAX(PTTCMS(4),PTSUB(4))
               XTSUB = PTSUB(4)/PTTCMS(4)
               PTOT2 = SQRT((PTTCMS(4)-PHKK(5,MOT))
     &                     *(PTTCMS(4)+PHKK(5,MOT)))
               DO 4 K=1,3
                  PPTCMS(K) = PTOT1*PPSUB(K)/PPSUTO
                  PTTCMS(K) = PTOT2*PTSUB(K)/PTSUTO
    4          CONTINUE
c**
c testprint
c
c     ppnn  / ptnn   - momenta of the int. nucleons (cms, negl. Fermi)
c     ptotnn         - total momentum of the int. nucleons (cms, negl. Fermi)
c     pptcms/ pttcms - momenta of the interacting nucleons (cms)
c     pp1,2 / pt1,2  - momenta of the four partons
c
c     pp    / pt     - total momenta of the pr/ta partons (cms, negl. Fermi)
c     ptot           - total momentum of the four partons (cms, negl. Fermi)
c     ppsub / ptsub  - total momenta of the proj / targ partons (cms)
c
c              PTOTCM = SQRT( (PPTCMS(1)+PTTCMS(1))**2 +
c    &                        (PPTCMS(2)+PTTCMS(2))**2 +
c    &                        (PPTCMS(3)+PTTCMS(3))**2 )
c              ENEWCM = SQRT( (PPTCMS(4)+PTTCMS(4)-PTOTCM) *
c    &                        (PPTCMS(4)+PTTCMS(4)+PTOTCM) )
c              PTOTSU = SQRT( (PPSUB(1)+PTSUB(1))**2 +
c    &                        (PPSUB(2)+PTSUB(2))**2 +
c    &                        (PPSUB(3)+PTSUB(3))**2 )
c              ENEWSU = SQRT( (PPSUB(4)+PTSUB(4)-PTOTSU) *
c    &                        (PPSUB(4)+PTSUB(4)+PTOTSU) )
c              IF (ENEWCM/EOLDCM.GT.1.1D0) THEN
c                 WRITE(*,*) ' EOLDCM, ENEWCM : ',EOLDCM,ENEWCM
c                 WRITE(*,*) ' EOLDSU, ENEWSU : ',EOLDSU,ENEWSU
c                 WRITE(*,*) ' XPSUB,  XTSUB  : ',XPSUB,XTSUB
c              ENDIF
c              BBGX = (PPTCMS(1)+PTTCMS(1))/ENEWCM
c              BBGY = (PPTCMS(2)+PTTCMS(2))/ENEWCM
c              BBGZ = (PPTCMS(3)+PTTCMS(3))/ENEWCM
c              BGAM = (PPTCMS(4)+PTTCMS(4))/ENEWCM
c     transform interacting nucleons into nucleon-nucleon cm-system
c              CALL DT_DALTRA(BGAM,-BBGX,-BBGY,-BBGZ,
c    &                    PPTCMS(1),PPTCMS(2),PPTCMS(3),PPTCMS(4),PPTOT,
c    &                     PPNEW1,PPNEW2,PPNEW3,PPNEW4)
c              CALL DT_DALTRA(BGAM,-BBGX,-BBGY,-BBGZ,
c    &                    PTTCMS(1),PTTCMS(2),PTTCMS(3),PTTCMS(4),PTTOT,
c    &                     PTNEW1,PTNEW2,PTNEW3,PTNEW4)
c              CALL DT_DALTRA(BGAM,-BBGX,-BBGY,-BBGZ,
c    &                     PPSUB(1),PPSUB(2),PPSUB(3),PPSUB(4),PPTOT,
c    &                     PPSUB1,PPSUB2,PPSUB3,PPSUB4)
c              CALL DT_DALTRA(BGAM,-BBGX,-BBGY,-BBGZ,
c    &                     PTSUB(1),PTSUB(2),PTSUB(3),PTSUB(4),PTTOT,
c    &                     PTSUB1,PTSUB2,PTSUB3,PTSUB4)
c              PTSTCM = SQRT( (PPNEW1+PTNEW1)**2 +
c    &                        (PPNEW2+PTNEW2)**2 +
c    &                        (PPNEW3+PTNEW3)**2 )
c              ETSTCM = SQRT( (PPNEW4+PTNEW4-PTSTCM) *
c    &                        (PPNEW4+PTNEW4+PTSTCM) )
c              PTSTSU = SQRT( (PPSUB1+PTSUB1)**2 +
c    &                        (PPSUB2+PTSUB2)**2 +
c    &                        (PPSUB3+PTSUB3)**2 )
c              ETSTSU = SQRT( (PPSUB4+PTSUB4-PTSTSU) *
c    &                        (PPSUB4+PTSUB4+PTSTSU) )
C              WRITE(*,*) ' mother cmE :'
C              WRITE(*,*) ETSTCM,ENEWCM
C              WRITE(*,*) ' subsystem cmE :'
C              WRITE(*,*) ETSTSU,ENEWSU
C              WRITE(*,*) ' projectile mother :'
C              WRITE(*,*) PPNEW1,PPNEW2,PPNEW3,PPNEW4
C              WRITE(*,*) ' target mother :'
C              WRITE(*,*) PTNEW1,PTNEW2,PTNEW3,PTNEW4
C              WRITE(*,*) ' projectile subsystem:'
C              WRITE(*,*) PPSUB1,PPSUB2,PPSUB3,PPSUB4
C              WRITE(*,*) ' target subsystem:'
C              WRITE(*,*) PTSUB1,PTSUB2,PTSUB3,PTSUB4
C              WRITE(*,*) ' projectile subsystem should be:'
C              WRITE(*,*) ZERO,ZERO,XPSUB*ETSTCM/2.0D0,
C    &                    XPSUB*ETSTCM/2.0D0
C              WRITE(*,*) ' target subsystem should be:'
C              WRITE(*,*) ZERO,ZERO,-XTSUB*ETSTCM/2.0D0,
C    &                    XTSUB*ETSTCM/2.0D0
C              WRITE(*,*) ' subsystem cmE should be: '
C              WRITE(*,*) SQRT(XPSUB*XTSUB)*ETSTCM,XPSUB,XTSUB
c**
c
c     generate complete remnant - nucleon/remnant event with PHOJET

               CALL PHO_EVENT(3,PPTCMS,PTTCMS,DUM,IREJ1)

c
c     copy back original settings of PHOJET process flags
               DO 11 K=1,11
                  IPRON(K,1) = KPRON(K)
   11          CONTINUE
c
c     check if PHOJET has rejected this event
               IF (IREJ1.NE.0) THEN
                  IF (IOULEV(1).GT.0)
     &            WRITE(ErrorOut,
     * '(1X,A)') 'EVENTB:  chain system rejected'
                  WRITE(ErrorOut,*)
     &                 'XPSUB,XTSUB,SECM ',XPSUB,XTSUB,SECM,AMTOT

                  CALL PHO_PREVNT(0)

                  GOTO 9999
               ENDIF
c
c     copy partons and strings from PHOJET common back into DTEVT for
c     external fragmentation
               MO1 = NC
               MO2 = NC+3
c!      uncomment this line for internal phojet-fragmentation
C              CALL DT_GETFSP(MO1,MO2,PP,PT,1)
               NPHOSC = NPHOSC+1
               CALL DT_GETPJE(MO1,MO2,PP,PT,1,NPHOSC,IREJ1)
               IF (IREJ1.NE.0) THEN
                  IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * '(1X,A,I4)')
     &               'EVENTB: CHAIN SYSTEM REJECTED 2'
                  GOTO 9999
               ENDIF
c
c     update statistics counter
               ICEVTG(IDCH(NC),2) = ICEVTG(IDCH(NC),2)+1
c
c-----------------------------------------------------------------------
c two-chain approx. for smaller systems
c
            ELSE
c
               NDTUSC = NDTUSC+1
c   special flag for double-Pomeron statistics
               IPOPO = 0
c
c   pick up flavors at the ends of the two chains
               IFP1 = IDHKK(NC)
               IFT1 = IDHKK(NC+1)
               IFP2 = IDHKK(NC+2)
               IFT2 = IDHKK(NC+3)
c   ..and the indices of the mothers
               MOP1 = NC
               MOT1 = NC+1
               MOP2 = NC+2
               MOT2 = NC+3
               CALL DT_GETCSY(IFP1,PP1,MOP1,IFP2,PP2,MOP2,
     &                     IFT1,PT1,MOT1,IFT2,PT2,MOT2,IREJ1)
c
c   check if this chain system was rejected
               IF (IREJ1.GT.0) THEN
                  IF (IOULEV(1).GT.0) THEN
                     WRITE(ErrorOut,*) 'rejected 1 in EVENTB'
                     WRITE(ErrorOut,'(1X,4(I6,4E12.3,/),E12.3)')
     &                  IFP1,PP1,IFT1,PT1,IFP2,PP2,IFT2,PT2,AMTOT
                  ENDIF
                  IRHHA = IRHHA+1
                  GOTO 9999
               ENDIF
c   the following lines are for sea-sea chains rejected in GETCSY
               IF (IREJ1.EQ.-1) NDTUSC = NDTUSC-1
               ICEVTG(IDCH(NC),1) = ICEVTG(IDCH(NC),1)+1
            ENDIF
c
         ENDIF
c
c     update statistics counter
         ICEVTG(IDCH(NC),0) = ICEVTG(IDCH(NC),0)+1
c
         NC = NC+4
c
    2 CONTINUE
c
c-----------------------------------------------------------------------
c treatment of low-mass chains (if there are any)
c
      IF (NDTUSC.GT.0) THEN
c
c   correct chains of very low masses for possible resonances
         IF (IRESCO.EQ.1) THEN
            CALL DT_EVTRES(IREJ1)
            IF (IREJ1.GT.0) THEN
               IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 2a in EVENTB'
               IRRES(1) = IRRES(1)+1
               GOTO 9999
            ENDIF
         ENDIF
c   fragmentation of low-mass chains
c!  uncomment this line for internal phojet-fragmentation
c   (of course it will still be fragmented by DPMJET-routines but it
c    has to be done here instead of further below)
C        CALL DT_EVTFRA(IREJ1)
C        IF (IREJ1.GT.0) THEN
C           IF (IOULEV(1).GT.0) WRITE(LOUT,*) 'rejected 2b in EVENTB'
C           IRFRAG = IRFRAG+1
C           GOTO 9999
C        ENDIF
      ELSE
c! uncomment this line for internal phojet-fragmentation
C        NPOINT(4) = NHKK+1
         IF (NPOINT(4).LE.NPOINT(3)) NPOINT(4) = NHKK+1
      ENDIF
c
c-----------------------------------------------------------------------
c new di-quark breaking mechanisms
c
      MXLEFT = 2
      CALL DT_CHASTA(0)
      IF ((PDBSEA(1).GT.0.0D0).OR.(PDBSEA(2).GT.0.0D0)
     &                        .OR.(PDBSEA(3).GT.0.0D0)) THEN
         CALL DT_DIQBRK
         MXLEFT = 4
      ENDIF
c
c-----------------------------------------------------------------------
c hadronize this event
c
c   hadronize PHOJET chain systems
      NPYMAX = 0
      NPJE   = NPHOSC/MXPHFR
      IF (MXPHFR.LT.MXLEFT) MXLEFT = 2
      IF (NPJE.GT.1) THEN
         NLEFT = NPHOSC-NPJE*MXPHFR
         DO 20 JFRG=1,NPJE
            NFRG = JFRG*MXPHFR
            IF ((JFRG.EQ.NPJE).AND.(NLEFT.LE.MXLEFT)) THEN
               CALL DT_EVTFRG(1,NPHOSC,NPYMEM,IREJ1)
               IF (IREJ1.GT.0) GOTO 22
               NLEFT = 0
            ELSE
               CALL DT_EVTFRG(1,NFRG,NPYMEM,IREJ1)
               IF (IREJ1.GT.0) GOTO 22
            ENDIF
            IF (NPYMEM.GT.NPYMAX) NPYMAX = NPYMEM
   20    CONTINUE
         IF (NLEFT.GT.0) THEN
            CALL DT_EVTFRG(1,NPHOSC,NPYMEM,IREJ1)
            IF (IREJ1.GT.0) GOTO 22
            IF (NPYMEM.GT.NPYMAX) NPYMAX = NPYMEM
         ENDIF
      ELSE
         CALL DT_EVTFRG(1,NPHOSC,NPYMEM,IREJ1)
         IF (IREJ1.GT.0) GOTO 22
         IF (NPYMEM.GT.NPYMAX) NPYMAX = NPYMEM
      ENDIF
c
c   check max. filling level of jetset common and
c   reduce mxphfr if necessary
      IF (NPYMAX.GT.3000) THEN
         IF (NPYMAX.GT.3500) THEN
            MXPHFR = MAX(1,MXPHFR-2)
         ELSE
            MXPHFR = MAX(1,MXPHFR-1)
         ENDIF
C        WRITE(LOUT,*) ' EVENTB: Mxphfr reduced to ',MXPHFR
      ENDIF
c
c   hadronize DTUNUC chain systems
   23 CONTINUE
      IBACK = MXDTFR
      CALL DT_EVTFRG(2,IBACK,NPYMEM,IREJ2)
      IF (IREJ2.GT.0) GOTO 22
c
c   check max. filling level of jetset common and
c   reduce mxdtfr if necessary
      IF (NPYMEM.GT.3000) THEN
         IF (NPYMEM.GT.3500) THEN
            MXDTFR = MAX(1,MXDTFR-20)
         ELSE
            MXDTFR = MAX(1,MXDTFR-10)
         ENDIF
C        WRITE(LOUT,*) ' EVENTB: Mxdtfr reduced to ',MXDTFR
      ENDIF
c
      IF (IBACK.EQ.-1) GOTO 23
c
   22 CONTINUE
C     CALL DT_EVTFRG(1,IREJ1)
C     CALL DT_EVTFRG(2,IREJ2)
      IF ((IREJ1.GT.0).OR.(IREJ2.GT.0)) THEN
         IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in EVENTB'
         IRFRAG = IRFRAG+1
         GOTO 9999
      ENDIF
c
c get final state particles from /DTEVTP/
c! uncomment this line for internal phojet-fragmentation
C     CALL DT_GETFSP(IDUM,IDUM,PP,PT,2)

      IF (IJPROJ.NE.7)
     &   CALL DT_EMC2(9,10,0,0,0,3,1,0,0,0,0,3,4,88,IREJ3)
C     IF (IREJ3.NE.0) GOTO 9999

      RETURN

 9999 CONTINUE
      IREVT = IREVT+1
      IREJ  = 1
      RETURN
      END
c
c===getpje=============================================================*
c
CDECK  ID>, DT_GETPJE
      SUBROUTINE DT_GETPJE(MO1,MO2,PP,PT,MODE,IPJE,IREJ)

c***********************************************************************
c This subroutine copies PHOJET partons and strings from POEVT1 into   *
c DTEVT1.                                                              *
c      MO1,MO2   indices of first and last mother-parton in DTEVT1     *
c      PP,PT     4-momenta of projectile/target being handled by       *
c                PHOJET                                                *
c This version dated 11.12.99 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY1=1.0D-1,
     &           ZERO=0.0D0,ONE=1.0D0,OHALF=0.5D0)

      LOGICAL LFLIP

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c DTUNUC-PHOJET interface, Lorentz-param. of n-n subsystem
      COMMON /DTLTSU/ BGX,BGY,BGZ,GAM

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c statistics: double-Pomeron exchange
      COMMON /DTFLG2/ INTFLG,IPOPO

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC



C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  color string configurations including collapsed strings and hadrons
      INTEGER MSTR
      PARAMETER (MSTR=500)
      INTEGER NPOS,NCODE,IPAR1,IPAR2,IPAR3,IPAR4,NNCH,IBHAD
      COMMON /POSTRG/ NPOS(4,MSTR),NCODE(MSTR),
     &                IPAR1(MSTR),IPAR2(MSTR),IPAR3(MSTR),IPAR4(MSTR),
     &                NNCH(MSTR),IBHAD(MSTR),ISTR

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD


      DIMENSION PP(4),PT(4)
      DATA MAXLOP /10000/

      INHKK = NHKK
      LFLIP = .TRUE.
    1 CONTINUE
      NPVAL = 0
      NTVAL = 0
      IREJ  = 0

c   store initial momenta for energy-momentum conservation check
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(PP(1),PP(2),PP(3),PP(4),1,IDUM1,IDUM2)
         CALL DT_EVTEMC(PT(1),PT(2),PT(3),PT(4),2,IDUM1,IDUM2)
      ENDIF
c copy partons and strings from POEVT1 into DTEVT1
      DO 11 I=1,ISTR
C        IF ((NCODE(I).EQ.-99).AND.(IPAMDL(17).EQ.0)) THEN
         IF (NCODE(I).EQ.-99) THEN
            IDXSTG = NPOS(1,I)
            IDSTG  = IDHEP(IDXSTG)
            PX = PHEP(1,IDXSTG)
            PY = PHEP(2,IDXSTG)
            PZ = PHEP(3,IDXSTG)
            PE = PHEP(4,IDXSTG)
            IF (MODE.LT.0) THEN
               ISTAT = 70000+IPJE
               CALL DT_EVTPUT(2,ISTAT,MO1,MO2,PX,PY,PZ,PE,
     &                        11,IDSTG,0)
               IF (LEMCCK) THEN
                  PX = -PX
                  PY = -PY
                  PZ = -PZ
                  PE = -PE
                  CALL DT_EVTEMC(PX,PY,PZ,PE,2,IDUM1,IDUM2)
               ENDIF
            ELSE
               CALL DT_DALTRA(GAM,BGX,BGY,BGZ,PX,PY,PZ,PE,PTOTMP,
     &                        PPX,PPY,PPZ,PPE)
               ISTAT = 70000+IPJE
               CALL DT_EVTPUT(2,ISTAT,MO1,MO2,PPX,PPY,PPZ,PPE,
     &                        11,IDSTG,0)
               IF (LEMCCK) THEN
                  PX = -PPX
                  PY = -PPY
                  PZ = -PPZ
                  PE = -PPE
                  CALL DT_EVTEMC(PX,PY,PZ,PE,2,IDUM1,IDUM2)
               ENDIF
            ENDIF
            NOBAM(NHKK)   = 0
            IHIST(1,NHKK) = IPHIST(1,IDXSTG)
            IHIST(2,NHKK) = 0
         ELSEIF (NCODE(I).GE.0) THEN
c   indices of partons and string in POEVT1
            IDX1 = ABS(JMOHEP(1,NPOS(1,I)))
            IDX2 = ABS(JMOHEP(2,NPOS(1,I)))
            IF ((IDX1.GT.IDX2).OR.(JMOHEP(2,NPOS(1,I)).GT.0)) THEN
               WRITE(ErrorOut,
     * *) ' GETPJE: IDX1.GT.IDX2 ',IDX1,IDX2,
     &         ' OR JMOHEP(2,NPOS(1,I)).GT.0 ',JMOHEP(2,NPOS(1,I)),' ! '
               STOP ' GETPJE 1'
            ENDIF
            IDXSTG = NPOS(1,I)
c   find "mother" string of the string
            IDXMS1 = ABS(JMOHEP(1,IDX1))
            IDXMS2 = ABS(JMOHEP(1,IDX2))
            IF (IDXMS1.NE.IDXMS2) THEN
               IDXMS1 = IDXSTG
               IDXMS2 = IDXSTG
C              STOP ' GETPJE: IDXMS1.NE.IDXMS2 !'
            ENDIF
c   search POEVT1 for the original hadron of the parton
            ILOOP = 0
            IPOM1 = 0
   14       CONTINUE
            ILOOP = ILOOP+1

            IF (IDHEP(IDXMS1).EQ.990) IPOM1 = 1

            IDXMS1 = ABS(JMOHEP(1,IDXMS1))
            IF ((IDXMS1.NE.1).AND.(IDXMS1.NE.2).AND.
     &          (ILOOP.LT.MAXLOP)) GOTO 14
            IF (ILOOP.EQ.MAXLOP) WRITE(*,*) ' GETPJE: MAXLOP in 1 ! '
            IPOM2 = 0
            ILOOP = 0
   15       CONTINUE
            ILOOP = ILOOP+1

            IF (IDHEP(IDXMS2).EQ.990) IPOM2 = 1

            IF ((ILOOP.EQ.1).OR.(IDHEP(IDXMS2).GE.7777)) THEN
               IDXMS2 = ABS(JMOHEP(2,IDXMS2))
            ELSE
               IDXMS2 = ABS(JMOHEP(1,IDXMS2))
            ENDIF
            IF ((IDXMS2.NE.1).AND.(IDXMS2.NE.2).AND.
     &          (ILOOP.LT.MAXLOP)) GOTO 15
            IF (ILOOP.EQ.MAXLOP) WRITE(*,*) ' GETPJE: MAXLOP in 5 ! '
c   parton 1
            IF (IDXMS1.EQ.1) THEN
               ISPTN1 = ISTHKK(MO1)
               M1PTN1 = MO1
               M2PTN1 = MO1+2
            ELSE
               ISPTN1 = ISTHKK(MO2)
               M1PTN1 = MO2-2
               M2PTN1 = MO2
            ENDIF
c   parton 2
            IF (IDXMS2.EQ.1) THEN
               ISPTN2 = ISTHKK(MO1)
               M1PTN2 = MO1
               M2PTN2 = MO1+2
            ELSE
               ISPTN2 = ISTHKK(MO2)
               M1PTN2 = MO2-2
               M2PTN2 = MO2
            ENDIF
c   check for mis-identified mothers and switch mother indices if necessary
            IF ((IDXMS1.EQ.IDXMS2).AND.(IPROCE.NE.5).AND.(IPROCE.NE.6)
     &          .AND.((IDHEP(IDX1).NE.21).OR.(IDHEP(IDX2).NE.21)).AND.
     &          (LFLIP)) THEN
               IF (PHEP(3,IDX1).GT.PHEP(3,IDX2)) THEN
                  ISPTN1 = ISTHKK(MO1)
                  M1PTN1 = MO1
                  M2PTN1 = MO1+2
                  ISPTN2 = ISTHKK(MO2)
                  M1PTN2 = MO2-2
                  M2PTN2 = MO2
               ELSE
                  ISPTN1 = ISTHKK(MO2)
                  M1PTN1 = MO2-2
                  M2PTN1 = MO2
                  ISPTN2 = ISTHKK(MO1)
                  M1PTN2 = MO1
                  M2PTN2 = MO1+2
               ENDIF
            ENDIF
c   register partons in temporary common
c     parton at chain end
            PX = PHEP(1,IDX1)
            PY = PHEP(2,IDX1)
            PZ = PHEP(3,IDX1)
            PE = PHEP(4,IDX1)
c flag only partons coming from Pomeron with 41/42
C           IF ((IPOM1.NE.0).OR.(NPOS(4,I).GE.4)) THEN
            IF (IPOM1.NE.0) THEN
               ISTX = ABS(ISPTN1)/10
               IMO  = ABS(ISPTN1)-10*ISTX
               ISPTN1 = -(40+IMO)
            ELSE
               IF ((ICOLOR(2,IDX1).EQ.0).OR.(IDHEP(IDX1).EQ.21)) THEN
                  ISTX = ABS(ISPTN1)/10
                  IMO  = ABS(ISPTN1)-10*ISTX
                  IF ((IDHEP(IDX1).EQ.21).OR.
     &                (ABS(IPHIST(1,IDX1)).GE.100)) THEN
                     ISPTN1 = -(60+IMO)
                  ELSE
                     ISPTN1 = -(50+IMO)
                  ENDIF
               ENDIF
            ENDIF
            IF (ISPTN1.EQ.-21) NPVAL = NPVAL+1
            IF (ISPTN1.EQ.-22) NTVAL = NTVAL+1
            IF (MODE.LT.0) THEN
               CALL DT_EVTPUT(ISPTN1,IDHEP(IDX1),M1PTN1,M2PTN1,PX,PY,
     &                        PZ,PE,0,0,0)
            ELSE
               CALL DT_DALTRA(GAM,BGX,BGY,BGZ,PX,PY,PZ,PE,PTOTMP,
     &                        PPX,PPY,PPZ,PPE)
               CALL DT_EVTPUT(ISPTN1,IDHEP(IDX1),M1PTN1,M2PTN1,PPX,PPY,
     &                        PPZ,PPE,0,0,0)
            ENDIF
            IHIST(1,NHKK) = IPHIST(1,IDX1)
            IHIST(2,NHKK) = 0
            DO 19 KK=1,4
               VHKK(KK,NHKK) = VHKK(KK,M2PTN1)
               WHKK(KK,NHKK) = WHKK(KK,M1PTN1)
   19       CONTINUE
            VHKK(4,NHKK) = VHKK(3,M2PTN1)/BLAB-VHKK(3,M1PTN1)/BGLAB
            WHKK(4,NHKK) = -WHKK(3,M1PTN1)/BLAB+WHKK(3,M2PTN1)/BGLAB
            M1STRG = NHKK
c     gluon kinks
            NGLUON = IDX2-IDX1-1
            IF (NGLUON.GT.0) THEN
               DO 17 IGLUON=1,NGLUON
                  IDX   = IDX1+IGLUON
                  IDXMS = ABS(JMOHEP(1,IDX))
                  IF ((IDXMS.NE.1).AND.(IDXMS.NE.2)) THEN
                     ILOOP = 0
   16                CONTINUE
                     ILOOP = ILOOP+1
                     IDXMS = ABS(JMOHEP(1,IDXMS))
                     IF ((IDXMS.NE.1).AND.(IDXMS.NE.2).AND.
     &                   (ILOOP.LT.MAXLOP)) GOTO 16
                     IF (ILOOP.EQ.MAXLOP)
     &                  WRITE(*,*) ' GETPJE: MAXLOP in 3 ! '
                  ENDIF
                  IF (IDXMS.EQ.1) THEN
                     ISPTN = ISTHKK(MO1)
                     M1PTN = MO1
                     M2PTN = MO1+2
                  ELSE
                     ISPTN = ISTHKK(MO2)
                     M1PTN = MO2-2
                     M2PTN = MO2
                  ENDIF
                  PX = PHEP(1,IDX)
                  PY = PHEP(2,IDX)
                  PZ = PHEP(3,IDX)
                  PE = PHEP(4,IDX)
                  IF ((ICOLOR(2,IDX).EQ.0).OR.(IDHEP(IDX).EQ.21)) THEN
                     ISTX = ABS(ISPTN)/10
                     IMO  = ABS(ISPTN)-10*ISTX
                     IF ((IDHEP(IDX).EQ.21).OR.
     &                   (ABS(IPHIST(1,IDX)).GE.100)) THEN
                        ISPTN = -(60+IMO)
                     ELSE
                        ISPTN = -(50+IMO)
                     ENDIF
                  ENDIF
                  IF (ISPTN.EQ.-21) NPVAL = NPVAL+1
                  IF (ISPTN.EQ.-22) NTVAL = NTVAL+1
                  IF (MODE.LT.0) THEN
                     CALL DT_EVTPUT(ISPTN,IDHEP(IDX),M1PTN,M2PTN,
     &                              PX,PY,PZ,PE,0,0,0)
                  ELSE
                     CALL DT_DALTRA(GAM,BGX,BGY,BGZ,PX,PY,PZ,PE,PTOTMP,
     &                              PPX,PPY,PPZ,PPE)
                     CALL DT_EVTPUT(ISPTN,IDHEP(IDX),M1PTN,M2PTN,
     &                              PPX,PPY,PPZ,PPE,0,0,0)
                  ENDIF
                  IHIST(1,NHKK) = IPHIST(1,IDX)
                  IHIST(2,NHKK) = 0
                  DO 20 KK=1,4
                     VHKK(KK,NHKK) = VHKK(KK,M2PTN)
                     WHKK(KK,NHKK) = WHKK(KK,M1PTN)
   20             CONTINUE
                  VHKK(4,NHKK)= VHKK(3,M2PTN)/BLAB-VHKK(3,M1PTN)/BGLAB
                  WHKK(4,NHKK)= -WHKK(3,M1PTN)/BLAB+WHKK(3,M2PTN)/BGLAB
   17          CONTINUE
            ENDIF
c     parton at chain end
            PX = PHEP(1,IDX2)
            PY = PHEP(2,IDX2)
            PZ = PHEP(3,IDX2)
            PE = PHEP(4,IDX2)
c flag only partons coming from Pomeron with 41/42
C           IF ((IPOM2.NE.0).OR.(NPOS(4,I).GE.4)) THEN
            IF (IPOM2.NE.0) THEN
               ISTX = ABS(ISPTN2)/10
               IMO  = ABS(ISPTN2)-10*ISTX
               ISPTN2 = -(40+IMO)
            ELSE
               IF ((ICOLOR(2,IDX2).EQ.0).OR.(IDHEP(IDX2).EQ.21)) THEN
                  ISTX = ABS(ISPTN2)/10
                  IMO  = ABS(ISPTN2)-10*ISTX
                  IF ((IDHEP(IDX2).EQ.21).OR.
     &                (ABS(IPHIST(1,IDX2)).GE.100)) THEN
                     ISPTN2 = -(60+IMO)
                  ELSE
                     ISPTN2 = -(50+IMO)
                  ENDIF
               ENDIF
            ENDIF
            IF (ISPTN2.EQ.-21) NPVAL = NPVAL+1
            IF (ISPTN2.EQ.-22) NTVAL = NTVAL+1
            IF (MODE.LT.0) THEN
               CALL DT_EVTPUT(ISPTN2,IDHEP(IDX2),M1PTN2,M2PTN2,
     &                        PX,PY,PZ,PE,0,0,0)
            ELSE
               CALL DT_DALTRA(GAM,BGX,BGY,BGZ,PX,PY,PZ,PE,PTOTMP,
     &                        PPX,PPY,PPZ,PPE)
               CALL DT_EVTPUT(ISPTN2,IDHEP(IDX2),M1PTN2,M2PTN2,
     &                        PPX,PPY,PPZ,PPE,0,0,0)
            ENDIF
            IHIST(1,NHKK) = IPHIST(1,IDX2)
            IHIST(2,NHKK) = 0
            DO 21 KK=1,4
               VHKK(KK,NHKK) = VHKK(KK,M2PTN2)
               WHKK(KK,NHKK) = WHKK(KK,M1PTN2)
   21       CONTINUE
            VHKK(4,NHKK) = VHKK(3,M2PTN2)/BLAB-VHKK(3,M1PTN2)/BGLAB
            WHKK(4,NHKK) = -WHKK(3,M1PTN2)/BLAB+WHKK(3,M2PTN2)/BGLAB
            M2STRG = NHKK
c   register string
            JSTRG = 100*IPROCE+NCODE(I)
            PX = PHEP(1,IDXSTG)
            PY = PHEP(2,IDXSTG)
            PZ = PHEP(3,IDXSTG)
            PE = PHEP(4,IDXSTG)
            IF (MODE.LT.0) THEN
               ISTAT = 70000+IPJE
               CALL DT_EVTPUT(JSTRG,ISTAT,M1STRG,M2STRG,
     &                        PX,PY,PZ,PE,0,0,0)
               IF (LEMCCK) THEN
                  PX = -PX
                  PY = -PY
                  PZ = -PZ
                  PE = -PE
                  CALL DT_EVTEMC(PX,PY,PZ,PE,2,IDUM1,IDUM2)
               ENDIF
            ELSE
               CALL DT_DALTRA(GAM,BGX,BGY,BGZ,PX,PY,PZ,PE,PTOTMP,
     &                        PPX,PPY,PPZ,PPE)
               ISTAT = 70000+IPJE
               CALL DT_EVTPUT(JSTRG,ISTAT,M1STRG,M2STRG,
     &                        PPX,PPY,PPZ,PPE,0,0,0)
               IF (LEMCCK) THEN
                  PX = -PPX
                  PY = -PPY
                  PZ = -PPZ
                  PE = -PPE
                  CALL DT_EVTEMC(PX,PY,PZ,PE,2,IDUM1,IDUM2)
               ENDIF
            ENDIF
            NOBAM(NHKK)   = 0
            IHIST(1,NHKK) = 0
            IHIST(2,NHKK) = 0
            DO 18 KK=1,4
               VHKK(KK,NHKK) = VHKK(KK,MO2)
               WHKK(KK,NHKK) = WHKK(KK,MO1)
   18       CONTINUE
            VHKK(4,NHKK) = VHKK(3,MO2)/BLAB-VHKK(3,MO1)/BGLAB
            WHKK(4,NHKK) = -WHKK(3,MO1)/BLAB+WHKK(3,MO2)/BGLAB
         ENDIF
   11 CONTINUE

      IF ( ((NPVAL.GT.2).OR.(NTVAL.GT.2)).AND.(LFLIP) ) THEN
         NHKK  = INHKK
         LFLIP = .FALSE.
         GOTO 1
      ENDIF

      IF (LEMCCK) THEN
         IF (UMO.GT.1.0D5) THEN
            CHKLEV = 1.0D0
         ELSE
            CHKLEV = TINY1
         ENDIF
         CALL DT_EVTEMC(DUM1,DUM2,DUM3,CHKLEV,-1,1000,IREJ2)

         IF (IREJ2.GT.ZERO) CALL PHO_PREVNT(0)

      ENDIF

c internal statistics
c   dble-Po statistics.
      IF (IPROCE.NE.4) IPOPO = 0

      INTFLG = IPROCE
      IDCHSY = IDCH(MO1)
      IF ((IPROCE.GE.1).AND.(IPROCE.LE.8)) THEN
         ICEVTG(IDCHSY,IPROCE+2) = ICEVTG(IDCHSY,IPROCE+2)+1
      ELSE
         WRITE(ErrorOut,1000) IPROCE,NEVHKK,MO1
 1000    FORMAT(1X,'GETFSP:   WARNING! INCONS. PROCESS ID. (',I2,
     &          ') AT EVT(CHAIN) ',I6,'(',I2,')')
      ENDIF
      IF (IPROCE.EQ.5) THEN
         IF ((IDIFR1.GE.1).AND.(IDIFR1.LE.3)) THEN
            ICEVTG(IDCHSY,18+IDIFR1) = ICEVTG(IDCHSY,18+IDIFR1)+1
         ELSE
C           WRITE(LOUT,1001) IPROCE,IDIFR1,IDIFR2
 1001       FORMAT(1X,'GETFSP:   WARNING! INCONS. DIFFRAC. ID. ',
     &             '(IPROCE,IDIFR1,IDIFR2=',3I3,')')
         ENDIF
      ELSEIF (IPROCE.EQ.6) THEN
         IF ((IDIFR2.GE.1).AND.(IDIFR2.LE.3)) THEN
            ICEVTG(IDCHSY,21+IDIFR2) = ICEVTG(IDCHSY,21+IDIFR2)+1
         ELSE
C           WRITE(LOUT,1001) IPROCE,IDIFR1,IDIFR2
         ENDIF
      ELSEIF (IPROCE.EQ.7) THEN
         IF ((IDIFR1.GE.1).AND.(IDIFR1.LE.3).AND.
     &       (IDIFR2.GE.1).AND.(IDIFR2.LE.3)) THEN
            IF ((IDIFR1.EQ.1).AND.(IDIFR2.EQ.1))
     &         ICEVTG(IDCHSY,25) = ICEVTG(IDCHSY,25)+1
            IF ((IDIFR1.EQ.2).AND.(IDIFR2.EQ.2))
     &         ICEVTG(IDCHSY,26) = ICEVTG(IDCHSY,26)+1
            IF ((IDIFR1.EQ.1).AND.(IDIFR2.EQ.2))
     &         ICEVTG(IDCHSY,27) = ICEVTG(IDCHSY,27)+1
            IF ((IDIFR1.EQ.2).AND.(IDIFR2.EQ.1))
     &         ICEVTG(IDCHSY,28) = ICEVTG(IDCHSY,28)+1
         ELSE
            WRITE(ErrorOut,1001) IPROCE,IDIFR1,IDIFR2
         ENDIF
      ENDIF
      IF ((IDIFR1+IDIFR2.EQ.0).AND.(KHDIR.GE.1).AND.(KHDIR.LE.3))
     &                                                       THEN
         ICEVTG(IDCHSY,10+KHDIR) = ICEVTG(IDCHSY,10+KHDIR)+1
         ICEVTG(IDCHSY,10+KHDIR) = ICEVTG(IDCHSY,10+KHDIR)+1
         ICEVTG(IDCHSY,10+KHDIR) = ICEVTG(IDCHSY,10+KHDIR)+1
      ENDIF
      ICEVTG(IDCHSY,14) = ICEVTG(IDCHSY,14)+KSPOM
      ICEVTG(IDCHSY,15) = ICEVTG(IDCHSY,15)+KHPOM
      ICEVTG(IDCHSY,16) = ICEVTG(IDCHSY,16)+KSREG
      ICEVTG(IDCHSY,17) = ICEVTG(IDCHSY,17)+(KSTRG+KHTRG)
      ICEVTG(IDCHSY,18) = ICEVTG(IDCHSY,18)+(KSLOO+KHLOO)

      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===phoini=============================================================*
c
CDECK  ID>, DT_PHOINI
      SUBROUTINE DT_PHOINI

c***********************************************************************
c Initialization PHOJET-event generator for nucleon-nucleon interact.  *
c This version dated 16.11.95 is written by S. Roesler                 *
c Last change: s.r. 21.01.01                                           *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ZERO=0.0D0,ONE=1.0D0)

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD

c
c parameters for cascade calculations:
c maximum mumber of PDF's which can be defined in phojet (limited
c by the dimension of ipdfs in pho_setpdf)
      PARAMETER (MAXPDF = 20)
c PDF parametrization and number of set for the first 30 hadrons in
c the bamjet-code list
c   negative numbers mean that the PDF is set in phojet,
c   zero stands for "not a hadron"
      DIMENSION IPARPD(30),ISETPD(30)
c PDF parametrization
      DATA IPARPD /
     &  -5,-5, 0, 0, 0, 0,-5,-5,-5, 0, 0, 5,-5,-5, 5, 5, 5, 5, 5, 5,
     &   5, 5,-5, 5, 5, 0, 0, 0, 0, 0/
c number of set
      DATA ISETPD /
     &  -6,-6, 0, 0, 0, 0,-3,-6,-6, 0, 0, 2,-2,-2, 2, 2, 6, 6, 2, 6,
     &   6, 6,-2, 2, 2, 0, 0, 0, 0, 0/

c*PHOJET105a
C     COMMON /GLOCMS/ XECM,XPCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)
C     PARAMETER ( MAXPRO = 16 )
C     PARAMETER ( MAXTAB = 20 )
C     COMMON /HAXSEC/ XSECTA(4,-1:MAXPRO,4,MAXTAB),XSECT(6,-1:MAXPRO),
C    &                MXSECT(0:4,-1:MAXPRO,4),ECMSH(4,MAXTAB),ISTTAB
C     CHARACTER*8 MDLNA
C     COMMON /MODELS/ MDLNA(50),ISWMDL(50),PARMDL(200),IPAMDL(100)
C     COMMON /PROCES/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15)
c*PHOJET110
C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

c*
      DIMENSION PP(4),PT(4)

      LOGICAL LSTART
      DATA LSTART /.TRUE./

      IJP = IJPROJ
      IJT = IJTARG
      Q2  = VIRT
c lepton-projectiles: initialize real photon instead
      IF ((IJP.EQ.3).OR.(IJP.EQ.4).OR.(IJP.EQ.10).OR.(IJP.EQ.11)) THEN
         IJP = 7
         Q2  = ZERO
      ENDIF

      IF (LPHOIN) CALL PHO_INIT(-1,IDUM)

c switch Reggeon off
C     IPAMDL(3)= 0
      IF (IP.EQ.1) THEN
         IFPAP(1) = IDT_IPDGHA(IJP)
         IFPAB(1) = IJP
      ELSE
         IFPAP(1) = 2212
         IFPAB(1) = IDT_ICIHAD(IFPAP(1))
      ENDIF
      PMASS(1) = AAM(IFPAB(1))-SQRT(Q2)
      PVIRT(1) = PMASS(1)**2
      IF (IT.EQ.1) THEN
         IFPAP(2) = IDT_IPDGHA(IJT)
         IFPAB(2) = IJT
      ELSE
         IFPAP(2) = 2212
         IFPAB(2) = IDT_ICIHAD(IFPAP(2))
      ENDIF
      PMASS(2) = AAM(IFPAB(2))
      PVIRT(2) = ZERO
      DO 1 K=1,4
         PP(K) = ZERO
         PT(K) = ZERO
    1 CONTINUE
c get max. possible momenta of incoming particles to be used for PHOJET ini.
      PPF = ZERO
      PTF = ZERO
      SCPF= 1.5D0
      IF (UMO.GE.1.E5) THEN
         SCPF= 5.0D0
      ENDIF
      IF (NCOMPO.GT.0) THEN
         DO 2 I=1,NCOMPO
            IF (IT.GT.1) THEN
               CALL DT_NCLPOT(IEMUCH(I),IEMUMA(I),ITZ,IT,ZERO,ZERO,0)
            ELSE
               CALL DT_NCLPOT(IPZ,IP,IEMUCH(I),IEMUMA(I),ZERO,ZERO,0)
            ENDIF
            PPFTMP = MAX(PFERMP(1),PFERMN(1))
            PTFTMP = MAX(PFERMP(2),PFERMN(2))
            IF (PPFTMP.GT.PPF) PPF = PPFTMP
            IF (PTFTMP.GT.PTF) PTF = PTFTMP
    2    CONTINUE
      ELSE
         CALL DT_NCLPOT(IPZ,IP,ITZ,IT,ZERO,ZERO,0)
         PPF = MAX(PFERMP(1),PFERMN(1))
         PTF = MAX(PFERMP(2),PFERMN(2))
      ENDIF
      PTF = -PTF
      PPF = SCPF*PPF
      PTF = SCPF*PTF
      IF (IJP.EQ.7) THEN
         AMP2  = SIGN(PMASS(1)**2,PMASS(1))
         PP(3) = PPCM
         PP(4) = SQRT(AMP2+PP(3)**2)
      ELSE
         EPF = SQRT(PPF**2+PMASS(1)**2)
         CALL DT_LTNUC(PPF,EPF,PP(3),PP(4),2)
      ENDIF
      ETF = SQRT(PTF**2+PMASS(2)**2)
      CALL DT_LTNUC(PTF,ETF,PT(3),PT(4),3)
      ECMINI = SQRT((PP(4)+PT(4))**2-(PP(1)+PT(1))**2-
     &              (PP(2)+PT(2))**2-(PP(3)+PT(3))**2)
      IF (LSTART) THEN
         WRITE(ErrorOut,1001) IP,IPZ,SCPF,PPF,PP
 1001    FORMAT(
     &      ' DT_PHOINI:    PHOJET INITIALIZED FOR PROJECTILE A,Z = ',
     &      I3,',',I2,/,F4.1,'XP_F(MAX) = ',E10.3,'  P(MAX) = ',4E10.3)
         IF (NCOMPO.GT.0) THEN
            WRITE(ErrorOut,1002) SCPF,PTF,PT
         ELSE
            WRITE(ErrorOut,1003) IT,ITZ,SCPF,PTF,PT
         ENDIF
 1002    FORMAT(
     &      ' DT_PHOINI:    PHOJET INITIALIZED FOR TARGET EMULSION  ',
     &          /,F4.1,'XP_F(MAX) = ',E10.3,'  P(MAX) = ',4E10.3)
 1003    FORMAT(
     &      ' DT_PHOINI:    PHOJET INITIALIZED FOR TARGET     A,Z = ',
     &      I3,',',I2,/,F4.1,'XP_F(MAX) = ',E10.3,'  P(MAX) = ',4E10.3)
         WRITE(ErrorOut,1004) ECMINI
 1004    FORMAT(' E_CM = ',E10.3)
         IF (IJP.EQ.8) WRITE(ErrorOut,1005)
 1005    FORMAT(
     &      ' DT_PHOINI: WARNING! PROTON PARAMETERS USED FOR NEUTRON',
     &          ' PROJECTILE')
         LSTART = .FALSE.
      ENDIF
c switch off new diffractive cross sections at low energies for nuclei
c (temporary solution)
      IF ((ISWMDL(30).NE.0).AND.((IP.GT.1).OR.(IT.GT.1))) THEN
         WRITE(ErrorOut,'(1X,A)')
     &      ' DT_PHOINI: MODEL-SWITCH 30 FOR NUCLEI RE-SET !'
         CALL PHO_SETMDL(30,0,1)
      ENDIF
c
C     IF (IJP.EQ.7) THEN
C        AMP2  = SIGN(PMASS(1)**2,PMASS(1))
C        PP(3) = PPCM
C        PP(4) = SQRT(AMP2+PP(3)**2)
C     ELSE
C        PFERMX = ZERO
C        IF (IP.GT.1) PFERMX = 0.5D0
C        EFERMX = SQRT(PFERMX**2+PMASS(1)**2)
C        CALL DT_LTNUC(PFERMX,EFERMX,PP(3),PP(4),2)
C     ENDIF
C     PFERMX = ZERO
C     IF ((IT.GT.1).OR.(NCOMPO.GT.0)) PFERMX = -0.5D0
C     EFERMX = SQRT(PFERMX**2+PMASS(2)**2)
C     CALL DT_LTNUC(PFERMX,EFERMX,PT(3),PT(4),3)
c*sr 26.10.96
      ISAV = IPAMDL(13)
      IF ((ISHAD(2).EQ.1).AND.
     &   ((IJPROJ.EQ. 7).OR.(IJPROJ.EQ.3).OR.(IJPROJ.EQ.4).OR.
     &    (IJPROJ.EQ.10).OR.(IJPROJ.EQ.11))) IPAMDL(13) = 1
c*

      CALL PHO_EVENT(-1,PP,PT,SIGMAX,IREJ1)

c*sr 26.10.96
      IPAMDL(13) = ISAV
c*
c
c patch for cascade calculations:
c define parton distribution functions for other hadrons, i.e. other
c then defined already in phojet
      IF (IOGLB.EQ.100) THEN
         WRITE(ErrorOut,1006)
 1006    FORMAT(/,1X,'PHOINI: ADDITIONAL PARTON DISTRIBUTION FUNCTIONS',
     &          ' ASSIGED (ID,IPAR,ISET)',/)
         NPDF = 0
         DO 3 I=1,30
            IF (IPARPD(I).NE.0) THEN
               NPDF = NPDF+1
               IF (NPDF.GT.MAXPDF) STOP ' PHOINI: NPDF > MAXPDF !'
               IF ((IPARPD(I).GT.0).AND.(ISETPD(I).GT.0)) THEN
                  IDPDG = IDT_IPDGHA(I)
                  IPAR  = IPARPD(I)
                  ISET  = ISETPD(I)
                  WRITE(ErrorOut,
     * '(13X,A8,3I6)') ANAME(I),IDPDG,IPAR,ISET
                  CALL PHO_SETPDF(IDPDG,IDUM,IPAR,ISET,0,0,-1)
               ENDIF
            ENDIF
    3    CONTINUE
      ENDIF


C     CALL PHO_PHIST(-1,SIGMAX)

      IF (IREJ1.NE.0) THEN
         WRITE(ErrorOut,1000)
 1000    FORMAT(1X,'PHOINI:   PHOJET EVENT-INITIALIZATION FAILED!')
         STOP
      ENDIF

      RETURN
      END

c
c===eventd=============================================================*
c
CDECK  ID>, DT_EVENTD
      SUBROUTINE DT_EVENTD(IREJ)

c***********************************************************************
c Quasi-elastic neutrino nucleus scattering.                           *
c This version dated 29.04.00 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,TINY5=1.0D-5)
      PARAMETER (SQTINF=1.0D+15)

      LOGICAL LFIRST

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME


      PARAMETER (MAXLND=4000)
      COMMON/PYJETS/N,NPAD,K(MAXLND,5),P(MAXLND,5),V(MAXLND,5)


c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c steering flags for qel neutrino scattering modules
      COMMON /QNEUTO/ DSIGSU,DSIGMC,NDSIG,NEUTYP,NEUDEC

      COMMON /QNPOL/ POLARX(4),PMODUL


      INTEGER PYK


      DATA LFIRST /.TRUE./

      IREJ = 0

      IF (LFIRST) THEN
         LFIRST = .FALSE.
         CALL DT_MASS_INI
      ENDIF

c JETSET parameter
      CALL DT_INITJS(0)

c interacting target nucleon
      LTYP = NEUTYP
      IF (NEUDEC.LE.9) THEN
         IF ((LTYP.EQ.1).OR.(LTYP.EQ.3).OR.(LTYP.EQ.5)) THEN
            NUCTYP = 2112
            NUCTOP = 2
         ELSE
            NUCTYP = 2212
            NUCTOP = 1
         ENDIF
      ELSE
         RTYP  = DT_RNDM(RTYP)
         ZFRAC = DBLE(ITZ)/DBLE(IT)
         IF (RTYP.LE.ZFRAC) THEN
            NUCTYP = 2212
            NUCTOP = 1
         ELSE
            NUCTYP = 2112
            NUCTOP = 2
         ENDIF
      ENDIF

c select first nucleon in list with matching id and reset all other
c nucleons which have been marked as "wounded" by ININUC
      IFOUND = 0
      DO 1 I=1,NHKK
         IF ((IDHKK(I).EQ.NUCTYP).AND.(IFOUND.EQ.0)) THEN
            ISTHKK(I) = 12
            IFOUND    = 1
            IDX = I
         ELSE
            IF (ISTHKK(I).EQ.12) ISTHKK(I) = 14
         ENDIF
    1 CONTINUE
      IF (IFOUND.EQ.0)
     &   STOP ' EVENTD: INTERACTING TARGET NUCLEON NOT FOUND! '

c correct position of proj. lepton: assume position of target nucleon
      DO 3 I=1,4
         VHKK(I,1) = VHKK(I,IDX)
         WHKK(I,1) = WHKK(I,IDX)
    3 CONTINUE

c load initial momenta for conservation check
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(ZERO,ZERO,PPROJ,EPROJ,1,IDUM,IDUM)
         CALL DT_EVTEMC(PHKK(1,IDX),PHKK(2,IDX),PHKK(3,IDX),PHKK(4,IDX),
     &                                                      2,IDUM,IDUM)
      ENDIF

c quasi-elastic scattering
      IF (NEUDEC.LT.9) THEN
         CALL DT_QEL_POL(EPROJ,LTYP,PHKK(1,IDX),PHKK(2,IDX),PHKK(3,IDX),
     &                                          PHKK(4,IDX),PHKK(5,IDX))
c  CC event on p or n
      ELSEIF (NEUDEC.EQ.10) THEN
         CALL DT_GEN_DELTA(EPROJ,LTYP,NUCTOP,1,PHKK(1,IDX),PHKK(2,IDX),
     &                     PHKK(3,IDX),PHKK(4,IDX),PHKK(5,IDX))
c  NC event on p or n
      ELSEIF (NEUDEC.EQ.11) THEN
         CALL DT_GEN_DELTA(EPROJ,LTYP,NUCTOP,2,PHKK(1,IDX),PHKK(2,IDX),
     &                     PHKK(3,IDX),PHKK(4,IDX),PHKK(5,IDX))
      ENDIF

c get final state particles from Lund-common and write them into HKKEVT
      NPOINT(1) = NHKK+1
      NPOINT(4) = NHKK+1

      NLINES = PYK(0,1)

      NHKK0  = NHKK+1
      DO 4 I=4,NLINES
         IF (K(I,1).EQ.1) THEN
            ID = K(I,2)
            PX = P(I,1)
            PY = P(I,2)
            PZ = P(I,3)
            PE = P(I,4)
            CALL DT_EVTPUT(1,ID,1,IDX,PX,PY,PZ,PE,0,0,0)
            IDBJ = IDT_ICIHAD(ID)
            EKIN = PHKK(4,NHKK)-PHKK(5,NHKK)
            IF ((IDBJ.EQ.1).OR.(IDBJ.EQ.8)) THEN
               IF (EKIN.LE.EPOT(2,IDBJ)) ISTHKK(NHKK) = 16
            ENDIF
            VHKK(1,NHKK) = VHKK(1,IDX)
            VHKK(2,NHKK) = VHKK(2,IDX)
            VHKK(3,NHKK) = VHKK(3,IDX)
            VHKK(4,NHKK) = VHKK(4,IDX)
C           IF (I.EQ.4) THEN
C              WHKK(1,NHKK) = POLARX(1)
C              WHKK(2,NHKK) = POLARX(2)
C              WHKK(3,NHKK) = POLARX(3)
C              WHKK(4,NHKK) = POLARX(4)
C           ELSE
               WHKK(1,NHKK) = WHKK(1,IDX)
               WHKK(2,NHKK) = WHKK(2,IDX)
               WHKK(3,NHKK) = WHKK(3,IDX)
               WHKK(4,NHKK) = WHKK(4,IDX)
C           ENDIF
            IF (LEMCCK) CALL DT_EVTEMC(-PX,-PY,-PZ,-PE,2,IDUM,IDUM)
         ENDIF
    4 CONTINUE

      IF (LEMCCK) THEN
         CHKLEV = TINY5
         CALL DT_EVTEMC(DUM,DUM,DUM,CHKLEV,-1,778,IREJ1)
         IF (IREJ1.NE.0) CALL DT_EVTOUT(4)
      ENDIF

c transform momenta into cms (as required for inc etc.)
      DO 5 I=NHKK0,NHKK
         IF (ISTHKK(I).EQ.1) THEN
            CALL DT_LTNUC(PHKK(3,I),PHKK(4,I),PZ,PE,3)
            PHKK(3,I) = PZ
            PHKK(4,I) = PE
         ENDIF
    5 CONTINUE

      RETURN
      END
c
c===kkevnt=============================================================*
c
CDECK  ID>, DT_KKEVNT
      SUBROUTINE DT_KKEVNT(KKMAT,IREJ)

c***********************************************************************
c Treatment of complete nucleus-nucleus or hadron-nucleus scattering   *
c without nuclear effects (one event).                                 *
c This subroutine is an update of the previous version (KKEVT) written *
c by J. Ranft/ H.-J. Moehring.                                         *
c This version dated 20.04.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10)


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c interface HADRIN-DPM
      COMMON /HNTHRE/ EHADTH,EHADLO,EHADHI,INTHAD,IDXTA

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c coordinates of nucleons
      COMMON /DTNUCO/ PKOO(3,MAXNCL),TKOO(3,MAXNCL)

c interface between Glauber formalism and DPM
      COMMON /DTGLIF/ JSSH(MAXNCL),JTSH(MAXNCL),
     &                INTER1(MAXINT),INTER2(MAXINT)

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c central particle production, impact parameter biasing
      COMMON /DTIMPA/ BIMIN,BIMAX,XSFRAC,ICENTR

c*temporary
c statistics: Glauber-formalism
      COMMON /DTSTA3/ ICWP,ICWT,NCSY,ICWPG,ICWTG,ICIG,IPGLB,ITGLB,NGLB

c*

      DATA NEVOLD,IPOLD,ITOLD,JJPOLD,EPROLD /4*0,0.0D0/

      IREJ   = 0
      ICREQU = ICREQU+1
      NC     = 0

    1 CONTINUE
      ICSAMP = ICSAMP+1
      NC     = NC+1
ccc &&&&&&& kk
ccc      IF (MOD(NC,10).EQ.0 ) THEN
      IF (MOD(NC,10).EQ.0  .and.  NC .gt. 100) THEN
cccc
         WRITE(ErrorOut,1000) NEVHKK, NC
 1000    FORMAT(1X,'KKEVNT: EVENT ',I8,' REJECTED ', i8,
     *       ' TIMES')
         GOTO 9999
      ENDIF

c initialize DTEVT1/DTEVT2
      CALL DT_EVTINI

c We need the following only in order to sample nucleon coordinates.
c However we don't have parameters (cross sections, slope etc.)
c for neutrinos available. Therefore switch projectile to proton
c in this case.
      IF (MCGENE.EQ.4) THEN
         JJPROJ = 1
      ELSE
         JJPROJ = IJPROJ
      ENDIF

   10 CONTINUE
      IF ( (NEVHKK.NE.NEVOLD).OR.(ICENTR.GT.0).OR.
c make sure that Glauber-formalism is called each time the interaction
c configuration changed
     &     (IP.NE.IPOLD).OR.(IT.NE.ITOLD).OR.(JJPROJ.NE.JJPOLD).OR.
     &     (ABS(EPROJ-EPROLD).GT.TINY10) ) THEN
c sample number of nucleon-nucleon coll. according to Glauber-form.
         CALL DT_GLAUBE(IP,IT,JJPROJ,BIMPAC,NN,NP,NT,JSSH,JTSH,KKMAT)
         NWTSAM = NN
         NWASAM = NP
         NWBSAM = NT
         NEVOLD = NEVHKK
         IPOLD  = IP
         ITOLD  = IT
         JJPOLD = JJPROJ
         EPROLD = EPROJ
      ENDIF

c force diffractive particle production in h-K interactions
      IF (((ABS(ISINGD).GT.1).OR.(ABS(IDOUBD).GT.1)).AND.
     &    (IP.EQ.1).AND.(NN.NE.1)) THEN
         NEVOLD = 0
         GOTO 10
      ENDIF

c check number of involved proj. nucl. (NP) if central prod.is requested
      IF (ICENTR.GT.0) THEN
         CALL DT_CHKCEN(IP,IT,NP,NT,IBACK)
         IF (IBACK.GT.0) GOTO 10
      ENDIF

c get initial nucleon-configuration in projectile and target
c rest-system (including Fermi-momenta if requested)
      CALL DT_ININUC(IJPROJ,IP,IPZ,PKOO,JSSH,1)
      MODE = 2
      IF (EPROJ.LE.EHADTH) MODE = 3
      CALL DT_ININUC(IJTARG,IT,ITZ,TKOO,JTSH,MODE)

      IF ((MCGENE.NE.3).AND.(MCGENE.NE.4)) THEN

c activate HADRIN at low energies (implemented for h-N scattering only)
         IF (EPROJ.LE.EHADHI) THEN
            IF (EHADTH.LT.ZERO) THEN
c   smooth transition btwn. DPM and HADRIN
               FRAC = (EPROJ-EHADLO)/(EHADHI-EHADLO)
               RR   = DT_RNDM(FRAC)
               IF (RR.GT.FRAC) THEN
                  IF (IP.EQ.1) THEN
                     CALL DT_HADCOL(IJPROJ,PPROJ,IDXTA,IREJ1)
                     IF (IREJ1.GT.0) GOTO 1
                     RETURN
                  ELSE
                     WRITE(ErrorOut,1001) IP,IT,EPROJ,EHADTH
                  ENDIF
               ENDIF
            ELSE
c   fixed threshold for onset of production via HADRIN
               IF (EPROJ.LE.EHADTH) THEN
                  IF (IP.EQ.1) THEN
                     CALL DT_HADCOL(IJPROJ,PPROJ,IDXTA,IREJ1)
                     IF (IREJ1.GT.0) GOTO 1
                     RETURN
                  ELSE
                     WRITE(ErrorOut,1001) IP,IT,EPROJ,EHADTH
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
 1001    FORMAT(1X,'KKEVNT:   WARNING! INTERACTION OF PROJ. (M=',
     &          I3,') WITH TARGET (M=',I3,')',/,11X,
     &          'AT E_LAB=',F5.1,'GEV (THRESHOLD-ENERGY: ',F3.1,
     &          'GEV) CANNOT BE HANDLED')

c sampling of momentum-x fractions & flavors of chain ends
         CALL DT_SPLPTN(NN)

c Lorentz-transformation of wounded nucleons into nucl.-nucl. cms
         CALL DT_NUC2CM

c collect momenta of chain ends and put them into DTEVT1
         CALL DT_GETPTN(IP,NN,NCSY,IREJ1)
         IF (IREJ1.NE.0) GOTO 1

      ENDIF

c handle chains including fragmentation (two-chain approximation)
      IF (MCGENE.EQ.1) THEN
c  two-chain approximation
         CALL DT_EVENTA(IJPROJ,IP,IT,NCSY,IREJ1)
         IF (IREJ1.NE.0) THEN
            IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in KKEVNT'
            GOTO 1
         ENDIF
      ELSEIF (MCGENE.EQ.2) THEN
c  multiple-Po exchange including minijets
         CALL DT_EVENTB(NCSY,IREJ1)
         IF (IREJ1.NE.0) THEN
            IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 2 in KKEVNT'
            GOTO 1
         ENDIF
      ELSEIF (MCGENE.EQ.3) THEN

         STOP ' THIS VERSION DOES NOT CONTAIN LEPTO !'

      ELSEIF (MCGENE.EQ.4) THEN
c  quasi-elastic neutrino scattering
         CALL DT_EVENTD(IREJ1)
         IF (IREJ1.NE.0) THEN
            IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 4 in KKEVNT'
            GOTO 1
         ENDIF
      ELSE
         WRITE(ErrorOut,1002) MCGENE
 1002    FORMAT(1X,'KKEVNT:   WARNING! EVENT-GENERATOR',I4,
     &         ' NOT AVAILABLE - PROGRAM STOPPED')
         STOP
      ENDIF

      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===chkcen=============================================================*
c
CDECK  ID>, DT_CHKCEN
      SUBROUTINE DT_CHKCEN(IP,IT,NP,NT,IBACK)

c***********************************************************************
c Check of number of involved projectile nucleons if central production*
c is requested.                                                        *
c Adopted from a part of the old KKEVT routine which was written by    *
c J. Ranft/H.-J.Moehring.                                              *
c This version dated 13.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c central particle production, impact parameter biasing
      COMMON /DTIMPA/ BIMIN,BIMAX,XSFRAC,ICENTR


      IBACK = 0

c old version
      IF (ICENTR.EQ.2) THEN
         IF (IP.LT.IT) THEN
            IF (IP.LE.8) THEN
               IF (NP.LT.IP-1) IBACK = 1
            ELSEIF (IP.LE.16) THEN
               IF (NP.LT.IP-2) IBACK = 1
            ELSEIF (IP.LE.32) THEN
               IF (NP.LT.IP-3) IBACK = 1
            ELSEIF (IP.GE.33) THEN
               IF (NP.LT.IP-5) IBACK = 1
            ENDIF
         ELSEIF (IP.EQ.IT) THEN
            IF (IP.EQ.32) THEN
               IF ((NP.LT.22).OR.(NT.LT.22)) IBACK = 1
            ELSE
               IF (NP.LT.IP-IP/8) IBACK = 1
            ENDIF
         ELSEIF (ABS(IP-IT).LT.3) THEN
            IF (NP.LT.IP-IP/8) IBACK = 1
         ENDIF
      ELSE
c new version (DPMJET, 5.6.99)
         IF (IP.LT.IT) THEN
            IF (IP.LE.8) THEN
               IF (NP.LT.IP-1) IBACK = 1
            ELSEIF (IP.LE.16) THEN
               IF (NP.LT.IP-2) IBACK = 1
            ELSEIF (IP.LT.32) THEN
               IF (NP.LT.IP-3) IBACK = 1
            ELSEIF (IP.GE.32) THEN
               IF (IT.LE.150) THEN
c   Example: S-Ag
                  IF (NP.LT.IP-1) IBACK = 1
               ELSE
c   Example: S-Au
                  IF (NP.LT.IP) IBACK = 1
               ENDIF
            ENDIF
         ELSEIF (IP.EQ.IT) THEN
c   Example: S-S
           IF (IP.EQ.32) THEN
              IF ((NP.LT.22).OR.(NT.LT.22)) IBACK = 1
c   Example: Pb-Pb
           ELSE
              IF (NP.LT.IP-IP/4) IBACK = 1
           ENDIF
         ELSEIF (ABS(IP-IT).LT.3) THEN
            IF (NP.LT.IP-IP/8) IBACK = 1
         ENDIF
      ENDIF

      ICCPRO = ICCPRO+1

      RETURN
      END
c
c===ininuc=============================================================*
c
CDECK  ID>, DT_ININUC
      SUBROUTINE DT_ININUC(ID,NMASS,NCH,COORD,JS,IMODE)

c***********************************************************************
c Samples initial configuration of nucleons in nucleus with mass NMASS *
c including Fermi-momenta (if reqested).                               *
c          ID             BAMJET-code for hadrons (instead of nuclei)  *
c          NMASS          mass number of nucleus (number of nucleons)  *
c          NCH            charge of nucleus                            *
c          COORD(3,NMASS) coordinates of nucleons inside nucleus in fm *
c          JS(NMASS) > 0  nucleon undergoes nucleon-nucleon interact.  *
c          IMODE = 1      projectile nucleus                           *
c                = 2      target     nucleus                           *
c                = 3      target     nucleus (E_lab<E_thr for HADRIN)  *
c Adopted from a part of the old KKEVT routine which was written by    *
c J. Ranft/H.-J.Moehring.                                              *
c This version dated 13.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (FM2MM=1.0D-12)


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c auxiliary common for chain system storage (DTUNUC 1.x)
      COMMON /DTCHSY/ ISKPCH(8,MAXINT),IPOSP(MAXNCL),IPOST(MAXNCL)

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c flavors of partons (DTUNUC 1.x)
      COMMON /DTDPMF/ IPVQ(MAXVQU),IPPV1(MAXVQU),IPPV2(MAXVQU),
     &                ITVQ(MAXVQU),ITTV1(MAXVQU),ITTV2(MAXVQU),
     &                IPSQ(MAXSQU),IPSQ2(MAXSQU),
     &                IPSAQ(MAXSQU),IPSAQ2(MAXSQU),
     &                ITSQ(MAXSQU),ITSQ2(MAXSQU),
     &                ITSAQ(MAXSQU),ITSAQ2(MAXSQU),
     &                KKPROJ(MAXVQU),KKTARG(MAXVQU)

c interface HADRIN-DPM
      COMMON /HNTHRE/ EHADTH,EHADLO,EHADHI,INTHAD,IDXTA


      DIMENSION PF(4),PFTOT(4),COORD(3,MAXNCL),JS(MAXNCL)

c number of neutrons
      NNEU = NMASS-NCH
c initializations
      NP = 0
      NN = 0
      DO 1 K=1,4
         PFTOT(K) = 0.0D0
    1 CONTINUE
      MODE   = IMODE
      IF (IMODE.GT.2) MODE = 2
c*sr 29.5. new NPOINT(1)-definition
C     IF (IMODE.GE.2) NPOINT(1) = NHKK+1
c*
      NHADRI = 0
      NC     = NHKK

c get initial configuration
      DO 2 I=1,NMASS
         NHKK = NHKK+1
         IF (JS(I).GT.0) THEN
            ISTHKK(NHKK) = 10+MODE
            IF (IMODE.EQ.3) THEN
c   additional treatment if HADRIN-generator is requested
               NHADRI = NHADRI+1
               IF (NHADRI.EQ.1) IDXTA  = NHKK
               IF (NHADRI.GT.1) ISTHKK(NHKK) = 14
            ENDIF
         ELSE
            ISTHKK(NHKK) = 12+MODE
         ENDIF
         IF (NMASS.GE.2) THEN
c   treatment for nuclei
            FRAC = 1.0D0-DBLE(NCH)/DBLE(NMASS)
            RR   = DT_RNDM(FRAC)
            IF ((RR.LT.FRAC).AND.(NN.LT.NNEU)) THEN
               IDX = 8
               NN  = NN+1
            ELSEIF ((RR.GE.FRAC).AND.(NP.LT.NCH)) THEN
               IDX = 1
               NP  = NP+1
            ELSEIF (NN.LT.NNEU) THEN
               IDX = 8
               NN  = NN+1
            ELSEIF (NP.LT.NCH)  THEN
               IDX = 1
               NP  = NP+1
            ENDIF
            IDHKK(NHKK) = IDT_IPDGHA(IDX)
            IDBAM(NHKK) = IDX
            IF (MODE.EQ.1) THEN
               IPOSP(I)  = NHKK
               KKPROJ(I) = IDX
            ELSE
               IPOST(I)  = NHKK
               KKTARG(I) = IDX
            ENDIF
            IF (IDX.EQ.1) THEN
               PFER = PFERMP(MODE)
               PBIN = SQRT(2.0D0*EBINDP(MODE)*AAM(1))
            ELSE
               PFER = PFERMN(MODE)
               PBIN = SQRT(2.0D0*EBINDN(MODE)*AAM(8))
            ENDIF
            CALL DT_FER4M(PFER,PBIN,PF(1),PF(2),PF(3),PF(4),IDX)
            DO 3 K=1,4
               PFTOT(K) = PFTOT(K)+PF(K)
               PHKK(K,NHKK) = PF(K)
    3       CONTINUE
            PHKK(5,NHKK) = AAM(IDX)
         ELSE
c   treatment for hadrons
            IDHKK(NHKK)  = IDT_IPDGHA(ID)
            IDBAM(NHKK)  = ID
            PHKK(4,NHKK) = AAM(ID)
            PHKK(5,NHKK) = AAM(ID)
C* VDM assumption
C            IF (IDHKK(NHKK).EQ.22) THEN
C               PHKK(4,NHKK) = AAM(33)
C               PHKK(5,NHKK) = AAM(33)
C            ENDIF
            IF (MODE.EQ.1) THEN
               IPOSP(I)  = NHKK
               KKPROJ(I) = ID
               PHKK(5,NHKK) = PHKK(5,NHKK)-SQRT(VIRT)
            ELSE
               IPOST(I)  = NHKK
               KKTARG(I) = ID
            ENDIF
         ENDIF
         DO 4 K=1,3
            VHKK(K,NHKK) = COORD(K,I)*FM2MM
            WHKK(K,NHKK) = COORD(K,I)*FM2MM
    4    CONTINUE
         IF (MODE.EQ.2) VHKK(1,NHKK) = VHKK(1,NHKK)+BIMPAC*FM2MM
         IF (MODE.EQ.2) WHKK(1,NHKK) = WHKK(1,NHKK)+BIMPAC*FM2MM
         VHKK(4,NHKK) = 0.0D0
         WHKK(4,NHKK) = 0.0D0
    2 CONTINUE

c balance Fermi-momenta
      IF (NMASS.GE.2) THEN
         DO 5 I=1,NMASS
            NC = NC+1
            DO 6 K=1,3
               PHKK(K,NC) = PHKK(K,NC)-PFTOT(K)/DBLE(NMASS)
    6       CONTINUE
            PHKK(4,NC) = SQRT(PHKK(5,NC)**2+PHKK(1,NC)**2+
     &                        PHKK(2,NC)**2+PHKK(3,NC)**2)
    5    CONTINUE
      ENDIF

      RETURN
      END
c
c===fer4m==============================================================*
c
CDECK  ID>, DT_FER4M
      SUBROUTINE DT_FER4M(PFERM,PBIND,PXT,PYT,PZT,ET,KT)

c***********************************************************************
c Sampling of nucleon Fermi-momenta from distributions at T=0.         *
c                                   processed by S. Roesler, 17.10.95  *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      LOGICAL LSTART

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI


      DATA LSTART /.TRUE./

      ILOOP = 0
      IF (LFERMI) THEN
         IF (LSTART) THEN
            WRITE(ErrorOut,1000)
 1000       FORMAT(/,1X,'FER4M:   SAMPLING OF FERMI-MOMENTA ACTIVATED')
            LSTART = .FALSE.
         ENDIF
    1    CONTINUE
         CALL DT_DFERMI(PABS)
         PABS = PFERM*PABS
C        IF (PABS.GE.PBIND) THEN
C           ILOOP = ILOOP+1
C           IF (MOD(ILOOP,500).EQ.0) THEN
C              WRITE(LOUT,1001) PABS,PBIND,ILOOP
C1001          FORMAT(1X,'FER4M:    Fermi-mom. corr. for binding',
C    &                ' energy ',2E12.3,I6)
C           ENDIF
C           GOTO 1
C        ENDIF
         CALL DT_DPOLI(POLC,POLS)
         CALL DT_DSFECF(SFE,CFE)
         CXTA = POLS*CFE
         CYTA = POLS*SFE
         CZTA = POLC
         ET   = SQRT(PABS*PABS+AAM(KT)**2)
         PXT  = CXTA*PABS
         PYT  = CYTA*PABS
         PZT  = CZTA*PABS
      ELSE
         ET   = AAM(KT)
         PXT  = 0.0D0
         PYT  = 0.0D0
         PZT  = 0.0D0
      ENDIF

      RETURN
      END
c
c===nuc2cm=============================================================*
c
CDECK  ID>, DT_NUC2CM
      SUBROUTINE DT_NUC2CM

c***********************************************************************
c Lorentz-transformation of all wounded nucleons from Lab. to nucl.-   *
c nucl. cms. (This subroutine replaces NUCMOM.)                        *
c This version dated 15.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY3=1.0D-3)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c*temporary
c statistics: Glauber-formalism
      COMMON /DTSTA3/ ICWP,ICWT,NCSY,ICWPG,ICWTG,ICIG,IPGLB,ITGLB,NGLB

c*

      ICWP = 0
      ICWT = 0
      NWTACC = 0
      NWAACC = 0
      NWBACC = 0

      NPOINT(1) = NHKK+1
      NEND      = NHKK
      DO 1 I=1,NEND
         IF ((ISTHKK(I).EQ.11).OR.(ISTHKK(I).EQ.12)) THEN
            IF (ISTHKK(I).EQ.11) NWAACC = NWAACC+1
            IF (ISTHKK(I).EQ.12) NWBACC = NWBACC+1
            MODE = ISTHKK(I)-9
C            IF (IDHKK(I).EQ.22) THEN
C* VDM assumption
C               PEIN = AAM(33)
C               IDB  = 33
C            ELSE
C               PEIN = PHKK(4,I)
C               IDB  = IDBAM(I)
C            ENDIF
C            CALL DT_LTRANS(PHKK(1,I),PHKK(2,I),PHKK(3,I),PEIN,
C     &           PX,PY,PZ,PE,IDB,MODE)
            IF (PHKK(5,I).GT.ZERO) THEN
               CALL DT_LTRANS(PHKK(1,I),PHKK(2,I),PHKK(3,I),PHKK(4,I),
     &              PX,PY,PZ,PE,IDBAM(I),MODE)
            ELSE
               PX = PGAMM(1)
               PY = PGAMM(2)
               PZ = PGAMM(3)
               PE = PGAMM(4)
            ENDIF
            IST = ISTHKK(I)-2
            ID  = IDHKK(I)
C* VDM assumption
C            IF (ID.EQ.22) ID = 113
            CALL DT_EVTPUT(IST,ID,I,0,PX,PY,PZ,PE,0,0,0)
            IF (ISTHKK(I).EQ.11) ICWP = ICWP+1
            IF (ISTHKK(I).EQ.12) ICWT = ICWT+1
         ENDIF
    1 CONTINUE

      NWTACC = MAX(NWAACC,NWBACC)
      ICDPR  = ICDPR+ICWP
      ICDTA  = ICDTA+ICWT
c*temporary
      IF ((ICWP.EQ.0).OR.(ICWT.EQ.0)) THEN
         CALL DT_EVTOUT(4)
         STOP
      ENDIF

      RETURN
      END
c
c===splptn=============================================================*
c
CDECK  ID>, DT_SPLPTN
      SUBROUTINE DT_SPLPTN(NN)

c***********************************************************************
c SamPLing of ParToN momenta and flavors.                              *
c This version dated 15.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ


c sample flavors of sea-quarks
      CALL DT_SPLFLA(NN,1)

c sample x-values of partons at chain ends
      ECM = UMO
      CALL DT_XKSAMP(NN,ECM)

c samle flavors
      CALL DT_SPLFLA(NN,2)

      RETURN
      END
c
c===splfla=============================================================*
c
CDECK  ID>, DT_SPLFLA
      SUBROUTINE DT_SPLFLA(NN,MODE)

c***********************************************************************
c SamPLing of FLAvors of partons at chain ends.                        *
c This subroutine replaces FLKSAA/FLKSAM.                              *
c            NN            number of nucleon-nucleon interactions      *
c            MODE = 1      sea-flavors                                 *
c                 = 2      valence-flavors                             *
c Based on the original version written by J. Ranft/H.-J. Moehring.    *
c This version dated 16.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c flavors of partons (DTUNUC 1.x)
      COMMON /DTDPMF/ IPVQ(MAXVQU),IPPV1(MAXVQU),IPPV2(MAXVQU),
     &                ITVQ(MAXVQU),ITTV1(MAXVQU),ITTV2(MAXVQU),
     &                IPSQ(MAXSQU),IPSQ2(MAXSQU),
     &                IPSAQ(MAXSQU),IPSAQ2(MAXSQU),
     &                ITSQ(MAXSQU),ITSQ2(MAXSQU),
     &                ITSAQ(MAXSQU),ITSAQ2(MAXSQU),
     &                KKPROJ(MAXVQU),KKTARG(MAXVQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPMI/ NVV,NSV,NVS,NSS,NDV,NVD,NDS,NSD,
     &                IXPV,IXPS,IXTV,IXTS,
     &                INTVV1(MAXVQU),INTVV2(MAXVQU),
     &                INTSV1(MAXVQU),INTSV2(MAXVQU),
     &                INTVS1(MAXVQU),INTVS2(MAXVQU),
     &                INTSS1(MAXSQU),INTSS2(MAXSQU),
     &                INTDV1(MAXVQU),INTDV2(MAXVQU),
     &                INTVD1(MAXVQU),INTVD2(MAXVQU),
     &                INTDS1(MAXSQU),INTDS2(MAXSQU),
     &                INTSD1(MAXSQU),INTSD2(MAXSQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPM0/ IFROVP(MAXVQU),ITOVP(MAXVQU),IFROSP(MAXSQU),
     &                IFROVT(MAXVQU),ITOVT(MAXVQU),IFROST(MAXSQU)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      IF (MODE.EQ.1) THEN
c sea-flavors
         DO 1 I=1,NN
            IPSQ(I)  = INT(1.0D0+DT_RNDM(CRONCO)*(2.0D0+SEASQ))
            IPSAQ(I) = -IPSQ(I)
    1    CONTINUE
         DO 2 I=1,NN
            ITSQ(I) = INT(1.0D0+DT_RNDM(CRONCO)*(2.0D0+SEASQ))
            ITSAQ(I)= -ITSQ(I)
    2    CONTINUE
      ELSEIF (MODE.EQ.2) THEN
c valence flavors
         DO 3 I=1,IXPV
            CALL DT_FLAHAD(KKPROJ(IFROVP(I)),IPVQ(I),IPPV1(I),IPPV2(I))
    3    CONTINUE
         DO 4 I=1,IXTV
            CALL DT_FLAHAD(KKTARG(IFROVT(I)),ITVQ(I),ITTV1(I),ITTV2(I))
    4    CONTINUE
      ENDIF

      RETURN
      END
c
c===getptn=============================================================*
c
CDECK  ID>, DT_GETPTN
      SUBROUTINE DT_GETPTN(IP,NN,NCSY,IREJ)

c***********************************************************************
c This subroutine collects partons at chain ends from temporary        *
c commons and puts them into DTEVT1.                                   *
c This version dated 15.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ZERO=0.0D0,OHALF=0.5D0)

      LOGICAL LCHK


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c auxiliary common for chain system storage (DTUNUC 1.x)
      COMMON /DTCHSY/ ISKPCH(8,MAXINT),IPOSP(MAXNCL),IPOST(MAXNCL)

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c x-values of partons (DTUNUC 1.x)
      COMMON /DTDPMX/ XPVQ(MAXVQU),XPVD(MAXVQU),
     &                XTVQ(MAXVQU),XTVD(MAXVQU),
     &                XPSQ(MAXSQU),XPSAQ(MAXSQU),
     &                XTSQ(MAXSQU),XTSAQ(MAXSQU)

c flavors of partons (DTUNUC 1.x)
      COMMON /DTDPMF/ IPVQ(MAXVQU),IPPV1(MAXVQU),IPPV2(MAXVQU),
     &                ITVQ(MAXVQU),ITTV1(MAXVQU),ITTV2(MAXVQU),
     &                IPSQ(MAXSQU),IPSQ2(MAXSQU),
     &                IPSAQ(MAXSQU),IPSAQ2(MAXSQU),
     &                ITSQ(MAXSQU),ITSQ2(MAXSQU),
     &                ITSAQ(MAXSQU),ITSAQ2(MAXSQU),
     &                KKPROJ(MAXVQU),KKTARG(MAXVQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPMI/ NVV,NSV,NVS,NSS,NDV,NVD,NDS,NSD,
     &                IXPV,IXPS,IXTV,IXTS,
     &                INTVV1(MAXVQU),INTVV2(MAXVQU),
     &                INTSV1(MAXVQU),INTSV2(MAXVQU),
     &                INTVS1(MAXVQU),INTVS2(MAXVQU),
     &                INTSS1(MAXSQU),INTSS2(MAXSQU),
     &                INTDV1(MAXVQU),INTDV2(MAXVQU),
     &                INTVD1(MAXVQU),INTVD2(MAXVQU),
     &                INTDS1(MAXSQU),INTDS2(MAXSQU),
     &                INTSD1(MAXSQU),INTSD2(MAXSQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPM0/ IFROVP(MAXVQU),ITOVP(MAXVQU),IFROSP(MAXSQU),
     &                IFROVT(MAXVQU),ITOVT(MAXVQU),IFROST(MAXSQU)


      DIMENSION PP1(4),PP2(4),PT1(4),PT2(4),PP(4),PT(4)

      DATA AMSS,AMVS,AMDS,AMVD,AMVV/0.4D0,2.0D0,2.0D0,2.5D0,2.0D0/

      IREJ      = 0
      NCSY      = 0
      NPOINT(2) = NHKK+1

c sea-sea chains
      DO 10 I=1,NSS
         IF (ISKPCH(1,I).EQ.99) GOTO 10
         ICCHAI(1,1) = ICCHAI(1,1)+2
         IDXP = INTSS1(I)
         IDXT = INTSS2(I)
         MOP  = JDAHKK(1,IPOSP(IFROSP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROST(IDXT)))
         DO 11 K=1,4
            PP1(K) = XPSQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPSAQ(IDXP)*PHKK(K,MOP)
            PT1(K) = XTSAQ(IDXT)*PHKK(K,MOT)
            PT2(K) = XTSQ(IDXT) *PHKK(K,MOT)
   11    CONTINUE
         PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                  +(PP1(3)+PT1(3))**2)
         ECH   = PP1(4)+PT1(4)
         AM1   = (ECH+PTOCH)*(ECH-PTOCH)
         PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                  +(PP2(3)+PT2(3))**2)
         ECH   = PP2(4)+PT2(4)
         AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMSS).OR.(AM2.LT.AMSS)) THEN
C              WRITE(LOUT,5000) NEVHKK,I,AM1,AM2
 5000          FORMAT(1X,'INCON. CHAIN MASS SS: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5000) NEVHKK,I,AM1,AM2
         ENDIF
         IFP1 = IDT_IB2PDG(IPSQ(IDXP),0,2)
         IFP2 = IDT_IB2PDG(IPSAQ(IDXP),0,2)
         IFT1 = IDT_IB2PDG(ITSAQ(IDXT),0,2)
         IFT2 = IDT_IB2PDG(ITSQ(IDXT),0,2)
         CALL DT_EVTPUT(-31,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                    0,0,1)
         CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                    0,0,1)
         CALL DT_EVTPUT(-31,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                    0,0,1)
         CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                    0,0,1)
         NCSY = NCSY+1
   10 CONTINUE

c disea-sea chains
      DO 20 I=1,NDS
         IF (ISKPCH(2,I).EQ.99) GOTO 20
         ICCHAI(1,2) = ICCHAI(1,2)+2
         IDXP = INTDS1(I)
         IDXT = INTDS2(I)
         MOP  = JDAHKK(1,IPOSP(IFROSP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROST(IDXT)))
         DO 21 K=1,4
            PP1(K) = XPSQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPSAQ(IDXP)*PHKK(K,MOP)
            PT1(K) = XTSQ(IDXT) *PHKK(K,MOT)
            PT2(K) = XTSAQ(IDXT)*PHKK(K,MOT)
   21    CONTINUE
         PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                  +(PP1(3)+PT1(3))**2)
         ECH   = PP1(4)+PT1(4)
         AM1   = (ECH+PTOCH)*(ECH-PTOCH)
         PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                  +(PP2(3)+PT2(3))**2)
         ECH   = PP2(4)+PT2(4)
         AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMDS).OR.(AM2.LT.AMDS)) THEN
C              WRITE(LOUT,5001) NEVHKK,I,AM1,AM2
 5001          FORMAT(1X,'INCON. CHAIN MASS DS: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5001) NEVHKK,I,AM1,AM2
         ENDIF
         IFP1 = IDT_IB2PDG(IPSQ(IDXP),IPSQ2(IDXP),2)
         IFP2 = IDT_IB2PDG(-IPSQ(IDXP),-IPSQ2(IDXP),2)
         IFT1 = IDT_IB2PDG(ITSQ(IDXT),0,2)
         IFT2 = IDT_IB2PDG(ITSAQ(IDXT),0,2)
         CALL DT_EVTPUT(-31,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                    0,0,2)
         CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                    0,0,2)
         CALL DT_EVTPUT(-31,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                    0,0,2)
         CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                    0,0,2)
         NCSY = NCSY+1
   20 CONTINUE

c sea-disea chains
      DO 30 I=1,NSD
         IF (ISKPCH(3,I).EQ.99) GOTO 30
         ICCHAI(1,3) = ICCHAI(1,3)+2
         IDXP = INTSD1(I)
         IDXT = INTSD2(I)
         MOP  = JDAHKK(1,IPOSP(IFROSP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROST(IDXT)))
         DO 31 K=1,4
            PP1(K) = XPSQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPSAQ(IDXP)*PHKK(K,MOP)
            PT1(K) = XTSQ(IDXT) *PHKK(K,MOT)
            PT2(K) = XTSAQ(IDXT)*PHKK(K,MOT)
   31    CONTINUE
         PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                  +(PP1(3)+PT1(3))**2)
         ECH   = PP1(4)+PT1(4)
         AM1   = (ECH+PTOCH)*(ECH-PTOCH)
         PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                  +(PP2(3)+PT2(3))**2)
         ECH   = PP2(4)+PT2(4)
         AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMDS).OR.(AM2.LT.AMDS)) THEN
C              WRITE(LOUT,5002) NEVHKK,I,AM1,AM2
 5002          FORMAT(1X,'INCON. CHAIN MASS SD: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5002) NEVHKK,I,AM1,AM2
         ENDIF
         IFP1 = IDT_IB2PDG(IPSQ(IDXP),0,2)
         IFP2 = IDT_IB2PDG(IPSAQ(IDXP),0,2)
         IFT1 = IDT_IB2PDG(ITSQ(IDXT),ITSQ2(IDXT),2)
         IFT2 = IDT_IB2PDG(-ITSQ(IDXT),-ITSQ2(IDXT),2)
         CALL DT_EVTPUT(-31,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                    0,0,3)
         CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                    0,0,3)
         CALL DT_EVTPUT(-31,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                    0,0,3)
         CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                    0,0,3)
         NCSY = NCSY+1
   30 CONTINUE

c disea-valence chains
      DO 50 I=1,NDV
         IF (ISKPCH(5,I).EQ.99) GOTO 50
         ICCHAI(1,5) = ICCHAI(1,5)+2
         IDXP = INTDV1(I)
         IDXT = INTDV2(I)
         MOP  = JDAHKK(1,IPOSP(IFROSP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROVT(IDXT)))
         DO 51 K=1,4
            PP1(K) = XPSQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPSAQ(IDXP)*PHKK(K,MOP)
            PT1(K) = XTVQ(IDXT) *PHKK(K,MOT)
            PT2(K) = XTVD(IDXT) *PHKK(K,MOT)
   51    CONTINUE
         PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                  +(PP1(3)+PT1(3))**2)
         ECH   = PP1(4)+PT1(4)
         AM1   = (ECH+PTOCH)*(ECH-PTOCH)
         PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                  +(PP2(3)+PT2(3))**2)
         ECH   = PP2(4)+PT2(4)
         AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMVD).OR.(AM2.LT.AMVD)) THEN
C              WRITE(LOUT,5003) NEVHKK,I,AM1,AM2
 5003          FORMAT(1X,'INCON. CHAIN MASS DV: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5003) NEVHKK,I,AM1,AM2
         ENDIF
         IFP1 = IDT_IB2PDG(IPSQ(IDXP),IPSQ2(IDXP),2)
         IFP2 = IDT_IB2PDG(-IPSQ(IDXP),-IPSQ2(IDXP),2)
         IFT1 = IDT_IB2PDG(ITVQ(IDXT),0,2)
         IFT2 = IDT_IB2PDG(ITTV1(IDXT),ITTV2(IDXT),2)
         CALL DT_EVTPUT(-31,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                    0,0,5)
         CALL DT_EVTPUT(-22,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                    0,0,5)
         CALL DT_EVTPUT(-31,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                    0,0,5)
         CALL DT_EVTPUT(-22,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                    0,0,5)
         NCSY = NCSY+1
   50 CONTINUE

c valence-sea chains
      DO 60 I=1,NVS
         IF (ISKPCH(6,I).EQ.99) GOTO 60
         ICCHAI(1,6) = ICCHAI(1,6)+2
         IDXP = INTVS1(I)
         IDXT = INTVS2(I)
         MOP  = JDAHKK(1,IPOSP(IFROVP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROST(IDXT)))
         DO 61 K=1,4
            PP1(K) = XPVQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPVD(IDXP) *PHKK(K,MOP)
            PT1(K) = XTSAQ(IDXT)*PHKK(K,MOT)
            PT2(K) = XTSQ(IDXT) *PHKK(K,MOT)
   61    CONTINUE
         IFP1 = IDT_IB2PDG(IPVQ(IDXP),0,2)
         IFP2 = IDT_IB2PDG(IPPV1(IDXP),IPPV2(IDXP),2)
         IFT1 = IDT_IB2PDG(ITSAQ(IDXT),0,2)
         IFT2 = IDT_IB2PDG(ITSQ(IDXT),0,2)
         CALL  DT_CHKCSY(IFP1,IFT1,LCHK)
         IF (LCHK) THEN
            CALL DT_EVTPUT(-21,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                       0,0,6)
            CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                       0,0,6)
            CALL DT_EVTPUT(-21,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                       0,0,6)
            CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                       0,0,6)
            PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                     +(PP1(3)+PT1(3))**2)
            ECH   = PP1(4)+PT1(4)
            AM1   = (ECH+PTOCH)*(ECH-PTOCH)
            PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                     +(PP2(3)+PT2(3))**2)
            ECH   = PP2(4)+PT2(4)
            AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         ELSE
            CALL DT_EVTPUT(-21,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                       0,0,6)
            CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                       0,0,6)
            CALL DT_EVTPUT(-21,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                       0,0,6)
            CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                       0,0,6)
            PTOCH = SQRT((PP1(1)+PT2(1))**2+(PP1(2)+PT2(2))**2
     &                                     +(PP1(3)+PT2(3))**2)
            ECH   = PP1(4)+PT2(4)
            AM2   = (ECH+PTOCH)*(ECH-PTOCH)
            PTOCH = SQRT((PP2(1)+PT1(1))**2+(PP2(2)+PT1(2))**2
     &                                     +(PP2(3)+PT1(3))**2)
            ECH   = PP2(4)+PT1(4)
            AM1   = (ECH+PTOCH)*(ECH-PTOCH)
         ENDIF
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMSS).OR.(AM2.LT.AMVS)) THEN
C              WRITE(LOUT,5004) NEVHKK,I,AM1,AM2
 5004          FORMAT(1X,'INCON. CHAIN MASS VS: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5004) NEVHKK,I,AM1,AM2
         ENDIF
         NCSY = NCSY+1
   60 CONTINUE

c sea-valence chains
      DO 40 I=1,NSV
         IF (ISKPCH(4,I).EQ.99) GOTO 40
         ICCHAI(1,4) = ICCHAI(1,4)+2
         IDXP = INTSV1(I)
         IDXT = INTSV2(I)
         MOP  = JDAHKK(1,IPOSP(IFROSP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROVT(IDXT)))
         DO 41 K=1,4
            PP1(K) = XPSQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPSAQ(IDXP)*PHKK(K,MOP)
            PT1(K) = XTVD(IDXT) *PHKK(K,MOT)
            PT2(K) = XTVQ(IDXT) *PHKK(K,MOT)
   41    CONTINUE
         PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                  +(PP1(3)+PT1(3))**2)
         ECH   = PP1(4)+PT1(4)
         AM1   = (ECH+PTOCH)*(ECH-PTOCH)
         PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                  +(PP2(3)+PT2(3))**2)
         ECH   = PP2(4)+PT2(4)
         AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMVS).OR.(AM2.LT.AMSS)) THEN
C              WRITE(LOUT,5005) NEVHKK,I,AM1,AM2
 5005          FORMAT(1X,'INCON. CHAIN MASS SV: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5005) NEVHKK,I,AM1,AM2
         ENDIF
         IFP1 = IDT_IB2PDG(IPSQ(IDXP),0,2)
         IFP2 = IDT_IB2PDG(IPSAQ(IDXP),0,2)
         IFT1 = IDT_IB2PDG(ITTV1(IDXT),ITTV2(IDXT),2)
         IFT2 = IDT_IB2PDG(ITVQ(IDXT),0,2)
         CALL DT_EVTPUT(-31,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                    0,0,4)
         CALL DT_EVTPUT(-22,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                    0,0,4)
         CALL DT_EVTPUT(-31,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                    0,0,4)
         CALL DT_EVTPUT(-22,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                    0,0,4)
         NCSY = NCSY+1
   40 CONTINUE

c valence-disea chains
      DO 70 I=1,NVD
         IF (ISKPCH(7,I).EQ.99) GOTO 70
         ICCHAI(1,7) = ICCHAI(1,7)+2
         IDXP = INTVD1(I)
         IDXT = INTVD2(I)
         MOP  = JDAHKK(1,IPOSP(IFROVP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROST(IDXT)))
         DO 71 K=1,4
            PP1(K) = XPVQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPVD(IDXP) *PHKK(K,MOP)
            PT1(K) = XTSQ(IDXT) *PHKK(K,MOT)
            PT2(K) = XTSAQ(IDXT)*PHKK(K,MOT)
   71    CONTINUE
         IFP1 = IDT_IB2PDG(IPVQ(IDXP),0,2)
         IFP2 = IDT_IB2PDG(IPPV1(IDXP),IPPV2(IDXP),2)
         IFT1 = IDT_IB2PDG(ITSQ(IDXT),ITSQ2(IDXT),2)
         IFT2 = IDT_IB2PDG(-ITSQ(IDXT),-ITSQ2(IDXT),2)
         CALL  DT_CHKCSY(IFP1,IFT1,LCHK)
         IF (LCHK) THEN
            CALL DT_EVTPUT(-21,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                       0,0,7)
            CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                       0,0,7)
            CALL DT_EVTPUT(-21,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                       0,0,7)
            CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                       0,0,7)
            PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                     +(PP1(3)+PT1(3))**2)
            ECH   = PP1(4)+PT1(4)
            AM1   = (ECH+PTOCH)*(ECH-PTOCH)
            PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                     +(PP2(3)+PT2(3))**2)
            ECH   = PP2(4)+PT2(4)
            AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         ELSE
            CALL DT_EVTPUT(-21,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                       0,0,7)
            CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                       0,0,7)
            CALL DT_EVTPUT(-21,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                       0,0,7)
            CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                       0,0,7)
            PTOCH = SQRT((PP1(1)+PT2(1))**2+(PP1(2)+PT2(2))**2
     &                                     +(PP1(3)+PT2(3))**2)
            ECH   = PP1(4)+PT2(4)
            AM1   = (ECH+PTOCH)*(ECH-PTOCH)
            PTOCH = SQRT((PP2(1)+PT1(1))**2+(PP2(2)+PT1(2))**2
     &                                     +(PP2(3)+PT1(3))**2)
            ECH   = PP2(4)+PT1(4)
            AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         ENDIF
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMVD).OR.(AM2.LT.AMVD)) THEN
C              WRITE(LOUT,5006) NEVHKK,I,AM1,AM2
 5006          FORMAT(1X,'INCON. CHAIN MASS VD: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5006) NEVHKK,I,AM1,AM2
         ENDIF
         NCSY = NCSY+1
   70 CONTINUE

c valence-valence chains
      DO 80 I=1,NVV
         IF (ISKPCH(8,I).EQ.99) GOTO 80
         ICCHAI(1,8) = ICCHAI(1,8)+2
         IDXP = INTVV1(I)
         IDXT = INTVV2(I)
         MOP  = JDAHKK(1,IPOSP(IFROVP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROVT(IDXT)))
         DO 81 K=1,4
            PP1(K) = XPVQ(IDXP)*PHKK(K,MOP)
            PP2(K) = XPVD(IDXP)*PHKK(K,MOP)
            PT1(K) = XTVD(IDXT)*PHKK(K,MOT)
            PT2(K) = XTVQ(IDXT)*PHKK(K,MOT)
   81    CONTINUE
         IFP1 = IDT_IB2PDG(IPVQ(IDXP),0,2)
         IFP2 = IDT_IB2PDG(IPPV1(IDXP),IPPV2(IDXP),2)
         IFT1 = IDT_IB2PDG(ITTV1(IDXT),ITTV2(IDXT),2)
         IFT2 = IDT_IB2PDG(ITVQ(IDXT),0,2)

c check for diffractive event
         IDIFF = 0
         IF (((ISINGD.GT.0).OR.(IDOUBD.GT.0)).AND.
     &        (IP.EQ.1).AND.(NN.EQ.1)) THEN
            DO 800 K=1,4
               PP(K) = PP1(K)+PP2(K)
               PT(K) = PT1(K)+PT2(K)
  800       CONTINUE
            ISTCK = NHKK
            CALL DT_DIFEVT(IFP1,IFP2,PP,MOP,
     &                  IFT1,IFT2,PT,MOT,IDIFF,NCSY,IREJ1)
C           IF (IREJ1.NE.0) GOTO 9999
            IF (IREJ1.NE.0) THEN
               IDIFF = 0
               NHKK  = ISTCK
            ENDIF
         ELSE
            IDIFF = 0
         ENDIF

         IF (IDIFF.EQ.0) THEN
c   valence-valence chain system
            CALL  DT_CHKCSY(IFP1,IFT1,LCHK)
            IF (LCHK) THEN
c    baryon-baryon
               CALL DT_EVTPUT(-21,IFP1,MOP,0,
     &                     PP1(1),PP1(2),PP1(3),PP1(4),0,0,8)
               CALL DT_EVTPUT(-22,IFT1,MOT,0,
     &                     PT1(1),PT1(2),PT1(3),PT1(4),0,0,8)
               CALL DT_EVTPUT(-21,IFP2,MOP,0,
     &                     PP2(1),PP2(2),PP2(3),PP2(4),0,0,8)
               CALL DT_EVTPUT(-22,IFT2,MOT,0,
     &                     PT2(1),PT2(2),PT2(3),PT2(4),0,0,8)
               PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                        +(PP1(3)+PT1(3))**2)
               ECH   = PP1(4)+PT1(4)
               AM1   = (ECH+PTOCH)*(ECH-PTOCH)
               PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                        +(PP2(3)+PT2(3))**2)
               ECH   = PP2(4)+PT2(4)
               AM2   = (ECH+PTOCH)*(ECH-PTOCH)
            ELSE
c    antibaryon-baryon
               CALL DT_EVTPUT(-21,IFP1,MOP,0,
     &                     PP1(1),PP1(2),PP1(3),PP1(4),0,0,8)
               CALL DT_EVTPUT(-22,IFT2,MOT,0,
     &                     PT2(1),PT2(2),PT2(3),PT2(4),0,0,8)
               CALL DT_EVTPUT(-21,IFP2,MOP,0,
     &                     PP2(1),PP2(2),PP2(3),PP2(4),0,0,8)
               CALL DT_EVTPUT(-22,IFT1,MOT,0,
     &                     PT1(1),PT1(2),PT1(3),PT1(4),0,0,8)
               PTOCH = SQRT((PP1(1)+PT2(1))**2+(PP1(2)+PT2(2))**2
     &                                        +(PP1(3)+PT2(3))**2)
               ECH   = PP1(4)+PT2(4)
               AM1   = (ECH+PTOCH)*(ECH-PTOCH)
               PTOCH = SQRT((PP2(1)+PT1(1))**2+(PP2(2)+PT1(2))**2
     &                                        +(PP2(3)+PT1(3))**2)
               ECH   = PP2(4)+PT1(4)
               AM2   = (ECH+PTOCH)*(ECH-PTOCH)
            ENDIF
            IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
               AM1 = SQRT(AM1)
               AM2 = SQRT(AM2)
               IF ((AM1.LT.AMVV).OR.(AM2.LT.AMVV)) THEN
C                 WRITE(LOUT,5007) NEVHKK,I,AM1,AM2
 5007             FORMAT(1X,'INCON. CHAIN MASS VV: ',2I5,2E10.3)
               ENDIF
            ELSE
               WRITE(ErrorOut,5007) NEVHKK,I,AM1,AM2
            ENDIF
            NCSY = NCSY+1
         ENDIF
   80 CONTINUE
      IF (ISTHKK(NPOINT(2)).EQ.1) NPOINT(2) = NPOINT(2)+1

c energy-momentum & flavor conservation check
      IF (ABS(IDIFF).NE.1) THEN
         IF (IDIFF.NE.0) THEN
            IF (LEMCCK) CALL DT_EMC2(9,10,0,0,0,3,-21,-22,-41,1,0,
     &                                              1,3,10,IREJ)
         ELSE
            IF (LEMCCK) CALL DT_EMC2(9,10,0,0,0,3,-21,-22,-31,-32,0,
     &                                              1,3,10,IREJ)
         ENDIF
         IF (IREJ.NE.0) THEN
            CALL DT_EVTOUT(4)
            STOP
         ENDIF
      ENDIF

      RETURN

 9999 CONTINUE
      IREJ  = 1
      RETURN
      END
c
c===chkcsy=============================================================*
c
CDECK  ID>, DT_CHKCSY
      SUBROUTINE DT_CHKCSY(ID1,ID2,LCHK)

c***********************************************************************
c CHeCk Chain SYstem for consistency of partons at chain ends.         *
c            ID1,ID2        PDG-numbers of partons at chain ends       *
c            LCHK = .true.  consistent chain                           *
c                 = .false. inconsistent chain                         *
c This version dated 18.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      LOGICAL LCHK

      LCHK = .TRUE.

c q-aq chain
      IF ((ABS(ID1).LE.6).AND.(ABS(ID2).LE.6)) THEN
         IF (ID1*ID2.GT.0) LCHK = .FALSE.
c q-qq, aq-aqaq chain
      ELSEIF (((ABS(ID1).LE.6).AND.(ABS(ID2).GT.6)).OR.
     &        ((ABS(ID1).GT.6).AND.(ABS(ID2).LE.6))) THEN
         IF (ID1*ID2.LT.0) LCHK = .FALSE.
c qq-aqaq chain
      ELSEIF ((ABS(ID1).GT.6).AND.(ABS(ID2).GT.6)) THEN
         IF (ID1*ID2.GT.0) LCHK = .FALSE.
      ENDIF

      RETURN
      END
c
c===eventa=============================================================*
c
CDECK  ID>, DT_EVENTA
      SUBROUTINE DT_EVENTA(ID,IP,IT,NCSY,IREJ)

c***********************************************************************
c Treatment of nucleon-nucleon interactions in a two-chain             *
c approximation.                                                       *
c  (input) ID       BAMJET-index of projectile hadron (in case of      *
c                   h-K scattering)                                    *
c          IP/IT    mass number of projectile/target nucleus           *
c          NCSY     number of two chain systems                        *
c          IREJ     rejection flag                                     *
c This version dated 15.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      DIMENSION PP1(4),PP2(4),PT1(4),PT2(4)

      IREJ      = 0
      NPOINT(3) = NHKK+1

c skip following treatment for low-mass diffraction
      IF (ABS(IFLAGD).EQ.1) THEN
         NPOINT(3) = NPOINT(2)
         GOTO 5
      ENDIF

c multiple scattering of chain ends
      IF ((IP.GT.1).AND.(MKCRON.NE.0)) CALL DT_CRONIN(1)
      IF ((IT.GT.1).AND.(MKCRON.NE.0)) CALL DT_CRONIN(2)

      NC = NPOINT(2)
c get a two-chain system from DTEVT1
      DO 3 I=1,NCSY
         IFP1 = IDHKK(NC)
         IFT1 = IDHKK(NC+1)
         IFP2 = IDHKK(NC+2)
         IFT2 = IDHKK(NC+3)
         DO 4 K=1,4
            PP1(K) = PHKK(K,NC)
            PT1(K) = PHKK(K,NC+1)
            PP2(K) = PHKK(K,NC+2)
            PT2(K) = PHKK(K,NC+3)
    4    CONTINUE
         MOP1 = NC
         MOT1 = NC+1
         MOP2 = NC+2
         MOT2 = NC+3
         CALL DT_GETCSY(IFP1,PP1,MOP1,IFP2,PP2,MOP2,
     &               IFT1,PT1,MOT1,IFT2,PT2,MOT2,IREJ1)
         IF (IREJ1.GT.0) THEN
            IRHHA = IRHHA+1
            IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in EVENTA'
            GOTO 9999
         ENDIF
         NC = NC+4
    3 CONTINUE

c meson/antibaryon projectile:
c sample single-chain valence-valence systems (Reggeon contrib.)
      IF ((IP.EQ.1).AND.(ISICHA.EQ.1)) THEN
         IF (IIBAR(ID).LE.0) CALL DT_VV2SCH
      ENDIF

      IF ((IRESCO.EQ.1).OR.(IFRAG(1).EQ.1)) THEN
c check DTEVT1 for remaining resonance mass corrections
         CALL DT_EVTRES(IREJ1)
         IF (IREJ1.GT.0) THEN
            IRRES(1) = IRRES(1)+1
            IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 2 in EVENTA'
            GOTO 9999
         ENDIF
      ENDIF

c assign p_t to two-"chain" systems consisting of two resonances only
c since only entries for chains will be affected, this is obsolete
c in case of JETSET-fragmetation
      CALL DT_RESPT

c combine q-aq chains to color ropes (qq-aqaq) (chain fusion)
      IF (LCO2CR) CALL DT_COM2CR

    5 CONTINUE

c fragmentation of the complete event
c*uncomment for internal phojet-fragmentation
C     CALL DT_EVTFRA(IREJ1)
      CALL DT_EVTFRG(2,IDUM,NPYMEM,IREJ1)
      IF (IREJ1.GT.0) THEN
         IRFRAG = IRFRAG+1
         IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 3 in EVENTA'
         GOTO 9999
      ENDIF

c decay of possible resonances (should be obsolete)
      CALL DT_DECAY1

      RETURN

 9999 CONTINUE
      IREVT = IREVT+1
      IREJ  = 1
      RETURN
      END
c
c===getcsy=============================================================*
c
CDECK  ID>, DT_GETCSY
      SUBROUTINE DT_GETCSY(IFPR1,PP1,MOP1,IFPR2,PP2,MOP2,
     &                  IFTA1,PT1,MOT1,IFTA2,PT2,MOT2,IREJ)

c***********************************************************************
c This version dated 15.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF


      DIMENSION PP1(4),PP2(4),PT1(4),PT2(4),
     &          IFP1(2),IFP2(2),IFT1(2),IFT2(2),PCH1(4),PCH2(4)

      IREJ  = 0

c get quark content of partons
      DO 1 I=1,2
         IFP1(I) = 0
         IFP2(I) = 0
         IFT1(I) = 0
         IFT2(I) = 0
    1 CONTINUE
      IFP1(1) = IDT_IPDG2B(IFPR1,1,2)
      IF (ABS(IFPR1).GE.1000) IFP1(2) = IDT_IPDG2B(IFPR1,2,2)
      IFP2(1) = IDT_IPDG2B(IFPR2,1,2)
      IF (ABS(IFPR2).GE.1000) IFP2(2) = IDT_IPDG2B(IFPR2,2,2)
      IFT1(1) = IDT_IPDG2B(IFTA1,1,2)
      IF (ABS(IFTA1).GE.1000) IFT1(2) = IDT_IPDG2B(IFTA1,2,2)
      IFT2(1) = IDT_IPDG2B(IFTA2,1,2)
      IF (ABS(IFTA2).GE.1000) IFT2(2) = IDT_IPDG2B(IFTA2,2,2)

c get kind of chains (1 - q-aq, 2 - q-qq/aq-aqaq, 3 - qq-aqaq)
      IDCH1 = 2
      IF ((IFP1(2).EQ.0).AND.(IFT1(2).EQ.0)) IDCH1 = 1
      IF ((IFP1(2).NE.0).AND.(IFT1(2).NE.0)) IDCH1 = 3
      IDCH2 = 2
      IF ((IFP2(2).EQ.0).AND.(IFT2(2).EQ.0)) IDCH2 = 1
      IF ((IFP2(2).NE.0).AND.(IFT2(2).NE.0)) IDCH2 = 3

c store initial configuration for energy-momentum cons. check
      IF (LEMCCK) CALL DT_EMC1(PP1,PP2,PT1,PT2,1,1,IDUM)

c sample intrinsic p_t at chain-ends
      CALL DT_GETSPT(PP1,IFPR1,IFP1,PP2,IFPR2,IFP2,
     &            PT1,IFTA1,IFT1,PT2,IFTA2,IFT2,
     &            AMCH1,IDCH1,AMCH2,IDCH2,IDCH(MOP1),IREJ1)
      IF (IREJ1.NE.0) THEN
         IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in GETCSY'
         IRPT = IRPT+1
         GOTO 9999
      ENDIF

C      IF ((IRESCO.EQ.1).OR.(IFRAG(1).EQ.1)) THEN
C         IF ((IDCH1.EQ.3).OR.((IDCH1.GT.1).AND.(IDCH2.EQ.1))) THEN
C* check second chain for resonance
C            CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),IDR2,IDXR2,
C     &                  AMCH2,AMCH2N,IDCH2,IREJ1)
C            IF (IREJ1.NE.0) GOTO 9999
C            IF (IDR2.NE.0) THEN
C               CALL DT_CHKINE(PP2,IFPR2,PP1,IFPR1,PT2,IFTA2,PT1,IFTA1,
C     &                     AMCH2,AMCH2N,AMCH1,IREJ1)
C               IF (IREJ1.NE.0) GOTO 9999
C            ENDIF
C* check first chain for resonance
C            CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),IDR1,IDXR1,
C     &                  AMCH1,AMCH1N,IDCH1,IREJ1)
C            IF (IREJ1.NE.0) GOTO 9999
C            IF (IDR1.NE.0) IDR1 = 100*IDR1
C         ELSE
C* check first chain for resonance
C            CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),IDR1,IDXR1,
C     &                  AMCH1,AMCH1N,IDCH1,IREJ1)
C            IF (IREJ1.NE.0) GOTO 9999
C            IF (IDR1.NE.0) THEN
C               CALL DT_CHKINE(PP1,IFPR1,PP2,IFPR2,PT1,IFTA1,PT2,IFTA2,
C     &                     AMCH1,AMCH1N,AMCH2,IREJ1)
C               IF (IREJ1.NE.0) GOTO 9999
C            ENDIF
C* check second chain for resonance
C            CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),IDR2,IDXR2,
C     &                  AMCH2,AMCH2N,IDCH2,IREJ1)
C            IF (IREJ1.NE.0) GOTO 9999
C            IF (IDR2.NE.0) IDR2 = 100*IDR2
C         ENDIF
C      ENDIF

      IF ((IRESCO.EQ.1).OR.(IFRAG(1).EQ.1)) THEN
c check chains for resonances
         CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),IDR1,IDXR1,
     &               AMCH1,AMCH1N,IDCH1,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
         CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),IDR2,IDXR2,
     &               AMCH2,AMCH2N,IDCH2,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
c change kinematics corresponding to resonance-masses
         IF ( (IDR1.NE.0).AND.(IDR2.EQ.0) ) THEN
            CALL DT_CHKINE(PP1,IFPR1,PP2,IFPR2,PT1,IFTA1,PT2,IFTA2,
     &                                 AMCH1,AMCH1N,AMCH2,IREJ1)
            IF (IREJ1.GT.0) GOTO 9999
            IF (IREJ1.EQ.-1) IDR1 = 100*IDR1
            CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),IDR2,IDXR2,
     &                  AMCH2,AMCH2N,IDCH2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            IF (IDR2.NE.0) IDR2 = 100*IDR2
         ELSEIF ( (IDR1.EQ.0).AND.(IDR2.NE.0) ) THEN
            CALL DT_CHKINE(PP2,IFPR2,PP1,IFPR1,PT2,IFTA2,PT1,IFTA1,
     &                                 AMCH2,AMCH2N,AMCH1,IREJ1)
            IF (IREJ1.GT.0) GOTO 9999
            IF (IREJ1.EQ.-1) IDR2 = 100*IDR2
            CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),IDR1,IDXR1,
     &                  AMCH1,AMCH1N,IDCH1,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            IF (IDR1.NE.0) IDR1 = 100*IDR1
         ELSEIF ( (IDR1.NE.0).AND.(IDR2.NE.0) ) THEN
            AMDIF1 = ABS(AMCH1-AMCH1N)
            AMDIF2 = ABS(AMCH2-AMCH2N)
            IF (AMDIF2.LT.AMDIF1) THEN
               CALL DT_CHKINE(PP2,IFPR2,PP1,IFPR1,PT2,IFTA2,PT1,IFTA1,
     &                                    AMCH2,AMCH2N,AMCH1,IREJ1)
               IF (IREJ1.GT.0) GOTO 9999
               IF (IREJ1.EQ.-1) IDR2 = 100*IDR2
               CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),
     &                     IDR1,IDXR1,AMCH1,AMCH1N,IDCH1,IREJ1)
               IF (IREJ1.NE.0) GOTO 9999
               IF (IDR1.NE.0) IDR1 = 100*IDR1
            ELSE
               CALL DT_CHKINE(PP1,IFPR1,PP2,IFPR2,PT1,IFTA1,PT2,IFTA2,
     &                                    AMCH1,AMCH1N,AMCH2,IREJ1)
               IF (IREJ1.GT.0) GOTO 9999
               IF (IREJ1.EQ.-1) IDR1 = 100*IDR1
               CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),
     &                     IDR2,IDXR2,AMCH2,AMCH2N,IDCH2,IREJ1)
               IF (IREJ1.NE.0) GOTO 9999
               IF (IDR2.NE.0) IDR2 = 100*IDR2
            ENDIF
         ENDIF
      ENDIF

c store final configuration for energy-momentum cons. check
      IF (LEMCCK) THEN
         CALL DT_EMC1(PP1,PP2,PT1,PT2,-2,1,IDUM)
         CALL DT_EMC1(PP1,PP2,PT1,PT2,3,1,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
      ENDIF

c put partons and chains into DTEVT1
      DO 10 I=1,4
         PCH1(I) = PP1(I)+PT1(I)
         PCH2(I) = PP2(I)+PT2(I)
   10 CONTINUE
      CALL DT_EVTPUT(-ISTHKK(MOP1),IFPR1,MOP1,0,PP1(1),PP1(2),
     &                                      PP1(3),PP1(4),0,0,0)
      CALL DT_EVTPUT(-ISTHKK(MOT1),IFTA1,MOT1,0,PT1(1),PT1(2),
     &                                      PT1(3),PT1(4),0,0,0)
      KCH = 100+IDCH(MOP1)*10+1
      CALL DT_EVTPUT(KCH,88888,-2,-1,
     &           PCH1(1),PCH1(2),PCH1(3),PCH1(4),IDR1,IDXR1,IDCH(MOP1))
      CALL DT_EVTPUT(-ISTHKK(MOP2),IFPR2,MOP2,0,PP2(1),PP2(2),
     &                                      PP2(3),PP2(4),0,0,0)
      CALL DT_EVTPUT(-ISTHKK(MOT2),IFTA2,MOT2,0,PT2(1),PT2(2),
     &                                      PT2(3),PT2(4),0,0,0)
      KCH = KCH+1
      CALL DT_EVTPUT(KCH,88888,-2,-1,
     &           PCH2(1),PCH2(2),PCH2(3),PCH2(4),IDR2,IDXR2,IDCH(MOP2))

      RETURN

 9999 CONTINUE
      IF ((IDCH(MOP1).LE.3).AND.(IDCH(MOP2).LE.3)) THEN
c "cancel" sea-sea chains
         CALL DT_RJSEAC(MOP1,MOP2,MOT1,MOT2,IREJ1)
         IF (IREJ1.NE.0) GOTO 9998
c*sr 16.5. flag for EVENTB
         IREJ = -1
         RETURN
      ENDIF
 9998 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===chkine=============================================================*
c
CDECK  ID>, DT_CHKINE
      SUBROUTINE DT_CHKINE(PP1I,IFP1,PP2I,IFP2,PT1I,IFT1,PT2I,IFT2,
     &                  AMCH1,AMCH1N,AMCH2,IREJ)

c***********************************************************************
c This subroutine replaces CORMOM.                                     *
c This version dated 05.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9,TINY10=1.0D-10)



c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC


      DIMENSION PP1(4),PP2(4),PT1(4),PT2(4),P1(4),P2(4),
     &          PP1I(4),PP2I(4),PT1I(4),PT2I(4)

      IREJ  = 0
      JMSHL = IMSHL

      SCALE  = AMCH1N/MAX(AMCH1,TINY10)
      DO 10 I=1,4
         PP1(I) = PP1I(I)
         PP2(I) = PP2I(I)
         PT1(I) = PT1I(I)
         PT2(I) = PT2I(I)
         PP2(I) = PP2(I)+(1.0D0-SCALE)*PP1(I)
         PT2(I) = PT2(I)+(1.0D0-SCALE)*PT1(I)
         PP1(I) = SCALE*PP1(I)
         PT1(I) = SCALE*PT1(I)
   10 CONTINUE
      IF ((PP1(4).LT.0.0D0).OR.(PP2(4).LT.0.0D0).OR.
     &    (PT1(4).LT.0.0D0).OR.(PT2(4).LT.0.0D0)) GOTO 9997

      ECH = PP2(4)+PT2(4)
      PCH = SQRT( (PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2+
     &                               (PP2(3)+PT2(3))**2 )
      AMCH22 = (ECH-PCH)*(ECH+PCH)
      IF (AMCH22.LT.0.0D0) THEN
         IF (IOULEV(1).GT.0)
     &      WRITE(ErrorOut,
     * '(1X,A)') 'CHKINE: inconsistent treatment!'
         GOTO 9997
      ENDIF

      AMCH1 = AMCH1N
      AMCH2 = SQRT(AMCH22)

c put partons again on mass shell
   13 CONTINUE
      XM1 = 0.0D0
      XM2 = 0.0D0
      IF (JMSHL.EQ.1) THEN

         XM1 = PYMASS(IFP1)
         XM2 = PYMASS(IFT1)

      ENDIF
      CALL DT_MASHEL(PP1,PT1,XM1,XM2,P1,P2,IREJ1)
      IF (IREJ1.NE.0) THEN
         IF (JMSHL.EQ.0) GOTO 9998
         JMSHL = 0
         GOTO 13
      ENDIF
      JMSHL = IMSHL
      DO 11 I=1,4
         PP1(I) = P1(I)
         PT1(I) = P2(I)
   11 CONTINUE
   14 CONTINUE
      XM1 = 0.0D0
      XM2 = 0.0D0
      IF (JMSHL.EQ.1) THEN

         XM1 = PYMASS(IFP2)
         XM2 = PYMASS(IFT2)

      ENDIF
      CALL DT_MASHEL(PP2,PT2,XM1,XM2,P1,P2,IREJ1)
      IF (IREJ1.NE.0) THEN
         IF (JMSHL.EQ.0) GOTO 9998
         JMSHL = 0
         GOTO 14
      ENDIF
      DO 12 I=1,4
         PP2(I) = P1(I)
         PT2(I) = P2(I)
   12 CONTINUE
      DO 15 I=1,4
         PP1I(I) = PP1(I)
         PP2I(I) = PP2(I)
         PT1I(I) = PT1(I)
         PT2I(I) = PT2(I)
   15 CONTINUE
      RETURN

 9997 IRCHKI(1) = IRCHKI(1)+1
c*sr
C     GOTO 9999
      IREJ = -1
      RETURN
c*
 9998 IRCHKI(2) = IRCHKI(2)+1

 9999 CONTINUE
      IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in CHKINE'
      IREJ = 1
      RETURN
      END
c
c===ch2res=============================================================*
c
CDECK  ID>, DT_CH2RES
      SUBROUTINE DT_CH2RES(IF1,IF2,IF3,IF4,IDR,IDXR,
     &                  AM,AMN,IMODE,IREJ)

c***********************************************************************
c Check chains for resonance production.                               *
c This subroutine replaces COMCMA/COBCMA/COMCM2                        *
c    input:                                                            *
c          IF1,2,3,4    input flavors (q,aq in any order)              *
c          AM           chain mass                                     *
c          MODE = 1     check q-aq chain for meson-resonance           *
c               = 2     check q-qq, aq-aqaq chain for baryon-resonance *
c               = 3     check qq-aqaq chain for lower mass cut         *
c    output:                                                           *
c          IDR = 0      no resonances found                            *
c              = -1     pseudoscalar meson/octet baryon                *
c              = 1      vector-meson/decuplet baryon                   *
c          IDXR         BAMJET-index of corresponding resonance        *
c          AMN          mass of corresponding resonance                *
c                                                                      *
c          IREJ         rejection flag                                 *
c This version dated 06.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c quark-content to particle index conversion (DTUNUC 1.x)
      COMMON /DTQ2ID/ IMPS(6,6),IMVE(6,6),IB08(6,21),IB10(6,21),
     &                IA08(6,21),IA10(6,21)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME


      DIMENSION IF(4),JF(4)

c*sr 4.7. test
C     DATA AMLOM,AMLOB /0.08D0,0.2D0/
      DATA AMLOM,AMLOB /0.1D0,0.7D0/
c*
C     DATA AMLOM,AMLOB /0.001D0,0.001D0/

      MODE = ABS(IMODE)

      IF ((MODE.LT.1).OR.(MODE.GT.3)) THEN
         WRITE(ErrorOut,1000) MODE
 1000    FORMAT(1X,'CH2RES: MODE ',I4,' NOT SUPPORTED!',/,
     &          1X,'        PROGRAM STOPPED')
         STOP
      ENDIF

      AMX  = AM
      IREJ = 0
      IDR  = 0
      IDXR = 0
      AMN  = AMX
      IF ((AM.LE.0.0D0).AND.(MODE.EQ.1)) AMX = AMLOM
      IF ((AM.LE.0.0D0).AND.(MODE.EQ.2)) AMX = AMLOB

      IF(1) = IF1
      IF(2) = IF2
      IF(3) = IF3
      IF(4) = IF4
      NF = 0
      DO 100 I=1,4
         IF (IF(I).NE.0) THEN
            NF = NF+1
            JF(NF) = IF(I)
         ENDIF
  100 CONTINUE
      IF (NF.LE.MODE) THEN
         WRITE(ErrorOut,1001) MODE,IF
 1001    FORMAT(1X,'CH2RES: INCONSISTENT INPUT FLAVORS IN MODE ',
     &   I4,' IF1 = ',I4,' IF2 = ',I4,' IF3 = ',I4,' IF4 = ',I4)
         GOTO 9999
      ENDIF

      GOTO (1,2,3) MODE

c check for meson resonance
    1 CONTINUE
      IFQ  = JF(1)
      IFAQ = ABS(JF(2))
      IF (JF(2).GT.0) THEN
         IFQ  = JF(2)
         IFAQ = ABS(JF(1))
      ENDIF
      IFPS = IMPS(IFAQ,IFQ)
      IFV  = IMVE(IFAQ,IFQ)
      AMPS = AAM(IFPS)
      AMV  = AAM(IFV)
      AMHI = AMV+0.3D0
      IF (AMX.LT.AMV) THEN
         IF (AMX.LT.AMPS) THEN
            IF (IMODE.GT.0) THEN
               IF ((IRESRJ.EQ.1).OR.(AMX.LT.AMLOM)) GOTO 9999
            ELSE
               IF (AMX.LT.0.8D0*AMPS) GOTO 9999
            ENDIF
            LOMRES = LOMRES+1
         ENDIF
c    replace chain by pseudoscalar meson
         IDR  = -1
         IDXR = IFPS
         AMN  = AMPS
      ELSEIF (AMX.LT.AMHI) THEN
c    replace chain by vector-meson
         IDR  = 1
         IDXR = IFV
         AMN  = AMV
      ENDIF
      RETURN

c check for baryon resonance
    2 CONTINUE
      CALL DT_DBKLAS(JF(1),JF(2),JF(3),JB8,JB10)
      AM8  = AAM(JB8)
      AM10 = AAM(JB10)
      AMHI = AM10+0.3D0
      IF (AMX.LT.AM10) THEN
         IF (AMX.LT.AM8) THEN
            IF (IMODE.GT.0) THEN
               IF ((IRESRJ.EQ.1).OR.(AMX.LT.AMLOB)) GOTO 9999
            ELSE
               IF (AMX.LT.0.8D0*AM8) GOTO 9999
            ENDIF
            LOBRES = LOBRES+1
         ENDIF
c    replace chain by oktet baryon
         IDR  = -1
         IDXR = JB8
         AMN  = AM8
      ELSEIF (AMX.LT.AMHI) THEN
         IDR  = 1
         IDXR = JB10
         AMN  = AM10
      ENDIF
      RETURN

c check qq-aqaq for lower mass cut
    3 CONTINUE
c   empirical definition of AMHI to allow for (b-antib)-pair prod.
      AMHI = 2.5D0
      IF (AMX.LT.AMHI) GOTO 9999
      RETURN

 9999 CONTINUE
      IF ((IOULEV(1).GT.0).AND.(IMODE.GT.0))
     &    WRITE(ErrorOut,*) 'rejected 1 in CH2RES',IMODE
      IREJ = 1
      IRRES(2) = IRRES(2)+1
      RETURN
      END
c
c===rjseac=============================================================*
c
CDECK  ID>, DT_RJSEAC
      SUBROUTINE DT_RJSEAC(MOP1,MOP2,MOT1,MOT2,IREJ)

c***********************************************************************
c ReJection of SEA-sea Chains.                                         *
c         MOP1/2       entries of projectile sea-partons in DTEVT1     *
c         MOT1/2       entries of projectile sea-partons in DTEVT1     *
c This version dated 16.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ZERO=0.0D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)


      DIMENSION IDXSEA(2,2),IDXNUC(2),ISTVAL(2)

      IREJ = 0

c projectile sea q-aq-pair
c    indices of sea-pair
      IDXSEA(1,1) = MOP1
      IDXSEA(1,2) = MOP2
c    index of mother-nucleon
      IDXNUC(1)   = JMOHKK(1,MOP1)
c    status of valence quarks to be corrected
      ISTVAL(1)   = -21

c target sea q-aq-pair
c    indices of sea-pair
      IDXSEA(2,1) = MOT1
      IDXSEA(2,2) = MOT2
c    index of mother-nucleon
      IDXNUC(2)   = JMOHKK(1,MOT1)
c    status of valence quarks to be corrected
      ISTVAL(2)   = -22

      DO 1 N=1,2
         IDONE = 0
         DO 2 I=NPOINT(2),NHKK
            IF ((ISTHKK(I).EQ.ISTVAL(N)).AND.
     &          (JMOHKK(1,I).EQ.IDXNUC(N)))   THEN
c valence parton found
c    inrease 4-momentum by sea 4-momentum
               DO 3 K=1,4
                  PHKK(K,I) = PHKK(K,I)+PHKK(K,IDXSEA(N,1))+
     &                                  PHKK(K,IDXSEA(N,2))
    3          CONTINUE
               PHKK(5,I) = SQRT(ABS(PHKK(4,I)**2-PHKK(1,I)**2-
     &                              PHKK(2,I)**2-PHKK(3,I)**2))
c    "cancel" sea-pair
               DO 4 J=1,2
                  ISTHKK(IDXSEA(N,J))   = 100
                  IDHKK(IDXSEA(N,J))    = 0
                  JMOHKK(1,IDXSEA(N,J)) = 0
                  JMOHKK(2,IDXSEA(N,J)) = 0
                  JDAHKK(1,IDXSEA(N,J)) = 0
                  JDAHKK(2,IDXSEA(N,J)) = 0
                  DO 5 K=1,4
                     PHKK(K,IDXSEA(N,J)) = ZERO
                     VHKK(K,IDXSEA(N,J)) = ZERO
                     WHKK(K,IDXSEA(N,J)) = ZERO
    5             CONTINUE
                  PHKK(5,IDXSEA(N,J)) = ZERO
    4          CONTINUE
               IDONE = 1
            ENDIF
    2    CONTINUE
         IF (IDONE.NE.1) THEN
            WRITE(ErrorOut,1000) NEVHKK,MOP1,MOP2,MOT1,MOT2
 1000       FORMAT(1X,'RJSEAC: EVENT ',I8,': INCONSISTENT EVENT',
     &                '-RECORD!',/,1X,'        SEA-QUARK PAIRS   ',
     &                2I5,4X,2I5,'   COULD NOT BE CANCELED!')
            GOTO 9999
         ENDIF
    1 CONTINUE
      ICRJSS = ICRJSS+1
      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===vv2sch=============================================================*
c
CDECK  ID>, DT_VV2SCH
      SUBROUTINE DT_VV2SCH

c***********************************************************************
c Change Valence-Valence chain systems to Single CHain systems for     *
c hadron-nucleus collisions with meson or antibaryon projectile.       *
c (Reggeon contribution)                                               *
c The single chain system is approximately treated as one chain and a  *
c meson at rest.                                                       *
c This version dated 18.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY7=1.0D-7,TINY3=1.0D-3)

      LOGICAL LSTART

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)


      DIMENSION IF(4,2),MO(4),PP1(4),PP2(4),PT1(4),PT2(4),PCH1(4),
     &          PCH2(4)

      DATA LSTART /.TRUE./

      IFSC  = 0
      IF (LSTART) THEN
         WRITE(ErrorOut,1000)
 1000    FORMAT(/,1X,'VV2SCH:  REGGEON CONTRIBUTION TO VALANCE-',
     &          'VALENCE CHAINS TREATED')
         LSTART = .FALSE.
      ENDIF

      NSTOP = NHKK

c get index of first chain
      DO 1 I=NPOINT(3),NHKK
         IF (IDHKK(I).EQ.88888) THEN
            NC = I
            GOTO 2
         ENDIF
    1 CONTINUE

    2 CONTINUE
      IF ((IDHKK(NC).EQ.88888).AND.(IDHKK(NC+3).EQ.88888)
     &                        .AND.(NC.LT.NSTOP)) THEN
c get valence-valence chains
         IF ((IDCH(NC).EQ.8).AND.(IDCH(NC+3).EQ.8)) THEN
c   get "mother"-hadron indices
            MO1   = JMOHKK(1,JMOHKK(1,JMOHKK(1,NC)))
            MO2   = JMOHKK(1,JMOHKK(1,JMOHKK(2,NC)))
            KPROJ = IDT_ICIHAD(IDHKK(MO1))
            KTARG = IDT_ICIHAD(IDHKK(MO2))
c   Lab momentum of projectile hadron
            CALL DT_LTNUC(PHKK(3,MO1),PHKK(4,MO1),PPZ,PPE,-3)
            PTOT  = SQRT(PHKK(1,MO1)**2+PHKK(2,MO1)**2+
     &                                  PHKK(3,MO1)**2)

            SICHAP = DT_PHNSCH(KPROJ,KTARG,PTOT)
            IF (DT_RNDM(PTOT).LE.SICHAP) THEN
               ICVV2S = ICVV2S+1
c   single chain requested
c      get flavors of chain-end partons
               MO(1) = JMOHKK(1,NC)
               MO(2) = JMOHKK(2,NC)
               MO(3) = JMOHKK(1,NC+3)
               MO(4) = JMOHKK(2,NC+3)
               DO 3 I=1,4
                  IF(I,1) = IDT_IPDG2B(IDHKK(MO(I)),1,2)
                  IF(I,2) = 0
                  IF (ABS(IDHKK(MO(I))).GE.1000)
     &               IF(I,2) = IDT_IPDG2B(IDHKK(MO(I)),2,2)
    3          CONTINUE
c      which one is the q-aq chain?
c        N1,N1+1 - DTEVT1-entries for q-aq system
c        N2,N2+1 - DTEVT1-entries for the other chain
               IF ((IF(1,2).EQ.0).AND.(IF(2,2).EQ.0)) THEN
                  K1 = 1
                  K2 = 3
                  N1 = NC-2
                  N2 = NC+1
               ELSEIF ((IF(3,2).EQ.0).AND.(IF(4,2).EQ.0)) THEN
                  K1 = 3
                  K2 = 1
                  N1 = NC+1
                  N2 = NC-2
               ELSE
                  GOTO 10
               ENDIF
               DO 4 K=1,4
                  PP1(K) = PHKK(K,N1)
                  PT1(K) = PHKK(K,N1+1)
                  PP2(K) = PHKK(K,N2)
                  PT2(K) = PHKK(K,N2+1)
    4          CONTINUE
               AMCH1 = PHKK(5,N1+2)
               AMCH2 = PHKK(5,N2+2)
c      get meson-identity corresponding to flavors of q-aq chain
               ITMP   = IRESRJ
               IRESRJ = 0
               CALL DT_CH2RES(IF(K1,1),IF(K1+1,1),0,0,IDR1,IDXR1,
     &                     ZERO,AMCH1N,1,IDUM)
               IRESRJ = ITMP
c      change kinematics of chains
               CALL DT_CHKINE(PP1,IDHKK(N1),  PP2,IDHKK(N2),
     &                     PT1,IDHKK(N1+1),PT2,IDHKK(N2+1),
     &                     AMCH1,AMCH1N,AMCH2,IREJ1)
               IF (IREJ1.NE.0) GOTO 10
c      check second chain for resonance
               IDCHAI = 2
               IF ((IF(K2,2).NE.0).AND.(IF(K2+1,2).NE.0)) IDCHAI = 3
               CALL DT_CH2RES(IF(K2,1),IF(K2,2),IF(K2+1,1),IF(K2+1,2),
     &                     IDR2,IDXR2,AMCH2,AMCH2N,IDCHAI,IREJ1)
               IF (IREJ1.NE.0) GOTO 10
               IF (IDR2.NE.0) IDR2 = 100*IDR2
c      add partons and chains to DTEVT1
               DO 5 K=1,4
                  PCH1(K) = PP1(K)+PT1(K)
                  PCH2(K) = PP2(K)+PT2(K)
    5          CONTINUE
               CALL DT_EVTPUT(ISTHKK(N1),IDHKK(N1),N1,0,PP1(1),PP1(2),
     &                                             PP1(3),PP1(4),0,0,0)
               CALL DT_EVTPUT(ISTHKK(N1+1),IDHKK(N1+1),N1+1,0,PT1(1),
     &                                      PT1(2),PT1(3),PT1(4),0,0,0)
               KCH = ISTHKK(N1+2)+100
               CALL DT_EVTPUT(KCH,88888,-2,-1,PCH1(1),PCH1(2),PCH1(3),
     &                     PCH1(4),IDR1,IDXR1,IDCH(N1+2))
               IDHKK(N1+2) = 22222
               CALL DT_EVTPUT(ISTHKK(N2),IDHKK(N2),N2,0,PP2(1),PP2(2),
     &                                             PP2(3),PP2(4),0,0,0)
               CALL DT_EVTPUT(ISTHKK(N2+1),IDHKK(N2+1),N2+1,0,PT2(1),
     &                                      PT2(2),PT2(3),PT2(4),0,0,0)
               KCH = ISTHKK(N2+2)+100
               CALL DT_EVTPUT(KCH,88888,-2,-1,PCH2(1),PCH2(2),PCH2(3),
     &                     PCH2(4),IDR2,IDXR2,IDCH(N2+2))
               IDHKK(N2+2) = 22222
            ENDIF
         ENDIF
      ELSE
         GOTO 11
      ENDIF
   10 CONTINUE
      NC = NC+6
      GOTO 2

   11 CONTINUE

      RETURN
      END
c
c=== phnsch ===========================================================*
c
CDECK  ID>, DT_PHNSCH
      DOUBLE PRECISION FUNCTION DT_PHNSCH( KP, KTARG, PLAB )

c----------------------------------------------------------------------*
c                                                                      *
c     Probability for Hadron Nucleon Single CHain interactions:        *
c                                                                      *
c     Created on 30 december 1993  by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 04-jan-94     by    Alfredo Ferrari               *
c                                                                      *
c             modified by J.R.for use in DTUNUC  6.1.94                *
c                                                                      *
c     Input variables:                                                 *
c                      Kp = hadron projectile index (Part numbering    *
c                           scheme)                                    *
c                   Ktarg = target nucleon index (1=proton, 8=neutron) *
c                    Plab = projectile laboratory momentum (GeV/c)     *
c     Output variable:                                                 *
c                  Phnsch = probability per single chain (particle     *
c                           exchange) interactions                     *
c                                                                      *
c----------------------------------------------------------------------*

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE

      PARAMETER ( LUNOUT = 6  )
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )

      PARAMETER ( NALLWP = 39   )
      PARAMETER ( IDMAXP = 210  )

      DIMENSION ICHRGE(39),AM(39)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


      DIMENSION KPTOIP(210)
c auxiliary common for reggeon exchange (DTUNUC 1.x)
      COMMON /DTQUAR/ IQECHR(-6:6),IQBCHR(-6:6),IQICHR(-6:6),
     &                IQSCHR(-6:6),IQCCHR(-6:6),IQUCHR(-6:6),
     &                IQTCHR(-6:6),MQUARK(3,39)


      DIMENSION SGTCOE (5,33), IHLP (NALLWP)
      DIMENSION SGTCO1(5,10),SGTCO2(5,8),SGTCO3(5,15)
      SAVE SGTCOE, IHLP
      SAVE IQFSC1, IQFSC2, IQBSC1, IQBSC2
      EQUIVALENCE (SGTCO1(1,1),SGTCOE(1,1))
      EQUIVALENCE (SGTCO2(1,1),SGTCOE(1,11))
      EQUIVALENCE (SGTCO3(1,1),SGTCOE(1,19))

c Conversion from part to paprop numbering
      DATA KPTOIP / 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
     & 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 66*0,
     & 34, 36, 31, 32, 33, 35, 37, 5*0, 38, 5*0, 39, 19*0, 27, 28, 74*0/

c  1=baryon, 2=pion, 3=kaon, 4=antibaryon:
      DATA IHLP/1,4,5*0,1,4,2*0,3,2*2,2*3,1,4,3,3*1,2,
     &    2*3, 2, 4*0, 3*4, 1, 4, 1, 4, 1, 4 /
C     DATA ( ( SGTCOE (J,I), J=1,5 ), I=1,10 ) /
      DATA  SGTCO1  /
c 1st reaction: gamma p total
     &0.147 D+00, ZERZER  , ZERZER   , 0.0022D+00, -0.0170D+00,
c 2nd reaction: gamma d total
     &0.300 D+00, ZERZER  , ZERZER   , 0.0095D+00, -0.057 D+00,
c 3rd reaction: pi+ p total
     &16.4  D+00, 19.3D+00, -0.42D+00, 0.19  D+00, ZERZER     ,
c 4th reaction: pi- p total
     &33.0  D+00, 14.0D+00, -1.36D+00, 0.456 D+00, -4.03  D+00,
c 5th reaction: pi+/- d total
     &56.8  D+00, 42.2D+00, -1.45D+00, 0.65  D+00, -5.39  D+00,
c 6th reaction: K+ p total
     &18.1  D+00, ZERZER  , ZERZER   , 0.26  D+00, -1.0   D+00,
c 7th reaction: K+ n total
     &18.7  D+00, ZERZER  , ZERZER   , 0.21  D+00, -0.89  D+00,
c 8th reaction: K+ d total
     &34.2  D+00, 7.9 D+00, -2.1 D+00, 0.346 D+00, -0.99  D+00,
c 9th reaction: K- p total
     &32.1  D+00, ZERZER  , ZERZER   , 0.66  D+00, -5.6   D+00,
c 10th reaction: K- n total
     &25.2  D+00, ZERZER  , ZERZER   , 0.38  D+00, -2.9   D+00/
C     DATA ( ( SGTCOE (J,I), J=1,5 ), I=11,18 ) /
      DATA  SGTCO2  /
c 11th reaction: K- d total
     &57.6  D+00, ZERZER  , ZERZER   , 1.17  D+00, -9.5   D+00,
c 12th reaction: p p total
     &48.0  D+00, ZERZER  , ZERZER   , 0.522 D+00, -4.51  D+00,
c 13th reaction: p n total
     &47.30 D+00, ZERZER  , ZERZER   , 0.513 D+00, -4.27  D+00,
c 14th reaction: p d total
     &91.3  D+00, ZERZER  , ZERZER   , 1.05  D+00, -8.8   D+00,
c 15th reaction: pbar p total
     &38.4  D+00, 77.6D+00, -0.64D+00, 0.26  D+00, -1.2   D+00,
c 16th reaction: pbar n total
     &ZERZER    ,133.6D+00, -0.70D+00, -1.22 D+00, 13.7   D+00,
c 17th reaction: pbar d total
     &112.  D+00, 125.D+00, -1.08D+00, 1.14  D+00, -12.4  D+00,
c 18th reaction: Lamda p total
     &30.4  D+00, ZERZER  , ZERZER   , ZERZER    , 1.6    D+00/
C     DATA ( ( SGTCOE (J,I), J=1,5 ), I=19,33 ) /
      DATA SGTCO3  /
c 19th reaction: pi+ p elastic
     &ZERZER    , 11.4D+00, -0.4 D+00, 0.079 D+00, ZERZER     ,
c 20th reaction: pi- p elastic
     &1.76  D+00, 11.2D+00, -0.64D+00, 0.043 D+00, ZERZER     ,
c 21st reaction: K+ p elastic
     &5.0   D+00, 8.1 D+00, -1.8 D+00, 0.16  D+00, -1.3   D+00,
c 22nd reaction: K- p elastic
     &7.3   D+00, ZERZER  , ZERZER   , 0.29  D+00, -2.40  D+00,
c 23rd reaction: p p elastic
     &11.9  D+00, 26.9D+00, -1.21D+00, 0.169 D+00, -1.85  D+00,
c 24th reaction: p d elastic
     &16.1  D+00, ZERZER  , ZERZER   , 0.32  D+00, -3.4   D+00,
c 25th reaction: pbar p elastic
     &10.2  D+00, 52.7D+00, -1.16D+00, 0.125 D+00, -1.28  D+00,
c 26th reaction: pbar p elastic bis
     &10.6  D+00, 53.1D+00, -1.19D+00, 0.136 D+00, -1.41  D+00,
c 27th reaction: pbar n elastic
     &36.5  D+00, ZERZER  , ZERZER   , ZERZER    , -11.9  D+00,
c 28th reaction: Lamda p elastic
     &12.3  D+00, ZERZER  , ZERZER   , ZERZER    , -2.4   D+00,
c 29th reaction: K- p ela bis
     &7.24  D+00, 46.0D+00, -4.71D+00, 0.279 D+00, -2.35  D+00,
c 30th reaction: pi- p cx
     &ZERZER    ,0.912D+00, -1.22D+00, ZERZER    , ZERZER     ,
c 31st reaction: K- p cx
     &ZERZER    , 3.39D+00, -1.75D+00, ZERZER    , ZERZER     ,
c 32nd reaction: K+ n cx
     &ZERZER    , 7.18D+00, -2.01D+00, ZERZER    , ZERZER     ,
c 33rd reaction: pbar p cx
     &ZERZER    , 18.8D+00, -2.01D+00, ZERZER    , ZERZER     /
c
c  +-------------------------------------------------------------------*
         ICHRGE(KTARG)=IICH(KTARG)
         AM    (KTARG)=AAM (KTARG)
c  |  Check for pi0 (d-dbar)
      IF ( KP .NE. 26 ) THEN
         IP  = KPTOIP (KP)
         IF(IP.EQ.0)IP=1
         ICHRGE(IP)=IICH(KP)
         AM    (IP)=AAM (KP)
c  |
c  +-------------------------------------------------------------------*
c  |
      ELSE
         IP = 23
         ICHRGE(IP)=0
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  No such interactions for baryon-baryon
      IF ( IIBAR (KP) .GT. 0 ) THEN
         DT_PHNSCH = ZERZER
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |  No "annihilation" diagram possible for K+ p/n
      ELSE IF ( IP .EQ. 15 ) THEN
         DT_PHNSCH = ZERZER
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |  No "annihilation" diagram possible for K0 p/n
      ELSE IF ( IP .EQ. 24 ) THEN
         DT_PHNSCH = ZERZER
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |  No "annihilation" diagram possible for Omebar p/n
      ELSE IF ( IP .GE. 38 ) THEN
         DT_PHNSCH = ZERZER
         RETURN
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  If the momentum is larger than 50 GeV/c, compute the single
c  |  chain probability at 50 GeV/c and extrapolate to the present
c  |  momentum according to 1/sqrt(s)
c  |  sigma = sigma_sch (50) * sqrt (s(50)/s) + sigma_dch
c  |  P_sch (50) = sigma_sch (50) / ( sigma_dch + sigma_sch (50) )
c  |  sigma_dch / sigma_sch (50) = 1 / P_sch (50) - 1
c  |  sigma_dch / sigma_sch = 1 / P_sch - 1 = ( 1 / P_sch (50) - 1 )
c  |                        x sqrt(s/s(50))
c  |  P_sch = 1 / [ ( 1 / P_sch (50) - 1 ) x sqrt(s/s(50)) + 1 ]
      IF ( PLAB .GT. 50.D+00 ) THEN
         PLA    = 50.D+00
         AMPSQ  = AM (IP)**2
         AMTSQ  = AM (KTARG)**2
         EPROJ  = SQRT ( PLAB**2 + AMPSQ )
         UMOSQ  = AMPSQ + AMTSQ + TWOTWO * AM (KTARG) * EPROJ
         EPROJ  = SQRT ( PLA**2 + AMPSQ )
         UMO50  = AMPSQ + AMTSQ + TWOTWO * AM (KTARG) * EPROJ
         UMORAT = SQRT ( UMOSQ / UMO50 )
c  |
c  +-------------------------------------------------------------------*
c  |  P < 3 GeV/c
      ELSE IF ( PLAB .LT. 3.D+00 ) THEN
         PLA    = 3.D+00
         AMPSQ  = AM (IP)**2
         AMTSQ  = AM (KTARG)**2
         EPROJ  = SQRT ( PLAB**2 + AMPSQ )
         UMOSQ  = AMPSQ + AMTSQ + TWOTWO * AM (KTARG) * EPROJ
         EPROJ  = SQRT ( PLA**2 + AMPSQ )
         UMO50  = AMPSQ + AMTSQ + TWOTWO * AM (KTARG) * EPROJ
         UMORAT = SQRT ( UMOSQ / UMO50 )
c  |
c  +-------------------------------------------------------------------*
c  |  P < 50 GeV/c
      ELSE
         PLA    = PLAB
         UMORAT = ONEONE
      END IF
c  |
c  +-------------------------------------------------------------------*
      ALGPLA = LOG (PLA)
c  +-------------------------------------------------------------------*
c  |  Pions:
      IF ( IHLP (IP) .EQ. 2 ) THEN
         ACOF = SGTCOE (1,3)
         BCOF = SGTCOE (2,3)
         ENNE = SGTCOE (3,3)
         CCOF = SGTCOE (4,3)
         DCOF = SGTCOE (5,3)
c  |  Compute the pi+ p total cross section:
         SPPPTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
         ACOF = SGTCOE (1,19)
         BCOF = SGTCOE (2,19)
         ENNE = SGTCOE (3,19)
         CCOF = SGTCOE (4,19)
         DCOF = SGTCOE (5,19)
c  |  Compute the pi+ p elastic cross section:
         SPPPEL = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
c  |  Compute the pi+ p inelastic cross section:
         SPPPIN = SPPPTT - SPPPEL
         ACOF = SGTCOE (1,4)
         BCOF = SGTCOE (2,4)
         ENNE = SGTCOE (3,4)
         CCOF = SGTCOE (4,4)
         DCOF = SGTCOE (5,4)
c  |  Compute the pi- p total cross section:
         SPMPTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
         ACOF = SGTCOE (1,20)
         BCOF = SGTCOE (2,20)
         ENNE = SGTCOE (3,20)
         CCOF = SGTCOE (4,20)
         DCOF = SGTCOE (5,20)
c  |  Compute the pi- p elastic cross section:
         SPMPEL = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
c  |  Compute the pi- p inelastic cross section:
         SPMPIN = SPMPTT - SPMPEL
         SIGDIA = SPMPIN - SPPPIN
c  |  +----------------------------------------------------------------*
c  |  |  Charged pions: besides isospin consideration it is supposed
c  |  |                 that (pi+ n)el is almost equal to (pi- p)el
c  |  |                 and  (pi+ p)el "    "     "    "  (pi- n)el
c  |  |                 and all are almost equal among each others
c  |  |                 (reasonable above 5 GeV/c)
         IF ( ICHRGE (IP) .NE. 0 ) THEN
            KHELP = KTARG / 8
            JREAC = 3 + IP - 13 + ICHRGE (IP) * KHELP
            ACOF = SGTCOE (1,JREAC)
            BCOF = SGTCOE (2,JREAC)
            ENNE = SGTCOE (3,JREAC)
            CCOF = SGTCOE (4,JREAC)
            DCOF = SGTCOE (5,JREAC)
c  |  |  Compute the total cross section:
            SHNCTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &             + DCOF * ALGPLA
            JREAC = 19 + IP - 13 + ICHRGE (IP) * KHELP
            ACOF = SGTCOE (1,JREAC)
            BCOF = SGTCOE (2,JREAC)
            ENNE = SGTCOE (3,JREAC)
            CCOF = SGTCOE (4,JREAC)
            DCOF = SGTCOE (5,JREAC)
c  |  |  Compute the elastic cross section:
            SHNCEL = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &             + DCOF * ALGPLA
c  |  |  Compute the inelastic cross section:
            SHNCIN = SHNCTT - SHNCEL
c  |  |  Number of diagrams:
            NDIAGR = 1 + IP - 13 + ICHRGE (IP) * KHELP
c  |  |  Now compute the chain end (anti)quark-(anti)diquark
            IQFSC1 = 1 + IP - 13
            IQFSC2 = 0
            IQBSC1 = 1 + KHELP
            IQBSC2 = 1 + IP - 13
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  pi0: besides isospin consideration it is supposed that the
c  |  |       elastic cross section is not very different from
c  |  |       pi+ p and/or pi- p (reasonable above 5 GeV/c)
         ELSE
            KHELP  = KTARG / 8
            K2HLP  = ( KP - 23 ) / 3
c  |  |  Number of diagrams:
c  |  |  For u ubar (k2hlp=0):
c           NDIAGR = 2 - KHELP
c  |  |  For d dbar (k2hlp=1):
c           NDIAGR = 2 + KHELP - K2HLP
            NDIAGR = 2 + KHELP * ( 2 * K2HLP - 1 ) - K2HLP
            SHNCIN = HLFHLF * ( SPPPIN + SPMPIN )
c  |  |  Now compute the chain end (anti)quark-(anti)diquark
            IQFSC1 = 1 + K2HLP
            IQFSC2 = 0
            IQBSC1 = 1 + KHELP
            IQBSC2 = 2 - K2HLP
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |                                                   end pi's
c  +-------------------------------------------------------------------*
c  |  Kaons:
      ELSE IF ( IHLP (IP) .EQ. 3 ) THEN
         ACOF = SGTCOE (1,6)
         BCOF = SGTCOE (2,6)
         ENNE = SGTCOE (3,6)
         CCOF = SGTCOE (4,6)
         DCOF = SGTCOE (5,6)
c  |  Compute the K+ p total cross section:
         SKPPTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
         ACOF = SGTCOE (1,21)
         BCOF = SGTCOE (2,21)
         ENNE = SGTCOE (3,21)
         CCOF = SGTCOE (4,21)
         DCOF = SGTCOE (5,21)
c  |  Compute the K+ p elastic cross section:
         SKPPEL = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
c  |  Compute the K+ p inelastic cross section:
         SKPPIN = SKPPTT - SKPPEL
         ACOF = SGTCOE (1,9)
         BCOF = SGTCOE (2,9)
         ENNE = SGTCOE (3,9)
         CCOF = SGTCOE (4,9)
         DCOF = SGTCOE (5,9)
c  |  Compute the K- p total cross section:
         SKMPTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
         ACOF = SGTCOE (1,22)
         BCOF = SGTCOE (2,22)
         ENNE = SGTCOE (3,22)
         CCOF = SGTCOE (4,22)
         DCOF = SGTCOE (5,22)
c  |  Compute the K- p elastic cross section:
         SKMPEL = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
c  |  Compute the K- p inelastic cross section:
         SKMPIN = SKMPTT - SKMPEL
         SIGDIA = HLFHLF * ( SKMPIN - SKPPIN )
c  |  +----------------------------------------------------------------*
c  |  |  Charged Kaons: actually only K-
         IF ( ICHRGE (IP) .NE. 0 ) THEN
            KHELP = KTARG / 8
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Proton target:
            IF ( KHELP .EQ. 0 ) THEN
               SHNCIN = SKMPIN
c  |  |  |  Number of diagrams:
               NDIAGR = 2
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Neutron target: besides isospin consideration it is supposed
c  |  |  |              that (K- n)el is almost equal to (K- p)el
c  |  |  |              (reasonable above 5 GeV/c)
            ELSE
               ACOF = SGTCOE (1,10)
               BCOF = SGTCOE (2,10)
               ENNE = SGTCOE (3,10)
               CCOF = SGTCOE (4,10)
               DCOF = SGTCOE (5,10)
c  |  |  |  Compute the total cross section:
               SHNCTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &                + DCOF * ALGPLA
c  |  |  |  Compute the elastic cross section:
               SHNCEL = SKMPEL
c  |  |  |  Compute the inelastic cross section:
               SHNCIN = SHNCTT - SHNCEL
c  |  |  |  Number of diagrams:
               NDIAGR = 1
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  Now compute the chain end (anti)quark-(anti)diquark
            IQFSC1 = 3
            IQFSC2 = 0
            IQBSC1 = 1 + KHELP
            IQBSC2 = 2
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  K0's: (actually only K0bar)
         ELSE
            KHELP  = KTARG / 8
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Proton target: (K0bar p)in supposed to be given by
c  |  |  |                 (K- p)in - Sig_diagr
            IF ( KHELP .EQ. 0 ) THEN
               SHNCIN = SKMPIN - SIGDIA
c  |  |  |  Number of diagrams:
               NDIAGR = 1
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Neutron target: (K0bar n)in supposed to be given by
c  |  |  |                 (K- n)in + Sig_diagr
c  |  |  |              besides isospin consideration it is supposed
c  |  |  |              that (K- n)el is almost equal to (K- p)el
c  |  |  |              (reasonable above 5 GeV/c)
            ELSE
               ACOF = SGTCOE (1,10)
               BCOF = SGTCOE (2,10)
               ENNE = SGTCOE (3,10)
               CCOF = SGTCOE (4,10)
               DCOF = SGTCOE (5,10)
c  |  |  |  Compute the total cross section:
               SHNCTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &                + DCOF * ALGPLA
c  |  |  |  Compute the elastic cross section:
               SHNCEL = SKMPEL
c  |  |  |  Compute the inelastic cross section:
               SHNCIN = SHNCTT - SHNCEL + SIGDIA
c  |  |  |  Number of diagrams:
               NDIAGR = 2
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  Now compute the chain end (anti)quark-(anti)diquark
            IQFSC1 = 3
            IQFSC2 = 0
            IQBSC1 = 1
            IQBSC2 = 1 + KHELP
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |                                                   end Kaon's
c  +-------------------------------------------------------------------*
c  |  Antinucleons:
      ELSE IF ( IHLP (IP) .EQ. 4 .AND. IP .LE. 9 ) THEN
c  |  For momenta between 3 and 5 GeV/c the use of tabulated data
c  |  should be implemented!
         ACOF = SGTCOE (1,15)
         BCOF = SGTCOE (2,15)
         ENNE = SGTCOE (3,15)
         CCOF = SGTCOE (4,15)
         DCOF = SGTCOE (5,15)
c  |  Compute the pbar p total cross section:
         SAPPTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
         IF ( PLA .LT. FIVFIV ) THEN
            JREAC = 26
         ELSE
            JREAC = 25
         END IF
         ACOF = SGTCOE (1,JREAC)
         BCOF = SGTCOE (2,JREAC)
         ENNE = SGTCOE (3,JREAC)
         CCOF = SGTCOE (4,JREAC)
         DCOF = SGTCOE (5,JREAC)
c  |  Compute the pbar p elastic cross section:
         SAPPEL = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
c  |  Compute the pbar p inelastic cross section:
         SAPPIN = SAPPTT - SAPPEL
         ACOF = SGTCOE (1,12)
         BCOF = SGTCOE (2,12)
         ENNE = SGTCOE (3,12)
         CCOF = SGTCOE (4,12)
         DCOF = SGTCOE (5,12)
c  |  Compute the p p total cross section:
         SPPTOT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
         ACOF = SGTCOE (1,23)
         BCOF = SGTCOE (2,23)
         ENNE = SGTCOE (3,23)
         CCOF = SGTCOE (4,23)
         DCOF = SGTCOE (5,23)
c  |  Compute the p p elastic cross section:
         SPPELA = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
c  |  Compute the K- p inelastic cross section:
         SPPINE = SPPTOT - SPPELA
         SIGDIA = ( SAPPIN - SPPINE ) / FIVFIV
         KHELP  = KTARG / 8
c  |  +----------------------------------------------------------------*
c  |  |  Pbar:
         IF ( ICHRGE (IP) .NE. 0 ) THEN
            NDIAGR = 5 - KHELP
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Proton target:
            IF ( KHELP .EQ. 0 ) THEN
c  |  |  |  Number of diagrams:
               SHNCIN = SAPPIN
               PUUBAR = 0.8D+00
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Neutron target: it is supposed that (ap n)el is almost equal
c  |  |  |                  to (ap p)el (reasonable above 5 GeV/c)
            ELSE
               ACOF = SGTCOE (1,16)
               BCOF = SGTCOE (2,16)
               ENNE = SGTCOE (3,16)
               CCOF = SGTCOE (4,16)
               DCOF = SGTCOE (5,16)
c  |  |  |  Compute the total cross section:
               SHNCTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &                + DCOF * ALGPLA
c  |  |  |  Compute the elastic cross section:
               SHNCEL = SAPPEL
c  |  |  |  Compute the inelastic cross section:
               SHNCIN = SHNCTT - SHNCEL
               PUUBAR = HLFHLF
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  Now compute the chain end (anti)quark-(anti)diquark
c  |  |  there are different possibilities, make a random choiche:
            IQFSC1 = -1
            RNCHEN = DT_RNDM(PUUBAR)
            IF ( RNCHEN .LT. PUUBAR ) THEN
               IQFSC2 = -2
            ELSE
               IQFSC2 = -1
            END IF
            IQBSC1 = -IQFSC1 + KHELP
            IQBSC2 = -IQFSC2
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  nbar:
         ELSE
            NDIAGR = 4 + KHELP
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Proton target: (nbar p)in supposed to be given by
c  |  |  |                 (pbar p)in - Sig_diagr
            IF ( KHELP .EQ. 0 ) THEN
               SHNCIN = SAPPIN - SIGDIA
               PDDBAR = HLFHLF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Neutron target: (nbar n)el is supposed to be equal to
c  |  |  |                  (pbar p)el (reasonable above 5 GeV/c)
            ELSE
c  |  |  |  Compute the total cross section:
               SHNCTT = SAPPTT
c  |  |  |  Compute the elastic cross section:
               SHNCEL = SAPPEL
c  |  |  |  Compute the inelastic cross section:
               SHNCIN = SHNCTT - SHNCEL
               PDDBAR = 0.8D+00
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  Now compute the chain end (anti)quark-(anti)diquark
c  |  |  there are different possibilities, make a random choiche:
            IQFSC1 = -2
            RNCHEN = DT_RNDM(RNCHEN)
            IF ( RNCHEN .LT. PDDBAR ) THEN
               IQFSC2 = -1
            ELSE
               IQFSC2 = -2
            END IF
            IQBSC1 = -IQFSC1 + KHELP - 1
            IQBSC2 = -IQFSC2
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |
c  +-------------------------------------------------------------------*
c  |  Others: not yet implemented
      ELSE
         SIGDIA = ZERZER
         SHNCIN = ONEONE
         NDIAGR = 0
         DT_PHNSCH = ZERZER
         RETURN
      END IF
c  |                                                   end others
c  +-------------------------------------------------------------------*
      DT_PHNSCH = NDIAGR * SIGDIA / SHNCIN
      IQECHC = IQECHR (IQFSC1) + IQECHR (IQFSC2) + IQECHR (IQBSC1)
     &       + IQECHR (IQBSC2)
      IQBCHC = IQBCHR (IQFSC1) + IQBCHR (IQFSC2) + IQBCHR (IQBSC1)
     &       + IQBCHR (IQBSC2)
      IQECHC = IQECHC / 3
      IQBCHC = IQBCHC / 3
      IQSCHC = IQSCHR (IQFSC1) + IQSCHR (IQFSC2) + IQSCHR (IQBSC1)
     &       + IQSCHR (IQBSC2)
      IQSPRO = IQSCHR (MQUARK(1,IP)) + IQSCHR (MQUARK(2,IP))
     &       + IQSCHR (MQUARK(3,IP))
c  +-------------------------------------------------------------------*
c  |  Consistency check:
      IF ( DT_PHNSCH .LE. ZERZER .OR. DT_PHNSCH .GT. ONEONE ) THEN
         WRITE (ErrorOut,*)' *** Phnsch,kp,ktarg,pla',
     &                         DT_PHNSCH,KP,KTARG,PLA,' ****'
         WRITE (ErrorOut,*)' *** Phnsch,kp,ktarg,pla',
     &                         DT_PHNSCH,KP,KTARG,PLA,' ****'
         DT_PHNSCH = MAX ( DT_PHNSCH, ZERZER )
         DT_PHNSCH = MIN ( DT_PHNSCH, ONEONE )
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Consistency check:
      IF ( IQSPRO .NE. IQSCHC .OR. ICHRGE (IP) + ICHRGE (KTARG)
     &     .NE. IQECHC .OR. IIBAR (KP) + IIBAR (KTARG) .NE. IQBCHC) THEN
         WRITE (ErrorOut,*)
     &' *** PHNSCH,IQSPRO,IQSCHC,ICHRGE,IQECHC,IBAR,IQBCHC,KTARG',
     &      IQSPRO,IQSCHC,ICHRGE(IP),IQECHC,IIBAR(KP),IQBCHC,KTARG
         WRITE (ErrorOut,*)
     &' *** PHNSCH,IQSPRO,IQSCHC,ICHRGE,IQECHC,IBAR,IQBCHC,KTARG',
     &      IQSPRO,IQSCHC,ICHRGE(IP),IQECHC,IIBAR(KP),IQBCHC,KTARG
      END IF
c  |
c  +-------------------------------------------------------------------*
c  P_sch = 1 / [ ( 1 / P_sch (50) - 1 ) x sqrt(s/s(50)) + 1 ]
      IF ( UMORAT .GT. ONEPLS )
     &   DT_PHNSCH = ONEONE / ( ( ONEONE / DT_PHNSCH
     &                                 - ONEONE ) * UMORAT + ONEONE )
      RETURN
c
      ENTRY DT_SCHQUA ( JQFSC1, JQFSC2, JQBSC1, JQBSC2 )
      DT_SCHQUA = ONEONE
      JQFSC1 = IQFSC1
      JQFSC2 = IQFSC2
      JQBSC1 = IQBSC1
      JQBSC2 = IQBSC2
c=== End of function Phnsch ===========================================*
      RETURN
      END
c
c===respt==============================================================*
c
CDECK  ID>, DT_RESPT
      SUBROUTINE DT_RESPT

c***********************************************************************
c Check DTEVT1 for two-resonance systems and sample intrinsic p_t.     *
c This version dated 18.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY7=1.0D-7,TINY3=1.0D-3)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)


c get index of first chain
      DO 1 I=NPOINT(3),NHKK
         IF (IDHKK(I).EQ.88888) THEN
            NC = I
            GOTO 2
         ENDIF
    1 CONTINUE

    2 CONTINUE
      IF ((IDHKK(NC).EQ.88888).AND.(IDHKK(NC+3).EQ.88888)) THEN
C        WRITE(LOUT,*)NC,NC+3,IDRES(NC),IDRES(NC+3)
c skip VV-,SS- systems
         IF ((IDCH(NC  ).NE.1).AND.(IDCH(NC  ).NE.8).AND.
     &       (IDCH(NC+3).NE.1).AND.(IDCH(NC+3).NE.8)) THEN
c check if both "chains" are resonances
            IF ((IDRES(NC).NE.0).AND.(IDRES(NC+3).NE.0)) THEN
               CALL DT_SAPTRE(NC,NC+3)
            ENDIF
         ENDIF
      ELSE
         GOTO 3
      ENDIF
      NC = NC+6
      GOTO 2

    3 CONTINUE

      RETURN
      END
c
c===evtres=============================================================*
c
CDECK  ID>, DT_EVTRES
      SUBROUTINE DT_EVTRES(IREJ)

c***********************************************************************
c This version dated 14.12.94 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY5=1.0D-5,TINY10=1.0D-10)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


      DIMENSION PP1(4),PP2(4),PT1(4),PT2(4),IFP(2),IFT(2)

      IREJ = 0

      DO 1 I=NPOINT(3),NHKK
         IF (ABS(IDRES(I)).GE.100) THEN
            AMMX = 0.0D0
            DO 2 J=NPOINT(3),NHKK
               IF (IDHKK(J).EQ.88888) THEN
                  IF (PHKK(5,J).GT.AMMX) THEN
                     AMMX = PHKK(5,J)
                     IMMX = J
                  ENDIF
               ENDIF
    2       CONTINUE
            IF (IDRES(IMMX).NE.0) THEN
               IF (IOULEV(3).GT.0) THEN
                  WRITE(ErrorOut,'(1X,A)')
     &               'EVTRES: NO CHAIN FOR CORREC. FOUND'
C                 GOTO 6
                  GOTO 9999
               ELSE
                  GOTO 9999
               ENDIF
            ENDIF
            IMO11  = JMOHKK(1,I)
            IMO12  = JMOHKK(2,I)
            IF (PHKK(3,IMO11).LT.0.0D0) THEN
               IMO11 = JMOHKK(2,I)
               IMO12 = JMOHKK(1,I)
            ENDIF
            IMO21  = JMOHKK(1,IMMX)
            IMO22  = JMOHKK(2,IMMX)
            IF (PHKK(3,IMO21).LT.0.0D0) THEN
               IMO21 = JMOHKK(2,IMMX)
               IMO22 = JMOHKK(1,IMMX)
            ENDIF
            AMCH1  = PHKK(5,I)
            AMCH1N = AAM(IDXRES(I))

            IFPR1 = IDHKK(IMO11)
            IFPR2 = IDHKK(IMO21)
            IFTA1 = IDHKK(IMO12)
            IFTA2 = IDHKK(IMO22)
            DO 4 J=1,4
               PP1(J) = PHKK(J,IMO11)
               PP2(J) = PHKK(J,IMO21)
               PT1(J) = PHKK(J,IMO12)
               PT2(J) = PHKK(J,IMO22)
    4       CONTINUE
c store initial configuration for energy-momentum cons. check
            IF (LEMCCK) CALL DT_EMC1(PP1,PP2,PT1,PT2,1,1,IREJ1)
c correct kinematics of second chain
            CALL DT_CHKINE(PP1,IFPR1,PP2,IFPR2,PT1,IFTA1,PT2,IFTA2,
     &                  AMCH1,AMCH1N,AMCH2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
c check now this chain for resonance mass
            IFP(1) = IDT_IPDG2B(IFPR2,1,2)
            IFP(2) = 0
            IF (ABS(IFPR2).GE.1000) IFP(2) = IDT_IPDG2B(IFPR2,2,2)
            IFT(1) = IDT_IPDG2B(IFTA2,1,2)
            IFT(2) = 0
            IF (ABS(IFTA2).GE.1000) IFT(2) = IDT_IPDG2B(IFTA2,2,2)
            IDCH2 = 2
            IF ((IFP(2).EQ.0).AND.(IFT(2).EQ.0)) IDCH2 = 1
            IF ((IFP(2).NE.0).AND.(IFT(2).NE.0)) IDCH2 = 3
            CALL DT_CH2RES(IFP(1),IFP(2),IFT(1),IFT(2),IDR2,IDXR2,
     &                  AMCH2,AMCH2N,IDCH2,IREJ1)
            IF ((IREJ1.NE.0).OR.(IDR2.NE.0)) THEN
               IF (IOULEV(1).GT.0)
     &            WRITE(ErrorOut,
     * *) ' correction for resonance not poss.'
c*sr test
C              GOTO 1
C              GOTO 9999
c*
            ENDIF
c store final configuration for energy-momentum cons. check
            IF (LEMCCK) THEN
               CALL DT_EMC1(PP1,PP2,PT1,PT2,-2,1,IREJ1)
               CALL DT_EMC1(PP1,PP2,PT1,PT2,3,1,IREJ1)
               IF (IREJ1.NE.0) GOTO 9999
            ENDIF
            DO 5 J=1,4
               PHKK(J,IMO11) = PP1(J)
               PHKK(J,IMO21) = PP2(J)
               PHKK(J,IMO12) = PT1(J)
               PHKK(J,IMO22) = PT2(J)
    5       CONTINUE
c correct entries of chains
            DO 3 K=1,4
               PHKK(K,I)    = PHKK(K,IMO11)+PHKK(K,IMO12)
               PHKK(K,IMMX) = PHKK(K,IMO21)+PHKK(K,IMO22)
    3       CONTINUE
            AM1 = PHKK(4,I)**2-PHKK(1,I)**2-PHKK(2,I)**2-PHKK(3,I)**2
            AM2 = PHKK(4,IMMX)**2-PHKK(1,IMMX)**2-PHKK(2,IMMX)**2-
     &            PHKK(3,IMMX)**2
c ?? the following should now be obsolete
c*sr test
C           IF ((AM1.LT.0.0D0).OR.(AM2.LT.1.0D0)) THEN
            IF ((AM1.LT.0.0D0).OR.(AM2.LT.0.0D0)) THEN
c*
               WRITE(ErrorOut,'(1X,A,4G10.3)')
     &          'EVTRES: INONSISTENT MASS-CORR.',AM1,AM2
C              GOTO 9999
               GOTO 1
            ENDIF
            PHKK(5,I)    = SQRT(AM1)
            PHKK(5,IMMX) = SQRT(AM2)
            IDRES(I)     = IDRES(I)/100
            IF ((ABS(PHKK(5,I)-AMCH1N).GT.TINY5).OR.
     &          (ABS(PHKK(5,IMMX)-AMCH2).GT.TINY5)) THEN
               WRITE(ErrorOut,'(1X,A,4G10.3)')
     &          'EVTRES: INCONSISTENT CHAIN-MASSES',
     &          PHKK(5,I),AMCH1N,PHKK(5,IMMX),AMCH2
               GOTO 9999
            ENDIF
         ENDIF
    1 CONTINUE
    6 CONTINUE
      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===getspt=============================================================*
c
CDECK  ID>, DT_GETSPT
      SUBROUTINE DT_GETSPT(PP1I,IFPR1,IFP1,PP2I,IFPR2,IFP2,
     &                  PT1I,IFTA1,IFT1,PT2I,IFTA2,IFT2,
     &                  AM1,IDCH1,AM2,IDCH2,IDCHAI,IREJ)

c***********************************************************************
c This version dated 12.12.94 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY5=1.0D-5,TINY3=1.0D-3,ZERO=0.0D0)



c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF


      DIMENSION PP1(4),PP1I(4),PP2(4),PP2I(4),PT1(4),PT1I(4),
     &          PT2(4),PT2I(4),P1(4),P2(4),
     &          IFP1(2),IFP2(2),IFT1(2),IFT2(2),
     &          PTOTI(4),PTOTF(4),DIFF(4)

      IC   = 0
      IREJ = 0
C     B33P = 4.0D0
C     B33T = 4.0D0
C     IF ((IDCHAI.EQ.6).OR.(IDCHAI.EQ.7).OR.(IDCHAI.EQ.8)) B33P = 2.0D0
C     IF ((IDCHAI.EQ.4).OR.(IDCHAI.EQ.5).OR.(IDCHAI.EQ.8)) B33T = 2.0D0
      REDU = 1.0D0
C     B33P = 3.5D0
C     B33T = 3.5D0
      B33P = 4.0D0
      B33T = 4.0D0
      IF (IDIFF.NE.0) THEN
         B33P = 16.0D0
         B33T = 16.0D0
      ENDIF

      DO 1 I=1,4
         PTOTI(I) = PP1I(I)+PP2I(I)+PT1I(I)+PT2I(I)
         PP1(I)   = PP1I(I)
         PP2(I)   = PP2I(I)
         PT1(I)   = PT1I(I)
         PT2(I)   = PT2I(I)
    1 CONTINUE
c get initial chain masses
      PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                               +(PP1(3)+PT1(3))**2)
      ECH   = PP1(4)+PT1(4)
      AM1   = (ECH+PTOCH)*(ECH-PTOCH)
      PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                               +(PP2(3)+PT2(3))**2)
      ECH   = PP2(4)+PT2(4)
      AM2   = (ECH+PTOCH)*(ECH-PTOCH)
      IF ((AM1.LT.0.0D0).OR.(AM2.LT.0.0D0)) THEN
         IF (IOULEV(1).GT.0)
     &   WRITE(ErrorOut,
     * '(1X,A,2G10.3)')'GETSPT: too small chain masses 1',
     &                              AM1,AM2
         GOTO 9999
      ENDIF
      AM1  = SQRT(AM1)
      AM2  = SQRT(AM2)
      AM1N = ZERO
      AM2N = ZERO

      MODE = 0
C      IF ((AM1.GE.3.0D0).AND.(AM2.GE.3.0D0)) THEN
C        MODE = 0
C      ELSE
C         MODE = 1
C         IF (AM1.LT.0.6) THEN
C            B33P = 10.0D0
C         ELSEIF ((AM1.GE.1.2).AND.(AM1.LT.3.0D0)) THEN
CC           B33P = 4.0D0
C         ENDIF
C         IF (AM2.LT.0.6) THEN
C            B33T = 10.0D0
C         ELSEIF ((AM2.GE.1.2).AND.(AM2.LT.3.0D0)) THEN
CC           B33T = 4.0D0
C         ENDIF
C      ENDIF

c check chain masses for very low mass chains
C     CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),IDUM,IDUM,
C    &            AM1,DUM,-IDCH1,IREJ1)
C     CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),IDUM,IDUM,
C    &            AM2,DUM,-IDCH2,IREJ2)
C     IF ((IREJ1.NE.0).OR.(IREJ2.NE.0)) THEN
C        B33P = 20.0D0
C        B33T = 20.0D0
C     ENDIF

      JMSHL = IMSHL

    2 CONTINUE
      IC = IC+1
      IF (MOD(IC,15).EQ.0) B33P  = 2.0D0*B33P
      IF (MOD(IC,15).EQ.0) B33T  = 2.0D0*B33T
      IF (MOD(IC,18).EQ.0) REDU  = 0.0D0
C     IF (MOD(IC,19).EQ.0) JMSHL = 0
      IF (MOD(IC,20).EQ.0) GOTO 7
C        WRITE(LOUT,'(1X,A)') 'GETSPT: rejection '
C        RETURN
C        GOTO 9999
C     ENDIF

c get transverse momentum
      IF (LINTPT) THEN
         ES   = -2.0D0/(B33P**2)
     &          *LOG(ABS(DT_RNDM(AM1)*DT_RNDM(AM2))+TINY10)
         HPSP = SQRT(ES*ES+2.0D0*ES*0.94D0)
         HPSP = HPSP*REDU
         ES   = -2.0D0/(B33T**2)
     &          *LOG(ABS(DT_RNDM(AM1)*DT_RNDM(AM2))+TINY10)
         HPST = SQRT(ES*ES+2.0D0*ES*0.94D0)
         HPST = HPST*REDU
      ELSE
         HPSP = ZERO
         HPST = ZERO
      ENDIF
      CALL DT_DSFECF(SFE1,CFE1)
      CALL DT_DSFECF(SFE2,CFE2)
      IF (MODE.EQ.0) THEN
         PP1(1) = PP1I(1)+HPSP*CFE1
         PP1(2) = PP1I(2)+HPSP*SFE1
         PP2(1) = PP2I(1)-HPSP*CFE1
         PP2(2) = PP2I(2)-HPSP*SFE1
         PT1(1) = PT1I(1)+HPST*CFE2
         PT1(2) = PT1I(2)+HPST*SFE2
         PT2(1) = PT2I(1)-HPST*CFE2
         PT2(2) = PT2I(2)-HPST*SFE2
      ELSE
         PP1(1) = PP1I(1)+HPSP*CFE1
         PP1(2) = PP1I(2)+HPSP*SFE1
         PT1(1) = PT1I(1)-HPSP*CFE1
         PT1(2) = PT1I(2)-HPSP*SFE1
         PP2(1) = PP2I(1)+HPST*CFE2
         PP2(2) = PP2I(2)+HPST*SFE2
         PT2(1) = PT2I(1)-HPST*CFE2
         PT2(2) = PT2I(2)-HPST*SFE2
      ENDIF

c put partons on mass shell
      XMP1 = 0.0D0
      XMT1 = 0.0D0
      IF (JMSHL.EQ.1) THEN

         XMP1 = PYMASS(IFPR1)
         XMT1 = PYMASS(IFTA1)

      ENDIF
      CALL DT_MASHEL(PP1,PT1,XMP1,XMT1,P1,P2,IREJ1)
      IF (IREJ1.NE.0) GOTO 2
      DO 3 I=1,4
         PTOTF(I) = P1(I)+P2(I)
         PP1(I)   = P1(I)
         PT1(I)   = P2(I)
    3 CONTINUE
      XMP2 = 0.0D0
      XMT2 = 0.0D0
      IF (JMSHL.EQ.1) THEN

         XMP2 = PYMASS(IFPR2)
         XMT2 = PYMASS(IFTA2)

      ENDIF
      CALL DT_MASHEL(PP2,PT2,XMP2,XMT2,P1,P2,IREJ1)
      IF (IREJ1.NE.0) GOTO 2
      DO 4 I=1,4
         PTOTF(I) = PTOTF(I)+P1(I)+P2(I)
         PP2(I)   = P1(I)
         PT2(I)   = P2(I)
    4 CONTINUE

c check consistency
      DO 5 I=1,4
         DIFF(I) = PTOTI(I)-PTOTF(I)
    5 CONTINUE
      IF ((ABS(DIFF(1)).GT.TINY5).OR.(ABS(DIFF(2)).GT.TINY5).OR.
     &    (ABS(DIFF(3)).GT.TINY5).OR.(ABS(DIFF(4)).GT.TINY5)) THEN
         WRITE(ErrorOut,
     * '(1X,A,4G10.3)') 'GETSPT: inconsistencies ',DIFF
         GOTO 9999
      ENDIF
      PTOTP1 = SQRT(PP1(1)**2+PP1(2)**2+PP1(3)**2)
      AMP1 = SQRT(ABS( (PP1(4)-PTOTP1)*(PP1(4)+PTOTP1) ))
      PTOTP2 = SQRT(PP2(1)**2+PP2(2)**2+PP2(3)**2)
      AMP2 = SQRT(ABS( (PP2(4)-PTOTP2)*(PP2(4)+PTOTP2) ))
      PTOTT1 = SQRT(PT1(1)**2+PT1(2)**2+PT1(3)**2)
      AMT1 = SQRT(ABS( (PT1(4)-PTOTT1)*(PT1(4)+PTOTT1) ))
      PTOTT2 = SQRT(PT2(1)**2+PT2(2)**2+PT2(3)**2)
      AMT2 = SQRT(ABS( (PT2(4)-PTOTT2)*(PT2(4)+PTOTT2) ))
      IF ((ABS(AMP1-XMP1).GT.TINY3).OR.(ABS(AMP2-XMP2).GT.TINY3).OR.
     &    (ABS(AMT1-XMT1).GT.TINY3).OR.(ABS(AMT2-XMT2).GT.TINY3))
     &                                                           THEN
         WRITE(ErrorOut,'(1X,A,2(4G10.3,/))')
     &     'GETSPT: INCONSISTENT MASSES',
     &     AMP1,XMP1,AMP2,XMP2,AMT1,XMT1,AMT2,XMT2
c sr 22.11.00: commented. It should only have inconsistent masses for
c ultrahigh energies due to rounding problems
C        GOTO 9999
      ENDIF

c get chain masses
      PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                               +(PP1(3)+PT1(3))**2)
      ECH   = PP1(4)+PT1(4)
      AM1N  = (ECH+PTOCH)*(ECH-PTOCH)
      PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                               +(PP2(3)+PT2(3))**2)
      ECH   = PP2(4)+PT2(4)
      AM2N  = (ECH+PTOCH)*(ECH-PTOCH)
      IF ((AM1N.LT.0.0D0).OR.(AM2N.LT.0.0D0)) THEN
         IF (IOULEV(1).GT.0)
     &   WRITE(ErrorOut,
     * '(1X,A,2G10.3)')'GETSPT: too small chain masses 2',
     &                              AM1N,AM2N
         GOTO 2
      ENDIF
      AM1N = SQRT(AM1N)
      AM2N = SQRT(AM2N)

c check chain masses for very low mass chains
      CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),IDUM,IDUM,
     &            AM1N,DUM,-IDCH1,IREJ1)
      IF (IREJ1.NE.0) GOTO 2
      CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),IDUM,IDUM,
     &            AM2N,DUM,-IDCH2,IREJ2)
      IF (IREJ2.NE.0) GOTO 2

    7 CONTINUE
      IF (AM1N.GT.ZERO) THEN
         AM1 = AM1N
         AM2 = AM2N
      ENDIF
      DO 6 I=1,4
         PP1I(I)   = PP1(I)
         PP2I(I)   = PP2(I)
         PT1I(I)   = PT1(I)
         PT2I(I)   = PT2(I)
    6 CONTINUE

      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===saptre=============================================================*
c
CDECK  ID>, DT_SAPTRE
      SUBROUTINE DT_SAPTRE(IDX1,IDX2)

c***********************************************************************
c p-t sampling for two-resonance systems. ("BAMJET-like" method)       *
c        IDX1,IDX2       indices of resonances ("chains") in DTEVT1    *
c Adopted from the original SAPTRE written by J. Ranft.                *
c This version dated 18.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY7=1.0D-7,TINY3=1.0D-3)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME


      DIMENSION PA1(4),PA2(4),P1(4),P2(4)

      DATA B3 /4.0D0/

      ESMAX1 = PHKK(4,IDX1)-PHKK(5,IDX1)
      ESMAX2 = PHKK(4,IDX2)-PHKK(5,IDX2)
      ESMAX  = MIN(ESMAX1,ESMAX2)
      IF (ESMAX.LE.0.05D0) RETURN

      HMA    = PHKK(5,IDX1)
      DO 1 K=1,4
         PA1(K) = PHKK(K,IDX1)
         PA2(K) = PHKK(K,IDX2)
    1 CONTINUE

      IF (LEMCCK) THEN
         CALL DT_EVTEMC(PA1(1),PA1(2),PA1(3),PA1(4),1,IDUM,IDUM)
         CALL DT_EVTEMC(PA2(1),PA2(2),PA2(3),PA2(4),2,IDUM,IDUM)
      ENDIF

      EXEB   = 0.0D0
      IF (B3*ESMAX.LE.60.0D0) EXEB = EXP(-B3*ESMAX)
      BEXP   = HMA*(1.0D0-EXEB)/B3
      AXEXP  = (1.0D0-(B3*ESMAX-1.0D0)*EXEB)/B3**2
      WA     = AXEXP/(BEXP+AXEXP)
      XAB    = DT_RNDM(WA)
   10 CONTINUE
c ES is the transverse kinetic energy
      IF (XAB.LT.WA)THEN
        X  = DT_RNDM(WA)
        Y  = DT_RNDM(WA)
        ES = -2.0D0/(B3**2)*LOG(X*Y+TINY7)
      ELSE
        X  = DT_RNDM(Y)
        ES = ABS(-LOG(X+TINY7)/B3)
      ENDIF
      IF (ES.GT.ESMAX) GOTO 10
      ES  = ES+HMA
c transverse momentum
      HPS = SQRT((ES-HMA)*(ES+HMA))

      CALL DT_DSFECF(SFE,CFE)
      HPX = HPS*CFE
      HPY = HPS*SFE
      PZ1NSQ = PA1(3)**2-HPS**2-2.0D0*PA1(1)*HPX-2.0D0*PA1(2)*HPY
      PZ2NSQ = PA2(3)**2-HPS**2+2.0D0*PA2(1)*HPX+2.0D0*PA2(2)*HPY
      IF ((PZ1NSQ.LT.TINY3).OR.(PZ2NSQ.LT.TINY3)) RETURN

C     PA1(3) = SIGN(SQRT(PZ1NSQ),PA1(3))
C     PA2(3) = SIGN(SQRT(PZ2NSQ),PA2(3))
      PA1(1) = PA1(1)+HPX
      PA1(2) = PA1(2)+HPY
      PA2(1) = PA2(1)-HPX
      PA2(2) = PA2(2)-HPY

c put resonances on mass-shell again
      XM1 = PHKK(5,IDX1)
      XM2 = PHKK(5,IDX2)
      CALL DT_MASHEL(PA1,PA2,XM1,XM2,P1,P2,IREJ1)
      IF (IREJ1.NE.0) RETURN

      IF (LEMCCK) THEN
         CALL DT_EVTEMC(-P1(1),-P1(2),-P1(3),-P1(4),2,IDUM,IDUM)
         CALL DT_EVTEMC(-P2(1),-P2(2),-P2(3),-P2(4),2,IDUM,IDUM)
         CALL DT_EVTEMC(DUM,DUM,DUM,DUM,3,12,IREJ1)
         IF (IREJ1.NE.0) RETURN
      ENDIF

      DO 2 K=1,4
         PHKK(K,IDX1) = P1(K)
         PHKK(K,IDX2) = P2(K)
    2 CONTINUE

      RETURN
      END
c
c===cronin=============================================================*
c
CDECK  ID>, DT_CRONIN
      SUBROUTINE DT_CRONIN(INCL)

c***********************************************************************
c Cronin-Effect. Multiple scattering of partons at chain ends.         *
c             INCL = 1     multiple sc. in projectile                  *
c                  = 2     multiple sc. in target                      *
c This version dated 05.01.96 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY3=1.0D-3)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC


      DIMENSION R(3),PIN(4),POUT(4),DEV(4)

      DO 1 K=1,4
         DEV(K) = ZERO
    1 CONTINUE

      DO 2 I=NPOINT(2),NHKK
         IF (ISTHKK(I).LT.0) THEN
c get z-position of the chain
            R(1) = VHKK(1,I)*1.0D12
            IF (INCL.EQ.2) R(1) = VHKK(1,I)*1.0D12-BIMPAC
            R(2) = VHKK(2,I)*1.0D12
            IDXNU = JMOHKK(1,I)
            IF ( (INCL.EQ.1).AND.(ISTHKK(IDXNU).EQ.10) )
     &                             IDXNU = JMOHKK(1,I-1)
            IF ( (INCL.EQ.2).AND.(ISTHKK(IDXNU).EQ. 9) )
     &                             IDXNU = JMOHKK(1,I+1)
            R(3) = VHKK(3,IDXNU)*1.0D12
c position of target parton the chain is connected to
            DO 3 K=1,4
               PIN(K) = PHKK(K,I)
    3       CONTINUE
c multiple scattering of parton with DTEVT1-index I
            CALL DT_CROMSC(PIN,R,POUT,INCL)
c*testprint
C           IF (NEVHKK.EQ.5) THEN
C              AMIN = PIN(4)**2-PIN(1)**2-PIN(2)**2-PIN(3)**2
C              AMOU = POUT(4)**2-POUT(1)**2-POUT(2)**2-POUT(3)**2
C              AMIN = SIGN(SQRT(ABS(AMIN)),AMIN)
C              AMOU = SIGN(SQRT(ABS(AMOU)),AMOU)
C              WRITE(6,'(A,I4,2E15.5)')'I,AMIN,AMOU: ',I,AMIN,AMOU
C              WRITE(6,'(A,4E15.5)')'PIN:       ',PIN
C              WRITE(6,'(A,4E15.5)')'POUT:      ',POUT
C           ENDIF
c*
c increase accumulator by energy-momentum difference
            DO 4 K=1,4
               DEV(K)    = DEV(K)+POUT(K)-PIN(K)
               PHKK(K,I) = POUT(K)
    4       CONTINUE
            PHKK(5,I) = SQRT(ABS(PHKK(4,I)**2-PHKK(1,I)**2-
     &                           PHKK(2,I)**2-PHKK(3,I)**2))
         ENDIF
    2 CONTINUE

c dump accumulator to momenta of valence partons
      NVAL = 0
      ETOT = 0.0D0
      DO 5 I=NPOINT(2),NHKK
         IF ((ISTHKK(I).EQ.-21).OR.(ISTHKK(I).EQ.-22)) THEN
            NVAL = NVAL+1
            ETOT = ETOT+PHKK(4,I)
         ENDIF
    5 CONTINUE
C     WRITE(LOUT,1000) NVAL,(DEV(K)/DBLE(NVAL),K=1,4)
 1000 FORMAT(1X,'CRONIN :  NUMBER OF VAL. PARTONS ',I4,/,
     &       9X,4E12.4)
      DO 6 I=NPOINT(2),NHKK
         IF ((ISTHKK(I).EQ.-21).OR.(ISTHKK(I).EQ.-22)) THEN
            E = PHKK(4,I)
            DO 7 K=1,4
C              PHKK(K,I) = PHKK(K,I)-DEV(K)/DBLE(NVAL)
               PHKK(K,I) = PHKK(K,I)-DEV(K)*E/ETOT
    7       CONTINUE
            PHKK(5,I) = SQRT(ABS(PHKK(4,I)**2-PHKK(1,I)**2-
     &                           PHKK(2,I)**2-PHKK(3,I)**2))
         ENDIF
    6 CONTINUE

      RETURN
      END
c
c===cromsc=============================================================*
c
CDECK  ID>, DT_CROMSC
      SUBROUTINE DT_CROMSC(PIN,R,POUT,INCL)

c***********************************************************************
c Cronin-Effect. Multiple scattering of one parton passing through     *
c nuclear matter.                                                      *
c            PIN(4)       input 4-momentum of parton                   *
c            POUT(4)      4-momentum of parton after mult. scatt.      *
c            R(3)         spatial position of parton in target nucleus *
c            INCL = 1     multiple sc. in projectile                   *
c                 = 2     multiple sc. in target                       *
c This is a revised version of the original version written by J. Ranft*
c This version dated 17.01.95 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY3=1.0D-3)

      LOGICAL LSTART

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      DIMENSION PIN(4),POUT(4),R(3)

      DATA LSTART /.TRUE./

      IRCRON(1) = IRCRON(1)+1

      IF (LSTART) THEN
         WRITE(ErrorOut,1000) CRONCO
 1000    FORMAT(/,1X,'CROMSC:  MULTIPLE SCATTERING OF CHAIN ENDS',
     &          ' TREATED',/,10X,'WITH PARAMETER CRONCO = ',F5.2)
         LSTART = .FALSE.
      ENDIF

      NCBACK = 0
      RNCL   = RPROJ
      IF (INCL.EQ.2) RNCL = RTARG

c Lorentz-transformation into Lab.
      MODE = -(INCL+1)
      CALL DT_LTNUC(PIN(3),PIN(4),PZ,PE,MODE)

      PTOT = SQRT(PIN(1)**2+PIN(2)**2+PZ**2)
      IF (PTOT.LE.8.0D0) GOTO 9997

c direction cosines of parton before mult. scattering
      COSX = PIN(1)/PTOT
      COSY = PIN(2)/PTOT
      COSZ = PZ/PTOT

      RTESQ = R(1)**2+R(2)**2+R(3)**2-RNCL**2
      IF (RTESQ.GE.-TINY3) GOTO 9999

c calculate distance (DIST) from R to surface of nucleus (radius RNCL)
c in the direction of particle motion

      A    = COSX*R(1)+COSY*R(2)+COSZ*R(3)
      TMP  = A**2-RTESQ
      IF (TMP.LT.ZERO) GOTO 9998
      DIST = -A+SQRT(TMP)

c multiple scattering angle
      THETO = CRONCO*SQRT(DIST)/PTOT
      IF (THETO.GT.0.1D0) THETO=0.1D0

    1 CONTINUE
c Gaussian sampling of spatial angle
      CALL DT_RANNOR(R1,R2)
      THETA = ABS(R1*THETO)
      IF (THETA.GT.0.3D0) GOTO 9997
      CALL DT_DSFECF(SFE,CFE)
      COSTH = COS(THETA)
      SINTH = SIN(THETA)

c new direction cosines
      CALL DT_MYTRAN(1,COSX,COSY,COSZ,COSTH,SINTH,SFE,CFE,
     &                               COSXN,COSYN,COSZN)

      POUT(1) = COSXN*PTOT
      POUT(2) = COSYN*PTOT
      PZ      = COSZN*PTOT
c Lorentz-transformation into nucl.-nucl. cms
      MODE = INCL+1
      CALL DT_LTNUC(PZ,PE,POUT(3),POUT(4),MODE)

C     IF (ABS(PIN(4)-POUT(4)).GT.0.2D0) THEN
C     IF ( (ABS(PIN(4)-POUT(4))/PIN(4)).GT.0.1D0 ) THEN
      IF ( (ABS(PIN(4)-POUT(4))/PIN(4)).GT.0.05D0 ) THEN
         THETO = THETO/2.0D0
         NCBACK = NCBACK+1
         IF (MOD(NCBACK,200).EQ.0) THEN
            WRITE(ErrorOut,1001) THETO,PIN,POUT
 1001       FORMAT(1X,'CROMSC: INCONSISTENT SCATTERING ANGLE ',
     &             E12.4,/,1X,'        PIN :',4E12.4,/,
     &             1X,'       POUT:',4E12.4)
            GOTO 9997
         ENDIF
         GOTO 1
      ENDIF

      RETURN

 9997 IRCRON(2) = IRCRON(2)+1
      GOTO 9999
 9998 IRCRON(3) = IRCRON(3)+1

 9999 CONTINUE
      DO 100 K=1,4
         POUT(K) = PIN(K)
  100 CONTINUE
      RETURN
      END
c
c===com2sr=============================================================*
c
CDECK  ID>, DT_COM2CR
      SUBROUTINE DT_COM2CR

c***********************************************************************
c COMbine q-aq chains to Color Ropes (qq-aqaq).                        *
c        CUTOF      parameter determining minimum number of not        *
c                   combined q-aq chains                               *
c This subroutine replaces KKEVCC etc.                                 *
c This version dated 11.01.95 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      DIMENSION IDXQA(248),IDXAQ(248)

      ICCHAI(1,9) = ICCHAI(1,9)+1
      NQA = 0
      NAQ = 0
c scan DTEVT1 for q-aq, aq-q chains
      DO 10 I=NPOINT(3),NHKK
c skip "chains" which are resonances
         IF ((IDHKK(I).EQ.88888).AND.(IDRES(I).EQ.0)) THEN
            MO1 = JMOHKK(1,I)
            MO2 = JMOHKK(2,I)
            IF ((ABS(IDHKK(MO1)).LE.6).AND.(ABS(IDHKK(MO2)).LE.6)) THEN
c q-aq, aq-q chain found, keep index
               IF (IDHKK(MO1).GT.0) THEN
                  NQA = NQA+1
                  IDXQA(NQA) = I
               ELSE
                  NAQ = NAQ+1
                  IDXAQ(NAQ) = I
               ENDIF
            ENDIF
         ENDIF
   10 CONTINUE

c minimum number of q-aq chains requested for the same projectile/
c target
      NCHMIN = IDT_NPOISS(CUTOF)

c combine q-aq chains of the same projectile
      CALL DT_SCN4CR(NQA,IDXQA,NCHMIN,1)
c combine q-aq chains of the same target
      CALL DT_SCN4CR(NQA,IDXQA,NCHMIN,2)
c combine aq-q chains of the same projectile
      CALL DT_SCN4CR(NAQ,IDXAQ,NCHMIN,1)
c combine aq-q chains of the same target
      CALL DT_SCN4CR(NAQ,IDXAQ,NCHMIN,2)

      RETURN
      END
c
c===scn4cr=============================================================*
c
CDECK  ID>, DT_SCN4CR
      SUBROUTINE DT_SCN4CR(NCH,IDXCH,NCHMIN,MODE)

c***********************************************************************
c SCan q-aq chains for Color Ropes.                                    *
c This version dated 11.01.95 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)


      DIMENSION IDXCH(248),IDXJN(248)

      DO 1 I=1,NCH
         IF (IDXCH(I).GT.0) THEN
            NJOIN = 1
            IDXMO = JMOHKK(1,JMOHKK(1,JMOHKK(MODE,IDXCH(I))))
            IDXJN(NJOIN) = I
            IF (I.LT.NCH) THEN
               DO 2 J=I+1,NCH
                  IF (IDXCH(J).GT.0) THEN
                     IDXMO1 = JMOHKK(1,JMOHKK(1,JMOHKK(MODE,IDXCH(J))))
                     IF (IDXMO.EQ.IDXMO1) THEN
                        NJOIN = NJOIN+1
                        IDXJN(NJOIN) = J
                     ENDIF
                  ENDIF
    2          CONTINUE
            ENDIF
            IF (NJOIN.GE.NCHMIN+2) THEN
               NJ = INT(DBLE(NJOIN-NCHMIN)/2.0D0)
               DO 3 J=1,2*NJ,2
                  CALL DT_JOIN(IDXCH(IDXJN(J)),IDXCH(IDXJN(J+1)),IREJ1)
                  IF (IREJ1.NE.0) GOTO 3
                  IDXCH(IDXJN(J))   = 0
                  IDXCH(IDXJN(J+1)) = 0
    3          CONTINUE
            ENDIF
         ENDIF
    1 CONTINUE

      RETURN
      END
c
c===join===============================================================*
c
CDECK  ID>, DT_JOIN
      SUBROUTINE DT_JOIN(IDX1,IDX2,IREJ)

c***********************************************************************
c This subroutine joins two q-aq chains to one qq-aqaq chain.          *
c     IDX1, IDX2       DTEVT1 indices of chains to be joined           *
c This version dated 11.01.95 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)



c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)


      DIMENSION MO(2,2),ID(2,2),IDX(2),PCH(4),PP(4),PT(4),P1(4),P2(4)

      IREJ   = 0

      IDX(1) = IDX1
      IDX(2) = IDX2
      DO 1 I=1,2
         DO 2 J=1,2
            MO(I,J) = JMOHKK(J,IDX(I))
            ID(I,J) = IDT_IPDG2B(IDHKK(MO(I,J)),1,2)
    2    CONTINUE
    1 CONTINUE

c check consistency
      IF ((ABS(ID(1,1)).GT.6).OR.(ABS(ID(1,2)).GT.6).OR.
     &    (ABS(ID(2,1)).GT.6).OR.(ABS(ID(2,2)).GT.6).OR.
     &    ((ID(1,1)*ID(2,1)).LT.0).OR.
     &    ((ID(1,2)*ID(2,2)).LT.0)) THEN
         WRITE(ErrorOut,
     * 1000) IDX(1),MO(1,1),MO(1,2),IDX(2),MO(2,1),
     &                    MO(2,2)
 1000    FORMAT(1X,'JOIN: INCONS. CHAIN SYSTEM! CHAIN ',I4,':',
     &             2I5,' CHAIN ',I4,':',2I5)
      ENDIF

c join chains
      DO 3 K=1,4
         PP(K) = PHKK(K,MO(1,1))+PHKK(K,MO(2,1))
         PT(K) = PHKK(K,MO(1,2))+PHKK(K,MO(2,2))
    3 CONTINUE
      IF1  = IDT_IB2PDG(ID(1,1),ID(2,1),2)
      IF2  = IDT_IB2PDG(ID(1,2),ID(2,2),2)
      IST1 = ISTHKK(MO(1,1))
      IST2 = ISTHKK(MO(1,2))

c put partons again on mass shell
      XM1 = 0.0D0
      XM2 = 0.0D0
      IF (IMSHL.EQ.1) THEN

         XM1 = PYMASS(IF1)
         XM2 = PYMASS(IF2)

      ENDIF
      CALL DT_MASHEL(PP,PT,XM1,XM2,P1,P2,IREJ1)
      IF (IREJ1.NE.0) GOTO 9999
      DO 4 I=1,4
         PP(I) = P1(I)
         PT(I) = P2(I)
    4 CONTINUE

c store new partons in DTEVT1
      CALL DT_EVTPUT(IST1,IF1,MO(1,1),MO(2,1),PP(1),PP(2),PP(3),PP(4),
     &                                                       0,0,0)
      CALL DT_EVTPUT(IST2,IF2,MO(1,2),MO(2,2),PT(1),PT(2),PT(3),PT(4),
     &                                                       0,0,0)
      DO 5 K=1,4
         PCH(K) = PP(K)+PT(K)
    5 CONTINUE

c check new chain for lower mass limit
      IF ((IRESCO.EQ.1).OR.(IFRAG(1).EQ.1)) THEN
         AMCH = SQRT(ABS(PCH(4)**2-PCH(1)**2-PCH(2)**2-PCH(3)**2))
         CALL DT_CH2RES(ID(1,1),ID(2,1),ID(1,2),ID(2,2),IDUM,IDUM,
     &               AMCH,AMCHN,3,IREJ1)
         IF (IREJ1.NE.0) THEN
            NHKK = NHKK-2
            GOTO 9999
         ENDIF
      ENDIF

      ICCHAI(2,9) = ICCHAI(2,9)+1
c store new chain in DTEVT1
      KCH = 191
      CALL DT_EVTPUT(KCH,88888,-2,-1,PCH(1),PCH(2),PCH(3),PCH(4),0,0,9)
      IDHKK(IDX(1)) = 22222
      IDHKK(IDX(2)) = 22222
c special treatment for space-time coordinates
      DO 6 K=1,4
         VHKK(K,NHKK) = (VHKK(K,IDX(1))+VHKK(K,IDX(2)))/2.0D0
         WHKK(K,NHKK) = (WHKK(K,IDX(1))+WHKK(K,IDX(2)))/2.0D0
    6 CONTINUE
      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===xsglau=============================================================*
c
CDECK  ID>, DT_XSGLAU
      SUBROUTINE DT_XSGLAU(NA,NB,JJPROJ,XI,Q2I,ECMI,IE,IQ,NIDX)

c***********************************************************************
c Total, elastic, quasi-elastic, inelastic cross sections according to *
c Glauber's approach.                                                  *
c  NA / NB     mass numbers of proj./target nuclei                     *
c  JJPROJ      bamjet-index of projectile (=1 in case of proj.nucleus) *
c  XI,Q2I,ECMI kinematical variables x, Q^2, E_cm                      *
c  IE,IQ       indices of energy and virtuality (the latter for gamma  *
c              projectiles only)                                       *
c  NIDX        index of projectile/target nucleus                      *
c This version dated 17.3.98  is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zmanagerp.h"
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      COMPLEX*16 CZERO,CONE,CTWO
      CHARACTER*12 CFILE
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,THREE=3.0D0,
     &           ONETHI=ONE/THREE,TINY25=1.0D-25)
      PARAMETER (TWOPI  = 6.283185307179586454D+00,
     &           PI     = TWOPI/TWO,
     &           GEV2MB = 0.38938D0,
     &           GEV2FM = 0.1972D0,
     &           ALPHEM = ONE/137.0D0,
c proton mass
     &           AMP    = 0.938D0,
     &           AMP2   = AMP**2,
c approx. nucleon radius
     &           RNUCLE = 1.12D0)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)

c parameters for hA-diffraction
      COMMON /DTDIHA/ DIBETA,DIALPH


      COMPLEX*16 PP11(MAXNCL),PP12(MAXNCL),PP21(MAXNCL),PP22(MAXNCL),
     &           OMPP11,OMPP12,OMPP21,OMPP22,
     &           DIPP11,DIPP12,DIPP21,DIPP22,AVDIPP,
     &           PPTMP1,PPTMP2
      COMPLEX*16 C,CA,CI
      DIMENSION COOP1(3,MAXNCL),COOT1(3,MAXNCL),
     &          COOP2(3,MAXNCL),COOT2(3,MAXNCL),
     &          BPROD(KSITEB)

      PARAMETER (NPOINT=16)
      DIMENSION ABSZX(NPOINT),WEIGHT(NPOINT)

      LOGICAL LFIRST,LOPEN
      DATA LFIRST,LOPEN /.TRUE.,.FALSE./

      NTARG = ABS(NIDX)
c for quasi-elastic neutrino scattering set projectile to proton
c it should not have an effect since the whole Glauber-formalism is
c not needed for these interactions..
      IF (MCGENE.EQ.4) THEN
         IJPROJ = 1
      ELSE
         IJPROJ = JJPROJ
      ENDIF


      IF ((ABS(IOGLB).EQ.1).AND.(.NOT.LOPEN)) THEN
         I = INDEX(CGLB,' ')
cc &&&&&&&&&c         
         CFILE= ' '
ccc &&&&&&
         IF (I.EQ.0) THEN
            CFILE = CGLB//'.GLB'
ccc        &&&&&&&&& kk
ccc            OPEN(LLOOK,FILE=CGLB//'.GLB',STATUS='UNKNOWN')
            call cdpmOpen(LLOOK, CFILE)
ccc
         ELSEIF (I.GT.1) THEN
            CFILE = CGLB(1:I-1)//'.GLB'
ccc         &&&&&&&&&&& KK
ccc          OPEN(LLOOK,FILE=CGLB(1:I-1)//'.GLB',STATUS='UNKNOWN')
            call cdpmOpen(LLOOK, CFILE)
ccc
         ELSE
            STOP 'XSGLAU 1'
         ENDIF
         LOPEN = .TRUE.
      ENDIF

      CZERO  = DCMPLX(ZERO,ZERO)
      CONE   = DCMPLX(ONE,ZERO)
      CTWO   = DCMPLX(TWO,ZERO)
      NEBINI = IE
      NQBINI = IQ

c re-define kinematics
      S  = ECMI**2
      Q2 = Q2I
      X  = XI
c  g(Q2=0)-A, h-A, A-A scattering
      IF ((X.LE.ZERO).AND.(Q2.LE.ZERO).AND.(S.GT.ZERO)) THEN
         Q2 = 0.0001D0
         X  = Q2/(S+Q2-AMP2)
c  g(Q2>0)-A scattering
      ELSEIF ((X.LE.ZERO).AND.(Q2.GT.ZERO).AND.(S.GT.ZERO)) THEN
         X  = Q2/(S+Q2-AMP2)
      ELSEIF ((X.GT.ZERO).AND.(Q2.LE.ZERO).AND.(S.GT.ZERO)) THEN
         Q2 = (S-AMP2)*X/(ONE-X)
      ELSEIF ((X.GT.ZERO).AND.(Q2.GT.ZERO)) THEN
         S  = Q2*(ONE-X)/X+AMP2
      ELSE
         WRITE(ErrorOut,*) 'XSGLAU: inconsistent input ',S,Q2,X
         STOP
      ENDIF
      ECMNN(IE) = SQRT(S)
      Q2G(IQ)   = Q2
      XNU = (S+Q2-AMP2)/(TWO*AMP)

c parameters determining statistics in evaluating Glauber-xsection
      NSTATB = JSTATB
      NSITEB = JBINSB
      IF (NSITEB.GT.KSITEB) NSITEB = KSITEB

c set up interaction geometry (common /DTGLAM/)
c  projectile/target radii
      RPRNCL = DT_RNCLUS(NA)
      RTANCL = DT_RNCLUS(NB)
      IF (IJPROJ.EQ.7) THEN
         RASH(1) = ZERO
         RBSH(NTARG) = RTANCL
         BMAX(NTARG) = 2.0D0*(RASH(1)+RBSH(NTARG))
      ELSE
         IF (NIDX.LE.-1) THEN
            RASH(1)     = RPRNCL
            RBSH(NTARG) = RTANCL
            BMAX(NTARG) = 2.0D0*(RASH(1)+RBSH(NTARG))
         ELSE
            RASH(NTARG) = RPRNCL
            RBSH(1)     = RTANCL
            BMAX(NTARG) = 2.0D0*(RASH(NTARG)+RBSH(1))
         ENDIF
      ENDIF
c  maximum impact-parameter
      BSTEP(NTARG)= BMAX(NTARG)/DBLE(NSITEB-1)

c slope, rho ( Re(f(0))/Im(f(0)) )
      IF ((IJPROJ.LE.12).AND.(IJPROJ.NE.7)) THEN
         IF (MCGENE.EQ.2) THEN
            ZERO1 = ZERO
            CALL DT_PHOXS(IJPROJ,1,ECMNN(IE),ZERO1,SDUM1,SDUM2,SDUM3,
     &                                                   BSLOPE,0)
         ELSE
            BSLOPE = 8.5D0*(1.0D0+0.065D0*LOG(S))
         ENDIF
         IF (ECMNN(IE).LE.3.0D0) THEN
            ROSH = -0.43D0
         ELSEIF ((ECMNN(IE).GT.3.0D0).AND.(ECMNN(IE).LE.50.D0)) THEN
            ROSH = -0.63D0+0.175D0*LOG(ECMNN(IE))
         ELSEIF (ECMNN(IE).GT.50.0D0) THEN
            ROSH = 0.1D0
         ENDIF
      ELSEIF (IJPROJ.EQ.7) THEN
         ROSH = 0.1D0
      ELSE
         BSLOPE = 6.0D0*(1.0D0+0.065D0*LOG(S))
         ROSH   = 0.01D0
      ENDIF

c projectile-nucleon xsection (in fm)
      IF (IJPROJ.EQ.7) THEN
         SIGSH = DT_SIGVP(X,Q2)/10.0D0
      ELSE
         ELAB  = (S-AAM(IJPROJ)**2-AMP2)/(TWO*AMP)
         PLAB  = SQRT( (ELAB-AAM(IJPROJ))*(ELAB+AAM(IJPROJ)) )
C        SIGSH = DT_SHNTOT(IJPROJ,1,ZERO,PLAB)/10.0D0
         DUMZER = ZERO
         CALL DT_XSHN(IJPROJ,1,PLAB,DUMZER,SIGSH,SIGEL)
         SIGSH = SIGSH/10.0D0
      ENDIF

c parameters for projectile diffraction (hA scattering only)
      IF ((MCGENE.EQ.2).AND.(NA.EQ.1).AND.(NB.GT.1).AND.(IJPROJ.NE.7)
     &                               .AND.(DIBETA.GE.ZERO)) THEN
         ZERO1 = ZERO
         CALL DT_PHOXS(IJPROJ,1,ECMNN(IE),ZERO1,STOT,SDUM2,SDIF1,BDUM,0)
C        DIBETA = SDIF1/STOT
         DIBETA = 0.2D0
         DIGAMM = SQRT(DIALPH**2+DIBETA**2)
         IF (DIBETA.LE.ZERO) THEN
            ALPGAM = ONE
         ELSE
            ALPGAM = DIALPH/DIGAMM
         ENDIF
         FACDI1 = ONE-ALPGAM
         FACDI2 = ONE+ALPGAM
         FACDI  = SQRT(FACDI1*FACDI2)
         WRITE(ErrorOut,
     * *)'DIBETA,DIALPH,DIGAMM: ',DIBETA,DIALPH,DIGAMM
      ELSE
         DIBETA = -1.0D0
         DIALPH = ZERO
         DIGAMM = ZERO
         FACDI1 = ZERO
         FACDI2 = 2.0D0
         FACDI  = ZERO
      ENDIF

c initializations
      DO 10 I=1,NSITEB
         BSITE( 0,IQ,NTARG,I) = ZERO
         BSITE(IE,IQ,NTARG,I) = ZERO
         BPROD(I) = ZERO
   10 CONTINUE
      STOT  = ZERO
      STOT2 = ZERO
      SELA  = ZERO
      SELA2 = ZERO
      SQEP  = ZERO
      SQEP2 = ZERO
      SQET  = ZERO
      SQET2 = ZERO
      SQE2  = ZERO
      SQE22 = ZERO
      SPRO  = ZERO
      SPRO2 = ZERO
      SDEL  = ZERO
      SDEL2 = ZERO
      SDQE  = ZERO
      SDQE2 = ZERO
      FACN   = ONE/DBLE(NSTATB)

      IPNT = 0
      RPNT = ZERO

c  initialize Gauss-integration for photon-proj.
      JPOINT = 1
      IF (IJPROJ.EQ.7) THEN
         IF (INTRGE(1).EQ.1) THEN
            AMLO2 = (3.0D0*AAM(13))**2
         ELSEIF (INTRGE(1).EQ.2) THEN
            AMLO2 = AAM(33)**2
         ELSE
            AMLO2 = AAM(96)**2
         ENDIF
         IF (INTRGE(2).EQ.1) THEN
            AMHI2 = S/TWO
         ELSEIF (INTRGE(2).EQ.2) THEN
            AMHI2 = S/4.0D0
         ELSE
            AMHI2 = S
         ENDIF
         AMHI20 = (ECMNN(IE)-AMP)**2
         IF (AMHI2.GE.AMHI20) AMHI2 = AMHI20
         XAMLO = LOG( AMLO2+Q2 )
         XAMHI = LOG( AMHI2+Q2 )
c*PHOJET105a
C        CALL GSET(XAMLO,XAMHI,NPOINT,ABSZX,WEIGHT)
c*PHOJET112

         CALL PHO_GAUSET(XAMLO,XAMHI,NPOINT,ABSZX,WEIGHT)

c*
         JPOINT = NPOINT
c ratio direct/total photon-nucleon xsection
         CALL DT_POILIK(NB,NTARG,ECMNN(IE),Q2,IPNT,RPNT,1)
      ENDIF

c read pre-initialized profile-function from file
      IF (IOGLB.EQ.1) THEN
         READ(LLOOK,'(5I10,E15.5)') KJPROJ,IA,IB,ISTATB,ISITEB,DUM
         IF ((IA.NE.NA).OR.(IB.NE.NB)) THEN
            WRITE(ErrorOut,1000) CFILE,IA,IB,ISTATB,ISITEB,
     &                             NA,NB,NSTATB,NSITEB
 1000       FORMAT(' XSGLAU: INCONSISTENT INPUT DATA IN FILE ',A12,/,
     &             ' (IA,IB,ISTATB,ISITEB) ',4I10,/,
     &             ' (NA,NB,NSTATB,NSITEB) ',4I10)
            STOP
         ENDIF
         IF (LFIRST) WRITE(ErrorOut,1001) CFILE
 1001    FORMAT(/,' XSGLAU: IMPACT PARAMETER DISTRIBUTION READ FROM ',
     &          'FILE ',A12,/)
         READ(LLOOK,'(6E12.5)') XSTOT(IE,IQ,NTARG),XSELA(IE,IQ,NTARG),
     &                          XSQEP(IE,IQ,NTARG),XSQET(IE,IQ,NTARG),
     &                          XSQE2(IE,IQ,NTARG),XSPRO(IE,IQ,NTARG)
         READ(LLOOK,'(6E12.5)') XETOT(IE,IQ,NTARG),XEELA(IE,IQ,NTARG),
     &                          XEQEP(IE,IQ,NTARG),XEQET(IE,IQ,NTARG),
     &                          XEQE2(IE,IQ,NTARG),XEPRO(IE,IQ,NTARG)
         NLINES = INT(DBLE(NSITEB)/7.0D0)
         IF (NLINES.GT.0) THEN
            DO 21 I=1,NLINES
               ISTART = 7*I-6
               READ(LLOOK,'(7E11.4)')
     &            (BSITE(IE,IQ,NTARG,J),J=ISTART,ISTART+6)
   21       CONTINUE
         ENDIF
         ISTART = 7*NLINES+1
         IF (ISTART.LE.NSITEB) THEN
            READ(LLOOK,'(7E11.4)')
     &         (BSITE(IE,IQ,NTARG,J),J=ISTART,NSITEB)
         ENDIF
         LFIRST = .FALSE.
         GOTO 100
c variable projectile/target/energy runs:
c read pre-initialized profile-functions from file
      ELSEIF (IOGLB.EQ.100) THEN
         CALL DT_GLBSET(IJPROJ,IINA,IINB,RRELAB,0)
         GOTO 100
      ENDIF

c cross sections averaged over NSTATB nucleon configurations
      DO 11 IS=1,NSTATB
C        IF ((NA.EQ.207).AND.(NB.EQ.207)) WRITE(LOUT,*) 'conf. ',IS
         STOTN = ZERO
         SELAN = ZERO
         SQEPN = ZERO
         SQETN = ZERO
         SQE2N = ZERO
         SPRON = ZERO
         SDELN = ZERO
         SDQEN = ZERO

         IF (NIDX.LE.-1) THEN
            CALL DT_CONUCL(COOP1,NA,RASH(1),0)
            CALL DT_CONUCL(COOT1,NB,RBSH(NTARG),1)
            IF ((.NOT.LPROD).OR.(IJPROJ.EQ.7)) THEN
               CALL DT_CONUCL(COOP2,NA,RASH(1),0)
               CALL DT_CONUCL(COOT2,NB,RBSH(NTARG),1)
            ENDIF
         ELSE
            CALL DT_CONUCL(COOP1,NA,RASH(NTARG),0)
            CALL DT_CONUCL(COOT1,NB,RBSH(1),1)
            IF ((.NOT.LPROD).OR.(IJPROJ.EQ.7)) THEN
               CALL DT_CONUCL(COOP2,NA,RASH(NTARG),0)
               CALL DT_CONUCL(COOT2,NB,RBSH(1),1)
            ENDIF
         ENDIF

c  integration over impact parameter B
         DO 12 IB=1,NSITEB-1
            STOTB = ZERO
            SELAB = ZERO
            SQEPB = ZERO
            SQETB = ZERO
            SQE2B = ZERO
            SPROB = ZERO
            SDIR  = ZERO
            SDELB = ZERO
            SDQEB = ZERO
            B     = DBLE(IB)*BSTEP(NTARG)
            FACB  = 10.0D0*TWOPI*B*BSTEP(NTARG)

c   integration over M_V^2 for photon-proj.
            DO 14 IM=1,JPOINT
               PP11(1) = CONE
               PP12(1) = CONE
               PP21(1) = CONE
               PP22(1) = CONE
               IF (IJPROJ.EQ.7) THEN
                  DO 13 K=2,NB
                     PP11(K) = CONE
                     PP12(K) = CONE
                     PP21(K) = CONE
                     PP22(K) = CONE
   13             CONTINUE
               ENDIF
               SHI  = ZERO
               FACM = ONE
               DCOH = 1.0D10

               IF (IJPROJ.EQ.7) THEN
                  AMV2 = EXP(ABSZX(IM))-Q2
                  AMV  = SQRT(AMV2)
                  IF (AMV2.LT.16.0D0) THEN
                     R = TWO
                  ELSEIF ((AMV2.GE.16.0D0).AND.(AMV2.LT.121.0D0)) THEN
                     R = 10.0D0/3.0D0
                  ELSE
                     R = 11.0D0/3.0D0
                  ENDIF
c    define M_V dependent properties of nucleon scattering amplitude
c     V_M-nucleon xsection
                  SIGMVD = RPNT*SIGSH/(AMV2+Q2+RL2)*10.0D0
                  SIGMV  = (ONE-RPNT)*SIGSH/(AMV2+Q2+RL2)
c     slope-parametrisation a la Kaidalov
                  BSLOPE = 2.0D0*(2.0D0+AAM(32)**2/(AMV2+Q2)
     &                           +0.25D0*LOG(S/(AMV2+Q2)))
c    coherence length
                  IF (ISHAD(3).EQ.1) DCOH = TWO*XNU/(AMV2+Q2)*GEV2FM
c    integration weight factor
                  FACM = ALPHEM/(3.0D0*PI*(ONE-X))*
     &                  R*AMV2/(AMV2+Q2)*(ONE+EPSPOL*Q2/AMV2)*WEIGHT(IM)
               ENDIF
               GSH = 10.0D0/(TWO*BSLOPE*GEV2MB)
               GAM = GSH
               IF (IJPROJ.EQ.7) THEN
                  RCA = GAM*SIGMV/TWOPI
               ELSE
                  RCA = GAM*SIGSH/TWOPI
               ENDIF
               FCA = -ROSH*RCA
               CA  = DCMPLX(RCA,FCA)
               CI  = CONE

               DO 15 INA=1,NA
                  KK1  = 1
                  INT1 = 1
                  KK2  = 1
                  INT2 = 1
                  DO 16 INB=1,NB
c    photon-projectile: check for supression by coherence length
                     IF (IJPROJ.EQ.7) THEN
                        IF (ABS(COOT1(3,INB)-COOT1(3,KK1)).GT.DCOH)THEN
                           KK1  = INB
                           INT1 = INT1+1
                        ENDIF
                        IF (ABS(COOT2(3,INB)-COOT2(3,KK2)).GT.DCOH)THEN
                           KK2  = INB
                           INT2 = INT2+1
                        ENDIF
                     ENDIF

                     X11 = B+COOT1(1,INB)-COOP1(1,INA)
                     Y11 =   COOT1(2,INB)-COOP1(2,INA)
                     XY11 = GAM*(X11*X11+Y11*Y11)
                     IF (XY11.LE.15.0D0) THEN
                        C = CONE-CA*EXP(-XY11)
                        AR = DBLE(PP11(INT1))
                        AI = DIMAG(PP11(INT1))
                        IF (ABS(AR).LT.TINY25) AR = ZERO
                        IF (ABS(AI).LT.TINY25) AI = ZERO
                        PP11(INT1) = DCMPLX(AR,AI)
                        PP11(INT1) = PP11(INT1)*C
                        AR  = DBLE(C)
                        AI  = DIMAG(C)
                        SHI = SHI+LOG(AR*AR+AI*AI)
                     ENDIF
                     IF ((.NOT.LPROD).OR.(IJPROJ.EQ.7)) THEN
                        X12 = B+COOT2(1,INB)-COOP1(1,INA)
                        Y12 =   COOT2(2,INB)-COOP1(2,INA)
                        XY12 = GAM*(X12*X12+Y12*Y12)
                        IF (XY12.LE.15.0D0) THEN
                           C = CONE-CA*EXP(-XY12)
                           AR = DBLE(PP12(INT2))
                           AI = DIMAG(PP12(INT2))
                           IF (ABS(AR).LT.TINY25) AR = ZERO
                           IF (ABS(AI).LT.TINY25) AI = ZERO
                           PP12(INT2) = DCMPLX(AR,AI)
                           PP12(INT2) = PP12(INT2)*C
                        ENDIF
                        X21 = B+COOT1(1,INB)-COOP2(1,INA)
                        Y21 =   COOT1(2,INB)-COOP2(2,INA)
                        XY21 = GAM*(X21*X21+Y21*Y21)
                        IF (XY21.LE.15.0D0) THEN
                           C = CONE-CA*EXP(-XY21)
                           AR = DBLE(PP21(INT1))
                           AI = DIMAG(PP21(INT1))
                           IF (ABS(AR).LT.TINY25) AR = ZERO
                           IF (ABS(AI).LT.TINY25) AI = ZERO
                           PP21(INT1) = DCMPLX(AR,AI)
                           PP21(INT1) = PP21(INT1)*C
                        ENDIF
                        X22 = B+COOT2(1,INB)-COOP2(1,INA)
                        Y22 =   COOT2(2,INB)-COOP2(2,INA)
                        XY22 = GAM*(X22*X22+Y22*Y22)
                        IF (XY22.LE.15.0D0) THEN
                           C = CONE-CA*EXP(-XY22)
                           AR = DBLE(PP22(INT2))
                           AI = DIMAG(PP22(INT2))
                           IF (ABS(AR).LT.TINY25) AR = ZERO
                           IF (ABS(AI).LT.TINY25) AI = ZERO
                           PP22(INT2) = DCMPLX(AR,AI)
                           PP22(INT2) = PP22(INT2)*C
                        ENDIF
                     ENDIF
   16             CONTINUE
   15          CONTINUE

               OMPP11 = CZERO
               OMPP21 = CZERO
               DIPP11 = CZERO
               DIPP21 = CZERO
               DO 17 K=1,INT1
                  IF (PP11(K).EQ.CZERO) THEN
                     PPTMP1 = CZERO
                     PPTMP2 = CZERO
                  ELSE
                     PPTMP1 = PP11(K)**(ONE-DIALPH-DIGAMM)
                     PPTMP2 = PP11(K)**(ONE-DIALPH+DIGAMM)
                  ENDIF
                  AVDIPP = 0.5D0*
     &                  ( FACDI1*(CONE-PPTMP1)+FACDI2*(CONE-PPTMP2) )
                  OMPP11 = OMPP11+AVDIPP
C                 OMPP11 = OMPP11+(CONE-PP11(K))
                  AVDIPP = 0.5D0*FACDI*( PPTMP1-PPTMP2 )
                  DIPP11 = DIPP11+AVDIPP
                  IF (PP21(K).EQ.CZERO) THEN
                     PPTMP1 = CZERO
                     PPTMP2 = CZERO
                  ELSE
                     PPTMP1 = PP21(K)**(ONE-DIALPH-DIGAMM)
                     PPTMP2 = PP21(K)**(ONE-DIALPH+DIGAMM)
                  ENDIF
                  AVDIPP = 0.5D0*
     &                  ( FACDI1*(CONE-PPTMP1)+FACDI2*(CONE-PPTMP2) )
                  OMPP21 = OMPP21+AVDIPP
C                 OMPP21 = OMPP21+(CONE-PP21(K))
                  AVDIPP = 0.5D0*FACDI*( PPTMP1-PPTMP2 )
                  DIPP21 = DIPP21+AVDIPP
   17          CONTINUE
               OMPP12 = CZERO
               OMPP22 = CZERO
               DIPP12 = CZERO
               DIPP22 = CZERO
               DO 18 K=1,INT2
                  IF (PP12(K).EQ.CZERO) THEN
                     PPTMP1 = CZERO
                     PPTMP2 = CZERO
                  ELSE
                     PPTMP1 = PP12(K)**(ONE-DIALPH-DIGAMM)
                     PPTMP2 = PP12(K)**(ONE-DIALPH+DIGAMM)
                  ENDIF
                  AVDIPP = 0.5D0*
     &                  ( FACDI1*(CONE-PPTMP1)+FACDI2*(CONE-PPTMP2) )
                  OMPP12 = OMPP12+AVDIPP
C                 OMPP12 = OMPP12+(CONE-PP12(K))
                  AVDIPP = 0.5D0*FACDI*( PPTMP1-PPTMP2 )
                  DIPP12 = DIPP12+AVDIPP
                  IF (PP22(K).EQ.CZERO) THEN
                     PPTMP1 = CZERO
                     PPTMP2 = CZERO
                  ELSE
                     PPTMP1 = PP22(K)**(ONE-DIALPH-DIGAMM)
                     PPTMP2 = PP22(K)**(ONE-DIALPH+DIGAMM)
                  ENDIF
                  AVDIPP = 0.5D0*
     &                  ( FACDI1*(CONE-PPTMP1)+FACDI2*(CONE-PPTMP2) )
                  OMPP22 = OMPP22+AVDIPP
C                 OMPP22 = OMPP22+(CONE-PP22(K))
                  AVDIPP = 0.5D0*FACDI*( PPTMP1-PPTMP2 )
                  DIPP22 = DIPP22+AVDIPP
   18          CONTINUE

               SPROM = ONE-EXP(SHI)
               SPROB = SPROB+FACM*SPROM
               IF ((.NOT.LPROD).OR.(IJPROJ.EQ.7)) THEN
                  STOTM = DBLE(OMPP11+OMPP22)
                  SELAM = DBLE(OMPP11*DCONJG(OMPP22))
                  SQEPM = DBLE(OMPP11*DCONJG(OMPP21))-SELAM
                  SQETM = DBLE(OMPP11*DCONJG(OMPP12))-SELAM
                  SQE2M = DBLE(OMPP11*DCONJG(OMPP11))-SELAM-SQEPM-SQETM
                  SDELM = DBLE(DIPP11*DCONJG(DIPP22))
                  SDQEM = DBLE(DIPP11*DCONJG(DIPP21))-SDELM
                  STOTB = STOTB+FACM*STOTM
                  SELAB = SELAB+FACM*SELAM
                  SDELB = SDELB+FACM*SDELM
                  IF (NB.GT.1) THEN
                     SQEPB = SQEPB+FACM*SQEPM
                     SDQEB = SDQEB+FACM*SDQEM
                  ENDIF
                  IF (NA.GT.1) SQETB = SQETB+FACM*SQETM
                  IF ((NA.GT.1).AND.(NB.GT.1)) SQE2B = SQE2B+FACM*SQE2M
                  IF (IJPROJ.EQ.7) SDIR = SDIR+FACM*SIGMVD
               ENDIF

   14       CONTINUE

            STOTN = STOTN+FACB*STOTB
            SELAN = SELAN+FACB*SELAB
            SQEPN = SQEPN+FACB*SQEPB
            SQETN = SQETN+FACB*SQETB
            SQE2N = SQE2N+FACB*SQE2B
            SPRON = SPRON+FACB*SPROB
            SDELN = SDELN+FACB*SDELB
            SDQEN = SDQEN+FACB*SDQEB

            IF (IJPROJ.EQ.7) THEN
               BPROD(IB+1)= BPROD(IB+1)+FACN*FACB*(STOTB-SELAB-SQEPB)
            ELSE
               IF (DIBETA.GT.ZERO) THEN
                  BPROD(IB+1)= BPROD(IB+1)
     &                        +FACN*FACB*(STOTB-SELAB-SQEPB-SQETB-SQE2B)
               ELSE
                  BPROD(IB+1)= BPROD(IB+1)+FACN*FACB*SPROB
               ENDIF
            ENDIF

   12    CONTINUE

         STOT  = STOT +FACN*STOTN
         STOT2 = STOT2+FACN*STOTN**2
         SELA  = SELA +FACN*SELAN
         SELA2 = SELA2+FACN*SELAN**2
         SQEP  = SQEP +FACN*SQEPN
         SQEP2 = SQEP2+FACN*SQEPN**2
         SQET  = SQET +FACN*SQETN
         SQET2 = SQET2+FACN*SQETN**2
         SQE2  = SQE2 +FACN*SQE2N
         SQE22 = SQE22+FACN*SQE2N**2
         SPRO  = SPRO +FACN*SPRON
         SPRO2 = SPRO2+FACN*SPRON**2
         SDEL  = SDEL +FACN*SDELN
         SDEL2 = SDEL2+FACN*SDELN**2
         SDQE  = SDQE +FACN*SDQEN
         SDQE2 = SDQE2+FACN*SDQEN**2

   11 CONTINUE

c final cross sections
c 1) total
      XSTOT(IE,IQ,NTARG) = STOT
      IF (IJPROJ.EQ.7)
     &   XSTOT(IE,IQ,NTARG) = XSTOT(IE,IQ,NTARG)+DBLE(NB)*SDIR
c 2) elastic
      XSELA(IE,IQ,NTARG) = SELA
c 3) quasi-el.: A+B-->A+X (excluding 2)
      XSQEP(IE,IQ,NTARG) = SQEP
c 4) quasi-el.: A+B-->X+B (excluding 2)
      XSQET(IE,IQ,NTARG) = SQET
c 5) quasi-el.: A+B-->X (excluding 2-4)
      XSQE2(IE,IQ,NTARG) = SQE2
c 6) production (= STOT-SELA-SQEP-SQET-SQE2!)
      IF (SDEL.GT.ZERO) THEN
         XSPRO(IE,IQ,NTARG) = STOT-SELA-SQEP-SQET-SQE2
      ELSE
         XSPRO(IE,IQ,NTARG) = SPRO
      ENDIF
c 7) projectile diffraction (el. scatt. off target)
      XSDEL(IE,IQ,NTARG) = SDEL
c 8) projectile diffraction (quasi-el. scatt. off target)
      XSDQE(IE,IQ,NTARG) = SDQE
c  stat. errors
      XETOT(IE,IQ,NTARG) = SQRT(ABS(STOT2-STOT**2)/DBLE(NSTATB-1))
      XEELA(IE,IQ,NTARG) = SQRT(ABS(SELA2-SELA**2)/DBLE(NSTATB-1))
      XEQEP(IE,IQ,NTARG) = SQRT(ABS(SQEP2-SQEP**2)/DBLE(NSTATB-1))
      XEQET(IE,IQ,NTARG) = SQRT(ABS(SQET2-SQET**2)/DBLE(NSTATB-1))
      XEQE2(IE,IQ,NTARG) = SQRT(ABS(SQE22-SQE2**2)/DBLE(NSTATB-1))
      XEPRO(IE,IQ,NTARG) = SQRT(ABS(SPRO2-SPRO**2)/DBLE(NSTATB-1))
      XEDEL(IE,IQ,NTARG) = SQRT(ABS(SDEL2-SDEL**2)/DBLE(NSTATB-1))
      XEDQE(IE,IQ,NTARG) = SQRT(ABS(SDQE2-SDQE**2)/DBLE(NSTATB-1))

      IF (IJPROJ.EQ.7) THEN
         BNORM = XSTOT(IE,IQ,NTARG)-XSELA(IE,IQ,NTARG)
     &          -XSQEP(IE,IQ,NTARG)
      ELSE
         BNORM = XSPRO(IE,IQ,NTARG)
      ENDIF
      DO 19 I=2,NSITEB
         BSITE(IE,IQ,NTARG,I) = BPROD(I)/BNORM+BSITE(IE,IQ,NTARG,I-1)
         IF ((IE.EQ.1).AND.(IQ.EQ.1))
     &      BSITE(0,1,NTARG,I) = BPROD(I)/BNORM+BSITE(0,1,NTARG,I-1)
   19 CONTINUE

c write profile function data into file
      IF ((IOGLB.EQ.-1).OR.(IOGLB.EQ.-100)) THEN
         WRITE(LLOOK,'(5I10,1P,E15.5)')
     &      IJPROJ,NA,NB,NSTATB,NSITEB,ECMNN(IE)
         WRITE(LLOOK,'(1P,6E12.5)')
     &      XSTOT(IE,IQ,NTARG),XSELA(IE,IQ,NTARG),XSQEP(IE,IQ,NTARG),
     &      XSQET(IE,IQ,NTARG),XSQE2(IE,IQ,NTARG),XSPRO(IE,IQ,NTARG)
         WRITE(LLOOK,'(1P,6E12.5)')
     &      XETOT(IE,IQ,NTARG),XEELA(IE,IQ,NTARG),XEQEP(IE,IQ,NTARG),
     &      XEQET(IE,IQ,NTARG),XEQE2(IE,IQ,NTARG),XEPRO(IE,IQ,NTARG)
         NLINES = INT(DBLE(NSITEB)/7.0D0)
         IF (NLINES.GT.0) THEN
            DO 20 I=1,NLINES
               ISTART = 7*I-6
               WRITE(LLOOK,'(1P,7E11.4)')
     &            (BSITE(IE,IQ,NTARG,J),J=ISTART,ISTART+6)
   20       CONTINUE
         ENDIF
         ISTART = 7*NLINES+1
         IF (ISTART.LE.NSITEB) THEN
            WRITE(LLOOK,'(1P,7E11.4)')
     &         (BSITE(IE,IQ,NTARG,J),J=ISTART,NSITEB)
         ENDIF
      ENDIF

  100 CONTINUE

C     IF (ABS(IOGLB).EQ.1) CLOSE(LLOOK)

      RETURN
      END
#endif
