c  ***********************************************************
c  *     open a sequential disk file.
c  *     This is intended to open a file that exists already
c  *     for formatted mode. If it doen not
c  *     exist or cannot be opened, return cond =1 
c  ***********************************************************
         subroutine copenf(io, fnin, icon)
c           io: integer. input.  Fortran logical device number
c           fnin: character(*). input. Disk file name to be openend.
c                     if it starts with %_, % is replaced by
c                     hostname. If %_#_, # is also replaced by
c                     the cumulative event # .
c                     The same is true  for the name after /.
c         icon: integer. output. 0--> ok
c                                1--> cannot be opened.
         implicit none
#include "Zreadonly.h"

         character*(*) fnin
         logical opn, ex
         integer io, ios, icon, klena, fornamelist
         character*300 msg
         character*100 fn

         fornamelist = 0
         goto 10
c        ***************
         entry  copenNLf(io, fnin, icon)
c        ***************
         fornamelist = 1
 10      continue
         call cgetfname(fnin, fn)
c                  see if already opened.
             inquire(file=fn(1:klena(fn)), opened=opn, exist=ex)
             if(opn) then
                icon = 0
             elseif(ex) then
#ifdef PCLinux
#define SPECIAL 1
#define DELIM ,delim='apostrophe'
#else
#define SPECIAL 0
#define DELIM 
#endif

#ifdef ACTION_READ
c                     for non-writable file action ='read'
c                      is needed.
                if(fornamelist .eq. SPECIAL) then
                   open(io, file=fn(1:klena(fn)), 
     *            iostat=ios, access='sequential',
     *            form='formatted', action='read' DELIM)
                else
                   open(io, file=fn(1:klena(fn)), 
     *                  iostat=ios, access='sequential',
     *                  form='formatted', action='read')
                endif
#else
                if(fornamelist .eq. SPECIAL) then
                   open(io, file=fn(1:klena(fn)), 
     *              iostat=ios, access='sequential',
     *              form='formatted' DELIM )
                else
                   open(io, file=fn(1:klena(fn)), 
     *                  iostat=ios, access='sequential',
     *                  form='formatted')
                endif
#endif
                 if(ios .eq. 0) then
                    icon = 0
                 else
                     write(msg, *)' file=',fn(1:klena(fn)),
     *               ' exists but cannot be opened'
                     call cerrorMsg(msg, 1)
                     write(msg,*) ' see copnef.f in Manager dir'
                     call cerrorMsg(msg, 1)
                     icon =1
                 endif    
             else
                 write(msg, *) ' file=', fn(1:klena(fn)),' not exist'
                 call cerrorMsg(msg, 1)
                 icon = 1
             endif    
         end
c  ***********************************************************
c  *     open a sequential disk file.
c  *     This is intended to open a file 
c  *     for formatted i/o mode. If it
c  *     cannot be opened, return cond =1 
c  ***********************************************************
         subroutine copenfw(io, fnin, icon)
c      
c           io: integer. input.  Fortran logical device number
c           fnin: character(*). input. Disk file name to be openend.
c         icon: integer. output. 0--> ok
c                                1--> cannot be opened.
         implicit none
#include "Zreadonly.h"

         character*(*) fnin
         logical opn, ex
         integer io, ios, icon, klena, fornamelist
         character*100 msg, fn

         fornamelist = 0
         goto 10

c        *******************
         entry copenNLfw(io, fnin, icon)
c        *******************
         fornamelist = 1
 10      continue

         call cgetfname(fnin, fn)
#ifdef   PCLinux
#define  SPECIAL 1
#define  DELIM ,delim='apostrophe'
#else
#define  SPECIAL 0
#define  DELIM 
#endif

c                  see if already opened.
             inquire(file=fn(1:klena(fn)), opened=opn, exist=ex)
             if(opn) then
                icon = 0
             elseif(ex) then
                if(fornamelist .eq. SPECIAL) then
                   open(io, file=fn(1:klena(fn)), 
     *             iostat=ios, access='sequential',
     *             form='formatted' DELIM )
                else
                   open(io, file=fn(1:klena(fn)), 
     *               iostat=ios, access='sequential',
     *               form='formatted')
                endif

                 if(ios .eq. 0) then
                    icon = 0
                 else
                     write(msg, *)' file=',fn(1:klena(fn)),
     *               ' exists but cannot be opened'
                     call cerrorMsg(msg, 1)
                     write(msg,*) ' see copnef.f in Manager dir'
                     call cerrorMsg(msg, 1)
                     icon =1
                 endif    
             else
                if(fornamelist .eq. SPECIAL) then
                   open(io, file=fn(1:klena(fn)), 
     *              iostat=ios, access='sequential',
     *              form='formatted' DELIM )
                else
                   open(io, file=fn(1:klena(fn)), 
     *               iostat=ios, access='sequential',
     *               form='formatted')
                endif
                if(ios .eq. 0) then
                   icon = 0
                else
                   icon = 3
                endif
             endif    
         end
      subroutine cskiptoEOF(iodev)
      implicit none
      integer iodev

c          skip to the end of previous write
       do while(.true.)
          read(iodev, *, end=100)
       enddo
 100   continue
       end
c  ***********************************************************
c  *     open a sequential disk file.( upgraded verson of
c  *     copenfw:
c  *     This is intended to open a file
c  *     for formatted or unformatted i/o mode.
c  ***********************************************************
         subroutine copenfw2(io, fn,  form, icon)
         implicit none
c
         integer  io ! input.  Fortran logical device number
         character*(*)  fn !  input. Disk file name to be openend.
         integer  form !  input. if 1--> formatted file
                       !            2--> binary file
         integer  icon !. output. 0  file is newly created and  opened
                       !          1  file exists and  opened
                       !          2  file has been already opened
                       !          3  file cannot be opened.
         logical opn, ex
         integer  ios,  klena
         character*11 format

         if(form .eq. 1) then
            format='formatted'
         elseif(form .eq. 2) then
            format='unformatted'
         else
            call cerrorMsg(
     *      'form input to chookopenfw is  invalid',0)
         endif

c                  see if already opened.
         inquire(file=fn(1:klena(fn)), opened=opn, exist=ex)
         if(opn) then
            icon = 2
         elseif(ex) then
            open(io, file=fn(1:klena(fn)),
     *           iostat=ios, access='sequential',
     *           form=format)
            if(ios .eq. 0) then
               icon = 1
            else
               call cerrorMsg(fn, 1)
               call cerrorMsg(
     *         'exists but cannot be opened', 1) 
               icon =3
            endif
         else
            open(io, file=fn(1:klena(fn)),
     *           iostat=ios, access='sequential',
     *           form=format, status='new' )
            if(ios .eq. 0) then
               icon = 0
            else
               icon = 3
            endif
         endif
         end
c           upgraded version of cskiptoEOF
      subroutine cskiptoEOF2(iodev, form)
      implicit none
      integer iodev  ! input  dev. no
      integer form   ! input  1--> ascii file
                     !        2--> binary file

c          skip to the end of previous write
       do while(.true.)
          if(form .eq. 1) then
             read(iodev, *, end=100)
          elseif(form .eq. 2) then
             read(iodev, end=100)
          endif
       enddo
 100      continue
       end

      subroutine cgetfname(fnin,  fn)
      implicit none

      character*(*) fnin  ! input. If it has %_ at the top or
                          ! if it has /%_ somewhere, 
                          ! all % will be replaced by hostname
                          ! If it is  %_#_ at top or it has /%_#_
                          ! somewhere, all of # will be replaced by
                          ! the current cumulative event number.
      character*(*) fn    ! output. 


      integer j, klena, nl

      fn = ' '
      fn = fnin
      nl = klena(fn)
      j = 1
      if( fn(1:2) .eq. '%_') then
         call creplst( fn, 1 )
      endif
      do while( index(fn, '/%_') .gt. 0)
         j = index(fn, '/%_') + 1
         call creplst( fn, j)
      enddo
      end
      subroutine creplst( fn, j )
      implicit none
      character*(*) fn   ! input.  must be < 256
      integer j          ! input.  fn(j:j+1) has  '%_'

      integer num, cumnum, klena, leng, leng2
      character*10  cnum
      character*64 host   !  sometimes, the complete name may be obtained
                          !  so it must be long. 

      character*256  fnt

      fnt= ' '
      fnt = fn(j:klena(fn))
      if( fnt(1:2) .eq. '%_'  .and. 
     *       fnt(3:4) .eq. '#_' ) then 
         call cgetHost(leng, host)
         call cqEventNo(num,  cumnum)
         cnum = ' '
         write(cnum, *) cumnum
         call kseblk(cnum, '{', leng2)
         fnt = 
     *        host(1:leng)//'_'//cnum(1:leng2)//
     *        '_'//fn(j+4:klena(fn))
      elseif(fnt(1:2) .eq. '%_') then
         call cgetHost(leng, host)
         fnt = host(1:leng)//fn(j+1:klena(fn))
      endif
      if(j .gt. 1) then
         fn = fn(1:j-1)//fnt
      else
         fn = fnt
      endif
      end
c      **************
      subroutine cgetHost(leng, hostn)
      integer  leng       ! output
      character*(*) hostn ! output

      character*1 NULL
      integer  kgetenv

      NULL = char(0)
      leng = kgetenv("HOSTNAME"//NULL, hostn)
      if(leng .eq. 0) then
         leng = kgetenv("HOST"//NULL, hostn)
         if(leng .eq. 0) then
            call
     *      cerrorMsg('Env. var. HOST or HOSTNAME not found',0)
         endif
      endif
      end
