c#include  "BlockData/cblkdedx.h"
c#include  "BlockData/cblkElemag.h"
c           test cdedxInAir
c      dedt in  (GeV)/(kg/m2)
c       so it is 1000 MeV/ ((1000g)/ 10000 cm2) = 1.e4 MeV/(g/cm2)
c      implicit none
c
c#include "Zptcl.h"
c#include "Zmass.h"
c#include  "Zcode.h"
c#include "Zelemagp.h"

c      record /ptcl/ aPtcl

c      integer j
c      real*8  rho, dedt,  ek
c
c      
c      Knockon =.false.
c      call cmkptc(kelec, regptcl, -1, aPtcl)
c      do  j=1, 10
c             rho=2.e-3*10.**(-(j-1)/2.)
c             ek = aPtcl.mass*1.00001 - aPtcl.mass
c             do  while (ek .lt. 100.)
c                 aPtcl.fm.p(4) = ek + aPtcl.mass 
c                 call cdedxInAir(aPtcl, rho, dedt)
c                 write(*, *) sngl(ek), sngl(dedt*1.e4)
c                 ek=ek*10.**0.1
c             enddo
c             write(*, *)
c      enddo
c      end
c     ****************************************************************
c     *                                                              *
c     * cdedxInAir: gives -de/dx (GeV/(kg/m**2)) of e+/e- mu, pi, k,
c     *              p etc in air.
c     ****************************************************************
c
c /usage/  call cdedxInAir(ptcl, rhoin, dedt)
c -- input--
c     ptcl:  record /ptcl/
c    rhoin: density of air in kg/m**3
c -- output --
c     dedt; energy loss   GeV/(kg/m**2) 
c
c
c
         subroutine cdedxInAir(aPtcl, rhoin, dedt)
         implicit none

#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zelemagp.h"

         record /ptcl/ aPtcl
         real*8  rhoin, dedt
c
         real*8 erg
         integer charge

c            next is moved to cbeginRun
c         if(first) then
c            call cdedxEleci(RecoilKineMinE, Knockon)
c            first = .false.
c         endif

         erg = aPtcl.fm.p(4)
c
         if(aPtcl.code .eq. kelec) then
            charge = aPtcl.charge
            call cdedxElec(erg, charge, dedt)  ! in GeV/(g/cm2)
            dedt = dedt / 10.                ! to GeV/(kg/m2)
         elseif(erg .gt. aPtcl.mass*3) then
            call cdedxatHE(aPtcl, rhoin, dedt)  ! in GeV/(kg/m2)
         else
            call cdedx2atLE(erg, aPtcl.mass, dedt) ! in GeV/(g/cm2)
            dedt = dedt / 10.                ! in GeV/(kg/m2)
         endif

         end

            

