c     ******************************************************************
c     *                                                                *
c     * csampNEPIntL: samples integraction length for a given
c     *              non e, gamma  particle in a given material air
c     *                                                                *
c     ******************************************************************
cc            From Epicsv7.0. this is not used from Epcis
c
c     *****************************************************************
      subroutine  csampNEPIntL
      implicit none
#include  "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zheavyp.h"
#include  "Zelemagp.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zcmuint.h"
c     **************************************************
c
      real*8 mfp, ek,  xs, et, mass, prob, path

c            
c        m.f.p (kg/m**2) = abn /xsec(mb)
c        parameter (aira=14.5, abogn=6.02e23, abn=aira*1.e28/abogn)
      real*8 abogn, toabn
      parameter (abogn=6.02d23, toabn=1.d28/abogn)
      real*8 collkgram, u,length
      real*8  eps/1.e-8/, smallxs/1.e-10/, largexs/1.e10/
      integer ica, ka, subcode
      logical useInt2
      character*70 msg

      et = TrackBefMove.p.fm.p(4)
      mass = TrackBefMove.p.mass
      ek = max(et - mass, eps)    ! avoid 0 energy.
      ka = TrackBefMove.p.code
      ica = TrackBefMove.p.charge

      call cdecayLeng(TrackBefMove, length)

      if(length .ne. Infty) then
         call csetIntInf(length, .true., 'decay')
      endif

c          collisions
c      useInt2 = IntModel .eq. 'int2' .and. 
c     *  TrackBefMove.p.fm.p(4) .lt. Elund
      useInt2 = ActiveMdl .eq. 'gheisha' .or.
     *          ActiveMdl .eq. 'dpmjet3'
      if(useInt2) then
         if(ka .eq. kneumu .or. ka .eq. kneue) then
            useInt2 = .false.
         elseif(ka .eq. kmuon) then
            useInt2 = .false.    
         elseif(ka .eq. kgnuc) then
            if(ActiveMdl .eq. 'dpmjet3') then
               useInt2 = .false.
            elseif(ica .ge. 2) then
               useInt2 = .false.
            endif
         elseif(ka .ge.  kalfa .and. ka .le. khvymax) then
c          
            useInt2 = .false.
         elseif(ka .eq. komega .or. 
     *        ka  .eq. krho .or. ka .eq. kphi) then
            useInt2 = .false.
         elseif(ka .eq. kddb .or. ka .eq. knnb) then
            useInt2 = .false.
         endif
      endif
      if(useInt2 .and. ActiveMdl .eq. 'dpmjet3' ) then
         useInt2 =
     *     (TrackBefMove.p.fm.p(4) - TrackBefMove.p.mass)
     *        .lt.  5.0 
c                     danger 5.0 is fixed &&&&&&&&&&
      endif

      if(useInt2 .and. ActiveMdl .eq. 'gheisha') then
c                Gheisha should be used for collisions
c                it include elastic scattering;
c                so we use different cross-sections
         call cxsecGheisha(TrackBefMove.p, 
     *        TargetMassN, TargetAtomicN, xs)

         mfp = toabn*TargetMassN/xs ! in kg/m2
c               sample interaction length
         call rndc(u)
         collkgram=-mfp*log(u)
      elseif(useInt2 .and. ActiveMdl .eq. 'dpmjet3') then
c          use total X-section

cccc         call ctotx(TrackBefMove.p, TargetMassN,  xs)
c              borrow gheisha cross-section for total 
         call cxsecGheisha(TrackBefMove.p, 
     *        TargetMassN, TargetAtomicN, xs)

         mfp = toabn*TargetMassN/xs ! in kg/m2
c               sample interaction length
         call rndc(u)

         collkgram=-mfp*log(u)
      else
c         get mean free path for collision
         if(ka .eq. kpion .or. ka .eq. keta) then
            if(ica .ge. 0) then ! pi+, 0. 
               call cpiPlusAXsec(TargetMassN, ek, xs)
            else
               call cpiMinusAXsec(TargetMassN, ek, xs)
            endif
         elseif (ka .eq. kkaon) then
            if(ica .ge. 0) then
               call ckPlusAXsec(TargetMassN, ek, xs)
            else
               call ckMinusAXsec(TargetMassN, ek, xs)
            endif
         elseif (ka .eq. kmuon) then
            xs = smallxs
            if(FromEpics) then
c              muon interaction in Epics is managed within
c              Epics so that we should skip this part

            else
               if(MuPr .ge. 2 .and.
     *              TrackBefMove.p.fm.p(4) .gt. muPrEmin) then

                  call cmuPrsmpP(TrackBefMove.p.fm.p(4), prob, path)
                  collkgram = path * 10. ! kg/m^2
                  call csetIntInf(collkgram, .false., 'mupair')
                  xs =max( prob/toabn*TargetMassN/10., smallxs)
               endif
               if(MuBr .ge. 2 .and. 
     *              TrackBefMove.p.fm.p(4) .gt. muBrEmin) then

                  call cmuBrsmpP(TrackBefMove.p.fm.p(4), prob, path)
                  collkgram = path * 10. ! kg/m^2
                  call csetIntInf(collkgram, .false., 'mubrem')
                  xs =max( prob/toabn*TargetMassN/10., smallxs)
               endif
               if(MuNI .ge. 2 .and. 
     *              TrackBefMove.p.fm.p(4) .gt. muNEmin) then

                  call cmuNsmpP(TrackBefMove.p.fm.p(4), prob, path)
                  collkgram = path * 10. ! kg/m^2
                  call csetIntInf(collkgram, .false., 'munuci')
                  xs =max( prob/toabn*TargetMassN/10., smallxs)
               endif
               if(xs .ne. smallxs) goto 100 !  *********
            endif
         elseif (ka .eq. knuc) then
            if(TrackBefMove.p.subcode .eq. antip) then
               if(ek .ne. eps) then
                  call cpbarAXsec(TargetMassN, ek, xs)
               else
                  xs = largexs
               endif
            else
               call cprotonAXsec(TargetMassN, ek, xs)
            endif    
         elseif(ka .eq. kgnuc ) then
c           heavy xs
            subcode =TrackBefMove.p.subcode
            call cAAXsec(subcode, TargetMassN, ek, xs)
         elseif(ka .ge. kalfa .and. ka .le. khvymax) then    
c           heavy xs ; will not come here; obsolete
            call cAAXsec(Code2massN(ka), TargetMassN, ek, xs)
         elseif(ka .eq. kneumu) then
            xs= smallxs
         elseif(ka .eq. kneue) then
            xs= smallxs
         elseif(ka .eq. kdmes) then
C            d meson; use mean free path for kaon
            call ckPlusAXsec(TargetMassN, ek, xs)
         elseif (ka .eq. knnb) then
c             nn~ instant decay
            xs= smallxs
         elseif (ka .eq. kddb) then
c           dd~ instant decay
            xs= smallxs
         elseif (ka .eq. kgzai .or. ka .eq. ksigma .or.
     *     ka .eq. kbomega    ) then
c               use proton x-section            
            call cprotonAXsec(TargetMassN, ek, xs)
         elseif ( ka .eq.  klambda .or. ka .eq. klambdac) then
c               use proton x-section            
            call cprotonAXsec(TargetMassN, ek, xs)
         else
            write(msg,*) ' csampNEPIntL:  strange ptcl: ka=',ka
            call cerrorMsg(msg, 0)
         endif
         if(xs .eq. smallxs) then
            collkgram = Infty
         elseif( xs .eq. largexs) then
            collkgram = 0.
         else
            mfp = toabn*TargetMassN/xs ! in kg/m2
c             sample interaction length
            call rndc(u)
            collkgram=-mfp*log(u)
         endif
      endif
      call csetIntInf(collkgram, .false., 'coll')
c          knockon
 100  continue
      if( FromEpics) then
c           knockon is treated in epics specially.
      else
         if(TrackBefMove.p.charge .ne. 0) then

            call cKnockp(TrackBefMove.p, prob, path) ! path in r.l
            if(prob .gt. 0.d0) then
               call csetIntInf(path *X0, .false., 'knock')
            else
               call csetIntInf(Infty,   .false., 'knock')
            endif
         endif
      endif
      end














