cc       to test cgetRotMat3, cinvRotMat3, cmultRotMat3, capplyRot3
cc           cgetRotMat3: get rotation matrix of x/y/z axis
cc           cinvRotMat3: invert a rotation matrix
cc           cmultRotMat3:  multiply two rotation matrix
cc           capplyRot3: applay a rotation on a 3d vector.
cc
c         implicit none
c         real*8 rm(3, 3),  rmn(3,3), rmm(3, 3)
c         real*8  Torad, vn(3), v(3)
c         integer i, j, m
c         v(1) =1.
c         v(2) =0.
c         v(3) = 1.
c
c         do i=1, 3
c            do j=1, 3
c                rm(i, j)=1.d30
c                rmn(i, j)=-1.d30
c                rmm(i, j)=1.d15
c            enddo
c         enddo
c         do i=1, 3
c            vn(i)= 1.e50
c         enddo
c         Torad=asin(1.d0)/90.d0
c         m=3
c         call cgetRotMat3(m, 1.d0,  0.d0, rm)
c         write(*,*) rm
c         call cgetRotMat3(m, cos(45.*Torad), -sin(45.*Torad), rm)
c         call cinvRotMat3(rm, rmn)
c         call cgetRotMat3(m,cos(-45.*Torad), -sin(-45.*Torad), rmm)
c         write(*, *) ' rotation matrix around m=', m
c         do i=1, 3
c             write(*,*) (rm(i,j),j=1, 3)
c          enddo
c         write(*,*) "-----inverse of the above--"
c         do i=1, 3
c             write(*,*) (rmn(i,j),j=1, 3)
c          enddo
c         write(*,*) "-----should be the same as above--"
c         do i=1, 3
c             write(*,*) (rmm(i,j),j=1, 3)
c          enddo
c         write(*,*) "-------"
c         call capplyRot3(rm, v, vn)
c         write(*, *) ' v is rotated by rm'
c         write(*,*) vn
c         call cmultRotMat3(rm, rmn, rmm)
c         write(*, *)' unit matrix should be seen'
c         write(*, *) rmm
c         call capplyRot3(rmm, v, vn)
c         write(*, *) " no change from v"
c         write(*,*) vn
c        end
c        **************************************************************
c        *
c        *  cgetRotMat3: make rotation matrix of 3-d coordinate axes.
c        *
c        **************************************************************
c  /usage/  call cgetRotMat3(m, cosa, sina, rm)
c
c    m: input. integer  1--> rotaion of coordinate around x axis
c                       2-->   //                         y
c                       3-->   //                         z
c                     rotation is made anticlock wise (e.g,
c                     if m=3,
c                                  !y    / new.r(1)
c                    $  new.r(2)      !    /
c                        $         !   / *
c                            $     !  /   * ang ( if > 0)
c                                $ ! /     *
c                                   ~~~~~~~~~~~~~~~~~ x
c                         z is directed to the eyes.
c   cosa: input. real*8. cos of  rotation angle.
c   sina: input. //      sin //
c   rm(3,3): output. real*8  rotation matrix.  v'=rm*v is the new coordinate
c                   of a vector v(see capplyRot3)
c
      subroutine cgetRotMat3(m, cosa, sina, rm)
          implicit none
c
          integer m
          real*8 cosa, sina
          real*8 rm(3, 3)
c
          integer i, j, m1, m2
          character*70 msg
c
          if(m .ge. 1 .and. m .le. 3) then
             do i=1, 3
                do j=1, 3
                   rm(i, j)= 0.d0
                enddo
             enddo   
             rm(m, m)=1.d0
             m1=mod(m,3)+1
             m2=mod(m1,3)+1
             rm(m1,m1)=cosa
             rm(m2,m2)=cosa
             rm(m1,m2)=sina
             rm(m2,m1)=-sina
          else
             write(msg, *) ' invalid m=',m,' to cgetRotMat3 '
             call cerrorMsg(msg,0)
          endif
      end
      subroutine cinvRotMat3(rm, rmn)
c             Invert rotation matrix rm and put into rmn.
c             rm should be a roation matrix made by calling
c             cgetRotMat3 (with cosa, sina).  rmn can be made by calling
c             cgetRotMat3 with cosa, -sina, too.  
c             rmn cannot be the same arrays as rm.
c             rmn is nothing but the transposed matrix of rm.
          implicit none
          real*8 rm(3,3), rmn(3,3)
          integer i, j
          do  i=1,3
             do  j=i+1, 3
                rmn(i,j)=rm(j, i)
                rmn(j,i)=rm(i, j)
             enddo
          enddo
          do  i=1, 3
             rmn(i,i)=rm(i, i)
          enddo
       end
       subroutine cmultRotMat3(a, b, c)
c            3-d matrix product c=a*b
c            c cannot be either of a or b.
          implicit none
          real*8 a(3,3), b(3,3), c(3,3)
          integer i, j, k
          real*8 ab
          do  i=1, 3
             do j=1, 3
                ab=0.
                do k=1, 3
                   ab=ab+ a(i,k)*b(k,j)
                enddo
                c(i,j)=ab
             enddo   
          enddo
       end
       subroutine capplyRot3(a, v, vn)
c          3-d transformation matrix a is multiplied by
c          a vector v to obtain a new vector vn.
c          vn can  be v.
c
           implicit none
           real*8 a(3,3), v(3), vn(3)
           
c
           real*8 sum
           integer i, j
c
          do  i=1, 3
             sum=0.
             do  j=1, 3
                 sum=sum + a(i, j)*v(j)
             enddo    
             vn(i)=sum
          enddo
       end
