cc         test cllh2eCent
c      include '../../Tracking/Zcoord.h'
c      record /coord/ a, b
c      a.lat = 35.
c      a.long =138.
c      a.h =0.
c      do while (a.lat .le. 90.001)
c         read(*, *) a.lat, a.long, a.h
c         call cllh2eCent( a, b)
c         write(*,*) b.x, b.y, b.z
c      enddo   
c      end
c          longitude latitude height to earth center rectangular 
c     coordinate  converstion.
c
      subroutine cllh2eCent(llh, xyz)
c       llh:  /coord/ structure. input. containing data in latitude,
c                                       longitude, height.
c       xyz:  /coord/ structue. output. The coordinate system is
c            such that the origin is at  the center of the earth
c            x-axis is directed to (0, 0) latitude and longitude.
c            y-axis is directed to (0, 90) latitude and longitude.
c            z-axsi is directed to the north pole.
c
c           xyz.r(1) is  x coordinate value in m 
c           xyz.r(2) is  y                    
c           xyz.r(3) is  z                    
c    ***  note  ***
c           xyz can be the same as llh.  time component is unchanged
c
      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"
c----      include '../../Tracking/Zcoord.h'
#include  "Zcoord.h"
c----      include 'Zearth.h'
#include  "Zearth.h"
      record /coord/llh,  xyz
      record /coord/ temp
c
      real*8 n
c
      n = Eradius/sqrt(1. -Eecen2 * sin(llh.lat*Torad)**2)
      temp.x = (n + llh.h) *cos(llh.lat*Torad)* cos(llh.long*Torad)
      temp.y = (n + llh.h) *cos(llh.lat*Torad)* sin(llh.long*Torad)
      xyz.r(3)  = (n* Eone_ecen2  + llh.h)*sin(llh.lat * Torad)
      xyz.r(1) = temp.x
      xyz.r(2) = temp.y
      xyz.sys = coord_types(1)
      end
