c
c        c2bdcy, c2bdcp, c2bdc0 and test programs.
c
c     include '../../KKlib/rnd.f'
c     include 'cmkptc.f'
c     include '../../KKlib/kcossn.f'
c     include 'cpxyzp.f'
c     include 'clorep.f'
c     include 'cgetRotMat4.f'
c     include 'clorez.f'
c     include 'cbst1.f'
c     include 'cbst0.f'
c     include 'cibst1.f'
c     include 'cgetlf.f'
c---------------------
c     implicit none
c:       c2bdcy, c2bdcp, c2bdc0.
c     include '../Zptcl.h'
c     include '../Zcode.h'
c     record /ptcl/ p, p1, p2
c     real*8 pabs
c
cc            test c2bdcy
c     call cmkptc(krho, 0, 0,  p)
c     p.fm.p(1)=0.
c     p.fm.p(2)=0.
c     p.fm.p(3)=10.
c     call cpxyzp(p.fm, pabs)
c     p.fm.p(4) = sqrt(p.mass**2 + pabs**2)
c
c     call cmkptc(kpion, 0,  1,  p1)
c     call cmkptc(kpion, 0, -1,  p2)
c     call c2bdcy(p, p1, p2)
c     write(*,*) p1.fm.p(1) + p2.fm.p(1)
c     write(*,*) p1.fm.p(2) + p2.fm.p(2)
c     write(*,*) p1.fm.p(3) + p2.fm.p(3)
c     call cbst1(1, p, p2, p2)
c     call cbst1(2, p, p1, p1)
c     write(*, *) p1.fm.p(3) + p2.fm.p(3)
c     write(*, *) p1.fm.p(4) + p2.fm.p(4), p.mass
c     end
c    ********************************************************
      subroutine c2bdcy(p, p1, p2)
c    ********************************************************
c        two body decay by pure phase space.  
c      Note that in case polarization exists,
c     this should not be used.
c     p: /ptcl/ Input.  particle which decays.
c               4 momentum and mass must be given
c               in a certain system K.
c    p1: /ptcl/ Input/Output. Decay product 1.
c               Mass must be given in input.
c               As output, 4 mementum is given in the
c               system K.  Other attributes are unchanged.
c    p2: /ptcl/ the same as above for 2nd ptcl.
c **** note:    for massless ptcl decay, use c2bdc0, which
c            is faster.
c
      implicit none
c----       include '../Zptcl.h'
#include  "Zptcl.h"
       record /ptcl/ p, p1, p2
       real*8 am, am1, am2, q1, e1, e2, cst, cs, sn, snt
c
        am = p.mass
        am1 = p1.mass
        am2 = p2.mass
        q1=max(  (am**2- (am1+am2)**2)*(am**2-(am1-am2)**2), 0.d0)
        q1=sqrt( q1 )/am/2
        e1=sqrt(q1**2+am1**2)
        if(am1 .eq. am2) then
           e2=e1
        else
           e2=sqrt(q1**2+am2**2)
        endif
        call rndc(cst)
        cst=cst*2-1.d0
        call kcossn(cs, sn)
        snt=sqrt(1.d0 - cst**2)
        p1.fm.p(1) = q1*snt*cs
        p1.fm.p(2) = q1*snt*sn
        p1.fm.p(4) = e1
        p1.fm.p(3) = q1*cst
        p2.fm.p(1) = -p1.fm.p(1)
        p2.fm.p(2) = -p1.fm.p(2)
        p2.fm.p(4) = e2
        p2.fm.p(3) = -p1.fm.p(3)
c         boost p1 into K
        call cibst1(1, p, p1, p1)

c          boost p2 into K
        call cibst1(2, p, p2, p2)
      end
c-----*********************************************
c:        c2bdcp test.
c     implicit none
c     include '../Zptcl.h'
c     include '../Zcode.h'
c     record /ptcl/ p, p1, p2
c     real*8 pabs
c
c     call cmkptc(kpion, 0, 0,  p)
c     p.fm.p(1)=0.
c     p.fm.p(2)=0.
c     p.fm.p(3)=10.
c     call cpxyzp(p.fm, pabs)
c     p.fm.p(4) = sqrt(p.mass**2 + pabs**2)
c
c     call cmkptc(kphoton, 0, 0,  p1)
c     call cmkptc(kphoton, 0, 0,  p2)
c     call c2bdcp(p, p1, 0.5d0, p2)
c     write(*,*) p1.fm.p(1) + p2.fm.p(1)
c     write(*,*) p1.fm.p(2) + p2.fm.p(2)
c     write(*,*) p1.fm.p(3) + p2.fm.p(3)
c       reboost to decay particle system
c     call cbst1(1, p, p2, p2)
c     call cbst1(2, p, p1, p1)
c     write(*, *) p1.fm.p(3) + p2.fm.p(3)
c     write(*, *) p1.fm.p(4) + p2.fm.p(4), p.mass
c     write(*, *) p1.fm.p(3), p2.fm.p(3), p.mass/2
c     end
c     ************************************************ 
      subroutine c2bdcp(p, p1, cst, p2)
c      2body decay when the one particle decay angle is
c     fixed.
c     ************************************************ 
c      p: /ptcl/ input.  a particle which decays. 4momentum
c           must be given in a certain system K.  
c           The mass should be given too.
c      p1:  /ptcl/.input/outut. first particle. mass must be given.
c            as input.
c            as output, 4 momentum is given at K. Others unchaed
c      cst: real*8. input.  cos(of angle to the z axis)
c             of 1st ptcl at the rest system of p
c      p2:  /ptcl/ input/output. 2nd particle. same as 1st ptcl.
c
      implicit none
c----      include '../Zptcl.h'
#include  "Zptcl.h"
      record /ptcl/ p, p1, p2
      real*8 cst
c
      real*8 am, am1, am2, q1, e1, e2, cs, sn, snt
c
      am1 = p1.mass
      am2 = p2.mass
      am = p.mass
      q1=max(  (am**2- (am1+am2)**2)*(am**2-(am1-am2)**2), 0.d0)
      q1=sqrt( q1 )/am/2
      e1=sqrt(q1**2+am1**2)
      if(am1 .eq. am2) then
           e2=e1
      else
           e2=sqrt(q1**2+am2**2)
      endif
      call kcossn(cs, sn)
      snt=sqrt(1.d0-cst**2)
      p1.fm.p(1) = q1*snt*cs
      p1.fm.p(2) = q1*snt*sn
      p1.fm.p(3) = q1*cst
      p1.fm.p(4) = e1
c
      p2.fm.p(1) = -p1.fm.p(1)
      p2.fm.p(2) = -p1.fm.p(2)
      p2.fm.p(3) = -p1.fm.p(3)
      p2.fm.p(4) = e2
c         boost p1 into K
      call cibst1(1, p, p1, p1)

c        boost p2 into K
      call cibst1(2, p, p2, p2)
      end
c-----*********************************************
c     implicit none
c:        c2bdc0 test.
c     include '../Zptcl.h'
c     include '../Zcode.h'
c     record /ptcl/ p, p1, p2
c     real*8 pabs
c
c     call cmkptc(kpion, 0, 0,  p)
c     p.fm.p(1)=0.
c     p.fm.p(2)=0.
c     p.fm.p(3)=10.
c     call cpxyzp(p.fm, pabs)
c     p.fm.p(4) = sqrt(p.mass**2 + pabs**2)
c
c     call cmkptc(kphoton, 0, 0,  p1)
c     call cmkptc(kphoton, 0, 0, p2)
c     call c2bdc0(p, p1, p2)
c     write(*,*) p1.fm.p(1) + p2.fm.p(1)
c     write(*,*) p1.fm.p(2) + p2.fm.p(2)
c     write(*,*) p1.fm.p(3) + p2.fm.p(3)
c     call cbst1(1, p, p2, p2)
c     call cbst1(2, p, p1, p1)
c     write(*, *) p1.fm.p(3) + p2.fm.p(3)
c     write(*, *) p1.fm.p(4) + p2.fm.p(4), p.mass
c     end
c     ************************************************
      subroutine c2bdc0(p, p1, p2)
c           special case for masseless 2 ptcl decay
c           such as pi0-->2g.
c     ************************************************
      implicit none
c----      include '../Zptcl.h'
#include  "Zptcl.h"
      record /ptcl/ p, p1, p2
      real*8 e1, e2, q1, cst, cs, sn, snt
c

      q1=p.mass/2
      e1=q1
      e2=e1
      call rndc(cst)
      cst=cst*2-1.d0
      call kcossn(cs, sn)
      snt=sqrt(1.d0-cst**2)
      p1.fm.p(1) = q1*snt*cs
      p1.fm.p(2) = q1*snt*sn
      p1.fm.p(4) = e1
      p1.fm.p(3) = q1*cst
c
      p2.fm.p(1) = -p1.fm.p(1)
      p2.fm.p(2) = -p1.fm.p(2)
      p2.fm.p(4) = e2
      p2.fm.p(3) = -p1.fm.p(3)
      call cibst1(1, p, p1, p1)
      call cibst1(2, p, p2, p2)
      end








