cc     test ksgamd
c      include 'kgauss.f'
c      include 'kgamma.f'
c      include 'rnd.f'
c--------------------------------
c     implicit none
c     real*8 alfa, am, xm, x
c     integer i
c
c        alfa=15.
c        am=105.
c        xm=alfa/am/(am-alfa)
c        do  i=1, 10000
cc            activate one of the following calls.
cc          call ksgmim(3, 300.d0, x)
cc          call ksgmis(2, 10.d0, x)
cc          call ksgmrm(3.5d0, 100.d0, x)
cc          call ksgmrs(3.5d0,  20.d0, x)
cc          call ksgmrs(0.2d0, 30.d0, x)
cc          call ksgmrs(-0.45d0, 300.d0, x)
cc          call ksgmrs(-0.95d0, 20.d0, x)
cc          call ksgmrm(1.00d0, 2.d0,  x)
c           write(*, *)  sngl(x)
c        enddo  
c      end
c    *****************************************************************
c    * sampling for the gamma distribution: (note power is not s-1)
c    *
c    *  (x/a)**s exp(-x/a)/gamma(s+1)d(x/a).
c    *
c    *     (s>-1.0; mean is a*(s+1)).
c    *
c    * ksgmim: sampling for an integer s with a given mean
c    * ksgmis: sampling for an integer s with a given scale parameter a
c    * ksgmrm: sampling for a real s with a given mean
c    * ksgmrs: sampling for a real s with a given scale parameter a
c    *
c    ****************************************************************
c
c    samples a random variable from gamma distribution, x**(s) exp(-x/a)
c
c   /usage/
c    call ksgmim(n, av, x)
c            n: input. integer>= 0.   s=n.
c           av: input.  real*8> 0.   the average of the distribution
c            x: output. real*8.  sampled random variable.
c
c    call ksgmis(n, a, x)
c            n: input. integer>=0.   s=n
c            a: input. real*8.    a in exp(-x/a)
c                      the mean is given by a*(n+1)
c            x: output. real*8.  sampled random variable.
c
c    call ksgmrm(s, av, x)
c            s: input. real*8 >-1.0
c           av: input. real*8.  >0. the average of the distribution.
c            x: output. real*8. a sampled radonm varible.
c                      if s is close to -1.0, x < 1.d-30 may not
c                      be very accurate.
c
c    call ksgmrs(s, a, x)
c            s: input.  real*8 > -1.
c            a: input.  real*8 > 0. a in exp(-x/a)
c                      the mean is given by a*(s+1)
c            x: output. real*8.  sampled random variable.
c                      if s is  close to -1.0, x < 1.d-30 may not
c                      be very accurate.
c
c         for s=3.5, 1653 msec is needed for calling 50000 times.
c         (by m780 35mips machine)
c
          subroutine ksgmrs(s, a, x)
c           implicit none
            real*8 s,  a, x
c
            real*8 alfa, u, r
            integer n
            logical more
c
              if(s .le. -1.) then
                    write(*,*) ' input value to ksgmrs. s=',
     *              s,' invalid'
                    stop 9999
              elseif(s .lt. 0.) then
                    call ksgamn(s, x)
              else
c                     sample a varible from x**s exp(-x)dx
c                      decompose s=n+alfa,  1.0>alfa>=0.
                    n=s
                    alfa=s-n
                    if(alfa .eq. 0.) then
c                        use integer case
                        call ksgmis(n, 1.d0,x)
                    else
c                        importance sampling with weight function
c                        rho= (1-alfa)*x**n exp(-x)/gamma(n+1) +
c                        alfa*x**(n+1) exp(-x)/gamma(n+2)
c                        =x**n exp(-x)/gamma(n+1) (1-alfa+alfa*x/(n+1))
c                        then,
c                        x**(n+alfa)exp(-x)/rho=
c                        x**alfa/(1-alfa+alfa*x/(n+1))
c                        which has a max value, (n+1)**alfa at x=n+1.
c                        determine if x**n exp(-x) or x**(n+1) exp(-x)
                        more=.true.
                        do 100 while (more)
c                            average trial # is 1.03 with max of 4 (for
c                            s=3.5, 50000 cases).
                            call rndc(u)
                            if(u .le. alfa) then
                                 call ksgmis(n+1,1.d0, x)
                            else
                                 call ksgmis(n, 1.d0, x)
                            endif
c                             rejection func.value
                            r= (x/(n+1))**alfa/(1.-alfa + alfa*x/(n+1))
                            call rndc(u)
                            more=u .gt. r
  100                   continue
                   endif
              endif
              x=a*x
          end
c
          subroutine ksgmrm(s, av, x)
c         implicit none
          real*8 s, av, x
c
          real*8 a
c
             if(s .le. -1.) then
                    write(*,*) ' input value to ksgmrs. s=',
     *              s,' invalid'
                    stop 9999
             endif
             a=av/(s+1.)
             call ksgmrs(s, a, x)
          end
c
          subroutine ksgmis(n, a, x)
c         implicit none
          real*8 a, x
          integer n
c
          real*8 u, ui
          integer i
          logical more
c
             if(n .le. -1) then
                  write(*,*) ' input value to ksgmis. n=',
     *            n,' invalid'
                  stop 9999
             endif
c
             more=.true.
             do 100 while (more)
                 call rndc(u)
                 do 50  i=1, n
                     call rndc(ui)
                     u=u*ui
   50            continue
                 more=u .le. 0.
  100        continue
             x=-a*log(u)
           end
c
           subroutine ksgmim(n, av, x)
c          implicit none
           real*8 av, x
           integer n
c
           real*8 a
c
             if(n .le. -1) then
                  write(*,*) ' input value to ksgmim. n=',n,' invalid'
                  stop 9999
             endif
c
             a=av/(n+1)
             call ksgmis(n, a, x)
           end
c            for   -1.0<s<0.
           subroutine ksgamn(s, x)
c          implicit none
           real*8 s, x
c
c
           real*8 pi/3.14159265/, rt2i/0.70710678/, eps/0.1d0/,
     *           err/1.d-3/,   small/1.d-30/
           real*8 u, r, us, br, kgamma, tmp, xold, acc
           logical more, more2
c
             if(s .ge. -0.5) then
c    importance sampling is completely possible by using weight
c    function of
c    rho=-2s* x**(-1/2)exp(-x)/gamma(1/2)+(2s+1)exp(-x).
c    then, x**s exp(-x)/rho=
c    x**s/( -2s x**(-1/2)/gamma(1/2) + (2s+1)).
c    this takes the
c    maximum, (1/gamma(1/2))**2s=pi**(-s) at x=(1/gamma(1/2))**2=1/pi
c    sampling for exp(-x)/root(x)dx  is done by taking the square of
c    a gaussian random varible with mean 0 and variance 1/root(2).
c
                 more=.true.
                 do 100 while ( more )
                    call rndc(u)
                    if(u .le. (2*s+1.)) then
                        call rndc(u)
                        x=-log(u)
                    else
                        call kgauss(0.d0, rt2i, x)
                        x=x*x
                    endif
c                         rejection function value
                    r=(pi*x)**(s+0.5)/(-2*s + (2*s+1.)*sqrt(pi*x))
                    call rndc(u)
                    more=u .gt. r
  100           continue
             else
c                 complete rejection method not known for me(ptcl data
c                 show some, but seems wrong).
c                 introduce a cut at a small x(=eps).
c                 divide the samling region into 2: x<eps and x> eps
c                 at x>eps
c                  use weight function exp(-x)/root(x)
c                  x**s exp(-x)/rho= x**(s+1/2)
c                at x<eps
c                  solve the usual equation approxmately. for small x,
c                  int(0;x)(x**s exp(-x)/gamma(s+1))=
c                  x**(s+1)/gamma(s+2)(1-(s+1)/(s+2)x+(s+1)/(s+3)/2x**2
c                 then,  the relative area of x< eps
                br=eps**(s+1.)/kgamma(s+2.) * (1.- (s+1.)/(s+2.)*eps
     *             + (s+1.)/(s+3.)/2*eps*eps  )
                call rndc(u)
                if(u .lt. br) then
c                    take value x< eps
                   call rndc(u)
                   us=u**(1./(s+1.))*eps
c                     initial guess at x<eps
                   x=us
                   tmp=
     *             (1.- (s+1.)/(s+2.)*eps+(s+1.)/(s+3)/2*eps*eps)
     *             **(1./(s+1.))
                   more=.true.
                   do 130  while( more )
c                         average trial is < 2
                       xold=x
                       x=us*tmp/
     *                 (1.-(s+1.)/(s+2.)*xold+(s+1.)/(s+3)/2*xold*xold)
     *                 ** (1./(s+1.))
                       if(x .lt. small) then
                          acc=0.
                       else
                          acc=abs(x/xold-1.)
                       endif
                       more=acc .gt. err
  130               continue
                else
                   more=.true.
                   do 200  while ( more )
                       more2=.true.
                       do 150 while ( more2 )
                           call kgauss(0.d0, rt2i, x)
                           x=x*x
                           more2= x .lt. eps
  150                  continue
c                             rejection function value
                       r=(x/eps)**(s+0.5)
                       call rndc(u)
                       more=u .gt. r
  200              continue
               endif
            endif
          end



