       subroutine cifXObsSite(nextwhere)
c         see if MovedTrack crosses an observation depth.
c         or go out of boundry.
c        if to be observed, reset MovedTrack information
      implicit none
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
#include  "Zearth.h"
#include  "Zcode.h"
c     
      integer nextwhere  ! output next where. to be used when ptcl
                         !  crosses an  observation  level. 
      integer loc
      real*8  leng, dedt, cosfromaxis
      real*8  clen2thick

      logical cross, seeupper

      record /coord/ xyz1, xyz2, dircos, diffvec, unitv, unitp
      real*8 dummylen, r0, rp, obsrl,  cosp, dt2, m2
      real*8 coscr2, r0r
c
      cross = .false.

      if(ObsPlane .ne. notUsed ) then
         loc = TrackBefMove.where 
         r0 = ObsSites(loc).pos.radiallen
         rp = TrackBefMove.pos.radiallen

         dt2 =   rp**2 -  r0**2
         if(dt2 .lt. 0.d0) then
            if(dt2 .lt. -1.d0) then
               write(*,*) ' loc =',loc, ' r0=',r0, ' rp=',rp,
     *             ' dt2=',dt2, ' code=',TrackBefMove.p.code,
     *         ' rp.h=', TrackBefMove.pos.height,
     *         ObsSites(loc).pos.height
               call cerrorMsg('position info invalid',0)
            endif
            dt2 = abs(dt2)
         endif
         coscr2 = dt2 /rp**2
c            dt vector for later use
         call cdiffvec(TrackBefMove.pos.xyz, 
     *        MovedTrack.pos.xyz, diffvec)
c
c         
c                  get d; unit vector
         call c3DV2DDCos(diffvec, unitv, dummylen)
         call c3DV2DDCos(TrackBefMove.pos.xyz, unitp, dummylen)
         call cscalerProd(unitv, unitp, cosp)
         cosp = -cosp
         seeupper = cosp .le. 0
         if(cosp .gt. 0) then
            seeupper = cosp**2 .le. coscr2
         endif

         if(.not. seeupper) then
            if( MovedTrack.pos.radiallen .gt.  rp) then
c              scattering affected . we should  seeuuper
c               seeupper = .true.
            endif
         else
            if(MovedTrack.pos.radiallen .lt. rp) then
c                   scattering ; we should not seeupper
c               seeupper = .false.
            endif
         endif
         if( abs(ObsPlane) .ne. perpendicular ) then
            if(.not. seeupper ) then
               if(MovedTrack.pos.radiallen .le. r0) then
c                    cross ; goes down
                  cross = .true.
               else
c                   get moved length  ^2           
                  call cscalerProd(diffvec, diffvec, m2)
                  if(m2 .gt. dt2) then
c                      double cross; first one is the nearest cross
                     cross =.true.
                  endif
               endif
            else
c                may see upper
               if(MovedTrack.pos.radiallen .ge.
     *            ObsSites(loc-1).pos.radiallen) then
                  cross =.true.
               endif
            endif
         elseif(abs(ObsPlane) .eq. perpendicular) then
c           observation plane is perpendicular to primary
c           convert coord into 1ry system
            call cxyz2prim(ObsSites(NoOfSites).pos.xyz, 
     *                  MovedTrack.pos.xyz, xyz2)
            call cxyz2prim(ObsSites(NoOfSites).pos.xyz, 
     *                  TrackBefMove.pos.xyz, xyz1)
            call cscalerProd(TrackBefMove.vec.w, DcAtObsXyz, 
     *       cosfromaxis)
            if(cosfromaxis .gt. 0.) then
               if(xyz1.r(3) .gt. ObsSites(loc).zpl .and.
     *              xyz2.r(3) .le. ObsSites(loc).zpl) then
                  cross = .true.
               elseif(loc .lt. NoOfSites) then
                  if(xyz1.r(3) .gt. ObsSites(loc+1).zpl .and.
     *                 xyz2.r(3) .le. ObsSites(loc+1).zpl) then
                     cross = .true.
                     loc = loc + 1
                     MovedTrack.where = loc
                     TrackBefMove.where = loc
                  endif
               endif
            else
               if(xyz1.r(3) .lt. ObsSites(loc).zpl .and.
     *              xyz2.r(3) .ge. ObsSites(loc).zpl ) then
                  cross = .true.
               elseif(loc .gt. 1) then
                  if(xyz1.r(3) .lt. ObsSites(loc+1).zpl .and.
     *                 xyz2.r(3) .ge. ObsSites(loc-1).zpl) then
                     cross = .true.
                     loc = loc - 1
                     MovedTrack.where = loc
                     TrackBefMove.where = loc
                  endif
               endif
            endif
         endif
         if(cross) then
c             get length, leng, from the starting point to
c             the observation depth
            if(abs(ObsPlane) .eq. perpendicular) then
c                direction cos in 1ry system
               if(MoveStat .ne. BorderL .and.
     *            MoveStat .ne. BorderH ) then
                  call cxyz2primD(diffvec, dircos)
                  leng = (ObsSites(loc).zpl - xyz1.r(3))/dircos.r(3)
                  leng = leng + abs(0.01d0/dircos.r(3))
               endif
            else    
c                 
               call cscalerProd(unitv, TrackBefMove.pos.xyz, r0r)
               if(seeupper) then
                  obsrl = ObsSites(loc-1 ).pos.radiallen
               else
                  obsrl = ObsSites(loc).pos.radiallen
               endif
c                 get distance to the crossing point
               if(rp .gt. obsrl ) then
                  leng = -r0r - sqrt(r0r**2 -
     *              (rp**2-obsrl**2))
               else
                  leng = -r0r + sqrt(r0r**2 -
     *             (rp**2 - obsrl**2))
               endif
               leng = leng + 0.01d0
            endif
c   
            IntInfArray(ProcessNo).length = leng
            IntInfArray(ProcessNo).thickness = clen2thick(
     *           TrackBefMove.pos.radiallen - Eradius,
     *           TrackBefMove.vec.coszenith, leng)
            call cmoveStreight(leng, unitv)
            if(MovedTrack.pos.height .le. BorderHeightL) then
               MoveStat = BorderL
               MovedTrack.where = NoOfSites+1
            elseif(MovedTrack.pos.height .ge. BorderHeightH) then
               MoveStat = BorderH
               MovedTrack.where = 0
            else
               MoveStat = ToBeObserved
               if(seeupper) then
                  nextwhere = loc - 1
                  MovedTrack.where = nextwhere
                  if(MovedTrack.pos.height .lt.
     *                   ObsSites(nextwhere).pos.height)  then
                  endif
               else
                  nextwhere = loc + 1
                  if(MovedTrack.pos.height .gt.
     *                ObsSites(loc).pos.height) then
                  endif
               endif
            endif

            if(MovedTrack.p.charge .ne. 0) then
               call cqElossRate(dedt) ! get de/dx computed previously
               MovedTrack.p.fm.p(4) =max( TrackBefMove.p.fm.p(4) -
     *          dedt * IntInfArray(ProcessNo).thickness,
     *          MovedTrack.p.mass)   ! max is for safety. we neg. 
                                     ! syncrotron loss
            endif
         else
            nextwhere = loc
         endif
      endif
      if(.not. cross .or. ObsPlane .eq. notUsed) then
c        
         if(BackAngLimit .gt. -1.0) then
            call cscalerProd(MovedTrack.vec.w, DcAtObsXyz, cosfromaxis)
            if(cosfromaxis .lt. BackAngLimit) then
c                discard it
               MoveStat = AngleLimit
            endif
         endif
      endif
      end
      subroutine cdiffvec(r1, r2, diff)
c        get diff= r2-r1 as 3 D vector
#include      "Zcoord.h"
      record /coord/ r1,  r2  ! input 
      record /coord/ diff     ! output.  

      integer i

      do i = 1, 3
         diff.r(i) = r2.r(i) - r1.r(i)
      enddo
      end




