c        cupsilon:  compute upsilon
c        cy2zeta:  y --> zeta
c        cx2zeta:  x --> zeta
c
c            compute critical value Upsilon
c           = E/m *  H/Hcr
      real*8  function cupsilon(electron, mag)
      implicit none
#include "Zglobalc.h"
#include "Zptcl.h"
#include "Zmagfield.h"

      record /ptcl/ electron ! electron
      record /magfield/ mag  ! magnetic field.
      real*8 bsin, cgetBsin

      bsin = cgetBsin(electron, mag)
c            E/m  * Bsin/Bcr      
      cupsilon = electron.fm.p(4) /electron.mass * bsin/Bcr
      end
c     *****************************************************************
c      compute critical energy (peak energy) of photons for synchrotron
c      radiation.
c        
      real*8 function cegCrit(e, upsilon)
      implicit none
c         y in Erber is Eg/Egcrit

      real*8  e  ! input.  Electron energy in GeV.
      real*8 upsilon   !  Upsilon value  E/m * Bsin/Bcr
c
      cegCrit = e * 3. * upsilon/(2. + 3.*upsilon)
      end
c     *****************************************
c        zeta = y/(2 +  3Upsilon(1-y))
c             = y/(2+3Upsilon)/(1- x)
c             = x (1+x )/ (3Upsilon)          Eq.2.8
      real*8 function cy2zeta(y, upsilon)
      implicit none
      real*8  y  ! input.  Eg/Egcrit
      real*8 upsilon ! input.  

      cy2zeta = y/ (2. + 3.*upsilon*(1. - y))
      end
c     ********************************************
c        This is approx. formula.
c
      real*8 function cx2zeta(x, upsilon)
      implicit none
      real*8  x  ! input.  Eg/Ee
      real*8 upsilon ! input.  

      cx2zeta = x *(1. + x)/(3.*upsilon)
      end
