#include "ZsaveStruc.h"
c       **************************************************************
c       *
c       * cbst0:  boost a partilce into the rest system of another
c       *         particle
c       *
c       **************************************************************
c
c /usage/  call cbst0(init, gb, p,  po)
c
c        Suppose two particles given in the system K. 
c        The Lorentz factor of particle 1 is given in K.
c        4 momentum of particle 2 is also given in K.  This boosts
c        particle 2 into  the rest frame of particle 1.

c  init: integer.  Input.  If gb is the same as the previous call to this
c        subroutine, give a value other than 1.  If gb is different
c        from the previous call, use 1. 
c    gb: structure /fmom/. Input. Lorentz factor of particle 1 in K.
c    p:  structure /ptcl/. Input. particle 2
c   po:  structure /ptcl/. Output. particle seen at the rest system
c        of particle 1.
c
       subroutine cbst0(init, gb, p, po)
         implicit none

#include  "Zptcl.h"
         record /fmom/ gb
         record /ptcl/ p, po
         integer init
c
         record /fmom/ ig
#ifdef  USESAVE
         save ig
#endif
c

         if(init .eq. 1) then
            ig.p(1) = -gb.p(1)
            ig.p(2) = -gb.p(2)
            ig.p(3) = -gb.p(3)
            ig.p(4) =  gb.p(4)
         endif
         po = p
         call clorep(init, ig, p, po)
       end


