	subroutine ciP5F1S50C70(cs, e1, e2, desingle)
	implicit none
	real*8 cs ! output.  cos
	real*8 e1  ! output  low end of energy
        real*8 e2  ! output   high end of energy
	real*8 desingle  ! output  energy deposit by single muon
                         !       in GeV with cos angle
c    Pb=0.5cm
c    Fe=0.1cm
c    Scinti = 5.0cm
c    Cos=0.70
c    energy 0.001 GeV to 1 GeV
c    slant Single Eqv. 0.7e-2 GeV
c

	cs = 0.70
	e1 = 1.d-3
	e2 = 1.
	desingle = 1.4e-2
      end
      subroutine sedem(e, de)
      implicit none
      real*8 e  ! input   electron energy in GeV.
      real*8 de  ! output  energy deposit in Scinti in GeV*cos(angle)

      integer ne, i
      integer nes
      parameter (nes=13)
      parameter(ne=10)

      real*8 zr(nes)
      real*8 u, el, rr

      real*8 hx, hy, f



      real*8 a(101,ne), a1(101),
     * ap4640(101), ap2154(101),ap1(101),             ap0464(101),
     *              ap0215(101), ap01(101), ap0046(101),
     *          ap0021(101), ap001(101)
      equivalence (a(1,ne-9 ), ap001(1))
      equivalence (a(1,ne-8 ), ap0021(1))
      equivalence (a(1,ne-7), ap0046(1))
      equivalence (a(1,ne-6), ap01(1))
      equivalence (a(1,ne-5), ap0215(1))
      equivalence (a(1,ne-4), ap0464(1))
      equivalence (a(1,ne-3), ap1(1))
      equivalence (a(1,ne-2), ap2154(1))
      equivalence (a(1,ne-1), ap4640(1))
      equivalence (a(1,ne  ), a1(1))
	
	data hx/0.01d0/, hy/0.333333333d0/
c
      data (a1    (i),i=   1,  72)/
     1-4.0000,-2.1897,-2.0441,-2.0124,-1.9922,-1.9729,-1.9534,-1.9367,
     2-1.9197,-1.9004,-1.8794,-1.8568,-1.8345,-1.8142,-1.7951,-1.7760,
     3-1.7578,-1.7395,-1.7248,-1.7096,-1.6935,-1.6794,-1.6663,-1.6541,
     4-1.6423,-1.6281,-1.6146,-1.6028,-1.5909,-1.5797,-1.5693,-1.5598,
     5-1.5501,-1.5403,-1.5314,-1.5231,-1.5153,-1.5078,-1.5005,-1.4933,
     6-1.4864,-1.4793,-1.4722,-1.4651,-1.4580,-1.4508,-1.4437,-1.4367,
     7-1.4298,-1.4232,-1.4169,-1.4109,-1.4048,-1.3987,-1.3926,-1.3862,
     8-1.3795,-1.3726,-1.3653,-1.3583,-1.3519,-1.3456,-1.3392,-1.3327,
     9-1.3269,-1.3215,-1.3159,-1.3095,-1.3027,-1.2965,-1.2905,-1.2844/
      data (a1    (i),i=  73, 101)/
     1-1.2779,-1.2711,-1.2644,-1.2575,-1.2504,-1.2430,-1.2362,-1.2303,
     2-1.2235,-1.2150,-1.2067,-1.1986,-1.1901,-1.1813,-1.1725,-1.1632,
     3-1.1531,-1.1433,-1.1336,-1.1236,-1.1126,-1.1003,-1.0866,-1.0722,
     4-1.0564,-1.0358,-1.0099,-0.9684,-0.7600/
c
      data (ap4640(i),i=   1,  72)/
     1-4.7150,-2.8326,-2.3771,-2.1706,-2.0876,-2.0512,-2.0304,-2.0152,
     2-2.0000,-1.9876,-1.9751,-1.9637,-1.9534,-1.9430,-1.9320,-1.9214,
     3-1.9112,-1.9000,-1.8892,-1.8788,-1.8654,-1.8524,-1.8401,-1.8285,
     4-1.8171,-1.8043,-1.7919,-1.7790,-1.7653,-1.7527,-1.7420,-1.7326,
     5-1.7220,-1.7117,-1.7023,-1.6928,-1.6829,-1.6725,-1.6622,-1.6521,
     6-1.6436,-1.6353,-1.6274,-1.6200,-1.6131,-1.6057,-1.5980,-1.5904,
     7-1.5826,-1.5753,-1.5684,-1.5612,-1.5536,-1.5467,-1.5405,-1.5339,
     8-1.5269,-1.5199,-1.5134,-1.5070,-1.5009,-1.4949,-1.4887,-1.4824,
     9-1.4762,-1.4701,-1.4640,-1.4578,-1.4514,-1.4450,-1.4389,-1.4332/
      data (ap4640(i),i=  73, 101)/
     1-1.4267,-1.4197,-1.4128,-1.4058,-1.3990,-1.3922,-1.3854,-1.3789,
     2-1.3721,-1.3628,-1.3541,-1.3466,-1.3385,-1.3297,-1.3204,-1.3106,
     3-1.3013,-1.2919,-1.2818,-1.2699,-1.2581,-1.2456,-1.2314,-1.2171,
     4-1.2006,-1.1784,-1.1504,-1.1153,-0.9200/
c
      data (ap2154(i),i=   1,  72)/
     1-5.0000,-3.4545,-3.0919,-2.8040,-2.6231,-2.4594,-2.3444,-2.2512,
     2-2.1796,-2.1389,-2.1116,-2.0833,-2.0719,-2.0590,-2.0465,-2.0354,
     3-2.0245,-2.0140,-2.0061,-1.9976,-1.9887,-1.9801,-1.9719,-1.9641,
     4-1.9564,-1.9486,-1.9406,-1.9326,-1.9245,-1.9161,-1.9079,-1.9003,
     5-1.8920,-1.8828,-1.8738,-1.8649,-1.8560,-1.8473,-1.8389,-1.8309,
     6-1.8238,-1.8150,-1.8053,-1.7976,-1.7903,-1.7819,-1.7731,-1.7638,
     7-1.7552,-1.7477,-1.7408,-1.7346,-1.7276,-1.7200,-1.7129,-1.7062,
     8-1.6994,-1.6927,-1.6859,-1.6785,-1.6711,-1.6639,-1.6569,-1.6501,
     9-1.6435,-1.6366,-1.6294,-1.6224,-1.6157,-1.6093,-1.6029,-1.5966/
      data (ap2154(i),i=  73, 101)/
     1-1.5901,-1.5837,-1.5766,-1.5689,-1.5612,-1.5533,-1.5462,-1.5397,
     2-1.5327,-1.5250,-1.5167,-1.5078,-1.4993,-1.4909,-1.4821,-1.4731,
     3-1.4643,-1.4539,-1.4425,-1.4308,-1.4195,-1.4084,-1.3951,-1.3789,
     4-1.3615,-1.3418,-1.3140,-1.2782,-1.1300/
c
      data (ap1   (i),i=   1,  72)/
     1-5.0000,-3.9208,-3.6374,-3.4367,-3.2814,-3.1493,-3.0275,-2.9095,
     2-2.8160,-2.7498,-2.6729,-2.6133,-2.5585,-2.5086,-2.4543,-2.4116,
     3-2.3646,-2.3319,-2.2962,-2.2635,-2.2322,-2.2088,-2.1852,-2.1651,
     4-2.1483,-2.1337,-2.1215,-2.1114,-2.1026,-2.0939,-2.0859,-2.0781,
     5-2.0701,-2.0618,-2.0549,-2.0489,-2.0418,-2.0342,-2.0269,-2.0197,
     6-2.0124,-2.0047,-1.9979,-1.9921,-1.9862,-1.9790,-1.9715,-1.9652,
     7-1.9600,-1.9541,-1.9476,-1.9413,-1.9352,-1.9293,-1.9231,-1.9167,
     8-1.9102,-1.9035,-1.8966,-1.8898,-1.8827,-1.8762,-1.8708,-1.8644,
     9-1.8562,-1.8487,-1.8421,-1.8359,-1.8294,-1.8229,-1.8151,-1.8068/
      data (ap1   (i),i=  73, 101)/
     1-1.7993,-1.7924,-1.7854,-1.7788,-1.7715,-1.7636,-1.7559,-1.7483,
     2-1.7402,-1.7317,-1.7231,-1.7145,-1.7067,-1.6987,-1.6900,-1.6806,
     3-1.6708,-1.6613,-1.6505,-1.6382,-1.6265,-1.6123,-1.5979,-1.5820,
     4-1.5647,-1.5447,-1.5174,-1.4757,-1.3250/
c
      data (ap0464(i),i=   1,  72)/
     1-5.6100,-4.4355,-4.1473,-3.9821,-3.8655,-3.7780,-3.6809,-3.6143,
     2-3.5424,-3.4863,-3.4294,-3.3689,-3.3129,-3.2650,-3.2202,-3.1774,
     3-3.1434,-3.1074,-3.0671,-3.0321,-2.9949,-2.9651,-2.9330,-2.8964,
     4-2.8696,-2.8415,-2.8100,-2.7825,-2.7551,-2.7274,-2.7036,-2.6824,
     5-2.6563,-2.6317,-2.6019,-2.5792,-2.5599,-2.5371,-2.5139,-2.4951,
     6-2.4764,-2.4566,-2.4353,-2.4150,-2.3995,-2.3775,-2.3611,-2.3446,
     7-2.3249,-2.3078,-2.2933,-2.2758,-2.2580,-2.2456,-2.2333,-2.2195,
     8-2.2083,-2.1972,-2.1866,-2.1774,-2.1682,-2.1594,-2.1518,-2.1436,
     9-2.1340,-2.1249,-2.1167,-2.1097,-2.1031,-2.0955,-2.0871,-2.0796/
      data (ap0464(i),i=  73, 101)/
     1-2.0730,-2.0662,-2.0595,-2.0528,-2.0467,-2.0400,-2.0321,-2.0244,
     2-2.0170,-2.0093,-2.0010,-1.9929,-1.9853,-1.9767,-1.9670,-1.9576,
     3-1.9481,-1.9381,-1.9273,-1.9157,-1.9024,-1.8861,-1.8694,-1.8525,
     4-1.8354,-1.8165,-1.7829,-1.7434,-1.5600/
c
      data (ap0215(i),i=   1,  72)/
     1-5.9850,-4.9642,-4.6009,-4.4296,-4.3099,-4.2201,-4.1373,-4.0764,
     2-4.0359,-3.9964,-3.9508,-3.9138,-3.8783,-3.8466,-3.8159,-3.7713,
     3-3.7373,-3.7084,-3.6816,-3.6553,-3.6330,-3.6113,-3.5886,-3.5588,
     4-3.5352,-3.5099,-3.4884,-3.4616,-3.4414,-3.4222,-3.4046,-3.3850,
     5-3.3667,-3.3502,-3.3330,-3.3181,-3.3010,-3.2848,-3.2663,-3.2472,
     6-3.2330,-3.2138,-3.1934,-3.1772,-3.1602,-3.1434,-3.1245,-3.1070,
     7-3.0914,-3.0794,-3.0644,-3.0484,-3.0313,-3.0107,-2.9919,-2.9716,
     8-2.9575,-2.9426,-2.9250,-2.9100,-2.8914,-2.8737,-2.8551,-2.8414,
     9-2.8258,-2.8080,-2.7919,-2.7712,-2.7518,-2.7330,-2.7156,-2.6992/
      data (ap0215(i),i=  73, 101)/
     1-2.6830,-2.6674,-2.6506,-2.6380,-2.6188,-2.5962,-2.5805,-2.5655,
     2-2.5498,-2.5321,-2.5113,-2.4935,-2.4752,-2.4613,-2.4404,-2.4163,
     3-2.3903,-2.3699,-2.3515,-2.3338,-2.3081,-2.2865,-2.2613,-2.2393,
     4-2.2113,-2.1850,-2.1494,-2.0984,-1.8450/
c
      data (ap01  (i),i=   1,  72)/
     1-5.9850,-5.2498,-4.9687,-4.8042,-4.6898,-4.6002,-4.5257,-4.4366,
     2-4.3788,-4.3041,-4.2682,-4.2239,-4.1753,-4.1392,-4.0981,-4.0687,
     3-4.0441,-4.0097,-3.9841,-3.9577,-3.9307,-3.9080,-3.8852,-3.8671,
     4-3.8504,-3.8316,-3.8116,-3.7962,-3.7814,-3.7659,-3.7431,-3.7257,
     5-3.7073,-3.6914,-3.6761,-3.6596,-3.6464,-3.6334,-3.6176,-3.6025,
     6-3.5847,-3.5704,-3.5576,-3.5443,-3.5287,-3.5155,-3.5007,-3.4833,
     7-3.4682,-3.4519,-3.4334,-3.4171,-3.4024,-3.3891,-3.3763,-3.3645,
     8-3.3518,-3.3386,-3.3255,-3.3130,-3.3011,-3.2878,-3.2761,-3.2642,
     9-3.2515,-3.2376,-3.2229,-3.2098,-3.1940,-3.1808,-3.1673,-3.1565/
      data (ap01  (i),i=  73, 101)/
     1-3.1442,-3.1297,-3.1145,-3.0969,-3.0789,-3.0653,-3.0493,-3.0314,
     2-3.0150,-2.9932,-2.9727,-2.9563,-2.9415,-2.9221,-2.9043,-2.8833,
     3-2.8628,-2.8399,-2.8140,-2.7905,-2.7676,-2.7381,-2.7094,-2.6758,
     4-2.6250,-2.5798,-2.5152,-2.4406,-2.2350/
c
      data (ap0046(i),i=   1,  72)/
     1-5.9250,-5.3052,-5.0769,-4.8847,-4.7697,-4.6966,-4.5954,-4.5179,
     2-4.4750,-4.4096,-4.3676,-4.3206,-4.2964,-4.2576,-4.2275,-4.2049,
     3-4.1737,-4.1486,-4.1239,-4.1006,-4.0819,-4.0646,-4.0378,-4.0106,
     4-3.9875,-3.9695,-3.9516,-3.9356,-3.9221,-3.8991,-3.8791,-3.8624,
     5-3.8525,-3.8420,-3.8291,-3.8150,-3.8013,-3.7891,-3.7781,-3.7621,
     6-3.7490,-3.7348,-3.7235,-3.7134,-3.7040,-3.6912,-3.6765,-3.6636,
     7-3.6534,-3.6436,-3.6311,-3.6192,-3.6052,-3.5928,-3.5820,-3.5699,
     8-3.5574,-3.5468,-3.5347,-3.5212,-3.5104,-3.4997,-3.4884,-3.4768,
     9-3.4664,-3.4558,-3.4456,-3.4360,-3.4262,-3.4108,-3.3960,-3.3835/
      data (ap0046(i),i=  73, 101)/
     1-3.3658,-3.3497,-3.3368,-3.3242,-3.3132,-3.3041,-3.2929,-3.2784,
     2-3.2633,-3.2525,-3.2331,-3.2140,-3.1947,-3.1767,-3.1562,-3.1372,
     3-3.1207,-3.1027,-3.0840,-3.0698,-3.0527,-3.0304,-3.0002,-2.9674,
     4-2.9323,-2.9015,-2.8559,-2.7767,-2.6550/
c
      data (ap0021(i),i=   1,  72)/
     1-5.8650,-5.2957,-5.1009,-5.0577,-4.9369,-4.8642,-4.7480,-4.6814,
     2-4.6114,-4.5541,-4.5513,-4.4788,-4.4118,-4.3829,-4.3642,-4.3149,
     3-4.3105,-4.2936,-4.2670,-4.2041,-4.1976,-4.1649,-4.1463,-4.1227,
     4-4.0940,-4.0831,-4.0752,-4.0636,-4.0342,-3.9866,-3.9927,-3.9747,
     5-3.9565,-3.9450,-3.9301,-3.9231,-3.9207,-3.9101,-3.8980,-3.8891,
     6-3.8707,-3.8575,-3.8487,-3.8405,-3.8286,-3.8184,-3.8214,-3.8121,
     7-3.7899,-3.7819,-3.7760,-3.7664,-3.7517,-3.7368,-3.7272,-3.7192,
     8-3.7066,-3.6955,-3.6855,-3.6771,-3.6622,-3.6492,-3.6388,-3.6329,
     9-3.6275,-3.6229,-3.6180,-3.6128,-3.6067,-3.5986,-3.5888,-3.5705/
      data (ap0021(i),i=  73, 101)/
     1-3.5622,-3.5496,-3.5351,-3.5286,-3.5226,-3.5201,-3.5080,-3.4931,
     2-3.4782,-3.4634,-3.4510,-3.4411,-3.4324,-3.4247,-3.4159,-3.4038,
     3-3.3836,-3.3668,-3.3485,-3.3292,-3.3229,-3.2991,-3.2806,-3.2623,
     4-3.2395,-3.2203,-3.1886,-3.1496,-3.1050/
c
      data ap001/5*-6., 6*-5.,90*-4.5/
c

       data zr/1.00, .995, .970,.875, .674, .40,
     *          .185, .067, .032, .001, .006,0.005, 0.001/
c
c
         el=log10(e)
         call rndc(u)
         call kintp3(zr, 1, nes, -3.d0, .25d0, el, rr)
         if(u .lt. rr) then
            de=0.
         else
            call rndc(u)
            call k4ptdi(b, 101, ne, 101, 0.d0, -3.d0, hx, hy,
     *      u, el, f)
            de = 10.d0**f
         endif
      end
      subroutine cepP5F1S50C70(e, de)
	implicit none
c            e+
	real*8 e, de
          call cemP5F1S50C70(e, de)
          if(e .lt. .021) then
c                correction;  7% increase at 10 mev
               de=de* (1. + (.021-e)* 7.)
          endif
      end
      subroutine cgP5F1S50C70(e, de)
      implicit none
c           this is for g  incident
c
      real*8 e, de

      integer ne, i
      integer nes
      parameter (nes=13)
      parameter(ne = 11)
      
      real*8 u, el, rr

      real*8 hx, hy, f

      real*8 zr(nes)

c
c
c

      real*8 a(101,ne), a1(101),
     *          ap4640(101), ap2154(101),ap1(101), ap0464(101),
     * ap0316(101), ap0215(101), ap01(101), ap0046(101),
     *          ap0021(101), ap001(101)
      equivalence (a(1,ne-10), ap001(1))
      equivalence (a(1,ne-9), ap0021(1))
      equivalence (a(1,ne-8), ap0046(1))
      equivalence (a(1,ne-7), ap01(1))
      equivalence (a(1,ne-6), ap0215(1))
      equivalence (a(1,ne-5), ap0316(1))
      equivalence (a(1,ne-4), ap0464(1))
      equivalence (a(1,ne-3), ap1(1))
      equivalence (a(1,ne-2), ap2154(1))
      equivalence (a(1,ne-1), ap4640(1))
      equivalence (a(1,ne  ), a1(1))

	data hx/0.01d0/, hy/0.333333333d0/
c
             real*4 zr(nes)/.78, .80, .83, .845, .809, .725,
     *       .622, .556, .505, .48, .455, .432, .426/
c
      endif
c
         el=log10(e)
         call rndc(u)
         call kintp3(zr, 1, nes, -3.d0, .25d0, el, rr)
         if(u .lt. rr) then
            de=0.
         else
            call rndc(u)
            call k4ptdi(b, 101, ne, 101, 0.d0, -3.d0, hx, hy,
     *      u, el, f)
            de = 10.d0**f
         endif
      end
