	subroutine ciP5F1S35C99(cs, e1, e2, desingle)
	implicit none
	real*8 cs ! output.  cos
	real*8 e1  ! output  low end of energy
        real*8 e2  ! output   high end of energy
	real*8 desingle  ! output  energy deposit by single muon
                         !       in GeV with cos angle
c    Pb=0.5cm
c    Fe=0.1cm
c    Scinti = 3.5cm
c    Cos=0.99
c    energy 0.001 GeV to 1 GeV
c    slant Single Eqv. 0.7e-2 GeV
c

	cs = 0.99
	e1 = 1.d-3
	e2 = 1.
	desingle = 0.7e-2
      end
      subroutine cemP5F1S35C99(e, de)
      implicit none
c           this is for e- incident
c             be >= 0.975
c de--output  energy deposit in scinti in gev*cos(angle)
c
      real*8 e  ! input   electron energy in GeV.
      real*8 de  ! output  energy deposit in Scinti in GeV*cos(angle)

      integer ne, i
      integer nes
      parameter (nes=13)
      parameter(ne=12)

      real*8 zr(nes)
      real*8 u, el, rr

      real*8 hx, hy, f

      real*8 b(101,ne), b1(101),
     * bp4640(101), bp2154(101),bp1(101),bp065(101), bp0464(101),
     * bp0316(101), bp0215(101), bp01(101), bp0046(101),
     * bp0021(101), bp001(101)
      equivalence (b(1,ne-11), bp001(1))
      equivalence (b(1,ne-10), bp0021(1))
      equivalence (b(1,ne-9), bp0046(1))
      equivalence (b(1,ne-8), bp01(1))
      equivalence (b(1,ne-7), bp0215(1))
      equivalence (b(1,ne-6), bp0316(1))
      equivalence (b(1,ne-5), bp0464(1))
      equivalence (b(1,ne-4), bp065(1))
      equivalence (b(1,ne-3), bp1(1))
      equivalence (b(1,ne-2), bp2154(1))
      equivalence (b(1,ne-1), bp4640(1))
      equivalence (b(1,ne  ), b1(1))
c
      data hx/0.01d0/, hy/0.3333333333d0/
c
      data (b1    (i),i=   1,  72)/
     1-2.9400,-2.4000,-2.3500,-2.2251,-2.2173,-2.2101,-2.2035,-2.1969,
     2-2.1904,-2.1840,-2.1774,-2.1709,-2.1642,-2.1577,-2.1520,-2.1463,
     3-2.1384,-2.1297,-2.1205,-2.1112,-2.1015,-2.0905,-2.0796,-2.0690,
     4-2.0580,-2.0458,-2.0336,-2.0214,-2.0085,-1.9917,-1.9738,-1.9571,
     5-1.9403,-1.9216,-1.9063,-1.8922,-1.8791,-1.8672,-1.8547,-1.8412,
     6-1.8292,-1.8169,-1.8029,-1.7891,-1.7750,-1.7606,-1.7469,-1.7343,
     7-1.7251,-1.7167,-1.7083,-1.7006,-1.6935,-1.6868,-1.6805,-1.6744,
     8-1.6687,-1.6626,-1.6564,-1.6501,-1.6436,-1.6372,-1.6306,-1.6239,
     9-1.6167,-1.6089,-1.6012,-1.5935,-1.5857,-1.5776,-1.5691,-1.5607/
      data (b1    (i),i=  73, 101)/
     1-1.5527,-1.5449,-1.5370,-1.5291,-1.5211,-1.5127,-1.5041,-1.4954,
     2-1.4865,-1.4776,-1.4683,-1.4592,-1.4509,-1.4425,-1.4321,-1.4212,
     3-1.4111,-1.4014,-1.3898,-1.3769,-1.3629,-1.3481,-1.3309,-1.3123,
     4-1.2923,-1.2706,-1.2319,-1.1860,-0.9800/
c
      data (bp4640(i),i=   1,  72)/
     1-4.0000,-2.5362,-2.23,  -2.22,  -2.2196,-2.2152,-2.2106,-2.2058,
     2-2.2013,-2.1967,-2.1923,-2.1878,-2.1833,-2.1788,-2.1745,-2.1698,
     3-2.1645,-2.1590,-2.1538,-2.1487,-2.1440,-2.1385,-2.1322,-2.1260,
     4-2.1198,-2.1137,-2.1071,-2.1000,-2.0928,-2.0856,-2.0777,-2.0688,
     5-2.0600,-2.0510,-2.0409,-2.0312,-2.0223,-2.0114,-2.0002,-1.9889,
     6-1.9762,-1.9639,-1.9506,-1.9337,-1.9199,-1.9085,-1.8965,-1.8842,
     7-1.8734,-1.8631,-1.8532,-1.8441,-1.8339,-1.8233,-1.8138,-1.8033,
     8-1.7925,-1.7826,-1.7723,-1.7610,-1.7488,-1.7386,-1.7297,-1.7217,
     9-1.7136,-1.7056,-1.6983,-1.6914,-1.6851,-1.6794,-1.6730,-1.6660/
      data (bp4640(i),i=  73, 101)/
     1-1.6593,-1.6528,-1.6461,-1.6389,-1.6315,-1.6242,-1.6170,-1.6092,
     2-1.6010,-1.5931,-1.5842,-1.5730,-1.5627,-1.5526,-1.5419,-1.5314,
     3-1.5202,-1.5079,-1.4958,-1.4820,-1.4692,-1.4528,-1.4371,-1.4204,
     4-1.4001,-1.3758,-1.3411,-1.2973,-1.1200/
c
      data (bp2154(i),i=   1,  72)/
     1-5.0000,-3.3063,-2.7377,-2.3815,-2.1817,-2.2272,-2.2196,-2.2143,
     2-2.2118,-2.2075,-2.2034,-2.2001,-2.1963,-2.1926,-2.1889,-2.1852,
     3-2.1816,-2.1779,-2.1742,-2.1705,-2.1668,-2.1631,-2.1594,-2.1559,
     4-2.1521,-2.1481,-2.1439,-2.1397,-2.1353,-2.1309,-2.1266,-2.1220,
     5-2.1171,-2.1119,-2.1065,-2.1008,-2.0948,-2.0889,-2.0831,-2.0774,
     6-2.0716,-2.0659,-2.0598,-2.0529,-2.0457,-2.0382,-2.0304,-2.0220,
     7-2.0131,-2.0036,-1.9943,-1.9851,-1.9756,-1.9652,-1.9540,-1.9425,
     8-1.9320,-1.9212,-1.9097,-1.9002,-1.8908,-1.8816,-1.8726,-1.8636,
     9-1.8543,-1.8447,-1.8349,-1.8256,-1.8164,-1.8073,-1.7977,-1.7877/
      data (bp2154(i),i=  73, 101)/
     1-1.7776,-1.7674,-1.7564,-1.7448,-1.7348,-1.7251,-1.7156,-1.7066,
     2-1.6977,-1.6890,-1.6802,-1.6714,-1.6630,-1.6539,-1.6429,-1.6323,
     3-1.6219,-1.6118,-1.6009,-1.5887,-1.5751,-1.5600,-1.5440,-1.5265,
     4-1.5069,-1.4817,-1.4513,-1.3993,-1.1750/
c
      data (bp1   (i),i=   1,  72)/
     1-4.0000,-3.8065,-3.4783,-3.1972,-2.9442,-2.7306,-2.5559,-2.4308,
     2-2.3355,-2.2542,-2.2073,-2.2223,-2.2172,-2.2124,-2.2080,-2.2038,
     3-2.1997,-2.1958,-2.1919,-2.1882,-2.1845,-2.1808,-2.1771,-2.1735,
     4-2.1699,-2.1665,-2.1631,-2.1598,-2.1565,-2.1531,-2.1497,-2.1463,
     5-2.1429,-2.1395,-2.1360,-2.1325,-2.1289,-2.1253,-2.1215,-2.1177,
     6-2.1137,-2.1098,-2.1058,-2.1018,-2.0977,-2.0933,-2.0887,-2.0839,
     7-2.0793,-2.0748,-2.0705,-2.0660,-2.0611,-2.0560,-2.0508,-2.0456,
     8-2.0404,-2.0348,-2.0287,-2.0224,-2.0161,-2.0096,-2.0030,-1.9963,
     9-1.9892,-1.9817,-1.9738,-1.9652,-1.9566,-1.9481,-1.9388,-1.9290/
      data (bp1   (i),i=  73, 101)/
     1-1.9192,-1.9092,-1.8990,-1.8894,-1.8799,-1.8705,-1.8618,-1.8528,
     2-1.8428,-1.8328,-1.8227,-1.8132,-1.8026,-1.7911,-1.7788,-1.7660,
     3-1.7538,-1.7406,-1.7269,-1.7117,-1.6963,-1.6782,-1.6619,-1.6445,
     4-1.6224,-1.5977,-1.5682,-1.5224,-1.3000/
c
      data (bp065 (i),i=   1,  72)/
     1-5.7600,-4.1534,-3.8117,-3.6097,-3.4286,-3.2731,-3.1438,-3.0117,
     2-2.8856,-2.7812,-2.6772,-2.6024,-2.5171,-2.4538,-2.3877,-2.3405,
     3-2.2869,-2.2356,-2.2258,-2.2169,-2.2105,-2.2068,-2.2013,-2.1959,
     4-2.1904,-2.1856,-2.1822,-2.1790,-2.1754,-2.1719,-2.1685,-2.1652,
     5-2.1617,-2.1582,-2.1546,-2.1510,-2.1473,-2.1436,-2.1399,-2.1362,
     6-2.1324,-2.1285,-2.1245,-2.1206,-2.1166,-2.1128,-2.1090,-2.1053,
     7-2.1016,-2.0978,-2.0940,-2.0903,-2.0864,-2.0823,-2.0780,-2.0736,
     8-2.0691,-2.0646,-2.0600,-2.0552,-2.0503,-2.0452,-2.0399,-2.0344,
     9-2.0288,-2.0230,-2.0170,-2.0111,-2.0052,-1.9993,-1.9934,-1.9876/
      data (bp065 (i),i=  73, 101)/
     1-1.9814,-1.9742,-1.9668,-1.9599,-1.9533,-1.9464,-1.9395,-1.9309,
     2-1.9209,-1.9119,-1.9029,-1.8940,-1.8834,-1.8721,-1.8607,-1.8495,
     3-1.8380,-1.8258,-1.8129,-1.8006,-1.7839,-1.7700,-1.7536,-1.7315,
     4-1.7123,-1.6860,-1.6519,-1.6061,-1.3950/
c
      data (bp0464(i),i=   1,  72)/
     1-5.0000,-4.2881,-3.9840,-3.8331,-3.7094,-3.5858,-3.4795,-3.3803,
     2-3.2982,-3.2167,-3.1423,-3.0605,-2.9884,-2.9186,-2.8557,-2.7960,
     3-2.7272,-2.6656,-2.6103,-2.5604,-2.5108,-2.4654,-2.4247,-2.3813,
     4-2.3465,-2.3095,-2.2845,-2.2554,-2.2324,-2.2225,-2.2132,-2.2058,
     5-2.1999,-2.1948,-2.1895,-2.1845,-2.1797,-2.1752,-2.1709,-2.1665,
     6-2.1623,-2.1580,-2.1539,-2.1497,-2.1456,-2.1415,-2.1373,-2.1331,
     7-2.1288,-2.1244,-2.1200,-2.1157,-2.1112,-2.1069,-2.1026,-2.0984,
     8-2.0942,-2.0900,-2.0858,-2.0814,-2.0770,-2.0723,-2.0674,-2.0625,
     9-2.0575,-2.0524,-2.0473,-2.0421,-2.0368,-2.0315,-2.0261,-2.0206/
      data (bp0464(i),i=  73, 101)/
     1-2.0151,-2.0095,-2.0038,-1.9979,-1.9919,-1.9856,-1.9785,-1.9710,
     2-1.9634,-1.9555,-1.9475,-1.9391,-1.9302,-1.9211,-1.9120,-1.9020,
     3-1.8913,-1.8798,-1.8671,-1.8551,-1.8428,-1.8288,-1.8125,-1.7958,
     4-1.7739,-1.7519,-1.7212,-1.6797,-1.4900/
c
      data (bp0316(i),i=   1,  72)/
     1-5.9550,-4.6335,-4.3378,-4.1173,-3.9975,-3.9143,-3.8320,-3.7669,
     2-3.6952,-3.6431,-3.5888,-3.5422,-3.4861,-3.4348,-3.3866,-3.3416,
     3-3.2965,-3.2557,-3.2192,-3.1681,-3.1299,-3.0952,-3.0527,-3.0177,
     4-2.9851,-2.9488,-2.9151,-2.8750,-2.8398,-2.8053,-2.7699,-2.7381,
     5-2.7081,-2.6797,-2.6445,-2.6114,-2.5833,-2.5560,-2.5251,-2.5007,
     6-2.4750,-2.4488,-2.4257,-2.4030,-2.3807,-2.3572,-2.3325,-2.3117,
     7-2.2913,-2.2733,-2.2557,-2.2371,-2.2230,-2.2124,-2.2031,-2.1960,
     8-2.1885,-2.1806,-2.1731,-2.1667,-2.1606,-2.1544,-2.1483,-2.1422,
     9-2.1361,-2.1301,-2.1240,-2.1178,-2.1118,-2.1060,-2.1001,-2.0941/
      data (bp0316(i),i=  73, 101)/
     1-2.0877,-2.0818,-2.0762,-2.0705,-2.0644,-2.0582,-2.0516,-2.0446,
     2-2.0377,-2.0306,-2.0236,-2.0169,-2.0094,-2.0005,-1.9920,-1.9840,
     3-1.9752,-1.9653,-1.9541,-1.9416,-1.9284,-1.9151,-1.9008,-1.8828,
     4-1.8639,-1.8417,-1.8189,-1.7811,-1.6650/
c
      data (bp0215(i),i=   1,  72)/
     1-5.0000,-4.9161,-4.6408,-4.4519,-4.3279,-4.2256,-4.1328,-4.0644,
     2-3.9968,-3.9509,-3.9049,-3.8621,-3.8156,-3.7703,-3.7332,-3.6993,
     3-3.6645,-3.6331,-3.6024,-3.5731,-3.5453,-3.5191,-3.4931,-3.4666,
     4-3.4416,-3.4135,-3.3901,-3.3644,-3.3381,-3.3152,-3.2945,-3.2721,
     5-3.2507,-3.2260,-3.2015,-3.1799,-3.1574,-3.1371,-3.1165,-3.0959,
     6-3.0747,-3.0519,-3.0313,-3.0117,-2.9913,-2.9711,-2.9515,-2.9322,
     7-2.9120,-2.8902,-2.8692,-2.8470,-2.8290,-2.8096,-2.7868,-2.7671,
     8-2.7478,-2.7262,-2.7044,-2.6858,-2.6652,-2.6444,-2.6244,-2.6051,
     9-2.5841,-2.5631,-2.5432,-2.5224,-2.4987,-2.4793,-2.4582,-2.4407/
      data (bp0215(i),i=  73, 101)/
     1-2.4212,-2.4037,-2.3851,-2.3660,-2.3477,-2.3306,-2.3145,-2.2968,
     2-2.2791,-2.2611,-2.2442,-2.2273,-2.2113,-2.1966,-2.1837,-2.1724,
     3-2.1605,-2.1479,-2.1362,-2.1220,-2.1091,-2.0963,-2.0828,-2.0668,
     4-2.0482,-2.0287,-2.0024,-1.9704,-1.8050/
c
      data (bp01  (i),i=   1,  72)/
     1-5.9550,-5.2492,-4.9461,-4.7859,-4.6481,-4.5487,-4.4610,-4.3965,
     2-4.3370,-4.2862,-4.2356,-4.1823,-4.1366,-4.0929,-4.0564,-4.0224,
     3-3.9934,-3.9661,-3.9390,-3.9123,-3.8938,-3.8729,-3.8474,-3.8261,
     4-3.8062,-3.7879,-3.7681,-3.7494,-3.7311,-3.7121,-3.6963,-3.6754,
     5-3.6609,-3.6437,-3.6261,-3.6104,-3.5928,-3.5778,-3.5621,-3.5462,
     6-3.5294,-3.5143,-3.4990,-3.4836,-3.4678,-3.4526,-3.4376,-3.4230,
     7-3.4078,-3.3940,-3.3805,-3.3663,-3.3528,-3.3401,-3.3267,-3.3116,
     8-3.2986,-3.2858,-3.2713,-3.2589,-3.2436,-3.2294,-3.2143,-3.1991,
     9-3.1854,-3.1696,-3.1556,-3.1404,-3.1227,-3.1071,-3.0916,-3.0774/
      data (bp01  (i),i=  73, 101)/
     1-3.0643,-3.0512,-3.0331,-3.0181,-3.0011,-2.9838,-2.9653,-2.9501,
     2-2.9332,-2.9162,-2.8980,-2.8765,-2.8559,-2.8344,-2.8146,-2.7929,
     3-2.7697,-2.7450,-2.7195,-2.6949,-2.6675,-2.6457,-2.6161,-2.5798,
     4-2.5436,-2.5023,-2.4382,-2.3590,-2.0700/
c
      data (bp0046(i),i=   1,  72)/
     1-5.9550,-5.2694,-4.9547,-4.8301,-4.7171,-4.6306,-4.5607,-4.4896,
     2-4.4157,-4.3502,-4.3145,-4.2659,-4.2302,-4.1970,-4.1709,-4.1411,
     3-4.1117,-4.0853,-4.0712,-4.0406,-4.0145,-3.9809,-3.9598,-3.9416,
     4-3.9243,-3.8982,-3.8753,-3.8527,-3.8375,-3.8219,-3.8029,-3.7827,
     5-3.7645,-3.7469,-3.7325,-3.7174,-3.7035,-3.6895,-3.6763,-3.6658,
     6-3.6542,-3.6415,-3.6306,-3.6188,-3.6037,-3.5896,-3.5777,-3.5662,
     7-3.5521,-3.5404,-3.5283,-3.5155,-3.5037,-3.4935,-3.4791,-3.4659,
     8-3.4541,-3.4433,-3.4327,-3.4210,-3.4078,-3.3973,-3.3858,-3.3722,
     9-3.3627,-3.3530,-3.3390,-3.3236,-3.3128,-3.3015,-3.2902,-3.2790/
      data (bp0046(i),i=  73, 101)/
     1-3.2676,-3.2534,-3.2380,-3.2223,-3.2052,-3.1909,-3.1751,-3.1613,
     2-3.1470,-3.1292,-3.1125,-3.0948,-3.0794,-3.0617,-3.0409,-3.0215,
     3-3.0024,-2.9814,-2.9582,-2.9349,-2.9039,-2.8818,-2.8525,-2.8154,
     4-2.7906,-2.7552,-2.7055,-2.6442,-2.4600/
c
      data (bp0021(i),i=   1,  72)/
     1-5.7450,-5.3661,-5.0731,-4.8917,-4.8477,-4.7662,-4.7004,-4.5651,
     2-4.4344,-4.3685,-4.3323,-4.3104,-4.2815,-4.2574,-4.2202,-4.1889,
     3-4.1369,-4.1245,-4.1095,-4.0879,-4.0740,-4.0580,-4.0423,-4.0298,
     4-4.0136,-4.0019,-3.9843,-3.9503,-3.9278,-3.9200,-3.9053,-3.8892,
     5-3.8782,-3.8692,-3.8568,-3.8444,-3.8333,-3.8320,-3.8248,-3.8168,
     6-3.8050,-3.7930,-3.7858,-3.7740,-3.7606,-3.7505,-3.7489,-3.7301,
     7-3.7073,-3.7019,-3.6932,-3.6831,-3.6631,-3.6417,-3.6461,-3.6379,
     8-3.6297,-3.6222,-3.6149,-3.6074,-3.6000,-3.5941,-3.5853,-3.5704,
     9-3.5592,-3.5502,-3.5421,-3.5343,-3.5270,-3.5202,-3.5164,-3.5148/
      data (bp0021(i),i=  73, 101)/
     1-3.4891,-3.4728,-3.4643,-3.4518,-3.4417,-3.4328,-3.4234,-3.4152,
     2-3.4080,-3.4024,-3.3967,-3.3793,-3.3609,-3.3363,-3.3193,-3.3090,
     3-3.2983,-3.2834,-3.2663,-3.2448,-3.2280,-3.2033,-3.1835,-3.1541,
     4-3.1326,-3.0966,-3.0285,-2.9996,-2.8950/
c
       data  zr/1.00, .995, .95, .88, .72, .42,
     *          .17, .077, .045, .025, .01, 0., 0./
c

       data  bp001/5*-6., 6*-5.,90*-4.5/

c
         el=log10(e)
         call rndc(u)
         call kintp3(zr, 1, nes, -3.d0, .25d0, el, rr)
         if(u .lt. rr) then
            de=0.
         else
            call rndc(u)
            call k4ptdi(b, 101, ne, 101, 0.d0, -3.d0, hx, hy,
     *      u, el, f)
            de=10.0d0**f
         endif
      end
      subroutine cepP5F1S35C99(e, de)
      implicit none
      real*8 e, de
c            e+
          call cemP5F1S35C99(e, de)
          if(e .lt. .021d0) then
c                correction; 10% increase at 10 MeV
               de=de* (1. + (.021-e)*10.)
          endif
      end
      subroutine cgP5F1S35C99(e, de)
      implicit none
c           this is for g  incident
c
      real*8 e, de

      integer ne, i
      integer nes
      parameter (nes=17)
      parameter(ne=9)
      
      real*8 u, el, rr

      real*8 hx, hy, f

      real*8 zr(nes)

      real*8 b(101,ne),  b3p162(101), b1(101),
     *          bp3162(101), bp1(101), bp0562(101),
     *          bp0316(101), bp01(101),
     *          bp0031(101), bp001(101)
      equivalence (b(1,ne-8), bp001(1))
      equivalence (b(1,ne-7), bp0031(1))
      equivalence (b(1,ne-6), bp01(1))
      equivalence (b(1,ne-5), bp0316(1))
      equivalence (b(1,ne-4), bp0562(1))
      equivalence (b(1,ne-3), bp1(1))
      equivalence (b(1,ne-2), bp3162(1))
      equivalence (b(1,ne-1), b1(1))
      equivalence (b(1,ne), b3p162(1))
c
c
      data (b3p162(i),i=   1,  72)/
     1-4.0000,-2.6185,-2.2899,-2.1464,-2.0447,-1.9547,-1.9244,-1.9167,
     2-1.9109,-1.9061,-1.9020,-1.8979,-1.8939,-1.8901,-1.8865,-1.8832,
     3-1.8797,-1.8763,-1.8729,-1.8693,-1.8653,-1.8613,-1.8574,-1.8535,
     4-1.8495,-1.8453,-1.8409,-1.8362,-1.8313,-1.8264,-1.8213,-1.8160,
     5-1.8105,-1.8051,-1.7995,-1.7930,-1.7866,-1.7805,-1.7727,-1.7648,
     6-1.7563,-1.7472,-1.7382,-1.7288,-1.7187,-1.7098,-1.7011,-1.6918,
     7-1.6819,-1.6717,-1.6611,-1.6519,-1.6417,-1.6309,-1.6191,-1.6067,
     8-1.5981,-1.5895,-1.5808,-1.5730,-1.5653,-1.5576,-1.5502,-1.5429,
     9-1.5353,-1.5275,-1.5203,-1.5130,-1.5056,-1.4979,-1.4898,-1.4814/
      data (b3p162(i),i=  73, 101)/
     1-1.4729,-1.4639,-1.4551,-1.4465,-1.4378,-1.4281,-1.4192,-1.4103,
     2-1.4005,-1.3903,-1.3795,-1.3683,-1.3580,-1.3476,-1.3368,-1.3254,
     3-1.3139,-1.3018,-1.2881,-1.2736,-1.2597,-1.2421,-1.2257,-1.2064,
     4-1.1845,-1.1552,-1.1200,-1.0674,-0.7800/
c
      data (b1    (i),i=   1,  72)/
     1-5.0000,-2.5993,-2.2928,-2.1972,-2.1459,-2.0920,-2.0421,-1.9902,
     2-1.9402,-1.9289,-1.9179,-1.9122,-1.9071,-1.9028,-1.8991,-1.8963,
     3-1.8928,-1.8896,-1.8864,-1.8834,-1.8803,-1.8771,-1.8740,-1.8710,
     4-1.8679,-1.8648,-1.8615,-1.8582,-1.8549,-1.8514,-1.8478,-1.8441,
     5-1.8404,-1.8365,-1.8326,-1.8286,-1.8245,-1.8203,-1.8161,-1.8117,
     6-1.8072,-1.8026,-1.7977,-1.7926,-1.7868,-1.7807,-1.7747,-1.7688,
     7-1.7630,-1.7566,-1.7497,-1.7430,-1.7364,-1.7293,-1.7211,-1.7132,
     8-1.7059,-1.6983,-1.6905,-1.6828,-1.6753,-1.6671,-1.6579,-1.6488,
     9-1.6395,-1.6293,-1.6195,-1.6103,-1.6011,-1.5924,-1.5844,-1.5765/
      data (b1    (i),i=  73, 101)/
     1-1.5687,-1.5615,-1.5551,-1.5484,-1.5415,-1.5342,-1.5263,-1.5179,
     2-1.5091,-1.5004,-1.4918,-1.4823,-1.4729,-1.4638,-1.4538,-1.4430,
     3-1.4318,-1.4202,-1.4073,-1.3940,-1.3804,-1.3647,-1.3487,-1.3293,
     4-1.3085,-1.2842,-1.2584,-1.2034,-0.9500/
c
      data (bp3162(i),i=   1,  72)/
     1-4.8450,-2.6840,-2.3806,-2.2280,-2.2046,-2.1858,-2.1664,-2.1472,
     2-2.1264,-2.1052,-2.0839,-2.0590,-2.0327,-2.0060,-1.9789,-1.9562,
     3-1.9319,-1.9174,-1.9168,-1.9109,-1.9068,-1.9037,-1.8998,-1.8963,
     4-1.8936,-1.8904,-1.8872,-1.8842,-1.8813,-1.8784,-1.8755,-1.8726,
     5-1.8697,-1.8669,-1.8640,-1.8611,-1.8582,-1.8553,-1.8525,-1.8495,
     6-1.8465,-1.8434,-1.8402,-1.8370,-1.8337,-1.8304,-1.8270,-1.8237,
     7-1.8203,-1.8168,-1.8133,-1.8096,-1.8059,-1.8021,-1.7981,-1.7941,
     8-1.7899,-1.7857,-1.7814,-1.7770,-1.7725,-1.7675,-1.7623,-1.7569,
     9-1.7515,-1.7462,-1.7406,-1.7346,-1.7283,-1.7216,-1.7146,-1.7079/
      data (bp3162(i),i=  73, 101)/
     1-1.7016,-1.6951,-1.6885,-1.6817,-1.6744,-1.6665,-1.6575,-1.6487,
     2-1.6404,-1.6317,-1.6225,-1.6113,-1.6005,-1.5901,-1.5788,-1.5684,
     3-1.5584,-1.5474,-1.5366,-1.5255,-1.5129,-1.4981,-1.4837,-1.4656,
     4-1.4445,-1.4210,-1.3915,-1.3465,-1.0800/
c
      data (bp1   (i),i=   1,  72)/
     1-5.5650,-3.3229,-2.9206,-2.6608,-2.5065,-2.3656,-2.2741,-2.2118,
     2-2.2186,-2.2097,-2.2017,-2.1947,-2.1872,-2.1793,-2.1719,-2.1651,
     3-2.1580,-2.1507,-2.1432,-2.1353,-2.1275,-2.1198,-2.1118,-2.1034,
     4-2.0947,-2.0857,-2.0771,-2.0684,-2.0598,-2.0508,-2.0415,-2.0314,
     5-2.0213,-2.0113,-2.0013,-1.9905,-1.9793,-1.9691,-1.9579,-1.9462,
     6-1.9347,-1.9250,-1.9171,-1.9109,-1.9073,-1.9032,-1.8987,-1.8946,
     7-1.8905,-1.8866,-1.8826,-1.8788,-1.8752,-1.8717,-1.8683,-1.8650,
     8-1.8616,-1.8582,-1.8548,-1.8515,-1.8481,-1.8447,-1.8413,-1.8379,
     9-1.8345,-1.8310,-1.8273,-1.8234,-1.8195,-1.8154,-1.8111,-1.8067/
      data (bp1   (i),i=  73, 101)/
     1-1.8023,-1.7979,-1.7939,-1.7896,-1.7851,-1.7801,-1.7749,-1.7693,
     2-1.7631,-1.7570,-1.7508,-1.7446,-1.7381,-1.7312,-1.7239,-1.7162,
     3-1.7079,-1.6989,-1.6891,-1.6786,-1.6680,-1.6551,-1.6432,-1.6265,
     4-1.6095,-1.5876,-1.5566,-1.5169,-1.2600/
c
      data (bp0562(i),i=   1,  72)/
     1-5.8350,-3.8648,-3.5351,-3.2898,-3.1078,-2.9689,-2.8391,-2.7315,
     2-2.6361,-2.5348,-2.4663,-2.4015,-2.3487,-2.2983,-2.2525,-2.2211,
     3-2.2189,-2.2107,-2.2043,-2.1979,-2.1919,-2.1861,-2.1805,-2.1751,
     4-2.1698,-2.1647,-2.1596,-2.1546,-2.1497,-2.1447,-2.1396,-2.1346,
     5-2.1293,-2.1236,-2.1176,-2.1112,-2.1045,-2.0981,-2.0920,-2.0858,
     6-2.0794,-2.0730,-2.0665,-2.0600,-2.0532,-2.0462,-2.0391,-2.0320,
     7-2.0250,-2.0182,-2.0116,-2.0046,-1.9972,-1.9880,-1.9790,-1.9703,
     8-1.9620,-1.9538,-1.9454,-1.9369,-1.9287,-1.9209,-1.9139,-1.9076,
     9-1.9018,-1.8966,-1.8917,-1.8868,-1.8821,-1.8775,-1.8727,-1.8679/
      data (bp0562(i),i=  73, 101)/
     1-1.8630,-1.8581,-1.8533,-1.8485,-1.8435,-1.8383,-1.8331,-1.8277,
     2-1.8222,-1.8165,-1.8105,-1.8042,-1.7978,-1.7914,-1.7847,-1.7773,
     3-1.7696,-1.7618,-1.7535,-1.7441,-1.7344,-1.7243,-1.7123,-1.6985,
     4-1.6827,-1.6614,-1.6358,-1.6013,-1.4100/
c
      data (bp0316(i),i=   1,  72)/
     1-6.0000,-4.3754,-4.0199,-3.8200,-3.7033,-3.5980,-3.5020,-3.4185,
     2-3.3473,-3.2723,-3.2099,-3.1492,-3.0856,-3.0243,-2.9657,-2.9068,
     3-2.8452,-2.7925,-2.7492,-2.7084,-2.6691,-2.6293,-2.5915,-2.5520,
     4-2.5164,-2.4861,-2.4598,-2.4214,-2.3917,-2.3675,-2.3414,-2.3155,
     5-2.2926,-2.2695,-2.2486,-2.2311,-2.2229,-2.2160,-2.2084,-2.2014,
     6-2.1955,-2.1893,-2.1831,-2.1770,-2.1710,-2.1652,-2.1595,-2.1540,
     7-2.1487,-2.1433,-2.1379,-2.1325,-2.1272,-2.1221,-2.1168,-2.1111,
     8-2.1052,-2.0993,-2.0936,-2.0879,-2.0819,-2.0756,-2.0693,-2.0632,
     9-2.0569,-2.0499,-2.0422,-2.0358,-2.0300,-2.0240,-2.0171,-2.0097/
      data (bp0316(i),i=  73, 101)/
     1-2.0018,-1.9936,-1.9854,-1.9771,-1.9688,-1.9600,-1.9508,-1.9417,
     2-1.9326,-1.9235,-1.9141,-1.9045,-1.8953,-1.8868,-1.8788,-1.8708,
     3-1.8628,-1.8541,-1.8447,-1.8343,-1.8237,-1.8130,-1.8026,-1.7892,
     4-1.7750,-1.7563,-1.7324,-1.6974,-1.5450/
c
      data (bp01  (i),i=   1,  72)/
     1-6.0000,-4.8595,-4.5967,-4.3824,-4.2552,-4.1625,-4.0737,-3.9967,
     2-3.9408,-3.8896,-3.8435,-3.8031,-3.7626,-3.7228,-3.6748,-3.6359,
     3-3.5959,-3.5663,-3.5251,-3.4871,-3.4520,-3.4149,-3.3843,-3.3497,
     4-3.3148,-3.2805,-3.2533,-3.2202,-3.1875,-3.1571,-3.1335,-3.1064,
     5-3.0807,-3.0517,-3.0245,-2.9964,-2.9659,-2.9334,-2.9101,-2.8840,
     6-2.8561,-2.8277,-2.8073,-2.7816,-2.7599,-2.7352,-2.7145,-2.6912,
     7-2.6678,-2.6463,-2.6281,-2.6116,-2.5942,-2.5759,-2.5591,-2.5433,
     8-2.5271,-2.5124,-2.4976,-2.4805,-2.4666,-2.4526,-2.4385,-2.4266,
     9-2.4147,-2.3979,-2.3834,-2.3727,-2.3613,-2.3500,-2.3391,-2.3257/
      data (bp01  (i),i=  73, 101)/
     1-2.3123,-2.3018,-2.2918,-2.2801,-2.2686,-2.2583,-2.2481,-2.2369,
     2-2.2272,-2.2172,-2.2065,-2.1959,-2.1864,-2.1782,-2.1680,-2.1575,
     3-2.1476,-2.1379,-2.1267,-2.1137,-2.1032,-2.0909,-2.0766,-2.0628,
     4-2.0486,-2.0314,-2.0159,-2.0049,-1.9950/
c
      data (bp0031(i),i=   1,  72)/
     1-5.9700,-4.6929,-4.3990,-4.2425,-4.1356,-4.0332,-3.9660,-3.8949,
     2-3.8304,-3.7688,-3.7169,-3.6737,-3.6273,-3.5884,-3.5557,-3.5229,
     3-3.4920,-3.4616,-3.4364,-3.4106,-3.3843,-3.3585,-3.3366,-3.3132,
     4-3.2880,-3.2680,-3.2469,-3.2270,-3.2078,-3.1916,-3.1740,-3.1582,
     5-3.1406,-3.1240,-3.1063,-3.0898,-3.0746,-3.0571,-3.0408,-3.0239,
     6-3.0081,-2.9925,-2.9782,-2.9627,-2.9491,-2.9376,-2.9232,-2.9080,
     7-2.8942,-2.8809,-2.8671,-2.8531,-2.8386,-2.8259,-2.8145,-2.8036,
     8-2.7937,-2.7821,-2.7705,-2.7595,-2.7495,-2.7386,-2.7270,-2.7172,
     9-2.7070,-2.6968,-2.6877,-2.6785,-2.6692,-2.6613,-2.6530,-2.6443/
      data (bp0031(i),i=  73, 101)/
     1-2.6363,-2.6292,-2.6224,-2.6161,-2.6093,-2.6011,-2.5932,-2.5856,
     2-2.5778,-2.5698,-2.5621,-2.5559,-2.5514,-2.5493,-2.5499,-2.5469,
     3-2.5443,-2.5420,-2.5441,-2.5417,-2.5400,-2.5359,-2.5318,-2.5277,
     4-2.5459,-2.5165,-2.4892,-2.4957,-2.4900/
c
      data (bp001 (i),i=   1,  72)/
     1-5.9850,-5.1259,-4.7905,-4.6308,-4.5046,-4.4151,-4.3397,-4.2776,
     2-4.2149,-4.1610,-4.1200,-4.0755,-4.0367,-4.0016,-3.9719,-3.9407,
     3-3.9117,-3.8837,-3.8628,-3.8415,-3.8155,-3.7932,-3.7737,-3.7555,
     4-3.7371,-3.7169,-3.6987,-3.6821,-3.6648,-3.6482,-3.6302,-3.6162,
     5-3.6020,-3.5872,-3.5738,-3.5603,-3.5474,-3.5349,-3.5223,-3.5101,
     6-3.4977,-3.4837,-3.4705,-3.4584,-3.4471,-3.4376,-3.4248,-3.4126,
     7-3.4016,-3.3915,-3.3813,-3.3704,-3.3587,-3.3494,-3.3390,-3.3278,
     8-3.3160,-3.3064,-3.2967,-3.2868,-3.2768,-3.2670,-3.2573,-3.2475,
     9-3.2378,-3.2284,-3.2184,-3.2068,-3.1939,-3.1828,-3.1734,-3.1659/
      data (bp001 (i),i=  73, 101)/
     1-3.1594,-3.1534,-3.1483,-3.1440,-3.1402,-3.1370,-3.1335,-3.1301,
     2-3.1269,-3.1238,-3.1208,-3.1180,-3.1153,-3.1141,-3.1133,-3.1100,
     3-3.1062,-3.1020,-3.0973,-3.0925,-3.0877,-3.0827,-3.0774,-3.0721,
     4-3.0656,-3.0569,-3.0656,-2.9693,-3.0000/
c

      data hx/0.01d0/, hy/0.5d0/
c            zero de rate
       data zr/.795, .825, .840, .845, .8225,
     *          .755, .645, .585,  .535, .505, .485, .475,
     *          .460, .455, .452, .450, .450/
c
c
         el=log10(e)
         call kintp3(zr, 1, nes, -3.d0, .25d0, el, rr)
         call rndc(u)
         if(u .lt. rr) then
            de=0.
         else
            call rndc(u)
            call k4ptdi(b, 101, ne, 101, 0.d0, -3.d0, hx, hy,
     *      u, el, f)
            de=10.d0**f
         endif
      end
