      subroutine cedP5F1S35(k, c,  cs, e, de, eqvp)
      implicit none
c       random samples the energy deposit by a 
c       particle falling on detector cosisting of
c       Pb0.5cm, Fe 0.1cm, Scinti 3.5 cm
c
      integer k ! input. particle id. 1==> gamma, 2==>electron
      integer c ! input. charge of the electron, -1 or 1 (positron)
      real*8 cs ! input. cosine angle of incident particle to the
                !        detector. 
                !        should be > 0.65 unlsess assumed to be
                !        0.65
      real*8 e  ! input. total energy of the particle in GeV
      real*8 de ! output. energy deposited in Scintilator. GeV
      real*8 eqvp ! output.  equivalen particle number converted
                  !   by reference to the energy deposit by
                  !   a vertical muon.
c          In this version, e < 1MeV is neglected and
c        de= eqvp =0 will result. If e > 1 GeV, result 
c        by 1 GeV is return.   
      real*8 ex, e1, e2, csinp
      real*8 singlede
      logical first/.true./
      save first, singlede
c             get vertical single muon energy depostit
      if(first) then
         call ciP5F1S35C99(csinp, e1, e2, singlede)
         first = .false.
      endif

      if(e .lt. 1.e-3) then
         de = 0.
      else
         ex = min(e, 1.d0)
         if( cs .gt. .95d0) then
            if(k .eq. 1) then
               call cgP5F1S35C99(ex, de)
            elseif(k .eq. 2) then
               if(c .eq. -1) then
                  call cemP5F1S35C99(ex, de)
               elseif(c .eq. 1) then
                  call cepP5F1S35C99(ex, de)
               else
                  write(*,*) 'error input to cedP5F1S35 c=', c
                  stop 9999
               endif
            else
              write(*, *) ' error input to edP5F1S35 k=', k
              stop 9999
            endif
         elseif(cs .gt. .85d0) then
            if(k .eq. 1) then
               call cgP5F1S35C90(ex, de)
            elseif(k .eq. 2) then
               if(c .eq. -1) then
                  call cemP5F1S35C90(ex, de)
               elseif(c .eq. 1) then
                  call cepP5F1S35C90(ex, de)
               else
                  write(*,*) 'error input to cedP5F1S35 c=', c
                  stop 9999
               endif
            else
              write(*, *) ' error input to edP5F1S35 k=', k
              stop 9999
            endif
         elseif(cs .gt. .75d0) then
            if(k .eq. 1) then
               call cgP5F1S35C80(ex, de)
            elseif(k .eq. 2) then
               if(c .eq. -1) then
                  call cemP5F1S35C80(ex, de)
               elseif(c .eq. 1) then
                  call cepP5F1S35C80(ex, de)
               else
                  write(*,*) 'error input to cedP5F1S35 c=', c
                  stop 9999
               endif
            else
              write(*, *) ' error input to edP5F1S35 k=', k
              stop 9999
            endif
         else
            if(k .eq. 1) then
               call cgP5F1S35C70(ex, de)
            elseif(k .eq. 2) then
               if(c .eq. -1) then
                  call cemP5F1S35C70(ex, de)
               elseif(c .eq. 1) then
                  call cepP5F1S35C70(ex, de)
               else
                  write(*,*) 'error input to cedP5F1S35 c=', c
                  stop 9999
               endif
            else
              write(*, *) ' error input to edP5F1S35 k=', k
              stop 9999
            endif
         endif
      endif
      eqvp = de/singlede
      end


           
