#include "ZcosmosBD.h"
c               this is generic test routine for interaction code
c         inside Comsos.  h-A/ A'-A collision can be tested.
c        
          implicit none

#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zmass.h"
#include  "Zmanagerp.h"
#include  "Zmanager.h"
#include  "Ztrackp.h"

          integer nmax
          external cblkManager
          external cblkEvhnp
          integer code, subcode, charge, klena
          real*8 roots, pabs
          character*1  NULL

          parameter (nmax =8000)   ! # of max ptcls supposed to be generated
          record /ptcl/ pj, tg, pj2, a(nmax), cmspj, cmstg
          record /ptcl/ compj, comtg
c             projectile and target information (both befor
c             and after collision ) in different system.
c
          integer k, icon, ntp, j, nevent, nuccharge
          real*8 x, y, eta, ek1
          integer NEVTS,NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,IEMU
          real*8 EPN
          real*4  x2, y2, z2
          real*4  ext/10./


          real*8  energy
          real pt, ptx, pty, ke, teta
          character*100  msg
          character*100  tracefile
          character*80  prefix
          character*16 uid
          character*16 input
          integer ia, iz, leng, kgetenv
          logical lroots, cms, xbyp
c
          record /fmom/ rest
 

          call creadParam(5)


          rest.p(1) = 0.
          rest.p(2) = 0.
          rest.p(3) = 0.
          rest.p(4) = 0.
c
c           get additional parameters written in user hookc
c
          call cqUHookc(1, msg)
          read(msg, *) lroots, code, subcode, charge, energy,
     *              ia, iz, cms, xbyp
          call cqUHookc(2, input)
          call cqUHookc(3, prefix)
c          write(ErrorOut,*) input

          if(DestEventNo(2) .eq. 0) then
             nevent =abs( DestEventNo(1))
          else
             nevent = abs(DestEventNo(2))
          endif

          if(Trace .eq. 0) then
             write(*,
     *      '(a,l2, a,i2, a,i3, a,i2, a,g13.3, a,l3, a,i2,'//
     *      ' a,l2, a,l2, a, a, a)')
     *      '# "roots=',lroots, ' proj.code=',code, ' subcode=',
     *      subcode, ' chg=',charge, '  E=',energy,' target A=',
     *      ia, ' Z=',iz, ' cms=',cms, ' xbyp=',xbyp,
     *      ' intmodel=', IntModel(1:klena(IntModel)),
     *      '"' 
            write(*, '(a)') 
     *     '# "x" "y" "eta" "pt" "code" "subcode" "charge"'//
     *     ' "mult" "teta" "K.E" "ev#"'
c           defalut trace.  fix the dirctor
         else
          if(TraceDir .eq. ' ') then
             call cgetLoginN(uid)
             TraceDir = '/tmp/'//uid(1:klena(uid))
          endif
         endif
c
cc             make incident
          call cmkptc(code, subcode,charge,  pj)
c            cms is for h-p
          if(lroots) then
             roots = energy
             if(pj.code .ne. kgnuc) then
                energy = ( roots**2 - pj.mass**2 - masp**2) /
     *                   (2*masp)
             else
                energy = ( roots**2/(2*masp) -  masp ) * subcode
             endif
          endif
c              set projectile energy and momentum
          pj.fm.p(1) =0.
          pj.fm.p(2) =0.
          pj.fm.p(4) = energy
          pj.fm.p(3) = sqrt(pj.fm.p(4)**2-pj.mass**2)
c
c           to form a CMS, once make proton target and h or p proj.
          call cmkptc(knuc, -1, 1,  tg)
          tg.fm = rest
          tg.fm.p(4) = tg.mass
          pj2 = pj
          if(pj.code .eq. kgnuc) then
             pj2.code = knuc
             pj2.charge = 1
             pj2.subcode = -1
             pj2.fm.p(4) = energy/subcode
             pj2.mass = masp
             pj2.fm.p(3) = sqrt(pj2.fm.p(4)**2-pj2.mass**2)
          endif

c             initialize. we are using as if from Comsos
          if(input .eq. ' ') then
             call cintModels('cosmos')
          else
             if(prefix .eq. ' ' ) then
                NULL = char(0)
                leng = kgetenv("EPICSTOP"//NULL, prefix)
                if(leng .eq. 0) then
                   call cerrorMsg('EPICSTOP is not given', 0)
                endif
c                        the last / is needed.
                prefix = prefix(1:leng)//'/Data/Media/'
             endif
             call cfixPrefix(prefix)
             call cintModels('check')
             if( index(IntModel, 'dpmjet3') .gt. 0) then
                call copenf(
     *           TempDev, input(1:klena(input))//".inp", icon)
                if(icon .ne. 0) then
                   call cerrorMsg('cannot open file', 1)
                   call cerrorMsg(input, 0)
                endif
                CALL DT_DTUINI(
     *            NEVTS,EPN,NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,IEMU)
                close(TempDev)
             endif
          endif

c              This is to form  Cmsp
          call chncol(pj2, tg, a, ntp, icon)

          call rnd1i(InitRn)     ! random number init.
c             fix model by seeing the proj. energy.
          call cfixModel(pj)
          if(cms) then
             call cbst1(1, Cmsp,  pj, cmspj)
             ek1 = cmspj.fm.p(3)
             compj = cmspj
             call cbst1(2, Cmsp,  tg, cmstg)
             comtg = cmstg
          else
             compj = pj
             comtg = tg
             if(xbyp) then
                ek1 = pj.fm.p(3)
             else
                ek1 = pj.fm.p(4) -  pj.mass
             endif
          endif

          if(pj.code .eq. kgnuc ) then
             ek1 = ek1 / pj.subcode
          endif

          if(SeedFile .ne. ' ') then
             call copenfw(SeedFileDev, SeedFile, icon)
             if(icon .ne. 0) then
                call cerrorMsg(' SeedFile open error' ,0)
             endif
          endif
          k = 1
          do while(k .le.  nevent)
             if(SeedFile .ne. ' ') then
                call rnd1s(SeedSave)
                EventNo = k
                call cwriteSeed
             endif
             if(pj.code .ne. kgnuc) then
                call chAcol(pj, ia, iz, a, ntp)
             else
                call cheavyInt(pj, ia, iz, a, ntp)
             endif
             if(Trace .ne. 0) then
                tracefile = ' '
                write(tracefile, *)
     *             TraceDir(1:klena(TraceDir))//'/trace', k
                call kseblk(tracefile, ' ', leng)
                call copenfw(TraceDev,
     *          tracefile(1:klena(tracefile)), icon)
c                   draw projectile 
                call cvisualizeTrack(compj, 1, ext)
                call cvisualizeTrack(comtg, 1, ext)
             endif

             do j = 1, ntp
                if(cms) then
                   call cbst1(j, Cmsp, a(j), a(j))
                endif
                if(Trace .eq. 0 ) then
                   ptx = sngl(a(j).fm.p(1))
                   pty = sngl(a(j).fm.p(2))
                   if(xbyp) then
                      x =  a(j).fm.p(3) / ek1 
                   else
                      x =( a(j).fm.p(4)- a(j).mass)/ek1
                   endif

                   pt =sqrt(a(j).fm.p(1)**2 + a(j).fm.p(2)**2)
                   teta = atan2( pt, sngl(a(j).fm.p(3)) ) *
     *               180./3.1415
                   ke = a(j).fm.p(4)-a(j).mass
                   if(.not. cms) then
c                    transform to CMS.  for y, eta, even if not cms 
                      call cbst1(j, Cmsp,  a(j), a(j))
                      call cyeta(a(j), y, eta)
                   endif

                   write(*, '(4g13.3, 3i3, i5, 2g13.3, i8)' )
     *               sngl(x), sngl(y),  sngl(eta),  pt, 
     *               a(j).code, a(j).subcode, a(j).charge,
     *               ntp, teta,
     *               ke,  k
                else
                   call cvisualizeTrack(a(j), 0, ext*0.35)
                endif
             enddo
             if(Trace .ne. 0 ) then
                close(TraceDev)
             endif
             k = k + 1
          enddo   
          if(Trace .ne. 0) then
             call cerrorMsg(
     *      'Use gnuplot with "set para"; "splot filename w l"',
     *       1)
             call cerrorMsg(
     *      ' You can also use "slide" command in Util', 1) 
          endif
       end
      subroutine cvisualizeTrack(pp, inout, ext)
      implicit none
#include "Zptcl.h"
#include "Ztrackp.h"
      record /ptcl/ pp   ! input. a particle
      integer inout      ! input. 1.specifis  output order.
      real*4  ext       ! input. track length to be drawn 

      real*8 pabs
      real*4 x2, y2, z2
c               
      call cpxyzp(pp.fm, pabs) 
      if(pabs .eq. 0.) pabs = 1.


      x2 = pp.fm.p(1)/pabs*ext
      y2 = pp.fm.p(2)/pabs*ext
      z2 = pp.fm.p(3)/pabs*ext

      if(inout .eq. 0) then
         write(TraceDev, *)
     *     0., 0., 0., pp.code, sngl(pp.fm.p(4)), pp.charge
         write(TraceDev, *) 
     *     x2, y2, z2, pp.code, sngl(pp.fm.p(4)), pp.charge
      else
         write(TraceDev, *) 
     *     -x2, -y2, -z2, pp.code, sngl(pp.fm.p(4)), pp.charge
         write(TraceDev, *)
     *     0., 0., 0., pp.code, sngl(pp.fm.p(4)), pp.charge
      endif
      write(TraceDev, *)
      write(TraceDev, *)
      end




