      subroutine cbremsPath(Ee, path)
c          generic brems sampling routine
      implicit none
#include "ZbpCnst.h"
c      entry cBrSampP(Ee, prob, path)


      real*8 Ee            ! input. Electron/positron energy in GeV
      real*8 prob          ! output. Brems prob. per r.l
      real*8 path          ! ouptut. sampled path in r.l

      real*8 u

      if(Ee .le. BrEemaxS) then
c            Seltzer region
         call cBrSSampP(Ee,  prob)
      elseif(Ee .le. CompScrE) then
c            screeinig region
         call cBrLSampP(Ee,  prob)
      elseif(Ee .le. BremEemaxL) then
c            complete screeing region
         call cBrCSampP(Ee, prob)
      else
c         LPM region;
c         call cBrHSampP(Ee, prob); this cannot be used due to rho change.
c         should not come here; LPM routine is called
c         from outer place. However, control may come here
c         because of small BremEemaxL ~ 94 GeV. 
c         If you are very serious about LPM, the effect may
c         be seen in 100 GeV region at very small gamma energies
c         However, the effect in air shower development could be
c         seen  at  least > 10^15 eV. Therefore  we use complete
c         screening cross section.
c         
         call cBrCSampP(Ee, prob)
      endif
      call rndc(u)
      path = - log(u)/prob
      end
c     *********************************** 
      subroutine cbremsEnergy(Ee, Eg)
      implicit none
#include "ZbpCnst.h"


      real*8 Ee            ! input. e-/e+ energy in GeV
      real*8 Eg            ! output. sampled Eg in GeV



      if(Ee .le. BrEemaxS) then
c            Seltzer region
         call cBrSSampE(Ee,  Eg)

      elseif(Ee .le. CompScrE) then
c            screeinig region
         call cBrLSampE(Ee,  Eg)

      elseif(Ee .le. BremEemaxL) then
c            complete screeing region
         call cBrCSampE(Ee, Eg)

      else
c            LPM region; same as path part. should not come
c         call cBrHSampE(Ee, Eg)
        call cBrCSampE(Ee, Eg)
      endif
      end
      block data cbpcnst
#include "ZbpCnst.h"
#include "ZbpTable.h"
      integer i


c          mb to /X0=
      data  mbtoPX0/  7.603928622358070E-004/
      data  X0g/  36.5667177404807/
c         #-#-#-#-#-#-#-#-#-#-#-#-

c       consts for Seltzer Brems sampling table 
      data  BrEeminS /  7.110000000000000E-004/
      data  BrEgminS /  1.000000000000000E-005/
      data  BrLEeminS / -3.14813039927023/
      data  BrEemaxS /  .100000000000000/
      data  BrUminSA /  .100000000000000/
      data  BrUmaxSA /  1.00000000000000/
      data  BrTXTS /  21/
      data  BrdUSA /  4.736842105263160E-002/
      data  BrdETXS /  .107406519963512/
      data  BrdES /  .107406519963512/
      data  BrUminSB /  .000000000000000/
      data  BrUmaxSB /  .562341325190349/
      data  BrdUSB /  2.811706625951750E-002/
      data  BrES /  21/
      data  BrUszSA /  20/
      data  BrUszSB /  21/


c    consts for Brems sampling table at low energies
      data  CompScrE /  77.0769320180599/
      data  BremEgmin /  1.000000000000000E-004/
      data  BremEemin /  1.000000000000000E-002/
      data  BremLEemin / -2.00000000000000/
      data  BremEemaxL /  94.1908705778637/
      data  BrScrE /  77.0769320180599/
      data  BremUminLA /  .100000000000000/
      data  BremUmaxLA /  1.00000000000000/
      data  BremTXTL /  38/
      data  BremdULA /  4.736842105263160E-002/
      data  BremdETXL /  .105052011340642/
      data  BremdEL /  .105052011340642/
      data  BremUminLB /  .000000000000000/
      data  BremUmaxLB /  .562341325190349/
      data  BremdULB /  2.811706625951750E-002/
      data  BremEsize /  38/
      data  BremUszLA /  20/
      data  BremUszLB /  21/


      data cScrMain/  769.871686272023/
      data cScrC1/  567.318764704017/


c   Brem at Seltzer table region: TX
          data ( BrTXS(i), i=  1,   21)/
     1   3.5802    ,  3.4380    ,  3.6693    ,  4.0594    ,
     2   4.5289    ,  5.0582    ,  5.6188    ,  6.1801    ,
     3   6.7399    ,  7.2933    ,  7.8203    ,  8.3134    ,
     4   8.8252    ,  9.3138    ,  9.7910    ,  10.257    ,
     5   10.708    ,  11.145    ,  11.567    ,  11.972    ,
     6   11.425                                                         
     * /   


c  Brem at Selzer table region; Region A
          data ( BrSTSA(i,   1), i=  1,   20)/
     1     2.53937,    2.44152,    2.36503,    2.30265,    2.25038,
     2     2.20553,    2.16664,    2.13233,    2.10205,    2.07478,
     3     2.05004,    2.02778,    2.00760,    1.98918,    1.97232,
     4     1.95685,    1.94261,    1.92955,    1.91742,    1.90612      
     * /   
          data ( BrSTSA(i,   2), i=  1,   20)/
     1     3.03865,    2.91910,    2.82803,    2.75546,    2.69547,
     2     2.64516,    2.60153,    2.56361,    2.53047,    2.50075,
     3     2.47404,    2.45000,    2.42833,    2.40876,    2.39094,
     4     2.37482,    2.36000,    2.34653,    2.33427,    2.32282      
     * /   
          data ( BrSTSA(i,   3), i=  1,   20)/
     1     3.41204,    3.27971,    3.18019,    3.10153,    3.03785,
     2     2.98470,    2.93983,    2.90032,    2.86547,    2.83470,
     3     2.80748,    2.78331,    2.76176,    2.74249,    2.72519,
     4     2.70964,    2.69553,    2.68278,    2.67139,    2.66074      
     * /   
          data ( BrSTSA(i,   4), i=  1,   20)/
     1     3.74577,    3.60543,    3.50079,    3.41951,    3.35380,
     2     3.29953,    3.25218,    3.21099,    3.17520,    3.14403,
     3     3.11677,    3.09284,    3.07173,    3.05301,    3.03641,
     4     3.02163,    3.00828,    2.99641,    2.98572,    2.97602      
     * /   
          data ( BrSTSA(i,   5), i=  1,   20)/
     1     4.06289,    3.91897,    3.81198,    3.72853,    3.66146,
     2     3.60521,    3.55699,    3.51535,    3.47924,    3.44783,
     3     3.42037,    3.39633,    3.37516,    3.35648,    3.33998,
     4     3.32524,    3.31226,    3.30057,    3.29029,    3.28077      
     * /   
          data ( BrSTSA(i,   6), i=  1,   20)/
     1     4.37081,    4.22375,    4.11468,    4.03004,    3.96192,
     2     3.90450,    3.85556,    3.81369,    3.77772,    3.74677,
     3     3.72001,    3.69679,    3.67655,    3.65889,    3.64337,
     4     3.62974,    3.61773,    3.60711,    3.59777,    3.58936      
     * /   
          data ( BrSTSA(i,   7), i=  1,   20)/
     1     4.67264,    4.52419,    4.41439,    4.32944,    4.26042,
     2     4.20220,    4.15288,    4.11106,    4.07552,    4.04517,
     3     4.01923,    3.99693,    3.97772,    3.96109,    3.94667,
     4     3.93408,    3.92306,    3.91355,    3.90508,    3.89763      
     * /   
          data ( BrSTSA(i,   8), i=  1,   20)/
     1     4.97361,    4.82687,    4.71775,    4.63229,    4.56147,
     2     4.50154,    4.45100,    4.40847,    4.37260,    4.34232,
     3     4.31666,    4.29484,    4.27625,    4.26029,    4.24658,
     4     4.23481,    4.22457,    4.21580,    4.20802,    4.20131      
     * /   
          data ( BrSTSA(i,   9), i=  1,   20)/
     1     5.27056,    5.12584,    5.01794,    4.93237,    4.86030,
     2     4.79913,    4.74774,    4.70479,    4.66893,    4.63896,
     3     4.61380,    4.59263,    4.57474,    4.55957,    4.54666,
     4     4.53568,    4.52628,    4.51813,    4.51120,    4.50518      
     * /   
          data ( BrSTSA(i,   10), i=  1,   20)/
     1     5.56384,    5.42025,    5.31287,    5.22687,    5.15325,
     2     5.09062,    5.03824,    4.99478,    4.95885,    4.92908,
     3     4.90437,    4.88377,    4.86654,    4.85214,    4.83998,
     4     4.82972,    4.82101,    4.81353,    4.80740,    4.80187      
     * /   
          data ( BrSTSA(i,   11), i=  1,   20)/
     1     5.85658,    5.71580,    5.61011,    5.52429,    5.44931,
     2     5.38521,    5.33179,    5.28778,    5.25171,    5.22214,
     3     5.19784,    5.17781,    5.16124,    5.14749,    5.13603,
     4     5.12647,    5.11836,    5.11166,    5.10581,    5.10107      
     * /   
          data ( BrSTSA(i,   12), i=  1,   20)/
     1     6.14844,    6.01012,    5.90636,    5.82216,    5.74917,
     2     5.68512,    5.62970,    5.58263,    5.54320,    5.51039,
     3     5.48328,    5.46086,    5.44228,    5.42695,    5.41422,
     4     5.40360,    5.39478,    5.38746,    5.38107,    5.37602      
     * /   
          data ( BrSTSA(i,   13), i=  1,   20)/
     1     6.43392,    6.29650,    6.19277,    6.10742,    6.03233,
     2     5.96602,    5.90886,    5.86075,    5.82087,    5.78812,
     3     5.76135,    5.73951,    5.72161,    5.70700,    5.69505,
     4     5.68515,    5.67704,    5.67029,    5.66458,    5.66003      
     * /   
          data ( BrSTSA(i,   14), i=  1,   20)/
     1     6.71483,    6.57756,    6.47320,    6.38612,    6.30871,
     2     6.24042,    6.18209,    6.13360,    6.09398,    6.06185,
     3     6.03595,    6.01505,    5.99816,    5.98454,    5.97343,
     4     5.96440,    5.95707,    5.95108,    5.94615,    5.94200      
     * /   
          data ( BrSTSA(i,   15), i=  1,   20)/
     1     6.99254,    6.85486,    6.74943,    6.66019,    6.58025,
     2     6.51008,    6.45085,    6.40232,    6.36321,    6.33196,
     3     6.30706,    6.28720,    6.27140,    6.25871,    6.24861,
     4     6.24041,    6.23380,    6.22848,    6.22424,    6.22054      
     * /   
          data ( BrSTSA(i,   16), i=  1,   20)/
     1     7.26682,    7.12820,    7.02129,    6.92951,    6.84691,
     2     6.77497,    6.71507,    6.66672,    6.62831,    6.59801,
     3     6.57419,    6.55544,    6.54067,    6.52902,    6.51969,
     4     6.51232,    6.50642,    6.50178,    6.49804,    6.49480      
     * /   
          data ( BrSTSA(i,   17), i=  1,   20)/
     1     7.53772,    7.39773,    7.28898,    7.19453,    7.10944,
     2     7.03612,    6.97598,    6.92819,    6.89078,    6.86166,
     3     6.83907,    6.82150,    6.80781,    6.79712,    6.78874,
     4     6.78205,    6.77690,    6.77269,    6.76945,    6.76670      
     * /   
          data ( BrSTSA(i,   18), i=  1,   20)/
     1     7.80544,    7.66391,    7.55337,    7.45642,    7.36935,
     2     7.29532,    7.23562,    7.18889,    7.15281,    7.12514,
     3     7.10389,    7.08760,    7.07500,    7.06532,    7.05778,
     4     7.05187,    7.04736,    7.04362,    7.04073,    7.03854      
     * /   
          data ( BrSTSA(i,   19), i=  1,   20)/
     1     8.07084,    7.92822,    7.81636,    7.71762,    7.62949,
     2     7.55569,    7.49715,    7.45199,    7.41762,    7.39158,
     3     7.37185,    7.35689,    7.34548,    7.33678,    7.33011,
     4     7.32489,    7.32088,    7.31784,    7.31547,    7.31344      
     * /   
          data ( BrSTSA(i,   20), i=  1,   20)/
     1     8.33546,    8.19209,    8.07930,    7.97927,    7.89080,
     2     7.81790,    7.76094,    7.71768,    7.68520,    7.66091,
     3     7.64271,    7.62907,    7.61880,    7.61106,    7.60520,
     4     7.60066,    7.59728,    7.59453,    7.59258,    7.59090      
     * /   
          data ( BrSTSA(i,   21), i=  1,   20)/
     1     8.71166,    8.61538,    8.55397,    8.51336,    8.48587,
     2     8.46692,    8.45373,    8.44445,    8.43787,    8.43318,
     3     8.42981,    8.42739,    8.42565,    8.42435,    8.42341,
     4     8.42269,    8.42225,    8.42187,    8.42141,    7.26833      
     * /   


c  Brem at Seltzer table regtion: Region B
          data ( BrSTSB(i,   1), i=  1,   21)/
     1    17.97887,   18.02931,   17.97400,   17.93393,   17.84044,
     2    17.64619,   17.31611,   16.82602,   16.17082,   15.35964,
     3    14.46280,   13.53011,   12.61029,   11.73132,   10.90742,
     4    10.14107,    9.43134,    8.77368,    8.16725,    7.61092,
     5     7.10308                                                      
     * /   
          data ( BrSTSB(i,   2), i=  1,   21)/
     1    41.36751,   41.37673,   41.27908,   40.90168,   39.96817,
     2    38.25566,   35.81916,   32.90948,   29.90071,   27.00655,
     3    24.34608,   21.95558,   19.82875,   17.94418,   16.27124,
     4    14.78228,   13.46140,   12.29284,   11.25803,   10.34172,
     5     9.52815                                                      
     * /   
          data ( BrSTSB(i,   3), i=  1,   21)/
     1    72.11397,   72.03162,   71.66522,   70.00726,   66.21676,
     2    60.38239,   53.64432,   47.08627,   41.24181,   36.20489,
     3    31.90698,   28.23086,   25.06290,   22.32292,   19.95358,
     4    17.90846,   16.14241,   14.61277,   13.28467,   12.12578,
     5    11.11139                                                      
     * /   
          data ( BrSTSB(i,   4), i=  1,   21)/
     1   104.40202,  104.31140,  103.15126,   98.68880,   89.66355,
     2    78.02751,   66.64538,   56.84243,   48.79154,   42.20146,
     3    36.72394,   32.12067,   28.23703,   24.95486,   22.17702,
     4    19.81780,   17.80304,   16.07401,   14.58144,   13.28736,
     5    12.15908                                                      
     * /   
          data ( BrSTSB(i,   5), i=  1,   21)/
     1   135.46644,  135.31307,  132.82840,  123.75075,  107.84985,
     2    90.22191,   74.87943,   62.66811,   53.12071,   45.50731,
     3    39.28747,   34.15285,   29.90430,   26.37398,   23.41761,
     4    20.92207,   18.79946,   16.97939,   15.40919,   14.04647,
     5    12.85768                                                      
     * /   
          data ( BrSTSB(i,   6), i=  1,   21)/
     1   162.35502,  161.96019,  157.55448,  142.82321,  119.96352,
     2    97.34255,   79.12825,   65.35412,   54.91691,   46.75064,
     3    40.21120,   34.90558,   30.56919,   26.98792,   24.00059,
     4    21.48307,   19.34155,   17.50326,   15.91499,   14.53469,
     5    13.32855                                                      
     * /   
          data ( BrSTSB(i,   7), i=  1,   21)/
     1   188.61658,  187.64402,  180.24647,  158.08130,  128.06833,
     2   101.37166,   81.07858,   66.23056,   55.20833,   46.77713,
     3    40.17771,   34.91394,   30.64609,   27.13169,   24.19784,
     4    21.72239,   19.61077,   17.79358,   16.21921,   14.84806,
     5    13.64697                                                      
     * /   
          data ( BrSTSB(i,   8), i=  1,   21)/
     1   212.56003,  210.84014,  198.57698,  167.84827,  131.88230,
     2   102.48969,   80.97573,   65.53824,   54.26303,   45.84242,
     3    39.39275,   34.32347,   30.23883,   26.88059,   24.07224,
     4    21.69201,   19.65347,   17.89031,   16.35527,   15.01091,
     5    13.82910                                                      
     * /   
          data ( BrSTSB(i,   9), i=  1,   21)/
     1   236.25350,  233.44817,  213.69389,  173.71995,  132.98722,
     2   101.77139,   79.63096,   63.98034,   52.74974,   44.51416,
     3    38.30249,   33.47372,   29.60562,   26.43097,   23.77228,
     4    21.51185,   19.56715,   17.87679,   16.39704,   15.09451,
     5    13.94420                                                      
     * /   
          data ( BrSTSB(i,   10), i=  1,   21)/
     1   259.55868,  255.85083,  225.47642,  176.00882,  131.65416,
     2    99.60304,   77.38799,   61.90204,   50.93455,   42.98718,
     3    37.04882,   32.47671,   28.84269,   25.86804,   23.37425,
     4    21.24495,   19.40284,   17.79227,   16.37598,   15.12465,
     5    14.01674                                                      
     * /   
          data ( BrSTSB(i,   11), i=  1,   21)/
     1   281.75440,  276.90709,  233.54268,  175.30933,  128.06342,
     2    95.95991,   74.29512,   59.38335,   48.89022,   41.31177,
     3    35.67584,   31.36855,   27.96462,   25.18976,   22.86643,
     4    20.87834,   19.15198,   17.63489,   16.29237,   15.09955,
     5    14.03774                                                      
     * /   
          data ( BrSTSB(i,   12), i=  1,   21)/
     1   302.50588,  295.28362,  238.50186,  173.46646,  124.15695,
     2    92.16869,   70.97471,   56.59414,   46.63074,   39.47401,
     3    34.19043,   30.17218,   27.01336,   24.44455,   22.29344,
     4    20.44981,   18.84222,   17.42279,   16.15996,   15.03234,
     5    14.02447                                                      
     * /   
          data ( BrSTSB(i,   13), i=  1,   21)/
     1   323.84427,  313.45864,  240.60582,  169.09410,  119.19026,
     2    87.88804,   67.45575,   53.80159,   44.40581,   37.70006,
     3    32.76699,   29.03360,   26.10998,   23.73915,   21.75443,
     4    20.05142,   18.56036,   17.23723,   16.05374,   14.99103,
     5    14.03660                                                      
     * /   
          data ( BrSTSB(i,   14), i=  1,   21)/
     1   343.96784,  328.95544,  239.79697,  163.40308,  113.66589,
     2    83.31389,   63.83338,   50.98432,   42.20315,   35.96304,
     3    31.38547,   27.93221,   25.23882,   23.06047,   21.23771,
     4    19.67122,   18.29562,   17.06855,   15.96428,   14.96662,
     5    14.06516                                                      
     * /   
          data ( BrSTSB(i,   15), i=  1,   21)/
     1   363.51456,  342.34656,  236.76962,  156.88810,  107.95161,
     2    78.75398,   60.25643,   48.23332,   40.05780,   34.28494,
     3    30.05274,   26.87103,   24.39708,   22.40474,   20.73777,
     4    19.30402,   18.04240,   16.91077,   15.88557,   14.95262,
     5    14.10387                                                      
     * /   
          data ( BrSTSB(i,   16), i=  1,   21)/
     1   382.47154,  353.25147,  231.86010,  149.92982,  102.17248,
     2    74.31831,   56.81651,   45.59816,   38.01121,   32.68399,
     3    28.78850,   25.86889,   23.60444,   21.78725,   20.27024,
     4    18.96393,   17.81252,   16.77392,   15.82622,   14.95646,
     5    14.15884                                                      
     * /   
          data ( BrSTSB(i,   17), i=  1,   21)/
     1   400.66974,  361.48018,  225.38063,  142.60300,   96.22430,
     2    69.88957,   53.49537,   43.06905,   36.06380,   31.16820,
     3    27.59294,   24.92419,   22.86108,   21.21281,   19.83947,
     4    18.65645,   17.61113,   16.66310,   15.79007,   14.98156,
     5    14.23313                                                      
     * /   
          data ( BrSTSB(i,   18), i=  1,   21)/
     1   418.10640,  367.03342,  217.69099,  135.14286,   90.23464,
     2    65.46246,   50.27123,   40.66535,   34.22690,   29.74465,
     3    26.48090,   24.04533,   22.17421,   20.68762,   19.45221,
     4    18.38836,   17.44521,   16.58354,   15.78189,   15.03044,
     5    14.32716                                                      
     * /   
          data ( BrSTSB(i,   19), i=  1,   21)/
     1   434.87674,  369.53035,  209.09101,  127.92607,   84.50309,
     2    61.13611,   47.15357,   38.37134,   32.50958,   28.42283,
     3    25.44076,   23.21735,   21.52448,   20.19302,   19.09460,
     4    18.15138,   17.30970,   16.53129,   15.79666,   15.09799,
     5    14.43547                                                      
     * /   
          data ( BrSTSB(i,   20), i=  1,   21)/
     1   450.90218,  369.16233,  199.70110,  120.39503,   79.00467,
     2    57.13186,   44.28729,   36.24445,   30.90264,   27.18542,
     3    24.47899,   22.45699,   20.93378,   19.74585,   18.77359,
     4    17.93943,   17.19057,   16.48993,   15.81831,   15.16921,
     5    14.54547                                                      
     * /   
          data ( BrSTSB(i,   21), i=  1,   21)/
     1   430.87104,  256.24705,  159.86484,   95.52547,   64.02694,
     2    47.27134,   37.41499,   31.14890,   26.90934,   23.90612,
     3    21.71304,   20.07186,   18.82486,   17.85364,   17.07358,
     4    16.41527,   15.82541,   15.26745,   14.72126,   14.18033,
     5    13.64733                                                      
     * /   

c   Brem at low energy: TX
          data ( BrTXL(i), i=  1,   38)/
     1   4.6901    ,  5.1357    ,  5.5855    ,  6.0307    ,
     2   6.4742    ,  6.9035    ,  7.3271    ,  7.7443    ,
     3   8.1535    ,  8.5518    ,  8.4760    ,  8.8336    ,
     4   9.1873    ,  9.5376    ,  9.8848    ,  10.229    ,
     5   10.571    ,  10.911    ,  11.250    ,  11.586    ,
     6   11.922    ,  12.256    ,  12.589    ,  12.922    ,
     7   13.253    ,  13.584    ,  13.915    ,  14.245    ,
     8   14.575    ,  14.905    ,  15.234    ,  15.563    ,
     9   15.892    ,  16.221    ,  16.549    ,  16.878    ,
     a   17.206    ,  17.536                                            
     * /   


c  Brem at low energy; Region A
          data ( BrSTLA(i,   1), i=  1,   20)/
     1     3.97716,    3.86445,    3.77874,    3.70987,    3.65220,
     2     3.60242,    3.55833,    3.51659,    3.47659,    3.43889,
     3     3.40390,    3.37182,    3.34262,    3.31620,    3.29236,
     4     3.27080,    3.25147,    3.23390,    3.21833,    3.20388      
     * /   
          data ( BrSTLA(i,   2), i=  1,   20)/
     1     4.24527,    4.13370,    4.04891,    3.98059,    3.92357,
     2     3.87465,    3.83095,    3.79037,    3.75198,    3.71554,
     3     3.68110,    3.64892,    3.61907,    3.59162,    3.56649,
     4     3.54363,    3.52283,    3.50404,    3.48708,    3.47161      
     * /   
          data ( BrSTLA(i,   3), i=  1,   20)/
     1     4.50886,    4.39705,    4.31179,    4.24273,    4.18491,
     2     4.13482,    4.08908,    4.04595,    4.00483,    3.96586,
     3     3.92940,    3.89565,    3.86477,    3.83673,    3.81142,
     4     3.78871,    3.76833,    3.74997,    3.73359,    3.71900      
     * /   
          data ( BrSTLA(i,   4), i=  1,   20)/
     1     4.77113,    4.65879,    4.57271,    4.50264,    4.44362,
     2     4.39171,    4.34338,    4.29730,    4.25336,    4.21204,
     3     4.17387,    4.13904,    4.10769,    4.07956,    4.05454,
     4     4.03235,    4.01270,    3.99526,    3.97985,    3.96608      
     * /   
          data ( BrSTLA(i,   5), i=  1,   20)/
     1     5.03293,    4.91993,    4.83284,    4.76160,    4.70110,
     2     4.64687,    4.59555,    4.54634,    4.49970,    4.45637,
     3     4.41691,    4.38148,    4.34999,    4.32223,    4.29784,
     4     4.27643,    4.25764,    4.24127,    4.22687,    4.21413      
     * /   
          data ( BrSTLA(i,   6), i=  1,   20)/
     1     5.29124,    5.17672,    5.08791,    5.01487,    4.95241,
     2     4.89527,    4.84064,    4.78834,    4.73932,    4.69451,
     3     4.65437,    4.61894,    4.58791,    4.56092,    4.53751,
     4     4.51723,    4.49962,    4.48427,    4.47104,    4.45953      
     * /   
          data ( BrSTLA(i,   7), i=  1,   20)/
     1     5.54788,    5.43155,    5.34083,    5.26590,    5.20122,
     2     5.14098,    5.08309,    5.02813,    4.97743,    4.93185,
     3     4.89170,    4.85685,    4.82676,    4.80094,    4.77880,
     4     4.75982,    4.74359,    4.72949,    4.71759,    4.70716      
     * /   
          data ( BrSTLA(i,   8), i=  1,   20)/
     1     5.80273,    5.68445,    5.59179,    5.51512,    5.44814,
     2     5.38496,    5.32431,    5.26743,    5.21586,    5.17040,
     3     5.13099,    5.09732,    5.06865,    5.04432,    5.02374,
     4     5.00629,    4.99145,    4.97886,    4.96800,    4.95886      
     * /   
          data ( BrSTLA(i,   9), i=  1,   20)/
     1     6.05601,    5.93590,    5.84159,    5.76347,    5.69434,
     2     5.62862,    5.56593,    5.50808,    5.45662,    5.41198,
     3     5.37399,    5.34195,    5.31501,    5.29248,    5.27357,
     4     5.25769,    5.24436,    5.23315,    5.22374,    5.21565      
     * /   
          data ( BrSTLA(i,   10), i=  1,   20)/
     1     6.30793,    6.18617,    6.09041,    6.01096,    5.93979,
     2     5.87191,    5.80787,    5.74984,    5.69914,    5.65601,
     3     5.61978,    5.58968,    5.56470,    5.54402,    5.52688,
     4     5.51269,    5.50078,    5.49097,    5.48260,    5.47572      
     * /   
          data ( BrSTLA(i,   11), i=  1,   20)/
     1     6.62246,    6.52557,    6.45734,    6.40804,    6.37167,
     2     6.34437,    6.32363,    6.30771,    6.29541,    6.28580,
     3     6.27830,    6.27239,    6.26772,    6.26401,    6.26101,
     4     6.25869,    6.25677,    6.25525,    6.25378,    6.25291      
     * /   
          data ( BrSTLA(i,   12), i=  1,   20)/
     1     6.87292,    6.77629,    6.70889,    6.66068,    6.62545,
     2     6.59928,    6.57958,    6.56463,    6.55318,    6.54436,
     3     6.53751,    6.53216,    6.52799,    6.52473,    6.52216,
     4     6.52010,    6.51848,    6.51715,    6.51616,    6.51519      
     * /   
          data ( BrSTLA(i,   13), i=  1,   20)/
     1     7.12170,    7.02529,    6.95871,    6.91154,    6.87742,
     2     6.85231,    6.83360,    6.81955,    6.80890,    6.80076,
     3     6.79452,    6.78970,    6.78598,    6.78310,    6.78084,
     4     6.77898,    6.77758,    6.77649,    6.77553,    6.77488      
     * /   
          data ( BrSTLA(i,   14), i=  1,   20)/
     1     7.36890,    7.27271,    7.20691,    7.16077,    7.12769,
     2     7.10360,    7.08583,    7.07261,    7.06270,    7.05520,
     3     7.04951,    7.04516,    7.04181,    7.03925,    7.03731,
     4     7.03569,    7.03447,    7.03358,    7.03275,    7.03221      
     * /   
          data ( BrSTLA(i,   15), i=  1,   20)/
     1     7.61466,    7.51865,    7.45365,    7.40849,    7.37645,
     2     7.35332,    7.33644,    7.32402,    7.31477,    7.30788,
     3     7.30270,    7.29878,    7.29580,    7.29350,    7.29178,
     4     7.29045,    7.28939,    7.28853,    7.28796,    7.28745      
     * /   
          data ( BrSTLA(i,   16), i=  1,   20)/
     1     7.85910,    7.76328,    7.69905,    7.65486,    7.62382,
     2     7.60165,    7.58561,    7.57392,    7.56533,    7.55899,
     3     7.55424,    7.55070,    7.54806,    7.54606,    7.54452,
     4     7.54337,    7.54246,    7.54176,    7.54130,    7.54082      
     * /   
          data ( BrSTLA(i,   17), i=  1,   20)/
     1     8.10232,    8.00672,    7.94328,    7.90007,    7.86999,
     2     7.84872,    7.83350,    7.82252,    7.81453,    7.80869,
     3     7.80438,    7.80120,    7.79883,    7.79706,    7.79567,
     4     7.79470,    7.79394,    7.79343,    7.79297,    7.79255      
     * /   
          data ( BrSTLA(i,   18), i=  1,   20)/
     1     8.34448,    8.24909,    8.18645,    8.14421,    8.11510,
     2     8.09472,    8.08029,    8.06997,    8.06254,    8.05715,
     3     8.05323,    8.05037,    8.04826,    8.04671,    8.04552,
     4     8.04465,    8.04406,    8.04349,    8.04311,    8.04283      
     * /   
          data ( BrSTLA(i,   19), i=  1,   20)/
     1     8.58570,    8.49056,    8.42874,    8.38746,    8.35929,
     2     8.33977,    8.32608,    8.31640,    8.30953,    8.30458,
     3     8.30102,    8.29841,    8.29654,    8.29518,    8.29415,
     4     8.29339,    8.29279,    8.29235,    8.29198,    8.29185      
     * /   
          data ( BrSTLA(i,   20), i=  1,   20)/
     1     8.82606,    8.73122,    8.67025,    8.62994,    8.60272,
     2     8.58404,    8.57107,    8.56199,    8.55560,    8.55107,
     3     8.54781,    8.54550,    8.54382,    8.54262,    8.54171,
     4     8.54109,    8.54066,    8.54016,    8.54002,    8.53977      
     * /   
          data ( BrSTLA(i,   21), i=  1,   20)/
     1     9.06569,    8.97121,    8.91112,    8.87178,    8.84548,
     2     8.82763,    8.81536,    8.80685,    8.80093,    8.79676,
     3     8.79383,    8.79175,    8.79025,    8.78917,    8.78843,
     4     8.78787,    8.78743,    8.78714,    8.78695,    8.78674      
     * /   
          data ( BrSTLA(i,   22), i=  1,   20)/
     1     9.30471,    9.21066,    9.15147,    9.11312,    9.08773,
     2     9.07066,    9.05905,    9.05110,    9.04560,    9.04179,
     3     9.03912,    9.03727,    9.03595,    9.03501,    9.03433,
     4     9.03385,    9.03349,    9.03322,    9.03293,    9.03291      
     * /   
          data ( BrSTLA(i,   23), i=  1,   20)/
     1     9.54322,    9.44966,    9.39139,    9.35403,    9.32953,
     2     9.31325,    9.30228,    9.29485,    9.28975,    9.28627,
     3     9.28386,    9.28216,    9.28100,    9.28017,    9.27960,
     4     9.27921,    9.27890,    9.27864,    9.27858,    9.27839      
     * /   
          data ( BrSTLA(i,   24), i=  1,   20)/
     1     9.78131,    9.68829,    9.63099,    9.59460,    9.57100,
     2     9.55544,    9.54511,    9.53814,    9.53346,    9.53025,
     3     9.52809,    9.52658,    9.52555,    9.52481,    9.52433,
     4     9.52398,    9.52368,    9.52359,    9.52352,    9.52329      
     * /   
          data ( BrSTLA(i,   25), i=  1,   20)/
     1    10.01906,    9.92665,    9.87032,    9.83493,    9.81219,
     2     9.79737,    9.78760,    9.78111,    9.77678,    9.77387,
     3     9.77187,    9.77055,    9.76961,    9.76900,    9.76853,
     4     9.76824,    9.76803,    9.76796,    9.76791,    9.76768      
     * /   
          data ( BrSTLA(i,   26), i=  1,   20)/
     1    10.25653,   10.16479,   10.10946,   10.07504,   10.05316,
     2    10.03905,   10.02983,   10.02378,   10.01979,   10.01711,
     3    10.01534,   10.01413,   10.01334,   10.01277,   10.01237,
     4    10.01215,   10.01197,   10.01174,   10.01175,   10.01165      
     * /   
          data ( BrSTLA(i,   27), i=  1,   20)/
     1    10.49382,   10.40278,   10.34846,   10.31503,   10.29398,
     2    10.28053,   10.27187,   10.26622,   10.26252,   10.26011,
     3    10.25849,   10.25742,   10.25672,   10.25620,   10.25589,
     4    10.25565,   10.25547,   10.25548,   10.25538,   10.25526      
     * /   
          data ( BrSTLA(i,   28), i=  1,   20)/
     1    10.73094,   10.64067,   10.58739,   10.55491,   10.53466,
     2    10.52189,   10.51371,   10.50847,   10.50506,   10.50285,
     3    10.50139,   10.50043,   10.49982,   10.49940,   10.49911,
     4    10.49892,   10.49875,   10.49864,   10.49846,   10.49857      
     * /   
          data ( BrSTLA(i,   29), i=  1,   20)/
     1    10.96796,   10.87849,   10.82625,   10.79472,   10.77529,
     2    10.76312,   10.75545,   10.75056,   10.74743,   10.74542,
     3    10.74409,   10.74325,   10.74269,   10.74233,   10.74207,
     4    10.74194,   10.74178,   10.74180,   10.74170,   10.74163      
     * /   
          data ( BrSTLA(i,   30), i=  1,   20)/
     1    11.20491,   11.11631,   11.06510,   11.03451,   11.01585,
     2    11.00430,   10.99708,   10.99253,   10.98965,   10.98782,
     3    10.98662,   10.98586,   10.98540,   10.98507,   10.98484,
     4    10.98472,   10.98464,   10.98457,   10.98464,   10.98448      
     * /   
          data ( BrSTLA(i,   31), i=  1,   20)/
     1    11.44183,   11.35412,   11.30396,   11.27430,   11.25639,
     2    11.24542,   11.23864,   11.23441,   11.23176,   11.23009,
     3    11.22904,   11.22836,   11.22792,   11.22765,   11.22746,
     4    11.22737,   11.22728,   11.22722,   11.22724,   11.22714      
     * /   
          data ( BrSTLA(i,   32), i=  1,   20)/
     1    11.67876,   11.59196,   11.54285,   11.51412,   11.49692,
     2    11.48652,   11.48014,   11.47623,   11.47378,   11.47227,
     3    11.47133,   11.47073,   11.47033,   11.47008,   11.46993,
     4    11.46980,   11.46977,   11.46975,   11.65155,   11.46967      
     * /   
          data ( BrSTLA(i,   33), i=  1,   20)/
     1    11.91568,   11.82987,   11.78179,   11.75395,   11.73748,
     2    11.72760,   11.72163,   11.71797,   11.71575,   11.71436,
     3    11.71351,   11.71297,   11.71264,   11.71245,   11.71229,
     4    11.71219,   11.71214,   10.10969,    7.12536,   11.71207      
     * /   
          data ( BrSTLA(i,   34), i=  1,   20)/
     1    12.15268,   12.06783,   12.02080,   11.99384,   11.97805,
     2    11.96869,   11.96309,   11.95970,   11.95765,   11.95641,
     3    11.95562,   11.95517,   11.95487,   11.95467,   11.95454,
     4    11.95446,   11.95445,   10.38711,    7.38509,   11.95437      
     * /   
          data ( BrSTLA(i,   35), i=  1,   20)/
     1    12.38972,   12.30588,   12.25988,   12.23379,   12.21868,
     2    12.20981,   12.20453,   12.20139,   12.19953,   12.19839,
     3    12.19769,   12.19729,   12.19703,   12.19686,   12.19674,
     4    12.19667,   12.19668,    8.15187,   13.25402,   12.19660      
     * /   
          data ( BrSTLA(i,   36), i=  1,   20)/
     1    12.62683,   12.54402,   12.49907,   12.47382,   12.45932,
     2    12.45092,   12.44599,   12.44309,   12.44136,   12.44032,
     3    12.43970,   12.43934,   12.43910,   12.43897,   12.43891,
     4    12.43884,   12.43876,    8.39059,   13.66837,   12.43875      
     * /   
          data ( BrSTLA(i,   37), i=  1,   20)/
     1    12.86403,   12.78226,   12.73833,   12.71389,   12.70005,
     2    12.69208,   12.68747,   12.68476,   12.68319,   12.68225,
     3    12.68168,   12.68138,   12.68118,   12.68107,   12.68098,
     4    12.68094,   15.09258,   11.18367,    8.15106,   12.68086      
     * /   
          data ( BrSTLA(i,   38), i=  1,   20)/
     1    13.10209,   13.02132,   12.97839,   12.95475,   12.94150,
     2    12.93395,   12.92962,   12.92714,   12.92569,   12.92484,
     3    12.92435,   12.92406,   12.92388,   12.92376,   12.92371,
     4    12.92368,    9.09815,   11.53466,    8.49811,   12.92361      
     * /   


c  Brem at low energy: Region B
          data ( BrSTLB(i,   1), i=  1,   21)/
     1   169.20386,  167.87951,  145.81104,  112.78110,   84.76650,
     2    64.39734,   50.35272,   40.39815,   33.24744,   28.01204,
     3    24.09980,   21.11143,   18.77618,   16.90997,   15.37995,
     4    14.09489,   12.99220,   12.02978,   11.17823,   10.41727,
     5     9.73265                                                      
     * /   
          data ( BrSTLB(i,   2), i=  1,   21)/
     1   187.12682,  185.49657,  152.72862,  115.40155,   84.40904,
     2    63.50019,   49.22788,   39.33080,   32.32565,   27.26975,
     3    23.51325,   20.65524,   18.43511,   16.66562,   15.22061,
     4    14.00548,   12.96194,   12.04922,   11.23853,   10.51115,
     5     9.85365                                                      
     * /   
          data ( BrSTLB(i,   3), i=  1,   21)/
     1   205.10028,  202.13674,  158.35670,  115.45021,   82.82869,
     2    61.76882,   47.63043,   38.01971,   31.29061,   26.46307,
     3    22.89543,   20.18640,   18.09084,   16.42457,   15.06493,
     4    13.92261,   12.94068,   12.07897,   11.31104,   10.61862,
     5     9.98971                                                      
     * /   
          data ( BrSTLB(i,   4), i=  1,   21)/
     1   222.89710,  217.79689,  161.96464,  114.27034,   80.62014,
     2    59.68653,   45.85391,   36.58466,   30.17198,   25.60047,
     3    22.23544,   19.68626,   17.71745,   16.15693,   14.88653,
     4    13.81954,   12.90054,   12.09282,   11.37046,   10.71594,
     5    10.11777                                                      
     * /   
          data ( BrSTLB(i,   5), i=  1,   21)/
     1   240.65640,  232.28661,  163.75795,  112.11932,   77.94913,
     2    57.36436,   43.97355,   35.08865,   29.00799,   24.69537,
     3    21.54029,   19.15334,   17.31561,   15.86182,   14.68239,
     4    13.69221,   12.83907,   12.08747,   11.41361,   10.79932,
     5    10.23480                                                      
     * /   
          data ( BrSTLB(i,   6), i=  1,   21)/
     1   257.67138,  244.65565,  163.71751,  109.19777,   74.93310,
     2    54.89269,   42.03493,   33.56794,   27.85116,   23.81173,
     3    20.86510,   18.64473,   16.93955,   15.59246,   14.50185,
     4    13.58764,   12.79931,   12.10398,   11.47748,   10.90315,
     5    10.37138                                                      
     * /   
          data ( BrSTLB(i,   7), i=  1,   21)/
     1   274.39660,  255.09422,  162.21706,  105.72880,   71.59908,
     2    52.16687,   40.00805,   32.04852,   26.69924,   22.93345,
     3    20.20224,   18.14349,   16.56777,   15.32719,   14.32565,
     4    13.48781,   12.76469,   12.12536,   11.54694,   11.01288,
     5    10.51377                                                      
     * /   
          data ( BrSTLB(i,   8), i=  1,   21)/
     1   290.79527,  263.60383,  159.45215,  101.95124,   68.18839,
     2    49.36604,   37.94230,   30.52688,   25.57495,   22.08274,
     3    19.55904,   17.65834,   16.20417,   15.06722,   14.15420,
     4    13.39370,   12.73776,   12.15668,   11.62668,   11.13241,
     5    10.66508                                                      
     * /   
          data ( BrSTLB(i,   9), i=  1,   21)/
     1   306.77973,  269.61514,  155.51070,   97.93084,   64.77779,
     2    46.64085,   35.91112,   29.04316,   24.47795,   21.26727,
     3    18.94833,   17.19823,   15.85770,   14.81921,   13.99257,
     4    13.30930,   12.72173,   12.19927,   11.71762,   11.26218,
     5    10.82484                                                      
     * /   
          data ( BrSTLB(i,   10), i=  1,   21)/
     1   322.23399,  273.32048,  150.77808,   93.43260,   61.22564,
     2    44.05215,   34.05850,   27.68577,   23.47243,   20.51592,
     3    18.38420,   16.78331,   15.55752,   14.61529,   13.87088,
     4    13.25860,   12.73236,   12.26167,   11.82344,   11.40262,
     5    10.99242                                                      
     * /   
          data ( BrSTLB(i,   11), i=  1,   21)/
     1   205.64908,  192.57681,  124.71704,   75.44609,   50.60651,
     2    37.27079,   29.36595,   24.34191,   20.93229,   18.51318,
     3    16.73740,   15.40551,   14.38865,   13.60038,   12.97979,
     4    12.47547,   12.04744,   11.66431,   11.30259,   10.94751,
     5    10.59312                                                      
     * /   
          data ( BrSTLB(i,   12), i=  1,   21)/
     1   215.27587,  197.76084,  120.39985,   71.38787,   47.80173,
     2    35.33955,   27.99995,   23.33875,   20.18206,   17.95091,
     3    16.31424,   15.09491,   14.17261,   13.46779,   12.91734,
     4    12.47439,   12.09915,   11.75944,   11.43217,   11.10320,
     5    10.76769                                                      
     * /   
          data ( BrSTLB(i,   13), i=  1,   21)/
     1   224.67828,  201.41317,  115.40855,   67.35667,   45.12165,
     2    33.49795,   26.73368,   22.41993,   19.49916,   17.43422,
     3    15.93333,   14.82333,   13.99504,   13.36930,   12.88762,
     4    12.50333,   12.17732,   11.87766,   11.58098,   11.27490,
     5    10.95522                                                      
     * /   
          data ( BrSTLB(i,   14), i=  1,   21)/
     1   233.88543,  203.72517,  109.97115,   63.42660,   42.58781,
     2    31.83356,   25.55252,   21.55709,   18.86702,   16.96805,
     3    15.59795,   14.59651,   13.85756,   13.30707,   12.89093,
     4    12.56203,   12.28140,   12.01793,   11.74877,   11.46200,
     5    11.15540                                                      
     * /   
          data ( BrSTLB(i,   15), i=  1,   21)/
     1   242.92398,  204.31620,  104.26777,   59.65027,   40.21115,
     2    30.23320,   24.45896,   20.78247,   18.29854,   16.55668,
     3    15.31093,   14.41299,   13.75918,   13.28222,   12.92679,
     4    12.64914,   12.41080,   12.17982,   11.93414,   11.66340,
     5    11.36718                                                      
     * /   
          data ( BrSTLB(i,   16), i=  1,   21)/
     1   251.81782,  203.37756,   98.47826,   56.05890,   37.99721,
     2    28.77777,   23.45410,   20.06587,   17.78212,   16.19668,
     3    15.07259,   14.27299,   13.70134,   13.29220,   12.99471,
     4    12.76485,   12.56404,   12.36154,   12.13598,   11.87843,
     5    11.59003                                                      
     * /   
          data ( BrSTLB(i,   17), i=  1,   21)/
     1   260.58809,  200.90985,   92.71069,   52.67644,   35.94550,
     2    27.46712,   22.53791,   19.41759,   17.32986,   15.88806,
     3    14.88292,   14.17483,   13.68164,   13.33713,   13.09275,
     4    12.90668,   12.73966,   12.56196,   12.35339,   12.10595,
     5    11.82266                                                      
     * /   
          data ( BrSTLB(i,   18), i=  1,   21)/
     1   269.25324,  196.72287,   87.07298,   49.51025,   34.05243,
     2    26.22133,   21.70984,   18.83735,   16.92951,   15.63456,
     3    14.73941,   14.12199,   13.70010,   13.41524,   13.21964,
     4    13.07262,   12.93614,   12.77992,   12.58494,   12.34480,
     5    12.06452                                                      
     * /   
          data ( BrSTLB(i,   19), i=  1,   21)/
     1   277.82929,  191.38926,   81.62516,   46.56758,   32.31363,
     2    25.11713,   20.94999,   18.32471,   16.59897,   15.43220,
     3    14.64196,   14.10751,   13.75307,   13.52390,   13.37345,
     4    13.26178,   13.15154,   13.01324,   12.82916,   12.59383,
     5    12.31429                                                      
     * /   
          data ( BrSTLB(i,   20), i=  1,   21)/
     1   286.33014,  184.71872,   76.43908,   43.84387,   30.72022,
     2    24.11166,   20.27565,   17.87872,   16.31956,   15.28071,
     3    14.58791,   14.13133,   13.84052,   13.66131,   13.55150,
     4    13.47159,   13.38433,   13.26141,   13.08485,   12.85206,
     5    12.57135                                                      
     * /   
          data ( BrSTLB(i,   21), i=  1,   21)/
     1   294.76782,  177.28382,   71.52686,   41.33211,   29.26404,
     2    23.16236,   19.66630,   17.49860,   16.09687,   15.17979,
     3    14.57708,   14.19334,   13.95870,   13.82475,   13.75178,
     4    13.70003,   13.63297,   13.52220,   13.35106,   13.11828,
     5    12.83456                                                      
     * /   
          data ( BrSTLB(i,   22), i=  1,   21)/
     1   303.15266,  169.08487,   66.92445,   39.02530,   27.93690,
     2    22.34436,   19.13920,   17.17311,   15.92433,   15.12157,
     3    14.60431,   14.28658,   14.10394,   14.01250,   13.97303,
     4    13.94617,   13.89631,   13.79441,   13.62627,   13.39150,
     5    13.10328                                                      
     * /   
          data ( BrSTLB(i,   23), i=  1,   21)/
     1   311.49341,  160.50360,   62.63191,   36.91404,   26.72912,
     2    21.61445,   18.69249,   16.92181,   15.80735,   15.10944,
     3    14.66933,   14.41087,   14.27614,   14.22177,   14.21250,
     4    14.20792,   14.17235,   14.07713,   13.90923,   13.67070,
     5    13.37629                                                      
     * /   
          data ( BrSTLB(i,   24), i=  1,   21)/
     1   319.79739,  151.73096,   58.64933,   34.98422,   25.63400,
     2    20.93066,   18.30593,   16.71322,   15.73961,   15.13565,
     3    14.76708,   14.56278,   14.47041,   14.45175,   14.46823,
     4    14.48328,   14.45953,   14.36881,   14.19897,   13.95487,
     5    13.65298                                                      
     * /   
          data ( BrSTLB(i,   25), i=  1,   21)/
     1   328.07071,  142.76711,   54.96482,   33.22642,   24.64408,
     2    20.36840,   17.97796,   16.56707,   15.71451,   15.19609,
     3    14.89487,   14.73873,   14.68672,   14.69880,   14.73959,
     4    14.77124,   14.75667,   14.66784,   14.49449,   14.24320,
     5    13.93248                                                      
     * /   
          data ( BrSTLB(i,   26), i=  1,   21)/
     1   336.31850,  133.99368,   51.57840,   31.62651,   23.75564,
     2    19.84769,   17.72690,   16.48297,   15.73789,   15.29443,
     3    15.05009,   14.93871,   14.92134,   14.96203,   15.02456,
     4    15.07028,   15.06216,   14.97330,   14.79448,   14.53487,
     5    14.21450                                                      
     * /   
          data ( BrSTLB(i,   27), i=  1,   21)/
     1   344.54506,  125.41076,   48.47816,   30.17034,   22.96494,
     2    19.44544,   17.53295,   16.42969,   15.79145,   15.42305,
     3    15.22774,   15.15756,   15.17315,   15.23880,   15.32119,
     4    15.37891,   15.37528,   15.28427,   15.09850,   14.82905,
     5    14.49818                                                      
     * /   
          data ( BrSTLB(i,   28), i=  1,   21)/
     1   352.75406,  117.20916,   45.62833,   28.85321,   22.26752,
     2    19.08139,   17.39534,   16.42737,   15.88095,   15.57414,
     3    15.43027,   15.39523,   15.43960,   15.52914,   15.62739,
     4    15.69503,   15.69441,   15.59948,   15.40554,   15.12515,
     5    14.78321                                                      
     * /   
          data ( BrSTLB(i,   29), i=  1,   21)/
     1   360.94856,  109.38893,   43.04085,   27.66098,   21.66037,
     2    18.79352,   17.31344,   16.47567,   16.00014,   15.75523,
     3    15.65002,   15.64999,   15.72074,   15.83031,   15.94324,
     4    16.01869,   16.01872,   15.91862,   15.71477,   15.42298,
     5    15.06905                                                      
     * /   
          data ( BrSTLB(i,   30), i=  1,   21)/
     1   369.13111,  101.95012,   40.66801,   26.58658,   21.13978,
     2    18.58031,   17.26753,   16.54342,   16.14893,   15.95484,
     3    15.88956,   15.91835,   16.01288,   16.14054,   16.26674,
     4    16.34892,   16.34790,   16.24075,   16.02630,   15.72190,
     5    15.35557                                                      
     * /   
          data ( BrSTLB(i,   31), i=  1,   21)/
     1   377.30383,   94.89274,   38.52174,   25.62764,   20.70127,
     2    18.43993,   17.27571,   16.65064,   16.32695,   16.17274,
     3    16.14369,   16.19854,   16.31475,   16.45987,   16.59721,
     4    16.68356,   16.68028,   16.56525,   16.33876,   16.02128,
     5    15.64226                                                      
     * /   
          data ( BrSTLB(i,   32), i=  1,   21)/
     1   385.46849,   88.40756,   36.56626,   24.77709,   20.33960,
     2    18.33102,   17.31803,   16.78660,   16.52184,   16.40885,
     3    16.40985,   16.49054,   16.62635,   16.78645,   16.93326,
     4    17.02322,   17.01588,   16.89143,   16.65246,   16.32114,
     5    15.92892                                                      
     * /   
          data ( BrSTLB(i,   33), i=  1,   21)/
     1   393.62656,   82.49460,   34.78964,   24.03259,   20.05029,
     2    18.29096,   17.41254,   16.95073,   16.73934,   16.66294,
     3    16.69042,   16.79249,   16.94638,   17.11932,   17.27492,
     4    17.36570,   17.35388,   17.21899,   16.96659,   16.62104,
     5    16.21539                                                      
     * /   
          data ( BrSTLB(i,   34), i=  1,   21)/
     1   401.77928,   76.77236,   33.17997,   23.38706,   19.82963,
     2    18.27902,   17.52061,   17.14278,   16.96718,   16.92737,
     3    16.98038,   17.10271,   17.27240,   17.45859,   17.62012,
     4    17.71164,   17.69345,   17.54729,   17.28062,   16.92056,
     5    16.50159                                                      
     * /   
          data ( BrSTLB(i,   35), i=  1,   21)/
     1   409.92766,   71.81310,   31.72532,   22.83342,   19.67089,
     2    18.33167,   17.65984,   17.35167,   17.21706,   17.20561,
     3    17.27948,   17.42106,   17.60430,   17.80138,   17.96885,
     4    18.05993,   18.03417,   17.87597,   17.59485,   17.21994,
     5    16.78709                                                      
     * /   
          data ( BrSTLB(i,   36), i=  1,   21)/
     1   418.07253,   67.04457,   30.42568,   22.37168,   19.56959,
     2    18.36862,   17.82946,   17.57700,   17.47661,   17.49377,
     3    17.58772,   17.74400,   17.94212,   18.14865,   18.32114,
     4    18.41002,   18.37605,   18.20469,   17.90842,   17.51848,
     5    17.07197                                                      
     * /   
          data ( BrSTLB(i,   37), i=  1,   21)/
     1   426.21457,   62.65753,   29.24527,   21.99005,   19.52126,
     2    18.50572,   18.02841,   17.81818,   17.75158,   17.78780,
     3    17.90243,   18.07324,   18.28454,   18.49945,   18.67553,
     4    18.76137,   18.71868,   18.53347,   18.22163,   17.81642,
     5    17.35613                                                      
     * /   
          data ( BrSTLB(i,   38), i=  1,   21)/
     1    17.53785,   17.45231,   17.53702,   17.54227,   17.55332,
     2    17.58199,   17.62090,   17.68056,   17.78024,   17.92047,
     3    18.10120,   18.31989,   18.56501,   18.80451,   18.99471,
     4    19.08621,   19.04014,   18.84619,   18.52224,   18.10437,
     5    17.63254                                                      
     * /   

c  consts for Pair  sampling table at low energies
      data  PairEgmin /  1.100000000000000E-003/
      data  PairLEgmin / -2.95860731484178/
      data  PairNonSc /  8.000000000000000E-003/
      data  PrScrE /  77.0769320180599/
      data  PairEgmaxL /  28257261.4107884/
      data  PairTXTL /  48/
      data  PairEsize /  48/
      data  PairUminLA /  5.000000000000000E-002/
      data  PairUmaxLA /  1.00000000000000/
      data  PairUszLA /  21/
      data  PairdULA /  4.750000000000000E-002/
      data  PairdETXL /  .103096419881820/
      data  PairUminLB /  .000000000000000/
      data  PairUmaxLB /  .472870804501588/
      data  PairUszLB /  21/
      data  PairdULB /  2.364354022507940E-002/
      data  PairdELA /  .103096419881820/
      data  PairdELB /  4.683525219905790E-002/


c   Pair at Low E: TX
          data ( PrTXL(i), i=  1,   48)/
     1  0.40518E-04, 0.23242E-02, 0.99176E-02, 0.23220E-01,
     2  0.41617E-01, 0.64290E-01, 0.90470E-01,  .11950    ,
     3   .15082    ,  .18392    ,  .21861    ,  .25392    ,
     4   .28954    ,  .32523    ,  .36080    ,  .39605    ,
     5   .43072    ,  .46446    ,  .49689    ,  .52764    ,
     6   .55642    ,  .58303    ,  .60736    ,  .62935    ,
     7   .64905    ,  .66651    ,  .68188    ,  .69533    ,
     8   .70703    ,  .71716    ,  .72590    ,  .73342    ,
     9   .73985    ,  .74535    ,  .75001    ,  .75396    ,
     a   .75730    ,  .76010    ,  .76246    ,  .76442    ,
     b   .76606    ,  .76743    ,  .76856    ,  .76949    ,
     c   .77027    ,  .77091    ,  .77143    ,  .77187                  
     * /   


c  Pair at Low E: Region A
          data ( PrSTLA(i,   1), i=  1,   21)/
     1      .03277,     .03176,     .03105,     .03050,     .03006,
     2      .02970,     .02940,     .02912,     .02891,     .02870,
     3      .02853,     .02838,     .02826,     .02815,     .02805,
     4      .02797,     .02790,     .02785,     .02784,     .02779,
     5      .02781                                                      
     * /   
          data ( PrSTLA(i,   2), i=  1,   21)/
     1      .12344,     .11959,     .11689,     .11483,     .11315,
     2      .11177,     .11060,     .10959,     .10873,     .10797,
     3      .10734,     .10677,     .10629,     .10587,     .10552,
     4      .10523,     .10501,     .10482,     .10469,     .10465,
     5      .10461                                                      
     * /   
          data ( PrSTLA(i,   3), i=  1,   21)/
     1      .19490,     .18882,     .18457,     .18133,     .17871,
     2      .17653,     .17470,     .17313,     .17179,     .17061,
     3      .16960,     .16874,     .16799,     .16735,     .16681,
     4      .16635,     .16601,     .16576,     .16552,     .16549,
     5      .16539                                                      
     * /   
          data ( PrSTLA(i,   4), i=  1,   21)/
     1      .25130,     .24352,     .23814,     .23403,     .23072,
     2      .22799,     .22570,     .22375,     .22207,     .22063,
     3      .21937,     .21830,     .21738,     .21659,     .21595,
     4      .21539,     .21496,     .21459,     .21437,     .21424,
     5      .21419                                                      
     * /   
          data ( PrSTLA(i,   5), i=  1,   21)/
     1      .29589,     .28690,     .28074,     .27606,     .27233,
     2      .26928,     .26672,     .26454,     .26268,     .26110,
     3      .25972,     .25856,     .25755,     .25669,     .25598,
     4      .25537,     .25491,     .25456,     .25427,     .25422,
     5      .25410                                                      
     * /   
          data ( PrSTLA(i,   6), i=  1,   21)/
     1      .33124,     .32148,     .31487,     .30990,     .30596,
     2      .30276,     .30011,     .29787,     .29598,     .29435,
     3      .29296,     .29178,     .29077,     .28992,     .28922,
     4      .28865,     .28819,     .28780,     .28756,     .28741,
     5      .28736                                                      
     * /   
          data ( PrSTLA(i,   7), i=  1,   21)/
     1      .35939,     .34923,     .34244,     .33740,     .33347,
     2      .33029,     .32768,     .32549,     .32366,     .32211,
     3      .32080,     .31967,     .31873,     .31794,     .31728,
     4      .31676,     .31633,     .31602,     .31578,     .31569,
     5      .31560                                                      
     * /   
          data ( PrSTLA(i,   8), i=  1,   21)/
     1      .38192,     .37168,     .36495,     .36002,     .35621,
     2      .35318,     .35072,     .34869,     .34702,     .34561,
     3      .34443,     .34345,     .34262,     .34191,     .34135,
     4      .34091,     .34054,     .34028,     .34009,     .33993,
     5      .33992                                                      
     * /   
          data ( PrSTLA(i,   9), i=  1,   21)/
     1      .40008,     .39001,     .38350,     .37881,     .37526,
     2      .37246,     .37024,     .36843,     .36693,     .36572,
     3      .36474,     .36391,     .36323,     .36268,     .36223,
     4      .36186,     .36158,     .36139,     .36122,     .36112,
     5      .36113                                                      
     * /   
          data ( PrSTLA(i,   10), i=  1,   21)/
     1      .41471,     .40513,     .39917,     .39501,     .39192,
     2      .38958,     .38774,     .38633,     .38521,     .38429,
     3      .38360,     .38304,     .38262,     .38227,     .38201,
     4      .38182,     .38168,     .38159,     .38149,     .38145,
     5      .38145                                                      
     * /   
          data ( PrSTLA(i,   11), i=  1,   21)/
     1      .42734,     .41843,     .41298,     .40924,     .40656,
     2      .40457,     .40308,     .40196,     .40113,     .40049,
     3      .40003,     .39970,     .39946,     .39931,     .39920,
     4      .39913,     .39910,     .39906,     .39905,     .39901,
     5      .39908                                                      
     * /   
          data ( PrSTLA(i,   12), i=  1,   21)/
     1      .43767,     .42947,     .42454,     .42127,     .41898,
     2      .41736,     .41621,     .41540,     .41484,     .41449,
     3      .41426,     .41415,     .41412,     .41414,     .41422,
     4      .41427,     .41435,     .41443,     .41452,     .41448,
     5      .41454                                                      
     * /   
          data ( PrSTLA(i,   13), i=  1,   21)/
     1      .44624,     .43872,     .43434,     .43151,     .42964,
     2      .42838,     .42756,     .42704,     .42678,     .42668,
     3      .42671,     .42682,     .42700,     .42721,     .42742,
     4      .42764,     .42783,     .42799,     .42808,     .42819,
     5      .42821                                                      
     * /   
          data ( PrSTLA(i,   14), i=  1,   21)/
     1      .45337,     .44655,     .44270,     .44033,     .43884,
     2      .43793,     .43745,     .43723,     .43725,     .43741,
     3      .43768,     .43800,     .43838,     .43876,     .43914,
     4      .43949,     .43978,     .44005,     .44022,     .44026,
     5      .44036                                                      
     * /   
          data ( PrSTLA(i,   15), i=  1,   21)/
     1      .45937,     .45323,     .44992,     .44797,     .44686,
     2      .44630,     .44611,     .44620,     .44649,     .44689,
     3      .44738,     .44793,     .44849,     .44904,     .44957,
     4      .45006,     .45045,     .45080,     .45102,     .45121,
     5      .45124                                                      
     * /   
          data ( PrSTLA(i,   16), i=  1,   21)/
     1      .46447,     .45900,     .45616,     .45465,     .45390,
     2      .45367,     .45378,     .45416,     .45471,     .45535,
     3      .45609,     .45684,     .45759,     .45831,     .45901,
     4      .45961,     .46012,     .46056,     .46089,     .46108,
     5      .46111                                                      
     * /   
          data ( PrSTLA(i,   17), i=  1,   21)/
     1      .46883,     .46400,     .46166,     .46055,     .46016,
     2      .46026,     .46069,     .46133,     .46214,     .46305,
     3      .46401,     .46500,     .46596,     .46687,     .46769,
     4      .46844,     .46909,     .46960,     .46998,     .47017,
     5      .47028                                                      
     * /   
          data ( PrSTLA(i,   18), i=  1,   21)/
     1      .47261,     .46841,     .46656,     .46585,     .46584,
     2      .46627,     .46700,     .46798,     .46906,     .47023,
     3      .47146,     .47265,     .47383,     .47495,     .47596,
     4      .47683,     .47760,     .47824,     .47864,     .47892,
     5      .47903                                                      
     * /   
          data ( PrSTLA(i,   19), i=  1,   21)/
     1      .47591,     .47235,     .47099,     .47070,     .47107,
     2      .47186,     .47295,     .47424,     .47563,     .47709,
     3      .47857,     .48003,     .48143,     .48274,     .48393,
     4      .48499,     .48590,     .48658,     .48715,     .48743,
     5      .48754                                                      
     * /   
          data ( PrSTLA(i,   20), i=  1,   21)/
     1      .47885,     .47592,     .47507,     .47522,     .47599,
     2      .47718,     .47863,     .48022,     .48193,     .48369,
     3      .48545,     .48717,     .48881,     .49032,     .49171,
     4      .49294,     .49397,     .49477,     .49542,     .49577,
     5      .49587                                                      
     * /   
          data ( PrSTLA(i,   21), i=  1,   21)/
     1      .48147,     .47921,     .47887,     .47948,     .48067,
     2      .48223,     .48404,     .48600,     .48803,     .49008,
     3      .49211,     .49408,     .49595,     .49770,     .49926,
     4      .50065,     .50181,     .50275,     .50343,     .50386,
     5      .50396                                                      
     * /   
          data ( PrSTLA(i,   22), i=  1,   21)/
     1      .48385,     .48223,     .48242,     .48352,     .48513,
     2      .48708,     .48923,     .49153,     .49386,     .49619,
     3      .49850,     .50072,     .50282,     .50478,     .50653,
     4      .50808,     .50938,     .51042,     .51115,     .51159,
     5      .51177                                                      
     * /   
          data ( PrSTLA(i,   23), i=  1,   21)/
     1      .48602,     .48505,     .48577,     .48733,     .48934,
     2      .49166,     .49416,     .49676,     .49941,     .50203,
     3      .50459,     .50706,     .50938,     .51153,     .51347,
     4      .51516,     .51658,     .51772,     .51856,     .51900,
     5      .51923                                                      
     * /   
          data ( PrSTLA(i,   24), i=  1,   21)/
     1      .48801,     .48769,     .48892,     .49092,     .49332,
     2      .49598,     .49882,     .50172,     .50463,     .50754,
     3      .51034,     .51304,     .51558,     .51793,     .52001,
     4      .52188,     .52345,     .52467,     .52559,     .52611,
     5      .52630                                                      
     * /   
          data ( PrSTLA(i,   25), i=  1,   21)/
     1      .48983,     .49014,     .49187,     .49427,     .49704,
     2      .50003,     .50317,     .50636,     .50954,     .51268,
     3      .51573,     .51865,     .52139,     .52392,     .52619,
     4      .52818,     .52985,     .53119,     .53219,     .53279,
     5      .53295                                                      
     * /   
          data ( PrSTLA(i,   26), i=  1,   21)/
     1      .49151,     .49242,     .49460,     .49738,     .50049,
     2      .50380,     .50721,     .51066,     .51409,     .51748,
     3      .52074,     .52385,     .52679,     .52948,     .53190,
     4      .53404,     .53581,     .53726,     .53831,     .53891,
     5      .53912                                                      
     * /   
          data ( PrSTLA(i,   27), i=  1,   21)/
     1      .49305,     .49451,     .49712,     .50024,     .50368,
     2      .50724,     .51093,     .51462,     .51829,     .52186,
     3      .52534,     .52863,     .53173,     .53459,     .53715,
     4      .53942,     .54130,     .54277,     .54388,     .54448,
     5      .54478                                                      
     * /   
          data ( PrSTLA(i,   28), i=  1,   21)/
     1      .49447,     .49644,     .49943,     .50286,     .50657,
     2      .51040,     .51431,     .51822,     .52208,     .52586,
     3      .52951,     .53298,     .53624,     .53923,     .54191,
     4      .54429,     .54625,     .54786,     .54900,     .54968,
     5      .54992                                                      
     * /   
          data ( PrSTLA(i,   29), i=  1,   21)/
     1      .49577,     .49820,     .50152,     .50525,     .50920,
     2      .51326,     .51738,     .52147,     .52551,     .52948,
     3      .53328,     .53688,     .54028,     .54339,     .54621,
     4      .54867,     .55072,     .55237,     .55359,     .55435,
     5      .55455                                                      
     * /   
          data ( PrSTLA(i,   30), i=  1,   21)/
     1      .49694,     .49978,     .50341,     .50740,     .51156,
     2      .51581,     .52010,     .52439,     .52859,     .53267,
     3      .53662,     .54037,     .54389,     .54711,     .55004,
     4      .55256,     .55471,     .55642,     .55766,     .55834,
     5      .55867                                                      
     * /   
          data ( PrSTLA(i,   31), i=  1,   21)/
     1      .49800,     .50122,     .50512,     .50932,     .51366,
     2      .51810,     .52255,     .52697,     .53129,     .53552,
     3      .53960,     .54346,     .54709,     .55041,     .55341,
     4      .55605,     .55823,     .56001,     .56130,     .56198,
     5      .56233                                                      
     * /   
          data ( PrSTLA(i,   32), i=  1,   21)/
     1      .49895,     .50250,     .50662,     .51102,     .51553,
     2      .52011,     .52469,     .52925,     .53370,     .53803,
     3      .54223,     .54620,     .54990,     .55334,     .55642,
     4      .55909,     .56137,     .56320,     .56452,     .56528,
     5      .56556                                                      
     * /   
          data ( PrSTLA(i,   33), i=  1,   21)/
     1      .49981,     .50364,     .50797,     .51252,     .51718,
     2      .52189,     .52660,     .53124,     .53583,     .54026,
     3      .54454,     .54859,     .55240,     .55588,     .55905,
     4      .56179,     .56413,     .56594,     .56732,     .56808,
     5      .56840                                                      
     * /   
          data ( PrSTLA(i,   34), i=  1,   21)/
     1      .50057,     .50464,     .50914,     .51384,     .51862,
     2      .52346,     .52825,     .53302,     .53767,     .54221,
     3      .54655,     .55069,     .55458,     .55814,     .56136,
     4      .56416,     .56651,     .56841,     .56979,     .57055,
     5      .57089                                                      
     * /   
          data ( PrSTLA(i,   35), i=  1,   21)/
     1      .50125,     .50554,     .51018,     .51499,     .51990,
     2      .52480,     .52972,     .53454,     .53930,     .54389,
     3      .54833,     .55254,     .55647,     .56011,     .56335,
     4      .56623,     .56861,     .57054,     .57192,     .57284,
     5      .57307                                                      
     * /   
          data ( PrSTLA(i,   36), i=  1,   21)/
     1      .50186,     .50632,     .51109,     .51603,     .52100,
     2      .52601,     .53099,     .53589,     .54069,     .54538,
     3      .54987,     .55414,     .55813,     .56180,     .56513,
     4      .56803,     .57045,     .57239,     .57380,     .57464,
     5      .57496                                                      
     * /   
          data ( PrSTLA(i,   37), i=  1,   21)/
     1      .50238,     .50700,     .51188,     .51690,     .52197,
     2      .52705,     .53209,     .53705,     .54192,     .54666,
     3      .55120,     .55552,     .55957,     .56329,     .56663,
     4      .56956,     .57204,     .57397,     .57543,     .57628,
     5      .57660                                                      
     * /   
          data ( PrSTLA(i,   38), i=  1,   21)/
     1      .50283,     .50759,     .51258,     .51768,     .52281,
     2      .52794,     .53303,     .53806,     .54299,     .54776,
     3      .55236,     .55672,     .56081,     .56455,     .56793,
     4      .57090,     .57339,     .57539,     .57682,     .57774,
     5      .57801                                                      
     * /   
          data ( PrSTLA(i,   39), i=  1,   21)/
     1      .50325,     .50812,     .51318,     .51833,     .52353,
     2      .52871,     .53387,     .53894,     .54391,     .54871,
     3      .55336,     .55776,     .56187,     .56565,     .56908,
     4      .57204,     .57457,     .57658,     .57804,     .57889,
     5      .57923                                                      
     * /   
          data ( PrSTLA(i,   40), i=  1,   21)/
     1      .50360,     .50855,     .51369,     .51891,     .52414,
     2      .52938,     .53457,     .53969,     .54468,     .54955,
     3      .55420,     .55863,     .56277,     .56658,     .57003,
     4      .57302,     .57555,     .57756,     .57902,     .57986,
     5      .58026                                                      
     * /   
          data ( PrSTLA(i,   41), i=  1,   21)/
     1      .50390,     .50895,     .51415,     .51940,     .52467,
     2      .52995,     .53518,     .54032,     .54536,     .55023,
     3      .55492,     .55937,     .56354,     .56739,     .57084,
     4      .57387,     .57640,     .57843,     .57991,     .58084,
     5      .58114                                                      
     * /   
          data ( PrSTLA(i,   42), i=  1,   21)/
     1      .50416,     .50928,     .51453,     .51982,     .52514,
     2      .53043,     .53569,     .54087,     .54593,     .55082,
     3      .55553,     .56002,     .56419,     .56807,     .57152,
     4      .57458,     .57713,     .57919,     .58065,     .58149,
     5      .58188                                                      
     * /   
          data ( PrSTLA(i,   43), i=  1,   21)/
     1      .50439,     .50957,     .51486,     .52018,     .52553,
     2      .53084,     .53613,     .54132,     .54639,     .55132,
     3      .55605,     .56054,     .56476,     .56862,     .57211,
     4      .57517,     .57774,     .57978,     .58129,     .58214,
     5      .58251                                                      
     * /   
          data ( PrSTLA(i,   44), i=  1,   21)/
     1      .50459,     .50981,     .51513,     .52049,     .52586,
     2      .53121,     .53651,     .54170,     .54679,     .55174,
     3      .55651,     .56100,     .56523,     .56911,     .57260,
     4      .57565,     .57827,     .58032,     .58178,     .58279,
     5      .58304                                                      
     * /   
          data ( PrSTLA(i,   45), i=  1,   21)/
     1      .50477,     .51004,     .51537,     .52076,     .52614,
     2      .53149,     .53681,     .54202,     .54715,     .55209,
     3      .55687,     .56137,     .56561,     .56950,     .57301,
     4      .57608,     .57867,     .58076,     .58227,     .58311,
     5      .58348                                                      
     * /   
          data ( PrSTLA(i,   46), i=  1,   21)/
     1      .50490,     .51021,     .51558,     .52097,     .52637,
     2      .53175,     .53706,     .54230,     .54744,     .55239,
     3      .55716,     .56170,     .56594,     .56985,     .57336,
     4      .57643,     .57904,     .58108,     .58259,     .58344,
     5      .58385                                                      
     * /   
          data ( PrSTLA(i,   47), i=  1,   21)/
     1      .50503,     .51036,     .51575,     .52116,     .52657,
     2      .53195,     .53730,     .54255,     .54766,     .55265,
     3      .55742,     .56197,     .56622,     .57013,     .57365,
     4      .57672,     .57932,     .58140,     .58292,     .58376,
     5      .58416                                                      
     * /   
          data ( PrSTLA(i,   48), i=  1,   21)/
     1      .50513,     .51048,     .51589,     .52131,     .52673,
     2      .53212,     .53748,     .54272,     .54788,     .55286,
     3      .55765,     .56219,     .56644,     .57036,     .57390,
     4      .57698,     .57957,     .58167,     .58316,     .58408,
     5      .58442                                                      
     * /   


c  Pair at Low E: Region B
          data ( PrSTLB(i,   1), i=  1,   21)/
     1      .53545,     .53545,     .53544,     .53542,     .53540,
     2      .53535,     .53529,     .53519,     .53509,     .53495,
     3      .53478,     .53458,     .53436,     .53410,     .53380,
     4      .53346,     .53309,     .53266,     .53220,     .53169,
     5      .53113                                                      
     * /   
          data ( PrSTLB(i,   2), i=  1,   21)/
     1      .53779,     .53779,     .53778,     .53776,     .53773,
     2      .53768,     .53762,     .53751,     .53740,     .53726,
     3      .53708,     .53687,     .53663,     .53635,     .53603,
     4      .53567,     .53527,     .53482,     .53433,     .53379,
     5      .53319                                                      
     * /   
          data ( PrSTLB(i,   3), i=  1,   21)/
     1      .54475,     .54474,     .54473,     .54471,     .54467,
     2      .54461,     .54453,     .54442,     .54428,     .54410,
     3      .54390,     .54365,     .54336,     .54303,     .54265,
     4      .54223,     .54176,     .54123,     .54064,     .54000,
     5      .53929                                                      
     * /   
          data ( PrSTLB(i,   4), i=  1,   21)/
     1      .55610,     .55610,     .55608,     .55605,     .55601,
     2      .55593,     .55583,     .55568,     .55551,     .55529,
     3      .55503,     .55472,     .55436,     .55395,     .55347,
     4      .55294,     .55234,     .55168,     .55095,     .55014,
     5      .54925                                                      
     * /   
          data ( PrSTLB(i,   5), i=  1,   21)/
     1      .57152,     .57151,     .57150,     .57146,     .57140,
     2      .57131,     .57117,     .57099,     .57077,     .57049,
     3      .57016,     .56976,     .56931,     .56877,     .56817,
     4      .56749,     .56673,     .56588,     .56494,     .56391,
     5      .56278                                                      
     * /   
          data ( PrSTLB(i,   6), i=  1,   21)/
     1      .59056,     .59056,     .59053,     .59049,     .59041,
     2      .59029,     .59012,     .58989,     .58960,     .58926,
     3      .58883,     .58833,     .58775,     .58708,     .58631,
     4      .58546,     .58449,     .58341,     .58223,     .58093,
     5      .57949                                                      
     * /   
          data ( PrSTLB(i,   7), i=  1,   21)/
     1      .61269,     .61268,     .61266,     .61260,     .61250,
     2      .61235,     .61214,     .61186,     .61150,     .61107,
     3      .61054,     .60991,     .60919,     .60835,     .60740,
     4      .60633,     .60513,     .60378,     .60231,     .60068,
     5      .59890                                                      
     * /   
          data ( PrSTLB(i,   8), i=  1,   21)/
     1      .63730,     .63730,     .63726,     .63720,     .63707,
     2      .63689,     .63663,     .63629,     .63586,     .63532,
     3      .63468,     .63392,     .63303,     .63201,     .63085,
     4      .62955,     .62808,     .62645,     .62464,     .62267,
     5      .62050                                                      
     * /   
          data ( PrSTLB(i,   9), i=  1,   21)/
     1      .66377,     .66376,     .66372,     .66364,     .66349,
     2      .66327,     .66296,     .66256,     .66204,     .66140,
     3      .66063,     .65972,     .65866,     .65745,     .65606,
     4      .65450,     .65275,     .65081,     .64866,     .64629,
     5      .64370                                                      
     * /   
          data ( PrSTLB(i,   10), i=  1,   21)/
     1      .69143,     .69143,     .69138,     .69129,     .69111,
     2      .69085,     .69049,     .69001,     .68942,     .68867,
     3      .68777,     .68671,     .68547,     .68404,     .68242,
     4      .68059,     .67854,     .67627,     .67375,     .67099,
     5      .66796                                                      
     * /   
          data ( PrSTLB(i,   11), i=  1,   21)/
     1      .71967,     .71966,     .71961,     .71950,     .71930,
     2      .71900,     .71859,     .71804,     .71734,     .71648,
     3      .71545,     .71423,     .71281,     .71117,     .70931,
     4      .70722,     .70486,     .70226,     .69936,     .69620,
     5      .69272                                                      
     * /   
          data ( PrSTLB(i,   12), i=  1,   21)/
     1      .74788,     .74787,     .74781,     .74769,     .74747,
     2      .74713,     .74666,     .74604,     .74526,     .74429,
     3      .74312,     .74174,     .74014,     .73829,     .73619,
     4      .73382,     .73116,     .72822,     .72496,     .72138,
     5      .71747                                                      
     * /   
          data ( PrSTLB(i,   13), i=  1,   21)/
     1      .77553,     .77552,     .77546,     .77532,     .77507,
     2      .77469,     .77417,     .77348,     .77261,     .77153,
     3      .77024,     .76870,     .76692,     .76486,     .76253,
     4      .75989,     .75695,     .75368,     .75006,     .74609,
     5      .74175                                                      
     * /   
          data ( PrSTLB(i,   14), i=  1,   21)/
     1      .80216,     .80214,     .80208,     .80192,     .80165,
     2      .80124,     .80067,     .79991,     .79895,     .79777,
     3      .79634,     .79467,     .79271,     .79046,     .78790,
     4      .78502,     .78179,     .77821,     .77425,     .76991,
     5      .76516                                                      
     * /   
          data ( PrSTLB(i,   15), i=  1,   21)/
     1      .82738,     .82736,     .82729,     .82712,     .82683,
     2      .82638,     .82577,     .82495,     .82391,     .82263,
     3      .82108,     .81926,     .81714,     .81471,     .81194,
     4      .80882,     .80533,     .80147,     .79719,     .79251,
     5      .78738                                                      
     * /   
          data ( PrSTLB(i,   16), i=  1,   21)/
     1      .85090,     .85088,     .85081,     .85063,     .85032,
     2      .84983,     .84917,     .84829,     .84718,     .84581,
     3      .84416,     .84221,     .83994,     .83734,     .83438,
     4      .83105,     .82732,     .82320,     .81864,     .81364,
     5      .80817                                                      
     * /   
          data ( PrSTLB(i,   17), i=  1,   21)/
     1      .87251,     .87249,     .87241,     .87222,     .87189,
     2      .87138,     .87067,     .86974,     .86856,     .86710,
     3      .86535,     .86329,     .86090,     .85814,     .85502,
     4      .85149,     .84757,     .84322,     .83841,     .83314,
     5      .82738                                                      
     * /   
          data ( PrSTLB(i,   18), i=  1,   21)/
     1      .89208,     .89206,     .89198,     .89178,     .89143,
     2      .89089,     .89015,     .88918,     .88794,     .88640,
     3      .88457,     .88241,     .87990,     .87702,     .87374,
     4      .87007,     .86597,     .86143,     .85642,     .85091,
     5      .84492                                                      
     * /   
          data ( PrSTLB(i,   19), i=  1,   21)/
     1      .90957,     .90955,     .90946,     .90925,     .90889,
     2      .90834,     .90756,     .90654,     .90525,     .90366,
     3      .90176,     .89951,     .89691,     .89393,     .89054,
     4      .88674,     .88250,     .87780,     .87263,     .86695,
     5      .86077                                                      
     * /   
          data ( PrSTLB(i,   20), i=  1,   21)/
     1      .92498,     .92496,     .92487,     .92465,     .92428,
     2      .92371,     .92291,     .92185,     .92053,     .91889,
     3      .91694,     .91463,     .91194,     .90888,     .90542,
     4      .90151,     .89718,     .89237,     .88709,     .88130,
     5      .87497                                                      
     * /   
          data ( PrSTLB(i,   21), i=  1,   21)/
     1      .93840,     .93839,     .93838,     .93831,     .93813,
     2      .93776,     .93712,     .93615,     .93482,     .93309,
     3      .93096,     .92846,     .92556,     .92225,     .91856,
     4      .91445,     .90992,     .90494,     .89950,     .89357,
     5      .88712                                                      
     * /   
          data ( PrSTLB(i,   22), i=  1,   21)/
     1      .94992,     .94991,     .94990,     .94983,     .94964,
     2      .94925,     .94859,     .94759,     .94623,     .94450,
     3      .94237,     .93989,     .93701,     .93375,     .93008,
     4      .92602,     .92153,     .91660,     .91119,     .90529,
     5      .89886                                                      
     * /   
          data ( PrSTLB(i,   23), i=  1,   21)/
     1      .95970,     .95969,     .95967,     .95960,     .95939,
     2      .95899,     .95830,     .95728,     .95590,     .95416,
     3      .95207,     .94960,     .94677,     .94357,     .93998,
     4      .93598,     .93155,     .92668,     .92133,     .91548,
     5      .90910                                                      
     * /   
          data ( PrSTLB(i,   24), i=  1,   21)/
     1      .96789,     .96788,     .96787,     .96778,     .96757,
     2      .96714,     .96643,     .96538,     .96401,     .96229,
     3      .96021,     .95780,     .95503,     .95190,     .94839,
     4      .94448,     .94014,     .93536,     .93010,     .92433,
     5      .91801                                                      
     * /   
          data ( PrSTLB(i,   25), i=  1,   21)/
     1      .97468,     .97467,     .97465,     .97457,     .97433,
     2      .97389,     .97315,     .97210,     .97073,     .96903,
     3      .96702,     .96467,     .96199,     .95895,     .95553,
     4      .95172,     .94749,     .94281,     .93766,     .93199,
     5      .92576                                                      
     * /   
          data ( PrSTLB(i,   26), i=  1,   21)/
     1      .98023,     .98022,     .98021,     .98010,     .97987,
     2      .97940,     .97865,     .97760,     .97626,     .97461,
     3      .97266,     .97040,     .96781,     .96488,     .96158,
     4      .95789,     .95377,     .94921,     .94417,     .93861,
     5      .93250                                                      
     * /   
          data ( PrSTLB(i,   27), i=  1,   21)/
     1      .98472,     .98471,     .98470,     .98459,     .98433,
     2      .98385,     .98310,     .98208,     .98076,     .97918,
     3      .97731,     .97514,     .97267,     .96984,     .96666,
     4      .96310,     .95910,     .95468,     .94977,     .94434,
     5      .93835                                                      
     * /   
          data ( PrSTLB(i,   28), i=  1,   21)/
     1      .98831,     .98830,     .98828,     .98817,     .98790,
     2      .98741,     .98666,     .98568,     .98442,     .98290,
     3      .98113,     .97906,     .97669,     .97399,     .97094,
     4      .96751,     .96367,     .95936,     .95459,     .94930,
     5      .94343                                                      
     * /   
          data ( PrSTLB(i,   29), i=  1,   21)/
     1      .99114,     .99114,     .99112,     .99100,     .99072,
     2      .99022,     .98950,     .98856,     .98737,     .98593,
     3      .98426,     .98231,     .98004,     .97747,     .97454,
     4      .97125,     .96754,     .96339,     .95876,     .95360,
     5      .94788                                                      
     * /   
          data ( PrSTLB(i,   30), i=  1,   21)/
     1      .99336,     .99335,     .99332,     .99320,     .99293,
     2      .99243,     .99176,     .99085,     .98974,     .98840,
     3      .98682,     .98496,     .98284,     .98039,     .97760,
     4      .97444,     .97087,     .96687,     .96238,     .95738,
     5      .95180                                                      
     * /   
          data ( PrSTLB(i,   31), i=  1,   21)/
     1      .99507,     .99506,     .99503,     .99491,     .99462,
     2      .99416,     .99351,     .99268,     .99163,     .99039,
     3      .98891,     .98718,     .98517,     .98284,     .98020,
     4      .97717,     .97376,     .96989,     .96557,     .96071,
     5      .95530                                                      
     * /   
          data ( PrSTLB(i,   32), i=  1,   21)/
     1      .99638,     .99637,     .99634,     .99622,     .99593,
     2      .99549,     .99490,     .99411,     .99316,     .99201,
     3      .99063,     .98901,     .98711,     .98492,     .98240,
     4      .97954,     .97627,     .97256,     .96839,     .96369,
     5      .95844                                                      
     * /   
          data ( PrSTLB(i,   33), i=  1,   21)/
     1      .99736,     .99736,     .99733,     .99721,     .99693,
     2      .99652,     .99598,     .99526,     .99438,     .99332,
     3      .99204,     .99053,     .98875,     .98669,     .98432,
     4      .98159,     .97846,     .97492,     .97090,     .96638,
     5      .96129                                                      
     * /   
          data ( PrSTLB(i,   34), i=  1,   21)/
     1      .99810,     .99809,     .99806,     .99794,     .99768,
     2      .99732,     .99682,     .99616,     .99536,     .99439,
     3      .99320,     .99180,     .99014,     .98820,     .98596,
     4      .98336,     .98040,     .97701,     .97317,     .96882,
     5      .96391                                                      
     * /   
          data ( PrSTLB(i,   35), i=  1,   21)/
     1      .99865,     .99864,     .99861,     .99849,     .99826,
     2      .99792,     .99747,     .99689,     .99616,     .99526,
     3      .99417,     .99286,     .99132,     .98951,     .98739,
     4      .98494,     .98211,     .97889,     .97520,     .97103,
     5      .96630                                                      
     * /   
          data ( PrSTLB(i,   36), i=  1,   21)/
     1      .99905,     .99904,     .99901,     .99889,     .99869,
     2      .99838,     .99797,     .99745,     .99678,     .99596,
     3      .99497,     .99377,     .99232,     .99063,     .98864,
     4      .98632,     .98364,     .98056,     .97705,     .97304,
     5      .96849                                                      
     * /   
          data ( PrSTLB(i,   37), i=  1,   21)/
     1      .99933,     .99933,     .99929,     .99919,     .99901,
     2      .99873,     .99838,     .99791,     .99730,     .99655,
     3      .99564,     .99453,     .99318,     .99158,     .98973,
     4      .98753,     .98500,     .98208,     .97871,     .97485,
     5      .97046                                                      
     * /   
          data ( PrSTLB(i,   38), i=  1,   21)/
     1      .99954,     .99953,     .99950,     .99941,     .99924,
     2      .99901,     .99869,     .99827,     .99772,     .99703,
     3      .99619,     .99516,     .99391,     .99243,     .99067,
     4      .98860,     .98619,     .98340,     .98017,     .97647,
     5      .97223                                                      
     * /   
          data ( PrSTLB(i,   39), i=  1,   21)/
     1      .99968,     .99968,     .99965,     .99957,     .99942,
     2      .99922,     .99893,     .99855,     .99806,     .99743,
     3      .99666,     .99570,     .99454,     .99315,     .99149,
     4      .98954,     .98725,     .98458,     .98147,     .97789,
     5      .97377                                                      
     * /   
          data ( PrSTLB(i,   40), i=  1,   21)/
     1      .99979,     .99978,     .99975,     .99967,     .99955,
     2      .99937,     .99912,     .99877,     .99833,     .99776,
     3      .99705,     .99616,     .99508,     .99377,     .99221,
     4      .99035,     .98816,     .98559,     .98259,     .97911,
     5      .97510                                                      
     * /   
          data ( PrSTLB(i,   41), i=  1,   21)/
     1      .99986,     .99985,     .99982,     .99976,     .99965,
     2      .99950,     .99927,     .99896,     .99855,     .99803,
     3      .99738,     .99655,     .99553,     .99431,     .99282,
     4      .99105,     .98894,     .98646,     .98354,     .98016,
     5      .97622                                                      
     * /   
          data ( PrSTLB(i,   42), i=  1,   21)/
     1      .99990,     .99990,     .99988,     .99982,     .99973,
     2      .99959,     .99938,     .99910,     .99874,     .99826,
     3      .99765,     .99688,     .99593,     .99476,     .99334,
     4      .99163,     .98960,     .98719,     .98434,     .98101,
     5      .97715                                                      
     * /   
          data ( PrSTLB(i,   43), i=  1,   21)/
     1      .99994,     .99993,     .99991,     .99987,     .99978,
     2      .99965,     .99949,     .99923,     .99889,     .99845,
     3      .99789,     .99715,     .99625,     .99514,     .99378,
     4      .99212,     .99015,     .98779,     .98499,     .98173,
     5      .97791                                                      
     * /   
          data ( PrSTLB(i,   44), i=  1,   21)/
     1      .99996,     .99995,     .99994,     .99989,     .99983,
     2      .99972,     .99955,     .99933,     .99902,     .99861,
     3      .99807,     .99739,     .99653,     .99545,     .99414,
     4      .99252,     .99058,     .98828,     .98553,     .98230,
     5      .97851                                                      
     * /   
          data ( PrSTLB(i,   45), i=  1,   21)/
     1      .99997,     .99997,     .99995,     .99992,     .99986,
     2      .99977,     .99962,     .99940,     .99913,     .99875,
     3      .99823,     .99759,     .99675,     .99571,     .99443,
     4      .99286,     .99095,     .98866,     .98594,     .98276,
     5      .97900                                                      
     * /   
          data ( PrSTLB(i,   46), i=  1,   21)/
     1      .99998,     .99998,     .99996,     .99993,     .99988,
     2      .99979,     .99967,     .99947,     .99921,     .99885,
     3      .99836,     .99773,     .99692,     .99592,     .99465,
     4      .99311,     .99123,     .98897,     .98627,     .98310,
     5      .97938                                                      
     * /   
          data ( PrSTLB(i,   47), i=  1,   21)/
     1      .99999,     .99998,     .99998,     .99995,     .99991,
     2      .99983,     .99971,     .99952,     .99928,     .99893,
     3      .99847,     .99786,     .99707,     .99608,     .99484,
     4      .99330,     .99144,     .98921,     .98654,     .98338,
     5      .97967                                                      
     * /   
          data ( PrSTLB(i,   48), i=  1,   21)/
     1      .99999,     .99999,     .99999,     .99996,     .99992,
     2      .99985,     .99974,     .99957,     .99933,     .99899,
     3      .99855,     .99796,     .99718,     .99620,     .99498,
     4      .99346,     .99161,     .98938,     .98673,     .98358,
     5      .97987                                                      
     * /   


      end
     

